#ifndef _RTK_EX_GPHY_H_
#define _RTK_EX_GPHY_H_

#define BOOLEAN		bool
#define SUCCESS		TRUE
#define FAILURE		FALSE

typedef enum {
	EXT_PHY_SPEED_10	= 0,	/* 10M bps */
	EXT_PHY_SPEED_100	= 1,	/* 100M bps */
	EXT_PHY_SPEED_500	= 2,	/* 500M bps */
	EXT_PHY_SPEED_1000	= 3,	/* 1G bps */
	EXT_PHY_SPEED_10000	= 4,	/* 10G bps */
	EXT_PHY_SPEED_10000LITE	= 5,	/* 10G Lite bps */
	EXT_PHY_SPEED_2000	= 6,	/* 2G bps */
	EXT_PHY_SPEED_2500	= 7,	/* 2.5G bps */
	EXT_PHY_SPEED_2500LITE	= 8,	/* 2.5G Lite bps */
	EXT_PHY_SPEED_5000	= 9,	/* 5G bps */
	EXT_PHY_SPEED_5000LITE	= 10,	/* 5G Lite bps */
	EXT_PHY_SPEED_MAX
} ext_phy_speed_mode_t;

typedef enum {
	EXT_PHY_DUPLEX_HALF      = 0,
	EXT_PHY_DUPLEX_FULL      = 1,
	EXT_PHY_DUPLEX_INVALID   = 0xFF,
} ext_phy_duplex_t;

typedef struct {
	bool			link_up;
	bool			duplex;
	ext_phy_speed_mode_t	speed;
} ext_phy_link_status_t;

#endif

