#include <linux/sched.h>		/* For schedule_timeout and HZ */

#include <common/rt_type.h>
#include <common/debug/rt_log.h>
#include <osal/time.h>
//#include <osal/phy_osal.h>
#include "nic_rtl8226.h"

static const MMD_REG Rtl8226b_a_n0_ramcode[] =
{
    { 31, 0xA436, 0xA016, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA436, 0xA012, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA436, 0xA014, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8010, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8025, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x803a, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8044, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8083, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x808d, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x808d, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x808d, },
    { 31, 0xA438, 0xd712, },
    { 31, 0xA438, 0x4077, },
    { 31, 0xA438, 0xd71e, },
    { 31, 0xA438, 0x4159, },
    { 31, 0xA438, 0xd71e, },
    { 31, 0xA438, 0x6099, },
    { 31, 0xA438, 0x7f44, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1a14, },
    { 31, 0xA438, 0x9040, },
    { 31, 0xA438, 0x9201, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1b1a, },
    { 31, 0xA438, 0xd71e, },
    { 31, 0xA438, 0x2425, },
    { 31, 0xA438, 0x1a14, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x3ce5, },
    { 31, 0xA438, 0x1afb, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1b00, },
    { 31, 0xA438, 0xd712, },
    { 31, 0xA438, 0x4077, },
    { 31, 0xA438, 0xd71e, },
    { 31, 0xA438, 0x4159, },
    { 31, 0xA438, 0xd71e, },
    { 31, 0xA438, 0x60b9, },
    { 31, 0xA438, 0x2421, },
    { 31, 0xA438, 0x1c17, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1a14, },
    { 31, 0xA438, 0x9040, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1c2c, },
    { 31, 0xA438, 0xd71e, },
    { 31, 0xA438, 0x2425, },
    { 31, 0xA438, 0x1a14, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x3ce5, },
    { 31, 0xA438, 0x1c0f, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1c13, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0xd501, },
    { 31, 0xA438, 0x6072, },
    { 31, 0xA438, 0x8401, },
    { 31, 0xA438, 0xf002, },
    { 31, 0xA438, 0xa401, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x146e, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0b77, },
    { 31, 0xA438, 0xd703, },
    { 31, 0xA438, 0x665d, },
    { 31, 0xA438, 0x653e, },
    { 31, 0xA438, 0x641f, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x62c4, },
    { 31, 0xA438, 0x6185, },
    { 31, 0xA438, 0x6066, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x165a, },
    { 31, 0xA438, 0xc101, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1945, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x7fa6, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x807d, },
    { 31, 0xA438, 0xc102, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1945, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x2569, },
    { 31, 0xA438, 0x8058, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x807d, },
    { 31, 0xA438, 0xc104, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1945, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x7fa4, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x807d, },
    { 31, 0xA438, 0xc120, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1945, },
    { 31, 0xA438, 0xd703, },
    { 31, 0xA438, 0x7fbf, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x807d, },
    { 31, 0xA438, 0xc140, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1945, },
    { 31, 0xA438, 0xd703, },
    { 31, 0xA438, 0x7fbe, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x807d, },
    { 31, 0xA438, 0xc180, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1945, },
    { 31, 0xA438, 0xd703, },
    { 31, 0xA438, 0x7fbd, },
    { 31, 0xA438, 0xc100, },
    { 31, 0xA438, 0xcb00, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x6018, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x165a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x14f6, },
    { 31, 0xA438, 0xd014, },
    { 31, 0xA438, 0xd1e3, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x1356, },
    { 31, 0xA438, 0xd705, },
    { 31, 0xA438, 0x5fbe, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x1559, },
    { 31, 0xA436, 0xA026, },
    { 31, 0xA438, 0xffff, },
    { 31, 0xA436, 0xA024, },
    { 31, 0xA438, 0xffff, },
    { 31, 0xA436, 0xA022, },
    { 31, 0xA438, 0xffff, },
    { 31, 0xA436, 0xA020, },
    { 31, 0xA438, 0x1557, },
    { 31, 0xA436, 0xA006, },
    { 31, 0xA438, 0x1677, },
    { 31, 0xA436, 0xA004, },
    { 31, 0xA438, 0x0b75, },
    { 31, 0xA436, 0xA002, },
    { 31, 0xA438, 0x1c17, },
    { 31, 0xA436, 0xA000, },
    { 31, 0xA438, 0x1b04, },
    { 31, 0xA436, 0xA008, },
    { 31, 0xA438, 0x1f00, },
};

static const MMD_REG Rtl8226b_b_n0_ramcode[] =
{
};

static const MMD_REG Rtl8226b_a_n1_ramcode[] =
{
};

static const MMD_REG Rtl8226b_b_n1_ramcode[] =
{
};

static const MMD_REG Rtl8226b_a_n2_ramcode[] =
{
    { 31, 0xA436, 0xA016, },
    { 31, 0xA438, 0x0020, },
    { 31, 0xA436, 0xA012, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA436, 0xA014, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8010, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x817f, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x82ab, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x83f8, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8444, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8454, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8459, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8465, },
    { 31, 0xA438, 0xcb11, },
    { 31, 0xA438, 0xa50c, },
    { 31, 0xA438, 0x8310, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x4076, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x0903, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d00, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a4d, },
    { 31, 0xA438, 0xcb12, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f84, },
    { 31, 0xA438, 0xd102, },
    { 31, 0xA438, 0xd040, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x60f3, },
    { 31, 0xA438, 0xd413, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xd410, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xcb13, },
    { 31, 0xA438, 0xa108, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8108, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xa910, },
    { 31, 0xA438, 0xa780, },
    { 31, 0xA438, 0xd14a, },
    { 31, 0xA438, 0xd048, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x6255, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5f74, },
    { 31, 0xA438, 0x6326, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f07, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x0902, },
    { 31, 0xA438, 0xffe2, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fab, },
    { 31, 0xA438, 0xba08, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8b, },
    { 31, 0xA438, 0x9a08, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x6535, },
    { 31, 0xA438, 0xd40d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xcb14, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xa780, },
    { 31, 0xA438, 0xd14a, },
    { 31, 0xA438, 0xd048, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0x6206, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f47, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x0902, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x8064, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xd40e, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x6073, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x4216, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0xd120, },
    { 31, 0xA438, 0xd040, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0x8504, },
    { 31, 0xA438, 0xcb21, },
    { 31, 0xA438, 0xa301, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5f9f, },
    { 31, 0xA438, 0x8301, },
    { 31, 0xA438, 0xd704, },
    { 31, 0xA438, 0x40e0, },
    { 31, 0xA438, 0xd196, },
    { 31, 0xA438, 0xd04d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xcb22, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a6d, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x1502, },
    { 31, 0xA438, 0xa640, },
    { 31, 0xA438, 0x9503, },
    { 31, 0xA438, 0x8910, },
    { 31, 0xA438, 0x8720, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d01, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d01, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0f14, },
    { 31, 0xA438, 0xcb23, },
    { 31, 0xA438, 0x8fc0, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0xaf40, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0x0cc0, },
    { 31, 0xA438, 0x0f80, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0xafc0, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x5dee, },
    { 31, 0xA438, 0xcb24, },
    { 31, 0xA438, 0x8f1f, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x7f6e, },
    { 31, 0xA438, 0xa111, },
    { 31, 0xA438, 0xa215, },
    { 31, 0xA438, 0xa401, },
    { 31, 0xA438, 0x8404, },
    { 31, 0xA438, 0xa720, },
    { 31, 0xA438, 0xcb25, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x1502, },
    { 31, 0xA438, 0x8640, },
    { 31, 0xA438, 0x9503, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0b43, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0b86, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0xcb26, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f82, },
    { 31, 0xA438, 0x8111, },
    { 31, 0xA438, 0x8205, },
    { 31, 0xA438, 0x8404, },
    { 31, 0xA438, 0xcb27, },
    { 31, 0xA438, 0xd404, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0xa710, },
    { 31, 0xA438, 0xa104, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8104, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0xa120, },
    { 31, 0xA438, 0xaa0f, },
    { 31, 0xA438, 0x8110, },
    { 31, 0xA438, 0xa284, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xd193, },
    { 31, 0xA438, 0xd046, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xcb28, },
    { 31, 0xA438, 0xa110, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa8, },
    { 31, 0xA438, 0x8110, },
    { 31, 0xA438, 0x8284, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0x8710, },
    { 31, 0xA438, 0xb804, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f82, },
    { 31, 0xA438, 0x9804, },
    { 31, 0xA438, 0xcb29, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f85, },
    { 31, 0xA438, 0xa710, },
    { 31, 0xA438, 0xb820, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f65, },
    { 31, 0xA438, 0x9820, },
    { 31, 0xA438, 0xcb2a, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa284, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xd13d, },
    { 31, 0xA438, 0xd04a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x3444, },
    { 31, 0xA438, 0x8149, },
    { 31, 0xA438, 0xa220, },
    { 31, 0xA438, 0xd1a0, },
    { 31, 0xA438, 0xd040, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x3444, },
    { 31, 0xA438, 0x8151, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f51, },
    { 31, 0xA438, 0xcb2f, },
    { 31, 0xA438, 0xa302, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5f63, },
    { 31, 0xA438, 0xd411, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0x8302, },
    { 31, 0xA438, 0xd409, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fa3, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x82a4, },
    { 31, 0xA438, 0x8404, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xb808, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7fa3, },
    { 31, 0xA438, 0x9808, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0433, },
    { 31, 0xA438, 0xcb15, },
    { 31, 0xA438, 0xa508, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d01, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d01, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a4d, },
    { 31, 0xA438, 0xa301, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5f9f, },
    { 31, 0xA438, 0x8301, },
    { 31, 0xA438, 0xd704, },
    { 31, 0xA438, 0x40e0, },
    { 31, 0xA438, 0xd115, },
    { 31, 0xA438, 0xd04f, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xd413, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xcb16, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a6d, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x1502, },
    { 31, 0xA438, 0xa640, },
    { 31, 0xA438, 0x9503, },
    { 31, 0xA438, 0x8720, },
    { 31, 0xA438, 0xd17a, },
    { 31, 0xA438, 0xd04c, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0f14, },
    { 31, 0xA438, 0xcb17, },
    { 31, 0xA438, 0x8fc0, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0xaf40, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0x0cc0, },
    { 31, 0xA438, 0x0f80, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0xafc0, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a25, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x61ce, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5db4, },
    { 31, 0xA438, 0xcb18, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x1502, },
    { 31, 0xA438, 0x8640, },
    { 31, 0xA438, 0x9503, },
    { 31, 0xA438, 0xa720, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0b43, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xffd6, },
    { 31, 0xA438, 0x8f1f, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x7f8e, },
    { 31, 0xA438, 0xa131, },
    { 31, 0xA438, 0xaa0f, },
    { 31, 0xA438, 0xa2d5, },
    { 31, 0xA438, 0xa407, },
    { 31, 0xA438, 0xa720, },
    { 31, 0xA438, 0x8310, },
    { 31, 0xA438, 0xa308, },
    { 31, 0xA438, 0x8308, },
    { 31, 0xA438, 0xcb19, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x1502, },
    { 31, 0xA438, 0x8640, },
    { 31, 0xA438, 0x9503, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0b43, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0b86, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0xcb1a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f82, },
    { 31, 0xA438, 0x8111, },
    { 31, 0xA438, 0x82c5, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x8402, },
    { 31, 0xA438, 0xb804, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f82, },
    { 31, 0xA438, 0x9804, },
    { 31, 0xA438, 0xcb1b, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f85, },
    { 31, 0xA438, 0xa710, },
    { 31, 0xA438, 0xb820, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f65, },
    { 31, 0xA438, 0x9820, },
    { 31, 0xA438, 0xcb1c, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0xa110, },
    { 31, 0xA438, 0xa284, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x8402, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa8, },
    { 31, 0xA438, 0xcb1d, },
    { 31, 0xA438, 0xa180, },
    { 31, 0xA438, 0xa402, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa8, },
    { 31, 0xA438, 0xa220, },
    { 31, 0xA438, 0xd1f5, },
    { 31, 0xA438, 0xd049, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x3444, },
    { 31, 0xA438, 0x8221, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f51, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fa3, },
    { 31, 0xA438, 0xa504, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d00, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x82a4, },
    { 31, 0xA438, 0x8402, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xb808, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7fa3, },
    { 31, 0xA438, 0x9808, },
    { 31, 0xA438, 0xcb2b, },
    { 31, 0xA438, 0xcb2c, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f84, },
    { 31, 0xA438, 0xd14a, },
    { 31, 0xA438, 0xd048, },
    { 31, 0xA438, 0xa780, },
    { 31, 0xA438, 0xcb2d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5f94, },
    { 31, 0xA438, 0x6208, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f27, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x0902, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xffe9, },
    { 31, 0xA438, 0xcb2e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa284, },
    { 31, 0xA438, 0xa406, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa8, },
    { 31, 0xA438, 0xa220, },
    { 31, 0xA438, 0xd1a0, },
    { 31, 0xA438, 0xd040, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x3444, },
    { 31, 0xA438, 0x827d, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f51, },
    { 31, 0xA438, 0xcb2f, },
    { 31, 0xA438, 0xa302, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5f63, },
    { 31, 0xA438, 0xd411, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0x8302, },
    { 31, 0xA438, 0xd409, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fa3, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x82a4, },
    { 31, 0xA438, 0x8406, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xb808, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7fa3, },
    { 31, 0xA438, 0x9808, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0433, },
    { 31, 0xA438, 0xcb30, },
    { 31, 0xA438, 0x8380, },
    { 31, 0xA438, 0xcb31, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f86, },
    { 31, 0xA438, 0x9308, },
    { 31, 0xA438, 0xb204, },
    { 31, 0xA438, 0xb301, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x5fa2, },
    { 31, 0xA438, 0xb302, },
    { 31, 0xA438, 0x9204, },
    { 31, 0xA438, 0xcb32, },
    { 31, 0xA438, 0xd408, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xd141, },
    { 31, 0xA438, 0xd043, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xd704, },
    { 31, 0xA438, 0x4ccc, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x4c81, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x609e, },
    { 31, 0xA438, 0xd1e5, },
    { 31, 0xA438, 0xd04d, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0xd1e5, },
    { 31, 0xA438, 0xd04d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d01, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d01, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0x8710, },
    { 31, 0xA438, 0xa108, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8108, },
    { 31, 0xA438, 0xa203, },
    { 31, 0xA438, 0x8120, },
    { 31, 0xA438, 0x8a0f, },
    { 31, 0xA438, 0xa111, },
    { 31, 0xA438, 0x8204, },
    { 31, 0xA438, 0xa140, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8140, },
    { 31, 0xA438, 0xd17a, },
    { 31, 0xA438, 0xd04b, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xa204, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa7, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0xd404, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0xa710, },
    { 31, 0xA438, 0x8101, },
    { 31, 0xA438, 0x8201, },
    { 31, 0xA438, 0xa104, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8104, },
    { 31, 0xA438, 0xa120, },
    { 31, 0xA438, 0xaa0f, },
    { 31, 0xA438, 0x8110, },
    { 31, 0xA438, 0xa284, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xd193, },
    { 31, 0xA438, 0xd047, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xa110, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa8, },
    { 31, 0xA438, 0xa180, },
    { 31, 0xA438, 0xd13d, },
    { 31, 0xA438, 0xd04a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xf024, },
    { 31, 0xA438, 0xa710, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x8204, },
    { 31, 0xA438, 0xa280, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa7, },
    { 31, 0xA438, 0x8710, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x8284, },
    { 31, 0xA438, 0x8406, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x4121, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x60f3, },
    { 31, 0xA438, 0xd1e5, },
    { 31, 0xA438, 0xd04d, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0x8710, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x8204, },
    { 31, 0xA438, 0xa280, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xb920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5fac, },
    { 31, 0xA438, 0x9920, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f8c, },
    { 31, 0xA438, 0xcb33, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x5f85, },
    { 31, 0xA438, 0xa710, },
    { 31, 0xA438, 0xb820, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd71f, },
    { 31, 0xA438, 0x7f65, },
    { 31, 0xA438, 0x9820, },
    { 31, 0xA438, 0xcb34, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa284, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa9, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x6853, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d00, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d00, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0x8190, },
    { 31, 0xA438, 0x8284, },
    { 31, 0xA438, 0xcb35, },
    { 31, 0xA438, 0xd407, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0x8110, },
    { 31, 0xA438, 0x8204, },
    { 31, 0xA438, 0xa280, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xd704, },
    { 31, 0xA438, 0x4215, },
    { 31, 0xA438, 0xa304, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb8, },
    { 31, 0xA438, 0xd1c3, },
    { 31, 0xA438, 0xd043, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0x8304, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x4109, },
    { 31, 0xA438, 0xf01e, },
    { 31, 0xA438, 0xcb36, },
    { 31, 0xA438, 0xd412, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6309, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x42c7, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0x8180, },
    { 31, 0xA438, 0x8280, },
    { 31, 0xA438, 0x8404, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a42, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0x0c03, },
    { 31, 0xA438, 0x0902, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xd14a, },
    { 31, 0xA438, 0xd048, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6083, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a7d, },
    { 31, 0xA438, 0xcc55, },
    { 31, 0xA438, 0xcb37, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa2a4, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6041, },
    { 31, 0xA438, 0xa402, },
    { 31, 0xA438, 0xd13d, },
    { 31, 0xA438, 0xd04a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fa9, },
    { 31, 0xA438, 0xd702, },
    { 31, 0xA438, 0x5f71, },
    { 31, 0xA438, 0xcb38, },
    { 31, 0xA438, 0x8224, },
    { 31, 0xA438, 0xa288, },
    { 31, 0xA438, 0x8180, },
    { 31, 0xA438, 0xa110, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x800a, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6041, },
    { 31, 0xA438, 0x8402, },
    { 31, 0xA438, 0xd415, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a37, },
    { 31, 0xA438, 0xd13d, },
    { 31, 0xA438, 0xd04a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0xcb39, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa2a0, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x6041, },
    { 31, 0xA438, 0xa402, },
    { 31, 0xA438, 0xd17a, },
    { 31, 0xA438, 0xd047, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5fb4, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0560, },
    { 31, 0xA438, 0xa111, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA438, 0x0000, },
    { 31, 0xA438, 0xd3f5, },
    { 31, 0xA438, 0xd219, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c31, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5fa5, },
    { 31, 0xA438, 0xa215, },
    { 31, 0xA438, 0xd30e, },
    { 31, 0xA438, 0xd21a, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c31, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x63e9, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5f65, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x7f36, },
    { 31, 0xA438, 0xa004, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c35, },
    { 31, 0xA438, 0x8004, },
    { 31, 0xA438, 0xa001, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c35, },
    { 31, 0xA438, 0x8001, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x4098, },
    { 31, 0xA438, 0xd102, },
    { 31, 0xA438, 0x9401, },
    { 31, 0xA438, 0xf003, },
    { 31, 0xA438, 0xd103, },
    { 31, 0xA438, 0xb401, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c27, },
    { 31, 0xA438, 0xa108, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c35, },
    { 31, 0xA438, 0x8108, },
    { 31, 0xA438, 0x8110, },
    { 31, 0xA438, 0x8294, },
    { 31, 0xA438, 0xa202, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0bdb, },
    { 31, 0xA438, 0xd39c, },
    { 31, 0xA438, 0xd210, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c31, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5fa5, },
    { 31, 0xA438, 0xd39c, },
    { 31, 0xA438, 0xd210, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c31, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5fa5, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c31, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x29b5, },
    { 31, 0xA438, 0x840e, },
    { 31, 0xA438, 0xd708, },
    { 31, 0xA438, 0x5f4a, },
    { 31, 0xA438, 0x0c1f, },
    { 31, 0xA438, 0x1014, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0c31, },
    { 31, 0xA438, 0xd709, },
    { 31, 0xA438, 0x7fa4, },
    { 31, 0xA438, 0x901f, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0c23, },
    { 31, 0xA438, 0xcb43, },
    { 31, 0xA438, 0xa508, },
    { 31, 0xA438, 0xd701, },
    { 31, 0xA438, 0x3699, },
    { 31, 0xA438, 0x844a, },
    { 31, 0xA438, 0xa504, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa2a0, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x2109, },
    { 31, 0xA438, 0x05ea, },
    { 31, 0xA438, 0xa402, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x05ea, },
    { 31, 0xA438, 0xcb90, },
    { 31, 0xA438, 0x0cf0, },
    { 31, 0xA438, 0x0ca0, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x06db, },
    { 31, 0xA438, 0xd1ff, },
    { 31, 0xA438, 0xd052, },
    { 31, 0xA438, 0xa508, },
    { 31, 0xA438, 0x8718, },
    { 31, 0xA438, 0xa00a, },
    { 31, 0xA438, 0xa190, },
    { 31, 0xA438, 0xa2a0, },
    { 31, 0xA438, 0xa404, },
    { 31, 0xA438, 0x0cf0, },
    { 31, 0xA438, 0x0c50, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x09ef, },
    { 31, 0xA438, 0x1000, },
    { 31, 0xA438, 0x0a5e, },
    { 31, 0xA438, 0xd704, },
    { 31, 0xA438, 0x2e70, },
    { 31, 0xA438, 0x06da, },
    { 31, 0xA438, 0xd700, },
    { 31, 0xA438, 0x5f55, },
    { 31, 0xA438, 0xa90c, },
    { 31, 0xA438, 0x1800, },
    { 31, 0xA438, 0x0645, },
    { 31, 0xA436, 0xA10E, },
    { 31, 0xA438, 0x0644, },
    { 31, 0xA436, 0xA10C, },
    { 31, 0xA438, 0x09e9, },
    { 31, 0xA436, 0xA10A, },
    { 31, 0xA438, 0x06da, },
    { 31, 0xA436, 0xA108, },
    { 31, 0xA438, 0x05e1, },
    { 31, 0xA436, 0xA106, },
    { 31, 0xA438, 0x0be4, },
    { 31, 0xA436, 0xA104, },
    { 31, 0xA438, 0x0435, },
    { 31, 0xA436, 0xA102, },
    { 31, 0xA438, 0x0141, },
    { 31, 0xA436, 0xA100, },
    { 31, 0xA438, 0x026d, },
    { 31, 0xA436, 0xA110, },
    { 31, 0xA438, 0x00ff, },
};

static const MMD_REG Rtl8226b_b_n2_ramcode[] =
{
};

static const MMD_REG Rtl8226b_a_uc2_ramcode[] =
{
   {31, 0xA436, 0xb87c, },
   {31, 0xA438, 0x85fe, },
   {31, 0xA436, 0xb87e, },
   {31, 0xA438, 0xaf86, },
   {31, 0xA438, 0x16af, },
   {31, 0xA438, 0x8699, },
   {31, 0xA438, 0xaf86, },
   {31, 0xA438, 0xe5af, },
   {31, 0xA438, 0x86f9, },
   {31, 0xA438, 0xaf87, },
   {31, 0xA438, 0x7aaf, },
   {31, 0xA438, 0x883a, },
   {31, 0xA438, 0xaf88, },
   {31, 0xA438, 0x58af, },
   {31, 0xA438, 0x8b6c, },
   {31, 0xA438, 0xd48b, },
   {31, 0xA438, 0x7c02, },
   {31, 0xA438, 0x8644, },
   {31, 0xA438, 0x2c00, },
   {31, 0xA438, 0x503c, },
   {31, 0xA438, 0xffd6, },
   {31, 0xA438, 0xac27, },
   {31, 0xA438, 0x18e1, },
   {31, 0xA438, 0x82fe, },
   {31, 0xA438, 0xad28, },
   {31, 0xA438, 0x0cd4, },
   {31, 0xA438, 0x8b84, },
   {31, 0xA438, 0x0286, },
   {31, 0xA438, 0x442c, },
   {31, 0xA438, 0x003c, },
   {31, 0xA438, 0xac27, },
   {31, 0xA438, 0x06ee, },
   {31, 0xA438, 0x8299, },
   {31, 0xA438, 0x01ae, },
   {31, 0xA438, 0x04ee, },
   {31, 0xA438, 0x8299, },
   {31, 0xA438, 0x00af, },
   {31, 0xA438, 0x23dc, },
   {31, 0xA438, 0xf9fa, },
   {31, 0xA438, 0xcefa, },
   {31, 0xA438, 0xfbef, },
   {31, 0xA438, 0x79fb, },
   {31, 0xA438, 0xc4bf, },
   {31, 0xA438, 0x8b76, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6dac, },
   {31, 0xA438, 0x2804, },
   {31, 0xA438, 0xd203, },
   {31, 0xA438, 0xae02, },
   {31, 0xA438, 0xd201, },
   {31, 0xA438, 0xbdd8, },
   {31, 0xA438, 0x19d9, },
   {31, 0xA438, 0xef94, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6d78, },
   {31, 0xA438, 0x03ef, },
   {31, 0xA438, 0x648a, },
   {31, 0xA438, 0x0002, },
   {31, 0xA438, 0xbdd8, },
   {31, 0xA438, 0x19d9, },
   {31, 0xA438, 0xef94, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6d78, },
   {31, 0xA438, 0x03ef, },
   {31, 0xA438, 0x7402, },
   {31, 0xA438, 0x72cd, },
   {31, 0xA438, 0xac50, },
   {31, 0xA438, 0x02ef, },
   {31, 0xA438, 0x643a, },
   {31, 0xA438, 0x019f, },
   {31, 0xA438, 0xe4ef, },
   {31, 0xA438, 0x4678, },
   {31, 0xA438, 0x03ac, },
   {31, 0xA438, 0x2002, },
   {31, 0xA438, 0xae02, },
   {31, 0xA438, 0xd0ff, },
   {31, 0xA438, 0xffef, },
   {31, 0xA438, 0x97ff, },
   {31, 0xA438, 0xfec6, },
   {31, 0xA438, 0xfefd, },
   {31, 0xA438, 0x041f, },
   {31, 0xA438, 0x771f, },
   {31, 0xA438, 0x221c, },
   {31, 0xA438, 0x450d, },
   {31, 0xA438, 0x481f, },
   {31, 0xA438, 0x00ac, },
   {31, 0xA438, 0x7f04, },
   {31, 0xA438, 0x1a94, },
   {31, 0xA438, 0xae08, },
   {31, 0xA438, 0x1a94, },
   {31, 0xA438, 0xac7f, },
   {31, 0xA438, 0x03d7, },
   {31, 0xA438, 0x0100, },
   {31, 0xA438, 0xef46, },
   {31, 0xA438, 0x0d48, },
   {31, 0xA438, 0x1f00, },
   {31, 0xA438, 0x1c45, },
   {31, 0xA438, 0xef69, },
   {31, 0xA438, 0xef57, },
   {31, 0xA438, 0xef74, },
   {31, 0xA438, 0x0272, },
   {31, 0xA438, 0xe8a7, },
   {31, 0xA438, 0xffff, },
   {31, 0xA438, 0x0d1a, },
   {31, 0xA438, 0x941b, },
   {31, 0xA438, 0x979e, },
   {31, 0xA438, 0x072d, },
   {31, 0xA438, 0x0100, },
   {31, 0xA438, 0x1a64, },
   {31, 0xA438, 0xef76, },
   {31, 0xA438, 0xef97, },
   {31, 0xA438, 0x0d98, },
   {31, 0xA438, 0xd400, },
   {31, 0xA438, 0xff1d, },
   {31, 0xA438, 0x941a, },
   {31, 0xA438, 0x89cf, },
   {31, 0xA438, 0x1a75, },
   {31, 0xA438, 0xaf74, },
   {31, 0xA438, 0xf9bf, },
   {31, 0xA438, 0x8b79, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6da1, },
   {31, 0xA438, 0x0005, },
   {31, 0xA438, 0xe180, },
   {31, 0xA438, 0xa0ae, },
   {31, 0xA438, 0x03e1, },
   {31, 0xA438, 0x80a1, },
   {31, 0xA438, 0xaf26, },
   {31, 0xA438, 0x9aac, },
   {31, 0xA438, 0x284d, },
   {31, 0xA438, 0xe08f, },
   {31, 0xA438, 0xffef, },
   {31, 0xA438, 0x10c0, },
   {31, 0xA438, 0xe08f, },
   {31, 0xA438, 0xfe10, },
   {31, 0xA438, 0x1b08, },
   {31, 0xA438, 0xa000, },
   {31, 0xA438, 0x04c8, },
   {31, 0xA438, 0xaf40, },
   {31, 0xA438, 0x67c8, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x8c02, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xc4bf, },
   {31, 0xA438, 0x8b8f, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6def, },
   {31, 0xA438, 0x74e0, },
   {31, 0xA438, 0x830c, },
   {31, 0xA438, 0xad20, },
   {31, 0xA438, 0x0302, },
   {31, 0xA438, 0x74ac, },
   {31, 0xA438, 0xccef, },
   {31, 0xA438, 0x971b, },
   {31, 0xA438, 0x76ad, },
   {31, 0xA438, 0x5f02, },
   {31, 0xA438, 0xae13, },
   {31, 0xA438, 0xef69, },
   {31, 0xA438, 0xef30, },
   {31, 0xA438, 0x1b32, },
   {31, 0xA438, 0xc4ef, },
   {31, 0xA438, 0x46e4, },
   {31, 0xA438, 0x8ffb, },
   {31, 0xA438, 0xe58f, },
   {31, 0xA438, 0xfce7, },
   {31, 0xA438, 0x8ffd, },
   {31, 0xA438, 0xcc10, },
   {31, 0xA438, 0x11ae, },
   {31, 0xA438, 0xb8d1, },
   {31, 0xA438, 0x00a1, },
   {31, 0xA438, 0x1f03, },
   {31, 0xA438, 0xaf40, },
   {31, 0xA438, 0x4fbf, },
   {31, 0xA438, 0x8b8c, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ec4, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x8f02, },
   {31, 0xA438, 0x6c6d, },
   {31, 0xA438, 0xef74, },
   {31, 0xA438, 0xe083, },
   {31, 0xA438, 0x0cad, },
   {31, 0xA438, 0x2003, },
   {31, 0xA438, 0x0274, },
   {31, 0xA438, 0xaccc, },
   {31, 0xA438, 0xef97, },
   {31, 0xA438, 0x1b76, },
   {31, 0xA438, 0xad5f, },
   {31, 0xA438, 0x02ae, },
   {31, 0xA438, 0x04ef, },
   {31, 0xA438, 0x69ef, },
   {31, 0xA438, 0x3111, },
   {31, 0xA438, 0xaed1, },
   {31, 0xA438, 0x0287, },
   {31, 0xA438, 0x80af, },
   {31, 0xA438, 0x2293, },
   {31, 0xA438, 0xf8f9, },
   {31, 0xA438, 0xfafb, },
   {31, 0xA438, 0xef59, },
   {31, 0xA438, 0xe080, },
   {31, 0xA438, 0x13ad, },
   {31, 0xA438, 0x252f, },
   {31, 0xA438, 0xbf88, },
   {31, 0xA438, 0x2802, },
   {31, 0xA438, 0x6c6d, },
   {31, 0xA438, 0xef64, },
   {31, 0xA438, 0x1f44, },
   {31, 0xA438, 0xe18f, },
   {31, 0xA438, 0xb91b, },
   {31, 0xA438, 0x64ad, },
   {31, 0xA438, 0x4f1d, },
   {31, 0xA438, 0xd688, },
   {31, 0xA438, 0x2bd7, },
   {31, 0xA438, 0x882e, },
   {31, 0xA438, 0x0274, },
   {31, 0xA438, 0x73ad, },
   {31, 0xA438, 0x5008, },
   {31, 0xA438, 0xbf88, },
   {31, 0xA438, 0x3102, },
   {31, 0xA438, 0x737c, },
   {31, 0xA438, 0xae03, },
   {31, 0xA438, 0x0287, },
   {31, 0xA438, 0xd0bf, },
   {31, 0xA438, 0x882b, },
   {31, 0xA438, 0x0273, },
   {31, 0xA438, 0x73e0, },
   {31, 0xA438, 0x824c, },
   {31, 0xA438, 0xf621, },
   {31, 0xA438, 0xe482, },
   {31, 0xA438, 0x4cbf, },
   {31, 0xA438, 0x8834, },
   {31, 0xA438, 0x0273, },
   {31, 0xA438, 0x7cef, },
   {31, 0xA438, 0x95ff, },
   {31, 0xA438, 0xfefd, },
   {31, 0xA438, 0xfc04, },
   {31, 0xA438, 0xf8f9, },
   {31, 0xA438, 0xfafb, },
   {31, 0xA438, 0xef79, },
   {31, 0xA438, 0xbf88, },
   {31, 0xA438, 0x1f02, },
   {31, 0xA438, 0x737c, },
   {31, 0xA438, 0x1f22, },
   {31, 0xA438, 0xac32, },
   {31, 0xA438, 0x31ef, },
   {31, 0xA438, 0x12bf, },
   {31, 0xA438, 0x8822, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ed6, },
   {31, 0xA438, 0x8fba, },
   {31, 0xA438, 0x1f33, },
   {31, 0xA438, 0xac3c, },
   {31, 0xA438, 0x1eef, },
   {31, 0xA438, 0x13bf, },
   {31, 0xA438, 0x8837, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4eef, },
   {31, 0xA438, 0x96d8, },
   {31, 0xA438, 0x19d9, },
   {31, 0xA438, 0xbf88, },
   {31, 0xA438, 0x2502, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xbf88, },
   {31, 0xA438, 0x2502, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x1616, },
   {31, 0xA438, 0x13ae, },
   {31, 0xA438, 0xdf12, },
   {31, 0xA438, 0xaecc, },
   {31, 0xA438, 0xbf88, },
   {31, 0xA438, 0x1f02, },
   {31, 0xA438, 0x7373, },
   {31, 0xA438, 0xef97, },
   {31, 0xA438, 0xfffe, },
   {31, 0xA438, 0xfdfc, },
   {31, 0xA438, 0x0466, },
   {31, 0xA438, 0xac88, },
   {31, 0xA438, 0x54ac, },
   {31, 0xA438, 0x88f0, },
   {31, 0xA438, 0xac8a, },
   {31, 0xA438, 0x92ac, },
   {31, 0xA438, 0xbadd, },
   {31, 0xA438, 0xac6c, },
   {31, 0xA438, 0xeeac, },
   {31, 0xA438, 0x6cff, },
   {31, 0xA438, 0xad02, },
   {31, 0xA438, 0x99ac, },
   {31, 0xA438, 0x0030, },
   {31, 0xA438, 0xac88, },
   {31, 0xA438, 0xd4c3, },
   {31, 0xA438, 0x5000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x0000, },
   {31, 0xA438, 0x00b4, },
   {31, 0xA438, 0xecee, },
   {31, 0xA438, 0x8298, },
   {31, 0xA438, 0x00af, },
   {31, 0xA438, 0x1412, },
   {31, 0xA438, 0xf8bf, },
   {31, 0xA438, 0x8b5d, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6d58, },
   {31, 0xA438, 0x03e1, },
   {31, 0xA438, 0x8fb8, },
   {31, 0xA438, 0x2901, },
   {31, 0xA438, 0xe58f, },
   {31, 0xA438, 0xb8a0, },
   {31, 0xA438, 0x0049, },
   {31, 0xA438, 0xef47, },
   {31, 0xA438, 0xe483, },
   {31, 0xA438, 0x02e5, },
   {31, 0xA438, 0x8303, },
   {31, 0xA438, 0xbfc2, },
   {31, 0xA438, 0x5f1a, },
   {31, 0xA438, 0x95f7, },
   {31, 0xA438, 0x05ee, },
   {31, 0xA438, 0xffd2, },
   {31, 0xA438, 0x00d8, },
   {31, 0xA438, 0xf605, },
   {31, 0xA438, 0x1f11, },
   {31, 0xA438, 0xef60, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3002, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c6d, },
   {31, 0xA438, 0xf728, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xf628, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x0c64, },
   {31, 0xA438, 0xef46, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x6002, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x0289, },
   {31, 0xA438, 0x9902, },
   {31, 0xA438, 0x3920, },
   {31, 0xA438, 0xaf89, },
   {31, 0xA438, 0x96a0, },
   {31, 0xA438, 0x0149, },
   {31, 0xA438, 0xef47, },
   {31, 0xA438, 0xe483, },
   {31, 0xA438, 0x04e5, },
   {31, 0xA438, 0x8305, },
   {31, 0xA438, 0xbfc2, },
   {31, 0xA438, 0x5f1a, },
   {31, 0xA438, 0x95f7, },
   {31, 0xA438, 0x05ee, },
   {31, 0xA438, 0xffd2, },
   {31, 0xA438, 0x00d8, },
   {31, 0xA438, 0xf605, },
   {31, 0xA438, 0x1f11, },
   {31, 0xA438, 0xef60, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3002, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c6d, },
   {31, 0xA438, 0xf729, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xf629, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x0c64, },
   {31, 0xA438, 0xef46, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x6302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x0289, },
   {31, 0xA438, 0x9902, },
   {31, 0xA438, 0x3920, },
   {31, 0xA438, 0xaf89, },
   {31, 0xA438, 0x96a0, },
   {31, 0xA438, 0x0249, },
   {31, 0xA438, 0xef47, },
   {31, 0xA438, 0xe483, },
   {31, 0xA438, 0x06e5, },
   {31, 0xA438, 0x8307, },
   {31, 0xA438, 0xbfc2, },
   {31, 0xA438, 0x5f1a, },
   {31, 0xA438, 0x95f7, },
   {31, 0xA438, 0x05ee, },
   {31, 0xA438, 0xffd2, },
   {31, 0xA438, 0x00d8, },
   {31, 0xA438, 0xf605, },
   {31, 0xA438, 0x1f11, },
   {31, 0xA438, 0xef60, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3002, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c6d, },
   {31, 0xA438, 0xf72a, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xf62a, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x3302, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x0c64, },
   {31, 0xA438, 0xef46, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x6602, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0x0289, },
   {31, 0xA438, 0x9902, },
   {31, 0xA438, 0x3920, },
   {31, 0xA438, 0xaf89, },
   {31, 0xA438, 0x96ef, },
   {31, 0xA438, 0x47e4, },
   {31, 0xA438, 0x8308, },
   {31, 0xA438, 0xe583, },
   {31, 0xA438, 0x09bf, },
   {31, 0xA438, 0xc25f, },
   {31, 0xA438, 0x1a95, },
   {31, 0xA438, 0xf705, },
   {31, 0xA438, 0xeeff, },
   {31, 0xA438, 0xd200, },
   {31, 0xA438, 0xd8f6, },
   {31, 0xA438, 0x051f, },
   {31, 0xA438, 0x11ef, },
   {31, 0xA438, 0x60bf, },
   {31, 0xA438, 0x8b30, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ebf, },
   {31, 0xA438, 0x8b33, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x6df7, },
   {31, 0xA438, 0x2bbf, },
   {31, 0xA438, 0x8b33, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ef6, },
   {31, 0xA438, 0x2bbf, },
   {31, 0xA438, 0x8b33, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4e0c, },
   {31, 0xA438, 0x64ef, },
   {31, 0xA438, 0x46bf, },
   {31, 0xA438, 0x8b69, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4e02, },
   {31, 0xA438, 0x8999, },
   {31, 0xA438, 0x0239, },
   {31, 0xA438, 0x20af, },
   {31, 0xA438, 0x8996, },
   {31, 0xA438, 0xaf39, },
   {31, 0xA438, 0x1ef8, },
   {31, 0xA438, 0xf9fa, },
   {31, 0xA438, 0xe08f, },
   {31, 0xA438, 0xb838, },
   {31, 0xA438, 0x02ad, },
   {31, 0xA438, 0x2702, },
   {31, 0xA438, 0xae03, },
   {31, 0xA438, 0xaf8b, },
   {31, 0xA438, 0x201f, },
   {31, 0xA438, 0x66ef, },
   {31, 0xA438, 0x65bf, },
   {31, 0xA438, 0xc21f, },
   {31, 0xA438, 0x1a96, },
   {31, 0xA438, 0xf705, },
   {31, 0xA438, 0xeeff, },
   {31, 0xA438, 0xd200, },
   {31, 0xA438, 0xdaf6, },
   {31, 0xA438, 0x05bf, },
   {31, 0xA438, 0xc22f, },
   {31, 0xA438, 0x1a96, },
   {31, 0xA438, 0xf705, },
   {31, 0xA438, 0xeeff, },
   {31, 0xA438, 0xd200, },
   {31, 0xA438, 0xdbf6, },
   {31, 0xA438, 0x05ef, },
   {31, 0xA438, 0x021f, },
   {31, 0xA438, 0x110d, },
   {31, 0xA438, 0x42bf, },
   {31, 0xA438, 0x8b3c, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4eef, },
   {31, 0xA438, 0x021b, },
   {31, 0xA438, 0x031f, },
   {31, 0xA438, 0x110d, },
   {31, 0xA438, 0x42bf, },
   {31, 0xA438, 0x8b36, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4eef, },
   {31, 0xA438, 0x021a, },
   {31, 0xA438, 0x031f, },
   {31, 0xA438, 0x110d, },
   {31, 0xA438, 0x42bf, },
   {31, 0xA438, 0x8b39, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ebf, },
   {31, 0xA438, 0xc23f, },
   {31, 0xA438, 0x1a96, },
   {31, 0xA438, 0xf705, },
   {31, 0xA438, 0xeeff, },
   {31, 0xA438, 0xd200, },
   {31, 0xA438, 0xdaf6, },
   {31, 0xA438, 0x05bf, },
   {31, 0xA438, 0xc24f, },
   {31, 0xA438, 0x1a96, },
   {31, 0xA438, 0xf705, },
   {31, 0xA438, 0xeeff, },
   {31, 0xA438, 0xd200, },
   {31, 0xA438, 0xdbf6, },
   {31, 0xA438, 0x05ef, },
   {31, 0xA438, 0x021f, },
   {31, 0xA438, 0x110d, },
   {31, 0xA438, 0x42bf, },
   {31, 0xA438, 0x8b45, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4eef, },
   {31, 0xA438, 0x021b, },
   {31, 0xA438, 0x031f, },
   {31, 0xA438, 0x110d, },
   {31, 0xA438, 0x42bf, },
   {31, 0xA438, 0x8b3f, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4eef, },
   {31, 0xA438, 0x021a, },
   {31, 0xA438, 0x031f, },
   {31, 0xA438, 0x110d, },
   {31, 0xA438, 0x42bf, },
   {31, 0xA438, 0x8b42, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4eef, },
   {31, 0xA438, 0x56d0, },
   {31, 0xA438, 0x201f, },
   {31, 0xA438, 0x11bf, },
   {31, 0xA438, 0x8b4e, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ebf, },
   {31, 0xA438, 0x8b48, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ebf, },
   {31, 0xA438, 0x8b4b, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ee1, },
   {31, 0xA438, 0x8578, },
   {31, 0xA438, 0xef03, },
   {31, 0xA438, 0x480a, },
   {31, 0xA438, 0x2805, },
   {31, 0xA438, 0xef20, },
   {31, 0xA438, 0x1b01, },
   {31, 0xA438, 0xad27, },
   {31, 0xA438, 0x3f1f, },
   {31, 0xA438, 0x44e0, },
   {31, 0xA438, 0x8560, },
   {31, 0xA438, 0xe185, },
   {31, 0xA438, 0x61bf, },
   {31, 0xA438, 0x8b51, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ee0, },
   {31, 0xA438, 0x8566, },
   {31, 0xA438, 0xe185, },
   {31, 0xA438, 0x67bf, },
   {31, 0xA438, 0x8b54, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ee0, },
   {31, 0xA438, 0x856c, },
   {31, 0xA438, 0xe185, },
   {31, 0xA438, 0x6dbf, },
   {31, 0xA438, 0x8b57, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ee0, },
   {31, 0xA438, 0x8572, },
   {31, 0xA438, 0xe185, },
   {31, 0xA438, 0x73bf, },
   {31, 0xA438, 0x8b5a, },
   {31, 0xA438, 0x026c, },
   {31, 0xA438, 0x4ee1, },
   {31, 0xA438, 0x8fb8, },
   {31, 0xA438, 0x5900, },
   {31, 0xA438, 0xf728, },
   {31, 0xA438, 0xe58f, },
   {31, 0xA438, 0xb8af, },
   {31, 0xA438, 0x8b2c, },
   {31, 0xA438, 0xe185, },
   {31, 0xA438, 0x791b, },
   {31, 0xA438, 0x21ad, },
   {31, 0xA438, 0x373e, },
   {31, 0xA438, 0x1f44, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x62e1, },
   {31, 0xA438, 0x8563, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5102, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x68e1, },
   {31, 0xA438, 0x8569, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5402, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x6ee1, },
   {31, 0xA438, 0x856f, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5702, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x74e1, },
   {31, 0xA438, 0x8575, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5a02, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe18f, },
   {31, 0xA438, 0xb859, },
   {31, 0xA438, 0x00f7, },
   {31, 0xA438, 0x28e5, },
   {31, 0xA438, 0x8fb8, },
   {31, 0xA438, 0xae4a, },
   {31, 0xA438, 0x1f44, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x64e1, },
   {31, 0xA438, 0x8565, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5102, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x6ae1, },
   {31, 0xA438, 0x856b, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5402, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x70e1, },
   {31, 0xA438, 0x8571, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5702, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe085, },
   {31, 0xA438, 0x76e1, },
   {31, 0xA438, 0x8577, },
   {31, 0xA438, 0xbf8b, },
   {31, 0xA438, 0x5a02, },
   {31, 0xA438, 0x6c4e, },
   {31, 0xA438, 0xe18f, },
   {31, 0xA438, 0xb859, },
   {31, 0xA438, 0x00f7, },
   {31, 0xA438, 0x28e5, },
   {31, 0xA438, 0x8fb8, },
   {31, 0xA438, 0xae0c, },
   {31, 0xA438, 0xe18f, },
   {31, 0xA438, 0xb839, },
   {31, 0xA438, 0x04ac, },
   {31, 0xA438, 0x2f04, },
   {31, 0xA438, 0xee8f, },
   {31, 0xA438, 0xb800, },
   {31, 0xA438, 0xfefd, },
   {31, 0xA438, 0xfc04, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0x8efc, },
   {31, 0xA438, 0xac8c, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xfaf0, },
   {31, 0xA438, 0xacf8, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xf6f0, },
   {31, 0xA438, 0xad00, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xfef0, },
   {31, 0xA438, 0xacfc, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xf4f0, },
   {31, 0xA438, 0xacf2, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xf0f0, },
   {31, 0xA438, 0xacb0, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xaef0, },
   {31, 0xA438, 0xacac, },
   {31, 0xA438, 0xf0ac, },
   {31, 0xA438, 0xaaf0, },
   {31, 0xA438, 0xacee, },
   {31, 0xA438, 0xf0b0, },
   {31, 0xA438, 0x24f0, },
   {31, 0xA438, 0xb0a4, },
   {31, 0xA438, 0xf0b1, },
   {31, 0xA438, 0x24f0, },
   {31, 0xA438, 0xb1a4, },
   {31, 0xA438, 0xee8f, },
   {31, 0xA438, 0xb800, },
   {31, 0xA438, 0xd400, },
   {31, 0xA438, 0x00af, },
   {31, 0xA438, 0x3976, },
   {31, 0xA438, 0x66ac, },
   {31, 0xA438, 0xeabb, },
   {31, 0xA438, 0xa430, },
   {31, 0xA438, 0x6e50, },
   {31, 0xA438, 0x6e53, },
   {31, 0xA438, 0x6e56, },
   {31, 0xA438, 0x6e59, },
   {31, 0xA438, 0x6e5c, },
   {31, 0xA438, 0x6e5f, },
   {31, 0xA438, 0x6e62, },
   {31, 0xA438, 0x6e65, },
   {31, 0xA438, 0xd9ac, },
   {31, 0xA438, 0x70f0, },
   {31, 0xA438, 0xac6a, },
   {31, 0xA436, 0xb85e, },
   {31, 0xA438, 0x23b7, },
   {31, 0xA436, 0xb860, },
   {31, 0xA438, 0x74db, },
   {31, 0xA436, 0xb862, },
   {31, 0xA438, 0x268c, },
   {31, 0xA436, 0xb864, },
   {31, 0xA438, 0x3FE5, },
   {31, 0xA436, 0xb886, },
   {31, 0xA438, 0x2250, },
   {31, 0xA436, 0xb888, },
   {31, 0xA438, 0x140e, },
   {31, 0xA436, 0xb88a, },
   {31, 0xA438, 0x3696, },
   {31, 0xA436, 0xb88c, },
   {31, 0xA438, 0x3973, },
   {31, 0xA436, 0xb838, },
   {31, 0xA438, 0x00ff, },

};

static const MMD_REG Rtl8226b_b_uc2_ramcode[] =
{
    { 31, 0xa436, 0Xb87c, },
    { 31, 0xa438, 0X8625, },
    { 31, 0xa436, 0Xb87e, },
    { 31, 0xa438, 0Xaf86, },
    { 31, 0xa438, 0X3daf, },
    { 31, 0xa438, 0X8689, },
    { 31, 0xa438, 0Xaf86, },
    { 31, 0xa438, 0X89af, },
    { 31, 0xa438, 0X8689, },
    { 31, 0xa438, 0Xaf86, },
    { 31, 0xa438, 0X89af, },
    { 31, 0xa438, 0X8689, },
    { 31, 0xa438, 0Xaf86, },
    { 31, 0xa438, 0X89af, },
    { 31, 0xa438, 0X8689, },
    { 31, 0xa438, 0Xbf86, },
    { 31, 0xa438, 0X49d7, },
    { 31, 0xa438, 0X0040, },
    { 31, 0xa438, 0X0277, },
    { 31, 0xa438, 0X7daf, },
    { 31, 0xa438, 0X2727, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7205, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7208, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X71f3, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X71f6, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7229, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X722c, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7217, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X721a, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X721d, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7211, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7220, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7214, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X722f, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7223, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7232, },
    { 31, 0xa438, 0X0000, },
    { 31, 0xa438, 0X7226, },
    { 31, 0xa436, 0Xb85e, },
    { 31, 0xa438, 0X271E, },
    { 31, 0xa436, 0Xb860, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb862, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb864, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb886, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb888, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb88a, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb88c, },
    { 31, 0xa438, 0Xffff, },
    { 31, 0xa436, 0Xb838, },
    { 31, 0xa438, 0X0001, },
};

static const MMD_REG Rtl8226b_a_uc_ramcode[] =
{
    { 31, 0xA436, 0x8464, },
    { 31, 0xA438, 0xaf84, },
    { 31, 0xA438, 0x7caf, },
    { 31, 0xA438, 0x8485, },
    { 31, 0xA438, 0xaf85, },
    { 31, 0xA438, 0x13af, },
    { 31, 0xA438, 0x851e, },
    { 31, 0xA438, 0xaf85, },
    { 31, 0xA438, 0xb9af, },
    { 31, 0xA438, 0x8684, },
    { 31, 0xA438, 0xaf87, },
    { 31, 0xA438, 0x01af, },
    { 31, 0xA438, 0x8701, },
    { 31, 0xA438, 0xac38, },
    { 31, 0xA438, 0x03af, },
    { 31, 0xA438, 0x38bb, },
    { 31, 0xA438, 0xaf38, },
    { 31, 0xA438, 0xc302, },
    { 31, 0xA438, 0x4618, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0x0a02, },
    { 31, 0xA438, 0x54b7, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0x1002, },
    { 31, 0xA438, 0x54c0, },
    { 31, 0xA438, 0xd400, },
    { 31, 0xA438, 0x0fbf, },
    { 31, 0xA438, 0x8507, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48bf, },
    { 31, 0xA438, 0x8504, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x6759, },
    { 31, 0xA438, 0xf0a1, },
    { 31, 0xA438, 0x3008, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x54c0, },
    { 31, 0xA438, 0xae06, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0x0d02, },
    { 31, 0xA438, 0x54b7, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0x0402, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xa183, },
    { 31, 0xA438, 0x02ae, },
    { 31, 0xA438, 0x15a1, },
    { 31, 0xA438, 0x8502, },
    { 31, 0xA438, 0xae10, },
    { 31, 0xA438, 0x59f0, },
    { 31, 0xA438, 0xa180, },
    { 31, 0xA438, 0x16bf, },
    { 31, 0xA438, 0x8501, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67a1, },
    { 31, 0xA438, 0x381b, },
    { 31, 0xA438, 0xae0b, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xffbf, },
    { 31, 0xA438, 0x84fe, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48ae, },
    { 31, 0xA438, 0x17bf, },
    { 31, 0xA438, 0x84fe, },
    { 31, 0xA438, 0x0254, },
    { 31, 0xA438, 0xb7bf, },
    { 31, 0xA438, 0x84fb, },
    { 31, 0xA438, 0x0254, },
    { 31, 0xA438, 0xb7ae, },
    { 31, 0xA438, 0x09a1, },
    { 31, 0xA438, 0x5006, },
    { 31, 0xA438, 0xbf84, },
    { 31, 0xA438, 0xfb02, },
    { 31, 0xA438, 0x54c0, },
    { 31, 0xA438, 0xaf04, },
    { 31, 0xA438, 0x4700, },
    { 31, 0xA438, 0xad34, },
    { 31, 0xA438, 0xfdad, },
    { 31, 0xA438, 0x0670, },
    { 31, 0xA438, 0xae14, },
    { 31, 0xA438, 0xf0a6, },
    { 31, 0xA438, 0x00b8, },
    { 31, 0xA438, 0xbd32, },
    { 31, 0xA438, 0x30bd, },
    { 31, 0xA438, 0x30aa, },
    { 31, 0xA438, 0xbd2c, },
    { 31, 0xA438, 0xccbd, },
    { 31, 0xA438, 0x2ca1, },
    { 31, 0xA438, 0x0705, },
    { 31, 0xA438, 0xec80, },
    { 31, 0xA438, 0xaf40, },
    { 31, 0xA438, 0xf7af, },
    { 31, 0xA438, 0x40f5, },
    { 31, 0xA438, 0xd101, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa402, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa702, },
    { 31, 0xA438, 0x54c0, },
    { 31, 0xA438, 0xd10f, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xaa02, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0x024d, },
    { 31, 0xA438, 0x6abf, },
    { 31, 0xA438, 0x85ad, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ff7, },
    { 31, 0xA438, 0xddbf, },
    { 31, 0xA438, 0x85b0, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ff8, },
    { 31, 0xA438, 0xddbf, },
    { 31, 0xA438, 0x85b3, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ff9, },
    { 31, 0xA438, 0xddbf, },
    { 31, 0xA438, 0x85b6, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ffa, },
    { 31, 0xA438, 0xddd1, },
    { 31, 0xA438, 0x00bf, },
    { 31, 0xA438, 0x85aa, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x4802, },
    { 31, 0xA438, 0x4d6a, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xad02, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfbdd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb002, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfcdd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb302, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfddd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb602, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfedd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa702, },
    { 31, 0xA438, 0x54b7, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa102, },
    { 31, 0xA438, 0x54b7, },
    { 31, 0xA438, 0xaf3c, },
    { 31, 0xA438, 0x2066, },
    { 31, 0xA438, 0xb800, },
    { 31, 0xA438, 0xb8bd, },
    { 31, 0xA438, 0x30ee, },
    { 31, 0xA438, 0xbd2c, },
    { 31, 0xA438, 0xb8bd, },
    { 31, 0xA438, 0x7040, },
    { 31, 0xA438, 0xbd86, },
    { 31, 0xA438, 0xc8bd, },
    { 31, 0xA438, 0x8640, },
    { 31, 0xA438, 0xbd88, },
    { 31, 0xA438, 0xc8bd, },
    { 31, 0xA438, 0x8802, },
    { 31, 0xA438, 0x1929, },
    { 31, 0xA438, 0xa202, },
    { 31, 0xA438, 0x02ae, },
    { 31, 0xA438, 0x03a2, },
    { 31, 0xA438, 0x032e, },
    { 31, 0xA438, 0xd10f, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xaa02, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xf7bf, },
    { 31, 0xA438, 0x85ad, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48e1, },
    { 31, 0xA438, 0x8ff8, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb002, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xf9bf, },
    { 31, 0xA438, 0x85b3, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48e1, },
    { 31, 0xA438, 0x8ffa, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb602, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xae2c, },
    { 31, 0xA438, 0xd100, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xaa02, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xfbbf, },
    { 31, 0xA438, 0x85ad, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48e1, },
    { 31, 0xA438, 0x8ffc, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb002, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xfdbf, },
    { 31, 0xA438, 0x85b3, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48e1, },
    { 31, 0xA438, 0x8ffe, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb602, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xbf86, },
    { 31, 0xA438, 0x7e02, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xa100, },
    { 31, 0xA438, 0x02ae, },
    { 31, 0xA438, 0x25a1, },
    { 31, 0xA438, 0x041d, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xf1bf, },
    { 31, 0xA438, 0x8675, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48e1, },
    { 31, 0xA438, 0x8ff2, },
    { 31, 0xA438, 0xbf86, },
    { 31, 0xA438, 0x7802, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xf3bf, },
    { 31, 0xA438, 0x867b, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48ae, },
    { 31, 0xA438, 0x29a1, },
    { 31, 0xA438, 0x070b, },
    { 31, 0xA438, 0xae24, },
    { 31, 0xA438, 0xbf86, },
    { 31, 0xA438, 0x8102, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xad28, },
    { 31, 0xA438, 0x1be1, },
    { 31, 0xA438, 0x8ff4, },
    { 31, 0xA438, 0xbf86, },
    { 31, 0xA438, 0x7502, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xe18f, },
    { 31, 0xA438, 0xf5bf, },
    { 31, 0xA438, 0x8678, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x48e1, },
    { 31, 0xA438, 0x8ff6, },
    { 31, 0xA438, 0xbf86, },
    { 31, 0xA438, 0x7b02, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xaf09, },
    { 31, 0xA438, 0x8420, },
    { 31, 0xA438, 0xbc32, },
    { 31, 0xA438, 0x20bc, },
    { 31, 0xA438, 0x3e76, },
    { 31, 0xA438, 0xbc08, },
    { 31, 0xA438, 0xfda6, },
    { 31, 0xA438, 0x1a00, },
    { 31, 0xA438, 0xb64e, },
    { 31, 0xA438, 0xd101, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa402, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa702, },
    { 31, 0xA438, 0x54c0, },
    { 31, 0xA438, 0xd10f, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xaa02, },
    { 31, 0xA438, 0x4f48, },
    { 31, 0xA438, 0x024d, },
    { 31, 0xA438, 0x6abf, },
    { 31, 0xA438, 0x85ad, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ff7, },
    { 31, 0xA438, 0xddbf, },
    { 31, 0xA438, 0x85b0, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ff8, },
    { 31, 0xA438, 0xddbf, },
    { 31, 0xA438, 0x85b3, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ff9, },
    { 31, 0xA438, 0xddbf, },
    { 31, 0xA438, 0x85b6, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x67bf, },
    { 31, 0xA438, 0x8ffa, },
    { 31, 0xA438, 0xddd1, },
    { 31, 0xA438, 0x00bf, },
    { 31, 0xA438, 0x85aa, },
    { 31, 0xA438, 0x024f, },
    { 31, 0xA438, 0x4802, },
    { 31, 0xA438, 0x4d6a, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xad02, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfbdd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb002, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfcdd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb302, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfddd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xb602, },
    { 31, 0xA438, 0x4f67, },
    { 31, 0xA438, 0xbf8f, },
    { 31, 0xA438, 0xfedd, },
    { 31, 0xA438, 0xbf85, },
    { 31, 0xA438, 0xa702, },
    { 31, 0xA438, 0x54b7, },
    { 31, 0xA438, 0xaf00, },
    { 31, 0xA438, 0x8800, },
    { 31, 0xA436, 0xb818, },
    { 31, 0xA438, 0x38b8, },
    { 31, 0xA436, 0xb81a, },
    { 31, 0xA438, 0x0444, },
    { 31, 0xA436, 0xb81c, },
    { 31, 0xA438, 0x40ee, },
    { 31, 0xA436, 0xb81e, },
    { 31, 0xA438, 0x3C1A, },
    { 31, 0xA436, 0xb850, },
    { 31, 0xA438, 0x0981, },
    { 31, 0xA436, 0xb852, },
    { 31, 0xA438, 0x0085, },
    { 31, 0xA436, 0xb878, },
    { 31, 0xA438, 0xffff, },
    { 31, 0xA436, 0xb884, },
    { 31, 0xA438, 0xffff, },
    { 31, 0xA436, 0xb832, },
    { 31, 0xA438, 0x003f, },
};

static const MMD_REG Rtl8226b_b_uc_ramcode[] =
{
};

static const MMD_REG Rtl8226b_a_data_ramcode[] =
{
    { 31, 0xB88E, 0XC23F, },
    { 31, 0xB890, 0X0000, },
    { 31, 0xB88E, 0XC241, },
    { 31, 0xB890, 0X0103, },
    { 31, 0xB88E, 0XC243, },
    { 31, 0xB890, 0X0507, },
    { 31, 0xB88E, 0XC245, },
    { 31, 0xB890, 0X090B, },
    { 31, 0xB88E, 0XC247, },
    { 31, 0xB890, 0X0C0E, },
    { 31, 0xB88E, 0XC249, },
    { 31, 0xB890, 0X1012, },
    { 31, 0xB88E, 0XC24B, },
    { 31, 0xB890, 0X1416, },  
};

static const MMD_REG Rtl8226b_b_data_ramcode[] =
{
};

static const MMD_REG Rtl8226b_a_isram_patch[] =
{
    { 30, 0X7E24, 0x0000, },
    { 30, 0x7C00, 0x9900, },
    { 30, 0x7C01, 0xC007, },
    { 30, 0x7C02, 0x6700, },
    { 30, 0x7C03, 0x7600, },
    { 30, 0x7C04, 0x1706, },
    { 30, 0x7C05, 0xF106, },
    { 30, 0x7C06, 0xE13E, },
    { 30, 0x7C07, 0xEBE6, },
    { 30, 0x7C08, 0xD2F4, },
    { 30, 0x7C09, 0xE908, },
    { 30, 0x7C0A, 0xEB00, },
    { 30, 0x7C0B, 0xC0FC, },
    { 30, 0x7C0C, 0x7100, },
    { 30, 0x7C0D, 0x4990, },
    { 30, 0x7C0E, 0xF002, },
    { 30, 0x7C0F, 0xE141, },
    { 30, 0x7C10, 0xC4FA, },
    { 30, 0x7C11, 0x7196, },
    { 30, 0x7C12, 0x4890, },
    { 30, 0x7C13, 0x9996, },
    { 30, 0x7C14, 0xC0F5, },
    { 30, 0x7C15, 0x7500, },
    { 30, 0x7C16, 0x7102, },
    { 30, 0x7C17, 0x4993, },
    { 30, 0x7C18, 0xF002, },
    { 30, 0x7C19, 0x4858, },
    { 30, 0x7C1A, 0x7380, },
    { 30, 0x7C1B, 0x48BE, },
    { 30, 0x7C1C, 0x48BD, },
    { 30, 0x7C1D, 0x483C, },
    { 30, 0x7C1E, 0x48BB, },
    { 30, 0x7C1F, 0x483A, },
    { 30, 0x7C20, 0x25B5, },
    { 30, 0x7C21, 0x21B5, },
    { 30, 0x7C22, 0x1700, },
    { 30, 0x7C23, 0xF013, },
    { 30, 0x7C24, 0x1701, },
    { 30, 0x7C25, 0xF01C, },
    { 30, 0x7C26, 0x1702, },
    { 30, 0x7C27, 0xF025, },
    { 30, 0x7C28, 0x1703, },
    { 30, 0x7C29, 0xF02F, },
    { 30, 0x7C2A, 0x1704, },
    { 30, 0x7C2B, 0xF039, },
    { 30, 0x7C2C, 0x1705, },
    { 30, 0x7C2D, 0xF03F, },
    { 30, 0x7C2E, 0xE116, },
    { 30, 0x7C2F, 0xD408, },
    { 30, 0x7C30, 0x0002, },
    { 30, 0x7C31, 0x0001, },
    { 30, 0x7C32, 0x00DE, },
    { 30, 0x7C33, 0x0007, },
    { 30, 0x7C34, 0x00CE, },
    { 30, 0x7C35, 0xF8FF, },
    { 30, 0x7C36, 0xC0D1, },
    { 30, 0x7C37, 0xC1F9, },
    { 30, 0x7C38, 0x9900, },
    { 30, 0x7C39, 0x49D1, },
    { 30, 0x7C3A, 0xF104, },
    { 30, 0x7C3B, 0x49EF, },
    { 30, 0x7C3C, 0xF13C, },
    { 30, 0x7C3D, 0xE047, },
    { 30, 0x7C3E, 0x49DA, },
    { 30, 0x7C3F, 0xF135, },
    { 30, 0x7C40, 0xE038, },
    { 30, 0x7C41, 0xC0C6, },
    { 30, 0x7C42, 0xC1EE, },
    { 30, 0x7C43, 0x9900, },
    { 30, 0x7C44, 0x49D1, },
    { 30, 0x7C45, 0xF104, },
    { 30, 0x7C46, 0x49EF, },
    { 30, 0x7C47, 0xF131, },
    { 30, 0x7C48, 0xE03C, },
    { 30, 0x7C49, 0x49DA, },
    { 30, 0x7C4A, 0xF132, },
    { 30, 0x7C4B, 0xE02D, },
    { 30, 0x7C4C, 0xC0BB, },
    { 30, 0x7C4D, 0xC1E4, },
    { 30, 0x7C4E, 0x9900, },
    { 30, 0x7C4F, 0x4855, },
    { 30, 0x7C50, 0x4856, },
    { 30, 0x7C51, 0x49D1, },
    { 30, 0x7C52, 0xF122, },
    { 30, 0x7C53, 0x49EF, },
    { 30, 0x7C54, 0xF120, },
    { 30, 0x7C55, 0xC1DB, },
    { 30, 0x7C56, 0x9900, },
    { 30, 0x7C57, 0xE02D, },
    { 30, 0x7C58, 0xC0AF, },
    { 30, 0x7C59, 0xC1D8, },
    { 30, 0x7C5A, 0x9900, },
    { 30, 0x7C5B, 0x4855, },
    { 30, 0x7C5C, 0x4856, },
    { 30, 0x7C5D, 0x49D1, },
    { 30, 0x7C5E, 0xF11E, },
    { 30, 0x7C5F, 0x49EF, },
    { 30, 0x7C60, 0xF11C, }, 
    { 30, 0x7C61, 0xC1CF, },
    { 30, 0x7C62, 0x9900, },
    { 30, 0x7C63, 0xE021, },
    { 30, 0x7C64, 0x49D1, },
    { 30, 0x7C65, 0xF104, },
    { 30, 0x7C66, 0x49EF, },
    { 30, 0x7C67, 0xF119, },
    { 30, 0x7C68, 0xE01C, },
    { 30, 0x7C69, 0x49DA, },
    { 30, 0x7C6A, 0xF112, },
    { 30, 0x7C6B, 0xE015, },
    { 30, 0x7C6C, 0x49D1, },
    { 30, 0x7C6D, 0xF104, },
    { 30, 0x7C6E, 0x49EF, },
    { 30, 0x7C6F, 0xF109, },
    { 30, 0x7C70, 0xE014, },
    { 30, 0x7C71, 0x49DA, },
    { 30, 0x7C72, 0xF10E, },
    { 30, 0x7C73, 0xE005, },
    { 30, 0x7C74, 0x1816, },
    { 30, 0x7C75, 0x4198, },
    { 30, 0x7C76, 0x1A05, },
    { 30, 0x7C77, 0xE010, },
    { 30, 0x7C78, 0x1802, },
    { 30, 0x7C79, 0x4198, },
    { 30, 0x7C7A, 0x1A04, },
    { 30, 0x7C7B, 0xE00C, },
    { 30, 0x7C7C, 0x1812, },
    { 30, 0x7C7D, 0x4198, },
    { 30, 0x7C7E, 0x1A05, },
    { 30, 0x7C7F, 0xE008, },
    { 30, 0x7C80, 0x180D, },
    { 30, 0x7C81, 0x4198, },
    { 30, 0x7C82, 0x1A06, },
    { 30, 0x7C83, 0xE004, },
    { 30, 0x7C84, 0x181F, },
    { 30, 0x7C85, 0x1A00, },
    { 30, 0x7C86, 0x4198, },
    { 30, 0x7C87, 0x9B80, },
    { 30, 0x7C88, 0xC0A7, },
    { 30, 0x7C89, 0x7100, },
    { 30, 0x7C8A, 0x1200, },
    { 30, 0x7C8B, 0xF005, },
    { 30, 0x7C8C, 0xC3A9, },
    { 30, 0x7C8D, 0x414B, },
    { 30, 0x7C8E, 0x2128, },
    { 30, 0x7C8F, 0x418A, },
    { 30, 0x7C90, 0x9900, },
    { 30, 0x7C91, 0xC0A1, },
    { 30, 0x7C92, 0x9890, },
    { 30, 0x7C93, 0xC0A0, },
    { 30, 0x7C94, 0x9892, },
    { 30, 0x7C95, 0x1803, },
    { 30, 0x7C96, 0x988E, },
    { 30, 0x7C97, 0x708E, },
    { 30, 0x7C98, 0x4980, },
    { 30, 0x7C99, 0xF1FE, },
    { 30, 0x7C9A, 0xC09A, },
    { 30, 0x7C9B, 0x9890, },
    { 30, 0x7C9C, 0x1801, },
    { 30, 0x7C9D, 0x988E, },
    { 30, 0x7C9E, 0x708E, },
    { 30, 0x7C9F, 0x4980, },
    { 30, 0x7CA0, 0xF1FE, },
    { 30, 0x7CA1, 0x7194, },
    { 30, 0x7CA2, 0x4819, },
    { 30, 0x7CA3, 0x9992, },
    { 30, 0x7CA4, 0x1803, },
    { 30, 0x7CA5, 0x988E, },
    { 30, 0x7CA6, 0x708E, },
    { 30, 0x7CA7, 0x4980, },
    { 30, 0x7CA8, 0xF1FE, },
    { 30, 0x7CA9, 0xC12A, },
    { 30, 0x7CAA, 0x7020, },
    { 30, 0x7CAB, 0x4980, },
    { 30, 0x7CAC, 0xF02A, },
    { 30, 0x7CAD, 0x49D2, },
    { 30, 0x7CAE, 0xF10B, },
    { 30, 0x7CAF, 0x49D3, },
    { 30, 0x7CB0, 0xF10C, },
    { 30, 0x7CB1, 0x49D4, },
    { 30, 0x7CB2, 0xF10C, },
    { 30, 0x7CB3, 0x49D9, },
    { 30, 0x7CB4, 0xF10A, },
    { 30, 0x7CB5, 0x49DA, },
    { 30, 0x7CB6, 0xF10A, },
    { 30, 0x7CB7, 0xC215, },
    { 30, 0x7CB8, 0xE009, },
    { 30, 0x7CB9, 0xE8BC, },
    { 30, 0x7CBA, 0xC210, },
    { 30, 0x7CBB, 0xE006, },
    { 30, 0x7CBC, 0xC20F, },
    { 30, 0x7CBD, 0xE004, },
    { 30, 0x7CBE, 0xC20F, },
    { 30, 0x7CBF, 0xE002, },
    { 30, 0x7CC0, 0xC20E, },
    { 30, 0x7CC1, 0x9A20, },
    { 30, 0x7CC2, 0xE8C3, },
    { 30, 0x7CC3, 0xC00C, },
    { 30, 0x7CC4, 0xC10C, },
    { 30, 0x7CC5, 0x9900, },
    { 30, 0x7CC6, 0xC00B, },
    { 30, 0x7CC7, 0xC10B, },
    { 30, 0x7CC8, 0x9900, },
    { 30, 0x7CC9, 0xE019, },
    { 30, 0x7CCA, 0x000D, },
    { 30, 0x7CCB, 0x010D, },
    { 30, 0x7CCC, 0x020D, },
    { 30, 0x7CCD, 0x030D, },
    { 30, 0x7CCE, 0x040F, },
    { 30, 0x7CCF, 0xC0A2, },
    { 30, 0x7CD0, 0x0140, },
    { 30, 0x7CD1, 0xC0AA, },
    { 30, 0x7CD2, 0x0008, },
    { 30, 0x7CD3, 0xEBE6, },
    { 30, 0x7CD4, 0xD408, },
    { 30, 0x7CD5, 0xF8FF, },
    { 30, 0x7CD6, 0x49DA, },
    { 30, 0x7CD7, 0xF10B, },
    { 30, 0x7CD8, 0x49D9, },
    { 30, 0x7CD9, 0xF10B, },
    { 30, 0x7CDA, 0x49D8, },
    { 30, 0x7CDB, 0xF10D, },
    { 30, 0x7CDC, 0x49D4, },
    { 30, 0x7CDD, 0xF109, },
    { 30, 0x7CDE, 0x49D3, },
    { 30, 0x7CDF, 0xF10B, },
    { 30, 0x7CE0, 0x49D2, },
    { 30, 0x7CE1, 0xF10B, },
    { 30, 0x7CE2, 0xC264, },
    { 30, 0x7CE3, 0xE00A, },
    { 30, 0x7CE4, 0xC263, },
    { 30, 0x7CE5, 0xE008, },
    { 30, 0x7CE6, 0xC262, },
    { 30, 0x7CE7, 0xE006, },
    { 30, 0x7CE8, 0xC261, },
    { 30, 0x7CE9, 0xE004, },
    { 30, 0x7CEA, 0xC260, },
    { 30, 0x7CEB, 0xE002, },
    { 30, 0x7CEC, 0xC25F, },
    { 30, 0x7CED, 0x49D0, },
    { 30, 0x7CEE, 0xF103, },
    { 30, 0x7CEF, 0x48A2, },
    { 30, 0x7CF0, 0xE002, },
    { 30, 0x7CF1, 0x4822, },
    { 30, 0x7CF2, 0x49D1, },
    { 30, 0x7CF3, 0xF103, },
    { 30, 0x7CF4, 0x48A4, },
    { 30, 0x7CF5, 0xE002, },
    { 30, 0x7CF6, 0x4824, },
    { 30, 0x7CF7, 0x49D5, },
    { 30, 0x7CF8, 0xF103, },
    { 30, 0x7CF9, 0x48A5, },
    { 30, 0x7CFA, 0xE002, },
    { 30, 0x7CFB, 0x4825, },
    { 30, 0x7CFC, 0x49D6, },
    { 30, 0x7CFD, 0xF103, },
    { 30, 0x7CFE, 0x48A6, },
    { 30, 0x7CFF, 0xE002, },
    { 30, 0x7223, 0x0001, },
    { 30, 0x7C00, 0x4826, },
    { 30, 0x7C01, 0xC04C, },
    { 30, 0x7C02, 0xC14C, },
    { 30, 0x7C03, 0x9900, },
    { 30, 0x7C04, 0xC04B, },
    { 30, 0x7C05, 0x7104, },
    { 30, 0x7C06, 0x499C, },
    { 30, 0x7C07, 0xF103, },
    { 30, 0x7C08, 0x48A7, },
    { 30, 0x7C09, 0xE002, },
    { 30, 0x7C0A, 0x4827, },
    { 30, 0x7C0B, 0x499B, },
    { 30, 0x7C0C, 0xF103, },
    { 30, 0x7C0D, 0x48A8, },
    { 30, 0x7C0E, 0xE002, },
    { 30, 0x7C0F, 0x4828, },
    { 30, 0x7C10, 0xC03F, },
    { 30, 0x7C11, 0x730A, },
    { 30, 0x7C12, 0x49B0, },
    { 30, 0x7C13, 0xF103, },
    { 30, 0x7C14, 0x48A9, },
    { 30, 0x7C15, 0xE002, },
    { 30, 0x7C16, 0x4829, },
    { 30, 0x7C17, 0x4998, },
    { 30, 0x7C18, 0xF103, },
    { 30, 0x7C19, 0x48AA, },
    { 30, 0x7C1A, 0xE006, },
    { 30, 0x7C1B, 0x49D3, },
    { 30, 0x7C1C, 0xF103, },
    { 30, 0x7C1D, 0x48AA, },
    { 30, 0x7C1E, 0xE002, },
    { 30, 0x7C1F, 0x482A, },
    { 30, 0x7C20, 0x4998, },
    { 30, 0x7C21, 0xF103, },
    { 30, 0x7C22, 0x48AB, },
    { 30, 0x7C23, 0xE006, },
    { 30, 0x7C24, 0x49D4, },
    { 30, 0x7C25, 0xF103, },
    { 30, 0x7C26, 0x48AB, },
    { 30, 0x7C27, 0xE002, },
    { 30, 0x7C28, 0x482B, },
    { 30, 0x7C29, 0x4998, },
    { 30, 0x7C2A, 0xF103, },
    { 30, 0x7C2B, 0x48AE, },
    { 30, 0x7C2C, 0xE002, },
    { 30, 0x7C2D, 0x482E, },
    { 30, 0x7C2E, 0x9A84, },
    { 30, 0x7C2F, 0xC016, },
    { 30, 0x7C30, 0x1905, },
    { 30, 0x7C31, 0x9902, },
    { 30, 0x7C32, 0x1901, },
    { 30, 0x7C33, 0x9900, },
    { 30, 0x7C34, 0xC018, },
    { 30, 0x7C35, 0x7100, },
    { 30, 0x7C36, 0x4811, },
    { 30, 0x7C37, 0x9900, },
    { 30, 0x7C38, 0xE00C, },
    { 30, 0x7C39, 0xC00C, },
    { 30, 0x7C3A, 0x7100, },
    { 30, 0x7C3B, 0x4990, },
    { 30, 0x7C3C, 0xF108, },
    { 30, 0x7C3D, 0xC00F, },
    { 30, 0x7C3E, 0x7100, },
    { 30, 0x7C3F, 0x4891, },
    { 30, 0x7C40, 0x9900, },
    { 30, 0x7C41, 0x7196, },
    { 30, 0x7C42, 0x4810, },
    { 30, 0x7C43, 0x9996, },
    { 30, 0x7C44, 0xFF80, },
    { 30, 0x7C45, 0xE42C, },
    { 30, 0x7C46, 0x1001, },
    { 30, 0x7C47, 0x1003, },
    { 30, 0x7C48, 0x0002, },
    { 30, 0x7C49, 0x0003, },
    { 30, 0x7C4A, 0x0001, },
    { 30, 0x7C4B, 0x0000, },
    { 30, 0x7C4C, 0xD2F0, },
    { 30, 0x7C4D, 0xE86C, },
    { 30, 0x7C4E, 0xA000, },
    { 30, 0x7C4F, 0xB430, },
    { 30, 0x7C50, 0xC123, },
    { 30, 0x7C51, 0x7220, },
    { 30, 0x7C52, 0x48A0, },
    { 30, 0x7C53, 0x9A20, },
    { 30, 0x7C54, 0x48A1, },
    { 30, 0x7C55, 0xC31F, },
    { 30, 0x7C56, 0x4153, },
    { 30, 0x7C57, 0xC01B, },
    { 30, 0x7C58, 0x7500, },
    { 30, 0x7C59, 0x49D2, },
    { 30, 0x7C5A, 0xF10B, },
    { 30, 0x7C5B, 0x49D3, },
    { 30, 0x7C5C, 0xF10B, },
    { 30, 0x7C5D, 0x49D4, },
    { 30, 0x7C5E, 0xF10B, },
    { 30, 0x7C5F, 0x49D9, },
    { 30, 0x7C60, 0xF109, },
    { 30, 0x7C61, 0x49DA, },
    { 30, 0x7C62, 0xF10A, },
    { 30, 0x7C63, 0x4829, },
    { 30, 0x7C64, 0xE00A, },
    { 30, 0x7C65, 0xE810, },
    { 30, 0x7C66, 0xE008, },
    { 30, 0x7C67, 0x4828, },
    { 30, 0x7C68, 0xE006, },
    { 30, 0x7C69, 0x4829, },
    { 30, 0x7C6A, 0x4828, },
    { 30, 0x7C6B, 0xE003, },
    { 30, 0x7C6C, 0x482A, },
    { 30, 0x7C6D, 0x4821, },
    { 30, 0x7C6E, 0x4820, },
    { 30, 0x7C6F, 0x9A20, },
    { 30, 0x7C70, 0xE815, },
    { 30, 0x7C71, 0xFF80, },
    { 30, 0x7C72, 0xE908, },
    { 30, 0x7C73, 0xEBE6, },
    { 30, 0x7C74, 0xF8FF, },
    { 30, 0x7C75, 0xB400, },
    { 30, 0x7C76, 0xB401, },
    { 30, 0x7C77, 0xC00A, },
    { 30, 0x7C78, 0xC10A, },
    { 30, 0x7C79, 0x9900, },
    { 30, 0x7C7A, 0xC009, },
    { 30, 0x7C7B, 0x7100, },
    { 30, 0x7C7C, 0x4890, },
    { 30, 0x7C7D, 0x9900, },
    { 30, 0x7C7E, 0xB001, },
    { 30, 0x7C7F, 0xB000, },
    { 30, 0x7C80, 0xFF80, },
    { 30, 0x7C81, 0xE86C, },
    { 30, 0x7C82, 0xA000, },
    { 30, 0x7C83, 0xB430, },
    { 30, 0x7C84, 0xB408, },
    { 30, 0x7C85, 0xB400, },
    { 30, 0x7C86, 0xB401, },
    { 30, 0x7C87, 0xC0FA, },
    { 30, 0x7C88, 0xC1FA, },
    { 30, 0x7C89, 0x9900, },
    { 30, 0x7C8A, 0xC0FA, },
    { 30, 0x7C8B, 0x7100, },
    { 30, 0x7C8C, 0x481A, },
    { 30, 0x7C8D, 0x481B, },
    { 30, 0x7C8E, 0x9900, },
    { 30, 0x7C8F, 0xB001, },
    { 30, 0x7C90, 0xB000, },
    { 30, 0x7C91, 0xFF80, },
    { 30, 0X7E13, 0x8000, },
    { 30, 0X7E14, 0x5c3c, },
    { 30, 0X7E24, 0X0001, },
};

static const MMD_REG Rtl8226b_b_isram_patch[] =
{
};

static BOOL
Rtl8226b_wait_for_bit(
    IN HANDLE hDevice,
    IN UINT16 dev,
    IN UINT16 addr,
    IN UINT16 mask,
    IN BOOL   set,
    IN UINT16 timeoutms)
{
    BOOL status = FAILURE;
    UINT16 phydata = 0;

    while (--timeoutms) {
        status = MmdPhyRead(hDevice, dev, addr, &phydata);

        if (!status)
            goto exit;

        if (!set)
            phydata = ~phydata;

        if ((phydata & mask) == mask)
            return 1;

        //Sleep(1);
	schedule_timeout(HZ/100);  //delay 10ms
    }

    //phy_osal_printf("Timeout (dev=%02x addr=0x%02x mask=0x%02x timeout=%d)\n", dev, addr, mask, timeoutms);

exit:
    return 0;
}

BOOLEAN
Rtl8226b_phy_init(
    IN HANDLE hDevice,
    IN PHY_LINK_ABILITY *pphylinkability,
    IN BOOL singlephy
    )
{
    BOOL status = FAILURE;
    UINT16 i = 0;  
    UINT16 phydata = 0;
    UINT16 VERID = 0;
    UINT16 SDSMode = 0x1 ; //write bit [5:0] = 0/1/2/3  SDS mode
    const UINT16 patchver_a = 0x0021, patchver_b = 0x0004, patchaddr = 0x8024;
    
    status = Rtl8226b_wait_for_bit(hDevice, MMD_VEND2, 0xA420, 0x3, 1, 100);
    if (status != SUCCESS)
        goto exit;

    status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x801E);
    if (status != SUCCESS)
        goto exit;
                     
    status = MmdPhyRead(hDevice, MMD_VEND2, 0xA438, &phydata);
    if (status != SUCCESS)
        goto exit;

    status = MmdPhyRead(hDevice, MMD_VEND1, 0x7309, &VERID);
    if (status != SUCCESS)
        goto exit;

    RTL8226B_INFO("VERID = 0x%04X / patchVER = 0x%04X (MDIO set %d , PHY Addr %d)", VERID, phydata, hDevice.unit, hDevice.port);

    if (VERID == 0x6700){
        if (phydata == patchver_a)
        {
        status = 1;
        goto exit;
        }
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xbf86, 0x9000);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xc402, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata |= 0x0400;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xC402, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= 0xfbff;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xC402, phydata);
        if (status != SUCCESS)
            goto exit;
            
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xbd4e, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0xF3FF;
        phydata |= 0x0800;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xbd4e, phydata);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xbf46, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0xF0FF;
        phydata |= 0x0700;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xbf46, phydata);
        if (status != SUCCESS)
            goto exit;             
 
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata |= BIT_4;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;

        status = Rtl8226b_wait_for_bit(hDevice, MMD_VEND2, 0xB800, BIT_6, 1, 100);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, patchaddr);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x3700);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0xB82E);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0001);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata |= BIT_7;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;

        for(i=0; i<sizeof(Rtl8226b_a_n0_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_a_n0_ramcode[i].dev, Rtl8226b_a_n0_ramcode[i].addr, Rtl8226b_a_n0_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

        for(i=0; i<sizeof(Rtl8226b_a_n1_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_a_n1_ramcode[i].dev, Rtl8226b_a_n1_ramcode[i].addr, Rtl8226b_a_n1_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }


        for(i=0; i<sizeof(Rtl8226b_a_n2_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_a_n2_ramcode[i].dev, Rtl8226b_a_n2_ramcode[i].addr, Rtl8226b_a_n2_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

        for(i=0; i<sizeof(Rtl8226b_a_uc2_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_a_uc2_ramcode[i].dev, Rtl8226b_a_uc2_ramcode[i].addr, Rtl8226b_a_uc2_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_7);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;

        for(i=0; i<sizeof(Rtl8226b_a_uc_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_a_uc_ramcode[i].dev, Rtl8226b_a_uc_ramcode[i].addr, Rtl8226b_a_uc_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }                                            

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB896, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_0);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB896, phydata);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB892, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0x00ff;
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB892, phydata);
        if (status != SUCCESS)
            goto exit;

        for(i=0; i<sizeof(Rtl8226b_a_data_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_a_data_ramcode[i].dev, Rtl8226b_a_data_ramcode[i].addr, Rtl8226b_a_data_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB896, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata |= BIT_0;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB896, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata = 0x0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata = 0x0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, phydata);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB82E, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_0);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB82E, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata = patchaddr;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata = 0x0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, phydata);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_4);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;

        status = Rtl8226b_wait_for_bit(hDevice, MMD_VEND2, 0xB800, BIT_6, 0, 100);
        if (status != SUCCESS)
            goto exit;

        phydata = 0x801E;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata = patchver_a;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, phydata);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xA86A, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata |= 0x0001;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA86A, phydata);
        if (status != SUCCESS)
            goto exit;   
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x8217);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x5074);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x821A);
        if(status != SUCCESS)
          goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x5070);
        if(status != SUCCESS)
          goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80da);
        if(status != SUCCESS)
        goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0403);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80dc);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x1001);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80b3);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0384);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80b7);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x2007);
        if(status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80ba);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x6c3d);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80b5);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xf009);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80bd);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x9f0c);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80c7);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xf083);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80dd);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x03f0);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80df);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x1004);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80cb);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x2007);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80ce);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x6c4a);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80c9);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x8009);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80d1);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x800c);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80a5);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xf0a4);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80a3);
        if(status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x200a);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80a6);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xadff);
        if(status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x809f);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x6043);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80a0);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x7300);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80a2);
        if(status != SUCCESS)
          goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0b20);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x80a9);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xc01e);
        if(status != SUCCESS)
              goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xD032, 0x0003);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xD034, 0x0004);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xD036, 0x0020);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x8fff);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0400);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8560);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x19cc);
        if(status != SUCCESS)
           goto exit;
   
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8562);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x19cc);
        if(status != SUCCESS)
           goto exit;
     
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8564);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x19cc);
        if(status != SUCCESS)
           goto exit;
        
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xAC8C, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0xF007;
        phydata |= 0x0ff8;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xAC8C, phydata);
        if (status != SUCCESS)
            goto exit;
            
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xAC46, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= 0xF00F;        
        phydata |= 0x07b0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xAC46, phydata);
        if (status != SUCCESS)
            goto exit;
        
        status = MmdPhyRead(hDevice, MMD_VEND2, 0XAC50, &phydata);
        if (status != SUCCESS)
            goto exit;
            
        phydata &= 0xF000;
        phydata |= 0x0fbc;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XAC50, phydata);
        if (status != SUCCESS)
            goto exit;
            
        status = MmdPhyRead(hDevice, MMD_VEND2, 0XAC3C, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0x1FFF;
        phydata |= 0x8000;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XAC3C, phydata);
        if (status != SUCCESS)
            goto exit;
            
        status = MmdPhyRead(hDevice, MMD_VEND2, 0XAC4E, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0xF000;
        phydata |= 0x0db4;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XAC4E, phydata);
        if (status != SUCCESS)
            goto exit;
            
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XACC8, 0XA0D3);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XACC6, 0X0707);
        if (status != SUCCESS)
            goto exit;
            
        status = MmdPhyRead(hDevice, MMD_VEND2, 0XAD08, &phydata);
        if (status != SUCCESS)
            goto exit;
        
        phydata &= 0xFF00;
        phydata |= 0X0007;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XAD08, phydata);
        if (status != SUCCESS)
            goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x813d);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x390e);
        if(status != SUCCESS)
           goto exit;
 
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x814f);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x790e);
        if(status != SUCCESS)
           goto exit;
 
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x80b0);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0f31);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87c, 0x8145);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x370e);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8157);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x770e);
        if(status != SUCCESS)
           goto exit;
 
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8169);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0d0a);
        if(status != SUCCESS)
           goto exit;
 
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x817b);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x1d0a);
        if(status != SUCCESS)
           goto exit;
  
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8566);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x147d);
        if(status != SUCCESS)
           goto exit;
  
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8568);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x147d);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x856a);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x147d);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8ffe);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0907);
        if(status != SUCCESS)
           goto exit;           

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x80D6);
        if(status != SUCCESS)
           goto exit;         

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x2801);
        if(status != SUCCESS)
           goto exit; 

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x80F2);
        if(status != SUCCESS)
           goto exit;         

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x2801);
        if(status != SUCCESS)
           goto exit;      

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x80F4);
        if(status != SUCCESS)
           goto exit;         

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x6077);
        if(status != SUCCESS)
           goto exit; 
         
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8141);
        if(status != SUCCESS)
           goto exit; 

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x320E);
        if(status != SUCCESS)
           goto exit; 
         
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8153);
        if(status != SUCCESS)
           goto exit; 

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x720E);
        if(status != SUCCESS)
           goto exit; 
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8529);
        if(status != SUCCESS)
           goto exit; 

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x050E);
        if(status != SUCCESS)
           goto exit; 

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xA412,  &phydata);
        if(status != SUCCESS)
           goto exit;
                   
         phydata |= BIT_9;
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA412, phydata);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xA5D4,  &phydata);
        if(status != SUCCESS)
           goto exit;
                   
        phydata |= BIT_7;
         
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA5D4, phydata);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x816c);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xc4a0);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x8170);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0xc4a0);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x8174);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x04a0);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x8178);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x04a0);
        if(status != SUCCESS)
           goto exit;

	   
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xBCE0, 0xaaaa);
        if(status != SUCCESS)
           goto exit;
		
	status = MmdPhyRead(hDevice, MMD_VEND2, 0xBC08,  &phydata);
        if(status != SUCCESS)
           goto exit;
        
        phydata &= 0xFFF3;           
        phydata |= 0x000c;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xBC08, phydata);
        if(status != SUCCESS)
           goto exit;
	   
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xBF4A, 0x001b);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0x817c);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0719);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0X8FF4);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0400);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0X8FF1);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0404);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8033);
        if(status != SUCCESS)
           goto exit;        

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x7c13);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8037);
        if(status != SUCCESS)
           goto exit;        

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x7c13);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x803B);
        if(status != SUCCESS)
           goto exit;          

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xFC32);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x803F);
        if(status != SUCCESS)
           goto exit;         

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x7c13);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8043);
        if(status != SUCCESS)
           goto exit;        

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x7c13);
        if(status != SUCCESS)
           goto exit;
  
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8047);
        if(status != SUCCESS)
           goto exit;         

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x7c13);
        if(status != SUCCESS)
           goto exit;
  
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x804B);
        if(status != SUCCESS)
           goto exit;          

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xFC1C);
        if(status != SUCCESS)
           goto exit; 

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xACDA,  &phydata);
        if(status != SUCCESS)
           goto exit;
                   
        phydata |= 0xFF00;
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xACDA, phydata);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xACDE, &phydata);
        if(status != SUCCESS)
           goto exit;
                   
         phydata |= 0xF000;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xACDE, phydata);
        if(status != SUCCESS)
           goto exit;
        
        status = MmdPhyRead(hDevice, MMD_VEND2, 0XBFA0, &phydata);
        if(status != SUCCESS)
           goto exit;
           
        phydata &= 0x0007;   
        phydata |= 0xD708;  
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XBFA0, phydata);
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XBFA2, 0X4100 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XBFA4, 0XE848 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XBFA6, 0XDC59 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0XB54C, &phydata);  
        if(status != SUCCESS)
           goto exit;
           
        phydata &= 0x003F;
        phydata |= 0x3c00;  
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XB54C, phydata);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0XBCCA, &phydata);  
        if(status != SUCCESS)
           goto exit;
           
        phydata |= 0x0300;   
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XBCCA, phydata);
        if(status != SUCCESS)
           goto exit;
        
        status = MmdPhyRead(hDevice, MMD_VEND2, 0XBF4C, &phydata);  
        if(status != SUCCESS)
           goto exit;
           
        phydata |= 0x0002;         
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XBF4C, phydata);  
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0XA432, &phydata);  
        if(status != SUCCESS)
           goto exit;
        
        phydata &= 0xFFBF;    
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XA432, phydata);  
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8013 );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x700  );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FB9 );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x2801 );
                if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FBA );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0100 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FBC );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x1900 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FBE );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xE100 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FC0 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0800 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FC2 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xE500 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FC4 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0F00 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FC6 );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xF100 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FC8 );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0400 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FCA );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xF300 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FCC );         
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xFD00 );
        if(status != SUCCESS)
           goto exit;
        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FCE );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xFF00 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FD0 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xFB00 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FD2 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0x0100 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FD4 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xF400 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FD6 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xFF00 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87C, 0x8FD8 );         
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB87E, 0xF600 );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XB506, 0X1E7 );
        if(status != SUCCESS)
           goto exit;
           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0X815A );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0XAE   );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0X815C );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0X470  );
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND2, 0XA6F0, &phydata );  
        if(status != SUCCESS)
           goto exit;
        
       phydata |= 0x0001; 
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0XA6F0, phydata );
        if(status != SUCCESS)
           goto exit;

        ///*   		
        // SDS
        ////// Release SerDes reg (wtg_top) Reset 30.0X758B[0] = 0
        //status = MmdPhyRead(hDevice, MMD_VEND2, 0X758B, &phydata );  
        //if(status != SUCCESS)
        //   goto exit;
        
        //phydata &= 0xFFFE;		
        //status = MmdPhyWrite(hDevice, MMD_VEND1, 0x758B, phydata);
        //if(status != SUCCESS)
        //   goto exit;
	   
	   status = MmdPhyWrite(hDevice, MMD_VEND1, 0X758B, 0x0004);    
        if(status != SUCCESS)
           goto exit;
		
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6A04, 0x0503);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x7580, 0x9416);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xe3da);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8005);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xa848);
        if(status != SUCCESS)
           goto exit;

  
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8001);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x6047);
        if(status != SUCCESS)
           goto exit;

 
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8002);
        if(status != SUCCESS)
           goto exit;

	   
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x5000);
        if(status != SUCCESS)
           goto exit;

	   
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8004);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x001f);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8006);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xf648);
        if(status != SUCCESS)
           goto exit;
  

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x800a);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xc000);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x800c);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xf712);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x800d);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xd422);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8020);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x88aa);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8021);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x0053);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8022);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x7b66);
        if(status != SUCCESS)
           goto exit;

	   
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8023);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xc40e);
        if(status != SUCCESS)
           goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8026);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6A04, 0x0403);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x7580, 0x9402);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xe312);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8005);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xa848);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8001);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x6046);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8002);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x5000);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8004);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x001f);
        if(status != SUCCESS)
           goto exit;
 
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8006);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xf648);
        if(status != SUCCESS)
           goto exit;
            
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x800a);
        if(status != SUCCESS)
           goto exit;
	   
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xc000);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x800c);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xf712);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x800d);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xd422);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8020);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x88aa);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8021);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x0053);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8022);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0x7b66);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8023);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F10, 0xc40e);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6F11, 0x8026);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND1, 0x6A12, &phydata );  
        if(status != SUCCESS)
           goto exit;
        
        phydata &= 0x9FFE;
        phydata |= 0x2000;        		
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x6A12, phydata);
        if(status != SUCCESS)
           goto exit;
           
		
		//// Release Reset 30.0X758B[0] = 1
        //status = MmdPhyRead(hDevice, MMD_VEND1, 0X758B, &phydata );  
        //if(status != SUCCESS)
        //   goto exit;
        
        //phydata |= 0x1;  
		//status = MmdPhyWrite(hDevice, MMD_VEND1, 0x758B, phydata);
        //if(status != SUCCESS)
        //   goto exit;
		
		status = MmdPhyWrite(hDevice, MMD_VEND1, 0x758B, 0x0005);
        if(status != SUCCESS)
           goto exit;
	     
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xa400, &phydata);
        if(status != SUCCESS)
           goto exit;
        
        phydata |= 0x0800;           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xa400, phydata);
        if(status != SUCCESS)
           goto exit;

        if (singlephy)
        {
            for(i=0; i<sizeof(Rtl8226b_a_isram_patch)/sizeof(MMD_REG); i++)
            {
                status = MmdPhyWrite(hDevice, Rtl8226b_a_isram_patch[i].dev, Rtl8226b_a_isram_patch[i].addr, Rtl8226b_a_isram_patch[i].value);
                if (status != SUCCESS){
                    goto exit;
		          }
            }
        }

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xa400, &phydata);
        if(status != SUCCESS)
           goto exit;
        
        phydata &= 0xf7ff;           
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xa400, phydata);
        if(status != SUCCESS)
           goto exit;
	   
	  
	   //------------------------------------------------------------------------
	   
        // TX polarity change
	    status = MmdPhyWrite(hDevice, MMD_VEND1, 0x7588, 0x0000);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x7589, 0x1503);
        if(status != SUCCESS)
           goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x7587, 0x0003);
        if(status != SUCCESS)
           goto exit;

		status = Rtl8226b_wait_for_bit(hDevice, MMD_VEND1, 0x7587, BIT_0, 0, 100);
		if (status != SUCCESS)
	   	goto exit;
	   
		//------------------------------------------------------------------------

        //SDS mode setting start
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x75F3, 0x0000);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND1, 0x697A, &phydata);
        if (status != SUCCESS)
            goto exit;
     
        phydata &= 0xFFC0;
        phydata |= SDSMode;  //write bit [5:0] = 0/1/2/3  M\mode諸reg
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x697A, phydata);
        if (status != SUCCESS)
            goto exit;
        //SDS mode setting end
		
       status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA400, 0x9200);
        if (status != SUCCESS)
            goto exit;
 
    }
    else if (VERID == 0x6710)
    {
        if (phydata == patchver_b)
        {
        status = 1;
        goto exit;
        }
        
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata |= BIT_4;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;

  
        status = Rtl8226b_wait_for_bit(hDevice, MMD_VEND2, 0xB800, BIT_6, 1, 100);
        if (status != SUCCESS)
            goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, patchaddr);
        if (status != SUCCESS)
            goto exit;

        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x3701);
        if (status != SUCCESS)
            goto exit;

        
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, 0xB82E);
        if (status != SUCCESS)
            goto exit;

   
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, 0x0001);
        if (status != SUCCESS)
            goto exit;

      
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata |= BIT_7;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;


        for(i=0; i<sizeof(Rtl8226b_b_n0_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_b_n0_ramcode[i].dev, Rtl8226b_b_n0_ramcode[i].addr, Rtl8226b_b_n0_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

 
        for(i=0; i<sizeof(Rtl8226b_b_n1_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_b_n1_ramcode[i].dev, Rtl8226b_b_n1_ramcode[i].addr, Rtl8226b_b_n1_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

         for(i=0; i<sizeof(Rtl8226b_b_n2_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_b_n2_ramcode[i].dev, Rtl8226b_b_n2_ramcode[i].addr, Rtl8226b_b_n2_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

    
        for(i=0; i<sizeof(Rtl8226b_b_uc2_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_b_uc2_ramcode[i].dev, Rtl8226b_b_uc2_ramcode[i].addr, Rtl8226b_b_uc2_ramcode[i].value);
           
			if (status != SUCCESS)
                goto exit;
        }

       
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_7);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;


        for(i=0; i<sizeof(Rtl8226b_b_uc_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_b_uc_ramcode[i].dev, Rtl8226b_b_uc_ramcode[i].addr, Rtl8226b_b_uc_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

       
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB896, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_0);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB896, phydata);
        if (status != SUCCESS)
            goto exit;
       
        phydata = 0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB892, phydata);
        if (status != SUCCESS)
            goto exit;
       
        for(i=0; i<sizeof(Rtl8226b_b_data_ramcode)/sizeof(MMD_REG); i++)
        {
            status = MmdPhyWrite(hDevice, Rtl8226b_b_data_ramcode[i].dev, Rtl8226b_b_data_ramcode[i].addr, Rtl8226b_b_data_ramcode[i].value);
            if (status != SUCCESS)
                goto exit;
        }

        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB896, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata |= BIT_0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB896, phydata);
        if (status != SUCCESS)
            goto exit;
           
        phydata = 0x0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, phydata);
        if (status != SUCCESS)
            goto exit;

        phydata = 0x0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, phydata);
        if (status != SUCCESS)
            goto exit;
     
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB82E, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_0);
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB82E, phydata);
        if (status != SUCCESS)
            goto exit;
         
        phydata = patchaddr;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, phydata);
        if (status != SUCCESS)
            goto exit;
    
        phydata = 0x0;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, phydata);
        if (status != SUCCESS)
            goto exit;
                         
        status = MmdPhyRead(hDevice, MMD_VEND2, 0xB820, &phydata);
        if (status != SUCCESS)
            goto exit;

        phydata &= (~BIT_4);

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xB820, phydata);
        if (status != SUCCESS)
            goto exit;

        status = Rtl8226b_wait_for_bit(hDevice, MMD_VEND2, 0xB800, BIT_6, 0, 100);
        if (status != SUCCESS)
            goto exit;
                      
        phydata = 0x801E;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA436, phydata);
        if (status != SUCCESS)
            goto exit;
     
        phydata = patchver_b;
        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA438, phydata);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xac46, 0xB794);
        if (status != SUCCESS)
            goto exit;
		

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xa46A, 0x0302);
        if (status != SUCCESS)
            goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xa412, 0x0200);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xa5d4, 0x0081);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xad30, 0x0A57);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xad30, 0x0A55);
        if (status != SUCCESS)
            goto exit;


        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xa46A, 0x0300);
        if (status != SUCCESS)
            goto exit;
   
        if (singlephy)
        {
            for(i=0; i<sizeof(Rtl8226b_b_isram_patch)/sizeof(MMD_REG); i++)
            {
                status = MmdPhyWrite(hDevice, Rtl8226b_b_isram_patch[i].dev, Rtl8226b_b_isram_patch[i].addr, Rtl8226b_b_isram_patch[i].value);
                if (status != SUCCESS)
                    goto exit;
            }
        }

        //SDS mode setting start
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x75F3, 0x0000);
        if (status != SUCCESS)
            goto exit;

        status = MmdPhyRead(hDevice, MMD_VEND1, 0x697A, &phydata);
        if (status != SUCCESS)
            goto exit;
     
        phydata &= 0xFFC0;
        phydata |= SDSMode;  //write bit [5:0] = 0/1/2/3  SDS mode
        status = MmdPhyWrite(hDevice, MMD_VEND1, 0x697A, phydata);
        if (status != SUCCESS)
            goto exit;
        //SDS mode setting end

        status = MmdPhyWrite(hDevice, MMD_VEND2, 0xA400, 0x9200);
        if (status != SUCCESS)
            goto exit;
    } else {
	phy_osal_printf("nuknown EVID (VERID=%02x)\n", VERID);
	status = FAILURE;
	goto exit;
    }

exit:
    return status;
}

