/*
 * Copyright (C) 2009-2016 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision$
 * $Date$
 *
 * Purpose : Mapper Layer is used to seperate different kind of software or hardware platform
 *
 * Feature : Just dispatch information to Multiplex layer
 *
 */
#ifndef __DAL_MAPPER_H__
#define __DAL_MAPPER_H__

/*
 * Include Files
 */
#include <common/rt_autoconf.h>
#include <common/rt_type.h>
#include <common/rt_error.h>
#include <dal/dal_common.h>
#include <rtk/vlan.h>
#include <rtk/l2.h>
#include <rtk/l3.h>
#include <rtk/tunnel.h>
#include <rtk/trunk.h>
#include <rtk/stp.h>
#include <rtk/rate.h>
#include <rtk/qos.h>
#include <rtk/trap.h>
#include <rtk/stat.h>
#include <rtk/switch.h>
#include <rtk/mirror.h>
#include <rtk/flowctrl.h>
#include <rtk/sec.h>
#include <rtk/oam.h>
#include <rtk/pie.h>
#include <rtk/eee.h>
#include <rtk/led.h>
#include <rtk/time.h>
#include <rtk/acl.h>
#include <rtk/mpls.h>
#include <rtk/stack.h>
#include <rtk/diag.h>
#include <rtk/vxlan.h>
#include <rtk/openflow.h>
#include <rtk/mcast.h>
#include <rtk/ipmcast.h>
#include <rtk/bpe.h>
#include <rtk/sds.h>

/*
 * Symbol Definition
 */


/*
 * Data Declaration
 */
typedef struct dal_mapper_s {
    int32   (*_init)(uint32 );

    /* VLAN */
    int32   (*vlan_init)(uint32 );
    int32   (*vlan_create)(uint32 , rtk_vlan_t );
    int32   (*vlan_destroy)(uint32, rtk_vlan_t);
    int32   (*vlan_destroyAll)(uint32 , uint32 );
    int32   (*vlan_port_add)(uint32 , rtk_vlan_t , rtk_port_t , uint32 );
    int32   (*vlan_port_del)(uint32 , rtk_vlan_t , rtk_port_t );
    int32   (*vlan_port_get)(uint32 , rtk_vlan_t , rtk_portmask_t * , rtk_portmask_t *);
    int32   (*vlan_port_set)(uint32 , rtk_vlan_t , rtk_portmask_t *, rtk_portmask_t *);
    int32   (*vlan_mcastGroup_get)(uint32, rtk_vlan_t, rtk_mcast_group_t *);
    int32   (*vlan_mcastGroup_set)(uint32, rtk_vlan_t, rtk_mcast_group_t);
    int32   (*vlan_svlMode_get)(uint32, rtk_vlan_svlMode_t *);
    int32   (*vlan_svlMode_set)(uint32, rtk_vlan_svlMode_t);
    int32   (*vlan_svlFid_get)(uint32, rtk_vlan_t, rtk_fid_t *);
    int32   (*vlan_svlFid_set)(uint32, rtk_vlan_t, rtk_fid_t);
    int32   (*vlan_stg_get)(uint32 , rtk_vlan_t , rtk_stg_t *);
    int32   (*vlan_stg_set)(uint32 , rtk_vlan_t , rtk_stg_t );
    int32   (*vlan_l2LookupSvlFid_get)(uint32 , rtk_vlan_l2mactype_t , rtk_fid_t *);
    int32   (*vlan_l2LookupSvlFid_set)(uint32 , rtk_vlan_l2mactype_t , rtk_fid_t );
    int32   (*vlan_l2LookupMode_get)(uint32 , rtk_vlan_t , rtk_vlan_l2mactype_t, rtk_vlan_l2LookupMode_t *);
    int32   (*vlan_l2LookupMode_set)(uint32 , rtk_vlan_t , rtk_vlan_l2mactype_t, rtk_vlan_l2LookupMode_t );
    int32   (*vlan_groupMask_get)(uint32 , rtk_vlan_t , rtk_vlan_groupMask_t *);
    int32   (*vlan_groupMask_set)(uint32 , rtk_vlan_t , rtk_vlan_groupMask_t *);
    int32   (*vlan_profileIdx_get)(uint32 , rtk_vlan_t , uint32 *);
    int32   (*vlan_profileIdx_set)(uint32 , rtk_vlan_t , uint32 );
    int32   (*vlan_profile_get)(uint32 , uint32 , rtk_vlan_profile_t *);
    int32   (*vlan_profile_set)(uint32 , uint32 , rtk_vlan_profile_t *);
    int32   (*vlan_portFwdVlan_get)(uint32 , rtk_port_t , rtk_vlan_pktTagMode_t, rtk_vlanType_t*);
    int32   (*vlan_portFwdVlan_set)(uint32 , rtk_port_t , rtk_vlan_pktTagMode_t, rtk_vlanType_t);
    int32   (*vlan_portAcceptFrameType_get)(uint32 ,rtk_port_t , rtk_vlanType_t, rtk_vlan_acceptFrameType_t *);
    int32   (*vlan_portAcceptFrameType_set)(uint32 ,rtk_port_t , rtk_vlanType_t, rtk_vlan_acceptFrameType_t );
    int32   (*vlan_portIgrFilter_get)(uint32 , rtk_port_t , rtk_vlan_ifilter_t *);
    int32   (*vlan_portIgrFilter_set)(uint32 , rtk_port_t , rtk_vlan_ifilter_t);
    int32   (*vlan_portEgrFilterEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portEgrFilterEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*vlan_mcastLeakyEnable_get)(uint32 , rtk_enable_t *);
    int32   (*vlan_mcastLeakyEnable_set)(uint32 , rtk_enable_t );
    int32   (*vlan_portPvidMode_get)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_vlan_pbVlan_mode_t *);
    int32   (*vlan_portPvidMode_set)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_vlan_pbVlan_mode_t );
    int32   (*vlan_portPvid_get)(uint32 , rtk_port_t , rtk_vlanType_t, uint32 *);
    int32   (*vlan_portPvid_set)(uint32 , rtk_port_t , rtk_vlanType_t, uint32 );
    int32   (*vlan_portPrivateVlanEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*vlan_portPrivateVlanEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*vlan_protoGroup_get)(uint32 , uint32 , rtk_vlan_protoGroup_t *);
    int32   (*vlan_protoGroup_set)(uint32 , uint32 , rtk_vlan_protoGroup_t *);
    int32   (*vlan_portProtoVlan_get)(uint32 , rtk_port_t , uint32 , rtk_vlan_protoVlanCfg_t *);
    int32   (*vlan_portProtoVlan_set)(uint32 , rtk_port_t , uint32 , rtk_vlan_protoVlanCfg_t *);
    int32   (*vlan_macBasedVlan_get)(uint32 , uint32 , uint32 *, rtk_mac_t *, rtk_vlan_t *, rtk_pri_t *);
    int32   (*vlan_macBasedVlan_set)(uint32 , uint32 , uint32 , rtk_mac_t *, rtk_vlan_t, rtk_pri_t);
    int32   (*vlan_macBasedVlanWithMsk_get)(uint32 , uint32 , uint32 *, rtk_mac_t *, rtk_mac_t *, rtk_vlan_t *, rtk_pri_t *);
    int32   (*vlan_macBasedVlanWithMsk_set)(uint32 , uint32 , uint32 , rtk_mac_t *, rtk_mac_t *, rtk_vlan_t, rtk_pri_t);
    int32   (*vlan_macBasedVlanWithPort_get)(uint32 , uint32 , uint32 *, rtk_mac_t *, rtk_mac_t *, rtk_port_t *, rtk_port_t *, rtk_vlan_t *, rtk_pri_t *);
    int32   (*vlan_macBasedVlanWithPort_set)(uint32 , uint32 , uint32 , rtk_mac_t *, rtk_mac_t *, rtk_port_t , rtk_port_t , rtk_vlan_t , rtk_pri_t);
    int32   (*vlan_portMacBasedVlanEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portMacBasedVlanEnable_set)(uint32 , rtk_port_t , rtk_enable_t);
    int32   (*vlan_macBasedVlanEntry_get)(uint32 , uint32 , rtk_vlan_macVlanEntry_t *);
    int32   (*vlan_macBasedVlanEntry_set)(uint32 , uint32 , rtk_vlan_macVlanEntry_t *);
    int32   (*vlan_macBasedVlanEntry_add)(uint32, rtk_vlan_macBasedEntry_t *);
    int32   (*vlan_macBasedVlanEntry_del)(uint32, rtk_vlan_macBasedEntry_t *);
    int32   (*vlan_ipSubnetBasedVlan_get)(uint32 , uint32 , uint32 *, ipaddr_t *,  ipaddr_t *, rtk_vlan_t *, rtk_pri_t *);
    int32   (*vlan_ipSubnetBasedVlan_set)(uint32 , uint32 , uint32 , ipaddr_t , ipaddr_t , rtk_vlan_t, rtk_pri_t);
    int32   (*vlan_ipSubnetBasedVlanWithPort_get)(uint32 , uint32 , uint32 *, ipaddr_t *,  ipaddr_t *, rtk_port_t *, rtk_port_t *, rtk_vlan_t *, rtk_pri_t *);
    int32   (*vlan_ipSubnetBasedVlanWithPort_set)(uint32 , uint32 , uint32 , ipaddr_t , ipaddr_t , rtk_port_t , rtk_port_t , rtk_vlan_t, rtk_pri_t);
    int32   (*vlan_portIpSubnetBasedVlanEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portIpSubnetBasedVlanEnable_set)(uint32 , rtk_port_t , rtk_enable_t);
    int32   (*vlan_ipSubnetBasedVlanEntry_get)(uint32 , uint32 , rtk_vlan_ipSubnetVlanEntry_t *);
    int32   (*vlan_ipSubnetBasedVlanEntry_set)(uint32 , uint32 , rtk_vlan_ipSubnetVlanEntry_t *);
    int32   (*vlan_ipSubnetBasedVlanEntry_add)(uint32, rtk_vlan_ipSubnetVlanEntry_t *);
    int32   (*vlan_ipSubnetBasedVlanEntry_del)(uint32, rtk_vlan_ipSubnetVlanEntry_t *);
    int32   (*vlan_tpidEntry_get)(uint32 , rtk_vlan_tagType_t, uint32 , uint32 *);
    int32   (*vlan_tpidEntry_set)(uint32 , rtk_vlan_tagType_t, uint32 , uint32 );
    int32   (*vlan_portIgrTpid_get)(uint32 , rtk_port_t , rtk_vlanType_t, uint32 *);
    int32   (*vlan_portIgrTpid_set)(uint32 , rtk_port_t , rtk_vlanType_t, uint32 );
    int32   (*vlan_portEgrTpid_get)(uint32 , rtk_port_t , rtk_vlanType_t, uint32 *);
    int32   (*vlan_portEgrTpid_set)(uint32 , rtk_port_t , rtk_vlanType_t, uint32 );
    int32   (*vlan_portEgrTpidSrc_get)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_vlan_egrTpidSrc_t *);
    int32   (*vlan_portEgrTpidSrc_set)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_vlan_egrTpidSrc_t );
    int32   (*vlan_portIgrExtraTagEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portIgrExtraTagEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*vlan_portEgrTagSts_get)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_vlan_tagSts_t *);
    int32   (*vlan_portEgrTagSts_set)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_vlan_tagSts_t );
    int32   (*vlan_portIgrVlanTransparentEnable_get)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_enable_t *);
    int32   (*vlan_portIgrVlanTransparentEnable_set)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_enable_t );
    int32   (*vlan_portEgrVlanTransparentEnable_get)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_enable_t *);
    int32   (*vlan_portEgrVlanTransparentEnable_set)(uint32 , rtk_port_t , rtk_vlanType_t, rtk_enable_t );
    int32   (*vlan_igrVlanCnvtBlkMode_get)(uint32 , uint32 , rtk_vlan_igrVlanCnvtBlk_mode_t *);
    int32   (*vlan_igrVlanCnvtBlkMode_set)(uint32 , uint32 , rtk_vlan_igrVlanCnvtBlk_mode_t );
    int32   (*vlan_igrVlanCnvtEntry_get)(uint32 , uint32 , rtk_vlan_igrVlanCnvtEntry_t *);
    int32   (*vlan_igrVlanCnvtEntry_set)(uint32 , uint32 , rtk_vlan_igrVlanCnvtEntry_t *);
    int32   (*vlan_portIgrVlanCnvtEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portIgrVlanCnvtEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*vlan_egrVlanCnvtDblTagEnable_get)(uint32 , rtk_enable_t *);
    int32   (*vlan_egrVlanCnvtDblTagEnable_set)(uint32 , rtk_enable_t );
    int32   (*vlan_egrVlanCnvtVidSource_get)(uint32 , rtk_l2_vlanMode_t *);
    int32   (*vlan_egrVlanCnvtVidSource_set)(uint32 , rtk_l2_vlanMode_t );
    int32   (*vlan_egrVlanCnvtEntry_get)(uint32 , uint32 , rtk_vlan_egrVlanCnvtEntry_t *);
    int32   (*vlan_egrVlanCnvtEntry_set)(uint32 , uint32 , rtk_vlan_egrVlanCnvtEntry_t *);
    int32   (*vlan_portEgrVlanCnvtEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portEgrVlanCnvtEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*vlan_aggrEnable_get)(uint32, rtk_enable_t *);
    int32   (*vlan_aggrEnable_set)(uint32, rtk_enable_t);
    int32   (*vlan_portVlanAggrEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*vlan_portVlanAggrEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*vlan_portVlanAggrPriEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*vlan_portVlanAggrPriEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*vlan_portVlanAggrCtrl_get)(uint32 , rtk_port_t , rtk_vlan_aggrCtrl_t *);
    int32   (*vlan_portVlanAggrCtrl_set)(uint32 , rtk_port_t , rtk_vlan_aggrCtrl_t );
    int32   (*vlan_leakyStpFilter_get)(uint32 , rtk_enable_t *);
    int32   (*vlan_leakyStpFilter_set)(uint32 , rtk_enable_t );
    int32   (*vlan_except_get)(uint32 , rtk_action_t *);
    int32   (*vlan_except_set)(uint32 , rtk_action_t );
    int32   (*vlan_portIgrCnvtDfltAct_get)(uint32, rtk_port_t, rtk_action_t *);
    int32   (*vlan_portIgrCnvtDfltAct_set)(uint32, rtk_port_t, rtk_action_t);
    int32   (*vlan_portIgrVlanCnvtLuMisAct_get)(uint32, rtk_port_t, rtk_vlanType_t, rtk_vlan_lookupMissAct_t *);
    int32   (*vlan_portIgrVlanCnvtLuMisAct_set)(uint32, rtk_port_t, rtk_vlanType_t, rtk_vlan_lookupMissAct_t);
    int32   (*vlan_portEgrVlanCnvtLuMisAct_get)(uint32, rtk_port_t, rtk_vlanType_t, rtk_vlan_lookupMissAct_t *);
    int32   (*vlan_portEgrVlanCnvtLuMisAct_set)(uint32, rtk_port_t, rtk_vlanType_t, rtk_vlan_lookupMissAct_t);
    int32   (*vlan_igrVlanCnvtEntry_delAll)(uint32);
    int32   (*vlan_egrVlanCnvtEntry_delAll)(uint32);
    int32   (*vlan_portIgrTagKeepType_get)(uint32 , rtk_port_t , rtk_vlan_tagKeepType_t *, rtk_vlan_tagKeepType_t *);
    int32   (*vlan_portIgrTagKeepType_set)(uint32 , rtk_port_t , rtk_vlan_tagKeepType_t , rtk_vlan_tagKeepType_t );
    int32   (*vlan_portEgrTagKeepType_get)(uint32 , rtk_port_t , rtk_vlan_tagKeepType_t *, rtk_vlan_tagKeepType_t *);
    int32   (*vlan_portEgrTagKeepType_set)(uint32 , rtk_port_t , rtk_vlan_tagKeepType_t , rtk_vlan_tagKeepType_t );
    int32   (*vlan_portEgrVlanCnvtVidSource_get)(uint32 , rtk_port_t , rtk_l2_vlanMode_t *);
    int32   (*vlan_portEgrVlanCnvtVidSource_set)(uint32 , rtk_port_t , rtk_l2_vlanMode_t );
    int32   (*vlan_portEgrVlanCnvtVidTarget_get)(uint32 , rtk_port_t , rtk_l2_vlanMode_t *);
    int32   (*vlan_portEgrVlanCnvtVidTarget_set)(uint32 , rtk_port_t , rtk_l2_vlanMode_t );
    int32   (*vlan_igrVlanCnvtHitIndication_get)(uint32 , uint32 , uint32, uint32 *);
    int32   (*vlan_egrVlanCnvtHitIndication_get)(uint32 , uint32 , uint32, uint32 *);
    int32   (*vlan_portIgrVlanCnvtRangeCheckSet_get)(uint32, rtk_port_t, uint32 *);
    int32   (*vlan_portIgrVlanCnvtRangeCheckSet_set)(uint32, rtk_port_t, uint32);
    int32   (*vlan_igrVlanCnvtRangeCheckEntry_get)(uint32, uint32, uint32, rtk_vlan_vlanCnvtRangeCheck_vid_t *);
    int32   (*vlan_igrVlanCnvtRangeCheckEntry_set)(uint32, uint32, uint32, rtk_vlan_vlanCnvtRangeCheck_vid_t *);
    int32   (*vlan_portEgrVlanCnvtRangeCheckSet_get)(uint32, rtk_port_t, uint32 *);
    int32   (*vlan_portEgrVlanCnvtRangeCheckSet_set)(uint32, rtk_port_t, uint32);
    int32   (*vlan_egrVlanCnvtRangeCheckEntry_get)(uint32, uint32, uint32, rtk_vlan_vlanCnvtRangeCheck_vid_t *);
    int32   (*vlan_egrVlanCnvtRangeCheckEntry_set)(uint32, uint32, uint32, rtk_vlan_vlanCnvtRangeCheck_vid_t *);
    int32   (*vlan_ecidPmsk_add)(uint32, rtk_vlan_t, rtk_bpe_pmskEntry_t *);
    int32   (*vlan_ecidPmsk_del)(uint32, rtk_vlan_t, rtk_bpe_pmskEntry_t *);
    int32   (*vlan_ecidPmsk_get)(uint32, rtk_vlan_t, rtk_bpe_pmskEntry_t *);
    int32   (*vlan_ecidPmskNextValid_get)(uint32, rtk_vlan_t, rtk_bpe_pmskEntry_t *);
    int32   (*vlan_trkVlanAggrEnable_get)(uint32, rtk_trk_t, rtk_enable_t *);
    int32   (*vlan_trkVlanAggrEnable_set)(uint32, rtk_trk_t, rtk_enable_t);
    int32   (*vlan_trkVlanAggrPriEnable_get)(uint32, rtk_trk_t, rtk_enable_t *);
    int32   (*vlan_trkVlanAggrPriEnable_set)(uint32, rtk_trk_t, rtk_enable_t);
    int32   (*vlan_trkVlanAggrCtrl_get)(uint32, rtk_trk_t, rtk_vlan_aggrCtrl_t *);
    int32   (*vlan_trkVlanAggrCtrl_set)(uint32, rtk_trk_t, rtk_vlan_aggrCtrl_t);
    int32   (*vlan_intfId_get)(uint32, rtk_vlan_t, rtk_intf_id_t *);
    int32   (*vlan_intfId_set)(uint32, rtk_vlan_t, rtk_intf_id_t);

    /* L2 */
    int32   (*l2_init)(uint32 );
    int32   (*l2_flushLinkDownPortAddrEnable_get)(uint32 , rtk_enable_t *);
    int32   (*l2_flushLinkDownPortAddrEnable_set)(uint32 , rtk_enable_t );
    int32   (*l2_ucastAddr_flush)(uint32 , rtk_l2_flushCfg_t *);
    int32   (*l2_macLearningCnt_get)(uint32, rtk_l2_macLimitType_t, rtk_l2_macCnt_t *);
    int32   (*l2_limitLearningNum_get)(uint32, rtk_l2_macLimitType_t, rtk_l2_macCnt_t *);
    int32   (*l2_limitLearningNum_set)(uint32, rtk_l2_macLimitType_t, rtk_l2_macCnt_t *);
    int32   (*l2_limitLearningAction_get)(uint32, rtk_l2_macLimitType_t, rtk_l2_macLimitAction_t *);
    int32   (*l2_limitLearningAction_set)(uint32, rtk_l2_macLimitType_t, rtk_l2_macLimitAction_t *);
    int32   (*l2_fidLimitLearningEntry_get)(uint32 , uint32 , rtk_l2_fidMacLimitEntry_t *);
    int32   (*l2_fidLimitLearningEntry_set)(uint32 , uint32 , rtk_l2_fidMacLimitEntry_t *);
    int32   (*l2_fidLearningCnt_reset)(uint32 , uint32 );
    int32   (*l2_agingTime_get)(uint32, rtk_l2_ageTimeType_t, uint32 *);
    int32   (*l2_agingTime_set)(uint32, rtk_l2_ageTimeType_t, uint32);
    int32   (*l2_portAgingEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*l2_portAgingEnable_set)(uint32 , rtk_port_t , rtk_enable_t);
    int32   (*l2_trkAgingEnable_get)(uint32, rtk_trk_t, rtk_enable_t *);
    int32   (*l2_trkAgingEnable_set)(uint32, rtk_trk_t, rtk_enable_t);
    int32   (*l2_hashAlgo_get)(uint32 , uint32 *);
    int32   (*l2_hashAlgo_set)(uint32 , uint32 );
    int32   (*l2_bucketHashAlgo_get)(uint32, uint32, uint32 *);
    int32   (*l2_bucketHashAlgo_set)(uint32, uint32, uint32);
    int32   (*l2_vlanMode_get)(uint32 , rtk_port_t , rtk_l2_vlanMode_t *);
    int32   (*l2_vlanMode_set)(uint32 , rtk_port_t , rtk_l2_vlanMode_t );
    int32   (*l2_learningFullAction_get)(uint32, rtk_action_t *);
    int32   (*l2_learningFullAction_set)(uint32, rtk_action_t);
    int32   (*l2_portNewMacOp_get)(uint32 , rtk_port_t , rtk_l2_newMacLrnMode_t *, rtk_action_t *);
    int32   (*l2_portNewMacOp_set)(uint32 , rtk_port_t , rtk_l2_newMacLrnMode_t , rtk_action_t );
    int32   (*l2_addr_init)(uint32 , rtk_vlan_t , rtk_mac_t *, rtk_l2_ucastAddr_t *);
    int32   (*l2_addr_add)(uint32 , rtk_l2_ucastAddr_t *);
    int32   (*l2_addr_del)(uint32 , rtk_vlan_t , rtk_mac_t *);
    int32   (*l2_addr_get)(uint32 , rtk_l2_ucastAddr_t *);
    int32   (*l2_addr_set)(uint32 , rtk_l2_ucastAddr_t *);
    int32   (*l2_addr_delAll)(uint32 , uint32 );
    int32   (*l2_nextValidAddr_get)(uint32 , int32 *, uint32 , rtk_l2_ucastAddr_t *);
    int32   (*l2_mcastAddr_init)(uint32 , rtk_vlan_t , rtk_mac_t *, rtk_l2_mcastAddr_t *);
    int32   (*l2_mcastAddr_add)(uint32 , rtk_l2_mcastAddr_t *);
    int32   (*l2_mcastAddr_del)(uint32 , rtk_vlan_t , rtk_mac_t *);
    int32   (*l2_mcastAddr_get)(uint32 , rtk_l2_mcastAddr_t *);
    int32   (*l2_mcastAddr_set)(uint32 , rtk_l2_mcastAddr_t *);
    int32   (*l2_mcastAddr_addByIndex)(uint32 , rtk_l2_mcastAddr_t *);
    int32   (*l2_mcastAddr_setByIndex)(uint32 , rtk_l2_mcastAddr_t *);
    int32   (*l2_mcastAddr_delIgnoreIndex)(uint32 , rtk_vlan_t , rtk_mac_t *);
    int32   (*l2_nextValidMcastAddr_get)(uint32 , int32 *, rtk_l2_mcastAddr_t *);
    int32   (*l2_ipmcMode_get)(uint32 , rtk_l2_ipmcMode_t *);
    int32   (*l2_ipmcMode_set)(uint32 , rtk_l2_ipmcMode_t );
    int32   (*l2_ipMcastAddrExt_init)(uint32 , rtk_l2_ipMcastHashKey_t * , rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddr_add)(uint32 , rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddr_del)(uint32 , ipaddr_t , ipaddr_t , rtk_vlan_t );
    int32   (*l2_ipMcastAddr_get)(uint32 , rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddr_set)(uint32 , rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddr_addByIndex)(uint32 , rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddr_setByIndex)(uint32 , rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddr_delIgnoreIndex)(uint32 , ipaddr_t , ipaddr_t , rtk_vlan_t );
    int32   (*l2_nextValidIpMcastAddr_get)(uint32 , int32 *, rtk_l2_ipMcastAddr_t *);
    int32   (*l2_ipMcastAddrChkEnable_get)(uint32 , rtk_enable_t *);
    int32   (*l2_ipMcastAddrChkEnable_set)(uint32 , rtk_enable_t );
    int32   (*l2_ipMcstFidVidCompareEnable_get)(uint32 , rtk_enable_t *);
    int32   (*l2_ipMcstFidVidCompareEnable_set)(uint32 , rtk_enable_t );
    int32   (*l2_ip6mcMode_get)(uint32 , rtk_l2_ipmcMode_t *);
    int32   (*l2_ip6mcMode_set)(uint32 , rtk_l2_ipmcMode_t );
    int32   (*l2_ip6CareByte_get)(uint32 , rtk_l2_ip6_careByte_type_t , uint32 *);
    int32   (*l2_ip6CareByte_set)(uint32 , rtk_l2_ip6_careByte_type_t , uint32);
    int32   (*l2_ip6McastAddrExt_init)(uint32 , rtk_l2_ip6McastHashKey_t * , rtk_l2_ip6McastAddr_t *);
    int32   (*l2_ip6McastAddr_add)(uint32 , rtk_l2_ip6McastAddr_t *);
    int32   (*l2_ip6McastAddr_del)(uint32 , rtk_ipv6_addr_t , rtk_ipv6_addr_t , rtk_vlan_t );
    int32   (*l2_ip6McastAddr_get)(uint32 , rtk_l2_ip6McastAddr_t *);
    int32   (*l2_ip6McastAddr_set)(uint32 , rtk_l2_ip6McastAddr_t *);
    int32   (*l2_ip6McastAddr_addByIndex)(uint32 , rtk_l2_ip6McastAddr_t *);
    int32   (*l2_ip6McastAddr_setByIndex)(uint32 , rtk_l2_ip6McastAddr_t *);
    int32   (*l2_ip6McastAddr_delIgnoreIndex)(uint32 , rtk_ipv6_addr_t , rtk_ipv6_addr_t , rtk_vlan_t );
    int32   (*l2_nextValidIp6McastAddr_get)(uint32 , int32 *, rtk_l2_ip6McastAddr_t *);
    int32   (*l2_mcastFwdIndex_alloc)(uint32 , int32 *);
    int32   (*l2_mcastFwdIndex_free)(uint32 , int32 );
    int32   (*l2_mcastFwdIndexFreeCount_get)(uint32 , uint32 *);
    int32   (*l2_mcastFwdPortmaskEntry_get)(uint32 , int32 , rtk_portmask_t *);
    int32   (*l2_mcastFwdPortmaskEntry_set)(uint32 , int32 , rtk_portmask_t *);
    int32   (*l2_cpuMacAddr_add)(uint32 , rtk_vlan_t , rtk_mac_t *);
    int32   (*l2_cpuMacAddr_del)(uint32 , rtk_vlan_t , rtk_mac_t *);
    int32   (*l2_portMoveAction_get)(uint32, rtk_l2_portMoveType_t, rtk_l2_portMoveAct_t *);
    int32   (*l2_portMoveAction_set)(uint32, rtk_l2_portMoveType_t, rtk_l2_portMoveAct_t *);
    int32   (*l2_portMoveLearn_get)(uint32, rtk_l2_portMoveType_t, rtk_l2_portMoveLrn_t *);
    int32   (*l2_portMoveLearn_set)(uint32, rtk_l2_portMoveType_t, rtk_l2_portMoveLrn_t *);
    int32   (*l2_legalPortMoveFlushAddrEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*l2_legalPortMoveFlushAddrEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*l2_staticPortMoveAction_get)(uint32 , rtk_port_t , rtk_action_t *);
    int32   (*l2_staticPortMoveAction_set)(uint32 , rtk_port_t , rtk_action_t );
    int32   (*l2_lookupMissFloodPortMask_get)(uint32 , rtk_l2_lookupMissType_t , rtk_portmask_t *);
    int32   (*l2_lookupMissFloodPortMask_set)(uint32 , rtk_l2_lookupMissType_t , rtk_portmask_t *);
    int32   (*l2_lookupMissFloodPortMask_add)(uint32 , rtk_l2_lookupMissType_t , rtk_port_t );
    int32   (*l2_lookupMissFloodPortMask_del)(uint32 , rtk_l2_lookupMissType_t , rtk_port_t );
    int32   (*l2_lookupMissFloodPortMask_setByIndex)(uint32 , rtk_l2_lookupMissType_t , uint32, rtk_portmask_t *);
    int32   (*l2_lookupMissFloodPortMaskIdx_get)(uint32 , rtk_l2_lookupMissType_t , uint32 *);
    int32   (*l2_lookupMissFloodPortMaskIdx_set)(uint32 , rtk_l2_lookupMissType_t , uint32 );
    int32   (*l2_portLookupMissAction_get)(uint32 , rtk_port_t , rtk_l2_lookupMissType_t , rtk_action_t *);
    int32   (*l2_portLookupMissAction_set)(uint32 , rtk_port_t , rtk_l2_lookupMissType_t , rtk_action_t );
    int32   (*l2_portUcastLookupMissAction_get)(uint32, rtk_port_t, rtk_action_t *);
    int32   (*l2_portUcastLookupMissAction_set)(uint32, rtk_port_t, rtk_action_t);
    int32   (*l2_srcPortEgrFilterMask_get)(uint32 , rtk_portmask_t *);
    int32   (*l2_srcPortEgrFilterMask_set)(uint32 , rtk_portmask_t *);
    int32   (*l2_srcPortEgrFilterMask_add)(uint32 , rtk_port_t );
    int32   (*l2_srcPortEgrFilterMask_del)(uint32 , rtk_port_t );
    int32   (*l2_exceptionAddrAction_get)(uint32 , rtk_l2_exceptionAddrType_t , rtk_action_t *);
    int32   (*l2_exceptionAddrAction_set)(uint32 , rtk_l2_exceptionAddrType_t , rtk_action_t );
    int32   (*l2_addrEntry_get)(uint32 , uint32, rtk_l2_entry_t *);
    int32   (*l2_conflictAddr_get)(uint32 , rtk_l2_entry_t * , rtk_l2_entry_t * , uint32 , uint32 *);
    int32   (*l2_zeroSALearningEnable_get)(uint32 , rtk_enable_t *);
    int32   (*l2_zeroSALearningEnable_set)(uint32 , rtk_enable_t);
    int32   (*l2_secureMacMode_get)(uint32, rtk_enable_t *);
    int32   (*l2_secureMacMode_set)(uint32, rtk_enable_t);
    int32   (*l2_portDynamicPortMoveForbidEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*l2_portDynamicPortMoveForbidEnable_set)(uint32 , rtk_port_t , rtk_enable_t);
    int32   (*l2_trkDynamicPortMoveForbidEnable_get)(uint32, rtk_trk_t, rtk_enable_t *);
    int32   (*l2_trkDynamicPortMoveForbidEnable_set)(uint32, rtk_trk_t, rtk_enable_t );
    int32   (*l2_portMacFilterEnable_get)(uint32 , rtk_port_t , rtk_l2_macFilterMode_t , rtk_enable_t *);
    int32   (*l2_portMacFilterEnable_set)(uint32 , rtk_port_t , rtk_l2_macFilterMode_t , rtk_enable_t);
    int32   (*l2_hwNextValidAddr_get)(uint32, int32 *, rtk_l2_nextValidType_t , rtk_l2_entry_t  *);
    int32   (*l2_portCtrl_get)(uint32, rtk_port_t, rtk_l2_portCtrlType_t, int32 *);
    int32   (*l2_portCtrl_set)(uint32, rtk_port_t, rtk_l2_portCtrlType_t, int32);
    int32   (*l2_status_get)(uint32, rtk_l2_stsType_t, uint32, uint32 *);
    int32   (*l2_stkLearningEnable_get)(uint32, rtk_enable_t *);
    int32   (*l2_stkLearningEnable_set)(uint32, rtk_enable_t);
    int32   (*l2_stkKeepUcastEntryValid_get)(uint32, rtk_enable_t *);
    int32   (*l2_stkKeepUcastEntryValid_set)(uint32, rtk_enable_t);
    int32   (*l2_entryCnt_get)(uint32, rtk_l2_entryType_t, uint32 *);
    int32   (*l2_hashIdx_get)(uint32, rtk_l2_macHashIdx_t *);
    int32   (*l2_addr_delByMac)(uint32, uint32 include_static, rtk_mac_t *);
    int32   (*l2_semUnlock)(uint32);
    int32   (*l2_semLock)(uint32);

    /* PORT */
    int32   (*port_init)(uint32 );
    int32   (*port_link_get)(uint32 , rtk_port_t , rtk_port_linkStatus_t *);
    int32   (*port_speedDuplex_get)(uint32 , rtk_port_t , rtk_port_speed_t *, rtk_port_duplex_t *);
    int32   (*port_flowctrl_get)(uint32 , rtk_port_t , uint32 *, uint32 *);
    int32   (*port_cpuPortId_get)(uint32 , rtk_port_t *);
    int32   (*port_isolation_get)(uint32 , rtk_port_t , rtk_portmask_t *);
    int32   (*port_isolation_set)(uint32 , rtk_port_t , rtk_portmask_t *);
    int32   (*port_isolationExt_get)(uint32 , uint32 , rtk_port_t , rtk_portmask_t *);
    int32   (*port_isolationExt_set)(uint32 , uint32 , rtk_port_t , rtk_portmask_t *);
    int32   (*port_isolation_add)(uint32 , rtk_port_t , rtk_port_t );
    int32   (*port_isolation_del)(uint32 , rtk_port_t , rtk_port_t );
    int32   (*port_isolationRestrictRoute_get)(uint32 , rtk_enable_t *);
    int32   (*port_isolationRestrictRoute_set)(uint32 , rtk_enable_t );
    int32   (*port_adminEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_adminEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_backpressureEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_backpressureEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_linkChange_register)(uint32, dal_link_change_callback_f);
    int32   (*port_linkChange_unregister)(uint32);
    int32   (*port_txEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_txEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_rxEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_rxEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_specialCongest_get)(uint32 , rtk_port_t , uint32* );
    int32   (*port_specialCongest_set)(uint32 , rtk_port_t , uint32 );
    int32   (*port_flowCtrlEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_flowCtrlEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_linkMedia_get)(uint32 , rtk_port_t , rtk_port_linkStatus_t *, rtk_port_media_t *);
    int32   (*port_vlanBasedIsolationEntry_get)(uint32 , uint32 , rtk_port_vlanIsolationEntry_t *);
    int32   (*port_vlanBasedIsolationEntry_set)(uint32 , uint32 , rtk_port_vlanIsolationEntry_t *);
    int32   (*port_vlanBasedIsolation_vlanSource_get)(uint32 , rtk_port_vlanIsolationSrc_t *);
    int32   (*port_vlanBasedIsolation_vlanSource_set)(uint32 , rtk_port_vlanIsolationSrc_t);
    int32   (*port_vlanBasedIsolationEgrBypass_get)(uint32 , rtk_port_t, rtk_enable_t *);
    int32   (*port_vlanBasedIsolationEgrBypass_set)(uint32 , rtk_port_t, rtk_enable_t);
    int32   (*port_fiberUnidirEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*port_fiberUnidirEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_fiberOAMLoopBackEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_macForceFc_set)(uint32, rtk_port_t, rtk_enable_t, rtk_enable_t, rtk_enable_t);
    int32   (*port_macForceFc_get)(uint32, rtk_port_t, rtk_enable_t *, rtk_enable_t *, rtk_enable_t *);
    int32   (*_port_macForceLink_get)(uint32, rtk_port_t, rtk_enable_t*, rtk_port_linkStatus_t*);
    int32   (*_port_macForceLink_set)(uint32, rtk_port_t, rtk_enable_t, rtk_port_linkStatus_t,rtk_port_media_chg_t);

    /* PHY */
    int32   (*phy_init)(uint32 );
    int32   (*port_phyAutoNegoEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_phyMasterSlave_get)(uint32 , rtk_port_t, rtk_port_masterSlave_t *, rtk_port_masterSlave_t *);
    int32   (*port_phyMasterSlave_set)(uint32 , rtk_port_t, rtk_port_masterSlave_t );
    int32   (*port_gigaLiteEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_gigaLiteEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_phy2pt5gLiteEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_phy2pt5gLiteEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_phyReg_get)(uint32 , rtk_port_t , uint32 , rtk_port_phy_reg_t , uint32 *);
    int32   (*port_phyReg_set)(uint32 , rtk_port_t , uint32 , rtk_port_phy_reg_t , uint32 );
    int32   (*port_phyExtParkPageReg_get)(uint32 , rtk_port_t , uint32 , uint32 , uint32 , rtk_port_phy_reg_t , uint32 *);
    int32   (*port_phyExtParkPageReg_set)(uint32 , rtk_port_t , uint32 , uint32 , uint32 , rtk_port_phy_reg_t , uint32);
    int32   (*port_phymaskExtParkPageReg_set)(uint32 , rtk_portmask_t *, uint32 , uint32 , uint32 , rtk_port_phy_reg_t , uint32);
    int32   (*port_phyMmdReg_get)(uint32 , rtk_port_t , uint32 , uint32 , uint32 *);
    int32   (*port_phyMmdReg_set)(uint32 , rtk_port_t , uint32 , uint32 , uint32);
    int32   (*port_phymaskMmdReg_set)(uint32 , rtk_portmask_t *, uint32 , uint32 , uint32);
    int32   (*port_phyComboPortMedia_get)(uint32 , rtk_port_t , rtk_port_media_t *);
    int32   (*port_phyComboPortMedia_set)(uint32 , rtk_port_t , rtk_port_media_t );
    int32   (*port_greenEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_greenEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_phyCrossOverMode_get)(uint32 , rtk_port_t , rtk_port_crossOver_mode_t *);
    int32   (*port_phyCrossOverMode_set)(uint32 , rtk_port_t , rtk_port_crossOver_mode_t );
    int32   (*port_phyCrossOverStatus_get)(uint32 , rtk_port_t , rtk_port_crossOver_status_t *);
    int32   (*port_phyComboPortFiberMedia_get)(uint32 , rtk_port_t , rtk_port_fiber_media_t *);
    int32   (*port_phyComboPortFiberMedia_set)(uint32 , rtk_port_t , rtk_port_fiber_media_t );
    int32   (*port_linkDownPowerSavingEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_linkDownPowerSavingEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_downSpeedEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*port_downSpeedEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_downSpeedStatus_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*port_fiberDownSpeedEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*port_fiberDownSpeedEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_fiberNwayForceLinkEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*port_fiberNwayForceLinkEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_phyLoopBackEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*port_phyLoopBackEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_phyFiberTxDis_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_phyFiberTxDisPin_set)(uint32, rtk_port_t, uint32);
    int32   (*port_phyForceModeAbility_get)(uint32 , rtk_port_t , rtk_port_speed_t *, rtk_port_duplex_t *, rtk_enable_t *);
    int32   (*port_phyForceModeAbility_set)(uint32 , rtk_port_t , rtk_port_speed_t , rtk_port_duplex_t , rtk_enable_t );
    int32   (*port_phyForceFlowctrlMode_get)(uint32 , rtk_port_t , rtk_port_flowctrl_mode_t *);
    int32   (*port_phyForceFlowctrlMode_set)(uint32 , rtk_port_t , rtk_port_flowctrl_mode_t *);
    int32   (*port_phyAutoNegoEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_phyAutoNegoAbilityLocal_get)(uint32, rtk_port_t, rtk_port_phy_ability_t *);
    int32   (*port_phyAutoNegoAbility_get)(uint32 , rtk_port_t , rtk_port_phy_ability_t *);
    int32   (*port_phyAutoNegoAbility_set)(uint32 , rtk_port_t , rtk_port_phy_ability_t *);
    int32   (*port_fiberRxEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*port_fiberRxEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*port_10gMedia_get)(uint32, rtk_port_t, rtk_port_10gMedia_t *);
    int32   (*port_10gMedia_set)(uint32, rtk_port_t, rtk_port_10gMedia_t);
    int32   (*port_phyIeeeTestMode_set)(uint32, rtk_port_t, rtk_port_phyTestMode_t *);
    int32   (*port_phyPolar_get)(uint32, rtk_port_t, rtk_port_phyPolarCtrl_t *);
    int32   (*port_phyPolar_set)(uint32, rtk_port_t, rtk_port_phyPolarCtrl_t *);
    int32   (*port_phyEyeMonitor_start)(uint32, rtk_port_t, uint32, uint32);
    int32   (*port_phyEyeMonitorInfo_get)(uint32, rtk_port_t, uint32, uint32, rtk_sds_eyeMonInfo_t *);
    int32   (*port_imageFlash_load)(uint32, rtk_port_t, uint32, uint8 *);
    int32   (*port_phySds_get)(uint32, rtk_port_t, rtk_sdsCfg_t *);
    int32   (*port_phySds_set)(uint32, rtk_port_t, rtk_sdsCfg_t *);
    int32   (*port_phySdsRxCaliStatus_get)(uint32, rtk_port_t, uint32, rtk_port_phySdsRxCaliStatus_t *);
    int32   (*port_phyReset_set)(uint32, rtk_port_t);
    int32   (*port_phyLinkStatus_get)(uint32, rtk_port_t, rtk_port_linkStatus_t *);
    int32   (*port_phyPeerAutoNegoAbility_get)(uint32, rtk_port_t, rtk_port_phy_ability_t *);
    int32   (*port_phyMacIntfSerdesMode_get)(uint32, rtk_port_t, rt_serdesMode_t *);
    int32   (*port_phyLedMode_set)(uint32 unit, rtk_port_t port, rtk_phy_ledMode_t *);
    int32   (*port_phyLedCtrl_get)(uint32, rtk_port_t, rtk_phy_ledCtrl_t *);
    int32   (*port_phyLedCtrl_set)(uint32, rtk_port_t, rtk_phy_ledCtrl_t *);
    int32   (*port_phyMacIntfSerdesLinkStatus_get)(uint32, rtk_port_t, rtk_phy_macIntfSdsLinkStatus_t *);
    int32   (*port_phySdsEyeParam_get)(uint32, rtk_port_t, uint32, rtk_sds_eyeParam_t *);
    int32   (*port_phySdsEyeParam_set)(uint32, rtk_port_t, uint32, rtk_sds_eyeParam_t *);
    int32   (*port_phyMdiLoopbackEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*port_phyMdiLoopbackEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*port_phyIntr_init)(uint32, rtk_port_t, rtk_phy_intr_t);
    int32   (*port_phyIntrEnable_get)(uint32, rtk_port_t, rtk_phy_intr_status_t, rtk_enable_t *);
    int32   (*port_phyIntrEnable_set)(uint32, rtk_port_t, rtk_phy_intr_status_t, rtk_enable_t);
    int32   (*port_phyIntrStatus_get)(uint32, rtk_port_t, rtk_phy_intr_t, rtk_phy_intrStatusVal_t *);
    int32   (*port_phyIntrMask_get)(uint32, rtk_port_t, rtk_phy_intr_t, uint32 *);
    int32   (*port_phyIntrMask_set)(uint32, rtk_port_t, rtk_phy_intr_t, uint32);
    int32   (*port_phySdsTestMode_set)(uint32, rtk_port_t, uint32, rtk_sds_testMode_t);
    int32   (*port_phySdsTestModeCnt_get)(uint32, rtk_port_t, uint32, uint32 *);
    int32   (*port_phySdsLeq_get)(uint32, rtk_port_t, uint32, rtk_enable_t *, uint32 *);
    int32   (*port_phySdsLeq_set)(uint32, rtk_port_t, uint32, rtk_enable_t, uint32);
    int32   (*port_phyCtrl_get)(uint32, rtk_port_t, rtk_phy_ctrl_t, uint32 *);
    int32   (*port_phyCtrl_set)(uint32, rtk_port_t, rtk_phy_ctrl_t, uint32);
    int32   (*port_phyLiteEnable_get)(uint32, rtk_port_t, rtk_port_lite_mode_t, rtk_enable_t *);
    int32   (*port_phyLiteEnable_set)(uint32, rtk_port_t, rtk_port_lite_mode_t, rtk_enable_t);
    int32   (*port_phyDbgCounter_get)(uint32, rtk_port_t, rtk_port_phy_dbg_cnt_t, uint64 *);

#if 0
    int32   (*diag_rtctEnable_set = dal_phy_rtctEnable_set;
    int32   (*diag_portRtctResult_get = dal_phy_portRtctResult_get;
    int32   (*time_portPtpEnable_get = dal_phy_portPtpEnable_get;
    int32   (*time_portPtpEnable_set = dal_phy_portPtpEnable_set;
    int32   (*time_portPtpRxTimestamp_get = dal_phy_portPtpRxTimestamp_get;
    int32   (*time_portPtpTxTimestamp_get = dal_phy_portPtpTxTimestamp_get;
    int32   (*time_portRefTime_get = dal_phy_portRefTime_get;
    int32   (*time_portRefTime_set = dal_phy_portRefTime_set;
    int32   (*time_portRefTimeAdjust_set = dal_phy_portRefTimeAdjust_set;
    int32   (*time_portRefTimeEnable_get = dal_phy_portRefTimeEnable_get;
    int32   (*time_portRefTimeEnable_set = dal_phy_portRefTimeEnable_set;
    int32   (*time_portRefTimeFreq_get = dal_phy_portRefTimeFreq_get;
    int32   (*time_portRefTimeFreq_set = dal_phy_portRefTimeFreq_set;
    int32   (*time_portPtpMacAddr_get = dal_phy_portSwitchMacAddr_get;
    int32   (*time_portPtpMacAddr_set = dal_phy_portSwitchMacAddr_set;
    int32   (*time_portPtpMacAddrRange_get = dal_phy_portPtpMacAddrRange_get;
    int32   (*time_portPtpMacAddrRange_set = dal_phy_portPtpMacAddrRange_set;
    int32   (*time_portPtpVlanTpid_get = dal_phy_portPtpVlanTpid_get;
    int32   (*time_portPtpVlanTpid_set = dal_phy_portPtpVlanTpid_set;
    int32   (*time_portPtpOper_get = dal_phy_portPtpOper_get;
    int32   (*time_portPtpOper_set = dal_phy_portPtpOper_set;
    int32   (*time_portPtpLatchTime_get = dal_phy_portPtpLatchTime_get;
#endif
    
    /* trunk function */
    int32   (*trunk_init)(uint32 );
    int32   (*trunk_mode_get)(uint32 , rtk_trunk_mode_t *);
    int32   (*trunk_mode_set)(uint32 , rtk_trunk_mode_t );
    int32   (*trunk_port_get)(uint32 , uint32 , rtk_portmask_t *);
    int32   (*trunk_port_set)(uint32 , uint32 , rtk_portmask_t *);
    int32   (*trunk_localPort_get) (uint32 , rtk_trk_t , rtk_portmask_t *);
    int32   (*trunk_localPort_set)(uint32 , rtk_trk_t , rtk_portmask_t *);
    int32   (*trunk_egrPort_get)(uint32 , rtk_trk_t , rtk_trk_egrPort_t *);
    int32   (*trunk_egrPort_set)(uint32 , rtk_trk_t , rtk_trk_egrPort_t *);
    int32   (*trunk_tunnelHashSrc_get)(uint32 , rtk_trunk_tunnelHashSrc_t *);
    int32   (*trunk_tunnelHashSrc_set)(uint32 , rtk_trunk_tunnelHashSrc_t );
    int32   (*trunk_distributionAlgorithmBind_get)(uint32, uint32, uint32*);
    int32   (*trunk_distributionAlgorithmBind_set)(uint32, uint32, uint32);
    int32   (*trunk_distributionAlgorithmTypeBind_get)(uint32, uint32, rtk_trunk_bindType_t, uint32*);
    int32   (*trunk_distributionAlgorithmTypeBind_set)(uint32, uint32, rtk_trunk_bindType_t, uint32);
    int32   (*trunk_distributionAlgorithmParam_get)(uint32, uint32, uint32*);
    int32   (*trunk_distributionAlgorithmParam_set)(uint32, uint32, uint32);
    int32   (*trunk_distributionAlgorithmTypeParam_get)(uint32, rtk_trunk_hashParamType_t, uint32, uint32*);
    int32   (*trunk_distributionAlgorithmTypeParam_set)(uint32, rtk_trunk_hashParamType_t, uint32, uint32);
    int32   (*trunk_distributionAlgorithmShift_get)(uint32, uint32, rtk_trunk_distAlgoShift_t *);
    int32   (*trunk_distributionAlgorithmShift_set)(uint32, uint32, rtk_trunk_distAlgoShift_t *);
    int32   (*trunk_distributionAlgorithmShiftGbl_get)(uint32 , rtk_trunk_distAlgoShift_t *);
    int32   (*trunk_distributionAlgorithmShiftGbl_set)(uint32 , rtk_trunk_distAlgoShift_t *);
    int32   (*trunk_trafficSeparate_get)(uint32, uint32, uint32 *);
    int32   (*trunk_trafficSeparate_set)(uint32, uint32, uint32);
    int32   (*trunk_trafficSeparateEnable_get)(uint32 , rtk_trk_t , rtk_trunk_separateType_t , rtk_enable_t *);
    int32   (*trunk_trafficSeparateEnable_set)(uint32 , rtk_trk_t , rtk_trunk_separateType_t , rtk_enable_t );
    int32   (*trunk_trafficSeparateDivision_get)(uint32 , rtk_enable_t *);
    int32   (*trunk_trafficSeparateDivision_set)(uint32 , rtk_enable_t );
    int32   (*trunk_stkTrkPort_get)(uint32 , rtk_stk_trk_t , rtk_portmask_t *);
    int32   (*trunk_stkTrkPort_set)(uint32 , rtk_stk_trk_t , rtk_portmask_t *);
    int32   (*trunk_stkTrkHash_get)(uint32 , rtk_trunk_stkTrkHash_t *);
    int32   (*trunk_stkTrkHash_set)(uint32 , rtk_trunk_stkTrkHash_t );
    int32   (*trunk_stkDistributionAlgorithmTypeBind_get)(uint32, rtk_stk_trk_t, rtk_trunk_bindType_t, uint32 *);
    int32   (*trunk_stkDistributionAlgorithmTypeBind_set)(uint32, rtk_stk_trk_t, rtk_trunk_bindType_t, uint32);
    int32   (*trunk_localFirst_get)(uint32, rtk_enable_t *);
    int32   (*trunk_localFirst_set)(uint32, rtk_enable_t);
    int32   (*trunk_localFirstFailOver_get)(uint32, rtk_enable_t *, rtk_enable_t *);
    int32   (*trunk_localFirstFailOver_set)(uint32, rtk_enable_t, rtk_enable_t);
    int32   (*trunk_srcPortMap_get)(uint32, rtk_dev_port_t, uint32 *, rtk_trk_t *);
    int32   (*trunk_srcPortMap_set)(uint32, rtk_dev_port_t, uint32, rtk_trk_t);

    /* BPE */
    int32   (*bpe_init)(uint32);
    int32   (*bpe_portFwdMode_get)(uint32, rtk_port_t, rtk_bpe_fwdMode_t *);
    int32   (*bpe_portFwdMode_set)(uint32, rtk_port_t, rtk_bpe_fwdMode_t);
    int32   (*bpe_portEcidNameSpaceGroupId_get)(uint32, rtk_port_t, uint32 *);
    int32   (*bpe_portEcidNameSpaceGroupId_set)(uint32, rtk_port_t, uint32);
    int32   (*bpe_portPcid_get)(uint32, rtk_port_t, rtk_bpe_pcidCfgType_t, rtk_bpe_ecid_t *);
    int32   (*bpe_portPcid_set)(uint32, rtk_port_t, rtk_bpe_pcidCfgType_t, rtk_bpe_ecid_t);
    int32   (*bpe_portPcidAct_get)(uint32, rtk_port_t, rtk_action_t *);
    int32   (*bpe_portPcidAct_set)(uint32, rtk_port_t, rtk_action_t);
    int32   (*bpe_portEgrTagSts_get)(uint32, rtk_port_t, rtk_bpe_tagSts_t *);
    int32   (*bpe_portEgrTagSts_set)(uint32, rtk_port_t, rtk_bpe_tagSts_t);
    int32   (*bpe_portEgrVlanTagSts_get)(uint32, rtk_port_t, rtk_bpe_vlanTagSts_t *);
    int32   (*bpe_portEgrVlanTagSts_set)(uint32, rtk_port_t, rtk_bpe_vlanTagSts_t);
    int32   (*bpe_pvidEntry_add)(uint32, rtk_bpe_pvidEntry_t *);
    int32   (*bpe_pvidEntry_del)(uint32, rtk_bpe_pvidEntry_t *);
    int32   (*bpe_pvidEntry_get)(uint32, rtk_bpe_pvidEntry_t *);
    int32   (*bpe_pvidEntryNextValid_get)(uint32, int32 *, rtk_bpe_pvidEntry_t *);
    int32   (*bpe_fwdEntry_add)(uint32, rtk_bpe_fwdEntry_t *);
    int32   (*bpe_fwdEntry_del)(uint32, rtk_bpe_fwdEntry_t *);
    int32   (*bpe_fwdEntry_get)(uint32, rtk_bpe_fwdEntry_t *);
    int32   (*bpe_fwdEntryNextValid_get)(uint32, int32 *, rtk_bpe_fwdEntry_t *);
    int32   (*bpe_globalCtrl_get)(uint32, rtk_bpe_globalCtrlType_t, int32 *);
    int32   (*bpe_globalCtrl_set)(uint32, rtk_bpe_globalCtrlType_t, int32);
    int32   (*bpe_portCtrl_get)(uint32, rtk_port_t, rtk_bpe_portCtrlType_t, int32 *);
    int32   (*bpe_portCtrl_set)(uint32, rtk_port_t, rtk_bpe_portCtrlType_t, int32);
    int32   (*bpe_priRemarking_get)(uint32, rtk_bpe_priRmkSrc_t, rtk_bpe_priRmkVal_t, rtk_pri_t *);
    int32   (*bpe_priRemarking_set)(uint32, rtk_bpe_priRmkSrc_t, rtk_bpe_priRmkVal_t, rtk_pri_t);

    /* spanning tree API */
    int32   (*stp_init)(uint32 );
    int32   (*stp_mstpInstance_create)(uint32 , uint32 );
    int32   (*stp_mstpInstance_destroy)(uint32 , uint32 );
    int32   (*stp_isMstpInstanceExist_get)(uint32 , uint32 , uint32 *);
    int32   (*stp_mstpState_get)(uint32 , uint32 , rtk_port_t , rtk_stp_state_t *);
    int32   (*stp_mstpState_set)(uint32 , uint32 , rtk_port_t , rtk_stp_state_t );
    int32   (*stp_mstpInstanceMode_get)(uint32 , rtk_stp_mstiMode_t *);
    int32   (*stp_mstpInstanceMode_set)(uint32 , rtk_stp_mstiMode_t );

    /* rate API */
    int32   (*rate_init)(uint32);
    int32   (*rate_includeIfg_get)(uint32, rtk_rate_module_t, rtk_enable_t *);
    int32   (*rate_includeIfg_set)(uint32, rtk_rate_module_t, rtk_enable_t);
    int32   (*rate_portIgrBwCtrlEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*rate_portIgrBwCtrlEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*rate_portIgrBwCtrlRate_get)(uint32, rtk_port_t, uint32 *);
    int32   (*rate_portIgrBwCtrlRate_set)(uint32, rtk_port_t, uint32);
    int32   (*rate_igrBandwidthLowThresh_get)(uint32, uint32 *);
    int32   (*rate_igrBandwidthLowThresh_set)(uint32, uint32);
    int32   (*rate_portIgrBandwidthHighThresh_get)(uint32, rtk_port_t, uint32 *);
    int32   (*rate_portIgrBandwidthHighThresh_set)(uint32, rtk_port_t, uint32);
    int32   (*rate_igrBwCtrlBurstSize_get)(uint32, uint32 *);
    int32   (*rate_igrBwCtrlBurstSize_set)(uint32, uint32);
    int32   (*rate_igrPortBwCtrlBurstSize_get)(uint32, uint32 *);
    int32   (*rate_igrPortBwCtrlBurstSize_set)(uint32, uint32);
    int32   (*rate_portIgrBwCtrlBurstSize_get)(uint32, rtk_port_t, rtk_rate_igrBwBurst_cfg_t *);
    int32   (*rate_portIgrBwCtrlBurstSize_set)(uint32, rtk_port_t, rtk_rate_igrBwBurst_cfg_t *);
    int32   (*rate_portIgrBandwidthCtrlExceed_get)(uint32, rtk_port_t , uint32 *);
    int32   (*rate_portIgrBandwidthCtrlExceed_reset)(uint32, rtk_port_t);
    int32   (*rate_igrBandwidthCtrlBypass_get)(uint32, rtk_rate_igr_bypassType_t, rtk_enable_t *);
    int32   (*rate_igrBandwidthCtrlBypass_set)(uint32, rtk_rate_igr_bypassType_t, rtk_enable_t);
    int32   (*rate_portIgrBwFlowctrlEnable_get)(uint32, rtk_port_t, rtk_enable_t * );
    int32   (*rate_portIgrBwFlowctrlEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*rate_portIgrQueueBwCtrlEnable_get)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t *);
    int32   (*rate_portIgrQueueBwCtrlEnable_set)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t);
    int32   (*rate_portIgrQueueBwCtrlRate_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portIgrQueueBwCtrlRate_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*rate_igrQueueBwCtrlBurstSize_get)(uint32, uint32 *);
    int32   (*rate_igrQueueBwCtrlBurstSize_set)(uint32, uint32);
    int32   (*rate_portIgrQueueBwCtrlBurstSize_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portIgrQueueBwCtrlBurstSize_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*rate_portIgrQueueBwCtrlExceed_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portIgrQueueBwCtrlExceed_reset)(uint32, rtk_port_t, rtk_qid_t);
    int32   (*rate_portEgrBwCtrlEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*rate_portEgrBwCtrlEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*rate_portEgrBwCtrlRate_get)(uint32, rtk_port_t, uint32 *);
    int32   (*rate_portEgrBwCtrlRate_set)(uint32, rtk_port_t, uint32);
    int32   (*rate_portEgrBwCtrlBurstSize_get)(uint32, rtk_port_t, uint32 *);
    int32   (*rate_portEgrBwCtrlBurstSize_set)(uint32, rtk_port_t, uint32);
    int32   (*rate_cpuEgrBandwidthCtrlRateMode_get)(uint32, rtk_rate_rateMode_t *);
    int32   (*rate_cpuEgrBandwidthCtrlRateMode_set)(uint32, rtk_rate_rateMode_t);
    int32   (*rate_egrPortBwCtrlBurstSize_get)(uint32, uint32 *);
    int32   (*rate_egrPortBwCtrlBurstSize_set)(uint32, uint32);
    int32   (*rate_portEgrQueueBwCtrlEnable_get)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t *);
    int32   (*rate_portEgrQueueBwCtrlEnable_set)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t);
    int32   (*rate_portEgrQueueBwCtrlRate_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portEgrQueueBwCtrlRate_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*rate_portEgrQueueBwCtrlBurstSize_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portEgrQueueBwCtrlBurstSize_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*rate_portEgrQueueAssuredBwCtrlEnable_get)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t *);
    int32   (*rate_portEgrQueueAssuredBwCtrlEnable_set)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t);
    int32   (*rate_portEgrQueueAssuredBwCtrlRate_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portEgrQueueAssuredBwCtrlRate_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*rate_portEgrQueueAssuredBwCtrlBurstSize_get)(uint32, rtk_port_t, rtk_qid_t, uint32 *);
    int32   (*rate_portEgrQueueAssuredBwCtrlBurstSize_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*rate_portEgrQueueAssuredBwCtrlMode_get)(uint32, rtk_port_t, rtk_qid_t, rtk_rate_assuredMode_t *);
    int32   (*rate_portEgrQueueAssuredBwCtrlMode_set)(uint32, rtk_port_t, rtk_qid_t, rtk_rate_assuredMode_t);
    int32   (*rate_egrQueueFixedBandwidthEnable_get)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t *);
    int32   (*rate_egrQueueFixedBandwidthEnable_set)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t);
    int32   (*rate_egrQueueBwCtrlBurstSize_get)(uint32, uint32 *);
    int32   (*rate_egrQueueBwCtrlBurstSize_set)(uint32, uint32);
    int32   (*rate_portStormCtrlEnable_get)(uint32, rtk_port_t, rtk_rate_storm_group_t, rtk_enable_t *);
    int32   (*rate_portStormCtrlEnable_set)(uint32, rtk_port_t, rtk_rate_storm_group_t, rtk_enable_t);
    int32   (*rate_portStormCtrlRate_get)(uint32, rtk_port_t, rtk_rate_storm_group_t, uint32 *);
    int32   (*rate_portStormCtrlRate_set)(uint32, rtk_port_t, rtk_rate_storm_group_t, uint32);
    int32   (*rate_stormControlBurstSize_get)(uint32, rtk_rate_storm_group_t, uint32 *);
    int32   (*rate_stormControlBurstSize_set)(uint32, rtk_rate_storm_group_t, uint32);
    int32   (*rate_portStormCtrlBurstSize_get)(uint32, rtk_port_t, rtk_rate_storm_group_t, uint32 *);
    int32   (*rate_portStormCtrlBurstSize_set)(uint32, rtk_port_t, rtk_rate_storm_group_t, uint32);
    int32   (*rate_portStormCtrlExceed_get)(uint32, rtk_port_t, rtk_rate_storm_group_t, uint32 *);
    int32   (*rate_portStormCtrlExceed_reset)(uint32, rtk_port_t, rtk_rate_storm_group_t);
    int32   (*rate_stormControlRateMode_get)(uint32, rtk_rate_storm_rateMode_t *);
    int32   (*rate_stormControlRateMode_set)(uint32, rtk_rate_storm_rateMode_t);
    int32   (*rate_portStormCtrlRateMode_get)(uint32, rtk_port_t, rtk_rate_storm_rateMode_t *);
    int32   (*rate_portStormCtrlRateMode_set)(uint32, rtk_port_t, rtk_rate_storm_rateMode_t);
    int32   (*rate_portStormCtrlTypeSel_get)(uint32, rtk_port_t, rtk_rate_storm_group_t, rtk_rate_storm_sel_t *);
    int32   (*rate_portStormCtrlTypeSel_set)(uint32, rtk_port_t, rtk_rate_storm_group_t, rtk_rate_storm_sel_t);
    int32   (*rate_stormControlBypass_get)(uint32, rtk_rate_storm_bypassType_t, rtk_enable_t  *);
    int32   (*rate_stormControlBypass_set)(uint32, rtk_rate_storm_bypassType_t, rtk_enable_t);
    int32   (*rate_portStormCtrlProtoEnable_get)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, rtk_enable_t *);
    int32   (*rate_portStormCtrlProtoEnable_set)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, rtk_enable_t);
    int32   (*rate_portStormCtrlProtoRate_get)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, uint32 *);
    int32   (*rate_portStormCtrlProtoRate_set)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, uint32);
    int32   (*rate_portStormCtrlProtoBurstSize_get)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, uint32 *);
    int32   (*rate_portStormCtrlProtoBurstSize_set)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, uint32);
    int32   (*rate_portStormCtrlProtoExceed_get)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t, uint32 *);
    int32   (*rate_portStormCtrlProtoExceed_reset)(uint32, rtk_port_t, rtk_rate_storm_proto_group_t);
    int32   (*rate_stormCtrlProtoVlanConstrtEnable_get)(uint32, rtk_rate_storm_proto_group_t, rtk_enable_t *);
    int32   (*rate_stormCtrlProtoVlanConstrtEnable_set)(uint32, rtk_rate_storm_proto_group_t, rtk_enable_t);

    /* qos API */
    int32   (*qos_init)(uint32 , uint32 );
    int32   (*qos_priSelGroup_get)(uint32 , uint32 , rtk_qos_priSelWeight_t *);
    int32   (*qos_priSelGroup_set)(uint32 , uint32 , rtk_qos_priSelWeight_t *);
    int32   (*qos_portPriSelGroup_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*qos_portPriSelGroup_set)(uint32 , rtk_port_t , uint32 );
    int32   (*qos_dpSrcSel_get)(uint32 , rtk_qos_dpSrc_t * );
    int32   (*qos_dpSrcSel_set)(uint32 , rtk_qos_dpSrc_t );
    int32   (*qos_portDEISrcSel_get)(uint32 , rtk_port_t , rtk_qos_deiSel_t * );
    int32   (*qos_portDEISrcSel_set)(uint32 , rtk_port_t , rtk_qos_deiSel_t );
    int32   (*qos_portDpSel_get)(uint32 , rtk_port_t , rtk_qos_dpSelWeight_t * );
    int32   (*qos_portDpSel_set)(uint32 , rtk_port_t , rtk_qos_dpSelWeight_t * );
    int32   (*qos_deiDpRemap_get)(uint32 , uint32 , uint32 * );
    int32   (*qos_deiDpRemap_set)(uint32 , uint32 , uint32 );
    int32   (*qos_dpRemap_get)(uint32 , rtk_qos_dpSrc_t , rtk_qos_dpSrcRemap_t , uint32 * );
    int32   (*qos_dpRemap_set)(uint32 , rtk_qos_dpSrc_t , rtk_qos_dpSrcRemap_t , uint32 );
    int32   (*qos_portInnerPri_get)(uint32 , rtk_port_t , rtk_pri_t *);
    int32   (*qos_portInnerPri_set)(uint32 , rtk_port_t , rtk_pri_t );
    int32   (*qos_portOuterPri_get)(uint32 , rtk_port_t , rtk_pri_t *);
    int32   (*qos_portOuterPri_set)(uint32 , rtk_port_t , rtk_pri_t );
    int32   (*qos_priRemap_get)(uint32 , rtk_qos_priSrc_t , rtk_qos_priSrcRemap_t , uint32 * );
    int32   (*qos_priRemap_set)(uint32 , rtk_qos_priSrc_t , rtk_qos_priSrcRemap_t , uint32 );
    int32   (*qos_queueNum_get)(uint32 , uint32 *);
    int32   (*qos_queueNum_set)(uint32 , uint32 );
    int32   (*qos_priMap_get)(uint32 , uint32 , rtk_qos_pri2queue_t *);
    int32   (*qos_priMap_set)(uint32 , uint32 , rtk_qos_pri2queue_t *);
    int32   (*qos_pri2QidMap_get)(uint32 , rtk_pri_t , rtk_qid_t *);
    int32   (*qos_pri2QidMap_set)(uint32 , rtk_pri_t , rtk_qid_t );
    int32   (*qos_cpuQid2QidMap_get)(uint32 , rtk_qid_t , rtk_qid_t * );
    int32   (*qos_cpuQid2QidMap_set)(uint32 , rtk_qid_t , rtk_qid_t );
    int32   (*qos_cpuQid2StackQidMap_get)(uint32 , rtk_qid_t , rtk_qid_t * );
    int32   (*qos_cpuQid2StackQidMap_set)(uint32 , rtk_qid_t , rtk_qid_t );

    int32   (*qos_port1pRemarkEnable_get)(uint32 , rtk_port_t , rtk_enable_t *) ;
    int32   (*qos_port1pRemarkEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*qos_1pRemarking_get)(uint32 , rtk_qos_1pRmkSrc_t , rtk_qos_1pRmkVal_t, rtk_pri_t *) ;
    int32   (*qos_1pRemarking_set)(uint32 , rtk_qos_1pRmkSrc_t , rtk_qos_1pRmkVal_t, rtk_pri_t );
    int32   (*qos_1pRemarkSrcSel_get)(uint32 , rtk_qos_1pRmkSrc_t *);
    int32   (*qos_1pRemarkSrcSel_set)(uint32 , rtk_qos_1pRmkSrc_t );
    int32   (*qos_port1pDfltPri_get)(uint32 , rtk_port_t , rtk_pri_t *) ;
    int32   (*qos_port1pDfltPri_set)(uint32 , rtk_port_t , rtk_pri_t );
    int32   (*qos_port1pDfltPriExt_get)(uint32 , uint32 , rtk_port_t , rtk_pri_t *) ;
    int32   (*qos_port1pDfltPriExt_set)(uint32 , uint32 , rtk_port_t , rtk_pri_t );
    int32   (*qos_port1pDfltPriSrcSel_get)(uint32 , rtk_port_t , rtk_qos_1pDfltPriSrc_t *) ;
    int32   (*qos_port1pDfltPriSrcSel_set)(uint32 , rtk_port_t , rtk_qos_1pDfltPriSrc_t );
    int32   (*qos_port1pDfltPriSrcSelExt_get)(uint32 , uint32 , rtk_port_t , rtk_qos_1pDfltPriSrc_t *) ;
    int32   (*qos_port1pDfltPriSrcSelExt_set)(uint32 , uint32 , rtk_port_t , rtk_qos_1pDfltPriSrc_t );
    int32   (*qos_1pDfltPriCfgSrcSel_get)(uint32 , rtk_qos_1pDfltCfgSrc_t *) ;
    int32   (*qos_1pDfltPriCfgSrcSel_set)(uint32 , rtk_qos_1pDfltCfgSrc_t );
    int32   (*qos_portOut1pRemarkEnable_get)(uint32 , rtk_port_t, rtk_enable_t *) ;
    int32   (*qos_portOut1pRemarkEnable_set)(uint32 , rtk_port_t, rtk_enable_t );
    int32   (*qos_outer1pRemarking_get)(uint32 , rtk_qos_outer1pRmkSrc_t, rtk_qos_outer1pRmkVal_t, rtk_pri_t *) ;
    int32   (*qos_outer1pRemarking_set)(uint32 , rtk_qos_outer1pRmkSrc_t, rtk_qos_outer1pRmkVal_t, rtk_pri_t );
    int32   (*qos_outer1pRemarkSrcSel_get)(uint32 , rtk_qos_outer1pRmkSrc_t *) ;
    int32   (*qos_outer1pRemarkSrcSel_set)(uint32 , rtk_qos_outer1pRmkSrc_t );
    int32   (*qos_portOuter1pDfltPri_get)(uint32 , rtk_port_t, rtk_pri_t *) ;
    int32   (*qos_portOuter1pDfltPri_set)(uint32 , rtk_port_t, rtk_pri_t );
    int32   (*qos_portOuter1pDfltPriExt_get)(uint32 , uint32 , rtk_port_t , rtk_pri_t *) ;
    int32   (*qos_portOuter1pDfltPriExt_set)(uint32 , uint32 , rtk_port_t , rtk_pri_t );
    int32   (*qos_portOuter1pDfltPriSrcSel_get)(uint32 , rtk_port_t , rtk_qos_outer1pDfltSrc_t *);
    int32   (*qos_portOuter1pDfltPriSrcSel_set)(uint32 , rtk_port_t , rtk_qos_outer1pDfltSrc_t );
    int32   (*qos_portOuter1pDfltPriSrcSelExt_get)(uint32 , uint32 , rtk_port_t , rtk_qos_outer1pDfltSrc_t *);
    int32   (*qos_portOuter1pDfltPriSrcSelExt_set)(uint32 , uint32 , rtk_port_t , rtk_qos_outer1pDfltSrc_t );
    int32   (*qos_outer1pDfltPriCfgSrcSel_get)(uint32 , rtk_qos_outer1pDfltCfgSrc_t *) ;
    int32   (*qos_outer1pDfltPriCfgSrcSel_set)(uint32 , rtk_qos_outer1pDfltCfgSrc_t );
    int32   (*qos_portDscpRemarkEnable_get)(uint32 , rtk_port_t, rtk_enable_t *) ;
    int32   (*qos_portDscpRemarkEnable_set)(uint32 , rtk_port_t, rtk_enable_t );
    int32   (*qos_dscpRemarking_get)(uint32 , rtk_qos_dscpRmkSrc_t, rtk_qos_dscpRmkVal_t, uint32 *) ;
    int32   (*qos_dscpRemarking_set)(uint32 , rtk_qos_dscpRmkSrc_t, rtk_qos_dscpRmkVal_t, uint32 );
    int32   (*qos_dscpRemarkSrcSel_get)(uint32 , rtk_qos_dscpRmkSrc_t *) ;
    int32   (*qos_dscpRemarkSrcSel_set)(uint32 , rtk_qos_dscpRmkSrc_t );
    int32   (*qos_portDeiRemarkEnable_get)(uint32 , rtk_port_t, rtk_enable_t *) ;
    int32   (*qos_portDeiRemarkEnable_set)(uint32 , rtk_port_t, rtk_enable_t );
    int32   (*qos_deiRemarking_get)(uint32 , rtk_qos_deiRmkSrc_t, rtk_qos_deiRmkVal_t, uint32 *) ;
    int32   (*qos_deiRemarking_set)(uint32 , rtk_qos_deiRmkSrc_t, rtk_qos_deiRmkVal_t, uint32 );
    int32   (*qos_portDeiRemarkTagSel_get)(uint32 , rtk_port_t, rtk_qos_deiSel_t *) ;
    int32   (*qos_portDeiRemarkTagSel_set)(uint32 , rtk_port_t, rtk_qos_deiSel_t );
    int32   (*qos_deiRemarkSrcSel_get)(uint32 , rtk_qos_deiRmkSrc_t *) ;
    int32   (*qos_deiRemarkSrcSel_set)(uint32 , rtk_qos_deiRmkSrc_t);

    int32   (*qos_1pDfltPri_get)(uint32 , rtk_pri_t *);
    int32   (*qos_1pDfltPri_set)(uint32 , rtk_pri_t );
    int32   (*qos_1pRemark_get)(uint32 , rtk_pri_t , rtk_pri_t *);
    int32   (*qos_1pRemark_set)(uint32 , rtk_pri_t , rtk_pri_t );
    int32   (*qos_outer1pRemark_get)(uint32 , rtk_pri_t , rtk_pri_t *);
    int32   (*qos_outer1pRemark_set)(uint32 , rtk_pri_t , rtk_pri_t );
    int32   (*qos_1pDfltPriSrcSel_get)(uint32 , rtk_qos_1pDfltPriSrc_t *);
    int32   (*qos_1pDfltPriSrcSel_set)(uint32 , rtk_qos_1pDfltPriSrc_t );
    int32   (*qos_outer1pDfltPri_get)(uint32 , rtk_pri_t *);
    int32   (*qos_outer1pDfltPri_set)(uint32 , rtk_pri_t );
    int32   (*qos_dscpRemark_get)(uint32 , rtk_pri_t , uint32 *);
    int32   (*qos_dscpRemark_set)(uint32 , rtk_pri_t , uint32 );
    int32   (*qos_dscp2Dot1pRemark_get)(uint32 , uint32 , rtk_pri_t *);
    int32   (*qos_dscp2Dot1pRemark_set)(uint32 , uint32 , rtk_pri_t );
    int32   (*qos_dscp2Outer1pRemark_get)(uint32 , uint32 , rtk_pri_t *);
    int32   (*qos_dscp2Outer1pRemark_set)(uint32 , uint32 , rtk_pri_t );
    int32   (*qos_dscp2DscpRemark_get)(uint32 , uint32 , uint32 *);
    int32   (*qos_dscp2DscpRemark_set)(uint32 , uint32 , uint32 );
    int32   (*qos_deiRemark_get)(uint32 , uint32 , uint32 *);
    int32   (*qos_deiRemark_set)(uint32 , uint32 , uint32 );
    int32   (*qos_portOuter1pRemarkSrcSel_get)(uint32 , rtk_port_t , rtk_qos_outer1pRmkSrc_t *);
    int32   (*qos_portOuter1pRemarkSrcSel_set)(uint32 , rtk_port_t , rtk_qos_outer1pRmkSrc_t );

    int32   (*qos_schedulingAlgorithm_get)(uint32 , rtk_port_t , rtk_qos_scheduling_type_t *);
    int32   (*qos_schedulingAlgorithm_set)(uint32 , rtk_port_t , rtk_qos_scheduling_type_t );
    int32   (*qos_schedulingQueue_get)(uint32 , rtk_port_t , rtk_qos_queue_weights_t *);
    int32   (*qos_schedulingQueue_set)(uint32 , rtk_port_t , rtk_qos_queue_weights_t *);
    int32   (*qos_congAvoidAlgo_get)(uint32 , rtk_qos_congAvoidAlgo_t *);
    int32   (*qos_congAvoidAlgo_set)(uint32 , rtk_qos_congAvoidAlgo_t );
    int32   (*qos_portCongAvoidAlgo_get)(uint32 , rtk_port_t , rtk_qos_congAvoidAlgo_t *);
    int32   (*qos_portCongAvoidAlgo_set)(uint32 , rtk_port_t , rtk_qos_congAvoidAlgo_t );
    int32   (*qos_congAvoidSysThresh_get)(uint32 ,uint32 , rtk_qos_congAvoidThresh_t *);
    int32   (*qos_congAvoidSysThresh_set)(uint32 ,uint32 , rtk_qos_congAvoidThresh_t *);
    int32   (*qos_congAvoidSysDropProbability_get)(uint32 , uint32 , uint32 *);
    int32   (*qos_congAvoidSysDropProbability_set)(uint32 , uint32 , uint32 );
    int32   (*qos_congAvoidGlobalQueueThresh_get)(uint32 , rtk_qid_t , uint32 , rtk_qos_congAvoidThresh_t *);
    int32   (*qos_congAvoidGlobalQueueThresh_set)(uint32 , rtk_qid_t , uint32 , rtk_qos_congAvoidThresh_t *);
    int32   (*qos_congAvoidGlobalQueueDropProbability_get)(uint32 , rtk_qid_t , uint32 , uint32 *);
    int32   (*qos_congAvoidGlobalQueueDropProbability_set)(uint32 , rtk_qid_t , uint32 , uint32 );
    int32   (*qos_congAvoidGlobalQueueConfig_get)(uint32 , rtk_qid_t , uint32 , rtk_qos_congAvoidThresh_t *);
    int32   (*qos_congAvoidGlobalQueueConfig_set)(uint32 , rtk_qid_t , uint32 , rtk_qos_congAvoidThresh_t *);
    int32   (*qos_portAvbStreamReservationClassEnable_get)(uint32 , rtk_port_t , rtk_qos_avbSrClass_t , rtk_enable_t *);
    int32   (*qos_portAvbStreamReservationClassEnable_set)(uint32 , rtk_port_t , rtk_qos_avbSrClass_t , rtk_enable_t );
    int32   (*qos_avbStreamReservationConfig_get)(uint32 , rtk_qos_avbSrConf_t *);
    int32   (*qos_avbStreamReservationConfig_set)(uint32 , rtk_qos_avbSrConf_t *);
    int32   (*qos_pkt2CpuPriRemap_get)(uint32 , rtk_pri_t , rtk_pri_t *);
    int32   (*qos_pkt2CpuPriRemap_set)(uint32 , rtk_pri_t , rtk_pri_t );
    int32   (*qos_rspanPriRemap_get)(uint32 , rtk_pri_t , rtk_pri_t *);
    int32   (*qos_rspanPriRemap_set)(uint32 , rtk_pri_t  , rtk_pri_t );
    int32   (*qos_portPri2IgrQMapEnable_get)(uint32, rtk_port_t, rtk_enable_t*);
    int32   (*qos_portPri2IgrQMapEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*qos_portPri2IgrQMap_get)(uint32, rtk_port_t, rtk_qos_pri2queue_t *);
    int32   (*qos_portPri2IgrQMap_set)(uint32, rtk_port_t, rtk_qos_pri2queue_t *);
    int32   (*qos_portIgrQueueWeight_get)(uint32, rtk_port_t, rtk_qid_t, uint32*);
    int32   (*qos_portIgrQueueWeight_set)(uint32, rtk_port_t, rtk_qid_t, uint32);
    int32   (*qos_invldDscpVal_get)(uint32, uint32 *);
    int32   (*qos_invldDscpVal_set)(uint32, uint32 );
    int32   (*qos_invldDscpMask_get)(uint32, uint32 *) ;
    int32   (*qos_invldDscpMask_set)(uint32, uint32 ) ;
    int32   (*qos_portInvldDscpEnable_get)(uint32, rtk_port_t , rtk_enable_t *);
    int32   (*qos_portInvldDscpEnable_set)(uint32, rtk_port_t , rtk_enable_t ) ;
    int32   (*qos_invldDscpEnable_get)(uint32, rtk_enable_t *) ;
    int32   (*qos_invldDscpEnable_set)(uint32 , rtk_enable_t ) ;
    int32   (*qos_sysPortPriRemapSel_get)(uint32, rtk_qos_portPriRemapSel_t *);
    int32   (*qos_sysPortPriRemapSel_set)(uint32, rtk_qos_portPriRemapSel_t );
    int32   (*qos_portPortPriRemapSel_get)(uint32, rtk_port_t, rtk_qos_portPriRemapSel_t *);
    int32   (*qos_portPortPriRemapSel_set)(uint32, rtk_port_t, rtk_qos_portPriRemapSel_t );
    int32   (*qos_portInnerPriRemapEnable_get)(uint32, rtk_enable_t *);
    int32   (*qos_portInnerPriRemapEnable_set)(uint32, rtk_enable_t );
    int32   (*qos_portOuterPriRemapEnable_get)(uint32, rtk_enable_t *);
    int32   (*qos_portOuterPriRemapEnable_set)(uint32, rtk_enable_t );
    int32   (*qos_priRemapEnable_get)(uint32, rtk_qos_priSrc_t, rtk_enable_t *);
    int32   (*qos_priRemapEnable_set)(uint32, rtk_qos_priSrc_t, rtk_enable_t );
    int32   (*qos_portQueueStrictEnable_get)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t *);
    int32   (*qos_portQueueStrictEnable_set)(uint32, rtk_port_t, rtk_qid_t, rtk_enable_t );

    /* TRAP API */
    int32   (*trap_init)(uint32 );
    int32   (*trap_rmaAction_get)(uint32 , rtk_mac_t *, rtk_mgmt_action_t *);
    int32   (*trap_rmaAction_set)(uint32 , rtk_mac_t *, rtk_mgmt_action_t );
    int32   (*trap_rmaGroupAction_get)(uint32 , rtk_trap_rmaGroup_frameType_t, rtk_mgmt_action_t *);
    int32   (*trap_rmaGroupAction_set)(uint32 , rtk_trap_rmaGroup_frameType_t, rtk_mgmt_action_t );
    int32   (*trap_rmaLearningEnable_get)(uint32 , rtk_mac_t *, rtk_enable_t *);
    int32   (*trap_rmaLearningEnable_set)(uint32 , rtk_mac_t *, rtk_enable_t );
    int32   (*trap_rmaGroupLearningEnable_get)(uint32 , rtk_trap_rmaGroup_frameType_t, rtk_enable_t *);
    int32   (*trap_rmaGroupLearningEnable_set)(uint32 , rtk_trap_rmaGroup_frameType_t, rtk_enable_t );
    int32   (*trap_bypassStp_get)(uint32 , rtk_trap_bypassStpType_t , rtk_enable_t *);
    int32   (*trap_bypassStp_set)(uint32 , rtk_trap_bypassStpType_t , rtk_enable_t );
    int32   (*trap_bypassVlan_get)(uint32 , rtk_trap_bypassVlanType_t , rtk_enable_t *);
    int32   (*trap_bypassVlan_set)(uint32 , rtk_trap_bypassVlanType_t , rtk_enable_t );
    int32   (*trap_userDefineRma_get)(uint32 , uint32 , rtk_trap_userDefinedRma_t *);
    int32   (*trap_userDefineRma_set)(uint32 , uint32 , rtk_trap_userDefinedRma_t *);
    int32   (*trap_userDefineRmaEnable_get)(uint32 , uint32 , rtk_enable_t *);
    int32   (*trap_userDefineRmaEnable_set)(uint32 , uint32 , rtk_enable_t );
    int32   (*trap_userDefineRmaAction_get)(uint32 , uint32 , rtk_mgmt_action_t *);
    int32   (*trap_userDefineRmaAction_set)(uint32 , uint32 , rtk_mgmt_action_t );
    int32   (*trap_userDefineRmaLearningEnable_get)(uint32 , uint32 , rtk_enable_t *);
    int32   (*trap_userDefineRmaLearningEnable_set)(uint32 , uint32 , rtk_enable_t );
    int32   (*trap_mgmtFrameAction_get)(uint32 , rtk_trap_mgmtType_t , rtk_mgmt_action_t *);
    int32   (*trap_mgmtFrameAction_set)(uint32 , rtk_trap_mgmtType_t , rtk_mgmt_action_t );
    int32   (*trap_mgmtFramePri_get)(uint32 , rtk_trap_mgmtType_t , rtk_pri_t *);
    int32   (*trap_mgmtFramePri_set)(uint32 , rtk_trap_mgmtType_t , rtk_pri_t );
    int32   (*trap_mgmtFrameQueue_get)(uint32 , rtk_trap_qType_t , rtk_qid_t *);
    int32   (*trap_mgmtFrameQueue_set)(uint32 , rtk_trap_qType_t , rtk_qid_t );
    int32   (*trap_mgmtFrameLearningEnable_get)(uint32 , rtk_trap_mgmtType_t , rtk_qid_t *);
    int32   (*trap_mgmtFrameLearningEnable_set)(uint32 , rtk_trap_mgmtType_t , rtk_qid_t );
    int32   (*trap_portMgmtFrameAction_get)(uint32 , rtk_port_t , rtk_trap_mgmtType_t , rtk_mgmt_action_t *);
    int32   (*trap_portMgmtFrameAction_set)(uint32 , rtk_port_t , rtk_trap_mgmtType_t , rtk_mgmt_action_t );
    int32   (*trap_pktWithCFIAction_get)(uint32 , rtk_action_t *);
    int32   (*trap_pktWithCFIAction_set)(uint32 , rtk_action_t);
    int32   (*trap_pktWithOuterCFIAction_get)(uint32 , rtk_action_t *);
    int32   (*trap_pktWithOuterCFIAction_set)(uint32 , rtk_action_t);
    int32   (*trap_pktWithCFIPri_get)(uint32 , rtk_pri_t *);
    int32   (*trap_pktWithCFIPri_set)(uint32 , rtk_pri_t );
    int32   (*trap_cfmAct_get)(uint32, rtk_trap_cfmType_t, uint32, rtk_action_t *);
    int32   (*trap_cfmAct_set)(uint32, rtk_trap_cfmType_t, uint32, rtk_action_t);
    int32   (*trap_cfmTarget_get)(uint32, rtk_trapTarget_t *);
    int32   (*trap_cfmTarget_set)(uint32, rtk_trapTarget_t);
    int32   (*trap_cfmFrameTrapPri_get)(uint32 , rtk_pri_t *);
    int32   (*trap_cfmFrameTrapPri_set)(uint32 , rtk_pri_t );
    int32   (*trap_oamPDUAction_get)(uint32 , rtk_action_t *);
    int32   (*trap_oamPDUAction_set)(uint32 , rtk_action_t );
    int32   (*trap_oamPDUPri_get)(uint32 , rtk_pri_t *);
    int32   (*trap_oamPDUPri_set)(uint32 , rtk_pri_t );
    int32   (*trap_portOamLoopbackParAction_get)(uint32 , rtk_port_t, rtk_trap_oam_action_t *);
    int32   (*trap_portOamLoopbackParAction_set)(uint32 , rtk_port_t, rtk_trap_oam_action_t);
    int32   (*trap_routeExceptionAction_get)(uint32 , rtk_trap_routeExceptionType_t , rtk_action_t *);
    int32   (*trap_routeExceptionAction_set)(uint32 , rtk_trap_routeExceptionType_t , rtk_action_t);
    int32   (*trap_routeExceptionPri_get)(uint32 , rtk_trap_routeExceptionType_t , rtk_pri_t *);
    int32   (*trap_routeExceptionPri_set)(uint32 , rtk_trap_routeExceptionType_t , rtk_pri_t);
    int32   (*trap_mgmtFrameMgmtVlanEnable_get)(uint32, rtk_enable_t *);
    int32   (*trap_mgmtFrameMgmtVlanEnable_set)(uint32, rtk_enable_t);
    int32   (*trap_mgmtFrameSelfARPEnable_get)(uint32, rtk_enable_t *);
    int32   (*trap_mgmtFrameSelfARPEnable_set)(uint32, rtk_enable_t);
    int32   (*trap_bpduFloodPortmask_get)(uint32,  rtk_portmask_t *);
    int32   (*trap_bpduFloodPortmask_set)(uint32,  rtk_portmask_t *);
    int32   (*trap_eapolFloodPortmask_get)(uint32,  rtk_portmask_t *);
    int32   (*trap_eapolFloodPortmask_set)(uint32,  rtk_portmask_t *);
    int32   (*trap_lldpFloodPortmask_get)(uint32,  rtk_portmask_t *);
    int32   (*trap_lldpFloodPortmask_set)(uint32,  rtk_portmask_t *);
    int32   (*trap_userDefineFloodPortmask_get)(uint32,  rtk_portmask_t *);
    int32   (*trap_userDefineFloodPortmask_set)(uint32,  rtk_portmask_t *);
    int32   (*trap_rmaFloodPortmask_get)(uint32,  rtk_portmask_t *);
    int32   (*trap_rmaFloodPortmask_set)(uint32,  rtk_portmask_t *);
    int32   (*trap_rmaCancelMirror_get)(uint32, rtk_enable_t *);
    int32   (*trap_rmaCancelMirror_set)(uint32, rtk_enable_t);
    int32   (*trap_rmaLookupMissActionEnable_get)(uint32, rtk_enable_t *);
    int32   (*trap_rmaLookupMissActionEnable_set)(uint32, rtk_enable_t);
    int32   (*trap_oamTarget_get)(uint32, rtk_trapTarget_t *);
    int32   (*trap_oamTarget_set)(uint32, rtk_trapTarget_t);
    int32   (*trap_mgmtFrameTarget_get)(uint32, rtk_trapTarget_t *);
    int32   (*trap_mgmtFrameTarget_set)(uint32, rtk_trapTarget_t);

    /* Stat API */
    int32   (*stat_init)(uint32 );
    int32   (*stat_enable_get)(uint32 , rtk_enable_t *);
    int32   (*stat_enable_set)(uint32 , rtk_enable_t );
    int32   (*stat_global_reset)(uint32 );
    int32   (*stat_port_reset)(uint32 , rtk_port_t );
    int32   (*stat_global_get)(uint32 , rtk_stat_global_type_t , uint64 *);
    int32   (*stat_global_getAll)(uint32 , rtk_stat_global_cntr_t *);
    int32   (*stat_port_get)(uint32 , rtk_port_t , rtk_stat_port_type_t , uint64 *);
    int32   (*stat_port_getAll)(uint32 , rtk_port_t , rtk_stat_port_cntr_t *);
    int32   (*stat_tagLenCntIncEnable_get)(uint32 , rtk_stat_tagCnt_type_t , rtk_enable_t *);
    int32   (*stat_tagLenCntIncEnable_set)(uint32 , rtk_stat_tagCnt_type_t , rtk_enable_t );
    int32   (*stat_stackHdrLenCntIncEnable_get)(uint32 , rtk_stat_stackHdrCnt_type_t , rtk_enable_t *);
    int32   (*stat_stackHdrLenCntIncEnable_set)(uint32 , rtk_stat_stackHdrCnt_type_t , rtk_enable_t );
    int32   (*stat_flexibleCntRange_get)(uint32 , uint32 , rtk_stat_flexCntSet_t *);
    int32   (*stat_flexibleCntRange_set)(uint32 , uint32 , rtk_stat_flexCntSet_t *);

    /* Switch API */
    int32   (*switch_init)(uint32 );
    int32   (*switch_cpuMaxPktLen_get)(uint32 , rtk_switch_pktDir_t , uint32 *);
    int32   (*switch_cpuMaxPktLen_set)(uint32 , rtk_switch_pktDir_t, uint32 );
    int32   (*switch_maxPktLenLinkSpeed_get)(uint32 , rtk_switch_maxPktLen_linkSpeed_t , uint32 *);
    int32   (*switch_maxPktLenLinkSpeed_set)(uint32 , rtk_switch_maxPktLen_linkSpeed_t , uint32 );
    int32   (*switch_maxPktLenTagLenCntIncEnable_get)(uint32 , rtk_enable_t *);
    int32   (*switch_maxPktLenTagLenCntIncEnable_set)(uint32 , rtk_enable_t );
    int32   (*switch_snapMode_get)(uint32 , rtk_snapMode_t *);
    int32   (*switch_snapMode_set)(uint32 , rtk_snapMode_t );
    int32   (*switch_chksumFailAction_get)(uint32 , rtk_port_t , rtk_switch_chksum_fail_t , rtk_action_t *);
    int32   (*switch_chksumFailAction_set)(uint32 , rtk_port_t , rtk_switch_chksum_fail_t , rtk_action_t );
    int32   (*switch_recalcCRCEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*switch_recalcCRCEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*switch_mgmtMacAddr_get)(uint32 , rtk_mac_t *);
    int32   (*switch_mgmtMacAddr_set)(uint32 , rtk_mac_t *);
    int32   (*switch_IPv4Addr_get)(uint32 , uint32 *);
    int32   (*switch_IPv4Addr_set)(uint32 , uint32 );
    int32   (*switch_pppoeIpParseEnable_get)(uint32 , rtk_enable_t *);
    int32   (*switch_pppoeIpParseEnable_set)(uint32 , rtk_enable_t );
    int32   (*switch_pkt2CpuTypeFormat_get)(uint32, rtk_switch_pkt2CpuType_t, rtk_pktFormat_t *);
    int32   (*switch_pkt2CpuTypeFormat_set)(uint32, rtk_switch_pkt2CpuType_t, rtk_pktFormat_t);
    int32   (*switch_cpuPktTruncateEnable_get)(uint32 , rtk_enable_t *);
    int32   (*switch_cpuPktTruncateEnable_set)(uint32 , rtk_enable_t );
    int32   (*switch_cpuPktTruncateLen_get)(uint32 , uint32 *);
    int32   (*switch_cpuPktTruncateLen_set)(uint32 , uint32 );
    int32   (*switch_portMaxPktLenLinkSpeed_get)(uint32, rtk_port_t, rtk_switch_maxPktLen_linkSpeed_t, uint32 *);
    int32   (*switch_portMaxPktLenLinkSpeed_set)(uint32, rtk_port_t, rtk_switch_maxPktLen_linkSpeed_t, uint32);
    int32   (*switch_portMaxPktLenTagLenCntIncEnable_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*switch_portMaxPktLenTagLenCntIncEnable_set)(uint32, rtk_port_t, rtk_enable_t);
    int32   (*switch_flexTblFmt_get)(uint32, rtk_switch_flexTblFmt_t *);
    int32   (*switch_flexTblFmt_set)(uint32, rtk_switch_flexTblFmt_t);

    /* MIRROR API */
    int32   (*mirror_init)(uint32 );
    int32   (*mirror_group_init)(uint32 , rtk_mirror_entry_t *);
    int32   (*mirror_group_get)(uint32 , uint32 , rtk_mirror_entry_t *);
    int32   (*mirror_group_set)(uint32 , uint32 , rtk_mirror_entry_t *);
    int32   (*mirror_rspanIgrMode_get)(uint32 , uint32 , rtk_mirror_rspanIgrMode_t *);
    int32   (*mirror_rspanIgrMode_set)(uint32 , uint32 , rtk_mirror_rspanIgrMode_t );
    int32   (*mirror_rspanEgrMode_get)(uint32 , uint32 , rtk_mirror_rspanEgrMode_t *);
    int32   (*mirror_rspanEgrMode_set)(uint32 , uint32 , rtk_mirror_rspanEgrMode_t );
    int32   (*mirror_rspanTag_get)(uint32 , uint32 , rtk_mirror_rspanTag_t *);
    int32   (*mirror_rspanTag_set)(uint32 , uint32 , rtk_mirror_rspanTag_t *);
    int32   (*mirror_sflowMirrorSampleRate_get)(uint32 , uint32 , uint32 *);
    int32   (*mirror_sflowMirrorSampleRate_set)(uint32 , uint32 , uint32 );
    int32   (*mirror_egrQueue_get)(uint32, rtk_enable_t *, rtk_qid_t *);
    int32   (*mirror_egrQueue_set)(uint32, rtk_enable_t, rtk_qid_t);
    int32   (*mirror_sflowPortIgrSampleRate_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*mirror_sflowPortIgrSampleRate_set)(uint32 , rtk_port_t , uint32 );
    int32   (*mirror_sflowPortEgrSampleRate_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*mirror_sflowPortEgrSampleRate_set)(uint32 , rtk_port_t , uint32 );
    int32   (*mirror_sflowSampleCtrl_get)(uint32, rtk_sflowSampleCtrl_t *);
    int32   (*mirror_sflowSampleCtrl_set)(uint32, rtk_sflowSampleCtrl_t );
    int32   (*mirror_sflowSampleTarget_get)(uint32, rtk_sflow_sampleTarget_t *);
    int32   (*mirror_sflowSampleTarget_set)(uint32, rtk_sflow_sampleTarget_t);

    /* flow control API */
    int32   (*flowctrl_init)(uint32 );
    int32   (*flowctrl_portPauseOnAction_get)(uint32 , rtk_port_t , rtk_flowctrl_pauseOnAction_t *);
    int32   (*flowctrl_portPauseOnAction_set)(uint32 , rtk_port_t , rtk_flowctrl_pauseOnAction_t );
    int32   (*flowctrl_portPauseOnAllowedPageNum_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*flowctrl_portPauseOnAllowedPageNum_set)(uint32 , rtk_port_t , uint32 );
    int32   (*flowctrl_pauseOnAllowedPktLen_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*flowctrl_pauseOnAllowedPktLen_set)(uint32 , rtk_port_t , uint32 );
    int32   (*flowctrl_pauseOnAllowedPktNum_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*flowctrl_pauseOnAllowedPktNum_set)(uint32 , rtk_port_t , uint32 );
    int32   (*flowctrl_igrGuarEnable_get)(uint32 , rtk_enable_t *);
    int32   (*flowctrl_igrGuarEnable_set)(uint32 , rtk_enable_t );
    int32   (*flowctrl_igrSystemPauseThresh_get)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrSystemPauseThresh_set)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrJumboSystemPauseThresh_get)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrJumboSystemPauseThresh_set)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrPauseThreshGroup_get)(uint32 , uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrPauseThreshGroup_set)(uint32 , uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_portIgrPortThreshGroupSel_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*flowctrl_portIgrPortThreshGroupSel_set)(uint32 , rtk_port_t , uint32 );
    int32   (*flowctrl_igrSystemCongestThresh_get)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrSystemCongestThresh_set)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrJumboSystemCongestThresh_get)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrJumboSystemCongestThresh_set)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrCongestThreshGroup_get)(uint32 , uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_igrCongestThreshGroup_set)(uint32 , uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_jumboModeStatus_get)(uint32 , uint32 *);
    int32   (*flowctrl_jumboModeEnable_get)(uint32 , rtk_enable_t *);
    int32   (*flowctrl_jumboModeEnable_set)(uint32 , rtk_enable_t );
    int32   (*flowctrl_jumboModeLength_get)(uint32 , uint32 *);
    int32   (*flowctrl_jumboModeLength_set)(uint32 , uint32 );
    int32   (*flowctrl_egrSystemUtilThresh_get)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_egrSystemUtilThresh_set)(uint32 , rtk_flowctrl_thresh_t *);
    int32   (*flowctrl_egrSystemDropThresh_get)(uint32 , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrSystemDropThresh_set)(uint32 , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrPortDropThresh_get)(uint32 , rtk_port_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrPortDropThresh_set)(uint32 , rtk_port_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrPortDropEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*flowctrl_egrPortDropEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*flowctrl_egrPortQueueDropEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*flowctrl_egrPortQueueDropEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*flowctrl_egrQueueDropThresh_get)(uint32 , rtk_qid_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrQueueDropThresh_set)(uint32 , rtk_qid_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrCpuQueueDropThresh_get)(uint32 , rtk_qid_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrCpuQueueDropThresh_set)(uint32 , rtk_qid_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_portEgrDropRefCongestEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*flowctrl_portEgrDropRefCongestEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*flowctrl_egrPortDropThreshGroup_get)(uint32 , uint32 , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrPortDropThreshGroup_set)(uint32 , uint32 , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrQueueDropThreshGroup_get)(uint32 , uint32 , rtk_qid_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_egrQueueDropThreshGroup_set)(uint32 , uint32 , rtk_qid_t , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_portEgrDropThreshGroupSel_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*flowctrl_portEgrDropThreshGroupSel_set)(uint32 , rtk_port_t , uint32 );
    int32   (*flowctrl_egrQueueDropEnable_get)(uint32 , rtk_port_t , rtk_qid_t , rtk_enable_t *);
    int32   (*flowctrl_egrQueueDropEnable_set)(uint32 , rtk_port_t , rtk_qid_t , rtk_enable_t );
    int32   (*flowctrl_portEgrQueueDropForceEnable_get)(uint32 , rtk_port_t , rtk_qid_t , rtk_enable_t *);
    int32   (*flowctrl_portEgrQueueDropForceEnable_set)(uint32 , rtk_port_t , rtk_qid_t , rtk_enable_t );
    int32   (*flowctrl_igrQueueDropEnable_get)(uint32 , rtk_port_t , rtk_qid_t , rtk_enable_t *);
    int32   (*flowctrl_igrQueueDropEnable_set)(uint32 , rtk_port_t , rtk_qid_t , rtk_enable_t );
    int32   (*flowctrl_igrQueuePauseDropThreshGroupSel_get)(uint32 , rtk_port_t , uint32 *);
    int32   (*flowctrl_igrQueuePauseDropThreshGroupSel_set)(uint32 , rtk_port_t , uint32 );
    int32   (*flowctrl_igrQueueDropThreshGroup_get)(uint32 , uint32, rtk_qid_t, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_igrQueueDropThreshGroup_set)(uint32 , uint32, rtk_qid_t, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_igrQueuePauseThreshGroup_get)(uint32, uint32, rtk_qid_t, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_igrQueuePauseThreshGroup_set)(uint32, uint32, rtk_qid_t, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_igrQueueDropThresh_get)(uint32, rtk_qid_t, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_igrQueueDropThresh_set)(uint32, rtk_qid_t, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_portHolTrafficDropEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*flowctrl_portHolTrafficDropEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*flowctrl_holTrafficTypeDropEnable_get)(uint32 , rtk_flowctrl_holTrafficType_t , rtk_enable_t *);
    int32   (*flowctrl_holTrafficTypeDropEnable_set)(uint32 , rtk_flowctrl_holTrafficType_t , rtk_enable_t );
    int32   (*flowctrl_specialCongestThreshold_get)(uint32 , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_specialCongestThreshold_set)(uint32 , rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_e2eCascadePortThresh_get)(uint32, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_e2eCascadePortThresh_set)(uint32, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_e2eRemotePortPauseThreshGroup_get)(uint32, uint32, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_e2eRemotePortPauseThreshGroup_set)(uint32, uint32, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_e2eRemotePortCongestThreshGroup_get)(uint32, uint32, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_e2eRemotePortCongestThreshGroup_set)(uint32, uint32, rtk_flowctrl_drop_thresh_t *);
    int32   (*flowctrl_portE2eRemotePortThreshGroupSel_get)(uint32, rtk_port_t, uint32 *);
    int32   (*flowctrl_portE2eRemotePortThreshGroupSel_set)(uint32, rtk_port_t, uint32);
    int32   (*flowctrl_tagPauseEnable_get)(uint32, rtk_enable_t *);
    int32   (*flowctrl_tagPauseEnable_set)(uint32, rtk_enable_t);
    int32   (*flowctrl_halfConsecutiveRetryEnable_get)(uint32, rtk_enable_t *);
    int32   (*flowctrl_halfConsecutiveRetryEnable_set)(uint32, rtk_enable_t);

    /* EEE */
    int32   (*eee_init)(uint32 );
    int32   (*eee_portEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*eee_portEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*eee_portState_get)(uint32, rtk_port_t, rtk_enable_t *);
    int32   (*eee_portPowerState_get)(uint32, rtk_port_t, rtk_eee_direction_t, rtk_eee_power_state_t *);
    int32   (*eeep_portEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*eeep_portEnable_set)(uint32 , rtk_port_t , rtk_enable_t);

    /* Security */
    int32   (*sec_init)(uint32 );
    int32   (*sec_portAttackPrevent_get)(uint32 , rtk_port_t , rtk_sec_attackType_t , rtk_action_t *);
    int32   (*sec_portAttackPrevent_set)(uint32 , rtk_port_t , rtk_sec_attackType_t , rtk_action_t );
    int32   (*sec_portAttackPreventEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*sec_portAttackPreventEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*sec_attackPreventAction_get)(uint32 , rtk_sec_attackType_t , rtk_action_t *);
    int32   (*sec_attackPreventAction_set)(uint32 , rtk_sec_attackType_t , rtk_action_t );
    int32   (*sec_minIPv6FragLen_get)(uint32 , uint32 *);
    int32   (*sec_minIPv6FragLen_set)(uint32 , uint32 );
    int32   (*sec_maxPingLen_get)(uint32 , uint32 *);
    int32   (*sec_maxPingLen_set)(uint32 , uint32 );
    int32   (*sec_minTCPHdrLen_get)(uint32 , uint32 *);
    int32   (*sec_minTCPHdrLen_set)(uint32 , uint32 );
    int32   (*sec_smurfNetmaskLen_get)(uint32, uint32 *);
    int32   (*sec_smurfNetmaskLen_set)(uint32, uint32 );
    int32   (*sec_trapTarget_get)(uint32, rtk_trapTarget_t *);
    int32   (*sec_trapTarget_set)(uint32, rtk_trapTarget_t);
    int32   (*sec_ipMacBindAction_get)(uint32, rtk_action_t *, rtk_action_t *, rtk_action_t *);
    int32   (*sec_ipMacBindAction_set)(uint32, rtk_action_t, rtk_action_t, rtk_action_t);
    int32   (*sec_portIpMacBindEnable_get)(uint32, rtk_port_t, rtk_sec_ipMacBindPktType_t, rtk_enable_t *);
    int32   (*sec_portIpMacBindEnable_set)(uint32, rtk_port_t, rtk_sec_ipMacBindPktType_t, rtk_enable_t);
    int32   (*sec_ipMacBindEntry_add)(uint32, rtk_sec_ipMacBindEntry_t *);
    int32   (*sec_ipMacBindEntry_del)(uint32, rtk_sec_ipMacBindEntry_t *);
    int32   (*sec_ipMacBindEntry_getNext)(uint32, int32 *, rtk_sec_ipMacBindEntry_t *);
    int32   (*sec_attackPreventHit_get)(uint32, rtk_sec_attackType_t, uint32 *);

    /* L3 */
    int32   (*l3_init)(uint32 );
    int32   (*l3_routeEntry_get)(uint32 , uint32 , rtk_l3_routeEntry_t *);
    int32   (*l3_routeEntry_set)(uint32 , uint32 , rtk_l3_routeEntry_t *);
    int32   (*l3_routeSwitchMacAddr_get)(uint32 , uint32 , rtk_mac_t *);
    int32   (*l3_routeSwitchMacAddr_set)(uint32 , uint32 , rtk_mac_t *);
    int32   (*l3_info_get)(uint32, rtk_l3_info_t *);
    int32   (*l3_routerMacEntry_get)(uint32, uint32, rtk_l3_routerMacEntry_t *);
    int32   (*l3_routerMacEntry_set)(uint32, uint32, rtk_l3_routerMacEntry_t *);
    int32   (*l3_intf_create)(uint32, rtk_l3_intf_t *);
    int32   (*l3_intf_destroy)(uint32, rtk_intf_id_t);
    int32   (*l3_intf_destroyAll)(uint32);
    int32   (*l3_intf_get)(uint32, rtk_l3_intfKeyType_t, rtk_l3_intf_t *);
    int32   (*l3_intf_set)(uint32, rtk_l3_intfKeyType_t, rtk_l3_intf_t *);
    int32   (*l3_intfStats_get)(uint32, rtk_intf_id_t, rtk_l3_intf_stats_t *);
    int32   (*l3_intfStats_reset)(uint32, rtk_intf_id_t);
    int32   (*l3_vrrp_add)(uint32, rtk_l3_vrrp_flag_t, rtk_vlan_t, uint32);
    int32   (*l3_vrrp_del)(uint32, rtk_l3_vrrp_flag_t, rtk_vlan_t, uint32);
    int32   (*l3_vrrp_delAll)(uint32, rtk_l3_vrrp_flag_t, rtk_vlan_t);
    int32   (*l3_vrrp_get)(uint32, rtk_l3_vrrp_flag_t, rtk_vlan_t, uint32, uint32 *, uint32 *);
    int32   (*l3_nextHop_create)(uint32, rtk_l3_flag_t, rtk_l3_nextHop_t *, rtk_l3_pathId_t *);
    int32   (*l3_nextHop_destroy)(uint32, rtk_l3_pathId_t);
    int32   (*l3_nextHop_get)(uint32, rtk_l3_pathId_t, rtk_l3_nextHop_t *);
    int32   (*l3_nextHopPath_find)(uint32, rtk_l3_nextHop_t *, rtk_l3_pathId_t *);
    int32   (*l3_ecmp_create)(uint32, rtk_l3_flag_t, uint32, rtk_l3_pathId_t *, rtk_l3_pathId_t *);
    int32   (*l3_ecmp_destroy)(uint32, rtk_l3_pathId_t);
    int32   (*l3_ecmp_get)(uint32, rtk_l3_pathId_t, uint32, rtk_l3_pathId_t *, uint32 *);
    int32   (*l3_ecmp_add)(uint32, rtk_l3_pathId_t, rtk_l3_pathId_t);
    int32   (*l3_ecmp_del)(uint32, rtk_l3_pathId_t, rtk_l3_pathId_t);
    int32   (*l3_ecmp_find)(uint32, uint32, rtk_l3_pathId_t *, rtk_l3_pathId_t *);
    int32   (*l3_host_add)(uint32, rtk_l3_host_t *);
    int32   (*l3_host_del)(uint32, rtk_l3_host_t *);
    int32   (*l3_host_del_byNetwork)(uint32, rtk_l3_route_t *);
    int32   (*l3_host_del_byIntfId)(uint32, rtk_intf_id_t, rtk_l3_flag_t);
    int32   (*l3_host_delAll)(uint32, rtk_l3_flag_t);
    int32   (*l3_host_find)(uint32, rtk_l3_host_t *);
    int32   (*l3_hostConflict_get)(uint32, rtk_l3_key_t *, rtk_l3_host_t *, int32, int32 *);
    int32   (*l3_host_age)(uint32, rtk_l3_flag_t, rtk_l3_hostTraverseCallback_f, void *);
    int32   (*l3_host_getNext)(uint32, rtk_l3_flag_t, int32 *, rtk_l3_host_t *);
    int32   (*l3_route_add)(uint32, rtk_l3_route_t *);
    int32   (*l3_route_del)(uint32, rtk_l3_route_t *);
    int32   (*l3_route_get)(uint32, rtk_l3_route_t *);
    int32   (*l3_route_del_byIntfId)(uint32, rtk_l3_flag_t, rtk_intf_id_t);
    int32   (*l3_route_delAll)(uint32, rtk_l3_flag_t);
    int32   (*l3_route_age)(uint32, rtk_l3_flag_t, rtk_l3_routeTraverseCallback_f, void *);
    int32   (*l3_route_getNext)(uint32, rtk_l3_flag_t, int32 *, rtk_l3_route_t *);
    int32   (*l3_globalCtrl_get)(uint32, rtk_l3_globalCtrlType_t, int32 *);
    int32   (*l3_globalCtrl_set)(uint32, rtk_l3_globalCtrlType_t, int32);
    int32   (*l3_intfCtrl_get)(uint32, rtk_intf_id_t, rtk_l3_intfCtrlType_t, int32 *);
    int32   (*l3_intfCtrl_set)(uint32, rtk_intf_id_t, rtk_l3_intfCtrlType_t, int32);
    int32   (*l3_portCtrl_get)(uint32, rtk_port_t, rtk_l3_portCtrlType_t, int32 *);
    int32   (*l3_portCtrl_set)(uint32, rtk_port_t, rtk_l3_portCtrlType_t, int32);

    /* Tunnel */
    int32   (*tunnel_init)(uint32);
    int32   (*tunnel_info_get)(uint32, rtk_tunnel_info_t *);
    int32   (*tunnel_intf_create)(uint32, rtk_tunnel_intf_t *);
    int32   (*tunnel_intf_destroy)(uint32, rtk_intf_id_t);
    int32   (*tunnel_intf_destroyAll)(uint32);
    int32   (*tunnel_intf_get)(uint32, rtk_tunnel_intf_t *);
    int32   (*tunnel_intf_set)(uint32, rtk_tunnel_intf_t *);
    int32   (*tunnel_intfPathId_get)(uint32, rtk_intf_id_t, rtk_l3_pathId_t *);
    int32   (*tunnel_intfPathId_set)(uint32, rtk_intf_id_t, rtk_l3_pathId_t);
    int32   (*tunnel_intfPath_get)(uint32, rtk_intf_id_t, uint32 *, uint32 *);
    int32   (*tunnel_intfPath_set)(uint32, rtk_intf_id_t, uint32, uint32);
    int32   (*tunnel_intfStats_get)(uint32, rtk_intf_id_t, rtk_tunnel_intf_stats_t *);
    int32   (*tunnel_intfStats_reset)(uint32, rtk_intf_id_t);
    int32   (*tunnel_qosProfile_get)(uint32, uint32, rtk_tunnel_qosProfile_t *);
    int32   (*tunnel_qosProfile_set)(uint32, uint32, rtk_tunnel_qosProfile_t);
    int32   (*tunnel_globalCtrl_get)(uint32, rtk_tunnel_globalCtrlType_t, int32 *);
    int32   (*tunnel_globalCtrl_set)(uint32, rtk_tunnel_globalCtrlType_t, int32);
    int32   (*capwap_udpPort_get)(uint32, uint32 *, uint32 *);
    int32   (*capwap_udpPort_set)(uint32, uint32, uint32);

    /* MCAST */
    int32   (*mcast_init)(uint32);
    int32   (*mcast_group_create)(uint32, uint32, rtk_mcast_type_t, rtk_mcast_group_t *);
    int32   (*mcast_group_destroy)(uint32, rtk_mcast_group_t);
    int32   (*mcast_group_getNext)(uint32, rtk_mcast_type_t, int32 *, rtk_mcast_group_t *);
    int32   (*mcast_nextHop_get)(uint32, rtk_mcast_group_t, int32, rtk_mcast_egrif_t *, int32 *);
    int32   (*mcast_nextHop_add)(uint32, rtk_mcast_group_t, rtk_mcast_egrif_t *);
    int32   (*mcast_nextHop_del)(uint32, rtk_mcast_group_t, rtk_mcast_egrif_t *);
    int32   (*mcast_nextHop_delAll)(uint32, rtk_mcast_group_t);

    /* IPMCAST */
    int32   (*ipmc_init)(uint32 );
    int32   (*ipmc_addr_add)(uint32, rtk_ipmc_addr_t *);
    int32   (*ipmc_addr_find)(uint32, rtk_ipmc_addr_t *);
    int32   (*ipmc_addr_del)(uint32, rtk_ipmc_addr_t *);
    int32   (*ipmc_addr_delAll)(uint32, rtk_ipmc_flag_t);
    int32   (*ipmc_nextValidAddr_get)(uint32, rtk_ipmc_flag_t, int32 *, rtk_ipmc_addr_t *);
    int32   (*ipmc_statMont_create)(uint32, rtk_ipmc_statMont_t *);
    int32   (*ipmc_statMont_destroy)(uint32, rtk_ipmc_statMont_t *);
    int32   (*ipmc_statCntr_reset)(uint32, rtk_ipmc_statKey_t *);
    int32   (*ipmc_statCntr_get)(uint32, rtk_ipmc_statKey_t *, rtk_ipmc_statCntr_t *);
    int32   (*ipmc_globalCtrl_set)(uint32, rtk_ipmc_globalCtrlType_t, int32);
    int32   (*ipmc_globalCtrl_get)(uint32, rtk_ipmc_globalCtrlType_t, int32 *);

    /* OAM */
    int32   (*oam_init)(uint32 );
    int32   (*oam_portDyingGaspPayload_set)(uint32 , rtk_port_t , uint8 *, uint32);
    int32   (*oam_dyingGaspSend_set)(uint32 , rtk_enable_t );
    int32   (*oam_autoDyingGaspEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*oam_autoDyingGaspEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*oam_dyingGaspWaitTime_get)(uint32 , uint32 *);
    int32   (*oam_dyingGaspWaitTime_set)(uint32 , uint32 );
    int32   (*oam_loopbackMacSwapEnable_get)(uint32 , rtk_enable_t *);
    int32   (*oam_loopbackMacSwapEnable_set)(uint32 , rtk_enable_t);
    int32   (*oam_portLoopbackMuxAction_get)(uint32 , rtk_port_t, rtk_action_t *);
    int32   (*oam_portLoopbackMuxAction_set)(uint32 , rtk_port_t, rtk_action_t);
    int32   (*oam_cfmCcmPcp_get)(uint32 , uint32 *);
    int32   (*oam_cfmCcmPcp_set)(uint32 , uint32 );
    int32   (*oam_cfmCcmCfi_get)(uint32 , uint32 *);
    int32   (*oam_cfmCcmCfi_set)(uint32 , uint32 );
    int32   (*oam_cfmCcmTpid_get)(uint32 , uint32 *);
    int32   (*oam_cfmCcmTpid_set)(uint32 , uint32 );
    int32   (*oam_cfmCcmInstLifetime_get)(uint32 , uint32 , uint32 *);
    int32   (*oam_cfmCcmInstLifetime_set)(uint32 , uint32 , uint32 );
    int32   (*oam_cfmCcmMepid_get)(uint32 , uint32 *);
    int32   (*oam_cfmCcmMepid_set)(uint32 , uint32 );
    int32   (*oam_cfmCcmIntervalField_get)(uint32 , uint32 *);
    int32   (*oam_cfmCcmIntervalField_set)(uint32 , uint32 );
    int32   (*oam_cfmCcmMdl_get)(uint32 , uint32 *);
    int32   (*oam_cfmCcmMdl_set)(uint32 , uint32 );
    int32   (*oam_cfmCcmInstTxMepid_get)(uint32 , uint32 , uint32 *);
    int32   (*oam_cfmCcmInstTxMepid_set)(uint32 , uint32 , uint32 );
    int32   (*oam_cfmCcmInstTxIntervalField_get)(uint32 , uint32 , uint32 *);
    int32   (*oam_cfmCcmInstTxIntervalField_set)(uint32 , uint32 , uint32 );
    int32   (*oam_cfmCcmInstTxMdl_get)(uint32 , uint32 , uint32 *);
    int32   (*oam_cfmCcmInstTxMdl_set)(uint32 , uint32 , uint32 );
    int32   (*oam_cfmCcmInstTagStatus_get)(uint32 , uint32 , rtk_enable_t *);
    int32   (*oam_cfmCcmInstTagStatus_set)(uint32 , uint32 , rtk_enable_t );
    int32   (*oam_cfmCcmInstVid_get)(uint32 , uint32 , rtk_vlan_t *);
    int32   (*oam_cfmCcmInstVid_set)(uint32 , uint32 , rtk_vlan_t );
    int32   (*oam_cfmCcmInstMaid_get)(uint32 , uint32 , uint32 *);
    int32   (*oam_cfmCcmInstMaid_set)(uint32 , uint32 , uint32 );
    int32   (*oam_cfmCcmInstTxStatus_get)(uint32 , uint32 , rtk_enable_t *);
    int32   (*oam_cfmCcmInstTxStatus_set)(uint32 , uint32 , rtk_enable_t );
    int32   (*oam_cfmCcmInstInterval_get)(uint32 , uint32 , uint32 *);
    int32   (*oam_cfmCcmInstInterval_set)(uint32 , uint32 , uint32 );
    int32   (*oam_cfmCcmTxInstPort_get)(uint32 , uint32 , uint32 , rtk_port_t *);
    int32   (*oam_cfmCcmTxInstPort_set)(uint32 , uint32 , uint32 , rtk_port_t );
    int32   (*oam_cfmCcmRxInstVid_get)(uint32 , uint32 , rtk_vlan_t *);
    int32   (*oam_cfmCcmRxInstVid_set)(uint32 , uint32 , rtk_vlan_t );
    int32   (*oam_cfmCcmRxInstPort_get)(uint32 , uint32 , uint32 , rtk_port_t *);
    int32   (*oam_cfmCcmRxInstPort_set)(uint32 , uint32 , uint32 , rtk_port_t );
    int32   (*oam_cfmCcmKeepalive_get)(uint32 , uint32 , uint32 , uint32 *);
    int32   (*oam_cfmPortEthDmEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*oam_cfmPortEthDmEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*oam_cfmEthDmRxTimestamp_get)(uint32 , uint32, rtk_time_timeStamp_t *);
    int32   (*oam_cfmEthDmTxDelay_get)(uint32 , rtk_oam_cfmEthDmTxDelay_t *);
    int32   (*oam_cfmEthDmTxDelay_set)(uint32 , rtk_oam_cfmEthDmTxDelay_t );
    int32   (*oam_cfmEthDmRefTime_get)(uint32, rtk_time_timeStamp_t * );
    int32   (*oam_cfmEthDmRefTime_set)(uint32 , rtk_time_timeStamp_t );
    int32   (*oam_cfmEthDmRefTimeEnable_get)(uint32 , rtk_enable_t * );
    int32   (*oam_cfmEthDmRefTimeEnable_set)(uint32 , rtk_enable_t );
    int32   (*oam_cfmEthDmRefTimeFreq_get)(uint32 , uint32 *);
    int32   (*oam_cfmEthDmRefTimeFreq_set)(uint32 , uint32 );
    int32   (*oam_dyingGaspPktCnt_get)(uint32, uint32 *);
    int32   (*oam_dyingGaspPktCnt_set)(uint32, uint32);
    int32   (*oam_pduLearningEnable_get)(uint32, rtk_enable_t *);
    int32   (*oam_pduLearningEnable_set)(uint32, rtk_enable_t);
    int32   (*oam_cfmCcmInstTxMember_get)(uint32, uint32, rtk_oam_cfmInstMember_t *);
    int32   (*oam_cfmCcmInstTxMember_set)(uint32, uint32, rtk_oam_cfmInstMember_t *);
    int32   (*oam_cfmCcmInstRxMember_get)(uint32, uint32, rtk_oam_cfmInstMember_t *);
    int32   (*oam_cfmCcmInstRxMember_set)(uint32, uint32, rtk_oam_cfmInstMember_t *);

    /* PIE */
    int32   (*pie_init)(uint32 );
    int32   (*pie_phase_get)(uint32 , uint32 , rtk_pie_phase_t *);
    int32   (*pie_phase_set)(uint32 , uint32 , rtk_pie_phase_t );
    int32   (*pie_blockLookupEnable_get)(uint32 , uint32 , rtk_enable_t *);
    int32   (*pie_blockLookupEnable_set)(uint32 , uint32 , rtk_enable_t );
    int32   (*pie_blockGrouping_get)(uint32 , uint32 , uint32 *, uint32 *);
    int32   (*pie_blockGrouping_set)(uint32 , uint32 , uint32  , uint32 );
    int32   (*pie_template_get)(uint32 , uint32 , rtk_pie_template_t *);
    int32   (*pie_template_set)(uint32 , uint32 , rtk_pie_template_t *);
    int32   (*pie_templateVlanSel_get)(uint32, rtk_pie_phase_t, uint32, rtk_pie_templateVlanSel_t *);
    int32   (*pie_templateVlanSel_set)(uint32, rtk_pie_phase_t, uint32, rtk_pie_templateVlanSel_t );
    int32   (*pie_templateField_check)(uint32, rtk_pie_phase_t, rtk_pie_templateFieldType_t);
    int32   (*pie_rangeCheckIp_get)(uint32, uint32, rtk_pie_rangeCheck_ip_t *);
    int32   (*pie_rangeCheckIp_set)(uint32, uint32, rtk_pie_rangeCheck_ip_t *);
    int32   (*pie_rangeCheck_get)(uint32, uint32, rtk_pie_rangeCheck_t *);
    int32   (*pie_rangeCheck_set)(uint32, uint32, rtk_pie_rangeCheck_t *);
    int32   (*pie_fieldSelector_get)(uint32, uint32, rtk_pie_fieldSelector_data_t *);
    int32   (*pie_fieldSelector_set)(uint32, uint32, rtk_pie_fieldSelector_data_t *);
    int32   (*pie_meterIncludeIfg_get)(uint32, rtk_enable_t *);
    int32   (*pie_meterIncludeIfg_set)(uint32, rtk_enable_t );
    int32   (*pie_meterExceed_get)(uint32, uint32, uint32 *);
    int32   (*pie_meterExceedAggregation_get)(uint32, uint32 *);
    int32   (*pie_meterEntry_get)(uint32, uint32, rtk_pie_meterEntry_t *);
    int32   (*pie_meterEntry_set)(uint32, uint32, rtk_pie_meterEntry_t *);
    int32   (*pie_meterDpSel_get)(uint32, rtk_pie_meterDpSel_t *);
    int32   (*pie_meterDpSel_set)(uint32, rtk_pie_meterDpSel_t );
    int32   (*pie_arpMacSel_get)(uint32, rtk_pie_arpMacSel_t *);
    int32   (*pie_arpMacSel_set)(uint32, rtk_pie_arpMacSel_t);
    int32   (*pie_intfSel_get)(uint32, rtk_pie_intfSel_t *);
    int32   (*pie_intfSel_set)(uint32, rtk_pie_intfSel_t);
    int32   (*pie_templateVlanFmtSel_get)(uint32, rtk_pie_phase_t, uint32, rtk_pie_templateVlanFmtSel_t *);
    int32   (*pie_templateVlanFmtSel_set)(uint32, rtk_pie_phase_t, uint32, rtk_pie_templateVlanFmtSel_t);
    int32   (*pie_meterTrtcmType_get)(uint32, rtk_pie_meterTrtcmType_t *);
    int32   (*pie_meterTrtcmType_set)(uint32, rtk_pie_meterTrtcmType_t);
    int32   (*pie_filter1BR_get)(uint32, rtk_enable_t *);
    int32   (*pie_filter1BR_set)(uint32, rtk_enable_t);

    /* ACL */
    int32   (*acl_init)(uint32 );

    int32   (*acl_portLookupEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*acl_portLookupEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*acl_lookupMissAct_get)(uint32 , rtk_port_t , rtk_acl_lookupMissAct_t *);
    int32   (*acl_lookupMissAct_set)(uint32 , rtk_port_t , rtk_acl_lookupMissAct_t );
    int32   (*acl_rangeCheckFieldSelector_get)(uint32 , uint32 , rtk_acl_rangeCheck_fieldSelector_t *);
    int32   (*acl_rangeCheckFieldSelector_set)(uint32 , uint32 , rtk_acl_rangeCheck_fieldSelector_t *);
    int32   (*acl_partition_get)(uint32 , uint32 *);
    int32   (*acl_partition_set)(uint32 , uint32);
    int32   (*acl_templateFieldIntentVlanTag_get)(uint32, rtk_vlan_tagType_t *);
    int32   (*acl_templateFieldIntentVlanTag_set)(uint32, rtk_vlan_tagType_t);
    int32   (*acl_rangeCheckDstPort_get)(uint32 , uint32 , rtk_acl_rangeCheck_portMask_t *);
    int32   (*acl_rangeCheckDstPort_set)(uint32 , uint32 , rtk_acl_rangeCheck_portMask_t *);
    int32   (*acl_blockResultMode_get)(uint32 , uint32 , rtk_acl_blockResultMode_t *);
    int32   (*acl_blockResultMode_set)(uint32 , uint32 , rtk_acl_blockResultMode_t );
    int32   (*acl_ruleEntryFieldSize_get)(uint32 , rtk_acl_fieldType_t , uint32 *);
    int32   (*acl_ruleEntrySize_get)(uint32 , rtk_acl_phase_t , uint32 *);
    int32   (*acl_ruleValidate_get)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , uint32 *);
    int32   (*acl_ruleValidate_set)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , uint32 );
    int32   (*acl_ruleEntry_read)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , uint8 *);
    int32   (*acl_ruleEntry_write)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , uint8 *);
    int32   (*acl_ruleEntryField_get)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , uint8 * , rtk_acl_fieldType_t , uint8 * , uint8 *);
    int32   (*acl_ruleEntryField_set)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , uint8 * , rtk_acl_fieldType_t , uint8 * , uint8 *);
    int32   (*acl_ruleEntryField_read)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_fieldType_t , uint8 * , uint8 *);
    int32   (*acl_ruleEntryField_write)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_fieldType_t , uint8 * , uint8 *);
    int32   (*acl_ruleEntryField_check)(uint32, rtk_acl_phase_t, rtk_acl_fieldType_t);
    int32   (*acl_ruleOperation_get)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_operation_t *);
    int32   (*acl_ruleOperation_set)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_operation_t *);
    int32   (*acl_ruleAction_get)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_action_t *);
    int32   (*acl_ruleAction_set)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_action_t *);
    int32   (*acl_blockPwrEnable_get)(uint32 , uint32 , rtk_enable_t *);
    int32   (*acl_blockPwrEnable_set)(uint32 , uint32 , rtk_enable_t );
    int32   (*acl_blockGroupEnable_get)(uint32 , uint32 , rtk_acl_blockGroup_t  , rtk_enable_t *);
    int32   (*acl_blockGroupEnable_set)(uint32 , uint32 , rtk_acl_blockGroup_t  , rtk_enable_t );
    int32   (*acl_statPktCnt_get)(uint32 , uint32 , uint32 *);
    int32   (*acl_statPktCnt_clear)(uint32 , uint32 );
    int32   (*acl_statByteCnt_get)(uint32 , uint32 , uint64 *);
    int32   (*acl_statByteCnt_clear)(uint32 , uint32 );
    int32   (*acl_stat_clearAll)(uint32 );
    int32   (*acl_rangeCheckL4Port_get)(uint32, uint32, rtk_acl_rangeCheck_l4Port_t *);
    int32   (*acl_rangeCheckL4Port_set)(uint32, uint32, rtk_acl_rangeCheck_l4Port_t *);
    int32   (*acl_rangeCheckVid_get)(uint32, uint32, rtk_acl_rangeCheck_vid_t *);
    int32   (*acl_rangeCheckVid_set)(uint32, uint32, rtk_acl_rangeCheck_vid_t *);
    int32   (*acl_rangeCheckPacketLen_get)(uint32, uint32, rtk_acl_rangeCheck_packetLen_t *);
    int32   (*acl_rangeCheckPacketLen_set)(uint32, uint32, rtk_acl_rangeCheck_packetLen_t *);
    int32   (*acl_rangeCheckSrcPort_get)(uint32 , uint32 , rtk_acl_rangeCheck_portMask_t *);
    int32   (*acl_rangeCheckSrcPort_set)(uint32 , uint32 , rtk_acl_rangeCheck_portMask_t *);
    int32   (*acl_meterBurstSize_get)(uint32, rtk_acl_meterMode_t, rtk_acl_meterBurstSize_t *);
    int32   (*acl_meterBurstSize_set)(uint32, rtk_acl_meterMode_t, rtk_acl_meterBurstSize_t *);
    int32   (*acl_meterMode_get)(uint32, uint32, rtk_acl_meterMode_t *);
    int32   (*acl_meterMode_set)(uint32, uint32, rtk_acl_meterMode_t );
    int32   (*acl_loopBackEnable_get)(uint32, uint32 *);
    int32   (*acl_loopBackEnable_set)(uint32, uint32);
    int32   (*acl_limitLoopbackTimes_get)(uint32, uint32 *);
    int32   (*acl_limitLoopbackTimes_set)(uint32, uint32);
    int32   (*acl_portPhaseLookupEnable_get)(uint32, rtk_port_t, rtk_acl_phase_t, uint32 *);
    int32   (*acl_portPhaseLookupEnable_set)(uint32, rtk_port_t, rtk_acl_phase_t, uint32);
    int32   (*acl_templateSelector_get)(uint32 , uint32 , rtk_acl_templateIdx_t *);
    int32   (*acl_templateSelector_set)(uint32 , uint32 , rtk_acl_templateIdx_t);
    int32   (*acl_statCnt_get)(uint32 , rtk_acl_phase_t , rtk_acl_id_t, rtk_acl_statMode_t, uint64 *);
    int32   (*acl_statCnt_clear)(uint32 , rtk_acl_phase_t , rtk_acl_id_t , rtk_acl_statMode_t);
    int32   (*acl_ruleHitIndication_get)(uint32, rtk_acl_phase_t, rtk_acl_id_t, uint32, uint32 *);
    int32   (*acl_rule_del)(uint32, rtk_acl_phase_t, rtk_acl_clear_t *);
    int32   (*acl_rule_move)(uint32, rtk_acl_phase_t, rtk_acl_move_t *);
    int32   (*acl_ruleEntryField_validate)(uint32, rtk_acl_phase_t, rtk_acl_id_t, rtk_acl_fieldType_t);
    int32   (*acl_fieldUsr2Template_get)(uint32, rtk_acl_phase_t, rtk_acl_fieldType_t, rtk_acl_fieldUsr2Template_t *);
    int32   (*acl_templateId_get)(uint32, rtk_acl_phase_t, rtk_acl_id_t, uint32 *);

    /* OpenFlow */
    int32   (*of_init)(uint32);
    int32   (*of_classifier_get)(uint32, rtk_of_classifierType_t, rtk_of_classifierData_t *);
    int32   (*of_classifier_set)(uint32, rtk_of_classifierType_t, rtk_of_classifierData_t );
    int32   (*of_flowMatchFieldSize_get)(uint32, rtk_of_matchfieldType_t, uint32 *);
    int32   (*of_flowEntrySize_get)(uint32, rtk_of_flowtable_phase_t, uint32 *);
    int32   (*of_flowEntryValidate_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, uint32 *);
    int32   (*of_flowEntryValidate_set)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, uint32);
    int32   (*of_flowEntryFieldList_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_matchfieldList_t *);
    int32   (*of_flowEntryField_check)(uint32, rtk_of_flowtable_phase_t, rtk_of_matchfieldType_t);
    int32   (*of_flowEntryField_read)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_matchfieldType_t, uint8 *, uint8 *);
    int32   (*of_flowEntryField_write)(uint32 , rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_matchfieldType_t, uint8 *, uint8 *);
    int32   (*of_flowEntryOperation_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowOperation_t *);
    int32   (*of_flowEntryOperation_set)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowOperation_t *);
    int32   (*of_flowEntryInstruction_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowIns_t *);
    int32   (*of_flowEntryInstruction_set)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowIns_t *);
    int32   (*of_flowEntrySetField_check)(uint32, rtk_of_flowtable_phase_t, uint32, rtk_of_setFieldType_t);
    int32   (*of_flowEntryHitSts_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, uint32, uint32 *);
    int32   (*of_flowEntry_del)(uint32, rtk_of_flowtable_phase_t, rtk_of_flowClear_t *);
    int32   (*of_flowEntry_move)(uint32, rtk_of_flowtable_phase_t, rtk_of_flowMove_t *);
    int32   (*of_ftTemplateSelector_get)(uint32, rtk_of_flowtable_phase_t, uint32, rtk_of_ftTemplateIdx_t *);
    int32   (*of_ftTemplateSelector_set)(uint32, rtk_of_flowtable_phase_t, uint32 , rtk_of_ftTemplateIdx_t);
    int32   (*of_flowCntMode_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowCntMode_t *);
    int32   (*of_flowCntMode_set)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowCntMode_t);
    int32   (*of_flowCnt_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowCntType_t, uint64 *);
    int32   (*of_flowCnt_clear)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, rtk_of_flowCntType_t);
    int32   (*of_flowCntThresh_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, uint64 *);
    int32   (*of_flowCntThresh_set)(uint32, rtk_of_flowtable_phase_t, rtk_of_flow_id_t, uint64);
    int32   (*of_ttlExcpt_get)(uint32, rtk_action_t *);
    int32   (*of_ttlExcpt_set)(uint32, rtk_action_t);
    int32   (*of_maxLoopback_get)(uint32, uint32 *);
    int32   (*of_maxLoopback_set)(uint32, uint32);
    int32   (*of_l2FlowTblMatchField_get)(uint32, rtk_of_l2FlowTblMatchField_t *);
    int32   (*of_l2FlowTblMatchField_set)(uint32, rtk_of_l2FlowTblMatchField_t);
    int32   (*of_l2FlowEntrySetField_check)(uint32, uint32, rtk_of_setFieldType_t);
    int32   (*of_l2FlowEntry_get)(uint32, rtk_of_l2FlowEntry_t *);
    int32   (*of_l2FlowEntryNextValid_get)(uint32, int32 *, rtk_of_l2FlowEntry_t *);
    int32   (*of_l2FlowEntry_add)(uint32, rtk_of_l2FlowEntry_t *);
    int32   (*of_l2FlowEntry_del)(uint32, rtk_of_l2FlowEntry_t *);
    int32   (*of_l2FlowEntry_delAll)(uint32);
    int32   (*of_l2FlowEntryHitSts_get)(uint32, rtk_of_l2FlowEntry_t *, uint32, uint32 *);
    int32   (*of_l2FlowTblHashAlgo_get)(uint32, uint32, uint32 *);
    int32   (*of_l2FlowTblHashAlgo_set)(uint32, uint32, uint32);
    int32   (*of_l3FlowTblPri_get)(uint32, rtk_of_l3FlowTblList_t *);
    int32   (*of_l3FlowTblPri_set)(uint32, rtk_of_l3FlowTblList_t);
    int32   (*of_l3CamFlowTblMatchField_get)(uint32, rtk_of_l3CamFlowTblMatchField_t *);
    int32   (*of_l3CamFlowTblMatchField_set)(uint32, rtk_of_l3CamFlowTblMatchField_t);
    int32   (*of_l3HashFlowTblMatchField_get)(uint32, rtk_of_l3HashFlowTblMatchField_t *);
    int32   (*of_l3HashFlowTblMatchField_set)(uint32, rtk_of_l3HashFlowTblMatchField_t);
    int32   (*of_l3HashFlowTblHashAlgo_get)(uint32, uint32, uint32 *);
    int32   (*of_l3HashFlowTblHashAlgo_set)(uint32, uint32, uint32);
    int32   (*of_l3FlowEntrySetField_check)(uint32, uint32, rtk_of_setFieldType_t);
    int32   (*of_l3CamFlowEntry_get)(uint32, uint32, rtk_of_l3CamFlowEntry_t *);
    int32   (*of_l3CamFlowEntry_add)(uint32, uint32, rtk_of_l3CamFlowEntry_t *);
    int32   (*of_l3CamFlowEntry_del)(uint32, uint32);
    int32   (*of_l3CamFlowEntry_move)(uint32, rtk_of_flowMove_t *);
    int32   (*of_l3CamflowEntryHitSts_get)(uint32, uint32, uint32, uint32 *);
    int32   (*of_l3HashFlowEntry_get)(uint32, rtk_of_l3HashFlowEntry_t *);
    int32   (*of_l3HashFlowEntryNextValid_get)(uint32, int32 *, rtk_of_l3HashFlowEntry_t *);
    int32   (*of_l3HashFlowEntry_add)(uint32, rtk_of_l3HashFlowEntry_t *);
    int32   (*of_l3HashFlowEntry_del)(uint32, rtk_of_l3HashFlowEntry_t *);
    int32   (*of_l3HashFlowEntry_delAll)(uint32);
    int32   (*of_l3HashflowEntryHitSts_get)(uint32, rtk_of_l3HashFlowEntry_t *, uint32, uint32 *);
    int32   (*of_groupEntry_get)(uint32, uint32, rtk_of_groupEntry_t *);
    int32   (*of_groupEntry_set)(uint32, uint32, rtk_of_groupEntry_t *);
    int32   (*of_groupTblHashPara_get)(uint32, rtk_of_groupTblHashPara_t *);
    int32   (*of_groupTblHashPara_set)(uint32, rtk_of_groupTblHashPara_t *);
    int32   (*of_actionBucket_get)(uint32, uint32, rtk_of_actionBucket_t *);
    int32   (*of_actionBucket_set)(uint32, uint32, rtk_of_actionBucket_t *);
    int32   (*of_trapTarget_get)(uint32, rtk_trapTarget_t *);
    int32   (*of_trapTarget_set)(uint32, rtk_trapTarget_t);
    int32   (*of_tblMissAction_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_tblMissAct_t *);
    int32   (*of_tblMissAction_set)(uint32, rtk_of_flowtable_phase_t, rtk_of_tblMissAct_t);
    int32   (*of_flowTblCnt_get)(uint32, rtk_of_flowtable_phase_t, rtk_of_flowTblCntType_t, uint32 *);

    /* VXLAN */
    int32   (*vxlan_init)(uint32);
    int32   (*vxlan_vni_add)(uint32, rtk_vxlan_vniEntry_t *);
    int32   (*vxlan_vni_del)(uint32, rtk_vxlan_vniEntry_t *);
    int32   (*vxlan_vni_delAll)(uint32);
    int32   (*vxlan_vni_get)(uint32, rtk_vxlan_vniEntry_t *);
    int32   (*vxlan_vni_set)(uint32, rtk_vxlan_vniEntry_t *);
    int32   (*vxlan_vni_getNext)(uint32, int32 *, rtk_vxlan_vniEntry_t *);
    int32   (*vxlan_globalCtrl_get)(uint32, rtk_vxlan_globalCtrlType_t, int32 *);
    int32   (*vxlan_globalCtrl_set)(uint32, rtk_vxlan_globalCtrlType_t, int32);

    /* LED */
    int32   (*led_init)(uint32 );
    int32   (*led_sysEnable_get)(uint32 , rtk_led_type_t , rtk_enable_t *);
    int32   (*led_sysEnable_set)(uint32 , rtk_led_type_t , rtk_enable_t );
    int32   (*led_portLedEntitySwCtrlEnable_get)(uint32, rtk_port_t, uint32, rtk_enable_t *);
    int32   (*led_portLedEntitySwCtrlEnable_set)(uint32, rtk_port_t, uint32, rtk_enable_t);
    int32   (*led_swCtrl_start)(uint32);
    int32   (*led_portLedEntitySwCtrlMode_get)(uint32, rtk_port_t, uint32, rtk_port_media_t, rtk_led_swCtrl_mode_t *);
    int32   (*led_portLedEntitySwCtrlMode_set)(uint32, rtk_port_t, uint32, rtk_port_media_t, rtk_led_swCtrl_mode_t);
    int32   (*led_sysMode_get)(uint32, rtk_led_swCtrl_mode_t *);
    int32   (*led_sysMode_set)(uint32, rtk_led_swCtrl_mode_t);
    int32   (*led_blinkTime_get)(uint32, rtk_led_blinkTime_t *);
    int32   (*led_blinkTime_set)(uint32, rtk_led_blinkTime_t);

    /* Time */
    int32   (*time_init)(uint32 );
    int32   (*time_portPtpEnable_get)(uint32 , rtk_port_t , rtk_enable_t *);
    int32   (*time_portPtpEnable_set)(uint32 , rtk_port_t , rtk_enable_t );
    int32   (*time_portPtpRxTimestamp_get)(uint32 , rtk_port_t , rtk_time_ptpIdentifier_t , rtk_time_timeStamp_t *);
    int32   (*time_portPtpTxTimestamp_get)(uint32 , rtk_port_t , rtk_time_ptpIdentifier_t , rtk_time_timeStamp_t *);
    int32   (*time_portPtpTxTimestampCallback_register)(uint32 , rtk_port_t , rtk_time_ptpIdentifier_t , rtk_time_ptpTime_cb_f *);
    int32   (*time_portRefTime_get)(uint32 , rtk_port_t, rtk_time_timeStamp_t *);
    int32   (*time_portRefTime_set)(uint32 , rtk_portmask_t, rtk_time_timeStamp_t );
    int32   (*time_portRefTimeAdjust_set)(uint32 , rtk_portmask_t,  uint32 , rtk_time_timeStamp_t );
    int32   (*time_portRefTimeEnable_get)(uint32 , rtk_port_t, rtk_enable_t *);
    int32   (*time_portRefTimeEnable_set)(uint32 , rtk_portmask_t, rtk_enable_t );
    int32   (*time_portRefTimeFreq_get)(uint32, rtk_port_t, uint32 *);
    int32   (*time_portRefTimeFreq_set)(uint32, rtk_portmask_t, uint32);

    /* MPLS */
    int32   (*mpls_init)(uint32);
    int32   (*mpls_trapTarget_get)(uint32, rtk_trapTarget_t *);
    int32   (*mpls_trapTarget_set)(uint32, rtk_trapTarget_t);
    int32   (*mpls_enable_get)(uint32, rtk_enable_t *);
    int32   (*mpls_enable_set)(uint32, rtk_enable_t);
    int32   (*mpls_ttlInherit_get)(uint32 , rtk_mpls_ttlInherit_t *);
    int32   (*mpls_ttlInherit_set)(uint32 , rtk_mpls_ttlInherit_t );
    int32   (*mpls_exceptionCtrl_get)(uint32, rtk_mpls_exceptionType_t, rtk_action_t *);
    int32   (*mpls_exceptionCtrl_set)(uint32, rtk_mpls_exceptionType_t, rtk_action_t);
    int32   (*mpls_nextHop_create)(uint32, rtk_mpls_nextHop_t *, rtk_l3_pathId_t *);
    int32   (*mpls_nextHop_destroy)(uint32, rtk_l3_pathId_t);
    int32   (*mpls_nextHop_get)(uint32, rtk_l3_pathId_t, rtk_mpls_nextHop_t *);
    int32   (*mpls_nextHop_set)(uint32, rtk_l3_pathId_t, rtk_mpls_nextHop_t *);
    int32   (*mpls_encap_create)(uint32, rtk_mpls_encap_t *, rtk_mpls_entryId_t *);
    int32   (*mpls_encap_destroy)(uint32, rtk_mpls_entryId_t);
    int32   (*mpls_encap_get)(uint32, rtk_mpls_entryId_t, rtk_mpls_encap_t *);
    int32   (*mpls_encap_set)(uint32, rtk_mpls_entryId_t, rtk_mpls_encap_t *);
    int32   (*mpls_encapId_find)(uint32, rtk_mpls_encap_t *, rtk_mpls_entryId_t *);
    int32   (*mpls_hashAlgo_get)(uint32, uint8 *);
    int32   (*mpls_hashAlgo_set)(uint32, uint8);
    int32   (*mpls_decap_create)(uint32, rtk_mpls_decapEntry_t *, rtk_mpls_entryId_t *);
    int32   (*mpls_decap_destroy)(uint32, rtk_mpls_entryId_t);
    int32   (*mpls_decap_get)(uint32, rtk_mpls_entryId_t, rtk_mpls_decapEntry_t *);
    int32   (*mpls_decap_set)(uint32, rtk_mpls_entryId_t, rtk_mpls_decapEntry_t *);
    int32   (*mpls_decapId_find)(uint32, rtk_mpls_decapEntry_t *, rtk_mpls_entryId_t *);
    int32   (*mpls_egrTcMap_get)(uint32, rtk_mpls_egrTcMapSrc_t *, uint8 *);
    int32   (*mpls_egrTcMap_set)(uint32, rtk_mpls_egrTcMapSrc_t *, uint8);
    int32   (*mpls_nextHop_create_id)(uint32, rtk_mpls_nextHop_t *, rtk_l3_pathId_t);
    int32   (*mpls_encap_create_id)(uint32, rtk_mpls_encap_t *, rtk_mpls_entryId_t);

    /* Stacking */
    int32   (*stack_init)(uint32);
    int32   (*stack_cascade_init)(uint32);
    int32   (*stack_port_get)(uint32, rtk_portmask_t *);
    int32   (*stack_port_set)(uint32, rtk_portmask_t *);
    int32   (*stack_devId_get)(uint32, uint32 *);
    int32   (*stack_devId_set)(uint32, uint32);
    int32   (*stack_masterDevId_get)(uint32, uint32 *);
    int32   (*stack_masterDevId_set)(uint32, uint32);
    int32   (*stack_loopGuard_get)(uint32, rtk_enable_t *);
    int32   (*stack_loopGuard_set)(uint32, rtk_enable_t);
    int32   (*stack_devPortMap_get)(uint32, uint32, rtk_portmask_t *);
    int32   (*stack_devPortMap_set)(uint32, uint32, rtk_portmask_t *);
    int32   (*stack_nonUcastBlockPort_get)(uint32, uint32, rtk_portmask_t *);
    int32   (*stack_nonUcastBlockPort_set)(uint32, uint32, rtk_portmask_t *);
    int32   (*stack_rmtIntrTxEnable_get)(uint32, rtk_enable_t *);
    int32   (*stack_rmtIntrTxEnable_set)(uint32, rtk_enable_t);
    int32   (*stack_rmtIntrTxTriggerEnable_get)(uint32, rtk_enable_t *);
    int32   (*stack_rmtIntrTxTriggerEnable_set)(uint32, rtk_enable_t);
    int32   (*stack_rmtIntrRxSeqCmpMargin_get)(uint32, int32 *);
    int32   (*stack_rmtIntrRxSeqCmpMargin_set)(uint32, int32);
    int32   (*stack_rmtIntrRxForceUpdateEnable_get)(uint32, rtk_enable_t *);
    int32   (*stack_rmtIntrRxForceUpdateEnable_set)(uint32, rtk_enable_t);
    int32   (*stack_rmtIntrInfo_get)(uint32, rtk_stack_rmtIntrInfo_t *);

    /* Diagnostic */
    int32   (*diag_init)(uint32 );
    int32   (*diag_portRtctResult_get)(uint32, rtk_port_t, rtk_rtctResult_t *);
    int32   (*diag_rtctEnable_set)(uint32, rtk_portmask_t *);
    int32   (*diag_table_read)(uint32 , uint32 , uint32 , uint32 *, uint32 *, uint32 *);

    /* SerDes */
    int32   (*sds_init)(uint32 );
    int32   (*sds_symErr_get)(uint32, uint32, rtk_sds_symErr_t *);
    int32   (*sds_symErr_clear)(uint32, uint32);
    int32   (*sds_linkSts_get)(uint32, uint32, rtk_sds_linkSts_t *);
    int32   (*sds_testModeCnt_get)(uint32, uint32, uint32 *);
    int32   (*sds_testMode_set)(uint32, uint32, rtk_sds_testMode_t);
    int32   (*sds_rx_rst)(uint32, uint32);
    int32   (*sds_leq_get)(uint32, uint32, rtk_sds_leq_t *);
    int32   (*sds_leq_set)(uint32, uint32, rtk_sds_leq_t *);
    int32   (*sds_leq_adapt)(uint32, uint32);
    int32   (*sds_xsgNwayEn_set)(uint32, uint32, rtk_enable_t);
    int32   (*sds_cmuBand_get)(uint32, uint32, uint32 *);
    int32   (*sds_cmuBand_set)(uint32, uint32, rtk_enable_t, uint32);
    int32   (*sds_eyeMonitor_start)(uint32, uint32, uint32);
    int32   (*sds_eyeParam_get)(uint32, uint32, rtk_sds_eyeParam_t *);
    int32   (*sds_eyeParam_set)(uint32, uint32, rtk_sds_eyeParam_t);
    int32   (*sds_rxCaliConf_get)(uint32, uint32, rtk_sds_rxCaliConf_t *);
    int32   (*sds_rxCaliConf_set)(uint32, uint32, rtk_sds_rxCaliConf_t);
    int32   (*_sds_mode_get)(uint32, uint32, rtk_serdesMode_t *);
    int32   (*_sds_mode_set)(uint32, uint32, rtk_serdesMode_t);
    int32   (*sds_ePhyReg_set)(uint32, uint32, uint32);
    int32   (*sds_ePhyReg_get)(uint32, uint32, uint32 *);
    int32   (*sds_eyeMonitorInfo_get)(uint32, uint32, uint32, rtk_sds_eyeMonInfo_t *);
    int32   (*sds_info_get)(uint32, uint32, rtk_sds_info_t *);
    int32   (*sds_loopback_get)(uint32, uint32, rtk_enable_t *);
    int32   (*sds_loopback_set)(uint32, uint32, rtk_enable_t);

    /* Debug */
    int32   (*debug_phy_get)(uint32, rtk_phy_debug_t *);
    int32   (*debug_phy_batch_port_set)(uint32 unit, rtk_portmask_t *pPortmask);
    int32   (*debug_phy_batch_op_set)(uint32 unit, rtk_phy_batch_para_t *pPara);

#if (defined(CONFIG_SDK_APP_DIAG_EXT) && defined (CONFIG_SDK_RTL9300))
    int32   (*diag_table_reg_field_get)(uint32, rtk_diag_debug_t *);
    int32   (*diag_table_reg_field_set)(uint32, rtk_diag_debug_t *);
#endif
}__attribute__((aligned(sizeof(int)))) dal_mapper_t ;


/*
 * Macro Definition
 */


/*
 * Function Declaration
 */

/* Module Name : */


#endif /* __DAL_MAPPER_H __ */
