#ifndef __RTK_MANGO_TABLE_STRUCT_H__
#define __RTK_MANGO_TABLE_STRUCT_H__

/*
 * Include Files
 */
#include <common/rt_autoconf.h>
#ifdef __BOOTLOADER__
#include <hal/chipdef/mango/rtk_mango_uboot_feature_def.h>
#else   /* __BOOTLOADER__ */
#include <hal/chipdef/mango/rtk_mango_feature_def.h>
#endif  /* __BOOTLOADER__ */

/* Superset Table Enum */
typedef enum rtk_mango_table_list_e
{
#if defined(CONFIG_SDK_CHIP_FEATURE_802_1Q_VLAN___QINQ)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLANt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_UNTAGt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_802_1Q_VLAN___QINQ */
#if defined(CONFIG_SDK_CHIP_FEATURE_VLAN_TRANSLATION)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASEDt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASEDt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_VLAN_TRANSLATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAGt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_SRC_TRK_MAPt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTIt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PORT_ISO_CTRLt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MAC_FORWARDING_CONTROL)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MC_PMSKt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MAC_FORWARDING_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_EGRESS_BANDWIDTH_CONTROL)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BWt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_EGRESS_BANDWIDTH_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_METER_MARKER)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METERt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_METER_MARKER */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Qt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE */
#if defined(CONFIG_SDK_CHIP_FEATURE_REMARKING)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_REMARKt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_REMARKING */
#if defined(CONFIG_SDK_CHIP_FEATURE_LAYER_3_ROUTING)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMPt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTFt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_CNTRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LISTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_TUNNEL_INTF_CNTRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_4t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_5t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTFt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_CNTRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_TUNNEL_INTF_CNTRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_NEXTHOPt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUCt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MACt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LAYER_3_ROUTING */
#if defined(CONFIG_SDK_CHIP_FEATURE_IP_TUNNEL)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_STARTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAPt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATIONt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_2t,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_IP_TUNNEL */
#if defined(CONFIG_SDK_CHIP_FEATURE_MPLS_VPLS)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAPt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAPt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_NHt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MPLS_VPLS */
#if defined(CONFIG_SDK_CHIP_FEATURE_MIB_COUNTER)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTRt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MIB_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOW_BASED_COUNTER)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FLOW_CNTRt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOW_BASED_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_PRIVATE_COUNTER)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_AUTO_RECOVERY_TXERR_CNTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTRt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PRIVATE_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_ACL)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACLt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACLt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACLt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ACL */
#if defined(CONFIG_SDK_CHIP_FEATURE_IP_MAC_BIDING)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BINDt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYNt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_IP_MAC_BIDING */
#if defined(CONFIG_SDK_CHIP_FEATURE_OPENFLOW)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKETt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGRt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_GROUP_TBLt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OF_DMACt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_OPENFLOW */
#if defined(CONFIG_SDK_CHIP_FEATURE_L2_TUNNEL)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSIDt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_LISTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TUNNEL_STARTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_LSTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCASTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCASTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLANt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_ENCAPt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_1t,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCASTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCASTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAMt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_L2_TUNNEL */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_EXTENSION)
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PMSK_LISTt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVIDt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAMt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWDt,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAMt,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_EXTENSION */

    MANGO_TABLE_LIST_END,
} rtk_mango_table_list_t;


/* Internal Table Enum */
typedef enum rtk_int_mango_table_list_e
{
#if defined(CONFIG_SDK_CHIP_FEATURE_802_1Q_VLAN___QINQ)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VLAN_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VLAN_UNTAG_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_802_1Q_VLAN___QINQ */
#if defined(CONFIG_SDK_CHIP_FEATURE_VLAN_TRANSLATION)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VLAN_EVC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VLAN_IP_BASED_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VLAN_IVC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VLAN_MAC_BASED_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_VLAN_TRANSLATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_LAG_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_SRC_TRK_MAP_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_MSTI_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_PORT_ISO_CTRL_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MAC_FORWARDING_CONTROL)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_CAM_CB_MC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_CAM_CB_UC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_CAM_MC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_CAM_UC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_CB_MC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_CB_UC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_MC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_UC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_MC_PMSK_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MAC_FORWARDING_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_EGRESS_BANDWIDTH_CONTROL)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_EGR_Q_BW_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_EGRESS_BANDWIDTH_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_METER_MARKER)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_METER_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_METER_MARKER */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_OUT_Q_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE */
#if defined(CONFIG_SDK_CHIP_FEATURE_REMARKING)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_REMARK_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_REMARKING */
#if defined(CONFIG_SDK_CHIP_FEATURE_LAYER_3_ROUTING)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_ECMP_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_EGR_INTF_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_EGR_INTF_CNTR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_EGR_INTF_LIST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_EGR_TUNNEL_INTF_CNTR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6MC_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6MC_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6MC_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6MC_3_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6MC_4_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6MC_5_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6UC_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6UC_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IP6UC_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IPMC_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IPMC_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_HOST_ROUTE_IPUC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_IGR_INTF_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_IGR_INTF_CNTR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_IGR_TUNNEL_INTF_CNTR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_NEXTHOP_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6MC_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6MC_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6MC_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6MC_3_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6MC_4_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6MC_5_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6UC_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6UC_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IP6UC_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IPMC_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IPMC_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_PREFIX_ROUTE_IPUC_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L3_ROUTER_MAC_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_LAYER_3_ROUTING */
#if defined(CONFIG_SDK_CHIP_FEATURE_IP_TUNNEL)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_START_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_START_ENCAP_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_START_ENCAP_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_START_ENCAP_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_TERMINATION_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_TERMINATION_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_TUNNEL_TERMINATION_2_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_IP_TUNNEL */
#if defined(CONFIG_SDK_CHIP_FEATURE_MPLS_VPLS)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_MPLS_DECAP_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_MPLS_DECAP_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_MPLS_ENCAP_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_MPLS_NH_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MPLS_VPLS */
#if defined(CONFIG_SDK_CHIP_FEATURE_MIB_COUNTER)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_STAT_PORT_MIB_CNTR_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_MIB_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOW_BASED_COUNTER)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FLOW_CNTR_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOW_BASED_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_PRIVATE_COUNTER)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_AUTO_RECOVERY_TXERR_CNT_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_STAT_PORT_PRVTE_CNTR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_STAT_PORT_PRVTE_E_Q_CNTR_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PRIVATE_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_ACL)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_EACL_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_IACL_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VACL_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_ACL */
#if defined(CONFIG_SDK_CHIP_FEATURE_IP_MAC_BIDING)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_IP_MAC_BIND_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_IP_MAC_BIND_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_IP_MAC_BIND_DYN_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_IP_MAC_BIDING */
#if defined(CONFIG_SDK_CHIP_FEATURE_OPENFLOW)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_ACTION_BUCKET_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_EGR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_IGR_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_CAM_FMT0_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_CAM_FMT0_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_CAM_FMT1_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_CAM_FMT1_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_CAM_FMT2_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_HASH_FMT0_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_HASH_FMT0_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_HASH_FMT1_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_HASH_FMT1_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_HASH_FMT2_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L2_HASH_FMT2_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L3_HASH_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L3_HASH_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L3_HASH_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L3_TCAM_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L3_TCAM_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_FT_L3_TCAM_2_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_GROUP_TBL_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_OF_DMAC_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_OPENFLOW */
#if defined(CONFIG_SDK_CHIP_FEATURE_L2_TUNNEL)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_BSSID_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_BSSID_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_BSSID_LIST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_BSSID_TUNNEL_START_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_CAPWAP_TUNNEL_START_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_CAPWAP_TUNNEL_START_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_LST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_MCAST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_MCAST_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_UCAST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_UCAST_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_VXLAN_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_VXLAN_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_L2_TNL_VXLAN_ENCAP_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VXLAN_TUNNEL_START_0_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_VXLAN_TUNNEL_START_1_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_WLC_MCAST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_WLC_MCAST_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_WLC_UCAST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_WLC_UCAST_CAM_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_L2_TUNNEL */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_EXTENSION)
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_ECID_PMSK_LIST_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_ECID_PVID_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_ECID_PVID_CAM_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_PE_FWD_RTL9310,
#endif
#if defined(CONFIG_SDK_RTL9310)
    INT_MANGO_PE_FWD_CAM_RTL9310,
#endif
#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_EXTENSION */

    INT_MANGO_TABLE_LIST_END,
} rtk_int_mango_table_list_t;

#if defined(CONFIG_SDK_CHIP_FEATURE_802_1Q_VLAN___QINQ)

typedef enum rtk_mango_vlanField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MBRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MSTItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_L2_HKEY_UCASTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_L2_HKEY_MCASTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_L3_INTF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_VLAN_PROFILEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_GROUP_MASKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_L2_TNL_LST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_L2_TNL_LST_IDXtf,
#endif

    MANGO_VLANFIELD_LIST_END,
} rtk_mango_vlanField_list_t;


typedef enum rtk_mango_vlan_untagField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_UNTAG_UNTAGtf,
#endif

    MANGO_VLAN_UNTAGFIELD_LIST_END,
} rtk_mango_vlan_untagField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_802_1Q_VLAN___QINQ */
#if defined(CONFIG_SDK_CHIP_FEATURE_VLAN_TRANSLATION)

typedef enum rtk_mango_vlan_evcField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_OTAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_ITAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_INT_VID_RNG_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_OTAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_ITAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_BMSK_INT_VID_RNG_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OTPID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OTPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OTAG_STS_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OTAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OPRI_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OVID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_ITPID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_ITPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_ITAG_STS_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_ITAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_IPRI_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_IVID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_EVC_IVIDtf,
#endif

    MANGO_VLAN_EVCFIELD_LIST_END,
} rtk_mango_vlan_evcField_list_t;


typedef enum rtk_mango_vlan_ip_basedField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_OVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_IVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BMSK_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BMSK_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BMSK_OVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BMSK_IVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BMSK_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_FWD_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_IGNORE_IGR_FLTRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BSSID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_BSSID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_VLAN_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_TPID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_TAG_STS_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_TAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_PRI_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_VID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IP_BASED_VIDtf,
#endif

    MANGO_VLAN_IP_BASEDFIELD_LIST_END,
} rtk_mango_vlan_ip_basedField_list_t;


typedef enum rtk_mango_vlan_ivcField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_OTAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_ITAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ORI_VID_RNG_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_OTAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_ITAG_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_BMSK_ORI_VID_RNG_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OTPID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OTPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OTAG_STS_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OTAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OPRI_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OVID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ITPID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ITPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ITAG_STS_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_ITAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_IPRI_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_IVID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_INTERFACE_ID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_IVC_INTERFACE_IDtf,
#endif

    MANGO_VLAN_IVCFIELD_LIST_END,
} rtk_mango_vlan_ivcField_list_t;


typedef enum rtk_mango_vlan_mac_basedField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_OVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_IVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_SMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BMSK_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BMSK_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BMSK_OVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BMSK_IVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BMSK_SMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_FWD_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_IGNORE_IGR_FLTRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BSSID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_BSSID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_VLAN_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_TPID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_TAG_STS_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_TAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_PRI_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_VID_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VLAN_MAC_BASED_VIDtf,
#endif

    MANGO_VLAN_MAC_BASEDFIELD_LIST_END,
} rtk_mango_vlan_mac_basedField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_VLAN_TRANSLATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION)

typedef enum rtk_mango_lagField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_NUM_TX_CANDItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_L2_HASH_MSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_IP4_HASH_MSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_IP6_HASH_MSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_SEP_FLOOD_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_SEP_KWN_MC_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_DEV0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_LAG_TRK_PORT0tf,
#endif

    MANGO_LAGFIELD_LIST_END,
} rtk_mango_lagField_list_t;


typedef enum rtk_mango_src_trk_mapField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_SRC_TRK_MAP_TRK_ID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_SRC_TRK_MAP_TRK_IDtf,
#endif

    MANGO_SRC_TRK_MAPFIELD_LIST_END,
} rtk_mango_src_trk_mapField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_LINK_AGGREGATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE)

typedef enum rtk_mango_mstiField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT55tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT54tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT53tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT52tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT51tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT50tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT49tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT48tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT47tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT46tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT45tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT44tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT43tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT42tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT41tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT40tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT39tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT38tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT37tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT36tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT35tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT34tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT33tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT32tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT31tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT30tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT29tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT28tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT27tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT26tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT25tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT24tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT23tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT22tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT21tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT20tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT19tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT18tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT17tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT16tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT15tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT14tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MSTI_STATE_PORT0tf,
#endif

    MANGO_MSTIFIELD_LIST_END,
} rtk_mango_mstiField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_SPANNING_TREE */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION)

typedef enum rtk_mango_port_iso_ctrlField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PORT_ISO_CTRL_PMSKtf,
#endif

    MANGO_PORT_ISO_CTRLFIELD_LIST_END,
} rtk_mango_port_iso_ctrlField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_ISOLATION */
#if defined(CONFIG_SDK_CHIP_FEATURE_MAC_FORWARDING_CONTROL)

typedef enum rtk_mango_l2_cam_cb_mcField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_LOCAL_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_MCAST_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_ECID_LST_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_ECID_PMSK_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_MC_LST_TYPEtf,
#endif

    MANGO_L2_CAM_CB_MCFIELD_LIST_END,
} rtk_mango_l2_cam_cb_mcField_list_t;


typedef enum rtk_mango_l2_cam_cb_ucField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_L2_TNLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_SPAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_AGEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_SA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_DA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_STATICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_SUSPENDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_DUP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_DUP_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_CB_UC_DUP_SPAtf,
#endif

    MANGO_L2_CAM_CB_UCFIELD_LIST_END,
} rtk_mango_l2_cam_cb_ucField_list_t;


typedef enum rtk_mango_l2_cam_mcField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_LOCAL_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_MC_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_REMOTE_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_L2_TNL_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_BPE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_DUP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_DUP_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_MC_DUP_SPAtf,
#endif

    MANGO_L2_CAM_MCFIELD_LIST_END,
} rtk_mango_l2_cam_mcField_list_t;


typedef enum rtk_mango_l2_cam_ucField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_L2_TNLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_SPAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_AGEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_SA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_DA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_STATICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_SUSPENDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_TAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_AGG_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_AGG_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_DUP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_DUP_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CAM_UC_DUP_SPAtf,
#endif

    MANGO_L2_CAM_UCFIELD_LIST_END,
} rtk_mango_l2_cam_ucField_list_t;


typedef enum rtk_mango_l2_cb_mcField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_LOCAL_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_MCAST_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_ECID_LST_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_ECID_PMSK_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_MC_LST_TYPEtf,
#endif

    MANGO_L2_CB_MCFIELD_LIST_END,
} rtk_mango_l2_cb_mcField_list_t;


typedef enum rtk_mango_l2_cb_ucField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_L2_TNLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_SPAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_AGEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_SA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_DA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_STATICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_SUSPENDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_DUP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_DUP_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_CB_UC_DUP_SPAtf,
#endif

    MANGO_L2_CB_UCFIELD_LIST_END,
} rtk_mango_l2_cb_ucField_list_t;


typedef enum rtk_mango_l2_mcField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_HASH_MSBtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_LOCAL_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_MC_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_REMOTE_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_L2_TNL_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_BPE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_DUP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_DUP_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_MC_DUP_SPAtf,
#endif

    MANGO_L2_MCFIELD_LIST_END,
} rtk_mango_l2_mcField_list_t;


typedef enum rtk_mango_l2_ucField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_HASH_MSBtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_L2_TNLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_SPAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_AGEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_SA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_DA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_STATICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_SUSPENDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_TAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_AGG_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_AGG_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_DUP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_DUP_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_UC_DUP_SPAtf,
#endif

    MANGO_L2_UCFIELD_LIST_END,
} rtk_mango_l2_ucField_list_t;


typedef enum rtk_mango_mc_pmskField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MC_PMSK_PMSKtf,
#endif

    MANGO_MC_PMSKFIELD_LIST_END,
} rtk_mango_mc_pmskField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_MAC_FORWARDING_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_EGRESS_BANDWIDTH_CONTROL)

typedef enum rtk_mango_egr_q_bwField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_MODE_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_LB_BURST_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_ASSURED_BW_EN_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_LB_BURST_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EGR_Q_BW_MAX_BW_EN_Q0tf,
#endif

    MANGO_EGR_Q_BWFIELD_LIST_END,
} rtk_mango_egr_q_bwField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_EGRESS_BANDWIDTH_CONTROL */
#if defined(CONFIG_SDK_CHIP_FEATURE_METER_MARKER)

typedef enum rtk_mango_meterField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_MODEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_COLOR_AWAREtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_RSTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_LB0_RATEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_LB0_BStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_LB1_RATEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_LB1_BStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_METER_RSERVEDtf,
#endif

    MANGO_METERFIELD_LIST_END,
} rtk_mango_meterField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_METER_MARKER */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE)

typedef enum rtk_mango_out_qField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_PORT_USED_PAGE_CNTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_PORT_MAX_USED_PAGE_CNTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_USED_PAGE_CNT_Q0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OUT_Q_MAX_USED_PAGE_CNT_Q0tf,
#endif

    MANGO_OUT_QFIELD_LIST_END,
} rtk_mango_out_qField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOWCONTROL___BACKPRESSURE */
#if defined(CONFIG_SDK_CHIP_FEATURE_REMARKING)

typedef enum rtk_mango_remarkField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_REMARK_IPRI_DFLT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_REMARK_OPRI_DFLT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_REMARK_IPRI_DFLT_SRCtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_REMARK_OPRI_DFLT_SRCtf,
#endif

    MANGO_REMARKFIELD_LIST_END,
} rtk_mango_remarkField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_REMARKING */
#if defined(CONFIG_SDK_CHIP_FEATURE_LAYER_3_ROUTING)

typedef enum rtk_mango_l3_ecmpField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_0_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_1_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_2_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_3_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_4_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_5_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_6_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_7_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_8_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_9_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_10_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_11_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_12_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_13_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_14_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_HASH_15_NH_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_NH_IDX_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_METER_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ECMP_METER_IDXtf,
#endif

    MANGO_L3_ECMPFIELD_LIST_END,
} rtk_mango_l3_ecmpField_list_t;


typedef enum rtk_mango_l3_egr_intfField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_DST_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_SMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP_MTU_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP6_MTU_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IPMC_TTL_SCOPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP6MC_HL_SCOPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP_ICMP_REDIRECT_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP6_ICMP_REDIRECT_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP_PBR_ICMP_REDIRECT_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_IP6_PBR_ICMP_REDIRECT_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_TUNNEL_IFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_TUNNEL_IDXtf,
#endif

    MANGO_L3_EGR_INTFFIELD_LIST_END,
} rtk_mango_l3_egr_intfField_list_t;


typedef enum rtk_mango_l3_egr_intf_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_CNTR_IF_OUT_OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_CNTR_IF_OUT_UCAST_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_CNTR_IF_OUT_MULTICAST_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_CNTR_IF_OUT_BROADCAST_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_CNTR_IF_OUT_DISCARDStf,
#endif

    MANGO_L3_EGR_INTF_CNTRFIELD_LIST_END,
} rtk_mango_l3_egr_intf_cntrField_list_t;


typedef enum rtk_mango_l3_egr_intf_listField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_OIL_NEXTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_TTL_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_SA_REPLACEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_L3_EGR_INTF_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_L2_TNL_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_MC_PMSK_L2_TNL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_DST_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_INTF_LIST_ECIDtf,
#endif

    MANGO_L3_EGR_INTF_LISTFIELD_LIST_END,
} rtk_mango_l3_egr_intf_listField_list_t;


typedef enum rtk_mango_l3_egr_tunnel_intf_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_TUNNEL_INTF_CNTR_IF_OUT_OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_TUNNEL_INTF_CNTR_IF_OUT_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_EGR_TUNNEL_INTF_CNTR_IF_OUT_DROPStf,
#endif

    MANGO_L3_EGR_TUNNEL_INTF_CNTRFIELD_LIST_END,
} rtk_mango_l3_egr_tunnel_intf_cntrField_list_t;


typedef enum rtk_mango_l3_host_route_ip6mc_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_MC_KEY_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_VID_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L2_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L2_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L2_MC_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L2_MC_TNL_LST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L2_MC_TNL_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L3_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_L3_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_RPF_CHK_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_RPF_FAIL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_OIL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_OIL_IDX_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_TTL_MINtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_0_HITtf,
#endif

    MANGO_L3_HOST_ROUTE_IP6MC_0FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6mc_0Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6mc_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_STACK_FWD_PMSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_L2_CHK_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_L3_RPF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_1_MTU_MAXtf,
#endif

    MANGO_L3_HOST_ROUTE_IP6MC_1FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6mc_1Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6mc_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_2_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_2_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_2_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_2_SIP6tf,
#endif

    MANGO_L3_HOST_ROUTE_IP6MC_2FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6mc_2Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6mc_3Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3_GIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_3_VIDtf,
#endif

    MANGO_L3_HOST_ROUTE_IP6MC_3FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6mc_3Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6mc_4Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_4_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_4_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_4_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_4_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_4_GIP6tf,
#endif

    MANGO_L3_HOST_ROUTE_IP6MC_4FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6mc_4Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6mc_5Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_5_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_5_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_5_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_5_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6MC_5_GIP6tf,
#endif

    MANGO_L3_HOST_ROUTE_IP6MC_5FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6mc_5Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6uc_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_DST_NULL_INTFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_ECMP_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_NH_ECMP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_TTL_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_0_HITtf,
#endif

    MANGO_L3_HOST_ROUTE_IP6UC_0FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6uc_0Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6uc_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_1_IP6tf,
#endif

    MANGO_L3_HOST_ROUTE_IP6UC_1FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6uc_1Field_list_t;


typedef enum rtk_mango_l3_host_route_ip6uc_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_2_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_2_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IP6UC_2_IP6tf,
#endif

    MANGO_L3_HOST_ROUTE_IP6UC_2FIELD_LIST_END,
} rtk_mango_l3_host_route_ip6uc_2Field_list_t;


typedef enum rtk_mango_l3_host_route_ipmc_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_MC_KEY_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_VID_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L2_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L2_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L2_MC_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L2_MC_TNL_LST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L2_MC_TNL_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L3_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_L3_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_RPF_CHK_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_RPF_FAIL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_OIL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_OIL_IDX_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_TTL_MINtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_0_HITtf,
#endif

    MANGO_L3_HOST_ROUTE_IPMC_0FIELD_LIST_END,
} rtk_mango_l3_host_route_ipmc_0Field_list_t;


typedef enum rtk_mango_l3_host_route_ipmc_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_GIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_STACK_FWD_PMSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_L2_CHK_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_L3_RPF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPMC_1_MTU_MAXtf,
#endif

    MANGO_L3_HOST_ROUTE_IPMC_1FIELD_LIST_END,
} rtk_mango_l3_host_route_ipmc_1Field_list_t;


typedef enum rtk_mango_l3_host_route_ipucField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_DST_NULL_INTFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_ECMP_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_NH_ECMP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_TTL_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_HOST_ROUTE_IPUC_HITtf,
#endif

    MANGO_L3_HOST_ROUTE_IPUCFIELD_LIST_END,
} rtk_mango_l3_host_route_ipucField_list_t;


typedef enum rtk_mango_l3_igr_intfField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IPUC_ROUTE_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6UC_ROUTE_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IPMC_ROUTE_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6MC_ROUTE_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IPMC_ROUTE_LU_MIS_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6MC_ROUTE_LU_MIS_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IPMC_ACT_224_0_0_Xtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IPMC_ACT_224_0_1_Xtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IPMC_ACT_239_X_X_Xtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6MC_ACT_0000_00XXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_MLD_ACT_0_X_Xtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_MLD_ACT_DB8_X_Xtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_ND_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP_URPF_FAIL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP_URPF_CHK_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP_URPF_DFLT_ROUTE_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP_URPF_CHK_MODEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_URPF_FAIL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_URPF_CHK_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_URPF_DFLT_ROUTE_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_IP6_URPF_CHK_MODEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_MC_KEY_SELtf,
#endif

    MANGO_L3_IGR_INTFFIELD_LIST_END,
} rtk_mango_l3_igr_intfField_list_t;


typedef enum rtk_mango_l3_igr_intf_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_CNTR_IF_IN_OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_CNTR_IF_IN_UCAST_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_CNTR_IF_IN_MULTICAST_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_CNTR_IF_IN_BROADCAST_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_INTF_CNTR_IF_IN_DISCARDStf,
#endif

    MANGO_L3_IGR_INTF_CNTRFIELD_LIST_END,
} rtk_mango_l3_igr_intf_cntrField_list_t;


typedef enum rtk_mango_l3_igr_tunnel_intf_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_TUNNEL_INTF_CNTR_IF_IN_OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_TUNNEL_INTF_CNTR_IF_IN_PKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_IGR_TUNNEL_INTF_CNTR_IF_IN_DROPStf,
#endif

    MANGO_L3_IGR_TUNNEL_INTF_CNTRFIELD_LIST_END,
} rtk_mango_l3_igr_tunnel_intf_cntrField_list_t;


typedef enum rtk_mango_l3_nexthopField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_NEXTHOP_DMAC_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_NEXTHOP_L3_EGR_INTF_IDXtf,
#endif

    MANGO_L3_NEXTHOPFIELD_LIST_END,
} rtk_mango_l3_nexthopField_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6mc_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_MC_KEY_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_MC_KEY_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_BMSK_RESERVEDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_VID_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L2_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L2_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L2_MC_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L2_MC_TNL_LST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L2_MC_TNL_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L3_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_L3_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_RPF_CHK_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_RPF_FAIL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_OIL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_OIL_IDX_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_TTL_MINtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_0_HITtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6MC_0FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6mc_0Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6mc_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_BMSK_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_STACK_FWD_PMSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_L2_CHK_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_L3_RPF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_1_MTU_MAXtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6MC_1FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6mc_1Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6mc_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_2_BMSK_IP6tf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6MC_2FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6mc_2Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6mc_3Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_GIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_ROUNDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_GIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_ROUNDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_3_BMSK_RESERVEDtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6MC_3FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6mc_3Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6mc_4Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_GIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_4_BMSK_IP6tf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6MC_4FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6mc_4Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6mc_5Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_GIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6MC_5_BMSK_IP6tf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6MC_5FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6mc_5Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6uc_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_BMSK_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_BMSK_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_BMSK_RESERVEDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_HOST_ROUTEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_DFLT_ROUTEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_DST_NULL_INTFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_ECMP_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_NH_ECMP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_TTL_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_0_HITtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6UC_0FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6uc_0Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6uc_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_BMSK_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_1_BMSK_RESERVEDtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6UC_1FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6uc_1Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ip6uc_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_BMSK_IP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IP6UC_2_BMSK_RESERVEDtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IP6UC_2FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ip6uc_2Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ipmc_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_MC_KEY_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_MC_KEY_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_BMSK_RESERVEDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_VID_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L2_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L2_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L2_MC_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L2_MC_TNL_LST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L2_MC_TNL_LST_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L3_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_L3_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_RPF_CHK_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_RPF_FAIL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_OIL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_OIL_IDX_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_TTL_MINtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_0_HITtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IPMC_0FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ipmc_0Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ipmc_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_GIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_ROUNDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_IPMC_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_GIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_ROUNDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_BMSK_RESERVEDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_STACK_FWD_PMSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_L2_CHK_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_L3_RPF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPMC_1_MTU_MAXtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IPMC_1FIELD_LIST_END,
} rtk_mango_l3_prefix_route_ipmc_1Field_list_t;


typedef enum rtk_mango_l3_prefix_route_ipucField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_BMSK_VRF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_BMSK_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_BMSK_RESERVEDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_HOST_ROUTEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_DFLT_ROUTEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_DST_NULL_INTFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_ECMP_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_NH_ECMP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_TTL_CHKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_QOS_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_QOS_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_PREFIX_ROUTE_IPUC_HITtf,
#endif

    MANGO_L3_PREFIX_ROUTE_IPUCFIELD_LIST_END,
} rtk_mango_l3_prefix_route_ipucField_list_t;


typedef enum rtk_mango_l3_router_macField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_INTF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_LU_PHASEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_L3_INTFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_INTF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_LU_PHASEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_L3_INTFtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_BMSK_RESERVEDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L3_ROUTER_MAC_ACTtf,
#endif

    MANGO_L3_ROUTER_MACFIELD_LIST_END,
} rtk_mango_l3_router_macField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_LAYER_3_ROUTING */
#if defined(CONFIG_SDK_CHIP_FEATURE_IP_TUNNEL)

typedef enum rtk_mango_tunnel_startField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_TUNNEL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_TTL_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_NH_INFO_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_NH_DMAC_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_L3_EGR_INTF_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_PE_ECID_EXTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_PE_ECID_BASEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_REF_L3_HDR_LENtf,
#endif

    MANGO_TUNNEL_STARTFIELD_LIST_END,
} rtk_mango_tunnel_startField_list_t;


typedef enum rtk_mango_tunnel_start_encapField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_TUNNEL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_TTL_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_TTL_DECtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_DONT_FRAG_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_DONT_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_L4_MSB_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_L4_LSB_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_QOS_PROFILE_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_VXLAN_ITAG_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_VXLAN_OTAG_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_VXLAN_VNItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_GRE_KEY_ADDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_FVID_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_DBL_TAG_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_DBL_TAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_ITAG_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_L3_EGR_INTF_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_NH_DMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_NH_SMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_ITAG_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_OTAG_TPID_IDXtf,
#endif

    MANGO_TUNNEL_START_ENCAPFIELD_LIST_END,
} rtk_mango_tunnel_start_encapField_list_t;


typedef enum rtk_mango_tunnel_start_encap_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_1_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_1_FLOW_LABELtf,
#endif

    MANGO_TUNNEL_START_ENCAP_1FIELD_LIST_END,
} rtk_mango_tunnel_start_encap_1Field_list_t;


typedef enum rtk_mango_tunnel_start_encap_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_2_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_START_ENCAP_2_DIPtf,
#endif

    MANGO_TUNNEL_START_ENCAP_2FIELD_LIST_END,
} rtk_mango_tunnel_start_encap_2Field_list_t;


typedef enum rtk_mango_tunnel_terminationField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_INTF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_PROTO_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_L4_MSB_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_L4_LSB_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_GRE_KEY_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_INTF_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_PROTO_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_L4_MSB_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_L4_LSB_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_BMSK_GRE_KEY_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_TUNNEL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_INNER_IPV4_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_INNER_IPV6_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_USE_TUNNEL_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_USE_TUNNEL_DSCPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_KEEP_TUNNEL_DSCPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_PRI_SEL_TBL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_TUNNEL_INTF_IDtf,
#endif

    MANGO_TUNNEL_TERMINATIONFIELD_LIST_END,
} rtk_mango_tunnel_terminationField_list_t;


typedef enum rtk_mango_tunnel_termination_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_1_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_1_SIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_1_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_1_BMSK_SIP6tf,
#endif

    MANGO_TUNNEL_TERMINATION_1FIELD_LIST_END,
} rtk_mango_tunnel_termination_1Field_list_t;


typedef enum rtk_mango_tunnel_termination_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_2_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_2_DIP6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_2_BMSK_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_TUNNEL_TERMINATION_2_BMSK_DIP6tf,
#endif

    MANGO_TUNNEL_TERMINATION_2FIELD_LIST_END,
} rtk_mango_tunnel_termination_2Field_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_IP_TUNNEL */
#if defined(CONFIG_SDK_CHIP_FEATURE_MPLS_VPLS)

typedef enum rtk_mango_mpls_decapField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_LABELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_DECAP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_ECMP_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_TTL_INHERITtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_DSCP_INHERITtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_PRI_SEL_TBL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_INT_PRI_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_INTF_IDtf,
#endif

    MANGO_MPLS_DECAPFIELD_LIST_END,
} rtk_mango_mpls_decapField_list_t;


typedef enum rtk_mango_mpls_decap_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_LABELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_DECAP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_ECMP_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_TTL_INHERITtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_DSCP_INHERITtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_PRI_SEL_TBL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_INT_PRI_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_DECAP_CAM_INTF_IDtf,
#endif

    MANGO_MPLS_DECAP_CAMFIELD_LIST_END,
} rtk_mango_mpls_decap_camField_list_t;


typedef enum rtk_mango_mpls_encapField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_LABEL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_LABELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_NEXT_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_NEXT_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_TTL_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_TC_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_ENCAP_TCtf,
#endif

    MANGO_MPLS_ENCAPFIELD_LIST_END,
} rtk_mango_mpls_encapField_list_t;


typedef enum rtk_mango_mpls_nhField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_NH_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_MPLS_NH_MPLS_ENCAP_IDXtf,
#endif

    MANGO_MPLS_NHFIELD_LIST_END,
} rtk_mango_mpls_nhField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_MPLS_VPLS */
#if defined(CONFIG_SDK_CHIP_FEATURE_MIB_COUNTER)

typedef enum rtk_mango_stat_port_mib_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINOCTETS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINOCTETS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTOCTETS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTOCTETS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINUCASTPKTS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINUCASTPKTS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINMULTICASTPKTS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINMULTICASTPKTS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINBROADCASTPKTS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFINBROADCASTPKTS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTUCASTPKTS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTUCASTPKTS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTMULTICASTPKTS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTMULTICASTPKTS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTBROADCASTPKTS_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTBROADCASTPKTS_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_IFOUTDISCARDStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT1DTPPORTINDISCARDStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3STATSSINGLECOLLISIONFRAMEStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3STATSMULTIPLECOLLISIONFRAMEStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3STATSDEFERREDTRANSMISSIONStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3STATSLATECOLLISIONStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3STATSEXCESSIVECOLLISIONStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3STATSSYMBOLERRORStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3CONTROLINUNKNOWNOPCODEStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3INPAUSEFRAMEStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_DOT3OUTPAUSEFRAMEStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_ETHERSTATSDROPEVENTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSBROADCASTPKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSMULTICASTPKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSCRCALIGNERRORStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSCRCALIGNERRORStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSUNDERSIZEPKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSUNDERSIZEPKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSOVERSIZEPKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSOVERSIZEPKTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSFRAGMENTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSFRAGMENTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSJABBERStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSJABBERStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSCOLLISIONStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSPKTS64OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSPKTS64OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSPKTS65TO127OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSPKTS65TO127OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSPKTS128TO255OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSPKTS128TO255OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSPKTS256TO511OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSPKTS256TO511OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSPKTS512TO1023OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSPKTS512TO1023OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_TX_ETHERSTATSPKTS1024TO1518OCTETStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_MIB_CNTR_RX_ETHERSTATSPKTS1024TO1518OCTETStf,
#endif

    MANGO_STAT_PORT_MIB_CNTRFIELD_LIST_END,
} rtk_mango_stat_port_mib_cntrField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_MIB_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_FLOW_BASED_COUNTER)

typedef enum rtk_mango_flow_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FLOW_CNTR_CNTR_MODEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FLOW_CNTR_PKT_CNTR_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FLOW_CNTR_PKT_CNTR_Ltf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FLOW_CNTR_BYTE_CNTR_Htf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FLOW_CNTR_BYTE_CNTR_Ltf,
#endif

    MANGO_FLOW_CNTRFIELD_LIST_END,
} rtk_mango_flow_cntrField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_FLOW_BASED_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_PRIVATE_COUNTER)

typedef enum rtk_mango_auto_recovery_txerr_cntField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_AUTO_RECOVERY_TXERR_CNT_TXERR_CNTtf,
#endif

    MANGO_AUTO_RECOVERY_TXERR_CNTFIELD_LIST_END,
} rtk_mango_auto_recovery_txerr_cntField_list_t;


typedef enum rtk_mango_stat_port_prvte_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSUNDERSIZEDROPPKTSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_TX_ETHERSTATSPKTS1519TOMAXOCTETSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSPKTS1519TOMAXOCTETSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_TX_ETHERSTATSPKTSOVERMAXOCTETSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSPKTSOVERMAXOCTETSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_TX_ETHERSTATSPKTSFLEXIBLEOCTETSSET1RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSPKTSFLEXIBLEOCTETSSET1RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_TX_ETHERSTATSPKTSFLEXIBLEOCTETSCRCSET1RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSPKTSFLEXIBLEOCTETSCRCSET1RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_TX_ETHERSTATSPKTSFLEXIBLEOCTETSSET0RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSPKTSFLEXIBLEOCTETSSET0RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_TX_ETHERSTATSPKTSFLEXIBLEOCTETSCRCSET0RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RX_ETHERSTATSPKTSFLEXIBLEOCTETSCRCSET0RTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_LENGTHFIELDERRORRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_FALSECARRIERTIMESRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_UNDERSIZEOCTETSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_FRAMINGERRORSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RXMACDISCARDSRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_RXMACIPGSHORTDROPRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE7OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE6OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE5OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE4OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE3OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE2OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE1OUTPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_CNTR_EGRQUEUE0OUTPKTRTtf,
#endif

    MANGO_STAT_PORT_PRVTE_CNTRFIELD_LIST_END,
} rtk_mango_stat_port_prvte_cntrField_list_t;


typedef enum rtk_mango_stat_port_prvte_e_q_cntrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE7DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE6DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE5DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE4DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE3DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE2DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE1DROPPKTRTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_STAT_PORT_PRVTE_E_Q_CNTR_EGRQUEUE0DROPPKTRTtf,
#endif

    MANGO_STAT_PORT_PRVTE_E_Q_CNTRFIELD_LIST_END,
} rtk_mango_stat_port_prvte_e_q_cntrField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_PRIVATE_COUNTER */
#if defined(CONFIG_SDK_CHIP_FEATURE_ACL)

typedef enum rtk_mango_eaclField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_DEVMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_EGR_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_DEVMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_EGR_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_BMSK_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_NOTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_AND2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_METERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_LOGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_RREMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_YREMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_REMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_OVLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_IVLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_RDROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_YDROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_ACT_MSK_DROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_METER_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_DROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_YDROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_RDROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_IVLAN_VID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_IVLAN_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_IPRI_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_IPRI_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OVLAN_VID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OVLAN_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OPRI_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OPRI_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_REMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_REMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_YREMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_YREMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_RREMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_RREMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_IVLAN_TPID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_IVLAN_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OVLAN_TPID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_EACL_OVLAN_TPID_IDXtf,
#endif

    MANGO_EACLFIELD_LIST_END,
} rtk_mango_eaclField_list_t;


typedef enum rtk_mango_iaclField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_DEVMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IGR_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_DEVMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_IGR_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BMSK_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_NOTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_AND1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_AND2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_METERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_LOGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_RREMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_YREMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_REMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_PRIOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_TAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_OPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_OVLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_IPRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_IVLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_MIRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_RDROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_YDROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_DROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_BYPASStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_CPUQIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ACT_MSK_INVT_IP_RSV_FLAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_METER_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_DROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_YDROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_RDROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FWD_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FWD_CPU_PKT_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FWD_SA_LRNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FWD_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_FWD_PORT_INFOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_MIR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_MIR_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IVLAN_VID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IVLAN_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IPRI_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IPRI_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OVLAN_VID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OVLAN_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OPRI_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OPRI_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_REMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_REMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_YREMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_YREMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_RREMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_RREMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_ITAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OTAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_INTERNAL_PRIOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BYPASS_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IVLAN_TPID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_IVLAN_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OVLAN_TPID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_OVLAN_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_CPUQIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IACL_BYPASS_ACT1tf,
#endif

    MANGO_IACLFIELD_LIST_END,
} rtk_mango_iaclField_list_t;


typedef enum rtk_mango_vaclField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_CONTENT_TOO_DEEPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_IGR_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_CONTENT_TOO_DEEPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_IGR_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BMSK_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_NOTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_AND1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_AND2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_METERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_LOGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_RREMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_YREMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_REMARKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_PRIOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_TAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_OPRI_RMKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_OVLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_IPRI_RMKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_IVLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_MIRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_RDROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_YDROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_DROPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_BYPASStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_QIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_TUNNELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ACT_MSK_INVT_IP_RSV_FLAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_METER_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_DROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_YDROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_RDROP_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FWD_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FWD_CPU_PKT_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FWD_SA_LRNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FWD_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_FWD_PORT_INFOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_MIR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_MIR_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_IVLAN_VID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_IVLAN_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_IPRI_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_IPRI_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OVLAN_VID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OVLAN_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OPRI_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OPRI_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_REMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_REMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_YREMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_YREMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_RREMARK_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_RREMARK_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_ITAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_OTAGSTStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_INTERNAL_PRIOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_BYPASS_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_QID_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_QIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_TUNNEL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VACL_TUNNEL_IDXtf,
#endif

    MANGO_VACLFIELD_LIST_END,
} rtk_mango_vaclField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_ACL */
#if defined(CONFIG_SDK_CHIP_FEATURE_IP_MAC_BIDING)

typedef enum rtk_mango_ip_mac_bindField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_SMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_PORT_BINDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_VID_BINDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_VIDtf,
#endif

    MANGO_IP_MAC_BINDFIELD_LIST_END,
} rtk_mango_ip_mac_bindField_list_t;


typedef enum rtk_mango_ip_mac_bind_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_SMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_PORT_BINDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_VID_BINDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_CAM_VIDtf,
#endif

    MANGO_IP_MAC_BIND_CAMFIELD_LIST_END,
} rtk_mango_ip_mac_bind_camField_list_t;


typedef enum rtk_mango_ip_mac_bind_dynField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_SMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_PORT_BINDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_PORT_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_VID_BINDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_IP_MAC_BIND_DYN_VIDtf,
#endif

    MANGO_IP_MAC_BIND_DYNFIELD_LIST_END,
} rtk_mango_ip_mac_bind_dynField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_IP_MAC_BIDING */
#if defined(CONFIG_SDK_CHIP_FEATURE_OPENFLOW)

typedef enum rtk_mango_action_bucketField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_COPY_TTL_INWARDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_POP_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_POP_MPLStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_POP_MPLS_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_PUSH_MPLStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_PUSH_MPLS_MODEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_MPLS_VPN_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_MPLS_LIB_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_MPLS_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_COPY_TTL_OUTWARDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_DEC_MPLS_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_DEC_IP_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_FIELD2_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_FIELD2_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ACTION_BUCKET_WA_OUTPUT_DATAtf,
#endif

    MANGO_ACTION_BUCKETFIELD_LIST_END,
} rtk_mango_action_bucketField_list_t;


typedef enum rtk_mango_ft_egrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_DEV_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_NORMAL_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_DEVMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_BMSK_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_REVERSEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_AGGR_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_INS_METERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_METER_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_METER_YELLOW_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_METER_RED_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_POP_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_EGR_WA_OUTPUT_TYPEtf,
#endif

    MANGO_FT_EGRFIELD_LIST_END,
} rtk_mango_ft_egrField_list_t;


typedef enum rtk_mango_ft_igrField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_DEV_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_NORMAL_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_13tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_12tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_11tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_10tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_9tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_8tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_7tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_6tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_3tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FIELD_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_MGNT_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_DEVMACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_NOT_FIRST_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FRAME_TYPE_L4tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FRAME_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_OTAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_ITAG_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_OTAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_ITAG_EXISTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_FRAME_TYPE_L2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_NML_PORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_BMSK_TIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_REVERSEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_AGGR_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_AGGR_2tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_INS_METERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_METER_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_METER_YELLOW_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_METER_RED_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_COPY_TTL_INWARDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_POP_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_POP_MPLStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_POP_MPLS_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_PUSH_MPLStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_PUSH_MPLS_MODEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_MPLS_VPN_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_MPLS_LIB_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_MPLS_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_COPY_TTL_OUTWARDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_DEC_MPLS_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_DEC_IP_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD2_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD2_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD3_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD3_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD4_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_FIELD4_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_GROUPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_GROUP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_IGR_GOTO_TBL_LB_TIMEtf,
#endif

    MANGO_FT_IGRFIELD_LIST_END,
} rtk_mango_ft_igrField_list_t;


typedef enum rtk_mango_ft_l2_cam_fmt0_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_HIT_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_0_GOTO_TBL_LB_TIMEtf,
#endif

    MANGO_FT_L2_CAM_FMT0_0FIELD_LIST_END,
} rtk_mango_ft_l2_cam_fmt0_0Field_list_t;


typedef enum rtk_mango_ft_l2_cam_fmt0_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_METADATA_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT0_1_METADATA_MSKtf,
#endif

    MANGO_FT_L2_CAM_FMT0_1FIELD_LIST_END,
} rtk_mango_ft_l2_cam_fmt0_1Field_list_t;


typedef enum rtk_mango_ft_l2_cam_fmt1_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_L4SPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_IPPROTOtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_HIT_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_0_GOTO_TBL_LB_TIMEtf,
#endif

    MANGO_FT_L2_CAM_FMT1_0FIELD_LIST_END,
} rtk_mango_ft_l2_cam_fmt1_0Field_list_t;


typedef enum rtk_mango_ft_l2_cam_fmt1_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_L4DPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT1_1_METADATA_MSKtf,
#endif

    MANGO_FT_L2_CAM_FMT1_1FIELD_LIST_END,
} rtk_mango_ft_l2_cam_fmt1_1Field_list_t;


typedef enum rtk_mango_ft_l2_cam_fmt2_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_L4SPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_HIT_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_CAM_FMT2_0_GOTO_TBL_LB_TIMEtf,
#endif

    MANGO_FT_L2_CAM_FMT2_0FIELD_LIST_END,
} rtk_mango_ft_l2_cam_fmt2_0Field_list_t;


typedef enum rtk_mango_ft_l2_hash_fmt0_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_METADATA_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_GOTO_TBL_LB_TIMEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_0_HIT_STStf,
#endif

    MANGO_FT_L2_HASH_FMT0_0FIELD_LIST_END,
} rtk_mango_ft_l2_hash_fmt0_0Field_list_t;


typedef enum rtk_mango_ft_l2_hash_fmt0_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_METADATA_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT0_1_METADATA_MSKtf,
#endif

    MANGO_FT_L2_HASH_FMT0_1FIELD_LIST_END,
} rtk_mango_ft_l2_hash_fmt0_1Field_list_t;


typedef enum rtk_mango_ft_l2_hash_fmt1_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_L4SPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_IPPROTO_7_1tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_GOTO_TBL_LB_TIMEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_0_HIT_STStf,
#endif

    MANGO_FT_L2_HASH_FMT1_0FIELD_LIST_END,
} rtk_mango_ft_l2_hash_fmt1_0Field_list_t;


typedef enum rtk_mango_ft_l2_hash_fmt1_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_L4DPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_IPPROTO_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT1_1_METADATA_MSKtf,
#endif

    MANGO_FT_L2_HASH_FMT1_1FIELD_LIST_END,
} rtk_mango_ft_l2_hash_fmt1_1Field_list_t;


typedef enum rtk_mango_ft_l2_hash_fmt2_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_L4SPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_VID_11_5tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_WA_SET_Q_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_GOTO_TBL_LB_TIMEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_0_HIT_STStf,
#endif

    MANGO_FT_L2_HASH_FMT2_0FIELD_LIST_END,
} rtk_mango_ft_l2_hash_fmt2_0Field_list_t;


typedef enum rtk_mango_ft_l2_hash_fmt2_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_L4DPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_TUPLE_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_VID_4_0tf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L2_HASH_FMT2_1_METADATA_MSKtf,
#endif

    MANGO_FT_L2_HASH_FMT2_1FIELD_LIST_END,
} rtk_mango_ft_l2_hash_fmt2_1Field_list_t;


typedef enum rtk_mango_ft_l3_hash_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_MD_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_DEC_IP_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_FIELD2_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_FIELD2_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_GOTO_TBL_LB_TIMEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_0_HIT_STStf,
#endif

    MANGO_FT_L3_HASH_0FIELD_LIST_END,
} rtk_mango_ft_l3_hash_0Field_list_t;


typedef enum rtk_mango_ft_l3_hash_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_MD_CMPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_WA_GROUPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_WA_GROUP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_1_WA_SET_Q_DATAtf,
#endif

    MANGO_FT_L3_HASH_1FIELD_LIST_END,
} rtk_mango_ft_l3_hash_1Field_list_t;


typedef enum rtk_mango_ft_l3_hash_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_WA_GROUPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_WA_GROUP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_HASH_2_WA_SET_Q_DATAtf,
#endif

    MANGO_FT_L3_HASH_2FIELD_LIST_END,
} rtk_mango_ft_l3_hash_2Field_list_t;


typedef enum rtk_mango_ft_l3_tcam_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_BMSK_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_BMSK_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_BMSK_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_BMSK_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_INS_GOTO_TBLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_INS_WRITE_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_INS_WRITE_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_INS_CLR_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_PUSH_VLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_VLAN_ETHTYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_DEC_IP_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_FIELD0_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_FIELD0_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_FIELD1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_FIELD1_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_FIELD2_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_FIELD2_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_GOTO_TBL_LB_TIMEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_WA_SET_Qtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_0_HIT_STStf,
#endif

    MANGO_FT_L3_TCAM_0FIELD_LIST_END,
} rtk_mango_ft_l3_tcam_0Field_list_t;


typedef enum rtk_mango_ft_l3_tcam_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_METADATA_KEYtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_BMSK_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_BMSK_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_BMSK_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_BMSK_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_WA_GROUPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_WA_GROUP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_1_WA_SET_Q_DATAtf,
#endif

    MANGO_FT_L3_TCAM_1FIELD_LIST_END,
} rtk_mango_ft_l3_tcam_1Field_list_t;


typedef enum rtk_mango_ft_l3_tcam_2Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_BMSK_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_BMSK_IP_VERtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_BMSK_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_BMSK_IPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_WA_GROUPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_WA_GROUP_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_WA_OUTPUT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_WA_OUTPUT_DATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_METADATAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_METADATA_MSKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_GOTO_TBL_ACTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_GOTO_TBL_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_FT_L3_TCAM_2_WA_SET_Q_DATAtf,
#endif

    MANGO_FT_L3_TCAM_2FIELD_LIST_END,
} rtk_mango_ft_l3_tcam_2Field_list_t;


typedef enum rtk_mango_group_tblField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_GROUP_TBL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_GROUP_TBL_BUCKET_NUMtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_GROUP_TBL_BUCKET_IDtf,
#endif

    MANGO_GROUP_TBLFIELD_LIST_END,
} rtk_mango_group_tblField_list_t;


typedef enum rtk_mango_of_dmacField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_OF_DMAC_MACtf,
#endif

    MANGO_OF_DMACFIELD_LIST_END,
} rtk_mango_of_dmacField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_OPENFLOW */
#if defined(CONFIG_SDK_CHIP_FEATURE_L2_TUNNEL)

typedef enum rtk_mango_bssidField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_BSSIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_OVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_IVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_FWD_VLAN_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_PRI_SEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TT_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TS_TUNNEL_IDXtf,
#endif

    MANGO_BSSIDFIELD_LIST_END,
} rtk_mango_bssidField_list_t;


typedef enum rtk_mango_bssid_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_BSSIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_OVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_IVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_FWD_VLAN_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_PRI_SEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TT_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TS_QOS_PROFILEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TS_11E_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TS_RADIO_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_CAM_TS_TUNNEL_IDXtf,
#endif

    MANGO_BSSID_CAMFIELD_LIST_END,
} rtk_mango_bssid_camField_list_t;


typedef enum rtk_mango_bssid_listField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_LIST_BSSID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_LIST_BSSID_NEXT_IDXtf,
#endif

    MANGO_BSSID_LISTFIELD_LIST_END,
} rtk_mango_bssid_listField_list_t;


typedef enum rtk_mango_bssid_tunnel_startField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TUNNEL_START_BSSIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TUNNEL_START_QOS_PROFILEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TUNNEL_START_11E_ENtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TUNNEL_START_RADIO_IDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_BSSID_TUNNEL_START_WIRELESS_INFOtf,
#endif

    MANGO_BSSID_TUNNEL_STARTFIELD_LIST_END,
} rtk_mango_bssid_tunnel_startField_list_t;


typedef enum rtk_mango_capwap_tunnel_start_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_IP_VERSIONtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_TUNNEL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_TTL_ASSINGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_UDP_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_DONT_FRAG_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_DONT_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_UDP_SPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_UDP_DPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_QOS_PROFILE_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_INT_ITAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_INT_OTAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_UDP_LITE_CHKSUMtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_RADIO_MAC_ADDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_WL_INFO_ADDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_FRAME_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_FVID_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_DBL_TAG_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_NH_INFO_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_NH_DMAC_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_L3_EGR_INTF_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_NH_DMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_NH_SMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_ITAG_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_0_OTAG_TPID_IDXtf,
#endif

    MANGO_CAPWAP_TUNNEL_START_0FIELD_LIST_END,
} rtk_mango_capwap_tunnel_start_0Field_list_t;


typedef enum rtk_mango_capwap_tunnel_start_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_1_IP_VERSIONtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_CAPWAP_TUNNEL_START_1_IPtf,
#endif

    MANGO_CAPWAP_TUNNEL_START_1FIELD_LIST_END,
} rtk_mango_capwap_tunnel_start_1Field_list_t;


typedef enum rtk_mango_l2_tnl_lstField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_LST_L2_TNL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_LST_NEXT_IDXtf,
#endif

    MANGO_L2_TNL_LSTFIELD_LIST_END,
} rtk_mango_l2_tnl_lstField_list_t;


typedef enum rtk_mango_l2_tnl_mcastField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_PEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_LOCAL_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_MCAST_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_REMOTE_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_L2_TNL_LST_IDXtf,
#endif

    MANGO_L2_TNL_MCASTFIELD_LIST_END,
} rtk_mango_l2_tnl_mcastField_list_t;


typedef enum rtk_mango_l2_tnl_mcast_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_PEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_LOCAL_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_MCAST_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_REMOTE_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_MCAST_CAM_L2_TNL_LST_IDXtf,
#endif

    MANGO_L2_TNL_MCAST_CAMFIELD_LIST_END,
} rtk_mango_l2_tnl_mcast_camField_list_t;


typedef enum rtk_mango_l2_tnl_ucastField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_PEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_L2_TNLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_SPAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_AGEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_SA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_DA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_STATICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_SUSPENDtf,
#endif

    MANGO_L2_TNL_UCASTFIELD_LIST_END,
} rtk_mango_l2_tnl_ucastField_list_t;


typedef enum rtk_mango_l2_tnl_ucast_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_PEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_L2_TNLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_NEXT_HOPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_IS_TRKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_SPAtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_AGEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_SA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_DA_BLKtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_STATICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_UCAST_CAM_SUSPENDtf,
#endif

    MANGO_L2_TNL_UCAST_CAMFIELD_LIST_END,
} rtk_mango_l2_tnl_ucast_camField_list_t;


typedef enum rtk_mango_l2_tnl_vxlanField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_MAGICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_TUNNEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_VNItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_OVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_IVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_FWD_VLAN_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_PRI_SEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TT_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_TS_TUNNEL_IDXtf,
#endif

    MANGO_L2_TNL_VXLANFIELD_LIST_END,
} rtk_mango_l2_tnl_vxlanField_list_t;


typedef enum rtk_mango_l2_tnl_vxlan_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_MAGICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_TUNNEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_VNItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_OVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_OVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_IVID_CMDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_IVIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_FWD_VLAN_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_PRI_SEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TT_INT_PRItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_CAM_TS_TUNNEL_IDXtf,
#endif

    MANGO_L2_TNL_VXLAN_CAMFIELD_LIST_END,
} rtk_mango_l2_tnl_vxlan_camField_list_t;


typedef enum rtk_mango_l2_tnl_vxlan_encapField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_ENCAP_MAGICtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_ENCAP_TS_TUNNEL_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_ENCAP_VNItf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_L2_TNL_VXLAN_ENCAP_QOS_PROFILEtf,
#endif

    MANGO_L2_TNL_VXLAN_ENCAPFIELD_LIST_END,
} rtk_mango_l2_tnl_vxlan_encapField_list_t;


typedef enum rtk_mango_vxlan_tunnel_start_0Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_IP_VERSIONtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_TUNNEL_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_SIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_DIPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_TTL_ASSINGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_TTLtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_UDP_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_DONT_FRAG_ASSIGNtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_DONT_FRAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_UDP_SPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_UDP_DPORTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_QOS_PROFILE_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_INT_ITAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_INT_OTAG_STStf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_VXLAN_HDR_FLAGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_VXLAN_HDR_NPtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_FVID_SELtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_DBL_TAG_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_NH_INFO_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_NH_DMAC_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_L3_EGR_INTF_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_NH_DMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_NH_SMAC_ADDRtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_ITAG_TPID_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_0_OTAG_TPID_IDXtf,
#endif

    MANGO_VXLAN_TUNNEL_START_0FIELD_LIST_END,
} rtk_mango_vxlan_tunnel_start_0Field_list_t;


typedef enum rtk_mango_vxlan_tunnel_start_1Field_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_1_IP_VERSIONtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_VXLAN_TUNNEL_START_1_IPtf,
#endif

    MANGO_VXLAN_TUNNEL_START_1FIELD_LIST_END,
} rtk_mango_vxlan_tunnel_start_1Field_list_t;


typedef enum rtk_mango_wlc_mcastField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_WIRE_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_MCAST_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_WIRELESS_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_BSSID_LIST_IDXtf,
#endif

    MANGO_WLC_MCASTFIELD_LIST_END,
} rtk_mango_wlc_mcastField_list_t;


typedef enum rtk_mango_wlc_mcast_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_WIRE_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_MCAST_PMSK_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_WIRELESS_FWDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_MCAST_CAM_BSSID_LIST_IDXtf,
#endif

    MANGO_WLC_MCAST_CAMFIELD_LIST_END,
} rtk_mango_wlc_mcast_camField_list_t;


typedef enum rtk_mango_wlc_ucastField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_WLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_BSSID_IDXtf,
#endif

    MANGO_WLC_UCASTFIELD_LIST_END,
} rtk_mango_wlc_ucastField_list_t;


typedef enum rtk_mango_wlc_ucast_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAM_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAM_FIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAM_MACtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAM_WLANtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_WLC_UCAST_CAM_BSSID_IDXtf,
#endif

    MANGO_WLC_UCAST_CAMFIELD_LIST_END,
} rtk_mango_wlc_ucast_camField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_L2_TUNNEL */
#if defined(CONFIG_SDK_CHIP_FEATURE_PORT_EXTENSION)

typedef enum rtk_mango_ecid_pmsk_listField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PMSK_LIST_NEXT_IDXtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PMSK_LIST_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PMSK_LIST_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PMSK_LIST_PMSK_IDXtf,
#endif

    MANGO_ECID_PMSK_LISTFIELD_LIST_END,
} rtk_mango_ecid_pmsk_listField_list_t;


typedef enum rtk_mango_ecid_pvidField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_NSGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_PORT_IDtf,
#endif

    MANGO_ECID_PVIDFIELD_LIST_END,
} rtk_mango_ecid_pvidField_list_t;


typedef enum rtk_mango_ecid_pvid_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAM_NSGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAM_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAM_VIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAM_PORT_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_ECID_PVID_CAM_PORT_IDtf,
#endif

    MANGO_ECID_PVID_CAMFIELD_LIST_END,
} rtk_mango_ecid_pvid_camField_list_t;


typedef enum rtk_mango_pe_fwdField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_NSGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_DPMtf,
#endif

    MANGO_PE_FWDFIELD_LIST_END,
} rtk_mango_pe_fwdField_list_t;


typedef enum rtk_mango_pe_fwd_camField_list_e
{
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAM_VALIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAM_FMTtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAM_ENTRY_TYPEtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAM_NSGtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAM_ECIDtf,
#endif
#if defined(CONFIG_SDK_RTL9310)
    MANGO_PE_FWD_CAM_DPMtf,
#endif

    MANGO_PE_FWD_CAMFIELD_LIST_END,
} rtk_mango_pe_fwd_camField_list_t;

#endif   /* CONFIG_SDK_CHIP_FEATURE_PORT_EXTENSION */
extern rtk_table_t rtk_mango_table_list[];


#endif    /* __RTK_MANGO_TABLE_STRUCT_H__ */
