/************************************************************************************
*
* Copyright (c) 2017 Aquantia Corp.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
*
* 1. Redistributions of source code must retain the above copyright notice, 
* this list of conditions and the following disclaimer.
*
* 2. Redistributions in binary form must reproduce the above copyright 
* notice, this list of conditions and the following disclaimer in the 
* documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY 
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH 
* DAMAGE.
*
************************************************************************************/

/*! \file 
*   This file contains the compiler assist macros and doxygen comments
*   for the PHY_XS Registers block.
*/

/*! \defgroup PHY_XS_registers_Defines PHY_XS Registers Defines
*   This module contains the compiler assist macros and doxygen comments
*   for the PHY_XS Registers block.
*/
/***********************************************************************
*                     Copyright Aquantia Corp.
*                             Freeware
*
* $File: //depot/icm/proj/Dena/rev1.0/c/Systems/tools/windows/regMapParser/src/gencheaders.py $
*
* $Revision: #13 $
*
* $DateTime: 2016/09/23 10:49:54 $
*
* $Author: wxia $
*
* $Label: $
*
* Description:
*
*   This file contains the compiler assist macros for the registers contained in the PHY_XS Registers block.
*
*
***********************************************************************/


/*@{*/
#ifndef AQ_EUR_PHY_XS_REGS_DEFINES_HEADER
#define AQ_EUR_PHY_XS_REGS_DEFINES_HEADER


/*-----------------------------------------------------------------------------*/
/*Access macro definitions                                                     */
/*-----------------------------------------------------------------------------*/
/*! \brief Base register address of structure AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_baseRegisterAddress 0x0000
/*! \brief MMD address of structure AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reset in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_reset 0
/*! \brief Preprocessor variable to relate field to bit position in structure reset in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_reset u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reset in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_reset u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure loopback in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_loopback 0
/*! \brief Preprocessor variable to relate field to bit position in structure loopback in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_loopback u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure loopback in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_loopback u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure speedSelection_0 in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_speedSelection_0 0
/*! \brief Preprocessor variable to relate field to bit position in structure speedSelection_0 in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_speedSelection_0 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure speedSelection_0 in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_speedSelection_0 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved00a in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_reserved00a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved00a in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_reserved00a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved00a in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_reserved00a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure lowPower in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_lowPower 0
/*! \brief Preprocessor variable to relate field to bit position in structure lowPower in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_lowPower u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure lowPower in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_lowPower u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure clockStopEnable in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_clockStopEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure clockStopEnable in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_clockStopEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure clockStopEnable in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_clockStopEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiStopEnable in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_xauiStopEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiStopEnable in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_xauiStopEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiStopEnable in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_xauiStopEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved00b in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_reserved00b 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved00b in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_reserved00b u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved00b in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_reserved00b u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure speedSelection_1 in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_speedSelection_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure speedSelection_1 in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_speedSelection_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure speedSelection_1 in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_speedSelection_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure speedSelection_2 in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_speedSelection_2 0
/*! \brief Preprocessor variable to relate field to bit position in structure speedSelection_2 in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_speedSelection_2 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure speedSelection_2 in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_speedSelection_2 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved00c in AQ_PhyXS_StandardControl_1_EUR */
#define AQ_PhyXS_StandardControl_1_EUR_reserved00c 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved00c in AQ_PhyXS_StandardControl_1_EUR */
#define bits_AQ_PhyXS_StandardControl_1_EUR_reserved00c u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved00c in AQ_PhyXS_StandardControl_1_EUR */
#define word_AQ_PhyXS_StandardControl_1_EUR_reserved00c u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_baseRegisterAddress 0x0001
/*! \brief MMD address of structure AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved01a in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_reserved01a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved01a in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_reserved01a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved01a in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_reserved01a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure txLpiReceived in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_txLpiReceived 0
/*! \brief Preprocessor variable to relate field to bit position in structure txLpiReceived in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_txLpiReceived u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txLpiReceived in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_txLpiReceived u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLpiReceived in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_rxLpiReceived 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLpiReceived in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_rxLpiReceived u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLpiReceived in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_rxLpiReceived u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure txLpiIndication in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_txLpiIndication 0
/*! \brief Preprocessor variable to relate field to bit position in structure txLpiIndication in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_txLpiIndication u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txLpiIndication in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_txLpiIndication u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLpiIndication in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_rxLpiIndication 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLpiIndication in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_rxLpiIndication u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLpiIndication in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_rxLpiIndication u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure fault in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_fault 0
/*! \brief Preprocessor variable to relate field to bit position in structure fault in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_fault u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure fault in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_fault u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure clockStopCapable in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_clockStopCapable 0
/*! \brief Preprocessor variable to relate field to bit position in structure clockStopCapable in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_clockStopCapable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure clockStopCapable in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_clockStopCapable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved01b in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_reserved01b 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved01b in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_reserved01b u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved01b in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_reserved01b u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_TransmitLinkAlignmentStatus in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_phyXS_TransmitLinkAlignmentStatus 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_TransmitLinkAlignmentStatus in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_phyXS_TransmitLinkAlignmentStatus u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_TransmitLinkAlignmentStatus in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_phyXS_TransmitLinkAlignmentStatus u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure lowPowerAbility in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_lowPowerAbility 0
/*! \brief Preprocessor variable to relate field to bit position in structure lowPowerAbility in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_lowPowerAbility u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure lowPowerAbility in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_lowPowerAbility u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved01c in AQ_PhyXS_StandardStatus_1_EUR */
#define AQ_PhyXS_StandardStatus_1_EUR_reserved01c 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved01c in AQ_PhyXS_StandardStatus_1_EUR */
#define bits_AQ_PhyXS_StandardStatus_1_EUR_reserved01c u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved01c in AQ_PhyXS_StandardStatus_1_EUR */
#define word_AQ_PhyXS_StandardStatus_1_EUR_reserved01c u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define AQ_PhyXS_StandardDeviceIdentifier_EUR_baseRegisterAddress 0x0002
/*! \brief MMD address of structure AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define AQ_PhyXS_StandardDeviceIdentifier_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure deviceIdMSW in AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define AQ_PhyXS_StandardDeviceIdentifier_EUR_deviceIdMSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure deviceIdMSW in AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define bits_AQ_PhyXS_StandardDeviceIdentifier_EUR_deviceIdMSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure deviceIdMSW in AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define word_AQ_PhyXS_StandardDeviceIdentifier_EUR_deviceIdMSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure deviceIdLSW in AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define AQ_PhyXS_StandardDeviceIdentifier_EUR_deviceIdLSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure deviceIdLSW in AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define bits_AQ_PhyXS_StandardDeviceIdentifier_EUR_deviceIdLSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure deviceIdLSW in AQ_PhyXS_StandardDeviceIdentifier_EUR */
#define word_AQ_PhyXS_StandardDeviceIdentifier_EUR_deviceIdLSW u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_StandardSpeedAbility_EUR */
#define AQ_PhyXS_StandardSpeedAbility_EUR_baseRegisterAddress 0x0004
/*! \brief MMD address of structure AQ_PhyXS_StandardSpeedAbility_EUR */
#define AQ_PhyXS_StandardSpeedAbility_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved04 in AQ_PhyXS_StandardSpeedAbility_EUR */
#define AQ_PhyXS_StandardSpeedAbility_EUR_reserved04 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved04 in AQ_PhyXS_StandardSpeedAbility_EUR */
#define bits_AQ_PhyXS_StandardSpeedAbility_EUR_reserved04 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved04 in AQ_PhyXS_StandardSpeedAbility_EUR */
#define word_AQ_PhyXS_StandardSpeedAbility_EUR_reserved04 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure _10gCapable in AQ_PhyXS_StandardSpeedAbility_EUR */
#define AQ_PhyXS_StandardSpeedAbility_EUR__10gCapable 0
/*! \brief Preprocessor variable to relate field to bit position in structure _10gCapable in AQ_PhyXS_StandardSpeedAbility_EUR */
#define bits_AQ_PhyXS_StandardSpeedAbility_EUR__10gCapable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure _10gCapable in AQ_PhyXS_StandardSpeedAbility_EUR */
#define word_AQ_PhyXS_StandardSpeedAbility_EUR__10gCapable u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_baseRegisterAddress 0x0005
/*! \brief MMD address of structure AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure autonegotiationPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_autonegotiationPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure autonegotiationPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_autonegotiationPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure autonegotiationPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_autonegotiationPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure tcPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_tcPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure tcPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_tcPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure tcPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_tcPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure dteXsPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_dteXsPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure dteXsPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_dteXsPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure dteXsPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_dteXsPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_phyXS_Present 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_phyXS_Present u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_phyXS_Present u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure pcsPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_pcsPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure pcsPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_pcsPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure pcsPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_pcsPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure wisPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_wisPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure wisPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_wisPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure wisPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_wisPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure pmaPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_pmaPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure pmaPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_pmaPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure pmaPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_pmaPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure clause_22RegistersPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_clause_22RegistersPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure clause_22RegistersPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_clause_22RegistersPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure clause_22RegistersPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_clause_22RegistersPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificDevice_2Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_vendorSpecificDevice_2Present 1
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificDevice_2Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_vendorSpecificDevice_2Present u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificDevice_2Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_vendorSpecificDevice_2Present u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificDevice_1Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_vendorSpecificDevice_1Present 1
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificDevice_1Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_vendorSpecificDevice_1Present u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificDevice_1Present in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_vendorSpecificDevice_1Present u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure clause_22ExtensionPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define AQ_PhyXS_StandardDevicesInPackage_EUR_clause_22ExtensionPresent 1
/*! \brief Preprocessor variable to relate field to bit position in structure clause_22ExtensionPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define bits_AQ_PhyXS_StandardDevicesInPackage_EUR_clause_22ExtensionPresent u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure clause_22ExtensionPresent in AQ_PhyXS_StandardDevicesInPackage_EUR */
#define word_AQ_PhyXS_StandardDevicesInPackage_EUR_clause_22ExtensionPresent u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Reserved_7Register_EUR */
#define AQ_PhyXS_Reserved_7Register_EUR_baseRegisterAddress 0x0007
/*! \brief MMD address of structure AQ_PhyXS_Reserved_7Register_EUR */
#define AQ_PhyXS_Reserved_7Register_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved07 in AQ_PhyXS_Reserved_7Register_EUR */
#define AQ_PhyXS_Reserved_7Register_EUR_reserved07 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved07 in AQ_PhyXS_Reserved_7Register_EUR */
#define bits_AQ_PhyXS_Reserved_7Register_EUR_reserved07 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved07 in AQ_PhyXS_Reserved_7Register_EUR */
#define word_AQ_PhyXS_Reserved_7Register_EUR_reserved07 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_baseRegisterAddress 0x0008
/*! \brief MMD address of structure AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure devicePresent in AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_devicePresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure devicePresent in AQ_PhyXS_StandardStatus_2_EUR */
#define bits_AQ_PhyXS_StandardStatus_2_EUR_devicePresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure devicePresent in AQ_PhyXS_StandardStatus_2_EUR */
#define word_AQ_PhyXS_StandardStatus_2_EUR_devicePresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved08a in AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_reserved08a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved08a in AQ_PhyXS_StandardStatus_2_EUR */
#define bits_AQ_PhyXS_StandardStatus_2_EUR_reserved08a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved08a in AQ_PhyXS_StandardStatus_2_EUR */
#define word_AQ_PhyXS_StandardStatus_2_EUR_reserved08a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure transmitFault in AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_transmitFault 0
/*! \brief Preprocessor variable to relate field to bit position in structure transmitFault in AQ_PhyXS_StandardStatus_2_EUR */
#define bits_AQ_PhyXS_StandardStatus_2_EUR_transmitFault u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure transmitFault in AQ_PhyXS_StandardStatus_2_EUR */
#define word_AQ_PhyXS_StandardStatus_2_EUR_transmitFault u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure receiveFault in AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_receiveFault 0
/*! \brief Preprocessor variable to relate field to bit position in structure receiveFault in AQ_PhyXS_StandardStatus_2_EUR */
#define bits_AQ_PhyXS_StandardStatus_2_EUR_receiveFault u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure receiveFault in AQ_PhyXS_StandardStatus_2_EUR */
#define word_AQ_PhyXS_StandardStatus_2_EUR_receiveFault u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved08b in AQ_PhyXS_StandardStatus_2_EUR */
#define AQ_PhyXS_StandardStatus_2_EUR_reserved08b 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved08b in AQ_PhyXS_StandardStatus_2_EUR */
#define bits_AQ_PhyXS_StandardStatus_2_EUR_reserved08b u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved08b in AQ_PhyXS_StandardStatus_2_EUR */
#define word_AQ_PhyXS_StandardStatus_2_EUR_reserved08b u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardPackageIdentifier_EUR */
#define AQ_PhyXS_StandardPackageIdentifier_EUR_baseRegisterAddress 0x000E
/*! \brief MMD address of structure AQ_PhyXS_StandardPackageIdentifier_EUR */
#define AQ_PhyXS_StandardPackageIdentifier_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure packageIdMSW in AQ_PhyXS_StandardPackageIdentifier_EUR */
#define AQ_PhyXS_StandardPackageIdentifier_EUR_packageIdMSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure packageIdMSW in AQ_PhyXS_StandardPackageIdentifier_EUR */
#define bits_AQ_PhyXS_StandardPackageIdentifier_EUR_packageIdMSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure packageIdMSW in AQ_PhyXS_StandardPackageIdentifier_EUR */
#define word_AQ_PhyXS_StandardPackageIdentifier_EUR_packageIdMSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure packageIdLSW in AQ_PhyXS_StandardPackageIdentifier_EUR */
#define AQ_PhyXS_StandardPackageIdentifier_EUR_packageIdLSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure packageIdLSW in AQ_PhyXS_StandardPackageIdentifier_EUR */
#define bits_AQ_PhyXS_StandardPackageIdentifier_EUR_packageIdLSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure packageIdLSW in AQ_PhyXS_StandardPackageIdentifier_EUR */
#define word_AQ_PhyXS_StandardPackageIdentifier_EUR_packageIdLSW u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_EeeCapabilityRegister_EUR */
#define AQ_PhyXS_EeeCapabilityRegister_EUR_baseRegisterAddress 0x0014
/*! \brief MMD address of structure AQ_PhyXS_EeeCapabilityRegister_EUR */
#define AQ_PhyXS_EeeCapabilityRegister_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved14a in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define AQ_PhyXS_EeeCapabilityRegister_EUR_reserved14a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved14a in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define bits_AQ_PhyXS_EeeCapabilityRegister_EUR_reserved14a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved14a in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define word_AQ_PhyXS_EeeCapabilityRegister_EUR_reserved14a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_Eee in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define AQ_PhyXS_EeeCapabilityRegister_EUR_phyXS_Eee 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_Eee in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define bits_AQ_PhyXS_EeeCapabilityRegister_EUR_phyXS_Eee u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_Eee in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define word_AQ_PhyXS_EeeCapabilityRegister_EUR_phyXS_Eee u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved14b in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define AQ_PhyXS_EeeCapabilityRegister_EUR_reserved14b 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved14b in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define bits_AQ_PhyXS_EeeCapabilityRegister_EUR_reserved14b u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved14b in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define word_AQ_PhyXS_EeeCapabilityRegister_EUR_reserved14b u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiStopCapable in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define AQ_PhyXS_EeeCapabilityRegister_EUR_xauiStopCapable 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiStopCapable in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define bits_AQ_PhyXS_EeeCapabilityRegister_EUR_xauiStopCapable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiStopCapable in AQ_PhyXS_EeeCapabilityRegister_EUR */
#define word_AQ_PhyXS_EeeCapabilityRegister_EUR_xauiStopCapable u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Reserved_15Register_EUR */
#define AQ_PhyXS_Reserved_15Register_EUR_baseRegisterAddress 0x0015
/*! \brief MMD address of structure AQ_PhyXS_Reserved_15Register_EUR */
#define AQ_PhyXS_Reserved_15Register_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved15 in AQ_PhyXS_Reserved_15Register_EUR */
#define AQ_PhyXS_Reserved_15Register_EUR_reserved15 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved15 in AQ_PhyXS_Reserved_15Register_EUR */
#define bits_AQ_PhyXS_Reserved_15Register_EUR_reserved15 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved15 in AQ_PhyXS_Reserved_15Register_EUR */
#define word_AQ_PhyXS_Reserved_15Register_EUR_reserved15 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_EeeWakeErrorCounter_EUR */
#define AQ_PhyXS_EeeWakeErrorCounter_EUR_baseRegisterAddress 0x0016
/*! \brief MMD address of structure AQ_PhyXS_EeeWakeErrorCounter_EUR */
#define AQ_PhyXS_EeeWakeErrorCounter_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure eeeWakeErrorCounter in AQ_PhyXS_EeeWakeErrorCounter_EUR */
#define AQ_PhyXS_EeeWakeErrorCounter_EUR_eeeWakeErrorCounter 0
/*! \brief Preprocessor variable to relate field to bit position in structure eeeWakeErrorCounter in AQ_PhyXS_EeeWakeErrorCounter_EUR */
#define bits_AQ_PhyXS_EeeWakeErrorCounter_EUR_eeeWakeErrorCounter u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure eeeWakeErrorCounter in AQ_PhyXS_EeeWakeErrorCounter_EUR */
#define word_AQ_PhyXS_EeeWakeErrorCounter_EUR_eeeWakeErrorCounter u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_baseRegisterAddress 0x0018
/*! \brief MMD address of structure AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved18a in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_reserved18a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved18a in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_reserved18a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved18a in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_reserved18a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXGXS_LaneAlignmentStatus in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_LaneAlignmentStatus 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXGXS_LaneAlignmentStatus in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_LaneAlignmentStatus u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXGXS_LaneAlignmentStatus in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_LaneAlignmentStatus u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXGXS_PatternTestingAbility in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_PatternTestingAbility 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXGXS_PatternTestingAbility in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_PatternTestingAbility u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXGXS_PatternTestingAbility in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_PatternTestingAbility u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXGXS_LoopbackAbility in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_LoopbackAbility 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXGXS_LoopbackAbility in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_LoopbackAbility u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXGXS_LoopbackAbility in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_phyXGXS_LoopbackAbility u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reserved18b in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_reserved18b 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved18b in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_reserved18b u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved18b in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_reserved18b u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure laneSync in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define AQ_PhyXS_StandardXGXS_LaneStatus_EUR_laneSync 0
/*! \brief Preprocessor variable to relate field to bit position in structure laneSync in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_laneSync u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure laneSync in AQ_PhyXS_StandardXGXS_LaneStatus_EUR */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_EUR_laneSync u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define AQ_PhyXS_StandardXGXS_TestControl_EUR_baseRegisterAddress 0x0019
/*! \brief MMD address of structure AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define AQ_PhyXS_StandardXGXS_TestControl_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved19a in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define AQ_PhyXS_StandardXGXS_TestControl_EUR_reserved19a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved19a in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define bits_AQ_PhyXS_StandardXGXS_TestControl_EUR_reserved19a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved19a in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define word_AQ_PhyXS_StandardXGXS_TestControl_EUR_reserved19a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure receiveTest_PatternEnable in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define AQ_PhyXS_StandardXGXS_TestControl_EUR_receiveTest_PatternEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure receiveTest_PatternEnable in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define bits_AQ_PhyXS_StandardXGXS_TestControl_EUR_receiveTest_PatternEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure receiveTest_PatternEnable in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define word_AQ_PhyXS_StandardXGXS_TestControl_EUR_receiveTest_PatternEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure test_patternSelect in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define AQ_PhyXS_StandardXGXS_TestControl_EUR_test_patternSelect 0
/*! \brief Preprocessor variable to relate field to bit position in structure test_patternSelect in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define bits_AQ_PhyXS_StandardXGXS_TestControl_EUR_test_patternSelect u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure test_patternSelect in AQ_PhyXS_StandardXGXS_TestControl_EUR */
#define word_AQ_PhyXS_StandardXGXS_TestControl_EUR_test_patternSelect u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Reserved_1aRegister_EUR */
#define AQ_PhyXS_Reserved_1aRegister_EUR_baseRegisterAddress 0x001A
/*! \brief MMD address of structure AQ_PhyXS_Reserved_1aRegister_EUR */
#define AQ_PhyXS_Reserved_1aRegister_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved1a in AQ_PhyXS_Reserved_1aRegister_EUR */
#define AQ_PhyXS_Reserved_1aRegister_EUR_reserved1a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved1a in AQ_PhyXS_Reserved_1aRegister_EUR */
#define bits_AQ_PhyXS_Reserved_1aRegister_EUR_reserved1a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved1a in AQ_PhyXS_Reserved_1aRegister_EUR */
#define word_AQ_PhyXS_Reserved_1aRegister_EUR_reserved1a u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Reserved_1bRegister_EUR */
#define AQ_PhyXS_Reserved_1bRegister_EUR_baseRegisterAddress 0x001B
/*! \brief MMD address of structure AQ_PhyXS_Reserved_1bRegister_EUR */
#define AQ_PhyXS_Reserved_1bRegister_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved1b in AQ_PhyXS_Reserved_1bRegister_EUR */
#define AQ_PhyXS_Reserved_1bRegister_EUR_reserved1b 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved1b in AQ_PhyXS_Reserved_1bRegister_EUR */
#define bits_AQ_PhyXS_Reserved_1bRegister_EUR_reserved1b u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved1b in AQ_PhyXS_Reserved_1bRegister_EUR */
#define word_AQ_PhyXS_Reserved_1bRegister_EUR_reserved1b u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Reserved_1cRegister_EUR */
#define AQ_PhyXS_Reserved_1cRegister_EUR_baseRegisterAddress 0x001C
/*! \brief MMD address of structure AQ_PhyXS_Reserved_1cRegister_EUR */
#define AQ_PhyXS_Reserved_1cRegister_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved1c in AQ_PhyXS_Reserved_1cRegister_EUR */
#define AQ_PhyXS_Reserved_1cRegister_EUR_reserved1c 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved1c in AQ_PhyXS_Reserved_1cRegister_EUR */
#define bits_AQ_PhyXS_Reserved_1cRegister_EUR_reserved1c u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved1c in AQ_PhyXS_Reserved_1cRegister_EUR */
#define word_AQ_PhyXS_Reserved_1cRegister_EUR_reserved1c u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Reserved_1dRegister_EUR */
#define AQ_PhyXS_Reserved_1dRegister_EUR_baseRegisterAddress 0x001D
/*! \brief MMD address of structure AQ_PhyXS_Reserved_1dRegister_EUR */
#define AQ_PhyXS_Reserved_1dRegister_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reserved1d in AQ_PhyXS_Reserved_1dRegister_EUR */
#define AQ_PhyXS_Reserved_1dRegister_EUR_reserved1d 0
/*! \brief Preprocessor variable to relate field to bit position in structure reserved1d in AQ_PhyXS_Reserved_1dRegister_EUR */
#define bits_AQ_PhyXS_Reserved_1dRegister_EUR_reserved1d u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reserved1d in AQ_PhyXS_Reserved_1dRegister_EUR */
#define word_AQ_PhyXS_Reserved_1dRegister_EUR_reserved1d u0.word_0

/*! \brief Base register address of structure AQ_TimesyncPhyXsCapability_EUR */
#define AQ_TimesyncPhyXsCapability_EUR_baseRegisterAddress 0x0708
/*! \brief MMD address of structure AQ_TimesyncPhyXsCapability_EUR */
#define AQ_TimesyncPhyXsCapability_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure timesyncTransmitPathDataDelay in AQ_TimesyncPhyXsCapability_EUR */
#define AQ_TimesyncPhyXsCapability_EUR_timesyncTransmitPathDataDelay 0
/*! \brief Preprocessor variable to relate field to bit position in structure timesyncTransmitPathDataDelay in AQ_TimesyncPhyXsCapability_EUR */
#define bits_AQ_TimesyncPhyXsCapability_EUR_timesyncTransmitPathDataDelay u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure timesyncTransmitPathDataDelay in AQ_TimesyncPhyXsCapability_EUR */
#define word_AQ_TimesyncPhyXsCapability_EUR_timesyncTransmitPathDataDelay u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure timesyncReceivePathDataDelay in AQ_TimesyncPhyXsCapability_EUR */
#define AQ_TimesyncPhyXsCapability_EUR_timesyncReceivePathDataDelay 0
/*! \brief Preprocessor variable to relate field to bit position in structure timesyncReceivePathDataDelay in AQ_TimesyncPhyXsCapability_EUR */
#define bits_AQ_TimesyncPhyXsCapability_EUR_timesyncReceivePathDataDelay u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure timesyncReceivePathDataDelay in AQ_TimesyncPhyXsCapability_EUR */
#define word_AQ_TimesyncPhyXsCapability_EUR_timesyncReceivePathDataDelay u0.word_0

/*! \brief Base register address of structure AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_baseRegisterAddress 0x0709
/*! \brief MMD address of structure AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_maximumPhyXsTransmitPathDataDelayLSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_maximumPhyXsTransmitPathDataDelayLSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_maximumPhyXsTransmitPathDataDelayLSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_maximumPhyXsTransmitPathDataDelayMSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_maximumPhyXsTransmitPathDataDelayMSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_maximumPhyXsTransmitPathDataDelayMSW u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_minimumPhyXsTransmitPathDataDelayLSW 2
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_minimumPhyXsTransmitPathDataDelayLSW u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_minimumPhyXsTransmitPathDataDelayLSW u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_minimumPhyXsTransmitPathDataDelayMSW 3
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_minimumPhyXsTransmitPathDataDelayMSW u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_EUR_minimumPhyXsTransmitPathDataDelayMSW u3.word_3

/*! \brief Base register address of structure AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define AQ_TimesyncPhyXsReceivePathDataDelay_EUR_baseRegisterAddress 0x070D
/*! \brief MMD address of structure AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define AQ_TimesyncPhyXsReceivePathDataDelay_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define AQ_TimesyncPhyXsReceivePathDataDelay_EUR_maximumPhyXsReceivePathDataDelayLSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_maximumPhyXsReceivePathDataDelayLSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_maximumPhyXsReceivePathDataDelayLSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define AQ_TimesyncPhyXsReceivePathDataDelay_EUR_maximumPhyXsReceivePathDataDelayMSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_maximumPhyXsReceivePathDataDelayMSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_maximumPhyXsReceivePathDataDelayMSW u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define AQ_TimesyncPhyXsReceivePathDataDelay_EUR_minimumPhyXsReceivePathDataDelayLSW 2
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_minimumPhyXsReceivePathDataDelayLSW u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_minimumPhyXsReceivePathDataDelayLSW u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define AQ_TimesyncPhyXsReceivePathDataDelay_EUR_minimumPhyXsReceivePathDataDelayMSW 3
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_minimumPhyXsReceivePathDataDelayMSW u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_EUR */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_EUR_minimumPhyXsReceivePathDataDelayMSW u3.word_3

/*! \brief Base register address of structure AQ_PhyXS_SerdesConfiguration_EUR */
#define AQ_PhyXS_SerdesConfiguration_EUR_baseRegisterAddress 0xC180
/*! \brief MMD address of structure AQ_PhyXS_SerdesConfiguration_EUR */
#define AQ_PhyXS_SerdesConfiguration_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_0Configuration_EUR */
#define AQ_PhyXS_SerdesLane_0Configuration_EUR_baseRegisterAddress 0xC1C0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_0Configuration_EUR */
#define AQ_PhyXS_SerdesLane_0Configuration_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_1Configuration_EUR */
#define AQ_PhyXS_SerdesLane_1Configuration_EUR_baseRegisterAddress 0xC1D0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_1Configuration_EUR */
#define AQ_PhyXS_SerdesLane_1Configuration_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_2Configuration_EUR */
#define AQ_PhyXS_SerdesLane_2Configuration_EUR_baseRegisterAddress 0xC1E0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_2Configuration_EUR */
#define AQ_PhyXS_SerdesLane_2Configuration_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_3Configuration_EUR */
#define AQ_PhyXS_SerdesLane_3Configuration_EUR_baseRegisterAddress 0xC1F0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_3Configuration_EUR */
#define AQ_PhyXS_SerdesLane_3Configuration_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_SerdesLut_EUR */
#define AQ_PhyXS_SerdesLut_EUR_baseRegisterAddress 0xC200
/*! \brief MMD address of structure AQ_PhyXS_SerdesLut_EUR */
#define AQ_PhyXS_SerdesLut_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_baseRegisterAddress 0xC440
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioningC440 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioningC440 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioningC440 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioningC440 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioningC440 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioningC440 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure _50MhzPrimaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR__50MhzPrimaryOutputEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure _50MhzPrimaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR__50MhzPrimaryOutputEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure _50MhzPrimaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR__50MhzPrimaryOutputEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure _50MhzSecondaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR__50MhzSecondaryOutputEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure _50MhzSecondaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR__50MhzSecondaryOutputEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure _50MhzSecondaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR__50MhzSecondaryOutputEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure serdesReset in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_serdesReset 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesReset in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_serdesReset u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesReset in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_serdesReset u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_2b in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_2b 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_2b in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_2b u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_2b in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_2b u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure usxAutonegControlForMac in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_usxAutonegControlForMac 1
/*! \brief Preprocessor variable to relate field to bit position in structure usxAutonegControlForMac in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_usxAutonegControlForMac u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure usxAutonegControlForMac in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_usxAutonegControlForMac u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure backplaneAngEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_backplaneAngEnable 1
/*! \brief Preprocessor variable to relate field to bit position in structure backplaneAngEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_backplaneAngEnable u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure backplaneAngEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_backplaneAngEnable u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_2a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_2a 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_2a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_2a u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_2a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_2a u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_3a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_3a 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_3a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_3a u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_3a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_3a u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure systemSgmiiRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemSgmiiRxInvert 2
/*! \brief Preprocessor variable to relate field to bit position in structure systemSgmiiRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemSgmiiRxInvert u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure systemSgmiiRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemSgmiiRxInvert u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_3 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_3 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_3 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_3 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_3 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_3 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_4a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_4a 3
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_4a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_4a u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_4a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_4a u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure systemKrRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemKrRxInvert 3
/*! \brief Preprocessor variable to relate field to bit position in structure systemKrRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemKrRxInvert u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure systemKrRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemKrRxInvert u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_4 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_4 3
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_4 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_4 u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_4 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_4 u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure loopbackControl in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_loopbackControl 4
/*! \brief Preprocessor variable to relate field to bit position in structure loopbackControl in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_loopbackControl u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure loopbackControl in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_loopbackControl u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_5 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_5 4
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_5 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_5 u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_5 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_5 u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure mdiPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_mdiPacketGeneration 4
/*! \brief Preprocessor variable to relate field to bit position in structure mdiPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_mdiPacketGeneration u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure mdiPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_mdiPacketGeneration u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure look_asidePortPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_look_asidePortPacketGeneration 4
/*! \brief Preprocessor variable to relate field to bit position in structure look_asidePortPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_look_asidePortPacketGeneration u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure look_asidePortPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_look_asidePortPacketGeneration u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure systemI_fPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemI_fPacketGeneration 4
/*! \brief Preprocessor variable to relate field to bit position in structure systemI_fPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemI_fPacketGeneration u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure systemI_fPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_systemI_fPacketGeneration u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure rate in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_rate 4
/*! \brief Preprocessor variable to relate field to bit position in structure rate in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_rate u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure rate in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_rate u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_6 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_6 5
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_6 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_6 u5.bits_5
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_6 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_6 u5.word_5
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_7 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_7 6
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_7 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_7 u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_7 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_7 u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostMinValue 6
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostMinValue u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostMinValue u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainMinValue 6
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainMinValue u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainMinValue u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpreMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreMinValue 6
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpreMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreMinValue u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpreMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreMinValue u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_8 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_8 7
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_8 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_8 u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_8 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_8 u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostMaxValue 7
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostMaxValue u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostMaxValue u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainMaxValue 7
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainMaxValue u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainMaxValue u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpreMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreMaxValue 7
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpreMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreMaxValue u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpreMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreMaxValue u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_9 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_9 8
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_9 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_9 u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_9 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_9 u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostInitValue 8
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostInitValue u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostInitValue u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainInitValue 8
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainInitValue u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainInitValue u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpreInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreInitValue 8
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpreInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreInitValue u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpreInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpreInitValue u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_10 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_10 9
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_10 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_10 u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_10 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_reservedTransmitProvisioning_10 u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostPresetValue 9
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostPresetValue u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCpostPresetValue u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainPresetValue 9
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainPresetValue u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngMainPresetValue u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCprePresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCprePresetValue 9
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCprePresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCprePresetValue u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCprePresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_EUR_krTrngCprePresetValue u9.word_9

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_PcsStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_EUR_baseRegisterAddress 0xC802
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_PcsStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_baseRegisterAddress 0xC820
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure numbersOfSerdesCals in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numbersOfSerdesCals 0
/*! \brief Preprocessor variable to relate field to bit position in structure numbersOfSerdesCals in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numbersOfSerdesCals u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure numbersOfSerdesCals in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numbersOfSerdesCals u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure numberOfSifBlockLockTranstitions_1__0 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifBlockLockTranstitions_1__0 1
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfSifBlockLockTranstitions_1__0 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifBlockLockTranstitions_1__0 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure numberOfSifBlockLockTranstitions_1__0 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifBlockLockTranstitions_1__0 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure numberOfSifBlockLockTranstitions_0__1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifBlockLockTranstitions_0__1 1
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfSifBlockLockTranstitions_0__1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifBlockLockTranstitions_0__1 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure numberOfSifBlockLockTranstitions_0__1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifBlockLockTranstitions_0__1 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure numberOfSifXgsSwitch_overs in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifXgsSwitch_overs 2
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfSifXgsSwitch_overs in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifXgsSwitch_overs u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure numberOfSifXgsSwitch_overs in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_EUR_numberOfSifXgsSwitch_overs u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_baseRegisterAddress 0xCC00
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure crpatTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_crpatTestPatternCheckerSyncError 0
/*! \brief Preprocessor variable to relate field to bit position in structure crpatTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_crpatTestPatternCheckerSyncError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure crpatTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_crpatTestPatternCheckerSyncError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure prbsTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_prbsTestPatternCheckerSyncError 0
/*! \brief Preprocessor variable to relate field to bit position in structure prbsTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_prbsTestPatternCheckerSyncError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure prbsTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_prbsTestPatternCheckerSyncError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure oscgmiiRxFifoInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_oscgmiiRxFifoInterrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure oscgmiiRxFifoInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_oscgmiiRxFifoInterrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure oscgmiiRxFifoInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_oscgmiiRxFifoInterrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure macsecEgressInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_macsecEgressInterrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecEgressInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_macsecEgressInterrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecEgressInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_macsecEgressInterrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure lossOfSignal in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_lossOfSignal 2
/*! \brief Preprocessor variable to relate field to bit position in structure lossOfSignal in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_lossOfSignal u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure lossOfSignal in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_lossOfSignal u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsTransmitAlarms in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_reservedPhyXsTransmitAlarms 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsTransmitAlarms in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_reservedPhyXsTransmitAlarms u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsTransmitAlarms in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_EUR_reservedPhyXsTransmitAlarms u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_baseRegisterAddress 0xD000
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure txLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_txLpiReceivedMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure txLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_txLpiReceivedMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_txLpiReceivedMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_rxLpiReceivedMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_rxLpiReceivedMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_rxLpiReceivedMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure transmitFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_transmitFaultMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure transmitFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_transmitFaultMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure transmitFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_transmitFaultMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure receiveFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_receiveFaultMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure receiveFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_receiveFaultMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure receiveFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_EUR_receiveFaultMask u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_baseRegisterAddress 0xD400
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure crpatTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_crpatTestPatternCheckerSyncErrorMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure crpatTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_crpatTestPatternCheckerSyncErrorMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure crpatTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_crpatTestPatternCheckerSyncErrorMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure prbsTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_prbsTestPatternCheckerSyncErrorMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure prbsTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_prbsTestPatternCheckerSyncErrorMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure prbsTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_prbsTestPatternCheckerSyncErrorMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure ocsgmiRxFifoInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_ocsgmiRxFifoInterruptMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure ocsgmiRxFifoInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_ocsgmiRxFifoInterruptMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure ocsgmiRxFifoInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_ocsgmiRxFifoInterruptMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure macsecEgressInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_macsecEgressInterruptMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecEgressInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_macsecEgressInterruptMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecEgressInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_macsecEgressInterruptMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure lossOfSignalMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_lossOfSignalMask 2
/*! \brief Preprocessor variable to relate field to bit position in structure lossOfSignalMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_lossOfSignalMask u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure lossOfSignalMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_lossOfSignalMask u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsTransmitAlarmsMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_reservedPhyXsTransmitAlarmsMask 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsTransmitAlarmsMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_reservedPhyXsTransmitAlarmsMask u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsTransmitAlarmsMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_EUR_reservedPhyXsTransmitAlarmsMask u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_baseRegisterAddress 0xD800
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure testPatternForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternForceError 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternForceError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternForceError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternMode_7ForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternMode_7ForceError 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternMode_7ForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternMode_7ForceError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternMode_7ForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternMode_7ForceError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure test_patternExtendedSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_test_patternExtendedSelect 0
/*! \brief Preprocessor variable to relate field to bit position in structure test_patternExtendedSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_test_patternExtendedSelect u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure test_patternExtendedSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_test_patternExtendedSelect u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternCheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternCheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternCheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternCheckPoint in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckPoint 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternCheckPoint in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckPoint u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternCheckPoint in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckPoint u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternMode_7CheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternMode_7CheckEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternMode_7CheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternMode_7CheckEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternMode_7CheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternMode_7CheckEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternInvert in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternInvert 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternInvert in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternInvert u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternInvert in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternInvert u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternSynchronizationThreshold in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternSynchronizationThreshold 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternSynchronizationThreshold in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternSynchronizationThreshold u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternSynchronizationThreshold in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternSynchronizationThreshold u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternInsertExtraIdles in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternInsertExtraIdles 1
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternInsertExtraIdles in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternInsertExtraIdles u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure testPatternInsertExtraIdles in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternInsertExtraIdles u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure testPatternCheckSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckSelect 1
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternCheckSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckSelect u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure testPatternCheckSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternCheckSelect u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure testPatternChannelSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternChannelSelect 1
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternChannelSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternChannelSelect u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure testPatternChannelSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_EUR_testPatternChannelSelect u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_baseRegisterAddress 0xD810
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure channel_0TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_0TestPatternErrorCounter 0
/*! \brief Preprocessor variable to relate field to bit position in structure channel_0TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_0TestPatternErrorCounter u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure channel_0TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_0TestPatternErrorCounter u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure channel_1TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_1TestPatternErrorCounter 1
/*! \brief Preprocessor variable to relate field to bit position in structure channel_1TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_1TestPatternErrorCounter u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure channel_1TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_1TestPatternErrorCounter u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure channel_2TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_2TestPatternErrorCounter 2
/*! \brief Preprocessor variable to relate field to bit position in structure channel_2TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_2TestPatternErrorCounter u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure channel_2TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_2TestPatternErrorCounter u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure channel_3TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_3TestPatternErrorCounter 3
/*! \brief Preprocessor variable to relate field to bit position in structure channel_3TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_3TestPatternErrorCounter u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure channel_3TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_channel_3TestPatternErrorCounter u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure testPatternMode_7ErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_testPatternMode_7ErrorCounter 4
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternMode_7ErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_testPatternMode_7ErrorCounter u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure testPatternMode_7ErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_testPatternMode_7ErrorCounter u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure packetFcsErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsErrorCounterLSW 5
/*! \brief Preprocessor variable to relate field to bit position in structure packetFcsErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsErrorCounterLSW u5.bits_5
/*! \brief Preprocessor variable to relate field to word position in structure packetFcsErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsErrorCounterLSW u5.word_5
/*! \brief Preprocessor variable to relate field to word number in structure packetFcsErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsErrorCounterMSW 6
/*! \brief Preprocessor variable to relate field to bit position in structure packetFcsErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsErrorCounterMSW u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure packetFcsErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsErrorCounterMSW u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure packetFcsNoErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsNoErrorCounterLSW 7
/*! \brief Preprocessor variable to relate field to bit position in structure packetFcsNoErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsNoErrorCounterLSW u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure packetFcsNoErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsNoErrorCounterLSW u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure packetFcsNoErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsNoErrorCounterMSW 8
/*! \brief Preprocessor variable to relate field to bit position in structure packetFcsNoErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsNoErrorCounterMSW u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure packetFcsNoErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_EUR_packetFcsNoErrorCounterMSW u8.word_8

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_baseRegisterAddress 0xD820
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure packetSourceAddressError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetSourceAddressError 0
/*! \brief Preprocessor variable to relate field to bit position in structure packetSourceAddressError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetSourceAddressError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure packetSourceAddressError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetSourceAddressError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure packetDestinationAddressError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetDestinationAddressError 0
/*! \brief Preprocessor variable to relate field to bit position in structure packetDestinationAddressError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetDestinationAddressError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure packetDestinationAddressError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetDestinationAddressError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure packetEthertypeOrLengthError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetEthertypeOrLengthError 0
/*! \brief Preprocessor variable to relate field to bit position in structure packetEthertypeOrLengthError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetEthertypeOrLengthError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure packetEthertypeOrLengthError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetEthertypeOrLengthError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure sequenceNumberError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_sequenceNumberError 0
/*! \brief Preprocessor variable to relate field to bit position in structure sequenceNumberError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_sequenceNumberError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure sequenceNumberError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_sequenceNumberError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure packetPayloadError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayloadError 0
/*! \brief Preprocessor variable to relate field to bit position in structure packetPayloadError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayloadError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure packetPayloadError in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayloadError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure packetPayload_0 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_0 1
/*! \brief Preprocessor variable to relate field to bit position in structure packetPayload_0 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_0 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure packetPayload_0 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_0 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure packetPayload_1 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_1 2
/*! \brief Preprocessor variable to relate field to bit position in structure packetPayload_1 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_1 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure packetPayload_1 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_1 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure packetPayload_2 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_2 3
/*! \brief Preprocessor variable to relate field to bit position in structure packetPayload_2 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_2 u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure packetPayload_2 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_2 u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure packetPayload_3 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_3 4
/*! \brief Preprocessor variable to relate field to bit position in structure packetPayload_3 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_3 u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure packetPayload_3 in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorStatus_EUR_packetPayload_3 u4.word_4

/*! \brief Base register address of structure AQ_OcsgmiiRxFifoStatus_EUR */
#define AQ_OcsgmiiRxFifoStatus_EUR_baseRegisterAddress 0xD840
/*! \brief MMD address of structure AQ_OcsgmiiRxFifoStatus_EUR */
#define AQ_OcsgmiiRxFifoStatus_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure ocsgmiiRxFifoLevel in AQ_OcsgmiiRxFifoStatus_EUR */
#define AQ_OcsgmiiRxFifoStatus_EUR_ocsgmiiRxFifoLevel 0
/*! \brief Preprocessor variable to relate field to bit position in structure ocsgmiiRxFifoLevel in AQ_OcsgmiiRxFifoStatus_EUR */
#define bits_AQ_OcsgmiiRxFifoStatus_EUR_ocsgmiiRxFifoLevel u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure ocsgmiiRxFifoLevel in AQ_OcsgmiiRxFifoStatus_EUR */
#define word_AQ_OcsgmiiRxFifoStatus_EUR_ocsgmiiRxFifoLevel u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_baseRegisterAddress 0xE410
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_1a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_1a 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_1a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_1a u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_1a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_1a u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemSgmiiTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_systemSgmiiTxInvert 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemSgmiiTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_systemSgmiiTxInvert u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemSgmiiTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_systemSgmiiTxInvert u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_2a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2a 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_2a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2a u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_2a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2a u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemKrTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_systemKrTxInvert 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemKrTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_systemKrTxInvert u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemKrTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_systemKrTxInvert u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_2b in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2b 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_2b in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2b u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_2b in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2b u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure applySerdesTxSettings in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_applySerdesTxSettings 1
/*! \brief Preprocessor variable to relate field to bit position in structure applySerdesTxSettings in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_applySerdesTxSettings u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure applySerdesTxSettings in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_applySerdesTxSettings u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_2 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_2 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_2 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedReceiveProvisioning_2 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_3 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_3 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_3 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_3 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_3 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_3 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0PostTap_1 2
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0PostTap_1 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0PostTap_1 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0PreTap 2
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0PreTap u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0PreTap u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_4 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_4 3
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_4 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_4 u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_4 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_4 u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0MainTap 3
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0MainTap u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0MainTap u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0Amplitude 3
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0Amplitude u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_serdesLane_0Amplitude u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_5 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_5 4
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_5 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_5 u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_5 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_5 u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_6 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_6 5
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_6 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_6 u5.bits_5
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_6 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_6 u5.word_5
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_7 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_7 6
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_7 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_7 u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_7 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_7 u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_8 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_8 7
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_8 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_8 u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_8 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_8 u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_9 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_9 8
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_9 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_9 u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_9 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_9 u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_10 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_10 9
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_10 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_10 u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_10 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_EUR_reservedRxProvisioning_10 u9.word_9

/*! \brief Base register address of structure AQ_PifMailboxExtra_EUR */
#define AQ_PifMailboxExtra_EUR_baseRegisterAddress 0xE41D
/*! \brief MMD address of structure AQ_PifMailboxExtra_EUR */
#define AQ_PifMailboxExtra_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure pifMailboxAddressRegister_2 in AQ_PifMailboxExtra_EUR */
#define AQ_PifMailboxExtra_EUR_pifMailboxAddressRegister_2 0
/*! \brief Preprocessor variable to relate field to bit position in structure pifMailboxAddressRegister_2 in AQ_PifMailboxExtra_EUR */
#define bits_AQ_PifMailboxExtra_EUR_pifMailboxAddressRegister_2 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure pifMailboxAddressRegister_2 in AQ_PifMailboxExtra_EUR */
#define word_AQ_PifMailboxExtra_EUR_pifMailboxAddressRegister_2 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure pifMailboxDataRegister_2 in AQ_PifMailboxExtra_EUR */
#define AQ_PifMailboxExtra_EUR_pifMailboxDataRegister_2 1
/*! \brief Preprocessor variable to relate field to bit position in structure pifMailboxDataRegister_2 in AQ_PifMailboxExtra_EUR */
#define bits_AQ_PifMailboxExtra_EUR_pifMailboxDataRegister_2 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure pifMailboxDataRegister_2 in AQ_PifMailboxExtra_EUR */
#define word_AQ_PifMailboxExtra_EUR_pifMailboxDataRegister_2 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_16 in AQ_PifMailboxExtra_EUR */
#define AQ_PifMailboxExtra_EUR_reservedRxProvisioning_16 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_16 in AQ_PifMailboxExtra_EUR */
#define bits_AQ_PifMailboxExtra_EUR_reservedRxProvisioning_16 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_16 in AQ_PifMailboxExtra_EUR */
#define word_AQ_PifMailboxExtra_EUR_reservedRxProvisioning_16 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure pifMailboxMMD_Register_2 in AQ_PifMailboxExtra_EUR */
#define AQ_PifMailboxExtra_EUR_pifMailboxMMD_Register_2 2
/*! \brief Preprocessor variable to relate field to bit position in structure pifMailboxMMD_Register_2 in AQ_PifMailboxExtra_EUR */
#define bits_AQ_PifMailboxExtra_EUR_pifMailboxMMD_Register_2 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure pifMailboxMMD_Register_2 in AQ_PifMailboxExtra_EUR */
#define word_AQ_PifMailboxExtra_EUR_pifMailboxMMD_Register_2 u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_PcsStatus_EUR */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_EUR_baseRegisterAddress 0xE802
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_PcsStatus_EUR */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR_baseRegisterAddress 0xE810
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure numberOfUsxAnegRestarts in AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR_numberOfUsxAnegRestarts 0
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfUsxAnegRestarts in AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR_numberOfUsxAnegRestarts u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure numberOfUsxAnegRestarts in AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorState_EUR_numberOfUsxAnegRestarts u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_baseRegisterAddress 0xE812
/*! \brief MMD address of structure AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceAutonegStatus in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceAutonegStatus 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceAutonegStatus in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceAutonegStatus u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceAutonegStatus in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceAutonegStatus u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLinkUp in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_rxLinkUp 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLinkUp in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_rxLinkUp u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLinkUp in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_rxLinkUp u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure txReady in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_txReady 0
/*! \brief Preprocessor variable to relate field to bit position in structure txReady in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_txReady u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txReady in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_txReady u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRate in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceRate 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRate in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceRate u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRate in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceRate u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceInUse in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceInUse 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceInUse in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceInUse u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceInUse in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_systemInterfaceInUse u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveState_3 in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_reservedReceiveState_3 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveState_3 in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_reservedReceiveState_3 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveState_3 in AQ_PhyXS_SystemInterfaceConnectionStatus_EUR */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_EUR_reservedReceiveState_3 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_baseRegisterAddress 0xEC00
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure macsecIngressInterrupt in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_macsecIngressInterrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecIngressInterrupt in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_macsecIngressInterrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecIngressInterrupt in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_macsecIngressInterrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkUp in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceRxLinkUp 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkUp in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceRxLinkUp u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkUp in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceRxLinkUp u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkDown in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceRxLinkDown 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkDown in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceRxLinkDown u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkDown in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceRxLinkDown u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceTxReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceTxReady 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceTxReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceTxReady u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceTxReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceTxReady u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceTxNotReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceTxNotReady 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceTxNotReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceTxNotReady u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceTxNotReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_systemInterfaceTxNotReady u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsReceiveAlarms_2 in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_reservedPhyXsReceiveAlarms_2 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsReceiveAlarms_2 in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_reservedPhyXsReceiveAlarms_2 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsReceiveAlarms_2 in AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_EUR_reservedPhyXsReceiveAlarms_2 u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_baseRegisterAddress 0xF400
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure macsecIngressInterruptMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_macsecIngressInterruptMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecIngressInterruptMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_macsecIngressInterruptMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecIngressInterruptMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_macsecIngressInterruptMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkUpMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_systemInterfaceRxLinkUpMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkUpMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_systemInterfaceRxLinkUpMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkUpMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_systemInterfaceRxLinkUpMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkDownMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_systemInterfaceRxLinkDownMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkDownMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_systemInterfaceRxLinkDownMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkDownMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_systemInterfaceRxLinkDownMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsReceiveAlarms_2Mask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_reservedPhyXsReceiveAlarms_2Mask 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsReceiveAlarms_2Mask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_reservedPhyXsReceiveAlarms_2Mask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsReceiveAlarms_2Mask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_EUR_reservedPhyXsReceiveAlarms_2Mask u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_VendorDebug_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_EUR_baseRegisterAddress 0xF800
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_VendorDebug_EUR */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_EUR_mmdAddress 0x04

/*! \brief Base register address of structure AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_baseRegisterAddress 0xFC00
/*! \brief MMD address of structure AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure standardAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_standardAlarms_1Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure standardAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_standardAlarms_1Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure standardAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_standardAlarms_1Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure standardAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_standardAlarms_2Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure standardAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_standardAlarms_2Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure standardAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_standardAlarms_2Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificTxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificTxAlarms_1Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificTxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificTxAlarms_1Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificTxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificTxAlarms_1Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificTxAlarms_3Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificTxAlarms_3Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificTxAlarms_3Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificTxAlarms_3Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificTxAlarms_3Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificTxAlarms_3Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificRxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificRxAlarms_1Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificRxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificRxAlarms_1Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificRxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificRxAlarms_1Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificRxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificRxAlarms_2Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificRxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificRxAlarms_2Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificRxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_EUR */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_EUR_vendorSpecificRxAlarms_2Interrupt u0.word_0
#endif
/*@}*/
/*@}*/
