/************************************************************************************
*
* Copyright (c) 2017 Aquantia Corp.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
*
* 1. Redistributions of source code must retain the above copyright notice, 
* this list of conditions and the following disclaimer.
*
* 2. Redistributions in binary form must reproduce the above copyright 
* notice, this list of conditions and the following disclaimer in the 
* documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY 
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY 
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH 
* DAMAGE.
*
************************************************************************************/

/*! \file 
*   This file contains the compiler assist macros and doxygen comments
*   for the PHY_XS Registers block.
*/

/*! \defgroup PHY_XS_registers_Defines PHY_XS Registers Defines
*   This module contains the compiler assist macros and doxygen comments
*   for the PHY_XS Registers block.
*/
/***********************************************************************
*                     Copyright Aquantia Corp.
*                             Freeware
*
* $File: //depot/icm/proj/Dena/rev1.0/c/Systems/tools/windows/regMapParser/src/gencheaders.py $
*
* $Revision: #13 $
*
* $DateTime: 2016/09/23 10:49:54 $
*
* $Author: wxia $
*
* $Label: $
*
* Description:
*
*   This file contains the compiler assist macros for the registers contained in the PHY_XS Registers block.
*
*
***********************************************************************/


/*@{*/
#ifndef AQ_HHD_PHY_XS_REGS_DEFINES_HEADER
#define AQ_HHD_PHY_XS_REGS_DEFINES_HEADER


/*-----------------------------------------------------------------------------*/
/*Access macro definitions                                                     */
/*-----------------------------------------------------------------------------*/
/*! \brief Base register address of structure AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_baseRegisterAddress 0x0000
/*! \brief MMD address of structure AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reset in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_reset 0
/*! \brief Preprocessor variable to relate field to bit position in structure reset in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_reset u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reset in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_reset u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure loopback in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_loopback 0
/*! \brief Preprocessor variable to relate field to bit position in structure loopback in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_loopback u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure loopback in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_loopback u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure speedSelection_0 in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_speedSelection_0 0
/*! \brief Preprocessor variable to relate field to bit position in structure speedSelection_0 in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_speedSelection_0 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure speedSelection_0 in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_speedSelection_0 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure lowPower in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_lowPower 0
/*! \brief Preprocessor variable to relate field to bit position in structure lowPower in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_lowPower u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure lowPower in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_lowPower u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure clockStopEnable in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_clockStopEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure clockStopEnable in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_clockStopEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure clockStopEnable in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_clockStopEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiStopEnable in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_xauiStopEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiStopEnable in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_xauiStopEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiStopEnable in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_xauiStopEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure speedSelection_1 in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_speedSelection_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure speedSelection_1 in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_speedSelection_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure speedSelection_1 in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_speedSelection_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure speedSelection_2 in AQ_PhyXS_StandardControl_1_HHD */
#define AQ_PhyXS_StandardControl_1_HHD_speedSelection_2 0
/*! \brief Preprocessor variable to relate field to bit position in structure speedSelection_2 in AQ_PhyXS_StandardControl_1_HHD */
#define bits_AQ_PhyXS_StandardControl_1_HHD_speedSelection_2 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure speedSelection_2 in AQ_PhyXS_StandardControl_1_HHD */
#define word_AQ_PhyXS_StandardControl_1_HHD_speedSelection_2 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_baseRegisterAddress 0x0001
/*! \brief MMD address of structure AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure txLpiReceived in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_txLpiReceived 0
/*! \brief Preprocessor variable to relate field to bit position in structure txLpiReceived in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_txLpiReceived u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txLpiReceived in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_txLpiReceived u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLpiReceived in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_rxLpiReceived 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLpiReceived in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_rxLpiReceived u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLpiReceived in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_rxLpiReceived u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure txLpiIndication in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_txLpiIndication 0
/*! \brief Preprocessor variable to relate field to bit position in structure txLpiIndication in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_txLpiIndication u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txLpiIndication in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_txLpiIndication u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLpiIndication in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_rxLpiIndication 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLpiIndication in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_rxLpiIndication u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLpiIndication in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_rxLpiIndication u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure fault in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_fault 0
/*! \brief Preprocessor variable to relate field to bit position in structure fault in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_fault u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure fault in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_fault u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure clockStopCapable in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_clockStopCapable 0
/*! \brief Preprocessor variable to relate field to bit position in structure clockStopCapable in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_clockStopCapable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure clockStopCapable in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_clockStopCapable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_TransmitLinkAlignmentStatus in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_phyXS_TransmitLinkAlignmentStatus 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_TransmitLinkAlignmentStatus in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_phyXS_TransmitLinkAlignmentStatus u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_TransmitLinkAlignmentStatus in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_phyXS_TransmitLinkAlignmentStatus u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure lowPowerAbility in AQ_PhyXS_StandardStatus_1_HHD */
#define AQ_PhyXS_StandardStatus_1_HHD_lowPowerAbility 0
/*! \brief Preprocessor variable to relate field to bit position in structure lowPowerAbility in AQ_PhyXS_StandardStatus_1_HHD */
#define bits_AQ_PhyXS_StandardStatus_1_HHD_lowPowerAbility u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure lowPowerAbility in AQ_PhyXS_StandardStatus_1_HHD */
#define word_AQ_PhyXS_StandardStatus_1_HHD_lowPowerAbility u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define AQ_PhyXS_StandardDeviceIdentifier_HHD_baseRegisterAddress 0x0002
/*! \brief MMD address of structure AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define AQ_PhyXS_StandardDeviceIdentifier_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure deviceIdMSW in AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define AQ_PhyXS_StandardDeviceIdentifier_HHD_deviceIdMSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure deviceIdMSW in AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define bits_AQ_PhyXS_StandardDeviceIdentifier_HHD_deviceIdMSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure deviceIdMSW in AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define word_AQ_PhyXS_StandardDeviceIdentifier_HHD_deviceIdMSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure deviceIdLSW in AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define AQ_PhyXS_StandardDeviceIdentifier_HHD_deviceIdLSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure deviceIdLSW in AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define bits_AQ_PhyXS_StandardDeviceIdentifier_HHD_deviceIdLSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure deviceIdLSW in AQ_PhyXS_StandardDeviceIdentifier_HHD */
#define word_AQ_PhyXS_StandardDeviceIdentifier_HHD_deviceIdLSW u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_StandardSpeedAbility_HHD */
#define AQ_PhyXS_StandardSpeedAbility_HHD_baseRegisterAddress 0x0004
/*! \brief MMD address of structure AQ_PhyXS_StandardSpeedAbility_HHD */
#define AQ_PhyXS_StandardSpeedAbility_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure _10gCapable in AQ_PhyXS_StandardSpeedAbility_HHD */
#define AQ_PhyXS_StandardSpeedAbility_HHD__10gCapable 0
/*! \brief Preprocessor variable to relate field to bit position in structure _10gCapable in AQ_PhyXS_StandardSpeedAbility_HHD */
#define bits_AQ_PhyXS_StandardSpeedAbility_HHD__10gCapable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure _10gCapable in AQ_PhyXS_StandardSpeedAbility_HHD */
#define word_AQ_PhyXS_StandardSpeedAbility_HHD__10gCapable u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_baseRegisterAddress 0x0005
/*! \brief MMD address of structure AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure autonegotiationPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_autonegotiationPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure autonegotiationPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_autonegotiationPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure autonegotiationPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_autonegotiationPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure tcPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_tcPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure tcPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_tcPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure tcPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_tcPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure dteXsPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_dteXsPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure dteXsPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_dteXsPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure dteXsPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_dteXsPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_phyXS_Present 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_phyXS_Present u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_phyXS_Present u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure pcsPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_pcsPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure pcsPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_pcsPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure pcsPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_pcsPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure wisPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_wisPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure wisPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_wisPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure wisPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_wisPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure pmaPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_pmaPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure pmaPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_pmaPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure pmaPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_pmaPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure clause_22RegistersPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_clause_22RegistersPresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure clause_22RegistersPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_clause_22RegistersPresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure clause_22RegistersPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_clause_22RegistersPresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificDevice_2Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_vendorSpecificDevice_2Present 1
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificDevice_2Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_vendorSpecificDevice_2Present u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificDevice_2Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_vendorSpecificDevice_2Present u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificDevice_1Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_vendorSpecificDevice_1Present 1
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificDevice_1Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_vendorSpecificDevice_1Present u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificDevice_1Present in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_vendorSpecificDevice_1Present u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure clause_22ExtensionPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define AQ_PhyXS_StandardDevicesInPackage_HHD_clause_22ExtensionPresent 1
/*! \brief Preprocessor variable to relate field to bit position in structure clause_22ExtensionPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define bits_AQ_PhyXS_StandardDevicesInPackage_HHD_clause_22ExtensionPresent u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure clause_22ExtensionPresent in AQ_PhyXS_StandardDevicesInPackage_HHD */
#define word_AQ_PhyXS_StandardDevicesInPackage_HHD_clause_22ExtensionPresent u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_StandardStatus_2_HHD */
#define AQ_PhyXS_StandardStatus_2_HHD_baseRegisterAddress 0x0008
/*! \brief MMD address of structure AQ_PhyXS_StandardStatus_2_HHD */
#define AQ_PhyXS_StandardStatus_2_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure devicePresent in AQ_PhyXS_StandardStatus_2_HHD */
#define AQ_PhyXS_StandardStatus_2_HHD_devicePresent 0
/*! \brief Preprocessor variable to relate field to bit position in structure devicePresent in AQ_PhyXS_StandardStatus_2_HHD */
#define bits_AQ_PhyXS_StandardStatus_2_HHD_devicePresent u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure devicePresent in AQ_PhyXS_StandardStatus_2_HHD */
#define word_AQ_PhyXS_StandardStatus_2_HHD_devicePresent u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure transmitFault in AQ_PhyXS_StandardStatus_2_HHD */
#define AQ_PhyXS_StandardStatus_2_HHD_transmitFault 0
/*! \brief Preprocessor variable to relate field to bit position in structure transmitFault in AQ_PhyXS_StandardStatus_2_HHD */
#define bits_AQ_PhyXS_StandardStatus_2_HHD_transmitFault u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure transmitFault in AQ_PhyXS_StandardStatus_2_HHD */
#define word_AQ_PhyXS_StandardStatus_2_HHD_transmitFault u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure receiveFault in AQ_PhyXS_StandardStatus_2_HHD */
#define AQ_PhyXS_StandardStatus_2_HHD_receiveFault 0
/*! \brief Preprocessor variable to relate field to bit position in structure receiveFault in AQ_PhyXS_StandardStatus_2_HHD */
#define bits_AQ_PhyXS_StandardStatus_2_HHD_receiveFault u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure receiveFault in AQ_PhyXS_StandardStatus_2_HHD */
#define word_AQ_PhyXS_StandardStatus_2_HHD_receiveFault u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardPackageIdentifier_HHD */
#define AQ_PhyXS_StandardPackageIdentifier_HHD_baseRegisterAddress 0x000E
/*! \brief MMD address of structure AQ_PhyXS_StandardPackageIdentifier_HHD */
#define AQ_PhyXS_StandardPackageIdentifier_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure packageIdMSW in AQ_PhyXS_StandardPackageIdentifier_HHD */
#define AQ_PhyXS_StandardPackageIdentifier_HHD_packageIdMSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure packageIdMSW in AQ_PhyXS_StandardPackageIdentifier_HHD */
#define bits_AQ_PhyXS_StandardPackageIdentifier_HHD_packageIdMSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure packageIdMSW in AQ_PhyXS_StandardPackageIdentifier_HHD */
#define word_AQ_PhyXS_StandardPackageIdentifier_HHD_packageIdMSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure packageIdLSW in AQ_PhyXS_StandardPackageIdentifier_HHD */
#define AQ_PhyXS_StandardPackageIdentifier_HHD_packageIdLSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure packageIdLSW in AQ_PhyXS_StandardPackageIdentifier_HHD */
#define bits_AQ_PhyXS_StandardPackageIdentifier_HHD_packageIdLSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure packageIdLSW in AQ_PhyXS_StandardPackageIdentifier_HHD */
#define word_AQ_PhyXS_StandardPackageIdentifier_HHD_packageIdLSW u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_EeeCapabilityRegister_HHD */
#define AQ_PhyXS_EeeCapabilityRegister_HHD_baseRegisterAddress 0x0014
/*! \brief MMD address of structure AQ_PhyXS_EeeCapabilityRegister_HHD */
#define AQ_PhyXS_EeeCapabilityRegister_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_Eee in AQ_PhyXS_EeeCapabilityRegister_HHD */
#define AQ_PhyXS_EeeCapabilityRegister_HHD_phyXS_Eee 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_Eee in AQ_PhyXS_EeeCapabilityRegister_HHD */
#define bits_AQ_PhyXS_EeeCapabilityRegister_HHD_phyXS_Eee u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_Eee in AQ_PhyXS_EeeCapabilityRegister_HHD */
#define word_AQ_PhyXS_EeeCapabilityRegister_HHD_phyXS_Eee u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiStopCapable in AQ_PhyXS_EeeCapabilityRegister_HHD */
#define AQ_PhyXS_EeeCapabilityRegister_HHD_xauiStopCapable 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiStopCapable in AQ_PhyXS_EeeCapabilityRegister_HHD */
#define bits_AQ_PhyXS_EeeCapabilityRegister_HHD_xauiStopCapable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiStopCapable in AQ_PhyXS_EeeCapabilityRegister_HHD */
#define word_AQ_PhyXS_EeeCapabilityRegister_HHD_xauiStopCapable u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_EeeWakeErrorCounter_HHD */
#define AQ_PhyXS_EeeWakeErrorCounter_HHD_baseRegisterAddress 0x0016
/*! \brief MMD address of structure AQ_PhyXS_EeeWakeErrorCounter_HHD */
#define AQ_PhyXS_EeeWakeErrorCounter_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure eeeWakeErrorCounter in AQ_PhyXS_EeeWakeErrorCounter_HHD */
#define AQ_PhyXS_EeeWakeErrorCounter_HHD_eeeWakeErrorCounter 0
/*! \brief Preprocessor variable to relate field to bit position in structure eeeWakeErrorCounter in AQ_PhyXS_EeeWakeErrorCounter_HHD */
#define bits_AQ_PhyXS_EeeWakeErrorCounter_HHD_eeeWakeErrorCounter u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure eeeWakeErrorCounter in AQ_PhyXS_EeeWakeErrorCounter_HHD */
#define word_AQ_PhyXS_EeeWakeErrorCounter_HHD_eeeWakeErrorCounter u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define AQ_PhyXS_StandardXGXS_LaneStatus_HHD_baseRegisterAddress 0x0018
/*! \brief MMD address of structure AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define AQ_PhyXS_StandardXGXS_LaneStatus_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure phyXGXS_LaneAlignmentStatus in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_LaneAlignmentStatus 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXGXS_LaneAlignmentStatus in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_LaneAlignmentStatus u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXGXS_LaneAlignmentStatus in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_LaneAlignmentStatus u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXGXS_PatternTestingAbility in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_PatternTestingAbility 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXGXS_PatternTestingAbility in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_PatternTestingAbility u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXGXS_PatternTestingAbility in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_PatternTestingAbility u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXGXS_LoopbackAbility in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_LoopbackAbility 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXGXS_LoopbackAbility in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_LoopbackAbility u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXGXS_LoopbackAbility in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_phyXGXS_LoopbackAbility u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure laneSync in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define AQ_PhyXS_StandardXGXS_LaneStatus_HHD_laneSync 0
/*! \brief Preprocessor variable to relate field to bit position in structure laneSync in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define bits_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_laneSync u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure laneSync in AQ_PhyXS_StandardXGXS_LaneStatus_HHD */
#define word_AQ_PhyXS_StandardXGXS_LaneStatus_HHD_laneSync u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define AQ_PhyXS_StandardXGXS_TestControl_HHD_baseRegisterAddress 0x0019
/*! \brief MMD address of structure AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define AQ_PhyXS_StandardXGXS_TestControl_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure receiveTest_PatternEnable in AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define AQ_PhyXS_StandardXGXS_TestControl_HHD_receiveTest_PatternEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure receiveTest_PatternEnable in AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define bits_AQ_PhyXS_StandardXGXS_TestControl_HHD_receiveTest_PatternEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure receiveTest_PatternEnable in AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define word_AQ_PhyXS_StandardXGXS_TestControl_HHD_receiveTest_PatternEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure test_patternSelect in AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define AQ_PhyXS_StandardXGXS_TestControl_HHD_test_patternSelect 0
/*! \brief Preprocessor variable to relate field to bit position in structure test_patternSelect in AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define bits_AQ_PhyXS_StandardXGXS_TestControl_HHD_test_patternSelect u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure test_patternSelect in AQ_PhyXS_StandardXGXS_TestControl_HHD */
#define word_AQ_PhyXS_StandardXGXS_TestControl_HHD_test_patternSelect u0.word_0

/*! \brief Base register address of structure AQ_TimesyncPhyXsCapability_HHD */
#define AQ_TimesyncPhyXsCapability_HHD_baseRegisterAddress 0x1800
/*! \brief MMD address of structure AQ_TimesyncPhyXsCapability_HHD */
#define AQ_TimesyncPhyXsCapability_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure timesyncTransmitPathDataDelay in AQ_TimesyncPhyXsCapability_HHD */
#define AQ_TimesyncPhyXsCapability_HHD_timesyncTransmitPathDataDelay 0
/*! \brief Preprocessor variable to relate field to bit position in structure timesyncTransmitPathDataDelay in AQ_TimesyncPhyXsCapability_HHD */
#define bits_AQ_TimesyncPhyXsCapability_HHD_timesyncTransmitPathDataDelay u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure timesyncTransmitPathDataDelay in AQ_TimesyncPhyXsCapability_HHD */
#define word_AQ_TimesyncPhyXsCapability_HHD_timesyncTransmitPathDataDelay u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure timesyncReceivePathDataDelay in AQ_TimesyncPhyXsCapability_HHD */
#define AQ_TimesyncPhyXsCapability_HHD_timesyncReceivePathDataDelay 0
/*! \brief Preprocessor variable to relate field to bit position in structure timesyncReceivePathDataDelay in AQ_TimesyncPhyXsCapability_HHD */
#define bits_AQ_TimesyncPhyXsCapability_HHD_timesyncReceivePathDataDelay u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure timesyncReceivePathDataDelay in AQ_TimesyncPhyXsCapability_HHD */
#define word_AQ_TimesyncPhyXsCapability_HHD_timesyncReceivePathDataDelay u0.word_0

/*! \brief Base register address of structure AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_baseRegisterAddress 0x1801
/*! \brief MMD address of structure AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_maximumPhyXsTransmitPathDataDelayLSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_maximumPhyXsTransmitPathDataDelayLSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_maximumPhyXsTransmitPathDataDelayLSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_maximumPhyXsTransmitPathDataDelayMSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_maximumPhyXsTransmitPathDataDelayMSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_maximumPhyXsTransmitPathDataDelayMSW u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_minimumPhyXsTransmitPathDataDelayLSW 2
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_minimumPhyXsTransmitPathDataDelayLSW u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsTransmitPathDataDelayLSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_minimumPhyXsTransmitPathDataDelayLSW u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_minimumPhyXsTransmitPathDataDelayMSW 3
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_minimumPhyXsTransmitPathDataDelayMSW u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsTransmitPathDataDelayMSW in AQ_TimesyncPhyXsTransmitPathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsTransmitPathDataDelay_HHD_minimumPhyXsTransmitPathDataDelayMSW u3.word_3

/*! \brief Base register address of structure AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define AQ_TimesyncPhyXsReceivePathDataDelay_HHD_baseRegisterAddress 0x1805
/*! \brief MMD address of structure AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define AQ_TimesyncPhyXsReceivePathDataDelay_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define AQ_TimesyncPhyXsReceivePathDataDelay_HHD_maximumPhyXsReceivePathDataDelayLSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_maximumPhyXsReceivePathDataDelayLSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_maximumPhyXsReceivePathDataDelayLSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure maximumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define AQ_TimesyncPhyXsReceivePathDataDelay_HHD_maximumPhyXsReceivePathDataDelayMSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure maximumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_maximumPhyXsReceivePathDataDelayMSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure maximumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_maximumPhyXsReceivePathDataDelayMSW u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define AQ_TimesyncPhyXsReceivePathDataDelay_HHD_minimumPhyXsReceivePathDataDelayLSW 2
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_minimumPhyXsReceivePathDataDelayLSW u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsReceivePathDataDelayLSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_minimumPhyXsReceivePathDataDelayLSW u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure minimumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define AQ_TimesyncPhyXsReceivePathDataDelay_HHD_minimumPhyXsReceivePathDataDelayMSW 3
/*! \brief Preprocessor variable to relate field to bit position in structure minimumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define bits_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_minimumPhyXsReceivePathDataDelayMSW u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure minimumPhyXsReceivePathDataDelayMSW in AQ_TimesyncPhyXsReceivePathDataDelay_HHD */
#define word_AQ_TimesyncPhyXsReceivePathDataDelay_HHD_minimumPhyXsReceivePathDataDelayMSW u3.word_3

/*! \brief Base register address of structure AQ_PhyXS_SerdesConfiguration_HHD */
#define AQ_PhyXS_SerdesConfiguration_HHD_baseRegisterAddress 0xC180
/*! \brief MMD address of structure AQ_PhyXS_SerdesConfiguration_HHD */
#define AQ_PhyXS_SerdesConfiguration_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure serdesConfigurationReserved_1_1 in AQ_PhyXS_SerdesConfiguration_HHD */
#define AQ_PhyXS_SerdesConfiguration_HHD_serdesConfigurationReserved_1_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesConfigurationReserved_1_1 in AQ_PhyXS_SerdesConfiguration_HHD */
#define bits_AQ_PhyXS_SerdesConfiguration_HHD_serdesConfigurationReserved_1_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesConfigurationReserved_1_1 in AQ_PhyXS_SerdesConfiguration_HHD */
#define word_AQ_PhyXS_SerdesConfiguration_HHD_serdesConfigurationReserved_1_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure serdesConfigurationReserved_1_2 in AQ_PhyXS_SerdesConfiguration_HHD */
#define AQ_PhyXS_SerdesConfiguration_HHD_serdesConfigurationReserved_1_2 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesConfigurationReserved_1_2 in AQ_PhyXS_SerdesConfiguration_HHD */
#define bits_AQ_PhyXS_SerdesConfiguration_HHD_serdesConfigurationReserved_1_2 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesConfigurationReserved_1_2 in AQ_PhyXS_SerdesConfiguration_HHD */
#define word_AQ_PhyXS_SerdesConfiguration_HHD_serdesConfigurationReserved_1_2 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_0Configuration_HHD */
#define AQ_PhyXS_SerdesLane_0Configuration_HHD_baseRegisterAddress 0xC1C0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_0Configuration_HHD */
#define AQ_PhyXS_SerdesLane_0Configuration_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_0Configuration_HHD */
#define AQ_PhyXS_SerdesLane_0Configuration_HHD_serdesLane_0ConfigurationReserved_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_0Configuration_HHD */
#define bits_AQ_PhyXS_SerdesLane_0Configuration_HHD_serdesLane_0ConfigurationReserved_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_0Configuration_HHD */
#define word_AQ_PhyXS_SerdesLane_0Configuration_HHD_serdesLane_0ConfigurationReserved_1 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_1Configuration_HHD */
#define AQ_PhyXS_SerdesLane_1Configuration_HHD_baseRegisterAddress 0xC1D0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_1Configuration_HHD */
#define AQ_PhyXS_SerdesLane_1Configuration_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_1ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_1Configuration_HHD */
#define AQ_PhyXS_SerdesLane_1Configuration_HHD_serdesLane_1ConfigurationReserved_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_1ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_1Configuration_HHD */
#define bits_AQ_PhyXS_SerdesLane_1Configuration_HHD_serdesLane_1ConfigurationReserved_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_1ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_1Configuration_HHD */
#define word_AQ_PhyXS_SerdesLane_1Configuration_HHD_serdesLane_1ConfigurationReserved_1 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_2Configuration_HHD */
#define AQ_PhyXS_SerdesLane_2Configuration_HHD_baseRegisterAddress 0xC1E0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_2Configuration_HHD */
#define AQ_PhyXS_SerdesLane_2Configuration_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_2ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_2Configuration_HHD */
#define AQ_PhyXS_SerdesLane_2Configuration_HHD_serdesLane_2ConfigurationReserved_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_2ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_2Configuration_HHD */
#define bits_AQ_PhyXS_SerdesLane_2Configuration_HHD_serdesLane_2ConfigurationReserved_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_2ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_2Configuration_HHD */
#define word_AQ_PhyXS_SerdesLane_2Configuration_HHD_serdesLane_2ConfigurationReserved_1 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SerdesLane_3Configuration_HHD */
#define AQ_PhyXS_SerdesLane_3Configuration_HHD_baseRegisterAddress 0xC1F0
/*! \brief MMD address of structure AQ_PhyXS_SerdesLane_3Configuration_HHD */
#define AQ_PhyXS_SerdesLane_3Configuration_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_3ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_3Configuration_HHD */
#define AQ_PhyXS_SerdesLane_3Configuration_HHD_serdesLane_3ConfigurationReserved_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_3ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_3Configuration_HHD */
#define bits_AQ_PhyXS_SerdesLane_3Configuration_HHD_serdesLane_3ConfigurationReserved_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_3ConfigurationReserved_1 in AQ_PhyXS_SerdesLane_3Configuration_HHD */
#define word_AQ_PhyXS_SerdesLane_3Configuration_HHD_serdesLane_3ConfigurationReserved_1 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SerdesLut_HHD */
#define AQ_PhyXS_SerdesLut_HHD_baseRegisterAddress 0xC200
/*! \brief MMD address of structure AQ_PhyXS_SerdesLut_HHD */
#define AQ_PhyXS_SerdesLut_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure serdesLut_256Reserved in AQ_PhyXS_SerdesLut_HHD */
#define AQ_PhyXS_SerdesLut_HHD_serdesLut_256Reserved 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLut_256Reserved in AQ_PhyXS_SerdesLut_HHD */
#define bits_AQ_PhyXS_SerdesLut_HHD_serdesLut_256Reserved u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesLut_256Reserved in AQ_PhyXS_SerdesLut_HHD */
#define word_AQ_PhyXS_SerdesLut_HHD_serdesLut_256Reserved u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_baseRegisterAddress 0xC440
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioningC440 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioningC440 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioningC440 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioningC440 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioningC440 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioningC440 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure _50MhzPrimaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD__50MhzPrimaryOutputEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure _50MhzPrimaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD__50MhzPrimaryOutputEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure _50MhzPrimaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD__50MhzPrimaryOutputEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure _50MhzSecondaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD__50MhzSecondaryOutputEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure _50MhzSecondaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD__50MhzSecondaryOutputEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure _50MhzSecondaryOutputEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD__50MhzSecondaryOutputEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure serdesReset in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_serdesReset 0
/*! \brief Preprocessor variable to relate field to bit position in structure serdesReset in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_serdesReset u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure serdesReset in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_serdesReset u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemI_f10G_OperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f10G_OperatingMode 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemI_f10G_OperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f10G_OperatingMode u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemI_f10G_OperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f10G_OperatingMode u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemI_f_2500base_xEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f_2500base_xEnable 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemI_f_2500base_xEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f_2500base_xEnable u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemI_f_2500base_xEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f_2500base_xEnable u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemI_f1G_100M_OperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f1G_100M_OperatingMode 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemI_f1G_100M_OperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f1G_100M_OperatingMode u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemI_f1G_100M_OperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_f1G_100M_OperatingMode u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure sgmii1G_100M_AutonegEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_sgmii1G_100M_AutonegEnable 1
/*! \brief Preprocessor variable to relate field to bit position in structure sgmii1G_100M_AutonegEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_sgmii1G_100M_AutonegEnable u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure sgmii1G_100M_AutonegEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_sgmii1G_100M_AutonegEnable u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure ocsgmii_2_5gAutonegEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_ocsgmii_2_5gAutonegEnable 1
/*! \brief Preprocessor variable to relate field to bit position in structure ocsgmii_2_5gAutonegEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_ocsgmii_2_5gAutonegEnable u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure ocsgmii_2_5gAutonegEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_ocsgmii_2_5gAutonegEnable u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure phyOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_phyOperatingMode 1
/*! \brief Preprocessor variable to relate field to bit position in structure phyOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_phyOperatingMode u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure phyOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_phyOperatingMode u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure rxauiOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_rxauiOperatingMode 1
/*! \brief Preprocessor variable to relate field to bit position in structure rxauiOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_rxauiOperatingMode u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure rxauiOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_rxauiOperatingMode u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure enableKrTraining in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_enableKrTraining 1
/*! \brief Preprocessor variable to relate field to bit position in structure enableKrTraining in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_enableKrTraining u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure enableKrTraining in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_enableKrTraining u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure usxAutonegControlForMac in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_usxAutonegControlForMac 1
/*! \brief Preprocessor variable to relate field to bit position in structure usxAutonegControlForMac in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_usxAutonegControlForMac u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure usxAutonegControlForMac in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_usxAutonegControlForMac u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure backplaneAngEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_backplaneAngEnable 1
/*! \brief Preprocessor variable to relate field to bit position in structure backplaneAngEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_backplaneAngEnable u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure backplaneAngEnable in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_backplaneAngEnable u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure lookasidePortOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_lookasidePortOperatingMode 1
/*! \brief Preprocessor variable to relate field to bit position in structure lookasidePortOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_lookasidePortOperatingMode u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure lookasidePortOperatingMode in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_lookasidePortOperatingMode u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLane_3Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_3Serdes 2
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLane_3Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_3Serdes u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLane_3Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_3Serdes u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLane_2Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_2Serdes 2
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLane_2Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_2Serdes u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLane_2Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_2Serdes u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLane_1Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_1Serdes 2
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLane_1Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_1Serdes u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLane_1Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_1Serdes u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLane_0Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_0Serdes 2
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLane_0Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_0Serdes u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLane_0Serdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLane_0Serdes u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLaneInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLaneInvert 2
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLaneInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLaneInvert u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLaneInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_xauiRxLaneInvert u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure systemSgmiiRxSerdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemSgmiiRxSerdes 2
/*! \brief Preprocessor variable to relate field to bit position in structure systemSgmiiRxSerdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemSgmiiRxSerdes u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure systemSgmiiRxSerdes in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemSgmiiRxSerdes u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure systemSgmiiRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemSgmiiRxInvert 2
/*! \brief Preprocessor variable to relate field to bit position in structure systemSgmiiRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemSgmiiRxInvert u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure systemSgmiiRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemSgmiiRxInvert u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_4a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_4a 3
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_4a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_4a u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_4a in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_4a u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure systemKrRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemKrRxInvert 3
/*! \brief Preprocessor variable to relate field to bit position in structure systemKrRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemKrRxInvert u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure systemKrRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemKrRxInvert u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure lookasidePortRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_lookasidePortRxInvert 3
/*! \brief Preprocessor variable to relate field to bit position in structure lookasidePortRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_lookasidePortRxInvert u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure lookasidePortRxInvert in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_lookasidePortRxInvert u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_4 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_4 3
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_4 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_4 u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_4 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_4 u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure loopbackControl in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_loopbackControl 4
/*! \brief Preprocessor variable to relate field to bit position in structure loopbackControl in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_loopbackControl u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure loopbackControl in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_loopbackControl u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_5 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_5 4
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_5 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_5 u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_5 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_5 u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure mdiPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_mdiPacketGeneration 4
/*! \brief Preprocessor variable to relate field to bit position in structure mdiPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_mdiPacketGeneration u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure mdiPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_mdiPacketGeneration u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure look_asidePortPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_look_asidePortPacketGeneration 4
/*! \brief Preprocessor variable to relate field to bit position in structure look_asidePortPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_look_asidePortPacketGeneration u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure look_asidePortPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_look_asidePortPacketGeneration u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure systemI_fPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_fPacketGeneration 4
/*! \brief Preprocessor variable to relate field to bit position in structure systemI_fPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_fPacketGeneration u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure systemI_fPacketGeneration in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_systemI_fPacketGeneration u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure rate in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_rate 4
/*! \brief Preprocessor variable to relate field to bit position in structure rate in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_rate u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure rate in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_rate u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_6 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_6 5
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_6 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_6 u5.bits_5
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_6 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_6 u5.word_5
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_7 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_7 6
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_7 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_7 u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_7 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_7 u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostMinValue 6
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostMinValue u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostMinValue u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainMinValue 6
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainMinValue u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainMinValue u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpreMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreMinValue 6
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpreMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreMinValue u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpreMinValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreMinValue u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_8 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_8 7
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_8 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_8 u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_8 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_8 u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostMaxValue 7
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostMaxValue u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostMaxValue u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainMaxValue 7
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainMaxValue u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainMaxValue u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpreMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreMaxValue 7
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpreMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreMaxValue u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpreMaxValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreMaxValue u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_9 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_9 8
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_9 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_9 u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_9 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_9 u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostInitValue 8
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostInitValue u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostInitValue u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainInitValue 8
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainInitValue u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainInitValue u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpreInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreInitValue 8
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpreInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreInitValue u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpreInitValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpreInitValue u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_10 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_10 9
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_10 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_10 u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_10 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_10 u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCpostPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostPresetValue 9
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCpostPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostPresetValue u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCpostPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCpostPresetValue u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure krTrngMainPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainPresetValue 9
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngMainPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainPresetValue u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure krTrngMainPresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngMainPresetValue u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure krTrngCprePresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCprePresetValue 9
/*! \brief Preprocessor variable to relate field to bit position in structure krTrngCprePresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCprePresetValue u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure krTrngCprePresetValue in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krTrngCprePresetValue u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure reservedTransmitProvisioning_13 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_13 12
/*! \brief Preprocessor variable to relate field to bit position in structure reservedTransmitProvisioning_13 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_13 u12.bits_12
/*! \brief Preprocessor variable to relate field to word position in structure reservedTransmitProvisioning_13 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_reservedTransmitProvisioning_13 u12.word_12
/*! \brief Preprocessor variable to relate field to word number in structure krPmdTrainingState in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krPmdTrainingState 12
/*! \brief Preprocessor variable to relate field to bit position in structure krPmdTrainingState in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krPmdTrainingState u12.bits_12
/*! \brief Preprocessor variable to relate field to word position in structure krPmdTrainingState in AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorProvisioning_HHD_krPmdTrainingState u12.word_12

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_baseRegisterAddress 0xC802
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure txFrameCounterLSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameCounterLSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure txFrameCounterLSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameCounterLSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txFrameCounterLSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameCounterLSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure txFrameCounterMSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameCounterMSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure txFrameCounterMSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameCounterMSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure txFrameCounterMSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameCounterMSW u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure txFrameErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameErrorCounterLSW 2
/*! \brief Preprocessor variable to relate field to bit position in structure txFrameErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameErrorCounterLSW u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure txFrameErrorCounterLSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameErrorCounterLSW u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure txFrameErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameErrorCounterMSW 3
/*! \brief Preprocessor variable to relate field to bit position in structure txFrameErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameErrorCounterMSW u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure txFrameErrorCounterMSW in AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_PcsStatus_HHD_txFrameErrorCounterMSW u3.word_3

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_baseRegisterAddress 0xC820
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure numbersOfSerdesCals in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numbersOfSerdesCals 0
/*! \brief Preprocessor variable to relate field to bit position in structure numbersOfSerdesCals in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numbersOfSerdesCals u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure numbersOfSerdesCals in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numbersOfSerdesCals u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure numberOfSifBlockLockTranstitions_1__0 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifBlockLockTranstitions_1__0 1
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfSifBlockLockTranstitions_1__0 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifBlockLockTranstitions_1__0 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure numberOfSifBlockLockTranstitions_1__0 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifBlockLockTranstitions_1__0 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure numberOfSifBlockLockTranstitions_0__1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifBlockLockTranstitions_0__1 1
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfSifBlockLockTranstitions_0__1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifBlockLockTranstitions_0__1 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure numberOfSifBlockLockTranstitions_0__1 in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifBlockLockTranstitions_0__1 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure numberOfSifXgsSwitch_overs in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifXgsSwitch_overs 2
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfSifXgsSwitch_overs in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifXgsSwitch_overs u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure numberOfSifXgsSwitch_overs in AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_ReservedVendorState_HHD_numberOfSifXgsSwitch_overs u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_baseRegisterAddress 0xCC00
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure crpatTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_crpatTestPatternCheckerSyncError 0
/*! \brief Preprocessor variable to relate field to bit position in structure crpatTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_crpatTestPatternCheckerSyncError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure crpatTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_crpatTestPatternCheckerSyncError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure prbsTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_prbsTestPatternCheckerSyncError 0
/*! \brief Preprocessor variable to relate field to bit position in structure prbsTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_prbsTestPatternCheckerSyncError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure prbsTestPatternCheckerSyncError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_prbsTestPatternCheckerSyncError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure macsecEgressInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_macsecEgressInterrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecEgressInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_macsecEgressInterrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecEgressInterrupt in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_macsecEgressInterrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxSequenceOrderedSetDeletion in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxSequenceOrderedSetDeletion 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxSequenceOrderedSetDeletion in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxSequenceOrderedSetDeletion u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxSequenceOrderedSetDeletion in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxSequenceOrderedSetDeletion u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLaneAlignmentLockStatus in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxLaneAlignmentLockStatus 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLaneAlignmentLockStatus in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxLaneAlignmentLockStatus u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLaneAlignmentLockStatus in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxLaneAlignmentLockStatus u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxReservedXgmiiCharacterReceived in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxReservedXgmiiCharacterReceived 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxReservedXgmiiCharacterReceived in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxReservedXgmiiCharacterReceived u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxReservedXgmiiCharacterReceived in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxReservedXgmiiCharacterReceived u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxInvalidXgmiiCharacterReceived in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxInvalidXgmiiCharacterReceived 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxInvalidXgmiiCharacterReceived in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxInvalidXgmiiCharacterReceived u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxInvalidXgmiiCharacterReceived in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxInvalidXgmiiCharacterReceived u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxCodeViolationError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxCodeViolationError 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxCodeViolationError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxCodeViolationError u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxCodeViolationError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxCodeViolationError u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxRunningDisparityError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxRunningDisparityError 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxRunningDisparityError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxRunningDisparityError u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxRunningDisparityError in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_xauiRxRunningDisparityError u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure lossOfSignal in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_lossOfSignal 2
/*! \brief Preprocessor variable to relate field to bit position in structure lossOfSignal in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_lossOfSignal u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure lossOfSignal in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_lossOfSignal u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsTransmitAlarms in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_reservedPhyXsTransmitAlarms 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsTransmitAlarms in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_reservedPhyXsTransmitAlarms u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsTransmitAlarms in AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorAlarms_HHD_reservedPhyXsTransmitAlarms u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_baseRegisterAddress 0xD000
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure txLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_txLpiReceivedMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure txLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_txLpiReceivedMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_txLpiReceivedMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_rxLpiReceivedMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_rxLpiReceivedMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLpiReceivedMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_rxLpiReceivedMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_TransmitLinkAlignmentStatusMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_phyXS_TransmitLinkAlignmentStatusMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_TransmitLinkAlignmentStatusMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_phyXS_TransmitLinkAlignmentStatusMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_TransmitLinkAlignmentStatusMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_phyXS_TransmitLinkAlignmentStatusMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure transmitFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_transmitFaultMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure transmitFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_transmitFaultMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure transmitFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_transmitFaultMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure receiveFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_receiveFaultMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure receiveFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_receiveFaultMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure receiveFaultMask in AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_StandardInterruptMask_HHD_receiveFaultMask u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_baseRegisterAddress 0xD400
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure crpatTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_crpatTestPatternCheckerSyncErrorMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure crpatTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_crpatTestPatternCheckerSyncErrorMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure crpatTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_crpatTestPatternCheckerSyncErrorMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure prbsTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_prbsTestPatternCheckerSyncErrorMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure prbsTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_prbsTestPatternCheckerSyncErrorMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure prbsTestPatternCheckerSyncErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_prbsTestPatternCheckerSyncErrorMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure macsecEgressInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_macsecEgressInterruptMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecEgressInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_macsecEgressInterruptMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecEgressInterruptMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_macsecEgressInterruptMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxSequenceOrderedSetDeletionMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxSequenceOrderedSetDeletionMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxSequenceOrderedSetDeletionMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxSequenceOrderedSetDeletionMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxSequenceOrderedSetDeletionMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxSequenceOrderedSetDeletionMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLaneAlignmentLockStatusMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxLaneAlignmentLockStatusMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLaneAlignmentLockStatusMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxLaneAlignmentLockStatusMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLaneAlignmentLockStatusMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxLaneAlignmentLockStatusMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxReservedXgmiiCharacterReceivedMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxReservedXgmiiCharacterReceivedMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxReservedXgmiiCharacterReceivedMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxReservedXgmiiCharacterReceivedMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxReservedXgmiiCharacterReceivedMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxReservedXgmiiCharacterReceivedMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxInvalidXgmiiCharacterReceivedMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxInvalidXgmiiCharacterReceivedMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxInvalidXgmiiCharacterReceivedMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxInvalidXgmiiCharacterReceivedMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxInvalidXgmiiCharacterReceivedMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxInvalidXgmiiCharacterReceivedMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxCodeViolationErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxCodeViolationErrorMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxCodeViolationErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxCodeViolationErrorMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxCodeViolationErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxCodeViolationErrorMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxRunningDisparityErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxRunningDisparityErrorMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxRunningDisparityErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxRunningDisparityErrorMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxRunningDisparityErrorMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_xauiRxRunningDisparityErrorMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure lossOfSignalMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_lossOfSignalMask 2
/*! \brief Preprocessor variable to relate field to bit position in structure lossOfSignalMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_lossOfSignalMask u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure lossOfSignalMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_lossOfSignalMask u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsTransmitAlarmsMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_reservedPhyXsTransmitAlarmsMask 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsTransmitAlarmsMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_reservedPhyXsTransmitAlarmsMask u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsTransmitAlarmsMask in AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorInterruptMask_HHD_reservedPhyXsTransmitAlarmsMask u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_baseRegisterAddress 0xD800
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure testPatternForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternForceError 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternForceError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternForceError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternMode_7ForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternMode_7ForceError 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternMode_7ForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternMode_7ForceError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternMode_7ForceError in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternMode_7ForceError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiRxLocalFaultInjection in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_xauiRxLocalFaultInjection 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiRxLocalFaultInjection in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_xauiRxLocalFaultInjection u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiRxLocalFaultInjection in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_xauiRxLocalFaultInjection u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure test_patternExtendedSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_test_patternExtendedSelect 0
/*! \brief Preprocessor variable to relate field to bit position in structure test_patternExtendedSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_test_patternExtendedSelect u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure test_patternExtendedSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_test_patternExtendedSelect u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternCheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternCheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternCheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternCheckPoint in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckPoint 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternCheckPoint in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckPoint u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternCheckPoint in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckPoint u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternMode_7CheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternMode_7CheckEnable 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternMode_7CheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternMode_7CheckEnable u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternMode_7CheckEnable in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternMode_7CheckEnable u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternInvert in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternInvert 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternInvert in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternInvert u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternInvert in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternInvert u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternSynchronizationThreshold in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternSynchronizationThreshold 0
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternSynchronizationThreshold in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternSynchronizationThreshold u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure testPatternSynchronizationThreshold in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternSynchronizationThreshold u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure testPatternInsertExtraIdles in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternInsertExtraIdles 1
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternInsertExtraIdles in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternInsertExtraIdles u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure testPatternInsertExtraIdles in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternInsertExtraIdles u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure testPatternCheckSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckSelect 1
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternCheckSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckSelect u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure testPatternCheckSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternCheckSelect u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure testPatternChannelSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternChannelSelect 1
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternChannelSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternChannelSelect u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure testPatternChannelSelect in AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_VendorDebug_HHD_testPatternChannelSelect u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_baseRegisterAddress 0xD810
/*! \brief MMD address of structure AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure channel_0TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_0TestPatternErrorCounter 0
/*! \brief Preprocessor variable to relate field to bit position in structure channel_0TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_0TestPatternErrorCounter u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure channel_0TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_0TestPatternErrorCounter u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure channel_1TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_1TestPatternErrorCounter 1
/*! \brief Preprocessor variable to relate field to bit position in structure channel_1TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_1TestPatternErrorCounter u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure channel_1TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_1TestPatternErrorCounter u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure channel_2TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_2TestPatternErrorCounter 2
/*! \brief Preprocessor variable to relate field to bit position in structure channel_2TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_2TestPatternErrorCounter u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure channel_2TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_2TestPatternErrorCounter u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure channel_3TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_3TestPatternErrorCounter 3
/*! \brief Preprocessor variable to relate field to bit position in structure channel_3TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_3TestPatternErrorCounter u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure channel_3TestPatternErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_channel_3TestPatternErrorCounter u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure testPatternMode_7ErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_testPatternMode_7ErrorCounter 4
/*! \brief Preprocessor variable to relate field to bit position in structure testPatternMode_7ErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define bits_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_testPatternMode_7ErrorCounter u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure testPatternMode_7ErrorCounter in AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD */
#define word_AQ_PhyXS_Transmit_xauiRx_TestPatternErrorCounter_HHD_testPatternMode_7ErrorCounter u4.word_4

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_baseRegisterAddress 0xE410
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxLane_3Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_3Serdes 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxLane_3Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_3Serdes u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxLane_3Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_3Serdes u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxLane_2Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_2Serdes 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxLane_2Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_2Serdes u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxLane_2Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_2Serdes u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxLane_1Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_1Serdes 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxLane_1Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_1Serdes u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxLane_1Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_1Serdes u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxLane_0Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_0Serdes 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxLane_0Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_0Serdes u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxLane_0Serdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLane_0Serdes u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxLaneInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLaneInvert 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxLaneInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLaneInvert u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxLaneInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_xauiTxLaneInvert u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemSgmiiTxSerdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemSgmiiTxSerdes 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemSgmiiTxSerdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemSgmiiTxSerdes u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemSgmiiTxSerdes in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemSgmiiTxSerdes u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemSgmiiTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemSgmiiTxInvert 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemSgmiiTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemSgmiiTxInvert u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemSgmiiTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemSgmiiTxInvert u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_1 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_1 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_1 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_2a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_2a 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_2a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_2a u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_2a in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_2a u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemKrTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemKrTxInvert 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemKrTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemKrTxInvert u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemKrTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_systemKrTxInvert u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure lookasidePortTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_lookasidePortTxInvert 1
/*! \brief Preprocessor variable to relate field to bit position in structure lookasidePortTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_lookasidePortTxInvert u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure lookasidePortTxInvert in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_lookasidePortTxInvert u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure applySerdesTxSettings in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_applySerdesTxSettings 1
/*! \brief Preprocessor variable to relate field to bit position in structure applySerdesTxSettings in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_applySerdesTxSettings u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure applySerdesTxSettings in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_applySerdesTxSettings u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveProvisioning_2 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_2 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveProvisioning_2 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_2 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveProvisioning_2 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedReceiveProvisioning_2 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_3 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_3 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_3 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_3 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_3 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_3 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0PostTap_1 2
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0PostTap_1 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0PostTap_1 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0PreTap 2
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0PreTap u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0PreTap u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0MainTap 2
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0MainTap u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0MainTap u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_4 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_4 3
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_4 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_4 u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_4 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_4 u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_0Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0Amplitude 3
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_0Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0Amplitude u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_0Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_0Amplitude u3.word_3
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_5 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_5 4
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_5 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_5 u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_5 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_5 u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_1PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1PostTap_1 4
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_1PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1PostTap_1 u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_1PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1PostTap_1 u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_1PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1PreTap 4
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_1PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1PreTap u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_1PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1PreTap u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_1MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1MainTap 4
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_1MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1MainTap u4.bits_4
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_1MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1MainTap u4.word_4
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_6 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_6 5
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_6 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_6 u5.bits_5
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_6 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_6 u5.word_5
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_1Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1Amplitude 5
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_1Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1Amplitude u5.bits_5
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_1Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_1Amplitude u5.word_5
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_7 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_7 6
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_7 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_7 u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_7 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_7 u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_2PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2PostTap_1 6
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_2PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2PostTap_1 u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_2PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2PostTap_1 u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_2PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2PreTap 6
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_2PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2PreTap u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_2PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2PreTap u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_2MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2MainTap 6
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_2MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2MainTap u6.bits_6
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_2MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2MainTap u6.word_6
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_8 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_8 7
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_8 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_8 u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_8 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_8 u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_2Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2Amplitude 7
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_2Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2Amplitude u7.bits_7
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_2Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_2Amplitude u7.word_7
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_9 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_9 8
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_9 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_9 u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_9 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_9 u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_3PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3PostTap_1 8
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_3PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3PostTap_1 u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_3PostTap_1 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3PostTap_1 u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_3PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3PreTap 8
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_3PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3PreTap u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_3PreTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3PreTap u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_3MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3MainTap 8
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_3MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3MainTap u8.bits_8
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_3MainTap in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3MainTap u8.word_8
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_10 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_10 9
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_10 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_10 u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_10 in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_reservedRxProvisioning_10 u9.word_9
/*! \brief Preprocessor variable to relate field to word number in structure serdesLane_3Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3Amplitude 9
/*! \brief Preprocessor variable to relate field to bit position in structure serdesLane_3Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3Amplitude u9.bits_9
/*! \brief Preprocessor variable to relate field to word position in structure serdesLane_3Amplitude in AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorProvisioning_HHD_serdesLane_3Amplitude u9.word_9

/*! \brief Base register address of structure AQ_PifMailboxExtra_HHD */
#define AQ_PifMailboxExtra_HHD_baseRegisterAddress 0xE41D
/*! \brief MMD address of structure AQ_PifMailboxExtra_HHD */
#define AQ_PifMailboxExtra_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure pifMailboxAddressRegister_2 in AQ_PifMailboxExtra_HHD */
#define AQ_PifMailboxExtra_HHD_pifMailboxAddressRegister_2 0
/*! \brief Preprocessor variable to relate field to bit position in structure pifMailboxAddressRegister_2 in AQ_PifMailboxExtra_HHD */
#define bits_AQ_PifMailboxExtra_HHD_pifMailboxAddressRegister_2 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure pifMailboxAddressRegister_2 in AQ_PifMailboxExtra_HHD */
#define word_AQ_PifMailboxExtra_HHD_pifMailboxAddressRegister_2 u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure pifMailboxDataRegister_2 in AQ_PifMailboxExtra_HHD */
#define AQ_PifMailboxExtra_HHD_pifMailboxDataRegister_2 1
/*! \brief Preprocessor variable to relate field to bit position in structure pifMailboxDataRegister_2 in AQ_PifMailboxExtra_HHD */
#define bits_AQ_PifMailboxExtra_HHD_pifMailboxDataRegister_2 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure pifMailboxDataRegister_2 in AQ_PifMailboxExtra_HHD */
#define word_AQ_PifMailboxExtra_HHD_pifMailboxDataRegister_2 u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedRxProvisioning_16 in AQ_PifMailboxExtra_HHD */
#define AQ_PifMailboxExtra_HHD_reservedRxProvisioning_16 2
/*! \brief Preprocessor variable to relate field to bit position in structure reservedRxProvisioning_16 in AQ_PifMailboxExtra_HHD */
#define bits_AQ_PifMailboxExtra_HHD_reservedRxProvisioning_16 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reservedRxProvisioning_16 in AQ_PifMailboxExtra_HHD */
#define word_AQ_PifMailboxExtra_HHD_reservedRxProvisioning_16 u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure pifMailboxMMD_Register_2 in AQ_PifMailboxExtra_HHD */
#define AQ_PifMailboxExtra_HHD_pifMailboxMMD_Register_2 2
/*! \brief Preprocessor variable to relate field to bit position in structure pifMailboxMMD_Register_2 in AQ_PifMailboxExtra_HHD */
#define bits_AQ_PifMailboxExtra_HHD_pifMailboxMMD_Register_2 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure pifMailboxMMD_Register_2 in AQ_PifMailboxExtra_HHD */
#define word_AQ_PifMailboxExtra_HHD_pifMailboxMMD_Register_2 u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_baseRegisterAddress 0xE802
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure rxFrameCounterLSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameCounterLSW 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxFrameCounterLSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameCounterLSW u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxFrameCounterLSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameCounterLSW u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxFrameCounterMSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameCounterMSW 1
/*! \brief Preprocessor variable to relate field to bit position in structure rxFrameCounterMSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameCounterMSW u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure rxFrameCounterMSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameCounterMSW u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure rxFrameErrorCounterLSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameErrorCounterLSW 2
/*! \brief Preprocessor variable to relate field to bit position in structure rxFrameErrorCounterLSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameErrorCounterLSW u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure rxFrameErrorCounterLSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameErrorCounterLSW u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure rxFrameErrorCounterMSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameErrorCounterMSW 3
/*! \brief Preprocessor variable to relate field to bit position in structure rxFrameErrorCounterMSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameErrorCounterMSW u3.bits_3
/*! \brief Preprocessor variable to relate field to word position in structure rxFrameErrorCounterMSW in AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_PcsStatus_HHD_rxFrameErrorCounterMSW u3.word_3

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD_baseRegisterAddress 0xE810
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure numberOfUsxAnegRestarts in AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD */
#define AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD_numberOfUsxAnegRestarts 0
/*! \brief Preprocessor variable to relate field to bit position in structure numberOfUsxAnegRestarts in AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD_numberOfUsxAnegRestarts u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure numberOfUsxAnegRestarts in AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_ReservedVendorState_HHD_numberOfUsxAnegRestarts u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_baseRegisterAddress 0xE812
/*! \brief MMD address of structure AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceAutonegStatus in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceAutonegStatus 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceAutonegStatus in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceAutonegStatus u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceAutonegStatus in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceAutonegStatus u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure rxLinkUp in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_rxLinkUp 0
/*! \brief Preprocessor variable to relate field to bit position in structure rxLinkUp in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_rxLinkUp u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure rxLinkUp in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_rxLinkUp u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure txReady in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_txReady 0
/*! \brief Preprocessor variable to relate field to bit position in structure txReady in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_txReady u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure txReady in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_txReady u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRate in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceRate 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRate in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceRate u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRate in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceRate u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceInUse in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceInUse 0
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceInUse in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceInUse u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceInUse in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_systemInterfaceInUse u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure reservedReceiveState_3 in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_reservedReceiveState_3 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedReceiveState_3 in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define bits_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_reservedReceiveState_3 u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedReceiveState_3 in AQ_PhyXS_SystemInterfaceConnectionStatus_HHD */
#define word_AQ_PhyXS_SystemInterfaceConnectionStatus_HHD_reservedReceiveState_3 u0.word_0

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_baseRegisterAddress 0xEC00
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reservedXgmiiCharacterReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_reservedXgmiiCharacterReceivedFromPcs 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedXgmiiCharacterReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_reservedXgmiiCharacterReceivedFromPcs u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedXgmiiCharacterReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_reservedXgmiiCharacterReceivedFromPcs u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure invalidXgmiiCharacterReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_invalidXgmiiCharacterReceivedFromPcs 0
/*! \brief Preprocessor variable to relate field to bit position in structure invalidXgmiiCharacterReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_invalidXgmiiCharacterReceivedFromPcs u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure invalidXgmiiCharacterReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_invalidXgmiiCharacterReceivedFromPcs u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure linkStatusMessageReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_linkStatusMessageReceivedFromPcs 0
/*! \brief Preprocessor variable to relate field to bit position in structure linkStatusMessageReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_linkStatusMessageReceivedFromPcs u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure linkStatusMessageReceivedFromPcs in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_linkStatusMessageReceivedFromPcs u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure macsecIngressInterrupt in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_macsecIngressInterrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecIngressInterrupt in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_macsecIngressInterrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecIngressInterrupt in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_macsecIngressInterrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkUp in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceRxLinkUp 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkUp in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceRxLinkUp u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkUp in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceRxLinkUp u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkDown in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceRxLinkDown 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkDown in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceRxLinkDown u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkDown in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceRxLinkDown u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceTxReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceTxReady 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceTxReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceTxReady u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceTxReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceTxReady u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceTxNotReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceTxNotReady 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceTxNotReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceTxNotReady u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceTxNotReady in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_systemInterfaceTxNotReady u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsReceiveAlarms_2 in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_reservedPhyXsReceiveAlarms_2 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsReceiveAlarms_2 in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_reservedPhyXsReceiveAlarms_2 u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsReceiveAlarms_2 in AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorAlarms_HHD_reservedPhyXsReceiveAlarms_2 u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_baseRegisterAddress 0xF400
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure reservedXgmiiCharacterReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_reservedXgmiiCharacterReceivedFromPcsMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure reservedXgmiiCharacterReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_reservedXgmiiCharacterReceivedFromPcsMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure reservedXgmiiCharacterReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_reservedXgmiiCharacterReceivedFromPcsMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure invalidXgmiiCharacterReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_invalidXgmiiCharacterReceivedFromPcsMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure invalidXgmiiCharacterReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_invalidXgmiiCharacterReceivedFromPcsMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure invalidXgmiiCharacterReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_invalidXgmiiCharacterReceivedFromPcsMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure linkStatusMessageReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_linkStatusMessageReceivedFromPcsMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure linkStatusMessageReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_linkStatusMessageReceivedFromPcsMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure linkStatusMessageReceivedFromPcsMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_linkStatusMessageReceivedFromPcsMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure macsecIngressInterruptMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_macsecIngressInterruptMask 0
/*! \brief Preprocessor variable to relate field to bit position in structure macsecIngressInterruptMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_macsecIngressInterruptMask u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure macsecIngressInterruptMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_macsecIngressInterruptMask u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkUpMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceRxLinkUpMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkUpMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceRxLinkUpMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkUpMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceRxLinkUpMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceRxLinkDownMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceRxLinkDownMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceRxLinkDownMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceRxLinkDownMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceRxLinkDownMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceRxLinkDownMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceTxReadyMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceTxReadyMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceTxReadyMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceTxReadyMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceTxReadyMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceTxReadyMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure systemInterfaceTxNotReadyMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceTxNotReadyMask 1
/*! \brief Preprocessor variable to relate field to bit position in structure systemInterfaceTxNotReadyMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceTxNotReadyMask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure systemInterfaceTxNotReadyMask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_systemInterfaceTxNotReadyMask u1.word_1
/*! \brief Preprocessor variable to relate field to word number in structure reservedPhyXsReceiveAlarms_2Mask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_reservedPhyXsReceiveAlarms_2Mask 1
/*! \brief Preprocessor variable to relate field to bit position in structure reservedPhyXsReceiveAlarms_2Mask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_reservedPhyXsReceiveAlarms_2Mask u1.bits_1
/*! \brief Preprocessor variable to relate field to word position in structure reservedPhyXsReceiveAlarms_2Mask in AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorInterruptMask_HHD_reservedPhyXsReceiveAlarms_2Mask u1.word_1

/*! \brief Base register address of structure AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_baseRegisterAddress 0xF800
/*! \brief MMD address of structure AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxErrorInjectionLaneSelect in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxErrorInjectionLaneSelect 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxErrorInjectionLaneSelect in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxErrorInjectionLaneSelect u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxErrorInjectionLaneSelect in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxErrorInjectionLaneSelect u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxInjectSynchronizationError in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectSynchronizationError 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxInjectSynchronizationError in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectSynchronizationError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxInjectSynchronizationError in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectSynchronizationError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxInjectAlignmentError in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectAlignmentError 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxInjectAlignmentError in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectAlignmentError u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxInjectAlignmentError in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectAlignmentError u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxInjectCodeViolation in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectCodeViolation 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxInjectCodeViolation in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectCodeViolation u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxInjectCodeViolation in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxInjectCodeViolation u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure xauiTx_10bViolationCodeword in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTx_10bViolationCodeword 0
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTx_10bViolationCodeword in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTx_10bViolationCodeword u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure xauiTx_10bViolationCodeword in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTx_10bViolationCodeword u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_SystemLoopbackPassThrough in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_phyXS_SystemLoopbackPassThrough 2
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_SystemLoopbackPassThrough in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_phyXS_SystemLoopbackPassThrough u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_SystemLoopbackPassThrough in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_phyXS_SystemLoopbackPassThrough u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure phyXS_SystemLoopbackEnable in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_phyXS_SystemLoopbackEnable 2
/*! \brief Preprocessor variable to relate field to bit position in structure phyXS_SystemLoopbackEnable in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_phyXS_SystemLoopbackEnable u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure phyXS_SystemLoopbackEnable in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_phyXS_SystemLoopbackEnable u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure xauiTxLocalFaultInjection in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxLocalFaultInjection 2
/*! \brief Preprocessor variable to relate field to bit position in structure xauiTxLocalFaultInjection in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxLocalFaultInjection u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure xauiTxLocalFaultInjection in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_xauiTxLocalFaultInjection u2.word_2
/*! \brief Preprocessor variable to relate field to word number in structure reserved_4 in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_reserved_4 2
/*! \brief Preprocessor variable to relate field to bit position in structure reserved_4 in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define bits_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_reserved_4 u2.bits_2
/*! \brief Preprocessor variable to relate field to word position in structure reserved_4 in AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD */
#define word_AQ_PhyXS_Receive_xauiTx_VendorDebug_HHD_reserved_4 u2.word_2

/*! \brief Base register address of structure AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_baseRegisterAddress 0xFC00
/*! \brief MMD address of structure AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_mmdAddress 0x04
/*! \brief Preprocessor variable to relate field to word number in structure standardAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_standardAlarms_1Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure standardAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_standardAlarms_1Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure standardAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_standardAlarms_1Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure standardAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_standardAlarms_2Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure standardAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_standardAlarms_2Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure standardAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_standardAlarms_2Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificTxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_1Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificTxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_1Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificTxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_1Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificTxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_2Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificTxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_2Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificTxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_2Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificTxAlarms_3Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_3Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificTxAlarms_3Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_3Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificTxAlarms_3Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificTxAlarms_3Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificRxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificRxAlarms_1Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificRxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificRxAlarms_1Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificRxAlarms_1Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificRxAlarms_1Interrupt u0.word_0
/*! \brief Preprocessor variable to relate field to word number in structure vendorSpecificRxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificRxAlarms_2Interrupt 0
/*! \brief Preprocessor variable to relate field to bit position in structure vendorSpecificRxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define bits_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificRxAlarms_2Interrupt u0.bits_0
/*! \brief Preprocessor variable to relate field to word position in structure vendorSpecificRxAlarms_2Interrupt in AQ_PhyXS_VendorGlobalInterruptFlags_HHD */
#define word_AQ_PhyXS_VendorGlobalInterruptFlags_HHD_vendorSpecificRxAlarms_2Interrupt u0.word_0
#endif
/*@}*/
/*@}*/
