#ifndef _RTL8367C_BASE_H_
#define _RTL8367C_BASE_H_

#include "rtl8367c_reg.h"

/* (16'h0000) port_reg */

#define    RTL8367C_PORT_SPECIAL_CONGEST_MODE_TIMER_BASE        RTL8367C_REG_PKTGEN_PORT0_TIMER
#define    RTL8367C_PORT_SPECIAL_CONGEST_MODE_TIMER_REG(port)    (RTL8367C_PORT_SPECIAL_CONGEST_MODE_TIMER_BASE + (port << 5))

#define    RTL8367C_PORT_MISC_CFG_BASE                            RTL8367C_REG_PORT0_MISC_CFG
#define    RTL8367C_PORT_MISC_CFG_REG(port)                        (RTL8367C_PORT_MISC_CFG_BASE + (port << 5))
#define    RTL8367C_1QREMARK_ENABLE_OFFSET                         RTL8367C_PORT0_MISC_CFG_DOT1Q_REMARK_ENABLE_OFFSET
#define    RTL8367C_1QREMARK_ENABLE_MASK                        RTL8367C_PORT0_MISC_CFG_DOT1Q_REMARK_ENABLE_MASK

#define    RTL8367C_INGRESSBW_PORT_IFG_MASK                        RTL8367C_PORT0_MISC_CFG_INGRESSBW_IFG_MASK
#define    RTL8367C_VLAN_EGRESS_MDOE_MASK                        RTL8367C_PORT0_MISC_CFG_VLAN_EGRESS_MODE_MASK
#define    RTL8367C_SPECIALCONGEST_SUSTAIN_TIMER_MASK            RTL8367C_PORT0_MISC_CFG_CONGESTION_SUSTAIN_TIME_MASK

#define    RTL8367C_INGRESSBW_PORT_RATE_LSB_BASE                RTL8367C_REG_INGRESSBW_PORT0_RATE_CTRL0
#define    RTL8367C_INGRESSBW_PORT_RATE_LSB_REG(port)            (RTL8367C_INGRESSBW_PORT_RATE_LSB_BASE + (port << 5))

#define    RTL8367C_PORT_SMALL_IPG_REG(port)                    (RTL8367C_REG_PORT0_MISC_CFG + (port*0x20))

#define    RTL8367C_PORT_EEE_CFG_BASE                           RTL8367C_REG_PORT0_EEECFG
#define    RTL8367C_PORT_EEE_CFG_REG(port)                      (RTL8367C_REG_PORT0_EEECFG + (port << 5))
#define    RTL8367C_PORT_EEE_100M_OFFSET                        RTL8367C_PORT0_EEECFG_EEE_100M_OFFSET
#define    RTL8367C_PORT_EEE_100M_MASK                          RTL8367C_PORT0_EEECFG_EEE_100M_MASK
#define    RTL8367C_PORT_EEE_GIGA_OFFSET                        RTL8367C_PORT0_EEECFG_EEE_GIGA_500M_OFFSET
#define    RTL8367C_PORT_EEE_GIGA_MASK                          RTL8367C_PORT0_EEECFG_EEE_GIGA_500M_MASK


/* (16'h0200) outq_reg */

#define    RTL8367C_FLOWCTRL_QUEUE_DROP_ON_BASE                    RTL8367C_REG_FLOWCTRL_QUEUE0_DROP_ON
#define    RTL8367C_FLOWCTRL_QUEUE_DROP_ON_REG(queue)            (RTL8367C_FLOWCTRL_QUEUE_DROP_ON_BASE + queue)
#define    RTL8367C_FLOWCTRL_QUEUE_DROP_ON_MASK                    RTL8367C_FLOWCTRL_QUEUE0_DROP_ON_MASK

#define    RTL8367C_FLOWCTRL_PORT_DROP_ON_BASE                    RTL8367C_REG_FLOWCTRL_PORT0_DROP_ON
#define    RTL8367C_FLOWCTRL_PORT_DROP_ON_REG(PORT)                (RTL8367C_FLOWCTRL_PORT_DROP_ON_BASE + PORT)
#define    RTL8367C_FLOWCTRL_PORT_DROP_ON_MASK                    RTL8367C_FLOWCTRL_PORT0_DROP_ON_MASK

#define    RTL8367C_FLOWCTRL_PORT_GAP_REG                        RTL8367C_REG_FLOWCTRL_PORT_GAP
#define    RTL8367C_FLOWCTRL_QUEUE_GAP_REG                        RTL8367C_REG_FLOWCTRL_QUEUE_GAP
#define    RTL8367C_FLOWCTRL_PORT_QEMPTY_REG                    RTL8367C_REG_PORT_QEMPTY

/* (16'h0300) sch_reg */

#define    RTL8367C_SCHEDULE_WFQ_BURST_SIZE_REG                    RTL8367C_REG_SCHEDULE_WFQ_BURST_SIZE

#define    RTL8367C_SCHEDULE_QUEUE_TYPE_BASE                    RTL8367C_REG_SCHEDULE_QUEUE_TYPE_CTRL0
#define    RTL8367C_SCHEDULE_QUEUE_TYPE_REG(port)                (RTL8367C_SCHEDULE_QUEUE_TYPE_BASE + (port >> 1))
#define    RTL8367C_SCHEDULE_QUEUE_TYPE_OFFSET(port, queue)        (((port & 0x1) << 3) + queue)
#define    RTL8367C_SCHEDULE_QUEUE_TYPE_MASK(port, queue)         RTL8367C_SCHEDULE_QUEUE_TYPE_OFFSET(port, queue)

#define    RTL8367C_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_BASE            RTL8367C_REG_SCHEDULE_PORT0_QUEUE0_WFQ_WEIGHT
#define    RTL8367C_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_REG(port, queue)    (RTL8367C_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_BASE + (port << 3) + queue)

#define    RTL8367C_SCHEDULE_APR_CTRL_REG                       RTL8367C_REG_SCHEDULE_APR_CTRL0
#define    RTL8367C_SCHEDULE_APR_CTRL_OFFSET(port)                (port)
#define    RTL8367C_SCHEDULE_APR_CTRL_MASK(port)                (1 << RTL8367C_SCHEDULE_APR_CTRL_OFFSET(port))

#define    RTL8367C_SCHEDULE_PORT_APR_METER_BASE                RTL8367C_REG_SCHEDULE_PORT0_APR_METER_CTRL0
#define    RTL8367C_SCHEDULE_PORT_APR_METER_REG(port, queue)    (RTL8367C_SCHEDULE_PORT_APR_METER_BASE + (port << 2) + (queue / 5))
#define    RTL8367C_SCHEDULE_PORT_APR_METER_OFFSET(queue)        (3 * (queue % 5))
#define    RTL8367C_SCHEDULE_PORT_APR_METER_MASK(queue)            (RTL8367C_SCHEDULE_PORT0_APR_METER_CTRL0_QUEUE0_APR_METER_MASK << RTL8367C_SCHEDULE_PORT_APR_METER_OFFSET(queue))

#define    RTL8367C_PORT_EGRESSBW_LSB_BASE                        RTL8367C_REG_PORT0_EGRESSBW_CTRL0
#define    RTL8367C_PORT_EGRESSBW_LSB_REG(port)                    (RTL8367C_PORT_EGRESSBW_LSB_BASE + (port << 1))

#define    RTL8367C_PORT_EGRESSBW_MSB_BASE                        RTL8367C_REG_PORT0_EGRESSBW_CTRL1
#define    RTL8367C_PORT_EGRESSBW_MSB_REG(port)                    (RTL8367C_PORT_EGRESSBW_MSB_BASE + (port << 1))

/* (16'h0500) table_reg */

#define    RTL8367C_TABLE_ACCESS_CTRL_REG                        RTL8367C_REG_TABLE_ACCESS_CTRL

#define    RTL8367C_TABLE_ACCESS_ADDR_REG                        RTL8367C_REG_TABLE_ACCESS_ADDR

#define    RTL8367C_TABLE_ACCESS_STATUS_REG                        RTL8367C_REG_TABLE_LUT_ADDR

#define    RTL8367C_TABLE_ACCESS_WRDATA_BASE                    RTL8367C_REG_TABLE_WRITE_DATA0
#define    RTL8367C_TABLE_ACCESS_WRDATA_REG(index)                (RTL8367C_TABLE_ACCESS_WRDATA_BASE + index)

#define    RTL8367C_TABLE_ACCESS_RDDATA_BASE                    RTL8367C_REG_TABLE_READ_DATA0
#define    RTL8367C_TABLE_ACCESS_RDDATA_REG(index)                (RTL8367C_TABLE_ACCESS_RDDATA_BASE + index)



/* (16'h0600) acl_reg */

#define    RTL8367C_ACL_RULE_TEMPLATE_CTRL_BASE                    RTL8367C_REG_ACL_RULE_TEMPLATE0_CTRL0
#define    RTL8367C_ACL_RULE_TEMPLATE_CTRL_REG(template)        (RTL8367C_ACL_RULE_TEMPLATE_CTRL_BASE + template * 0x4)
#define    RTL8367C_ACL_TEMPLATE_FIELD_OFFSET(field)            ((field & 0x01) <<3)
#define    RTL8367C_ACL_TEMPLATE_FIELD_MASK(field)                (0x3F << RTL8367C_ACL_TEMPLATE_FIELD_OFFSET(field))

#define    RTL8367C_ACL_ACTION_CTRL_BASE                        RTL8367C_REG_ACL_ACTION_CTRL0
#define    RTL8367C_ACL_ACTION_CTRL_REG(rule)                   (RTL8367C_ACL_ACTION_CTRL_BASE + (rule >> 1))
#define    RTL8367C_ACL_ACTION_CTRL2_BASE                        RTL8367C_REG_ACL_ACTION_CTRL32
#define    RTL8367C_ACL_ACTION_CTRL2_REG(rule)                  (RTL8367C_ACL_ACTION_CTRL2_BASE + ((rule-64) >> 1))

#define    RTL8367C_ACL_OP_NOT_OFFSET(rule)                        (6 + ((rule & 0x1) << 3))
#define    RTL8367C_ACL_OP_NOT_MASK(rule)                        (1 << RTL8367C_ACL_OP_NOT_OFFSET(rule))
#define    RTL8367C_ACL_OP_ACTION_OFFSET(rule)                    ((rule & 0x1) << 3)
#define    RTL8367C_ACL_OP_ACTION_MASK(rule)                    (0x3F << RTL8367C_ACL_OP_ACTION_OFFSET(rule))

#define    RTL8367C_ACL_ENABLE_REG                                RTL8367C_REG_ACL_ENABLE
#define    RTL8367C_ACL_UNMATCH_PERMIT_REG                        RTL8367C_REG_ACL_UNMATCH_PERMIT

/* (16'h0700) cvlan_reg */

#define    RTL8367C_VLAN_PVID_CTRL_BASE                            RTL8367C_REG_VLAN_PVID_CTRL0
#define    RTL8367C_VLAN_PVID_CTRL_REG(port)                    (RTL8367C_VLAN_PVID_CTRL_BASE + (port >> 1))
#define    RTL8367C_PORT_VIDX_OFFSET(port)                        ((port &1)<<3)
#define    RTL8367C_PORT_VIDX_MASK(port)                        (RTL8367C_PORT0_VIDX_MASK << RTL8367C_PORT_VIDX_OFFSET(port))

#define    RTL8367C_VLAN_PPB_VALID_BASE                            RTL8367C_REG_VLAN_PPB0_VALID
#define    RTL8367C_VLAN_PPB_VALID_REG(item)                    (RTL8367C_VLAN_PPB_VALID_BASE + (item << 3))

#define    RTL8367C_VLAN_PPB_CTRL_BASE                            RTL8367C_REG_VLAN_PPB0_CTRL0
#define    RTL8367C_VLAN_PPB_CTRL_REG(item, port)               (RTL8367C_VLAN_PPB_CTRL_BASE + (item << 3) + (port / 3) )
#define    RTL8367C_VLAN_PPB_CTRL_OFFSET(port)                    ((port % 3) * 5)
#define    RTL8367C_VLAN_PPB_CTRL_MASK(port)                    (RTL8367C_VLAN_PPB0_CTRL0_PORT0_INDEX_MASK << RTL8367C_VLAN_PPB_CTRL_OFFSET(port))

#define    RTL8367C_VLAN_PPB_FRAMETYPE_BASE                    RTL8367C_REG_VLAN_PPB0_CTRL2
#define    RTL8367C_VLAN_PPB_FRAMETYPE_REG(item)               (RTL8367C_VLAN_PPB_FRAMETYPE_BASE + (item << 3))
#define    RTL8367C_VLAN_PPB_FRAMETYPE_MASK                    RTL8367C_VLAN_PPB0_CTRL2_FRAME_TYPE_MASK

#define    RTL8367C_VLAN_PPB_ETHERTYPR_BASE                        RTL8367C_REG_VLAN_PPB0_CTRL3
#define    RTL8367C_VLAN_PPB_ETHERTYPR_REG(item)                (RTL8367C_VLAN_PPB_ETHERTYPR_BASE + (item << 3))

#define    RTL8367C_VLAN_MEMBER_CONFIGURATION_BASE                RTL8367C_REG_VLAN_MEMBER_CONFIGURATION0_CTRL0


#define    RTL8367C_VLAN_CTRL_REG                                RTL8367C_REG_VLAN_CTRL

#define    RTL8367C_VLAN_INGRESS_REG                            RTL8367C_REG_VLAN_INGRESS

#define    RTL8367C_VLAN_ACCEPT_FRAME_TYPE_BASE                    RTL8367C_REG_VLAN_ACCEPT_FRAME_TYPE_CTRL0
#define    RTL8367C_VLAN_ACCEPT_FRAME_TYPE_REG(port)            (RTL8367C_VLAN_ACCEPT_FRAME_TYPE_BASE + (port >> 3))
#define    RTL8367C_VLAN_ACCEPT_FRAME_TYPE_MASK(port)           (RTL8367C_PORT0_FRAME_TYPE_MASK << ((port & 0x7) << 1))

#define    RTL8367C_PORT_EFID_BASE                                RTL8367C_REG_PORT_EFID_CTRL0
#define    RTL8367C_PORT_EFID_REG(port)                            (RTL8367C_PORT_EFID_BASE + (port >> 2))
#define    RTL8367C_PORT_EFID_OFFSET(port)                         ((port & 0x3) << 2)
#define    RTL8367C_PORT_EFID_MASK(port)                        (RTL8367C_PORT0_EFID_MASK << RTL8367C_PORT_EFID_OFFSET(port))

#define    RTL8367C_PORT_PBFIDEN_REG                            RTL8367C_REG_PORT_PBFIDEN

#define    RTL8367C_PORT_PBFID_BASE                             RTL8367C_REG_PORT0_PBFID
#define    RTL8367C_PORT_PBFID_REG(port)                        (RTL8367C_PORT_PBFID_BASE + port)

/* (16'h0800) dpm_reg */

#define    RTL8367C_RMA_CTRL_BASE                                RTL8367C_REG_RMA_CTRL00


#define    RTL8367C_VLAN_PORTBASED_PRIORITY_BASE                RTL8367C_REG_VLAN_PORTBASED_PRIORITY_CTRL0
#define    RTL8367C_VLAN_PORTBASED_PRIORITY_REG(port)            (RTL8367C_VLAN_PORTBASED_PRIORITY_BASE + (port >> 2))
#define    RTL8367C_VLAN_PORTBASED_PRIORITY_OFFSET(port)        ((port & 0x3) << 2)
#define    RTL8367C_VLAN_PORTBASED_PRIORITY_MASK(port)            (0x7 << RTL8367C_VLAN_PORTBASED_PRIORITY_OFFSET(port))

#define    RTL8367C_VLAN_PPB_PRIORITY_ITEM_BASE                    RTL8367C_REG_VLAN_PPB_PRIORITY_ITEM0_CTRL0
#define    RTL8367C_VLAN_PPB_PRIORITY_ITEM_REG(port, item)        (RTL8367C_VLAN_PPB_PRIORITY_ITEM_BASE + (item << 2)+ (port>>2))
#define    RTL8367C_VLAN_PPB_PRIORITY_ITEM_OFFSET(port)            ((port & 0x3) <<2)
#define    RTL8367C_VLAN_PPB_PRIORITY_ITEM_MASK(port)            (RTL8367C_VLAN_PPB_PRIORITY_ITEM0_CTRL0_PORT0_PRIORITY_MASK << RTL8367C_VLAN_PPB_PRIORITY_ITEM_OFFSET(port))

#define    RTL8367C_QOS_1Q_PRIORITY_REMAPPING_BASE                RTL8367C_REG_QOS_1Q_PRIORITY_REMAPPING_CTRL0
#define    RTL8367C_QOS_1Q_PRIORITY_REMAPPING_REG(pri)            (RTL8367C_QOS_1Q_PRIORITY_REMAPPING_BASE + (pri >> 2))
#define    RTL8367C_QOS_1Q_PRIORITY_REMAPPING_OFFSET(pri)        ((pri & 0x3) << 2)
#define    RTL8367C_QOS_1Q_PRIORITY_REMAPPING_MASK(pri)            (0x7 << RTL8367C_QOS_1Q_PRIORITY_REMAPPING_OFFSET(pri))

#define    RTL8367C_QOS_DSCP_TO_PRIORITY_BASE                    RTL8367C_REG_QOS_DSCP_TO_PRIORITY_CTRL0
#define    RTL8367C_QOS_DSCP_TO_PRIORITY_REG(dscp)                (RTL8367C_QOS_DSCP_TO_PRIORITY_BASE + (dscp >> 2))
#define    RTL8367C_QOS_DSCP_TO_PRIORITY_OFFSET(dscp)            ((dscp & 0x3) << 2)
#define    RTL8367C_QOS_DSCP_TO_PRIORITY_MASK(dscp)                (0x7 << RTL8367C_QOS_DSCP_TO_PRIORITY_OFFSET(dscp))

#define    RTL8367C_QOS_PORTBASED_PRIORITY_BASE                    RTL8367C_REG_QOS_PORTBASED_PRIORITY_CTRL0
#define    RTL8367C_QOS_PORTBASED_PRIORITY_REG(port)            (RTL8367C_QOS_PORTBASED_PRIORITY_BASE + (port >> 2))
#define    RTL8367C_QOS_PORTBASED_PRIORITY_OFFSET(port)            ((port & 0x3) << 2)
#define    RTL8367C_QOS_PORTBASED_PRIORITY_MASK(port)            (0x7 << RTL8367C_QOS_PORTBASED_PRIORITY_OFFSET(port))

#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_BASE            RTL8367C_REG_QOS_INTERNAL_PRIORITY_DECISION_CTRL0
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_REG(src)        (RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_BASE + (src >> 1))
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_OFFSET(src)  ((src & 1) << 3)
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_MASK(src)    (RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_CTRL0_QOS_PORT_WEIGHT_MASK << RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_OFFSET(src))

#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_BASE            RTL8367C_REG_QOS_INTERNAL_PRIORITY_DECISION2_CTRL0
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_REG(src)        (RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_BASE + (src >> 1))
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_OFFSET(src)  ((src & 1) << 3)
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_MASK(src)    (RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_CTRL0_QOS_PORT_WEIGHT_MASK << RTL8367C_QOS_INTERNAL_PRIORITY_DECISION2_OFFSET(src))

#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_IDX_CTRL            RTL8367C_REG_QOS_INTERNAL_PRIORITY_DECISION_IDX
#define    RTL8367C_QOS_INTERNAL_PRIORITY_DECISION_IDX(port)  (1 << port)

#define    RTL8367C_QOS_PRIPORITY_REMAPPING_IN_CPU_BASE            RTL8367C_REG_QOS_PRIORITY_REMAPPING_IN_CPU_CTRL0
#define    RTL8367C_QOS_PRIPORITY_REMAPPING_IN_CPU_REG(pri)        (RTL8367C_QOS_PRIPORITY_REMAPPING_IN_CPU_BASE + (pri >> 2))
#define    RTL8367C_QOS_PRIPORITY_REMAPPING_IN_CPU_OFFSET(pri)  ((pri & 0x3) << 2)
#define    RTL8367C_QOS_PRIPORITY_REMAPPING_IN_CPU_MASK(pri)    (RTL8367C_QOS_PRIORITY_REMAPPING_IN_CPU_CTRL0_PRIORITY0_MASK << RTL8367C_QOS_PRIPORITY_REMAPPING_IN_CPU_OFFSET(pri))

#define    RTL8367C_QOS_TRAP_PRIORITY_CTRL0_REG                RTL8367C_REG_QOS_TRAP_PRIORITY0

#define    RTL8367C_QOS_TRAP_PRIORITY_CTRL1_REG                RTL8367C_REG_QOS_TRAP_PRIORITY1

#define    RTL8367C_QOS_DSCP_TO_DSCP_BASE                             RTL8367C_REG_QOS_DSCP_REMARK_DSCP_CTRL0
#define    RTL8367C_QOS_DSCP_TO_DSCP_REG(dscp)                     (RTL8367C_REG_QOS_DSCP_REMARK_DSCP_CTRL0 + (dscp >> 1))
#define    RTL8367C_QOS_DSCP_TO_DSCP_OFFSET(dscp)                ((dscp & 0x1) << 8)
#define    RTL8367C_QOS_DSCP_TO_DSCP_MASK(dscp)                   (0x3F << RTL8367C_QOS_DSCP_TO_DSCP_OFFSET(dscp))

#define    RTL8367C_UNUCAST_FLOADING_PMSK_REG                    RTL8367C_REG_UNDA_FLOODING_PMSK

#define    RTL8367C_UNMCAST_FLOADING_PMSK_REG                    RTL8367C_REG_UNMCAST_FLOADING_PMSK

#define    RTL8367C_BCAST_FLOADING_PMSK_REG                        RTL8367C_REG_BCAST_FLOADING_PMSK

#define    RTL8367C_PORT_ISOLATION_PORT_MASK_BASE                RTL8367C_REG_PORT_ISOLATION_PORT0_MASK
#define    RTL8367C_PORT_ISOLATION_PORT_MASK_REG(port)            (RTL8367C_PORT_ISOLATION_PORT_MASK_BASE + port)

#define    RTL8367C_FORCE_CTRL_REG                                RTL8367C_REG_FORCE_CTRL

#define    RTL8367C_SOURCE_PORT_BLOCK_REG                        RTL8367C_REG_SOURCE_PORT_PERMIT

#define    RTL8367C_IPMCAST_VLAN_LEAKY_REG                        RTL8367C_REG_IPMCAST_VLAN_LEAKY

#define    RTL8367C_IPMCAST_PORTISO_LEAKY_REG                    RTL8367C_REG_IPMCAST_PORTISO_LEAKY

#define    RTL8367C_PORT_SECURIT_CTRL_REG                        RTL8367C_REG_PORT_SECURITY_CTRL

#define    RTL8367C_UNKNOWN_IPV4_MULTICAST_BASE                    RTL8367C_REG_UNKNOWN_IPV4_MULTICAST_CTRL0
#define    RTL8367C_UNKNOWN_IPV4_MULTICAST_REG(port)            (RTL8367C_UNKNOWN_IPV4_MULTICAST_BASE + (port >> 3))
#define    RTL8367C_UNKNOWN_IPV4_MULTICAST_OFFSET(port)            ((port & 0x7) << 1)
#define    RTL8367C_UNKNOWN_IPV4_MULTICAST_MASK(port)            (RTL8367C_PORT0_UNKNOWN_IP4_MCAST_MASK << RTL8367C_UNKNOWN_IPV4_MULTICAST_OFFSET(port))

#define    RTL8367C_UNKNOWN_IPV6_MULTICAST_BASE                    RTL8367C_REG_UNKNOWN_IPV6_MULTICAST_CTRL0
#define    RTL8367C_UNKNOWN_IPV6_MULTICAST_REG(port)            (RTL8367C_UNKNOWN_IPV6_MULTICAST_BASE + (port >> 3))
#define    RTL8367C_UNKNOWN_IPV6_MULTICAST_OFFSET(port)            ((port & 0x7) << 1)
#define    RTL8367C_UNKNOWN_IPV6_MULTICAST_MASK(port)            (RTL8367C_PORT0_UNKNOWN_IP4_MCAST_MASK << RTL8367C_UNKNOWN_IPV6_MULTICAST_OFFSET(port))

#define    RTL8367C_UNKNOWN_L2_MULTICAST_BASE                    RTL8367C_REG_UNKNOWN_L2_MULTICAST_CTRL0
#define    RTL8367C_UNKNOWN_L2_MULTICAST_REG(port)                (RTL8367C_UNKNOWN_L2_MULTICAST_BASE + (port >> 3))
#define    RTL8367C_UNKNOWN_L2_MULTICAST_OFFSET(port)            ((port & 0x7) << 1)
#define    RTL8367C_UNKNOWN_L2_MULTICAST_MASK(port)                (RTL8367C_PORT0_UNKNOWN_L2_MCAST_MASK << RTL8367C_UNKNOWN_L2_MULTICAST_OFFSET(port))

#define    RTL8367C_PORT_TRUNK_CTRL_REG                            RTL8367C_REG_PORT_TRUNK_CTRL
#define    RTL8367C_PORT_TRUNK_HASH_MASK                           0x007F

#define    RTL8367C_PORT_TRUNK_GROUP_MASK_REG    RTL8367C_REG_PORT_TRUNK_GROUP_MASK
#define    RTL8367C_PORT_TRUNK_GROUP_MASK_OFFSET(group)    (group << 2)
#define    RTL8367C_PORT_TRUNK_GROUP_MASK_MASK(group)    (RTL8367C_PORT_TRUNK_GROUP0_MASK_MASK << RTL8367C_PORT_TRUNK_GROUP_MASK_OFFSET(group))

#define    RTL8367C_PORT_TRUNK_FLOWCTRL_REG                        RTL8367C_REG_PORT_TRUNK_FLOWCTRL

#define    RTL8367C_QOS_PORT_QUEUE_NUMBER_BASE                    RTL8367C_REG_QOS_PORT_QUEUE_NUMBER_CTRL0
#define    RTL8367C_QOS_PORT_QUEUE_NUMBER_REG(port)                (RTL8367C_QOS_PORT_QUEUE_NUMBER_BASE + (port >> 2))
#define    RTL8367C_QOS_PORT_QUEUE_NUMBER_OFFSET(port)            ((port & 0x3) << 2)
#define    RTL8367C_QOS_PORT_QUEUE_NUMBER_MASK(port)            (0x7 << RTL8367C_QOS_PORT_QUEUE_NUMBER_OFFSET(port))

#define    RTL8367C_QOS_1Q_PRIORITY_TO_QID_BASE                    RTL8367C_REG_QOS_1Q_PRIORITY_TO_QID_CTRL0
#define    RTL8367C_QOS_1Q_PRIORITY_TO_QID_REG(index, pri)        (RTL8367C_QOS_1Q_PRIORITY_TO_QID_BASE + (index << 1) + (pri >> 2))
#define    RTL8367C_QOS_1Q_PRIORITY_TO_QID_OFFSET(pri)            ((pri & 0x3) << 2)
#define    RTL8367C_QOS_1Q_PRIORITY_TO_QID_MASK(pri)            (RTL8367C_QOS_1Q_PRIORITY_TO_QID_CTRL0_PRIORITY0_TO_QID_MASK << RTL8367C_QOS_1Q_PRIORITY_TO_QID_OFFSET(pri))

#define    RTL8367C_DEBUG_INFO_BASE                                RTL8367C_REG_PORT_DEBUG_INFO_CTRL0
#define    RTL8367C_DEBUG_INFO_REG(port)                        (RTL8367C_DEBUG_INFO_BASE + (port >>1))
#define    RTL8367C_DEBUG_INFO_OFFSET(port)                        ((port&1)<<3)
#define    RTL8367C_DEBUG_INFO_MASK(port)                        (RTL8367C_PORT0_DEBUG_INFO_MASK << RTL8367C_DEBUG_INFO_OFFSET(port))

/* (16'h0a00) l2_reg */

#define    RTL8367C_VLAN_MSTI_BASE                                RTL8367C_REG_VLAN_MSTI0_CTRL0
#define    RTL8367C_VLAN_MSTI_REG(tree, port)                    (RTL8367C_VLAN_MSTI_BASE + (tree << 1) + (port >> 3))
#define    RTL8367C_VLAN_MSTI_OFFSET(port)                        ((port & 0x7) << 1)
#define    RTL8367C_VLAN_MSTI_MASK(port)                        (RTL8367C_VLAN_MSTI0_CTRL0_PORT0_STATE_MASK << RTL8367C_VLAN_MSTI_OFFSET(port))

#define    RTL8367C_LUT_PORT_LEARN_LIMITNO_BASE                    RTL8367C_REG_LUT_PORT0_LEARN_LIMITNO
#define    RTL8367C_LUT_PORT_LEARN_LIMITNO_REG(port)            (RTL8367C_LUT_PORT_LEARN_LIMITNO_BASE + port)

#define    RTL8367C_LUT_CFG_REG                                    RTL8367C_REG_LUT_CFG

#define    RTL8367C_LUT_AGEOUT_CTRL_REG                            RTL8367C_REG_LUT_AGEOUT_CTRL

#define    RTL8367C_FORCE_FLUSH_REG                                RTL8367C_REG_FORCE_FLUSH

#define    RTL8367C_STORM_BCAST_REG                                RTL8367C_REG_STORM_BCAST

#define    RTL8367C_STORM_MCAST_REG                                RTL8367C_REG_STORM_MCAST

#define    RTL8367C_STORM_UNKNOWN_UCAST_REG                        RTL8367C_REG_STORM_UNKOWN_UCAST

#define    RTL8367C_STORM_UNKNOWN_MCAST_REG                        RTL8367C_REG_STORM_UNKOWN_MCAST

#define    RTL8367C_STORM_BCAST_METER_CTRL_BASE                    RTL8367C_REG_STORM_BCAST_METER_CTRL0
#define    RTL8367C_STORM_BCAST_METER_CTRL_REG(port)            (RTL8367C_STORM_BCAST_METER_CTRL_BASE + (port >> 1))
#define    RTL8367C_STORM_BCAST_METER_CTRL_OFFSET(port)            ((port & 0x1) << 3)
#define    RTL8367C_STORM_BCAST_METER_CTRL_MASK(port)            (0xFF << RTL8367C_STORM_BCAST_METER_CTRL_OFFSET(port))

#define    RTL8367C_STORM_MCAST_METER_CTRL_BASE                    RTL8367C_REG_STORM_MCAST_METER_CTRL0
#define    RTL8367C_STORM_MCAST_METER_CTRL_REG(port)            (RTL8367C_STORM_MCAST_METER_CTRL_BASE + (port >> 1))
#define    RTL8367C_STORM_MCAST_METER_CTRL_OFFSET(port)            ((port & 0x1) << 3)
#define    RTL8367C_STORM_MCAST_METER_CTRL_MASK(port)            (0xFF << RTL8367C_STORM_MCAST_METER_CTRL_OFFSET(port))

#define    RTL8367C_STORM_UNDA_METER_CTRL_BASE                    RTL8367C_REG_STORM_UNDA_METER_CTRL0
#define    RTL8367C_STORM_UNDA_METER_CTRL_REG(port)                (RTL8367C_STORM_UNDA_METER_CTRL_BASE + (port >> 1))
#define    RTL8367C_STORM_UNDA_METER_CTRL_OFFSET(port)            ((port & 0x1) << 3)
#define    RTL8367C_STORM_UNDA_METER_CTRL_MASK(port)            (0xFF << RTL8367C_STORM_UNDA_METER_CTRL_OFFSET(port))

#define    RTL8367C_STORM_UNMC_METER_CTRL_BASE                    RTL8367C_REG_STORM_UNMC_METER_CTRL0
#define    RTL8367C_STORM_UNMC_METER_CTRL_REG(port)                (RTL8367C_STORM_UNMC_METER_CTRL_BASE + (port >> 1))
#define    RTL8367C_STORM_UNMC_METER_CTRL_OFFSET(port)            ((port & 0x1) << 3)
#define    RTL8367C_STORM_UNMC_METER_CTRL_MASK(port)            (0xFF << RTL8367C_STORM_UNMC_METER_CTRL_OFFSET(port))

#define    RTL8367C_OAM_PARSER_OFFSET(port)                        (port*2)
#define    RTL8367C_OAM_PARSER_MASK(port)                        (RTL8367C_PORT0_PARACT_MASK << RTL8367C_OAM_PARSER_OFFSET(port))

#define    RTL8367C_OAM_MULTIPLEXER_OFFSET(port)                (port*2)
#define    RTL8367C_OAM_MULTIPLEXER_MASK(port)                    (RTL8367C_PORT0_PARACT_MASK << RTL8367C_OAM_MULTIPLEXER_OFFSET(port))

#define    RTL8367C_OAM_CTRL_REG                                RTL8367C_REG_OAM_CTRL

#define    RTL8367C_DOT1X_PORT_ENABLE_REG                        RTL8367C_REG_DOT1X_PORT_ENABLE

#define    RTL8367C_DOT1X_MAC_ENABLE_REG                        RTL8367C_REG_DOT1X_MAC_ENABLE

#define    RTL8367C_DOT1X_PORT_AUTH_REG                            RTL8367C_REG_DOT1X_PORT_AUTH

#define    RTL8367C_DOT1X_PORT_OPDIR_REG                        RTL8367C_REG_DOT1X_PORT_OPDIR

#define    RTL8367C_DOT1X_UNAUTH_ACT_BASE                        RTL8367C_REG_DOT1X_UNAUTH_ACT_W0
#define    RTL8367C_DOT1X_UNAUTH_ACT_OFFSET(port)                ((port & 0x7) << 1)
#define    RTL8367C_DOT1X_UNAUTH_ACT_MASK(port)                    (RTL8367C_DOT1X_PORT0_UNAUTHBH_MASK << RTL8367C_DOT1X_UNAUTH_ACT_OFFSET(port))

#define    RTL8367C_DOT1X_CFG_REG                                RTL8367C_REG_DOT1X_CFG

#define    RTL8367C_REG_L2_LRN_CNT_BASE                            RTL8367C_REG_L2_LRN_CNT_CTRL0
#define    RTL8367C_REG_L2_LRN_CNT_REG(port)                    (RTL8367C_REG_L2_LRN_CNT_BASE + port)

/* (16'h0b00) mltvlan_reg */

#define    RTL8367C_SVLAN_MCAST2S_ENTRY_BASE_REG(index)        (RTL8367C_REG_SVLAN_MCAST2S_ENTRY0_CTRL0 + index*5)

/* (16'h0c00) svlan_reg */

#define    RTL8367C_SVLAN_MEMBERCFG_BASE_REG(index)                (RTL8367C_REG_SVLAN_MEMBERCFG0_CTRL1 + index*3)
#define    RTL8367C_SVLAN_C2SCFG_BASE_REG(index)                  (RTL8367C_REG_SVLAN_C2SCFG0_CTRL0+ index*3)
#define    RTL8367C_SVLAN_CFG_REG                                RTL8367C_REG_SVLAN_CFG

/* (16'h0f00) hsactrl_reg */

#define    RTL8367C_SVLAN_S2C_ENTRY_BASE_REG(index)                (RTL8367C_REG_SVLAN_SP2C_ENTRY0_CTRL0 + index*2)

/* (16'h1000) mib_reg */

#define    RTL8367C_MIB_COUNTER_BASE_REG                        RTL8367C_REG_MIB_COUNTER0

#define    RTL8367C_MIB_ADDRESS_REG                                RTL8367C_REG_MIB_ADDRESS

#define    RTL8367C_MIB_CTRL_REG                                RTL8367C_REG_MIB_CTRL0
#define    RTL8367C_MIB_PORT07_MASK                                (0xFF<<RTL8367C_PORT0_RESET_OFFSET)

/* (16'h1100) intrpt_reg */

#define    RTL8367C_INTR_CTRL_REG                                RTL8367C_REG_INTR_CTRL

#define    RTL8367C_INTR_IMR_REG                                RTL8367C_REG_INTR_IMR

#define    RTL8367C_INTR_IMS_REG                                RTL8367C_REG_INTR_IMS

#define    RTL8367C_INTR_INDICATOR_BASED                        RTL8367C_REG_LEARN_OVER_INDICATOR
#define    RTL8367C_LEARN_OVER_INDICATOR_REG                    RTL8367C_REG_LEARN_OVER_INDICATOR

#define    RTL8367C_SPEED_CHANGE_INDICATOR_REG                    RTL8367C_REG_SPEED_CHANGE_INDICATOR

#define    RTL8367C_PORT_LINKDOWN_INDICATOR_REG                    RTL8367C_REG_PORT_LINKDOWN_INDICATOR

#define    RTL8367C_PORT_LINKUP_INDICATOR_REG                    RTL8367C_REG_PORT_LINKUP_INDICATOR

#define    RTL8367C_REG_METER_EXCEED_INDICATOR_BASE                RTL8367C_REG_METER_EXCEED_INDICATOR0
#define    RTL8367C_REG_METER_EXCEED_INDICATOR_REG(meter)        (RTL8367C_REG_METER_EXCEED_INDICATOR_BASE + (meter >> 4))
#define    RTL8367C_REG_METER_EXCEED_INDICATOR_OFFSET(meter)    (meter & 0xF)

/* (16'h1200) swcore_reg */

#define    RTL8367C_VS_TPID_REG                                    RTL8367C_REG_VS_TPID

#define    RTL8367C_SWITCH_MAC_BASE                                RTL8367C_REG_SWITCH_MAC0

#define    RTL8367C_REMARKING_CTRL_REG                            RTL8367C_REG_SWITCH_CTRL0

#define    RTL8367C_QOS_DSCP_REMARK_BASE                        RTL8367C_REG_QOS_DSCP_REMARK_CTRL0
#define    RTL8367C_QOS_DSCP_REMARK_REG(pri)                    (RTL8367C_QOS_DSCP_REMARK_BASE + (pri >> 1))
#define    RTL8367C_QOS_DSCP_REMARK_OFFSET(pri)                    (((pri) & 0x1) << 3)
#define    RTL8367C_QOS_DSCP_REMARK_MASK(pri)                    (0x3F << RTL8367C_QOS_DSCP_REMARK_OFFSET(pri))

#define    RTL8367C_QOS_1Q_REMARK_BASE                            RTL8367C_REG_QOS_1Q_REMARK_CTRL0
#define    RTL8367C_QOS_1Q_REMARK_REG(pri)                        (RTL8367C_QOS_1Q_REMARK_BASE + (pri >> 2))
#define    RTL8367C_QOS_1Q_REMARK_OFFSET(pri)                    ((pri & 0x3) << 2)
#define    RTL8367C_QOS_1Q_REMARK_MASK(pri)                        (0x7 << RTL8367C_QOS_1Q_REMARK_OFFSET(pri))

#define    RTL8367C_PTKGEN_PAYLOAD_CTRL0_REG                    RTL8367C_REG_PTKGEN_PAYLOAD_CTRL0

#define    RTL8367C_PTKGEN_PAYLOAD_CTRL1_REG                    RTL8367C_REG_PTKGEN_PAYLOAD_CTRL1

#define    RTL8367C_SVLAN_UPLINK_PORTMASK_REG                    RTL8367C_REG_SVLAN_UPLINK_PORTMASK

#define    RTL8367C_CPU_PORT_MASK_REG                            RTL8367C_REG_CPU_PORT_MASK

#define    RTL8367C_CPU_CTRL_REG                                RTL8367C_REG_CPU_CTRL

#define    RTL8367C_MIRROR_CTRL_REG                                RTL8367C_REG_MIRROR_CTRL


#define    RTL8367C_FLOWCRTL_EGRESS_QUEUE_ENABLE_BASE            RTL8367C_REG_FLOWCRTL_EGRESS_QUEUE_ENABLE_CTRL0
#define    RTL8367C_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG(port)        (RTL8367C_FLOWCRTL_EGRESS_QUEUE_ENABLE_BASE + (port >> 1))
#define    RTL8367C_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8367C_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG_MASK(port)    (RTL8367C_PORT0_QUEUE_MASK_MASK << RTL8367C_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG_OFFSET(port))


#define    RTL8367C_FLOWCTRL_PORT_PAGE_COUNTER_BASE                RTL8367C_REG_FLOWCTRL_PORT0_PAGE_COUNTER
#define    RTL8367C_FLOWCTRL_PORT_PAGE_COUNTER_REG(port)        (RTL8367C_FLOWCTRL_PORT_PAGE_COUNTER_BASE + port)
#define    RTL8367C_FLOWCTRL_PORT_PAGE_COUNTER_MASK                RTL8367C_FLOWCTRL_PORT0_PAGE_COUNTER_MASK

#define    RTL8367C_FLOWCTRL_PORT_PAGE_MAX_BASE                    RTL8367C_REG_FLOWCTRL_PORT0_PAGE_MAX
#define    RTL8367C_FLOWCTRL_PORT_PAGE_MAX_REG(port)            (RTL8367C_FLOWCTRL_PORT_PAGE_MAX_BASE + port)
#define    RTL8367C_FLOWCTRL_PORT_PAGE_MAX_MASK                    RTL8367C_FLOWCTRL_PORT0_PAGE_MAX_MASK

#define    RTL8367C_FIELD_SELECTOR_REG(index)                    (RTL8367C_REG_FIELD_SELECTOR0 + index)
#define    RTL8367C_FIELD_SELECTOR_ENABLE_OFFSET                 RTL8367C_FIELD_SELECTOR0_ENABLE_OFFSET
#define    RTL8367C_FIELD_SELECTOR_ENABLE_MASK                    RTL8367C_FIELD_SELECTOR0_ENABLE_MASK
#define    RTL8367C_FIELD_SELECTOR_FORMAT_OFFSET                RTL8367C_FIELD_SELECTOR0_FORMAT_OFFSET
#define    RTL8367C_FIELD_SELECTOR_FORMAT_MASK                    RTL8367C_FIELD_SELECTOR0_FORMAT_MASK
#define    RTL8367C_FIELD_SELECTOR_OFFSET_OFFSET                  RTL8367C_FIELD_SELECTOR0_OFFSET_OFFSET
#define    RTL8367C_FIELD_SELECTOR_OFFSET_MASK                    RTL8367C_FIELD_SELECTOR0_OFFSET_MASK

/* (16'h1300) chip_reg*/

/* (16'h1400) mtrpool_reg */
#define    RTL8367C_METER_RATE_BASE                                RTL8367C_REG_METER0_RATE_CTRL0
#define    RTL8367C_METER_RATE_REG(meter)                        ((meter << 1) + RTL8367C_METER_RATE_BASE)

#define    RTL8367C_METER_BUCKET_SIZE_BASE                        RTL8367C_REG_METER0_BUCKET_SIZE
#define    RTL8367C_METER_BUCKET_SIZE_REG(meter)                (RTL8367C_METER_BUCKET_SIZE_BASE + meter)

#define    RTL8367C_LEAKY_BUCKET_TICK_REG                        RTL8367C_REG_METER_CTRL0
#define    RTL8367C_LEAKY_BUCKET_TICK_OFFSET                    RTL8367C_METER_TICK_OFFSET
#define    RTL8367C_LEAKY_BUCKET_TICK_MASK                        RTL8367C_METER_TICK_MASK

#define    RTL8367C_LEAKY_BUCKET_TOKEN_REG                        RTL8367C_REG_METER_CTRL1
#define    RTL8367C_LEAKY_BUCKET_TOKEN_OFFSET                    RTL8367C_METER_CTRL1_OFFSET
#define    RTL8367C_LEAKY_BUCKET_TOKEN_MASK                        RTL8367C_METER_CTRL1_MASK

#define    RTL8367C_METER_OVERRATE_INDICATOR_BASE                RTL8367C_REG_METER_OVERRATE_INDICATOR0
#define    RTL8367C_METER_OVERRATE_INDICATOR_REG(meter)            (RTL8367C_METER_OVERRATE_INDICATOR_BASE + (meter >> 4))
#define    RTL8367C_METER_EXCEED_OFFSET(meter)                    (meter & 0xF)
#define    RTL8367C_METER_EXCEED_MASK(meter)                    (1 << RTL8367C_METER_EXCEED_OFFSET(meter))

#define    RTL8367C_METER_IFG_CTRL_BASE                            RTL8367C_REG_METER_IFG_CTRL0
#define    RTL8367C_METER_IFG_CTRL_REG(meter)                    (RTL8367C_METER_IFG_CTRL_BASE + (meter >> 4))
#define    RTL8367C_METER_IFG_OFFSET(meter)                        (meter & 0xF)
#define    RTL8367C_METER_IFG_MASK(meter)                        (1 << RTL8367C_METER_IFG_OFFSET(meter))

#define    RTL8367C_FLOWCTRL_CTRL_REG                            RTL8367C_REG_FLOWCTRL_CTRL0

/* (16'h1800)8051_RLDP_EEE_reg */
#define    RTL8367C_EEELLDP_CTRL0_REG                            RTL8367C_REG_EEELLDP_CTRL0

#define    RTL8367C_EEELLDP_CTRL1_REG                            RTL8367C_REG_EEELLDP_CTRL1

#define    RTL8367C_EEELLDP_PMSK_REG                            RTL8367C_REG_EEELLDP_PMSK

#define    RTL8367C_EEELLDP_TX_FRAMEU_REG_BASE                    RTL8367C_REG_EEELLDP_FRAMEU00

#define    RTL8367C_EEELLDP_TX_CAP_FRAMEL_REG_BASE                RTL8367C_REG_EEELLDP_CAP_FRAMEL00

#define    RTL8367C_EEELLDP_RX_VALUE_PORT_BASE                    RTL8367C_REG_EEELLDP_RX_VALUE_P00_00
#define    RTL8367C_EEELLDP_RX_VALUE_PORT_REG(port)                (RTL8367C_EEELLDP_RX_VALUE_PORT_BASE + (port * 9))

#define    RTL8367C_RLDP_CTRL0_REG                                RTL8367C_REG_RLDP_CTRL0
#define    RTL8367C_RLDP_MODE_OFFSET    14

#define    RTL8367C_RLDP_RETRY_COUNT_REG                        RTL8367C_REG_RLDP_CTRL1

#define    RTL8367C_RLDP_RETRY_PERIOD_LOOPSTATE_REG                RTL8367C_REG_RLDP_CTRL2

#define    RTL8367C_RLDP_RETRY_PERIOD_CHKSTATE_REG                RTL8367C_REG_RLDP_CTRL3

#define    RTL8367C_RLDP_TX_PMSK_REG                            RTL8367C_REG_RLDP_CTRL4

#define    RTL8367C_RLDP_RAND_NUM_REG_BASE                        RTL8367C_REG_RLDP_RAND_NUM0

#define    RTL8367C_RLDP_MAGIC_NUM_REG_BASE                        RTL8367C_REG_RLDP_MAGIC_NUM0

#define    RTL8367C_RLDP_LOOP_PMSK_REG                            RTL8367C_REG_RLDP_LOOPSTATUS_INDICATOR

#define    RTL8367C_RLDP_LOOP_PORT_BASE                            RTL8367C_REG_RLDP_LOOP_PORT_REG0
#define    RTL8367C_RLDP_LOOP_PORT_REG(port)                    (RTL8367C_RLDP_LOOP_PORT_BASE + (port >> 1))
#define    RTL8367C_RLDP_LOOP_PORT_OFFSET(port)                    ((port & 0x1) << 3)
#define    RTL8367C_RLDP_LOOP_PORT_MASK(port)                    (RTL8367C_RLDP_LOOP_PORT_00_MASK << RTL8367C_RLDP_LOOP_PORT_OFFSET(port))

#define    RTL8367C_PAGEMETER_PORT_BASE                            RTL8367C_REG_PAGEMETER_PORT0_CTRL0
#define    RTL8367C_PAGEMETER_PORT_REG(port)                    (RTL8367C_PAGEMETER_PORT_BASE + 0x20*port)

#define    RTL8367C_HIGHPRI_INDICATOR_REG                        RTL8367C_REG_HIGHPRI_INDICATOR
#define    RTL8367C_PORT_INDICATOR_OFFSET(port)                    (port)
#define    RTL8367C_PORT_INDICATOR_MASK(port)                    (RTL8367C_PORT0_INDICATOR_MASK << RTL8367C_PORT_INDICATOR_OFFSET(port))

#define    RTL8367C_HIGHPRI_CFG_REG                                RTL8367C_REG_HIGHPRI_CFG

#define    RTL8367C_EAV_PRIORITY_REMAPPING_BASE                    RTL8367C_REG_EAV_CTRL1
#define    RTL8367C_EAV_PRIORITY_REMAPPING_REG(pri)                (RTL8367C_EAV_PRIORITY_REMAPPING_BASE + (pri >> 2))
#define    RTL8367C_EAV_PRIORITY_REMAPPING_OFFSET(pri)            ((pri & 0x3) * RTL8367C_REMAP_EAV_PRI1_REGEN_OFFSET)
#define    RTL8367C_EAV_PRIORITY_REMAPPING_MASK(pri)            (RTL8367C_REMAP_EAV_PRI0_REGEN_MASK << RTL8367C_EAV_PRIORITY_REMAPPING_OFFSET(pri))

#define    RTL8367C_EEEP_CFG_BASE                                RTL8367C_REG_PORT0_EEECFG
#define    RTL8367C_EEEP_CFG_REG(port)                            (RTL8367C_EEEP_CFG_BASE + (port*0x20))

#define    RTL8367C_PKG_CFG_BASE                                RTL8367C_REG_PKTGEN_PORT0_CTRL
#define    RTL8367C_PKG_CFG_REG(port)                            (RTL8367C_PKG_CFG_BASE + (port*0x20))

#define    RTL8367C_PKG_DA_BASE                                    RTL8367C_REG_PKTGEN_PORT0_DA0
#define    RTL8367C_PKG_DA_REG(port)                            (RTL8367C_PKG_DA_BASE + (port*0x20))

#define    RTL8367C_PKG_SA_BASE                                    RTL8367C_REG_PKTGEN_PORT0_SA0
#define    RTL8367C_PKG_SA_REG(port)                            (RTL8367C_PKG_SA_BASE + (port*0x20))

#define    RTL8367C_PKG_NUM_BASE                                RTL8367C_REG_PKTGEN_PORT0_COUNTER0
#define    RTL8367C_PKG_NUM_REG(port)                            (RTL8367C_PKG_NUM_BASE + (port*0x20))

#define    RTL8367C_PKG_LENGTH_BASE                                RTL8367C_REG_PKTGEN_PORT0_TX_LENGTH
#define    RTL8367C_PKG_LENGTH_REG(port)                        (RTL8367C_PKG_LENGTH_BASE + (port*0x20))

/* (16'h1c00)IGMP_MLD_reg */
#define    RTL8367C_IGMP_GROUP_USAGE_BASE                       RTL8367C_REG_IGMP_GROUP_USAGE_LIST0
#define    RTL8367C_IGMP_GROUP_USAGE_REG(idx)                   (RTL8367C_IGMP_GROUP_USAGE_BASE + (idx / 16))

#define    RTL8367C_FALLBACK_BASE                               RTL8367C_REG_FALLBACK_PORT0_CFG0
#define    RTL8367C_FALLBACK_PORT_CFG_REG(port)                 (RTL8367C_FALLBACK_BASE + (port * 4))
#define    RTL8367C_FALLBACK_PORT_MON_CNT_REG(port)             (RTL8367C_FALLBACK_BASE + 1 + (port * 4))
#define    RTL8367C_FALLBACK_PORT_ERR_CNT_REG(port)             (RTL8367C_FALLBACK_BASE + 3 + (port * 4))


/* (16'h6400)timer_1588 */
#define    RTL8367C_EAV_CFG_BASE                                              RTL8367C_REG_P0_EAV_CFG
#define    RTL8367C_EAV_PORT_CFG_REG(port)                              (RTL8367C_EAV_CFG_BASE + (port *0x10))
#define    RTL8367C_EAV_CFG_PTP_PHY_EN_EN_OFFSET                 RTL8367C_P0_EAV_CFG_PTP_PHY_EN_EN_OFFSET
#define    RTL8367C_EAV_CFG_RX_PDELAY_RESP_OFFSET                RTL8367C_P0_EAV_CFG_RX_PDELAY_RESP_OFFSET
#define    RTL8367C_EAV_CFG_RX_PDELAY_REQ_OFFSET                 RTL8367C_P0_EAV_CFG_RX_PDELAY_REQ_OFFSET
#define    RTL8367C_EAV_CFG_RX_DELAY_REQ_OFFSET                   RTL8367C_P0_EAV_CFG_RX_DELAY_REQ_OFFSET
#define    RTL8367C_EAV_CFG_RX_SYNC_OFFSET                            RTL8367C_P0_EAV_CFG_RX_SYNC_OFFSET
#define    RTL8367C_EAV_CFG_TX_PDELAY_RESP_OFFSET                RTL8367C_P0_EAV_CFG_TX_PDELAY_RESP_OFFSET
#define    RTL8367C_EAV_CFG_TX_PDELAY_REQ_OFFSET                 RTL8367C_P0_EAV_CFG_TX_PDELAY_REQ_OFFSET
#define    RTL8367C_EAV_CFG_TX_DELAY_REQ_OFFSET                   RTL8367C_P0_EAV_CFG_TX_DELAY_REQ_OFFSET
#define    RTL8367C_EAV_CFG_TX_SYNC_OFFSET                            RTL8367C_P0_EAV_CFG_TX_SYNC_OFFSET

#define    RTL8367C_REG_TX_SYNC_SEQ_ID_BASE                       RTL8367C_REG_P0_TX_SYNC_SEQ_ID
#define    RTL8367C_REG_TX_SYNC_SEQ_ID(port)                        (RTL8367C_REG_TX_SYNC_SEQ_ID_BASE + (port *0x10))
#define    RTL8367C_REG_SEQ_ID(port, type)                              (RTL8367C_REG_TX_SYNC_SEQ_ID_BASE + type + (port *0x10))

#define    RTL8367C_REG_TX_DELAY_REQ_SEQ_ID_BASE              RTL8367C_REG_P0_TX_DELAY_REQ_SEQ_ID
#define    RTL8367C_REG_TX_PDELAY_REQ_SEQ_ID_BASE          RTL8367C_REG_P0_TX_PDELAY_REQ_SEQ_ID
#define    RTL8367C_REG_TX_PDELAY_RESP_SEQ_ID_BASE        RTL8367C_REG_P0_TX_PDELAY_RESP_SEQ_ID
#define    RTL8367C_REG_RX_SYNC_SEQ_ID_BASE                        RTL8367C_REG_P0_RX_SYNC_SEQ_ID
#define    RTL8367C_REG_RX_DELAY_REQ_SEQ_ID_BASE            RTL8367C_REG_P0_RX_DELAY_REQ_SEQ_ID
#define    RTL8367C_REG_RX_PDELAY_REQ_SEQ_ID_BASE        RTL8367C_REG_P0_RX_PDELAY_REQ_SEQ_ID
#define    RTL8367C_REG_RX_PDELAY_RESP_SEQ_ID_BASE        RTL8367C_REG_P0_RX_PDELAY_RESP_SEQ_ID

#define    RTL8367C_REG_PORT_NSEC_L_BASE                            RTL8367C_REG_P0_PORT_NSEC_15_0
#define    RTL8367C_REG_PORT_NSEC_L(port)                            (RTL8367C_REG_PORT_NSEC_L_BASE + (port *0x10))
#define    RTL8367C_REG_PORT_NSEC_H_BASE                            RTL8367C_REG_P0_PORT_NSEC_26_16
#define    RTL8367C_REG_PORT_NSEC_H(port)                            (RTL8367C_REG_PORT_NSEC_H_BASE + (port *0x10))
#define    RTL8367C_PORT_NSEC_H_OFFSET                                RTL8367C_P0_PORT_NSEC_26_16_OFFSET
#define    RTL8367C_PORT_NSEC_H_MASK                                   RTL8367C_P0_PORT_NSEC_26_16_MASK

#define    RTL8367C_REG_PORT_SEC_L_BASE                                RTL8367C_REG_P0_PORT_SEC_15_0
#define    RTL8367C_REG_PORT_SEC_L(port)                            (RTL8367C_REG_PORT_SEC_L_BASE + (port *0x10))
#define    RTL8367C_REG_PORT_SEC_H_BASE                            RTL8367C_REG_P0_PORT_SEC_31_16
#define    RTL8367C_REG_PORT_SEC_H(port)                            (RTL8367C_REG_PORT_SEC_H_BASE + (port *0x10))

#endif /*#ifndef _RTL8367C_BASE_H_*/

