/*
 * Copyright (C) 2016 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
*/

#include <linux/if_vlan.h>
#include <linux/netfilter/nf_conntrack_tuple_common.h>
#include <linux/etherdevice.h>
#include <linux/inetdevice.h>
#include <linux/if_arp.h>
#include <linux/if_ether.h>
#include <linux/ip.h>
#include <linux/in.h>
#include <net/netfilter/nf_conntrack.h>
#include <net/neighbour.h>
#include <net/addrconf.h>
#include "../../../../net/bridge/br_private.h"
#include <common/rt_error.h>
#include <rtk/switch.h>

#include "rtk_fc_driver.h"
#include "rtk_fc_callback.h"
#include "rtk_fc_internal.h"
#include "rtk_fc_debug.h"
#include "rtk_fc_dualHeader.h"
#include "rtk_fc_mappingAPI.h"
#include "rtk_fc_external.h"
#include "rtk_fc_acl.h"
#include "rtk_fc_helper.h"



#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_RTK_L34_G3_PLATFORM)
extern uint32 ASICDRIVERVER;
static int _rtl9607c_fc_global_state_init(void)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_l34_hsdState_set(ENABLED);
	rtk_rg_asic_l2UcAct_set(FB_L2UCACT_FB);

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)

	if(CHIP_ID_9607C) {
#if defined(CONFIG_SWITCH_SYS_CLOCK_TUNE)
		if(ASICDRIVERVER!=0x1){
			rtk_rg_asic_shareMeterGlobalConfig_set(0x16U, 0x3cU);
		}else
#endif
		{
			rtk_rg_asic_shareMeterGlobalConfig_set(0x57U, 0xbdU);
		}
	}else {
		rtk_rg_asic_shareMeterGlobalConfig_set(0x2bU, 0xbdU);
	}

#else

#if defined(CONFIG_SWITCH_SYS_CLOCK_TUNE)
	if(ASICDRIVERVER!=0x1){
		rtk_rg_asic_shareMeterGlobalConfig_set(0x16U, 0x3cU);
	}else
#endif
	{
		rtk_rg_asic_shareMeterGlobalConfig_set(0x57U, 0xbdU);
	}

#endif

	_rtk_rg_fb_hw_init();

	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TTL_1, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_TCP_SYN_FIN_REST, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_TCP_SYN_ACK, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_FRAGMENT, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_L3_CS_CHK, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_L4_CS_CHK, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_L2_FLOW_LOOKUP_BY_MAC, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_CMP_TOS, ENABLED);

	// skip all optional hash pattern
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_SKIP_DA, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_SVID, DISABLED);

	//default add cvid to hash key
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_CVID, DISABLED);


#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER!=0x1U)
#endif
	{
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_CPRI, ENABLED);
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_CPRI, ENABLED);
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_CPRI, ENABLED);
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_CPRI, ENABLED);
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_CPRI, ENABLED);
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_SA, ENABLED);
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_DA, ENABLED);
#if defined(CONFIG_RTK_SOC_RTL8198D)
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_DSCP, DISABLED);
#else
		RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_DSCP, DISABLED);
#endif
	}

	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_SPRI, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI, ENABLED);

	//init preHashPtn
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_SPORT,  0xB0000U);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_DPORT, 0x40000U);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_SIP, 0xE00000U);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_DIP, 0xF00000U);

	//set uc lookup mode
	//_rtk_rg_lut_ucLookupAction_init();

	//init flow ingress check
	//check tos
#if defined(CONFIG_RTK_SOC_RTL8198D)
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH34_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
#else
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH34_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_TOS] = ENABLED; // this should follow FB_GLOBAL_PATHALL_SKIP_DSCP setting
#endif
	//check protocol
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL] = DISABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_PROTOCOL] = DISABLED;
	//check spa
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA] = ENABLED;
	//check stream idx
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_STREAM_IDX] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX] = ENABLED; // support SW only
	//check path6
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SMAC_IDX] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DMAC_IDX] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SIP] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DIP] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SPORT] = DISABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DPORT] = DISABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_GRE_CALL_ID] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_TUNNEL_ID] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_SID] = ENABLED;

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_CMP_TOS, ENABLED);

	// skip all optional hash pattern
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_SKIP_DA, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_SVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_CVID, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_SVID, ENABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_CVID, ENABLED);

	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_CPRI, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_CPRI, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_CPRI, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_CPRI, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_CPRI, ENABLED);	// dual header: no need to care cpri
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_SA, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_DA, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_DSCP, DISABLED);

	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_SPRI, DISABLED);
	RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI, ENABLED);

	//init preHashPtn
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_SPORT,  0xB0000);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_DPORT, 0x40000);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_SIP, 0xF00000);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_DIP, 0xF00000);

	//init flow ingress check
	//check tos
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_TOS] = DISABLED;		// must be disabled because of G3 flow key limitation: if enable l3 mask, the flows with ip or nonip will be distingushed as different.
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH34_TOS] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_TOS] = DISABLED;
	//check protocol
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL] = DISABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_PROTOCOL] = DISABLED;
	//check spa
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA] = ENABLED;
	//check stream idx
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_STREAM_IDX] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX] = ENABLED; // support HW and SW
	//check path6
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SMAC_IDX] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DMAC_IDX] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SIP] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DIP] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SPORT] = DISABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DPORT] = DISABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_GRE_CALL_ID] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_TUNNEL_ID] = ENABLED;
	fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_SID] = ENABLED;
#endif

	fc_db.systemGlobal.bypass_ethertypeProto[0] = 0x888eU;	// 802.1x
	fc_db.systemGlobal.bypass_ethertypeProto_bitmap |= (1U<<0);

	return 0;
}

static int _rtl9607c_fc_port_init(void)
{
	int i=0, ret=0;
	rtk_enable_t enable;

	//get phyPort status and store in software
	for(i=RTK_PORT_UTP0;i<RTK_PORT_UTP11;i++)
	{
		if(rtk_switch_phyPortId_get(i, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	}

	if(rtk_switch_phyPortId_get(RTK_PORT_PON, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_FIBER, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_EXT0, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_EXT1, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_EXT2, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_HSG0, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_HSG1, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);


	if(rtk_switch_phyPortId_get(RTK_PORT_CPU, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
#if defined(CONFIG_FC_RTL9607C_SERIES)
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU1, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU2, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
#endif	
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU1, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU2, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU3, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU4, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU5, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU6, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU7, &ret)==RT_ERR_OK)fc_db.systemGlobal.phyPortStatus|=0x1ULL<<(RTK_FC_MAC_PORT0+ret);

#endif

	// enable src port blocking but exclude cpu ports
	{
		rtk_portmask_t srcPortBlocking;
		rtk_l2_srcPortEgrFilterMask_get(&srcPortBlocking);
		srcPortBlocking.bits[0] &= (~RTK_FC_ALL_MAC_CPU_PORTMASK);
		rtk_l2_srcPortEgrFilterMask_set(&srcPortBlocking);
		rtk_l2_extPortEgrFilterMask_set(&(rtk_portmask_t){{0}});
	}

	enable = ENABLED;
#if !defined(CONFIG_RTK_L34_G3_PLATFORM)

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)

	if(CHIP_ID_9607C) {
		//switch padding
		ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE0, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
		ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE1, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
		//allow receiving packet which smaller than 64 bytes
		ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE0, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
		ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE1, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
		/*CONFIG_GMAC2_USABLE*/
	    	ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_SLAVECPU, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
	    	ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_SLAVECPU, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
	}else{
		//switch padding
		ASSERT_EQ(reg_array_field_write(RTL9603CVD_P_MISCr, RTK_FC_MAC_PORT_CPU, REG_ARRAY_INDEX_NONE, RTL9603CVD_PADDING_ENf, &enable), RT_ERR_OK);
		//allow receiving packet which smaller than 64 bytes
		ASSERT_EQ(reg_array_field_write(RTL9603CVD_P_MISCr, RTK_FC_MAC_PORT_CPU, REG_ARRAY_INDEX_NONE, RTL9603CVD_RX_SPCf, &enable), RT_ERR_OK);
	}

#elif defined(CONFIG_FC_RTL9607C_SERIES)
	//switch padding
	ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE0, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
	ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE1, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
	//allow receiving packet which smaller than 64 bytes
	ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE0, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
	ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_MASTERCPU_CORE1, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
	/*CONFIG_GMAC2_USABLE*/
    ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_SLAVECPU, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
    ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, RTK_FC_MAC_PORT_SLAVECPU, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
	//switch padding
	ASSERT_EQ(reg_array_field_write(RTL9603CVD_P_MISCr, RTK_FC_MAC_PORT_CPU, REG_ARRAY_INDEX_NONE, RTL9603CVD_PADDING_ENf, &enable), RT_ERR_OK);
	//allow receiving packet which smaller than 64 bytes
	ASSERT_EQ(reg_array_field_write(RTL9603CVD_P_MISCr, RTK_FC_MAC_PORT_CPU, REG_ARRAY_INDEX_NONE, RTL9603CVD_RX_SPCf, &enable), RT_ERR_OK);
#endif

#endif

	return 0;
}

static int _rtl9607c_fc_lut_init(void)
{
	int i;
	uint32 regValue;
	rtk_portmask_t mbpmsk;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM) 
	ASSERT_EQ_CONT(rtk_l2_camState_set(ENABLED), RT_ERR_OK);
#endif

	rtk_l2_lookupMissAction_set(DLF_TYPE_BCAST,ACTION_FOLLOW_FB);

	// unknown DA flooding setting: trap to CPU
	mbpmsk.bits[0]=1U<<RTK_FC_MAC_PORT_MAINCPU;
	rtk_l2_lookupMissFloodPortMask_set(DLF_TYPE_MCAST,&mbpmsk);		//set multicast flooding port
	rtk_l2_lookupMissFloodPortMask_set(DLF_TYPE_BCAST,&mbpmsk);		//set broadcast
	rtk_l2_lookupMissFloodPortMask_set(DLF_TYPE_UCAST,&mbpmsk);		//set unicast unknown DA flooding mask
	rtk_l2_lookupMissAction_set(DLF_TYPE_UCAST, ACTION_FORWARD);		//set unicast unknown DA action as FORWARD to CPU, to prevent strom control fail issue

	//Turn off Lut auto-learning, set unknown SA and port-move trap
	for(i=0;i<RTK_FC_MAC_PORT_MAX;i++)
	{
		if(RTK_FC_ALL_MAC_CPU_PORTMASK & (1ULL<<i)) {
			//Turn off CPU port LUT auto-learning, and set Action to Forward
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNT_SET(i,0),RT_ERR_OK);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			//ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_FORWARD),RT_ERR_OK);
			ASSERT_EQ_CONT(RTK_L2_ILLEGALPORTMOVEACTION_SET(i,ACTION_FORWARD),RT_ERR_OK);
#else
#if defined(CONFIG_RTK_SOC_RTL8198D)
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_FORWARD),RT_ERR_OK);
#else
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_TO_CPU),RT_ERR_OK);
#endif
			// For VXLAN/NPTv6 Sram mode usage: To prevent portmoving from cpu-port.
			ASSERT_EQ_CONT(RTK_L2_ILLEGALPORTMOVEACTION_SET(i, ACTION_FORWARD), RT_ERR_OK);
#endif
		}else {
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			if(fc_db.controlFuc.loopbackMode_is_enabled)
			{
				if((i == RTK_FC_MAC_PORT6) || (i == RTK_FC_MAC_PORT6))
					continue; // port 5 and port 6 is invalid in switch when loopback mode is enabled
			}
#endif
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNT_SET(i,0),RT_ERR_OK);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			// G3 use L3FE CLS as ACL rule, so we expect no L2 trap happens before ACL.
			// in such design, adding hw l2 entry is no necessary. that means no unknown sa, no unmatch vlan, no port moving.
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_FORWARD),RT_ERR_OK);
			ASSERT_EQ_CONT(RTK_L2_ILLEGALPORTMOVEACTION_SET(i,ACTION_FORWARD),RT_ERR_OK);
#else
#if defined(CONFIG_RTK_SOC_RTL8198D)
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_FORWARD),RT_ERR_OK);
#else
			ASSERT_EQ_CONT(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_TO_CPU),RT_ERR_OK);
#endif
			ASSERT_EQ_CONT(RTK_L2_ILLEGALPORTMOVEACTION_SET(i,ACTION_TRAP2CPU),RT_ERR_OK);
#endif
		}

		// disable lut aging
		ASSERT_EQ_CONT(RTK_L2_PORTAGINGENABLE_SET(i, DISABLED), RT_ERR_OK);

#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_CA8277AB_SERIES)	// not support in 8277C
		ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_BCAST,ACTION_FORWARD),RT_ERR_RG_OK);
		ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_UCAST,ACTION_FORWARD),RT_ERR_RG_OK);

#if defined(CONFIG_RTK_L34_G3_PLATFORM)		
		ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_BCAST,ACTION_FORWARD),RT_ERR_RG_OK);
#else
		// trap by L34 flow miss instead of switch flood to cpu port
		ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_BCAST,ACTION_FOLLOW_FB),RT_ERR_RG_OK);
#endif
		ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_UCAST,ACTION_FORWARD),RT_ERR_RG_OK);
#endif
	}

	//Flush all unicast LUT may be learned by hardware
	ASSERT_EQ_CONT(rtk_l2_addr_delAll(ENABLED),RT_ERR_OK);

	// arp used as known
	regValue = 0x1U;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(CHIP_ID_9607C) {
		ASSERT_EQ_CONT(reg_field_write(RTL9607C_LUT_CFGr, RTL9607C_LUT_L34_ARP_USAGE_AS_KNOWNf, &regValue),RT_ERR_OK);	
	}else {
		ASSERT_EQ_CONT(reg_field_write(RTL9603CVD_LUT_CFGr, RTL9603CVD_LUT_L34_ARP_USAGE_AS_KNOWNf, &regValue),RT_ERR_OK);
	}
#elif defined(CONFIG_FC_RTL9607C_SERIES)
	ASSERT_EQ_CONT(reg_field_write(RTL9607C_LUT_CFGr, RTL9607C_LUT_L34_ARP_USAGE_AS_KNOWNf, &regValue),RT_ERR_OK);
#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
	ASSERT_EQ_CONT(reg_field_write(RTL9603CVD_LUT_CFGr, RTL9603CVD_LUT_L34_ARP_USAGE_AS_KNOWNf, &regValue),RT_ERR_OK);
#endif

#endif

	return 0;
}

static int _rtl9607c_fc_svlan_init(void)
{

	int i;
	rtk_portmask_t svlanmbr;

	fc_db.systemGlobal.ifstagTPID1_enabled = FALSE;
	fc_db.systemGlobal.stagTPID[0] = ETH_P_8021AD;
	fc_db.systemGlobal.stagTPID[1] = 0x8888U;
	
	rtk_svlan_tpidEnable_set(0U, ENABLED);
	rtk_svlan_tpidEntry_set(0, fc_db.systemGlobal.stagTPID[0]);
	rtk_svlan_tpidEnable_set(1U, DISABLED);
	rtk_svlan_tpidEntry_set(1, fc_db.systemGlobal.stagTPID[1]);

	rtk_svlan_svlanFunctionEnable_set(DISABLED);

	for(i = RTK_FC_MAC_PORT0; i < RTK_FC_MAC_PORT_MAX; i++)
		RTK_SVLAN_SERVICEPORT_SET(i, ENABLED);

	// change default action from drop to port-based.
	rtk_svlan_untagAction_set(SVLAN_ACTION_PSVID, 0U);

	 // for switch behavior: port base vlan transparent, used by hybrid mode lan-lan forwarding
	rtk_svlan_create(0U);
	svlanmbr.bits[0] = fc_db.systemGlobal.phyPortStatus;
	rtk_svlan_memberPort_set(0U, &svlanmbr, &svlanmbr);

	rtk_fc_gmac_svlan_tpid_enable(fc_db.systemGlobal.stagTPID[0], 0);
	rtk_fc_gmac_svlan_tpid_enable(fc_db.systemGlobal.stagTPID[1], 1);

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	// DMA_LSO SVLAN TPID config
	rtk_dma_lso_reg_write(0x800088a8, DMA_SEC_DMA_GLB_DMA_LSO_VLAN_TAG_TYPE0);
#endif

	return 0;
}

static int _rtl9607c_fc_cvlan_init(void)
{

#if !defined(CONFIG_RTK_L34_G3_PLATFORM)	// vlan disabling is not fully supported in CA platform
	rtk_portmask_t mbr, untag;
	int i;

	rtk_vlan_vlanFunctionEnable_set(DISABLED);

	/* Clear all vlan table setting */
	rtk_vlan_destroyAll(0U);
	/* Configure Vlan Table for LAN */
	mbr.bits[0] = (1U<<RTK_FC_MAC_PORT0) | (1U<<RTK_FC_MAC_PORT1) | (1U<<RTK_FC_MAC_PORT2) | (1U<<RTK_FC_MAC_PORT3) | (1U<<RTK_FC_MAC_PORT4) \
		| (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE0) | (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE1) | (1U<<RTK_FC_MAC_PORT_SLAVECPU);
	untag.bits[0] = (1U<<RTK_FC_MAC_PORT0) | (1U<<RTK_FC_MAC_PORT1) | (1U<<RTK_FC_MAC_PORT2) | (1U<<RTK_FC_MAC_PORT3) | (1U<<RTK_FC_MAC_PORT4) \
		| (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE0) | (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE1) | (1U<<RTK_FC_MAC_PORT_SLAVECPU);
	rtk_vlan_create(LAN_VID);
	rtk_vlan_port_set(LAN_VID,&mbr,&untag);
	mbr.bits[0] = (1U<<FC_EXT_PORT_LIST_MAX)-1U;
	//ASSERT_EQ(rtk_vlan_extPort_set(LAN_VID,&mbr);
	rtk_vlan_extPortmaskCfg_set(0U,&mbr);
	rtk_vlan_extPortmaskIndex_set(LAN_VID, 0U);
	rtk_vlan_fidMode_set(LAN_VID,VLAN_FID_SVL);
	rtk_vlan_fid_set(LAN_VID, DEFAULT_FID);

	/* Configure Vlan Table for WAN */
	mbr.bits[0] = (1U<<RTK_FC_MAC_PORT_PON) | (1U<<RTK_FC_MAC_PORT_RGMII) | (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE0) \
		| (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE1) | (1U<<RTK_FC_MAC_PORT_SLAVECPU);
	untag.bits[0] = (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE0) | (1U<<RTK_FC_MAC_PORT_MASTERCPU_CORE1) | (1U<<RTK_FC_MAC_PORT_SLAVECPU);
	//untag.bits[0] = 0x0;
	rtk_vlan_create(WAN_VID);
	rtk_vlan_port_set(WAN_VID,&mbr,&untag);
	mbr.bits[0] = (1U<<FC_EXT_PORT_LIST_MAX)-1U;
	//ASSERT_EQ(rtk_vlan_extPort_set(WAN_VID,&mbr);
	rtk_vlan_extPortmaskCfg_set(1U,&mbr);
	rtk_vlan_extPortmaskIndex_set(WAN_VID, 1U);
	rtk_vlan_fidMode_set(WAN_VID,VLAN_FID_SVL);
	rtk_vlan_fid_set(WAN_VID, DEFAULT_FID);


	/* Configure Port based VLAN ID register */

	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT0,LAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT1,LAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT2,LAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT3,LAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT4,LAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT_PON,WAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT_RGMII,WAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT_MASTERCPU_CORE0,WAN_VID);
	RTK_VLAN_PORTPVID_SET(RTK_FC_MAC_PORT_MASTERCPU_CORE1,WAN_VID);
	for(i = 0; i < FC_EXT_PORT_LIST_MAX; i++)
		rtk_vlan_extPortPvid_set(i, LAN_VID);
#else
	rtk_vlan_vlanFunctionEnable_set(DISABLED);
#endif

	return 0;
}

/* Lut learning callback func */
int rtk_fc_rtl9607c_API_lut_add(void* input_data)
{
	int ret = RTK_FC_RET_OK;
	rtk_fc_lut_entry_t *pLutEntry = (rtk_fc_lut_entry_t *)input_data;

	if(pLutEntry->l2Addr[0]&0x1)
	{

		rtk_l2_mcastAddr_t mcastAddr;
		memset(&mcastAddr,0,sizeof(mcastAddr));
		mcastAddr.portmask.bits[0]=0U;
		mcastAddr.ext_portmask_idx=31U;
		mcastAddr.vid =pLutEntry->CVID;
		mcastAddr.fid = pLutEntry->svl_fid;
		memcpy(&mcastAddr.mac.octet, &pLutEntry->l2Addr, ETH_ALEN);
		ret=rtk_l2_mcastAddr_add(&mcastAddr);
		if(ret==RT_ERR_OK){
			TABLE("Add MC LUT[%d]",  mcastAddr.index);
			pLutEntry->lutIdx = mcastAddr.index;
		}
		else{
			TABLE("Fail to add mac %pM to LUT table, rtk_ret = 0x%x", pLutEntry->l2Addr, ret);
		}
	}
	else
	{
		rtk_l2_ucastAddr_t l2Addr;

		memset(&l2Addr, 0, sizeof(l2Addr));

		l2Addr.flags|=RTK_L2_UCAST_FLAG_ARP_USED;
		l2Addr.fid = pLutEntry->svl_fid;
		l2Addr.age = 7U;
		l2Addr.port = pLutEntry->spa;
		l2Addr.ext_port = pLutEntry->extspa;
		if(pLutEntry->CTAG_IF)
		{
			l2Addr.flags|=RTK_L2_UCAST_FLAG_CTAG_IF;
		}
		else
		{
			l2Addr.flags&=(~RTK_L2_UCAST_FLAG_CTAG_IF);
		}
		l2Addr.vid = pLutEntry->CVID;

		// Hw lut aging is enabled in hybrid mode, so we need to set lut to static
		l2Addr.flags|=RTK_L2_UCAST_FLAG_STATIC;

		memcpy(&l2Addr.mac.octet, &pLutEntry->l2Addr, ETH_ALEN);

		ret = rtk_l2_addr_add(&l2Addr);

		if(ret==RT_ERR_OK){			
			TABLE("Add LUT[%d] MAC %pM SPA %d EXTSPA %d CTAGIF %d VID %d", l2Addr.index, &l2Addr.mac.octet[0], l2Addr.port, l2Addr.ext_port, (l2Addr.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?TRUE:FALSE, l2Addr.vid);
			pLutEntry->lutIdx = l2Addr.index;
		}
		else{
			TABLE("Fail to add mac %pM to LUT table, rtk_ret = 0x%x", pLutEntry->l2Addr, ret);
		}
	}
	if(ret==RT_ERR_OK)
		ret = RTK_FC_RET_OK;
	else if(ret==RT_ERR_ENTRY_FULL)
		ret = RTK_FC_RET_ERR_ENTRY_FULL;
	else
		ret = RTK_FC_RET_ERR;

	return ret;
}

int rtk_fc_rtl9607c_API_lut_del(void* input_data)
{
	rtk_fc_lut_entry_t *pLutEntry = (rtk_fc_lut_entry_t *)input_data;
	uint8 *mac = &pLutEntry->l2Addr[0];
	int ret = RT_ERR_OK, delLutDirectly=TRUE;
	rtk_l2_ucastAddr_t l2UcAddr;
	rtk_l2_mcastAddr_t l2McAddr;


	TABLE("Del LUT mac = %pM", mac);

	if((mac[0]&0x1)==0x0)
	{
		if(fc_db.hypridPPTP.portmask)
		{
			bzero(&l2UcAddr, sizeof(l2UcAddr));
			l2UcAddr.fid = pLutEntry->svl_fid;
			memcpy(&l2UcAddr.mac.octet, mac, ETH_ALEN);

			ret = rtk_l2_addr_get(&l2UcAddr);
			if(ret == RT_ERR_OK)
			{
				//Because this lut entry may be used by HW PPTP, we just disable its static and set its age to 2 for short timeout.
				if((0x1ULL<<l2UcAddr.port) & fc_db.wanPortMask.portmask)
				{
					TABLE("Disable static flag of lut[%d] and set its age to 2", l2UcAddr.index);
					l2UcAddr.flags &= (~RTK_L2_UCAST_FLAG_STATIC);
					l2UcAddr.flags &= (~RTK_L2_UCAST_FLAG_ARP_USED);
					l2UcAddr.age = 2U;
					ret = rtk_l2_addr_add(&l2UcAddr);
					delLutDirectly = FALSE;
				}
			}
			else
			{
				WARNING("[Fail to del hw lut] ret=%d MAC=%pM does not exist!", ret, mac);
				return RTK_FC_RET_ERR;
			}
		}
		if(delLutDirectly)
		{
			bzero(&l2UcAddr, sizeof(l2UcAddr));
			l2UcAddr.fid = pLutEntry->svl_fid;
			memcpy(&l2UcAddr.mac.octet, mac, ETH_ALEN);

			ret = rtk_l2_addr_del(&l2UcAddr);
		}
	}
	else
	{
		bzero(&l2McAddr, sizeof(l2McAddr));
		l2McAddr.fid = pLutEntry->svl_fid;
		memcpy(&l2McAddr.mac.octet, mac, ETH_ALEN);

		ret = rtk_l2_mcastAddr_del(&l2McAddr);
	}

	if(ret!=RT_ERR_OK)
	{
		WARNING("[Fail to del hw lut] ret=%d MAC=%pM", ret, mac);
		return RTK_FC_RET_ERR;
	}
	else
		return RTK_FC_RET_OK;
}

int rtk_fc_rtl9607c_API_lut_query(unsigned char *mac, int *lutIdx)
{
	int ret = 0;
	rtk_l2_ucastAddr_t l2UcAddr;
	rtk_l2_mcastAddr_t l2McAddr;


	if((mac[0]&0x1)==0x0)
	{
		bzero(&l2UcAddr, sizeof(l2UcAddr));
		l2UcAddr.fid = DEFAULT_FID;
		memcpy(&l2UcAddr.mac.octet, mac, ETH_ALEN);

		ret = rtk_l2_addr_get(&l2UcAddr);
		if(ret == RT_ERR_OK)
			*lutIdx = l2UcAddr.index;
	}
	else
	{
		bzero(&l2McAddr, sizeof(l2McAddr));
		l2McAddr.fid = DEFAULT_FID;
		memcpy(&l2McAddr.mac.octet, mac, ETH_ALEN);
		ret = rtk_l2_mcastAddr_get(&l2McAddr);
		if(ret == RT_ERR_OK)
			*lutIdx = l2McAddr.index;
	}

	return ret;
}



int rtk_fc_rtl9607c_API_init(void)
{
	int ret = 0;

	//printk("========== RTK FleetConntrack Driver Init ==========\n");

#ifdef __KERNEL__
	ASSERT_EQ(rtk_init_without_pon(),RT_ERR_OK);
#else
	ASSERT_EQ(rtk_init(),RT_ERR_OK);
#endif

	ASSERT_EQ(rtk_l2_init(), RT_ERR_OK);

	if((ret = _rtl9607c_fc_port_init()) != RTK_FC_RET_OK) {
		printk("HWNAT global state init failed: %x\n", ret);
		goto ERROR;
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	{
		uint32 flowMode = FB_MODE_32K;
#if defined(CONFIG_FC_FLOWBASED_DYN_MAX_32K)
		flowMode = FB_MODE_32K;
#elif defined(CONFIG_FC_FLOWBASED_DYN_MAX_16K)
		flowMode = FB_MODE_16K;
#elif defined(CONFIG_FC_FLOWBASED_DYN_MAX_8K)
		flowMode = FB_MODE_8K;
#elif defined(CONFIG_FC_FLOWBASED_DYN_MAX_4K)
		flowMode = FB_MODE_4K;
#endif

		if((ret = _rtk_rg_fbMode_set(flowMode)) != RTK_FC_RET_OK) {
			printk("HWNAT init failed: %x\n", ret);
			goto ERROR;
		}
	}
#endif

	if((ret = _rtl9607c_fc_lut_init()) != RTK_FC_RET_OK) {
		printk("HWNAT init failed: %x\n", ret);
		goto ERROR;
	}

	if((ret = _rtl9607c_fc_global_state_init()) != RTK_FC_RET_OK) {
		printk("HWNAT global state init failed: %x\n", ret);
		goto ERROR;
	}

	if((ret = _rtl9607c_fc_cvlan_init()) != RTK_FC_RET_OK) {
		printk("HWNAT cvlan init failed: %x\n", ret);
		goto ERROR;
	}

	if((ret = _rtl9607c_fc_svlan_init()) != RTK_FC_RET_OK) {
		printk("HWNAT global state init failed: %x\n", ret);
		goto ERROR;
	}


#if !defined(CONFIG_RTK_L34_G3_PLATFORM)
	if((ret = rtk_rg_asic_hsbaMode_set(L34_HSBA_LOG_ALL)) != RTK_FC_RET_OK)
	{
		printk("HWNAT global state init failed: %x\n", ret);
		goto ERROR;
	}
#endif

	rtk_fc_tableReset();

ERROR:
	return ret;
}

#endif

#if defined(CONFIG_RTK_L34_G3_PLATFORM)

int rtk_fc_flow_tuple_init(void)
{
	ca_status_t ca_ret;
	rtk_rg_flow_key_mask_t flowKeyMask;

	bzero(&flowKeyMask, sizeof(flowKeyMask));

	flowKeyMask.P12_spa = fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA];
	flowKeyMask.P12_vlanId = fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID] ? FALSE : TRUE;
	flowKeyMask.P12_vlanPri = (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI] && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI]) ? FALSE : TRUE;
	flowKeyMask.P345_vlanId = fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID] ? FALSE : TRUE;
	flowKeyMask.P345_vlanPri = (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI] && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI]) ? FALSE : TRUE;
	flowKeyMask.pall_vlan_deicfi = fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI] ? FALSE : TRUE;
	flowKeyMask.p12_stream_id = fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_STREAM_IDX];
	flowKeyMask.p345_stream_id = fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX];
	flowKeyMask.p12_ethtype = fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL];
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS]==ENABLED)
	{
		flowKeyMask.P345_dscp = TRUE;
		flowKeyMask.P345_ecn = fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS];
	}
	else
	{
		flowKeyMask.P345_dscp = FALSE;
		flowKeyMask.P345_ecn = FALSE;
	}
	ca_ret = rtk_rg_g3_flow_init(flowKeyMask);
	if(ca_ret!=CA_E_OK)
	{
		WARNING("Fail to initialize G3 flow, ca_ret=0x%x", ca_ret);
		return RT_ERR_RG_FAILED;
	}

#if defined(CONFIG_FC_RTL8277C_SERIES)
	{
		bool if_cache_age0_hit = FALSE;
		ca_ret = aal_hash_cache_age0_hit_get(&if_cache_age0_hit);
		if(ca_ret != AAL_E_OK)
		{
			WARNING("Fail to get hash cache age0 hit state, ca_ret=0x%x", ca_ret);
			return RT_ERR_RG_FAILED;
		}
		if(if_cache_age0_hit)
			fc_db.controlFuc.if_hash_cache_age0_hit = TRUE;
		else
			fc_db.controlFuc.if_hash_cache_age0_hit = FALSE;
	}
#endif
	return ca_ret;
}
int rtk_fc_ca_API_lut_add(void* input_data)
{
	int ret = RTK_FC_RET_OK;
	rtk_fc_lut_entry_t *pLutEntry = (rtk_fc_lut_entry_t *)input_data;

#if defined(CONFIG_FC_CA8277AB_SERIES)
	uint32 hwL2Idx;
	ca_l2_addr_entry_t addr;

	if(pLutEntry->l2Addr[0]&0x1) {
		// pure software lut for multicast mac
		return RTK_FC_RET_OK;
	}
	
	memset(&addr, 0, sizeof(addr));
	memcpy(addr.mac_addr, &pLutEntry->l2Addr, ETH_ALEN);

	addr.static_flag = 1;	// prevent hw overwriting
	
	addr.vid = pLutEntry->CVID;
	addr.fwd_vid = pLutEntry->CVID;

	addr.sa_permit = 1;
	addr.da_permit = 1;
	addr.port_id = pLutEntry->spa;
	
	if(pLutEntry->l2Addr[0]&0x1)
		addr.mc_group_id = 0;
	else
		addr.mc_group_id = CA_UINT32_INVALID;

	ret = ca_l2_addr_add(CA_DEF_DEVID,&addr);

		
	if(ret==CA_E_OK){
	
		if(_rtk_fc_hw_lut_idx_get(&pLutEntry->l2Addr[0], pLutEntry->svl_fid, &hwL2Idx)!=RT_ERR_OK) {
			WARNING("FIXME: Fail to get mac %pM from LUT table", pLutEntry->l2Addr);
			ret = RTK_FC_RET_ERR;
		} else {
			pLutEntry->lutIdx = hwL2Idx;
			
			TABLE("Add LUT[%d] MAC %pM SPA %d CTAGIF %d VID %d", hwL2Idx, &pLutEntry->l2Addr[0], pLutEntry->spa, pLutEntry->CTAG_IF, pLutEntry->CVID);

			ret = RTK_FC_RET_OK;
		}
	}else if(ret == CA_E_FULL) {
		TABLE("RTK_FC_RET_ERR_ENTRY_FULL");
		ret = RTK_FC_RET_ERR_ENTRY_FULL;
	}else {
		WARNING("Fail to add mac %pM, ret = 0x%x, hashidx = %d", pLutEntry->l2Addr, ret, _rtk_fc_hash_mac_fid(&addr.mac_addr[0], 0) << RTK_FC_LUT_HASH_WAY_SHIFT);
	} 
#else

	if(pLutEntry->l2Addr[0]&0x1)
	{
		ca_uint32_t addr=0;
		aal_fdb_entry_cfg_t   fdbEntry;
		memset(&fdbEntry, 0, sizeof(aal_fdb_entry_cfg_t));
		memcpy(fdbEntry.mac,pLutEntry->l2Addr,sizeof(ca_mac_addr_t));
		
		fdbEntry.static_flag	= 1;
		fdbEntry.sa_permit		= 1;
		fdbEntry.da_permit		= 1;
		fdbEntry.port_id		= pLutEntry->spa;
		if((ret = aal_fdb_entry_add(0,&fdbEntry))!=CA_E_OK)
		{
			TABLE("table aal_fdb_entry_add Error ret=%d",ret);
			return RTK_FC_RET_ERR;
		}
		/*Get FDB table address*/
		if(CA_E_OK == aal_fdb_entry_offset_get(0, fdbEntry.mac, 
			fdbEntry.key_vid, fdbEntry.dot1p, &addr))
		{
			pLutEntry->lutIdx  = addr;
		}


	}
	else
	{
		rtk_l2_ucastAddr_t l2Addr;

		memset(&l2Addr, 0, sizeof(l2Addr));

		l2Addr.flags|=RTK_L2_UCAST_FLAG_ARP_USED;
		l2Addr.fid = pLutEntry->svl_fid;
		l2Addr.age = 7;
		l2Addr.port = pLutEntry->spa;
		l2Addr.ext_port = pLutEntry->extspa;
		if(pLutEntry->CTAG_IF)
		{
			l2Addr.flags|=RTK_L2_UCAST_FLAG_CTAG_IF;
		}
		else
		{
			l2Addr.flags&=(~RTK_L2_UCAST_FLAG_CTAG_IF);
		}
		l2Addr.vid = pLutEntry->CVID;

		// Hw lut aging is enabled in hybrid mode, so we need to set lut to static
		l2Addr.flags|=RTK_L2_UCAST_FLAG_STATIC;

		memcpy(&l2Addr.mac.octet, &pLutEntry->l2Addr, ETH_ALEN);

		/*dal_rtl8277c_l2_addr_add*/
		ret = rtk_l2_addr_add(&l2Addr); 
		
		if(ret==RT_ERR_OK){ 		
			TABLE("Add LUT[%d] MAC %pM SPA %d EXTSPA %d CTAGIF %d VID %d", l2Addr.index, &l2Addr.mac.octet[0], l2Addr.port, l2Addr.ext_port, (l2Addr.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?TRUE:FALSE, l2Addr.vid);
			pLutEntry->lutIdx = l2Addr.index;
		}
		else{
			TABLE("Fail to add mac %pM to LUT table, rtk_ret = 0x%x", pLutEntry->l2Addr, ret);
		}

	}

		
	if(ret==RT_ERR_OK)
		ret = RTK_FC_RET_OK;
	else if(ret==RT_ERR_ENTRY_FULL)
		ret = RTK_FC_RET_ERR_ENTRY_FULL;
	else
		ret = RTK_FC_RET_ERR;
#endif

	return ret;
}
int rtk_fc_ca_API_lut_del(void* input_data)
{	
	rtk_fc_lut_entry_t *pLutEntry = (rtk_fc_lut_entry_t *)input_data;
	uint8 *mac = &pLutEntry->l2Addr[0];
	int ret = RTK_FC_RET_OK;
	
#if defined(CONFIG_FC_CA8277AB_SERIES)
	ca_l2_addr_entry_t addr;

	if(mac[0]&0x1) {
		// pure software lut for multicast mac
		return RTK_FC_RET_OK;
	}

	memset(&addr, 0, sizeof(addr));
	memcpy(addr.mac_addr, mac, ETH_ALEN);

	if((ret = ca_l2_addr_get(CA_DEF_DEVID, addr.mac_addr, pLutEntry->svl_fid, &addr))!=CA_E_OK)
	{
		WARNING("Fail to get mac %pM, ret = 0x%x", mac, ret);
		return RTK_FC_RET_ERR;
	}
	
	TABLE("Del LUT mac = %pM", mac);
	
	if((ret = ca_l2_addr_delete(CA_DEF_DEVID, &addr))!=CA_E_OK)
	{
		WARNING("Fail to del mac %pM, ret = 0x%x", mac, ret);
		return RTK_FC_RET_ERR;
	}
#else
	if(mac[0]&0x1) 
	{
		aal_fdb_entry_cfg_t   fdb_entry;
		memset(&fdb_entry,0,sizeof(aal_fdb_entry_cfg_t));

		ret = aal_fdb_entry_get(0,mac,0,&fdb_entry);
        if(ret)
        {
			TABLE("mac = %pM aal_fdb_entry_get fail ret=%d",mac,ret);
			return RTK_FC_RET_ERR;
        }
		ret = aal_fdb_entry_del(0, &fdb_entry);
        if(ret)
        {
			TABLE("mac = %pM aal_fdb_entry_del fail ret=%d",mac,ret);
			return RTK_FC_RET_ERR;
        }		
	}
	else
	{
		rtk_l2_ucastAddr_t l2UcAddr;

		bzero(&l2UcAddr, sizeof(l2UcAddr));
		l2UcAddr.fid = pLutEntry->svl_fid;
		memcpy(&l2UcAddr.mac.octet, mac, ETH_ALEN);

		//dal_rtl8277c_l2_addr_del
		ret = rtk_l2_addr_del(&l2UcAddr);
	}
#endif

	return ret;
}
int rtk_fc_ca_API_lut_query(unsigned char *mac, int *lutIdx)
{
	uint32 hwL2Idx;

	if(_rtk_fc_hw_lut_idx_get(mac, DEFAULT_FID, &hwL2Idx)!=RT_ERR_OK) {
		WARNING("FIXME: Fail to get mac %pM from LUT table", mac);
		return RTK_FC_RET_ERR;
	} else {
		*lutIdx = hwL2Idx;
		
		TABLE("Find mac %pM from LUT[%d]", mac, hwL2Idx);
	}

	return RTK_FC_RET_OK;
}
int rtk_fc_ca_API_init(void)
{
	rtk_fc_rtl9607c_API_init();

	rtk_asic_init();

#if defined(CONFIG_FC_CA8277AB_SERIES)
#if defined(CONFIG_FC_CAG3_SERIES)
	if(fc_db.controlFuc.loopbackMode_is_enabled)
		ASSERT_EQ_CONT(rtk_rg_g3_l2fe_hostpolicing_init(), RT_ERR_RG_OK);
#endif
	if(fc_db.controlFuc.port4_hsgmii_en) {
		rtk_rg_asic_l3qm_p4_init();
	}
#endif
	
	rtk_fc_flow_tuple_init();

	/*************************
	 * CPU Port 0x12~0x17 for wifi
	 *************************/
	ASSERT_EQ_CONT(rtk_rg_g3_cpuport_init(), CA_E_OK);

	//unkwon-da trap
	ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_FC_MAC_PORT0,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_FC_MAC_PORT1,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_FC_MAC_PORT2,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_FC_MAC_PORT3,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ_CONT(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_FC_MAC_PORT_PON,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);

	//rtk_ne_reg_write(0xa0000000, L3FE_FE_L3E_HS_CACHE_MISC);

#if defined(CONFIG_FC_CA8277B_SERIES)
{
	uint32 status;
	aal_port_physical_port_enable_get(CA_DEF_DEVID, ASIC_LPORT_ETH_NI6, &status);
	if(status) {
		fc_db.controlFuc.p6_xfi_en = TRUE;
		fc_db.controlFuc.p7_rxsel_l3fe = TRUE;
	}
	rtk_8277b_asic_ni_p7_rxsel_l3fe(fc_db.controlFuc.p7_rxsel_l3fe);
}
#endif

	return RTK_FC_RET_OK;
}

int rtk_fc_pf_exit(void)
{
	rtk_asic_exit();

	return SUCCESS;
}
#endif


static int _rtk_fc_extPMask_init(void)
{
	int i;

	// Init table
	for(i = 0; i < RTK_FC_TABLESIZE_EXTPORT; i++)
	{
		bzero(&fc_db.extPortTbl[i], sizeof(rtk_fc_tableExtPort_t));
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_rg_asic_table_reset(FB_RST_EXT_PMASK_TYPE);
#endif

	return SUCCESS;
}

#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac
static int _rtk_fc_indMac_addr_init(void)
{
	int i;

	// Init table
	for(i = 0; i < RTK_FC_TABLESIZE_INDMAC; i++)
	{
		bzero(&fc_db.indMacTbl[i], sizeof(rtk_fc_tableIndMac_t));
	}

	// Init list
	for(i=0; i<RTK_FLOWBASE_BUCKETSIZE_INDMAC; i++)
		INIT_LIST_HEAD(&fc_db.listHead_indMacHash[i]);


#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_rg_asic_table_reset(FB_RST_MAC_INDEX_TBL);
#endif

	return SUCCESS;
}

// input: l2 address
// output: indMac table index
static int _rtk_fc_indMac_addr_ref(rtk_l2_ucastAddr_t *l2Addr, int *index)
{
	int ret=RTK_FC_RET_OK;
	int i;
	rtk_fc_tableIndMac_t *entry = NULL;


	for(i=0;i<RTK_FC_TABLESIZE_INDMAC;i++)
	{
		if((fc_db.indMacTbl[i].valid==0U) || (fc_db.indMacTbl[i].indMacRefCount == 0U))
		{
			entry = &fc_db.indMacTbl[i];
			break;
		}
	}

	if(i == RTK_FC_TABLESIZE_INDMAC)
	{
		DEBUG("Indirect MAC table full!");
		return RTK_FC_RET_ERR_ENTRY_FULL;
	}

	if(entry != NULL)
	{
		if(entry->valid==0){
			// new empty entry
			memset(entry,0,sizeof(rtk_fc_tableIndMac_t));
			entry->hwIdx = i;
		}else if(fc_db.indMacTbl[i].indMacRefCount == 0U){
			// replace old entry
			list_del(&entry->hashList);
			memset(entry,0,sizeof(rtk_fc_tableIndMac_t));
			entry->hwIdx = i;
		}
		INIT_LIST_HEAD(&entry->hashList);
		list_add_tail(&entry->hashList, &fc_db.listHead_indMacHash[l2Addr->mac.octet[5]&(RTK_FLOWBASE_BUCKETSIZE_INDMAC-1)]);
		// Sync. to H/W
		entry->indMac.l2_idx = l2Addr->index;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		ret = rtk_rg_asic_indirectMacTable_add(i, &entry->indMac);
#endif
		if(ret!=RTK_FC_RET_OK)
		{
			DEBUG("Add H/W indirect mac table failed!");
			return ret;
		}else
			TABLE("Add indMac[%d] -> l2: %d", entry->hwIdx, entry->indMac.l2_idx);
		entry->valid = TRUE;
		*index = i;
	}

	return RTK_FC_RET_OK;
}


int rtk_fc_indMac_idx_get(unsigned int l2Idx, int *indMacIdx)
{
	int ret = RTK_FC_RET_OK;
	int index=SIGNED_INVALID;
	rtk_fc_tableIndMac_t *pIndMacEntry;
	rtk_l2_addr_table_t l2Addr;
	int hashing;

	FC_PARAM_CHK(l2Idx>=RTK_FC_TABLESIZE_LUT, RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);
	
	if(unlikely(fc_db.lutTbl[l2Idx] == NULL)){
		WARNING("lut entry[%d] is not exist!\n", l2Idx);
		return RTK_FC_RET_ERR_NULL_POINTER;
	}

	// search exist entry
	hashing = (fc_db.lutTbl[l2Idx]->l2Addr[5]&(RTK_FLOWBASE_BUCKETSIZE_INDMAC-1));
	// find exist entry
	list_for_each_entry(pIndMacEntry, &fc_db.listHead_indMacHash[hashing], hashList)
	{
		if(l2Idx == pIndMacEntry->indMac.l2_idx)
		{
			index = pIndMacEntry->hwIdx;
			break;
		}
	}
	
	// miss: try to add a new one
	if(index == SIGNED_INVALID) {
		
		bzero(&l2Addr, sizeof(l2Addr));

		if(fc_db.lutTbl[l2Idx]){
			memcpy(&l2Addr.entry.l2UcEntry.mac.octet[0], fc_db.lutTbl[l2Idx]->l2Addr, ETH_ALEN);
			l2Addr.entry.l2UcEntry.index = l2Idx;
		}
		
		if((ret = _rtk_fc_indMac_addr_ref(&l2Addr.entry.l2UcEntry, &index)) != RTK_FC_RET_OK)
			return ret;
	}

	*indMacIdx = index;

	return ret;
}
#endif

// prepare sw netif info from net_device
static int _rtk_fc_netif_sw_add(rtk_fc_tableNetif_t *netifTable, struct net_device *dev)
{
	int ret = 0;
	struct inet6_dev *in6_dev;
	int ipAddr = 0;
	uint32 global_ipv6_addr_set = 0U;
	unsigned int mtu;
	uint8 *pMac = NULL;
	int16 macL2Idx = 0;
	int16 lutidx;

	if(!netifTable || !dev)
	{
		WARNING("NULL pointer");
		return FAILED;

	}

	RTK_FC_HELPER_RCU_READ_LOCK();

	RTK_FC_HELPER_RCU_INDEV_GET_IPADDR(dev, &ipAddr);

	pMac = &netifTable->intf.gateway_mac_addr.octet[0];

	netifTable->global_ipv6_addr_set = 0U;
	netifTable->pppoe_synced = 0U;

	
	//in6_dev = __in6_dev_get(dev);
	RTK_FC_HELPER_RCU_IN6_DEV_GET(dev, &in6_dev);
	if(in6_dev != NULL)
	{
		RTK_FC_HELPER_NETDEV_IFA_GLOBAL_ADDR6_SET(in6_dev, &global_ipv6_addr_set);
		netifTable->global_ipv6_addr_set = global_ipv6_addr_set;
	}

	RTK_FC_HELPER_RCU_READ_UNLOCK();

	// clear interface mac is necessary for ppp dev.
	if(netifTable->lutIdx != SIGNED_INVALID)
		_rtk_fc_lut_staticEntry_del(netifTable->lutIdx);

	bzero(&netifTable->intf.gateway_mac_addr.octet[0], sizeof(rtk_mac_t));

	RTK_FC_HELPER_NETDEV_SET_NFTABLE_MACADDR(dev, netifTable->intf.gateway_mac_addr.octet);

	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(dev, &mtu, RTK_FC_NETDEV_GET_MTU);

	if(!netifTable->intf.valid) {
		RTK_FC_HOOK_PS_DEV_DEV_HOLD(dev);
		netifTable->intf.valid = 1U;
	}
	netifTable->intf.gateway_ipv4_addr = ipAddr;
	netifTable->intf.intf_mtu_check = 1U;
	netifTable->intf.intf_mtu = mtu;

	netifTable->intf.ingress_action = FB_ACTION_FORWARD;
	netifTable->intf.egress_action = FB_ACTION_FORWARD;

	netifTable->intf.out_pppoe_act = FB_NETIFPPPOE_ACT_REMOVE;
	netifTable->intf.out_pppoe_sid = 0U;

	RTK_FC_HOOK_GET_VID_BY_DEV(&netifTable->vlanId, dev);
	TRACE("netifTable->vlanId=%u dev->name=%s\n", netifTable->vlanId, dev->name);

	netifTable->dev = dev;

#if defined(CONFIG_FC_RTL8277C_SERIES)
	netifTable->dualType = RTK_FC_DUALTYPE_NONE;
	netifTable->hwEntryNum = 1U;

	if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_DOMAIN_WAN))
		netifTable->macportidx = ASIC_LPORT_L3_WAN;
	else
		netifTable->macportidx = ASIC_LPORT_L3_LAN;
#endif	

	// Add GMAC to lut table	
	if( (pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5] )!=0x0 ) {
		rtk_fc_pmap_t portmap;
	
		portmap.macPortIdx = netifTable->macportidx;
		portmap.macExtPortIdx = netifTable->macextportidx;

		//if mac has exited in l2 entry, delete (mac clone case)
		if(_rtk_fc_lut_find(pMac, &lutidx) == RTK_FC_RET_OK) {
			RTK_FC_LUT_DEL(fc_db.lutTbl[lutidx], FALSE);
		}
		
		ret = _rtk_fc_lut_learning(&netifTable->intf.gateway_mac_addr.octet[0], portmap, netifTable->vlanId, netifTable->wlanidx,
											FALSE, TRUE,&macL2Idx);
		if(ret)
			WARNING("ret = 0x%x, dev %s mac %pM", ret, dev->name, &netifTable->intf.gateway_mac_addr.octet[0]);

		netifTable->lutIdx = macL2Idx;
		if(fc_db.lutTbl[macL2Idx]) fc_db.lutTbl[macL2Idx]->isGMAC = TRUE;
	}

	if (!strncmp(dev->name, "br0", IFNAMSIZ)) {
		RTK_FC_HELPER_MGR_BR0_IP_MAC_SET(ipAddr, netifTable->intf.gateway_mac_addr.octet, 0U);
	}

	return SUCCESS;
}

// del sw netif
int _rtk_fc_netif_sw_del(int swEntIdx)
{
	int ret = 0 ;
	int i = 0;
	int is_pppoe =0;
	uint32 type=0U;
	
	FC_PARAM_CHK(swEntIdx>=RTK_FC_TABLESIZE_INTF_SW, FAIL);
	FC_PARAM_CHK((fc_db.netifTbl[swEntIdx].intf.valid==0), SUCCESS);

	if(fc_db.netifTbl[swEntIdx].dev)
		RTK_FC_HELPER_NETDEV_GET_DEV_DATA(fc_db.netifTbl[swEntIdx].dev, &type, RTK_FC_NETDEV_GET_TYPE);
	if(type == ARPHRD_PPP )
		is_pppoe = 1;

	RTK_FC_HOOK_PS_DEV_DEV_PUT(fc_db.netifTbl[swEntIdx].dev);
	if(fc_db.netifTbl[swEntIdx].lutIdx != SIGNED_INVALID)
	{
		ret = _rtk_fc_lut_staticEntry_del(fc_db.netifTbl[swEntIdx].lutIdx);
	}

	if(is_pppoe ==1 && fc_db.netifTbl[swEntIdx].pppoe_synced ==0U) // Which means there are 1 pppoe interface but not sync yet.
		fc_db.pppoe_sync_num --;

	// clean related netdev event job
	for(i = 0; i < RTK_FC_NETDEV_EVENT_JOB_ARRAY_SIZE; i++)
	{
		if(fc_db.netdevEventJob.netdevEventJobList[i].valid && fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx == swEntIdx)
		{
			rtk_fc_netdev_event_job_clean(i);
		}
	}

	if (!strncmp(fc_db.netifTbl[swEntIdx].dev->name, "br0", IFNAMSIZ)) {
		uint8 mac_addr[ETHER_ADDR_LEN] = {0};
		RTK_FC_HELPER_MGR_BR0_IP_MAC_SET(0U, mac_addr, 0U);
	}

	bzero(&fc_db.netifTbl[swEntIdx], sizeof(fc_db.netifTbl[swEntIdx]));
	fc_db.netifTbl[swEntIdx].lutIdx = SIGNED_INVALID;
	fc_db.netifTbl[swEntIdx].hwIdx = SIGNED_INVALID;
	fc_db.netifTbl[swEntIdx].macportidx = RTK_FC_MAC_PORT_MAINCPU;
	fc_db.netifTbl[swEntIdx].macextportidx = RTK_FC_MAC_EXT_NONE;
	fc_db.netifTbl[swEntIdx].wlanidx = RTK_FC_WLANX_NOT_FOUND;
#if defined(CONFIG_FC_RTL8277C_SERIES)
	fc_db.netifTbl[swEntIdx].hwFmrIdx = SIGNED_INVALID;
#endif
	fc_db.pppoe_netif_record[swEntIdx] = 0U;

	
	
	return SUCCESS;
}

// get exist or free entry index
static int _rtk_fc_netif_swIdx_get(struct net_device *dev, uint8 *existEnt)
{
	int i = 0, firstFreeEntIdx = FAIL;

	if(!dev) {WARNING("no net device");}
	*existEnt = FALSE;

	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid)
		{
			if(dev && fc_db.netifTbl[i].dev && (dev == fc_db.netifTbl[i].dev) && (!memcmp(dev->name, &fc_db.netifTbl[i].dev->name , strlen(dev->name)))) {
				*existEnt = TRUE;
				break;
			}
		}
		else if(firstFreeEntIdx == FAIL)
			firstFreeEntIdx = i;
	}
	if(i != RTK_FC_TABLESIZE_INTF_SW)	//found
		return i;
	else
		return firstFreeEntIdx;
}

// add current interface to hw entry
static int _rtk_fc_netif_hw_recovery(void)
{
	int i = 0;

	for(i = 0; i < RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid)
			rtk_fc_netif_update(i);
	}

	return SUCCESS;
}

// reset exist hw entry
static int _rtk_fc_netif_hw_init(void)
{
	int i;

	for(i = 0; i < RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(!fc_db.netifTbl[i].dev && fc_db.netifTbl[i].hwIdx!=SIGNED_INVALID)
		{
			fc_db.netifTbl[i].intf.valid = 0U;
		}
		fc_db.netifTbl[i].lutIdx = SIGNED_INVALID;
		fc_db.netifTbl[i].hwIdx = SIGNED_INVALID;
		fc_db.netifTbl[i].macportidx = RTK_FC_MAC_PORT_MAINCPU;
		fc_db.netifTbl[i].macextportidx = RTK_FC_MAC_EXT_NONE;
		fc_db.netifTbl[i].wlanidx = RTK_FC_WLANX_NOT_FOUND;
#if defined(CONFIG_FC_RTL8277C_SERIES)		
		fc_db.netifTbl[i].hwFmrIdx = SIGNED_INVALID;
#endif
	}

	for(i = 0; i < RTK_FC_TABLESIZE_INTF; i++)
	{
		fc_db.netifHwTbl[i].refCount = 0U; // for RTK_RG_ASIC_NETIFTABLE_DEL to clear HW and SW fields
		RTK_RG_ASIC_NETIFTABLE_DEL(i); //clear HW and SW fields
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_rg_asic_table_reset(FB_RST_IF_TBL);
#endif

	return SUCCESS;
}

#if defined(CONFIG_FC_RTL8277C_SERIES)
static void _rtk_fc_sw_netif_setting_for_dualHdr(rtk_fc_dev_type_t devType, uint32 swNetifIdx, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	uint8 hwEntryNum = 1;
	rtk_fc_dualHdrtype_t dualType = RTK_FC_DUALTYPE_NONE;
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);

	if(devType==RTK_FC_DEV_TYPE_INGRESS)
	{
		if(pFcIngressData->isDualHeader && pPktHdr->dualHdrType==RTK_FC_DUALTYPE_NONE)	//downstream dual
		{
			if(pFcIngressData->ingressTagif & DSLITE_TAGIF)
				dualType = RTK_FC_DUALTYPE_DSLITE;
			else if(pFcIngressData->ingressTagif & PPTP_TAGIF)
				dualType = RTK_FC_DUALTYPE_PPTP;
			else if(pFcIngressData->ingressTagif & L2TP_TAGIF)
				dualType = RTK_FC_DUALTYPE_L2TP;
			else if(pFcIngressData->ingressTagif & IPSEC_ESP_TAGIF)
				dualType = RTK_FC_DUALTYPE_IPSEC;
			else if(pFcIngressData->ingressTagif & GRE_ETH_BR_TAGIF)
				dualType = RTK_FC_DUALTYPE_GRE_ETH_BR;
			else if(pFcIngressData->ingressTagif & VXLAN_TAGIF)
				dualType = RTK_FC_DUALTYPE_VXLAN;
			else if(pFcIngressData->ingressTagif & V6RD_TAGIF)
				dualType = RTK_FC_DUALTYPE_6RD;
			else
				dualType = RTK_FC_DUALTYPE_NONE;
	
			hwEntryNum = ((dualType == RTK_FC_DUALTYPE_VXLAN) && (pFcIngressData->vxlan_info.outer_tag_len > RTK_FC_DUAL_CONTENT_BUFFER_SIZE)) ? 2 : 1 ;
		}else if(pPktHdr->isMAPT && pPktHdr->iph)
			dualType = RTK_FC_DUALTYPE_MAPT;
	}
	else if(devType==RTK_FC_DEV_TYPE_EGRESS)
	{
		if(pFcIngressData->isDualHeader==0 && pPktHdr->dualHdrType) //upstream dual
		{
			dualType = pPktHdr->dualHdrType;
			hwEntryNum = ((dualType == RTK_FC_DUALTYPE_VXLAN) && (pPktHdr->vxlan_info.outerTag_off > RTK_FC_DUAL_CONTENT_BUFFER_SIZE)) ? 2 : 1 ;
		}else if(pPktHdr->isMAPT && pPktHdr->ip6h)
			dualType = RTK_FC_DUALTYPE_MAPT;
	}

	fc_db.netifTbl[swNetifIdx].dualType = dualType;
	fc_db.netifTbl[swNetifIdx].hwEntryNum = hwEntryNum;

	return;
}
#endif

static int _rtk_fc_netif_hwIdx_get(rtk_fc_dev_type_t devType, struct net_device *device, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	int i,hwIdx;

	if(!device){
		WARNING("dev was NULL");
		return -1;
	}

	for(i = 0; i < RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid==0)
			continue;
		if(fc_db.netifTbl[i].dev == device)
		{
			hwIdx=fc_db.netifTbl[i].hwIdx;
			if((hwIdx == SIGNED_INVALID) || ((hwIdx != SIGNED_INVALID) && fc_db.netifHwTbl[hwIdx].ifTempEntry))
			{
#if defined(CONFIG_FC_RTL8277C_SERIES)
				_rtk_fc_sw_netif_setting_for_dualHdr(devType, i, rtskb, pPktHdr);
#endif
				//no hw entry or its hw entry is a temp entry
				if(rtk_fc_netif_update_by_flow(i) != RTK_FC_RET_OK)
				{
					DEBUG("update netif by flow failed!");
					return FAILED;
				}
				hwIdx=fc_db.netifTbl[i].hwIdx;
				
				if(hwIdx < 0 || hwIdx >= RTK_FC_TABLESIZE_INTF) {
					WARNING("%s invalid hw idx %d, sw idx %d",  device->name, hwIdx, i);
					dump_netif(NULL, NULL);
					dump_sw_netif(NULL, NULL);
					_rtk_fc_dump_stack();
					return FAILED;
				}
					
				_rtk_fc_netif_dummy_packet_set(hwIdx); //initial for PPPoE dummy packet
			}
			goto FOUND;
		}
	}
	return FAILED;

FOUND:
	return hwIdx;
}

int rtk_fc_tableReset(void)
{
	_rtk_fc_netif_hw_init();
#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac, pFlowPath5->out_dmac_idx is meaningless
	_rtk_fc_indMac_addr_init();
#endif
	_rtk_fc_extPMask_init();

	_rtk_fc_netif_hw_recovery();

	return SUCCESS;
}

int rtk_fc_netif_update(int swEntIdx)
{
	TABLE("update hw netif - will del and then add sw netif[%d] to hw again (temp entry)", swEntIdx);
	rtk_fc_netif_del(swEntIdx);
	return rtk_fc_netif_add_tempEntry(swEntIdx);
}

int rtk_fc_netif_update_by_flow(int swEntIdx)
{
	TABLE("update hw netif - will del and then add sw netif[%d] to hw again", swEntIdx);
	rtk_fc_netif_del(swEntIdx);
	return rtk_fc_netif_add_by_flow(swEntIdx);
}

void rtk_fc_netif_port_info_set(int swEntIdx, char macportidx, char macextportidx, char wlanidx)
{
	fc_db.netifTbl[swEntIdx].macportidx= macportidx;
	fc_db.netifTbl[swEntIdx].macextportidx= macextportidx;
	fc_db.netifTbl[swEntIdx].wlanidx= wlanidx;
}

// add sw netif to hw temp entry (for gateway MAC only, not for flow acceleration)
int rtk_fc_netif_add_tempEntry(int swEntIdx)
{
	int i = 0, hwIdx;
	struct net_device *device = NULL;
	rtk_fc_ret_t ret = RTK_FC_RET_ERR;
	int16 gMacL2Idx = 0;
	uint8 *pMac = NULL;
	uint32 type=0U;

	device =  fc_db.netifTbl[swEntIdx].dev;

	if(!device || (0 > swEntIdx) || (swEntIdx>=RTK_FC_TABLESIZE_INTF_SW))
	{
		WARNING("FIXME: try to write sw netif[%d]", swEntIdx);
		goto RET_FAILED;
	}

	if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(device, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE))
		DEBUG("Ready to add bridge interface %s to hw netif table. (temp entry)", device->name);

	else if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(device, RTK_FC_NETDEV_PRIV_FLAG_TYPE_DOMAIN_WAN))
	{
		if(RTK_FC_HELPER_GET_BR_PORT_EXIST(device))
		{
			struct net_device *br_intf=NULL;
			br_intf = rtk_fc_getBridgedDevbyNetDev(device);
			if(br_intf)
			{
				DEBUG("WAN interface %s is the member of bridge intf %s, no need to add temp entry", device->name, br_intf->name);
				return RTK_FC_RET_OK;
			}
		}
		DEBUG("Ready to add WAN interface %s to hw netif table. (temp entry)", device->name);
	}
	else if((fc_db.netifTbl[swEntIdx].intf.gateway_ipv4_addr!=0U )|| (fc_db.netifTbl[swEntIdx].global_ipv6_addr_set != 0U))
		DEBUG("Ready to add interface %s to hw netif table.", device->name);
	else
		return RTK_FC_RET_OK;

	if(fc_db.netifTbl[swEntIdx].intf.valid!=TRUE)
	{
		WARNING("config was incomplete");
		goto RET_FAILED;
	}


	//
	// Update pppoe netif infomation
	// 
	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(device, &type, RTK_FC_NETDEV_GET_TYPE);
	
	if(type == ARPHRD_PPP && fc_db.netifTbl[swEntIdx].pppoe_synced ==0 && fc_db.pppoe_netif_record[swEntIdx] ==0)
	{
		EVENT("PPPOE interface!device->name:%s swEntIdx = %d\n",device->name, swEntIdx);
		fc_db.pppoe_sync_num ++;
		fc_db.pppoe_netif_record[swEntIdx] =1U;
	}


	hwIdx = fc_db.netifTbl[swEntIdx].hwIdx;

	TRACE("try to add temp HW intf for sw intf[%d] device %s", swEntIdx, device->name);

	if(hwIdx==SIGNED_INVALID)
	{
		for(i=RTK_FC_NETIF_START_IDX; i<RTK_FC_TABLESIZE_INTF; i++)
		{
			// find duplicate temp entry
			if((fc_db.netifHwTbl[i].intf.valid) && (fc_db.netifHwTbl[i].ifTempEntry) && (!memcmp(&(fc_db.netifHwTbl[i].intf.gateway_mac_addr), &(fc_db.netifTbl[swEntIdx].intf.gateway_mac_addr), sizeof(fc_db.netifHwTbl[i].intf.gateway_mac_addr /*temp entry, compare gateway MAC only*/))))
			{
				fc_db.netifTbl[swEntIdx].hwIdx = i;
				fc_db.netifHwTbl[i].refCount++;
				return RTK_FC_RET_OK;
			}
			// find first free netif entry
			if((fc_db.netifHwTbl[i].intf.valid == FALSE) && (hwIdx==SIGNED_INVALID))
			{
				hwIdx = i;
			}
		}
	}
	else
	{
		//update SW netif => always delete its HW entry and re-add it
		WARNING("strange interface (update SW interface but its hw entry exists): sw_intf[%d].hwIdx=%d, hw_intf[%d].intf.valid=%d, hw_intf[%d].ifTempEntry=%d, hw_intf[%d].refCount=%d", swEntIdx, hwIdx, hwIdx, fc_db.netifHwTbl[hwIdx].intf.valid, hwIdx, fc_db.netifHwTbl[hwIdx].ifTempEntry, hwIdx, fc_db.netifHwTbl[hwIdx].refCount);
		goto RET_FAILED;
	}

	if(hwIdx==-1)
	{
		WARNING("hw netif table was full");
		goto RET_FAILED;
	}

	pMac = &fc_db.netifTbl[swEntIdx].intf.gateway_mac_addr.octet[0];

	fc_db.netifTbl[swEntIdx].hwIdx = hwIdx;

	//HW entry set valid bit and gateway MAC only
	fc_db.netifHwTbl[hwIdx].intf.valid = TRUE;
	memcpy(&(fc_db.netifHwTbl[hwIdx].intf.gateway_mac_addr), pMac, sizeof(fc_db.netifHwTbl[hwIdx].intf.gateway_mac_addr));

	fc_db.netifHwTbl[hwIdx].ifTempEntry = TRUE;

	fc_db.netifHwTbl[hwIdx].refCount++;
	ret = RTK_RG_ASIC_NETIFTABLE_ADD(hwIdx, &(fc_db.netifHwTbl[hwIdx].intf));

	if(ret != RTK_FC_RET_OK){

		fc_db.netifTbl[swEntIdx].hwIdx = SIGNED_INVALID;

		fc_db.netifHwTbl[hwIdx].refCount--;
		RTK_RG_ASIC_NETIFTABLE_DEL(hwIdx);

		WARNING("add sw netif[%d] failed: %x\n", swEntIdx, ret);
		goto RET_FAILED;
	}
	else{
		TABLE("Add sw intf[%d] to temp hw netif[%d] for device %s", swEntIdx, hwIdx, device->name);

	}

	/*reserved ACL*/
	_rtk_fc_aclAndCfReservedRule_intfRsvUpdate(TRUE, swEntIdx);

	// Add GMAC to lut table
	if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])!=0x0){
		rtk_fc_pmap_t portmap;

		portmap.macPortIdx = fc_db.netifTbl[swEntIdx].macportidx;
		portmap.macExtPortIdx = fc_db.netifTbl[swEntIdx].macextportidx;
		ASSERT_EQ(_rtk_fc_lut_learning(&fc_db.netifTbl[swEntIdx].intf.gateway_mac_addr.octet[0], portmap, fc_db.netifTbl[swEntIdx].vlanId, fc_db.netifTbl[swEntIdx].wlanidx,
											FALSE, TRUE,&gMacL2Idx),RTK_FC_RET_OK);

		fc_db.netifHwTbl[hwIdx].lutIdx = gMacL2Idx;
		if(fc_db.lutTbl[gMacL2Idx]) fc_db.lutTbl[gMacL2Idx]->isGMAC = TRUE;
		TRACE("hw netif %d lut %d", hwIdx, fc_db.netifHwTbl[hwIdx].lutIdx);
	}
		
	return ret;

RET_FAILED:
	return FAILED;
}



// add sw netif to hw entry
int rtk_fc_netif_add_by_flow(int swEntIdx)
{
	int i = 0, hwIdx;
	struct net_device *device = NULL;
	struct in_ifaddr* if_info = NULL;
	rtk_fc_ret_t ret = RTK_FC_RET_ERR;
	int16 gMacL2Idx = 0;
	uint8 *pMac = NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES)
	int netif_idx_offset, netif_search_start_idx;
	uint8 hwEntryNum=1;
#endif

	device =  fc_db.netifTbl[swEntIdx].dev;

	if(!device || (0 > swEntIdx) || (swEntIdx>=RTK_FC_TABLESIZE_INTF_SW))
	{
		WARNING("FIXME: try to write sw netif[%d]", swEntIdx);
		goto RET_FAILED;
	}

#if defined(CONFIG_FC_RTL8198F_SERIES)
	//vlan device
	if (is_vlan_dev(device)){
		DEBUG("FIXME currently donot add vlan device to hw netif table. dev->name %s sw netif index [%d]", device->name, swEntIdx);
		goto RET_FAILED;
	}
#endif

	RTK_FC_HELPER_NETDEV_GET_IF_INFO(device, &if_info);

	if(fc_db.netifTbl[swEntIdx].intf.valid!=TRUE)
	{
		WARNING("config was incomplete");
		goto RET_FAILED;
	}

	hwIdx = fc_db.netifTbl[swEntIdx].hwIdx;

	TRACE("try to add HW intf for sw intf[%d] device %s", swEntIdx, device->name);

	if(hwIdx==SIGNED_INVALID)
	{
#if defined(CONFIG_FC_RTL8277C_SERIES)
		netif_search_start_idx = (fc_db.netifTbl[swEntIdx].dualType==RTK_FC_DUALTYPE_NONE) ? RTK_FC_NETIF_START_IDX : RTK_FC_DUAL_NETIF_START_IDX ;	
		hwEntryNum = fc_db.netifTbl[swEntIdx].hwEntryNum;
		switch(hwEntryNum)
		{
			case 1:
			case 2:	
				for(i=netif_search_start_idx; i<RTK_FC_TABLESIZE_INTF; i+=hwEntryNum)
				{
					// find duplicate hw entry
					if((fc_db.netifHwTbl[i].intf.valid) && (!fc_db.netifHwTbl[i].ifTempEntry) && (!memcmp(&(fc_db.netifHwTbl[i].intf), &(fc_db.netifTbl[swEntIdx].intf), sizeof(fc_db.netifHwTbl[i].intf))))
					{
						fc_db.netifTbl[swEntIdx].hwIdx = i;
						fc_db.netifHwTbl[i].refCount++;
						return RTK_FC_RET_OK;
					}
					// find first consecutive n free netif entry
					if(hwIdx==SIGNED_INVALID)
					{
						for(netif_idx_offset=0; netif_idx_offset<hwEntryNum; netif_idx_offset++)
						{
							if(fc_db.netifHwTbl[ i + netif_idx_offset].intf.valid)
								break;
						}
						if(netif_idx_offset==hwEntryNum)
						{
							hwIdx = i;
						}
					}
				}
				break;
			default:
				WARNING("Do not support hwEntryNum=%d, swNetifIdx=%d", hwEntryNum, swEntIdx);
				goto RET_FAILED;
		}	
#else
		for(i=RTK_FC_NETIF_START_IDX; i<RTK_FC_TABLESIZE_INTF; i++)
		{
			// find duplicate hw entry
			if((fc_db.netifHwTbl[i].intf.valid) && (!fc_db.netifHwTbl[i].ifTempEntry) && (!memcmp(&(fc_db.netifHwTbl[i].intf), &(fc_db.netifTbl[swEntIdx].intf), sizeof(fc_db.netifHwTbl[i].intf))))
			{
				fc_db.netifTbl[swEntIdx].hwIdx = i;
				fc_db.netifHwTbl[i].refCount++;
				return RTK_FC_RET_OK;
			}
			// find first free netif entry
			if((fc_db.netifHwTbl[i].intf.valid == FALSE) && (hwIdx==SIGNED_INVALID))
			{
				hwIdx = i;
			}
		}
#endif		
	}
	else
	{
		//update SW netif => always delete its HW entry and re-add it
		WARNING("strange interface (update SW interface but its hw entry exists): sw_intf[%d].hwIdx=%d, hw_intf[%d].intf.valid=%d, hw_intf[%d].ifTempEntry=%d , hw_intf[%d].refCount=%d", swEntIdx, fc_db.netifTbl[swEntIdx].hwIdx, hwIdx, fc_db.netifHwTbl[hwIdx].intf.valid, hwIdx, fc_db.netifHwTbl[hwIdx].ifTempEntry, hwIdx, fc_db.netifHwTbl[hwIdx].refCount);
		goto RET_FAILED;
	}

	if(hwIdx==-1)
	{
		WARNING("hw netif table was full");
		goto RET_FAILED;
	}

	pMac = &fc_db.netifTbl[swEntIdx].intf.gateway_mac_addr.octet[0];

	fc_db.netifTbl[swEntIdx].hwIdx = hwIdx;

	memcpy(&(fc_db.netifHwTbl[hwIdx].intf), &(fc_db.netifTbl[swEntIdx].intf), sizeof(fc_db.netifHwTbl[hwIdx].intf));

	fc_db.netifHwTbl[hwIdx].ifTempEntry = FALSE;
#if defined(CONFIG_FC_RTL8277C_SERIES)
	fc_db.netifHwTbl[hwIdx].dualType = fc_db.netifTbl[swEntIdx].dualType;
	fc_db.netifHwTbl[hwIdx].hwEntryNum = hwEntryNum;
	fc_db.netifHwTbl[hwIdx].dualHdr_ds_clsIdx = CA_UINT32_INVALID;
	if(fc_db.netifHwTbl[hwIdx].dualType && fc_db.netifHwTbl[hwIdx].dualType==RTK_FC_DUALTYPE_MAPT)
		fc_db.netifHwTbl[hwIdx].hwMaptInfo.ds_clsIdx_TCP_flag0 = CA_UINT32_INVALID;
#endif
	fc_db.netifHwTbl[hwIdx].refCount++;

	ret = RTK_RG_ASIC_NETIFTABLE_ADD(hwIdx, &(fc_db.netifHwTbl[hwIdx].intf));

	if(ret != RTK_FC_RET_OK){

		fc_db.netifTbl[swEntIdx].hwIdx = SIGNED_INVALID;

		fc_db.netifHwTbl[hwIdx].refCount--;
		RTK_RG_ASIC_NETIFTABLE_DEL(hwIdx);

		if(if_info)
			WARNING("add netif %s (%pI4/%pI4) failed: %x\n", if_info->ifa_label, &if_info->ifa_address, &if_info->ifa_mask, ret);
		else
			WARNING("add sw netif[%d] failed: %x\n", swEntIdx, ret);
		goto RET_FAILED;
	}
	else{
		TABLE("Add sw intf[%d] to hw netif[%d] for device %s", swEntIdx, hwIdx, device->name);

	}

#if defined(CONFIG_FC_RTL8277C_SERIES)
	for(netif_idx_offset=1; netif_idx_offset<hwEntryNum; netif_idx_offset++)
	{
		int hwNetifIdx = hwIdx + netif_idx_offset;
		//HW entry set valid bit and gateway MAC only
		fc_db.netifHwTbl[hwNetifIdx].intf.valid = TRUE;
		fc_db.netifHwTbl[hwNetifIdx].dualType = fc_db.netifTbl[swEntIdx].dualType;
		fc_db.netifHwTbl[hwNetifIdx].hwEntryNum = 0U;
		fc_db.netifHwTbl[hwNetifIdx].dualHdr_ds_clsIdx = CA_UINT32_INVALID;
		if(fc_db.netifHwTbl[hwNetifIdx].dualType && fc_db.netifHwTbl[hwNetifIdx].dualType==RTK_FC_DUALTYPE_MAPT)
			fc_db.netifHwTbl[hwNetifIdx].hwMaptInfo.ds_clsIdx_TCP_flag0 = CA_UINT32_INVALID;
		memcpy(&(fc_db.netifHwTbl[hwNetifIdx].intf.gateway_mac_addr), pMac, sizeof(fc_db.netifHwTbl[hwNetifIdx].intf.gateway_mac_addr));

		fc_db.netifHwTbl[hwNetifIdx].ifTempEntry = FALSE;

		fc_db.netifHwTbl[hwNetifIdx].refCount = 1U;
		
		ret = RTK_RG_ASIC_NETIFTABLE_ADD(hwNetifIdx, &(fc_db.netifHwTbl[hwNetifIdx].intf));

		if(ret != RTK_FC_RET_OK){

			fc_db.netifTbl[swEntIdx].hwIdx = SIGNED_INVALID;

			//recover netif
			for(i=hwNetifIdx; i>=hwIdx; i--)
			{
				fc_db.netifHwTbl[i].refCount = 0U;
				RTK_RG_ASIC_NETIFTABLE_DEL(i);
			}

			if(if_info)
				WARNING("add netif %s (%pI4/%pI4) failed: %x\n", if_info->ifa_label, &if_info->ifa_address, &if_info->ifa_mask, ret);
			else
				WARNING("add sw netif[%d] failed: %x\n", swEntIdx, ret);
			goto RET_FAILED;
		}
		else{
			TABLE("[Dual virtual netif] Add sw intf[%d] to hw netif[%d] for device %s", swEntIdx, hwNetifIdx, device->name);

		}
	}
#endif

	/*reserved ACL*/
	_rtk_fc_aclAndCfReservedRule_intfRsvUpdate(TRUE, swEntIdx);

	// Add GMAC to lut table
	if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])!=0x0){
		rtk_fc_pmap_t portmap;

		portmap.macPortIdx = fc_db.netifTbl[swEntIdx].macportidx;
		portmap.macExtPortIdx = fc_db.netifTbl[swEntIdx].macextportidx;
		ASSERT_EQ(_rtk_fc_lut_learning(&fc_db.netifTbl[swEntIdx].intf.gateway_mac_addr.octet[0], portmap, fc_db.netifTbl[swEntIdx].vlanId, fc_db.netifTbl[swEntIdx].wlanidx,
											FALSE, TRUE,&gMacL2Idx),RTK_FC_RET_OK);

		fc_db.netifHwTbl[hwIdx].lutIdx = gMacL2Idx;
		fc_db.netifTbl[swEntIdx].lutIdx = gMacL2Idx;	// for PPPoE interface update
		if(fc_db.lutTbl[gMacL2Idx]) fc_db.lutTbl[gMacL2Idx]->isGMAC = TRUE;
		TRACE("hw netif %d lut %d", hwIdx, fc_db.netifHwTbl[hwIdx].lutIdx);
	}
	return ret;

RET_FAILED:
	return FAILED;
}

// del hw netif
int rtk_fc_netif_del(int swEntIdx)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	int update_rsv_acl = FALSE;
	int hwIdx;

	if(fc_db.netifTbl[swEntIdx].hwIdx == SIGNED_INVALID){
               return RTK_FC_RET_ERR_ENTRY_NOT_FOUND;
    }

	hwIdx = fc_db.netifTbl[swEntIdx].hwIdx;

	if(hwIdx != SIGNED_INVALID)
	{
		TABLE("Del netif[%d] for device %s", hwIdx, fc_db.netifTbl[swEntIdx].dev->name);

		fc_db.netifHwTbl[hwIdx].refCount--;
		fc_db.netifTbl[swEntIdx].hwIdx = SIGNED_INVALID;

		if(!fc_db.netifHwTbl[hwIdx].refCount)
		{
			// Decrease GMAC reference count and Delete entry if refcount becomes zero
			TRACE("hw netif %d lut %d", hwIdx, fc_db.netifHwTbl[hwIdx].lutIdx);
			if(fc_db.netifHwTbl[hwIdx].lutIdx != SIGNED_INVALID)
			{
				ret = _rtk_fc_lut_staticEntry_del(fc_db.netifHwTbl[hwIdx].lutIdx);
				if(ret != SUCCESS){
					WARNING("hw netif %d lut %d is something wrong", hwIdx, fc_db.netifHwTbl[hwIdx].lutIdx);
				}
			}
			
			//delete fmrtable
#if defined(CONFIG_FC_RTL8277C_SERIES)			
			if(fc_db.netifTbl[swEntIdx].hwFmrIdx!=SIGNED_INVALID)
			{
				rtk_fc_mapet_hwfmrInfo_t fmrhwInfo;
				bzero(&fmrhwInfo,sizeof(fmrhwInfo));
				fmrhwInfo.hwFmrIdx=fc_db.netifTbl[swEntIdx].hwFmrIdx;
				rtk_fc_mapet_hwfmr_del(&fmrhwInfo);
			}
#endif

			// Delete lut index of PPPoE gateway(nexthop)
			if(0<=fc_db.netifHwTbl[hwIdx].pppoeGwLutIdx && fc_db.netifHwTbl[hwIdx].pppoeGwLutIdx<RTK_FC_TABLESIZE_LUT){
				RTK_FC_LUT_DEL(fc_db.lutTbl[fc_db.netifHwTbl[hwIdx].pppoeGwLutIdx], FALSE);
			}

			
			// Delete related flows
			rtk_fc_flow_delete_by_intfIdx(hwIdx);

			// Delete Extra tag related table
			if(fc_db.netifHwTbl[hwIdx].dualType){
				rtk_fc_dualConfig_del(hwIdx);
			}


			// Delete Netif
			/*reserved ACL pre check*/
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			update_rsv_acl = TRUE;
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
			if(fc_db.netifHwTbl[hwIdx].dualType==RTK_FC_DUALTYPE_DSLITE)
				update_rsv_acl = TRUE;
#endif

			ret = RTK_RG_ASIC_NETIFTABLE_DEL(hwIdx);

			if(ret != RTK_FC_RET_OK){
				WARNING("Del HW netif[%d] for device %s failed", hwIdx, fc_db.netifTbl[swEntIdx].dev->name);
			}
			else{
				TABLE("Del netif[%d] for device %s netif[%d].refCount is %d now", hwIdx, fc_db.netifTbl[swEntIdx].dev->name, hwIdx, fc_db.netifHwTbl[hwIdx].refCount);

				/*reserved ACL*/
				if(update_rsv_acl)
					_rtk_fc_aclAndCfReservedRule_intfRsvUpdate(FALSE, swEntIdx);
			}
#if defined(CONFIG_FC_RTL8277C_SERIES)
{
			int netif_idx_offset;
			for(netif_idx_offset=1; netif_idx_offset<fc_db.netifTbl[swEntIdx].hwEntryNum; netif_idx_offset++)
			{
				fc_db.netifHwTbl[hwIdx + netif_idx_offset].refCount = 0U;
				RTK_RG_ASIC_NETIFTABLE_DEL(hwIdx + netif_idx_offset);
			}
}
#endif			
		}
	}
	return ret;
}

// return hw interface table index
int rtk_fc_decideNetifIndex(rtk_fc_dev_type_t devType, struct net_device *dev, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	int i;

	if(!dev){
		WARNING("dev was NULL");
		return -1;
	}

	i = _rtk_fc_netif_hwIdx_get(devType, dev, rtskb, pPktHdr);

	if(i!=FAILED)
	{
		// find
		return i;
	}else
	{
		FIXME("FIXME, all netif should be added by netdev event, %s", dev->name);
		// add a new one?
	}

	return -1;
}


int rtk_fc_eventHandler_inetAddr(void *ptr, unsigned long event)
{
	int entIdx = FAIL, vlanid = 0, ret = RTK_FC_RET_OK;
	uint8 entExist = FALSE;
	struct net_device *dev = NULL;
	int ipAddr = 0;
	unsigned int mtu;
	
	RTK_FC_HELPER_RCU_READ_LOCK();

	RTK_FC_HELPER_NETDEV_IFA_TO_DEV(ptr, &dev);
	RTK_FC_HELPER_RCU_INDEV_GET_IPADDR(dev, &ipAddr);
	RTK_FC_HELPER_RCU_READ_UNLOCK();

	if(unlikely(fc_db.rtk_fc_mgr_init==0)) return RTK_FC_RET_OK;

	if(unlikely(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SPEC_TEST)) return RTK_FC_RET_OK;

	if(RTK_FC_HELPER_NETDEV_IGNORE_LOOKUP(dev,event)) return RTK_FC_RET_OK;

	EVENT("[INETADDR EVENT] netdevice:%s event:%lu\n", dev->name, event);

	switch (event) {
		case NETDEV_UP:
			break;
		default:
			return RTK_FC_RET_OK;
	}

	entIdx = _rtk_fc_netif_swIdx_get(dev, &entExist);
	if(entIdx == FAIL){
		WARNING("[INETADDR EVENT] netdevice:%s sw net device table was full\n", dev->name);
		return RTK_FC_RET_ERR_ENTRY_FULL;
	}
	EVENT("netdev:%s ip:%pI4h", dev->name, (&ipAddr));


	RTK_FC_HOOK_GET_VID_BY_DEV((unsigned short *)&vlanid, dev);
	EVENT("vlanId=%u dev->name=%s\n", vlanid, dev->name);
	_rtk_fc_netif_sw_add(&fc_db.netifTbl[entIdx], dev);

	// update netif hw table to sync configuration
	rtk_fc_netif_update(entIdx);

#ifdef CONFIG_SYSCTL // disable netfilter checksum checking
	{
		RTK_FC_HELPER_NETDEV_SET_NETFILTER_CHECKSUM(&dev);
		/*
		struct net *net = dev_net(dev);
		net->ct.sysctl_checksum = 0;
		*/
	}
#endif

	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(dev, &mtu, RTK_FC_NETDEV_GET_MTU);

	EVENT("SW NETIF[%d]: devname = %s, ip = %pI4h, vlan = %d, mtu = %d", entIdx, dev->name, &ipAddr, vlanid, mtu);	
		
	return ret;

}

int rtk_fc_eventHandler_inet6Addr(void *ptr, unsigned long event)
{
	// sync ipv6 addr to sw netif table

	int entIdx = FAIL, vlanid = 0, ret = RTK_FC_RET_OK;
	uint8 entExist = FALSE;
	struct net_device *dev = NULL;
	unsigned int mtu;

	RTK_FC_HELPER_NETDEV_IFAV6_TO_DEV(ptr, &dev);
	if(unlikely(fc_db.rtk_fc_mgr_init==0)) return RTK_FC_RET_OK;

	if(unlikely(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SPEC_TEST)) return RTK_FC_RET_OK;

	if(RTK_FC_HELPER_NETDEV_IGNORE_LOOKUP(dev,event)) return RTK_FC_RET_OK;

	EVENT("[INET6ADDR EVENT] netdevice:%s event:%lu\n", dev->name, event);

	switch (event) {
		case NETDEV_UP:
			break;
		default:
			return RTK_FC_RET_OK;
	}

	entIdx = _rtk_fc_netif_swIdx_get(dev, &entExist);
	if(entIdx == FAIL){
		WARNING("[INET6ADDR EVENT] netdevice:%s sw net device table was full\n", dev->name);
		return RTK_FC_RET_ERR_ENTRY_FULL;
	}

	RTK_FC_HOOK_GET_VID_BY_DEV((unsigned short *)&vlanid, dev);
	EVENT("vlanId=%u dev->name=%s\n",vlanid, dev->name);

	_rtk_fc_netif_sw_add(&fc_db.netifTbl[entIdx], dev);

	// update netif hw table to sync configuration
	rtk_fc_netif_update(entIdx);


#ifdef CONFIG_SYSCTL // disable netfilter checksum checking
	{
		RTK_FC_HELPER_NETDEV_SET_NETFILTER_CHECKSUM(&dev);
		/*
		struct net *net = dev_net(dev);
		net->ct.sysctl_checksum = 0;
		*/
	}
#endif
	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(dev, &mtu, RTK_FC_NETDEV_GET_MTU);

	EVENT("SW NETIF[%d]: devname = %s, vlan = %d, mtu = %d", entIdx, dev->name, vlanid, mtu);	

	return ret;

}


int rtk_fc_eventHandler_netDev(void *ptr, unsigned long event)
{
	struct net_device *dev = NULL;
	bool iswlan = FALSE;
	int entIdx;
	uint8 entExist = FALSE;
	unsigned int mtu=0U, priv_flags=0U, type=0U;
	int i;

	RTK_FC_HELPER_NETDEV_NOTIFIERINFO_TO_DEV(ptr, &dev);

	if(unlikely(fc_db.rtk_fc_mgr_init==0)) return RTK_FC_RET_OK;
	
	if(unlikely(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SPEC_TEST)) return RTK_FC_RET_OK;

	if(RTK_FC_HELPER_NETDEV_IGNORE_LOOKUP(dev,event)) return RTK_FC_RET_OK;

	entIdx = _rtk_fc_netif_swIdx_get(dev, &entExist);

	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(dev, &mtu, RTK_FC_NETDEV_GET_MTU);
	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(dev, &type, RTK_FC_NETDEV_GET_TYPE);
	RTK_FC_HELPER_NETDEV_GET_DEV_DATA(dev, &priv_flags, RTK_FC_NETDEV_GET_PRI_FLAGS);

	EVENT("[NETDEVICE EVENT] netdevice:%s  type: %d event:%lu associated %s sw netif idx: %d priv_flags:0x%x features:0x%llx\n", dev->name, type, event, entExist?"find":"new", entIdx, priv_flags, dev->features);

	if(entIdx == FAIL){
		WARNING("[NETDEVICE EVENT] netdevice:%s sw net device table was full\n", dev->name);
		return RTK_FC_RET_ERR_ENTRY_FULL;
	}


	switch (event) {		
		case NETDEV_REGISTER:
			//wlan init
			RTK_FC_HELPER_WLAN_SET_USBNAME(dev);
			//For G3, below operation is done in rtk_rg_wlan_netDevice_set().
			RTK_FC_HOOK_PS_DEV_IS_WLAN_DEV(dev, &iswlan);
			if(iswlan)
			{
				RTK_FC_HELPER_SET_WFO_PORTID(dev);
				RTK_FC_HELPER_WLAN_REGISTER(RTK_FC_WLANX_NOT_FOUND, dev);
			}
			/* fall through */
		case NETDEV_UP:
			/* fall through */
		case NETDEV_CHANGEMTU:
			/* fall through */
		case NETDEV_CHANGEADDR:
			_rtk_fc_netif_sw_add(&fc_db.netifTbl[entIdx], dev);

			// update netif hw table to sync configuration
			rtk_fc_netif_update(entIdx);

			break;
		case NETDEV_CHANGEUPPER:
			/*bridge member change: update netif hw table to sync configuration (member info can not be gotten immediately, use timer to delay updating)
			del WAN intf from bridge: add temp HW intf entry for WAN
			add WAN intf into bridge: remove HW intf entry for WAN
			*/
			for(i = 0; i < RTK_FC_NETDEV_EVENT_JOB_ARRAY_SIZE ; i++){
				if(fc_db.netdevEventJob.netdevEventJobList[i].valid==0)
				{
					fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx = entIdx;
					fc_db.netdevEventJob.netdevEventJobList[i].event = NETDEV_CHANGEUPPER;
					fc_db.netdevEventJob.netdevEventJobList[i].valid = 1U;
					break;
				}
			}
			rtk_fc_netdev_event_timerKick();
			break;
		case NETDEV_DOWN:			
			RTK_FC_HOOK_PS_DEV_IS_WLAN_DEV(dev, &iswlan);
			if(iswlan) {
				// wlan devnot ready, so flush related flow to prevent wifi fast forward.
				rtk_fc_wlan_devidx_t wlan_dev_idx;
				RTK_FC_HELPER_WLAN_DEV_TO_DEVID(dev, &wlan_dev_idx);
				rtk_fc_flow_delete_by_wlanIdx(wlan_dev_idx);
			}
			if(type == ARPHRD_PPP) {
				EVENT("ppp device was going down, remove it from sw/hw table");
			}
			/* fall through */
		case NETDEV_UNREGISTER:

			if(entExist) {
				rtk_fc_netif_del(entIdx);
				_rtk_fc_netif_sw_del(entIdx);
			}

			RTK_FC_HOOK_PS_DEV_IS_WLAN_DEV(dev, &iswlan);
			if(iswlan)
			{
				// wlan devnot ready, so flush related flow to prevent wifi fast forward.
				rtk_fc_wlan_devidx_t wlan_dev_idx;
				RTK_FC_HELPER_WLAN_DEV_TO_DEVID(dev, &wlan_dev_idx);
				rtk_fc_flow_delete_by_wlanIdx(wlan_dev_idx);
				RTK_FC_HELPER_WLAN_UNREGISTER(dev);
			}
			break;
		case NETDEV_CHANGE:
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)			
			if(fc_db.controlFuc.bc_hwflow_accelerate && fc_db.bcMacIdx!=FAIL)
			{
				TABLE("link change delete abstr bc-flow delete by lut:%d",fc_db.bcMacIdx);
				rtk_fc_abstrSwFlow_BC_UUC_UMC_floodingDomain_delete();
			}
#endif			
			if(fc_db.igmp_unknown_flood)
			{
				extern int32 rtk_fc_igmp_sendAllMcDummyPktDetector(unsigned long task_priv);
				rtk_fc_igmp_sendAllMcDummyPktDetector(0UL);
				IGMP("dev %s state is change ",dev->name);
			} 
			break;
		default:
			return RTK_FC_RET_OK;
	}


	return RTK_FC_RET_OK;

}



