/*
 * Copyright (C) 2017 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
*/

#include "rtk_fc_struct.h"



// ingress/egress learning
int rtk_fc_ingress_outerHdrPathUpdate(rtk_fc_pktHdr_t *pPktHdr, uint32 path6Idx);
int rtk_fc_egress_extratagDecision(rtk_fc_pktHdr_t *pPktHdr, uint32 netifIdx, uint32 *extraTagIdx);
int rtk_fc_mapt_accelerate(rtk_fc_ingress_data_t *pFcIngressData, rtk_fc_pktHdr_t *pPktHdr, uint32 igrNetifIdx, uint32 egrNetifIdx);

// shortcut operation
int rtk_fc_mapt_translate(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable);
int rtk_fc_outerHdr_insert(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTblEnt);
int rtk_fc_outerHdr_remove(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr);
int rtk_fc_l2Dual_outerHdr_remove(struct rt_skbuff *rtskb, uint8 outer_tag_len, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable);
int rtk_fc_l2Dual_outerHdr_insert(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable);

// Others
int rtk_fc_egress_tunnelInfoSync(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr);
int rtk_fc_dualConfig_del(int hwIntfIdx);
int rtk_fc_dualInfoInit(void);
int rtk_fc_callId_to_interface_setting(rtk_fc_pktHdr_t *pPktHdr);

// mape extra header
int rtk_fc_mape_dst6Info_init(void);
void rtk_fc_mark_mape_flow6(rtk_fc_pktHdr_t *pPktHdr, uint32 flowIdx);
int rtk_fc_is_mape_upstream_flow5(uint32 flowIdx);
void rtk_fc_mape_dst6_update(rtk_fc_pktHdr_t *pPktHdr, uint32 outif_idx, uint16 fmr_idx);
int rtk_fc_mape_dst6_decision(rtk_fc_pktHdr_t *pPktHdr, uint32 flowIdx);
int rtk_fc_mape_dst6_refcnt_put(uint32 flowIdx);


#if defined(CONFIG_FC_RTL8277C_SERIES)
rtk_fc_ret_t rtk_fc_dual_control_entry_setVXLAN(int idx, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo);
rtk_fc_ret_t rtk_fc_dual_control_content_setVXLAN(uint32 dual_content_tbl_idx, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, u8 *outer_header_content, int outer_header_size, rtk_fc_pktHdr_t *pPktHdr);


#endif
