/*
 * Copyright (C) 2016 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
*/

#include <linux/if_pppox.h>
#include <linux/etherdevice.h>
#include <net/neighbour.h>
#include <net/arp.h>
#include <net/tcp.h>
#include <net/ip6_checksum.h>
#include <linux/inetdevice.h>
#include <linux/icmp.h>
#include <linux/kmod.h>

#include "rtk_fc_struct.h"
#include "rtk_fc_define.h"
#include "rtk_fc_debug.h"
#include "rtk_fc_driver.h"
#include "rtk_fc_internal.h"
#include "rtk_fc_callback.h"
#include "rtk_fc_dualHeader.h"
#include "rtk_fc_mappingAPI.h"
#include "rtk_fc_external.h"
#include "rtk_fc_multicast.h"
#include "rtk_fc_helper_multicast.h"
#include "rtk_fc_vxlan.h"



#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_CA8277AB_SERIES)
#include "rtk_rg_g3_internal.h"
#endif
#include "rtk/l2.h"
#include <mcast.h>
#include <aal_l3_cls.h>
#endif

#if 0//defined(CONFIG_RTL_MULTI_ETH_WAN)
#include "if_smux.h"
#endif
#include "rtk_fc_multicast.h"
#include "rtk_fc_acl.h"

#if defined(CONFIG_FC_CA8277B_SERIES)

extern rtk_scfg_t rtkScfg;
extern int ca_ni_init_tx_dma_lso_special_fast_fwd(u8 *vxlanContentBuffer, int vxlanContentBufferSize, int inner_extra_len);
extern int ca_ni_init_set_inner_extra_len(int direction, int inner_extra_len);
extern int ca_ni_init_tx_dma_lso_special_fast_fwd_init_skb_pool(void);

#endif
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
int _rtk_fc_updateLsoPara0(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr);
#endif
rtk_fc_tableFlowEntry_t *pTmp_tableFlowEntry=NULL;

//#ifdef CONFIG_FC_RTL9607C_SERIES
//extern uint32 ASICDRIVERVER;
//#endif
#if defined(CONFIG_FC_RTL9607C_SERIES)
extern uint32 dynamic_sram_desc;
#endif

extern fc_l2_refresh_notify rtk_fc_notify_lut_refresh;
extern rtk_fc_api_module_t *RTK_FC_API_MODULE;

#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
static struct kmem_cache *flow_dummy_data = NULL;
#endif


static const char *const br_port_state_names[] = {
	[BR_STATE_DISABLED] = "disabled",
	[BR_STATE_LISTENING] = "listening",
	[BR_STATE_LEARNING] = "learning",
	[BR_STATE_FORWARDING] = "forwarding",
	[BR_STATE_BLOCKING] = "blocking",
};

static const char *const rtk_fc_fwd_dir_name[RTK_FC_FLOW_DIRECTION_END] = {
	[RTK_FC_FLOW_DIRECTION_NA] = "N/A",
	[RTK_FC_FLOW_DIRECTION_UPSTREAM] = "upstream",
	[RTK_FC_FLOW_DIRECTION_DOWNSTREAM] = "downstream",
	[RTK_FC_FLOW_DIRECTION_LANBRIDGE] = "lanbridge",
	[RTK_FC_FLOW_DIRECTION_NATLOOPBACK] = "natloopback",
};
static const char *const rtk_fc_fwd_type_name[RTK_FC_FWDTYPE_END] = {
	[RTK_FC_FWDTYPE_BRIDGE] = "bridge",
	[RTK_FC_FWDTYPE_ROUTING] = "routing",
	[RTK_FC_FWDTYPE_NAPT] = "napt",
};

int assert_eq(int func_return,int expect_return,const char *func,int line)
{
	if (func_return != expect_return)
	{
		rtlglue_printf("\033[31;43m%s(%d): func_return=0x%x expect_return=0x%x, fail, so abort!\033[m\n",func, line,func_return,expect_return);
		_rtk_fc_dump_stack();
		return func_return;
	}
	return 0;
}

void assert_ok_sub_func(int assert_ret, char *assert_str,const char *func,int line)
{
	if(assert_ret!=0)
	{
		rtlglue_printf("\033[1;33;41m[ASSERT_FAIL]'%s=0x%x'\033[1;30m @%s:%d\033[0m\n",assert_str,assert_ret,func,line);
		_rtk_fc_dump_stack();
	}
}

void assert_sub_func(int assert_ret, char *assert_str,const char *func,int line)
{
	if(!(assert_ret))
	{
		rtlglue_printf("\033[1;33;41m[ASSERT]'%s'\033[1;30m @%s:%d\033[0m\n", assert_str,func,line);
		_rtk_fc_dump_stack();
	}
}


#define IP_PROTO_TCP 6
#define IP_PROTO_UDP 17
#define _RTK_RG_CHM _rtk_rg_standard_chksum

static u16
_rtk_rg_standard_chksum(u8 *dataptr, u16 len)
{
  u32 acc;
  u16 src;
  u8 *octetptr;

  acc = 0;

  octetptr = (u8*)dataptr;
  while (len > 1)
  {

    src = (*octetptr) << 8;
    octetptr++;
    src |= (*octetptr);
    octetptr++;
    acc += src;
    len -= 2;
  }

  if (len > 0)
  {
    src = (*octetptr) << 8;
    acc += src;
  }

  acc = (acc >> 16) + (acc & 0x0000ffffUL);
  while ((acc & 0xffff0000) != 0) {
    acc = (acc >> 16) + (acc & 0x0000ffffUL);
  }

  return htons((u16)acc);
}
void rtk_fc_set_bit(unsigned int nr, void *addr)
{
	((unsigned int *) addr)[nr>>5] |= (0x1 << (nr&0x1f));
}

void rtk_fc_clear_bit(unsigned int nr, void *addr)
{
	((unsigned int *) addr)[nr>>5] &= ~(0x1 << (nr&0x1f));
}

int rtk_fc_test_bit(unsigned int nr, void *addr)
{
	return 1UL & (((unsigned int *) addr)[nr>>5] >> (nr&0x1f));
}

u16 inet_chksum(u8 *dataptr, u16 len)
{
  u32 acc;

  acc = _RTK_RG_CHM(dataptr, len);
  while (acc >> 16) {
    acc = (acc & 0xffff) + (acc >> 16);
  }
  return (u16)~(acc & 0xffff);
}

u16 inet_chksum_pseudo(u8 *tcphdr, u16 tcplen,
       u32 srcip, u32 destip,  u8 proto)
{
	u32 acc;
	u8 swapped;

	acc = 0;
	swapped = 0;
	/* iterate through all pbuf in chain */

	acc += _RTK_RG_CHM(tcphdr, tcplen);

	while (acc >> 16)
	{
		acc = (acc & 0xffffUL) + (acc >> 16);
	}
	if (tcplen % 2 != 0)
	{
		swapped = 1 - swapped;
		acc = ((acc & 0xff) << 8) | ((acc & 0xff00UL) >> 8);
	}

	if (swapped)
	{
		acc = ((acc & 0xff) << 8) | ((acc & 0xff00UL) >> 8);
	}

	acc += (srcip & 0xffffUL);
	acc += ((srcip >> 16) & 0xffffUL);
	acc += (destip & 0xffffUL);
	acc += ((destip>> 16) & 0xffffUL);
	acc += (u32)htons((u16)proto);
	acc += (u32)htons(tcplen);
	while (acc >> 16)
	{
		acc = (acc & 0xffffUL) + (acc >> 16);
	}
	return (u16)~(acc & 0xffffUL);

}

u16 inet_chksum_pseudoV6(u8 *tcphdr, u16 tcplen,
       u8 *srcip, u8 *destip,  u8 proto)
{
	u32 acc;
	u8 swapped, i;
	u16 *ipTmp;

	acc = 0;
	swapped = 0;
	/* iterate through all pbuf in chain */

	acc += _RTK_RG_CHM(tcphdr, tcplen);

	while (acc >> 16)
	{
		acc = (acc & 0xffffUL) + (acc >> 16);
	}
	if (tcplen % 2 != 0)
	{
		swapped = 1 - swapped;
		acc = ((acc & 0xff) << 8) | ((acc & 0xff00UL) >> 8);
	}

	if (swapped)
	{
		acc = ((acc & 0xff) << 8) | ((acc & 0xff00UL) >> 8);
	}

	ipTmp = (u16 *)srcip;
	for(i=0; i<(IPV6_ADDR_LEN/2); i++)
	{
		acc += ipTmp[i];
	}
	ipTmp = (u16 *)destip;
	for(i=0; i<(IPV6_ADDR_LEN/2); i++)
	{
		acc += ipTmp[i];
	}
	acc += (u32)htons((u16)proto);
	acc += (u32)htons(tcplen);
	while (acc >> 16)
	{
		acc = (acc & 0xffffUL) + (acc >> 16);
	}
	return (u16)~(acc & 0xffffUL);

}


int rtk_fc_user_pipe_cmd(const char *comment, ...)
{

	char * envp[]={
		"HOME=/",
		NULL
	};
	char * argv[]={
		"/bin/ash",
		"-c",
		fc_db.cmd_buf,
		NULL
	};
	int retval;
	va_list argList;
	va_start(argList, comment);
	//sprintf( cmd_buff, comment, ##arg);
	vsprintf(fc_db.cmd_buf, comment, argList);

	retval=call_usermodehelper(argv[0], argv, envp, UMH_WAIT_PROC);

	va_end(argList);
	return retval;
}
static inline void rtk_fc_rtnetlink_job_clean(int index)
{
	memset(&fc_db.rtnlJobs.rtnlJobList[index],0,sizeof(fc_db.rtnlJobs.rtnlJobList[index]));
}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

void rtk_fc_dynamicPrehashPtn_setHWNAT(void)
{
	EVENT("Set hwnat to 1!!!");
	fc_db.controlFuc.hwnat_mode = RT_FLOW_HWNAT_MODE_ORIGINAL;
	RTK_FC_HELPER_MGR_HWNAT_MODE_SET(RT_FLOW_HWNAT_MODE_ORIGINAL);
						
	rtk_fc_flow_flush_forHashChange();//clear all flow

	//fc_db.dynamic_calculate_prehash_count = 0;
	fc_db.dynamic_calculate_prehash_jiffies = jiffies;
	EVENT("Set dynamic_calculate_prehash_count 0!!!");
}
#endif
void rtk_fc_rtnetlink_sync_lut(void)
{
	int i;
	bool fdb_exist = FALSE, v4neigh_exist = FALSE, v6neigh_exist = FALSE;
	rtk_fc_fdb_entry_t fc_fdb;


	for(i = 0; i < RTK_FC_RTNL_JOB_ARRAY_SIZE; i++)
	{
		if(fc_db.rtnlJobs.rtnlJobList[i].valid!=0  && fc_db.rtnlJobs.rtnlJobList[i].type == RTK_FC_RTNL_JOB_NEIGH)
		{
			int16 l2Idx = 0;
			struct net_device *dev;
			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_LOCK_BH();


			RTK_FC_HOOK_PS_DEV_GET_BY_INDEX(fc_db.rtnlJobs.rtnlJobList[i].sock_net, fc_db.rtnlJobs.rtnlJobList[i].ifindex, &dev);

			if(dev==NULL) {
				EVENT("[RTNL JOBS] dev is not found by ifindex %d", fc_db.rtnlJobs.rtnlJobList[i].ifindex);
				rtk_fc_rtnetlink_job_clean(i);
				RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();
				continue;
			}
			EVENT("[RTNL JOBS] rcv dev %s, netdevidx %d, mac %pM  action: %d job-index: %d", dev->name, fc_db.rtnlJobs.rtnlJobList[i].ifindex, fc_db.rtnlJobs.rtnlJobList[i].addr, fc_db.rtnlJobs.rtnlJobList[i].action, i);

			/*TODO: sync lut info*/
			if(_rtk_fc_lut_find(fc_db.rtnlJobs.rtnlJobList[i].addr, &l2Idx) != RTK_FC_RET_OK) {
				// lut entry is not found
				EVENT("[RTNL JOBS] mac %pM is not found in l2 table, do nothing", fc_db.rtnlJobs.rtnlJobList[i].addr);
				rtk_fc_rtnetlink_job_clean(i);
				RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();
				continue;
			}

			if(fc_db.rtnlJobs.rtnlJobList[i].action==RTK_FC_RTNL_JOB_ACT_CHECK)
			{
				bool iswlan = FALSE;
				rtk_fc_wlan_devidx_t wlanDevIdx = RTK_FC_WLANX_NOT_FOUND;
				rtk_fc_realdev_t realdev;

				RTK_FC_HOOK_PS_DEV_IS_WLAN_DEV(dev, &iswlan);

				if(iswlan) {
					// new fdb learning on wifi dev
					RTK_FC_HELPER_WLAN_DEV_TO_DEVID(dev, &wlanDevIdx);

					if(wlanDevIdx != fc_db.lutTbl[l2Idx]->wlan_dev_idx &&wlanDevIdx!=RTK_FC_WLANX_NOT_FOUND) {

						TRACE("[RTNL JOBS] port moving from wlan dev idx %d to %d", fc_db.lutTbl[l2Idx]->wlan_dev_idx, wlanDevIdx);
						RTK_FC_LUT_DEL(fc_db.lutTbl[l2Idx], FALSE);
					}

				}else
				{
					// new fdb learning on nic dev/
					if((RTK_FC_HOOK_PS_DEV_GET_REALDEV_PHYPORT(dev, &realdev) == RTK_FC_RET_OK) && (realdev.physicalPid != fc_db.lutTbl[l2Idx]->spa)) {

						TRACE("[RTNL JOBS] port moving from phy port %d to %d", fc_db.lutTbl[l2Idx]->spa, realdev.physicalPid);
						RTK_FC_LUT_DEL(fc_db.lutTbl[l2Idx], FALSE);
					}
				}
			} else if (fc_db.rtnlJobs.rtnlJobList[i].action == RTK_FC_RTNL_JOB_ACT_DEL) {
				fdb_exist = _rtk_fc_lookup_fdb(&fc_db.lutTbl[l2Idx]->l2Addr[0], fc_db.lutTbl[l2Idx]->CVID, &fc_fdb);
				v4neigh_exist = _rtk_fc_lookup_v4neighbor(&fc_db.lutTbl[l2Idx]->l2Addr[0]);
				v6neigh_exist = _rtk_fc_lookup_v6neighbor(&fc_db.lutTbl[l2Idx]->l2Addr[0]);

				// neighbor timeout: if LUT entry is not sync to fbd and not not exits in fdb/neighbor => delete it
				if(fc_db.lutTbl[l2Idx]->isSync2PsEntry && !(fdb_exist || v4neigh_exist || v6neigh_exist))
					RTK_FC_LUT_DEL(fc_db.lutTbl[l2Idx], FALSE);
			}
			rtk_fc_rtnetlink_job_clean(i);
			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();
		}
	}

}

#if defined(CONFIG_RTK_SOC_RTL8198D) || defined(CONFIG_FC_RTL8198F_SERIES) || defined(CONFIG_RTL8198X_SERIES)
bool rtk_fc_sip_is_default_gateway(__be32 sip_addr)
{
	int i;

	for (i = 0; i < MAX_DEFAULT_ROUTE_INFO_ENTRY_SIZE; i++) {
		if (fc_db.defaultRouteInfo[i].valid) {
			if (fc_db.defaultRouteInfo[i].gw_addr && fc_db.defaultRouteInfo[i].gw_addr == sip_addr) {
				TRACE("hit default route ip=%pI4, dev=%s, tbl=%d", 
					&sip_addr, fc_db.defaultRouteInfo[i].dev_name, fc_db.defaultRouteInfo[i].rt_tbl_id);
				return TRUE;
			}
		}
	}

	return FALSE;
}

int rtk_fc_update_default_route_info(uint8 action, char *dev_name, uint8 len, uint8 rt_tbl_id, __be32 gw_addr)
{
	int i, index = -1, ret = SUCCESS;

	if (unlikely(!dev_name || len == 0 || len > IFNAMSIZ))
		return FAIL;

	for (i = 0; i < MAX_DEFAULT_ROUTE_INFO_ENTRY_SIZE; i++) {
		if (fc_db.defaultRouteInfo[i].valid == 0) {
			if (index == -1)
				index = i;
		}
		else {
			if (!memcmp(fc_db.defaultRouteInfo[i].dev_name, dev_name, len)) {
				if (action == RTK_FC_RTNL_JOB_ACT_ADD) {
					fc_db.defaultRouteInfo[i].gw_addr = gw_addr;
					fc_db.defaultRouteInfo[i].rt_tbl_id = rt_tbl_id;
				}
				else {
					memset(&fc_db.defaultRouteInfo[i], 0, sizeof(rtk_fc_default_route_info_t));
				}
				break;
			}
		}
	}

	if (i == MAX_DEFAULT_ROUTE_INFO_ENTRY_SIZE) {
		if (action == RTK_FC_RTNL_JOB_ACT_ADD) {
			if (index >= 0) {
				fc_db.defaultRouteInfo[index].valid = 1;
				memcpy(fc_db.defaultRouteInfo[index].dev_name, dev_name, len);
				fc_db.defaultRouteInfo[index].gw_addr = gw_addr;
				fc_db.defaultRouteInfo[index].rt_tbl_id = rt_tbl_id;
			}
			else {
				EVENT("[RTNL JOBS] default gateway info tbl full");
				ret = FAIL;
			}
		}
		else {
			EVENT("[RTNL JOBS] cannot find entry with dev=%s gateway=%pI4 to delete", dev_name, &gw_addr);
			ret = FAIL;
		}
	}

	return ret;
}

void rtk_fc_rtnetlink_sync_default_route_info(void)
{
	int i, ret;

	for(i = 0; i < RTK_FC_RTNL_JOB_ARRAY_SIZE; i++) {
		if(fc_db.rtnlJobs.rtnlJobList[i].valid != 0  && fc_db.rtnlJobs.rtnlJobList[i].type == RTK_FC_RTNL_JOB_ROUTE) {
			struct net_device *dev = NULL;

			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_LOCK_BH();

			RTK_FC_HOOK_PS_DEV_GET_BY_INDEX(fc_db.rtnlJobs.rtnlJobList[i].sock_net, fc_db.rtnlJobs.rtnlJobList[i].ifindex, &dev);

			if(dev==NULL) {
				EVENT("[RTNL JOBS] dev is not found by ifindex %d", fc_db.rtnlJobs.rtnlJobList[i].ifindex);
				rtk_fc_rtnetlink_job_clean(i);
				RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();
				continue;
			}

			ret = rtk_fc_update_default_route_info(
				fc_db.rtnlJobs.rtnlJobList[i].action, 
				dev->name, IFNAMSIZ, 
				fc_db.rtnlJobs.rtnlJobList[i].rt_tbl_id,
				fc_db.rtnlJobs.rtnlJobList[i].gw_addr);

			EVENT("[RTNL JOBS] rcv dev %s, netdevidx %d, rt_tbl %d gw %pI4  action: %d job-index: %d, result: %d\n", 
				dev->name, fc_db.rtnlJobs.rtnlJobList[i].ifindex, fc_db.rtnlJobs.rtnlJobList[i].rt_tbl_id, &fc_db.rtnlJobs.rtnlJobList[i].gw_addr, fc_db.rtnlJobs.rtnlJobList[i].action, i, ret);

			rtk_fc_rtnetlink_job_clean(i);
			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();
		}
	}
}
#endif

#if defined(CONFIG_RTK_SOC_RTL8198D)
int rtk_fc_flow_limit_set(bool swOnly, uint32 in_path, int limit)
{
	if (swOnly) {
		switch (in_path) {
		case FB_PATH_12:
			fc_db.flow_limit.sw_path12_limit = limit;
			break;
		case FB_PATH_34:
			fc_db.flow_limit.sw_path34_limit = limit;
			break;
		case FB_PATH_5:
			fc_db.flow_limit.sw_path5_limit = limit;
			break;
		case FB_PATH_6:
			fc_db.flow_limit.sw_path6_limit = limit;
			break;
		default:
			break;
		}
	}
	else {
		switch (in_path) {
		case FB_PATH_12:
			fc_db.flow_limit.hw_path12_limit = limit;
			break;
		case FB_PATH_34:
			fc_db.flow_limit.hw_path34_limit = limit;
			break;
		case FB_PATH_5:
			fc_db.flow_limit.hw_path5_limit = limit;
			break;
		case FB_PATH_6:
			fc_db.flow_limit.hw_path6_limit = limit;
			break;
		default:
			break;
		}
	}

	return SUCCESS;
}

int rtk_fc_flow_limit_check(bool *swOnly, uint32 in_path)
{
	if (unlikely(!swOnly)) {
		return FAILED;
	}

	if (*swOnly == FALSE) {
		switch (in_path) {
		case FB_PATH_12:
			if (fc_db.flow_limit.hw_path12_limit >= 0 && atomic_read(&fc_db.flow_limit.hw_path12_count) >= fc_db.flow_limit.hw_path12_limit) {
				TRACE("reach path12 hw flow limitation %d, check sw flow limitation", fc_db.flow_limit.hw_path12_limit);
				*swOnly = TRUE;
			}
			break;
		case FB_PATH_34:
			if (fc_db.flow_limit.hw_path34_limit >= 0 && atomic_read(&fc_db.flow_limit.hw_path34_count) >= fc_db.flow_limit.hw_path34_limit) {
				TRACE("reach path34 hw flow limitation %d, check sw flow limitation", fc_db.flow_limit.hw_path34_limit);
				*swOnly = TRUE;
			}
			break;
		case FB_PATH_5:
			if (fc_db.flow_limit.hw_path5_limit >= 0 && atomic_read(&fc_db.flow_limit.hw_path5_count) >= fc_db.flow_limit.hw_path5_limit) {
				TRACE("reach path5 hw flow limitation %d, check sw flow limitation", fc_db.flow_limit.hw_path5_limit);
				*swOnly = TRUE;
			}
			break;
		case FB_PATH_6:
			if (fc_db.flow_limit.hw_path6_limit >= 0 && atomic_read(&fc_db.flow_limit.hw_path6_count) >= fc_db.flow_limit.hw_path6_limit) {
				TRACE("reach path6 hw flow limitation %d, check sw flow limitation", fc_db.flow_limit.hw_path6_limit);
				*swOnly = TRUE;
			}
			break;
		default:
			return FAILED;
		}
	}

	if (*swOnly == TRUE){
		switch (in_path) {
		case FB_PATH_12:
			if (fc_db.flow_limit.sw_path12_limit >= 0 && atomic_read(&fc_db.flow_limit.sw_path12_count) >= fc_db.flow_limit.sw_path12_limit) {
				TRACE("reach path12 sw flow limitation %d", fc_db.flow_limit.sw_path12_limit);
				return FAILED;
			}
			break;
		case FB_PATH_34:
			if (fc_db.flow_limit.sw_path34_limit >= 0 && atomic_read(&fc_db.flow_limit.sw_path34_count) >= fc_db.flow_limit.sw_path34_limit) {
				TRACE("reach path34 sw flow limitation %d", fc_db.flow_limit.sw_path34_limit);
				return FAILED;
			}
			break;
		case FB_PATH_5:
			if (fc_db.flow_limit.sw_path5_limit >= 0 && atomic_read(&fc_db.flow_limit.sw_path5_count) >= fc_db.flow_limit.sw_path5_limit) {
				TRACE("reach path5 sw flow limitation %d", fc_db.flow_limit.sw_path5_limit);
				return FAILED;
			}
			break;
		case FB_PATH_6:
			if (fc_db.flow_limit.sw_path6_limit >= 0 && atomic_read(&fc_db.flow_limit.sw_path6_count) >= fc_db.flow_limit.sw_path6_limit) {
				TRACE("reach path6 sw flow limitation %d", fc_db.flow_limit.sw_path6_limit);
				return FAILED;
			}
			break;
		default:
			return FAILED;
		}
	}

	return SUCCESS;
}


int rtk_fc_flow_limit_count_update(bool swOnly, uint32 in_path, bool op_add)
{
	if (swOnly) {
		switch (in_path) {
		case FB_PATH_12:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.sw_path12_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.sw_path12_count);
			}
			break;
		case FB_PATH_34:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.sw_path34_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.sw_path34_count);
			}
			break;
		case FB_PATH_5:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.sw_path5_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.sw_path5_count);
			}
			break;
		case FB_PATH_6:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.sw_path6_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.sw_path6_count);
			}
			break;
		default:
			break;
		}
	}
	else {
		switch (in_path) {
		case FB_PATH_12:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.hw_path12_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.hw_path12_count);
			}
			break;
		case FB_PATH_34:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.hw_path34_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.hw_path34_count);
			}
			break;
		case FB_PATH_5:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.hw_path5_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.hw_path5_count);
			}
			break;
		case FB_PATH_6:
			if (op_add) {
				atomic_inc(&fc_db.flow_limit.hw_path6_count);
			}
			else {
				atomic_dec(&fc_db.flow_limit.hw_path6_count);
			}
			break;
		default:
			break;
		}
	}

	return SUCCESS;
}

int rtk_fc_flow_limit_init(void)
{
	fc_db.flow_limit.hw_path12_limit = -1;
	fc_db.flow_limit.hw_path34_limit = -1;
	fc_db.flow_limit.hw_path5_limit = -1;
	fc_db.flow_limit.hw_path6_limit = -1;
	fc_db.flow_limit.sw_path12_limit = -1;
	fc_db.flow_limit.sw_path34_limit = -1;
	fc_db.flow_limit.sw_path5_limit = -1;
	fc_db.flow_limit.sw_path6_limit = -1;

	atomic_set(&fc_db.flow_limit.sw_path12_count, 0);
	atomic_set(&fc_db.flow_limit.sw_path34_count, 0);
	atomic_set(&fc_db.flow_limit.sw_path5_count, 0);
	atomic_set(&fc_db.flow_limit.sw_path6_count, 0);
	atomic_set(&fc_db.flow_limit.hw_path12_count, 0);
	atomic_set(&fc_db.flow_limit.hw_path34_count, 0);
	atomic_set(&fc_db.flow_limit.hw_path5_count, 0);
	atomic_set(&fc_db.flow_limit.hw_path6_count, 0);

	return SUCCESS;
}
#endif
void rtk_fc_rtnetlink_timerFunc(unsigned long task_priv)
{	
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
	//========================= Critical Section Start =========================//
	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	
	TIMER("RTNL TIME eventTimer TICK");

	rtk_fc_rtnetlink_sync_lut();

#if defined(CONFIG_RTK_SOC_RTL8198D) || defined(CONFIG_FC_RTL8198F_SERIES) || defined(CONFIG_RTL8198X_SERIES)
	rtk_fc_rtnetlink_sync_default_route_info();
#endif

	//========================= Critical Section End =========================//
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();

	return;
}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

void rtk_fc_dynamicPrehashPtn_timerFunc(unsigned long task_priv)
{
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
	//========================= Critical Section Start =========================//
	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	
	EVENT("RTNL TIME eventTimer TICK");

	rtk_fc_dynamicPrehashPtn_setHWNAT();

	//========================= Critical Section End =========================//
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();

	return;
}
#endif
static inline void rtk_fc_rtnetlink_timerKick(void)
{
	unsigned long int msec2jiffies=0;

	EVENT("[RTNL JOB] Start a Event Timer");

	RTK_FC_HELPER_MSECS_TO_JIFFIES(RTK_FC_RTNL_EVENT_TICK_MSECONDMS, &msec2jiffies);

	RTK_FC_HELPER_MOD_TIMER(fc_db.rtnlJobs.rtnetlinkEventTimer, jiffies+msec2jiffies);

}

static void rtk_fc_rtnetlink_data_handler(struct sock *sk)
{
	int rc = 0;
	struct net *net = NULL;
	//struct net *net = sock_net(sk);
	struct sk_buff *skb = NULL;
	struct nlmsghdr *nlh = NULL;
	struct ndmsg *ndm = NULL;
	struct nlattr *tb[NDA_MAX+1];
	uint8 *addr;
	int i;


	// register RT group message	: RTNLGRP_NEIGH (nl_groups == 3)
	// monitor RT message type		: RTM_NEWNEIGH & RTM_DELNEIGH (nlh->nlmsg_type == 28 || 29)

	/* Receive the data packet */
	skb = skb_recv_datagram(sk, 0, 0, &rc);
	if (rc) {
		WARNING("[RT EVENT] recv netlink skb fail. rc=%d", -rc);
		return;
	}
	
	if(unlikely(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SPEC_TEST)) goto done;

	//nlh = (struct nlmsghdr *) skb->data;
	RTK_FC_HELPER_NETLINK_GET_NET_FROM_SOCK(sk, &net);
	RTK_FC_HELPER_NETLINK_GET_NLHDR_FROM_SKBDATA(skb, &nlh);
	if (!nlh ) {
		WARNING("[RT EVENT] Invalid netlink header");
		goto done;
	}

	if(nlh->nlmsg_type == RTM_NEWNEIGH || nlh->nlmsg_type == RTM_DELNEIGH) {	// 28 or 29

		ndm = nlmsg_data(nlh);

		if(ndm->ndm_family == AF_BRIDGE) {	// 7
			// monitor FDB change


			EVENT("[RT EVENT] rcv rtnetlink msg type %d (%s), family %d (AF_BRIDGE)",
				nlh->nlmsg_type, (nlh->nlmsg_type == RTM_NEWNEIGH) ? "NEWNEIGH" : "DELNEIGH" , ndm->ndm_family);

			// refer data format from fdb_fill_info()
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,14,0)
			if((rc = nlmsg_parse(nlh, sizeof(*ndm), tb, NDA_MAX, NULL, NULL)) < 0) 
#else
			if((rc = nlmsg_parse(nlh, sizeof(*ndm), tb, NDA_MAX, NULL)) < 0) 
#endif
			{
				WARNING("[RT EVENT] nlmsg_parse fail");
				goto done;
			}

			if (!tb[NDA_LLADDR] || nla_len(tb[NDA_LLADDR]) != ETH_ALEN) {
				WARNING("[RT EVENT] RTM_NEWNEIGH with invalid address");
				goto done;
			}

			addr = nla_data(tb[NDA_LLADDR]);

			//EVENT("[RT EVENT] rcv dev %s, netdevidx %d, mac %pM", dev->name, ndm->ndm_ifindex, addr);

			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_LOCK_BH();
			//========================= Critical Section Start =========================//
			for(i = 0; i < RTK_FC_RTNL_JOB_ARRAY_SIZE ; i++){
				if(fc_db.rtnlJobs.rtnlJobList[i].valid==0)
				{
					fc_db.rtnlJobs.rtnlJobList[i].addr[0]       = addr[0];
					fc_db.rtnlJobs.rtnlJobList[i].addr[1]       = addr[1];
					fc_db.rtnlJobs.rtnlJobList[i].addr[2]       = addr[2];
					fc_db.rtnlJobs.rtnlJobList[i].addr[3]       = addr[3];
					fc_db.rtnlJobs.rtnlJobList[i].addr[4]       = addr[4];
					fc_db.rtnlJobs.rtnlJobList[i].addr[5]       = addr[5];
					fc_db.rtnlJobs.rtnlJobList[i].sock_net  	= net;
					fc_db.rtnlJobs.rtnlJobList[i].ifindex    	= ndm->ndm_ifindex;

					if(nlh->nlmsg_type==RTM_NEWNEIGH)
						fc_db.rtnlJobs.rtnlJobList[i].action 	= RTK_FC_RTNL_JOB_ACT_CHECK;
					else if(nlh->nlmsg_type==RTM_DELNEIGH)
						fc_db.rtnlJobs.rtnlJobList[i].action 	= RTK_FC_RTNL_JOB_ACT_DEL;
					else
						fc_db.rtnlJobs.rtnlJobList[i].action    = RTK_FC_RTNL_JOB_ACT_OTHER;

					fc_db.rtnlJobs.rtnlJobList[i].type 			= RTK_FC_RTNL_JOB_NEIGH;
					fc_db.rtnlJobs.rtnlJobList[i].valid         = 1;

					break;
				}
			}
			//========================= Critical Section End =========================//
			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();

			rtk_fc_rtnetlink_timerKick();

		}else {

			EVENT("[RT EVENT] rcv rtnetlink msg type %d, family %d, do nothing", nlh->nlmsg_type, ndm->ndm_family);
		}

	}
#if defined(CONFIG_RTK_SOC_RTL8198D)
	else if (nlh->nlmsg_type == RTM_NEWROUTE || nlh->nlmsg_type == RTM_DELROUTE) {
		struct rtmsg *rtm = (struct rtmsg *)nlmsg_data(nlh);
		struct nlattr *rt_tb[RTA_MAX+1];
		uint32 ifindex;
		__be32 gw_addr = 0;

		if (rtm->rtm_type == RTN_UNICAST && rtm->rtm_family == AF_INET) {
		#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,14,0)
			if((rc = nlmsg_parse(nlh, sizeof(*rtm), rt_tb, RTA_MAX, NULL, NULL)) < 0) 
		#else
			if((rc = nlmsg_parse(nlh, sizeof(*rtm), rt_tb, RTA_MAX, NULL)) < 0) 
		#endif
			{
				WARNING("[RT EVENT] nlmsg_parse fail");
				goto done;
			}

			EVENT("[RT EVENT] rcv rtnetlink msg type %d, family %d, rt_type %d", 
				nlh->nlmsg_type, rtm->rtm_family, rtm->rtm_type);

			if (!rt_tb[RTA_OIF] || (nlh->nlmsg_type == RTM_NEWROUTE && !rt_tb[RTA_GATEWAY])) {
				EVENT("[RT EVENT] RTM_ROUTE without gateway address or out intf");
				goto done;
			}

			ifindex = nla_get_u32(rt_tb[RTA_OIF]);

			if (rt_tb[RTA_GATEWAY])
				gw_addr = nla_get_be32(rt_tb[RTA_GATEWAY]);

			EVENT("[RT EVENT] ifindex %d, gw_addr %pI4", ifindex, &gw_addr);

			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_LOCK_BH();
			for(i = 0; i < RTK_FC_RTNL_JOB_ARRAY_SIZE ; i++){
				if(fc_db.rtnlJobs.rtnlJobList[i].valid==0)
				{
					fc_db.rtnlJobs.rtnlJobList[i].sock_net  	= net;
					fc_db.rtnlJobs.rtnlJobList[i].ifindex    	= ifindex;
					fc_db.rtnlJobs.rtnlJobList[i].gw_addr		= gw_addr;
					fc_db.rtnlJobs.rtnlJobList[i].rt_tbl_id		= rtm->rtm_table;
					if(nlh->nlmsg_type==RTM_NEWROUTE)
						fc_db.rtnlJobs.rtnlJobList[i].action 	= RTK_FC_RTNL_JOB_ACT_ADD;
					else
						fc_db.rtnlJobs.rtnlJobList[i].action 	= RTK_FC_RTNL_JOB_ACT_DEL;

					fc_db.rtnlJobs.rtnlJobList[i].type 			= RTK_FC_RTNL_JOB_ROUTE;
					fc_db.rtnlJobs.rtnlJobList[i].valid         = 1;

					break;
				}
			}
			RTK_FC_HELPER_MGR_RTNETLINK_TIMER_SPIN_UNLOCK_BH();

			rtk_fc_rtnetlink_timerKick();
		}
		else {
			EVENT("[RT EVENT] rcv rtnetlink msg type %d, family %d, rt_type %d, do nothing", 
				nlh->nlmsg_type, rtm->rtm_family, rtm->rtm_type);
		}
	}
#endif
	else {
		EVENT("[RT EVENT] rcv rtnetlink type %d, do nothing", nlh->nlmsg_type);
	}

done:
	skb_free_datagram(sk, skb);
}

void rtk_fc_rtnetlink_register_notifier(void)
{
	struct sockaddr_nl addr = { 0 };
	struct sock *nlsock = NULL;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,4,0)
	int rc = sock_create_kern(&init_net, AF_NETLINK, SOCK_RAW, NETLINK_ROUTE, &fc_db.rtnl_socket);
#else
	int rc = sock_create_kern(AF_NETLINK, SOCK_RAW, NETLINK_ROUTE, &fc_db.rtnl_socket);
#endif

	if (rc)
	    return;

	addr.nl_family		= AF_NETLINK;
	addr.nl_pid		= 0;
	addr.nl_groups	=1 << (RTNLGRP_NEIGH-1);  //refer to netlink_group_mask, return group ? 1 << (group - 1) : 0;
#if defined(CONFIG_RTK_SOC_RTL8198D)
	addr.nl_groups  |= (1 << (RTNLGRP_IPV4_ROUTE- 1));
#endif

	rc = kernel_bind(fc_db.rtnl_socket, (struct sockaddr *) &addr, sizeof(addr));
	if (rc) {
		WARNING("bind netlink socket fail");
		return;
	}

	nlsock = fc_db.rtnl_socket->sk;
	RTK_FC_HELPER_NETLINK_SET_SOCK_DATA(nlsock, rtk_fc_rtnetlink_data_handler, GFP_KERNEL);

	//printk("[HWNAT] fc create netlink socket %p\n", nlsock);

}

void rtk_fc_rtnetlink_unregister_notifier(void)
{
	if(fc_db.rtnl_socket) {
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,4,0)
		sock_release(fc_db.rtnl_socket);
#else
		sk_release_kernel(fc_db.rtnl_socket->sk);
#endif
	}
}

void rtk_fc_netdev_event_job_clean(int index)
{
	memset(&fc_db.netdevEventJob.netdevEventJobList[index], 0, sizeof(fc_db.netdevEventJob.netdevEventJobList[index]));
}

void rtk_fc_netdev_event_job(void)
{
	int i;

	for(i = 0; i < RTK_FC_NETDEV_EVENT_JOB_ARRAY_SIZE; i++)
	{
		if(fc_db.netdevEventJob.netdevEventJobList[i].valid)
		{
			switch(fc_db.netdevEventJob.netdevEventJobList[i].event)
			{
				case NETDEV_CHANGEUPPER:
					// update netif hw table to sync configuration
					if((0 <= fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx) && (fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx < RTK_FC_TABLESIZE_INTF_SW))
					{
						EVENT("[NETDEV JOBS] NETDEV_CHANGEUPPER, update sw netif[%d] to HW (dev %s)", fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx, fc_db.netifTbl[fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx].dev->name);
						rtk_fc_netif_update(fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx);
					}
					else
						WARNING("invalid SW intf index %d", fc_db.netdevEventJob.netdevEventJobList[i].swIntfIdx);
					break;
				default:
					break;
			}
			rtk_fc_netdev_event_job_clean(i);
		}
	}

}


void rtk_fc_netdev_event_timerFunc(unsigned long task_priv)
{
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
	//========================= Critical Section Start =========================//
	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	
	TIMER("netdev eventTimer TICK");

	rtk_fc_netdev_event_job();

	//========================= Critical Section End =========================//
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();

	return;
}

void rtk_fc_netdev_event_timerKick(void)
{
	unsigned long int msec2jiffies=0;

	EVENT("[NETDEV_EVENT] Start a Event Timer");

	RTK_FC_HELPER_MSECS_TO_JIFFIES(RTK_FC_NETDEV_EVENT_TICK_MSECONDMS, &msec2jiffies);
	
	RTK_FC_HELPER_MOD_TIMER(fc_db.netdevEventJob.netdevEventJobTimer, jiffies+msec2jiffies);


}

__IRAM_FC_NICTRX
rtk_fc_wlan_devidx_t rtk_fc_wlan_port_to_devid_find(rtk_fc_mac_port_idx_t macPort, rtk_fc_wlan_ext_info_t wlanExtInfo, 
													struct rt_skbuff *rtskb, struct sk_buff *skb, bool saLookup, bool lockReq)
{
	rtk_fc_wlan_devidx_t wlanDevIdx = RTK_FC_WLANX_NOT_FOUND;
	
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_wlan_devmask_t bitmask;
	rtk_fc_skipHwlookUp_stat_t skipHwlookUp_stat, ori_skipHwlookUp_stat;
	skipHwlookUp_stat.status = FALSE;

	RTK_FC_HELPER_WLAN_PORT_TO_DEVID(macPort, wlanExtInfo.macExtPort, &wlanDevIdx, &bitmask);

	if(unlikely(wlanDevIdx == RTK_FC_WLANX_MULTI_INTF)) {
		int16 lutidx = 0;
		struct rt_skbuff pri_rtskb;

		// the port may be shared by multiple wifi dev, lookup sa to decide correct wifi dev id

		// NOTICE: wifi ff needs to get fc lock here!

		if((rtskb == NULL) && (skb != NULL)) {
			
			RTK_FC_HOOK_CONVERTER_SKB(skb, &pri_rtskb);
			rtskb = &pri_rtskb;
		}

		if(rtskb) {
			struct ethhdr *eth = (struct ethhdr *)RTSKB_DATA(rtskb);
			uint8 *mac = saLookup ? (&eth->h_source[0]) : (&eth->h_dest[0]);
			
			if(lockReq) {
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
			}

			if(_rtk_fc_lut_find(mac, &lutidx) == RTK_FC_RET_OK) {
				rtk_fc_mac_port_idx_t macPortIdxByLut;
				rtk_fc_mac_ext_port_idx_t macExtPortIdxByLut;

				wlanDevIdx = fc_db.lutTbl[lutidx]->wlan_dev_idx;
				if(RTK_FC_HELPER_WLAN_DEVID_TO_PORTID(wlanDevIdx, &macPortIdxByLut, &macExtPortIdxByLut) == SUCCESS)
				{
					if((macPortIdxByLut != macPort) || (macExtPortIdxByLut != wlanExtInfo.macExtPort))
					{
						// LUT port moving
						skipHwlookUp_stat.status = TRUE;
						skipHwlookUp_stat.last_jiffies = jiffies;
						LUT("unmatched port info of %s(%pM) wlanDevIdx[%d]: %d(%d), skipHwlookUp_stat is ON for port %d(%d)", saLookup?"SMAC":"DMAC", mac, wlanDevIdx, macPortIdxByLut, macExtPortIdxByLut, macPort, wlanExtInfo.macExtPort);
					}
				}
				else
				{
					skipHwlookUp_stat.status = TRUE;
					skipHwlookUp_stat.last_jiffies = jiffies;
					LUT("unmatched port info of %s(%pM) wlanDevIdx[%d]: n.a.(n.a.), skipHwlookUp_stat is ON for port %d(%d)", saLookup?"SMAC":"DMAC", mac, wlanDevIdx, macPort, wlanExtInfo.macExtPort);
				}
			}
			else
			{
				if (saLookup) {
					skipHwlookUp_stat.status = TRUE;
					skipHwlookUp_stat.last_jiffies = jiffies;
					LUT("RTK_FC_WLANX_MULTI_INTF with unknown %s(%pM), skipHwlookUp_stat is ON for port %d(%d)", "SMAC", mac, macPort, wlanExtInfo.macExtPort);
				}
				else {
					// strange case, to wifi hw forwarding, but dmac not in lut tbl ?
					LUT("unlikely RTK_FC_WLANX_MULTI_INTF with unknown %s(%pM), skipHwlookUp_stat is ON for port %d(%d)", "DMAC", mac, macPort, wlanExtInfo.macExtPort);
				}
			}
			if(skipHwlookUp_stat.status == TRUE)
			{
				RTK_FC_HELPER_MGR_SKIPHWLOOKUP_STAT_GET(&ori_skipHwlookUp_stat);
				if(ori_skipHwlookUp_stat.status)
				{
					LUT("skipHwlookUp_stat is in use by port %d(%d), skipHwlookUp_stat is ON for port %d(%d) failed !!!", ori_skipHwlookUp_stat.portInfo.macPortIdx, ori_skipHwlookUp_stat.portInfo.macExtPortIdx, macPort, wlanExtInfo.macExtPort);
					wlanDevIdx = RTK_FC_WLANX_NOT_FOUND;	// Drop
				}
				else
				{
					skipHwlookUp_stat.portInfo.macPortIdx = macPort;
					skipHwlookUp_stat.portInfo.macExtPortIdx = wlanExtInfo.macExtPort;
					RTK_FC_HELPER_MGR_SKIPHWLOOKUP_STAT_SET(skipHwlookUp_stat);
					wlanDevIdx = RTK_FC_WLANX_NOT_FOUND;	// Drop
				}
			}

			if(lockReq) {
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
			}
		}
	}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	wlanDevIdx = wlanExtInfo.wlanDevIdx;

#else
#error
#endif

	return wlanDevIdx;
}

rtk_fc_wlan_devidx_t rtk_fc_wlan_rtmbssid_to_devidx(rt_wlan_index_t wlanIdx, rt_wlan_mbssid_index_t mbssidIdx)
{
	rtk_fc_wlan_devidx_t wlanDevIdx;

	RTK_FC_HELPER_WLAN_RTMBSSID_TO_DEVIDX(wlanIdx, mbssidIdx, &wlanDevIdx);

	return wlanDevIdx;
}

int rtk_fc_wlan_rtmbssidMask_to_devMask(rt_wlan_mbssid_mask_t *rtWlanMbssidMsk,rtk_fc_wlan_devmask_t *wlanDevIdMask)
{
	return RTK_FC_HELPER_WLAN_RTMBSSIDMSK_TO_DEVMSK(rtWlanMbssidMsk, wlanDevIdMask);
}

int rtk_fc_wlan_devMask_to_rtmbssidMask(rtk_fc_wlan_devmask_t *wlanDevIdMask,rt_wlan_mbssid_mask_t *rtWlanMbssidMsk)
{
	return RTK_FC_HELPER_WLAN_DEVMSK_TO_RTMBSSIDMSK(wlanDevIdMask, rtWlanMbssidMsk);
}


rtk_fc_ret_t rtk_fc_wan_portmask_set(rtk_fc_port_mask_t wanpmsk)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	
	fc_db.wanPortMask.portmask = wanpmsk;
	RTK_FC_HELPER_MGR_WAN_PORT_MASK_SET(wanpmsk);
	fc_db.lanPortMask.portmask = (RTK_FC_ALL_MAC_PORTMASK_WITHOUT_CPU& (~ fc_db.wanPortMask.portmask));
	/****  Other configuration ****/

	//reflash ACL
	_rtk_rg_aclAndCfReservedRuleAdd(RTK_FC_ACLANDCF_RESERVED_TAIL_END, NULL);

#if defined(CONFIG_FC_G3_G3LITE_SERIES) || defined(CONFIG_CA_G3_G3LITE_SERIES)
	/* set CLS WAN default fib for hashlite(unknowDA lookup)*/
	ASSERT_EQ(rtk_rg_g3_l3fe_unknownDA_wan_default_enable(__ffs(wanpmsk)), AAL_E_OK);
#endif

	return ret;
}

__IRAM_FC_SHORTCUT
unsigned int _rtk_fc_hash_mac_fid(unsigned char *mac, unsigned int fid)
{
	uint32 lutHashIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

unsigned char hashidx[9]={0};

	hashidx[8]=((mac[4]>>0)&1)^((mac[3]>>1)&1)^((mac[2]>>2)&1)^((mac[1]>>3)&1)^((mac[0]>>4)&1);
	hashidx[7]=((mac[5]>>7)&1)^((mac[3]>>0)&1)^((mac[2]>>1)&1)^((mac[1]>>2)&1)^((mac[0]>>3)&1);
	hashidx[6]=((mac[5]>>6)&1)^((mac[4]>>7)&1)^((mac[2]>>0)&1)^((mac[1]>>1)&1)^((mac[0]>>2)&1);
	hashidx[5]=((mac[5]>>5)&1)^((mac[4]>>6)&1)^((mac[3]>>7)&1)^((mac[1]>>0)&1)^((mac[0]>>1)&1);
	hashidx[4]=((mac[5]>>4)&1)^((mac[4]>>5)&1)^((mac[3]>>6)&1)^((mac[2]>>7)&1)^((mac[0]>>0)&1)^((fid>>1)&1);
	hashidx[3]=((mac[5]>>3)&1)^((mac[4]>>4)&1)^((mac[3]>>5)&1)^((mac[2]>>6)&1)^((mac[1]>>7)&1)^((fid>>0)&1);
	hashidx[2]=((mac[5]>>2)&1)^((mac[4]>>3)&1)^((mac[3]>>4)&1)^((mac[2]>>5)&1)^((mac[1]>>6)&1)^((mac[0]>>7)&1);
	hashidx[1]=((mac[5]>>1)&1)^((mac[4]>>2)&1)^((mac[3]>>3)&1)^((mac[2]>>4)&1)^((mac[1]>>5)&1)^((mac[0]>>6)&1);
	hashidx[0]=((mac[5]>>0)&1)^((mac[4]>>1)&1)^((mac[3]>>2)&1)^((mac[2]>>3)&1)^((mac[1]>>4)&1)^((mac[0]>>5)&1);
	lutHashIdx = ((hashidx[8]<<8)|(hashidx[7]<<7)|(hashidx[6]<<6)|(hashidx[5]<<5)|(hashidx[4]<<4)|(hashidx[3]<<3)|(hashidx[2]<<2)|(hashidx[1]<<1)|(hashidx[0]<<0));


#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	unsigned char hashidx[9]={0};

	hashidx[8]=((mac[4]>>0)&1)^((mac[3]>>1)&1)^((mac[2]>>2)&1)^((mac[1]>>3)&1)^((mac[0]>>4)&1);
	hashidx[7]=((mac[5]>>7)&1)^((mac[3]>>0)&1)^((mac[2]>>1)&1)^((mac[1]>>2)&1)^((mac[0]>>3)&1);
	hashidx[6]=((mac[5]>>6)&1)^((mac[4]>>7)&1)^((mac[2]>>0)&1)^((mac[1]>>1)&1)^((mac[0]>>2)&1);
	hashidx[5]=((mac[5]>>5)&1)^((mac[4]>>6)&1)^((mac[3]>>7)&1)^((mac[1]>>0)&1)^((mac[0]>>1)&1);
	hashidx[4]=((mac[5]>>4)&1)^((mac[4]>>5)&1)^((mac[3]>>6)&1)^((mac[2]>>7)&1)^((mac[0]>>0)&1);
	hashidx[3]=((mac[5]>>3)&1)^((mac[4]>>4)&1)^((mac[3]>>5)&1)^((mac[2]>>6)&1)^((mac[1]>>7)&1);
	hashidx[2]=((mac[5]>>2)&1)^((mac[4]>>3)&1)^((mac[3]>>4)&1)^((mac[2]>>5)&1)^((mac[1]>>6)&1)^((mac[0]>>7)&1);
	hashidx[1]=((mac[5]>>1)&1)^((mac[4]>>2)&1)^((mac[3]>>3)&1)^((mac[2]>>4)&1)^((mac[1]>>5)&1)^((mac[0]>>6)&1);
	hashidx[0]=((mac[5]>>0)&1)^((mac[4]>>1)&1)^((mac[3]>>2)&1)^((mac[2]>>3)&1)^((mac[1]>>4)&1)^((mac[0]>>5)&1);
	lutHashIdx = ((hashidx[8]<<8)|(hashidx[7]<<7)|(hashidx[6]<<6)|(hashidx[5]<<5)|(hashidx[4]<<4)|(hashidx[3]<<3)|(hashidx[2]<<2)|(hashidx[1]<<1)|(hashidx[0]<<0));

#else
#error
#endif
	assert(lutHashIdx<RTK_FC_LUT_BUCKET_SIZE);
	return lutHashIdx;
}

/* Lut pre-allocation */
void _rtk_fc_lutEntry_pool_init(void)
{
	int num = RTK_FC_LUTENTRY_POOL_SIZE;
	int i;


	memset(fc_db.lutEntry_pool_ring, 0, sizeof(rtk_fc_lut_entry_t *) * num);

	for(i=0;i<num;i++)
	{
		fc_db.lutEntry_pool_ring[i] = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_lut_entry_t), GFP_ATOMIC);
		if(fc_db.lutEntry_pool_ring[i]==NULL)
		{
			WARNING("[ERROR] Preallocte flow cache entries failed!\n\n");
		}
		INIT_LIST_HEAD(&fc_db.lutEntry_pool_ring[i]->lutList);
	}

	fc_db.lutEntry_pool_max = num;
	fc_db.lutEntry_pool_free = num;
    DEBUG("%s: %d initialized\n", __FUNCTION__, num);
}

rtk_fc_lut_entry_t *_rtk_fc_lutEntry_getFromPool(void)
{
	rtk_fc_lut_entry_t *pNewLutEntry=NULL;

	if(unlikely(fc_db.lutEntry_pool_free<=0))
	{
		WARNING("LUT free pool is empty.");
		return NULL;
	}

	fc_db.lutEntry_pool_free--;
	pNewLutEntry = fc_db.lutEntry_pool_ring[fc_db.lutEntry_pool_free];
	memset(pNewLutEntry, 0, sizeof(rtk_fc_lut_entry_t));
	INIT_LIST_HEAD(&pNewLutEntry->lutList);

    return pNewLutEntry;
}

void _rtk_fc_lutEntry_returnToPool(rtk_fc_lut_entry_t *pLutEntry)
{
	fc_db.lutEntry_pool_ring[fc_db.lutEntry_pool_free]=pLutEntry;
	fc_db.lutEntry_pool_free++;

	if (unlikely(fc_db.lutEntry_pool_free > fc_db.lutEntry_pool_max))
	        goto error;

	return;

error:
        WARNING("%s(%d): error cnt=%d max=%d\n",__FUNCTION__, __LINE__, fc_db.lutEntry_pool_free, fc_db.lutEntry_pool_max);
        dump_stack();
}

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
int _rtk_fc_hw_lut_idx_get(uint8 *mac, uint32 fid, uint32 *hwL2Idx)
{
	int32 i=0;
	uint32 l2Idx, ret;
	rtk_l2_addr_table_t l2entry;


	l2Idx = _rtk_fc_hash_mac_fid(mac, fid) << RTK_FC_LUT_HASH_WAY_SHIFT;

	DEBUG("mac %pM, search l2Idx starting from %d", mac, l2Idx);
	for(i=l2Idx; i<(l2Idx+RTK_FC_LUT_BUCKET_SIZE); i++)
	{
		ret=rtk_l2_nextValidEntry_get(&i, &l2entry);
		if(ret==RT_ERR_OK)
		{
			if(l2entry.entryType == RTK_LUT_L2UC) {
				if(!memcmp(l2entry.entry.l2UcEntry.mac.octet, mac, ETHER_ADDR_LEN))
				{
					*hwL2Idx = i;
					return RT_ERR_OK;
				}
			}else if (l2entry.entryType == RTK_LUT_L2MC) {	
				if(!memcmp(l2entry.entry.l2McEntry.mac.octet, mac, ETHER_ADDR_LEN))
				{
					*hwL2Idx = i;
					return RT_ERR_OK;
				}
			}
		}
	}

	//Search CAM
	for(i=LUTTABLE_SRAM_SIZE; i<RTK_FC_TABLESIZE_LUT; i++)
	{
		ret=rtk_l2_nextValidEntry_get(&i, &l2entry);
		if(ret==RT_ERR_OK)
		{
			if(l2entry.entryType == RTK_LUT_L2UC) {
				if(!memcmp(l2entry.entry.l2UcEntry.mac.octet, mac, ETHER_ADDR_LEN))
				{
					*hwL2Idx = i;
					return RT_ERR_OK;
				}
			}else if (l2entry.entryType == RTK_LUT_L2MC) {	
				if(!memcmp(l2entry.entry.l2McEntry.mac.octet, mac, ETHER_ADDR_LEN))
				{
					*hwL2Idx = i;
					return RT_ERR_OK;
				}
			}
		}

	}

	WARNING("Does not find corresponding hw lut entry, mac=%pM fid=%d", mac, fid);
	
	return RT_ERR_FAILED;
}

#endif

void rtk_fc_lut_free_entry(struct rcu_head *head)
{
	rtk_fc_lut_entry_t *pLutEntry = container_of(head, rtk_fc_lut_entry_t, lutRcuHead);
	
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
	
	if(pLutEntry->rcuFreeEnt_skipDel){
		TABLE("free lut[%d] mac: %pM, but bypss hw del action", pLutEntry->lutIdx, &pLutEntry->l2Addr[0]);
		pLutEntry->rcuFreeEnt_skipDel = FALSE;	// also will be cleared when getting from pool.
		goto END;
	}
	
	TABLE("free lut[%d] mac: %pM, free entry num = %d", pLutEntry->lutIdx, &pLutEntry->l2Addr[0], fc_db.lutEntry_pool_free);	
	
	fc_db.lutTbl[pLutEntry->lutIdx] = NULL;

	
END:	
	_rtk_fc_lutEntry_returnToPool(pLutEntry);

	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
}

int RTK_FC_LUT_ADD(rtk_fc_lut_entry_t *pLutEntry, int update)
{
	int ret = RTK_FC_RET_OK;
	uint32 lutHashIdx=0;
	uint32 lutQuickHashIdx=0;

	FC_PARAM_CHK((pLutEntry==NULL), RTK_FC_RET_ERR_NULL_POINTER);

	DEBUG("Learning lut mac:%pM on spa:%d extspa:%d isStatic:%d wlanIdx:%d",pLutEntry->l2Addr,pLutEntry->spa,pLutEntry->extspa,pLutEntry->isStatic,pLutEntry->wlan_dev_idx);

	lutHashIdx = _rtk_fc_hash_mac_fid(pLutEntry->l2Addr, pLutEntry->svl_fid);
	lutQuickHashIdx = _rtk_fc_quickhash_mac_fid(pLutEntry->l2Addr, pLutEntry->svl_fid);

 	// Add to H/W table
	if(RTK_FC_API_MODULE==NULL)
	{
		WARNING("[Error]  API module not init!");
		return -1;
	}
	if(RTK_FC_API_MODULE->rtk_fc_api_lut_add!= NULL)
	{
		ret = RTK_FC_API_MODULE->rtk_fc_api_lut_add(pLutEntry);
		if(ret)
		{
			DEBUG("Add LUT with return error(0x%x).",ret);	// include table full
			return ret;
		}
		else
		{
			if(update==TRUE)
			{
				TRACE("Update entry: L2[%d]", pLutEntry->lutIdx);
				return ret;
			}
			else if(update==FALSE && fc_db.lutTbl[pLutEntry->lutIdx] != NULL) {
				TRACE("add (%pM) new l2 to hw idx %d but sw tbl is occupied by mac %pM ", pLutEntry->l2Addr, pLutEntry->lutIdx, fc_db.lutTbl[pLutEntry->lutIdx]->l2Addr);

				if(fc_db.lutTbl[pLutEntry->lutIdx]->valid==FALSE) {
					// the old one will be freed later because of RCU, the new one should be add properly.
					TRACE("Lut old entry exist, lutHashIdx=%d, entIdx=%d, replace it", lutHashIdx, pLutEntry->lutIdx);
					fc_db.lutTbl[pLutEntry->lutIdx]->rcuFreeEnt_skipDel = TRUE;
					ret = RTK_FC_RET_OK;
				}else if(memcmp(pLutEntry->l2Addr, fc_db.lutTbl[pLutEntry->lutIdx]->l2Addr, ETH_ALEN)) {

					RTK_FC_API_MODULE->rtk_fc_api_lut_del(pLutEntry);

					return RTK_FC_RET_ERR;
				}else{
				
					return RTK_FC_RET_ERR_ENTRY_EXIST;
				}
				
			}
			// Only for non-static Unicast
			if((pLutEntry->spa < RTK_FC_MAC_PORT_MAX) && (pLutEntry->l2Addr[0]&0x1)==0x0 && pLutEntry->isStatic==0 && pLutEntry->svl_fid==0)
			{
				atomic_inc(&fc_db.macAddrLearningLimit[pLutEntry->spa].learningCount);
				if(0<=pLutEntry->wlan_dev_idx && pLutEntry->wlan_dev_idx<RTK_FC_WLANX_END_INTF)
					atomic_inc(&fc_db.wlanMacAddrLearningLimit[pLutEntry->wlan_dev_idx].learningCount);

				rtk_fc_macAddr_portGroup_lrnCnt_inc(pLutEntry);
			}

			fc_db.lutTbl[pLutEntry->lutIdx] = pLutEntry;
			if((RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE)<=pLutEntry->lutIdx && pLutEntry->lutIdx<RTK_FC_TABLESIZE_LUT)
				assert_ok(_rtk_fc_lutCamListAdd(lutHashIdx, pLutEntry->lutIdx));

			// S/W Sync.
			pLutEntry->valid = TRUE;
			list_add_tail_rcu(&pLutEntry->lutList,&fc_db.lut_hash_list_head[lutHashIdx]);
			list_add_tail_rcu(&pLutEntry->lutQuickList,&fc_db.lut_quickhash_list_head[lutQuickHashIdx]);

#if defined(CONFIG_FC_G3_G3LITE_SERIES)
			{
				uint32 entryidx = 0;
				int hashliterc = 0;
				hashliterc = rtk_rg_g3_l3fe_knownDA_add(pLutEntry->l2Addr, &entryidx);
				if(hashliterc == AAL_E_OK) {
					pLutEntry->daHashLiteIdx = entryidx;
					TABLE("add known da %pM to hashlite entry %d", &pLutEntry->l2Addr[0], entryidx);
				}else if (hashliterc == AAL_E_TBLFULL){
					pLutEntry->daHashLiteIdx = SIGNED_INVALID;
					TRACE("table full, fail to add known da %pM to hashlite entry", &pLutEntry->l2Addr[0]);
				}
				else {
					// other error reason
					pLutEntry->daHashLiteIdx = SIGNED_INVALID;
					WARNING("fail to add known da %pM to hashlite entry, ret = %d", &pLutEntry->l2Addr[0], hashliterc);
				}
			}
#endif
			DEBUG("<<<<< Add Lut successfully.");
		}

	}else{
		WARNING("[Error] callback func not init!");
	}

	return ret;
}

int RTK_FC_LUT_DEL(rtk_fc_lut_entry_t *pLutEntry, uint8 skipFlowFlush)
{
	int ret;

	if(RTK_FC_API_MODULE==NULL)
	{
		WARNING("[Error] Flow base API module not init!");
		return -1;
	}
	FC_PARAM_CHK((pLutEntry==NULL), RTK_FC_RET_ERR_NULL_POINTER);

	FC_PARAM_CHK((pLutEntry->valid==FALSE), RTK_FC_RET_OK);

	DEBUG("del lut[%d] mac:%pM on spa:%d wlanDevidx:%d", pLutEntry->lutIdx, pLutEntry->l2Addr,pLutEntry->spa, pLutEntry->wlan_dev_idx);

	if(pLutEntry->isStatic)
	{
		DEBUG("LUT entry is static, should not be deleted");
		return 0;
	}

	// Delete associated flow entries
	if(skipFlowFlush==FALSE && pLutEntry->anyFlowEstablish)
		rtk_fc_flow_delete_by_l2Idx(pLutEntry->lutIdx);

	// Only for non-static Unicast
	if((pLutEntry->l2Addr[0]&0x1)==0x0 && pLutEntry->isStatic==0)
	{
		atomic_dec(&fc_db.macAddrLearningLimit[pLutEntry->spa].learningCount);
		if(0<=pLutEntry->wlan_dev_idx && pLutEntry->wlan_dev_idx<RTK_FC_WLANX_END_INTF)
			atomic_dec(&fc_db.wlanMacAddrLearningLimit[pLutEntry->wlan_dev_idx].learningCount);
		rtk_fc_macAddr_portGroup_lrnCnt_dec(pLutEntry);
		
		if(fc_db.wanAccessLimit.limitField==RT_MISC_WAN_ACCESS_LIMIT_BY_MAC && pLutEntry->isPermitWanAccess)atomic_dec(&fc_db.wanAccessLimit.learningCount);
	}
	
	// Delete lut entry
	if(RTK_FC_API_MODULE->rtk_fc_api_lut_del != NULL)
	{
		ret = RTK_FC_API_MODULE->rtk_fc_api_lut_del(pLutEntry);
		if(ret)
		{
			WARNING("Del lut[%d] %pM with retrun error(0x%x).", pLutEntry->lutIdx, pLutEntry->l2Addr,ret);		// hw entry may not exist if user del it by rt api.
		}

#if defined(CONFIG_FC_G3_G3LITE_SERIES)
		if(pLutEntry->daHashLiteIdx != SIGNED_INVALID)
		{
			if(rtk_rg_g3_l3fe_knownDA_del(pLutEntry->daHashLiteIdx) == RTK_FC_RET_OK) {
				TABLE("del known da %pM from hashlite entry %d\n", &pLutEntry->l2Addr[0], pLutEntry->daHashLiteIdx);
			}else {
				WARNING("fail to del known da with hashlite entry idx %d\n", pLutEntry->daHashLiteIdx);
			}
		}
#endif
	}

	
	if((RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE)<=pLutEntry->lutIdx && pLutEntry->lutIdx<RTK_FC_TABLESIZE_LUT)
		assert_ok(_rtk_fc_lutCamListDel(pLutEntry->lutIdx));

	// S/W Sync.
	pLutEntry->valid = FALSE;
	list_del_rcu(&pLutEntry->lutList);
	list_del_rcu(&pLutEntry->lutQuickList);
	

	RTK_FC_HELPER_CALL_RCU(&pLutEntry->lutRcuHead, rtk_fc_lut_free_entry);

#if defined(CONFIG_FC_RTL9607C_SERIES)	
	if(pLutEntry->duplicateEntry_exist) {
		rtk_fc_wifi_lut_fid_t fid = RTK_FC_WIFI_FID_0;
		int16 lutIdx = 0;
		
		for(fid = RTK_FC_WIFI_FID_1 ; fid < fc_db.controlFuc.wifi_tx_gmac_trunking_num; fid++){
			ret = _rtk_fc_lut_find_fid(&pLutEntry->l2Addr[0], fid, &lutIdx);
			if(ret == RTK_FC_RET_OK) {
			#if defined(CONFIG_RTK_SOC_RTL8198D)
				if (fc_db.lutTbl[lutIdx]->wlan_dev_idx < RTK_FC_WLANX_NOT_FOUND && fc_db.lutTbl[lutIdx]->isStatic) {
					fc_db.lutTbl[lutIdx]->isStatic = 0;
				}
			#endif

				RTK_FC_LUT_DEL(fc_db.lutTbl[lutIdx], skipFlowFlush);
			}
		}
	}
#endif

	return SUCCESS;
}

bool _rtk_fc_lookup_fdb_force(unsigned char *mac, uint16 vid, rtk_fc_fdb_entry_t *fc_fdb)
{
	int i;
	bool found = FALSE;

	if(mac==NULL)
	{
		WARNING("[Fail to lookup fdb] mac is NULL");
		return FALSE;
	}
	if(fc_fdb==NULL)
	{
		WARNING("[Fail to lookup fdb] param err");
		return FALSE;
	}
	
	for(i = 0; i < RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].dev==NULL)
			continue;

		if(!RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE)) // check bridge dev
			continue;

		if(RTK_FC_HOOK_PS_FDB_TIME_GET(fc_db.netifTbl[i].dev, mac, vid, fc_fdb) == SUCCESS) {
			found = TRUE;
			break;
		}
	}

	if(found)
	{
		PSTACK("FDB MAC[%pM] on %s update time %lu", mac, fc_fdb->br_port_netdev->name, fc_fdb->updated);
		return TRUE;
	}else{
		PSTACK("[Fail to lookup fdb] [%pM] No fdb", mac);
		return FALSE;
	}

}

bool _rtk_fc_lookup_fdb(unsigned char *mac, uint16 vid, rtk_fc_fdb_entry_t *fc_fdb)
{
	if(fc_db.controlFuc.flow_skipAllPsTracking || fc_db.controlFuc.l2_skipPsTracking)
	{
		return FALSE;
	}

	return _rtk_fc_lookup_fdb_force(mac, vid, fc_fdb);
}

bool _rtk_fc_refresh_fdb(unsigned char *mac, uint16 vid)
{
	int i;

	if(mac==NULL)
	{
		WARNING("[Fail to lookup fdb] mac is NULL");
		return FALSE;
	}
	
	if(fc_db.controlFuc.flow_skipAllPsTracking || fc_db.controlFuc.l2_skipPsTracking)
	{
		return FALSE;
	}

	for(i = 0; i < RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].dev==NULL)
			continue;

		if(!RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE)) // check bridge dev
			continue;

		if(RTK_FC_HOOK_PS_FDB_REFRESH(fc_db.netifTbl[i].dev, mac, vid) == SUCCESS)
			return TRUE;
	}

	return FALSE;

}


bool _rtk_fc_lookup_v4neighbor(unsigned char *mac)
{
	int ret=RTK_FC_RET_ERR;
	if(mac==NULL) return FALSE;
	
	if(fc_db.controlFuc.flow_skipAllPsTracking || fc_db.controlFuc.l2_skipPsTracking)
	{
		return FALSE;
	}

	ret = RTK_FC_HOOK_PS_NEIGHV4_GET(mac);

	return (ret == RTK_FC_RET_OK) ? TRUE : FALSE;
}

bool _rtk_fc_lookup_v6neighbor(unsigned char *mac)
{
	int ret=RTK_FC_RET_ERR;
	if(mac==NULL) return FALSE;
	
	if(fc_db.controlFuc.flow_skipAllPsTracking || fc_db.controlFuc.l2_skipPsTracking)
	{
		return FALSE;
	}

//#if IS_ENABLED(CONFIG_IPV6)	// IPV6 state is decided by the compiler option from fc hook module.
	ret = RTK_FC_HOOK_PS_NEIGHV6_GET(mac);
//#endif

	return (ret == RTK_FC_RET_OK) ? TRUE : FALSE;
}

void _rtk_fc_enumerate_v4neighbor(void (*cb)(struct neighbour *, void *), void *cookie)
{
	RTK_FC_HOOK_PS_NEIGHV4_ENUMERATE(cb, cookie);
}

void _rtk_fc_enumerate_v6neighbor(void (*cb)(struct neighbour *, void *), void *cookie)
{
	RTK_FC_HOOK_PS_NEIGHV6_ENUMERATE(cb, cookie);
}

int _rtk_fc_compare_neighbor_ha_nud(struct neighbour *neigh, void *cookie, unsigned char state)
{
	int ret=RTK_FC_RET_ERR;
	if(neigh==NULL||cookie==NULL) return FALSE;

	ret = RTK_FC_HOOK_PS_NEIGH_KEY_NUD_COMPARE(neigh, FC_HELPER_KEY_HA, cookie, state);

	return (ret == RTK_FC_RET_OK) ? TRUE : FALSE;
}

int _rtk_fc_compare_neighbor_primary_key_nud(struct neighbour *neigh, void *cookie, unsigned char state)
{
	int ret=RTK_FC_RET_ERR;
	if(neigh==NULL||cookie==NULL) return FALSE;

	ret = RTK_FC_HOOK_PS_NEIGH_KEY_NUD_COMPARE(neigh, FC_HELPER_KEY_PRIMARY_KEY, cookie, state);

	return (ret == RTK_FC_RET_OK) ? TRUE : FALSE;
}

void _rtk_fc_update_neighbor_nud(struct neighbour * neigh, unsigned char state, unsigned int flag)
{
	RTK_FC_HOOK_PS_NEIGH_NUD_UPDATE(neigh, state, flag);
}

void _rtk_fc_learning_preparation(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);

	// Record packet is not from PS directly.
	pFcIngressData->isNotLocalOut = 1;

	// Record ingress info. in skb. for SA learning
//	pFcIngressData->reason = pPktHdr->reason;
	pFcIngressData->ingressPort = pPktHdr->ingressPort.macPortIdx;
	pFcIngressData->wlan_dev_idx = pPktHdr->igrWlanDevIdx;
	if(pPktHdr->eth!=NULL)	// It's already parsed
	{
		memcpy(pFcIngressData->sa, pPktHdr->eth->h_source, ETH_ALEN);
	}
	else
	{
		//
	}

	return;
}

int32 _rtk_fc_lut_nonStaticEntry_flush(void)
{
	rtk_fc_lut_entry_t *pLutEntry=NULL;
	int32 i = 0;

	for(i = 0; i < RTK_FC_LUT_BUCKET_SIZE; i++){
		list_for_each_entry_rcu(pLutEntry, &fc_db.lut_quickhash_list_head[i], lutQuickList)
		{
			rtk_fc_flow_delete_by_l2Idx(pLutEntry->lutIdx);
		}
	}

	return SUCCESS;
}

int32 _rtk_fc_lut_wlanDevidx_del(rtk_fc_wlan_devidx_t wlan_dev_idx)
{
	rtk_fc_lut_entry_t *pLutEntry=NULL;
	int32 i = 0;


	if(wlan_dev_idx >= RTK_FC_WLANX_END_INTF || fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SPEC_TEST) return SUCCESS;

	DEBUG("flush wlanDevidx[%d]", wlan_dev_idx);
	
	rtk_fc_flow_delete_by_wlanIdx(wlan_dev_idx);

	for(i = 0; i < RTK_FC_LUT_BUCKET_SIZE; i++){
		list_for_each_entry_rcu(pLutEntry, &fc_db.lut_quickhash_list_head[i], lutQuickList)
		{
			if(pLutEntry && pLutEntry->wlan_dev_idx == wlan_dev_idx)
			{
				RTK_FC_LUT_DEL(pLutEntry, TRUE);
			}
		}
	}

	return SUCCESS;
}

int32 _rtk_fc_lut_linkdown_del(uint32 portIdx)
{
	rtk_fc_lut_entry_t *pLutEntry=NULL;
	int32 i = 0;
#if 0// debug flush time 
	unsigned long start_jiffies=jiffies;
	struct timeval tv;
#endif

	if(!((fc_db.wanPortMask.portmask | fc_db.lanPortMask.portmask) & (1<<portIdx))|| (fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SPEC_TEST)) return SUCCESS;

	rtk_fc_flow_delete_by_spa(portIdx);

	for(i = 0; i < RTK_FC_LUT_BUCKET_SIZE; i++){
		list_for_each_entry_rcu(pLutEntry, &fc_db.lut_quickhash_list_head[i], lutQuickList)
		{
			if(pLutEntry && pLutEntry->spa == portIdx)
			{
				DEBUG("link down - delete lut[%d]", pLutEntry->lutIdx);
				RTK_FC_LUT_DEL(pLutEntry, TRUE);
			}
		}
	}

#if 0// debug flush time
	jiffies_to_timeval((jiffies - start_jiffies), &tv);
	WARNING("processing time = %ld.%06ld sec ", tv.tv_sec, tv.tv_usec);
#endif

	return SUCCESS;
}

int32 _rtk_fc_lut_staticEntry_del(uint32 lutIdx)
{
	int32 swEntIdx = 0;
	int isDevMac = FALSE;

	if(lutIdx>=RTK_FC_TABLESIZE_LUT){
		WARNING("[Fail to delete static lut] lut[%d] is out of range", lutIdx);
		return FAILED;
	}
	if(fc_db.lutTbl[lutIdx] == NULL){
		WARNING("[Fail to delete static lut] lut[%d] is not exist", lutIdx);
		return FAILED;
	}
	if(!fc_db.lutTbl[lutIdx]->isStatic){
#if defined(CONFIG_RTK_SOC_RTL8198D)
		if (fc_db.lutTbl[lutIdx]->wlan_dev_idx < RTK_FC_WLANX_NOT_FOUND) {
			EVENT("del %pM lut entry [%d] with [%u][%u][%u]", fc_db.lutTbl[lutIdx]->l2Addr, lutIdx, fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, fc_db.lutTbl[lutIdx]->wlan_dev_idx);
			assert_ok(RTK_FC_LUT_DEL(fc_db.lutTbl[lutIdx], FALSE));
			return SUCCESS;
		}
#endif
		WARNING("[Fail to delete static lut] lut[%d] is not static", lutIdx);
		return FAILED;
	}
	if(fc_db.lutTbl[lutIdx]->staticRefCount==0){
		WARNING("[Fail to delete static lut] lut[%d]'s staticRefCount is zero", lutIdx);
		return FAILED;
	}

	for(swEntIdx = 0;swEntIdx < RTK_FC_TABLESIZE_INTF_SW; swEntIdx++){
		if(fc_db.netifTbl[swEntIdx].lutIdx == lutIdx)
		{
			DEBUG("Find dev %s according lut[%d]", fc_db.netifTbl[swEntIdx].dev->name,lutIdx);
			isDevMac = TRUE;
			break;
		}
	}
	
	fc_db.lutTbl[lutIdx]->staticRefCount--;

#if defined(CONFIG_RTK_SOC_RTL8198D)
	// force to delete static wifi lut
	if (fc_db.lutTbl[lutIdx]->staticRefCount && fc_db.lutTbl[lutIdx]->wlan_dev_idx < RTK_FC_WLANX_NOT_FOUND) {
		fc_db.lutTbl[lutIdx]->staticRefCount = 0;
	}
#endif

	if(fc_db.lutTbl[lutIdx]->staticRefCount==0)
		fc_db.lutTbl[lutIdx]->isStatic=0;

	if(fc_db.lutTbl[lutIdx]->isStatic==0) {
		if((fc_db.lutTbl[lutIdx]->l2Addr[0]&1) ){
			//multicast && non-static && non-kernel mode delete lut entry immediately
			TABLE("del lut[%d]", lutIdx);
			assert_ok(RTK_FC_LUT_DEL(fc_db.lutTbl[lutIdx], FALSE));
		}else if((fc_db.lutTbl[lutIdx]->l2Addr[0]&1)==0 && isDevMac && fc_db.lutTbl[lutIdx]->wlan_dev_idx==RTK_FC_WLANX_NOT_FOUND) {
			//interface mac && non-static && delete lut entry immediately
			int spa = fc_db.lutTbl[lutIdx]->spa;
			TABLE("del interface lut[%d]", lutIdx);
			assert_ok(RTK_FC_LUT_DEL(fc_db.lutTbl[lutIdx], FALSE));
			//recover it because static adding didn't increase learningcnt but del action did that.
			atomic_inc(&fc_db.macAddrLearningLimit[spa].learningCount);	
			if(fc_db.macAddr_portGroup.group.portmask & (1<<spa)) {
				atomic_inc(&fc_db.macAddr_portGroup.limitCfg.learningCount);
			}
			
		}
#if defined(CONFIG_RTK_SOC_RTL8198D)
		else if (fc_db.lutTbl[lutIdx]->wlan_dev_idx < RTK_FC_WLANX_NOT_FOUND) {
			EVENT("del %pM lut entry [%d] with [%u][%u][%u]", fc_db.lutTbl[lutIdx]->l2Addr, lutIdx, fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, fc_db.lutTbl[lutIdx]->wlan_dev_idx);
			assert_ok(RTK_FC_LUT_DEL(fc_db.lutTbl[lutIdx], FALSE));
		}
#endif
	}

	return SUCCESS;
}

rtk_fc_ret_t _rtk_fc_lut_find_fid(uint8 *mac, uint8 fid,int16 *lutIdx)
{
	rtk_fc_lut_entry_t *pLutEntry=NULL;
	int32 lutHashIdx=0;

	// hw hash
	lutHashIdx = _rtk_fc_hash_mac_fid(mac, fid);

	list_for_each_entry_rcu(pLutEntry, &fc_db.lut_hash_list_head[lutHashIdx], lutList)
	{
		if(pLutEntry && !memcmp(pLutEntry->l2Addr, mac, ETH_ALEN) && (pLutEntry->svl_fid == fid))
		{
			*lutIdx = pLutEntry->lutIdx;
			return RTK_FC_RET_OK;
		}
	}

	return RTK_FC_RET_ERR;
}

__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_lut_find(uint8 *mac, int16 *lutIdx)
{
	rtk_fc_lut_entry_t *pLutEntry=NULL;
	int32 lutHashIdx=0;

	// sw quickhash - don't care fid!			
	lutHashIdx = _rtk_fc_quickhash_mac_fid(mac, DEFAULT_FID);

	list_for_each_entry_rcu(pLutEntry, &fc_db.lut_quickhash_list_head[lutHashIdx], lutQuickList)
	{
		if(pLutEntry && !memcmp(pLutEntry->l2Addr, mac, ETH_ALEN))
		{
			*lutIdx = pLutEntry->lutIdx;
			return RTK_FC_RET_OK;
		}
	}

	return RTK_FC_RET_ERR;
}

/* For ingress handling, MUST acquire global lock first if add/del any fc_db entries */
__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_lut_portmoving_check(int32 lutIdx, rtk_fc_pmap_t curPortMap, rtk_fc_wlan_devidx_t wlanDevIdx, uint16 cvid)
{
	uint32 i;
	int32 swEntIdx = 0;

	if(lutIdx==FAIL ||  lutIdx>=RTK_FC_TABLESIZE_LUT ){
		WARNING("l2 index %d is invalid", lutIdx);
		return RTK_FC_RET_ERR;
	}

	if(fc_db.lutTbl[lutIdx]==NULL) {
		WARNING("l2 index %d not exist, please check l2 table", lutIdx);
		return RTK_FC_RET_ERR;
	}
	if(unlikely(1<<curPortMap.macPortIdx& fc_db.port_enable_port_moving_bitmask )) // Disable port moving
	{
		if((fc_db.lutTbl[lutIdx]->spa != curPortMap.macPortIdx) && fc_db.lutTbl[lutIdx]->isUnknowUcMc==0)
		{
			DEBUG("[Port Moving]Port %d setting is disable port-moving, so drop packetet", curPortMap.macPortIdx);
			return RTK_FC_RET_DROP;
		}
	}
	if(unlikely( (fc_db.lutTbl[lutIdx]->spa != curPortMap.macPortIdx) ||
		(fc_db.lutTbl[lutIdx]->extspa!= curPortMap.macExtPortIdx) ||
		(fc_db.lutTbl[lutIdx]->wlan_dev_idx != wlanDevIdx) ) ) 
	{
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();

		// port moving, traverse MC flow table, to delete static SMAC LUT entry and related flow
		if(fc_db.lutTbl[lutIdx]->isStatic) 
		{
			rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
			rtk_fc_mcExtraSwFlowIdx_entry_t *mcTmpSwFlowId_entry=NULL;
			for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
			{
				list_for_each_entry_safe(mcSwFlowId_entry,mcTmpSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
				{
					if(fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].lutIgrSaIdx!=FAIL && fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].lutIgrSaIdx ==lutIdx)
					{
						rtk_fc_flow_delete(mcSwFlowId_entry->swFlowIdx);
					}
				}	
			}
		}
		// LUT static entry: gateway MAC, MC MAC, source MAC of MC flow entry.

		if(fc_db.lutTbl[lutIdx]->isStatic) 
		{
			if (((1 << (char)curPortMap.macPortIdx) & fc_db.wanPortMask.portmask) == 0) {
				// find swEntIdx
				for(swEntIdx = 0;swEntIdx < RTK_FC_TABLESIZE_INTF_SW; swEntIdx++){
					int hw_idx = fc_db.netifTbl[swEntIdx].hwIdx;
					if((hw_idx != SIGNED_INVALID) && fc_db.netifHwTbl[hw_idx].lutIdx == lutIdx){					
						rtk_fc_tableNetif_t *netifTable = & fc_db.netifTbl[swEntIdx];
						rtk_fc_pmap_t portmap;
						int16 macL2Idx = 0;

						if (fc_db.mac_clone_enable == 0) {
							TRACE("skip netif %s lut port moving, l2 entry[%d]", fc_db.netifTbl[swEntIdx].dev->name, lutIdx);
							RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
							return RTK_FC_RET_LRN_SKIP_UNKNOWNSA;
						}

						if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[swEntIdx].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE) || RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[swEntIdx].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_BRIDGE_PORT))
						{
							WARNING("dev %s does not do port moving!!!!!\n",fc_db.netifTbl[swEntIdx].dev->name);
							
							RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
							return RTK_FC_RET_ERR;
						}
						TRACE("%s do port moving, update l2 entry[%d]", fc_db.netifTbl[swEntIdx].dev->name, lutIdx);

						//update swnetif, lut reference count --
						if(netifTable->lutIdx != SIGNED_INVALID)
						{
							_rtk_fc_lut_staticEntry_del(netifTable->lutIdx);
						}

						rtk_fc_netif_port_info_set(swEntIdx, (char)curPortMap.macPortIdx, (char)curPortMap.macExtPortIdx, wlanDevIdx);
						rtk_fc_netif_update(swEntIdx);

						//update swnetif, lut reference count ++
						portmap.macPortIdx = netifTable->macportidx;
						portmap.macExtPortIdx = netifTable->macextportidx;

						_rtk_fc_lut_learning(&netifTable->intf.gateway_mac_addr.octet[0], portmap, netifTable->vlanId, wlanDevIdx,
											FALSE, TRUE,&macL2Idx);
						netifTable->lutIdx = macL2Idx;

						break;
					}
				}
				if (swEntIdx == RTK_FC_TABLESIZE_INTF_SW) {
					TRACE("swEntIdx is not found. port moving from port %d(%d) to %d(%d), ignore it and return fail since l2[%d] (%pM) is a static one",
						fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, curPortMap.macPortIdx, curPortMap.macExtPortIdx, lutIdx, fc_db.lutTbl[lutIdx]->l2Addr);

					RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
					return RTK_FC_RET_ERR;
				}
			}else {
				TRACE("port moving from port %d(%d) to %d(%d), ignore it and return fail since l2[%d] (%pM) is a static one",
					fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, curPortMap.macPortIdx, curPortMap.macExtPortIdx, lutIdx, fc_db.lutTbl[lutIdx]->l2Addr);

				RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
				return RTK_FC_RET_ERR;
			}
		}
		else 
		{
			TRACE("spa unmatch / port moving (ingress: port/extPort/wlanIdx(%d/%d/%d), LUT: port/extPort/wlanIdx(%d/%d/%d)), del l2 entry[%d]", 
				curPortMap.macPortIdx, curPortMap.macExtPortIdx, wlanDevIdx, fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, fc_db.lutTbl[lutIdx]->wlan_dev_idx, lutIdx);
			assert_ok(RTK_FC_LUT_DEL(fc_db.lutTbl[lutIdx], FALSE));

			RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
			return RTK_FC_RET_ERR;
		}
		
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	}

	if(unlikely(fc_db.l2_port_moving_check_with_vlan !=0 && fc_db.lutTbl[lutIdx]->CVID != cvid))
	{
		if(fc_db.lutTbl[lutIdx]->isStatic) {
			
			RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
			
			if (((1 << (char)curPortMap.macPortIdx) & fc_db.wanPortMask.portmask) == 0) {
				// find swEntIdx
				for(swEntIdx = 0;swEntIdx < RTK_FC_TABLESIZE_INTF_SW; swEntIdx++){
				int hw_idx = fc_db.netifTbl[swEntIdx].hwIdx;
				if((hw_idx != SIGNED_INVALID) && fc_db.netifHwTbl[hw_idx].lutIdx == lutIdx){
					rtk_fc_tableNetif_t *netifTable = & fc_db.netifTbl[swEntIdx];
					rtk_fc_pmap_t portmap;
					int16 macL2Idx = 0;
					
					if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[swEntIdx].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE) || RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[swEntIdx].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_BRIDGE_PORT))
					{
						WARNING("dev %s does not do port moving!!!!!\n",fc_db.netifTbl[swEntIdx].dev->name);

						RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
						return RTK_FC_RET_ERR;
					}
					TRACE("%s do port moving, update l2 entry[%d]", fc_db.netifTbl[swEntIdx].dev->name, lutIdx);

					//update swnetif, lut reference count --
					if(netifTable->lutIdx != SIGNED_INVALID)
					{
						_rtk_fc_lut_staticEntry_del(netifTable->lutIdx);
					}
					// port moving now
					rtk_fc_netif_port_info_set(swEntIdx, (char)curPortMap.macPortIdx, (char)curPortMap.macExtPortIdx, wlanDevIdx);
					// update hwnetif
					rtk_fc_netif_update(swEntIdx);

					//update swnetif, lut reference count ++
					portmap.macPortIdx = netifTable->macportidx;
					portmap.macExtPortIdx = netifTable->macextportidx;
					_rtk_fc_lut_learning(&netifTable->intf.gateway_mac_addr.octet[0], portmap, netifTable->vlanId, netifTable->wlanidx,
											FALSE, TRUE,&macL2Idx);
					netifTable->lutIdx = macL2Idx;
					
					break;
					}
				}
				if (swEntIdx == RTK_FC_TABLESIZE_INTF_SW) {
					TRACE("swEntIdx is not found. port moving from port %d(%d) to %d(%d), ignore it and return fail since l2[%d] (%pM) is a static one",
						fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, curPortMap.macPortIdx, curPortMap.macExtPortIdx, lutIdx, fc_db.lutTbl[lutIdx]->l2Addr);
					
					RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
					return RTK_FC_RET_ERR;
				}
			}else {
				TRACE("port moving from port %d(%d) to %d(%d), ignore it and return fail since l2[%d] (%pM) is a static one",
					fc_db.lutTbl[lutIdx]->spa, fc_db.lutTbl[lutIdx]->extspa, curPortMap.macPortIdx, curPortMap.macExtPortIdx, lutIdx, fc_db.lutTbl[lutIdx]->l2Addr);

				RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
				return RTK_FC_RET_ERR;
			}
			
			RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
		}
		else {		
			RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
			
			TRACE("Mac: %pM (vlan:%d) with new vlan:%d, delete LUT but not delete flow!", &fc_db.lutTbl[lutIdx]->l2Addr[0],fc_db.lutTbl[lutIdx]->CVID,cvid);
			fc_db.lutTbl[lutIdx]->CVID = cvid;
			fc_db.lutTbl[lutIdx]->CTAG_IF = (cvid!=0) ? 1 : 0;
			if(fc_db.lutTbl[lutIdx]->isUnknowUcMc)
				fc_db.lutTbl[lutIdx]->isUnknowUcMc=0;
			assert_ok(RTK_FC_LUT_ADD(fc_db.lutTbl[lutIdx], TRUE));

			RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
			return RTK_FC_RET_OK;
		}
		
	}

	return RTK_FC_RET_OK;
}

int32 _rtk_fc_lut_LRU(uint32 lutHashIdx)
{
	int i = 0;
	rtk_fc_lut_entry_t *pLruLutEntry=NULL, *pLruLutEntry_Flow=NULL, *pLruLutEntry_noFlow=NULL, *pLutEntry=NULL;
	unsigned long leastRecentlyAccTime=jiffies+1;	// always pickup the first one
	unsigned long leastRecentlyAccTime_noFlow=leastRecentlyAccTime;
	int32 victimLutIdx=SIGNED_INVALID;

	TRACE("[Lut table is full] Try to do LRU !! lutHashIdx = %d", lutHashIdx);

	// scan SRAM bucket
	list_for_each_entry_rcu(pLutEntry, &fc_db.lut_hash_list_head[lutHashIdx], lutList)
	{
		if(pLutEntry->isStatic || (pLutEntry->l2Addr[0] & 0x1))
			continue;

		if(pLruLutEntry_noFlow && pLutEntry->anyFlowEstablish)
			continue;

		DEBUG("check lut[%d] anyFlowEstablish:%d jiffies:%lu noflow_jiffies:%lu flow_jiffies:%lu", 
			pLutEntry->lutIdx, pLutEntry->anyFlowEstablish, pLutEntry->last_jiffies, leastRecentlyAccTime_noFlow, leastRecentlyAccTime);
		
		/* find LRU lut without flow entry */
		if((pLutEntry->anyFlowEstablish==FALSE) && 
			time_after(leastRecentlyAccTime_noFlow, pLutEntry->last_jiffies)) {
			
			leastRecentlyAccTime_noFlow = pLutEntry->last_jiffies;
			pLruLutEntry_noFlow = pLutEntry;
		}
		
		/* find LRU lut with flow entry */
		if((pLutEntry->anyFlowEstablish==TRUE) && 
			time_after(leastRecentlyAccTime, pLutEntry->last_jiffies)) {
			
			leastRecentlyAccTime = pLutEntry->last_jiffies;
			pLruLutEntry_Flow = pLutEntry;
		}
	}

	// scan CAM table
	for(i = LUTTABLE_SRAM_SIZE; i < RTK_FC_TABLESIZE_LUT; i++) {
		
		pLutEntry = fc_db.lutTbl[i];
		
		if(!pLutEntry)
			continue;

		if(!pLutEntry->valid ||pLutEntry->isStatic || (pLutEntry->l2Addr[0] & 0x1))
			continue;

		if(pLruLutEntry_noFlow && pLutEntry->anyFlowEstablish)
			continue;

		DEBUG("check lut[%d] anyFlowEstablish:%d jiffies:%lu noflow_jiffies:%lu flow_jiffies:%lu", 
			pLutEntry->lutIdx, pLutEntry->anyFlowEstablish, pLutEntry->last_jiffies, leastRecentlyAccTime_noFlow, leastRecentlyAccTime);
		
		/* find LRU lut without flow entry */
		if((pLutEntry->anyFlowEstablish==FALSE) && 
			time_after(leastRecentlyAccTime_noFlow, pLutEntry->last_jiffies)) {
			
			leastRecentlyAccTime_noFlow = pLutEntry->last_jiffies;
			pLruLutEntry_noFlow = pLutEntry;
		}
		
		/* find LRU lut with flow entry */
		if((pLutEntry->anyFlowEstablish==TRUE) && 
			time_after(leastRecentlyAccTime, pLutEntry->last_jiffies)) {
			
			leastRecentlyAccTime = pLutEntry->last_jiffies;
			pLruLutEntry_Flow = pLutEntry;
		}
	}

	if(pLruLutEntry_noFlow) {
		pLruLutEntry = pLruLutEntry_noFlow;
	}
	else if(pLruLutEntry_Flow) {
		pLruLutEntry = pLruLutEntry_Flow;
	}

	if(pLruLutEntry) {
		victimLutIdx = pLruLutEntry->lutIdx;
		TABLE("LRU - del lut[%d] MAC: %pM anyFlowEstablish: %d", victimLutIdx, &pLruLutEntry->l2Addr[0], pLruLutEntry->anyFlowEstablish);
		assert_ok(RTK_FC_LUT_DEL(pLruLutEntry, pLruLutEntry->anyFlowEstablish ? FALSE : TRUE));
	}else {
		WARNING("FAIL to find LRU entry");
	}

	return victimLutIdx;
}

uint8 _rtk_fc_lut_learning_check(rtk_fc_pktHdr_t *pPktHdr)
{
	uint8 doLutLearn=FALSE;
	uint32 i, dip;

	if(pPktHdr->arph)
	{
		// Ethernet environment
		if(pPktHdr->arph->ar_hln==6 && pPktHdr->arph->ar_pln==4)
		{
			if(ntohs(pPktHdr->arph->ar_op)==ARPOP_REPLY)
			{
				if(pPktHdr->dmacToGatewayMAC)
				{
					DEBUG("[ARP reply] DMAC==GMAC ...do SMAC learning");
					doLutLearn = TRUE;
				}
			}
			else if(ntohs(pPktHdr->arph->ar_op)==ARPOP_REQUEST)
			{
				dip = ntohl(*(uint32 *)((unsigned char *)pPktHdr->arph + 24));
				DEBUG("[ARP request] target IP is %pI4h", &dip);
				for(i=0; i<RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].hwIdx==FAIL)
						continue;
					if(fc_db.netifTbl[i].intf.gateway_ipv4_addr==dip)
					{
						DEBUG("[ARP request] target IP is our gateway IP ...do SMAC learning");
						doLutLearn = TRUE;
						break;
					}
				}
			}
		}
	}
	else if(pPktHdr->icmp6h)
	{
		if(pPktHdr->icmp6h->icmp6_type==ICMPV6_NA)
		{
			if(pPktHdr->dmacToGatewayMAC)
			{
				DEBUG("[NA] DMAC==GMAC ...do SMAC learning");
				doLutLearn = TRUE;
			}
		}
		else if(pPktHdr->icmp6h->icmp6_type==ICMPV6_NS)
		{
			FIXME("[NS] target IP is our gateway IP ...do SMAC learning");
		}
	}

	return doLutLearn;
}

//SA Learning
rtk_fc_ret_t _rtk_fc_lut_learning(uint8 *srcMac, rtk_fc_pmap_t igrPort, uint16 vid,
					rtk_fc_wlan_devidx_t wlan_dev_idx, uint8 verify_fdb, uint8 isStatic, int16 *macL2Idx)
{
	int ret;
	rtk_fc_lut_entry_t *pLutEntry, *pNextLutEntry, *pNewLutEntry;
	bool fdb_exist=FALSE, v4neigh_exist=FALSE, v6neigh_exist=FALSE;
	rtk_fc_fdb_entry_t fc_fdb;
	int32 lutHashIdx=0;
	unsigned char flag_isSync2PsEntry = TRUE;
	rtk_fc_skipHwlookUp_stat_t skipHwlookUp_stat;
	rtk_fc_pmap_t ingressPort=igrPort;
	uint8 unknownUCMC=FALSE;
#if defined(CONFIG_RTK_SOC_RTL8198D)
	bool wifi_lut_moving = FALSE;
#endif

	if(srcMac==NULL)
		return RTK_FC_RET_LRN_NULL_POINTER;

	//for unknow unicast we force learning on port RTK_FC_MAC_PORT0 
	if(RTK_FC_MAC_PORT_MAX==igrPort.macPortIdx && RTK_FC_MAC_EXT_PORT_MAX==ingressPort.macExtPortIdx && RTK_FC_WLANX_NOT_FOUND == wlan_dev_idx)
	{
		ingressPort.macPortIdx = RTK_FC_MAC_PORT0;
		ingressPort.macExtPortIdx = RTK_FC_MAC_EXT_PORT_MAX;
		unknownUCMC=TRUE;
	}

	if(!isStatic && (RTK_FC_MAC_PORT_MAINCPU == ingressPort.macPortIdx) && (wlan_dev_idx == RTK_FC_WLANX_NOT_FOUND)
#if defined(CONFIG_FC_RTL8198F_SERIES)
        && !(fc_db.controlFuc.pe_fc_enable && (ingressPort.macPortIdx == fc_db.controlFuc.pe_port))
#endif
        )
	{
		TRACE("[Skip lut learning] SPA[%d] is from pure cpu port.", ingressPort.macPortIdx);
		return RTK_FC_RET_LRN_SKIP_FROMCPUPKT;
	}

	if(srcMac[0]&0x1)
	{
		TRACE("[Skip lut learning] SMAC is BC/MC.");
		return RTK_FC_RET_LRN_SKIP_MCPKT;
	}

	if((srcMac[0]|srcMac[1]|srcMac[2]|srcMac[3]|srcMac[4]|srcMac[5])==0)
	{
		TRACE("[Skip lut learning] SMAC is 00:00:00:00:00:00");
		return RTK_FC_RET_LRN_SKIP_MCPKT;
	}


	DEBUG("learn MAC=%pM, spa=%d(%d), wlan_dev_idx=%d", srcMac, ingressPort.macPortIdx, ingressPort.macExtPortIdx, wlan_dev_idx);


	lutHashIdx = _rtk_fc_hash_mac_fid(srcMac, DEFAULT_FID);

	//Duplicate check
	list_for_each_entry_safe(pLutEntry, pNextLutEntry, &fc_db.lut_hash_list_head[lutHashIdx], lutList)
	{
		if(pLutEntry && !memcmp(pLutEntry->l2Addr, srcMac, ETH_ALEN))
		{
		#if defined(CONFIG_RTK_SOC_RTL8198D)
			if((isStatic && wlan_dev_idx == RTK_FC_WLANX_NOT_FOUND) || (pLutEntry->spa == ingressPort.macPortIdx && pLutEntry->extspa == ingressPort.macExtPortIdx
				&& pLutEntry->wlan_dev_idx == wlan_dev_idx
				))
		#else
			// for static (gmac) entry, no needed to check spa
			if(isStatic || (pLutEntry->spa == ingressPort.macPortIdx && pLutEntry->extspa == ingressPort.macExtPortIdx
				&& pLutEntry->wlan_dev_idx == wlan_dev_idx
				))
		#endif
			{

			#if defined(CONFIG_RTK_SOC_RTL8198D)
				if (isStatic && (pLutEntry->wlan_dev_idx != RTK_FC_WLANX_NOT_FOUND) && !pLutEntry->isStatic) {
					EVENT("moving wifi non-static %pM lut [%d] with [%u][%u][%u] to static", 
						pLutEntry->l2Addr, pLutEntry->lutIdx, pLutEntry->spa, pLutEntry->extspa, pLutEntry->wlan_dev_idx);
				}
			#endif

				if(isStatic)
				{
					pLutEntry->isStatic = TRUE;
					pLutEntry->staticRefCount++;
					pLutEntry->isSync2PsEntry = FALSE; //Static entry not sync to Linux FDB/neighbor
				}
				if(verify_fdb && pLutEntry->isSync2PsEntry == FALSE)
				{
					fdb_exist = _rtk_fc_lookup_fdb(srcMac, vid, &fc_fdb);

					v4neigh_exist = _rtk_fc_lookup_v4neighbor(srcMac);

					v6neigh_exist = _rtk_fc_lookup_v6neighbor(srcMac);

					if(!pLutEntry->isStatic)
					{
						if(fdb_exist==FALSE && v4neigh_exist==FALSE && v6neigh_exist==FALSE)
						{
							TRACE("fdb and Neighbor(v4/v6) are all not found., Change isSync2PsEntry state.");
							pLutEntry->isSync2PsEntry = FALSE;
						}
						else
							pLutEntry->isSync2PsEntry = TRUE;
					}
				}
				pLutEntry->last_jiffies = jiffies;
				TRACE("[Lut learning] match exist lut[%d]", pLutEntry->lutIdx);
				*macL2Idx = pLutEntry->lutIdx;
				return RTK_FC_RET_OK;
			}
			else //port moving
			{
				if(pLutEntry->isStatic) {
				#if defined(CONFIG_RTK_SOC_RTL8198D)
					// may do port moving for static wifi lut
					if (pLutEntry->wlan_dev_idx == RTK_FC_WLANX_NOT_FOUND)
				#endif
					{
						// the original lut entry is a static one, current packet could not be recognized. Not handle it, return fail.
						TRACE("lut idx[%d](%pM) is static but spa (%d/%d) is not matching with current pkt (from %d/%d)?", pLutEntry->lutIdx, srcMac, pLutEntry->spa, pLutEntry->extspa, ingressPort.macPortIdx, ingressPort.macExtPortIdx);
						return RTK_FC_RET_LRN_FAIL;
					}

				#if defined(CONFIG_RTK_SOC_RTL8198D)
					if (!isStatic && pLutEntry->wlan_dev_idx != RTK_FC_WLANX_NOT_FOUND && wlan_dev_idx != RTK_FC_WLANX_NOT_FOUND) {
						EVENT("prevent %pM wifi lut [%d] portmoving from static to non-static, old lut=[%u][%u][%u] new info=[%u][%u][%u]", 
							pLutEntry->l2Addr, pLutEntry->lutIdx, pLutEntry->spa, pLutEntry->extspa, pLutEntry->wlan_dev_idx, 
							ingressPort.macPortIdx, ingressPort.macExtPortIdx, wlan_dev_idx);
						return RTK_FC_RET_LRN_FAIL;
					}

					wifi_lut_moving = TRUE;
					pLutEntry->isStatic = FALSE;
					EVENT("delete static %pM old lut [%d] and prepare to do wifi lut port moving, isStatic=%u, old lut=[%u][%u][%u] new info=[%u][%u][%u]", 
						pLutEntry->l2Addr, pLutEntry->lutIdx, isStatic, pLutEntry->spa, pLutEntry->extspa, pLutEntry->wlan_dev_idx, 
						ingressPort.macPortIdx, ingressPort.macExtPortIdx, wlan_dev_idx);
				#endif
				}
			#if defined(CONFIG_RTK_SOC_RTL8198D)
				else if (pLutEntry->wlan_dev_idx != RTK_FC_WLANX_NOT_FOUND || wlan_dev_idx != RTK_FC_WLANX_NOT_FOUND) {
					wifi_lut_moving = TRUE;
					EVENT("delete non-static %pM old lut [%d] and prepare to do wifi lut port moving, isStatic=%u, old lut=[%u][%u][%u] new info=[%u][%u][%u]", 
						pLutEntry->l2Addr, pLutEntry->lutIdx, isStatic, pLutEntry->spa, pLutEntry->extspa, pLutEntry->wlan_dev_idx, 
						ingressPort.macPortIdx, ingressPort.macExtPortIdx, wlan_dev_idx);
				}
			#endif

				assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
				break;
			}
		}else
			{
					TRACE("duplicate check, lut[%d] unmatch!!!!", pLutEntry->lutIdx);
			}
	}

	if(verify_fdb)
	{
		fdb_exist = _rtk_fc_lookup_fdb(srcMac, vid, &fc_fdb);

		v4neigh_exist = _rtk_fc_lookup_v4neighbor(srcMac);

		v6neigh_exist = _rtk_fc_lookup_v6neighbor(srcMac);

		if(fdb_exist==FALSE && v4neigh_exist==FALSE && v6neigh_exist==FALSE)
		{
			if(isStatic)
			{
				TRACE("[Forcibly add lut] fdb and Neighbor(v4/v6) are all not found.");
			}
			else
			{
				// for PS: the mac is not learned yet so it may be unknown da flooding
				TRACE("fdb and Neighbor(v4/v6) are all not found. unknown mac.");
				return RTK_FC_RET_LRN_FAIL;
				
			}
		}
		else
		{
			TRACE("fdb is %s, v4_neighbor is %s, v6_neighbor is %s", (fdb_exist==FALSE)?"NULL":"Found", (v4neigh_exist==FALSE)?"NULL":"Found", (v6neigh_exist==FALSE)?"NULL":"Found");
		}
	
	}
	else
	{
		TRACE("No need to verify fdb/neighbor");
		fdb_exist = FALSE;
		v4neigh_exist = FALSE;
		v6neigh_exist = FALSE;
		flag_isSync2PsEntry = FALSE;
	}

	{		
		// Add lut entry, the entry idx is fully controlled by HW
		pNewLutEntry = _rtk_fc_lutEntry_getFromPool();
		if(pNewLutEntry==NULL)
		{
			//WARNING("[Fail to add lut] Lut table pool is full.");
			return RTK_FC_RET_ERR_ENTRY_FULL;
		}
		pNewLutEntry->spa = ingressPort.macPortIdx;
		pNewLutEntry->extspa = ingressPort.macExtPortIdx;
		pNewLutEntry->wlan_dev_idx = wlan_dev_idx;
		memcpy(pNewLutEntry->l2Addr, srcMac, ETH_ALEN);
		pNewLutEntry->isStatic = isStatic;
		pNewLutEntry->last_jiffies =jiffies;
		pNewLutEntry->isUnknowUcMc = unknownUCMC;

		// if there is no ctag, the vid will be zero.
		pNewLutEntry->CTAG_IF = (vid!=0) ? 1 : 0;
		pNewLutEntry->CVID = vid;

		if(isStatic)
		{
			pNewLutEntry->staticRefCount=1;
			pNewLutEntry->isSync2PsEntry = FALSE;
		}
		else
		{
			pNewLutEntry->isSync2PsEntry = flag_isSync2PsEntry;
		}

		if((ret=RTK_FC_LUT_ADD(pNewLutEntry, FALSE))==RTK_FC_RET_ERR_ENTRY_FULL)
		{
			/* because delete operation will be delayed triggered by CALL_RCU, lut learning should be done in next packet. */
			if(_rtk_fc_lut_LRU(lutHashIdx)==SIGNED_INVALID)
			{
				ret = RTK_FC_RET_ERR_ENTRY_FULL;
			}else {

				if(unlikely(fc_db.fwdStatistic))
				{
					atomic_inc(&fc_db.statistic.perPortCnt_L2LRU[ingressPort.macPortIdx]);
				}

				ret=RTK_FC_LUT_ADD(pNewLutEntry, FALSE);
			}
		}

		if(ret)
		{
			if(ret == RTK_FC_RET_ERR_ENTRY_FULL)
				TRACE("Lut table is full, lutHashIdx=%d MAC: %pM", lutHashIdx, srcMac);
			else if(ret == RTK_FC_RET_ERR_ENTRY_EXIST) {
				TRACE("Lut entry exist, lutHashIdx=%d MAC: %pM", lutHashIdx, srcMac);
			}else
				WARNING("Add LUT error!ret = 0x%x MAC: %pM", ret, srcMac);
			
			_rtk_fc_lutEntry_returnToPool(pNewLutEntry);
			return RTK_FC_RET_LRN_FAIL;
		}
	#if defined(CONFIG_RTK_SOC_RTL8198D)
		else {
			if (wlan_dev_idx != RTK_FC_WLANX_NOT_FOUND || wifi_lut_moving == TRUE) {
				EVENT("[%d] add %pM lut entry [%u] with [%u][%u][%u] static [%u]", wifi_lut_moving, pNewLutEntry->l2Addr, pNewLutEntry->lutIdx, pNewLutEntry->spa, pNewLutEntry->extspa, pNewLutEntry->wlan_dev_idx, pNewLutEntry->isStatic);
			}
		}
	#endif
	}


	*macL2Idx = pNewLutEntry->lutIdx;
	_rtk_fc_lutHostPolicingIdxUpdate(pNewLutEntry->l2Addr);
	RTK_FC_HELPER_MGR_SKIPHWLOOKUP_STAT_GET(&skipHwlookUp_stat);
	if(unlikely(skipHwlookUp_stat.status))
	{
		if((ingressPort.macPortIdx == skipHwlookUp_stat.portInfo.macPortIdx) && (ingressPort.macExtPortIdx == skipHwlookUp_stat.portInfo.macExtPortIdx))
		{
			RTK_FC_HELPER_MGR_SKIPHWLOOKUP_STAT_CLEAR();
			TRACE("New learned MAC at port %d(%d) Turn off skipHwlookUp status", skipHwlookUp_stat.portInfo.macPortIdx, skipHwlookUp_stat.portInfo.macExtPortIdx);
		}
	}

#if defined(CONFIG_FC_RTL9607C_SERIES)	
	// last step for duplicate entry control
	if((wlan_dev_idx < RTK_FC_WLANX_END_INTF) && fc_db.controlFuc.wifi_tx_gmac_trunking) {	
		uint8 duplicateEntryCnt = 0;
		rtk_fc_wlan_devmap_t *devmap = NULL;

		ret = RTK_FC_HELPER_WLAN_DEVMAP_GET(wlan_dev_idx, &devmap);
		
		if(ret==SUCCESS && devmap->gmac_tx_trunking)
		{
		
			pNewLutEntry->duplicateEntry_exist = TRUE;
					
			for(duplicateEntryCnt = RTK_FC_WIFI_FID_1; duplicateEntryCnt < fc_db.controlFuc.wifi_tx_gmac_trunking_num; duplicateEntryCnt++) {
				
				rtk_fc_lut_entry_t *pDuplicateLutEntry = _rtk_fc_lutEntry_getFromPool();
				if(pDuplicateLutEntry==NULL)
				{
					TRACE("[Fail to add lut] Lut table pool is full.");
					return RTK_FC_RET_ERR_ENTRY_FULL;
				}
				
				memcpy(pDuplicateLutEntry, pNewLutEntry, offsetof(rtk_fc_lut_entry_t, lutRcuHead));

				pDuplicateLutEntry->duplicateEntry_exist = FALSE;				
				pDuplicateLutEntry->svl_fid = duplicateEntryCnt;

				if(pDuplicateLutEntry->svl_fid==RTK_FC_WIFI_FID_1)
					pDuplicateLutEntry->spa = RTK_FC_MAC_PORT_MASTERCPU_CORE1;
				else if(pDuplicateLutEntry->svl_fid==RTK_FC_WIFI_FID_2)
					pDuplicateLutEntry->spa = RTK_FC_MAC_PORT_SLAVECPU;
				else
					WARNING("unexpect fid %d", pDuplicateLutEntry->svl_fid);
				
				// ADD
				if((ret=RTK_FC_LUT_ADD(pDuplicateLutEntry, FALSE))==RTK_FC_RET_ERR_ENTRY_FULL)
				{
					/* because delete operation will be delayed triggered by CALL_RCU, lut learning should be done in next packet. */
					if(_rtk_fc_lut_LRU(lutHashIdx)==SIGNED_INVALID)
					{
						ret = RTK_FC_RET_ERR_ENTRY_FULL;
					}else {
					
						if(unlikely(fc_db.fwdStatistic))
						{
							atomic_inc(&fc_db.statistic.perPortCnt_L2LRU[ingressPort.macPortIdx]);
						}

						ret=RTK_FC_LUT_ADD(pDuplicateLutEntry, FALSE);
					}
				}
				
				if(ret)
				{
					if(ret == RTK_FC_RET_ERR_ENTRY_FULL)
						TRACE("Lut table is full, lutHashIdx=%d MAC: %pM", lutHashIdx, srcMac);
					else if(ret == RTK_FC_RET_ERR_ENTRY_EXIST) {
						TRACE("Lut entry exist, lutHashIdx=%d MAC: %pM", lutHashIdx, srcMac);
					}else
						WARNING("Add LUT error!ret = 0x%x MAC: %pM", ret, srcMac);
					
					_rtk_fc_lutEntry_returnToPool(pDuplicateLutEntry);
					break;
				}
			}
		}
	}
#endif

	return RTK_FC_RET_OK;
}


void _rtk_fc_lut_timeoutCheck(void)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		_rtk_fc_lut_timeout_byCheckAging();
	}
	else
#endif
	{
		_rtk_fc_lut_timeout_byCheckTrfBits();
	}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	/*For G3, updating of LUT aging time is carried out while flow aging time updating and SA learing.*/
	/*LUT checking at house keeping only checks if the LUT entry exists in Linux kernel.*/
	_rtk_fc_lut_timeout_byCheckKernel();
#endif

	return;
}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

void _rtk_fc_lut_timeout_byCheckAging(void)
{
	int i, ret;
	rtk_fc_lut_entry_t *pLutEntry;
	rtk_l2_ucastAddr_t l2UcAddr;
	int checkIdx_end;
	bool fdb_exist = FALSE, v4neigh_exist = FALSE, v6neigh_exist = FALSE;
	rtk_fc_fdb_entry_t fc_fdb;

	memset(&l2UcAddr, 0, sizeof(l2UcAddr));

	checkIdx_end = ((fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM) > RTK_FC_TABLESIZE_LUT) ? RTK_FC_TABLESIZE_LUT: (fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM);

	TIMER("scan lut entries from %d to %d", fc_db.l2_hkCurIdx, checkIdx_end);

	for(i=fc_db.l2_hkCurIdx; i<checkIdx_end; i++)
	{
		if(fc_db.lutTbl[i]==NULL)
			continue;

		pLutEntry = fc_db.lutTbl[i];
		
		if(!pLutEntry->valid || pLutEntry->svl_fid)
			continue;

		if((pLutEntry->l2Addr[0]&0x1)==0x0)
		{
			//unicast entry aging

			// get lut status
			l2UcAddr.flags = 0x0;
			l2UcAddr.fid = DEFAULT_FID;
			memcpy(l2UcAddr.mac.octet, pLutEntry->l2Addr, ETH_ALEN);
			ret = rtk_l2_addr_get(&l2UcAddr);
			
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Hw/Sw lut is not synchronized] Index=%d MAC=%pM", pLutEntry->lutIdx, pLutEntry->l2Addr);
			}
			else
			{
				if(l2UcAddr.age != 1)
				{
					TIMER("refresh sw l2 idle time, Index=%d MAC=%pM", pLutEntry->lutIdx, pLutEntry->l2Addr);
					pLutEntry->last_jiffies = jiffies;

					if(!pLutEntry->isStatic && rtk_fc_notify_lut_refresh)
						rtk_fc_notify_lut_refresh(pLutEntry->l2Addr, pLutEntry->CVID, pLutEntry->anyFlowEstablish);
				}

				//reset age to 1 if this l2 entry is not timeout
				l2UcAddr.age = 1;
				assert_ok(rtk_l2_addr_add(&l2UcAddr));

				
				if(!pLutEntry->isStatic) {
					fdb_exist = FALSE;
					v4neigh_exist = FALSE;
					v6neigh_exist = FALSE;
					
					if(pLutEntry->isSync2PsEntry) {
						// delete lut if not found
						
						if(l2UcAddr.age != 1){
							fdb_exist = _rtk_fc_refresh_fdb(&pLutEntry->l2Addr[0], pLutEntry->CVID);
						}else{
							fdb_exist = _rtk_fc_lookup_fdb(&pLutEntry->l2Addr[0], pLutEntry->CVID, &fc_fdb);
						}

						v4neigh_exist = _rtk_fc_lookup_v4neighbor(&pLutEntry->l2Addr[0]);
						v6neigh_exist = _rtk_fc_lookup_v6neighbor(&pLutEntry->l2Addr[0]);
						
						if(!(fdb_exist || v4neigh_exist || v6neigh_exist))
						{
							TIMER("[Del lut] Lut[%d]'s fdb and neighbor(v4/v6) are all non-used", pLutEntry->lutIdx);
							assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
						}
							
					} else {
						// delete lut if timeout
						
						if(time_after(jiffies,pLutEntry->last_jiffies + fc_db.ucTimeout_unit1s*CONFIG_HZ)) {
							TIMER("[Del lut] Lut[%d] is not used", pLutEntry->lutIdx);
							assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
						}
					}
				}

			}

		}
		else
		{
			//multicast entry
			if(pLutEntry->isStatic)
				continue;

			if(time_after(jiffies,pLutEntry->last_jiffies + fc_db.mcTimeout_unit1s*CONFIG_HZ))
			{
				TIMER("[Del lut] Lut[%d] is not used(By MC)", pLutEntry->lutIdx);
				assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
			}
		}

	}

	fc_db.l2_hkCurIdx = ((fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM) > RTK_FC_TABLESIZE_LUT) ? 0: (fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM);

	return;
}


void _rtk_fc_lut_timeout_byCheckTrfBits(void)
{
	int i;
	rtk_fc_lut_entry_t *pLutEntry;
	rtk_l2_ucastAddr_t l2UcAddr;
	int checkIdx_start, checkIdx_end;
	uint32 saTrfbitMask = 0;
	bool fdb_exist = FALSE, v4neigh_exist = FALSE, v6neigh_exist = FALSE;
	rtk_fc_fdb_entry_t fc_fdb;


	memset(&l2UcAddr, 0, sizeof(l2UcAddr));

	checkIdx_end = ((fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM) > RTK_FC_TABLESIZE_LUT) ? RTK_FC_TABLESIZE_LUT: (fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM);
	//since there is bCAM enabled and trafficbit mechanism, we must take 32 entries as one basic unit.
	for(checkIdx_start = fc_db.l2_hkCurIdx; checkIdx_start < checkIdx_end; checkIdx_start += 32)
	{
		assert_ok(rtk_rg_asic_lutSATraffic_get(checkIdx_start , &saTrfbitMask));
		for(i = checkIdx_start ; (i < (checkIdx_start+32)) && (i < RTK_FC_TABLESIZE_LUT) ; i++)
		{

			if(fc_db.lutTbl[i]==NULL)
				continue;

			pLutEntry = fc_db.lutTbl[i];
			
			if(!pLutEntry->valid || pLutEntry->svl_fid)
				continue;

			if((pLutEntry->l2Addr[0]&0x1)==0x0)
			{
				//unicast entry

				if(saTrfbitMask & (1<<(i-checkIdx_start))){
					TIMER("refresh sw l2 idle time, Index=%d MAC=%pM", pLutEntry->lutIdx, pLutEntry->l2Addr);
					pLutEntry->last_jiffies = jiffies; 

					if(!pLutEntry->isStatic && rtk_fc_notify_lut_refresh)
						rtk_fc_notify_lut_refresh(pLutEntry->l2Addr, pLutEntry->CVID, pLutEntry->anyFlowEstablish);
				}
			

				if(!pLutEntry->isStatic) {
					fdb_exist = FALSE;
					v4neigh_exist = FALSE;
					v6neigh_exist = FALSE;
					
					if(pLutEntry->isSync2PsEntry) {
						// delete lut if not found
						
						if(saTrfbitMask & (1<<(i-checkIdx_start))){
							fdb_exist = _rtk_fc_refresh_fdb(&pLutEntry->l2Addr[0], pLutEntry->CVID);
						}else{
							fdb_exist = _rtk_fc_lookup_fdb(&pLutEntry->l2Addr[0], pLutEntry->CVID, &fc_fdb);
						}

						v4neigh_exist = _rtk_fc_lookup_v4neighbor(&pLutEntry->l2Addr[0]);
						v6neigh_exist = _rtk_fc_lookup_v6neighbor(&pLutEntry->l2Addr[0]);
						
						if(!(fdb_exist || v4neigh_exist || v6neigh_exist))
						{
							TIMER("[Del lut] Lut[%d]'s fdb and neighbor(v4/v6) are all non-used", pLutEntry->lutIdx);
							assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
						}
							
					} else {
						// delete lut if timeout
						
						if(time_after(jiffies,pLutEntry->last_jiffies + fc_db.ucTimeout_unit1s*CONFIG_HZ)) {
							TIMER("[Del lut] Lut[%d] is not used", pLutEntry->lutIdx);
							assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
						}
					}
				}

			}
			else
			{
				//multicast entry
				
				if(pLutEntry->isStatic)
					continue;

				if(time_after(jiffies,pLutEntry->last_jiffies + fc_db.mcTimeout_unit1s*CONFIG_HZ))
				{
					TIMER("[Del lut] Lut[%d] is not used(By MC)", pLutEntry->lutIdx);
					assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
				}
			}
		}
	}
	fc_db.l2_hkCurIdx = ((fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM) > RTK_FC_TABLESIZE_LUT) ? 0: (fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM);

	return;
}

#endif
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
void _rtk_fc_lut_timeout_byCheckKernel(void)
{
	int i;
	rtk_fc_lut_entry_t *pLutEntry;
	int checkIdx_end;
	bool fdb_exist = FALSE, v4neigh_exist = FALSE, v6neigh_exist = FALSE;
	rtk_fc_fdb_entry_t fc_fdb;

	checkIdx_end = ((fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM) > RTK_FC_TABLESIZE_LUT) ? RTK_FC_TABLESIZE_LUT: (fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM);

	//TIMER("scan l2 index from %d to %d", fc_db.l2_hkCurIdx, checkIdx_end);

	for(i = fc_db.l2_hkCurIdx; i < checkIdx_end; i++)
	{
		if(fc_db.lutTbl[i]==NULL)
			continue;

		pLutEntry = fc_db.lutTbl[i];

		if(!pLutEntry->valid || pLutEntry->svl_fid)
			continue;

		if(pLutEntry->isStatic)
			continue;

		if((pLutEntry->l2Addr[0]&0x1)==0x0)
		{
			//unicast entry
			if(pLutEntry->isSync2PsEntry) {
				// sync linux
				fdb_exist = _rtk_fc_lookup_fdb(&pLutEntry->l2Addr[0], pLutEntry->CVID, &fc_fdb);
				v4neigh_exist = _rtk_fc_lookup_v4neighbor(&pLutEntry->l2Addr[0]);
				v6neigh_exist = _rtk_fc_lookup_v6neighbor(&pLutEntry->l2Addr[0]);

				if(!(fdb_exist || v4neigh_exist || v6neigh_exist)) {
					TIMER("[Del lut] Lut[%d] - fdb and neighbor(v4/v6) are all non-used", pLutEntry->lutIdx);
					assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
				}
				
			} else {
				// sync idle timeout
				if(time_after(jiffies, pLutEntry->last_jiffies + fc_db.ucTimeout_unit1s*CONFIG_HZ)) {		
					TIMER("[Del lut] Lut[%d] - idle time over %d (cur %lu last %lu)", pLutEntry->lutIdx, fc_db.ucTimeout_unit1s*CONFIG_HZ, jiffies, pLutEntry->last_jiffies);
					assert_ok(RTK_FC_LUT_DEL(pLutEntry, FALSE));
				}
			}

		} else {
			//multicast entry
			
			// N/A
		}
	}
	fc_db.l2_hkCurIdx = ((fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM) > RTK_FC_TABLESIZE_LUT) ? 0: (fc_db.l2_hkCurIdx + L2HOUSE_KEEP_NUM);

	return;
}

int _rtk_fc_lut_updateTimer(int l2Idx)
{
	rtk_fc_lut_entry_t *pLutEntry;

	TIMER("[update LUT] Update the aging time of LUT[%d]\n", l2Idx);

	if((l2Idx == SIGNED_INVALID) || (fc_db.lutTbl[l2Idx]==NULL))
	{
		TIMER("[update LUT] L2[%d] is invalid. Not update LUT aging time\n", l2Idx);
		return (RTK_FC_RET_ERR_INVALID_PARAM);
	}

	pLutEntry = fc_db.lutTbl[l2Idx];

	if((pLutEntry->l2Addr[0]&0x1)==0x0)
	{
		/***Unicast entry***/

		//update SA idle time
		pLutEntry->last_jiffies = jiffies;

		if(!pLutEntry->isStatic && rtk_fc_notify_lut_refresh)
			rtk_fc_notify_lut_refresh(pLutEntry->l2Addr, pLutEntry->CVID, pLutEntry->anyFlowEstablish);

		if(pLutEntry->isSync2PsEntry)
		{
			_rtk_fc_refresh_fdb(&pLutEntry->l2Addr[0], pLutEntry->CVID);
		}
	}
	return SUCCESS;
}
int _rtk_fc_netif_updateSwTrafficBit(rtk_fc_tableFlowEntry_t flowTblEntry)
{
	//There is no traffic bits in G3 HW for netif, use SW to record netif traffic bit.
	int inIntfIdx = FAIL, outInufIdx = FAIL;
	rtk_rg_asic_path3_entry_t * pP3FlowEntry = &flowTblEntry.path3;

	if((pP3FlowEntry->in_path == FB_PATH_12) || (pP3FlowEntry->in_path == FB_PATH_34) || (pP3FlowEntry->in_path == FB_PATH_5))
	{
		if((pP3FlowEntry->in_path == FB_PATH_12) && (pP3FlowEntry->in_multiple_act == 1))
		{//Path2 has no in_intf_idx field
		}
		else
			inIntfIdx = pP3FlowEntry->in_intf_idx;
		outInufIdx = pP3FlowEntry->out_intf_idx;
	}
	if(inIntfIdx != FAIL)
		fc_db.netifTrfBit[inIntfIdx/32] |= (1 << (inIntfIdx%32));
	if(outInufIdx != FAIL)
		fc_db.netifTrfBit[outInufIdx/32] |= (1 << (outInufIdx%32));
	return RTK_FC_RET_OK;
}
#endif


rtk_fc_ret_t _rtk_fc_lutCamListAdd(uint32 lutHashIdx, uint32 addLutCamIdx)
{
	rtk_fc_lutCam_linkList_t *pLutCamEntry;

	if(lutHashIdx>=RTK_FC_LUT_BUCKET_SIZE)
	{
		WARNING("lutHashIdx(%d) is out of range 0~%d", lutHashIdx, RTK_FC_LUT_BUCKET_SIZE-1);
		return (RTK_FC_RET_ERR);
	}
	if(!((RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE)<=addLutCamIdx && addLutCamIdx<RTK_FC_TABLESIZE_LUT))
	{
		WARNING("addLutCamIdx(%d) is out of range %d~%d", addLutCamIdx, (RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE), RTK_FC_TABLESIZE_LUT-1);
		return (RTK_FC_RET_ERR);
	}

	pLutCamEntry = &fc_db.lutCamList[addLutCamIdx-(RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE)];

	//Delete from head list
	list_del_init(&pLutCamEntry->lut_list);

	//Add to hash head list
	list_add_tail(&pLutCamEntry->lut_list, &fc_db.lutCam_hashListHead[lutHashIdx]);

	DEBUG("add lut[%d] to lutCamHead[%d]\n", addLutCamIdx, lutHashIdx);

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t _rtk_fc_lutCamListDel(uint32 delLutCamIdx)
{
	rtk_fc_lutCam_linkList_t *pDelLutCamEntry;
	rtk_fc_lutCam_linkList_t *pLutCamEntry,*pNextLutCamEntry;

	if(!((RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE)<=delLutCamIdx && delLutCamIdx<RTK_FC_TABLESIZE_LUT))
	{
		WARNING("delLutCamIdx(%d) is out of range %d~%d", delLutCamIdx, (RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE), RTK_FC_TABLESIZE_LUT-1);
		return (RTK_FC_RET_ERR);
	}

	pDelLutCamEntry = &fc_db.lutCamList[delLutCamIdx-(RTK_FC_TABLESIZE_LUT-LUTTABLE_BCAM_SIZE)];

	//Delete from head list
	list_del_init(&pDelLutCamEntry->lut_list);

	if(list_empty(&fc_db.lutCam_freeListHead))
	{
		list_add(&pDelLutCamEntry->lut_list, &fc_db.lutCam_freeListHead);
	}
	else
	{
		list_for_each_entry_safe(pLutCamEntry,pNextLutCamEntry,&fc_db.lutCam_freeListHead,lut_list)
		{
			if(pDelLutCamEntry->idx < pLutCamEntry->idx)
			{
				list_add_tail(&pDelLutCamEntry->lut_list, &pLutCamEntry->lut_list);
				break;
			}

			if(&pNextLutCamEntry->lut_list == &fc_db.lutCam_freeListHead)
			{
				list_add(&pDelLutCamEntry->lut_list, &pLutCamEntry->lut_list);
				break;
			}
		}
	}

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t _rtk_fc_lutHostPolicingIdxUpdate(uint8 *mac)
{
	int16 lutIdx, i;

	if(_rtk_fc_lut_find(mac, &lutIdx) == RTK_FC_RET_OK)
	{
		//the mac address exists in LUT, check if it needs to do host policing
		assert(0 <= lutIdx && lutIdx < RTK_FC_TABLESIZE_LUT);

		for(i = 0 ; i < RT_RATE_HOSTPOLICING_TABLE_SIZE ; i++)
		{
			if(!memcmp(mac, fc_db.hostPoliceTable[i].hostPoliceControl.mac_addr, sizeof(fc_db.hostPoliceTable[i].hostPoliceControl.mac_addr)))
				break;
		}
		if(i < RT_RATE_HOSTPOLICING_TABLE_SIZE)
			fc_db.lutTbl[lutIdx]->hostPolIdx = i;

		else
			fc_db.lutTbl[lutIdx]->hostPolIdx = FAIL;
	}

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_macAddr_portGroup_lrnCnt_inc(rtk_fc_lut_entry_t *pLutEntry)
{
	if(pLutEntry && fc_db.macAddr_portGroup.group.portmask & (1<<pLutEntry->spa)) {
		atomic_inc(&fc_db.macAddr_portGroup.limitCfg.learningCount);
	}

	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_macAddr_portGroup_lrnCnt_dec(rtk_fc_lut_entry_t *pLutEntry)
{
	if(pLutEntry && fc_db.macAddr_portGroup.group.portmask & (1<<pLutEntry->spa)) {
		atomic_dec(&fc_db.macAddr_portGroup.limitCfg.learningCount);
	}

	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_macAddr_portGroup_lrnCnt_check(int spa)
{	
	if(fc_db.macAddr_portGroup.group.portmask & (1<<spa)) {
		if(atomic_read(&fc_db.macAddr_portGroup.limitCfg.learningCount) >= fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber) {
			TRACE("[DROP]  Port %d group learning count %d exeed group limitation %d", spa, atomic_read(&fc_db.macAddr_portGroup.limitCfg.learningCount), fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber);
			return RTK_FC_RET_DROP_GROUPLEARNING_LIMIT;
		}
	}else {
		if(fc_db.macAddrLearningLimit[spa].learningLimit_conf.learningLimitNumber>=0
			&& fc_db.macAddrLearningLimit[spa].learningLimit_conf.learningLimitNumber<=atomic_read(&fc_db.macAddrLearningLimit[spa].learningCount))
		{
			TRACE("[DROP] Port %d SA learning limit is reached(%d)", spa, fc_db.macAddrLearningLimit[spa].learningLimit_conf.learningLimitNumber);
			return RTK_FC_RET_DROP_PORTLEARNING_LIMIT;
		}
	}

	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_macAddr_portGroup_lrnCnt_config(rtk_fc_port_mask_t portmask)
{
	int i = 0, limitedCnt = 0;

	for(i = 0; i <RTK_FC_MAC_PORT_MAX; i++) {
		// clear related l2 entries
		if((1<<i) & (portmask | fc_db.macAddr_portGroup.group.portmask)) {
			_rtk_fc_lut_linkdown_del(i);
		}
	}
	
	for(i = 0; i <RTK_FC_MAC_PORT_MAX; i++) {
		if((1<<i) & portmask) {
			
			if(fc_db.macAddrLearningLimit[i].learningLimit_conf.learningLimitNumber == SIGNED_INVALID)
				fc_db.macAddrLearningLimit[i].learningLimit_conf.learningLimitNumber = 0;

			if(fc_db.macAddrLearningLimit[i].learningLimit_conf.learningLimitNumber > 0)
				limitedCnt += fc_db.macAddrLearningLimit[i].learningLimit_conf.learningLimitNumber;
		}	
	}

	if(portmask == 0)
		fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber = SIGNED_INVALID;
	else
		fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber = limitedCnt;
	
	fc_db.macAddr_portGroup.group.portmask = portmask;
	

	return RTK_FC_RET_OK;
}

void rtk_fc_update_pppoeHwNetif_info(int swNetifIdx, int sid)
{
	if(fc_db.pppoe_sync_num!=0 )
	{
    	fc_db.pppoe_sync_num --;
    }
	fc_db.netifTbl[swNetifIdx].intf.out_pppoe_sid = sid&0xffff;
	fc_db.netifTbl[swNetifIdx].intf.out_pppoe_act = FB_NETIFPPPOE_ACT_ADD;
	fc_db.netifTbl[swNetifIdx].pppoe_synced = 1;
	
}

int rtk_fc_update_pppNetif_macInfo(int swNetifIdx, uint8 *pNetifMac, uint8 *mac)
{
	int16 macL2Idx = 0;
	if(fc_db.netifTbl[swNetifIdx].lutIdx != SIGNED_INVALID)
	{
		_rtk_fc_lut_staticEntry_del(fc_db.netifTbl[swNetifIdx].lutIdx);
	}

	memcpy(pNetifMac, mac, ETH_ALEN);

	if((mac[0]|mac[1]|mac[2]|mac[3]|mac[4]|mac[5]) != 0x0)
	{
		rtk_fc_pmap_t portmap;

		portmap.macPortIdx = fc_db.netifTbl[swNetifIdx].macportidx;
		portmap.macExtPortIdx = fc_db.netifTbl[swNetifIdx].macextportidx;
		ASSERT_EQ(_rtk_fc_lut_learning(mac, portmap, fc_db.netifTbl[swNetifIdx].vlanId, fc_db.netifTbl[swNetifIdx].wlanidx,
											FALSE, TRUE,&macL2Idx),RTK_FC_RET_OK);
		fc_db.netifTbl[swNetifIdx].lutIdx = macL2Idx;
		if(fc_db.lutTbl[macL2Idx]) fc_db.lutTbl[macL2Idx]->isGMAC = TRUE;
	}
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t _rtk_fc_setPPPoeNetifInfoByIgmp(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	uint32 i =0;
	struct net_device *netif_dev=NULL;
	bool find = FALSE;
	uint32  find_idx = 0;

	//for igmp/mld packet
	if(pPktHdr->igmph==NULL && pPktHdr->icmp6h==NULL)
		return RTK_FC_RET_OK;

	//for pppoe case
	if(pPktHdr->ppph)
	{
		DEBUG("IGMP control packet try to update PPPoE interface!");
		//IP based 
		if(pPktHdr->iph || pPktHdr->ip6h)	//ipv4 or ipv6
		{
			find = FALSE;
			if(pPktHdr->fwdType == RTK_FC_FWDTYPE_NAPT)
			{
				// IPv4 NAPT: search PPP interface by gateway IP
				for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					unsigned int type=0;

					//DEBUG("i = %d, gateway ip = 0x%x, packet sip = 0x%x", i, fc_db.netifTbl[i].intf.gateway_ipv4_addr, pPktHdr->iph->saddr);
					if(fc_db.netifTbl[i].intf.valid==0)
						continue;

					RTK_FC_HELPER_NETDEV_GET_DEV_DATA(fc_db.netifTbl[i].dev, &type, RTK_FC_NETDEV_GET_TYPE);
					if(pPktHdr->iph &&
						(fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0) && (fc_db.netifTbl[i].intf.gateway_ipv4_addr==ntohl(pPktHdr->iph->saddr)) && (type == ARPHRD_PPP)) {
						find = TRUE;
						find_idx = i;
						TRACE("DstDev %s is decided by using srcIp %pI4", fc_db.netifTbl[i].dev->name, &pPktHdr->iph->saddr);
						break;
					}
				}
			}
			else if(pPktHdr->fwdType == RTK_FC_FWDTYPE_ROUTING)
			{
				// IPv4/IPv6 routing: If pppoe, search PPP interface SID and MAC first
				for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					int32 sid = ntohs(pPktHdr->ppph->sid);
					uint8 *pMac = &fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0];
					if(fc_db.netifTbl[i].intf.valid && (fc_db.netifTbl[i].intf.out_pppoe_sid == (sid&0xffff)) && (fc_db.netifTbl[i].intf.out_pppoe_act == FB_NETIFPPPOE_ACT_ADD) && (!memcmp(pMac, &pPktHdr->eth->h_source[0], ETH_ALEN)))
					{
						find = TRUE;
						find_idx = i;
						break;
					}
				}

				// IPv4/IPv6 routing: search empty PPP interface
				if(find == FALSE)
				{
					for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
					{
						unsigned int type=0;
						uint8 *pMac = &fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0];

						if(fc_db.netifTbl[i].intf.valid==0)
							continue;

						RTK_FC_HELPER_NETDEV_GET_DEV_DATA(fc_db.netifTbl[i].dev, &type, RTK_FC_NETDEV_GET_TYPE);
						//routing: check interface type, zero MAC
						if((type == ARPHRD_PPP) && ((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0))
						{
							find = TRUE;
							find_idx = i;
							TRACE("DstDev %s is decided by ARPHRD_PPP type with zero MAC intf", fc_db.netifTbl[i].dev->name);
							break;
						}
					}
				}
			}
			if(find && (find_idx<RTK_FC_TABLESIZE_INTF_SW))
			{
				uint8 *pMac = &fc_db.netifTbl[find_idx].intf.gateway_mac_addr.octet[0];
				int32 sid = ntohs(pPktHdr->ppph->sid);
				bool update = FALSE;

				if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0)	// sync ethnet device mac to ppp interface
				{
					int ret;
					TRACE("Try to update pppoe hw netif because mac is not set.");
					ret = rtk_fc_update_pppNetif_macInfo(find_idx, pMac, &pPktHdr->eth->h_source[0]);
					if(ret)
					{
						WARNING("update ppp interface gateway MAC failed, ret = %d", ret);
						return RTK_FC_RET_ERR;
					}
					update = TRUE;
					if(((fc_db.netifTbl[find_idx].intf.out_pppoe_sid != (sid&0xffff)) || fc_db.netifTbl[find_idx].intf.out_pppoe_act != FB_NETIFPPPOE_ACT_ADD) )// sid change or pppoe_act change
						rtk_fc_update_pppoeHwNetif_info(find_idx,sid);
				}

				if((fc_db.netifTbl[find_idx].hwIdx!=SIGNED_INVALID) && (fc_db.netifHwTbl[fc_db.netifTbl[find_idx].hwIdx].ifTempEntry) && update) {
					TRACE("try to update sw_netif[%d] hw_netif[%d] sid: %d", find_idx, fc_db.netifTbl[find_idx].hwIdx, sid);
					//rtk_fc_netif_add_by_flow(i);
					if(rtk_fc_netif_update_by_flow(find_idx) != RTK_FC_RET_OK)
						DEBUG("update netif by flow failed!");
					else
						_rtk_fc_netif_dummy_packet_set(fc_db.netifTbl[find_idx].hwIdx); //initial for PPPoE dummy packet
				}
				netif_dev = fc_db.netifTbl[i].dev;
			}
		}
	}
	
	return RTK_FC_RET_OK;
}

static struct net_device* rtk_fc_getIngressDev_by_cachedData(rtk_fc_pktHdr_t *pPktHdr, struct rt_skbuff *rtskb, rtk_fc_forwardingType_t fwdType, rtk_fc_flow_direction_t dir)
{
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);
	struct net_device *netif_dev=NULL;
	unsigned int type=0;
	int i = 0, sw_netif_idx = SIGNED_INVALID;
	uint8 mismatch = FALSE;

	if(pFcIngressData->logicalInDev) {

		// wan interface, e.g. nas0_x
		if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(pFcIngressData->logicalInDev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_DOMAIN_WAN))
		{
			DEBUG("find ingress WAN intf %s by netfilter hook", pFcIngressData->logicalInDev->name);
			netif_dev =  pFcIngressData->logicalInDev;
			goto DOUBLE_CHECK;
		}
#if defined(CONFIG_FC_RTL8277C_SERIES)//And 9607F should be using the same if condition.
		if( (pFcIngressData->ingressTagif & VXLAN_TAGIF)  || (pFcIngressData->ingressTagif & GRE_ETH_BR_TAGIF) )
		{
			netif_dev = pFcIngressData->logicalInDev;
			goto DOUBLE_CHECK;
		}
#endif

		// lan bridged interce, e.g. eth0.x.0
		netif_dev = rtk_fc_getBridgedDevbyNetDev(pFcIngressData->logicalInDev);
		if(netif_dev){
			DEBUG("find ingress virtual intf %s but real bridge dev is %s", pFcIngressData->logicalInDev->name, netif_dev->name);
			goto DOUBLE_CHECK;
		}

		// lan interface, e.g. brx
		if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(pFcIngressData->logicalInDev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE))
		{
			DEBUG("find ingress Bridge intf %s by netfilter hook", pFcIngressData->logicalInDev->name);
			netif_dev = pFcIngressData->logicalInDev;
			goto DOUBLE_CHECK;
		}

		// wan interface, e.g. pppx
		RTK_FC_HELPER_NETDEV_GET_DEV_DATA(pFcIngressData->logicalInDev, &type, RTK_FC_NETDEV_GET_TYPE);
		if(type == ARPHRD_PPP)
		{
			DEBUG("find ingress PPP intf %s by netfilter hook", pFcIngressData->logicalInDev->name);
			netif_dev =  pFcIngressData->logicalInDev;
			goto DOUBLE_CHECK;
		}
		
		DEBUG("Use default intf %s by netfilter hook", pFcIngressData->logicalInDev->name);
			
		netif_dev = pFcIngressData->logicalInDev;
		goto DOUBLE_CHECK;
	}

DOUBLE_CHECK:
	// valid check
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if((fc_db.netifTbl[i].intf.valid == 1) && (fc_db.netifTbl[i].dev == netif_dev))
		{
			sw_netif_idx = i;
			break;
		}
	}

	if(sw_netif_idx == SIGNED_INVALID) {
		netif_dev = NULL;
		return netif_dev;
	}
	if(fwdType == RTK_FC_FWDTYPE_BRIDGE) {
		return netif_dev;
	}
	if(pPktHdr->isMAPT) {
		//always trust logical_in_dev from skb cached data
		//update logical netif's mac
		uint8 *pMac = &fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet[0];
		if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0){	// sync ethnet device mac to ppp interface
			int ret=rtk_fc_update_pppNetif_macInfo(sw_netif_idx, pMac, &pFcIngressData->da[0]);
			if(ret)
				WARNING("update mapt interface gateway MAC failed, ret = %d", ret);
		}
		return netif_dev;
	}

	// info check if !bridge
	if((pFcIngressData->ingressTagif & PPPOE_TAGIF)) {
		uint16 sid = pFcIngressData->sessionId;

		// check netdev configuration
		if(fc_db.netifTbl[sw_netif_idx].intf.out_pppoe_act != FB_NETIFPPPOE_ACT_ADD ||
			fc_db.netifTbl[sw_netif_idx].intf.out_pppoe_sid != sid)
		{
			rtk_fc_update_pppoeHwNetif_info(sw_netif_idx, sid);
			TRACE("double check: sw_netif[%d] %s ppp session id mismatch", sw_netif_idx, netif_dev->name);
		}

		//if((pFcIngressData->ingressTagif & IPV4_TAGIF) || (pFcIngressData->ingressTagif & IPV6_TAGIF))
		{
			if(!pPktHdr->isMulticast) {

				// L3 ip
				if(fwdType == RTK_FC_FWDTYPE_NAPT)
				{
					if(pPktHdr->iph) {

						if((fc_db.netifTbl[sw_netif_idx].intf.gateway_ipv4_addr!=0) && 
							(fc_db.netifTbl[sw_netif_idx].intf.gateway_ipv4_addr==pFcIngressData->dstIp)) {
							// find
						} else {
							mismatch = TRUE;
							TRACE("double check fail: sw_netif[%d] %s ipv4 nat mismatch", sw_netif_idx, netif_dev->name);
						}
						
					}else if (pPktHdr->ip6h) {
						// find, may be NPTv6 or NAT66
						
					}							
				}

				// L2 mac
				if(fwdType == RTK_FC_FWDTYPE_NAPT || fwdType == RTK_FC_FWDTYPE_ROUTING)
				{
					uint8 *pMac = &fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet[0];
					if((!memcmp(pMac, &pFcIngressData->da[0], ETH_ALEN)))
					{
						// find
					}else {
						rtk_fc_update_pppNetif_macInfo(sw_netif_idx, &fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet[0], &pFcIngressData->da[0]);
						TRACE("double check: sw_netif[%d] %s mac mismatch", sw_netif_idx, netif_dev->name);
					}
				}
			
			}
		}

	}else {
	
		if(!memcmp(fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet, pFcIngressData->da, ETH_ALEN))
		{
			if( dir == RTK_FC_FLOW_DIRECTION_DOWNSTREAM && fwdType==RTK_FC_FWDTYPE_NAPT)
			{
				if(pPktHdr->iph!=NULL && fc_db.netifTbl[sw_netif_idx].intf.gateway_ipv4_addr != pFcIngressData->dstIp) // For v4 nat device getting
				{
					{//if ((pFcIngressData->ingressTagif&DSLITE_TAGIF)!=0) { //Exclude MAP-E
						mismatch = TRUE;
						TRACE("double check fail: sw_netif[%d] %s ip mismatch", sw_netif_idx, netif_dev->name);
					}
				}
				else if ( pPktHdr->ip6h!=NULL && pPktHdr->iph==NULL ) // For v6 nat device getting
				{
					// TODO : For supporting v6 NAT/NPT
				}
			}
			else if(dir == RTK_FC_FLOW_DIRECTION_DOWNSTREAM && pFcIngressData->ingressTagif == DSLITE_TAGIF ) // For ipv6
			{
				int ret = 0;

				ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[sw_netif_idx].dev, pFcIngressData->dstIp, dir);

				if( ret!=SUCCESS) {
				        mismatch = TRUE;
					TRACE("double check fail: sw_netif[%d] %s dslite v6ip mismatch", sw_netif_idx, netif_dev->name);
				}
			}
		}else {
			mismatch = TRUE;
			TRACE("double check fail: sw_netif[%d] %s mac mismatch", sw_netif_idx, netif_dev->name);
		}
	}

	if(mismatch)
		return NULL;
	else
		return netif_dev;
}

static struct net_device* rtk_fc_getEgressDev_by_cachedData(rtk_fc_pktHdr_t *pPktHdr, struct rt_skbuff *rtskb, rtk_fc_forwardingType_t fwdType, rtk_fc_flow_direction_t dir)
{
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);
	struct net_device *netif_dev=NULL;
	unsigned int type=0;
	int i = 0, sw_netif_idx = SIGNED_INVALID;
	uint8 mismatch = FALSE;
	uint8 isEndPointTunnel = FALSE;

	if(pFcIngressData->logicalOutDev) {

		// wan interface, e.g. nas0_x
		if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(pFcIngressData->logicalOutDev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_DOMAIN_WAN))
		{
			DEBUG("find egress WAN intf %s by netfilter hook", pFcIngressData->logicalOutDev->name);
			netif_dev = pFcIngressData->logicalOutDev;
			goto DOUBLE_CHECK;
		}
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN || pPktHdr->dualHdrType == RTK_FC_DUALTYPE_GRE_ETH_BR )
		{
			netif_dev = pFcIngressData->logicalOutDev;
			goto DOUBLE_CHECK;
		}
#endif
		// lan bridged interce, e.g. eth0.x.0
		netif_dev = rtk_fc_getBridgedDevbyNetDev(pFcIngressData->logicalOutDev);
		if(netif_dev){
			DEBUG("find egress virtual intf %s but real bridge dev is %s", pFcIngressData->logicalOutDev->name, netif_dev->name);
			goto DOUBLE_CHECK;
		}
			
		// lan interface, e.g. brx (note: should not find brx in bridge netfilter postrouting chain)
		if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(pFcIngressData->logicalOutDev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE))
		{
			DEBUG("find egress Bridge intf %s by netfilter hook", pFcIngressData->logicalOutDev->name);
			
			netif_dev = pFcIngressData->logicalOutDev;
			goto DOUBLE_CHECK;
		}
		
		// wan interface, e.g. pppx
		RTK_FC_HELPER_NETDEV_GET_DEV_DATA(pFcIngressData->logicalOutDev, &type, RTK_FC_NETDEV_GET_TYPE);
		if(type == ARPHRD_PPP)
		{
			DEBUG("find egress PPP intf %s by netfilter hook", pFcIngressData->logicalOutDev->name);
			
			netif_dev = pFcIngressData->logicalOutDev;
			goto DOUBLE_CHECK;
		}
		DEBUG("Use default intf %s by netfilter hook", pFcIngressData->logicalOutDev->name);
			
		netif_dev = pFcIngressData->logicalOutDev;
		goto DOUBLE_CHECK;
		
	}

DOUBLE_CHECK:
	// valid check
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if((fc_db.netifTbl[i].intf.valid == 1) && (fc_db.netifTbl[i].dev == netif_dev))
		{
			sw_netif_idx = i;
			break;
		}
	}

	if(sw_netif_idx == SIGNED_INVALID) {
		netif_dev = NULL;
		return netif_dev;
	}
	if(fwdType == RTK_FC_FWDTYPE_BRIDGE) {
		return netif_dev;
	}
	if(pPktHdr->isMAPT) {
		//always trust logical_out_dev from skb cached data
		//update logical netif's mac
		uint8 *pMac = &fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet[0];
		if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0){	// sync ethnet device mac to ppp interface
			int ret=rtk_fc_update_pppNetif_macInfo(sw_netif_idx, pMac, &pPktHdr->eth->h_source[0]);
			if(ret)
				WARNING("update mapt interface gateway MAC failed, ret = %d", ret);
		}
		return netif_dev;
	}
	
	if(((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP) || (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP)) && pPktHdr->dual_passthrough_type==RTK_FC_DUALTYPE_NONE )
		isEndPointTunnel = TRUE;


	// info check if !bridge
	if((pPktHdr->ppph || isEndPointTunnel==TRUE)) {

		if(pPktHdr->ppph) {
			uint16 sid = ntohs(pPktHdr->ppph->sid);

			// check netdev configuration
			if(fc_db.netifTbl[sw_netif_idx].intf.out_pppoe_act != FB_NETIFPPPOE_ACT_ADD ||
				fc_db.netifTbl[sw_netif_idx].intf.out_pppoe_sid != sid)
			{
				rtk_fc_update_pppoeHwNetif_info(sw_netif_idx, sid);
				TRACE("double check: sw_netif[%d] %s ppp session id mismatch", sw_netif_idx, netif_dev->name);
			}
		}

		//if((pFcIngressData->ingressTagif & IPV4_TAGIF) || (pFcIngressData->ingressTagif & IPV6_TAGIF))
		{
			if(!pPktHdr->isMulticast) {

				// L3 ip
				if(fwdType == RTK_FC_FWDTYPE_NAPT)
				{
					if(pPktHdr->iph) {

						if((fc_db.netifTbl[sw_netif_idx].intf.gateway_ipv4_addr!=0) && 
							(fc_db.netifTbl[sw_netif_idx].intf.gateway_ipv4_addr==ntohl(pPktHdr->iph->saddr))) {
							// find
						} else {
							mismatch = TRUE;
							TRACE("double check fail: sw_netif[%d] %s ipv4 nat mismatch", sw_netif_idx, netif_dev->name);
						}
						
					}else if (pPktHdr->ip6h) {
						// find, may be NPTv6 or NAT66
						
					}							
				}

				// L2 mac
				if(fwdType == RTK_FC_FWDTYPE_NAPT || fwdType == RTK_FC_FWDTYPE_ROUTING)
				{
					uint8 *pMac = &fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet[0];
					if((!memcmp(pMac, &pFcIngressData->da[0], ETH_ALEN)))
					{
						// find
					}else {
						rtk_fc_update_pppNetif_macInfo(sw_netif_idx, &fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet[0], &pPktHdr->eth->h_source[0]);
						TRACE("double check: sw_netif[%d] %s mac mismatch", sw_netif_idx, netif_dev->name);
					}
				}
			
			}
		}

	}else {
	
		if(!memcmp(fc_db.netifTbl[sw_netif_idx].intf.gateway_mac_addr.octet, &pPktHdr->eth->h_source[0], ETH_ALEN))
		{
			if(dir == RTK_FC_FLOW_DIRECTION_UPSTREAM && fwdType==RTK_FC_FWDTYPE_NAPT)
			{
				if(pPktHdr->iph!=NULL && fc_db.netifTbl[sw_netif_idx].intf.gateway_ipv4_addr !=  ntohl(pPktHdr->iph->saddr)) // For v4 nat device getting
				{
					if (pPktHdr->dualHdrType != RTK_FC_DUALTYPE_DSLITE) { //Exclude MAP-E
						mismatch = TRUE;
						TRACE("double check fail: sw_netif[%d] %s ip mismatch", sw_netif_idx, netif_dev->name);
					}
				}
				else if ( pPktHdr->ip6h!=NULL && pPktHdr->iph==NULL ) // For v6 nat device getting
				{
					// TODO : For supporting v6 NAT/NPT
				}
			}
			else if(dir == RTK_FC_FLOW_DIRECTION_UPSTREAM && pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE && pPktHdr->ip6h != NULL && pPktHdr->iph!=NULL) // For ipv6
			{
				int ret = 0;

				ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[sw_netif_idx].dev, pFcIngressData->dstIp, dir);

				if( ret!=SUCCESS) {
				        mismatch = TRUE;
					TRACE("double check fail: sw_netif[%d] %s dslite v6ip mismatch", sw_netif_idx, netif_dev->name);
				}
			}
		}else {
			mismatch = TRUE;
			TRACE("double check fail: sw_netif[%d] %s mac mismatch", sw_netif_idx, netif_dev->name);
		}
	}

	if(mismatch)
		return NULL;
	else
		return netif_dev;
}

struct net_device* rtk_fc_getIngressDev(rtk_fc_pktHdr_t *pPktHdr, struct rt_skbuff *rtskb, rtk_fc_forwardingType_t fwdType, rtk_fc_flow_direction_t dir)
{
	uint32 i =0, cvid = 0;
	struct net_device *netif_dev=NULL;
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);
	bool find = FALSE;
	uint32 find_idx = 0;

	cvid = (pFcIngressData->ingressTagif & CVLAN_TAGIF) ? pFcIngressData->srcCVlanId : ((pFcIngressData->ingressTagif & SVLAN_TAGIF) ? pFcIngressData->srcSVlanId : -1);

	DEBUG("igr netdev %s data: dstMac=%02x:%02x:%02x:%02x:%02x:%02x cvid=%d",
		pFcIngressData->logicalInDev? pFcIngressData->logicalInDev->name : "NULL", 
		pFcIngressData->da[0], pFcIngressData->da[1], pFcIngressData->da[2], pFcIngressData->da[3], pFcIngressData->da[4], pFcIngressData->da[5], cvid);

	if(pFcIngressData->logicalInDev){
		netif_dev = rtk_fc_getIngressDev_by_cachedData(pPktHdr, rtskb, fwdType, dir);
		if(netif_dev){
			//DEBUG("ingress real dev is %s", pFcIngressData->logicalInDev->name);
			goto RET_DEV;
		}
	}

	if((pFcIngressData->ingressTagif & PPPOE_TAGIF)) {
		uint16 sid = pFcIngressData->sessionId;

		/* IP based */

		if((pFcIngressData->ingressTagif & IPV4_TAGIF) || (pFcIngressData->ingressTagif & IPV6_TAGIF))
		{
			find = FALSE;
			if(pPktHdr->isMulticast)
			{
				//pppoe multicast packet: just check session ID
				for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					if(fc_db.netifTbl[i].intf.valid==0)
						continue;
					if(fc_db.netifTbl[i].intf.out_pppoe_sid == sid)
					{
						netif_dev = fc_db.netifTbl[i].dev;
						TRACE("MC dstIp packets: srcDev %s is decided by using PPPoE session ID %d", netif_dev->name, sid);
						goto RET_DEV;
					}
				}
			}
			else if(fwdType == RTK_FC_FWDTYPE_NAPT)
			{
				// IPv4 NAPT: search PPP interface by gateway IP
				for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					//DEBUG("i = %d, gateway ip = 0x%x, packet sip = 0x%x", i, fc_db.netifTbl[i].intf.gateway_ipv4_addr, pPktHdr->iph->saddr);
					if(fc_db.netifTbl[i].intf.valid==0)
						continue;
					if( (pPktHdr->iph) && 
						(fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0) && 
						(fc_db.netifTbl[i].intf.gateway_ipv4_addr==pFcIngressData->dstIp)
					)
					{
						find = TRUE;
						find_idx = i;
						TRACE("srcDev %s is decided by using dstIp %pI4", fc_db.netifTbl[i].dev->name, &pFcIngressData->dstIp);
						break;
					}
					else if (pPktHdr->ip6h)
					{
						if(RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[i].dev, pFcIngressData->dstIp,dir) == SUCCESS)
						{
							find = TRUE;
							find_idx = i;
							TRACE("IPv6 Find PPPoE interface %s by compare v6 hash :0x%x",fc_db.netifTbl[i].dev->name, pFcIngressData->dstIp);
							break;
						}
					}
				}
			}
			else if(fwdType == RTK_FC_FWDTYPE_ROUTING)
			{
				// IPv4/IPv6 routing: If pppoe, search PPP interface SID and MAC first
				for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					uint8 *pMac = &fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0];
					if(fc_db.netifTbl[i].intf.valid && (fc_db.netifTbl[i].intf.out_pppoe_sid == (sid&0xffff)) && (fc_db.netifTbl[i].intf.out_pppoe_act == FB_NETIFPPPOE_ACT_ADD) && (!memcmp(pMac, &pFcIngressData->da[0], ETH_ALEN)))
					{
						find = TRUE;
						find_idx = i;
						TRACE("srcDev %s is decided by using pppoe session id 0x%x", fc_db.netifTbl[i].dev->name, sid);
						break;
					}
				}

				// IPv4/IPv6 routing: search empty PPP interface
				if(find == FALSE)
				{
					for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
					{
						unsigned int type=0;
						uint8 *pMac = &fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0];

						if(fc_db.netifTbl[i].intf.valid==0)
							continue;

						RTK_FC_HELPER_NETDEV_GET_DEV_DATA(fc_db.netifTbl[i].dev, &type, RTK_FC_NETDEV_GET_TYPE);
						//routing: check interface type, zero MAC
						if((type == ARPHRD_PPP) && ((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0))
						{
							// DSLITE pppoe down stream interface
							if(dir == RTK_FC_FLOW_DIRECTION_DOWNSTREAM)
							{
								if(pFcIngressData->ingressTagif == DSLITE_TAGIF)
								{
									int ret = 0;

								        ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[i].dev, pFcIngressData->dstIp, dir);

								        if( ret!=SUCCESS)
								                continue;
								        TRACE("[DSLITE]Find ppp interface %s by compare v6 hash :0x%x",fc_db.netifTbl[i].dev->name, pFcIngressData->dstIp);
								}
								else if(pFcIngressData->ingressTagif == V6RD_TAGIF)
								{
									int ipAddr = 0;

									RTK_FC_HELPER_RCU_INDEV_GET_IPADDR(fc_db.netifTbl[i].dev, &ipAddr);
									if(pFcIngressData->dstIp != ipAddr)
										continue;
								}
							}
							find = TRUE;
							find_idx = i;
							TRACE("srcDev %s is decided by ARPHRD_PPP type with zero MAC intf", fc_db.netifTbl[i].dev->name);
							break;
						}
					}
				}
			}
			if(find && (find_idx<RTK_FC_TABLESIZE_INTF_SW))
			{
				uint8 *pMac = &fc_db.netifTbl[find_idx].intf.gateway_mac_addr.octet[0];
				bool update = FALSE;

				if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0)	// sync ethnet device mac to ppp interface
				{
					int ret;
					ret = rtk_fc_update_pppNetif_macInfo(find_idx, pMac, &pFcIngressData->da[0]);
					if(ret)
					{
						WARNING("update ppp interface gateway MAC failed, ret = %d", ret);
						goto RET_DEV;
					}
					update = TRUE;
					if((fc_db.netifTbl[find_idx].intf.out_pppoe_sid != (sid&0xffff)) || fc_db.netifTbl[find_idx].intf.out_pppoe_act != FB_NETIFPPPOE_ACT_ADD)// sid change or pppoe_act change
						rtk_fc_update_pppoeHwNetif_info(find_idx,sid);
				}
				if((fc_db.netifTbl[find_idx].hwIdx!=SIGNED_INVALID) && update)
				{
					if(fc_db.netifHwTbl[fc_db.netifTbl[find_idx].hwIdx].ifTempEntry)
						TRACE("hw netif tempEntry of sw_netif[%d] will be update by flow later: sid %d", find_idx, sid);
					else
						WARNING("try to update sw_netif[%d] hw_netif[%d] sid[%d], but the hw netif is not a tempEntry", find_idx, fc_db.netifTbl[find_idx].hwIdx, sid);
				}
				
				netif_dev = fc_db.netifTbl[find_idx].dev;
				goto RET_DEV;
			}
		}

	}
#if 0  // WEN:We use smux device now, and smux device will not add vlan id when rtk_fc_netif_sw_add. For the purpose of efficiency, don't use vlan to find device (saving for-loop time).
	/* VLAN based */
	if(cvid!=FAIL)
	{
		for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
		{
			if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
				continue;
			if(cvid == fc_db.netifTbl[i].vlanId)
			{
				netif_dev=fc_db.netifTbl[i].dev;
				TRACE("SrcDev %s is decided by using cvid[%d]", netif_dev->name, cvid);
				goto RET_DEV;
			}
		}
	}
#endif	
	// for finding NAT device

	/* MAC based */
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
			continue;
		
		if(!memcmp(fc_db.netifTbl[i].intf.gateway_mac_addr.octet, pFcIngressData->da, ETH_ALEN))
		{
			if( dir == RTK_FC_FLOW_DIRECTION_DOWNSTREAM && fwdType==RTK_FC_FWDTYPE_NAPT)
			{
				if(pPktHdr->iph!=NULL && fc_db.netifTbl[i].intf.gateway_ipv4_addr != pFcIngressData->dstIp) // For v4 nat device getting
				{
					if ((pFcIngressData->ingressTagif&DSLITE_TAGIF)==0)//Exclude MAP-E
						continue;
				}
				else if ( pPktHdr->ip6h!=NULL && pPktHdr->iph==NULL ) // For v6 nat device getting
				{
					// TODO : For supporting v6 NAT/NPT
				}
			}
			else if(dir == RTK_FC_FLOW_DIRECTION_DOWNSTREAM && pFcIngressData->ingressTagif == DSLITE_TAGIF ) // For ipv6 nat
			{
		        int ret = 0;

		        ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[i].dev, pFcIngressData->dstIp, dir);

		        if( ret!=SUCCESS)
		                continue;
		        TRACE("[DSLITE]Find interface %s by compare v6 hash :0x%x",fc_db.netifTbl[i].dev->name, pFcIngressData->dstIp);
			}
			netif_dev=fc_db.netifTbl[i].dev;
			TRACE("SrcDev %s is decided by using mac[%02x:%02x:%02x:%02x:%02x:%02x]", netif_dev->name, pFcIngressData->da[0], pFcIngressData->da[1], pFcIngressData->da[2], pFcIngressData->da[3], pFcIngressData->da[4], pFcIngressData->da[5]);
			goto RET_DEV;
		}
	}
	


	/* default:
		1. routing untag wan - multicast
		2. bridged untag wan (should not happen)
	*/
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)			// find a non-bridged interface without VLAN
	{
		if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
			continue;

		if(fwdType!=RTK_FC_FWDTYPE_BRIDGE){
			if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE)
				|| RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_BRIDGE_PORT)
				|| RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_LIVE_ADDR_CHANGE))
				continue;

			if(fc_db.netifTbl[i].vlanId==0)	// for smux untag wan
			{
				netif_dev = fc_db.netifTbl[i].dev;
				TRACE("SrcDev %s is decided by choosing a non-bridge and untag interface", netif_dev->name);
				goto RET_DEV;
			}
		}else{
			if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE)
				|| RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_LIVE_ADDR_CHANGE))
			{
				netif_dev = fc_db.netifTbl[i].dev;
				TRACE("SrcDev %s is decided by choosing a bridge interface", netif_dev->name);
				goto RET_DEV;
			}
		}
	}

RET_DEV:
	return netif_dev;
}


struct net_device* rtk_fc_getEgressDev(rtk_fc_pktHdr_t *pPktHdr, struct rt_skbuff *rtskb, rtk_fc_forwardingType_t fwdType, rtk_fc_flow_direction_t dir)
{
	uint32 i =0;
	struct net_device *dev = pPktHdr->dstDev, *netif_dev=NULL;
	struct ethhdr *eth = pPktHdr->eth;
	uint8 isEndPointTunnel = FALSE;
	bool find = FALSE;
	uint32 find_idx = 0;
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);

	DEBUG("egr netdev %s/%s srcMac=%pM dstPort=%d Dualtype = %d", (pFcIngressData->logicalOutDev)?pFcIngressData->logicalOutDev->name:"NULL", 
			dev->name, &eth->h_source, pPktHdr->egressPort.macPortIdx, pPktHdr->dualHdrType);

	/*
		2020/05/06 Wen
		Only endpoint tunnel (l2tp / pptp ) should find device by type-ppp,
		l2tp / pptp passthrough should get egress device by mac.
	*/
	if(((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP) || (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP)) && pPktHdr->dual_passthrough_type==RTK_FC_DUALTYPE_NONE )
		isEndPointTunnel = TRUE;

	if(pFcIngressData->logicalOutDev){
		netif_dev = rtk_fc_getEgressDev_by_cachedData(pPktHdr, rtskb, fwdType, dir);
		if(netif_dev){
			//DEBUG("ingress real dev is %s", pFcIngressData->logicalInDev->name);
			goto RET_DEV;
		}
	}

	if(pPktHdr->ppph || isEndPointTunnel==TRUE)
	{
		/* IP based */
		if(pPktHdr->iph || pPktHdr->ip6h)	//ipv4 or ipv6
		{
			find = FALSE;
			if(fwdType == RTK_FC_FWDTYPE_NAPT)
			{
				// IPv4 NAPT: search PPP interface by gateway IP
				for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
				{
					unsigned int type=0;

					//DEBUG("i = %d, gateway ip = 0x%x, packet sip = 0x%x", i, fc_db.netifTbl[i].intf.gateway_ipv4_addr, pPktHdr->iph->saddr);
					if(fc_db.netifTbl[i].intf.valid==0)
						continue;

					RTK_FC_HELPER_NETDEV_GET_DEV_DATA(fc_db.netifTbl[i].dev, &type, RTK_FC_NETDEV_GET_TYPE);

					// IPv4 NAPT: search PPP interface by gateway IP
					if(pPktHdr->iph &&
						(fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0) && (fc_db.netifTbl[i].intf.gateway_ipv4_addr==ntohl(pPktHdr->iph->saddr)) && (type == ARPHRD_PPP)) {
						find = TRUE;
						find_idx = i;
						TRACE("DstDev %s is decided by using srcIp %pI4", fc_db.netifTbl[i].dev->name, &pPktHdr->iph->saddr);
						break;
					}
					else if ( pPktHdr->ip6h)// IPv6 NAPT: search PPP interface by gateway IP hash
					{
					        if(RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[i].dev, pPktHdr->ipv6Sip_hash,dir) == SUCCESS)
						{
							find = TRUE;
							find_idx = i;
							TRACE("IPv6 Find PPPoE interface %s by compare v6 hash :0x%x",fc_db.netifTbl[i].dev->name, pPktHdr->ipv6Sip_hash);
							break;
						}
					}
				}
			}
			else if(fwdType == RTK_FC_FWDTYPE_ROUTING)
			{
				// IPv4/IPv6 routing: If pppoe, search PPP interface SID and MAC first
				if(pPktHdr->ppph)
				{
					for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
					{
						int32 sid = ntohs(pPktHdr->ppph->sid);
						uint8 *pMac = &fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0];
						if(fc_db.netifTbl[i].intf.valid && (fc_db.netifTbl[i].intf.out_pppoe_sid == (sid&0xffff)) && (fc_db.netifTbl[i].intf.out_pppoe_act == FB_NETIFPPPOE_ACT_ADD) && (!memcmp(pMac, &pPktHdr->eth->h_source[0], ETH_ALEN)))
						{
							find = TRUE;
							find_idx = i;
							TRACE("DstDev %s is decided by using pppoe session id 0x%x", fc_db.netifTbl[i].dev->name, sid);
							break;
						}
					}
				}

				// IPv4/IPv6 routing: search empty PPP interface
				if(find == FALSE)
				{
					for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
					{
						unsigned int type=0;
						uint8 *pMac = &fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0];

						if(fc_db.netifTbl[i].intf.valid==0)
							continue;

						RTK_FC_HELPER_NETDEV_GET_DEV_DATA(fc_db.netifTbl[i].dev, &type, RTK_FC_NETDEV_GET_TYPE);
						//routing: check interface type, zero MAC
						if((type == ARPHRD_PPP) && ((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0))
						{
							if(dir == RTK_FC_FLOW_DIRECTION_UPSTREAM && pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE && pPktHdr->ip6h != NULL && pPktHdr->iph!=NULL)
							{
								int ret = 0;

						        ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDR(fc_db.netifTbl[i].dev, &pPktHdr->ip6h->saddr);

						        if( ret!=SUCCESS)
						                continue;
						        TRACE("[DSLITE]Find ppp interface %s by compare v6 address:%pI6",fc_db.netifTbl[i].dev->name,&pPktHdr->ip6h->saddr.s6_addr32[0]);

							}
							find = TRUE;
							find_idx = i;
							TRACE("DstDev %s is decided by ARPHRD_PPP type with zero MAC intf", fc_db.netifTbl[i].dev->name);
							break;
						}
					}
				}
			}

			if(find && (find_idx<RTK_FC_TABLESIZE_INTF_SW))
			{
				uint8 *pMac = &fc_db.netifTbl[find_idx].intf.gateway_mac_addr.octet[0];
				int32 sid = pPktHdr->ppph ? ntohs(pPktHdr->ppph->sid) : -1;
				bool update = FALSE;

				if((pMac[0]|pMac[1]|pMac[2]|pMac[3]|pMac[4]|pMac[5])==0x0)	// sync ethnet device mac to ppp interface
				{
					int ret;
					ret = rtk_fc_update_pppNetif_macInfo(find_idx, pMac, &pPktHdr->eth->h_source[0]);
					if(ret)
					{
						WARNING("update ppp interface gateway MAC failed, ret = %d", ret);
						goto RET_DEV;
					}
					update = TRUE;
					if((sid!=-1) && ((fc_db.netifTbl[find_idx].intf.out_pppoe_sid != (sid&0xffff)) || fc_db.netifTbl[find_idx].intf.out_pppoe_act != FB_NETIFPPPOE_ACT_ADD) )// sid change or pppoe_act change
						rtk_fc_update_pppoeHwNetif_info(find_idx,sid);
				}

				if((fc_db.netifTbl[find_idx].hwIdx!=SIGNED_INVALID) && update)
				{
					if(fc_db.netifHwTbl[fc_db.netifTbl[find_idx].hwIdx].ifTempEntry)
						TRACE("hw netif tempEntry of sw_netif[%d] will be update by flow later, sid: %d", find_idx, sid);
					else
						WARNING("try to update sw_netif[%d] hw_netif[%d] sid[%d], but the hw netif is not a tempEntry", find_idx, fc_db.netifTbl[find_idx].hwIdx, sid);
				}
				
				netif_dev = fc_db.netifTbl[find_idx].dev;
				goto RET_DEV;
			}
		}
	}
	else
	{
#if 0 //WEN: We use smux device now, and smux device will not add vlan id when rtk_fc_netif_sw_add. For the purpose of efficiency, don't use vlan to find device (saving for-loop time).
		/* VLAN based */
		if(pPktHdr->cvh)
		{
			for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
			{
				if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
					continue;
				if(pPktHdr->cvlanid == fc_db.netifTbl[i].vlanId)
				{
					netif_dev=fc_db.netifTbl[i].dev;
					TRACE("DstDev %s is decided by using cvid[%d]", netif_dev->name, (ntohs(pPktHdr->cvh->h_vlan_TCI)&VLAN_VID_MASK));
					goto RET_DEV;
				}
			}
		}else if(pPktHdr->svh)
		{
			for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
			{
				if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
					continue;
				if(pPktHdr->svlanid == fc_db.netifTbl[i].vlanId)
				{
					netif_dev=fc_db.netifTbl[i].dev;
					TRACE("DstDev %s is decided by using svid[%d]", netif_dev->name, (ntohs(pPktHdr->svh->h_vlan_TCI)&VLAN_VID_MASK));
					goto RET_DEV;
				}
			}
		}
#endif
//MACBASED:
		/* MAC based */ // For finding nat device
		for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
		{

			if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
				continue;
			if((!memcmp(fc_db.netifTbl[i].intf.gateway_mac_addr.octet, eth->h_source, ETH_ALEN)) )
			{		

				if(dir == RTK_FC_FLOW_DIRECTION_UPSTREAM && fwdType==RTK_FC_FWDTYPE_NAPT )
				{
					if( pPktHdr->iph!=NULL && fc_db.netifTbl[i].intf.gateway_ipv4_addr != ntohl(pPktHdr->iph->saddr) ) // For ipv4 nat or ds-lite
					{
						if (pPktHdr->dualHdrType != RTK_FC_DUALTYPE_DSLITE)//Exclude MAP-E
							continue;
					}
					else if(pPktHdr->ip6h != NULL && pPktHdr->iph==NULL) // For ipv6 nat
					{
						// TODO : For supporting v6 NAT/NPT 
					}
				}
				else if(dir == RTK_FC_FLOW_DIRECTION_UPSTREAM && pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE && pPktHdr->ip6h != NULL && pPktHdr->iph!=NULL) // For ipv6 nat
				{
			        int ret = 0;

			        ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDR(fc_db.netifTbl[i].dev, &pPktHdr->ip6h->saddr);

			        if( ret!=SUCCESS)
			                continue;
			        TRACE("[DSLITE]Find interface %s by compare v6 address:%pI6",fc_db.netifTbl[i].dev->name,&pPktHdr->ip6h->saddr.s6_addr32[0]);
				}
				netif_dev = fc_db.netifTbl[i].dev;
				TRACE("DstDev %s is decided by using mac[%pM]", netif_dev->name, &eth->h_source[0]);
				goto RET_DEV;
			}
		}
		
		
	}

	/* default:
		1. routing untag wan for multicast
		2. bridged untag wan (should not happen)
	*/
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)			// find a non-bridged interface without VLAN
	{
		if((fc_db.netifTbl[i].intf.valid == FALSE) || (fc_db.netifTbl[i].hwIdx == SIGNED_INVALID))
			continue;

		if(fwdType!=RTK_FC_FWDTYPE_BRIDGE){
			if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE)
				|| RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_BRIDGE_PORT)
				|| RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_LIVE_ADDR_CHANGE))
				continue;

			if(fc_db.netifTbl[i].vlanId==0)	// for smux untag wan
			{
				netif_dev = fc_db.netifTbl[i].dev;
				TRACE("DstDev %s is decided by choosing a non-bridge and untag interface", netif_dev->name);
				goto RET_DEV;
			}
		}else{

			if(RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_EBRIDGE)
				|| RTK_FC_HOOK_PS_DEV_IS_PRIV_FLAGS_SET(fc_db.netifTbl[i].dev, RTK_FC_NETDEV_PRIV_FLAG_TYPE_LIVE_ADDR_CHANGE))
			{
				netif_dev = fc_db.netifTbl[i].dev;
				TRACE("DstDev %s is decided by choosing a bridge interface", netif_dev->name);
				goto RET_DEV;
			}
		}
	}

RET_DEV:
	return netif_dev;
}

static inline struct nf_conn *rtk_fc_flow_ct_get(rtk_fc_tableFlow_t *pFlowTbl)
{
	return pFlowTbl->cachedCt;
}

rtk_fc_ret_t rtk_fc_flow_ct_decision(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, struct rt_nfconn **rtct)
{
	struct nf_conn *pEgrCT = NULL;
	bool alive = TRUE;
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);

	// get ct(conntrack) from skb
	RTK_FC_HOOK_PS_CT_GET(RTSKB_SKB(rtskb), &pEgrCT);

	if(pFcIngressData->ct!=NULL && ((pEgrCT==NULL) ||			/* e.g. pppoe upstream */
		(!pFcIngressData->isDualHeader && pPktHdr->dualHdrType) /*e.g. single -> dual*/)) {
		pEgrCT = pFcIngressData->ct;
	}

	if(fc_db.controlFuc.flow_skipAllPsTracking){
		pEgrCT = NULL;
	}

	if(pEgrCT) {
		RTK_FC_HOOK_PS_CT_SESSION_ALIVE_CHECK(pEgrCT, &alive);
		if(!alive) {
			return RTK_FC_RET_LRN_FAIL;
		}
		
		RTK_FC_HOOK_CONVERTER_CT(pEgrCT, *rtct);
	}


	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_flow_ct_detach(rtk_fc_tableFlow_t *pFlowTbl)
{
	if(pFlowTbl->cachedCt) {
		RTK_FC_HELPER_PS_CT_NF_CT_PUT(&pFlowTbl->cachedCt->ct_general);
		FLOW_INFO_SET(pFlowTbl, FLOW_INFO_SKIP_CT, TRUE);
		pFlowTbl->cachedCt = NULL;
	}

	return RTK_FC_RET_OK;
}


#if defined(CONFIG_RTK_L34_XPON_PLATFORM) 

rtk_fc_ret_t rtk_fc_flow_flush_forHashChange(void)
{
	int i, j, hashIdx, entIdx;
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;

	TABLE("flush all non-mc entry");
	//do not flush static flows
	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);

		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
				continue;

			//skip update flow if it's busy
			if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
			{
				fc_db.flowTbl[entIdx].needUpdate = 1;
				continue;
			}

			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		}

		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
						continue;

					//skip update flow if it's busy
					if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
					{
						fc_db.flowTbl[entIdx].needUpdate = 1;
						continue;
					}

					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}

		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
						continue;

					//skip update flow if it's busy
					if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
					{
						fc_db.flowTbl[entIdx].needUpdate = 1;
						continue;
					}

					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}
		
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

	return (RTK_FC_RET_OK);
}

#endif
/*
*	flush flows when:
		1. user request via ctrl proc
		2. netif/interface add or del
*/
rtk_fc_ret_t rtk_fc_flow_flush(void)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	// flush uuc/uipmc mac
	for(i=0 ; i<RTK_FC_TABLESIZE_LUT ;i++)
	{
		if(fc_db.lutTbl[i] && fc_db.lutTbl[i]->valid && fc_db.lutTbl[i]->isUnknowUcMc)
			assert_ok(RTK_FC_LUT_DEL(fc_db.lutTbl[i], fc_db.lutTbl[i]->anyFlowEstablish ? FALSE : TRUE));
	}


	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);

		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			//skip update flow if it's busy
			if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
			{
				fc_db.flowTbl[entIdx].needUpdate = 1;
				continue;
			}

			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					//skip update flow if it's busy
					if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
					{
						fc_db.flowTbl[entIdx].needUpdate = 1;
						continue;
					}

					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}
#endif
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					//skip update flow if it's busy
					if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
					{
						fc_db.flowTbl[entIdx].needUpdate = 1;
						continue;
					}

					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			//skip update flow if it's busy
			if(fc_db.systemGlobal.flow_not_update_in_real_time && fc_db.flowTbl[entIdx].idleSecs==0)
			{
				fc_db.flowTbl[entIdx].needUpdate = 1;
				continue;
			}

			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		}
	}

	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif

	return (RTK_FC_RET_OK);
}
#if defined(CONFIG_FC_RTL8277C_SERIES)
rtk_fc_ret_t rtk_fc_ct_info_flush(void)
{
	rtk_fc_ct_hash_info_t *pTmp_ct_hash_list, *pTmp_next_ct_hash_list;
	int i ;
	for(i = 0 ; i < RTK_FC_CT_HASH_INFO_BUCKET_SIZE; i++)
	{
		if(!list_empty(&fc_db.ct_hash_info_ListHead[i]))
		{
			list_for_each_entry_safe(pTmp_ct_hash_list, pTmp_next_ct_hash_list, &fc_db.ct_hash_info_ListHead[i], ct_hash_list)
			{
				list_del(&pTmp_ct_hash_list->ct_hash_list);
				RTK_FC_HELPER_FC_KFREE(pTmp_ct_hash_list, sizeof(rtk_fc_ct_hash_info_t));
			}
		}
	}
	return (RTK_FC_RET_OK);
	
}
#endif
rtk_fc_ret_t rtk_fc_reset_v6NatTable(void)
{
	int i;

	//do not flush static flows
	for(i = RTK_FC_I6NAT_TABLE_START_INDEX ; i < RTK_FC_TABLESIZE_I6NAT_MAPPING_TABLE; i ++)
	{
		bzero(&fc_db.ipv6_nat_mappingTbl[i].addr, sizeof(struct in6_addr));
		
		atomic_set(&fc_db.ipv6_nat_mappingTbl[i].refCount, 0);
	}
	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_reset_v6MaptTable(void)
{
	int i;

	for(i = RTK_FC_I6MAPT_TABLE_START_INDEX ; i < RTK_FC_TABLESIZE_I6MAPT_MAPPING_TABLE; i ++)
	{
		fc_db.ipv6_mapt_mappingTbl[i].isHash = 0;
		bzero(&fc_db.ipv6_mapt_mappingTbl[i].addr, sizeof(struct in6_addr));
		atomic_set(&fc_db.ipv6_mapt_mappingTbl[i].refCount, 0);
	}
	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_flow_flush_all(void)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
				if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
					continue;
#else
				if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
					continue;
#endif
					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}
		
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		}
	}

	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif


	return (RTK_FC_RET_OK);
}

static uint8 rtk_fc_flow_delete_by_pattern_matchOrNot(rt_flow_op_flow_pattern_t flowPattern, uint32 flowIdx)
{
	rtk_fc_tableFlowEntry_t *pFlow=NULL;
	int16 lut_igr_idx, lut_egr_idx;

	pFlow=fc_db.flowTbl[flowIdx].pFlowEntry;

	// match flows:
	if(pFlow &&	((pFlow->path1.in_path==FB_PATH_34) || (pFlow->path1.in_path==FB_PATH_5)))
	{
		lut_igr_idx = fc_db.flowTbl[flowIdx].lutIgrSaIdx;
		lut_egr_idx = fc_db.flowTbl[flowIdx].lutEgrDaIdx;

		if((flowPattern.l4proto_valid) && (flowPattern.l4proto != pFlow->path3.in_l4proto))
			goto NOT_MATCH;

		if((flowPattern.sip4_valid || flowPattern.dip4_valid || flowPattern.modified_sip4_valid || flowPattern.modified_dip4_valid) && (flowPattern.sip6_valid || flowPattern.dip6_valid))
			goto NOT_MATCH; //pattern include IPv4 and IPv6 at the same time

		if((flowPattern.sip4_valid || flowPattern.dip4_valid || flowPattern.modified_sip4_valid || flowPattern.modified_dip4_valid) && pFlow->path3.in_ipv4_or_ipv6)
			goto NOT_MATCH; //pattern include SIPv4 or DIPv4 but is IPv6 flow

		if(flowPattern.sip4_valid && (flowPattern.sip4 != pFlow->path3.in_src_ipv4_addr))
			goto NOT_MATCH; //pattern include SIPv4 but no hit

		if(flowPattern.dip4_valid && (flowPattern.dip4 != pFlow->path3.in_dst_ipv4_addr))
			goto NOT_MATCH; //pattern include DIPv4 but no hit

		if((flowPattern.sip6_valid || flowPattern.dip6_valid) && !pFlow->path3.in_ipv4_or_ipv6)
			goto NOT_MATCH; //pattern include SIPv6 or DIPv6 but is IPv4 flow

		if(flowPattern.sip6_valid && (_rtk_rg_flowHashIPv6SrcAddr_get(flowPattern.sip6) != pFlow->path3.in_src_ipv6_addr_hash))
			goto NOT_MATCH; //pattern include SIPv6 but no hit

		if(flowPattern.dip6_valid && (_rtk_rg_flowHashIPv6DstAddr_get(flowPattern.dip6) != pFlow->path3.in_dst_ipv6_addr_hash))
			goto NOT_MATCH; //pattern include DIPv6 but no hit

		if(flowPattern.sport_valid && (flowPattern.sport != pFlow->path3.in_l4_src_port))
			goto NOT_MATCH; //pattern include SPORT but no hit

		if(flowPattern.dport_valid && (flowPattern.dport != pFlow->path3.in_l4_dst_port))
			goto NOT_MATCH; //pattern include DPORT but no hit

		if (flowPattern.mac_valid && (flowPattern.mac_lut_idx != lut_igr_idx) && (flowPattern.mac_lut_idx != lut_egr_idx)) {
			goto NOT_MATCH; //pattern include MAC but no hit
		}
		else {
			if (flowPattern.smac_valid && (flowPattern.smac_lut_idx != lut_igr_idx))
				goto NOT_MATCH; //pattern include SMAC but no hit

			if (flowPattern.dmac_valid && (flowPattern.dmac_lut_idx != lut_egr_idx))
				goto NOT_MATCH; //pattern include DMAC but no hit
		}

		//check modified pattern
		if(pFlow->path1.in_path==FB_PATH_5 && pFlow->path5.out_l4_act){
			if(pFlow->path5.out_l4_direction){	//upstream
				if(flowPattern.modified_sip4_valid && (flowPattern.modified_sip4 != fc_db.netifHwTbl[pFlow->path5.out_intf_idx].intf.gateway_ipv4_addr))
					goto NOT_MATCH; //pattern include MSIPv4 but no hit

				if(flowPattern.modified_sport_valid && (flowPattern.modified_sport != pFlow->path5.out_l4_port))
					goto NOT_MATCH; //pattern include MSPORT but no hit
			}else{	//downstream
				if(flowPattern.modified_dip4_valid && (flowPattern.modified_dip4 != pFlow->path5.out_dst_ipv4_addr))
					goto NOT_MATCH; //pattern include MDIPv4 but no hit

				if(flowPattern.modified_dport_valid && (flowPattern.modified_dport != pFlow->path5.out_l4_port))
					goto NOT_MATCH; //pattern include MDPORT but no hit
			}
		}
	}
	else
		goto NOT_MATCH;

	return TRUE;

NOT_MATCH:
	return FALSE;
	
}

rtk_fc_ret_t rtk_fc_flow_delete_by_pattern(rt_flow_op_flow_pattern_t flowPattern)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	if(!(flowPattern.sip6_valid || flowPattern.dip6_valid || flowPattern.sip4_valid || flowPattern.dip4_valid || flowPattern.sport_valid || flowPattern.dport_valid || flowPattern.l4proto_valid || flowPattern.modified_sip4_valid || flowPattern.modified_dip4_valid || flowPattern.modified_sport_valid || flowPattern.modified_dport_valid || flowPattern.mac_valid || flowPattern.smac_valid || flowPattern.dmac_valid))
		return (RTK_FC_RET_OK); // no valid pattern, do nothing

	if (flowPattern.mac_valid) {
		flowPattern.mac_lut_idx = -1;

		if (_rtk_fc_lut_find(flowPattern.mac, &flowPattern.mac_lut_idx) == RTK_FC_RET_OK) {
			API("[flowOp] pattern MAC: %pM mac_lut_idx %d", flowPattern.mac, flowPattern.mac_lut_idx);
		}
		else {
			API("[flowOp] pattern MAC: %pM not in lut tbl", flowPattern.mac);
		}
	}

	if (flowPattern.smac_valid) {
		flowPattern.smac_lut_idx = -1;

		if (_rtk_fc_lut_find(flowPattern.smac, &flowPattern.smac_lut_idx) == RTK_FC_RET_OK) {
			API("[flowOp] pattern SMAC: %pM smac_lut_idx %d", flowPattern.smac, flowPattern.smac_lut_idx);
		}
		else {
			API("[flowOp] pattern SMAC: %pM not in lut tbl", flowPattern.smac);
		}
	}

	if (flowPattern.dmac_valid) {
		flowPattern.dmac_lut_idx = -1;

		if (_rtk_fc_lut_find(flowPattern.dmac, &flowPattern.dmac_lut_idx)  == RTK_FC_RET_OK) {
			API("[flowOp] pattern DMAC: %pM dmac_lut_idx %d", flowPattern.dmac, flowPattern.dmac_lut_idx);
		}
		else {
			API("[flowOp] pattern DMAC: %pM not in lut tbl", flowPattern.dmac);
		}
	}

	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(rtk_fc_flow_delete_by_pattern_matchOrNot( flowPattern, entIdx)==TRUE) {
				TABLE("Delete flow entry [%d] by pattern", entIdx);
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
			
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if(rtk_fc_flow_delete_by_pattern_matchOrNot( flowPattern, entIdx)==TRUE) {
						TABLE("Delete flow entry [%d] by pattern", entIdx);
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}

				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if(rtk_fc_flow_delete_by_pattern_matchOrNot( flowPattern, entIdx)==TRUE) {
						TABLE("Delete flow entry [%d] by pattern", entIdx);
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}

				}
			}
		}
		
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(rtk_fc_flow_delete_by_pattern_matchOrNot( flowPattern, entIdx)==TRUE) {
				TABLE("Delete flow entry [%d] by pattern", entIdx);
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}

		}
	}

	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif

	return (RTK_FC_RET_OK);
}


rtk_fc_ret_t rtk_fc_flow_delete_by_intfIdx(int intfIdx)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	//Check input parameters
	FC_PARAM_CHK((intfIdx>=RTK_FC_TABLESIZE_INTF), RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);

	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			// match flows:
			// 1. ingress interface: path1/3/4/5/6, path2 is reserved bits.
			// 2. egress interface: path1/2/3/4/5, path6 has no out_intf_idx field.
			if(fc_db.flowTbl[entIdx].pFlowEntry  &&
				((fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path==FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_multiple_act!= TRUE && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) || 
				(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) ||
				(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_6 && fc_db.flowTbl[entIdx].pFlowEntry->path1.out_intf_idx==intfIdx))
				)
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}

			
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					// match flows:
					// 1. ingress interface: path1/3/4/5/6, path2 is reserved bits.
					// 2. egress interface: path1/2/3/4/5, path6 has no out_intf_idx field.
					if(fc_db.flowTbl[entIdx].pFlowEntry  &&
						((fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path==FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_multiple_act!= TRUE && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) || 
						(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) ||
						(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_6 && fc_db.flowTbl[entIdx].pFlowEntry->path1.out_intf_idx==intfIdx))
						)
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					// match flows:
					// 1. ingress interface: path1/3/4/5/6, path2 is reserved bits.
					// 2. egress interface: path1/2/3/4/5, path6 has no out_intf_idx field.
					if(fc_db.flowTbl[entIdx].pFlowEntry  &&
						((fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path==FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_multiple_act!= TRUE && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) || 
						(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) ||
						(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_6 && fc_db.flowTbl[entIdx].pFlowEntry->path1.out_intf_idx==intfIdx))
						)
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		// flush HW flow - overflow hash
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		if(!list_empty(&fc_db.overFlowHash_inUseListHead))
		{
			list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
			{
				entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
				if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
					continue;
#else
				if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
					continue;
#endif
				if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
					continue;

				// match flows:
				// 1. ingress interface: path1/3/4/5/6, path2 is reserved bits.
				// 2. egress interface: path1/2/3/4/5, path6 has no out_intf_idx field.
				if(fc_db.flowTbl[entIdx].pFlowEntry  &&
					((fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path==FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_multiple_act!= TRUE && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) ||
					(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_12 && fc_db.flowTbl[entIdx].pFlowEntry->path1.in_intf_idx==intfIdx) ||
					(fc_db.flowTbl[entIdx].pFlowEntry->path1.in_path!=FB_PATH_6 && fc_db.flowTbl[entIdx].pFlowEntry->path1.out_intf_idx==intfIdx))
					)
				{
					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}

		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif


	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_flow_delete_by_l2Idx(int l2Idx)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif
#if 0// debug flush time 
	unsigned long start_jiffies=jiffies;
	struct timeval tv;
#endif
	//Check input parameters
	FC_PARAM_CHK((l2Idx>=RTK_FC_TABLESIZE_LUT), RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);

	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// reduce scanning time
		if(	(fc_db.fb_hwFlow_validBitsArray[(hashIdx >> 5)] == 0) &&
			((rgpro_db.fbMode!=FB_MODE_4K) || ((rgpro_db.fbMode==FB_MODE_4K) && list_empty(&fc_db.flowTcam_hashListHead[i]))) &&
			(list_empty(&fc_db.swFlow_hashListHead[(i << fc_db.swflowlistBucketExtendShift)])) 	) {
			continue;
		}

		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx);
#else
		
		rtk_fc_flow_batchscan_group_lock(i);
#endif
		
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(fc_db.flowTbl[entIdx].lutIgrSaIdx==l2Idx || fc_db.flowTbl[entIdx].lutEgrDaIdx==l2Idx)
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if(fc_db.flowTbl[entIdx].lutIgrSaIdx==l2Idx || fc_db.flowTbl[entIdx].lutEgrDaIdx==l2Idx)
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if(fc_db.flowTbl[entIdx].lutIgrSaIdx==l2Idx || fc_db.flowTbl[entIdx].lutEgrDaIdx==l2Idx)
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
		
		//============================================//
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx);
#else

		rtk_fc_flow_batchscan_group_unlock(i);
#endif
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(fc_db.flowTbl[entIdx].lutIgrSaIdx==l2Idx || fc_db.flowTbl[entIdx].lutEgrDaIdx==l2Idx)
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
		}
	}

	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif

#if 0// debug flush time
	jiffies_to_timeval((jiffies - start_jiffies), &tv);
	WARNING("processing time = %ld.%06ld sec ", tv.tv_sec, tv.tv_usec);
#endif

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_flow_delete_by_wlanIdx(rtk_fc_wlan_devidx_t wlanIdx)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	//Check input parameters
	FC_PARAM_CHK((wlanIdx>=RTK_FC_WLANX_END_INTF), RTK_FC_RET_ERR_INVALID_PARAM);

	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if((fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->wlan_dev_idx==wlanIdx) || 
				(fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->wlan_dev_idx==wlanIdx) )
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if((fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->wlan_dev_idx==wlanIdx) || 
						(fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->wlan_dev_idx==wlanIdx) )
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if((fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->wlan_dev_idx==wlanIdx) || 
						(fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->wlan_dev_idx==wlanIdx) )
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if((fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->wlan_dev_idx==wlanIdx) || 
				(fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->wlan_dev_idx==wlanIdx) )
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
		}
	}

	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif


	return (RTK_FC_RET_OK);
}


rtk_fc_ret_t rtk_fc_flow_delete_by_spa(int spa)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	//Check input parameters
	FC_PARAM_CHK((spa>=RTK_FC_MAC_PORT_MAX), RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);

	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(    ( fc_db.flowTbl[entIdx].lutIgrSaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->spa==spa) 
				|| ( fc_db.flowTbl[entIdx].lutEgrDaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->spa==spa))
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if(    ( fc_db.flowTbl[entIdx].lutIgrSaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->spa==spa) 
						|| ( fc_db.flowTbl[entIdx].lutEgrDaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->spa==spa))
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;

					if(    ( fc_db.flowTbl[entIdx].lutIgrSaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->spa==spa) 
						|| ( fc_db.flowTbl[entIdx].lutEgrDaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->spa==spa))
					{
						ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
		}
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(    ( fc_db.flowTbl[entIdx].lutIgrSaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutIgrSaIdx]->spa==spa)
				|| ( fc_db.flowTbl[entIdx].lutEgrDaIdx!= SIGNED_INVALID && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx] && fc_db.lutTbl[fc_db.flowTbl[entIdx].lutEgrDaIdx]->spa==spa))
			{
				ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
			}
		}
	}

	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif

	return (RTK_FC_RET_OK);
}

/*
 * search flow table according entry index with corresponding flow spin lock.
*/
rtk_fc_ret_t rtk_fc_flow_delete_by_entryIdx(uint32 entIdx)
{
	int i, sw_flow_list_idx, bucketIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;

	//Check input parameters
	FC_PARAM_CHK((entIdx>=fc_db.flowSwTableSize), RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);


	if(entIdx < (fc_db.flowHashBuckets << fc_db.flowHashWayShift)) {
		bucketIdx = (entIdx >> fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(bucketIdx);

		ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		
		rtk_fc_flow_batchscan_group_unlock(bucketIdx);

	}
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	else if((entIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= entIdx))
	{
		// overflow hash
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	}
#endif

	else {
	

		for(i = 0; i < fc_db.flowHashBuckets; i++) {
			
			rtk_fc_flow_batchscan_group_lock(i);
			
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			// flush HW flow - TCAM
			if(rgpro_db.fbMode==FB_MODE_4K)
			{
				//search hw Tcam flow
				if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
				{
					list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
					{
						if (entIdx == pFlowTcamEntry->idx)
							ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
#endif

			// flush SW flow according to hash index
			RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(sw_flow_list_idx, i)
			{
				if(!list_empty(&fc_db.swFlow_hashListHead[sw_flow_list_idx]))
				{
					list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[sw_flow_list_idx], flow_list)
					{
						if (entIdx == pFlowEntry->idx)
							ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
					}
				}
			}
			rtk_fc_flow_batchscan_group_unlock(i);
		}
	}
	return (RTK_FC_RET_OK);
}



rtk_fc_ret_t rtk_fc_abstrSwFlow_BC_UUC_UMC_floodingDomain_delete(void)
{
	int i, j, hashIdx, entIdx;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
#endif


	//Check input parameters

	for(i = 0; i < fc_db.flowHashBuckets; i++) {
		hashIdx = (i<<fc_db.flowHashWayShift);
		
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//
		
		// flush HW flow
		for(j = 0; j < (1<<fc_db.flowHashWayShift); j++) {
			entIdx = (i<<fc_db.flowHashWayShift) + j;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(!fc_db.flowTbl[entIdx].pAbstrSwFlowEt)
				continue;

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
				continue;

			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);

		}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					entIdx = pFlowTcamEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(!fc_db.flowTbl[entIdx].pAbstrSwFlowEt)
						continue;
					
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;
					
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
						continue;

					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);

				}
			}
		}
#endif
		
		// flush SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(j, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[j]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[j], flow_list)
				{
					entIdx = pFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
						continue;
#else
					if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
						continue;
#endif
					if(!fc_db.flowTbl[entIdx].pAbstrSwFlowEt)
						continue;
					
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
						continue;
					
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
						continue;

					ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);
				}
			}
		}
		
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// flush HW flow - overflow hash
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	if(!list_empty(&fc_db.overFlowHash_inUseListHead))
	{
		list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
		{
			entIdx = pOverFlowEntry->idx;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[entIdx].candidateState == CANDIDATE_STATE_NONE)
				continue;
#else
			if(fc_db.flowTbl[entIdx].pFlowEntry->path1.valid==0)
				continue;
#endif
			if(!fc_db.flowTbl[entIdx].pAbstrSwFlowEt)
				continue;

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_STATIC_ENTRY))
				continue;

			if(FLOW_INFO_IS_SET(&fc_db.flowTbl[entIdx], FLOW_INFO_MC_ENTRY))
				continue;

			ASSERT_EQ_CONT(rtk_fc_flow_delete(entIdx), RTK_FC_RET_OK);

		}
	}
	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif


	return (RTK_FC_RET_OK);
}


rtk_fc_ret_t rtk_fc_abstrSwFlow_delete(int swFlowIdx)
{
	rtk_fc_tableFlow_t *pFlowTable;
	rt_flow_ops_data_t flow_ops_data;

	if(swFlowIdx < fc_db.flowHwTableSize)
	{
		WARNING("swFlowIdx(%d) < fc_db.flowHwTableSize(%d) Error",swFlowIdx, fc_db.flowHwTableSize);
		return RTK_FC_RET_ERR_INVALID_PARAM;
	}

	pFlowTable = &fc_db.flowTbl[swFlowIdx];

	//sw delete update to hw
	rtk_fc_abstrSwSyncToHw_del(swFlowIdx);

	//clear software 
	if(fc_db.flowTbl[swFlowIdx].protoCtrl == FLOW_PROTO_CTRL_LOOPBACK_ACC && fc_db.flowTbl[swFlowIdx].loopbackRevFlowIdx != SIGNED_INVALID && (fc_db.flowTbl[fc_db.flowTbl[swFlowIdx].loopbackRevFlowIdx].pFlowEntry->path1.valid!=0))
	{
		TABLE("Flow[%d]: Delete its loopback reverve Flow[%d]", swFlowIdx, fc_db.flowTbl[swFlowIdx].loopbackRevFlowIdx);
		rtk_fc_flow_delete(fc_db.flowTbl[swFlowIdx].loopbackRevFlowIdx);
	}

	if(fc_db.flow_callback_func.cbFlowDel != NULL) {
		memset(&(flow_ops_data.data_getFlowMib.swFlowCnt), 0, sizeof(flow_ops_data.data_getFlowMib.swFlowCnt));
		if(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SW_ONLY)
		{
			flow_ops_data.data_getFlowMib.index = swFlowIdx;
			RTK_FC_HELPER_MGR_SW_FLOW_MIB_GET(flow_ops_data.data_getFlowMib.index, &(flow_ops_data.data_getFlowMib.swFlowCnt));
				}

		fc_db.flow_callback_func.cbFlowDel(swFlowIdx, flow_ops_data.data_getFlowMib.swFlowCnt.ingress_packet_count, flow_ops_data.data_getFlowMib.swFlowCnt.ingress_byte_count);
	}

	if(FLOW_INFO_IS_SET(&fc_db.flowTbl[swFlowIdx], FLOW_INFO_MC_ENTRY))
		rtk_fc_igmp_mcExtraFlowIdxTbl_del(swFlowIdx);
	
	// initialize sw field of flow
	if(pFlowTable->cachedCt)
		RTK_FC_HELPER_PS_CT_NF_CT_PUT(&pFlowTable->cachedCt->ct_general);
	
	pFlowTable->cachedCt = NULL;
	//--------------- RESET: init value which is 0	   -------------------------------------------------------------------------------//
	memset((uint8 *)pFlowTable + offsetof(rtk_fc_tableFlow_t, cachedCt) , 0 , (sizeof(rtk_fc_tableFlow_t)- offsetof(rtk_fc_tableFlow_t, cachedCt) ) );
	//------------------------------------------------------------------------------------------------------------------------------//


	//----------------RESET: init value which is not 0 -------------------------------------------------------------------------------//
#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
	pFlowTable->srcDev = NULL;
	if(pFlowTable->dummyPkt) bzero(pFlowTable->dummyPkt, sizeof(rtk_fc_igrDummyData_t));
#endif
	if(pFlowTable->pAbstrSwFlowEt)
	{
		//free swFlowList
		rtk_fc_abstrSwFlowFree(pFlowTable->pAbstrSwFlowEt);
		pFlowTable->pAbstrSwFlowEt=NULL;
	}
	pFlowTable->lutIgrSaIdx = SIGNED_INVALID;
	pFlowTable->lutEgrDaIdx = SIGNED_INVALID;	
	//------------------------------------------------------------------------------------------------------------------------------//


	if(fc_db.shortcut_flow_count > 0)	// sw flow list
	{
		assert_ok(_rtk_fc_swFlowListDel(swFlowIdx));
	}

	RTK_FC_HELPER_MGR_SW_FLOW_MIB_CLEAR(swFlowIdx);

	TABLE("Delete swflow entry [%d]", swFlowIdx);

	return (RTK_FC_RET_OK);
}




#if	defined(CONFIG_FC_RTL9607C_SERIES)

static inline void _rtk_fc_special_fastFwd_nptv6_flow_delete(int flowIdx)
{
	//----------------------------------------------NPTv6 RELATED---------------------------------------------------
	if(fc_db.controlFuc.special_fast_forward_mode==1 &&
		fc_db.flowTbl[flowIdx].protoCtrl == FLOW_PROTO_CTRL_NPTV6_SFF &&
		fc_db.flowTbl[flowIdx].nptv6_info_index!=0 && 
		fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].isSet!=0)
	{
		int isInner = 0;
		
		if(flowIdx == fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].inner_flow_index)
			isInner = 1;

		TABLE("[NPTv6][nptv6_flow_info:%d]Delete %s flow, and will delete %s flow [%d] right away", fc_db.flowTbl[flowIdx].nptv6_info_index,
		                   																			isInner?"inner":"Outer", 
																									isInner?"Outer":"Inner",
																									isInner?(fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].outer_flow_index):(fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].inner_flow_index));

		fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].isSet = 0;
		
		if(fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].sw_flow_index!=0){
			rtk_fc_flow_delete(fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].sw_flow_index);
			fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].sw_flow_index = 0;
		}
		
		if(isInner) // Now flow index is inner, so delete outer right away
			rtk_fc_flow_delete(fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].outer_flow_index);
		else // Now flow index is outer, so delete inner right away
			rtk_fc_flow_delete(fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].inner_flow_index);
		fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].outer_flow_index = 0;
		fc_db.nptv6_flow_info[fc_db.flowTbl[flowIdx].nptv6_info_index].inner_flow_index = 0;
	
	}
	//----------------------------------------------END OF NPTv6 RELATED---------------------------------------------------

}
#endif


// clear valid bit but keep flow entry content
rtk_fc_ret_t rtk_fc_flow_delete(int flowIdx)
{
	rtk_fc_tableFlow_t *pFlowTable;
#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac
	int indMacIdx = FAIL;
#endif
	rt_flow_ops_data_t flow_ops_data;
	int i, ret = RTK_FC_RET_OK;
#if defined(CONFIG_FC_RTL8277C_SERIES)	
	rtk_fc_ct_hash_info_t *pTmp_ct_hash_list, *pTmp_next_ct_hash_list;
	uint32 ct_hash = 0;
#endif
	if((flowIdx<0) || (flowIdx>=fc_db.flowSwTableSize))
	{
		WARNING("[Invalid parameter] flowIdx=%d", flowIdx);
		return (RTK_FC_RET_ERR_INVALID_PARAM);
	}

	 pFlowTable = &fc_db.flowTbl[flowIdx];
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(pFlowTable->candidateState == CANDIDATE_STATE_NONE)
		return (RTK_FC_RET_OK);
#else
	if(pFlowTable->pFlowEntry.path1.valid == 0)
		return (RTK_FC_RET_OK);
#endif

	for(i = 0 ; i < FLOWDELTRACE_MAX ; i++)
	{
		if(fc_db.flow_del_trace_index[i] == SIGNED_INVALID)
			break;
		if(fc_db.flow_del_trace_index[i] == flowIdx)
		{
			WARNING("flow delete Tracking flow Idx = %d", flowIdx);
			WARNING("===============================================================");
			_rtk_fc_dump_stack();
			WARNING("===============================================================");
		}
	}

	/* all sw/hw pAbstrSwFlowEt->swFlowIdx is same for the flow ,just delete pAbstrSwFlowEt->swFlowIdx*/
	if (pFlowTable->pAbstrSwFlowEt)
	{
		//delete hardware flow and need sync hwflow to software struct:
		//	maybe just want to delete specific hwIdx(action) but we delete all of swFlow ?
		return rtk_fc_abstrSwFlow_delete(pFlowTable->pAbstrSwFlowEt->swFlowIdx);
	}
#if defined(CONFIG_FC_RTL8277C_SERIES)
	
	
	if(pFlowTable->cachedCt != NULL)
	{
		ct_hash = (((uint32)(uintptr_t)pFlowTable->cachedCt) >> 12)&0xff; // should be 0~255
		DEBUG("ct_hash = %d",ct_hash);
		if(!list_empty(&fc_db.ct_hash_info_ListHead[ct_hash]))
		{
			list_for_each_entry_safe(pTmp_ct_hash_list, pTmp_next_ct_hash_list, &fc_db.ct_hash_info_ListHead[ct_hash], ct_hash_list)	//just return the first entry right behind of head
			{
				if(pTmp_ct_hash_list->ct == pFlowTable->cachedCt)
				{
					DEBUG("Find!!");
					list_del(&pTmp_ct_hash_list->ct_hash_list);
					RTK_FC_HELPER_FC_KFREE(pTmp_ct_hash_list, sizeof(rtk_fc_ct_hash_info_t));
					break;
				}
			}
		}
	}
	
#endif

	if( fc_db.flowTbl[flowIdx].protoCtrl == FLOW_PROTO_CTRL_LOOPBACK_ACC && fc_db.flowTbl[flowIdx].loopbackRevFlowIdx != SIGNED_INVALID && (fc_db.flowTbl[fc_db.flowTbl[flowIdx].loopbackRevFlowIdx].pFlowEntry->path1.valid!=0))
	{
		TABLE("Flow[%d]: Delete its loopback reverve Flow[%d]", flowIdx, fc_db.flowTbl[flowIdx].loopbackRevFlowIdx);
		rtk_fc_flow_delete(fc_db.flowTbl[flowIdx].loopbackRevFlowIdx);
	}

#if !defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(fc_db.flowTbl[flowIdx].pFlowEntry->path1.valid==0)
	{
		WARNING("[Invalid parameter] flowIdx[%d] is invalid", flowIdx);
		return (RTK_FC_RET_ERR_FLOW_NOT_FOUND);
	}
#endif


	if(fc_db.flow_callback_func.cbFlowDel != NULL) {
		memset(&(flow_ops_data.data_getFlowMib.swFlowCnt), 0, sizeof(flow_ops_data.data_getFlowMib.swFlowCnt));
		if(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SW_ONLY)
		{
			flow_ops_data.data_getFlowMib.index = flowIdx;
			RTK_FC_HELPER_MGR_SW_FLOW_MIB_GET(flow_ops_data.data_getFlowMib.index, &(flow_ops_data.data_getFlowMib.swFlowCnt));
                }

		fc_db.flow_callback_func.cbFlowDel(flowIdx, flow_ops_data.data_getFlowMib.swFlowCnt.ingress_packet_count, flow_ops_data.data_getFlowMib.swFlowCnt.ingress_byte_count);
	}

	//decrease extidx reference count
	if( ((pFlowTable->pFlowEntry->path1.in_path == FB_PATH_12) || (pFlowTable->pFlowEntry->path1.in_path == FB_PATH_34))
		&& (pFlowTable->pFlowEntry->path1.out_ext_portmask_idx!=0) )
	{
		ASSERT_EQ(RTK_RG_ASIC_EXTPORTMASKTABLE_DEL(pFlowTable->pFlowEntry->path1.out_ext_portmask_idx),RTK_FC_RET_OK);
	}

#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac
	// decrease indmac reference count
	if((((pFlowTable->pFlowEntry->path1.in_path == FB_PATH_12) || (pFlowTable->pFlowEntry->path1.in_path == FB_PATH_34))
			&& (pFlowTable->pFlowEntry->path1.in_multiple_act != 1)
			&& (pFlowTable->pFlowEntry->path1.out_dmac_trans || pFlowTable->pFlowEntry->path1.out_uc_lut_lookup))		// path 1, 3
		|| (pFlowTable->pFlowEntry->path1.in_path == FB_PATH_5)															// path 5
		)
	{
		indMacIdx = pFlowTable->pFlowEntry->path1.out_dmac_idx;
		if(fc_db.indMacTbl[indMacIdx].valid)
			fc_db.indMacTbl[indMacIdx].indMacRefCount--;
		else{
			FIXME("indMacIdx was wrong?");
		}
	}
#endif
	// initialize sw field of flow
	if(pFlowTable->cachedCt){
		nf_conntrack_put(&pFlowTable->cachedCt->ct_general);
		pFlowTable->cachedCt = NULL;
	}
	
	if(pFlowTable->protoCtrl & FLOW_PROTO_CTRL_L2DUAL)
	{
		ret = _rtk_fc_l2Dual_flow_del(pFlowTable, flowIdx);
		if(ret == 1)
		return RTK_FC_RET_OK;
	}
#if defined(CONFIG_FC_RTL9607C_SERIES)
	_rtk_fc_special_fastFwd_nptv6_flow_delete(flowIdx);
	
#endif
 	
	if((pFlowTable->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT) && pFlowTable->dual_pt_flowMapTbl_idx != 0)
	{
		bzero(&fc_db.dual_pt_flowMapTbl[pFlowTable->dual_pt_flowMapTbl_idx], sizeof(fc_db.dual_pt_flowMapTbl[pFlowTable->dual_pt_flowMapTbl_idx]));
	}

	// Delete IPV6 NAT mapping table : decrease reference count
	if( (pFlowTable->protoCtrl == FLOW_PROTO_CTRL_V6NAT) && (pFlowTable->pFlowEntry->path1.in_path == FB_PATH_5) && 
		 pFlowTable->ipv6_nat_indirect_mapping_index!=0
	)
	{
		if(atomic_read(&fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].refCount)>0)
			atomic_dec(&fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].refCount);
#if defined(CONFIG_FC_RTL8277C_SERIES) 
		if(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].isNPTv6)
			aal_hash_npt6_prefix_addr_entry_del(0, fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].prefix_idx);
#endif
		
	}
	// Delete MAPT mapping table : decrease reference count
	else if( (pFlowTable->protoCtrl == FLOW_PROTO_CTRL_MAPT_ACC) && (pFlowTable->pFlowEntry->path1.in_path == FB_PATH_5) && 
		 pFlowTable->maptInfo.sip_indirect_mapping_index!=0 && pFlowTable->maptInfo.dip_indirect_mapping_index!=0
	)
	{
		if(atomic_read(&fc_db.ipv6_mapt_mappingTbl[pFlowTable->maptInfo.sip_indirect_mapping_index].refCount)>0)
			atomic_dec(&fc_db.ipv6_mapt_mappingTbl[pFlowTable->maptInfo.sip_indirect_mapping_index].refCount);
		if(atomic_read(&fc_db.ipv6_mapt_mappingTbl[pFlowTable->maptInfo.dip_indirect_mapping_index].refCount)>0)
			atomic_dec(&fc_db.ipv6_mapt_mappingTbl[pFlowTable->maptInfo.dip_indirect_mapping_index].refCount);
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if(pFlowTable->pFlowEntry->path5.out_fmr_idx_act && pFlowTable->pFlowEntry->path5.out_fmr_idx!=L3PE_DUAL_FMR_TBL_ENTRY_MAX)
			assert_ok(rtk_8277c_l3_pe_dual_fmr_del(pFlowTable->pFlowEntry->path5.out_fmr_idx));
#endif
	}
	else if(pFlowTable->pFlowEntry->path1.in_path == FB_PATH_6)
	{
		int i;
		for(i = 0; i < RTK_FC_TABLESIZE_INTF; i++)
		{
			if(fc_db.netifHwTbl[i].outerHdrFlowIdx == flowIdx && fc_db.netifHwTbl[i].dualType == RTK_FC_DUALTYPE_6RD)
			{
				fc_db.netifHwTbl[i].outerHdrFlowIdx = SIGNED_INVALID;
				fc_db.netifHwTbl[i].outerHdrExtratagIdx = 0;
			}
		}
	}
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
	if(fc_db.flowTbl[flowIdx].dmaAftFibCtrlEn)
		_rtk_fc_dmaAftAction_del(fc_db.flowTbl[flowIdx].dmaAftFibIdx);
	fc_db.flowTbl[flowIdx].dmaAftFibCtrlEn = 0;
	fc_db.flowTbl[flowIdx].dmaAftFibIdx = 0;
#endif

	
	//--------------- RESET: init value which is 0     -------------------------------------------------------------------------------//
	memset((uint8 *)pFlowTable + offsetof(rtk_fc_tableFlow_t, cachedCt) , 0 , (sizeof(rtk_fc_tableFlow_t)- offsetof(rtk_fc_tableFlow_t, cachedCt) ) );
	//------------------------------------------------------------------------------------------------------------------------------//


	//----------------RESET: init value which is not 0 -------------------------------------------------------------------------------//
#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
	pFlowTable->srcDev = NULL;
	if(pFlowTable->dummyPkt) bzero(pFlowTable->dummyPkt, sizeof(rtk_fc_igrDummyData_t));
#endif
	if(pFlowTable->pAbstrSwFlowEt)
	{
		rtk_fc_abstrSwFlowFree(pFlowTable->pAbstrSwFlowEt);
		pFlowTable->pAbstrSwFlowEt=NULL;
	}

	//------------------------------------------------------------------------------------------------------------------------------//
	

	if(flowIdx < fc_db.flowHwTableSize)
	{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		fc_db.fb_hwFlow_validBitsArray[(flowIdx >> 5)] &= ~(0x1 << (flowIdx&0x1f));
		// flow Tcam list
		if(rgpro_db.fbMode==FB_MODE_4K && RTK_FC_TABLESIZE_FLOWSRAM<=flowIdx)
		{
			assert_ok(_rtk_fc_flowTcamListDel(flowIdx));
		}
#elif defined(CONFIG_FC_RTL8277C_SERIES)
#if RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if(flowIdx >= RTK_FC_TABLESIZE_HASH_FLOW)
			assert_ok(_rtk_fc_overFlowHashListDel(flowIdx));
#endif
		if (rtk_fc_is_mape_upstream_flow5(flowIdx) == TRUE)
			rtk_fc_mape_dst6_refcnt_put(flowIdx);
#endif
	}
	else if(fc_db.shortcut_flow_count > 0)	// sw flow list
	{
		assert_ok(_rtk_fc_swFlowListDel(flowIdx));
		
		if (rtk_fc_is_mape_upstream_flow5(flowIdx) == TRUE)
			rtk_fc_mape_dst6_refcnt_put(flowIdx);
	}

#if defined(CONFIG_RTK_SOC_RTL8198D)
	rtk_fc_flow_limit_count_update((flowIdx < fc_db.flowHwTableSize ? FALSE : TRUE), pFlowTable->pFlowEntry->path1.in_path, FALSE);
#endif

	ASSERT_EQ(RTK_RG_ASIC_FLOWPATH_DEL(flowIdx), RTK_FC_RET_OK);

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_RTL8277C_SERIES)
	if(flowIdx <= fc_db.flowHwTableSize)
		fc_db.g3_mHashTbl_validBitsArray[(flowIdx >> 5)] &= ~(0x1 << (flowIdx&0x1f));
#else
	if(fc_db.flowTbl[flowIdx].mainHashIdx != G3_FLOWIDX_INVALID)
		fc_db.g3_mHashTbl_validBitsArray[(fc_db.flowTbl[flowIdx].mainHashIdx >> 5)] &= ~(0x1 << (fc_db.flowTbl[flowIdx].mainHashIdx&0x1f));
	// reset mainHashIdx after delete entry
	pFlowTable->mainHashIdx = G3_FLOWIDX_INVALID;
#endif
	pFlowTable->ingressSaHostPolIdx = SIGNED_INVALID;
	pFlowTable->egressDaHostPolIdx = SIGNED_INVALID;
#endif


	RTK_FC_HELPER_MGR_SW_FLOW_MIB_CLEAR(flowIdx);

	TABLE("Delete flow entry [%d]", flowIdx);

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_flow_invalid_hw(int flowIdx)
{
	rtk_fc_tableFlow_t *pFlowTable;

	if((flowIdx<0) || (flowIdx>=fc_db.flowSwTableSize))
	{
		WARNING("[Invalid parameter] flowIdx=%d", flowIdx);
		return (RTK_FC_RET_ERR_INVALID_PARAM);
	}
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(fc_db.flowTbl[flowIdx].candidateState==CANDIDATE_STATE_NONE)
#else
	if(!fc_db.flowTbl[flowIdx].pFlowEntry->path1.valid)
#endif
	{
		// Due to the global lock range, flow may be delete between shortcut hit and rtk_fc_flow_invalid_hw(). Check if flow valid first.
		TRACE("flow may be deleted. Do nothing here.");
		return (RTK_FC_RET_OK);
	}

	pFlowTable = &fc_db.flowTbl[flowIdx];

#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)

	if(flowIdx>=fc_db.flowHwTableSize) {
		DEBUG("flowIdx %d is software only", flowIdx);
		return (RTK_FC_RET_OK);
	}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	if(pFlowTable->mainHashIdx== G3_FLOWIDX_INVALID) {
		DEBUG("flowIdx %d is software only", flowIdx);
		return (RTK_FC_RET_OK);
	}
#endif


	pFlowTable->pFlowEntry->path1.valid = FALSE;

	ASSERT_EQ(RTK_RG_ASIC_FLOWPATH_INVALID(flowIdx), RTK_FC_RET_OK);

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_RTL8277C_SERIES)
	fc_db.g3_mHashTbl_validBitsArray[(flowIdx >> 5)] &= ~(0x1 << (flowIdx&0x1f));
#else
	// reset mainHashIdx after delete entry
	fc_db.g3_mHashTbl_validBitsArray[(pFlowTable->mainHashIdx >> 5)] &= ~(0x1 << (pFlowTable->mainHashIdx&0x1f));
	pFlowTable->mainHashIdx = G3_FLOWIDX_INVALID;
#endif
#endif
	
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	pFlowTable->candidateState= CANDIDATE_STATE_AGING;
#endif

	TABLE("Invalid flow entry [%d]", flowIdx);

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_flow_reverse_add(uint32 *pFlowIdx, uint32 flowHashIdx, void *pPathData, struct rt_nfconn *rtct,
									rtk_fc_igrExtraInfo_t *pExtraInfo, uint8 isMulticast, rtk_fc_pmap_t ingressPort, uint8 addSwOnly, uint8 staticEntry,
									rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	uint32 reverse_flowidx, reverse_hashidx;
	rtk_fc_tableFlowEntry_t reverse_flow;
	rtk_fc_igrExtraInfo_t reverse_extraInfo;
	rtk_fc_g3IgrExtraInfo_t reverse_g3IgrExtraInfo;
	rtk_rg_asic_path5_entry_t *ori_flow, *pFlowPath5;
	rtk_fc_flow_direction_t direction = RTK_FC_FLOW_DIRECTION_UPSTREAM;
	bool isNAPT = 0;
	int idx=0;
	rtk_fc_pmap_t reverse_igrport;

	ori_flow = (rtk_rg_asic_path5_entry_t *)pPathData;
	pFlowPath5 = (rtk_rg_asic_path5_entry_t *)&reverse_flow;

	if(ori_flow == NULL) {
		WARNING("original flow is not ready");
		return RTK_FC_RET_ERR_NULL_POINTER;
	}
	direction = (ori_flow->out_l4_direction==1) ? RTK_FC_FLOW_DIRECTION_UPSTREAM : RTK_FC_FLOW_DIRECTION_DOWNSTREAM;
	isNAPT = ori_flow->out_l4_act;

	if((direction==RTK_FC_FLOW_DIRECTION_DOWNSTREAM)) {
		TRACE("adding reverse flow by downstream traffic is not support");
		return RTK_FC_RET_OK;
	}

#if defined(CONFIG_RTK_SOC_RTL8198D)
	// addSwOnly may be changed here
	if (rtk_fc_flow_limit_check((bool *)&addSwOnly, ori_flow->in_path) != SUCCESS) {
		return FAIL;
	}
#endif

	TRACE("prepare reverse flow");

	{
		// based on current flow (ori_flow) to set reversed flow (pPathData)
		memcpy(pFlowPath5, ori_flow, sizeof(rtk_rg_asic_path5_entry_t));
		//pFlowPath5->valid = TRUE;
		//pFlowPath5->in_path = FB_PATH_5;
		//pFlowPath5->in_ipv4_or_ipv6 = ori_flow->in_ipv4_or_ipv6;
		if(isNAPT) {
			if(direction==RTK_FC_FLOW_DIRECTION_UPSTREAM) {
				// get downstream setting.
				pFlowPath5->in_src_ipv4_addr = ori_flow->in_dst_ipv4_addr;
				pFlowPath5->in_dst_ipv4_addr = 	fc_db.netifHwTbl[ori_flow->out_intf_idx].intf.gateway_ipv4_addr;

				pFlowPath5->out_dst_ipv4_addr = ori_flow->in_src_ipv4_addr;

				pFlowPath5->in_l4_src_port = ori_flow->in_l4_dst_port;
				pFlowPath5->in_l4_dst_port = ori_flow->out_l4_port;

				pFlowPath5->out_l4_port = ori_flow->in_l4_src_port;

				
				pFlowPath5->out_l4_direction = 0;
		
			}
		}else{
			// get reversed setting.
			pFlowPath5->in_src_ipv4_addr = ori_flow->in_dst_ipv4_addr;
			pFlowPath5->in_dst_ipv4_addr = ori_flow->in_src_ipv4_addr;
		}

		//pFlowPath5->in_l4proto = l4Protocol;

		pFlowPath5->in_intf_idx = ori_flow->out_intf_idx;
		
		pFlowPath5->in_stagif = (ori_flow->out_svlan_id!=0) ? TRUE : FALSE;
		pFlowPath5->in_ctagif = (ori_flow->out_cvlan_id!=0) ? TRUE : FALSE;
		pFlowPath5->in_pppoeif = (fc_db.netifHwTbl[ori_flow->out_intf_idx].intf.out_pppoe_act == FB_NETIFPPPOE_ACT_ADD) ? TRUE : FALSE;
		pFlowPath5->in_tos_check = fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS];
		pFlowPath5->in_tos = 0;					// not sure
		pFlowPath5->in_cvlan_pri = ori_flow->out_cpri;	//not sure

		//-------------------------egress action-------------------------

		//pFlowPath5->out_l4_act = isNAPT;														// Routing: 0, NAPT: 1

		pFlowPath5->out_intf_idx = ori_flow->in_intf_idx;
#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac, pFlowPath5->out_dmac_idx is meaningless
		ASSERT_EQ(rtk_fc_indMac_idx_get(pExtraInfo->lutIgrSaIdx, &idx), RTK_FC_RET_OK);
#endif
		pFlowPath5->out_dmac_idx = idx;
		//svlan
		if(ori_flow->in_stagif) {
			pFlowPath5->out_egress_svid_act = TRUE;
			pFlowPath5->out_svlan_id = pG3IgrExtraInfo->svlan_id;
			pFlowPath5->out_stag_format_act = TRUE;
			pFlowPath5->out_svid_format_act = TRUE;
			pFlowPath5->out_spri_format_act = TRUE;
			pFlowPath5->out_spri = 0;	//not sure
		}else{
			
			pFlowPath5->out_egress_svid_act = TRUE;
			pFlowPath5->out_stag_format_act = TRUE;
			pFlowPath5->out_svid_format_act = FALSE;
			pFlowPath5->out_spri_format_act = FALSE;
		}
		//cvlan
		if(ori_flow->in_stagif) {
			pFlowPath5->out_egress_cvid_act = TRUE;
			pFlowPath5->out_ctag_format_act = TRUE;
			pFlowPath5->out_cvlan_id =  pG3IgrExtraInfo->cvlan_id;
			pFlowPath5->out_cvid_format_act = TRUE;
			pFlowPath5->out_cpri_format_act = TRUE;
			pFlowPath5->out_cpri = 0;	//not sure
		}else {
			pFlowPath5->out_egress_cvid_act = TRUE;
			pFlowPath5->out_ctag_format_act = TRUE;
			pFlowPath5->out_cvid_format_act = FALSE;
			pFlowPath5->out_cpri_format_act = FALSE;
		}

		//other
		//pFlowPath5->out_user_pri_act = TRUE;
		//pFlowPath5->out_user_priority = pPktHdr->remarkDec.outputQid;

		//pFlowPath5->out_dscp_act = TRUE;
		//pFlowPath5->out_dscp = ((isIpv6 ? ((pPktHdr->ip6h->priority<<4) | (pPktHdr->ip6h->flow_lbl[0]>>4)) : pPktHdr->iph->tos)>>2) & 0x3f;
#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac
		DEBUG("Egress dmac indirect index: %d\n", pFlowPath5->out_dmac_idx);

		if(fc_db.lutTbl[fc_db.indMacTbl[pFlowPath5->out_dmac_idx].indMac.l2_idx]==NULL) {
			WARNING("L2 indmac index %d -> L2 %d is not exist?", pFlowPath5->out_dmac_idx, fc_db.indMacTbl[pFlowPath5->out_dmac_idx].indMac.l2_idx);
			return RTK_FC_RET_ERR_NULL_POINTER;
		}

		if(fc_db.lutTbl[fc_db.indMacTbl[pFlowPath5->out_dmac_idx].indMac.l2_idx]->spa == RTK_FC_MAC_PORT_PON){
			//pFlowPath5->out_stream_idx_act = pPktHdr->remarkDec.streamId_en;
			//pFlowPath5->out_stream_idx = pPktHdr->remarkDec.streamId;
			TRACE("could not make streamidx decision!!!!!!!!!");
		}
#endif
		//pFlowPath5->out_share_meter_act = pPktHdr->remarkDec.meterIdx_en;
		//pFlowPath5->out_share_meter_idx = pPktHdr->remarkDec.meterIdx;

		//pFlowPath5->out_flow_counter_act = pPktHdr->remarkDec.mibIdx_en;
		//pFlowPath5->out_flow_counter_idx = pPktHdr->remarkDec.mibIdx;

		//pFlowPath5->out_extra_tag_index = tunnelExtraTagIdx;

		//pFlowPath5->out_egress_port_to_vid_act = FALSE;
		//pFlowPath5->out_drop = 0;
		//pFlowPath5->lock = (pFlowPath5->out_share_meter_act) ? TRUE: FALSE;


	}

	reverse_igrport.macPortIdx = fc_db.lutTbl[pExtraInfo->lutEgrDaIdx]->spa;
	reverse_igrport.macExtPortIdx = fc_db.lutTbl[pExtraInfo->lutEgrDaIdx]->extspa;
	
	bzero(&reverse_extraInfo, sizeof(reverse_extraInfo));	
	reverse_extraInfo.lutIgrSaIdx = pExtraInfo->lutEgrDaIdx;
	reverse_extraInfo.lutEgrDaIdx = (fc_db.netifHwTbl[ori_flow->out_intf_idx].lutIdx);
#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
	if(fc_db.controlFuc.flow_sessionAutoExtend){				// dummy packet is not support for dual header
		// not support
		reverse_extraInfo.dummyPkt = NULL;
	}
#endif
		
	_rtk_fc_g3IgrExtraInfo_init(&reverse_g3IgrExtraInfo);
	reverse_g3IgrExtraInfo.lutIgrSaIdx = reverse_extraInfo.lutIgrSaIdx;
	reverse_g3IgrExtraInfo.svlan_id = ori_flow->out_svlan_id;
	reverse_g3IgrExtraInfo.cvlan_id = ori_flow->out_cvlan_id;
	reverse_g3IgrExtraInfo.ipv6_Saddr.s6_addr32[0] = pFlowPath5->in_src_ipv4_addr;
	reverse_g3IgrExtraInfo.ipv6_Daddr.s6_addr32[0] = pFlowPath5->in_dst_ipv4_addr;
	reverse_g3IgrExtraInfo.direction = direction;
	if(pFlowPath5->in_pppoeif){
		reverse_g3IgrExtraInfo.pppoe_session_id = fc_db.netifHwTbl[ori_flow->out_intf_idx].intf.out_pppoe_sid;
	}

	if(!fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI])
		reverse_g3IgrExtraInfo.svlan_pri = ori_flow->out_spri;

	if(!fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI])
	{
		reverse_g3IgrExtraInfo.igr_svlan_dei = pG3IgrExtraInfo->egr_svlan_dei;
		reverse_g3IgrExtraInfo.igr_cvlan_cfi = pG3IgrExtraInfo->egr_cvlan_cfi;
	}
	reverse_g3IgrExtraInfo.egr_svlan_dei = pG3IgrExtraInfo->igr_svlan_dei;
	reverse_g3IgrExtraInfo.egr_cvlan_cfi = pG3IgrExtraInfo->igr_cvlan_cfi;
	reverse_g3IgrExtraInfo.igr_svlan_tpid_sel = pG3IgrExtraInfo->egr_svlan_tpid_sel;
	reverse_g3IgrExtraInfo.egr_svlan_tpid_sel = pG3IgrExtraInfo->igr_svlan_tpid_sel;
	reverse_g3IgrExtraInfo.pon_stream_id = pFlowPath5->out_stream_idx_act?pFlowPath5->out_stream_idx:0;

#if defined(CONFIG_FC_RTL8277C_SERIES)
	{
		rtk_8277c_asic_flow_hash_crc_t flow_hash_crc;
		if(_rtk_fc_flow_hashIndex(reverse_flow, pG3IgrExtraInfo, &flow_hash_crc) != RTK_FC_RET_OK)
		{
			WARNING("Get flow CRC by flowPathEntry failed");
			return RT_ERR_RG_FAILED;
		}
		reverse_hashidx = flow_hash_crc.crc16;
		pG3IgrExtraInfo->crc16 = flow_hash_crc.crc16;
		pG3IgrExtraInfo->crc32 = flow_hash_crc.crc32;
	}
#else
	reverse_hashidx = _rtk_fc_flow_hashIndex(reverse_flow, ori_flow->out_svlan_id, ori_flow->out_cvlan_id, FALSE);
#endif


	ret = rtk_fc_flow_add(&reverse_flowidx, reverse_hashidx, pFlowPath5, rtct,
						&reverse_extraInfo, isMulticast, reverse_igrport, addSwOnly, staticEntry, &reverse_g3IgrExtraInfo, NULL);




	return ret;
}

rtk_fc_ret_t rtk_fc_flow_add(uint32 *pFlowIdx, uint32 flowHashIdx, void *pPathData, struct rt_nfconn *rtct,
									rtk_fc_igrExtraInfo_t *pExtraInfo, uint8 isMulticast, rtk_fc_pmap_t ingressPort, uint8 addSwOnly, uint8 staticEntry,
									rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_ret_t ret;
	rtk_rg_asic_path1_entry_t *pFlow = pPathData;
	int indMacIdx = FAIL;
	uint8 notTcam=FALSE, addHwOnly=FALSE;
	uint8 forceGet = FALSE;
	struct nf_conn *ct = rtct?rtct->ct:NULL;
	uint32 ctMark = rtct?rtct->mark:0;
	uint32 theSamePtnFlowIdx = FAIL;
	uint8 isHitSwFwdedAclTrapPri = (pPktHdr)?pPktHdr->isHitSwFwdedAclTrapPri:0;
#if defined(CONFIG_FC_RTL8277C_SERIES)
	uint32 baseHwFlowIdx = (flowHashIdx & fc_db.flowEntIdxMask) / (RTK_FC_TABLESIZE_HASH_FLOW_MAX/RTK_FC_TABLESIZE_HASH_FLOW);
#else
	uint32 baseHwFlowIdx = flowHashIdx;
#endif


	if(pG3IgrExtraInfo)
		pG3IgrExtraInfo->isHitSwFwdedAclTrapPri = isHitSwFwdedAclTrapPri;
		
	//20170811LUKE: force add flow to sw only if swflow_only is set.
	if(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_SW_ONLY && pFlow->in_path != FB_PATH_6) addSwOnly=TRUE;
	if(pPktHdr && pPktHdr->isHitSwFwdedAclTrapPri) addSwOnly=TRUE;

	if(fc_db.flowStatistic && !addSwOnly)
	{
		uint32 hash, collision=TRUE, i;

		hash = baseHwFlowIdx>>fc_db.flowHashWayShift;
		if(!(hash<fc_db.flowHashBuckets))
			WARNING("Hash index[%d] is out of range(0 ~ %d).", hash, fc_db.flowHashBuckets);
		else
		{
			fc_db.flowHashCount[hash]++;

			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
				if(fc_db.flowTbl[baseHwFlowIdx+i].candidateState==CANDIDATE_STATE_NONE)
#else
				if(fc_db.flowTbl[baseHwFlowIdx+i].pFlowEntry->path1.valid==0)
#endif
				{
					collision = FALSE;
					break;
				}
			}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			if(rgpro_db.fbMode==FB_MODE_4K && collision)
			{
				if(!list_empty(&fc_db.flowTcam_freeListHead))
					collision = FALSE;
			}
#elif defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
			if(!list_empty(&fc_db.overFlowHash_freeListHead))
				collision = FALSE;
#endif
			if(collision){
				if(!_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[baseHwFlowIdx], pPathData, pG3IgrExtraInfo, isMulticast))
				{
					fc_db.flowHashHwCollisionCount[hash]++;
					FIXME("collision - flow hash index %d", baseHwFlowIdx);
					rtk_fc_dump_collisionFlows(fc_db.flowTbl[baseHwFlowIdx].pFlowEntry, pPathData);
				}
			}
		}

	}

	if((pFlow->in_path==FB_PATH_6)
		|| (pFlow->in_path==FB_PATH_34 && isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_SKIP_DA]==DISABLED))
	{
		notTcam = TRUE;
	}

	if(!addSwOnly)
	{
		if(pFlow->lock==TRUE)		//flows for multicast path or enabing meter action
		{
			addHwOnly = TRUE;
		}
	}

	if(isMulticast)
	{
		forceGet = TRUE;
	}

	ret = _rtk_fc_flow_freeEntry_get(pFlowIdx, flowHashIdx, *(rtk_fc_tableFlowEntry_t *)pPathData, isMulticast, notTcam, addHwOnly, addSwOnly, forceGet, pG3IgrExtraInfo, isHitSwFwdedAclTrapPri);
	if(ret==RTK_FC_RET_ERR_FLOW_LRU)
	{
		if(unlikely(fc_db.fwdStatistic))
		{
			atomic_inc(&fc_db.statistic.perPortCnt_FlowLRU[ingressPort.macPortIdx]);
		}

		if (rtk_fc_is_mape_upstream_flow5(*pFlowIdx) == TRUE){
			rtk_fc_mape_dst6_refcnt_put(*pFlowIdx);		
		}	
	}
	else if(ret==RTK_FC_RET_ERR_ENTRY_EXIST)
	{
		TRACE("bypass flow-adding operation");
			
		if( (pFlow->in_path == FB_PATH_5) && fc_db.controlFuc.flow_delay_mode == RTK_FC_KERNEL_DELEY_MODE )
		{	
			TRACE("update flow streamId_en:%u streamId:%u outputQid:%u", pPktHdr->remarkDec.streamId_en, pPktHdr->remarkDec.streamId, pPktHdr->remarkDec.outputQid);
			fc_db.flowTbl[*pFlowIdx].pFlowEntry->path5.out_stream_idx_act = pPktHdr->remarkDec.streamId_en;
			fc_db.flowTbl[*pFlowIdx].pFlowEntry->path5.out_stream_idx = pPktHdr->remarkDec.streamId;
	
			if(pPktHdr->remarkDec.outputQid)
				fc_db.flowTbl[*pFlowIdx].pFlowEntry->path5.out_user_pri_act = TRUE;	
			else
				fc_db.flowTbl[*pFlowIdx].pFlowEntry->path5.out_user_pri_act = FALSE;
			
			fc_db.flowTbl[*pFlowIdx].pFlowEntry->path5.out_user_priority = pPktHdr->remarkDec.outputQid;	
		}
		return (RTK_FC_RET_OK);
	}
	else if(ret!=RTK_FC_RET_OK)
	{
		return ret;
	}
	if((((pFlow->in_path == FB_PATH_12) || (pFlow->in_path == FB_PATH_34)) && (pFlow->in_multiple_act != 1) && (pFlow->out_dmac_trans || pFlow->out_uc_lut_lookup))		// path 1, 3
		|| (pFlow->in_path == FB_PATH_5)											// path 5
		)
	{
		indMacIdx = pFlow->out_dmac_idx;
	}
		
#if defined(CONFIG_FC_RTL8277C_SERIES)
	// init flow cache mib
	fc_db.flowTbl[*pFlowIdx].flow_cache_mib_en 	= pPktHdr->remarkDec.flow_cache_mib_en;
	fc_db.flowTbl[*pFlowIdx].flow_cache_mib_idx = SIGNED_INVALID;
#endif

	ret = RTK_RG_ASIC_FLOWPATH_SET(pFlowIdx, pPathData, pG3IgrExtraInfo, addSwOnly);
	if(ret==RTK_FC_RET_OK)
		ret = _rtk_fc_flow_swField_set(*pFlowIdx, flowHashIdx, ct, pExtraInfo, indMacIdx, addSwOnly, staticEntry,isMulticast, pG3IgrExtraInfo, pPktHdr);
	if(ret==RTK_FC_RET_OK){
#if defined(CONFIG_RTK_SOC_RTL8198D)
		rtk_fc_flow_limit_count_update((*pFlowIdx < fc_db.flowHwTableSize ? FALSE : TRUE), pFlow->in_path, TRUE);
#endif

		TABLE("Add %s flow entry [%d], ct[%p]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, ct);

		if(_rtk_fc_flow_isTheSamePatternExist_get(*pFlowIdx, flowHashIdx, isMulticast, &theSamePtnFlowIdx))
		{
			//find the same pattern flow
			TRACE("The same pattern flow exists (flow[%d].isHitSwFwdedAclTrapPri: %d, flow[%d].isHitSwFwdedAclTrapPri: %d)", 
											theSamePtnFlowIdx, FLOW_INFO_IS_SET(&fc_db.flowTbl[theSamePtnFlowIdx], FLOW_INFO_ACL_PRI_FWD), 
											*pFlowIdx, FLOW_INFO_IS_SET(&fc_db.flowTbl[*pFlowIdx], FLOW_INFO_ACL_PRI_FWD));
			FLOW_INFO_SET(&fc_db.flowTbl[*pFlowIdx], FLOW_INFO_DUPLICATE_EXIST, TRUE);
			FLOW_INFO_SET(&fc_db.flowTbl[theSamePtnFlowIdx], FLOW_INFO_DUPLICATE_EXIST, TRUE);
		}

		if(fc_db.flow_callback_func.cbFlowAdd != NULL && pG3IgrExtraInfo) {
			if(pG3IgrExtraInfo->direction <= RTK_FC_FLOW_DIRECTION_DOWNSTREAM)
#if defined(CONFIG_RTK_L34_G3_PLATFORM) && !defined(CONFIG_FC_RTL8277C_SERIES)
			{
				fc_db.flow_callback_func.cbFlowAdd(ctMark, ct, *pFlowIdx, pG3IgrExtraInfo->direction, (fc_db.flowTbl[*pFlowIdx].mainHashIdx == G3_FLOWIDX_INVALID)?1:0);
				//Support using rtct->mark as DPI index.
				//check mainHashIdx for HW or SW acceleration.
			}
#elif defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)
			{
				fc_db.flow_callback_func.cbFlowAdd(ctMark, ct, *pFlowIdx, pG3IgrExtraInfo->direction, (*pFlowIdx >= fc_db.flowHwTableSize)?1:0);

			}
#endif
		}
		
		
#if defined(CONFIG_FC_RTL9607C_SERIES)
		if(fc_db.controlFuc.special_fast_forward_mode==1 && 
		   fc_db.controlFuc.hwnat_customize==1 &&
		   pPktHdr &&
		   pPktHdr->isV6_NAT &&
		   addSwOnly !=1 &&
		   pG3IgrExtraInfo &&
		   pG3IgrExtraInfo->nptv6_hwlookup_flow ==0
		   )
		{
			int npt_flow_info_idx=0;
			int result = 0;
			result = _rtk_fc_get_nptv6_flowInfo_idx(&npt_flow_info_idx);
			TRACE("NPTv6 Inner flow setting!npt_flow_info_idx = %d inner flow index = %d",npt_flow_info_idx,*pFlowIdx);
			if(result!=FAILED)
				fc_db.nptv6_flow_info[npt_flow_info_idx].inner_flow_index = *pFlowIdx;
			else
				WARNING("[NPTv6]get nptv6_flowInfo_idx failed!");
			pG3IgrExtraInfo->nptv6_info_index = npt_flow_info_idx;
			
			TRACE("flowIdx= %d nptv6_info_index = %d pG3IgrExtraInfo->nptv6_info_index",*pFlowIdx,pG3IgrExtraInfo->nptv6_info_index);
			fc_db.flowTbl[*pFlowIdx].protoCtrl = FLOW_PROTO_CTRL_NPTV6_SFF;
			fc_db.flowTbl[*pFlowIdx].nptv6_info_index = pG3IgrExtraInfo->nptv6_info_index;
			
			
		}
		else if(fc_db.controlFuc.special_fast_forward_mode==1 && 
		   fc_db.controlFuc.hwnat_customize==1 &&
		   pPktHdr &&
		   pPktHdr->isV6_NAT &&
		   addSwOnly !=1 &&
		   pG3IgrExtraInfo &&
		   pG3IgrExtraInfo->nptv6_hwlookup_flow ==1
		)
		{
			TRACE("NPTv6 Outer flow setting! pG3IgrExtraInfo->nptv6_info_index = %d, outer FlowIdx = %d", pG3IgrExtraInfo->nptv6_info_index,*pFlowIdx);
			fc_db.flowTbl[*pFlowIdx].protoCtrl = FLOW_PROTO_CTRL_NPTV6_SFF;
			fc_db.flowTbl[*pFlowIdx].nptv6_info_index = pG3IgrExtraInfo->nptv6_info_index;
			fc_db.nptv6_flow_info[pG3IgrExtraInfo->nptv6_info_index].outer_flow_index = *pFlowIdx;
			fc_db.nptv6_flow_info[pG3IgrExtraInfo->nptv6_info_index].isSet = 1;
			
		}
		else if(fc_db.controlFuc.special_fast_forward_mode==1 && 
		   fc_db.controlFuc.hwnat_customize==1 &&
		   pPktHdr &&
		   pPktHdr->isV6_NAT &&
		   addSwOnly==1 &&
		   pG3IgrExtraInfo && pG3IgrExtraInfo->nptv6_info_index !=0 &&
		   fc_db.nptv6_flow_info[pG3IgrExtraInfo->nptv6_info_index].isSet == 1 &&
		   dynamic_sram_desc == 0
		   )
		{
			TRACE("NPTv6 SW flow setting! pG3IgrExtraInfo->nptv6_info_index = %d, sw FlowIdx = %d", pG3IgrExtraInfo->nptv6_info_index,*pFlowIdx);
			fc_db.flowTbl[*pFlowIdx].nptv6_info_index = pG3IgrExtraInfo->nptv6_info_index;
			fc_db.nptv6_flow_info[pG3IgrExtraInfo->nptv6_info_index].sw_flow_index = *pFlowIdx;
			fc_db.flowTbl[*pFlowIdx].protoCtrl = FLOW_PROTO_CTRL_NPTV6_SFF;
		}
#endif

	}
	else{
		WARNING("FAIL ret = 0x%x", ret);
	}

	return (ret);
}

rtk_fc_ret_t _rtk_fc_flow_wan_downstream_loopback_flow_prepare
	(void *pFlowEntryData, void *pRevFlowEntryData, int *pRevHashIdx, rtk_fc_igrExtraInfo_t *pExtraInfo, rtk_fc_igrExtraInfo_t *pRevExtraInfo, 
	rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, rtk_fc_g3IgrExtraInfo_t *pRevG3IgrExtraInfo, rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_rg_asic_path1_entry_t *pFlow = pFlowEntryData, *pRevFlow = pRevFlowEntryData;
	uint16 outCvid = 0, remapCvid, outSvid = 0, remapSvid;
	uint8 outCpri = 0, remapCpri;
	uint16 cvidRemapOff = 100, cpriRemapOff = 1, svidRemapOff = 100;
	uint16 lutDaIdx_gmacChk = FALSE;

	/*copy flow to loopback reverse flow*/
	memcpy(pRevFlow, pFlow, sizeof(rtk_rg_asic_path1_entry_t));

	{
		/* modify original flow
			action: change egress svid, cvid and cpri to remapping cvid and cpri
		*/
		if(pFlow->out_cvid_format_act)
		{
			outCvid = pFlow->out_cvlan_id;
			outCpri = pFlow->out_cpri;
		}

		if(pFlow->out_svid_format_act)
			outSvid = pFlow->out_svlan_id;

		//action remapping
		remapCvid = (outCvid + cvidRemapOff) & 0xfff;
		remapCpri = (outCpri + cpriRemapOff) & 0x7;
		remapSvid = (outSvid + svidRemapOff) & 0xfff;
		pFlow->out_cvid_format_act = TRUE;
		pFlow->out_cpri_format_act = TRUE;
		pFlow->out_cvlan_id = remapCvid;
		pFlow->out_cpri = remapCpri;
		pFlow->out_svid_format_act = TRUE;
		pFlow->out_svlan_id = remapSvid;
	}

	{
		/* modify loopback reverse flow
			pattern:  change ingress cvid and cpri to remapping cvid and cpri
			action: forwarn to WAN port
		*/
		//pattern remapping
		pRevFlow->in_ctagif = TRUE;
		pRevFlow->in_cvlan_pri = remapCpri;
		pRevFlow->in_stagif = TRUE;
		if(pRevFlow->in_path == FB_PATH_12)
		{
			pRevFlow->in_cvlan_id = remapCvid; // only path12 has in_cvlan_id field
			pRevFlow->in_svlan_id = remapSvid;
			pRevFlow->in_spa = __ffs(pFlow->out_portmask);
		}

		pRevFlow->out_uc_lut_lookup = FALSE;
		pRevFlow->out_portmask = fc_db.wanPortMask.portmask;
		pRevFlow->out_ext_portmask_idx = 0;
		pRevFlow->in_out_stream_idx_check_act = TRUE;
		pRevFlow->in_out_stream_idx = pPktHdr->remarkDec.streamId;
	}

	{
		/*prepare loopback reverse extraInfo*/
		memcpy(pRevExtraInfo, pExtraInfo, sizeof(rtk_fc_igrExtraInfo_t));
#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
		pRevExtraInfo->srcDev = pPktHdr->dstDev;
		pRevExtraInfo->dummyPkt = NULL;
#endif
	}

	{
		/*prepare loopback reverse g3IgrExtraInfo*/
		memcpy(pRevG3IgrExtraInfo, pG3IgrExtraInfo, sizeof(rtk_fc_g3IgrExtraInfo_t));
		pRevG3IgrExtraInfo->svlan_id = pRevFlow->in_svlan_id;
		pRevG3IgrExtraInfo->cvlan_id = pRevFlow->in_cvlan_id;
		pRevG3IgrExtraInfo->ingressSaHostPolIdx = FAIL;
		pRevG3IgrExtraInfo->egressDaHostPolIdx = FAIL;
	}
	{
		/* calculate hash index for loopback reverse flow	*/
		if(pRevFlow->in_path == FB_PATH_34)
		{
			//PATH34
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
			if(ASICDRIVERVER==0x1)
			{
				//search dmac index
				if(pPktHdr->dmacL2Idx != FAIL)
				{
					lutDaIdx_gmacChk = pPktHdr->dmacL2Idx;
				}
				else
				{
					DEBUG("[Path 3] DMAC is not found in lut table.");
					*pRevHashIdx = SIGNED_INVALID;
					return RTK_FC_RET_ERR_INVALID_PARAM;
				}
			}else
#endif
			{
				lutDaIdx_gmacChk = 0;
			}

		}
#if defined(CONFIG_FC_RTL8277C_SERIES)
			{
				rtk_8277c_asic_flow_hash_crc_t flow_hash_crc;
				if(_rtk_fc_flow_hashIndex(*((rtk_fc_tableFlowEntry_t*)pRevFlow), pG3IgrExtraInfo, &flow_hash_crc) != RTK_FC_RET_OK)
				{
					WARNING("Get flow CRC by flowPathEntry failed");
					return RT_ERR_RG_FAILED;
				}
				*pRevHashIdx = flow_hash_crc.crc16;
			}
#else
			*pRevHashIdx = _rtk_fc_flow_hashIndex(*((rtk_fc_tableFlowEntry_t*)pRevFlow), pRevFlow->in_stagif?pRevFlow->in_svlan_id:0, remapCvid, lutDaIdx_gmacChk);
#endif
	}

	return RTK_FC_RET_OK;
}

int _rtk_fc_flow_swField_set(uint32 flowIdx, uint32 flowHashIdx, struct nf_conn *ct, rtk_fc_igrExtraInfo_t *pExtraInfo, int indMacIdx, uint8 swOnly, uint8 staticEntry,uint8 isMulticast, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, rtk_fc_pktHdr_t *pPktHdr)
{
	if(flowIdx < fc_db.flowHwTableSize)
	{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		fc_db.fb_hwFlow_validBitsArray[(flowIdx >> 5)] |= (0x1 << (flowIdx&0x1f));
		// flow Tcam list
		if(rgpro_db.fbMode==FB_MODE_4K
			&& (RTK_FC_TABLESIZE_FLOWSRAM<=flowIdx && flowIdx<fc_db.flowHwTableSize))
		{
			uint32 hash=flowHashIdx>>fc_db.flowHashWayShift;
			assert_ok(_rtk_fc_flowTcamListAdd(hash, flowIdx));
		}

#elif defined(CONFIG_FC_RTL8277C_SERIES)
		if (rtk_fc_is_mape_upstream_flow5(flowIdx) == TRUE)
		{
			if (rtk_fc_mape_dst6_decision(pPktHdr, flowIdx) != SUCCESS)
				return FAILED;
		}
#if RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if(flowIdx >= RTK_FC_TABLESIZE_HASH_FLOW)
			assert_ok(_rtk_fc_overFlowHashListAdd(flowIdx));
#endif
#endif
	}
	else if(fc_db.shortcut_flow_count > 0)	// sw flow list
	{
		uint32 flowHashListIdx;
		if (rtk_fc_is_mape_upstream_flow5(flowIdx) == TRUE)
		{
			if (rtk_fc_mape_dst6_decision(pPktHdr, flowIdx) != SUCCESS)
				return FAILED;
		}
		
		flowHashListIdx=RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx);
		assert_ok(_rtk_fc_swFlowListAdd(flowHashListIdx, flowIdx));
	}

	if(ct)
	{
		if( RTK_FC_HOOK_PS_CT_IS_DYING(ct) || !atomic_inc_not_zero(&ct->ct_general.use) )
		{
			WARNING("flow %d ct is dying or refcount is 0", flowIdx);
			fc_db.flowTbl[flowIdx].cachedCt = NULL;
		}else{
			// nf_conntrack_get is done by atomic_inc_not_zero
			fc_db.flowTbl[flowIdx].cachedCt = ct;	
		}
	}else{
		fc_db.flowTbl[flowIdx].cachedCt = NULL;
	}
	
	FLOW_INFO_SET(&fc_db.flowTbl[flowIdx], FLOW_INFO_SOFTWARE_ONLY, swOnly);
	FLOW_INFO_SET(&fc_db.flowTbl[flowIdx], FLOW_INFO_STATIC_ENTRY, staticEntry);
	FLOW_INFO_SET(&fc_db.flowTbl[flowIdx], FLOW_INFO_MC_ENTRY, isMulticast);
	fc_db.flowTbl[flowIdx].idleSecs = 0;
	fc_db.flowTbl[flowIdx].needUpdate = 0;
	fc_db.flowTbl[flowIdx].swTrfBit = TRUE;		// if flase, housekeeping may delete flow immediately
	fc_db.flowTbl[flowIdx].flow_hit_times = 0;
	if(pG3IgrExtraInfo)
	{
		fc_db.flowTbl[flowIdx].igr_stpid_sel = pG3IgrExtraInfo->igr_svlan_tpid_sel;
		fc_db.flowTbl[flowIdx].egr_stpid_sel = pG3IgrExtraInfo->egr_svlan_tpid_sel;
	}
//	fc_db.flowTbl[flowIdx].loopbackRevFlowIdx = SIGNED_INVALID;// shared field!!
//	fc_db.flowTbl[flowIdx].ipv6_nat_indirect_mapping_index = 0;	// shared field!!
	if(pPktHdr)
	{
		if(swOnly){
			if(pPktHdr->icmph){
				fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_ICMP_ACC;
				fc_db.flowTbl[flowIdx].icmpInfo.icmp_id = pPktHdr->icmph->un.echo.id;
				fc_db.flowTbl[flowIdx].icmpInfo.icmp_seqence_num = pPktHdr->icmph->un.echo.sequence;
			}else if(pPktHdr->icmp6h){
				fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_ICMP_ACC;
				fc_db.flowTbl[flowIdx].icmpInfo.icmp_id = pPktHdr->icmp6h->icmp6_identifier;
				fc_db.flowTbl[flowIdx].icmpInfo.icmp_seqence_num = pPktHdr->icmp6h->icmp6_sequence;
			}
		}
		if(pPktHdr->isMAPT){
			fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_MAPT_ACC;
			if(pExtraInfo)fc_db.flowTbl[flowIdx].maptInfo=pExtraInfo->maptInfo;
#if defined(CONFIG_FC_RTL8277C_SERIES)
			//keep fmr idx for decreasing ref count when downstream flow destroyed.
			if(pPktHdr->fmr_idx != SIGNED_INVALID){
				fc_db.flowTbl[flowIdx].pFlowEntry->path5.out_fmr_idx_act = TRUE;
				fc_db.flowTbl[flowIdx].pFlowEntry->path5.out_fmr_idx = pPktHdr->fmr_idx;
			}
#endif
		}
		if(pPktHdr->remarkDec.skip_fc_alg_check)
		{
			fc_db.flowTbl[flowIdx].flow_extra_info |= FLOW_INFO_ALG_EXIST;
		}

		FLOW_INFO_SET(&fc_db.flowTbl[flowIdx], FLOW_INFO_ACL_PRI_FWD, pPktHdr->isHitSwFwdedAclTrapPri);
	}
		
	if(pExtraInfo){
		fc_db.flowTbl[flowIdx].lutIgrSaIdx = pExtraInfo->lutIgrSaIdx;
		fc_db.flowTbl[flowIdx].lutEgrDaIdx = pExtraInfo->lutEgrDaIdx;
		fc_db.flowTbl[flowIdx].swShaperEn = pExtraInfo->swShaperEn;
#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
		fc_db.flowTbl[flowIdx].srcDev = pExtraInfo->srcDev;
		if(fc_db.flowTbl[flowIdx].dummyPkt && pExtraInfo->dummyPkt) {
			memcpy(fc_db.flowTbl[flowIdx].dummyPkt, pExtraInfo->dummyPkt, sizeof(rtk_fc_igrDummyData_t));
		}
#endif
	}

	if(!fc_db.flowTbl[flowIdx].cachedCt) // any flow entry without ct
		FLOW_INFO_SET(&fc_db.flowTbl[flowIdx], FLOW_INFO_SKIP_CT, TRUE);

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(fc_db.flowTbl[flowIdx].pFlowEntry->path1.valid==FALSE)
		fc_db.flowTbl[flowIdx].candidateState = CANDIDATE_STATE_NEW;		// postpond adding to HW, state is new
	else
		fc_db.flowTbl[flowIdx].candidateState = CANDIDATE_STATE_READY;	// adding to HW right now, state is ready
#endif

#if !defined(CONFIG_FC_RTL8277C_SERIES) // 8277C no need indMac
	if(indMacIdx!= FAIL)
	{
		if(fc_db.indMacTbl[indMacIdx].valid)
			fc_db.indMacTbl[indMacIdx].indMacRefCount++;
		else{
			FIXME("indMacIdx was wrong?");
		}
	}
#endif
	if(pG3IgrExtraInfo)
	{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
		fc_db.flowTbl[flowIdx].ingressSaHostPolIdx = pG3IgrExtraInfo->ingressSaHostPolIdx;
		fc_db.flowTbl[flowIdx].egressDaHostPolIdx = pG3IgrExtraInfo->egressDaHostPolIdx;
#endif
		fc_db.flowTbl[flowIdx].pppoe_sid = pG3IgrExtraInfo->pppoe_session_id;
		fc_db.flowTbl[flowIdx].svlan_pri = pG3IgrExtraInfo->svlan_pri;
		fc_db.flowTbl[flowIdx].igr_svlan_dei = pG3IgrExtraInfo->igr_svlan_dei;
		fc_db.flowTbl[flowIdx].igr_cvlan_cfi = pG3IgrExtraInfo->igr_cvlan_cfi;
		fc_db.flowTbl[flowIdx].egr_svlan_dei = pG3IgrExtraInfo->egr_svlan_dei;
		fc_db.flowTbl[flowIdx].egr_cvlan_cfi = pG3IgrExtraInfo->egr_cvlan_cfi;
		fc_db.flowTbl[flowIdx].egr_tos_ecn_remark = pG3IgrExtraInfo->egr_tos_ecn_remark;
		fc_db.flowTbl[flowIdx].egr_tos_ecn = pG3IgrExtraInfo->egr_tos_ecn;
		fc_db.flowTbl[flowIdx].pon_stream_id = pG3IgrExtraInfo->pon_stream_id;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		fc_db.flowTbl[flowIdx].crc16 = pG3IgrExtraInfo->crc16;
		fc_db.flowTbl[flowIdx].crc32 = pG3IgrExtraInfo->crc32;
#endif

	}
	

	if(pG3IgrExtraInfo && (pG3IgrExtraInfo->dualPtFlowMapping_info.dual_type != RTK_FC_DUALTYPE_NONE))
	{
		int i;

		for(i = RTK_FC_DUAL_PT_TBL_START_IDX ; i < RTK_FC_DUAL_PASSTHROUGH_FLOWMAPPING_SIZE ; i++)
		{		
			//find invalid dual_pt_flowMapTbl entry
			if(fc_db.dual_pt_flowMapTbl[i].dual_type == RTK_FC_DUALTYPE_NONE)
			{
				TABLE("Add dual pass through flow Map table [%d] (flowTbl[%d])!\n",i,flowIdx);
				memcpy(&(fc_db.dual_pt_flowMapTbl[i]), &(pG3IgrExtraInfo->dualPtFlowMapping_info), sizeof(fc_db.dual_pt_flowMapTbl[i]));
				fc_db.dual_pt_flowMapTbl[i].refFlowIdx = flowIdx;
				fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_DUAL_PT;
				fc_db.flowTbl[flowIdx].dual_pt_flowMapTbl_idx = i;
				break;
			}
		}
		
		if(i == RTK_FC_DUAL_PASSTHROUGH_FLOWMAPPING_SIZE)
		{
			rtk_fc_flow_delete(flowIdx);
			WARNING("no free dual_pt_flowMapTbl entry, delete PPTP/L2TP passthrough routing/NAT flow");
			return RTK_FC_RET_ERR_ENTRY_FULL;
		}
	}


	if(pPktHdr!=NULL && pPktHdr->ip6h && pPktHdr->isV6_NAT==TRUE && pPktHdr->nptv6_outerFlow==0)
	{
		int i6SnatIndirectIndex = 0;
		
		
		fc_db.out_user_pri_act = fc_db.flowTbl[flowIdx].pFlowEntry->path5.out_user_pri_act;
		fc_db.out_user_priority = fc_db.flowTbl[flowIdx].pFlowEntry->path5.out_user_priority;
		TRACE("fc_db.out_user_pri_act %d fc_db.out_user_priority %d", fc_db.out_user_pri_act,fc_db.out_user_priority);
		//fc_db.flowTbl[flowIdx].ipv6_nat_indirect_mapping_index = pG3IgrExtraInfo->ipv6NatIndirectIndex;
		if( rtk_fc_get_ipv6_nat_indirectMap_ref(pPktHdr, &i6SnatIndirectIndex)==SUCCESS)
		{
			if(pPktHdr->direction == RTK_FC_FLOW_DIRECTION_UPSTREAM){			
				TRACE("[NAT66/NPTv6]Find ipv6 mapping table[%d], ingress saddr v6hash: %x Egress ipv6-saddr: %pI6c ipv6-daddr: %pI6c\n",i6SnatIndirectIndex, pPktHdr->ipv6Sip_hash, (&(pPktHdr->ip6h->saddr)), (&(pPktHdr->ip6h->daddr)));
				fc_db.out_stream_idx = fc_db.flowTbl[flowIdx].pFlowEntry->path5.out_stream_idx;
			}else if(pPktHdr->direction == RTK_FC_FLOW_DIRECTION_DOWNSTREAM)
				TRACE("[NAT66/NPTv6]Find ipv6 mapping table[%d], ingress daddr v6hash: %x Egress ipv6-daddr: %pI6c ipv6-daddr: %pI6c\n",i6SnatIndirectIndex, pPktHdr->ipv6Dip_hash, (&(pPktHdr->ip6h->daddr)), (&(pPktHdr->ip6h->daddr)));

			fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_V6NAT;
			fc_db.flowTbl[flowIdx].ipv6_nat_indirect_mapping_index = i6SnatIndirectIndex;

			if(pG3IgrExtraInfo && pG3IgrExtraInfo->naptv6_info.isNPTv6==1)
			{
				fc_db.ipv6_nat_mappingTbl[i6SnatIndirectIndex].wan_prefix_len =  pG3IgrExtraInfo->naptv6_info.wan_prefix_len;
				fc_db.ipv6_nat_mappingTbl[i6SnatIndirectIndex].lan_prefix_len =  pG3IgrExtraInfo->naptv6_info.lan_prefix_len;
				fc_db.ipv6_nat_mappingTbl[i6SnatIndirectIndex].isNPTv6 = pG3IgrExtraInfo->naptv6_info.isNPTv6;	
#if defined(CONFIG_FC_RTL8277C_SERIES)	
				fc_db.ipv6_nat_mappingTbl[i6SnatIndirectIndex].prefix_idx = pG3IgrExtraInfo->naptv6_info.prefix_idx;	
#endif			

			}	
		}	
		else
		{
			WARNING("[NAT V6] Get v6 nat indirect map failed!");
			return FAILED;
		}
	}

	if(pPktHdr!=NULL && pG3IgrExtraInfo && (pG3IgrExtraInfo->l2Dual_type!=RTK_FC_L2DUAL_TYPE_NONE) && !(pG3IgrExtraInfo->vxlan_info.is_vxlanUS_outerFlow) )
	{
		uint32 l2Dual_tag_table_index = 0;

		if(rtk_fc_l2Dual_table_setting(pG3IgrExtraInfo, pPktHdr, &l2Dual_tag_table_index) == SUCCESS)
		{
			fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_L2DUAL;
			fc_db.flowTbl[flowIdx].l2Dual_table_info.l2Dual_table_index = l2Dual_tag_table_index;
		}
		else
		{
			rtk_fc_flow_delete(flowIdx);
			TRACE("[l2Dual] Add l2Dual table entry failed!");
		}
	}

	if(pG3IgrExtraInfo && pG3IgrExtraInfo->l2Dual_type== RTK_FC_L2DUAL_TYPE_VXLAN && (pG3IgrExtraInfo->vxlan_info.is_vxlanDS_outerFlow || pG3IgrExtraInfo->vxlan_info.is_vxlanUS_outerFlow) )
	{
		fc_db.flowTbl[flowIdx].protoCtrl = FLOW_PROTO_CTRL_L2DUAL;
		fc_db.flowTbl[flowIdx].l2Dual_table_info.l2Dual_table_index = 0;
	}
	//TABLE("Add %s flow entry [%d]", (flowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", flowIdx);

	if(pExtraInfo) {
		if((pExtraInfo->lutIgrSaIdx!=-1) && (fc_db.lutTbl[pExtraInfo->lutIgrSaIdx]!=NULL))
			fc_db.lutTbl[pExtraInfo->lutIgrSaIdx]->anyFlowEstablish = TRUE;
		if((pExtraInfo->lutEgrDaIdx!=-1) && (fc_db.lutTbl[pExtraInfo->lutEgrDaIdx]!=NULL))
			fc_db.lutTbl[pExtraInfo->lutEgrDaIdx]->anyFlowEstablish = TRUE;
	}

	if (pPktHdr)
		pPktHdr->egressFlowAddComplete = TRUE;
	
	return SUCCESS;
}

int _rtk_fc_flowTable_init(void)
{

	uint32 i=0;

	fc_db.flowLockGroupSize = RTK_FC_HELPER_MGR_CHECK_CONFIG_SETTING(FC_MGR_GET_CONFIG_FLOW_LOCK_GROUP_SIZE);
	bzero(&FLOWDATAPOOL, FLOWDATAPOOL_SIZE);
	fc_db.flowSwTableSize = fc_db.flowHwTableSize + fc_db.shortcut_flow_count; // update number of sw flow entries

	if(pTmp_tableFlowEntry) RTK_FC_HELPER_FC_KFREE(pTmp_tableFlowEntry, sizeof(rtk_fc_tableFlowEntry_t)*(fc_db.flowSwTableSize - fc_db.flowHwTableSize));

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

	//init flow entries for hw index
	if(_rtk_rg_fbMode_get()==FB_MODE_4K)
	{
		for(i=0; i<fc_db.flowHwTableSize; i++)
			fc_db.flowTbl[i].pFlowEntry = (rtk_fc_tableFlowEntry_t *)(FLOWDATAPOOL+(sizeof(rtk_fc_tableFlowEntry_t)*i));

		// Init flow Tcam list
		{
			// Init flow Tcam free list head
			INIT_LIST_HEAD(&fc_db.flowTcam_freeListHead);

			// Init flow Tcam hash list head
			if(fc_db.flowTcam_hashListHead) RTK_FC_HELPER_FC_KFREE(fc_db.flowTcam_hashListHead, sizeof(struct list_head) * fc_db.flowHashBuckets);
			fc_db.flowTcam_hashListHead = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct list_head) * fc_db.flowHashBuckets, GFP_ATOMIC);
			for(i=0;i<fc_db.flowHashBuckets;i++) {
				INIT_LIST_HEAD(&fc_db.flowTcam_hashListHead[i]);
				if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
					WARNING("tcam list %d not empty", i);
			}

			// Init flow Tcam list
			if(fc_db.flowTcamList) RTK_FC_HELPER_FC_KFREE(fc_db.flowTcamList, sizeof(rtk_fc_flowTcam_linkList_t) * RTK_FC_TABLESIZE_FLOWTCAM);
			fc_db.flowTcamList = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_flowTcam_linkList_t) * RTK_FC_TABLESIZE_FLOWTCAM, GFP_ATOMIC);
			for(i=0; i<RTK_FC_TABLESIZE_FLOWTCAM; i++)
			{
				INIT_LIST_HEAD(&fc_db.flowTcamList[i].flowTcam_list);
				fc_db.flowTcamList[i].idx = RTK_FC_TABLESIZE_FLOWSRAM;	//4096
				fc_db.flowTcamList[i].idx += i;

				//add free list to free list head
				list_add_tail(&fc_db.flowTcamList[i].flowTcam_list, &fc_db.flowTcam_freeListHead);
			}
		}

	}else
	{
		// for dram mode, assign pointer to rgpro_db
		if(rgpro_db.ddrBusAlign32==ENABLED)
		{
			for(i=0; i<fc_db.flowHwTableSize; i++)
				fc_db.flowTbl[i].pFlowEntry = (rtk_fc_tableFlowEntry_t *)(rgpro_db.ddrMemBase+(sizeof(rtk_fc_tableFlowEntry_t)*i));
		}
		else
		{
			WARNING("Not support!");
		}

	}
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	for(i=0; i<fc_db.flowHwTableSize; i++)
	{
		fc_db.flowTbl[i].pFlowEntry = (rtk_fc_tableFlowEntry_t *)(FLOWDATAPOOL+(sizeof(rtk_fc_tableFlowEntry_t)*i));
	}

#endif
	
	
	pTmp_tableFlowEntry = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_tableFlowEntry_t)*(fc_db.flowSwTableSize - fc_db.flowHwTableSize), GFP_ATOMIC);

	//init flow entries for sw index
	for(i=fc_db.flowHwTableSize; i<fc_db.flowSwTableSize; i++)
	{
		fc_db.flowTbl[i].pFlowEntry = (pTmp_tableFlowEntry) + (i-fc_db.flowHwTableSize) ;
		
		if(fc_db.flowTbl[i].pFlowEntry == NULL)
			WARNING("memory allocation for flow[%d] failed.", i);
	}
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	// Init overflow flow list
	{
		INIT_LIST_HEAD(&fc_db.overFlowHash_inUseListHead);
		INIT_LIST_HEAD(&fc_db.overFlowHash_freeListHead);

		// Init overflow list
		if(fc_db.overFlowHashList) RTK_FC_HELPER_FC_KFREE(fc_db.overFlowHashList, sizeof(rtk_fc_overFlowHash_linkList_t) * RTK_FC_TABLESIZE_OVERFLOW_FLOW);
		fc_db.overFlowHashList = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_overFlowHash_linkList_t) * RTK_FC_TABLESIZE_OVERFLOW_FLOW, GFP_ATOMIC);
		for(i = 0 ; i < RTK_FC_TABLESIZE_OVERFLOW_FLOW ; i++)
		{
			INIT_LIST_HEAD(&fc_db.overFlowHashList[i].flow_list);
			fc_db.overFlowHashList[i].idx = RTK_FC_TABLESIZE_HASH_FLOW;
			fc_db.overFlowHashList[i].idx += i;

			//add free list to free list head
			list_add_tail(&fc_db.overFlowHashList[i].flow_list, &fc_db.overFlowHash_freeListHead);
		}
	}
#endif

	// Init sw flow list
	{
		//atomic_set(&fc_db.swflow_only, 0);

		// Init sw flow free list head
		INIT_LIST_HEAD(&fc_db.swFlow_freeListHead);

		// Init sw flow hash list head
		if(fc_db.swFlow_hashListHead) RTK_FC_HELPER_FC_KFREE(fc_db.swFlow_hashListHead,sizeof(struct list_head) * RTK_SW_FLOW_LIST_HEAD_COUNT);
		fc_db.swFlow_hashListHead = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct list_head) * RTK_SW_FLOW_LIST_HEAD_COUNT, GFP_ATOMIC);
		for(i=0;i<RTK_SW_FLOW_LIST_HEAD_COUNT;i++)
			INIT_LIST_HEAD(&fc_db.swFlow_hashListHead[i]);

		// Init sw flow list
		if(fc_db.swFlowList) RTK_FC_HELPER_FC_KFREE(fc_db.swFlowList,sizeof(rtk_fc_swFlow_linkList_t) * (fc_db.flowSwTableSize-fc_db.flowHwTableSize));
		fc_db.swFlowList = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_swFlow_linkList_t) * (fc_db.flowSwTableSize-fc_db.flowHwTableSize), GFP_ATOMIC);
		for(i=0; i<(fc_db.flowSwTableSize-fc_db.flowHwTableSize); i++)
		{
			INIT_LIST_HEAD(&fc_db.swFlowList[i].flow_list);
			fc_db.swFlowList[i].idx = fc_db.flowHwTableSize;
			fc_db.swFlowList[i].idx += i;

			//add free list to free list head
			list_add_tail(&fc_db.swFlowList[i].flow_list, &fc_db.swFlow_freeListHead);
		}
	}

	{
		int max_hash_size = RTK_FC_GET_IPFRAG_MAX_HASH_SIZE();
		int max_hash_entry_size = RTK_FC_GET_IPFRAG_MAX_HASH_ENTRY_SIZE();
		
		INIT_LIST_HEAD(&fc_db.ipFrag_freeListHead);
		INIT_LIST_HEAD(&fc_db.negativeIpFrag_freeListHead);
		
		if (fc_db.ipFrag_hashListHead) RTK_FC_HELPER_FC_KFREE(fc_db.ipFrag_hashListHead, sizeof(struct list_head) * max_hash_size);
		fc_db.ipFrag_hashListHead = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct list_head) * max_hash_size, GFP_ATOMIC);
		
		if (fc_db.negativeIpFrag_hashListHead) RTK_FC_HELPER_FC_KFREE(fc_db.negativeIpFrag_hashListHead, sizeof(struct list_head) * max_hash_size);
		fc_db.negativeIpFrag_hashListHead = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct list_head) * max_hash_size, GFP_ATOMIC);

		for (i = 0; i <  max_hash_size; i++) {
			INIT_LIST_HEAD(&fc_db.ipFrag_hashListHead[i]);
			INIT_LIST_HEAD(&fc_db.negativeIpFrag_hashListHead[i]);
		}
		
		if (fc_db.ipFragList) {
			for (i = 0; i < (max_hash_size * max_hash_entry_size); i++) {
				if(RTK_FC_HELPER_TIMER_PENDING(fc_db.ipFragList[i].timer))
					RTK_FC_HELPER_DEL_TIMER(fc_db.ipFragList[i].timer);
				RTK_FC_HELPER_MGR_TIMER_LIST_KFREE(fc_db.ipFragList[i].timer);
			}
			RTK_FC_HELPER_FC_KFREE(fc_db.ipFragList, sizeof(rtk_fc_ipFrag_linkList_t) * max_hash_size * max_hash_entry_size);
		}
		
		fc_db.ipFragList = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_ipFrag_linkList_t) * max_hash_size * max_hash_entry_size, GFP_ATOMIC);
		memset(fc_db.ipFragList, 0, sizeof(rtk_fc_ipFrag_linkList_t) * max_hash_size * max_hash_entry_size);
		
		if (fc_db.negativeIpFragList) {
			for (i = 0; i < (max_hash_size * max_hash_entry_size); i++) {
				if(RTK_FC_HELPER_TIMER_PENDING(fc_db.negativeIpFragList[i].timer))
					RTK_FC_HELPER_DEL_TIMER(fc_db.negativeIpFragList[i].timer);
				RTK_FC_HELPER_MGR_TIMER_LIST_KFREE(fc_db.negativeIpFragList[i].timer);
			}
			
			RTK_FC_HELPER_FC_KFREE(fc_db.negativeIpFragList, sizeof(rtk_fc_negativeIpFrag_linkList_t) * max_hash_size * max_hash_entry_size);
		}
		
		fc_db.negativeIpFragList = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_negativeIpFrag_linkList_t) * max_hash_size * max_hash_entry_size, GFP_ATOMIC);
		memset(fc_db.negativeIpFragList, 0, sizeof(rtk_fc_negativeIpFrag_linkList_t) * max_hash_size * max_hash_entry_size);

		for (i = 0; i < (max_hash_size * max_hash_entry_size); i++)
		{
			INIT_LIST_HEAD(&fc_db.ipFragList[i].entry);
			list_add_tail(&fc_db.ipFragList[i].entry, &fc_db.ipFrag_freeListHead);
			
			fc_db.ipFragList[i].timer = RTK_FC_HELPER_MGR_TIMER_LIST_KMALLOC();
			RTK_FC_HELPER_INIT_TIMER(fc_db.ipFragList[i].timer, rtk_fc_ipFrag_cache_timeout);
			RTK_FC_HELPER_SETUP_TIMER(fc_db.ipFragList[i].timer,rtk_fc_ipFrag_cache_timeout,(unsigned long)&fc_db.ipFragList[i]);



			INIT_LIST_HEAD(&fc_db.negativeIpFragList[i].entry);
			list_add_tail(&fc_db.negativeIpFragList[i].entry, &fc_db.negativeIpFrag_freeListHead);
			
			fc_db.negativeIpFragList[i].timer = RTK_FC_HELPER_MGR_TIMER_LIST_KMALLOC();
			RTK_FC_HELPER_INIT_TIMER(fc_db.negativeIpFragList[i].timer, (void*)rtk_fc_negtive_ipFrag_cache_timeout);
			RTK_FC_HELPER_SETUP_TIMER(fc_db.negativeIpFragList[i].timer,(void*)rtk_fc_negtive_ipFrag_cache_timeout,(unsigned long)&fc_db.negativeIpFragList[i]);
		}
	}

	return SUCCESS;
}

// fb mode related items, nees re-allocate data structure if changing fb mode.
int _rtk_fc_flowDataBase_init(void)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	fc_db.flowHwTableSize = _rtk_rg_flowEntryNum_get();	// get entry number must be called after fb-init func.
	if(rgpro_db.fbMode==FB_MODE_4K) fc_db.flowHwTableSize+=RTK_FC_TABLESIZE_FLOWTCAM;

	fc_db.flowHashBuckets = _rtk_rg_flowHashBuckets_get();
	fc_db.flowHashWayShift = (rgpro_db.fbMode==FB_MODE_4K)?2:0;
	fc_db.swflowlistBucketExtendShift = 0;	//no need to extend

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_RTL8277C_SERIES)
	uint32_t hashTbl_size, hashBucket_size, hashAction_width;
	uint16_t hashOfTbl_size;
	aal_hash_hash_table_size_get(&hashTbl_size, &hashBucket_size, &hashAction_width);
	aal_hash_hash_overflow_table_size_get(&hashOfTbl_size);

	if(((hashTbl_size+RTK_FC_TABLESIZE_OVERFLOW_FLOW) != RTK_FC_TABLESIZE_HW_FLOW) || (hashTbl_size != RTK_FC_TABLESIZE_HASH_FLOW) || (hashOfTbl_size < RTK_FC_TABLESIZE_OVERFLOW_FLOW))
		WARNING("check!! un-match HW hash number (hashTbl_size: %d, hashOfTbl_size: %d, RTK_FC_TABLESIZE_HW_FLOW: %d, RTK_FC_TABLESIZE_HASH_FLOW: %d, RTK_FC_TABLESIZE_OVERFLOW_FLOW: %d)!!", hashTbl_size, hashOfTbl_size, RTK_FC_TABLESIZE_HW_FLOW, RTK_FC_TABLESIZE_HASH_FLOW, RTK_FC_TABLESIZE_OVERFLOW_FLOW);

	fc_db.flowHwTableSize = RTK_FC_TABLESIZE_HW_FLOW; 			// hash entry: HW hash entry and overflow hash entry
	fc_db.flowHashBuckets = hashTbl_size/hashBucket_size;
	fc_db.flowHashWayShift = __ffs(hashBucket_size);
	fc_db.flowEntIdxMask = ((fc_db.flowHashBuckets-1) << fc_db.flowHashWayShift) * (RTK_FC_TABLESIZE_HASH_FLOW_MAX/hashTbl_size);
	fc_db.swflowlistBucketExtendShift = __ffs((hashBucket_size*32768)/hashTbl_size);	//extend hash sw list to 32768

#else
	fc_db.flowHwTableSize = RTK_FC_TABLESIZE_HW_FLOW; 			// search flow entry: G3 2 ways; G3-lite 1 way
	fc_db.flowHashBuckets = 32768;
	fc_db.flowHashWayShift = ((fc_db.flowHwTableSize / fc_db.flowHashBuckets)>>1);
	fc_db.swflowlistBucketExtendShift = 0;	//no need to extend
#endif
#endif

	//fc_db.hwFlow_hkCurIdx = 0;
	fc_db.swFlow_hkCurIdx = 0;

	/* Init flow table */
	_rtk_fc_flowTable_init();
	DEBUG("INIT flow table, hw size:%d  sw size:%d", fc_db.flowHwTableSize, fc_db.flowSwTableSize);

	fc_db.flowIdleTimeout_unit1s = 30;
	fc_db.ucTimeout_unit1s = 300;
	fc_db.mcTimeout_unit1s = DEFAULT_MCGROUP_TRAP_TIMEOUT;
	_rtk_fc_flow_chenkingTime_set(20);	// linux udp timeout is 30 sec.
	fc_db.wanAccessLimitProbeInterval_unit1s = 3;

	fc_db.controlFuc.pppoe_connectionAutoExtend_period_unit1s = 60;

	fc_db.flowSync_groupCnt = fc_db.flowHashBuckets/RTK_FTCHECK_GRANULARITY;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	// flow entry valid array for hw
	if(fc_db.fb_hwFlow_validBitsArray) RTK_FC_HELPER_FC_KFREE(fc_db.fb_hwFlow_validBitsArray, sizeof(int)*(fc_db.flowHwTableSize>>5));
	fc_db.fb_hwFlow_validBitsArray = RTK_FC_HELPER_FC_KMALLOC(sizeof(int)*(fc_db.flowHwTableSize>>5), GFP_ATOMIC);
	memset(fc_db.fb_hwFlow_validBitsArray, 0, sizeof(int)*(fc_db.flowHwTableSize>>5));

	// flow entry valid array for hw - tmp validbits for house keeping
	if(fc_db.fb_hwFlow_tmpValidBitsArray) RTK_FC_HELPER_FC_KFREE(fc_db.fb_hwFlow_tmpValidBitsArray, sizeof(int)*(fc_db.flowHwTableSize>>5));
	fc_db.fb_hwFlow_tmpValidBitsArray = RTK_FC_HELPER_FC_KMALLOC(sizeof(int)*(fc_db.flowHwTableSize>>5), GFP_ATOMIC);
	memset(fc_db.fb_hwFlow_tmpValidBitsArray, 0, sizeof(int)*(fc_db.flowHwTableSize>>5));

	// flow entry traffic bit array for hw
	if(fc_db.fb_hwFlow_trfBitsArray) RTK_FC_HELPER_FC_KFREE(fc_db.fb_hwFlow_trfBitsArray,sizeof(int) *(fc_db.flowHwTableSize>>5));
	fc_db.fb_hwFlow_trfBitsArray = RTK_FC_HELPER_FC_KMALLOC(sizeof(int)*(fc_db.flowHwTableSize>>5), GFP_ATOMIC);
	memset(fc_db.fb_hwFlow_trfBitsArray, 0, sizeof(int)*(fc_db.flowHwTableSize>>5));
#endif

	// Init flow hash count
	if(fc_db.flowHashCount) RTK_FC_HELPER_FC_KFREE(fc_db.flowHashCount, sizeof(uint16) * fc_db.flowHashBuckets);
	fc_db.flowHashCount = RTK_FC_HELPER_FC_KMALLOC(sizeof(uint16) * fc_db.flowHashBuckets, GFP_ATOMIC);
	memset(fc_db.flowHashCount, 0, sizeof(uint16) * fc_db.flowHashBuckets);

	if(fc_db.flowHashHwCollisionCount) RTK_FC_HELPER_FC_KFREE(fc_db.flowHashHwCollisionCount, sizeof(uint16) * fc_db.flowHashBuckets);
	fc_db.flowHashHwCollisionCount = RTK_FC_HELPER_FC_KMALLOC(sizeof(uint16) * fc_db.flowHashBuckets, GFP_ATOMIC);
	memset(fc_db.flowHashHwCollisionCount, 0, sizeof(uint16) * fc_db.flowHashBuckets);


#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	// HW mainHash valid array
	if(fc_db.g3_mHashTbl_validBitsArray) RTK_FC_HELPER_FC_KFREE(fc_db.g3_mHashTbl_validBitsArray,sizeof(int));
	fc_db.g3_mHashTbl_validBitsArray = RTK_FC_HELPER_FC_KMALLOC(sizeof(int)*(fc_db.flowHwTableSize>>5), GFP_ATOMIC);
	memset(fc_db.g3_mHashTbl_validBitsArray, 0, sizeof(int)*(fc_db.flowHwTableSize>>5));

	// HW mainHash traffic bit
	if(fc_db.g3_mHash_trfBitsArray) RTK_FC_HELPER_FC_KFREE(fc_db.g3_mHash_trfBitsArray,sizeof(uint32));
	fc_db.g3_mHash_trfBitsArray = RTK_FC_HELPER_FC_KMALLOC(sizeof(int)*(fc_db.flowHwTableSize>>5), GFP_ATOMIC);
	memset(fc_db.g3_mHash_trfBitsArray, 0, sizeof(int)*(fc_db.flowHwTableSize>>5));
#endif

	return SUCCESS;
}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
int _rtk_fc_flowTcamListAdd(uint32 flowHashIdx, uint32 addFlowIdx)
{
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry;


	if(rgpro_db.fbMode!=FB_MODE_4K)
		goto RET_FAILED;
	if(!(flowHashIdx<fc_db.flowHashBuckets))
		goto RET_FAILED;
	if(!(RTK_FC_TABLESIZE_FLOWSRAM<=addFlowIdx && addFlowIdx<fc_db.flowHwTableSize))
		goto RET_FAILED;

	pFlowTcamEntry = &fc_db.flowTcamList[addFlowIdx-RTK_FC_TABLESIZE_FLOWSRAM];

	//Delete from head list
	list_del_init(&pFlowTcamEntry->flowTcam_list);

	//Add to hash head list
	list_add_tail(&pFlowTcamEntry->flowTcam_list, &fc_db.flowTcam_hashListHead[flowHashIdx]);

	DEBUG("add flow[%d] to flowTcam_hashListHead[%d]\n", addFlowIdx, flowHashIdx);

	return (RTK_FC_RET_OK);

RET_FAILED:
	return FAILED;
}

int _rtk_fc_flowTcamListDel(uint32 delFlowIdx)
{
	rtk_fc_flowTcam_linkList_t *pDelFlowTcamEntry;
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry, *pNextFlowTcamEntry;


	if(rgpro_db.fbMode!=FB_MODE_4K)
		goto RET_FAILED;
	if(!(RTK_FC_TABLESIZE_FLOWSRAM<=delFlowIdx && delFlowIdx<fc_db.flowHwTableSize))
		goto RET_FAILED;

	pDelFlowTcamEntry = &fc_db.flowTcamList[delFlowIdx-RTK_FC_TABLESIZE_FLOWSRAM];

	//Delete from head list
	list_del_init(&pDelFlowTcamEntry->flowTcam_list);

	if(list_empty(&fc_db.flowTcam_freeListHead))
	{
		list_add(&pDelFlowTcamEntry->flowTcam_list, &fc_db.flowTcam_freeListHead);
	}
	else
	{
		list_for_each_entry_safe(pFlowTcamEntry, pNextFlowTcamEntry, &fc_db.flowTcam_freeListHead, flowTcam_list)
		{
			if(pDelFlowTcamEntry->idx < pFlowTcamEntry->idx)
			{
				list_add_tail(&pDelFlowTcamEntry->flowTcam_list, &pFlowTcamEntry->flowTcam_list);
				break;
			}

			if(&pNextFlowTcamEntry->flowTcam_list == &fc_db.flowTcam_freeListHead)
			{
				list_add(&pDelFlowTcamEntry->flowTcam_list, &pFlowTcamEntry->flowTcam_list);
				break;
			}
		}
	}

	return (RTK_FC_RET_OK);

RET_FAILED:
	return FAILED;
}
#endif
__IRAM_FC_SHORTCUT 
bool _rtk_fc_flow_extraSwflowPatternCheck(rtk_fc_dual_passthrough_flowMapping_t dualPtFlowMapping_info, uint32 dual_pt_flowMapTbl_idx)
{
	if((dualPtFlowMapping_info.dual_type == RTK_FC_DUALTYPE_NONE) && (dual_pt_flowMapTbl_idx == RTK_FC_DUAL_PT_TBL_INVALID_IDX))
		return TRUE;


	if(dualPtFlowMapping_info.dual_type == fc_db.dual_pt_flowMapTbl[dual_pt_flowMapTbl_idx].dual_type)
	{
		//non dual passthrough packet, fc_db.flowTbl[flowIdx].dual_pt_flowMapTbl_idx will be 0 (reserverd entry)
		if(dualPtFlowMapping_info.dual_type == RTK_FC_DUALTYPE_PPTP)
		{
			if(dualPtFlowMapping_info.pptp_flowMapping.in_gre_call_id != fc_db.dual_pt_flowMapTbl[dual_pt_flowMapTbl_idx].pptp_flowMapping.in_gre_call_id)
				return FALSE;
		}
		else if(dualPtFlowMapping_info.dual_type == RTK_FC_DUALTYPE_L2TP)
		{
			if((dualPtFlowMapping_info.l2tp_flowMapping.in_l2tp_tunnel_id != fc_db.dual_pt_flowMapTbl[dual_pt_flowMapTbl_idx].l2tp_flowMapping.in_l2tp_tunnel_id) ||
				(dualPtFlowMapping_info.l2tp_flowMapping.in_l2tp_session_id!= fc_db.dual_pt_flowMapTbl[dual_pt_flowMapTbl_idx].l2tp_flowMapping.in_l2tp_session_id))
				return FALSE;
		}else if(dualPtFlowMapping_info.dual_type == RTK_FC_DUALTYPE_IPSEC)
		{
			if(dualPtFlowMapping_info.ipsec_flowMapping.esp_spi != fc_db.dual_pt_flowMapTbl[dual_pt_flowMapTbl_idx].ipsec_flowMapping.esp_spi)
				return FALSE;
		}
	}
	else
		return FALSE;
	
	TRACE("extra sw flow pattern check: HIT (dualType: %d)", dualPtFlowMapping_info.dual_type);

	return TRUE;
}

__IRAM_FC_SHORTCUT
bool rtk_fc_flow_compareByIngressPktHdr(uint8 multipleAct, rtk_fc_tableFlow_t *pFlowTable, rtk_fc_pktHdr_t *pPktHdr)
{
	int isIPv6 = pPktHdr->ip6h ? ((pPktHdr->dualHdrType!=RTK_FC_DUALTYPE_DSLITE)?TRUE: FALSE) : FALSE;
	int isTcp = pPktHdr->tcph? TRUE : FALSE;
	uint32 igrSip = 0, igrDip = 0, igrSport = 0, igrDport = 0, flowdip = 0;
	uint32 igrStagif = 0, igrCtagif = 0, igrCpri = 0, igrPppoeif = 0, igrPppoeSid = 0, igrTos = 0;
	bool isL3 = ((pPktHdr->iph) || (pPktHdr->ip6h)) ? TRUE : FALSE;
	bool isL4 = ((pPktHdr->tcph) || (pPktHdr->udph)) ? TRUE : FALSE;
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	bool isMcPassthrough = (!pPktHdr->isMulticast && ((pPktHdr->iph && FLOW_IPV4_MULTICAST_ADDRESS(ntohl(pPktHdr->iph->daddr))) ||(pPktHdr->ip6h && FLOW_IPV6_MULTICAST_ADDRESS(ntohl(pPktHdr->ip6h->daddr.s6_addr32[0])))))?TRUE:FALSE;
#endif
						
	if(!pFlowTable  || !pFlowTable->pFlowEntry
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
		|| pFlowTable->candidateState == CANDIDATE_STATE_NONE
#else
		|| pFlowTable->pFlowEntry->path1.valid == FALSE
#endif
		)
		goto RET_FALSE;
	if((pFlowTable->pFlowEntry->path1.in_path==FB_PATH_12 || pFlowTable->pFlowEntry->path1.in_path==FB_PATH_34)
		&& (pFlowTable->pFlowEntry->path1.in_multiple_act != multipleAct))
		goto RET_FALSE;

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
		// spa check by flow since unknown sa is not control by l2fe anymore
		if( (!fc_db.lutTbl[pFlowTable->lutIgrSaIdx]) || (pPktHdr->isMulticast==0 && pPktHdr->ingressPort.macPortIdx != fc_db.lutTbl[pFlowTable->lutIgrSaIdx]->spa)) {
			TRACE("spa unmatch");
			goto RET_FALSE;
		}
#endif
	if(pPktHdr->isHitSwFwdedAclTrapPri != FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_ACL_PRI_FWD))
		goto RET_FALSE;

	igrPppoeif = (pPktHdr->ppph) ? TRUE : FALSE;
	igrPppoeSid = (pPktHdr->ppph) ? ntohs(pPktHdr->ppph->sid) : 0;
	if(isL3) {
		igrSip = isIPv6 ? pPktHdr->ipv6Sip_hash : ntohl(pPktHdr->iph->saddr);
		igrDip = isIPv6 ? pPktHdr->ipv6Dip_hash : ntohl(pPktHdr->iph->daddr);
	}
	if(isL4) {
		igrSport = pPktHdr->tcph ? ntohs(pPktHdr->tcph->source) : ntohs(pPktHdr->udph->source);
		igrDport = pPktHdr->tcph ? ntohs(pPktHdr->tcph->dest) : ntohs(pPktHdr->udph->dest);
	}

	if (pPktHdr->ipFragFlag && !(pPktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG)) {
		if (pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_TCP || pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_UDP) {
			isL4= TRUE;
			igrSport = pPktHdr->cacheIpFragInfo.src_port;
			igrDport = pPktHdr->cacheIpFragInfo.dst_port;
			isTcp = (pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_TCP) ? TRUE : FALSE;
		}
	}
		
	if((pPktHdr->dmacToGatewayMAC && !pPktHdr->isMulticast)) {
		
			// routing or napt(r)
			rtk_rg_asic_path5_entry_t *pFlowP5 = &pFlowTable->pFlowEntry->path5;

			if(unlikely(fc_db.netifHwTbl[pFlowP5->in_intf_idx].intf.valid == FALSE))
			{
				WARNING("incorrect hw netifidx %d", pFlowP5->in_intf_idx);
				goto RET_FALSE;
			}

			if(pFlowP5->in_path != FB_PATH_5)
				goto RET_FALSE;
			if(pFlowP5->in_ipv4_or_ipv6 != isIPv6)
				goto RET_FALSE;
			if(pFlowP5->in_l4proto != isTcp)
				goto RET_FALSE;

			//For MAP-E, compare inbound dst_v4_ip with tunnel ipv4 address
			if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_MAPE_ACC && (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_DSLITE) && (pFlowP5->out_l4_act==1 && pFlowP5->out_l4_direction==0)){
				flowdip = pFlowTable->mapeInfo.mape_tun_ipv4_addr;
				DEBUG("[MAP-E] flowdip=0x%08x",flowdip);
			}else if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_MAPT_ACC && pFlowP5->out_l4_direction==0){		//downstream, compare v6 hash value
				if(igrSip==fc_db.ipv6_mapt_mappingTbl[pFlowTable->maptInfo.sip_indirect_mapping_index].v6_hash_value && 
					igrDip==fc_db.ipv6_mapt_mappingTbl[pFlowTable->maptInfo.dip_indirect_mapping_index].v6_hash_value){
					DEBUG("[MAPT] SIP and DIP match hash value!!");
					goto CHECK_PORT;
				}else{
					goto RET_FALSE;
				}
			}else
				flowdip = (pFlowP5->out_l4_act==1 && pFlowP5->out_l4_direction==0)?(fc_db.netifHwTbl[pFlowP5->in_intf_idx].intf.gateway_ipv4_addr):(pFlowP5->in_dst_ipv4_addr);

			if(pFlowP5->in_src_ipv4_addr != igrSip)
				goto RET_FALSE;

			// For Ipv6 downstream dnat
			if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_V6NAT && pFlowTable->ipv6_nat_indirect_mapping_index!=0 && pFlowP5->out_l4_direction==0 && isIPv6)
			{
#if 0 /*FIXME WHEN KNOWING NATP v6 or NPT v6*/
				int ret = FAIL, i;

				//Use igrDip to compare with gate-way ipv6 global ip
				for(i = 0 ; i < RTK_FC_TABLESIZE_INTF_SW ; i++)
				{
					if(fc_db.netifTbl[i].intf.valid &&(fc_db.netifTbl[i].hwIdx == pFlowP5->in_intf_idx))
					{
						ret = RTK_FC_HELPER_NETDEV_COMPARE_V6ADDR_BY_V6ADDRHASH(fc_db.netifTbl[i].dev, igrDip);
						if(ret == SUCCESS)
							break;
					}
				}
#endif
				goto CHECK_PORT;

			}

			if(flowdip != igrDip)
				goto RET_FALSE;
CHECK_PORT:			
			if(pFlowP5->in_l4_src_port != igrSport)
				goto RET_FALSE;
			if(pFlowP5->in_l4_dst_port != igrDport)
				goto RET_FALSE;

			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_SVID]==DISABLED)
			{
				igrStagif = (pPktHdr->svh) ? TRUE : FALSE;
				if(pFlowP5->in_stagif != igrStagif)
					goto RET_FALSE;
			}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
			if(ASICDRIVERVER==0x1)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID]==DISABLED)
				{
					igrCtagif = (pPktHdr->cvh) ? TRUE : FALSE;
					if(pFlowP5->in_ctagif != igrCtagif)
						goto RET_FALSE;
				}
			}else
#endif
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID]==DISABLED
					|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI]==DISABLED)
				{
					igrCtagif = (pPktHdr->cvh) ? TRUE : FALSE;
					if(pFlowP5->in_ctagif != igrCtagif)
						goto RET_FALSE;
				}
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI]==DISABLED)
				{
					igrCpri = (pPktHdr->cvh) ? pPktHdr->cvlanpri  : 0;
					if(pFlowP5->in_cvlan_pri != igrCpri)
						goto RET_FALSE;
				}
			}
			if(pFlowP5->in_pppoeif != igrPppoeif)
				goto RET_FALSE;
			if(igrPppoeif)
			{
				if(fc_db.netifHwTbl[pFlowP5->in_intf_idx].intf.out_pppoe_sid != igrPppoeSid)
				{
					goto RET_FALSE;
				}
			}
			if(pFlowP5->in_tos_check)
			{
				igrTos = (pPktHdr->iph) ? pPktHdr->iph->tos : ((pPktHdr->ip6h)?((((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf))):0);
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
				{
					if(pFlowP5->in_tos != igrTos)
						goto RET_FALSE;
				}
				else
				{
					if((pFlowP5->in_tos&0xfc) != (igrTos&0xfc))
						goto RET_FALSE;
				}
			}
			if((pPktHdr->ingressPort.macPortIdx==RTK_FC_MAC_PORT_PON) && fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX])
			{
				if(pFlowTable->pon_stream_id != pPktHdr->ponstreamid)
					goto RET_FALSE;
			}
	}
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	else if((isL3 && isL4) && !isMcPassthrough && (pPktHdr->isMulticast || !fc_db.controlFuc.bridge_5tuple_flow_accelerate_by_2tuple))
#else
	else if(isL3 && isL4 && !fc_db.controlFuc.bridge_5tuple_flow_accelerate_by_2tuple)
#endif
	{
		rtk_rg_asic_path3_entry_t *pFlowP3 = &pFlowTable->pFlowEntry->path3;

		if(unlikely(fc_db.netifHwTbl[pFlowP3->in_intf_idx].intf.valid==FALSE))
		{
	
			WARNING("incorrect hw netifidx %d", pFlowP3->in_intf_idx);
			goto RET_FALSE;
		}

		if(pFlowP3->in_path != FB_PATH_34)
			goto RET_FALSE;
		if(pFlowP3->in_ipv4_or_ipv6 != isIPv6)
			goto RET_FALSE;
		if(pFlowP3->in_l4proto != isTcp)
			goto RET_FALSE;

		if(pFlowP3->in_src_ipv4_addr != igrSip)
			goto RET_FALSE;
		if(pFlowP3->in_dst_ipv4_addr != igrDip)
			goto RET_FALSE;
		if(pFlowP3->in_l4_src_port != igrSport)
			goto RET_FALSE;
		if(pFlowP3->in_l4_dst_port != igrDport)
			goto RET_FALSE;

		if((pPktHdr->isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_SVID]==DISABLED)
			|| (!pPktHdr->isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_SVID]==DISABLED))
		{
			igrStagif = (pPktHdr->svh) ? TRUE : FALSE;
			if(pFlowP3->in_stagif != igrStagif)
				goto RET_FALSE;
		}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			if((pPktHdr->isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED)
				|| (!pPktHdr->isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED))
			{
				igrCtagif = (pPktHdr->cvh) ? TRUE : FALSE;
				if(pFlowP3->in_ctagif != igrCtagif)
					goto RET_FALSE;
			}
		}else
#endif
		{
			if((pPktHdr->isMulticast && (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED || fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED))
				|| (!pPktHdr->isMulticast && (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED || fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED)))
			{
				igrCtagif = (pPktHdr->cvh) ? TRUE : FALSE;
				if(pFlowP3->in_ctagif != igrCtagif)
					goto RET_FALSE;
			}
			if((pPktHdr->isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED)
				|| (!pPktHdr->isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED))
			{
				igrCpri = (pPktHdr->cvh) ? pPktHdr->cvlanpri: 0;
				if(pFlowP3->in_cvlan_pri != igrCpri)
					goto RET_FALSE;
			}
		}
		if(pFlowP3->in_pppoeif != igrPppoeif)
			goto RET_FALSE;
		if(igrPppoeif)
		{
			if(pFlowP3->in_pppoe_sid_check)
			{
				if(fc_db.netifHwTbl[pFlowP3->in_intf_idx].intf.out_pppoe_sid != igrPppoeSid)
				{
					goto RET_FALSE;
				}
			}
			else
			{
				if(pFlowTable->pppoe_sid != igrPppoeSid)
				{
					goto RET_FALSE;
				}
			}
		}
		if(pFlowP3->in_tos_check)
		{
			igrTos = (pPktHdr->iph) ? pPktHdr->iph->tos : ((pPktHdr->ip6h)?((((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf))):0);
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
			{
				if(pFlowP3->in_tos != igrTos)
					goto RET_FALSE;
			}
			else
			{
				if((pFlowP3->in_tos&0xfc) != (igrTos&0xfc))
					goto RET_FALSE;
			}
		}
		if((pPktHdr->ingressPort.macPortIdx==RTK_FC_MAC_PORT_PON) && fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX])
		{
			if(pFlowTable->pon_stream_id != pPktHdr->ponstreamid)
				goto RET_FALSE;
		}
		
		/*TR247 requirement*/
		if(FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_SOFTWARE_ONLY) && (pFlowP3->in_path == FB_PATH_34) &&
			((pFlowTable->lutIgrSaIdx != pPktHdr->smacL2Idx) || (pFlowTable->lutEgrDaIdx!= pPktHdr->dmacL2Idx)) )
		{
			goto RET_FALSE;
		}
		
	}
	else
	{
		rtk_rg_asic_path1_entry_t *pFlowP1 = &pFlowTable->pFlowEntry->path1;

		if(pFlowP1->in_path != FB_PATH_12){
			DEBUG("MISS");
			goto RET_FALSE;
		}
		if(pPktHdr->smacL2Idx==FAIL){
			DEBUG("unknown sa, skip shortcut check");
			goto RET_FALSE;
		}
		if(pPktHdr->dmacL2Idx==FAIL){
			DEBUG("unknown sa, skip shortcut check");
			goto RET_FALSE;
		}
		if(pFlowP1->in_smac_lut_idx != pPktHdr->smacL2Idx){
			DEBUG("MISS");
			goto RET_FALSE;
		}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)		
		if(pPktHdr->dmacL2Idx==fc_db.bcMacIdx)
		{
			if(pFlowP1->in_dmac_lut_idx != HW_BC_IDX){
				DEBUG("MISS");
				goto RET_FALSE;
			}
		}
		else
#endif			
		{
			if(pFlowP1->in_dmac_lut_idx != pPktHdr->dmacL2Idx){
				DEBUG("MISS");
				goto RET_FALSE;
			}
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_SVID]==DISABLED)
		{
			igrStagif = (pPktHdr->svh) ? TRUE : FALSE;
			if(pFlowP1->in_stagif != igrStagif){
				DEBUG("MISS");
				goto RET_FALSE;
			}
		}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED)
			{
				igrCtagif = (pPktHdr->cvh) ? TRUE : FALSE;
				if(pFlowP1->in_ctagif != igrCtagif){
					DEBUG("MISS");
					goto RET_FALSE;
				}
			}
		}else
#endif
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED
				|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED)
			{
				igrCtagif = (pPktHdr->cvh) ? TRUE : FALSE;
				if(pFlowP1->in_ctagif != igrCtagif){
					DEBUG("MISS");
					goto RET_FALSE;
				}
			}
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED)
			{
				igrCpri = (pPktHdr->cvh) ? pPktHdr->cvlanpri : 0;
				if(pFlowP1->in_cvlan_pri != igrCpri){
					DEBUG("MISS");
					goto RET_FALSE;
				}
			}
		}
		if(pFlowP1->in_pppoeif != igrPppoeif){
			DEBUG("MISS");
			goto RET_FALSE;
		}
		if(igrPppoeif && pFlowP1->in_pppoe_sid_check)
		{
			if(pFlowP1->in_pppoe_sid != igrPppoeSid){
				DEBUG("MISS");
				goto RET_FALSE;
			}
		}
		if(pFlowP1->in_tos_check)
		{
			igrTos = (pPktHdr->iph) ? pPktHdr->iph->tos : ((pPktHdr->ip6h)?((((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf))):0);
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
			{
				if(pFlowP1->in_tos != igrTos){
					DEBUG("MISS");
					goto RET_FALSE;
				}
			}
			else
			{
				if((pFlowP1->in_tos&0xfc) != (igrTos&0xfc)){
					DEBUG("MISS");
					goto RET_FALSE;
				}
			}
		}
		if(pFlowP1->in_spa_check)
		{
			if(PATH12_SPA(pFlowP1->in_spa) != pPktHdr->ingressPort.macPortIdx){
				DEBUG("MISS");
				goto RET_FALSE;
			}
			if(pFlowP1->in_ext_spa != pPktHdr->ingressPort.macExtPortIdx){
				DEBUG("MISS");
				goto RET_FALSE;
			}
		}
		if(pFlowP1->in_out_stream_idx_check_act && (pPktHdr->ingressPort.macPortIdx==RTK_FC_MAC_PORT_PON))
		{
			if(pFlowP1->in_out_stream_idx != pPktHdr->ponstreamid){
				DEBUG("MISS");
				goto RET_FALSE;
			}
		}

		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL]) {
			uint32 hwIdx = 0;
			if(unlikely(RTK_RG_ASIC_ETHTYPE_GET_HW_IDX(pPktHdr->ethtype, &hwIdx)!=RTK_FC_RET_OK)) {
					WARNING("ethtype check error");
					goto RET_FALSE;
			}
			
			if(pFlowP1->in_protocol != RTK_FC_ETHERTYPE_DONT_CARE) {
				// flow entry care ethtype
				if(pFlowP1->in_protocol != hwIdx) {
					DEBUG("MISS");
					goto RET_FALSE;
				}
			}else if((pFlowP1->in_protocol == RTK_FC_ETHERTYPE_DONT_CARE) && (hwIdx!=RTK_FC_ETHERTYPE_DONT_CARE)){
				// flow entry don't care ethtype, but currect pkt care
				DEBUG("MISS");
				goto RET_FALSE;
			}else {
				// all don't care
			}
		}
	}

	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI]==DISABLED)
	{
		uint32 igrSpri;
		igrSpri = (pPktHdr->svh)?pPktHdr->svlanpri:0;
		if(pFlowTable->svlan_pri != igrSpri)
		{
			goto RET_FALSE;
		}
	}
	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI]==DISABLED)
	{
		uint32 igrSdei, igrCcfi;
		igrSdei = (pPktHdr->svh)?pPktHdr->svlandei:0;
		igrCcfi = (pPktHdr->cvh)?pPktHdr->cvlancfi:0;
		if((pFlowTable->igr_svlan_dei != igrSdei) || (pFlowTable->igr_cvlan_cfi != igrCcfi))
		{
			goto RET_FALSE;
		}
	}
	
	if(unlikely(((pFlowTable->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT) && pFlowTable->dual_pt_flowMapTbl_idx!=RTK_FC_DUAL_PT_TBL_INVALID_IDX) || 
				(pPktHdr->dualHdrType && pPktHdr->outerHdrMiss) || 
				(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_IPSEC))) {
		
		rtk_fc_dual_passthrough_flowMapping_t dualPtFlowMapping_info;
		
		memset(&dualPtFlowMapping_info, 0 , sizeof(dualPtFlowMapping_info));

		DEBUG("cur pkt dual %d compare to flow, the dual passthrouth table is %d", pPktHdr->dualHdrType, pFlowTable->dual_pt_flowMapTbl_idx);
		
		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP && pPktHdr->tunnelInfo.pptp.pCallId)
		{
			dualPtFlowMapping_info.dual_type = RTK_FC_DUALTYPE_PPTP;
			dualPtFlowMapping_info.pptp_flowMapping.in_gre_call_id = pPktHdr->tunnelInfo.pptp.grecallid;
		}
		else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP)
		{
			dualPtFlowMapping_info.dual_type = RTK_FC_DUALTYPE_L2TP;
			dualPtFlowMapping_info.l2tp_flowMapping.in_l2tp_tunnel_id = pPktHdr->tunnelInfo.l2tp.tunnelid;
			dualPtFlowMapping_info.l2tp_flowMapping.in_l2tp_session_id = pPktHdr->tunnelInfo.l2tp.sessionid;
		}else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_IPSEC)
		{
			dualPtFlowMapping_info.dual_type = RTK_FC_DUALTYPE_IPSEC;
			dualPtFlowMapping_info.ipsec_flowMapping.esp_spi = pPktHdr->esph->spi;
		}


		if((_rtk_fc_flow_extraSwflowPatternCheck(dualPtFlowMapping_info, pFlowTable->dual_pt_flowMapTbl_idx)) == FALSE)
		{
			goto RET_FALSE;
		}
	}

	//VXLAN down stream checking
	if( (pFlowTable->protoCtrl == FLOW_PROTO_CTRL_L2DUAL) && (pFlowTable->l2Dual_table_info.l2Dual_table_index != RTK_FC_L2DUAL_TABLE_INVALID_IDX) &&
		(pPktHdr->dualHdrType && pPktHdr->outerHdrMiss)
	)
	{
		if(pPktHdr->dualHdrType!=RTK_FC_DUALTYPE_VXLAN)
			goto RET_FALSE;
		if( (ntohl(pPktHdr->vxlan_info.vxlanHdr->vx_vni)>>8) != fc_db.l2DualTbl[pFlowTable->l2Dual_table_info.l2Dual_table_index].vxlan_ds.vni )
			goto RET_FALSE;
		if(pPktHdr->vxlan_info.outerTag_off != fc_db.l2DualTbl[pFlowTable->l2Dual_table_info.l2Dual_table_index].vxlan_ds.outer_tag_len )
			goto RET_FALSE;
	}	

	if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_ICMP_ACC) {
		// icmpv4/icmpv6 acceleration check

		if(pPktHdr->icmph && (pPktHdr->icmph->type == 8 || pPktHdr->icmph->type == 0) ) //v4 request/reply
		{
			if(pPktHdr->icmph->un.echo.id !=pFlowTable->icmpInfo.icmp_id)
				goto RET_FALSE;
			
			if(pPktHdr->icmph->un.echo.sequence !=pFlowTable->icmpInfo.icmp_seqence_num)
				goto RET_FALSE;
		}
		else if(pPktHdr->icmp6h && (pPktHdr->icmp6h->icmp6_type == 128 || pPktHdr->icmp6h->icmp6_type == 129) ) // v6 request/reply
		{
			TRACE("icmp v6 ! pPktHdr->icmp6h->icmp6_sequence = %d pPktHdr->icmp6h->icmp6_identifier = %d", pPktHdr->icmp6h->icmp6_sequence, pPktHdr->icmp6h->icmp6_identifier);
			if(pPktHdr->icmp6h->icmp6_sequence !=pFlowTable->icmpInfo.icmp_seqence_num)
				goto RET_FALSE;
			
			if(pPktHdr->icmp6h->icmp6_identifier !=pFlowTable->icmpInfo.icmp_id)
				goto RET_FALSE;
		}else {
			TRACE("packet find icmp flow but not match supported type");
			goto RET_FALSE;
		}
	}

	if(pPktHdr->stpid_sel != pFlowTable->igr_stpid_sel)
		goto RET_FALSE; // HW support stag TPID pattern
			
	return TRUE;

RET_FALSE:
	return FALSE;
}
#if defined(CONFIG_FC_RTL8277C_SERIES)
__IRAM_FC_SHORTCUT
bool rtk_fc_flow_compareByIngressPktHdr_with_CRC(rtk_fc_tableFlow_t *pFlowTable, rtk_fc_pktHdr_t *pPktHdr)
{
	bool isL3 = ((pPktHdr->iph) || (pPktHdr->ip6h)) ? TRUE : FALSE;
	bool isL4 = ((pPktHdr->tcph) || (pPktHdr->udph)) ? TRUE : FALSE;
	bool isMcPassthrough = (!pPktHdr->isMulticast && ((pPktHdr->iph && FLOW_IPV4_MULTICAST_ADDRESS(ntohl(pPktHdr->iph->daddr))) ||(pPktHdr->ip6h && FLOW_IPV6_MULTICAST_ADDRESS(ntohl(pPktHdr->ip6h->daddr.s6_addr32[0])))))?TRUE:FALSE;

	if(!pFlowTable || !pFlowTable->pFlowEntry
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
		|| pFlowTable->candidateState == CANDIDATE_STATE_NONE
#else
		|| pFlowTable->pFlowEntry->path1.valid == FALSE
#endif
		)
		goto RET_FALSE;

#if 1
	// spa check by flow since unknown sa is not control by l2fe anymore
	if( (!fc_db.lutTbl[pFlowTable->lutIgrSaIdx]) || (pPktHdr->isMulticast==0 && pPktHdr->ingressPort.macPortIdx != fc_db.lutTbl[pFlowTable->lutIgrSaIdx]->spa)) {
		TRACE("spa unmatch");
		goto RET_FALSE;
	}
#endif
	if(pPktHdr->isHitSwFwdedAclTrapPri != FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_ACL_PRI_FWD))
		goto RET_FALSE;

	if((pPktHdr->flowHashIdx != pFlowTable->crc16) || (pPktHdr->crc32 != pFlowTable->crc32))
	{
		TRACE("CRC unmatch! packet CRC16/CRC32: 0x%04x/0x%08x, flow CRC16/CRC32: 0x%04x/0x%08x", pPktHdr->flowHashIdx, pPktHdr->crc32, pFlowTable->crc16, pFlowTable->crc32);
		goto RET_FALSE;
	}

	if((isL3 && isL4) && !isMcPassthrough && (pPktHdr->isMulticast || !fc_db.controlFuc.bridge_5tuple_flow_accelerate_by_2tuple))
	{
		rtk_rg_asic_path3_entry_t *pFlowP3 = &pFlowTable->pFlowEntry->path3;

		/*TR247 requirement*/
		if(FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_SOFTWARE_ONLY) && (pFlowP3->in_path == FB_PATH_34) &&
			((pFlowTable->lutIgrSaIdx != pPktHdr->smacL2Idx) || (pFlowTable->lutEgrDaIdx!= pPktHdr->dmacL2Idx)) )
		{
			goto RET_FALSE;
		}
	}

	if(unlikely(((pFlowTable->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT) && pFlowTable->dual_pt_flowMapTbl_idx!=RTK_FC_DUAL_PT_TBL_INVALID_IDX) ||
			(pPktHdr->dualHdrType && pPktHdr->outerHdrMiss) ||
			(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_IPSEC))) {

		rtk_fc_dual_passthrough_flowMapping_t dualPtFlowMapping_info;

		memset(&dualPtFlowMapping_info, 0 , sizeof(dualPtFlowMapping_info));
		DEBUG("cur pkt dual %d compare to flow, the dual passthrouth table is %d", pPktHdr->dualHdrType, pFlowTable->dual_pt_flowMapTbl_idx);

		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP && pPktHdr->tunnelInfo.pptp.pCallId)
		{
			dualPtFlowMapping_info.dual_type = RTK_FC_DUALTYPE_PPTP;
			dualPtFlowMapping_info.pptp_flowMapping.in_gre_call_id = pPktHdr->tunnelInfo.pptp.grecallid;
		}
		else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP)
		{
			dualPtFlowMapping_info.dual_type = RTK_FC_DUALTYPE_L2TP;
			dualPtFlowMapping_info.l2tp_flowMapping.in_l2tp_tunnel_id = pPktHdr->tunnelInfo.l2tp.tunnelid;
			dualPtFlowMapping_info.l2tp_flowMapping.in_l2tp_session_id = pPktHdr->tunnelInfo.l2tp.sessionid;
		}else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_IPSEC)
		{
			dualPtFlowMapping_info.dual_type = RTK_FC_DUALTYPE_IPSEC;
			dualPtFlowMapping_info.ipsec_flowMapping.esp_spi = pPktHdr->esph->spi;
		}

		if((_rtk_fc_flow_extraSwflowPatternCheck(dualPtFlowMapping_info, pFlowTable->dual_pt_flowMapTbl_idx)) == FALSE)
		{
			goto RET_FALSE;
		}
	}

	if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_ICMP_ACC) {
		// icmpv4/icmpv6 acceleration check

		if(pPktHdr->icmph && (pPktHdr->icmph->type == 8 || pPktHdr->icmph->type == 0) ) //v4 request/reply
		{
			if(pPktHdr->icmph->un.echo.id !=pFlowTable->icmpInfo.icmp_id)
				goto RET_FALSE;

			if(pPktHdr->icmph->un.echo.sequence !=pFlowTable->icmpInfo.icmp_seqence_num)
				goto RET_FALSE;
		}
		else if(pPktHdr->icmp6h && (pPktHdr->icmp6h->icmp6_type == 128 || pPktHdr->icmp6h->icmp6_type == 129) ) // v6 request/reply
		{
			TRACE("icmp v6 ! pPktHdr->icmp6h->icmp6_sequence = %d pPktHdr->icmp6h->icmp6_identifier = %d", pPktHdr->icmp6h->icmp6_sequence, pPktHdr->icmp6h->icmp6_identifier);
			if(pPktHdr->icmp6h->icmp6_sequence !=pFlowTable->icmpInfo.icmp_seqence_num)
				goto RET_FALSE;

			if(pPktHdr->icmp6h->icmp6_identifier !=pFlowTable->icmpInfo.icmp_id)
				goto RET_FALSE;
		}else {
			TRACE("packet find icmp flow but not match supported type");
			goto RET_FALSE;
		}
	}
	return TRUE;

RET_FALSE:
	return FALSE;
}

__IRAM_FC_SHORTCUT
rtk_fc_flowEntSearchReturn_t rtk_fc_flow_searchByIngressPktHdr(uint32 flowHashIdx, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable,rtk_fc_tableFlow_t *pFlowTable_mutiAction,uint32* flowTblIdx,uint32* flowTblMutiActIdx)
{
	uint32 i = 0, find = FALSE;
	uint32 flowMatchIdx=(RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE);
	rtk_fc_flowEntSearchReturn_t searchResult = RTK_FC_FLOWENT_SEARCH_FAIL;
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL;
	uint32 baseHwFlowIdx = (flowHashIdx & fc_db.flowEntIdxMask) / (RTK_FC_TABLESIZE_HASH_FLOW_MAX/RTK_FC_TABLESIZE_HASH_FLOW);
	
	if((fc_db.controlFuc.hwnat_mode == RT_FLOW_HWNAT_MODE_SW_ONLY) && (fc_db.shortcut_flow_count != 0))
		goto SEARCH_SW_FLOW;

	FC_PARAM_CHK(((baseHwFlowIdx+(1<<fc_db.flowHashWayShift)-1)>=fc_db.flowHwTableSize/*> valid hw index*/), RTK_FC_FLOWENT_SEARCH_FAIL);

	for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
	{
#if 0
		if((find = rtk_fc_flow_compareByIngressPktHdr(0, &fc_db.flowTbl[baseHwFlowIdx+i], pPktHdr)) == TRUE)
#else
		if((find = rtk_fc_flow_compareByIngressPktHdr_with_CRC(&fc_db.flowTbl[baseHwFlowIdx+i], pPktHdr)) == TRUE)
#endif
		{
			flowMatchIdx = (baseHwFlowIdx+i);
			break;
		}
	}
#if RTK_FC_TABLESIZE_OVERFLOW_FLOW
	{
		rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL;
	//search overflow entry
		if(!find && !list_empty(&fc_db.overFlowHash_inUseListHead))
		{
			list_for_each_entry(pOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
			{
#if 0
				if((find = rtk_fc_flow_compareByIngressPktHdr(0, &fc_db.flowTbl[pOverFlowEntry->idx], pPktHdr)) == TRUE)
#else
				if((find = rtk_fc_flow_compareByIngressPktHdr_with_CRC(&fc_db.flowTbl[pOverFlowEntry->idx], pPktHdr)) == TRUE)
#endif
				{
					flowMatchIdx = pOverFlowEntry->idx;
					break;
				}
			}
		}
	}
#endif
	if(find)
	{
		searchResult = RTK_FC_FLOWENT_SEARCH_HW;
		if(flowMatchIdx> 0 && flowMatchIdx< (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE) &&
			fc_db.flowTbl[flowMatchIdx].protoCtrl==FLOW_PROTO_CTRL_NPTV6_SFF && fc_db.flowTbl[flowMatchIdx].nptv6_info_index!=0)
		{
			DEBUG("[NPTv6]DRAM/SRAM flow :%d trap to CPU! Should check shortCut",flowMatchIdx);
			goto SEARCH_SW_FLOW;
		}
	}

	if((fc_db.shortcut_flow_count != 0))
	{
		if(!find)
		{
SEARCH_SW_FLOW:
			//search sw flow
			if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)]))
			{
				list_for_each_entry(pFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)], flow_list)
				{
					
					if(pFlowEntry->idx <0 ||  pFlowEntry->idx >(RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE) )
					{
							WARNING("strange flow idx!!! pFlowEntry->idx = %d, flowHashIdx[%d]",pFlowEntry->idx, flowHashIdx);
							break;
					}
#if 0
					if((find = rtk_fc_flow_compareByIngressPktHdr(0, &fc_db.flowTbl[pFlowEntry->idx], pPktHdr)) == TRUE)
#else
					if((find = rtk_fc_flow_compareByIngressPktHdr_with_CRC(&fc_db.flowTbl[pFlowEntry->idx], pPktHdr)) == TRUE)
#endif
					{
						flowMatchIdx = pFlowEntry->idx;
						break;
					}
				}
			}

			if(find) searchResult = RTK_FC_FLOWENT_SEARCH_SW;
		}
	}

	if(find && (flowMatchIdx < (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE)))
	{
		memcpy(pFlowTable, &fc_db.flowTbl[flowMatchIdx], sizeof(*pFlowTable));

		TRACE("Hit %s flow[%d], flowHashIdx[%d]", (flowMatchIdx<fc_db.flowHwTableSize)?"Hw":"Sw", flowMatchIdx, flowHashIdx);
		//record matched flow index in pktHdr
		*flowTblIdx= flowMatchIdx;
		fc_db.flowTbl[flowMatchIdx].swTrfBit = TRUE;
	}
	else
		TRACE("Does not find flow entry by using ingress pattern, flowHashIdx[%d]", flowHashIdx);

	return searchResult;
}

#else
__IRAM_FC_SHORTCUT
rtk_fc_flowEntSearchReturn_t rtk_fc_flow_searchByIngressPktHdr(uint32 flowHashIdx, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable,rtk_fc_tableFlow_t *pFlowTable_mutiAction,uint32* flowTblIdx,uint32* flowTblMutiActIdx)
{
	uint32 i = 0, find = FALSE,find_mutiAct = FALSE;
	uint32 flowMatchIdx=(RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE),flowMatchIdx_mutiAction=FAIL;
	rtk_fc_flowEntSearchReturn_t searchResult = RTK_FC_FLOWENT_SEARCH_FAIL,searchResult_multiAction=RTK_FC_FLOWENT_SEARCH_FAIL;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL;
#endif
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL;
	uint32 baseHwFlowIdx = flowHashIdx;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if((fc_db.controlFuc.hwnat_mode == RT_FLOW_HWNAT_MODE_SW_ONLY) && (fc_db.shortcut_flow_count != 0))
		goto SEARCH_SW_FLOW;
#endif

	FC_PARAM_CHK(((baseHwFlowIdx+(1<<fc_db.flowHashWayShift)-1)>=fc_db.flowHwTableSize/*> valid hw index*/), RTK_FC_FLOWENT_SEARCH_FAIL);

	for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
	{
		if((find = rtk_fc_flow_compareByIngressPktHdr(0, &fc_db.flowTbl[baseHwFlowIdx+i], pPktHdr)) == TRUE)
		{
			flowMatchIdx = (baseHwFlowIdx+i);
			break;
		}
	}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if(rgpro_db.fbMode==FB_MODE_4K && !find)
	{
		//search hw Tcam flow
		if(!list_empty(&fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift]))
		{
			list_for_each_entry(pFlowTcamEntry, &fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift], flowTcam_list)
			{
				if((find = rtk_fc_flow_compareByIngressPktHdr(0, &fc_db.flowTbl[pFlowTcamEntry->idx], pPktHdr)) == TRUE)
				{
					flowMatchIdx = pFlowTcamEntry->idx;
					break;
				}
			}
		}
	}
#endif

	if(find) 
	{
		searchResult = RTK_FC_FLOWENT_SEARCH_HW;
		if(flowMatchIdx> 0 && flowMatchIdx< (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE) &&
			fc_db.flowTbl[flowMatchIdx].protoCtrl==FLOW_PROTO_CTRL_NPTV6_SFF && fc_db.flowTbl[flowMatchIdx].nptv6_info_index!=0)
		{
			DEBUG("[NPTv6]DRAM/SRAM flow :%d trap to CPU! Should check shortCut",flowMatchIdx);
			goto SEARCH_SW_FLOW;
		}
	}

	if((fc_db.shortcut_flow_count != 0))
	{
		if(!find)
		{
SEARCH_SW_FLOW:
			//search sw flow
			if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)]))
			{
				list_for_each_entry(pFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)], flow_list)
				{
					
					if(pFlowEntry->idx >(RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE) )
					{
							WARNING("strange flow idx!!! pFlowEntry->idx = %d, flowHashIdx[%d]",pFlowEntry->idx, flowHashIdx);
							break;
					}
					if((find = rtk_fc_flow_compareByIngressPktHdr(0, &fc_db.flowTbl[pFlowEntry->idx], pPktHdr)) == TRUE)
					{
						flowMatchIdx = pFlowEntry->idx;
						break;
					}
				}
			}

			if(find) searchResult = RTK_FC_FLOWENT_SEARCH_SW;
		}
	}

	if(find && (flowMatchIdx < (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE)))
	{
#if defined(CONFIG_RTL9607C_SERIES) && defined(CONFIG_RTL9603CVD_SERIES)	
		// In order to share an image between 9607C and 9603CVD
		{
			rtk_fc_tableFlowEntry_t *pFlowEntry_tmp = pFlowTable->pFlowEntry;
			memcpy(pFlowTable, &fc_db.flowTbl[flowMatchIdx], sizeof(*pFlowTable));
			pFlowTable->pFlowEntry = pFlowEntry_tmp;
			memcpy(pFlowTable->pFlowEntry, fc_db.flowTbl[flowMatchIdx].pFlowEntry, sizeof(rtk_fc_tableFlowEntry_t));
			_rtk_fc_sharing_image_flow_structure_convert(&pFlowTable->pFlowEntry->path1);
		}
#else
		memcpy(pFlowTable, &fc_db.flowTbl[flowMatchIdx], sizeof(*pFlowTable));
#endif
		TRACE("Hit %s flow[%d], flowHashIdx[%d]", (flowMatchIdx<fc_db.flowHwTableSize)?"Hw":"Sw", flowMatchIdx, flowHashIdx);
		//record matched flow index in pktHdr
		*flowTblIdx= flowMatchIdx;
		fc_db.flowTbl[flowMatchIdx].swTrfBit = TRUE;

	}
	else
		TRACE("Does not find flow entry by using ingress pattern, flowHashIdx[%d]", flowHashIdx);


	if(find && pFlowTable && pFlowTable->pFlowEntry && (pFlowTable->pFlowEntry->path3.in_path<=FB_PATH_34) && (pFlowTable->pFlowEntry->path3.out_multiple_act==1))
	{

		flowMatchIdx_mutiAction = _rtk_fc_sw_flowHashIndexStep2_get(flowHashIdx);
		for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
		{
			if((find_mutiAct = rtk_fc_flow_compareByIngressPktHdr(1, &fc_db.flowTbl[flowMatchIdx_mutiAction+i], pPktHdr)) == TRUE)
			{
				flowMatchIdx_mutiAction = (flowMatchIdx_mutiAction+i);
				break;
			}
		}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		if(rgpro_db.fbMode==FB_MODE_4K && !find_mutiAct)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[flowMatchIdx_mutiAction>>fc_db.flowHashWayShift]))
			{
				list_for_each_entry(pFlowTcamEntry, &fc_db.flowTcam_hashListHead[flowMatchIdx_mutiAction>>fc_db.flowHashWayShift], flowTcam_list)
				{
					if((find_mutiAct = rtk_fc_flow_compareByIngressPktHdr(1, &fc_db.flowTbl[pFlowTcamEntry->idx], pPktHdr)) == TRUE)
					{
						flowMatchIdx_mutiAction = pFlowTcamEntry->idx;
						break;
					}
				}
			}
		}
#endif
		if(find_mutiAct) searchResult_multiAction = RTK_FC_FLOWENT_SEARCH_HW;

		if(fc_db.shortcut_flow_count != 0)
		{
			if(!find_mutiAct)
			{
				//search sw flow
				if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowMatchIdx_mutiAction)]))
				{
					list_for_each_entry(pFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowMatchIdx_mutiAction)], flow_list)
					{
						
						if((find_mutiAct = rtk_fc_flow_compareByIngressPktHdr(1, &fc_db.flowTbl[pFlowEntry->idx], pPktHdr)) == TRUE)
						{
							flowMatchIdx_mutiAction = pFlowEntry->idx;
							break;
						}
					}
				}

				if(find_mutiAct) searchResult_multiAction = RTK_FC_FLOWENT_SEARCH_SW;
			}
		}


		if(find_mutiAct)
		{
#if defined(CONFIG_RTL9607C_SERIES) && defined(CONFIG_RTL9603CVD_SERIES)		
			// In order to share an image between 9607C and 9603CVD
			{
				rtk_fc_tableFlowEntry_t *pFlowEntry_tmp = pFlowTable_mutiAction->pFlowEntry;
				memcpy(pFlowTable_mutiAction, &fc_db.flowTbl[flowMatchIdx_mutiAction], sizeof(*pFlowTable_mutiAction));
				pFlowTable_mutiAction->pFlowEntry = pFlowEntry_tmp;
				memcpy(pFlowTable_mutiAction->pFlowEntry, fc_db.flowTbl[flowMatchIdx_mutiAction].pFlowEntry, sizeof(rtk_fc_tableFlowEntry_t));
				_rtk_fc_sharing_image_flow_structure_convert(&pFlowTable_mutiAction->pFlowEntry->path1);
			}
#else
			memcpy(pFlowTable_mutiAction, &fc_db.flowTbl[flowMatchIdx_mutiAction], sizeof(*pFlowTable_mutiAction));
#endif
			*flowTblMutiActIdx= flowMatchIdx_mutiAction;
			TRACE("Hit multi-Action %s flow[%d], flowHashIdx[%d]", (flowMatchIdx_mutiAction<fc_db.flowHwTableSize)?"Hw":"Sw", flowMatchIdx_mutiAction, flowHashIdx);
			fc_db.flowTbl[flowMatchIdx_mutiAction].swTrfBit = TRUE;

			if(searchResult_multiAction==RTK_FC_FLOWENT_SEARCH_SW)
				searchResult = RTK_FC_FLOWENT_SEARCH_SW;
		}
	}

	return searchResult;
}
#endif

bool _rtk_fc_flow_isTheSamePatternExist_get(int32 checkFlowIdx, uint32 flowHashIdx , uint8 isMulticast, uint32 *theSamePtnFlowIdx)
{
	uint32 i, search_index;
#if defined(CONFIG_FC_RTL8277C_SERIES)
	uint32 baseHwFlowIdx = (flowHashIdx & fc_db.flowEntIdxMask) / (RTK_FC_TABLESIZE_HASH_FLOW_MAX/RTK_FC_TABLESIZE_HASH_FLOW);
#else
	uint32 baseHwFlowIdx = flowHashIdx;
#endif

	*theSamePtnFlowIdx = FAIL;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)
	if(FLOW_INFO_IS_SET(&fc_db.flowTbl[checkFlowIdx], FLOW_INFO_ACL_PRI_FWD) == 0)
		goto SEARCH_SW_FLOW;	// the same pattern flow must exist in SW flow
#endif

	for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
	{
		search_index = baseHwFlowIdx+i;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
		if(fc_db.flowTbl[search_index].candidateState==CANDIDATE_STATE_NONE)
#else
		if(fc_db.flowTbl[search_index].pFlowEntry->path1.valid==0)
#endif
		{
			continue;
		}

		if(checkFlowIdx == search_index)
			continue;

		if(_rtk_fc_flow_matchOrNot_tblEntry(&fc_db.flowTbl[search_index], &fc_db.flowTbl[checkFlowIdx]))
		{
			*theSamePtnFlowIdx = search_index;
			return TRUE;
		}
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if(rgpro_db.fbMode==FB_MODE_4K)
	{
		rtk_fc_flowTcam_linkList_t *pFlowTcamEntry, *pNextFlowTcamEntry;

		if(!list_empty(&fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift]))
		{
			list_for_each_entry_safe(pFlowTcamEntry, pNextFlowTcamEntry, &fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift], flowTcam_list)
			{
				search_index = pFlowTcamEntry->idx;

				if(checkFlowIdx == search_index)
					continue;
				
				if(_rtk_fc_flow_matchOrNot_tblEntry(&fc_db.flowTbl[search_index], &fc_db.flowTbl[checkFlowIdx]))
				{
					*theSamePtnFlowIdx = search_index;
					return TRUE;
				}
			}
		}
	}
#endif
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	{
		rtk_fc_overFlowHash_linkList_t *pOverFlowEntry, *pNextOverFlowEntry;
		//search overflow entry
		if(!list_empty(&fc_db.overFlowHash_inUseListHead))
		{
			list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
			{
				search_index = pOverFlowEntry->idx;

				if(checkFlowIdx == search_index)
					continue;

				if(_rtk_fc_flow_matchOrNot_tblEntry(&fc_db.flowTbl[search_index], &fc_db.flowTbl[checkFlowIdx]))
				{
					*theSamePtnFlowIdx = search_index;
					return TRUE;
				}
			}
		}
	}
#endif

#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)
SEARCH_SW_FLOW:
#endif
	if(fc_db.shortcut_flow_count > 0)
	{
		rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;

		if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)]))
		{
			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)], flow_list)	//just return the first entry right behind of head
			{
				search_index = pFlowEntry->idx;

				if(checkFlowIdx == search_index)
					continue;
				
				if(_rtk_fc_flow_matchOrNot_tblEntry(&fc_db.flowTbl[search_index], &fc_db.flowTbl[checkFlowIdx]))
				{
					*theSamePtnFlowIdx = search_index;
					return TRUE;
				}
			}
		}
	}

	return FALSE;
}

#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
rtk_fc_ret_t rtk_fc_flow_dummyPktBuffer_alloc(void)
{
	int i = 0;

	if(flow_dummy_data == NULL){
		flow_dummy_data = kmem_cache_create("flow_dummy_data", sizeof(rtk_fc_igrDummyData_t), 0, 0, NULL);
		if (flow_dummy_data == NULL)
			return -ENOMEM;


		for(i=0; i<fc_db.flowSwTableSize; i++){
			fc_db.flowTbl[i].dummyPkt = kmem_cache_alloc(flow_dummy_data, GFP_ATOMIC);

			if(fc_db.flowTbl[i].dummyPkt==NULL)
				goto OOM;
		}
	}
	return (RTK_FC_RET_OK);

OOM:
	WARNING("malloc fail, free allocated buffers and disable dummy packet mechanism");
	rtk_fc_flow_dummyPktBuffer_free();
	return (RTK_FC_RET_ERR);
}

rtk_fc_ret_t rtk_fc_flow_dummyPktBuffer_free(void)
{
	int i = 0;

	if(flow_dummy_data != NULL){
		for(i=0; i<fc_db.flowSwTableSize; i++){
			if(fc_db.flowTbl[i].dummyPkt!=NULL)
				kmem_cache_free(flow_dummy_data, fc_db.flowTbl[i].dummyPkt);
		}

		kmem_cache_destroy(flow_dummy_data);
		flow_dummy_data = NULL;
	}

	return (RTK_FC_RET_OK);
}
#endif

rtk_fc_ret_t rtk_fc_flow_skbDataReasm(rtk_fc_ingress_data_t *pFcIngressData, rtk_fc_pktHdr_t *pPktHdr, uint8 *pData)
{
	int off = 0;
	uint16 cvlanid_tci = 0,svlanid_tci = 0;
	struct pppoe_hdr *pPPPoEHdr = NULL;
	struct iphdr *iph = NULL;
	struct ipv6hdr *ip6h = NULL;
	struct tcphdr *tcph = NULL;
	struct udphdr *udph = NULL;
	__wsum tmp_csum = 0;

	bzero(pData,MAX_AUTOEXT_PKT_SIZE);
	//eth
	memcpy(pData+off, pFcIngressData->da, ETH_ALEN);
	off+=6;
	memcpy(pData+off, pFcIngressData->sa, ETH_ALEN);
	off+=6;

	// svlan/cvlan
	if(pFcIngressData->ingressTagif & SVLAN_TAGIF){
		svlanid_tci = pFcIngressData->srcSVlanId | pFcIngressData->srcSVlanPri<<VLAN_PRIO_SHIFT ;
		(*(uint16 *)(pData+off)) =  htons(fc_db.systemGlobal.stagTPID[pFcIngressData->srcSVlanTpid_sel]);
		(*(uint16 *)(pData+off+2)) =  htons(svlanid_tci);
		off+=4;
	}
	if(pFcIngressData->ingressTagif & CVLAN_TAGIF){
		cvlanid_tci = pFcIngressData->srcCVlanId | pFcIngressData->srcCVlanPri<<VLAN_PRIO_SHIFT ;
		(*(uint16 *)(pData+off)) =  htons(ETH_P_8021Q);
		(*(uint16 *)(pData+off+2)) =  htons(cvlanid_tci);
		off+=4;
	}
	//pppoe
	if(pFcIngressData->ingressTagif & PPPOE_TAGIF){
		(*(uint16 *)(pData+off)) = htons(ETH_P_PPP_SES);
		pPPPoEHdr = (struct pppoe_hdr *)(pData+off+2);
		pPPPoEHdr->ver = 1;
		pPPPoEHdr->type = 1;
		pPPPoEHdr->sid = htons(pFcIngressData->sessionId);
		off+=8;
		pPPPoEHdr->length = htons(MAX_AUTOEXT_PKT_SIZE - off);
	}

	//ipv4/ipv6
	if(pFcIngressData->ingressTagif & IPV6_TAGIF){

		FC_PARAM_CHK((pPktHdr->ip6h==NULL), RTK_FC_RET_ERR);

		if(pFcIngressData->ingressTagif & PPPOE_TAGIF)
			(*(uint16 *)(pData+off)) = htons(0x0057);
		else
			(*(uint16 *)(pData+off)) =  htons(ETH_P_IPV6);
		off+=2;
		ip6h = (struct ipv6hdr *)(pData+off);

		memcpy(ip6h, pPktHdr->ip6h, sizeof(struct ipv6hdr));

		if(pFcIngressData->ingressTagif & TCP_TAGIF)
			ip6h->nexthdr = IPPROTO_TCP;
		else if(pFcIngressData->ingressTagif & UDP_TAGIF)
			ip6h->nexthdr = IPPROTO_UDP;

		off +=(sizeof(struct ipv6hdr));
		ip6h->payload_len =htons(MAX_AUTOEXT_PKT_SIZE-off);

		ip6h->hop_limit=64;
		ip6h->priority = pFcIngressData->v6tos>>4;
		ip6h->flow_lbl[0]&=0x0f;
		ip6h->flow_lbl[0]|= (pFcIngressData->v6tos&0xf)<<4;

	}else if(pFcIngressData->ingressTagif & IPV4_TAGIF){
		if(pFcIngressData->ingressTagif & PPPOE_TAGIF)
			(*(uint16 *)(pData+off)) = htons(0x0021);
		else
			(*(uint16 *)(pData+off)) =  htons(ETH_P_IP);
		off+=2;
		iph = (struct iphdr *)(pData+off);
		iph->check = 0;//init to zero
		iph->version = 0x4;
		iph->ihl = 5;
		iph->tot_len = htons(MAX_AUTOEXT_PKT_SIZE-off);
		iph->saddr = htonl(pFcIngressData->srcIp);
		iph->daddr = htonl(pFcIngressData->dstIp);
		iph->ttl = 64;
		iph->tos = pFcIngressData->v4tos;
		//iph->id = 0;
		if(pFcIngressData->ingressTagif & TCP_TAGIF)
			iph->protocol = IPPROTO_TCP;
		else if(pFcIngressData->ingressTagif & UDP_TAGIF)
			iph->protocol = IPPROTO_UDP;
		//checksum
		ip_send_check(iph);
		off+=20;
	}

	//tcp/udp
	if(pFcIngressData->ingressTagif & TCP_TAGIF){
		tcph = (struct tcphdr *)(pData+off);
		tcph->check=0;//init to zero
		tcph->source = htons(pFcIngressData->srcPort);
		tcph->dest = htons(pFcIngressData->dstPort);
		tcph->ack = 1;
		tcph->window = htons(8192);
		tmp_csum = csum_partial(tcph, MAX_AUTOEXT_PKT_SIZE-off, 0);
		if((pFcIngressData->ingressTagif & IPV4_TAGIF) && iph)
			tcph->check = tcp_v4_check(MAX_AUTOEXT_PKT_SIZE-off, iph->saddr, iph->daddr, tmp_csum);
		else if((pFcIngressData->ingressTagif & IPV6_TAGIF) && ip6h)
			tcph->check = tcp_v6_check(MAX_AUTOEXT_PKT_SIZE-off, &ip6h->saddr, &ip6h->daddr, tmp_csum);
	}
	else if(pFcIngressData->ingressTagif & UDP_TAGIF){
		udph = (struct udphdr *)(pData+off);
		udph->source = htons(pFcIngressData->srcPort);
		udph->dest = htons(pFcIngressData->dstPort);
		udph->len = htons(MAX_AUTOEXT_PKT_SIZE-off);
		udph->check = 0;	// no checksum
	}

	return (RTK_FC_RET_OK);
}


rtk_fc_ret_t rtk_fc_pppoe_netif_skbDataReasm(rtk_fc_tableNetif_t *pNetifEntry, rtk_fc_netifDummyPacket_t *pDummyPkt)
{
	int off = 0;
	uint8 *pData = (uint8 *)(pDummyPkt->dummyPkt);
	struct pppoe_hdr *pPPPoEHdr = NULL;
	rtk_fc_hwTableNetif_t *pNetifHwEntry = &(fc_db.netifHwTbl[pNetifEntry->hwIdx]);
	/*Generate an udp packet send from PPPoE server to WAN interface*/

	bzero(pData, MAX_AUTOEXT_PKT_SIZE);
	//eth
	//DA: PPPoE WAN interface MAC address
	memcpy(pData+off, &(pNetifEntry->intf.gateway_mac_addr.octet[0]), ETH_ALEN);
	off+=6;
	//SA: PPPoE server MAC address
	memcpy(pData+off, &(fc_db.lutTbl[pNetifHwEntry->pppoeGwLutIdx]->l2Addr[0]), ETH_ALEN);
	off+=6;

	//pppoe
	(*(uint16 *)(pData+off)) = htons(ETH_P_PPP_SES);
	pPPPoEHdr = (struct pppoe_hdr *)(pData+off+2);
	pPPPoEHdr->ver = 1;
	pPPPoEHdr->type = 1;
	pPPPoEHdr->sid = htons(pNetifEntry->intf.out_pppoe_sid);
	off+=8;
	pPPPoEHdr->length = htons(MAX_AUTOEXT_PKT_SIZE - off);

	(*(uint16 *)(pData+off)) = htons(0x0021);//PPP: ipv4
	pDummyPkt->dummyPktInit = 1;

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_pptp_netif_skbDataReasm(rtk_fc_tableNetif_t *pNetifEntry, rtk_fc_netifDummyPacket_t *pDummyPkt)
{
	int off = 0;
	uint8 *pData = (uint8 *)(pDummyPkt->dummyPkt);
	struct iphdr *iph = NULL;
	struct udphdr *udph=NULL;
	struct iphdr *iph_inner = NULL;

	rtk_fc_pptp_gre_header_t *pptp_gre_header=NULL;
	rtk_fc_ppp_header_t *ppp_header = NULL;

	rtk_fc_hwTableNetif_t *pNetifHwEntry = &(fc_db.netifHwTbl[pNetifEntry->hwIdx]);
	
	bzero(pData, MAX_AUTOEXT_PKT_SIZE);
	//eth
	memcpy(pData+off, &(fc_db.lutTbl[fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_dmac_lut_idx]->l2Addr[0]), ETH_ALEN);
	off+=6;
	memcpy(pData+off, &(fc_db.lutTbl[fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_smac_lut_idx]->l2Addr[0]), ETH_ALEN);
	off+=6;

	//pppoe
	(*(uint16 *)(pData+off)) = htons(ETH_P_IP);
	iph = (struct iphdr *)(pData+off+2);

	iph->version  = (4);
	iph->ihl      = (5);
	iph->tos      = (0);
	iph->tot_len  = htons(64);
	iph->id       = htons(0);
	iph->frag_off = htons(0);
	iph->ttl      = (64);
	iph->protocol = (47);
	iph->check    = htons(0);
	iph->saddr    = htonl(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_src_ipv4_addr);
	iph->daddr    = htonl(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_dst_ipv4_addr);
	
	pptp_gre_header = (rtk_fc_pptp_gre_header_t *)(pData+off+2+20);
	pptp_gre_header->flags       = htons(0x3001);
	pptp_gre_header->protocol    = htons(0x880b);
	pptp_gre_header->payload_len = htons(32);
	pptp_gre_header->call_id     = htons(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_gre_call_id);
	pptp_gre_header->seq         = htonl(0);

	///Point-to-Point Protocol
	ppp_header = (rtk_fc_ppp_header_t * )(pData+off+2+20+12);
	ppp_header->address  = (0xff);
	ppp_header->control  = (0x03);
	ppp_header->protocol = htons(0x0021);
	//(*(uint16*)(pData+off+2+20+12))   = htons(0xff03);
	//(*(uint16*)(pData+off+2+20+12+2)) = htons(0x0021);

	iph_inner = (struct iphdr *)(pData+off+2+20+12+4);
	iph_inner->version  = 4;
	iph_inner->ihl      = 5;
	iph_inner->tos      = 0;
	iph_inner->tot_len  = htons(28);
	iph_inner->id       = htons(0);
	iph_inner->frag_off = htons(0);
	iph_inner->ttl      = 64;
	iph_inner->protocol = IPPROTO_UDP;
	iph_inner->check    = htons(0);
	iph_inner->saddr    = htonl(0x08080808);//8.8.8.8
	iph_inner->daddr    = htonl(pNetifHwEntry->intf.gateway_ipv4_addr);

	udph = (struct udphdr *)(pData+off+2+20+12+2+2+20);
	udph->source = htons(0x56ce); //random e.g. 22222
	udph->dest   = htons(0x2b67); //random e.g. 11111
	udph->len    = htons(8);
	udph->check  = htons(0);
	pDummyPkt->dummyPktInit = 1;

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_l2tp_netif_skbDataReasm(rtk_fc_tableNetif_t *pNetifEntry, rtk_fc_netifDummyPacket_t *pDummyPkt)
{
	int off = 0;
	uint8 *pData = (uint8 *)(pDummyPkt->dummyPkt);
	struct iphdr *iph = NULL;
	struct udphdr *outer_udph=NULL, *inner_udph=NULL;
	struct iphdr *iph_inner = NULL;
	rtk_fc_l2tp_header_t *l2tph = NULL;
	rtk_fc_ppp_header_t *ppp_header = NULL;
	rtk_fc_hwTableNetif_t *pNetifHwEntry = &(fc_db.netifHwTbl[pNetifEntry->hwIdx]);

	bzero(pData, MAX_AUTOEXT_PKT_SIZE);
	//eth
	
	memcpy(pData+off, &(fc_db.lutTbl[fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_dmac_lut_idx]->l2Addr[0]), ETH_ALEN);
	off+=6;
	memcpy(pData+off, &(fc_db.lutTbl[fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_smac_lut_idx]->l2Addr[0]), ETH_ALEN);
	off+=6;

	//pppoe
	(*(uint16 *)(pData+off)) = htons(ETH_P_IP);
	iph = (struct iphdr *)(pData+off+2);

	iph->version  = 4;
	iph->ihl      = 5;
	iph->tos      = 0;
	iph->tot_len  = htons(86);
	iph->id       = htons(0);
	iph->frag_off = htons(0);
	iph->ttl      = 64;
	iph->protocol = 17;
	iph->check    = htons(0);
	iph->saddr    = htonl(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_src_ipv4_addr);
	iph->daddr    = htonl(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_dst_ipv4_addr);

	outer_udph = (struct udphdr *)(pData+off+2+20);
	outer_udph->source = htons(0x06a5); //sport 1701
	outer_udph->dest   = htons(0x06a5); //dport 1701
	outer_udph->len    = htons(46);
	outer_udph->check  = htons(0);

	l2tph = (rtk_fc_l2tp_header_t *)(pData+off+2+20+8);
	l2tph->pack_type  = htons(0x0002);
	l2tph->tunnul_id  = htons(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_l2tp_tunnel_id);
	l2tph->session_id = htons(fc_db.flowTbl[pNetifHwEntry->outerHdrFlowIdx].pFlowEntry->path6.in_l2tp_session_id);

	///Point-to-Point Protocol
	ppp_header = (rtk_fc_ppp_header_t * )(pData+off+2+20+8+6);
	ppp_header->address  = (0xff);
	ppp_header->control  = (0x03);
	ppp_header->protocol = htons(0x0021);
	//(*(uint16*)(pData+off+2+20+8+6))   = htons(0xff03);
	//(*(uint16*)(pData+off+2+20+8+6+2)) = htons(0x0021);
	
	iph_inner = (struct iphdr *)(pData+off+2+20+8+6+4);
	iph_inner->version  = 4;
	iph_inner->ihl      = 5;
	iph_inner->tos      = 0;
	iph_inner->tot_len  = htons(28);
	iph_inner->id       = htons(0);
	iph_inner->frag_off = htons(0);
	iph_inner->ttl      = 254;
	iph_inner->protocol = IPPROTO_UDP;
	iph_inner->check    = htons(0);
	iph_inner->saddr    = htonl(0x08080808);//8.8.8.8
	iph_inner->daddr    = htonl(pNetifHwEntry->intf.gateway_ipv4_addr);

	inner_udph = (struct udphdr *)(pData+off+2+20+8+6+2+2+20);
	inner_udph->source = htons(0x56ce); //random e.g. 22222
	inner_udph->dest   = htons(0x2b67); //random e.g. 11111
	inner_udph->len    = htons(8);
	inner_udph->check  = htons(0);


	pDummyPkt->dummyPktInit = 1;

	return (RTK_FC_RET_OK);
}

#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
rtk_fc_ret_t rtk_fc_flow_autoExtendByDummyPkt(rtk_fc_tableFlow_t *pFlowTable)
{
	struct sk_buff *skb = NULL;
	struct rt_skbuff *rtskb, rtSKB;

	FC_PARAM_CHK(pFlowTable==NULL, RTK_FC_RET_ERR_NULL_POINTER);
	FC_PARAM_CHK(pFlowTable->pFlowEntry==NULL, RTK_FC_RET_ERR_NULL_POINTER);
	FC_PARAM_CHK(pFlowTable->srcDev==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
	FC_PARAM_CHK(pFlowTable->dummyPkt==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	RTK_FC_HOOK_PS_SKB_DEV_ALLOC_SKB(SKB_BUF_SIZE, &skb);
	if(skb==NULL)
		return RTK_FC_RET_ERR;

	rtskb = &rtSKB;
	RTK_FC_HOOK_CONVERTER_SKB(skb, rtskb);

	RTSKB_DEV(rtskb)= pFlowTable->srcDev;
	RTK_FC_HOOK_PS_SKB_SKB_PUT(RTSKB_SKB(rtskb),MAX_AUTOEXT_PKT_SIZE,&RTSKB_DATA(rtskb));


	memcpy(RTSKB_DATA(rtskb), pFlowTable->dummyPkt, RTSKB_LEN(rtskb));

	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));
	
	RTSKB_FROMDEV(rtskb)= RTSKB_DEV(rtskb);

	RTK_FC_HOOK_PS_SKB_ETH_TYPE_TRANS(RTSKB_SKB(rtskb), RTSKB_DEV(rtskb));
	RTSKB_FCIGRDATA(rtskb)->isDummyPkt = TRUE;
	RTSKB_FCIGRDATA(rtskb)->ingressPort = RTK_FC_MAC_PORT_MAINCPU;
	atomic_inc(&fc_db.statistic.perPortCnt_dummpPktAlloc[RTSKB_FCIGRDATA(rtskb)->ingressPort]);

	TIMER("[KeepAlive] send dummy pkt via netdev %s, proto = 0x%x", RTSKB_DEV(rtskb)->name, RTSKB_PROTOCOL(rtskb));

	DUMP_PACKET(RTSKB_DATA(rtskb), RTSKB_LEN(rtskb), "flow sync data");

	if(RTK_FC_HOOK_PS_SKB_NETIF_RX(RTSKB_SKB(rtskb))== NET_RX_DROP){
		WARNING("[KeepAlive] send dummy pkt fail, dev = %s", RTSKB_DEV(rtskb)->name);
	}

	return (RTK_FC_RET_OK);
}
#endif

rtk_fc_ret_t rtk_fc_pppoe_netif_autoExtendByDummyPkt(rtk_fc_tableNetif_t *pNetifEntry, rtk_fc_netifDummyPacket_t *pDummyPkt)
{
	int i;
	struct sk_buff *skb = NULL;
	struct net_device *dev = NULL;
	struct rt_skbuff *rtskb, rtSKB;
	
	FC_PARAM_CHK(pNetifEntry==NULL, RTK_FC_RET_ERR_NULL_POINTER);
	FC_PARAM_CHK(pNetifEntry->dev==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	/*send the ICMP echo request from PPPoE server to WAN interface*/
	RTK_FC_HOOK_PS_SKB_DEV_ALLOC_SKB(SKB_BUF_SIZE, &skb);
	if(skb==NULL)
		return RTK_FC_RET_ERR;

	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(!fc_db.netifTbl[i].intf.valid)
			continue;
		// ppp over ethnet dev. so we need to find the ethernet dev and do rx to ps.
		if((fc_db.netifTbl[i].intf.out_pppoe_act != FB_NETIFPPPOE_ACT_ADD) &&
			(!memcmp(&fc_db.netifTbl[i].intf.gateway_mac_addr.octet[0], &pNetifEntry->intf.gateway_mac_addr, ETH_ALEN)) )
		{
			if(RTK_FC_HOOK_PS_DEV_NETIF_RUNNING(fc_db.netifTbl[i].dev))
			{
				dev = fc_db.netifTbl[i].dev;
				break;
			}
		}
	}

	if (!dev)
	{
		WARNING("[KeepAlive] send PPPoE auto extend dummy pkt fail: Not find corresponding interface for %s", pNetifEntry->dev->name);
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(skb);
		return (RTK_FC_RET_ERR);
	}
	else
	{
		TIMER("[KeepAlive] send PPPoE auto extend dummy pkt by interface %s\n", dev->name);
	}

	
	rtskb = &rtSKB;
	RTK_FC_HOOK_CONVERTER_SKB(skb, rtskb);

	RTSKB_DEV(rtskb)= dev;
	RTK_FC_HOOK_PS_SKB_SKB_PUT(RTSKB_SKB(rtskb),MAX_AUTOEXT_PKT_SIZE,&RTSKB_DATA(rtskb));
	
	memcpy(RTSKB_DATA(rtskb), pDummyPkt->dummyPkt, RTSKB_LEN(rtskb));
	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

	DUMP_PACKET(RTSKB_DATA(rtskb), RTSKB_LEN(rtskb), "PPPoE auto extend data");

	RTSKB_FROMDEV(rtskb)= RTSKB_DEV(rtskb);

	RTK_FC_HOOK_PS_SKB_ETH_TYPE_TRANS(RTSKB_SKB(rtskb), RTSKB_DEV(rtskb));
	RTSKB_FCIGRDATA(rtskb)->isDummyPkt = TRUE;
	
	if(!fc_db.wanPortMask.portmask)
	{
		WARNING("[KeepAlive] WAN portmask is zero");
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(skb);
		return (RTK_FC_RET_ERR);
	}
	RTSKB_FCIGRDATA(rtskb)->ingressPort = __ffs(fc_db.wanPortMask.portmask);
	TIMER("[KeepAlive] send PPPoE WAN dummy pkt via netdev %s, proto = 0x%x", RTSKB_DEV(rtskb)->name, RTSKB_PROTOCOL(rtskb));

	RTK_FC_HOOK_PS_SKB_PARAM_SET(skb, RTK_FC_SKB_PARAM_PKTTYPE, PACKET_OTHERHOST); //make the packet be dropped by linux PS in the begining of ip_rcv().
	
	if(RTK_FC_HOOK_PS_SKB_NETIF_RX(RTSKB_SKB(rtskb))== NET_RX_DROP) {
		WARNING("[KeepAlive] send PPPoE auto extend dummy pkt fail, dev = %s", RTSKB_DEV(rtskb)->name);
	}
	return (RTK_FC_RET_OK);
}
rtk_fc_ret_t rtk_fc_pptp_netif_autoExtendByDummyPkt(rtk_fc_tableNetif_t *pNetifEntry, rtk_fc_netifDummyPacket_t *pDummyPkt)
{
	int i;
	struct sk_buff *skb = NULL;
	struct net_device *dev = NULL;
	struct rt_skbuff *rtskb, rtSKB;
	
	FC_PARAM_CHK(pNetifEntry==NULL, RTK_FC_RET_ERR_NULL_POINTER);
	FC_PARAM_CHK(pNetifEntry->dev==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	RTK_FC_HOOK_PS_SKB_DEV_ALLOC_SKB(SKB_BUF_SIZE, &skb);
	if(skb==NULL)
		return RTK_FC_RET_ERR;

	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].hwIdx==FAIL)
			continue;
		if((fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].dualType == RTK_FC_DUALTYPE_PPTP) &&
			(fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0) )
		{
			if(RTK_FC_HOOK_PS_DEV_NETIF_RUNNING(fc_db.netifTbl[i].dev))
			{
				dev = fc_db.netifTbl[i].dev;
				//printk("DEV: %s\n",dev->name);
				break;
			}
		}
	}

	if (!dev)
	{
		WARNING("[KeepAlive] send PPTP auto extend dummy pkt fail: Not find corresponding interface for %s", pNetifEntry->dev->name);
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(skb);
		return (RTK_FC_RET_ERR);
	}
	else
	{
		TIMER("[KeepAlive] send PPTP auto extend dummy pkt by interface %s\n", dev->name);
	}

	rtskb = &rtSKB;
	RTK_FC_HOOK_CONVERTER_SKB(skb, rtskb);

	RTSKB_DEV(rtskb)= dev;
	RTK_FC_HOOK_PS_SKB_SKB_PUT(RTSKB_SKB(rtskb),MAX_AUTOEXT_PKT_SIZE,&RTSKB_DATA(rtskb));

	memcpy(RTSKB_DATA(rtskb), pDummyPkt->dummyPkt, RTSKB_LEN(rtskb));
	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

	DUMP_PACKET(RTSKB_DATA(rtskb), RTSKB_LEN(rtskb), "PPTP auto extend data");

	RTSKB_FROMDEV(rtskb)= RTSKB_DEV(rtskb);

	RTK_FC_HOOK_PS_SKB_ETH_TYPE_TRANS(RTSKB_SKB(rtskb), RTSKB_DEV(rtskb));
	RTSKB_FCIGRDATA(rtskb)->isDummyPkt = TRUE;

	if(!fc_db.wanPortMask.portmask)
	{
		WARNING("[KeepAlive] WAN portmask is zero");
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(skb);
		return (RTK_FC_RET_ERR);
	}
	RTSKB_FCIGRDATA(rtskb)->ingressPort = __ffs(fc_db.wanPortMask.portmask);
	TIMER("[KeepAlive] send PPTP WAN dummy pkt via netdev %s, proto = 0x%x",  RTSKB_DEV(rtskb)->name, RTSKB_PROTOCOL(rtskb));

	RTK_FC_HOOK_PS_SKB_PARAM_SET(skb, RTK_FC_SKB_PARAM_PKTTYPE, PACKET_OTHERHOST); //make the packet be dropped by linux PS in the begining of ip_rcv().
	
	if(RTK_FC_HOOK_PS_SKB_NETIF_RX(RTSKB_SKB(rtskb))== NET_RX_DROP) {
		WARNING("[KeepAlive] send PPTP auto extend dummy pkt fail, dev = %s", RTSKB_DEV(rtskb)->name);
	}
	
	return (RTK_FC_RET_OK);
}
rtk_fc_ret_t rtk_fc_l2tp_netif_autoExtendByDummyPkt(rtk_fc_tableNetif_t *pNetifEntry, rtk_fc_netifDummyPacket_t *pDummyPkt)
{
	int i;
	struct sk_buff *skb = NULL;
	struct net_device *dev = NULL;
	struct rt_skbuff *rtskb, rtSKB;
	
	FC_PARAM_CHK(pNetifEntry==NULL, RTK_FC_RET_ERR_NULL_POINTER);
	FC_PARAM_CHK(pNetifEntry->dev==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	RTK_FC_HOOK_PS_SKB_DEV_ALLOC_SKB(SKB_BUF_SIZE, &skb);
	if(skb==NULL)
		return RTK_FC_RET_ERR;

	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].hwIdx==FAIL)
			continue;
		if((fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].dualType == RTK_FC_DUALTYPE_L2TP) &&
			(fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0) )
		{
			if(RTK_FC_HOOK_PS_DEV_NETIF_RUNNING(fc_db.netifTbl[i].dev))
			{
				dev = fc_db.netifTbl[i].dev;
				//printk("DEV: %s\n",dev->name);
				break;
			}
		}
	}

	if (!dev)
	{
		WARNING("[KeepAlive] send L2TP auto extend dummy pkt fail: Not find corresponding interface for %s", pNetifEntry->dev->name);
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(skb);
		return (RTK_FC_RET_ERR);
	}
	else
	{
		TIMER("[KeepAlive] send L2TP auto extend dummy pkt by interface %s\n", dev->name);
	}

	rtskb = &rtSKB;
	RTK_FC_HOOK_CONVERTER_SKB(skb, rtskb);

	RTSKB_DEV(rtskb)= dev;
	RTK_FC_HOOK_PS_SKB_SKB_PUT(RTSKB_SKB(rtskb),MAX_AUTOEXT_PKT_SIZE,&RTSKB_DATA(rtskb));

	memcpy(RTSKB_DATA(rtskb), pDummyPkt->dummyPkt, RTSKB_LEN(rtskb));
	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

	DUMP_PACKET(RTSKB_DATA(rtskb), RTSKB_LEN(rtskb), "L2TP auto extend data");

	RTSKB_FROMDEV(rtskb)= RTSKB_DEV(rtskb);

	RTK_FC_HOOK_PS_SKB_ETH_TYPE_TRANS(RTSKB_SKB(rtskb), RTSKB_DEV(rtskb));
	RTSKB_FCIGRDATA(rtskb)->isDummyPkt = TRUE;

	if(!fc_db.wanPortMask.portmask)
	{
		WARNING("[KeepAlive] WAN portmask is zero");
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(skb);
		return (RTK_FC_RET_ERR);
	}
	RTSKB_FCIGRDATA(rtskb)->ingressPort = __ffs(fc_db.wanPortMask.portmask);
	TIMER("[KeepAlive] send L2TP WAN dummy pkt via netdev %s, proto = 0x%x",  RTSKB_DEV(rtskb)->name, RTSKB_PROTOCOL(rtskb));

	RTK_FC_HOOK_PS_SKB_PARAM_SET(skb, RTK_FC_SKB_PARAM_PKTTYPE, PACKET_OTHERHOST); //make the packet be dropped by linux PS in the begining of ip_rcv().
	
	if(RTK_FC_HOOK_PS_SKB_NETIF_RX(RTSKB_SKB(rtskb))== NET_RX_DROP) {
		WARNING("[KeepAlive] send PPTP auto extend dummy pkt fail, dev = %s", RTSKB_DEV(rtskb)->name);
	}
	
	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t rtk_fc_flow_updateTimer_and_checkTimeout(int idx, unsigned char trfBit)
{
	rtk_fc_tableFlow_t *pFlowTable;
	int elapsedTime;
	int32 forceUpdate=FALSE;
	char pathNum = 0;
	struct nf_conn *pCT;


#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_RTK_L34_G3_PLATFORM)
	elapsedTime = fc_db.flowSyncPeriod_unit1s;
#else
	elapsedTime = (RTK_FC_TIMER_TICK_SECOND*RTK_FC_HOUSEKEEP_MAX_SELECT);
#endif
	if(idx<0 || idx>=fc_db.flowSwTableSize)
	{
		WARNING("flow idx[%d] is out of range", idx);
		return (RTK_FC_RET_ERR_INVALID_PARAM);
	}

	TIMER("update timer of flow[%d], trfbit = %d by cpu[%d]", idx, trfBit, smp_processor_id());

	pFlowTable = &fc_db.flowTbl[idx];
	if(FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_MC_ENTRY))
		forceUpdate = FALSE;
	else
		forceUpdate = FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_STATIC_ENTRY)?TRUE:FALSE;

	pathNum = _rtk_fc_flowPath_get(pFlowTable->pFlowEntry);

	if(pFlowTable->needUpdate && !trfBit && !forceUpdate)
	{
		TIMER("[Path %d] flow[%d] needs to be updated, delete it", pathNum, idx);
		goto FLOW_TIMEOUT;
	}


	if(pFlowTable->pAbstrSwFlowEt)
	{
		goto IDLETIMEOUT_CHECK;
	}
	else	
	{
	
		switch(pFlowTable->pFlowEntry->path1.in_path)
		{
			case FB_PATH_12:
				goto IDLETIMEOUT_CHECK;
				break;
			case FB_PATH_34:
			case FB_PATH_5:
				if(FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_STATIC_ENTRY))
					goto IDLETIMEOUT_CHECK;
				/* For OVS, support all flow timeout by idlesecs*/
				if(FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_SKIP_CT) || (FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_MC_ENTRY)))
				{
					goto IDLETIMEOUT_CHECK;
				}
				/***************************************/
				pCT = rtk_fc_flow_ct_get(pFlowTable);
				
				if(pCT==NULL)
				{
					if(fc_db.controlFuc.house_keeping_flow_delete_immediatly==0)
					{
						TIMER("[Path %d] flow[%d]'s ct is NULL? go idle timeout", pathNum, idx);
						goto IDLETIMEOUT_CHECK;
					}
					else
					{
						TIMER("[Path %d] flow[%d]'s ct is NULL? go flow delete", pathNum, idx);
						goto FLOW_TIMEOUT;

					}
				}
				else
				{
					bool ct_alive = FALSE;
					RTK_FC_HOOK_PS_CT_SESSION_ALIVE_CHECK(pCT, &ct_alive);
					if(!ct_alive) {
						TIMER("[Path %d] flow[%d]'s ct is dying", pathNum, idx);
						rtk_fc_flow_ct_detach(pFlowTable);
						if(fc_db.controlFuc.house_keeping_flow_delete_immediatly==0)
							goto IDLETIMEOUT_CHECK;
						else
							goto FLOW_TIMEOUT;
					}

					if(trfBit || forceUpdate)
					{
						pFlowTable->idleSecs = 0; // for /proc/fc/ctrl/flow_not_update_in_real_time
						TIMER("[Path %d] flow[%d] trf bit = 1, use = %d, ct stats 0x%lx", pathNum, idx, pCT->ct_general.use.counter, RTK_FC_HOOK_PS_CT_STATUS_GET(pCT));	// for debug
						// Traffic detected
						if (RTK_FC_HOOK_PS_CT_REFRESH(pCT) != SUCCESS) {
							TIMER("[Path %d] flow[%d] ct refresh is fail", pathNum, idx);
							rtk_fc_flow_ct_detach(pFlowTable);
							if(fc_db.controlFuc.house_keeping_flow_delete_immediatly==0)
								goto IDLETIMEOUT_CHECK;
							else
								goto FLOW_TIMEOUT;
								
						}
					}else{
						pFlowTable->idleSecs += elapsedTime; // for /proc/fc/ctrl/flow_not_update_in_real_time
						TIMER("[Path %d] flow[%d] trf bit = 0, use = %d, ct stats 0x%lx", pathNum, idx, pCT->ct_general.use.counter, RTK_FC_HOOK_PS_CT_STATUS_GET(pCT));	// for debug
					}
				}
				break;
			case FB_PATH_6:
			default:
				break;
		}
	}

	return (RTK_FC_RET_OK);
	
IDLETIMEOUT_CHECK:
	if(trfBit || forceUpdate)
	{
		//The traffic bit of this PATH1/2 flow entry is enabled, clear the flow idleSecs.
		pFlowTable->idleSecs = 0;
		if(pFlowTable->pAbstrSwFlowEt)
		{
			TIMER("AbstrFlow Update flow[%d]'s idle time to 0.", idx);
			if(pFlowTable->lutEgrDaIdx !=FAIL &&     pFlowTable->lutEgrDaIdx<   RTK_FC_TABLESIZE_LUT)
			{
				TIMER("AbstrFlow Update lut[%d]'s idle time to 0.", pFlowTable->lutEgrDaIdx);
				fc_db.lutTbl[pFlowTable->lutEgrDaIdx]->last_jiffies = jiffies;
			}
		}
		else
		{
			TIMER("[Path %d] Update flow[%d]'s idle time to 0.", pathNum, idx);
		}
#if defined(CONFIG_FC_FLOW_AUTO_EXTEND)
		if(fc_db.controlFuc.flow_sessionAutoExtend){
			rtk_fc_flow_autoExtendByDummyPkt(pFlowTable);
		}
#endif
	}
	else
	{

		pFlowTable->idleSecs += elapsedTime;
		if(FLOW_INFO_IS_SET(pFlowTable, FLOW_INFO_MC_ENTRY))
		{

			if(pFlowTable->idleSecs >= fc_db.mcTimeout_unit1s)
			{
				TIMER("[Path %d] flow[%d]'s idle time(%d) >= timeout(%d), delete it", pathNum, idx, pFlowTable->idleSecs, fc_db.mcTimeout_unit1s);
				goto FLOW_TIMEOUT;
			}
			TIMER("[Path %d] flow[%d]'s idle time = %d", pathNum, idx, pFlowTable->idleSecs);
		}
		else
		{
			if(pFlowTable->idleSecs >= fc_db.flowIdleTimeout_unit1s)
			{
				TIMER("[Path %d] flow[%d]'s idle time(%d) >= timeout(%d), delete it", pathNum, idx, pFlowTable->idleSecs, fc_db.flowIdleTimeout_unit1s);
				goto FLOW_TIMEOUT;
			}
			TIMER("[Path %d] flow[%d]'s idle time = %d", pathNum, idx, pFlowTable->idleSecs);
		}
	}


	return (RTK_FC_RET_OK);

FLOW_TIMEOUT:

	TIMER("Flow[%d] is timeout or update needed, delete it", idx);
	ASSERT_EQ_CONT(rtk_fc_flow_delete(idx), RTK_FC_RET_OK);

	return (RTK_FC_RET_ERR_FLOW_TIMEOUT);
}

int _rtk_fc_flowPath_get(rtk_fc_tableFlowEntry_t *pFlow)
{
	int pathNum = 6;

	if(pFlow->path1.in_path == 0){
		pathNum = 1;
	}else if(pFlow->path1.in_path == 1){
		pathNum = 3;
	}else if(pFlow->path1.in_path == 2){
		pathNum = 5;
	}
	if(pathNum!=6){
		if(pFlow->path1.in_multiple_act)
			pathNum++;
	}
	return pathNum;
}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
/*
*  Flow housekeeping for both HW and SW entry
*/
int _rtk_fc_flow_timeoutCheck(void)
{
	int i, wayPosi, sw_flow_list_idx, ret;
	uint32 startBucket, endBucket;
	int ftIdx,start,end;
	unsigned long long tcamTrfBits = 0;
	uint8 trfStatus = FALSE;
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
	rtk_fc_flowTcam_linkList_t *pFlowTcamEntry=NULL, *pFlowTcamNext=NULL;

	// bucket section
	startBucket = (fc_db.swFlow_hkCurIdx);
	endBucket = (fc_db.swFlow_hkCurIdx + RTK_FTCHECK_GRANULARITY);
	if(endBucket > (fc_db.flowHashBuckets)) endBucket = (fc_db.flowHashBuckets);

	// entry section
	start = (startBucket<<fc_db.flowHashWayShift);
	end = (endBucket<<fc_db.flowHashWayShift);

	bzero(fc_db.fb_hwFlow_trfBitsArray, sizeof(int)*(fc_db.flowHwTableSize>>5));
	bzero(fc_db.fb_hwFlow_tmpValidBitsArray, sizeof(int)*(fc_db.flowHwTableSize>>5));
	memcpy(&fc_db.fb_hwFlow_tmpValidBitsArray[start>>5], &fc_db.fb_hwFlow_validBitsArray[start>>5], sizeof(int)*((end-start)>>5));

	// get traffic bits according to validset, be careful to get(reset) interested entries only!!
	ret = rtk_rg_asic_flowTraffic_get(fc_db.fb_hwFlow_tmpValidBitsArray, fc_db.fb_hwFlow_trfBitsArray);
	if(ret != RT_ERR_OK)
	{
		return -1;
	}

	if((_rtk_rg_fbMode_get() == FB_MODE_4K) && (end > (RTK_FC_TABLESIZE_FLOWSRAM>>5)))	// if driver needs to scan TCAM traffic bits
	{
		rtk_rg_asic_camTraffic_get(&tcamTrfBits);
		fc_db.fb_hwFlow_trfBitsArray[(RTK_FC_TABLESIZE_FLOWSRAM>>5)] = (tcamTrfBits) & 0xffffffff;
		fc_db.fb_hwFlow_trfBitsArray[(RTK_FC_TABLESIZE_FLOWSRAM>>5)+1] = (tcamTrfBits >> 32) & 0xffffffff;
	}


	for(i=startBucket; i<endBucket; i++)
	{
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//

		// flow entries exist, scan each flow
		for(wayPosi=0; wayPosi<(1<<fc_db.flowHashWayShift); wayPosi++)
		{
			ftIdx = (i<<fc_db.flowHashWayShift) + wayPosi;
			
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[ftIdx].candidateState!=CANDIDATE_STATE_NONE)
#else
			if(fc_db.flowTbl[ftIdx].pFlowEntry->path1.valid)
#endif
			{
				trfStatus = (fc_db.flowTbl[ftIdx].swTrfBit || ((fc_db.fb_hwFlow_trfBitsArray[ftIdx>>5]>>(ftIdx&0x1f)) & 0x1))?TRUE:FALSE;
				fc_db.flowTbl[ftIdx].swTrfBit = FALSE;

				if(fc_db.flowTbl[ftIdx].pAbstrSwFlowEt)
				{
					//juset need update trfStatus to abstrSw Entry
					if(trfStatus)
						fc_db.flowTbl[fc_db.flowTbl[ftIdx].pAbstrSwFlowEt->swFlowIdx].swTrfBit=1;
				}
				else				
				{
					ret = rtk_fc_flow_updateTimer_and_checkTimeout(ftIdx, trfStatus);
					if(ret!=RTK_FC_RET_ERR_FLOW_TIMEOUT)
					{
						assert_ok(ret);
					}

				}

			}

		}
		
		// flush HW flow - TCAM
		if(rgpro_db.fbMode==FB_MODE_4K)
		{
			//search hw Tcam flow
			if(!list_empty(&fc_db.flowTcam_hashListHead[i]))
			{
				//TRACE("tcam hash list i = %d", i); for debugging later
				list_for_each_entry_safe(pFlowTcamEntry, pFlowTcamNext, &fc_db.flowTcam_hashListHead[i], flowTcam_list)
				{
					ftIdx = pFlowTcamEntry->idx;
					
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[ftIdx].candidateState!=CANDIDATE_STATE_NONE)
#else
					if(fc_db.flowTbl[ftIdx].pFlowEntry->path1.valid)
#endif
					{
						trfStatus = (fc_db.flowTbl[ftIdx].swTrfBit || ((fc_db.fb_hwFlow_trfBitsArray[ftIdx>>5]>>(ftIdx&0x1f)) & 0x1))?TRUE:FALSE;
						fc_db.flowTbl[ftIdx].swTrfBit = FALSE;

						if(fc_db.flowTbl[ftIdx].pAbstrSwFlowEt)
						{
							//juset need update trfStatus to abstrSw Entry
							if(trfStatus)
								fc_db.flowTbl[fc_db.flowTbl[ftIdx].pAbstrSwFlowEt->swFlowIdx].swTrfBit=1;
						}
						else				
						{
							ret = rtk_fc_flow_updateTimer_and_checkTimeout(ftIdx, trfStatus);
							if(ret!=RTK_FC_RET_ERR_FLOW_TIMEOUT)
							{
								assert_ok(ret);
							}

						}

					}

				}
			}
		}
		
		// scan SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(sw_flow_list_idx, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[sw_flow_list_idx]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[sw_flow_list_idx], flow_list)
				{
					ftIdx = pFlowEntry->idx;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
					if(fc_db.flowTbl[ftIdx].candidateState == CANDIDATE_STATE_NONE) continue;
#else
					if(fc_db.flowTbl[ftIdx].pFlowEntry->path1.valid==0) continue;
#endif
					ret = rtk_fc_flow_updateTimer_and_checkTimeout(ftIdx, fc_db.flowTbl[ftIdx].swTrfBit);
					fc_db.flowTbl[ftIdx].swTrfBit = FALSE;
					if(ret!=RTK_FC_RET_ERR_FLOW_TIMEOUT)
					{
						assert_ok(ret);
					}
				}
			}
		}
		
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
	}

	fc_db.swFlow_hkCurIdx = endBucket % fc_db.flowHashBuckets;
	
	return 0;
}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
/*
*  mainHash traffic bit update
*	8277c
*		- 32 timer ticks per flow_sync_period, 1 tick scan 256 bucket (2K entries)
*		- 32 entries as one traffic bit group
*/
int _rtk_fc_mainHashFlowTrf_update(void)
{
	uint32 i, start, end;
	uint32 trafficBit;
	int32 ret;

	start = (fc_db.g3_mHash_trf_hkCurIdx>>5);
	end = ((fc_db.g3_mHash_trf_hkCurIdx + RTK_MHASH_TRF_CHECK_GRANULARITY)>>5);
	if(((fc_db.flowHwTableSize>>5) - end) == ((RTK_FC_TABLESIZE_HW_FLOW - HASH_HASH_TBL_ENTRY_MAX)>>5) )
		end += ((RTK_FC_TABLESIZE_HW_FLOW - HASH_HASH_TBL_ENTRY_MAX)>>5);
	
	if(end > (fc_db.flowHwTableSize>>5)) 
		end = (fc_db.flowHwTableSize>>5);

	for(i=start; i< end; i++)
	{
		if(fc_db.g3_mHashTbl_validBitsArray[i]==0) continue;
		TIMER("checking mHashFlow array[%d] / (mashFlow traffic from %d to %d)", i, i<<5, (i<<5)+31);
		// flow entries exist, ge each flow
#if defined(CONFIG_FC_RTL8277C_SERIES)
		ret = rtk_8277c_asic_flow_traffic_get(i<<5, &trafficBit);
#else
		ret = ca_flow_traffic_status_get(G3_DEF_DEVID, i<<5, &trafficBit);
#endif
		
		if( ret != AAL_E_OK)
		{
			WARNING("ca_ret of ca_flow_traffic_status_get() is %d", ret);
			continue;
		}
		fc_db.g3_mHash_trfBitsArray[i] |= trafficBit; // ca_flow_traffic_status_get is read clear, OR to SW stored traffic bit
	}

	fc_db.g3_mHash_trf_hkCurIdx = (end<<5) % (fc_db.flowHwTableSize);

	return SUCCESS;
}
#if defined(CONFIG_FC_RTL8277C_SERIES)
static void _rtk_fc_mainHashFlow_timeoutUpdate(uint32 ftIdx)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	uint8 trfStatus = FALSE;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(fc_db.flowTbl[ftIdx].candidateState!=CANDIDATE_STATE_NONE)
#else
	if(fc_db.flowTbl[ftIdx].pFlowEntry->path1.valid)
#endif
	{
		if(ftIdx < fc_db.flowHwTableSize)
		{
			//get Hardware traffic bit
			if(fc_db.g3_mHash_trfBitsArray[ftIdx >> 5] & (1 << (ftIdx & 0x1F)))
			{
				trfStatus = TRUE;
				fc_db.g3_mHash_trfBitsArray[ftIdx >> 5] ^= (1 << (ftIdx & 0x1F));
			}
		}

		//get software traffic bit
		if(fc_db.flowTbl[ftIdx].swTrfBit)
			trfStatus = TRUE;
		fc_db.flowTbl[ftIdx].swTrfBit = FALSE;


		if((ftIdx < fc_db.flowHwTableSize) && fc_db.flowTbl[ftIdx].pAbstrSwFlowEt)
		{
			//juset need update trfStatus to abstrSw Entry
			if(trfStatus)
				fc_db.flowTbl[fc_db.flowTbl[ftIdx].pAbstrSwFlowEt->swFlowIdx].swTrfBit=1;
		}
		else
		{
			ret = rtk_fc_flow_updateTimer_and_checkTimeout(ftIdx, trfStatus);
			if(ret!=RTK_FC_RET_ERR_FLOW_TIMEOUT)
			{
				assert_ok(ret);
			}
			/*active flow, update its SA idle time and ingress/egress traffic bits*/
			if(trfStatus)
			{
				TIMER("[update LUT] Update the aging time of HW flow[%d]'s SA: L2[%d]\n", ftIdx, fc_db.flowTbl[ftIdx].lutIgrSaIdx);
				_rtk_fc_lut_updateTimer(fc_db.flowTbl[ftIdx].lutIgrSaIdx);
				_rtk_fc_netif_updateSwTrafficBit(*(fc_db.flowTbl[ftIdx].pFlowEntry));
			}
		}
	}

	return;
}
#else
static void _rtk_fc_mainHashFlow_timeoutUpdate(uint32 ftIdx)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	uint8 trfStatus = FALSE;
	
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(fc_db.flowTbl[ftIdx].candidateState!=CANDIDATE_STATE_NONE)
#else
	if(fc_db.flowTbl[ftIdx].pFlowEntry->path1.valid)
#endif
	{			
		trfStatus = FALSE;

		//get software traffic bit
		if(fc_db.flowTbl[ftIdx].swTrfBit)
			trfStatus = TRUE;
		fc_db.flowTbl[ftIdx].swTrfBit = FALSE;

		if(fc_db.flowTbl[ftIdx].mainHashIdx != G3_FLOWIDX_INVALID){
			if(fc_db.g3_mHash_trfBitsArray[fc_db.flowTbl[ftIdx].mainHashIdx >> 5] & (1 << (fc_db.flowTbl[ftIdx].mainHashIdx & 0x1F)))
			{
				trfStatus = TRUE;
				fc_db.g3_mHash_trfBitsArray[fc_db.flowTbl[ftIdx].mainHashIdx >> 5] ^= (1 << (fc_db.flowTbl[ftIdx].mainHashIdx & 0x1F));
			}
		}
		if(fc_db.flowTbl[ftIdx].protoCtrl ==FLOW_PROTO_CTRL_L2DUAL && FLOW_INFO_IS_SET(&fc_db.flowTbl[ftIdx], FLOW_INFO_SOFTWARE_ONLY))
		{
			int i;
			for(i = 0 ; i < 4 ; i++)
			{
				if(fc_db.vxlan_upStream_record[i].isSet!=0 && fc_db.vxlan_upStream_record[i].sw_flow_index == ftIdx)
				{
					uint32 inner_mainHash_idx = fc_db.flowTbl[fc_db.vxlan_upStream_record[i].inner_flow_index].mainHashIdx;
					if(fc_db.g3_mHash_trfBitsArray[inner_mainHash_idx >> 5] & (1 << (inner_mainHash_idx & 0x1F)))
					{
						trfStatus = TRUE;
						//fc_db.g3_mHash_trfBitsArray[inner_mainHash_idx >> 5] ^= (1 << (inner_mainHash_idx & 0x1F));
						TIMER("[VXLAN][US]swonly flow set trf-bit = TRUE because its inner hash %d has traffic",inner_mainHash_idx);
						break;
					}
				}
				if(fc_db.vxlan_downStream_record[i].isSet!=0 &&fc_db.vxlan_downStream_record[i].sw_flow_index == ftIdx)
				{
					uint32 inner_mainHash_idx = fc_db.flowTbl[fc_db.vxlan_downStream_record[i].inner_flow_index].mainHashIdx;
					if(fc_db.g3_mHash_trfBitsArray[inner_mainHash_idx >> 5] & (1 << (inner_mainHash_idx & 0x1F)))
					{
						trfStatus = TRUE;
						//fc_db.g3_mHash_trfBitsArray[inner_mainHash_idx >> 5] ^= (1 << (inner_mainHash_idx & 0x1F));
						TIMER("[VXLAN][DS]swonly flow set trf-bit = TRUE because its inner hash %d has traffic",inner_mainHash_idx);
						break;
					}
				}
			}
		}
		
		ret = rtk_fc_flow_updateTimer_and_checkTimeout(ftIdx, trfStatus);
		if(ret!=RTK_FC_RET_ERR_FLOW_TIMEOUT)
		{
			assert_ok(ret);
		}
		/*active flow, update its SA idle time and ingress/egress traffic bits*/
		if(trfStatus)
		{
			TIMER("[update LUT] Update the aging time of HW flow[%d]'s SA: L2[%d]\n", ftIdx, fc_db.flowTbl[ftIdx].lutIgrSaIdx);
			_rtk_fc_lut_updateTimer(fc_db.flowTbl[ftIdx].lutIgrSaIdx);
			_rtk_fc_netif_updateSwTrafficBit(*(fc_db.flowTbl[ftIdx].pFlowEntry));
		}
	}

	return;
}
#endif

/*
*  Flow housekeeping for both HW and SW entry
*/
int _rtk_fc_flow_timeoutCheck(void)
{
	int i, wayPosi, sw_flow_list_idx;
	int ftIdx;
	uint32 startBucket, endBucket;
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL, *pFlowEntryNext=NULL;
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	rtk_fc_overFlowHash_linkList_t *pOverFlowHashEntry=NULL, *pOverFlowHashEntryNext=NULL;
#endif
	
	// validset position
	startBucket = (fc_db.swFlow_hkCurIdx);
	endBucket = (fc_db.swFlow_hkCurIdx + RTK_FTCHECK_GRANULARITY);
	if(endBucket > (fc_db.flowHashBuckets)) endBucket = (fc_db.flowHashBuckets);

	for(i=startBucket; i<endBucket; i++)
	{
		rtk_fc_flow_batchscan_group_lock(i);
		//============================================//

		// flow entries exist, scan each flow
		for(wayPosi=0; wayPosi<(1<<fc_db.flowHashWayShift); wayPosi++)
		{
			ftIdx = (i<<fc_db.flowHashWayShift) + wayPosi;

			_rtk_fc_mainHashFlow_timeoutUpdate(ftIdx);
		}

		// scan SW flow according to hash index
		RTK_FOR_EACH_SW_FLOW_LIST_IN_BUCKET(sw_flow_list_idx, i)
		{
			if(!list_empty(&fc_db.swFlow_hashListHead[sw_flow_list_idx]))
			{
				list_for_each_entry_safe(pFlowEntry, pFlowEntryNext, &fc_db.swFlow_hashListHead[sw_flow_list_idx], flow_list)
				{
					ftIdx = pFlowEntry->idx;
				
					_rtk_fc_mainHashFlow_timeoutUpdate(ftIdx);
				}
			}
		}
		//============================================//
		rtk_fc_flow_batchscan_group_unlock(i);
		
	}
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	if(endBucket == fc_db.flowHashBuckets)
	{
		// check last hw flow bucket: check overflow flow at the same time
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		if(!list_empty(&fc_db.overFlowHash_inUseListHead))
		{
			list_for_each_entry_safe(pOverFlowHashEntry, pOverFlowHashEntryNext, &fc_db.overFlowHash_inUseListHead, flow_list)
			{
				ftIdx = pOverFlowHashEntry->idx;
				_rtk_fc_mainHashFlow_timeoutUpdate(ftIdx);
			}
		}
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
	}
#endif
	fc_db.swFlow_hkCurIdx = endBucket % fc_db.flowHashBuckets;

	return SUCCESS;
}
#endif
rtk_fc_ret_t _rtk_fc_hwNetifTraffic_get(int hwIntfIdx, int *netifTraffic)
{
	if((hwIntfIdx < 0) || (hwIntfIdx >= RTK_FC_TABLESIZE_INTF))
	{
		WARNING("Invalind HW netif index");
		return RT_ERR_RG_INVALID_PARAM;
	}
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(fc_db.netifTrfBit[hwIntfIdx/32] & (1 << (hwIntfIdx%32)))
		*netifTraffic = TRUE;
	else
		*netifTraffic = FALSE;

	// read-and-clear
	fc_db.netifTrfBit[hwIntfIdx/32] &= ~(1 << (hwIntfIdx%32));
#else
	{
		uint32 netifTrfbits;
		ASSERT_EQ(rtk_rg_asic_netifTraffic_get(&netifTrfbits), SUCCESS);
		if(netifTrfbits & (1<<hwIntfIdx))
			*netifTraffic = TRUE;
		else
			*netifTraffic = FALSE;
	}
#endif
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t _rtk_fc_pppoeConnectionAutoExtend_checkPppoeWAN(void)
{
	int i;
	int netifTrf = FALSE; // netif traffic bit
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(! fc_db.netifTbl[i].intf.valid)
			continue;
		if(fc_db.netifTbl[i].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_ADD)
		{
			int hwIdx = fc_db.netifTbl[i].hwIdx;
			if((hwIdx != SIGNED_INVALID) && (!fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].ifTempEntry) && (fc_db.netifHwTbl[hwIdx].pppoeGwLutIdx != SIGNED_INVALID) && (fc_db.lutTbl[fc_db.netifHwTbl[hwIdx].pppoeGwLutIdx]!=NULL))
			{
				if((_rtk_fc_hwNetifTraffic_get(fc_db.netifTbl[i].hwIdx, &netifTrf) == RTK_FC_RET_OK) && (netifTrf == TRUE))
				{//There is traffic passes through PPPoE WAN
					if(fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx].dummyPktInit == 0)
					{//Not initial dummy packet for thid pppoe WAN
						if(fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx].dummyPkt == NULL)
						{
							WARNING("No memory for PPPoE WAN dummy pkt. Do nothing!\n");
							continue;//skip
						}
						//generate dummt packet for PPPoE WAN
						rtk_fc_pppoe_netif_skbDataReasm(&fc_db.netifTbl[i], &fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx]);
					}
					rtk_fc_pppoe_netif_autoExtendByDummyPkt(&fc_db.netifTbl[i], &fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx]);
				}
			}
		}
	}
	return SUCCESS;
}
rtk_fc_ret_t _rtk_fc_l2tpConnectionAutoExtend(void)
{
	int i;
	int netifTrf = FALSE; // netif traffic bit
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
		if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].hwIdx==FAIL)
			continue;

		if(fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].ifTempEntry)
			continue; // temp entry, skip
		
		if(fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].dualType!= RTK_FC_DUALTYPE_L2TP)
			continue;

		if((fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0)) {
			if((_rtk_fc_hwNetifTraffic_get(fc_db.netifTbl[i].hwIdx, &netifTrf) == RTK_FC_RET_OK) && (netifTrf == TRUE))
				{//There is traffic passes through PPPoE WAN
					if(fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx].dummyPktInit == 0)
					{
						if(fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx].dummyPkt == NULL)
						{
							WARNING("No memory for L2TP WAN dummy pkt. Do nothing!\n");
							continue;//skip
						}
						//generate dummt packet for PPPoE WAN
						rtk_fc_l2tp_netif_skbDataReasm(&fc_db.netifTbl[i], &fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx]);
					}
					rtk_fc_l2tp_netif_autoExtendByDummyPkt(&fc_db.netifTbl[i], &fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx]);
				}
			
		}


	}

	return SUCCESS;
}
rtk_fc_ret_t _rtk_fc_pptpConnectionAutoExtend(void)
{
	int i;
	int netifTrf = FALSE; // netif traffic bit
	for(i = 0; i< RTK_FC_TABLESIZE_INTF_SW; i++)
	{
	
		//DEBUG("i = %d, netif: %s gateway ip = %pI4, packet sip =  %pI4", i, fc_db.netifTbl[i].dev->name, &fc_db.netifTbl[i].intf.gateway_ipv4_addr, &pPktHdr->iph->saddr);
		if(fc_db.netifTbl[i].intf.valid==0 || fc_db.netifTbl[i].hwIdx==FAIL)
			continue;

		if(fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].ifTempEntry)
			continue; // temp entry, skips
		
		if(fc_db.netifHwTbl[fc_db.netifTbl[i].hwIdx].dualType != RTK_FC_DUALTYPE_PPTP)
			continue;
		
		if( (fc_db.netifTbl[i].intf.gateway_ipv4_addr!=0) ) {
			if((_rtk_fc_hwNetifTraffic_get(fc_db.netifTbl[i].hwIdx, &netifTrf) == RTK_FC_RET_OK) && (netifTrf == TRUE))
				{//There is traffic passes through PPPoE WAN
					printk("There is traffic passes through PPTP WAN\n");
					if(fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx].dummyPktInit == 0)
					{//Not initial dummy packet for thid pppoe WAN
						if(fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx].dummyPkt == NULL)
						{
							WARNING("No memory for PPTP WAN dummy pkt. Do nothing!\n");
							continue;//skip
						}
						//generate dummt packet for PPPoE WAN
						rtk_fc_pptp_netif_skbDataReasm(&fc_db.netifTbl[i], &fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx]);
					}
					rtk_fc_pptp_netif_autoExtendByDummyPkt(&fc_db.netifTbl[i], &fc_db.netifDummyPacket[fc_db.netifTbl[i].hwIdx]);
				}

		}


	}
	return SUCCESS;
}


void _rtk_fc_pppoeConnectionAutoExtend_task(unsigned long task_priv)
{
	if(fc_db.controlFuc.pppoe_connectionAutoExtend == TRUE)
	{
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
		//========================= Critical Section Start =========================//
		task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
		
		if((1 << fc_db.controlFuc.hwnat_mode) & HWNAT_MODE_SKIP_FC_FUNC_BITMASK)//Trap to PS mode
		{
			_rtk_fc_pppoeConnectionAutoExtend_checkPppoeWAN();
			_rtk_fc_pptpConnectionAutoExtend();
			_rtk_fc_l2tpConnectionAutoExtend();
		}
		RTK_FC_HELPER_MOD_TIMER(fc_db.controlFuc.pppoe_connectionAutoExtend_timer, jiffies + (fc_db.controlFuc.pppoe_connectionAutoExtend_period_unit1s* CONFIG_HZ));
		//========================= Critical Section End =========================//
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	}
	return;
}

__IRAM_FC_SHORTCUT
int _rtk_fc_sw_perFlowCounting(int flowTblIdx, int pktLenIgr, uint16 payloadLen)
{
	/*
	 * per flow mib counting is protected by flow group spinlock.
	 
	 */
	rt_flow_op_sw_flow_mib_info_t count;
	DEBUG("update per flow SW mib: ingress %d bytes", pktLenIgr);

	/* pktLenIgr or pktLenEgr may be 0
	     For example, MC shortcut flow, only the first egress packet will be set to non-zero pktLenIgr*/

	/*per Flow Mib, only support in RT_FLOW_HWNAT_MODE_SW_ONLY mode*/
	if((fc_db.controlFuc.hwnat_mode == RT_FLOW_HWNAT_MODE_SW_ONLY) && (flowTblIdx != SIGNED_INVALID) && pktLenIgr)
	{
		memset(&count, 0, sizeof(count));
		count.ingress_packet_count = 1;
		if(fc_db.controlFuc.sw_shaperMib_update_mode_flow == SW_SHAPERMIB_UPDATE_BY_PAYLOADLEN)
			count.ingress_byte_count = payloadLen;
		else
			count.ingress_byte_count = pktLenIgr;
		DEBUG("update per flow mib: flowMib[%d]", flowTblIdx);
		
		RTK_FC_HELPER_MGR_SW_FLOW_MIB_ADD(flowTblIdx, count);
	}

	return SUCCESS;
}

uint64 _rtk_fc_sw_hostMib_all_cpu_get(uint32 hostCtrlIdx, rtk_fc_hostMibType_t type)
{
	uint64 sum = 0;
	uint32 i =0;
	
	switch(type)
	{
		case RX_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.hostPoliceTable[hostCtrlIdx].swHostPoliceCounter[i].rx_count;
			break;
		case TX_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.hostPoliceTable[hostCtrlIdx].swHostPoliceCounter[i].tx_count;
			break;
	}

	return sum;
}

uint64 _rtk_fc_sw_flowMib_all_cpu_get(uint32 flowmibIdx, rtk_fc_flowMibType_t type)
{
	uint64 sum = 0;
	uint32 i =0;
	
	switch(type)
	{
		case IN_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.flowSWMib[flowmibIdx][i].in_packet_cnt;
			break;
		case IN_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.flowSWMib[flowmibIdx][i].in_byte_cnt;
			break;
		case OUT_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.flowSWMib[flowmibIdx][i].out_packet_cnt;
			break;
		case OUT_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.flowSWMib[flowmibIdx][i].out_byte_cnt;
			break;
	}

	return sum;
}

uint64 _rtk_fc_sw_netifMib_all_cpu_get(uint32 netifIdx, rtk_fc_netifMibType_t type)
{
	uint64 sum = 0;
	uint32 i =0;
	
	switch(type)
	{
		case IN_UC_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].in_intf_uc_packet_cnt;
			break;
		case IN_UC_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].in_intf_uc_byte_cnt;
			break;
		case IN_MC_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].in_intf_mc_packet_cnt;
			break;
		case IN_MC_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].in_intf_mc_byte_cnt;
			break;
		case IN_BC_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].in_intf_bc_packet_cnt;
			break;
		case IN_BC_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].in_intf_bc_byte_cnt;
			break;
		case OUT_UC_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].out_intf_uc_packet_cnt;
			break;
		case OUT_UC_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].out_intf_uc_byte_cnt;
			break;
		case OUT_MC_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].out_intf_mc_packet_cnt;
			break;
		case OUT_MC_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].out_intf_mc_byte_cnt;
			break;
		case OUT_BC_PKT_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].out_intf_bc_packet_cnt;
			break;
		case OUT_BC_BYTE_CNT:
			for(i = 0; i < NR_CPUS; i ++)
				sum += fc_db.netifHwTbl[netifIdx].intfMib[i].out_intf_bc_byte_cnt;
			break;
	}

	return sum;
}

static void _rtk_fc_sw_intfFlowMibCounting(int flowMibIdx, int intfIdxIgr, int skbLenIgr, int intfIdxEgr, int skbLenEgr, rtk_fc_packetType_t pktType, uint32 payloadLen)
{
	int pktLenIgr = (skbLenIgr)?(skbLenIgr + 4):skbLenIgr, pktLenEgr = skbLenEgr?(skbLenEgr + 4):skbLenEgr;	// 4 bytes CRC
	/* pktLenIgr or pktLenEgr may be 0
	     For example, MC shortcut flow, only the first egress packet will be set to non-zero pktLenIgr*/

	/*Interface Mib*/
	switch(pktType)
	{
		case RTK_FC_PKTTYPE_UC:
				if(skbLenIgr != 0)
				{
					fc_db.netifHwTbl[intfIdxIgr].intfMib[smp_processor_id()].in_intf_uc_packet_cnt++;
					fc_db.netifHwTbl[intfIdxIgr].intfMib[smp_processor_id()].in_intf_uc_byte_cnt += pktLenIgr;
				}
				DEBUG("update ingress netif mib: netif[%d] (ingress %d bytes)", intfIdxIgr, pktLenIgr);
				if(skbLenEgr != 0)
				{
					fc_db.netifHwTbl[intfIdxEgr].intfMib[smp_processor_id()].out_intf_uc_packet_cnt++;
					fc_db.netifHwTbl[intfIdxEgr].intfMib[smp_processor_id()].out_intf_uc_byte_cnt += pktLenEgr;
				}
				DEBUG("update egress netif mib: netif[%d] (egress %d bytes)", intfIdxEgr, pktLenEgr);
			break;
		case RTK_FC_PKTTYPE_MC:
				if(skbLenIgr != 0)
				{
					fc_db.netifHwTbl[intfIdxIgr].intfMib[smp_processor_id()].in_intf_mc_packet_cnt++;
					fc_db.netifHwTbl[intfIdxIgr].intfMib[smp_processor_id()].in_intf_mc_byte_cnt += pktLenIgr;
				}
				DEBUG("update ingress netif mib: netif[%d] (ingress %d bytes)", intfIdxIgr, pktLenIgr);
				if(skbLenEgr != 0)
				{
					fc_db.netifHwTbl[intfIdxEgr].intfMib[smp_processor_id()].out_intf_mc_packet_cnt++;
					fc_db.netifHwTbl[intfIdxEgr].intfMib[smp_processor_id()].out_intf_mc_byte_cnt += pktLenEgr;
				}
				DEBUG("update egress netif mib: netif[%d] (egress %d bytes)", intfIdxEgr, pktLenEgr);
			break;
		case RTK_FC_PKTTYPE_BC:
				if(skbLenIgr != 0)
				{
					fc_db.netifHwTbl[intfIdxIgr].intfMib[smp_processor_id()].in_intf_bc_packet_cnt++;
					fc_db.netifHwTbl[intfIdxIgr].intfMib[smp_processor_id()].in_intf_bc_byte_cnt += pktLenIgr;
				}
				DEBUG("update ingress netif mib: netif[%d] (ingress %d bytes)", intfIdxIgr, pktLenIgr);
				if(skbLenEgr != 0)
				{
					fc_db.netifHwTbl[intfIdxEgr].intfMib[smp_processor_id()].out_intf_bc_packet_cnt++;
					fc_db.netifHwTbl[intfIdxEgr].intfMib[smp_processor_id()].out_intf_bc_byte_cnt += pktLenEgr;
				}
				DEBUG("update egress netif mib: netif[%d] (egress %d bytes)", intfIdxEgr, pktLenEgr);
			break;
	}
	/*Flow Mib*/
	if(flowMibIdx != FAIL)
	{
		if(skbLenIgr != 0)
		{
			fc_db.flowSWMib[flowMibIdx][smp_processor_id()].in_packet_cnt++;
			if(fc_db.controlFuc.sw_shaperMib_update_mode_flow == SW_SHAPERMIB_UPDATE_BY_PAYLOADLEN)
				fc_db.flowSWMib[flowMibIdx][smp_processor_id()].in_byte_cnt += payloadLen;
			else
				fc_db.flowSWMib[flowMibIdx][smp_processor_id()].in_byte_cnt += pktLenIgr;
			DEBUG("update ingress flow mib: flowMib[%d] (ingress %d bytes (payload %d bytes))", flowMibIdx , pktLenIgr, payloadLen);
		}
		if(skbLenEgr != 0)
		{
			fc_db.flowSWMib[flowMibIdx][smp_processor_id()].out_packet_cnt++;
			if(fc_db.controlFuc.sw_shaperMib_update_mode_flow == SW_SHAPERMIB_UPDATE_BY_PAYLOADLEN)
				fc_db.flowSWMib[flowMibIdx][smp_processor_id()].out_byte_cnt += payloadLen;
			else
				fc_db.flowSWMib[flowMibIdx][smp_processor_id()].out_byte_cnt += pktLenEgr;
			DEBUG("update egress flow mib: flowMib[%d] (egress %d bytes (payload %d bytes))", flowMibIdx, pktLenEgr, payloadLen);
		}
	}

	return;
}

__IRAM_FC_SHORTCUT
int _rtk_fc_sw_hostPolicingMibCounting(int16 smacHostPolIdx, int16 dmacHostPolIdx, int skbLenIgr, int skbLenEgr, uint16 payloadLen)
{
	int pktLenIgr = skbLenIgr + 4, pktLenEgr = skbLenEgr + 4;	// 4 bytes CRC

	DEBUG("host mib counting check smacHostPolIdx[%d] dmacHostPolIdx[%d]", smacHostPolIdx, dmacHostPolIdx);

	/* pktLenIgr or pktLenEgr may be 0
	     For example, MC shortcut flow, only the first egress packet skbLen will be set to non-zero pktLenIgr*/

	if(smacHostPolIdx != SIGNED_INVALID)
	{
		DEBUG("SA %pM is set in hostPolice[%d], update its rx count (ingress %d bytes (payload %d bytes))", fc_db.hostPoliceTable[smacHostPolIdx].hostPoliceControl.mac_addr, smacHostPolIdx, pktLenIgr, payloadLen);
		if((fc_db.hostPoliceTable[smacHostPolIdx].hostPoliceControl.mib_count_control) && (skbLenIgr != 0))
		{
			if(fc_db.controlFuc.sw_shaperMib_update_mode_host)
				fc_db.hostPoliceTable[smacHostPolIdx].swHostPoliceCounter[smp_processor_id()].rx_count += payloadLen;
			else
				fc_db.hostPoliceTable[smacHostPolIdx].swHostPoliceCounter[smp_processor_id()].rx_count += pktLenIgr;
		}
	}


	if(dmacHostPolIdx != SIGNED_INVALID)
	{
		DEBUG("DA %pM is set in hostPolice[%d], update its tx count (egress %d bytes (payload %d bytes))", fc_db.hostPoliceTable[dmacHostPolIdx].hostPoliceControl.mac_addr, dmacHostPolIdx, pktLenEgr, payloadLen);
		if((fc_db.hostPoliceTable[dmacHostPolIdx].hostPoliceControl.mib_count_control) && (skbLenEgr != 0))
		{
			if(fc_db.controlFuc.sw_shaperMib_update_mode_host)
				fc_db.hostPoliceTable[dmacHostPolIdx].swHostPoliceCounter[smp_processor_id()].tx_count += payloadLen;
			else
				fc_db.hostPoliceTable[dmacHostPolIdx].swHostPoliceCounter[smp_processor_id()].tx_count += pktLenEgr;
		}
	}

	return SUCCESS;
}


rtk_fc_ret_t _rtk_fc_flowEgressTx(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, int portMask, rtk_fc_wlan_devidx_t egrWlanDevIdx)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	
	// wifi tx
	if((egrWlanDevIdx < RTK_FC_WLANX_END_INTF)
#if defined(CONFIG_FC_RTL8198F_SERIES)
		&& (!fc_db.controlFuc.pe_fc_enable || (portMask != (1<<fc_db.controlFuc.pe_port)))
#endif
		)
	{
		//RTK_FC_HELPER_WLAN_HARD_START_XMIT(egrWlanDevIdx, RTSKB_SKB(rtskb));
		ret = rtk_fc_wifi_send_with_wlandevidx(egrWlanDevIdx, rtskb, pPktHdr, pPktHdr->remarkDec.outputQid);
		

		return ret;

	}

#if defined(CONFIG_FC_RTL8198F_SERIES)
	{
		int direction = _rtk_fc_flow_direction(pPktHdr, RTSKB_FCIGRDATA(rtskb));
		if(RTK_FC_HOOK_PASS_COS_TO_83XX_QOS(pPktHdr->remarkDec.outputQid, rtskb, portMask, fc_db.wanPortMask.portmask, direction) != SUCCESS)
		{
			return RTK_FC_RET_DROP;
		}
	}
#endif


	// nic tx
	if(pPktHdr)
	{
		fc_tx_info_t	*ptxInfo, txInfo;
		uint8 ip_summed;

		ptxInfo = &txInfo;
		memset(ptxInfo, 0, sizeof(fc_tx_info_t));

		TXINFO_EOR(ptxInfo)			= 0;
		TXINFO_FS(ptxInfo) 			= 1;
		TXINFO_LS(ptxInfo) 			= 1;
		RTK_FC_HOOK_PS_SKB_IP_SUMMED_GET(RTSKB_SKB(rtskb), &ip_summed);
		if(ip_summed != CHECKSUM_NONE) {
			// CHECKSUM_NONE/Tx: The skb was already checksummed by the protocol, or a checksum is not required.
			TXINFO_IPCS(ptxInfo)			= 1;
			TXINFO_L4CS(ptxInfo)			= 1;
		}
		TXINFO_CRC(ptxInfo)			= 1;
		TXINFO_DATA_LEN(ptxInfo)	= RTSKB_LEN(rtskb);
		TXINFO_CPUTAG(ptxInfo) 		= 1;



		// TPID SELECTION
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		if(pPktHdr->remarkDec.svlan_tpid_from_skbmark== RTK_FC_TPID_FROM_SKBMARK_USE_STAG_1)
		{
			TXINFO_TPID_SEL(ptxInfo)	= 1;
		}

#endif
		
		// SVLAN RELATED SETTING
		if(pPktHdr->remarkDec.svlan_action_from_skbmark==RTK_FC_SKBMARK_VLAN_KEEP_ORIGINAL)
			TXINFO_SVLAN_ACT(ptxInfo)   = 0;
		else
			TXINFO_SVLAN_ACT(ptxInfo)   = (pPktHdr->remarkDec.svlan_action_from_skbmark==RTK_FC_SKBMARK_VLAN_UNTAG)?0x2:0x3;
			
		TXINFO_SVLAN_VIDL(ptxInfo) 	= (pPktHdr->svlanid&0xff);
		TXINFO_SVLAN_PRIO(ptxInfo) 	= pPktHdr->svlanpri;
		TXINFO_SVLAN_VIDH(ptxInfo) 	= ((pPktHdr->svlanid&0xf00)>>8);
		TXINFO_STAG_AWARE(ptxInfo)	= 1;



		// CVLAN RELATED SETTING
		if(pPktHdr->remarkDec.cvlan_action_from_skbmark==RTK_FC_SKBMARK_VLAN_KEEP_ORIGINAL)
			TXINFO_CVLAN_ACT(ptxInfo)   = 0;
		else
			TXINFO_CVLAN_ACT(ptxInfo)   = (pPktHdr->remarkDec.cvlan_action_from_skbmark==RTK_FC_SKBMARK_VLAN_UNTAG)?0x2:0x3;

		TXINFO_CVLAN_VIDL(ptxInfo)	= (pPktHdr->cvlanid&0xff);
		TXINFO_CVLAN_PRIO(ptxInfo)	= pPktHdr->cvlanpri;
		TXINFO_CVLAN_VIDH(ptxInfo)	= ((pPktHdr->cvlanid&0xf00)>>8);

		
		TXINFO_SVLAN_CFI(ptxInfo)		= 0;
		TXINFO_CVLAN_CFI(ptxInfo)		= 0;
		TXINFO_TX_PORTMSK(ptxInfo)      = portMask;

		TXINFO_ASPRI(ptxInfo)		= 1;
		TXINFO_CPUTAG_PRI(ptxInfo) 	= pPktHdr->remarkDec.outputQid;
		TXINFO_KEEP(ptxInfo)		= 0;
		TXINFO_DISLRN(ptxInfo) 		= 1;
		if(portMask & fc_db.wanPortMask.portmask){
			TXINFO_CPUTAG_PSEL(ptxInfo)		= pPktHdr->remarkDec.streamId_en;
			TXINFO_TX_DST_STREAM_ID(ptxInfo)= pPktHdr->remarkDec.streamId;
		}
		TXINFO_L34_KEEP(ptxInfo)		= 1;
		TXINFO_GMAC_ID(ptxInfo)		    = 0;
		{
			// if traffic is from wlan, select GMAC according to DMAC SPA
			uint32 gmacid=0;
			if(pPktHdr->igrWlanDevIdx < RTK_FC_WLANX_END_INTF && pPktHdr->egressFlowAddComplete) {
				RTK_FC_HELPER_WLAN_RX_LOOKUP_GMAC_DECISION(pPktHdr->egressPort.macPortIdx, &gmacid);
				DEBUG("dest port is %d, sel gmac %d", pPktHdr->egressPort.macPortIdx, gmacid);
				TXINFO_GMAC_ID(ptxInfo)		    = gmacid;
			}
		}
		TXINFO_EXTSPA(ptxInfo) 			= 0;
		TXINFO_TX_PPPOE_ACT(ptxInfo)    = 0;
		TXINFO_TX_PPPOE_IDX(ptxInfo)	= 0;

#if defined(CONFIG_FC_RTL8198F_SERIES)
		if(fc_db.controlFuc.pe_fc_enable && (portMask >= (1<<RTK_FC_MAC_PORT_WLAN_CPU0)))
			TXINFO_PE_PORTMSK(ptxInfo) = portMask;
#endif
		ret = rtk_fc_nic_send_with_txInfo(rtskb, ptxInfo, 0, pPktHdr);
	}

	return ret;
}

int rtk_fc_gmac_svlan_tpid_enable(uint16 svlan_tpid, int vlan_register)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		// GMAC support svlan offload
		fc_tx_info_t txInfo={{{0}},0,{{0}},{{0}}};
		uint32 val = 0;


		//	31-16	R/W 	0x88a8	STAG_PID	Set the s-tag protocol identifier. This field is valid only when COM_REG.TDSC_VLAN_TYPE is high.
		//	15		R/W 	0		R_en_rstag	Gmac rx. 0. disable STAG_PID. 1: enable STAG_PID.
		//	14		R/W 	0		R_en_tstag	Gmac tx. 0. disable STAG_PID. 1: enable STAG_PID.

		val = ((svlan_tpid)<<16) | 0xc000;
		
		re8686_set_vlan_register(&txInfo, vlan_register, val);  // Write to VLAN_REG

		txInfo.opts3.bit.gmac_id = 1;
		re8686_set_vlan_register(&txInfo, vlan_register, val);  // Write to VLAN_REG



#endif

	return SUCCESS;
}


/*
* vlanID: vid[11:0] only
*/
__IRAM_FC_SHORTCUT
int rtk_fc_skbVlanTag_update(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, uint16 vlanID, uint8 isStag)
{
	uint16 vlanTCI = 0;

	FC_PARAM_CHK(pPktHdr->eth==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	TRACE("insert %sTag vid=%x",isStag?"S":"C", vlanID);

	if(isStag){
		FC_PARAM_CHK(pPktHdr->svh==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
		// insert stag after ethhdr
		vlanTCI = ntohs(pPktHdr->svh->h_vlan_TCI);

	}else{
		FC_PARAM_CHK(pPktHdr->cvh==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
		// insert ctag after stag or ethhdr
		vlanTCI = ntohs(pPktHdr->cvh->h_vlan_TCI);
	}

	vlanTCI &= ~(VLAN_VID_MASK);
	vlanTCI |= (vlanID&VLAN_VID_MASK);

	// update header info
	if(isStag){
		pPktHdr->svh->h_vlan_TCI = htons(vlanTCI);
		pPktHdr->svlanid = vlanTCI & VLAN_VID_MASK;
		pPktHdr->svlanpri = (vlanTCI & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;
	}
	else{
		pPktHdr->cvh->h_vlan_TCI = htons(vlanTCI);
		pPktHdr->cvlanid = vlanTCI & VLAN_VID_MASK;
		pPktHdr->cvlanpri = (vlanTCI & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;
	}

	return (SUCCESS);
}



struct vlan_hdr_format {
	__be16	tpid;
	__be16	vlan_TCI;
};
/*
* vlanTCI: pri[15:13] + dei[12] + vid[11:0]
* insertOffset point to tag tpid 
*/
__IRAM_FC_SHORTCUT
int rtk_fc_skbVlanTag_fast_insert(struct rt_skbuff *rtskb, uint16 insertOffset,uint16 tpid ,uint16 vlanTCI)
{
	struct vlan_hdr_format *pVlan=NULL;

	TRACE("insert offset:%d tpid:0x%x TCI=0x%x",insertOffset,tpid,vlanTCI);

	if(RTK_FC_HOOK_PS_SKB_SKB_COW_HEAD(RTSKB_SKB(rtskb), VLAN_HLEN)<0)
		{WARNING("skb head room is not enough");return FAIL;}

	//RTK_FC_HOOK_PS_SKB_SKB_PUSH(RTSKB_SKB(rtskb), VLAN_HLEN, &pData);   
	RTSKB_DATA(rtskb)-=VLAN_HLEN;
	RTSKB_LEN(rtskb)+=VLAN_HLEN;	
	memmove(RTSKB_DATA(rtskb), RTSKB_DATA(rtskb) + VLAN_HLEN, insertOffset);

	pVlan= (struct vlan_hdr_format*)(RTSKB_DATA(rtskb)+insertOffset);
	pVlan->tpid=htons(tpid);
	pVlan->vlan_TCI=htons(vlanTCI);

	//reset skb L234 header
	//RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));
	RTSKB_MAC_HEADER(rtskb) -= (VLAN_HLEN);
	RTSKB_TRANSPORT_HEADER(rtskb) -= (VLAN_HLEN);
	RTSKB_NETWORK_HEADER(rtskb) -= (VLAN_HLEN);

	return (SUCCESS);
}

/* removeOffset point to tag tpid */
__IRAM_FC_SHORTCUT
int rtk_fc_skbVlanTag_fast_remove(struct rt_skbuff *rtskb, uint16 removeOffset)
{
	TRACE("remove tag removeOffset:%d ",removeOffset);
	
	memmove(RTSKB_DATA(rtskb)+VLAN_HLEN, RTSKB_DATA(rtskb), removeOffset);		// remove vlan header

	//RTK_FC_HOOK_PS_SKB_SKB_PULL(RTSKB_SKB(rtskb),VLAN_HLEN,&pData);
	RTSKB_DATA(rtskb)+=VLAN_HLEN;
	RTSKB_LEN(rtskb)-=VLAN_HLEN;

	//RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));
	RTSKB_MAC_HEADER(rtskb) += (VLAN_HLEN);
	RTSKB_TRANSPORT_HEADER(rtskb) += (VLAN_HLEN);
	RTSKB_NETWORK_HEADER(rtskb) += (VLAN_HLEN);

	return (SUCCESS);
}

/* insertOffset point to  ETH_P_PPP_SES 0x8864*/
__IRAM_FC_SHORTCUT
int _rtk_fc_skbPPPoETag_fast_insert(struct rt_skbuff *rtskb, uint16 insertOffset, uint16 sessionid)
{
	uint16 *pL3proto = NULL;
	uint16 *pEthPPP = NULL;
	struct pppoe_hdr *ppph=NULL;

	if(RTK_FC_HOOK_PS_SKB_SKB_COW_HEAD(RTSKB_SKB(rtskb), PPPOE_SES_HLEN)<0)
		{WARNING("skb head room is not enough");return FAIL;}	

	//p2p protocol
	pL3proto = (uint16 *)(RTSKB_DATA(rtskb)+insertOffset);
	if(*pL3proto==htons(ETH_P_IPV6))
		*pL3proto=htons(0x0057);
	else if(*pL3proto==htons(ETH_P_IP))
		*pL3proto=htons(0x0021);
	else
		{WARNING("bad protocol ");  return FAIL;}

	//RTK_FC_HOOK_PS_SKB_SKB_PUSH(RTSKB_SKB(rtskb), PPPOE_SES_HLEN, &pData);
	RTSKB_DATA(rtskb)-=PPPOE_SES_HLEN;
	RTSKB_LEN(rtskb)+=PPPOE_SES_HLEN;	

	memmove(RTSKB_DATA(rtskb), RTSKB_DATA(rtskb) + PPPOE_SES_HLEN, insertOffset);

	//RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));
	RTSKB_MAC_HEADER(rtskb) -= (PPPOE_SES_HLEN);
	RTSKB_TRANSPORT_HEADER(rtskb) -= (PPPOE_SES_HLEN);
	RTSKB_NETWORK_HEADER(rtskb) -= (PPPOE_SES_HLEN);

	//eth=0x8864
	pEthPPP = (uint16 *)(RTSKB_DATA(rtskb)+insertOffset);
	*pEthPPP = htons(ETH_P_PPP_SES);

	//ppphdr
	ppph = (struct pppoe_hdr *)(RTSKB_DATA(rtskb) + insertOffset + ETH_TLEN);
	ppph->type = 1;
	ppph->ver = 1;
	ppph->code = 0;	// session data
	ppph->sid = htons(sessionid);
	ppph->length = htons(RTSKB_LEN(rtskb) - insertOffset - PPPOE_SES_HLEN ); // payload length includes p2p protocol(2 bytes)

	return (SUCCESS);
}

/* removeOffset point to  ETH_P_PPP_SES 0x8864*/
__IRAM_FC_SHORTCUT
int _rtk_fc_skbPPPoETag_fast_remove(struct rt_skbuff *rtskb,uint16 removeOffset)
{
	uint8 *pP2Pproto = NULL;
	uint16 *pl3proto = 0;
	uint16 l3proto = 0;
	int rmSize = PPPOE_SES_HLEN;

	pP2Pproto =RTSKB_DATA(rtskb)+removeOffset+PPPOE_SES_HLEN;

	if(pP2Pproto[0]==0x21 || (pP2Pproto[0]==0x0 && pP2Pproto[1]==0x21))
		l3proto = htons(ETH_P_IP);
	else if(pP2Pproto[0]==0x57 || (pP2Pproto[0]==0x0 && pP2Pproto[1]==0x57))
		l3proto = htons(ETH_P_IPV6);
	else
		{WARNING("unknown l3 proto 0x%x", pP2Pproto[0]<<8|pP2Pproto[1]);return RTK_FC_RET_ERR;}
		
	if(pP2Pproto[0]!=0x0) rmSize-=1;

	memmove( RTSKB_DATA(rtskb)+rmSize,  RTSKB_DATA(rtskb), removeOffset);		// remove pppoe header

	//RTK_FC_HOOK_PS_SKB_SKB_PULL(RTSKB_SKB(rtskb),rmSize,RTSKB_DATA(rtskb));
	RTSKB_DATA(rtskb)+=rmSize;
	RTSKB_LEN(rtskb)-=rmSize;
	
	//RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));
	RTSKB_MAC_HEADER(rtskb) += (PPPOE_SES_HLEN);
	RTSKB_TRANSPORT_HEADER(rtskb) += (PPPOE_SES_HLEN);
	RTSKB_NETWORK_HEADER(rtskb) += (PPPOE_SES_HLEN);

	pl3proto =   (uint16 *)(RTSKB_DATA(rtskb)+removeOffset);
	*pl3proto = l3proto;

	return (SUCCESS);
}


/*
* vlanTCI: pri[15:13] + dei[12] + vid[11:0]
*/
__IRAM_FC_SHORTCUT
int rtk_fc_skbVlanTag_insert(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, uint16 vlanTCI, uint8 isStag)
{
	uint8 *pData = RTSKB_DATA(rtskb);
	int insertOff = 0;

	FC_PARAM_CHK(pPktHdr->eth==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	insertOff += (ETH_HLEN - 2);
	TRACE("insert %sTag TCI=%x",isStag?"S":"C",vlanTCI);

	if(isStag){
		FC_PARAM_CHK(pPktHdr->svh!=NULL, RTK_FC_RET_ERR_INVALID_PARAM);
		// insert stag after ethhdr

	}else{
		FC_PARAM_CHK(pPktHdr->cvh!=NULL, RTK_FC_RET_ERR_INVALID_PARAM);
		// insert ctag after stag or ethhdr
		if(pPktHdr->svh) insertOff += VLAN_HLEN;
	}

	if(_rtk_fc_skb_cow_head_and_pktHdr_update(RTSKB_SKB(rtskb), VLAN_HLEN, rtskb, pPktHdr)<0)
	{
		WARNING("skb head room is not enough");
		return FAIL;
	}

	RTK_FC_HOOK_PS_SKB_SKB_PUSH(RTSKB_SKB(rtskb), VLAN_HLEN, &pData);
	memmove(pData, pData + VLAN_HLEN, insertOff);

	RTSKB_MAC_HEADER(rtskb) -= (VLAN_HLEN);
	// reset header pointer
	pPktHdr->eth = (struct ethhdr *)pData;
	if(isStag){
		pPktHdr->eth->h_proto = htons(ETH_P_8021AD);

		pPktHdr->svh = (struct vlan_hdr *)(pData+insertOff+2);
		pPktHdr->svh->h_vlan_TCI = htons(vlanTCI);
		pPktHdr->svlanid = vlanTCI & VLAN_VID_MASK;
		pPktHdr->svlanpri = (vlanTCI & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;
	}
	else{
		if(pPktHdr->svh){
			pPktHdr->svh = (struct vlan_hdr *)((uint8 *)(pPktHdr->svh) - VLAN_HLEN);
			pPktHdr->svh->h_vlan_encapsulated_proto = htons(ETH_P_8021Q);
		}else
			pPktHdr->eth->h_proto = htons(ETH_P_8021Q);

		pPktHdr->cvh = (struct vlan_hdr *)(pData+insertOff+2);
		pPktHdr->cvh->h_vlan_TCI = htons(vlanTCI);
		pPktHdr->cvlanid = vlanTCI & VLAN_VID_MASK;
		pPktHdr->cvlanpri = (vlanTCI & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;
	}

	return (SUCCESS);
}
__IRAM_FC_SHORTCUT
int rtk_fc_skbVlanTag_remove(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, uint8 isStag)
{
	uint8 *pData = RTSKB_DATA(rtskb);
	int rmOff = 0;

	FC_PARAM_CHK(pPktHdr->eth==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	TRACE("remove %sTag ",isStag?"S":"C");
	rmOff += (ETH_HLEN - 2);

	if(isStag){
		FC_PARAM_CHK(pPktHdr->svh==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
		// insert stag after ethhdr
	}else{
		FC_PARAM_CHK(pPktHdr->cvh==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
		// insert ctag after stag or ethhdr
		if(pPktHdr->svh) rmOff += VLAN_HLEN;

	}

	memmove(pData+VLAN_HLEN, pData, rmOff);		// remove vlan header

	RTSKB_DATA(rtskb)+=VLAN_HLEN;
	RTSKB_LEN(rtskb)-=VLAN_HLEN;
	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

	pPktHdr->eth = (struct ethhdr *)(pData+VLAN_HLEN);
	if(isStag){
		pPktHdr->svh = NULL;
		pPktHdr->svlanid = 0;
		pPktHdr->svlanpri = 0;
	}else{
		if(pPktHdr->svh)
			pPktHdr->svh = (struct vlan_hdr *)((uint8 *)(pPktHdr->svh) + VLAN_HLEN);
		pPktHdr->cvh = NULL;
		pPktHdr->cvlanid = 0;
		pPktHdr->cvlanpri = 0;
	}

	return (SUCCESS);
}

__IRAM_FC_SHORTCUT
static int _rtk_fc_skbPPPoETag_insert(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, uint16 sessionid)
{
	uint8 *pData = RTSKB_DATA(rtskb);
	uint16 l3proto = 0;
	int insertOff = 0;

	FC_PARAM_CHK(pPktHdr->eth==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
	FC_PARAM_CHK(pPktHdr->ppph!=NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	insertOff += (ETH_HLEN);

	if(pPktHdr->svh) insertOff+= VLAN_HLEN;
	if(pPktHdr->cvh) insertOff+= VLAN_HLEN;

	if(_rtk_fc_skb_cow_head_and_pktHdr_update(RTSKB_SKB(rtskb), PPPOE_SES_HLEN, rtskb, pPktHdr)<0)
	{
		WARNING("skb head room is not enough");
		return FAIL;
	}

	RTK_FC_HOOK_PS_SKB_SKB_PUSH(RTSKB_SKB(rtskb), PPPOE_SES_HLEN, &pData);
	memmove(pData, pData + PPPOE_SES_HLEN, insertOff);

	RTSKB_MAC_HEADER(rtskb) -= (PPPOE_SES_HLEN);
	// reset header pointer
	pPktHdr->eth = (struct ethhdr *)pData;

	if(pPktHdr->svh) pPktHdr->svh = (struct vlan_hdr *)((uint8 *)(pPktHdr->svh) - PPPOE_SES_HLEN);
	if(pPktHdr->cvh) pPktHdr->cvh = (struct vlan_hdr *)((uint8 *)(pPktHdr->cvh) - PPPOE_SES_HLEN);


	if(pPktHdr->cvh){
		l3proto = pPktHdr->cvh->h_vlan_encapsulated_proto;
		pPktHdr->cvh->h_vlan_encapsulated_proto = htons(ETH_P_PPP_SES);
	}
	else if(pPktHdr->svh){
		l3proto = pPktHdr->svh->h_vlan_encapsulated_proto;
		pPktHdr->svh->h_vlan_encapsulated_proto = htons(ETH_P_PPP_SES);
	}else{
		l3proto = pPktHdr->eth->h_proto;
		pPktHdr->eth->h_proto = htons(ETH_P_PPP_SES);
	}

	if(l3proto == htons(ETH_P_IPV6))
		l3proto = 0x0057;
	else
		l3proto = 0x0021;

	pPktHdr->ppph = (struct pppoe_hdr *)(pData + insertOff);
	pPktHdr->ppph->type = 1;
	pPktHdr->ppph->ver = 1;
	pPktHdr->ppph->code = 0;	// session data
	pPktHdr->ppph->sid = htons(sessionid);
	pPktHdr->ppph->length = htons(RTSKB_LEN(rtskb) - insertOff - PPPOE_SES_HLEN +2); // payload length includes p2p protocol(2 bytes)
	//p2p protocol
	pData[insertOff+6] = l3proto>>8;
	pData[insertOff+7] = l3proto&0xff;

	return (SUCCESS);
}

__IRAM_FC_SHORTCUT
static int _rtk_fc_skbPPPoETag_remove(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	uint8 *pData = RTSKB_DATA(rtskb);
	uint8 *pP2Pproto = NULL;
	uint16 l3proto = 0;
	int rmOff = 0, rmSize = PPPOE_SES_HLEN;

	FC_PARAM_CHK(pPktHdr->eth==NULL, RTK_FC_RET_ERR_INVALID_PARAM);
	FC_PARAM_CHK(pPktHdr->ppph==NULL, RTK_FC_RET_ERR_INVALID_PARAM);

	pP2Pproto = ((uint8 *)pPktHdr->ppph + 6);
	if(pP2Pproto[0]==0x21 || (pP2Pproto[0]==0x0 && pP2Pproto[1]==0x21))
		l3proto = ETH_P_IP;
	else if(pP2Pproto[0]==0x57 || (pP2Pproto[0]==0x0 && pP2Pproto[1]==0x57))
		l3proto = ETH_P_IPV6;
	else{
		WARNING("unknown l3 proto 0x%x", pP2Pproto[0]<<8|pP2Pproto[1]);
		return RTK_FC_RET_ERR;
	}
	if(pP2Pproto[0]!=0x0) rmSize-=1;


	rmOff += (ETH_HLEN);

	if(pPktHdr->svh) rmOff+= VLAN_HLEN;
	if(pPktHdr->cvh) rmOff+= VLAN_HLEN;

	memmove(pData+rmSize, pData, rmOff);		// remove pppoe header

	RTSKB_DATA(rtskb)+=rmSize;
	RTSKB_LEN(rtskb)-=rmSize;
	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

	pPktHdr->eth = (struct ethhdr *)(pData+rmSize);
	if(pPktHdr->svh) 
	{
		pPktHdr->svh = (struct vlan_hdr *)((uint8 *)RTSKB_DATA(rtskb) + sizeof(struct ethhdr));
	}
	if(pPktHdr->cvh)
	{
		if(pPktHdr->svh)
		{
			pPktHdr->cvh = (struct vlan_hdr *)((uint8 *)RTSKB_DATA(rtskb) + sizeof(struct ethhdr) + VLAN_HLEN);
		}
		else
		{
			pPktHdr->cvh = (struct vlan_hdr *)((uint8 *)RTSKB_DATA(rtskb) + sizeof(struct ethhdr));
		}
	}

	if(pPktHdr->cvh)
		pPktHdr->cvh->h_vlan_encapsulated_proto = htons(l3proto);
	else if(pPktHdr->svh)
		pPktHdr->svh->h_vlan_encapsulated_proto = htons(l3proto);
	else
		pPktHdr->eth->h_proto = htons(l3proto);


	return (SUCCESS);
}


__IRAM_FC_SHORTCUT
int _rtk_fc_skbHdrPointerReset(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	if(pPktHdr->eth){
		RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

		//DEBUG("skb head %p, data %p", rtskb->skb->head, RTSKB_DATA(rtskb));		// rtskb->skb->...  only for debug usage

		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN)
		{
			RTK_FC_HOOK_PS_SKB_SKB_SET_NETWORK_HEADER(RTSKB_SKB(rtskb), ((uint8 *)pPktHdr->outer_iph - (uint8 *)pPktHdr->outer_eth));
		}
		else if(pPktHdr->dualHdrType != RTK_FC_DUALTYPE_NONE)
		{
			RTK_FC_HOOK_PS_SKB_SKB_SET_NETWORK_HEADER(RTSKB_SKB(rtskb), ((uint8 *)pPktHdr->outer_iph - (uint8 *)pPktHdr->eth));
		}
		else
		{
			if(pPktHdr->iph){
				//pPktHdr->iph = (struct iphdr *)((uint8 *)pPktHdr->iph + len_diff);
				RTK_FC_HOOK_PS_SKB_SKB_SET_NETWORK_HEADER(RTSKB_SKB(rtskb), ((uint8 *)pPktHdr->iph - (uint8 *)pPktHdr->eth));
			}
			else if(pPktHdr->ip6h){
				//pPktHdr->ip6h = (struct ipv6hdr *)((uint8 *)pPktHdr->ip6h + len_diff);
				RTK_FC_HOOK_PS_SKB_SKB_SET_NETWORK_HEADER(RTSKB_SKB(rtskb), ((uint8 *)pPktHdr->ip6h - (uint8 *)pPktHdr->eth));
			}
		}

		if(pPktHdr->tcph){
			//pPktHdr->tcph = (struct tcphdr *)((uint8 *)pPktHdr->tcph + len_diff);
			RTK_FC_HOOK_PS_SKB_SKB_SET_TRANSPORT_HEADER(RTSKB_SKB(rtskb), ((uint8 *)pPktHdr->tcph - (uint8 *)pPktHdr->eth));
		}
		else if(pPktHdr->udph){
			//pPktHdr->udph = (struct udphdr *)((uint8 *)pPktHdr->udph + len_diff);
			RTK_FC_HOOK_PS_SKB_SKB_SET_TRANSPORT_HEADER(RTSKB_SKB(rtskb), ((uint8 *)pPktHdr->udph - (uint8 *)pPktHdr->eth));
		}

		//DEBUG("offset: l2 %d, l3 %d, l4 %d", RTSKB_MAC_HEADER(rtskb), rtskb->skb->network_header , rtskb->skb->transport_header); // rtskb->skb->...  only for debug usage
	}
	return (SUCCESS);
}


/*
* for PPPoE and VLAN tags, do insert or remove before wifi tx
*/
__IRAM_FC_SHORTCUT
int _rtk_fc_swPktHdrModify(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowEnt)
{
	uint16 vlanTCI = 0;
	int16 len_diff = 0;

	FC_PARAM_CHK(pPktHdr==NULL, FAIL);
	FC_PARAM_CHK(rtskb==NULL, FAIL);
	FC_PARAM_CHK(pFlowEnt==NULL, FAIL);
	FC_PARAM_CHK(pFlowEnt->pFlowEntry==NULL, FAIL);

	if(fc_db.debugLevel & FC_DEBUG_LEVEL_TRACE_DUMP)
		DUMP_PACKET(RTSKB_DATA(rtskb),RTSKB_LEN(rtskb),"before modify packet");

	// SVLAN
	if(pFlowEnt->pFlowEntry->path5.out_svid_format_act)								//Tag
	{
		vlanTCI = pFlowEnt->pFlowEntry->path5.out_svlan_id | (pFlowEnt->pFlowEntry->path5.out_spri<<VLAN_PRIO_SHIFT) | (pFlowEnt->egr_svlan_dei<<VLAN_CFI_SHIFT);
		if(pPktHdr->svh){
			pPktHdr->svh->h_vlan_TCI = htons(vlanTCI);
		}
		else{
			len_diff+=4;
			rtk_fc_skbVlanTag_insert(rtskb, pPktHdr, vlanTCI, TRUE);
		}
	}else																//Untag
	{
		if(pPktHdr->svh){
			len_diff-=4;
			rtk_fc_skbVlanTag_remove(rtskb, pPktHdr, TRUE);
		}
		else{
			// nothing
		}
	}

	// CVLAN
	//DEBUG("out_cvid_format_act=%d pPktHdr->cvh=%p pFlowEnt->path5.out_cvlan_id=%d",pFlowEnt->path5.out_cvid_format_act,pPktHdr->cvh,pFlowEnt->path5.out_cvlan_id);
	if(pFlowEnt->pFlowEntry->path5.out_cvid_format_act)									//Tag
	{
		vlanTCI = pFlowEnt->pFlowEntry->path5.out_cvlan_id | (pFlowEnt->pFlowEntry->path5.out_cpri<<VLAN_PRIO_SHIFT | (pFlowEnt->egr_cvlan_cfi<<VLAN_CFI_SHIFT));
		if(pPktHdr->cvh){
			pPktHdr->cvh->h_vlan_TCI = htons(vlanTCI);
		}
		else{
			len_diff+=4;
			rtk_fc_skbVlanTag_insert(rtskb, pPktHdr, vlanTCI, FALSE);
		}
	}else																//Untag
	{
		if(pPktHdr->cvh) {
			len_diff-=4;
			rtk_fc_skbVlanTag_remove(rtskb, pPktHdr, FALSE);
		}else{
			// nothing
		}
	}

	// PPPoE - only path5 routing/nat case or path1/2/3/4 smac_trans case
	if((pFlowEnt->pFlowEntry->path1.in_path == FB_PATH_5) || (pFlowEnt->pFlowEntry->path1.in_path < FB_PATH_5 && pFlowEnt->pFlowEntry->path1.out_smac_trans)) {
		if((pPktHdr->ppph==NULL) &&
			( (fc_db.netifHwTbl[pFlowEnt->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_ADD) ||
			(fc_db.netifHwTbl[pFlowEnt->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_MODIFY))  ) 			//untag => tag
		{
			len_diff+=8;
			_rtk_fc_skbPPPoETag_insert(rtskb, pPktHdr, fc_db.netifHwTbl[pFlowEnt->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_sid);
		}
		else if((pPktHdr->ppph) && (fc_db.netifHwTbl[pFlowEnt->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_REMOVE))	//tag => untag
		{
			len_diff-=8;
			_rtk_fc_skbPPPoETag_remove(rtskb, pPktHdr);
		}
		else 																//untag => untag, tag => tag
		{
			// nothing
		}
	}

	if(fc_db.debugLevel & FC_DEBUG_LEVEL_TRACE_DUMP)
		DUMP_PACKET(RTSKB_DATA(rtskb),RTSKB_LEN(rtskb),"after modify packet");

	DEBUG("lendiff %d", len_diff);

#if 0
	// reset skb L234 header
	// [IMPORTANT] for CA-G3: CA api L4 checksum offload needs correct header pointer!
	_rtk_fc_skbHdrPointerReset(rtskb, pPktHdr);
#endif

	return (SUCCESS);
}


extern uint16 patternSizeMapping[FLOW_PATTERN_MAX]; 	//byte unit 

// sync with rtk_fc_abstrSwFlowPatternGenBySkb
__IRAM_FC_SHORTCUT
int rtk_fc_parseAbstrSwPattenField(uint8 isIpv6,rtk_fc_abstrSwFlowPattern_entry_t *swFlowKey,rtk_fc_abstrSwFlowPattenField_entry_t *pField)
{

	rtk_fc_abstrSwFlowType_entry_t *flowType;
	uint32 offset=0;

	flowType=&fc_db.abstrSwFlowType[swFlowKey->bits.flowtype];

	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_PHY_LSPID))
	{
		pField->pLspid=&swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_PHY_LSPID];
	}
	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_PHY_STREAMID))
	{
		pField->pPonStreaId=&swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_PHY_STREAMID];
	}
	
	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_DMAC))
	{
		pField->pDmac = &swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_L2_DMAC];

	}
	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_SMAC))
	{
		pField->pSmac = &swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_L2_SMAC];
	}
	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_ETH))
	{
		pField->pEth = (uint16*)&swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_L2_ETH];
	}

	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_CVLANTAG))
	{
		pField->pCvlanTCI = (uint16*)&swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_L2_CVLANTAG];		
	}

	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_SVLANTAG))
	{
		pField->pSvlanTCI = (uint16*)&swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_L2_SVLANTAG];		
	}

	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_PPPOETAG))
	{
		if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L2_PPPOESID))
		{
			pField->pPppoeSid = (uint16*)&swFlowKey->swPattern[offset];
			offset+=patternSizeMapping[FLOW_L2_PPPOESID];			
		}
	}
	
	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L3_IPVER46))
	{
		if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L3_DIP))
		{
			pField->pDip = (uint32*)&swFlowKey->swPattern[offset];
			offset+=patternSizeMapping[FLOW_L3_DIP];	
		}
		if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L3_SIP))
		{
			pField->pSip = (uint32*)&swFlowKey->swPattern[offset];
			offset+=patternSizeMapping[FLOW_L3_SIP];	
		}
		if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L3_TOS))
		{
			pField->pTos = &swFlowKey->swPattern[offset];
			offset+=patternSizeMapping[FLOW_L3_TOS];			
		}
	}

	if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L4_PROTO))
	{
		pField->pL4Porto = &swFlowKey->swPattern[offset];
		offset+=patternSizeMapping[FLOW_L4_PROTO];				

		if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L4_DPORT))
		{
			pField->pL4Dport = (uint16*)&swFlowKey->swPattern[offset];
			offset+=patternSizeMapping[FLOW_L4_DPORT];		
		}
		if(flowType->patternFlagMsk & TYPETOMSK(FLOW_L4_SPORT))
		{
			pField->pL4Sport =(uint16*)&swFlowKey->swPattern[offset];
			offset+=patternSizeMapping[FLOW_L4_SPORT];				
		}
	}

	return SUCCESS;
}

// older sync with rtk_fc_abstrSwFlowActGenBySkb
__IRAM_FC_SHORTCUT
int rtk_fc_parseAbstrSwActionField(uint8 isIpv6,rtk_fc_abstrSwFlowAction_entry_t *pSwFlowAction,rtk_fc_abstrSwFlowActionField_entry_t *pField)
{
	
	uint32 offset=0;

	if(pSwFlowAction->bits.dmacTrans)
	{
		pField->pDmac=&pSwFlowAction->swAction[offset];
		offset+=patternSizeMapping[FLOW_L2_DMAC];
		TRACE("dmacTrans  DMAC:%pM",pField->pDmac);
	}
	
	if(pSwFlowAction->bits.smacTrans)
	{
		pField->pSmac=&pSwFlowAction->swAction[offset];
		offset+=patternSizeMapping[FLOW_L2_SMAC];
		TRACE("smacTrans SMAC:%pM",pField->pSmac);
	}

	if(pSwFlowAction->bits.stagCmd==SWFLOW_EGACT_TAG)
	{
		pField->pSvlanTCI=(uint16*)(&pSwFlowAction->swAction[offset]);
		offset+=patternSizeMapping[FLOW_L2_SVLANTAG];
		TRACE("stagCmd[EgressTag] SVLAN_TCI:%x",*pField->pSvlanTCI);
	}
	else
		TRACE("stagCmd[Untag]");
	
	if(pSwFlowAction->bits.ctagCmd==SWFLOW_EGACT_TAG)
	{
		pField->pCvlanTCI=(uint16*)(&pSwFlowAction->swAction[offset]);
		offset+=patternSizeMapping[FLOW_L2_CVLANTAG];
		TRACE("ctagCmd[EgressTag] CVLAN_TCI:%x",*pField->pCvlanTCI);
	}
	else
		TRACE("ctagCmd[Untag]");
	
	if(pSwFlowAction->bits.pppoeCmd==SWFLOW_EGACT_TAG)
	{
		pField->pPppoeSid=(uint16*)(&pSwFlowAction->swAction[offset]);
		offset+=patternSizeMapping[FLOW_L2_PPPOESID];
		TRACE("pppoeCmd[EgressTag] %x",*pField->pPppoeSid);
	}
	else
		TRACE("pppoeCmd[Untag]");
	
	if(pSwFlowAction->bits.dipTrans)
	{
		if(isIpv6==0)
		{
			pField->pDip=(uint32*)(&pSwFlowAction->swAction[offset]);	
			TRACE("dipTrans DIP:%pI4h",pField->pDip);
			offset+=patternSizeMapping[FLOW_L3_DIP];
		}
		else if(isIpv6==1)
		{
			pField->pDip=(uint32*)(&pSwFlowAction->swAction[offset]);
			TRACE("dipTrans DIP:%pI6",pField->pDip);
			offset+=(patternSizeMapping[FLOW_L3_DIP]*4);
		}
	}
	
	if(pSwFlowAction->bits.sipTrans)
	{
		//TODO:Not support yet
		if(isIpv6==0)
		{
			pField->pSip=(uint32*)(&pSwFlowAction->swAction[offset]);
			TRACE("sipTrans SIP:%pI4h",pField->pSip);
			offset+=patternSizeMapping[FLOW_L3_SIP];
		}
		else if(isIpv6==1)
		{
			pField->pSip=(uint32*)(&pSwFlowAction->swAction[offset]);
			TRACE("sipTrans SIP%pI6",pField->pSip);
			offset+=(patternSizeMapping[FLOW_L3_SIP]*4);
		}
	}
	
	if(pSwFlowAction->bits.dscpCmd || pSwFlowAction->bits.ecnCmd)
	{
		pField->pTos=&pSwFlowAction->swAction[offset];
		TRACE("dscpCmd=%d/ecnCmd=%d  Tos:%x",pSwFlowAction->bits.dscpCmd,pSwFlowAction->bits.ecnCmd,*pField->pTos);
		offset+=patternSizeMapping[FLOW_L3_TOS];
	}
	
	if(pSwFlowAction->bits.l4dportCmd)
	{
		pField->pL4Dport=(uint16*)(&pSwFlowAction->swAction[offset]);
		TRACE("l4dportCmd DPORT:%x",*pField->pL4Dport);
		offset+=patternSizeMapping[FLOW_L4_DPORT];
	}
	
	if(pSwFlowAction->bits.l4sportCmd)
	{
		pField->pL4Sport=(uint16*)(&pSwFlowAction->swAction[offset]);
		TRACE("l4sportCmd SPORT:%x",*pField->pL4Sport);
		offset+=patternSizeMapping[FLOW_L4_SPORT];
	}
	
	
	if(pSwFlowAction->bits.userPriCmd)
	{
		pField->pUserPri=&pSwFlowAction->swAction[offset];		
		TRACE("userPriCmd USERPRI:%x",*pField->pUserPri);
		offset+=1;
	}
	if(pSwFlowAction->bits.ponStreamIdCmd)
	{
		pField->pPonStreaId=&pSwFlowAction->swAction[offset];
		TRACE("ponStreamIdCmd STREAMID:%x",*pField->pPonStreaId);
		offset+=patternSizeMapping[FLOW_PHY_STREAMID];
	}

	return SUCCESS;
}

/*
* for PPPoE and VLAN tags, do insert or remove before wifi tx
*/
__IRAM_FC_SHORTCUT
int rtk_fc_abstrSwPktHdrModify(struct rt_skbuff *rtskb, struct vlan_hdr *svh,struct vlan_hdr *cvh,struct pppoe_hdr *ppph, rtk_fc_abstrSwFlowAction_entry_t *pSwFlowAction,rtk_fc_abstrSwFlowActionField_entry_t *pActField)
{
	FC_PARAM_CHK(rtskb==NULL, FAIL);
	FC_PARAM_CHK(pSwFlowAction==NULL, FAIL);
	FC_PARAM_CHK(pActField==NULL, FAIL);

	if(fc_db.debugLevel & FC_DEBUG_LEVEL_TRACE_DUMP)
		dump_packet(RTSKB_DATA(rtskb),RTSKB_LEN(rtskb),"before modify packet");

	if((ppph==NULL) && (pSwFlowAction->bits.pppoeCmd==SWFLOW_EGACT_TAG))
	{
		//untag => tag
		int offset=ETH_HLEN-ETH_TLEN;
		if(svh)
			offset+=VLAN_HLEN;
		if(cvh)
			offset+=VLAN_HLEN;
		_rtk_fc_skbPPPoETag_fast_insert(rtskb, offset,*pActField->pPppoeSid);
	}
	else if((ppph) && (pSwFlowAction->bits.pppoeCmd==SWFLOW_EGACT_UNTAG))
	{
		//tag => untag
		int offset=ETH_HLEN-ETH_TLEN;
		if(svh)
			offset+=VLAN_HLEN;
		if(cvh)
			offset+=VLAN_HLEN;		
		_rtk_fc_skbPPPoETag_fast_remove(rtskb, offset);
	}


	// CVLAN
	if(pSwFlowAction->bits.ctagCmd==SWFLOW_EGACT_TAG)
	{
		if(cvh)
		{
			//tag -> tag
			cvh->h_vlan_TCI = htons(*pActField->pCvlanTCI);
		}
		else
		{
			//untag->tag
			rtk_fc_skbVlanTag_fast_insert(rtskb, ETH_HLEN-ETH_TLEN+(svh?VLAN_HLEN:0),ETH_P_8021Q, *pActField->pCvlanTCI);				
		}
	}
	else
	{	
		//EGRESS UNTAG
		if(cvh)
		{
			//tag->untag
			rtk_fc_skbVlanTag_fast_remove(rtskb, ETH_HLEN-ETH_TLEN+(svh?VLAN_HLEN:0));
		}
		else
		{
			//untag->untag
		}
	}

	// SVLAN
	if(pSwFlowAction->bits.stagCmd==SWFLOW_EGACT_TAG)
	{
		if(svh)
		{
			//tag -> tag
			svh->h_vlan_TCI = htons(*pActField->pSvlanTCI);
		}
		else
		{
			//untag->tag
			rtk_fc_skbVlanTag_fast_insert(rtskb, ETH_HLEN-ETH_TLEN,ETH_P_8021AD, *pActField->pSvlanTCI);				
		}
	}
	else
	{
		//EGRESS UNTAG
		if(svh)
		{
			//tag->untag
			rtk_fc_skbVlanTag_fast_remove(rtskb,  ETH_HLEN-ETH_TLEN);
		}
		else
		{
			//untag->untag
		}
	}

	if(fc_db.debugLevel & FC_DEBUG_LEVEL_TRACE_DUMP)
		dump_packet(RTSKB_DATA(rtskb),RTSKB_LEN(rtskb),"after modify packet");

	return (SUCCESS);
}

__IRAM_FC_SHORTCUT
int _rtk_fc_abstrSw_flow_packet_modification(struct rt_skbuff *rtskb_handle, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr,  rtk_fc_abstrSwFlowActionList_entry_t *pSwFlowAction, struct ipv6hdr *ip6h_tmp,
														struct ethhdr *eth_tmp,	struct vlan_hdr *svh_tmp,struct vlan_hdr *cvh_tmp, struct pppoe_hdr *ppph_tmp,struct iphdr *iph_tmp, struct tcphdr *tcph_tmp,	struct udphdr *udph_tmp, rtk_fc_abstrSwFlowActionField_entry_t *pActField,
														int32 softwareModify)
{

	uint16 oriTos=0;

	rtk_fc_parseAbstrSwActionField((ip6h_tmp?TRUE:FALSE),&pSwFlowAction->swFlowAction,pActField);

	//we modify start from L4 to L2 and do not use higher point after modify (I don't want to updata L3/L4 point if remove ctag/stag/pppoeTag)

	/*  L4 modify */
	if(pSwFlowAction->swFlowAction.bits.l4dportCmd)
	{
		if(udph_tmp)
			udph_tmp->dest = htons(*pActField->pL4Dport);
		else if(tcph_tmp)
			tcph_tmp->dest = htons(*pActField->pL4Dport);

	}
	if(pSwFlowAction->swFlowAction.bits.l4sportCmd)
	{
		if(udph_tmp)
			udph_tmp->source = htons(*pActField->pL4Sport);
		else if(tcph_tmp)
			tcph_tmp->source = htons(*pActField->pL4Sport);

	}
	
	/* L3 modify */
	if(pSwFlowAction->swFlowAction.bits.dipTrans)
	{
		if(iph_tmp)
			iph_tmp->daddr = htonl(*pActField->pDip);
		else if(ip6h_tmp)
			memcpy(&ip6h_tmp->daddr,pActField->pDip,sizeof(ip6h_tmp->daddr));
	}
	if(pSwFlowAction->swFlowAction.bits.sipTrans)
	{
		if(iph_tmp)
			iph_tmp->saddr = htonl(*pActField->pSip);
		else if(ip6h_tmp)
			memcpy(&ip6h_tmp->saddr,pActField->pSip,sizeof(ip6h_tmp->saddr));
	}
	if(pSwFlowAction->swFlowAction.bits.dscpCmd || pSwFlowAction->swFlowAction.bits.ecnCmd)
	{
		if(iph_tmp)
		{
			oriTos = iph_tmp->tos;
			if(pSwFlowAction->swFlowAction.bits.dscpCmd)
			{
				iph_tmp->tos &= (~FC_IP_DSCP_MASK);
				iph_tmp->tos |= ((*pActField->pTos)&FC_IP_DSCP_MASK);
			}
			if(pSwFlowAction->swFlowAction.bits.ecnCmd)
			{
				iph_tmp->tos &= (~FC_IP_ECN_MASK);
				iph_tmp->tos |= ((*pActField->pTos)&FC_IP_ECN_MASK);
			}
		}
		else if(ip6h_tmp)
		{
			oriTos = (ip6h_tmp->priority<<8) | (ip6h_tmp->flow_lbl[0]);
			if(pSwFlowAction->swFlowAction.bits.dscpCmd)
			{
				ip6h_tmp->flow_lbl[0] &= 0x3f;
				ip6h_tmp->priority = (*pActField->pTos>>4)&0xf;
				ip6h_tmp->flow_lbl[0] |= ((*pActField->pTos)&0xc)<<4;
			}
			if(pSwFlowAction->swFlowAction.bits.ecnCmd)
			{
				ip6h_tmp->flow_lbl[0] &= 0xcf;
				ip6h_tmp->flow_lbl[0] |= ((*pActField->pTos)&0x3)<<4;
			}
		}
	}

	/* we put mac modify in l3 because smacTrans may decrease ttl */
	if(pSwFlowAction->swFlowAction.bits.dmacTrans)
	{
		memcpy(eth_tmp->h_dest, pActField->pDmac, ETH_ALEN);
	}

	if(pSwFlowAction->swFlowAction.bits.smacTrans)
	{
		memcpy(eth_tmp->h_source, pActField->pSmac, ETH_ALEN);
		if(iph_tmp)
		{
			iph_tmp->ttl--;
			if(iph_tmp->ttl<=0)
				return FAILED;
		}
		else if(ip6h_tmp)
		{
			ip6h_tmp->hop_limit--;
			if(ip6h_tmp->hop_limit <=0)
				return FAILED;
		}
	}

	//checksum update
	if(softwareModify && (iph_tmp))
	{
		// to wifi or dual header: s/w needs to update (inner) l34 checksum
		iph_tmp->check =  _rtk_fc_L3ChecksumDiff_update(ntohs(iph_tmp->check), 0, 0, oriTos,
																0, 0, iph_tmp->tos , pSwFlowAction->swFlowAction.bits.smacTrans?-1:0);
	}

	/* L2 Modify  PPPoE -> Ctag -> Stag */
	//	do tag action
	if(softwareModify)
	{
		TRACE("do softwarestag/ctag/pppoe tag action");
		rtk_fc_abstrSwPktHdrModify(rtskb_handle, svh_tmp,cvh_tmp,ppph_tmp, &pSwFlowAction->swFlowAction,pActField);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)			
		_rtk_fc_updateLsoPara0(rtskb, pPktHdr);
#endif
		pPktHdr->skbLen_egress = RTSKB_LEN(rtskb_handle) + 4;			// egress length is updated already by _rtk_fc_swPktHdrModify
	}
	else
	{
		FIXME("should do this in txDesc");
	}
	return SUCCESS;
}


__IRAM_FC_SHORTCUT
int rtk_fc_abstrSw_flowModifyAndDirTx(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr,uint32 flowTblIdx )
{
	struct ethhdr *eth_tmp=NULL;
	struct iphdr *iph_tmp=NULL; //NULL: not ipv4 header
	struct tcphdr *tcph_tmp=NULL; //NULL: not tcp header
	struct udphdr *udph_tmp=NULL; //NULL: not udp header
	struct vlan_hdr *svh_tmp=NULL;
	struct vlan_hdr *cvh_tmp=NULL;
	struct pppoe_hdr *ppph_tmp=NULL; // NULL: untag
	struct ipv6hdr *ip6h_tmp=NULL; //NULL: not ipv6 header
	struct rt_skbuff *rtskb_handle=NULL;
	struct sk_buff *skb_handle=NULL;
	struct net_device *pWifiDev=NULL;
	struct sk_buff *wifi_skb=NULL;
	struct rt_skbuff *wifi_rtskb=NULL;	
	rtk_fc_abstrSwFlowList_entry_t *pAbstrSwFlowEt;
	rtk_fc_abstrSwFlowActionList_entry_t *pSwFlowAction;
	rtk_fc_abstrSwFlowLdpid_entry_t *pTmpLdpid=NULL;
	rtk_fc_abstrSwFlowActionField_entry_t *pActField;
	fc_tx_info_t	*ptxInfo;

	uint32 eth_off=0, svh_off=0, cvh_off=0, ppph_off=0, iph_off=0, ip6h_off=0,l4_off=0;
	uint32 pktActCopyCnt=0,handleActCnt=0;
	uint32 toWifiCloneCnt=0,handleWifiCnt=0,toPhyCloneCnt=0,handlePhyCnt=0;
	uint32 pmsk=0;
	int32 ret;
	bool isFirstPkt = TRUE;
	int32 softwareModify=0;


	if(!rtskb || !pPktHdr || !fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt)
		return RTK_FC_RET_LRN_NULL_POINTER;

	pPktHdr->flowIdx = flowTblIdx;		// required by egres tx

	ptxInfo = RTK_FC_HELPER_FC_KMALLOC(sizeof(fc_tx_info_t), GFP_ATOMIC);
	pAbstrSwFlowEt = fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt;
	pActField = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_abstrSwFlowActionField_entry_t), GFP_ATOMIC);


	list_for_each_entry(pSwFlowAction, &fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt->swFlowActionHdr, swFlowActionList)
	{
		pktActCopyCnt++;
	}
	
	rtskb_handle = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct rt_skbuff), GFP_ATOMIC);
	wifi_rtskb = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct rt_skbuff), GFP_ATOMIC);

	if(pPktHdr->eth)
		eth_off = (uint8 *)pPktHdr->eth-RTSKB_DATA(rtskb);
	if(pPktHdr->svh)
		svh_off = (uint8 *)pPktHdr->svh-RTSKB_DATA(rtskb);
	if(pPktHdr->cvh)
		cvh_off = (uint8 *)pPktHdr->cvh-RTSKB_DATA(rtskb);
	if(pPktHdr->ppph)
		ppph_off = (uint8 *)pPktHdr->ppph-RTSKB_DATA(rtskb);
	if(pPktHdr->iph)
		iph_off = (uint8 *)pPktHdr->iph-RTSKB_DATA(rtskb);
	else if (pPktHdr->ip6h)
		ip6h_off = (uint8 *)pPktHdr->ip6h-RTSKB_DATA(rtskb);
	if(pPktHdr->tcph )
		l4_off = (uint8 *)pPktHdr->tcph-RTSKB_DATA(rtskb);
	else if (pPktHdr->udph)
		l4_off = (uint8 *)pPktHdr->udph-RTSKB_DATA(rtskb);
// ====================== start handle skb  ====================== 

	list_for_each_entry(pSwFlowAction, &fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt->swFlowActionHdr, swFlowActionList)
	{
		handleActCnt++;
		//per-skb init 
		toWifiCloneCnt=0;handleWifiCnt=0;
		toPhyCloneCnt=0;handlePhyCnt=0;
		softwareModify=0;
		pmsk=0;
		skb_handle=NULL;
		eth_tmp =NULL;svh_tmp =NULL;cvh_tmp =NULL;ppph_tmp =NULL;iph_tmp =NULL;ip6h_tmp =NULL;tcph_tmp=NULL;udph_tmp=NULL;
		bzero(pActField,sizeof(*pActField));
		memset(ptxInfo, 0, sizeof(fc_tx_info_t));

		list_for_each_entry(pTmpLdpid, &pSwFlowAction->ldpidListHdr, ldpidList)
		{
			if(pTmpLdpid->isWlan)
			{
				toWifiCloneCnt++;
			}
			else
			{
				pmsk|=(1<<pTmpLdpid->flowLdpid);
				toPhyCloneCnt++;
			}
		}
		
		if(toWifiCloneCnt)
		{
			softwareModify=1;
		}
// TODO:hwacc by txDesc after
//#if defined(CONFIG_RTK_L34_G3_PLATFORM) 
		softwareModify=1;
//#endif

		if(handleActCnt==(pktActCopyCnt))
		{
			//the last action packet using ori-skb
			skb_handle = RTSKB_SKB(rtskb);
		}
		else
		{
			//prepare a new skb to send
			RTK_FC_HOOK_PS_SKB_SKB_COPY(RTSKB_SKB(rtskb), GFP_ATOMIC, &skb_handle);
			if(skb_handle==NULL)
			{
				WARNING("skb_clone fail");
				ret = RTK_FC_RET_LRN_NULL_POINTER;
				goto RETURN_ERROR;
				
			}
		}
		
		RTK_FC_HOOK_CONVERTER_SKB(skb_handle, rtskb_handle);

		pPktHdr->pCurSwFlowAction = pSwFlowAction;
		pPktHdr->skbLen_egress = RTSKB_LEN(rtskb_handle);

		if(toWifiCloneCnt==0 &&  pmsk==0)
			goto SC_DROP;
		
		if(pPktHdr->eth)
			eth_tmp = (struct ethhdr *)(RTSKB_DATA(rtskb_handle) + eth_off);
		if(pPktHdr->svh)
			svh_tmp = (struct vlan_hdr *)(RTSKB_DATA(rtskb_handle) + svh_off);
		if(pPktHdr->cvh)
			cvh_tmp = (struct vlan_hdr *)(RTSKB_DATA(rtskb_handle) + cvh_off);
		if(pPktHdr->ppph)
			ppph_tmp = (struct pppoe_hdr *)(RTSKB_DATA(rtskb_handle) + ppph_off);
		if(pPktHdr->iph)
			iph_tmp = (struct iphdr *)(RTSKB_DATA(rtskb_handle) + iph_off);
		else if (pPktHdr->ip6h)
			ip6h_tmp = (struct ipv6hdr *)(RTSKB_DATA(rtskb_handle) + ip6h_off);
		if(pPktHdr->tcph )
			tcph_tmp = (struct tcphdr *) (RTSKB_DATA(rtskb_handle) + l4_off);
		else if (pPktHdr->udph)
			udph_tmp = (struct udphdr *) (RTSKB_DATA(rtskb_handle) + l4_off);

//=========================start  modify packet ===========================
		ret = _rtk_fc_abstrSw_flow_packet_modification(rtskb_handle, rtskb, pPktHdr ,  pSwFlowAction, ip6h_tmp, eth_tmp, svh_tmp, cvh_tmp , ppph_tmp ,iph_tmp, tcph_tmp,	udph_tmp, pActField, softwareModify);
		if(ret != SUCCESS)
			goto SC_DROP;
			
//================== start sending packet ==================
//================== To Wifi ==================
		if(toWifiCloneCnt)
		{
			list_for_each_entry(pTmpLdpid, &pSwFlowAction->ldpidListHdr, ldpidList)
			{
				if(pTmpLdpid->isWlan)
				{
					handleWifiCnt++;
					pWifiDev=NULL;
					if((RTK_FC_HELPER_WLAN_DEVID_TO_DEV(pTmpLdpid->flowLdpid, &pWifiDev))!=SUCCESS)
					{
						WARNING("[ToPS] fail to find wlan dev.. idx %d", pTmpLdpid->flowLdpid);
						continue;
					}

					if(toWifiCloneCnt==handleWifiCnt && toPhyCloneCnt==0)
					{
						//the last packet to wifi and no need send to phy we used ori-copy packet to reduce clone times
						wifi_skb=RTSKB_SKB(rtskb_handle);
					}
					else
					{
						RTK_FC_HOOK_PS_SKB_SKB_COPY(RTSKB_SKB(rtskb_handle), GFP_ATOMIC, &wifi_skb);
						if(wifi_skb==NULL) continue;
					}

					TRACE("Send to wifi sendMbssid:%d ",pTmpLdpid->flowLdpid);					
					RTK_FC_HOOK_CONVERTER_SKB(wifi_skb, wifi_rtskb);
					
					ret = rtk_fc_wifi_send_with_wlandevidx((rtk_fc_wlan_devidx_t)pTmpLdpid->flowLdpid, wifi_rtskb, pPktHdr, pSwFlowAction->swFlowAction.bits.userPriCmd?(*(pActField->pUserPri)):0);
					if(isFirstPkt)
					{
						pPktHdr->skbLen_ingress = 0; // only first packet couts ingress count
						isFirstPkt = FALSE;
					}					
					if(unlikely(ret&RTK_FC_RET_DROP))
					{
						if(unlikely(fc_db.fwdStatistic))
						{
							atomic_read(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
						}
						// free cloned skb now but free rtskb_handle at last step
						dev_kfree_skb_any(wifi_skb);
					}
				}
			}
		}
//==================To Phy Port ==================
		if(pmsk)
		{
			TXINFO_FS(ptxInfo)			= 1;
			TXINFO_LS(ptxInfo)			= 1;
			TXINFO_STAG_AWARE(ptxInfo)	= 1;
			TXINFO_IPCS(ptxInfo)		= 1;
			TXINFO_L4CS(ptxInfo)		= 1;
			TXINFO_DISLRN(ptxInfo)		= 1;
			TXINFO_L34_KEEP(ptxInfo)	= 1;
			
			TXINFO_ASPRI(ptxInfo) = pSwFlowAction->swFlowAction.bits.userPriCmd;
			if( pSwFlowAction->swFlowAction.bits.userPriCmd)
				TXINFO_CPUTAG_PRI(ptxInfo) = *(pActField->pUserPri);

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			if(!softwareModify)
			{
	 			// SVLAN
				if(pSwFlowAction->swFlowAction.bits.stagCmd)								//Tag
				{
					if(pSwFlowAction->swFlowAction.bits.stagCmd == SWFLOW_EGACT_TAG)
					{
						TXINFO_SVLAN_ACT(ptxInfo)  = 0x3;										//remarking
						TXINFO_SVLAN_VIDL(ptxInfo) = ((*pActField->pSvlanTCI)&0xff);
						TXINFO_SVLAN_VIDH(ptxInfo) = (((*pActField->pSvlanTCI)&0xf00)>>8);
						TXINFO_SVLAN_PRIO(ptxInfo) = ((*pActField->pSvlanTCI) & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;

						// decide egress packet length
						if(svh_tmp==NULL) pPktHdr->skbLen_egress += 4;
					}
					else if(pSwFlowAction->swFlowAction.bits.stagCmd == SWFLOW_EGACT_UNTAG)
					{
						TXINFO_SVLAN_ACT(ptxInfo)=0x2;										//remove stag
						// decide egress packet length
						if(svh_tmp) pPktHdr->skbLen_egress -= 4;
					}
				}


				// CVLAN
				if(pSwFlowAction->swFlowAction.bits.ctagCmd == SWFLOW_EGACT_TAG)
				{
					TXINFO_CVLAN_ACT(ptxInfo)=0x3;										//remarking
					TXINFO_CVLAN_VIDL(ptxInfo)=((*pActField->pCvlanTCI)&0xff);
					TXINFO_CVLAN_VIDH(ptxInfo)=(((*pActField->pCvlanTCI)&0xf00)>>8);
					TXINFO_CVLAN_PRIO(ptxInfo)=((*pActField->pCvlanTCI) & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;

					// decide egress packet length
					if(cvh_tmp) pPktHdr->skbLen_egress += 4;
				}
				else if (pSwFlowAction->swFlowAction.bits.ctagCmd == SWFLOW_EGACT_UNTAG)
				{
					TXINFO_CVLAN_ACT(ptxInfo)=0x2;										//remove ctag
					// decide egress packet length
					if(cvh_tmp) pPktHdr->skbLen_egress -= 4;
				}


				//TODO:interface decision
#if 0
				if((p_pktHdr_tmp->ppph==NULL) && pSwFlowAction->swFlowAction.bits.stagCmd==SWFLOW_EGACT_TAG)
				{
					TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_ADD;			//keep or add (always tag)
					TXINFO_TX_PPPOE_IDX(ptxInfo)=pTxFlowEnt->path3.out_intf_idx&0xf;
					// decide egress packet length
					pPktHdr->skbLen_egress += 8;
				}
				else if ((p_pktHdr_tmp->ppph) && (fc_db.netifHwTbl[pTxFlowEnt->path3.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_REMOVE))
				{
					TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_REMOVE; 	//remove
					TXINFO_TX_PPPOE_IDX(ptxInfo)=0;
					
					// decide egress packet length
					pPktHdr->skbLen_egress -= 8;
				}
				else
				{
					TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_KEEP;			//keep
					TXINFO_TX_PPPOE_IDX(ptxInfo)=0;
				}


				if(pTxFlowEnt->path3.out_stream_idx_act){
					TXINFO_CPUTAG_PSEL(ptxInfo) = 1;
					TXINFO_TX_DST_STREAM_ID(ptxInfo) = pTxFlowEnt->path3.out_stream_idx;
				}
#endif
			}
			TXINFO_TX_PORTMSK(ptxInfo) = pmsk;
			TRACE("direct Tx %s to pmsk[%x]", RTSKB_DEV(rtskb_handle)?RTSKB_DEV(rtskb_handle)->name:"NULL", pmsk);

			ret = rtk_fc_nic_send_with_txInfo(rtskb_handle, ptxInfo, 0, pPktHdr);
			if(isFirstPkt)
			{
				pPktHdr->skbLen_ingress = 0; // only first packet couts ingress count
				isFirstPkt = FALSE;
			}

			if(unlikely(ret&RTK_FC_RET_DROP))
			{
				if(unlikely(fc_db.fwdStatistic))
				{
					atomic_inc(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
				}				
				dev_kfree_skb_any(RTSKB_SKB(rtskb_handle));
			}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
{
			int dstPortIdx =  0;
			struct sk_buff *pTxPhySkb=NULL;
			struct rt_skbuff *rttxskb=NULL, rtTxSKB;
			rttxskb = &rtTxSKB;

			pPktHdr->skbLen_egress = RTSKB_LEN(rtskb);			// egress length is updated already by _rtk_fc_swPktHdrModify

			for(dstPortIdx = 0; dstPortIdx <= RTK_FC_MAC_PORT_PON; dstPortIdx++ )
			{
				if(pmsk&(1<<dstPortIdx))
				{
					handlePhyCnt++;

					if(toPhyCloneCnt==handlePhyCnt)
					{
						//the last packet to to phy we used ori-copy packet to reduce clone times
						pTxPhySkb=RTSKB_SKB(rtskb_handle);
						rttxskb=rtskb_handle;
					}
					else
					{
						RTK_FC_HOOK_PS_SKB_SKB_CLONE(RTSKB_SKB(rtskb_handle), GFP_ATOMIC, &pTxPhySkb);
						RTK_FC_HOOK_CONVERTER_SKB(pTxPhySkb, rttxskb);
					}
					TXINFO_TX_PORTMSK(ptxInfo) = (1<<dstPortIdx);

					TRACE("direct Tx to %s port[%d]", RTSKB_DEV(rttxskb)?RTSKB_DEV(rttxskb)->name:"NULL", dstPortIdx);
					
					ret = rtk_fc_nic_send_with_txInfo(rttxskb, ptxInfo, 0, pPktHdr);
					if(isFirstPkt)
					{
						pPktHdr->skbLen_ingress = 0; // only first packet couts ingress count
						isFirstPkt = FALSE;
					}

					if(unlikely(ret&RTK_FC_RET_DROP))
					{
						if(unlikely(fc_db.fwdStatistic))
						{
							atomic_inc(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
						}							
						dev_kfree_skb_any(pTxPhySkb);
					}
				}
			}
}
#endif
		}

		
		if(0)
		{
SC_DROP:
			dev_kfree_skb_any(RTSKB_SKB(rtskb_handle));
		}
	}

	if(ptxInfo) RTK_FC_HELPER_FC_KFREE(ptxInfo,sizeof(fc_tx_info_t));
	if(pActField) RTK_FC_HELPER_FC_KFREE(pActField,sizeof(rtk_fc_abstrSwFlowActionField_entry_t));
	if(rtskb_handle) RTK_FC_HELPER_FC_KFREE(rtskb_handle,sizeof(struct rt_skbuff));
	if(wifi_rtskb) RTK_FC_HELPER_FC_KFREE(wifi_rtskb,sizeof(struct rt_skbuff));
	return RTK_FC_RET_OK;

RETURN_ERROR:

	
	if(ptxInfo) RTK_FC_HELPER_FC_KFREE(ptxInfo,sizeof(fc_tx_info_t));
	if(pActField) RTK_FC_HELPER_FC_KFREE(pActField,sizeof(rtk_fc_abstrSwFlowActionField_entry_t));
	if(rtskb_handle) RTK_FC_HELPER_FC_KFREE(rtskb_handle,sizeof(struct rt_skbuff));
	if(wifi_rtskb) RTK_FC_HELPER_FC_KFREE(wifi_rtskb,sizeof(struct rt_skbuff));
	return ret;

}



#if defined(CONFIG_RTK_L34_G3_PLATFORM)
__IRAM_FC_SHORTCUT
int _rtk_fc_updateLsoPara0(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	// shortcut and not dual packet: fill DMA LSO parameter here
	pPktHdr->txlso_para0.bf.keep_txCon_lsopara = TRUE;

#if defined(CONFIG_FC_RTL8277C_SERIES)
	if (RTK_FC_NIC_TX_WO_HDR(rtskb)){
		//packet size less than MTU and disable nic tx mirror can use hp=11 faster tx api
		//ip fragment or disable ipv4 udp checksum or udp/tcp len=0 should configure auto checksum selection=disable
		if ((pPktHdr->ipFragFlag) || 
			(pPktHdr->udph && ((pPktHdr->udph->check==0) || (ntohs(pPktHdr->udph->len) == 0))) ||
			(pPktHdr->tcph && (pPktHdr->tcph->doff == 0)))
		{
			pPktHdr->txlso_para0.bf.tx_no_hdr_chk_dis = TRUE;
		}
		pPktHdr->txlso_para0.bf.bypass_en = TRUE;
		return RTK_FC_RET_OK;
	}
#endif

	if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE)
		pPktHdr->txlso_para0.bf.ipv6_en = TRUE;
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_6RD)
		pPktHdr->txlso_para0.bf.ipv4_en = TRUE;
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP)
	{
		if(pPktHdr->outer_iph->version == 0x4)
			pPktHdr->txlso_para0.bf.ipv4_en = TRUE;
		else if(pPktHdr->outer_iph->version == 0x6)
			pPktHdr->txlso_para0.bf.ipv6_en = TRUE;
	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP)
	{
		if(pPktHdr->outer_iph->version == 0x4)
		{
			pPktHdr->txlso_para0.bf.ipv4_en = TRUE;
			pPktHdr->txlso_para0.bf.udp_en = TRUE;
		}
		else if(pPktHdr->outer_iph->version == 0x6)
		{
			pPktHdr->txlso_para0.bf.ipv6_en = TRUE;
			pPktHdr->txlso_para0.bf.udp_en = TRUE;
		}
	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN)
	{
		if(pPktHdr->outer_iph->version == 0x4)
		{
			pPktHdr->txlso_para0.bf.ipv4_en = TRUE;
			pPktHdr->txlso_para0.bf.udp_en = TRUE;
		}
		else if(pPktHdr->outer_iph->version == 0x6)
		{
			pPktHdr->txlso_para0.bf.ipv6_en = TRUE;
			pPktHdr->txlso_para0.bf.udp_en = TRUE;
		}
	}
	else
	{
		if(pPktHdr->iph)
		{
			pPktHdr->txlso_para0.bf.ipv4_en = TRUE;
			if(pPktHdr->tcph && pPktHdr->tcph->doff)
				pPktHdr->txlso_para0.bf.tcp_en = TRUE;
			else if(pPktHdr->udph && (pPktHdr->udph->check != 0) && (ntohs(pPktHdr->udph->len) != 0))
				pPktHdr->txlso_para0.bf.udp_en = TRUE;
		}
		else if(pPktHdr->ip6h)
		{
			pPktHdr->txlso_para0.bf.ipv6_en = TRUE;
			if(pPktHdr->tcph && pPktHdr->tcph->doff)
				pPktHdr->txlso_para0.bf.tcp_en = TRUE;
			else if(pPktHdr->udph && (ntohs(pPktHdr->udph->len) != 0))
				pPktHdr->txlso_para0.bf.udp_en = TRUE;
		}
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if((pPktHdr->udph && ((pPktHdr->udph->check==0) || (ntohs(pPktHdr->udph->len) == 0))) ||
			(pPktHdr->tcph && (pPktHdr->tcph->doff == 0)))
		{
			pPktHdr->txlso_para0.bf.tx_no_hdr_chk_dis = TRUE;
		}
#endif
	}

	if (RTSKB_LEN(rtskb) < 64)
		pPktHdr->txlso_para0.bf.lenfix_en = TRUE;


	if (pPktHdr->ipFragFlag) {
#if defined(CONFIG_FC_RTL8277C_SERIES)
		pPktHdr->txlso_para0.bf.tx_no_hdr_chk_dis = TRUE;	//faster tx api with auto checksum selection disable
#endif
		pPktHdr->txlso_para0.bf.ipv4_en = FALSE;
		if (pPktHdr->tcph && pPktHdr->tcph->doff)
			pPktHdr->txlso_para0.bf.tcp_en = FALSE;
		else if(pPktHdr->udph && (pPktHdr->udph->check != 0) && (ntohs(pPktHdr->udph->len) != 0))
			pPktHdr->txlso_para0.bf.udp_en = FALSE;
	}

	return RTK_FC_RET_OK;
}
#endif


int _rtk_fc_mc_flowModifyAndDirTx(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable, rtk_fc_tableFlow_t *pFlowTable_mutiAct,uint32 path3Idx,uint32 path4Idx, bool ifSkipNicL2Offload)
{
	int ret = SUCCESS;
	rtk_fc_tableFlow_t *pTxFlowEnt;
	uint64 extPmsk=0;
	struct net_device *pWifiDev=NULL;
	rtk_fc_wlan_devidx_t wlan_dev_idx;
	int wlan_dev_idx_satrt,wlan_dev_idx_end,sendMbssid;
	struct sk_buff *wifi_skb=NULL;
	struct sk_buff *skb_handle=NULL,*path4_skb=NULL;
	struct rt_skbuff *rtskb_handle=NULL;
	struct rt_skbuff *wifi_rtskb=NULL;
	uint16 oriTos=0;
	uint32 eth_off=0, svh_off=0, cvh_off=0, ppph_off=0, iph_off=0, ip6h_off=0;
	uint8 send2MultiAction=0;
	uint32 out_portmask=0x0, out_portmask_bitCnt=0;
	rtk_fc_pktHdr_t *p_pktHdr_tmp;
	fc_tx_info_t	*ptxInfo;
	int shortCut_dpi_ret = 0;
	bool isFirstPkt = TRUE;
	uint8 forceSwChksum = FALSE;
	uint8 noL4Chksum = FALSE;


	


	if(!pFlowTable || !pFlowTable->pFlowEntry || !pPktHdr) return RTK_FC_RET_LRN_NULL_POINTER;
	if(pFlowTable->pFlowEntry->path3.out_multiple_act && (pFlowTable_mutiAct==NULL || pFlowTable_mutiAct->pFlowEntry==NULL)) return RTK_FC_RET_LRN_NULL_POINTER;
	if(path3Idx >= (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE)) return RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE;
	if(path4Idx >= (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE)) return RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(pFlowTable->candidateState==CANDIDATE_STATE_NONE) return RTK_FC_RET_LRN_NOT_SUPPORT;
#else
	if(!pFlowTable->pFlowEntry->path1.valid) return RTK_FC_RET_LRN_NOT_SUPPORT;
#endif

	p_pktHdr_tmp = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_pktHdr_t), GFP_ATOMIC);
	ptxInfo = RTK_FC_HELPER_FC_KMALLOC(sizeof(fc_tx_info_t), GFP_ATOMIC);
	memset(ptxInfo, 0, sizeof(fc_tx_info_t));

	rtskb_handle = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct rt_skbuff), GFP_ATOMIC);
	wifi_rtskb = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct rt_skbuff), GFP_ATOMIC);

	pWifiDev=NULL;
	wlan_dev_idx=RTK_FC_WLANX_NOT_FOUND;

	TRACE("Hit Mc shortcut Tx");

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if(RTSKB_LEN(rtskb) > RE8670_MAX_ETH_FRAME_SIZE) // nic limitation
	{
		forceSwChksum = TRUE;
	}
#endif	

	if(pPktHdr->iph && pPktHdr->udph && pPktHdr->udph->check==0){
		noL4Chksum = TRUE;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if (RTK_FC_NIC_TX_WO_HDR(rtskb))
			forceSwChksum = TRUE;
#endif
	}

	if(pFlowTable->pFlowEntry->path3.out_multiple_act)
	{
		RTK_FC_HOOK_PS_SKB_SKB_COPY(RTSKB_SKB(rtskb), GFP_ATOMIC, &path4_skb);
		if(path4_skb==NULL)
		{
			WARNING("skb_clone fail");
			ret = RTK_FC_RET_LRN_NULL_POINTER;
			goto RETURN_ERROR;
			
		}
	}

	if(pPktHdr->eth)
		eth_off = (uint8 *)pPktHdr->eth-RTSKB_DATA(rtskb);
	if(pPktHdr->svh)
		svh_off = (uint8 *)pPktHdr->svh-RTSKB_DATA(rtskb);
	if(pPktHdr->cvh)
		cvh_off = (uint8 *)pPktHdr->cvh-RTSKB_DATA(rtskb);
	if(pPktHdr->ppph)
		ppph_off = (uint8 *)pPktHdr->ppph-RTSKB_DATA(rtskb);
	if(pPktHdr->iph)
		iph_off = (uint8 *)pPktHdr->iph-RTSKB_DATA(rtskb);
	else if (pPktHdr->ip6h)
		ip6h_off = (uint8 *)pPktHdr->ip6h-RTSKB_DATA(rtskb);

MUTLI_ACTION_SEND:

	bzero(p_pktHdr_tmp,sizeof(*p_pktHdr_tmp));
	p_pktHdr_tmp->eth =NULL;
	p_pktHdr_tmp->svh =NULL;
	p_pktHdr_tmp->cvh =NULL;
	p_pktHdr_tmp->ppph =NULL;
	p_pktHdr_tmp->iph =NULL;
	p_pktHdr_tmp->ip6h =NULL;

	if(send2MultiAction)
	{
		skb_handle = path4_skb;
		pTxFlowEnt = pFlowTable_mutiAct;
		pPktHdr->flowIdx = path4Idx;
		out_portmask = pTxFlowEnt->pFlowEntry->path3.out_portmask;
		TRACE("Start Sent to Path4 out_portmask=%x", out_portmask);
	}
	else
	{
		skb_handle = RTSKB_SKB(rtskb);
		pTxFlowEnt = pFlowTable;
		pPktHdr->flowIdx = path3Idx;
		out_portmask = pTxFlowEnt->pFlowEntry->path3.out_portmask;
		TRACE("Start Sent to Path3 out_portmask=%x", out_portmask);
	}

	RTK_FC_HOOK_CONVERTER_SKB(skb_handle, rtskb_handle);


	if((out_portmask!=0) || (pTxFlowEnt->pFlowEntry->path3.out_ext_portmask_idx!=0))
	{

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		rtk_fc_mac_port_idx_t macPort;
		rtk_fc_mac_ext_port_idx_t macExtPort;
		rtk_fc_wlan_devmask_t wlanDevBitMask;
#endif
		int curbit;

		//init header
		//bzero(&txDesc, sizeof(txDesc));
		extPmsk=0;out_portmask_bitCnt=0;

		pPktHdr->skbLen_egress = RTSKB_LEN(rtskb_handle);

		if(pPktHdr->eth)
			p_pktHdr_tmp->eth = (struct ethhdr *)(RTSKB_DATA(rtskb_handle) + eth_off);
		if(pPktHdr->svh)
			p_pktHdr_tmp->svh = (struct vlan_hdr *)(RTSKB_DATA(rtskb_handle) + svh_off);
		if(pPktHdr->cvh)
			p_pktHdr_tmp->cvh = (struct vlan_hdr *)(RTSKB_DATA(rtskb_handle) + cvh_off);
		if(pPktHdr->ppph)
			p_pktHdr_tmp->ppph = (struct pppoe_hdr *)(RTSKB_DATA(rtskb_handle) + ppph_off);
		if(pPktHdr->iph)
			p_pktHdr_tmp->iph = (struct iphdr *)(RTSKB_DATA(rtskb_handle) + iph_off);
		else if (pPktHdr->ip6h)
			p_pktHdr_tmp->ip6h = (struct ipv6hdr *)(RTSKB_DATA(rtskb_handle) + ip6h_off);



		// L34 modification
		if(pTxFlowEnt->pFlowEntry->path3.in_path == FB_PATH_34)
		{
			// SMAC and TTL
			if(pTxFlowEnt->pFlowEntry->path3.out_smac_trans)
			{

				if(p_pktHdr_tmp->eth)
					memcpy(p_pktHdr_tmp->eth->h_source, &fc_db.netifHwTbl[pTxFlowEnt->pFlowEntry->path3.out_intf_idx].intf.gateway_mac_addr.octet[0], ETH_ALEN);
				if(p_pktHdr_tmp->iph)
				{
					p_pktHdr_tmp->iph->ttl--;
					if(p_pktHdr_tmp->iph->ttl<=0)
						goto TTL_DROP;
				}
				else if(p_pktHdr_tmp->ip6h)
				{
					p_pktHdr_tmp->ip6h->hop_limit--;
					if(p_pktHdr_tmp->ip6h->hop_limit <=0)
						goto TTL_DROP;
				}
			}
			//DMAC (PPPoE Multicast)
			if((pPktHdr->dmacToGatewayMAC) && (pPktHdr->ppph))
			{
				rtk_mac_t mcMac = {{0}};
				if(pPktHdr->iph)
				{
					mcMac.octet[0] = 0x01;
					mcMac.octet[1] = 0x00;
					mcMac.octet[2] = 0x5E;
					mcMac.octet[3] = (ntohl(pPktHdr->iph->daddr) >> 16) & 0x7F;
					mcMac.octet[4] = (ntohl(pPktHdr->iph->daddr) >> 8) & 0xFF;
					mcMac.octet[5] = (ntohl(pPktHdr->iph->daddr)) & 0xFF;
					if(p_pktHdr_tmp->eth)
						memcpy(p_pktHdr_tmp->eth->h_dest, &mcMac.octet[0], ETH_ALEN);
				}
				else if(pPktHdr->ip6h)
				{
					mcMac.octet[0] = 0x33;
					mcMac.octet[1] = 0x33;
					mcMac.octet[2] = (ntohl(pPktHdr->ip6h->daddr.s6_addr32[3]) >> 24) & 0xFF;
					mcMac.octet[3] = (ntohl(pPktHdr->ip6h->daddr.s6_addr32[3]) >> 16) & 0xFF;
					mcMac.octet[4] = (ntohl(pPktHdr->ip6h->daddr.s6_addr32[3]) >> 8) & 0xFF;
					mcMac.octet[5] = (ntohl(pPktHdr->ip6h->daddr.s6_addr32[3])) & 0xFF;
					if(p_pktHdr_tmp->eth)
						memcpy(p_pktHdr_tmp->eth->h_dest, &mcMac.octet[0], ETH_ALEN);
				}
			}


			//Tos and DSCP
			{
				// DSCP+ECN remark
				uint8 newTos = 0;
				if(p_pktHdr_tmp->iph)
				{
					oriTos = p_pktHdr_tmp->iph->tos;
					if(pTxFlowEnt->pFlowEntry->path3.out_dscp_act)
						newTos |= ((pTxFlowEnt->pFlowEntry->path3.out_dscp<<2)&0xfc);
					else
						newTos |= (oriTos & 0xfc);

					if(pTxFlowEnt->egr_tos_ecn_remark)
						newTos |= (pTxFlowEnt->egr_tos_ecn & 0x3);
					else
						newTos |= (oriTos & 0x3);

					p_pktHdr_tmp->iph->tos = newTos;
				}
				else if(p_pktHdr_tmp->ip6h)
				{
					oriTos = (((p_pktHdr_tmp->ip6h->priority<<4)&0xf0)|((p_pktHdr_tmp->ip6h->flow_lbl[0]>>4)&0xf));
					if(pTxFlowEnt->pFlowEntry->path3.out_dscp_act)
						newTos |= ((pTxFlowEnt->pFlowEntry->path3.out_dscp<<2)&0xfc);
					else
						newTos |= (oriTos & 0xfc);

					if(pTxFlowEnt->egr_tos_ecn_remark)
						newTos |= (pTxFlowEnt->egr_tos_ecn & 0x3);
					else
						newTos |= (oriTos & 0x3);

					p_pktHdr_tmp->ip6h->priority = ((newTos>>4)&0xf);
					p_pktHdr_tmp->ip6h->flow_lbl[0] &= 0xf;
					p_pktHdr_tmp->ip6h->flow_lbl[0] |= (newTos&0xf)<<4;
				}
			}

		}
		if(pTxFlowEnt->pFlowEntry->path3.out_ext_portmask_idx)
			extPmsk = fc_db.extPortTbl[pTxFlowEnt->pFlowEntry->path3.out_ext_portmask_idx].extPortEnt.extpmask;

		RTK_FC_HOOK_PS_SKB_IP_SUMMED_SET(RTSKB_SKB(rtskb), CHECKSUM_COMPLETE); // for 8277 series, HW need to do checksum offload

		// checksum
		if(extPmsk ||
			forceSwChksum ||
			(pTxFlowEnt->pFlowEntry->path3.out_extra_tag_index && fc_db.netifHwTbl[pTxFlowEnt->pFlowEntry->path3.out_intf_idx].dualType))
		{
			// to wifi or dual header: s/w needs to update (inner) l34 checksum
			if(p_pktHdr_tmp->iph)
				p_pktHdr_tmp->iph->check =  _rtk_fc_L3ChecksumDiff_update(ntohs(p_pktHdr_tmp->iph->check), 0, 0, oriTos,
																	0, 0, p_pktHdr_tmp->iph->tos , pTxFlowEnt->pFlowEntry->path3.out_smac_trans?-1:0);
		}else{
			/* no hardware offload */
		}


	//	do tag action
		if(extPmsk)
		{
			TRACE("do wifi stag/ctag/pppoe tag action");
			_rtk_fc_swPktHdrModify(rtskb_handle, p_pktHdr_tmp, pTxFlowEnt);
			pPktHdr->skbLen_egress = RTSKB_LEN(rtskb_handle);			// egress length is updated already by _rtk_fc_swPktHdrModify
		}


		while(extPmsk)
		{

			wlan_dev_idx=RTK_FC_WLANX_NOT_FOUND;
			
			curbit = __ffs(extPmsk);

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			// extp bit stands for wlan port, it may be shared by multiple wlan dev

			switch (curbit/(RTK_FC_MAC_EXT_PORT_MAX - RTK_FC_MAC_EXT_PORT0))
			{
				case 0:
					macPort = RTK_FC_MAC_PORT_MAINCPU;
					break;
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
				case 1:
					macPort = RTK_FC_MAC_PORT_MASTERCPU_CORE1;
					break;
				case 2:
					macPort = RTK_FC_MAC_PORT_SLAVECPU;
					break;
#endif
				default:
					WARNING("error bit %d", curbit);
					macPort = RTK_FC_MAC_PORT_MAINCPU;
					break;
			}
			macExtPort = (curbit % (RTK_FC_MAC_EXT_PORT_MAX - RTK_FC_MAC_EXT_PORT0)) + RTK_FC_MAC_EXT_PORT0;

			RTK_FC_HELPER_WLAN_PORT_TO_DEVID(macPort, macExtPort, &wlan_dev_idx, &wlanDevBitMask);

			if((wlan_dev_idx==RTK_FC_WLANX_MULTI_INTF) && wlanDevBitMask)
			{
				wlan_dev_idx_satrt = __ffs64(wlanDevBitMask);
				wlan_dev_idx_end = (63 - __builtin_clzll(wlanDevBitMask));
			}else if(wlan_dev_idx == RTK_FC_WLANX_NOT_FOUND) {
				WARNING("not wlan dev binding to port %d extport %d", macPort, macExtPort);
				continue;
			}else{
				wlan_dev_idx_satrt = wlan_dev_idx_end = wlan_dev_idx;
			}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
			// extp bit stands for wifiDevMask, each bit map to specific wlan dev

			wlan_dev_idx_satrt = wlan_dev_idx_end = wlan_dev_idx = curbit;
#endif

			extPmsk &= (~((uint64)1<<curbit));

			for(sendMbssid=wlan_dev_idx_satrt;sendMbssid<=wlan_dev_idx_end;sendMbssid++)
			{

				if((wlan_dev_idx>=RTK_FC_WLANX_END_INTF))
					break;

				pWifiDev=NULL;

				if(RTK_FC_HELPER_WLAN_DEVID_TO_DEV(sendMbssid, &pWifiDev)!=SUCCESS){
					TRACE("fail to find wlan dev..wlanDevIdx = %d", sendMbssid);
					continue;
				}

				{
					RTK_FC_HOOK_PS_SKB_SKB_COPY(RTSKB_SKB(rtskb_handle), GFP_ATOMIC, &wifi_skb);
					if(wifi_skb==NULL) continue;
					TRACE("Send to wifi sendMbssid:%d ",sendMbssid);
					
					RTK_FC_HOOK_CONVERTER_SKB(wifi_skb, wifi_rtskb);

					//RTK_FC_HELPER_WLAN_HARD_START_XMIT(sendMbssid, wifi_skb);
					ret = rtk_fc_wifi_send_with_wlandevidx(sendMbssid, wifi_rtskb, pPktHdr, pTxFlowEnt->pFlowEntry->path3.out_user_pri_act?pTxFlowEnt->pFlowEntry->path3.out_user_priority:0);
					if(isFirstPkt)
					{
						pPktHdr->skbLen_ingress = 0; // only first packet couts ingress count
						isFirstPkt = FALSE;
					}

					if(unlikely(ret&RTK_FC_RET_DROP))
					{
						if(unlikely(fc_db.fwdStatistic))
						{
							atomic_read(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
						}
						// free cloned skb now but free rtskb_handle at last step
						RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(wifi_skb);
						
					}

				}
			}

		}


		if(out_portmask)
		{
			out_portmask_bitCnt = out_portmask;
			RTK_FC_ONE_COUNT(out_portmask_bitCnt);

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			if(ifSkipNicL2Offload)
			{
				// do vlan/pppoe action by SW
				_rtk_fc_swPktHdrModify(rtskb_handle, p_pktHdr_tmp, pTxFlowEnt);
				pPktHdr->skbLen_egress = RTSKB_LEN(rtskb_handle) + 4;			// egress length is updated already by _rtk_fc_swPktHdrModify
			}
			else
			{
	 			// SVLAN
				if(pTxFlowEnt->pFlowEntry->path3.out_svid_format_act)								//Tag
				{
					TXINFO_SVLAN_ACT(ptxInfo)  = 0x3;										//remarking
					TXINFO_SVLAN_VIDL(ptxInfo) = (pTxFlowEnt->pFlowEntry->path3.out_svlan_id&0xff);
					TXINFO_SVLAN_VIDH(ptxInfo) = ((pTxFlowEnt->pFlowEntry->path3.out_svlan_id&0xf00)>>8);
					TXINFO_SVLAN_PRIO(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_spri;
					TXINFO_SVLAN_CFI(ptxInfo) = pTxFlowEnt->egr_svlan_dei;

					// decide egress packet length
					if(p_pktHdr_tmp->svh==NULL) pPktHdr->skbLen_egress += 4;
				}else									//Untag
				{
					TXINFO_SVLAN_ACT(ptxInfo)=0x2;										//remove stag

					// decide egress packet length
					if(p_pktHdr_tmp->svh) pPktHdr->skbLen_egress -= 4;
				}
			
				if(pFlowTable->egr_stpid_sel==1){
						//TXINFO_TPID_SEL(ptxInfo) = 1;
						// Should modify skb->data
						u8 *pData=RTSKB_DATA(rtskb);
						uint16 vlan_TCI = 0;
						uint16 new_tpid = fc_db.systemGlobal.stagTPID[1];

						if((*(u16*)(pData+ETH_HLEN-2)) == htons(fc_db.systemGlobal.stagTPID[0]))
						{

							(*(u16*)(pData+ETH_HLEN-2)) = new_tpid;
							vlan_TCI = pTxFlowEnt->pFlowEntry->path5.out_svlan_id;
							vlan_TCI |= (pTxFlowEnt->pFlowEntry->path5.out_spri<<13)&0xf000;
							DEBUG("[ShortCut]TPID selection = 1 (from skb->mark)!Need to modify tpid = 0x%x and vlan_TCI = 0x%x\n", new_tpid, vlan_TCI);
				
							(*(u16*)(pData+ETH_HLEN)) = htons(vlan_TCI);
						}else{
							//Original untag, so set TPID_SEL to 1 , let GMAC do the magic.
							TXINFO_TPID_SEL(ptxInfo) = 1;
						}
						
					}

				// CVLAN
				if(pTxFlowEnt->pFlowEntry->path3.out_cvid_format_act)								//Tag
				{
					TXINFO_CVLAN_ACT(ptxInfo)=0x3;										//remarking
					TXINFO_CVLAN_VIDL(ptxInfo)=(pTxFlowEnt->pFlowEntry->path3.out_cvlan_id&0xff);
					TXINFO_CVLAN_VIDH(ptxInfo)=((pTxFlowEnt->pFlowEntry->path3.out_cvlan_id&0xf00)>>8);
					TXINFO_CVLAN_PRIO(ptxInfo)=pTxFlowEnt->pFlowEntry->path3.out_cpri;
					TXINFO_CVLAN_CFI(ptxInfo) = pTxFlowEnt->egr_cvlan_cfi;

					// decide egress packet length
					if(p_pktHdr_tmp->cvh) pPktHdr->skbLen_egress += 4;
				}else																//Untag
				{
					TXINFO_CVLAN_ACT(ptxInfo)=0x2;										//remove ctag

					// decide egress packet length
					if(p_pktHdr_tmp->cvh) pPktHdr->skbLen_egress -= 4;
				}


				// PPPoE
				if(!pPktHdr->dmacToGatewayMAC)
				{
					//bridging: keep pppoe tag
					TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_KEEP;
					TXINFO_TX_PPPOE_IDX(ptxInfo)=0;
				}
				else
				{
					if((p_pktHdr_tmp->ppph==NULL) &&
						( (fc_db.netifHwTbl[pTxFlowEnt->pFlowEntry->path3.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_ADD) ||
						(fc_db.netifHwTbl[pTxFlowEnt->pFlowEntry->path3.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_MODIFY))  ) 			//untag => tag

					{
						TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_ADD;			//keep or add (always tag)
						TXINFO_TX_PPPOE_IDX(ptxInfo)=pTxFlowEnt->pFlowEntry->path3.out_intf_idx&0xf;

						// decide egress packet length
						pPktHdr->skbLen_egress += 8;
					}
					else if((p_pktHdr_tmp->ppph) && (fc_db.netifHwTbl[pTxFlowEnt->pFlowEntry->path3.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_REMOVE)) //tag => untag
					{
						TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_REMOVE;		//remove
						TXINFO_TX_PPPOE_IDX(ptxInfo)=0;

						// decide egress packet length
						pPktHdr->skbLen_egress -= 8;
					}
					else																//untag => untag, tag => tag
					{
						TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_KEEP;			//keep
						TXINFO_TX_PPPOE_IDX(ptxInfo)=0;
					}
				}
			}

			if(send2MultiAction==0)
			{
				if(pTxFlowEnt->pFlowEntry->path3.out_stream_idx_act)
					TXINFO_TX_DST_STREAM_ID(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_stream_idx;
			}

			if(pTxFlowEnt->pFlowEntry->path3.out_stream_idx_act){
				TXINFO_CPUTAG_PSEL(ptxInfo) = 1;
				TXINFO_TX_DST_STREAM_ID(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_stream_idx;
			}


			// other tx descriptor
			TXINFO_FS(ptxInfo)      	= 1;
			TXINFO_LS(ptxInfo)      	= 1;
			TXINFO_STAG_AWARE(ptxInfo)	= 1;
			if(forceSwChksum) {
				TXINFO_IPCS(ptxInfo)		= 0;
				TXINFO_L4CS(ptxInfo) 	= 0;
			} else {
				TXINFO_IPCS(ptxInfo)		= 1;
				if(!noL4Chksum)
					TXINFO_L4CS(ptxInfo) 	= 1;
			}
			TXINFO_DISLRN(ptxInfo) 		= 1;
			TXINFO_L34_KEEP(ptxInfo) 	= 1;

			TXINFO_TX_PORTMSK(ptxInfo) = out_portmask;

			TXINFO_ASPRI(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_user_pri_act;
			TXINFO_CPUTAG_PRI(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_user_priority;

			/*
			*	Short Cut DPI After modification Here
			*
			*   Hit Shortcut but not modify packet content yet
			*   here, support 2 types of return value from dpi external function:
			*   1. Continue  :  Continue the unfinished send with tx info 
			*   2. Drop      :  Drop the packet.
			*/
			if(fc_db.flow_callback_func.cbShortcut_after)
			{
				rt_cbFunc_flow_info_t cbFunc_info;

				memset(&cbFunc_info, 0, sizeof(rt_cbFunc_flow_info_t));
				cbFunc_info.cachedCt 		= pFlowTable->cachedCt;
				cbFunc_info.flowIdx 		= path3Idx;
				cbFunc_info.flow_extra_info = pFlowTable->flow_extra_info;
				
				shortCut_dpi_ret = fc_db.flow_callback_func.cbShortcut_after(rtskb->skb, cbFunc_info);
		
				switch(shortCut_dpi_ret){
		
					case RT_FLOW_CB_FUNC_RET_CONTINUE:
						DEBUG("[SHORTCUT DPI]Continue shortcut after DPI");
						break;
					case RT_FLOW_CB_FUNC_RET_DROP:
						{
						DEBUG("[SHORTCUT DPI]Drop packet after DPI");
						ret = RTK_FC_RET_DROP_CALLBACK_FUNC;
						goto RETURN_ERROR;
						break;
						}
					default:
						break;
				}
			}

			ret = rtk_fc_nic_send_with_txInfo(rtskb_handle, ptxInfo, 0, pPktHdr);
			if(isFirstPkt)
			{
				pPktHdr->skbLen_ingress = 0; // only first packet couts ingress count
				isFirstPkt = FALSE;
			}

			if(unlikely(ret&RTK_FC_RET_DROP))
			{
				if(unlikely(fc_db.fwdStatistic))
				{
					atomic_inc(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
				}
				// free cloned skb now but free rtskb_handle at last step
		
			}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

// other tx descriptor

			TXINFO_FS(ptxInfo) 			= 1;
			TXINFO_LS(ptxInfo) 			= 1;
			TXINFO_STAG_AWARE(ptxInfo)	= 1;
			TXINFO_IPCS(ptxInfo) 		= 1;
			TXINFO_L4CS(ptxInfo) 		= 1;
			TXINFO_DISLRN(ptxInfo) 		= 1;
			TXINFO_L34_KEEP(ptxInfo) 	= 1;
			TXINFO_ASPRI(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_user_pri_act;
			TXINFO_CPUTAG_PRI(ptxInfo) = pTxFlowEnt->pFlowEntry->path3.out_user_priority;

			_rtk_fc_swPktHdrModify(rtskb_handle, p_pktHdr_tmp, pTxFlowEnt);

			_rtk_fc_updateLsoPara0(rtskb, pPktHdr);

			pPktHdr->skbLen_egress = RTSKB_LEN(rtskb);			// egress length is updated already by _rtk_fc_swPktHdrModify
			{

				int dstPortIdx =  0;
				struct sk_buff *pTxPhySkb=NULL;
				struct rt_skbuff *rttxskb=NULL;
				rttxskb = RTK_FC_HELPER_FC_KMALLOC(sizeof(struct rt_skbuff), GFP_ATOMIC);

				for(dstPortIdx = 0; dstPortIdx <= RTK_FC_MAC_PORT_PON; dstPortIdx++ )
				{
					if(out_portmask&(1<<dstPortIdx)){
						RTK_FC_HOOK_PS_SKB_SKB_COPY(RTSKB_SKB(rtskb_handle), GFP_ATOMIC, &pTxPhySkb);
						RTK_FC_HOOK_CONVERTER_SKB(pTxPhySkb, rttxskb);
						TXINFO_TX_PORTMSK(ptxInfo) = (1<<dstPortIdx);

						TRACE("direct Tx to %s port[%d]", RTSKB_DEV(rttxskb)?RTSKB_DEV(rttxskb)->name:"NULL", dstPortIdx);
						
						/*
						*	Short Cut DPI After modification Here
						*
						*	Hit Shortcut but not modify packet content yet
						*	here, support 2 types of return value from dpi external function:
						*	1. Continue  :	Continue the unfinished send with tx info 
						*	2. Drop 	 :	Drop the packet.
						*/
						if(fc_db.flow_callback_func.cbShortcut_after)
						{
							rt_cbFunc_flow_info_t cbFunc_info;

							memset(&cbFunc_info, 0, sizeof(rt_cbFunc_flow_info_t));
							cbFunc_info.cachedCt 		= pFlowTable->cachedCt;
							cbFunc_info.flowIdx 		= path3Idx;
							cbFunc_info.flow_extra_info = pFlowTable->flow_extra_info;
		
							shortCut_dpi_ret = fc_db.flow_callback_func.cbShortcut_after(rtskb->skb, cbFunc_info);
								
							switch(shortCut_dpi_ret){
								
								case RT_FLOW_CB_FUNC_RET_CONTINUE:
									DEBUG("[SHORTCUT DPI]Continue shortcut after DPI");
									break;
								case RT_FLOW_CB_FUNC_RET_DROP:
									{
										DEBUG("[SHORTCUT DPI]Drop packet after DPI");
										if(rttxskb) RTK_FC_HELPER_FC_KFREE(rttxskb,sizeof(struct rt_skbuff));

										ret = RTK_FC_RET_DROP_CALLBACK_FUNC;
										goto RETURN_ERROR;
										break;
									}
								default:
									break;
							}
						}
						ret = rtk_fc_nic_send_with_txInfo(rttxskb, ptxInfo, 0, pPktHdr);
						if(isFirstPkt)
						{
							pPktHdr->skbLen_ingress = 0; // only first packet couts ingress count
							isFirstPkt = FALSE;
						}
						
						if(unlikely(ret&RTK_FC_RET_DROP))
						{
							if(unlikely(fc_db.fwdStatistic))
							{
								atomic_inc(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
							}
							// free cloned skb now but free rtskb_handle at last step
							RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(pTxPhySkb);
					
						}
					}
				}
				if(rttxskb) RTK_FC_HELPER_FC_KFREE(rttxskb,sizeof(struct rt_skbuff));
			}
			RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(RTSKB_SKB(rtskb_handle));
#endif
		}
		else
		{
			//no need to send phy
			RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(RTSKB_SKB(rtskb_handle));
		}
	}
	else
	{
		//no need to send any
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(RTSKB_SKB(rtskb_handle));
	}

	if(0)
	{
TTL_DROP:
		WARNING("TTL/HotLimit exceed Zero");
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(RTSKB_SKB(rtskb_handle));
	}

	if(send2MultiAction==0 && pFlowTable->pFlowEntry->path3.out_multiple_act )
	{
		send2MultiAction = 1;
		//TRACE("GOTO MUTLI_ACTION_SEND");
		goto MUTLI_ACTION_SEND;
	}

	
	if(ptxInfo) RTK_FC_HELPER_FC_KFREE(ptxInfo,sizeof(fc_tx_info_t));
	if(p_pktHdr_tmp) RTK_FC_HELPER_FC_KFREE(p_pktHdr_tmp,sizeof(rtk_fc_pktHdr_t));
	if(rtskb_handle) RTK_FC_HELPER_FC_KFREE(rtskb_handle,sizeof(struct rt_skbuff));
	if(wifi_rtskb) RTK_FC_HELPER_FC_KFREE(wifi_rtskb,sizeof(struct rt_skbuff));

	return RTK_FC_RET_OK;

RETURN_ERROR:
	if(ptxInfo) RTK_FC_HELPER_FC_KFREE(ptxInfo,sizeof(fc_tx_info_t));
	if(p_pktHdr_tmp) RTK_FC_HELPER_FC_KFREE(p_pktHdr_tmp,sizeof(rtk_fc_pktHdr_t));
	if(rtskb_handle) RTK_FC_HELPER_FC_KFREE(rtskb_handle,sizeof(struct rt_skbuff));
	if(wifi_rtskb) RTK_FC_HELPER_FC_KFREE(wifi_rtskb,sizeof(struct rt_skbuff));
	return ret;
}

__IRAM_FC_SHORTCUT
int _rtk_fc_flowModifyAndDirTx(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *pFlowTable, uint32 flow_Idx, bool ifSkipNicL2Offload)
{
	int ret = SUCCESS;
	//rtk_fc_txdesc_t txDesc;
	unsigned int l2Idx;
	uint32 oriSip=0, oriDip=0;
	uint16 oriSport=0, oriDport=0, oriTos=0;
	struct net_device *pWifiDev;
	int wlan_dev_idx;
	fc_tx_info_t *ptxInfo;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	fc_tx_info_t txInfo={{{0}},0,{{0}},{{0}},{{0}}};
#else
	fc_tx_info_t txInfo={0};
#endif
	int shortCut_dpi_ret = 0;
	uint16 origIPID=0, newIPID=0;
	uint8 mape_upstream=0, mape_ipid_updated=0;
	uint8 forceSwChksum = FALSE;
	uint8 v6Type = RTK_FC_IPV6_TYPE_NORMAL;
	uint8 noL4Chksum = FALSE;
	bool isFwdByLut = (pFlowTable->pFlowEntry->path1.in_path == FB_PATH_5)?TRUE:(pFlowTable->pFlowEntry->path1.out_uc_lut_lookup?TRUE:FALSE);
	uint32 egrPortMask = 0;
#ifdef CONFIG_RTK_SOC_RTL8198D
	uint8 ori_smac[ETH_ALEN] = {0};
	uint8 mode = RTK_FC_HELPER_GET_EXT_FLOW_MIB_CONTROL_MODE();
#endif
	struct in6_addr origIP6;

	ptxInfo = &txInfo;
	
	prefetch(&RTSKB_DATA(rtskb)[0]);
	prefetch(&RTSKB_DATA(rtskb)[32]);
	
	TRACE("modify packet content and do direct tx!");

	if(!pFlowTable || !pFlowTable->pFlowEntry || !pPktHdr ) return RTK_FC_RET_LRN_NULL_POINTER;
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(pFlowTable->candidateState==CANDIDATE_STATE_NONE) return RTK_FC_RET_LRN_NOT_SUPPORT;
#else
	if(!pFlowTable->pFlowEntry->path1.valid) return RTK_FC_RET_LRN_NOT_SUPPORT;
#endif

	pPktHdr->skbLen_egress = RTSKB_LEN(rtskb);

	pWifiDev=NULL;
	wlan_dev_idx=RTK_FC_WLANX_NOT_FOUND;
	//bzero(&txDesc, sizeof(txDesc));

	l2Idx = pFlowTable->lutEgrDaIdx;
	if(fc_db.lutTbl[l2Idx]==NULL)
	{
		WARNING("_rtk_fc_flowModifyAndDirTx: lut tbl[%d] is null!(from flow_Idx): %d\n", l2Idx, flow_Idx);
		return RTK_FC_RET_LRN_FAIL;
	}
	else
		wlan_dev_idx=fc_db.lutTbl[l2Idx]->wlan_dev_idx;
	
	if(wlan_dev_idx!=RTK_FC_WLANX_NOT_FOUND)
	{
		if((RTK_FC_HELPER_WLAN_DEVID_TO_DEV(wlan_dev_idx, &pWifiDev))!=SUCCESS){
			WARNING("[ToPS] fail to find lut[%d] wlan dev.. idx %d", l2Idx, wlan_dev_idx);
			return RTK_FC_RET_LRN_FAIL;
		}
	}
	
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if(RTSKB_LEN(rtskb) > RE8670_MAX_ETH_FRAME_SIZE) // nic limitation
	{
		forceSwChksum = TRUE;
	}
#endif	

	// single header and dual inner udp
	if(pPktHdr->iph && pPktHdr->udph && pPktHdr->udph->check==0){
		noL4Chksum = TRUE;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if (RTK_FC_NIC_TX_WO_HDR(rtskb))
			forceSwChksum = TRUE;
#endif
	}

	{
		// DSCP+ECN remark
		uint8 newTos = 0;
		if(pPktHdr->iph)
		{
			oriTos = pPktHdr->iph->tos;
			if(pFlowTable->pFlowEntry->path5.out_dscp_act)
				newTos |= ((pFlowTable->pFlowEntry->path5.out_dscp<<2)&0xfc);
			else
				newTos |= (oriTos & 0xfc);

			if(pFlowTable->egr_tos_ecn_remark)
				newTos |= (pFlowTable->egr_tos_ecn & 0x3);
			else
				newTos |= (oriTos & 0x3);

			pPktHdr->iph->tos = newTos;
		}
		else if(pPktHdr->ip6h)
		{
			oriTos = (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));
			if(pFlowTable->pFlowEntry->path5.out_dscp_act)
				newTos |= ((pFlowTable->pFlowEntry->path5.out_dscp<<2)&0xfc);
			else
				newTos |= (oriTos & 0xfc);

			if(pFlowTable->egr_tos_ecn_remark)
				newTos |= (pFlowTable->egr_tos_ecn & 0x3);
			else
				newTos |= (oriTos & 0x3);

			pPktHdr->ip6h->priority = ((newTos>>4)&0xf);
			pPktHdr->ip6h->flow_lbl[0] &= 0xf;
			pPktHdr->ip6h->flow_lbl[0] |= (newTos&0xf)<<4;
		}
	}

	if (pPktHdr->ipFragFlag) {
		forceSwChksum = TRUE;
	}

	// L34 modification
	if(pFlowTable->pFlowEntry->path5.in_path == FB_PATH_5)
	{
		// MAC
#ifdef CONFIG_RTK_SOC_RTL8198D
		memcpy(ori_smac, (RTSKB_DATA(rtskb) + ETH_ALEN), ETH_ALEN);
#endif
		memcpy(pPktHdr->eth->h_source, &fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.gateway_mac_addr.octet[0], ETH_ALEN);
		memcpy(pPktHdr->eth->h_dest, &fc_db.lutTbl[l2Idx]->l2Addr[0], ETH_ALEN);
		pPktHdr->dmacHostPolIdx = fc_db.lutTbl[l2Idx]->hostPolIdx; // update host poling index

		// NAPT(R)
		if(pFlowTable->pFlowEntry->path5.out_l4_act && (pPktHdr->iph!=NULL||pPktHdr->isMAPT))
		{
			uint32 sip = 0, dip = 0;			// translated info
			uint16 sport = 0, dport = 0;	// translated info
			if(pFlowTable->pFlowEntry->path5.out_l4_direction)
			{
				// outbound
				if(!pPktHdr->isMAPT){
					sip = fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.gateway_ipv4_addr;
					//For MAP-E, translate the source IPv4 address to tunnel IPv4 address
					if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_MAPE_ACC && fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].dualType == RTK_FC_DUALTYPE_DSLITE){
						sip = pFlowTable->mapeInfo.mape_tun_ipv4_addr;
						mape_upstream = 1;
					}

					dip = ntohl(pPktHdr->iph->daddr);
				}

				sport = pFlowTable->pFlowEntry->path5.out_l4_port;
			}else{
				// inbound
				sip = ntohl(pPktHdr->iph->saddr);
				if(pPktHdr->isMAPT)
					dip = ntohl(pPktHdr->iph->daddr);	//already be translated
				else
					dip = pFlowTable->pFlowEntry->path5.out_dst_ipv4_addr;

				dport = pFlowTable->pFlowEntry->path5.out_l4_port;
			}

			// L3 trans
			if(pPktHdr->iph)
			{
				oriSip = pPktHdr->iph->saddr;
				oriDip = pPktHdr->iph->daddr;

				pPktHdr->iph->saddr = htonl(sip);
				pPktHdr->iph->daddr = htonl(dip);

				if (mape_upstream){			
					if (RTK_FC_HOOK_MAPE_IPID_GET(rtk_fc_flow_ct_get(pFlowTable), &newIPID) == RTK_FC_RET_OK){
						origIPID = pPktHdr->iph->id;
						pPktHdr->iph->id = htons(newIPID);
						mape_ipid_updated = 1;
					}
				}
			}
			
			// L4 trans
			if (!pPktHdr->ipFragFlag || (pPktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG))
			{
				if(pPktHdr->tcph)
				{
					oriSport = pPktHdr->tcph->source;
					oriDport = pPktHdr->tcph->dest;

					if(pFlowTable->pFlowEntry->path5.out_l4_direction)
						pPktHdr->tcph->source = htons(sport);
					else
						pPktHdr->tcph->dest = htons(dport);
				}else if(pPktHdr->udph)
				{
					oriSport = pPktHdr->udph->source;
					oriDport = pPktHdr->udph->dest;

					if(pFlowTable->pFlowEntry->path5.out_l4_direction)
						pPktHdr->udph->source = htons(sport);
					else
						pPktHdr->udph->dest = htons(dport);
				}
			}
		}
#ifdef CONFIG_RTK_SOC_RTL8198D
		if(!pFlowTable->pFlowEntry->path5.out_l4_act && pPktHdr->iph!=NULL)
			oriSip = pPktHdr->iph->saddr;
#endif

		//
		// IPV6 NAT/NPT modify here
		//
		
		if(	(pPktHdr->iph == NULL) && 
			(pPktHdr->ip6h && pFlowTable->protoCtrl == FLOW_PROTO_CTRL_V6NAT && pFlowTable->ipv6_nat_indirect_mapping_index!=0) && 
			(atomic_read(&fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].refCount)!=0)
		  )
		{
			if(pFlowTable->pFlowEntry->path5.out_l4_direction == 1) // upstream
			{
				TRACE("IPV6 SNAT! Will modify v6 saddr from %pI6c to %pI6c\n", (&(pPktHdr->ip6h->saddr)), (&(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].addr)));
				memcpy(&origIP6, &pPktHdr->ip6h->saddr, sizeof(struct in6_addr));

				pPktHdr->ip6h->saddr = fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].addr;
				if(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].isNPTv6)
				{
					v6Type = RTK_FC_IPV6_TYPE_NPTv6;
				}
				else
				{
					v6Type = RTK_FC_IPV6_TYPE_NAT66;
				}
			}
			else if(pFlowTable->pFlowEntry->path5.out_l4_direction == 0) // downstream
			{
				TRACE("IPV6 DNAT! Will modify v6 daddr  from %pI6c to %pI6c\n", (&(pPktHdr->ip6h->daddr)), (&(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].addr)));
				memcpy(&origIP6, &pPktHdr->ip6h->daddr, sizeof(struct in6_addr));

				pPktHdr->ip6h->daddr = fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].addr;
				if(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].isNPTv6)
				{
					v6Type = RTK_FC_IPV6_TYPE_NPTv6;
				}
				else
				{
					v6Type = RTK_FC_IPV6_TYPE_NAT66;
				}
			}
			DEBUG("v6Type = %s", v6Type==RTK_FC_IPV6_TYPE_NPTv6?"NPTv6":"NAT66");
		}

		if(pPktHdr->iph)
			pPktHdr->iph->ttl--;
		else if(pPktHdr->ip6h)
			pPktHdr->ip6h->hop_limit--;

		RTK_FC_HOOK_PS_SKB_IP_SUMMED_SET(RTSKB_SKB(rtskb), CHECKSUM_COMPLETE); // for 8277 series, HW need to do checksum offload

		// checksum
		if(pWifiDev
				|| forceSwChksum
				|| (pFlowTable->pFlowEntry->path5.out_extra_tag_index && fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].dualType)
				|| (pFlowTable->protoCtrl == FLOW_PROTO_CTRL_L2DUAL && pFlowTable->l2Dual_table_info.l2Dual_table_index!=0 && fc_db.l2DualTbl[pFlowTable->l2Dual_table_info.l2Dual_table_index].type!=RTK_FC_L2DUAL_TYPE_NONE)
			)
		{

			do
			{
				if(v6Type == RTK_FC_IPV6_TYPE_NPTv6)
				{
					DEBUG("[NPTv6]ShortCut! Don't need to recalculate l34 checksum");
					break;
				}
				// to wifi or dual header: s/w needs to update (inner) l34 checksum
				if(pPktHdr->iph)
				{
					if(pFlowTable->pFlowEntry->path5.out_l4_act) //NAPT(R)
					{
						pPktHdr->iph->check =  _rtk_fc_L3ChecksumDiff_update(ntohs(pPktHdr->iph->check), ntohl(oriSip), ntohl(oriDip), oriTos,
																			ntohl(pPktHdr->iph->saddr), ntohl(pPktHdr->iph->daddr), pPktHdr->iph->tos, -1);
						if (mape_ipid_updated > 0){
							pPktHdr->iph->check =  _rtk_fc_L3ChecksumDiff_update(ntohs(pPktHdr->iph->check), 0, 0, ntohs(origIPID),
																			0, 0, newIPID, 0);
						}
						if((pPktHdr->ipFragFlag == RTK_FC_IP_NO_FRAG) ||
							(pPktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG)) {
							if(pPktHdr->tcph)
								pPktHdr->tcph->check = _rtk_fc_L4ChecksumDiff_update(ntohs(pPktHdr->tcph->check), ntohl(oriSip), ntohl(oriDip), ntohs(oriSport), ntohs(oriDport),
																					ntohl(pPktHdr->iph->saddr), ntohl(pPktHdr->iph->daddr), ntohs(pPktHdr->tcph->source), ntohs(pPktHdr->tcph->dest));
							if(pPktHdr->udph && pPktHdr->udph->check!=0)
								pPktHdr->udph->check = _rtk_fc_L4ChecksumDiff_update(ntohs(pPktHdr->udph->check), ntohl(oriSip), ntohl(oriDip), ntohs(oriSport), ntohs(oriDport),
																					ntohl(pPktHdr->iph->saddr), ntohl(pPktHdr->iph->daddr), ntohs(pPktHdr->udph->source), ntohs(pPktHdr->udph->dest));
						}
					}
					else //Routing=> no need to update L4 header checksum
						pPktHdr->iph->check =  _rtk_fc_L3ChecksumDiff_update(ntohs(pPktHdr->iph->check), 0, 0, oriTos,
																			0, 0, pPktHdr->iph->tos, -1);
				}
				else
				{
					if(v6Type == RTK_FC_IPV6_TYPE_NAT66)
					{
						DEBUG("[NAT66]ShortCut! Need to recalculate l34 checksum");
						#if 1
						if (pPktHdr->tcph || (pPktHdr->udph && pPktHdr->udph->check!=0))
						{
							__be16	*l4Check;
							if (pPktHdr->tcph)
								l4Check = &(pPktHdr->tcph->check);
							else
								l4Check = &(pPktHdr->udph->check);
							if (pFlowTable->pFlowEntry->path5.out_l4_direction == 1)//upstream
								*(l4Check) = _rtk_fc_ipv6_L4ChecksumDiff_update(pPktHdr->ip6h->saddr.s6_addr16, origIP6.s6_addr16, *l4Check);
							else//downstream
								*(l4Check) = _rtk_fc_ipv6_L4ChecksumDiff_update(pPktHdr->ip6h->daddr.s6_addr16, origIP6.s6_addr16, *l4Check);
						}
						#else
						_rtk_fc_pktHdr_v6L34Checksum_update(pPktHdr);
						#endif
					}
				}
			}
			while (0);
			
			
		}else{
			/* no hardware offload */
		}
	}

	// prepare sw shaping
	if(fc_db.flowTbl[flow_Idx].swShaperEn & (1<<SWSHAPER_TYPE_FLOW)) {
		// translate flow shaper setting to remarkDec
		pPktHdr->remarkDec.swShaper_en= TRUE;
		pPktHdr->remarkDec.meterIdx = pFlowTable->pFlowEntry->path1.out_share_meter_idx;
	}
	pPktHdr->flowIdx = flow_Idx;

#ifdef CONFIG_RTK_SOC_RTL8198D
	//count eth&wlan sw pkt
	if (RTK_FC_HELPER_GET_EXT_FLOW_MIB_CONTROL()) {
		if (pFlowTable->pFlowEntry->path5.in_path == FB_PATH_5 && (pPktHdr->iph || pPktHdr->ip6h) && (pPktHdr->udph || pPktHdr->tcph)) {
			bool is_uplink = (pFlowTable->pFlowEntry->path5.out_l4_direction) ? TRUE : FALSE;
			uint8 is_wlan_sta = 0;
			struct net_device *dev = NULL;
			rtk_fc_ext_flow_mib_host_mapping_t host;
			rtk_fc_ext_flow_mib_param_t param;
			uint8 *mac_addr;

			if (is_uplink) {
				if (pPktHdr->igrWlanDevIdx <  RTK_FC_WLANX_NOT_FOUND) {
					RTK_FC_HELPER_WLAN_DEVID_TO_DEV(pPktHdr->igrWlanDevIdx, &dev);
					is_wlan_sta = dev ? RTK_FC_HELPER_IS_WLAN_5G(dev->name) : 0;
				}
			}
			else {
				is_wlan_sta = (pWifiDev)? RTK_FC_HELPER_IS_WLAN_5G(pWifiDev->name): 0;
			}

			memset(&param, 0, sizeof(rtk_fc_ext_flow_mib_param_t));
			param.packet_count	= 1;
			param.byte_count	= pPktHdr->skbLen_egress + 4;	// CRC
			param.is_uplink 	= is_uplink;
			param.update_type	= RTK_FC_COUNTER_UPDATE_SW;

			if (mode == RTK_EXT_FLOW_MIB_IPV4_BASED && pPktHdr->iph) {
				memset(&host, 0, sizeof(rtk_fc_ext_flow_mib_host_mapping_t));
				host.is_wlan_sta		= is_wlan_sta;
				host.ip_addr			= is_uplink? oriSip : pPktHdr->iph->daddr;

				RTK_FC_HELPER_UPDATE_EXT_FLOW_MIB_BY_LAN_IP(&host, &param);
			}
			else if (mode == RTK_EXT_FLOW_MIB_MAC_BASED){
				mac_addr = is_uplink ? ori_smac : pPktHdr->eth->h_dest;

				RTK_FC_HELPER_UPDATE_EXT_FLOW_MIB_BY_LAN_MAC(mac_addr, is_wlan_sta, &param);
			}
		}
	}
#endif	

	// =========== start NIC/WIFI Tx =========== //

	if(pFlowTable->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT && pFlowTable->dual_pt_flowMapTbl_idx!=0 && fc_db.dual_pt_flowMapTbl[pFlowTable->dual_pt_flowMapTbl_idx].dual_type==RTK_FC_DUALTYPE_PPTP)
	{
		if(pPktHdr->tunnelInfo.pptp.pCallId!=NULL)
		{
			TRACE("[PPTP]Modify Call Id From %d to %d !", pPktHdr->tunnelInfo.pptp.grecallid, fc_db.dual_pt_flowMapTbl[pFlowTable->dual_pt_flowMapTbl_idx].pptp_flowMapping.out_gre_call_id);
			(*(u16*)(pPktHdr->tunnelInfo.pptp.pCallId)) = htons(fc_db.dual_pt_flowMapTbl[pFlowTable->dual_pt_flowMapTbl_idx].pptp_flowMapping.out_gre_call_id);
		}
	
	}

	if(pWifiDev)
	{
		_rtk_fc_swPktHdrModify(rtskb, pPktHdr, pFlowTable);
		pPktHdr->skbLen_egress = RTSKB_LEN(rtskb);			// egress length is updated already by _rtk_fc_swPktHdrModify

		//RTK_FC_HELPER_WLAN_HARD_START_XMIT(wlan_dev_idx, RTSKB_SKB(rtskb));
		ret = rtk_fc_wifi_send_with_wlandevidx(wlan_dev_idx, rtskb, pPktHdr, pFlowTable->pFlowEntry->path5.out_user_pri_act?pFlowTable->pFlowEntry->path5.out_user_priority:0);

		goto MIB_COUNTING;
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if(ifSkipNicL2Offload)
	{
		// do vlan/pppoe action by SW
		_rtk_fc_swPktHdrModify(rtskb, pPktHdr, pFlowTable);
	}
	else
	{

		// SVLAN
		if(pFlowTable->pFlowEntry->path5.out_svid_format_act)								//Tag
		{
			if(pFlowTable->protoCtrl !=FLOW_PROTO_CTRL_V6NAT /*&& pFlowTable->ipv6_nat_indirect_mapping_index == 0*/)
			{
				TXINFO_SVLAN_ACT(ptxInfo)=0x3;										//remarking
				TXINFO_SVLAN_VIDL(ptxInfo)=(pFlowTable->pFlowEntry->path5.out_svlan_id&0xff);
				TXINFO_SVLAN_VIDH(ptxInfo)=((pFlowTable->pFlowEntry->path5.out_svlan_id&0xf00)>>8);
				TXINFO_SVLAN_PRIO(ptxInfo)=pFlowTable->pFlowEntry->path5.out_spri;
				TXINFO_SVLAN_CFI(ptxInfo)=pFlowTable->egr_svlan_dei;
				// decide egress packet length
				if(pPktHdr->svh==NULL) pPktHdr->skbLen_egress += 4;
			}
			else if(pFlowTable->protoCtrl ==FLOW_PROTO_CTRL_V6NAT && pFlowTable->ipv6_nat_indirect_mapping_index!=0 && fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriSVID!=0)
			{
				TXINFO_SVLAN_ACT(ptxInfo)=0x3;										//remarking
				TXINFO_SVLAN_VIDL(ptxInfo)=(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriSVID&0xff);
				TXINFO_SVLAN_VIDH(ptxInfo)=((fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriSVID&0xf00)>>8);
				TXINFO_SVLAN_PRIO(ptxInfo)=fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriSPRI;
				//txDesc.tx_cvlan_cfi
				// decide egress packet length
				if(pPktHdr->svh==NULL) pPktHdr->skbLen_egress += 4;
			}
			else if(pFlowTable->protoCtrl ==FLOW_PROTO_CTRL_V6NAT && pFlowTable->ipv6_nat_indirect_mapping_index!=0 && fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriSVID==0)
			{
				TXINFO_SVLAN_ACT(ptxInfo)=0x2;										//remove ctag

				// decide egress packet length
				if(pPktHdr->svh) pPktHdr->skbLen_egress -= 4;
			}
		}else									//Untag
		{
			TXINFO_SVLAN_ACT(ptxInfo)=0x2;										//remove stag

			// decide egress packet length
			if(pPktHdr->svh) pPktHdr->skbLen_egress -= 4;
		}

		if(pFlowTable->egr_stpid_sel==1){
			//TXINFO_TPID_SEL(ptxInfo) = 1;
			// Should modify skb->data
			u8 *pData=RTSKB_DATA(rtskb);
			uint16 vlan_TCI = 0;
			uint16 new_tpid = fc_db.systemGlobal.stagTPID[1];
		
			if((*(u16*)(pData+ETH_HLEN-2)) == htons(fc_db.systemGlobal.stagTPID[0]))
			{
				(*(u16*)(pData+ETH_HLEN-2)) = new_tpid;
				vlan_TCI = pFlowTable->pFlowEntry->path5.out_svlan_id;
				vlan_TCI |= ((pFlowTable->pFlowEntry->path5.out_spri<<VLAN_PRIO_SHIFT)&VLAN_PRIO_MASK) | ((pFlowTable->egr_svlan_dei<<VLAN_CFI_SHIFT)&VLAN_CFI_MASK);
				DEBUG("[ShortCut]TPID selection = 1 (from skb->mark)!Need to modify tpid = 0x%x and vlan_TCI = 0x%x\n", new_tpid, vlan_TCI);

				(*(u16*)(pData+ETH_HLEN)) = htons(vlan_TCI);
			}else{
				//Original untag, so set TPID_SEL to 1 , let GMAC do the magic.
				TXINFO_TPID_SEL(ptxInfo) = 1;
			}
			
		}
		
		// CVLAN
		if(pFlowTable->pFlowEntry->path5.out_cvid_format_act)								//Tag
		{
			if(pFlowTable->protoCtrl !=FLOW_PROTO_CTRL_V6NAT /*&& pFlowTable->ipv6_nat_indirect_mapping_index == 0*/)
			{
				TXINFO_CVLAN_ACT(ptxInfo)=0x3;										//remarking
				TXINFO_CVLAN_VIDL(ptxInfo)=(pFlowTable->pFlowEntry->path5.out_cvlan_id&0xff);
				TXINFO_CVLAN_VIDH(ptxInfo)=((pFlowTable->pFlowEntry->path5.out_cvlan_id&0xf00)>>8);
				TXINFO_CVLAN_PRIO(ptxInfo)=pFlowTable->pFlowEntry->path5.out_cpri;
				TXINFO_CVLAN_CFI(ptxInfo)=pFlowTable->egr_cvlan_cfi;
				//txDesc.tx_cvlan_cfi
				// decide egress packet length
				if(pPktHdr->cvh==NULL) pPktHdr->skbLen_egress += 4;
			}
			else if(pFlowTable->protoCtrl ==FLOW_PROTO_CTRL_V6NAT && pFlowTable->ipv6_nat_indirect_mapping_index!=0 && fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriCVID!=0)
			{
				TXINFO_CVLAN_ACT(ptxInfo)=0x3;										//remarking
				TXINFO_CVLAN_VIDL(ptxInfo)=(fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriCVID&0xff);
				TXINFO_CVLAN_VIDH(ptxInfo)=((fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriCVID&0xf00)>>8);
				TXINFO_CVLAN_PRIO(ptxInfo)=fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriCPRI;
				//txDesc.tx_cvlan_cfi
				// decide egress packet length
				if(pPktHdr->cvh==NULL) pPktHdr->skbLen_egress += 4;
			}
			else if(pFlowTable->protoCtrl ==FLOW_PROTO_CTRL_V6NAT && pFlowTable->ipv6_nat_indirect_mapping_index!=0 && fc_db.ipv6_nat_mappingTbl[pFlowTable->ipv6_nat_indirect_mapping_index].oriCVID==0)
			{
				TXINFO_CVLAN_ACT(ptxInfo)=0x2;										//remove ctag

				// decide egress packet length
				if(pPktHdr->cvh) pPktHdr->skbLen_egress -= 4;
			}
		}else																//Untag
		{
			TXINFO_CVLAN_ACT(ptxInfo)=0x2;										//remove ctag

			// decide egress packet length
			if(pPktHdr->cvh) pPktHdr->skbLen_egress -= 4;
		}


		// PPPoE
		if(!pPktHdr->dmacToGatewayMAC)
		{
			//bridging: keep pppoe tag
			TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_KEEP;
			TXINFO_TX_PPPOE_IDX(ptxInfo)=0;
		}
		else
		{
			if((pPktHdr->ppph==NULL) &&
				( (fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_ADD) ||
				(fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_MODIFY))  ) 			//untag => tag
			{
				TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_ADD; 			//keep or add (always tag)
				TXINFO_TX_PPPOE_IDX(ptxInfo)=pFlowTable->pFlowEntry->path5.out_intf_idx&0xf;

				// decide egress packet length
				pPktHdr->skbLen_egress += 8;
			}
			else if((pPktHdr->ppph) && (fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_REMOVE))	//tag => untag
			{
				TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_REMOVE; 		//remove
				TXINFO_TX_PPPOE_IDX(ptxInfo)=0;

				// decide egress packet length
				pPktHdr->skbLen_egress -= 8;
			}
			else 																//untag => untag, tag => tag
			{
				TXINFO_TX_PPPOE_ACT(ptxInfo)=RTK_FC_CPUTAG_PPPOEACT_KEEP; 			//keep
				TXINFO_TX_PPPOE_IDX(ptxInfo)=0;
			}
		}
	}

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
	if(pFlowTable->dmaAftFibCtrlEn)
	{
		DEBUG("TX dmaAftFibCtrlEn is TRUE, VLAN and PPPoE headers will be modified by HW. (dmaAftFibIdx = %u)", pFlowTable->dmaAftFibIdx);
		pPktHdr->txlso_para0.bf.dma_aft_l2fib_enable = TRUE;
		pPktHdr->txlso_para0.bf.dma_aft_l2fib_index = pFlowTable->dmaAftFibIdx;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if(!(RTK_FC_NIC_TX_WO_HDR(rtskb)))
		{
			uint32 rsvEntryIdx;
			_rtk_fc_dmaAftAction_add(&rsvEntryIdx, fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].fib, TRUE);
			pPktHdr->txlso_para0.bf.dma_aft_l2fib_index = rsvEntryIdx;
			DEBUG("[dmaAftFibCtrlEn] copy dmaAftFibIdx from %u to %u for tx api with header", pFlowTable->dmaAftFibIdx, pPktHdr->txlso_para0.bf.dma_aft_l2fib_index);
			fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].syncRsvEntry = TRUE;
			fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].syncRsvEntryIdx = pPktHdr->txlso_para0.bf.dma_aft_l2fib_index;
		}
#endif
#if 0
		// reset skb L234 header
		// [IMPORTANT] for CA-G3: CA api L4 checksum offload needs correct header pointer!
		_rtk_fc_skbHdrPointerReset(rtskb, pPktHdr);
#endif
		if(fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].fib.vlan_vld)
		{
			//vlan action
			int ingress_vlanTag_count;
			if(pPktHdr->svh && pPktHdr->cvh)
				ingress_vlanTag_count = 2;
			else if(pPktHdr->svh || pPktHdr->cvh)
				ingress_vlanTag_count = 1;
			else
				ingress_vlanTag_count = 0;
			pPktHdr->skbLen_egress += ((((int32_t)fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].fib.vlan_cnt) - ingress_vlanTag_count)*4);
		}

		if(fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].fib.pppoe_cmd == 1)
		{
			//pppoe push
			pPktHdr->skbLen_egress += 8;
		}
		else if(fc_db.dmaAftActionTbl[pFlowTable->dmaAftFibIdx].fib.pppoe_cmd == 2)
		{
			//pppoe pop
			pPktHdr->skbLen_egress -= 8;
		}
	}
	else
#endif
	{
		if((pFlowTable->protoCtrl != FLOW_PROTO_CTRL_L2DUAL) || (pFlowTable->protoCtrl == FLOW_PROTO_CTRL_L2DUAL && pFlowTable->l2Dual_table_info.l2Dual_table_index==0))
		{
			_rtk_fc_swPktHdrModify(rtskb, pPktHdr, pFlowTable);

			pPktHdr->skbLen_egress = RTSKB_LEN(rtskb);			// egress length is updated already by _rtk_fc_swPktHdrModify
		}
	}

	_rtk_fc_updateLsoPara0(rtskb, pPktHdr);
#endif


	// other tx descriptor
	if(pFlowTable->pFlowEntry->path5.out_stream_idx_act){
		TXINFO_CPUTAG_PSEL(ptxInfo) = 1;
		TXINFO_TX_DST_STREAM_ID(ptxInfo) = pFlowTable->pFlowEntry->path5.out_stream_idx;
		DEBUG("tx streamid = %d", TXINFO_TX_DST_STREAM_ID(ptxInfo));
	}

	TXINFO_FS(ptxInfo) = 1;
	TXINFO_LS(ptxInfo) = 1;
	TXINFO_STAG_AWARE(ptxInfo)=1;

	if(forceSwChksum) {
		TXINFO_IPCS(ptxInfo) = 0;		
		TXINFO_L4CS(ptxInfo) = 0;
	} else
	{
		TXINFO_IPCS(ptxInfo) = 1;
		if(!noL4Chksum)
			TXINFO_L4CS(ptxInfo) = 1;
	}
	TXINFO_DISLRN(ptxInfo) = 1;
	TXINFO_L34_KEEP(ptxInfo) = 1;


	if(  (0 <= pFlowTable->lutIgrSaIdx && pFlowTable->lutIgrSaIdx < RTK_FC_TABLESIZE_LUT) &&
		(0 <= l2Idx && l2Idx < RTK_FC_TABLESIZE_LUT)) {
#if defined(CONFIG_FC_RTL9607C_SERIES)
		// if traffic is from wlan, select GMAC according to DMAC SPA
		uint32 gmacid=0;
		if((fc_db.lutTbl[pFlowTable->lutIgrSaIdx]!=NULL) && (fc_db.lutTbl[pFlowTable->lutIgrSaIdx]->wlan_dev_idx < RTK_FC_WLANX_END_INTF)) {
			RTK_FC_HELPER_WLAN_RX_LOOKUP_GMAC_DECISION(fc_db.lutTbl[l2Idx]->spa, &gmacid);
			DEBUG("dmac spa is %d, sel gmac %d", fc_db.lutTbl[l2Idx]->spa, gmacid);
		}else if(fc_db.controlFuc.wifi_tx_trap_hash) {
			// non-wifi traffic && enable hw trap hash
			gmacid = flow_Idx % 2;
			DEBUG("hw trap hash is enabled, sel gmac %d according flow index %d", gmacid, flow_Idx);
		}

		TXINFO_GMAC_ID(ptxInfo)		    = gmacid;
#endif

		egrPortMask = isFwdByLut?(1<<fc_db.lutTbl[l2Idx]->spa): pFlowTable->pFlowEntry->path1.out_portmask;
	}else
		egrPortMask = pFlowTable->pFlowEntry->path1.out_portmask;

#if defined(CONFIG_FC_RTL8198F_SERIES)
	if (fc_db.controlFuc.pe_fc_enable && ((__ffs(egrPortMask)) >= RTK_FC_MAC_PORT_WLAN_CPU0))
		TXINFO_PE_PORTMSK(ptxInfo) = egrPortMask;
	else
#endif
	TXINFO_TX_PORTMSK(ptxInfo) = egrPortMask;
	TXINFO_ASPRI(ptxInfo) = pFlowTable->pFlowEntry->path5.out_user_pri_act;
	TXINFO_CPUTAG_PRI(ptxInfo) = pFlowTable->pFlowEntry->path5.out_user_priority;

	/*
	*	Short Cut DPI After modification Here
	*
	*   Hit Shortcut but not modify packet content yet
	*   here, support 2 types of return value from dpi external function:
	*   1. Continue  :  Continue the unfinished send with tx info 
	*   2. Drop      :  Drop the packet.
	*/
	if(fc_db.flow_callback_func.cbShortcut_after)
	{
		rt_cbFunc_flow_info_t cbFunc_info;

		memset(&cbFunc_info, 0, sizeof(rt_cbFunc_flow_info_t));
		cbFunc_info.cachedCt 		= pFlowTable->cachedCt;
		cbFunc_info.flowIdx 		= flow_Idx;
		cbFunc_info.flow_extra_info = pFlowTable->flow_extra_info;
		
		shortCut_dpi_ret = fc_db.flow_callback_func.cbShortcut_after(rtskb->skb, cbFunc_info);
		
		switch(shortCut_dpi_ret){
		
			case RT_FLOW_CB_FUNC_RET_CONTINUE:
				DEBUG("[SHORTCUT DPI]Continue shortcut after DPI");
				break;
			case RT_FLOW_CB_FUNC_RET_DROP:
				DEBUG("[SHORTCUT DPI]Drop packet after DPI");
				return RTK_FC_RET_DROP_CALLBACK_FUNC;
				break;
			default:
				break;
		}
	}
	
	ret = rtk_fc_nic_send_with_txInfo(rtskb, ptxInfo, 0, pPktHdr);

MIB_COUNTING:
	if(unlikely(ret&RTK_FC_RET_DROP))
	{
		TRACE("[Drop] Drop by nic tx");

		if(unlikely(fc_db.fwdStatistic))
		{
			atomic_inc(&fc_db.statistic.perPortCnt_Drop[pPktHdr->ingressPort.macPortIdx][ret & ~(RTK_FC_RET_DROP)]);
		}
		RTK_FC_HOOK_PS_SKB_DEV_KFREE_SKB_ANY(RTSKB_SKB(rtskb));
		return RTK_FC_RET_OK;
	}else{
		
		if(unlikely(fc_db.fwdStatistic))
		{
			switch(pFlowTable->pFlowEntry->path1.in_path)
			{
				case FB_PATH_12:
				case FB_PATH_34:
					atomic_inc(&fc_db.statistic.perPortCnt_L2FWD[pPktHdr->ingressPort.macPortIdx]);
					break;
				case FB_PATH_5:
					if(pFlowTable->pFlowEntry->path5.in_ipv4_or_ipv6==0)
					{
						if(pFlowTable->pFlowEntry->path5.out_l4_act)
							atomic_inc(&fc_db.statistic.perPortCnt_L4FWD[pPktHdr->ingressPort.macPortIdx]);
						else
							atomic_inc(&fc_db.statistic.perPortCnt_IPv4_L3FWD[pPktHdr->ingressPort.macPortIdx]);
					}
					else
					{
						atomic_inc(&fc_db.statistic.perPortCnt_IPv6_L3FWD[pPktHdr->ingressPort.macPortIdx]);
					}
					break;
				case FB_PATH_6:
				default:
					TRACE("Path in_path(%d) is not supported by shortcut", pFlowTable->pFlowEntry->path5.in_path);
					break;
			}
		}

	}
	
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t _rtk_fc_extPMaskEntry_find(uint32 extPMask, uint32 *entryIdx)
{
	uint8 idx = 0, freeIdx = 0, hit = FALSE;

	if(extPMask == 0x0)
	{
		hit = TRUE;
		idx = 0;
	}
	else
	{
		// reserve entry[0] for no-extension port used, so search the same one or empty one from entry[1].
		for(idx = EXTPTBL_RSVED_ENTRY ; idx < RTK_FC_TABLESIZE_EXTPORT ; idx++)
		{
			// find the first empty entry
			if((fc_db.extPortTbl[idx].extPortRefCount==0) && (freeIdx==0))
			{
				freeIdx = idx;
			}
			// find the same setting
			if(fc_db.extPortTbl[idx].extPortEnt.extpmask == extPMask)
			{
				hit = TRUE;
				break;
			}
		}

		if(idx == RTK_FC_TABLESIZE_EXTPORT && (hit==FALSE) && (freeIdx==0))
			return RTK_FC_RET_ERR_ENTRY_FULL;

		// if hit, use the found index(idx). if not, use the empty entry(freeIdx).
		if(!hit)
			idx = freeIdx;
	}

	*entryIdx = idx;
	//DEBUG("find extension port mask entry[%d], freeidx = %d", idx, freeIdx);

	return RTK_FC_RET_OK;
}

rtk_fc_ret_t _rtk_fc_ethTypeEntry_acl_ref(uint16 ethtype, uint32 *hwIdx)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	int i, freeIdx = SIGNED_INVALID;
	
	// find exist
	for(i = 0; i < RTK_FC_TABLESIZE_ETHERTYPE; i++) {
		if((freeIdx == SIGNED_INVALID) && !fc_db.ethertypeTbl[i].valid)
			freeIdx = i;
		if(fc_db.ethertypeTbl[i].valid && (fc_db.ethertypeTbl[i].ethType == ethtype)) {

			fc_db.ethertypeTbl[i].acl_ref++;
			*hwIdx = fc_db.ethertypeTbl[i].hwIdx;
			return RTK_FC_RET_OK;
		}
	}

	// not found, add one
	if((ret = RTK_RG_ASIC_ETHTYPE_ADD(freeIdx, ethtype))==RTK_FC_RET_OK) {
		fc_db.ethertypeTbl[freeIdx].acl_ref++;
		*hwIdx = fc_db.ethertypeTbl[freeIdx].hwIdx;
		return RTK_FC_RET_OK;
	}else{
		// fail
	}

	return ret;
}

rtk_fc_ret_t _rtk_fc_ethTypeEntry_acl_deref(uint32 hwIdx)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	int i;

	// find exist
	for(i = 0; i < RTK_FC_TABLESIZE_ETHERTYPE; i++) {
		if(fc_db.ethertypeTbl[i].valid && (fc_db.ethertypeTbl[i].hwIdx == hwIdx)) {

			if(fc_db.ethertypeTbl[i].acl_ref)
				fc_db.ethertypeTbl[i].acl_ref--;
			else
				WARNING("ethtype 0x%x swidx [%d] hwidx[%d], the acl reference count is zero", fc_db.ethertypeTbl[i].ethType, i, hwIdx);
			
			if(fc_db.ethertypeTbl[i].acl_ref == 0 && fc_db.ethertypeTbl[i].flow_ref ==FALSE)
				RTK_RG_ASIC_ETHTYPE_DEL(i);
			return RTK_FC_RET_OK;
		}
	}

	// not found
	WARNING("hwidx %d not found", hwIdx);
	ret = RTK_FC_RET_ERR_ENTRY_NOT_FOUND;

	return ret;
}

#if !defined(CONFIG_FC_RTL8277C_SERIES)
uint32 _rtk_fc_sw_flowHashPath12ExtraItem_get(void *pFlowData)
{
	u32 extraItem = 0;
	rtk_rg_asic_path1_entry_t *pP1Data = pFlowData;
	uint8 igrCPRI = 0, igrDSCP = 0;

	if(pP1Data==NULL)
	{
		WARNING("flow data is NULL");
		return 0;
	}

	igrCPRI = pP1Data->in_cvlan_pri;
	igrDSCP = pP1Data->in_tos >> 2;

#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		extraItem = 0x0;
	}else
#endif
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_DSCP]==DISABLED){
			extraItem = ((igrDSCP&0x3f)<<3) ^ extraItem;
			//DEBUG("flow hash with DSCP %d", igrDSCP);
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED){
			extraItem = (igrCPRI&0x7) ^ extraItem;
			//DEBUG("flow hash with CPRI %d", igrCPRI);
		}
	}

	return extraItem;
}


uint32 _rtk_fc_sw_flowHashPath34ExtraItem_get(void *pFlowData, uint16 igrSVID, uint16 igrCVID, uint16 lutDaIdx_gmacChk)
{
	u32 extraItem = 0;
	rtk_rg_asic_path3_entry_t *pP3Data = pFlowData;
	u8 isMulticast = FALSE;
	uint8 igrCPRI = 0, igrDSCP = 0;

	if(pP3Data==NULL)
	{
		WARNING("flow data is NULL");
		return 0;
	}

	igrCPRI = pP3Data->in_cvlan_pri;
	igrDSCP = pP3Data->in_tos >> 2;

	if(pP3Data->in_ipv4_or_ipv6 == 1){
		/* IPv6 */
		isMulticast = (pP3Data->in_dst_ipv6_addr_hash& FLOW_V6HASHADDR_MC_BIT)?TRUE:FALSE;
	}else{
		/* IPv4 */
		if((pP3Data->in_dst_ipv4_addr >= FLOW_V4ADDR_MC_LO_BOUND) && (pP3Data->in_dst_ipv4_addr < FLOW_V4ADDR_MC_UP_BOUND))
			isMulticast = TRUE;
	}

	if(isMulticast){
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_SVID]==DISABLED){
			extraItem |= (igrSVID<<12);
			//DEBUG("flow hash with SVID %d", igrSVID);
		}else
			extraItem &= 0x000fff;

		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED){
			extraItem |= igrCVID;
			//DEBUG("flow hash with CVID %d", igrCVID);
		}else
			extraItem &= 0xfff000;
	}else{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_SVID]==DISABLED){
			extraItem |= (igrSVID<<12);
			//DEBUG("flow hash with SVID %d", igrSVID);
		}else
			extraItem &= 0x000fff;

		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED){
			extraItem |= igrCVID;
			//DEBUG("flow hash with CVID %d", igrCVID);
		}else
			extraItem &= 0xfff000;
	}

	/* Extraitem: Consider L4 protocol only for path 3/4/5 */
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_SKIP_DA]==DISABLED)
			extraItem = (pP3Data->in_l4proto<<23 | (lutDaIdx_gmacChk&0xfff)) ^ extraItem;
		else
			extraItem = (pP3Data->in_l4proto<<23) ^ extraItem;
	}else
#endif
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_SKIP_DA]==DISABLED)
			extraItem = (pP3Data->in_l4proto<<23 | ((lutDaIdx_gmacChk&0x1)<<9)) ^ extraItem;
		else
			extraItem = (pP3Data->in_l4proto<<23) ^ extraItem;

		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_DSCP]==DISABLED){
			extraItem = ((igrDSCP&0x3f)<<3) ^ extraItem;
			//DEBUG("flow hash with DSCP %d", igrDSCP);
		}

		if(isMulticast){
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED){
				extraItem = (igrCPRI&0x7) ^ extraItem;
				//DEBUG("flow hash with CPRI %d", igrCPRI);
			}
		}else{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED){
				extraItem = (igrCPRI&0x7) ^ extraItem;
				//DEBUG("flow hash with CPRI %d", igrCPRI);
			}
		}
	}

	return extraItem;
}


uint32 _rtk_fc_sw_flowHashPath5ExtraItem_get(void *pFlowData, uint16 igrSVID, uint16 igrCVID)
{
	u32 extraItem = 0;
	rtk_rg_asic_path5_entry_t *pP5Data = pFlowData;
	uint8 igrCPRI = 0, igrDSCP = 0;

	if(pP5Data==NULL)
	{
		WARNING("flow data is NULL");
		return 0;
	}

	igrCPRI = pP5Data->in_cvlan_pri;
	igrDSCP = pP5Data->in_tos >> 2;

	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_SVID]==DISABLED){
		extraItem |= (igrSVID<<12);
		//DEBUG("flow hash with SVID %d", igrSVID);
	}else
		extraItem &= 0x000fff;

	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID]==DISABLED){
		extraItem |= igrCVID;
		//DEBUG("flow hash with CVID %d", igrCVID);
	}else
		extraItem &= 0xfff000;

	/* Extraitem: Consider L4 protocol only for path 3/4/5 */
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		extraItem = (pP5Data->in_l4proto<<23) ^ extraItem;
	}else
#endif
	{
		extraItem = (pP5Data->in_l4proto<<23) ^ extraItem;

		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_DSCP]==DISABLED){
			extraItem = ((igrDSCP&0x3f)<<3) ^ extraItem;
			//DEBUG("flow hash with DSCP %d", igrDSCP);
		}

		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI]==DISABLED){
			extraItem = (igrCPRI&0x7) ^ extraItem;
			//DEBUG("flow hash with CPRI %d", igrCPRI);
		}
	}

	return extraItem;
}

uint32 _rtk_fc_sw_flowHashPath6ExtraItem_get(void *pFlowData, uint16 igrSVID, uint16 igrCVID)
{
	u32 extraItem = 0;
	rtk_rg_asic_path6_entry_t *pP6Data = pFlowData;
	uint8 igrCPRI = 0, igrDSCP = 0;

	if(pP6Data==NULL)
	{
		WARNING("flow data is NULL");
		return 0;
	}

	igrCPRI = pP6Data->in_cvlan_pri;
	igrDSCP = pP6Data->in_tos >> 2;

	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_SVID]==DISABLED){
		extraItem |= (igrSVID<<12);
		//DEBUG("flow hash with SVID %d", igrSVID);
	}else
		extraItem &= 0x000fff;

	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED){
		extraItem |= igrCVID;
		//DEBUG("flow hash with CVID %d", igrCVID);
	}else
		extraItem &= 0xfff000;

#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		// NA
	}else
#endif
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_DSCP]==DISABLED){
			extraItem = ((igrDSCP&0x3f)<<3) ^ extraItem;
			//DEBUG("flow hash with DSCP %d", igrDSCP);
		}

		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED){
			extraItem = (igrCPRI&0x7) ^ extraItem;
			//DEBUG("flow hash with CPRI %d", igrCPRI);
		}
	}

	return extraItem;
}

uint32 _rtk_fc_sw_flowHashIndexStep1_get_with_prehashPattern(uint16 param1, uint16 param2, uint32 param3, uint32 param4, uint32 extraItem, uint32 sip_ptn, uint32 dip_ptn, uint32 sport_ptn, uint32 dport_ptn)
{
	uint32 sum1=0, sum2=0, sum=0, sum_nk=0, hashIdx=0;
	uint32 sport=0, dport=0, sip=0, dip=0;
	rtk_rg_asic_fbMode_t fbMode;

	//ASSERT_EQ(rtk_rg_asic_fbModeCtrl_get(FB_MODE_FB_MOD, &fbMode), SUCCESS);
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	
	fbMode = rgpro_db.fbMode;

	sport = _rtk_rg_flowHashPreProcessPort(param1, sport_ptn);
	dport = _rtk_rg_flowHashPreProcessPort(param2, dport_ptn);
	sip = _rtk_rg_flowHashPreProcessIP(param3, sip_ptn);
	dip = _rtk_rg_flowHashPreProcessIP(param4, dip_ptn);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	sport = _rtk_rg_flowHashPreProcessPort(param1, sport_ptn);
	dport = _rtk_rg_flowHashPreProcessPort(param2, dport_ptn);
	sip = _rtk_rg_flowHashPreProcessIP(param3, sip_ptn);
	dip = _rtk_rg_flowHashPreProcessIP(param4, dip_ptn);

	fbMode = FB_MODE_32K;

#else
	fbMode = FB_MODE_32K;
	//WARNING("new platform use 32K hash by default");

#endif

	sum1 = ((sip&0xfffff)  + (sip>>20) + (dip&0xfffff) + (dip>>20) + sport + dport) & 0x7fffff;		// sum1[22:0]
	sum2 = ((sum1&0xfffff) + (sum1>>20)) & 0x1fffff;						// sum2[20:0]
	sum	  = ((sum2&0xfffff) + (sum2>>20)) & 0x1fffff;						// sum[20:0]

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(CHIP_ID_9607C) {	
		switch(fbMode)
		{
			case FB_MODE_4K:
				// 4k mode: 4-way (10 bits index)
				sum_nk = ((sum&0x3ff) + ((sum>>10)&0x3ff) + ((sum>>20)&0x1))&0x3ff;		// sum_4k[9:0]
				hashIdx = sum_nk ^ (extraItem&0x3ff) ^ ((extraItem>>10)&0x3ff) ^ ((extraItem>>20)&0xf);
				hashIdx = hashIdx<<2;												// Get base entry index
				break;
			case FB_MODE_8K:
				// 8k mode: 1-way (13 bits index)
				sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
				sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x1);
				sum_nk = (sum1&0x1000) | (sum2&0xfff);							// sum_8k[12:0]
				hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
				break;
			case FB_MODE_16K:
				// 16k mode: 1-way (14 bits index)
				sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
				sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x3);
				sum_nk = (sum1&0x3000) | (sum2&0xfff);							// sum_8k[13:0]
				hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
				break;
			case FB_MODE_32K:
				// 32k mode: 1-way (15 bits index)
				sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
				sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x7);
				sum_nk = (sum1&0x7000) | (sum2&0xfff);							// sum_8k[14:0]
				hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
				break;
		}
	}else {
		switch (fbMode) 
		{
			case FB_MODE_1K:
				// 1k mode: 4-way (8 bits index)
				sum_nk = ((sum&0xff) + ((sum>>8)&0xff) + ((sum>>16)&0x1f))&0xff;		// sum_4k[7:0]
				hashIdx = sum_nk ^ (extraItem&0xff) ^ ((extraItem>>8)&0xff) ^ ((extraItem>>16)&0xff);
				hashIdx = hashIdx<<2;												// Get base entry index
				break;
			case FB_MODE_8K:
				// 8k mode: 1-way (13 bits index)
				sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
				sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x7);
				sum_nk = (sum1&0x1c00) | (sum2&0x3ff);							// sum_8k[12:0]
				hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
				break;
			case FB_MODE_16K:
				// 16k mode: 1-way (14 bits index)
				sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
				sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0xf);
				sum_nk = (sum1&0x3c00) | (sum2&0x3ff);							// sum_16k[13:0]
				hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
				break;
			case FB_MODE_32K:
				// 32k mode: 1-way (15 bits index)
				sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
				sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x1f);
				sum_nk = (sum1&0x7c00) | (sum2&0x3ff);							// sum_32k[14:0]
				hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
				break;
		}
	}

#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
	switch (fbMode) 
	{
		case FB_MODE_1K:
			// 1k mode: 4-way (8 bits index)
			sum_nk = ((sum&0xff) + ((sum>>8)&0xff) + ((sum>>16)&0x1f))&0xff;		// sum_4k[7:0]
			hashIdx = sum_nk ^ (extraItem&0xff) ^ ((extraItem>>8)&0xff) ^ ((extraItem>>16)&0xff);
			hashIdx = hashIdx<<2;												// Get base entry index
			break;
		case FB_MODE_8K:
			// 8k mode: 1-way (13 bits index)
			sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
			sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x7);
			sum_nk = (sum1&0x1c00) | (sum2&0x3ff);							// sum_8k[12:0]
			hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
			break;
		case FB_MODE_16K:
			// 16k mode: 1-way (14 bits index)
			sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
			sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0xf);
			sum_nk = (sum1&0x3c00) | (sum2&0x3ff);							// sum_16k[13:0]
			hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
			break;
		case FB_MODE_32K:
			// 32k mode: 1-way (15 bits index)
			sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
			sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x1f);
			sum_nk = (sum1&0x7c00) | (sum2&0x3ff);							// sum_32k[14:0]
			hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
			break;
	}
#else

	switch(fbMode)
	{
		case FB_MODE_4K:
			// 4k mode: 4-way (10 bits index)
			sum_nk = ((sum&0x3ff) + ((sum>>10)&0x3ff) + ((sum>>20)&0x1))&0x3ff;		// sum_4k[9:0]
			hashIdx = sum_nk ^ (extraItem&0x3ff) ^ ((extraItem>>10)&0x3ff) ^ ((extraItem>>20)&0xf);
			hashIdx = hashIdx<<2;												// Get base entry index
			break;
		case FB_MODE_8K:
			// 8k mode: 1-way (13 bits index)
			sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
			sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x1);
			sum_nk = (sum1&0x1000) | (sum2&0xfff);							// sum_8k[12:0]
			hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
			break;
		case FB_MODE_16K:
			// 16k mode: 1-way (14 bits index)
			sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
			sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x3);
			sum_nk = (sum1&0x3000) | (sum2&0xfff);							// sum_8k[13:0]
			hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
			break;
		case FB_MODE_32K:
			// 32k mode: 1-way (15 bits index)
			sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
			sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x7);
			sum_nk = (sum1&0x7000) | (sum2&0xfff);							// sum_8k[14:0]
			hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
			break;
	}
#endif
	//DEBUG("[FLOWHASH] index=%d, fbMode=%d, params: [0x%x,0x%x,0x%x,0x%x], extra:0x%x", hashIdx, fbMode, param1, param2, param3, param4, extraItem);
	//DEBUG("[FLOWHASH] index=%d, fbMode=%d, after preprocess: [0x%x,0x%x,0x%x,0x%x], sum1:0x%x", hashIdx, fbMode, sport, dport, sip, dip, sum);
	return hashIdx;
}

uint32 _rtk_fc_sw_flowHashIndexStep1_get(uint16 param1, uint16 param2, uint32 param3, uint32 param4, uint32 extraItem)
{
	uint32 sum1=0, sum2=0, sum=0, sum_nk=0, hashIdx=0;
	uint32 sport=0, dport=0, sip=0, dip=0;
	rtk_rg_asic_fbMode_t fbMode;

	//ASSERT_EQ(rtk_rg_asic_fbModeCtrl_get(FB_MODE_FB_MOD, &fbMode), SUCCESS);
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	uint32 preHashPtn;
	fbMode = rgpro_db.fbMode;

	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_SPORT];
	sport = _rtk_rg_flowHashPreProcessPort(param1, preHashPtn);
	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_DPORT];
	dport = _rtk_rg_flowHashPreProcessPort(param2, preHashPtn);
	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_SIP];
	sip = _rtk_rg_flowHashPreProcessIP(param3, preHashPtn);
	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_DIP];
	dip = _rtk_rg_flowHashPreProcessIP(param4, preHashPtn);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	uint32 preHashPtn;

	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_SPORT];
	sport = _rtk_rg_flowHashPreProcessPort(param1, preHashPtn);
	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_DPORT];
	dport = _rtk_rg_flowHashPreProcessPort(param2, preHashPtn);
	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_SIP];
	sip = _rtk_rg_flowHashPreProcessIP(param3, preHashPtn);
	preHashPtn = fc_db.systemGlobal.preHashPtn[FB_PREHASH_PTN_DIP];
	dip = _rtk_rg_flowHashPreProcessIP(param4, preHashPtn);

	fbMode = FB_MODE_32K;

#else
	fbMode = FB_MODE_32K;
	WARNING("new platform use 32K hash by default");

#endif

	sum1 = ((sip&0xfffff)  + (sip>>20) + (dip&0xfffff) + (dip>>20) + sport + dport) & 0x7fffff;		// sum1[22:0]
	sum2 = ((sum1&0xfffff) + (sum1>>20)) & 0x1fffff;						// sum2[20:0]
	sum	  = ((sum2&0xfffff) + (sum2>>20)) & 0x1fffff;						// sum[20:0]

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(CHIP_ID_9607C) {	
		switch(fbMode)
		{
			case FB_MODE_4K:
				// 4k mode: 4-way (10 bits index)
				sum_nk = ((sum&0x3ff) + ((sum>>10)&0x3ff) + ((sum>>20)&0x1))&0x3ff;		// sum_4k[9:0]
				hashIdx = sum_nk ^ (extraItem&0x3ff) ^ ((extraItem>>10)&0x3ff) ^ ((extraItem>>20)&0xf);
				hashIdx = hashIdx<<2;												// Get base entry index
				break;
			case FB_MODE_8K:
				// 8k mode: 1-way (13 bits index)
				sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
				sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x1);
				sum_nk = (sum1&0x1000) | (sum2&0xfff);							// sum_8k[12:0]
				hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
				break;
			case FB_MODE_16K:
				// 16k mode: 1-way (14 bits index)
				sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
				sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x3);
				sum_nk = (sum1&0x3000) | (sum2&0xfff);							// sum_8k[13:0]
				hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
				break;
			case FB_MODE_32K:
				// 32k mode: 1-way (15 bits index)
				sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
				sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x7);
				sum_nk = (sum1&0x7000) | (sum2&0xfff);							// sum_8k[14:0]
				hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
				break;
		}
	}else {
		switch (fbMode) 
		{
			case FB_MODE_1K:
				// 1k mode: 4-way (8 bits index)
				sum_nk = ((sum&0xff) + ((sum>>8)&0xff) + ((sum>>16)&0x1f))&0xff;		// sum_4k[7:0]
				hashIdx = sum_nk ^ (extraItem&0xff) ^ ((extraItem>>8)&0xff) ^ ((extraItem>>16)&0xff);
				hashIdx = hashIdx<<2;												// Get base entry index
				break;
			case FB_MODE_8K:
				// 8k mode: 1-way (13 bits index)
				sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
				sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x7);
				sum_nk = (sum1&0x1c00) | (sum2&0x3ff);							// sum_8k[12:0]
				hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
				break;
			case FB_MODE_16K:
				// 16k mode: 1-way (14 bits index)
				sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
				sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0xf);
				sum_nk = (sum1&0x3c00) | (sum2&0x3ff);							// sum_16k[13:0]
				hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
				break;
			case FB_MODE_32K:
				// 32k mode: 1-way (15 bits index)
				sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
				sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x1f);
				sum_nk = (sum1&0x7c00) | (sum2&0x3ff);							// sum_32k[14:0]
				hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
				break;
		}
	}

#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
	switch (fbMode) 
	{
		case FB_MODE_1K:
			// 1k mode: 4-way (8 bits index)
			sum_nk = ((sum&0xff) + ((sum>>8)&0xff) + ((sum>>16)&0x1f))&0xff;		// sum_4k[7:0]
			hashIdx = sum_nk ^ (extraItem&0xff) ^ ((extraItem>>8)&0xff) ^ ((extraItem>>16)&0xff);
			hashIdx = hashIdx<<2;												// Get base entry index
			break;
		case FB_MODE_8K:
			// 8k mode: 1-way (13 bits index)
			sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
			sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x7);
			sum_nk = (sum1&0x1c00) | (sum2&0x3ff);							// sum_8k[12:0]
			hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
			break;
		case FB_MODE_16K:
			// 16k mode: 1-way (14 bits index)
			sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
			sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0xf);
			sum_nk = (sum1&0x3c00) | (sum2&0x3ff);							// sum_16k[13:0]
			hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
			break;
		case FB_MODE_32K:
			// 32k mode: 1-way (15 bits index)
			sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
			sum2 = (sum1&0x3ff) ^ ((sum1>>10)&0x1f);
			sum_nk = (sum1&0x7c00) | (sum2&0x3ff);							// sum_32k[14:0]
			hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
			break;
	}
#else

	switch(fbMode)
	{
		case FB_MODE_4K:
			// 4k mode: 4-way (10 bits index)
			sum_nk = ((sum&0x3ff) + ((sum>>10)&0x3ff) + ((sum>>20)&0x1))&0x3ff;		// sum_4k[9:0]
			hashIdx = sum_nk ^ (extraItem&0x3ff) ^ ((extraItem>>10)&0x3ff) ^ ((extraItem>>20)&0xf);
			hashIdx = hashIdx<<2;												// Get base entry index
			break;
		case FB_MODE_8K:
			// 8k mode: 1-way (13 bits index)
			sum1 = (sum&0x1fff) + ((sum>>13)&0xff);
			sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x1);
			sum_nk = (sum1&0x1000) | (sum2&0xfff);							// sum_8k[12:0]
			hashIdx = sum_nk ^ (extraItem&0x1fff) ^ ((extraItem>>13)&0x7ff);
			break;
		case FB_MODE_16K:
			// 16k mode: 1-way (14 bits index)
			sum1 = (sum&0x3fff) + ((sum>>14)&0x7f);
			sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x3);
			sum_nk = (sum1&0x3000) | (sum2&0xfff);							// sum_8k[13:0]
			hashIdx = sum_nk ^ (extraItem&0x3fff) ^ ((extraItem>>14)&0x3ff);
			break;
		case FB_MODE_32K:
			// 32k mode: 1-way (15 bits index)
			sum1 = (sum&0x7fff) + ((sum>>15)&0x3f);
			sum2 = (sum1&0xfff) ^ ((sum1>>12)&0x7);
			sum_nk = (sum1&0x7000) | (sum2&0xfff);							// sum_8k[14:0]
			hashIdx = sum_nk ^ (extraItem&0x7fff) ^ ((extraItem>>15)&0x1ff);
			break;
	}
#endif
	DEBUG("[FLOWHASH] index=%d, fbMode=%d, params: [0x%x,0x%x,0x%x,0x%x], extra:0x%x", hashIdx, fbMode, param1, param2, param3, param4, extraItem);
	//DEBUG("[FLOWHASH] index=%d, fbMode=%d, after preprocess: [0x%x,0x%x,0x%x,0x%x], sum1:0x%x", hashIdx, fbMode, sport, dport, sip, dip, sum);
	return hashIdx;
}

uint32 _rtk_fc_sw_flowHashIndexStep2_get(uint32 step1Idx)
{
	rtk_rg_asic_fbMode_t fbMode;
	uint32 hashidx = 0;
	
#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	uint32 mask = 0;
	if(CHIP_ID_9607C) {	
		mask = 0x7E03;	// Hid_s2[14:0] = {~hid[14:10], ~hid[9], hid[8:2], ~hid[1:0]}	0x7E03= 111_1110_0000_0011
	}else {	
		mask = 0x7F83;	// Hid_s2[14:0] = {~hid[14:8], ~hid[7], hid[6:2], ~hid[1:0]}	0x7E83= 111_1111_1000_0011
	}
#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
	uint32 mask = 0x7F83;	// Hid_s2[14:0] = {~hid[14:8], ~hid[7], hid[6:2], ~hid[1:0]}	0x7E83= 111_1111_1000_0011
#else
	uint32 mask = 0x7E03;	// Hid_s2[14:0] = {~hid[14:10], ~hid[9], hid[8:2], ~hid[1:0]}	0x7E03= 111_1110_0000_0011
#endif

	//ASSERT_EQ(rtk_rg_asic_fbModeCtrl_get(FB_MODE_FB_MOD, &fbMode), SUCCESS);
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	fbMode = rgpro_db.fbMode;
#else
	fbMode = FB_MODE_32K;
#endif

	switch(fbMode)
	{
#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		case FB_MODE_4K:
			if(CHIP_ID_9607C) {	
				// 4k mode: 4-way (10 bits index)
				hashidx = step1Idx >> 2;			// shift back to 10 bits
				mask = mask & 0x3ff;				// Hid_s2[9:0] = { ~hid[9], hid[8:2], ~hid[1:0]} => 10 bits mask
				hashidx = hashidx ^ mask;
				hashidx = hashidx << 2; 		// shift to 12 bits 4 way entry index
			}else {
				// 1k mode: 4-way (8 bits index)
				hashidx = step1Idx >> 2;			// shift back to 8 bits
				mask = mask & 0xff; 			// Hid_s2[7:0] = { ~hid[7], hid[6:2], ~hid[1:0]} => 8 bits mask
				hashidx = hashidx ^ mask;
				hashidx = hashidx << 2; 		// shift to 12 bits 4 way entry index
			}
			break;
#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
		case FB_MODE_1K:
			// 4k mode: 4-way (8 bits index)
			hashidx = step1Idx >> 2;			// shift back to 8 bits
			mask = mask & 0xff; 			// Hid_s2[7:0] = { ~hid[7], hid[6:2], ~hid[1:0]} => 8 bits mask
			hashidx = hashidx ^ mask;
			hashidx = hashidx << 2; 		// shift to 12 bits 4 way entry index
			break;
#else
		case FB_MODE_4K:
			// 4k mode: 4-way (10 bits index)
			hashidx = step1Idx >> 2;			// shift back to 10 bits
			mask = mask & 0x3ff;				// Hid_s2[9:0] = { ~hid[9], hid[8:2], ~hid[1:0]} => 10 bits mask
			hashidx = hashidx ^ mask;
			hashidx = hashidx << 2; 		// shift to 12 bits 4 way entry index
			break;
#endif
		case FB_MODE_8K:
			// 8k mode: 1-way (13 bits index)
			mask = mask & 0x1fff;
			hashidx = step1Idx ^ mask;
			break;
		case FB_MODE_16K:
			// 16k mode: 1-way (14 bits index)
			mask = mask & 0x3fff;
			hashidx = step1Idx ^ mask;
			break;
		case FB_MODE_32K:
			// 32k mode: 1-way (15 bits index)
			mask = mask & 0x7fff;
			hashidx = step1Idx ^ mask;
			break;
	}

	DEBUG("[FLOWHASH] step1Idx=%d index=%d (Step2), fbMode=%d", step1Idx,hashidx, fbMode);
	return hashidx;
}
#endif
rtk_fc_ret_t _rtk_fc_flow_getOuterHeaderFlowByPktHdr(rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlowEntry_t *pFlow)
{
	rtk_rg_asic_path6_entry_t *p6 = &pFlow->path6;

	if(pPktHdr->smacL2Idx == FAIL) {
		DEBUG("unknown sa");
		goto RET_FAIL;
	}
	if(pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		goto RET_FAIL;
	}

	bzero(pFlow, sizeof(rtk_fc_tableFlowEntry_t));

	p6->valid = TRUE;
	p6->in_path = FB_PATH_6;
	//p6->in_intf_idx = ;
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SMAC_IDX]==ENABLED)
	{
		p6->in_smac_lut_idx = pPktHdr->smacL2Idx;
	}
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DMAC_IDX]==ENABLED)
	{
		p6->in_dmac_lut_idx = pPktHdr->dmacL2Idx;
	}
	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_SVID]==DISABLED)
	{
		p6->in_stagif = pPktHdr->svh ? TRUE : FALSE;
	}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED)
		{
			p6->in_ctagif = pPktHdr->cvh ? TRUE : FALSE;
		}
	}else
#endif
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED
			|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED)
		{
			p6->in_ctagif = pPktHdr->cvh ? TRUE : FALSE;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED)
		{
			p6->in_cvlan_pri = pPktHdr->cvlanpri;
		}
	}
   	p6->in_pppoeif = pPktHdr->ppph ? TRUE : FALSE;
	p6->in_pppoe_sid_check = TRUE;
	p6->in_pppoe_sid = pPktHdr->ppph ? ntohs(pPktHdr->ppph->sid) : 0;


	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SIP]==ENABLED)
	{
		p6->in_src_ipv4_addr = (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE) ? pPktHdr->ipv6Sip_hash : ntohl(pPktHdr->outer_iph->saddr);
	}
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DIP]==ENABLED)
	{
		p6->in_dst_ipv4_addr = (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE) ? pPktHdr->ipv6Dip_hash : ntohl(pPktHdr->outer_iph->daddr);
	}
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SPORT]==ENABLED)
	{
		p6->in_l4_src_port = (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP) ?  pPktHdr->outer_udph->source : 0;
	}
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DPORT]==ENABLED)
	{
		p6->in_l4_dst_port = (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP) ?  pPktHdr->outer_udph->dest : 0;
	}
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_PROTOCOL]==ENABLED)
	{
		p6->in_protocol = FB_INPROTOCOL_ALL_ACCEPT;
	}

	if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE)
		p6->in_dsliteif = TRUE;

	if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP){
		p6->in_pptpif = TRUE;

		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_GRE_CALL_ID]==ENABLED)
		{
			p6->in_gre_call_id = pPktHdr->tunnelInfo.pptp.grecallid;
		}
	}

	if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP){
		p6->in_l2tpif = TRUE;

		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_TUNNEL_ID]==ENABLED)
		{
			p6->in_l2tp_tunnel_id = pPktHdr->tunnelInfo.l2tp.tunnelid;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_SID]==ENABLED)
		{
			p6->in_l2tp_session_id = pPktHdr->tunnelInfo.l2tp.sessionid;
		}
	}



	return (RTK_FC_RET_OK);

RET_FAIL:
	return (RTK_FC_RET_ERR);
}


int _rtk_fc_flow_hitOuterHdrFlowByPktHdr(rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlowEntry_t *pFlow)
{
	int16 l2Idx = 0;
	rtk_rg_asic_path6_entry_t *p6 = NULL;
	rtk_fc_hwTableNetif_t *pNetif = NULL;
	rtk_fc_tableFlow_t *pFlowTable = NULL;

	FC_PARAM_CHK(pFlow==NULL, FALSE);
	FC_PARAM_CHK(pFlow->path6.in_path != FB_PATH_6, FALSE);

	p6 = &pFlow->path6;

	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SMAC_IDX]==ENABLED)
	{
		if(_rtk_fc_lut_find(pPktHdr->eth->h_source, &l2Idx) == RTK_FC_RET_OK)
		{
			if(p6->in_smac_lut_idx!=l2Idx)
				goto RET_FAIL;
		}else
			goto RET_FAIL;

	}
	if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DMAC_IDX]==ENABLED)
	{
		if(_rtk_fc_lut_find(pPktHdr->eth->h_dest, &l2Idx) == RTK_FC_RET_OK)
		{
			if(p6->in_dmac_lut_idx!=l2Idx)
				goto RET_FAIL;
		}else
			goto RET_FAIL;
	}
	if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_SVID]==DISABLED)
	{
		if(p6->in_stagif!=(pPktHdr->svh?TRUE:FALSE))
			goto RET_FAIL;
	}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	if(ASICDRIVERVER==0x1)
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED)
		{
			if(p6->in_ctagif!=(pPktHdr->cvh?TRUE:FALSE))
			goto RET_FAIL;
		}
	}else
#endif
	{
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED
			|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED)
		{
			if(p6->in_ctagif!=(pPktHdr->cvh?TRUE:FALSE))
				goto RET_FAIL;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED)
		{
			if(p6->in_cvlan_pri!=pPktHdr->cvlanpri)
				goto RET_FAIL;
		}
	}
	if(p6->in_pppoeif!=(pPktHdr->ppph?TRUE:FALSE))
		goto RET_FAIL;
	if(p6->in_pppoe_sid_check && (pPktHdr->ppph))
	{
		if(p6->in_pppoe_sid!=ntohs(pPktHdr->ppph->sid))
		goto RET_FAIL;
	}
	if(p6->in_dsliteif!=((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE)?TRUE:FALSE))
		goto RET_FAIL;
	if(p6->rsvd_in_6rdif!=((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_6RD)?TRUE:FALSE))
		goto RET_FAIL;
	if(p6->in_pptpif!=((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP)?TRUE:FALSE))
		goto RET_FAIL;
	if(p6->in_l2tpif!=((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP)?TRUE:FALSE))
		goto RET_FAIL;

	if(p6->in_src_ip_check){
		if(p6->in_dsliteif){
			/* MAP-E:
			*	In FMR's CE1->CE2->BR->CE1 case, 
			*		the srcAddr6 in downstream is different from the dstAddr6 in upstream.
			*	So bypass the check of 'in_src_ipv6_addr_hash' to pass this test case. 
			*/
			pNetif = &(fc_db.netifHwTbl[p6->in_intf_idx]); ;
			pFlowTable = &(fc_db.flowTbl[pNetif->outerHdrFlowIdx]);
			if (pFlowTable->mapeInfo.mape_flow6 != 1){
				if(p6->in_src_ipv6_addr_hash!=pPktHdr->ipv6Sip_hash)
					goto RET_FAIL;
			}
		}else{
			if(p6->in_src_ipv4_addr!=ntohl(pPktHdr->outer_iph->saddr))
				goto RET_FAIL;
		}
	}

	if(p6->in_dst_ip_check){
		if(p6->in_dsliteif){
			if(p6->in_dst_ipv6_addr_hash!=pPktHdr->ipv6Dip_hash)
				goto RET_FAIL;
		}else{
			if(p6->in_dst_ipv4_addr!=ntohl(pPktHdr->outer_iph->daddr))
				goto RET_FAIL;
		}
	}

	if(p6->in_l4_src_port_check){
		if(p6->in_l2tpif){

			if(p6->in_l4_src_port!=pPktHdr->outer_udph->source)
				goto RET_FAIL;
		}
	}

	if(p6->in_l4_dst_port_check){
		if(p6->in_l2tpif){

			if(p6->in_l4_dst_port!=pPktHdr->outer_udph->dest)
				goto RET_FAIL;
		}
	}

	if(p6->in_protocol!= FB_INPROTOCOL_ALL_ACCEPT)
	{
		//todo: in_protocol compare
	}

	if(p6->in_pptpif){
		if(p6->in_gre_call_id_check){
			if(p6->in_gre_call_id!=pPktHdr->tunnelInfo.pptp.grecallid)
			goto RET_FAIL;
		}
	}

	if(p6->in_l2tpif){
		if(p6->in_l2tp_tunnel_id_check)
		{
			if(p6->in_l2tp_tunnel_id!=pPktHdr->tunnelInfo.l2tp.tunnelid)
				goto RET_FAIL;
		}
		if(p6->in_l2tp_session_id_check)
		{
			if(p6->in_l2tp_session_id!=pPktHdr->tunnelInfo.l2tp.sessionid)
				goto RET_FAIL;
		}
	}

	return (TRUE);

RET_FAIL:
	return (FALSE);
}

#if defined(CONFIG_FC_RTL8277C_SERIES)
// get hash index by flow entry
uint32 _rtk_fc_flow_hashIndex(rtk_fc_tableFlowEntry_t flowPathEntry, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, rtk_8277c_asic_flow_hash_crc_t *flow_hash_crc)
{
	rtk_8277c_asic_flow_hash_cal_info_t flowHashCalInfo;
	memset(&flowHashCalInfo, 0, sizeof(flowHashCalInfo));

	if(!flow_hash_crc)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if((flowPathEntry.path1.in_path != FB_PATH_6) && (!pG3IgrExtraInfo))
		return RTK_FC_RET_ERR_NULL_POINTER; // path6 may hava null pG3IgrExtraInfo

	if(flowPathEntry.path1.in_path==FB_PATH_12)
	{
		//FB_PATH_12
		flowHashCalInfo.in_path = FB_PATH_12;
		memcpy(&flowHashCalInfo.path12_key.src_mac[0], &fc_db.lutTbl[flowPathEntry.path1.in_smac_lut_idx]->l2Addr, ETH_ALEN);
		memcpy(&flowHashCalInfo.path12_key.dst_mac[0], &fc_db.lutTbl[flowPathEntry.path1.in_dmac_lut_idx]->l2Addr, ETH_ALEN);

		flowHashCalInfo.path12_key.orig_lspid		= fc_db.lutTbl[pG3IgrExtraInfo->lutIgrSaIdx]->spa;
		if(flowPathEntry.path1.in_stagif)
		{
			flowHashCalInfo.path12_key.stag_if		= TRUE;
			flowHashCalInfo.path12_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pG3IgrExtraInfo->igr_svlan_tpid_sel];
			flowHashCalInfo.path12_key.svlan_id		= pG3IgrExtraInfo->svlan_id;
			flowHashCalInfo.path12_key.svlan_pri	= pG3IgrExtraInfo->svlan_pri;
			flowHashCalInfo.path12_key.svlan_dei	= pG3IgrExtraInfo->igr_svlan_dei;
		}
		if(flowPathEntry.path1.in_ctagif)
		{
			flowHashCalInfo.path12_key.ctag_if		= TRUE;
			flowHashCalInfo.path12_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path12_key.cvlan_id		= pG3IgrExtraInfo->cvlan_id;
			flowHashCalInfo.path12_key.cvlan_pri	= flowPathEntry.path1.in_cvlan_pri;
			flowHashCalInfo.path12_key.cvlan_cfi	= pG3IgrExtraInfo->igr_cvlan_cfi;
		}

		if(flowPathEntry.path1.in_tos_check)
		{
			flowHashCalInfo.path12_key.ip_dscp = (flowPathEntry.path1.in_tos >>2)&0x3f;
			flowHashCalInfo.path12_key.ip_ecn = flowPathEntry.path1.in_tos&0x3;
		}

		// from PON
		if(flowHashCalInfo.path12_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path12_key.pon_streamId_or_wifi_devIdx = pG3IgrExtraInfo->pon_stream_id;
		// from wifi
		if((1 << flowHashCalInfo.path12_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path12_key.pon_streamId_or_wifi_devIdx =  fc_db.lutTbl[pG3IgrExtraInfo->lutIgrSaIdx]->wlan_dev_idx;
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_34)
	{
		flowHashCalInfo.in_path = FB_PATH_34;
		flowHashCalInfo.path34_key.orig_lspid		= fc_db.lutTbl[pG3IgrExtraInfo->lutIgrSaIdx]->spa;

		if(flowPathEntry.path3.in_stagif)
		{
			flowHashCalInfo.path34_key.stag_if		= TRUE;
			flowHashCalInfo.path34_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pG3IgrExtraInfo->igr_svlan_tpid_sel];
			flowHashCalInfo.path34_key.svlan_id		= pG3IgrExtraInfo->svlan_id;
			flowHashCalInfo.path34_key.svlan_pri	= pG3IgrExtraInfo->svlan_pri;
			flowHashCalInfo.path34_key.svlan_dei	= pG3IgrExtraInfo->igr_svlan_dei;
		}
		if(flowPathEntry.path3.in_ctagif)
		{
			flowHashCalInfo.path34_key.ctag_if		= TRUE;
			flowHashCalInfo.path34_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path34_key.cvlan_id		= pG3IgrExtraInfo->cvlan_id;
			flowHashCalInfo.path34_key.cvlan_pri	= flowPathEntry.path3.in_cvlan_pri;
			flowHashCalInfo.path34_key.cvlan_cfi		= pG3IgrExtraInfo->igr_cvlan_cfi;
		}
		if(flowPathEntry.path3.in_pppoeif)
		{
			flowHashCalInfo.path34_key.pppoetag_if		= TRUE;
			flowHashCalInfo.path34_key.pppoe_sid		= pG3IgrExtraInfo->pppoe_session_id;
		}
		if(flowPathEntry.path3.in_tos_check)
		{
			flowHashCalInfo.path34_key.ip_dscp = (flowPathEntry.path3.in_tos >>2)&0x3f;
			flowHashCalInfo.path34_key.ip_ecn = flowPathEntry.path3.in_tos&0x3;
		}
		if(flowPathEntry.path3.in_ipv4_or_ipv6)
		{
			flowHashCalInfo.path34_key.ipv4_or_ipv6 = TRUE; // 1: IPv6, 0: IPv4
			flowHashCalInfo.path34_key.ip_sa[0] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[0]);
			flowHashCalInfo.path34_key.ip_sa[1] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[4]);
			flowHashCalInfo.path34_key.ip_sa[2] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[8]);
			flowHashCalInfo.path34_key.ip_sa[3] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[12]);
			flowHashCalInfo.path34_key.ip_da[0] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[0]);
			flowHashCalInfo.path34_key.ip_da[1] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[4]);
			flowHashCalInfo.path34_key.ip_da[2] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[8]);
			flowHashCalInfo.path34_key.ip_da[3] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[12]);
		}
		else
		{
			flowHashCalInfo.path34_key.ipv4_or_ipv6 = FALSE; // 1: IPv6, 0: IPv4
			flowHashCalInfo.path34_key.ip_sa[3] = flowPathEntry.path3.in_src_ipv4_addr;
			flowHashCalInfo.path34_key.ip_da[3] = flowPathEntry.path3.in_dst_ipv4_addr;
		}

		flowHashCalInfo.path34_key.l4proto = flowPathEntry.path3.in_l4proto; // 1: TCP, 0: UDP
		flowHashCalInfo.path34_key.l4_src_port		=  flowPathEntry.path3.in_l4_src_port;
		flowHashCalInfo.path34_key.l4_dst_port		=  flowPathEntry.path3.in_l4_dst_port;

		// from PON
		if(flowHashCalInfo.path34_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path34_key.pon_streamId_or_wifi_devIdx = pG3IgrExtraInfo->pon_stream_id;
		// from wifi
		if((1 << flowHashCalInfo.path34_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path34_key.pon_streamId_or_wifi_devIdx = fc_db.lutTbl[pG3IgrExtraInfo->lutIgrSaIdx]->wlan_dev_idx;
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_5) 		//path 5
	{
		flowHashCalInfo.in_path = FB_PATH_5;
		flowHashCalInfo.path5_key.orig_lspid		=  fc_db.lutTbl[pG3IgrExtraInfo->lutIgrSaIdx]->spa;
		if(flowPathEntry.path5.in_stagif)
		{
			flowHashCalInfo.path5_key.stag_if		= TRUE;
			flowHashCalInfo.path5_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pG3IgrExtraInfo->igr_svlan_tpid_sel];
			flowHashCalInfo.path5_key.svlan_id		= pG3IgrExtraInfo->svlan_id;
			flowHashCalInfo.path5_key.svlan_pri		= pG3IgrExtraInfo->svlan_pri;
			flowHashCalInfo.path5_key.svlan_dei		= pG3IgrExtraInfo->igr_svlan_dei;
		}
		if(flowPathEntry.path5.in_ctagif)
		{
			flowHashCalInfo.path5_key.ctag_if		= TRUE;
			flowHashCalInfo.path5_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path5_key.cvlan_id		= pG3IgrExtraInfo->cvlan_id;
			flowHashCalInfo.path5_key.cvlan_pri		= flowPathEntry.path5.in_cvlan_pri;
			flowHashCalInfo.path5_key.cvlan_cfi		= pG3IgrExtraInfo->igr_cvlan_cfi;
		}
		if(flowPathEntry.path5.in_pppoeif)
		{
			flowHashCalInfo.path5_key.pppoetag_if		= TRUE;
			flowHashCalInfo.path5_key.pppoe_sid			= pG3IgrExtraInfo->pppoe_session_id;
		}
		if(flowPathEntry.path5.in_tos_check)
		{
			flowHashCalInfo.path5_key.ip_dscp = (flowPathEntry.path5.in_tos >>2)&0x3f;
			flowHashCalInfo.path5_key.ip_ecn = flowPathEntry.path5.in_tos&0x3;
		}
		if(flowPathEntry.path5.in_ipv4_or_ipv6)
		{
			flowHashCalInfo.path5_key.ipv4_or_ipv6 = TRUE; // 1: IPv6, 0: IPv4
			flowHashCalInfo.path5_key.ip_sa[0] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[0]);
			flowHashCalInfo.path5_key.ip_sa[1] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[4]);
			flowHashCalInfo.path5_key.ip_sa[2] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[8]);
			flowHashCalInfo.path5_key.ip_sa[3] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Saddr.s6_addr[12]);
			flowHashCalInfo.path5_key.ip_da[0] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[0]);
			flowHashCalInfo.path5_key.ip_da[1] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[4]);
			flowHashCalInfo.path5_key.ip_da[2] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[8]);
			flowHashCalInfo.path5_key.ip_da[3] = ntohl(*(uint32*)&pG3IgrExtraInfo->ipv6_Daddr.s6_addr[12]);
		}
		else
		{
			flowHashCalInfo.path5_key.ipv4_or_ipv6 = FALSE; // 1: IPv6, 0: IPv4
			flowHashCalInfo.path5_key.ip_sa[3] = flowPathEntry.path5.in_src_ipv4_addr;
			if(flowPathEntry.path5.out_l4_act)
			{
				// NAPT
				if(flowPathEntry.path5.out_l4_direction)
					flowHashCalInfo.path5_key.ip_da[3] =flowPathEntry.path5.in_dst_ipv4_addr;// outbound
				else
					flowHashCalInfo.path5_key.ip_da[3] = fc_db.netifHwTbl[flowPathEntry.path5.in_intf_idx].intf.gateway_ipv4_addr; // inbound
			}
			else
			{
				// Routing
				flowHashCalInfo.path5_key.ip_da[3] = flowPathEntry.path5.in_dst_ipv4_addr;
			}
		}

		flowHashCalInfo.path5_key.l4proto = flowPathEntry.path5.in_l4proto; // 1: TCP, 0: UDPs
		flowHashCalInfo.path5_key.l4_src_port		=  flowPathEntry.path5.in_l4_src_port;
		flowHashCalInfo.path5_key.l4_dst_port		=  flowPathEntry.path5.in_l4_dst_port;

		// from PON
		if(flowHashCalInfo.path5_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path5_key.pon_streamId_or_wifi_devIdx = pG3IgrExtraInfo->pon_stream_id;
		// from wifi
		if((1 << flowHashCalInfo.path5_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path5_key.pon_streamId_or_wifi_devIdx = fc_db.lutTbl[pG3IgrExtraInfo->lutIgrSaIdx]->wlan_dev_idx;
	}

	if(flowPathEntry.path1.in_path==FB_PATH_6)
	{
		//path 6: no need to calculate CRC16/32
		flow_hash_crc->crc16 = 0;
		flow_hash_crc->crc32 = 0;
	}
	else
	{
		//path12, path34, path5: calculate CRC16/32
		if(rtk_8277c_asic_flow_hash_crc_cal(&flowHashCalInfo, flow_hash_crc) != ASIC_RET_SUCCESS)
		{
			WARNING("Calculate flow CRC32/CRC16 failed!!!");
			return RTK_FC_RET_ERR;
		}
	}
	return RTK_FC_RET_OK;
}

// get hash index by pkthdr (support outer header only)
__IRAM_FC_SHORTCUT
int32 _rtk_fc_flow_hashIndex_byDualPktOuterHdr(rtk_fc_pktHdr_t *pPktHdr, rtk_8277c_asic_flow_hash_crc_t *flow_hash_crc)
{
	rtk_8277c_asic_flow_hash_cal_info_t flowHashCalInfo;
	memset(&flowHashCalInfo, 0, sizeof(flowHashCalInfo));

	if((pPktHdr->dualHdrType != RTK_FC_DUALTYPE_PPTP) && (pPktHdr->dualHdrType != RTK_FC_DUALTYPE_L2TP) && (pPktHdr->dualHdrType != RTK_FC_DUALTYPE_VXLAN))
	{
		DEBUG("non PPTP/L2TP/VXLAN packet! support PPTP/L2TP passthrough & VXLAN only");
		return RTK_FC_RET_ERR;
	}

	if(pPktHdr->smacL2Idx == FAIL) {
		DEBUG("unknown sa");
		return RTK_FC_RET_ERR;
	}

	if(!pPktHdr->isMulticast && pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		return RTK_FC_RET_ERR;
	}

	if(pPktHdr->outer_iph == NULL)
	{
		DEBUG("There is no outer IP header info");
		return RTK_FC_RET_ERR;
	}

	flowHashCalInfo.in_path = (pPktHdr->dmacToGatewayMAC)?FB_PATH_5:FB_PATH_34;	//dual header: PPTP/L2TP, consider path 3 & 5 only

	if(flowHashCalInfo.in_path==FB_PATH_5)
	{
		flowHashCalInfo.path5_key.orig_lspid		= pPktHdr->ingressPort.macPortIdx;
		if(pPktHdr->svh)
		{
			flowHashCalInfo.path5_key.stag_if		= TRUE;
			flowHashCalInfo.path5_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pPktHdr->stpid_sel];
			flowHashCalInfo.path5_key.svlan_id		= pPktHdr->svlanid;
			flowHashCalInfo.path5_key.svlan_pri		= pPktHdr->svlanpri;
			flowHashCalInfo.path5_key.svlan_dei		= pPktHdr->svlandei;
		}
		if(pPktHdr->cvh)
		{
			flowHashCalInfo.path5_key.ctag_if		= TRUE;
			flowHashCalInfo.path5_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path5_key.cvlan_id		= pPktHdr->cvlanid;
			flowHashCalInfo.path5_key.cvlan_pri		= pPktHdr->cvlanpri;
			flowHashCalInfo.path5_key.cvlan_cfi		= pPktHdr->cvlancfi;
		}

		if(pPktHdr->outer_ppph)
		{
			flowHashCalInfo.path5_key.pppoetag_if		= TRUE;
			flowHashCalInfo.path5_key.pppoe_sid			= ntohs(pPktHdr->outer_ppph->sid);
		}

		flowHashCalInfo.path5_key.ipv4_or_ipv6		= 0;
		flowHashCalInfo.path5_key.l4proto			= 0;
		flowHashCalInfo.path5_key.ip_dscp			= (pPktHdr->outer_iph->tos>>2)&0x3F;
		flowHashCalInfo.path5_key.ip_ecn			= pPktHdr->outer_iph->tos&0x3;
		flowHashCalInfo.path5_key.ip_sa[3] 			= ntohl(pPktHdr->outer_iph->saddr);
		flowHashCalInfo.path5_key.ip_da[3]			= ntohl(pPktHdr->outer_iph->daddr);

		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP)
		{
			//keep L4 SPORT DPORT to 0
		}
		else
		{
			flowHashCalInfo.path5_key.l4_src_port	= ntohs(pPktHdr->outer_udph->source);
			flowHashCalInfo.path5_key.l4_dst_port	= ntohs(pPktHdr->outer_udph->dest);
		}

		// from PON
		if(flowHashCalInfo.path5_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path5_key.pon_streamId_or_wifi_devIdx = pPktHdr->ponstreamid;
		// from wifi
		if((1 << flowHashCalInfo.path5_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path5_key.pon_streamId_or_wifi_devIdx = pPktHdr->igrWlanDevIdx;
	}
	else if(flowHashCalInfo.in_path==FB_PATH_34)
	{
		flowHashCalInfo.path34_key.orig_lspid		= pPktHdr->ingressPort.macPortIdx;
		if(pPktHdr->svh)
		{
			flowHashCalInfo.path34_key.stag_if		= TRUE;
			flowHashCalInfo.path34_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pPktHdr->stpid_sel];
			flowHashCalInfo.path34_key.svlan_id		= pPktHdr->svlanid;
			flowHashCalInfo.path34_key.svlan_pri	= pPktHdr->svlanpri;
			flowHashCalInfo.path34_key.svlan_dei	= pPktHdr->svlandei;
		}
		if(pPktHdr->cvh)
		{
			flowHashCalInfo.path34_key.ctag_if		= TRUE;
			flowHashCalInfo.path34_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path34_key.cvlan_id		= pPktHdr->cvlanid;
			flowHashCalInfo.path34_key.cvlan_pri	= pPktHdr->cvlanpri;
			flowHashCalInfo.path34_key.cvlan_cfi	= pPktHdr->cvlancfi;
		}

		if(pPktHdr->outer_ppph)
		{
			flowHashCalInfo.path34_key.pppoetag_if		= TRUE;
			flowHashCalInfo.path34_key.pppoe_sid		= ntohs(pPktHdr->outer_ppph->sid);
		}

		flowHashCalInfo.path34_key.ipv4_or_ipv6		= 0;
		flowHashCalInfo.path34_key.l4proto			= 0;
		flowHashCalInfo.path34_key.ip_dscp			= (pPktHdr->outer_iph->tos>>2)&0x3F;
		flowHashCalInfo.path34_key.ip_ecn			= pPktHdr->outer_iph->tos&0x3;

		flowHashCalInfo.path34_key.ip_sa[3]			= ntohl(pPktHdr->outer_iph->saddr);
		flowHashCalInfo.path34_key.ip_da[3]			= ntohl(pPktHdr->outer_iph->daddr);

		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP)
		{
			//keep L4 SPORT DPORT to 0
		}
		else
		{
			flowHashCalInfo.path34_key.l4_src_port	= ntohs(pPktHdr->outer_udph->source);
			flowHashCalInfo.path34_key.l4_dst_port	= ntohs(pPktHdr->outer_udph->dest);
		}

		// from PON
		if(flowHashCalInfo.path34_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path34_key.pon_streamId_or_wifi_devIdx = pPktHdr->ponstreamid;
		// from wifi
		if((1 << flowHashCalInfo.path34_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path34_key.pon_streamId_or_wifi_devIdx = pPktHdr->igrWlanDevIdx;
	}
	if(rtk_8277c_asic_flow_hash_crc_cal(&flowHashCalInfo, flow_hash_crc) != ASIC_RET_SUCCESS)
	{
		WARNING("Calculate flow CRC32/CRC16 failed!!!");
		return RTK_FC_RET_ERR;
	}
	return RTK_FC_RET_OK;
}

// get hash index by pkthdr (support inner header only)
__IRAM_FC_SHORTCUT
int _rtk_fc_flow_hashIndex_byPktHdr(rtk_fc_pktHdr_t *pPktHdr, rtk_8277c_asic_flow_hash_crc_t *flow_hash_crc)
{
	uint16 sport = 0, dport = 0;
	bool isL3 = ((pPktHdr->iph) || (pPktHdr->ip6h)) ? TRUE : FALSE;
	bool isL4 = ((pPktHdr->tcph) || (pPktHdr->udph)) ? TRUE : FALSE;		// L4 protocol accelerated by HW
	bool fragFakeTcph = FALSE;
#if 0 // calculate CRC according to CLS t2 profile selection rule
	bool isMcPassthrough = (!pPktHdr->isMulticast && ((pPktHdr->iph && FLOW_IPV4_MULTICAST_ADDRESS(ntohl(pPktHdr->iph->daddr))) ||(pPktHdr->ip6h && FLOW_IPV6_MULTICAST_ADDRESS(ntohl(pPktHdr->ip6h->daddr.s6_addr32[0])))))?TRUE:FALSE;
#endif

	rtk_8277c_asic_flow_hash_cal_info_t flowHashCalInfo;
	memset(&flowHashCalInfo, 0, sizeof(flowHashCalInfo));
#if 0
	if(pPktHdr->smacL2Idx == FAIL) {
		DEBUG("unknown sa");
		return RTK_FC_RET_ERR;
	}

	if(!pPktHdr->isMulticast && pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		return RTK_FC_RET_ERR;
	}
#endif
	if(isL4) {
		sport= (pPktHdr->tcph) ? ntohs(pPktHdr->tcph->source) : ntohs(pPktHdr->udph->source);
		dport = (pPktHdr->tcph) ? ntohs(pPktHdr->tcph->dest) : ntohs(pPktHdr->udph->dest);
	}

	// for second and later fragment packet get correct hash index
	if (pPktHdr->ipFragFlag && !(pPktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG) && (pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_TCP || pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_UDP)) {
		isL4 = TRUE;
		sport = pPktHdr->cacheIpFragInfo.src_port;
		dport = pPktHdr->cacheIpFragInfo.dst_port;
		if (pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_TCP)
			fragFakeTcph = TRUE;
		FRAGMENT("frag with iph id=0x%x, sport=0x%x, dport=0x%x", ntohs(pPktHdr->iph->id), sport, dport);
	}

	// calculate CRC according to CLS t2 profile selection rule
	if(pPktHdr->isMulticast)
		flowHashCalInfo.in_path = FB_PATH_MC;
	else if(pPktHdr->dmacToGatewayMAC && isL3)
		flowHashCalInfo.in_path = FB_PATH_5;
	else if(isL3 && isL4)
	{
		if(/*isMcPassthrough || */fc_db.controlFuc.bridge_5tuple_flow_accelerate_by_2tuple)
			flowHashCalInfo.in_path = FB_PATH_12;
		else
			flowHashCalInfo.in_path = FB_PATH_34;
	}
	else
		flowHashCalInfo.in_path = FB_PATH_12;

	//support multicast a software hash by path34 when l3 only by hash l4 sport:0 and dport:0
	if(isL3 && isL4 ==0 && pPktHdr->isMulticast)
		flowHashCalInfo.in_path = FB_PATH_34;

	if(flowHashCalInfo.in_path==FB_PATH_5)
	{
		flowHashCalInfo.path5_key.orig_lspid		= pPktHdr->ingressPort.macPortIdx;
		if(pPktHdr->svh)
		{
			flowHashCalInfo.path5_key.stag_if		= TRUE;
			flowHashCalInfo.path5_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pPktHdr->stpid_sel];
			flowHashCalInfo.path5_key.svlan_id		= pPktHdr->svlanid;
			flowHashCalInfo.path5_key.svlan_pri		= pPktHdr->svlanpri;
			flowHashCalInfo.path5_key.svlan_dei		= pPktHdr->svlandei;
		}
		if(pPktHdr->cvh)
		{
			flowHashCalInfo.path5_key.ctag_if		= TRUE;
			flowHashCalInfo.path5_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path5_key.cvlan_id		= pPktHdr->cvlanid;
			flowHashCalInfo.path5_key.cvlan_pri		= pPktHdr->cvlanpri;
			flowHashCalInfo.path5_key.cvlan_cfi		= pPktHdr->cvlancfi;
		}

		if(pPktHdr->ppph)
		{
			flowHashCalInfo.path5_key.pppoetag_if		= TRUE;
			flowHashCalInfo.path5_key.pppoe_sid			= ntohs(pPktHdr->ppph->sid);
		}
		flowHashCalInfo.path5_key.ipv4_or_ipv6		= (pPktHdr->iph) ? 0:1;		// 1: IPv6, 0: IPv4
		flowHashCalInfo.path5_key.l4proto			= (pPktHdr->tcph) ? 1:0;	// 1: TCP, 0: UDP
		if (fragFakeTcph)
			flowHashCalInfo.path5_key.l4proto		= 1;
		flowHashCalInfo.path5_key.ip_dscp			= (pPktHdr->iph) ? (pPktHdr->iph->tos>>2)&0x3F : (((pPktHdr->ip6h->priority<<2)&0x3C)|((pPktHdr->ip6h->flow_lbl[0]>>6)&0x3));
		flowHashCalInfo.path5_key.ip_ecn			= (pPktHdr->iph) ? pPktHdr->iph->tos&0x3 : ((pPktHdr->ip6h->flow_lbl[0]>>4)&0x3);

		if(pPktHdr->iph)
		{
			flowHashCalInfo.path5_key.ip_sa[3] = ntohl(pPktHdr->iph->saddr);
			flowHashCalInfo.path5_key.ip_da[3] = ntohl(pPktHdr->iph->daddr);
		}
		else
		{
			flowHashCalInfo.path5_key.ip_sa[0] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[0]);
			flowHashCalInfo.path5_key.ip_sa[1] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[4]);
			flowHashCalInfo.path5_key.ip_sa[2] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[8]);
			flowHashCalInfo.path5_key.ip_sa[3] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[12]);
			flowHashCalInfo.path5_key.ip_da[0] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[0]);
			flowHashCalInfo.path5_key.ip_da[1] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[4]);
			flowHashCalInfo.path5_key.ip_da[2] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[8]);
			flowHashCalInfo.path5_key.ip_da[3] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[12]);
		}

		flowHashCalInfo.path5_key.l4_src_port		=  sport;
		flowHashCalInfo.path5_key.l4_dst_port		=  dport;

		// from PON
		if(flowHashCalInfo.path5_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path5_key.pon_streamId_or_wifi_devIdx = pPktHdr->ponstreamid;
		// from wifi
		if((1 << flowHashCalInfo.path5_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path5_key.pon_streamId_or_wifi_devIdx = pPktHdr->igrWlanDevIdx;
	}
	else if(flowHashCalInfo.in_path==FB_PATH_34)
	{
		flowHashCalInfo.path34_key.orig_lspid		= pPktHdr->ingressPort.macPortIdx;
		if(pPktHdr->svh)
		{
			flowHashCalInfo.path34_key.stag_if		= TRUE;
			flowHashCalInfo.path34_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pPktHdr->stpid_sel];
			flowHashCalInfo.path34_key.svlan_id		= pPktHdr->svlanid;
			flowHashCalInfo.path34_key.svlan_pri	= pPktHdr->svlanpri;
			flowHashCalInfo.path34_key.svlan_dei	= pPktHdr->svlandei;
		}
		if(pPktHdr->cvh)
		{
			flowHashCalInfo.path34_key.ctag_if		= TRUE;
			flowHashCalInfo.path34_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path34_key.cvlan_id		= pPktHdr->cvlanid;
			flowHashCalInfo.path34_key.cvlan_pri	= pPktHdr->cvlanpri;
			flowHashCalInfo.path34_key.cvlan_cfi	= pPktHdr->cvlancfi;
		}

		if(pPktHdr->ppph)
		{
			flowHashCalInfo.path34_key.pppoetag_if		= TRUE;
			flowHashCalInfo.path34_key.pppoe_sid		= ntohs(pPktHdr->ppph->sid);
		}
		flowHashCalInfo.path34_key.ipv4_or_ipv6		= (pPktHdr->iph) ? 0:1;		// 1: IPv6, 0: IPv4
		flowHashCalInfo.path34_key.l4proto			= (pPktHdr->tcph) ? 1:0;	// 1: TCP, 0: UDP
		if (fragFakeTcph)
			flowHashCalInfo.path34_key.l4proto		= 1;
		flowHashCalInfo.path34_key.ip_dscp			= (pPktHdr->iph) ? (pPktHdr->iph->tos>>2)&0x3F : (((pPktHdr->ip6h->priority<<2)&0x3C)|((pPktHdr->ip6h->flow_lbl[0]>>6)&0x3));
		flowHashCalInfo.path34_key.ip_ecn			= (pPktHdr->iph) ? pPktHdr->iph->tos&0x3 : ((pPktHdr->ip6h->flow_lbl[0]>>4)&0x3);

		if(pPktHdr->iph)
		{
			flowHashCalInfo.path34_key.ip_sa[3] = ntohl(pPktHdr->iph->saddr);
			flowHashCalInfo.path34_key.ip_da[3] = ntohl(pPktHdr->iph->daddr);
		}
		else
		{
			flowHashCalInfo.path34_key.ip_sa[0] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[0]);
			flowHashCalInfo.path34_key.ip_sa[1] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[4]);
			flowHashCalInfo.path34_key.ip_sa[2] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[8]);
			flowHashCalInfo.path34_key.ip_sa[3] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[12]);
			flowHashCalInfo.path34_key.ip_da[0] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[0]);
			flowHashCalInfo.path34_key.ip_da[1] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[4]);
			flowHashCalInfo.path34_key.ip_da[2] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[8]);
			flowHashCalInfo.path34_key.ip_da[3] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[12]);
		}

		flowHashCalInfo.path34_key.l4_src_port		=  sport;
		flowHashCalInfo.path34_key.l4_dst_port		=  dport;

		// from PON
		if(flowHashCalInfo.path34_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path34_key.pon_streamId_or_wifi_devIdx = pPktHdr->ponstreamid;
		// from wifi
		if((1 << flowHashCalInfo.path34_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path34_key.pon_streamId_or_wifi_devIdx = pPktHdr->igrWlanDevIdx;
	}
	else if(flowHashCalInfo.in_path==FB_PATH_12)
	{
		flowHashCalInfo.path12_key.orig_lspid		= pPktHdr->ingressPort.macPortIdx;
		memcpy(&flowHashCalInfo.path12_key.src_mac[0], &pPktHdr->eth->h_source[0], ETH_ALEN);
		memcpy(&flowHashCalInfo.path12_key.dst_mac[0], &pPktHdr->eth->h_dest[0], ETH_ALEN);
		if(pPktHdr->svh)
		{
			flowHashCalInfo.path12_key.stag_if		= TRUE;
			flowHashCalInfo.path12_key.svlan_tpid	= fc_db.systemGlobal.stagTPID[pPktHdr->stpid_sel];
			flowHashCalInfo.path12_key.svlan_id		= pPktHdr->svlanid;
			flowHashCalInfo.path12_key.svlan_pri	= pPktHdr->svlanpri;
			flowHashCalInfo.path12_key.svlan_dei	= pPktHdr->svlandei;
		}
		if(pPktHdr->cvh)
		{
			flowHashCalInfo.path12_key.ctag_if		= TRUE;
			flowHashCalInfo.path12_key.cvlan_tpid	= 0x8100;
			flowHashCalInfo.path12_key.cvlan_id		= pPktHdr->cvlanid;
			flowHashCalInfo.path12_key.cvlan_pri	= pPktHdr->cvlanpri;
			flowHashCalInfo.path12_key.cvlan_cfi	= pPktHdr->cvlancfi;
		}

		if(pPktHdr->iph)
		{
			flowHashCalInfo.path12_key.ip_dscp			=  (pPktHdr->iph->tos>>2)&0x3F;
			flowHashCalInfo.path12_key.ip_ecn			=  pPktHdr->iph->tos&0x3;
		}
		else if(pPktHdr->ip6h)
		{
			flowHashCalInfo.path12_key.ip_dscp			= (((pPktHdr->ip6h->priority<<2)&0x3C)|((pPktHdr->ip6h->flow_lbl[0]>>6)&0x3));
			flowHashCalInfo.path12_key.ip_ecn			= ((pPktHdr->ip6h->flow_lbl[0]>>4)&0x3);
		}

		// from PON
		if(flowHashCalInfo.path12_key.orig_lspid == RTK_FC_MAC_PORT_PON)
			flowHashCalInfo.path12_key.pon_streamId_or_wifi_devIdx = pPktHdr->ponstreamid;
		// from wifi
		if((1 << flowHashCalInfo.path12_key.orig_lspid) & RTK_FC_ALL_MAC_WLANCPU_PORTMASK)
			flowHashCalInfo.path12_key.pon_streamId_or_wifi_devIdx = pPktHdr->igrWlanDevIdx;
	}
	else
	{
		//FB_PATH_MC

		// MC profile: care vid and 8021p only for VLAN fileds.
		if(pPktHdr->svh)
		{
			flowHashCalInfo.mc_key.stag_if		= TRUE;
			flowHashCalInfo.mc_key.svlan_id		= pPktHdr->svlanid;
			flowHashCalInfo.mc_key.svlan_pri	= pPktHdr->svlanpri;
		}
		if(pPktHdr->cvh)
		{
			flowHashCalInfo.mc_key.ctag_if		= TRUE;
			flowHashCalInfo.mc_key.cvlan_id		= pPktHdr->cvlanid;
			flowHashCalInfo.mc_key.cvlan_pri		= pPktHdr->cvlanpri;
		}

		flowHashCalInfo.mc_key.ipv4_or_ipv6		= (pPktHdr->iph) ? 0:1;		// 1: IPv6, 0: IPv4

		if(pPktHdr->iph)
		{
			flowHashCalInfo.mc_key.ip_sa[3] = ntohl(pPktHdr->iph->saddr);
			flowHashCalInfo.mc_key.ip_da[3] = ntohl(pPktHdr->iph->daddr);
		}
		else
		{
			flowHashCalInfo.mc_key.ip_sa[0] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[0]);
			flowHashCalInfo.mc_key.ip_sa[1] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[4]);
			flowHashCalInfo.mc_key.ip_sa[2] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[8]);
			flowHashCalInfo.mc_key.ip_sa[3] = ntohl(*(uint32*)&pPktHdr->ip6h->saddr.s6_addr[12]);
			flowHashCalInfo.mc_key.ip_da[0] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[0]);
			flowHashCalInfo.mc_key.ip_da[1] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[4]);
			flowHashCalInfo.mc_key.ip_da[2] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[8]);
			flowHashCalInfo.mc_key.ip_da[3] = ntohl(*(uint32*)&pPktHdr->ip6h->daddr.s6_addr[12]);
		}
	}

	if(rtk_8277c_asic_flow_hash_crc_cal(&flowHashCalInfo, flow_hash_crc) != ASIC_RET_SUCCESS)
	{
		WARNING("Calculate flow CRC32/CRC16 failed!!!");
		return RTK_FC_RET_ERR;
	}
	return RTK_FC_RET_OK;
}

__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_flow_hashIndex_get(rtk_fc_pktHdr_t *pPktHdr, fc_rx_info_t *pRxInfo)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	bool sw_recul_crc = FALSE;
	char sw_recul_rsn[40] = {0};

	TRACE("dual header type = %d", pPktHdr->dualHdrType);

	if((likely((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_NONE) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_IPSEC) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_GRE_ETH_BR)))) {
		/*
		* single header: check hash idx from rxinfo
		*/
		{
			if(RXINFO_HASH_CRC_NEED_RECAL_HW_RSN(pRxInfo))
			{
				sw_recul_crc = TRUE;
				sprintf(sw_recul_rsn, "%s", "HW_RSN need to re-calculate CRC");
			}
			else if(pPktHdr->ipFragFlag)
			{
				sw_recul_crc = TRUE;
				sprintf(sw_recul_rsn, "%s", "pkt is ipFrag");
			}
			/*
				SW work around for acl trap:
				1. do not set 0xf for t2_ctrl									=> for HW CRC calculation.
				2. TTL set to 0													=> for hash hit packets trap to CPU (by TTL check)
				3. hdrCPU->mdata_raw.mdata_l & RXINFO_REF_ACL_RSN_CTRL_USER_CRC	=> for SW to recover ACL trap reason
				4. no_drop set to 1												=> for not to be Drop by MC hash profile default action (MC hash profile use policer rate 0 to drop packet)
				===
				HW reason:
				[5 tuple]
				- flow miss		<= ACL trap must be this reason (NO need to recalculate CRC)
				[2 tuple]
				- flow miss		<= ACL trap must be this reason (need to recalculate CRC due to hash tuple be set to RTK_8277C_FLOW_PROFILE_FLOW_5TUPLE_TCP_FLAG0)
				[MC]
				- flow miss		<= ACL trap must be this reason (need to recalculate CRC due to hash tuple be set to RTK_8277C_FLOW_PROFILE_FLOW_5TUPLE_TCP_FLAG0)
				===
			*/
			if(RXINFO_HASH_CRC_NEED_RECAL_ACL_TRP(pRxInfo))
			{
				if(fc_db.controlFuc.bridge_5tuple_flow_accelerate_by_2tuple && (!pPktHdr->dmacToGatewayMAC) && (pPktHdr->tcph || pPktHdr->udph))
				{
					sw_recul_crc = TRUE;
					sprintf(sw_recul_rsn, "%s", "ACL trap and pkt is 2 tuple flow");
				}
				else if((!pPktHdr->tcph) && (!pPktHdr->udph))
				{
					sw_recul_crc = TRUE;
					sprintf(sw_recul_rsn, "%s", "ACL trap and pkt is 2 tuple flow");
				}
				else if(pPktHdr->isMulticast)
				{
					sw_recul_crc = TRUE;
					sprintf(sw_recul_rsn, "%s", "ACL trap and pkt is Multicast flow");
				}
				else if(pPktHdr->dmacToGatewayMAC && (!((pPktHdr->tcph) || (pPktHdr->udph))) && ((pPktHdr->iph) || (pPktHdr->ip6h)))
				{
					/* TO-DO: if HW ACL support pure L3 routing packets to select 5 tuple hash profile, this condition can be removed.*/
					sw_recul_crc = TRUE;
					sprintf(sw_recul_rsn, "%s", "pure L3 routing");
				}
			}
			if(sw_recul_crc)
			{
				rtk_8277c_asic_flow_hash_crc_t flow_hash_crc;

				if(_rtk_fc_flow_hashIndex_byPktHdr(pPktHdr, &flow_hash_crc) != RTK_FC_RET_OK)
				{
					WARNING("Get flow CRC by PktHdr failed");
					ret = RTK_FC_RET_ERR;
				}

				pPktHdr->flowHashIdx = flow_hash_crc.crc16;
				pPktHdr->crc32 = flow_hash_crc.crc32;
				DEBUG("%s, need to recalculate crc16/crc32: 0x%04x/0x%08x", sw_recul_rsn, pPktHdr->flowHashIdx, pPktHdr->crc32);
			}
			else
			{
				pPktHdr->flowHashIdx = RXINFO_HASH_CRC16(pRxInfo);
				pPktHdr->crc32 = RXINFO_HASH_CRC32(pRxInfo);
				DEBUG("crc16(0x%04x) and crc32(0x%08x) in header_cpu", pPktHdr->flowHashIdx, pPktHdr->crc32);
				if(unlikely(fc_db.controlFuc.hash_crc_debug))
				{
					if((pPktHdr->outer_iph && (pPktHdr->outer_iph->ihl!=5)) ||
						(pPktHdr->iph && (pPktHdr->iph->ihl!=5)) ||
						(pPktHdr->ip6h && (pPktHdr->ip6h->nexthdr!=IPPROTO_IPIP) && (pPktHdr->ip6h->nexthdr!=IPPROTO_TCP) && (pPktHdr->ip6h->nexthdr!=IPPROTO_UDP))
						)
					{
						//IP option and TCP FIN/RST are flow keys. CRC recalculate must mis-matched, no need to recalculate.
						DEBUG("[hash_crc_debug] no need SW to recalculate CRC");
					}
					else
					{
						rtk_8277c_asic_flow_hash_crc_t flow_hash_crc = {0};

						if(_rtk_fc_flow_hashIndex_byPktHdr(pPktHdr, &flow_hash_crc) != RTK_FC_RET_OK)
						{
							WARNING("Get flow CRC by PktHdr failed");
							ret = RTK_FC_RET_ERR;
						}
						if((flow_hash_crc.crc16 != pPktHdr->flowHashIdx) || (flow_hash_crc.crc32 != pPktHdr->crc32))
							WARNING("[hash_crc_debug] CRC unmatched!!! crc16/crc32(SW): 0x%04x/0x%08x, crc16/crc32(HW): 0x%04x/0x%08x", flow_hash_crc.crc16, flow_hash_crc.crc32, pPktHdr->flowHashIdx, pPktHdr->crc32);
						else
							TRACE("[hash_crc_debug] CRC matched!!! crc16/crc32(SW): 0x%04x/0x%08x, crc16/crc32(HW): 0x%04x/0x%08x", flow_hash_crc.crc16, flow_hash_crc.crc32, pPktHdr->flowHashIdx, pPktHdr->crc32);
					}
				}
			}
		}
	}
	else
	{
		/*
		 * dual header: search outer entry first which was saved in netif table
		*/
		uint8 hitPath6 = FALSE;
		uint32 path6HashIdx = 0;
		uint32 i =0;

		for(i=0; i<RTK_FC_TABLESIZE_INTF; i++){
			if(fc_db.netifHwTbl[i].intf.valid==FALSE) continue;
			if(fc_db.netifHwTbl[i].dualType != pPktHdr->dualHdrType) continue;
			
			if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN  && fc_db.netifHwTbl[i].vxlan_vni == SIGNED_INVALID) 
				continue;
			else if(fc_db.netifHwTbl[i].outerHdrFlowIdx == SIGNED_INVALID) 
				continue;
			
			TRACE("compare to netif[%d] flow[%d]", i, fc_db.netifHwTbl[i].outerHdrFlowIdx);
			
			if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN  && fc_db.netifHwTbl[i].vxlan_vni == (ntohl(pPktHdr->vxlan_info.vxlanHdr->vx_vni)>>8) )
			{
				DEBUG("VXLAN DownStream interface hit!");
				goto INNER_PKT_HASH;
			}
			else if(_rtk_fc_flow_hitOuterHdrFlowByPktHdr(pPktHdr, fc_db.flowTbl[fc_db.netifHwTbl[i].outerHdrFlowIdx].pFlowEntry) == TRUE){
				hitPath6 = TRUE;
				path6HashIdx = fc_db.netifHwTbl[i].outerHdrFlowIdx;
				break;
			}
		}

		if(hitPath6)
		{
	#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[path6HashIdx].candidateState == CANDIDATE_STATE_NEW)
	#else
			if(fc_db.flowTbl[path6HashIdx].pFlowEntry->path6.valid == FALSE)
	#endif
			{
				rtk_fc_ingress_outerHdrPathUpdate(pPktHdr, path6HashIdx);
			}
			if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE)
			{
				if(fc_db.flowTbl[path6HashIdx].mapeInfo.mape_flow6)
					pPktHdr->isMAPE=TRUE;
				else
					pPktHdr->isDslite=TRUE;
			}
	
INNER_PKT_HASH: 
			// outer header hit: get inner hash from rxInfo
			{
		
				rtk_8277c_asic_flow_hash_crc_t flow_hash_crc;

				if(_rtk_fc_flow_hashIndex_byPktHdr(pPktHdr, &flow_hash_crc) != RTK_FC_RET_OK)
				{
					WARNING("Get flow CRC by PktHdr failed");
					ret = RTK_FC_RET_ERR;
				}

				pPktHdr->flowHashIdx = flow_hash_crc.crc16;
				pPktHdr->crc32 = flow_hash_crc.crc32;
			}

			pPktHdr->outerHdrMiss = FALSE;
			TRACE("hit outer header flow path, inner hash crc16/crc32 are 0x%04x/0x%08x", pPktHdr->flowHashIdx, pPktHdr->crc32);
		}
		else
		{
			//miss outer header to path5, use outerheader to calculate path1~5 hash index
			{
				rtk_8277c_asic_flow_hash_crc_t flow_hash_crc;

				if(_rtk_fc_flow_hashIndex_byDualPktOuterHdr(pPktHdr, &flow_hash_crc) != RTK_FC_RET_OK)
				{
					WARNING("Get flow CRC by PktHdr failed");
					ret = RTK_FC_RET_ERR;
				}

				pPktHdr->flowHashIdx = flow_hash_crc.crc16;
				pPktHdr->crc32 = flow_hash_crc.crc32;
			}

			pPktHdr->outerHdrMiss = TRUE;

			TRACE("miss outer header flow path, recalculate crc16/crc32 index by outer header: 0x%04x/0x%08x", pPktHdr->flowHashIdx, pPktHdr->crc32);
		}

	}
	return ret;
}


#else
// get hash index by flow entry
uint32 _rtk_fc_flow_hashIndex(rtk_fc_tableFlowEntry_t flowPathEntry, uint16 igrSVID, uint16 igrCVID, uint16 lutDaIdx_gmacChk /*used by path3 & path4*/)
{
	uint32 flowHashIdx;
	uint16 param1=0, param2=0;
	uint32 param3=0, param4=0;
	uint32 extraItem=0;


	if(flowPathEntry.path1.in_path==FB_PATH_12)
	{
		param1 = (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_SVID]==DISABLED)?igrSVID:0;
		param2 = (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED)?igrCVID:0;
		if(flowPathEntry.path1.in_multiple_act==0)		//path 1
		{
			param3 = flowPathEntry.path1.in_smac_lut_idx;
			param4 = flowPathEntry.path1.in_dmac_lut_idx;
			extraItem = _rtk_fc_sw_flowHashPath12ExtraItem_get(&flowPathEntry.path1);
		}
		else											//path 2
		{
			param3 = flowPathEntry.path2.in_smac_lut_idx;
			param4 = flowPathEntry.path2.in_dmac_lut_idx;
			extraItem = _rtk_fc_sw_flowHashPath12ExtraItem_get(&flowPathEntry.path2);
		}
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_34)
	{
		if(flowPathEntry.path1.in_multiple_act==0)		//path 3
		{
			param1 = flowPathEntry.path3.in_l4_src_port;
			param2 = flowPathEntry.path3.in_l4_dst_port;
			param3 = flowPathEntry.path3.in_src_ipv4_addr;
			param4 = flowPathEntry.path3.in_dst_ipv4_addr;
			extraItem = _rtk_fc_sw_flowHashPath34ExtraItem_get(&flowPathEntry.path3, igrSVID, igrCVID, lutDaIdx_gmacChk);
		}
		else											//path 4
		{
			param1 = flowPathEntry.path4.in_l4_src_port;
			param2 = flowPathEntry.path4.in_l4_dst_port;
			param3 = flowPathEntry.path4.in_src_ipv4_addr;
			param4 = flowPathEntry.path4.in_dst_ipv4_addr;
			extraItem = _rtk_fc_sw_flowHashPath34ExtraItem_get(&flowPathEntry.path4, igrSVID, igrCVID, lutDaIdx_gmacChk);
		}
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_5)			//path 5
	{
		if(flowPathEntry.path5.in_ipv4_or_ipv6==0 && flowPathEntry.path5.out_l4_act==1 && flowPathEntry.path5.out_l4_direction==0)
		{
			param1 = flowPathEntry.path5.in_l4_src_port;
			param2 = flowPathEntry.path5.in_l4_dst_port;
			param3 = flowPathEntry.path5.in_src_ipv4_addr;
			if(fc_db.netifHwTbl[flowPathEntry.path5.in_intf_idx].intf.valid && (fc_db.netifHwTbl[flowPathEntry.path5.in_intf_idx].intf.gateway_ipv4_addr!=0))
				param4 = fc_db.netifHwTbl[flowPathEntry.path5.in_intf_idx].intf.gateway_ipv4_addr;
			else
				WARNING("flow path 5 use ingress interface %d to find wan information was fail", flowPathEntry.path5.in_intf_idx);
			extraItem = _rtk_fc_sw_flowHashPath5ExtraItem_get(&flowPathEntry.path5, igrSVID, igrCVID);
		}
		else
		{
			param1 = flowPathEntry.path5.in_l4_src_port;
			param2 = flowPathEntry.path5.in_l4_dst_port;
			param3 = flowPathEntry.path5.in_src_ipv4_addr;
			param4 = flowPathEntry.path5.in_dst_ipv4_addr;
			extraItem = _rtk_fc_sw_flowHashPath5ExtraItem_get(&flowPathEntry.path5, igrSVID, igrCVID);
		}
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_6)			//path 6
	{
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			param1 = flowPathEntry.path6.in_smac_lut_idx;
			param2 = flowPathEntry.path6.in_dmac_lut_idx;

		}else
#endif
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_SA]==DISABLED)
				param1 = flowPathEntry.path6.in_smac_lut_idx;
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_DA]==DISABLED)
				param2 = flowPathEntry.path6.in_dmac_lut_idx;
		}
		param3 = flowPathEntry.path6.in_src_ipv4_addr;
		param4 = flowPathEntry.path6.in_dst_ipv4_addr;
		extraItem = _rtk_fc_sw_flowHashPath6ExtraItem_get(&flowPathEntry.path6, igrSVID, igrCVID);
	}

	flowHashIdx = _rtk_fc_sw_flowHashIndexStep1_get(param1, param2, param3, param4, extraItem);
	if(flowPathEntry.path1.in_multiple_act==1 && (flowPathEntry.path1.in_path==FB_PATH_12 || flowPathEntry.path1.in_path==FB_PATH_34))
		flowHashIdx = _rtk_fc_sw_flowHashIndexStep2_get(flowHashIdx);

	return flowHashIdx;
}

// get hash index by pkthdr (support outer header only)
__IRAM_FC_SHORTCUT
int32 _rtk_fc_flow_hashIndex_byDualPktOuterHdr(rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_tableFlowEntry_t flowPathEntry;
	uint16 igrSVID, igrCVID, lutDaIdx_gmacChk;

	if((pPktHdr->dualHdrType != RTK_FC_DUALTYPE_PPTP) && (pPktHdr->dualHdrType != RTK_FC_DUALTYPE_L2TP) && (pPktHdr->dualHdrType != RTK_FC_DUALTYPE_VXLAN))
	{
		DEBUG("non PPTP/L2TP/VXLAN packet! support PPTP/L2TP passthrough & VXLAN only");
		return FAIL;
	}

	if(pPktHdr->smacL2Idx == FAIL) {
		DEBUG("unknown sa");
		return FAIL;
	}

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(!pPktHdr->isMulticast && pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		return FAIL;
	}
#else
	if(pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		return FAIL;
	}
#endif

	if(pPktHdr->outer_iph == NULL)
	{
		DEBUG("There is no outer IP header info");
		return FAIL;
	}

	lutDaIdx_gmacChk = 0; //only path34 care
	igrSVID = (pPktHdr->svh)?pPktHdr->svlanid:0;
	igrCVID = (pPktHdr->cvh)?pPktHdr->cvlanid:0;
	memset(&flowPathEntry, 0 , sizeof(rtk_fc_tableFlowEntry_t));
	flowPathEntry.path1.in_path = (pPktHdr->dmacToGatewayMAC)?FB_PATH_5:FB_PATH_34;	//dual header: PPTP/L2TP, consider path 3 & 5 only

	if(flowPathEntry.path1.in_path==FB_PATH_5)
	{
		flowPathEntry.path5.in_src_ipv4_addr	= ntohl(pPktHdr->outer_iph->saddr);
		flowPathEntry.path5.in_dst_ipv4_addr	= ntohl(pPktHdr->outer_iph->daddr);
		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP)
		{
			//keep L4 SPORT DPORT to 0
		}
		else
		{
			flowPathEntry.path5.in_l4_src_port		= ntohs(pPktHdr->outer_udph->source);
			flowPathEntry.path5.in_l4_dst_port		= ntohs(pPktHdr->outer_udph->dest);
		}
		flowPathEntry.path5.in_l4proto			= 0;
		flowPathEntry.path5.in_cvlan_pri 		= (pPktHdr->cvh) ? pPktHdr->cvlanpri : 0;
		flowPathEntry.path5.in_tos 				= pPktHdr->outer_iph->tos;
#if 0
		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN)
		{
			flowPathEntry.path5.in_src_ipv4_addr	= ntohl(pPktHdr->iph->saddr);
			flowPathEntry.path5.in_dst_ipv4_addr	= ntohl(pPktHdr->iph->daddr);
			if(pPktHdr->udph)
			{
				flowPathEntry.path5.in_l4_src_port		= ntohs(pPktHdr->udph->source);
				flowPathEntry.path5.in_l4_dst_port		= ntohs(pPktHdr->udph->dest);
				flowPathEntry.path5.in_l4proto = 0;
			}
			else if (pPktHdr->tcph)
			{
				flowPathEntry.path5.in_l4_src_port		= ntohs(pPktHdr->tcph->source);
				flowPathEntry.path5.in_l4_dst_port		= ntohs(pPktHdr->tcph->dest);
				flowPathEntry.path5.in_l4proto = 1;
			}

		}
#endif
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_34)
	{
		flowPathEntry.path3.in_src_ipv4_addr	= ntohl(pPktHdr->outer_iph->saddr);
		flowPathEntry.path3.in_dst_ipv4_addr	= ntohl(pPktHdr->outer_iph->daddr);
		if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP)
		{
			//keep L4 SPORT DPORT to 0
		}
		else
		{
			flowPathEntry.path3.in_l4_src_port		= ntohs(pPktHdr->outer_udph->source);
			flowPathEntry.path3.in_l4_dst_port		= ntohs(pPktHdr->outer_udph->dest);
		}
		flowPathEntry.path3.in_l4proto			= 0;
		flowPathEntry.path3.in_ipv4_or_ipv6		= 0;
		flowPathEntry.path3.in_cvlan_pri 		= (pPktHdr->cvh) ? pPktHdr->cvlanpri : 0;
		flowPathEntry.path3.in_tos 				= pPktHdr->outer_iph->tos;
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			//search dmac index
			if(pPktHdr->dmacL2Idx!=FAIL)
			{
				lutDaIdx_gmacChk = pPktHdr->dmacL2Idx;
			}
			else
			{
				DEBUG("[Path 3] DMAC is not found in lut table.");
				return FAIL;

			}
		}else
#endif
		{
			lutDaIdx_gmacChk = (pPktHdr->dmacToGatewayMAC)?1:0;
		}
	}

	return _rtk_fc_flow_hashIndex(flowPathEntry, igrSVID, igrCVID, lutDaIdx_gmacChk /*used by path3 & path4*/);
}

// get hash index by pkthdr (support inner header only)
__IRAM_FC_SHORTCUT
int32 _rtk_fc_flow_hashIndex_byPktHdr(rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_tableFlowEntry_t flowPathEntry={{{0}}};
	uint16 igrSVID, igrCVID, lutDaIdx_gmacChk;
	uint16 sport = 0, dport = 0;
	bool isL3 = ((pPktHdr->iph) || (pPktHdr->ip6h)) ? TRUE : FALSE;
	bool isL4 = ((pPktHdr->tcph) || (pPktHdr->udph)) ? TRUE : FALSE;		// L4 protocol accelerated by HW
	bool fragFakeTcph = FALSE;
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	bool isMcPassthrough = (!pPktHdr->isMulticast && ((pPktHdr->iph && FLOW_IPV4_MULTICAST_ADDRESS(ntohl(pPktHdr->iph->daddr))) ||(pPktHdr->ip6h && FLOW_IPV6_MULTICAST_ADDRESS(ntohl(pPktHdr->ip6h->daddr.s6_addr32[0])))))?TRUE:FALSE;
#endif

	if(pPktHdr->smacL2Idx == FAIL) {
		DEBUG("unknown sa");
		return FAIL;
	}

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(!pPktHdr->isMulticast && pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		return FAIL;
	}
#else
	if(pPktHdr->dmacL2Idx == FAIL) {
		DEBUG("unknown da");
		return FAIL;
	}
#endif

	lutDaIdx_gmacChk = 0; //only path34 care
	igrSVID = (pPktHdr->svh)?pPktHdr->svlanid:0;
	igrCVID = (pPktHdr->cvh)?pPktHdr->cvlanid:0;
	
	if(isL4) {
		sport= (pPktHdr->tcph) ? ntohs(pPktHdr->tcph->source) : ntohs(pPktHdr->udph->source);
		dport = (pPktHdr->tcph) ? ntohs(pPktHdr->tcph->dest) : ntohs(pPktHdr->udph->dest);
	}
	
	// for second and later fragment packet get correct hash index
	if (pPktHdr->ipFragFlag && !(pPktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG) && (pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_TCP || pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_UDP)) {
		isL4 = TRUE;
		sport = pPktHdr->cacheIpFragInfo.src_port;
		dport = pPktHdr->cacheIpFragInfo.dst_port;
		if (pPktHdr->cacheIpFragInfo.frag_info.protocol == IPPROTO_TCP)
			fragFakeTcph = TRUE;
			
		FRAGMENT("frag with iph id=0x%x, sport=0x%x, dport=0x%x", pPktHdr->cacheIpFragInfo.frag_info.frag_id, sport, dport);
	}
	
	//memset(&flowPathEntry, 0 , sizeof(rtk_fc_tableFlowEntry_t));

	if(pPktHdr->dmacToGatewayMAC && !pPktHdr->isMulticast && isL3)
		flowPathEntry.path1.in_path = FB_PATH_5;
	else if(isL3 && isL4)
	{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
		if(isMcPassthrough)
			flowPathEntry.path1.in_path = FB_PATH_12;
		else
#endif
		if((!pPktHdr->isMulticast && fc_db.controlFuc.bridge_5tuple_flow_accelerate_by_2tuple))
			flowPathEntry.path1.in_path = FB_PATH_12;
		else
			flowPathEntry.path1.in_path = FB_PATH_34;
	}
	else
		flowPathEntry.path1.in_path = FB_PATH_12;

	//support multicast a software hash by path34 when l3 only by hash l4 sport:0 and dport:0
	if(isL3 && isL4 ==0 && pPktHdr->isMulticast)
		flowPathEntry.path1.in_path = FB_PATH_34;

	if(flowPathEntry.path1.in_path==FB_PATH_5)
	{
		flowPathEntry.path5.in_src_ipv4_addr	= (pPktHdr->iph) ? ntohl(pPktHdr->iph->saddr) : pPktHdr->ipv6Sip_hash;
		flowPathEntry.path5.in_dst_ipv4_addr	= (pPktHdr->iph) ? ntohl(pPktHdr->iph->daddr) : pPktHdr->ipv6Dip_hash;
		flowPathEntry.path5.in_l4_src_port		= sport;
		flowPathEntry.path5.in_l4_dst_port		= dport;
		flowPathEntry.path5.in_l4proto			= (pPktHdr->tcph) ? 1:0;
		flowPathEntry.path5.in_cvlan_pri 		= (pPktHdr->cvh) ? pPktHdr->cvlanpri : 0;
		flowPathEntry.path5.in_tos 				= (pPktHdr->iph) ? pPktHdr->iph->tos : (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));

		if (fragFakeTcph)
			flowPathEntry.path5.in_l4proto = 1;
	}
	else if(flowPathEntry.path1.in_path==FB_PATH_34)
	{
		flowPathEntry.path3.in_src_ipv4_addr	= (pPktHdr->iph) ? ntohl(pPktHdr->iph->saddr) : pPktHdr->ipv6Sip_hash;
		flowPathEntry.path3.in_dst_ipv4_addr	= (pPktHdr->iph) ? ntohl(pPktHdr->iph->daddr) : pPktHdr->ipv6Dip_hash;
		flowPathEntry.path3.in_l4_src_port		= sport;
		flowPathEntry.path3.in_l4_dst_port		= dport;
		flowPathEntry.path3.in_l4proto			= (pPktHdr->tcph) ? 1:0;
		flowPathEntry.path3.in_ipv4_or_ipv6		= (pPktHdr->ip6h) ? 1:0;
		flowPathEntry.path3.in_cvlan_pri 		= (pPktHdr->cvh) ? pPktHdr->cvlanpri : 0;
		flowPathEntry.path3.in_tos 				= (pPktHdr->iph) ? pPktHdr->iph->tos : (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));

		if (fragFakeTcph)
			flowPathEntry.path3.in_l4proto = 1;

#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			//search dmac index
			if(pPktHdr->dmacL2Idx!=FAIL)
			{
				lutDaIdx_gmacChk = pPktHdr->dmacL2Idx;
			}
			else
			{
				DEBUG("[Path 3] DMAC is not found in lut table.");
				return FAIL;

			}
		}else
#endif
		{
			lutDaIdx_gmacChk = (pPktHdr->dmacToGatewayMAC)?1:0;
		}
	}
	else
	{
		//FB_PATH_12
		flowPathEntry.path1.in_cvlan_pri = (pPktHdr->cvh) ? pPktHdr->cvlanpri : 0;
		if(isL3) {
			flowPathEntry.path1.in_tos = (pPktHdr->iph) ? pPktHdr->iph->tos : ((pPktHdr->ip6h)?((((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf))):0);
		}
		if(pPktHdr->smacL2Idx!=FAIL)
		{
			flowPathEntry.path1.in_smac_lut_idx = pPktHdr->smacL2Idx;
		}
		else
		{
			DEBUG("[Path 1] SMAC is not found in lut table.");
			return FAIL;

		}
		if(pPktHdr->dmacL2Idx!=FAIL)
		{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)			
			if(pPktHdr->dmacL2Idx==fc_db.bcMacIdx)
				flowPathEntry.path1.in_dmac_lut_idx = HW_BC_IDX;
			else
#endif				
				flowPathEntry.path1.in_dmac_lut_idx = pPktHdr->dmacL2Idx;
		}
		else
		{
			DEBUG("[Path 1] DMAC is not found in lut table.");
			return FAIL;

		}

	}

	return _rtk_fc_flow_hashIndex(flowPathEntry, igrSVID, igrCVID, lutDaIdx_gmacChk /*used by path3 & path4*/);
}

__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_flow_hashIndex_get(rtk_fc_pktHdr_t *pPktHdr, fc_rx_info_t *pRxInfo)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	int32 hashIdx = FAIL;

	TRACE("dual header type = %d", pPktHdr->dualHdrType);

	if((likely((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_NONE) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_IPSEC) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_GRE_ETH_BR)))) {
		/*
		 * single header: check hash idx from rxinfo
		 */
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		if(RXINFO_FBI(pRxInfo)){
			if(unlikely(RXINFO_FB_HASH(pRxInfo) > _rtk_rg_flowHashBuckets_get()))	// prevent hash value was unmatched during switching flow_mode
				ret = RTK_FC_RET_ERR;
			else
				hashIdx = (rgpro_db.fbMode==FB_MODE_4K) ? (RXINFO_FB_HASH(pRxInfo)<<2) : (RXINFO_FB_HASH(pRxInfo));
		}
		else
#endif
			hashIdx = _rtk_fc_flow_hashIndex_byPktHdr(pPktHdr);
	}else {
		/*
		 * dual header: search outer entry first which was saved in netif table
		 */
		uint8 hitPath6 = FALSE;
		uint32 path6HashIdx = 0;
		uint32 i =0;

		for(i=0; i<RTK_FC_TABLESIZE_INTF; i++){
			if(fc_db.netifHwTbl[i].intf.valid==FALSE) continue;
			if(fc_db.netifHwTbl[i].dualType != pPktHdr->dualHdrType) continue;
			if(fc_db.netifHwTbl[i].outerHdrFlowIdx == SIGNED_INVALID) continue;
			TRACE("compare to netif[%d] flow[%d]", i, fc_db.netifHwTbl[i].outerHdrFlowIdx);

			if(_rtk_fc_flow_hitOuterHdrFlowByPktHdr(pPktHdr, fc_db.flowTbl[fc_db.netifHwTbl[i].outerHdrFlowIdx].pFlowEntry) == TRUE){
				hitPath6 = TRUE;
				path6HashIdx = fc_db.netifHwTbl[i].outerHdrFlowIdx;
				break;
			}
		}

		if(hitPath6){
		#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
			if(fc_db.flowTbl[path6HashIdx].candidateState == CANDIDATE_STATE_NEW)
		#else
			if(fc_db.flowTbl[path6HashIdx].pFlowEntry->path6.valid == FALSE)
		#endif
			{
				rtk_fc_ingress_outerHdrPathUpdate(pPktHdr, path6HashIdx);
			}

			// outer header hit: get inner hash from rxInfo, but rxInfo.hashidx should not equal to the path6
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
			if(RXINFO_FBI(pRxInfo)){
				if(RXINFO_FB_HASH(pRxInfo) > _rtk_rg_flowHashBuckets_get())	// prevent hash value was unmatched during switching flow_mode
					ret = RTK_FC_RET_ERR;
				else
					hashIdx = (rgpro_db.fbMode==FB_MODE_4K) ? (RXINFO_FB_HASH(pRxInfo)<<2) : (RXINFO_FB_HASH(pRxInfo));
			}
			else
#endif
				hashIdx = _rtk_fc_flow_hashIndex_byPktHdr(pPktHdr);


			pPktHdr->outerHdrMiss = FALSE;
			TRACE("hit outer header flow path, inner hash index is %d", hashIdx);
		}else{
			//miss outer header to path5, use outerheader to calculate path1~5 hash index
			{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
				if(RXINFO_FBI(pRxInfo)){
					if(unlikely(RXINFO_FB_HASH(pRxInfo) > _rtk_rg_flowHashBuckets_get()))	// prevent hash value was unmatched during switching flow_mode
						ret = RTK_FC_RET_ERR;
					else
						hashIdx = (rgpro_db.fbMode==FB_MODE_4K) ? (RXINFO_FB_HASH(pRxInfo)<<2) : (RXINFO_FB_HASH(pRxInfo));
				}
				else
#endif
					hashIdx = _rtk_fc_flow_hashIndex_byDualPktOuterHdr(pPktHdr);
			}

			pPktHdr->outerHdrMiss = TRUE;
			
			TRACE("miss outer header flow path, recalculate hash index by outer header: %d", hashIdx);
		}

	}

	pPktHdr->flowHashIdx = hashIdx;

	if(unlikely(pPktHdr->flowHashIdx == SIGNED_INVALID)) {
		ret = RTK_FC_RET_ERR;
	}else {
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	// 32K hash value point to 64K entry
	pPktHdr->flowHashIdx <<= fc_db.flowHashWayShift;
#endif
	}
	return ret;
}
#endif
uint8 _rtk_fc_flow_matchOrNot_hw_fields(rtk_fc_tableFlowEntry_t *pFlowEntryCmp, rtk_fc_tableFlowEntry_t *pFlowEntry, uint8 isMulticast)
{
	
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	// valid bit may be FALSE
#else
	if(pFlowEntryCmp->path1.valid==0)
	{
		WARNING("flow invalid!!");
		return FALSE;
	}
#endif

	if(pFlowEntryCmp->path1.in_path!=pFlowEntry->path1.in_path)
		return FALSE;

	if(pFlowEntry->path1.in_path==FB_PATH_12)
	{
		if(pFlowEntryCmp->path1.in_multiple_act!=pFlowEntry->path1.in_multiple_act)
			return FALSE;

		if(pFlowEntry->path1.in_multiple_act==0)		//path 1
		{
			if(pFlowEntryCmp->path1.in_smac_lut_idx!=pFlowEntry->path1.in_smac_lut_idx)
				return FALSE;
			if(pFlowEntryCmp->path1.in_dmac_lut_idx!=pFlowEntry->path1.in_dmac_lut_idx)
				return FALSE;
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_SVID]==DISABLED)
			{
				if(pFlowEntryCmp->path1.in_stagif!=pFlowEntry->path1.in_stagif)
					return FALSE;
				if(pFlowEntryCmp->path1.in_svlan_id!=pFlowEntry->path1.in_svlan_id)
					return FALSE;
			}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
			if(ASICDRIVERVER==0x1)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED)
				{
					if(pFlowEntryCmp->path1.in_ctagif!=pFlowEntry->path1.in_ctagif)
						return FALSE;
					if(pFlowEntryCmp->path1.in_cvlan_id!=pFlowEntry->path1.in_cvlan_id)
						return FALSE;
				}
			}else
#endif
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED
					|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED)
				{
					if(pFlowEntryCmp->path1.in_ctagif!=pFlowEntry->path1.in_ctagif)
						return FALSE;
				}
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED)
				{
					if(pFlowEntryCmp->path1.in_cvlan_id!=pFlowEntry->path1.in_cvlan_id)
						return FALSE;
				}
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED)
				{
					if(pFlowEntryCmp->path1.in_cvlan_pri!=pFlowEntry->path1.in_cvlan_pri)
						return FALSE;
				}
			}
			if(pFlowEntryCmp->path1.in_pppoeif!=pFlowEntry->path1.in_pppoeif)
				return FALSE;
			if(pFlowEntryCmp->path1.in_pppoe_sid_check!=pFlowEntry->path1.in_pppoe_sid_check)
				return FALSE;
			if(pFlowEntry->path1.in_pppoeif && pFlowEntry->path1.in_pppoe_sid_check)
			{
				if(pFlowEntryCmp->path1.in_pppoe_sid!=pFlowEntry->path1.in_pppoe_sid)
					return FALSE;
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_TOS]==ENABLED)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
				{
					if(pFlowEntryCmp->path1.in_tos!=pFlowEntry->path1.in_tos)
						return FALSE;
				}
				else
				{
					if((pFlowEntryCmp->path1.in_tos&0xfc)!=(pFlowEntry->path1.in_tos&0xfc))
						return FALSE;
				}
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL]==ENABLED)
			{
				if(pFlowEntryCmp->path1.in_protocol!=pFlowEntry->path1.in_protocol)
					return FALSE;
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA]==ENABLED)
			{
				if(PATH12_SPA(pFlowEntryCmp->path1.in_spa)!=pFlowEntry->path1.in_spa)
					return FALSE;
				if(pFlowEntryCmp->path1.in_ext_spa!=pFlowEntry->path1.in_ext_spa)
					return FALSE;
			}
			if( fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_STREAM_IDX]==ENABLED
				&& (1<<PATH12_SPA(pFlowEntryCmp->path1.in_spa))&fc_db.wanPortMask.portmask
				&& (1<<pFlowEntry->path1.in_spa)&fc_db.wanPortMask.portmask)
			{
				if(pFlowEntryCmp->path1.in_out_stream_idx!=pFlowEntry->path1.in_out_stream_idx)
					return FALSE;
			}
		}
		else											//path 2
		{
			if(pFlowEntryCmp->path2.in_smac_lut_idx!=pFlowEntry->path2.in_smac_lut_idx)
				return FALSE;
			if(pFlowEntryCmp->path2.in_dmac_lut_idx!=pFlowEntry->path2.in_dmac_lut_idx)
				return FALSE;
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_SVID]==DISABLED)
			{
				if(pFlowEntryCmp->path2.in_stagif!=pFlowEntry->path2.in_stagif)
					return FALSE;
				if(pFlowEntryCmp->path2.in_svlan_id!=pFlowEntry->path2.in_svlan_id)
					return FALSE;
			}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
			if(ASICDRIVERVER==0x1)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED)
				{
					if(pFlowEntryCmp->path2.in_ctagif!=pFlowEntry->path2.in_ctagif)
						return FALSE;
					if(pFlowEntryCmp->path2.in_cvlan_id!=pFlowEntry->path2.in_cvlan_id)
						return FALSE;
				}
			}else
#endif
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED
					|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED)
				{
					if(pFlowEntryCmp->path2.in_ctagif!=pFlowEntry->path2.in_ctagif)
						return FALSE;
				}
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED)
				{
					if(pFlowEntryCmp->path2.in_cvlan_id!=pFlowEntry->path2.in_cvlan_id)
						return FALSE;
				}
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED)
				{
					if(pFlowEntryCmp->path2.in_cvlan_pri!=pFlowEntry->path2.in_cvlan_pri)
						return FALSE;
				}
			}
			if(pFlowEntryCmp->path2.in_pppoeif!=pFlowEntry->path2.in_pppoeif)
				return FALSE;
			if(pFlowEntryCmp->path2.in_pppoe_sid_check!=pFlowEntry->path2.in_pppoe_sid_check)
				return FALSE;
			if(pFlowEntry->path2.in_pppoeif && pFlowEntry->path2.in_pppoe_sid_check)
			{
				if(pFlowEntryCmp->path2.in_pppoe_sid!=pFlowEntry->path2.in_pppoe_sid)
					return FALSE;
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_TOS]==ENABLED)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
				{
					if(pFlowEntryCmp->path2.in_tos!=pFlowEntry->path2.in_tos)
						return FALSE;
				}
				else
				{
					if((pFlowEntryCmp->path2.in_tos&0xfc)!=(pFlowEntry->path2.in_tos&0xfc))
						return FALSE;
				}
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL]==ENABLED)
			{
				if(pFlowEntryCmp->path2.in_protocol!=pFlowEntry->path2.in_protocol)
					return FALSE;
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA]==ENABLED)
			{
				if(PATH12_SPA(pFlowEntryCmp->path2.in_spa)!=pFlowEntry->path2.in_spa)
					return FALSE;
				if(pFlowEntryCmp->path2.in_ext_spa!=pFlowEntry->path2.in_ext_spa)
					return FALSE;
			}
			if( fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_STREAM_IDX]==ENABLED
				&& (1<<PATH12_SPA(pFlowEntryCmp->path2.in_spa))&fc_db.wanPortMask.portmask
				&& (1<<pFlowEntry->path2.in_spa)&fc_db.wanPortMask.portmask)
			{
				if(pFlowEntryCmp->path2.in_stream_idx!=pFlowEntry->path2.in_stream_idx)
					return FALSE;
			}
		}
	}
	else if(pFlowEntry->path1.in_path==FB_PATH_34)
	{
		if(pFlowEntryCmp->path1.in_multiple_act!=pFlowEntry->path1.in_multiple_act)
			return FALSE;

		if(pFlowEntry->path1.in_multiple_act==0)		//path 3
		{
			if(pFlowEntryCmp->path3.in_ipv4_or_ipv6!=pFlowEntry->path3.in_ipv4_or_ipv6)
				return FALSE;
			if(pFlowEntryCmp->path3.in_src_ipv4_addr!=pFlowEntry->path3.in_src_ipv4_addr)
				return FALSE;
			if(pFlowEntryCmp->path3.in_dst_ipv4_addr!=pFlowEntry->path3.in_dst_ipv4_addr)
				return FALSE;
			if(pFlowEntryCmp->path3.in_l4_src_port!=pFlowEntry->path3.in_l4_src_port)
				return FALSE;
			if(pFlowEntryCmp->path3.in_l4_dst_port!=pFlowEntry->path3.in_l4_dst_port)
				return FALSE;
			if(pFlowEntryCmp->path3.in_l4proto!=pFlowEntry->path3.in_l4proto)
				return FALSE;

			if((isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_SVID]==DISABLED)
				|| (!isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_SVID]==DISABLED))
			{
				if(pFlowEntryCmp->path3.in_stagif!=pFlowEntry->path3.in_stagif)
					return FALSE;
			}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
			if(ASICDRIVERVER==0x1)
			{
				if((isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED)
					|| (!isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED))
				{
					if(pFlowEntryCmp->path3.in_ctagif!=pFlowEntry->path3.in_ctagif)
						return FALSE;
				}
			}else
#endif
			{
				if((isMulticast && (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED || fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED))
					|| (!isMulticast && (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED || fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED)))
				{
					if(pFlowEntryCmp->path3.in_ctagif!=pFlowEntry->path3.in_ctagif)
						return FALSE;
				}
				if((isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED)
					|| (!isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED))
				{
					if(pFlowEntryCmp->path3.in_cvlan_pri!=pFlowEntry->path3.in_cvlan_pri)
						return FALSE;
				}
			}
			if(pFlowEntryCmp->path3.in_pppoeif!=pFlowEntry->path3.in_pppoeif)
				return FALSE;
			if(pFlowEntryCmp->path3.in_pppoe_sid_check!=pFlowEntry->path3.in_pppoe_sid_check)
				return FALSE;
			if(pFlowEntry->path3.in_pppoeif && pFlowEntry->path3.in_pppoe_sid_check)
			{
				if(pFlowEntryCmp->path3.in_intf_idx!=pFlowEntry->path3.in_intf_idx)
					return FALSE;
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH34_TOS]==ENABLED)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
				{
					if(pFlowEntryCmp->path3.in_tos!=pFlowEntry->path3.in_tos)
						return FALSE;
				}
				else
				{
					if((pFlowEntryCmp->path3.in_tos&0xfc)!=(pFlowEntry->path3.in_tos&0xfc))
						return FALSE;
				}
			}
		}
		else											//path 4
		{
			if(pFlowEntryCmp->path4.in_ipv4_or_ipv6!=pFlowEntry->path4.in_ipv4_or_ipv6)
				return FALSE;
			if(pFlowEntryCmp->path4.in_src_ipv4_addr!=pFlowEntry->path4.in_src_ipv4_addr)
				return FALSE;
			if(pFlowEntryCmp->path4.in_dst_ipv4_addr!=pFlowEntry->path4.in_dst_ipv4_addr)
				return FALSE;
			if(pFlowEntryCmp->path4.in_l4_src_port!=pFlowEntry->path4.in_l4_src_port)
				return FALSE;
			if(pFlowEntryCmp->path4.in_l4_dst_port!=pFlowEntry->path4.in_l4_dst_port)
				return FALSE;
			if(pFlowEntryCmp->path4.in_l4proto!=pFlowEntry->path4.in_l4proto)
				return FALSE;

			if((isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_SVID]==DISABLED)
				|| (!isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_SVID]==DISABLED))
			{
				if(pFlowEntryCmp->path4.in_stagif!=pFlowEntry->path4.in_stagif)
					return FALSE;
			}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
			if(ASICDRIVERVER==0x1)
			{
				if((isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED)
					|| (!isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED))
				{
					if(pFlowEntryCmp->path4.in_ctagif!=pFlowEntry->path4.in_ctagif)
						return FALSE;
				}
			}else
#endif
			{
				if((isMulticast && (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CVID]==DISABLED || fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED))
					|| (!isMulticast && (fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CVID]==DISABLED || fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED)))
				{
					if(pFlowEntryCmp->path4.in_ctagif!=pFlowEntry->path4.in_ctagif)
						return FALSE;
				}
				if((isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_MC_SKIP_CPRI]==DISABLED)
					|| (!isMulticast && fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH34_UCBC_SKIP_CPRI]==DISABLED))
				{
					if(pFlowEntryCmp->path4.in_cvlan_pri!=pFlowEntry->path4.in_cvlan_pri)
						return FALSE;
				}
			}
			if(pFlowEntryCmp->path4.in_pppoeif!=pFlowEntry->path4.in_pppoeif)
				return FALSE;
			if(pFlowEntryCmp->path4.in_pppoe_sid_check!=pFlowEntry->path4.in_pppoe_sid_check)
				return FALSE;
			if(pFlowEntry->path4.in_pppoeif && pFlowEntry->path4.in_pppoe_sid_check)
			{
				if(pFlowEntryCmp->path4.in_intf_idx!=pFlowEntry->path4.in_intf_idx)
					return FALSE;
			}
			if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH34_TOS]==ENABLED)
			{
				if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
				{
					if(pFlowEntryCmp->path4.in_tos!=pFlowEntry->path4.in_tos)
						return FALSE;
				}
				else
				{
					if((pFlowEntryCmp->path4.in_tos&0xfc)!=(pFlowEntry->path4.in_tos&0xfc))
						return FALSE;
				}
			}
		}
	}
	else if(pFlowEntry->path1.in_path==FB_PATH_5) 		//path 5
	{
		if(pFlowEntryCmp->path5.in_l4_src_port!=pFlowEntry->path5.in_l4_src_port)
			return FALSE;
		if(pFlowEntryCmp->path5.in_l4_dst_port!=pFlowEntry->path5.in_l4_dst_port)
			return FALSE;
		
		if(pFlowEntryCmp->path5.in_src_ipv4_addr!=pFlowEntry->path5.in_src_ipv4_addr)
			return FALSE;
		if(pFlowEntry->path5.in_ipv4_or_ipv6==0 && pFlowEntry->path5.out_l4_act==1 && pFlowEntry->path5.out_l4_direction==0) //naptr
		{
			if(pFlowEntryCmp->path5.in_intf_idx!=pFlowEntry->path5.in_intf_idx)
				return FALSE;
		}
		else //napt, routing
		{
			if(pFlowEntryCmp->path5.in_dst_ipv4_addr!=pFlowEntry->path5.in_dst_ipv4_addr)
				return FALSE;
		}
		
		if(pFlowEntryCmp->path5.in_l4proto!=pFlowEntry->path5.in_l4proto)
			return FALSE;
		if(pFlowEntryCmp->path5.in_ipv4_or_ipv6!=pFlowEntry->path5.in_ipv4_or_ipv6)
			return FALSE;
		if(pFlowEntryCmp->path5.out_l4_act!=pFlowEntry->path5.out_l4_act)	// Routing: 0, NAPT: 1
			return FALSE;
		if(pFlowEntry->path5.out_l4_act)
		{
			if(pFlowEntryCmp->path5.out_l4_direction!=pFlowEntry->path5.out_l4_direction)	// outbound: 1, inbound: 0
				return FALSE;
		}
		
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_SVID]==DISABLED)
		{
			if(pFlowEntryCmp->path5.in_stagif!=pFlowEntry->path5.in_stagif)
				return FALSE;
		}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID]==DISABLED)
			{
				if(pFlowEntryCmp->path5.in_ctagif!=pFlowEntry->path5.in_ctagif)
					return FALSE;
			}
		}else
#endif
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID]==DISABLED
				|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI]==DISABLED)
			{
				if(pFlowEntryCmp->path5.in_ctagif!=pFlowEntry->path5.in_ctagif)
					return FALSE;
			}
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI]==DISABLED)
			{
				if(pFlowEntryCmp->path5.in_cvlan_pri!=pFlowEntry->path5.in_cvlan_pri)
					return FALSE;
			}
		}
		if(pFlowEntryCmp->path5.in_pppoeif!=pFlowEntry->path5.in_pppoeif)
			return FALSE;
		if(pFlowEntry->path5.in_pppoeif)
		{
			if(pFlowEntryCmp->path5.in_intf_idx!=pFlowEntry->path5.in_intf_idx)
				return FALSE;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS]==ENABLED)
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED)
			{
				if(pFlowEntryCmp->path5.in_tos!=pFlowEntry->path5.in_tos)
					return FALSE;
			}
			else
			{
				if((pFlowEntryCmp->path5.in_tos&0xfc)!=(pFlowEntry->path5.in_tos&0xfc))
					return FALSE;
			}
		}
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if(pFlowEntryCmp->path5.out_fmr_idx_act!=pFlowEntry->path5.out_fmr_idx_act)
			return FALSE;
		if(pFlowEntry->path5.out_fmr_idx_act)
		{
			if(pFlowEntryCmp->path5.out_fmr_idx!=pFlowEntry->path5.out_fmr_idx)
				return FALSE;
		}
#endif
	}
	else if(pFlowEntry->path1.in_path==FB_PATH_6) 		//path 6
	{
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SMAC_IDX]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_smac_lut_idx!=pFlowEntry->path6.in_smac_lut_idx)
				return FALSE;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DMAC_IDX]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_dmac_lut_idx!=pFlowEntry->path6.in_dmac_lut_idx)
				return FALSE;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_SVID]==DISABLED)
		{
			if(pFlowEntryCmp->path6.in_stagif!=pFlowEntry->path6.in_stagif)
				return FALSE;
		}
#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
		if(ASICDRIVERVER==0x1)
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED)
			{
				if(pFlowEntryCmp->path6.in_ctagif!=pFlowEntry->path6.in_ctagif)
					return FALSE;
			}
		}else
#endif
		{
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CVID]==DISABLED
				|| fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED)
			{
				if(pFlowEntryCmp->path6.in_ctagif!=pFlowEntry->path6.in_ctagif)
					return FALSE;
			}
			if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH6_SKIP_CPRI]==DISABLED)
			{
				if(pFlowEntryCmp->path6.in_cvlan_pri!=pFlowEntry->path6.in_cvlan_pri)
					return FALSE;
			}
		}
		if(pFlowEntryCmp->path6.in_pppoeif!=pFlowEntry->path6.in_pppoeif)
			return FALSE;
		if(pFlowEntryCmp->path6.in_pppoe_sid_check!=pFlowEntry->path6.in_pppoe_sid_check)
			return FALSE;
		if(pFlowEntry->path6.in_pppoeif && pFlowEntry->path6.in_pppoe_sid_check)
		{
			if(pFlowEntryCmp->path6.in_pppoe_sid!=pFlowEntry->path6.in_pppoe_sid)
				return FALSE;
		}
		if(pFlowEntryCmp->path6.in_dsliteif!=pFlowEntry->path6.in_dsliteif) //check ipv6 or not
			return FALSE;
		if(pFlowEntryCmp->path6.rsvd_in_6rdif!=pFlowEntry->path6.rsvd_in_6rdif) //check 6rd or not
			return FALSE;
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SIP]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_src_ipv4_addr!=pFlowEntry->path6.in_src_ipv4_addr)
				return FALSE;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DIP]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_dst_ipv4_addr!=pFlowEntry->path6.in_dst_ipv4_addr)
				return FALSE;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SPORT]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_l4_src_port!=pFlowEntry->path6.in_l4_src_port)
				return FALSE;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DPORT]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_l4_dst_port!=pFlowEntry->path6.in_l4_dst_port)
				return FALSE;
		}
		if(fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_PROTOCOL]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_protocol!=pFlowEntry->path6.in_protocol)
				return FALSE;
		}
		if(pFlowEntryCmp->path6.in_pptpif!=pFlowEntry->path6.in_pptpif)
			return FALSE;
		if(pFlowEntry->path6.in_pptpif && fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_GRE_CALL_ID]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_gre_call_id!=pFlowEntry->path6.in_gre_call_id)
				return FALSE;
		}
		if(pFlowEntryCmp->path6.in_l2tpif!=pFlowEntry->path6.in_l2tpif)
			return FALSE;
		if(pFlowEntry->path6.in_l2tpif && fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_TUNNEL_ID]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_l2tp_tunnel_id!=pFlowEntry->path6.in_l2tp_tunnel_id)
				return FALSE;
		}
		if(pFlowEntry->path6.in_l2tpif &&fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_SID]==ENABLED)
		{
			if(pFlowEntryCmp->path6.in_l2tp_session_id!=pFlowEntry->path6.in_l2tp_session_id)
				return FALSE;
		}
	}

	return TRUE;
}


/*
 *  flow table entry comparsion
 */
uint32 _rtk_fc_flow_matchOrNot_tblEntry(rtk_fc_tableFlow_t *pFlowCmp, rtk_fc_tableFlow_t *pFlowCur)
{
	rtk_fc_tableFlowEntry_t *pFlowEntryCmp = pFlowCmp->pFlowEntry;
	rtk_fc_tableFlowEntry_t *pFlowEntry = pFlowCur->pFlowEntry;

	/* hardware field checking */
	if(_rtk_fc_flow_matchOrNot_hw_fields(pFlowEntryCmp, pFlowEntry, FLOW_INFO_IS_SET(pFlowCur, FLOW_INFO_MC_ENTRY)) == FALSE)
		goto RET_FALSE;

	/* software field checking */
	{
		if(FLOW_INFO_IS_SET(pFlowCmp, FLOW_INFO_ACL_PRI_FWD) != FLOW_INFO_IS_SET(pFlowCur, FLOW_INFO_ACL_PRI_FWD))
			goto RET_FALSE;
		
		/*TR247 requirement*/
		if(FLOW_INFO_IS_SET(pFlowCmp, FLOW_INFO_SOFTWARE_ONLY) && (pFlowEntryCmp->path3.in_path == FB_PATH_34) &&
			((pFlowCmp->lutIgrSaIdx != pFlowCur->lutIgrSaIdx) || (pFlowCmp->lutEgrDaIdx != pFlowCur->lutEgrDaIdx)))
		{
			goto RET_FALSE;
		}
		
		if((pFlowEntryCmp->path3.in_path == FB_PATH_34) && (pFlowEntryCmp->path3.in_pppoeif) && (pFlowEntryCmp->path3.in_pppoe_sid_check == FALSE))
		{
			//need to compare PPPoE session ID in SW flow field
			if(pFlowCur->pppoe_sid != pFlowCmp->pppoe_sid)
				goto RET_FALSE;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI]==DISABLED)
		{
			//need to compare SVLAN PRI in SW flow field
			if(pFlowCur->svlan_pri != pFlowCmp->svlan_pri)
				goto RET_FALSE;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI]==DISABLED)
		{
			//need to compare SVLAN DEI and CVLAN CFI in SW flow field
			if((pFlowCur->igr_svlan_dei != pFlowCmp->igr_svlan_dei) || (pFlowCur->igr_cvlan_cfi != pFlowCmp->igr_cvlan_cfi))
				goto RET_FALSE;
		}
		if(((pFlowEntryCmp->path3.in_path == FB_PATH_34) || (pFlowEntryCmp->path3.in_path == FB_PATH_5)) && fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX])
		{
			//need to compare pon stream id in SW flow field (Path 12 pon stream id will be checked in _rtk_fc_flow_matchOrNot())
			if(pFlowCur->pon_stream_id != pFlowCmp->pon_stream_id)
				goto RET_FALSE;
		}

		if(pFlowCmp->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT || (pFlowCur->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT))
		{
			// if any one is dual passthrough case, compare them.
			if(pFlowCmp->protoCtrl != FLOW_PROTO_CTRL_DUAL_PT || pFlowCur->protoCtrl != FLOW_PROTO_CTRL_DUAL_PT)	
				goto RET_FALSE;
			
			if(_rtk_fc_flow_extraSwflowPatternCheck(fc_db.dual_pt_flowMapTbl[pFlowCur->dual_pt_flowMapTbl_idx] , pFlowCmp->dual_pt_flowMapTbl_idx)==FALSE)
				goto RET_FALSE;
		}
			
	}
	if(pFlowCmp->igr_stpid_sel != pFlowCur->igr_stpid_sel)
		goto RET_FALSE;

	return TRUE;

RET_FALSE:
	return FALSE;
}


/*
 * pFlowCmp:  to be compared.
 * pFlowEntry: currect flow entry.
 * pIgrExtraInfo: current flow eith extra info for software field comparison.
 */
uint32 _rtk_fc_flow_matchOrNot(rtk_fc_tableFlow_t *pFlowCmp, rtk_fc_tableFlowEntry_t *pFlowEntry, rtk_fc_g3IgrExtraInfo_t *pIgrExtraInfo, uint8 isMulticast)
{
	rtk_fc_tableFlowEntry_t *pFlowEntryCmp = pFlowCmp->pFlowEntry;

	/* hardware field checking */
	if(_rtk_fc_flow_matchOrNot_hw_fields(pFlowEntryCmp, pFlowEntry,isMulticast) == FALSE)
		goto RET_FALSE;

	//skip software field checking
	if(pIgrExtraInfo==NULL)
		return TRUE;

	/* software field checking if possible*/
	if(pIgrExtraInfo)
	{
		if(FLOW_INFO_IS_SET(pFlowCmp, FLOW_INFO_ACL_PRI_FWD) != pIgrExtraInfo->isHitSwFwdedAclTrapPri)
			goto RET_FALSE;

		/*TR247 requirement*/
		if(FLOW_INFO_IS_SET(pFlowCmp, FLOW_INFO_SOFTWARE_ONLY) && (pFlowEntryCmp->path3.in_path == FB_PATH_34) &&
			((pFlowCmp->lutIgrSaIdx != pIgrExtraInfo->lutIgrSaIdx) || (pFlowCmp->lutEgrDaIdx != pIgrExtraInfo->lutEgrDaIdx)))
		{
			goto RET_FALSE;
		}
			
		if((pFlowEntryCmp->path3.in_path == FB_PATH_34) && (pFlowEntryCmp->path3.in_pppoeif) && (pFlowEntryCmp->path3.in_pppoe_sid_check == FALSE))
		{
			//need to compare PPPoE session ID in SW flow field
			if(pIgrExtraInfo->pppoe_session_id != pFlowCmp->pppoe_sid)
				goto RET_FALSE;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI]==DISABLED)
		{
			//need to compare SVLAN PRI in SW flow field
			if(pIgrExtraInfo->svlan_pri != pFlowCmp->svlan_pri)
				goto RET_FALSE;
		}
		if(fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI]==DISABLED)
		{
			//need to compare SVLAN DEI and CVLAN CFI in SW flow field
			if((pIgrExtraInfo->igr_svlan_dei != pFlowCmp->igr_svlan_dei) || (pIgrExtraInfo->igr_cvlan_cfi != pFlowCmp->igr_cvlan_cfi))
				goto RET_FALSE;
		}
		if(((pFlowEntryCmp->path3.in_path == FB_PATH_34) || (pFlowEntryCmp->path3.in_path == FB_PATH_5)) && fc_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH345_STREAM_IDX])
		{
			//need to compare pon stream id in SW flow field (Path 12 pon stream id will be checked in _rtk_fc_flow_matchOrNot())
			if(pIgrExtraInfo->pon_stream_id != pFlowCmp->pon_stream_id)
				goto RET_FALSE;
		}

		if(pFlowCmp->protoCtrl == FLOW_PROTO_CTRL_DUAL_PT || (pIgrExtraInfo->dualPtFlowMapping_info.dual_type != RTK_FC_DUALTYPE_NONE))
		{
			// if any one is dual passthrough case, compare them.
			if(pFlowCmp->protoCtrl != FLOW_PROTO_CTRL_DUAL_PT || pIgrExtraInfo->dualPtFlowMapping_info.dual_type == RTK_FC_DUALTYPE_NONE)	
				goto RET_FALSE;
			
			if(_rtk_fc_flow_extraSwflowPatternCheck(pIgrExtraInfo->dualPtFlowMapping_info, pFlowCmp->dual_pt_flowMapTbl_idx)==FALSE)
				goto RET_FALSE;
		}

		if(pFlowCmp->protoCtrl == FLOW_PROTO_CTRL_L2DUAL )
		{
			if(pIgrExtraInfo->vxlan_info.is_vxlanUS_innerFlow ==1 && FLOW_INFO_IS_SET(pFlowCmp, FLOW_INFO_SOFTWARE_ONLY) )
				goto RET_FALSE;
			if(pIgrExtraInfo->vxlan_info.is_vxlanDS_innerFlow ==1 && FLOW_INFO_IS_SET(pFlowCmp, FLOW_INFO_SOFTWARE_ONLY) )
				goto RET_FALSE;
		}

		if(pIgrExtraInfo->igr_svlan_tpid_sel != pFlowCmp->igr_stpid_sel)
			goto RET_FALSE;

	}


	return TRUE;

RET_FALSE:
	return FALSE;
}


rtk_fc_ret_t rtk_fc_abstrSwflow_freeEntry_get(uint32 *pFlowIdx, uint32 flowHashIdx, uint8 forceGet,rtk_fc_abstrSwFlowPattern_entry_t *swFlowPattern)
{
	uint32 search_index;
	int nearestExpiryTimeFlowIdx=FAIL, longestIdleTimeFlowIdx=FAIL;
	int32 first_invalid=FAIL, flowHitIdx=FAIL, first_dynamic=FAIL; // for multicast forcely replace dynamic flow entry
	unsigned long nearestExpiryTime=0;
	uint32 longestIdleTime=0;
	struct nf_conn *pCT = NULL;
	unsigned long extime = 0;


	if((fc_db.shortcut_flow_count > 0))
	{
		rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;

		if(first_invalid==FAIL)
		{
			if(!list_empty(&fc_db.swFlow_freeListHead))
			{
				list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_freeListHead, flow_list)	//just return the first entry right behind of head
				{
					first_invalid = pFlowEntry->idx;
					break;
				}
			}
		}
		if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)]))
		{
			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)], flow_list)	//just return the first entry right behind of head
			{
				search_index = pFlowEntry->idx;
				if(fc_db.flowTbl[search_index].pAbstrSwFlowEt && memcmp(&fc_db.flowTbl[search_index].pAbstrSwFlowEt->swFlowKey,swFlowPattern,sizeof(rtk_fc_abstrSwFlowPattern_entry_t))==0)
				{
					flowHitIdx = search_index;
					goto RET_CHECK;
				}

				if(first_invalid==FAIL)
				{	
					// if first_invalid has been found, skip LRU to reduce searching time
					if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY)==0)
					{
						if(first_dynamic==FAIL)
							first_dynamic = search_index;

						if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
						{
							if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
							{
								longestIdleTimeFlowIdx = search_index;
								longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
							}
						}
						else 
						{
							pCT = rtk_fc_flow_ct_get(&fc_db.flowTbl[search_index]);
							RTK_FC_HOOK_PS_CT_EXPIRETIME_GET(pCT, &extime);
							if(nearestExpiryTimeFlowIdx==FAIL
								|| (nearestExpiryTimeFlowIdx>=0 && time_before(extime, nearestExpiryTime)))
							{
								nearestExpiryTimeFlowIdx = search_index;
								nearestExpiryTime = extime;
							}
						}
					}
				}
			}
		}
	}

RET_CHECK:
	if(flowHitIdx!=FAIL) //hit flow entry
	{
		*pFlowIdx = flowHitIdx;
		TRACE("Match %s flow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
		return (RTK_FC_RET_ERR_ENTRY_EXIST);
	}
	else				//does not hit any flow entry
	{
		if(first_invalid!=FAIL)
		{
			*pFlowIdx = first_invalid;
			fc_db.flowTbl[*pFlowIdx].pAbstrSwFlowEt= rtk_fc_abstrSwFlowAlloc(swFlowPattern);
			TRACE("Found invalid %s flow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
		}
		else			//does not find any invalid flow entry
		{

			//software lru
			if(longestIdleTimeFlowIdx!=FAIL)
			{
				*pFlowIdx = longestIdleTimeFlowIdx;
				TRACE("Replace longest idle time %s flow[%d], idleTime=%d s", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, longestIdleTime);
				ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
				fc_db.flowTbl[*pFlowIdx].pAbstrSwFlowEt= rtk_fc_abstrSwFlowAlloc(swFlowPattern);
				return (RTK_FC_RET_ERR_FLOW_LRU);
			}
			else if(nearestExpiryTimeFlowIdx!=FAIL)
			{
				*pFlowIdx = nearestExpiryTimeFlowIdx;
				TRACE("Replace nearest expiry time %s flow[%d], expires=%lu, jiffies=%lu", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, nearestExpiryTime, jiffies);
				ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
				fc_db.flowTbl[*pFlowIdx].pAbstrSwFlowEt= rtk_fc_abstrSwFlowAlloc(swFlowPattern);
				return (RTK_FC_RET_ERR_FLOW_LRU);
			}
			else		//does not find any victim flow entry
			{
				if(forceGet && first_dynamic!=FAIL)
				{
					*pFlowIdx = first_dynamic;
					TRACE("Replace first dynamic %s flow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
					ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
					fc_db.flowTbl[*pFlowIdx].pAbstrSwFlowEt= rtk_fc_abstrSwFlowAlloc(swFlowPattern);
					return (RTK_FC_RET_ERR_FLOW_LRU);
				}
				else
				{
					DEBUG("Flow table is full, flowHashIdx=%d", flowHashIdx);
					*pFlowIdx = flowHashIdx;
					return (RTK_FC_RET_ERR_FLOW_FULL);
				}
			}
		}
	}

	return (RTK_FC_RET_OK);
}


rtk_fc_ret_t rtk_fc_abstrHwflow_freeEntry_get(uint32 *pFlowIdx, uint32 flowHashIdx, rtk_fc_tableFlowEntry_t flowPathEntry, uint8 isMulticast, uint8 notTcam, uint8 forceGet)
{

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
		//rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);
	
#else

	uint32 i, search_index;
	int nearestExpiryTimeFlowIdx=FAIL, longestIdleTimeFlowIdx=FAIL;
	int32 first_invalid=FAIL, flowHitIdx=FAIL, first_dynamic=FAIL; // for multicast forcely replace dynamic flow entry
	unsigned long nearestExpiryTime=0;
	uint32 longestIdleTime=0;
	struct nf_conn *pCT = NULL;
	unsigned long extime = 0;


	for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
	{
		search_index = flowHashIdx+i;

		if(fc_db.flowTbl[search_index].pFlowEntry->path1.valid==0)
		{
			if(first_invalid==FAIL && !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock))
				first_invalid = search_index;

			continue;
		}
		
		if(_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[search_index], &flowPathEntry, NULL, isMulticast))
		{
			flowHitIdx = search_index;
			goto RET_CHECK;
		}

		if(first_invalid==FAIL)
		{	// if first_invalid has been found or shortcut count is 0, skip LRU to reduce searching time
			if((forceGet && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY))) ||																/* mc flow is prior to others */
				(!(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY)) &&  !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock)))			/* hwonly(meter) is prior to other uc flows*/
			{
				if(first_dynamic==FAIL)
					first_dynamic = search_index;

				if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
				{
					if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
					{
						longestIdleTimeFlowIdx = search_index;
						longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
					}
				}
			}
		}
	}

	if(rgpro_db.fbMode==FB_MODE_4K && !notTcam)
	{
		rtk_fc_flowTcam_linkList_t *pFlowTcamEntry, *pNextFlowTcamEntry;

		if(first_invalid==FAIL)
		{
			if(!list_empty(&fc_db.flowTcam_freeListHead))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pNextFlowTcamEntry, &fc_db.flowTcam_freeListHead, flowTcam_list)	//just return the first entry right behind of head
				{
					if(!(fc_db.flowTbl[pFlowTcamEntry->idx].pFlowEntry->path1.lock))
					{
						first_invalid = pFlowTcamEntry->idx;
						break;
					}
				}
			}
		}
		if(!list_empty(&fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift]))
		{
			list_for_each_entry_safe(pFlowTcamEntry, pNextFlowTcamEntry, &fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift], flowTcam_list)
			{
				search_index = pFlowTcamEntry->idx;

				if(_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[search_index], &flowPathEntry, NULL, isMulticast))
				{
					flowHitIdx = search_index;
					goto RET_CHECK;
				}

				if(first_invalid==FAIL)
				{	// if first_invalid has been found, skip LRU to reduce searching time
					if((forceGet && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY))) ||																/* mc flow is prior to others */
						(!(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY)) &&  !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock)))			/* hwonly(meter) is prior to other uc flows*/
					{
						if(first_dynamic==FAIL)
							first_dynamic = search_index;

						if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
						{
							if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
							{
								longestIdleTimeFlowIdx = search_index;
								longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
							}
						}
						else {
							pCT = rtk_fc_flow_ct_get(&fc_db.flowTbl[search_index]);
							RTK_FC_HOOK_PS_CT_EXPIRETIME_GET(pCT, &extime);
							if(nearestExpiryTimeFlowIdx==FAIL
								|| (nearestExpiryTimeFlowIdx>=0 && time_before(extime, nearestExpiryTime)))
							{
								nearestExpiryTimeFlowIdx = search_index;
								nearestExpiryTime = extime;
							}
						}
					}
				}
			}
		}
	}




RET_CHECK:
	if(flowHitIdx!=FAIL) //hit flow entry
	{
		*pFlowIdx = flowHitIdx;
		TRACE("Match %s hwflow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
		return (RTK_FC_RET_ERR_ENTRY_EXIST);
	}
	else				//does not hit any flow entry
	{
		if(first_invalid!=FAIL)
		{
			*pFlowIdx = first_invalid;
			TRACE("Found invalid %s hwflow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
		}
		else			//does not find any invalid flow entry
		{
			if(longestIdleTimeFlowIdx!=FAIL)
			{
				*pFlowIdx = longestIdleTimeFlowIdx;
				TRACE("Replace longest idle time %s hwflow[%d], idleTime=%d s", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, longestIdleTime);
				ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
				return (RTK_FC_RET_ERR_FLOW_LRU);
			}
			else if(nearestExpiryTimeFlowIdx!=FAIL)
			{
				*pFlowIdx = nearestExpiryTimeFlowIdx;
				TRACE("Replace nearest expiry time %s hwflow[%d], expires=%lu, jiffies=%lu", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, nearestExpiryTime, jiffies);
				ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
				return (RTK_FC_RET_ERR_FLOW_LRU);
			}
			else		//does not find any victim flow entry
			{
				if(forceGet && first_dynamic!=FAIL)
				{
					*pFlowIdx = first_dynamic;
					TRACE("Replace first dynamic %s hwflow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
					ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
					return (RTK_FC_RET_ERR_FLOW_LRU);
				}
				else
				{
					DEBUG("Flow table is full, hwflowHashIdx=%d", flowHashIdx);
					*pFlowIdx = flowHashIdx;
					return (RTK_FC_RET_ERR_FLOW_FULL);
				}
			}
		}
	}
#endif

	return (RTK_FC_RET_OK);
}





rtk_fc_ret_t _rtk_fc_flow_freeEntry_get(uint32 *pFlowIdx, uint32 flowHashIdx, rtk_fc_tableFlowEntry_t flowPathEntry, uint8 isMulticast, uint8 notTcam, uint8 addHwOnly, uint8 addSwOnly, uint8 forceGet, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, uint8 isHitSwFwdedAclTrapPri)
{
	uint32 i, search_index;
	int nearestExpiryTimeFlowIdx=FAIL, longestIdleTimeFlowIdx=FAIL;
	int32 first_invalid=FAIL, flowHitIdx=FAIL, first_dynamic=FAIL; // for multicast forcely replace dynamic flow entry
	unsigned long nearestExpiryTime=0;
	uint32 longestIdleTime=0;
	struct nf_conn *pCT = NULL;
	unsigned long extime = 0;
#if defined(CONFIG_FC_RTL8277C_SERIES)
	uint32 baseHwFlowIdx = (flowHashIdx & fc_db.flowEntIdxMask) / (RTK_FC_TABLESIZE_HASH_FLOW_MAX/RTK_FC_TABLESIZE_HASH_FLOW);
#else
	uint32 baseHwFlowIdx = flowHashIdx;
#endif


	if(addHwOnly && addSwOnly)
		return (RTK_FC_RET_ERR_INVALID_PARAM);

#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)
	if(addSwOnly) goto SEARCH_SW_FLOW;
#endif

	for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
	{
#if defined(CONFIG_FC_RTL8277C_SERIES)
		/* cache hash only stores crc16[12:0] and cache invalidate only compares crc16[12:0] and slot.
		 * If crc16[12:0] and slot are both 0, and cache_hash_age0_hit_enabled is enabled.
		 * The HW may choose empty entries (all fields are 0) to clear.
		 * Thus, if crc16[12:0] is 0, prevent its slot to be 0.
		 */
		if((i == 0) && fc_db.controlFuc.if_hash_cache_age0_hit && !(flowHashIdx & (0x1fff)))
		{
			TRACE("skip way 0 due to HW issue");
			continue;
		}
#endif
		search_index = baseHwFlowIdx+i;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
		if(fc_db.flowTbl[search_index].candidateState==CANDIDATE_STATE_NONE)
#else
		if(fc_db.flowTbl[search_index].pFlowEntry->path1.valid==0)
#endif
		{
			if(first_invalid==FAIL && !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock))
				first_invalid = search_index;

			continue;
		}
		if(_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[search_index], &flowPathEntry, pG3IgrExtraInfo, isMulticast))
		{
			flowHitIdx = search_index;
			goto RET_CHECK;
		}
		if(first_invalid==FAIL){	// if first_invalid has been found or shortcut count is 0, skip LRU to reduce searching time
			if((forceGet && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY))) ||																/* mc flow is prior to others */
				(addHwOnly && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY)) &&  !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock)))			/* hwonly(meter) is prior to other uc flows*/
			{
				if(first_dynamic==FAIL)
					first_dynamic = search_index;

				if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
				{
					if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
					{
						longestIdleTimeFlowIdx = search_index;
						longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
					}
				}
				else {
					pCT = rtk_fc_flow_ct_get(&fc_db.flowTbl[search_index]);
					RTK_FC_HOOK_PS_CT_EXPIRETIME_GET(pCT, &extime);
					if(nearestExpiryTimeFlowIdx==FAIL
						|| (nearestExpiryTimeFlowIdx>=0 && time_before(extime, nearestExpiryTime)))
					{
						nearestExpiryTimeFlowIdx = search_index;
						nearestExpiryTime = extime;
					}
				}
			}
		}
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	if(rgpro_db.fbMode==FB_MODE_4K && !notTcam)
	{
		rtk_fc_flowTcam_linkList_t *pFlowTcamEntry, *pNextFlowTcamEntry;

		if(first_invalid==FAIL)
		{
			if(!list_empty(&fc_db.flowTcam_freeListHead))
			{
				list_for_each_entry_safe(pFlowTcamEntry, pNextFlowTcamEntry, &fc_db.flowTcam_freeListHead, flowTcam_list)	//just return the first entry right behind of head
				{
					if(!(fc_db.flowTbl[pFlowTcamEntry->idx].pFlowEntry->path1.lock))
					{
						first_invalid = pFlowTcamEntry->idx;
						break;
					}
				}
			}
		}
		if(!list_empty(&fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift]))
		{
			list_for_each_entry_safe(pFlowTcamEntry, pNextFlowTcamEntry, &fc_db.flowTcam_hashListHead[flowHashIdx>>fc_db.flowHashWayShift], flowTcam_list)
			{
				search_index = pFlowTcamEntry->idx;

				if(_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[search_index], &flowPathEntry, pG3IgrExtraInfo, isMulticast))
				{
					flowHitIdx = search_index;
					goto RET_CHECK;
				}
				if(first_invalid==FAIL){	// if first_invalid has been found, skip LRU to reduce searching time
					if((forceGet && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY))) ||																/* mc flow is prior to others */
						(addHwOnly && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY)) &&  !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock)))			/* hwonly(meter) is prior to other uc flows*/
					{
						if(first_dynamic==FAIL)
							first_dynamic = search_index;

						if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
						{
							if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
							{
								longestIdleTimeFlowIdx = search_index;
								longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
							}
						}
						else {
							pCT = rtk_fc_flow_ct_get(&fc_db.flowTbl[search_index]);
							RTK_FC_HOOK_PS_CT_EXPIRETIME_GET(pCT, &extime);
							if(nearestExpiryTimeFlowIdx==FAIL
								|| (nearestExpiryTimeFlowIdx>=0 && time_before(extime, nearestExpiryTime)))
							{
								nearestExpiryTimeFlowIdx = search_index;
								nearestExpiryTime = extime;
							}
						}
					}
				}
			}
		}
	}
#endif

#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	{
		rtk_fc_overFlowHash_linkList_t *pOverFlowEntry=NULL, *pNextOverFlowEntry;
		if(first_invalid==FAIL)
		{
			if(!list_empty(&fc_db.overFlowHash_freeListHead))
			{
				list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_freeListHead, flow_list)	//just return the first entry right behind of head
				{
					first_invalid = pOverFlowEntry->idx;
					break;
				}
			}
		}
		if(!list_empty(&fc_db.overFlowHash_inUseListHead))
		{
			list_for_each_entry_safe(pOverFlowEntry, pNextOverFlowEntry, &fc_db.overFlowHash_inUseListHead, flow_list)
			{
				search_index = pOverFlowEntry->idx;

				if(_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[search_index], &flowPathEntry, pG3IgrExtraInfo, isMulticast))
				{
					flowHitIdx = search_index;
					goto RET_CHECK;
				}
				if(first_invalid==FAIL){	// if first_invalid has been found, skip LRU to reduce searching time
					if((forceGet && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY))) ||																/* mc flow is prior to others */
						(addHwOnly && !(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY)) &&	!(fc_db.flowTbl[search_index].pFlowEntry->path1.lock))) 		/* hwonly(meter) is prior to other uc flows*/
					{
						if(first_dynamic==FAIL)
							first_dynamic = search_index;

						if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
						{
							if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
							{
								longestIdleTimeFlowIdx = search_index;
								longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
							}
						}
						else {
							pCT = rtk_fc_flow_ct_get(&fc_db.flowTbl[search_index]);
							RTK_FC_HOOK_PS_CT_EXPIRETIME_GET(pCT, &extime);
							if(nearestExpiryTimeFlowIdx==FAIL
								|| (nearestExpiryTimeFlowIdx>=0 && time_before(extime, nearestExpiryTime)))
							{
								nearestExpiryTimeFlowIdx = search_index;
								nearestExpiryTime = extime;
							}
						}
					}
				}
			}
		}
	}
#endif

	if(addHwOnly && (first_invalid==FAIL) && (longestIdleTimeFlowIdx==FAIL) && (nearestExpiryTimeFlowIdx==FAIL)){
		WARNING("Flow belongs to HwOnly but no any flow could be replaced, so we add to sw, flowHashIdx = %d", flowHashIdx);
		addHwOnly = FALSE;
	}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)  || defined(CONFIG_FC_RTL8277C_SERIES)
SEARCH_SW_FLOW:
#endif
	if((fc_db.shortcut_flow_count > 0) && (!addHwOnly))
	{
		rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;

		if(first_invalid==FAIL)
		{
			if(!list_empty(&fc_db.swFlow_freeListHead))
			{
				list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_freeListHead, flow_list)	//just return the first entry right behind of head
				{
					first_invalid = pFlowEntry->idx;
					break;
				}
			}
		}

		if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)]))
		{
			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)], flow_list)	//just return the first entry right behind of head
			{
				search_index = pFlowEntry->idx;

				if(_rtk_fc_flow_matchOrNot(&fc_db.flowTbl[search_index], &flowPathEntry, pG3IgrExtraInfo, isMulticast))
				{
					flowHitIdx = search_index;
					goto RET_CHECK;				
				}
				if(first_invalid==FAIL){	// if first_invalid has been found, skip LRU to reduce searching time
					if((FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_STATIC_ENTRY))==0 && !(fc_db.flowTbl[search_index].pFlowEntry->path1.lock))
					{
						if(first_dynamic==FAIL)
							first_dynamic = search_index;

						if(FLOW_INFO_IS_SET(&fc_db.flowTbl[search_index], FLOW_INFO_SKIP_CT))
						{
							if(fc_db.flowTbl[search_index].idleSecs>=longestIdleTime)
							{
								longestIdleTimeFlowIdx = search_index;
								longestIdleTime = fc_db.flowTbl[search_index].idleSecs;
							}
						}
						else {
							pCT = rtk_fc_flow_ct_get(&fc_db.flowTbl[search_index]);
							RTK_FC_HOOK_PS_CT_EXPIRETIME_GET(pCT, &extime);
							if(nearestExpiryTimeFlowIdx==FAIL
								|| (nearestExpiryTimeFlowIdx>=0 && time_before(extime, nearestExpiryTime)))
							{
								nearestExpiryTimeFlowIdx = search_index;
								nearestExpiryTime = extime;
							}
						}
					}
				}
			}
		}
	}


RET_CHECK:
	if(flowHitIdx!=FAIL) //hit flow entry
	{
		*pFlowIdx = flowHitIdx;
		TRACE("Match %s flow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
		return (RTK_FC_RET_ERR_ENTRY_EXIST);
	}
	else				//does not hit any flow entry
	{
		if(first_invalid!=FAIL)
		{
			*pFlowIdx = first_invalid;
			TRACE("Found invalid %s flow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
		}
		else			//does not find any invalid flow entry
		{
			if(longestIdleTimeFlowIdx!=FAIL)
			{
				*pFlowIdx = longestIdleTimeFlowIdx;
				TRACE("Replace longest idle time %s flow[%d], idleTime=%d s", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, longestIdleTime);
				ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
				return (RTK_FC_RET_ERR_FLOW_LRU);
			}
			else if(nearestExpiryTimeFlowIdx!=FAIL)
			{
				*pFlowIdx = nearestExpiryTimeFlowIdx;
				TRACE("Replace nearest expiry time %s flow[%d], expires=%lu, jiffies=%lu", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx, nearestExpiryTime, jiffies);
				ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
				return (RTK_FC_RET_ERR_FLOW_LRU);
			}
			else		//does not find any victim flow entry
			{
				if(forceGet && first_dynamic!=FAIL)
				{
					*pFlowIdx = first_dynamic;
					TRACE("Replace first dynamic %s flow[%d]", (*pFlowIdx<fc_db.flowHwTableSize)?"Hw":"Sw", *pFlowIdx);
					ASSERT_EQ(rtk_fc_flow_delete(*pFlowIdx), RTK_FC_RET_OK);
					return (RTK_FC_RET_ERR_FLOW_LRU);
				}
				else
				{
					DEBUG("Flow table is full, flowHashIdx=%d", flowHashIdx);
					*pFlowIdx = FAILED;
					return (RTK_FC_RET_ERR_FLOW_FULL);
				}
			}
		}
	}

	return (RTK_FC_RET_OK);
}

rtk_fc_ret_t _rtk_fc_flow_chenkingTime_set(uint32 flowSyncPeriod)
{

	fc_db.flowSyncPeriod_unit1s = flowSyncPeriod;

	return RTK_FC_RET_OK;
}


__IRAM_FC_SHORTCUT
static void _rtk_fc_pkthdr_dualTranslation(rtk_fc_pktHdr_t *pPktHdr)
{
	if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP){
		if(pPktHdr->iph){
			pPktHdr->outer_iph = &(*pPktHdr->iph);
			pPktHdr->iph = NULL;
		}
		if(pPktHdr->ip6h){
			pPktHdr->outer_ip6h = &(*pPktHdr->ip6h);
			pPktHdr->outer_ipv6Sip_hash = pPktHdr->ipv6Sip_hash;
			pPktHdr->outer_ipv6Dip_hash = pPktHdr->ipv6Dip_hash;
			pPktHdr->ip6h = NULL;
		}
	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_L2TP){
		pPktHdr->outer_iph = &(*pPktHdr->iph);
		pPktHdr->iph = NULL;
		pPktHdr->outer_udph = &(*pPktHdr->udph);
		pPktHdr->udph = NULL;
	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE){
		//none
	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_6RD){
		pPktHdr->outer_iph = &(*pPktHdr->iph);
		pPktHdr->iph = NULL;
	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN){
		pPktHdr->outer_eth = &(*pPktHdr->eth);
		pPktHdr->eth = NULL;
		if(pPktHdr->svh){
			pPktHdr->outer_svh = &(*pPktHdr->svh);
			pPktHdr->outer_svlanid = pPktHdr->svlanid;
			pPktHdr->outer_svlandei = pPktHdr->svlandei;
			pPktHdr->outer_svh = &(*pPktHdr->svh);
			pPktHdr->svh = NULL;
		}
		if(pPktHdr->cvh){
			pPktHdr->outer_cvh = &(*pPktHdr->cvh);
			pPktHdr->outer_cvlanid = pPktHdr->cvlanid;
			pPktHdr->outer_cvlancfi = pPktHdr->cvlancfi;
			pPktHdr->outer_cvh = &(*pPktHdr->cvh);
			pPktHdr->cvh = NULL;
		}
		if(pPktHdr->ppph){
			pPktHdr->outer_ppph = &(*pPktHdr->ppph);
			pPktHdr->ppph = NULL;
		}
		if(pPktHdr->iph){
			pPktHdr->outer_iph = &(*pPktHdr->iph);
			pPktHdr->iph = NULL;
		}
		if(pPktHdr->ip6h){
			pPktHdr->outer_ip6h = &(*pPktHdr->ip6h);
			pPktHdr->outer_ipv6Sip_hash = pPktHdr->ipv6Sip_hash;
			pPktHdr->outer_ipv6Dip_hash = pPktHdr->ipv6Dip_hash;
			pPktHdr->ip6h = NULL;
		}
		if(pPktHdr->udph)
		{
			pPktHdr->outer_udph = &(*pPktHdr->udph);
			pPktHdr->udph = NULL;
		}

		pPktHdr->outer_smacL2Idx = pPktHdr->smacL2Idx;
		pPktHdr->smacL2Idx = SIGNED_INVALID;

	}
	else if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_GRE_ETH_BR){
		pPktHdr->outer_eth = &(*pPktHdr->eth);
		pPktHdr->eth = NULL;
		if(pPktHdr->svh){
			pPktHdr->outer_svh = &(*pPktHdr->svh);
			pPktHdr->svh = NULL;
		}
		if(pPktHdr->cvh){
			pPktHdr->outer_cvh = &(*pPktHdr->cvh);
			pPktHdr->cvh = NULL;
		}
		if(pPktHdr->ppph){
			pPktHdr->outer_ppph = &(*pPktHdr->ppph);
			pPktHdr->ppph = NULL;
		}
		if(pPktHdr->iph){
			pPktHdr->outer_iph = &(*pPktHdr->iph);
			pPktHdr->iph = NULL;
		}
	}
}
__IRAM_FC_SHORTCUT
static void _rtk_fc_pkthdr_vlanFromSKBMark_remarkingProcess(struct rt_skbuff *rtskb,
																		 rtk_fc_pktHdr_t *pPktHdr, 
                                           							     bool cvlan, 
																	     bool tag, 
																		 struct vlan_hdr * original_vlan_hdr, 
																		 unsigned short ori_vlan_id, 
																		 unsigned short ori_vlan_pri)
{
	uint32 vlan_TCI = 0;

	TRACE("cvlan %d, tag %d, ori_vlan hdr:%p, ori vlanid %d, ori vlan pri %d\n",cvlan, tag, original_vlan_hdr, ori_vlan_id, ori_vlan_pri);
	if(cvlan)
	{	
		
        //---------------------------------------------
		// Get CVID:
		// if not set in skb mark : get original cvid
		// if is set in skb mark  : get from skb->mark		
		//---------------------------------------------
		if( fc_db.skbmark[RTK_FC_SKBMARK_CVLAN_ID].startBit != FAILED ) //CVID is set
			pPktHdr->cvlanid = rtk_fc_egress_skbMarkSetting(rtskb, RTK_FC_SKBMARK_CVLAN_ID);
		else
			pPktHdr->cvlanid = ori_vlan_id;

		//---------------------------------------------
		// Get CPRI:
		// if not set in skb mark : get original cpri
		// if is set in skb mark  : get from skb->mark
		//---------------------------------------------
		if( fc_db.skbmark[RTK_FC_SKBMARK_CVLAN_PRI].startBit != FAILED )
			pPktHdr->cvlanpri = rtk_fc_egress_skbMarkSetting(rtskb, RTK_FC_SKBMARK_CVLAN_PRI);
		else
			pPktHdr->cvlanpri = ori_vlan_pri;
		TRACE("Info from skb mark, cvlan id: %d , cvlan pri: %d",pPktHdr->cvlanid, pPktHdr->cvlanpri);
		//---------------------------------------------
		// CVLAN vid and pri are not set in the same time:
		// cvh need to use original cvh pointer
		//---------------------------------------------
		if(fc_db.skbmark[RTK_FC_SKBMARK_CVLAN_ID].startBit == FAILED)
		{
			if(tag && fc_db.skbmark[RTK_FC_SKBMARK_CVLAN_PRI].startBit == FAILED )
				pPktHdr->cvh = original_vlan_hdr;
			else if(tag)
				goto CREATE_NEW_CVH;
			else if(!tag){
				DEBUG("[Untag][Replace] Not set vid in skbmark, wrong operation!");
				pPktHdr->cvh = NULL;
			}
		}
		else
		{
CREATE_NEW_CVH:

			//---------------------------------------------
			//Use new cvid and new cpri to create new cvh
			//---------------------------------------------
			vlan_TCI = pPktHdr->cvlanid;
			vlan_TCI |= (pPktHdr->cvlanpri<<13)&0xf000;
			DEBUG("Create new cvlan header, cvlan id: %d , cvlan pri: %d",pPktHdr->cvlanid, pPktHdr->cvlanpri);

			memset(&fc_db.cvh_from_skbmark,0,sizeof(struct vlan_hdr));
			fc_db.cvh_from_skbmark.h_vlan_TCI = htons(vlan_TCI);

			pPktHdr->cvh = &fc_db.cvh_from_skbmark;
		}
		
	}
	else
	{
		//---------------------------------------------
		// Get SVID:
		// if not set in skb mark : get original svid
		// if is set in skb mark  : get from skb->mark		
		//---------------------------------------------
		if( fc_db.skbmark[RTK_FC_SKBMARK_SVLAN_ID].startBit != FAILED )
			pPktHdr->svlanid = rtk_fc_egress_skbMarkSetting(rtskb, RTK_FC_SKBMARK_SVLAN_ID);
		else
			pPktHdr->svlanid = ori_vlan_id;

		//---------------------------------------------
		// Get SPRI:
		// if not set in skb mark : get original spri
		// if is set in skb mark  : get from skb->mark
		//---------------------------------------------
		if( fc_db.skbmark[RTK_FC_SKBMARK_SVLAN_PRI].startBit != FAILED )
			pPktHdr->svlanpri = rtk_fc_egress_skbMarkSetting(rtskb, RTK_FC_SKBMARK_SVLAN_PRI);
		else
			pPktHdr->svlanpri = ori_vlan_pri;
		TRACE("Info from skb mark, svlan id: %d , svlan pri: %d",pPktHdr->svlanid, pPktHdr->svlanpri);
		//---------------------------------------------
		// SVLAN vid and pri are not set in the same time:
		// svh need to use original svh pointer
		//---------------------------------------------
		if(fc_db.skbmark[RTK_FC_SKBMARK_SVLAN_ID].startBit == FAILED)
		{
			if(tag && fc_db.skbmark[RTK_FC_SKBMARK_SVLAN_PRI].startBit == FAILED )
				pPktHdr->svh = original_vlan_hdr;
			else if(tag)
				goto CREATE_NEW_SVH;
			else if(!tag)
				pPktHdr->svh = NULL;
		}
		else
		{
CREATE_NEW_SVH:
			
			//---------------------------------------------
			//Use new svid and new spri to create new svh
			//---------------------------------------------
			vlan_TCI = pPktHdr->svlanid;
			vlan_TCI |= (pPktHdr->svlanpri<<13)&0xf000;

			DEBUG("Create new svlan header, svlan id: %d , svlan pri: %d",pPktHdr->svlanid, pPktHdr->svlanpri);
			memset(&fc_db.svh_from_skbmark,0,sizeof(struct vlan_hdr));
			fc_db.svh_from_skbmark.h_vlan_TCI = htons(vlan_TCI);
			
			if(fc_db.skbmark[RTK_FC_SKBMARK_SVLAN_TPID].startBit == FAILED)
				pPktHdr->stpid_sel = 0;
			else
			{
				int SVLAN_TPID_SELECTION = 0;
				//---------------------------------------------
				// svlan tpid from skb->mark: 1 bit
				// 0: Use fc_db.systemGlobal.stagTPID[0]
				// 1: Replace to  fc_db.systemGlobal.stagTPID[1]
				//
				//---------------------------------------------
				SVLAN_TPID_SELECTION = rtk_fc_egress_skbMarkSetting(rtskb, RTK_FC_SKBMARK_SVLAN_TPID);

				//---------------------------------------------
				// Keep selection value in packet header for 
				// later flow add decision
				//---------------------------------------------
				pPktHdr->remarkDec.svlan_tpid_from_skbmark = SVLAN_TPID_SELECTION;
				
				if(SVLAN_TPID_SELECTION==1)
				{
					//---------------------------------------------
					// Should Skip learning
					// Should not learning to hw flow because l34 switch can't process.
					// But GMAC can. -> SW flow only
					//---------------------------------------------
					TRACE("TPID selection doesn't use FC default tpid, so only learn at sw-flow in later!");
					pPktHdr->stpid_sel = 1;
				}else
					pPktHdr->stpid_sel = 0;
			}
				

			pPktHdr->svh = &fc_db.svh_from_skbmark;

		}
		
	}
}


rtk_fc_ret_t _rtk_fc_macLrn_limit_check(int isIgr, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_ret_t limit_ret=RTK_FC_RET_OK;
	unsigned char *pSmac;
	unsigned int SIP=0;
	struct in6_addr *pSIPv6=NULL;
	unsigned int ingressMAcPort = pPktHdr->ingressPort.macPortIdx;
	int wlanDevIdx;
	if(isIgr){
		pSmac=pPktHdr->eth->h_source;
		wlanDevIdx=pPktHdr->igrWlanDevIdx;
		if(pPktHdr->iph){
			SIP=pPktHdr->iph->saddr;
		}else if(pPktHdr->ip6h){
			pSIPv6=&pPktHdr->ip6h->saddr;
		}
	}else{
		pSmac=RTSKB_FCIGRDATA(rtskb)->sa;
		wlanDevIdx=RTSKB_FCIGRDATA(rtskb)->wlan_dev_idx;
		if(RTSKB_FCIGRDATA(rtskb)->ingressTagif&IPV4_TAGIF){
			SIP=htonl(RTSKB_FCIGRDATA(rtskb)->srcIp);
		}
	}

	//Check per port SA learning limit
	limit_ret=rtk_fc_macAddr_portGroup_lrnCnt_check(ingressMAcPort);
	
	if((RTK_FC_ALL_MAC_CPU_PORTMASK&(0x1<<ingressMAcPort))
		&& wlanDevIdx!=RTK_FC_WLANX_NOT_FOUND)
	{
		if(fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningLimit_conf.learningLimitNumber>=0
			&& fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningLimit_conf.learningLimitNumber<=atomic_read(&fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningCount))
		{
			TRACE("[DROP] wlan_dev_idx(%d) learning limit is reached(%d)", wlanDevIdx, fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningLimit_conf.learningLimitNumber);
			limit_ret=RTK_FC_RET_DROP_WIFILEARNING_LIMIT;
		}
	}
	//error printk for syslogd
	if(limit_ret == RTK_FC_RET_DROP_PORTLEARNING_LIMIT){
		if(SIP)
			pr_err_ratelimited("[Error][WarnLog] Port %d SMAC learning limit is reached(%d) and dropped. SMAC:%pM SIP:%pI4\n",ingressMAcPort,fc_db.macAddrLearningLimit[ingressMAcPort].learningLimit_conf.learningLimitNumber,pSmac,&SIP);
		else if(pSIPv6)
			pr_err_ratelimited("[Error][WarnLog] Port %d SMAC learning limit is reached(%d) and dropped. SMAC:%pM SIP:%pI6\n",ingressMAcPort,fc_db.macAddrLearningLimit[ingressMAcPort].learningLimit_conf.learningLimitNumber,pSmac,pSIPv6);
		else
			pr_err_ratelimited("[Error][WarnLog] Port %d SMAC learning limit is reached(%d) and dropped. SMAC:%pM\n",ingressMAcPort,fc_db.macAddrLearningLimit[ingressMAcPort].learningLimit_conf.learningLimitNumber,pSmac);
		return limit_ret;
	}else if(limit_ret == RTK_FC_RET_DROP_GROUPLEARNING_LIMIT){
		if(SIP)
			pr_err_ratelimited("[Error][WarnLog] Group SMAC learning limit is reached(%d), dropped at port[%d]. SMAC:%pM SIP:%pI4\n",fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber,ingressMAcPort,pSmac,&SIP);
		else if(pSIPv6)
			pr_err_ratelimited("[Error][WarnLog] Group SMAC learning limit is reached(%d), dropped at port[%d]. SMAC:%pM SIP:%pI6\n",fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber,ingressMAcPort,pSmac,pSIPv6);
		else
			pr_err_ratelimited("[Error][WarnLog] Group SMAC learning limit is reached(%d), dropped at port[%d]. SMAC:%pM\n",fc_db.macAddr_portGroup.limitCfg.learningLimit_conf.learningLimitNumber,ingressMAcPort,pSmac);
		return limit_ret;
	}else if(limit_ret == RTK_FC_RET_DROP_WIFILEARNING_LIMIT){
		if(SIP)
			pr_err_ratelimited("[Error][WarnLog] WlanDev %d SMAC learning limit is reached(%d) and dropped. SMAC:%pM SIP:%pI4\n",wlanDevIdx,fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningLimit_conf.learningLimitNumber,pSmac,&SIP);
		else if(pSIPv6)
			pr_err_ratelimited("[Error][WarnLog] WlanDev %d SMAC learning limit is reached(%d) and dropped. SMAC:%pM SIP:%pI6\n",wlanDevIdx,fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningLimit_conf.learningLimitNumber,pSmac,pSIPv6);
		else
			pr_err_ratelimited("[Error][WarnLog] WlanDev %d SMAC learning limit is reached(%d) and dropped. SMAC:%pM\n",wlanDevIdx,fc_db.wlanMacAddrLearningLimit[wlanDevIdx].learningLimit_conf.learningLimitNumber,pSmac);
		return limit_ret;
	}
	return limit_ret;

}
rtk_fc_ret_t _rtk_fc_vlanGroupMacLimit_check(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	int limit_ret=RTK_FC_RET_OK;
	int ctagVid=pPktHdr->cvh?pPktHdr->cvlanid:-1;
	uint32 vlanMacGroupIdx;
	rtk_fc_vlanGroupMacLimit_mac_t *pMac,*pNextMac;
	int l2Hash = 0, matchMac=0;

	l2Hash = _rtk_fc_hash_mac_fid(pPktHdr->eth->h_source, DEFAULT_FID);
	//l2Hash = l2Idx<<RTK_FC_LUT_HASH_WAY_SHIFT;

	//check if any MAC-equal entries exist, delete them all for port-moving
	if(!list_empty(&fc_db.vlanGroupMACLimit_macHead[l2Hash]))
	{
		list_for_each_entry_safe(pMac, pNextMac, &fc_db.vlanGroupMACLimit_macHead[l2Hash], mac_list)
		{
			//check port-moving
			if(!memcmp(pMac->mac.octet,pPktHdr->eth->h_source,ETHER_ADDR_LEN))
			{
				if(pMac->pGroup && pMac->pGroup->group_info.port!=pPktHdr->ingressPort.macPortIdx)
				{
					//WARNING("[VGLIMIT] port-moving..delete MAC vlan %d",pMac->vlanId);
					atomic_dec(&pMac->pGroup->group_info.mac_count);
					list_del(&pMac->group_list);
					list_del(&pMac->mac_list);
					RTK_FC_HELPER_FC_KFREE(pMac, sizeof(rtk_fc_vlanGroupMacLimit_mac_t));
				}
				else if(pMac->vlanId==ctagVid)
				{
					//match, just return
					DEBUG("[VLANGRP LIMIT] match exist MAC.");
					matchMac=1;
				}
			}
		}
	}
	limit_ret=rtk_fc_vlanGroupLrnLimit_find(pPktHdr->ingressPort.macPortIdx, ctagVid, &vlanMacGroupIdx);
	if(limit_ret==RT_ERR_RG_OK)
	{
		//group found, now check limit and check if the mac had already been learned.
		DEBUG("[VLANGRP LIMIT] the vlanMacGroup index is %d",vlanMacGroupIdx);
		if(!matchMac)
		{
			//check limit, create new MAC if avalable
			if(atomic_read(&fc_db.vlanGroupMACLimit_group[vlanMacGroupIdx].group_info.mac_count)< fc_db.vlanGroupMACLimit_group[vlanMacGroupIdx].group_info.mac_limit_number)
			{
				pMac=RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_vlanGroupMacLimit_mac_t), GFP_ATOMIC);
				if(pMac)
				{
					//DEBUG("[VGLIMIT] create new mac for group[%d]",vlanMacGroupIdx);
					memcpy(pMac->mac.octet,pPktHdr->eth->h_source, ETH_ALEN);
					if(pPktHdr->cvh)
						pMac->vlanId=pPktHdr->cvlanid;
					else
						pMac->vlanId=-1;
					list_add_tail(&pMac->mac_list, &fc_db.vlanGroupMACLimit_macHead[l2Hash]);
					atomic_inc(&fc_db.vlanGroupMACLimit_group[vlanMacGroupIdx].group_info.mac_count);
					pMac->pGroup=&fc_db.vlanGroupMACLimit_group[vlanMacGroupIdx];
					list_add_tail(&pMac->group_list, &fc_db.vlanGroupMACLimit_group[vlanMacGroupIdx].mac_head);
				}
				else
				{
					DEBUG("[VGLIMIT] no memory..drop packet.");
					return RTK_FC_RET_DROP_NO_MEMORY;
				}
			}
			else
			{
				DEBUG("[VGLIMIT] the group is full..drop packet.");
				return RTK_FC_RET_DROP_VLANGROUPLEARNING_LIMIT;
			}
		}
	}

	return RTK_FC_RET_OK;
}


																		 
__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_lut_learning_processing(struct rt_skbuff *rtskb, int egressPortMask, rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	int16 l2Idx;
	uint8 isIgr = (egressPortMask==0) ? TRUE : FALSE;
	
#if defined(CONFIG_RTK_L34_G3_PLATFORM) && !defined(CONFIG_FC_G3_G3LITE_SERIES)
	if(unlikely(!isIgr)) {
		if((egressPortMask&(1<<RTK_FC_MAC_PORT_PON)) && 
			(pPktHdr->remarkDec.streamId_en) && 
			(fc_db.streamidTbl[pPktHdr->remarkDec.streamId].valid==FALSE)) {

			TRACE("invalid streamid %d, Drop packet!", pPktHdr->remarkDec.streamId);
			return RTK_FC_RET_DROP_INVALID_STREAMID;
		}
	}
#endif

	if(pPktHdr->smacL2Idx != SIGNED_INVALID)
	{
		/*	1. record smac lut index.
		*	2. check port moving or not
		*/
		l2Idx = pPktHdr->smacL2Idx;

		if(isIgr)
		{
			if(fc_db.lutTbl[pPktHdr->smacL2Idx]) 
				fc_db.lutTbl[pPktHdr->smacL2Idx]->last_jiffies = jiffies;
			
#if defined(CONFIG_RTK_SOC_RTL8198D) || defined(CONFIG_FC_RTL8198F_SERIES) || defined(CONFIG_RTL8198X_SERIES)
			if (pPktHdr->iph && rtk_fc_sip_is_default_gateway(pPktHdr->iph->saddr)) {
				TRACE("skip portmoving check with sip=%pI4", &pPktHdr->iph->saddr);
			}
			else
#endif
			{
				ret = _rtk_fc_lut_portmoving_check(l2Idx, pPktHdr->ingressPort, pPktHdr->igrWlanDevIdx, pPktHdr->cvlanid);
				if(ret ==RTK_FC_RET_DROP || ret == RTK_FC_RET_LRN_SKIP_UNKNOWNSA)
					return ret;
				if(ret!=RTK_FC_RET_OK)
					pPktHdr->smacL2Idx = SIGNED_INVALID;

				
			}
		}
		else
		{
			//keep permission from sa
			if(fc_db.lutTbl[l2Idx]->isStatic)
				pPktHdr->isPermitWanAccess=1;
			else
				pPktHdr->isPermitWanAccess=fc_db.lutTbl[l2Idx]->isPermitWanAccess;

		}
	}
	else
	{
		ret = _rtk_fc_macLrn_limit_check(isIgr, rtskb, pPktHdr);
		if(ret != RTK_FC_RET_OK)
		{
			DEBUG("[macLrn_limit]Mac learning limit check failed, ret = 0x%x",ret);
			return ret;
		}

		ret = _rtk_fc_vlanGroupMacLimit_check(rtskb, pPktHdr);
		if(ret != RTK_FC_RET_OK)
		{
			DEBUG("[vlanGroupMacLimit]vlan group mac learning limit check failed, ret = 0x%x",ret);
			return ret;
		}

		if(isIgr)
		{
			if(unlikely(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN && pPktHdr->outer_eth!=NULL && pPktHdr->outer_smacL2Idx == SIGNED_INVALID))
			{
				uint16 outer_cvid = 0;
				if(pPktHdr->outer_cvh)
					outer_cvid = (ntohs(pPktHdr->outer_cvh->h_vlan_TCI)&VLAN_VID_MASK);

				RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH_IRQ_PROTECT();
				ret = _rtk_fc_lut_learning(pPktHdr->outer_eth->h_source,pPktHdr->ingressPort, outer_cvid,
								pPktHdr->igrWlanDevIdx, FALSE, TRUE, &pPktHdr->outer_smacL2Idx);
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH_IRQ_PROTECT();
			}
			if(unlikely((pPktHdr->smacL2Idx == SIGNED_INVALID) && !(fc_db.controlFuc.l2_macEgrLearning & (1<<pPktHdr->ingressPort.macPortIdx))))	// unknown SA and learning at ingress
			{
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH_IRQ_PROTECT();
				ret = _rtk_fc_lut_learning(pPktHdr->eth->h_source, pPktHdr->ingressPort, pPktHdr->cvlanid,
									pPktHdr->igrWlanDevIdx, FALSE, FALSE, &pPktHdr->smacL2Idx);
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH_IRQ_PROTECT();
				
				if( ret !=RTK_FC_RET_OK)	{
					TRACE("LUT SA %pM learning was fail, ret = 0x%x", pPktHdr->eth->h_source, ret);
				}

				return RTK_FC_RET_LRN_SKIP_UNKNOWNSA;
			}
			
		}
		else
		{
			// lut learning should be done here because regardless the flow is planed to be learned or not.
			if(RTSKB_FCIGRDATA(rtskb)->isNotLocalOut) {
				
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH_IRQ_PROTECT();
				ret = _rtk_fc_lut_learning(RTSKB_FCIGRDATA(rtskb)->sa, pPktHdr->ingressPort, RTSKB_FCIGRDATA(rtskb)->srcCVlanId, 
									pPktHdr->igrWlanDevIdx, FALSE, FALSE, &pPktHdr->smacL2Idx);
				RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH_IRQ_PROTECT();
				
				if(ret != RTK_FC_RET_OK) {
					TRACE("LUT SA learning is fail, ret = 0x%x", ret);
				}
				
				return RTK_FC_RET_LRN_SKIP_UNKNOWNSA;
			}
			
		}
		
		
	}

	//20190411LUKE: check wan access limit if configured.
	if(!isIgr){
		//20200221LUKE: check L34 forward by smacEgrChange.
		if(RTSKB_FCIGRDATA(rtskb)->isNotLocalOut && pPktHdr->smacEgrChange == TRUE && fc_db.wanAccessLimit.accessLimitNumber>=0 &&
			((fc_db.wanAccessLimit.portMask&(0x1<<RTSKB_FCIGRDATA(rtskb)->ingressPort))
			|| (RTSKB_FCIGRDATA(rtskb)->wlan_dev_idx!=RTK_FC_WLANX_NOT_FOUND && (fc_db.wanAccessLimit.wlanMask&(1LL<<RTSKB_FCIGRDATA(rtskb)->wlan_dev_idx)))))
		{
			RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH_IRQ_PROTECT();
				
			if(fc_db.wanAccessLimit.limitField==RT_MISC_WAN_ACCESS_LIMIT_BY_MAC)
			{
				if(!pPktHdr->isPermitWanAccess)
				{
					if(fc_db.wanAccessLimit.accessLimitNumber<=atomic_read(&fc_db.wanAccessLimit.learningCount))
					{
						//trigger arp mechanism here!!
						_rtk_fc_wanAccessLimit_timer_init();

						TRACE("[DROP] wan access limit is reached(%d)", fc_db.wanAccessLimit.accessLimitNumber);
						if(RTSKB_FCIGRDATA(rtskb)->ingressTagif&IPV4_TAGIF)
						{
							unsigned int SIP=htonl(RTSKB_FCIGRDATA(rtskb)->srcIp);
							pr_err_ratelimited("[Error][WarnLog] Portmask Limit by MAC reached(%d), action: Drop. SMAC:%pM SIP:%pI4\n",fc_db.wanAccessLimit.accessLimitNumber,RTSKB_FCIGRDATA(rtskb)->sa,&SIP);
						}else{
							pr_err_ratelimited("[Error][WarnLog] Portmask Limit by MAC reached(%d), action: Drop. SMAC:%pM\n",fc_db.wanAccessLimit.accessLimitNumber,RTSKB_FCIGRDATA(rtskb)->sa);
						}
						ret = RTK_FC_RET_DROP_WAN_ACCESS_LIMIT;
					}else {
						pPktHdr->isPermitWanAccess=1;
						if(pPktHdr->smacL2Idx != SIGNED_INVALID)fc_db.lutTbl[pPktHdr->smacL2Idx]->isPermitWanAccess=1;		//FIXME: store permit in sa's lut entry here!!
						atomic_inc(&fc_db.wanAccessLimit.learningCount);
					}
				}
			}
			else
			{
				//20191226LUKE: we lookup ip by network byte order since we insert ip as big-endian when permission was given.
				if(RTSKB_FCIGRDATA(rtskb)->ingressTagif&IPV4_TAGIF)
				{
					unsigned int SIP=htonl(RTSKB_FCIGRDATA(rtskb)->srcIp);
					if(_rtk_fc_wanAccessLimit_IP_lookup(SIP)==FAILED)
					{
						if(fc_db.wanAccessLimit.accessLimitNumber<=atomic_read(&fc_db.wanAccessLimit.learningCount))
						{
							//trigger arp mechanism here!!
							_rtk_fc_wanAccessLimit_timer_init();

							TRACE("[DROP] wan access limit is reached(%d)", fc_db.wanAccessLimit.accessLimitNumber);
							pr_err_ratelimited("[Error][WarnLog] Portmask Limit by IP reached(%d), action: Drop. SMAC:%pM SIP:%pI4\n",fc_db.wanAccessLimit.accessLimitNumber,RTSKB_FCIGRDATA(rtskb)->sa,&SIP);
							ret = RTK_FC_RET_DROP_WAN_ACCESS_LIMIT;
						}else {
							//20191226LUKE: we keep network byte order when store ip in list, since we will compare it with linux's neighbor table, which stored as network byte order(big-endian).
							if(_rtk_fc_wanAccessLimit_IP_insert(SIP)==FAILED)
								ret = RTK_FC_RET_DROP_WAN_ACCESS_LIMIT;
						}
					}
				}
			}
			RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH_IRQ_PROTECT();
			
			if(ret != RTK_FC_RET_OK)
				return ret;
		}
	}

	
	if((pPktHdr->smacL2Idx != SIGNED_INVALID) && fc_db.lutTbl[pPktHdr->smacL2Idx])
		pPktHdr->smacHostPolIdx = fc_db.lutTbl[pPktHdr->smacL2Idx]->hostPolIdx;
	if((pPktHdr->dmacL2Idx != SIGNED_INVALID) && fc_db.lutTbl[pPktHdr->dmacL2Idx])
		pPktHdr->dmacHostPolIdx = fc_db.lutTbl[pPktHdr->dmacL2Idx]->hostPolIdx;

	return RTK_FC_RET_OK;
}

__IRAM_FC_SHORTCUT
void _rtk_fc_trace_log_processing(struct rt_skbuff *rtskb, fc_rx_info_t *pRxInfo, rtk_fc_pktHdr_t *pPktHdr, int isIgr)
{
	/****** TRACE FILTER ******/	
	if(unlikely(fc_db.filterLevel&fc_db.debugLevel)) {
		_rtk_fc_trace_filter_compare(rtskb, pPktHdr,isIgr);
	}
	else
	{
		if(isIgr)
		{
			if(fc_db.debugLevel & FC_DEBUG_LEVEL_TOPS)
			{
				RTK_FC_HELPER_MGR_TRACEFILTER_SPIN_LOCK_BH();
				fc_db.debugLevel_tmp = fc_db.debugLevel;
				fc_db.debugLevel &= FC_DEBUG_LEVEL_WARN | FC_DEBUG_LEVEL_TOPS; //keep WARN and TOPS
			}
		}
	}
	/*************************/

	/****** MAIN DEBUG INFO: PACKET BOUNDARY ******/
	if(unlikely(fc_db.debugLevel&FC_DEBUG_LEVEL_TRACE)) {
		if(isIgr) {
			_rtk_fc_displayInfo(rtskb, pPktHdr, pRxInfo);

			
			DEBUG("IngressMacPort=0x%x, IngressMacExtPort=%d", pPktHdr->ingressPort.macPortIdx, pPktHdr->ingressPort.macExtPortIdx);
		}else {
			_rtk_fc_displayInfo(rtskb, pPktHdr, NULL);
		}
	}

	if(unlikely(fc_db.debugLevel&FC_DEBUG_LEVEL_TRACE_DUMP)) {
		DUMP_PACKET(RTSKB_DATA(rtskb), (RTSKB_LEN(rtskb)-RTSKB_DATA_LEN(rtskb)), isIgr?"[Ingress]":"[Egress]");
	}
	/**********************************************/


	/****** FC Function starts from here  ******/

	//for debug
	if(unlikely((fc_db.debugLevel & FC_DEBUG_LEVEL_DEBUG) && 
		(RTSKB_MARK(rtskb)!=0 || RTSKB_MARK2(rtskb)!=0)) )
	{
		int i;

		if(RTSKB_MARK(rtskb)!=0)
			DEBUG("skb->mark1 = 0x%x\n", RTSKB_MARK(rtskb));
		if(RTSKB_MARK2(rtskb))
			DEBUG("skb->mark2 = 0x%llx", RTSKB_MARK2(rtskb));
		if((!isIgr)) {
			for(i=0; i < RTK_FC_SKBMARK_END ; i++)
			{
				if(fc_db.skbmark[i].startBit != RTK_FC_RMK_UNDEF)
				{
					char temp[20];
					int markvalue = 0;
					switch(i)
					{
						case RTK_FC_SKBMARK_QID:
							strcpy(temp, "qid");
							markvalue = pPktHdr->remarkDec.outputQid;
							break;
						case RTK_FC_SKBMARK_STREAMID:
							strcpy(temp, "streamid");
							markvalue = pPktHdr->remarkDec.streamId;
							break;
						case RTK_FC_SKBMARK_STREAMID_EN:
							strcpy(temp, "streamId en");
							markvalue = pPktHdr->remarkDec.streamId_en;
							break;
						case RTK_FC_SKBMARK_SWSHAPER_EN:
							strcpy(temp, "swShpaer en");
							markvalue = pPktHdr->remarkDec.swShaper_en;
							break;
						case RTK_FC_SKBMARK_METERIDX:
							strcpy(temp, "meterIdx");
							markvalue = pPktHdr->remarkDec.meterIdx;
							break;
						case RTK_FC_SKBMARK_METERIDX_EN:
							strcpy(temp, "meterIdx en");
							markvalue = pPktHdr->remarkDec.meterIdx_en;
							break;
						case RTK_FC_SKBMARK_FWDBYPS:
							strcpy(temp, "fwd by PS");
							markvalue = pPktHdr->remarkDec.fwdByPS;
							break;
						case RTK_FC_SKBMARK_MIBIDX:
							strcpy(temp, "mibIdx");
							markvalue = pPktHdr->remarkDec.mibIdx;
							break;
						case RTK_FC_SKBMARK_MIBIDX_EN:
							strcpy(temp, "mibIdx en");
							markvalue = pPktHdr->remarkDec.mibIdx_en;
							break;
						case RTK_FC_SKBMARK_FLOW_CACHE_MIB_EN:
							strcpy(temp, "flow_cache_mib en");
							markvalue = pPktHdr->remarkDec.flow_cache_mib_en;
							break;	
						case RTK_FC_SKBMARK_WANDSLOOPBACK_EN:
							strcpy(temp, "wanDsLoopback_en");
							markvalue = pPktHdr->remarkDec.wanDsLoopback_en;
							break;
						case RTK_FC_SKBMARK_PSFLOODFWDACC:
							strcpy(temp, "psFloodingFwdAcc");
							markvalue = pPktHdr->remarkDec.psFloodfwdAcc;
							break;		

						default:
							break;
					}
					if(markvalue!=0)
						DEBUG("mark%d bits[%d:%d] %s = %d", fc_db.skbmark[i].mark1or2+1, fc_db.skbmark[i].startBit, fc_db.skbmark[i].startBit+fc_db.skbmark[i].len-1, temp, markvalue);
				}
			}
		}
	}
	
	return;
}


/*
	decision pPktHdr->abstrSwFlowSearch to abstrSwFlow DataPath
*/
__IRAM_FC_SHORTCUT
rtk_fc_ret_t rtk_fc_abstrSwFlowSearchIf(rtk_fc_pktHdr_t *pPktHdr,uint8 isIgr)
{
	if(pPktHdr->isMulticast)
	{
		/* L3 IPMC (include UIPMC)*/
		TRACE("abstrSwFlowSearch by isMulticast=%d",pPktHdr->isMulticast);
		pPktHdr->abstrSwFlowSearch=TRUE;
		pPktHdr->abstrSwFlowFlooding=TRUE;
	}
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)	
	else if(fc_db.controlFuc.bc_hwflow_accelerate &&  
		(pPktHdr->eth && ((pPktHdr->eth->h_dest[ABSTR_BC_PREFIX_NUM]&ABSTR_BC_PREFIX_MASK)==ABSTR_BC_PREFIX)) )
	{
		/* L2MC || BC */
		uint8 bcmac[6]={0xff,0xff,0xff,0xff,0xff,0xff};
		if(memcmp(&pPktHdr->eth->h_dest[0],bcmac,sizeof(bcmac))==0)
		{
			//Mac FF:FF:FF:FF:FF:FF BC accelerate
			TRACE("abstrSwFlowSearch by FF:FF:FF:FF:FF:FF");
			pPktHdr->abstrSwFlowSearch=TRUE;
			pPktHdr->abstrSwFlowFlooding=TRUE;
		}
		else if(pPktHdr->ip6h==NULL && pPktHdr->iph==NULL)
		{
			//L2 MC accelerate	
			/*
				include (01-80-c2-xx-xx-xx/01:00:0c:xx:xx:xx)
			*/
			TRACE("abstrSwFlowSearch by L2 MC accelerate");
			pPktHdr->abstrSwFlowSearch=TRUE;
			pPktHdr->abstrSwFlowFlooding=TRUE;
		}
	
	}
	else if(fc_db.controlFuc.bc_hwflow_accelerate)
	{
		//for UUC accelerate
		if(isIgr)
		{
			//ingress
			if(pPktHdr->dmacL2Idx!=FAIL && fc_db.lutTbl[pPktHdr->dmacL2Idx]->isUnknowUcMc)
			{
				pPktHdr->abstrSwFlowSearch=TRUE;
				pPktHdr->abstrSwFlowFlooding=TRUE;	
			}
		}
		else
		{
			//egress
			if(pPktHdr->remarkDec.psFloodfwdAcc)
			{
				pPktHdr->abstrSwFlowSearch=TRUE;
				pPktHdr->abstrSwFlowFlooding=TRUE;	
			}
			
		}
		
		//we get unicast dmac l2 index ,if it is uuc mac
	}
#endif

	if(pPktHdr->abstrSwFlowFlooding && pPktHdr->eth)
	{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
		int16 l2Idx=FAIL;
		int32 ret=0;

		//egresss learning [unknown_uc/unknown_l2mc/unknown_l3mc] as non-static lut dmac
		if(fc_db.controlFuc.bc_hwflow_accelerate && isIgr==0 && pPktHdr->dmacL2Idx==FAIL )
		{
			if(((pPktHdr->eth->h_dest[ABSTR_BC_PREFIX_NUM]&ABSTR_BC_PREFIX_MASK)==ABSTR_BC_PREFIX))
			{
				ret= _rtk_fc_cpuSpa_macAdd(pPktHdr->eth->h_dest,FALSE, &l2Idx);
				if(ret)
					TABLE("Mac add Error");
				else
					 pPktHdr->dmacL2Idx=l2Idx;
				
				TRACE("abstrFlow flooding learning UMC/UIPMC non-static lut entry [%d]%pM for hardware accelerate",l2Idx,pPktHdr->eth->h_dest);
			}
			else
			{
				rtk_fc_pmap_t igrPort;
				igrPort.macPortIdx = RTK_FC_MAC_PORT_MAX;
				igrPort.macExtPortIdx = RTK_FC_MAC_EXT_PORT_MAX;
				ret=_rtk_fc_lut_learning(pPktHdr->eth->h_dest,igrPort,pPktHdr->cvlanid,RTK_FC_WLANX_NOT_FOUND,FALSE,FALSE,&l2Idx);
				if(ret)
					TABLE("Mac add Error");
				else
					 pPktHdr->dmacL2Idx=l2Idx;
				
				TRACE("abstrFlow flooding learning UUC non-static lut entry [%d]%pM for hardware accelerate",l2Idx,pPktHdr->eth->h_dest);
			}
		}
#endif
	}

	return RTK_FC_RET_OK;
}


__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_pktHdr_inspect(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, int egressPortMask, fc_rx_info_t *pRxInfo)
{
	uint8 l4Proto = 0;
	int nexthdr = 0;
	int16 l2Idx;
	int off=0, tmpOff = 0;
	u8 *pData=RTSKB_DATA(rtskb);
	uint8 isIgr = (egressPortMask==0) ? TRUE : FALSE;
	uint8 isRouting = FALSE;							// if routing, keep going to parse dual header. if bridge, we don't care dual header content.
	uint8 dualFail = FALSE;
	int i = 0;
	//struct ipv6_opt_hdr* ipv6OptHdr = NULL;

	prefetch(&pData[32]);
	prefetch(&pPktHdr->ethtype_proto);

	if(unlikely(RTSKB_SKB(rtskb)== NULL || RTSKB_DATA(rtskb)== NULL))
		return RTK_FC_RET_LRN_NULL_POINTER;

	if(RTSKB_LEN(rtskb)-RTSKB_DATA_LEN(rtskb) < ETH_HLEN)
		return RTK_FC_RET_LRN_FAIL; //non linear skbuff len < ETH_HLEN

GRE_ETH_BR_INNER:
VXLAN_INNER:
	isRouting = FALSE; 
	pPktHdr->dmacToGatewayMAC = 0;
	// Eth
	pPktHdr->eth = (struct ethhdr *)(pData+off);
	off+=(ETH_HLEN-2);

	if(isIgr){
		// ingress: in_DA
		if(_rtk_fc_lut_find(pPktHdr->eth->h_dest, &l2Idx)==RTK_FC_RET_OK) {
			pPktHdr->dmacL2Idx = l2Idx;

			if(fc_db.lutTbl[l2Idx] && fc_db.lutTbl[l2Idx]->isGMAC) { //VXLAN downstream: inner DA 
				isRouting = TRUE;
				pPktHdr->dmacToGatewayMAC = TRUE;
				RTSKB_FCIGRDATA(rtskb)->isDAGatewayMAC = TRUE;		// for doLearning = 0 with mac clone
			}
		}else 
			pPktHdr->dmacL2Idx = SIGNED_INVALID;

		// ingress: in_SA
		if(_rtk_fc_lut_find(pPktHdr->eth->h_source, &l2Idx) == RTK_FC_RET_OK)
			pPktHdr->smacL2Idx = l2Idx;
		else
			pPktHdr->smacL2Idx = SIGNED_INVALID;

	}else{
		// egress: out_DA
		if(_rtk_fc_lut_find(pPktHdr->eth->h_dest, &l2Idx)==RTK_FC_RET_OK)
			pPktHdr->dmacL2Idx = l2Idx;
		else
			pPktHdr->dmacL2Idx = SIGNED_INVALID;
		
		// egress: in_SA
		if(_rtk_fc_lut_find(RTSKB_FCIGRDATA(rtskb)->sa, &l2Idx) == RTK_FC_RET_OK)
			pPktHdr->smacL2Idx = l2Idx;
		else
			pPktHdr->smacL2Idx = SIGNED_INVALID;
	
		if(memcmp(&RTSKB_FCIGRDATA(rtskb)->sa[0], &pPktHdr->eth->h_source[0], ETH_ALEN))
		{
			isRouting = TRUE;
			pPktHdr->smacEgrChange = TRUE;
		}
		
		// MAC Clone: host smac == gateway mac in upstream routing case
		if(RTSKB_FCIGRDATA(rtskb)->isDAGatewayMAC)
			isRouting = TRUE;
	}
	

	// SVLAN
	if(unlikely(!isIgr && pPktHdr->remarkDec.svlan_action_from_skbmark))
	{
		
		if(pPktHdr->remarkDec.svlan_action_from_skbmark == RTK_FC_SKBMARK_VLAN_UNTAG)
		{
			
			//---------------------------------------------
	        // Actions: untag---> remove svh to NULL, and set svlan id, svlan pri to 0;
	        //---------------------------------------------
			if((*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[0]))
				off+=VLAN_HLEN;
			
			pPktHdr->svh = NULL;
			
		}
		else if(pPktHdr->remarkDec.svlan_action_from_skbmark == RTK_FC_SKBMARK_VLAN_REMARK)
		{
			//---------------------------------------------
			// 1. Check the packet is tagged or untagged
			//---------------------------------------------

			if(((*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[0])) || (fc_db.systemGlobal.ifstagTPID1_enabled && ((*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[1]))))
			{
				//---------------------------------------------
				//Tagged process
				//---------------------------------------------
				unsigned short original_svlan_id = 0;
				unsigned short original_svlan_pri = 0;
				struct vlan_hdr * original_svlan_hdr=NULL;
			
				//---------------------------------------------
				//parsing first for later tagged process used
				//---------------------------------------------
				original_svlan_hdr = (struct vlan_hdr *)(pData+off+2);
				original_svlan_id = (ntohs(original_svlan_hdr->h_vlan_TCI)&VLAN_VID_MASK);
				original_svlan_pri = ((ntohs(original_svlan_hdr->h_vlan_TCI)&VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT);
				
                _rtk_fc_pkthdr_vlanFromSKBMark_remarkingProcess(rtskb, pPktHdr, FALSE, TRUE, original_svlan_hdr, original_svlan_id,original_svlan_pri);

				if(fc_db.systemGlobal.ifstagTPID1_enabled && pPktHdr->remarkDec.svlan_tpid_from_skbmark && (*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[0]))
				{
					//---------------------------------------------
					//	If tpid selection is not equal to 
					//  fc_db.systemGlobal.stagTPID[0], then we need to 
					//  manually change the tpid in skb->data
					//---------------------------------------------
					TRACE("Orignal TPID: 0x%x, should be modified to TPID: 0x%x", (*(u16*)(pData+off)), fc_db.systemGlobal.stagTPID[1]);
					(*(u16*)(pData+off)) = fc_db.systemGlobal.stagTPID[1];
					
				}
				//---------------------------------------------
				//Add offset to let later parsing work successfully
				//---------------------------------------------
				
				off+=VLAN_HLEN;
			}
			else
			{
				//---------------------------------------------
				//Untagged process
				//---------------------------------------------
				_rtk_fc_pkthdr_vlanFromSKBMark_remarkingProcess(rtskb, pPktHdr, FALSE, FALSE, NULL, 0, 0);
				
			}
		
		}
		
	}else{ 
		// Original packet parsing	
		if(((*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[0])) || (fc_db.systemGlobal.ifstagTPID1_enabled && ((*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[1]))))
		{
			pPktHdr->stpid_sel = (fc_db.systemGlobal.ifstagTPID1_enabled && ((*(u16*)(pData+off)) == htons(fc_db.systemGlobal.stagTPID[1])))? 1 : 0;
			pPktHdr->svh = (struct vlan_hdr *)(pData+off+2);
			pPktHdr->svlanid = (ntohs(pPktHdr->svh->h_vlan_TCI)&VLAN_VID_MASK);
			pPktHdr->svlanpri = ((ntohs(pPktHdr->svh->h_vlan_TCI)&VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT);
			pPktHdr->svlandei = ((ntohs(pPktHdr->svh->h_vlan_TCI)&VLAN_CFI_MASK)>>VLAN_CFI_SHIFT);
			
			off+=VLAN_HLEN;
		}
	}

	// CVLAN
	if(unlikely(!isIgr && pPktHdr->remarkDec.cvlan_action_from_skbmark)){
		// might be assigned by skb mark
		TRACE("cvlan action from skbmark, action:%d\n",pPktHdr->remarkDec.cvlan_action_from_skbmark);
		
		//---------------------------------------------
        // Actions: untag---> remove cvh to NULL, and set cvlan id, cvlan pri to 0;
        //---------------------------------------------
		if(pPktHdr->remarkDec.cvlan_action_from_skbmark == RTK_FC_SKBMARK_VLAN_UNTAG)
		{
			if((*(u16*)(pData+off)) == htons(ETH_P_8021Q))
				off+=VLAN_HLEN;
			
			pPktHdr->cvh = NULL;
			
		}
		else if(pPktHdr->remarkDec.cvlan_action_from_skbmark == RTK_FC_SKBMARK_VLAN_REMARK)
		{
			//---------------------------------------------
			// 1. Check the packet is tagged or untagged
			//---------------------------------------------
			if((*(u16*)(pData+off)) == htons(ETH_P_8021Q)) //Tagged cvlan process
			{
				
				unsigned short original_cvlanid=0;
				unsigned short original_cvlanpri=0;
				struct vlan_hdr * original_vlan_hdr=NULL;
				TRACE("[CVLAN]TAG REPLACE");
				
				//---------------------------------------------
				//parsing first for later tagged process used
				//---------------------------------------------
				original_vlan_hdr = (struct vlan_hdr *)(pData+off+2);
				original_cvlanid = (ntohs(original_vlan_hdr->h_vlan_TCI)&VLAN_VID_MASK);
				original_cvlanpri = ((ntohs(original_vlan_hdr->h_vlan_TCI)&VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT);
				_rtk_fc_pkthdr_vlanFromSKBMark_remarkingProcess(rtskb, pPktHdr, TRUE, TRUE, original_vlan_hdr, original_cvlanid, original_cvlanpri);
				//---------------------------------------------
				//Add offset to let later parsing work successfully
				//---------------------------------------------
				off+=VLAN_HLEN;
				
				
			}
			else{ //Untagged cvlan process
				TRACE("[CVLAN]UNTAG REPLACE");
				_rtk_fc_pkthdr_vlanFromSKBMark_remarkingProcess(rtskb, pPktHdr, TRUE, FALSE, NULL, 0, 0 );
			}
						
		}

	}else{
		// Original packet parsing
		if((*(u16*)(pData+off)) == htons(ETH_P_8021Q))
		{
			pPktHdr->cvh = (struct vlan_hdr *)(pData+off+2);
			pPktHdr->cvlanid = (ntohs(pPktHdr->cvh->h_vlan_TCI)&VLAN_VID_MASK);
			pPktHdr->cvlanpri = ((ntohs(pPktHdr->cvh->h_vlan_TCI)&VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT);
			pPktHdr->cvlancfi = ((ntohs(pPktHdr->cvh->h_vlan_TCI)&VLAN_CFI_MASK)>>VLAN_CFI_SHIFT);
			off+=VLAN_HLEN;
		}

	}

	//if(pPktHdr->eth->h_proto == ntohs(ETH_P_8021Q) && pPktHdr->svh)
	//	pPktHdr->eth->h_proto = ntohs(ETH_P_8021AD);


	if(pPktHdr->cvh) {
		pPktHdr->ethtype_proto = ntohs(pPktHdr->cvh->h_vlan_encapsulated_proto);
	}else if(pPktHdr->svh) {
		pPktHdr->ethtype_proto = ntohs(pPktHdr->svh->h_vlan_encapsulated_proto);
	}else {
		pPktHdr->ethtype_proto = ntohs(pPktHdr->eth->h_proto);
	}

	pPktHdr->ethtype = pPktHdr->ethtype_proto;
	// PPPoE
	if(((*(u16*)(pData+off)) == htons(ETH_P_PPP_SES)) || ((*(u16*)(pData+off)) == htons(ETH_P_PPP_DISC)))
	{
		pPktHdr->ppph = (struct pppoe_hdr *)((unsigned char *)(pData)+off+2);
		off += PPPOE_SES_HLEN;
		if(pPktHdr->ethtype_proto == (ETH_P_PPP_SES))
			pPktHdr->ethtype_proto = ntohs((*(u16*)(pData+off)));
	}

	pPktHdr->l2PayloadLen = (RTSKB_LEN(rtskb)-(off+2));

TUNNEL_INNER:
	// L3 - IPv4/IPv6
	if(((*(u16*)(pData+off)) == htons(ETH_P_IP)) || ((*(u16*)(pData+off)) == htons(0x0021)) || (pData[off] == 0x21))
	{
		if(pData[off]==0x21)off-=1;
DSLITE_INNER:
		//IPv4
		pPktHdr->iph = (struct iphdr *)((unsigned char *)(pData)+off+2);

		pPktHdr->l3Offset = off+2;
		if( (pPktHdr->iph->version!=0x4) || !(pPktHdr->iph->ihl >= 0x5) ){
			TRACE("Non-normal ipv4 packet!Set ip-header to NULL and go pure path 12!");
			pPktHdr->iph = NULL;
			goto PURE_PATH12;
		}
		
		if(ntohs(pPktHdr->iph->frag_off) & 0x3FFF)
		{
			pPktHdr->isFragment = TRUE;

			if (pPktHdr->iph->protocol == IPPROTO_UDP) {
				pPktHdr->ipFragFlag = RTK_FC_IP_FRAG;
				if (ntohs(pPktHdr->iph->frag_off) == IP_MF)
					pPktHdr->ipFragFlag |= RTK_FC_IP_FIRST_FRAG;
				else if ((ntohs(pPktHdr->iph->frag_off) & IP_OFFSET) && !(ntohs(pPktHdr->iph->frag_off) & IP_MF))
					pPktHdr->ipFragFlag |= RTK_FC_IP_LAST_FRAG;

				if(unlikely(fc_db.fwdStatistic))
					atomic_inc(&fc_db.statistic.perPortCnt_ipFrag[pPktHdr->ingressPort.macPortIdx]);

				FRAGMENT("fragment packet iph id=0x%x, frag_off=0x%x, ipFragFlag=0x%x", ntohs(pPktHdr->iph->id), ntohs(pPktHdr->iph->frag_off), pPktHdr->ipFragFlag);
			}
		}
		off +=((pPktHdr->iph->ihl<<2)+2);
		l4Proto = pPktHdr->iph->protocol;

		if(l4Proto == IPPROTO_IPV6)
		{
			if(isRouting){
				if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
					return RTK_FC_RET_LRN_NOT_SUPPORT;
				else
					pPktHdr->dualHdrType = RTK_FC_DUALTYPE_6RD;
				off -= 2; //minus 2 for IP header is is start from ((unsigned char *)(pSkb->data)+off+2)
				goto V6RD_INNER;
			}
		}
	}
	else if((*(u16*)(pData+off)) == htons(ETH_P_IPV6) ||((*(u16*)(pData+off)) == htons(0x0057)) || (pData[off] == 0x57))
	{
		if(pData[off]==0x57)off-=1;
V6RD_INNER:
		//IPv6
		pPktHdr->ip6h = (struct ipv6hdr *)((unsigned char *)(pData)+off+2);
		pPktHdr->l3Offset = off+2;

		if( pPktHdr->ip6h->version!=0x6 ){
			TRACE("Non-normal ipv6 packet!Set ip6-header to NULL and go pure path 12!");
			pPktHdr->ip6h = NULL;
			goto PURE_PATH12;
		}
		
		pPktHdr->ipv6Sip_hash = _rtk_rg_flowHashIPv6SrcAddr_get(pPktHdr->ip6h->saddr.s6_addr);
		pPktHdr->ipv6Dip_hash = _rtk_rg_flowHashIPv6DstAddr_get(pPktHdr->ip6h->daddr.s6_addr);
		off +=(sizeof(struct ipv6hdr)+2);
		
		nexthdr =pPktHdr->ip6h->nexthdr;

MORE_IPV6_EXT:
		switch(nexthdr)
		{
			case (IPPROTO_IPIP):
			{
				//2[dslite]
				if(isRouting){
					TRACE("DSLite find!!");
					
					if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
						return RTK_FC_RET_LRN_NOT_SUPPORT;
					else
						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_DSLITE;
					off -= 2; //minus 2 for IP header is is start from ((unsigned char *)(pSkb->data)+off+2)
					goto DSLITE_INNER;


				}
				break;
			}
			case (IPPROTO_DSTOPTS):
			case (IPPROTO_HOPOPTS):
			{
				//TRACE("Parser Hop-by-Hop or DSTOPTS");
				nexthdr = *((unsigned char *)(pData)+off);
				off += ((*((unsigned char *)(pData)+off+1))+1)<<3 ; //( (nexthdr.len *8) +8 )
				goto MORE_IPV6_EXT;
			}
			case (IPPROTO_ROUTING):
			{
				//TRACE("Parser IPPROTO_ROUTING");
				nexthdr = *((unsigned char *)(pData)+off);
				off += ((*((unsigned char *)(pData)+off+1))+1)<<3 ; //( (nexthdr.len *8) +8 )
				goto MORE_IPV6_EXT;
			}
			case (IPPROTO_FRAGMENT):
			{
				//TRACE("Parser Fragment pkt");
				pPktHdr->isFragment = TRUE;
				nexthdr = *((unsigned char *)(pData)+off);
				off+=8;
				goto MORE_IPV6_EXT;
			}
			case (IPPROTO_ICMPV6):
			{
				//TRACE("Parser ICMPv6 Packet");
				break;
			}
			case (IPPROTO_NONE):
				break;
			case (IPPROTO_MH):
				break;

			default:
				break;
		}


		if(pPktHdr->iph && (pPktHdr->iph->protocol!=IPPROTO_IPV6))
			l4Proto = pPktHdr->iph->protocol;
		else
			l4Proto = nexthdr;

		//DEBUG("[PARSE][v6]L4 Protocol:%x",l4Proto);

	}
	else if((*(u16*)(pData+off)) == htons(ETH_P_ARP))
	{
		pPktHdr->arph = (struct arphdr *)((unsigned char *)(pData)+off+2);
	}

PURE_PATH12:

	if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_6RD)
		_rtk_fc_pkthdr_dualTranslation(pPktHdr);				// chage header to outer_header

	if((pPktHdr->iph == NULL) && (pPktHdr->ip6h == NULL))
		pPktHdr->payloadLen = pPktHdr->l2PayloadLen;	// pure L2 packet
	else
		pPktHdr->payloadLen = (RTSKB_LEN(rtskb)-off);	// L3 packet

	pPktHdr->l4Offset = off;

	// L4 - tcp/udp/...protocols
	pPktHdr->l4protol = l4Proto;
	switch(l4Proto)
	{
		case (IPPROTO_TCP):
			pPktHdr->tcph = (struct tcphdr *)((unsigned char *)(pData)+off);
			off += sizeof(struct tcphdr);
			pPktHdr->payloadLen -= (pPktHdr->tcph->doff * 4);
			break;
		case (IPPROTO_UDP):
			if ((pPktHdr->ipFragFlag & RTK_FC_IP_FRAG) && !(pPktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG))
				break;

			pPktHdr->udph = (struct udphdr *)((unsigned char *)(pData)+off);
			off += sizeof(struct udphdr);
			pPktHdr->payloadLen -= 8;
			
			//2[l2tp] l2tp+ppp
			if(isRouting && ((pPktHdr->udph->source==htons(1701)) || (pPktHdr->udph->dest==htons(1701)))){	 // for both ingress and egress packets
				if(pData[off]&0x89){			 // sw support: Offset bit(0x2) and offset_size must be 0
					dualFail = TRUE;			// skip: control packet parsing(0x80) or Sequence bit(0x8)/Priority bit(0x1)
					pPktHdr->dualFailed = TRUE;
				}
				if((pData[off+1]&0xf)!=0x2){
					dualFail = TRUE;	// support ver 2 only
					pPktHdr->dualFailed = TRUE;
				}
				tmpOff = 2;										// flag+version
				if(pData[off]&0x40)
					tmpOff+=2;									// Length bit
				pPktHdr->tunnelInfo.l2tp.tunnelid = ntohs(*(u16*)(pData+off+tmpOff));
				pPktHdr->tunnelInfo.l2tp.sessionid= ntohs(*(u16*)(pData+off+tmpOff+2));
				tmpOff+=4;
				if(pData[off]&0x02) {                                                           // sw support: Offset bit(0x2) and offset_size must be 0
					if((pData[off+tmpOff]==0 && (pData[off+tmpOff+1]==0) ) && isIgr && pRxInfo ) {
						tmpOff+=2;
						RXINFO_FBI(pRxInfo) = 0;					// force reset indicator, get hash idx (_rtk_fc_flow_hashIndex_get) by sw calculation 			
						TRACE("L2TP header with offset=0, try sw acceleration later");
					}else {
						dualFail = pPktHdr->dualFailed = TRUE;	
						TRACE("L2TP header with offset!=0, accelearation not support");
					}
				}


				if(pData[off+tmpOff] == 0xff  && pData[off+tmpOff+1] ==0x03){	// 0xff03: Address and Control field.
					// ff 03 00 xx OR ff 03 xx
					if ((pData[off+tmpOff+2] == 0x00)  && ((pData[off+tmpOff+3] ==0x21) || (pData[off+tmpOff+3] ==0x57))){
						pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_FF0300XX;
						tmpOff += 2;
					}
					else if ((pData[off+tmpOff+2] ==0x21) || (pData[off+tmpOff+2] ==0x57)){
						pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_FF03XX;
						tmpOff += 2;
					}
					else{
						dualFail = TRUE;
						pPktHdr->dualFailed = TRUE;
					}
				}else if(pData[off+tmpOff] == 0x00  && (pData[off+tmpOff+1] ==0x21 || pData[off+tmpOff+1] ==0x57)){
					// 00 xx
					pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_00XX;
				}else if((pData[off+tmpOff] ==0x21 || pData[off+tmpOff] ==0x57)){
					// xx
					pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_XX;
				}else{
					dualFail = TRUE;
					pPktHdr->dualFailed = TRUE;
				}

				if(!dualFail){
					off += tmpOff;
					TRACE("L2TP find!! %s\n",isIgr?"Ingress":"Egress");
					
					if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
						return RTK_FC_RET_LRN_NOT_SUPPORT;
					else
						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_L2TP;
					_rtk_fc_pkthdr_dualTranslation(pPktHdr);				// chage header to outer_header
					l4Proto = 0;
					goto TUNNEL_INNER;
				}
			}else if(isRouting && ((pPktHdr->udph->source==htons(4789)) || (pPktHdr->udph->dest==htons(4789))) ){ // vxlan
				int is_vxlan = FALSE;
				int udp_len = ntohs(pPktHdr->udph->len);
				
				if( (udp_len - sizeof(struct udphdr) ) < (ETH_HLEN + sizeof(rtk_fc_vxlanhdr_t)) )
				{
					is_vxlan = FALSE;
				}
				else
				{
					is_vxlan = TRUE;
				}
				
				if(is_vxlan)
				{
					TRACE("VXLAN FIND!!\n");
					
					if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
						return RTK_FC_RET_LRN_NOT_SUPPORT;
					else
						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_VXLAN;
					
					//if(fc_db.controlFuc.special_fast_forward_mode==1)
					{
						if(pPktHdr->iph)
						{
							pPktHdr->vxlan_info.outer_ip_len_off = off - sizeof(struct udphdr) - sizeof(struct iphdr) + offsetof(struct iphdr, tot_len); // ipv4 tot_len include ipv4 hdr len
							pPktHdr->vxlan_info.outer_isV6 = 0;
						}
						else if(pPktHdr->ip6h)
						{
							pPktHdr->vxlan_info.outer_ip6h_len_off = off - sizeof(struct udphdr) - sizeof(struct ipv6hdr) + offsetof(struct ipv6hdr, payload_len);  // ipv6 payload_len not include ipv6 hdr len
							pPktHdr->vxlan_info.outer_isV6 = 1;
						}
						pPktHdr->vxlan_info.outer_udp_len_off = off - sizeof(struct udphdr) + offsetof(struct udphdr, len);
						TRACE("outer ip len off = %d, outer udp len off = %d",pPktHdr->vxlan_info.outer_ip_len_off, pPktHdr->vxlan_info.outer_udp_len_off);
						
					}
					_rtk_fc_pkthdr_dualTranslation(pPktHdr);				// record outter and reset inner header wich will be re-parse later
					
					pPktHdr->vxlan_info.vxlanHdr = (rtk_fc_vxlanhdr_t *)((unsigned char *)(pData)+off);
					off += sizeof(rtk_fc_vxlanhdr_t);//8 //VXLAN HDR SIZE = 8bytes

					pPktHdr->vxlan_info.outerTag_off = off;
					TRACE("[VXLAN]Outer vxlan header offset = %d\n", pPktHdr->vxlan_info.outerTag_off);
					
					//pPktHdr->eth = (struct ethhdr *)(pData+off); // record inner ether header
					

					//off +=(ETH_HLEN-2);
					l4Proto = 0;
					goto VXLAN_INNER;
				}
			}
			break;
		case (IPPROTO_IGMP):
			pPktHdr->igmph= (struct igmphdr *)((unsigned char *)(pData)+off);
			pPktHdr->payloadLen -= 8;
			break;
		case (IPPROTO_ICMPV6):
			pPktHdr->icmp6h = (struct icmp6hdr *)((unsigned char *)(pData)+off);
			pPktHdr->payloadLen -= 8;
			break;
		case (IPPROTO_GRE):
			//2[pptp] gre+ppp
			//pPktHdr->payloadLen -= 8; //keep gre payload size as L3 payload size
			if(isRouting){
				tmpOff = 8; // Basic GRE header
				
				if((pData[off] & 0xc0)){
					dualFail = TRUE;		// checksum bit(0x80) / routing bit(0x40) / stict source route bit(0x8) / recursion control bit(0x7)
					pPktHdr->dualFailed = TRUE;
				}
				if(!(pData[off] & 0x20)){
					dualFail = TRUE;		// key bit	(Payload Length+Call ID))
					pPktHdr->dualFailed = TRUE;
				}
				if((pData[off+1] & 0x78)){
					dualFail = TRUE;		// reserved bits
					pPktHdr->dualFailed = TRUE;
				}
				if((pData[off+1] & 0x7)>0x1){
					dualFail = TRUE;	// GRE version >1
					pPktHdr->dualFailed = TRUE;
				}


				if((pData[off+2] == 0x88) && (pData[off+3] == 0x0b)){	// protocol type: ppp
			
					pPktHdr->tunnelInfo.pptp.grecallid = ntohs(*(u16*)(pData+off+6));
					pPktHdr->tunnelInfo.pptp.pCallId = pData+off+6;
					
					if(pData[off] & 0x10){		// Sequence number bit
						pPktHdr->tunnelInfo.pptp.greseq = ntohl(*(u32*)(pData+off+tmpOff));
						//pPktHdr->tunnelInfo.pptp.greseqTagif = TRUE;
						pPktHdr->tunnelInfo.tunnelTag |= GRESEQ_TAGIF;
						pPktHdr->tunnelInfo.pptp.pGRESeq = (u32*)(pData+off+tmpOff);
						tmpOff += 4;
					}
					if(pData[off+1] & 0x80){	// Ack number bit
						pPktHdr->tunnelInfo.pptp.greack = ntohl(*(u32*)(pData+off+tmpOff));
						//pPktHdr->tunnelInfo.pptp.greackTagif = TRUE;
						pPktHdr->tunnelInfo.tunnelTag |= GREACK_TAGIF;
						pPktHdr->tunnelInfo.pptp.pGREAck = (u32*)(pData+off+tmpOff);
						tmpOff += 4;
					}

					if(pData[off+tmpOff] == 0xff  && pData[off+tmpOff+1] ==0x03){	// 0xff03: Address and Control field.
						// ff 03 00 xx OR ff 03 xx
						if ((pData[off+tmpOff+2] == 0x00)  && ((pData[off+tmpOff+3] ==0x21) || (pData[off+tmpOff+3] ==0x57))){
							pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_FF0300XX;
							tmpOff += 2;
						}
						else if ((pData[off+tmpOff+2] ==0x21) || (pData[off+tmpOff+2] ==0x57)){
							pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_FF03XX;
							tmpOff += 2;
						}
						else{
							dualFail = TRUE;
							pPktHdr->dualFailed = TRUE;
							///add debug
							if(isIgr && (pData[off+tmpOff+2] == 0xc0) && ((pData[off+tmpOff+3] ==0x21) || (pData[off+tmpOff+3] ==0x57)) && (pData[off+tmpOff+4] == 0x09))
							{
								DEBUG("[PPTP] recv pptp PPP LCP echo request!!! greseq=%d Call id =%d\n", pPktHdr->tunnelInfo.pptp.greseq, pPktHdr->tunnelInfo.pptp.grecallid);
							}
																				
							if(isIgr==0 && (pData[off+tmpOff+2] == 0xc0) && ((pData[off+tmpOff+3] ==0x21) || (pData[off+tmpOff+3] ==0x57)) && (pData[off+tmpOff+4] == 0x0a))
							{
								DEBUG("[PPTP] send pptp PPP LCP echo reply!!! greseq=%d greack=%d Call id =%d\n", pPktHdr->tunnelInfo.pptp.greseq, pPktHdr->tunnelInfo.pptp.greack, pPktHdr->tunnelInfo.pptp.grecallid );
							}
						}
					}else if(pData[off+tmpOff] == 0x00  && (pData[off+tmpOff+1] ==0x21 || pData[off+tmpOff+1] ==0x57)){
						// 00 xx
						pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_00XX;
					}else if((pData[off+tmpOff] ==0x21 || pData[off+tmpOff] ==0x57)){
						// xx
						pPktHdr->tunnelInfo.pppMode=RTK_FC_COMP_PPP_XX;
					}else{
						// it may be tcp control session flow
						dualFail = TRUE;
						pPktHdr->dualFailed = TRUE;
					}
				}
				else if((pData[off+2] == 0x65) && (pData[off+3] == 0x58)) { // protocol type: Transparent Ether Bridging
					dualFail = FALSE;
					pPktHdr->dualFailed = FALSE;
					if((pData[off] & 0x80) /* checksum bit(0x80)*/ || (pData[off] & 0x20) /*key bit*/
						|| (pData[off] & 0x10) /*sequence number bit*/ || (pData[off+1] & 0x7) /*version != 0*/)
					{
						dualFail = TRUE;
						pPktHdr->dualFailed = TRUE;
					}
					else
					{
						pPktHdr->greh = (struct gre_base_hdr *)(pData+off);
						off += 4;
						TRACE("GRE (Transparent Ether Bridging) find!!");
						pPktHdr->greEthBr_info.outerTag_off = off;
						TRACE("[GRE ETH BR] Outer GRE ETH BR header offset = %d\n", pPktHdr->greEthBr_info.outerTag_off);
						
						if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
							return RTK_FC_RET_LRN_NOT_SUPPORT;
						else
							pPktHdr->dualHdrType = RTK_FC_DUALTYPE_GRE_ETH_BR;
						_rtk_fc_pkthdr_dualTranslation(pPktHdr);				// chage header to outer_header
						l4Proto = 0;

						// clear L2 related info, use inner L2 header to decide the following info
						{
							isRouting = FALSE;
							pPktHdr->dmacToGatewayMAC = FALSE;
							pPktHdr->smacEgrChange = FALSE;
						}
						goto GRE_ETH_BR_INNER;
					}
				}
				else{							//Protocol Type != 0x880B || Protocol Type != 0x6558
					dualFail = TRUE;
					pPktHdr->dualFailed = TRUE;
				}

				if(isIgr){
					for(i = 0; i < RTK_FC_TABLESIZE_INTF; i++){
						if(fc_db.netifHwTbl[i].intf.valid==FALSE) continue;
						if(fc_db.netifHwTbl[i].dualType != RTK_FC_DUALTYPE_PPTP) continue;
						if(!memcmp(&fc_db.netifHwTbl[i].intf.gateway_mac_addr, pPktHdr->eth->h_dest, ETH_ALEN) &&
							(fc_db.netifHwTbl[i].outerHdrFlowIdx != SIGNED_INVALID) &&
							(fc_db.flowTbl[fc_db.netifHwTbl[i].outerHdrFlowIdx].pFlowEntry->path6.in_gre_call_id == pPktHdr->tunnelInfo.pptp.grecallid) &&
							(fc_db.flowTbl[fc_db.netifHwTbl[i].outerHdrFlowIdx].pFlowEntry->path6.in_src_ipv4_addr == ntohl(pPktHdr->iph->saddr))
							)
						{
							pPktHdr->tunnelInfo.pptp.outerFlowReady = TRUE;

							//if(pPktHdr->tunnelInfo.pptp.greseqTagif){
							if(pPktHdr->tunnelInfo.tunnelTag & GRESEQ_TAGIF){
								rtk_fc_dualHdrInfo_set(RTK_FC_FB_DUALHDR_GREACK, i, pPktHdr->tunnelInfo.pptp.greseq);
							}

							if(!fc_db.netifHwTbl[i].psTunnelInfo.rx_server_seq_start_tracking){
								fc_db.netifHwTbl[i].psTunnelInfo.rx_server_seq_start_tracking = TRUE;
								fc_db.netifHwTbl[i].psTunnelInfo.rx_server_seq = pPktHdr->tunnelInfo.pptp.greseq;
							}

							//if(pPktHdr->tunnelInfo.pptp.greseqTagif){		// localinout sync
							if(pPktHdr->tunnelInfo.tunnelTag & GRESEQ_TAGIF){
								*pPktHdr->tunnelInfo.pptp.pGRESeq =  htonl(fc_db.netifHwTbl[i].psTunnelInfo.rx_server_seq);
								DEBUG("rx pptp seq = %d", fc_db.netifHwTbl[i].psTunnelInfo.rx_server_seq);
								fc_db.netifHwTbl[i].psTunnelInfo.rx_server_seq += 1;	// incremental seq
							}
							//if(pPktHdr->tunnelInfo.pptp.greackTagif){			// localinout sync
							if(pPktHdr->tunnelInfo.tunnelTag & GREACK_TAGIF){
								*pPktHdr->tunnelInfo.pptp.pGREAck = htonl(fc_db.netifHwTbl[i].psTunnelInfo.tx_greseq);
								DEBUG("rx pptp ack = %d", fc_db.netifHwTbl[i].psTunnelInfo.tx_greseq);
							}

							break;
						}else
							continue;
					}
				}
				if(!dualFail){
					off += tmpOff;
					TRACE("PPTP find!!");
						
					if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
						return RTK_FC_RET_LRN_NOT_SUPPORT;
					else
						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_PPTP;
					_rtk_fc_pkthdr_dualTranslation(pPktHdr);				// chage header to outer_header
					l4Proto = 0;
					goto TUNNEL_INNER;
				}
			}
			break;
		case (IPPROTO_ESP):
			pPktHdr->esph = (struct ip_esp_hdr *)((unsigned char *)(pData)+off);
				
			if(pPktHdr->dualHdrType!= RTK_FC_DUALTYPE_NONE)
				return RTK_FC_RET_LRN_NOT_SUPPORT;
			else
				pPktHdr->dualHdrType = RTK_FC_DUALTYPE_IPSEC;
			//pPktHdr->payloadLen -= 12; //keep gre payload size as L3 payload size
			break;
		case (IPPROTO_ICMP):
			pPktHdr->icmph = (struct icmphdr *)((unsigned char *)(pData)+off);
			
			//pPktHdr->payloadLen -= 12; //keep gre payload size as L3 payload size
			break;
		default:
			break;
	}


	if(unlikely(!isIgr)){
		rtk_fc_flow_direction_t direction=0;

		pPktHdr->dstDev = RTSKB_DEV(rtskb);

		pPktHdr->egressPort.macPortIdx = __ffs(egressPortMask);
		
		pPktHdr->skbLen_egress = RTSKB_LEN(rtskb);

		direction = _rtk_fc_flow_direction(pPktHdr, RTSKB_FCIGRDATA(rtskb));

		pPktHdr->direction = direction;

		if(direction == RTK_FC_FLOW_DIRECTION_NATLOOPBACK){
			//This kind of packet will be skip learning later in Egress flow learning process, so in header inspect just need to return OK.
			goto INSPECT_DONE;
		}
		
		//WARNING("isRouting  = %d direction = %d", isRouting, direction);
		if(isRouting && direction!= RTK_FC_FLOW_DIRECTION_LANBRIDGE){

			if(pPktHdr->iph){
				if((direction == RTK_FC_FLOW_DIRECTION_UPSTREAM) && (ntohl(pPktHdr->iph->saddr) != RTSKB_FCIGRDATA(rtskb)->srcIp)){
					pPktHdr->fwdType = RTK_FC_FWDTYPE_NAPT;		// outbound
				}else if((direction == RTK_FC_FLOW_DIRECTION_DOWNSTREAM) && (ntohl(pPktHdr->iph->daddr) != RTSKB_FCIGRDATA(rtskb)->dstIp)){
					pPktHdr->fwdType = RTK_FC_FWDTYPE_NAPT;		// inbound
				}else
					pPktHdr->fwdType = RTK_FC_FWDTYPE_ROUTING;	// ipv4 routing

				if(RTSKB_FCIGRDATA(rtskb)->ingressTagif&IPV6_TAGIF)
					pPktHdr->isMAPT = TRUE;
				
				if ( (direction == RTK_FC_FLOW_DIRECTION_UPSTREAM && !RTSKB_FCIGRDATA(rtskb)->isDualHeader && pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE) ||
					(direction == RTK_FC_FLOW_DIRECTION_DOWNSTREAM && RTSKB_FCIGRDATA(rtskb)->ingressTagif&DSLITE_TAGIF && pPktHdr->dualHdrType == RTK_FC_DUALTYPE_NONE))
				{
						pPktHdr->isMAPT = FALSE;
					
						if(pPktHdr->fwdType==RTK_FC_FWDTYPE_NAPT)
							pPktHdr->isMAPE=TRUE;
						else
							pPktHdr->isDslite=TRUE;
#if defined(CONFIG_FC_RTL8277C_SERIES)						
						pPktHdr->fmr_idx = L3PE_DUAL_FMR_TBL_ENTRY_MAX;
#endif
						TRACE(" egress 4IN6 Packet isMAPE=%d isDslite=%d ",pPktHdr->isMAPE,pPktHdr->isDslite);
				}				
			}else{ 
				// ipv6
				if((direction == RTK_FC_FLOW_DIRECTION_UPSTREAM) && ((pPktHdr->ipv6Sip_hash) != RTSKB_FCIGRDATA(rtskb)->srcIp)){
					pPktHdr->fwdType = RTK_FC_FWDTYPE_NAPT;		// outbound
				}else if((direction == RTK_FC_FLOW_DIRECTION_DOWNSTREAM) && ((pPktHdr->ipv6Dip_hash) != RTSKB_FCIGRDATA(rtskb)->dstIp)){
					pPktHdr->fwdType = RTK_FC_FWDTYPE_NAPT;		// inbound
				}else
					pPktHdr->fwdType = RTK_FC_FWDTYPE_ROUTING;	// ipv6 routing

				if(RTSKB_FCIGRDATA(rtskb)->ingressTagif&IPV4_TAGIF)
					pPktHdr->isMAPT = TRUE;
			}

		}else{
			pPktHdr->fwdType = RTK_FC_FWDTYPE_BRIDGE;

			TRACE("egress fwdType %d (%s)\n", pPktHdr->fwdType, rtk_fc_fwd_type_name[pPktHdr->fwdType]);
		}
		pPktHdr->isHitSwFwdedAclTrapPri = RTSKB_FCIGRDATA(rtskb)->isHitSwFwdedAclTrapPri;
	}
	else
	{
		//isIgr
		pPktHdr->skbLen_ingress = RTSKB_LEN(rtskb);
		if((pPktHdr->reason == CPU_REASON_ACL) && pRxInfo && (fc_db.controlFuc.flow_swFwded_aclTrapPri_mask & (1 << RXINFO_INT_PRI(pRxInfo))))
			pPktHdr->isHitSwFwdedAclTrapPri = TRUE;
	}

	if((pPktHdr->iph && FLOW_IPV4_MULTICAST_ADDRESS(ntohl(pPktHdr->iph->daddr))) ||(pPktHdr->ip6h && FLOW_IPV6_MULTICAST_ADDRESS(ntohl(pPktHdr->ip6h->daddr.s6_addr32[0]))))
	{
		if(pPktHdr->eth->h_dest[0]&0x1)
		{
			//normal multicast
			pPktHdr->isMulticast = TRUE;
		}
		else
		{
			//ucMAC  for ingress parse l2 uc and to gatewayMac is multicast
			//       for egress parse dmac to gatewayMac is impossible,always FALSE
			if(pPktHdr->dmacToGatewayMAC)
				pPktHdr->isMulticast = TRUE;
			else
				pPktHdr->isMulticast = FALSE;
		}
	}

	rtk_fc_abstrSwFlowSearchIf(pPktHdr,isIgr);

	
INSPECT_DONE:
	return RTK_FC_RET_OK;

}

int _rtk_fc_pktHdr_dump(rtk_fc_pktHdr_t *pPktHdr)
{
	int sport=0, dport=0;

	if(pPktHdr->tcph)
	{
		sport = ntohs(pPktHdr->tcph->source);
		dport = ntohs(pPktHdr->tcph->dest);
	}else if(pPktHdr->udph)
	{
		sport = ntohs(pPktHdr->udph->source);
		dport = ntohs(pPktHdr->udph->dest);
	}

	if((pPktHdr->iph)&&(pPktHdr->tcph||pPktHdr->udph))
	{
		rtlglue_printf("Src=%pI4(%d) Dst=%pI4(%d) %s L4_PROTO=0x%02x %s%s%s%s%s%s\n",
			&pPktHdr->iph->saddr,
			sport,
			&pPktHdr->iph->daddr ,
			dport,
			pPktHdr->tcph?"TCP":(pPktHdr->udph?"UDP":"OTHER"),
			pPktHdr->iph->protocol,
			(pPktHdr->tcph)?"Flags:":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->syn)?"SYN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->ack)?"ACK":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->psh)?"PUSH":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->fin)?"FIN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->rst)?"RST":""
			);
	}
	else
	{
		//rtlglue_printf("fixme");
	}

	return SUCCESS;
}

/*
* sip/dip/tos/ttl are differential between (new value - ori value)
* input: host byte order
* output: network byte order
*/
uint16 _rtk_fc_L3ChecksumDiff_update(uint16 ori_checksum, uint32 ori_sip, uint32 ori_dip, uint16 ori_tos ,
																uint32 new_sip, uint32 new_dip, uint16 new_tos, uint32 ttldiff)
{
	uint32 tmp_chksum = ((~ori_checksum)&0xffff);
	// OCADD & OCSUB

	if(((ori_sip&0xffff0000)^(new_sip&0xffff0000))!=0){
		tmp_chksum += (((~ori_sip)>>16) + (new_sip>>16));
	}
	if(((ori_sip&0x0000ffff)^(new_sip&0x0000ffff))!=0){
		tmp_chksum += (((~ori_sip)&0xffff) + (new_sip&0xffff));
	}

	if(((ori_dip&0xffff0000)^(new_dip&0xffff0000))!=0){
		tmp_chksum += (((~ori_dip)>>16) + (new_dip>>16));
	}
	if(((ori_dip&0x0000ffff)^(new_dip&0x0000ffff))!=0){
		tmp_chksum += (((~ori_dip)&0xffff) + (new_dip&0xffff));
	}


	if(ori_tos!=new_tos){
		tmp_chksum += (((~ori_tos)&0xffff) + (new_tos&0xffff));
	}

	if(ttldiff!=0){
		tmp_chksum += ((~((-ttldiff)<<8))&0xffff);
	}

	while (tmp_chksum >> 16)
	{
		tmp_chksum = (tmp_chksum & 0xffffUL) + (tmp_chksum >> 16);
	}

	return htons(~(tmp_chksum&0xffff));
}
/*
* sip/dip/sport/dport are differential between (new value - ori value)
* ipv6 sip/dip should always zero.
* input: host byte order
* output: network byte order
*/
uint16 _rtk_fc_L4ChecksumDiff_update(uint16 ori_checksum, uint32 ori_sip, uint32 ori_dip, uint16 ori_sport, uint16 ori_dport,
																uint32 new_sip, uint32 new_dip, uint16 new_sport, uint16 new_dport)
{
	uint32 tmp_chksum = ((~ori_checksum)&0xffff);
	// OCADD & OCSUB

	if(((ori_sip&0xffff0000)^(new_sip&0xffff0000))!=0){
		tmp_chksum += (((~ori_sip)>>16) + (new_sip>>16));
	}
	if(((ori_sip&0x0000ffff)^(new_sip&0x0000ffff))!=0){
		tmp_chksum += (((~ori_sip)&0xffff) + (new_sip&0xffff));
	}


	if(((ori_dip&0xffff0000)^(new_dip&0xffff0000))!=0){
		tmp_chksum += (((~ori_dip)>>16) + (new_dip>>16));
	}
	if(((ori_dip&0x0000ffff)^(new_dip&0x0000ffff))!=0){
		tmp_chksum += (((~ori_dip)&0xffff) + (new_dip&0xffff));
	}

	if(ori_sport!=new_sport){
		tmp_chksum += (((~ori_sport)&0xffff) + (new_sport&0xffff));
	}

	if(ori_dport!=new_dport){
		tmp_chksum += (((~ori_dport)&0xffff) + (new_dport&0xffff));
	}

	while (tmp_chksum >> 16)
	{
		tmp_chksum = (tmp_chksum & 0xffffUL) + (tmp_chksum >> 16);
	}

	return htons(~(tmp_chksum&0xffff));
}

int _rtk_fc_pktHdr_v4L34Checksum_update(rtk_fc_pktHdr_t *pPktHdr)
{
	if(pPktHdr->iph){
		pPktHdr->iph->check  = 0;
		pPktHdr->iph->check = ip_fast_csum((unsigned char *)pPktHdr->iph, pPktHdr->iph->ihl);

		if(pPktHdr->udph){
			pPktHdr->udph->check = 0;
			pPktHdr->udph->check = inet_chksum_pseudo((u8 *)pPktHdr->udph, pPktHdr->udph->len, pPktHdr->iph->saddr, pPktHdr->iph->daddr, pPktHdr->iph->protocol);
		}
		if(pPktHdr->tcph){
			pPktHdr->tcph->check = 0;
			pPktHdr->tcph->check = inet_chksum_pseudo((u8 *)pPktHdr->tcph, pPktHdr->iph->tot_len - (pPktHdr->iph->ihl<<2), pPktHdr->iph->saddr, pPktHdr->iph->daddr, pPktHdr->iph->protocol);
		}
	}

	return (SUCCESS);
}

static uint16 csum_incremental_update_modified(uint16 old_csum,uint16 old_field,uint16 new_field)
{
   unsigned long csum = (~old_csum & 0xFFFF) + (~old_field &0xFFFF) + new_field ;

   csum = (csum >> 16) + (csum & 0xFFFF);

   csum +=  (csum >> 16);

   return (uint16)(~csum);

}

uint16 _rtk_fc_ipv6_L4ChecksumDiff_update(uint16 *new_ip, uint16 *old_ip,uint16 checksum)
{
	int i;
	uint16 acc=ntohs(checksum);

	if (!old_ip || !new_ip)
		return -1;

	for(i=0; i<8;i++)
	{
		acc=csum_incremental_update_modified(acc,ntohs(old_ip[i]),ntohs(new_ip[i]));
	}

	return htons(acc);
}

int _rtk_fc_pktHdr_v6L34Checksum_update(rtk_fc_pktHdr_t *pPktHdr)
{
	if(pPktHdr->ip6h){
		if(pPktHdr->udph){
			pPktHdr->udph->check = 0;
			pPktHdr->udph->check = inet_chksum_pseudoV6((u8 *)pPktHdr->udph, pPktHdr->udph->len, &pPktHdr->ip6h->saddr.s6_addr[0], &pPktHdr->ip6h->daddr.s6_addr[0], pPktHdr->ip6h->nexthdr);
		}
		if(pPktHdr->tcph){
			pPktHdr->tcph->check = 0;
			pPktHdr->tcph->check = inet_chksum_pseudoV6((u8 *)pPktHdr->tcph, pPktHdr->ip6h->payload_len, &pPktHdr->ip6h->saddr.s6_addr[0], &pPktHdr->ip6h->daddr.s6_addr[0], pPktHdr->ip6h->nexthdr);
		}
	}

	return (SUCCESS);
}

int _rtk_fc_flow_direction(rtk_fc_pktHdr_t *pPktHdr, rtk_fc_ingress_data_t *ingress_data)
{
	bool toWAN=FALSE,fromWAN=FALSE;
	int flowDirection=-1;
	int snatTrans = FALSE;
	int dnatTrans = FALSE;

	// Decide flow direction according to ingress/egress physical port
	toWAN = (((1<<pPktHdr->egressPort.macPortIdx)&fc_db.wanPortMask.portmask)!=0)?1:0;
	fromWAN = (((1<<ingress_data->ingressPort)&fc_db.wanPortMask.portmask)!=0)?1:0;

	if(fc_db.wanPortWifidevMask) {
		if(fc_db.wanPortWifidevMask & (1LL << pPktHdr->egrWlanDevIdx))
			toWAN = TRUE;
		if(fc_db.wanPortWifidevMask & (1LL << pPktHdr->igrWlanDevIdx))
			fromWAN = TRUE;
	}

	if(fromWAN==FALSE && toWAN==TRUE)
		flowDirection = RTK_FC_FLOW_DIRECTION_UPSTREAM;
	else if(fromWAN==TRUE && toWAN==FALSE)
		flowDirection = RTK_FC_FLOW_DIRECTION_DOWNSTREAM;
	else
		flowDirection = RTK_FC_FLOW_DIRECTION_LANBRIDGE;

	if((ingress_data->doLearning) && (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_NONE) && (pPktHdr->iph) && !(ingress_data->ingressTagif&VXLAN_TAGIF) && !(ingress_data->ingressTagif&IPV6_TAGIF)){

		// V4
		snatTrans = (ntohl(pPktHdr->iph->saddr) != ingress_data->srcIp) ? TRUE : FALSE;
		dnatTrans = (ntohl(pPktHdr->iph->daddr) != ingress_data->dstIp) ? TRUE : FALSE;

		// check NAT loopback (SNAT + DNAT)
		if(snatTrans && dnatTrans){
			flowDirection = RTK_FC_FLOW_DIRECTION_NATLOOPBACK;			// nat loopback dip is wan ip; consider routing case too, prevent not suppoprt behavior
			DEBUG("NAT loopback (SNAT + DNAT)");
		}

		if((flowDirection == RTK_FC_FLOW_DIRECTION_LANBRIDGE)){
			if (snatTrans){
				flowDirection = RTK_FC_FLOW_DIRECTION_NATLOOPBACK;		// nat loopback but dip is lan private ip address
				DEBUG("NAT loopback, dip is lan private ip address");
			}
			if (dnatTrans){
				flowDirection = RTK_FC_FLOW_DIRECTION_NATLOOPBACK;		// nat loopback but sip is lan private ip address
				DEBUG("NAT loopback, sip is lan private ip address");
			}
		}
	}

	if(flowDirection==-1)
		WARNING("can't decide flow direction, ingress form %d, egress to port %d", ingress_data->ingressPort, pPktHdr->egressPort.macPortIdx);
	else{
		DEBUG("flow direction = %d (%s) snat = %d, dnat = %d", flowDirection, rtk_fc_fwd_dir_name[flowDirection], snatTrans, dnatTrans);

	}


	return flowDirection;
}

void _rtk_fc_trace_filter_flowTracker(uint32 flowidx)
{
	uint32 show = fc_db.tracefilterShow;

	if((fc_db.debugLevel&FC_DEBUG_LEVEL_TABLE) && (fc_db.filterLevel&FC_DEBUG_LEVEL_TABLE))
	{
		int i=0,hit=0;
		
		for(i=0 ; i< TRACFILTER_MAX ;i++)
		{
			if((fc_db.trace_filter_bitmask[i] & FC_DEBUG_TRACE_FILTER_FLOWINDEX) &&
				fc_db.trace_filter[i].flowindex== flowidx) {

				if(fc_db.trace_filter_bitmask[i] & FC_DEBUG_TRACE_FILTER_SHOWNUMBEROFTIMES) {
					if(fc_db.trace_filter[i].showNumberOfTimesCounter < fc_db.trace_filter[i].showNumberOfTimes) {
						hit=1;
						fc_db.trace_filter[i].showNumberOfTimesCounter++;
					}

				}else {
					hit=1;
				}
			}
		}
		
		if(hit)
		{
			fc_db.tracefilterShow = 1U;
			WARNING("Tracking flow Idx = %d", flowidx);
			WARNING("===============================================================");
			_rtk_fc_dump_stack();
			WARNING("===============================================================");
			fc_db.tracefilterShow = show;
		}
	}
	return;
}


void _rtk_fc_trace_filter_compare(struct rt_skbuff *rtskb,rtk_fc_pktHdr_t *pPktHdr, int isIgr)
{
	int32 i,j;
	uint32 show=0U;
	int32 da_hit=0,sa_hit=0;
	uint16 ingressSPA = 0;

	//if(unlikely(fc_db.filterLevel&fc_db.debugLevel))	// move to caller
	{
		if(pPktHdr->egressPort.macPortIdx==0)
			ingressSPA = pPktHdr->ingressPort.macPortIdx;
		else{
			if(RTSKB_FCIGRDATA(rtskb)->doLearning)
				ingressSPA = RTSKB_FCIGRDATA(rtskb)->ingressPort;
			else
				ingressSPA = RTK_FC_MAC_PORT_CPU;
		}

		for(i=0;i<TRACFILTER_MAX;i++)
		{
			da_hit=0;
			sa_hit=0;

			if(!(fc_db.traceFilterRuleMask & (1<<i)))
				continue;

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_SPA)
			{
				if(fc_db.trace_filter[i].spa!=ingressSPA) continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_DA)
			{
				for(j=0;j<6;j++)
				{
					if((fc_db.trace_filter[i].dmac.octet[j]&fc_db.trace_filter[i].dmac_mask.octet[j])!=
						(RTSKB_DATA(rtskb)[j]&fc_db.trace_filter[i].dmac_mask.octet[j]))
							da_hit=1;
				}
				if(da_hit)
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_SA)
			{
				for(j=0;j<6;j++)
				{
					if((fc_db.trace_filter[i].smac.octet[j]&fc_db.trace_filter[i].smac_mask.octet[j])!=
						(RTSKB_DATA(rtskb)[j+6]&fc_db.trace_filter[i].smac_mask.octet[j]))
							sa_hit=1;
				}
				if(sa_hit)
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_ETH)
			{
				if(fc_db.trace_filter[i].ethertype!=pPktHdr->ethtype_proto) continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_SIP)
			{
				if(pPktHdr->iph)
				{
					if(fc_db.trace_filter[i].sip!=ntohl(pPktHdr->iph->saddr))
						continue;
				}else
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_DIP)
			{
				if(pPktHdr->iph)
				{
					if(fc_db.trace_filter[i].dip!=ntohl(pPktHdr->iph->daddr))
						continue;
				}else
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_IP)
			{
				if(pPktHdr->iph)
				{
					if((fc_db.trace_filter[i].ip!=ntohl(pPktHdr->iph->daddr))&&(fc_db.trace_filter[i].ip!=ntohl(pPktHdr->iph->saddr)))
						continue;
				}else
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_L4PROTO)
			{
				if(fc_db.trace_filter[i].l4proto!=pPktHdr->l4protol){ continue;}
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_SPORT)
			{
				if(pPktHdr->tcph){if(fc_db.trace_filter[i].sport!=ntohs(pPktHdr->tcph->source)) continue;}
				else if(pPktHdr->udph){if(fc_db.trace_filter[i].sport!=ntohs(pPktHdr->udph->source))continue;}
				else{continue;}
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_DPORT)
			{
				if(pPktHdr->tcph){if(fc_db.trace_filter[i].dport!=ntohs(pPktHdr->tcph->dest)) continue;}
				else if(pPktHdr->udph){if(fc_db.trace_filter[i].dport!=ntohs(pPktHdr->udph->dest)) continue;}
				else{continue;}
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_REASON)
			{
				if(fc_db.trace_filter[i].reason!=pPktHdr->reason) continue;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_CVLAN)
			{
				if(pPktHdr->cvh!=NULL)
				{
					if((pPktHdr->cvlanid!=fc_db.trace_filter[i].cvlanid))
						continue;
				}else
					continue;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_SVLAN)
			{
				if(pPktHdr->svh!=NULL)
				{
					if(pPktHdr->svlanid!=fc_db.trace_filter[i].svlanid)
						continue;
				}else
					continue;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_PPPOESESSIONID)
			{
				if(pPktHdr->ppph)
				{
					if(ntohs(pPktHdr->ppph->sid)!=fc_db.trace_filter[i].sessionid)
						continue;
				}else
					continue;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_V6DIP)
			{
				if(pPktHdr->ip6h)
				{
					if( !(memcmp(pPktHdr->ip6h->daddr.s6_addr32,&(fc_db.trace_filter[i].dipv6[0]),16)==0) )
						continue;
				}
				else
					continue;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_V6SIP)
			{
				if(pPktHdr->ip6h)
				{
					if( !(memcmp(pPktHdr->ip6h->saddr.s6_addr32,&(fc_db.trace_filter[i].sipv6[0]),16)==0) )
						continue;
				}
				else
					continue;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_SHOWNUMBEROFTIMES)
			{
				if(fc_db.trace_filter[i].showNumberOfTimesCounter>= fc_db.trace_filter[i].showNumberOfTimes)
					continue;
				else
					fc_db.trace_filter[i].showNumberOfTimesCounter++;
			}

			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_DUMMYMC)
			{
				if(RTSKB_FCIGRDATA(rtskb)->mcDummyPkt==0)
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_WLAN_INDEX)
			{
				// From wlan device
				// ingress: check pPktHdr->igrWlanDevIdx
				// Egress: !isIgr and RTSKB_FCIGRDATA(rtskb)->wlan_dev_idx==fc_db.trace_filter[i].wlan_index
				
				if( !( pPktHdr->igrWlanDevIdx==fc_db.trace_filter[i].wlan_index || ( RTSKB_FCIGRDATA(rtskb)->isNotLocalOut&&(!isIgr) && (RTSKB_FCIGRDATA(rtskb)->wlan_dev_idx==fc_db.trace_filter[i].wlan_index) ) ) )
					continue;
			}
			if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_FLOWINDEX)
			{
					continue;
			}

			show=1U;
			break;
		}
		
		if(show==1U){
			RTK_FC_HELPER_MGR_TRACEFILTER_SPIN_LOCK_BH();
			fc_db.tracefilterShow = show;
			if(isIgr && ((fc_db.debugLevel & fc_db.filterLevel) & FC_DEBUG_LEVEL_TOPS))
			{
				fc_db.debugLevel_tmp = fc_db.debugLevel;
				fc_db.debugLevel &= !(fc_db.filterLevel);
				fc_db.debugLevel |= FC_DEBUG_LEVEL_TOPS;
			}

			// get correct rx dev if trace log is on.
			if(isIgr) {
				RTK_FC_HELPER_DECIDE_RX_DEV_BY_SPA(pPktHdr->ingressPort.macPortIdx, &RTSKB_DEV(rtskb));
			}
			
		}else {
			if(fc_db.tracefilterShow)	// not display but owned by other cpu
				RTK_FC_HELPER_MGR_TRACEFILTER_SPIN_LOCK_BH();
				
			fc_db.tracefilterShow = 0U;
		}

	}
	return;
}

void _rtk_fc_str2mac(unsigned char *mac_string,rtk_mac_t *pMacEntry)
{
	int i,j=0,k=0;
	memset(pMacEntry,0,sizeof(rtk_mac_t));
	for(i=0;i<strlen(mac_string);i++)
	{
		if(mac_string[i]==':')
		{
			j=0;
			continue;
		}
		else if((mac_string[i]>='A')&&(mac_string[i]<='F'))
			pMacEntry->octet[k]+=(mac_string[i]-'A'+10);
		else if((mac_string[i]>='a')&&(mac_string[i]<='f'))
			pMacEntry->octet[k]+=(mac_string[i]-'a'+10);
		else if((mac_string[i]>='0')&&(mac_string[i]<='9'))
			pMacEntry->octet[k]+=(mac_string[i]-'0');
		else
			DEBUG("str2mac MAC string parsing error!");
		if(j==0) pMacEntry->octet[k]<<=4;
		if(j==1) k++;
		j++;
	}
}

int32 _rtk_fc_strToMac(uint8 *pMac, int8 *pStr)
{
	int8 *ptr;
	uint32 k;

	if(pMac == NULL)
		return -1;
	if(pStr == NULL)
		return -1;

	memset(pMac,0, ETH_ALEN);
	ptr = pStr;

	for ( k = 0 ; *ptr ; ptr ++ )
	{
		if (*ptr == ' ')
		{
		} else if ( (*ptr == ':') || (*ptr == '-') )
		{
			k ++;
		} else if ( ('0' <= *ptr) && (*ptr <= '9') )
		{
			pMac[k] = (pMac[k]<<4) + (*ptr-'0');
		} else if ( ('a' <= *ptr) && (*ptr <= 'f') )
		{
			pMac[k] = (pMac[k]<<4) + (*ptr-'a'+10);
		} else if( ('A' <= *ptr) && (*ptr <= 'F') )
		{
			pMac[k] = (pMac[k]<<4) + (*ptr-'A'+10);
		} else
		{
			break;
		}
	}

	if (k != 5)
	{
		return -1;
	}

	return 0;
}

void _rtk_fc_displayInfo(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, fc_rx_info_t *pRxInfo)
{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	char dbg_info[64] = {0};
#endif


	if(pRxInfo != NULL) {
		TRACE_RXINFO("===== >> INGRESS PACKET BOUNDARY(%p) dev %s =====\n", RTSKB_SKB(rtskb), RTSKB_DEV(rtskb)->name);

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if((RXINFO_REASON(pRxInfo) == CPU_REASON_ACL) && (RXINFO_REFIDX(pRxInfo)&RXINFO_REF_ACL_RSN_BIT))
#else
		if(RXINFO_REFIDX(pRxInfo)&RXINFO_REF_ACL_RSN_BIT)
#endif
		{
			_rtk_fc_aclHeaderInfo_get(dbg_info, sizeof(dbg_info), (RXINFO_REFIDX(pRxInfo)&RXINFO_REF_ACL_RSN_BIT));
		}
		else
			snprintf(dbg_info, sizeof(dbg_info), "(ref:0x%x)", RXINFO_REFIDX(pRxInfo));

		TRACE("SPA(EXT)=%d(%d) EXTMASK(HASH)=0x%x(%d) Rsn=%d%s IntPri=%d",
			pPktHdr->ingressPort.macPortIdx, pPktHdr->ingressPort.macExtPortIdx,
			RXINFO_FB_HASH(pRxInfo),RXINFO_FB_HASH(pRxInfo),RXINFO_REASON(pRxInfo), dbg_info,RXINFO_INT_PRI(pRxInfo));
#else
		TRACE("SPA(EXT)=%d(%d) EXTMASK(HASH)=0x%x(%d) Rsn=%d IntPri=%d",
			pPktHdr->ingressPort.macPortIdx, pPktHdr->ingressPort.macExtPortIdx,
			RXINFO_FB_HASH(pRxInfo),RXINFO_FB_HASH(pRxInfo),RXINFO_REASON(pRxInfo),RXINFO_INT_PRI(pRxInfo));
#endif

	}else {
		TRACE_TXINFO("===== << EGRESS PACKET BOUNDARY(%p) dev %s=====\n", RTSKB_SKB(rtskb), RTSKB_DEV(rtskb)->name);

	}

	TRACE("DA=%pM SA=%pM ETH=%04x len=%d\n        stag=%d(SVID=%d) ctag=%d(VID=%d)",
		&RTSKB_DATA(rtskb)[0], &RTSKB_DATA(rtskb)[6], pPktHdr->ethtype_proto,RTSKB_LEN(rtskb),
		(pPktHdr->svh==NULL)?0:1,(int)pPktHdr->svlanid,(pPktHdr->cvh==NULL)?0:1,(int)pPktHdr->cvlanid);

	if(pPktHdr->outer_eth)
	{
		TRACE("[OUTER_L2] DA=%pM SA=%pM stag=%d ctag=%d",
		pPktHdr->outer_eth->h_dest, pPktHdr->outer_eth->h_source, (pPktHdr->outer_svh==NULL)?0:1,(pPktHdr->outer_cvh==NULL)?0:1);
	}

	// dual info
	if(((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_PPTP) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_L2TP)|| (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_VXLAN) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_GRE_ETH_BR)) && pPktHdr->outer_iph)
	{
		TRACE("Src=%pI4(%d) Dst=%pI4(%d) %s L4_PROTO=0x%02x ",
				&pPktHdr->outer_iph->saddr, (pPktHdr->outer_udph)?ntohs(pPktHdr->outer_udph->source):-1,
				&pPktHdr->outer_iph->daddr, (pPktHdr->outer_udph)?ntohs(pPktHdr->outer_udph->dest):-1,
				(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_PPTP)?"PPTP":((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_L2TP)?"L2TP":((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_VXLAN)?"VXLAN":"GRE_ETH_BR")),
				pPktHdr->outer_iph->protocol
				);
	}
	if((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_DSLITE) && (pPktHdr->ip6h))
	{
		TRACE("Src=%pI6 Dst=%pI6 %s NextHdr=0x%02x ",
				&pPktHdr->ip6h->saddr, &pPktHdr->ip6h->daddr, "DSLite", pPktHdr->ip6h->nexthdr
				);
	}
	// l3/l4 info
	if((pPktHdr->iph)&&(pPktHdr->tcph||pPktHdr->udph))
	{
		TRACE("Src=%pI4(%d) Dst=%pI4(%d) %s L4_PROTO=0x%02x %s%s%s%s%s%s",
			&pPktHdr->iph->saddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->source):ntohs(pPktHdr->udph->source),
			&pPktHdr->iph->daddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->dest):ntohs(pPktHdr->udph->dest),
			pPktHdr->tcph?"TCP":(pPktHdr->udph?"UDP":"OTHER"),
			pPktHdr->iph->protocol,
			(pPktHdr->tcph)?"Flags:":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->syn)?"SYN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->ack)?"ACK":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->psh)?"PUSH":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->fin)?"FIN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->rst)?"RST":""
			);
	}else if(pPktHdr->iph){
		TRACE("Src=%pI4 Dst=%pI4 L4_PROTO=0x%02x",
			&pPktHdr->iph->saddr,
			&pPktHdr->iph->daddr,
			pPktHdr->iph->protocol
			);
	}

	if((pPktHdr->ip6h)&&(pPktHdr->tcph||pPktHdr->udph))
	{
		TRACE("Src=%pI6(%d) Dst=%pI6(%d) %s NextHdr=0x%02x %s%s%s%s%s%s",
			&pPktHdr->ip6h->saddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->source):ntohs(pPktHdr->udph->source),
			&pPktHdr->ip6h->daddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->dest):ntohs(pPktHdr->udph->dest),
			pPktHdr->tcph?"TCP":(pPktHdr->udph?"UDP":"OTHER"),
			pPktHdr->ip6h->nexthdr,
			(pPktHdr->tcph)?"Flags:":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->syn)?"SYN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->ack)?"ACK":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->psh)?"PUSH":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->fin)?"FIN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->rst)?"RST":""
			);
	}
	TRACE("hitSwFwdedAclTrapPri= %s", pPktHdr->isHitSwFwdedAclTrapPri?"TRUE":"FALSE");
}

void _rtk_fc_displayInfo_toPs(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, fc_rx_info_t *pRxInfo, rtk_fc_toPsReason_t toPsReason)
{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	char dbg_info[64] = {0};
#endif

	TOPS("===== >> INGRESS PACKET BOUNDARY(%p) dev %s =====\n", RTSKB_SKB(rtskb), RTSKB_DEV(rtskb)->name);

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_RTL8277C_SERIES)
	if((RXINFO_REASON(pRxInfo) == CPU_REASON_ACL) && (RXINFO_REFIDX(pRxInfo)&RXINFO_REF_ACL_RSN_BIT))
#else
	if(RXINFO_REFIDX(pRxInfo)&RXINFO_REF_ACL_RSN_BIT)
#endif
	{
		_rtk_fc_aclHeaderInfo_get(dbg_info, sizeof(dbg_info), (RXINFO_REFIDX(pRxInfo)&RXINFO_REF_ACL_RSN_BIT));
	}
	else
		snprintf(dbg_info, sizeof(dbg_info), "(ref:0x%x)", RXINFO_REFIDX(pRxInfo));

	TOPS("SPA(EXT)=%d(%d) EXTMASK(HASH)=0x%x(%d) Rsn=%d%s IntPri=%d",
		pPktHdr->ingressPort.macPortIdx, pPktHdr->ingressPort.macExtPortIdx,
		RXINFO_FB_HASH(pRxInfo),RXINFO_FB_HASH(pRxInfo),RXINFO_REASON(pRxInfo), dbg_info,RXINFO_INT_PRI(pRxInfo));
#else
	TOPS("SPA(EXT)=%d(%d) EXTMASK(HASH)=0x%x(%d) Rsn=%d IntPri=%d",
		pPktHdr->ingressPort.macPortIdx, pPktHdr->ingressPort.macExtPortIdx,
		RXINFO_FB_HASH(pRxInfo),RXINFO_FB_HASH(pRxInfo),RXINFO_REASON(pRxInfo),RXINFO_INT_PRI(pRxInfo));
#endif

	TOPS("DA=%pM SA=%pM ETH=%04x len=%d\n        stag=%d(SVID=%d) ctag=%d(VID=%d)",
		&RTSKB_DATA(rtskb)[0], &RTSKB_DATA(rtskb)[6], pPktHdr->ethtype_proto,RTSKB_LEN(rtskb),
		(pPktHdr->svh==NULL)?0:1,(int)pPktHdr->svlanid,(pPktHdr->cvh==NULL)?0:1,(int)pPktHdr->cvlanid);


	// dual info
	if(((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_PPTP) || (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_L2TP)|| (pPktHdr->dualHdrType==RTK_FC_DUALTYPE_VXLAN)) && pPktHdr->outer_iph)
	{
		TOPS("Src=%pI4(%d) Dst=%pI4(%d) %s L4_PROTO=0x%02x ",
				&pPktHdr->outer_iph->saddr, (pPktHdr->outer_udph)?ntohs(pPktHdr->outer_udph->source):-1,
				&pPktHdr->outer_iph->daddr, (pPktHdr->outer_udph)?ntohs(pPktHdr->outer_udph->dest):-1,
				(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_PPTP)?"PPTP":(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_L2TP)?"L2TP":"VXLAN",
				pPktHdr->outer_iph->protocol
				);
	}
	if((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_DSLITE) && (pPktHdr->ip6h))
	{
		TOPS("Src=%pI6 Dst=%pI6 %s NextHdr=0x%02x ",
				&pPktHdr->ip6h->saddr, &pPktHdr->ip6h->daddr, "DSLite", pPktHdr->ip6h->nexthdr
				);
	}
	// l3/l4 info
	if((pPktHdr->iph)&&(pPktHdr->tcph||pPktHdr->udph))
	{
		TOPS("Src=%pI4(%d) Dst=%pI4(%d) %s L4_PROTO=0x%02x %s%s%s%s%s%s",
			&pPktHdr->iph->saddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->source):ntohs(pPktHdr->udph->source),
			&pPktHdr->iph->daddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->dest):ntohs(pPktHdr->udph->dest),
			pPktHdr->tcph?"TCP":(pPktHdr->udph?"UDP":"OTHER"),
			pPktHdr->iph->protocol,
			(pPktHdr->tcph)?"Flags:":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->syn)?"SYN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->ack)?"ACK":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->psh)?"PUSH":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->fin)?"FIN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->rst)?"RST":""
			);
	}else if(pPktHdr->iph){
		TOPS("Src=%pI4 Dst=%pI4 L4_PROTO=0x%02x",
			&pPktHdr->iph->saddr,
			&pPktHdr->iph->daddr,
			pPktHdr->iph->protocol
			);
	}

	if((pPktHdr->ip6h)&&(pPktHdr->tcph||pPktHdr->udph))
	{
		TOPS("Src=%pI6(%d) Dst=%pI6(%d) %s NextHdr=0x%02x %s%s%s%s%s%s",
			&pPktHdr->ip6h->saddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->source):ntohs(pPktHdr->udph->source),
			&pPktHdr->ip6h->daddr, (pPktHdr->tcph)?ntohs(pPktHdr->tcph->dest):ntohs(pPktHdr->udph->dest),
			pPktHdr->tcph?"TCP":(pPktHdr->udph?"UDP":"OTHER"),
			pPktHdr->ip6h->nexthdr,
			(pPktHdr->tcph)?"Flags:":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->syn)?"SYN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->ack)?"ACK":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->psh)?"PUSH":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->fin)?"FIN":"",
			(pPktHdr->tcph)&&(pPktHdr->tcph->rst)?"RST":""
			);
	}

	TOPS("toPsReason is 0x%x", toPsReason);
	if(toPsReason & FC_DBUG_TOPSREASON_PKTPARSE_FAIL)
		TOPS("  To PS reason: packet parsing failed");
	if(toPsReason & FC_DBUG_TOPSREASON_BYPASS_ETHTYPE)
		TOPS("  To PS reason: bypass ethertype");
	if(toPsReason & FC_DBUG_TOPSREASON_UNKNOWN_SMAC)
		TOPS("  To PS reason: unknown SMAC");
	if(toPsReason & FC_DBUG_TOPSREASON_CPU_REASON)
		TOPS("  To PS reason: CPU reason");
	if(toPsReason & FC_DBUG_TOPSREASON_SKIP_SHORTCUT)
		TOPS("  To PS reason: hit shortcut but need ps to handle it, skip learning");
	if(toPsReason & FC_DBUG_TOPSREASON_DIS_SWFWD)
		TOPS("  To PS reason: Disabling sw acceleration mode (HW only mode)");
	if(toPsReason & FC_DBUG_TOPSREASON_SHORTCUT_DPI)
		TOPS("  To PS reason: Foward to PS and do not learn flow again because of shortcut dpi");
	if(toPsReason & FC_DBUG_TOPSREASON_FLOWIDX_FAIL)
		TOPS("  To PS reason: flow index is fail");
	if(toPsReason & FC_DBUG_TOPSREASON_SHORTCUT_MISS)
		TOPS("  To PS reason: shortcut miss");
}


void _rtk_fc_record_ingress_statistic(rtk_fc_pktHdr_t *pPktHdr)
{

	if(pPktHdr->tcph)
	{
		atomic_inc(&fc_db.statistic.perPortCnt_TCP[pPktHdr->ingressPort.macPortIdx]);
		if(pPktHdr->tcph->syn)
		{
			if(pPktHdr->tcph->ack)
				atomic_inc(&fc_db.statistic.perPortCnt_SYN_ACK[pPktHdr->ingressPort.macPortIdx]);
			else
				atomic_inc(&fc_db.statistic.perPortCnt_SYN[pPktHdr->ingressPort.macPortIdx]);
		}
		else if(pPktHdr->tcph->rst)
		{
			if(pPktHdr->tcph->ack)
				atomic_inc(&fc_db.statistic.perPortCnt_RST_ACK[pPktHdr->ingressPort.macPortIdx]);
			else
				atomic_inc(&fc_db.statistic.perPortCnt_RST[pPktHdr->ingressPort.macPortIdx]);
		}
		else if(pPktHdr->tcph->fin)
		{
			if(pPktHdr->tcph->ack)
			{
				if(pPktHdr->tcph->psh)
					atomic_inc(&fc_db.statistic.perPortCnt_FIN_PSH_ACK[pPktHdr->ingressPort.macPortIdx]);
				else
					atomic_inc(&fc_db.statistic.perPortCnt_FIN_ACK[pPktHdr->ingressPort.macPortIdx]);
			}
			else
				atomic_inc(&fc_db.statistic.perPortCnt_FIN[pPktHdr->ingressPort.macPortIdx]);
		}
		else if(pPktHdr->tcph->ack)
		{
			if(pPktHdr->tcph->psh)
			{
				//push ack
				atomic_inc(&fc_db.statistic.perPortCnt_PUSH_ACK[pPktHdr->ingressPort.macPortIdx]);
			}
			else
			{
				atomic_inc(&fc_db.statistic.perPortCnt_ACK[pPktHdr->ingressPort.macPortIdx]);
			}
		}

	}
	else if(pPktHdr->udph)
		atomic_inc(&fc_db.statistic.perPortCnt_UDP[pPktHdr->ingressPort.macPortIdx]);


	if(pPktHdr->isFragment)
		atomic_inc(&fc_db.statistic.perPortCnt_fragment[pPktHdr->ingressPort.macPortIdx]);

	//if((pPktHdr->reason<256)&&(pPktHdr->reason>=0))
		atomic_inc(&fc_db.statistic.perPortCnt_Reason[pPktHdr->reason][pPktHdr->ingressPort.macPortIdx]);


	return;
}

void _rtk_fc_record_egress_statistic(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	struct nf_conn *ct=NULL;
	struct rt_nfconn *rtct=NULL, rt_ct;
	bool isL3 = ((pPktHdr->iph) || (pPktHdr->ip6h)) ? TRUE : FALSE;
	bool isL4 = ((pPktHdr->tcph) || (pPktHdr->udph)) ? TRUE : FALSE;

	if(RTSKB_FCIGRDATA(rtskb)->isNotLocalOut)
	{
		RTK_FC_HOOK_PS_CT_GET(RTSKB_SKB(rtskb), &ct);
		if(ct) {
			rtct = &rt_ct;
			RTK_FC_HOOK_CONVERTER_CT(ct, rtct);
		}

		if(isL3 && isL4 && rtct && rtct->ct)
		{
			if(RTSKB_FCIGRDATA(rtskb)->isDAGatewayMAC && !pPktHdr->isMulticast)
			{
				if(pPktHdr->iph)
				{
					if(test_bit(IPS_SRC_NAT_BIT, &rtct->status) || test_bit(IPS_DST_NAT_BIT, &rtct->status))
						atomic_inc(&fc_db.statistic.perPortCnt_L4FWD[pPktHdr->ingressPort.macPortIdx]);
					else
						atomic_inc(&fc_db.statistic.perPortCnt_IPv4_L3FWD[pPktHdr->ingressPort.macPortIdx]);
				}
				else
				{
					atomic_inc(&fc_db.statistic.perPortCnt_IPv6_L3FWD[pPktHdr->ingressPort.macPortIdx]);
				}
			}
			else
			{
				atomic_inc(&fc_db.statistic.perPortCnt_L2FWD[pPktHdr->ingressPort.macPortIdx]);
			}
		}
		else
		{
			atomic_inc(&fc_db.statistic.perPortCnt_L2FWD[pPktHdr->ingressPort.macPortIdx]);
		}

	}

	return;
}

#if defined(CONFIG_FC_RTL8277C_SERIES)
uint32 _rtk_fc_flow_intf_mapping_idx_get(uint32 hwNetifIdx)
{
	uint32 intf_mapping_idx = hwNetifIdx;

	switch(fc_db.netifHwTbl[hwNetifIdx].dualType)
	{
		case RTK_FC_DUALTYPE_DSLITE:
		case RTK_FC_DUALTYPE_PPTP:
		case RTK_FC_DUALTYPE_L2TP:
		case RTK_FC_DUALTYPE_VXLAN:
		case RTK_FC_DUALTYPE_6RD:
		case RTK_FC_DUALTYPE_MAPT:
			intf_mapping_idx = ((fc_db.netifHwTbl[hwNetifIdx].hwEntryNum==2) ? (32+hwNetifIdx) : (16+hwNetifIdx));
			break;
		default:
			intf_mapping_idx = hwNetifIdx;
			break;
	}
	
	return intf_mapping_idx;
}

#if RTK_FC_TABLESIZE_OVERFLOW_FLOW
int _rtk_fc_overFlowHashListAdd(uint32 addFlowIdx)
{
	rtk_fc_overFlowHash_linkList_t *pOverFlowList;

	if(!((addFlowIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= addFlowIdx)))
	{
		WARNING("Invalid overflow flow index %d", addFlowIdx);
		goto RET_FAILED;
	}

	pOverFlowList = &fc_db.overFlowHashList[addFlowIdx-(fc_db.flowHwTableSize-RTK_FC_TABLESIZE_OVERFLOW_FLOW)];

	//Delete from head list
	list_del_init(&pOverFlowList->flow_list);
	//Add to hash head list
	list_add_tail(&pOverFlowList->flow_list, &fc_db.overFlowHash_inUseListHead);

	DEBUG("add overflow hash[%d] to overFlowHash_inUseListHead\n", addFlowIdx);

	return SUCCESS;

RET_FAILED:
	return FAILED;
}

int _rtk_fc_overFlowHashListDel(uint32 delFlowIdx)
{
	rtk_fc_overFlowHash_linkList_t *pOverFlowList;

	if(!((delFlowIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= delFlowIdx)))
	{
		WARNING("Invalid overflow flow index %d", delFlowIdx);
		goto RET_FAILED;
	}

	pOverFlowList = &fc_db.overFlowHashList[delFlowIdx-(fc_db.flowHwTableSize-RTK_FC_TABLESIZE_OVERFLOW_FLOW)];

	//Delete from head list
	list_del_init(&pOverFlowList->flow_list);

	//Add to hash head list
	list_add_tail(&pOverFlowList->flow_list, &fc_db.overFlowHash_freeListHead);

	DEBUG("free overflow hash[%d] to overFlowHash_freeListHead\n", delFlowIdx);

	return SUCCESS;

RET_FAILED:
	return FAILED;
}
#endif
#endif

int _rtk_fc_swFlowListAdd(uint32 flowHashListIdx, uint32 addFlowIdx)
{
	rtk_fc_swFlow_linkList_t *pFlowList;


	if(!(flowHashListIdx<RTK_SW_FLOW_LIST_HEAD_COUNT))
		goto RET_FAILED;
	if(!(fc_db.flowHwTableSize<=addFlowIdx && addFlowIdx<fc_db.flowSwTableSize))
		goto RET_FAILED;

	pFlowList = &fc_db.swFlowList[addFlowIdx-fc_db.flowHwTableSize];
	
	//Delete from head list
	list_del_init(&pFlowList->flow_list);
	//Add to hash head list
	list_add_tail(&pFlowList->flow_list, &fc_db.swFlow_hashListHead[flowHashListIdx]);

	DEBUG("add sw flow[%d] to swFlow_hashListHead[%d]\n", addFlowIdx, flowHashListIdx);
	
	return SUCCESS;

RET_FAILED:
	return FAILED;
}

int _rtk_fc_swFlowListDel(uint32 delFlowIdx)
{
	rtk_fc_swFlow_linkList_t *pFlowList;


	if(!(fc_db.flowHwTableSize<=delFlowIdx && delFlowIdx<fc_db.flowSwTableSize))
		goto RET_FAILED;

	pFlowList = &fc_db.swFlowList[delFlowIdx-fc_db.flowHwTableSize];

	//Delete from head list
	list_del_init(&pFlowList->flow_list);

	//Add to hash head list
	list_add_tail(&pFlowList->flow_list, &fc_db.swFlow_freeListHead);

	DEBUG("free sw flow[%d] to swFlow_freeListHead\n", delFlowIdx);

	return SUCCESS;

RET_FAILED:
	return FAILED;
}


//COPY FROM rtk_fc_flow_searchByIngressPktHdr
__IRAM_FC_SHORTCUT
rtk_fc_flowEntSearchReturn_t rtk_fc_abstrSwflow_searchByIngressPktHdr(uint32 flowHashIdx, rtk_fc_pktHdr_t *pPktHdr,uint32* flowTblIdx)
{
	int flowTypeSel=FAIL,flowTypePri=FAIL;
	int search_index,i;
	rtk_fc_abstrSwFlowPattern_entry_t swFlowPattern[ABSTR_SWFLOW_TYPE_SIZE];
	rtk_fc_swFlow_linkList_t *pFlowEntry=NULL;

	for(i=0;i<ABSTR_SWFLOW_TYPE_SIZE;i++)
	{
		if(!fc_db.abstrSwFlowType[i].valid)
			break;
		if(rtk_fc_abstrSwFlowPatternGenByPktHdr(pPktHdr,&swFlowPattern[i],i)==SUCCESS)
		{
			if(fc_db.abstrSwFlowType[i].flowTypePri > flowTypePri)
			{
				flowTypeSel=i;
				flowTypePri=fc_db.abstrSwFlowType[i].flowTypePri;
			}
		}
	}
	if(flowTypeSel==FAIL)
		return RTK_FC_FLOWENT_SEARCH_FAIL;


	if(!list_empty(&fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)]))
	{
		list_for_each_entry(pFlowEntry, &fc_db.swFlow_hashListHead[RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(flowHashIdx)], flow_list)	//just return the first entry right behind of head
		{
			search_index = pFlowEntry->idx;
			if(fc_db.flowTbl[search_index].pAbstrSwFlowEt && memcmp(&fc_db.flowTbl[search_index].pAbstrSwFlowEt->swFlowKey,&swFlowPattern[flowTypeSel],sizeof(rtk_fc_abstrSwFlowPattern_entry_t))==0)
			{
				TRACE("Match AbstrSwflow[%d]",search_index);
				fc_db.flowTbl[search_index].swTrfBit = TRUE;
				*flowTblIdx =search_index;
				return RTK_FC_FLOWENT_SEARCH_SW;
			}
		}
	}

	return RTK_FC_FLOWENT_SEARCH_FAIL;
}

//COPY FROM _rtk_fc_shortCutCheck
__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_abstrSwShortCutCheck(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	uint32 flowTblIdx=FAIL;
	rtk_fc_flowEntSearchReturn_t result = RTK_FC_FLOWENT_SEARCH_FAIL;
	int ret = 0;
	uint8 acl_trap_bypass_shortcut = TRUE;

	TRACE("Check shortcut, flowHashIdx=%d", pPktHdr->flowHashIdx);

	result = rtk_fc_abstrSwflow_searchByIngressPktHdr(pPktHdr->flowHashIdx, pPktHdr,&flowTblIdx);
	if(unlikely(result == RTK_FC_FLOWENT_SEARCH_FAIL))
		return RTK_FC_RET_LRN_SHORTCUT_MISS;
		
	if(unlikely(flowTblIdx >= (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE))) {
		WARNING("flowTblIdx out of range!\n");
		return RTK_FC_RET_LRN_SHORTCUT_MISS;
	}

	// hit shortcut!
	FLOW_SHORTCUT_HIT(pPktHdr);
	
	if(unlikely(fc_db.fwdStatistic))
	{
		if(pPktHdr->ip6h)
			atomic_inc(&fc_db.statistic.perPortCnt_shortcutV6[pPktHdr->ingressPort.macPortIdx]);
		else
			atomic_inc(&fc_db.statistic.perPortCnt_shortcut[pPktHdr->ingressPort.macPortIdx]);
	}

	if(unlikely(pPktHdr->isHitSwFwdedAclTrapPri))
	{
		acl_trap_bypass_shortcut = FALSE;
	}
	else if(unlikely(pPktHdr->icmph && ((pPktHdr->icmph->type == 0 || pPktHdr->icmph->type == 8)	&& pPktHdr->dmacToGatewayMAC) ))
	{
		acl_trap_bypass_shortcut = FALSE;
		TRACE("ICMP shortCut! type: %d, dmacToGateway: %d", pPktHdr->icmph->type, pPktHdr->dmacToGatewayMAC);
	}
	else if(unlikely(pPktHdr->icmp6h && ((pPktHdr->icmp6h->icmp6_type == 129 || pPktHdr->icmp6h->icmp6_type == 128) && pPktHdr->dmacToGatewayMAC)))
	{
		acl_trap_bypass_shortcut = FALSE;
		TRACE("ICMPv6 shortCut! type: %d, dmacToGateway: %d", pPktHdr->icmp6h->icmp6_type, pPktHdr->dmacToGatewayMAC);
	}
	
	if(unlikely((pPktHdr->reason == CPU_REASON_ACL) && acl_trap_bypass_shortcut)) 
		return RTK_FC_RET_LRN_SKIP_CTRLPKT;

#if defined(CONFIG_RTK_SOC_RTL8198D)
	if(pPktHdr->isMulticast)
	{
		//skip forward by softflow if hit user group address
		if((pPktHdr->ip6h)&&(rtk_fc_get_user_group(&pPktHdr->ip6h->daddr.s6_addr32[0], 1) == 0))
			return RTK_FC_RET_LRN_SHORTCUT_MISS;
		else if((pPktHdr->iph)&&(rtk_fc_get_user_group(&pPktHdr->iph->daddr, 0) == 0))
			return RTK_FC_RET_LRN_SHORTCUT_MISS;
	}
#endif
	

	/*
		Disable SW acc mode, this flow hit short cut in ingress learning but do not modify it & direct TX it,
		so let FC not cache ingress data to not add the same flow again.
	*/
	if(unlikely(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_HW_ONLY))
	{
		DEBUG("HWNAT Mode: Disable sw acceleration (HW acceleration Only), skip shorcut but set flow entry valid.");
		return RTK_FC_RET_LRN_DISABLE_SW_ACCELERATION;
	}


	/*
	*	Short Cut DPI Before modification Here
	*
	*	Hit Shortcut but not modify packet content yet
	*	here, support 3 types of return value from dpi external function:
	*	1. Trap 	 :	Trap to protocol stack, but won't learn flow again.
	*	2. Continue  :	Continue the unfinished shortcut checking and filling job
	*	3. Drop 	 :	Drop the packet.
	*/
	if(fc_db.flow_callback_func.cbShortcut_before)
	{
		rt_cbFunc_flow_info_t cbFunc_info;
		int shortCut_dpi_ret = 0;
		
		//memset(&cbFunc_info, 0, sizeof(rt_cbFunc_flow_info_t));
		cbFunc_info.cachedCt			= fc_db.flowTbl[flowTblIdx].cachedCt;
		cbFunc_info.flowIdx 			= flowTblIdx;
		cbFunc_info.flow_extra_info 	= fc_db.flowTbl[flowTblIdx].flow_extra_info;
	
		shortCut_dpi_ret = fc_db.flow_callback_func.cbShortcut_before(rtskb->skb, cbFunc_info);
	
		switch(shortCut_dpi_ret)
		{
			case RT_FLOW_CB_FUNC_RET_TRAP:
				DEBUG("[SHORTCUT DPI]Trap to CPU after DPI");
				return RTK_FC_RET_LRN_TRAP_TO_PS;
				break;
			case RT_FLOW_CB_FUNC_RET_CONTINUE:
				DEBUG("[SHORTCUT DPI]Continue shortcut after DPI");
				break;
			case RT_FLOW_CB_FUNC_RET_DROP:
				DEBUG("[SHORTCUT DPI]Drop packet after DPI");
				return RTK_FC_RET_DROP_CALLBACK_FUNC;
				break;
			default:
				break;
		}
	}



	// [CPU_REASON_MTU] skip if over egress intf MTU
#if 0	
	if((fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.valid) && fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.intf_mtu_check)
	{
		int l2PayloadSize = pPktHdr->l2PayloadLen;
		int intfMTU = fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.intf_mtu;


		if(l2PayloadSize > intfMTU)
		{	//l2PayloadSize > (1500-40)
			{
				TRACE("[SC] Over netif[%d] MTU (%d > %d)", flowTable.pFlowEntry->path1.out_intf_idx, l2PayloadSize, intfMTU);
				return RTK_FC_RET_LRN_SKIP_SHORTCUT;
			}
		}
	}
#endif

	// modify packet and forward by nic dirtx
	if((ret = rtk_fc_abstrSw_flowModifyAndDirTx(rtskb, pPktHdr,flowTblIdx)) != RTK_FC_RET_OK)
	{
		TRACE("dritx fail! ret = %d", ret);
	}else{
		ret = RTK_FC_RET_LRN_SHORTCUT_TX;
	}


	return ret;
}



rtk_fc_ret_t rtk_fc_shortCut_setG3IgrExtraInfo(rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, rtk_fc_g3IgrExtraInfo_t *path4_pG3IgrExtraInfo, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *flowTable,uint32 flowTblMutiActIdx, rtk_fc_tableFlow_t *flowTable_multiAction)
{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	/*prepare info that are used when adding G3 HW*/

	_rtk_fc_g3IgrExtraInfo_init(pG3IgrExtraInfo);
	pG3IgrExtraInfo->lutIgrSaIdx = flowTable->lutIgrSaIdx;
	pG3IgrExtraInfo->lutEgrDaIdx = flowTable->lutEgrDaIdx;
	pG3IgrExtraInfo->svlan_id = (pPktHdr->svh) ? pPktHdr->svlanid : 0;
	pG3IgrExtraInfo->cvlan_id = (pPktHdr->cvh) ? pPktHdr->cvlanid : 0;
	if((flowTable->pFlowEntry->path3.in_path==FB_PATH_34)||(flowTable->pFlowEntry->path3.in_path==FB_PATH_5))
	{
		if(flowTable->pFlowEntry->path3.in_pppoeif)
			pG3IgrExtraInfo->pppoe_session_id = (pPktHdr->ppph)?(ntohs(pPktHdr->ppph->sid)):0;

		if(flowTable->pFlowEntry->path3.in_ipv4_or_ipv6)
		{
#if	defined(CONFIG_FC_CA8277B_SERIES)
			if(flowTable->protoCtrl == FLOW_PROTO_CTRL_V6NAT && flowTable->ipv6_nat_indirect_mapping_index!=0)
			{
				if(flowTable->pFlowEntry->path5.out_l4_direction == 1)//Upstream
				{
					TRACE("IPV6 SNAT! Sip-before %pI6c Sip-After %pI6c\n", (&(pPktHdr->ip6h->saddr)), (&(fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].addr)));
					memcpy(&pG3IgrExtraInfo->ipv6_Saddr, &pPktHdr->ip6h->saddr, sizeof(struct in6_addr));
					memcpy(&pG3IgrExtraInfo->ipv6_Daddr, &pPktHdr->ip6h->daddr, sizeof(struct in6_addr));
					memcpy(&pG3IgrExtraInfo->ipv6_nat_addr,  &fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].addr, sizeof(struct in6_addr));
				}
				else if (flowTable->pFlowEntry->path5.out_l4_direction == 0) //DownStream
				{
					TRACE("IPV6 DNAT! Dip-before %pI6c Dip-After %pI6c\n", (&(pPktHdr->ip6h->daddr)), (&(fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].addr)));
					memcpy(&pG3IgrExtraInfo->ipv6_Saddr, &pPktHdr->ip6h->saddr, sizeof(struct in6_addr));
					memcpy(&pG3IgrExtraInfo->ipv6_Daddr, &pPktHdr->ip6h->daddr, sizeof(struct in6_addr));
					memcpy(&pG3IgrExtraInfo->ipv6_nat_addr,  &fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].addr, sizeof(struct in6_addr));
				}
			}
			else
#endif
			{
				//do not consider Ipv6 NAT case, use original IPv6 SIP and DIP
				memcpy(&pG3IgrExtraInfo->ipv6_Saddr, &pPktHdr->ip6h->saddr, sizeof(struct in6_addr));
				memcpy(&pG3IgrExtraInfo->ipv6_Daddr, &pPktHdr->ip6h->daddr, sizeof(struct in6_addr));
			}
		}
		else
		{
			pG3IgrExtraInfo->ipv6_Saddr.s6_addr32[0] = flowTable->pFlowEntry->path3.in_src_ipv4_addr;
			pG3IgrExtraInfo->ipv6_Daddr.s6_addr32[0] = flowTable->pFlowEntry->path3.in_dst_ipv4_addr;
		}
	}
	pG3IgrExtraInfo->ingressSaHostPolIdx = flowTable->ingressSaHostPolIdx;
	pG3IgrExtraInfo->egressDaHostPolIdx = flowTable->egressDaHostPolIdx;

	if(!fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI])
		pG3IgrExtraInfo->svlan_pri = flowTable->svlan_pri;

	if(!fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI])
	{
		pG3IgrExtraInfo->igr_svlan_dei = flowTable->igr_svlan_dei;
		pG3IgrExtraInfo->igr_cvlan_cfi = flowTable->igr_cvlan_cfi;
	}
	pG3IgrExtraInfo->egr_svlan_dei = flowTable->egr_svlan_dei;
	pG3IgrExtraInfo->egr_cvlan_cfi = flowTable->egr_cvlan_cfi;
	pG3IgrExtraInfo->igr_svlan_tpid_sel = flowTable->igr_stpid_sel;
	pG3IgrExtraInfo->egr_svlan_tpid_sel = flowTable->egr_stpid_sel;
	pG3IgrExtraInfo->egr_tos_ecn_remark = flowTable->egr_tos_ecn_remark;
	pG3IgrExtraInfo->egr_tos_ecn = flowTable->egr_tos_ecn;
	pG3IgrExtraInfo->pon_stream_id = flowTable->pon_stream_id;

#if defined(CONFIG_FC_RTL8277C_SERIES)

	if(flowTable->protoCtrl == FLOW_PROTO_CTRL_L2DUAL && flowTable->l2Dual_table_info.l2Dual_table_index != 0)
	{
		DEBUG("VXLAN upstream");	
		pG3IgrExtraInfo->l2Dual_type = RTK_FC_L2DUAL_TYPE_VXLAN;

		if(fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].action == RTK_FC_L2DUAL_ACT_ADD)
		{
			pG3IgrExtraInfo->l2Dual_action = RTK_FC_L2DUAL_ACT_ADD;
			pG3IgrExtraInfo->vxlan_info.outer_srcPort 		= fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].vxlan_us.outer_udph_sport;
			pG3IgrExtraInfo->vxlan_info.ingress_intf_idx	= fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].vxlan_us.ingress_intf_idx;
			pG3IgrExtraInfo->vxlan_info.egress_intf_idx		= fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].vxlan_us.egress_intf_idx;
		}
		else if(fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].action == RTK_FC_L2DUAL_ACT_REMOVE)
		{
			pG3IgrExtraInfo->l2Dual_action = RTK_FC_L2DUAL_ACT_REMOVE;
			pG3IgrExtraInfo->vxlan_info.ingress_intf_idx	= fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].vxlan_ds.ingress_intf_idx;
			pG3IgrExtraInfo->vxlan_info.egress_intf_idx		= fc_db.l2DualTbl[flowTable->l2Dual_table_info.l2Dual_table_index].vxlan_ds.egress_intf_idx;
		}
	}
			
	if(flowTable->protoCtrl == FLOW_PROTO_CTRL_V6NAT && flowTable->ipv6_nat_indirect_mapping_index!=0)
	{
		if(fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].isNPTv6)
		{
			pG3IgrExtraInfo->naptv6_info.wan_prefix_len 	= fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].wan_prefix_len;
			pG3IgrExtraInfo->naptv6_info.lan_prefix_len 	= fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].lan_prefix_len;
			pG3IgrExtraInfo->naptv6_info.isNPTv6 			= fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].isNPTv6;	
			pG3IgrExtraInfo->naptv6_info.prefix_idx 		= fc_db.ipv6_nat_mappingTbl[flowTable->ipv6_nat_indirect_mapping_index].prefix_idx;	
			
			DEBUG("[NPTv6]wan_prefix_len: %d, lan_prefix_len:%d, isNPTv6: %d",pG3IgrExtraInfo->naptv6_info.wan_prefix_len, pG3IgrExtraInfo->naptv6_info.lan_prefix_len, pG3IgrExtraInfo->naptv6_info.isNPTv6);
		}
		
	}
#endif



#endif



	if(unlikely(flowTblMutiActIdx != FAIL))
	{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)

		_rtk_fc_g3IgrExtraInfo_init(path4_pG3IgrExtraInfo);
		path4_pG3IgrExtraInfo->lutIgrSaIdx = flowTable_multiAction->lutIgrSaIdx;
		path4_pG3IgrExtraInfo->lutEgrDaIdx = flowTable_multiAction->lutEgrDaIdx;
		path4_pG3IgrExtraInfo->svlan_id = (pPktHdr->svh) ? pPktHdr->svlanid : 0;
		path4_pG3IgrExtraInfo->cvlan_id = (pPktHdr->cvh) ? pPktHdr->cvlanid : 0;

		if(((flowTable_multiAction->pFlowEntry->path3.in_path==FB_PATH_34)||(flowTable_multiAction->pFlowEntry->path3.in_path==FB_PATH_5)) && flowTable_multiAction->pFlowEntry->path3.in_pppoeif)
			path4_pG3IgrExtraInfo->pppoe_session_id = (pPktHdr->ppph)?(ntohs(pPktHdr->ppph->sid)):0;
		if(!fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_SPRI])
			path4_pG3IgrExtraInfo->svlan_pri = flowTable_multiAction->svlan_pri;
		if(!fc_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATHALL_SKIP_VLAN_DEICFI])
		{
			path4_pG3IgrExtraInfo->igr_svlan_dei = flowTable_multiAction->igr_svlan_dei;
			path4_pG3IgrExtraInfo->igr_cvlan_cfi = flowTable_multiAction->igr_cvlan_cfi;
		}
		path4_pG3IgrExtraInfo->egr_svlan_dei = flowTable_multiAction->egr_svlan_dei;
		path4_pG3IgrExtraInfo->egr_cvlan_cfi = flowTable_multiAction->egr_cvlan_cfi;
		path4_pG3IgrExtraInfo->igr_svlan_tpid_sel = flowTable_multiAction->igr_stpid_sel;
		path4_pG3IgrExtraInfo->egr_svlan_tpid_sel = flowTable_multiAction->egr_stpid_sel;
		path4_pG3IgrExtraInfo->egr_tos_ecn_remark = flowTable_multiAction->egr_tos_ecn_remark;
		path4_pG3IgrExtraInfo->egr_tos_ecn = flowTable_multiAction->egr_tos_ecn;
		path4_pG3IgrExtraInfo->pon_stream_id = flowTable_multiAction->pon_stream_id;
		if(((flowTable_multiAction->pFlowEntry->path3.in_path==FB_PATH_34)||(flowTable_multiAction->pFlowEntry->path3.in_path==FB_PATH_5)) && flowTable_multiAction->pFlowEntry->path3.in_ipv4_or_ipv6)
		{
			//do not consider Ipv6 NAT case, use original IPv6 SIP and DIP
			memcpy(&path4_pG3IgrExtraInfo->ipv6_Saddr, &pPktHdr->ip6h->saddr, sizeof(struct in6_addr));
			memcpy(&path4_pG3IgrExtraInfo->ipv6_Daddr, &pPktHdr->ip6h->daddr, sizeof(struct in6_addr));
		}
		else if(((flowTable_multiAction->pFlowEntry->path3.in_path==FB_PATH_34)||(flowTable_multiAction->pFlowEntry->path3.in_path==FB_PATH_5)) && !flowTable_multiAction->pFlowEntry->path3.in_ipv4_or_ipv6)
		{
			path4_pG3IgrExtraInfo->ipv6_Saddr.s6_addr32[0] = flowTable_multiAction->pFlowEntry->path3.in_src_ipv4_addr;
			path4_pG3IgrExtraInfo->ipv6_Daddr.s6_addr32[0] = flowTable_multiAction->pFlowEntry->path3.in_dst_ipv4_addr;
		}

#endif

	}
#if defined(CONFIG_FC_RTL8277C_SERIES)
	pG3IgrExtraInfo->crc16 = pPktHdr->flowHashIdx;
	pG3IgrExtraInfo->crc32 = pPktHdr->crc32;
#endif

	return RTK_FC_RET_OK;
	
}

rtk_fc_ret_t rtk_fc_shortcut_candidate_update_to_hw(rtk_fc_pktHdr_t *pPktHdr,
										uint32 flowTblIdx, rtk_fc_tableFlow_t *flowTable, 
										uint32 flowTblMutiActIdx, rtk_fc_tableFlow_t *flowTable_multiAction, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, rtk_fc_g3IgrExtraInfo_t *path4_pG3IgrExtraInfo)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	if(fc_db.flowTbl[flowTblIdx].candidateState==CANDIDATE_STATE_NONE)
#else
	if(!fc_db.flowTbl[flowTblIdx].pFlowEntry->path1.valid)
#endif
	{
		// Due to the global lock range, flow may be delete between shortcut hit and rtk_fc_shortcut_candidate_update_to_hw(). Check if flow valid first.
		TRACE("[Candidate] flow may be deleted. Do nothing here.");
		return ret;
	}

	flowTable->pFlowEntry->path1.valid = TRUE;
	ASSERT_EQ(RTK_RG_ASIC_FLOWPATH_SET(&flowTblIdx, &flowTable->pFlowEntry->path1, pG3IgrExtraInfo, FLOW_INFO_IS_SET(flowTable, FLOW_INFO_SOFTWARE_ONLY)), RTK_FC_RET_OK);
	
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
	flowTable->candidateState = CANDIDATE_STATE_READY;
	fc_db.flowTbl[flowTblIdx].candidateState = CANDIDATE_STATE_READY;
#endif
	TRACE("[Candidate] update flow[%d] to HW", flowTblIdx);

	if(unlikely(flowTblMutiActIdx != FAIL))
	{
		flowTable_multiAction->pFlowEntry->path1.valid = TRUE;
		ASSERT_EQ(RTK_RG_ASIC_FLOWPATH_SET(&flowTblMutiActIdx, &flowTable_multiAction->pFlowEntry->path1, path4_pG3IgrExtraInfo, FLOW_INFO_IS_SET(flowTable_multiAction, FLOW_INFO_SOFTWARE_ONLY)), RTK_FC_RET_OK);
#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
		flowTable_multiAction->candidateState = CANDIDATE_STATE_READY;
		fc_db.flowTbl[flowTblMutiActIdx].candidateState = CANDIDATE_STATE_READY;
#endif
		TRACE("[Candidate] update Multiple action flow[%d] to HW", flowTblIdx);
	}

	return ret;
}



rtk_fc_ret_t rtk_fc_shortcut_candidate_update_check(			uint32 flowTblIdx, rtk_fc_tableFlow_t *flowTable, uint8 *pDoUpdateToHw)
{
	if(unlikely(!flowTable->pFlowEntry->path1.valid)){

		if(flowTable->candidateState == CANDIDATE_STATE_NEW) // 0: ps add flow which valid bit is 0; 1: shortcut; 2:shortcut and set valid bit to 1;
		{
			fc_db.flowTbl[flowTblIdx].flow_hit_times++;
			DEBUG("flowTbl[%d] hit shortcut %d times", flowTblIdx, fc_db.flowTbl[flowTblIdx].flow_hit_times);
			
			if(fc_db.controlFuc.flow_delay_hit_num > 0 && (fc_db.flowTbl[flowTblIdx].flow_hit_times < fc_db.controlFuc.flow_delay_hit_num) ){
				if (fc_db.controlFuc.flow_delay_mode == RTK_FC_KERNEL_DELEY_MODE) {
					DEBUG("Skip shortcut, delay to fc flow table, need to hit %d times shortcut, %d times left.", 
						fc_db.controlFuc.flow_delay_hit_num,
						fc_db.controlFuc.flow_delay_hit_num - fc_db.flowTbl[flowTblIdx].flow_hit_times);
						return RTK_FC_RET_LRN_SHORTCUT_MISS;
				}
				else {
					DEBUG("Delay to hw flow table, need to hit %d times shortcut, %d times left.", 
						fc_db.controlFuc.flow_delay_hit_num,
						fc_db.controlFuc.flow_delay_hit_num - fc_db.flowTbl[flowTblIdx].flow_hit_times);
				}
			}
			else if(fc_db.controlFuc.flow_delay_hit_num==0 || fc_db.flowTbl[flowTblIdx].flow_hit_times == fc_db.controlFuc.flow_delay_hit_num){
					
				if(fc_db.controlFuc.flow_delay_hit_num)
					DEBUG("Delay to hw flow table, already hit %d times shortcut and ready to enable hw acceleration.", 
							fc_db.controlFuc.flow_delay_hit_num);

				*pDoUpdateToHw = TRUE;
				TRACE("[Candidate] hit flow[%d] and ready to be accelerated by HW, update to HW later", flowTblIdx);
			}
			// continue shortcut tx
		}
	}

	return RTK_FC_RET_OK;
}
#if defined(CONFIG_FC_RTL8277C_SERIES)
int rtk_fc_tcp_rst_reverseFlow_delete(rtk_fc_tableFlow_t *pFlowTable, uint32 flowTblIdx)
{
	uint32 ct_hash = 0, find = 0, reverse_flow_index = 0;
	rtk_fc_ct_hash_info_t *pTmp_ct_hash_list, *pTmp_next_ct_hash_list;
	int ret;
	
	if(pFlowTable->cachedCt == NULL)
		return SUCCESS;
	
	ct_hash = (((uint32)(uintptr_t)pFlowTable->cachedCt) >> 12)&0xff; // should be 0~255
	
	if(!list_empty(&fc_db.ct_hash_info_ListHead[ct_hash]))
	{
		list_for_each_entry_safe(pTmp_ct_hash_list, pTmp_next_ct_hash_list, &fc_db.ct_hash_info_ListHead[ct_hash], ct_hash_list)	//just return the first entry right behind of head
		{
			if(pTmp_ct_hash_list->ct == pFlowTable->cachedCt)
			{
				DEBUG("Find!!flowTblIdx = %d",flowTblIdx);
				
				if(flowTblIdx == pTmp_ct_hash_list->upstream_flow_index)
				{
					DEBUG("Cached downstream flow index = %d ct = %p",pTmp_ct_hash_list->downstream_flow_index, pTmp_ct_hash_list->ct);
					reverse_flow_index = pTmp_ct_hash_list->downstream_flow_index;
					find = 1;
				}
				else if(flowTblIdx == pTmp_ct_hash_list->downstream_flow_index)
				{
					DEBUG("Cached upstream flow index = %d ct = %p",pTmp_ct_hash_list->upstream_flow_index, pTmp_ct_hash_list->ct);
					reverse_flow_index = pTmp_ct_hash_list->upstream_flow_index;
					find = 1;
				}
					
				break;
			}
		}
	}
	if(find == 1)
	{
		{
			RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_index);
			//ASSERT_EQ(rtk_fc_flow_delete(reverse_flow_real_index), RTK_FC_RET_OK);
			ret = rtk_fc_flow_delete(reverse_flow_index);
			if(ret != RTK_FC_RET_OK)
			{
				WARNING("TCP RST Reverse delete flow[%d] failed! ret = %x", reverse_flow_index, ret);

				RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_index);
				return ret;
			}
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_index);

		}
	}
	return RTK_FC_RET_OK;
}
#else
#if 0
__IRAM_FC_SHORTCUT
int rtk_fc_tcp_rst_reverseFlow_delete(rtk_fc_tableFlow_t *pFlowTable, uint32 flowTblIdx, uint32 in_path, rtk_fc_pktHdr_t *pPktHdr)
{
	int reverse_flow_real_index = FAIL, ret =0 ;
	uint32 hashIdx_reverse; // before shift

	if((pPktHdr->iph==NULL) && (pPktHdr->ip6h==NULL))
		goto DEL_REV_FLOW;
	
	if(pFlowTable->pFlowEntry->path1.in_path == FB_PATH_5)
	{
		
		int direction;
		int find = 0, i;
		rtk_fc_tableFlowEntry_t flowPathEntry;
		uint16 igrSVID, igrCVID, lutDaIdx_gmacChk;
		
		uint16 param1=0, param2=0;
		uint32 param3=0, param4=0;
		uint32 extraItem=0;
		uint32 search_index=0;
		
		lutDaIdx_gmacChk = 0; //only path34 care
		igrSVID = pFlowTable->pFlowEntry->path5.out_svid_format_act ==1?pFlowTable->pFlowEntry->path5.out_svlan_id:0;
		igrCVID = pFlowTable->pFlowEntry->path5.out_cvid_format_act ==1?pFlowTable->pFlowEntry->path5.out_cvlan_id:0;
		memset(&flowPathEntry, 0 , sizeof(rtk_fc_tableFlowEntry_t));
		/*
		* 1. Get hash index related information about reverse-flow from incoming flow 
		* 2. Setting  parameter for calculating Hash index
		*/
		{
			direction = (pFlowTable->pFlowEntry->path5.out_l4_direction==1) ? RTK_FC_FLOW_DIRECTION_UPSTREAM : RTK_FC_FLOW_DIRECTION_DOWNSTREAM;
			
			flowPathEntry.path1.in_path=FB_PATH_5;
			flowPathEntry.path5.in_l4proto			= 1;						   //tcp			
			flowPathEntry.path5.in_cvlan_pri		= pFlowTable->pFlowEntry->path5.out_cpri_format_act ==1?pFlowTable->pFlowEntry->path5.out_cpri:0;
			flowPathEntry.path5.in_tos				= (pPktHdr->iph) ? pPktHdr->iph->tos : (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));
								

			if(direction==RTK_FC_FLOW_DIRECTION_UPSTREAM) {
				param1 = pFlowTable->pFlowEntry->path5.in_l4_dst_port;
				param2 = pFlowTable->pFlowEntry->path5.out_l4_port;
				param3 = pFlowTable->pFlowEntry->path5.in_dst_ipv4_addr;
				param4 = (pPktHdr->iph) ? fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.gateway_ipv4_addr : pFlowTable->pFlowEntry->path5.in_src_ipv4_addr;
				extraItem = _rtk_fc_sw_flowHashPath5ExtraItem_get(&flowPathEntry.path5, igrSVID, igrCVID);
				
			} else if (direction==RTK_FC_FLOW_DIRECTION_DOWNSTREAM) {
				// get upstream setting.
				param1 = pFlowTable->pFlowEntry->path5.out_l4_port;
				param2 = pFlowTable->pFlowEntry->path5.in_l4_src_port;
				param3 = pFlowTable->pFlowEntry->path5.out_dst_ipv4_addr;
				param4 =  (pPktHdr->iph) ?pFlowTable->pFlowEntry->path5.out_dst_ipv4_addr : pFlowTable->pFlowEntry->path5.in_dst_ipv4_addr;
				extraItem = _rtk_fc_sw_flowHashPath5ExtraItem_get(&flowPathEntry.path5, igrSVID, igrCVID);
			
			}
		}
		/*
		*  3. Get hash index
		*/
		{
			hashIdx_reverse = _rtk_fc_sw_flowHashIndexStep1_get(param1, param2, param3, param4, extraItem);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			// 32K hash value point to 64K entry
			hashIdx_reverse <<= fc_db.flowHashWayShift;
#endif

		}
		TRACE("[TCP][RESET]Reverse flow hash idx = %d\n", hashIdx_reverse);

		/*
		*	3. Search reverse flow and check ct is the same or not.
		*
		*/
		if(pFlowTable->cachedCt!=NULL)
		{
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				search_index = hashIdx_reverse+i;
				
				if(fc_db.flowTbl[search_index].cachedCt == pFlowTable->cachedCt)
				{
					// CT match, but still need to check ip and port
					
					int match = 0;
					
					match = rtk_fc_reverse_flow_path5_match(direction, search_index, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = search_index;
						break;
					}
				}
			}
		}
		else
		{ 
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				int match = 0;
				
				search_index = hashIdx_reverse+i;
				
				match = rtk_fc_reverse_flow_path5_match(direction, search_index, pFlowTable);
				if(match == 1)
				{
					find = 1;
					reverse_flow_real_index = search_index;
					break;
				}
			}
		}
		
		if((find == 0) && fc_db.shortcut_flow_count > 0)
		{

			uint32 flow_hashListHead=RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(hashIdx_reverse);
			
			rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;
			/*
			* 	Related hash index flow table is not the correct reverse-flow: So need to search sw Flow list
			*/
			
			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[flow_hashListHead], flow_list)	//just return the first entry right behind of head
			{
				if((pFlowTable->cachedCt!=NULL && fc_db.flowTbl[pFlowEntry->idx].cachedCt ==  pFlowTable->cachedCt) || (pFlowTable->cachedCt==NULL )){
					
					int match = 0;
					
					match = rtk_fc_reverse_flow_path5_match(direction, pFlowEntry->idx, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = pFlowEntry->idx;
						break;
					}
				}
			}
					
		}
	}
	else if(pFlowTable->pFlowEntry->path1.in_path == FB_PATH_34)
	{
		int find = 0, i ;
		rtk_fc_tableFlowEntry_t flowPathEntry;
		uint16 igrSVID, igrCVID, lutDaIdx_gmacChk;
		uint16 param1=0, param2=0;
		uint32 param3=0, param4=0;
		uint32 extraItem=0;
		uint32 search_index=0;
		
		lutDaIdx_gmacChk = 0; //only path34 care
		igrSVID = pFlowTable->pFlowEntry->path3.out_svid_format_act ==1?pFlowTable->pFlowEntry->path3.out_svlan_id:0;
		igrCVID = pFlowTable->pFlowEntry->path3.out_cvid_format_act ==1?pFlowTable->pFlowEntry->path3.out_cvlan_id:0;
		//lutDaIdx_gmacChk = (pPktHdr->dmacToGatewayMAC)?1:0;
		memset(&flowPathEntry, 0 , sizeof(rtk_fc_tableFlowEntry_t));

		flowPathEntry.path1.in_path=FB_PATH_34;
		flowPathEntry.path3.in_l4proto			= 1;						   //tcp
		flowPathEntry.path3.in_ipv4_or_ipv6		= (pPktHdr->ip6h) ? 1:0;
		flowPathEntry.path3.in_cvlan_pri		= pFlowTable->pFlowEntry->path3.out_cpri_format_act ==1?pFlowTable->pFlowEntry->path3.out_cpri:0;
		flowPathEntry.path3.in_tos				= (pPktHdr->iph) ? pPktHdr->iph->tos : (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));
				
		param1 = pFlowTable->pFlowEntry->path3.in_l4_dst_port;
		param2 = pFlowTable->pFlowEntry->path3.in_l4_src_port;
		param3 = pFlowTable->pFlowEntry->path3.in_dst_ipv4_addr;
		param4 = pFlowTable->pFlowEntry->path3.in_src_ipv4_addr;
		extraItem = _rtk_fc_sw_flowHashPath34ExtraItem_get(&flowPathEntry.path3, igrSVID, igrCVID, lutDaIdx_gmacChk);
	
		
		/*
		*  3. Get hash index
		*/
		{
			hashIdx_reverse = _rtk_fc_sw_flowHashIndexStep1_get(param1, param2, param3, param4, extraItem);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			// 32K hash value point to 64K entry
			hashIdx_reverse <<= fc_db.flowHashWayShift;
#endif

		}
		TRACE("[TCP][RESET][PATH3]Reverse flow hash idx = %d\n", hashIdx_reverse);

		if(pFlowTable->cachedCt!=NULL)
		{
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				search_index = hashIdx_reverse+i;
				
				if(fc_db.flowTbl[search_index].cachedCt == pFlowTable->cachedCt)
				{
					// CT match, but still need to check ip and port
					
					int match = 0;

					match= rtk_fc_reverse_flow_path3_match(search_index, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = search_index;
						break;
					}
				}
			}
		}
		else
		{ 
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				int match = 0;
				
				search_index = hashIdx_reverse+i;
				

				match= rtk_fc_reverse_flow_path3_match(search_index, pFlowTable);
				if(match == 1)
				{
					find = 1;
					reverse_flow_real_index = search_index;
					break;
				}
			}
		}
		
		if((find == 0) && fc_db.shortcut_flow_count > 0)
		{

			uint32 flow_hashListHead=RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(hashIdx_reverse);
			
			rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;
			/*
			* 	Related hash index flow table is not the correct reverse-flow: So need to search sw Flow list
			*/
			
			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[flow_hashListHead], flow_list)	//just return the first entry right behind of head
			{
				if( (pFlowTable->cachedCt!=NULL && fc_db.flowTbl[pFlowEntry->idx].cachedCt ==  pFlowTable->cachedCt) || (pFlowTable->cachedCt==NULL)) {
					int match = 0;

					match= rtk_fc_reverse_flow_path3_match(pFlowEntry->idx, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = pFlowEntry->idx;
						break;
					}
				}
			}
					
		}
	}
DEL_REV_FLOW:
	if(reverse_flow_real_index == FAIL)
		DEBUG("[TCP][RST]Can't not find reverse flow index!");
	else
	{
		if(FLOW_INFO_IS_SET(&fc_db.flowTbl[reverse_flow_real_index], FLOW_INFO_DUPLICATE_EXIST))
		{
			uint32 theSamePtnFlowIdx;
			if(_rtk_fc_flow_isTheSamePatternExist_get(reverse_flow_real_index, hashIdx_reverse , pPktHdr->isMulticast, &theSamePtnFlowIdx))
			{
				DEBUG("[TCP][RST]delete flow[%d] at the same time (whitch have the same pattern with flow[%d])", theSamePtnFlowIdx, reverse_flow_real_index);
				RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx_reverse);
				//ASSERT_EQ(rtk_fc_flow_delete(theSamePtnFlowIdx), RTK_FC_RET_OK);
				ret = rtk_fc_flow_delete(theSamePtnFlowIdx);
				if(ret != RTK_FC_RET_OK)
				{
					WARNING("TCP RST Reverse delete theSamePtnFlowIdx flow[%d] failed! ret = %x", theSamePtnFlowIdx, ret);
					RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx_reverse);
					return ret;
				}
				RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx_reverse);
			}
			else
			{
				DEBUG("[TCP][RST]flow[%d] should have a the same pattern flow, but can't find it", reverse_flow_real_index);
			}
		}

		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx_reverse);
		//ASSERT_EQ(rtk_fc_flow_delete(reverse_flow_real_index), RTK_FC_RET_OK);
		ret = rtk_fc_flow_delete(reverse_flow_real_index);
		if(ret != RTK_FC_RET_OK)
		{
			WARNING("TCP RST Reverse delete flow[%d] failed! ret = %x", reverse_flow_real_index, ret);
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx_reverse);
			return ret;
		}
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, hashIdx_reverse);
	}

	return RTK_FC_RET_OK;
}
#endif

__IRAM_FC_SHORTCUT
int rtk_fc_tcp_rst_reverseFlowIdx_get(rtk_fc_tableFlow_t *pFlowTable, uint32 flowTblIdx, uint32 in_path, rtk_fc_pktHdr_t *pPktHdr, uint32 *reverse_flow_hashidx, int *reverse_flow_idx, int *reverse_flow_idx2)
{
	int reverse_flow_real_index = FAIL;
	uint32 hashIdx_reverse; // before shift

	if((pPktHdr->iph==NULL) && (pPktHdr->ip6h==NULL))
		return RTK_FC_RET_ERR;

	if(pFlowTable->pFlowEntry->path1.in_path == FB_PATH_5)
	{
		int direction;
		int find = 0, i;
		rtk_fc_tableFlowEntry_t flowPathEntry;
		uint16 igrSVID, igrCVID, lutDaIdx_gmacChk;

		uint16 param1=0, param2=0;
		uint32 param3=0, param4=0;
		uint32 extraItem=0;
		uint32 search_index=0;

		lutDaIdx_gmacChk = 0; //only path34 care
		igrSVID = pFlowTable->pFlowEntry->path5.out_svid_format_act ==1?pFlowTable->pFlowEntry->path5.out_svlan_id:0;
		igrCVID = pFlowTable->pFlowEntry->path5.out_cvid_format_act ==1?pFlowTable->pFlowEntry->path5.out_cvlan_id:0;
		memset(&flowPathEntry, 0 , sizeof(rtk_fc_tableFlowEntry_t));
		/*
		* 1. Get hash index related information about reverse-flow from incoming flow 
		* 2. Setting  parameter for calculating Hash index
		*/
		{
			direction = (pFlowTable->pFlowEntry->path5.out_l4_direction==1) ? RTK_FC_FLOW_DIRECTION_UPSTREAM : RTK_FC_FLOW_DIRECTION_DOWNSTREAM;

			flowPathEntry.path1.in_path=FB_PATH_5;
			flowPathEntry.path5.in_l4proto			= 1;						   //tcp
			flowPathEntry.path5.in_cvlan_pri		= pFlowTable->pFlowEntry->path5.out_cpri_format_act ==1?pFlowTable->pFlowEntry->path5.out_cpri:0;
			flowPathEntry.path5.in_tos				= (pPktHdr->iph) ? pPktHdr->iph->tos : (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));


			if(direction==RTK_FC_FLOW_DIRECTION_UPSTREAM) {
				param1 = pFlowTable->pFlowEntry->path5.in_l4_dst_port;
				param2 = pFlowTable->pFlowEntry->path5.out_l4_port;
				param3 = pFlowTable->pFlowEntry->path5.in_dst_ipv4_addr;
				param4 = (pPktHdr->iph) ? fc_db.netifHwTbl[pFlowTable->pFlowEntry->path5.out_intf_idx].intf.gateway_ipv4_addr : pFlowTable->pFlowEntry->path5.in_src_ipv4_addr;
				extraItem = _rtk_fc_sw_flowHashPath5ExtraItem_get(&flowPathEntry.path5, igrSVID, igrCVID);

			} else if (direction==RTK_FC_FLOW_DIRECTION_DOWNSTREAM) {
				// get upstream setting.
				param1 = pFlowTable->pFlowEntry->path5.out_l4_port;
				param2 = pFlowTable->pFlowEntry->path5.in_l4_src_port;
				param3 = pFlowTable->pFlowEntry->path5.out_dst_ipv4_addr;
				param4 =  (pPktHdr->iph) ?pFlowTable->pFlowEntry->path5.out_dst_ipv4_addr : pFlowTable->pFlowEntry->path5.in_dst_ipv4_addr;
				extraItem = _rtk_fc_sw_flowHashPath5ExtraItem_get(&flowPathEntry.path5, igrSVID, igrCVID);

			}
		}
		/*
		*  3. Get hash index
		*/
		{
			hashIdx_reverse = _rtk_fc_sw_flowHashIndexStep1_get(param1, param2, param3, param4, extraItem);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			// 32K hash value point to 64K entry
			hashIdx_reverse <<= fc_db.flowHashWayShift;
#endif

		}
		TRACE("[TCP][RESET]Reverse flow hash idx = %d\n", hashIdx_reverse);

		/*
		*	3. Search reverse flow and check ct is the same or not.
		*
		*/
		if(pFlowTable->cachedCt!=NULL)
		{
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				search_index = hashIdx_reverse+i;

				if(fc_db.flowTbl[search_index].cachedCt == pFlowTable->cachedCt)
				{
					// CT match, but still need to check ip and port

					int match = 0;

					match = rtk_fc_reverse_flow_path5_match(direction, search_index, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = search_index;
						break;
					}
				}
			}
		}
		else
		{
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				int match = 0;

				search_index = hashIdx_reverse+i;

				match = rtk_fc_reverse_flow_path5_match(direction, search_index, pFlowTable);
				if(match == 1)
				{
					find = 1;
					reverse_flow_real_index = search_index;
					break;
				}
			}
		}

		if((find == 0) && fc_db.shortcut_flow_count > 0)
		{

			uint32 flow_hashListHead=RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(hashIdx_reverse);

			rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;
			/*
			* 	Related hash index flow table is not the correct reverse-flow: So need to search sw Flow list
			*/

			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[flow_hashListHead], flow_list)	//just return the first entry right behind of head
			{
				if((pFlowTable->cachedCt!=NULL && fc_db.flowTbl[pFlowEntry->idx].cachedCt ==  pFlowTable->cachedCt) || (pFlowTable->cachedCt==NULL )){

					int match = 0;

					match = rtk_fc_reverse_flow_path5_match(direction, pFlowEntry->idx, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = pFlowEntry->idx;
						break;
					}
				}
			}

		}
	}
	else if(pFlowTable->pFlowEntry->path1.in_path == FB_PATH_34)
	{
		int find = 0, i ;
		rtk_fc_tableFlowEntry_t flowPathEntry;
		uint16 igrSVID, igrCVID, lutDaIdx_gmacChk;
		uint16 param1=0, param2=0;
		uint32 param3=0, param4=0;
		uint32 extraItem=0;
		uint32 search_index=0;

		lutDaIdx_gmacChk = 0; //only path34 care
		igrSVID = pFlowTable->pFlowEntry->path3.out_svid_format_act ==1?pFlowTable->pFlowEntry->path3.out_svlan_id:0;
		igrCVID = pFlowTable->pFlowEntry->path3.out_cvid_format_act ==1?pFlowTable->pFlowEntry->path3.out_cvlan_id:0;
		//lutDaIdx_gmacChk = (pPktHdr->dmacToGatewayMAC)?1:0;
		memset(&flowPathEntry, 0 , sizeof(rtk_fc_tableFlowEntry_t));

		flowPathEntry.path1.in_path=FB_PATH_34;
		flowPathEntry.path3.in_l4proto			= 1;						   //tcp
		flowPathEntry.path3.in_ipv4_or_ipv6		= (pPktHdr->ip6h) ? 1:0;
		flowPathEntry.path3.in_cvlan_pri		= pFlowTable->pFlowEntry->path3.out_cpri_format_act ==1?pFlowTable->pFlowEntry->path3.out_cpri:0;
		flowPathEntry.path3.in_tos				= (pPktHdr->iph) ? pPktHdr->iph->tos : (((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf));

		param1 = pFlowTable->pFlowEntry->path3.in_l4_dst_port;
		param2 = pFlowTable->pFlowEntry->path3.in_l4_src_port;
		param3 = pFlowTable->pFlowEntry->path3.in_dst_ipv4_addr;
		param4 = pFlowTable->pFlowEntry->path3.in_src_ipv4_addr;
		extraItem = _rtk_fc_sw_flowHashPath34ExtraItem_get(&flowPathEntry.path3, igrSVID, igrCVID, lutDaIdx_gmacChk);


		/*
		*  3. Get hash index
		*/
		{
			hashIdx_reverse = _rtk_fc_sw_flowHashIndexStep1_get(param1, param2, param3, param4, extraItem);
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
			// 32K hash value point to 64K entry
			hashIdx_reverse <<= fc_db.flowHashWayShift;
#endif

		}
		TRACE("[TCP][RESET][PATH3]Reverse flow hash idx = %d\n", hashIdx_reverse);

		if(pFlowTable->cachedCt!=NULL)
		{
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				search_index = hashIdx_reverse+i;

				if(fc_db.flowTbl[search_index].cachedCt == pFlowTable->cachedCt)
				{
					// CT match, but still need to check ip and port

					int match = 0;

					match= rtk_fc_reverse_flow_path3_match(search_index, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = search_index;
						break;
					}
				}
			}
		}
		else
		{
			for(i=0; i<(1<<fc_db.flowHashWayShift); i++)
			{
				int match = 0;

				search_index = hashIdx_reverse+i;


				match= rtk_fc_reverse_flow_path3_match(search_index, pFlowTable);
				if(match == 1)
				{
					find = 1;
					reverse_flow_real_index = search_index;
					break;
				}
			}
		}

		if((find == 0) && fc_db.shortcut_flow_count > 0)
		{

			uint32 flow_hashListHead=RTK_HASH_VAL_TO_SW_FLOW_LIST_IDX(hashIdx_reverse);

			rtk_fc_swFlow_linkList_t *pFlowEntry, *pNextFlowEntry;
			/*
			* 	Related hash index flow table is not the correct reverse-flow: So need to search sw Flow list
			*/

			list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &fc_db.swFlow_hashListHead[flow_hashListHead], flow_list)	//just return the first entry right behind of head
			{
				if( (pFlowTable->cachedCt!=NULL && fc_db.flowTbl[pFlowEntry->idx].cachedCt ==  pFlowTable->cachedCt) || (pFlowTable->cachedCt==NULL)) {
					int match = 0;

					match= rtk_fc_reverse_flow_path3_match(pFlowEntry->idx, pFlowTable);
					if(match == 1)
					{
						find = 1;
						reverse_flow_real_index = pFlowEntry->idx;
						break;
					}
				}
			}

		}
	}

	if(reverse_flow_real_index == FAIL)
		DEBUG("[TCP][RST]Can't not find reverse flow index!");
	else
	{
		*reverse_flow_hashidx = hashIdx_reverse;
		*reverse_flow_idx = reverse_flow_real_index;

		if(FLOW_INFO_IS_SET(&fc_db.flowTbl[reverse_flow_real_index], FLOW_INFO_DUPLICATE_EXIST))
		{
			uint32 theSamePtnFlowIdx;
			if(_rtk_fc_flow_isTheSamePatternExist_get(reverse_flow_real_index, hashIdx_reverse , pPktHdr->isMulticast, &theSamePtnFlowIdx))
			{
				*reverse_flow_idx2 = theSamePtnFlowIdx;
			}
			else
			{
				DEBUG("[TCP][RST]flow[%d] should have a the same pattern flow, but can't find it", reverse_flow_real_index);
			}
		}

		DEBUG("flow index = %d, reverse_flow_hashidx = %d, reverse_flow_idx = %d, reverse_flow_idx2 = %d", 
			flowTblIdx, *reverse_flow_hashidx, *reverse_flow_idx, *reverse_flow_idx2);
	}

	return RTK_FC_RET_OK;
}

__IRAM_FC_SHORTCUT
int rtk_fc_tcp_rst_reverseFlow_delete_by_idx(uint32 reverse_flow_hashidx, int reverse_flow_idx, int reverse_flow_idx2)
{
	int ret =0;

	if (reverse_flow_idx != FAIL)
	{
		if (reverse_flow_idx2 != FAIL) {
			DEBUG("[TCP][RST]delete flow[%d] at the same time (whitch have the same pattern with flow[%d])", reverse_flow_idx2, reverse_flow_idx);
			RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_hashidx);
			//ASSERT_EQ(rtk_fc_flow_delete(theSamePtnFlowIdx), RTK_FC_RET_OK);
			ret = rtk_fc_flow_delete(reverse_flow_idx2);
			if(ret != RTK_FC_RET_OK)
			{
				WARNING("TCP RST Reverse delete theSamePtnFlowIdx flow[%d] failed! ret = %x", reverse_flow_idx2, ret);
				RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_hashidx);
				return ret;
			}
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_hashidx);
		}

		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_hashidx);
		//ASSERT_EQ(rtk_fc_flow_delete(reverse_flow_real_index), RTK_FC_RET_OK);
		ret = rtk_fc_flow_delete(reverse_flow_idx);
		if(ret != RTK_FC_RET_OK)
		{
			WARNING("TCP RST Reverse delete flow[%d] failed! ret = %x", reverse_flow_idx, ret);
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_hashidx);
			return ret;
		}
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, reverse_flow_hashidx);
	}

	return RTK_FC_RET_OK;
}

#endif
__IRAM_FC_SHORTCUT 
int _rtk_fc_ct_tcp_state_decision(uint32 flowTblIdx, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_tableFlow_t *flowTable,struct rt_skbuff *rtskb, uint8 *doUpdateToHw, uint8 *doInvalid, uint8 *doDel, int *delete_reverse_flow)
{
	struct nf_conn * pCT = NULL;
	struct rt_nfconn *rtct, rt_ct;
	//int ret;
	rt_tcp_conntrack_state_t rt_tcp_state_old = RT_TCP_CONNTRACK_IGNORE, rt_tcp_state_new = RT_TCP_CONNTRACK_IGNORE;
	rt_ip_conntrack_dir_t rt_ip_dir = RT_IP_CT_DIR_MAX;
	rt_nf_5tuple_info_t rt_nf_tuple_info;
	
	if(pPktHdr->tcph)
	{
		pCT = rtk_fc_flow_ct_get(flowTable);

		if(pCT!=NULL) {
			
			rtct = &rt_ct;
			RTK_FC_HOOK_CONVERTER_CT(pCT, rtct);

			RTK_FC_HELPER_SPIN_LOCK_BH(rtct->lock);

#if defined(CONFIG_RTK_SOC_RTL8198D) || defined(CONFIG_FC_RTL8198F_SERIES) || defined(CONFIG_RTL8198X_SERIES)
			if(fc_db.tcp_in_window_shortcut_check) {
				uint32 is_ipv4 = pPktHdr->iph ? 1 : 0;
				int32 offset = pPktHdr->iph ? ((uint8 *)pPktHdr->iph - (uint8 *)pPktHdr->eth) : ((uint8 *)pPktHdr->ip6h - (uint8 *)pPktHdr->eth);
				uint8 *l3h = pPktHdr->iph ? (uint8 *)pPktHdr->iph : (uint8 *)pPktHdr->ip6h;
				rtk_fc_helper_ret_t helper_ret = RTK_FC_HELPER_TCP_IN_WINDOW(RTSKB_SKB(rtskb), pCT, is_ipv4, (uint8 *)l3h, offset, pPktHdr->tcph);

				atomic_inc(&fc_db.statistic.totalCnt_tcp_in_window);

				switch(helper_ret) {
				case RTK_FC_HELPER_RET_OK:
					atomic_inc(&fc_db.statistic.okCnt_tcp_in_window);
					break;
				case RTK_FC_HELPER_RET_ERR_TCP_WINDOW_CHECK_FAIL:
					atomic_inc(&fc_db.statistic.failCnt_tcp_in_window);
					break;
				case RTK_FC_HELPER_RET_ERR_NULL_POINTER:
				case RTK_FC_HELPER_RET_ERR_INVALID_PARAM:
					atomic_inc(&fc_db.statistic.abnormalCnt_tcp_in_window);
					break;
				default:
					break;
				}

				if(helper_ret == RTK_FC_HELPER_RET_ERR_TCP_WINDOW_CHECK_FAIL) {
					switch(fc_db.tcp_in_window_shortcut_fail_action) {
					case RTK_FC_TCP_IN_WINDOW_FAIL_FREE_SKB:
						RTK_FC_HELPER_SPIN_UNLOCK_BH(rtct->lock);
						//ret = RTK_FC_RET_DROP;
						*doUpdateToHw = FALSE;
						return FAILED;
						break;
					case RTK_FC_TCP_IN_WINDOW_FAIL_TO_PS:
						RTSKB_FCIGRDATA(rtskb)->skip_nf_conntrack_in = 1;
						RTK_FC_HELPER_SPIN_UNLOCK_BH(rtct->lock);
						//ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;
						*doUpdateToHw = FALSE;
						return FAILED;
						break;
					case RTK_FC_TCP_IN_WINDOW_FAIL_CONTINUE_SHORTCUT:
					default:
						break;
					}
				}
			}
#endif

			// update tcp FIN/RST state of CT
			RTK_FC_HELPER_PS_CT_RT_TCP_STATE_GET(rtct->ct, &rt_tcp_state_old);
			RTK_FC_HELPER_PS_CT_RT_5TUPLE_INFO_GET(rtct->ct, &rt_nf_tuple_info);
			//compare SIP to get direction
			if(pPktHdr->iph)
			{
				if(flowTable->protoCtrl == FLOW_PROTO_CTRL_MAPT_ACC){
					if(!memcmp(&rt_nf_tuple_info.tuple[RT_IP_CT_DIR_ORIGINAL].src_ip.v6_addr, &(fc_db.ipv6_mapt_mappingTbl[flowTable->maptInfo.sip_indirect_mapping_index].addr), sizeof(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_ORIGINAL].src_ip.v6_addr)))
						rt_ip_dir = RT_IP_CT_DIR_ORIGINAL;
					else if(!memcmp(&rt_nf_tuple_info.tuple[RT_IP_CT_DIR_REPLY].src_ip.v6_addr, &(fc_db.ipv6_mapt_mappingTbl[flowTable->maptInfo.sip_indirect_mapping_index].addr), sizeof(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_REPLY].src_ip.v6_addr)))
						rt_ip_dir = RT_IP_CT_DIR_REPLY;
				}else{
					if(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_ORIGINAL].src_ip.v4_addr == pPktHdr->iph->saddr)
						rt_ip_dir = RT_IP_CT_DIR_ORIGINAL;
					else if(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_REPLY].src_ip.v4_addr == pPktHdr->iph->saddr)
						rt_ip_dir = RT_IP_CT_DIR_REPLY;
				}
			}
			else if(pPktHdr->ip6h)
			{
				if(flowTable->protoCtrl == FLOW_PROTO_CTRL_MAPT_ACC){
					if(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_ORIGINAL].src_ip.v4_addr == htonl(flowTable->pFlowEntry->path5.in_src_ipv4_addr))
						rt_ip_dir = RT_IP_CT_DIR_ORIGINAL;
					else if(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_REPLY].src_ip.v4_addr == htonl(flowTable->pFlowEntry->path5.in_src_ipv4_addr))
						rt_ip_dir = RT_IP_CT_DIR_REPLY;
				}else{
					if(!memcmp(&rt_nf_tuple_info.tuple[RT_IP_CT_DIR_ORIGINAL].src_ip.v6_addr, &(pPktHdr->ip6h->saddr), sizeof(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_ORIGINAL].src_ip.v6_addr)))
						rt_ip_dir = RT_IP_CT_DIR_ORIGINAL;
					else if(!memcmp(&rt_nf_tuple_info.tuple[RT_IP_CT_DIR_REPLY].src_ip.v6_addr, &(pPktHdr->ip6h->saddr), sizeof(rt_nf_tuple_info.tuple[RT_IP_CT_DIR_REPLY].src_ip.v6_addr)))
						rt_ip_dir = RT_IP_CT_DIR_REPLY;
				}
			}
			if(rt_ip_dir < RT_IP_CT_DIR_MAX)
			{
				if(atomic_read(&rtct->ct_general->use) && (rt_tcp_state_old < RT_TCP_CONNTRACK_MAX)
					)
				{
					if(pPktHdr->tcph->rst){
						rt_tcp_state_new = rt_tcp_conntracks[rt_ip_dir][RT_TCP_PKT_TYPE_RST][rt_tcp_state_old];
						*delete_reverse_flow = 1;
					}
					else if(pPktHdr->tcph->syn)
					{
						if(pPktHdr->tcph->ack)
							rt_tcp_state_new = rt_tcp_conntracks[rt_ip_dir][RT_TCP_PKT_TYPE_SYNACK][rt_tcp_state_old];
						else
							rt_tcp_state_new = rt_tcp_conntracks[rt_ip_dir][RT_TCP_PKT_TYPE_SYN][rt_tcp_state_old];
					}
					else if(pPktHdr->tcph->fin)
						rt_tcp_state_new = rt_tcp_conntracks[rt_ip_dir][RT_TCP_PKT_TYPE_FIN][rt_tcp_state_old];
					else if(pPktHdr->tcph->ack)
						rt_tcp_state_new = rt_tcp_conntracks[rt_ip_dir][RT_TCP_PKT_TYPE_ACK][rt_tcp_state_old];
					else {
						// what else?
						TRACE("FIXME");
						rt_tcp_state_new = rt_tcp_conntracks[rt_ip_dir][RT_TCP_PKT_TYPE_NONE][rt_tcp_state_old];
					}

					/* Follow protocol stack behavior, the following 3 condition will not update CT TCP state:
						1. old_state >= TIME_WAIT AND new_state is SYN_SENT
						2. new_state is IGNORE
						3. new_state is TCP_CONNTRACK_MAX (INVALID)
					*/
					if ((rt_tcp_state_old >= RT_TCP_CONNTRACK_TIME_WAIT) && (rt_tcp_state_new == RT_TCP_CONNTRACK_SYN_SENT))
						rt_tcp_state_new = RT_TCP_CONNTRACK_IGNORE;

					if((rt_tcp_state_new != RT_TCP_CONNTRACK_IGNORE) && (rt_tcp_state_new != RT_TCP_CONNTRACK_MAX)){
						DEBUG("[TCP ct update] state %s -> %s", rt_tcp_conntrack_names[rt_tcp_state_old], rt_tcp_conntrack_names[rt_tcp_state_new]);

						// state update
						RTK_FC_HELPER_PS_CT_RT_TCP_STATE_SET(rtct->ct, rt_tcp_state_new);
					}

					if(rt_tcp_state_new==RT_TCP_CONNTRACK_FIN_WAIT || 
						(rt_tcp_state_new==RT_TCP_CONNTRACK_LAST_ACK && rt_ip_dir == RT_IP_CT_DIR_REPLY))
						*doInvalid = TRUE;
					else if(rt_tcp_state_new==RT_TCP_CONNTRACK_TIME_WAIT || 
							rt_tcp_state_new==RT_TCP_CONNTRACK_CLOSE || 
							(rt_tcp_state_new==RT_TCP_CONNTRACK_LAST_ACK && rt_ip_dir == RT_IP_CT_DIR_ORIGINAL))
						*doDel = TRUE;
				}
				RTK_FC_HELPER_SPIN_UNLOCK_BH(rtct->lock);
				RTK_FC_HOOK_PS_CT_REFRESH(rtct->ct);
			}
			else
			{
				RTK_FC_HELPER_SPIN_UNLOCK_BH(rtct->lock);
				WARNING("Strange!! ct SIP info not matched!");
			}
		}
		
		if(unlikely(flowTable->candidateState == CANDIDATE_STATE_AGING)) {

			// TCP last ack, flow could be deleted now
			*doDel = TRUE;
			TRACE("[Candidata] hit flow[%d] and flow will be deleted after shortcut tx", flowTblIdx);
		}
		
	}
	return SUCCESS;
}

__IRAM_FC_SHORTCUT
rtk_fc_ret_t _rtk_fc_shortCutCheck(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	rtk_fc_tableFlow_t flowTable={0};
	rtk_fc_tableFlow_t flowTable_multiAction={0};
	uint32 flowTblIdx=FAIL,flowTblMutiActIdx=FAIL;
	rtk_fc_flowEntSearchReturn_t result = RTK_FC_FLOWENT_SEARCH_FAIL;
	int ret = 0;
	int shortCut_dpi_ret = 0;
	int delete_reverse_flow = 0;
#if !defined(CONFIG_FC_RTL8277C_SERIES)
	int reverse_flow_idx = FAIL, reverse_flow_idx2 = FAIL;
	uint32 reverse_flow_hashidx = 0;
#endif
	//int hwHashIdx = pPktHdr->flowHashIdx;
	uint8 doDel = FALSE, doInvalid = FALSE, doUpdateToHw = FALSE, doDelFragCache = FALSE, doDelFragCache2 = FALSE;
	uint8 acl_trap_bypass_shortcut = TRUE;
	uint16 intf_mtu;
	
	struct udphdr fakeUdpHdr;
	bool ifSkipNicL2Offload = FALSE;
	rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo=NULL;
	rtk_fc_g3IgrExtraInfo_t *path4_pG3IgrExtraInfo=NULL;
	
#if defined(CONFIG_RTK_SOC_RTL8198D)
	unsigned short isIpv6;
	unsigned int groupIP[4];
#endif

#if defined(CONFIG_RTL9607C_SERIES) && defined(CONFIG_RTL9603CVD_SERIES)
	// In order to share an image between 9607C and 9603CVD
	rtk_fc_tableFlowEntry_t flowEntry, flowMultiEntry;
	flowTable.pFlowEntry = &flowEntry;
	flowTable_multiAction.pFlowEntry = &flowMultiEntry;
#endif

	if(pPktHdr->outerHdrMiss)
	{

		if(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_PPTP)
		{	
			pPktHdr->iph = pPktHdr->outer_iph;	// move iph to the position of outer header
			memset(&fakeUdpHdr, 0, sizeof(fakeUdpHdr));
			pPktHdr->udph = &fakeUdpHdr;		// use a fake udp hearder for PPTP
			
			if(pPktHdr->outer_iph)
				pPktHdr->ip6h = NULL;
			
			pPktHdr->tcph = NULL;				//inner L4 header may be TCP 
			TRACE("PPTP passthrough");
		}
		else if(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_L2TP)
		{
			pPktHdr->iph = pPktHdr->outer_iph;
			pPktHdr->udph =  pPktHdr->outer_udph;

			if(pPktHdr->outer_iph)
				pPktHdr->ip6h = NULL;
			
			pPktHdr->tcph = NULL;				//inner L4 header may be TCP
			TRACE("L2TP passthrough");
		}
		else if(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_VXLAN)
		{
			TRACE("VXLAN! Keep check shortCut!");
		}
		else
			return RTK_FC_RET_LRN_SHORTCUT_MISS; // outer header flow was not ready yet, bypass shortcut checking
	}


	TRACE("Check shortcut, flowHashIdx=%d", pPktHdr->flowHashIdx);

	//3 === Flow table critical section START - protected by flow group lock ===
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif

	{
		result = rtk_fc_flow_searchByIngressPktHdr(pPktHdr->flowHashIdx, pPktHdr, &flowTable, &flowTable_multiAction, &flowTblIdx, &flowTblMutiActIdx);

		if(unlikely(result == RTK_FC_FLOWENT_SEARCH_FAIL)) {
			ret = RTK_FC_RET_LRN_SHORTCUT_MISS;

			if (pPktHdr->ipFragFlag)
				doDelFragCache2 = TRUE;

			goto FLOW_CRI_SEC_END;
		}
			
		if(unlikely(flowTblIdx >= (RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE))) {
			WARNING("flowTblIdx out of range!\n");
			ret = RTK_FC_RET_LRN_SHORTCUT_MISS;
			goto FLOW_CRI_SEC_END;
		}

		// hit shortcut!
		FLOW_SHORTCUT_HIT(pPktHdr);
		
		if(unlikely(fc_db.fwdStatistic))
		{
			switch(flowTable.pFlowEntry->path1.in_path)
			{
				case FB_PATH_34:
					if(flowTable.pFlowEntry->path3.in_ipv4_or_ipv6==0)
					{
						atomic_inc(&fc_db.statistic.perPortCnt_shortcut[pPktHdr->ingressPort.macPortIdx]);
					}
					else
						atomic_inc(&fc_db.statistic.perPortCnt_shortcutV6[pPktHdr->ingressPort.macPortIdx]);
					break;
				case FB_PATH_5:
					if(flowTable.pFlowEntry->path5.in_ipv4_or_ipv6==0)
					{
						atomic_inc(&fc_db.statistic.perPortCnt_shortcut[pPktHdr->ingressPort.macPortIdx]);
					}
					else
					{
						atomic_inc(&fc_db.statistic.perPortCnt_shortcutV6[pPktHdr->ingressPort.macPortIdx]);
					}
					break;
				case FB_PATH_12:
					atomic_inc(&fc_db.statistic.perPortCnt_shortcut[pPktHdr->ingressPort.macPortIdx]);
					break;
				case FB_PATH_6:
				default:
					WARNING("flwo path 6 is not supported by shortcut");
					ret = RTK_FC_RET_LRN_NOT_SUPPORT;
					goto FLOW_CRI_SEC_END;
			}

			if(flowTable.protoCtrl == FLOW_PROTO_CTRL_ICMP_ACC) {
				if(pPktHdr->icmph)
					atomic_inc(&fc_db.statistic.perPortCnt_shortcut_icmp4[pPktHdr->ingressPort.macPortIdx]);
				else if(pPktHdr->icmp6h)
					atomic_inc(&fc_db.statistic.perPortCnt_shortcut_icmp6[pPktHdr->ingressPort.macPortIdx]);
			}
		}


		if(pPktHdr->isHitSwFwdedAclTrapPri)
			acl_trap_bypass_shortcut = FALSE;
		
		if(pPktHdr->icmph && ((pPktHdr->icmph->type == 0 || pPktHdr->icmph->type == 8)  && pPktHdr->dmacToGatewayMAC) )
		{
			acl_trap_bypass_shortcut = FALSE;
			TRACE("ICMP shortCut! type: %d, dmacToGateway: %d", pPktHdr->icmph->type, pPktHdr->dmacToGatewayMAC);
		}
		else if(pPktHdr->icmp6h && ((pPktHdr->icmp6h->icmp6_type == 129 || pPktHdr->icmp6h->icmp6_type == 128) && pPktHdr->dmacToGatewayMAC))
		{
			acl_trap_bypass_shortcut = FALSE;
			TRACE("ICMPv6 shortCut! type: %d, dmacToGateway: %d", pPktHdr->icmp6h->icmp6_type, pPktHdr->dmacToGatewayMAC);
		}

		if(unlikely((pPktHdr->reason == CPU_REASON_ACL) && acl_trap_bypass_shortcut)) {
			ret = RTK_FC_RET_LRN_SKIP_CTRLPKT;
			goto FLOW_CRI_SEC_END;
		}
		
		// candidate state changing
		if(unlikely(!flowTable.pFlowEntry->path1.valid || 
			((flowTblMutiActIdx != FAIL) && (!flowTable_multiAction.pFlowEntry->path1.valid)))){

			if((ret = rtk_fc_shortcut_candidate_update_check(flowTblIdx, &flowTable, &doUpdateToHw)))
				goto FLOW_CRI_SEC_END;

			if(doUpdateToHw)
			{
				/********************* Set G3 Ingress Extra Info ********************************/
				pG3IgrExtraInfo = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_g3IgrExtraInfo_t), GFP_ATOMIC);
				path4_pG3IgrExtraInfo = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_g3IgrExtraInfo_t), GFP_ATOMIC);
				rtk_fc_shortCut_setG3IgrExtraInfo(pG3IgrExtraInfo, path4_pG3IgrExtraInfo, pPktHdr, &flowTable ,
				                              flowTblMutiActIdx, &flowTable_multiAction);
			}
		}

		/*
			Disable SW acc mode, this flow hit short cut in ingress learning but do not modify it & direct TX it,
			so let FC not cache ingress data to not add the same flow again.
		*/
		if(unlikely(fc_db.controlFuc.hwnat_mode==RT_FLOW_HWNAT_MODE_HW_ONLY))
		{
			DEBUG("HWNAT Mode: Disable sw acceleration (HW acceleration Only), skip shorcut but set flow entry valid.");
			ret = RTK_FC_RET_LRN_DISABLE_SW_ACCELERATION;
			goto FLOW_CRI_SEC_END;
		}
		
		// [CPU_REASON_MTU] skip if over egress intf MTU
		if(unlikely((fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.valid) && fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.intf_mtu_check))
		{
			int outerHdrLen = 0;
			int l2PayloadSize = pPktHdr->l2PayloadLen;
			int intfMTU = fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.intf_mtu;

			if((pPktHdr->dualHdrType==RTK_FC_DUALTYPE_PPTP)||(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_L2TP)){
				if(pPktHdr->iph){
					outerHdrLen = (uint8*)pPktHdr->iph - (uint8*)pPktHdr->outer_iph;
				}else if(pPktHdr->ip6h){
					outerHdrLen = (uint8*)pPktHdr->ip6h - (uint8*)pPktHdr->outer_iph;
				}
				l2PayloadSize -= outerHdrLen;
			}else if(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_DSLITE){
				outerHdrLen = (uint8*)pPktHdr->iph - (uint8*)pPktHdr->ip6h;
				l2PayloadSize -= outerHdrLen;
				
				DSLITE("[Downstream]: l2PayloadSize(%d), intfMTU=%d",l2PayloadSize, intfMTU);
			}else if(pPktHdr->dualHdrType==RTK_FC_DUALTYPE_6RD){
				outerHdrLen = (uint8*)pPktHdr->ip6h - (uint8*)pPktHdr->outer_iph;
				l2PayloadSize -= outerHdrLen;
			}

			//Ds-Lite/MAP-E upstream, need update the l2PayloadSize after insert ipv6hdr
			if(fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].dualType == RTK_FC_DUALTYPE_DSLITE){
				l2PayloadSize += sizeof(struct ipv6hdr);
				DSLITE("[Upstream]: l2PayloadSize(%d), intfMTU=%d",l2PayloadSize, intfMTU);
			}
			

			if(l2PayloadSize > intfMTU){//l2PayloadSize > (1500-40)
			#if defined(CONFIG_FC_RTL8198F_SERIES)
				//Ds-Lite/MAP-E upstream UDP
				if( (atomic_read(&fc_db.dsliteUdpFrag)!=0) && (pPktHdr->udph != NULL) &&
					(fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].dualType == RTK_FC_DUALTYPE_DSLITE) &&
					 (RTK_FC_HOOK_DSLITE_IPV6_FGRAMENT(NULL,NULL,NULL,NULL) != RTK_FC_RET_ERR) ){
					DSLITE("[%s] [UDP Fragment] Over netif[%d] MTU (%d > %d)", flowTable.pFlowEntry->path5.out_l4_act?"MAP-E":"Ds-Lite",
						flowTable.pFlowEntry->path1.out_intf_idx, l2PayloadSize, intfMTU);
				}else
			#endif
				{
					TRACE("[SC] Over netif[%d] MTU (%d > %d)", flowTable.pFlowEntry->path1.out_intf_idx, l2PayloadSize, intfMTU);
					ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;

					if (pPktHdr->ipFragFlag) {
						doDelFragCache = TRUE;
						intf_mtu = fc_db.netifHwTbl[flowTable.pFlowEntry->path1.out_intf_idx].intf.intf_mtu;
					}
					goto FLOW_CRI_SEC_END;
				}
			}
		}
		// [CPU_REASON_TTL] skip if ttl<=1
		if((flowTable.pFlowEntry->path5.in_path == FB_PATH_5) || ((flowTable.pFlowEntry->path5.in_path < FB_PATH_5) && flowTable.pFlowEntry->path3.out_smac_trans))
		{
			if(pPktHdr->iph && (pPktHdr->iph->ttl <= 1)){
				TRACE("[SC] IPv4 Routing but TTL <=1");
				ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;
				goto FLOW_CRI_SEC_END;
			}
			if(pPktHdr->ip6h && (pPktHdr->ip6h->hop_limit <= 1)){
				TRACE("[SC] IPv6 Routing but TTL <=1");
				ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;
				goto FLOW_CRI_SEC_END;
			}
		}
		

		/*
		*	Short Cut DPI Before modification Here
		*
		*	Hit Shortcut but not modify packet content yet
		*	here, support 3 types of return value from dpi external function:
		*	1. Trap 	 :	Trap to protocol stack, but won't learn flow again.
		*	2. Continue  :	Continue the unfinished shortcut checking and filling job
		*	3. Drop 	 :	Drop the packet.
		*/
		if(fc_db.flow_callback_func.cbShortcut_before)
		{
			rt_cbFunc_flow_info_t cbFunc_info;

			memset(&cbFunc_info, 0, sizeof(rt_cbFunc_flow_info_t));
			cbFunc_info.cachedCt            = flowTable.cachedCt;
			cbFunc_info.flowIdx             = flowTblIdx;
			cbFunc_info.flow_extra_info = flowTable.flow_extra_info;

			shortCut_dpi_ret = fc_db.flow_callback_func.cbShortcut_before(rtskb->skb, cbFunc_info);

			switch(shortCut_dpi_ret){
				case RT_FLOW_CB_FUNC_RET_TRAP:
					DEBUG("[SHORTCUT DPI]Trap to CPU after DPI");
					ret = RTK_FC_RET_LRN_TRAP_TO_PS;
					doUpdateToHw = FALSE;
					goto FLOW_CRI_SEC_END;
					break;
				case RT_FLOW_CB_FUNC_RET_CONTINUE:
					DEBUG("[SHORTCUT DPI]Continue shortcut after DPI");
					break;
				case RT_FLOW_CB_FUNC_RET_DROP:
					DEBUG("[SHORTCUT DPI]Drop packet after DPI");
					ret = RTK_FC_RET_DROP_CALLBACK_FUNC;
					doUpdateToHw = FALSE;
					goto FLOW_CRI_SEC_END;
					break;
				default:
					break;
			}
		}

		
	
		/********************* All SKB Modification starts from here*********************/

		//---------TCP STATE--------------------------------------------

		ret = _rtk_fc_ct_tcp_state_decision(flowTblIdx, pPktHdr, &flowTable, rtskb, &doUpdateToHw, &doInvalid, &doDel, &delete_reverse_flow);
		if(ret != SUCCESS)
			goto FLOW_CRI_SEC_END;

	#if !defined(CONFIG_FC_RTL8277C_SERIES)
		if (delete_reverse_flow) {
			rtk_fc_tcp_rst_reverseFlowIdx_get(&flowTable, flowTblIdx, flowTable.pFlowEntry->path1.in_path, pPktHdr, &reverse_flow_hashidx, &reverse_flow_idx, &reverse_flow_idx2);
		}
	#endif

		/*** trim packet padding. (Note. This should be done before insert outer header, or the length field in headers would be wrong. 	***/
		if((pPktHdr->iph)||(pPktHdr->ip6h)){
			int l3Len = (pPktHdr->iph)? ntohs(pPktHdr->iph->tot_len) : ntohs(pPktHdr->ip6h->payload_len) + 40;
			int l3Offset = (pPktHdr->iph) ? (uint8 *)(pPktHdr->iph) - RTSKB_DATA(rtskb) :  (uint8 *)(pPktHdr->ip6h) - RTSKB_DATA(rtskb);
			int packet_len = l3Offset + l3Len;
			if(pPktHdr->ppph && ((l3Len+2) < ntohs(pPktHdr->ppph->length))) pPktHdr->ppph->length=htons(ntohs(pPktHdr->ppph->length)-(RTSKB_LEN(rtskb)-packet_len));

			DEBUG("trim skb len from %d to %d", RTSKB_LEN(rtskb), packet_len);
			RTK_FC_HOOK_PS_SKB_SKB_TRIM(RTSKB_SKB(rtskb), packet_len);
		}

		// check dual header operation
		if(pPktHdr->dualHdrType && pPktHdr->outerHdrMiss==FALSE && pPktHdr->dualHdrType!=RTK_FC_DUALTYPE_IPSEC && pPktHdr->dualHdrType!=RTK_FC_DUALTYPE_GRE_ETH_BR && pPktHdr->dualHdrType!=RTK_FC_DUALTYPE_VXLAN)
		{
			TRACE("Remove outer header");
			rtk_fc_outerHdr_remove(rtskb, pPktHdr);
			pPktHdr->dualHdrType = RTK_FC_DUALTYPE_NONE; //G3 need this info to fill nic tx info
		}

		if((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_NONE) &&
			(flowTable.pFlowEntry->path1.in_path!=FB_PATH_6) && (flowTable.pFlowEntry->path5.out_extra_tag_index!=0))
		{
			TRACE("Insert outer header");
			rtk_fc_outerHdr_insert(rtskb, pPktHdr, &flowTable);
		}

		/********************* L2DUAL ACTION HERE*****************************************/
		{
			if(flowTable.protoCtrl == FLOW_PROTO_CTRL_L2DUAL && flowTable.l2Dual_table_info.l2Dual_table_index!=0 && atomic_read(&fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].refCount)!=0 )
			{
				if(fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].type == RTK_FC_L2DUAL_TYPE_VXLAN && fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].action == RTK_FC_L2DUAL_ACT_ADD)
				{
					if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_NONE)//VXLAN Upstream
					{
						int ret;
						TRACE("[VXLAN][UPSTREAM]Will add VXLAN tag, len = %d\n", fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].vxlan_us.outer_tag_len);
						ret = rtk_fc_l2Dual_outerHdr_insert(rtskb, pPktHdr, &flowTable);

						if(ret)
						{
							WARNING("Inset VXLAN tag fail, skip shortcut");
							ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;
							doUpdateToHw = FALSE;
							goto FLOW_CRI_SEC_END;
						}
						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_VXLAN; //G3 need this info to fill nic tx info
						ifSkipNicL2Offload = TRUE; // skip NIC VLAN/PPPoE offload to prevet outer l2 header to be modified

					}
				}
				else if(fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].type == RTK_FC_L2DUAL_TYPE_VXLAN && fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].action == RTK_FC_L2DUAL_ACT_REMOVE)
				{
					if(flowTable.pFlowEntry->path5.out_l4_direction == 0) //DownStream
					{
						TRACE("[VXLAN][DOWNSTREAM]Will remove VXLAN tag len = %d\n", pPktHdr->vxlan_info.outerTag_off);
						rtk_fc_l2Dual_outerHdr_remove(rtskb, pPktHdr->vxlan_info.outerTag_off, pPktHdr, &flowTable);

						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_NONE; //G3 need this info to fill nic tx info
					}
				}
				else if(fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].type == RTK_FC_L2DUAL_TYPE_GRE_ETH_BR && fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].action == RTK_FC_L2DUAL_ACT_ADD)
				{
					if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_NONE) //GRE ETH BR Upstream
					{
						TRACE("[GRE_ETH_BR][UPSTREAM] Will add GRE_ETH_BR tag, len = %d\n", fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].greEthBr_us.outer_tag_len);
						ret = rtk_fc_l2Dual_outerHdr_insert(rtskb, pPktHdr, &flowTable);

						if(ret)
						{
							WARNING("Inset GRE_ETH_BR tag fail, skip shortcut");
							ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;
							doUpdateToHw = FALSE;
							goto FLOW_CRI_SEC_END;
						}

						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_GRE_ETH_BR;
						ifSkipNicL2Offload = TRUE; // skip NIC VLAN/PPPoE offload to prevet outer l2 header to be modified
					}
				}
				else if(fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].type == RTK_FC_L2DUAL_TYPE_GRE_ETH_BR && fc_db.l2DualTbl[flowTable.l2Dual_table_info.l2Dual_table_index].action == RTK_FC_L2DUAL_ACT_REMOVE)
				{
					if(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_GRE_ETH_BR) //GRE ETH BR DownStream
					{
						TRACE("[GRE_ETH_BR][DOWNSTREAM] Will remove GRE_ETH_BR tag len = %d\n", pPktHdr->greEthBr_info.outerTag_off);
						rtk_fc_l2Dual_outerHdr_remove(rtskb, pPktHdr->greEthBr_info.outerTag_off, pPktHdr, &flowTable);
						pPktHdr->dualHdrType = RTK_FC_DUALTYPE_NONE;
					}
				}
			}
		}

		//check for mapt shortcut
		if(flowTable.protoCtrl == FLOW_PROTO_CTRL_MAPT_ACC){
			TRACE("[MAPT] Will translate IP header here\n");
			if(rtk_fc_mapt_translate(rtskb, pPktHdr, &flowTable)){
				TRACE("Transform IP header fail or Fragment, skip shortcut");
				ret = RTK_FC_RET_LRN_SKIP_SHORTCUT;
				doUpdateToHw = FALSE;
				goto FLOW_CRI_SEC_END;
			}
			pPktHdr->isMAPT=1;
		}

		// modify packet and forward by nic dirtx
		if(pPktHdr->isMulticast ==0)
		{
			//pPktHdr->shortCut_unlock_bit = 2; // RTK_FC_SHORTCUT_EARLY_UNLOCK_REQUEST
			if((ret = _rtk_fc_flowModifyAndDirTx(rtskb, pPktHdr, &flowTable, flowTblIdx, ifSkipNicL2Offload)) != RTK_FC_RET_OK)
			{
				TRACE("dritx fail! ret = %d", ret);
			}else{
				ret = RTK_FC_RET_LRN_SHORTCUT_TX;
			}
		}
		else
		{
#if defined(CONFIG_RTK_SOC_RTL8198D)
			
			memset(groupIP, 0,sizeof(groupIP));
			if(pPktHdr->ip6h)
			{
				isIpv6 =1;
				memcpy(groupIP,pPktHdr->ip6h->daddr.s6_addr32, sizeof(groupIP));
			}
			else if (pPktHdr->iph)
			{
				isIpv6 =0;
				groupIP[0]=ntohl(pPktHdr->iph->daddr); 
			}
					
			if((pPktHdr->ip6h || pPktHdr->iph) && (rtk_fc_get_user_group(groupIP, isIpv6) == 0))
			{
			
				doUpdateToHw = FALSE;
				ret = RTK_FC_RET_LRN_SHORTCUT_MISS;
			}else
#endif
			{		
				if((ret = _rtk_fc_mc_flowModifyAndDirTx(rtskb, pPktHdr, &flowTable, &flowTable_multiAction, flowTblIdx, flowTblMutiActIdx, ifSkipNicL2Offload)) != RTK_FC_RET_OK)
				{
					TRACE("dritx fail! ret = %d", ret);
				}else{
					ret = RTK_FC_RET_LRN_SHORTCUT_TX;
				}
			}
		}
		
	}
FLOW_CRI_SEC_END:
	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
#endif

	//3 === Flow table critical section END - protected by flow group lock ===

	if(unlikely(ret != RTK_FC_RET_LRN_SHORTCUT_TX) && unlikely(ret != RTK_FC_RET_LRN_DISABLE_SW_ACCELERATION)) {
		doUpdateToHw = doInvalid = doDel = FALSE;
	}

	if(doUpdateToHw) {
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if((flowTblIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= flowTblIdx))
			RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		else
#endif
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
		ASSERT_EQ_CONT(rtk_fc_shortcut_candidate_update_to_hw(pPktHdr, flowTblIdx, &flowTable, flowTblMutiActIdx, &flowTable_multiAction, pG3IgrExtraInfo, path4_pG3IgrExtraInfo), RTK_FC_RET_OK);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if((flowTblIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= flowTblIdx))
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		else
#endif
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);

		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	}
	
	if(doInvalid) {
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
		// invalid hw flow, back to software procedure
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if((flowTblIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= flowTblIdx))
			RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		else
#endif
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
		ASSERT_EQ_CONT(rtk_fc_flow_invalid_hw(flowTblIdx), RTK_FC_RET_OK);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if((flowTblIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= flowTblIdx))
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		else
#endif
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	}	
	if(doDel) {
		// delete from hw
		/*
		* When receive tcp-reset, the reverse flow should be delete as well
		*	1. Get hash index related information about reverse-flow from incoming flow
		*   2. Calculate Hash index, and check cached ct is the same or not
		*   3. Delete two flow
		*/
		
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
		
		if(delete_reverse_flow ){
		#if defined(CONFIG_FC_RTL8277C_SERIES)
			rtk_fc_tcp_rst_reverseFlow_delete(&flowTable, flowTblIdx);
		#else
			rtk_fc_tcp_rst_reverseFlow_delete_by_idx(reverse_flow_hashidx, reverse_flow_idx, reverse_flow_idx2);
		#endif
		}
		if(FLOW_INFO_IS_SET(&fc_db.flowTbl[flowTblIdx], FLOW_INFO_DUPLICATE_EXIST))
		{
			uint32 theSamePtnFlowIdx;
			if(_rtk_fc_flow_isTheSamePatternExist_get(flowTblIdx, pPktHdr->flowHashIdx , pPktHdr->isMulticast, &theSamePtnFlowIdx))
			{
				
				DEBUG("[TCP][RST]delete flow[%d] at the same time (whitch have the same pattern with flow[%d])", theSamePtnFlowIdx, flowTblIdx);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
				if((theSamePtnFlowIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= theSamePtnFlowIdx))
					RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
				else
#endif
				RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
				ASSERT_EQ_CONT(rtk_fc_flow_delete(theSamePtnFlowIdx), RTK_FC_RET_OK);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
				if((theSamePtnFlowIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= theSamePtnFlowIdx))
					RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
				else
#endif
				RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
			}
			
			else
			{
				DEBUG("[TCP][RST]flow[%d] should have a the same pattern flow, but can't find it", flowTblIdx);
			}
		}
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if((flowTblIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= flowTblIdx))
			RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		else
#endif
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
		ASSERT_EQ_CONT(rtk_fc_flow_delete(flowTblIdx), RTK_FC_RET_OK);
#if defined(CONFIG_FC_RTL8277C_SERIES) && RTK_FC_TABLESIZE_OVERFLOW_FLOW
		if((flowTblIdx < fc_db.flowHwTableSize) && (RTK_FC_TABLESIZE_HASH_FLOW <= flowTblIdx))
			RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW_OVERFLOW, 0);
		else
#endif
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_FLOW, pPktHdr->flowHashIdx);
		
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	}

	if (pPktHdr->iph && (doDelFragCache || doDelFragCache2)) {
		rtk_fc_ipFrag_linkList_t *pfrag_cache;

		RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();

		pfrag_cache = rtk_fc_ipfrag_shortcut_find_cache(pPktHdr);
		if (pfrag_cache) {

			// fail mtu check and delete frag cache
			if (doDelFragCache) {
				FRAGMENT("frag with iph id=0x%x frag_off=0x%x, l2PayloadLen=%d, intf_mtu=%d, del frag cache", 
					ntohs(pPktHdr->iph->id), ntohs(pPktHdr->iph->frag_off), 
					pPktHdr->l2PayloadLen, intf_mtu);
			}
			else {	// search shortcut flow fail
				FRAGMENT("frag with iph id=0x%x frag_off=0x%x, search flow fail, del frag cache", ntohs(pPktHdr->iph->id), ntohs(pPktHdr->iph->frag_off));
			}

			rtk_fc_ipFrag_cache_del(pfrag_cache);
		}

		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	}

	if(pG3IgrExtraInfo) RTK_FC_HELPER_FC_KFREE(pG3IgrExtraInfo,sizeof(rtk_fc_g3IgrExtraInfo_t));
	if(path4_pG3IgrExtraInfo) RTK_FC_HELPER_FC_KFREE(path4_pG3IgrExtraInfo,sizeof(rtk_fc_g3IgrExtraInfo_t));

	return ret;
}
static void rtk_fc_sw_gemmib_counting(uint32 ruleIdx, uint8 rxCnt, uint8 *pDa, uint32 pktbytes)
{
	uint8 cpu = smp_processor_id();
	
	if(rxCnt) {
		
		fc_db.gemFilter_mib[ruleIdx][cpu].ifInOctets += pktbytes;

		if((pDa[0]&pDa[1]&pDa[2]&pDa[3]&pDa[4]&pDa[5]) == 0xFF)
			fc_db.gemFilter_mib[ruleIdx][cpu].ifInBroadcastPkts++;
		else if(pDa[0]&0x1)
			fc_db.gemFilter_mib[ruleIdx][cpu].ifInMulticastPkts++;
		else
			fc_db.gemFilter_mib[ruleIdx][cpu].ifInUcastPkts++;
		
		if(pktbytes <= 64)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts64Octets++;
		else if(pktbytes < 128)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts65to127Octets++;
		else if(pktbytes < 256)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts128to255Octets++;
		else if(pktbytes < 512)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts256to511Octets++;
		else if(pktbytes < 1024)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts512to1023Octets++;
		else if(pktbytes < 1519)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts1024to1518Octets++;
		else {
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxPkts1519toMaxOctets++;
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsRxOversizePkts++;
		}
	}else {
		fc_db.gemFilter_mib[ruleIdx][cpu].ifOutOctets += pktbytes;
		
		if((pDa[0]&pDa[1]&pDa[2]&pDa[3]&pDa[4]&pDa[5]) == 0xFF)
			fc_db.gemFilter_mib[ruleIdx][cpu].ifOutBrocastPkts++;
		if(pDa[0]&0x1)
			fc_db.gemFilter_mib[ruleIdx][cpu].ifOutMulticastPkts++;
		else
			fc_db.gemFilter_mib[ruleIdx][cpu].ifOutUcastPkts++;
		
		if(pktbytes <= 64)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts64Octets++;
		else if(pktbytes < 128)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts65to127Octets++;
		else if(pktbytes < 256)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts128to255Octets++;
		else if(pktbytes < 512)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts256to511Octets++;
		else if(pktbytes < 1024)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts512to1023Octets++;
		else if(pktbytes < 1519)
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts1024to1518Octets++;
		else {
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxPkts1519toMaxOctets++;
			fc_db.gemFilter_mib[ruleIdx][cpu].etherStatsTxOversizePkts++;
		}
			
	}
}

rtk_fc_ret_t rtk_fc_sw_gemmib_filtering_ingress(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	uint32 i =0;
	uint32 uniPortId=0, ponSid=0;
	uint32 pktbytes;	//include CRC
	uint16 vid = 0;
	uint8 pri = 0;
	
	if(!fc_db.controlFuc.gemFilter_conf_en)
		return RTK_FC_RET_OK;
	
	uniPortId = pPktHdr->ingressPort.macPortIdx;
	ponSid =  pPktHdr->ponstreamid;
	
	if(pPktHdr->outer_svh) {
		vid = pPktHdr->outer_svlanid;
		pri = pPktHdr->outer_svlanpri;
	} else if(pPktHdr->outer_cvh) {
		vid = pPktHdr->outer_cvlanid;
		pri = pPktHdr->outer_cvlanpri;
	} else if(pPktHdr->svh) {
		vid = pPktHdr->svlanid;
		pri = pPktHdr->svlanpri;
	} else if(pPktHdr->cvh) {
		vid = pPktHdr->cvlanid;
		pri = pPktHdr->cvlanpri;
	}
	
	DEBUG("compare rx gem filtering rule by portid %d sid %d vid %d pri %d", uniPortId, ponSid, vid, pri);

	// search and increase rx counter
	for(i = 0; i < RT_STAT_GEMMIB_TABLE_SIZE; i++) {

		if(fc_db.gemFilter_conf[i].enable == TRUE) {

			if((fc_db.gemFilter_conf[i].type == RT_STAT_FILTER_FLOW && uniPortId == RTK_FC_MAC_PORT_PON && fc_db.gemFilter_conf[i].type_flowId == ponSid) || 
				(fc_db.gemFilter_conf[i].type == RT_STAT_FILTER_PORT && fc_db.gemFilter_conf[i].type_flowId == uniPortId)) 
			{

				// check filter rule: flow filtering only because dest uni port is unknown in rx stage

				if((fc_db.gemFilter_conf[i].filter_vid != RT_STAT_GEMMIB_FILTER_VID_INVAILD) && (fc_db.gemFilter_conf[i].filter_vid != vid)) {
					continue;
				}
				if((fc_db.gemFilter_conf[i].filter_pri != RT_STAT_GEMMIB_FILTER_PRI_INVAILD) && (fc_db.gemFilter_conf[i].filter_pri != pri)) {
					continue;
				}
				
				// mib++ if hit
				pktbytes = RTSKB_LEN(rtskb) + 4;
				DEBUG("hit gem filtering mib rule[%d], %s count %d bytes", i, "rx", pktbytes);

				rtk_fc_sw_gemmib_counting(i, TRUE, (pPktHdr->outer_eth) ? &pPktHdr->outer_eth->h_dest[0] : &pPktHdr->eth->h_dest[0], pktbytes);
			}
		}
	}

	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_sw_gemmib_filtering_egress(struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, rtk_fc_shaping_destType_t txDest, void *pTxPriv)
{
	uint32 i =0;
	uint16 uniPortMask=0, ponSid=0;
	uint32 pktbytes;	//include CRC
	uint16 vid = 0;
	uint8 pri = 0, hit = FALSE, rxCnt = FALSE, toPON = FALSE;
	rtk_fc_smp_nicTx_private_t *pNicTxPriv;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	fc_tx_info_t *ptxInfo;
#endif

	pNicTxPriv = (rtk_fc_smp_nicTx_private_t *)pTxPriv;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)	
	ptxInfo = &pNicTxPriv->txInfo;
#endif
	
	if(!fc_db.controlFuc.gemFilter_conf_en)
		return RTK_FC_RET_OK;

	if(txDest!=SHAPING_DESTTYPE_NIC)
		return RTK_FC_RET_OK;

	// prepare filtering data
	if(pPktHdr->flowIdx != FAIL && (pPktHdr->isHitShortcut)) {
		DEBUG("shortcut forward by flow[%d]", pPktHdr->flowIdx);
		
		//3 Shortcut fwd
		if(pPktHdr->abstrSwFlowSearch && fc_db.flowTbl[pPktHdr->flowIdx].pAbstrSwFlowEt) {
			rtk_fc_abstrSwFlowActionList_entry_t *pSwFlowAction = pPktHdr->pCurSwFlowAction;
			rtk_fc_abstrSwFlowActionField_entry_t *pActField,actField={0};

			if(!pSwFlowAction) {
				DEBUG("abst sw flow action is null");
				return RTK_FC_RET_OK;
			}
			pActField = &actField;
			
			rtk_fc_parseAbstrSwActionField((pPktHdr->ip6h?TRUE:FALSE),&pSwFlowAction->swFlowAction,pActField);
		
			if(pSwFlowAction->swFlowAction.bits.stagCmd == SWFLOW_EGACT_TAG) {
				vid = ((*pActField->pSvlanTCI) & VLAN_VID_MASK);
				pri = ((*pActField->pSvlanTCI) & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;
			}else if(pSwFlowAction->swFlowAction.bits.ctagCmd == SWFLOW_EGACT_TAG){
				vid = ((*pActField->pCvlanTCI) & VLAN_VID_MASK);
				pri = ((*pActField->pCvlanTCI) & VLAN_PRIO_MASK)>>VLAN_PRIO_SHIFT;
			}
			if(pSwFlowAction->swFlowAction.bits.ponStreamIdCmd) {
				toPON = TRUE;
				ponSid = (*pActField->pPonStreaId);
				uniPortMask = (1<<RTK_FC_MAC_PORT_PON);	// pNicTxPriv->core_config.bf.ldpid is already translated from sid mapping table(fc_db.streamidTbl) in 77x.
			}else {
				toPON = FALSE;
				//ponSid = 0;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
				uniPortMask = TXINFO_TX_PORTMSK(ptxInfo);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
				uniPortMask = (1<<pNicTxPriv->core_config.bf.ldpid);
#endif
			}
			
		}else
			

		{
		
			if(fc_db.flowTbl[pPktHdr->flowIdx].lutEgrDaIdx == SIGNED_INVALID || fc_db.flowTbl[pPktHdr->flowIdx].lutIgrSaIdx == SIGNED_INVALID) {
				DEBUG("invalid L2 da idx = %d sa idx = %d", fc_db.flowTbl[pPktHdr->flowIdx].lutEgrDaIdx, fc_db.flowTbl[pPktHdr->flowIdx].lutIgrSaIdx);
				return RTK_FC_RET_OK;
			}

			if(fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.in_path <= FB_PATH_34 && fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_uc_lut_lookup==0)
				uniPortMask = fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_portmask;
			else
				uniPortMask = 1<<fc_db.lutTbl[fc_db.flowTbl[pPktHdr->flowIdx].lutEgrDaIdx]->spa;
				
			
			if(fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_svid_format_act){
				vid = fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_svlan_id;
				pri = fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_spri;
			}else if(fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_cvid_format_act){
				vid = fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_cvlan_id;
				pri = fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.out_cpri;
			}

			//fc_db.lutTbl[fc_db.flowTbl[pPktHdr->flowIdx].lutEgrDaIdx]->spa may not eqal to uniPortMask because of flooding
			if(uniPortMask == (1<<RTK_FC_MAC_PORT_PON)) { 
				toPON = TRUE;
				// tx to PON
				ponSid = fc_db.flowTbl[pPktHdr->flowIdx].pFlowEntry->path1.in_out_stream_idx;

				
			}else if(fc_db.lutTbl[fc_db.flowTbl[pPktHdr->flowIdx].lutIgrSaIdx]->spa == RTK_FC_MAC_PORT_PON) {
				toPON = FALSE;
				// rx from PON: filter tx uni port only
				//ponSid = pPktHdr->ponstreamid;
				
			}else
				return RTK_FC_RET_OK;
		}
	
	} else {
		//3 Slowpath fwd

		uniPortMask = 1 << pPktHdr->egressPort.macPortIdx;

		DEBUG("slow path to portmask 0x%x direction %d", uniPortMask, pPktHdr->direction);
		
		if(pPktHdr->outer_svh) {
			vid = pPktHdr->outer_svlanid;
			pri = pPktHdr->outer_svlanpri;
		} else if(pPktHdr->outer_cvh) {
			vid = pPktHdr->outer_cvlanid;
			pri = pPktHdr->outer_cvlanpri;
		} else if(pPktHdr->svh) {
			vid = pPktHdr->svlanid;
			pri = pPktHdr->svlanpri;
		} else if(pPktHdr->cvh) {
			vid = pPktHdr->cvlanid;
			pri = pPktHdr->cvlanpri;
		}
		if((pPktHdr->direction == RTK_FC_FLOW_DIRECTION_UPSTREAM) && 
			pPktHdr->egressPort.macPortIdx == RTK_FC_MAC_PORT_PON) {
			DEBUG("slowpath forward, flow[%d]", pPktHdr->flowIdx);
			toPON = TRUE;
			
			if(pPktHdr->remarkDec.streamId_en)
				ponSid = pPktHdr->remarkDec.streamId;


		}else if((pPktHdr->direction == RTK_FC_FLOW_DIRECTION_DOWNSTREAM) &&
			pPktHdr->ingressPort.macPortIdx == RTK_FC_MAC_PORT_PON){
			toPON = FALSE;
			//ponSid = pIgrData->ponStreamId;

		}else{
			DEBUG("not us to pon or ds from pon, skip.");
			return RTK_FC_RET_OK;
		}
	}

	DEBUG("compare gem filtering rule by portmask 0x%x sid %d vid %d pri %d", uniPortMask, ponSid, vid, pri);

	// search and increase counter
	for(i = 0; i < RT_STAT_GEMMIB_TABLE_SIZE; i++) {
		hit = FALSE;
		if(fc_db.gemFilter_conf[i].enable == TRUE) {

			DEBUG("gem filter rule[%d] %s id %d", i, fc_db.gemFilter_conf[i].type == RT_STAT_FILTER_FLOW ? "flow" : "port", fc_db.gemFilter_conf[i].type_portId);
			
			if((fc_db.gemFilter_conf[i].type == RT_STAT_FILTER_FLOW && toPON && fc_db.gemFilter_conf[i].type_flowId == ponSid) || 
				(fc_db.gemFilter_conf[i].type == RT_STAT_FILTER_PORT && ((1<<fc_db.gemFilter_conf[i].type_portId) & uniPortMask)) ) 
			{
				hit = TRUE;
				if((fc_db.gemFilter_conf[i].filter_vid != RT_STAT_GEMMIB_FILTER_VID_INVAILD) && (fc_db.gemFilter_conf[i].filter_vid != vid)) {
					hit = FALSE;
				}
				if((fc_db.gemFilter_conf[i].filter_pri != RT_STAT_GEMMIB_FILTER_PRI_INVAILD) && (fc_db.gemFilter_conf[i].filter_pri != pri)) {
					hit = FALSE;
				}	
				
				pktbytes = pPktHdr->skbLen_egress+4;
				rxCnt = FALSE;	// ds to specific uni port, count tx counter
			}

			if(hit) {
				DEBUG("hit gem filtering mib rule[%d], %s count %d bytes", i, rxCnt?"rx":"tx", pktbytes);

				if (likely(pPktHdr->outer_eth || pPktHdr->eth)) {
					rtk_fc_sw_gemmib_counting(i, rxCnt, (pPktHdr->outer_eth) ? &pPktHdr->outer_eth->h_dest[0] : &pPktHdr->eth->h_dest[0], pktbytes);
				}
				else {
					DEBUG("pPktHdr->outer_eth and pPktHdr->eth are NULL pointers");
				}
			}
		}
	}


	
	return RTK_FC_RET_OK;
}

int rtk_fc_sw_shaper_skip_specific_tcp(rtk_fc_pktHdr_t *pPktHdr)
{
	if (pPktHdr && pPktHdr->iph && pPktHdr->tcph) {
		if (pPktHdr->tcph->syn) {
			TRACE("IPv4 TCP syn with ip id=0x%x, skip sw shaper", ntohs(pPktHdr->iph->id));
			return TRUE;
		}
		else if (pPktHdr->tcph->fin || pPktHdr->tcph->rst) {
			TRACE("IPv4 TCP fin or rst with ip id=0x%x, skip sw shaper", ntohs(pPktHdr->iph->id));
			return TRUE;
		}
		else if (pPktHdr->tcph->ack && !pPktHdr->tcph->urg && !pPktHdr->tcph->ece && !pPktHdr->tcph->cwr) {
			if (!pPktHdr->tcph->psh && (ntohs(pPktHdr->iph->tot_len) - ((pPktHdr->iph->ihl) << 2) - ((pPktHdr->tcph->doff) << 2)) == 0) {
				TRACE("IPv4 TCP data ack with ip id=0x%x, skip sw shaper", ntohs(pPktHdr->iph->id));
				return TRUE; 			
			}
			else if (pPktHdr->tcph->psh && (ntohs(pPktHdr->iph->tot_len) - ((pPktHdr->iph->ihl) << 2) - ((pPktHdr->tcph->doff) << 2)) == 1) {
				// for chariot TCP throughput script last ack
				TRACE("IPv4 TCP transaction last ack with ip id=0x%x, skip sw shaper", ntohs(pPktHdr->iph->id));
				return TRUE;
			}
		}
	}
	else if (pPktHdr && pPktHdr->ip6h && pPktHdr->tcph) {
		if (pPktHdr->tcph->syn) {
			TRACE("IPv6 TCP syn, skip sw shaper");
			return TRUE;
		}
		else if (pPktHdr->tcph->fin || pPktHdr->tcph->rst) {
			TRACE("IPv6 TCP fin or rst, skip sw shaper");
			return TRUE;
		}
		else if (pPktHdr->tcph->ack && !pPktHdr->tcph->urg && !pPktHdr->tcph->ece && !pPktHdr->tcph->cwr) {
			if(!pPktHdr->tcph->psh && (ntohs(pPktHdr->ip6h->payload_len) - ((pPktHdr->tcph->doff) << 2)) == 0) {
				TRACE("IPv6 TCP data ack with sip 0x%x, skip sw shaper", pPktHdr->ipv6Sip_hash);
				return TRUE;
			}
			else if(pPktHdr->tcph->psh && (ntohs(pPktHdr->ip6h->payload_len) - ((pPktHdr->tcph->doff) << 2)) == 1) {
				TRACE("IPv6 TCP transaction last ack with sip 0x%x, skip sw shaper", pPktHdr->ipv6Sip_hash);
				return TRUE;
			}
		}
	}

	return FALSE;
}

__IRAM_FC_SHORTCUT
int _rtk_fc_sw_shaper_mib_counting(int16 smacHostPolIdx, int16 dmacHostPolIdx, int32 flowTblIdx, int skbLenIgr, int skbLenEgr, uint16 payloadLen)
{
	/*
	 * Per CPU counters. no need to get functional spinlock first.
	 */
	int flowMibIdx = SIGNED_INVALID;
	int intfIdxIgr = SIGNED_INVALID, intfIdxEgr = SIGNED_INVALID;

	if((smacHostPolIdx != SIGNED_INVALID) || (dmacHostPolIdx != SIGNED_INVALID))
		_rtk_fc_sw_hostPolicingMibCounting(smacHostPolIdx, dmacHostPolIdx, skbLenIgr, skbLenEgr, payloadLen);

	if(flowTblIdx != SIGNED_INVALID)
	{
		rtk_fc_tableFlowEntry_t *pTxFlowEnt = fc_db.flowTbl[flowTblIdx].pFlowEntry;
		rtk_fc_packetType_t pktType = (FLOW_INFO_IS_SET(&fc_db.flowTbl[flowTblIdx], FLOW_INFO_MC_ENTRY))?RTK_FC_PKTTYPE_MC:RTK_FC_PKTTYPE_UC;

#if defined(CONFIG_RTK_L34_CANDIDATE_FLOW)
		if(fc_db.flowTbl[flowTblIdx].candidateState!=CANDIDATE_STATE_NONE)
#else
		if((pTxFlowEnt->path1.valid) || (fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt))
#endif
		{
			if(fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt)
			{
				rtk_fc_abstrSwFlowActionList_entry_t *pTmpSwFlowAction;

				list_for_each_entry(pTmpSwFlowAction, &fc_db.flowTbl[flowTblIdx].pAbstrSwFlowEt->swFlowActionHdr, swFlowActionList)
				{
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
					intfIdxIgr = pTmpSwFlowAction->igrIntf;
					intfIdxEgr = 0; // egress interface fix to 0
#else
					// not support MC interface counter
#endif
#else
					intfIdxIgr = pTmpSwFlowAction->igrIntf;
					intfIdxEgr = pTmpSwFlowAction->egrIntf;
#endif
					if((intfIdxIgr != SIGNED_INVALID) && (intfIdxEgr != SIGNED_INVALID))
						_rtk_fc_sw_intfFlowMibCounting(flowMibIdx, intfIdxIgr, skbLenIgr, intfIdxEgr, skbLenEgr, pktType, payloadLen);
					break;
				}
			}
			else if((pTxFlowEnt->path1.in_path == FB_PATH_12) || (pTxFlowEnt->path1.in_path == FB_PATH_34) || (pTxFlowEnt->path1.in_path == FB_PATH_5))
			{
				if(pTxFlowEnt->path1.out_flow_counter_act)
					flowMibIdx = pTxFlowEnt->path1.out_flow_counter_idx;
				intfIdxIgr = pTxFlowEnt->path1.in_intf_idx;
				intfIdxEgr = pTxFlowEnt->path1.out_intf_idx;

				if((intfIdxIgr != SIGNED_INVALID) && (intfIdxEgr != SIGNED_INVALID))
					_rtk_fc_sw_intfFlowMibCounting(flowMibIdx, intfIdxIgr, skbLenIgr, intfIdxEgr, skbLenEgr, pktType, payloadLen);

				if(fc_db.controlFuc.sw_per_flow_mib)
					_rtk_fc_sw_perFlowCounting(flowTblIdx, skbLenIgr, payloadLen);
			}
		}
	}
	return RTK_FC_RET_OK;
}

__IRAM_FC_SHORTCUT
int rtk_fc_sw_shaper_rate_couting(uint32 shapingCtrlIdx, uint32 skbOrPayLaodLen, uint8 reschedule, rtk_fc_sw_shaperMib_update_modeType_t updateMode)
{
	// L34 Meter
	uint32 pktLen = skbOrPayLaodLen;
	rtk_fc_sw_meter_t *meterConf=NULL;

	if(shapingCtrlIdx < RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER)
		meterConf = &fc_db.l34Meter[shapingCtrlIdx - RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_FLOWMETER];
	else
		meterConf = &fc_db.swMeter[shapingCtrlIdx - RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER];

	if(updateMode == SW_SHAPERMIB_UPDATE_BY_PKTLEN)
	{
		pktLen += 4;		// 4 bytes CRC
		if(meterConf->ifgInclude == ENABLED)
			pktLen += 20; /*interframe  gap*/
	}

	if(time_after_eq(jiffies, meterConf->lastJiffies + RTK_FC_SW_SHAPING_JIFFIES/*unit:(RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)sec*/))
	{
		meterConf->lastBandwthByte_preInterval = meterConf->lastBandwthByte_curInterval;
		meterConf->lastBandwthByte_curInterval = 0;
		memset(&meterConf->meterCount, 0, sizeof(rtk_fc_meterCount_t));
		meterConf->lastJiffies = jiffies;
	}

	if(reschedule == FALSE){
		if(atomic_read(&fc_db.shapingCtrl[shapingCtrlIdx].congestion) == TRUE)
			return RTK_FC_RET_ERR_OVER_RATE_LIMIT;
	}

	//Check if over rate limit (Only support bit rate now)
	{
		/*rate limit bits in time period*/
		if((meterConf->meterCount.byteCount+pktLen) > ((meterConf->rate*((1000/8)*RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)/*unit:(RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)sec*/) + meterConf->lastBandwthByte_preInterval))
		{
			meterConf->lastBandwthByte_curInterval = ((meterConf->rate*((1000/8)*RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)/*unit:(RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)sec*/) + meterConf->lastBandwthByte_preInterval) - meterConf->meterCount.byteCount;
			TRACE("the packet belongs to %s[%d], and over its rate limit.", (shapingCtrlIdx < RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER)?"flow_meter":"sw_meter", (shapingCtrlIdx < RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER)?shapingCtrlIdx-RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_FLOWMETER:shapingCtrlIdx-RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER);
			return RTK_FC_RET_ERR_OVER_RATE_LIMIT;
		}

	}
	TRACE("the packet belongs to %s[%d], continue tx.", (shapingCtrlIdx < RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER)?"flow_meter":"sw_meter", (shapingCtrlIdx < RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER)?shapingCtrlIdx-RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_FLOWMETER:shapingCtrlIdx-RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER);

	meterConf->meterCount.byteCount += pktLen;
	meterConf->meterCount.packetCount++;
	return RTK_FC_RET_OK;
}

void rtk_fc_sw_shaper_kicktx_timerfunc(unsigned long task_priv)
{
	// de-queue
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	unsigned int cnt=RTK_FC_MAX_SHAPING_QUEUE_SIZE;
	rtk_fc_shaping_bucket_t *pOldestOne = NULL;
	int scheduleidx = 0;
	bool resched = FALSE;
	uint32 shapingCtrlIdx;
	uint8 ifPayLoadLenMode;
	uint32 skblen, rateUpdateLen;
	uint32 burstBytes = 0, burstBytes_threshold = 0;
	rtk_fc_sw_meter_t *meterConf=NULL;
	unsigned long int jiffies_elaspe_after_timerKick;
	
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
	RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_SHAPER_MIB, 0);

	shapingCtrlIdx = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	
	scheduleidx = atomic_read(&fc_db.shapingCtrl[shapingCtrlIdx].sched_idx);

	pOldestOne = &fc_db.shapingCtrl[shapingCtrlIdx].queue[scheduleidx];

	if(shapingCtrlIdx < RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER)
	{
		ifPayLoadLenMode = (fc_db.controlFuc.sw_shaperMib_update_mode_flow == SW_SHAPERMIB_UPDATE_BY_PAYLOADLEN)?TRUE:FALSE;
		meterConf = &fc_db.l34Meter[shapingCtrlIdx - RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_FLOWMETER];
	}
	else
	{
		ifPayLoadLenMode = (fc_db.controlFuc.sw_shaperMib_update_mode_host == SW_SHAPERMIB_UPDATE_BY_PAYLOADLEN)?TRUE:FALSE;
		meterConf = &fc_db.swMeter[shapingCtrlIdx - RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER];
	}

	if(unlikely(atomic_read(&pOldestOne->state) == SMP_WORK_STATE_FREE))
	{
		TRACE("timer func cpu[%d] process shapingCtrlIdx %d --- empty", smp_processor_id(), shapingCtrlIdx);
		//empty tx queue
		atomic_set(&fc_db.shapingCtrl[shapingCtrlIdx].congestion, 0);// to allow smp_call_function
		
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_SHAPER_MIB, 0);
		RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
		return;
	}

	jiffies_elaspe_after_timerKick = jiffies - fc_db.shapingCtrl[shapingCtrlIdx].lastJiffies_kickTimer;
	burstBytes_threshold = ((meterConf->rate*((1000/8)*RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)/*unit:(RTK_FC_SW_SHAPING_JIFFIES/CONFIG_HZ)sec*/) + meterConf->lastBandwthByte_preInterval) / (RTK_FC_SW_SHAPING_JIFFIES/jiffies_elaspe_after_timerKick);
	burstBytes_threshold += RTK_FC_SW_SHAPING_BURST_BYTES; // Tolerance
	
	do{
		if(pOldestOne->buffInfo.txDest == SHAPING_DESTTYPE_WIFI)
			RTK_FC_HOOK_PS_SKB_PARAM_GET(pOldestOne->wifiTxPriv.skb, RTK_FC_SKB_PARAM_LEN, &skblen);
		else
			RTK_FC_HOOK_PS_SKB_PARAM_GET(pOldestOne->nicTxPriv.skb, RTK_FC_SKB_PARAM_LEN, &skblen);
		
		rateUpdateLen = ifPayLoadLenMode?pOldestOne->payLoadLen:skblen;

		ret = rtk_fc_sw_shaper_rate_couting(shapingCtrlIdx, rateUpdateLen, TRUE, ifPayLoadLenMode);

		if(ret == RTK_FC_RET_OK) {
			if(pOldestOne->buffInfo.txDest == SHAPING_DESTTYPE_WIFI) {
				fc_rx_info_t tmpRxInfo;
				fc_rx_info_t *pTmpRxInfo = &tmpRxInfo;
				RXINFO_INT_PRI(pTmpRxInfo) = pOldestOne->wifiTxPriv.outputQid; // only this fields in tmpRxInfo valid for wifi TX, ignore other fields
#if defined(CONFIG_RTK_L34_G3_PLATFORM) && defined(CONFIG_FC_QTNA_WIFI_AX)
				RXINFO_IS_WIFI_FF(pTmpRxInfo) = 0;
#endif
				RTK_FC_HELPER_WLAN_HARD_START_XMIT(pOldestOne->wifiTxPriv.wlandevidx, pOldestOne->wifiTxPriv.skb, pTmpRxInfo);
			}
			else{
				RTK_FC_HELPER_MGR_NIC_TX(&pOldestOne->nicTxPriv);
			}
			fc_db.shapingCtrl[shapingCtrlIdx].pausetxcnt++;
			/*
			slow path:
				ingress: SMAC host (ingress skb lenth here)
				egress: DMAC host + flow (egress skb lenth here)
			shortcut:
				ingress: SMAC host + DMAC host + flow (egress skb lenth here)
			*/			
			_rtk_fc_sw_shaper_mib_counting(
			pOldestOne->buffInfo.smacHostPolIdx_vld?pOldestOne->buffInfo.smacHostPolIdx:SIGNED_INVALID,
			pOldestOne->buffInfo.dmacHostPolIdx_vld?pOldestOne->buffInfo.dmacHostPolIdx:SIGNED_INVALID,
			pOldestOne->buffInfo.flowTblIdx_vld?pOldestOne->buffInfo.flowTblIdx:SIGNED_INVALID,
			skblen, skblen, pOldestOne->payLoadLen);
		}else {
			resched = TRUE;
			break;
		}
		
		scheduleidx += 1;
		scheduleidx &= (RTK_FC_MAX_SHAPING_QUEUE_SIZE-1);
		smp_mb(); 
		
		atomic_set(&pOldestOne->state, SMP_WORK_STATE_FREE);
		atomic_set(&fc_db.shapingCtrl[shapingCtrlIdx].sched_idx, scheduleidx);
		pOldestOne = &fc_db.shapingCtrl[shapingCtrlIdx].queue[scheduleidx];

		if(unlikely(atomic_read(&pOldestOne->state) == SMP_WORK_STATE_FREE)) {
			pOldestOne = NULL;
		}

		burstBytes += rateUpdateLen;
		if(burstBytes >= burstBytes_threshold)
		{
			resched = TRUE;
			break;
		}
	}while((pOldestOne) && (--cnt>0));


	if(cnt == 0)
		resched = TRUE;

	if(resched) {
		// schedule timer
		fc_db.shapingCtrl[shapingCtrlIdx].lastJiffies_kickTimer = jiffies;
		RTK_FC_HELPER_MOD_TIMER(fc_db.shapingCtrl[shapingCtrlIdx].kicktxtimer, jiffies + RTK_FC_SW_SHAPING_TIMER_TICK);
	}else{
		atomic_set(&fc_db.shapingCtrl[shapingCtrlIdx].congestion, 0);// to allow smp_call_function
	}
	
	RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_SHAPER_MIB, 0);
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	
}

__IRAM_FC_SHORTCUT
rtk_fc_ret_t rtk_fc_sw_shaper(rtk_fc_shaping_destType_t txDest, void *pTxPriv, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr, bool isIngress, bool isEgress)
{
	rtk_fc_ret_t ret = RTK_FC_RET_OK;
	int freeidx = 0;
	rtk_fc_smp_nicTx_private_t *pNicTxPriv = (rtk_fc_smp_nicTx_private_t *)pTxPriv;
	rtk_fc_smp_wifiTx_private_t *pWifiTxPriv = (rtk_fc_smp_wifiTx_private_t *)pTxPriv;
	rtk_fc_shaping_bucket_t *pFirstOne=NULL;
	uint32 shapingCtrlIdx = 0, minCongestionRate = 0xFFFFFFFF;
	bool ifCongestion = FALSE;
	uint32 sa_rateUpdateLen, da_rateUpdateLen, flow_rateUpdateLen;
	int32 sa_shapingCtrlIdx = SIGNED_INVALID, da_shapingCtrlIdx = SIGNED_INVALID, flow_shapingCtrlIdx = SIGNED_INVALID;
	int16 mib_smacHostPolIdx = SIGNED_INVALID, mib_dmacHostPolIdx = SIGNED_INVALID;
	int mib_flowTblIdx = SIGNED_INVALID;

	/* pktLenIgr or pktLenEgr may be 0
	     For example, MC shortcut flow, only the first egress packet will be set to non-zero pktLenIgr*/
	if((isIngress) && (pPktHdr->skbLen_ingress))
	{
		//2sw host SMAC shaping check
		if((pPktHdr->smacHostPolIdx != SIGNED_INVALID) && fc_db.hostPoliceTable[pPktHdr->smacHostPolIdx].hostPoliceControl.mib_count_control)
			mib_smacHostPolIdx = pPktHdr->smacHostPolIdx;
		if((pPktHdr->smacHostPolIdx != SIGNED_INVALID) && fc_db.hostPoliceTable[pPktHdr->smacHostPolIdx].ingress_limit_by_swShaper)
		{
			sa_shapingCtrlIdx = fc_db.hostPoliceTable[pPktHdr->smacHostPolIdx].ingress_limit_meter_hwIndex + RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER;
			if(fc_db.controlFuc.sw_shaperMib_update_mode_host)
				sa_rateUpdateLen = pPktHdr->payloadLen;
			else
				sa_rateUpdateLen = pPktHdr->skbLen_ingress;
		}
	}

	if((isEgress) && (pPktHdr->skbLen_egress))
	{
		
		//2sw host DMAC shaping check
		if((pPktHdr->dmacHostPolIdx != SIGNED_INVALID) && fc_db.hostPoliceTable[pPktHdr->dmacHostPolIdx].hostPoliceControl.mib_count_control)
			mib_dmacHostPolIdx = pPktHdr->dmacHostPolIdx;
		if((pPktHdr->dmacHostPolIdx != SIGNED_INVALID) && fc_db.hostPoliceTable[pPktHdr->dmacHostPolIdx].egress_limit_by_swShaper)
		{
			da_shapingCtrlIdx = fc_db.hostPoliceTable[pPktHdr->dmacHostPolIdx].egress_limit_meter_hwIndex + RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_SWMETER;
			if(fc_db.controlFuc.sw_shaperMib_update_mode_host)
				da_rateUpdateLen = pPktHdr->payloadLen;
			else
				da_rateUpdateLen = pPktHdr->skbLen_egress;
		
		}

		//2sw flow shaping check
		mib_flowTblIdx =  pPktHdr->flowIdx;
		if(unlikely(pPktHdr->remarkDec.swShaper_en))
		{
			flow_shapingCtrlIdx = pPktHdr->remarkDec.meterIdx + RTK_FC_SW_SHAPING_CTRL_IDX_OFFSET_FLOWMETER;
			if(fc_db.controlFuc.sw_shaperMib_update_mode_flow  == SW_SHAPERMIB_UPDATE_BY_PAYLOADLEN)
				flow_rateUpdateLen = pPktHdr->payloadLen;
			else
				flow_rateUpdateLen = pPktHdr->skbLen_egress;
		}

		
	}

	//2 Congestion control
	if((sa_shapingCtrlIdx!= SIGNED_INVALID) || (da_shapingCtrlIdx!= SIGNED_INVALID) || (flow_shapingCtrlIdx!= SIGNED_INVALID))
	{
		RTK_FC_HELPER_MGR_FUNC_SPIN_LOCK(RTK_FC_FUNC_LOCK_SHAPER_MIB, 0);
	
		if(sa_shapingCtrlIdx!= SIGNED_INVALID) {
			if(rtk_fc_sw_shaper_rate_couting(sa_shapingCtrlIdx, sa_rateUpdateLen, FALSE, fc_db.controlFuc.sw_shaperMib_update_mode_host) != RTK_FC_RET_OK)
			{
				ifCongestion = TRUE;
				if(fc_db.swMeter[fc_db.hostPoliceTable[pPktHdr->smacHostPolIdx].ingress_limit_meter_hwIndex].rate < minCongestionRate)
				{
					shapingCtrlIdx = sa_shapingCtrlIdx;
					minCongestionRate = fc_db.swMeter[fc_db.hostPoliceTable[pPktHdr->smacHostPolIdx].ingress_limit_meter_hwIndex].rate;
				}
			}
		}

		if(da_shapingCtrlIdx!= SIGNED_INVALID) {
			if(rtk_fc_sw_shaper_rate_couting(da_shapingCtrlIdx, da_rateUpdateLen, FALSE, fc_db.controlFuc.sw_shaperMib_update_mode_host) != RTK_FC_RET_OK)
			{
				ifCongestion = TRUE;
				if(fc_db.swMeter[fc_db.hostPoliceTable[pPktHdr->dmacHostPolIdx].egress_limit_meter_hwIndex].rate < minCongestionRate)
				{
					shapingCtrlIdx = da_shapingCtrlIdx;
					minCongestionRate = fc_db.swMeter[fc_db.hostPoliceTable[pPktHdr->dmacHostPolIdx].egress_limit_meter_hwIndex].rate;
				}
			}
		}
		
		if(flow_shapingCtrlIdx!= SIGNED_INVALID) {
			if(rtk_fc_sw_shaper_rate_couting(flow_shapingCtrlIdx, flow_rateUpdateLen, FALSE, fc_db.controlFuc.sw_shaperMib_update_mode_flow) != RTK_FC_RET_OK)
			{
				ifCongestion = TRUE;
				if(fc_db.l34Meter[pPktHdr->remarkDec.meterIdx].rate < minCongestionRate)
				{
					shapingCtrlIdx = flow_shapingCtrlIdx;
					minCongestionRate = fc_db.l34Meter[pPktHdr->remarkDec.meterIdx].rate;
				}
			}
		}
		
		if (rtk_fc_sw_shaper_skip_specific_tcp(pPktHdr) == TRUE) {
			ifCongestion = FALSE;
		}

		if(ifCongestion){
			// RTK_FC_RET_ERR_OVER_RATE_LIMIT
			/*
			 * Enqueue
			 */
			atomic_set(&fc_db.shapingCtrl[shapingCtrlIdx].congestion, 1);
			
			freeidx = atomic_read(&fc_db.shapingCtrl[shapingCtrlIdx].free_idx);
			
			pFirstOne = &fc_db.shapingCtrl[shapingCtrlIdx].queue[freeidx];

			if(unlikely(atomic_read(&pFirstOne->state) == SMP_WORK_STATE_SCHED))
			{
			
				TRACE("congestion - no free buffer (shapingCtrlIdx %d work idx %d)", shapingCtrlIdx, freeidx);

				// caller will call dev_kfree_skb_any and take care of fwdStatistic counter
				ret = RTK_FC_RET_DROP_SHAPING_RATE_LIMIT;
			}else{
				//Setup information
				memset(&pFirstOne->buffInfo, 0, sizeof(pFirstOne->buffInfo));
				if(mib_smacHostPolIdx != SIGNED_INVALID)
				{
					pFirstOne->buffInfo.smacHostPolIdx_vld = TRUE;
					pFirstOne->buffInfo.smacHostPolIdx = mib_smacHostPolIdx & 0x1f;
				}
				if(mib_dmacHostPolIdx != SIGNED_INVALID)
				{
					pFirstOne->buffInfo.dmacHostPolIdx_vld = TRUE;
					pFirstOne->buffInfo.dmacHostPolIdx = mib_dmacHostPolIdx & 0x1f;
				}
				if(mib_flowTblIdx != SIGNED_INVALID)
				{
					pFirstOne->buffInfo.flowTblIdx_vld = TRUE;
					pFirstOne->buffInfo.flowTblIdx = mib_flowTblIdx & 0x1ffff;
				}
				if(txDest == SHAPING_DESTTYPE_WIFI){
					pFirstOne->buffInfo.txDest = txDest;
					memcpy(&pFirstOne->wifiTxPriv, pTxPriv, sizeof(rtk_fc_smp_wifiTx_private_t));
				}
				else{
					pFirstOne->buffInfo.txDest = txDest;
					memcpy(&pFirstOne->nicTxPriv, pTxPriv, sizeof(rtk_fc_smp_nicTx_private_t));
				}
				
				freeidx += 1;
				freeidx &= (RTK_FC_MAX_SHAPING_QUEUE_SIZE-1);
				smp_mb(); 
				
				atomic_set(&fc_db.shapingCtrl[shapingCtrlIdx].free_idx, freeidx);
				atomic_set(&pFirstOne->state, SMP_WORK_STATE_SCHED);
				pFirstOne->payLoadLen = pPktHdr->payloadLen;
				fc_db.shapingCtrl[shapingCtrlIdx].enququcnt++;

				if(unlikely(fc_db.controlFuc.gemFilter_conf_en))
					rtk_fc_sw_gemmib_filtering_egress(rtskb, pPktHdr, txDest, pTxPriv);

				ret = RTK_FC_RET_OK;
			}
			
			// schedule timer
			if(!RTK_FC_HELPER_TIMER_PENDING(fc_db.shapingCtrl[shapingCtrlIdx].kicktxtimer))
			{
				fc_db.shapingCtrl[shapingCtrlIdx].lastJiffies_kickTimer = jiffies;
				RTK_FC_HELPER_MOD_TIMER(fc_db.shapingCtrl[shapingCtrlIdx].kicktxtimer, jiffies + RTK_FC_SW_SHAPING_TIMER_TICK);
			}

		}
			
		RTK_FC_HELPER_MGR_FUNC_SPIN_UNLOCK(RTK_FC_FUNC_LOCK_SHAPER_MIB, 0);
	}

	if(!ifCongestion) {
		TRACE("non-congestion - continue %s tx", (txDest == SHAPING_DESTTYPE_WIFI)?"wifi":"nic");
		
		
		if(txDest == SHAPING_DESTTYPE_WIFI) {
			fc_rx_info_t tmpRxInfo;
			fc_rx_info_t *pTmpRxInfo = &tmpRxInfo;
			RXINFO_INT_PRI(pTmpRxInfo) = pWifiTxPriv->outputQid; // only this fields in tmpRxInfo valid for wifi TX, ignore other fields
#if defined(CONFIG_RTK_L34_G3_PLATFORM) && defined(CONFIG_FC_QTNA_WIFI_AX)
			RXINFO_IS_WIFI_FF(pTmpRxInfo) = 0;
#endif
			RTK_FC_HELPER_WLAN_HARD_START_XMIT(pWifiTxPriv->wlandevidx, pWifiTxPriv->skb, pTmpRxInfo);
		}
		else {
			RTK_FC_HELPER_MGR_NIC_TX(pNicTxPriv);
		}
		
		if(unlikely(fc_db.controlFuc.gemFilter_conf_en))
			rtk_fc_sw_gemmib_filtering_egress(rtskb, pPktHdr, txDest, pTxPriv);
		
		//no congestion, update netif/flow counter
		_rtk_fc_sw_shaper_mib_counting(mib_smacHostPolIdx, mib_dmacHostPolIdx, mib_flowTblIdx, pPktHdr->skbLen_ingress, pPktHdr->skbLen_egress, pPktHdr->payloadLen);
		
	}

	return ret;
}

/*
 * NIC direct Tx only, wifi hardware lookup is done by mgr module.
 */
__IRAM_FC_SHORTCUT
rtk_fc_ret_t rtk_fc_nic_send_with_txInfo(struct rt_skbuff *rtskb, fc_tx_info_t* ptxInfo, int ring_num, rtk_fc_pktHdr_t* pPktHdr)
{
	rtk_fc_smp_nicTx_private_t smp_nicTx_info={0};
	
#if defined(CONFIG_RTL8686NIC)
	smp_nicTx_info.skb = RTSKB_SKB(rtskb);
	memcpy(&smp_nicTx_info.txInfo, ptxInfo, sizeof(smp_nicTx_info.txInfo));

	/*
	 * sw shaper handler
	 */	
	if((RTSKB_FCIGRDATA(rtskb)->isNotLocalOut) || (pPktHdr->isHitShortcut))
		return rtk_fc_sw_shaper(SHAPING_DESTTYPE_NIC, &smp_nicTx_info, rtskb, pPktHdr, TRUE, TRUE);
	else
		return rtk_fc_sw_shaper(SHAPING_DESTTYPE_NIC, &smp_nicTx_info, rtskb, pPktHdr, FALSE, FALSE);

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)

	int ldpid = 0;
	ni_tx_core_config_t *p_core_config = &smp_nicTx_info.core_config;
	uint32 flowid = 0;
	

#if defined(CONFIG_FC_RTL8198F_SERIES)
	if(TXINFO_PE_PORTMSK(ptxInfo))
		ldpid = (63 - __builtin_clzll(TXINFO_PE_PORTMSK(ptxInfo)));				// directTx to physical port
	else
#endif
		ldpid = (63 - __builtin_clzll(TXINFO_TX_PORTMSK(ptxInfo)));				// directTx to physical port

	if(unlikely((ldpid == AAL_LPORT_L3_LAN) || (ldpid == AAL_LPORT_L3_WAN)))
	{
		//dev_kfree_skb_any(RTSKB_SKB(rtskb));
		WARNING("dirtx to %d is forbidden! drop packet", ldpid);
		return RTK_FC_RET_DROP;
	}

#if defined(CONFIG_FC_CAG3_SERIES)		// 8277A
	if(TXINFO_CPUTAG_PSEL(ptxInfo)) { // PON SID
		uint16 vlanTCI = TXINFO_TX_DST_STREAM_ID(ptxInfo);
		if(pPktHdr->cvh) {
			vlanTCI |= (ntohs(pPktHdr->cvh->h_vlan_TCI) & VLAN_PRIO_MASK);
		}
		rtk_fc_skbVlanTag_insert(rtskb, pPktHdr, vlanTCI, TRUE);
	}
#elif !defined(CONFIG_FC_RTL8198F_SERIES)	// 8277B, 8277C,
	if(TXINFO_CPUTAG_PSEL(ptxInfo) && 
		(TXINFO_TX_PORTMSK(ptxInfo) & fc_db.wanPortMask.portmask)) { // PON SID

		p_core_config->bf.ldpid = fc_db.streamidTbl[TXINFO_TX_DST_STREAM_ID(ptxInfo)].ldpid;
		p_core_config->bf.txq_index = fc_db.streamidTbl[TXINFO_TX_DST_STREAM_ID(ptxInfo)].cos;	
		p_core_config->bf.flow_id_set = TRUE;
		p_core_config->bf.lspid = RTK_FC_MAC_PORT_CPU1; // for mirror function: if enabling pon port(0x7) egress mirror, the ldpid may be 0x20~0x2F
		
		flowid = fc_db.streamidTbl[TXINFO_TX_DST_STREAM_ID(ptxInfo)].gemid;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		smp_nicTx_info.stream_id = TXINFO_TX_DST_STREAM_ID(ptxInfo);
#endif
	}else
#endif									// ethernet, 8198F, 
	{
		p_core_config->bf.lspid = RTK_FC_MAC_PORT_CPU;
		p_core_config->bf.ldpid = ldpid;
		p_core_config->bf.txq_index = TXINFO_CPUTAG_PRI(ptxInfo);	
	}
	
#if defined(CONFIG_FC_RTL8277C_SERIES)
	if(unlikely(fc_db.controlFuc.tx_with_hdr_debug))
		smp_nicTx_info.force_def_tx_en = TRUE;
#endif
	p_core_config->bf.is_from_ca_tx =  TRUE;
	p_core_config->bf.bypass_fwd_engine =  TRUE;
	
	TRACE("CA NI tx to %s port[%d]", RTSKB_DEV(rtskb)?RTSKB_DEV(rtskb)->name:"NULL", ldpid);

#if defined(CONFIG_FC_RTL8198F_SERIES)
	if ((atomic_read(&fc_db.dsliteUdpFrag)!=0) && (pPktHdr->outer_iph != NULL) &&
		(pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE)&&
		(RTSKB_LEN(rtskb)-(skb_network_header(RTSKB_SKB(rtskb))-skb_mac_header(RTSKB_SKB(rtskb))) > RTSKB_DEV(rtskb)->mtu) ){

		ca_ni_tx_config_t ca_tx_config={0};
		DSLITE("[Ds-Lite][UDP fragment] RTSKB_LEN(rtskb)=%d, RTSKB_DEV(rtskb)->mtu=%d", RTSKB_LEN(rtskb), RTSKB_DEV(rtskb)->mtu);

		memcpy(&ca_tx_config.core_config, p_core_config, sizeof(ni_tx_core_config_t));
		ca_tx_config.flow_id = flowid;
		RTK_FC_HOOK_DSLITE_IPV6_FGRAMENT(RTSKB_SKB(rtskb), RTSKB_DEV(rtskb), &ca_tx_config, nic_egress_start_xmit);

	}else
#endif
	{
	
		smp_nicTx_info.skb = RTSKB_SKB(rtskb);
		smp_nicTx_info.flow_id = flowid;
		smp_nicTx_info.lso_para0 = pPktHdr->txlso_para0;
		
		/*
		 * sw shaper handler
		 */	
		if((RTSKB_FCIGRDATA(rtskb)->isNotLocalOut) || (pPktHdr->isHitShortcut))
			return rtk_fc_sw_shaper(SHAPING_DESTTYPE_NIC, &smp_nicTx_info, rtskb, pPktHdr, TRUE, TRUE);
		else
			return rtk_fc_sw_shaper(SHAPING_DESTTYPE_NIC, &smp_nicTx_info, rtskb, pPktHdr, FALSE, FALSE);
	}

#endif

	return RTK_FC_RET_OK;
}

__IRAM_FC_SHORTCUT
rtk_fc_ret_t rtk_fc_wifi_send_with_wlandevidx(rtk_fc_wlan_devidx_t wlan_dev_idx, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t* pPktHdr, uint8 outputQid)
{
	rtk_fc_smp_wifiTx_private_t wifiTxPriv;

	/*
	 * sw shaper handler
	 */	
	wifiTxPriv.skb = RTSKB_SKB(rtskb);
	wifiTxPriv.wlandevidx = wlan_dev_idx;
	wifiTxPriv.outputQid = outputQid;

	if((RTSKB_FCIGRDATA(rtskb)->isNotLocalOut) || (pPktHdr->isHitShortcut))
		return rtk_fc_sw_shaper(SHAPING_DESTTYPE_WIFI, &wifiTxPriv, rtskb, pPktHdr, TRUE, TRUE);
	else
		return rtk_fc_sw_shaper(SHAPING_DESTTYPE_WIFI, &wifiTxPriv, rtskb, pPktHdr, FALSE, FALSE);

}

int _rtk_fc_netif_dummy_packet_set(uint32 hwNetifIdx)
{
	/*Set netif dummy packet for pppoe/PPTP/L2TP interface*/
	fc_db.netifDummyPacket[hwNetifIdx].dummyPktInit = 0;
	if(fc_db.netifDummyPacket[hwNetifIdx].dummyPkt != NULL)
	{
		RTK_FC_HELPER_FC_KFREE(fc_db.netifDummyPacket[hwNetifIdx].dummyPkt,sizeof(rtk_fc_igrDummyData_t));
		fc_db.netifDummyPacket[hwNetifIdx].dummyPkt = NULL;
	}

	if(fc_db.netifHwTbl[hwNetifIdx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_ADD)
		fc_db.netifDummyPacket[hwNetifIdx].dummyPkt = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_igrDummyData_t), GFP_ATOMIC);
	else if(fc_db.netifHwTbl[hwNetifIdx].dualType == RTK_FC_DUALTYPE_PPTP)
		fc_db.netifDummyPacket[hwNetifIdx].dummyPkt = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_igrDummyData_t), GFP_ATOMIC);
	else if(fc_db.netifHwTbl[hwNetifIdx].dualType == RTK_FC_DUALTYPE_L2TP)
		fc_db.netifDummyPacket[hwNetifIdx].dummyPkt = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_igrDummyData_t), GFP_ATOMIC);
	return SUCCESS;
}
int _rtk_fc_netif_dummy_packet_clear(uint32 hwNetifIdx)
{
	/*Set netif dummy packet for pppoe interface*/
	fc_db.netifDummyPacket[hwNetifIdx].dummyPktInit = 0;
	if(fc_db.netifDummyPacket[hwNetifIdx].dummyPkt != NULL)
	{
		RTK_FC_HELPER_FC_KFREE(fc_db.netifDummyPacket[hwNetifIdx].dummyPkt,sizeof(rtk_fc_igrDummyData_t));
		fc_db.netifDummyPacket[hwNetifIdx].dummyPkt = NULL;
	}
	return SUCCESS;
}
#if defined(CONFIG_RTK_L34_G3_PLATFORM)

uint32 _rtk_rg_flowHashPreProcessPort(uint16 port, uint32 cf_ptn){

	uint32 shiftdir = (cf_ptn >> 19) & 0x1;
	uint32 shiftbits = (cf_ptn >> 16) & 0x7;
	uint32 xoroperatedvalue = cf_ptn & 0xffff;
	uint32 port_tmp = 0;
	//DEBUG("Hash - preprocess: shift dir: %d, bits %d, xor value = 0x%x", shiftdir, shiftbits, xoroperatedvalue);
	if(shiftdir){	// shift left
		port_tmp = ((port << shiftbits) & 0xffff) | (port >> (16 - shiftbits));
	}else{		// shift right
		port_tmp = ((port << (16 - shiftbits)) & 0xffff) | (port >> shiftbits);
	}
	//DEBUG("Hash - preprocess: 0x%x ^ 0x%x = 0x%x", port_tmp, xoroperatedvalue, (port_tmp ^ xoroperatedvalue));
	return (port_tmp ^ xoroperatedvalue) & 0xffff;	// sport, dport: (16 bits)

}

uint32 _rtk_rg_flowHashPreProcessIP(uint32 ip, uint32 cf_ptn){
	uint32 shiftdir = (cf_ptn >> 23) & 0x1;
	uint32 shiftbits = (cf_ptn >> 20) & 0x7;
	uint32 xoroperatedvalue = cf_ptn & 0xfffff;
	uint32 msb_12bits = ip & 0xfff00000;
	uint32 lsb_20bits = ip & 0x000fffff;
	uint32 ip_tmp = 0;
	ip &= 0xfffff;
	//DEBUG("Hash - preprocess: shift dir: %d, bits %d, xor value = 0x%x", shiftdir, shiftbits, xoroperatedvalue);
	if(shiftdir){	// shift left
		ip_tmp = ((lsb_20bits << shiftbits) & 0xfffff) | (lsb_20bits>> (20 - shiftbits));
	}else{		// shift right
		ip_tmp = ((lsb_20bits << (20 - shiftbits)) & 0xfffff) | (lsb_20bits>> shiftbits);
	}
	//DEBUG("Hash - preprocess: 0x%x | (0x%x ^ 0x%x) = 0x%x", msb_12bits, ip_tmp, xoroperatedvalue, msb_12bits | (ip_tmp ^ xoroperatedvalue));
	return (msb_12bits |( (ip_tmp ^ xoroperatedvalue) & 0xfffff));	// sip, dip: (msb12bits + 20 bits)

}

__IRAM_FC_SHORTCUT
uint32 _rtk_rg_flowHashIPv6DstAddr_get(uint8 ipDes[16])
{
	/* Dst hashidx = {MC_bit, v6hsh[30:0]} */
	uint32 hashIdx = ntohl((*(uint32*)&ipDes[0])) ^ ntohl((*(uint32*)&ipDes[4])) ^ ntohl((*(uint32*)&ipDes[8])) ^ ntohl((*(uint32*)&ipDes[12]));
	hashIdx = (hashIdx >> 31) ^ (hashIdx & 0x7fffffff);
	/* Set MC bit to 1 if ipv6 address is started with ffxx*/
	if(ipDes[0] == 0xff)
		hashIdx |= (1<<31);
	//DEBUG("hashIdx = 0x%x", hashIdx);

	return hashIdx;
}

__IRAM_FC_SHORTCUT
uint32 _rtk_rg_flowHashIPv6SrcAddr_get(uint8 ipSrc[16])
{
	/* Dst hashidx = {MC_bit, v6hsh[30:0]} */
	uint32 hashIdx = ntohl((*(uint32*)&ipSrc[0])) ^ ntohl((*(uint32*)&ipSrc[4])) ^ ntohl((*(uint32*)&ipSrc[8])) ^ ntohl((*(uint32*)&ipSrc[12]));

	//DEBUG("hashIdx = 0x%x", hashIdx);
	return hashIdx;
}
uint32 _rtk_rg_fbMode_get(void)
{
	return FB_MODE_32K;
}

int32 _rtk_fc_g3_l2cls_for_hostPoliceControl_add(int hostPolIdx)
{
#if defined(CONFIG_FC_CAG3_SERIES)
	/*Add L2 CLS for host policing*/
	rtk_fc_aclAndCf_reserved_hostPoliceSaDa_t hostPoliceSaDa_Info;
	memcpy(&(hostPoliceSaDa_Info.hostMac), fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr, sizeof(rtk_mac_t));

	TABLE("Add L2 CLS rule for host MAC: %pM", fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr);
	//SMAC
	hostPoliceSaDa_Info.flow_id = FAIL;
	hostPoliceSaDa_Info.ca_cls_index = FAIL;
	if(fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.ingress_limit_control == ENABLED) //enble ingress rate limit
		hostPoliceSaDa_Info.flow_id = fc_db.hostPoliceTable[hostPolIdx].ingress_limit_meter_hwIndex;
	else if(fc_db.hostPoliceTable[hostPolIdx].loggingRx_policerIdx != FAIL) //disable ingress rate limit but enable logging
		hostPoliceSaDa_Info.flow_id = fc_db.hostPoliceTable[hostPolIdx].loggingRx_policerIdx;
	if(hostPoliceSaDa_Info.flow_id != FAIL) // add l2 CLS for ingress SA
	{
		if(_rtk_rg_aclAndCfReservedRuleAddSpecial(RTK_CA_CLS_TYPE_L2_INGRESS_SA_HOSTPOLICING, &hostPoliceSaDa_Info) != RT_ERR_OK)
		{
			WARNING("Add L2 CLS rule for SMAC(%pM) host policing failed.", fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr);
		}
		else
		{
			fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress = hostPoliceSaDa_Info.ca_cls_index;
			TABLE("Add L2 CLS rule for SMAC(%pM): ca_acl[%d]", fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr, fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress);
		}
	}

	//DMAC
	hostPoliceSaDa_Info.flow_id = FAIL;
	hostPoliceSaDa_Info.ca_cls_index = FAIL;
	if(fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.egress_limit_control == ENABLED) //enble egress rate limit
		hostPoliceSaDa_Info.flow_id = fc_db.hostPoliceTable[hostPolIdx].egress_limit_meter_hwIndex;
	else if(fc_db.hostPoliceTable[hostPolIdx].loggingTx_policerIdx != FAIL) //disable egress rate limit but enable logging
		hostPoliceSaDa_Info.flow_id = fc_db.hostPoliceTable[hostPolIdx].loggingTx_policerIdx;
	if(hostPoliceSaDa_Info.flow_id != FAIL) // add l2 CLS for egress DA
	{
		if(_rtk_rg_aclAndCfReservedRuleAddSpecial(RTK_CA_CLS_TYPE_L2_EGRESS_DA_HOSTPOLICING, &hostPoliceSaDa_Info) != RT_ERR_OK)
		{
			WARNING("Add L2 CLS rule for DMAC(%pM) host policing failed.", fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr);
		}
		else
		{
			fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress = hostPoliceSaDa_Info.ca_cls_index;
			TABLE("Add L2 CLS rule for SMAC(%pM): ca_acl[%d]", fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr, fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress);
		}
	}
#endif
	return RT_ERR_OK;
}

int32 _rtk_fc_g3_l2cls_for_hostPoliceControl_del(int hostPolIdx)
{
#if defined(CONFIG_FC_CAG3_SERIES)
	TABLE("delete L2 CLS rule for MAC: %pM, SA: ca_acl[%d], DA: ca_acl[%d]", fc_db.hostPoliceTable[hostPolIdx].hostPoliceControl.mac_addr, fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress, fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress);
	if(fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress != FAIL)
	{
		if(ca_classifier_rule_delete(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress) != CA_E_OK)
		{
			WARNING("delete ca_acl[%d] failed", fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress);
		}
		fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_ingress = FAIL;
	}
	if(fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress != FAIL)
	{
		if(ca_classifier_rule_delete(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress) != CA_E_OK)
		{
			WARNING("delete ca_acl[%d] failed", fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress);
		}
		fc_db.hostPoliceTable[hostPolIdx].l2ClsIndex.idx_egress = FAIL;
	}
#endif
	return RT_ERR_OK;
}



/*====================
_rtk_fc_g3L3Policer_set(): Set L3 policer.
	copy from dal_ca8279_rate_shareMeter_set().
	_rtk_fc_g3L3Policer_set():		Set L3 policer
	dal_ca8279_rate_shareMeter_set():	Set L2 policer
====================*/
int32 _rtk_fc_g3L3Policer_set(uint32 index, uint32 rate, rtk_enable_t ifgInclude)
{
    /* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(METER_RATE_MAX < rate)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(RTK_ENABLE_END <= ifgInclude)
		return RTK_FC_RET_ERR_INVALID_PARAM;

    if(rate >= METER_RATE_MAX) //Disable policer
    {
		if(rtk_rg_l3_flow_policer_mode_set(index, DISABLED) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
    }
    else
    {
		if(rtk_rg_l3_flow_policer_mode_set(index, ENABLED) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
		if(rtk_rg_l3_flow_policer_rate_set(index, rate, rate) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
    }

	if(rtk_rg_l3_policer_ifg_config_set(ifgInclude) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	return SUCCESS;
}

/*====================
_rtk_fc_g3L3Policer_set(): Get L3 policer. //copy from dal_ca8279_rate_shareMeter_get().
	dal_ca8279_rate_shareMeter_get():	Get L2 policer
====================*/
int32 _rtk_fc_g3L3Policer_get(uint32 index, uint32 *pRate , rtk_enable_t *pIfgInclude)
{
	uint32_t committed_rate, peak_rate;
	bool pol_mode;
	bool if_ifg_include = FALSE;

    /* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(NULL == pRate)
		return RTK_FC_RET_ERR_NULL_POINTER;
	if(NULL == pIfgInclude)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(rtk_rg_l3_flow_policer_mode_get(index, &pol_mode) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	if(pol_mode)
	{
		if(rtk_rg_l3_flow_policer_rate_get(index, &committed_rate, &peak_rate) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;

		*pRate = committed_rate;
	}
	else
	{
		// policer is in disable mode
		*pRate = METER_RATE_MAX;
	}

	if(rtk_rg_l3_policer_ifg_config_get(&if_ifg_include) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	*pIfgInclude = if_ifg_include;

	return SUCCESS;
}

int32 _rtk_fc_g3L3PolicerBurstSize_set(uint32 index, uint32 bucketSize)
{
	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(METER_BURST_MAX < bucketSize)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(rtk_rg_l3_flow_policer_burstSize_set(index, bucketSize, bucketSize) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	return SUCCESS;
}

int32 _rtk_fc_g3L3PolicerBurstSize_get(uint32 index, uint32* pBucketSize)
{
	uint32_t committed_burstSize, peak_burstSize;

	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(NULL == pBucketSize)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(rtk_rg_l3_flow_policer_burstSize_get(index, &committed_burstSize, &peak_burstSize) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	*pBucketSize = committed_burstSize;
	return SUCCESS;
}

#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
/*====================
_rtk_fc_g3L3Policer2_set(): Set L3 policer2.
====================*/
int32 _rtk_fc_g3L3Policer2_set(uint32 index, uint32 rate, rtk_enable_t ifgInclude)
{
	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(METER_RATE_MAX < rate)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(RTK_ENABLE_END <= ifgInclude)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(rate >= METER_RATE_MAX) //Disable policer
	{
		if(rtk_rg_l3_flow_policer2_mode_set(index, DISABLED) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
	}
	else
	{
		if(rtk_rg_l3_flow_policer2_mode_set(index, ENABLED) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
		if(rtk_rg_l3_flow_policer2_rate_set(index, rate, rate) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
	}

	if(rtk_rg_l3_policer_ifg_config_set(ifgInclude) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	return SUCCESS;
}


/*====================
_rtk_fc_g3L3Policer2_set(): Get L3 policer2.
====================*/
int32 _rtk_fc_g3L3Policer2_get(uint32 index, uint32 *pRate , rtk_enable_t *pIfgInclude)
{
	uint32_t committed_rate, peak_rate;
	bool pol_mode;
	bool if_ifg_include = FALSE;

	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(NULL == pRate)
		return RTK_FC_RET_ERR_NULL_POINTER;
	if(NULL == pIfgInclude)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(rtk_rg_l3_flow_policer2_mode_get(index, &pol_mode) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	if(pol_mode)
	{
		if(rtk_rg_l3_flow_policer2_rate_get(index, &committed_rate, &peak_rate) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;

		*pRate = committed_rate;
	}
	else
	{
		// policer is in disable mode
		*pRate = METER_RATE_MAX;
	}

	if(rtk_rg_l3_policer_ifg_config_get(&if_ifg_include) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	*pIfgInclude = if_ifg_include;

	return SUCCESS;
}


int32 _rtk_fc_g3L3Policer2BurstSize_set(uint32 index, uint32 bucketSize)
{
	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(METER_BURST_MAX < bucketSize)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(rtk_rg_l3_flow_policer2_burstSize_set(index, bucketSize, bucketSize) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	return SUCCESS;
}

int32 _rtk_fc_g3L3Policer2BurstSize_get(uint32 index, uint32* pBucketSize)
{
	uint32_t committed_burstSize, peak_burstSize;

	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(NULL == pBucketSize)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(rtk_rg_l3_flow_policer2_burstSize_get(index, &committed_burstSize, &peak_burstSize) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	*pBucketSize = committed_burstSize;
	return SUCCESS;
}

/*====================
_rtk_fc_g3L3Policer3_set(): Set L3 policer3.
====================*/
int32 _rtk_fc_g3L3Policer3_set(uint32 index, uint32 rate, rtk_enable_t ifgInclude)
{
	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(METER_RATE_MAX < rate)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(RTK_ENABLE_END <= ifgInclude)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(rate >= METER_RATE_MAX) //Disable policer
	{
		if(rtk_rg_l3_flow_policer3_mode_set(index, DISABLED) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
	}
	else
	{
		if(rtk_rg_l3_flow_policer3_mode_set(index, ENABLED) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
		if(rtk_rg_l3_flow_policer3_rate_set(index, rate, rate) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;
	}

	if(rtk_rg_l3_policer_ifg_config_set(ifgInclude) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	return SUCCESS;
}


/*====================
_rtk_fc_g3L3Policer3_set(): Get L3 policer3.
====================*/
int32 _rtk_fc_g3L3Policer3_get(uint32 index, uint32 *pRate , rtk_enable_t *pIfgInclude)
{
	uint32_t committed_rate, peak_rate;
	bool pol_mode;
	bool if_ifg_include = FALSE;

	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(NULL == pRate)
		return RTK_FC_RET_ERR_NULL_POINTER;
	if(NULL == pIfgInclude)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(rtk_rg_l3_flow_policer3_mode_get(index, &pol_mode) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	if(pol_mode)
	{
		if(rtk_rg_l3_flow_policer3_rate_get(index, &committed_rate, &peak_rate) != ASIC_RET_SUCCESS)
			return RTK_FC_RET_ERR;

		*pRate = committed_rate;
	}
	else
	{
		// policer is in disable mode
		*pRate = METER_RATE_MAX;
	}

	if(rtk_rg_l3_policer_ifg_config_get(&if_ifg_include) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	*pIfgInclude = if_ifg_include;

	return SUCCESS;
}


int32 _rtk_fc_g3L3Policer3BurstSize_set(uint32 index, uint32 bucketSize)
{
	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(METER_BURST_MAX < bucketSize)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if(rtk_rg_l3_flow_policer3_burstSize_set(index, bucketSize, bucketSize) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	return SUCCESS;
}


int32 _rtk_fc_g3L3Policer3BurstSize_get(uint32 index, uint32* pBucketSize)
{
	uint32_t committed_burstSize, peak_burstSize;

	/* parameter check */
	if(G3_L3_FLOW_POLICER_SIZE <= index)
		return RTK_FC_RET_ERR_INVALID_PARAM;
	if(NULL == pBucketSize)
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(rtk_rg_l3_flow_policer3_burstSize_get(index, &committed_burstSize, &peak_burstSize) != ASIC_RET_SUCCESS)
		return RTK_FC_RET_ERR;

	*pBucketSize = committed_burstSize;
	return SUCCESS;
}

/*====================
_rtk_fc_g3PolRemap_sync(): Get pol id sync to pol_2(77B)/pol_3(77C) for ACL.
====================*/
int32 _rtk_fc_g3PolRemap_sync(int hw_index)
{
	int polRemapIdx, polIdx, ret;
	uint32 rate;
	rtk_enable_t ifgIncludeTmp;
	uint32 bucketSize;

	for(polRemapIdx = 0; polRemapIdx < RTK_FC_TABLESIZE_POLREMAP; polRemapIdx++)
	{
		if(!fc_db.hwPolRemap[polRemapIdx].valid)
			continue;
		polIdx = fc_db.hwPolRemap[polRemapIdx].pol_id;

		if((hw_index != -1 /*-1 means update all*/) && (polIdx != hw_index))
			continue;

		//update rate
		if((ret = _rtk_fc_g3L3Policer_get(polIdx, &rate, &ifgIncludeTmp)) != SUCCESS)
			return ret;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if((ret = _rtk_fc_g3L3Policer3_set(polRemapIdx, rate, ifgIncludeTmp)) != SUCCESS)
			return ret;
#else
		if((ret = _rtk_fc_g3L3Policer2_set(polRemapIdx, rate, ifgIncludeTmp)) != SUCCESS)
			return ret;
#endif

		//update burst size
		if((ret = _rtk_fc_g3L3PolicerBurstSize_get(polIdx, &bucketSize)) != SUCCESS)
			return ret;
#if defined(CONFIG_FC_RTL8277C_SERIES)
		if((ret = _rtk_fc_g3L3Policer3BurstSize_set(polRemapIdx, bucketSize)) != SUCCESS)
			return ret;
#else
		if((ret = _rtk_fc_g3L3Policer2BurstSize_set(polRemapIdx, bucketSize)) != SUCCESS)
			return ret;
#endif
	}

	return SUCCESS;
}

int32 _rtk_fc_dmaAftAction_add(uint32* index, rtk_rg_asic_dmaAftFib_t fib, uint8 is_rsv)
{
	int i, entry_start, entry_stop;
	int first_invald_index = RTK_FC_TABLESIZE_DMAAFTACTION;
	
	
	*index = RTK_FC_TABLESIZE_DMAAFTACTION;

#if defined(CONFIG_FC_RTL8277C_SERIES)
	//always reserve entry 0 for NOP, entry 1~15 for tx api with hp!=11
	if(is_rsv){
		entry_start = 1;
		entry_stop = RTK_FC_TABLESIZE_DMAAFTACTION_RSV;

	}else{
		entry_start = RTK_FC_TABLESIZE_DMAAFTACTION_RSV;
		entry_stop = RTK_FC_TABLESIZE_DMAAFTACTION;
	}
#else
	entry_start = 0;
	entry_stop = RTK_FC_TABLESIZE_DMAAFTACTION;
#endif

	//find duplicated entry
	for(i = entry_start ; i < entry_stop ; i++)
	{
		unsigned long timeout = fc_db.dmaAftActionTbl[i].last_jiffies_when_deleted +1*CONFIG_HZ;  // entry will be valid after 1 second 

		if(fc_db.dmaAftActionTbl[i].refCount != 0)
		{
			if(memcmp(&(fc_db.dmaAftActionTbl[i].fib), &fib, sizeof(fc_db.dmaAftActionTbl[i].fib)) == 0)
			{
				TRACE("Find duplicated dmaAftAction index: %d", i);
#if defined(CONFIG_FC_RTL8277C_SERIES)
				if(is_rsv)	//each SC will come here, so reference is useless
					fc_db.dmaAftActionTbl[i].refCount = 1;
				else
#endif
				fc_db.dmaAftActionTbl[i].refCount++;
				*index = i;
				return RTK_FC_RET_OK;
			}
		}
		else
		{
			//refcount == 0
			if(time_after_eq(jiffies, timeout)  // refcount = 0 and time should be after 1 sec
				&& first_invald_index == RTK_FC_TABLESIZE_DMAAFTACTION
			)
			{
				TRACE("Find dmaAftAction first invalid index: %d", i);
				first_invald_index = i;
			}
		}
	}

	//first invalid entry
	if(first_invald_index != RTK_FC_TABLESIZE_DMAAFTACTION)
	{
		//find first invalid entry and set to HW successfully
		if(rtk_rg_asic_dmaAftFib_set(first_invald_index, fib) == 0)
		{
#if defined(CONFIG_FC_RTL8277C_SERIES)
			if(is_rsv)
				fc_db.dmaAftActionTbl[first_invald_index].refCount = 1;
			else
#endif
			fc_db.dmaAftActionTbl[first_invald_index].refCount++;
			*index = first_invald_index;
			memcpy(&(fc_db.dmaAftActionTbl[first_invald_index].fib), &fib, sizeof(fc_db.dmaAftActionTbl[first_invald_index].fib));
		}
	}
	else
		return RTK_FC_RET_ERR_ENTRY_FULL;

	return RTK_FC_RET_OK;
}

int32 _rtk_fc_dmaAftAction_del(uint32 index)
{
	fc_db.dmaAftActionTbl[index].refCount--;

	if(!fc_db.dmaAftActionTbl[index].refCount)
	{
		//Record the jiffies when refCount = 0
		fc_db.dmaAftActionTbl[index].last_jiffies_when_deleted = jiffies;
	}

#if defined(CONFIG_FC_RTL8277C_SERIES)
	if(fc_db.dmaAftActionTbl[index].syncRsvEntry)
	{
		int i;
		for(i = 0 ; i < RTK_FC_TABLESIZE_DMAAFTACTION ; i++)
		{
			if(i == index)
				continue;
			if((fc_db.dmaAftActionTbl[i].syncRsvEntry) && (fc_db.dmaAftActionTbl[i].syncRsvEntryIdx == fc_db.dmaAftActionTbl[index].syncRsvEntryIdx))
				break;
		}
		if(i == RTK_FC_TABLESIZE_DMAAFTACTION){	//remove this rsv entry only when no one reference
			_rtk_fc_dmaAftAction_del(fc_db.dmaAftActionTbl[index].syncRsvEntryIdx);
			fc_db.dmaAftActionTbl[index].syncRsvEntry = 0;
			fc_db.dmaAftActionTbl[index].syncRsvEntryIdx = 0;
		}
	}
#endif

	return RTK_FC_RET_OK;
}

int32 _rtk_fc_flow_dmaAftAction_update(rtk_rg_asic_path3_entry_t *pFlow, uint32 flowIdx, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo)
{
	rtk_rg_asic_dmaAftFib_t fib;
	uint32 fibIdx;
	bool if_dmaAftFibCtrlEn = FALSE;
	memset(&fib, 0, sizeof(fib));
	
	/*check vlan action (push and pop only, swap can be easily achieve by SW)*/
	if(((pFlow->in_stagif == 0) && (pFlow->out_svid_format_act == 1))  /*stag push*/ ||
		((pFlow->in_stagif == 1) && (pFlow->out_svid_format_act == 0)) /*stag pop*/ ||
		((pFlow->in_ctagif == 0) && (pFlow->out_cvid_format_act == 1)) /*ctag push*/ ||
		((pFlow->in_ctagif == 1) && (pFlow->out_cvid_format_act == 0)) /*ctag pop*/)
	{
		fib.vlan_vld = 1;

		if(pFlow->out_svid_format_act && pFlow->out_cvid_format_act)
		{
			//egress: stag + ctag
			fib.vlan_cnt = 2;
			fib.top_tpid_enc = pG3IgrExtraInfo->egr_svlan_tpid_sel? 3 : 2; // TPID_2: fc_db.systemGlobal.stagTPID[1], TPID_1: fc_db.systemGlobal.stagTPID[0]
			fib.top_tpid_sel = 3; // fib
			fib.top_vid = pFlow->out_svlan_id;
			fib.top_802_1p = pFlow->out_spri;
			fib.top_1p_sel = 3; // fib
			fib.top_dei = pG3IgrExtraInfo->egr_svlan_dei;
			fib.top_dei_sel = 3; //fib

			fib.inner_tpid_enc = 1; // TPID_0: 0x8100
			fib.inner_tpid_sel = 3; // fib
			fib.inner_vid = pFlow->out_cvlan_id;
			fib.inner_802_1p = pFlow->out_cpri;
			fib.inner_1p_sel = 3; // fib
			fib.inner_dei = pG3IgrExtraInfo->egr_cvlan_cfi;
			fib.inner_dei_sel = 3; //fib
		}
		else if(pFlow->out_svid_format_act)
		{
			//egress:  stag
			fib.vlan_cnt = 1;
			fib.top_tpid_enc = pG3IgrExtraInfo->egr_svlan_tpid_sel? 3 : 2; // TPID_2: fc_db.systemGlobal.stagTPID[1], TPID_1: fc_db.systemGlobal.stagTPID[0]
			fib.top_tpid_sel = 3; // fib
			fib.top_vid = pFlow->out_svlan_id;
			fib.top_802_1p = pFlow->out_spri;
			fib.top_1p_sel = 3; // fib
			fib.top_dei = pG3IgrExtraInfo->egr_svlan_dei;
			fib.top_dei_sel = 3; //fib
		}
		else if(pFlow->out_cvid_format_act)
		{
			//egress:  ctag
			fib.vlan_cnt = 1;
			fib.top_tpid_enc = 1; // TPID_0: 0x8100
			fib.top_tpid_sel = 3; // fib
			fib.top_vid = pFlow->out_cvlan_id;
			fib.top_802_1p = pFlow->out_cpri;
			fib.top_1p_sel = 3; // fib
			fib.top_dei = pG3IgrExtraInfo->egr_cvlan_cfi;
			fib.top_dei_sel = 3; //fib
		}
		else
		{
			//egress: untag
		}
		if_dmaAftFibCtrlEn = TRUE;
		
	}

	/*check pppoe action*/
	if((pFlow->in_path == FB_PATH_5) || ((pFlow->in_path == FB_PATH_12 || (pFlow->in_path == FB_PATH_34)) && pFlow->out_smac_trans))
	{
		if((pFlow->in_pppoeif == 0) &&
			((fc_db.netifHwTbl[pFlow->out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_ADD) || (fc_db.netifHwTbl[pFlow->out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_MODIFY)))
		{
			fib.pppoe_cmd = 1; // push
			fib.session_id = fc_db.netifHwTbl[pFlow->out_intf_idx].intf.out_pppoe_sid;
			if_dmaAftFibCtrlEn = TRUE;
		}
		else if((pFlow->in_pppoeif == 1) && (fc_db.netifHwTbl[pFlow->out_intf_idx].intf.out_pppoe_act==FB_NETIFPPPOE_ACT_REMOVE))
		{
			fib.pppoe_cmd = 2; //pop
			if_dmaAftFibCtrlEn = TRUE;
		}
	}
	if(if_dmaAftFibCtrlEn)
	{
		_rtk_fc_dmaAftAction_add(&fibIdx, fib, FALSE);
		if(fibIdx < RTK_FC_TABLESIZE_DMAAFTACTION)
		{
			fc_db.flowTbl[flowIdx].dmaAftFibCtrlEn = if_dmaAftFibCtrlEn;
			fc_db.flowTbl[flowIdx].dmaAftFibIdx = fibIdx;
		}
	}
	return RTK_FC_RET_OK;
}
#endif


void _rtk_fc_g3FlowIdDecision(rtk_rg_asic_path1_entry_t *flow, rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo, bool *flowIdActMask, uint16 *flowId)
{
#if defined(CONFIG_FC_CAG3_SERIES)
	rtk_rg_asic_path5_entry_t *pFlowPath3 = (rtk_rg_asic_path5_entry_t *)flow;
#endif

	/***
	8277:
	flow ID decision for policer1:
		flow meter > flow mib > host policing rx rate limit > host policing tx rate limit  > host policing rx counting > host policing tx counting
	8277B for policer3:
		host policing rx counting > host policing tx counting
	****/

#if defined(CONFIG_FC_CAG3_SERIES)
	if(pFlowPath3->out_share_meter_act)
	{
		bool flowIdMaskTmp;
		uint16 flowIdTmp;
		if(fc_db.controlFuc.rt_api_is_enabled){

			int32 ret;
			rt_rate_meter_mapping_t meterMapping;
			//ret = rt_rate_shareMeterMappingHw_get(pFlowPath3->out_share_meter_idx, &meterMapping);
			ret = RTK_FC_HELPER_RT_RATE_SHAREMETER_MAPPING_HW_GET(pFlowPath3->out_share_meter_idx, &meterMapping);
			if((ret == 0) && (meterMapping.type == RT_METER_TYPE_FLOW))
			{
				flowIdMaskTmp = pFlowPath3->out_share_meter_act;
				flowIdTmp = meterMapping.hw_index + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR;
			}
			else
			{
				WARNING("flow id decision Failed, return value: %d, virtual meter type: %d", ret, meterMapping.type);
				flowIdMaskTmp = 0;
				flowIdTmp = 0;
			}
		}else{
			flowIdMaskTmp = pFlowPath3->out_share_meter_act;
			flowIdTmp = pFlowPath3->out_share_meter_idx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR;
		}

		TRACE("flow id decision: flow meter [%d] (policer id: %d).", pFlowPath3->out_share_meter_idx, flowIdTmp);
		*flowIdActMask = flowIdMaskTmp;
		*flowId = flowIdTmp;
		return;
	}
	if(pFlowPath3->out_flow_counter_act)
	{
		TRACE("flow id decision: flow mib [%d] (policer id: %d).", pFlowPath3->out_flow_counter_idx, pFlowPath3->out_flow_counter_idx + G3_FLOW_POLICER_IDXSHIFT_FLOWMIB);
		*flowIdActMask = pFlowPath3->out_flow_counter_act;
		*flowId = pFlowPath3->out_flow_counter_idx + G3_FLOW_POLICER_IDXSHIFT_FLOWMIB;
		return;
	}
#endif

	if(fc_db.controlFuc.loopbackMode_is_enabled == FALSE)
	{
		if((pG3IgrExtraInfo->ingressSaHostPolIdx != FAIL) && fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.ingress_limit_control)
		{
#if defined(CONFIG_FC_CA8277B_SERIES)
			WARNING("not support hw host rate policing");
#else
			TRACE("flow id decision: hostPolicing[%d] (MAC: %pM) ingress rate limit (meter: %d, policer id: %d).", pG3IgrExtraInfo->ingressSaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.mac_addr, fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.ingress_limit_meter_index, fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].ingress_limit_meter_hwIndex);
			*flowIdActMask = fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.ingress_limit_control;
			*flowId = fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].ingress_limit_meter_hwIndex;

			//if mib_count_control is enable, chek if flow id is consistent
			if(fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.mib_count_control && (*flowId != fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].loggingRx_policerIdx))
				WARNING("Please check! decided flow ID is %d, but hostPolicing[%d]'s loggingRx_policerIdx is %d", *flowId, pG3IgrExtraInfo->ingressSaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].loggingRx_policerIdx);
#endif
			return;
		}

		if((pG3IgrExtraInfo->egressDaHostPolIdx != FAIL) && fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.egress_limit_control)
		{
#if defined(CONFIG_FC_CA8277B_SERIES)
			WARNING("not support hw host rate policing");
#else
			TRACE("flow id decision: hostPolicing[%d] (MAC: %pM) egress rate limit (meter: %d, policer id: %d).", pG3IgrExtraInfo->egressDaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.mac_addr, fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.egress_limit_meter_index, fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].egress_limit_meter_hwIndex );
			*flowIdActMask = fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.egress_limit_control;
			*flowId = fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].egress_limit_meter_hwIndex;

			//if mib_count_control is enable, chek if flow id is consistent
			if(fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.mib_count_control && (*flowId != fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].loggingTx_policerIdx))
				WARNING("Please check! decided flow ID is %d, but hostPolicing[%d]'s loggingTx_policerIdx is %d", *flowId, pG3IgrExtraInfo->egressDaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].loggingTx_policerIdx);
#endif
			return;
		}

		if((pG3IgrExtraInfo->ingressSaHostPolIdx != FAIL) && fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.mib_count_control)
		{
			TRACE("flow id decision: hostPolicing[%d] (MAC: %pM) ingress mib (policer id: %d).", pG3IgrExtraInfo->ingressSaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.mac_addr, pG3IgrExtraInfo->ingressSaHostPolIdx + G3_FLOW_POLICER_IDXSHIFT_HPLOGRX);
			*flowIdActMask = fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].hostPoliceControl.mib_count_control;
			*flowId = pG3IgrExtraInfo->ingressSaHostPolIdx + G3_FLOW_POLICER_IDXSHIFT_HPLOGRX;

			//chek if flow id is consistent
			if(*flowId != fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].loggingRx_policerIdx)
				WARNING("Please check! decided flow ID is %d, but hostPolicing[%d]'s loggingRx_policerIdx is %d", *flowId, pG3IgrExtraInfo->ingressSaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->ingressSaHostPolIdx].loggingRx_policerIdx);

			return;
		}

		if((pG3IgrExtraInfo->egressDaHostPolIdx != FAIL) && fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.mib_count_control)
		{
			TRACE("flow id decision: hostPolicing[%d] (MAC: %pM) egress mib (policer id: %d).", pG3IgrExtraInfo->egressDaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.mac_addr, pG3IgrExtraInfo->egressDaHostPolIdx + G3_FLOW_POLICER_IDXSHIFT_HPLOGTX);
			*flowIdActMask = fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].hostPoliceControl.mib_count_control;
			*flowId = pG3IgrExtraInfo->egressDaHostPolIdx + G3_FLOW_POLICER_IDXSHIFT_HPLOGTX;

			//chek if flow id is consistent
			if(*flowId != fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].loggingTx_policerIdx)
				WARNING("Please check! decided flow ID is %d, but hostPolicing[%d]'s loggingTx_policerIdx is %d", *flowId, pG3IgrExtraInfo->egressDaHostPolIdx, fc_db.hostPoliceTable[pG3IgrExtraInfo->egressDaHostPolIdx].loggingTx_policerIdx);

			return;
		}
	}

	TRACE("flow id decision: none.");
	return;
}


#endif // CONFIG_RTK_L34_G3_PLATFORM

void _rtk_fc_g3IgrExtraInfo_init(rtk_fc_g3IgrExtraInfo_t *pG3IgrExtraInfo)
{
	bzero(pG3IgrExtraInfo, sizeof(rtk_fc_g3IgrExtraInfo_t));
	pG3IgrExtraInfo->ingressSaHostPolIdx = FAIL;
	pG3IgrExtraInfo->egressDaHostPolIdx = FAIL;
}

int32 _rtk_fc_checkPortNotExistByPhy(rtk_fc_mac_port_idx_t port)
{
	return ((0x1LL<<port)&fc_db.systemGlobal.phyPortStatus)?0:1;
}

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
int _rtk_fc_wifi_flow_ctrl_onOff_set(bool wifi_flow_ctrl_onOff_state)
{
	rtk_port_macAbility_t cpu0Ability;
	rtk_port_macAbility_t cpu1Ability;
	ASSERT_EQ(RTK_PORT_MACFORCEABILITY_GET(RTK_FC_MAC_PORT_MASTERCPU_CORE0, &cpu0Ability),RT_ERR_OK);
	ASSERT_EQ(RTK_PORT_MACFORCEABILITY_GET(RTK_FC_MAC_PORT_MASTERCPU_CORE1, &cpu1Ability),RT_ERR_OK);
	if(wifi_flow_ctrl_onOff_state == DISABLED)
	{
		if(cpu0Ability.txFc == ENABLED || cpu0Ability.rxFc == ENABLED)
		{
			cpu0Ability.txFc = DISABLED;
			cpu0Ability.rxFc = DISABLED;
		}

		if(cpu1Ability.txFc == ENABLED || cpu1Ability.rxFc == ENABLED)
		{
			cpu1Ability.txFc = DISABLED;
			cpu1Ability.rxFc = DISABLED;
		}
	}
	else
	{
		if(cpu0Ability.txFc == DISABLED || cpu0Ability.rxFc == DISABLED)
		{
			cpu0Ability.txFc = ENABLED;
			cpu0Ability.rxFc = ENABLED;
		}

		if(cpu1Ability.txFc == DISABLED || cpu1Ability.rxFc == DISABLED)
		{
			cpu1Ability.txFc = ENABLED;
			cpu1Ability.rxFc = ENABLED;
		}

	}
	ASSERT_EQ(RTK_PORT_MACFORCEABILITY_SET(RTK_FC_MAC_PORT_MASTERCPU_CORE0, cpu0Ability), RT_ERR_OK);
	ASSERT_EQ(RTK_PORT_MACFORCEABILITYSTATE_SET(RTK_FC_MAC_PORT_MASTERCPU_CORE0, ENABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_PORT_MACFORCEABILITY_SET(RTK_FC_MAC_PORT_MASTERCPU_CORE1, cpu1Ability), RT_ERR_OK);
	ASSERT_EQ(RTK_PORT_MACFORCEABILITYSTATE_SET(RTK_FC_MAC_PORT_MASTERCPU_CORE1, ENABLED), RT_ERR_OK);
	return (RTK_FC_RET_OK);
}

void _rtk_fc_wifi_flow_ctrl_detect_timerFunc(unsigned int task_priv)
{
	rtk_fc_wifi_flow_crtl_info_t wifi_flow_crtl_info;
	uint32 wlan0_ingressRate;
	uint32 wlan1_ingressRate;

	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	
	RTK_FC_HELPER_MGR_WIFI_FLOW_CRTL_INFO_GET(&wifi_flow_crtl_info);

	wlan0_ingressRate = (wifi_flow_crtl_info.wlan0_accumulate_bit*10/RTK_FC_DEFAULT_WIFI_FLOW_CTRL_DETECT_INTERVAL/1000000);/*mbps*/
	wlan1_ingressRate = (wifi_flow_crtl_info.wlan1_accumulate_bit*10/RTK_FC_DEFAULT_WIFI_FLOW_CTRL_DETECT_INTERVAL/1000000);/*mbps*/

	if(!wifi_flow_crtl_info.wifi_flow_ctrl_auto_en)
		WARNING("fc_db.controlFuc.wifi_flow_crtl_func.wifi_flow_ctrl_auto_en is DISABLED but enter _rtk_rg_wifi_flow_ctrl_detect_timerFunc()");
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
	if((wlan0_ingressRate >= fc_db.controlFuc.wifi_flow_crtl_threshold.wlan0_flow_ctrl_on_threshold_mbps) && (wlan1_ingressRate >= fc_db.controlFuc.wifi_flow_crtl_threshold.wlan1_flow_ctrl_on_threshold_mbps))
	{
		//packets from both wlan0 and wlan1 are more than their ON threshold during the time interval, turn on CPU port flow control
		DEBUG("packets from both wlan0 and wlan1 are more than their ON threshold, turn on CPU port %d and %d flow control", RTK_FC_MAC_PORT_MASTERCPU_CORE0, RTK_FC_MAC_PORT_MASTERCPU_CORE1);
		_rtk_fc_wifi_flow_ctrl_onOff_set(ENABLED); //turn on CPU port flow control
	}

	if((wlan0_ingressRate <= fc_db.controlFuc.wifi_flow_crtl_threshold.wlan0_flow_ctrl_off_threshold_mbps) && (wlan1_ingressRate <= fc_db.controlFuc.wifi_flow_crtl_threshold.wlan1_flow_ctrl_off_threshold_mbps))
	{
		//packets from both wlan0 and wlan1 are less than their OFF threshold during the time interval, turn off CPU port flow control
		DEBUG("packets from both wlan0 and wlan1 are more than their OFF threshold, turn off CPU port %d and %d flow control", RTK_FC_MAC_PORT_MASTERCPU_CORE0, RTK_FC_MAC_PORT_MASTERCPU_CORE1);
		_rtk_fc_wifi_flow_ctrl_onOff_set(DISABLED); //turn off CPU port flow control
	}

	//clear wlan0/wlan1 accumulated bit count
	RTK_FC_HELPER_MGR_WIFI_FLOW_CRTL_INFO_CLEAR();
	RTK_FC_HELPER_MOD_TIMER(fc_db.controlFuc.wifi_flow_ctrl_detect_timer, jiffies+((RTK_FC_DEFAULT_WIFI_FLOW_CTRL_DETECT_INTERVAL*CONFIG_HZ)/10/*unit:(1/10)sec*/));
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
}
int rtk_fc_wifi_flow_ctrl_onOff_check(void)
{
	rtk_fc_wifi_flow_crtl_info_t wifi_flow_crtl_info;	
	RTK_FC_HELPER_MGR_WIFI_FLOW_CRTL_INFO_GET(&wifi_flow_crtl_info);
	
	if(fc_db.controlFuc.wifi_flow_crtl_threshold.wlan0_flow_ctrl_off_threshold_mbps && fc_db.controlFuc.wifi_flow_crtl_threshold.wlan1_flow_ctrl_off_threshold_mbps)
	{
		if(!wifi_flow_crtl_info.wifi_flow_ctrl_auto_en)//disable => enable
		{
			DEBUG("Enable wifi flow contrl");

			if(RTK_FC_HELPER_TIMER_PENDING(fc_db.controlFuc.wifi_flow_ctrl_detect_timer))
				RTK_FC_HELPER_DEL_TIMER(fc_db.controlFuc.wifi_flow_ctrl_detect_timer);

			RTK_FC_HELPER_INIT_TIMER(fc_db.controlFuc.wifi_flow_ctrl_detect_timer, _rtk_fc_wifi_flow_ctrl_detect_timerFunc);
			RTK_FC_HELPER_SETUP_TIMER(fc_db.controlFuc.wifi_flow_ctrl_detect_timer, _rtk_fc_wifi_flow_ctrl_detect_timerFunc, (unsigned long)NULL);
			RTK_FC_HELPER_MOD_TIMER(fc_db.controlFuc.wifi_flow_ctrl_detect_timer, jiffies+((RTK_FC_DEFAULT_WIFI_FLOW_CTRL_DETECT_INTERVAL*CONFIG_HZ)/10/*unit:(1/10)sec*/));
		}
		RTK_FC_HELPER_MGR_WIFI_FLOW_CRTL_INFO_SET(ENABLED);
	}
	else
	{
		if(wifi_flow_crtl_info.wifi_flow_ctrl_auto_en)//enable => disable
		{
			DEBUG("Disable wifi flow contrl");
			if(RTK_FC_HELPER_TIMER_PENDING(fc_db.controlFuc.wifi_flow_ctrl_detect_timer))
				RTK_FC_HELPER_DEL_TIMER(fc_db.controlFuc.wifi_flow_ctrl_detect_timer);
			_rtk_fc_wifi_flow_ctrl_onOff_set(DISABLED); //turn off CPU port flow control
		}
		RTK_FC_HELPER_MGR_WIFI_FLOW_CRTL_INFO_SET(DISABLED);
	}

	return (RTK_FC_RET_OK);
}
#endif

__IRAM_FC_SHORTCUT
rtk_fc_ret_t rtk_fc_dualHdrInfo_set(rtk_rg_asic_dualHdrInfo_t target, uint8 intfIdx, uint32 value)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	return rtk_rg_asic_dualHdrInfo_set(target, intfIdx, value);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM) // G3 need to suppout SW GRE SEQ/ACK IPV4ID table
	FC_PARAM_CHK((intfIdx<0)||(intfIdx >= RTK_FC_TABLESIZE_INTF_SW), RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);
	switch(target)
	{
		case RTK_FC_FB_DUALHDR_GRESEQ:
#if defined(CONFIG_FC_RTL8277C_SERIES)
			aal_l3pe_gre_seq_set(RTK_FC_DUAL_CONTROL_IDX(intfIdx), value);
#else
			fc_db.greIpidInfo[intfIdx].greSeq = value;
#endif
			break;
		case RTK_FC_FB_DUALHDR_GREACK:
#if defined(CONFIG_FC_RTL8277C_SERIES)
			aal_l3pe_gre_ack_set(RTK_FC_DUAL_CONTROL_IDX(intfIdx), value);
#else
			fc_db.greIpidInfo[intfIdx].greAck = value;
#endif
			break;
		case RTK_FC_FB_DUALHDR_OUTER_IPV4ID:
#if defined(CONFIG_FC_RTL8277C_SERIES)
			aal_l3pe_ipv4_id_set(RTK_FC_DUAL_CONTROL_IDX(intfIdx), value);
#else
			fc_db.greIpidInfo[intfIdx].fbIpId = value;
#endif
			break;
		default:
			WARNING("target %d is not supported", target);
			return RTK_FC_RET_ERR_INVALID_PARAM;
			break;
	}
	return RTK_FC_RET_OK;
#endif
}

rtk_fc_ret_t rtk_fc_dualHdrInfo_get(rtk_rg_asic_dualHdrInfo_t target, uint8 intfIdx, uint32 *value)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	return rtk_rg_asic_dualHdrInfo_get(target, intfIdx, value);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM) // G3 need to suppout SW GRE SEQ/ACK IPV4ID table
	FC_PARAM_CHK((intfIdx<0)||(intfIdx >= RTK_FC_TABLESIZE_INTF_SW), RTK_FC_RET_ERR_INDEX_OUT_OF_RANGE);
	FC_PARAM_CHK((NULL == value), RTK_FC_RET_ERR_NULL_POINTER);

	switch(target)
	{
		case RTK_FC_FB_DUALHDR_GRESEQ:
#if defined(CONFIG_FC_RTL8277C_SERIES)
			aal_l3pe_gre_seq_get(RTK_FC_DUAL_CONTROL_IDX(intfIdx), value);
#else
			*value = fc_db.greIpidInfo[intfIdx].greSeq++; //SEQ increase 1 after read
#endif
			break;
		case RTK_FC_FB_DUALHDR_GREACK:
#if defined(CONFIG_FC_RTL8277C_SERIES)
			aal_l3pe_gre_ack_get(RTK_FC_DUAL_CONTROL_IDX(intfIdx), value);
#else
			*value = fc_db.greIpidInfo[intfIdx].greAck;
#endif
			break;
		case RTK_FC_FB_DUALHDR_OUTER_IPV4ID:
#if defined(CONFIG_FC_RTL8277C_SERIES)
			aal_l3pe_ipv4_id_get(RTK_FC_DUAL_CONTROL_IDX(intfIdx), (unsigned short *)value);
#else
			*value = fc_db.greIpidInfo[intfIdx].fbIpId++; //IPID increase 1 after read
#endif
			break;
		default:
			WARNING("target %d is not supported", target);
			return RTK_FC_RET_ERR_INVALID_PARAM;
			break;
	}
	return RTK_FC_RET_OK;
#endif
}
int32 _rtk_fc_hwFlowMib_get(uint32 flowMibIdx, rtk_fc_flowOrHostmib_counter_t *counter)
{
	if(counter == NULL)
		return RTK_FC_RET_ERR_NULL_POINTER;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	{
		rtk_rg_asic_flowMib_entry_t flowMIB;
		ASSERT_EQ(rtk_rg_asic_flowMib_get(flowMibIdx, &flowMIB), SUCCESS); 	// hw only

		counter->in_packet_cnt = flowMIB.in_packet_cnt;
		counter->in_byte_cnt = flowMIB.in_byte_cnt;
		counter->out_byte_cnt = flowMIB.out_byte_cnt;
		counter->out_packet_cnt = flowMIB.out_packet_cnt;
	}
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	{
		aal_l3_te_pm_policer_t l3_pm_data;

#if defined(CONFIG_FC_CA8277B_SERIES)
		//flow meter: use policer2, support flow_meter_mib_conf_dependence is 1 only
		if(fc_db.controlFuc.flow_meter_mib_conf_dependence)
			ASSERT_EQ(aal_l3_te_pm_policer_agr_flow_get(G3_DEF_DEVID, flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR, &l3_pm_data), CA_E_OK);
		else
			memset(&l3_pm_data, 0, sizeof(l3_pm_data));
#elif defined(CONFIG_FC_RTL8277C_SERIES)
		if(fc_db.controlFuc.flow_meter_mib_conf_dependence)
			ASSERT_EQ(aal_l3_te_pm_policer_agr_flow_get(G3_DEF_DEVID, flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR, &l3_pm_data), CA_E_OK);
		else
			ASSERT_EQ(aal_l3_te_pm_policer_flow3_get(G3_DEF_DEVID, flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMIB, &l3_pm_data), CA_E_OK);
#else
		if(fc_db.controlFuc.flow_meter_mib_conf_dependence)
			ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, (flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR), &l3_pm_data), CA_E_OK);
		else
			ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, (flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMIB), &l3_pm_data), CA_E_OK);
#endif
		//read clear, store into SW
		fc_db.flowHWMib[flowMibIdx].in_packet_cnt += l3_pm_data.total_pkt;
		fc_db.flowHWMib[flowMibIdx].out_packet_cnt += l3_pm_data.total_pkt - l3_pm_data.red_pkt;
		fc_db.flowHWMib[flowMibIdx].in_byte_cnt += l3_pm_data.total_bytes;
		fc_db.flowHWMib[flowMibIdx].out_byte_cnt += l3_pm_data.total_bytes - l3_pm_data.red_bytes;

		counter->in_packet_cnt = fc_db.flowHWMib[flowMibIdx].in_packet_cnt;
		counter->in_byte_cnt = fc_db.flowHWMib[flowMibIdx].in_byte_cnt;
		counter->out_packet_cnt = fc_db.flowHWMib[flowMibIdx].out_packet_cnt;
		counter->out_byte_cnt = fc_db.flowHWMib[flowMibIdx].out_byte_cnt;
	}
#endif
	return SUCCESS;
}

int32 _rtk_fc_hwFlowMib_clear(uint32 flowMibIdx)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	ASSERT_EQ(rtk_rg_asic_flowMib_reset(flowMibIdx), SUCCESS);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	aal_l3_te_pm_policer_t l3_pm_data;

#if defined(CONFIG_FC_CA8277B_SERIES)
	//flow meter: use policer2, support flow_meter_mib_conf_dependence is 1 only
	if(fc_db.controlFuc.flow_meter_mib_conf_dependence)
		ASSERT_EQ(aal_l3_te_pm_policer_agr_flow_get(G3_DEF_DEVID, flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR, &l3_pm_data), CA_E_OK);
#elif defined(CONFIG_FC_RTL8277C_SERIES)
	if(fc_db.controlFuc.flow_meter_mib_conf_dependence)
		ASSERT_EQ(aal_l3_te_pm_policer_agr_flow_get(G3_DEF_DEVID, flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR, &l3_pm_data), CA_E_OK);
	else
		ASSERT_EQ(aal_l3_te_pm_policer_flow3_get(G3_DEF_DEVID, flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMIB, &l3_pm_data), CA_E_OK);
#else
	if(fc_db.controlFuc.flow_meter_mib_conf_dependence)
		ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, (flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMTR), &l3_pm_data), CA_E_OK); //read clear
	else
		ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, (flowMibIdx + G3_FLOW_POLICER_IDXSHIFT_FLOWMIB), &l3_pm_data), CA_E_OK); //read clear
#endif
	memset(&fc_db.flowHWMib[flowMibIdx], 0 , sizeof(fc_db.flowHWMib[flowMibIdx]));
#endif
	return SUCCESS;
}

int32 _rtk_fc_hwHostPolingMib_get(uint32 hostPolingIdx, uint64 *rx_count, uint64 *tx_count)
{

#if defined (CONFIG_RTK_L34_XPON_PLATFORM)
	ASSERT_EQ(rtk_stat_hostCnt_get(hostPolingIdx, STAT_HOST_RX_OCTETS, rx_count),RT_ERR_OK);
	ASSERT_EQ(rtk_stat_hostCnt_get(hostPolingIdx, STAT_HOST_TX_OCTETS, tx_count),RT_ERR_OK);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	aal_l3_te_pm_policer_t l3_pm_data;
#if defined(CONFIG_FC_CAG3_SERIES)
	aal_l2_te_pm_policer_t l2_pm_data;
#endif

	//get rx counter
	if(fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx != FAIL)
	{
		if(fc_db.controlFuc.loopbackMode_is_enabled)
		{
#if defined(CONFIG_FC_CAG3_SERIES)
			ASSERT_EQ(aal_l2_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx, &l2_pm_data), CA_E_OK); //read clear
			fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter.rx_count += l2_pm_data.total_bytes - l2_pm_data.red_bytes; //get forward count
#endif
		}
		else
		{
#if defined(CONFIG_FC_CA8277B_SERIES)
			ASSERT_EQ(aal_l3_te_pm_policer_flow3_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#else
			ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#endif
			fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter.rx_count += l3_pm_data.total_bytes - l3_pm_data.red_bytes; //get forward count
		}
	}
	//get tx counter
	if(fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx != FAIL)
	{
		if(fc_db.controlFuc.loopbackMode_is_enabled)
		{
#if defined(CONFIG_FC_CAG3_SERIES)		
			ASSERT_EQ(aal_l2_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx, &l2_pm_data), CA_E_OK); //read clear
			fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter.tx_count += l2_pm_data.total_bytes - l2_pm_data.red_bytes; //get forward count
#endif
		}
		else
		{
#if defined(CONFIG_FC_CA8277B_SERIES)
			ASSERT_EQ(aal_l3_te_pm_policer_flow3_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#else
			ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#endif
			fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter.tx_count += l3_pm_data.total_bytes - l3_pm_data.red_bytes; //get forward count
		}
	}

	*rx_count = fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter.rx_count;
	*tx_count = fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter.tx_count;
#endif

	return SUCCESS;
}

int32 _rtk_fc_hwHostPolingMib_clear(uint32 hostPolingIdx)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	ASSERT_EQ(rtk_stat_hostCnt_reset(hostPolingIdx),RT_ERR_OK); // clear HW counter
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	aal_l3_te_pm_policer_t l3_pm_data;
#if defined(CONFIG_FC_CAG3_SERIES)
	aal_l2_te_pm_policer_t l2_pm_data;
#endif

	if(fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx != FAIL)
	{
		if(fc_db.controlFuc.loopbackMode_is_enabled){
#if defined(CONFIG_FC_CAG3_SERIES)
			ASSERT_EQ(aal_l2_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx, &l2_pm_data), CA_E_OK); //read clear
#endif
		} else
		{
#if defined(CONFIG_FC_CA8277B_SERIES)
			ASSERT_EQ(aal_l3_te_pm_policer_flow3_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#else
			ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingRx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#endif
		}
	}
	if(fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx != FAIL)
	{
		if(fc_db.controlFuc.loopbackMode_is_enabled) {
#if defined(CONFIG_FC_CAG3_SERIES)
			ASSERT_EQ(aal_l2_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx, &l2_pm_data), CA_E_OK); //read clear
#endif
		} else
		{
#if defined(CONFIG_FC_CA8277B_SERIES)
			ASSERT_EQ(aal_l3_te_pm_policer_flow3_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#else
			ASSERT_EQ(aal_l3_te_pm_policer_flow_get(G3_DEF_DEVID, fc_db.hostPoliceTable[hostPolingIdx].loggingTx_policerIdx, &l3_pm_data), CA_E_OK); //read clear
#endif
		}
	}
	memset(&fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter, 0 , sizeof(fc_db.hostPoliceTable[hostPolingIdx].hwHostPoliceCounter));
#endif

	return SUCCESS;
}

int _rtk_fc_l3Meter_set(rt_rate_ext_meter_type_t meterType, uint32 index, uint32 rate, rtk_enable_t ifgInclude)
{
	int ret = SUCCESS;
	uint32 hw_idx = index;

#if defined (CONFIG_RTK_L34_XPON_PLATFORM)
	ret = rtk_rg_asic_shareMeter_set(hw_idx, rate, ifgInclude);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(meterType == RT_RATE_EXT_METER_TYPE_FLOW)
	{
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
		hw_idx += G3_FLOW_POLICER_IDXSHIFT_FLOWMTR;
		ret = _rtk_fc_g3L3Policer2_set(hw_idx, rate, ifgInclude);//8277B/8277C, flow meter use flow policer2
#else
		ret = _rtk_fc_g3L3Policer_set(hw_idx, rate, ifgInclude);//On G3 platform, set L3 policer directly
#endif
	}
	else
	{
		ret = _rtk_fc_g3L3Policer_set(hw_idx, rate, ifgInclude);//On G3 platform, set L3 policer directly
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
		if(meterType == RT_RATE_EXT_METER_TYPE_ACL)
			ret = _rtk_fc_g3PolRemap_sync(hw_idx);
#endif

	}
#endif
	if((meterType == RT_RATE_EXT_METER_TYPE_FLOW) && (ret == SUCCESS)) {
		fc_db.l34Meter[index].rate = rate;
		fc_db.l34Meter[index].ifgInclude = ifgInclude;
	}

	return ret;
}

int _rtk_fc_l3Meter_get(rt_rate_ext_meter_type_t meterType, uint32 index, uint32 *pRate , rtk_enable_t *pIfgInclude)
{
	int ret = SUCCESS;
	uint32 hw_idx = index;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	ret = rtk_rg_asic_shareMeter_get(hw_idx, pRate, pIfgInclude);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(meterType == RT_RATE_EXT_METER_TYPE_FLOW)
	{
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
		hw_idx += G3_FLOW_POLICER_IDXSHIFT_FLOWMTR;
		ret = _rtk_fc_g3L3Policer2_get(hw_idx, pRate, pIfgInclude);//8277B/8277C, flow meter use flow policer2
#else
		ret = _rtk_fc_g3L3Policer_get(hw_idx, pRate, pIfgInclude); //On G3 platform, get L3 policer directly
#endif
	}
	else
	{
		ret = _rtk_fc_g3L3Policer_get(hw_idx, pRate, pIfgInclude); //On G3 platform, get L3 policer directly
	}
#endif

	return ret;
}

int _rtk_fc_l3MeterBucket_set(rt_rate_ext_meter_type_t meterType, uint32 index, uint32 bucketSize)
{
	int ret = SUCCESS;
	int32 hw_idx = index;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	ret = rtk_rg_asic_shareMeterBucket_set(hw_idx, bucketSize);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(meterType == RT_RATE_EXT_METER_TYPE_FLOW)
	{
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
		hw_idx += G3_FLOW_POLICER_IDXSHIFT_FLOWMTR;
		ret = _rtk_fc_g3L3Policer2BurstSize_set(hw_idx, bucketSize);//8277B/8277C, flow meter use flow policer2
#else
		ret = _rtk_fc_g3L3PolicerBurstSize_set(hw_idx, bucketSize);//On G3 platform, set L3 policer directly
#endif
	}
	else
	{
		ret = _rtk_fc_g3L3PolicerBurstSize_set(hw_idx, bucketSize);//On G3 platform, set L3 policer directly
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
		if(meterType == RT_RATE_EXT_METER_TYPE_ACL)
			ret = _rtk_fc_g3PolRemap_sync(hw_idx);
#endif

	}
#endif
	return ret;
}
int _rtk_fc_l3MeterBucket_get(rt_rate_ext_meter_type_t meterType, uint32 index, uint32 *pBucketSize)
{
	int ret = SUCCESS;
	int32 hw_idx = index;
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	ret = rtk_rg_asic_shareMeterBucket_get(hw_idx, pBucketSize);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	if(meterType == RT_RATE_EXT_METER_TYPE_FLOW)
	{
#if defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
		hw_idx += G3_FLOW_POLICER_IDXSHIFT_FLOWMTR;
		ret = _rtk_fc_g3L3Policer2BurstSize_get(hw_idx, pBucketSize);//8277B/8277C, flow meter use flow policer2
#else
		ret = _rtk_fc_g3L3PolicerBurstSize_get(hw_idx, pBucketSize);//On G3 platform, set L3 policer directly
#endif
	}
	else
	{
		ret = _rtk_fc_g3L3PolicerBurstSize_get(hw_idx, pBucketSize);//On G3 platform, set L3 policer directly
	}
#endif
	return ret;
}

int _rtk_fc_wanAccessLimit_IP_insert(uint32 sip)
{
	rtk_fc_wan_access_limit_IP_list_t *pList = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_wan_access_limit_IP_list_t), GFP_ATOMIC);
	if(pList==NULL)
	{
		WARNING("[ERROR] Preallocte flow cache entries failed!\n\n");
		return FAILED;
	}

	pList->sip=sip;
	list_add_tail(&pList->accessIP_list, &fc_db.wanAccessLimitIP_head[sip&0xff]);
	atomic_inc(&fc_db.wanAccessLimit.learningCount);
	return SUCCESS;
}

int _rtk_fc_wanAccessLimit_IP_delete(uint32 sip)
{
	rt_flow_op_flow_pattern_t flowPattern;
	rtk_fc_wan_access_limit_IP_list_t *pList,*pNext;
	struct list_head *pHead=&fc_db.wanAccessLimitIP_head[sip&0xffU];
	if(!list_empty(pHead))
	{
		list_for_each_entry_safe(pList, pNext, pHead, accessIP_list)
		{
			if(pList->sip==sip)
			{
				list_del(&pList->accessIP_list);
				RTK_FC_HELPER_FC_KFREE(pList,sizeof(rtk_fc_wan_access_limit_IP_list_t));
				atomic_dec(&fc_db.wanAccessLimit.learningCount);
				break;
			}
		}
	}
	//delete upstream flow
	memset(&flowPattern,0,sizeof(rt_flow_op_flow_pattern_t));
	flowPattern.sip4_valid=1U;
	flowPattern.sip4=sip;
	rtk_fc_flow_delete_by_pattern(flowPattern);
	memset(&flowPattern,0,sizeof(rt_flow_op_flow_pattern_t));
	//delete downstream flow
	flowPattern.modified_dip4_valid=1U;
	flowPattern.modified_dip4=sip;
	rtk_fc_flow_delete_by_pattern(flowPattern);
	return SUCCESS;
}

int _rtk_fc_wanAccessLimit_IP_reset()
{
	int i;
	rt_flow_op_flow_pattern_t flowPattern;
	rtk_fc_wan_access_limit_IP_list_t *pList,*pNext;
	for(i=0;i<RTK_FC_WAN_ACCESS_IP_BUCKET_SIZE;i++)
	{
		struct list_head *pHead=&fc_db.wanAccessLimitIP_head[i];
		if(!list_empty(pHead))
		{
			list_for_each_entry_safe(pList, pNext, pHead, accessIP_list)
			{
				list_del(&pList->accessIP_list);
				//delete upstream flow
				memset(&flowPattern,0,sizeof(rt_flow_op_flow_pattern_t));
				flowPattern.sip4_valid=1U;
				flowPattern.sip4=pList->sip;
				rtk_fc_flow_delete_by_pattern(flowPattern);
				//delete downstream flow
				memset(&flowPattern,0,sizeof(rt_flow_op_flow_pattern_t));
				flowPattern.modified_dip4_valid=1U;
				flowPattern.modified_dip4=pList->sip;
				rtk_fc_flow_delete_by_pattern(flowPattern);
				RTK_FC_HELPER_FC_KFREE(pList,sizeof(rtk_fc_wan_access_limit_IP_list_t));
				atomic_dec(&fc_db.wanAccessLimit.learningCount);
			}
		}
	}
	return SUCCESS;
}

int _rtk_fc_wanAccessLimit_IP_lookup(uint32 sip)
{
	rtk_fc_wan_access_limit_IP_list_t *pList;
	struct list_head *pHead=&fc_db.wanAccessLimitIP_head[sip&0xff];
	if(!list_empty(pHead))
	{
		list_for_each_entry(pList, pHead, accessIP_list)
		{
			if(pList->sip==sip)
				return SUCCESS;
		}
	}
	return FAILED;
}

void _rtk_fc_wanAccessLimit_timer_init(void)
{
	//check activity, just return if timer enable now
	if(atomic_inc_return(&fc_db.wanAccessLimit.timer_activity)==1)
	{
		if(RTK_FC_HELPER_TIMER_PENDING(fc_db.wanAccessLimit.neighbor_probe_timer))
			RTK_FC_HELPER_DEL_TIMER(fc_db.wanAccessLimit.neighbor_probe_timer);

		if(fc_db.wanAccessLimit.limitField==RT_MISC_WAN_ACCESS_LIMIT_BY_MAC)
		{
			fc_db.wanAccessLimit.probing_l2Idx = FAIL;	//init
			RTK_FC_HELPER_SETUP_TIMER(fc_db.wanAccessLimit.neighbor_probe_timer, _rtk_fc_wanAccessLimit_byMac_function, (unsigned long)NULL);
		}
		else
		{
			fc_db.wanAccessLimit.probing_IP = 0;	//init
			RTK_FC_HELPER_SETUP_TIMER(fc_db.wanAccessLimit.neighbor_probe_timer, _rtk_fc_wanAccessLimit_byIP_function, (unsigned long)NULL);
		}
		//_rtk_fc_wanAccessLimit_timer_function();
		RTK_FC_HELPER_MOD_TIMER(fc_db.wanAccessLimit.neighbor_probe_timer, jiffies+(fc_db.wanAccessLimitProbeInterval_unit1s*CONFIG_HZ/*unit:1sec*/));
	}
	else
		TIMER("The neighbor lookup timer is actived..");
}

void _rtk_fc_wanAccessLimit_byMac_function(unsigned long task_priv)
{
	int i,ret_v4,ret_v6;

	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();

	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);

	i=fc_db.wanAccessLimit.probing_l2Idx;
	fc_db.wanAccessLimit.probing_l2Idx=FAIL;

	//lookup neighbor from l2 table.
	if(i>=0)
	{
		if(fc_db.lutTbl[i])
		{
			TIMER("check %d again...",i);
			//check v4 and v6 neighbor
			ret_v4=_rtk_fc_lookup_v4neighbor(fc_db.lutTbl[i]->l2Addr);
			ret_v6=_rtk_fc_lookup_v6neighbor(fc_db.lutTbl[i]->l2Addr);
			if(ret_v4==FALSE && ret_v6==FALSE)
			{
				//delete the lut, then return
				TIMER("the LUT[%d] is not connected, delete it!",i);
				RTK_FC_LUT_DEL(fc_db.lutTbl[i], FALSE);
				goto OUT_NEIGH_LOOKUP;
			}

			TIMER("alive, choose another permitted LUT...");
			//find next valid lut
			for(i++;i<RTK_FC_TABLESIZE_LUT;i++)
			{
				if(fc_db.lutTbl[i] && fc_db.lutTbl[i]->isPermitWanAccess && ((fc_db.wanAccessLimit.portMask&(0x1<<fc_db.lutTbl[i]->spa))
					|| (fc_db.lutTbl[i]->wlan_dev_idx!=RTK_FC_WLANX_NOT_FOUND && (fc_db.wanAccessLimit.wlanMask&(1LL<<fc_db.lutTbl[i]->wlan_dev_idx)))))
				{
					//check v4 first
					ret_v4=_rtk_fc_lookup_v4neighbor(fc_db.lutTbl[i]->l2Addr);
					if(ret_v4!=FALSE)
					{
						//change its nud, modify timer, return
						_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byMac_cb, (void *)fc_db.lutTbl[i]->l2Addr);
					}
					//check v6 neighbor
					ret_v6=_rtk_fc_lookup_v6neighbor(fc_db.lutTbl[i]->l2Addr);
					if(ret_v6!=FALSE)
					{
						//change its nud, modify timer, return
						_rtk_fc_enumerate_v6neighbor(_rtk_fc_wanAccessLimit_byMac_cb, (void *)fc_db.lutTbl[i]->l2Addr);
					}	
					if(ret_v4==FALSE && ret_v6==FALSE)
					{
						//delete the lut, then return
						TIMER("the LUT[%d] is not connected, delete it!",i);
						RTK_FC_LUT_DEL(fc_db.lutTbl[i], FALSE);
						goto OUT_NEIGH_LOOKUP;
					}
					TIMER("use the LUT[%d] for check!",i);
					fc_db.wanAccessLimit.probing_l2Idx=i;
					break;
				}
			}
		}
		//no match lut anymore..
	}
	else
	{
		TIMER("choose one permitted LUT for check alive...");
		//find one valid lut, change its nud, modify timer, return
		for(i=0;i<RTK_FC_TABLESIZE_LUT;i++)
		{
			if(fc_db.lutTbl[i] && fc_db.lutTbl[i]->isPermitWanAccess && ((fc_db.wanAccessLimit.portMask&(0x1<<fc_db.lutTbl[i]->spa))
				|| (fc_db.lutTbl[i]->wlan_dev_idx!=RTK_FC_WLANX_NOT_FOUND && (fc_db.wanAccessLimit.wlanMask&(1LL<<fc_db.lutTbl[i]->wlan_dev_idx)))))
			{
				//check v4 first
				ret_v4=_rtk_fc_lookup_v4neighbor(fc_db.lutTbl[i]->l2Addr);
				if(ret_v4!=FALSE)
				{
					//change its nud, modify timer, return
					_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byMac_cb, (void *)fc_db.lutTbl[i]->l2Addr);
				}
				//check v6 neighbor
				ret_v6=_rtk_fc_lookup_v6neighbor(fc_db.lutTbl[i]->l2Addr);
				if(ret_v6!=FALSE)
				{
					//change its nud, modify timer, return
					_rtk_fc_enumerate_v6neighbor(_rtk_fc_wanAccessLimit_byMac_cb, (void *)fc_db.lutTbl[i]->l2Addr);
				}
				if(ret_v4==FALSE && ret_v6==FALSE)
				{
					//delete the lut, then return
					TIMER("the LUT[%d] is not connected, delete it!",i);
					RTK_FC_LUT_DEL(fc_db.lutTbl[i], FALSE);
					goto OUT_NEIGH_LOOKUP;
				}
				TIMER("use the LUT[%d] for check!",i);
				fc_db.wanAccessLimit.probing_l2Idx=i;
				break;
			}
		}
	}

OUT_NEIGH_LOOKUP:
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();

	if(fc_db.wanAccessLimit.probing_l2Idx==FAIL)
		atomic_set(&fc_db.wanAccessLimit.timer_activity, 0);

	return;
}

void _rtk_fc_wanAccessLimit_byMac_cb(struct neighbour *neigh, void *cookie)
{
	if(_rtk_fc_compare_neighbor_ha_nud(neigh, cookie, NUD_NONE))
	{
		TIMER("!!!!match!!!!");

		_rtk_fc_update_neighbor_nud(neigh, NUD_PROBE, NEIGH_UPDATE_F_ADMIN);

		RTK_FC_HELPER_MOD_TIMER(fc_db.wanAccessLimit.neighbor_probe_timer, jiffies+(fc_db.wanAccessLimitProbeInterval_unit1s*CONFIG_HZ/*unit:1sec*/));
	}
}

void _rtk_fc_wanAccessLimit_byIP_function(unsigned long task_priv)
{
	int i;
	unsigned int cookie=0;

	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();

	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);

	//lookup neighbor from ip list.
	if(fc_db.wanAccessLimit.probing_IP>0)
	{
		TIMER("check %pI4 again!!",&fc_db.wanAccessLimit.probing_IP);
		//check existence
		cookie=fc_db.wanAccessLimit.probing_IP;
		_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byIP_connected_cb, (void *)&cookie);
		if(fc_db.wanAccessLimit.probing_IP>0)
		{
			TIMER("the IP %pI4 is not connected, delete it!",&cookie);
			//not found, delete it!
			_rtk_fc_wanAccessLimit_IP_delete(fc_db.wanAccessLimit.probing_IP);
			fc_db.wanAccessLimit.probing_IP=0;
		}
		else
		{
			//find next IP
			int found=0;
			TIMER("alive, choose another IP");
			for(i=cookie&0xff;i<RTK_FC_WAN_ACCESS_IP_BUCKET_SIZE;i++)
			{
				struct list_head *pHead=&fc_db.wanAccessLimitIP_head[i];
				if(!list_empty(pHead))
				{
					rtk_fc_wan_access_limit_IP_list_t *pList;
					list_for_each_entry(pList, pHead, accessIP_list)
					{
						if(found)
						{
							TIMER("use the IP %pI4 for check!!",&pList->sip);
							//use the first IP after old cookie entry.
							fc_db.wanAccessLimit.probing_IP=pList->sip;
							cookie=pList->sip;
							i=RTK_FC_WAN_ACCESS_IP_BUCKET_SIZE;
							_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byIP_exist_cb, (void *)&cookie);
							if(fc_db.wanAccessLimit.probing_IP==0)	//the neighbor exist
							{
								TIMER("neighbor exist, change nud..");
								fc_db.wanAccessLimit.probing_IP=cookie;
								//change its nud, modify timer, return
								_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byIP_cb, (void *)&cookie);
								found=2;
							}
							break;
						}
						else if(pList->sip==cookie)
							found=1;
					}
				}
			}
			if(found==1 && fc_db.wanAccessLimit.probing_IP>0)	//found next IP but without neighbor
			{
				TIMER("the next IP %pI4 is not exist, delete it!!",&fc_db.wanAccessLimit.probing_IP);
				//neighbor not found, delete it!
				_rtk_fc_wanAccessLimit_IP_delete(fc_db.wanAccessLimit.probing_IP);
				fc_db.wanAccessLimit.probing_IP=0;
			}
		}
	}
	else
	{
		TIMER("choose one IP for check alive..");
		//start from the beginning
		for(i=0;i<RTK_FC_WAN_ACCESS_IP_BUCKET_SIZE;i++)
		{
			struct list_head *pHead=&fc_db.wanAccessLimitIP_head[i];
			if(!list_empty(pHead))
			{
				rtk_fc_wan_access_limit_IP_list_t *pList;
				list_for_each_entry(pList, pHead, accessIP_list)
				{
					TIMER("choose IP:%pI4",&pList->sip);
					//use the first IP.
					fc_db.wanAccessLimit.probing_IP=pList->sip;
					cookie=pList->sip;
					i=RTK_FC_WAN_ACCESS_IP_BUCKET_SIZE;
					_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byIP_exist_cb, (void *)&cookie);
					break;
				}
			}
		}
		if(cookie>0)	//got valid IP
		{
			TIMER("if the IP exist?");
			if(fc_db.wanAccessLimit.probing_IP==0)	//the neighbor exist
			{
				TIMER("YES! change it's nud");
				fc_db.wanAccessLimit.probing_IP=cookie;
				//change its nud, modify timer, return
				_rtk_fc_enumerate_v4neighbor(_rtk_fc_wanAccessLimit_byIP_cb, (void *)&cookie);
			}
			else
			{
				TIMER("NO! the neighbor is not exist, delete IP %pI4",&fc_db.wanAccessLimit.probing_IP);
				//neighbor not found, delete it!
				_rtk_fc_wanAccessLimit_IP_delete(fc_db.wanAccessLimit.probing_IP);
				fc_db.wanAccessLimit.probing_IP=0;
			}
		}
	}

	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();

	if(fc_db.wanAccessLimit.probing_IP==0)
		atomic_set(&fc_db.wanAccessLimit.timer_activity, 0);

	return;
}

void _rtk_fc_wanAccessLimit_byIP_exist_cb(struct neighbour *neigh, void *cookie)
{

	if(_rtk_fc_compare_neighbor_primary_key_nud(neigh, cookie, NUD_VALID))
	{
		TIMER("neighbor[%pI4] is VALID!",RTK_FC_HOOK_PS_NEIGH_KEY_GET(neigh));
		//since the neigh is exist, the host is alive.
		fc_db.wanAccessLimit.probing_IP=0;
	}
}

void _rtk_fc_wanAccessLimit_byIP_connected_cb(struct neighbour *neigh, void *cookie)
{
	if(_rtk_fc_compare_neighbor_primary_key_nud(neigh, cookie, NUD_CONNECTED))
	{
		TIMER("neighbor[%pI4] is CONNECT!",RTK_FC_HOOK_PS_NEIGH_KEY_GET(neigh));
		//since the neigh is exist, the host is alive.
		fc_db.wanAccessLimit.probing_IP=0;
	}
}

void _rtk_fc_wanAccessLimit_byIP_cb(struct neighbour *neigh, void *cookie)
{
	if(_rtk_fc_compare_neighbor_primary_key_nud(neigh, cookie, NUD_NONE))
	{
		TIMER("!!!!match!!!!");

		_rtk_fc_update_neighbor_nud(neigh, NUD_PROBE, NEIGH_UPDATE_F_ADMIN);

		RTK_FC_HELPER_MOD_TIMER(fc_db.wanAccessLimit.neighbor_probe_timer, jiffies+(fc_db.wanAccessLimitProbeInterval_unit1s*CONFIG_HZ/*unit:1sec*/));
	}
}

void _rtk_fc_sharing_image_flow_structure_convert(rtk_rg_asic_path1_entry_t *pP1Data)
{
// In order to share an image between 9607C and 9603CVD
#if defined(CONFIG_RTL9607C_SERIES) && !defined(__LITTLE_ENDIAN)
	if(ASIC_CHIP_ID==RTL9603CVD_CHIP_ID)
	{
		if(pP1Data->in_path==FB_PATH_12) // path 1, 2
		{
			pP1Data->in_spa >>= 1;
			pP1Data->out_portmask >>= 5;
		}
		else if(pP1Data->in_path==FB_PATH_34)	// path 3, 4
		{
			pP1Data->out_portmask >>= 5;
		}
	}
#endif	
	return;
}

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
void _rtk_fc_sharing_image_port_define(void)
{
	if(CHIP_ID_9607C) {
		/* RTL9607C */
		fc_db.systemGlobal.macport_0 = 0;
		fc_db.systemGlobal.macport_1 = 1;
		fc_db.systemGlobal.macport_2 = 2;
		fc_db.systemGlobal.macport_3 = 3;
		fc_db.systemGlobal.macport_4 = 4;
		fc_db.systemGlobal.macport_pon = 5;
		fc_db.systemGlobal.macport_inic = 6;
		fc_db.systemGlobal.macport_scpu = 7;
		fc_db.systemGlobal.macport_rgmii = 8;
		fc_db.systemGlobal.macport_mcpu_0 = 9;
		fc_db.systemGlobal.macport_mcpu_1 = 10;

		fc_db.systemGlobal.mac10extport_0 = 6;
		fc_db.systemGlobal.mac7extport_0 = 12;
	}else {
		/* RTL9603CVD */
		fc_db.systemGlobal.macport_0 = 0;
		fc_db.systemGlobal.macport_1 = 1;
		fc_db.systemGlobal.macport_2 = 2;
		fc_db.systemGlobal.macport_3 = 3;
		fc_db.systemGlobal.macport_pon = 4;
		fc_db.systemGlobal.macport_scpu = 5;
		fc_db.systemGlobal.macport_mcpu_0 = 5;
		fc_db.systemGlobal.macport_mcpu_1 = 5;
		
		fc_db.systemGlobal.macport_4 = 3;
		fc_db.systemGlobal.macport_inic = 3;
		fc_db.systemGlobal.macport_rgmii = 3;
		
		fc_db.systemGlobal.mac10extport_0 = 0;
		fc_db.systemGlobal.mac7extport_0 = 0;
	}
}
#endif

/* in order with rtk_fc_swFlowPatternFlag_t*/
uint16 patternSizeMapping[FLOW_PATTERN_MAX];		//byte unit 

int32 rtk_fc_abstrSwFlowModule_init(void)
{
	memset(&patternSizeMapping,0,sizeof(patternSizeMapping));
	patternSizeMapping[FLOW_PHY_LSPID] = 1;
	patternSizeMapping[FLOW_PHY_STREAMID] = 1;
	patternSizeMapping[FLOW_L2_DMAC] = 6;
	patternSizeMapping[FLOW_L2_SMAC] = 6;
	patternSizeMapping[FLOW_L2_ETH] = 2;
	patternSizeMapping[FLOW_L2_CVLANTAG] = 2;
	patternSizeMapping[FLOW_L2_CVLAN] = 0;
	patternSizeMapping[FLOW_L2_CPRI] = 0;
	patternSizeMapping[FLOW_L2_CDEI] = 0;
	patternSizeMapping[FLOW_L2_SVLANTAG] = 2;
	patternSizeMapping[FLOW_L2_SVLAN] = 0;
	patternSizeMapping[FLOW_L2_SPRI] = 0;
	patternSizeMapping[FLOW_L2_SDEI] = 0;
	patternSizeMapping[FLOW_L2_PPPOETAG] = 0;
	patternSizeMapping[FLOW_L2_PPPOESID] = 2;
	patternSizeMapping[FLOW_L3_IPVER46] = 0;
	patternSizeMapping[FLOW_L3_DIP] = 4;		//if v6 we put v6dipHash(32bits)
	patternSizeMapping[FLOW_L3_SIP] = 4;		//if v6 we put v6sipHash(32bits)
	patternSizeMapping[FLOW_L3_TOS] = 1;
	patternSizeMapping[FLOW_L4_PROTO] = 1;
	patternSizeMapping[FLOW_L4_DPORT] = 2;
	patternSizeMapping[FLOW_L4_SPORT] = 2;

	return SUCCESS;
}


int32 rtk_fc_abstrSwFlowDelTemplateType(uint32 typeMsk)
{
	int i;
	rtk_fc_abstrSwFlowType_entry_t tmp_abstrSwFlowType;
	bzero(&tmp_abstrSwFlowType,sizeof(tmp_abstrSwFlowType));
	
	tmp_abstrSwFlowType.patternFlagMsk=typeMsk;
	tmp_abstrSwFlowType.patternSize=ABSTR_SWFLOW_PATTERN_RESVED_SIZE;

	if(typeMsk&(TYPETOMSK(FLOW_L2_CVLAN) | TYPETOMSK(FLOW_L2_CPRI) | TYPETOMSK(FLOW_L2_CDEI)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L2_CVLANTAG);
	if(typeMsk&(TYPETOMSK(FLOW_L2_SVLAN) | TYPETOMSK(FLOW_L2_SPRI) | TYPETOMSK(FLOW_L2_SDEI)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L2_SVLANTAG);
	if(typeMsk&(TYPETOMSK(FLOW_L2_PPPOESID)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L2_PPPOETAG);	
	if(typeMsk&(TYPETOMSK(FLOW_L3_DIP) | TYPETOMSK(FLOW_L3_SIP)|TYPETOMSK(FLOW_L3_TOS)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L3_IPVER46);
	if(typeMsk&(TYPETOMSK(FLOW_L4_DPORT) | TYPETOMSK(FLOW_L4_SPORT)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L4_PROTO);

	for(i=0;i<FLOW_PATTERN_MAX;i++)
	{
		if(tmp_abstrSwFlowType.patternFlagMsk & TYPETOMSK(i))
		{
			tmp_abstrSwFlowType.patternSize+=patternSizeMapping[i];
		}
	}

	if(tmp_abstrSwFlowType.patternSize > sizeof(rtk_fc_abstrSwFlowPattern_entry_t))
	{
		WARNING("patternSize(%u) > rtk_fc_abstrSwFlowPattern_entry_t(%u) ",tmp_abstrSwFlowType.patternSize, (uint32)sizeof(rtk_fc_abstrSwFlowPattern_entry_t));
		return FAIL;
	}
	for(i=0;i<ABSTR_SWFLOW_TYPE_SIZE;i++)
	{
		if(fc_db.abstrSwFlowType[i].valid)
		{
			if(fc_db.abstrSwFlowType[i].patternFlagMsk == tmp_abstrSwFlowType.patternFlagMsk)
			{
				//delete type
				bzero(&fc_db.abstrSwFlowType[i],sizeof(fc_db.abstrSwFlowType[i]));
				return SUCCESS;
			}

		}
	}

	WARNING("abstrSwFlowType not exist typeMsk=%x",typeMsk);
	return FAIL;

}

int32 rtk_fc_abstrSwFlowAddTemplateType(uint32 typeMsk,uint32 pri)
{
	int i;
	int firstInvalid=FAIL;
	rtk_fc_abstrSwFlowType_entry_t tmp_abstrSwFlowType;
	bzero(&tmp_abstrSwFlowType,sizeof(tmp_abstrSwFlowType));
	
	tmp_abstrSwFlowType.patternFlagMsk=typeMsk;
	tmp_abstrSwFlowType.patternSize=ABSTR_SWFLOW_PATTERN_RESVED_SIZE;

	if(typeMsk&(TYPETOMSK(FLOW_L2_CVLAN) | TYPETOMSK(FLOW_L2_CPRI) | TYPETOMSK(FLOW_L2_CDEI)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L2_CVLANTAG);
	if(typeMsk&(TYPETOMSK(FLOW_L2_SVLAN) | TYPETOMSK(FLOW_L2_SPRI) | TYPETOMSK(FLOW_L2_SDEI)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L2_SVLANTAG);
	if(typeMsk&(TYPETOMSK(FLOW_L2_PPPOESID)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L2_PPPOETAG);	
	if(typeMsk&(TYPETOMSK(FLOW_L3_DIP) | TYPETOMSK(FLOW_L3_SIP)|TYPETOMSK(FLOW_L3_TOS)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L3_IPVER46);
	if(typeMsk&(TYPETOMSK(FLOW_L4_DPORT) | TYPETOMSK(FLOW_L4_SPORT)))
		tmp_abstrSwFlowType.patternFlagMsk|=TYPETOMSK(FLOW_L4_PROTO);

	
	for(i=0;i<ABSTR_SWFLOW_TYPE_SIZE;i++)
	{
		if(fc_db.abstrSwFlowType[i].valid==0)
		{
			if(firstInvalid==FAIL)
				firstInvalid=i;
		}
		else
		{
			if(fc_db.abstrSwFlowType[i].patternFlagMsk == tmp_abstrSwFlowType.patternFlagMsk)
			{
				//using old one update pri 
				fc_db.abstrSwFlowType[i].flowTypePri=pri;
				return SUCCESS;
			}

		}
	}
	if(firstInvalid==FAIL)
	{
		WARNING("rtk_fc_abstrSwFlowAddTemplateType Error ");
		return FAIL;
	}

	bzero(&fc_db.abstrSwFlowType[firstInvalid],sizeof(fc_db.abstrSwFlowType[firstInvalid]));
	fc_db.abstrSwFlowType[firstInvalid].valid=1;
	fc_db.abstrSwFlowType[firstInvalid].patternFlagMsk=tmp_abstrSwFlowType.patternFlagMsk;
	fc_db.abstrSwFlowType[firstInvalid].patternSize=ABSTR_SWFLOW_PATTERN_RESVED_SIZE;
	fc_db.abstrSwFlowType[firstInvalid].flowTypePri=pri;

	for(i=0;i<FLOW_PATTERN_MAX;i++)
	{
		if(fc_db.abstrSwFlowType[firstInvalid].patternFlagMsk & TYPETOMSK(i))
		{
			fc_db.abstrSwFlowType[firstInvalid].patternSize+=patternSizeMapping[i];
		}
	}

	if(fc_db.abstrSwFlowType[firstInvalid].patternSize > sizeof(rtk_fc_abstrSwFlowPattern_entry_t))
	{
		WARNING("patternSize(%u) > rtk_fc_abstrSwFlowPattern_entry_t(%u) ",fc_db.abstrSwFlowType[firstInvalid].patternSize, (uint32)sizeof(rtk_fc_abstrSwFlowPattern_entry_t));
		fc_db.abstrSwFlowType[firstInvalid].valid=0;
		return FAIL;
	}

	return firstInvalid;

}


int32 rtk_fc_abstrSwFlowActGenBySkb(rtk_fc_pktHdr_t *pPktHdr,struct rt_skbuff *rtskb,rtk_fc_abstrSwFlowAction_entry_t *action)
{

	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);

	uint16 offset=0;
	//uint8 isIpv6 = 0, isDslite = 0, l4Protocol = 0, isNAPT = 0;
	uint16 igrCVlanTagif = 0, igrCVID = 0,igrCPRI = 0, egrCVlanTagif = 0, egrCVID = 0,egrCPRI = 0;
	uint16 igrSVlanTagif = 0, igrSVID = 0,igrSPRI = 0, egrSVlanTagif = 0, egrSVID = 0,egrSPRI = 0;
	uint16 igrPPPoETagif = 0 , egrPPPoETagif=0 ,egrPPPoESSID=0;
	//uint32 sip = 0, dip = 0;
	//uint16 sport = 0, dport = 0;

	bzero(action,sizeof(rtk_fc_abstrSwFlowAction_entry_t));

	// VLAN
	if(pFcIngressData->ingressTagif & SVLAN_TAGIF)
		igrSVlanTagif = TRUE;
	if(pFcIngressData->ingressTagif & CVLAN_TAGIF)
		igrCVlanTagif = TRUE;
	if(pFcIngressData->ingressTagif & PPPOE_TAGIF)
		igrPPPoETagif = TRUE;


	igrSVID = igrSVlanTagif ? pFcIngressData->srcSVlanId : 0;
	igrSPRI = igrSVlanTagif ? pFcIngressData->srcSVlanPri : 0;

	igrCVID = igrCVlanTagif ? pFcIngressData->srcCVlanId : 0;
	igrCPRI = igrCVlanTagif ? pFcIngressData->srcCVlanPri : 0;


	//FIXME USERMODE AUTOMODE
	egrSVlanTagif = pPktHdr->svh ? TRUE : FALSE;
	egrSVID = egrSVlanTagif ? pPktHdr->svlanid : 0;
	egrSPRI = egrSVlanTagif ? pPktHdr->svlanpri : 0;

	
	egrCVlanTagif = pPktHdr->cvh ? TRUE : FALSE;
	egrCVID = egrCVlanTagif ? pPktHdr->cvlanid : 0;
	egrCPRI = egrCVlanTagif ? pPktHdr->cvlanpri : 0;


	egrPPPoETagif = pPktHdr->ppph ? TRUE : FALSE;
	egrPPPoESSID = egrPPPoETagif ? ntohs(pPktHdr->ppph->sid):0;


/*
	isIpv6 = (pPktHdr->ip6h) ? TRUE : FALSE;

	if((!pFcIngressData->isDualHeader) && (pPktHdr->dualHdrType == RTK_FC_DUALTYPE_DSLITE)) // single -> dual && it is ds-lite packet: the IPv6 header is added at egress
	{
		isIpv6 = FALSE;
		isDslite = TRUE;
	}

	
	// l34 routing / napt
	if((pPktHdr->direction==RTK_FC_FLOW_DIRECTION_UPSTREAM) && pPktHdr->iph && (ntohl(pPktHdr->iph->saddr) != pFcIngressData->srcIp)) // for ipv4 up-stream
		isNAPT = TRUE;
	else if ((pPktHdr->direction==RTK_FC_FLOW_DIRECTION_UPSTREAM) && pPktHdr->ip6h && ((pPktHdr->ipv6Sip_hash) != pFcIngressData->srcIp) && (!isDslite)) // for ipv6 up-stream
		isNAPT = TRUE;
	
	
	if((pPktHdr->direction==RTK_FC_FLOW_DIRECTION_DOWNSTREAM) && pPktHdr->iph && (ntohl(pPktHdr->iph->daddr) != pFcIngressData->dstIp)) // for ipv4 down-stream
		isNAPT = TRUE;
	else if((pPktHdr->direction==RTK_FC_FLOW_DIRECTION_DOWNSTREAM) && pPktHdr->ip6h && (pPktHdr->ipv6Dip_hash != pFcIngressData->dstIp))// for ipv6 down-stream
		isNAPT = TRUE;
	
	if(isNAPT && isIpv6 ){
		TRACE("[IPv6 NAT]IPv6 %sNAT! Sw-flow only!", pPktHdr->direction == RTK_FC_FLOW_DIRECTION_UPSTREAM?"S":"D");
		
		pPktHdr->isV6_NAT = TRUE; //For adding ipv6 nat in _rtk_fc_flow_swField_set
	}

	
	// prepare ip port info
	sip = pFcIngressData->srcIp;
	dip = pFcIngressData->dstIp;
	
	sport = pFcIngressData->srcPort;
	dport = pFcIngressData->dstPort;
*/



	//action setting 
	
	//DMAC
	if(memcmp(pFcIngressData->da,pPktHdr->eth->h_dest,sizeof(pFcIngressData->da))!=0)
	{
		action->bits.dmacTrans=1;
		memcpy(&action->swAction[offset],pPktHdr->eth->h_dest,patternSizeMapping[FLOW_L2_DMAC]);
		offset+=patternSizeMapping[FLOW_L2_DMAC];
	}

	//SMAC
	if(memcmp(pFcIngressData->sa,pPktHdr->eth->h_source,sizeof(pFcIngressData->sa))!=0)
	{
		action->bits.smacTrans=1;
		memcpy(&action->swAction[offset],pPktHdr->eth->h_source,patternSizeMapping[FLOW_L2_SMAC]);
		offset+=patternSizeMapping[FLOW_L2_SMAC];
	}

	//SVLAN
	if(egrSVlanTagif==FALSE)
		action->bits.stagCmd=SWFLOW_EGACT_UNTAG;
	else
	{
		uint16 svlan= 0;
		action->bits.stagCmd=SWFLOW_EGACT_TAG;
		
		//untag/tag -> tag
		svlan = (egrSPRI<<VLAN_PRIO_SHIFT)| egrSVID;
		
		memcpy(&action->swAction[offset],&svlan,patternSizeMapping[FLOW_L2_SVLANTAG]);
		offset+=patternSizeMapping[FLOW_L2_SVLANTAG];
	}

	//CVLAN
	if(egrCVlanTagif==FALSE)
		action->bits.ctagCmd=SWFLOW_EGACT_UNTAG;
	else
	{
		uint16 cvlan= 0;
		action->bits.ctagCmd=SWFLOW_EGACT_TAG;
		
		//untag/tag -> tag
		cvlan = (egrCPRI<<VLAN_PRIO_SHIFT)| egrCVID;
		
		memcpy(&action->swAction[offset],&cvlan,patternSizeMapping[FLOW_L2_CVLANTAG]);
		offset+=patternSizeMapping[FLOW_L2_CVLANTAG];
	}


	//PPPoE
	 if(egrPPPoETagif==FALSE)
		action->bits.pppoeCmd=SWFLOW_EGACT_UNTAG;
	else
	{
		action->bits.pppoeCmd=SWFLOW_EGACT_TAG;
		memcpy(&action->swAction[offset],&egrPPPoESSID,patternSizeMapping[FLOW_L2_PPPOESID]);
		offset+=patternSizeMapping[FLOW_L2_PPPOESID];
	}

	FIXME("DIP/SIP/L4DPORT/L4SPORT action Set");
	
	//DIP

	//SIP

	//DSCP ENC always assign
	{
		uint8  ipTos=0;
		action->bits.dscpCmd=1;
		action->bits.ecnCmd=1;
		if(pPktHdr->iph)
		{
			ipTos =  pPktHdr->iph->tos;
			memcpy(&action->swAction[offset],&ipTos,1);

		}
		else if(pPktHdr->ip6h)
		{
			ipTos =  ((pPktHdr->ip6h->priority<<4) | (pPktHdr->ip6h->flow_lbl[0]>>4));
			memcpy(&action->swAction[offset],&ipTos,patternSizeMapping[FLOW_L3_TOS]);		
		}
		offset+=patternSizeMapping[FLOW_L3_TOS];
	}
	
	//DPORT

	//SPORT



	//FLOW PRIORITY
	if(pPktHdr->remarkDec.outputQid)
	{
		uint8 user_priority=0;
		action->bits.userPriCmd=1;
		user_priority = pPktHdr->remarkDec.outputQid;
		memcpy(&action->swAction[offset],&user_priority,1);
		offset+=1;
	}

	//PON STREAMID
	if(pPktHdr->remarkDec.streamId_en)
	{
		uint8 ponStreamId=0;
		action->bits.ponStreamIdCmd=1;
		ponStreamId = pPktHdr->remarkDec.streamId;
		memcpy(&action->swAction[offset],&ponStreamId,patternSizeMapping[FLOW_PHY_STREAMID]); 	
		offset+=patternSizeMapping[FLOW_PHY_STREAMID];
	}


	if(offset+ABSTR_SWFLOW_ACTION_RESVED_SIZE >= sizeof(rtk_fc_abstrSwFlowAction_entry_t) )
	{
		WARNING("offset+ABSTR_SWFLOW_ACTION_RESVED_SIZE > rtk_fc_abstrSwFlowAction_entry_t ");
		return RTK_FC_RET_ERR;
	}
	
	return RTK_FC_RET_OK;
}


//for rtk_fc_egress_abstrSwFlowDecision
int32 rtk_fc_abstrSwFlowPatternGenBySkb(rtk_fc_pktHdr_t *pPktHdr,struct rt_skbuff *rtskb,rtk_fc_abstrSwFlowPattern_entry_t *swFlowPatten,uint8 flowTye)
{
	int32 offset=0;
	uint16 ctag=0,stag=0;  //  (vpri<<VLAN_PRIO_SHIFT)|(vlan)
	rtk_fc_ingress_data_t *pFcIngressData = RTSKB_FCIGRDATA(rtskb);

	if(ABSTR_SWFLOW_TYPE_SIZE <= flowTye)
		return FAIL;
	if(fc_db.abstrSwFlowType[flowTye].valid==0)
		return FAIL;

	memset(swFlowPatten,0,sizeof(rtk_fc_abstrSwFlowPattern_entry_t));

	swFlowPatten->bits.flowtype=flowTye;

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_PHY_LSPID) )
	{
		uint8 lspid=pFcIngressData->ingressPort;
		memcpy(&swFlowPatten->swPattern[offset],&lspid,patternSizeMapping[FLOW_PHY_LSPID]);
		offset+=patternSizeMapping[FLOW_PHY_LSPID];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_PHY_STREAMID) )
	{
		uint8 ponStreamId=pFcIngressData->ponStreamId;
		memcpy(&swFlowPatten->swPattern[offset],&ponStreamId,patternSizeMapping[FLOW_PHY_STREAMID]);
		offset+=patternSizeMapping[FLOW_PHY_STREAMID];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_DMAC) )
	{
		memcpy(&swFlowPatten->swPattern[offset],pFcIngressData->da,patternSizeMapping[FLOW_L2_DMAC]);
		offset+=patternSizeMapping[FLOW_L2_DMAC];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SMAC))
	{
		memcpy(&swFlowPatten->swPattern[offset],pFcIngressData->sa,patternSizeMapping[FLOW_L2_SMAC]);
		offset+=patternSizeMapping[FLOW_L2_SMAC];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_ETH))
	{
		memcpy(&swFlowPatten->swPattern[offset],&pPktHdr->ethtype,patternSizeMapping[FLOW_L2_ETH]);
		offset+=patternSizeMapping[FLOW_L2_ETH];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CVLAN))
	{
		if(pFcIngressData->ingressTagif & CVLAN_TAGIF)
		{
			ctag|=pFcIngressData->srcCVlanId;
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CPRI))
	{
		if(pFcIngressData->ingressTagif & CVLAN_TAGIF)
		{
			ctag|=(pFcIngressData->srcCVlanPri<<VLAN_PRIO_SHIFT);
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CDEI))
	{
		if(pFcIngressData->ingressTagif & CVLAN_TAGIF)
		{
			ctag|=(pFcIngressData->srcCVlanCfi<<VLAN_CFI_SHIFT);
		}
	}
	
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CVLANTAG))
	{
		if(pFcIngressData->ingressTagif & CVLAN_TAGIF)
		{
			swFlowPatten->bits.ctagif=1;
			memcpy(&swFlowPatten->swPattern[offset],&ctag,patternSizeMapping[FLOW_L2_CVLANTAG]);
		}
		offset+=patternSizeMapping[FLOW_L2_CVLANTAG];	
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SVLAN))
	{
		if(pFcIngressData->ingressTagif & SVLAN_TAGIF)
		{
			stag|=pFcIngressData->srcSVlanId;
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SPRI))
	{
		if(pFcIngressData->ingressTagif & SVLAN_TAGIF)
		{
			stag|= (pFcIngressData->srcSVlanPri<<VLAN_PRIO_SHIFT);
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SDEI))
	{
		if(pFcIngressData->ingressTagif & SVLAN_TAGIF)
		{
			stag|= (pFcIngressData->srcSVlanDei<<VLAN_CFI_SHIFT);
		}
	}	
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SVLANTAG))
	{
		if(pFcIngressData->ingressTagif & SVLAN_TAGIF)
		{
			swFlowPatten->bits.stagif=1;
			memcpy(&swFlowPatten->swPattern[offset],&stag,patternSizeMapping[FLOW_L2_SVLANTAG]);
		}
		offset+=patternSizeMapping[FLOW_L2_SVLANTAG];	
	}


	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_PPPOETAG))
	{
		if(pFcIngressData->ingressTagif & PPPOE_TAGIF)
			swFlowPatten->bits.pppoetagif=1;
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_PPPOESID))
	{
		if(pFcIngressData->ingressTagif & PPPOE_TAGIF)
		{
			uint16 pppoeSessionId=ntohs(pFcIngressData->sessionId);
			swFlowPatten->bits.pppoetagif=1;
			memcpy(&swFlowPatten->swPattern[offset],&pppoeSessionId,patternSizeMapping[FLOW_L2_PPPOESID]);
		}
		offset+=patternSizeMapping[FLOW_L2_PPPOESID];		
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_IPVER46))
	{
		if(pFcIngressData->ingressTagif & IPV6_TAGIF)
			swFlowPatten->bits.isIpv6=1;
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_DIP))
	{
		if(pFcIngressData->ingressTagif & IPV6_TAGIF)
		{
			swFlowPatten->bits.isIpv6=1;	
			memcpy(&swFlowPatten->swPattern[offset],&pFcIngressData->dstIp,patternSizeMapping[FLOW_L3_DIP]);
		}
		else if(pFcIngressData->ingressTagif & IPV4_TAGIF)
		{
			uint32 hostDaddr= pFcIngressData->dstIp;
			memcpy(&swFlowPatten->swPattern[offset],&hostDaddr,patternSizeMapping[FLOW_L3_DIP]);
		}
		else
		{
			TRACE("No IPHdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L3_DIP];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_SIP) )
	{
		if(pFcIngressData->ingressTagif & IPV6_TAGIF)
		{
			swFlowPatten->bits.isIpv6=1;	
			memcpy(&swFlowPatten->swPattern[offset],&pFcIngressData->srcIp,patternSizeMapping[FLOW_L3_SIP]);
		}
		else if(pFcIngressData->ingressTagif & IPV4_TAGIF)
		{
			uint32 hostSaddr= pFcIngressData->srcIp;
			memcpy(&swFlowPatten->swPattern[offset],&hostSaddr,patternSizeMapping[FLOW_L3_SIP]);
		}
		else
		{
			TRACE("No IPHdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L3_SIP];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_TOS))
	{
		if(pFcIngressData->ingressTagif & IPV6_TAGIF)
		{
			uint8 v6Tos= pFcIngressData->v6tos;
			swFlowPatten->bits.isIpv6=1;	
			memcpy(&swFlowPatten->swPattern[offset],&v6Tos,patternSizeMapping[FLOW_L3_TOS]);
		}
		else if(pFcIngressData->ingressTagif & IPV4_TAGIF)
		{
			uint8 v4Tos= pFcIngressData->v4tos;
			memcpy(&swFlowPatten->swPattern[offset],&v4Tos,patternSizeMapping[FLOW_L3_TOS]);
		}
		else
		{
			TRACE("No IPHdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L3_TOS];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L4_PROTO))
	{
		if((pFcIngressData->ingressTagif & IPV4_TAGIF) || (pFcIngressData->ingressTagif & IPV6_TAGIF))
		{
			memcpy(&swFlowPatten->swPattern[offset],&pPktHdr->l4protol,patternSizeMapping[FLOW_L4_PROTO]);
		}
		else
		{
			TRACE("No L4Hdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L4_PROTO];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L4_DPORT))
	{
		if(pFcIngressData->ingressTagif & UDP_TAGIF)
		{
			uint16 dport=pFcIngressData->dstPort;
			memcpy(&swFlowPatten->swPattern[offset],&dport,patternSizeMapping[FLOW_L4_DPORT]);
		}
		else if(pFcIngressData->ingressTagif & TCP_TAGIF)
		{
			uint16 dport=pFcIngressData->dstPort;
			memcpy(&swFlowPatten->swPattern[offset],&dport,patternSizeMapping[FLOW_L4_DPORT]);
		}
		else
		{
			TRACE("No L4HdrTCPUDP Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L4_DPORT];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L4_SPORT))
	{
		if(pFcIngressData->ingressTagif & UDP_TAGIF)
		{
			uint16 sport=pFcIngressData->srcPort;
			memcpy(&swFlowPatten->swPattern[offset],&sport,patternSizeMapping[FLOW_L4_SPORT]);
		}
		else if(pFcIngressData->ingressTagif & TCP_TAGIF)
		{
			uint16 sport=pFcIngressData->srcPort;
			memcpy(&swFlowPatten->swPattern[offset],&sport,patternSizeMapping[FLOW_L4_SPORT]);
		}
		else
		{
			TRACE("No L4HdrTCPUDP Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L4_SPORT];
	}
	TRACE("flowTye:%d Pattens GenDone",flowTye);
	return SUCCESS;

}



//ingress for shortcut 
__IRAM_FC_SHORTCUT
int32 rtk_fc_abstrSwFlowPatternGenByPktHdr(rtk_fc_pktHdr_t *pPktHdr,rtk_fc_abstrSwFlowPattern_entry_t *swFlowPatten,uint8 flowTye)
{
	int32 offset=0;
	uint16 ctag=0,stag=0;  //  (vpri<<VLAN_PRIO_SHIFT)|(vlan)

	memset(swFlowPatten,0,sizeof(rtk_fc_abstrSwFlowPattern_entry_t));

	if(ABSTR_SWFLOW_TYPE_SIZE <= flowTye)
		return FAIL;
	if(fc_db.abstrSwFlowType[flowTye].valid==0)
		return FAIL;


	swFlowPatten->bits.flowtype=flowTye;

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_PHY_LSPID) )
	{
		uint8 lspid=pPktHdr->ingressPort.macPortIdx;
		memcpy(&swFlowPatten->swPattern[offset],&lspid,patternSizeMapping[FLOW_PHY_LSPID]);

		offset+=patternSizeMapping[FLOW_PHY_LSPID];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_PHY_STREAMID) )
	{
		uint8 streamid=pPktHdr->ponstreamid;
		memcpy(&swFlowPatten->swPattern[offset],&streamid,patternSizeMapping[FLOW_PHY_STREAMID]);

		offset+=patternSizeMapping[FLOW_PHY_STREAMID];
	}


	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_DMAC) )
	{
		if(pPktHdr->eth)
		{
			memcpy(&swFlowPatten->swPattern[offset],pPktHdr->eth->h_dest,patternSizeMapping[FLOW_L2_DMAC]);
		}
		offset+=patternSizeMapping[FLOW_L2_DMAC];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SMAC))
	{
		if(pPktHdr->eth)
		{
			memcpy(&swFlowPatten->swPattern[offset],pPktHdr->eth->h_source,patternSizeMapping[FLOW_L2_SMAC]);
		}
		offset+=patternSizeMapping[FLOW_L2_SMAC];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_ETH) )
	{
		uint16 ethtype=pPktHdr->ethtype;
		memcpy(&swFlowPatten->swPattern[offset],&ethtype,patternSizeMapping[FLOW_L2_ETH]);

		offset+=patternSizeMapping[FLOW_L2_ETH];
	}


	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CVLAN))
	{
		if(pPktHdr->cvh)
		{
			ctag=pPktHdr->cvlanid;
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CPRI))
	{
		if(pPktHdr->cvh)
		{
			ctag|=(pPktHdr->cvlanpri<<VLAN_PRIO_SHIFT);
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CDEI))
	{
		if(pPktHdr->cvh)
		{
			ctag|=(pPktHdr->cvlancfi<<VLAN_CFI_SHIFT);
		}
	}	
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_CVLANTAG))
	{
		if(pPktHdr->cvh)
		{
			swFlowPatten->bits.ctagif=1;
			memcpy(&swFlowPatten->swPattern[offset],&ctag,patternSizeMapping[FLOW_L2_CVLANTAG]);
		}
		offset+=patternSizeMapping[FLOW_L2_CVLANTAG];
	}


	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SVLAN))
	{
		if(pPktHdr->svh)
		{
			stag=pPktHdr->svlanid;
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SPRI))
	{
		if(pPktHdr->svh)
		{
			stag|=(pPktHdr->svlanpri<<VLAN_PRIO_SHIFT);
		}
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SDEI))
	{
		if(pPktHdr->svh)
		{
			stag|=(pPktHdr->svlandei<<VLAN_CFI_SHIFT);
		}
	}	
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_SVLANTAG))
	{
		if(pPktHdr->svh)
		{
			swFlowPatten->bits.stagif=1;
			memcpy(&swFlowPatten->swPattern[offset],&stag,patternSizeMapping[FLOW_L2_SVLANTAG]);
		}
		offset+=patternSizeMapping[FLOW_L2_CVLANTAG];
	}


	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_PPPOETAG))
	{
		if(pPktHdr->ppph)
			swFlowPatten->bits.pppoetagif=1;
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L2_PPPOESID))
	{
		if(pPktHdr->ppph)
		{
			uint16 pppoeSessionId=ntohs(pPktHdr->ppph->sid);
			swFlowPatten->bits.pppoetagif=1;
			memcpy(&swFlowPatten->swPattern[offset],&pppoeSessionId,patternSizeMapping[FLOW_L2_PPPOESID]);
			offset+=patternSizeMapping[FLOW_L2_PPPOESID];		
		}
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_IPVER46))
	{
		if(pPktHdr->ip6h)
			swFlowPatten->bits.isIpv6=1;
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_DIP))
	{
		if(pPktHdr->ip6h)
		{
			swFlowPatten->bits.isIpv6=1;	
			memcpy(&swFlowPatten->swPattern[offset],&pPktHdr->ipv6Dip_hash,patternSizeMapping[FLOW_L3_DIP]);
		}
		else if(pPktHdr->iph)
		{
			uint32 hostDaddr= ntohl(pPktHdr->iph->daddr);
			memcpy(&swFlowPatten->swPattern[offset],&hostDaddr,patternSizeMapping[FLOW_L3_DIP]);
		}
		else
		{
			TRACE("No IPHdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L3_DIP];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_SIP) )
	{
		if(pPktHdr->ip6h)
		{
			swFlowPatten->bits.isIpv6=1;	
			memcpy(&swFlowPatten->swPattern[offset],&pPktHdr->ipv6Sip_hash,patternSizeMapping[FLOW_L3_SIP]);
		}
		else if(pPktHdr->iph)
		{
			uint32 hostSaddr= ntohl(pPktHdr->iph->saddr);
			memcpy(&swFlowPatten->swPattern[offset],&hostSaddr,patternSizeMapping[FLOW_L3_SIP]);
		}
		else
		{
			TRACE("No IPHdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L3_SIP];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L3_TOS))
	{
		if(pPktHdr->ip6h)
		{
			uint8 v6Tos= ((pPktHdr->ip6h->priority<<4)&0xf0)|((pPktHdr->ip6h->flow_lbl[0]>>4)&0xf);
			swFlowPatten->bits.isIpv6=1;	
			memcpy(&swFlowPatten->swPattern[offset],&v6Tos,patternSizeMapping[FLOW_L3_TOS]);
		}
		else if(pPktHdr->iph)
		{
			uint8 v4Tos= pPktHdr->iph->tos;
			memcpy(&swFlowPatten->swPattern[offset],&v4Tos,patternSizeMapping[FLOW_L3_TOS]);
		}
		else
		{
			TRACE("No IPHdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L3_TOS];
	}
	
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L4_PROTO))
	{
		if((pPktHdr->udph) || (pPktHdr->tcph))
		{
			memcpy(&swFlowPatten->swPattern[offset],&pPktHdr->l4protol,patternSizeMapping[FLOW_L4_PROTO]);
		}
		else
		{
			TRACE("No L4Hdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L4_PROTO];
	}

	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L4_DPORT))
	{
		if(pPktHdr->udph)
		{
			uint16 dport=ntohs(pPktHdr->udph->dest);
			memcpy(&swFlowPatten->swPattern[offset],&dport,patternSizeMapping[FLOW_L4_DPORT]);
		}
		else if(pPktHdr->tcph)
		{
			uint16 dport=ntohs(pPktHdr->tcph->dest);
			memcpy(&swFlowPatten->swPattern[offset],&dport,patternSizeMapping[FLOW_L4_DPORT]);
		}
		else
		{
			TRACE("No L4Hdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L4_DPORT];
	}
	if(fc_db.abstrSwFlowType[flowTye].patternFlagMsk & TYPETOMSK(FLOW_L4_SPORT))
	{
		if(pPktHdr->udph)
		{
			uint16 sport=ntohs(pPktHdr->udph->source);
			memcpy(&swFlowPatten->swPattern[offset],&sport,patternSizeMapping[FLOW_L4_SPORT]);
		}
		else if(pPktHdr->tcph)
		{
			uint16 sport=ntohs(pPktHdr->tcph->source);
			memcpy(&swFlowPatten->swPattern[offset],&sport,patternSizeMapping[FLOW_L4_SPORT]);
		}
		else
		{
			TRACE("No L4Hdr Gen Fail");
			return FAIL;
		}
		offset+=patternSizeMapping[FLOW_L4_SPORT];
	}
	TRACE("flowTye:%d Pattens GenDone",flowTye);

	return SUCCESS;

}

int32 rtk_fc_abstrSwFlowPatternSet(void)
{

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	rtk_fc_abstrSwFlowAddTemplateType(ABSTR_TEMPLATE_TYPE_L4,ABSTR_TEMPLATE_PRI_L4);
	rtk_fc_abstrSwFlowAddTemplateType(ABSTR_TEMPLATE_TYPE_L3,ABSTR_TEMPLATE_PRI_L3);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	rtk_fc_abstrSwFlowAddTemplateType(ABSTR_TEMPLATE_TYPE_L3,ABSTR_TEMPLATE_PRI_L3);
#endif
	return SUCCESS;

}

rtk_fc_abstrSwFlowList_entry_t* rtk_fc_abstrSwFlowAlloc(rtk_fc_abstrSwFlowPattern_entry_t *swFlowKey)// rtk_fc_abstrSwFlowList_entry_t fc_db.flowTbl
{
	rtk_fc_abstrSwFlowList_entry_t *pSwFlow=NULL;
	pSwFlow = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_abstrSwFlowList_entry_t), GFP_ATOMIC);
	if(pSwFlow)
	{
		memcpy(&pSwFlow->swFlowKey,swFlowKey,sizeof(rtk_fc_abstrSwFlowPattern_entry_t));
		INIT_LIST_HEAD(&pSwFlow->swFlowActionHdr);
	}
	return pSwFlow;
}


int rtk_fc_abstrSwFlowFree(rtk_fc_abstrSwFlowList_entry_t *pSwFlowList)
{

	rtk_fc_abstrSwFlowActionList_entry_t *pTmpAct,*pAct;

	if(pSwFlowList)
	{
		list_for_each_entry_safe(pAct,pTmpAct,&pSwFlowList->swFlowActionHdr,swFlowActionList)
		{
			rtk_fc_abstrSwFlowActionFree(pAct);
		}
		RTK_FC_HELPER_FC_KFREE(pSwFlowList,sizeof(rtk_fc_abstrSwFlowList_entry_t));
	}
	return SUCCESS;
}


rtk_fc_abstrSwFlowActionList_entry_t* rtk_fc_abstrSwFlowActionAlloc(rtk_fc_abstrSwFlowAction_entry_t *swFlowAct)
{
	rtk_fc_abstrSwFlowActionList_entry_t *pSwFlowAct=NULL;
	pSwFlowAct = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_abstrSwFlowActionList_entry_t), GFP_ATOMIC);
	if(pSwFlowAct)
	{
		memcpy(&pSwFlowAct->swFlowAction,swFlowAct,sizeof(rtk_fc_abstrSwFlowAction_entry_t));
		INIT_LIST_HEAD(&pSwFlowAct->swFlowActionList);
		INIT_LIST_HEAD(&pSwFlowAct->ldpidListHdr);
	}
	return pSwFlowAct;
}


int rtk_fc_abstrSwFlowActionFree(rtk_fc_abstrSwFlowActionList_entry_t *pSwFlowAct)
{
	rtk_fc_abstrSwFlowLdpid_entry_t *pLdpid,*pTmpLdpid;
	if(pSwFlowAct)
	{
		list_for_each_entry_safe(pLdpid,pTmpLdpid,&pSwFlowAct->ldpidListHdr,ldpidList)
		{
			rtk_fc_abstrSwFlowLdpidFree(pLdpid);
		}
		list_del(&pSwFlowAct->swFlowActionList);
		RTK_FC_HELPER_FC_KFREE(pSwFlowAct,sizeof(rtk_fc_abstrSwFlowActionList_entry_t));
	}
	return SUCCESS;
}


rtk_fc_abstrSwFlowLdpid_entry_t* rtk_fc_abstrSwFlowLdpidAlloc(void)
{
	rtk_fc_abstrSwFlowLdpid_entry_t *pSwFlowLdpid=NULL;
	pSwFlowLdpid = RTK_FC_HELPER_FC_KMALLOC(sizeof(rtk_fc_abstrSwFlowLdpid_entry_t),GFP_ATOMIC);
	if(pSwFlowLdpid)
	{
		INIT_LIST_HEAD(&pSwFlowLdpid->ldpidList);
	}
	return pSwFlowLdpid;
}

int rtk_fc_abstrSwFlowLdpidFree(rtk_fc_abstrSwFlowLdpid_entry_t* pLdpid)
{
	if(pLdpid)
	{	
		list_del(&pLdpid->ldpidList);
		RTK_FC_HELPER_FC_KFREE(pLdpid,sizeof(rtk_fc_abstrSwFlowLdpid_entry_t));
	}
	return SUCCESS;
}



static int rtk_fc_ipFrag_hashFunc(rtk_fc_ipFrag_info_t *frag_info)
{
	unsigned int h;
	int max_hash_size = RTK_FC_GET_IPFRAG_MAX_HASH_SIZE();
	
	if (unlikely(!frag_info || max_hash_size <= 0))
		return FAIL;

	h = frag_info->src_ip ^ frag_info->dst_ip;
	h ^= (h >> 16) ^ frag_info->frag_id;
	h ^= (h >> 8) ^ frag_info->protocol;
	
	return (h & (max_hash_size - 1));
}

rtk_fc_ret_t rtk_fc_ipFrag_cache_free(rtk_fc_ipFrag_linkList_t *ipFragList)
{
	rtk_fc_ipFrag_info_t *pfrag_info;

	if (unlikely(!ipFragList))
		return RTK_FC_RET_ERR_NULL_POINTER;

	ipFragList->valid = 0;
	ipFragList->hash_idx_valid = 0U;
	ipFragList->src_port = 0;
	ipFragList->dst_port = 0;
	ipFragList->rcv_data_len = 0U;
	ipFragList->total_data_len = 0U;
	ipFragList->tmp_data_len = 0U;
	ipFragList->hash_idx = 0U;

	pfrag_info = &ipFragList->frag_info;
	pfrag_info->src_ip = 0U;
	pfrag_info->dst_ip = 0U;
	pfrag_info->frag_id = 0U;
	pfrag_info->protocol = 0U;

	list_del_init(&ipFragList->entry);
	list_add_tail(&ipFragList->entry, &fc_db.ipFrag_freeListHead);
	
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_ipFrag_cache_timeout(unsigned long task_priv)
{
	rtk_fc_ipFrag_linkList_t *ipFragList;
	rtk_fc_ret_t ret;

	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	ipFragList = (rtk_fc_ipFrag_linkList_t *)task_priv;
	
	if (unlikely(!ipFragList))
		return RTK_FC_RET_ERR_NULL_POINTER;

	FRAGMENT("valid: %d", ipFragList->valid);
	if (!ipFragList->valid) 
		return RTK_FC_RET_ERR_ENTRY_NOT_FOUND;

	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH_IRQ_PROTECT();
	ret = rtk_fc_ipFrag_cache_free(ipFragList);
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH_IRQ_PROTECT();

	return ret;
}

rtk_fc_ret_t rtk_fc_ipFrag_cache_add(rtk_fc_pktHdr_t *pktHdr)
{
	int hash;
	int cache_timeout_msec = RTK_FC_GET_IPFRAG_CACHE_TIMEOUT_MSEC();
	unsigned long int msec2jiffies = 0;
	rtk_fc_ipFrag_linkList_t *ipFragList = NULL;
	rtk_fc_ipFrag_info_t frag_info;
	
	if (unlikely(!pktHdr || !pktHdr->iph || cache_timeout_msec <= 0))
		return RTK_FC_RET_ERR_NULL_POINTER;

	memset(&frag_info, 0, sizeof(rtk_fc_ipFrag_info_t));
	frag_info.src_ip	= ntohl(pktHdr->iph->saddr);
	frag_info.dst_ip	= ntohl(pktHdr->iph->daddr);
	frag_info.frag_id	= ntohs(pktHdr->iph->id);
	frag_info.protocol	= pktHdr->iph->protocol;
		
	if ((hash = rtk_fc_ipFrag_hashFunc(&frag_info)) == FAIL)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if (!list_empty(&fc_db.ipFrag_freeListHead)) {
		list_for_each_entry(ipFragList, &fc_db.ipFrag_freeListHead, entry) {
			break;
		}

		ipFragList->valid 				= 1;
		memcpy(&ipFragList->frag_info, &frag_info, sizeof(rtk_fc_ipFrag_info_t));

		pktHdr->cacheIpFragInfo.hash_idx_valid = 1U;
		pktHdr->cacheIpFragInfo.hash_idx = hash;
		memcpy(&pktHdr->cacheIpFragInfo.frag_info, &frag_info, sizeof(rtk_fc_ipFrag_info_t));

		if (pktHdr->tcph) {
			ipFragList->src_port = htons(pktHdr->tcph->source);
			ipFragList->dst_port = htons(pktHdr->tcph->dest);
			FRAGMENT("add ip frag cache with tcp header! id=0x%x", ipFragList->frag_info.frag_id);
		}
		else if (pktHdr->udph) {
			ipFragList->src_port = htons(pktHdr->udph->source);
			ipFragList->dst_port = htons(pktHdr->udph->dest);

			ipFragList->total_data_len = ntohs(pktHdr->udph->len) - sizeof(struct udphdr);
			ipFragList->tmp_data_len = (ntohs(pktHdr->iph->tot_len) - (pktHdr->iph->ihl << 2) - sizeof(struct udphdr));

			FRAGMENT("[udp] add ip frag cache! iph id=0x%x, tmp_data_len=%d, total_data_len=%d (pkthdr ipFragFlag=0x%x hash_idx=%d)", 
				ipFragList->frag_info.frag_id, ipFragList->tmp_data_len, ipFragList->total_data_len, pktHdr->ipFragFlag, pktHdr->cacheIpFragInfo.hash_idx);
		}
		else {
			FRAGMENT("add ip frag cache with ip header only! id=0x%x", ipFragList->frag_info.frag_id);
		}
		
		list_del_init(&ipFragList->entry);
		list_add_tail(&ipFragList->entry, &fc_db.ipFrag_hashListHead[hash]);
		
		// start timer
		RTK_FC_HELPER_MSECS_TO_JIFFIES(cache_timeout_msec, &msec2jiffies);
		if(RTK_FC_HELPER_TIMER_PENDING(ipFragList->timer))
			RTK_FC_HELPER_DEL_TIMER(ipFragList->timer);
		
		RTK_FC_HELPER_MOD_TIMER(ipFragList->timer, jiffies+msec2jiffies);

		atomic_inc(&fc_db.statistic.perPortCnt_ipFrag_cached[pktHdr->ingressPort.macPortIdx]);
	}
	else {
		atomic_inc(&fc_db.statistic.perPortCnt_ipFrag_cache_tbl_full[pktHdr->ingressPort.macPortIdx]);
	}
	
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_ipFrag_cache_del(rtk_fc_ipFrag_linkList_t *ipFragList)
{
	if (unlikely(!ipFragList))
		return RTK_FC_RET_ERR_NULL_POINTER;

	if(RTK_FC_HELPER_TIMER_PENDING(ipFragList->timer))
		RTK_FC_HELPER_DEL_TIMER(ipFragList->timer);

	rtk_fc_ipFrag_cache_free(ipFragList);

	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_ipFrag_cache_find(rtk_fc_pktHdr_t *pktHdr)
{
	int hash;
	rtk_fc_ipFrag_linkList_t *ipFragList = NULL;
	rtk_fc_ipFrag_info_t frag_info;
	
	if (unlikely(!pktHdr || !pktHdr->iph))
		return RTK_FC_RET_ERR_NULL_POINTER;

	memset(&frag_info, 0, sizeof(rtk_fc_ipFrag_info_t));
	frag_info.src_ip	= ntohl(pktHdr->iph->saddr);
	frag_info.dst_ip	= ntohl(pktHdr->iph->daddr);
	frag_info.frag_id	= ntohs(pktHdr->iph->id);
	frag_info.protocol	= pktHdr->iph->protocol;

	if ((hash = rtk_fc_ipFrag_hashFunc(&frag_info)) == FAIL)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	memset(&pktHdr->cacheIpFragInfo, 0, sizeof(rtk_fc_ipFrag_linkList_t));
	list_for_each_entry(ipFragList, &fc_db.ipFrag_hashListHead[hash], entry) {
		if (!memcmp(&ipFragList->frag_info, &frag_info, sizeof(rtk_fc_ipFrag_info_t))) {
			// store fragInfo into pktHdr
			memcpy(&pktHdr->cacheIpFragInfo, ipFragList, sizeof(rtk_fc_ipFrag_linkList_t));

			if ((pktHdr->ipFragFlag & RTK_FC_IP_FIRST_FRAG) && pktHdr->udph) {
				ipFragList->total_data_len = ntohs(pktHdr->udph->len) - sizeof(struct udphdr);
			}

			pktHdr->cacheIpFragInfo.hash_idx_valid = 1U;
			pktHdr->cacheIpFragInfo.hash_idx = hash;

			if (pktHdr->udph)
				ipFragList->tmp_data_len = (ntohs(pktHdr->iph->tot_len) - (pktHdr->iph->ihl << 2) - sizeof(struct udphdr));
			else
				ipFragList->tmp_data_len = (ntohs(pktHdr->iph->tot_len) - (pktHdr->iph->ihl << 2));

			FRAGMENT("hit ip frag cache! iph id=0x%x, tmp_data_len=%d, total_data_len=%d (pkthdr ipFragFlag=0x%x hash_idx=%d)", 
				ipFragList->frag_info.frag_id, ipFragList->tmp_data_len, ipFragList->total_data_len, pktHdr->ipFragFlag, pktHdr->cacheIpFragInfo.hash_idx);

			atomic_inc(&fc_db.statistic.perPortCnt_hit_ipFrag_cache[pktHdr->ingressPort.macPortIdx]);
			return RTK_FC_RET_OK;
		}
	}

	return RTK_FC_RET_ERR_ENTRY_NOT_FOUND;
}

rtk_fc_ret_t rtk_fc_negtive_ipFrag_cache_free(rtk_fc_negativeIpFrag_linkList_t *negativeIpFragList)
{
	if (unlikely(!negativeIpFragList))
		return RTK_FC_RET_ERR_NULL_POINTER;

	negativeIpFragList->valid = 0;
	memset(&negativeIpFragList->frag_info, 0, sizeof(rtk_fc_ipFrag_info_t));
	
	list_del_init(&negativeIpFragList->entry);
	list_add_tail(&negativeIpFragList->entry, &fc_db.negativeIpFrag_freeListHead);
	
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_negtive_ipFrag_cache_timeout(unsigned long task_priv)
{
	rtk_fc_negativeIpFrag_linkList_t *negativeIpFragList;
	rtk_fc_ret_t ret;

	task_priv = RTK_FC_HELPER_TIMER_DATA_GET(task_priv);
	negativeIpFragList = (rtk_fc_negativeIpFrag_linkList_t *)task_priv;
	
	if (unlikely(!negativeIpFragList))
		return RTK_FC_RET_ERR_NULL_POINTER;

	FRAGMENT("valid: %d", negativeIpFragList->valid);
	if (!negativeIpFragList->valid) 
		return RTK_FC_RET_ERR_ENTRY_NOT_FOUND;

	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH_IRQ_PROTECT();	
	ret = rtk_fc_negtive_ipFrag_cache_free(negativeIpFragList);
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH_IRQ_PROTECT();

	return ret;
}

rtk_fc_ret_t rtk_fc_negative_ipFrag_cache_add(rtk_fc_pktHdr_t *pktHdr)
{
	int hash;
	int cache_timeout_msec = RTK_FC_GET_IPFRAG_CACHE_TIMEOUT_MSEC();
	unsigned long int msec2jiffies = 0;
	rtk_fc_negativeIpFrag_linkList_t *negativeIpFragList = NULL;
	rtk_fc_ipFrag_info_t frag_info;
	
	if (unlikely(!pktHdr || !pktHdr->iph || cache_timeout_msec <= 0))
		return RTK_FC_RET_ERR_NULL_POINTER;

	memset(&frag_info, 0, sizeof(rtk_fc_ipFrag_info_t));
	frag_info.src_ip	= ntohl(pktHdr->iph->saddr);
	frag_info.dst_ip	= ntohl(pktHdr->iph->daddr);
	frag_info.frag_id	= ntohs(pktHdr->iph->id);
	frag_info.protocol	= pktHdr->iph->protocol;
	
	if ((hash = rtk_fc_ipFrag_hashFunc(&frag_info)) == FAIL)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	if (!list_empty(&fc_db.negativeIpFrag_freeListHead)) {
		list_for_each_entry(negativeIpFragList, &fc_db.negativeIpFrag_freeListHead, entry) {
			break;
		}
		
		negativeIpFragList->valid = 1;
		memcpy(&negativeIpFragList->frag_info, &frag_info, sizeof(rtk_fc_ipFrag_info_t));
		
		FRAGMENT("add negative ip frag cache! id=0x%x", negativeIpFragList->frag_info.frag_id);
		list_del_init(&negativeIpFragList->entry);
		list_add_tail(&negativeIpFragList->entry, &fc_db.negativeIpFrag_hashListHead[hash]);

		// start timer
		RTK_FC_HELPER_MSECS_TO_JIFFIES(cache_timeout_msec, &msec2jiffies);
		if(RTK_FC_HELPER_TIMER_PENDING(negativeIpFragList->timer))
			RTK_FC_HELPER_DEL_TIMER(negativeIpFragList->timer);

		RTK_FC_HELPER_MOD_TIMER(negativeIpFragList->timer, jiffies+msec2jiffies);

		atomic_inc(&fc_db.statistic.perPortCnt_negative_ipFrag_cached[pktHdr->ingressPort.macPortIdx]);
	}
	else {
		atomic_inc(&fc_db.statistic.perPortCnt_negative_ipFrag_cache_tbl_full[pktHdr->ingressPort.macPortIdx]);
	}
	
	return RTK_FC_RET_OK;
}

rtk_fc_ret_t rtk_fc_negative_ipFrag_cache_find(rtk_fc_pktHdr_t *pktHdr)
{
	int hash;
	rtk_fc_negativeIpFrag_linkList_t *negativeIpFragList = NULL;
	rtk_fc_ipFrag_info_t frag_info;
	
	if (unlikely(!pktHdr || !pktHdr->iph))
		return RTK_FC_RET_ERR_NULL_POINTER;

	memset(&frag_info, 0, sizeof(rtk_fc_ipFrag_info_t));
	frag_info.src_ip	= ntohl(pktHdr->iph->saddr);
	frag_info.dst_ip	= ntohl(pktHdr->iph->daddr);
	frag_info.frag_id	= ntohs(pktHdr->iph->id);
	frag_info.protocol	= pktHdr->iph->protocol;
	
	if ((hash = rtk_fc_ipFrag_hashFunc(&frag_info)) == FAIL)
		return RTK_FC_RET_ERR_INVALID_PARAM;

	list_for_each_entry(negativeIpFragList, &fc_db.negativeIpFrag_hashListHead[hash], entry) {
		if (!memcmp(&negativeIpFragList->frag_info, &frag_info, sizeof(rtk_fc_ipFrag_info_t))) {
			atomic_inc(&fc_db.statistic.perPortCnt_hit_negative_ipFrag_cache[pktHdr->ingressPort.macPortIdx]);
			return RTK_FC_RET_OK;
		}
	}

	return RTK_FC_RET_ERR_ENTRY_NOT_FOUND;
}

rtk_fc_ret_t rtk_fc_ipfrag_ingress_del_cache(rtk_fc_pktHdr_t *pktHdr)
{
	int hash;
	uint16 frag_id;
	rtk_fc_ipFrag_linkList_t *ipFragList = NULL;

	if (unlikely(!pktHdr))
		return RTK_FC_RET_ERR_NULL_POINTER;

	hash = pktHdr->cacheIpFragInfo.hash_idx;
	frag_id = pktHdr->cacheIpFragInfo.frag_info.frag_id;

	FRAGMENT("hash_idx=%d, ipFragFlag=0x%x, iph id=0x%x", hash, pktHdr->ipFragFlag, frag_id);

	list_for_each_entry(ipFragList, &fc_db.ipFrag_hashListHead[hash], entry) {
		if (!memcmp(&ipFragList->frag_info, &(pktHdr->cacheIpFragInfo.frag_info), sizeof(rtk_fc_ipFrag_info_t))) {
			FRAGMENT("update ip frag cache with iph id=0x%x, ipFragFlag=0x%x, rcv_offset=%d, tmp_offset=%d, total_data_len=%d",
				ipFragList->frag_info.frag_id, pktHdr->ipFragFlag, ipFragList->rcv_data_len, ipFragList->tmp_data_len, ipFragList->total_data_len);

			ipFragList->rcv_data_len += ipFragList->tmp_data_len;
			ipFragList->tmp_data_len = 0U;

			if (ipFragList->total_data_len && ipFragList->total_data_len == ipFragList->rcv_data_len) {
				FRAGMENT("del frag cache with iph id=0x%x", frag_id);
				rtk_fc_ipFrag_cache_del(ipFragList);
			}

			return RTK_FC_RET_OK;
		}
	}

	return RTK_FC_RET_ERR_ENTRY_NOT_FOUND;
}

rtk_fc_ipFrag_linkList_t *rtk_fc_ipfrag_shortcut_find_cache(rtk_fc_pktHdr_t *pktHdr)
{
	int hash;
	uint16 frag_id;
	rtk_fc_ipFrag_linkList_t *ipFragList = NULL;

	if (unlikely(!pktHdr))
		return NULL;

	hash = pktHdr->cacheIpFragInfo.hash_idx;
	frag_id = pktHdr->cacheIpFragInfo.frag_info.frag_id;

	FRAGMENT("hash_idx=%d, ipFragFlag=0x%x, iph id=0x%x", hash, pktHdr->ipFragFlag, frag_id);

	list_for_each_entry(ipFragList, &fc_db.ipFrag_hashListHead[hash], entry) {
		if (!memcmp(&ipFragList->frag_info, &(pktHdr->cacheIpFragInfo.frag_info), sizeof(rtk_fc_ipFrag_info_t))) {
			return ipFragList;
		}
	}

	return NULL;
}

int _rtk_fc_skb_cow_head_and_pktHdr_update(struct sk_buff *skb, unsigned int headroom, struct rt_skbuff *rtskb, rtk_fc_pktHdr_t *pPktHdr)
{
	uint8* pOriSkbData = (uint8*)(skb->data);
	int ret = RTK_FC_HOOK_PS_SKB_SKB_COW_HEAD(skb, headroom);
	ptrdiff_t addrPtrDiff;

	if((ret >= 0) && (pOriSkbData != skb->data))
	{
		// skb had been re-allocated, update the pointers
		if(pPktHdr == NULL || rtskb == NULL)
		{
			WARNING("pPktHdr or rtskb is NULL!\n");
			return FAIL;
		}
		RTK_FC_HOOK_CONVERTER_SKB(skb, rtskb);
		if(pPktHdr->eth != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->eth) - pOriSkbData);
			pPktHdr->eth = (struct ethhdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->svh != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->svh) - pOriSkbData);
			pPktHdr->svh = (struct vlan_hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->cvh != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->cvh) - pOriSkbData);
			pPktHdr->cvh = (struct vlan_hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->ppph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->ppph) - pOriSkbData);
			pPktHdr->ppph = (struct pppoe_hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->iph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->iph) - pOriSkbData);
			pPktHdr->iph = (struct iphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->ip6h != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->ip6h) - pOriSkbData);
			pPktHdr->ip6h = (struct ipv6hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->tcph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->tcph) - pOriSkbData);
			pPktHdr->tcph = (struct tcphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->udph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->udph) - pOriSkbData);
			pPktHdr->udph = (struct udphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->igmph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->igmph) - pOriSkbData);
			pPktHdr->igmph = (struct igmphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->icmp6h != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->icmp6h) - pOriSkbData);
			pPktHdr->icmp6h = (struct icmp6hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->arph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->arph) - pOriSkbData);
			pPktHdr->arph = (struct arphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->esph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->esph) - pOriSkbData);
			pPktHdr->esph = (struct ip_esp_hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->outer_iph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->outer_iph) - pOriSkbData);
			pPktHdr->outer_iph = (struct iphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->outer_udph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->outer_udph) - pOriSkbData);
			pPktHdr->outer_udph = (struct udphdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->greh != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->greh) - pOriSkbData);
			pPktHdr->greh = (struct gre_base_hdr *)(skb->data + addrPtrDiff);
		}
		if(pPktHdr->icmph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->icmph) - pOriSkbData);
			pPktHdr->icmph = (struct icmphdr *)(skb->data + addrPtrDiff);
		}

		if((pPktHdr->tunnelInfo.tunnelTag & GRESEQ_TAGIF) && (pPktHdr->tunnelInfo.pptp.pGRESeq != NULL))
		{
			addrPtrDiff = ((uint8*)(pPktHdr->tunnelInfo.pptp.pGRESeq) - pOriSkbData);
			pPktHdr->tunnelInfo.pptp.pGRESeq = (uint32 *)(skb->data + addrPtrDiff);
		}

		if((pPktHdr->tunnelInfo.tunnelTag & GREACK_TAGIF) && (pPktHdr->tunnelInfo.pptp.pGREAck != NULL))
		{
			addrPtrDiff = ((uint8*)(pPktHdr->tunnelInfo.pptp.pGREAck) - pOriSkbData);
			pPktHdr->tunnelInfo.pptp.pGREAck = (uint32 *)(skb->data + addrPtrDiff);
		}

		if((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_PPTP) && (pPktHdr->tunnelInfo.pptp.pCallId != NULL))
		{
			addrPtrDiff = ((uint8*)(pPktHdr->tunnelInfo.pptp.pCallId) - pOriSkbData);
			pPktHdr->tunnelInfo.pptp.pCallId = (u8 *)(skb->data + addrPtrDiff);
		}

		if((pPktHdr->dualHdrType == RTK_FC_DUALTYPE_VXLAN) && (pPktHdr->vxlan_info.vxlanHdr != NULL))
		{
			addrPtrDiff = ((uint8*)(pPktHdr->vxlan_info.vxlanHdr) - pOriSkbData);
			pPktHdr->vxlan_info.vxlanHdr = (rtk_fc_vxlanhdr_t *)(skb->data + addrPtrDiff);
		}

		if(pPktHdr->outer_eth != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->outer_eth) - pOriSkbData);
			pPktHdr->outer_eth = (struct ethhdr *)(skb->data + addrPtrDiff);
		}

		if(pPktHdr->outer_svh != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->outer_svh) - pOriSkbData);
			pPktHdr->outer_svh = (struct vlan_hdr *)(skb->data + addrPtrDiff);
		}

		if(pPktHdr->outer_cvh != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->outer_cvh) - pOriSkbData);
			pPktHdr->outer_cvh = (struct vlan_hdr *)(skb->data + addrPtrDiff);
		}

		if(pPktHdr->outer_ppph != NULL)
		{
			addrPtrDiff = ((uint8*)(pPktHdr->outer_ppph) - pOriSkbData);
			pPktHdr->outer_ppph = (struct pppoe_hdr *)(skb->data + addrPtrDiff);
		}
	}
	return ret;
}


