		/*
 * Copyright (C) 2017 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
*/


#include "rtk_fc_acl.h"
#include "rtk_fc_internal.h"
#include "rtk_fc_callback.h"
#include "rtk_fc_debug.h"
#include "rtk_fc_multicast.h"
#include "rtk_fc_mappingAPI.h"
#include "rtk_fc_external.h"

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#include "aal_l3_specpkt.h"
#include "aal_common.h"
#endif


#include <rtk/acl.h>
#include <rtk/l2.h>

#include <net/mld.h>
#include <uapi/linux/igmp.h>
#include <linux/if_bridge.h>
#include <br_private.h>


#define TOOL

#if  defined(CONFIG_RTK_L34_G3_PLATFORM)
int32 rtk_fc_l3fe_specialPktToCPU(aal_l3_specpkt_type_t l3_pkt_type,int spid)
{
    aal_l3_specpkt_ctrl_t       l3_ctrl;
    aal_l3_specpkt_ctrl_mask_t  l3_ctrl_mask;
    aal_l3fe_lpb_tbl_cfg_t      lpb_tbl_cfg;
    ca_uint8_t     lpb_profile = 0;
    L3FE_STG0_CTRL_t stg0_ctrl;
    l3_stg0_ldpid_map_t stg0_ldpid_map;
	int ret;
	int forward_to_cpu=true;

	/* get lpb_idx_mode for correct source of lpb_profile */

	/* get lpb_idx_mode for correct source of lpb_profile */
	if ((ret = aal_l3fe_stg0_ctrl_get(G3_DEF_DEVID, &stg0_ctrl)) != AAL_E_OK) {
		printk("%s: Fail to get STG0 ctrl. (ret=%d)\n", __func__, ret);
		return ret;
	}


	if (stg0_ctrl.bf.lpb_idx_mode == 0)
	{
		/* get lpb_profile from L3FE_STG0_LDPID_MAP */
		if ((ret = aal_l3_stg0_ldpid_map_get(G3_DEF_DEVID, &stg0_ldpid_map)) != CA_E_OK) {
			printk("%s: Fail to get STG0 LDPID map. (ret=%d)\n", __func__, ret);
			return ret;
		}
		if (spid == stg0_ldpid_map.rule_0)
			lpb_profile = 0;
		else if (spid == stg0_ldpid_map.rule_1)
			lpb_profile = 1;
		else if (spid == stg0_ldpid_map.rule_2)
			lpb_profile = 2;
		else
			lpb_profile = 3;

	}
	else 
	{
		/* get lpb_profile from L3FE_STG0_LPB_IDX_TBL */
		ret = aal_l3fe_lpb_idx_tbl_get(G3_DEF_DEVID, spid, &lpb_profile);
		if (CA_E_OK != ret) {
			printk("Invoke aal_l3fe_lpb_idx_tbl_get return %#x.\n", ret);
			return ret;
		}
	}

	l3_ctrl_mask.s.ldpid   = 1;
	//l3_ctrl_mask.s.cos	   = 0;
	//l3_ctrl_mask.s.pol_en_sel = 0;
	//l3_ctrl_mask.s.pol_id  = 0;
	l3_ctrl_mask.s.spcl_en = 1;

	memset(&l3_ctrl, 0, sizeof(aal_l3_specpkt_ctrl_t));
	l3_ctrl.ldpid = RTK_FC_MAC_PORT_CPU;


    if (forward_to_cpu)
        l3_ctrl.spcl_en = 1;

    if (AAL_L3_SPECPKT_TYPE_L2_PTP == l3_pkt_type || AAL_L3_SPECPKT_TYPE_L4_PTP == l3_pkt_type)
	{
        l3_ctrl_mask.s.keep_ts = 1;
        l3_ctrl.keep_ts = 1;
    }

    memset(&lpb_tbl_cfg, 0, sizeof(lpb_tbl_cfg));
    ret = aal_l3_stg0_lpb_tbl_get(G3_DEF_DEVID, lpb_profile, &lpb_tbl_cfg);
    if (CA_E_OK != ret) 
	{
        printk("Invoke aal_l3_stg0_lpb_tbl_get return %#x.\n", ret);
        return ret;
    }
    ret = aal_l3_specpkt_ctrl_set(G3_DEF_DEVID, lpb_tbl_cfg.spcl_pkt_sel,
        l3_pkt_type, l3_ctrl_mask, &l3_ctrl);


	return SUCCESS;

}

#endif

int _rtk_fc_igmp_mld_module_init(void)
{
	/* Mc flow pool*/
	rtk_fc_igmp_mcExtraFlowIdxTbl_flashInit();

	fc_db.igmpDummyPktDetectorTimer.igmpTimer = RTK_FC_HELPER_MGR_TIMER_LIST_KMALLOC();
	fc_db.igmpDummyPktDetectorTimer.nextTimerPeriod = RTK_FC_IGMP_DUMYPKT_TICK_MSECONDMS;

	/*HW behavior*/
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_MAC_AND_VID_FID), SUCCESS);
	ASSERT_EQ(rtk_l2_ipmcVlanMode_set(LOOKUP_VLAN_BY_IVL_SVL), SUCCESS);

	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_ICMP6MC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_DHCP6MC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_RSVIPMC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_RSVIP6MC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF01,1),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF02,1),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF05,1),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF0E,1),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_SOILCITED_NOTE,1),RT_ERR_RG_OK);

	assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_FC_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP, NULL));

	rtk_l2_lookupMissAction_set(DLF_TYPE_IPMC, ACTION_DROP);
	rtk_l2_lookupMissAction_set(DLF_TYPE_IP6MC,ACTION_DROP);
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	rtk_l2_lookupMissAction_set(DLF_TYPE_IPMC, ACTION_TRAP2CPU);

#if defined(CONFIG_FC_RTL8277C_SERIES)
	rtk_8277c_flow_default_action_update(RTK_8277C_FLOW_PROFILE_FLOW_MC,RTK_8277C_FLOW_DEFACT_TYPE_DROP);
#else
	aal_default_action_set(G3_DEF_DEVID, RG_CA_FLOW_MC, FALSE);
#endif

	rtk_fc_l3fe_specialPktToCPU(AAL_L3_SPECPKT_TYPE_RIP,AAL_LPORT_L3_LAN);
	rtk_fc_l3fe_specialPktToCPU(AAL_L3_SPECPKT_TYPE_RIP,AAL_LPORT_L3_WAN);
	rtk_fc_l3fe_specialPktToCPU(AAL_L3_SPECPKT_TYPE_SSDP,AAL_LPORT_L3_LAN);
	rtk_fc_l3fe_specialPktToCPU(AAL_L3_SPECPKT_TYPE_SSDP,AAL_LPORT_L3_WAN);
	//DHCPv6, ICMPv6, IPv6 NDP, IPv6 MLD will trap by reserve acl	
	#endif

#if defined(CONFIG_FC_RTL8198F_SERIES)
	RTK_FC_HELPER_8367R_REALY_IGMP_PROTOCOL_INIT();
#endif 


	return SUCCESS;

}


uint32 _rtk_fc_mcflowHash(uint32 groupip_LSB_32)
{
	return (groupip_LSB_32 & ((1<<RTK_FC_TABLESIZE_MCFLOW_HASH_SHIFTBITS)-1));
}


int rtk_fc_igmp_mcExtraFlowIdxTbl_flashInit(void)
{
	int i;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW_HASH ;i++)
	{
		INIT_LIST_HEAD(&fc_db.listHead_mcExtraFlowIdxHashTbl[i]);
	}
	INIT_LIST_HEAD(&fc_db.listFree_mcExtraFlowIdxHashTbl);

	for(i=0 ; i<RTK_FC_TABLESIZE_MCFLOW;i++ )
	{
		memset(&fc_db.mcExtraFlowIdxTbl[i],0,sizeof(rtk_fc_mcExtraSwFlowIdx_entry_t));
		fc_db.mcExtraFlowIdxTbl[i].entryIdx = i;
		INIT_LIST_HEAD(&fc_db.mcExtraFlowIdxTbl[i].entry);
		list_add_tail(&fc_db.mcExtraFlowIdxTbl[i].entry, &fc_db.listFree_mcExtraFlowIdxHashTbl);		
	}

	return (RT_ERR_RG_OK);
}


rtk_fc_mcExtraSwFlowIdx_entry_t * rtk_fc_igmp_mcExtraFlowIdxTbl_add(rtk_fc_ingress_data_t *pFcIngressData,rtk_fc_pktHdr_t *pPktHdr,struct rt_skbuff *rtskb,int32 swFlowIdx)
{
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry_tmp=NULL;
	uint32 mcflowHash=0;
	int32 mcflowIdxDuplicate=0;
	//uint32 tmp_entryIdx=0;
	mcflowHash =_rtk_fc_mcflowHash(pFcIngressData->dstIp);

	list_for_each_entry(mcSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[mcflowHash],entry)
	{
		if(mcSwFlowId_entry->swFlowIdx==swFlowIdx)
		{
			mcflowIdxDuplicate=1;
			break;
		}
	}

	if(mcflowIdxDuplicate)
	{
		IGMP("mcflowIdx Duplicate at mcflowHash=%d swFlowIdx=%d update mcflowEntry",mcflowHash,swFlowIdx);
	}
	else
	{
		if(list_empty(&fc_db.listFree_mcExtraFlowIdxHashTbl))
		{
			uint32 maxIdleSecs=0;
			uint32 maxIdle_mcFlowTbl_idx=0;	
			bool find = FALSE;
			uint32 i;
			//do lru

			for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
			{
				list_for_each_entry(mcSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
				{
					if(fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].idleSecs > maxIdleSecs)
					{
						maxIdleSecs=fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].idleSecs;
						maxIdle_mcFlowTbl_idx=mcSwFlowId_entry->swFlowIdx;
						find = TRUE;
					}
				}
			}

			if(find && (maxIdle_mcFlowTbl_idx<RTK_FC_TABLESIZE_MCFLOW))
			{
				//delete a maxIdleSecs Entry
				IGMP("LRU delete a maxIdleSecs Entry");
				rtk_fc_igmp_mcExtraFlowIdxTbl_del(maxIdle_mcFlowTbl_idx);
			}	
		}

		if(list_empty(&fc_db.listFree_mcExtraFlowIdxHashTbl))
		{
			WARNING("all free IGMP listFree_mcExtraFlowIdxHashTbl list are allocated and no idle entry can be select...");
			return (NULL);
		}

		list_for_each_entry_safe(mcSwFlowId_entry,mcSwFlowId_entry_tmp,&fc_db.listFree_mcExtraFlowIdxHashTbl,entry)		//just return the first entry right behind of head
		{
			list_del_init(&mcSwFlowId_entry->entry);
			break;
		}
		IGMP("New a mcflow mcSwFlowId_entry[%d] ",mcSwFlowId_entry->entryIdx);

		/*we should init every field in mcSwFlowId_entry*/
		mcSwFlowId_entry->valid=1;
		mcSwFlowId_entry->dummySyncTimes=0;
		if(pPktHdr->ip6h)
		{
			mcSwFlowId_entry->isIpv6=1;
			memcpy(mcSwFlowId_entry->multicastAddress,pPktHdr->ip6h->daddr.in6_u.u6_addr32,sizeof(mcSwFlowId_entry->multicastAddress));
			memcpy(mcSwFlowId_entry->sourceAddress,pPktHdr->ip6h->saddr.in6_u.u6_addr32,sizeof(mcSwFlowId_entry->sourceAddress));
		}
		else
		{
			mcSwFlowId_entry->isIpv6=0;
			bzero(mcSwFlowId_entry->multicastAddress,sizeof(mcSwFlowId_entry->multicastAddress));
			bzero(mcSwFlowId_entry->sourceAddress,sizeof(mcSwFlowId_entry->sourceAddress));
			mcSwFlowId_entry->multicastAddress[0] =pFcIngressData->dstIp;
			mcSwFlowId_entry->sourceAddress[0] =pFcIngressData->srcIp;
		}
		if(pFcIngressData->ingressTagif & CVLAN_TAGIF)
			mcSwFlowId_entry->ingressCvid=pFcIngressData->srcCVlanId;
		else
			mcSwFlowId_entry->ingressCvid=FAIL;
	
		rtk_fc_flow_skbDataReasm(pFcIngressData,pPktHdr,mcSwFlowId_entry->mcDataBuf.dataBuf.data);
		mcSwFlowId_entry->mcDataBuf.skb_mark = RTSKB_MARK(rtskb);
		mcSwFlowId_entry->mcDataBuf.skb_mark2 = RTSKB_MARK2(rtskb);
		memcpy(&mcSwFlowId_entry->mcDataBuf.fcIngressData,pFcIngressData,sizeof(rtk_fc_ingress_data_t));
		mcSwFlowId_entry->mcDataBuf.fcIngressData.ct = NULL;
		mcSwFlowId_entry->mcDataBuf.fcIngressData.mcDummyPkt=1;
		
		mcSwFlowId_entry->swFlowIdx =swFlowIdx;

		list_add(&mcSwFlowId_entry->entry, &fc_db.listHead_mcExtraFlowIdxHashTbl[mcflowHash]);

	}

	return mcSwFlowId_entry;

}


int rtk_fc_igmp_mcExtraFlowIdxTbl_free(rtk_fc_mcExtraSwFlowIdx_entry_t* mcSwFlowId_entry)
{
	list_del_init(&mcSwFlowId_entry->entry);
	mcSwFlowId_entry->valid=0;
	list_add(&mcSwFlowId_entry->entry, &fc_db.listFree_mcExtraFlowIdxHashTbl);
	IGMP("Del mcExtraFlowIdxTbl[%d] ref to swFlowIdx[%d]",mcSwFlowId_entry->entryIdx,mcSwFlowId_entry->swFlowIdx);
	return (RT_ERR_RG_OK);
}

int rtk_fc_igmp_mcExtraFlowIdxTbl_del(int32 swFlowIdx)
{
	int i;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry_tmp=NULL;
	
	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{
		list_for_each_entry_safe(mcSwFlowId_entry,mcSwFlowId_entry_tmp,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			if(mcSwFlowId_entry->swFlowIdx==swFlowIdx)
			{
				rtk_fc_igmp_mcExtraFlowIdxTbl_free(mcSwFlowId_entry);
				return SUCCESS;
			}
		}
	}
	IGMP("Can't find swFlowIdx ");
	return FAIL;
}

rtk_fc_mcExtraSwFlowIdx_entry_t* rtk_fc_igmp_mcExtraFlowIdxTbl_find(int32 swFlowIdx)
{
	int i;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry_find=NULL;
	
	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{
		list_for_each_entry(mcSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			if(mcSwFlowId_entry->swFlowIdx==swFlowIdx)
			{
				mcSwFlowId_entry_find=mcSwFlowId_entry;
				break;
			}
		}
	}

	if(mcSwFlowId_entry_find==NULL)
	{
		IGMP("Can't find swFlowIdx ");
	}

	return mcSwFlowId_entry_find;

}



int _rtk_fc_groupLSB32_to_mac(unsigned char* mac,uint32 isIpv6,uint32 groupip_LSB_32)
{
	if(isIpv6)
	{
		mac[0]=0x33;
		mac[1]=0x33;
		mac[2]=(groupip_LSB_32>>24)&0xff;
		mac[3]=(groupip_LSB_32>>16)&0xff;
		mac[4]=(groupip_LSB_32>>8 )&0xff;
		mac[5]=(groupip_LSB_32>>0 )&0xff;
	}
	else
	{
		mac[0]=0x01;
		mac[1]=0x00;
		mac[2]=0x5e;
		mac[3]=(groupip_LSB_32>>16)&0x7f;
		mac[4]=(groupip_LSB_32>>8 )&0xff;
		mac[5]=(groupip_LSB_32>>0 )&0xff;
	}

	return SUCCESS;
}



rtk_fc_ret_t _rtk_fc_cpuSpa_macAdd(uint8 *mac,uint8 isStatic,int16 *mcL2Idx)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)
	int32 ret, i;
	rtk_fc_lut_entry_t *pLutEntry, *pNewLutEntry;
	int32 lutHashIdx=0, lutIdx=0, first_invalid=FAIL;
	rtk_fc_lutCam_linkList_t *pLutCamEntry, *pNextLutCamEntry;

	lutHashIdx = _rtk_fc_hash_mac_fid(mac, DEFAULT_FID);
	//Duplicate check
	list_for_each_entry_rcu(pLutEntry, &fc_db.lut_hash_list_head[lutHashIdx], lutList)
	{
		if(pLutEntry && !memcmp(pLutEntry->l2Addr, mac, ETH_ALEN) )
		{
			if(isStatic)
			{
				if(pLutEntry->isStatic==0)
					pLutEntry->isStatic=1;
				pLutEntry->staticRefCount++;
			}
			pLutEntry->last_jiffies=jiffies;
			*mcL2Idx = pLutEntry->lutIdx;
			return RTK_FC_RET_OK;
		}
	}

	lutIdx = lutHashIdx<<RTK_FC_LUT_HASH_WAY_SHIFT;
	for(i=lutIdx; i<(lutIdx+RTK_FC_LUT_HASH_WAY_SIZE); i++)
	{
		if(fc_db.lutTbl[i]==NULL)
		{
			first_invalid = i;
			TRACE("Found invalid lut[%d]", first_invalid);
			break;
		}
	}
	if(first_invalid==FAIL)
	{
		if(!list_empty(&fc_db.lutCam_freeListHead))
		{
			list_for_each_entry_safe(pLutCamEntry, pNextLutCamEntry, &fc_db.lutCam_freeListHead, lut_list)	//just return the first entry right behind of head
			{
				first_invalid = pLutCamEntry->idx;
				TRACE("Found invalid lut[%d] in cam", first_invalid);
				break;
			}
		}
	}
	if(first_invalid==FAIL)
	{
		if((first_invalid = _rtk_fc_lut_LRU(lutHashIdx)) != FAIL)
		{
			TRACE("Replace least recently used lut[%d]", first_invalid);
		}
		else
		{
			WARNING("Lut table is full, lutHashIdx=%d", lutHashIdx);
			return RTK_FC_RET_LRN_FAIL;
		}
	}

	//clear hw entry,if hybrid mode hardware autolearning may cause hw/sw not sync
	{
		rtk_l2_addr_table_t l2table;
		uint32 getidx=first_invalid;
		if(RT_ERR_OK ==	(rtk_l2_nextValidEntry_get(&getidx, &l2table)))
		{
			if(first_invalid == getidx && l2table.entryType==RTK_LUT_L2UC)
			{
				TABLE("clear hw lut for sw learning Idx:%d",first_invalid);
				rtk_l2_addr_del(&l2table.entry.l2UcEntry);
			}
		}
	}

	pNewLutEntry = _rtk_fc_lutEntry_getFromPool();
	if(pNewLutEntry==NULL)
	{
		WARNING("[Fail to add lut] Lut table pool is full.");
		return RTK_FC_RET_LRN_FAIL;
	}
	pNewLutEntry->spa = RTK_FC_MAC_PORT_MAX;
	pNewLutEntry->extspa = RTK_FC_MAC_EXT_PORT_MAX;
	pNewLutEntry->wlan_dev_idx=RTK_FC_WLANX_NOT_FOUND;
	memcpy(pNewLutEntry->l2Addr, mac, ETH_ALEN);
	pNewLutEntry->isStatic = isStatic;
	pNewLutEntry->last_jiffies = jiffies;
	if(isStatic)
		pNewLutEntry->staticRefCount=1;
	pNewLutEntry->isSync2PsEntry = FALSE;
	pNewLutEntry->hostPolIdx = FAIL;

	ret = RTK_FC_LUT_ADD(pNewLutEntry, FALSE);
	if(ret)
	{
		TABLE("MC MAC ADD FAILED ! ret=%d",ret);
		_rtk_fc_lutEntry_returnToPool(pNewLutEntry);
		return RTK_FC_RET_LRN_FAIL;
	}
	//if(pNewLutEntry->lutIdx!=first_invalid)
		//WARNING("New lut's index(%d) is not as expected index(%d)", pNewLutEntry->lutIdx, first_invalid);
	*mcL2Idx = pNewLutEntry->lutIdx;

#endif

	return RTK_FC_RET_OK;
}


/*
* groupip_LSB_32: host byte order
*/
rtk_fc_ret_t _rtk_fc_igmp_lutMcAdd(uint8 isIpv6 ,uint32 groupip_LSB_32,uint8 isStatic,int16 *mcL2Idx)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM) || defined(CONFIG_FC_RTL8277C_SERIES)
	uint8 mcMac[ETH_ALEN]={0};

	_rtk_fc_groupLSB32_to_mac(mcMac, isIpv6, groupip_LSB_32);

	return _rtk_fc_cpuSpa_macAdd(mcMac,isStatic,mcL2Idx);

#else
	return RTK_FC_RET_OK;
#endif
}



#define MC_DUMMY_SKB_PRI 7

#if 0 // not support
typedef struct rtk_fc_skb_netif_receiceWK_s
{
	struct work_struct work;
	struct sk_buff *skb;
}rtk_fc_skb_netif_receice_wq_t;

void rtk_fc_netif_reveive_skb_wq(struct work_struct *p_work)
{
	rtk_fc_skb_netif_receice_wq_t *p_callback_work = container_of(p_work, rtk_fc_skb_netif_receice_wq_t, work);
	RTK_FC_HOOK_PS_SKB_NETIF_RECEIVE_SKB(p_callback_work->skb);
	RTK_FC_HELPER_FC_KFREE(p_callback_work,sizeof(*p_callback_work));
}

int32 rtk_fc_skb_netif_receive_skb_wq_schedule(struct sk_buff *skb)
{
	int32 ret;
	rtk_fc_skb_netif_receice_wq_t *work = RTK_FC_HELPER_FC_KMALLOC(sizeof(typeof(*work)),GFP_ATOMIC);
	INIT_WORK(&work->work, rtk_fc_netif_reveive_skb_wq);
	work->skb = skb;
	ret=schedule_work(&work->work);
	if(ret==false)
		WARNING("Wq Error\n");	
	return SUCCESS;
}
#endif

//int32	hwIdx;					//9607C Series is lut idx / G3 Series is hash Idx
//int32	hwIdx2; 				//9607C Series is FAIL / G3 Series 8277C is lutIdx
int32 _rtk_fc_mc_groupToHwAsUnknown(int32 hwIdx,int32 hwIdx2)
{

	int32 ret=FAIL;
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
	int32 deleteIdx=hwIdx;
	ca_ip_address_t groupAddr;
	bzero(&groupAddr,sizeof(groupAddr));
#if defined(CONFIG_FC_RTL8277C_SERIES)
{
	rtk_fc_tableFlow_t *pFlowTable;

	ret=rtk_8277c_flow_mcast_group_asunknown(groupAddr,&deleteIdx);
	if(ret!=SUCCESS )
	{
		WARNING("rtk_8277c_flow_mcast_group_asunknown Error ret=%d",ret);
		return ret;
	}

	//invalid hwFlow_validBitsArray
	if(deleteIdx < fc_db.flowHwTableSize)
	{
		fc_db.g3_mHashTbl_validBitsArray[(deleteIdx >> 5)] &= ~(0x1 << (deleteIdx&0x1f));
	}
	
	pFlowTable = &fc_db.flowTbl[deleteIdx];

	pFlowTable->pFlowEntry->path1.valid = 0;

	// initialize sw field of hwflow
	pFlowTable->cachedCt = NULL;
	//--------------- RESET: init value which is 0	   -------------------------------------------------------------------------------//
	memset((uint8 *)pFlowTable + offsetof(rtk_fc_tableFlow_t, cachedCt) , 0 , (sizeof(rtk_fc_tableFlow_t)- offsetof(rtk_fc_tableFlow_t, cachedCt) ) );
	//------------------------------------------------------------------------------------------------------------------------------//
	
	//----------------RESET: init value which is not 0 -------------------------------------------------------------------------------//
	pFlowTable->loopbackRevFlowIdx = SIGNED_INVALID;		// shared info
	pFlowTable->lutIgrSaIdx = SIGNED_INVALID;
	pFlowTable->lutEgrDaIdx = SIGNED_INVALID;
	pFlowTable->pAbstrSwFlowEt=NULL;
	//------------------------------------------------------------------------------------------------------------------------------//


	if(hwIdx2 != FAIL)
	{
		if(fc_db.lutTbl[hwIdx2])
		{
			ASSERT_EQ(_rtk_fc_lut_staticEntry_del(hwIdx2), SUCCESS);
		}
	}


}
#else
	ret=rtl_l2_mcast_group_asunknown(G3_DEF_DEVID,groupAddr,&deleteIdx);
#endif
	IGMP("set rtl_l2_mcast_group_asunknown ");
	if(ret!=CA_E_OK )
	{
		WARNING("rtl_l2_mcast_group_asunknown Error ret=%d",ret);
	}			
#else

	ret=_rtk_fc_lut_staticEntry_del((uint32)hwIdx);
	if(ret!=SUCCESS )
	{
		WARNING("_rtk_fc_lut_staticEntry_del Error ret=%d",ret);
	}

#endif

	return ret;

}

//int32	hwIdx;					//9607C Series is lut idx / G3 Series is hash Idx
//int32	hwIdx2; 				//9607C Series is FAIL / G3 Series 8277C is lutIdx
int32 _rtk_fc_mc_groupToHwAsKnown(uint32 is_ipv6,uint32 *gip,int32 *hwIdx,int32 *hwIdx2)
{

	int32 ret=RTK_FC_RET_LRN_FAIL;
	*hwIdx=FAIL;
	*hwIdx2=FAIL;
#if defined(CONFIG_RTK_L34_G3_PLATFORM)
{
	ca_ip_address_t groupAddr;
	bzero(&groupAddr,sizeof(groupAddr));
	
	if(is_ipv6)
	{
		groupAddr.afi =CA_IPV6;
		groupAddr.addr_len=128;
		groupAddr.ip_addr.ipv6_addr[0] = ntohl(gip[0]);
		groupAddr.ip_addr.ipv6_addr[1] = ntohl(gip[1]);
		groupAddr.ip_addr.ipv6_addr[2] = ntohl(gip[2]);
		groupAddr.ip_addr.ipv6_addr[3] = ntohl(gip[3]);
	}
	else
	{
		groupAddr.afi =CA_IPV4;
		groupAddr.addr_len=32;
		groupAddr.ip_addr.ipv4_addr =gip[0];
	}
#if defined(CONFIG_FC_RTL8277C_SERIES)
{
	int16 macIdx=FAIL;
	ret=rtl_8277c_flow_mcast_group_asknown(groupAddr,hwIdx);
	if(ret != RTK_FC_RET_OK)
	{
		IGMP("add known group fail %d",ret);
		return ret;
	}
	else
		IGMP("group Idx=%d",*hwIdx);

	//set to path6 is a static entry
	fc_db.flowTbl[*hwIdx].pFlowEntry->path6.valid=TRUE;
	fc_db.flowTbl[*hwIdx].pFlowEntry->path6.in_path= FB_PATH_6;
	fc_db.flowTbl[*hwIdx].candidateState=CANDIDATE_STATE_READY;
	fc_db.flowTbl[*hwIdx].lutIgrSaIdx = FAIL;
	fc_db.flowTbl[*hwIdx].lutEgrDaIdx = FAIL;
	fc_db.g3_mHashTbl_validBitsArray[((*hwIdx) >> 5)] |= (0x1 << ((*hwIdx)&0x1f));
	FLOW_INFO_SET(&fc_db.flowTbl[*hwIdx], FLOW_INFO_STATIC_ENTRY, 1);


	if(is_ipv6)
	{
		ret=_rtk_fc_igmp_lutMcAdd(is_ipv6,gip[3],1,&macIdx);
	}
	else
	{
		ret=_rtk_fc_igmp_lutMcAdd(is_ipv6,gip[0],1,&macIdx);
	}
	if(ret==RTK_FC_RET_OK)
		*hwIdx2=macIdx;	

}
#else	
	ret=rtl_l2_mcast_group_asknown(G3_DEF_DEVID,groupAddr,hwIdx);
#endif
}
#else
{
	int16 macIdx;
	if(is_ipv6)
	{
		ret=_rtk_fc_igmp_lutMcAdd(is_ipv6,gip[3],1,&macIdx);
	}
	else
	{
		ret=_rtk_fc_igmp_lutMcAdd(is_ipv6,gip[0],1,&macIdx);
	}
	*hwIdx=macIdx;

}
#endif
	if(ret != RTK_FC_RET_OK)
		IGMP("add known group fail %x",ret);
	else
		IGMP("group hwIdx=%d hwIdx2=%d",*hwIdx,*hwIdx2);

	return ret;
}

rtk_fc_table_mcGroupTbl_t* rtk_fc_mc_findKnownGroupEntry(uint32 is_ipv6,uint32 *gip)
{
	int i;
	int32 dupEtIdx=FAIL;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
	{
		if(fc_db.mcGroupTbl[i].valid)
		{
			if(is_ipv6 != fc_db.mcGroupTbl[i].isIpv6)
				continue;
			
			if(is_ipv6)
			{
				if(memcmp(fc_db.mcGroupTbl[i].mcGroup,gip,sizeof(fc_db.mcGroupTbl[i].mcGroup))==0)
					dupEtIdx=i;
			}
			else
			{
				if(fc_db.mcGroupTbl[i].mcGroup[0]==gip[0])
					dupEtIdx=i;
			}
				
		}
	}

	if(dupEtIdx==FAIL)
		return NULL;
	else
		return &fc_db.mcGroupTbl[dupEtIdx];

}


int32 rtk_fc_mc_delKnownGroupEntry(rtk_fc_table_mcGroupTbl_t* mcGroupEt)
{
	if(mcGroupEt->valid && (mcGroupEt->groupRefCnt>0))
	{
		IGMP("delKnownGroupEntry  groupRefCnt:%d->%d",mcGroupEt->groupRefCnt,mcGroupEt->groupRefCnt-1);
		mcGroupEt->groupRefCnt--;
		if(mcGroupEt->groupRefCnt==0)
		{
			_rtk_fc_mc_groupToHwAsUnknown(mcGroupEt->hwIdx,mcGroupEt->hwIdx2);
			mcGroupEt->valid=0;
			return SUCCESS;
		}

	}
	return SUCCESS;
}

rtk_fc_table_mcGroupTbl_t* rtk_fc_mc_addKnownGroupEntry(uint32 is_ipv6,uint32 *gip)
{
	int i;
	int32 firtInvalidIdx=FAIL;
	int32 dupEtIdx=FAIL;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
	{
		if(fc_db.mcGroupTbl[i].valid)
		{
			if(is_ipv6 != fc_db.mcGroupTbl[i].isIpv6)
				continue;
			
			if(is_ipv6)
			{

				if(memcmp(fc_db.mcGroupTbl[i].mcGroup,gip,sizeof(fc_db.mcGroupTbl[i].mcGroup))==0)
					dupEtIdx=i;
			}
			else
			{
				if(fc_db.mcGroupTbl[i].mcGroup[0]==gip[0])
					dupEtIdx=i;
			}
				
		}
		else
		{
			if(firtInvalidIdx==FAIL)
				firtInvalidIdx=i;
		}	
	}

	if(firtInvalidIdx==FAIL && dupEtIdx==FAIL)
	{
		IGMP("mcGroupTbl Full ");
		return NULL;
	}

	if(dupEtIdx==FAIL)
	{
		//newEt
		bzero(&fc_db.mcGroupTbl[firtInvalidIdx],sizeof(rtk_fc_table_mcGroupTbl_t));
		if(_rtk_fc_mc_groupToHwAsKnown(is_ipv6,gip,&fc_db.mcGroupTbl[firtInvalidIdx].hwIdx,&fc_db.mcGroupTbl[firtInvalidIdx].hwIdx2)!=RTK_FC_RET_OK)
			return NULL;		
		fc_db.mcGroupTbl[firtInvalidIdx].valid=1;
		fc_db.mcGroupTbl[firtInvalidIdx].groupRefCnt=1;
		fc_db.mcGroupTbl[firtInvalidIdx].isIpv6=is_ipv6;
		if(is_ipv6)
		{
			memcpy(fc_db.mcGroupTbl[firtInvalidIdx].mcGroup,gip,sizeof(fc_db.mcGroupTbl[firtInvalidIdx].mcGroup));
		}
		else
		{
			fc_db.mcGroupTbl[firtInvalidIdx].mcGroup[0]=gip[0];			
		}

		return &fc_db.mcGroupTbl[firtInvalidIdx];
	}
	else
	{
		IGMP("Using a old groupEt add ref to %d->%d",fc_db.mcGroupTbl[dupEtIdx].groupRefCnt,fc_db.mcGroupTbl[dupEtIdx].groupRefCnt+1);
		//dupEt
		fc_db.mcGroupTbl[dupEtIdx].groupRefCnt++;
		return &fc_db.mcGroupTbl[dupEtIdx];
	}


}


rtk_fc_table_mcConfigTbl_t* rtk_fc_mc_mallocMcConfig (uint32 is_ipv6,uint32 *gip,uint8 careSource,uint32 *sip,uint8 careCvid,int16 ingressCvid)
{
	int i;
	int32 firtInvalidIdx=FAIL;
	int32 gipHit=0,sipHit=0,vlanHit=0;

	if(gip==NULL || (careSource && sip==NULL))
		return NULL;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
	{
		sipHit=0;vlanHit=0;gipHit=0;
		if(fc_db.mcCfgTbl[i].valid==0)
		{
			if(firtInvalidIdx==FAIL)
			{
				firtInvalidIdx=i;
				break;
			}
		}	
	}

	if(firtInvalidIdx==FAIL)
	{
		IGMP("mcGroupTbl Full ");
		return NULL;
	}

	//new entry
	if(rtk_fc_mc_addKnownGroupEntry(is_ipv6,gip)==NULL)
		return NULL;

	bzero(&fc_db.mcCfgTbl[firtInvalidIdx],sizeof(rtk_fc_table_mcConfigTbl_t));
	fc_db.mcCfgTbl[firtInvalidIdx].valid=1;
	fc_db.mcCfgTbl[firtInvalidIdx].careIngressCvid=careCvid;
	if(careCvid)
		fc_db.mcCfgTbl[firtInvalidIdx].confIgrCvid=ingressCvid;
	fc_db.mcCfgTbl[firtInvalidIdx].careSource=careSource;
	fc_db.mcCfgTbl[firtInvalidIdx].isIpv6=is_ipv6;
	if(is_ipv6)
	{
		memcpy(fc_db.mcCfgTbl[firtInvalidIdx].confGroup,gip,sizeof(fc_db.mcCfgTbl[firtInvalidIdx].confGroup));
		if(careSource && sip)
			memcpy(fc_db.mcCfgTbl[firtInvalidIdx].confSource,sip,sizeof(fc_db.mcCfgTbl[firtInvalidIdx].confSource));
	}
	else
	{
		fc_db.mcCfgTbl[firtInvalidIdx].confGroup[0]=gip[0];
		if(careSource && sip)
			fc_db.mcCfgTbl[firtInvalidIdx].confSource[0]=sip[0];
	}
	
	return &fc_db.mcCfgTbl[firtInvalidIdx];


}

rtk_fc_table_mcConfigTbl_t* rtk_fc_mc_findMcConfig(uint32 is_ipv6,uint32 *gip,uint8 careSource,uint32 *sip,uint8 careCvid,int16 ingressCvid)
{
	int i;
	int32 dupEtIdx=FAIL;
	int32 gipHit=0,sipHit=0,vlanHit=0;

	if(gip==NULL || (careSource && sip==NULL))
		return NULL;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
	{
		sipHit=0;vlanHit=0;gipHit=0;
		if(fc_db.mcCfgTbl[i].valid)
		{
			if(is_ipv6 != fc_db.mcCfgTbl[i].isIpv6)
				continue;
			if(careSource != fc_db.mcCfgTbl[i].careSource)
				continue;
			if(careCvid != fc_db.mcCfgTbl[i].careIngressCvid)
				continue;

			
			if(is_ipv6)
			{
				if(memcmp(fc_db.mcCfgTbl[i].confGroup,gip,sizeof(fc_db.mcCfgTbl[i].confGroup))==0)
					gipHit=1;
				if(careSource && sip )
				{
					if(memcmp(fc_db.mcCfgTbl[i].confSource,sip,sizeof(fc_db.mcCfgTbl[i].confSource))==0)
						sipHit=1;
				}
				else
					sipHit=1;
			}
			else
			{
				if(fc_db.mcCfgTbl[i].confGroup[0]==gip[0])
					gipHit=1;
				if(careSource && sip)
				{
					if(fc_db.mcCfgTbl[i].confSource[0]==sip[0])
						sipHit=1;
				}
				else
					sipHit=1;
			}

			if(careCvid)
			{
				if( fc_db.mcCfgTbl[i].confIgrCvid==ingressCvid)
					vlanHit=1;
			}
			else
				vlanHit=1;
		
			IGMP("[%d]gipHit=%d sipHit=%d vlanHit=%d",i,gipHit,sipHit,vlanHit);
			if(gipHit && sipHit && vlanHit)
			{
				dupEtIdx=i;
				break;
			}
		}

	}
	
	if(dupEtIdx==FAIL)
	{
		return NULL;
	}
	else
		return &fc_db.mcCfgTbl[dupEtIdx];


}

int rtk_fc_mc_delMcConfig(rtk_fc_table_mcConfigTbl_t* delconf)
{
	rtk_fc_table_mcGroupTbl_t* knownGroup= rtk_fc_mc_findKnownGroupEntry(delconf->isIpv6,delconf->confGroup);
	if(knownGroup)
		rtk_fc_mc_delKnownGroupEntry(knownGroup);
	bzero(delconf,sizeof(rtk_fc_table_mcConfigTbl_t));
	return SUCCESS;
}

//cvlan -1 is untag
rtk_fc_table_mcConfigTbl_t* rtk_fc_mc_searchMcConfigByPatten(uint8 isIpv6 ,uint32 *groupIp ,uint32 *soruceIp,int16 cvlan)
{
	int i;
	int32 gipHit=0,sipHit=0,vlanHit=0;
	int32 hitIdx=FAIL;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
	{

		if(!fc_db.mcCfgTbl[i].valid)
			continue;
		sipHit=0;vlanHit=0;gipHit=0;

		if(isIpv6==1 && fc_db.mcCfgTbl[i].isIpv6==1)
		{
			if(memcmp(fc_db.mcCfgTbl[i].confGroup,groupIp,sizeof(fc_db.mcCfgTbl[i].confGroup))==0)
				gipHit=1;
			if(fc_db.mcCfgTbl[i].careSource )
			{
				if(memcmp(fc_db.mcCfgTbl[i].confSource,soruceIp,sizeof(fc_db.mcCfgTbl[i].confSource))==0)
					sipHit=1;
			}
			else
				sipHit=1;
		}
		else if(isIpv6==0 && fc_db.mcCfgTbl[i].isIpv6==0)
		{
			if(fc_db.mcCfgTbl[i].confGroup[0]== (*groupIp))
				gipHit=1;
			if(fc_db.mcCfgTbl[i].careSource)
			{
				if(fc_db.mcCfgTbl[i].confSource[0]==(*soruceIp))
					sipHit=1;
			}
			else
				sipHit=1;
		}

		if(fc_db.mcCfgTbl[i].careIngressCvid)
		{
			if( fc_db.mcCfgTbl[i].confIgrCvid==cvlan)
				vlanHit=1;
		}
		else
			vlanHit=1;

		IGMP("[%d]gipHit=%d sipHit=%d vlanHit=%d",i,gipHit,sipHit,vlanHit);
		if(gipHit && sipHit && vlanHit)
		{
			hitIdx=i;
			break;
		}
	
	}

	if(hitIdx==FAIL)
	{
		return NULL;
	}
	else
		return &fc_db.mcCfgTbl[hitIdx];



}



//just reutrn first hit
rtk_fc_table_mcConfigTbl_t* rtk_fc_mc_searchMcConfigByPktHdr(struct rt_skbuff *rtskb ,rtk_fc_pktHdr_t *pPktHdr)
{
	int i;
	int32 gipHit=0,sipHit=0,vlanHit=0;
	int32 hitIdx=FAIL;

	for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
	{

		if(!fc_db.mcCfgTbl[i].valid)
			continue;
		sipHit=0;vlanHit=0;gipHit=0;

		if(pPktHdr->ip6h && fc_db.mcCfgTbl[i].isIpv6==1)
		{
			if(memcmp(fc_db.mcCfgTbl[i].confGroup,pPktHdr->ip6h->daddr.s6_addr,sizeof(fc_db.mcCfgTbl[i].confGroup))==0)
				gipHit=1;
			if(fc_db.mcCfgTbl[i].careSource )
			{
				if(memcmp(fc_db.mcCfgTbl[i].confSource,pPktHdr->ip6h->saddr.s6_addr,sizeof(fc_db.mcCfgTbl[i].confSource))==0)
					sipHit=1;
			}
			else
				sipHit=1;
		}
		else if(pPktHdr->iph && fc_db.mcCfgTbl[i].isIpv6==0)
		{
			if(fc_db.mcCfgTbl[i].confGroup[0]==ntohl(pPktHdr->iph->daddr))
				gipHit=1;
			if(fc_db.mcCfgTbl[i].careSource)
			{
				if(fc_db.mcCfgTbl[i].confSource[0]==ntohl(pPktHdr->iph->saddr))
					sipHit=1;
			}
			else
				sipHit=1;
		}

		if(fc_db.mcCfgTbl[i].careIngressCvid )
		{
			if( (!(RTSKB_FCIGRDATA(rtskb)->ingressTagif & CVLAN_TAGIF) && fc_db.mcCfgTbl[i].confIgrCvid==-1) ||
				((RTSKB_FCIGRDATA(rtskb)->ingressTagif & CVLAN_TAGIF) && fc_db.mcCfgTbl[i].confIgrCvid==RTSKB_FCIGRDATA(rtskb)->srcCVlanId))
				vlanHit=1;
		}
		else
			vlanHit=1;

		IGMP("[%d]gipHit=%d sipHit=%d vlanHit=%d",i,gipHit,sipHit,vlanHit);
		if(gipHit && sipHit && vlanHit)
		{
			hitIdx=i;
			break;
		}
	
	}

	if(hitIdx==FAIL)
	{
		return NULL;
	}
	else
		return &fc_db.mcCfgTbl[hitIdx];



}


int32 rtk_fc_igmp_checkFlow(rtk_fc_table_mcConfigTbl_t* mcConfig)
{

	int i;
	int32 gorupIpHit=0;
	int32 careSourceAndHit=0;
	int32 careCvidAndHit=0;
	
	for(i=0 ; i<RTK_FC_TABLESIZE_MCFLOW ;i++)
	{

		gorupIpHit=0;
		careSourceAndHit=0;
		careCvidAndHit=0;

		if(!fc_db.mcExtraFlowIdxTbl[i].valid)
			continue;

		if(mcConfig->isIpv6==fc_db.mcExtraFlowIdxTbl[i].isIpv6 && memcmp(fc_db.mcExtraFlowIdxTbl[i].multicastAddress,mcConfig->confGroup,sizeof(fc_db.mcExtraFlowIdxTbl[i].multicastAddress))==0)
			gorupIpHit=1;
		
		if(mcConfig->careSource)
		{
			if(mcConfig->isIpv6==fc_db.mcExtraFlowIdxTbl[i].isIpv6 && (memcmp(fc_db.mcExtraFlowIdxTbl[i].sourceAddress,mcConfig->confSource,sizeof(fc_db.mcExtraFlowIdxTbl[i].sourceAddress))==0))
				careSourceAndHit=1;
		}
		else
			careSourceAndHit=1; // treat as hit
		
		if(mcConfig->careIngressCvid)
		{
			if(( mcConfig->confIgrCvid == fc_db.mcExtraFlowIdxTbl[i].ingressCvid) )
				careCvidAndHit=1;
		}
		else
			careCvidAndHit=1;  // treat as hit


		//all hit delete relative table
		IGMP("mcflowIdx[%d] gorupIpHit:%d careSourceAndHit:%d careCvidAndHit:%d",i,gorupIpHit,careSourceAndHit,careCvidAndHit);
		if(gorupIpHit && careSourceAndHit && careCvidAndHit)
			return FALSE;
	}
	
	return TRUE;
} 



rtk_fc_ret_t rtk_fc_abstrSwflow_sendMcDummyPkt(rtk_fc_mcExtraSwFlowIdx_entry_t *mcFlowIdxEt)
{
	struct sk_buff *skb = NULL;
	struct rt_skbuff *rtskb, rtSKB;
	struct net_device *SrcDev=NULL;

	if(mcFlowIdxEt->valid==0)
		return RTK_FC_RET_ERR;

	FC_PARAM_CHK(mcFlowIdxEt==NULL, RTK_FC_RET_ERR_NULL_POINTER);

	RTK_FC_HOOK_PS_SKB_DEV_ALLOC_SKB(SKB_BUF_SIZE, &skb);
	if(skb==NULL)
		return RTK_FC_RET_ERR;

	SrcDev = fc_db.netifTbl[mcFlowIdxEt->mcDataBuf.fcIngressData.SrcDevSwIfIdx].dev;
	if(SrcDev==NULL)
		return RTK_FC_RET_ERR;

	// set l4_hash=1 sw_hash=1; and hash =0 to avoid enqueue to backlog again
	if(fc_db.hook_func.ps->fc_skb_set_sw_hash)
		fc_db.hook_func.ps->fc_skb_set_sw_hash(skb);
	if(fc_db.hook_func.ps->fc_skb_set_l4_hash)
		fc_db.hook_func.ps->fc_skb_set_l4_hash(skb);
	if(fc_db.hook_func.ps->fc_skb_set_priority)
		fc_db.hook_func.ps->fc_skb_set_priority(skb,MC_DUMMY_SKB_PRI);

	rtskb = &rtSKB;
	RTK_FC_HOOK_CONVERTER_SKB(skb, rtskb);

	RTSKB_DEV(rtskb) = SrcDev;

	RTSKB_MARK(rtskb) = mcFlowIdxEt->mcDataBuf.skb_mark;	
	if(RTSKB_MARK2_EXIST(rtskb))
		RTSKB_MARK2_FORCE(rtskb) = mcFlowIdxEt->mcDataBuf.skb_mark2;

	RTSKB_HASH(rtskb)=0;

	/* *pData = skb_put(skb, len); */
	RTK_FC_HOOK_PS_SKB_SKB_PUT(RTSKB_SKB(rtskb),MAX_AUTOEXT_PKT_SIZE,&RTSKB_DATA(rtskb));

	memcpy(RTSKB_DATA(rtskb), mcFlowIdxEt->mcDataBuf.dataBuf.data, RTSKB_LEN(rtskb));

	/* skb_reset_mac_header(skb); */
	RTK_FC_HOOK_PS_SKB_SKB_RESET_MAC_HEADER(RTSKB_SKB(rtskb));

	/* skb->protocol = eth_type_trans(skb, dev); */
	RTK_FC_HOOK_PS_SKB_ETH_TYPE_TRANS(RTSKB_SKB(rtskb), RTSKB_DEV(rtskb));

	memcpy(RTSKB_FCIGRDATA(rtskb),&mcFlowIdxEt->mcDataBuf.fcIngressData,sizeof(rtk_fc_ingress_data_t));
	atomic_inc(&fc_db.statistic.perPortCnt_dummpPktAlloc[RTSKB_FCIGRDATA(rtskb)->ingressPort]);

	//netif_rx receive RTSKB_DATA(rtskb) = skb->header+ ETH_HLEN(14) ,we should set RTSKB_PROTOCOL(rtskb) correct
	IGMP("[McData] send dummy pkt via netdev %s, proto = 0x%x len=%d", RTSKB_DEV(rtskb)->name, RTSKB_PROTOCOL(rtskb),RTSKB_LEN(rtskb));
	if(fc_db.debugLevel & FC_DEBUG_LEVEL_TRACE_DUMP )
		dump_packet( mcFlowIdxEt->mcDataBuf.dataBuf.data, MAX_AUTOEXT_PKT_SIZE, "[McData]");

/*
//	way1.using workqueue:
//		-get a warning message "NOHZ:local_softirq_peding 08"
//		-get a GPL problem when lock debug open

	rtk_fc_skb_netif_receive_skb_wq_schedule(RTSKB_SKB(rtskb));
*/

/*
//	way2.using netif_receive_skb
//		-get a tx deadlock problem
		
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();
	if(RTK_FC_HOOK_PS_SKB_NETIF_RECEIVE_SKB(RTSKB_SKB(rtskb))== NET_RX_DROP)
	{
		WARNING("[McData] send dummy pkt fail, dev = %s", RTSKB_DEV(rtskb)->name);
	}
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();
*/


//	way3. using netif_rx
//		-binding with linux backlog hacking (we hope do not binding with hacking)
//		-should set priority
		RTK_FC_HOOK_PS_SKB_NETIF_RX(RTSKB_SKB(rtskb));

	return (RTK_FC_RET_OK);
}


//clear delete port and rearrange egrInfo[]
int32 rtk_fc_igmp_renewMcConfig(rtk_fc_table_mcConfigTbl_t* mcConfig)
{
	rtk_fc_mcPort_t	 _egrInfo[RT_MCCFG_MAX_NUM];
	int i ;
	uint32 cnt=0;
	
	bzero(_egrInfo,sizeof(_egrInfo));

	for(i=0 ; i< mcConfig->cnt_egrInfo;i++)
	{
		//keep all exclude delete entry
		if(mcConfig->egrInfo[i].status!=PORT_STATUS_SHOULD_BE_DELETE)
		{
			memcpy(&_egrInfo[cnt],&mcConfig->egrInfo[i],sizeof(rtk_fc_mcPort_t));
			_egrInfo[cnt].status=PORT_STATUS_UPDATE_DONE;
			cnt++;
		}
	}
	memcpy(mcConfig->egrInfo,&_egrInfo,sizeof(_egrInfo));
	mcConfig->cnt_egrInfo = cnt;
	
	return SUCCESS;
}

int32 rtk_fc_igmp_mcConfig_abstrSwFlow_sendDummy(rtk_fc_table_mcConfigTbl_t* mcConfig)
{
	int i;
	int32 gorupIpHit=0;
	int32 careSourceAndHit=0;
	int32 careCvidAndHit=0;
	rtk_fc_abstrSwFlowList_entry_t *pAbstrSwFlowEt=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcTmpSwFlowId_entry=NULL;

	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{

		list_for_each_entry_safe(mcSwFlowId_entry,mcTmpSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			gorupIpHit=0;careSourceAndHit=0;careCvidAndHit=0;
			pAbstrSwFlowEt=fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].pAbstrSwFlowEt;

			if(mcConfig->isIpv6==pAbstrSwFlowEt->swFlowKey.bits.isIpv6 && memcmp(mcSwFlowId_entry->multicastAddress,mcConfig->confGroup,sizeof(mcSwFlowId_entry->multicastAddress))==0)
				gorupIpHit=1;

			if(mcConfig->careSource)
			{
				if(mcConfig->isIpv6==pAbstrSwFlowEt->swFlowKey.bits.isIpv6 && (memcmp(mcSwFlowId_entry->sourceAddress,mcConfig->confSource,sizeof(mcSwFlowId_entry->sourceAddress))==0))
					careSourceAndHit=1;
			}
			else
				careSourceAndHit=1; // treat as hit

			if(mcConfig->careIngressCvid)
			{
				if(( mcConfig->confIgrCvid == mcSwFlowId_entry->ingressCvid) )
					careCvidAndHit=1;
			}
			else
				careCvidAndHit=1;  // treat as hit


			IGMP("[%d]swFlowIdx[%d] gorupIpHit:%d careSourceAndHit:%d careCvidAndHit:%d",mcSwFlowId_entry->entryIdx,mcSwFlowId_entry->swFlowIdx,gorupIpHit,careSourceAndHit,careCvidAndHit);
			if(gorupIpHit && careSourceAndHit && careCvidAndHit )
			{
				//send dummy packet by flow for add port purpose
				IGMP("send dummy packet");
				rtk_fc_abstrSwflow_sendMcDummyPkt(mcSwFlowId_entry);
			}
			
		}
	}

	return SUCCESS;

}



//just remove leave port in swflow and hw, if join we need send dummy packet to add swflow action
int32 rtk_fc_igmp_applyMcConfig_abstrSwFlow(rtk_fc_table_mcConfigTbl_t* mcConfig)
{
	int i,j;
	int32 gorupIpHit=0;
	int32 careSourceAndHit=0;
	int32 careCvidAndHit=0;
	rtk_fc_abstrSwFlowList_entry_t *pAbstrSwFlowEt=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcTmpSwFlowId_entry=NULL;
	rtk_fc_abstrSwFlowActionList_entry_t *pSwFlowAction=NULL;
	rtk_fc_abstrSwFlowActionList_entry_t *pTmpSwFlowAction=NULL;
	rtk_fc_abstrSwFlowLdpid_entry_t *pLdpid=NULL;
	rtk_fc_abstrSwFlowLdpid_entry_t *pTmpLdpid=NULL;
	uint32 needAddDev=0;
	uint32 needDelDev=0;


	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{

		list_for_each_entry_safe(mcSwFlowId_entry,mcTmpSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			needAddDev=0;needDelDev=0;
			gorupIpHit=0;careSourceAndHit=0;careCvidAndHit=0;
			pAbstrSwFlowEt=fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].pAbstrSwFlowEt;

			/* may we */
			if(mcConfig->isIpv6==pAbstrSwFlowEt->swFlowKey.bits.isIpv6 && memcmp(mcSwFlowId_entry->multicastAddress,mcConfig->confGroup,sizeof(mcSwFlowId_entry->multicastAddress))==0)
				gorupIpHit=1;

			if(mcConfig->careSource)
			{
				if(mcConfig->isIpv6==pAbstrSwFlowEt->swFlowKey.bits.isIpv6 && (memcmp(mcSwFlowId_entry->sourceAddress,mcConfig->confSource,sizeof(mcSwFlowId_entry->sourceAddress))==0))
					careSourceAndHit=1;
			}
			else
				careSourceAndHit=1; // treat as hit

			if(mcConfig->careIngressCvid)
			{
				if(( mcConfig->confIgrCvid == mcSwFlowId_entry->ingressCvid) )
					careCvidAndHit=1;
			}
			else
				careCvidAndHit=1;  // treat as hit


			IGMP("[%d]swFlowIdx[%d] gorupIpHit:%d careSourceAndHit:%d careCvidAndHit:%d",mcSwFlowId_entry->entryIdx,mcSwFlowId_entry->swFlowIdx,gorupIpHit,careSourceAndHit,careCvidAndHit);
			if(gorupIpHit && careSourceAndHit && careCvidAndHit )
			{
				list_for_each_entry_safe(pSwFlowAction,pTmpSwFlowAction, &pAbstrSwFlowEt->swFlowActionHdr, swFlowActionList)
				{
					list_for_each_entry_safe(pLdpid,pTmpLdpid, &pSwFlowAction->ldpidListHdr, ldpidList)
					{
						for(j=0;j< mcConfig->cnt_egrInfo;j++)
						{
							if(mcConfig->egrInfo[j].status==PORT_STATUS_UPDATE_DONE)
								continue;

							if(mcConfig->egrInfo[j].ifidx==FAIL)
							{
								if(pLdpid->isWlan==mcConfig->egrInfo[j].isWlan &&
								   pLdpid->flowLdpid == mcConfig->egrInfo[j].portId &&
								   mcConfig->egrInfo[j].status==PORT_STATUS_SHOULD_BE_DELETE)
								{
									//remove and free ldpid list
									IGMP("IGMP remove port(%d)",pLdpid->flowLdpid);
									pLdpid->portSyncStatus=PORT_STATUS_SHOULD_BE_DELETE;
									needDelDev=1;
								}

							}
							else
							{
								if(pLdpid->devIfIdx == mcConfig->egrInfo[j].ifidx && mcConfig->egrInfo[j].status==PORT_STATUS_SHOULD_BE_DELETE)
								{
									//remove and free ldpid list
									IGMP("IGMP remove ifidx:%d port(%d) ",pLdpid->devIfIdx,pLdpid->flowLdpid);
									pLdpid->portSyncStatus=PORT_STATUS_SHOULD_BE_DELETE;
									needDelDev=1;
								}
							}
							
							if( mcConfig->egrInfo[j].status == PORT_STATUS_SHOULD_BE_ADD)
							{
								IGMP("IGMP Add port(%d) devIfIdx=%d wlan=%d",mcConfig->egrInfo[j].portId,mcConfig->egrInfo[j].ifidx,mcConfig->egrInfo[j].isWlan);
								needAddDev=1;
							}
						}
					}
				}

				if(needDelDev)
				{
					uint32 portCnt=0;
					//sync to hardware
					if(!FLOW_INFO_IS_SET(&fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx], FLOW_INFO_SOFTWARE_ONLY))
						rtk_fc_abstrSwSyncToHw_update(mcSwFlowId_entry->swFlowIdx);
					
					//clear should be delete entry 
					list_for_each_entry_safe(pSwFlowAction,pTmpSwFlowAction, &pAbstrSwFlowEt->swFlowActionHdr, swFlowActionList)
					{
						portCnt=0;
						list_for_each_entry_safe(pLdpid,pTmpLdpid, &pSwFlowAction->ldpidListHdr, ldpidList)
						{
							if(pLdpid->portSyncStatus==PORT_STATUS_SHOULD_BE_DELETE)
							{
								IGMP("delete pLdpid=%d ifidx:%d",pLdpid->flowLdpid,pLdpid->devIfIdx);
								rtk_fc_abstrSwFlowLdpidFree(pLdpid);
							}
							else
								portCnt++;
						}
						//if Ldpid list empty delete this action
						if(portCnt==0)
						{
							IGMP("delete pSwFlowAction");
							rtk_fc_abstrSwFlowActionFree(pSwFlowAction);
						}
					}

					//if Action list empty delete flow 
					if(list_empty(&pAbstrSwFlowEt->swFlowActionHdr))
					{
						IGMP("delete swFlowIdx=%d",mcSwFlowId_entry->swFlowIdx);
						rtk_fc_flow_delete(mcSwFlowId_entry->swFlowIdx);
					}
				}

				if(needAddDev)
				{
					//send dummy packet by flow for add port purpose
					IGMP("send dummy packet");
					rtk_fc_abstrSwflow_sendMcDummyPkt(mcSwFlowId_entry);
					mcSwFlowId_entry->dummySyncTimes=0;
					rtk_fc_igmp_setupmcDummyPktDetectorTimer();
				}
			
			}
			
		}
	}

	return SUCCESS;

}


int32 _rtk_fc_igmp_mc_get_devConfig(rt_igmp_group_devPort_cfg_t *mcConfig)
{
	uint8 isipv6 = mcConfig->is_ipv6;
	uint32 *gip = NULL;
	uint32 *sip = NULL;
	int32 ingress_cvid = FAIL;
	int i;

	gip = (uint32*)&(mcConfig->group_addr.ipv6[0]);
	if(gip[0]==0 && gip[1]==0 && gip[2]==0 && gip[3]==0)
		gip=NULL;
	if(mcConfig->careSourceAddress)
		sip = (uint32*)&(mcConfig->source_addr.ipv6[0]);

	if(mcConfig->ingress_ctagif)
		ingress_cvid=mcConfig->ingress_cvid;


	if(mcConfig->is_ipv6)
	{
		IGMP("get groupBehavior:%d is_ipv6=%d cntEgrInfo=%d careSip/careVid=[%d/%d] group_addr=%pI6 source_addr=%pI6 tagif[%d]ingressVid=%d "
			,mcConfig->groupBehavior,mcConfig->is_ipv6,mcConfig->cntEgrInfo,mcConfig->careSourceAddress,mcConfig->careIngressCvid,&mcConfig->group_addr.ipv6[0],&mcConfig->source_addr.ipv6[0],mcConfig->ingress_ctagif,mcConfig->ingress_cvid);		
	}
	else
	{
		IGMP("get groupBehavior:%d is_ipv6=%d cntEgrInfo=%d careSip/careVid=[%d/%d] group_addr=%pI4h source_addr=%pI4h tagif[%d]ingressVid=%d "
			,mcConfig->groupBehavior,mcConfig->is_ipv6,mcConfig->cntEgrInfo,mcConfig->careSourceAddress,mcConfig->careIngressCvid,&mcConfig->group_addr.ipv4,&mcConfig->source_addr.ipv4,mcConfig->ingress_ctagif,mcConfig->ingress_cvid);
	}

	if(gip && (mcConfig->groupBehavior==RT_MC_BEHAVIOR_FLOW_FORWAED))
	{
		rtk_fc_table_mcConfigTbl_t *mcSetEntry;
		
		mcSetEntry = rtk_fc_mc_findMcConfig(isipv6,gip,mcConfig->careSourceAddress,sip,mcConfig->careIngressCvid,ingress_cvid);
		if(mcSetEntry == NULL)
			return FAIL;

		for(i=0;i<mcSetEntry->cnt_egrInfo;i++)
		{
			if(mcConfig->egrInfoType==EGRINFO_PID)
			{
				mcConfig->egrInfo.portId[i].isWlan=mcSetEntry->egrInfo[i].isWlan;
				if(mcConfig->egrInfo.portId[i].isWlan)
				{

					rt_wlan_mbssid_index_t mbssidIdx;
					rt_wlan_index_t wlanIdx;
					rtk_fc_wlan_devmask_t wlanDevIdMask;
					rt_wlan_mbssid_mask_t wlanMbssidMask[RT_WLAN_DEVICE_MAX];
					wlanDevIdMask = ((rtk_fc_wlan_devmask_t)1) << mcSetEntry->egrInfo[i].portId;
					rtk_fc_wlan_devMask_to_rtmbssidMask(&wlanDevIdMask,wlanMbssidMask);
					for(wlanIdx=0 ; wlanIdx<RT_WLAN_DEVICE_MAX ; wlanIdx++)
					{
						for(mbssidIdx=0;mbssidIdx<RT_WLAN_MBSSID_MAX;mbssidIdx++)
						{
							if(wlanMbssidMask[wlanIdx] & (1<<mbssidIdx))
							{
								mcConfig->egrInfo.portId[i].wlan.wlanDevIdx = wlanIdx;
								mcConfig->egrInfo.portId[i].wlan.wlanMbssid = mbssidIdx;
							}
						}
					}
				}
				else
				{
					mcConfig->egrInfo.portId[i].phyPortIdx=mcSetEntry->egrInfo[i].portId;
				}
			}
			else
			{
				mcConfig->egrInfo.devIfidx[i].ifindex=mcSetEntry->egrInfo[i].ifidx;
			}

		}
		mcConfig->cntEgrInfo = mcSetEntry->cnt_egrInfo;
	}

	return FAILED;
}


int32 _rtk_fc_igmp_mc_set_dev_to_dirver(rt_igmp_group_devPort_cfg_t *mcConfig)
{
	uint8 isipv6 = mcConfig->is_ipv6;
	uint32 *gip = NULL;
	uint32 *sip = NULL;
	int32 ingress_cvid = FAIL;
	int i,j;
	struct net_device *dev=NULL;
	rtk_fc_realdev_t rdev;
	rtk_fc_wlan_devidx_t wlanIdx=RTK_FC_WLANX_NOT_FOUND;
	uint32 hitSame=0;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcTmpSwFlowId_entry=NULL;

	gip = (uint32*)&(mcConfig->group_addr.ipv6[0]);
	if(gip[0]==0 && gip[1]==0 && gip[2]==0 && gip[3]==0)
		gip=NULL;
	if(mcConfig->careSourceAddress)
		sip = (uint32*)&(mcConfig->source_addr.ipv6[0]);

	if(mcConfig->ingress_ctagif)
		ingress_cvid=mcConfig->ingress_cvid;


	if(mcConfig->is_ipv6)
	{
		IGMP("set groupBehavior:%d is_ipv6=%d cntEgrInfo=%d careSip/careVid=[%d/%d] group_addr=%pI6 source_addr=%pI6 tagif[%d]ingressVid=%d "
			,mcConfig->groupBehavior,mcConfig->is_ipv6,mcConfig->cntEgrInfo,mcConfig->careSourceAddress,mcConfig->careIngressCvid,&mcConfig->group_addr.ipv6[0],&mcConfig->source_addr.ipv6[0],mcConfig->ingress_ctagif,mcConfig->ingress_cvid);		
	}
	else
	{
		IGMP("set groupBehavior:%d is_ipv6=%d cntEgrInfo=%d careSip/careVid=[%d/%d] group_addr=%pI4h source_addr=%pI4h tagif[%d]ingressVid=%d "
			,mcConfig->groupBehavior,mcConfig->is_ipv6,mcConfig->cntEgrInfo,mcConfig->careSourceAddress,mcConfig->careIngressCvid,&mcConfig->group_addr.ipv4,&mcConfig->source_addr.ipv4,mcConfig->ingress_ctagif,mcConfig->ingress_cvid);
	}
	for(j=0;j<mcConfig->cntEgrInfo;j++)
	{
	
		if(mcConfig->egrInfoType==EGRINFO_DEVIFIDX)
		{
			RTK_FC_HOOK_PS_DEV_GET_BY_INDEX(&init_net,mcConfig->egrInfo.devIfidx[j].ifindex,&dev);
			if(dev)
			{
				if(RTK_FC_HOOK_PS_DEV_GET_REALDEV_PHYPORT(dev,&rdev)!=FAIL)
				{
					IGMP("\t %s[Ifidx:%d]=>[Port:%d] ",dev->name,mcConfig->egrInfo.devIfidx[j].ifindex,rdev.physicalPid);
				}
				else if(RTK_FC_HELPER_WLAN_DEV_TO_DEVID(dev,&wlanIdx)!=FAIL)
				{
					IGMP("\t %s[Ifidx:%d]=>[WlanIdx:%d] ",dev->name,mcConfig->egrInfo.devIfidx[j].ifindex,wlanIdx);
				}
			}
		}
		else
		{
			if(mcConfig->egrInfo.portId[j].isWlan)
			{
				IGMP("\t [WLANPort][DEVIDX=%d][MBSSID=%d]",mcConfig->egrInfo.portId[j].wlan.wlanDevIdx,mcConfig->egrInfo.portId[j].wlan.wlanMbssid);

			}
			else
				IGMP("\t [PHYPort:%d]",mcConfig->egrInfo.portId[j].phyPortIdx);
		}
	}		


	if(gip)
	{
		if(mcConfig->groupBehavior==RT_MC_BEHAVIOR_FLOW_FORWAED)
		{
			rtk_fc_table_mcConfigTbl_t *mcSetEntry;

			mcSetEntry = rtk_fc_mc_findMcConfig(isipv6,gip,mcConfig->careSourceAddress,sip,mcConfig->careIngressCvid,ingress_cvid);
			if(mcSetEntry == NULL)
			{
				if(mcConfig->cntEgrInfo!=0)
				{
					//new a entry
					mcSetEntry = rtk_fc_mc_mallocMcConfig(isipv6,gip,mcConfig->careSourceAddress,sip,mcConfig->careIngressCvid,ingress_cvid);				
				}
				else
				{
					IGMP("delete a non-exist entry do nothing and return");
					return FAIL;
				}
			}

			if(mcSetEntry == NULL)
				return FAIL;
			
			for(i=0;i<mcSetEntry->cnt_egrInfo;i++)
			{
				hitSame=0;
				for(j=0;j<mcConfig->cntEgrInfo;j++)
				{
					
					if(mcConfig->egrInfoType==EGRINFO_PID)
					{
						if(   (mcConfig->egrInfo.portId[j].isWlan==1 && mcSetEntry->egrInfo[i].isWlan==1 &&  (mcSetEntry->egrInfo[i].portId == rtk_fc_wlan_rtmbssid_to_devidx(mcConfig->egrInfo.portId[j].wlan.wlanDevIdx,mcConfig->egrInfo.portId[j].wlan.wlanMbssid))) 
							||(mcConfig->egrInfo.portId[j].isWlan==0 && mcSetEntry->egrInfo[i].isWlan==0 &&  (mcSetEntry->egrInfo[i].portId == mcConfig->egrInfo.portId[j].phyPortIdx)))
						{
							hitSame=1;
							mcSetEntry->egrInfo[i].status=PORT_STATUS_UPDATE_DONE;
							//using resv0 to do a mark which handle done
							mcConfig->egrInfo.portId[j].resv0=1;
							IGMP("Ignore [%s]Port %d",mcSetEntry->egrInfo[i].isWlan?"WLAN":"PHY",mcSetEntry->egrInfo[i].portId);
							break;
						}
					}
					else
					{
						if( mcConfig->egrInfo.devIfidx[j].ifindex == mcSetEntry->egrInfo[i].ifidx) //send to same dev not a diff
						{
							hitSame=1;
							mcSetEntry->egrInfo[i].status=PORT_STATUS_UPDATE_DONE;
							//using resv0 to do a mark which handle done
							mcConfig->egrInfo.devIfidx[j].resv0=1;								
							IGMP("Ignore Port %d ifidx:%d",mcSetEntry->egrInfo[i].portId,mcSetEntry->egrInfo[i].ifidx);
							break;
						}
					}

				}
				if(!hitSame)
				{
					//entry not found in new config , we mark this to delete
					mcSetEntry->egrInfo[i].status=PORT_STATUS_SHOULD_BE_DELETE;
					IGMP("Del [%s]Port %d ifidx:%d",mcSetEntry->egrInfo[i].isWlan?"WLAN":"PHY",mcSetEntry->egrInfo[i].portId,mcSetEntry->egrInfo[i].ifidx);
				}
			}
			for(j=0;j<mcConfig->cntEgrInfo;j++)
			{
				//entry not handle , we mark this to add
				if(    (mcConfig->egrInfoType==EGRINFO_PID && !mcConfig->egrInfo.portId[j].resv0)
					|| ((mcConfig->egrInfoType==EGRINFO_DEVIFIDX && !mcConfig->egrInfo.devIfidx[j].resv0)))
				{
					
					if(mcConfig->egrInfoType==EGRINFO_PID)
					{
						mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].isWlan = mcConfig->egrInfo.portId[j].isWlan;
						if(!mcConfig->egrInfo.portId[j].isWlan)
						{
							//phyPort
							mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].isWlan=0;
							mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].portId = mcConfig->egrInfo.portId[j].phyPortIdx;
						}
						else
						{
							//wlan
							mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].isWlan=1;
							mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].portId = rtk_fc_wlan_rtmbssid_to_devidx(mcConfig->egrInfo.portId[j].wlan.wlanDevIdx,mcConfig->egrInfo.portId[j].wlan.wlanMbssid);
						}
						IGMP("Add Port:%d wlan:%d ",mcConfig->egrInfo.portId[j].phyPortIdx,mcConfig->egrInfo.portId[j].isWlan);
						mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].ifidx=FAIL;
					}
					else
					{
						mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].ifidx=mcConfig->egrInfo.devIfidx[j].ifindex;
						RTK_FC_HOOK_PS_DEV_GET_BY_INDEX(&init_net,mcConfig->egrInfo.devIfidx[j].ifindex,&dev);
						if(dev)
						{
							if(RTK_FC_HOOK_PS_DEV_GET_REALDEV_PHYPORT(dev,&rdev)!=FAIL)
							{
								//phyPort
								mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].isWlan=0;
								mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].portId = rdev.physicalPid;
							}
							else if(RTK_FC_HELPER_WLAN_DEV_TO_DEVID(dev,&wlanIdx)!=FAIL)
							{
								//wlan
								mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].isWlan=1;
								mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].portId = wlanIdx;
							}
						}
					}
					mcSetEntry->egrInfo[mcSetEntry->cnt_egrInfo].status=PORT_STATUS_SHOULD_BE_ADD;
					mcSetEntry->cnt_egrInfo++;
				}
			}


			rtk_fc_igmp_applyMcConfig_abstrSwFlow(mcSetEntry);
			rtk_fc_igmp_renewMcConfig(mcSetEntry);

			if(mcConfig->cntEgrInfo==0)
				rtk_fc_mc_delMcConfig(mcSetEntry);


		}
		else if(mcConfig->groupBehavior==RT_MC_BEHAVIOR_GROUP_AS_KNOW)
		{
			if(rtk_fc_mc_addKnownGroupEntry(isipv6,gip)==NULL)
			{
				WARNING("IGMP Table FULL");
				return FAILED;
			}			
		}
		else if(mcConfig->groupBehavior==RT_MC_BEHAVIOR_GROUP_AS_UNKNOW)
		{
		
			//delete  knowGroup
			rtk_fc_table_mcGroupTbl_t *groupTbl=rtk_fc_mc_findKnownGroupEntry(isipv6,gip);
			if(groupTbl)
			{
				//we need flush flow table for this group (snooping disable and igmpporxy enable  )
				for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
				{				
					list_for_each_entry_safe(mcSwFlowId_entry,mcTmpSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
					{
						if(memcmp(mcSwFlowId_entry->multicastAddress,gip,sizeof(mcSwFlowId_entry->multicastAddress))==0 && mcSwFlowId_entry->isIpv6==isipv6)
						{
							rtk_fc_flow_delete(mcSwFlowId_entry->swFlowIdx);
						}
					}
				}
				rtk_fc_mc_delKnownGroupEntry(groupTbl);
			}
		
		}
		else if(mcConfig->groupBehavior==RT_MC_CHECK_UNKNOWN_FLOOD_FLOW)
		{
			rtk_fc_table_mcConfigTbl_t *mcSetEntry;	

			mcSetEntry = rtk_fc_mc_findMcConfig(isipv6,gip,mcConfig->careSourceAddress,sip,mcConfig->careIngressCvid,ingress_cvid);
			if(mcSetEntry == NULL)
				return FAIL;
				
			mcConfig->floodFlowDelete = rtk_fc_igmp_checkFlow(mcSetEntry);
			return SUCCESS; 
		}
		else if(mcConfig->groupBehavior==RT_MC_BEHAVIOR_FLOW_UPDATE)
		{
			rtk_fc_table_mcConfigTbl_t *mcSetEntry;
			
			mcSetEntry = rtk_fc_mc_findMcConfig(isipv6,gip,mcConfig->careSourceAddress,sip,mcConfig->careIngressCvid,ingress_cvid);
			if(mcSetEntry == NULL)
				return FAIL;

			rtk_fc_igmp_mcConfig_abstrSwFlow_sendDummy(mcSetEntry);

		}
		
	}
	else
	{
		IGMP("Group NULL Flush Mc abstrsw mc flow Table");
		for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
		{
			list_for_each_entry_safe(mcSwFlowId_entry,mcTmpSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
			{
					rtk_fc_flow_delete(mcSwFlowId_entry->swFlowIdx);
			}
		}
		for(i=0;i<RTK_FC_TABLESIZE_MCFLOW;i++)
		{
			if(!fc_db.mcCfgTbl[i].valid)
				continue;
			rtk_fc_mc_delMcConfig(&fc_db.mcCfgTbl[i]);
		}
	}
	return SUCCESS;
}



int32 _rtk_fc_igmp_mc_set_to_dirver(rt_igmp_multicast_group_cfg_t *mcConfig)
{
	/*transfer rt_igmp_multicast_group_cfg_t to rt_igmp_group_devPort_cfg_t	and calling  _rtk_fc_igmp_mc_set_dev_to_dirver */
	int i,j;
	int devCnt=0;
	rtk_fc_wlan_devmask_t p3_wlanMask=0,p4_wlanMask=0;

	rt_igmp_group_devPort_cfg_t sw_mcConfig;


	//error check
	if(mcConfig->first_act_portmask & mcConfig->second_act_portmask)
		return FAIL;

	bzero(&sw_mcConfig,sizeof(sw_mcConfig));

	sw_mcConfig.is_ipv6 =  mcConfig->is_ipv6;
	sw_mcConfig.careIngressCvid = mcConfig->careIngressCvid;
	sw_mcConfig.careSourceAddress = mcConfig->careSourceAddress;
	sw_mcConfig.groupBehavior = mcConfig->groupBehavior;
	sw_mcConfig.ingress_ctagif = mcConfig->ingress_ctagif;
	sw_mcConfig.ingress_cvid =  mcConfig->ingress_cvid;

	sw_mcConfig.egrInfoType = EGRINFO_PID;

	memcpy(sw_mcConfig.group_addr.ipv6,mcConfig->group_addr.ipv6,sizeof(mcConfig->group_addr.ipv6));
	memcpy(sw_mcConfig.source_addr.ipv6,mcConfig->source_addr.ipv6,sizeof(mcConfig->source_addr.ipv6));
	
	rtk_fc_wlan_rtmbssidMask_to_devMask(mcConfig->first_act_wlanMbssidMask,&p3_wlanMask);
	rtk_fc_wlan_rtmbssidMask_to_devMask(mcConfig->second_act_wlanMbssidMask,&p4_wlanMask);


	for(i=0;i<31 /*(rt_port_phy_port_mask_t)int32  max 31 bit pmsk */;i++)
	{
		if((1<<i) & mcConfig->first_act_portmask)
		{
			sw_mcConfig.egrInfo.portId[devCnt].isWlan=0;
			sw_mcConfig.egrInfo.portId[devCnt].phyPortIdx = i;
			devCnt++;
		}
		if((1<<i) & mcConfig->second_act_portmask)
		{
			sw_mcConfig.egrInfo.portId[devCnt].isWlan=0;
			sw_mcConfig.egrInfo.portId[devCnt].phyPortIdx = i;
			devCnt++;
		}
	}
	for(i=0;i<RT_WLAN_DEVICE_MAX;i++)
	{

		for(j=0;j<RT_WLAN_MBSSID_MAX;j++)
		{
			if(mcConfig->first_act_wlanMbssidMask[i] & (1<<j))
			{
				sw_mcConfig.egrInfo.portId[devCnt].isWlan=1;
				sw_mcConfig.egrInfo.portId[devCnt].wlan.wlanDevIdx=i;
				sw_mcConfig.egrInfo.portId[devCnt].wlan.wlanMbssid =j;
				devCnt++;
			}
		}
		
	}
	sw_mcConfig.cntEgrInfo = devCnt;

	_rtk_fc_igmp_mc_set_dev_to_dirver(&sw_mcConfig);

	if(sw_mcConfig.groupBehavior==RT_MC_CHECK_UNKNOWN_FLOOD_FLOW)
		mcConfig->floodFlowDelete = sw_mcConfig.floodFlowDelete;
	return SUCCESS;

}



#define UCIGMP_ADD 0
#define UCIGMP_DEL 1

rtk_fc_ret_t _rtk_fc_ucIGMPflowModify_passthroughMc(rtk_fc_pktHdr_t *pPktHdr,rtk_fc_pmap_t  igrPortMap,rtk_fc_wlan_devidx_t igrWlanDevIdx,uint32* group,uint32 addZero_delOne)
{
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

	int i;
	uint32 groupHash=0;
	rtk_rg_asic_path3_entry_t p3Data;
	uint32 modify_phymsk= 1<< igrPortMap.macPortIdx;
	uint32 modify_extdevMask = (1LL << igrWlanDevIdx);
	rtk_fc_ext_port_mask_t modify_extPmsk=0;
	uint32 ori_extPmsk,ori_phymsk;
	uint32 final_extMask,final_phymsk;
	uint32 p3_oldExtpmskIdx=0,p3_extPmskIdx=0;
	
	//not passthrough unicast multicast
	if(pPktHdr->isMulticast!=0)
		return RTK_FC_RET_OK;

	//bypass search flow if unknow_da (avoid attack igmp packets cause cpu 100%)
	if(pPktHdr->dmacL2Idx==FAIL)
		return RTK_FC_RET_OK;


	for(i=0;i<(RTK_FC_TABLESIZE_HW_FLOW + RTK_FC_MAX_SHORTCUT_FLOW_SIZE);i++)
	{
		if(fc_db.flowTbl[i].pFlowEntry->path3.valid && fc_db.flowTbl[i].pFlowEntry->path3.in_path==FB_PATH_34 )
		{
			ori_extPmsk=0;
			ori_phymsk=0;
			p3_oldExtpmskIdx=0;
			p3_extPmskIdx=0;
			modify_extPmsk=0;

			if(pPktHdr->ip6h && fc_db.flowTbl[i].pFlowEntry->path3.in_ipv4_or_ipv6 ==1)
				groupHash = _rtk_rg_flowHashIPv6DstAddr_get((uint8 *)group);
			else if(pPktHdr->iph && fc_db.flowTbl[i].pFlowEntry->path3.in_ipv4_or_ipv6 ==0 )
				groupHash = group[0];
			else
				continue;
			
			//both v4 & v6
			if(groupHash == fc_db.flowTbl[i].pFlowEntry->path3.in_dst_ipv4_addr)
			{
				memcpy(&p3Data, &fc_db.flowTbl[i].pFlowEntry->path3, sizeof(rtk_rg_asic_path3_entry_t));
				_rtk_fc_sharing_image_flow_structure_convert((rtk_rg_asic_path1_entry_t *)&p3Data);


				if ( igrWlanDevIdx!=RTK_FC_WLANX_NOT_FOUND)
				{
					if(p3Data.out_ext_portmask_idx)
					{
						p3_oldExtpmskIdx = p3Data.out_ext_portmask_idx;
						ori_extPmsk = fc_db.extPortTbl[p3Data.out_ext_portmask_idx].extPortEnt.extpmask;
					}

					RTK_FC_HELPER_WLAN_DEVMASK_TO_EXTPORMASK(modify_extdevMask, &modify_extPmsk);

					if(addZero_delOne==UCIGMP_ADD)
						final_extMask = ori_extPmsk | modify_extPmsk;
					else
						final_extMask = ori_extPmsk & (~modify_extPmsk);

					if(ori_extPmsk != final_extMask )
					{
						IGMP("FLOW[%d] extpmsk 0x%x -> 0x%x by passthrough igmp packet",i,ori_extPmsk,final_extMask);

						if(RTK_RG_ASIC_EXTPORTMASKTABLE_ADD(final_extMask,&p3_extPmskIdx)!=RTK_FC_RET_OK)
						{
							WARNING("RTK_RG_ASIC_EXTPORTMASKTABLE_ADD ret FAILED");
							continue;
						}
						
						p3Data.out_ext_portmask_idx = p3_extPmskIdx;
						
						ASSERT_EQ(RTK_RG_ASIC_FLOWPATH_SET(&i, &p3Data, NULL, FLOW_INFO_IS_SET(&fc_db.flowTbl[i], FLOW_INFO_SOFTWARE_ONLY)), RTK_FC_RET_OK);

						if(RTK_RG_ASIC_EXTPORTMASKTABLE_DEL(p3_oldExtpmskIdx)!=RTK_FC_RET_OK)
						{
							WARNING("RTK_RG_ASIC_EXTPORTMASKTABLE_DEL ret FAILED");
							continue;
						}	
					}
				}
				else if(modify_phymsk)
				{
					ori_phymsk = p3Data.out_portmask;
					
					if(addZero_delOne==UCIGMP_ADD)
						final_phymsk =  ori_phymsk | modify_phymsk;
					else
						final_phymsk =  ori_phymsk & (~modify_phymsk);

					if(ori_phymsk != final_phymsk)
					{
						p3Data.out_portmask = final_phymsk;
						IGMP("FLOW[%d] pmsk 0x%x -> 0x%x by passthrough igmp packet",i,ori_phymsk,final_phymsk);
						ASSERT_EQ(RTK_RG_ASIC_FLOWPATH_SET(&i, &p3Data, NULL, FLOW_INFO_IS_SET(&fc_db.flowTbl[i], FLOW_INFO_SOFTWARE_ONLY)), RTK_FC_RET_OK);
					}
				}
				
			}

		}
	}
#endif

	return RTK_FC_RET_OK;
	
}

#define FC_IS_CLASSD_ADDR(ipv4addr)				((((uint32)(ipv4addr)) & 0xf0000000) == 0xe0000000)

//portMask is single port
rtk_fc_ret_t _rtk_fc_igmp_mld_ingressLan_learning(rtk_fc_pktHdr_t *pPktHdr,rtk_fc_pmap_t  igrPortMap, rtk_fc_wlan_devidx_t igrWlanDevIdx)
{
	struct igmpv3_report *ih;
	struct igmpv3_grec *grec;
	struct mld2_grec *grecmld;
	int i;
	int len=0;
	int numGrp;
	int type;
	__be32 _group[4]={0};
	unsigned char mac[6]={0};
	int16 mcidx=-1;
	uint32 _lanPortMask =0;
	uint16 grec_nsrcs = 0;

	//skip normal packet
	if(pPktHdr->igmph==NULL && pPktHdr->icmp6h==NULL)
	{
		//IGMP("IGMP Skip non igmph/icmp6h packet");
		return RTK_FC_RET_OK;
	}
	
	if( (pPktHdr->isFragment) ||
		(pPktHdr->iph && (!FC_IS_CLASSD_ADDR(ntohl(pPktHdr->iph->daddr)))) || 
		(pPktHdr->ip6h && pPktHdr->ip6h->daddr.in6_u.u6_addr8[0]!=0xff)) 
	{
		IGMP("IGMP strange packet");return RTK_FC_RET_OK;
	}

	_lanPortMask = fc_db.lanPortMask.portmask;

	if(pPktHdr->igmph  && ( ((1<<igrPortMap.macPortIdx) &  _lanPortMask) || (igrWlanDevIdx < RTK_FC_WLANX_END_INTF)))
	{

		if(pPktHdr->igmph->type==IGMP_HOST_MEMBERSHIP_REPORT || pPktHdr->igmph->type==IGMPV2_HOST_MEMBERSHIP_REPORT)
		{
			_group[0] = ntohl(pPktHdr->igmph->group);
			if(!FC_IS_CLASSD_ADDR(_group[0])){IGMP("IGMP Error packet");
				return RTK_FC_RET_OK;}
			_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_ADD);
			IGMP("receive IGMPv1/IGMPv2 Report packet at LANPort[%d]! WLANDEVID[%d]! Group=%pI4h lutidx=%d",igrPortMap.macPortIdx, igrWlanDevIdx, &_group[0],mcidx);
		}
		else if (pPktHdr->igmph->type==IGMPV3_HOST_MEMBERSHIP_REPORT)
		{
			ih =(struct igmpv3_report *)pPktHdr->igmph;
			numGrp = ntohs(ih->ngrec);
			if(numGrp>8){IGMP("skip large numberGrp search to avoid attack");return RTK_FC_RET_OK;}
		
			grec = ih->grec ;
			for (i = 0; i < numGrp; i++)
			{
				_group[0] = ntohl(grec->grec_mca);
				_rtk_fc_groupLSB32_to_mac(mac,0,_group[0]);

				type = grec->grec_type;
				grec_nsrcs = ntohs(grec->grec_nsrcs);
				
				if(!FC_IS_CLASSD_ADDR(_group[0])){IGMP("IGMP Error packet");return RTK_FC_RET_OK;}			
				if(grec_nsrcs>8){IGMP("skip large grec_nsrcs search to avoid attack");return RTK_FC_RET_OK;}


				len =  (8 + ntohs(grec->grec_nsrcs)*4 + ntohs(grec->grec_auxwords)*4) ;
				grec = ((void*)grec) +len;

				if ((type == IGMPV3_CHANGE_TO_INCLUDE ||
					type == IGMPV3_MODE_IS_INCLUDE) &&
					grec_nsrcs == 0)
				{
					_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_DEL);
					IGMP("receive a IGMP leave packet form LANPort[%d]!! WLANDEVID[%d]!! Group=%pI4h ", igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
				}
				else
				{
					_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_ADD);
					IGMP("receive IGMPv3 Report packet at LANPort[%d]!! WLANDEVID[%d]!! Group=%pI4h", igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
				}
			}
		}
		else if (pPktHdr->igmph->type==IGMP_HOST_LEAVE_MESSAGE)
		{
			_group[0] = ntohl(pPktHdr->igmph->group);
			_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_DEL);
			IGMP("receive a IGMP leave packet form LANPort[%d]!! WLANDEVID[%d]!! Group=%pI4h ", igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
		}

	}
	else if (pPktHdr->icmp6h && (((1<<igrPortMap.macPortIdx) & _lanPortMask) || (igrWlanDevIdx < RTK_FC_WLANX_END_INTF)))
	{
		memcpy(_group, ((void*)pPktHdr->icmp6h)+8 ,sizeof(_group));
		if(pPktHdr->icmp6h->icmp6_type ==ICMPV6_MGM_REPORT )
		{
			if((_group[0]&0xff000000) !=0xff000000){IGMP("MLD Error packet");return RTK_FC_RET_OK;}
			
			_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_ADD);
			IGMP("receive MlDv1 Report packet at LANPort[%d]! WLANDEVID[%d]! Group=%pI6",igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
		}
		else if (pPktHdr->icmp6h->icmp6_type ==ICMPV6_MLD2_REPORT )
		{
			numGrp = ntohs(pPktHdr->icmp6h->icmp6_dataun.un_data16[1]);
			if(numGrp>8){IGMP("skip large numberGrp search to avoid attack");return RTK_FC_RET_OK;}
			
			grecmld = ((void*)pPktHdr->icmp6h)+8 ;
			for (i = 0; i < numGrp; i++)
			{
				memcpy(_group,grecmld->grec_mca.s6_addr,sizeof(_group));
				_rtk_fc_groupLSB32_to_mac(mac,1,_group[3]);
				type = grecmld->grec_type;
				grec_nsrcs = ntohs(grecmld->grec_nsrcs);
				
				if((_group[0]&0xff000000) !=0xff000000){IGMP("MLD Error packet");return RTK_FC_RET_OK;}
				if(grec_nsrcs>8){IGMP("skip large grec_nsrcs search to avoid attack");return RTK_FC_RET_OK;}

				len =  (20 + ntohs(grecmld->grec_nsrcs)*4 + ntohs(grecmld->grec_auxwords)*4) ;
				grecmld = ((void*)grecmld) +len;

				if ((type == MLD2_CHANGE_TO_INCLUDE ||
					type == MLD2_MODE_IS_INCLUDE) &&
					grec_nsrcs == 0)
				{
					_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_DEL);
					IGMP("receive a MLD leave packet form LANPort[%x]! WLANDEVID[%d]! Group=%pI6 ",igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
				}
				else
				{
					_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_ADD);
					IGMP("receive MlDv2 Report packet at LANPort[%x]! WLANDEVID[%d]! Group=%pI6",igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
				}
			}
		}
		else if (pPktHdr->icmp6h->icmp6_type ==ICMPV6_MGM_REDUCTION )
		{
			memcpy(_group, ((void*)pPktHdr->icmp6h)+8 ,sizeof(_group));
			_rtk_fc_ucIGMPflowModify_passthroughMc(pPktHdr,igrPortMap,igrWlanDevIdx,_group,UCIGMP_DEL);
			IGMP("receive a MLD leave packet form LANPort[%x]! WLANDEVID[%d]! Group=%pI6 ",igrPortMap.macPortIdx,igrWlanDevIdx,&_group[0]);
		}
		else
		{
			//not mld packet
			return RTK_FC_RET_LRN_SKIP_ICMPv6;
		}
	}
	else {

		return RTK_FC_RET_OK;
	}


	return RTK_FC_RET_LRN_SKIP_IGMP_MLD;


}


int rtk_fc_igmp_mld_dirver_show(struct seq_file *s, void *v)
{
	int i;

	PROC_PRINTF("KNOWN GROUP LIST:\n");

	for(i=0 ; i<RTK_FC_TABLESIZE_MCFLOW ;i++)
	{
		if(!fc_db.mcGroupTbl[i].valid)
			continue;
	
		if(fc_db.mcGroupTbl[i].isIpv6)
		{
			PROC_PRINTF("[%d]GroupAddress [%pI6] refCnt=%d \n",
				i,fc_db.mcGroupTbl[i].mcGroup,fc_db.mcGroupTbl[i].groupRefCnt);
		}
		else
		{
			PROC_PRINTF("[%d]GroupAddress [%pI4h] refCnt=%d \n",
				i,&fc_db.mcGroupTbl[i].mcGroup[0],fc_db.mcGroupTbl[i].groupRefCnt);
		}
		PROC_PRINTF("\t hwIdx=%d ",fc_db.mcGroupTbl[i].hwIdx);
		PROC_PRINTF("\n");
	
	}
	PROC_PRINTF("==============================\n");
	PROC_PRINTF("CONFIG LIST:\n");
	
	for(i=0 ; i<RTK_FC_TABLESIZE_MCFLOW ;i++)
	{
		if(!fc_db.mcCfgTbl[i].valid)
			continue;

		if(fc_db.mcCfgTbl[i].isIpv6)
		{
			PROC_PRINTF("[%d]GroupAddress [%pI6]   <== (carebit:%d)SourceAddr [%pI6]  (carebit:%d)IngressCvid[%d]\n",
				i,fc_db.mcCfgTbl[i].confGroup,fc_db.mcCfgTbl[i].careSource, fc_db.mcCfgTbl[i].confSource,fc_db.mcCfgTbl[i].careIngressCvid,fc_db.mcCfgTbl[i].confIgrCvid);
			PROC_PRINTF("\t hwIdx=%d ",fc_db.mcGroupTbl[i].hwIdx);
		}
		else
		{
			PROC_PRINTF("[%d]GroupAddress [%pI4h]   <== (carebit:%d)SourceAddr [%pI4h]  (carebit:%d)IngressCvid[%d]\n",
				i,&fc_db.mcCfgTbl[i].confGroup,fc_db.mcCfgTbl[i].careSource,&fc_db.mcCfgTbl[i].confSource,fc_db.mcCfgTbl[i].careIngressCvid,fc_db.mcCfgTbl[i].confIgrCvid);
		}
{
		int j;
		struct net_device *dev=NULL;
		rtk_fc_realdev_t rdev;
		PROC_PRINTF("\t");
		for(j=0;j<fc_db.mcCfgTbl[i].cnt_egrInfo;j++)
		{

			if(fc_db.mcCfgTbl[i].egrInfo[j].ifidx!=FAIL)
			{
				RTK_FC_HOOK_PS_DEV_GET_BY_INDEX(&init_net,fc_db.mcCfgTbl[i].egrInfo[j].ifidx,&dev);
				if(dev)
				{
					RTK_FC_HOOK_PS_DEV_GET_REALDEV_PHYPORT(dev,&rdev);
					if(fc_db.mcCfgTbl[i].egrInfo[j].isWlan)
						PROC_PRINTF(" [WlanPort:%d(%s ifidx=%d)] ",fc_db.mcCfgTbl[i].egrInfo[j].portId,dev->name,fc_db.mcCfgTbl[i].egrInfo[j].ifidx);
					else
						PROC_PRINTF(" [Port:%d(%s ifidx=%d)] ",fc_db.mcCfgTbl[i].egrInfo[j].portId,dev->name,fc_db.mcCfgTbl[i].egrInfo[j].ifidx);

				}
			}
			else
			{
				if(fc_db.mcCfgTbl[i].egrInfo[j].isWlan)
					PROC_PRINTF(" [WlanPort:%d] ",fc_db.mcCfgTbl[i].egrInfo[j].portId);
				else
					PROC_PRINTF(" [Port:%d] ",fc_db.mcCfgTbl[i].egrInfo[j].portId);
			}
		}
		PROC_PRINTF("\n");
}

	}

	PROC_PRINTF("==============================\n");
	PROC_PRINTF("FLOW LIST:\n");

	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{
		rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
		list_for_each_entry(mcSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			PROC_PRINTF("[%d]swMcFlow["COLOR_Y"%d"COLOR_NM"]:\n",mcSwFlowId_entry->entryIdx,mcSwFlowId_entry->swFlowIdx);
			dump_abstrSwFlowPatten_table(s,v,fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].pAbstrSwFlowEt);
		}
	}
	return SUCCESS;

}


int32 _rtk_fc_igmp_mld_show_group_info(uint32 isIpv6,uint32 * groupip,uint32 p3PortMask, rtk_fc_wlan_devmask_t p3WlanMask,int32 p3Cvid,uint8 p3Cpri,uint32 p4PortMask, rtk_fc_wlan_devmask_t p4WlanMask,int32 p4Cvid,uint8 p4Cpri,uint32 careIngressCvid,int32 ingress_cvid,uint32 careSip,uint32 * sip)
{

	if(isIpv6==0) {
		rtlglue_printf("Group_v4 %pI4h \n", groupip);
		rtlglue_printf("\t PortMask = %x WlanDevMask = %llx\n",p3PortMask, p3WlanMask);

	}else {
		rtlglue_printf("Group_v6 %pI6 \n", groupip);
		rtlglue_printf("\t PortMask = %x WlanDevMask = %llx\n", p3PortMask, p3WlanMask);

	}

	return SUCCESS;
}



int32 rtk_fc_igmp_sendAllMcDummyPktDetector(unsigned long task_priv)
{
	int i;

	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{
		list_for_each_entry(mcSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			rtk_fc_abstrSwflow_sendMcDummyPkt(mcSwFlowId_entry);
		}
	}
	IGMP("rtk_fc_igmp_sendAllMcDummyPktDetector");

	return SUCCESS;
}


void rtk_fc_igmp_mcDummyPktDetectorConfigPort(unsigned long task_priv)
{
	int i;
	rtk_fc_mcExtraSwFlowIdx_entry_t *mcSwFlowId_entry=NULL;
	rtk_fc_abstrSwFlowActionList_entry_t *pTmpSwFlowAction;
	rtk_fc_abstrSwFlowLdpid_entry_t *pLdpid=NULL;
	uint32 portCnt=0;
	rtk_fc_table_mcConfigTbl_t *mcConfig=NULL;
	
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_LOCK_BH();

	for(i=0;i<TRACFILTER_MAX;i++)
	{
		if(fc_db.trace_filter_bitmask[i]&FC_DEBUG_TRACE_FILTER_DUMMYMC)
		{
			fc_db.tracefilterShow=1U;
		}
	}

	for (i =0 ; i< RTK_FC_TABLESIZE_MCFLOW_HASH; i++)
	{
		list_for_each_entry(mcSwFlowId_entry,&fc_db.listHead_mcExtraFlowIdxHashTbl[i],entry)
		{
			mcConfig=NULL;

			/* sent dummy packet 3 times , period for RTK_FC_IGMP_DUMYPKT_TICK_MSECONDMS */
			if(mcSwFlowId_entry->dummySyncTimes >= 3)
				continue;
			if(fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].pAbstrSwFlowEt==NULL)
				continue;

			//check config and abstr-port not sync
			mcConfig = rtk_fc_mc_searchMcConfigByPatten(mcSwFlowId_entry->isIpv6,mcSwFlowId_entry->multicastAddress,mcSwFlowId_entry->sourceAddress,mcSwFlowId_entry->ingressCvid);
			if(mcConfig==NULL)
				continue;
			
			portCnt=0;
			list_for_each_entry(pTmpSwFlowAction, &fc_db.flowTbl[mcSwFlowId_entry->swFlowIdx].pAbstrSwFlowEt->swFlowActionHdr, swFlowActionList)
			{
				list_for_each_entry(pLdpid, &pTmpSwFlowAction->ldpidListHdr, ldpidList)
				{
					portCnt++;
				}
			}

			//only care egress packet lose
			if(mcConfig->cnt_egrInfo > portCnt)
			{
				IGMP("mcConfig->cnt_egrInfo=%d and portCnt=%d not sync send dummy packet for flow[%d]",mcConfig->cnt_egrInfo,portCnt,mcSwFlowId_entry->swFlowIdx);
				rtk_fc_abstrSwflow_sendMcDummyPkt(mcSwFlowId_entry);
				mcSwFlowId_entry->dummySyncTimes++;
				rtk_fc_igmp_setupmcDummyPktDetectorTimer();
			}
			
		}
	}

	fc_db.tracefilterShow=0U;
	RTK_FC_HELPER_MGR_GLOBAL_SPIN_UNLOCK_BH();


	return;
}


void rtk_fc_igmp_setupmcDummyPktDetectorTimer(void)
{
	unsigned long int msec2jiffies=0;
		
	
	if(RTK_FC_HELPER_TIMER_PENDING(fc_db.igmpDummyPktDetectorTimer.igmpTimer))
	{
		IGMP("update igmpDummyPktDetectorTimer stop time");
		RTK_FC_HELPER_MSECS_TO_JIFFIES(fc_db.igmpDummyPktDetectorTimer.nextTimerPeriod, &msec2jiffies);
		//update stop time
		//fc_db.igmpDummyPktDetectorTimer.stopjiffies = jiffies + 3*msec2jiffies ;
	}
	else
	{
		IGMP("IGMP START a DummyPktDetectorTimer Timer");
		RTK_FC_HELPER_INIT_TIMER(fc_db.igmpDummyPktDetectorTimer.igmpTimer,rtk_fc_igmp_mcDummyPktDetectorConfigPort);
		RTK_FC_HELPER_SETUP_TIMER(fc_db.igmpDummyPktDetectorTimer.igmpTimer,rtk_fc_igmp_mcDummyPktDetectorConfigPort,(unsigned long)NULL);
		RTK_FC_HELPER_MSECS_TO_JIFFIES(fc_db.igmpDummyPktDetectorTimer.nextTimerPeriod, &msec2jiffies);
		//fc_db.igmpDummyPktDetectorTimer.stopjiffies = jiffies + 3*msec2jiffies+1 ;
		RTK_FC_HELPER_MOD_TIMER(fc_db.igmpDummyPktDetectorTimer.igmpTimer, jiffies+msec2jiffies);
	}

	return ;
}



#if defined(CONFIG_RTK_SOC_RTL8198D)

int _rtk_fc_add_lutMac(unsigned int*_group ,unsigned short isIpv6)
{
	unsigned char mac[6]={0};
	int16 mcidx;
	int16 mcL2Idx=-1;
	
	if(isIpv6)
		_rtk_fc_groupLSB32_to_mac(mac,isIpv6,_group[3]);
	else
		_rtk_fc_groupLSB32_to_mac(mac,isIpv6,_group[0]);


	//check group mac in LUT 
	if(_rtk_fc_lut_find((uint8 *)mac, &mcidx) != RTK_FC_RET_OK)
	{
		// add group mac to LUT
		if(isIpv6)
			ASSERT_EQ(_rtk_fc_igmp_lutMcAdd(isIpv6, _group[3],TRUE,&mcL2Idx),RTK_FC_RET_OK);
		else
			ASSERT_EQ(_rtk_fc_igmp_lutMcAdd(isIpv6, _group[0],TRUE,&mcL2Idx),RTK_FC_RET_OK);

		//printk("_rtk_fc_igmp_lutMcAdd ok ,gip= %x,mcidx =%x\n",_group[0],mcL2Idx);
	}
	
	return SUCCESS;
	
}


int _rtk_fc_check_user_group(unsigned char * skbData)
{
	unsigned int group[4] = {0};
	unsigned short isIpv6 = 0;
	unsigned char* pdata = skbData;

	//check DIP
	if((pdata[0]==0x01)&&(pdata[1]==0x00)&&(pdata[2]==0x5e))  
	{
		pdata = pdata + (ETH_ALEN<<1);
	   if(*((unsigned short*)pdata) == (unsigned short)htons(0x8100))
	   {
			pdata = pdata + 4;	
	   }
	   pdata = pdata + 18;	

	   group[0] = htonl(*((unsigned int*)pdata));
	   
	   isIpv6 = 0;
	}
	else if((pdata[0]==0x33)&&(pdata[1]==0x33)&&(pdata[2]==0xff))
	{

		pdata = pdata + (ETH_ALEN<<1);
	   if(*((unsigned short*)pdata) == (unsigned short)htons(0x8100))
	   {
			pdata = pdata + 4;	
	   }
	   pdata = pdata + 26;	

	   group[0] = htonl(*((unsigned int*)pdata));
	   group[1] = htonl(*(((unsigned int*)pdata)+1));
	   group[2] = htonl(*(((unsigned int*)pdata)+2));
	   group[3] = htonl(*(((unsigned int*)pdata)+3));

	   isIpv6 = 1;
	}
	else
	 return FALSE;


	
	if(rtk_fc_get_user_group(group, isIpv6) != 0)
		return FALSE;
	else
	{
		//printk("rtk_fc_check_user_group, group =%x,isIpv6 =%d\n",group[0],isIpv6);
		return TRUE;
	}
}

#endif
