#ifndef __RTK_FC_API_H__
#define __RTK_FC_API_H__

/****************************************
*	EXPORT_SYMBOL from FC (core) driver	*
*****************************************/

#include <rtk_fc_mgr.h>


#if defined(CONFIG_FC_RTL8277C_SERIES)


/*
				 15         k+m-1        m       0
				 +-----------+-----------+-------+
   Ports in 	 |	   A	 |	  PSID	 |	 j	 |
the CE port set  |	  > 0	 |			 |		 |
				 +-----------+-----------+-------+
				 |	a bits	 |	k bits	 |m bits |
　　　　　　　　　　　　　　↑　　　　　↑
					psidEndOffset    psidStartOffset
				 
*/
typedef struct rtk_fc_mapet_hwfmrInfo_s
{
	char devName[32];
	unsigned char fmrv6Prefix[8];
	unsigned char fmrPrefixLen;			/* End-user IPv6 prefix (Rule IPv6 prefix + EA bits)*/
	unsigned char draftVersion;
	unsigned char psidStartOffset;		//psidEndOffset - psidStartOffset >=0
	unsigned char psidEndOffset;
	int hwFmrIdx;				//output
}rtk_fc_mapet_hwfmrInfo_t;


/* Function Name:
* 	 rtk_fc_mapet_hwfmr_add
* Description:
* 	 Map-E/Map-T fmr table add for hardware accelerate
* Input:
* 	 fmrhwInfo		
* Output:
* 	 N/A
* Return:
* 	 0		 - SUCCESS
* 	 others  - error code
*/
int rtk_fc_mapet_hwfmr_add(rtk_fc_mapet_hwfmrInfo_t *fmrhwInfo);

/* Function Name:
* 	 rtk_fc_mapet_hwfmr_del
* Description:
* 	Map-E/Map-T fmr table del for hardware accelerate
* Input:
* 	 fmrhwInfo
* Output:
* 	  N/A
* Return:
* 	 0		 - SUCCESS
* 	 others  - error code
*/
int rtk_fc_mapet_hwfmr_del(rtk_fc_mapet_hwfmrInfo_t *fmrhwInfo);
#endif

 /* Function Name:
 *      rtk_fc_ingress_flowLearning
 * Description:
 *      Flow-based HWNAT ingress learning module
 * Input:
 *      rtskb		- packet buffer translated from sk_buff struct
 *      pRxInfo		- provide ingress hw info
 * Output:
 *      N/A
 * Return:
 *      RE8670_RX_STOP			
 *      RE8670_RX_CONTINUE 
 *      RE8670_RX_STOP_SKBNOFREE
 */
int rtk_fc_ingress_flowLearning(struct rt_skbuff *rtskb, fc_rx_info_t *pRxInfo);
 
 /* Function Name:
 *      rtk_fc_egress_flowLearning
 * Description:
 *      Flow-based HWNAT egress learning module
 * Input:
 *      rtskb			- packet buffer translated from sk_buff struct
 *      dev			- net dev
 *      portMask 		- ethernet dev to tx port
 *      egrWlanDevIdx	- wlan dev index
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
int rtk_fc_egress_flowLearning(struct rt_skbuff *rtskb, struct net_device *dev, int portMask, rtk_fc_wlan_devidx_t egrWlanDevIdx);

 /* Function Name:
 *      rtk_fc_fastfwd_ingress_rcv
 * Description:
 *      Flow-based HWNAT ingress learning module
 * Input:
 *      rtskb			- packet buffer translated from sk_buff struct
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
int rtk_fc_fastfwd_ingress_rcv(struct rt_skbuff *rtskb);
 
 /* Function Name:
 *      rtk_fc_fastfwd_egress_xmit
 * Description:
 *      Flow-based HWNAT egress learning module for wlan traffic
 * Input:
 *      rtskb			- packet buffer translated from sk_buff struct
 *      dev			- net dev
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
int rtk_fc_fastfwd_egress_xmit(struct rt_skbuff *rtskb, struct net_device *dev);

 /* Function Name:
 *      rtk_fc_fastfwd_directXmit
 * Description:
 *      wifi fastforward: receiving skb from nic and forwarding to wifi driver tx without any processing
 * Input:
 *      skb				- skb data
 *      pRxDesc		- nic rx info
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
 int rtk_fc_fastfwd_directXmit(struct sk_buff *skb, fc_rx_info_t *pRxInfo);

 /* Function Name:
 *      rtk_fc_helper_register
 * Description:
 *      manager module register helper function to core module
 * Input:
 *      type		- helper function sub-type
 *      api			- pointer for different helper functions
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
int rtk_fc_helper_register(rtk_fc_helper_api_t type, void *api);


/* Function Name:
 *      rtk_fc_helper_unregister
 * Description:
 *      force remarking packet format according to specific patterns.
 * Input:
 *      type		- helper function sub-type
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
int rtk_fc_helper_unregister(rtk_fc_helper_api_t type);

/* Function Name:
 *      rtk_fc_coreDBInfo_get
 * Description:
 *      Get fc db info from mgr module.
 * Input:
 *      opCode		  - info type
 *      pOpData         - the data from core module
 * Output:
 *      N/A
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */

int rtk_fc_coreDBInfo_get(rtk_fc_coreDB_ops_t opCode, rtk_fc_coreDB_info_t* pOpData);

/* Function Name:
 *      rtk_fc_l2Info_get
 * Description:
 *      Get fc l2 mac information
 * Input:
 *      mac		- target mac address
 * Output:
 *      l2info		- port and other information 
 * Return:
 *      0		- SUCCESS
 *      others 	- error code
 */
int rtk_fc_l2Info_get(uint8 *mac, rtk_fc_mgr_l2_info_t *l2info);


typedef void (* fc_l2_refresh_notify)(unsigned char *mac, unsigned short vid, unsigned char anyflowestablish);
void rtk_fc_reg_lut_notify(fc_l2_refresh_notify notify_func);

#if defined(CONFIG_RTK_SOC_RTL8198D) || defined(CONFIG_FC_RTL8198F_SERIES) || defined(CONFIG_RTL8198X_SERIES)
uint _rtk_fc_lut_learning(uint8 *srcMac, rtk_fc_pmap_t igrPort, uint16 vid, rtk_fc_wlan_devidx_t wlan_dev_idx, uint8 verify_fdb, uint8 isStatic, int16 *macL2Idx);
uint _rtk_fc_lut_find(uint8 *mac, int16 *lutIdx);
int _rtk_fc_lut_staticEntry_del(uint32 lutIdx);
#endif
#endif
