#if !defined(RTK_FC_PORT_H) && !defined(RTK_RG_PORT_H)
#define RTK_FC_PORT_H

#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)

#if defined(COMPILE_RTK_L34_FC_MGR_MODULE)
	//  fc_mgr_db used by manager module
#define RTK_FC_MAC_PORT_PON 		(fc_mgr_db.macport_pon)
#define RTK_FC_MAC_PORT_SLAVECPU 	(fc_mgr_db.macport_scpu)
#define RTK_FC_MAC_PORT_MASTERCPU_CORE0	(fc_mgr_db.macport_mcpu_0)
#define RTK_FC_MAC_PORT_MASTERCPU_CORE1 (fc_mgr_db.macport_mcpu_1)

#define FC_EXT_MAC10_PORT0		(fc_mgr_db.mac10extport_0)
#define FC_EXT_MAC7_PORT0			(fc_mgr_db.mac7extport_0)

#else
	// fc_db used by core module
#define RTK_FC_MAC_PORT0 			(fc_db.systemGlobal.macport_0)
#define RTK_FC_MAC_PORT1 			(fc_db.systemGlobal.macport_1)
#define RTK_FC_MAC_PORT2 			(fc_db.systemGlobal.macport_2)
#define RTK_FC_MAC_PORT3 			(fc_db.systemGlobal.macport_3)
#define RTK_FC_MAC_PORT4 			(fc_db.systemGlobal.macport_4)
#define RTK_FC_MAC_PORT_PON 		(fc_db.systemGlobal.macport_pon)
#define RTK_FC_MAC_PORT_iNIC		(fc_db.systemGlobal.macport_inic)
#define RTK_FC_MAC_PORT_SLAVECPU 	(fc_db.systemGlobal.macport_scpu)
#define RTK_FC_MAC_PORT_RGMII		(fc_db.systemGlobal.macport_rgmii)
#define RTK_FC_MAC_PORT_MASTERCPU_CORE0	(fc_db.systemGlobal.macport_mcpu_0)
#define RTK_FC_MAC_PORT_MASTERCPU_CORE1 (fc_db.systemGlobal.macport_mcpu_1)

#define FC_EXT_MAC10_PORT0		(fc_db.systemGlobal.mac10extport_0)
#define FC_EXT_MAC7_PORT0			(fc_db.systemGlobal.mac7extport_0)
#endif

#endif


typedef enum rtk_fc_mac_port_idx_e
{
#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	RTK_FC_MAC_PORT_RSVD=10,
#elif defined(CONFIG_FC_RTL9607C_SERIES)
	RTK_FC_MAC_PORT0=0,
	RTK_FC_MAC_PORT1=1, 	
	RTK_FC_MAC_PORT2=2, 
	RTK_FC_MAC_PORT3=3,
	RTK_FC_MAC_PORT4=4,
	RTK_FC_MAC_PORT_PON=5, 
	RTK_FC_MAC_PORT_iNIC=6, 
	RTK_FC_MAC_PORT_SLAVECPU=7, 
	RTK_FC_MAC_PORT_RGMII=8, 
	RTK_FC_MAC_PORT_MASTERCPU_CORE0=9, 
	RTK_FC_MAC_PORT_MASTERCPU_CORE1=10,
#elif defined(CONFIG_FC_RTL9603CVD_SERIES)
	RTK_FC_MAC_PORT0=0,
	RTK_FC_MAC_PORT1=1, 	
	RTK_FC_MAC_PORT2=2, 
	RTK_FC_MAC_PORT3=3,
	RTK_FC_MAC_PORT_PON=4,
	RTK_FC_MAC_PORT_CPU=5, 
#elif defined(CONFIG_FC_CAG3_SERIES) || defined(CONFIG_FC_CA8277B_SERIES) || defined(CONFIG_FC_RTL8277C_SERIES)
	RTK_FC_MAC_PORT0=0,
	RTK_FC_MAC_PORT1=1, 	
	RTK_FC_MAC_PORT2=2, 
	RTK_FC_MAC_PORT3=3,
	RTK_FC_MAC_PORT4=4,		// not support
	RTK_FC_MAC_PORT5=5, 		// not support
	RTK_FC_MAC_PORT6=6, 
#if defined(CONFIG_RG_G3_WAN_PORT_INDEX)
	RTK_FC_MAC_PORT_PON=CONFIG_RG_G3_WAN_PORT_INDEX,
#else
	RTK_FC_MAC_PORT_PON=7, 
#endif
	RTK_FC_MAC_PORT_CPU=0x10,
	RTK_FC_MAC_PORT_CPU1=0x11,
	RTK_FC_MAC_PORT_WLAN_CPU0=0x12,
	RTK_FC_MAC_PORT_WLAN_CPU1=0x13,
	RTK_FC_MAC_PORT_WLAN_CPU2=0x14,
	RTK_FC_MAC_PORT_WLAN_CPU3=0x15,
	RTK_FC_MAC_PORT_WLAN_CPU4=0x16,
	RTK_FC_MAC_PORT_WLAN_CPU5=0x17,
	RTK_FC_MAC_PORT_L3_WAN=0x18,
	RTK_FC_MAC_PORT_L3_LAN=0x19,

#elif defined(CONFIG_FC_RTL8198F_SERIES)
	RTK_FC_MAC_PORT0=0,
	RTK_FC_MAC_PORT1=1,
	RTK_FC_MAC_PORT2=2,
	RTK_FC_MAC_PORT3=3,
	RTK_FC_MAC_PORT_PON=4,
	RTK_FC_MAC_PORT4=5,
	RTK_FC_MAC_PORT5=6,
	RTK_FC_MAC_PORT6=7,
	RTK_FC_MAC_PORT_CPU=0x10,
	RTK_FC_MAC_PORT_CPU1=0x11,
	RTK_FC_MAC_PORT_WLAN_CPU0=0x12,
	RTK_FC_MAC_PORT_WLAN_CPU1=0x13,
	RTK_FC_MAC_PORT_WLAN_CPU2=0x14,
	RTK_FC_MAC_PORT_WLAN_CPU3=0x15,
	RTK_FC_MAC_PORT_WLAN_CPU4=0x16,
	RTK_FC_MAC_PORT_WLAN_CPU5=0x17,
#endif
	RTK_FC_MAC_PORT_MAX,

} rtk_fc_mac_port_idx_t;

typedef enum rtk_fc_mac_ext_port_idx_e
{
	RTK_FC_MAC_EXT_NONE=0,
#if defined(CONFIG_RTK_L34_XPON_PLATFORM)
	RTK_FC_MAC_EXT_CPU=0,
	RTK_FC_MAC_EXT_PORT0=1,
	RTK_FC_MAC_EXT_PORT1=2, 	
	RTK_FC_MAC_EXT_PORT2=3, 
	RTK_FC_MAC_EXT_PORT3=4,
	RTK_FC_MAC_EXT_PORT4=5,
	RTK_FC_MAC_EXT_PORT5=6,
	RTK_FC_MAC_EXT_PORT_MAX,
#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
	RTK_FC_MAC_EXT_CPU=0,	//for compiler
	RTK_FC_MAC_EXT_PORT_MAX,
#endif

} rtk_fc_mac_ext_port_idx_t;

typedef struct rtk_fc_pmap_s
{
	rtk_fc_mac_port_idx_t macPortIdx;
	rtk_fc_mac_ext_port_idx_t macExtPortIdx;
}rtk_fc_pmap_t;


typedef unsigned long long  rtk_fc_port_mask_t;

#if defined(CONFIG_RTK_L34_XPON_PLATFORM)

typedef enum rtk_fc_ext_port_list_e
{
#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	FC_EXT_MAC_RSVD = 17,
#elif defined(CONFIG_FC_RTL9607C_SERIES) 
	FC_EXT_MAC9_PORT0 = 0,		/*EXT0-WIFI-ROOT*/
	FC_EXT_MAC9_PORT1,		/*EXT1-WIFI-VAP0*/
	FC_EXT_MAC9_PORT2,		/*EXT2-WIFI-VAP1*/
	FC_EXT_MAC9_PORT3,		/*EXT3-WIFI-VAP2*/
	FC_EXT_MAC9_PORT4,		/*EXT4-WIFI-VAP3*/
	FC_EXT_MAC9_PORT5,		/*EXT5-WIFI-WDS or Other*/
	FC_EXT_MAC10_PORT0 = 6,		/*EXT0-WIFI-ROOT*/
	FC_EXT_MAC10_PORT1,		/*EXT1-WIFI-VAP0*/
	FC_EXT_MAC10_PORT2,		/*EXT2-WIFI-VAP1*/
	FC_EXT_MAC10_PORT3,		/*EXT3-WIFI-VAP2*/
	FC_EXT_MAC10_PORT4,		/*EXT4-WIFI-VAP3*/
	FC_EXT_MAC10_PORT5,		/*EXT5-WIFI-WDS or Other*/
	FC_EXT_MAC7_PORT0 = 12,		/*EXT0-WIFI-ROOT*/
	FC_EXT_MAC7_PORT1,		/*EXT1-WIFI-VAP0*/
	FC_EXT_MAC7_PORT2,		/*EXT2-WIFI-VAP1*/
	FC_EXT_MAC7_PORT3,		/*EXT3-WIFI-VAP2*/
	FC_EXT_MAC7_PORT4,		/*EXT4-WIFI-VAP3*/
	FC_EXT_MAC7_PORT5,		/*EXT5-WIFI-WDS or Other*/
#elif defined(CONFIG_FC_RTL9603CVD_SERIES) 
	FC_EXT_MAC_PORT0 = 0,		
	FC_EXT_MAC_PORT1,		
	FC_EXT_MAC_PORT2,		
	FC_EXT_MAC_PORT3,		
	FC_EXT_MAC_PORT4,		
	FC_EXT_MAC_PORT5,		
#endif
	FC_EXT_PORT_LIST_MAX,
}rtk_fc_ext_port_list_t;

typedef enum rtk_fc_ext_port_mask_e
{
	FC_EXTMASK_EMPTY = 0,
#if defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
	FC_EXTMASK_MAC_RSVD,
#elif defined(CONFIG_FC_RTL9607C_SERIES)	
	FC_EXTMASK_MAC9_PORT0 = (1<<FC_EXT_MAC9_PORT0),
	FC_EXTMASK_MAC9_PORT1 = (1<<FC_EXT_MAC9_PORT1),
	FC_EXTMASK_MAC9_PORT2 = (1<<FC_EXT_MAC9_PORT2),
	FC_EXTMASK_MAC9_PORT3 = (1<<FC_EXT_MAC9_PORT3),
	FC_EXTMASK_MAC9_PORT4 = (1<<FC_EXT_MAC9_PORT4),
	FC_EXTMASK_MAC9_PORT5 = (1<<FC_EXT_MAC9_PORT5),
	FC_EXTMASK_MAC10_PORT0 = (1<<FC_EXT_MAC10_PORT0),
	FC_EXTMASK_MAC10_PORT1 = (1<<FC_EXT_MAC10_PORT1),
	FC_EXTMASK_MAC10_PORT2 = (1<<FC_EXT_MAC10_PORT2),
	FC_EXTMASK_MAC10_PORT3 = (1<<FC_EXT_MAC10_PORT3),
	FC_EXTMASK_MAC10_PORT4 = (1<<FC_EXT_MAC10_PORT4),
	FC_EXTMASK_MAC10_PORT5 = (1<<FC_EXT_MAC10_PORT5),
	FC_EXTMASK_MAC7_PORT0 = (1<<FC_EXT_MAC7_PORT0),
	FC_EXTMASK_MAC7_PORT1 = (1<<FC_EXT_MAC7_PORT1),
	FC_EXTMASK_MAC7_PORT2 = (1<<FC_EXT_MAC7_PORT2),
	FC_EXTMASK_MAC7_PORT3 = (1<<FC_EXT_MAC7_PORT3),
	FC_EXTMASK_MAC7_PORT4 = (1<<FC_EXT_MAC7_PORT4),
	FC_EXTMASK_MAC7_PORT5 = (1<<FC_EXT_MAC7_PORT5),
#elif defined(CONFIG_FC_RTL9603CVD_SERIES) 
	FC_EXTMASK_MAC_PORT0 = (1<<FC_EXT_MAC_PORT0),
	FC_EXTMASK_MAC_PORT1 = (1<<FC_EXT_MAC_PORT1),
	FC_EXTMASK_MAC_PORT2 = (1<<FC_EXT_MAC_PORT2),
	FC_EXTMASK_MAC_PORT3 = (1<<FC_EXT_MAC_PORT3),
	FC_EXTMASK_MAC_PORT4 = (1<<FC_EXT_MAC_PORT4),
	FC_EXTMASK_MAC_PORT5 = (1<<FC_EXT_MAC_PORT5),
#endif
	FC_EXTMASK_ALL_PORT = (1<<FC_EXT_PORT_LIST_MAX)-1,
	
}rtk_fc_ext_port_mask_t;
#endif

typedef rtk_fc_mac_port_idx_t rtk_rg_port_idx_t;		// for asic driver

#define RTK_FC_ALL_MAC_PORTMASK ((1ULL<<RTK_FC_MAC_PORT_MAX) - 1)
#define RTK_FC_ALL_MAC_PORTMASK_WITHOUT_CPU (fc_db.all_mac_portmask_without_cpu)

#if defined(CONFIG_FC_RTL9607C_SERIES) || defined(CONFIG_FC_RTL9607C_RTL9603CVD_HYBRID)
#define RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK ((1<<RTK_FC_MAC_PORT_MASTERCPU_CORE0) | (1<<RTK_FC_MAC_PORT_MASTERCPU_CORE1))
#define RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK (1<<RTK_FC_MAC_PORT_SLAVECPU)
#define RTK_FC_ALL_MAC_CPU_PORTMASK (RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK | RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK)
#define RTK_FC_ALL_MAC_WLANCPU_PORTMASK (RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK | RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK)

#define RTK_FC_MAC_PORT_MAINCPU			RTK_FC_MAC_PORT_MASTERCPU_CORE0
#define RTK_FC_MAC_PORT_LASTCPU			RTK_FC_MAC_PORT_MASTERCPU_CORE1
#define RTK_FC_MAC_PORT_CPU 			RTK_FC_MAC_PORT_MASTERCPU_CORE1				// indicate the last physical port

#elif defined(CONFIG_FC_RTL9603CVD_SERIES) 
#define RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK ((1<<RTK_FC_MAC_PORT_CPU))
#define RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK (0)
#define RTK_FC_ALL_MAC_CPU_PORTMASK (RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK | RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK)
#define RTK_FC_ALL_MAC_WLANCPU_PORTMASK (RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK | RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK)

#define RTK_FC_MAC_PORT_MAINCPU			RTK_FC_MAC_PORT_CPU
#define RTK_FC_MAC_PORT_LASTCPU			RTK_FC_MAC_PORT_CPU
/* to be compatible with RTL9607C*/
#define RTK_FC_MAC_PORT4					RTK_FC_MAC_PORT3
#define RTK_FC_MAC_PORT_iNIC				RTK_FC_MAC_PORT3
#define RTK_FC_MAC_PORT_RGMII				RTK_FC_MAC_PORT3 
#define RTK_FC_MAC_PORT_MASTERCPU_CORE0 RTK_FC_MAC_PORT_CPU
#define RTK_FC_MAC_PORT_MASTERCPU_CORE1 RTK_FC_MAC_PORT_CPU
#define RTK_FC_MAC_PORT_SLAVECPU			RTK_FC_MAC_PORT_CPU

#elif defined(CONFIG_RTK_L34_G3_PLATFORM)
#define RTK_FC_ALL_MAC_MASTER_CPU_PORTMASK ((1<<RTK_FC_MAC_PORT_CPU))
#define RTK_FC_ALL_MAC_SLAVE_CPU_PORTMASK (0)

#define RTK_FC_ALL_MAC_CPU_PORTMASK ((1<<RTK_FC_MAC_PORT_CPU) | (1<<(RTK_FC_MAC_PORT_CPU+1)) | (1<<RTK_FC_MAC_PORT_WLAN_CPU0) | (1<<RTK_FC_MAC_PORT_WLAN_CPU1) | (1<<RTK_FC_MAC_PORT_WLAN_CPU2) | (1<<RTK_FC_MAC_PORT_WLAN_CPU3) | (1<<RTK_FC_MAC_PORT_WLAN_CPU4) | (1<<RTK_FC_MAC_PORT_WLAN_CPU5)) 
#define RTK_FC_ALL_MAC_WLANCPU_PORTMASK RTK_FC_ALL_MAC_CPU_PORTMASK

#define RTK_FC_ALL_MAC_PURECPU_PORTMASK ((1<<RTK_FC_MAC_PORT_CPU) | (1<<(RTK_FC_MAC_PORT_CPU+1)))

#define RTK_FC_MAC_PORT_MAINCPU			RTK_FC_MAC_PORT_CPU
#define RTK_FC_MAC_PORT_LASTCPU			RTK_FC_MAC_PORT_WLAN_CPU5


#define	RTK_FC_MAC_PORT_SPECIAL_FF_US RTK_FC_MAC_PORT_WLAN_CPU4
#define	RTK_FC_MAC_PORT_SPECIAL_FF_DS RTK_FC_MAC_PORT_WLAN_CPU5

#define	RTK_FC_MAC_PORT_SPECIAL_FASTFWD_CPU_PORT_0 RTK_FC_MAC_PORT_WLAN_CPU2
#define	RTK_FC_MAC_PORT_SPECIAL_FASTFWD_CPU_PORT_1 RTK_FC_MAC_PORT_WLAN_CPU3
#define	RTK_FC_MAC_PORT_SPECIAL_FASTFWD_CPU_PORT_2 RTK_FC_MAC_PORT_WLAN_CPU4
#define	RTK_FC_MAC_PORT_SPECIAL_FASTFWD_CPU_PORT_3 RTK_FC_MAC_PORT_WLAN_CPU5
#endif

#endif //RTK_FC_PORT_H