/*
 * Copyright (C) 2012 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 68395 $
 * $Date: 2016-05-27 16:38:35 +0800 (Fri, 27 May 2016) $
 *
 * Purpose : Definition of PE API
 *
 * Feature : The file includes the following modules and sub-modules
 *           (1) Configuration of http test
 *
 */


#ifndef __RT_PE_EXT_H__
#define __RT_PE_EXT_H__


/*
 * Include Files
 */
#include <common/rt_type.h>

/*
 * Symbol Definition
 */
#define MAX_PE_HTTP_DOWNLOAD_CONNECTION_NUM (8)
#define MAX_PE_HTTP_UPLOAD_CONNECTION_NUM (8)
#define MAX_PE_HTTP_CONNECTION_NUM ((MAX_PE_HTTP_DOWNLOAD_CONNECTION_NUM>MAX_PE_HTTP_UPLOAD_CONNECTION_NUM) ? MAX_PE_HTTP_DOWNLOAD_CONNECTION_NUM : MAX_PE_HTTP_UPLOAD_CONNECTION_NUM)
#define MAX_PE_HTTP_REQ_URL_STR_LENGTH (100)
#define MAX_PE_HTTP_VERSION_STR_LENGTH (20)
#define RT_PE_HTTP_TEST_CPU_PORT (0x13)
#define RT_PE_HTTP_TEST_DMA_LSO_CPU_VP_ID (11)
#if defined(CONFIG_FC_CA8277B_SERIES)
#define RT_PE_HTTP_TEST_DMA_LSO_LSPID (0x20)
#else //CONFIG_FC_RTL8277C_SERIES
#define RT_PE_HTTP_TEST_DMA_LSO_LSPID (0x11)
#endif

#define RT_PE_HTTP_TEST_DMA_LSO_BACKPRESSURE (1)
#define RT_PE_DMA_LSO_SHAPER_RATE_1DOT25G 	(0x0012C000)  //1200M
#define RT_PE_DMA_LSO_SHAPER_RATE_2DOT5G 	(0x00258000)  //2400M
#define RT_PE_DMA_LSO_SHAPER_RATE_10G 		(0x00992000)  //9800M


/*
 * Data Declaration
 */
typedef enum rt_pe_ret_e
{
	RT_PE_RET_FAIL				= -1,
	RT_PE_RET_OK				= 0,
	RT_PE_RET_PARAM_SIZE_ERROR	= 1,
	RT_PE_RET_EXISTED			= 2,
	RT_PE_RET_NOT_FOUND 		= 3,
} rt_pe_ret_t;

typedef enum rt_pe_http_test_cmd_e
{
	RT_PE_HTTP_TEST_CMD_DOWNLOAD_START = 0,
	RT_PE_HTTP_TEST_CMD_DOWNLOAD_STOP,
	RT_PE_HTTP_TEST_CMD_DOWNLOAD_GET_CNT,
	RT_PE_HTTP_TEST_CMD_UPLOAD_START,
	RT_PE_HTTP_TEST_CMD_UPLOAD_STOP,
	RT_PE_HTTP_TEST_CMD_UPLOAD_GET_CNT,
	RT_PE_HTTP_TEST_CMD_MAX
} rt_pe_http_test_cmd_t;

typedef enum rt_pe_http_test_return_cmd_e
{
	RT_PE_HTTP_TEST_RETURN_CMD_DOWNLOAD_FINISH 	= 0,
	RT_PE_HTTP_TEST_RETURN_CMD_DOWNLOAD_CNT 	= 1,
	RT_PE_HTTP_TEST_RETURN_CMD_UPLOAD_FINISH 	= 2,
	RT_PE_HTTP_TEST_RETURN_CMD_UPLOAD_CNT 		= 3,
	RT_PE_HTTP_TEST_RETURN_CMD_MAX
} rt_pe_http_test_return_cmd_t;

typedef struct rt_pe_http_test_request_s
{
	rt_pe_http_test_cmd_t req_cmd;
		
	rtk_mac_t server_mac;
	rtk_mac_t client_mac;
	uint8 isIPv4OrIpv6; // 0: ipv4, 1: ipv6
	union{
		rtk_ip_addr_t ipv4_addr;
		rtk_ipv6_addr_t ipv6_addr;
	}client_ip;
	union{
		rtk_ip_addr_t ipv4_addr;
		rtk_ipv6_addr_t ipv6_addr;
	}server_ip;
	uint16 client_l4port;
	uint16 server_l4port;

	uint32 ldpid;
	int16 pppoe_sid;	// -1 invalid
	int16 svlan_vid;	// -1 invalid
	int16 cvlan_vid;	// -1 invalid
	int16 pon_streamId;	// -1 invalid

	uint8 http_req_url[MAX_PE_HTTP_REQ_URL_STR_LENGTH]; 	//e.g., "/garbage.php?ckSize=5000"
	uint8 http_version[MAX_PE_HTTP_VERSION_STR_LENGTH]; 	//e.g., "HTTP/1.1"

	uint8 non_congestion_mode;		// for download

	uint64 upload_content_length; 	// unit: bytes
	
	uint32 tcp_window_size; 		// unit: bytes, 0: means it uses default window size
	uint16 tcp_mss_size;			// unit: bytes, 0: means it uses default value

	uint32 connection_number;		// MAX_PE_HTTP_DOWNLOAD_CONNECTION_NUM, MAX_PE_HTTP_UPLOAD_CONNECTION_NUM
}rt_pe_http_test_request_t;

typedef struct rt_pe_http_test_result_s
{
	rt_pe_ret_t ret_val;
	uint32 pktCnt;
	uint64 byteCnt;					//payload only
	uint64 byteCnt_include_pktHdr;	//L2+L3+L4+payload
	uint32 total_pktCnt;
	uint64 total_byteCnt;					//payload only
	uint64 total_byteCnt_include_pktHdr;	//L2+L3+L4+payload
	//the unit of following time is milliseconds 
	uint64 TCP_openRequestTime_ms; //It's relative time and is always zero
	uint64 TCP_openResponseTime_ms;
	uint64 HTTP_ROMTime_ms; //http get
	uint64 HTTP_BOMTime_ms; //start transmission
	uint64 HTTP_EOMTime_ms; //end transmission
}rt_pe_http_test_result_t;


/*
 * Function Declaration
 */

/* Function Name:
 *      rt_pe_http_test
 * Description:
 *      Set configuration of pe http test
 * Input:
 *      http_test_req	- Configuration of http test request 
 * Output:
 *		pHttp_test_result
 * Return:
 *      RT_ERR_OK					- OK
 *      RT_ERR_DRIVER_NOT_FOUND		- Driver not found
 *      RT_ERR_NOT_ALLOWED			- Driver return fail
 * Note:
 *      The API can set configuration of pe http test
 */
extern int rt_pe_http_test(rt_pe_http_test_request_t http_test_req, rt_pe_http_test_result_t *pHttp_test_result);

#endif /* __RT_PE_EXT_H__ */
