#ifndef __RTK_FC_SKB_H__
#define __RTK_FC_SKB_H__
#include <linux/version.h>

typedef struct rtk_fc_ingress_vxlan_info_s
{
	unsigned char outer_v4tos;				//ref to IPV4_TAGIF
	unsigned char outer_tag_len;       // For vxlan down stream
	signed short  outer_sa_idx;
	unsigned char outer_da[6];		   // For vxlan down stream
	unsigned short outer_srcPort;			// For vxlan down stream
	unsigned int outer_srcIp;				// For vxlan down stream
#if defined(CONFIG_FC_RTL8277C_SERIES)	
	union{
		unsigned int outer_dstIp;				// For vxlan down stream
		struct	in6_addr outer_v6dstIp;
	};
#else
	unsigned int outer_dstIp;				// For vxlan down stream
#endif
	unsigned int vni;						// For vxlan down stream
	unsigned char outer_isV6;						// For vxlan down stream
}rtk_fc_ingress_vxlan_info_t;

typedef struct rtk_fc_ingress_greEthBr_info_s
{
	unsigned int remoteIp;		// ipv4 address
	unsigned int gateWayIp;		// ipv4 address
}rtk_fc_ingress_greEthBr_info_t;


typedef struct rtk_fc_ingress_nptv6_info_s
{
	unsigned int lan_prefix_len;
    unsigned int wan_prefix_len;
}rtk_fc_ingress_nptv6_info_t;

typedef struct rtk_fc_dualHeader_mapt_info_s
{
	unsigned int src_style:2;
	unsigned int src_v6_pref_len:7;
	unsigned int src_v4_pref_len:5;
	unsigned int src_ea_len:6;
	unsigned int src_psid_offset:4;
	unsigned char src_v6_addr[8];

	unsigned int dst_style:2;
	unsigned int dst_v6_pref_len:7;
	unsigned int dst_v4_pref_len:5;
	unsigned int dst_ea_len:6;
	unsigned int dst_psid_offset:4;
}rtk_fc_dualHeader_mapt_info_t;

typedef struct rtk_fc_ingress_data_s
{
	//struct net_device* srcDev;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(4,4,0)
	struct net_device* logicalInDev;
	struct net_device* logicalOutDev;
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(3,18,0)
	const struct net_device* logicalInDev;
	const struct net_device* logicalOutDev;
#endif
	int flowHashIdx;					// -1 indicate invalid
#if defined(CONFIG_FC_RTL8277C_SERIES)
	unsigned int crc32;
#endif
	struct nf_conn *ct;
	unsigned int  ingressTagif;			// ref to rtk_fc_enum_pktHdrTagif_t
	unsigned int srcIp;				// ipv4 address or ipv6 hash value
	unsigned int dstIp;				// ipv4 address or ipv6 hash value
	
	unsigned short srcPort;
	unsigned short dstPort;
	
	unsigned short sessionId;			//ref to PPPOE_TAGIF
	unsigned short outer_sessionId;     // For vxlan down stream
	
	unsigned short ingressCallid;		// pptp gre
	unsigned char ingressPort;			// mac port number
	unsigned char wlan_dev_idx;		// wlan dev index indicate the using mac port and ext port
	
	unsigned char sa[6];
	unsigned char da[6];
	
	unsigned char v4tos;				//ref to IPV4_TAGIF
	unsigned char v6tos;				//ref to IPV6_TAGIF
	unsigned int srcSVlanId:12;		//ref to SVLAN_TAGIF
	unsigned int srcCVlanPri:3;
	unsigned int srcCVlanCfi:1;
	
	unsigned int srcCVlanId:12;		//ref to CVLAN_TAGIF
	unsigned int srcSVlanPri:3;	
	unsigned int srcSVlanDei:1;
	unsigned int srcSVlanTpid_sel:1;		//ref to SVLAN_TAGIF
	unsigned int outer_srcSVlanId:12;		// For vxlan down stream
	unsigned int outer_srcCVlanPri:3;		// For vxlan down stream
	
	unsigned int outer_srcCVlanCfi:1;		// For vxlan down stream
	unsigned int outer_srcCVlanId:12;		// For vxlan down stream
	unsigned int outer_srcSVlanPri:3;		// For vxlan down stream
	unsigned int outer_srcSVlanDei:1;		// For vxlan down stream
	unsigned int outer_srcSVlanTpid_sel:1;	// For vxlan down stream
	unsigned int ponStreamId:8;
	unsigned int isDAGatewayMAC:1;
	unsigned int isDualHeader:1;		// True: this content belongs to outer header 
	unsigned int doLearning:1;
	unsigned int isNotLocalOut:1;
	unsigned int isDummyPkt:1;		// triger by house keeping
	unsigned int mcDummyPkt:1;
	
	unsigned int ipId:16;
	unsigned int SrcDevSwIfIdx:6;
	unsigned int outerHdrUnhit:1;
	unsigned int isHitSwFwdedAclTrapPri:1;
	unsigned int skbCloned:1;
	unsigned int ipFragFlag:3;		// for fragment shortcut only
#if defined(CONFIG_RTK_SOC_RTL8198D) || defined(CONFIG_FC_RTL8198F_SERIES) || defined(CONFIG_RTL8198X_SERIES)
	unsigned int 	skip_nf_conntrack_in:1;		// for fc shortcut tcp_in_window() check fail, skip kernel nf_conntrack_in()
	char			wlan_type;					// for traffic count
	unsigned char ingress_sa[6];
	unsigned char ingress_da[6];
#endif
#if defined(CONFIG_RTK_SOC_RTL8198D)
	unsigned char	src_phyport;
#endif
	unsigned int ingressDualFailed:1;
	union
	{
		rtk_fc_ingress_vxlan_info_t vxlan_info;       		//VXLAN_TAGIF
		rtk_fc_ingress_greEthBr_info_t greEthBr_info;		//GRE_ETH_BR_TAGIF
		rtk_fc_dualHeader_mapt_info_t mapt_info;			//MAPT info		
		rtk_fc_ingress_nptv6_info_t nptv6_info;
	};
	struct	in6_addr ingress_v6ip_info;		//downstream->dip upstream->sip
}__attribute__((packed)) rtk_fc_ingress_data_t;

#endif
