
#include <rtk_igmp_snooping.h>
#include <rt_igmp_ext.h>
#include <rtk_igmp_debug.h>
#include <rtk_igmp_hook.h>


#include <common/rt_type.h>
#include <rtk/l2.h>

#include <rtk_fc_helper_wlan.h>
#include <rtk_fc_helper.h>
#include <linux/workqueue.h>


#define UNCTAG -1
#define IF_SOURCECARE 1
#define IF_VLANCARE 1

#define IGMP_MAX_WQ_SIZE 512 

typedef struct rtk_igmp_CbWorkq_s
{
	struct work_struct work;
	union
	{
		rtk_igmp_groupCbEvt_t groupCb;
		rtk_igmp_flowCbEvt_t flowCb;
		rtk_igmp_unknownMcCbEvt_t unknownCtrl;
	}data;
	struct list_head work_list;
}rtk_igmp_CbWorkq_t;

rtk_igmp_CbWorkq_t callbackWorkq[IGMP_MAX_WQ_SIZE];
struct list_head listFreeHead_workq;

atomic_t wqAllocCnt=ATOMIC_INIT(0);
atomic_t wqFreeCnt=ATOMIC_INIT(0);
atomic_t wqInit=ATOMIC_INIT(0);

int32 rtk_igmp_callbackwq_flushInit(void)
{
	int i;
	igmp_spin_lock_bh(igmpSysdb.lock_callBack);	
	INIT_LIST_HEAD(&listFreeHead_workq);
	for(i=0;i<IGMP_MAX_WQ_SIZE;i++)
	{
		memset(&callbackWorkq[i],0,sizeof(rtk_igmp_CbWorkq_t));
		INIT_LIST_HEAD(&callbackWorkq[i].work_list);
		list_add_tail(&callbackWorkq[i].work_list, &listFreeHead_workq);	
	}
	igmp_spin_unlock_bh(igmpSysdb.lock_callBack);
	return SUCCESS;
}


rtk_igmp_CbWorkq_t * rtk_igmp_callbackwq_malloc(void)
{
	rtk_igmp_CbWorkq_t *callbackwq_entry;
	rtk_igmp_CbWorkq_t *callbackwq_entry_tmp;

	if(atomic_read(&wqInit)==0)
	{
		rtk_igmp_callbackwq_flushInit();
		atomic_inc(&wqInit);
	}
	igmp_spin_lock_bh(igmpSysdb.lock_callBack); 

	if(list_empty(&listFreeHead_workq))
	{
		IGMP_HWCB("all free IGMP listFreeHead_workq are allocated...");
		igmp_spin_unlock_bh(igmpSysdb.lock_callBack);
		return (NULL);
	}
	list_for_each_entry_safe(callbackwq_entry,callbackwq_entry_tmp,&listFreeHead_workq,work_list)		//just return the first entry right behind of head
	{
		list_del_init(&callbackwq_entry->work_list);
		break;
	}
	igmp_spin_unlock_bh(igmpSysdb.lock_callBack);

	memset(&callbackwq_entry->data,0,sizeof(callbackwq_entry->data));
	
	return callbackwq_entry;
}



int rtk_igmp_callbackwq_free(rtk_igmp_CbWorkq_t* workq)
{
	igmp_spin_lock_bh(igmpSysdb.lock_callBack);	
	list_del_init(&workq->work_list);
	list_add(&workq->work_list, &listFreeHead_workq);
	igmp_spin_unlock_bh(igmpSysdb.lock_callBack);
	return (SUCCESS);
}


int32 _rtk_igmp_hwRegInit(void)
{

	// set to auto mode
	return rt_igmp_multicastMode_set(RT_IGMP_MULTICAST_SYNC_AUTO);
}
int32 _rtk_igmp_hwUnRegClear(void)
{
	// set to kernel mode
	return rt_igmp_multicastMode_set(RT_IGMP_MULTICAST_SYNC_AUTO);
}

int32 _rtk_igmp_unknownIpMc_Action(rtk_igmp_unknownMcCbEvt_t *unknownCtrl)
{
	int ret=0;
	rt_igmp_unknownMc_cfg_t mcUnknCfg;

	memset(&mcUnknCfg,0,sizeof(mcUnknCfg));

	mcUnknCfg.isipv6 = unknownCtrl->isIpv6;

	mcUnknCfg.trapPkt = (unknownCtrl->unknownAct==UNKNOWN_MC_DROP)?0:1;

	ret=rt_igmp_unknownMcAction_set(mcUnknCfg);

	if(ret)
		IGMP_HWCB("ret=%d error",ret);

	return SUCCESS;
}

int32 _rtk_igmp_flowDelCbEvt(rtk_igmp_flowCbEvt_t *flowCb)
{
#if 1
	int ret=0;
	rt_igmp_group_devPort_cfg_t mcDevConfig;

	memset(&mcDevConfig,0,sizeof(mcDevConfig));
	mcDevConfig.groupBehavior=RT_MC_BEHAVIOR_FLOW_FORWAED;
	mcDevConfig.is_ipv6=flowCb->isIPv6;

	mcDevConfig.careIngressCvid=IF_VLANCARE;
	mcDevConfig.careSourceAddress=IF_SOURCECARE;

	if(flowCb->ingressCvlan==FAIL)
		mcDevConfig.ingress_ctagif=0;
	else
	{
		mcDevConfig.ingress_ctagif=1;
		mcDevConfig.ingress_cvid = flowCb->ingressCvlan;
	}

	if(flowCb->isIPv6)
		memcpy(&mcDevConfig.source_addr.ipv6[0],&flowCb->sourceAddr[0],sizeof(mcDevConfig.source_addr));
	else
		mcDevConfig.source_addr.ipv4=flowCb->sourceAddr[0];


	if(flowCb->isIPv6)
		memcpy(&mcDevConfig.group_addr.ipv6[0],&flowCb->group[0],sizeof(mcDevConfig.group_addr));
	else
		mcDevConfig.group_addr.ipv4=flowCb->group[0];

	ret = rt_igmp_multicastGroupDev_set (mcDevConfig);

//may delete same sip/dip but  dport/sport different not a error
//	if(ret)
//		IGMP_WARNING("ret=%d Error",ret);

	return ret;

#else
	int ret=0;
	rt_igmp_multicast_group_cfg_t mcConfig;

	if(flowCb->l4proto != IPPROTO_UDP)
		return FAIL;

	memset(&mcConfig,0,sizeof(mcConfig));
	mcConfig.groupBehavior=RT_MC_BEHAVIOR_FLOW_FORWAED;
	mcConfig.is_ipv6=flowCb->isIPv6;

	mcConfig.careIngressCvid=IF_VLANCARE;
	mcConfig.careSourceAddress=IF_SOURCECARE;

	if(flowCb->ingressCvlan==FAIL)
		mcConfig.ingress_ctagif=0;
	else
	{
		mcConfig.ingress_ctagif=1;
		mcConfig.ingress_cvid = flowCb->ingressCvlan;
	}

	if(flowCb->isIPv6)
		memcpy(&mcConfig.source_addr.ipv6[0],&flowCb->sourceAddr[0],sizeof(mcConfig.source_addr));
	else
		mcConfig.source_addr.ipv4=flowCb->sourceAddr[0];


	if(flowCb->isIPv6)
		memcpy(&mcConfig.group_addr.ipv6[0],&flowCb->group[0],sizeof(mcConfig.group_addr));
	else
		mcConfig.group_addr.ipv4=flowCb->group[0];

	ret = rt_igmp_multicastGroup_set (mcConfig);

//may delete same sip/dip but  dport/sport different not a error
//	if(ret)
//		IGMP_WARNING("ret=%d Error",ret);

	return ret;
#endif
}

int32 _rtk_igmp_groupFlowPrepare_devPort_cfg(rtk_igmp_flowCbEvt_t *flowCb,rt_igmp_group_devPort_cfg_t *mcConfig,int32 groupBehavior)
{
	if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX || igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORT)
	{
		int i;
		int fwdCnt=0;
		rtk_fc_wlan_devidx_t wlanDevIdx;
		rt_wlan_mbssid_mask_t wlanMbssidMask[RT_WLAN_DEVICE_MAX];
		rtk_fc_wlan_devmask_t wlanDevIdMask;
		rt_igmp_group_devPort_cfg_t *mcDevConfig=mcConfig;

		memset(mcDevConfig,0,sizeof(rt_igmp_group_devPort_cfg_t));
		mcDevConfig->groupBehavior=groupBehavior;
		if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX)
			mcDevConfig->egrInfoType = EGRINFO_DEVIFIDX;
		else
			mcDevConfig->egrInfoType = EGRINFO_PID;

		mcDevConfig->is_ipv6=flowCb->isIPv6;

		mcDevConfig->careIngressCvid=IF_VLANCARE;
		mcDevConfig->careSourceAddress=IF_SOURCECARE;

		if(flowCb->ingressCvlan==FAIL)
			mcDevConfig->ingress_ctagif=0;
		else
		{
			mcDevConfig->ingress_ctagif=1;
			mcDevConfig->ingress_cvid = flowCb->ingressCvlan;
		}

		if(flowCb->isIPv6)
			memcpy(&mcDevConfig->source_addr.ipv6[0],&flowCb->sourceAddr[0],sizeof(mcDevConfig->source_addr));
		else
			mcDevConfig->source_addr.ipv4=flowCb->sourceAddr[0];


		if(flowCb->isIPv6)
			memcpy(&mcDevConfig->group_addr.ipv6[0],&flowCb->group[0],sizeof(mcDevConfig->group_addr));
		else
			mcDevConfig->group_addr.ipv4=flowCb->group[0];

		if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX)
		{
			for(i=0;i<RT_MCCFG_MAX_NUM;i++)
			{
				if(flowCb->egressDevInfo[i].valid)
				{
					mcDevConfig->egrInfo.devIfidx[fwdCnt].ifindex = flowCb->egressDevInfo[i].devIfIdx;
					fwdCnt++;

					if(fwdCnt>=RT_MCCFG_MAX_NUM)
					{
						IGMP_WARNING("fwdCnt out-of-range Error");
						return FAIL;
					}
				}
				else
					break;
			}

		}
		else
		{
			//Port Mode
			for(i=0;i<IGMP_MAX_DEV_NUM;i++)
			{
				if(flowCb->egressDevInfo[i].valid)
				{
					struct net_device *dev;
					rtk_fc_realdev_t rdev;
					
					igmp_spin_lock_bh(igmpSysdb.lock_igmp); 		
					dev = rtk_igmp_devIfidx_to_dev(flowCb->egressDevInfo[i].devIfIdx);
					igmp_spin_unlock_bh(igmpSysdb.lock_igmp);

					if(dev==NULL)
						continue;

					if(rtk_fc_dev_get_realdev_phyport(dev,&rdev)!=FAIL)
					{
						mcDevConfig->egrInfo.portId[fwdCnt].isWlan=0;
						mcDevConfig->egrInfo.portId[fwdCnt].phyPortIdx=rdev.physicalPid;
						fwdCnt++;
					}
					else if(rtk_fc_dev2wlanDevIdx(dev, &wlanDevIdx)!=FAIL)
					{
						rt_wlan_mbssid_index_t mbssidIdx;
						rt_wlan_index_t wlanIdx;
						wlanDevIdMask = ((rtk_fc_wlan_devmask_t)1LL) << wlanDevIdx;
						rtk_fc_wlan_devMask2RtmbssidMask(&wlanDevIdMask,wlanMbssidMask);
						for(wlanIdx=0 ; wlanIdx<RT_WLAN_DEVICE_MAX ; wlanIdx++)
						{
							for(mbssidIdx=0;mbssidIdx<RT_WLAN_MBSSID_MAX;mbssidIdx++)
							{
								if(wlanMbssidMask[wlanIdx] & (1<<mbssidIdx))
									goto FOUND_WLAN;
							}

						}
						if(0)
						{
FOUND_WLAN:
							mcDevConfig->egrInfo.portId[fwdCnt].isWlan=1;
							mcDevConfig->egrInfo.portId[fwdCnt].wlan.wlanDevIdx = wlanIdx;
							mcDevConfig->egrInfo.portId[fwdCnt].wlan.wlanMbssid = mbssidIdx;
							fwdCnt++;
						}
					}
					
				}
				else
					break;
			}
		}
		mcDevConfig->cntEgrInfo = fwdCnt;

		return SUCCESS;
	}

	return SUCCESS;
}



int32 __rtk_igmp_groupFlowPrepare_pmskgroup_cfg(rtk_igmp_flowCbEvt_t *flowCb,rt_igmp_multicast_group_cfg_t *mcConfig,int32 groupBehavior)
{
	if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORTMASK)
	{
		int i,j;
		rtk_fc_wlan_devidx_t wlanDevIdx;
		rtk_fc_wlan_devmask_t wlanDevIdMask;
		rt_wlan_mbssid_mask_t wlanMbssidMask[RT_WLAN_DEVICE_MAX];
		rt_igmp_multicast_group_cfg_t *mcPmskConfig=mcConfig;

		//if(flowCb->l4proto != IPPROTO_UDP)
			//return FAIL;

		memset(mcPmskConfig,0,sizeof(rt_igmp_multicast_group_cfg_t));
		mcPmskConfig->groupBehavior=groupBehavior;
		mcPmskConfig->is_ipv6=flowCb->isIPv6;

		mcPmskConfig->careIngressCvid=IF_VLANCARE;
		mcPmskConfig->careSourceAddress=IF_SOURCECARE;

		if(flowCb->ingressCvlan==FAIL)
			mcPmskConfig->ingress_ctagif=0;
		else
		{
			mcPmskConfig->ingress_ctagif=1;
			mcPmskConfig->ingress_cvid = flowCb->ingressCvlan;
		}

		if(flowCb->isIPv6)
			memcpy(&mcPmskConfig->source_addr.ipv6[0],&flowCb->sourceAddr[0],sizeof(mcPmskConfig->source_addr));
		else
			mcPmskConfig->source_addr.ipv4=flowCb->sourceAddr[0];


		if(flowCb->isIPv6)
			memcpy(&mcPmskConfig->group_addr.ipv6[0],&flowCb->group[0],sizeof(mcPmskConfig->group_addr));
		else
			mcPmskConfig->group_addr.ipv4=flowCb->group[0];


		//we only used first_act_portmask only ( first_act_portmask == (first_act_portmask|second_act_portmask)
		for(i=0;i<IGMP_MAX_DEV_NUM;i++)
		{
			if(flowCb->egressDevInfo[i].valid)
			{
				struct net_device *dev;
				rtk_fc_realdev_t rdev;
				
				igmp_spin_lock_bh(igmpSysdb.lock_igmp); 		
				dev = rtk_igmp_devIfidx_to_dev(flowCb->egressDevInfo[i].devIfIdx);
				igmp_spin_unlock_bh(igmpSysdb.lock_igmp);

				if(dev==NULL)
					continue;

				if(rtk_fc_dev_get_realdev_phyport(dev,&rdev)!=FAIL)
				{
					if(mcPmskConfig->first_act_portmask & (1 << rdev.physicalPid) )
					{
						//multi-packet send to same physical port not support for now
						IGMP_DATA("multi-packet send to same physical port not support for now");
						return FAIL;
					}
					else
					{
						mcPmskConfig->first_act_portmask |= (1 << rdev.physicalPid);
					}
				}
				else if(rtk_fc_dev2wlanDevIdx(dev, &wlanDevIdx)!=FAIL)
				{
					wlanDevIdMask = ((rtk_fc_wlan_devmask_t)1) << wlanDevIdx;
					rtk_fc_wlan_devMask2RtmbssidMask(&wlanDevIdMask,wlanMbssidMask);
					for(j=0 ; j<RT_WLAN_DEVICE_MAX ; j++)
						mcPmskConfig->first_act_wlanMbssidMask[j] |= wlanMbssidMask[j];
				}
				
			}
			else
				break;
		}
		IGMP_HWCB("set first_action_portmask to %x first_act_wlanMbssidMask[ %x %x %x ]",mcPmskConfig->first_act_portmask,mcPmskConfig->first_act_wlanMbssidMask[0],mcPmskConfig->first_act_wlanMbssidMask[1],mcPmskConfig->first_act_wlanMbssidMask[2]);

		return SUCCESS;
	}
	return SUCCESS;
}

/*
l4proto/dport/sport  will miss here
*/
int32 _rtk_igmp_flowSetCbEvt(rtk_igmp_flowCbEvt_t *flowCb)
{
	if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX || igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORT)
	{
		int ret=0;
		rt_igmp_group_devPort_cfg_t mcDevConfig;

		if(_rtk_igmp_groupFlowPrepare_devPort_cfg(flowCb,&mcDevConfig,RT_MC_BEHAVIOR_FLOW_FORWAED)==SUCCESS)
		{
			ret = rt_igmp_multicastGroupDev_set (mcDevConfig);
			if(ret)
				IGMP_WARNING("ret=%d Error",ret);
		}
		return ret;
	}
	else if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORTMASK)
	{
		int ret=0;
		rt_igmp_multicast_group_cfg_t mcConfig;

		if(__rtk_igmp_groupFlowPrepare_pmskgroup_cfg(flowCb,&mcConfig,RT_MC_BEHAVIOR_FLOW_FORWAED)==SUCCESS)
		{
			ret = rt_igmp_multicastGroup_set (mcConfig);
			if(ret)
				IGMP_WARNING("ret=%d Error",ret);
		}

		return ret;
	}
	return SUCCESS;
}


/*
l4proto/dport/sport  will miss here
*/
int32 _rtk_igmp_flowUpdateCbEvt(rtk_igmp_flowCbEvt_t *flowCb)
{
	if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX || igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORT)
	{
		int ret=0;
		rt_igmp_group_devPort_cfg_t mcDevConfig;

		if(_rtk_igmp_groupFlowPrepare_devPort_cfg(flowCb,&mcDevConfig,RT_MC_BEHAVIOR_FLOW_UPDATE)==SUCCESS)
		{
			ret = rt_igmp_multicastGroupDev_set (mcDevConfig);
			if(ret)
				IGMP_WARNING("ret=%d Error",ret);
		}
		return ret;
	}
	else if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORTMASK)
	{
		int ret=0;
		rt_igmp_multicast_group_cfg_t mcConfig;

		if(__rtk_igmp_groupFlowPrepare_pmskgroup_cfg(flowCb,&mcConfig,RT_MC_BEHAVIOR_FLOW_UPDATE)==SUCCESS)
		{
			ret = rt_igmp_multicastGroup_set (mcConfig);
			if(ret)
				IGMP_WARNING("ret=%d Error",ret);
		}

		return ret;
	}
	return SUCCESS;
}





int32 _rtk_igmp_groupAddCbEvt(rtk_igmp_groupCbEvt_t *groupCb)
{
	if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX || igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORT)
	{
		int ret=0;
		rt_igmp_group_devPort_cfg_t mcDevConfig;
		memset(&mcDevConfig,0,sizeof(mcDevConfig));

		mcDevConfig.careIngressCvid=IF_VLANCARE;
		mcDevConfig.careSourceAddress=IF_SOURCECARE;

		mcDevConfig.groupBehavior=RT_MC_BEHAVIOR_GROUP_AS_KNOW;
		mcDevConfig.is_ipv6=groupCb->isIPv6;

		if(groupCb->isIPv6)
			memcpy(&mcDevConfig.group_addr.ipv6[0],&groupCb->group[0],sizeof(mcDevConfig.group_addr));
		else
			mcDevConfig.group_addr.ipv4=groupCb->group[0];

		ret = rt_igmp_multicastGroupDev_set(mcDevConfig);

		if(ret)
			IGMP_WARNING("ret=%d Error",ret);

		return SUCCESS;
	}
	else if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORTMASK)
	{
		int ret=0;
		rt_igmp_multicast_group_cfg_t mcConfig;
		memset(&mcConfig,0,sizeof(mcConfig));

		mcConfig.careIngressCvid=IF_VLANCARE;
		mcConfig.careSourceAddress=IF_SOURCECARE;

		mcConfig.groupBehavior=RT_MC_BEHAVIOR_GROUP_AS_KNOW;
		mcConfig.is_ipv6=groupCb->isIPv6;

		if(groupCb->isIPv6)
			memcpy(&mcConfig.group_addr.ipv6[0],&groupCb->group[0],sizeof(mcConfig.group_addr));
		else
			mcConfig.group_addr.ipv4=groupCb->group[0];

		ret = rt_igmp_multicastGroup_set (mcConfig);

		if(ret)
			IGMP_WARNING("ret=%d Error",ret);

		return SUCCESS;
	}
	return SUCCESS;
}

int32 _rtk_igmp_groupDelCbEvt(rtk_igmp_groupCbEvt_t *groupCb)
{
	if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_IFIDX || igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORT)
	{
		int ret=0;
		rt_igmp_group_devPort_cfg_t mcDevConfig;
		memset(&mcDevConfig,0,sizeof(mcDevConfig));

		mcDevConfig.careIngressCvid=IF_VLANCARE;
		mcDevConfig.careSourceAddress=IF_SOURCECARE;;

		mcDevConfig.groupBehavior=RT_MC_BEHAVIOR_GROUP_AS_UNKNOW;
		mcDevConfig.is_ipv6=groupCb->isIPv6;

		if(groupCb->isIPv6)
			memcpy(&mcDevConfig.group_addr.ipv6[0],&groupCb->group[0],sizeof(mcDevConfig.group_addr));
		else
			mcDevConfig.group_addr.ipv4=groupCb->group[0];

		ret = rt_igmp_multicastGroupDev_set (mcDevConfig);

		if(ret)
			IGMP_WARNING("ret=%d Error",ret);

		return SUCCESS;
	}
	else if(igmpSysdb.hwCbMode==RTK_IGMP_CONFIG_BY_PORTMASK)
	{
		int ret=0;
		rt_igmp_multicast_group_cfg_t mcConfig;
		memset(&mcConfig,0,sizeof(mcConfig));

		mcConfig.careIngressCvid=IF_VLANCARE;
		mcConfig.careSourceAddress=IF_SOURCECARE;;

		mcConfig.groupBehavior=RT_MC_BEHAVIOR_GROUP_AS_UNKNOW;
		mcConfig.is_ipv6=groupCb->isIPv6;

		if(groupCb->isIPv6)
			memcpy(&mcConfig.group_addr.ipv6[0],&groupCb->group[0],sizeof(mcConfig.group_addr));
		else
			mcConfig.group_addr.ipv4=groupCb->group[0];

		ret = rt_igmp_multicastGroup_set (mcConfig);

		if(ret)
			IGMP_WARNING("ret=%d Error",ret);

		return SUCCESS;
	}
	return SUCCESS;
}


void w_rtk_igmp_hwRegInit(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_hwRegInit();
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_hwRegInit return error %d",ret );
}
void w_rtk_igmp_hwUnRegClear(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_hwUnRegClear();
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_hwUnRegClear return error %d",ret );	
}
void w_rtk_igmp_unknownIpMc_Action(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_unknownIpMc_Action(&p_callback_work->data.unknownCtrl);
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_unknownIpMc_Action return error %d",ret );	
}
void w_rtk_igmp_flowDelCbEvt(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_flowDelCbEvt(&p_callback_work->data.flowCb);
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_flowDelCbEvt return error %d",ret );	
}
void w_rtk_igmp_flowSetCbEvt(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_flowSetCbEvt(&p_callback_work->data.flowCb);
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_flowSetCbEvt return error %d",ret );	
}
void w_rtk_igmp_flowUpdateCbEvt(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_flowUpdateCbEvt(&p_callback_work->data.flowCb);
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_flowUpdateCbEvt return error %d",ret );	
}

void w_rtk_igmp_groupAddCbEvt(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_groupAddCbEvt(&p_callback_work->data.groupCb);
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_groupAddCbEvt return error %d",ret );	
}
void w_rtk_igmp_groupDelCbEvt(struct work_struct *p_work)
{
	int ret;
	rtk_igmp_CbWorkq_t *p_callback_work = container_of(p_work, rtk_igmp_CbWorkq_t, work);
	ret = _rtk_igmp_groupDelCbEvt(&p_callback_work->data.groupCb);
	atomic_inc(&wqFreeCnt);
	rtk_igmp_callbackwq_free(p_callback_work);
	if(ret)
		printk("igmp callback w_rtk_igmp_groupDelCbEvt return error %d",ret );	
}


int32 rtk_igmp_hwRegInit(void)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work = rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_hwRegInit);
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}
int32 rtk_igmp_hwUnRegClear(void)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work =  rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_unknownIpMc_Action);
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}
int32 rtk_igmp_unknownIpMc_Action(rtk_igmp_unknownMcCbEvt_t *unknownCtrl)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work = rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_unknownIpMc_Action);
	memcpy(&work->data.unknownCtrl,unknownCtrl,sizeof(work->data.unknownCtrl));
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}
int32 rtk_igmp_flowDelCbEvt(rtk_igmp_flowCbEvt_t *flowCb)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work =  rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_flowDelCbEvt);
	memcpy(&work->data.flowCb,flowCb,sizeof(work->data.flowCb));
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}
int32 rtk_igmp_flowSetCbEvt(rtk_igmp_flowCbEvt_t *flowCb)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work =  rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_flowSetCbEvt);
	memcpy(&work->data.flowCb,flowCb,sizeof(work->data.flowCb));
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}
int32 rtk_igmp_flowUpdateCbEvt(rtk_igmp_flowCbEvt_t *flowCb)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work =  rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_flowUpdateCbEvt);
	memcpy(&work->data.flowCb,flowCb,sizeof(work->data.flowCb));
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}

int32 rtk_igmp_groupAddCbEvt(rtk_igmp_groupCbEvt_t *groupCb)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work =  rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_groupAddCbEvt);
	memcpy(&work->data.groupCb,groupCb,sizeof(work->data.groupCb));	
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");	
	return SUCCESS;
}
int32 rtk_igmp_groupDelCbEvt(rtk_igmp_groupCbEvt_t *groupCb)
{
	int32 ret;
	rtk_igmp_CbWorkq_t *work =  rtk_igmp_callbackwq_malloc();
	if(work==NULL)
	{
		printk("igmp no Menory Error");
		return SUCCESS;
	}	
	atomic_inc(&wqAllocCnt);
	INIT_WORK(&work->work, w_rtk_igmp_groupDelCbEvt);
	memcpy(&work->data.groupCb,groupCb,sizeof(work->data.groupCb));	
	ret=schedule_work(&work->work);
	if(ret==false)
		printk("Wq Error\n");
	return SUCCESS;
}

