#include <rtk_igmp_tinyPS_mcfwd.h>
#include <rtk_igmp_snooping.h>
#include <rtk_igmp_debug.h>
#include <rtk_igmp_hook.h>
#include <net/ip6_route.h>
#include <net/dst.h>
#include <net/ipv6.h>
#include <net/ip.h>
#include <linux/skbuff.h>
#include <linux/netfilter_ipv6.h>

extern int dev_queue_xmit(struct sk_buff *skb);


#if LINUX_VERSION_CODE > KERNEL_VERSION(4, 1, 0)

int rtk_igmp_br_dev_queue_xmit(struct net *net, struct sock *sk, struct sk_buff *skb)
{
	skb_push(skb, ETH_HLEN);
	br_drop_fake_rtable(skb);
	dev_queue_xmit(skb);
	return 0;
}
int rtk_igmp_br_forward(struct net *net, struct sock *sk, struct sk_buff *skb)
{
	return NF_HOOK(NFPROTO_BRIDGE, NF_BR_POST_ROUTING,net,sk,skb, NULL, skb->dev,rtk_igmp_br_dev_queue_xmit);
}

#else

int rtk_igmp_br_dev_queue_xmit(struct sk_buff *skb)
{
	skb_push(skb, ETH_HLEN);
	br_drop_fake_rtable(skb);
	dev_queue_xmit(skb);
	return 0;
}

int rtk_igmp_br_forward(struct sk_buff *skb,struct sk_buff *sendskb)
{
	return NF_HOOK(NFPROTO_BRIDGE, NF_BR_POST_ROUTING, skb, NULL, skb->dev,rtk_igmp_br_dev_queue_xmit);
}

#endif

int rtk_igmp_sendto_L3_NF_HOOK(struct net *net, struct sock *sk, struct sk_buff *send_skb)
{
#if LINUX_VERSION_CODE > KERNEL_VERSION(4, 1, 0)
	if(igmpSysdb.igmp_debug_level&RTK_IGMP_DEBUG_LEVEL_DUMP)
		igmp_dump_packet(skb_mac_header(send_skb)-ETH_HLEN,send_skb->len+send_skb->mac_len+ETH_HLEN,"IGMP Egress");
	IGMP_DATA("Continue to check NF_BR_LOCAL_OUT/NF_BR_POST_ROUTING and Forward to Dev:%s[%d]",send_skb->dev->name,send_skb->dev->ifindex);
	return NF_HOOK(NFPROTO_BRIDGE, NF_BR_LOCAL_OUT,net, NULL, send_skb, NULL, send_skb->dev,rtk_igmp_br_forward);
#else
	if(igmpSysdb.igmp_debug_level&RTK_IGMP_DEBUG_LEVEL_DUMP)				
		igmp_dump_packet(skb_mac_header(send_skb)-ETH_HLEN,send_skb->len+send_skb->mac_len+ETH_HLEN,"IGMP Egress");
	IGMP_DATA("Continue to check NF_BR_LOCAL_OUT/NF_BR_POST_ROUTING and Forward to Dev:%s[%d]",send_skb->dev->name,send_skb->dev->ifindex);
	return NF_HOOK(NFPROTO_BRIDGE, NF_BR_LOCAL_OUT, send_skb, NULL, send_skb->dev,rtk_igmp_br_forward);
#endif
}


int rtk_igmp_sendto_L2_NF_HOOK(struct net *net, struct sock *sk, struct sk_buff *send_skb,struct net_device *indev)
{
#if LINUX_VERSION_CODE > KERNEL_VERSION(4, 1, 0)
	if(igmpSysdb.igmp_debug_level&RTK_IGMP_DEBUG_LEVEL_DUMP)
		igmp_dump_packet(skb_mac_header(send_skb),send_skb->len+send_skb->mac_len,"IGMP Egress");
	IGMP_DATA("Continue to check NF_BR_FORWARD/NF_BR_POST_ROUTING and Forward to Dev:%s[%d]",send_skb->dev->name,send_skb->dev->ifindex);
	return NF_HOOK(NFPROTO_BRIDGE, NF_BR_FORWARD, net, NULL,send_skb, indev, send_skb->dev,rtk_igmp_br_forward);
#else
	if(igmpSysdb.igmp_debug_level&RTK_IGMP_DEBUG_LEVEL_DUMP)
		igmp_dump_packet(skb_mac_header(send_skb),send_skb->len+send_skb->mac_len,"IGMP Egress");
	IGMP_DATA("Continue to check NF_BR_FORWARD/NF_BR_POST_ROUTING and Forward to Dev:%s[%d]",send_skb->dev->name,send_skb->dev->ifindex);
	return NF_HOOK(NFPROTO_BRIDGE, NF_BR_FORWARD,send_skb, indev, send_skb->dev,rtk_igmp_br_forward);
#endif
}

#if 0
/* simulate  ip_finish_output and ip6_finish_output*/
static void ip6_copy_metadata(struct sk_buff *to, struct sk_buff *from)
{
	to->pkt_type = from->pkt_type;
	to->priority = from->priority;
	to->protocol = from->protocol;
	skb_dst_drop(to);
	skb_dst_set(to, dst_clone(skb_dst(from)));
	to->dev = from->dev;
	to->mark = from->mark;

#ifdef CONFIG_NET_SCHED
	to->tc_index = from->tc_index;
#endif
	nf_copy(to, from);
	skb_copy_secmark(to, from);
}


/* full copy from  ip6_fragment because of ip6_fragment is not a EXPORT_SYMBOL*/
static int _ip6_fragment(struct net *net, struct sock *sk, struct sk_buff *skb,
		 int (*output)(struct net *, struct sock *, struct sk_buff *))
{
	struct sk_buff *frag;
	struct rt6_info *rt = (struct rt6_info *)skb_dst(skb);
	struct ipv6_pinfo *np = skb->sk && !dev_recursion_level() ?
				inet6_sk(skb->sk) : NULL;
	struct ipv6hdr *tmp_hdr;
	struct frag_hdr *fh;
	unsigned int mtu, hlen, left, len;
	int hroom, troom;
	__be32 frag_id;
	int ptr, offset = 0, err = 0;
	u8 *prevhdr, nexthdr = 0;

	err = ip6_find_1stfragopt(skb, &prevhdr);
	if (err < 0)
		goto fail;
	hlen = err;
	nexthdr = *prevhdr;

	mtu = ip6_skb_dst_mtu(skb);

	/* We must not fragment if the socket is set to force MTU discovery
	 * or if the skb it not generated by a local socket.
	 */
	if (unlikely(!skb->ignore_df && skb->len > mtu))
		goto fail_toobig;

	if (IP6CB(skb)->frag_max_size) {
		if (IP6CB(skb)->frag_max_size > mtu)
			goto fail_toobig;

		/* don't send fragments larger than what we received */
		mtu = IP6CB(skb)->frag_max_size;
		if (mtu < IPV6_MIN_MTU)
			mtu = IPV6_MIN_MTU;
	}

	if (np && np->frag_size < mtu) {
		if (np->frag_size)
			mtu = np->frag_size;
	}
	if (mtu < hlen + sizeof(struct frag_hdr) + 8)
		goto fail_toobig;
	mtu -= hlen + sizeof(struct frag_hdr);

	frag_id = ipv6_select_ident(net, &ipv6_hdr(skb)->daddr,
				    &ipv6_hdr(skb)->saddr);

	if (skb->ip_summed == CHECKSUM_PARTIAL &&
	    (err = skb_checksum_help(skb)))
		goto fail;

	hroom = LL_RESERVED_SPACE(rt->dst.dev);
	if (skb_has_frag_list(skb)) {
		int first_len = skb_pagelen(skb);
		struct sk_buff *frag2;

		if (first_len - hlen > mtu ||
		    ((first_len - hlen) & 7) ||
		    skb_cloned(skb) ||
		    skb_headroom(skb) < (hroom + sizeof(struct frag_hdr)))
			goto slow_path;

		skb_walk_frags(skb, frag) {
			/* Correct geometry. */
			if (frag->len > mtu ||
			    ((frag->len & 7) && frag->next) ||
			    skb_headroom(frag) < (hlen + hroom + sizeof(struct frag_hdr)))
				goto slow_path_clean;

			/* Partially cloned skb? */
			if (skb_shared(frag))
				goto slow_path_clean;

			BUG_ON(frag->sk);
			if (skb->sk) {
				frag->sk = skb->sk;
				frag->destructor = sock_wfree;
			}
			skb->truesize -= frag->truesize;
		}

		err = 0;
		offset = 0;
		/* BUILD HEADER */

		*prevhdr = NEXTHDR_FRAGMENT;
		tmp_hdr = kmemdup(skb_network_header(skb), hlen, GFP_ATOMIC);
		if (!tmp_hdr) {
			err = -ENOMEM;
			goto fail;
		}
		frag = skb_shinfo(skb)->frag_list;
		skb_frag_list_init(skb);

		__skb_pull(skb, hlen);
		fh = (struct frag_hdr *)__skb_push(skb, sizeof(struct frag_hdr));
		__skb_push(skb, hlen);
		skb_reset_network_header(skb);
		memcpy(skb_network_header(skb), tmp_hdr, hlen);

		fh->nexthdr = nexthdr;
		fh->reserved = 0;
		fh->frag_off = htons(IP6_MF);
		fh->identification = frag_id;

		first_len = skb_pagelen(skb);
		skb->data_len = first_len - skb_headlen(skb);
		skb->len = first_len;
		ipv6_hdr(skb)->payload_len = htons(first_len -
						   sizeof(struct ipv6hdr));

		dst_hold(&rt->dst);

		for (;;) {
			/* Prepare header of the next frame,
			 * before previous one went down. */
			if (frag) {
				frag->ip_summed = CHECKSUM_NONE;
				skb_reset_transport_header(frag);
				fh = (struct frag_hdr *)__skb_push(frag, sizeof(struct frag_hdr));
				__skb_push(frag, hlen);
				skb_reset_network_header(frag);
				memcpy(skb_network_header(frag), tmp_hdr,
				       hlen);
				offset += skb->len - hlen - sizeof(struct frag_hdr);
				fh->nexthdr = nexthdr;
				fh->reserved = 0;
				fh->frag_off = htons(offset);
				if (frag->next)
					fh->frag_off |= htons(IP6_MF);
				fh->identification = frag_id;
				ipv6_hdr(frag)->payload_len =
						htons(frag->len -
						      sizeof(struct ipv6hdr));
				ip6_copy_metadata(frag, skb);
			}

			err = output(net, sk, skb);
			if (!err)
				IP6_INC_STATS(net, ip6_dst_idev(&rt->dst),
					      IPSTATS_MIB_FRAGCREATES);

			if (err || !frag)
				break;

			skb = frag;
			frag = skb->next;
			skb->next = NULL;
		}

		kfree(tmp_hdr);

		if (err == 0) {
			IP6_INC_STATS(net, ip6_dst_idev(&rt->dst),
				      IPSTATS_MIB_FRAGOKS);
			ip6_rt_put(rt);
			return 0;
		}

		kfree_skb_list(frag);

		IP6_INC_STATS(net, ip6_dst_idev(&rt->dst),
			      IPSTATS_MIB_FRAGFAILS);
		ip6_rt_put(rt);
		return err;

slow_path_clean:
		skb_walk_frags(skb, frag2) {
			if (frag2 == frag)
				break;
			frag2->sk = NULL;
			frag2->destructor = NULL;
			skb->truesize += frag2->truesize;
		}
	}

slow_path:
	left = skb->len - hlen;		/* Space per frame */
	ptr = hlen;			/* Where to start from */

	/*
	 *	Fragment the datagram.
	 */

	troom = rt->dst.dev->needed_tailroom;

	/*
	 *	Keep copying data until we run out.
	 */
	while (left > 0)	{
		u8 *fragnexthdr_offset;

		len = left;
		/* IF: it doesn't fit, use 'mtu' - the data space left */
		if (len > mtu)
			len = mtu;
		/* IF: we are not sending up to and including the packet end
		   then align the next start on an eight byte boundary */
		if (len < left)	{
			len &= ~7;
		}

		/* Allocate buffer */
		frag = alloc_skb(len + hlen + sizeof(struct frag_hdr) +
				 hroom + troom, GFP_ATOMIC);
		if (!frag) {
			err = -ENOMEM;
			goto fail;
		}

		/*
		 *	Set up data on packet
		 */

		ip6_copy_metadata(frag, skb);
		skb_reserve(frag, hroom);
		skb_put(frag, len + hlen + sizeof(struct frag_hdr));
		skb_reset_network_header(frag);
		fh = (struct frag_hdr *)(skb_network_header(frag) + hlen);
		frag->transport_header = (frag->network_header + hlen +
					  sizeof(struct frag_hdr));

		/*
		 *	Charge the memory for the fragment to any owner
		 *	it might possess
		 */
		if (skb->sk)
			skb_set_owner_w(frag, skb->sk);

		/*
		 *	Copy the packet header into the new buffer.
		 */
		skb_copy_from_linear_data(skb, skb_network_header(frag), hlen);

		fragnexthdr_offset = skb_network_header(frag);
		fragnexthdr_offset += prevhdr - skb_network_header(skb);
		*fragnexthdr_offset = NEXTHDR_FRAGMENT;

		/*
		 *	Build fragment header.
		 */
		fh->nexthdr = nexthdr;
		fh->reserved = 0;
		fh->identification = frag_id;

		/*
		 *	Copy a block of the IP datagram.
		 */
		BUG_ON(skb_copy_bits(skb, ptr, skb_transport_header(frag),
				     len));
		left -= len;

		fh->frag_off = htons(offset);
		if (left > 0)
			fh->frag_off |= htons(IP6_MF);
		ipv6_hdr(frag)->payload_len = htons(frag->len -
						    sizeof(struct ipv6hdr));

		ptr += len;
		offset += len;

		/*
		 *	Put this fragment into the sending queue.
		 */
		err = output(net, sk, frag);
		if (err)
			goto fail;

		IP6_INC_STATS(net, ip6_dst_idev(skb_dst(skb)),
			      IPSTATS_MIB_FRAGCREATES);
	}
	IP6_INC_STATS(net, ip6_dst_idev(skb_dst(skb)),
		      IPSTATS_MIB_FRAGOKS);
	consume_skb(skb);
	return err;

fail_toobig:
	if (skb->sk && dst_allfrag(skb_dst(skb)))
		sk_nocaps_add(skb->sk, NETIF_F_GSO_MASK);

	skb->dev = skb_dst(skb)->dev;
	icmpv6_send(skb, ICMPV6_PKT_TOOBIG, 0, mtu);
	err = -EMSGSIZE;

fail:
	IP6_INC_STATS(net, ip6_dst_idev(skb_dst(skb)),
		      IPSTATS_MIB_FRAGFAILS);
	kfree_skb(skb);
	return err;
}

#endif


void rtk_igmp_ip_finish_output(uint8 isL3Forward,uint8 isIpv6, struct net_device *indev, struct sk_buff *skb)
{
	struct sock *sk=NULL;
	struct net *net=NULL;
	//do not using gsofunction

#if LINUX_VERSION_CODE > KERNEL_VERSION(4, 1, 0)
	net= dev_net(indev);
#endif

	if(isL3Forward) 	
	{
/* not support fragment packet yet*/
#if 0
		if(isIpv6)
		{
			IGMP_DATA("skb->len=%d MTU=%d",skb->len,ip6_skb_dst_mtu(skb));
			/* reference to ip6_finish_output*/
			if ((skb->len > ip6_skb_dst_mtu(skb) /*&& !skb_is_gso(skb) */) ||
				dst_allfrag(skb_dst(skb)) ||
				(IP6CB(skb)->frag_max_size && skb->len > IP6CB(skb)->frag_max_size))
			{
				IGMP_DATA("IGMP Fragment Packet do _ip6_fragment");
				_ip6_fragment(net, sk, skb, rtk_igmp_sendto_L3_NF_HOOK);
			}
			else
				rtk_igmp_sendto_L3_NF_HOOK(net, sk, skb);
		}
		else
		{
	
			/* reference to ip_finish_output*/
			unsigned int mtu;
#if 0
			/* Policy lookup after SNAT yielded a new policy */
			if (skb_dst(skb)->xfrm) {
				IPCB(skb)->flags |= IPSKB_REROUTED;
				return dst_output(net, sk, skb);
			}

			mtu = ip_skb_dst_mtu(skb);
			if (skb_is_gso(skb))
				return ip_finish_output_gso(net, sk, skb, mtu);
#endif		
			mtu = ip_skb_dst_mtu(skb);
			IGMP_DATA("skb->len=%d MTU=%d",skb->len,mtu);
			if (skb->len > mtu || (IPCB(skb)->flags & IPSKB_FRAG_PMTU))
			{
				/*reference to  ip_fragment*/
				//ip_fragment(net, sk, skb, mtu, rtk_igmp_sendto_L3_NF_HOOK);
				struct iphdr *iph = ip_hdr(skb);
				if ((iph->frag_off & htons(IP_DF)) == 0)
				{
					IGMP_DATA("IGMP Fragment Packet do ip_do_fragment");
					ip_do_fragment(net, sk, skb, rtk_igmp_sendto_L3_NF_HOOK);
					return;
				}

#if 0			/*multicast  do not send ICMP to sender*/
				if (unlikely(!skb->ignore_df ||
					     (IPCB(skb)->frag_max_size &&
					      IPCB(skb)->frag_max_size > mtu))) {
					IP_INC_STATS(net, IPSTATS_MIB_FRAGFAILS);
					icmp_send(skb, ICMP_DEST_UNREACH, ICMP_FRAG_NEEDED,
						  htonl(mtu));
					kfree_skb(skb);
					return -EMSGSIZE;
				}
#endif
				IGMP_DATA("IGMP Fragment Packet do ip_do_fragment");
				ip_do_fragment(net, sk, skb, rtk_igmp_sendto_L3_NF_HOOK);
				return;

			}
			else			
				rtk_igmp_sendto_L3_NF_HOOK(net, sk, skb);
		}
#else
		rtk_igmp_sendto_L3_NF_HOOK(net, sk, skb);
#endif
	}
	else
	{
		rtk_igmp_sendto_L2_NF_HOOK(net, sk, skb,indev);
	}

	return;

}

#define CHECK_FLOW_L4_EN 0

rtk_igmp_nf_ret_e_t rtk_igmp_data_process( struct sk_buff *skb,rtk_igmp_pktHdr_t *pPkthdr, const struct net_device *SrcDev,const struct net_device *DstDev)
{

	int i ;
	int32 ret=RTK_IGMP_NF_DROP;
	struct rtk_igmp_multicastFwdInfo fwdInfo;
	struct rtk_igmp_multicastDataInfo dataInfo;

	//l2 DA/SA buf
	unsigned char *p_eth_hdr=NULL;

	memset(&dataInfo,0,sizeof(dataInfo));
	memset(&fwdInfo,0,sizeof(fwdInfo));


	if(pPkthdr->ingressCtagif)
	{
		dataInfo.vlanId = pPkthdr->ingressCvid;
		dataInfo.vlanTagif=1;
	}
	else
	{
		dataInfo.vlanTagif=0;
	}

	if(pPkthdr->iph)
	{
		p_eth_hdr=((unsigned char *)pPkthdr->iph)-ETH_HLEN;
		dataInfo.ipVersion = IP_VERSION4;
		dataInfo.groupAddr[0] = ntohl(pPkthdr->iph->daddr);
		dataInfo.sourceIp[0] =  ntohl(pPkthdr->iph->saddr);
	}
	else if(pPkthdr->ip6h)
	{
		p_eth_hdr=((unsigned char *)pPkthdr->ip6h)-ETH_HLEN;
		dataInfo.ipVersion = IP_VERSION6;
		memcpy(dataInfo.groupAddr,&pPkthdr->ip6h->daddr.s6_addr[0],sizeof(dataInfo.groupAddr));
		memcpy(dataInfo.sourceIp,&pPkthdr->ip6h->saddr.s6_addr[0],sizeof(dataInfo.sourceIp));
	}
	else
	{
		IGMP_DATA("non v4/v6 packet accept");
		return RTK_IGMP_NF_ACCEPT;
	}

	if(pPkthdr->udph && CHECK_FLOW_L4_EN==1)
	{
		dataInfo.l4proto = pPkthdr->l4proto;
		dataInfo.dport = ntohs(pPkthdr->udph->dest);
		dataInfo.sport = ntohs(pPkthdr->udph->source);
	}
	else
	{
		dataInfo.l4proto = FAIL;
		dataInfo.dport = FAIL;
		dataInfo.sport = FAIL;
	}
#if defined(CONFIG_RTL_NEW_FLOW_BASE_HWNAT_DRIVER) || defined(CONFIG_RTK_L34_FLEETCONNTRACK_ENABLE)	
	if(skb->fcIngressData.mcDummyPkt)
		dataInfo.privateField|=DUMMY_PKT;
	if(skb->fcIngressData.doLearning==0)
		dataInfo.privateField|=SKIP_LEARNING;
#endif

	igmp_spin_lock_bh(igmpSysdb.lock_igmp);
	ret = rtk_igmp_getMulticastDataFwdInfo(SrcDev,DstDev,1,&dataInfo,&fwdInfo);
	igmp_spin_unlock_bh(igmpSysdb.lock_igmp);

	if(ret !=SUCCESS)
	{
		if(fwdInfo.reservedMCast)
		{
			IGMP_DATA("Reserved multicast Keeping NF_ACCEPT to Protocol-Stack");
			return RTK_IGMP_NF_ACCEPT;
		}
		else if (fwdInfo.dropPkt)
		{
			IGMP_DATA("fwd non member dropPkt");
			return RTK_IGMP_NF_DROP;
		}
		else if (fwdInfo.unknownMCast)
		{
			IGMP_DATA("unknownMCast pkt");
			//return RTK_IGMP_NF_DROP;  //maybe disable snooping do not dorp
		}
		else
		{
			IGMP_DATA("rtk_igmp_getMulticastDataFwdInfo ret =%d",ret);
		}
		return RTK_IGMP_NF_ACCEPT;
	}

	//change sa to DstDev if routing multicast Data
	if(!SrcDev && DstDev && DstDev->dev_addr &&(DstDev->dev_addr[0]|DstDev->dev_addr[1]|DstDev->dev_addr[2]|DstDev->dev_addr[3]|DstDev->dev_addr[4]|DstDev->dev_addr[5]))
	{

		//change SA
		IGMP_DATA("Multicast Routing Change SA to %pM",DstDev->dev_addr);
		memcpy(p_eth_hdr+ETH_ALEN,DstDev->dev_addr,ETH_ALEN);

		//change DA/ETHTYPE
		if(pPkthdr->ip6h)
		{
			p_eth_hdr[0]=0x33;
			p_eth_hdr[1]=0x33;
			p_eth_hdr[2]=pPkthdr->ip6h->daddr.in6_u.u6_addr8[12];
			p_eth_hdr[3]=pPkthdr->ip6h->daddr.in6_u.u6_addr8[13];
			p_eth_hdr[4]=pPkthdr->ip6h->daddr.in6_u.u6_addr8[14];
			p_eth_hdr[5]=pPkthdr->ip6h->daddr.in6_u.u6_addr8[15];
			p_eth_hdr[12]=0x86;
			p_eth_hdr[13]=0xdd;
		}
		else if(pPkthdr->iph)
		{
			p_eth_hdr[0]=0x01;
			p_eth_hdr[1]=0x00;
			p_eth_hdr[2]=0x5e;
			p_eth_hdr[3]=(ntohl(pPkthdr->iph->daddr) & 0x007f0000)>>16;
			p_eth_hdr[4]=(ntohl(pPkthdr->iph->daddr) & 0xff00)>>8;
			p_eth_hdr[5]=(ntohl(pPkthdr->iph->daddr) & 0xff);
			p_eth_hdr[12]=0x08;
			p_eth_hdr[13]=0x00;
		}
		//skb_push(skb, hh_cacheBufLen);
		//skb_reset_mac_header(skb);

		/*For pppoe routing multicast data case, skb->mac_header is equal to skb->network_header .
		  But skb->mac_header is used for mac matching at the ebtables output chain .
		  So skb->mac_header needs to be set at here .
		*/
		skb->mac_header = p_eth_hdr - skb->head;
		skb_reset_mac_len(skb);
	}

	for(i=0 ;i< IGMP_MAX_DEV_NUM ;i++)
	{
 		struct sk_buff *send_skb;
 		struct net_device *indev,*outdev;

 		if(fwdInfo.egressDevInfo[i].valid)
 		{
			if(SrcDev  && fwdInfo.egressDevInfo[i].devIfIdx ==SrcDev->ifindex)
			{
				IGMP_DATA("Skip send to Dev:%s[%d] By Source Dev Filter",SrcDev->name,SrcDev->ifindex);
				continue;
			}

	 		indev = skb->dev;
	 		outdev = rtk_igmp_devIfidx_to_dev(fwdInfo.egressDevInfo[i].devIfIdx);

			if(indev == NULL || outdev==NULL)
			{
				IGMP_DATA("NULL indev/outdev send");
				continue;
			}

	 		send_skb = skb_copy(skb, GFP_ATOMIC);
	 		send_skb->dev =outdev;
	 		skb_forward_csum(send_skb);

			//send to dev
			rtk_igmp_ip_finish_output(DstDev?TRUE:FALSE,pPkthdr->ip6h?TRUE:FALSE,indev,send_skb);
			
 		}
		else
			break;
	}

	return RTK_IGMP_NF_DROP;
}



