#ifndef _RE_RECYCLESKB_H_
#define _RE_RECYCLESKB_H_

#include <linux/skbuff.h>
#include <linux/interrupt.h>
#include <linux/ptool.h>		//performance
#include <linux/kernel.h>		//dump_stack
#include <linux/mm.h>			//get total memory size

#if defined(CONFIG_RTK_L34_G3_PLATFORM)
#include <ca_ni.h>
#include <ca_ext.h>

#define MBUF_LEN CA_NI_SKB_PKT_LEN
#else
#include "../nicDriver/re8686_rtl9607c.h"

#define MBUF_LEN        SKB_BUF_SIZE
#endif

#if defined(RTL_PRIV_DATA_SIZE) && RTL_PRIV_DATA_SIZE > 0
//define reserve 0, because alloc_skb will append RTL_PRIV_DATA_SIZE, so share it
#define RTL_RESERVED_HEADER_SIZE	0 
#else
#define RTL_RESERVED_HEADER_SIZE	128
#endif
#define CROSS_LAN_MBUF_LEN		(MBUF_LEN+16)

#if defined(CONFIG_CMCC)
#define MAX_PRE_ALLOC_RX_SKB	20000
#else
#define MAX_PRE_ALLOC_RX_SKB	5000
#endif

#define MAX_ETH_SKB_NUM	(MAX_PRE_ALLOC_RX_SKB + 600)
#define MAX_CRITICAL_ETH_SKB_NUM 256

#define ETH_RECYCLE_SKB_PROC	1

enum {
	RTL_RECYCLE_QUEUE=0x1,
	RTL_RECYCLE_CRITICAL_QUEUE=0x2,
};

enum {
	RTL_RECYCLE_SWITCH_ON=0x0,
	RTL_RECYCLE_SWITCH_OFF=0x1,
};


#if defined(RTL_RING_BUFFER_RECYCLE_SKB)
enum {
	RTL_RING_BUF_RECYCLE_NORMAL=0x0,
	RTL_RING_BUF_RECYCLE_EMPTY,
	RTL_RING_BUF_RECYCLE_FULL,
};

struct ring_buffer_recycle_t
{
	unsigned int rd_idx;
	unsigned int wr_idx;
	unsigned int state;	//0: normal, 1:empty, 2:full
	unsigned int ring_size_mask;

	struct sk_buff **ring_buffer_recycle_array;
	spinlock_t	lock;
};
#endif
#if defined(RTL_STRAIGHT_ARRAY_RECYCLE_SKB)
struct straight_recycle_t
{
	unsigned int idx;
	struct sk_buff **array;
	spinlock_t	lock;
};
#endif

#define RECYCLE_SPINLOCK(x) spin_lock_bh(x)
#define RECYCLE_SPINUNLOCK(x) spin_unlock_bh(x)


void init_recycle_eth_skb_buf(unsigned int ring_size, unsigned int max_size);
struct sk_buff *dev_alloc_skb_recy_eth(unsigned int size);
struct sk_buff *dev_alloc_critical_skb_recy_eth(unsigned int size);
#define dev_alloc_skb_priv_eth dev_alloc_skb_recy_eth
#define dev_alloc_critical_skb_priv_eth dev_alloc_critical_skb_recy_eth
struct sk_buff *recycle_skb_swap(struct sk_buff *skb);
unsigned int rtl_free_eth_skb_num(void);
unsigned int rtl_free_eth_critical_skb_num(void);

extern int min_free_kbytes;

unsigned int rtl_alloc_eth_skb_num(void);
unsigned int rtl_alloc_eth_critical_skb_num(void);

#endif /*_RE_RECYCLESKB_H_*/
