#ifndef __RT_EDP_PORT_H__
#define __RT_EDP_PORT_H__

typedef enum rt_edp_mac_port_idx_e
{
#if defined(CONFIG_RG_RTL9607C_SERIES)

	RT_EDP_MAC_PORT0=0,
	RT_EDP_MAC_PORT1=1,
	RT_EDP_MAC_PORT2=2,
	RT_EDP_MAC_PORT3=3,
	RT_EDP_MAC_PORT4=4,
	RT_EDP_MAC_PORT_PON=5,
	RT_EDP_MAC_PORT_iNIC=6,
	RT_EDP_MAC_PORT_SLAVECPU=7,
	RT_EDP_MAC_PORT_RGMII=8,
	RT_EDP_MAC_PORT_MASTERCPU_CORE0=9,
	RT_EDP_MAC_PORT_MASTERCPU_CORE1=10,
	RT_EDP_MAC_PORT_MAX,

#elif defined(CONFIG_RG_RTL9603CVD_SERIES)

	RT_EDP_MAC_PORT0=0,
	RT_EDP_MAC_PORT1=1,
	RT_EDP_MAC_PORT2=2,
	RT_EDP_MAC_PORT3=3,
	RT_EDP_MAC_PORT_PON=4,
	RT_EDP_MAC_PORT_CPU=5,
	RT_EDP_MAC_PORT_MAX,

#elif defined(CONFIG_RG_G3_SERIES)

	RT_EDP_MAC_PORT0=0,
	RT_EDP_MAC_PORT1=1,
	RT_EDP_MAC_PORT2=2,
	RT_EDP_MAC_PORT3=3,
#if defined(CONFIG_ARCH_CORTINA_G3HGU)
	RT_EDP_MAC_PORT4=4,
	RT_EDP_MAC_PORT5=5,
	RT_EDP_MAC_PORT6=6,
#if defined(CONFIG_RG_G3_WAN_PORT_INDEX)
	RT_EDP_MAC_PORT_PON=CONFIG_RG_G3_WAN_PORT_INDEX,
#else
	RT_EDP_MAC_PORT_PON=7,
#endif
#else
	RT_EDP_MAC_PORT_PON=7,
#endif
	RT_EDP_MAC_PORT_CPU=0x10,
	RT_EDP_MAC_PORT_CPU_WLAN0_ROOT=0x12,
	RT_EDP_MAC_PORT_CPU_WLAN0_VAP0=0x13,
	RT_EDP_MAC_PORT_CPU_WLAN0_VAP1=0x14,
	RT_EDP_MAC_PORT_CPU_WLAN0_VAP2=0x15,
	RT_EDP_MAC_PORT_CPU_WLAN0_VAP3=0x16,
	RT_EDP_MAC_PORT_CPU_WLAN1_AND_OTHERS=0x17,
	RT_EDP_MAC_PORT_MAX,

#endif

} rt_edp_mac_port_idx_t;

typedef enum rt_edp_mac_ext_port_idx_e
{
#if defined(CONFIG_RG_RTL9607C_SERIES)

	RT_EDP_MAC_EXT_CPU=0,
	RT_EDP_MAC_EXT_PORT0=1,
	RT_EDP_MAC_EXT_PORT1=2,
	RT_EDP_MAC_EXT_PORT2=3,
	RT_EDP_MAC_EXT_PORT3=4,
	RT_EDP_MAC_EXT_PORT4=5,
	RT_EDP_MAC_EXT_PORT5=6,
	RT_EDP_MAC_EXT_PORT_MAX,

#elif defined(CONFIG_RG_RTL9603CVD_SERIES)

	RT_EDP_MAC_EXT_CPU=0,
	RT_EDP_MAC_EXT_PORT0=1,
	RT_EDP_MAC_EXT_PORT1=2,
	RT_EDP_MAC_EXT_PORT2=3,
	RT_EDP_MAC_EXT_PORT3=4,
	RT_EDP_MAC_EXT_PORT4=5,
	RT_EDP_MAC_EXT_PORT5=6,
	RT_EDP_MAC_EXT_PORT_MAX,

#elif defined(CONFIG_RG_G3_SERIES)

	RT_EDP_MAC_EXT_CPU=0,
	RT_EDP_MAC_EXT_PORT0=1,		// wlan0_root
	RT_EDP_MAC_EXT_PORT1=2,		// wlan0_vap0
	RT_EDP_MAC_EXT_PORT2=3,		// wlan0_vap1
	RT_EDP_MAC_EXT_PORT3=4,		// wlan0_vap2
	RT_EDP_MAC_EXT_PORT4=5,		// wlan0_vap3
	RT_EDP_MAC_EXT_PORT5=6,		// others

	RT_EDP_MAC_EXT_PORT_WLAN0_ROOT=RT_EDP_MAC_EXT_PORT0,	// wlan0_root
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP0=RT_EDP_MAC_EXT_PORT1,	// wlan0_vap0
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP1=RT_EDP_MAC_EXT_PORT2,	// wlan0_vap1
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP2=RT_EDP_MAC_EXT_PORT3,	// wlan0_vap2
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP3=RT_EDP_MAC_EXT_PORT4,	// wlan0_vap3
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP4,							// wlan0_vap4
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP5,							// wlan0_vap5
	RT_EDP_MAC_EXT_PORT_WLAN0_VAP6,							// wlan0_vap6
#endif
	RT_EDP_MAC_EXT_PORT_WLAN1_ROOT,							// wlan1_root
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP0,							// wlan1_vap0
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP1,							// wlan1_vap1
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP2,							// wlan1_vap2
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP3,							// wlan1_vap3
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP4,							// wlan1_vap4
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP5,							// wlan1_vap5
	RT_EDP_MAC_EXT_PORT_WLAN1_VAP6,							// wlan1_vap6
#endif
	RT_EDP_MAC_EXT_PORT_MAX,								// 17

#endif

} rt_edp_mac_ext_port_idx_t;


typedef enum rt_edp_port_idx_e
{
#if defined(CONFIG_RG_RTL9607C_SERIES)

	RT_EDP_PORT0=0,
	RT_EDP_PORT1,
	RT_EDP_PORT2,
	RT_EDP_PORT3,
	RT_EDP_PORT4,
	RT_EDP_PORT_PON=5,
	RT_EDP_PORT_iNIC,
	RT_EDP_PORT_SLAVECPU=7,
	RT_EDP_PORT_RGMII,
	RT_EDP_PORT_MASTERCPU_CORE0=9,
	RT_EDP_PORT_MASTERCPU_CORE1=10,
	RT_EDP_EXT_PORT0=11,	// MAC9
	RT_EDP_EXT_PORT1,
	RT_EDP_EXT_PORT2,
	RT_EDP_EXT_PORT3,
	RT_EDP_EXT_PORT4,
	RT_EDP_EXT_PORT5,
	RT_EDP_MAC10_EXT_PORT0=17,
	RT_EDP_MAC10_EXT_PORT1,
	RT_EDP_MAC10_EXT_PORT2,
	RT_EDP_MAC10_EXT_PORT3,
	RT_EDP_MAC10_EXT_PORT4,
	RT_EDP_MAC10_EXT_PORT5,
	RT_EDP_MAC7_EXT_PORT0=23,
	RT_EDP_MAC7_EXT_PORT1,
	RT_EDP_MAC7_EXT_PORT2,
	RT_EDP_MAC7_EXT_PORT3,
	RT_EDP_MAC7_EXT_PORT4,
	RT_EDP_MAC7_EXT_PORT5,
	RT_EDP_PORT_MAX=29,

#elif defined(CONFIG_RG_RTL9603CVD_SERIES)

	RT_EDP_PORT0=0,
	RT_EDP_PORT1,
	RT_EDP_PORT2,
	RT_EDP_PORT3,
	RT_EDP_PORT_PON=4,
	RT_EDP_PORT_CPU,
	RT_EDP_EXT_PORT0=6,
	RT_EDP_EXT_PORT1,
	RT_EDP_EXT_PORT2,
	RT_EDP_EXT_PORT3,
	RT_EDP_EXT_PORT4,
	RT_EDP_EXT_PORT5,
	RT_EDP_PORT_MAX,

#elif defined(CONFIG_RG_G3_SERIES)

	RT_EDP_PORT0=0,
	RT_EDP_PORT1=1,
	RT_EDP_PORT2=2,
	RT_EDP_PORT3=3,
#if defined(CONFIG_ARCH_CORTINA_G3HGU)
	RT_EDP_PORT4=4,
	RT_EDP_PORT5=5,
	RT_EDP_PORT6=6,
#if defined(CONFIG_RG_G3_WAN_PORT_INDEX)
	RT_EDP_PORT_PON=CONFIG_RG_G3_WAN_PORT_INDEX,
#else
	RT_EDP_PORT_PON=7,
#endif
#else
	RT_EDP_PORT_PON=7,
#endif
	RT_EDP_PORT_CPU=0x10,
	RT_EDP_PORT_CPU_WLAN0_ROOT=0x12,
	RT_EDP_PORT_CPU_WLAN0_VAP0=0x13,
	RT_EDP_PORT_CPU_WLAN0_VAP1=0x14,
	RT_EDP_PORT_CPU_WLAN0_VAP2=0x15,
	RT_EDP_PORT_CPU_WLAN0_VAP3=0x16,
	RT_EDP_PORT_CPU_WLAN1_AND_OTHERS=0x17,
	RT_EDP_EXT_PORT0=0x18,	// virtual port for master wifi
	RT_EDP_EXT_PORT1=0x19,	// virtual port for slave wifi
	RT_EDP_EXT_PORT2=0x1a,	// for wwan(vxd)
	RT_EDP_EXT_PORT3=0x1b,	// for wwan(vxd)
	RT_EDP_PORT_MAX,

#endif
} rt_edp_port_idx_t;

#define RT_EDP_PORT_WLAN_OF_MASTER_CPU RT_EDP_EXT_PORT0
#define RT_EDP_PORT_WLAN_OF_SLAVE_CPU RT_EDP_EXT_PORT1

#endif
