#ifndef RTK_RG_ACL_APOLLOFE_H
#define RTK_RG_ACL_APOLLOFE_H

#include <rtk_rg_struct.h>



#define ACL_PER_RULE_FIELD_SIZE 8
#define GLOBAL_ACL_FIELD_SIZE APOLLOFE_RG_ACL_TEMPLATE_END
#define GLOBAL_ACL_RULE_SIZE 8
#define GLOBAL_CF_FIELD_SIZE PATTERN_CF_END
#define GLOBAL_CF_RULE_SIZE 1


#define RG_PURE_CF_PATTERNS (EGRESS_IPV4_SIP_RANGE_BIT|EGRESS_IPV4_DIP_RANGE_BIT|EGRESS_L4_SPORT_RANGE_BIT|EGRESS_L4_DPORT_RANGE_BIT|EGRESS_CTAG_PRI_BIT|EGRESS_CTAG_VID_BIT|INGRESS_EGRESS_PORTIDX_BIT|INTERNAL_PRI_BIT) //not include EGRESS_INTF_BIT beause it can be transform
#define RG_PURE_CF_QOS_ACTION (ACL_ACTION_ACL_CVLANTAG_BIT|ACL_ACTION_ACL_SVLANTAG_BIT|ACL_ACTION_DS_UNIMASK_BIT)


#define PURE_ACL_PATTERN_BITS \
(INGRESS_PORT_BIT|INGRESS_INTF_BIT|INGRESS_ETHERTYPE_BIT|INGRESS_CTAG_PRI_BIT|INGRESS_CTAG_VID_BIT|INGRESS_SMAC_BIT \
|INGRESS_DMAC_BIT|INGRESS_DSCP_BIT|INGRESS_L4_TCP_BIT|INGRESS_L4_UDP_BIT|INGRESS_IPV6_SIP_RANGE_BIT|INGRESS_IPV6_DIP_RANGE_BIT \
|INGRESS_IPV4_SIP_RANGE_BIT|INGRESS_IPV4_DIP_RANGE_BIT|INGRESS_L4_SPORT_RANGE_BIT|INGRESS_L4_DPORT_RANGE_BIT \
|INGRESS_L4_ICMP_BIT|INGRESS_IPV6_DSCP_BIT|INGRESS_STREAM_ID_BIT|INGRESS_STAG_PRI_BIT|INGRESS_STAG_VID_BIT|INGRESS_STAGIF_BIT|INGRESS_CTAGIF_BIT \
|INGRESS_L4_POROTCAL_VALUE_BIT|INGRESS_TOS_BIT|INGRESS_IPV6_TC_BIT|INGRESS_IPV6_SIP_BIT|INGRESS_IPV6_DIP_BIT|INGRESS_WLANDEV_BIT|INGRESS_IPV4_TAGIF_BIT|INGRESS_IPV6_TAGIF_BIT \
|INGRESS_CTAG_CFI_BIT|INGRESS_STAG_DEI_BIT|INGRESS_PKT_LEN_RANGE_BIT)


#define PURE_CF_PATTERN_BITS \
(EGRESS_INTF_BIT|EGRESS_IPV4_SIP_RANGE_BIT|EGRESS_IPV4_DIP_RANGE_BIT \
|EGRESS_L4_SPORT_RANGE_BIT|EGRESS_L4_DPORT_RANGE_BIT|EGRESS_CTAG_PRI_BIT|EGRESS_CTAG_VID_BIT|INGRESS_EGRESS_PORTIDX_BIT|INTERNAL_PRI_BIT)


#define MIN_ACL_ENTRY_INDEX 	RESERVED_ACL_BEFORE
#define MAX_ACL_ENTRY_INDEX 	RESERVED_ACL_AFTER

#define MAX_ACL_SW_ENTRY_SIZE 128

#if defined(CONFIG_APOLLO_FPGA_PHY_TEST)
#define MAX_ACL_ENTRY_SIZE 	16 // [FIXME] limit size for FPGA verify
#define TOTAL_CF_ENTRY_SIZE 	16 // [FIXME] limit size for FPGA verify
#define DEFAULT_CF_PATTERN0_ENTRY_SIZE 	10  // [FIXME] limit size for FPGA verify, pattern0 use CF[0~9], pattern1 use CF[10~15]
#else
#define MAX_ACL_ENTRY_SIZE 	96
#define TOTAL_CF_ENTRY_SIZE 	256
#define DEFAULT_CF_PATTERN0_ENTRY_SIZE 	128
#endif
#define CF_UNI_DEFAULT 0x7	//if flood or multicast, uni default is 0b111(uni 3 bit)
#define MAX_CF_GEMIDX_VALUE 0x40
#define MAX_CF_GEMIDX_MASK 0x7f
#define SW_CF_GEMIDX_MASK 0xffff
#define MAX_CF_LLID_VALUE 0xf

#define MAX_ACL_IPRANGETABLE_SIZE 	32
#define MAX_ACL_PORTRANGETABLE_SIZE 32
#define MAX_ACL_PKTLENRANGETABLE_SIZE RTL9602C_MAX_NUM_OF_RANGE_CHECK_PKTLEN
#define USER_ACL_PKTLENRANGETABLE_START 3
#define MAX_ACL_TEMPLATE_SIZE 8 //this size also limit the acl multiple hit size(one aclSWEntry at most mapping to 4 acl ASIC entry)


#define RESERVED_ACL_BEFORE rg_db.systemGlobal.aclAndCfReservedRule.aclLowerBoundary
#define RESERVED_ACL_AFTER rg_db.systemGlobal.aclAndCfReservedRule.aclUpperBoundary

#define RESERVED_CF_BEFORE 	rg_db.systemGlobal.aclAndCfReservedRule.cfLowerBoundary
#define RESERVED_CF_AFTER 	rg_db.systemGlobal.aclAndCfReservedRule.cfUpperBoundary

#define DEFAULT_L2_WANIF_IDX 0
#define DEFAULT_MC_WANIF_IDX 14

#define HW_ACL_REARRANGE_PROTECT_VERSION 2
#if defined(HW_ACL_REARRANGE_PROTECT_VERSION) && (HW_ACL_REARRANGE_PROTECT_VERSION==2)
typedef enum rtk_rg_aclHWRearrange_protect_rule_idx_s
{
	HW_ACL_REARRANGE_PROTECT_V4MC_PERMIT = 0,
	HW_ACL_REARRANGE_PROTECT_V6MC_PERMIT = 1,
	HW_ACL_REARRANGE_PROTECT_OTHERS_TRAP = 2,
	HW_ACL_REARRANGE_PROTECT_RSV_HEAD = 3,
} rtk_rg_aclHWRearrange_protect_rule_idx_t;
#endif

//Internal
typedef enum rtk_rg_us_cfField_Teamplate_e
{
	TEMPLATE_US_CFG_INTERNAL_CVID_AND_INTERNAL_PRI = 0,
	TEMPLATE_US_CFG_INTERNAL_CVID_AND_EMARKED_PRI = 1,
	TEMPLATE_US_CFG_END,
}rtk_rg_us_cfField_Teamplate_t;

typedef enum rtk_rg_ds_cfField_Teamplate_e
{
	TEMPLATE_DS_CFG_OUTTER_VID_AND_INGRESS_CTAG_PRI = 0,
	TEMPLATE_DS_CFG_INGRESS_CVID_AND_INGRESS_CTAG_PRI = 1,
	TEMPLATE_DS_CFG_END,
}rtk_rg_ds_cfField_Teamplate_t;


typedef enum rtk_rg_aclField_Teamplate_s
{
	//related to Template[0]: used for L2 pattern
	TEMPLATE_DMAC0 				=0,
	TEMPLATE_DMAC1 				=1,
	TEMPLATE_DMAC2 				=2,
	TEMPLATE_SMAC0 				=3,
	TEMPLATE_SMAC1 				=4,
	TEMPLATE_SMAC2 				=5,
	TEMPLATE_CTAG 				=6,
	TEMPLATE_STAG				=7,
	//related to Template[1]: used for L3 pattern
	TEMPLATE_IPv4DIP0 			=8,
	TEMPLATE_IPv4DIP1 			=9,
	TEMPLATE_IPv4SIP0 			=10,
	TEMPLATE_IPv4SIP1			=11,
	TEMPLATE_IP_RANGE_16_31		=12,
	TEMPLATE_ETHERTYPE 			=13,
	TEMPLATE_EXTPORTMASK		=14,
	TEMPLATE_GEMPORT			=15,
	//related to Template[2]: used for L4 pattern
	TEMPLATE_L4_DPORT			=16, //use Field selector[1]
	TEMPLATE_L4_SPORT			=17, //use Field selector[0]
	TEMPLATE_L4PORT_RANGE_16_31	=18,
	TEMPLATE_IP4_TOS_PROTO		=19,
	TEMPLATE_IP6_TC_NH 			=20,
	TEMPLATE_RSV_2_5	 		=21, //not used
	TEMPLATE_RSV_2_6 			=22, //not used
	TEMPLATE_PKT_LEN_RANGE		=23,
	//related to Template[3]: rsv
	TEMPLATE_RSV_3_0			=24, //not used
	TEMPLATE_RSV_3_1			=25, //not used
	TEMPLATE_RSV_3_2			=26, //not used
	TEMPLATE_RSV_3_3			=27, //not used
	TEMPLATE_RSV_3_4			=28, //not used
	TEMPLATE_RSV_3_5			=29, //not used
	TEMPLATE_RSV_3_6			=30, //not used
	TEMPLATE_RSV_3_7			=31, //not used
	//related to Template[4]: rsv
	TEMPLATE_RSV_4_0			=32, //not used
	TEMPLATE_RSV_4_1			=33, //not used
	TEMPLATE_RSV_4_2			=34, //not used
	TEMPLATE_RSV_4_3			=35, //not used
	TEMPLATE_RSV_4_4			=36, //not used
	TEMPLATE_RSV_4_5			=37, //not used
	TEMPLATE_RSV_4_6			=38, //not used
	TEMPLATE_RSV_4_7			=39, //not used

	//related to Template[5]: SIPv6
	TEMPLATE_IPv6SIP0			=40,
	TEMPLATE_IPv6SIP1			=41,
	TEMPLATE_IPv6SIP2			=42,
	TEMPLATE_IPv6SIP3			=43,
	TEMPLATE_IPv6SIP4			=44,
	TEMPLATE_IPv6SIP5			=45,
	TEMPLATE_IPv6SIP6			=46,
	TEMPLATE_IPv6SIP7			=47,

	//related to Template[6]: DIPv6
	TEMPLATE_IPv6DIP0			=48,
	TEMPLATE_IPv6DIP1			=49,
	TEMPLATE_IPv6DIP2			=50,
	TEMPLATE_IPv6DIP3			=51,
	TEMPLATE_IPv6DIP4			=52,
	TEMPLATE_IPv6DIP5			=53,
	TEMPLATE_IPv6DIP6			=54,
	TEMPLATE_IPv6DIP7			=55,

	//related to Template[7]: Must sync to H/W. This template can not be changed.
	TEMPLATE_EGR_IP_RANGE_0_15	=56,
	TEMPLATE_EGR_IP_RANGE_16_31	=57, //used by ACL, do not used by CF
	TEMPLATE_EGR_L4PORT_RANGE_0_15	=58,
	TEMPLATE_EGR_L4PORT_RANGE_16_31 =59,
	TEMPLATE_EGR_DMAC0			=60,
	TEMPLATE_EGR_DMAC1			=61,
	TEMPLATE_EGR_DMAC2			=62,
	TEMPLATE_EGR_IP4_TOS_PROTO_IP6_TC_NH	=63,
	APOLLOFE_RG_ACL_TEMPLATE_END,
}rtk_rg_aclField_Teamplate_t;


typedef enum rtk_rg_cfField_pattern_s
{
	PATTERN_CF_WANINTF			= 0,
	PATTERN_CF_PPPOE_IF 		= 1,
	PATTERN_CF_IPV4_IF 			= 2,
	PATTERN_CF_IPV6_IF 			= 3,
	PATTERN_CF_IPMC_IF 			= 4,
	PATTERN_CF_IGMP_MLD_IF 		= 5,
	PATTERN_CF_ACL_LATCH_TO_CF 	= 6,
	PATTERN_CF_CF_LATCH_TO_ACL 	= 7,
	PATTERN_CF_VID_CFG 			= 8,
	PATTERN_CF_TAG_PRI 			= 9,
	PATTERN_CF_PRI_CFG 			= 10,
	PATTERN_CF_STAG_IF 			= 11,
	PATTERN_CF_CTAG_IF 			= 12,
	PATTERN_CF_UNI 				= 13,
	PATTERN_CF_END 				= 14,
}rtk_rg_cfField_pattern_t;


typedef enum rtk_rg_aclSWEntry_used_tables_field_s
{
	APOLLOFE_RG_ACL_USED_INGRESS_SIP4TABLE = (1<<0),
	APOLLOFE_RG_ACL_USED_INGRESS_DIP4TABLE = (1<<1),
	APOLLOFE_RG_ACL_USED_INGRESS_SIP6TABLE = (1<<2),
	APOLLOFE_RG_ACL_USED_INGRESS_DIP6TABLE = (1<<3),
	APOLLOFE_RG_ACL_USED_INGRESS_SPORTTABLE = (1<<4),
	APOLLOFE_RG_ACL_USED_INGRESS_DPORTTABLE = (1<<5),
	APOLLOFE_RG_ACL_USED_EGRESS_SIP4TABLE = (1<<6),
	APOLLOFE_RG_ACL_USED_EGRESS_DIP4TABLE = (1<<7),
	APOLLOFE_RG_ACL_USED_EGRESS_SIP6TABLE = (1<<8),
	APOLLOFE_RG_ACL_USED_EGRESS_DIP6TABLE = (1<<9),
	APOLLOFE_RG_ACL_USED_EGRESS_SPORTTABLE = (1<<10),
	APOLLOFE_RG_ACL_USED_EGRESS_DPORTTABLE = (1<<11),
	APOLLOFE_RG_ACL_USED_INGRESS_PKTLENTABLE = (1<<12),
} rtk_rg_aclSWEntry_used_tables_field_t;

typedef enum rtk_rg_aclSWEntry_used_tables_index_s
{
	APOLLOFE_RG_ACL_USED_INGRESS_SIP4TABLE_INDEX = 0,
	APOLLOFE_RG_ACL_USED_INGRESS_DIP4TABLE_INDEX = 1,
	APOLLOFE_RG_ACL_USED_INGRESS_SIP6TABLE_INDEX = 2,
	APOLLOFE_RG_ACL_USED_INGRESS_DIP6TABLE_INDEX = 3,
	APOLLOFE_RG_ACL_USED_INGRESS_SPORTTABLE_INDEX = 4,
	APOLLOFE_RG_ACL_USED_INGRESS_DPORTTABLE_INDEX = 5,
	APOLLOFE_RG_ACL_USED_EGRESS_SIP4TABLE_INDEX = 6,
	APOLLOFE_RG_ACL_USED_EGRESS_DIP4TABLE_INDEX = 7,
	APOLLOFE_RG_ACL_USED_EGRESS_SIP6TABLE_INDEX = 8,
	APOLLOFE_RG_ACL_USED_EGRESS_DIP6TABLE_INDEX = 9,
	APOLLOFE_RG_ACL_USED_EGRESS_SPORTTABLE_INDEX = 10,
	APOLLOFE_RG_ACL_USED_EGRESS_DPORTTABLE_INDEX = 11,
	APOLLOFE_RG_ACL_USED_INGRESS_PKTLENTABLE_INDEX = 12,
	USED_TABLE_END = 13,
} rtk_rg_aclSWEntry_used_tables_index_t;


/*ACL Reserved*/
typedef enum rtk_rg_aclAndCf_reserved_type_e
{
	/*HEAD PATCH: The lower index number, the higher acl&cf priority*/
	RTK_RG_ACLANDCF_RESERVED_ACL_SKIP_HW_REARRANGE_PERMIT_AND_TRAP_RESERV=0,
	RTK_RG_ACLANDCF_RESERVED_INTF0_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF1_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF2_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF3_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF4_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF5_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF6_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF7_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF8_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF9_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF10_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF11_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF12_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF13_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF14_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF15_DHCP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_STPBLOCKING,
	RTK_RG_ACLANDCF_RESERVED_MULTICAST_RMA_TRAP,
	RTK_RG_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP,
	RTK_RG_ACLANDCF_RESERVED_WIFI2_IPC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_BROADCAST_TRAP,
	RTK_RG_ACLANDCF_RESERVED_ALL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_UNICAST_TRAP,
	RTK_RG_ACLANDCF_RESERVED_SYN_PACKET_TRAP,
	RTK_RG_ACLANDCF_RESERVED_ACK_PACKET_ASSIGN_PRIORITY,
	RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY,
	RTK_RG_ACLANDCF_RESERVED_L2TP_CONTROL_LCP_PACKET_TRAP_AND_ASSIGN_PRIORITY,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_FAIL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF0_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF1_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF2_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF3_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF4_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF5_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF6_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_PORTBINDING_INTF7_NONE_IP_VLAN_TRANSLATE,
	RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF1_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF2_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF3_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF4_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF5_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF6_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF7_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF8_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF9_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF10_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF11_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF12_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF13_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF14_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_INTF15_DSLITE_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF0_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF1_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF2_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF3_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF4_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF5_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF6_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF7_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF8_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF9_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF10_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF11_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF12_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF13_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF14_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF15_MC_ROUTING_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF0_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF1_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF2_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF3_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF4_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF5_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF6_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF7_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF8_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF9_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF10_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF11_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF12_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF13_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF14_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_IPV6_INTF15_LINK_LOCAL_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE0_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE1_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE2_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE3_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE4_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE5_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE6_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE7_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE8_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE9_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE10_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE11_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE12_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE13_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE14_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE15_DIP_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE0_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE1_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE2_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE3_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE4_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE5_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE6_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE7_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE8_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE9_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE10_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE11_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE12_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE13_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE14_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_RULE15_DIPv6_MASK_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PORT1_TRAP,
	RTK_RG_ACLANDCF_RESERVED_PORT2_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND0_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND1_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND2_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND3_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND5_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND7_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND8_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND9_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND10_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND11_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND12_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND13_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND14_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND15_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND16_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND17_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND18_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND19_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND20_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND21_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND22_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND23_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND24_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND25_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND26_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND27_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND28_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND29_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND30_TRAP,
	RTK_RG_ACLANDCF_RESERVED_VLANBIND31_TRAP,
//
	RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF1_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF2_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF3_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF4_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF5_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF6_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF7_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF8_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF9_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF10_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF11_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF12_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF13_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF14_GATEWAY_IPv4_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF15_GATEWAY_IPv4_TRAP,

	RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF1_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF2_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF3_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF4_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF5_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF6_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF7_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF8_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF9_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF10_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF11_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF12_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF13_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF14_GATEWAY_IPv6_TRAP,
	RTK_RG_ACLANDCF_RESERVED_NETIF15_GATEWAY_IPv6_TRAP,
//
	RTK_RG_ACLANDCF_RESERVED_IGMP_MLD_DROP,
	RTK_RG_ACLANDCF_RESERVED_HEAD_END,

	/*TAIL PATCH: The lower index number, the lower acl&cf priority*/
	RTK_RG_ACLANDCF_RESERVED_LAN_TO_INTERNET_BRIDGEWAN_VLAN_TRANSLATE,
    RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT,
    RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6_PASSTHROUGHT,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_TRAP_ALL8863_US8864_DMAC2CVID_DS8864,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF15ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF14ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF13ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF12ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF11ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF10ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF9ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF8ISPPPOEWAN,
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF7ISPPPOEWAN, //pppoe packet to intf7 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF6ISPPPOEWAN, //pppoe packet to intf6 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF5ISPPPOEWAN, //pppoe packet to intf5 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF4ISPPPOEWAN, //pppoe packet to intf4 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF3ISPPPOEWAN, //pppoe packet to intf3 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF2ISPPPOEWAN, //pppoe packet to intf2 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF1ISPPPOEWAN, //pppoe packet to intf1 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864
	RTK_RG_ACLANDCF_RESERVED_PPPoEPASSTHROUGHT_INTF0ISPPPOEWAN, //pppoe packet to intf0 avoid hit RTK_RG_ACL_RESERVED_PPPoEPASSTHROUGHT_REMARKIN_BY_DMAC2CVID_DOWNSTREAM_ETHTER_8864

	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT0_WITHOUT_FILTER,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT1_WITHOUT_FILTER,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT2_WITHOUT_FILTER,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT3_WITHOUT_FILTER,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT4_WITHOUT_FILTER,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT5_WITHOUT_FILTER,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_INGRESS_CVLAN_FOR_SERVICE_PORT6_WITHOUT_FILTER,

	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF0,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF1,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF2,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF3,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF4,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF5,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF6,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF7,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF8,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF9,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF10,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF11,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF12,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF13,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF14,
	RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF15,
    RTK_RG_ACLANDCF_RESERVED_TAIL_END,
}rtk_rg_aclAndCf_reserved_type_t;

typedef struct rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_s{
	int priority;
}rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_t;

typedef struct rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_s{
	int ingress_vlan; //the interfaces assigned vlan.
	int assigned_priority;
}rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_t;


typedef struct rtk_rg_aclAndCf_reserved_AssignCvlanForServicePortWithoutFilter_s{
	int service_port; //physical port which enabled service port ability.
	int assigned_vid;
}rtk_rg_aclAndCf_reserved_AssignCvlanForServicePortWithoutFilter_t;

typedef struct rtk_rg_aclAndCf_reserved_intf_dhcp_trap_s{
	rtk_mac_t gmac;
}rtk_rg_aclAndCf_reserved_intf_dhcp_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_intf_dslite_trap_s{
	rtk_mac_t smac;
	rtk_ipv6_addr_t ipv6_dip;
}rtk_rg_aclAndCf_reserved_intf_dslite_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_pppoe_intf_multicast_routing_trap_s{
	rtk_mac_t gmac;
}rtk_rg_aclAndCf_reserved_pppoe_intf_multicast_routing_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_intf_linkLocal_trap_s{
	rtk_mac_t gmac;
}rtk_rg_aclAndCf_reserved_intf_linkLocal_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_ack_packet_assign_priority_s{
	int priority;
}rtk_rg_aclAndCf_reserved_ack_packet_assign_priority_t;

typedef struct rtk_rg_aclAndCf_reserved_pppoe_lcp_assign_priority_s{
	int priority;
}rtk_rg_aclAndCf_reserved_pppoe_lcp_assign_priority_t;


typedef struct rtk_rg_aclAndCf_reserved_pppoepassthroughtIntfIsPppoewanPatch_s
{
	rtk_mac_t gmac;
}rtk_rg_aclAndCf_reserved_pppoepassthroughtIntfIsPppoewanPatch_t;

typedef struct rtk_rg_aclAndCf_reserved_pppoepassthroughtDefaulRuletPatch_s
{
	uint32 lanPmsk;
	uint32 wanPmsk;
	uint32 remarkVid;
}rtk_rg_aclAndCf_reserved_pppoepassthroughtDefaulTrapRuletPatch_t;

typedef struct rtk_rg_aclAndCf_reserved_dip_mask_trap_s{
	uint32 dip;
	uint32 mask;
}rtk_rg_aclAndCf_reserved_dip_mask_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_dipv6_mask_trap_s{
	rtk_ipv6_addr_t dipv6;
	rtk_ipv6_addr_t dipv6_mask;
}rtk_rg_aclAndCf_reserved_dipv6_mask_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_vlan_bind_trap_s{
	uint32 portmask;
	uint32 vid;
}rtk_rg_aclAndCf_reserved_vlan_bind_trap_t;

typedef struct rtk_rg_aclAndCf_reserved_none_ip_bind_translate_vid_s{
	uint32 portmask;
	uint32 ingress_vid;
}rtk_rg_aclAndCf_reserved_none_ip_bind_translate_vid_t;

typedef struct rtk_rg_aclAndCf_reserved_igmp_mld_drop_s{
	uint32 portmask;
}rtk_rg_aclAndCf_reserved_igmp_mld_drop_t;


typedef struct rtk_rg_aclAndCf_reserved_lan_to_internet_bridgeWan_translate_vid_s{
	uint32 portmask;
	uint32 wan_vid;
}rtk_rg_aclAndCf_reserved_lan_to_internet_bridgeWan_translate_vid_t;


typedef struct rtk_rg_aclAndCf_reserved_global_s
{
	uint32 aclLowerBoundary; //The End index of acl reserve rules in the head
	uint32 aclUpperBoundary; //The start index of acl reserve rules in the tail
	uint32 cfLowerBoundary;  //The start index of cf reserve rules in the head
	uint32 cfUpperBoundary;  //The start index of cf reserve rules in the tail
	uint8 reservedMask[RTK_RG_ACLANDCF_RESERVED_TAIL_END];
	//rtk_rg_aclAndCf_reserved_type_t reservedMask;

	uint32 acl_MC_temp_permit_idx; //this index is reserved for user ACL rearrange, and reserved by type RTK_RG_ACLANDCF_RESERVED_BROADCAST_TRAP or RTK_RG_ACLANDCF_RESERVED_ALL_TRAP

	int aclSkipRearrangeIPv4MCPermitIdx;//rsv HW ACL index for multicast permit, used when aclSkipRearrangeHWAclCf==1
	int aclSkipRearrangeIPv6MCPermitIdx;//rsv HW ACL index for multicast permit, used when aclSkipRearrangeHWAclCf==1
	int aclSkipRearrangeAlltTrapIdx;//rsv HW ACL index for rest all trap, used when aclSkipRearrangeHWAclCf==1

	rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_t assignVlanBasedPriorityForInterfacePara[16]; //each array stand for one intf.Idx.
	rtk_rg_aclAndCf_reserved_AssignCvlanForServicePortWithoutFilter_t 	assignCvlanForServicePortWithoutFilterPara[7];//each array stand for one port
	rtk_rg_aclAndCf_reserved_intf_dhcp_trap_t intf_dhcp_trap_para[16]; //each array stand for one intf.Idx.
	rtk_rg_aclAndCf_reserved_intf_dslite_trap_t intf_dslite_trap_para[16];//each array stand for one intf.Idx.
	rtk_rg_aclAndCf_reserved_pppoe_intf_multicast_routing_trap_t pppoe_intf_multicast_routing_trap_para[16];//each array stand for one intf.Idx.
	rtk_rg_aclAndCf_reserved_intf_linkLocal_trap_t intf_link_local_trap_para[16]; //each array stand for one intf.Idx.
	rtk_rg_aclAndCf_reserved_ack_packet_assign_priority_t ack_packet_assign_priority;
	rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_t l2tp_ctrl_lcp_assign_prioity;
	rtk_rg_aclAndCf_reserved_pppoe_lcp_assign_priority_t pppoe_lcp_assign_prioity;
	rtk_rg_aclAndCf_reserved_pppoepassthroughtIntfIsPppoewanPatch_t pppoepassthroughtIntfIsPppoewanpara[16];//each array stand for one intf.Idx.
	rtk_rg_aclAndCf_reserved_pppoepassthroughtDefaulTrapRuletPatch_t	pppoepassthroughtDefaulTrapRulePatchPara;
	rtk_rg_aclAndCf_reserved_dip_mask_trap_t dip_mask_trap[16];
	rtk_rg_aclAndCf_reserved_dipv6_mask_trap_t dipv6_mask_trap[16];
	rtk_rg_aclAndCf_reserved_vlan_bind_trap_t vlan_bind_trap[32];
	rtk_rg_aclAndCf_reserved_none_ip_bind_translate_vid_t none_ip_bind_translate_vid[8];//each array stand for one intf.Idx.  only H/W intf need to patch
	rtk_rg_aclAndCf_reserved_igmp_mld_drop_t igmp_mld_drop_portmask;
	rtk_rg_aclAndCf_reserved_lan_to_internet_bridgeWan_translate_vid_t lan_pask_and_wan_vid;
}rtk_rg_acl_reserved_global_t;


#endif //end of #ifndef RTK_RG_ACL_APOLLOFE_H


