/*
 * Copyright (C) 2012 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
*/

#ifdef CONFIG_SMP
#ifdef	CONFIG_RG_G3_SERIES
#else
#include <bspchip.h> // for smp_affinity setting
#endif
#endif

#include <rtk_rg_define.h>
#include <rtk_rg_struct.h>
#include <rtk_rg_liteRomeDriver.h>
#include <rtk_rg_fwdEngine.h>
#include <rtk_rg_igmpsnooping.h>
//#ifdef CONFIG_RG_DEBUG
#include <rtk_rg_debug.h>
//#endif
#include <rtk_rg_callback.h>
#include <rtk_rg_apollo_liteRomeDriver.h>
#include <rtk_rg_profile.h>
#include <rtk_rg_ipsec.h>
#include <linux/sched.h> //for current
#include <linux/tty.h> //for the tty declarations

#ifdef CONFIG_APOLLO_MODEL
#else
#ifdef __linux__
#include <linux/init.h>
#include <linux/delay.h> //for mdelay
#include <linux/skbuff.h>
#include <linux/timer.h>
#include <linux/proc_fs.h> //for create proc
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/kallsyms.h> //for sprint_symbol
#include <linux/module.h> //for sprint_symbol
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)
//for NPTv6
#include <uapi/linux/netfilter_ipv6/ip6t_NPT.h>
#include <uapi/linux/module.h>
#include <net/ipv6.h>
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)
#include <linux/fs.h>
#else
#include <linux/config.h>
#endif
#include <linux/netdevice.h>
#include <linux/inet.h>	//for hton, in_aton
#else
#include <re8686_sim.h>
#endif
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
#include <dal/apollomp/raw/apollomp_raw_hwmisc.h>
#elif defined(CONFIG_RG_RTL9602C_SERIES)
#include <dal/rtl9602c/dal_rtl9602c_hwmisc.h>
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
#include <dal/rtl9607c/dal_rtl9607c_hwmisc.h>
#elif  defined(CONFIG_RG_RTL9603CVD_SERIES)
#include <dal/rtl9603cvd/dal_rtl9603cvd_hwmisc.h>
#endif

#if defined(CONFIG_RG_G3_SERIES)
#include <rtk_rg_g3_internal.h>
#endif



#ifdef CONFIG_YUEME_DPI
extern int DPI_naptInfoAddCallBack(rtk_rg_naptInfo_t* naptInfo);
extern int DPI_naptInfoDeleteCallBack(rtk_rg_naptInfo_t* naptInfo);
extern int DPI_naptPreRouteCallBack(void *data, rtk_rg_naptDirection_t direct);
extern int DPI_naptForwardCallBack(void *data, rtk_rg_naptDirection_t direct);
#endif

#include <rtk_rg_acl.h>
#include <common/error.h>
#include <rtk/init.h>
#include <rtk/l34_bind_config.h>
#include <rtk/svlan.h>
#include <dal/apollomp/raw/apollomp_raw_hwmisc.h>
#include <rtk/sec.h>
#include <rtk/stat.h>
#include <rtk/ponmac.h>
#include <rtk/cpu.h>

#if defined(CONFIG_RG_RTL9600_SERIES)
#include <dal/apollomp/raw/apollomp_raw_flowctrl.h>
#include <dal/apollomp/raw/apollomp_raw_l2.h>
#endif


//#include <dal/apollomp/dal_apollomp_l34.h>	//FIXME: because RTK do not have binding related APIs
//#include <hal/common/halctrl.h>
//#include <hal/chipdef/apollo/apollo_reg_struct.h>
//#include <hal/mac/reg.h>
#if 0//def CONFIG_RG_LAYER2_SOFTWARE_LEARN
#include <rtk/irq.h>		//for register link-change event
#include <rtk/intr.h>		//for get and clear link-down indicator register
#endif


#if 0 //ysleu: it's not good to mix apollo testing codes and rome driver toghter, the staff we need was redefined in rtk_rg_internal.h
#include <rtl_glue.h>
#include <rtl_utils.h>
#endif
extern rtk_mac_t g_whiteList[WHITELISTSIZE];
extern unsigned int g_whiteList_idx;

#if defined(CONFIG_RG_RTL9602C_SERIES)
#include <rtk_rg_apolloFE_liteRomeDriver.h>
#include <hal/chipdef/rtl9602c/rtk_rtl9602c_reg_struct.h>
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
#include <rtk_rg_apolloPro_liteRomeDriver.h>
#include <hal/chipdef/rtl9607c/rtk_rtl9607c_reg_struct.h>
#include <rtk_rg_apolloPro_asicDriver.h>
#include <rtk_rg_apolloPro_internal.h>
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
#include <rtk_rg_apolloPro_liteRomeDriver.h>
#include <hal/chipdef/rtl9603cvd/rtk_rtl9603cvd_reg_struct.h>
#include <rtk_rg_apolloPro_asicDriver.h>
#include <rtk_rg_apolloPro_internal.h>
#else
struct platform pf=
{
	.rtk_rg_api_module_init= rtk_rg_apollo_api_module_init,
	.rtk_rg_driverVersion_get= rtk_rg_apollo_driverVersion_get,
	.rtk_rg_initParam_get	=rtk_rg_apollo_initParam_get,
	.rtk_rg_initParam_set	=rtk_rg_apollo_initParam_set,
	.rtk_rg_lanInterface_add	=rtk_rg_apollo_lanInterface_add,
//5
	.rtk_rg_wanInterface_add	=rtk_rg_apollo_wanInterface_add,
	.rtk_rg_staticInfo_set	=rtk_rg_apollo_staticInfo_set,
	.rtk_rg_dhcpRequest_set	=rtk_rg_apollo_dhcpRequest_set,
	.rtk_rg_dhcpClientInfo_set	=rtk_rg_apollo_dhcpClientInfo_set,
	.rtk_rg_pppoeClientInfoBeforeDial_set	=rtk_rg_apollo_pppoeClientInfoBeforeDial_set,
//10
	.rtk_rg_pppoeClientInfoAfterDial_set	=rtk_rg_apollo_pppoeClientInfoAfterDial_set,
	.rtk_rg_interface_del	=rtk_rg_apollo_interface_del,
	.rtk_rg_intfInfo_find	=rtk_rg_apollo_intfInfo_find,
	.rtk_rg_cvlan_add	=rtk_rg_apollo_cvlan_add,
	.rtk_rg_cvlan_del	=rtk_rg_apollo_cvlan_del,
//15
	.rtk_rg_cvlan_get=rtk_rg_apollo_cvlan_get,
	.rtk_rg_vlanBinding_add	=rtk_rg_apollo_vlanBinding_add,
	.rtk_rg_vlanBinding_del	=rtk_rg_apollo_vlanBinding_del,
	.rtk_rg_vlanBinding_find	=rtk_rg_apollo_vlanBinding_find,
	.rtk_rg_algServerInLanAppsIpAddr_add	=rtk_rg_apollo_algServerInLanAppsIpAddr_add,
//20
	.rtk_rg_algServerInLanAppsIpAddr_del	=rtk_rg_apollo_algServerInLanAppsIpAddr_del,
	.rtk_rg_algApps_set	=rtk_rg_apollo_algApps_set,
	.rtk_rg_algApps_get	=rtk_rg_apollo_algApps_get,
	.rtk_rg_dmzHost_set	=rtk_rg_apollo_dmzHost_set,
	.rtk_rg_dmzHost_get	=rtk_rg_apollo_dmzHost_get,
//25
	.rtk_rg_virtualServer_add	=rtk_rg_apollo_virtualServer_add,
	.rtk_rg_virtualServer_del	=rtk_rg_apollo_virtualServer_del,
	.rtk_rg_virtualServer_find	=rtk_rg_apollo_virtualServer_find,
	.rtk_rg_aclFilterAndQos_add	=rtk_rg_apollo_aclFilterAndQos_add,
	.rtk_rg_aclFilterAndQos_del	=rtk_rg_apollo_aclFilterAndQos_del,
//30
	.rtk_rg_aclFilterAndQos_find	=rtk_rg_apollo_aclFilterAndQos_find,
	.rtk_rg_macFilter_add	=rtk_rg_apollo_macFilter_add,
	.rtk_rg_macFilter_del	=rtk_rg_apollo_macFilter_del,
	.rtk_rg_macFilter_find	=rtk_rg_apollo_macFilter_find,
	.rtk_rg_mac_filter_whitelist_add	=rtk_rg_apollo_macFilter_whitelist_add,
//35
	.rtk_rg_mac_filter_whitelist_del	=rtk_rg_apollo_macFilter_whitelist_del,
	.rtk_rg_urlFilterString_add	=rtk_rg_apollo_urlFilterString_add,
	.rtk_rg_urlFilterString_del	=rtk_rg_apollo_urlFilterString_del,
	.rtk_rg_urlFilterString_find	=rtk_rg_apollo_urlFilterString_find,
	.rtk_rg_upnpConnection_add	=rtk_rg_apollo_upnpConnection_add,
//40
	.rtk_rg_upnpConnection_del	=rtk_rg_apollo_upnpConnection_del,
	.rtk_rg_upnpConnection_find	=rtk_rg_apollo_upnpConnection_find,
	.rtk_rg_naptConnection_add	=rtk_rg_apollo_naptConnection_add,
	.rtk_rg_naptConnection_del	=rtk_rg_apollo_naptConnection_del,
	.rtk_rg_naptConnection_find	=rtk_rg_apollo_naptConnection_find,
//45
	.rtk_rg_multicastFlow_add	=rtk_rg_apollo_multicastFlow_add,
	.rtk_rg_multicastFlow_del	=rtk_rg_apollo_multicastFlow_del,
	/* martin zhu add */
	.rtk_rg_l2MultiCastFlow_add	=rtk_rg_apollo_l2MultiCastFlow_add,
	.rtk_rg_multicastFlow_find	=rtk_rg_apollo_multicastFlow_find,
	.rtk_rg_macEntry_add	=rtk_rg_apollo_macEntry_add,
//50
	.rtk_rg_macEntry_del	=rtk_rg_apollo_macEntry_del,
	.rtk_rg_macEntry_find	=rtk_rg_apollo_macEntry_find,
	.rtk_rg_arpEntry_add	=rtk_rg_apollo_arpEntry_add,
	.rtk_rg_arpEntry_del	=rtk_rg_apollo_arpEntry_del,
	.rtk_rg_arpEntry_find	=rtk_rg_apollo_arpEntry_find,
//55
	.rtk_rg_neighborEntry_add	=rtk_rg_apollo_neighborEntry_add,
	.rtk_rg_neighborEntry_del	=rtk_rg_apollo_neighborEntry_del,
	.rtk_rg_neighborEntry_find	=rtk_rg_apollo_neighborEntry_find,
	.rtk_rg_accessWanLimit_set	=rtk_rg_apollo_accessWanLimit_set,
	.rtk_rg_accessWanLimit_get	=rtk_rg_apollo_accessWanLimit_get,
//60
	.rtk_rg_accessWanLimitCategory_set	=rtk_rg_apollo_accessWanLimitCategory_set,
	.rtk_rg_accessWanLimitCategory_get	=rtk_rg_apollo_accessWanLimitCategory_get,
	.rtk_rg_softwareSourceAddrLearningLimit_set	=rtk_rg_apollo_softwareSourceAddrLearningLimit_set,
	.rtk_rg_softwareSourceAddrLearningLimit_get	=rtk_rg_apollo_softwareSourceAddrLearningLimit_get,
	.rtk_rg_dosPortMaskEnable_set	=rtk_rg_apollo_dosPortMaskEnable_set,
//65
	.rtk_rg_dosPortMaskEnable_get	=rtk_rg_apollo_dosPortMaskEnable_get,
	.rtk_rg_dosType_set	=rtk_rg_apollo_dosType_set,
	.rtk_rg_dosType_get	=rtk_rg_apollo_dosType_get,
	.rtk_rg_dosFloodType_set	=rtk_rg_apollo_dosFloodType_set,
	.rtk_rg_dosFloodType_get	=rtk_rg_apollo_dosFloodType_get,
//70
	.rtk_rg_portMirror_set	=rtk_rg_apollo_portMirror_set,
	.rtk_rg_portMirror_get	=rtk_rg_apollo_portMirror_get,
	.rtk_rg_portMirror_clear	=rtk_rg_apollo_portMirror_clear,
	.rtk_rg_portEgrBandwidthCtrlRate_set	=rtk_rg_apollo_portEgrBandwidthCtrlRate_set,
	.rtk_rg_portIgrBandwidthCtrlRate_set	=rtk_rg_apollo_portIgrBandwidthCtrlRate_set,
//75
	.rtk_rg_portEgrBandwidthCtrlRate_get	=rtk_rg_apollo_portEgrBandwidthCtrlRate_get,
	.rtk_rg_portIgrBandwidthCtrlRate_get	=rtk_rg_apollo_portIgrBandwidthCtrlRate_get,
	.rtk_rg_phyPortForceAbility_set	=rtk_rg_apollo_phyPortForceAbility_set,
	.rtk_rg_phyPortForceAbility_get	=rtk_rg_apollo_phyPortForceAbility_get,
	.rtk_rg_cpuPortForceTrafficCtrl_set	=rtk_rg_apollo_cpuPortForceTrafficCtrl_set,
//80
	.rtk_rg_cpuPortForceTrafficCtrl_get	=rtk_rg_apollo_cpuPortForceTrafficCtrl_get,
	.rtk_rg_portMibInfo_get	=rtk_rg_apollo_portMibInfo_get,
	.rtk_rg_portMibInfo_clear	=rtk_rg_apollo_portMibInfo_clear,
	.rtk_rg_stormControl_add	=rtk_rg_apollo_stormControl_add,
	.rtk_rg_stormControl_del	=rtk_rg_apollo_stormControl_del,
//85
	.rtk_rg_stormControl_find	=rtk_rg_apollo_stormControl_find,
	.rtk_rg_shareMeter_set	=rtk_rg_apollo_shareMeter_set,
	.rtk_rg_shareMeter_get	=rtk_rg_apollo_shareMeter_get,
	.rtk_rg_shareMeterMode_set =rtk_rg_apollo_shareMeterMode_set,
	.rtk_rg_shareMeterMode_get =rtk_rg_apollo_shareMeterMode_get,
//90
	.rtk_rg_qosStrictPriorityOrWeightFairQueue_set	=rtk_rg_apollo_qosStrictPriorityOrWeightFairQueue_set,
	.rtk_rg_qosStrictPriorityOrWeightFairQueue_get	=rtk_rg_apollo_qosStrictPriorityOrWeightFairQueue_get,
	.rtk_rg_qosInternalPriMapToQueueId_set	=rtk_rg_apollo_qosInternalPriMapToQueueId_set,
	.rtk_rg_qosInternalPriMapToQueueId_get	=rtk_rg_apollo_qosInternalPriMapToQueueId_get,
	.rtk_rg_qosInternalPriDecisionByWeight_set	=rtk_rg_apollo_qosInternalPriDecisionByWeight_set,
//95
	.rtk_rg_qosInternalPriDecisionByWeight_get	=rtk_rg_apollo_qosInternalPriDecisionByWeight_get,
	.rtk_rg_qosDscpRemapToInternalPri_set	=rtk_rg_apollo_qosDscpRemapToInternalPri_set,
	.rtk_rg_qosDscpRemapToInternalPri_get	=rtk_rg_apollo_qosDscpRemapToInternalPri_get,
	.rtk_rg_qosPortBasedPriority_set	=rtk_rg_apollo_qosPortBasedPriority_set,
	.rtk_rg_qosPortBasedPriority_get	=rtk_rg_apollo_qosPortBasedPriority_get,
//100
	.rtk_rg_qosDot1pPriRemapToInternalPri_set	=rtk_rg_apollo_qosDot1pPriRemapToInternalPri_set,
	.rtk_rg_qosDot1pPriRemapToInternalPri_get	=rtk_rg_apollo_qosDot1pPriRemapToInternalPri_get,
	.rtk_rg_qosDscpRemarkEgressPortEnableAndSrcSelect_set	=rtk_rg_apollo_qosDscpRemarkEgressPortEnableAndSrcSelect_set,
	.rtk_rg_qosDscpRemarkEgressPortEnableAndSrcSelect_get	=rtk_rg_apollo_qosDscpRemarkEgressPortEnableAndSrcSelect_get,
	.rtk_rg_qosDscpRemarkByInternalPri_set	=rtk_rg_apollo_qosDscpRemarkByInternalPri_set,
//105
	.rtk_rg_qosDscpRemarkByInternalPri_get	=rtk_rg_apollo_qosDscpRemarkByInternalPri_get,
	.rtk_rg_qosDscpRemarkByDscp_set	=rtk_rg_apollo_qosDscpRemarkByDscp_set,
	.rtk_rg_qosDscpRemarkByDscp_get	=rtk_rg_apollo_qosDscpRemarkByDscp_get,
	.rtk_rg_qosDot1pPriRemarkByInternalPriEgressPortEnable_set	=rtk_rg_apollo_qosDot1pPriRemarkByInternalPriEgressPortEnable_set,
	.rtk_rg_qosDot1pPriRemarkByInternalPriEgressPortEnable_get	=rtk_rg_apollo_qosDot1pPriRemarkByInternalPriEgressPortEnable_get,
//110
	.rtk_rg_qosDot1pPriRemarkByInternalPri_set	=rtk_rg_apollo_qosDot1pPriRemarkByInternalPri_set,
	.rtk_rg_qosDot1pPriRemarkByInternalPri_get	=rtk_rg_apollo_qosDot1pPriRemarkByInternalPri_get,
	.rtk_rg_portBasedCVlanId_set	=rtk_rg_apollo_portBasedCVlanId_set,
	.rtk_rg_portBasedCVlanId_get	=rtk_rg_apollo_portBasedCVlanId_get,
	.rtk_rg_portStatus_get	=rtk_rg_apollo_portStatus_get,
//115
#ifdef CONFIG_RG_NAPT_PORT_COLLISION_PREVENTION
	.rtk_rg_naptExtPortGet	=rtk_rg_apollo_naptExtPortGet,
	.rtk_rg_naptExtPortFree	=rtk_rg_apollo_naptExtPortFree,
#endif
	.rtk_rg_classifyEntry_add	=rtk_rg_apollo_classifyEntry_add,
	.rtk_rg_classifyEntry_find	=rtk_rg_apollo_classifyEntry_find,
	.rtk_rg_classifyEntry_del	=rtk_rg_apollo_classifyEntry_del,
//120
	.rtk_rg_svlanTpid_get= rtk_rg_apollo_svlanTpid_get,
	.rtk_rg_svlanTpid_set= rtk_rg_apollo_svlanTpid_set,
	.rtk_rg_svlanServicePort_set=rtk_rg_apollo_svlanServicePort_set,
	.rtk_rg_svlanServicePort_get=rtk_rg_apollo_svlanServicePort_get,
	.rtk_rg_pppoeInterfaceIdleTime_get=rtk_rg_apollo_pppoeInterfaceIdleTime_get,
//125
	.rtk_rg_gatewayServicePortRegister_add=rtk_rg_apollo_gatewayServicePortRegister_add,
	.rtk_rg_gatewayServicePortRegister_del=rtk_rg_apollo_gatewayServicePortRegister_del,
	.rtk_rg_gatewayServicePortRegister_find=rtk_rg_apollo_gatewayServicePortRegister_find,
	.rtk_rg_wlanDevBasedCVlanId_set=rtk_rg_apollo_wlanDevBasedCVlanId_set,
	.rtk_rg_wlanDevBasedCVlanId_get=rtk_rg_apollo_wlanDevBasedCVlanId_get,
//130
	.rtk_rg_wlanSoftwareSourceAddrLearningLimit_set=rtk_rg_apollo_wlanSoftwareSourceAddrLearningLimit_set,
	.rtk_rg_wlanSoftwareSourceAddrLearningLimit_get=rtk_rg_apollo_wlanSoftwareSourceAddrLearningLimit_get,
	.rtk_rg_naptFilterAndQos_add=rtk_rg_apollo_naptFilterAndQos_add,
	.rtk_rg_naptFilterAndQos_del=rtk_rg_apollo_naptFilterAndQos_del,
	.rtk_rg_naptFilterAndQos_find=rtk_rg_apollo_naptFilterAndQos_find,
//135
	.rtk_rg_pptpClientInfoBeforeDial_set=rtk_rg_apollo_pptpClientInfoBeforeDial_set,
	.rtk_rg_pptpClientInfoAfterDial_set=rtk_rg_apollo_pptpClientInfoAfterDial_set,
	.rtk_rg_l2tpClientInfoBeforeDial_set=rtk_rg_apollo_l2tpClientInfoBeforeDial_set,
	.rtk_rg_l2tpClientInfoAfterDial_set=rtk_rg_apollo_l2tpClientInfoAfterDial_set,
	.rtk_rg_stpBlockingPortmask_set=rtk_rg_apollo_stpBlockingPortmask_set,
//140
	.rtk_rg_stpBlockingPortmask_get=rtk_rg_apollo_stpBlockingPortmask_get,
	.rtk_rg_portIsolation_set=rtk_rg_apollo_portIsolation_set,
	.rtk_rg_portIsolation_get=rtk_rg_apollo_portIsolation_get,
	.rtk_rg_dsliteInfo_set=rtk_rg_apollo_dsliteInfo_set,
	.rtk_rg_pppoeDsliteInfoBeforeDial_set=rtk_rg_apollo_pppoeDsliteInfoBeforeDial_set,
//145
	.rtk_rg_pppoeDsliteInfoAfterDial_set=rtk_rg_apollo_pppoeDsliteInfoAfterDial_set,
	.rtk_rg_gponDsBcFilterAndRemarking_add=rtk_rg_apollo_gponDsBcFilterAndRemarking_add,
	.rtk_rg_gponDsBcFilterAndRemarking_del=rtk_rg_apollo_gponDsBcFilterAndRemarking_del,
	.rtk_rg_gponDsBcFilterAndRemarking_find=rtk_rg_apollo_gponDsBcFilterAndRemarking_find,
	.rtk_rg_gponDsBcFilterAndRemarking_del_all=rtk_rg_apollo_gponDsBcFilterAndRemarking_del_all,
//150
	.rtk_rg_gponDsBcFilterAndRemarking_Enable=rtk_rg_apollo_gponDsBcFilterAndRemarking_Enable,
	.rtk_rg_interfaceMibCounter_del=NULL,
	.rtk_rg_interfaceMibCounter_get=NULL,
	.rtk_rg_redirectHttpAll_set=rtk_rg_apollo_redirectHttpAll_set,
	.rtk_rg_redirectHttpAll_get=rtk_rg_apollo_redirectHttpAll_get,
//155
	.rtk_rg_redirectHttpURL_add=rtk_rg_apollo_redirectHttpURL_add,
	.rtk_rg_redirectHttpURL_del=rtk_rg_apollo_redirectHttpURL_del,
	.rtk_rg_redirectHttpWhiteList_add=rtk_rg_apollo_redirectHttpWhiteList_add,
	.rtk_rg_redirectHttpWhiteList_del=rtk_rg_apollo_redirectHttpWhiteList_del,
	.rtk_rg_redirectHttpRsp_set=rtk_rg_apollo_redirectHttpRsp_set,
//160
	.rtk_rg_redirectHttpRsp_get=rtk_rg_apollo_redirectHttpRsp_get,
	.rtk_rg_svlanTpid2_get= NULL,//supported by 9602c
	.rtk_rg_svlanTpid2_set= NULL,//supported by 9602c
	.rtk_rg_svlanTpid2_enable_get=NULL,//supported by 9602c
	.rtk_rg_svlanTpid2_enable_set=NULL,//supported by 9602c
//165
	.rtk_rg_hostPoliceControl_set=NULL,
	.rtk_rg_hostPoliceControl_get=NULL,
	.rtk_rg_hostPoliceLogging_get=NULL,
	.rtk_rg_hostPoliceLogging_del=NULL,
	.rtk_rg_redirectHttpCount_set=rtk_rg_apollo_redirectHttpCount_set,
//170
	.rtk_rg_redirectHttpCount_get=rtk_rg_apollo_redirectHttpCount_get,
	.rtk_rg_staticRoute_add=rtk_rg_apollo_staticRoute_add,
	.rtk_rg_staticRoute_del=rtk_rg_apollo_staticRoute_del,
	.rtk_rg_staticRoute_find=rtk_rg_apollo_staticRoute_find,
	.rtk_rg_aclLogCounterControl_get=rtk_rg_apollo_aclLogCounterControl_get,
//175
	.rtk_rg_aclLogCounterControl_set=rtk_rg_apollo_aclLogCounterControl_set,
	.rtk_rg_aclLogCounter_get=rtk_rg_apollo_aclLogCounter_get,
	.rtk_rg_aclLogCounter_reset=rtk_rg_apollo_aclLogCounter_reset,
	.rtk_rg_groupMacLimit_get=rtk_rg_apollo_groupMacLimit_get,
	.rtk_rg_groupMacLimit_set=rtk_rg_apollo_groupMacLimit_set,
//180
	.rtk_rg_igmpMldSnoopingControl_set=rtk_rg_apollo_igmpMldSnoopingControl_set,
	.rtk_rg_igmpMldSnoopingControl_get=rtk_rg_apollo_igmpMldSnoopingControl_get,
	.rtk_rg_flowMibCounter_get=NULL,
	.rtk_rg_flowMibCounter_reset=NULL,
	.rtk_rg_softwareIdleTime_set=rtk_rg_apollo_softwareIdleTime_set,
//185
	.rtk_rg_softwareIdleTime_get=rtk_rg_apollo_softwareIdleTime_get,
	.rtk_rg_funcbasedMeter_set=NULL,
	.rtk_rg_funcbasedMeter_get=NULL,
	.rtk_rg_flowHiPriEntry_add=NULL,
	.rtk_rg_flowHiPriEntry_del=NULL,
//190
	.rtk_rg_igmpMldSnoopingPortControl_add=rtk_rg_apollo_igmpMldSnoopingPortControl_add,
	.rtk_rg_igmpMldSnoopingPortControl_del=rtk_rg_apollo_igmpMldSnoopingPortControl_del,
	.rtk_rg_igmpMldSnoopingPortControl_find=rtk_rg_apollo_igmpMldSnoopingPortControl_find,
	.rtk_rg_callback_function_ptr_get=rtk_rg_apollo_callback_function_ptr_get,
	.rtk_rg_vlanGroupMacLimit_add=rtk_rg_apollo_vlanGroupMacLimit_add,
//195
	.rtk_rg_vlanGroupMacLimit_set=rtk_rg_apollo_vlanGroupMacLimit_set,
	.rtk_rg_vlanGroupMacLimit_del=rtk_rg_apollo_vlanGroupMacLimit_del,
	.rtk_rg_vlanGroupMacLimit_get=rtk_rg_apollo_vlanGroupMacLimit_get,
	.rtk_rg_vlanGroupMacLimit_find=rtk_rg_apollo_vlanGroupMacLimit_find,
	.rtk_rg_dosFloodThresholdUnit_set=rtk_rg_apollo_dosFloodThresholdUnit_set,
//200
	.rtk_rg_dosFloodThresholdUnit_get=rtk_rg_apollo_dosFloodThresholdUnit_get,
	.rtk_rg_accessDot1xControl_set=rtk_rg_apollo_accessDot1xControl_set,
	.rtk_rg_accessDot1xFilter_set=rtk_rg_apollo_accessDot1xFilter_set,
	.rtk_rg_urlflowPri_add=NULL,
	.rtk_rg_urlflowPri_del=NULL,		
//205
	.rtk_rg_portTrigger_add=rtk_rg_apollo_portTrigger_add,
	.rtk_rg_portTrigger_del=rtk_rg_apollo_portTrigger_del,
	.rtk_rg_vxlanClientInfo_set=rtk_rg_apollo_vxlanClientInfo_set,
	.rtk_rg_ipset_add=rtk_rg_apollo_ipset_add,
	.rtk_rg_ipset_del=rtk_rg_apollo_ipset_del,
//210
	.rtk_rg_ipsets_group_set=rtk_rg_apollo_ipsets_group_set,
	.rtk_rg_ipsets_set_add=rtk_rg_apollo_ipsets_set_add,
	.rtk_rg_ipsets_set_del=rtk_rg_apollo_ipsets_set_del,
	.rtk_rg_ipsets_rule_add=rtk_rg_apollo_ipsets_rule_add,
	.rtk_rg_ipsets_rule_del=rtk_rg_apollo_ipsets_rule_del,
//215
};
#endif

#ifdef __KERNEL__
#if defined(CONFIG_RG_G3_SERIES)
int _rtk_rg_g3_generic_intf_index_get(uint8 isLanIntf, uint32 lanWan_groupIdx_for_genericIntf, rtk_rg_mac_port_idx_t macPort, rtk_rg_mbssidDev_t wlanDevIdx)
{
	int gen_intfIdx = FAIL;

	if(isLanIntf)	// lan
	{
		if(lanWan_groupIdx_for_genericIntf >= MAX_LAN_INTERFACE_SIZE)
		{
			WARNING("Lan index(%d) >= MAX_LAN_INTERFACE_SIZE(%d)", lanWan_groupIdx_for_genericIntf, MAX_LAN_INTERFACE_SIZE);
			return FAIL;
		}
		// port 0~3			-> 	generic intf 0~3
		// PON port			-> 	generic intf 4
		// wlan0 root			->	generic intf 5
		// wlan0 vap0~3		->	generic intf 6~9
		// wlan0 vap4~6		->	generic intf 10
		// wlan0 wds0~7, vxd	->	generic intf 10
		// wlan1 root			->	generic intf 10
		// wlan1 vap0~3		->	generic intf 10
		// wlan1 wds0~7, vxd	->	generic intf 10
		if(wlanDevIdx>=0)	// wlan
		{
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
			//swap
			if(wlanDevIdx>=RG_RET_MBSSID_SLAVE_ROOT_INTF)
				wlanDevIdx -= RG_RET_MBSSID_SLAVE_ROOT_INTF;
			else
				wlanDevIdx += RG_RET_MBSSID_SLAVE_ROOT_INTF;

			TRACE("Change wlanDevIdx to %d to get generic interface index", wlanDevIdx);
#endif
			switch(wlanDevIdx)
			{
				case RG_RET_MBSSID_MASTER_ROOT_INTF:
				case RG_RET_MBSSID_MASTER_VAP0_INTF:
				case RG_RET_MBSSID_MASTER_VAP1_INTF:
				case RG_RET_MBSSID_MASTER_VAP2_INTF:
				case RG_RET_MBSSID_MASTER_VAP3_INTF:
					gen_intfIdx = (lanWan_groupIdx_for_genericIntf * MAX_GENERIC_INTERFACE_PER_LAN) + (GENERIC_INTERFACE_INDEX_OF_WLAN0_ROOT - NETIF_START_IDX) + (wlanDevIdx - RG_RET_MBSSID_MASTER_ROOT_INTF);
					break;
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
				case RG_RET_MBSSID_MASTER_VAP4_INTF:
				case RG_RET_MBSSID_MASTER_VAP5_INTF:
				case RG_RET_MBSSID_MASTER_VAP6_INTF:
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
				case RG_RET_MBSSID_MASTER_WDS0_INTF:
				case RG_RET_MBSSID_MASTER_WDS1_INTF:
				case RG_RET_MBSSID_MASTER_WDS2_INTF:
				case RG_RET_MBSSID_MASTER_WDS3_INTF:
				case RG_RET_MBSSID_MASTER_WDS4_INTF:
				case RG_RET_MBSSID_MASTER_WDS5_INTF:
				case RG_RET_MBSSID_MASTER_WDS6_INTF:
#ifdef CONFIG_RTL_MESH_SUPPORT
				case RG_RET_MBSSID_MASTER_MESH_INTF:
#else	// not CONFIG_RTL_MESH_SUPPORT
				case RG_RET_MBSSID_MASTER_WDS7_INTF:
#endif	// end CONFIG_RTL_MESH_SUPPORT
#else	// not CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_MESH_SUPPORT
				case RG_RET_MBSSID_MASTER_MESH_INTF:
#endif	// end CONFIG_RTL_MESH_SUPPORT
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
				case RG_RET_MBSSID_MASTER_CLIENT_INTF:
#endif
				case RG_RET_MBSSID_SLAVE_ROOT_INTF:
				case RG_RET_MBSSID_SLAVE_VAP0_INTF:
				case RG_RET_MBSSID_SLAVE_VAP1_INTF:
				case RG_RET_MBSSID_SLAVE_VAP2_INTF:
				case RG_RET_MBSSID_SLAVE_VAP3_INTF:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
				case RG_RET_MBSSID_SLAVE_VAP4_INTF:
				case RG_RET_MBSSID_SLAVE_VAP5_INTF:
				case RG_RET_MBSSID_SLAVE_VAP6_INTF:
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
				case RG_RET_MBSSID_SLAVE_WDS0_INTF:
				case RG_RET_MBSSID_SLAVE_WDS1_INTF:
				case RG_RET_MBSSID_SLAVE_WDS2_INTF:
				case RG_RET_MBSSID_SLAVE_WDS3_INTF:
				case RG_RET_MBSSID_SLAVE_WDS4_INTF:
				case RG_RET_MBSSID_SLAVE_WDS5_INTF:
				case RG_RET_MBSSID_SLAVE_WDS6_INTF:
				case RG_RET_MBSSID_SLAVE_WDS7_INTF:
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
				case RG_RET_MBSSID_SLAVE_CLIENT_INTF:
#endif
					gen_intfIdx = (lanWan_groupIdx_for_genericIntf * MAX_GENERIC_INTERFACE_PER_LAN) + (GENERIC_INTERFACE_INDEX_OF_WLAN1_WDS_VXD - NETIF_START_IDX);
					break;
				default:
					break;
			}
		}
		else
		{
			switch(macPort)
			{
				case RTK_RG_MAC_PORT0:
				case RTK_RG_MAC_PORT1:
				case RTK_RG_MAC_PORT2:
				case RTK_RG_MAC_PORT3:
					gen_intfIdx = (lanWan_groupIdx_for_genericIntf * MAX_GENERIC_INTERFACE_PER_LAN) + macPort;
					break;
				case RTK_RG_MAC_PORT_PON:
					gen_intfIdx = (lanWan_groupIdx_for_genericIntf * MAX_GENERIC_INTERFACE_PER_LAN) + 4;
					break;
				default:
					break;
			}
		}
	}
	else			//wan
	{
		gen_intfIdx = (MAX_LAN_INTERFACE_SIZE * MAX_GENERIC_INTERFACE_PER_LAN) + lanWan_groupIdx_for_genericIntf;
	}
	gen_intfIdx += NETIF_START_IDX;
	if(gen_intfIdx!=FAIL)
		TRACE("%s index[%d]'s generic intf index is %d (macPort=%d, wlanDevIdx=%d)", (isLanIntf)?"Lan":"Wan", lanWan_groupIdx_for_genericIntf, gen_intfIdx, macPort, wlanDevIdx);
	else
		WARNING("Fail to get %s index[%d]'s generic intf index (macPort=%d, wlanDevIdx=%d)", (isLanIntf)?"Lan":"Wan", lanWan_groupIdx_for_genericIntf, macPort, wlanDevIdx);

	return gen_intfIdx;
}

rtk_rg_err_code_t _rtk_rg_generic_intf_reserve_acl_delete(uint32 intfIdx, rtk_rg_mac_port_idx_t portIdx)
{
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].clsIdx_option_trap[portIdx]>0) {
		_rtk_rg_aclAndCfReservedRuleDelSpecial(RTK_CA_CLS_TYPE_IPV4_WITH_OPTION_TRAP, rg_db.systemGlobal.interfaceInfo[intfIdx].clsIdx_option_trap[portIdx], NULL);
		rg_db.systemGlobal.interfaceInfo[intfIdx].clsIdx_option_trap[portIdx] = 0;
	}

	return RT_ERR_RG_OK;
}

rtk_rg_err_code_t _rtk_rg_generic_intf_reserve_acl_add(uint32 intfIdx, rtk_rg_aclAndCf_reserved_ipv4_with_option_trap_t rsvedCLS)
{
	rtk_rg_mac_port_idx_t portIdx = rsvedCLS.src_port;

	// clear - if exist
	_rtk_rg_generic_intf_reserve_acl_delete(intfIdx, portIdx);

	// add
	if(_rtk_rg_aclAndCfReservedRuleAddSpecial(RTK_CA_CLS_TYPE_IPV4_WITH_OPTION_TRAP, &rsvedCLS) == RT_ERR_RG_OK){
		rg_db.systemGlobal.interfaceInfo[intfIdx].clsIdx_option_trap[portIdx] = rsvedCLS.cls_index;
	}else{
		rg_db.systemGlobal.interfaceInfo[intfIdx].clsIdx_option_trap[portIdx] = 0;
	}

	return RT_ERR_RG_OK;
}

rtk_rg_err_code_t _rtk_rg_generic_lan_intf_add(uint32 intfIdx)
{
	ca_status_t ca_ret;
	ca_gen_intf_attrib_t genIntf;
	int genIntf_idx;
	rtk_rg_mac_port_idx_t portIdx;

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	for(portIdx=0; portIdx<=RTK_RG_MAC_PORT_PON; portIdx++)
	{
		if(RG_INVALID_MAC_PORT(portIdx)) continue;

		if((rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.port_mask.portmask & (0x1<<portIdx))==0x0) continue;

		if((genIntf_idx = _rtk_rg_g3_generic_intf_index_get(TRUE, rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf, portIdx, FAIL))==FAIL) continue;

		memset(&genIntf, 0, sizeof(genIntf));
		// clear
		ca_generic_intf_del(G3_DEF_DEVID, genIntf_idx);
		// re-add
		genIntf.intf_id = genIntf_idx;
		genIntf.key_mask.orig_src_port= TRUE;
		genIntf.key_mask.src_port = TRUE;
		genIntf.key_mask.l2 = TRUE;
		genIntf.key_mask.ip = TRUE;
		genIntf.key.orig_src_port = portIdx;
		genIntf.key.src_port = CA_PORT_ID(CA_PORT_TYPE_L3,  portIdx);
		/*For multicast setting, the interface MAC should be set.*/
		memcpy(&genIntf.key.l2.mac_da, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.gmac.octet, ETHER_ADDR_LEN);
		if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.untag_mask.portmask & (0x1<<portIdx))
		{
			//for interface without vlan, the VID should be set as CA_UINT16_INVALID
			genIntf.key.l2.vlan_otag.vlan_min.vid = CA_UINT16_INVALID;
			genIntf.key.l2.vlan_otag.vlan_max = genIntf.key.l2.vlan_otag.vlan_min;
		}
		else
		{
			// TODO: support multiple vlan tag
			genIntf.key_mask.l2_mask.vlan_count = TRUE;
			genIntf.key_mask.l2_mask.vlan_otag_mask.vid = TRUE;
			genIntf.key.l2.vlan_count = 1;
			genIntf.key.l2.vlan_otag.vlan_min.vid = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.intf_vlan_id;
			genIntf.key.l2.vlan_otag.vlan_max = genIntf.key.l2.vlan_otag.vlan_min;
		}
		genIntf.key_pppoe_session_id = CA_UINT16_INVALID;
		genIntf.key_sw_id = CA_UINT32_INVALID;
		genIntf.action_mask.mtu = TRUE;
		genIntf.mtu = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.mtu;
		genIntf.nat_enable = TRUE;

		ca_ret = ca_generic_intf_add(G3_DEF_DEVID, &genIntf);
		if(ca_ret!=CA_E_OK)
		{
			WARNING("Fail to add generic intf[%d], ca_ret=0x%x", genIntf_idx, ca_ret);
			return RT_ERR_RG_FAILED;
		}
	}

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.port_mask.portmask & (0x1<<RTK_RG_PORT_WLAN_OF_MASTER_CPU))
	{
		for(genIntf_idx=GENERIC_INTERFACE_INDEX_OF_WLAN0_ROOT; genIntf_idx<(MAX_GENERIC_INTERFACE_PER_LAN + NETIF_START_IDX); genIntf_idx++)
		{
			memset(&genIntf, 0, sizeof(genIntf));
			switch(genIntf_idx)
			{
				case GENERIC_INTERFACE_INDEX_OF_WLAN0_ROOT:
					portIdx = RTK_RG_MAC_PORT_CPU_WLAN0_ROOT;
					break;
				case GENERIC_INTERFACE_INDEX_OF_WLAN0_VAP0:
					portIdx = RTK_RG_MAC_PORT_CPU_WLAN0_VAP0;
					break;
				case GENERIC_INTERFACE_INDEX_OF_WLAN0_VAP1:
					portIdx = RTK_RG_MAC_PORT_CPU_WLAN0_VAP1;
					break;
				case GENERIC_INTERFACE_INDEX_OF_WLAN0_VAP2:
					portIdx = RTK_RG_MAC_PORT_CPU_WLAN0_VAP2;
					break;
				case GENERIC_INTERFACE_INDEX_OF_WLAN0_VAP3:
					portIdx = RTK_RG_MAC_PORT_CPU_WLAN0_VAP3;
					break;
				default:
					portIdx = RTK_RG_MAC_PORT_CPU_WLAN1_AND_OTHERS;
					break;
			}
			genIntf_idx += (rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf * MAX_GENERIC_INTERFACE_PER_LAN);
			// clear
			ca_generic_intf_del(G3_DEF_DEVID, genIntf_idx);
			// re-add
			genIntf.intf_id = genIntf_idx;
			genIntf.key_mask.orig_src_port= TRUE;
			genIntf.key_mask.src_port = TRUE;
			genIntf.key_mask.l2 = TRUE;
			genIntf.key_mask.ip = TRUE;
			genIntf.key.orig_src_port = portIdx;
			genIntf.key.src_port = CA_PORT_ID(CA_PORT_TYPE_L3,  portIdx);
			/*For multicast setting, the interface MAC should be set.*/
			memcpy(&genIntf.key.l2.mac_da, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.gmac.octet, ETHER_ADDR_LEN);
			if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.untag_mask.portmask & (0x1<<RTK_RG_MAC_PORT_CPU))
			{
				//for interface without vlan, the VID should be set as CA_UINT16_INVALID
				genIntf.key.l2.vlan_otag.vlan_min.vid = CA_UINT16_INVALID;
				genIntf.key.l2.vlan_otag.vlan_max = genIntf.key.l2.vlan_otag.vlan_min;
			}
			else
			{
				// TODO: support multiple vlan tag
				genIntf.key_mask.l2_mask.vlan_count = TRUE;
				genIntf.key_mask.l2_mask.vlan_otag_mask.vid = TRUE;
				genIntf.key.l2.vlan_count = 1;
				genIntf.key.l2.vlan_otag.vlan_min.vid = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.intf_vlan_id;
				genIntf.key.l2.vlan_otag.vlan_max = genIntf.key.l2.vlan_otag.vlan_min;
			}
			genIntf.key_pppoe_session_id = CA_UINT16_INVALID;
			genIntf.key_sw_id = CA_UINT32_INVALID;
			genIntf.action_mask.mtu = TRUE;
			genIntf.mtu = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.mtu;
			genIntf.nat_enable = TRUE;

			ca_ret = ca_generic_intf_add(G3_DEF_DEVID, &genIntf);
			if(ca_ret!=CA_E_OK)
			{
				WARNING("Fail to add generic intf[%d], ca_ret=0x%x", genIntf_idx, ca_ret);
				return RT_ERR_RG_FAILED;
			}
		}
	}
	{	// reserved ACL - CA_L3_CLS_PROFILE_LAN
		rtk_rg_aclAndCf_reserved_ipv4_with_option_trap_t rsvedCLS;
		bzero(&rsvedCLS,sizeof(rsvedCLS));
		rsvedCLS.src_port = AAL_LPORT_ETH_NI0;
		memcpy(&rsvedCLS.dst_mac, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.gmac.octet, ETHER_ADDR_LEN);
		_rtk_rg_generic_intf_reserve_acl_add(intfIdx, rsvedCLS);
	}

	return RT_ERR_RG_OK;
}

rtk_rg_err_code_t _rtk_rg_generic_lan_intf_del(uint32 intfIdx)
{
	int genIntf_idx;
	rtk_rg_mac_port_idx_t portIdx;

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	for(portIdx=0; portIdx<=RTK_RG_MAC_PORT_PON; portIdx++)
	{
		if(RG_INVALID_MAC_PORT(portIdx)) continue;

		if((rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.port_mask.portmask & (0x1<<portIdx))==0x0) continue;

		if((genIntf_idx = _rtk_rg_g3_generic_intf_index_get(TRUE, rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf, portIdx, FAIL))==FAIL) continue;

		// clear
		ca_generic_intf_del(G3_DEF_DEVID, genIntf_idx);
	}
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.port_mask.portmask & (0x1<<RTK_RG_PORT_WLAN_OF_MASTER_CPU))
	{
		for(genIntf_idx=GENERIC_INTERFACE_INDEX_OF_WLAN0_ROOT; genIntf_idx<(MAX_GENERIC_INTERFACE_PER_LAN+ NETIF_START_IDX); genIntf_idx++)
		{
			genIntf_idx += (rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf * MAX_GENERIC_INTERFACE_PER_LAN);

			// clear
			ca_generic_intf_del(G3_DEF_DEVID, genIntf_idx);
		}
	}

	// reserved ACL - CA_L3_CLS_PROFILE_LAN
	_rtk_rg_generic_intf_reserve_acl_delete(intfIdx, AAL_LPORT_ETH_NI0);

	return RT_ERR_RG_OK;
}

rtk_rg_err_code_t _rtk_rg_generic_wan_intf_add(uint32 intfIdx)
{
	ca_status_t ca_ret;
	ca_gen_intf_attrib_t genIntf;
	int genIntf_idx;
	rtk_rg_mac_port_idx_t portIdx;

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan==0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	portIdx = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
	if((genIntf_idx = _rtk_rg_g3_generic_intf_index_get(FALSE, rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf, portIdx, FAIL))==FAIL)
		RETURN_ERR(RT_ERR_RG_FAILED);

	memset(&genIntf, 0, sizeof(genIntf));
	// clear
	ca_generic_intf_del(G3_DEF_DEVID, genIntf_idx);
	// re-add
	genIntf.intf_id = genIntf_idx;
	genIntf.key_mask.orig_src_port= TRUE;
	genIntf.key_mask.src_port = TRUE;
	genIntf.key_mask.l2 = TRUE;
	genIntf.key_mask.ip = TRUE;
	genIntf.key.orig_src_port = portIdx;
	genIntf.key.src_port = CA_PORT_ID(CA_PORT_TYPE_GPON,  portIdx);
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
	{
		// bridge wan interface
		/*For multicast setting, the interface MAC should be set.*/
		memcpy(&genIntf.key.l2.mac_da.mac_min, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet, ETHER_ADDR_LEN);
		memcpy(&genIntf.key.l2.mac_da.mac_max, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet, ETHER_ADDR_LEN);
	}
	else
	{
		// NAPT/Routing wan interface
		genIntf.key_mask.l2_mask.mac_da = TRUE;
		memcpy(&genIntf.key.l2.mac_da.mac_min, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet, ETHER_ADDR_LEN);
		memcpy(&genIntf.key.l2.mac_da.mac_max, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet, ETHER_ADDR_LEN);

		if(rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo->ip_version!=IPVER_V6ONLY
			&& rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo->napt_enable)
		{
			genIntf.key_mask.ip_mask.ip_da = TRUE;
			genIntf.key.ip.ip_da.ip_addr.ipv4_addr =  rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo->ip_addr;
		}

	}
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on==0)
	{
		//for interface without vlan, the VID should be set as CA_UINT16_INVALID
		genIntf.key.l2.vlan_otag.vlan_min.vid = CA_UINT16_INVALID;
		genIntf.key.l2.vlan_otag.vlan_max = genIntf.key.l2.vlan_otag.vlan_min;
	}
	else
	{
		// TODO: support multiple vlan tag
		genIntf.key_mask.l2_mask.vlan_count = TRUE;
		genIntf.key_mask.l2_mask.vlan_otag_mask.vid = TRUE;
		genIntf.key.l2.vlan_count = 1;
		genIntf.key.l2.vlan_otag.vlan_min.vid = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
		genIntf.key.l2.vlan_otag.vlan_max = genIntf.key.l2.vlan_otag.vlan_min;
	}
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)
	{
		genIntf.key_pppoe_session_id = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_info.after_dial.sessionId;
	}
	else if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
	{
		genIntf.key_pppoe_session_id = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.sessionId;
	}
	else
	{
		genIntf.key_pppoe_session_id = CA_UINT16_INVALID;
	}
	genIntf.key_sw_id = CA_UINT32_INVALID;
	genIntf.action_mask.mtu = TRUE;
	genIntf.mtu = rg_db.netif[intfIdx].rtk_netif.mtu;
	genIntf.nat_enable = TRUE;

	ca_ret = ca_generic_intf_add(G3_DEF_DEVID, &genIntf);
	if(ca_ret!=CA_E_OK)
	{
		WARNING("Fail to add generic intf[%d], ca_ret=0x%x", genIntf_idx, ca_ret);
		return RT_ERR_RG_FAILED;
	}
	{	// reserved ACL - CA_L3_CLS_PROFILE_WAN
		rtk_rg_aclAndCf_reserved_ipv4_with_option_trap_t rsvedCLS;
		bzero(&rsvedCLS,sizeof(rsvedCLS));
		rsvedCLS.src_port = AAL_LPORT_ETH_NI7;
		memcpy(&rsvedCLS.dst_mac, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet, ETHER_ADDR_LEN);
		_rtk_rg_generic_intf_reserve_acl_add(intfIdx, rsvedCLS);
	}

	return RT_ERR_RG_OK;
}

rtk_rg_err_code_t _rtk_rg_generic_wan_intf_del(uint32 intfIdx)
{
	int genIntf_idx;
	rtk_rg_mac_port_idx_t portIdx;

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan==0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	portIdx = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;

	if((genIntf_idx = _rtk_rg_g3_generic_intf_index_get(FALSE, rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf, portIdx, FAIL))==FAIL)
		RETURN_ERR(RT_ERR_RG_FAILED);

	// clear
	ca_generic_intf_del(G3_DEF_DEVID, genIntf_idx);

	// reserved ACL - CA_L3_CLS_PROFILE_WAN
	_rtk_rg_generic_intf_reserve_acl_delete(intfIdx, AAL_LPORT_ETH_NI7);

	return RT_ERR_RG_OK;
}

int re8670_rx_skb (struct re_private *cp, struct sk_buff *skb, struct rx_info *pRxInfo)
{
	WARNING("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;
}
void mips_perf_measure_entrance(int index)
{
	//FIXME("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return;
}
void mips_perf_measure_exit(int index)
{
	//FIXME("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return;
}
struct net_device* decideRxDevice(struct re_private *cp, struct rx_info *pRxInfo)
{
	WARNING("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return NULL;
}
int re8686_send_with_txInfo(struct sk_buff *skb, struct tx_info* ptxInfo, int ring_num)
{
	ca_ni_tx_config_t ca_tx_config;
	struct rtk_rg_txdesc_s *pTxDesc = (struct rtk_rg_txdesc_s *)ptxInfo;

	memset(&ca_tx_config,0,sizeof(ca_tx_config));
	ca_tx_config.core_config.bf.is_from_ca_tx = 1;
	ca_tx_config.core_config.bf.bypass_fwd_engine = 1;
	ca_tx_config.core_config.bf.txq_index = pTxDesc->tx_cputag_pri; //CA_NI_DMA_LSO_TXQ_IDX;
	if(pTxDesc->tx_l34_keep) // Direct Tx
	{
		ca_tx_config.core_config.bf.ldpid = __ffs(pTxDesc->tx_tx_portmask);
		ca_tx_config.core_config.bf.lspid = AAL_LPORT_CPU_0;

		if(pTxDesc->tx_ipcs)
		{
			if(pTxDesc->tx_isIpv6)
				ca_tx_config.lso_para0.bf.ipv6_en = 1;
			else
				ca_tx_config.lso_para0.bf.ipv4_en = 1;
		}
		if(pTxDesc->tx_l4cs)
		{
			if(pTxDesc->tx_isTcp)
				ca_tx_config.lso_para0.bf.tcp_en = 1;
			else
				ca_tx_config.lso_para0.bf.udp_en = 1;
		}
		if(skb->len < 60)
			ca_tx_config.lso_para0.bf.lenfix_en = 1;

		// lso_para0.bf.bypass_en should be always 0. that bit is for debug purpose.
		ca_tx_config.lso_para0.bf.bypass_en = 0;

		TRACE("G3 Direct TX: lspid=0x%x, ldpid=0x%x, ipv4_en=%d, ipv6_en=%d, tcp_en=%d, udp_en=%d, lenfix_en=%d",
				ca_tx_config.core_config.bf.lspid,
				ca_tx_config.core_config.bf.ldpid,
				ca_tx_config.lso_para0.bf.ipv4_en,
				ca_tx_config.lso_para0.bf.ipv6_en,
				ca_tx_config.lso_para0.bf.tcp_en,
				ca_tx_config.lso_para0.bf.udp_en,
				ca_tx_config.lso_para0.bf.lenfix_en);
	}
	else					// HWLOOKUP
	{
		ca_tx_config.core_config.bf.ldpid = AAL_LPORT_L3_LAN;
		ca_tx_config.core_config.bf.lspid = AAL_LPORT_CPU_0;

		if(pTxDesc->tx_extspa!=RTK_RG_MAC_EXT_CPU)
		{
			if(pTxDesc->tx_gmac_id==0 && pTxDesc->tx_extspa<=RTK_RG_MAC_EXT_PORT4)
				ca_tx_config.core_config.bf.lspid = RTK_RG_MAC_PORT_CPU_WLAN0_ROOT + (pTxDesc->tx_extspa-RTK_RG_MAC_EXT_BASED_PORT);	// master root + vaps
			else
			{
				ca_tx_config.core_config.bf.lspid = RTK_RG_MAC_PORT_CPU_WLAN1_AND_OTHERS;												// shared cpu port

				ca_tx_config.core_config.bf.flow_id_set = TRUE;
				if(pTxDesc->tx_gmac_id==0)
					ca_tx_config.flow_id = RTK_RG_WIFI_FLOWID_CPU_RSVD + (pTxDesc->tx_extspa-RTK_RG_MAC_EXT_PORT4);
				else
					ca_tx_config.flow_id = RTK_RG_WIFI1_FLOWID_ROOT + (pTxDesc->tx_extspa-RTK_RG_MAC_EXT_BASED_PORT);

				if(ca_tx_config.flow_id>=RTK_RG_WIFI1_FLOWID_OTHER)
					WARNING("ERROR: wlan[%d] extport[%d] hwlookup flow_id[%d]", pTxDesc->tx_gmac_id, pTxDesc->tx_extspa, ca_tx_config.flow_id);
			}
		}

		TRACE("G3 HWLOOKUP: lspid=0x%x, ldpid=0x%x, flow_id=%d",
				ca_tx_config.core_config.bf.lspid,
				ca_tx_config.core_config.bf.ldpid,
				ca_tx_config.flow_id);
	}
	ca_tx_config.cb_cookie = NULL;
	ca_tx_config.xmit_done_cb_fn = NULL;
	return nic_egress_start_xmit(skb, skb->dev, &ca_tx_config);
}
int re8670_start_xmit (struct sk_buff *skb, struct net_device *dev)
{
	ca_ni_tx_config_t tx_config;

	memset(&tx_config,0,sizeof(tx_config));
	tx_config.core_config.bf.is_from_ca_tx = 1;
	tx_config.core_config.bf.lspid = AAL_LPORT_CPU_0;
	tx_config.core_config.bf.ldpid = ((struct ca_eth_private*)netdev_priv(dev))->port_cfg.tx_ldpid;
	tx_config.core_config.bf.bypass_fwd_engine = 1;

	tx_config.cb_cookie = NULL;
	tx_config.xmit_done_cb_fn = NULL;
	//printk("%s skb = %p \n", __func__, skb);
	return nic_egress_start_xmit(skb, skb->dev, &tx_config);
}
int re8686_set_flow_control(unsigned int gmac, unsigned int ring, unsigned char enable)
{
	FIXME("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;
}

void _rtk_rg_reflash_lut_table(void)
{
	uint32 l2Idx, ret_l2Idx, vid, ori_doNotAddHwLut = rg_db.systemGlobal.doNotAddHwLut;
	rtk_rg_macEntry_t macEntry;

	if(rg_db.systemGlobal.auto_detect_hw_lut_mode==0)
	{
		rg_db.systemGlobal.doNotAddHwLut = 1;
	}
	else
	{
		rg_db.systemGlobal.doNotAddHwLut = 0;
		for(vid=0; vid<MAX_VLAN_SW_TABLE_SIZE; vid++)
		{
			if(rg_db.vlan[vid].valid==0)
				continue;
			if(rg_db.vlan[vid].fidMode==VLAN_FID_IVL)
			{
				rg_db.systemGlobal.doNotAddHwLut = 1;
				break;
			}
		}
		if(ori_doNotAddHwLut!=rg_db.systemGlobal.doNotAddHwLut)
		{
			if(rg_db.systemGlobal.doNotAddHwLut)	// SVL -> IVL
			{
				DEBUG("clear hw lut table");
				assert_ok(RTK_L2_ADDR_DELALL(1));
			}
			else									// IVL -> SVL
			{
				DEBUG("Sync sw lut table to hw");
				for(l2Idx=0; l2Idx<MAX_LUT_HW_TABLE_SIZE; l2Idx++)
				{
					if(rg_db.lut[l2Idx].valid && rg_db.lut[l2Idx].rtk_lut.entryType==RTK_LUT_L2UC)
					{
						_rtk_rg_lutToMacEntry_translator(rg_db.lut[l2Idx], &macEntry);
						assert_ok((pf.rtk_rg_macEntry_add)(&macEntry, &ret_l2Idx));
						if(l2Idx != ret_l2Idx) WARNING("Fail to sync sw lut[%d] to hw table, ret_l2Idx(hw)=%d", l2Idx, ret_l2Idx);
					}
				}
			}
		}
	}

	return;
}

void _rtk_rg_init_mainHash_swData_by_swFlowIdx(uint32 swFlowIdx)
{
	if(swFlowIdx>=MAX_FLOW_SW_TABLE_SIZE)
	{
		WARNING("swFlowIdx(%d) is out of range 0~%d", swFlowIdx, MAX_FLOW_SW_TABLE_SIZE-1);
		return;
	}
	if(0<=rg_db.flow[swFlowIdx].mainHash_hwFlowIdx && rg_db.flow[swFlowIdx].mainHash_hwFlowIdx<MAX_FLOW_HW_MAIN_HASH_SIZE)
	{
		rg_db.mainHashValidSet[rg_db.flow[swFlowIdx].mainHash_hwFlowIdx>>5] &= ~(0x1<<(rg_db.flow[swFlowIdx].mainHash_hwFlowIdx&0x1f));
		rg_db.swFlowIdx_mainHashMapping[rg_db.flow[swFlowIdx].mainHash_hwFlowIdx].swFlowIdx = 0;
		rg_db.flow[swFlowIdx].mainHash_hwFlowIdx = FAIL;
	}

	return;
}
#endif	// end CONFIG_RG_G3_SERIES

#else //1 for Model code
#define GFP_ATOMIC 0
struct sk_buff *skb_clone(struct sk_buff *skb,int gfp_type)
{
	struct sk_buff *new_skb;

	new_skb=(struct sk_buff *)(unsigned long)rtlglue_malloc(sizeof(struct sk_buff));
	if(new_skb==NULL) return NULL;

	new_skb->len = skb->len;
	new_skb->data = skb->data;

	return new_skb;
}

void dev_kfree_skb_any(struct sk_buff *skb)
{
	skb->data = NULL;
	rtlglue_free(skb);
}

int re8686_send_with_txInfo(struct sk_buff *skb, struct tx_info* ptxInfo, int ring_num)
{
#ifdef CONFIG_APOLLO_MODEL
		struct tx_info txInfo;
		int egressPort;
		memcpy(&txInfo,&rg_kernel.txDesc,sizeof(struct tx_info));
		dump_txInfo(txInfo);

		dump_packet(skb->data, skb->len+4, "\033[1;32mForwarding Engine Tx\033[m");

		if(txInfo.opts3.bit.tx_portmask!=0)
		{
			//Direct Tx
			DEBUG("\033[1;32mDirect Tx. @ %s %d\033[m\n",__FUNCTION__,__LINE__);
			model_fwdEngine_directTx(skb,txInfo);
			for(egressPort=0;egressPort<RTK_RG_PORT_MAX;egressPort++)
			{
				if(txInfo.opts3.bit.tx_portmask & (0x1<<egressPort))	//Direct Tx packet to NIC
					virtualGMACQueuePushPkt(egressPort,skb);
			}
		}
		else
		{
			//HW. lookup
			DEBUG("\033[1;32mH/W lookup. @ %s %d\033[m\n",__FUNCTION__,__LINE__);
			struct sk_buff egressPkt[RTK_RG_PORT_MAX];
			uint8 pkt[RTK_RG_PORT_MAX][2048]={0};
			for(egressPort=0;egressPort<RTK_RG_PORT_CPU;egressPort++)
			{
				//HW. lookup packet to NIC
				egressPkt[egressPort].data=pkt[egressPort];
				egressPkt[egressPort].len=0;
			}

			model_fwdEngine_hwLookup(skb,txInfo,egressPkt);

			for(egressPort=0;egressPort<RTK_RG_PORT_CPU;egressPort++)
			{
				if(egressPkt[egressPort].len)
					virtualGMACQueuePushPkt(egressPort,&egressPkt[egressPort]);
			}

		}

		dump_packet(skb->data, skb->len, "\033[1;32mGMAC Tx\033[m");
#endif
	return 0;
}

int re8670_rx_skb (struct re_private *cp, struct sk_buff *skb, struct rx_info *pRxInfo)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;
}

struct sk_buff *re8670_getAlloc(unsigned int size)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;
}

struct sk_buff *rtk_rg_skbCopyToPreAllocSkb(struct sk_buff *skb)
{
	struct sk_buff *new_skb;

	printf("FIXME %s %d (skb copy not ready!)\n",__FUNCTION__,__LINE__);

	//return new_skb;

	return 0;
}


struct sk_buff *_vlan_insert_tag(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb,u16 outter_tagif,u16 outter_protocal,u16 outter_content,u16 inner_tagif,u16 inner_protocal,u16 inner_content)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;

}

struct sk_buff *_vlan_remove_tag(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, u16 protocal)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;

}

struct sk_buff *_vlan_remove_doubleTag(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;

}

struct sk_buff *_vlan_modify_tag(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb, u16 ori_protocal,u16 mod_protocal,u16 mod_content)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;

}

struct sk_buff *_vlan_modify_doubleTag(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb, u16 mod_outter_protocal,u16 mod_outter_content,u16 mod_inner_protocal,u16 mod_inner_content)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;

}



#endif
//#include "types.h"

/* Module Name: System*/
//rtk_rg_intfInfo_t RG_GLB_INTF_INFO[8];		//store each interface information, LAN or WAN
//int volatile RG_GLB_ARP_REQUEST_FINISHED[MAX_NETIF_SW_TABLE_SIZE];	//used to indicate the ARP request return or not



/*the option for rtk_init setting by virtualmac or not: 0:normal, 1:virtualmac*/
int virtualmacEnable = DISABLE;


/* ALL global Variables & Tables */
__SRAM_FWDENG_PREDATA rtk_rg_globalDatabase_cache_t	rg_db_cache;
//__SRAM_FWDENG uint32 __rg_end_of_sram;

rtk_rg_dynamic_sram_data_t rg_db_dynamic_sram;
__SRAM_FWDENG_DATA rtk_rg_globalDatabase_t	rg_db;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_RG_FLOW_AUTO_AGEOUT)
uint32 notIdleSet[MAX_FLOW_TABLE_SIZE>>5];	// save in heap because 32K mode needs lots of memory
uint32 tmpFlowValidSet[MAX_FLOW_TABLE_SIZE>>5];
#endif

rtk_rg_globalKernel_t	rg_kernel;


char rg_mt_watch_tmp[512];
char StringErrName[64]={0};

int32 apollo_mac_init(void);

#include <rtk_rg_mappingAPI.h>

#ifdef CONFIG_APOLLOPRO_FPGA
extern int single_test(struct file *file, const char __user *buffer, unsigned long count, void *data);
#endif


#if defined(CONFIG_RG_RTL9600_SERIES)
/*Apollo ACL related patch used APIs */
extern int32 _rtk_rg_AclEgressPriorityPattern_Check(void);
extern int32 _rtk_rg_acl_reserved_stag_ingressCVidFromPVID(uint32 in_pvid, uint32 in_port);

#ifdef CONFIG_DUALBAND_CONCURRENT
extern int32 _rtk_rg_acl_reserved_wifi_internalVidPriTranslateForSlave(uint32 in_cvid, uint32 in_cpri, uint32 tran_cvid, uint32 tran_pri);
#endif
#ifdef RTK_RG_INGRESS_QOS_TEST_PATCH
extern int _rtk_rg_qos_acl_patch(rtk_rg_mac_port_idx_t port, uint32 rate);
extern int _rtk_rg_qos_acl_flush(void);
#endif

#ifdef __KERNEL__ //model code skips HW patch
extern int _rtk_rg_acl_reserved_pppoeCvidIssue_svid2IngressCvid(int wan_port);
#endif
extern int _rtk_rg_acl_reserved_pppoeCvidIssue_spriRemap2InternalPri(int wan_port, int spri, int intpri);
#endif




int32 _rtk_rg_switch_version_get(uint32 * pChipId, uint32 * pRev, uint32 * pSubtype)
{
	int ret;
	uint32 ChipId, Rev, Subtype;
	ret=rtk_switch_version_get(&ChipId, &Rev, &Subtype);
	*pChipId=ChipId;
	//20141119LUKE: fix hw version shift than sw definitions in apollomp
	if(ChipId==APOLLOMP_CHIP_ID && Rev>CHIP_REV_ID_0)*pRev=Rev-1;
	else *pRev=Rev;
	*pSubtype=Subtype;
	return ret;
}

rtk_rg_err_code_t rtk_rg_apollo_driverVersion_get(rtk_rg_VersionString_t *version_string)
{
    //Check the parameter
    if(version_string == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);

    //Clear and initialization
    memset(version_string->version_string, 0, sizeof(rtk_rg_VersionString_t));

	//Check switch chip revision
	ASSERT_EQ(_rtk_rg_switch_version_get(&rg_kernel.apolloChipId,&rg_kernel.apolloRev,&rg_kernel.apolloSubtype),RT_ERR_OK);

    //Return the version code
	snprintf(version_string->version_string,127,"Lunar:%s Switch:%s Diag:%s RG:%s User:%s (0x%x 0x%x 0x%x)",
	LUNAR_SVN_VERSION,SWITCH_SVN_VERSION,DIAG_SVN_VERSION,ROMEDRIVER_SVN_VERSION,USER_SVN_VERSION,
	rg_kernel.apolloChipId,rg_kernel.apolloRev,rg_kernel.apolloSubtype);

    //sprintf(version_string->version_string,"%s",ROMEDRIVER_VERSION);


    return (RT_ERR_RG_OK);
}

rtk_rg_successFailReturn_t _rtk_rg_internal_support_check(void)
{
#if defined(CONFIG_RG_G3_SERIES)
	//G3 foece as 9607C newsest chip version behavior
	rg_db.systemGlobal.internalSupportMask = RTK_RG_INTERNAL_SUPPORT_BIT0;
#else

	//=============== Module support check =========================
 	uint32 off_1=0;
	uint32 off_2=0;

	MEM32_WRITE(0xbb010004,0xa0000000);
	off_1 = REG32(0xbb010004);
	MEM32_WRITE(0xbb010004,0x00000000);

	MEM32_WRITE(0xbb010008,0xb0000000);
	off_2 = REG32(0xbb010008);
	MEM32_WRITE(0xbb010008,0x00000000);
	off_2 &= 0x00007000;

#if defined(CONFIG_RG_RTL9600_SERIES)
	switch(off_1)
	{
		case REG_SHIFT_BASE_1:
			switch(off_2)
			{
				case REG_SHIFT_3_0:
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT1;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT2;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT3;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT4;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT5;
					break;
				case REG_SHIFT_3_1:
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT1;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT2;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT3;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT4;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT5;
					break;

				case REG_SHIFT_3_2:
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT1;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT2;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT3;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT4;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT5;
					break;

				case REG_SHIFT_3_3:
				default:
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT1;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT2;
					rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT4;
					break;
			}
			break;
		case REG_SHIFT_1:
			rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT0;
			rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT3;
			rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT4;
			break;
		case REG_SHIFT_2:
			rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT0;
			rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT3;
			rg_db.systemGlobal.internalSupportMask |= RTK_RG_INTERNAL_SUPPORT_BIT4;
			break;
		default:
			break;

	}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
	switch(off_1)
	{
		case REG_SHIFT_BASE_2:
			rg_db.systemGlobal.internalSupportMask = RTK_RG_INTERNAL_SUPPORT_BIT0;
			break;
		case REG_SHIFT_BASE_3:
		default:
			rg_db.systemGlobal.internalSupportMask = RTK_RG_INTERNAL_SUPPORT_BIT1;
			break;
	}
#elif defined(CONFIG_RG_RTL9607C_SERIES)
	off_1 = rg_kernel.apolloRev;
	switch(off_1)
	{
		case 0x1:
			rg_db.systemGlobal.internalSupportMask = RTK_RG_INTERNAL_SUPPORT_BIT0;
			break;
		case 0x2:
		default:
			rg_db.systemGlobal.internalSupportMask = RTK_RG_INTERNAL_SUPPORT_BIT1;
			break;

	}
#endif

	DEBUG("internalSupportMask=0x%x", rg_db.systemGlobal.internalSupportMask);
#endif
	return RT_ERR_RG_OK;

}

void _rtk_rg_set_initState(rtk_rg_initState_t newState)
{
	rg_lock(&rg_kernel.initLock);
	//========================critical region start=========================
	rg_kernel.init_state=newState;
	//========================critical region end=========================
	rg_unlock(&rg_kernel.initLock);
}

__IRAM_FWDENG
rtk_rg_initState_t _rtk_rg_get_initState(void)
{
	rtk_rg_initState_t ret;
	rg_lock(&rg_kernel.initLock);
	//========================critical region start=========================
	ret=rg_kernel.init_state;
	//========================critical region end=========================
	rg_unlock(&rg_kernel.initLock);
	return ret;
}

rtk_rg_err_code_t rtk_rg_apollo_initParam_get(rtk_rg_initParams_t *init_param)
{
	//Check the parameter
	if(init_param == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);

	//Copy from rg_db
	memcpy(init_param, &rg_db.systemGlobal.initParam, sizeof(rtk_rg_initParams_t));
#if 0
	//Checking for parameters initialized
	if(rg_db.systemGlobal.initParam.arpAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.arpDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.macAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.macDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.naptAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.naptDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.routingAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.routingDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.bindingAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.bindingDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack == NULL &&
			rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack == NULL &&
			rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack == NULL &&
			rg_db.systemGlobal.initParam.interfaceAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.interfaceDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.neighborAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.neighborDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack == NULL &&
			rg_db.systemGlobal.initParam.pppoeBeforeDiagByHwCallBack == NULL)
		RETURN_ERR(RT_ERR_RG_INITPM_UNINIT);

	//Return each function pointer
	init_param->arpAddByHwCallBack = rg_db.systemGlobal.initParam.arpAddByHwCallBack;
	init_param->arpDelByHwCallBack = rg_db.systemGlobal.initParam.arpDelByHwCallBack;
	init_param->macAddByHwCallBack = rg_db.systemGlobal.initParam.macAddByHwCallBack;
	init_param->macDelByHwCallBack = rg_db.systemGlobal.initParam.macDelByHwCallBack;
	init_param->naptAddByHwCallBack = rg_db.systemGlobal.initParam.naptAddByHwCallBack;
	init_param->naptDelByHwCallBack = rg_db.systemGlobal.initParam.naptDelByHwCallBack;
	init_param->routingAddByHwCallBack = rg_db.systemGlobal.initParam.routingAddByHwCallBack;
	init_param->routingDelByHwCallBack = rg_db.systemGlobal.initParam.routingDelByHwCallBack;
	init_param->bindingAddByHwCallBack = rg_db.systemGlobal.initParam.bindingAddByHwCallBack;
	init_param->bindingDelByHwCallBack = rg_db.systemGlobal.initParam.bindingDelByHwCallBack;
	init_param->naptInboundConnLookupFirstCallBack = rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack;
	init_param->naptInboundConnLookupSecondCallBack = rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack;
	init_param->naptInboundConnLookupThirdCallBack = rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack;
	init_param->interfaceAddByHwCallBack = rg_db.systemGlobal.initParam.interfaceAddByHwCallBack;
	init_param->interfaceDelByHwCallBack = rg_db.systemGlobal.initParam.interfaceDelByHwCallBack;
	init_param->neighborAddByHwCallBack = rg_db.systemGlobal.initParam.neighborAddByHwCallBack;
	init_param->neighborDelByHwCallBack = rg_db.systemGlobal.initParam.neighborDelByHwCallBack;
	init_param->v6RoutingAddByHwCallBack = rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack;
	init_param->v6RoutingDelByHwCallBack = rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack;
	init_param->pppoeBeforeDiagByHwCallBack = rg_db.systemGlobal.initParam.pppoeBeforeDiagByHwCallBack;
#endif
	return (RT_ERR_RG_OK);
}

#if defined(CONFIG_SMP)
void rtk_rg_swRateLimitTimerFunc(unsigned long task_priv)
#else
//20181019LUKE: disable softirq and tasklet when execute timer function in uniprocessor.
void rtk_rg_swRateLimitTimerFunc_up(unsigned long task_priv);
void rtk_rg_swRateLimitTimerFunc(unsigned long task_priv)
{
	int smp_id=0;
	rg_inbound_queue_lock(smp_id,&rg_kernel.rg_inbound_queue_lock);
	rtk_rg_swRateLimitTimerFunc_up(task_priv);
	rg_inbound_queue_unlock(&rg_kernel.rg_inbound_queue_lock);
}
void rtk_rg_swRateLimitTimerFunc_up(unsigned long task_priv)
#endif
{
	//DEBUG("rtk_rg_BCMCRateLimitTimerFunc triggered, original BCByteCount=%d IPv6MCByteCount=%d",rg_db.systemGlobal.BCByteCount,rg_db.systemGlobal.IPv6MCByteCount);
	//clear the accumulate pkt counter
	//rg_db.systemGlobal.BCByteCount = 0;
	//rg_db.systemGlobal.IPv6MCByteCount = 0;
	//rg_db.systemGlobal.IPv4MCByteCount = 0;
	//rg_db.systemGlobal.unKnownDAByteCount = 0;
	//rg_db.systemGlobal.overMTUByteCount = 0;
	//rg_db.systemGlobal.ArpReqByteCount = 0;
	//rg_db.systemGlobal.dosRateLimit.byteCount = 0;
	//rg_db.systemGlobal.igmpByteCount = 0;
	//rg_db.systemGlobal.dhcpByteCount = 0;
	if(rg_db.systemGlobal.naptSwRateLimitTriggered) //clear if this functional is enabled to save time
		bzero(rg_db.systemGlobal.naptSwRateLimitByteCount,sizeof(uint32)*MAX_NAPT_FILER_SW_ENTRY_SIZE);
#if 0 //clear counter in _rtk_rg_dropBySwRateLimt_Check()
	memset(rg_db.systemGlobal.systemMeter.hwMeterCounterTable, 0, sizeof(rg_db.systemGlobal.systemMeter.hwMeterCounterTable));
	memset(rg_db.systemGlobal.systemMeter.swMeterCounterTable, 0, sizeof(rg_db.systemGlobal.systemMeter.swMeterCounterTable));
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	memset(rg_db.systemGlobal.systemMeter.flowMeterCounterTable, 0, sizeof(rg_db.systemGlobal.systemMeter.flowMeterCounterTable));
#endif
#endif


#ifdef CONFIG_MASTER_WLAN0_ENABLE
	rg_db.systemGlobal.wifiIngressRateLimitDevOverMask = 0;
	rg_db.systemGlobal.wifiEgressRateLimitDevOverMask = 0;
	memset(rg_db.systemGlobal.wifiIngressByteCount,0,sizeof(int)*MAX_WLAN_DEVICE_NUM);
	memset(rg_db.systemGlobal.wifiEgressByteCount,0,sizeof(int)*MAX_WLAN_DEVICE_NUM);
#endif
#ifdef __KERNEL__
	_rtk_rg_mod_timer(&rg_kernel.swRateLimitTimer, jiffies+TICKTIME_PERIOD/*unit:1sec*/);
#endif
}


int _rtk_rg_igmpSnoopingOnOff(int isOn, int onlyChangeTimer, int isIVL)
{
	int ret,i;


#ifdef __KERNEL__


#ifdef TIMER_AGG
	extern rtk_rg_timer_t igmpSysTimer;
	extern rtk_rg_timer_t mCastQuerytimer;
#else
	extern struct timer_list igmpSysTimer;
	extern struct timer_list mCastQuerytimer;
#endif
	void rtl_mCastQueryTimerExpired(unsigned long arg);
	void rtl_multicastSysTimerExpired(uint32 expireDada);

	_rtk_rg_del_timer(&mCastQuerytimer);
	_rtk_rg_del_timer(&igmpSysTimer);
#endif
	if(onlyChangeTimer) goto changeTimer;


	if(isOn)
	{
		DEBUG("IGMP Snooping enable...");

		/* ipv4/v6	dip/sip hash (include IPM routing) */
#if defined(CONFIG_RG_RTL9602C_SERIES)
		ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_DIP_AND_VID_FID),RT_ERR_RG_OK); //path3
		ASSERT_EQ(rtk_l2_ipv6mcMode_set(LOOKUP_ON_DIP),RT_ERR_RG_OK);			//path4
		//9602bvb don't have rtk_l2_ipmcGroupLookupMissHash_set
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_MAC_AND_VID_FID), SUCCESS);
		//ASSERT_EQ(rtk_l2_ipmcVlanMode_set(LOOKUP_VLAN_FORCE_NO_VLAN), SUCCESS);
		ASSERT_EQ(rtk_l2_ipmcVlanMode_set(LOOKUP_VLAN_BY_IVL_SVL), SUCCESS);
#elif defined(CONFIG_RG_G3_SERIES)
		//do nothing
#elif defined(CONFIG_RG_RTL9600_SERIES)
		ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_DIP_AND_SIP),RT_ERR_RG_OK);
		ASSERT_EQ(rtk_l2_ipmcGroupLookupMissHash_set(HASH_DIP_ONLY),RT_ERR_RG_OK);
#else
		"CONFIG ERROR"
#endif


		for(i=0;i<RTK_RG_PORT_LASTCPU;i++)
		{
			if(RG_INVALID_PORT(i)) continue;


#if defined(CONFIG_RG_G3_SERIES)
			//G3 set multicast mainHash default drop
			ASSERT_EQ(aal_default_action_set(G3_DEF_DEVID, RG_CA_FLOW_MC, FALSE),CA_E_OK);

			//G3 always forward unknow mulitcast to cpu (avoid drop by l2fe)
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IPMC,ACTION_FORWARD); //DLF_TYPE_IPMC && DLF_TYPE_IP6MC
			if(ret!=RT_ERR_RG_OK) return ret;
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_MCAST,ACTION_FORWARD);
			if(ret!=RT_ERR_RG_OK) return ret;

#else
			if(rg_db.systemGlobal.multicastProtocol!=RG_MC_MLD_ONLY)
				ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IPMC,ACTION_DROP);
			else
				ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IPMC,ACTION_TRAP2CPU);
			if(ret!=RT_ERR_RG_OK) return ret;

			//ret=rtk_l2_portLookupMissAction_set(i,DLF_TYPE_IP6MC,ACTION_TRAP2CPU); //to fix ICMPv6 can't to ping issue.(from LAN to Gateway)
			if(rg_db.systemGlobal.multicastProtocol!=RG_MC_IGMP_ONLY)
				ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IP6MC,ACTION_DROP);//to fix IPv6 Multicast flooding without join issue. ( ICMPv6 can't to ping issue will fixed(trap) by ACL)
			else
				ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IP6MC,ACTION_TRAP2CPU);
			if(ret!=RT_ERR_RG_OK) return ret;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_MCAST,ACTION_TRAP2CPU);
			if(ret!=RT_ERR_RG_OK) return ret;
#endif
#endif
		}


#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)

		assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP, NULL));
		if(rg_db.systemGlobal.multicastProtocol!=RG_MC_IGMP_ONLY)
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT, NULL));
		else
			assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT));

#if defined(CONFIG_RG_G3_SERIES)
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_PROTOCOL_TRAP));
		if(rg_db.systemGlobal.multicastProtocol!=RG_MC_BOTH_IGMP_MLD)
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_PROTOCOL_TRAP, NULL));
#endif	//CONFIG_RG_G3_SERIES
#else

		if(rg_db.systemGlobal.multicastProtocol!=RG_MC_MLD_ONLY)
		{
			if(isIVL) //IVL, trap SSDP by ACL because VLAN is hard to decide.
			{
				assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP, NULL));
			}
			else //SVL, saveing the ACL resource by LUT
			{
				if(rg_db.systemGlobal.ssdp_trap_lut_idx==-1)
				{
					//Create IPMC flow for SSDP 239.255.255.250 to trap from LAN port(because if igmpSnooping is on, the LAN port's IPMC will DROP)
					rtk_rg_multicastFlow_t mcFlow;
					memset(&mcFlow,0,sizeof(rtk_rg_multicastFlow_t));

					mcFlow.srcFilterMode=RTK_RG_IPV4MC_DONT_CARE_SRC;
					mcFlow.multicast_ipv4_addr = 0xeffffffa;	//239.255.255.250
					mcFlow.port_mask.portmask=0x1<<RTK_RG_PORT_MAINCPU;
#if defined(CONFIG_RG_RTL9600_SERIES)
					if(rg_db.systemGlobal.initParam.igmpSnoopingEnable==2)  //9600sersie lut path3 not support routing
						mcFlow.routingMode = RTK_RG_IPV4MC_DIS_ROUTING;
#endif
					ASSERT_EQ(rtk_rg_apollo_multicastFlow_add(&mcFlow, &rg_db.systemGlobal.ssdp_trap_lut_idx),RT_ERR_RG_OK);
				}
			}
			//224.0.0.0~224.0.0.255 trap
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_RMA_TRAP, NULL));
		}
		else
		{
			//make sure SSDP trap rule is deleted, no matter original is IVL by ACL or SVL by LUT.
			if(rg_db.systemGlobal.ssdp_trap_lut_idx!=-1)
			{
				ASSERT_EQ(rtk_rg_apollo_multicastFlow_del(rg_db.systemGlobal.ssdp_trap_lut_idx),RT_ERR_RG_OK);
				rg_db.systemGlobal.ssdp_trap_lut_idx=-1;
			}
			assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP));
		}

		if(rg_db.systemGlobal.multicastProtocol!=RG_MC_IGMP_ONLY)
		{
			//translate IP6MC VID to DEFAULT_CPU_VLAN for passthrought IPv6 Routing Wan (Egress VLAN Filter)
#if defined(CONFIG_RG_RTL9600_SERIES)
			rg_db.systemGlobal.ipv6MC_translate_ingressVID_enable=RTK_RG_ENABLED;
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6_PASSTHROUGHT, NULL));
#else
			rg_db.systemGlobal.ipv6MC_translate_ingressVID_enable=RTK_RG_DISABLED;
			assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6_PASSTHROUGHT));
#endif
			//[20140526]Permit UDP to avoid trap(avoid multicast data flooding, if multicastDA unknow will drop/trap by rtk_l2_portLookupMissAction_set),
			//but always trap else packet(such as RaDVD, ICMPv6 ...etc)
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT, NULL));
		}
		else
		{
			rg_db.systemGlobal.ipv6MC_translate_ingressVID_enable=RTK_RG_DISABLED;
			assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6_PASSTHROUGHT));
			assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT));
		}
#endif //end CONFIG_RG_FLOW_BASED_PLATFORM
	}
	else
	{
		DEBUG("IGMP Snooping disable...");
	#if defined(CONFIG_MASTER_WLAN0_ENABLE)
		//rg_db.systemGlobal.initParam.igmpWifiRefEnable=0;
		rg_db.systemGlobal.igmpWifiRefEnable=0;
	#endif

		for(i=0;i<RTK_RG_PORT_LASTCPU;i++)
		{
			if(RG_INVALID_PORT(i)) continue;

#if defined(CONFIG_RG_G3_SERIES)
			//G3 set multicast mainHash default Trap
			ASSERT_EQ(aal_default_action_set(G3_DEF_DEVID, RG_CA_FLOW_MC, TRUE),CA_E_OK);

			//G3 always forward unknow mulitcast to cpu (avoid drop by l2fe)
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IPMC,ACTION_FORWARD); //DLF_TYPE_IPMC && DLF_TYPE_IP6MC
			if(ret!=RT_ERR_RG_OK) return ret;
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_MCAST,ACTION_FORWARD);
			if(ret!=RT_ERR_RG_OK) return ret;
#else
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IPMC,ACTION_TRAP2CPU);
			if(ret!=RT_ERR_RG_OK) return ret;
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IP6MC,ACTION_TRAP2CPU);
			if(ret!=RT_ERR_RG_OK) return ret;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else
			ret=RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_MCAST,ACTION_TRAP2CPU);
			if(ret!=RT_ERR_RG_OK) return ret;
#endif
#endif
		}


#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT));
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP));
#if defined(CONFIG_RG_G3_SERIES)
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_PROTOCOL_TRAP));
#endif	//CONFIG_RG_G3_SERIES
#else
		//delete SSDP trap of SVL
		if(rg_db.systemGlobal.ssdp_trap_lut_idx!=-1)
		{
			ASSERT_EQ(rtk_rg_apollo_multicastFlow_del(rg_db.systemGlobal.ssdp_trap_lut_idx),RT_ERR_RG_OK);
			rg_db.systemGlobal.ssdp_trap_lut_idx=-1;
		}
		//delete SSDP trap
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_SSDP_TRAP));
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6_PASSTHROUGHT));
		assert_ok(_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_MULTICAST_TRAP_AND_GLOBAL_SCOPE_PERMIT));
		rg_db.systemGlobal.ipv6MC_translate_ingressVID_enable=RTK_RG_DISABLED;
#endif

	}


	//Flush IGMP or MLD entry based on igmpSnoopingEnable and multicastProtocol
	if(isOn==0)
		rtl_flushAllIgmpRecord(1);
	else
		rtl_flushAllIgmpRecord(0);



	//for Multicast PATH3 (LUT PATH3, CVID+GIP)
#if RTK_RG_MULTICAST_MODE_MACFID
		/* path 2*/
#if !defined(CONFIG_RG_G3_SERIES)
		ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_MAC_AND_VID_FID),RT_ERR_RG_OK);
#endif
	#if defined(CONFIG_RG_RTL9602C_SERIES)
		//ipv6 path2 hash by (mac,vid/fid)
		rtk_l2_ipv6mcMode_set(LOOKUP_ON_MAC_AND_VID_FID);
	#endif
#endif

#if !defined(CONFIG_RG_G3_SERIES)
	//20141215LUKE: enable IVL support
	if(isIVL)
	{
		/* path 2*/
		ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_MAC_AND_VID_FID),RT_ERR_RG_OK);
	}
#endif

	//sync the ivl/svl Multicast state to rg_db
	#if 0
	rg_db.systemGlobal.initParam.ivlMulticastSupport = isIVL;
	#else
	if (rg_db.systemGlobal.initParam.igmpSnoopingEnable==2 && rg_db.systemGlobal.initParam.ivlMulticastSupport!=0)
	{
		WARNING("rg init failed. if igmpSnoopingEnable(=2, care source mode), then ivlMulticastSupport force be 0\n");
		rg_db.systemGlobal.initParam.ivlMulticastSupport = 0;
	}
	else
	{
		rg_db.systemGlobal.initParam.ivlMulticastSupport = isIVL;
	}
	#endif


changeTimer:
#ifdef __KERNEL__

	if(isOn)
	{
		_rtk_rg_init_timer(&igmpSysTimer);
		igmpSysTimer.function = (void*)rtl_multicastSysTimerExpired;
		if(rg_db.systemGlobal.igmp_sys_timer_sec==0)
			rg_db.systemGlobal.igmp_sys_timer_sec=RTK_RG_DEFAULT_IGMP_SYS_TIMER_INTERVAL;
		_rtk_rg_mod_timer(&igmpSysTimer, jiffies+rg_db.systemGlobal.igmp_sys_timer_sec*CONFIG_HZ);
		if(rg_db.systemGlobal.mcast_query_sec!=0)
		{
			_rtk_rg_init_timer(&mCastQuerytimer);
			mCastQuerytimer.function = (void*)rtl_mCastQueryTimerExpired;
			//rg_db.systemGlobal.mcast_query_sec=RTK_RG_DEFAULT_MCAST_QUERY_INTERVAL;
			_rtk_rg_mod_timer(&mCastQuerytimer, jiffies+rg_db.systemGlobal.mcast_query_sec*CONFIG_HZ);
		}
	}

#endif


	return (RT_ERR_RG_OK);
}

void _rtk_rg_default_svlan_manipulate(void)
{
	int ret = RT_ERR_OK;
	rtk_portmask_t mbpmsk, utpmsk;
	//#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
	if (rg_kernel.stag_enable==RTK_RG_ENABLED) {
#if defined(CONFIG_RG_RTL9600_SERIES)
		if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT2))
#endif

		{
			//SVLAN initialization
			//Create SVID[1], member=all, untag=all
			//svlan set svlan-table svid fwdVLAN_CPU member all,6
			//svlan set svlan-table svid fwdVLAN_CPU untag-member all,6
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			ret=rtk_svlan_create(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN);
			if((ret!=RT_ERR_OK) &&
#if defined(CONFIG_RG_RTL9600_SERIES)
				(ret!=RT_ERR_SVLAN_EXIST)
#else
				(ret!=RT_ERR_VLAN_EXIST)
#endif
				)WARNING("SVLAN %d create failed: %x",rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN,ret);
#endif
			mbpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;
			utpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;
			assert_ok(RTK_SVLAN_MEMBERPORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN, &mbpmsk, &utpmsk));

#if defined(CONFIG_RG_RTL9600_SERIES)
			//Assign FID to WAN_FID
			assert_ok(rtk_svlan_fidEnable_set(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN,ENABLED));
			assert_ok(rtk_svlan_fid_set(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN,WAN_FID));

			//Set SVLAN untag action to assign SVLAN ID fwdVLAN_CPU
			assert_ok(RTK_SVLAN_UNTAGACTION_SET(SVLAN_ACTION_SVLAN, rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN));

			//Set SVLAN unmatch action to assign ingress SVLAN ID fwdVLAN_CPU, but keep original ingress SVID
			assert_ok(rtk_svlan_unmatchAction_set(SVLAN_ACTION_SVLAN, rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN));
#else
			//Set SVLAN untag action to assign SVLAN ID fwdVLAN_CPU
			assert_ok(RTK_SVLAN_UNTAGACTION_SET(SVLAN_ACTION_PSVID, rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN));

			for(ret=0;ret<RTK_RG_MAC_PORT_MAX;ret++)
			{
				if(RG_INVALID_MAC_PORT(ret)) continue;
				assert_ok(RTK_SVLAN_PORTSVID_SET(ret, rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN));
			}
#endif
		}
	}
	else	//destroy svlan default if no needed
#if defined(CONFIG_RG_RTL9600_SERIES)
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT2))
#endif
	{
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		ret=rtk_svlan_destroy(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN);
#endif
#if defined(CONFIG_RG_RTL9600_SERIES)
		if((ret!=RT_ERR_OK)&&(ret!=RT_ERR_SVLAN_NOT_EXIST))WARNING("SVLAN %d destroy failed: %x",rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN,ret);
#else
		if((ret!=RT_ERR_OK)&&(ret!=RT_ERR_VLAN_ENTRY_NOT_FOUND))WARNING("SVLAN %d destroy failed: %x",rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN,ret);
#endif
	}
}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
void _rtk_rg_check_wlan_device_exist_or_not(void)
{
	int i,ret;
	rtk_portmask_t mac_pmask, etp_pmask;

	//Check if WLAN0 device exist or not
	for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
	{
		ret=0;
		switch(i)
		{
			case RG_RET_MBSSID_MASTER_ROOT_INTF:
				if(wlan_root_netdev!=NULL)ret=1;
				break;
			case RG_RET_MBSSID_MASTER_VAP0_INTF:
			case RG_RET_MBSSID_MASTER_VAP1_INTF:
			case RG_RET_MBSSID_MASTER_VAP2_INTF:
			case RG_RET_MBSSID_MASTER_VAP3_INTF:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
			case RG_RET_MBSSID_MASTER_VAP4_INTF:
			case RG_RET_MBSSID_MASTER_VAP5_INTF:
			case RG_RET_MBSSID_MASTER_VAP6_INTF:
#endif
				if(wlan_vap_netdev[i-RG_RET_MBSSID_MASTER_VAP0_INTF]!=NULL)ret=1;
				break;
#if defined(CONFIG_RTL_WDS_SUPPORT)
			case RG_RET_MBSSID_MASTER_WDS0_INTF:
			case RG_RET_MBSSID_MASTER_WDS1_INTF:
			case RG_RET_MBSSID_MASTER_WDS2_INTF:
			case RG_RET_MBSSID_MASTER_WDS3_INTF:
			case RG_RET_MBSSID_MASTER_WDS4_INTF:
			case RG_RET_MBSSID_MASTER_WDS5_INTF:
			case RG_RET_MBSSID_MASTER_WDS6_INTF:
#ifdef CONFIG_RTL_MESH_SUPPORT
				if(wlan_wds_netdev[i-RG_RET_MBSSID_MASTER_WDS0_INTF]!=NULL)ret=1;
				break;
			case RG_RET_MBSSID_MASTER_MESH_INTF:
				if(wlan_mesh_netdev!=NULL)ret=1;
				break;
#else	// not CONFIG_RTL_MESH_SUPPORT
			case RG_RET_MBSSID_MASTER_WDS7_INTF:
				if(wlan_wds_netdev[i-RG_RET_MBSSID_MASTER_WDS0_INTF]!=NULL)ret=1;
				break;
#endif	// end CONFIG_RTL_MESH_SUPPORT
#else	// not CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_MESH_SUPPORT
			case RG_RET_MBSSID_MASTER_MESH_INTF:
				if(wlan_mesh_netdev!=NULL)ret=1;
				break;
#endif	// end CONFIG_RTL_MESH_SUPPORT
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
			case RG_RET_MBSSID_MASTER_CLIENT_INTF:
				if(wlan_vxd_netdev!=NULL)ret=1;
				break;
#endif
#if defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION)
			case RG_RET_MBSSID_SLAVE_ROOT_INTF:
				if(wlan1_root_netdev!=NULL)ret=1;
				break;
			case RG_RET_MBSSID_SLAVE_VAP0_INTF:
			case RG_RET_MBSSID_SLAVE_VAP1_INTF:
			case RG_RET_MBSSID_SLAVE_VAP2_INTF:
			case RG_RET_MBSSID_SLAVE_VAP3_INTF:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
			case RG_RET_MBSSID_SLAVE_VAP4_INTF:
			case RG_RET_MBSSID_SLAVE_VAP5_INTF:
			case RG_RET_MBSSID_SLAVE_VAP6_INTF:
#endif
				if(wlan1_vap_netdev[i-RG_RET_MBSSID_SLAVE_VAP0_INTF]!=NULL)ret=1;
				break;
#if defined(CONFIG_RTL_WDS_SUPPORT)
			case RG_RET_MBSSID_SLAVE_WDS0_INTF:
			case RG_RET_MBSSID_SLAVE_WDS1_INTF:
			case RG_RET_MBSSID_SLAVE_WDS2_INTF:
			case RG_RET_MBSSID_SLAVE_WDS3_INTF:
			case RG_RET_MBSSID_SLAVE_WDS4_INTF:
			case RG_RET_MBSSID_SLAVE_WDS5_INTF:
			case RG_RET_MBSSID_SLAVE_WDS6_INTF:
			case RG_RET_MBSSID_SLAVE_WDS7_INTF:
				if(wlan1_wds_netdev[i-RG_RET_MBSSID_SLAVE_WDS0_INTF]!=NULL)ret=1;
				break;
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
			case RG_RET_MBSSID_SLAVE_CLIENT_INTF:
				if(wlan1_vxd_netdev!=NULL)ret=1;
				break;
#endif
#endif
			default:
				break;
		}
		DEBUG("wlan device %d is %s", i, (ret==1)?"exist":"non-exist");
#ifdef CONFIG_DUALBAND_CONCURRENT
#if defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
		if((RG_RET_MBSSID_SLAVE_ROOT_INTF<=i && i<=RG_RET_MBSSID_SLAVE_VAP3_INTF)
			|| ((RG_RET_MBSSID_SLAVE_VAP3_INTF+1)<=i && i<=RG_RET_MBSSID_SLAVE_LAST_INTF && rg_db.systemGlobal.enableSlaveSSIDBind)) ret=1;
#else
		if(RG_RET_MBSSID_SLAVE_ROOT_INTF<=i && i<=RG_RET_MBSSID_SLAVE_LAST_INTF && rg_db.systemGlobal.enableSlaveSSIDBind) ret=1;
#endif
#endif
		//20161107LUKE: disable wifi device check by default.
		if(!rg_db.systemGlobal.checkWifiDev)ret=1;
		rg_db.systemGlobal.wlan0BindDecision[i].exist=ret;
	}

	//20160526LUKE: update dev-based VLAN of wifi devices
	mac_pmask.bits[0]=0x0;
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
	etp_pmask.bits[0]=RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK;	//ext 1=>master wifi

	_rtk_rg_updatePortBasedVIDByLanOrder(mac_pmask, etp_pmask);

	if(rg_db.systemGlobal.rgInit==1 && rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		//UpdateBindInternet
		_rtk_rg_updateBindWanIntf(NULL);
		//Update non-binding
		_rtk_rg_updateNoneBindingPortmask(rg_db.systemGlobal.wanPortMask.portmask);
		//Update PVID of OtherWan-binding port to vlan specific for the WAN
		_rtk_rg_updateBindOtherWanPortBasedVID(NULL);
	}
}

int rtk_rg_wifiDeviceEnumerate(struct file *file, const char *buff, unsigned long len, void *data)
{
	_rtk_rg_check_wlan_device_exist_or_not();
	return len;
}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
#else	//switch support pppoe tag offload
extern void gmac_padding_enable(unsigned int gmac, rtk_enable_t enable);
#endif

rtk_rg_err_code_t _rtk_rg_pon_rgmii_as_cf_port_check(void)
{
	int i;
	int keep_pon_as_cfport=0;
#if !defined(CONFIG_RG_RTL9602C_SERIES)	&& !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
	int keep_rgmii_as_cfport=0;
#endif

	if(rg_db.systemGlobal.initParam.hybridMode)
	{
		TRACE("cf port is controled by OMCI, so RG skip it.");
		return RT_ERR_RG_OK;
	}

	//check any port that need
	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
	{
		if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan &&
		 	rg_db.systemGlobal.interfaceInfo[i].valid &&
			rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_port_idx==RTK_RG_PORT_PON){
			keep_pon_as_cfport=1;
		}
#if !defined(CONFIG_RG_RTL9602C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
		if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan &&
		 	rg_db.systemGlobal.interfaceInfo[i].valid &&
			rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_port_idx==RTK_RG_PORT_RGMII){
			keep_pon_as_cfport=1;
		}
#endif
	}

	if(keep_pon_as_cfport==1){
		ASSERT_EQ(RTK_CLASSIFY_CFSEL_SET(RTK_RG_MAC_PORT_PON, CLASSIFY_CF_SEL_ENABLE),RT_ERR_OK);
	}else{
		ASSERT_EQ(RTK_CLASSIFY_CFSEL_SET(RTK_RG_MAC_PORT_PON, CLASSIFY_CF_SEL_DISABLE),RT_ERR_OK);
	}

#if !defined(CONFIG_RG_RTL9602C_SERIES)	&& !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)

#if defined(CONFIG_RG_RTL9600_SERIES)
	if(keep_rgmii_as_cfport==1 || rg_db.systemGlobal.pppoeGponSmallbandwithControl)
#else
	if(keep_rgmii_as_cfport==1)
#endif
	{
		ASSERT_EQ(RTK_CLASSIFY_CFSEL_SET(RTK_RG_MAC_PORT_RGMII, CLASSIFY_CF_SEL_ENABLE),RT_ERR_OK);
	}
	else
	{
		ASSERT_EQ(RTK_CLASSIFY_CFSEL_SET(RTK_RG_MAC_PORT_RGMII, CLASSIFY_CF_SEL_DISABLE),RT_ERR_OK);
	}
#endif

	return RT_ERR_RG_OK;
}

#if defined(CONFIG_RG_G3_SERIES)
rtk_rg_err_code_t _rtk_rg_g3_flow_key_mask_init(void)
{
	ca_status_t ca_ret;
	rtk_rg_flow_key_mask_t flowKeyMask;

	flowKeyMask.P12_spa = (rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA]==ENABLED) ? TRUE : FALSE;
	flowKeyMask.P12_vlanId = (rg_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CVID]==DISABLED) ? TRUE : FALSE;
	flowKeyMask.P12_vlanPri = (rg_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH12_SKIP_CPRI]==DISABLED) ? TRUE : FALSE;
	flowKeyMask.P345_vlanId = (rg_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CVID]==DISABLED) ? TRUE : FALSE;
	flowKeyMask.P345_vlanPri = (rg_db.systemGlobal.fbGlobalState[FB_GLOBAL_PATH5_SKIP_CPRI]==DISABLED) ? TRUE : FALSE;
	if(rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS]==ENABLED)
	{
		flowKeyMask.P345_dscp = TRUE;
		flowKeyMask.P345_ecn = (rg_db.systemGlobal.fbGlobalState[FB_GLOBAL_CMP_TOS]==ENABLED) ? TRUE : FALSE;
	}
	else
	{
		flowKeyMask.P345_dscp = FALSE;
		flowKeyMask.P345_ecn = FALSE;
	}
	ca_ret = rtk_rg_g3_flow_init(flowKeyMask);
	if(ca_ret!=CA_E_OK)
	{
		WARNING("Fail to initialize G3 flow, ca_ret=0x%x", ca_ret);
		return RT_ERR_RG_FAILED;
	}

	return RT_ERR_RG_OK;
}
#endif	// end CONFIG_RG_G3_SERIES

int32 _rtk_rg_initParam_set(rtk_rg_initParams_t *init_param)
{
    int ret,i;
    rtk_portmask_t mbpmsk, utpmsk, etpmsk;
	rtk_portmask_t srcExtPortFilterMmsk;
	rtk_rg_macEntry_t macEt;
	rtk_l34_routing_entry_t rtEntry;
	rtk_ipv6Routing_entry_t rtv6Entry;
	rtk_vlan_protoGroup_t protoGroupCfg;
	rtk_enable_t vlanFiltering;
#if !defined(CONFIG_RG_G3_SERIES)
	rtk_port_macAbility_t cpuAbility;
#endif
#if defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION)
#ifdef CONFIG_DUALBAND_CONCURRENT
	rtk_rg_cvlan_info_t vlanForSlaveWifi;
#endif
#endif
	rtk_rg_portmask_t allPortMask;

    //rtk_classify_cfg_t cfEntry;

    //Checking for input parameter - if here we pass NULL, means we just reset the Global variables
    //if(init_param == NULL)
    //RETURN_ERR(RT_ERR_RG_NULL_POINTER);





	//=============== Clear all rg_db variables =========================
	ASSERT_EQ(_rtk_rg_globalVariableReset(),RT_ERR_RG_OK);

	//=============== Global variables initilization =========================

	if(init_param != NULL)
	{
		memcpy(&rg_db.systemGlobal.initParam,init_param,sizeof(rtk_rg_initParams_t));

		if((POINTER_CAST)init_param->initByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.initByHwCallBack=_rtk_rg_initParameterSetByHwCallBack;
		if((POINTER_CAST)init_param->arpAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.arpAddByHwCallBack=_rtk_rg_arpAddByHwCallBack;
		if((POINTER_CAST)init_param->arpDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.arpDelByHwCallBack=_rtk_rg_arpDelByHwCallBack;
		if((POINTER_CAST)init_param->macAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.macAddByHwCallBack=_rtk_rg_macAddByHwCallBack;
		if((POINTER_CAST)init_param->macDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.macDelByHwCallBack=_rtk_rg_macDelByHwCallBack;
//5
		if((POINTER_CAST)init_param->routingAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.routingAddByHwCallBack=_rtk_rg_routingAddByHwCallBack;
		if((POINTER_CAST)init_param->routingDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.routingDelByHwCallBack=_rtk_rg_routingDelByHwCallBack;
		if((POINTER_CAST)init_param->naptAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.naptAddByHwCallBack=_rtk_rg_naptAddByHwCallBack;
		if((POINTER_CAST)init_param->naptDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.naptDelByHwCallBack=_rtk_rg_naptDelByHwCallBack;
		if((POINTER_CAST)init_param->bindingAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.bindingAddByHwCallBack=_rtk_rg_bindingAddByHwCallBack;
//10
		if((POINTER_CAST)init_param->bindingDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.bindingDelByHwCallBack=_rtk_rg_bindingDelByHwCallBack;
		if((POINTER_CAST)init_param->interfaceAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.interfaceAddByHwCallBack=_rtk_rg_interfaceAddByHwCallBack;
		if((POINTER_CAST)init_param->interfaceDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.interfaceDelByHwCallBack=_rtk_rg_interfaceDelByHwCallBack;
		if((POINTER_CAST)init_param->neighborAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.neighborAddByHwCallBack=_rtk_rg_neighborAddByHwCallBack;
		if((POINTER_CAST)init_param->neighborDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.neighborDelByHwCallBack=_rtk_rg_neighborDelByHwCallBack;
//15
		if((POINTER_CAST)init_param->v6RoutingAddByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack=_rtk_rg_v6RoutingAddByHwCallBack;
		if((POINTER_CAST)init_param->v6RoutingDelByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack=_rtk_rg_v6RoutingDelByHwCallBack;
		//init_param->naptInboundConnLookupFirstCallBack registered later if needed
		//init_param->naptInboundConnLookupSecondCallBack registered later if needed
		//init_param->naptInboundConnLookupThirdCallBack registered later if needed
//20
		if((POINTER_CAST)init_param->dhcpRequestByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.dhcpRequestByHwCallBack=_rtk_rg_dhcpRequestByHwCallBack;
		if((POINTER_CAST)init_param->pppoeBeforeDiagByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.pppoeBeforeDiagByHwCallBack=_rtk_rg_pppoeBeforeDialByHwCallBack;
		if((POINTER_CAST)init_param->pptpBeforeDialByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.pptpBeforeDialByHwCallBack=_rtk_rg_pptpBeforeDialByHwCallBack;
		if((POINTER_CAST)init_param->l2tpBeforeDialByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.l2tpBeforeDialByHwCallBack=_rtk_rg_l2tpBeforeDialByHwCallBack;
		if((POINTER_CAST)init_param->pppoeDsliteBeforeDialByHwCallBack==0xffffffff) rg_db.systemGlobal.initParam.pppoeDsliteBeforeDialByHwCallBack=_rtk_rg_pppoeDsliteBeforeDialByHwCallBack;
//25
		//rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupFirstCallBack register at init if needed
		//rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupSecondCallBack register at init if needed
		//rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupThirdCallBack register at init if needed
		if((POINTER_CAST)init_param->softwareNaptInfoAddCallBack==0xffffffff) rg_db.systemGlobal.initParam.softwareNaptInfoAddCallBack=_rtk_rg_softwareNaptInfoAddCallBack;
		if((POINTER_CAST)init_param->softwareNaptInfoDeleteCallBack==0xffffffff) rg_db.systemGlobal.initParam.softwareNaptInfoDeleteCallBack=_rtk_rg_softwareNaptInfoDeleteCallBack;
//30
		if((POINTER_CAST)init_param->naptPreRouteDPICallBack==0xffffffff) rg_db.systemGlobal.initParam.naptPreRouteDPICallBack=_rtk_rg_naptPreRouteDPICallBack;
		if((POINTER_CAST)init_param->naptForwardDPICallBack==0xffffffff) rg_db.systemGlobal.initParam.naptForwardDPICallBack=_rtk_rg_naptForwardDPICallBack;
		if((POINTER_CAST)init_param->pppoeLCPStateCallBack==0xffffffff) rg_db.systemGlobal.initParam.pppoeLCPStateCallBack=_rtk_rg_pppoeLCPStateCallBack;

	}
	else //default Init Value
	{
		rg_db.systemGlobal.initParam.igmpSnoopingEnable=1;
		rg_db.systemGlobal.initParam.macBasedTagDecision=0;
		rg_db.systemGlobal.initParam.wanPortGponMode=0; 	//default is non-GPON mode
		rg_db.systemGlobal.initParam.ivlMulticastSupport=0;
		rg_db.systemGlobal.initParam.hybridMode=0;
	}

	//Check and assign default VLAN value if not given by init_param
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU==0)
		rg_db.systemGlobal.initParam.fwdVLAN_CPU=DEFAULT_CPU_VLAN;

#if defined(CONFIG_RG_RTL9600_SERIES)
	rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN = rg_db.systemGlobal.initParam.fwdVLAN_CPU;
#else
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN==0)
		rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN=DEFAULT_CPU_SVLAN;
#endif

	if(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block==0)
		rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block=DEFAULT_PROTO_BLOCK_VLAN;
	if(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET==0)
		rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET=DEFAULT_BIND_INTERNET;
	if(rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER==0)
		rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER=DEFAULT_BIND_OTHER;


	if(rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET>=MAX_VLAN_SW_TABLE_SIZE-1)
		RETURN_ERR(RT_ERR_RG_VLAN_OVER_RANGE);

#if defined(CONFIG_RG_RTL9600_SERIES)
#else
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN==rg_db.systemGlobal.initParam.fwdVLAN_CPU)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN==rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN>=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN<=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
#endif
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU==rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_CPU>=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		rg_db.systemGlobal.initParam.fwdVLAN_CPU<=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block>=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block<=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET>=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET<=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);

	//sync port range used by ps
	_rtk_rg_syncPortRangeUsedByPSCallBack();

	//enable local in napt add to shortcut
	rg_db.systemGlobal.localInNaptAddToShortcut = RTK_RG_DEFAULT_LOCAL_IN_NAPT_ADD_TO_SHORTCUT;

	//init http default port
	rg_db.systemGlobal.httpMonitorPort = RTK_RG_DEFAULT_HTTP_MONITOR_PORT;
	//init http default port
	rg_db.systemGlobal.httpsMonitorPort = RTK_RG_DEFAULT_HTTPS_MONITOR_PORT;

	//disable white list
	rg_db.systemGlobal.whiteListState = RTK_RG_DEFAULT_WHITELIST_STATE;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// replace Hw flow with Sw flow when it is deleted.
	rg_db.systemGlobal.replaceHwFlow = RTK_RG_DEFAULT_REPLACE_HW_FLOW;
    // default enable L2/L3 stateful tracking
    rg_db.systemGlobal.L2TcpUdpStatefulTracking = RG_STATEFUL_TRACKING_ENABLE;
    rg_db.systemGlobal.L3TcpUdpStatefulTracking = RG_STATEFUL_TRACKING_ENABLE;
#endif
#if defined(CONFIG_RG_RTL9602C_SERIES)
	//can not enable this proc when macBasedTagDecision is disabled
	if(rg_db.systemGlobal.initParam.macBasedTagDecision==0)
		rg_kernel.block_communication_between_internet_and_other=0;
#endif

	//confirm all RG platform APIs are registered
	ASSERT_EQ(_rtk_rg_platform_function_register_check(&pf),RT_ERR_RG_OK);

	//get timeout value from default define
#if defined(CONFIG_ROME_NAPT_SHORTCUT)
	rg_db.systemGlobal.v4ShortCut_timeout=RTK_RG_DEFAULT_V4_SHORTCUT_TIMEOUT;
#endif
#if defined(CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT)
	rg_db.systemGlobal.v6ShortCut_timeout=RTK_RG_DEFAULT_V6_SHORTCUT_TIMEOUT;
#endif
#if defined(CONFIG_RG_FLOW_AUTO_AGEOUT)
	rg_db.systemGlobal.flow_timeout=RTK_RG_DEFAULT_FLOW_TIMEOUT;
#endif
	rg_db.systemGlobal.arp_timeout=RTK_RG_DEFAULT_ARP_TIMEOUT;
	rg_db.systemGlobal.neighbor_timeout=RTK_RG_DEFAULT_NEIGHBOR_TIMEOUT;
	rg_db.systemGlobal.tcp_long_timeout=RTK_RG_DEFAULT_TCP_LONG_TIMEOUT;
	rg_db.systemGlobal.tcp_short_timeout=RTK_RG_DEFAULT_TCP_SHORT_TIMEOUT;
	rg_db.systemGlobal.udp_long_timeout=RTK_RG_DEFAULT_UDP_LONG_TIMEOUT;
	rg_db.systemGlobal.udp_short_timeout=RTK_RG_DEFAULT_UDP_SHORT_TIMEOUT;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	rg_db.systemGlobal.l2_timeout=RTK_RG_DEFAULT_L2_TIMEOUT;
#endif
	rg_db.systemGlobal.fragment_timeout=RTK_RG_DEFAULT_FRAGMENT_LIST_TIMEOUT;

	rg_db.systemGlobal.wanAccessLimit_interval=CONFIG_RG_ACCESSWAN_TIMER_DELAY;

	rg_db.systemGlobal.house_keep_sec=RTK_RG_DEFAULT_HOUSE_KEEP_SECOND;
	rg_db.systemGlobal.mcast_query_sec=RTK_RG_DEFAULT_MCAST_QUERY_INTERVAL;
	rg_db.systemGlobal.arp_requset_interval_sec=RTK_RG_DEFAULT_ARP_REQUEST_INTERVAL_SECOND;
	rg_db.systemGlobal.auto_test_fail_arp_interval_sec=RTK_RG_DEFAULT_AUTO_TEST_FAIL_ARP_INTERVAL_SECOND;

	rg_db.systemGlobal.icmp_timeout=RTK_RG_DEFAULT_ICMP_TRACKING_TIMEOUT_INTERVAL_SECOND;

	rg_db.systemGlobal.dpi_accelerate_enable=RTK_RG_DEFAULT_DPI_ACCELERATE_SECONDS;
	rg_db.systemGlobal.dpi_accelerate_jiffies=jiffies;

#ifdef CONFIG_SMP
	rg_db.systemGlobal.criticalPacketBypassRxQueue=GMAC_PRIORITY_CRITICAL;
#if CONFIG_NR_CPUS == 4
	rg_db.systemGlobal.gmac9_affinity_cpumask = 0x2;  //CPU 1
	rg_db.systemGlobal.gmac10_affinity_cpumask = 0x2;  //CPU 1
	rg_db.systemGlobal.gmac7_affinity_cpumask = 0xf;  //CPU all
#ifdef CONFIG_RG_RTL9607C_SERIES
	{
		cpumask_t cpumask;
		cpumask.bits[0]=rg_db.systemGlobal.gmac9_affinity_cpumask;  //CPU 1
		irq_set_affinity(BSP_INT0_GMAC0_IRQ, &cpumask); //GMAC9

		cpumask.bits[0]=rg_db.systemGlobal.gmac10_affinity_cpumask;  //CPU 1
		irq_set_affinity(BSP_INT0_GMAC1_IRQ, &cpumask); //GMAC10

		cpumask.bits[0]=0x4;  //CPU 2
		irq_set_affinity(BSP_PCIE_11AC_IRQ, &cpumask); //PCIE 0

		cpumask.bits[0]=0x8;  //CPU 3
		irq_set_affinity(BSP_PCIE_11N_IRQ, &cpumask); //PCIE 1
	}
#endif


	rg_db.systemGlobal.smpRgCpuFromCpu[0]=2;
	rg_db.systemGlobal.smpRgCpuFromCpu[1]=2;
	rg_db.systemGlobal.smpRgCpuFromCpu[2]=2;
	rg_db.systemGlobal.smpRgCpuFromCpu[3]=2;

	rg_db.systemGlobal.smpNicTxCpuFromCpu[0]=0;
	rg_db.systemGlobal.smpNicTxCpuFromCpu[1]=0;
	rg_db.systemGlobal.smpNicTxCpuFromCpu[2]=0;
	rg_db.systemGlobal.smpNicTxCpuFromCpu[3]=0;
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
	rg_db.systemGlobal.smpNicTxCpuFromGMAC0[0]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC0[1]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC0[2]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC0[3]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC1[0]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC1[1]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC1[2]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC1[3]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC2[0]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC2[1]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC2[2]=0;
	rg_db.systemGlobal.smpNicTxCpuFromGMAC2[3]=0;
#endif
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[0]=3;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[1]=3;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[2]=3;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[3]=3;

	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[0]=0;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[1]=0;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[2]=0;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[3]=0;
#else
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[0]=0;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[1]=0;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[2]=0;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[3]=0;

	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[0]=3;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[1]=3;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[2]=3;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[3]=3;
#endif
#elif CONFIG_NR_CPUS == 2
rg_db.systemGlobal.gmac9_affinity_cpumask = 0x1;  //CPU 0
rg_db.systemGlobal.gmac10_affinity_cpumask = 0x2;  //CPU 1
rg_db.systemGlobal.gmac7_affinity_cpumask = 0x3;  //CPU all
#ifdef CONFIG_RG_RTL9607C_SERIES
	{
		cpumask_t cpumask;
		cpumask.bits[0]=rg_db.systemGlobal.gmac9_affinity_cpumask;  //CPU 0
		irq_set_affinity(BSP_INT0_GMAC0_IRQ, &cpumask); //GMAC9

		cpumask.bits[0]=rg_db.systemGlobal.gmac10_affinity_cpumask;  //CPU 1
		irq_set_affinity(BSP_INT0_GMAC1_IRQ, &cpumask); //GMAC10

		cpumask.bits[0]=0x1;  //CPU 0
		irq_set_affinity(BSP_PCIE_11AC_IRQ, &cpumask); //PCIE 0

		cpumask.bits[0]=0x1;  //CPU 0
		irq_set_affinity(BSP_PCIE_11N_IRQ, &cpumask); //PCIE 1
	}
#endif
	rg_db.systemGlobal.smpRgCpuFromCpu[0]=1;
	rg_db.systemGlobal.smpRgCpuFromCpu[1]=1;

	rg_db.systemGlobal.smpNicTxCpuFromCpu[0]=0;
	rg_db.systemGlobal.smpNicTxCpuFromCpu[1]=0;

	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[0]=0;
	rg_db.systemGlobal.smpWifi11acTxCpuFromCpu[1]=0;

	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[0]=0;
	rg_db.systemGlobal.smpWifi11nTxCpuFromCpu[1]=0;
#else
#error
#endif

#endif


	//check supported module
	ASSERT_EQ(_rtk_rg_internal_support_check(),RT_ERR_RG_OK);

	//get phyPort status and store in software
	for(i=RTK_PORT_UTP0;i<RTK_PORT_UTP11;i++)
	{
		if(rtk_switch_phyPortId_get(i, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	}
	if(rtk_switch_phyPortId_get(RTK_PORT_PON, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_FIBER, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_EXT0, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_EXT1, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_EXT2, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
#if defined(CONFIG_RG_RTL9607C_SERIES)
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU0, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU1, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU2, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
#else
	if(rtk_switch_phyPortId_get(RTK_PORT_CPU, &ret)==RT_ERR_OK)rg_db.systemGlobal.phyPortStatus|=0x1<<(RTK_RG_PORT0+ret);
#endif


	DEBUG("phyPortStatus = 0x%x",rg_db.systemGlobal.phyPortStatus);

#if defined(CONFIG_RG_G3_SERIES)
	rg_db.systemGlobal.rg_mirror_ingress_pkt_to_port = -1; //default no need to mirror
#endif



	//20170105: clear service port, user can call rtk_rg_apollo_svlanServicePort_set() to set service port after rg init.
	rg_db.systemGlobal.service_pmsk.portmask=0;
	for(i=0;i<=RTK_RG_MAC_PORT_LASTCPU;i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;
		assert_ok(RTK_SVLAN_SERVICEPORT_SET(i,DISABLED));
	}

#if !defined(CONFIG_RG_SUPPORT_JUMBO_FRAME) // not support Jumbo frame
	//Dropped jumbo frame to avoid software(NIC) buzy dropping.
	for(i=0;i<=RTK_RG_MAC_PORT_LASTCPU;i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;
		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i)) continue;
		//reference to NIC driver SKB_BUF_SIZE
		ASSERT_EQ(RTK_SWITCH_MAXPKTLENBYPORT_SET(i, SKB_BUF_SIZE),RT_ERR_OK);
	}
#endif

    /* Initialize SDK */
    //rtlglue_printf("RTK RG initialize.....%d\n",RG_GLB_VLAN_INIT);


#ifdef __KERNEL__
	ASSERT_EQ(RTK_INIT_WITHOUT_PON(),RT_ERR_OK);
#else
    ASSERT_EQ(rtk_init(),RT_ERR_OK);
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//fb init
//#if !defined(CONFIG_RG_G3_SERIES)
	ASSERT_EQ(_rtk_rg_fb_init(), RT_ERR_OK);
//#endif //!defined(CONFIG_RG_G3_SERIES)


#else // not CONFIG_RG_FLOW_BASED_PLATFORM
	ASSERT_EQ(rtk_l34_init(),RT_ERR_OK);
#endif
	ASSERT_EQ(RTK_L2_INIT(),RT_ERR_OK);

#if defined(CONFIG_RG_G3_SERIES)
	{
		ca_status_t ca_ret;
		ca_ret = rtk_rg_g3_init();
		if(ca_ret!=CA_E_OK)
		{
			WARNING("Fail to initialize G3, ca_ret=0x%x", ca_ret);
			return RT_ERR_RG_FAILED;
		}
	}
#endif

	//sync switch/FB meter status to SW *** note. for G3 this shoule be done after g3 init ***
	{
		uint32 rate;
		rtk_enable_t ifgInclude;
		rtk_rate_metet_mode_t meterMode;

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		//sync FB meter to switch meter value
		for(i=0;i<FLOWBASED_TABLESIZE_SHAREMTR;i++)
		{
			ret = rtk_rate_shareMeter_get(i, &rate , (void*)&ifgInclude);
			if(ret!=RT_ERR_OK){WARNING("Sync FB meter[%d] and Switch meter[%d] Fail!!!",i,i);}

			ret = rtk_rg_asic_shareMeter_set(i, rate, ifgInclude);
			if(ret!=RT_ERR_OK){WARNING("Sync FB meter[%d] and Switch meter[%d] Fail!!!",i,i);}

			rg_db.systemGlobal.systemMeter.flowMeter[i].rate = rate;
			rg_db.systemGlobal.systemMeter.flowMeter[i].ifgInclude = ifgInclude;
			rg_db.systemGlobal.systemMeter.flowMeter[i].meterCount = &rg_db.systemGlobal.systemMeter.flowMeterCounterTable[i];
			rg_db.systemGlobal.systemMeter.flowMeter[i].meterMode = METER_MODE_BIT_RATE; //flow-based meter only support bit rate mode
			rg_db.systemGlobal.systemMeter.flowMeter[i].lastJiffies = jiffies;
			rg_db.systemGlobal.systemMeter.flowMeter[i].lastJiffiesPersec = jiffies;
			memset(&rg_db.systemGlobal.systemMeter.flowMeter[i].meterCountPersec, 0, sizeof(rg_db.systemGlobal.systemMeter.flowMeter[i].meterCountPersec));
		}
#endif
		for(i=0;i<MAX_HW_SHAREMETER_TABLE_SIZE;i++)
		{
			ret = rtk_rate_shareMeter_get(i, &rate , (void*)&ifgInclude);
			if(ret!=RT_ERR_OK){WARNING("sync switch sharemeter[%d] rate/ifginclude to SW Fail!!!",i);}
			rg_db.systemGlobal.systemMeter.hwMeter[i].rate = rate;
			rg_db.systemGlobal.systemMeter.hwMeter[i].ifgInclude = ifgInclude;
			rg_db.systemGlobal.systemMeter.hwMeter[i].meterCount = &rg_db.systemGlobal.systemMeter.hwMeterCounterTable[i];

#if defined(CONFIG_RG_RTL9600_SERIES)
			meterMode = METER_MODE_BIT_RATE;//apollo: not support meter mode setting
#else
			ret = rtk_rate_shareMeterMode_get(i, &meterMode);
			if(ret!=RT_ERR_OK){WARNING("sync switch sharemeter[%d] mode to SW Fail!!!",i);}
#endif
			rg_db.systemGlobal.systemMeter.hwMeter[i].meterMode = meterMode;
			rg_db.systemGlobal.systemMeter.hwMeter[i].lastJiffies = jiffies;
			rg_db.systemGlobal.systemMeter.hwMeter[i].lastJiffiesPersec = jiffies;
			memset(&rg_db.systemGlobal.systemMeter.hwMeter[i].meterCountPersec, 0, sizeof(rg_db.systemGlobal.systemMeter.hwMeter[i].meterCountPersec));
		}

		//initial pure SW meter setting
		for(i = 0 ; i < PURE_SW_SHAREMETER_TABLE_SIZE ; i++)
		{
			rg_db.systemGlobal.systemMeter.swMeter[i].rate = MAX_SWITCH_METER_RATE;
			rg_db.systemGlobal.systemMeter.swMeter[i].ifgInclude = DISABLE;
			rg_db.systemGlobal.systemMeter.swMeter[i].meterCount = &rg_db.systemGlobal.systemMeter.swMeterCounterTable[i];
			rg_db.systemGlobal.systemMeter.swMeter[i].meterMode= METER_MODE_BIT_RATE;
			rg_db.systemGlobal.systemMeter.swMeter[i].lastJiffies = jiffies;
			rg_db.systemGlobal.systemMeter.swMeter[i].lastJiffiesPersec = jiffies;
			memset(&rg_db.systemGlobal.systemMeter.swMeter[i].meterCountPersec, 0, sizeof(rg_db.systemGlobal.systemMeter.swMeter[i].meterCountPersec));
		}

		// init sw shaping control
		for(i = 0; i< MAX_SW_SHAPER_TABLE_SIZE; i++)
		{
			_rtk_rg_del_timer(&rg_db.systemGlobal.systemMeter.shapingCtrl[i].kicktxtimer);
			_rtk_rg_init_timer(&rg_db.systemGlobal.systemMeter.shapingCtrl[i].kicktxtimer);
			rg_db.systemGlobal.systemMeter.shapingCtrl[i].kicktxtimer.function = rtk_rg_sw_shaper_kicktx_timerfunc;
			rg_db.systemGlobal.systemMeter.shapingCtrl[i].kicktxtimer.data = (unsigned long)i;
			atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[i].free_idx, 0);
			atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[i].sched_idx, 0);
			atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[i].congestion, 0);
			rg_db.systemGlobal.systemMeter.shapingCtrl[i].enququcnt = 0;
			rg_db.systemGlobal.systemMeter.shapingCtrl[i].pausetxcnt = 0;
			memset(rg_db.systemGlobal.systemMeter.shapingCtrl[i].queue, 0, sizeof(rtk_rg_shaping_bucket_t)*MAX_SW_SHAPER_QUEUE_SIZE);
			rg_db.systemGlobal.systemMeter.shapingCtrl[i].timerCnt = 0;
		}
	}

#if defined(CONFIG_RG_RTL9602C_SERIES)

#if 0
	{
		//default set each vlan be untag to avoid  service-port to serverive-port may content stag out because no stag unmatch action.
		rtk_portmask_t memberPortmask;
		rtk_portmask_t untagPortmask;
		int32 ret;
		for(i=0;i<MAX_VLAN_HW_TABLE_SIZE;i++)
		{
			//ASSERT_EQ(rtk_vlan_port_get(i,&memberPortmask,&untagPortmask),RT_ERR_OK);
			ret = rtk_vlan_port_get(i,&memberPortmask,&untagPortmask);
			if(ret!=RT_ERR_OK) WARNING("rtk_vlan_port_get(vid=%d) failed!!!",i);
			untagPortmask.bits[0]=RTK_RG_ALL_MAC_PORTMASK;
			//ASSERT_EQ(RTK_VLAN_PORT_SET(i,&memberPortmask,&untagPortmask),RT_ERR_OK);
			ret = RTK_VLAN_PORT_SET(i,&memberPortmask,&untagPortmask);
			if(ret!=RT_ERR_OK) WARNING("RTK_VLAN_PORT_SET(vid=%d) failed!!!",i);
		}
	}
#endif
#endif

	// get initilized port link status
	ASSERT_EQ(_rtk_rg_getPortLinkupStatus(), RT_ERR_OK);

#ifdef CONFIG_RG_LAYER2_SOFTWARE_LEARN
	//clear link-down indicator from the beginning
#if 0//def __KERNEL__
	ASSERT_EQ(rtk_intr_linkdownStatus_clear(),RT_ERR_OK);

	/*register link-change ISR bh handler*/
	ASSERT_EQ(rtk_irq_isr_register(INTR_TYPE_LINK_CHANGE,_rtk_rg_switchLinkChangeHandler),RT_ERR_OK);
	//turn on link-change ISR mask
	ASSERT_EQ(rtk_intr_imr_set(INTR_TYPE_LINK_CHANGE,ENABLED),RT_ERR_OK);
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	//Turn off Lut aging
	for(i=0;i<RTK_RG_MAC_PORT_MAX;i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;
		ASSERT_EQ(RTK_L2_PORTAGINGENABLE_SET(i, DISABLED),RT_ERR_OK);
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_APOLLO_FPGA_PHY_TEST)


#else	//switch support pppoe tag offload
	// 1. disable gmac padding
	for(i=0; i<MAX_GMAC_NUM; i++)
		gmac_padding_enable(i, DISABLED);
	// 2. enable switch padding
	// 3. allow switch's cpu port to receive packet which smaller than 64 bytes
	{
#if defined(CONFIG_RG_RTL9607C_SERIES)
		rtk_enable_t enable=ENABLED;
		rtk_rg_mac_port_idx_t port;

		for(port=0; port<RTK_RG_MAC_PORT_MAX; port++)
		{
			if((0x1<<port)&RTK_RG_ALL_MAC_CPU_PORTMASK)
			{
				//enable switch padding
				ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, port, REG_ARRAY_INDEX_NONE, RTL9607C_PADDING_ENf, &enable), RT_ERR_OK);
				//allow receiving packet which smaller than 64 bytes
				ASSERT_EQ(reg_array_field_write(RTL9607C_P_MISCr, port, REG_ARRAY_INDEX_NONE, RTL9607C_RX_SPCf, &enable), RT_ERR_OK);
			}
		}
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
		rtk_enable_t enable=ENABLED;

		//enable switch padding
		ASSERT_EQ(reg_array_field_write(RTL9603CVD_P_MISCr, RTK_RG_MAC_PORT_CPU, REG_ARRAY_INDEX_NONE, RTL9603CVD_PADDING_ENf, &enable), RT_ERR_OK);
		//allow receiving packet which smaller than 64 bytes
		ASSERT_EQ(reg_array_field_write(RTL9603CVD_P_MISCr, RTK_RG_MAC_PORT_CPU, REG_ARRAY_INDEX_NONE, RTL9603CVD_RX_SPCf, &enable), RT_ERR_OK);

#else
#error
#endif
	}
#endif

	//20170104LUKE: disable switch linkdown flush function to avoid LUT asynchronous
	ASSERT_EQ(rtk_l2_flushLinkDownPortAddrEnable_set(DISABLED),RT_ERR_OK);

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_G3_SERIES)
#elif defined(CONFIG_RG_RTL9602C_SERIES)
{
	uint32 regValue = 0x1;
	ASSERT_EQ(reg_field_write(RTL9602C_LUT_CFGr, RTL9602C_LUT_L34_ARP_USAGE_AS_KNOWNf, &regValue),RT_ERR_OK);
}
#elif defined(CONFIG_RG_RTL9607C_SERIES)
{
	uint32 regValue = 0x1;
	ASSERT_EQ(reg_field_write(RTL9607C_LUT_CFGr, RTL9607C_LUT_L34_ARP_USAGE_AS_KNOWNf, &regValue),RT_ERR_OK);
}
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
	ASSERT_EQ(rtk_rg_asic_l2ArpUsageAsKnown_set(RTK_RG_ENABLED), RT_ERR_RG_OK);
#elif defined(CONFIG_RG_G3_SERIES)
	//FIXME
#else
#error
#endif

	//if(rg_db.systemGlobal.initParam.macBasedTagDecision==0)
	//	rg_kernel.wanDmac2cvidDisabled = 0;
	//Chuck20170925: default disabled Wan dmac2cvid(turn on proc) to avoid GPON olt vlan is different with Wan vlan issue.
	rg_kernel.wanDmac2cvidDisabled = 1;
	//init dmac2cvid and vid unmatched action
	ASSERT_EQ(_rtk_rg_dmac2cvid_and_vidUnmatch_update(), RT_ERR_RG_OK);

	//Turn off Lut auto-learning, set unknown SA and port-move trap
	for(i=0;i<RTK_RG_MAC_PORT_MAX;i++)		//CPU port will use auto-learning, and do not turn on DMAC2CViD function
	{
		if(RG_INVALID_MAC_PORT(i)) continue;

		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i))
		{
#if !defined(CONFIG_RG_G3_SERIES)
			//Turn off CPU port LUT auto-learning, and set Action to Forward
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNT_SET(i,0),RT_ERR_OK);
#if defined(CONFIG_RG_RTL9600_SERIES) && defined(CONFIG_DUALBAND_CONCURRENT)
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_FORWARD),RT_ERR_OK);
#else
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_TO_CPU),RT_ERR_OK);
#endif
#endif
		}
		else
		{
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNT_SET(i,0),RT_ERR_OK);
#if defined(CONFIG_RG_G3_SERIES)
			// G3 use L3FE CLS as ACL rule, so we expect no L2 trap happens before ACL.
			// in such design, adding hw l2 entry is no necessary. that means no unknown sa, no unmatch vlan, no port moving.
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_FORWARD),RT_ERR_OK);
#elif defined(CONFIG_RG_RTL9607C_SERIES)
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,rg_kernel.layer2LookupMissFlood2CPU==RTK_RG_ENABLED?LIMIT_LEARN_CNT_ACTION_FORWARD:LIMIT_LEARN_CNT_ACTION_TO_CPU),RT_ERR_OK);
#else
			ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(i,LIMIT_LEARN_CNT_ACTION_TO_CPU),RT_ERR_OK);
#endif
			//because multicast unknow_sa trap > unknowMulticast drop so we should set unknow sa to forward
			//ASSERT_EQ(RTK_L2_NEWMACOP_SET(i,HARDWARE_LEARNING,ACTION_TRAP2CPU),RT_ERR_OK);
			ASSERT_EQ(RTK_L2_ILLEGALPORTMOVEACTION_SET(i,ACTION_TRAP2CPU),RT_ERR_OK);
		}
	}

	//Flush all unicast LUT may be learned by hardware
	ASSERT_EQ(RTK_L2_ADDR_DELALL(ENABLED),RT_ERR_OK);

#endif


#ifdef CONFIG_APOLLO_TESTING
	// inited by rtk_rg_module_init, do not do rtk_init() again!!! it will make virtualmac disabled!
	if(virtualmacEnable==ENABLE)
	{
		apollo_mac_init();
	}
#endif

#ifdef CONFIG_APOLLO_MODEL
#else
	#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//HSD debug
	assert_ok(rtk_l34_hsdState_set(ENABLED));
	#endif
#endif

#if defined(CONFIG_RG_NAPT_AUTO_AGEOUT) && !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Clear traffic
	rtk_l34_hwL4TrfWrkTbl_Clear(0);
	rtk_l34_hwL4TrfWrkTbl_Clear(1);
#endif

	//make sharemeter burst size larger
	for(i=0;i<MAX_HW_SHAREMETER_TABLE_SIZE;i++){
#if defined(CONFIG_RG_G3_SERIES)
		ASSERT_EQ(rtk_rate_shareMeterBucket_set(i,0xfff),RT_ERR_OK); //The maximun burst size for policer is 0xfff
#else
		ASSERT_EQ(rtk_rate_shareMeterBucket_set(i,0x3fff),RT_ERR_OK);
#endif
	}

	//Init ACL Template & Field Selector & RangeTable Value
	ASSERT_EQ(_rtk_rg_acl_asic_init(),RT_ERR_RG_OK);

	//Init Classify RangeTable Value
	ASSERT_EQ(_rtk_rg_classify_asic_init(),RT_ERR_RG_OK);

	//Init naptFilterAndQos (pure software)
	ASSERT_EQ(_rtk_rg_apollo_naptFilterAndQos_init(),RT_ERR_RG_OK);

	//init acllFilter for SW maintain info
	ASSERT_EQ(_rtk_rg_aclSWEntry_init(),RT_ERR_RG_OK);

	//init classify Filter for SW maintain info
	ASSERT_EQ(_rtk_rg_classifySWEntry_init(),RT_ERR_RG_OK);

	//PON,RGMII CF port init
	ASSERT_EQ(_rtk_rg_pon_rgmii_as_cf_port_check(),RT_ERR_RG_OK);

	//init reserved ACL SW maintain info
	ASSERT_EQ(_rtk_rg_aclReservedEntry_init(),RT_ERR_RG_OK);

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) //9607C testchip need to force trap none-recognized (PPP version=0x1 + Type=0x1 + Code)  PPP packet
	if(rg_db.systemGlobal.internalSupportMask == RTK_RG_INTERNAL_SUPPORT_BIT0){
		rtk_rg_aclAndCf_reserved_ack_packet_assign_priority_t ack_packet_assign_priority;
		bzero(&ack_packet_assign_priority,sizeof(ack_packet_assign_priority));
		ack_packet_assign_priority.priority=7;
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY, &ack_packet_assign_priority);
	}
#endif




#if defined(__KERNEL__) && defined(CONFIG_RG_RTL9600_SERIES)
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		assert_ok(_rtk_rg_acl_reserved_pppoeCvidIssue_svid2IngressCvid(RTK_RG_PORT_PON));
	}
#endif


#ifdef CONFIG_DUALBAND_CONCURRENT
	assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_IGMP_TO_SLAVE_WIFI_BLOCK, NULL));
	assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_SLAVE_WIFI_BC_MC_TRAP, NULL));
#endif

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_CONTROL_PACKET_TRAP, NULL));
#endif



#ifdef __KERNEL__
	//init stormControl  for SW maintain info
	ASSERT_EQ(_rtk_rg_stormControlEntry_init(),RT_ERR_RG_OK);
#endif

	//init urlFilter for SW maintain info
	ASSERT_EQ(_rtk_rg_urlFilter_table_init(),RT_ERR_RG_OK);

	//init macFilter for SW maintain info
	ASSERT_EQ(_rtk_rg_macFilter_table_init(),RT_ERR_RG_OK);

	ASSERT_EQ(_rtk_rg_urlAssignPri_table_init(),RT_ERR_RG_OK);


#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	//reserved RTK_RG_ACLANDCF_RESERVED_EPON_DROP_AND_INTERRUPT doesn't need for apolloFE.
#else
#ifdef CONFIG_EPON_FEATURE
	if(init_param==NULL || (init_param!=NULL && !init_param->wanPortGponMode))
	{
		if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT3)){
			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_EPON_DROP_AND_INTERRUPT, NULL);
		}
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_EPON_ASSIGN_PRIORITY, NULL);
	}
#endif


#endif

	//Enable tpid1
	ASSERT_EQ(RTK_SVLAN_TPIDENABLE_SET(0, ENABLED), RT_ERR_RG_OK);
	ASSERT_EQ(RTK_SVLAN_TPIDENTRY_SET(0, 0x88a8), RT_ERR_RG_OK);
#if defined(CONFIG_RG_RTL9600_SERIES)
#else // support tpid2
	ASSERT_EQ(RTK_SVLAN_TPIDENTRY_SET(1, 0x8100), RT_ERR_RG_OK);
#endif
#if !defined(CONFIG_RG_G3_SERIES)
	assert_ok(rtk_svlan_deiKeepState_set(ENABLED));	//keep dei format when trap to CPU
#endif


#if defined(CONFIG_RG_RTL9600_SERIES)
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		//Patch for 6266 b-cut and before, because we use STAG to patch pppoe issue,
		//we have to set this otherwise unmatch ctag packet will always untag!!
		ASSERT_EQ(rtk_svlan_sp2cUnmatchCtagging_set(ENABLED),RT_ERR_OK);
	}
#endif

	//Turn on Lut table extened 64 entries
	switch(rg_kernel.apolloChipId)
	{
#if defined(CONFIG_RG_RTL9600_SERIES)
		case APOLLOMP_CHIP_ID:
			ASSERT_EQ(apollomp_raw_l2_camEnable_set(ENABLED),RT_ERR_OK);
			break;
#endif
#if defined(CONFIG_RTL9601B_SERIES)
		case RTL9601B_CHIP_ID:
			ASSERT_EQ(rtk_l2_camState_set(ENABLED),RT_ERR_OK);
			break;
#endif
#if defined(CONFIG_RG_RTL9602C_SERIES)
		case RTL9602C_CHIP_ID:
			ASSERT_EQ(rtk_l2_camState_set(ENABLED),RT_ERR_OK);
			break;
#endif
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		case RTL9603CVD_CHIP_ID:
		case RTL9607C_CHIP_ID:
			ASSERT_EQ(rtk_l2_camState_set(ENABLED),RT_ERR_OK);
			break;
#endif
		default:
			DEBUG("Chip Not Support.\n");
	}


	//Port isolation initialization
#if defined(CONFIG_RG_RTL9600_SERIES)
	assert_ok(rtk_port_isolationCtagPktConfig_set(RTK_PORT_ISO_CFG_0)); //9602c and xdsl not support
	assert_ok(rtk_port_isolationL34PktConfig_set(RTK_PORT_ISO_CFG_0)); //9602c and xdsl not support
#endif
	allPortMask.portmask=RTK_RG_ALL_PORTMASK;	//all port and ext-port
	_rtk_rg_portmask_translator(allPortMask, &mbpmsk, &etpmsk);
#if defined(CONFIG_RG_G3_SERIES)
	etpmsk.bits[0]=0; //G3 port isolation not support extPort
#endif
	for(i=RTK_RG_PORT0;i<RTK_RG_PORT_MAX;i++)
	{
		if(RG_INVALID_PORT(i)) continue;

		rg_db.systemGlobal.portIsolation[i].portmask=allPortMask.portmask;

		if(RTK_RG_ALL_CPU_PORTMASK & (0x1<<i))
		{
			assert_ok(RTK_PORT_ISOLATIONIPMCLEAKY_SET(i, DISABLED));
			assert_ok(RTK_PORT_ISOLATIONENTRY_SET(RTK_PORT_ISO_CFG_0, i, &mbpmsk, &etpmsk));
			assert_ok(RTK_PORT_ISOLATIONENTRYEXT_SET(RTK_PORT_ISO_CFG_0, i-RTK_RG_PORT_LASTCPU, &mbpmsk, &etpmsk));
#if defined(CONFIG_RG_RTL9600_SERIES)
			assert_ok(RTK_PORT_ISOLATIONENTRY_SET(RTK_PORT_ISO_CFG_1, i, &mbpmsk, &etpmsk));
			assert_ok(RTK_PORT_ISOLATIONENTRYEXT_SET(RTK_PORT_ISO_CFG_1, i-RTK_RG_PORT_LASTCPU, &mbpmsk, &etpmsk));
#endif
		}
		else	// not cpu port
		{
			if(i>RTK_RG_PORT_LASTCPU) 	//ext port
			{
				assert_ok(RTK_PORT_ISOLATIONENTRYEXT_SET(RTK_PORT_ISO_CFG_0, i-RTK_RG_PORT_LASTCPU, &mbpmsk, &etpmsk));
#if defined(CONFIG_RG_RTL9600_SERIES)
				assert_ok(RTK_PORT_ISOLATIONENTRYEXT_SET(RTK_PORT_ISO_CFG_1, i-RTK_RG_PORT_LASTCPU, &mbpmsk, &etpmsk));
#endif
			}
			else						//not ext port
			{
				assert_ok(RTK_PORT_ISOLATIONIPMCLEAKY_SET(i, DISABLED));
				assert_ok(RTK_PORT_ISOLATIONENTRY_SET(RTK_PORT_ISO_CFG_0, i, &mbpmsk, &etpmsk));
#if defined(CONFIG_RG_RTL9600_SERIES)
				assert_ok(RTK_PORT_ISOLATIONENTRY_SET(RTK_PORT_ISO_CFG_1, i, &mbpmsk, &etpmsk));
#endif
			}
		}
	}

	//ALG initialization
	rtk_rg_init_alg_ESP();
	rg_db.algServInLanIpMapping[RTK_RG_ALG_SIP_TCP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_SIP_TCP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_SIP_UDP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_SIP_UDP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_H323_TCP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_H323_TCP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_H323_UDP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_H323_UDP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_RTSP_TCP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_RTSP_TCP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_RTSP_UDP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_RTSP_UDP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_FTP_TCP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_FTP_TCP_SRV_IN_LAN_BIT;
	rg_db.algServInLanIpMapping[RTK_RG_ALG_FTP_UDP_SRV_IN_LAN-RTK_RG_ALG_SIP_TCP_SRV_IN_LAN].algType=RTK_RG_ALG_FTP_UDP_SRV_IN_LAN_BIT;

	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE<<1;i++)
	{
		//bzero(&rg_db.systemGlobal.interfaceInfo[i], sizeof(rtk_rg_interface_info_global_t));
		//rg_db.systemGlobal.interfaceInfo[i].p_lanIntfConf=NULL;
		//rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo=NULL;

		//rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo=NULL;
		//rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo=NULL;
#ifdef __KERNEL__
		if(rg_db.systemGlobal.intfArpRequest[i].finished==0)
		{
			_rtk_rg_del_timer(&rg_kernel.arpRequestTimer[i]);

		}
		if(rg_db.systemGlobal.intfNeighborDiscovery[i].finished==0)
		{
			_rtk_rg_del_timer(&rg_kernel.neighborDiscoveryTimer[i]);
		}
#endif
		rg_db.systemGlobal.intfArpRequest[i].finished = 1;
		rg_db.systemGlobal.intfNeighborDiscovery[i].finished = 1;
	}

	for(i=0;i<MAX_STATIC_ROUTE_SIZE;i++){

		_rtk_rg_del_timer(&rg_kernel.staticRouteArpOrNBReqTimer[i]);
		rg_db.systemGlobal.staticRouteArpReq[i].finished = 1;
		rg_db.systemGlobal.staticRouteNBDiscovery[i].finished = 1;
	}

	/*for(i=0;i<MAX_BIND_HW_TABLE_SIZE;i++)
	{
		rg_db.systemGlobal.bindToIntf[i]=-1;
		rg_db.systemGlobal.bindWithVLAN[i]=-1;
	}*/

	//for(i=0;i<RTK_RG_PORT_MAX;i++)
		//rg_db.systemGlobal.portBasedVID[i]=rg_db.systemGlobal.initParam.fwdVLAN_CPU;		//reset port-based VLAN in rg_db


#if defined(CONFIG_RG_RTL9602C_SERIES)
    // init hw/sw mib interface counter

	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++) {
        rtk_rg_apolloFE_interfaceMibCounter_del(i);
	}
#endif


	for(i=0;i<RTK_RG_PORT_MAX;i++)
	{
		rg_db.systemGlobal.sourceAddrLearningLimitNumber[i]=DEF_SOFTWARE_LEARNING_LIMIT;		//reset port-based SA learning limit (software learning)
	}
	rg_db.systemGlobal.accessWanLimitPortMask=DEF_SOFTWARE_LEARNING_LIMIT;		//reset portmask WAN access limit
	rg_db.systemGlobal.accessWanLimitPortMask_member.portmask=0x0;				//default no port will be count for speed
	rg_db.systemGlobal.groupMACLimit=DEF_SOFTWARE_LEARNING_LIMIT;		//reset group mac limit
	rg_db.systemGlobal.groupMACLimit_member.portmask=0x0;				//default no port will be limited
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	rg_db.systemGlobal.accessWanLimitPortMask_wlan0member=0x0;
	rg_db.systemGlobal.groupMACLimit_wlan0member=0x0;
#endif
	for(i=0;i<WanAccessCategoryNum;i++)
		rg_db.systemGlobal.accessWanLimitCategory[i]=DEF_SOFTWARE_LEARNING_LIMIT;

#if defined(CONFIG_RG_8021X_MAC_TABLE_SIZE) && (CONFIG_RG_8021X_MAC_TABLE_SIZE!=0)
	memset(&rg_db.systemGlobal.accessDot1xCfg, 0, sizeof(rg_db.systemGlobal.accessDot1xCfg));
#endif

#if 0
	for(i=0;i<STATIC_DHCP_ALLOC_NUM;i++)
		_DHCP_STATIC[i].valid=0;
#endif

	//20151218LUKE: check if we should create default svlan or not.
	_rtk_rg_default_svlan_manipulate();
	/* Virtual Server initialization
	for(i=0;i<MAX_VIRTUAL_SERVER_SW_TABLE_SIZE;i++)
	{
		rg_db.systemGlobal.virtualServerGroup[i].p_virtualServer = NULL;
	}*/
	/* UPNP initialization
	for(i=0;i<MAX_UPNP_SW_TABLE_SIZE;i++)
	{
		rg_db.systemGlobal.upnpGroup[i].p_upnp = NULL;
	}*/

	//rg_db.systemGlobal.lanIntfTotalNum = 0;			//how many LAN interface added
	//rg_db.systemGlobal.wanIntfTotalNum = 0;			//how many WAN interface added
	//rg_db.systemGlobal.wanInfoSet = 0;			//which WAN interface had been set
	//rg_db.systemGlobal.vlanBindTotalNum = 0;
	//rg_db.systemGlobal.pppoeBeforeCalled = 0;
	rg_db.systemGlobal.defaultRouteSet = -1;		//keep which interface is default route
	rg_db.systemGlobal.defaultIPV6RouteSet = -1;	//keep which interface is IPv6 default route
	rg_db.systemGlobal.intfIdxForReset = -1;			//only use when wan need reset
	rg_db.systemGlobal.ssdp_trap_lut_idx =-1;
	//rg_db.systemGlobal.virtualServerTotalNum = 0;
	//rg_db.systemGlobal.upnpTotalNum = 0;
	rg_db.p_routingArpInfoArray=rg_db.routingArpInfoArray_1;
	rg_db.p_tempRoutingArpInfoArray=rg_db.routingArpInfoArray_2;
	rg_db.p_routingVlanInfoArray=rg_db.routingVlanInfoArray_1;	//store interface vlan id
	rg_db.p_tempRoutingVlanInfoArray=rg_db.routingVlanInfoArray_2;

/*
	//Set up PPPoE pass through Protocol Group
	protoGroupCfg.frametype=FRAME_TYPE_ETHERNET;
	protoGroupCfg.framevalue=0x8863;				//PPPoE discovery stage
	ret = rtk_vlan_protoGroup_set(PPPOE_DISCOVERY_GROUPID,&protoGroupCfg);
	if(ret!=RT_ERR_OK)return ret;

	protoGroupCfg.frametype=FRAME_TYPE_ETHERNET;
	protoGroupCfg.framevalue=0x8864;				//PPPoE session stage
	ret = rtk_vlan_protoGroup_set(PPPOE_SESSION_GROUPID,&protoGroupCfg);
	if(ret!=RT_ERR_OK)return ret;
*/
	//Set up Protocol Group for IPv4/v6 separately
	protoGroupCfg.frametype=FRAME_TYPE_ETHERNET;
	protoGroupCfg.framevalue=RG_IPV4_ETHERTYPE;				//IPv4
	ret = RTK_VLAN_PROTOGROUP_SET(RG_IPV4_GROUPID,&protoGroupCfg);
	if(ret!=RT_ERR_OK)return ret;
	protoGroupCfg.frametype=FRAME_TYPE_ETHERNET;
	protoGroupCfg.framevalue=RG_ARP_ETHERTYPE;				//ARP
	ret = RTK_VLAN_PROTOGROUP_SET(RG_ARP_GROUPID,&protoGroupCfg);
	if(ret!=RT_ERR_OK)return ret;
	protoGroupCfg.frametype=FRAME_TYPE_ETHERNET;
	protoGroupCfg.framevalue=RG_IPV6_ETHERTYPE;				//IPv6
	ret = RTK_VLAN_PROTOGROUP_SET(RG_IPV6_GROUPID,&protoGroupCfg);
	if(ret!=RT_ERR_OK)return ret;

#if !defined(CONFIG_RG_G3_SERIES)
	//Destory VLAN 1 created by RTK
	ret = RTK_VLAN_DESTROY(1);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

#endif

	//Set up CPU VLAN
	ret = RTK_VLAN_CREATE(rg_db.systemGlobal.initParam.fwdVLAN_CPU);
	if(ret == RT_ERR_NOT_INIT)
	{
		//Initialize VLAN module
		ret = rtk_vlan_init();
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_NOT_INIT);
		ret = RTK_VLAN_CREATE(rg_db.systemGlobal.initParam.fwdVLAN_CPU);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	}
	else if (ret == RT_ERR_VLAN_EXIST)
	{
		DEBUG("fwdVLAN_CPU[%d] had created..",rg_db.systemGlobal.initParam.fwdVLAN_CPU);
		rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].valid = 1;
	}
	mbpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;	//all port
	utpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;	//all untag
	etpmsk.bits[0]=RTK_RG_ALL_VIRUAL_PORTMASK;	//all extension port

	ret = RTK_VLAN_FID_SET(rg_db.systemGlobal.initParam.fwdVLAN_CPU, LAN_FID);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_FIDMODE_SET(rg_db.systemGlobal.initParam.fwdVLAN_CPU, VLAN_FID_SVL);		//This is used for ALL LAN interface
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_CPU, &mbpmsk, &utpmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_CPU, &etpmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

#ifdef CONFIG_RG_WAN_PORT_ISOLATE
	//cxy: for wan port isolate with lan ports
	mbpmsk.bits[0]=(1<<RTK_RG_PORT_PON);	//all port
	utpmsk.bits[0]=(1<<RTK_RG_PORT_PON);	//all untag
	etpmsk.bits[0]=0x0;	//all extension port

	ret = RTK_VLAN_CREATE(DEFAULT_WAN_VLAN);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_FID_SET(DEFAULT_WAN_VLAN, WAN_FID);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_FIDMODE_SET(DEFAULT_WAN_VLAN, VLAN_FID_SVL);		//This is used for ALL LAN interface
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_PORT_SET(DEFAULT_WAN_VLAN, &mbpmsk, &utpmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_EXTPORT_SET(DEFAULT_WAN_VLAN, &etpmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
#endif


#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	//_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_EGRESS_VLAN_FILTER_DISABLE, NULL);
	//20170524: apolloPro disabled H/W vlan-filter for case ACL translate ingress CVID which is not created.
	vlanFiltering=DISABLED;
#else
	vlanFiltering=ENABLE;
#endif

	//cvlan igr/egr filter switch
	ret = RTK_VLAN_VLANFUNCTIONENABLE_SET(vlanFiltering);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_G3_SERIES)
#else
	//forcibly disable svlan igr/egr filter switch
	ret = rtk_svlan_svlanFunctionEnable_set(DISABLED);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
#endif

	for(i=0;i<RTK_RG_MAC_PORT_MAX;i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;

		ret = RTK_VLAN_PORTIGRFILTERENABLE_SET(i, vlanFiltering);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

		ret = RTK_VLAN_PORTPVID_SET(i, rg_db.systemGlobal.initParam.fwdVLAN_CPU);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	}

	for(i=RTK_RG_EXT_PORT0;i<RTK_RG_PORT_MAX;i++)
	{
		if(RG_INVALID_PORT(i)) continue;

		/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
		ret = RTK_VLAN_EXTPORTPVID_SET(i-RTK_RG_EXT_BASED_PORT,rg_db.systemGlobal.initParam.fwdVLAN_CPU);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	}


#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//init preHashPtn
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_SPORT,  0xB0000);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_DPORT, 0x40000);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_SIP, 0xE00000);
	RTK_RG_ASIC_PREHASHPTN_SET(FB_PREHASH_PTN_DIP, 0xF00000);

	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TTL_1, ENABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_TCP_SYN_FIN_REST, ENABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_TCP_SYN_ACK, ENABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_FRAGMENT, ENABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_L3_CS_CHK, ENABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_L4_CS_CHK, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_L2_FLOW_LOOKUP_BY_MAC, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_CMP_TOS, DISABLED), RT_ERR_OK);

	//hash cvid
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_CVID, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_CVID, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_CVID, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_CVID, DISABLED), RT_ERR_OK);
	//20170614: Seal !! A path6 flow can not support multiple ingress vid.
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_CVID, ENABLED), RT_ERR_OK);
	//hash svid
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_SVID, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_SVID, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_SVID, DISABLED), RT_ERR_OK);
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_SVID, DISABLED), RT_ERR_OK);
	//20170614: Seal !! A path6 flow can not support multiple ingress vid.
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_SVID, ENABLED), RT_ERR_OK);
	//path34 default hash dmacIndex(or dmac==GMAC)
	ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_SKIP_DA, DISABLED), SUCCESS);
#if defined(CONFIG_RG_RTL9607C_SERIES)
	if(!(rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
#endif
	{
		// 20180521: enable flow hash of Cpri and DSCP by default
		//hash cpri
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH12_SKIP_CPRI, DISABLED), SUCCESS);
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_UCBC_SKIP_CPRI, DISABLED), SUCCESS);
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH34_MC_SKIP_CPRI, DISABLED), SUCCESS);
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH5_SKIP_CPRI, DISABLED), SUCCESS);
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_CPRI, DISABLED), SUCCESS);
		//hash dscp
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATHALL_SKIP_DSCP, DISABLED), SUCCESS);

		//path6 hash skip da,sa
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_SA, ENABLED), SUCCESS);
		ASSERT_EQ(RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_PATH6_SKIP_DA, ENABLED), SUCCESS);
	}

#if !defined(CONFIG_RG_G3_SERIES)
	//path34 init lut loopup mode
	ASSERT_EQ(rtk_l2_ipmcMode_set(LOOKUP_ON_MAC_AND_VID_FID), SUCCESS);
	//ASSERT_EQ(rtk_l2_ipmcVlanMode_set(LOOKUP_VLAN_FORCE_NO_VLAN), SUCCESS);
	ASSERT_EQ(rtk_l2_ipmcVlanMode_set(LOOKUP_VLAN_BY_IVL_SVL), SUCCESS);
#endif

	//init flow ingress check
	//check tos
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_TOS] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH34_TOS] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH5_TOS] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_TOS] = DISABLED;
	//check protocol
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_PROTOCOL] = DISABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_PROTOCOL] = DISABLED;
	//check spa
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_SPA] = DISABLED;
	//check stream idx
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH12_STREAM_IDX] = DISABLED;
	//check path6
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SMAC_IDX] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DMAC_IDX] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SIP] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DIP] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_SPORT] = DISABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_DPORT] = DISABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_GRE_CALL_ID] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_TUNNEL_ID] = ENABLED;
	rg_db.systemGlobal.flowCheckState[FB_FLOW_CHECK_PATH6_L2TP_SID] = ENABLED;

	ASSERT_EQ(RTK_RG_ASIC_WANACCESSLIMITPORTMASK_SET(0x0), RT_ERR_RG_OK);

#if defined(CONFIG_RG_G3_SERIES)
	ASSERT_EQ(_rtk_rg_g3_flow_key_mask_init(), RT_ERR_RG_OK);
	rtk_cpu_tagAwareByPort_set(RTK_RG_MAC_PORT_CPU, ENABLED);	//turn on aware cpu tag for cpu ports

#if defined(CONFIG_RG_G3_L2FE_POL_OFFLOAD)
	ASSERT_EQ(rtk_rg_g3_l2fe_hostpolicing_init(), RT_ERR_RG_OK);
#endif
#if defined(CONFIG_RG_G3_L3FE_MC_DEEPQ)
	rtk_rg_g3_l3fe_mcbuffering_init();
#endif
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	rtk_rg_asic_hsbaMode_set(L34_HSBA_LOG_ALL);								//turn on all hsba log
	//turn on aware cpu tag for cpu ports
	for(i=RTK_RG_MAC_PORT0; i<RTK_RG_MAC_PORT_MAX; i++)
	{
		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i))
		{
			rtk_cpu_tagAwareByPort_set(i, ENABLED);
			rtk_cpu_trapInsertTagByPort_set(i,ENABLED);
		}
	}
	_rtk_rg_lut_ucLookupAction_init();										//FB mode or LUT_FB mix mode

	//Set un-match flow priority
	if(rg_db.systemGlobal.prevent_control_packet_drop == ENABLE)
		ASSERT_EQ(rtk_rg_asic_unmatchedCpuPriority_set(RTK_RG_UNMATCH_FLOW_TRAP_PRI),RT_ERR_RG_OK);
	else
		ASSERT_EQ(rtk_rg_asic_unmatchedCpuPriority_set(RTK_RG_UNMATCH_FLOW_TRAP_PRI_DEFAULT),RT_ERR_RG_OK);

	//disabled force FB trap priroity, let it follow switch.
	ASSERT_EQ(rtk_rg_asic_trapCpuPriority_set(DISABLED, 0),RT_ERR_RG_OK);

#if defined(CONFIG_RG_RTL9607C_SERIES)
#if defined(CONFIG_SWITCH_SYS_CLOCK_TUNE)
	if(!(rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0)){
		ASSERT_EQ(rtk_rg_asic_shareMeterGlobalConfig_set(0x16, 0x3c), RT_ERR_RG_OK);
	}else
#endif
	{
		ASSERT_EQ(rtk_rg_asic_shareMeterGlobalConfig_set(0x57, 0xbd), RT_ERR_RG_OK);
	}
#endif
#endif //defined(CONFIG_RG_G3_SERIES)

#else //1 not CONFIG_RG_FLOW_BASED_PLATFORM
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_L34_STATE,ENABLED),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_L3NAT_STATE,ENABLED),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_L4NAT_STATE,ENABLED),RT_ERR_OK);

	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_L3CHKSERRALLOW_STATE,DISABLED),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_L4CHKSERRALLOW_STATE,DISABLED),RT_ERR_OK);

	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_BIND_STATE,ENABLED),RT_ERR_OK);		//turn on binding for 0601
#if defined(CONFIG_RG_RTL9602C_SERIES)
	//9602bvb remove this flag
#else
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_PPPKEEP_STATE,ENABLED),RT_ERR_OK);	//turn off PPPoE keep in default
#endif

	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_NAT2LOG_STATE,ENABLED),RT_ERR_OK);

#if defined(CONFIG_RG_RTL9600_SERIES)
	//20160217LUKE: for 9600, TTLMINUS_STATE will influence multicast packet also, so disable in advance here.
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_TTLMINUS_STATE,DISABLED),RT_ERR_OK);
#else
	//20160217LUKE: Otherwise, TTLMINUS_STATE won't influence multicast packet, so we can safely turn it on.
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_TTLMINUS_STATE,ENABLED),RT_ERR_OK);
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_FRAG2CPU_STATE,ENABLED),RT_ERR_OK);
	// 9602bvb remove L34_GLOBAL_KEEP_ORG_STATE.(always original when org=1)
	//20151001LUKE: turn on DSlite support defaultly
	ASSERT_EQ(rtk_l34_dsliteControl_set(L34_DSLITE_CTRL_DSLITE_STATE,ENABLED),RT_ERR_OK);
	//turn off flow route defaultly
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_V4FLOW_RT_STATE,DISABLED),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_V6FLOW_RT_STATE,DISABLED),RT_ERR_OK);
	if(rg_kernel.block_communication_between_internet_and_other)
	{
		//20170509: L34 packets are trapped to cpu due to arp miss of sip lookup (reason 27).
		//only update dip arp
		ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_SIP_ARP_TRF_STATE,DISABLED),RT_ERR_OK);
		ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_DIP_ARP_TRF_STATE,ENABLED),RT_ERR_OK);
	}
	else
	{
		//only update sip arp
		ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_SIP_ARP_TRF_STATE,ENABLED),RT_ERR_OK);
		ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_DIP_ARP_TRF_STATE,DISABLED),RT_ERR_OK);
	}
#else
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_FRAG2CPU_STATE,ENABLED),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_GLOBALSTATE_SET(L34_GLOBAL_KEEP_ORG_STATE,ENABLED),RT_ERR_OK);
#endif

	ASSERT_EQ(rtk_l34_wanRoutMode_set(L34_WANROUTE_FORWARD),RT_ERR_OK);
	ASSERT_EQ(rtk_l34_lookupMode_set(L34_LOOKUP_MAC_BASE),RT_ERR_OK);
	ASSERT_EQ(rtk_l34_hsabMode_set(L34_HSBA_LOG_ALL),RT_ERR_OK);			//turn on all hsba log
#endif // CONFIG_RG_FLOW_BASED_PLATFORM


	//initialize unmatch action register
#if defined(CONFIG_RG_RTL9600_SERIES)
	//20170517: When L2 bind to L3/L34 and binding action is forced L2 forward, packet will do pppoe action.
	//Therefore, trap packet to fwdEngine and do Forced Bridge action
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L2L3,L34_BIND_ACT_TRAP),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L2L34,L34_BIND_ACT_TRAP),RT_ERR_OK);
#else
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L2L3,L34_BIND_ACT_FORCE_L2BRIDGE),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L2L34,L34_BIND_ACT_FORCE_L2BRIDGE),RT_ERR_OK);
#endif
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L3L2,L34_BIND_ACT_DROP),RT_ERR_OK);	//20140717LUKE:these packets should be blocked
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L3L3,L34_BIND_ACT_FORCE_BINDL3),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L3L34,L34_BIND_ACT_IPV4_LOOKUPL4TABLE_IPV6_TRAP),RT_ERR_OK);

	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L34L2,L34_BIND_ACT_DROP),RT_ERR_OK);	//20140717LUKE:these packets should be blocked
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_UNMATCHED_L34L3,L34_BIND_ACT_FORCE_BINDL3_SKIP_LOOKUPL4),RT_ERR_OK);

	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_CUSTOMIZED_L2,L34_BIND_ACT_PERMIT_L2BRIDGE),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_CUSTOMIZED_L3,L34_BIND_ACT_FORCE_BINDL3),RT_ERR_OK);
	ASSERT_EQ(RTK_L34_BINDINGACTION_SET(L34_BIND_CUSTOMIZED_L34,L34_BIND_ACT_NORMAL_LOOKUPL34),RT_ERR_OK);


#ifdef __KERNEL__
#if !defined(CONFIG_RG_G3_SERIES)
	//Turn off CPU port flow control (2014/09/29: To turn on flow-control will cause CPU can't send packet to any port when pause frame is received.)
	for(i=RTK_RG_MAC_PORT0; i<RTK_RG_MAC_PORT_MAX; i++)
	{
		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i))
		{
			ASSERT_EQ(RTK_PORT_MACFORCEABILITY_GET(i,&cpuAbility),RT_ERR_OK);
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
			if(rg_db.systemGlobal.prevent_control_packet_drop == ENABLE)
			{

				cpuAbility.txFc=ENABLED;
				cpuAbility.rxFc=ENABLED;
			}
			else
#endif
			{

				cpuAbility.txFc=DISABLED;
				cpuAbility.rxFc=DISABLED;
			}
#if defined(CONFIG_GMAC2_USABLE)
			if(i==RTK_RG_PORT_SLAVECPU)
			{
				cpuAbility.duplex = PORT_FULL_DUPLEX;
				cpuAbility.linkStatus = PORT_LINKUP;
				cpuAbility.speed = PORT_SPEED_1000M;
			}
#endif
			ASSERT_EQ(RTK_PORT_MACFORCEABILITY_SET(i,cpuAbility),RT_ERR_OK);
			ASSERT_EQ(RTK_PORT_MACFORCEABILITYSTATE_SET(i,ENABLED),RT_ERR_OK);
		}
	}
#endif
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_APOLLO_FPGA_PHY_TEST)
	/*Enable ring 1 of GMAC9 flow control and disable other ones. (disabled rings will not sent out pause frames)*/
	re8686_set_flow_control(0, 0, DISABLE);
	if(rg_db.systemGlobal.prevent_control_packet_drop == ENABLE)
		re8686_set_flow_control(0, 1, ENABLE);
	else
		re8686_set_flow_control(0, 1, DISABLE);
	re8686_set_flow_control(0, 2, DISABLE);
	re8686_set_flow_control(0, 3, DISABLE);
	re8686_set_flow_control(0, 4, DISABLE);
	re8686_set_flow_control(0, 5, DISABLE);
	re8686_set_flow_control(1, 0, DISABLE);
	re8686_set_flow_control(1, 1, DISABLE);
	re8686_set_flow_control(1, 2, DISABLE);
	re8686_set_flow_control(1, 3, DISABLE);
	re8686_set_flow_control(1, 4, DISABLE);
	re8686_set_flow_control(1, 5, DISABLE);

#if !defined(CONFIG_RG_G3_SERIES)	// CONFIG_RG_G3_SERIES_DEVELOPMENT
	/*If rg_fc_db.controlFuc.prevent_control_packet_drop is enabled, turn on NIC suspend mechanism*/
	if(rg_db.systemGlobal.prevent_control_packet_drop == ENABLE)
		re8686_set_pauseBySw(ENABLE);
	else
		re8686_set_pauseBySw(DISABLE);

#if defined(CONFIG_RG_RTL9607C_SERIES)
	//Enable CPU trap hash and enable hash select items: SIP, DIP, SPORT and DPORT
	for(i = 0 ; i < MAX_TRAP_HASH_RESULT ; i++)
	{
		if(i & 0x1)
			RTK_TRAP_CPUTRAPHASHPORT_SET(i, RTK_RG_MAC_PORT_MASTERCPU_CORE1);
		else
			RTK_TRAP_CPUTRAPHASHPORT_SET(i, RTK_RG_MAC_PORT_MASTERCPU_CORE0);
	}
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_SPA, DISABLE);
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_SMAC, DISABLE);
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_DMAC, DISABLE);
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_SIP_INNER, DISABLE);
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_DIP_INNER, DISABLE);
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_SPORT_INNER, ENABLE);
	rtk_trap_cpuTrapHashMask_set(TRAP_HASH_DPORT_INNER, ENABLE);
#endif

#if defined(CONFIG_GMAC1_USABLE)
#if defined(CONFIG_RG_RTL9607C_SERIES) && defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE) && !defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
	if(!rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
		rtk_trap_cpuTrapHashState_set(DISABLED);
	else
#endif
		rtk_trap_cpuTrapHashState_set(ENABLED);
#else
	rtk_trap_cpuTrapHashState_set(DISABLED);
#endif
#endif
#endif


#ifdef CONFIG_RG_NAPT_UPNP_SUPPORT
	rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack=_rtk_rg_fwdEngine_upnpCheck;
	#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupFirstCallBack=NULL;	//reserved for future requirement
	#endif //end of CONFIG_RG_IPV6_NAPT_SUPPORT
#else
	rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack=NULL;
	rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupFirstCallBack=NULL;
#endif

#ifdef CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT
	rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack=_rtk_rg_fwdEngine_virtualServerCheck;
	#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupSecondCallBack=_rtk_rg_fwdEngine_ipv6VirtualServerCheck;
	#endif //end of CONFIG_RG_IPV6_NAPT_SUPPORT
#else
	rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack=NULL;
	rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupSecondCallBack=NULL;
#endif

#ifdef CONFIG_RG_NAPT_DMZ_SUPPORT
	rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack=_rtk_rg_fwdEngine_dmzCheck;
	#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupThirdCallBack=_rtk_rg_fwdEngine_ipv6DmzCheck;
	#endif //end of CONFIG_RG_IPV6_NAPT_SUPPORT
#else
	rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack=NULL;
	rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupThirdCallBack=NULL;
#endif //end of CONFIG_RG_NAPT_DMZ_SUPPORT

	ASSERT_EQ(_rtk_rg_igmpSnoopingOnOff(rg_db.systemGlobal.initParam.igmpSnoopingEnable,0,rg_db.systemGlobal.initParam.ivlMulticastSupport),RT_ERR_RG_OK);

	// flush all igmp entry
    rtl_flushAllIgmpRecord(1);


	//drop multicast packets if they are from cpu port (follow abel's suggestion, please refer to mail "[ApolloMP] L2 lookup-miss multicast action" at 20160520)
	for(i=RTK_RG_MAC_PORT0; i<RTK_RG_MAC_PORT_MAX; i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;

		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i))
		{
			ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IPMC,ACTION_TRAP2CPU),RT_ERR_RG_OK);
			ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_IP6MC,ACTION_TRAP2CPU),RT_ERR_RG_OK);
			ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_MCAST,ACTION_DROP),RT_ERR_RG_OK);
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	for(i=RTK_RG_MAC_PORT0; i<RTK_RG_MAC_PORT_MAX; i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;
		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i))
			continue;
		ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(i,DLF_TYPE_BCAST,rg_kernel.layer2LookupMissFlood2CPU==RTK_RG_DISABLED?ACTION_TRAP2CPU:ACTION_FORWARD),RT_ERR_RG_OK);
	}
#endif


	mbpmsk.bits[0]=1<<RTK_RG_MAC_PORT_MAINCPU;
#if !defined(CONFIG_RG_G3_SERIES)
	ASSERT_EQ(rtk_l2_lookupMissFloodPortMask_set(DLF_TYPE_MCAST,&mbpmsk),RT_ERR_RG_OK);		//set multicast flooding port
#endif

	for(i=0;i<=RTK_RG_PORT_LASTCPU;i++)
	{
		if(RG_INVALID_PORT(i)) continue;
#if defined(CONFIG_RG_G3_SERIES)
		if(RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<i)) continue;
#endif
#ifndef CONFIG_RG_G3_SERIES
		ASSERT_EQ(RTK_TRAP_PORTIGMPMLDCTRLPKTACTION_SET(i, IGMPMLD_TYPE_IGMPV1,ACTION_TRAP2CPU),RT_ERR_RG_OK) ;
		ASSERT_EQ(RTK_TRAP_PORTIGMPMLDCTRLPKTACTION_SET(i, IGMPMLD_TYPE_IGMPV2,ACTION_TRAP2CPU),RT_ERR_RG_OK) ;
		ASSERT_EQ(RTK_TRAP_PORTIGMPMLDCTRLPKTACTION_SET(i, IGMPMLD_TYPE_IGMPV3,ACTION_TRAP2CPU),RT_ERR_RG_OK) ;
		ASSERT_EQ(RTK_TRAP_PORTIGMPMLDCTRLPKTACTION_SET(i, IGMPMLD_TYPE_MLDV1,ACTION_TRAP2CPU),RT_ERR_RG_OK);
		ASSERT_EQ(RTK_TRAP_PORTIGMPMLDCTRLPKTACTION_SET(i, IGMPMLD_TYPE_MLDV2,ACTION_TRAP2CPU),RT_ERR_RG_OK) ;
#endif
	}

	rg_db.systemGlobal.vlanInit = 1;

	//Set Default routing to CPU
	bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
    rtEntry.valid=1;
    rtEntry.process=L34_PROCESS_CPU;		//set all packets to CPU if WAN is default route

    ASSERT_EQ(RTK_L34_ROUTINGTABLE_SET(V4_DEFAULT_ROUTE_IDX, &rtEntry),RT_ERR_OK);		//set default route

#ifdef CONFIG_DUALBAND_CONCURRENT
/*
	//Create routing to CPU for Wifi2 subnet
	bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
	rtEntry.ipAddr=0x0afdfd00;	//10.253.253.0
	rtEntry.ipMask=29;	// 2bits,  total has 4 addresses
    rtEntry.valid=1;
    rtEntry.process=L34_PROCESS_CPU;		//set all packets to CPU if WAN is default route

    ASSERT_EQ(RTK_L34_ROUTINGTABLE_SET(SLAVE_WIFI_ROUTE_IDX, &rtEntry),RT_ERR_OK);		//set ipc route
*/

	//20160531Chuck: instead IPC routing trap by reserved ACl to save Routing entry.
	_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_WIFI2_IPC_ROUTING_TRAP, NULL);
#endif



	//Set IPv6 Default routing to CPU
	bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
    rtv6Entry.valid=1;
    rtv6Entry.type=L34_IPV6_ROUTE_TYPE_TRAP;	//set all ipv6 packets to CPU if WAN is default route

    ASSERT_EQ(RTK_L34_IPV6ROUTINGTABLE_SET(V6_DEFAULT_ROUTE_IDX, &rtv6Entry),RT_ERR_OK);		//set default route

	//Create dummy LUT entry for TRAP to CPU
	/*i=rg_db.systemGlobal.defaultTrapLUTIdx;
	ret = rtk_rg_macEntry_find(&macEt, &i);

	if(ret==RT_ERR_RG_OK && i==rg_db.systemGlobal.defaultTrapLUTIdx)		//delete old record if had
		rtk_rg_macEntry_del(rg_db.systemGlobal.defaultTrapLUTIdx);*/

	bzero(&macEt, sizeof(rtk_rg_macEntry_t));
	macEt.isIVL=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].fidMode==VLAN_FID_IVL)?1:0;
	macEt.fid=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].fid;
	macEt.vlan_id=rg_db.systemGlobal.initParam.fwdVLAN_CPU;
	macEt.port_idx=RTK_RG_PORT_MAINCPU;
	macEt.wlan_device_idx=FAIL;
	macEt.static_entry=1;		//static for not age-out, didn't turn on ARP_USED flag for it to TRAP
	ASSERT_EQ((pf.rtk_rg_macEntry_add)(&macEt, &rg_db.systemGlobal.defaultTrapLUTIdx),RT_ERR_RG_OK);

	//Set the downstream CF rule for VLAN binding
	/*memset(&cfEntry, 0, sizeof(cfEntry));
	cfEntry.index=RG_GLB_VLAN_BINDING_CFIDX;
	cfEntry.direction=CLASSIFY_DIRECTION_DS;
    cfEntry.valid=0;		//Disabled in begining, if there is Vlan binding, it will become valid
    cfEntry.act.dsAct.cAct=CLASSIFY_DS_CACT_ADD_CTAG_8100;
    cfEntry.act.dsAct.cVidAct=CLASSIFY_DS_VID_ACT_FROM_LUT;
    cfEntry.act.dsAct.cPriAct=CLASSIFY_DS_PRI_ACT_NOP;
    cfEntry.act.dsAct.uniAct=CLASSIFY_DS_UNI_ACT_NOP;		//all port should be classified
    ret = rtk_classify_cfgEntry_add(&cfEntry);
    if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_CF_ENTRY_ACCESS_FAILED);*/


	/* IPv4 broadcast and unicast unknown DA flooding setting: trap to CPU */
#if !defined(CONFIG_RG_G3_SERIES)
	ASSERT_EQ(rtk_l2_lookupMissFloodPortMask_set(DLF_TYPE_BCAST,&mbpmsk),RT_ERR_RG_OK);		//set broadcast
	ASSERT_EQ(rtk_l2_lookupMissFloodPortMask_set(DLF_TYPE_UCAST,&mbpmsk),RT_ERR_RG_OK);		//set unicast unknown DA flooding mask
#endif
	//ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_BCAST,ACTION_FORWARD),RT_ERR_RG_OK);		//broadcast action can't be set, always flooding
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_UCAST,rg_kernel.layer2LookupMissFlood2CPU==RTK_RG_DISABLED?ACTION_TRAP2CPU:ACTION_FORWARD),RT_ERR_RG_OK);		//set unicast unknown DA action

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
	//this function is not supported in apollo.

	//G3 not support these type (DLF_TYPE_ICMP6MC, DLF_TYPE_DHCP6MC, DLF_TYPE_RSVIPMC, DLF_TYPE_RSVIP6MC)
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_ICMP6MC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_DHCP6MC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_RSVIPMC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_lookupMissAction_set(DLF_TYPE_RSVIP6MC, ACTION_TRAP2CPU),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF01,ENABLED),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF02,ENABLED),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF05,ENABLED),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_RSVDOC_FF0E,ENABLED),RT_ERR_RG_OK);
	ASSERT_EQ(rtk_l2_ip6mcReservedAddrEnable_set(LUT_IP6MCADDR_SOILCITED_NOTE,ENABLED),RT_ERR_RG_OK);

#endif

#if defined(CONFIG_RG_G3_SERIES)	// CONFIG_RG_G3_SERIES_DEVELOPMENT
		//unkwon-da trap
		ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_RG_PORT0,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
		ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_RG_PORT1,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
		ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_RG_PORT2,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
		ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_RG_PORT3,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
		ASSERT_EQ(RTK_L2_PORTLOOKUPMISSACTION_SET(RTK_RG_PORT_PON,DLF_TYPE_UCAST,ACTION_TRAP2CPU),RT_ERR_RG_OK);
		//vlan filter disabled
#endif


	//add init callback to sync protocal-stack
	if(rg_db.systemGlobal.initParam.initByHwCallBack != NULL)
	{
		DEBUG("do initByHwCallBack()");
		rg_db.systemGlobal.initParam.initByHwCallBack();
	}

	for(i=0;i<8;i++)
	{
		ASSERT_EQ(RTK_QOS_1PPRIREMAPGROUP_SET(0,i,i,0),SUCCESS); //set 1Q-Base Priority ReMapping to internal Priority
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(i != CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
#endif
		{
			ASSERT_EQ(rtk_rg_apollo_qosDot1pPriRemarkByInternalPri_set(i, i), SUCCESS); //set internal Priority to dot1P remarking
			ASSERT_EQ(rtk_rg_apollo_qosDscpRemarkByInternalPri_set(i, 0), SUCCESS); //set internal Priority to dscp remarking
		}
	}

	for(i = 0 ; i < RTK_RG_MAC_PORT_MAX ; i++)
	{
		//set dot1P/dscp remarking per port disabling
		if((0x1<<i) & RTK_RG_ALL_MAC_PORTMASK & rg_db.systemGlobal.phyPortStatus)
		{
			ASSERT_EQ(rtk_rg_apollo_qosDot1pPriRemarkByInternalPriEgressPortEnable_set(i, RTK_RG_DISABLED), SUCCESS);
			ASSERT_EQ(rtk_rg_apollo_qosDscpRemarkEgressPortEnableAndSrcSelect_set(i, RTK_RG_DISABLED, 0), SUCCESS);


			//set port-based priority
#ifdef CONFIG_DUALBAND_CONCURRENT
			if(0 == CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
				WARNING("Check port-based priority setting!");
			else
#endif
			{
				ASSERT_EQ(rtk_rg_apollo_qosPortBasedPriority_set(i, 0), SUCCESS);
			}
		}
	}

	//set dscp remapping
	for(i=0 ; i < 64 ; i++)
	{
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(0 == CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
			WARNING("Check dscp remapping setting!");
		else
#endif
		{
			ASSERT_EQ(rtk_rg_apollo_qosDscpRemapToInternalPri_set(i, 0), SUCCESS);//set dscp Priority ReMapping to internal Priority
		}
		ASSERT_EQ(rtk_rg_apollo_qosDscpRemarkByDscp_set(i, 0), SUCCESS); //set dscp to dscp remarking
	}


#if !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
	// set CPU port's SA learning limit action to TRAP
	ASSERT_EQ(RTK_L2_PORTLIMITLEARNINGCNTACTION_SET(RTK_RG_MAC_PORT_MAINCPU,LIMIT_LEARN_CNT_ACTION_TO_CPU),RT_ERR_OK);
#endif	// end not CONFIG_RG_G3_SERIES
	// disable CPU port & all extension port src filter
	srcExtPortFilterMmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU;
    ASSERT_EQ(RTK_L2_SRCPORTEGRFILTERMASK_SET(&srcExtPortFilterMmsk),SUCCESS);
	srcExtPortFilterMmsk.bits[0]=0; // src filter ext port by software
#if !defined(CONFIG_RG_G3_SERIES)
    ASSERT_EQ(rtk_l2_extPortEgrFilterMask_set(&srcExtPortFilterMmsk),SUCCESS);


	//set internal pri to CPU pri mapping
	for(i=0;i<8;i++)
	{
		ASSERT_EQ(rtk_qos_fwd2CpuPriRemap_set(i,i),SUCCESS);
	}
#endif

	//set pri weight
	{
		rtk_qos_priSelWeight_t weight;
		memset(&weight,0,sizeof(weight));
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		weight.weight_of_portBased=1;
		weight.weight_of_dot1q=2;
		weight.weight_of_dscp=0; //disable DSCP pri-decision
		weight.weight_of_acl=7;
		weight.weight_of_svlanBased=5;
		weight.weight_of_l4Based=6;
		ASSERT_EQ(RTK_QOS_PRISELGROUP_SET(0, &weight),SUCCESS);
		ASSERT_EQ(RTK_QOS_PRISELGROUP_SET(1, &weight),SUCCESS);
#else
	    weight.weight_of_portBased=1;
	    weight.weight_of_dot1q=2;
		weight.weight_of_dscp=0; //disable DSCP pri-decision
	    weight.weight_of_acl=15;
    	weight.weight_of_lutFwd=14;
	    weight.weight_of_saBaed=13;
	    weight.weight_of_vlanBased=10;
	    weight.weight_of_svlanBased=9;
    	weight.weight_of_l4Based=11;

		ASSERT_EQ(RTK_QOS_PRISELGROUP_SET(0, &weight),SUCCESS);
		ASSERT_EQ(RTK_QOS_PRISELGROUP_SET(1, &weight),SUCCESS);
#endif
	}

#if 0	// 20180521: enable flow hash of Cpri and DSCP by default
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_determind_fb_flow_hash_flexible_pattern(); //Chuck20170317: default do not using dot1p to internal-priority for saving FB hash index
#endif
#endif



	for(i=0;i<RTK_RG_MAC_PORT_MAX;i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;
		ASSERT_EQ(RTK_QOS_PORTPRIMAP_SET(i, 3),SUCCESS); //per port use table3 for internal-pri <=> queue mapping
	}


#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	//ApolloFE suppport only one wifi, no need reserved ACL to patch.
#else

#if defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION)
	ASSERT_EQ(_rtk_rg_acl_reserved_wifi_extPMaskTranslate_add(0,(1<<(RTK_RG_EXT_PORT0-RTK_RG_PORT_CPU)),(1<<(RTK_RG_EXT_PORT2-RTK_RG_PORT_CPU))),SUCCESS); //from EXT1, destExtPortMask=0x8 (patch: NIC RX haven't EXT-SPA filed)
#ifdef CONFIG_DUALBAND_CONCURRENT
	ASSERT_EQ(_rtk_rg_acl_reserved_wifi_extPMaskTranslate_add(1,(1<<(RTK_RG_EXT_PORT1-RTK_RG_PORT_CPU)),(1<<(RTK_RG_EXT_PORT3-RTK_RG_PORT_CPU))),SUCCESS);//from EXT2, destExtPortMask=0x10 (patch: NIC RX haven't EXT-SPA filed)

	vlanForSlaveWifi.isIVL=0;
	vlanForSlaveWifi.memberPortMask.portmask=((1<<RTK_RG_PORT_CPU)|(1<<RTK_RG_EXT_PORT0)|(1<<RTK_RG_EXT_PORT1));
	vlanForSlaveWifi.untagPortMask.portmask=RTK_RG_ALL_MAC_PORTMASK;
	vlanForSlaveWifi.vlanId=CONFIG_DEFAULT_TO_SLAVE_GMAC_VID;
	vlanForSlaveWifi.vlan_based_pri=0;
	vlanForSlaveWifi.vlan_based_pri_enable=DISABLED;
	ASSERT_EQ(rtk_rg_apollo_cvlan_add(&vlanForSlaveWifi),SUCCESS);


	ASSERT_EQ(_rtk_rg_acl_reserved_wifi_internalVidPriTranslateForSlave(CONFIG_DEFAULT_TO_SLAVE_GMAC_VID,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI,CONFIG_DEFAULT_TO_SLAVE_GMAC_VID,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI),SUCCESS); // patch for Slave GMAC packets recvice by special 1Q VID and PRI

	if(CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI==7)
	{
		ASSERT_EQ(RTK_QOS_1PPRIREMAPGROUP_SET(0,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI,6,0),SUCCESS); //patch: Pri=4 is reserved for Slave GMAC, So 1Q Pri=4 is mapping to Pri=5.
	}
	else
	{
		ASSERT_EQ(RTK_QOS_1PPRIREMAPGROUP_SET(0,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI+1,0),SUCCESS); //patch: Pri=4 is reserved for Slave GMAC, So 1Q Pri=4 is mapping to Pri=5.
	}

	// SET SLAVE CPU STATIC MAC ADDRESS
	{
		rtk_rg_macEntry_t macEntry;
		int entry_idx;
		memset(&macEntry,0,sizeof(macEntry));
		macEntry.arp_used=0;
		macEntry.isIVL=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].fidMode==VLAN_FID_IVL)?1:0;
		_rtk_rg_str2mac(CONFIG_DEFAULT_SLAVE_IPC_MAC_ADDRESS,&macEntry.mac);
		//printk("######### %02x:%02x:%02x:%02x:%02x:%02x ###########\n",macEntry.mac.octet[0],macEntry.mac.octet[1]
		//	,macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

		macEntry.port_idx=RTK_RG_EXT_PORT1;
		//20170522LUKE: wlan_device_idx should not FAIL here, so give it a dummy index.
		macEntry.wlan_device_idx=WLAN_DEVICE_NUM;
		macEntry.static_entry=1;
		macEntry.fid=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].fid;
		macEntry.vlan_id=rg_db.systemGlobal.initParam.fwdVLAN_CPU;
		(pf.rtk_rg_macEntry_add)(&macEntry,&entry_idx);
	}

	// SET MASTER CPU STATIC MAC ADDRESS
	{
		rtk_rg_macEntry_t macEntry;
		int entry_idx;
		memset(&macEntry,0,sizeof(macEntry));
		macEntry.arp_used=0;
		macEntry.isIVL=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].fidMode==VLAN_FID_IVL)?1:0;
		_rtk_rg_str2mac(CONFIG_DEFAULT_MASTER_IPC_MAC_ADDRESS,&macEntry.mac);
		//printk("######### %02x:%02x:%02x:%02x:%02x:%02x ###########\n",macEntry.mac.octet[0],macEntry.mac.octet[1]
		//	,macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

		macEntry.port_idx=RTK_RG_PORT_CPU;
		macEntry.wlan_device_idx=FAIL;
		macEntry.static_entry=1;
		macEntry.fid=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].fid;
		macEntry.vlan_id=rg_db.systemGlobal.initParam.fwdVLAN_CPU;
		(pf.rtk_rg_macEntry_add)(&macEntry,&entry_idx);
	}

#endif//end of #ifdef CONFIG_DUALBAND_CONCURRENT

/*
	//just for debug
	{
		rtk_portmask_t mirroredRxPortmask;
		rtk_portmask_t mirroredTxPortmask;
		mirroredRxPortmask.bits[0] =(1<<RTK_RG_PORT_CPU);
		mirroredTxPortmask.bits[0] =(1<<RTK_RG_PORT_CPU);
		ASSERT_EQ(rtk_mirror_portBased_set(RTK_RG_PORT0, &mirroredRxPortmask, &mirroredTxPortmask),SUCCESS);
	}
*/
#endif //end of #if defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION)

#endif //end of #if defined(CONFIG_RG_RTL9602C_SERIES)

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	_rtk_rg_check_wlan_device_exist_or_not();

	for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
	{
		//20140716LUKE:default CPU VLAN should contains all Wlan0's device
		if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
		{
			assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0, i, rg_db.systemGlobal.initParam.fwdVLAN_CPU));
			rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].wlan0DevMask|=(0x1<<i);
			rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].wlan0UntagMask=0xffffffff; //all untag
			rg_db.systemGlobal.wlan0SourceAddrLearningLimitNumber[i]=DEF_SOFTWARE_LEARNING_LIMIT;
		}
	}
#endif
#if !defined(CONFIG_RG_G3_SERIES)
#if defined(__KERNEL__)

	#if defined(CONFIG_RG_RTL9600_SERIES)
	{
		int ret,data;

		//Enable PON port bandwidth control
		data = 1;
		if( (ret=reg_field_write(APOLLOMP_RSVD_EGR_OUTQr, APOLLOMP_PON_EGR_RATE_CTRL_ENf, (uint32 *)&data)) != RT_ERR_OK)
			WARNING("Configure Apollo MP RSVD_EGR_OUTQ control register PON_EGR_RATE_CTRL_EN field failed!");

		//Enable PON port bandwidth control
		data = 0xd;
		if( (ret=reg_field_write(APOLLOMP_INBW_BOUNDr, APOLLOMP_HBOUNDf, (uint32 *)&data)) != RT_ERR_OK)
			WARNING("Configure Apollo MP INBW_BOUND control register HBOUND field failed!");
	}
	#endif
#endif
#endif

	//BC, IPv6 MC rate limit
	//TRACE("rg_db.systemGlobal.BCRateLimitPortMask=%d", rg_db.systemGlobal.BCRateLimitPortMask);
	//rg_db.systemGlobal.BCRateLimitPortMask = 0x0;
	rg_db.systemGlobal.BCRateLimitShareMeterIdx = -1; //disabled
	//TRACE("rg_db.systemGlobal.BCByteCount=%d", rg_db.systemGlobal.BCByteCount); //not set /proc/rg
	//rg_db.systemGlobal.BCByteCount = 0;
	//TRACE("rg_db.systemGlobal.IPv6MCRateLimitPortMask=%d", rg_db.systemGlobal.IPv6MCRateLimitPortMask);
	//rg_db.systemGlobal.IPv6MCRateLimitPortMask = 0x0;
	rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx = -1;
	//TRACE("rg_db.systemGlobal.IPv6MCByteCount=%d", rg_db.systemGlobal.IPv6MCByteCount);
	//rg_db.systemGlobal.IPv6MCByteCount = 0;
	//TRACE("rg_db.systemGlobal.IPv4MCRateLimitPortMask=%d", rg_db.systemGlobal.IPv4MCRateLimitPortMask);
	//rg_db.systemGlobal.IPv4MCRateLimitPortMask = 0x0;
	rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx = -1;
	//TRACE("rg_db.systemGlobal.IPv4MCByteCount=%d", rg_db.systemGlobal.IPv4MCByteCount);
	//rg_db.systemGlobal.IPv4MCByteCount = 0;
	//TRACE("rg_db.systemGlobal.unKnownDARateLimitPortMask=%d", rg_db.systemGlobal.unKnownDARateLimitPortMask);
	//rg_db.systemGlobal.unKnownDARateLimitPortMask = 0x0;
	rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx = -1;
	//TRACE("rg_db.systemGlobal.unKnownDAByteCount=%d", rg_db.systemGlobal.unKnownDAByteCount);
	//rg_db.systemGlobal.unKnownDAByteCount = 0;
	rg_db.systemGlobal.unlearnedSALimit=RG_INIT_DEFAULT_unlearnedSA_rate_limit;
	rg_db.systemGlobal.unlearnedSAJiffies=jiffies;

	rg_db.systemGlobal.overMTURateLimitShareMeterIdx = -1;

	rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx = -1;

	for(i=0;i<RTK_RG_MAX_DOS_RATE_LIMIT_TABLE_SIZE;i++)
		rg_db.systemGlobal.dosRateLimit[i].shareMeterIdx = RG_INIT_DEFAULT_dos_rate_limit;

	rg_db.systemGlobal.igmpRateLimitShareMeterIdx = -1;

	rg_db.systemGlobal.dhcpRateLimitShareMeterIdx = -1;

	rg_db.systemGlobal.synRateLimitShareMeterIdx = -1;

	//20160817LUKE: turn on TCP swap fin and delete rst connection functionality.
	rg_db.systemGlobal.tcpSwapFinDelRst = RG_INIT_DEFAULT_tcp_swap_fin_del_rst;


	//igmp report ingress filter portmask, default enabled all port permit
	rg_db.systemGlobal.igmpReportIngressPortmask= RTK_RG_ALL_PORTMASK;

	//igmp report egress filter portmask, default enabled all port permit
	rg_db.systemGlobal.igmpReportPortmask= RTK_RG_ALL_PORTMASK;

	//igmp leave egress filter portmask, default enabled all port permit
	rg_db.systemGlobal.igmpLeavePortmask= RTK_RG_ALL_PORTMASK;

	rg_db.systemGlobal.igmpProxyOnly2Wifi = 0;

	//igmp version support , default all enable
	rg_db.systemGlobal.multicastVersionSupport = (RG_MC_IGMPV1|RG_MC_IGMPV2|RG_MC_IGMPV3|RG_MC_MLDV1|RG_MC_MLDV2) ;

	//igmp query filter portmask, default enabled all port permit
	rg_db.systemGlobal.igmpMldQueryPortmask= RTK_RG_ALL_PORTMASK;

	rtl_mCastModuleArray[rg_db.systemGlobal.nicIgmpModuleIndex].enableFastLeave=0;


	// set default short timeout = 2secs
	_rtk_rg_tcpShortTimeoutHouseKeep_set(2*CONFIG_HZ);

	//trap all IPv6 link local packet to protocal-stack
	//assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_IPV6_LINK_LOCAL_TRAP, NULL));

	//sync proc/rg/hwnat, default enable
	_rtk_rg_hwnatACLManipulate(ENABLED);

	rg_db.systemGlobal.fwdStatistic=0;
	memset(&rg_db.systemGlobal.statistic,0,sizeof(rg_db.systemGlobal.statistic));
	rg_db.systemGlobal.fwdStatistic=1;

	//Enable fwd statistic by default
	if(rg_db.systemGlobal.stpBlockingPortmask.portmask)
	{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_STPBLOCKING);
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_STPBLOCKING,NULL);

	}
	else
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_STPBLOCKING);



#ifdef CONFIG_GPON_FEATURE
	if((init_param!=NULL)&&(init_param->wanPortGponMode==1))
	{
		rg_db.systemGlobal.ponPortUnmatchCfDrop=1;
		rtk_classify_unmatchAction_set(CLASSIFY_UNMATCH_PERMIT_WITHOUT_PON);
	}
	else
	{
		//TRACE("rg_db.systemGlobal.ponPortUnmatchCfDrop=%d", rg_db.systemGlobal.ponPortUnmatchCfDrop);
		//rg_db.systemGlobal.ponPortUnmatchCfDrop=0;
		rtk_classify_unmatchAction_set(CLASSIFY_UNMATCH_PERMIT);
	}
#else
	//TRACE("rg_db.systemGlobal.ponPortUnmatchCfDrop=%d", rg_db.systemGlobal.ponPortUnmatchCfDrop);
	//rg_db.systemGlobal.ponPortUnmatchCfDrop=0;
	rtk_classify_unmatchAction_set(CLASSIFY_UNMATCH_PERMIT);
#endif

	//20151007LUKE: initialize dslite multicast table
	for(i=0;i<MAX_DSLITEMC_SW_TABLE_SIZE;i++){
		rtk_l34_dsliteMc_entry_t dsliteMcEntry;
		dsliteMcEntry.index=i;
		memset(&dsliteMcEntry.ipUPrefix64,0,sizeof(rtk_ipv6_addr_t));
		memset(&dsliteMcEntry.ipUPrefix64Mask,0xff,sizeof(rtk_ipv6_addr_t));
		memset(&dsliteMcEntry.ipMPrefix64,0,sizeof(rtk_ipv6_addr_t));
		memset(&dsliteMcEntry.ipMPrefix64Mask,0xff,sizeof(rtk_ipv6_addr_t));
		//ASSERT_EQ(rtk_rg_apollo_dsliteMcTable_set(&dsliteMcEntry),RT_ERR_RG_OK);
		ASSERT_EQ(RTK_L34_DSLITEMULTICAST_SET(&dsliteMcEntry),RT_ERR_RG_OK);
	}

	//software unmatch trap to PS
	rg_db.systemGlobal.dsliteControlSet[L34_DSLITE_CTRL_MC_PREFIX_UNMATCH]=RTK_L34_DSLITE_UNMATCH_ACT_TRAP;
	//hardware unmatch trap to romeDriver
	rtk_l34_dsliteControl_set(L34_DSLITE_CTRL_MC_PREFIX_UNMATCH, RTK_L34_DSLITE_UNMATCH_ACT_TRAP);

#if defined(CONFIG_RG_G3_SERIES)
	rg_db.systemGlobal.flow_meter_mib_conf_dependence = RTK_RG_ENABLED; // the mib configuration depends on meter configuration for every flow
#endif

	rg_db.systemGlobal.rgInit = 1;
	DEBUG("END!!!!!!!!!");
    return (RT_ERR_RG_OK);
}


rtk_rg_err_code_t rtk_rg_apollo_initParam_set(rtk_rg_initParams_t *init_param)
{
	int32 ret;

	//Check switch chip revision
	ASSERT_EQ(_rtk_rg_switch_version_get(&rg_kernel.apolloChipId,&rg_kernel.apolloRev,&rg_kernel.apolloSubtype),RT_ERR_OK);

	//before start, set init_state to avoid packet receive in fwdEngine may cause kernel panic
    _rtk_rg_set_initState(RTK_RG_DURING_INIT);
	ret=_rtk_rg_initParam_set(init_param);
	//reset state after init when success
	if(ret==RT_ERR_RG_OK)
	{
		_rtk_rg_set_initState(RTK_RG_INIT_FINISHED);
		return (RT_ERR_RG_OK);
	}
	else
		RETURN_ERR(ret);

}

int _rtk_rg_portmask_translator(rtk_rg_portmask_t in_pmask, rtk_portmask_t* out_mac_pmask, rtk_portmask_t* out_ext_pmask){
	int i;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rtk_portmask_t tmp_ext_pmask;
#else
	int EXT_CPU_PORT_flag = DISABLED;
#endif

	if(out_mac_pmask==NULL||out_ext_pmask==NULL )
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);

	bzero(out_mac_pmask,sizeof(rtk_portmask_t));
	bzero(out_ext_pmask,sizeof(rtk_portmask_t));

	//set mac portmask
	for(i=0;i<RTK_RG_MAC_PORT_MAX;i++){
#if defined(CONFIG_RG_G3_SERIES) && defined(CONFIG_RG_G3_WAN_PORT_INDEX)
		if((i==AAL_LPORT_ETH_NI7) && (in_pmask.portmask & (1<<i))){
			out_mac_pmask->bits[0] |= (1<<CONFIG_RG_G3_WAN_PORT_INDEX);
		}
#endif
		if(RG_INVALID_MAC_PORT(i)) continue;
		if(in_pmask.portmask & (1<<i)){
			out_mac_pmask->bits[0] |= (1<<i);
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// in flow based architecture, the extension ports and physical cpu ports are independent
	// [9607C] set ext portmask: Bit[5:0]: EXT 5-0 in MAC9; Bit[11:6]: EXT 11-6 in MAC10; Bit[17:12]: EXT 17-12 in MAC7
	// [G3] set ext portmask: Bit[3:0]: EXT 3~0
	bzero(&tmp_ext_pmask,sizeof(rtk_portmask_t));
	for(i=0;i<RTK_RG_MAX_EXT_PORT;i++){
		if(in_pmask.portmask & (1<<(i+RTK_RG_EXT_BASED_PORT))){
			tmp_ext_pmask.bits[0] |= (1<<i);
		}
	}
	//In order to be forward compatible, ext0 stands for all wifi device of master cpu, and ext1 stands for all wifi device of slave cpu.
	tmp_ext_pmask.bits[0] &= ((0x1<<(RTK_RG_EXT_PORT0-RTK_RG_EXT_BASED_PORT)) | (0x1<<(RTK_RG_EXT_PORT1-RTK_RG_EXT_BASED_PORT)));
	if(tmp_ext_pmask.bits[0] & (0x1<<(RTK_RG_EXT_PORT0-RTK_RG_EXT_BASED_PORT)))
		out_ext_pmask->bits[0] |= RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK;
	if(tmp_ext_pmask.bits[0] & (0x1<<(RTK_RG_EXT_PORT1-RTK_RG_EXT_BASED_PORT)))
		out_ext_pmask->bits[0] |= RTK_RG_ALL_VLAN_SLAVE_EXT_PORTMASK;

	DEBUG("PortMask 0x%x: physical port is 0x%x, extension port is 0x%x", in_pmask, out_mac_pmask->bits[0], out_ext_pmask->bits[0]);	// remove me if work well
#else
	//set ext portmask
	for(i=0;i<RTK_RG_MAX_EXT_PORT;i++){
		if(RG_INVALID_MAC_PORT(i)) continue;
		if(in_pmask.portmask & (1<<(i+RTK_RG_MAC_PORT_MAX))){
			out_ext_pmask->bits[0] |= (1<<(i+1));
			EXT_CPU_PORT_flag = ENABLED;//ENABLE MAC_CPU_PORT if any EXT_PORT is ENABLED
		}
	}

	if(EXT_CPU_PORT_flag==ENABLED)
		out_mac_pmask->bits[0] |= (1<<RTK_RG_MAC_PORT_CPU);

	if(in_pmask.portmask & (1<<RTK_RG_MAC_PORT_CPU)){
		out_ext_pmask->bits[0] |= 1; //enable extCPU port
	}
#endif

	return (RT_ERR_RG_OK);

}


//LAN Interface/Static Route/IPv4 DHCP Server
int _rtk_rg_softwareArpTableLookUp(unsigned short routingIdx, ipaddr_t ipAddr, rtk_rg_arp_linkList_t **pSoftwareArpEntry, int resetIdleTime)
{
	rtk_rg_arp_linkList_t *pArpEntry;

	if(list_empty(&rg_db.softwareArpTableHead[ipAddr&0xff]))
		goto NOT_FOUND;

	list_for_each_entry(pArpEntry,&rg_db.softwareArpTableHead[ipAddr&0xff],arp_list)
	{
		if(rg_db.arp[pArpEntry->idx].routingIdx==routingIdx && rg_db.arp[pArpEntry->idx].ipv4Addr==ipAddr)
		{
			TRACE("Found! SW ARP[%d] is match with %x",pArpEntry->idx,ipAddr);
			//Reset idle time
			//20141009LUKE: update idleSecs and sendReqCount
			if(resetIdleTime)
			{
				rg_db.arp[pArpEntry->idx].idleSecs=0;
				rg_db.arp[pArpEntry->idx].sendReqCount=0;
			}
			*pSoftwareArpEntry=pArpEntry;
			return (RT_ERR_RG_OK);
		}
	}

NOT_FOUND:
	//not found
	*pSoftwareArpEntry=NULL;
	return (RT_ERR_RG_OK);
}

int _rtk_rg_softwareArpTableAdd(unsigned short routingIdx, ipaddr_t ipv4Addr, int l2Idx, int staticEntry, int *swArpIdx)
{
	rtk_rg_arp_linkList_t *pNewArpEntry;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	int retval=0, i, nxthopRefFlag;
	rtk_l2_addr_table_t asic_l2_entry;
#endif

	//Check if we have not-used free arp list
	if(list_empty(&rg_db.softwareArpFreeListHead))
	{
		DEBUG("all free SW ARP list are allocated...");
		//Clear all recently not used entries
		if(_rtk_rg_freeRecentlyNotUsedArpList()!=RT_ERR_RG_OK)
		{
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
			if(rg_db.lut[l2Idx].valid)
			{
				if(rg_db.lut[l2Idx].arp_refCount==0)
				{
					nxthopRefFlag = 0;
					for(i=0; i<MAX_NEXTHOP_SW_TABLE_SIZE; i++)
					{
						if(l2Idx==rg_db.nexthop[i].rtk_nexthop.nhIdx)
						{
							nxthopRefFlag = 1;
							break;
						}
					}

					if(nxthopRefFlag==0)
					{
						//Sync to LUT
						if(rg_db.lut[l2Idx].valid && rg_db.lut[l2Idx].rtk_lut.entryType==RTK_LUT_L2UC)
						{
							memcpy(&asic_l2_entry, &rg_db.lut[l2Idx].rtk_lut, sizeof(rtk_l2_addr_table_t));
							if((asic_l2_entry.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_ARP_USED)!=0
								&& (asic_l2_entry.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_STATIC)==0)
							{
								asic_l2_entry.entry.l2UcEntry.flags &= (~RTK_L2_UCAST_FLAG_ARP_USED);
								// [Call RTK_L2_ADDR_ADD directly] disable arp used
								retval = RTK_L2_ADDR_ADD(&asic_l2_entry.entry.l2UcEntry);
								ASSERT_EQ(retval,RT_ERR_OK);
							}
						}
					}
				}
			}
#endif
			return(RT_ERR_RG_FAILED);
		}
	}

	//Get one from free list
	pNewArpEntry=list_first_entry(&rg_db.softwareArpFreeListHead, rtk_rg_arp_linkList_t, arp_list);
	list_del_init(&pNewArpEntry->arp_list);

	//DEBUG("the free ARP %p idx is %d, routing=%d",pNewArpEntry,pNewArpEntry->idx,pNewArpEntry->routingIdx);

	//Setup ARP information
	rg_db.arp[pNewArpEntry->idx].rtk_arp.nhIdx=l2Idx;
	rg_db.arp[pNewArpEntry->idx].rtk_arp.valid=1;
	rg_db.arp[pNewArpEntry->idx].ipv4Addr=ipv4Addr;
	rg_db.arp[pNewArpEntry->idx].staticEntry=staticEntry;
	rg_db.arp[pNewArpEntry->idx].idleSecs=0;
	rg_db.arp[pNewArpEntry->idx].sendReqCount=0;
	rg_db.arp[pNewArpEntry->idx].routingIdx=routingIdx;
	if(swArpIdx)*swArpIdx=pNewArpEntry->idx;

	//DEBUG("the arp[%d] has ip=%x, static=%d, nhIdx=%d",pNewArpEntry->idx,rg_db.arp[pNewArpEntry->idx].ipv4Addr,rg_db.arp[pNewArpEntry->idx].staticEntry,rg_db.arp[pNewArpEntry->idx].rtk_arp.nhIdx);

	//Add to hash head list
	list_add(&pNewArpEntry->arp_list,&rg_db.softwareArpTableHead[ipv4Addr&0xff]);

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	if(rg_db.lut[l2Idx].valid) rg_db.lut[l2Idx].arp_refCount++;
#endif

	return (RT_ERR_RG_OK);
}

int _rtk_rg_softwareArpTableDel(rtk_rg_arp_linkList_t *pDelArpEntry)
{
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	int retval=0, i, l2Idx, nxthopRefFlag;
	rtk_l2_addr_table_t asic_l2_entry;
#endif
	uint32 arpL2Idx = rg_db.arp[pDelArpEntry->idx].rtk_arp.nhIdx;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Delete flow entry
	ASSERT_EQ(_rtk_rg_flow_del_by_arpIdx(pDelArpEntry->idx), RT_ERR_RG_OK);
#endif

	//Delete from head list
	list_del_init(&pDelArpEntry->arp_list);

	//Clear data
	//20170307LUKE: decrease count when we delete permited ARP.
	if(rg_db.arp[pDelArpEntry->idx].permit_for_l34_forward==WanAccessLimitPermit)
		if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_PORTMASK)
			atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
	memset(&rg_db.arp[pDelArpEntry->idx],0,sizeof(rtk_rg_table_arp_t));

	//Add back to free list
	list_add(&pDelArpEntry->arp_list,&rg_db.softwareArpFreeListHead);

	//20180111LUKE: remove l34permit when arp is invalided.
	_rtk_rg_disablePortmaskPermitedLut(arpL2Idx);
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	if(rg_db.lut[arpL2Idx].valid)
	{
		if(rg_db.lut[arpL2Idx].arp_refCount>0)
			rg_db.lut[arpL2Idx].arp_refCount--;
		if(rg_db.lut[arpL2Idx].arp_refCount==0)
		{
			nxthopRefFlag = 0;
			for(i=0; i<MAX_NEXTHOP_SW_TABLE_SIZE; i++)
			{
				if(arpL2Idx==rg_db.nexthop[i].rtk_nexthop.nhIdx)
				{
					nxthopRefFlag = 1;
					break;
				}
			}

			if(nxthopRefFlag==0)
			{
				rtk_rg_lut_linkList_t *pLutList, *pNextLutList;
				uint32 lutGroupIdx = rg_db.lut[arpL2Idx].lutGroupIdx;

				if(lutGroupIdx<MAX_LUT_HW_TABLE_SIZE){
					list_for_each_entry_safe(pLutList, pNextLutList, &rg_db.lutGroupTableHead[lutGroupIdx], lut_list)	//just return the first entry right behind of head
					{
						//Sync to LUT
						l2Idx = pLutList->idx;
						if(rg_db.lut[l2Idx].valid && rg_db.lut[l2Idx].rtk_lut.entryType==RTK_LUT_L2UC)
						{
							memcpy(&asic_l2_entry, &rg_db.lut[l2Idx].rtk_lut, sizeof(rtk_l2_addr_table_t));
							if((asic_l2_entry.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_ARP_USED)!=0
								&& (asic_l2_entry.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_STATIC)==0)
							{
								asic_l2_entry.entry.l2UcEntry.flags &= (~RTK_L2_UCAST_FLAG_ARP_USED);
								// [Call RTK_L2_ADDR_ADD directly] disable arp used
								retval = RTK_L2_ADDR_ADD(&asic_l2_entry.entry.l2UcEntry);
								ASSERT_EQ(retval,RT_ERR_OK);
							}
						}
					}
				}else
					DEBUG("lutGroupIdx is %d!",lutGroupIdx);
			}
		}
	}
#endif

	return (RT_ERR_RG_OK);
}

int _rtk_rg_freeRecentlyNotUsedArpList(void)
{
	int count=0;
	int i;
	rtk_rg_arp_linkList_t *pArpEntry,*pNextEntry;

	for(i=0;i<MAX_ARP_SW_TABLE_HEAD;i++)
	{
		list_for_each_entry_safe(pArpEntry,pNextEntry,&rg_db.softwareArpTableHead[i],arp_list)
		{
			if(rg_db.arp[pArpEntry->idx].staticEntry==0 && rg_db.arp[pArpEntry->idx].idleSecs>=ARP_SW_TABLE_THRESHOLD)	//not be accessed in ARP_SW_TABLE_THRESHOLD time
			{
				_rtk_rg_softwareArpTableDel(pArpEntry);
				count++;
			}
		}
	}

	if(count==0)		//no recently not used ARP entry....
	{
		TABLE_FULL("There is no recently non-used sw ARP entry");
		return(RT_ERR_RG_FAILED);
	}

	return (RT_ERR_RG_OK);
}


int32 _rtk_rg_arpRearrange(rtk_rg_routing_arpInfo_t *newAddingEntry, ipaddr_t newIpAddr, int routingARPNum)
{
#if defined(CONFIG_RG_RTL9600_SERIES)

	unsigned int i,j,k,arpNum=0,lanArpTotal=0,wanArpTotal=0,arpStart=0,inRangeIdx=0,routingIdx=0,prevRoutingIdx=0;
	ipaddr_t comparingArpIP=0;

	//init
	bzero(rg_db.tempArpTable,sizeof(rtk_rg_table_arp_t)*MAX_ARP_HW_TABLE_SIZE);
	bzero(rg_db.tempL3Table,sizeof(rtk_l34_routing_entry_t)*MAX_L3_SW_TABLE_SIZE);
	bzero(rg_db.arpTableCopied,sizeof(unsigned char)*MAX_ARP_HW_TABLE_SIZE);

	// TODO:We need to stop the packets flow from here!!

	//Count the ARP number all routing entries needed, and caculate each entry's ARP Start and End index
	for(i=0;i<routingARPNum;i++)
	{
		//newAdding one has not add to routing table yet
		arpNum=0x1<<rg_db.p_tempRoutingArpInfoArray[i].bitNum;
		routingIdx=rg_db.p_tempRoutingArpInfoArray[i].routingIdx;
		//DEBUG("i=%d, arpNum is %d, routingIdx is %d",i,arpNum,routingIdx);

		if(rg_db.l3[routingIdx].rtk_l3.valid==0)
			comparingArpIP=newIpAddr;
		else
			comparingArpIP=rg_db.l3[routingIdx].rtk_l3.ipAddr;

		for(j=0;j<i;j++)
		{
			//DEBUG("j is %d",j);
			prevRoutingIdx=rg_db.p_tempRoutingArpInfoArray[j].routingIdx;
			if(rg_db.l3[prevRoutingIdx].rtk_l3.valid)
			{
				if((comparingArpIP&rg_db.l3[prevRoutingIdx].netmask) == rg_db.l3[prevRoutingIdx].rtk_l3.ipAddr)
				{
					//DEBUG("HIT!!comparingArpIP(%x)&rg_db.l3[%d].netmask=%x, rg_db.l3[%d].rtk_l3.ipAddr=%x",comparingArpIP,prevRoutingIdx,comparingArpIP&rg_db.l3[prevRoutingIdx].netmask,prevRoutingIdx,rg_db.l3[prevRoutingIdx].rtk_l3.ipAddr);
					break;
				}
			}
			else	//the routing entry has not added to table yet, therefore it must be the newAddingEntry
			{
				if((comparingArpIP&(~newAddingEntry->notMask)) == (newIpAddr&(~newAddingEntry->notMask)))
				{
					//DEBUG("HIT!!comparingArpIP(%x)&(~newAddingEntry.notMask)=%x, newIpAddr(%x)&(~newAddingEntry.notMask))=%x",comparingArpIP,comparingArpIP&(~newAddingEntry->notMask),newIpAddr,newIpAddr&(~newAddingEntry->notMask));
					break;
				}
			}
		}

		if(j==i)//unmatch any IP-range before, create new IP-range
		{
//DEBUG("add new IP-range");
			if(rg_db.p_tempRoutingArpInfoArray[i].isLan)
				lanArpTotal+=arpNum;
			else
				wanArpTotal+=arpNum;
			rg_db.p_tempRoutingArpInfoArray[i].arpStart=arpStart;
			arpStart+=(arpNum>>0x2);
			rg_db.p_tempRoutingArpInfoArray[i].arpEnd=arpStart-1;	//each ARP index has four entries
		}
		else if(rg_db.p_tempRoutingArpInfoArray[i].bitNum==rg_db.p_tempRoutingArpInfoArray[j].bitNum)
		{
//DEBUG("in the same IP-range");
			//no matter IVL or SVL, two interface has same subnet is prohibited here!!
			RETURN_ERR(RT_ERR_RG_INTF_OVERLAP_AND_SAME_SUBNET);
#if 0
			if(rg_db.vlan[rg_db.p_tempRoutingVlanInfoArray[i]].fidMode==VLAN_FID_IVL ||
				rg_db.vlan[rg_db.p_tempRoutingVlanInfoArray[j]].fidMode==VLAN_FID_IVL)		//IVL interfaces can not overlap their ip subnet, otherwise routing table will always hit first add one
				RETURN_ERR(RT_ERR_RG_VLAN_BASED_OVERLAP_SUBNET);

			//the Ith entry is in the Jth entry's IP-range and Ith entry is as big as Jth entry
			rg_db.p_tempRoutingArpInfoArray[i].arpStart=rg_db.p_tempRoutingArpInfoArray[j].arpStart;
			rg_db.p_tempRoutingArpInfoArray[i].arpEnd=rg_db.p_tempRoutingArpInfoArray[j].arpEnd;
#endif
		}
		else
		{
//DEBUG("the %d(%d) is inside %d(%d) IP-range",i,rg_db.p_tempRoutingArpInfoArray[i].bitNum,j,rg_db.p_tempRoutingArpInfoArray[j].bitNum);
			if(rg_db.vlan[rg_db.p_tempRoutingVlanInfoArray[i]].fidMode==VLAN_FID_IVL ||
				rg_db.vlan[rg_db.p_tempRoutingVlanInfoArray[j]].fidMode==VLAN_FID_IVL)		//IVL interfaces can not overlap their ip subnet, otherwise routing table will always hit first add one
				RETURN_ERR(RT_ERR_RG_VLAN_BASED_OVERLAP_SUBNET);

			//the Ith entry is inside the Jth entry's IP-range, so the Jth ARP start is referenced
			inRangeIdx=(comparingArpIP&rg_db.p_tempRoutingArpInfoArray[j].notMask)>>rg_db.p_tempRoutingArpInfoArray[i].bitNum;
			rg_db.p_tempRoutingArpInfoArray[i].arpStart=rg_db.p_tempRoutingArpInfoArray[j].arpStart+(inRangeIdx<<(rg_db.p_tempRoutingArpInfoArray[i].bitNum-2)); //each ARP index has four entries
			rg_db.p_tempRoutingArpInfoArray[i].arpEnd=rg_db.p_tempRoutingArpInfoArray[i].arpStart+(arpNum>>0x2)-1;
		}

		//Check ARP number is over hardware limitation or not
		//DEBUG("Lan ARP total is %d, Wan ARP total is %d",lanArpTotal,wanArpTotal);
		if(newIpAddr!=0)	//in deleting, these check is not necessary
		{
			if((newAddingEntry->isLan && lanArpTotal>rg_kernel.arp_number_for_LAN) ||
				(newAddingEntry->isLan==0 && wanArpTotal>rg_kernel.arp_number_for_WAN))
			{
				//DEBUG("The hardware ARP table is not enough for the new routing entry...add to sw table!");
				return (RT_ERR_RG_ADD_ARP_TO_SW_TABLE);	//add to sw table when needed
				//RETURN_ERR(RT_ERR_RG_ARP_FULL);
			}
		}
		//DEBUG("add to hardware ARP table for the new routing entry!");

		//Return the newArpRouting's ARP Start and End
		if(newIpAddr!=0 && rg_db.p_tempRoutingArpInfoArray[i].intfIdx==newAddingEntry->intfIdx)
		{
			newAddingEntry->arpStart=rg_db.p_tempRoutingArpInfoArray[i].arpStart;
			newAddingEntry->arpEnd=rg_db.p_tempRoutingArpInfoArray[i].arpEnd;
		}

		//Check if ARP rearrangement is needed
		j=rg_db.p_tempRoutingArpInfoArray[i].arpStart<<0x2;
		if(rg_db.l3[routingIdx].rtk_l3.valid==1)
		{
			//Keep routing table entry in tempRouting table
			memcpy(&rg_db.tempL3Table[routingIdx],&rg_db.l3[routingIdx].rtk_l3,sizeof(rtk_l34_routing_entry_t));
//DEBUG("j = %d, tmp start %d, routing start %d, arpNUm= %d",j,rg_db.p_tempRoutingArpInfoArray[i].arpStart,rg_db.l3[routingIdx].rtk_l3.arpStart,arpNum);
			if(rg_db.p_tempRoutingArpInfoArray[i].arpStart != rg_db.l3[routingIdx].rtk_l3.arpStart)
			{
//DEBUG("rearrange!!");
				//Rearrange old ARP records in tempArpTable
				for(k=rg_db.l3[routingIdx].rtk_l3.arpStart<<0x2;k<((rg_db.l3[routingIdx].rtk_l3.arpEnd+1)<<0x2);k++)
					memcpy(&rg_db.tempArpTable[j++],&rg_db.arp[k],sizeof(rtk_rg_table_arp_t));

				//Modify routing table
				rg_db.tempL3Table[routingIdx].arpStart=rg_db.p_tempRoutingArpInfoArray[i].arpStart;
				rg_db.tempL3Table[routingIdx].arpEnd=rg_db.p_tempRoutingArpInfoArray[i].arpEnd;
			}
			else if(rg_db.arpTableCopied[j] == 0)
			{
//DEBUG("no..i am not moving..");
				memcpy(&rg_db.tempArpTable[j],&rg_db.arp[j],sizeof(rtk_rg_table_arp_t)*arpNum);
			}

			//Painted the arpTableCopied for recognize the ARP entries copied or not
			memset(&rg_db.arpTableCopied[rg_db.p_tempRoutingArpInfoArray[i].arpStart<<0x2],1,sizeof(unsigned char)*arpNum);
		}
	}

	//Write the tempRouting table to hardware L3 table
	for(i=0;i<MAX_L3_SW_TABLE_SIZE;i++)
	{
		//Only the modified routing entry need to be overrided
		if(rg_db.tempL3Table[i].valid==1)
			ASSERT_EQ(RTK_L34_ROUTINGTABLE_SET(i,&rg_db.tempL3Table[i]),RT_ERR_OK);
	}
	//Write the tempArp table to hardware ARP table
	for(i=0;i<MAX_ARP_HW_TABLE_SIZE;i++)
	{
		/*DEBUG("i = %d, valid = %d, l3idx = %d, nhidx= %d",i,
			rg_db.tempArpTable[i].rtk_arp.valid,
			rg_db.tempArpTable[i].rtk_arp.index,
			rg_db.tempArpTable[i].rtk_arp.nhIdx);*/
		ASSERT_EQ(RTK_L34_ARPTABLE_SET(i,&rg_db.tempArpTable[i].rtk_arp),RT_ERR_OK);
	}
	// TODO:We need to restart the packets flow from here!!
//DEBUG("after arp rearrange!!");
	return (RT_ERR_RG_OK);
#elif defined(CONFIG_RG_RTL9602C_SERIES)
	FIXME("9602BVB don't need to rearrange ARP");
	return (RT_ERR_RG_OK);

#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	return (RT_ERR_RG_OK);

#endif
}

int32 _rtk_rg_addArpRoutingArray(rtk_rg_routing_arpInfo_t *newAddingEntry, ipaddr_t newIpAddr, int intfVlanId)
{
	unsigned int ret,i=0;
	rtk_rg_routing_arpInfo_t *pTemporary;
	int *pVlanTemporary;

	//init
	bzero(rg_db.p_tempRoutingArpInfoArray,sizeof(rtk_rg_routing_arpInfo_t)*MAX_L3_SW_TABLE_SIZE);
	bzero(rg_db.p_tempRoutingVlanInfoArray,sizeof(int)*MAX_L3_SW_TABLE_SIZE);

	//Add New entry with other old ARP routing entries in routingArpInfoArray to tempRoutingArpInfoArray by the order of IP-range size.
	//The software ARP routing will NOT add here, the new entry will add first since we will decide it can be added in hw or not in _rtk_rg_arpRearrange.
	for(i=0;i<rg_db.routingArpInfoNum;i++)
	{
		if(newAddingEntry->bitNum>rg_db.p_routingArpInfoArray[i].bitNum)
		{
			memcpy(&rg_db.p_tempRoutingArpInfoArray[i],newAddingEntry,sizeof(rtk_rg_routing_arpInfo_t));
			memcpy(&rg_db.p_tempRoutingArpInfoArray[i+1],&rg_db.p_routingArpInfoArray[i],sizeof(rtk_rg_routing_arpInfo_t)*(rg_db.routingArpInfoNum-i));

			rg_db.p_tempRoutingVlanInfoArray[i]=intfVlanId;
			memcpy(&rg_db.p_tempRoutingVlanInfoArray[i+1],&rg_db.p_routingVlanInfoArray[i],sizeof(int)*(rg_db.routingArpInfoNum-i));
			break;
		}
		else
		{
			memcpy(&rg_db.p_tempRoutingArpInfoArray[i],&rg_db.p_routingArpInfoArray[i],sizeof(rtk_rg_routing_arpInfo_t));
			rg_db.p_tempRoutingVlanInfoArray[i]=rg_db.p_routingVlanInfoArray[i];
		}
	}
	//the newAdding is the smallest one, so add it at the end of array
	if(i==rg_db.routingArpInfoNum)
	{
		memcpy(&rg_db.p_tempRoutingArpInfoArray[i],newAddingEntry,sizeof(rtk_rg_routing_arpInfo_t));
		rg_db.p_tempRoutingVlanInfoArray[i]=intfVlanId;
	}

	//Count and check ARP table distribution
	ret=_rtk_rg_arpRearrange(newAddingEntry,newIpAddr,rg_db.routingArpInfoNum+1);
	if(ret!=RT_ERR_RG_OK)
		return ret;

	//Global variable modification
	rg_db.routingArpInfoNum++;
	pTemporary=rg_db.p_routingArpInfoArray;
	rg_db.p_routingArpInfoArray=rg_db.p_tempRoutingArpInfoArray;
	rg_db.p_tempRoutingArpInfoArray=pTemporary;

	pVlanTemporary=rg_db.p_routingVlanInfoArray;
	rg_db.p_routingVlanInfoArray=rg_db.p_tempRoutingVlanInfoArray;
	rg_db.p_tempRoutingVlanInfoArray=pVlanTemporary;

	return (RT_ERR_RG_OK);
}
#if defined(CONFIG_RG_RTL9600_SERIES)
static rtk_rg_routing_linkList_t swRoutingList[MAX_L3_HW_TABLE_SIZE];
#endif
int32 _rtk_rg_convertSwArpToHwTable(rtk_rg_routing_arpInfo_t *deletingEntry)
{
#if defined(CONFIG_RG_RTL9600_SERIES)
	int ret,i=0,arpNum,bitNum,arpIdx,intfVlanId;
	uint8 inserted=0;

	struct list_head swRoutingHead;

	rtk_rg_routing_linkList_t *pSwRoutingList;

	rtk_rg_arp_linkList_t *pSwArpInfo,*pNextSwArpInfo;
	rtk_rg_arpEntry_t arpEntry;
	rtk_rg_routing_arpInfo_t newAddingRoute;
	ipaddr_t newIpAddr;
	rtk_l34_routing_entry_t rtEntry;

	//20140312LUKE:if this time we just set the same interface twice, bypass this convert function!
	if(rg_db.systemGlobal.intfIdxForReset!=-1)
		return (RT_ERR_RG_OK);

	//init
	INIT_LIST_HEAD(&swRoutingHead);
	for(i=0;i<MAX_L3_HW_TABLE_SIZE;i++)
	{
		INIT_LIST_HEAD(&swRoutingList[i].route_list);
		swRoutingList[i].idx=i;
		swRoutingList[i].bitNum=0;
	}

	//Check if the empty ARP table can accommodate the same size software ARP table routing
	//If so, copy from software ARP link list to hardware ARP table
	for(i=0;i<MAX_L3_HW_TABLE_SIZE;i++)
	{
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(i==SLAVE_WIFI_ROUTE_IDX)	//ipc routing should not be converted at any time!
			continue;
#endif

		if(rg_db.l3[i].rtk_l3.valid && rg_db.l3[i].rtk_l3.ipAddr>0 && rg_db.l3[i].rtk_l3.process==L34_PROCESS_CPU)
		{
			if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].storedInfo.is_wan)
			{
				//20140623LUKE:do not convert OtherWAN interface route!!
				if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.none_internet)
					continue;

				//20150916LUKE: do not convert PPTP, L2TP, Dslite, pppoe_Dslite interface route!!
				//20140312LUKE:do not convert PPPoE interface route!!(internal is WAN)
				if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE||
					(rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type>=RTK_RG_PPTP &&
					rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type<=RTK_RG_PPPoE_DSLITE))
					continue;

				//20140916LUKE: if STATIC ROUTE set gw_MAC_autolearn and gw not yet response, we should not convert it!!
				if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].p_wanStaticInfo->gateway_ipv4_addr &&
					!rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].p_wanStaticInfo->ipv4_default_gateway_on)
					continue;
			}
			else
			{
				if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx].storedInfo.lan_intf.add_sw_arp)
					continue;
			}

			bitNum=31-rg_db.l3[i].rtk_l3.ipMask;
			if(rg_db.l3[i].rtk_l3.rt2waninf!=deletingEntry->isLan && bitNum<=deletingEntry->bitNum)	//convert sw bitNum bigger than deleting hw entry is impossible
			{
				DEBUG("add to candidate list!!i is %d",i);
				swRoutingList[i].bitNum=bitNum;

				if(list_empty(&swRoutingHead))
				{
					DEBUG("add to list head!");
					list_add(&swRoutingList[i].route_list,&swRoutingHead);
				}
				else
				{
					//insert the new candidate entry by its bitNum, bigger is close to head, smaller is far from it.
					list_for_each_entry(pSwRoutingList,&swRoutingHead,route_list)
					{
						if(bitNum>pSwRoutingList->bitNum)
						{
							inserted=1;
							break;
						}
					}

					if(inserted)
					{
						DEBUG("insert new routing list(%d) before pSwRoutingList(%d)",bitNum,pSwRoutingList->bitNum);
						list_add_tail(&swRoutingList[i].route_list,&pSwRoutingList->route_list);
					}
					else
					{
						DEBUG("append new routing list(%d) before the Head",bitNum);
						list_add_tail(&swRoutingList[i].route_list,&swRoutingHead);
					}
				}
			}
		}
	}

	arpNum=0x1<<deletingEntry->bitNum;

	if(!list_empty(&swRoutingHead))
	{
		DEBUG("total can add %d arp entries",arpNum);
		list_for_each_entry(pSwRoutingList,&swRoutingHead,route_list)
		{
			//if the sw entry size is accommodate into the deleting range,
			//transfer sw ARP to hw ARP, add to tempRoutingArray and rearrange ARP table
			//count arp range
			newAddingRoute.arpStart=deletingEntry->arpStart;
			arpNum-=0x1<<pSwRoutingList->bitNum;
			DEBUG("there are %d last arp entries can be add..",arpNum);
			if(arpNum<0)
				break;

			if(pSwRoutingList->bitNum<=2)
				deletingEntry->arpStart+=1;
			else
				deletingEntry->arpStart+=(0x1<<(pSwRoutingList->bitNum-2));
			newAddingRoute.arpEnd=deletingEntry->arpStart-1;
			DEBUG("    new arpStart=%d, arpEnd=%d...deleing arpStart=%d, arpEnd=%d",newAddingRoute.arpStart,newAddingRoute.arpEnd,deletingEntry->arpStart,deletingEntry->arpEnd);

			newAddingRoute.routingIdx=pSwRoutingList->idx;
			newAddingRoute.intfIdx=rg_db.l3[pSwRoutingList->idx].rtk_l3.netifIdx;
			newAddingRoute.bitNum=pSwRoutingList->bitNum;

			//Rearrange ARP table
			newIpAddr=rg_db.l3[pSwRoutingList->idx].rtk_l3.ipAddr;
			if(rg_db.l3[pSwRoutingList->idx].rtk_l3.rt2waninf)
			{
				newAddingRoute.isLan=0;
				newAddingRoute.notMask=~(rg_db.systemGlobal.interfaceInfo[newAddingRoute.intfIdx].p_wanStaticInfo->ip_network_mask);
				intfVlanId=rg_db.systemGlobal.interfaceInfo[newAddingRoute.intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			}
			else
			{
				newAddingRoute.isLan=1;
				newAddingRoute.notMask=~(rg_db.systemGlobal.interfaceInfo[newAddingRoute.intfIdx].p_lanIntfConf->ip_network_mask);
				intfVlanId=rg_db.systemGlobal.interfaceInfo[newAddingRoute.intfIdx].p_lanIntfConf->intf_vlan_id;
			}
			ret=_rtk_rg_addArpRoutingArray(&newAddingRoute,newIpAddr,intfVlanId);
			if(ret==RT_ERR_RG_OK)
			{
				//change routing table's process from CPU to ARP
				memcpy(&rtEntry,&rg_db.l3[newAddingRoute.routingIdx].rtk_l3,sizeof(rtk_l34_routing_entry_t));
				rtEntry.process = L34_PROCESS_ARP;
				rtEntry.arpStart = newAddingRoute.arpStart;
				rtEntry.arpEnd = newAddingRoute.arpEnd;
				DEBUG("    Convert sw ARP to hw!! newArpStart is %d, newArpEnd is %d",rtEntry.arpStart,rtEntry.arpEnd);
				ret = RTK_L34_ROUTINGTABLE_SET(newAddingRoute.routingIdx, &rtEntry);
				if(ret!=RT_ERR_OK)
					break;

				//Convert software ARP to hw ARP table
				for(i=0;i<MAX_ARP_SW_TABLE_HEAD;i++)
				{
					list_for_each_entry_safe(pSwArpInfo,pNextSwArpInfo,&rg_db.softwareArpTableHead[i],arp_list)
					{
						if(rg_db.arp[pSwArpInfo->idx].routingIdx==newAddingRoute.routingIdx)	//Hit,transfer to hw arp
						{
							arpIdx=(newAddingRoute.arpStart<<2);
							arpIdx+=rg_db.arp[pSwArpInfo->idx].ipv4Addr&newAddingRoute.notMask;
							arpEntry.ipv4Addr=rg_db.arp[pSwArpInfo->idx].ipv4Addr;
							arpEntry.macEntryIdx=rg_db.arp[pSwArpInfo->idx].rtk_arp.nhIdx;
							arpEntry.staticEntry=rg_db.arp[pSwArpInfo->idx].staticEntry;		//keep static character
							DEBUG("    convert sw ARP[%d]->l2:%d from sw to hw[%d]!!",pSwArpInfo->idx,arpEntry.macEntryIdx,arpIdx);
							assert_ok(rtk_rg_apollo_arpEntry_add(&arpEntry,&arpIdx));

							//Free software ARP list
							DEBUG("    free sw ARP[%d] in array[%d]!",pSwArpInfo->idx,i);
							_rtk_rg_softwareArpTableDel(pSwArpInfo);
						}
					}
					/*pSwArpInfo=rg_db.pSoftwareArpTableHead[i];
					while(pSwArpInfo!=NULL)
					{
						pNextSwArpInfo=pSwArpInfo->pNext;
						if(pSwArpInfo->routingIdx==pSwRoutingHead->swRoutingEntry.routingIdx)		//Hit,transfer to hw arp
						{
							arpIdx=(pSwRoutingHead->swRoutingEntry.arpStart<<2);
							arpIdx+=pSwArpInfo->ipv4Addr&pSwRoutingHead->swRoutingEntry.notMask;
							arpEntry.ipv4Addr=pSwArpInfo->ipv4Addr;
							arpEntry.macEntryIdx=pSwArpInfo->nhIdx;
							arpEntry.staticEntry=pSwArpInfo->staticEntry;		//keep static character
							DEBUG("add ARP from sw to hw[%d]!!",arpIdx);
							assert_ok(rtk_rg_arpEntry_add(&arpEntry,&arpIdx));

							//Free software ARP list
							DEBUG("free sw ARP Info in array[%d]!",i);
							_rtk_rg_softwareArpTableDel(pSwArpInfo);
						}
						pSwArpInfo=pNextSwArpInfo;
					}*/
				}
			}
			else
				break;	//failed to convert, just return.
		}
		/*while(pSwRoutingHead!=NULL)
		{
			//if the sw entry size is accommodate into the deleting range,
			//transfer sw ARP to hw ARP, add to tempRoutingArray and rearrange ARP table
			//count arp range
			pSwRoutingHead->swRoutingEntry.arpStart=deletingEntry->arpStart;
			arpNum-=0x1<<pSwRoutingHead->swRoutingEntry.bitNum;
			DEBUG("there are %d last arp entries can be add..",arpNum);
			if(arpNum<0)
				break;

			if(pSwRoutingHead->swRoutingEntry.bitNum<=2)
				deletingEntry->arpStart+=1;
			else
				deletingEntry->arpStart+=(0x1<<(pSwRoutingHead->swRoutingEntry.bitNum-2));
			pSwRoutingHead->swRoutingEntry.arpEnd=deletingEntry->arpStart;
			DEBUG("new arpStart=%d, arpEnd=%d...deleing arpStart=%d, arpEnd=%d",pSwRoutingHead->swRoutingEntry.arpStart,pSwRoutingHead->swRoutingEntry.arpEnd,
				deletingEntry->arpStart,deletingEntry->arpEnd);

			//Rearrange ARP table
			newIpAddr=rg_db.l3[pSwRoutingHead->swRoutingEntry.routingIdx].rtk_l3.ipAddr;
			if(pSwRoutingHead->swRoutingEntry.isLan)
				intfVlanId=rg_db.systemGlobal.interfaceInfo[pSwRoutingHead->swRoutingEntry.intfIdx].p_lanIntfConf->intf_vlan_id;
			else
				intfVlanId=rg_db.systemGlobal.interfaceInfo[pSwRoutingHead->swRoutingEntry.intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			ret=_rtk_rg_addArpRoutingArray(&pSwRoutingHead->swRoutingEntry,newIpAddr,intfVlanId);
			if(ret==RT_ERR_RG_OK)
			{
				//change routing table's process from CPU to ARP
				memcpy(&rtEntry,&rg_db.l3[pSwRoutingHead->swRoutingEntry.routingIdx].rtk_l3,sizeof(rtk_l34_routing_entry_t));
				rtEntry.process = L34_PROCESS_ARP;
				rtEntry.arpStart = pSwRoutingHead->swRoutingEntry.arpStart;
				rtEntry.arpEnd = pSwRoutingHead->swRoutingEntry.arpEnd;
				DEBUG("Convert sw ARP to hw!! newArpStart is %d, newArpEnd is %d",rtEntry.arpStart,rtEntry.arpEnd);
				ret = RTK_L34_ROUTINGTABLE_SET(pSwRoutingHead->swRoutingEntry.routingIdx, &rtEntry);
				if(ret!=RT_ERR_OK)
					break;

				for(i=0;i<MAX_ARP_SW_TABLE_HEAD;i++)
				{
					pSwArpInfo=rg_db.pSoftwareArpTableHead[i];
					while(pSwArpInfo!=NULL)
					{
						pNextSwArpInfo=pSwArpInfo->pNext;
						if(pSwArpInfo->routingIdx==pSwRoutingHead->swRoutingEntry.routingIdx)		//Hit,transfer to hw arp
						{
							arpIdx=(pSwRoutingHead->swRoutingEntry.arpStart<<2);
							arpIdx+=pSwArpInfo->ipv4Addr&pSwRoutingHead->swRoutingEntry.notMask;
							arpEntry.ipv4Addr=pSwArpInfo->ipv4Addr;
							arpEntry.macEntryIdx=pSwArpInfo->nhIdx;
							arpEntry.staticEntry=pSwArpInfo->staticEntry;		//keep static character
							DEBUG("add ARP from sw to hw[%d]!!",arpIdx);
							assert_ok(rtk_rg_arpEntry_add(&arpEntry,&arpIdx));

							//Free software ARP list
							DEBUG("free sw ARP Info in array[%d]!",i);
							_rtk_rg_softwareArpTableDel(pSwArpInfo);
						}
						pSwArpInfo=pNextSwArpInfo;
					}
				}
			}
			else
				break;	//failed to convert, just return.

			pSwRoutingHead=pSwRoutingHead->pNext;
		}*/
	}

	return (RT_ERR_RG_OK);

#elif defined(CONFIG_RG_RTL9602C_SERIES)
	FIXME("9602BVB don't need to converSwArpToHW");
	return (RT_ERR_RG_OK);

#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	//FIXME:
	return (RT_ERR_RG_OK);
#endif
}

int32 _rtk_rg_delArpRoutingArray(rtk_rg_routing_arpInfo_t *deletingEntry)
{
	unsigned int ret,i=0;
	rtk_rg_routing_arpInfo_t *pTemporary;
	int *pVlanTemporary;


	//init
	bzero(rg_db.p_tempRoutingArpInfoArray,sizeof(rtk_rg_routing_arpInfo_t)*MAX_L3_SW_TABLE_SIZE);
	bzero(rg_db.p_tempRoutingVlanInfoArray,sizeof(int)*MAX_L3_SW_TABLE_SIZE);

	//if the entry is deleting, we do not add it in tmpArray
	for(i=0;i<rg_db.routingArpInfoNum;i++)
	{
		if(deletingEntry->routingIdx==rg_db.p_routingArpInfoArray[i].routingIdx)
		{
			memcpy(&rg_db.p_tempRoutingArpInfoArray[i],&rg_db.p_routingArpInfoArray[i+1],sizeof(rtk_rg_routing_arpInfo_t)*(rg_db.routingArpInfoNum-i-1));
			memcpy(&rg_db.p_tempRoutingVlanInfoArray[i],&rg_db.p_routingVlanInfoArray[i+1],sizeof(int)*(rg_db.routingArpInfoNum-i-1));
			break;
		}
		else
		{
			memcpy(&rg_db.p_tempRoutingArpInfoArray[i],&rg_db.p_routingArpInfoArray[i],sizeof(rtk_rg_routing_arpInfo_t));
			rg_db.p_tempRoutingVlanInfoArray[i]=rg_db.p_routingVlanInfoArray[i];
		}
	}

	//Count and check ARP table distribution
	ret=_rtk_rg_arpRearrange(NULL,0,rg_db.routingArpInfoNum-1);
	if(ret!=RT_ERR_RG_OK)
		return ret;

	//Global variable modification
	rg_db.routingArpInfoNum--;
	pTemporary=rg_db.p_routingArpInfoArray;
	rg_db.p_routingArpInfoArray=rg_db.p_tempRoutingArpInfoArray;
	rg_db.p_tempRoutingArpInfoArray=pTemporary;


	pVlanTemporary=rg_db.p_routingVlanInfoArray;
	rg_db.p_routingVlanInfoArray=rg_db.p_tempRoutingVlanInfoArray;
	rg_db.p_tempRoutingVlanInfoArray=pVlanTemporary;

	//Convert sw ARP list to hw ARP table if any
#ifdef CONFIG_APOLLO_MODEL
	rtlglue_printf("FIXME: Execute model codes _rtk_rg_convertSwArpToHwTable() segmentation fault!\n");
#else
	_rtk_rg_convertSwArpToHwTable(deletingEntry);
#endif

	return (RT_ERR_RG_OK);
}

void _rtk_rg_refreshPPPoEPassThroughLanOrWanPortMask(void)
{
	if((rg_db.algFunctionMask&RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0)
	{
		//Turn off ACL first and re-enable Pass through to refresh the LAN or WAN port mask
		rg_db.algFunctionMask&=(~RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT);
		rtk_rg_apollo_algApps_set(rg_db.algFunctionMask);
		rg_db.algFunctionMask|=RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT;
		rtk_rg_apollo_algApps_set(rg_db.algFunctionMask);
	}
}

rtk_rg_successFailReturn_t _rtk_rg_createGatewayMacEntry(uint8 *gatewayMac, int vlanID, uint32 untagSet, int intfIdx, uint8 isLanIntf)
{
	rtk_rg_macEntry_t macEntry;
	int ret,l2Idx,search_index,count=0,first_invalid=-1,lut_orig=-1,port_move_orig=-1,category_orig=-1,wlan_move_orig=-1,permit_orig=0,lut_matchIdx=FAIL,dynLut=0;
	rtk_rg_port_idx_t portIdx=RTK_RG_PORT_MAX;
	uint32 check_ivl_vid=vlanID, ivlL2Idx;

	memset(&macEntry,0,sizeof(rtk_rg_macEntry_t));

	//Add SVL lut entry first
	macEntry.isIVL=0;
	macEntry.vlan_id=vlanID;
	macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
	if((untagSet&(0x1<<RTK_RG_MAC_PORT_CPU))>0)		//cpu is in untag set
		macEntry.vlan_id=0;		//untag for DMAC2CVID
#else	// support ctag_if
	macEntry.ctag_if=((untagSet&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)>0)?0:1;
#endif
	//DEBUG("the internalVlanID is %d, fid is %d",macEntry.vlan_id,macEntry.fid);

	l2Idx=_rtk_rg_hash_mac_fid_efid(gatewayMac,macEntry.fid,0);			//FIXME:EFID is 0 now
	l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
	do
	{
		search_index = l2Idx+count;
		//DEBUG("search_idx is %d\n",search_index);
		if(rg_db.lut[search_index].valid==0)
		{
			if(first_invalid==-1)
				first_invalid=search_index;
			//break;	//empty, just add
			count++; //search from next entry
			continue;
		}

		if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
			(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,gatewayMac,ETHER_ADDR_LEN)==0))
		{
			if(((macEntry.isIVL==1) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
			((macEntry.isIVL==0) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
			{
				//Record matched index of lut
				lut_matchIdx=search_index;

				//DEBUG("match!!");
				if(!(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)){
					permit_orig=rg_db.lut[search_index].permit_for_l34_forward;
					dynLut=1;
					_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
					_rtk_rg_lutExtport_translator(&portIdx);
#endif
					if(!RG_INVALID_PORT(portIdx))
					{
						//------------------ Critical Section start -----------------------//
						//rg_lock(&rg_kernel.saLearningLimitLock);

						if(rg_db.lut[search_index].countingInLearningLimit)
							assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));
						
						//20170301LUKE: modify count when limit field is source mac.
						if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
							if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx) && permit_orig)
								atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);					

						if(_rtK_rg_checkCategoryPortmask(&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry)==RT_ERR_RG_OK)
						{
							category_orig=rg_db.lut[search_index].category;
							//20170301LUKE: modify count when limit field is source mac.
							if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC && category_orig>=0 && category_orig<WanAccessCategoryNum)
								atomic_dec(&rg_db.systemGlobal.accessWanLimitCategoryCount[category_orig]);
						}
						lut_orig=search_index;
						port_move_orig=portIdx;
						if(portIdx > RTK_RG_PORT_LASTCPU)
						{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
							//decrease wlan's device count
							if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
								|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
								) && rg_db.lut[search_index].wlan_device_idx>=0)
							{
								wlan_move_orig=rg_db.lut[search_index].wlan_device_idx;
								if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
									if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<wlan_move_orig) && permit_orig)
										atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
							}
#endif

							DEBUG("froced replace WLAN's LUT entry[%d] for gateway entry!!",search_index);
							break;
						}
						else
						{
							DEBUG("froced replace LUT entry[%d] for gateway entry!!",search_index);
							break;
						}
					}
				}
				//------------------ Critical Section End -----------------------//
				//rg_unlock(&rg_kernel.saLearningLimitLock);
				rg_db.netif[intfIdx].l2_idx=search_index;
				goto ADD_IVL_LUT;
			}
		}

		count++; //search from next entry
	}while(count < MAX_LUT_HASH_WAY_SIZE);

	if(count==MAX_LUT_HASH_WAY_SIZE)
	{
		//Check bCAM LUT first, if match, just return.
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
		{
			if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
			{
				if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,gatewayMac,ETHER_ADDR_LEN)==0)
				{
					if(((macEntry.isIVL==1) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
					((macEntry.isIVL==0) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
					{
						//Record matched index of lut
						lut_matchIdx=search_index;

						//DEBUG("match!!");
						if(!(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)){
							permit_orig=rg_db.lut[search_index].permit_for_l34_forward;
							dynLut=1;
							_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
							_rtk_rg_lutExtport_translator(&portIdx);
#endif
							if(!RG_INVALID_PORT(portIdx))
							{
								//------------------ Critical Section start -----------------------//
								//rg_lock(&rg_kernel.saLearningLimitLock);

								if(rg_db.lut[search_index].countingInLearningLimit)
									assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));
								
								//20170301LUKE: modify count when limit field is source mac.
								if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
									if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx) && permit_orig)
										atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);					

								if(_rtK_rg_checkCategoryPortmask(&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry)==RT_ERR_RG_OK)
								{
									category_orig=rg_db.lut[search_index].category;
									//20170301LUKE: modify count when limit field is source mac.
									if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC && category_orig>=0 && category_orig<WanAccessCategoryNum)
										atomic_dec(&rg_db.systemGlobal.accessWanLimitCategoryCount[category_orig]);
								}
								lut_orig=search_index;
								port_move_orig=portIdx;
								if(portIdx > RTK_RG_PORT_LASTCPU)
								{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
									//decrease wlan's device count
									if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
										|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
										) && rg_db.lut[search_index].wlan_device_idx>=0)
									{
										wlan_move_orig=rg_db.lut[search_index].wlan_device_idx;
										if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
											if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<wlan_move_orig) && permit_orig)
												atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
									}
#endif

									DEBUG("froced replace WLAN's LUT entry[%d] for gateway entry!!",search_index);
									break;
								}
								else
								{
									DEBUG("froced replace LUT entry[%d] for gateway entry!!",search_index);
									break;
								}
							}
						}
						//------------------ Critical Section End -----------------------//
						//rg_unlock(&rg_kernel.saLearningLimitLock);
						rg_db.netif[intfIdx].l2_idx=search_index;
						goto ADD_IVL_LUT;
					}
				}
			}
		}
		if(first_invalid==-1)
			count=_rtk_rg_layer2GarbageCollection(l2Idx);		//check if there is asynchronus between software and hardware table
	}

	//Decide lut index
	if(lut_matchIdx>=0 && rg_db.lut[lut_matchIdx].valid==0)
	{
		if(lut_matchIdx<LUT_HW_TABLE_SIZE)
		{
			if(first_invalid<0 || (first_invalid>=0 && lut_matchIdx<first_invalid))
				first_invalid = lut_matchIdx;
		}
		lut_matchIdx = FAIL;
	}
	if(lut_matchIdx>=0)
	{
		search_index = lut_matchIdx;
	}
	else
	{
		if(first_invalid>=0)
		{
			search_index = first_invalid;
		}
		else	//When the 4-way is full, check the bCAM list for free to add. If the bCAM is also full, do LRU.
		{
			search_index=_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, FAIL);
			if(search_index==RG_RET_ENTRY_NOT_GET)
			{
				FIXME("must add software LUT entry for LUT entry full.");
				if(dynLut)
				{
					//port-moving fail, recovery old count
					if((lut_orig>=0) && rg_db.lut[lut_orig].countingInLearningLimit)
						assert_ok(_rtk_rg_mac_learning_limit_count_inc(port_move_orig, wlan_move_orig));
					
					if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
					{
						if((port_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<port_move_orig)) && permit_orig)
							atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						if((wlan_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<wlan_move_orig)) && permit_orig)
							atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#endif
					}

					//category not change, recovery old count
					if(category_orig>=0 && category_orig<WanAccessCategoryNum)
					{
						//20170301LUKE: modify count when limit field is source mac.
						if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
							atomic_inc(&rg_db.systemGlobal.accessWanLimitCategoryCount[category_orig]);
					}
				}
				return RG_RET_FAIL;
			}
		}
	}
	memcpy(macEntry.mac.octet,gatewayMac,ETHER_ADDR_LEN);
	macEntry.port_idx = RTK_RG_PORT_MAINCPU;
#if defined(CONFIG_RG_G3_SERIES)
	// G3 platform: -2 stands for lan interface, -3 stands for wan interface
	macEntry.wlan_device_idx = (isLanIntf) ? -2 : -3;
#else	// not CONFIG_RG_G3_SERIES
	macEntry.wlan_device_idx = FAIL;
#endif
	macEntry.static_entry=1;	//since this lut entry should exist till interface dead, we have to create it statically
	ret=(pf.rtk_rg_macEntry_add)(&macEntry,&search_index);
	assert_ok(ret);
	rg_db.netif[intfIdx].l2_idx=search_index;
	DEBUG("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x netif=%d ###\n",search_index,gatewayMac[0],gatewayMac[1],gatewayMac[2],gatewayMac[3],gatewayMac[4],gatewayMac[5],intfIdx);

ADD_IVL_LUT:
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_kernel.block_communication_between_internet_and_other)
	{
		if(isLanIntf)
		{
			ret = _rtk_rg_create_ivlMacEntries_of_internalUsedVid(search_index, check_ivl_vid, FAIL, FAIL);
			if(ret!=RT_ERR_RG_OK)
			{
				WARNING("Fail to create ivl mac entries, ret=0x%x", ret);
				return RG_RET_FAIL;
			}
		}
	}
	else
#endif
	//Add IVL lut entry (Do not move!)
	if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
	{
		ret = _rtk_rg_ivlMacEntry_add(search_index, check_ivl_vid, FAIL, FAIL, &ivlL2Idx);
		if(ret!=RT_ERR_RG_OK)
		{
			WARNING("Fail to create the corresponding ivl mac entry, ret=0x%x", ret);
			return RG_RET_FAIL;
		}
	}

	return RG_RET_SUCCESS;
}

void _rtk_rg_deleteGatewayMacEntry(uint8 *gatewayMac, int vlanID, uint32 untagSet)
{
	rtk_rg_macEntry_t macEntry;
	int ret,l2Idx,search_index,count=0,i;

	memset(&macEntry,0,sizeof(rtk_rg_macEntry_t));

	macEntry.vlan_id=vlanID;
	macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
	//DEBUG("the internalVlanID is %d, fid is %d",macEntry.vlan_id,macEntry.fid);

	if(rg_db.vlan[macEntry.vlan_id].fidMode==VLAN_FID_IVL)
	{
		macEntry.isIVL=1;
		l2Idx=_rtk_rg_hash_mac_vid_efid(gatewayMac,macEntry.vlan_id,0);		//FIXME:EFID is 0 now
	}
	else
	{
DEL_SVL_LUT:
		count=0;
		macEntry.isIVL=0;
#if defined(CONFIG_RG_RTL9600_SERIES)
		if((untagSet&(0x1<<RTK_RG_MAC_PORT_CPU))>0)		//cpu is in untag set
			macEntry.vlan_id=0;		//untag for DMAC2CVID
#else	// support ctag_if
		macEntry.ctag_if=((untagSet&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)>0)?0:1;
#endif
		l2Idx=_rtk_rg_hash_mac_fid_efid(gatewayMac,macEntry.fid,0);			//FIXME:EFID is 0 now
	}

	l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
	do
	{
		search_index = l2Idx+count;
		//DEBUG("search_idx is %d\n",search_index);
		if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
			(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,gatewayMac,ETHER_ADDR_LEN)==0))
		{
			if(((macEntry.isIVL==1) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
			((macEntry.isIVL==0) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
			{
				//DEBUG("match!!");
				break;
			}
		}

		count++; //search from next entry
	}while(count < MAX_LUT_HASH_WAY_SIZE);

	if(count==MAX_LUT_HASH_WAY_SIZE)
	{
		//Check bCAM LUT first, if match, just return.
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
		{
			if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
			{
				if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,gatewayMac,ETHER_ADDR_LEN)==0)
				{
					if(((macEntry.isIVL==1) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
					((macEntry.isIVL==0) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
					{
						//HIT!
						break;
					}
				}
			}
		}

		if(search_index==MAX_LUT_HW_TABLE_SIZE)
		{
			DEBUG("gateway %s lut is not exist anymore...",macEntry.isIVL?"VLAN-based":"MAC-based");
			if(macEntry.isIVL)goto DEL_SVL_LUT;		//del SVL,too
			return;
		}
	}

	//Check if there are LAN or WAN interfaces use the same MAC and VLANID
	for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
	{
		//if the interface are IVL, VLAN and MAC are all the same, we just keep the IVL one, but SVL should check again
		if(macEntry.isIVL==1)
		{
			if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id==macEntry.vlan_id && rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->isIVL && memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
				goto DEL_SVL_LUT;
		}
		else		//check the VLANID to insure that tag/untag will be same
		{
			if(macEntry.vlan_id==0)	//untag
			{
				if((rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->untag_mask.portmask&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)>0 && macEntry.vlan_id==0 &&	//cpu is in untag set
					memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
					goto KEEP_MAC;
			}
			else	//tag: compare VID
			{
				if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id==macEntry.vlan_id &&
					memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
					goto KEEP_MAC;
			}
		}
	}
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		//if the interface are IVL, VLAN and MAC are all the same, we just keep the IVL one, but SVL should check again
		if(macEntry.isIVL==1)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==macEntry.vlan_id && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->isIVL && memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
				goto DEL_SVL_LUT;
		}
		else
		{
			if(macEntry.vlan_id==0)	//untag
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on==0 &&	//cpu is in untag set
					memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
					goto KEEP_MAC;
			}
			else	//tag: compare VID
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==macEntry.vlan_id &&
					memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
					goto KEEP_MAC;
			}

		}
	}

	ret=(pf.rtk_rg_macEntry_del)(search_index);
	if(ret==RT_ERR_RG_ENTRY_NOT_EXIST)		//not in hardware anymore
		memset(&rg_db.lut[search_index],0,sizeof(rtk_rg_table_lut_t));

	if(macEntry.isIVL)goto DEL_SVL_LUT;		//del SVL,too

KEEP_MAC:
	return;
}

int _rtk_rg_updatePortBasedVIDByLanOrder(rtk_portmask_t mac_pmask, rtk_portmask_t etp_pmask /*Note!! For FB: bit'0 stands for ext0 not cpu port*/)
{
	int i,j,setPVid,ret;
	int8 IPVerAll,IPVerAllUntag,IPVerV4,IPVerV6,IPProtoBlock;
	int8 IPVerAll_ext,IPVerAllUntag_ext;
	int8 VLANProtoBlockUsed=0;
	rtk_vlan_protoVlanCfg_t protoVlanCfg;
	rtk_portmask_t mbpmsk, utpmsk, etpmsk;
	//rtk_portmask_t mbpmsk,etpmsk,update_mbpmsk,update_etpmsk;

	DEBUG("mac_pmsk is %x, ext_pmsk is %x",mac_pmask.bits[0],etp_pmask.bits[0]);

	//Check member port of VLAN ID
	for(i=0;i<RTK_RG_MAC_PORT_MAX;i++)
	{
		if(RG_INVALID_MAC_PORT(i)) continue;
		if((mac_pmask.bits[0]&(0x1<<i)) > 0 /*&& i != RTK_RG_MAC_PORT_CPU*/)
		{
			//init
			_rtk_rg_cleanPortAndProtocolSettings(i);
			IPVerAll=0;
			IPVerAllUntag=0;
			IPVerV4=0;
			IPVerV6=0;
			IPProtoBlock=0;
			setPVid=rg_db.systemGlobal.initParam.fwdVLAN_CPU;
			for(j=0;j<rg_db.systemGlobal.lanIntfTotalNum;j++)
			{
				if((rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->port_mask.portmask&(0x1<<i)) > 0)
				{
					if(rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->ip_version==IPVER_V4ONLY)
					{
						if(IPVerV4==0)		//first add V4 ony inteface, add to PPB setting
						{
							//DEBUG("@@@ add IPv4 PPB as %d in port %d",rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id,i);
							IPVerV4=1;
							//add V4 PPB
							protoVlanCfg.valid=1;
							protoVlanCfg.vid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
							protoVlanCfg.pri=0;			//FIXME: should I change this?
							protoVlanCfg.dei=0;
							ret = RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV4_GROUPID,&protoVlanCfg);
							assert_ok(ret);

							//add ARP PPB
							protoVlanCfg.valid=1;
							protoVlanCfg.vid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
							protoVlanCfg.pri=0;			//FIXME: should I change this?
							protoVlanCfg.dei=0;
							ret = RTK_VLAN_PORTPROTOVLAN_SET(i,RG_ARP_GROUPID,&protoVlanCfg);
							assert_ok(ret);

							if(IPVerAll==0 && IPVerAllUntag==0)
							{
								//if no other interface set to "ALL", the PVID should set to DEFAULT_LAN_VLAN
								//to block all other protocol packet from going to other port.
								IPProtoBlock=1;
								setPVid=rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block;
							}
						}
					}
					else if(rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->ip_version==IPVER_V6ONLY)
					{
						if(IPVerV6==0)
						{
							//DEBUG("@@@ add IPv6 PPB as %d in port %d",rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id,i);
							IPVerV6=1;
							//add V6 PPB
							protoVlanCfg.valid=1;
							protoVlanCfg.vid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
							protoVlanCfg.pri=0;			//FIXME: should I change this?
							protoVlanCfg.dei=0;
							ret = RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV6_GROUPID,&protoVlanCfg);
							assert_ok(ret);

							if(IPVerAll==0 && IPVerAllUntag==0)
							{
								//if no other interface set to "ALL", the PVID should set to DEFAULT_LAN_VLAN
								//to block all other protocol packet from going to other port.
								IPProtoBlock=1;
								setPVid=rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block;
							}
						}
					}
					else	//all
					{
						if(IPVerAllUntag==0 && (rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->untag_mask.portmask&(0x1<<i))>0)
						{
							//DEBUG("@@@ set pvid of port %d as %d(first Untag LAN)",i,rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id);
							setPVid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
							IPVerAllUntag=1;
						}
						else if(IPVerAllUntag==0 && IPVerAll==0)
						{
							//DEBUG("@@@ set pvid of port %d as %d(first LAN)",i,rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id);
							setPVid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
							IPVerAll=1;
						}
						else
						{
							//Do nothing
							//DEBUG("@@@ set pvid of port %d as %d(already decided)",i,setPVid);
						}
					}
				}
			}
#if 0
			firstIPVer=-1;
			setPVid=DEFAULT_CPU_VLAN;
			for(j=0;j<rg_db.systemGlobal.lanIntfTotalNum;j++)
			{
				if((rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->port_mask.portmask&(0x1<<i)) > 0)
				{
					if(firstIPVer<0)		//first interface's IPVersion
					{
						setPVid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
						firstIPVer=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->ip_version;
					}
					else		//the j is after first interface, so check if we need to add port and protocol based VLAN
					{
						if(firstIPVer==IPVER_V4V6 || rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->ip_version != firstIPVer)
						{
							if(firstIPVer==IPVER_V4ONLY)
							{
								//add V6 PPB
								protoVlanCfg.valid=1;
								protoVlanCfg.vid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
								protoVlanCfg.pri=0;			//FIXME: should I change this?
								protoVlanCfg.dei=0;
								ret = RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV6_GROUPID,&protoVlanCfg);
								assert_ok(ret);
							}
							else if(firstIPVer==IPVER_V6ONLY)
							{
								//add V4 PPB
								protoVlanCfg.valid=1;
								protoVlanCfg.vid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
								protoVlanCfg.pri=0;			//FIXME: should I change this?
								protoVlanCfg.dei=0;
								ret = RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV4_GROUPID,&protoVlanCfg);
								assert_ok(ret);

								//add ARP PPB
								protoVlanCfg.valid=1;
								protoVlanCfg.vid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
								protoVlanCfg.pri=0;			//FIXME: should I change this?
								protoVlanCfg.dei=0;
								ret = RTK_VLAN_PORTPROTOVLAN_SET(i,RG_ARP_GROUPID,&protoVlanCfg);
								assert_ok(ret);
							}
							break;
						}
					}
				}
			}
#endif
			if(IPProtoBlock && !rg_db.systemGlobal.vlan_proto_block_created)
			{
				ret = RTK_VLAN_CREATE(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block);
				if(ret==RT_ERR_VLAN_EXIST)
				{
					WARNING("the fwdVLAN_Proto_Block[%d] had been used...please check!",rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block);
				}
				else
				{
					assert_ok(ret);
				}
				mbpmsk.bits[0]=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;	//CPU port
				utpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;		//all untag
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
				etpmsk.bits[0]=0x1;							//extension CPU port
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
				/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
				etpmsk.bits[0]=0x0;
#else
#error
#endif
				ret = RTK_VLAN_FID_SET(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block, LAN_FID);
				assert_ok(ret);
				ret = RTK_VLAN_FIDMODE_SET(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block, VLAN_FID_SVL);		//This is used for ALL LAN interface
				assert_ok(ret);
				ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block, &mbpmsk, &utpmsk);
				assert_ok(ret);
				ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block, &etpmsk);
				assert_ok(ret);

				rg_db.systemGlobal.vlan_proto_block_created=1;
				VLANProtoBlockUsed=1;
			}

			//DEBUG("MAC port %d vlan is %d",i,setPVid);
			ret = RTK_VLAN_PORTPVID_SET(i, setPVid);
			assert_ok(ret);
		}
	}

	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
	for(i=0; i<RTK_RG_MAX_EXT_PORT; i++)
	{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		if(i==0)continue;	//extension port 0 is CPU port, no port-based VID
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
#else
#error
#endif
		if((etp_pmask.bits[0]&(0x1<<i)) > 0 /*&& i+RTK_RG_PORT_LASTCPU < RTK_RG_PORT_MAX*/)
		{
			IPVerAll_ext=0;
			IPVerAllUntag_ext=0;
			setPVid=rg_db.systemGlobal.initParam.fwdVLAN_CPU;

			for(j=0;j<rg_db.systemGlobal.lanIntfTotalNum;j++)
			{
				//DEBUG("lan portmask=0x%x, portmask=0x%x", rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->port_mask.portmask, (0x1<<(i+RTK_RG_EXT_BASED_PORT)));
				if((rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->port_mask.portmask&(0x1<<(i+RTK_RG_EXT_BASED_PORT))) > 0)
				{
					if(IPVerAllUntag_ext==0 && (rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->untag_mask.portmask&(0x1<<RTK_RG_EXT_BASED_PORT))>0)
					{
						//DEBUG("@@@ set pvid of port %d as %d(first Untag LAN)",i,rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id);
						setPVid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
						IPVerAllUntag_ext=1;
					}
					else if(IPVerAllUntag_ext==0 && IPVerAll_ext==0)
					{
						//DEBUG("@@@ set pvid of port %d as %d(first LAN)",i,rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id);
						setPVid=rg_db.systemGlobal.lanIntfGroup[j].p_intfInfo->p_lanIntfConf->intf_vlan_id;
						IPVerAll_ext=1;
					}
					else
					{
						//Do nothing
						//DEBUG("@@@ set pvid of port %d as %d(already decided)",i,setPVid);
					}
				}
			}

			DEBUG("EXT port %d vlan is %d",i,setPVid);
			ret = RTK_VLAN_EXTPORTPVID_SET(i, setPVid);		//ext port index is 0-4, means ext port 1-5
			assert_ok(ret);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
			if(i==1)
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
			if(i==0)
#else
#error
#endif
			{
				//Assign device-based VID to WLAN0's devices
				for(j=0;j<MAX_WLAN_DEVICE_NUM;j++)
				{
					if(rg_db.systemGlobal.wlan0BindDecision[j].exist)
					{
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
						if(j==RG_WWAN_WLAN0_VXD || j==RG_WWAN_WLAN1_VXD)continue;
#endif
						ret = rtk_rg_apollo_wlanDevBasedCVlanId_set(0,j,setPVid);
						assert_ok(ret);
					}
				}
			}
#endif

			//1 FIXME: in 6266, port and protocol based VLAN do not have extension port settings!!
		}
	}

	//Clear up proto block vlan if not needed anymore
	if(rg_db.systemGlobal.vlan_proto_block_created==1 && VLANProtoBlockUsed==0)
	{
		ret=RTK_VLAN_DESTROY(rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block);
		assert_ok(ret);
		rg_db.systemGlobal.vlan_proto_block_created=0;
	}

	//20180801LUKE: for multiple LAN interface with wifi, all of them should enable wlan device member.
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
	{
		int j,lanVid=rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id;
		if(rg_db.vlan[lanVid].Ext_portmask.bits[0]&RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK)
		{
			//Assign device-based VID to WLAN0's devices
			for(j=0;j<MAX_WLAN_DEVICE_NUM;j++)
			{
				if(rg_db.systemGlobal.wlan0BindDecision[j].exist)
				{
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
					if(j==RG_WWAN_WLAN0_VXD || j==RG_WWAN_WLAN1_VXD)continue;
#endif
					//Add this device to setPVid's Wlan0DevMask
					rg_db.vlan[lanVid].wlan0DevMask|=(0x1<<j);
					if(rg_db.vlan[lanVid].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))
						rg_db.vlan[lanVid].wlan0UntagMask|=(0x1<<j);
					else
						rg_db.vlan[lanVid].wlan0UntagMask&=(~(0x1<<j));
				}else{
					//Remove this device to setPVid's Wlan0DevMask
					rg_db.vlan[lanVid].wlan0DevMask&=(~(0x1<<j));
					rg_db.vlan[lanVid].wlan0UntagMask|=(0x1<<j);
				}
			}
		}
	}
#endif

	return (RT_ERR_RG_OK);
}

void _rtk_rg_deletingPortBindFromInterface(int intfIdx)
{
	int i;
	rtk_binding_entry_t pbindEt;
	rtk_rg_bindingEntry_t cb_bindEt;

	if(intfIdx<0 || intfIdx>=MAX_NETIF_SW_TABLE_SIZE)return;

	//clear all binding rules for this intfIdx
	for(i=MAX_BIND_SW_TABLE_SIZE - 1;i>=0;i--)
	{
		if(rg_db.bind[i].valid && rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx == intfIdx)
		{
			bzero(&pbindEt, sizeof(rtk_binding_entry_t));
			bzero(&cb_bindEt,sizeof(rtk_rg_bindingEntry_t));
			if(rg_db.bind[i].rtk_bind.vidLan == 0)	//vlan != 0 means port-vlan binding, which we don't care here
			{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
				if(rg_db.systemGlobal.interfaceInfo[intfIdx].valid > IF_VALID_ENTRY)
				{
					int iterPort=0;
					for(iterPort=RTK_RG_MAC_PORT0; iterPort<RTK_RG_MAC_PORT_MAX-1; iterPort++)
					{
						if(RG_INVALID_MAC_PORT(iterPort)) continue;
						if(rg_db.bind[i].rtk_bind.portMask.bits[0] &  (1<<iterPort))
						{
							_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP + iterPort);
							WARNING("ReservedRuleDel Port Bind trap Port=%d",iterPort);
						}
					}
				}
#endif

				cb_bindEt.port_bind_pmask.portmask=rg_db.bind[i].rtk_bind.portMask.bits[0];

				assert_ok(RTK_L34_BINDINGTABLE_SET(i, &pbindEt));

				// TODO:Call the initParam's bindingDelByHwCallBack
				if(rg_db.systemGlobal.initParam.bindingDelByHwCallBack != NULL)
				{
					cb_bindEt.type=BIND_TYPE_PORT;
					cb_bindEt.wan_intf_idx=intfIdx;
					rg_db.systemGlobal.initParam.bindingDelByHwCallBack(&cb_bindEt);
				}
			}
		}
	}
}

int32 _rtk_rg_addBindFromPortmask(unsigned int pmsk, unsigned int expmsk, int intfIdx, int wantypeIdx, int v6WantypeIdx)
{
	int i,j,ret,errorno,count=0,v6bindIdx=-1,addV6Bind=0;
	rtk_binding_entry_t pbindEt;
	rtk_rg_bindingEntry_t cb_bindEt;
	unsigned int tmppmsk=pmsk, tmpexpmsk=expmsk;

	//MAC Port
	count=tmppmsk;
	RG_ONE_COUNT(count);
	//DEBUG("MAC port count is %d",count);
	for(j=0;j<count;j++)
	{
		addV6Bind=0;
		v6bindIdx=-1;
ADD_PORT_FOR_V6:
		errorno=RT_ERR_RG_ENTRY_FULL;
		for(i=MAX_BIND_SW_TABLE_SIZE - 1;i>=0;i--)		//Port-binding start from the bottom of Binding Table
		{
			if(rg_db.bind[i].valid == 0)
				break;
		}
		if(i==-1)goto RET_BINDING_ERR;

		if(v6bindIdx<0)v6bindIdx = i;		//Keep
		//DEBUG("%d is available",i);
		//rg_db.systemGlobal.bindToIntf[bindIdx]=intfIdx;

		//Add port binding entry once a time
		errorno=RT_ERR_RG_PORT_BIND_SET_FAIL;
		bzero(&pbindEt, sizeof(rtk_binding_entry_t));
		pbindEt.extPortMask.bits[0]=0;
		pbindEt.vidLan=0;
		if(addV6Bind)
		{
			//we should change previous bind rule to v6 and add new v4 entry!(v4 upper than v6)
			rg_db.bind[v6bindIdx].rtk_bind.bindProto=L34_BIND_PROTO_NOT_IPV4;	//v6 and other
			rg_db.bind[v6bindIdx].rtk_bind.wanTypeIdx=v6WantypeIdx;
			ret = RTK_L34_BINDINGTABLE_SET(v6bindIdx, &rg_db.bind[v6bindIdx].rtk_bind);
			if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
			{
				errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
				goto RET_BINDING_ERR;
			}
			if(ret!=RT_ERR_OK)goto RET_BINDING_ERR;

			pbindEt.wanTypeIdx=wantypeIdx;
			pbindEt.bindProto=L34_BIND_PROTO_NOT_IPV6;		//v4 and other
		}
		else
		{
			pbindEt.wanTypeIdx=wantypeIdx;
			pbindEt.bindProto=L34_BIND_PROTO_ALL;		//ALL protocol in L3, and L2
		}

		//DEBUG("before: tmppmsk is %x",tmppmsk);
		if((tmppmsk&(0x1<<RTK_RG_PORT0)) >0)			//PORT0
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT0);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT0);
		}
		else if((tmppmsk&(0x1<<RTK_RG_PORT1)) >0)		//PORT1
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT1);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT1);
		}
#if !defined(CONFIG_RG_RTL9602C_SERIES)
		else if((tmppmsk&(0x1<<RTK_RG_PORT2)) >0)		//PORT2
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT2);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT2);
		}
		else if((tmppmsk&(0x1<<RTK_RG_PORT3)) >0)		//PORT3
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT3);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT3);
		}
#if !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
		else if((tmppmsk&(0x1<<RTK_RG_PORT_RGMII)) >0)		//PORT5
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT_RGMII);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT_RGMII);
		}
#endif //end !CONFIG_RG_G3_SERIES
#endif //end !CONFIG_RG_RTL9602C_SERIES
#if defined(CONFIG_RG_RTL9607C_SERIES)
		else if((tmppmsk&(0x1<<RTK_RG_PORT4)) >0)
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT4);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT4);
		}
#endif
		else if((tmppmsk&(0x1<<RTK_RG_PORT_PON)) >0)		//PORT4
		{
			tmppmsk&=~(0x1<<RTK_RG_PORT_PON);
			pbindEt.portMask.bits[0]=(0x1<<RTK_RG_PORT_PON);
		}

		else
			continue;
		ret = RTK_L34_BINDINGTABLE_SET(i, &pbindEt);
		if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
		{
			errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
			goto RET_BINDING_ERR;
		}
		if(ret!=RT_ERR_OK)goto RET_BINDING_ERR;


#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		if((v6bindIdx!=-1 && rg_db.bind[v6bindIdx].valid==SOFTWARE_ONLY_ENTRY) ||
			rg_db.bind[i].valid == SOFTWARE_ONLY_ENTRY ||
			((MAX_NETIF_HW_TABLE_SIZE <=intfIdx)  && (intfIdx<MAX_NETIF_SW_TABLE_SIZE)))
		{
			int iterPort=0;
			for(iterPort=RTK_RG_MAC_PORT0; iterPort<RTK_RG_MAC_PORT_MAX-1; iterPort++)
			{
				if(RG_INVALID_MAC_PORT(iterPort)) continue;
				if(pbindEt.portMask.bits[0] &  (1<<iterPort))
				{
					_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP + iterPort, NULL);
					WARNING("ReservedRuleAdd Port Bind trap Port=%d",iterPort);
				}
			}
		}
#endif


		// TODO:Call the initParam's bindingAddByHwCallBack
		if(!addV6Bind && rg_db.systemGlobal.initParam.bindingAddByHwCallBack != NULL)
		{
			cb_bindEt.type=BIND_TYPE_PORT;
			cb_bindEt.port_bind_pmask.portmask=pbindEt.portMask.bits[0];
			cb_bindEt.wan_intf_idx=intfIdx;
			rg_db.systemGlobal.initParam.bindingAddByHwCallBack(&cb_bindEt);
		}
		//20140806LUKE: if we have ipv6 wanType, we should create one more bind for it!!
		if(!addV6Bind && v6WantypeIdx!=FAIL)
		{
			addV6Bind=1;
			tmppmsk|=pbindEt.portMask.bits[0];
			goto ADD_PORT_FOR_V6;
		}
	}

	//Extension port
	count=tmpexpmsk;
	RG_ONE_COUNT(count);
	for(j=0;j<count;j++)
	{
		addV6Bind=0;
		v6bindIdx=-1;
ADD_EXTPORT_FOR_V6:
		errorno=RT_ERR_RG_ENTRY_FULL;
		for(i=MAX_BIND_SW_TABLE_SIZE - 1;i>=0;i--)		//Port-binding start from the bottom of Binding Table
		{
			if(rg_db.bind[i].valid == 0)
				break;
		}
		if(i==-1)goto RET_BINDING_ERR;

		if(v6bindIdx<0)v6bindIdx = i;		//Keep
		//DEBUG("%d is available",i);
		//rg_db.systemGlobal.bindToIntf[bindIdx]=intfIdx;

		//Add port binding entry once a time
		errorno=RT_ERR_RG_EXTPORT_BIND_SET_FAIL;
		bzero(&pbindEt, sizeof(rtk_binding_entry_t));
		pbindEt.portMask.bits[0]=0;
		pbindEt.vidLan=0;
		if(addV6Bind)
		{
			//we should change previous bind rule to v6 and add new v4 entry!(v4 upper than v6)
			rg_db.bind[v6bindIdx].rtk_bind.bindProto=L34_BIND_PROTO_NOT_IPV4;	//v6 and other
			rg_db.bind[v6bindIdx].rtk_bind.wanTypeIdx=v6WantypeIdx;
			ret = RTK_L34_BINDINGTABLE_SET(v6bindIdx, &rg_db.bind[v6bindIdx].rtk_bind);
			if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
			{
				errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
				goto RET_BINDING_ERR;
			}
			if(ret!=RT_ERR_OK)goto RET_BINDING_ERR;

			pbindEt.wanTypeIdx=wantypeIdx;
			pbindEt.bindProto=L34_BIND_PROTO_NOT_IPV6;		//v4 and other
		}
		else
		{
			pbindEt.wanTypeIdx=wantypeIdx;
			pbindEt.bindProto=L34_BIND_PROTO_ALL;		//ALL protocol in L3, and L2
		}

		//DEBUG("before: tmpexpmsk is %x",tmpexpmsk);
		if((tmpexpmsk&(0x1<<(RTK_RG_EXT_PORT0-RTK_RG_EXT_PORT0))) >0)			//EXTPORT0
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_EXT_PORT0-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_EXT_PORT0);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_EXT_PORT1-RTK_RG_EXT_PORT0))) >0)		//EXTPORT1
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_EXT_PORT1-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_EXT_PORT1);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_EXT_PORT2-RTK_RG_EXT_PORT0))) >0)		//EXTPORT2
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_EXT_PORT2-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_EXT_PORT2);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_EXT_PORT3-RTK_RG_EXT_PORT0))) >0)		//EXTPORT3
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_EXT_PORT3-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_EXT_PORT3);
		}
#if !defined(CONFIG_RG_G3_SERIES)
		else if((tmpexpmsk&(0x1<<(RTK_RG_EXT_PORT4-RTK_RG_EXT_PORT0))) >0)		//EXTPORT4
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_EXT_PORT4-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_EXT_PORT4);
		}
#endif
#if !defined(CONFIG_RG_RTL9600_SERIES) && !defined(CONFIG_RG_G3_SERIES)
		else if((tmpexpmsk&(0x1<<(RTK_RG_EXT_PORT5-RTK_RG_EXT_PORT0))) >0)		//EXTPORT5
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_EXT_PORT5-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_EXT_PORT5);
		}
#endif
#if defined(CONFIG_RG_RTL9607C_SERIES)
		//MAC 10
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC10_EXT_PORT0-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC10_EXT_PORT0-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC10_EXT_PORT0);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC10_EXT_PORT1-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC10_EXT_PORT1-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC10_EXT_PORT1);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC10_EXT_PORT2-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC10_EXT_PORT2-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC10_EXT_PORT2);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC10_EXT_PORT3-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC10_EXT_PORT3-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC10_EXT_PORT3);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC10_EXT_PORT4-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC10_EXT_PORT4-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC10_EXT_PORT4);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC10_EXT_PORT5-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC10_EXT_PORT5-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC10_EXT_PORT5);
		}
		//MAC 7
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC7_EXT_PORT0-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC7_EXT_PORT0-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC7_EXT_PORT0);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC7_EXT_PORT1-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC7_EXT_PORT1-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC7_EXT_PORT1);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC7_EXT_PORT2-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC7_EXT_PORT2-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC7_EXT_PORT2);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC7_EXT_PORT3-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC7_EXT_PORT3-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC7_EXT_PORT3);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC7_EXT_PORT4-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC7_EXT_PORT4-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC7_EXT_PORT4);
		}
		else if((tmpexpmsk&(0x1<<(RTK_RG_MAC7_EXT_PORT5-RTK_RG_EXT_PORT0))) >0)
		{
			tmpexpmsk&=~(0x1<<(RTK_RG_MAC7_EXT_PORT5-RTK_RG_EXT_PORT0));
			pbindEt.extPortMask.bits[0]=(0x1<<RTK_RG_BD_MAC7_EXT_PORT5);
		}
#endif
		else
			continue;
		ret = RTK_L34_BINDINGTABLE_SET(i, &pbindEt);
		if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
		{
			errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
			goto RET_BINDING_ERR;
		}
		if(ret!=RT_ERR_OK)goto RET_BINDING_ERR;


		// TODO:Call the initParam's bindingAddByHwCallBack
		if(!addV6Bind && rg_db.systemGlobal.initParam.bindingAddByHwCallBack != NULL)
		{
			cb_bindEt.type=BIND_TYPE_PORT;
			cb_bindEt.port_bind_pmask.portmask=pbindEt.extPortMask.bits[0];
			cb_bindEt.wan_intf_idx=intfIdx;
			rg_db.systemGlobal.initParam.bindingAddByHwCallBack(&cb_bindEt);
		}
		//20140806LUKE: if we have ipv6 wanType, we should create one more bind for it!!
		if(!addV6Bind && v6WantypeIdx!=FAIL)
		{
			addV6Bind=1;
			tmpexpmsk|=pbindEt.extPortMask.bits[0];
			goto ADD_EXTPORT_FOR_V6;
		}
	}

	return (RT_ERR_RG_OK);


RET_BINDING_ERR:
	//Delete each port-binding entry in binding table (vlan=0)
	_rtk_rg_deletingPortBindFromInterface(intfIdx);

	return (errorno);
}

int32 _rtk_rg_updatingVlanBind(int wanIdx,int v6wanTypeIdx)
{
	int i,j,ret,wanTypeIdx;
	rtk_binding_entry_t pbindEt;

	wanTypeIdx=rg_db.systemGlobal.interfaceInfo[wanIdx].storedInfo.wan_intf.bind_wan_type_ipv4;
	DEBUG("wanTypeIdx is %d ,v6wanTypeIdx is %d",wanTypeIdx,v6wanTypeIdx);
	if(v6wanTypeIdx>=0)	//change ALL to V4andOther, create v6andOther
	{
		for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
		{
			if(rg_db.bind[i].valid && rg_db.bind[i].rtk_bind.vidLan!=0 &&
				rg_db.bind[i].rtk_bind.bindProto==L34_BIND_PROTO_ALL &&
				rg_db.bind[i].rtk_bind.wanTypeIdx==wanTypeIdx)
			{
				//find a valid one for v6bind
				for(j=0;j<MAX_BIND_SW_TABLE_SIZE;j++)
				{
					if(!rg_db.bind[j].valid)
						break;
				}
				if(j==MAX_BIND_SW_TABLE_SIZE)RETURN_ERR(RT_ERR_RG_ENTRY_FULL);

				memcpy(&pbindEt,&rg_db.bind[i].rtk_bind,sizeof(rtk_binding_entry_t));
				pbindEt.bindProto=L34_BIND_PROTO_NOT_IPV6;
				ret = RTK_L34_BINDINGTABLE_SET(i, &pbindEt);
				if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
				if(ret!=RT_ERR_OK)RETURN_ERR(ret);
				DEBUG("change bind[%d] to v4andOther!",i);

				pbindEt.wanTypeIdx=v6wanTypeIdx;
				pbindEt.bindProto=L34_BIND_PROTO_NOT_IPV4;
				ret = RTK_L34_BINDINGTABLE_SET(j, &pbindEt);
				if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
				if(ret!=RT_ERR_OK)RETURN_ERR(ret);
				rg_db.systemGlobal.vlanBindTotalNum++;
				DEBUG("add bind[%d] to v6andOther!",j);
			}
		}
	}
	else	//delete v6andOther, recovery v4andOther to ALL
	{
		for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
		{
			if(rg_db.bind[i].valid && rg_db.bind[i].rtk_bind.vidLan!=0 &&
				rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx==wanIdx)
			{
				if(rg_db.bind[i].rtk_bind.bindProto==L34_BIND_PROTO_NOT_IPV4)
				{
					//delete v6bind
					memset(&pbindEt,0,sizeof(rtk_binding_entry_t));
					ret = RTK_L34_BINDINGTABLE_SET(i, &pbindEt);
					if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
					if(ret!=RT_ERR_OK)RETURN_ERR(ret);
					if(rg_db.systemGlobal.vlanBindTotalNum>0)
						rg_db.systemGlobal.vlanBindTotalNum--;
					DEBUG("delete bind[%d] to v6andOther!",i);
				}
				else if(rg_db.bind[i].rtk_bind.bindProto==L34_BIND_PROTO_NOT_IPV6)
				{
					//recovery v4bind
					rg_db.bind[i].rtk_bind.bindProto=L34_BIND_PROTO_ALL;
					ret = RTK_L34_BINDINGTABLE_SET(i, &rg_db.bind[i].rtk_bind);
					if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
					if(ret!=RT_ERR_OK)RETURN_ERR(ret);
					DEBUG("change bind[%d] to all!",i);
				}
			}
		}
	}

	return (RT_ERR_RG_OK);
}


int32 _rtk_rg_deleteSwARP(int intfIdx, int routingIdx)
{
	int i;
	rtk_rg_arp_linkList_t *pSwArpList,*pNextSwArpList;

	for(i=0;i<MAX_ARP_SW_TABLE_HEAD;i++)
	{
		if(!list_empty(&rg_db.softwareArpTableHead[i]))
		{
			list_for_each_entry_safe(pSwArpList,pNextSwArpList,&rg_db.softwareArpTableHead[i],arp_list)
			{
				if(rg_db.arp[pSwArpList->idx].routingIdx==routingIdx)
				{
					_rtk_rg_softwareArpTableDel(pSwArpList);

				}
			}
		}
	}

	return (RT_ERR_RG_OK);
}

int _rtk_rg_deleteIPv4ArpByRouting(int routeIdx, int lan_or_wan_intf_idx)
{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Delete the ARP table entries referenced by routing table
	_rtk_rg_deleteSwARP(lan_or_wan_intf_idx,routeIdx);
#elif defined(CONFIG_RG_RTL9600_SERIES)
	int i,ret;
	int count=0,l2Idx,search_index;
	rtk_rg_macEntry_t secondMacEt;
	rtk_rg_table_arp_t *pArpInfo;
	for(i=(rg_db.l3[routeIdx].rtk_l3.arpStart<<2);i<((rg_db.l3[routeIdx].rtk_l3.arpEnd+1)<<2);i++)
	{
		//bzero(&macEt, sizeof(rtk_rg_macEntry_t));
		bzero(&secondMacEt, sizeof(rtk_rg_macEntry_t));
		//bzero(&arpInfo,sizeof(rtk_rg_table_arp_t));
		count=0;
		pArpInfo=&rg_db.arp[i];
		if(pArpInfo->rtk_arp.valid==0)
			continue;
		//Delete LUT table entries referenced by ARP:
		//If the VLAN is IVL, find if there is SVL LUT, delete it also, and vice versa.
		//20140728LUKE: static LUT should keep in system
		if(rg_db.lut[pArpInfo->rtk_arp.nhIdx].valid && rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entryType==RTK_LUT_L2UC && (rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0 &&  _rtk_rg_lut_is_sw_static(pArpInfo->rtk_arp.nhIdx)==FALSE)
		{
			//Check fidmode
			if(rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)
			{
				//delete SVL, too
				secondMacEt.isIVL=0;
				secondMacEt.fid=rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.fid;
				//DEBUG("the SVL(%d) lut has to be deleted,too",secondMacEt.fid);
				l2Idx=_rtk_rg_hash_mac_fid_efid(rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.mac.octet,secondMacEt.fid,rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.efid);
			}
			else
			{
				//delete IVL, too
				secondMacEt.isIVL=1;

				//because the SVL LUT will set VID as 0 if untag, therefore VLAN ID should get for interface setting
				if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1)	//wan interface
					secondMacEt.vlan_id = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
				else	//lan interface
					secondMacEt.vlan_id = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->intf_vlan_id;
				//DEBUG("the IVL(%d) lut has to be deleted,too",secondMacEt.vlan_id);
				l2Idx=_rtk_rg_hash_mac_vid_efid(rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.mac.octet,secondMacEt.vlan_id,rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.efid);
			}
			l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
	   		do
			{
				search_index = l2Idx+count;
				//DEBUG("search_idx is %d",search_index);
				if(rg_db.lut[search_index].valid==0)
				{
					count++;
					continue;	//empty
				}

				if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
					(!memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,rg_db.lut[pArpInfo->rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)))
				{
					if((secondMacEt.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==secondMacEt.vlan_id) ||
						(secondMacEt.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==secondMacEt.fid))
					{
						//DEBUG("%s MAC is exist @ %d, deleting...",secondMacEt.isIVL?"IVL":"SVL",search_index);
						(pf.rtk_rg_macEntry_del)(search_index);
						break;
					}
				}

				count++; //search from next entry
			}
			while(count < MAX_LUT_HASH_WAY_SIZE);

			//Delete original one
			ret = (pf.rtk_rg_macEntry_del)(pArpInfo->rtk_arp.nhIdx);
			//if the MAC is not exist, continue
			//if(ret!=RT_ERR_RG_OK)return ret;
		}

		if(rg_db.arp[i].rtk_arp.valid!=0)
		{
			ret = rtk_rg_apollo_arpEntry_del(i);
			if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);
		}
	}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
	//Delete the ARP table entries referenced by routing table
	_rtk_rg_deleteHwARP(lan_or_wan_intf_idx,routeIdx);
	_rtk_rg_deleteSwARP(lan_or_wan_intf_idx,routeIdx);
#endif
	return (RT_ERR_RG_OK);
}

int32 _rtk_rg_deleteIPv4Routing(int lan_or_wan_intf_idx)
{
	int i,j,ret;
	int nh_num,match_intf=0,deleteL3Idx=-1;
#if defined(CONFIG_RG_RTL9600_SERIES)
	rtk_rg_routing_arpInfo_t deletingEntry;
#endif
	rtk_l34_routing_entry_t rtEntry;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;

	for(i=0; i<MAX_L3_SW_TABLE_SIZE; i++)
    {
		if(i== V4_DEFAULT_ROUTE_IDX)
			continue;
#ifdef CONFIG_DUALBAND_CONCURRENT
        if(i==SLAVE_WIFI_ROUTE_IDX)	//ipc routing should not be deleted at any time!
			continue;
#endif
		//20170525LUKE: we should not delete static route's routing entry here.
		for(j=0;j<MAX_STATIC_ROUTE_SIZE;j++)if(rg_db.staticRoute[j].valid&&rg_db.staticRoute[j].route_idx==i)break;
		if(j!=MAX_STATIC_ROUTE_SIZE)continue;
		//Delete the ARP table entries referenced by routing table
        if(rg_db.l3[i].rtk_l3.process == L34_PROCESS_ARP && rg_db.l3[i].rtk_l3.netifIdx == lan_or_wan_intf_idx)
        {
        	_rtk_rg_deleteIPv4ArpByRouting(i, lan_or_wan_intf_idx);
#if defined(CONFIG_RG_RTL9600_SERIES)
            //Deleting the routing entry
            bzero(&deletingEntry, sizeof(rtk_rg_routing_arpInfo_t));
            deletingEntry.routingIdx=i;
			if(rg_db.l3[i].rtk_l3.rt2waninf)		//routing to WAN
				deletingEntry.isLan=0;
			else
				deletingEntry.isLan=1;
			deletingEntry.bitNum=31-rg_db.l3[i].rtk_l3.ipMask;
			deletingEntry.arpStart=rg_db.l3[i].rtk_l3.arpStart;
			deletingEntry.arpEnd=rg_db.l3[i].rtk_l3.arpEnd;
#endif
            bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
			bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
			cb_routEt.dest_ip=rg_db.l3[i].rtk_l3.ipAddr;
			cb_routEt.ip_mask=rg_db.l3[i].netmask;
            ret = RTK_L34_ROUTINGTABLE_SET(i, &rtEntry);
            if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);
			deleteL3Idx = i;
#if defined(CONFIG_RG_RTL9600_SERIES)
			//Rerrange ARP table
			ret=_rtk_rg_delArpRoutingArray(&deletingEntry);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);
#endif

			//2 Call the initParam's routingDelByHwCallBack
			if(rg_db.systemGlobal.initParam.routingDelByHwCallBack != NULL)
			{
				cb_routEt.nexthop=0;
				cb_routEt.wan_intf_idx=lan_or_wan_intf_idx;
				rg_db.systemGlobal.initParam.routingDelByHwCallBack(&cb_routEt);
			}
        }
		else if(rg_db.l3[i].rtk_l3.process == L34_PROCESS_CPU && rg_db.l3[i].rtk_l3.ipAddr>0 && rg_db.l3[i].rtk_l3.netifIdx == lan_or_wan_intf_idx)		//delete routing which added sw ARP table
		{
#ifdef CONFIG_APOLLO_MODEL
			rtlglue_printf("FIXME: Execute list_for_each_entry_safe() lead to segmentation fault @ %s %d\n",__FUNCTION__,__LINE__);
			continue;
#endif
			//Delete the ARP table entries referenced by routing table
			_rtk_rg_deleteSwARP(lan_or_wan_intf_idx,i);


#if 0	//no need to rerrange ARP table
			//Deleting the routing entry
            bzero(&deletingEntry, sizeof(rtk_rg_routing_arpInfo_t));
            deletingEntry.routingIdx=i;
			if(rg_db.l3[i].rtk_l3.rt2waninf)		//routing to WAN
				deletingEntry.isLan=0;
			else
				deletingEntry.isLan=1;
			deletingEntry.bitNum=31-rg_db.l3[i].rtk_l3.ipMask;
			deletingEntry.arpStart=rg_db.l3[i].rtk_l3.arpStart;
			deletingEntry.arpEnd=rg_db.l3[i].rtk_l3.arpEnd;
#endif
            bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
			bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
			cb_routEt.dest_ip=rg_db.l3[i].rtk_l3.ipAddr;
			cb_routEt.ip_mask=rg_db.l3[i].netmask;
            ret = RTK_L34_ROUTINGTABLE_SET(i, &rtEntry);
            if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);
			deleteL3Idx = i;

			//no need to rerrange ARP table
			//ret=_rtk_rg_delArpRoutingArray(&deletingEntry);
			//if(ret!=RT_ERR_OK)goto RET_ERR;

			//2 Call the initParam's routingDelByHwCallBack
			if(rg_db.systemGlobal.initParam.routingDelByHwCallBack != NULL)
			{
				cb_routEt.nexthop=0;
				cb_routEt.wan_intf_idx=lan_or_wan_intf_idx;
				rg_db.systemGlobal.initParam.routingDelByHwCallBack(&cb_routEt);
			}
		}
        else if(rg_db.l3[i].rtk_l3.process == L34_PROCESS_NH)
        {
        	//20140827LUKE: till setup STATIC ROUTE, we will create sw-ARP when asking remote server, delete it now!!
			_rtk_rg_deleteSwARP(lan_or_wan_intf_idx,i);

        	//2 FIXME:if load-balance is used, then here should modified for it!!
            //Lookup Nexthop table for checking related interface
            nh_num = rg_db.l3[i].rtk_l3.nhStart;
			nh_num += (0x1<<rg_db.l3[i].rtk_l3.nhNum);
            if(nh_num > MAX_NEXTHOP_SW_TABLE_SIZE || nh_num<0)RETURN_ERR(RT_ERR_RG_NXP_GET_FAIL);

			match_intf=0;
            for(j=rg_db.l3[i].rtk_l3.nhStart; j<nh_num; j++)
            {
            	//20171013LUKE: check if we have original WAN index in mask for deleting routing entry reference.
            	if(rg_db.nexthop[j].staticRouteWanIdxMask)
            	{
					if(rg_db.nexthop[j].staticRouteWanIdxMask&(0x1<<lan_or_wan_intf_idx))
	            	{
	            		ret=_rtk_rg_decreaseNexthopReference(j);
						if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);

	                    match_intf=1;//match_intf++;
	                    rg_db.nexthop[j].staticRouteWanIdxMask=0x0;
	            	}
					continue;	//different, bypass to next nexthop.
            	}
                if(rg_db.nexthop[j].rtk_nexthop.ifIdx == lan_or_wan_intf_idx)
                {
                	ret=_rtk_rg_decreaseNexthopReference(j);
					if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);

                    match_intf=1;//match_intf++;
                }
            }

            //Deleting the routing entry
            if(match_intf == 1)//if(match_intf == (nh_num-rtEntry.nhStart))
            {
                bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
				bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
				cb_routEt.dest_ip=rg_db.l3[i].rtk_l3.ipAddr;
				cb_routEt.ip_mask=rg_db.l3[i].netmask;
                ret = RTK_L34_ROUTINGTABLE_SET(i, &rtEntry);
                if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);
				deleteL3Idx = i;

				//2 Call the initParam's routingDelByHwCallBack
				if(rg_db.systemGlobal.initParam.routingDelByHwCallBack != NULL)
				{
					cb_routEt.wan_intf_idx=lan_or_wan_intf_idx;
					cb_routEt.nexthop=rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr;
					rg_db.systemGlobal.initParam.routingDelByHwCallBack(&cb_routEt);
				}
            }
        }
    }

	//Delete Internal External IP table entry, if any,decrease Nexthop table ref count, if zero delete nexthop entry
    if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1 &&
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_BRIDGE)
    {
		//Reset Default route to CPU if ipv4_default_gateway_on is 1
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv4_default_gateway_on == 1)
		{
			bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
			bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
			rtEntry.process=L34_PROCESS_CPU;
			rtEntry.valid=1;

			//20140808LUKE: if we delete default route WAN, decrease nexthop counter here!
    		if(rg_db.l3[V4_DEFAULT_ROUTE_IDX].rtk_l3.process==L34_PROCESS_NH)
    		{
    			ret=_rtk_rg_decreaseNexthopReference(rg_db.l3[V4_DEFAULT_ROUTE_IDX].rtk_l3.nhStart);
				if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);
    		}

            ret = RTK_L34_ROUTINGTABLE_SET(V4_DEFAULT_ROUTE_IDX, &rtEntry);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);
		}

	    if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->napt_enable ||
			(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv4_default_gateway_on==0 && rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr!=0))
	    {
			//2 $$$$ Delete NAPTR, NAPT table with deleting interface by comparing NAPTR's EIP idx $$$$
			int eipidx=rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.extip_idx;
			for(i=0;i<MAX_NAPT_OUT_SW_TABLE_SIZE;i++)
				if(rg_db.naptOut[i].rtk_naptOut.valid && rg_db.naptIn[rg_db.naptOut[i].rtk_naptOut.hashIdx].rtk_naptIn.extIpIdx==rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.extip_idx)
					rtk_rg_apollo_naptConnection_del(i);

			if(eipidx>=0)
			{
				ret=_rtk_rg_decreaseNexthopReference(rg_db.extip[eipidx].rtk_extip.nhIdx);
				if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);

				//20150609LUKE: we have to clear interface's eipidx in rg_db, too.
				//20200409LUKE: decrease EIP refCnt here.
				ret=_rtk_rg_decreaseExtIPReference(eipidx);
				if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_EXTIP_SET_FAIL);
				rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.extip_idx=-1;
			}

			//20140807LUKE: modify wanType's type when deleting
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4>=0 &&
				rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].valid)
			{
				rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype.wanType=L34_WAN_TYPE_L3_ROUTE;
				rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].valid=1;
		        ret = RTK_L34_WANTYPETABLE_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4, &rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype);
		        if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
		        if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_WANTYPE_SET_FAIL);
				DEBUG("change wanType[%d] to %d",rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4,rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype.wanType);
			}
	    }
    }

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid & IF_SOFTWARE4_ENTRY )
	{	//delete ipv4 reserved acl for software entry
		WARNING("delete software interface  netif=%d l3idx=%d ",lan_or_wan_intf_idx,deleteL3Idx);
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_RULE0_DIP_MASK_TRAP+deleteL3Idx);
	}
#endif

	return (RT_ERR_RG_OK);
}

int _rtk_rg_deleteIPv6NeighborByRouting(int routeIdx, int lan_or_wan_intf_idx)
{
	int i,ret/*,count,l2Idx,search_index*/;
	rtk_rg_neighborInfo_t neighborInfo;
	//rtk_rg_macEntry_t secondMacEt;

	for(i=0;i<MAX_IPV6_NEIGHBOR_SW_TABLE_SIZE;i++)
	{
		bzero(&neighborInfo, sizeof(rtk_rg_neighborInfo_t));
		//bzero(&secondMacEt, sizeof(rtk_rg_macEntry_t));
		//count=0;

		ret = rtk_rg_apollo_neighborEntry_find(&neighborInfo,&i);

		if(ret==RT_ERR_RG_NO_MORE_ENTRY_FOUND)		//neighbor after j is all invalid
			break;
		if(neighborInfo.neighborEntry.matchRouteIdx==routeIdx)
		{
			//Delete LUT table entries referenced by Neighbor
			ret = rtk_rg_apollo_neighborEntry_del(i);
			if(ret!=RT_ERR_RG_OK)return (ret);
#if 0	//do not delete LUT here, neighborEntry_del checks refcount and modifies arp_used if necessary.
			//If the VLAN is IVL, find if there is SVL LUT, delete it also, and vice versa.
			if(rg_db.lut[neighborInfo.neighborEntry.l2Idx].valid && rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entryType==RTK_LUT_L2UC)
			{
				//Check fidmode
				if(rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)
				{
					//delete SVL, too
					secondMacEt.isIVL=0;
					secondMacEt.fid=rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.fid;
					//DEBUG("the SVL(%d) lut has to be deleted,too",secondMacEt.fid);
					l2Idx=_rtk_rg_hash_mac_fid_efid(rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,secondMacEt.fid,rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.efid);
				}
				else
				{
					//delete IVL, too
					secondMacEt.isIVL=1;

					//because the SVL LUT will set VID as 0 if untag, therefore VLAN ID should get for interface setting
					if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1)	//wan interface
						secondMacEt.vlan_id = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
					else	//lan interface
						secondMacEt.vlan_id = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->intf_vlan_id;
					//DEBUG("the IVL(%d) lut has to be deleted,too",secondMacEt.vlan_id);
					l2Idx=_rtk_rg_hash_mac_vid_efid(rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,secondMacEt.vlan_id,rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.efid);
				}
				l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
		   		do
				{
					search_index = l2Idx+count;
					//DEBUG("search_idx is %d",search_index);
					if(rg_db.lut[search_index].valid==0)
					{
						count++;
						continue;	//empty
					}

					if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
						(!memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)))
					{
						if((secondMacEt.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==secondMacEt.vlan_id) ||
							(secondMacEt.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==secondMacEt.fid))
						{
							//DEBUG("%s MAC is exist @ %d, deleting...",secondMacEt.isIVL?"IVL":"SVL",search_index);
							(pf.rtk_rg_macEntry_del)(search_index);
							break;
						}
					}

					count++; //search from next entry
				}
				while(count < MAX_LUT_HASH_WAY_SIZE);
#if defined(CONFIG_RG_RTL9602C_SERIES)
				if(count==MAX_LUT_HASH_WAY_SIZE)
				{
					for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
					{
						if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
						{
							if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,rg_db.lut[neighborInfo.neighborEntry.l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN)==0)
							{
								if((secondMacEt.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==secondMacEt.vlan_id) ||
									(secondMacEt.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==secondMacEt.fid))
								{
									//DEBUG("%s MAC is exist @ %d, deleting...",secondMacEt.isIVL?"IVL":"SVL",search_index);
									(pf.rtk_rg_macEntry_del)(search_index);
									break;
								}
							}
						}
					}
				}
#endif
				//Delete original one
				ret = (pf.rtk_rg_macEntry_del)(neighborInfo.neighborEntry.l2Idx);
				//if L2 is not valid, do nothing
				//if(ret!=RT_ERR_RG_OK)return ret;
			}
#endif
		}
	}

	return (RT_ERR_RG_OK);
}

int32 _rtk_rg_deleteIPv6Routing(int lan_or_wan_intf_idx)
{
	int i,j,ret,deletev6l3Idx=-1;
	int nh_num,match_intf=0;
	rtk_ipv6Routing_entry_t rtv6Entry;
	rtk_rg_ipv6RoutingEntry_t cb_routv6Et;
	rtk_wanType_entry_t wantEt;
	unsigned int tmppmsk,tmpexpmsk;
	rtk_portmask_t out_mac_pmask,out_ext_pmask;

	for(i=0; i<MAX_IPV6_ROUTING_SW_TABLE_SIZE; i++)
	{
		if(i == V6_DEFAULT_ROUTE_IDX)
			continue;
		//20170525LUKE: we should not delete static route's routing entry here.
		for(j=0;j<MAX_STATIC_ROUTE_SIZE;j++)if(rg_db.staticRoute[j].valid&&rg_db.staticRoute[j].route_idx==i)break;
		if(j!=MAX_STATIC_ROUTE_SIZE)continue;
		if(rg_db.v6route[i].rtk_v6route.valid)
		{
			if((rg_db.v6route[i].rtk_v6route.type == L34_IPV6_ROUTE_TYPE_LOCAL || rg_db.v6route[i].rtk_v6route.type == L34_IPV6_ROUTE_TYPE_TRAP) && rg_db.v6route[i].rtk_v6route.nhOrIfidIdx == lan_or_wan_intf_idx)		//FIXME:the trap routing entry need to be deleted
			{
				//Delete the Neighbor table entries referenced by routing table
				ret=_rtk_rg_deleteIPv6NeighborByRouting(i,lan_or_wan_intf_idx);
				if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);

				//Deleting the routing entry
				bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
				bzero(&cb_routv6Et, sizeof(rtk_rg_ipv6RoutingEntry_t));
				memcpy(cb_routv6Et.dest_ip.ipv6_addr,rg_db.v6route[i].rtk_v6route.ipv6Addr.ipv6_addr,IPV6_ADDR_LEN);
				cb_routv6Et.prefix_len=rg_db.v6route[i].rtk_v6route.ipv6PrefixLen;
				cb_routv6Et.NhOrIntfIdx=rg_db.v6route[i].rtk_v6route.nhOrIfidIdx;
				cb_routv6Et.type=rg_db.v6route[i].rtk_v6route.type;
				ret = RTK_L34_IPV6ROUTINGTABLE_SET(i, &rtv6Entry);
				deletev6l3Idx = i;
				if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);

				//2 Call the initParam's v6routingDelByHwCallBack
				if(rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack != NULL)
				{
					rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack(&cb_routv6Et);
				}
			}
			else if(rg_db.v6route[i].rtk_v6route.type == L34_IPV6_ROUTE_TYPE_GLOBAL)		//nexthop
			{
				//20220210LUKE:initialize match_intf otherwise the previous decision may affect following routing entry
				match_intf=0;

				//Lookup Nexthop table for checking related interface
				nh_num = rg_db.v6route[i].rtk_v6route.nhOrIfidIdx;

				if(nh_num >= MAX_NEXTHOP_SW_TABLE_SIZE || nh_num<0 )RETURN_ERR(RT_ERR_RG_NXP_GET_FAIL);

				if(rg_db.nexthop[nh_num].rtk_nexthop.ifIdx == lan_or_wan_intf_idx)
				{
					ret=_rtk_rg_decreaseNexthopReference(nh_num);
					if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);

					match_intf=1;
				}

				//Deleting the routing entry
				if(match_intf == 1)
				{
					//20140904LUKE: for STATIC ROUTE may have neighbor entry, so we should delete it right here!
					ret=_rtk_rg_deleteIPv6NeighborByRouting(i,lan_or_wan_intf_idx);
					if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);

					bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
					bzero(&cb_routv6Et, sizeof(rtk_rg_ipv6RoutingEntry_t));
					memcpy(cb_routv6Et.dest_ip.ipv6_addr,rg_db.v6route[i].rtk_v6route.ipv6Addr.ipv6_addr,IPV6_ADDR_LEN);
					cb_routv6Et.prefix_len=rg_db.v6route[i].rtk_v6route.ipv6PrefixLen;
					cb_routv6Et.NhOrIntfIdx=rg_db.v6route[i].rtk_v6route.nhOrIfidIdx;
					cb_routv6Et.type=rg_db.v6route[i].rtk_v6route.type;
					ret = RTK_L34_IPV6ROUTINGTABLE_SET(i, &rtv6Entry);
					deletev6l3Idx =i;
					if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);

					//2 Call the initParam's v6routingDelByHwCallBack
					if(rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack != NULL)
					{
						rg_db.systemGlobal.initParam.v6RoutingDelByHwCallBack(&cb_routv6Et);
					}
				}
			}
		}
	}

    if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1 &&
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_BRIDGE)
    {
    	//Delete wanType if added
    	DEBUG("wan[%d].bind_wan_type_ipv6 is %d",lan_or_wan_intf_idx,rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6);
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6>=0)
		{
			//update binding rules
			_rtk_rg_portmask_translator(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask,&out_mac_pmask,&out_ext_pmask);
			tmppmsk=out_mac_pmask.bits[0];
			tmpexpmsk=out_ext_pmask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
			tmpexpmsk >>= 0x1;	//FIXME:translator contain cpu port, but binding should not contain it, so shift it
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
			/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
			_rtk_rg_deletingPortBindFromInterface(lan_or_wan_intf_idx);
			ret=_rtk_rg_addBindFromPortmask(tmppmsk,tmpexpmsk,lan_or_wan_intf_idx,rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4,FAIL);
			if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);

			//update vlan-binding
			ret=_rtk_rg_updatingVlanBind(lan_or_wan_intf_idx,FAIL);
			if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);

			DEBUG("deleting ipv6 wantype[%d]!!",rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6);
			j = rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6].rtk_wantype.nhIdx;

	        bzero(&wantEt, sizeof(rtk_wanType_entry_t));
			rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6].valid =0;
	        ret = RTK_L34_WANTYPETABLE_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6, &wantEt);
	        if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
	        if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_WANTYPE_SET_FAIL);
			ret=_rtk_rg_decreaseNexthopReference(j);
			if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);

			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6=FAIL;
		}

		//Reset Default route to CPU if ipv6_default_gateway_on is 1
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv6_default_gateway_on == 1)
		{
			bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
			bzero(&cb_routv6Et, sizeof(rtk_rg_ipv6RoutingEntry_t));
			rtv6Entry.type=L34_IPV6_ROUTE_TYPE_TRAP;
			rtv6Entry.valid=1;
			cb_routv6Et.type=L34_IPV6_ROUTE_TYPE_TRAP;

			//20140807LUKE: if we delete default route WAN, decrease nexthop counter here!
    		if(rg_db.v6route[V6_DEFAULT_ROUTE_IDX].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_GLOBAL)
    		{
    			ret=_rtk_rg_decreaseNexthopReference(rg_db.v6route[V6_DEFAULT_ROUTE_IDX].rtk_v6route.nhOrIfidIdx);
				if(ret!=RT_ERR_RG_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);
    		}

			ret = RTK_L34_IPV6ROUTINGTABLE_SET(V6_DEFAULT_ROUTE_IDX,&rtv6Entry);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);
		}
    }

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid & IF_SOFTWARE6_ENTRY)
	{
		// v6patch delete acl
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_RULE0_DIPv6_MASK_TRAP+deletev6l3Idx);
		WARNING("Del software v6 routing entry deletev6l3Idx=%d  netif=%d",deletev6l3Idx,lan_or_wan_intf_idx);
	}
#endif

	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_lanInterface_add(rtk_rg_lanIntfConf_t *lan_info,int *intf_idx)
{
	int ret,vlan_exist=0,errorno=RT_ERR_RG_OK,tmpVid,/*tmpPVid,*/ipv4Enable=0,ipv6Enable=0,intfMatch=0/*,changeMTU=0*/;
	int i,intfIdx=-1,rtIdx=-1,rtv6Idx=-1,input_ipmsk;
	rtk_l34_netif_entry_t intfEntry;
	rtk_l34_routing_entry_t rtEntry;
	rtk_ipv6Routing_entry_t rtv6Entry;
	rtk_portmask_t ori_pmsk,ori_utmsk,ori_etpmsk;
	rtk_rg_table_vlan_t ori_vlanEntry;
	rtk_portmask_t out_mac_pmask,out_ext_pmask;
	rtk_portmask_t untag_mac_pmask;
	//rtk_portmask_t ori_CPU_member_mask,ori_CPU_untag_mask,ori_CPU_ext_mask;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;
	rtk_rg_ipv6RoutingEntry_t cb_routv6Et;
	//rtk_vlan_protoVlanCfg_t protoVlanCfg;
#if defined(CONFIG_RG_RTL9600_SERIES)
	rtk_rg_routing_arpInfo_t newAddingEntry;
#endif
	rtk_fidMode_t fidMode;
	uint8 zeroMac[ETHER_ADDR_LEN]={0};
	rtk_rg_ip_updated_t ip_update_state=NO_IP_UPDATED;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//apolloPro no need reserved ACL to support in this function.
#else
	rtk_rg_aclAndCf_reserved_type_t rsvType;
#endif
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//apolloPro will always trap if unhit flow
#else
	rtk_rg_aclAndCf_reserved_intf_linkLocal_trap_t	intf_link_local_trap_para;
#endif

	if(lan_info == NULL || intf_idx == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);

	DEBUG("ip_version=%d",lan_info->ip_version);
	DEBUG("gmac=%02x:%02x:%02x:%02x:%02x:%02x",lan_info->gmac.octet[0],lan_info->gmac.octet[1],lan_info->gmac.octet[2],lan_info->gmac.octet[3],lan_info->gmac.octet[4],lan_info->gmac.octet[5]);
	DEBUG("ip_addr=0x%x",lan_info->ip_addr);
	DEBUG("ip_network_mask=0x%x",lan_info->ip_network_mask);
	DEBUG("ipv6_addr=%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",lan_info->ipv6_addr.ipv6_addr[0],lan_info->ipv6_addr.ipv6_addr[1],lan_info->ipv6_addr.ipv6_addr[2],lan_info->ipv6_addr.ipv6_addr[3],lan_info->ipv6_addr.ipv6_addr[4],lan_info->ipv6_addr.ipv6_addr[5],lan_info->ipv6_addr.ipv6_addr[6],lan_info->ipv6_addr.ipv6_addr[7]
						,lan_info->ipv6_addr.ipv6_addr[8],lan_info->ipv6_addr.ipv6_addr[9],lan_info->ipv6_addr.ipv6_addr[10],lan_info->ipv6_addr.ipv6_addr[11],lan_info->ipv6_addr.ipv6_addr[12],lan_info->ipv6_addr.ipv6_addr[13],lan_info->ipv6_addr.ipv6_addr[14],lan_info->ipv6_addr.ipv6_addr[15]);
	DEBUG("ipv6_network_mask_length=%x",lan_info->ipv6_network_mask_length);
	DEBUG("port_mask=0x%x",lan_info->port_mask);
	DEBUG("untag_mask=0x%x",lan_info->untag_mask);
	DEBUG("intf_vlan_id=%d",lan_info->intf_vlan_id);
	DEBUG("vlan_based_pri_enable=%d",lan_info->vlan_based_pri_enable);
	DEBUG("vlan_based_pri=%d",lan_info->vlan_based_pri);
	DEBUG("mtu=%d",lan_info->mtu);
	DEBUG("isIVL=%d",lan_info->isIVL);
	DEBUG("replace_subnet=%d",lan_info->replace_subnet);
#if defined(CONFIG_RG_RTL9600_SERIES)
	DEBUG("add_sw_arp=%d",lan_info->add_sw_arp);
#endif

#if defined(CONFIG_RG_G3_SERIES)
	if(lan_info->replace_subnet==0 && rg_db.systemGlobal.lanIntfTotalNum>=MAX_LAN_INTERFACE_SIZE)
		RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
#endif

	//Checking for input parameter
	if(rg_db.systemGlobal.initParam.macBasedTagDecision && lan_info->isIVL)		//IVL can not be set when DMAC2CVID is trun on
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//Check VLAN init
	if(rg_db.systemGlobal.vlanInit==0)
		RETURN_ERR(RT_ERR_RG_NOT_INIT);
	if(lan_info->isIVL)
	{
		if(lan_info->intf_vlan_id<0 || lan_info->intf_vlan_id>=MAX_VLAN_HW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}
	else
	{
		if(lan_info->intf_vlan_id<0 || lan_info->intf_vlan_id>=MAX_VLAN_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}

	//Check IP version
	if(lan_info->ip_version<0 || lan_info->ip_version>=IPVER_END)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if((lan_info->ip_version==IPVER_V4ONLY || lan_info->ip_version==IPVER_V4V6) && lan_info->ip_network_mask>0)
		ipv4Enable=1;
	if((lan_info->ip_version==IPVER_V6ONLY || lan_info->ip_version==IPVER_V4V6) && lan_info->ipv6_network_mask_length>0)
		ipv6Enable=1;

	if(ipv4Enable==1 && (lan_info->ip_addr == 0 || lan_info->ip_network_mask == 0))
		ipv4Enable=0;//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(ipv6Enable==1)
	{
		if(lan_info->ipv6_network_mask_length==0)
			ipv6Enable=0;//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		else if(lan_info->ipv6_network_mask_length>128)	//interface route should not bigger than 128bit
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		else
		{
			//Check for valid IPv6 address
			if(*(unsigned int *)lan_info->ipv6_addr.ipv6_addr == 0 &&
				*(unsigned int *)(lan_info->ipv6_addr.ipv6_addr+4) == 0 &&
				*(unsigned int *)(lan_info->ipv6_addr.ipv6_addr+8) == 0 &&
				*(unsigned int *)(lan_info->ipv6_addr.ipv6_addr+12) == 0)
				//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
				ipv6Enable=0;
		}
	}
	if((ipv6Enable|ipv4Enable) && lan_info->gmac.octet[0] == 0 && lan_info->gmac.octet[1] == 0 && lan_info->gmac.octet[2] == 0 &&
		lan_info->gmac.octet[3] == 0 && lan_info->gmac.octet[4] == 0 && lan_info->gmac.octet[5] == 0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(lan_info->gmac.octet[0]&1)	//interface MAC can not use multicast address
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	if(lan_info->mtu==0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(lan_info->port_mask.portmask == 0 ||
		RG_INVALID_MAC_PORTMASK(lan_info->untag_mask.portmask) || //untag set didn't contain extension port
		lan_info->mtu == 0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(RG_INVALID_PORTMASK(lan_info->port_mask.portmask))
		WARNING("LAN port_mask(%x) is not valid");



	if((rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].valid && lan_info->intf_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_CPU) ||
#if !defined(CONFIG_RG_RTL9600_SERIES)
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN].valid && lan_info->intf_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN) ||
#endif
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block].valid && lan_info->intf_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block) ||
		(rg_db.systemGlobal.initParam.macBasedTagDecision==1 && (lan_info->intf_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET ||
		(lan_info->intf_vlan_id >= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		lan_info->intf_vlan_id <= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET))))
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);

	//20150309LUKE: always treat disabled pri as "-1"
	if(lan_info->vlan_based_pri_enable==RTK_RG_DISABLED)
		lan_info->vlan_based_pri=-1;
	else if(lan_info->vlan_based_pri<0 || lan_info->vlan_based_pri>7)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//20170213: if user didn't add CPU port, we set it to untagged
	if((lan_info->port_mask.portmask&RTK_RG_ALL_MASTER_CPU_PORTMASK)!=RTK_RG_ALL_MASTER_CPU_PORTMASK)
	{
		lan_info->port_mask.portmask|=RTK_RG_ALL_MASTER_CPU_PORTMASK;
		lan_info->untag_mask.portmask|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;
		DEBUG("forcely enable lan cpu port and set it to untagged, port_mask=0x%x, untag_mask=0x%x", lan_info->port_mask.portmask, lan_info->untag_mask.portmask);
	}

	//if(lan_info->intf_vlan_id >= DEFAULT_PPB_VLAN_START && lan_info->intf_vlan_id < (DEFAULT_PPB_VLAN_START+MAX_NETIF_SW_TABLE_SIZE))
		//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//different Lan interface can have same port
	/*for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
	{
		//Check if there is any LAN interface has the same port with the adding intf
		if((rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->port_mask.portmask&lan_info->port_mask.portmask) > 0)
			RETURN_ERR(RT_ERR_RG_PORT_USED);
	}*/
	tmpVid=lan_info->intf_vlan_id;
	if(tmpVid<0||tmpVid>=MAX_VLAN_SW_TABLE_SIZE)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
	{
		//Check if there is a LAN interface has the same information but IP setting with the adding intf
		if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_version==lan_info->ip_version &&
			!memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,lan_info->gmac.octet,ETHER_ADDR_LEN) &&
			rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->port_mask.portmask==lan_info->port_mask.portmask &&
			rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->untag_mask.portmask==lan_info->untag_mask.portmask &&
			rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id==lan_info->intf_vlan_id &&
			rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->vlan_based_pri_enable==lan_info->vlan_based_pri_enable &&
			rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->vlan_based_pri==lan_info->vlan_based_pri &&
			rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->isIVL==lan_info->isIVL)
		{
			intfMatch=1;

			//keep old interface index
			intfIdx=rg_db.systemGlobal.lanIntfGroup[i].index;

			//Check if IPv4_changed
			if(rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ip_addr != lan_info->ip_addr ||
				rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ip_network_mask != lan_info->ip_network_mask)
				ip_update_state=ONLY_IPV4_UPDATED;

			//Check if IPv6_changed
			if(memcmp(rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ipv6_addr.ipv6_addr,lan_info->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN) ||
				rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ipv6_network_mask_length != lan_info->ipv6_network_mask_length)
			{
				if(ip_update_state==ONLY_IPV4_UPDATED)
					ip_update_state=IPV4_IPV6_UPDATED;
				else
					ip_update_state=ONLY_IPV6_UPDATED;
			}

			if(ip_update_state==NO_IP_UPDATED)
			{
				DEBUG("all information are same with interface[%d], do nothing with IP.",intfIdx);
				ipv4Enable=0;
				ipv6Enable=0;
			}
			else
			{
				//20140702LUKE:Check if we are replace subnet this time!!
				if(lan_info->replace_subnet)
				{
					if(ip_update_state==ONLY_IPV4_UPDATED || ip_update_state==IPV4_IPV6_UPDATED)
					{
						DEBUG("change IPv4 settings only!! IPv4 enable is %d",ipv4Enable);
						//just delete IPv4 related setting, do v4_only procedure later
						if(ip_update_state==ONLY_IPV4_UPDATED)ipv6Enable=0;

						//20140702LUKE:when delete ARP if need, it should not convert software ARP to HW, since we are going to reset right after!
						rg_db.systemGlobal.intfIdxForReset=intfIdx;
						ret=_rtk_rg_deleteIPv4Routing(intfIdx);
						rg_db.systemGlobal.intfIdxForReset=-1;
						if(ret!=RT_ERR_RG_OK) RETURN_ERR(ret);

						//Clear software data structure
						rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ip_addr=0;
						rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ip_network_mask=0;
					}
					if(ip_update_state==ONLY_IPV6_UPDATED || ip_update_state==IPV4_IPV6_UPDATED)
					{
						DEBUG("change IPv6 settings only!! ipv6enable is %d",ipv6Enable);
						//just delete IPv6 related setting, do v6_only procedure later
						if(ip_update_state==ONLY_IPV6_UPDATED)ipv4Enable=0;

						ret=_rtk_rg_deleteIPv6Routing(intfIdx);
						if(ret!=RT_ERR_RG_OK) RETURN_ERR(ret);

						//Clear software data structure
						bzero(rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
						rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ipv6_network_mask_length=0;
					}
				}
				else
				{
					//Check if we are change v4 IP only without lan_info->replace_subnet
					if(ip_update_state==ONLY_IPV4_UPDATED)
					{
						//when add IPv4 subnet, IPv6 won't be count.
						ipv6Enable=0;
					}
					else	//ONLY_IPV6_UPDATED || IPV4_IPV6_UPDATED
					{
						//We don't support IPv6 for adding one more subnet with same interface right now.
						//Besides, add IPv4 more subnet and change IPv6 at same time is also illegal.
						RETURN_ERR(RT_ERR_RG_IPV6_LAN_MORE_SUBNET_FAIL);
					}
				}
			}
			break;
		}
	}

	//Check VLAN-binding use this VLAN or not
	for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
		if(rg_db.bind[i].valid && rg_db.bind[i].rtk_bind.vidLan==lan_info->intf_vlan_id)
			RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_VLANBINDING);
	//Check Customer VLAN use this VLAN or not
	if(rg_db.vlan[lan_info->intf_vlan_id].valid && rg_db.vlan[lan_info->intf_vlan_id].addedAsCustomerVLAN)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_CVLAN);

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	//20160524LUKE: check wlan-device existence
	_rtk_rg_check_wlan_device_exist_or_not();
#endif

	//rtlglue_printf("RTK RG lan add.....%d\n",RG_GLB_VLAN_INIT);
	//Transfer RG portmask to RTK portmask
	_rtk_rg_portmask_translator(lan_info->port_mask,&out_mac_pmask,&out_ext_pmask);

	//20140702LUKE:bypass create new interface since we are replace old IP settings or add one more IPv4 subnet!!
	if(intfMatch)goto CHECK_ROUTE;

	//Check interface table available or not
	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
	{
		//bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
		//ret = rtk_l34_netifTable_get(i, &intfEntry);
		//if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_INTF_GET_FAIL);

		//if(intfEntry.valid == 0)
		if(rg_db.systemGlobal.interfaceInfo[i].valid == IF_INVALID_ENTRY)
			break;
	}
	if(i==MAX_NETIF_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_ENTRY_FULL);

	intfIdx=i;		//keep

CHECK_ROUTE:
	//Check routing table available or not
	if(ipv4Enable==1)
	{
		rtIdx=MAX_L3_SW_TABLE_SIZE;
		for(i=0;i<MAX_L3_SW_TABLE_SIZE ;i++)	//because idx MAX_L3_SW_TABLE_SIZE-1 is reserved for default route
		{
			if(i== V4_DEFAULT_ROUTE_IDX)
				continue;
			//if(rg_db.l3[i].rtk_l3.valid == 0 && rtIdx==MAX_L3_SW_TABLE_SIZE)
				//rtIdx=i;		//keep the first valid entry
			if(rg_db.l3[i].rtk_l3.valid == 0)
			{
				rtIdx=i;		//keep the first valid entry
				break;
			}

			//if(rg_db.l3[i].rtk_l3.process == L34_PROCESS_ARP && rg_db.l3[i].rtk_l3.arpEnd > last_arp)		//find the end ARP address
				//last_arp = rg_db.l3[i].rtk_l3.arpEnd;
		}
		if(rtIdx==MAX_L3_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
	}


	if(ipv6Enable==1)
	{
		rtv6Idx=MAX_IPV6_ROUTING_SW_TABLE_SIZE;
		for(i=0;i<MAX_IPV6_ROUTING_SW_TABLE_SIZE;i++)	//because idx V6_DEFAULT_ROUTE_IDX is reserved for default route
		{
			if(i == V6_DEFAULT_ROUTE_IDX)
				continue;
			if(rg_db.v6route[i].rtk_v6route.valid == 0)
			{
				rtv6Idx=i;		//keep the first valid entry
				break;
			}
		}
		if(rtv6Idx==MAX_IPV6_ROUTING_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
	}


	//------------------ Critical Section start -----------------------//
	//rg_lock(&rg_kernel.interfaceLock);

	//Set up Interface table
	bzero(&intfEntry,sizeof(rtk_l34_netif_entry_t));
	intfEntry.valid=1;
	memcpy(intfEntry.gateway_mac.octet, lan_info->gmac.octet,ETHER_ADDR_LEN);
	intfEntry.mac_mask=0x7;	//no mask
	intfEntry.vlan_id=lan_info->intf_vlan_id;		//for LAN DMAC2CVID to replace this SVL CVID
	intfEntry.enable_rounting=1;
	intfEntry.mtu=lan_info->mtu;

#if defined(CONFIG_RG_RTL9600_SERIES)
	//20141110LUKE: add for inhibiting multicast routing downstream trigger overMTU trap.
	if(rg_kernel.apolloChipId==APOLLOMP_CHIP_ID)
		intfEntry.mtu+=2;
#elif defined(CONFIG_RG_RTL9607C_SERIES)
	//20181226: avoid jumbo bridge packet is trapped to cpu due to over MTU.
	if(rg_db.systemGlobal.disable_lanIntf_overMtu_trap)
		intfEntry.mtu=DEFAULT_BRIDGE_WAN_MTU;
#endif

	//20140702LUKE:bypass set VLAN since we are replace old IP settings or add one more IPv4 subnet!!
	if(intfMatch)goto BYPASS_VLAN;

	//Set VLAN
	memset(&ori_vlanEntry,0,sizeof(rtk_rg_table_vlan_t));
	ori_pmsk.bits[0]=out_mac_pmask.bits[0];		//initial port mask
	ori_etpmsk.bits[0]=out_ext_pmask.bits[0];	//initial ext-port mask
	ori_utmsk.bits[0]=lan_info->untag_mask.portmask;	//initial untag set mask
	errorno=RT_ERR_RG_VLAN_SET_FAIL;
//----------------------
//----------------------

	ret = RTK_VLAN_CREATE(tmpVid);

	if(ret==RT_ERR_VLAN_EXIST)
	{
		memcpy(&ori_pmsk, &rg_db.vlan[tmpVid].MemberPortmask,sizeof(rtk_portmask_t));
		memcpy(&ori_utmsk, &rg_db.vlan[tmpVid].UntagPortmask,sizeof(rtk_portmask_t));
		memcpy(&ori_etpmsk, &rg_db.vlan[tmpVid].Ext_portmask,sizeof(rtk_portmask_t));

		//keep all information of original VLAN
		memcpy(&ori_vlanEntry, &rg_db.vlan[tmpVid],sizeof(rtk_rg_table_vlan_t));

		vlan_exist=1;
	}
	else if(ret!=RT_ERR_OK)
	{
		goto RET_VLAN_ERR;
	}

	//Check vlan-based priority enable for setup vlan-priority
	if(lan_info->vlan_based_pri_enable==RTK_RG_ENABLED)
	{
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(lan_info->vlan_based_pri==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
		{
			errorno=RT_ERR_RG_VLAN_PRI_CONFLICT_WIFI;
			goto RET_VLAN_ERR;
		}
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
		//WARNING("[FIXME]for 9602C, we can't set priority for VLAN directly...");
		//errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
		//goto RET_VLAN_ERR;
		{
			rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_t assignVlanBasedPriorityForInterfacePara;
			bzero(&assignVlanBasedPriorityForInterfacePara,sizeof(rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_t));
			assignVlanBasedPriorityForInterfacePara.ingress_vlan = lan_info->intf_vlan_id;
			assignVlanBasedPriorityForInterfacePara.assigned_priority = lan_info->vlan_based_pri;
			if(intfIdx < MAX_NETIF_HW_TABLE_SIZE)
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF0+intfIdx, &assignVlanBasedPriorityForInterfacePara);
		}
#else
		ret = RTK_VLAN_PRIORITYENABLE_SET(tmpVid,ENABLED);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
		ret = RTK_VLAN_PRIORITY_SET(tmpVid,lan_info->vlan_based_pri);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
#endif
	}
	else
	{
#if defined(CONFIG_RG_RTL9602C_SERIES)
#else
		ret = RTK_VLAN_PRIORITYENABLE_SET(tmpVid,DISABLED);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
#endif
	}

	//decide to use IVL or SVL for VLAN tag decision, IVL by untag set; SVL by DMAC2CVID
	if(lan_info->isIVL)
		fidMode=VLAN_FID_IVL;
	else
		fidMode=VLAN_FID_SVL;
	ret = RTK_VLAN_FIDMODE_SET(tmpVid, fidMode);		//Patch 20121129
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	ret = RTK_VLAN_FID_SET(tmpVid, LAN_FID);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	out_mac_pmask.bits[0]|=ori_pmsk.bits[0];		//add LAN port to vlan

	untag_mac_pmask.bits[0]=ori_utmsk.bits[0];
	untag_mac_pmask.bits[0]|=lan_info->untag_mask.portmask;		//add untag set to LAN

	//20140613LUKE: for multicast routing packet will use ingress's VLAN untag set, therefore set all none-member port as untag!!(ServerInLAN)
	untag_mac_pmask.bits[0]|=(~(out_mac_pmask.bits[0]))&RTK_RG_ALL_MAC_PORTMASK;
	errorno=RT_ERR_RG_VLAN_SET_FAIL;
	ret = RTK_VLAN_PORT_SET(tmpVid, &out_mac_pmask, &untag_mac_pmask);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	out_ext_pmask.bits[0]|=ori_etpmsk.bits[0];		//add LAN ext-port to vlan
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	out_ext_pmask.bits[0]|=0x1;		//add ext-CPU port to vlan
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
	ret = RTK_VLAN_EXTPORT_SET(tmpVid, &out_ext_pmask);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	//Check for bridge WAN, add Lan member to their VLAN if under MAC-based setting
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			{
				//ori_pmsk.bits[0]|=(0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wan_intf_conf.wan_port_idx);
				tmpVid=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				memcpy(&ori_pmsk, &rg_db.vlan[tmpVid].MemberPortmask,sizeof(rtk_portmask_t));
				memcpy(&ori_utmsk, &rg_db.vlan[tmpVid].UntagPortmask,sizeof(rtk_portmask_t));
				memcpy(&ori_etpmsk, &rg_db.vlan[tmpVid].Ext_portmask,sizeof(rtk_portmask_t));

				//Let LAN port become active in WAN's VLAN member port mask
				out_mac_pmask.bits[0]|=ori_pmsk.bits[0];
				out_ext_pmask.bits[0]|=ori_etpmsk.bits[0];
				//We do not add Lan port to untag set

				errorno=RT_ERR_RG_VLAN_SET_FAIL;
				ret = 0;
				if(RTK_VLAN_PORT_SET(tmpVid, &out_mac_pmask, &ori_utmsk)!=RT_ERR_OK)
					ret++;

#if defined(CONFIG_RG_RTL9602C_SERIES)
				//if(rg_kernel.debug_level&RTK_RG_DEBUG_LEVEL_FIXME)
				{
					if(RTK_VLAN_EXTPORT_SET(tmpVid,&out_ext_pmask)!=RT_ERR_OK)
						ret++;
				}
#else
				if(RTK_VLAN_EXTPORT_SET(tmpVid,&out_ext_pmask)!=RT_ERR_OK)
					ret++;
#endif
				if(ret>0){
					RTK_VLAN_PORT_SET(tmpVid, &ori_pmsk, &ori_utmsk);
    				RTK_VLAN_EXTPORT_SET(tmpVid, &ori_etpmsk);
					goto RET_BD_WAN_VLAN_ERR;
				}
			}
		}
	}

BYPASS_VLAN:
	//Set up interface table
	//for L2_only setting, if the MAC address is all zero, just set netif entry valid to zero!!(for interface index synchronisation)
	if(!memcmp(intfEntry.gateway_mac.octet,zeroMac,ETHER_ADDR_LEN))
		intfEntry.valid=0;
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	intfEntry.isL34=intfEntry.valid;
	intfEntry.ipAddr=lan_info->ip_addr;
	intfEntry.isCtagIf=0;	//FIXME: temporary setting this to zero now, it seems don't care.
	intfEntry.dslite_state=DISABLED;
#endif
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	intfEntry.deny_ipv4 = (lan_info->ip_version==IPVER_V6ONLY)?TRUE:FALSE;
	intfEntry.deny_ipv6 = (lan_info->ip_version==IPVER_V4ONLY)?TRUE:FALSE;
#endif
	errorno=RT_ERR_RG_INTF_SET_FAIL;
	ret = RTK_L34_NETIFTABLE_SET(intfIdx, &intfEntry);
	if(ret!=RT_ERR_OK)goto RET_INTF_ERR;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	ret = _rtk_rg_netifPPPoESession_set(intfIdx, FB_NETIFPPPOE_ACT_REMOVE, 0);
	if(ret!=RT_ERR_OK)goto RET_INTF_ERR;
#endif

	//reset software MTU should keep original MTU, only hardware MTU need to change!!
	rg_db.netif[intfIdx].rtk_netif.mtu=lan_info->mtu;

	//Set up Routing table
	if(ipv4Enable==1)
	{
		bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
		rtEntry.netifIdx=intfIdx;
		rtEntry.valid=1;
		rtEntry.process=L34_PROCESS_CPU;		//default add to sw table
		rtEntry.internal=1;
		rtEntry.ipAddr=lan_info->ip_addr&lan_info->ip_network_mask;		//20130301-store IP addr after masked
		rtEntry.rt2waninf=0;
		input_ipmsk=lan_info->ip_network_mask;
		RG_ONE_COUNT(input_ipmsk);
		rtEntry.ipMask=input_ipmsk-1;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_RG_RTL9602C_SERIES)
		rtEntry.process = L34_PROCESS_ARP;
#elif defined(CONFIG_RG_RTL9600_SERIES)
		//Check for ARP table for enough entry
		// TODO:Check for ARP range and add to rg_db.systemGlobal.routingArpInfoArray
		bzero(&newAddingEntry,sizeof(rtk_rg_routing_arpInfo_t));
		newAddingEntry.routingIdx=rtIdx;
		newAddingEntry.intfIdx=intfIdx;
		newAddingEntry.notMask=~lan_info->ip_network_mask;
		newAddingEntry.bitNum=32-input_ipmsk;
		newAddingEntry.isLan=1;

#if defined(CONFIG_RG_RTL9600_SERIES)
		if(lan_info->add_sw_arp==0)
#endif
		{
			if(newAddingEntry.bitNum <= 8)	//if need more than or equal to 512 entries, recorded in fwdEngine
			{
				errorno=RT_ERR_RG_ADD_ARP_MAC_FAILED;
				ret=_rtk_rg_addArpRoutingArray(&newAddingEntry,lan_info->ip_addr,lan_info->intf_vlan_id);
				if(ret==RT_ERR_RG_OK)
				{
					rtEntry.process = L34_PROCESS_ARP;
					rtEntry.arpStart = newAddingEntry.arpStart;
					rtEntry.arpEnd = newAddingEntry.arpEnd;
				}
				else if(ret==RT_ERR_RG_ADD_ARP_TO_SW_TABLE)		//for sw table, routing entry just set process to CPU
				{
					WARNING("HW table is not enough...will add LAN%d to software ARP table!",intfIdx);
				}
				else
					goto RET_INVALID_ARP;
			}
			else
			{
				WARNING("HW table is not enough...will add LAN%d to software ARP table!",intfIdx);
			}
		}
#endif

		errorno=RT_ERR_RG_ROUTE_SET_FAIL;
		ret = RTK_L34_ROUTINGTABLE_SET(rtIdx, &rtEntry);
		if(ret!=RT_ERR_OK)goto RET_ROUTING_ERR;

		//20140703LUKE: keep original IP address for check gateway IP
		rg_db.l3[rtIdx].gateway_ip=lan_info->ip_addr;

		//20140702LUKE: we should sync software data after replace old settings!!
		if((ip_update_state==ONLY_IPV4_UPDATED||ip_update_state==IPV4_IPV6_UPDATED) && lan_info->replace_subnet==1)
		{
			rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ip_addr=lan_info->ip_addr;
			rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ip_network_mask=lan_info->ip_network_mask;
		}
	}
	if(ipv6Enable==1)
	{
		bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
		rtv6Entry.valid=1;
		rtv6Entry.type=L34_IPV6_ROUTE_TYPE_LOCAL;
		rtv6Entry.nhOrIfidIdx=intfIdx;
		rtv6Entry.ipv6PrefixLen=lan_info->ipv6_network_mask_length;
		memcpy(&rtv6Entry.ipv6Addr,&lan_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
		rtv6Entry.rt2waninf=0;	//local route, routing to LAN

		errorno=RT_ERR_RG_ROUTE_SET_FAIL;
		ret = RTK_L34_IPV6ROUTINGTABLE_SET(rtv6Idx,&rtv6Entry);
		if(ret!=RT_ERR_OK)goto RET_ROUTING_ERR;

		//20160601LUKE: keep original IPv6 address for check gateway IP
		memcpy(&rg_db.v6route[rtv6Idx].gateway_ipv6Addr,&lan_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));

		//20140702LUKE: we should sync software data after replace old settings!!
		if((ip_update_state==ONLY_IPV6_UPDATED||ip_update_state==IPV4_IPV6_UPDATED) && lan_info->replace_subnet==1)
		{
			memcpy(&rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ipv6_addr,&lan_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
			rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->ipv6_network_mask_length=lan_info->ipv6_network_mask_length;
		}
	}

	// TODO:Call the initParam's routingAddByHwCallBack
	if(ipv4Enable==1)
	{
		if(rg_db.systemGlobal.initParam.routingAddByHwCallBack != NULL)
		{
			bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
			cb_routEt.dest_ip=lan_info->ip_addr;
			cb_routEt.ip_mask=lan_info->ip_network_mask;
			cb_routEt.nexthop=0;	//interface route
			cb_routEt.wan_intf_idx=intfIdx;
			rg_db.systemGlobal.initParam.routingAddByHwCallBack(&cb_routEt);
		}
	}
	// TODO:Call the initParam's v6RoutingAddByHwCallBack
	if(ipv6Enable==1)
	{
		if(rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack != NULL)
		{
			bzero(&cb_routv6Et, sizeof(rtk_rg_ipv6RoutingEntry_t));
			memcpy(&cb_routv6Et.dest_ip,&lan_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
			cb_routv6Et.prefix_len=lan_info->ipv6_network_mask_length;
			cb_routv6Et.NhOrIntfIdx=intfIdx;
			cb_routv6Et.type=L34_IPV6_ROUTE_TYPE_LOCAL;
			rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack(&cb_routv6Et);
		}
	}

	//20140702LUKE:only add gateway MAC when create new interface
	if(!intfMatch)
	{
		rtk_rg_successFailReturn_t ret_fs;
		//1 FIXME: patch for DA==GatewayMac will hit layer2 unknown DA, if action is trap
		//Create Lan gateway STATIC MAC
		errorno=RT_ERR_RG_CREATE_GATEWAY_LUT_FAIL;
		ret_fs = _rtk_rg_createGatewayMacEntry(lan_info->gmac.octet,lan_info->intf_vlan_id,lan_info->untag_mask.portmask,intfIdx,TRUE);
		if(ret_fs==RG_RET_FAIL)goto RET_ROUTING_ERR;
	}

	errorno=RT_ERR_RG_OK;
	*intf_idx = intfIdx;

	//20140702LUKE:bypass software data restored
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.mtu=lan_info->mtu;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.replace_subnet=lan_info->replace_subnet;
#if defined(CONFIG_RG_RTL9600_SERIES)
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.add_sw_arp=lan_info->add_sw_arp;
#endif
	if(intfMatch)goto BYPASS_SW_DATA;

	//store information in Global variable
	rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.lanIntfTotalNum].index=intfIdx;
	rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.lanIntfTotalNum].p_intfInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx];
	rg_db.systemGlobal.interfaceInfo[intfIdx].lan_or_wan_index=rg_db.systemGlobal.lanIntfTotalNum;
	rg_db.systemGlobal.lanIntfTotalNum++;

#if defined(CONFIG_RG_G3_SERIES)
	for(i=0; i<MAX_LAN_INTERFACE_SIZE; i++)
	{
		if(rg_db.systemGlobal.lanIntfGroup_for_genericIntf[i]==0)
		{
			rg_db.systemGlobal.lanIntfGroup_for_genericIntf[i] = 1;
			rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf = i;
			break;
		}
	}
	if(i==MAX_LAN_INTERFACE_SIZE)
	{
		WARNING("lanIntfGroup_for_genericIntf table is full.");
		RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
	}
#endif	

	//update LAN port mask
	rg_db.systemGlobal.lanPortMask.portmask|=lan_info->port_mask.portmask;
	//update dmac2cvid and vid unmatched action
	assert_ok(_rtk_rg_dmac2cvid_and_vidUnmatch_update());

	rg_db.systemGlobal.interfaceInfo[intfIdx].valid=IF_VALID_ENTRY;
	bzero(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.intf_name,32);
	sprintf(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.intf_name, "LAN%d",intfIdx);
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan=0;

	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.ip_version=lan_info->ip_version;
	memcpy(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.gmac.octet, lan_info->gmac.octet,ETHER_ADDR_LEN);
	if(ipv4Enable==1)
	{
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.ip_addr=lan_info->ip_addr;
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.ip_network_mask=lan_info->ip_network_mask;
	}
	if(ipv6Enable==1)
	{
		memcpy(&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.ipv6_addr,&lan_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.ipv6_network_mask_length=lan_info->ipv6_network_mask_length;
	}
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.port_mask=lan_info->port_mask;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.untag_mask.portmask=lan_info->untag_mask.portmask;
	//rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.extport_mask=lan_info->extport_mask;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.intf_vlan_id=lan_info->intf_vlan_id;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.vlan_based_pri_enable=lan_info->vlan_based_pri_enable;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.vlan_based_pri=lan_info->vlan_based_pri;
	//rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.pppoe_passThrough=lan_info->pppoe_passThrough;
#if 0
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.dhcp_server_enable=lan_info->dhcp_server_enable;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.lease_time=lan_info->lease_time;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.dhcp_start_ip_addr=lan_info->dhcp_start_ip_addr;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.dhcp_end_ip_addr=lan_info->dhcp_end_ip_addr;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.dhcp_port_binding_mask=lan_info->dhcp_port_binding_mask;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.dhcp_extport_binding_mask=lan_info->dhcp_extport_binding_mask;
#endif
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.isIVL=lan_info->isIVL;


	rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf; 	//short-cut of lan interface structure
	//Check PPPoE Pass through
	_rtk_rg_refreshPPPoEPassThroughLanOrWanPortMask();
	//Update PVID
	_rtk_rg_updatePortBasedVIDByLanOrder(rg_db.vlan[lan_info->intf_vlan_id].MemberPortmask, rg_db.vlan[lan_info->intf_vlan_id].Ext_portmask);
	//20150128LUKE: recovery pvid whild add LAN after delete one.
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		//UpdateBindInternet
		_rtk_rg_updateBindWanIntf(NULL);
		//Update non-binding
		_rtk_rg_updateNoneBindingPortmask(rg_db.systemGlobal.wanPortMask.portmask);
		//Update PVID of OtherWan-binding port to vlan specific for the WAN
		_rtk_rg_updateBindOtherWanPortBasedVID(NULL);
	}


	if(intfIdx < MAX_NETIF_HW_TABLE_SIZE)
	{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//apolloPro will always trap if unhit flow
#else
		if(lan_info->ip_version==IPVER_V6ONLY || lan_info->ip_version==IPVER_V4V6)
		{
			//20141226LUKE: add the trap link local ACL since we turn on IPv6 this interface!!
			memcpy(intf_link_local_trap_para.gmac.octet,lan_info->gmac.octet,ETHER_ADDR_LEN);
			rsvType=RTK_RG_ACLANDCF_RESERVED_IPV6_INTF0_LINK_LOCAL_TRAP+intfIdx;
			_rtk_rg_aclAndCfReservedRuleAdd(rsvType, &intf_link_local_trap_para);
		}
		else
		{
			//20141226LUKE: delete the trap link local ACL since we didn't support IPv6 this interface!!
			rsvType=RTK_RG_ACLANDCF_RESERVED_IPV6_INTF0_LINK_LOCAL_TRAP+intfIdx;
			_rtk_rg_aclAndCfReservedRuleDel(rsvType);
		}
#endif
	}

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if(ipv4Enable==1 && ((intfIdx>=MAX_NETIF_HW_TABLE_SIZE) || (rg_db.l3[rtIdx].valid==SOFTWARE_ONLY_ENTRY)))
	{
		rtk_rg_aclAndCf_reserved_dip_mask_trap_t dip_mask_trap;
		bzero(&dip_mask_trap,sizeof(dip_mask_trap));
		dip_mask_trap.dip=rg_db.l3[rtIdx].rtk_l3.ipAddr;
		dip_mask_trap.mask =~((1<<(31-(rg_db.l3[rtIdx].rtk_l3.ipMask)))-1);
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_RULE0_DIP_MASK_TRAP +rtIdx, &dip_mask_trap);
		rg_db.systemGlobal.interfaceInfo[intfIdx].valid|=IF_SOFTWARE4_ENTRY;
		WARNING("ReservedRuleAdd software data path ADD_LANv4 netif=%d L3Idx=%d",intfIdx,rtIdx);
	}
	if(ipv6Enable==1 && ((intfIdx>=MAX_NETIF_HW_TABLE_SIZE) || (rg_db.v6route[rtv6Idx].valid == SOFTWARE_ONLY_ENTRY)))
	{
		// v6patch
		rtk_rg_aclAndCf_reserved_dipv6_mask_trap_t dipv6_mask_trap;
		int32 byteZeroCount =( (128-rg_db.v6route[rtv6Idx].rtk_v6route.ipv6PrefixLen) /8);
		int32 residue = ( (128-rg_db.v6route[rtv6Idx].rtk_v6route.ipv6PrefixLen) %8);
		bzero(&dipv6_mask_trap,sizeof(dipv6_mask_trap));
		memcpy(&dipv6_mask_trap.dipv6.ipv6_addr[0],&rg_db.v6route[rtv6Idx].rtk_v6route.ipv6Addr.ipv6_addr[0],sizeof(dipv6_mask_trap.dipv6));

		memset(&dipv6_mask_trap.dipv6_mask.ipv6_addr[0],0xff,IPV6_ADDR_LEN);
		if(byteZeroCount)
			memset(&dipv6_mask_trap.dipv6_mask.ipv6_addr[IPV6_ADDR_LEN-byteZeroCount],0,byteZeroCount);
		if(residue)
			dipv6_mask_trap.dipv6_mask.ipv6_addr[IPV6_ADDR_LEN-byteZeroCount] &= (~((1<<residue) -1));

		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_RULE0_DIPv6_MASK_TRAP +rtv6Idx, &dipv6_mask_trap);
		rg_db.systemGlobal.interfaceInfo[intfIdx].valid|=IF_SOFTWARE6_ENTRY;
		WARNING("ReservedRuleAdd software data path ADD_LANv6 netif=%d L3Idx=%d",intfIdx,rtv6Idx);
	}
#endif

#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	//20141225LUKE: while add LAN interface we should rearrange ACL which use the gmac address for L34
	if(rg_db.systemGlobal.acl_SW_egress_intf_type_zero_num)
		ASSERT_EQ(_rtk_rg_acl_user_part_rearrange(),RT_ERR_RG_OK);
#endif

BYPASS_SW_DATA:
	//add lan-interfcae callback to sync protocal-stack
	if(rg_db.systemGlobal.initParam.interfaceAddByHwCallBack != NULL)
	{
		//20140704LUKE:special case, if we change MTU only but set replace_subnet to 1, callback will flush IP address including more subnet,
		//therefore we should let callback think we are just setting the same IP information without modify.
		if(ip_update_state==NO_IP_UPDATED)rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.replace_subnet=0;

		rg_db.systemGlobal.initParam.interfaceAddByHwCallBack(&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo,&intfIdx);

		//recover to original setting
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.replace_subnet=lan_info->replace_subnet;
	}
#if defined(CONFIG_RG_G3_SERIES)
	// Add generic interface of lan
	ASSERT_EQ(_rtk_rg_generic_lan_intf_add(intfIdx), RT_ERR_RG_OK);
	// reflash lut table
	_rtk_rg_reflash_lut_table();
#endif

	goto RET_SUCCESS;

RET_ROUTING_ERR:
    //Delete the routing entry
    if(rtIdx>=0)
	{
	    bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
	    RTK_L34_ROUTINGTABLE_SET(rtIdx, &rtEntry);
    }
	if(rtv6Idx>=0)
	{
		bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
		RTK_L34_IPV6ROUTINGTABLE_SET(rtv6Idx,&rtv6Entry);
	}
#if defined(CONFIG_RG_RTL9600_SERIES)
RET_INVALID_ARP:
#endif
RET_INTF_ERR:
    //Delete the interface entry
    bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
    RTK_L34_NETIFTABLE_SET(intfIdx, &intfEntry);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	 _rtk_rg_netifPPPoESession_set(intfIdx, FB_NETIFPPPOE_ACT_KEEP, 0);
#endif
RET_BD_WAN_VLAN_ERR:
RET_VLAN_ERR:
    //Delete the VLAN created, or recovery its member port if exist
	/*if(lan_info->pppoe_passThrough == 1)
	{
		bzero(&protoVlanCfg,sizeof(rtk_vlan_protoVlanCfg_t));
		if(out_ext_pmask.bits[0] > 0x1)
		{
			rtk_vlan_portProtoVlan_set(RTK_RG_MAC_PORT_CPU,PPPOE_DISCOVERY_GROUPID,&protoVlanCfg);
			rtk_vlan_portProtoVlan_set(RTK_RG_MAC_PORT_CPU,PPPOE_SESSION_GROUPID,&protoVlanCfg);
		}
		for(i=0;i<RTK_RG_PORT_CPU;i++)
		{
			if((out_mac_pmask.bits[0]&(0x1<<i)) > 0)
			{
				rtk_vlan_portProtoVlan_set(i,PPPOE_DISCOVERY_GROUPID,&protoVlanCfg);
				rtk_vlan_portProtoVlan_set(i,PPPOE_SESSION_GROUPID,&protoVlanCfg);
			}
		}
	}*/
    if(vlan_exist)
    {
        RTK_VLAN_PORT_SET(intfEntry.vlan_id, &ori_vlanEntry.MemberPortmask, &ori_vlanEntry.UntagPortmask);
        RTK_VLAN_EXTPORT_SET(intfEntry.vlan_id, &ori_vlanEntry.Ext_portmask);
        RTK_VLAN_FIDMODE_SET(intfEntry.vlan_id, ori_vlanEntry.fidMode);
		RTK_VLAN_FID_SET(intfEntry.vlan_id, ori_vlanEntry.fid);
#if defined(CONFIG_RG_RTL9602C_SERIES)
#else
		RTK_VLAN_PRIORITYENABLE_SET(intfEntry.vlan_id,ori_vlanEntry.priorityEn);
		RTK_VLAN_PRIORITY_SET(intfEntry.vlan_id,ori_vlanEntry.priority);
#endif
    }
    else
    {
        RTK_VLAN_DESTROY(intfEntry.vlan_id);
    }
/*RET_DEF_VLAN_ERR:
	//Recovery Default VLAN setting
	RTK_VLAN_PORT_SET(DEFAULT_LAN_VLAN, &ori_CPU_member_mask, &ori_CPU_untag_mask);*/

RET_SUCCESS:

	//------------------ Critical Section End -----------------------//
	//rg_unlock(&rg_kernel.interfaceLock);

    RETURN_ERR(errorno);
}

#if 0
int32 rtk_rg_apollo_dhcpServerStaticAlloc_add(ipaddr_t ipaddr, rtk_mac_t *macaddr,int *static_idx)
{
    int i;

    //Check input param
    if(static_idx == NULL || macaddr == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    if(ipaddr == 0)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
    if(macaddr->octet[0]==0 && macaddr->octet[1]==0 && macaddr->octet[2]==0 &&
            macaddr->octet[3]==0 && macaddr->octet[4]==0 && macaddr->octet[5]==0)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Store ip and macaddr in structure
    for(i=0; i<STATIC_DHCP_ALLOC_NUM; i++)
    {
        if(_DHCP_STATIC[i].valid != 0)
            continue;

        _DHCP_STATIC[i].ip=ipaddr;
        memcpy(_DHCP_STATIC[i].mac.octet, macaddr->octet, 6);
        _DHCP_STATIC[i].valid=1;
    }
    if(i == STATIC_DHCP_ALLOC_NUM)RETURN_ERR(RT_ERR_RG_ENTRY_FULL);

    //Return the index of new added ip-mac structure
    *static_idx = i;

    return (RT_ERR_RG_OK);
}

int32 rtk_rg_apollo_dhcpServerStaticAlloc_del(int static_idx)
{
    //Check param
    if(static_idx<0 || static_idx>=STATIC_DHCP_ALLOC_NUM)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
    if(_DHCP_STATIC[static_idx].valid == 0)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    _DHCP_STATIC[static_idx].valid=0;		//we just turn off the valid bit

    return (RT_ERR_RG_OK);
}

int32 rtk_rg_apollo_dhcpServerStaticAlloc_find(ipaddr_t *ipaddr, rtk_mac_t *macaddr, int *idx)
{
    //Check param
    int i;
    if(idx == NULL || ipaddr == NULL || macaddr == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    if(*idx<0 || *idx>=STATIC_DHCP_ALLOC_NUM)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Find the first available one from idx
    for(i=*idx; i<STATIC_DHCP_ALLOC_NUM; i++)
    {
        if(_DHCP_STATIC[i].valid==0)
            continue;

        *ipaddr=_DHCP_STATIC[i].ip;
        memcpy(macaddr->octet, _DHCP_STATIC[i].mac.octet, 6);
    }
    if(i==STATIC_DHCP_ALLOC_NUM)RETURN_ERR(RT_ERR_RG_STATIC_NOT_FOUND);

    //Return the first available index from idx
    *idx = i;

    return (RT_ERR_RG_OK);
}
#endif

//WAN Interface
int32 _rtk_rg_updateWANPortBasedVID(rtk_rg_port_idx_t wan_port)
{
#ifdef CONFIG_RG_WAN_PORT_ISOLATE
	int tmpPVid=DEFAULT_WAN_VLAN;
#else
	int tmpPVid=rg_db.systemGlobal.initParam.fwdVLAN_CPU;
#endif
	int origPVid,ret,i;
	int untag_RT=0,tag_WAN=0;

	//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && wan_port==RTK_RG_PORT_RGMII){
		DEBUG("Special recovery WAN_PORT from RGMII to PON.");
		wan_port=RTK_RG_PORT_PON;
	}
#endif
	rg_db.systemGlobal.wanPortMask.portmask=0x0;

#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl){
		rg_db.systemGlobal.wanPortMask.portmask|=(1<<RTK_RG_PORT_RGMII);
	}
#endif
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		//update WAN port mask
		rg_db.systemGlobal.wanPortMask.portmask|=0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx;

		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx==wan_port)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE && !rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on)
			{
				//Untag BG WAN
				tmpPVid=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				break;
			}
			else if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE && !rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on)
			{
				//Untag RT WAN
				if(untag_RT==0)	//keep first
				{
					untag_RT++;
					tmpPVid=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				}
			}
			else if(untag_RT==0)
			{
				//Tagged BG or RT WAN
				if(tag_WAN==0)	//keep first
				{
					tag_WAN++;
					tmpPVid=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				}
			}
		}
	}

	//update dmac2cvid and vid unmatched action
	assert_ok(_rtk_rg_dmac2cvid_and_vidUnmatch_update());

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// Reflash ACL due to wanPortMask update
	_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_TAIL_END, NULL);
#if defined(CONFIG_RG_G3_SERIES)
	// set CLS WAN default fib for hashlite(unknowDA lookup)
	ASSERT_EQ(rtk_rg_g3_l3fe_unknownDA_wan_default_enable(__ffs(rg_db.systemGlobal.wanPortMask.portmask)), AAL_E_OK);
#else	//not G3
	// Wan portmask has confirmed, sync portmask setting to lut wan port which is referenced by l2UcAct: FB_L2UCACT_FBLUT.
	rtk_rg_asic_l2UcWanEn_set(rg_db.systemGlobal.wanPortMask.portmask);
#endif //defined(CONFIG_RG_G3_SERIES)
#endif

//#if defined(CONFIG_GPON_FEATURE) || defined(CONFIG_EPON_FEATURE)
	//20141119LUKE: support S-tag from service port, which equals to WAN-port
	if ((rg_kernel.stag_enable==RTK_RG_ENABLED) && (rg_db.systemGlobal.initParam.hybridMode == 0)) {
#if defined(CONFIG_RG_RTL9600_SERIES)
		if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT2))
#endif
		{
			if(rg_db.systemGlobal.wanPortMask.portmask&(1<<RTK_RG_MAC_PORT_PON))
			{
				assert_ok(RTK_SVLAN_SERVICEPORT_SET(RTK_RG_MAC_PORT_PON, ENABLED));
			}
			else
			{
				assert_ok(RTK_SVLAN_SERVICEPORT_SET(RTK_RG_MAC_PORT_PON, DISABLED));
			}
			/*for(i=0;i<RTK_RG_MAC_PORT_CPU;i++)
			{
				if(rg_db.systemGlobal.wanPortMask.portmask&(1<<i))
				{
					assert_ok(RTK_SVLAN_SERVICEPORT_SET(i, ENABLED));
				}
				else
				{
					assert_ok(RTK_SVLAN_SERVICEPORT_SET(i, DISABLED));
				}
			}*/
		}
	}
//#endif

	origPVid=rg_db.systemGlobal.portBasedVID[wan_port];
	ret = RTK_VLAN_PORTPVID_SET(wan_port, tmpPVid);
	if(ret!=RT_ERR_OK)
	{
		RTK_VLAN_PORTPVID_SET(wan_port, origPVid);		//recovery original pvid
		WARNING("set Port_%d PVID[%d] fail...recovery to [%d]",wan_port,tmpPVid,origPVid);
		RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	}

	return (RT_ERR_RG_OK);
}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
#if defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
void _rtk_rg_lutExtport_translator(rtk_rg_port_idx_t *portIdx)
{
	//In order to be forward compatible, ext0 stands for all wifi device of master cpu, and ext1 stands for all wifi device of slave cpu.
#if defined(CONFIG_RG_G3_SERIES)
	if(RTK_RG_PORT_CPU_WLAN0_ROOT<=*portIdx && *portIdx<=RTK_RG_PORT_CPU_WLAN1_AND_OTHERS)
		*portIdx=RTK_RG_EXT_PORT0;
#else
	if(RTK_RG_EXT_PORT0<=*portIdx && *portIdx<=RTK_RG_EXT_PORT5)
		*portIdx=RTK_RG_EXT_PORT0;
#if defined(CONFIG_RG_RTL9607C_SERIES)
	else if(RTK_RG_MAC10_EXT_PORT0<=*portIdx && *portIdx<=RTK_RG_MAC10_EXT_PORT5)
		*portIdx=RTK_RG_EXT_PORT0;
	else if(RTK_RG_MAC7_EXT_PORT0<=*portIdx && *portIdx<=RTK_RG_MAC7_EXT_PORT5)
#if defined(CONFIG_DUALBAND_CONCURRENT)
		*portIdx=RTK_RG_EXT_PORT1;
#else
		*portIdx=RTK_RG_EXT_PORT0;
#endif
#endif
#endif
}

void _rtk_rg_wlanDevToPort_translator(rtk_rg_mbssidDev_t wlanDev, rtk_rg_port_idx_t *portIdx)
{
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
	//swap
	if(wlanDev>=RG_RET_MBSSID_SLAVE_ROOT_INTF)
		wlanDev-=RG_RET_MBSSID_SLAVE_ROOT_INTF;
	else
		wlanDev+=RG_RET_MBSSID_SLAVE_ROOT_INTF;
#endif
#if defined(CONFIG_RG_G3_SERIES)
	switch(wlanDev)
	{
		case RG_RET_MBSSID_MASTER_ROOT_INTF:
		case RG_RET_MBSSID_MASTER_VAP0_INTF:
		case RG_RET_MBSSID_MASTER_VAP1_INTF:
		case RG_RET_MBSSID_MASTER_VAP2_INTF:
		case RG_RET_MBSSID_MASTER_VAP3_INTF:
			*portIdx = RTK_RG_PORT_CPU_WLAN0_ROOT+wlanDev;
			break;
		default:
			*portIdx = RTK_RG_PORT_CPU_WLAN1_AND_OTHERS;
			break;
	}
#else // not CONFIG_RG_G3_SERIES
	switch(wlanDev)
	{
		case RG_RET_MBSSID_MASTER_ROOT_INTF:
		case RG_RET_MBSSID_MASTER_VAP0_INTF:
		case RG_RET_MBSSID_MASTER_VAP1_INTF:
		case RG_RET_MBSSID_MASTER_VAP2_INTF:
		case RG_RET_MBSSID_MASTER_VAP3_INTF:
			*portIdx = RTK_RG_EXT_PORT0+wlanDev;
			break;
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
		case RG_RET_MBSSID_MASTER_VAP4_INTF:
		case RG_RET_MBSSID_MASTER_VAP5_INTF:
		case RG_RET_MBSSID_MASTER_VAP6_INTF:
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
		case RG_RET_MBSSID_MASTER_WDS0_INTF:
		case RG_RET_MBSSID_MASTER_WDS1_INTF:
		case RG_RET_MBSSID_MASTER_WDS2_INTF:
		case RG_RET_MBSSID_MASTER_WDS3_INTF:
		case RG_RET_MBSSID_MASTER_WDS4_INTF:
		case RG_RET_MBSSID_MASTER_WDS5_INTF:
		case RG_RET_MBSSID_MASTER_WDS6_INTF:
#ifdef CONFIG_RTL_MESH_SUPPORT
		case RG_RET_MBSSID_MASTER_MESH_INTF:
#else	// not CONFIG_RTL_MESH_SUPPORT
		case RG_RET_MBSSID_MASTER_WDS7_INTF:
#endif	// end CONFIG_RTL_MESH_SUPPORT
#else	// not CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_MESH_SUPPORT
		case RG_RET_MBSSID_MASTER_MESH_INTF:
#endif	// end CONFIG_RTL_MESH_SUPPORT
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
		case RG_RET_MBSSID_MASTER_CLIENT_INTF:
#endif
			*portIdx = RTK_RG_EXT_PORT5;
			break;
#if defined(CONFIG_RG_RTL9607C_SERIES)
		case RG_RET_MBSSID_SLAVE_ROOT_INTF:
		case RG_RET_MBSSID_SLAVE_VAP0_INTF:
		case RG_RET_MBSSID_SLAVE_VAP1_INTF:
		case RG_RET_MBSSID_SLAVE_VAP2_INTF:
		case RG_RET_MBSSID_SLAVE_VAP3_INTF:
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
			*portIdx = RTK_RG_MAC7_EXT_PORT0+(wlanDev-RG_RET_MBSSID_SLAVE_ROOT_INTF);
#else
			if(!rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
				*portIdx = RTK_RG_MAC10_EXT_PORT0+(wlanDev-RG_RET_MBSSID_SLAVE_ROOT_INTF);
			else
				*portIdx = RTK_RG_EXT_PORT5;
#endif
			break;
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
		case RG_RET_MBSSID_SLAVE_VAP4_INTF:
		case RG_RET_MBSSID_SLAVE_VAP5_INTF:
		case RG_RET_MBSSID_SLAVE_VAP6_INTF:
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
		case RG_RET_MBSSID_SLAVE_WDS0_INTF:
		case RG_RET_MBSSID_SLAVE_WDS1_INTF:
		case RG_RET_MBSSID_SLAVE_WDS2_INTF:
		case RG_RET_MBSSID_SLAVE_WDS3_INTF:
		case RG_RET_MBSSID_SLAVE_WDS4_INTF:
		case RG_RET_MBSSID_SLAVE_WDS5_INTF:
		case RG_RET_MBSSID_SLAVE_WDS6_INTF:
		case RG_RET_MBSSID_SLAVE_WDS7_INTF:
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
		case RG_RET_MBSSID_SLAVE_CLIENT_INTF:
#endif
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
			*portIdx = RTK_RG_MAC7_EXT_PORT5;
#else
			if(!rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
				*portIdx = RTK_RG_MAC10_EXT_PORT5;
			else
				*portIdx = RTK_RG_EXT_PORT5;
#endif
			break;
#endif
		default:
			break;
	}
#endif
}

void _rtk_rg_wlanDevToExtPortmask_translator(rtk_rg_mbssidDev_t wlanDev, rtk_portmask_t *etpmsk)
{
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
	//swap
	if(wlanDev>=RG_RET_MBSSID_SLAVE_ROOT_INTF)
		wlanDev-=RG_RET_MBSSID_SLAVE_ROOT_INTF;
	else
		wlanDev+=RG_RET_MBSSID_SLAVE_ROOT_INTF;
#endif
#if defined(CONFIG_RG_G3_SERIES)
	etpmsk->bits[0]|=(0x1<<(RTK_RG_MAC_EXT_PORT0-RTK_RG_MAC_EXT_BASED_PORT));

#else	// not CONFIG_RG_G3_SERIES
	switch(wlanDev)
	{
		case RG_RET_MBSSID_MASTER_ROOT_INTF:
		case RG_RET_MBSSID_MASTER_VAP0_INTF:
		case RG_RET_MBSSID_MASTER_VAP1_INTF:
		case RG_RET_MBSSID_MASTER_VAP2_INTF:
		case RG_RET_MBSSID_MASTER_VAP3_INTF:
			etpmsk->bits[0]|=(0x1<<wlanDev);
			break;
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
		case RG_RET_MBSSID_MASTER_VAP4_INTF:
		case RG_RET_MBSSID_MASTER_VAP5_INTF:
		case RG_RET_MBSSID_MASTER_VAP6_INTF:
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
		case RG_RET_MBSSID_MASTER_WDS0_INTF:
		case RG_RET_MBSSID_MASTER_WDS1_INTF:
		case RG_RET_MBSSID_MASTER_WDS2_INTF:
		case RG_RET_MBSSID_MASTER_WDS3_INTF:
		case RG_RET_MBSSID_MASTER_WDS4_INTF:
		case RG_RET_MBSSID_MASTER_WDS5_INTF:
		case RG_RET_MBSSID_MASTER_WDS6_INTF:
#ifdef CONFIG_RTL_MESH_SUPPORT
		case RG_RET_MBSSID_MASTER_MESH_INTF:
#else	// not CONFIG_RTL_MESH_SUPPORT
		case RG_RET_MBSSID_MASTER_WDS7_INTF:
#endif	// end CONFIG_RTL_MESH_SUPPORT
#else	// not CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_MESH_SUPPORT
		case RG_RET_MBSSID_MASTER_MESH_INTF:
#endif	// end CONFIG_RTL_MESH_SUPPORT
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
		case RG_RET_MBSSID_MASTER_CLIENT_INTF:
#endif
			etpmsk->bits[0]|=(0x1<<(RTK_RG_EXT_PORT5-RTK_RG_EXT_BASED_PORT));
			break;
#if defined(CONFIG_RG_RTL9607C_SERIES)
		case RG_RET_MBSSID_SLAVE_ROOT_INTF:
		case RG_RET_MBSSID_SLAVE_VAP0_INTF:
		case RG_RET_MBSSID_SLAVE_VAP1_INTF:
		case RG_RET_MBSSID_SLAVE_VAP2_INTF:
		case RG_RET_MBSSID_SLAVE_VAP3_INTF:
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
			etpmsk->bits[0]|=(0x1<<((wlanDev-RG_RET_MBSSID_SLAVE_ROOT_INTF)+(RTK_RG_MAC7_EXT_PORT0-RTK_RG_EXT_BASED_PORT)));
#else
			if(!rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
				etpmsk->bits[0]|=(0x1<<((wlanDev-RG_RET_MBSSID_SLAVE_ROOT_INTF)+(RTK_RG_MAC10_EXT_PORT0-RTK_RG_EXT_BASED_PORT)));
			else
				etpmsk->bits[0]|=(0x1<<(RTK_RG_EXT_PORT5-RTK_RG_EXT_BASED_PORT));
#endif
			break;
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
		case RG_RET_MBSSID_SLAVE_VAP4_INTF:
		case RG_RET_MBSSID_SLAVE_VAP5_INTF:
		case RG_RET_MBSSID_SLAVE_VAP6_INTF:
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
		case RG_RET_MBSSID_SLAVE_WDS0_INTF:
		case RG_RET_MBSSID_SLAVE_WDS1_INTF:
		case RG_RET_MBSSID_SLAVE_WDS2_INTF:
		case RG_RET_MBSSID_SLAVE_WDS3_INTF:
		case RG_RET_MBSSID_SLAVE_WDS4_INTF:
		case RG_RET_MBSSID_SLAVE_WDS5_INTF:
		case RG_RET_MBSSID_SLAVE_WDS6_INTF:
		case RG_RET_MBSSID_SLAVE_WDS7_INTF:
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
		case RG_RET_MBSSID_SLAVE_CLIENT_INTF:
#endif
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
			etpmsk->bits[0]|=(0x1<<(RTK_RG_MAC7_EXT_PORT5-RTK_RG_EXT_BASED_PORT));
#else
			if(!rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
				etpmsk->bits[0]|=(0x1<<(RTK_RG_MAC10_EXT_PORT5-RTK_RG_EXT_BASED_PORT));
			else
				etpmsk->bits[0]|=(0x1<<(RTK_RG_EXT_PORT5-RTK_RG_EXT_BASED_PORT));
#endif
			break;
#endif
		default:
			break;
	}
#endif
}

void _rtk_rg_egressExtPort_translator(rtk_rg_pktHdr_t *pPktHdr)
{
#if defined(CONFIG_RG_G3_SERIES)
	rtk_rg_port_idx_t egressPort;

	_rtk_rg_macPortToPort_translator(&egressPort, pPktHdr->egressMacPort, pPktHdr->egressMacExtPort);
	_rtk_rg_lutExtport_translator(&egressPort);
	_rtk_rg_portToMacPort_translator(egressPort, &pPktHdr->egressMacPort, &pPktHdr->egressMacExtPort);
	TRACE("[After extPort translator] dmacL2Idx[%d] port(%d) extPort(%d) ", pPktHdr->dmacL2Idx, pPktHdr->egressMacPort, pPktHdr->egressMacExtPort);
#endif
	return;
}
#endif

void _rtk_rg_wlanDevMaskToExtPortmask_translator(uint32 wlanDevMask, rtk_portmask_t *etpmsk)
{
#if defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
	rtk_rg_mbssidDev_t wlanDev;
	for(wlanDev=0; wlanDev<MAX_WLAN_DEVICE_NUM; wlanDev++)
	{
		if(wlanDevMask&(0x1<<wlanDev))
			_rtk_rg_wlanDevToExtPortmask_translator(wlanDev, etpmsk);
	}

#else	// not CONFIG_RG_FLOW_NEW_WIFI_MODE

#ifdef CONFIG_DUALBAND_CONCURRENT
	if(wlanDevMask&((0x1<<WLAN_DEVICE_NUM)-1))
		etpmsk->bits[0]|=(0x1<<(RTK_RG_MAC_EXT_PORT0-RTK_RG_MAC_EXT_BASED_PORT));
	if(rg_db.systemGlobal.enableSlaveSSIDBind && wlanDevMask>=(0x1<<WLAN_DEVICE_NUM))
		etpmsk->bits[0]|=(0x1<<(RTK_RG_MAC_EXT_PORT1-RTK_RG_MAC_EXT_BASED_PORT));
#else // not CONFIG_DUALBAND_CONCURRENT
	if(wlanDevMask)
		etpmsk->bits[0]|=(0x1<<(RTK_RG_MAC_EXT_PORT0-RTK_RG_MAC_EXT_BASED_PORT));
#endif

#endif
}

void _rtk_rg_updateOtherWanWlan0Setting(rtk_rg_wanIntfConf_t *wanintf, rtk_portmask_t *etpmsk, int vidX)
{
	int i;

	if(wanintf->wlan0_dev_binding_mask)
	{
		uint32 masterWifi_dev_binding_mask, slaveWifi_dev_binding_mask;
		masterWifi_dev_binding_mask = wanintf->wlan0_dev_binding_mask&((0x1<<WLAN_DEVICE_NUM)-1);
		slaveWifi_dev_binding_mask = wanintf->wlan0_dev_binding_mask&(~((0x1<<WLAN_DEVICE_NUM)-1));

		_rtk_rg_wlanDevMaskToExtPortmask_translator(wanintf->wlan0_dev_binding_mask, etpmsk);

		//Change DVID of all binding WLAN0 device to OtherWanVlan
		for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
		{
			if(wanintf->wlan0_dev_binding_mask&(0x1<<i))
				assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,vidX));
		}

		//Add binding WLAN0 device to OtherWanVlan's Wlan0DevMask
		rg_db.vlan[vidX].wlan0DevMask|=wanintf->wlan0_dev_binding_mask;
		if(rg_db.vlan[vidX].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))
			rg_db.vlan[vidX].wlan0UntagMask|=masterWifi_dev_binding_mask;
		else
			rg_db.vlan[vidX].wlan0UntagMask&=(~masterWifi_dev_binding_mask);

#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		if(rg_db.vlan[vidX].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_SLAVECPU))
#else
		if(rg_db.vlan[vidX].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))
#endif
			rg_db.vlan[vidX].wlan0UntagMask|=slaveWifi_dev_binding_mask;
		else
			rg_db.vlan[vidX].wlan0UntagMask&=(~slaveWifi_dev_binding_mask);
	}
	else
	{
		if(wanintf->port_binding_mask.portmask & (0x1<<RTK_RG_EXT_PORT0))
		{
			//Change DVID of all WLAN0 device to OtherWanVlan
#ifdef CONFIG_DUALBAND_CONCURRENT
			for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
			for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
			{
				if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
				{
					assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,vidX));

					//Add all WLAN0 device to OtherWanVlan's Wlan0DevMask
					rg_db.vlan[vidX].wlan0DevMask|=(0x1<<i);
					if(rg_db.vlan[vidX].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))
						rg_db.vlan[vidX].wlan0UntagMask|=(0x1<<i);
					else
						rg_db.vlan[vidX].wlan0UntagMask&=(~(0x1<<i));
				}
			}
		}
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(wanintf->port_binding_mask.portmask & (0x1<<RTK_RG_EXT_PORT1))
		{
			//Change DVID of WLAN1 device to OtherWanVlan
			for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
			{
				if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
				{
					assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,vidX));

					//Add all WLAN1 device to OtherWanVlan's Wlan0DevMask
					rg_db.vlan[vidX].wlan0DevMask|=(0x1<<i);
					if(rg_db.vlan[vidX].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_SLAVECPU))
						rg_db.vlan[vidX].wlan0UntagMask|=(0x1<<i);
					else
						rg_db.vlan[vidX].wlan0UntagMask&=(~(0x1<<i));
				}
			}
		}
#endif
	}
}
#endif

int32 _rtk_rg_updateBindWanIntf(rtk_rg_wanIntfConf_t *wanintf)
{
	int i,j,ret,vlanId;
	rtk_portmask_t mbpmsk, utpmsk, etpmsk;
	rtk_portmask_t out_mac_pmask,out_ext_pmask,vlan_bind_pmsk,vlan_bind_extpmsk;
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	uint32 wlanDevMask;
#endif

	if(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].valid==0)
	{
		//first use, create it
		ret = RTK_VLAN_CREATE(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET);
		if (ret == RT_ERR_VLAN_EXIST)
		{
			DEBUG("fwdVLAN_BIND_INTERNET[%d] had created..",rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET);
			rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].valid = 1;
		}
	}

	mbpmsk.bits[0]=rg_db.systemGlobal.lanPortMask.portmask|RTK_RG_ALL_CPU_PORTMASK;	//all LAN port with CPU
#if 1	//20170303: internal used vlan must be all untagged
	utpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;	//all untag
#else
	utpmsk.bits[0]=RTK_RG_ALL_LAN_PORTMASK|RTK_RG_ALL_CPU_PORTMASK;	//all untag
#endif
	etpmsk.bits[0]=RTK_RG_ALL_USED_VIRUAL_PORTMASK; 	//cpu, extension port 0 and 1

	//Search all non-internet binding WAN, remove their member from VID fwdVLAN_BIND_INTERNET
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->none_internet==1 &&
			rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask>0)
		{
			rtk_portmask_t _vlanExtPmsk;
			_rtk_rg_portmask_translator(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask,&out_mac_pmask,&out_ext_pmask);

			mbpmsk.bits[0]&=(~(out_mac_pmask.bits[0]));
			etpmsk.bits[0]&=(~(out_ext_pmask.bits[0]));

			//update it's VLAN member by binding mask and wlan dev mask
			vlanId=rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[i].index];
			rg_db.vlan[vlanId].MemberPortmask.bits[0]=out_mac_pmask.bits[0];	//all binding LAN port with CPU
			rg_db.vlan[vlanId].MemberPortmask.bits[0]|=RTK_RG_ALL_CPU_PORTMASK;
			//assign WAN port to Other VLAN's member
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type == RTK_RG_BRIDGE)
				rg_db.vlan[vlanId].MemberPortmask.bits[0]|=0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx;
#if 1	//20170303: internal used vlan must be all untagged
			rg_db.vlan[vlanId].UntagPortmask.bits[0]=RTK_RG_ALL_MAC_PORTMASK; //all untag
#else
			rg_db.vlan[vlanId].UntagPortmask.bits[0]=out_mac_pmask.bits[0]; //all untag
			rg_db.vlan[vlanId].UntagPortmask.bits[0]|=RTK_RG_ALL_CPU_PORTMASK;
#endif
			//rg_db.vlan[vlanId].Ext_portmask.bits[0]=out_ext_pmask.bits[0];//all binding ext LAN port
			_vlanExtPmsk.bits[0]=out_ext_pmask.bits[0];//all binding ext LAN port
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
			//rg_db.vlan[vlanId].Ext_portmask.bits[0]|=0x1;
			_vlanExtPmsk.bits[0]|=0x1;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
			/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			rg_db.vlan[vlanId].wlan0DevMask=0x0;	//clear first
			rg_db.vlan[vlanId].wlan0UntagMask=0x0;
			_rtk_rg_updateOtherWanWlan0Setting(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf,&_vlanExtPmsk,vlanId);
#endif
			ret = RTK_VLAN_PORT_SET(vlanId, &rg_db.vlan[vlanId].MemberPortmask, &rg_db.vlan[vlanId].UntagPortmask);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
			ret = RTK_VLAN_EXTPORT_SET(vlanId, &_vlanExtPmsk);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

		}
	}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	wlanDevMask=0x0;
	rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask=0x0;
	rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask=0x0;

	//Check wlan-device binding only when there is no WAN port-binding ext0.
	if(etpmsk.bits[0]&RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK)
	{
		etpmsk.bits[0]&=(~RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK);

		//Search all wlan0 devices, if one of them are un-binding or binding to internet WAN, keep ext0 port in member.
#ifdef CONFIG_DUALBAND_CONCURRENT
		for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
		for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
			{
				if(rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
				{
					//internet-binding device, keep ext0 in member!
					if(!rg_db.systemGlobal.interfaceInfo[rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf].storedInfo.wan_intf.wan_intf_conf.none_internet)
					{
						wlanDevMask |= (0x1<<i);

						//Change DVID of internet-bindingl WLAN device to fwdVLAN_BIND_INTERNET
						assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET));

						//Set this device to fwdVLAN_BIND_INTERNET's DevMask
						rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask|=(0x1<<i);
						if(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))
							rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask|=(0x1<<i);
						else
							rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask&=(~(0x1<<i));
					}
				}
				else
				{
					//un-binding device, keep ext0 in member!
					wlanDevMask |= (0x1<<i);

					//Change DVID of un-binding WLAN device to fwdVLAN_BIND_INTERNET
					assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET));

					//Set this device to fwdVLAN_BIND_INTERNET's DevMask
					rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask|=(0x1<<i);
					if(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))
						rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask|=(0x1<<i);
					else
						rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask&=(~(0x1<<i));
				}
			}
		}
	}
#ifdef CONFIG_DUALBAND_CONCURRENT
	if(etpmsk.bits[0]&RTK_RG_ALL_VLAN_SLAVE_EXT_PORTMASK)
	{
		etpmsk.bits[0]&=(~RTK_RG_ALL_VLAN_SLAVE_EXT_PORTMASK);

		//Search all wlan1 devices, if one of them are un-binding or binding to internet WAN, keep ext1 port in member.
		for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
			{
				if(rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
				{
					//internet-binding device, keep ext1 in member!
					if(!rg_db.systemGlobal.interfaceInfo[rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf].storedInfo.wan_intf.wan_intf_conf.none_internet)
					{
						wlanDevMask |= (0x1<<i);

						//Change DVID of internet-bindingl WLAN device to fwdVLAN_BIND_INTERNET
						assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET));

						//Set this device to fwdVLAN_BIND_INTERNET's DevMask
						rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask|=(0x1<<i);
						if(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_SLAVECPU))
							rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask|=(0x1<<i);
						else
							rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask&=(~(0x1<<i));
					}
				}
				else
				{
					//un-binding device, keep ext0 in member!
					wlanDevMask |= (0x1<<i);

					//Change DVID of un-binding WLAN device to fwdVLAN_BIND_INTERNET
					assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET));

					//Set this device to fwdVLAN_BIND_INTERNET's DevMask
					rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask|=(0x1<<i);
					if(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_SLAVECPU))
						rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask|=(0x1<<i);
					else
						rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask&=(~(0x1<<i));
				}
			}
		}
	}
#endif
	//Compare the new adding WAN,too
	if(wanintf != NULL)
	{
		if(wanintf->none_internet==0)
		{
			//internet-binding device, keep ext0 in member!
			if(wanintf->wlan0_dev_binding_mask>0)
				wlanDevMask |= wanintf->wlan0_dev_binding_mask;
		}
		else
		{
			//remove the otherWAN bind device from fwdVLAN_BIND_INTERNET's DevMask
			rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask&=(~(wanintf->wlan0_dev_binding_mask));
			rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask&=(~(wanintf->wlan0_dev_binding_mask));
		}
	}
	//translate wlanDevMask To extPortmask
	_rtk_rg_wlanDevMaskToExtPortmask_translator(wlanDevMask, &etpmsk);
#endif

	//Compare the new adding WAN,too
	if(wanintf != NULL && wanintf->none_internet==1 && wanintf->port_binding_mask.portmask>0)
	{
		_rtk_rg_portmask_translator(wanintf->port_binding_mask,&out_mac_pmask,&out_ext_pmask);

		mbpmsk.bits[0]&=(~(out_mac_pmask.bits[0]));
		etpmsk.bits[0]&=(~(out_ext_pmask.bits[0]));
	}

	//20140516LUKE:we should keep CPU port unless there is no ext port anymore
	if(etpmsk.bits[0])
		mbpmsk.bits[0]|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;

	ret = RTK_VLAN_FID_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, LAN_FID);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_kernel.block_communication_between_internet_and_other)
		ret = RTK_VLAN_FIDMODE_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, VLAN_FID_IVL);		//This is used for ALL LAN interface
	else
#endif
		ret = RTK_VLAN_FIDMODE_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, VLAN_FID_SVL);		//This is used for ALL LAN interface
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, &mbpmsk, &utpmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, &etpmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

	//Change PVID of all LAN port remain in fwdVLAN_BIND_INTERNET
	for(i=0;i<=RTK_RG_PORT_LASTCPU;i++)
	{
		if(RG_INVALID_PORT(i)) continue;

		if(mbpmsk.bits[0]&(0x1<<i))
		{
			//20150408LUKE: check PPB first
			if(rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID].valid)
			{
				rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID].vid=rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET;
				ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV4_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID]),RT_ERR_OK);
				rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_ARP_GROUPID].vid=rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET;
				ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_ARP_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_ARP_GROUPID]),RT_ERR_OK);
			}
			else if(rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID].valid)
			{
				rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID].vid=rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET;
				ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV6_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID]),RT_ERR_OK);
			}
			else
				ASSERT_EQ(RTK_VLAN_PORTPVID_SET(i,rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET),RT_ERR_OK);
		}
	}
	for(i=RTK_RG_EXT_PORT0;i<RTK_RG_PORT_MAX;i++)
	{
		if(RG_INVALID_PORT(i)) continue;
		if(etpmsk.bits[0]&(0x1<<(i-RTK_RG_EXT_BASED_PORT)))
			ASSERT_EQ(RTK_VLAN_EXTPORTPVID_SET(i-RTK_RG_EXT_BASED_PORT,rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET),RT_ERR_OK);
	}

	//Refresh all WAN's VLAN member
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		rtk_portmask_t _vlanExtPmsk;
		//dismiss all LAN member...
		_rtk_rg_portmask_translator(rg_db.systemGlobal.lanPortMask,&out_mac_pmask,&out_ext_pmask);
		//20170525: Does not dismiss cpu port and wan port

		_vlanExtPmsk.bits[0]=rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0];

		rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask.bits[0]&=(~(out_mac_pmask.bits[0]&(~(RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK|(0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx)))));
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		_vlanExtPmsk.bits[0]&=(~(out_ext_pmask.bits[0]&(~(0x1))));
		//rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0]&=(~(out_ext_pmask.bits[0]&(~(0x1))));
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
#ifdef CONFIG_MASTER_WLAN0_ENABLE
		//dismiss all WLAN0 Device in VLAN's Mask
		rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0DevMask=0x0;//((0x1<<RG_WWAN_WLAN0_VXD)|(0x1<<RG_WWAN_WLAN1_VXD));
		rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0UntagMask=0x0;//((0x1<<RG_WWAN_WLAN0_VXD)|(0x1<<RG_WWAN_WLAN1_VXD));
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
		if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wirelessWan==RG_WWAN_WLAN0_VXD)
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0DevMask=0x1<<RG_WWAN_WLAN0_VXD;
		else if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wirelessWan==RG_WWAN_WLAN1_VXD)
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0DevMask=0x1<<RG_WWAN_WLAN1_VXD;
#endif
#endif

		//20190725LUKE: recovery member port from vlan-binding with same vlan
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->vlan_binding_mask.portmask)
		{
			_rtk_rg_portmask_translator(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->vlan_binding_mask,&vlan_bind_pmsk,&vlan_bind_extpmsk);
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask.bits[0]|=vlan_bind_pmsk.bits[0];	//all vlan-binding port
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask.bits[0]&=(~vlan_bind_pmsk.bits[0]);	//all vlan-binding port should tag
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0]|=vlan_bind_extpmsk.bits[0];	//all vlan-binding ext-port 
		}
		
		//20180125LUKE: add user defined portmask to bridge wan.
		if(rg_db.systemGlobal.wanVlanMemAppend[rg_db.systemGlobal.wanIntfGroup[i].index].portmask)
		{
			_rtk_rg_portmask_translator(rg_db.systemGlobal.wanVlanMemAppend[rg_db.systemGlobal.wanIntfGroup[i].index],&out_mac_pmask,&out_ext_pmask);
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask.bits[0]|=out_mac_pmask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
			_vlanExtPmsk.bits[0]|=out_ext_pmask.bits[0];
			//rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0]|=out_ext_pmask.bits[0];
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
		}
		//reset internet WAN's VLAN
		ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask, &rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
		ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &_vlanExtPmsk);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	}

	//update all bridge WAN's VLAN member
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
		{
			rtk_portmask_t _vlanExtPmsk;

			_vlanExtPmsk.bits[0] = rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0];
			vlanId=FAIL;
			//internet bridge WAN's LAN member is come from fwdVLAN_BIND_INTERNET
			if(!rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->none_internet)
			{
				vlanId=rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET;
			}
			else //other bridge WAN's LAN member
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask!=0 || rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wlan0_dev_binding_mask!=0)
					vlanId=rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[i].index];
			}

			//20140516LUKE:All LAN port should be untag, CPU port will follow WAN port's setting!
			rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask.bits[0]|= ((rg_db.systemGlobal.lanPortMask.portmask & RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU) & (~rg_db.systemGlobal.wanPortMask.portmask));

			//20190725LUKE: check all other WAN interface with same VLAN here
			for(j=0;j<rg_db.systemGlobal.wanIntfTotalNum;j++)
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==rg_db.systemGlobal.wanIntfGroup[j].p_wanIntfConf->egress_vlan_id &&
					rg_db.systemGlobal.wanIntfGroup[j].p_wanIntfConf->vlan_binding_mask.portmask)
				{
					_rtk_rg_portmask_translator(rg_db.systemGlobal.wanIntfGroup[j].p_wanIntfConf->vlan_binding_mask,&vlan_bind_pmsk,&vlan_bind_extpmsk);
					rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask.bits[0]|=vlan_bind_pmsk.bits[0];	//all vlan-binding port
					rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask.bits[0]&=(~vlan_bind_pmsk.bits[0]);	//all vlan-binding port should tag
					rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0]|=vlan_bind_extpmsk.bits[0];	//all vlan-binding ext-port 
				}
			}

			if(vlanId!=FAIL)
			{
				//assign LAN member to fwdVLAN_BIND_INTERNET's member
				rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask.bits[0]|=rg_db.vlan[vlanId].MemberPortmask.bits[0];
				//rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].Ext_portmask.bits[0]|=rg_db.vlan[vlanId].Ext_portmask.bits[0];
				_vlanExtPmsk.bits[0]|=rg_db.vlan[vlanId].Ext_portmask.bits[0];
#ifdef CONFIG_MASTER_WLAN0_ENABLE
				//assign fwdVLAN_BIND_INTERNET's WLAN0 Device to VLAN's Mask
				rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0DevMask|=rg_db.vlan[vlanId].wlan0DevMask;
				rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0UntagMask|=rg_db.vlan[vlanId].wlan0UntagMask;
#endif
			}

			//reset WAN's VLAN
			ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].MemberPortmask, &rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
			ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &_vlanExtPmsk);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
		}
	}

	return (RT_ERR_RG_OK);
}

int32 _rtk_rg_transformPortmaskToPortIdx(uint32 portmask, unsigned int *portIdx)
{
	int i;

	if(RG_INVALID_PORTMASK(portmask))
		RETURN_ERR(RT_ERR_RG_INDEX_OUT_OF_RANGE);

	for(i=RTK_RG_PORT0;i<RTK_RG_PORT_MAX;i++)
	{
		if(portmask&(0x1<<i))
		{
			*portIdx=i;
			break;
		}
	}

	return (RT_ERR_RG_OK);
}

int32 _rtk_rg_updateNoneBindingPortmask(uint32 wanPmsk)
{
	int i;
	uint32 portIdx=0, none_binding_masterDev=0, none_binding_slaveDev=0;

	//init
	rg_db.systemGlobal.non_binding_pmsk.portmask=rg_db.systemGlobal.lanPortMask.portmask|RTK_RG_ALL_EXT_PORTMASK;	//all LAN port, non-LAN is always non-binding!!
	for(i=RTK_RG_PORT0;i<RTK_RG_PORT_MAX;i++)
	{
		rg_db.systemGlobal.portbinding_wan_idx[i]=-1;
	}

	//search all port-binding WAN and vlan-binding rules, record non-binding port in rg_db.systemGlobal.non_binding_pmsk
	//record each port which port-binding to WAN interface in rg_db.systemGlobal.portbinding_wan_idx[RTK_RG_PORT_MAX]
	for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
	{
		if(rg_db.bind[i].valid)
		{
			if(rg_db.bind[i].rtk_bind.portMask.bits[0]>0)
			{
				rg_db.systemGlobal.non_binding_pmsk.portmask &= (~rg_db.bind[i].rtk_bind.portMask.bits[0]);
				//only record port-binding
				if(rg_db.bind[i].rtk_bind.vidLan==0 && _rtk_rg_transformPortmaskToPortIdx(rg_db.bind[i].rtk_bind.portMask.bits[0],&portIdx)==RT_ERR_RG_OK)
					rg_db.systemGlobal.portbinding_wan_idx[portIdx]=rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx;
				TABLE("rg_db.systemGlobal.portbinding_wan_idx[%d]=%d",portIdx,rg_db.systemGlobal.portbinding_wan_idx[portIdx]);
			}
			else if(rg_db.bind[i].rtk_bind.extPortMask.bits[0]>0)
			{
				rg_db.systemGlobal.non_binding_pmsk.portmask &= (~(rg_db.bind[i].rtk_bind.extPortMask.bits[0]<<RTK_RG_EXT_PORT0));
				//only record port-binding
				if(rg_db.bind[i].rtk_bind.vidLan==0 && _rtk_rg_transformPortmaskToPortIdx((rg_db.bind[i].rtk_bind.extPortMask.bits[0]<<RTK_RG_EXT_PORT0),&portIdx)==RT_ERR_RG_OK)
					rg_db.systemGlobal.portbinding_wan_idx[portIdx]=rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx;
			}
		}
	}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	if(rg_db.systemGlobal.non_binding_pmsk.portmask&(0x1<<RTK_RG_EXT_PORT0))
	{
		//Check if there are non-binding-device in WLAN0
#ifdef CONFIG_DUALBAND_CONCURRENT
		for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
		for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist && !rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
			{
				none_binding_masterDev |= 0x1<<i;
			}
		}
		//if all wifi device of master cpu is binding, dismiss ext0 port in non_binding_pmsk
		if(!none_binding_masterDev)
		{
			rg_db.systemGlobal.non_binding_pmsk.portmask&=(~(0x1<<RTK_RG_EXT_PORT0));
		}
	}
#ifdef CONFIG_DUALBAND_CONCURRENT
	if(rg_db.systemGlobal.non_binding_pmsk.portmask&(0x1<<RTK_RG_EXT_PORT1))
	{
		//Check if there are non-binding-device in WLAN1
		for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist && !rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
			{
				none_binding_slaveDev |= 0x1<<i;
			}
		}
		//if all WLAN1 device is binding, dismiss ext1 port in non_binding_pmsk
		if(!none_binding_slaveDev)
		{
			rg_db.systemGlobal.non_binding_pmsk.portmask&=(~(0x1<<RTK_RG_EXT_PORT1));
		}
	}
#endif
#endif

	if((rg_db.systemGlobal.non_binding_pmsk.portmask|none_binding_masterDev|none_binding_slaveDev)==0x0)
	{
		//remove WAN port from fwdVLAN_BIND_INTERNET VLAN's member
		rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].MemberPortmask.bits[0]&=(~wanPmsk);
		assert_ok(RTK_VLAN_PORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, &rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].MemberPortmask, &rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].UntagPortmask));
		//assert_ok(RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, &rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].Ext_portmask));
	}
	else
	{
		//add WAN port to fwdVLAN_BIND_INTERNET VLAN's member
		rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].MemberPortmask.bits[0]|=wanPmsk;
		assert_ok(RTK_VLAN_PORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, &rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].MemberPortmask, &rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].UntagPortmask));
		//assert_ok(RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET, &rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].Ext_portmask));
	}

#if defined(CONFIG_RG_RTL9602C_SERIES)
	//untag packets from non-binding port translate their cvid to internet wan vid
	if(rg_kernel.block_communication_between_internet_and_other)
	{
		uint32 addRsvAcl=FALSE, internetWanVid=0;

		if(rg_db.systemGlobal.non_binding_pmsk.portmask)
		{
			for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE
					&& rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->none_internet==0)
				{
					addRsvAcl = TRUE;
					internetWanVid = rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				}
			}
		}
		if(addRsvAcl)
		{
			rtk_rg_aclAndCf_reserved_lan_to_internet_bridgeWan_translate_vid_t lan_pask_and_wan_vid;
			lan_pask_and_wan_vid.portmask = rg_db.systemGlobal.non_binding_pmsk.portmask;
			lan_pask_and_wan_vid.wan_vid = internetWanVid;
			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_LAN_TO_INTERNET_BRIDGEWAN_VLAN_TRANSLATE, &lan_pask_and_wan_vid);
		}
		else
		{
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_LAN_TO_INTERNET_BRIDGEWAN_VLAN_TRANSLATE);
		}
	}
#endif

	//Clear All shortcut, otherwise shortcut decision may be different after binding!!
	_rtk_rg_shortCut_clear();

	return (RT_ERR_RG_OK);
}

int32 _rtk_rg_caculateOtherWanVlanID(rtk_rg_wanIntfConf_t *wanintf)
{
	int count=0,vidX=-1;
	rtk_rg_portmask_t bindingPmsk;
	memcpy(&bindingPmsk,&wanintf->port_binding_mask,sizeof(rtk_rg_portmask_t));

	//Caculate OtherWanVlan based on the lowest indes of bindingPmsk
	while(bindingPmsk.portmask>0)
	{
		if((bindingPmsk.portmask&0x1)>0)
		{
			//ext_port0 is 4, ext_port1 is 5
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RTL9601B_SERIES)
			if(count>RTK_RG_PORT3)
				count-=3;
#elif defined(CONFIG_RG_RTL9602C_SERIES)
			if(count>RTK_RG_PORT1)
				count-=2;
#endif
			vidX=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+count;
			break;
		}
		count++;
		bindingPmsk.portmask>>=1;
	}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	if(vidX==-1 && wanintf->wlan0_dev_binding_mask>0)
	{
		int dmsk=wanintf->wlan0_dev_binding_mask;
		vidX=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER;
		count=6;	//start from wlan's root

		while(dmsk>0)
		{
			if((dmsk&0x1)>0)
			{
				vidX+=count;
				break;
			}
			count++;
			dmsk>>=1;
		}
	}
#endif
	return vidX;
}


int32 _rtk_rg_updateBindOtherWanPortBasedVID(rtk_rg_wanIntfConf_t *otherWanIntf)
{
	int intfidx,i,vidX=-1;
	rtk_portmask_t mbpmsk, etpmsk;

	for(intfidx=0;intfidx<rg_db.systemGlobal.wanIntfTotalNum;intfidx++)
	{
		if(rg_db.systemGlobal.wanIntfGroup[intfidx].p_wanIntfConf->none_internet)
		{
			_rtk_rg_portmask_translator(rg_db.systemGlobal.wanIntfGroup[intfidx].p_wanIntfConf->port_binding_mask,&mbpmsk,&etpmsk);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			rg_db.vlan[rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index]].wlan0DevMask=0x0;	//clear first
			rg_db.vlan[rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index]].wlan0UntagMask=0x0;
			_rtk_rg_updateOtherWanWlan0Setting(rg_db.systemGlobal.wanIntfGroup[intfidx].p_wanIntfConf,&etpmsk,rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index]);
#endif
			//Change PVID of all binding port to OtherWanVlan
			for(i=RTK_RG_MAC_PORT0;i<RTK_RG_MAC_PORT_MAX;i++)
			{
				if(RG_INVALID_MAC_PORT(i)) continue;
				if(mbpmsk.bits[0]&(0x1<<i))
				{
					//20150408LUKE: check PPB first
					if(rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID].valid)
					{
						rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID].vid=rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index];
						ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV4_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID]),RT_ERR_OK);
						rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_ARP_GROUPID].vid=rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index];
						ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_ARP_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_ARP_GROUPID]),RT_ERR_OK);
					}
					else if(rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID].valid)
					{
						rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID].vid=rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index];
						ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV6_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID]),RT_ERR_OK);
					}
					else
						ASSERT_EQ(RTK_VLAN_PORTPVID_SET(i,rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index]),RT_ERR_OK);
				}
			}
			for(i=RTK_RG_EXT_PORT0;i<RTK_RG_PORT_MAX;i++)
			{
				if(RG_INVALID_PORT(i)) continue;
				//20140711LUKE: if we setup WLAN device binding, we can't change ext0 port's PVID here!
				//only change it's PVID when the ext0 port is in original out_ext_pmask.
				if(etpmsk.bits[0]&(0x1<<(i-RTK_RG_EXT_BASED_PORT)))
					ASSERT_EQ(RTK_VLAN_EXTPORTPVID_SET(i-RTK_RG_EXT_BASED_PORT,rg_db.systemGlobal.otherWanVlan[rg_db.systemGlobal.wanIntfGroup[intfidx].index]),RT_ERR_OK);
			}
		}
	}
	if(otherWanIntf!=NULL)
	{
		if(otherWanIntf->none_internet)
		{
			vidX=_rtk_rg_caculateOtherWanVlanID(otherWanIntf);
			if(vidX<0)
				RETURN_ERR(RT_ERR_RG_VLAN_OVER_RANGE);
			_rtk_rg_portmask_translator(otherWanIntf->port_binding_mask,&mbpmsk,&etpmsk);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			rg_db.vlan[vidX].wlan0DevMask=0x0;	//clear first
			rg_db.vlan[vidX].wlan0UntagMask=0x0;
			_rtk_rg_updateOtherWanWlan0Setting(otherWanIntf,&etpmsk,vidX);
#endif
			//Change PVID of all binding port to OtherWanVlan
			for(i=RTK_RG_MAC_PORT0;i<RTK_RG_MAC_PORT_MAX;i++)
			{
				if(RG_INVALID_MAC_PORT(i)) continue;
				if(mbpmsk.bits[0]&(0x1<<i))
				{
					//20150408LUKE: check PPB first
					if(rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID].valid)
					{
						rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID].vid=vidX;
						ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV4_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV4_GROUPID]),RT_ERR_OK);
						rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_ARP_GROUPID].vid=vidX;
						ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_ARP_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_ARP_GROUPID]),RT_ERR_OK);
					}
					else if(rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID].valid)
					{
						rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID].vid=vidX;
						ASSERT_EQ(RTK_VLAN_PORTPROTOVLAN_SET(i,RG_IPV6_GROUPID,&rg_db.systemGlobal.protoBasedVID[i].protoVLANCfg[RG_IPV6_GROUPID]),RT_ERR_OK);
					}
					else
						ASSERT_EQ(RTK_VLAN_PORTPVID_SET(i,vidX),RT_ERR_OK);
				}
			}
			for(i=RTK_RG_EXT_PORT0;i<RTK_RG_PORT_MAX;i++)
			{
				if(RG_INVALID_PORT(i)) continue;
				//20140711LUKE: if we setup WLAN device binding, we can't change ext0 port's PVID here!
				//only change it's PVID when the ext0 port is in original out_ext_pmask.
				if(etpmsk.bits[0]&(0x1<<(i-RTK_RG_EXT_BASED_PORT)))
					ASSERT_EQ(RTK_VLAN_EXTPORTPVID_SET(i-RTK_RG_EXT_BASED_PORT,vidX),RT_ERR_OK);
			}
		}
	}

	return RT_ERR_RG_OK;
}

int32 _rtk_rg_createOtherWanVlan(rtk_rg_wanIntfConf_t *wanintf, int *otherWanVlan, int reAddSameWan)
{
	int vidX,i,ret;
	rtk_portmask_t out_mac_pmask,out_ext_pmask;
	rtk_portmask_t _vlanExtPmsk;
	//init
	_vlanExtPmsk.bits[0]=0;
	_rtk_rg_portmask_translator(wanintf->port_binding_mask,&out_mac_pmask,&out_ext_pmask);

	//Create VID otherWanVlan based on the lowest index of bindingPmsk
	vidX=_rtk_rg_caculateOtherWanVlanID(wanintf);
	if(vidX<0)
		RETURN_ERR(RT_ERR_RG_VLAN_OVER_RANGE);

	//init
	DEBUG("vidX is %d , original vid is %d",vidX,reAddSameWan==FAIL?-1:rg_db.systemGlobal.otherWanVlan[reAddSameWan]);
	if(rg_db.vlan[vidX].valid==0)
	{
		//first use, create it
		ret = RTK_VLAN_CREATE(vidX);
		if (ret == RT_ERR_VLAN_EXIST)
		{
			DEBUG("Vid x[%d] had created..",vidX);
			rg_db.vlan[vidX].valid = 1;
		}
	}

	rg_db.vlan[vidX].MemberPortmask.bits[0]=out_mac_pmask.bits[0];	 //all binding LAN port with CPU
	rg_db.vlan[vidX].MemberPortmask.bits[0]|=RTK_RG_ALL_CPU_PORTMASK;
#if 1	//20170303: internal used vlan must be all untagged
	rg_db.vlan[vidX].UntagPortmask.bits[0]=RTK_RG_ALL_MAC_PORTMASK;	 //all untag
#else
	rg_db.vlan[vidX].UntagPortmask.bits[0]=out_mac_pmask.bits[0];	 //all untag
	rg_db.vlan[vidX].UntagPortmask.bits[0]|=RTK_RG_ALL_CPU_PORTMASK;
#endif

	_vlanExtPmsk.bits[0]=out_ext_pmask.bits[0];	 //all binding ext LAN port
	//rg_db.vlan[vidX].Ext_portmask.bits[0]=out_ext_pmask.bits[0];	 //all binding ext LAN port
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	_vlanExtPmsk.bits[0]|=0x1;
	//rg_db.vlan[vidX].Ext_portmask.bits[0]|=0x1;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	_rtk_rg_wlanDevMaskToExtPortmask_translator(wanintf->wlan0_dev_binding_mask, &_vlanExtPmsk);
#endif

	ret = RTK_VLAN_FID_SET(vidX, LAN_FID);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_kernel.block_communication_between_internet_and_other)
		ret = RTK_VLAN_FIDMODE_SET(vidX, VLAN_FID_IVL);		//This is used for ALL LAN interface
	else
#endif
		ret = RTK_VLAN_FIDMODE_SET(vidX, VLAN_FID_SVL);		//This is used for ALL LAN interface
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_PORT_SET(vidX, &rg_db.vlan[vidX].MemberPortmask, &rg_db.vlan[vidX].UntagPortmask);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);
	ret = RTK_VLAN_EXTPORT_SET(vidX, &_vlanExtPmsk);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

	_rtk_rg_updateBindOtherWanPortBasedVID(wanintf);

	//20140723LUKE: delete old vlan if different
	if(reAddSameWan!=FAIL)
	{
		for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
		{
			//if there is otherWan use the old vlan, we should not delete it!!
			if(i!=reAddSameWan)
			{
				if(rg_db.systemGlobal.otherWanVlan[i]==rg_db.systemGlobal.otherWanVlan[reAddSameWan])
				{
					rg_db.systemGlobal.otherWanVlan[reAddSameWan]=0;
					break;
				}
			}
		}
		if(vidX!=rg_db.systemGlobal.otherWanVlan[reAddSameWan])
		{
			if(rg_db.systemGlobal.otherWanVlan[reAddSameWan]!=0)
				RTK_VLAN_DESTROY(rg_db.systemGlobal.otherWanVlan[reAddSameWan]);
			rg_db.systemGlobal.otherWanVlan[reAddSameWan]=0;
		}
	}

	*otherWanVlan=vidX;

	return (RT_ERR_RG_OK);
}


void _rtk_rg_wanInterface_special_case_check(void)
{
	int i,j;

	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++) //check is there any PPPoE Wan
	{
		if(rg_db.systemGlobal.interfaceInfo[i].valid &&
			rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1 &&
			rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)
		{

			for(j=0;j<MAX_NETIF_SW_TABLE_SIZE;j++) //check is there any bridgeWan using the same interface vlan
			{
				if(rg_db.systemGlobal.interfaceInfo[j].valid &&
					rg_db.systemGlobal.interfaceInfo[j].storedInfo.is_wan==1 &&
					rg_db.systemGlobal.interfaceInfo[j].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE &&
					rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id==rg_db.systemGlobal.interfaceInfo[j].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id)
				{
					//show warning message to remind the patch may need for special case:
					WARNING("patch may need for specail case: PPPoE(v4_only)+bridgeWan(v6_only)  Or  PPPoE(v6_only)+bridgeWan(v4_only) with same interface vlan\n");
					WARNING("For PPPoE Wan need below patch:");
					WARNING("(1) ACL:(ingress_port_mask=WAN_PORT) + (ingress_ctag_vid=PPPoE_WAN_VID) + (ingress_dmac=WAN_GMAC) => (action_acl_ingress_vid=PPPoE_WAN_VID )  [avoid bridge patch ACL tranlate the vlan] \n");
					WARNING("For BridgeWan need below patch:");
					WARNING("(1) ACL:(ingress_port_mask=WAN_PORT) + (ingress_ctag_vid=PPPoE_WAN_VID) + (inrgess_ethertype=permit_ipversion_type) => (action_acl_ingress_vid=LAN_VID)   [avoid vlan filter]");
					WARNING("(2) ACL:(ingress_port_mask=BRIDGEWAN_PORT_BINDING_MASK) => Trap [avoid using wring sessionID] ");
					WARNING("(3) echo 1 > proc/rg/pppoe_bc_passthrought_to_bindingWan [PADI can be pass throught from LAN to WAN] ");
					WARNING("(4) echo [netIfIdx] [Action] > proc/rg/bridgeWan_drop_by_protocal [discard not support ip_veriosn in bridgeWan] ");
				}
			}

		}
	}
}

rtk_rg_err_code_t rtk_rg_apollo_wanInterface_add(rtk_rg_wanIntfConf_t *wanintf, int *wan_intf_idx)
{
	rtk_rg_err_code_t errorno;
	uint32 overlap_port_binding_mask;
	int i, reAddWanIdx;
	rtk_rg_wanIntfConf_t reAddWanIntf;

	if(rg_db.systemGlobal.initParam.macBasedTagDecision
		&& wanintf->port_binding_mask.portmask)
	{
		if(RG_INVALID_PORTMASK(wanintf->port_binding_mask.portmask))
			WARNING("WAN bind_mask(0x%x) is not valid", wanintf->port_binding_mask.portmask);
		if(wanintf->port_binding_mask.portmask&(0x1<<wanintf->wan_port_idx))	//wan port should not be included in port-binding portmask
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		if((wanintf->port_binding_mask.portmask&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK) > 0)	//port-binding should not be CPU port
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

		for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
		{
			overlap_port_binding_mask = rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask & wanintf->port_binding_mask.portmask;
			if(overlap_port_binding_mask)
			{
				WARNING("Portmask 0x%x Binded from WAN[%d] to this WAN!!...re-add WAN[%d]", overlap_port_binding_mask, rg_db.systemGlobal.wanIntfGroup[i].index, rg_db.systemGlobal.wanIntfGroup[i].index);
				memcpy(&reAddWanIntf, rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf, sizeof(rtk_rg_wanIntfConf_t));
				reAddWanIntf.port_binding_mask.portmask &= ~(overlap_port_binding_mask);
				reAddWanIntf.forcedAddNewIntf = 0;
				errorno = _rtk_rg_apollo_wanInterface_add(&reAddWanIntf, &reAddWanIdx);
				if(errorno!=RT_ERR_RG_OK) goto RET_ERR;
			}
		}
	}

	errorno = _rtk_rg_apollo_wanInterface_add(wanintf, wan_intf_idx);
RET_ERR:
	RETURN_ERR(errorno);
}

rtk_rg_err_code_t _rtk_rg_apollo_wanInterface_add(rtk_rg_wanIntfConf_t *wanintf, int *wan_intf_idx)
{
	int ret,i,vlanID,errorno,vlan_exist=0,tmpVid,nxpIdx=-1,v6nxpIdx=-1,wantypeIdx=-1,v6wantypeIdx=-1,pppoeIdx=-1,extipIdx=-1,baseIntfIdx=-1;
	unsigned int intfIdx,tmppmsk,tmpexpmsk,addToStaticMAC=0;
	unsigned int reAddSameWan=0,old_pmsk=0,old_extpmsk=0,delete_pmsk=0,delete_extpmsk=0;
	unsigned int disableBroadcast=0;
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	unsigned int isMasterSSidBind=0;
#ifdef CONFIG_DUALBAND_CONCURRENT
	unsigned int isSlaveSSidBind=0;
#endif
#endif
	rtk_rg_wirelessWan_t wirelessWan=RG_WWAN_WIRED;
	rtk_portmask_t mbpmsk,utpmsk,etpmsk,/*all_lan_pmsk,all_lan_etpmsk,all_lan_utagpmsk,*/wanPmsk;	//member, untag, extension port masks
	//rtk_portmask_t ori_CPU_member_mask,ori_CPU_untag_mask;//,ori_CPU_ext_mask;
	rtk_l34_netif_entry_t intfEntry;
	//rtk_l34_routing_entry_t rtEntry,ori_rtEt;
	rtk_rg_table_vlan_t ori_vlanEntry;
	rtk_portmask_t out_mac_pmask,out_ext_pmask;
	rtk_l34_nexthop_entry_t nxpEt;
	rtk_wanType_entry_t wantEt;
	rtk_fidMode_t fidMode;
	//rtk_vlan_protoVlanCfg_t protoVlanCfg;
	rtk_mac_t zeroMac={{0}};
#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	rtk_rg_portmask_t orig_pbdmsk;
	unsigned int changeBindingPmsk=0;
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//apolloPro no need reserved ACL support in this function
#else
	rtk_rg_aclAndCf_reserved_type_t rsvType;
	rtk_rg_aclAndCf_reserved_intf_linkLocal_trap_t	intf_link_local_trap_para;
#endif
	if(wanintf == NULL || wan_intf_idx == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(wanintf->egress_vlan_tag_on || wanintf->isIVL)
	{
		if(wanintf->egress_vlan_id < 0 || wanintf->egress_vlan_id >= MAX_VLAN_HW_TABLE_SIZE)		//invalid vid
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}
	else
	{
		if(wanintf->egress_vlan_id < 0 || wanintf->egress_vlan_id >= MAX_VLAN_SW_TABLE_SIZE)		//invalid vid
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}
	if(wanintf->wan_type<0 || wanintf->wan_type>=RTK_RG_WAN_TYPE_END)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(wanintf->bridgeToBindingWanByProtocol<0 || wanintf->bridgeToBindingWanByProtocol>=BGBWP_END)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//Check parameter
	//20160315LUKE: if portmask contain WAN port, return fail.
	if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_PORTMASK && rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<wanintf->wan_port_idx))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//if(rg_db.systemGlobal.lanIntfTotalNum==0)		//Check if LAN added before WAN creation
		//RETURN_ERR(RT_ERR_RG_LAN_NOT_EXIST);
	if((rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].valid && wanintf->egress_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_CPU) ||
#if !defined(CONFIG_RG_RTL9600_SERIES)
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN].valid && wanintf->egress_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN) ||
#endif
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block].valid && wanintf->egress_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block) ||
		(rg_db.systemGlobal.initParam.macBasedTagDecision==1 && (wanintf->egress_vlan_id == rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET ||
		(wanintf->egress_vlan_id >= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		wanintf->egress_vlan_id <= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET))))
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	//if(wanintf->egress_vlan_id >= DEFAULT_PPB_VLAN_START && wanintf->egress_vlan_id < (DEFAULT_PPB_VLAN_START+MAX_NETIF_SW_TABLE_SIZE))
		//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//20150427LUKE: check for wireless WAN setting
	if((wanintf->wan_port_idx)==RTK_RG_EXT_PORT2)
	{
#if defined(CONFIG_RTL_REPEATER_MODE_SUPPORT) && defined(CONFIG_MASTER_WLAN0_ENABLE)
		if(!rg_db.systemGlobal.wlan0BindDecision[RG_WWAN_WLAN0_VXD].exist)
			RETURN_ERR(RT_ERR_RG_WWAN_NOT_EXIST);
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
			if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wirelessWan==RG_WWAN_WLAN0_VXD)
				RETURN_ERR(RT_ERR_RG_WWAN_SAME_VXD);
		wirelessWan=RG_WWAN_WLAN0_VXD;
		wanintf->wan_port_idx=RTK_RG_PORT_PON;
#else
		RETURN_ERR(RT_ERR_RG_WWAN_NOT_EXIST);
#endif
	}
	else if((wanintf->wan_port_idx)==RTK_RG_EXT_PORT3)
	{
#if defined(CONFIG_RTL_REPEATER_MODE_SUPPORT) && defined(CONFIG_MASTER_WLAN0_ENABLE)
		if(!rg_db.systemGlobal.wlan0BindDecision[RG_WWAN_WLAN1_VXD].exist)
			RETURN_ERR(RT_ERR_RG_WWAN_NOT_EXIST);
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
			if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wirelessWan==RG_WWAN_WLAN1_VXD)
				RETURN_ERR(RT_ERR_RG_WWAN_SAME_VXD);
		wirelessWan=RG_WWAN_WLAN1_VXD;
		wanintf->wan_port_idx=RTK_RG_PORT_PON;
#else
		RETURN_ERR(RT_ERR_RG_WWAN_NOT_EXIST);
#endif
	}
	if(wanintf->wan_port_idx < RTK_RG_PORT0 || wanintf->wan_port_idx >= RTK_RG_EXT_PORT0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//20150309LUKE: always treat disabled pri as "-1"
	if(wanintf->vlan_based_pri_enable==RTK_RG_DISABLED)
		wanintf->vlan_based_pri=-1;
	else if(wanintf->vlan_based_pri<0 || wanintf->vlan_based_pri>7)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#if 0//def CONFIG_GPON_FEATURE
	if(rg_db.systemGlobal.initParam.wanPortGponMode && wanintf->wan_port_idx==RTK_RG_MAC_PORT_PON && (wanintf->gponStreamID<0||wanintf->gponStreamID>127))		//Check stream ID valid or not in GPON mode
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#endif
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		if(wanintf->isIVL)		//IVL can not be set when DMAC2CVID is trun on
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		if(wanintf->port_binding_mask.portmask&(0x1<<wanintf->wan_port_idx))	//wan port should not be included in port-binding portmask
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		if(RG_INVALID_PORTMASK(wanintf->port_binding_mask.portmask))WARNING("WAN bind_mask(%x) is not valid");
#ifdef CONFIG_MASTER_WLAN0_ENABLE
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(wanintf->wlan0_dev_binding_mask>>WLAN_DEVICE_NUM)WARNING("WAN wlan0bind_mask(%x) shoud not bigger than %x",wanintf->wlan0_dev_binding_mask,(0x1<<WLAN_DEVICE_NUM)-1);
#else
		if((MAX_WLAN_DEVICE_NUM<(sizeof(wanintf->wlan0_dev_binding_mask)*8))
			&& (wanintf->wlan0_dev_binding_mask>>MAX_WLAN_DEVICE_NUM))
			WARNING("WAN wlan0bind_mask(%x) shoud not bigger than %x",wanintf->wlan0_dev_binding_mask,((uint64)0x1<<MAX_WLAN_DEVICE_NUM)-1);
#endif
#endif
#if defined(CONFIG_RG_RTL9602C_SERIES)
		if(rg_kernel.wanDmac2cvidDisabled==0 && (wanintf->port_binding_mask.portmask>0 || wanintf->wlan0_dev_binding_mask>0))
			WARNING("Binding conflict DMAC2CVID if multi-vlan host exist at WAN!");//RETURN_ERR(RT_ERR_RG_BINDING_DMAC2CVID_CONFLICT);
#endif
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20170308LUKE: policy route may failed if there is binding rule exist.
		if(wanintf->port_binding_mask.portmask||wanintf->wlan0_dev_binding_mask){
			for(i=0;i<MAX_ACL_SW_ENTRY_SIZE;i++)
			{
				if(rg_db.systemGlobal.acl_SW_table_entry[i].valid==RTK_RG_ENABLED && rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.action_type==ACL_ACTION_TYPE_POLICY_ROUTE)
				{
					WARNING("Binidng could not coexist with Policy Route at this platform!");
					RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
				}
			}
		}
#endif
	}else{
		if(wanintf->port_binding_mask.portmask>0)		//set port-binding but global switch is off
			RETURN_ERR(RT_ERR_RG_BIND_WITH_UNBIND_WAN);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
		if(wanintf->wlan0_dev_binding_mask>0)			//set ssid-binding but global switch is off
			RETURN_ERR(RT_ERR_RG_BIND_WITH_UNBIND_WAN);
#endif
	}

#if 0
	//test chip should not restrict wan port to PON or RGMII, since it do not has binding function
	if(wanintf->wan_port_idx<RTK_RG_MAC_PORT_PON || wanintf->wan_port_idx>RTK_RG_MAC_PORT_RGMII)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#endif
	/*if((wanintf->wan_port_idx==RTK_RG_MAC_PORT_PON && RG_GLB_WAN_PON_USED == 1) || 			//wan port used
		(wanintf->wan_port_idx==RTK_RG_MAC_PORT_RGMII && RG_GLB_WAN_RGMII_USED == 1))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);*/
#ifdef CONFIG_MASTER_WLAN0_ENABLE
#ifdef CONFIG_DUALBAND_CONCURRENT
	for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
	for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
	{
		if(wanintf->wlan0_dev_binding_mask&(0x1<<i))
		{
			isMasterSSidBind=1;
			break;
		}
	}
	//If we or other WAN enable ext0 port in port-binding-mask, means we are binding ALL wlan0 device to single wan,
	//therefore wlan0-dev-binding-mask sould keep zero.
	if((wanintf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT0)) && isMasterSSidBind==1)
		RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);

#ifdef CONFIG_DUALBAND_CONCURRENT
	for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
	{
		if(wanintf->wlan0_dev_binding_mask&(0x1<<i))
		{
			isSlaveSSidBind=1;
			break;
		}
	}
	//If we or other WAN enable ext1 port in port-binding-mask, means we are binding ALL wlan1 device to single wan,
	//therefore wlan0-dev-binding-mask with wlan1's device sould keep zero.
	if((wanintf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT1)) && isSlaveSSidBind==1)
		RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
#endif

	//Check if the WLAN0's devices are absence or already binded by other WAN separately
	//20140718LUKE: we need to support dynamic replace WLAN binding when add WAN, so display WARNING instead return error.
	for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
	{
		if(wanintf->wlan0_dev_binding_mask&(0x1<<i))
		{
			if(!rg_db.systemGlobal.wlan0BindDecision[i].exist)
				RETURN_ERR(RT_ERR_RG_WLAN_BINDING_ABSENCE);
			else if(rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
			{
				WARNING("WLAN0 Dev[%d] Binded from WAN[%d] to this WAN!!",i,rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf);//RETURN_ERR(RT_ERR_RG_WLAN_BINDING_OVERLAP);
				//remove this WLAN device from original binding WAN
				rg_db.systemGlobal.interfaceInfo[rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf].storedInfo.wan_intf.wan_intf_conf.wlan0_dev_binding_mask&=(~(0x1<<i));
				rg_db.systemGlobal.wlan0BindDecision[i].set_bind=0;
				rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf=0;
				rg_db.systemGlobal.wlan0BindingUsed&=(~(0x1<<i));
			}
		}
	}
#endif
	if(RG_INVALID_PORTMASK(wanintf->port_binding_mask.portmask))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if((wanintf->port_binding_mask.portmask&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK) > 0)	//port-binding should not be CPU port
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(wanintf->gmac.octet[0]&1)	//interface MAC can not use multicast address
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	//20160524LUKE: check wlan-device existence
	_rtk_rg_check_wlan_device_exist_or_not();
#endif

	//for non-zero MAC address, we should add it as static gateway mac in LUT table
	if(memcmp(wanintf->gmac.octet,zeroMac.octet,ETHER_ADDR_LEN))
		addToStaticMAC=1;

	vlanID=wanintf->egress_vlan_id;
	wanPmsk.bits[0]=0x1<<wanintf->wan_port_idx;	//pon is the 4th bit and RGMII is 5th
	//all_lan_pmsk.bits[0]=wanPmsk.bits[0];
	//all_lan_etpmsk.bits[0]=0;
	//all_lan_utagpmsk.bits[0]=0;

	//Check if we are re-add same WAN interface
	//20141229LUKE: add forcedAdd option to create new interface even parameters are the same. (for static route)
	if(!wanintf->forcedAddNewIntf)
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(wanintf->wan_type==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type &&
				!memcmp(wanintf->gmac.octet,rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,ETHER_ADDR_LEN) &&
				wanintf->wan_port_idx==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx &&
				wanintf->egress_vlan_tag_on==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on &&
				wanintf->egress_vlan_id==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id &&
				wanintf->vlan_based_pri_enable==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->vlan_based_pri_enable &&
				wanintf->vlan_based_pri==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->vlan_based_pri &&
				wanintf->isIVL==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->isIVL &&
				wanintf->none_internet==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->none_internet)
				{
					reAddSameWan=1;
					intfIdx=rg_db.systemGlobal.wanIntfGroup[i].index;	//keep
					DEBUG("reAdd WAN[%d]!!",intfIdx);

					//Convert RG portmask to RTK portmask
					_rtk_rg_portmask_translator(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask,&out_mac_pmask,&out_ext_pmask);
					old_pmsk=out_mac_pmask.bits[0];
					old_extpmsk=out_ext_pmask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
					old_extpmsk >>= 0x1;	//FIXME:translator contain cpu port, but binding should not contain it, so shift it
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
					/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
					DEBUG("old pmsk is %x, old extpmsk is %x",old_pmsk,old_extpmsk);
					_rtk_rg_portmask_translator(wanintf->port_binding_mask,&out_mac_pmask,&out_ext_pmask);
					delete_pmsk=old_pmsk&(~out_mac_pmask.bits[0]);
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
					delete_extpmsk=old_extpmsk&(~(out_ext_pmask.bits[0]>>0x1));	//FIXME:translator contain cpu port, but binding should not contain it, so shift it
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
					/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
					delete_extpmsk=old_extpmsk&(~(out_ext_pmask.bits[0]));
#else
#error
#endif
					DEBUG("need to be delete: pmsk=%x, extpmsk=%x",delete_pmsk,delete_extpmsk);
					break;
				}
		}

		if(reAddSameWan)
		{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			if((wanintf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT0)))
			{
				//Check if the WLAN0's devices are absence or already binded by other WAN separately
#ifdef CONFIG_DUALBAND_CONCURRENT
				for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
				for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
				{
					if(rg_db.systemGlobal.wlan0BindDecision[i].exist && rg_db.systemGlobal.wlan0BindDecision[i].set_bind && rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf!=intfIdx)
						RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
				}
			}
			if(isMasterSSidBind)
			{
				for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
				{
					if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT0) && rg_db.systemGlobal.wanIntfGroup[i].index!=intfIdx)
						RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
				}
			}
#ifdef CONFIG_DUALBAND_CONCURRENT
			if((wanintf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT1)))
			{
				//Check if the WLAN1's devices are absence or already binded by other WAN separately
				for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
				{
					if(rg_db.systemGlobal.wlan0BindDecision[i].exist && rg_db.systemGlobal.wlan0BindDecision[i].set_bind && rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf!=intfIdx)
						RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
				}
			}
			if(isSlaveSSidBind)
			{
				for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
				{
					if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT1) && rg_db.systemGlobal.wanIntfGroup[i].index!=intfIdx)
						RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
				}
			}
#endif
#endif

#ifdef CONFIG_MASTER_WLAN0_ENABLE
#ifdef CONFIG_DUALBAND_CONCURRENT
			for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
			for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
			{
				if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
				{
					//20140723LUKE: Clear old wlan0 binding
					if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wlan0_dev_binding_mask&(0x1<<i))
					{
						rg_db.systemGlobal.wlan0BindDecision[i].set_bind=0;
						rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf=0;
						rg_db.systemGlobal.wlan0BindingUsed&=(~(0x1<<i));
						assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,rg_db.systemGlobal.portBasedVID[RTK_RG_EXT_PORT0]));
					}
				}
			}
#ifdef CONFIG_DUALBAND_CONCURRENT
			for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
			{
				if(rg_db.systemGlobal.wlan0BindDecision[i].exist)
				{
					//20140723LUKE: Clear old wlan0 binding
					if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wlan0_dev_binding_mask&(0x1<<i))
					{
						rg_db.systemGlobal.wlan0BindDecision[i].set_bind=0;
						rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf=0;
						rg_db.systemGlobal.wlan0BindingUsed&=(~(0x1<<i));
						assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,i,rg_db.systemGlobal.portBasedVID[RTK_RG_EXT_PORT1]));

					}
				}
			}
#endif
#endif
			goto RESET_INTF;
		}
	}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	if((wanintf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT0)))
	{
		//Check if the WLAN0's devices are absence or already binded by other WAN separately
#ifdef CONFIG_DUALBAND_CONCURRENT
		for(i=0;i<WLAN_DEVICE_NUM;i++)
#else
		for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
#endif
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist && rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
				RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
		}
	}
	if(isMasterSSidBind)
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT0))
				RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
		}
	}
#ifdef CONFIG_DUALBAND_CONCURRENT
	if((wanintf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT1)))
	{
		//Check if the WLAN1's devices are absence or already binded by other WAN separately
		for(i=WLAN_DEVICE_NUM;i<MAX_WLAN_DEVICE_NUM;i++)
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist && rg_db.systemGlobal.wlan0BindDecision[i].set_bind)
				RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
		}
	}
	if(isSlaveSSidBind)
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->port_binding_mask.portmask&(0x1<<RTK_RG_EXT_PORT1))
				RETURN_ERR(RT_ERR_RG_WLAN_BINDING_CONFLICT);
		}
	}
#endif
#endif

	//Check if we set two untag bridge WAN at the same port
	if(wanintf->wan_type==RTK_RG_BRIDGE && wanintf->egress_vlan_tag_on==0)
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			rtk_rg_port_idx_t wan_port_idx=wanintf->wan_port_idx;
#if defined(CONFIG_RTL_REPEATER_MODE_SUPPORT) && defined(CONFIG_MASTER_WLAN0_ENABLE)
			if(wirelessWan==RG_WWAN_WLAN0_VXD)wan_port_idx=RTK_RG_EXT_PORT2;
			else if(wirelessWan==RG_WWAN_WLAN1_VXD)wan_port_idx=RTK_RG_EXT_PORT3;
#endif
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on==0 &&
				rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE &&
				rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx==wan_port_idx)
				RETURN_ERR(RT_ERR_RG_UNTAG_BRIDGEWAN_TWICE);
		}
	}

	//Check if we didn't add LAN interface before un-binding bridge WAN
	//if(wanintf->wan_type==RTK_RG_BRIDGE && wanintf->port_binding_mask.portmask==0 && rg_db.systemGlobal.lanIntfTotalNum==0)
		//RETURN_ERR(RT_ERR_RG_LAN_NOT_EXIST);

	//Check if VLAN init
	if(rg_db.systemGlobal.vlanInit==0)
		RETURN_ERR(RT_ERR_RG_NOT_INIT);

	//Check VLAN-binding use this VLAN or not
	/*for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
		if(rg_db.bind[i].valid && rg_db.bind[i].rtk_bind.vidLan==wanintf->egress_vlan_id)
			RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_VLANBINDING);*/
	//Checl Customer VLAN use this VLAN or not
	if(rg_db.vlan[wanintf->egress_vlan_id].valid && rg_db.vlan[wanintf->egress_vlan_id].addedAsCustomerVLAN)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_CVLAN);

	//Check interface table available or not
	if(rg_db.systemGlobal.intfIdxForReset == -1)
	{


		for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
		{

#if defined(CONFIG_RG_RTL9600_SERIES)
			//PATCH_20131022:Because CF rule will use WAN intf as zero, and multicast will use index 7, so these indexes are avoided!!
			if( (i==0) || (i ==(MAX_NETIF_HW_TABLE_SIZE-1)) )
				continue ;
#endif

			if(rg_db.systemGlobal.interfaceInfo[i].valid == IF_INVALID_ENTRY)
				break;
		}
		if(i==MAX_NETIF_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);

		intfIdx=i;
		//rtlglue_printf("rg_db.systemGlobal.intfIdxForReset == -1(%d): intfIdx=%d \n",__LINE__,intfIdx);
	}
	else
	{
		//we are reset the added wan interface, so give me the same index!!
		intfIdx = rg_db.systemGlobal.intfIdxForReset;
		rg_db.systemGlobal.intfIdxForReset = -1;

		//rtlglue_printf("else(%d): intfIdx=%d \n",__LINE__,intfIdx);
	}

	//Check pppoe table available or not if wanType=pppoe or pppoe_dslite
	if((wanintf->wan_type == RTK_RG_PPPoE)||(wanintf->wan_type == RTK_RG_PPPoE_DSLITE)){
		for(i=0;i<MAX_PPPOE_SW_TABLE_SIZE;i++){
			if(rg_db.pppoe[i].rtk_pppoe.sessionID==0)
				break;
		}
		if(i==MAX_PPPOE_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
		pppoeIdx=i;
		rg_db.pppoe[i].rtk_pppoe.sessionID=0xffffffff;	//prevent another interface choose same PPPoE index
	}
#if defined(CONFIG_RG_RTL9602C_SERIES)
	//20151001LUKE: lookup for invalid DSlite entry if wan_type is DSlite or PPPoE_DSlite
	if((wanintf->wan_type == RTK_RG_DSLITE)||(wanintf->wan_type == RTK_RG_PPPoE_DSLITE)){
		for(i=0;i<MAX_DSLITE_SW_TABLE_SIZE;i++){
			if(rg_db.dslite[i].rtk_dslite.valid==DISABLED)
				break;
		}
		if(i==MAX_DSLITE_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.dslite_idx=i;
		rg_db.dslite[i].rtk_dslite.valid=ENABLED;
		rg_db.dslite[i].rtk_dslite.index=i;
		rg_db.dslite[i].intfIdx=intfIdx;
	}
#endif
RESET_INTF:
	//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (wanintf->wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (wanintf->wan_port_idx)==RTK_RG_PORT_PON){
		DEBUG("Special change WAN_PORT from PON to RGMII.");
		wanintf->wan_port_idx=RTK_RG_PORT_RGMII;
		wanPmsk.bits[0]|=0x1<<RTK_RG_PORT_RGMII;
	}
#endif
	//------------------ Critical Section start -----------------------//
	//rg_lock(&rg_kernel.interfaceLock);

	//20140723LUKE: bypass set interface
	if(reAddSameWan)goto DELETE_OLD_BIND;

	//Set up interface table
	errorno=RT_ERR_RG_INTF_SET_FAIL;
	bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
	intfEntry.valid=1;
	//20151002LUKE: for bridge WAN interface should not fill GMAC in interface table!
	if(wanintf->wan_type != RTK_RG_BRIDGE)
		memcpy(intfEntry.gateway_mac.octet, wanintf->gmac.octet,ETHER_ADDR_LEN);
	intfEntry.mac_mask=0x7;	//no mask
	intfEntry.vlan_id=vlanID;
	intfEntry.enable_rounting=1;
	intfEntry.mtu=1500;				//This dummy value should be fine since we don't care MTU in L2 bridging!!

#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(wanintf->wan_type != RTK_RG_BRIDGE){
		intfEntry.isL34=1;
		intfEntry.ipAddr=0xffffffff;	//20200210LUKE: in case matched before IPversion and IPaddress is decided. The HSA l3intf will OR all matched interfaces.
	}
	intfEntry.isCtagIf=wanintf->egress_vlan_tag_on;

	if((wanintf->wan_type == RTK_RG_DSLITE)||(wanintf->wan_type == RTK_RG_PPPoE_DSLITE))
	{
		intfEntry.dslite_state=ENABLED;
		intfEntry.dslite_idx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.dslite_idx;
	}
	else
	{
		intfEntry.dslite_state=DISABLED;
		intfEntry.dslite_idx=0;
	}
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(wanintf->wan_type != RTK_RG_BRIDGE)
		intfEntry.isL34=1;
	intfEntry.isCtagIf=wanintf->egress_vlan_tag_on;
	if((wanintf->wan_type == RTK_RG_DSLITE)||(wanintf->wan_type == RTK_RG_PPPoE_DSLITE))
		intfEntry.dslite_state=ENABLED;

#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
	//Patch for 0601 and 6266, when binding to interface happened,
	//the packet size have 2 byte would't decrease, causing TRAP reason 224.
	//therefore the hardware setting should be set as preferred value plus 2 here
	if(rg_kernel.apolloChipId==APOLLOMP_CHIP_ID && rg_db.systemGlobal.initParam.macBasedTagDecision)
		intfEntry.mtu=1502;
#endif

	// for testing upstream(jumbo frame) binding to bridge wan
	if(wanintf->wan_type == RTK_RG_BRIDGE)
		intfEntry.mtu=DEFAULT_BRIDGE_WAN_MTU; //14 bits

	//if VLAN-based and bridge WAN MAC is zero, set this netif entry as invalid!!(for interface index synchronisation)
	if(wanintf->wan_type==RTK_RG_BRIDGE && rg_db.systemGlobal.initParam.macBasedTagDecision==0 && !addToStaticMAC)
		intfEntry.valid=0;
	DEBUG("Add NETIF[%d] VLAN[%d]\n",intfIdx,intfEntry.vlan_id);
	ret = RTK_L34_NETIFTABLE_SET(intfIdx, &intfEntry);
	DEBUG("ret:%x\n",ret);
	if(ret!=RT_ERR_OK)goto RET_INTF_ERR;

	//reset software MTU should keep original MTU, only hardware MTU need to patch!!
	if(wanintf->wan_type != RTK_RG_BRIDGE) // for testing upstream(jumbo frame) binding to bridge wan
		rg_db.netif[intfIdx].rtk_netif.mtu=1500;

DELETE_OLD_BIND:

	//Convert RG portmask to RTK portmask
	_rtk_rg_portmask_translator(wanintf->port_binding_mask,&out_mac_pmask,&out_ext_pmask);
	tmppmsk=out_mac_pmask.bits[0];
	tmpexpmsk=out_ext_pmask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	tmpexpmsk >>= 0x1;	//FIXME:translator contain cpu port, but binding should not contain it, so shift it
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif

#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	orig_pbdmsk.portmask=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask;	//keep orig port-binding mask for ACL rearrange
#endif
	DEBUG("the binding mask is %x, extmsk is %x, wlan0_bind_mask is %x",tmppmsk,tmpexpmsk,wanintf->wlan0_dev_binding_mask);

	//Check if there is other interface or vlan-binding set same port as binding port
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		errorno=RT_ERR_RG_PORT_BIND_SET_FAIL;
		for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
		{
			if(rg_db.bind[i].valid)
			{
				//we should not assign the same port binding with different Wan interface
				//20140718LUKE: we need to support dynamic replace port binding when add WAN, so display WARNING instead return error.
				ret=0;
				if(reAddSameWan && rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx==intfIdx)
				{
					//keep the unchange port-binding rules for the same WAN!
					if((rg_db.bind[i].rtk_bind.portMask.bits[0]&tmppmsk)>0 || (rg_db.bind[i].rtk_bind.extPortMask.bits[0]&tmpexpmsk)>0)
						continue;
				}
				if((rg_db.bind[i].rtk_bind.portMask.bits[0]&tmppmsk)>0 || (rg_db.bind[i].rtk_bind.portMask.bits[0]&delete_pmsk)>0)
				{
					//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
					if(rg_db.bind[i].rtk_bind.vidLan==0)
					{
						if(!reAddSameWan)WARNING("Portmask 0x%x Binded from WAN[%d] to this WAN!!",rg_db.bind[i].rtk_bind.portMask.bits[0],rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx);
						ret=1;
					}
					else
					{
						if(!reAddSameWan)WARNING("Vlan[%d]@Portmask 0x%x Binded from WAN[%d] will add port-binding to this WAN!!(Vlan-binding is untouched)",rg_db.bind[i].rtk_bind.vidLan,rg_db.bind[i].rtk_bind.portMask.bits[0],rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx);
					}
				}
				if((rg_db.bind[i].rtk_bind.extPortMask.bits[0]&tmpexpmsk)>0 || (rg_db.bind[i].rtk_bind.extPortMask.bits[0]&delete_extpmsk)>0)
				{
					//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
					if(rg_db.bind[i].rtk_bind.vidLan==0)
					{
						if(!reAddSameWan)WARNING("ExtPortmask 0x%x Binded from WAN[%d] to WAN!!",rg_db.bind[i].rtk_bind.extPortMask.bits[0],rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx);
						ret=1;
					}
					else
					{
						if(!reAddSameWan)WARNING("Vlan[%d]@ExtPortmask 0x%x Binded from WAN[%d] will add port-binding to this WAN!!(Vlan-binding is untouched)",rg_db.bind[i].rtk_bind.vidLan,rg_db.bind[i].rtk_bind.extPortMask.bits[0],rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx);
					}
				}

				if(ret)
				{
					rtk_rg_table_bind_t ori_bindEntry;

					memcpy(&ori_bindEntry,&rg_db.bind[i],sizeof(rtk_rg_table_bind_t));	//store software
					bzero(&rg_db.bind[i],sizeof(rtk_rg_table_bind_t));					//clear software
					ret=RTK_L34_BINDINGTABLE_SET(i,&rg_db.bind[i].rtk_bind);			//clear hardware
					memcpy(&rg_db.bind[i],&ori_bindEntry,sizeof(rtk_rg_table_bind_t));	//recovery software
					if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
					{
						errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
						goto RET_OVERLAP_BIND_ERR;
					}
					if(ret!=RT_ERR_OK)goto RET_OVERLAP_BIND_ERR;
					rg_db.bind[i].valid = INVALID_ENTRY;

					//remove the overlap port from original binding WAN
					if(ori_bindEntry.rtk_bind.portMask.bits[0]>0)
						rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[rg_db.wantype[ori_bindEntry.rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask&=(~(ori_bindEntry.rtk_bind.portMask.bits[0]));
					else
						rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[rg_db.wantype[ori_bindEntry.rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask&=(~(ori_bindEntry.rtk_bind.extPortMask.bits[0]<<RTK_RG_EXT_PORT0));

#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
					changeBindingPmsk=1;
#endif
				}
			}
		}
	}

	//Check if Bridge mode
	//20150303LUKE: we should not block broadcast from WAN when macBasedTagDecision is on.
	if((rg_db.systemGlobal.initParam.macBasedTagDecision==0)&&(wanintf->wan_type==RTK_RG_BRIDGE))
	{
		//Get all Lan interface and add WAN port to their VLAN
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			tmpVid=rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id;

			//Check if there is LAN interface has same VLAN id with me, if so, disable broadcast to avoid re-send packet!!
			if(tmpVid==vlanID)disableBroadcast=1;

			//20140424LUKE:we don't add WAN to LAN now, since binding scenario need more complicated setting!!
#if 0
			if(rg_db.systemGlobal.initParam.macBasedTagDecision)		//only add to LAN interface if MAC-based
			{
				memcpy(&mbpmsk, &rg_db.vlan[tmpVid].MemberPortmask,sizeof(rtk_portmask_t));
				memcpy(&utpmsk, &rg_db.vlan[tmpVid].UntagPortmask,sizeof(rtk_portmask_t));
				memcpy(&etpmsk, &rg_db.vlan[tmpVid].Ext_portmask,sizeof(rtk_portmask_t));

				//Let WAN port become active in LAN's VLAN member port mask
				//mbpmsk.bits[0] |= wanintf->wan_port_mask.bits[0];
				mbpmsk.bits[0] |= wanPmsk.bits[0];
				//add wan port to lan's untag set by egress_tag_on setting
				for(j=0;j<rg_db.systemGlobal.wanIntfTotalNum;j++)
				{
					if(rg_db.systemGlobal.wanIntfGroup[j].p_wanIntfConf->wan_type==RTK_RG_BRIDGE && wanPmsk.bits[0]&(0x1<<rg_db.systemGlobal.wanIntfGroup[j].p_wanIntfConf->wan_port_idx))
						break;
				}
				if(j==rg_db.systemGlobal.wanIntfTotalNum)		//no before bridge WAN added at this port
				{
					if(wanintf->egress_vlan_tag_on)			//egress tagged packet
						utpmsk.bits[0]&=(~(wanPmsk.bits[0]));	//set WAN port to 0 in untag set (tagging)
					else
						utpmsk.bits[0]|=wanPmsk.bits[0];		//set WAN port to 1 in untag set (untagging)
				}

				//Keep Lan's member port mask in all_lan_pmsk and all_lan_etpmsk
				all_lan_pmsk.bits[0] |= mbpmsk.bits[0];
				all_lan_etpmsk.bits[0] |= etpmsk.bits[0];
				all_lan_utagpmsk.bits[0] |= utpmsk.bits[0];

				errorno=RT_ERR_RG_VLAN_SET_FAIL;
				ret = RTK_VLAN_PORT_SET(tmpVid, &mbpmsk, &utpmsk);
				if(ret!=RT_ERR_OK)goto RET_BRIDGE_ERR;
			}
#endif
		}
	}



	//L3 routing interface (Static or DHCP or PPPOE) will reach here directly
	//Set up VLAN
	memset(&ori_vlanEntry,0,sizeof(rtk_rg_table_vlan_t));
	mbpmsk=wanPmsk;			//WAN port mask
	etpmsk.bits[0]=0;
	utpmsk.bits[0]=0;

	errorno=RT_ERR_RG_VLAN_SET_FAIL;
	ret = RTK_VLAN_CREATE(vlanID);
	if(ret == RT_ERR_VLAN_EXIST)
	{
		//keep all information of original VLAN
		memcpy(&ori_vlanEntry, &rg_db.vlan[vlanID],sizeof(rtk_rg_table_vlan_t));

		vlan_exist=1;
	} else if(ret!=RT_ERR_OK)
		goto RET_VLAN_ERR;

	//Set up its member port, extension port set, and FID mode
	//decide to use IVL or SVL for VLAN tag decision, IVL by untag set; SVL by DMAC2CVID
	if(wanintf->isIVL)
		fidMode=VLAN_FID_IVL;		//vlan-based
	else
		fidMode=VLAN_FID_SVL;		//mac-based
	ret = RTK_VLAN_FIDMODE_SET(vlanID, fidMode);		//Patch 20121130
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	ret = RTK_VLAN_FID_SET(vlanID, WAN_FID);		//Patch 20121130
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	mbpmsk.bits[0]|=ori_vlanEntry.MemberPortmask.bits[0];
	etpmsk.bits[0]|=ori_vlanEntry.Ext_portmask.bits[0];
	utpmsk.bits[0]|=ori_vlanEntry.UntagPortmask.bits[0];

	//20140424LUKE:we don't add LAN to WAN now, since binding scenario need more complicated setting!!
#if 0
	//only add LAN member to WAN when DMAC2CVID is turn on (mac-based)
	if(wanintf->wan_type == RTK_RG_BRIDGE && rg_db.systemGlobal.initParam.macBasedTagDecision==1)
	{
		//Patch for flooding 20121129, noneed, because we change to svl at all
		/*if(vlan_exist==0)
		{
			ret = RTK_VLAN_FIDMODE_SET(vlanID, VLAN_FID_SVL);
			if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
			ret = RTK_VLAN_FID_SET(vlanID, LAN_FID);
			if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
		}*/
		mbpmsk.bits[0]|=all_lan_pmsk.bits[0];		//add LAN port into WAN VLAN member port mask
		etpmsk.bits[0]|=all_lan_etpmsk.bits[0];		//add LAN ext-port into WAN VLAN ext-port mask
		utpmsk.bits[0]|=all_lan_utagpmsk.bits[0];	//add LAN untag-port into WAN VLAN untag-port mask
	}
#else
	//20140502LUKE:Only turn on this when macBasedTagDecision is set to 1
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		_rtk_rg_updateBindWanIntf(wanintf);	//update fwdVLAN_BIND_INTERNET member and set un-bind LAN to it

		//Set WAN VID's LAN member
		if(wanintf->port_binding_mask.portmask == 0 && wanintf->wlan0_dev_binding_mask == 0)	//non-binding
		{
			//dismiss all LAN member...
			//mbpmsk.bits[0]&=(~(0x1<<RTK_RG_PORT0|0x1<<RTK_RG_PORT1|0x1<<RTK_RG_PORT2|0x1<<RTK_RG_PORT3));
			//etpmsk.bits[0]&=(~(	(0x1<<(RTK_RG_EXT_PORT0-RTK_RG_PORT_CPU))|(0x1<<(RTK_RG_EXT_PORT1-RTK_RG_PORT_CPU))));
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			//dismiss all WLAN0 Device in VLAN's Mask
			//rg_db.vlan[vlanID].wlan0DevMask=0x0;
			//rg_db.vlan[vlanID].wlan0UntagMask=0x0;
#endif
			//internet WAN's LAN member is come from fwdVLAN_BIND_INTERNET
			if(!wanintf->none_internet && wanintf->wan_type == RTK_RG_BRIDGE)
			{
				//assign LAN member to fwdVLAN_BIND_INTERNET's member
				mbpmsk.bits[0]|=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].MemberPortmask.bits[0];
				etpmsk.bits[0]|=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].Ext_portmask.bits[0];
#ifdef CONFIG_MASTER_WLAN0_ENABLE
				//assign fwdVLAN_BIND_INTERNET's WLAN0 Device to VLAN's Mask
				rg_db.vlan[vlanID].wlan0DevMask|=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask;
				rg_db.vlan[vlanID].wlan0UntagMask|=rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0UntagMask;
#endif

				//20140516LUKE:All LAN port should be untag, CPU port will follow WAN port's setting!
				utpmsk.bits[0]|=(rg_db.systemGlobal.lanPortMask.portmask & RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU);
			}

			if(reAddSameWan && rg_db.systemGlobal.otherWanVlan[intfIdx]!=0)
			{
				//delete Other Wan's VLANID used for traffic isolation
				ret = RTK_VLAN_DESTROY(rg_db.systemGlobal.otherWanVlan[intfIdx]);
				errorno=RT_ERR_RG_VLAN_SET_FAIL;
				if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
				rg_db.systemGlobal.otherWanVlan[intfIdx]=0;
			}
		}
		else
		{
			if(wanintf->none_internet)
			{
				//create Other VLAN!
				if(reAddSameWan)
					errorno=_rtk_rg_createOtherWanVlan(wanintf,&ret,intfIdx);
				else
					errorno=_rtk_rg_createOtherWanVlan(wanintf,&ret,FAIL);
				if(errorno==RT_ERR_RG_OK)
				{
					//dismiss all LAN member...
					//mbpmsk.bits[0]&=(~(0x1<<RTK_RG_PORT0|0x1<<RTK_RG_PORT1|0x1<<RTK_RG_PORT2|0x1<<RTK_RG_PORT3));
					//etpmsk.bits[0]&=(~(	(0x1<<(RTK_RG_EXT_PORT0-RTK_RG_PORT_CPU))|(0x1<<(RTK_RG_EXT_PORT1-RTK_RG_PORT_CPU))));
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					//dismiss all WLAN0 Device in VLAN's Mask
					//rg_db.vlan[vlanID].wlan0DevMask=0x0;
					//rg_db.vlan[vlanID].wlan0UntagMask=0x0;
#endif
					if(wanintf->wan_type == RTK_RG_BRIDGE)
					{
						//assign LAN member to Other VLAN's member
						mbpmsk.bits[0]|=rg_db.vlan[ret].MemberPortmask.bits[0];
						etpmsk.bits[0]|=rg_db.vlan[ret].Ext_portmask.bits[0];
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						//assign Other VLAN's WLAN0 Device to mask of WAN's VLAN
						rg_db.vlan[vlanID].wlan0DevMask|=rg_db.vlan[ret].wlan0DevMask;
						rg_db.vlan[vlanID].wlan0UntagMask|=rg_db.vlan[ret].wlan0UntagMask;
#endif
						//assign WAN port to Other VLAN's member
						rg_db.vlan[ret].MemberPortmask.bits[0]|=wanPmsk.bits[0];

						errorno = RTK_VLAN_PORT_SET(ret, &rg_db.vlan[ret].MemberPortmask, &rg_db.vlan[ret].UntagPortmask);
						if(errorno!=RT_ERR_OK)
							goto RET_VLAN_ERR;

						//20140925LUKE:All LAN port would be untag
						utpmsk.bits[0]|=(rg_db.systemGlobal.lanPortMask.portmask & RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU);
					}

					//Store this VLAN ID in WAN's data structure
					rg_db.systemGlobal.otherWanVlan[intfIdx]=ret;
				}
				else
				{
					//fail, recovery..
					_rtk_rg_updateBindWanIntf(NULL);
					goto RET_VLAN_ERR;
				}
			}
			else	//internet binding WAN
			{
				//dismiss all LAN member...
				//mbpmsk.bits[0]&=(~(0x1<<RTK_RG_PORT0|0x1<<RTK_RG_PORT1|0x1<<RTK_RG_PORT2|0x1<<RTK_RG_PORT3));
				//etpmsk.bits[0]&=(~(	(0x1<<(RTK_RG_EXT_PORT0-RTK_RG_PORT_CPU))|(0x1<<(RTK_RG_EXT_PORT1-RTK_RG_PORT_CPU))));
#ifdef CONFIG_MASTER_WLAN0_ENABLE
				//dismiss all WLAN0 Device in VLAN's Mask
				//rg_db.vlan[vlanID].wlan0DevMask=0x0;
				//rg_db.vlan[vlanID].wlan0UntagMask=0x0;
#endif
				if(wanintf->wan_type == RTK_RG_BRIDGE)
				{
					//assign LAN member to fwdVLAN_BIND_INTERNET's member
					//20141121LUKE: should not include port member which not in any LAN!!
					for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
					{
						_rtk_rg_portmask_translator(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->port_mask, &out_mac_pmask, &out_ext_pmask);
						mbpmsk.bits[0]|=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].MemberPortmask.bits[0]&out_mac_pmask.bits[0]);
						etpmsk.bits[0]|=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].Ext_portmask.bits[0]&out_ext_pmask.bits[0]);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						//assign fwdVLAN_BIND_INTERNET's WLAN0 Device to VLAN's Mask
						rg_db.vlan[vlanID].wlan0DevMask|=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask&rg_db.vlan[rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id].wlan0DevMask);
						rg_db.vlan[vlanID].wlan0UntagMask|=(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET].wlan0DevMask&rg_db.vlan[rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id].wlan0UntagMask);
#endif
					}

					//20140516LUKE:All LAN port should be untag, CPU port will follow WAN port's setting!
					utpmsk.bits[0]|=(rg_db.systemGlobal.lanPortMask.portmask & RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU);
				}
			}
		}
	}
#endif  //end #if 0 else

	mbpmsk.bits[0]|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;	//CPUport always on, or TRAP will failed
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	etpmsk.bits[0]|=0x1;							//CPUport always on, or TRAP will failed
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif

#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
	//20150428LUKE: for macBased, we should broadcast to bridge WWAN by interface, not by vlan-decision
	if(!rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		if(wirelessWan!=RG_WWAN_WIRED)
		{
			etpmsk.bits[0]|=(0x1<<(RTK_RG_MAC_EXT_PORT0-RTK_RG_MAC_EXT_BASED_PORT));				//enable ext_1 for wireless WAN
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			if(wirelessWan==RG_WWAN_WLAN0_VXD)
			{
				assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,RG_WWAN_WLAN0_VXD,vlanID));
				rg_db.vlan[vlanID].wlan0DevMask|=(0x1<<RG_WWAN_WLAN0_VXD);
				if(wanintf->egress_vlan_tag_on)rg_db.vlan[vlanID].wlan0UntagMask&=(~(0x1<<RG_WWAN_WLAN0_VXD));
				else rg_db.vlan[vlanID].wlan0UntagMask|=(0x1<<RG_WWAN_WLAN0_VXD);
			}
			else if(wirelessWan==RG_WWAN_WLAN1_VXD)
			{
				assert_ok(rtk_rg_apollo_wlanDevBasedCVlanId_set(0,RG_WWAN_WLAN1_VXD,vlanID));
				rg_db.vlan[vlanID].wlan0DevMask|=(0x1<<RG_WWAN_WLAN1_VXD);
				if(wanintf->egress_vlan_tag_on)rg_db.vlan[vlanID].wlan0UntagMask&=(~(0x1<<RG_WWAN_WLAN1_VXD));
				else rg_db.vlan[vlanID].wlan0UntagMask|=(0x1<<RG_WWAN_WLAN1_VXD);
			}
#endif
			if(wanintf->wan_type==RTK_RG_BRIDGE)
				mbpmsk.bits[0]&=(~(wanPmsk.bits[0]));	//dismiss wan port if we are birdge
		}
	}
#endif

	if(wanintf->egress_vlan_tag_on)			//egress tagged packet
	{
		utpmsk.bits[0]&=(~(wanPmsk.bits[0]));	//set WAN port to 0 in untag set (tagging)
		if(wanintf->wan_type!=RTK_RG_BRIDGE)
			utpmsk.bits[0]&=(~RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK);	//set CPU port to 0 in untag set (tagging) for SMUX to detag
		else
		{
			//20140508LUKE:add UNBIND tagged bridge WAN should set VLAN's CPU port to TAGGED!!
			//for BINDING bridge WAN, vlan_exist should be zero!
			if(vlan_exist==0)
			{
				utpmsk.bits[0]&=(~RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK);	//set CPU port to 0 in untag set (tagging) for SMUX to detag
			}
			else if(utpmsk.bits[0]&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)
			{
				errorno=RT_ERR_RG_CPU_TAG_DIFF_BRIDGE_WAN;
				goto RET_VLAN_ERR;
			}
		}
	}
	else
	{
		utpmsk.bits[0]|=wanPmsk.bits[0];		//set WAN port to 1 in untag set (untagging)
		if(wanintf->wan_type!=RTK_RG_BRIDGE)
			utpmsk.bits[0]|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;	//set CPU port to 1 in untag set (untagging)
		else
		{
			//20140508LUKE:add UNBIND untag bridge WAN should set VLAN's CPU port to UNTAG!!
			//for BINDING bridge WAN, vlan_exist should be zero!
			if(vlan_exist==0)
			{
				utpmsk.bits[0]|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;	//set CPU port to 1 in untag set (untagging)
			}
			else if((utpmsk.bits[0]&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)!=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)
			{
				errorno=RT_ERR_RG_CPU_TAG_DIFF_BRIDGE_WAN;
				goto RET_VLAN_ERR;
			}
		}
	}

	//Patch:20131009, for multicast routing packet will use ingress's VLAN untag set, therefore set all none-member port as untag!!
	//20200514LUKE: change RTK_RG_ALL_MAC_PORTMASK to RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU to prevent RT_ERR_RG_CPU_TAG_DIFF_BRIDGE_WAN.
	utpmsk.bits[0]|=(~(mbpmsk.bits[0]))&RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU;

#if defined(CONFIG_OPENWRT_RG) && defined(CONFIG_SWCONFIG)
	//ysleu: Always tagged to CPU on SWCONFIG mode
	utpmsk.bits[0]&=(~RTK_RG_ALL_CPU_PORTMASK);
#endif

	ret = RTK_VLAN_PORT_SET(vlanID, &mbpmsk, &utpmsk);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	ret = RTK_VLAN_EXTPORT_SET(vlanID, &etpmsk);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

#if defined(CONFIG_MASTER_WLAN0_ENABLE)
	//20160524LUKE: for multicast routing packet will use ingress's VLAN untag set, therefore set all none-member port as untag!!
	rg_db.vlan[vlanID].wlan0UntagMask|=(~(rg_db.vlan[vlanID].wlan0DevMask))&(0xffffffff>>(32-MAX_WLAN_DEVICE_NUM));
#endif

	if(wanintf->vlan_based_pri_enable==RTK_RG_ENABLED)
	{
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(wanintf->vlan_based_pri==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
		{
			errorno=RT_ERR_RG_VLAN_PRI_CONFLICT_WIFI;
			goto RET_VLAN_ERR;
		}
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
		//WARNING("[FIXME]for 9602C, we can't set priority for VLAN directly...");
		//errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
		//goto RET_VLAN_ERR;
		{
			rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_t assignVlanBasedPriorityForInterfacePara;
			bzero(&assignVlanBasedPriorityForInterfacePara,sizeof(rtk_rg_aclAndCf_reserved_AssignVlanBasedPriorityForInterface_t));
			assignVlanBasedPriorityForInterfacePara.ingress_vlan = wanintf->egress_vlan_id;
			assignVlanBasedPriorityForInterfacePara.assigned_priority = wanintf->vlan_based_pri;
			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF0+intfIdx, &assignVlanBasedPriorityForInterfacePara);
		}
#else
		ret = RTK_VLAN_PRIORITY_SET(vlanID, wanintf->vlan_based_pri);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

		ret = RTK_VLAN_PRIORITYENABLE_SET(vlanID, ENABLED);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
#endif



	}
	else
	{

#if defined(CONFIG_RG_RTL9602C_SERIES)
#else
		ret = RTK_VLAN_PRIORITYENABLE_SET(vlanID, DISABLED);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

#endif
	}


	//20140723LUKE: bypass other tables
	//20150622LUKE: since we didn't turn on macBased decision, we won't have binding, then the wanType is no need,
	//nexthop will be setup in _rtk_rg_internal_GWMACSetup_stage2 or _rtk_rg_internal_IPV6GWMACSetup_stage2
	//20150624LUKE: for PPTP and L2TP, we need nexthop index at internal_wanSet, so we have to choose one here!
	if(reAddSameWan || (!rg_db.systemGlobal.initParam.macBasedTagDecision && wanintf->wan_type!=RTK_RG_PPTP && wanintf->wan_type!=RTK_RG_L2TP))goto ADD_BINDING;

	//Set up WAN type and NXP hop table here

	//Check for empty entry
	errorno=RT_ERR_RG_ENTRY_FULL;
	for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++)
	{
		if(rg_db.systemGlobal.nxpRefCount[i] == 0)
			break;
	}
	if(i==MAX_NEXTHOP_SW_TABLE_SIZE)goto RET_VLAN_ERR;

	nxpIdx = i;		//Keep

	//Setup Nexthop table in nxtidx
	errorno=RT_ERR_RG_NXP_SET_FAIL;
	nxpEt.ifIdx=intfIdx;
	// if WAN is PPPoE, LAN is untag. (keepPppoe=1 will send untag packet to WAN)
	if((wanintf->wan_type == RTK_RG_PPPoE)||(wanintf->wan_type == RTK_RG_PPPoE_DSLITE)){
		nxpEt.type=L34_NH_PPPOE;
		#if defined(CONFIG_RG_RTL9602C_SERIES)
		nxpEt.keepPppoe=2; /* If original tagged, keep. Otherwise add tag with PPPIDX session id */
		#else
		nxpEt.keepPppoe=0;
		#endif
		nxpEt.pppoeIdx=pppoeIdx;
	}else{
		nxpEt.type=L34_NH_ETHER;
		nxpEt.keepPppoe=1;
		nxpEt.pppoeIdx=0;
	}

	// FIXME: here should to use binding remote host mac index, if port-binding is set
	nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;		//use this DUMMY index to force packet TRAP to CPU

	rg_db.nexthop[nxpIdx].valid=1;
	ret = RTK_L34_NEXTHOPTABLE_SET(nxpIdx, &nxpEt);
	if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
	rg_db.systemGlobal.nxpRefCount[nxpIdx]++;	//add for deleting it when del interface

	//20150618LUKE: v6 nexthop should be assigned only when needed
	/*if(wanintf->wan_type != RTK_RG_BRIDGE)
	{
		//Check for empty entry
		errorno=RT_ERR_RG_ENTRY_FULL;
		for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++)
		{
			if(rg_db.systemGlobal.nxpRefCount[i] == 0)
				break;
		}
		if(i==MAX_NEXTHOP_SW_TABLE_SIZE)goto RET_VLAN_ERR;

		v6nxpIdx = i;		//Keep

		//20140623LUKE:IPv4 and IPv6 may have different remote MAC address, so we keep two nexthop respectively
TRACE("ifIdx=%d keepPPPoE=%d pppoeIdx=%d type=%d index=%d",nxpEt.ifIdx,nxpEt.keepPppoe,nxpEt.nhIdx,nxpEt.pppoeIdx,nxpEt.type,v6nxpIdx);

#if defined(CONFIG_RG_RTL9602C_SERIES)
		FIXME("9602BVB nexthop entry number=netif entry number");
		ret = RTK_L34_NEXTHOPTABLE_SET(v6nxpIdx, &nxpEt);	//used for IPv6
		if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
		rg_db.systemGlobal.nxpRefCount[v6nxpIdx]++;	//add for deleting it when del interface
#else
		ret = RTK_L34_NEXTHOPTABLE_SET(v6nxpIdx, &nxpEt);	//used for IPv6
		if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
		rg_db.systemGlobal.nxpRefCount[v6nxpIdx]++;	//add for deleting it when del interface
#endif

	}*/

	//Add WAN type table
	errorno=RT_ERR_RG_WANTYPE_SET_FAIL;
	bzero(&wantEt, sizeof(rtk_wanType_entry_t));
	wantEt.nhIdx=nxpIdx;
	if(wanintf->wan_type==RTK_RG_BRIDGE)
		wantEt.wanType=L34_WAN_TYPE_L2_BRIDGE;
	else
		wantEt.wanType=L34_WAN_TYPE_L3_ROUTE;		//this value should be modified if NAPT

	for(i=0;i<MAX_WANTYPE_SW_TABLE_SIZE;i++)
	{
		if(rg_db.wantype[i].valid==0)
		{
			wantypeIdx=i;
			break;
		}
	}
	if(wantypeIdx<0)goto RET_WANTYPE_ERR;
	rg_db.wantype[wantypeIdx].valid=1;
	ret = RTK_L34_WANTYPETABLE_SET(wantypeIdx, &wantEt);
	if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
	{
		errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
		goto RET_WANTYPE_ERR;
	}
	if(ret!=RT_ERR_OK)goto RET_WANTYPE_ERR;
	rg_db.systemGlobal.nxpRefCount[nxpIdx]++;		//nexthop reference by WAN type table

ADD_BINDING:
	if(reAddSameWan)
	{
		//if we add binding before, we do not readd them here!
		DEBUG("before: binding pmsk is %x, extpmsk is %x",tmppmsk,tmpexpmsk);
		tmppmsk&=(~old_pmsk);
		tmpexpmsk&=(~old_extpmsk);
		DEBUG("binding pmsk is %x, extpmsk is %x",tmppmsk,tmpexpmsk);
		wantypeIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.bind_wan_type_ipv4;
		v6wantypeIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.bind_wan_type_ipv6;
		nxpIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv4;
		v6nxpIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv6;
		pppoeIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_idx;
		extipIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.extip_idx;
		baseIntfIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.baseIntf_idx;
		wirelessWan=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wirelessWan;
	}

	//Set up port-binding for WAN interface
	//DEBUG("start");
	//20140423LUKE:CPU port can't be add to binding rule!!
	tmppmsk&=(~RTK_RG_ALL_CPU_PORTMASK);
	if(tmppmsk>0 || tmpexpmsk>0)
	{
		DEBUG("wantypeIdx is %d, v6wantypeIdx is %d",wantypeIdx,v6wantypeIdx);
		errorno=_rtk_rg_addBindFromPortmask(tmppmsk,tmpexpmsk,intfIdx,wantypeIdx,v6wantypeIdx);
		if(errorno!=RT_ERR_RG_OK)goto RET_WANTYPE_ERR;
	}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	//Add WLAN0 device-binding rules
	for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
	{
		if(rg_db.systemGlobal.wlan0BindDecision[i].exist && (wanintf->wlan0_dev_binding_mask&(0x1<<i)))
		{
			rg_db.systemGlobal.wlan0BindDecision[i].set_bind=1;
			rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf=intfIdx;
			rg_db.systemGlobal.wlan0BindingUsed|=(0x1<<i);
		}
	}
#endif

	//20140502LUKE:Only turn on this when macBasedTagDecision is set to 1
	if(rg_db.systemGlobal.initParam.macBasedTagDecision==1)
	{
		//Update non binding portmask, if portmask is zero, remove WAN port from fwdVLAN_BIND_INTERNET
		//otherwise add WAN port to fwdVLAN_BIND_INTERNET!
		_rtk_rg_updateNoneBindingPortmask(wanPmsk.bits[0]);
	}

#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	//20140723LUKE: bypass create gateway mac
	if(reAddSameWan||changeBindingPmsk){
		//20141224LUKE: since port-binding may be modified, we should rearrange ACL which use the WAN interface as egress interface of the binding
		if(rg_db.systemGlobal.acl_SW_egress_intf_type_zero_num && (orig_pbdmsk.portmask!=wanintf->port_binding_mask.portmask||changeBindingPmsk)){
			rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask=wanintf->port_binding_mask.portmask;
			ASSERT_EQ(_rtk_rg_acl_user_part_rearrange(),RT_ERR_RG_OK);
		}

		//20140723LUKE: bypass create gateway mac
		if(reAddSameWan)
			goto RESET_RGDB;
	}
#else
	//20140723LUKE: bypass create gateway mac
	if(reAddSameWan)
		goto RESET_RGDB;
#endif

	if(addToStaticMAC)
	{
		rtk_rg_successFailReturn_t ret_fs;
		//1 FIXME: patch for DA==GatewayMac will hit layer2 unknown DA, if action is trap
		//Create Wan gateway STATIC MAC
		errorno=RT_ERR_RG_CREATE_GATEWAY_LUT_FAIL;
		if(wanintf->egress_vlan_tag_on)	//cpu tagged
			utpmsk.bits[0]=0;
		else
			utpmsk.bits[0]=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;
		ret_fs = _rtk_rg_createGatewayMacEntry(wanintf->gmac.octet,wanintf->egress_vlan_id,utpmsk.bits[0],intfIdx,FALSE);
		if(ret_fs==RG_RET_FAIL)goto RET_WANTYPE_ERR;
		if(rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_mechanism && wanintf->wan_type==RTK_RG_VXLAN)
		{
			rtk_rg_macEntry_t macEntry;
			int virtual_dmacL2Idx;
			_rtk_rg_lutToMacEntry_translator(rg_db.lut[rg_db.netif[intfIdx].l2_idx], &macEntry);
			macEntry.mac.octet[0] = 0x0;
			macEntry.mac.octet[1] = 0x0;
			macEntry.mac.octet[2] = 0x5e;
			macEntry.static_entry = 1;
			macEntry.arp_used = 1;
			if(rg_kernel.apolloChipId==RTL9607C_CHIP_ID){
				macEntry.mac.octet[3] = 0x00;
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamGmac==1)
					macEntry.port_idx = RTK_RG_MAC10_EXT_PORT4;
				else if(rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamGmac==2)
					macEntry.port_idx = RTK_RG_MAC7_EXT_PORT4;
				else
					macEntry.port_idx = RTK_RG_EXT_PORT4;
				if((pf.rtk_rg_macEntry_add)(&macEntry, &virtual_dmacL2Idx)==RT_ERR_RG_OK)
					rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx=virtual_dmacL2Idx;
				else
					rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx=-1;

				macEntry.mac.octet[3] = 0x01;
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_extraGmac==1)
					macEntry.port_idx = RTK_RG_MAC10_EXT_PORT4;
				else if(rg_db_dynamic_sram.vxlan_acc.vxlan_extraGmac==2)
					macEntry.port_idx = RTK_RG_MAC7_EXT_PORT4;
				else
					macEntry.port_idx = RTK_RG_EXT_PORT4;
				if((pf.rtk_rg_macEntry_add)(&macEntry, &virtual_dmacL2Idx)==RT_ERR_RG_OK)
					rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx=virtual_dmacL2Idx;
				else
					rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx=-1;
			}else{
				macEntry.port_idx = RTK_RG_EXT_PORT4;
			
				if((pf.rtk_rg_macEntry_add)(&macEntry, &virtual_dmacL2Idx)==RT_ERR_RG_OK)
					rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx=virtual_dmacL2Idx;
				else
					rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx=-1;
				rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx=-1;
			}
			
			//20200624LUKE:initialize the upstreamL2Idx, it will be updated in _rtk_rg_vxlan_acceleration_mechanism_check.
			rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_upstreamL2Idx=-1;
			rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_upstreamL2Idx=-1;
		}
	}

	//Set Global variables
	rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum].index=intfIdx;
	rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum].disableBroadcast=disableBroadcast;
	rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum].p_intfInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx];
	rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum].p_wanIntfConf=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf;
	rg_db.systemGlobal.interfaceInfo[intfIdx].lan_or_wan_index=rg_db.systemGlobal.wanIntfTotalNum;
	rg_db.systemGlobal.wanIntfTotalNum++;		//add WAN interface number

#if defined(CONFIG_RG_G3_SERIES)
	for(i=0; i<MAX_WAN_INTERFACE_SIZE; i++)
	{
		if(rg_db.systemGlobal.wanIntfGroup_for_genericIntf[i]==0)
		{
			rg_db.systemGlobal.wanIntfGroup_for_genericIntf[i] = 1;
			rg_db.systemGlobal.interfaceInfo[intfIdx].lanWan_groupIdx_for_genericIntf = i;
			break;
		}
	}
	if(i==MAX_WAN_INTERFACE_SIZE)
	{
		WARNING("wanIntfGroup_for_genericIntf table is full.");
		RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
	}
#endif	

RESET_RGDB:

	*wan_intf_idx = intfIdx;
	//rtlglue_printf("wan_intf_idx get = %d",*wan_intf_idx);

	//store information in Global variable
	rg_db.systemGlobal.interfaceInfo[intfIdx].valid=IF_VALID_ENTRY;
	bzero(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.intf_name,32);
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan=1;
	//20140806LUKE: for binding WAN, wanType is set to v4 and bind rule protocol is v4v6_all first!!
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.bind_wan_type_ipv4=wantypeIdx;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.bind_wan_type_ipv6=v6wantypeIdx;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wirelessWan=wirelessWan;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv4=nxpIdx;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv6=v6nxpIdx;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_idx=pppoeIdx;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.extip_idx=extipIdx;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.baseIntf_idx=baseIntfIdx;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.flowEntryIdx = -1;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.extraTagActionListIdx =0;
#endif
#if defined(CONFIG_RG_WAN_MSS_CACHE)
	//20170727LUKE: reset mss cache information of this wan interface.
	_rtk_rg_mssCache_reset(intfIdx);
#endif
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type=wanintf->wan_type;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.isIVL=wanintf->isIVL;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.none_internet=wanintf->none_internet;
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wlan0_dev_binding_mask=wanintf->wlan0_dev_binding_mask;
#endif
	if(wanintf->wan_type == RTK_RG_STATIC)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.static_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_DHCP)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.dhcp_client_info.hw_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_PPPoE)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_info.after_dial.hw_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_PPTP)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pptp_info.after_dial.hw_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_L2TP)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.l2tp_info.after_dial.hw_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_DSLITE)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.dslite_info.static_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_PPPoE_DSLITE)
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.static_info;		//short-cut of wan static info structure
	else if(wanintf->wan_type == RTK_RG_VXLAN)
	{
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.after_dial.hw_info;		//short-cut of wan static info structure
		if(reAddSameWan==0) 
			rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx = FAIL;
	}
	else	//bridge WAN
		rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo=NULL;

	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx=wanintf->wan_port_idx;
	//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (wanintf->wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (wanintf->wan_port_idx)==RTK_RG_PORT_RGMII){
		DEBUG("Special recovery WAN_PORT from RGMII to PON.");
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx=RTK_RG_PORT_PON;
	}
#endif
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask=wanintf->port_binding_mask.portmask;
	//rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.extport_binding_mask=wanintf->extport_binding_mask;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on=wanintf->egress_vlan_tag_on;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id=wanintf->egress_vlan_id;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri_enable=wanintf->vlan_based_pri_enable;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri=wanintf->vlan_based_pri;
	//_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.default_gateway_on=wanintf->default_gateway_on;
	memcpy(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet, wanintf->gmac.octet,ETHER_ADDR_LEN);
	//if(rg_db.systemGlobal.initParam.wanPortGponMode && wanintf->wan_port_idx==RTK_RG_MAC_PORT_PON)
		//rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.gponStreamID=wanintf->gponStreamID;
	//20170331LUKE: this variable decides BC or MC L2 packets which hit binding to routing WAN should be forwarded or not.
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.bridgeToBindingWanByProtocol=wanintf->bridgeToBindingWanByProtocol;
	//20180503LUKE: before IP information set, we should receive both version of IP packets.
	//20180717LUKE: force IP version to IPVER_V4V6 only for newborn interface.
	//20180919LUKE: check if we add first time but forcedAddNewIntf is zero.
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo && (wanintf->forcedAddNewIntf||reAddSameWan==0))rg_db.systemGlobal.interfaceInfo[intfIdx].p_wanStaticInfo->ip_version=IPVER_V4V6;
	//20200121LUKE: forbid IGMP/MLD when egress from this WAN if configured
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.forbiddenUnbindIGMP=wanintf->forbiddenUnbindIGMP;
	rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.forbiddenUnbindMLD=wanintf->forbiddenUnbindMLD;

	//20140723LUKE: bypass unnecessary parts
	if(reAddSameWan)
	{
		errorno=RT_ERR_RG_OK;
		goto RET_SUCCESS;
	}

	//Update PVID
	_rtk_rg_updateWANPortBasedVID(wanintf->wan_port_idx);


	//Check PPPoE Pass through
	_rtk_rg_refreshPPPoEPassThroughLanOrWanPortMask();


#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//apolloPro will always trap if unhit flow
#else
	//20141208LUKE: setup ACL for traping DHCP packets
	if(wanintf->wan_type==RTK_RG_DHCP && intfIdx<MAX_NETIF_HW_TABLE_SIZE)
	{
		rtk_rg_aclAndCf_reserved_intf_dhcp_trap_t intf_dhcp_trap_para;

		bzero(&intf_dhcp_trap_para,sizeof(intf_dhcp_trap_para));
		memcpy(intf_dhcp_trap_para.gmac.octet,wanintf->gmac.octet,ETHER_ADDR_LEN);
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_INTF0_DHCP_TRAP+intfIdx,&intf_dhcp_trap_para);
	}
#endif


#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(rg_db.systemGlobal.fragment_ipv4_intf_trap){
		rtk_rg_aclAndCf_reserved_intf_ipv4_fragment_trap_t intf_ipv4_trap;
		bzero(&intf_ipv4_trap,sizeof(intf_ipv4_trap));
		memcpy(intf_ipv4_trap.gmac.octet,wanintf->gmac.octet,ETHER_ADDR_LEN);
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_INTF0_IPV4_FRAGMENT_TRAP+intfIdx,&intf_ipv4_trap);
	}
#endif


	//20150312LUKE: for OMCI wanInfo, we should call callback for every WAN.
	//if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE){
		//add wan-interfcae callback to sync protocal-stack
		if(rg_db.systemGlobal.initParam.interfaceAddByHwCallBack != NULL)
		{
			//rtk_rg_intfInfo_t intfInfo;
			//bzero(&intfInfo,sizeof(intfInfo));
			//memcpy(&intfInfo, &rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo, sizeof(intfInfo));
			rg_db.systemGlobal.initParam.interfaceAddByHwCallBack(&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo,&intfIdx);
		}
	//}

#if defined(CONFIG_RG_RTL9600_SERIES)
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0)){
		// Multicast packets must change cvid to PVID if they're from PON port and un-Ctag. (MC CVID is not from internalVID when VSPMSK enabled)
#if 0
		{
			rtk_rg_aclAndCf_reserved_multicastVidTranslateForIpv4_t multicastVidTranslateForIpv4;
			rtk_rg_aclAndCf_reserved_multicastVidTranslateForIpv6_t multicastVidTranslateForIpv6;
			//int pvid;
			//rtk_vlan_portPvid_get(RTK_RG_MAC_PORT_PON,&pvid);
			multicastVidTranslateForIpv4.vid=rg_db.systemGlobal.portBasedVID[RTK_RG_MAC_PORT_PON];
			multicastVidTranslateForIpv6.vid=rg_db.systemGlobal.portBasedVID[RTK_RG_MAC_PORT_PON];
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV4, &multicastVidTranslateForIpv4));
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6, &multicastVidTranslateForIpv6));
		}
#endif
	}
#endif

	//20150315CHUCK: detect if RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY is needed.
	if(_rtk_rg_add_pppoe_lcp_reserved_acl_detect()){
		rtk_rg_aclAndCf_reserved_ack_packet_assign_priority_t ack_packet_assign_priority;
		bzero(&ack_packet_assign_priority,sizeof(ack_packet_assign_priority));

		ack_packet_assign_priority.priority=7;
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(ack_packet_assign_priority.priority==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
			ack_packet_assign_priority.priority = (CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI-1);
#endif
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY, &ack_packet_assign_priority);
		DEBUG("Add reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");

	}else{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY);
		DEBUG("Del reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");
	}

	if(_rtk_rg_add_l2tp_lcp_reserved_acl_detect()){
		rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_t lcp_packet_assign_priority;
		bzero(&lcp_packet_assign_priority,sizeof(rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_t));
		lcp_packet_assign_priority.priority=7;

#ifdef CONFIG_DUALBAND_CONCURRENT
		if(lcp_packet_assign_priority.priority==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
			lcp_packet_assign_priority.priority = (CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI-1);
#endif
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_L2TP_CONTROL_LCP_PACKET_TRAP_AND_ASSIGN_PRIORITY, &lcp_packet_assign_priority);
		DEBUG("Add reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");
	}else{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_L2TP_CONTROL_LCP_PACKET_TRAP_AND_ASSIGN_PRIORITY);
		DEBUG("Del reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");

	}




	if(wanintf->wan_type==RTK_RG_BRIDGE &&
		  (((MAX_NETIF_HW_TABLE_SIZE <= *wan_intf_idx) && (*wan_intf_idx < MAX_NETIF_SW_TABLE_SIZE)) 	||
		  ((MAX_WANTYPE_HW_TABLE_SIZE <= wantypeIdx) && (wantypeIdx < MAX_WANTYPE_SW_TABLE_SIZE) && (rg_db.wantype[wantypeIdx].valid==SOFTWARE_ONLY_ENTRY)) 		||
		  ((MAX_WANTYPE_HW_TABLE_SIZE <= v6wantypeIdx) && (v6wantypeIdx < MAX_WANTYPE_SW_TABLE_SIZE) && (rg_db.wantype[v6wantypeIdx].valid==SOFTWARE_ONLY_ENTRY)))
	)
	{
		rg_db.systemGlobal.interfaceInfo[intfIdx].valid |= (IF_SOFTWARE4_ENTRY|IF_SOFTWARE6_ENTRY);
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//apolloPro will always trap if unhit flow
#else
	//20160427CHUCK: move the per L34 ipv6 interfcae link-local trap to add wan stage, otherwise the DHCPv6 and PPPoEv6 may not be diag up.
	if((*wan_intf_idx) < MAX_NETIF_HW_TABLE_SIZE)
	{
		if(wanintf->wan_type==RTK_RG_BRIDGE || wanintf->wan_type==RTK_RG_PPTP || wanintf->wan_type==RTK_RG_L2TP || wanintf->wan_type==RTK_RG_VXLAN)
		{
			//Bridge or IPv4 interfcae do not need to trap ipv6 link-local
		}
		else
		{
			//20141226LUKE: add the trap link local ACL since we turn on IPv6 this interface!!
			memcpy(intf_link_local_trap_para.gmac.octet,wanintf->gmac.octet,ETHER_ADDR_LEN);
			rsvType=RTK_RG_ACLANDCF_RESERVED_IPV6_INTF0_LINK_LOCAL_TRAP+(*wan_intf_idx);
			_rtk_rg_aclAndCfReservedRuleAdd(rsvType, &intf_link_local_trap_para);
		}
	}
#endif

	ASSERT_EQ(_rtk_rg_pon_rgmii_as_cf_port_check(),RT_ERR_RG_OK);

	_rtk_rg_wanInterface_special_case_check();

#if defined(CONFIG_RG_G3_SERIES)
	// Add generic interface of bridge wan
	if(wanintf->wan_type==RTK_RG_BRIDGE)
	{
		ASSERT_EQ(_rtk_rg_generic_wan_intf_add(intfIdx), RT_ERR_RG_OK);
	}
	// reflash lut table
	_rtk_rg_reflash_lut_table();
#endif

	errorno=RT_ERR_RG_OK;

	goto RET_SUCCESS;

#if 0
RET_DEF_ROUTE_ERR:
	//Recovery default setting
	RTK_L34_ROUTINGTABLE_SET(RTK_L34_ROUTINGTABLE_SET, &ori_rtEt);
#endif
RET_WANTYPE_ERR:
	if(wantypeIdx>=0)
	{
		//Delete WAN type entry
		bzero(&wantEt, sizeof(rtk_wanType_entry_t));
		rg_db.wantype[wantypeIdx].valid=0;
		RTK_L34_WANTYPETABLE_SET(wantypeIdx, &wantEt);
	}
RET_NEXTHOP_ERR:
	//Delete nexthop entry
	bzero(&nxpEt, sizeof(rtk_l34_nexthop_entry_t));
	rg_db.nexthop[nxpIdx].valid=0;
	RTK_L34_NEXTHOPTABLE_SET(nxpIdx, &nxpEt);
RET_VLAN_ERR:
	//Recovery VLAN setting
	if(vlan_exist)
	{
		RTK_VLAN_PORT_SET(vlanID, &ori_vlanEntry.MemberPortmask, &ori_vlanEntry.UntagPortmask);
		RTK_VLAN_EXTPORT_SET(vlanID, &ori_vlanEntry.Ext_portmask);
		RTK_VLAN_FIDMODE_SET(vlanID, ori_vlanEntry.fidMode);
		RTK_VLAN_FID_SET(vlanID, ori_vlanEntry.fid);
#if defined(CONFIG_RG_RTL9602C_SERIES)
#else
		RTK_VLAN_PRIORITYENABLE_SET(vlanID, ori_vlanEntry.priorityEn);
		RTK_VLAN_PRIORITY_SET(vlanID, ori_vlanEntry.priority);
#endif
	}
	else
	{
		RTK_VLAN_DESTROY(vlanID);
	}
//RET_BRIDGE_ERR:
	//Recovery all Lan interface's VLAN member port mask
	if(wanintf->wan_type == RTK_RG_BRIDGE)
	{
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			tmpVid=rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id;
			//rtk_vlan_port_get(rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.intf_vlan_id, &mbpmsk, &utpmsk);
			memcpy(&mbpmsk, &rg_db.vlan[tmpVid].MemberPortmask,sizeof(rtk_portmask_t));
			memcpy(&utpmsk, &rg_db.vlan[tmpVid].UntagPortmask,sizeof(rtk_portmask_t));
			mbpmsk.bits[0] &= (~(wanPmsk.bits[0]));		//negative the WAN PORT in LAN's VLAN member port mask
			RTK_VLAN_PORT_SET(tmpVid, &mbpmsk, &utpmsk);
		}
	}
#if 0
RET_DEFALT_VLAN_ERR:
	//Recovery DEFAULT LAN VLAN
	RTK_VLAN_PORT_SET(DEFAULT_LAN_VLAN, &ori_CPU_member_mask, &ori_CPU_untag_mask);
#endif

/*RET_PPPOE_PASS_ERR:
	ret=0;
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wan_intf_conf.wan_port_idx == wanintf->wan_port_idx)
			ret++;
	}
	if(ret==0)		//only this WAN used the wan port
	{
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->pppoe_passThrough == 1)
			{
				//remove WAN port to their PPB VLAN
				tmpVid=DEFAULT_PPB_VLAN_START+rg_db.systemGlobal.lanIntfGroup[i].index;
				memcpy(&ori_pmsk, &rg_db.vlan[tmpVid].MemberPortmask,sizeof(rtk_portmask_t));
				memcpy(&ori_utmsk, &rg_db.vlan[tmpVid].UntagPortmask,sizeof(rtk_portmask_t));
				memcpy(&ori_etpmsk, &rg_db.vlan[tmpVid].Ext_portmask,sizeof(rtk_portmask_t));

				if(wanintf->wan_port_idx <= RTK_RG_PORT_CPU)
				{
					ori_pmsk.bits[0]&=~(0x1<<wanintf->wan_port_idx);
					ori_utmsk.bits[0]&=~(0x1<<wanintf->wan_port_idx);
				}
				else
				{
					ori_etpmsk.bits[0]&=~(0x1<<(wanintf->wan_port_idx-RTK_RG_EXT_PORT0));
					ori_utmsk.bits[0]&=~(0x1<<RTK_RG_PORT_CPU);
				}

				RTK_VLAN_PORT_SET(tmpVid, &ori_pmsk, &ori_utmsk);
				RTK_VLAN_EXTPORT_SET(tmpVid, &ori_etpmsk);
			}
		}
	}
*/
RET_INTF_ERR:
	//Delete interface entry
	bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
	RTK_L34_NETIFTABLE_SET(intfIdx, &intfEntry);

RET_OVERLAP_BIND_ERR:
	//re-Sync binding table by software database
	for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
	{
		RTK_L34_BINDINGTABLE_SET(i,&rg_db.bind[i].rtk_bind);
	}

RET_SUCCESS:
	//------------------ Critical Section End -----------------------//
	//rg_unlock(&rg_kernel.interfaceLock);

#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(errorno==RT_ERR_RG_OK)
	{
		if(rg_kernel.block_communication_between_internet_and_other)
			ASSERT_EQ(_rtk_rg_update_lanIntf_ivlMacEntries(), RT_ERR_RG_OK);
	}
#endif

    RETURN_ERR(errorno);
}

int _rtk_rg_decreaseNexthopReference(int nexthopIdx)
{
	int ret;
	rtk_l34_pppoe_entry_t pppEt;
	rtk_l34_nexthop_entry_t nxpEt;
	rtk_l2_ucastAddr_t l2UcEntry;

	if(rg_db.systemGlobal.nxpRefCount[nexthopIdx] <= 0)
	{
		rg_db.systemGlobal.nxpRefCount[nexthopIdx]=0;
		return (RT_ERR_RG_OK);
	}

	rg_db.systemGlobal.nxpRefCount[nexthopIdx]--;

	//20140724LUKE: because the last one ref count is interface, so we should delete LUT here.
	//when add IPv4's nexthop, interface and wanType table are counted, so two means the LUT is no needed
	//for IPv6's nexthop, one means the LUT is no needed
	if((rg_db.systemGlobal.nxpRefCount[nexthopIdx] == 2 && nexthopIdx == rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[nexthopIdx].rtk_nexthop.ifIdx].storedInfo.wan_intf.nexthop_ipv4) ||
		(rg_db.systemGlobal.nxpRefCount[nexthopIdx] == 2 && nexthopIdx == rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[nexthopIdx].rtk_nexthop.ifIdx].storedInfo.wan_intf.nexthop_ipv6) ||
		rg_db.systemGlobal.nxpRefCount[nexthopIdx] == 1)
	{
		//if there is another nexthop use the same LUT, we can't delete it!!
		for(ret=0;ret<MAX_NEXTHOP_SW_TABLE_SIZE;ret++)
		{
			//20150916LUKE: if the decrease nexthop is used as base WAN of PPTP/L2TP, delete LUT would be OK.
			if(ret!=nexthopIdx && rg_db.nexthop[ret].rtk_nexthop.nhIdx==rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx && rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[ret].rtk_nexthop.ifIdx].valid &&
				(rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[ret].rtk_nexthop.ifIdx].storedInfo.is_wan==0 ||	rg_db.systemGlobal.interfaceInfo[rg_db.nexthop[ret].rtk_nexthop.ifIdx].storedInfo.wan_intf.baseIntf_idx!=rg_db.nexthop[nexthopIdx].rtk_nexthop.ifIdx))
				break;
		}

		if(ret==MAX_NEXTHOP_SW_TABLE_SIZE && rg_db.lut[rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx].valid &&
			rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx!=rg_db.systemGlobal.defaultTrapLUTIdx)
		{
#if 1
{
			// 20171227: Only disable static flag of nexthop L2 entry to prevent packet loss of multicast packet which its smac is same as this L2 entry
			rtk_rg_lut_linkList_t *pLutList, *pNextLutList;
			uint32 lutGroupIdx = rg_db.lut[rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx].lutGroupIdx, l2Idx;

			if(lutGroupIdx<MAX_LUT_HW_TABLE_SIZE){
				list_for_each_entry_safe(pLutList, pNextLutList, &rg_db.lutGroupTableHead[lutGroupIdx], lut_list)	//just return the first entry right behind of head
				{
					//Sync to LUT
					l2Idx = pLutList->idx;
					if(rg_db.lut[l2Idx].valid && rg_db.lut[l2Idx].rtk_lut.entryType==RTK_LUT_L2UC)
					{
						memcpy(&l2UcEntry, &rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry, sizeof(rtk_l2_ucastAddr_t));
						if((l2UcEntry.flags & RTK_L2_UCAST_FLAG_STATIC)!=0)
						{
							l2UcEntry.flags &= (~RTK_L2_UCAST_FLAG_STATIC);
							// [Call RTK_L2_ADDR_ADD directly] disable static
							ASSERT_EQ(RTK_L2_ADDR_ADD(&l2UcEntry), RT_ERR_OK);
						}
					}
				}
			}else
				WARNING("lutGroupIdx is %d!",lutGroupIdx);
}
#else
{
			//Delete LUT referenced by Nexthop and no other nexthop used
			memcpy(&l2UcEntry,&rg_db.lut[rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx].rtk_lut.entry.l2UcEntry,sizeof(rtk_l2_ucastAddr_t));
#if defined(CONFIG_RG_RTL9600_SERIES)
			//20160329LUKE: fix untag LUT won't be deleted issue.
			if(l2UcEntry.vid==0)	//auto-learned as untag
				l2UcEntry.vid=rg_db.systemGlobal.initParam.fwdVLAN_CPU;
#endif
			_rtk_rg_deleteGatewayMacEntry(l2UcEntry.mac.octet, l2UcEntry.vid, rg_db.vlan[l2UcEntry.vid].UntagPortmask.bits[0]);
}
#endif
		}
		//Set to default trap LUT index
		memcpy(&nxpEt,&rg_db.nexthop[nexthopIdx].rtk_nexthop,sizeof(rtk_l34_nexthop_entry_t));
		nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;
		rg_db.nexthop[nexthopIdx].valid=1;
		ret = RTK_L34_NEXTHOPTABLE_SET(nexthopIdx, &nxpEt);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);
	}
	else if(rg_db.systemGlobal.nxpRefCount[nexthopIdx] == 0)
	{
		//Delete Nexthop entry, since nobody use it
		if(rg_db.nexthop[nexthopIdx].rtk_nexthop.type==L34_NH_PPPOE)
		{
			//20211230LUKE: if there is another nexthop use the same PPPoE, we can't delete it!!
			for(ret=0;ret<MAX_NEXTHOP_SW_TABLE_SIZE;ret++)
			{
				if(ret!=nexthopIdx && rg_db.nexthop[ret].valid && rg_db.nexthop[ret].rtk_nexthop.type==L34_NH_PPPOE &&
					rg_db.nexthop[ret].rtk_nexthop.pppoeIdx==rg_db.nexthop[nexthopIdx].rtk_nexthop.pppoeIdx)
					break;
			}
			if(ret==MAX_NEXTHOP_SW_TABLE_SIZE){
				//Delete PPPoE table
				bzero(&pppEt, sizeof(rtk_l34_pppoe_entry_t));
				ret = RTK_L34_PPPOETABLE_SET(rg_db.nexthop[nexthopIdx].rtk_nexthop.pppoeIdx, &pppEt);
				if(ret!=RT_ERR_OK)
					RETURN_ERR(RT_ERR_RG_PPPOE_SET_FAIL);
			}
		}

		bzero(&nxpEt, sizeof(rtk_l34_nexthop_entry_t));
		rg_db.nexthop[nexthopIdx].valid=0;
		ret = RTK_L34_NEXTHOPTABLE_SET(nexthopIdx, &nxpEt);

		if(ret!=RT_ERR_OK)
			RETURN_ERR(RT_ERR_RG_NXP_SET_FAIL);
	}

	return (RT_ERR_RG_OK);
}

int _rtk_rg_decreaseExtIPReference(int ipIdx)
{
	rtk_l34_ext_intip_entry_t extipEt={0};

	if(rg_db.systemGlobal.eipRefCount[ipIdx] <= 0){
		rg_db.systemGlobal.eipRefCount[ipIdx]=0;
		return (RT_ERR_RG_OK);
	}

	rg_db.systemGlobal.eipRefCount[ipIdx]--;

	if(rg_db.systemGlobal.eipRefCount[ipIdx] == 0){
		//delete the eip entry
		assert_ok(RTK_L34_EXTINTIPTABLE_SET(ipIdx, &extipEt));
	}

	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_interface_del(int lan_or_wan_intf_idx)
{

#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
#else
	int addRsvPPPoEBridgeMcTrap=0;
#endif

    int i,ret,tmpVid,errorno;
	unsigned int wan_set_mask;
    rtk_l34_netif_entry_t intfEt;
	rtk_portmask_t mbpmsk,utpmsk,etpmsk;
	rtk_portmask_t pvid_mac_pmask,pvid_ext_pmask;
	rtk_portmask_t wanPmsk;
	rtk_wanType_entry_t wantEt;
	rtk_l34_nexthop_entry_t nxpEt;
	rtk_l34_pppoe_entry_t pppoeEt;
    rtk_binding_entry_t pbindEt;
	rtk_rg_bindingEntry_t cb_bindEt;
	rtk_rg_intfInfo_t keep_store_info;		//for callback
	rtk_rg_virtualServer_t virtual_server;
	rtk_rg_upnpConnection_t upnp;
	rtk_rg_dmzInfo_t dmz_info;
	rtk_rg_port_idx_t deleting_wan_port=RTK_RG_MAC_PORT_MAX;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//ApolloPro no need reserved ACL to suport feature in this function
#else
	rtk_rg_aclAndCf_reserved_type_t rsvType;
#endif
	wanPmsk.bits[0] = 0;

    //Check parameter
    if(lan_or_wan_intf_idx<0 || lan_or_wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE){
		rtlglue_printf("intf lan_or_wan_intf_idx=%d\n",lan_or_wan_intf_idx);
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
    }

	//Check the interface had created or not
	if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid == IF_INVALID_ENTRY){
		rtlglue_printf("intf valid=%d\n",rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid);
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}

#if defined(CONFIG_RG_RTL9602C_SERIES) //patch for mismatching mib ipv6 netif problem
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1
			&& rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_BRIDGE)
		{
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ip_version==IPVER_V4V6
				&& rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->napt_enable==1
				&& lan_or_wan_intf_idx>=(MAX_NETIF_HW_TABLE_SIZE/2) )
			{
				rtlglue_printf("Can not delete ipv6 wan netif[%d].\n", lan_or_wan_intf_idx);
				RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
			}
		}
	}
#endif

	//20161221LUKE: if we encounter static route using deleting interface, we should return fail to warn user.
	for(i=0;i<MAX_STATIC_ROUTE_SIZE;i++){
		if(rg_db.staticRoute[i].valid!=INVALID_ENTRY && rg_db.staticRoute[i].nxtip_intfidx==lan_or_wan_intf_idx){
			WARNING("Exist StaticRoute[%d] on this interface...Please delete it in advance!",i);
			RETURN_ERR(RT_ERR_RG_SR_EXIST);
		}
	}

    //bzero(&intfEt, sizeof(rtk_l34_netif_entry_t));
    //ret = rtk_l34_netifTable_get(lan_or_wan_intf_idx, &intfEt);
    //if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_INTF_GET_FAIL);
    //if(intfEt.valid != 1)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//------------------ Critical Section start -----------------------//
	//rg_lock(&rg_kernel.interfaceLock);

	//20161031LUKE: move this from the end of API to avoid reflash ACL will recreate  inexistence VLAN ID.
	//20141226LUKE: delete the trap link local ACL since we are deleting this interface!!
	if(lan_or_wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
	{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					//apolloPro will always trap if unhit flow
#else
		rsvType=RTK_RG_ACLANDCF_RESERVED_IPV6_INTF0_LINK_LOCAL_TRAP+lan_or_wan_intf_idx;
		_rtk_rg_aclAndCfReservedRuleDel(rsvType);
#endif
	}

#if defined(CONFIG_RG_G3_SERIES)
	// Delete generic interface of lan/wan
	if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan)
	{
		ASSERT_EQ(_rtk_rg_generic_wan_intf_del(lan_or_wan_intf_idx), RT_ERR_RG_OK);
	}
	else
	{
		ASSERT_EQ(_rtk_rg_generic_lan_intf_del(lan_or_wan_intf_idx), RT_ERR_RG_OK);
	}
#endif

	//Reset all Lan interface to delete WAN port to their VLAN (only for Bridge mode WAN)
	if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan)
	{
		deleting_wan_port=rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
		wanPmsk.bits[0]=0x1<<deleting_wan_port;
		//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
		if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && deleting_wan_port==RTK_RG_PORT_PON){
			DEBUG("Special add RGMII to WAN_PORT_MASK.");
			wanPmsk.bits[0]|=0x1<<RTK_RG_PORT_RGMII;
		}
#endif
#if 0//def CONFIG_GPON_FEATURE
		//Clear Classfication for GPON stream ID based on interface index
		if(rg_db.systemGlobal.initParam.wanPortGponMode && rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx==RTK_RG_MAC_PORT_PON)
		{
			if(rg_db.systemGlobal.untagBridgeGponWanIdx==lan_or_wan_intf_idx)
			{
				_rtk_rg_cf_reserved_pon_intfSSIDRemap_del(-1);
				rg_db.systemGlobal.untagBridgeGponWanIdx=-1;
			}
			else
				_rtk_rg_cf_reserved_pon_intfSSIDRemap_del(lan_or_wan_intf_idx);
		}
#endif
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo!=NULL)	//not bridge WAN
		{
			//Stop ARP request timer if this WAN interface set IPv4 gatewayIP
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr){
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx].finished = 1;
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx].reqIp = 0;
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx].gwMacReqCallBack = NULL;
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx].disableL3Inspect = 0;
			}

			//Stop ARP request for PPTP and L2TP WAN
			if((rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP)||
				(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP)){
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp = 0;
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].gwMacReqCallBack = NULL;
				rg_db.systemGlobal.intfArpRequest[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].disableL3Inspect = 0;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				// For PPTP, L2TP WAN, delete FB related setting.
				_rtk_rg_flow_deleteTunnelConfig(lan_or_wan_intf_idx);
#endif
			}

			//Stop Neighbor Discovery request timer if this WAN interface set IPv6 gatewayIP
			if(*(unsigned int *)rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr!=0||
				*(unsigned int *)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr+4)!=0||
				*(unsigned int *)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr+8)!=0||
				*(unsigned int *)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr+12)!=0){
				rg_db.systemGlobal.intfNeighborDiscovery[lan_or_wan_intf_idx].finished = 1;
				bzero(rg_db.systemGlobal.intfNeighborDiscovery[lan_or_wan_intf_idx].reqIp.ipv6_addr,IPV6_ADDR_LEN);
				rg_db.systemGlobal.intfNeighborDiscovery[lan_or_wan_intf_idx].ipv6GwMacReqCallBack = NULL;
			}

			//Stop Neighbor Discovery request for Dslite WAN
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE){
				rg_db.systemGlobal.intfNeighborDiscovery[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;
				bzero(rg_db.systemGlobal.intfNeighborDiscovery[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp.ipv6_addr,IPV6_ADDR_LEN);
				rg_db.systemGlobal.intfNeighborDiscovery[lan_or_wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].ipv6GwMacReqCallBack = NULL;

			}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
				rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE){
				// For DSLite WAN, delete FB related setting.
				_rtk_rg_flow_deleteTunnelConfig(lan_or_wan_intf_idx);
			}
#endif
		}
#ifdef CONFIG_RG_PPPOE_PASSTHROUGH
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//apolloPro no need this feature
#else
		//Delete ACL setting for PPPoE Pass through
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type == RTK_RG_PPPoE)
			_rtk_rg_acl_reserved_pppoePassthrough_IntfisPppoewan_del(lan_or_wan_intf_idx);
#endif
#endif

		//20140620LUKE:if we set same interface twice, we just want to reset it's staticInfo without change it's binding rules and related data!!
		if(rg_db.systemGlobal.intfIdxForReset!=lan_or_wan_intf_idx)
		{
			//Delete the VLAN-Binding entries which binding to the deleting interface first
			for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
			{
				//if(rg_db.systemGlobal.bindToIntf[i]==lan_or_wan_intf_idx && rg_db.systemGlobal.bindWithVLAN[i]!=-1)		//the binding rule points to the deleting interface
				if(rg_db.bind[i].valid && rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx==lan_or_wan_intf_idx)
				{
					if(rg_db.bind[i].rtk_bind.vidLan!=0)		//the binding rule points to the deleting interface
					{
						errorno = rtk_rg_apollo_vlanBinding_del(i);
						if(errorno!=RT_ERR_RG_OK)goto RET_ERR;
						DEBUG("del vlan-binding[%d]",i);
					}
					else
					{
						//Delete Binding table for port-binding entries
						cb_bindEt.type=BIND_TYPE_PORT;
						cb_bindEt.port_bind_pmask.portmask=rg_db.bind[i].rtk_bind.portMask.bits[0];
						cb_bindEt.port_bind_pmask.portmask|=rg_db.bind[i].rtk_bind.extPortMask.bits[0]<<RTK_RG_EXT_PORT0;
						cb_bindEt.wan_intf_idx=lan_or_wan_intf_idx;
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
						if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid > IF_VALID_ENTRY)
						{	//delete pure software netif for port binding
							int iterPort=0;
							for(iterPort=RTK_RG_MAC_PORT0; iterPort<RTK_RG_MAC_PORT_MAX-1; iterPort++)
							{
								if(RG_INVALID_MAC_PORT(iterPort)) continue;
								if(rg_db.bind[i].rtk_bind.portMask.bits[0] & (1<<iterPort))
								{
									_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP + iterPort);
								}
							}
						}
#endif
						bzero(&pbindEt, sizeof(rtk_binding_entry_t));
						//ret = dal_apollomp_l34_bindingTable_set(i, &pbindEt); //FIXME:no RTK APIs
						ret = RTK_L34_BINDINGTABLE_SET(i, &pbindEt);
						errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
						if(ret==RT_ERR_CHIP_NOT_SUPPORTED)goto RET_ERR;
						errorno=RT_ERR_RG_PORT_BIND_SET_FAIL;
						if(ret!=RT_ERR_OK)goto RET_ERR;

						//rg_db.systemGlobal.bindToIntf[i]=-1;		//reset to unused
						DEBUG("del port-binding[%d], mask is %x",i,cb_bindEt.port_bind_pmask.portmask);
						//20140807LUKE: dismiss the portmask from WAN's binding_mask
						rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask&=(~(cb_bindEt.port_bind_pmask.portmask));
						DEBUG("wan[%d] port-binding-mask is %x..",lan_or_wan_intf_idx,rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask);

						//2 Call the initParam's bindingDelByHwCallBack
						if(rg_db.systemGlobal.initParam.bindingDelByHwCallBack != NULL)
						{
							rg_db.systemGlobal.initParam.bindingDelByHwCallBack(&cb_bindEt);
						}
					}
				}
			}
		}

		//20140424LUKE:we don't add LAN to WAN now, since binding scenario need more complicated setting!!
		switch(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type)
		{
			case RTK_RG_PPPoE:
			case RTK_RG_PPPoE_DSLITE:
				//delete the pppoe table entry
				errorno=RT_ERR_RG_PPPOE_SET_FAIL;
				pppoeEt.sessionID=0;
				ret=RTK_L34_PPPOETABLE_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_idx,&pppoeEt);
				if(ret!=RT_ERR_OK)goto RET_ERR;
				break;
			default:
				break;
		}

		//1 patch for DA==GatewayMac will hit layer2 unknown DA, if action is trap
		errorno=RT_ERR_RG_DELETE_GATEWAY_LUT_FAIL;
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)	//cpu tagged
			utpmsk.bits[0]=0;
		else
			utpmsk.bits[0]=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;
		//Delete the interface MAC entry
		_rtk_rg_deleteGatewayMacEntry(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id,utpmsk.bits[0]);
		if(rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_mechanism && rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
		{
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_upstreamL2Idx>=0)
				(pf.rtk_rg_macEntry_del)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_upstreamL2Idx);
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_upstreamL2Idx>=0)
				(pf.rtk_rg_macEntry_del)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_upstreamL2Idx);
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx>=0)
				(pf.rtk_rg_macEntry_del)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx);
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx>=0)
				(pf.rtk_rg_macEntry_del)(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx);
			if(rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx==lan_or_wan_intf_idx)
			{
				struct rtl8686_hwnat_customized_entry customized_entry={0};
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamInfo_prepared && rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamRing_modified){
					customized_entry.valid=FALSE;
					customized_entry.gmac=rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamGmac;
					customized_entry.rxRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamRxRingNum;
					customized_entry.txRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamTxRingNum;
					customized_entry.type=CUSTOMIZE_TYPE_VXLAN_UP;
					re8686_customized_rx_and_tx(customized_entry, NULL, NULL, NULL, NULL);
					rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamInfo_prepared=0;
					rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamRing_modified=0;
				}
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamInfo_prepared && rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamRing_modified){
					customized_entry.valid=FALSE;
					customized_entry.gmac=rg_db_dynamic_sram.vxlan_acc.vxlan_extraGmac;
					customized_entry.rxRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamRxRingNum;
					customized_entry.txRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamTxRingNum;
					customized_entry.type=CUSTOMIZE_TYPE_VXLAN_UP;
					re8686_customized_rx_and_tx(customized_entry, NULL, NULL, NULL, NULL);
					rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamInfo_prepared=0;
					rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamRing_modified=0;
				}
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamInfo_prepared && rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamRing_modified){
					customized_entry.valid=FALSE;
					customized_entry.gmac=rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamGmac;
					customized_entry.rxRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamRxRingNum;
					customized_entry.txRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamTxRingNum;
					customized_entry.type=CUSTOMIZE_TYPE_VXLAN_DOWN;
					re8686_customized_rx_and_tx(customized_entry, NULL, NULL, NULL, NULL);
					rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamInfo_prepared=0;
					rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamRing_modified=0;
				}
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamInfo_prepared && rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamRing_modified){
					customized_entry.valid=FALSE;
					customized_entry.gmac=rg_db_dynamic_sram.vxlan_acc.vxlan_extraGmac;
					customized_entry.rxRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamRxRingNum;
					customized_entry.txRingNum=rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamTxRingNum;
					customized_entry.type=CUSTOMIZE_TYPE_VXLAN_DOWN;
					re8686_customized_rx_and_tx(customized_entry, NULL, NULL, NULL, NULL);
					rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamInfo_prepared=0;
					rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamRing_modified=0;
				}
			}
		}
	}
	else		//LAN interface
	{
		//The LAN interface can not be deleted when WAN interface had added
		//errorno=RT_ERR_RG_MODIFY_LAN_AT_WAN_EXIST;
		//if(rg_db.systemGlobal.wanIntfTotalNum>0)
			//goto RET_ERR;

		if(rg_db.systemGlobal.initParam.macBasedTagDecision==0)
		{
			//reset bridge WAN's VLAN setting
			for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE
					&& rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.intf_vlan_id)
				{
					mbpmsk.bits[0] = (0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx) | RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;	//CPU port always on, or TRAP will failed
					utpmsk.bits[0] = (rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on)? 0 : mbpmsk.bits[0];
					//Patch:20131009, for multicast routing packet will use ingress's VLAN untag set, therefore set all none-member port as untag!!
					utpmsk.bits[0] |= (~(mbpmsk.bits[0]))&RTK_RG_ALL_MAC_PORTMASK;
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
					etpmsk.bits[0] = 0x1;							//CPUport always on, or TRAP will failed
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
					/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
					etpmsk.bits[0] = 0x0;
#else
#error
#endif
					errorno=RT_ERR_RG_VLAN_SET_FAIL;
					ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &mbpmsk, &utpmsk);
					if(ret!=RT_ERR_OK)goto RET_ERR;
					ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &etpmsk);
					if(ret!=RT_ERR_OK)goto RET_ERR;
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].wlan0DevMask = 0x0;
#endif
				}
			}
		}
#if 0
		//re-gather all Lan's VLAN information
		all_lan_pmsk.bits[0]=0;
		all_lan_etpmsk.bits[0]=0;
		all_lan_utagpmsk.bits[0]=0;
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.lanIntfGroup[i].index==lan_or_wan_intf_idx)
				continue;
			tmpVid=rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id;
			//DEBUG("i = %d, vid = %d\n",i,tmpVid);

			all_lan_pmsk.bits[0] |= rg_db.vlan[tmpVid].MemberPortmask.bits[0];
			all_lan_etpmsk.bits[0] |= rg_db.vlan[tmpVid].Ext_portmask.bits[0];
			all_lan_utagpmsk.bits[0] |= rg_db.vlan[tmpVid].UntagPortmask.bits[0];
		}

		//reset bridge WAN's VLAN setting, since there is LAN deleting
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			{
				//add untag set by wan setting
				utpmsk.bits[0]=rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask.bits[0]|all_lan_utagpmsk.bits[0];
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on)			//egress tagged packet
				{
					utpmsk.bits[0]&=(~(0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx));	//set WAN port to 0 in untag set (tagging)
					utpmsk.bits[0]&=(~(RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK));		//cpu port should follow wan port tag configuration.
				}
				else
				{
					utpmsk.bits[0]|=0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx;		//set WAN port to 1 in untag set (untagging)
					utpmsk.bits[0]|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;		//cpu port should follow wan port tag configuration.
				}

				if(all_lan_pmsk.bits[0]==0 && all_lan_etpmsk.bits[0]==0)		//the last LAN intf is deleting
				{
					//reset to WAN port only
					all_lan_pmsk.bits[0]|=0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx;
					errorno=RT_ERR_RG_VLAN_SET_FAIL;
					ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &all_lan_pmsk, &utpmsk);
					if(ret!=RT_ERR_OK)goto RET_ERR;
					ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &all_lan_etpmsk);
					if(ret!=RT_ERR_OK)goto RET_ERR;
				}
				else
				{
					errorno=RT_ERR_RG_VLAN_SET_FAIL;
					ret = RTK_VLAN_PORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &all_lan_pmsk, &utpmsk);
					if(ret!=RT_ERR_OK)goto RET_ERR;
					ret = RTK_VLAN_EXTPORT_SET(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id, &all_lan_etpmsk);
					if(ret!=RT_ERR_OK)goto RET_ERR;
				}
			}
		}
#endif
#if 0
		//If this is the last LAN interface, reset DEFAULT LAN VLAN to default value
		if(rg_db.systemGlobal.lanIntfTotalNum == 1)
		{
			mbpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;	//all port
			utpmsk.bits[0]=RTK_RG_ALL_MAC_PORTMASK;	//all untag
			etpmsk.bits[0]=RTK_RG_ALL_VIRUAL_PORTMASK;	//all extension port

			ret = RTK_VLAN_PORT_SET(DEFAULT_LAN_VLAN, &mbpmsk, &utpmsk);
			errorno=RT_ERR_RG_VLAN_SET_FAIL;
			if(ret!=RT_ERR_OK)goto RET_ERR;
			ret = RTK_VLAN_EXTPORT_SET(DEFAULT_LAN_VLAN, &etpmsk);
			if(ret!=RT_ERR_OK)goto RET_ERR;
		}
		else
		{
			//take off this LAN interface's member port and extension port from DEFAULT LAN VLAN
			//mbpmsk.bits[0]=0;
			//utpmsk.bits[0]=0;
			//etpmsk.bits[0]=0;
			//ret = rtk_vlan_port_get(DEFAULT_LAN_VLAN, &mbpmsk, &utpmsk);
			//errorno=RT_ERR_RG_VLAN_GET_FAIL;
			//if(ret!=RT_ERR_OK)goto RET_ERR;
			memcpy(&mbpmsk, &rg_db.vlan[DEFAULT_LAN_VLAN].MemberPortmask,sizeof(rtk_portmask_t));
			memcpy(&utpmsk, &rg_db.vlan[DEFAULT_LAN_VLAN].UntagPortmask,sizeof(rtk_portmask_t));
			//ret = rtk_vlan_extPort_get(DEFAULT_LAN_VLAN, &etpmsk);
			//if(ret!=RT_ERR_OK)goto RET_ERR;
			memcpy(&etpmsk, &rg_db.vlan[DEFAULT_LAN_VLAN].Ext_portmask,sizeof(rtk_portmask_t));


			//Transfer RG portmask to RTK portmask
			_rtk_rg_portmask_translator(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->port_mask,&out_mac_pmask,&out_ext_pmask);

			mbpmsk.bits[0]&=(~(out_mac_pmask.bits[0]));
			etpmsk.bits[0]&=(~(out_ext_pmask.bits[0]));

			ret = RTK_VLAN_PORT_SET(DEFAULT_LAN_VLAN, &mbpmsk, &utpmsk);
			errorno=RT_ERR_RG_VLAN_SET_FAIL;
			if(ret!=RT_ERR_OK)goto RET_ERR;
			ret = RTK_VLAN_EXTPORT_SET(DEFAULT_LAN_VLAN, &etpmsk);
			if(ret!=RT_ERR_OK)goto RET_ERR;
		}

		//Reset PPB setting, if any
		/*errorno=RT_ERR_RG_PPB_SET_FAILED;
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->pppoe_passThrough == 1)
		{
			bzero(&protoVlanCfg,sizeof(rtk_vlan_protoVlanCfg_t));
			protoVlanCfg.vid=DEFAULT_CPU_VLAN;		//fixme: rtk api won't accept vid=0, so we assign a dummy one
			if(out_ext_pmask.bits[0] > 0x1)
			{
				ret = rtk_vlan_portProtoVlan_set(RTK_RG_MAC_PORT_CPU,PPPOE_DISCOVERY_GROUPID,&protoVlanCfg);
				if(ret!=RT_ERR_OK)goto RET_ERR;
				ret = rtk_vlan_portProtoVlan_set(RTK_RG_MAC_PORT_CPU,PPPOE_SESSION_GROUPID,&protoVlanCfg);
				if(ret!=RT_ERR_OK)goto RET_ERR;
			}
			for(i=0;i<RTK_RG_PORT_CPU;i++)
			{
				if((out_mac_pmask.bits[0]&(0x1<<i)) > 0)
				{
					ret = rtk_vlan_portProtoVlan_set(i,PPPOE_DISCOVERY_GROUPID,&protoVlanCfg);
					if(ret!=RT_ERR_OK)goto RET_ERR;
					ret = rtk_vlan_portProtoVlan_set(i,PPPOE_SESSION_GROUPID,&protoVlanCfg);
					if(ret!=RT_ERR_OK)goto RET_ERR;
				}
			}
			errorno=RT_ERR_RG_VLAN_SET_FAIL;
			ret = RTK_VLAN_DESTROY(DEFAULT_PPB_VLAN_START+lan_or_wan_intf_idx);
			if(ret!=RT_ERR_OK)goto RET_ERR;
		}*/

		//Set back port-based and extport-based VLAN ID
		errorno=RT_ERR_RG_VLAN_SET_FAIL;
		for(i=0;i<RTK_RG_PORT_MAX;i++)
		{
			if((rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->port_mask.portmask&(0x1<<i)) > 0)
			{
				if(i<=RTK_RG_PORT_CPU)
				{
					ret = rtk_vlan_portPvid_set(i, DEFAULT_CPU_VLAN);
					if(ret!=RT_ERR_OK)
						goto RET_ERR;
				}
				else
				{
					ret = rtk_vlan_extPortPvid_set(i-RTK_RG_PORT_CPU, DEFAULT_CPU_VLAN);
					if(ret!=RT_ERR_OK)
						goto RET_ERR;
				}

				rg_db.systemGlobal.portBasedVID[i]=DEFAULT_CPU_VLAN;		//reset port-based and ext-port-based VLAN in rg_db
			}
		}
#endif

		//1 patch for DA==GatewayMac will hit layer2 unknown DA, if action is trap
		errorno=RT_ERR_RG_DELETE_GATEWAY_LUT_FAIL;
		//Delete the interface MAC entry
		_rtk_rg_deleteGatewayMacEntry(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->gmac.octet,rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->intf_vlan_id,rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->untag_mask.portmask);
	}

    //Delete routing table entry, decrease Nexthop table ref count, if zero, delete nexthop entry
    errorno=_rtk_rg_deleteIPv4Routing(lan_or_wan_intf_idx);
	if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

	//Delete ipv6 routing table entry, decrease Nexthop table ref count, if zero delete nexthop entry
	errorno=_rtk_rg_deleteIPv6Routing(lan_or_wan_intf_idx);
	if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

    if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1)
    {
    	//20160625LUKE: decrease nexthop reference count when del interface
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4>=0){
			ret=_rtk_rg_decreaseNexthopReference(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4);
			if(ret!=RT_ERR_RG_OK)goto RET_ERR;
		}
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.nexthop_ipv6>=0){
			ret=_rtk_rg_decreaseNexthopReference(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.nexthop_ipv6);
			if(ret!=RT_ERR_RG_OK)goto RET_ERR;
		}

        if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4>=0)
        {
        	errorno = RT_ERR_RG_NXP_SET_FAIL;
			ret=_rtk_rg_decreaseNexthopReference(rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype.nhIdx);
			if(ret!=RT_ERR_RG_OK)goto RET_ERR;

	        bzero(&wantEt, sizeof(rtk_wanType_entry_t));
			rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].valid=0;
	        ret = RTK_L34_WANTYPETABLE_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4, &wantEt);
			errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
	        if(ret==RT_ERR_CHIP_NOT_SUPPORTED)goto RET_ERR;
			errorno=RT_ERR_RG_WANTYPE_SET_FAIL;
	        if(ret!=RT_ERR_OK)goto RET_ERR;
        }
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6>=0)
        {
			errorno = RT_ERR_RG_NXP_SET_FAIL;
			ret=_rtk_rg_decreaseNexthopReference(rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6].rtk_wantype.nhIdx);
			if(ret!=RT_ERR_RG_OK)goto RET_ERR;

	        bzero(&wantEt, sizeof(rtk_wanType_entry_t));
			rg_db.wantype[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6].valid=0;
	        ret = RTK_L34_WANTYPETABLE_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6, &wantEt);
			errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
	        if(ret==RT_ERR_CHIP_NOT_SUPPORTED)goto RET_ERR;
			errorno=RT_ERR_RG_WANTYPE_SET_FAIL;
	        if(ret!=RT_ERR_OK)goto RET_ERR;
			errorno = RT_ERR_RG_NXP_SET_FAIL;
        }


#if defined(CONFIG_RG_RTL9602C_SERIES)
		//9602bvb not support vlan based pri
#else
		//Reset VLAN priority
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri_enable==RTK_RG_ENABLED &&
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri!=0)
		{
			ret = RTK_VLAN_PRIORITY_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id, 0);
			errorno=RT_ERR_RG_VLAN_SET_FAIL;
			if(ret!=RT_ERR_OK)goto RET_ERR;
			ret = RTK_VLAN_PRIORITYENABLE_SET(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id, DISABLED);
			errorno=RT_ERR_RG_VLAN_SET_FAIL;
			if(ret!=RT_ERR_OK)goto RET_ERR;
		}
#endif

	}

	//Delete the deleting interface's VLAN setting, if there is no other interface or binding rule use it
	ret = 0;
	if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1)	//wan interface
	{
		tmpVid = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.none_internet &&
			rg_db.systemGlobal.otherWanVlan[lan_or_wan_intf_idx]!=0)
		{
			//delete Other Wan's VLANID used for traffic isolation
			ret = RTK_VLAN_DESTROY(rg_db.systemGlobal.otherWanVlan[lan_or_wan_intf_idx]);
			errorno=RT_ERR_RG_VLAN_SET_FAIL;
			if(ret!=RT_ERR_OK)goto RET_ERR;
			rg_db.systemGlobal.otherWanVlan[lan_or_wan_intf_idx]=0;
		}
		if(rg_db.systemGlobal.wanVlanMemAppend[lan_or_wan_intf_idx].portmask)
		{
			//clear it
			rg_db.systemGlobal.wanVlanMemAppend[lan_or_wan_intf_idx].portmask=0;
			rg_db.systemGlobal.wanVlanMemAppend_origMem[lan_or_wan_intf_idx].bits[0]=0;
			rg_db.systemGlobal.wanVlanMemAppend_origExt[lan_or_wan_intf_idx].bits[0]=0;
		}
	}
	else	//lan interface
	{
		tmpVid = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->intf_vlan_id;
		memcpy(&pvid_mac_pmask,&rg_db.vlan[tmpVid].MemberPortmask,sizeof(rtk_portmask_t));
		memcpy(&pvid_ext_pmask,&rg_db.vlan[tmpVid].Ext_portmask,sizeof(rtk_portmask_t));
	}

	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
	{
		if(i != lan_or_wan_intf_idx && rg_db.systemGlobal.interfaceInfo[i].valid)
		{
			if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1)	//wan interface
			{
				if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id==tmpVid)
					ret++;
				//20150915LUKE: clear PPTP/L2TP's baseIntf_idx if this is the base WAN of them, and re-initialize request for MAC
				if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.baseIntf_idx==lan_or_wan_intf_idx)
				{
					if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP)
						_rtk_rg_PPTPLearningTimerInitialize(i);
					else
						_rtk_rg_L2TPLearningTimerInitialize(i);
					rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.baseIntf_idx=-1;
					memcpy(&nxpEt,&rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.nexthop_ipv4].rtk_nexthop,sizeof(rtk_l34_nexthop_entry_t));
					nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;		//use this DUMMY index to force packet TRAP to CPU
					rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.nexthop_ipv4].valid=1;
					RTK_L34_NEXTHOPTABLE_SET(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.nexthop_ipv4, &nxpEt);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					// For PPTP, L2TP WAN, delete FB related setting.
					_rtk_rg_flow_deleteTunnelConfig(i);
#endif
				}
			}
			else	//lan interface
			{
				if(rg_db.systemGlobal.interfaceInfo[i].p_lanIntfConf->intf_vlan_id==tmpVid)
					ret++;
			}
		}
	}
	for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
	{
		//if(rg_db.systemGlobal.bindWithVLAN[i]==tmpVid)
		if(rg_db.bind[i].valid  && rg_db.bind[i].rtk_bind.vidLan==tmpVid)
			ret++;
	}

	if(ret==0)
	{
		ret = RTK_VLAN_DESTROY(tmpVid);
		errorno=RT_ERR_RG_VLAN_SET_FAIL;
		if(ret!=RT_ERR_OK)goto RET_ERR;
	}

#if defined(CONFIG_RG_RTL9602C_SERIES)
	{
		//distroyed vlan based prioirty.
		DEBUG("del vlanbased priority");
		if(lan_or_wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_ASSIGN_VLAN_BASED_RRIORITY_FOR_INTF0+lan_or_wan_intf_idx);
	}
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES) //patch for mismatching mib ipv6 netif problem
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan==1
			&& rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_BRIDGE)
		{
			if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ip_version==IPVER_V4V6
				&& rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->napt_enable==1)
			{
				bzero(&intfEt, sizeof(rtk_l34_netif_entry_t));
				ret = RTK_L34_NETIFTABLE_SET(lan_or_wan_intf_idx+(MAX_NETIF_HW_TABLE_SIZE/2), &intfEt);
				errorno=RT_ERR_RG_INTF_SET_FAIL;
				if(ret!=RT_ERR_OK)goto RET_ERR;
				//bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx+(MAX_NETIF_SW_TABLE_SIZE/2)], sizeof(rtk_rg_interface_info_global_t));
			}
		}
	}
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//force delete flow by interface before Netif change
	_rtk_rg_flow_del_by_intf(lan_or_wan_intf_idx);
#endif

    //Delete interface table entry
    bzero(&intfEt, sizeof(rtk_l34_netif_entry_t));
    ret = RTK_L34_NETIFTABLE_SET(lan_or_wan_intf_idx, &intfEt);
	errorno=RT_ERR_RG_INTF_SET_FAIL;
    if(ret!=RT_ERR_OK)goto RET_ERR;

#if defined(CONFIG_RG_RTL9602C_SERIES)
    // errorno=RT_ERR_RG_INTF_SET_FAIL;
    ret = rtk_rg_apolloFE_interfaceMibCounter_del(lan_or_wan_intf_idx);
    if(ret!=RT_ERR_OK)goto RET_ERR;

#endif
    /*for(i=0;i<8;i++)
    {
    	//Lookup IP table for checking related interface
    	memset(&extipEt, 0, sizeof(extipEt));
    	ret = rtk_l34_extIntIPTable_get(i, &extipEt);
    	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_EXTIP_FAIL);

    	//Lookup nexthop table
    	memset(&nxpEt, 0, sizeof(nxpEt));
    	ret = rtk_l34_nexthopTable_get(extipEt.nhIdx, &nxpEt);
    	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_NXP_FAIL);

    	if(nxpEt.ifIdx == lan_or_wan_intf_idx)
    	{
    		rg_db.systemGlobal.nxpRefCount[j]--;
    		match_intf = 1;

    		if(rg_db.systemGlobal.nxpRefCount[j]==0)
    		{
    			//Delete Nexthop entry, since nobody use it
    			if(nxpEt.type==L34_NH_PPPOE)
    			{
    				//Delete PPPoE table
    				memset(&pppEt, 0, sizeof(pppEt));
    				RTK_L34_PPPOETABLE_SET(nxpEt.pppoeIdx, &pppEt);
    				if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_PPPOE_FAIL);
    			}
    			memset(&nxpEt, 0, sizeof(nxpEt));
    			ret = RTK_L34_NEXTHOPTABLE_SET(j, &nxpEt);
    			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_NXP_FAIL);
    		}
    	}
    }*/

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	//Check if WLAN binding to this WAN, clear it!
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
		{
			if(rg_db.systemGlobal.wlan0BindDecision[i].exist && rg_db.systemGlobal.wlan0BindDecision[i].set_bind && rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf==lan_or_wan_intf_idx)
			{
				rg_db.systemGlobal.wlan0BindDecision[i].set_bind=0;
				rg_db.systemGlobal.wlan0BindDecision[i].bind_wanIntf=0;
				rg_db.systemGlobal.wlan0BindingUsed&=(~(0x1<<i));
			}
		}
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.internalSupportMask&RTK_RG_INTERNAL_SUPPORT_BIT4)
	{
		if(rg_db.systemGlobal.igmp_pppoe_passthrough_learning==0)
		{

			//removed the H/W intf PPPoE Multicast trap rule
			if( rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan &&
				rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE &&
				rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_idx >=0 &&
				rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid ){
				_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_PPPoE_MULTICAST_INTF0_PERMIT+lan_or_wan_intf_idx);
			}

			//check if default bridge PPPoE Multicast trap rule is need or not.
			addRsvPPPoEBridgeMcTrap=0;
			for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
			{
				if( rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan &&
					rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE &&
					rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.pppoe_idx >=0 &&
					rg_db.systemGlobal.interfaceInfo[i].valid )
				{
					if(i == lan_or_wan_intf_idx)
						continue;
					//exist any PPPoE Wan in H/W,  still need reserved
					addRsvPPPoEBridgeMcTrap=1;
					break;
				}
			}
			if(addRsvPPPoEBridgeMcTrap==0){
				_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_PPPoE_MULTICAST_DEFAULT_TRAP);
			}
		}
	}
#endif


	//keep Global variable structure for callback function
	bzero(&keep_store_info,sizeof(rtk_rg_intfInfo_t));
	memcpy(&keep_store_info,&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo,sizeof(rtk_rg_intfInfo_t));

    //Reset Global variable structure
    rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].valid=IF_INVALID_ENTRY;
    bzero(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.intf_name, 32);
    if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.is_wan == 1)
    {
    	//Reset WAN set mask
    	wan_set_mask=0x1<<lan_or_wan_intf_idx;
    	rg_db.systemGlobal.wanInfoSet &= ~(wan_set_mask);

		//Decrease Global WAN interface count
		rg_db.systemGlobal.wanIntfTotalNum--;		//decrease WAN interface number
#if 1
		//Reset WAN group entry, defragmentation if needed
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index != rg_db.systemGlobal.wanIntfTotalNum)
		{
			for(i=rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
			{
				memcpy(&rg_db.systemGlobal.wanIntfGroup[i],&rg_db.systemGlobal.wanIntfGroup[i+1],sizeof(rtk_rg_wan_interface_group_info_t));
				//rg_db.systemGlobal.wanIntfGroup[i].index = rg_db.systemGlobal.wanIntfGroup[i+1].index;
				//rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo = rg_db.systemGlobal.wanIntfGroup[i+1].p_intfInfo;
				//rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf = rg_db.systemGlobal.wanIntfGroup[i+1].p_wanIntfConf;
				rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->lan_or_wan_index--;
			}
		}
#else
		//Reset WAN group entry, defragmentation if needed
		//since interface order is not important, we just move the last one to the deleting index
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index != rg_db.systemGlobal.wanIntfTotalNum)
		{
			rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index].index =
				rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum].index;
			rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index].p_intfInfo=
				rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum].p_intfInfo;
		}
#endif
		bzero(&rg_db.systemGlobal.wanIntfGroup[rg_db.systemGlobal.wanIntfTotalNum],sizeof(rtk_rg_wan_interface_group_info_t));

#if defined(CONFIG_RG_G3_SERIES)
		rg_db.systemGlobal.wanIntfGroup_for_genericIntf[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lanWan_groupIdx_for_genericIntf] = 0;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lanWan_groupIdx_for_genericIntf = 0;
#endif

        //Clear WAN structure
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4=-1;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6=-1;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wirelessWan=RG_WWAN_WIRED;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_idx=-1;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.extip_idx=-1;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.baseIntf_idx=-1;

        bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac, sizeof(rtk_mac_t));
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask=0;
        //rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.extport_binding_mask.bits[0]=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id=0;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri_enable=RTK_RG_DISABLED;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri=0;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.isIVL=0;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.none_internet=0;

		if(rg_db.systemGlobal.defaultRouteSet == lan_or_wan_intf_idx)
			rg_db.systemGlobal.defaultRouteSet=-1;
		if(rg_db.systemGlobal.defaultIPV6RouteSet == lan_or_wan_intf_idx)
			rg_db.systemGlobal.defaultIPV6RouteSet=-1;

		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo!=NULL)	//not bridge WAN
		{
			//20140620LUKE:if we set same interface twice, we just want to reset it's staticInfo without change it's binding rules and related data!!
			if(rg_db.systemGlobal.intfIdxForReset!=lan_or_wan_intf_idx)
			{
				//Check for L4 WAN to clean all virtualServer, UPnP, and DMZ for the WAN index
				//if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->napt_enable)	//napt_enable is zero while intf is up but not getting ip
				{
					//Clear Virtual Server
					i=0;
					ret=RT_ERR_RG_OK;
					while(i<MAX_VIRTUAL_SERVER_SW_TABLE_SIZE && ret==RT_ERR_RG_OK)
					{
						ret=rtk_rg_apollo_virtualServer_find(&virtual_server,&i);
						if(ret==RT_ERR_RG_OK && virtual_server.wan_intf_idx==lan_or_wan_intf_idx)
							rtk_rg_apollo_virtualServer_del(i);
						i++;
					}
					//Clear UPnP
					i=0;
					ret=RT_ERR_RG_OK;
					while(i<MAX_UPNP_SW_TABLE_SIZE && ret==RT_ERR_RG_OK)
					{
						ret=rtk_rg_apollo_upnpConnection_find(&upnp,&i);
						if(ret==RT_ERR_RG_OK && upnp.wan_intf_idx==lan_or_wan_intf_idx)
							rtk_rg_apollo_upnpConnection_del(i);
						i++;
					}
					//Clear DMZ
					bzero(&dmz_info,sizeof(rtk_rg_dmzInfo_t));
					rtk_rg_apollo_dmzHost_set(lan_or_wan_intf_idx,&dmz_info);
				}
			}

			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ip_version=0;		//default ipv4
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->napt_enable=0;
	        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ip_addr=0;
	        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ip_network_mask=0;
			bzero(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv6_mask_length=0;
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv4_default_gateway_on=0;
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr=0;
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->ipv6_default_gateway_on=0;
			bzero(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
	        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->mtu=0;
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4=0;
			bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv4,sizeof(rtk_mac_t));
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv6=0;
			bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv6,sizeof(rtk_mac_t));
		}

        if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DHCP)
        {
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dhcp_client_info.stauts=0;
        }
        else if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)
        {
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.after_dial.sessionId=0;

            bzero(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.username, 4);
            bzero(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.password, 4);
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.auth_type=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.pppoe_proxy_enable=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.max_pppoe_proxy_num=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.auto_reconnect=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.dial_on_demond=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.idle_timeout_secs=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.stauts=0;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.dialOnDemondCallBack=NULL;
            rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.idleTimeOutCallBack=NULL;
        }
		else if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE)
		{
			bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite,sizeof(rtk_l34_dsliteInf_entry_t));
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_info.aftr_mac_auto_learn=0;
			bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_info.aftr_mac_addr,sizeof(rtk_mac_t));

#if defined(CONFIG_RG_RTL9602C_SERIES)
			bzero(&rg_db.dslite[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_idx].rtk_dslite,sizeof(rtk_l34_dsliteInf_entry_t));
			ASSERT_EQ(RTK_L34_DSLITEINFTABLE_SET(&rg_db.dslite[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_idx].rtk_dslite),RT_ERR_OK);
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_idx=-1;
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//apolloPro will always trap if unhit flow
#else
			//disable reserve ACL
			if(lan_or_wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
				_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP+lan_or_wan_intf_idx);
#endif
		}
		else if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
		{
			bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite,sizeof(rtk_l34_dsliteInf_entry_t));
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.aftr_mac_auto_learn=0;
			bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.aftr_mac_addr,sizeof(rtk_mac_t));

#if defined(CONFIG_RG_RTL9602C_SERIES)
			bzero(&rg_db.dslite[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_idx].rtk_dslite,sizeof(rtk_l34_dsliteInf_entry_t));
			ASSERT_EQ(RTK_L34_DSLITEINFTABLE_SET(&rg_db.dslite[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_idx].rtk_dslite),RT_ERR_OK);
			rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.dslite_idx=-1;
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//ApolloPro always trap if not hit flow
#else
			//disable reserve ACL
			if(lan_or_wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
				_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP+lan_or_wan_intf_idx);
#endif
		}
		else if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
		{
			int vxlan_remote_ipv4_gatewayMac_l2Idx = rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx;
			if(0<=vxlan_remote_ipv4_gatewayMac_l2Idx && vxlan_remote_ipv4_gatewayMac_l2Idx<MAX_LUT_SW_TABLE_SIZE)
			{
				if(rg_db.lut[vxlan_remote_ipv4_gatewayMac_l2Idx].valid && rg_db.lut[vxlan_remote_ipv4_gatewayMac_l2Idx].vxlanStaticRefCnt>0)
					rg_db.lut[vxlan_remote_ipv4_gatewayMac_l2Idx].vxlanStaticRefCnt--;
				rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx = FAIL;
			}
		}
		
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_wanStaticInfo=NULL;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type=0;

		//Update PVID
		_rtk_rg_updateWANPortBasedVID(deleting_wan_port);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//ApolloPro always trap if not hit flow
#else
		//20141208LUKE: setup ACL for traping DHCP packets
		if(keep_store_info.wan_intf.wan_intf_conf.wan_type==RTK_RG_DHCP && lan_or_wan_intf_idx<MAX_NETIF_HW_TABLE_SIZE)
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_INTF0_DHCP_TRAP+lan_or_wan_intf_idx);
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		if(rg_db.systemGlobal.fragment_ipv4_intf_trap){
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_INTF0_IPV4_FRAGMENT_TRAP+lan_or_wan_intf_idx);
		}
#endif


#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		if(rg_db.systemGlobal.trap_routing_wan_by_acl)
		{
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv4_TRAP+lan_or_wan_intf_idx);
		}
		//20170316: trap WAN gateway ip of IPv6 STATIC ROUTE with reserved acl
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv6_TRAP+lan_or_wan_intf_idx);
#endif
    }
    else
    {
		//Decrease Global LAN interface count
		rg_db.systemGlobal.lanIntfTotalNum--;		//decrease LAN interface number
#if 1
    	//Reset LAN group entry, defragmentation if needed
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index != rg_db.systemGlobal.lanIntfTotalNum)
		{
			for(i=rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
			{
				rg_db.systemGlobal.lanIntfGroup[i].index = rg_db.systemGlobal.lanIntfGroup[i+1].index;
				rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo = rg_db.systemGlobal.lanIntfGroup[i+1].p_intfInfo;
				rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->lan_or_wan_index--;
			}
		}
#else
		//Reset LAN group entry, defragmentation if needed
		//since interface order is not important, we just move the last one to the deleting index
		if(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index != rg_db.systemGlobal.lanIntfTotalNum)
		{
			rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index].index =
				rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.lanIntfTotalNum].index;
			rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lan_or_wan_index].p_intfInfo=
				rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.lanIntfTotalNum].p_intfInfo;
		}
#endif

#if defined(CONFIG_RG_G3_SERIES)
		rg_db.systemGlobal.lanIntfGroup_for_genericIntf[rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lanWan_groupIdx_for_genericIntf] = 0;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].lanWan_groupIdx_for_genericIntf = 0;
#endif

		rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.lanIntfTotalNum].index=0;
		rg_db.systemGlobal.lanIntfGroup[rg_db.systemGlobal.lanIntfTotalNum].p_intfInfo=NULL;

		//Reset LAN's portmask
		rg_db.systemGlobal.lanPortMask.portmask = 0;
		for(i=0; i<rg_db.systemGlobal.lanIntfTotalNum; i++)
		{
			rg_db.systemGlobal.lanPortMask.portmask |= rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->port_mask.portmask;
		}
		//update dmac2cvid and vid unmatched action
		assert_ok(_rtk_rg_dmac2cvid_and_vidUnmatch_update());

        //Clear LAN structure
        bzero(&rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->gmac, sizeof(rtk_mac_t));
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->ip_version=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->ip_addr=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->ip_network_mask=0;
		bzero(rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->ipv6_network_mask_length=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->port_mask.portmask=0;
        //rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.extport_mask.bits[0]=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->intf_vlan_id=0;
		//rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->pppoe_passThrough=0;
#if 0
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.dhcp_server_enable=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.lease_time=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.dhcp_start_ip_addr=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.dhcp_end_ip_addr=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.dhcp_port_binding_mask.bits[0]=0;
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo.lan_intf.dhcp_extport_binding_mask.bits[0]=0;
#endif
        rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf->mtu=0;
		rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].p_lanIntfConf=NULL;

		//Update PVID
		_rtk_rg_updatePortBasedVIDByLanOrder(pvid_mac_pmask, pvid_ext_pmask);
    }

#if defined(CONFIG_RG_RTL9600_SERIES)
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0)){
		// Multicast packets must change cvid to PVID if they're from PON port and un-Ctag. (MC CVID is not from internalVID when VSPMSK enabled)
#if 0
		{
			rtk_rg_aclAndCf_reserved_multicastVidTranslateForIpv4_t multicastVidTranslateForIpv4;
			rtk_rg_aclAndCf_reserved_multicastVidTranslateForIpv6_t multicastVidTranslateForIpv6;
			//int pvid;
			//rtk_vlan_portPvid_get(RTK_RG_MAC_PORT_PON,&pvid);
			multicastVidTranslateForIpv4.vid=rg_db.systemGlobal.portBasedVID[RTK_RG_MAC_PORT_PON];
			multicastVidTranslateForIpv6.vid=rg_db.systemGlobal.portBasedVID[RTK_RG_MAC_PORT_PON];
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV4, &multicastVidTranslateForIpv4));
			assert_ok(_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_MULTICAST_VID_TRANSLATE_FOR_IPV6, &multicastVidTranslateForIpv6));

		}
#endif
	}
#endif



#if defined(CONFIG_RG_RTL9600_SERIES)

	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl==1 &&
		rg_db.systemGlobal.pppoeGponSmallbandwithControlSupportBrigeSameMac==1)
	{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_GPON_PPPoE_SMALL_BANDWIDTH_BRIDGE_DMAC_SAME_AS_INTF0_REMOTE_MAC+lan_or_wan_intf_idx);
	}
#endif



	errorno=RT_ERR_RG_OK;

	//Only turn on this when macBasedTagDecision is set to 1
	if(rg_db.systemGlobal.initParam.macBasedTagDecision)
	{
		//UpdateBindInternet
		_rtk_rg_updateBindWanIntf(NULL);
		//Update non-binding
		_rtk_rg_updateNoneBindingPortmask(rg_db.systemGlobal.wanPortMask.portmask);
		//Update PVID of OtherWan-binding port to vlan specific for the WAN
		_rtk_rg_updateBindOtherWanPortBasedVID(NULL);
	}

	//Check PPPoE Pass through
	_rtk_rg_refreshPPPoEPassThroughLanOrWanPortMask();

#if defined(CONFIG_RG_RTL9602C_SERIES)
	//20160418LUKE: for DSlite routing mode, we should trap TCP SYN for MSS clamping.
	_rtk_rg_dslite_routing_reserved_acl_decision();
#endif

#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	//20141225LUKE: since LAN or WAN is gone, we should release hw ACL which use the WAN interface as egress interface or use LANGMAC as DMAC for L34
	if(rg_db.systemGlobal.acl_SW_egress_intf_type_zero_num)
		ASSERT_EQ(_rtk_rg_acl_user_part_rearrange(),RT_ERR_RG_OK);
#endif

	//del wan-interfcae callback to sync protocal-stack
	if(rg_db.systemGlobal.initParam.interfaceDelByHwCallBack != NULL)
	{
		//rg_db.systemGlobal.interfaceInfo[lan_or_wan_intf_idx].storedInfo  has been reset! so, use keep_store_info
		rg_db.systemGlobal.initParam.interfaceDelByHwCallBack(&keep_store_info,&lan_or_wan_intf_idx);
	}


	//20150315CHUCK: detect if RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY is needed.
	if(_rtk_rg_add_pppoe_lcp_reserved_acl_detect()){
		rtk_rg_aclAndCf_reserved_ack_packet_assign_priority_t ack_packet_assign_priority;
		bzero(&ack_packet_assign_priority,sizeof(ack_packet_assign_priority));

		ack_packet_assign_priority.priority=7;
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(ack_packet_assign_priority.priority==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
			ack_packet_assign_priority.priority = (CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI-1);
#endif
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY, &ack_packet_assign_priority);
		DEBUG("Add reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");

	}else{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY);
		DEBUG("Del reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");
	}


	if(_rtk_rg_add_l2tp_lcp_reserved_acl_detect()){
		rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_t lcp_packet_assign_priority;
		bzero(&lcp_packet_assign_priority,sizeof(rtk_rg_aclAndCf_reserved_l2tp_control_lcp_trap_and_assign_priority_t));
		lcp_packet_assign_priority.priority=7;

#ifdef CONFIG_DUALBAND_CONCURRENT
		if(lcp_packet_assign_priority.priority==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
			lcp_packet_assign_priority.priority = (CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI-1);
#endif
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_L2TP_CONTROL_LCP_PACKET_TRAP_AND_ASSIGN_PRIORITY, &lcp_packet_assign_priority);
		DEBUG("Add reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");
	}else{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_L2TP_CONTROL_LCP_PACKET_TRAP_AND_ASSIGN_PRIORITY);
		DEBUG("Del reserved ACL RTK_RG_ACLANDCF_RESERVED_PPPoE_LCP_PACKET_ASSIGN_PRIORITY");

	}



	//if non-any-dslite-wan delete dsliteMc entry
	{
		uint32 delDsliteMcEntry=1;
		rtk_l34_dsliteMc_entry_t dsliteMcEntry;

		for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
		{
			if( rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan &&
				rg_db.systemGlobal.interfaceInfo[i].valid &&
				(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
				rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE))
			{
				delDsliteMcEntry=0;
				break;
			}
		}

		if(delDsliteMcEntry)
		{
			bzero(&dsliteMcEntry,sizeof(dsliteMcEntry));
			memset(&dsliteMcEntry.ipUPrefix64Mask,0xff,sizeof(rtk_ipv6_addr_t));
			memset(&dsliteMcEntry.ipMPrefix64Mask,0xff,sizeof(rtk_ipv6_addr_t));
			ASSERT_EQ(RTK_L34_DSLITEMULTICAST_SET(&dsliteMcEntry),RT_ERR_RG_OK);
		}
	}


	ASSERT_EQ(_rtk_rg_pon_rgmii_as_cf_port_check(),RT_ERR_RG_OK);
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	rtk_rg_apolloPro_interfaceMibCounter_del(lan_or_wan_intf_idx); //clear interface mib
#endif
	//Clear shortcut
	_rtk_rg_shortCut_clear();
RET_ERR:
	//------------------ Critical Section End -----------------------//
	//rg_unlock(&rg_kernel.interfaceLock);
    RETURN_ERR(errorno);
}


/*
	if (valid_lan_or_wan_intf_idx == -1)
		find interface by ip (wan first then lan)
	else
		find first vaild start from valid_lan_or_wan_intf_idx
 */
rtk_rg_err_code_t rtk_rg_apollo_intfInfo_find(rtk_rg_intfInfo_t *intf_info, int *valid_lan_or_wan_intf_idx)
{
    int i,/*ret,*/valid_idx;
	//ipaddr_t search_ip, search_mask;
    //rtk_l34_netif_entry_t intfEt;
    rtk_ipv6_addr_t zeroV6Addr;

    //Check parameter
    if(intf_info == NULL || valid_lan_or_wan_intf_idx == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    valid_idx = *valid_lan_or_wan_intf_idx;
    if(valid_idx<-1 || valid_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	if(valid_idx == -1)
	{
		//Check IP address valid or not
		bzero(zeroV6Addr.ipv6_addr,IPV6_ADDR_LEN);
		if(intf_info->lan_intf.ip_addr == 0 && memcmp(intf_info->lan_intf.ipv6_addr.ipv6_addr,zeroV6Addr.ipv6_addr,IPV6_ADDR_LEN) == 0)
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);


		//search_ip=intf_info->lan_intf.ip_addr;
		//search_mask=intf_info->lan_intf.ip_network_mask;

		//Find interface by ip
		//Search Wan first, then Lan

		for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
		{
			//Bridge WAN won't be compared with
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
				continue;


			if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr == intf_info->lan_intf.ip_addr ||
				memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ipv6_addr.ipv6_addr,intf_info->lan_intf.ipv6_addr.ipv6_addr,IPV6_ADDR_LEN)==0)

			{
				valid_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
				goto MATCHING_IDX;
			}
		}

		for(i=0; i<rg_db.systemGlobal.lanIntfTotalNum; i++)
		{
			if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_addr == intf_info->lan_intf.ip_addr ||
				memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ipv6_addr.ipv6_addr,intf_info->lan_intf.ipv6_addr.ipv6_addr,IPV6_ADDR_LEN)==0)
			{
				valid_idx=rg_db.systemGlobal.lanIntfGroup[i].index;
				goto MATCHING_IDX;
			}
		}

		return (RT_ERR_RG_ENTRY_NOT_EXIST);
	}
	else
	{
	    //Find the first valid interface from valid_lan_or_wan_intf_idx
	    for(i=valid_idx; i<MAX_NETIF_SW_TABLE_SIZE; i++)
	    {
	        //bzero(&intfEt, sizeof(rtk_l34_netif_entry_t));
	        //ret = rtk_l34_netifTable_get(i, &intfEt);
	        //if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_INTF_GET_FAIL);

	        //if(intfEt.valid != 0)
	        if(rg_db.systemGlobal.interfaceInfo[i].valid)
	        {
	            valid_idx = i;
	            break;
	        }
	    }
	    if(i==MAX_NETIF_SW_TABLE_SIZE)
			return (RT_ERR_RG_ENTRY_NOT_EXIST);
	}

MATCHING_IDX:

	bzero(intf_info,sizeof(rtk_rg_intfInfo_t));
	memcpy(intf_info,&rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo,sizeof(rtk_rg_intfInfo_t));
#if 0
    memcpy(intf_info->intf_name, rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.intf_name, 32);
    intf_info->is_wan=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.is_wan;
    if(intf_info->is_wan)
    {
        intf_info->wan_intf.wan_intf_conf.wan_type=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.wan_type;
        memcpy(&intf_info->wan_intf.wan_intf_conf.gmac, &rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.gmac, sizeof(rtk_mac_t));
        intf_info->wan_intf.wan_intf_conf.wan_port_idx=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
        intf_info->wan_intf.wan_intf_conf.port_binding_mask.portmask=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask;
        intf_info->wan_intf.wan_intf_conf.egress_vlan_tag_on=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on;
        intf_info->wan_intf.wan_intf_conf.egress_vlan_id=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
        intf_info->wan_intf.wan_intf_conf.vlan_based_pri=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.wan_intf_conf.vlan_based_pri;

		if(intf_info->wan_intf.wan_intf_conf.wan_type != RTK_RG_BRIDGE)
		{
			intf_info->wan_intf.static_info.ip_version=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ip_version;
			intf_info->wan_intf.static_info.napt_enable=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->napt_enable;
	        intf_info->wan_intf.static_info.ip_addr=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ip_addr;
	        intf_info->wan_intf.static_info.ip_network_mask=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ip_network_mask;
			memcpy(intf_info->wan_intf.static_info.ipv6_addr.ipv6_addr,rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
	        intf_info->wan_intf.static_info.ipv6_mask_length=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ipv6_mask_length;
			intf_info->wan_intf.static_info.ipv4_default_gateway_on=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ipv4_default_gateway_on;
	        intf_info->wan_intf.static_info.gateway_ipv4_addr=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->gateway_ipv4_addr;
			intf_info->wan_intf.static_info.ipv6_default_gateway_on=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->ipv6_default_gateway_on;
	        intf_info->wan_intf.static_info.gateway_ipv6_addr=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->gateway_ipv6_addr;
	        intf_info->wan_intf.static_info.dns_ip_addr1=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->dns_ip_addr1;
	        intf_info->wan_intf.static_info.dns_ip_addr2=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->dns_ip_addr2;
	        intf_info->wan_intf.static_info.dns_ip_addr3=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->dns_ip_addr3;
	        intf_info->wan_intf.static_info.mtu=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->mtu;
			intf_info->wan_intf.static_info.gw_mac_auto_learn_for_ipv4=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4;
			memcpy(&intf_info->wan_intf.static_info.gateway_mac_addr_for_ipv4,&rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv4,sizeof(rtk_mac_t));
			intf_info->wan_intf.static_info.gw_mac_auto_learn_for_ipv4=rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4;
			memcpy(&intf_info->wan_intf.static_info.gateway_mac_addr_for_ipv6,&rg_db.systemGlobal.interfaceInfo[valid_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv6,sizeof(rtk_mac_t));

			if(intf_info->wan_intf.wan_intf_conf.wan_type == RTK_RG_DHCP)
	        {
	            intf_info->wan_intf.dhcp_client_info.stauts=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.dhcp_client_info.stauts;
	        }
	        else if(intf_info->wan_intf.wan_intf_conf.wan_type == RTK_RG_PPPoE)
	        {
	            intf_info->wan_intf.pppoe_info.after_dial.sessionId=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.after_dial.sessionId;

	            bzero(intf_info->wan_intf.pppoe_info.before_dial.username, 4);
	            memcpy(intf_info->wan_intf.pppoe_info.before_dial.username, rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.username, 4);
	            bzero(intf_info->wan_intf.pppoe_info.before_dial.password, 4);
	            memcpy(intf_info->wan_intf.pppoe_info.before_dial.password, rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.password, 4);
	            intf_info->wan_intf.pppoe_info.before_dial.auth_type=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.auth_type;
	            intf_info->wan_intf.pppoe_info.before_dial.pppoe_proxy_enable=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.pppoe_proxy_enable;
	            intf_info->wan_intf.pppoe_info.before_dial.max_pppoe_proxy_num=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.max_pppoe_proxy_num;
	            intf_info->wan_intf.pppoe_info.before_dial.auto_reconnect=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.auto_reconnect;
	            intf_info->wan_intf.pppoe_info.before_dial.dial_on_demond=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.dial_on_demond;
	            intf_info->wan_intf.pppoe_info.before_dial.idle_timeout_secs=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.idle_timeout_secs;
	            intf_info->wan_intf.pppoe_info.before_dial.stauts=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.stauts;
	            intf_info->wan_intf.pppoe_info.before_dial.dialOnDemondCallBack=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.dialOnDemondCallBack;
	            intf_info->wan_intf.pppoe_info.before_dial.idleTimeOutCallBack=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.wan_intf.pppoe_info.before_dial.idleTimeOutCallBack;
	        }
		}
    }
    else
    {
		intf_info->lan_intf.ip_version=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->ip_version;
        memcpy(&intf_info->lan_intf.gmac, &rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->gmac, sizeof(rtk_mac_t));
        intf_info->lan_intf.ip_addr=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->ip_addr;
        intf_info->lan_intf.ip_network_mask=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->ip_network_mask;
		memcpy(intf_info->lan_intf.ipv6_addr.ipv6_addr,rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
        intf_info->lan_intf.ipv6_network_mask_length=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->ipv6_network_mask_length;
        intf_info->lan_intf.port_mask.portmask=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->port_mask.portmask;
		intf_info->lan_intf.untag_mask.portmask=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->untag_mask.portmask;
        intf_info->lan_intf.intf_vlan_id=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->intf_vlan_id;
#if 0
        intf_info->lan_intf.dhcp_server_enable=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.lan_intf.dhcp_server_enable;
        intf_info->lan_intf.lease_time=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.lan_intf.lease_time;
        intf_info->lan_intf.dhcp_start_ip_addr=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.lan_intf.dhcp_start_ip_addr;
        intf_info->lan_intf.dhcp_end_ip_addr=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.lan_intf.dhcp_end_ip_addr;
        intf_info->lan_intf.dhcp_port_binding_mask.bits[0]=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.lan_intf.dhcp_port_binding_mask.bits[0];
        intf_info->lan_intf.dhcp_extport_binding_mask.bits[0]=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.lan_intf.dhcp_extport_binding_mask.bits[0];
#endif
        intf_info->lan_intf.mtu=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->mtu;
		intf_info->lan_intf.pppoe_passThrough=rg_db.systemGlobal.interfaceInfo[valid_idx].p_lanIntfConf->pppoe_passThrough;
    }

    intf_info->ingress_packet_count=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.ingress_packet_count;
    intf_info->ingress_byte_count=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.ingress_byte_count;
    intf_info->egress_packet_count=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.egress_packet_count;
    intf_info->egress_byte_count=rg_db.systemGlobal.interfaceInfo[valid_idx].storedInfo.egress_byte_count;
#endif
    //Return the valid index
    *valid_lan_or_wan_intf_idx = valid_idx;

    return (RT_ERR_RG_OK);
}

__IRAM_FWDENG_SLOWPATH
unsigned int _rtk_rg_NAPTRemoteHash_get(unsigned int ip, unsigned int port)
{
        unsigned short hash_value=0;

        hash_value = ((ip&0xffff) ^ ((ip>>16)&0xffff) ^ (port));

        return hash_value;
}

uint8 _rtk_rg_IPv6NeighborHash(const uint8 *ifid, uint8 rtidx)
{
	/*

	nb_8bhash_idx[7:0] = pkt.dip[7:0] ^ pkt.dip[15:8] ^  pkt.dip[23:16] ^ pkt.dip[31:24] ^
				  	     pkt.dip[39:32] ^ pkt.dip[47:40] ^  pkt.dip[55:48] ^ pkt.dip[63:56] ;
	nb_hash_idx[3:0] = nb_8bhash_idx[3:0] ^ nb_8bhash_idx[7:4] ^
					{ Ipv6_rtidx[0], Ipv6_rtidx[1], Ipv6_rtidx[1:0] } ;
	*/

	uint8 pre_idx;
	uint8 rightHalf;
	uint8 leftHalf;
	uint8 rtidx_0;
	uint8 rtidx_1;
	uint8 newrtidx;
	uint8 hash_idx;

	pre_idx = ifid[7]^ifid[6]^ifid[5]^ifid[4]^ifid[3]^ifid[2]^ifid[1]^ifid[0];

	rightHalf = pre_idx&0xf;
	leftHalf = (pre_idx>>4)&0xf;

	rtidx_0 = (rtidx&0x1)<<3;
	rtidx_1 = (rtidx&0x2)<<1;
	newrtidx = rtidx_0 | rtidx_1 | rtidx;
	hash_idx = rightHalf^leftHalf^newrtidx;

	return hash_idx;
}


void txinfo_debug(struct tx_info *pTxInfo);

#if defined(CONFIG_RG_RTL9600_SERIES)
int rtk_rg_congestionCtrlQueuePkt(struct sk_buff *skb, struct tx_info* ptxInfo,int isHighQueue)
{
	int firstPortIdx=FAIL, ret;
	rtk_rg_congestionCtrlRing_t *ccr;
	uint32 tx_portmask;

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	tx_portmask = ptxInfo->opts3.bit.tx_portmask;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
	tx_portmask = ptxInfo->opts2.bit.tx_portmask;
#else
#error
#endif

	if(tx_portmask!=0)
		firstPortIdx = __ffs(tx_portmask);
	else
		firstPortIdx = FAIL;

	if(firstPortIdx==FAIL)
	{
#ifdef CONFIG_SMP
		ret = _rtk_rg_smp_send_with_txInfo(skb,ptxInfo,0);
#else
		ret = re8686_send_with_txInfo(skb,ptxInfo,0);
#endif
		// drop message will print by caller.
		if(ret==0 && rg_db.systemGlobal.fwdStatistic)
			rg_db.systemGlobal.statistic.perPortCnt_NIC_TX[rg_db.pktHdr->ingressPort]++;
		return ret;
	}

	if((rg_db.congestionCtrlQueueCounter[isHighQueue][firstPortIdx]+1)==MAX_CONGESTION_CTRL_RING_SIZE)
	{
		rg_db.congestionCtrlFullDrop[isHighQueue][firstPortIdx]++;
		TRACE("[Drop] Drop by congestion control.");
		_rtk_rg_dev_kfree_skb_any(skb);
		return 0;
	}

	ccr=&rg_db.congestionCtrlRing[isHighQueue][firstPortIdx][rg_db.congestionCtrlQueueIdx[isHighQueue][firstPortIdx]];
	memcpy(&ccr->ptxInfo,ptxInfo,sizeof(struct tx_info));
	ccr->pSkb=skb;
	ccr->ingressPort=rg_db.pktHdr->ingressPort;
	rg_db.congestionCtrlQueueCounter[isHighQueue][firstPortIdx]++;
	if(rg_db.congestionCtrlQueueCounter[isHighQueue][firstPortIdx]>rg_db.congestionCtrlMaxQueueCounter[isHighQueue][firstPortIdx])
		rg_db.congestionCtrlMaxQueueCounter[isHighQueue][firstPortIdx]=rg_db.congestionCtrlQueueCounter[isHighQueue][firstPortIdx];

	rg_db.congestionCtrlQueueIdx[isHighQueue][firstPortIdx]++;
	if(rg_db.congestionCtrlQueueIdx[isHighQueue][firstPortIdx]==MAX_CONGESTION_CTRL_RING_SIZE) rg_db.congestionCtrlQueueIdx[isHighQueue][firstPortIdx]=0;


	return 0;
}


__IRAM_FWDENG
static void _rtk_rg_congestionCtrlTimerFunc(void)
{
	uint32 bytesSended[MAX_CONGESTION_CTRL_PORTS]={0};
	uint32 sendFinished[2][MAX_CONGESTION_CTRL_PORTS]={{0},{0}};
	int i,j,k;
	int ret;
	uint32 tx_portmask;

	for(j=(rg_db.systemGlobal.congestionCtrlInboundAckToHighQueue?1:0);j>=0;j--)
	{
		int finishedPorts=0;
		while(1)
		{

			for(i=0;i<MAX_CONGESTION_CTRL_PORTS;i++)
			{
				int sendTimesPerPort=0;

				if(sendFinished[j][i]==0)
				{
					while(1)
					{
						int len;
						rtk_rg_congestionCtrlRing_t *ccr;

						if(rg_db.congestionCtrlQueueCounter[j][i]==0)
						{
							sendFinished[j][i]=1;
							finishedPorts++;
							break;
						}

						ccr=&rg_db.congestionCtrlRing[j][i][rg_db.congestionCtrlSendIdx[j][i]];
						len=ccr->pSkb->len;
						if(len<60) len=60;
						len+=24; //preamble+CRC

						if((rg_db.systemGlobal.congestionCtrlSendBytesInterval[i]+rg_db.congestionCtrlSendedRemainder[i])<(bytesSended[i]+len))
						{
							sendFinished[j][i]=1;
							if(rg_db.systemGlobal.congestionCtrlSendRemainderInNextGap)
							{
								rg_db.congestionCtrlSendedRemainder[i]=(rg_db.systemGlobal.congestionCtrlSendBytesInterval[i]+rg_db.congestionCtrlSendedRemainder[i]-bytesSended[i]);
							}
							finishedPorts++;
							break;
						}
#ifdef CONFIG_SMP
						ret=_rtk_rg_smp_send_with_txInfo(ccr->pSkb,&ccr->ptxInfo,0);
#else
						ret=re8686_send_with_txInfo(ccr->pSkb,&ccr->ptxInfo,0);
#endif
						if(ret!=0)
							TRACE("[Drop] Drop by nic tx");
						else if(rg_db.systemGlobal.fwdStatistic)
							rg_db.systemGlobal.statistic.perPortCnt_NIC_TX[ccr->ingressPort]++;

						sendTimesPerPort++;
						rg_db.congestionCtrlQueueCounter[j][i]--;
						rg_db.congestionCtrlSendIdx[j][i]++;
						if(rg_db.congestionCtrlSendIdx[j][i]==MAX_CONGESTION_CTRL_RING_SIZE) rg_db.congestionCtrlSendIdx[j][i]=0;
						bytesSended[i]+=len;

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
						tx_portmask = ccr->ptxInfo.opts3.bit.tx_portmask;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
						tx_portmask = ccr->ptxInfo.opts2.bit.tx_portmask;
#else
#error
#endif
						if((1<<i)!=tx_portmask) //send to multi-ports
						{
							for(k=i+1;k<MAX_CONGESTION_CTRL_PORTS;k++)
							{
								if((1<<k)&tx_portmask)
								{
									bytesSended[k]+=len;
								}
							}
						}

						if(sendTimesPerPort>=rg_db.systemGlobal.congestionCtrlSendTimesPerPort)
						{
							break;
						}
					}
				}

			}
			if(finishedPorts>=MAX_CONGESTION_CTRL_PORTS) break;
		}
	}

}

__IRAM_FWDENG
static irqreturn_t rtk_rg_timer_interrupt(int irq, void * dev_instance, struct pt_regs *regs)
{
	//_rtk_rg_congestionCtrlTimerSubFunc();
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)  || defined(CONFIG_RG_RTL9603CVD_SERIES)
	if(REG32(APOLLOPRO_TC6INT)&0x10000)
	{
		REG32(APOLLOPRO_TC6INT)|=0x110000; //enable interrupt & clear isr
#else
	if(REG32(BSP_TC2INT)&0x10000)
	{
		REG32(BSP_TC2INT)|=0x110000; //enable interrupt & clear isr
#endif
		tasklet_hi_schedule(&rg_db.systemGlobal.congestionCtrlTasklets);
	}
	else
	{
		return IRQ_RETVAL(IRQ_NONE);
	}

	return IRQ_RETVAL(IRQ_HANDLED);
}
#endif
//#define JUMBO_SKB_BUF_SIZE	(9216+18+2)
//#define JUBMO_SPLIT_LEN (1514)

void _rtk_rg_nic_tx(struct sk_buff *skb, struct tx_info* ptxInfo, int ring_num, rtk_rg_port_idx_t ingressPort, rtk_rg_mibUpdate_entry_t mibUpdateInfo)
{
	int ret;

	//support mib counter of interface
	_rtk_rg_updateMib(mibUpdateInfo);
	
#ifdef CONFIG_SMP
	ret = _rtk_rg_smp_send_with_txInfo(skb, ptxInfo, ring_num);
#else
	ret = re8686_send_with_txInfo(skb, ptxInfo, ring_num);
#endif
	if(ret!=0) 
		TRACE("[Drop] Drop by nic tx");
	else if(rg_db.systemGlobal.fwdStatistic)
		rg_db.systemGlobal.statistic.perPortCnt_NIC_TX[ingressPort]++;
	
	return;
}

void _rtk_rg_wifi_tx(struct sk_buff *skb, struct net_device *dev, rtk_rg_mibUpdate_entry_t mibUpdateInfo)
{
	//support mib counter of interface
	_rtk_rg_updateMib(mibUpdateInfo);
	
#if defined(CONFIG_SMP) && defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION) && defined(CONFIG_MASTER_WLAN0_ENABLE)
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
	if(dev->name[4]=='1')
#else
	if(dev->name[4]=='0')
#endif
		_rtk_rg_smp_wifi_11ac_hard_start_xmit(skb,dev);
	else
		_rtk_rg_smp_wifi_11n_hard_start_xmit(skb,dev);
#else
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30) || defined(CONFIG_OPENWRT_RG)
	dev->netdev_ops->ndo_start_xmit(skb,dev);
#else	
	dev->hard_start_xmit(skb,dev);
#endif
#endif
	return;
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t rtk_rg_sw_shaper_rate_couting(uint32 swMeterIdx, uint32 skbLen, uint8 reschedule)
{
	uint32 byteCount = skbLen + 4;		// 4 bytes CRC
	uint32 packetCount = 1;
	rtk_rg_meterConf_t *meterConf = NULL;

	if(!(0<=swMeterIdx && swMeterIdx<PURE_SW_SHAREMETER_TABLE_SIZE))
	{
		WARNING("[sw shaper] swMeterIdx[%d] is overflow, skip to do shaping", swMeterIdx);
		return RG_FWDENGINE_RET_CONTINUE;
	}
		
	if(_rtk_rg_shareMeterConf_get(swMeterIdx+PURE_SW_METER_IDX_OFFSET, &meterConf) != RT_ERR_RG_OK)
	{
		WARNING("Fail to get meter[%d] config by using _rtk_rg_shareMeterConf_get()", swMeterIdx+PURE_SW_METER_IDX_OFFSET);
		return RG_FWDENGINE_RET_CONTINUE;
	}
	TRACE("[sw shaper] meterIdx=%d rate=%d ifgInclude=%d meterMode=%d\n", swMeterIdx+PURE_SW_METER_IDX_OFFSET, meterConf->rate, meterConf->ifgInclude, meterConf->meterMode);

	if(time_after_eq(jiffies, meterConf->lastJiffies + RTK_RG_SWRATELIMIT_JIFFIES))
	{
		memset(meterConf->meterCount, 0, sizeof(rtk_rg_meterCount_t));
		meterConf->lastJiffies = jiffies;
	}
	if(time_after_eq(jiffies, meterConf->lastJiffiesPersec + CONFIG_HZ/*unit: 1sec*/))
	{
		memset(&meterConf->meterCountPersec, 0, sizeof(rtk_rg_meterCount_t));
		meterConf->lastJiffiesPersec = jiffies;
	}

	if(reschedule == FALSE){
		if(atomic_read(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].congestion) == TRUE)
			return RG_FWDENGINE_RET_DROP;
	}

	//Check if over rate limit
	if(meterConf->meterMode == METER_MODE_BIT_RATE)
	{
		/*rate limit bits in time period*/
		if(	
			((meterConf->meterCount->byteCount+byteCount) > ((meterConf->rate*((1000/8)*RTK_RG_SWRATELIMIT_JIFFIES/CONFIG_HZ)))) ||
			((meterConf->meterCountPersec.byteCount+byteCount) > (meterConf->rate*(1000/8))/*unit:1sec*/)
			)	
		{
			TRACE("[Over rate limit] the packet belongs to shareMeter[%d]", swMeterIdx+PURE_SW_METER_IDX_OFFSET);
			return RG_FWDENGINE_RET_DROP;
		}
	}
	else if(meterConf->meterMode == METER_MODE_PACKET_RATE)
	{
		/*rate limit packets in time period*/
		if(
			((meterConf->meterCount->packetCount+packetCount) > ((meterConf->rate*RTK_RG_SWRATELIMIT_JIFFIES)/CONFIG_HZ)) ||
			((meterConf->meterCountPersec.packetCount+packetCount) > meterConf->rate/*unit:1sec*/)
			)
		{
			TRACE("[Over rate limit] the packet belongs to shareMeter[%d]",	swMeterIdx+PURE_SW_METER_IDX_OFFSET);
			return RG_FWDENGINE_RET_DROP;
		}
	}
	else
	{
		WARNING("Check! meter[%d] is not in bit rate mode or packet rate mode");
		return RG_FWDENGINE_RET_CONTINUE;
	}

	meterConf->meterCount->byteCount += byteCount;
	meterConf->meterCount->packetCount += packetCount;

	meterConf->meterCountPersec.byteCount += byteCount;
	meterConf->meterCountPersec.packetCount += packetCount;
	
	TRACE("[Forward] the packet belongs to shareMeter[%d], and NOT over its rate limit. byteCount=%d packetCount=%d", swMeterIdx+PURE_SW_METER_IDX_OFFSET, meterConf->meterCount->byteCount, meterConf->meterCount->packetCount);
	return RG_FWDENGINE_RET_CONTINUE;
}

void rtk_rg_sw_shaper_kicktx_timerfunc(unsigned long sw_meter_Idx)
{
	// de-queue
	rtk_rg_fwdEngineReturn_t ret = RG_FWDENGINE_RET_CONTINUE;
	unsigned int cnt = MAX_SW_SHAPER_QUEUE_SIZE;
	rtk_rg_shaping_bucket_t *pOldestOne = NULL;
	int scheduleidx = 0;
	bool resched = FALSE;
	uint32 swMeterIdx = (uint32)sw_meter_Idx;

	rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].timerCnt++;
	
	scheduleidx = atomic_read(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].sched_idx);
	pOldestOne = &rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].queue[scheduleidx];

	if(unlikely(atomic_read(&pOldestOne->state) == SMP_WORK_STATE_FREE))
	{
		TRACE("timer func cpu[%d] process shaping sw meter %d --- empty", smp_processor_id(), swMeterIdx);
		//empty tx queue
		atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].congestion, 0); // to allow smp_call_function
		return;
	}

	do{
		ret = rtk_rg_sw_shaper_rate_couting(swMeterIdx, pOldestOne->skbLen, TRUE);
		if(ret == RG_FWDENGINE_RET_CONTINUE) 
		{
			if(pOldestOne->wifiTx)
				_rtk_rg_wifi_tx(pOldestOne->wifiTxPriv.skb, pOldestOne->wifiTxPriv.dev, pOldestOne->wifiTxPriv.mibUpdateInfo);
			else
				_rtk_rg_nic_tx(pOldestOne->nicTxPriv.skb, &pOldestOne->nicTxPriv.txInfo, pOldestOne->nicTxPriv.ring_num, pOldestOne->nicTxPriv.ingressPort, pOldestOne->nicTxPriv.mibUpdateInfo);
			
			rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].pausetxcnt++;
		}
		else 
		{
			resched = TRUE;
			break;
		}
		
		scheduleidx += 1;
		scheduleidx &= (MAX_SW_SHAPER_QUEUE_SIZE-1);
		smp_mb(); 
		
		atomic_set(&pOldestOne->state, SMP_WORK_STATE_FREE);
		atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].sched_idx, scheduleidx);
		pOldestOne = &rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].queue[scheduleidx];

		if(unlikely(atomic_read(&pOldestOne->state) == SMP_WORK_STATE_FREE)) 
		{
			pOldestOne = NULL;
		}
	}while((pOldestOne) && (--cnt>0));

	if(cnt == 0)
		resched = TRUE;

	if(resched) 
	{
		// schedule timer
		_rtk_rg_mod_timer(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].kicktxtimer, jiffies + RTK_RG_SW_SHAPER_TIMER_TICK);
	}
	else
	{
		atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].congestion, 0); // to allow smp_call_function
	}

	return;
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t rtk_rg_sw_shaper(bool wifiTx, void *pTxPriv, uint32 swMeterIdx)
{
	rtk_rg_fwdEngineReturn_t ret = RG_FWDENGINE_RET_CONTINUE;
	int freeidx = 0;
	rtk_rg_smp_nicTx_private_t *pNicTxPriv = (rtk_rg_smp_nicTx_private_t *)pTxPriv;
	rtk_rg_smp_wifiTx_private_t *pWifiTxPriv = (rtk_rg_smp_wifiTx_private_t *)pTxPriv;
	rtk_rg_shaping_bucket_t *pFirstOne=NULL;
	uint32 skbLen = (wifiTx) ? pWifiTxPriv->skb->len : pNicTxPriv->skb->len;

	if(0<=swMeterIdx && swMeterIdx<PURE_SW_SHAREMETER_TABLE_SIZE)
	{
		if(rg_db.systemGlobal.systemMeter.swMeter[swMeterIdx].rate)
			ret = rtk_rg_sw_shaper_rate_couting(swMeterIdx, skbLen, FALSE);
		else	// rate=0
		{
			TRACE("[sw shaper] rate of swMeterIdx[%d] is zero, skip to do shaper queuing", swMeterIdx);
			return RG_FWDENGINE_RET_DROP;
		}
	}
	else
	{
		TRACE("[sw shaper] swMeterIdx[%d] is overflow, skip to do shaping", swMeterIdx);
		ret = RG_FWDENGINE_RET_CONTINUE;
	}
	
	if(ret == RG_FWDENGINE_RET_CONTINUE)
	{
		TRACE("non-congestion - continue %s tx", wifiTx?"wifi":"nic");
		if(wifiTx)
			_rtk_rg_wifi_tx(pWifiTxPriv->skb, pWifiTxPriv->dev, pWifiTxPriv->mibUpdateInfo);
		else
			_rtk_rg_nic_tx(pNicTxPriv->skb, &pNicTxPriv->txInfo, pNicTxPriv->ring_num, pNicTxPriv->ingressPort, pNicTxPriv->mibUpdateInfo);
	}
	else 
	{
		// RG_FWDENGINE_RET_DROP
		/*
		 * Enqueue
		 */
		atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].congestion, 1);
		
		freeidx = atomic_read(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].free_idx);
		
		pFirstOne = &rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].queue[freeidx];

		if(unlikely(atomic_read(&pFirstOne->state) == SMP_WORK_STATE_SCHED))
		{
		
			TRACE("congestion - no free buffer (swMeterIdx %d freeidx %d)", swMeterIdx, freeidx);

			// caller will call dev_kfree_skb_any and take care of fwdStatistic counter
			ret = RG_FWDENGINE_RET_DROP;
		}
		else
		{
			//Setup information
			if(wifiTx){
				pFirstOne->wifiTx = TRUE;
				memcpy(&pFirstOne->wifiTxPriv, pTxPriv, sizeof(rtk_rg_smp_wifiTx_private_t));		
			}
			else{
				pFirstOne->wifiTx = FALSE;
				memcpy(&pFirstOne->nicTxPriv, pTxPriv, sizeof(rtk_rg_smp_nicTx_private_t));		
			}
			
			freeidx += 1;
			freeidx &= (MAX_SW_SHAPER_QUEUE_SIZE-1);
			smp_mb(); 
			
			atomic_set(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].free_idx, freeidx);
			atomic_set(&pFirstOne->state, SMP_WORK_STATE_SCHED);
			pFirstOne->skbLen = skbLen;
			rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].enququcnt++;

			TRACE("[sw shaper] Enqueue shaper[%d]", swMeterIdx);
#if defined(CONFIG_RG_DEBUG)
			if(rg_kernel.debug_level&RTK_RG_DEBUG_LEVEL_TRACE_DUMP)
			{
				int trace=1;
				if(rg_kernel.filter_level& RTK_RG_DEBUG_LEVEL_TRACE_DUMP)
				{
					trace = rg_kernel.tracefilterShow;
					//trace=_rtk_rg_trace_filter_compare(pPktHdr->skb,pPktHdr);
				}

				if(trace==1)
				{
					if(wifiTx)
						dump_packet(pFirstOne->wifiTxPriv.skb->data, pFirstOne->wifiTxPriv.skb->len, "To wifi");
					else
						dump_packet(pFirstOne->nicTxPriv.skb->data, pFirstOne->nicTxPriv.skb->len, "To nic");
				}		
			}
#endif			
			ret = RG_FWDENGINE_RET_CONTINUE;
		}

		// schedule timer
		if(!_rtk_rg_timer_pending(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].kicktxtimer))
			_rtk_rg_mod_timer(&rg_db.systemGlobal.systemMeter.shapingCtrl[swMeterIdx].kicktxtimer, jiffies + RTK_RG_SW_SHAPER_TIMER_TICK);
	}

	return ret;
}

void _rtk_rg_updateMibInfo(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb)
{
	pPktHdr->mibUpdateInfo.dstHostIdx = FAIL;
	pPktHdr->mibUpdateInfo.srcIntfIdx = FAIL;
	pPktHdr->mibUpdateInfo.dstIntfIdx = FAIL;
	
#if defined(CONFIG_RG_RTL9600_SERIES)
#elif defined(CONFIG_RG_RTL9602C_SERIES) //support mib counter of interface
	//20151027LUKE: from protocol stack(local-out) should not be counted!!
	if(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)
	{
		//20151026LUKE: count MIB for downstream skb only once.
		if(pPktHdr->mibDirect==RTK_RG_CLASSIFY_DIRECTION_DOWNSTREAM){
			pPktHdr->mibUpdateInfo.pkt_type = RTK_RG_PKT_TYPE_UC;
			pPktHdr->mibUpdateInfo.srcIntfIdx = pPktHdr->mibNetifIdx;
			pPktHdr->mibUpdateInfo.igrPktLen = pPktHdr->pRxDesc->rx_data_length; //original packet length minus CRC
		}else if(pPktHdr->mibDirect==RTK_RG_CLASSIFY_DIRECTION_UPSTREAM){
			pPktHdr->mibUpdateInfo.pkt_type = RTK_RG_PKT_TYPE_UC;
			pPktHdr->mibUpdateInfo.dstIntfIdx = pPktHdr->mibNetifIdx;
			pPktHdr->mibUpdateInfo.egrPktLen = skb->len+pPktHdr->mibTagDelta+4; // add crc
		}
	}
#else //support mib counter of interface
	if(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK
		&& (0<=pPktHdr->srcNetifIdx && pPktHdr->srcNetifIdx<MAX_NETIF_SW_TABLE_SIZE)
		&& (0<=pPktHdr->netifIdx && pPktHdr->netifIdx<MAX_NETIF_SW_TABLE_SIZE))
	{
		if(pPktHdr->pDmac[0]==0xff)
			pPktHdr->mibUpdateInfo.pkt_type = RTK_RG_PKT_TYPE_BC;
		else if(pPktHdr->pDmac[0]&0x1)
			pPktHdr->mibUpdateInfo.pkt_type = RTK_RG_PKT_TYPE_MC;
		else
			pPktHdr->mibUpdateInfo.pkt_type = RTK_RG_PKT_TYPE_UC;
		
		pPktHdr->mibUpdateInfo.srcIntfIdx = pPktHdr->srcNetifIdx;
		pPktHdr->mibUpdateInfo.dstIntfIdx = pPktHdr->netifIdx;
		pPktHdr->mibUpdateInfo.igrPktLen = (pPktHdr->pRxDesc->rx_data_length+4); // add crc
		pPktHdr->mibUpdateInfo.egrPktLen = (skb->len+pPktHdr->mibTagDelta<=RG_MIN_MRU)?(RG_MIN_MRU+4):(skb->len+pPktHdr->mibTagDelta+4); // add crc		
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support host policy
	//20160323LUKE: update TX mib count if DMAC match, padding and crc will be counted as hw.
	if(pPktHdr->dmacL2Idx!=FAIL && rg_db.lut[pPktHdr->dmacL2Idx].host_idx_valid){
		pPktHdr->mibUpdateInfo.dstHostIdx = rg_db.lut[pPktHdr->dmacL2Idx].host_idx;
		pPktHdr->mibUpdateInfo.egrHostPktLen = (skb->len+pPktHdr->mibTagDelta<=RG_MIN_MRU)?(RG_MIN_MRU+4):(skb->len+pPktHdr->mibTagDelta+4); // add crc
	}
#endif

	pPktHdr->mibUpdateInfo.egrMacPort=pPktHdr->egressMacPort;
}

void _rtk_rg_updateMib(rtk_rg_mibUpdate_entry_t mibUpdateInfo)
{
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
	switch(mibUpdateInfo.pkt_type)
	{
		case RTK_RG_PKT_TYPE_UC:
			if(0<=mibUpdateInfo.srcIntfIdx && mibUpdateInfo.srcIntfIdx<MAX_NETIF_SW_TABLE_SIZE)
			{
				rg_db.netif[mibUpdateInfo.srcIntfIdx].netifMib.in_intf_uc_packet_cnt++;
				rg_db.netif[mibUpdateInfo.srcIntfIdx].netifMib.in_intf_uc_byte_cnt += mibUpdateInfo.igrPktLen;
			}
			if(0<=mibUpdateInfo.dstIntfIdx && mibUpdateInfo.dstIntfIdx<MAX_NETIF_SW_TABLE_SIZE)
			{
				rg_db.netif[mibUpdateInfo.dstIntfIdx].netifMib.out_intf_uc_packet_cnt++;
				rg_db.netif[mibUpdateInfo.dstIntfIdx].netifMib.out_intf_uc_byte_cnt += mibUpdateInfo.egrPktLen;
			}
			break;
		case RTK_RG_PKT_TYPE_MC:
			if(0<=mibUpdateInfo.srcIntfIdx && mibUpdateInfo.srcIntfIdx<MAX_NETIF_SW_TABLE_SIZE)
			{
				rg_db.netif[mibUpdateInfo.srcIntfIdx].netifMib.in_intf_mc_packet_cnt++;
				rg_db.netif[mibUpdateInfo.srcIntfIdx].netifMib.in_intf_mc_byte_cnt += mibUpdateInfo.igrPktLen;
			}
			if(0<=mibUpdateInfo.dstIntfIdx && mibUpdateInfo.dstIntfIdx<MAX_NETIF_SW_TABLE_SIZE)
			{
				rg_db.netif[mibUpdateInfo.dstIntfIdx].netifMib.out_intf_mc_packet_cnt++;
				rg_db.netif[mibUpdateInfo.dstIntfIdx].netifMib.out_intf_mc_byte_cnt += mibUpdateInfo.egrPktLen;
			}
			break;
		case RTK_RG_PKT_TYPE_BC:
			if(0<=mibUpdateInfo.srcIntfIdx && mibUpdateInfo.srcIntfIdx<MAX_NETIF_SW_TABLE_SIZE)
			{
				rg_db.netif[mibUpdateInfo.srcIntfIdx].netifMib.in_intf_bc_packet_cnt++;
				rg_db.netif[mibUpdateInfo.srcIntfIdx].netifMib.in_intf_bc_byte_cnt += mibUpdateInfo.igrPktLen;
			}
			if(0<=mibUpdateInfo.dstIntfIdx && mibUpdateInfo.dstIntfIdx<MAX_NETIF_SW_TABLE_SIZE)
			{
				rg_db.netif[mibUpdateInfo.dstIntfIdx].netifMib.out_intf_bc_packet_cnt++;
				rg_db.netif[mibUpdateInfo.dstIntfIdx].netifMib.out_intf_bc_byte_cnt += mibUpdateInfo.egrPktLen;
			}
			break;
		default:
			break;	
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support host policy
	if(0<=mibUpdateInfo.dstHostIdx && mibUpdateInfo.dstHostIdx<HOST_POLICING_TABLE_SIZE)
	{
		rg_db.hostPoliceList[mibUpdateInfo.dstHostIdx].count.tx_count += mibUpdateInfo.egrHostPktLen;
		DEBUG("update TX host mib, dstHostIdx=%d, tx=>%llu", mibUpdateInfo.dstHostIdx, rg_db.hostPoliceList[mibUpdateInfo.dstHostIdx].count.tx_count);
	}
#endif

	//20201224LUKE: calculate packet type tx here
	if(rg_db.systemGlobal.fwdStatistic)
	{
		int mass=(mibUpdateInfo.egrPktLen>MASS_PACKET_SIZE)?0x4:0;
		rtk_rg_pkt_type_t egressPktType=(mibUpdateInfo.pkt_type)|mass;
		switch(egressPktType)
		{
			case RTK_RG_PKT_TYPE_BC:
				rg_db.systemGlobal.statistic.perPortCnt_Tx_broadcast[mibUpdateInfo.egrMacPort]++;
				break;
			case RTK_RG_PKT_TYPE_MC:
				rg_db.systemGlobal.statistic.perPortCnt_Tx_multicast[mibUpdateInfo.egrMacPort]++;
				break;
			case RTK_RG_PKT_TYPE_UC:
				rg_db.systemGlobal.statistic.perPortCnt_Tx_unicast[mibUpdateInfo.egrMacPort]++;
				break;
			case RTK_RG_PKT_TYPE_MASS_BC:
				rg_db.systemGlobal.statistic.perPortCnt_Tx_mass_broadcast[mibUpdateInfo.egrMacPort]++;
				break;
			case RTK_RG_PKT_TYPE_MASS_MC:
				rg_db.systemGlobal.statistic.perPortCnt_Tx_mass_multicast[mibUpdateInfo.egrMacPort]++;
				break;
			case RTK_RG_PKT_TYPE_MASS_UC:
				rg_db.systemGlobal.statistic.perPortCnt_Tx_mass_unicast[mibUpdateInfo.egrMacPort]++;
				break;
			default:
				break;
		}
	}

	return;
}

__IRAM_FWDENG
void _rtk_rg_send_with_txInfo(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb, struct tx_info* ptxInfo, int ring_num)
{
	uint32 tx_portmask;
#if defined(CONFIG_APOLLO_FPGA_PHY_TEST)
	struct sk_buff *new_skb=NULL;
	struct tx_info tmpTxInfo;
	memcpy(&tmpTxInfo, ptxInfo, sizeof(tmpTxInfo));
	_rtk_rg_fpgaTest_txProcess(skb, &new_skb, &tmpTxInfo, pPktHdr);
	skb = new_skb;
	ptxInfo = &tmpTxInfo;
#elif defined(CONFIG_RTL9607C_TEST_CHIP)
	struct sk_buff *new_skb=NULL;
	_rtk_rg_sw_txPadding(skb, &new_skb, pPktHdr);
	skb = new_skb;
#endif

#if defined(CONFIG_RG_G3_SERIES)
	if(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)
	{
		skb->data_len = skb->len;
		skb_reset_mac_header(skb);
		// G3 only support L4 checksum HW offload
		DEBUG("[L4 checksum HW offload] skb->network_header=%d, skb->transport_header=%d pPktHdr->l3Offset=%d, pPktHdr->l4Offset=%d", skb->network_header, skb->transport_header, pPktHdr->l3Offset, pPktHdr->l4Offset);
		skb_set_network_header(skb, pPktHdr->l3Offset);
		if(pPktHdr->tagif & TCP_TAGIF)
			skb_set_transport_header(skb, pPktHdr->l4Offset);
		else
			skb_reset_transport_header(skb);
	}
	DEBUG("[L4 checksum HW offload] skb->network_header=%d, skb->transport_header=%d", skb->network_header, skb->transport_header);
#endif


#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_APOLLO_FPGA_PHY_TEST)
	tx_portmask = ptxInfo->opts3.bit.tx_portmask;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	tx_portmask = ptxInfo->opts2.bit.tx_portmask;
#else
#error
#endif
#if defined(CONFIG_RG_DEBUG)
	if(rg_kernel.debug_level&RTK_RG_DEBUG_LEVEL_TRACE_DUMP)
	{
		int trace=1;
		if(rg_kernel.filter_level& RTK_RG_DEBUG_LEVEL_TRACE_DUMP)
		{
			trace = rg_kernel.tracefilterShow;
			//trace=_rtk_rg_trace_filter_compare(pPktHdr->skb,pPktHdr);
		}

		if(trace==1)
		{
			dump_packet(pPktHdr->skb->data,pPktHdr->skb->len,"trace_dump");
		}
	}
#endif

	//support mib counter of interface
	_rtk_rg_updateMibInfo(pPktHdr, skb);

#if defined(CONFIG_RG_RTL9600_SERIES)
	if((rg_db.systemGlobal.congestionCtrlIntervalMicroSecs!=0)&&(tx_portmask&rg_db.systemGlobal.congestionCtrlPortMask))
	{
		int isHighQueue=0;
		if((skb->len<=100)&&(rg_db.systemGlobal.congestionCtrlInboundAckToHighQueue)&&(pPktHdr->tcpFlags.ack==1))
			isHighQueue=1;
		if(rtk_rg_congestionCtrlQueuePkt(skb, ptxInfo, isHighQueue)!=0) TRACE("[Drop] Drop by nic tx");
		return;
	}
	else
#endif
	{
		if(0<=pPktHdr->swMeterOffsetIdx && pPktHdr->swMeterOffsetIdx<PURE_SW_SHAREMETER_TABLE_SIZE)
		{
			rtk_rg_smp_nicTx_private_t nicTxPriv;

			nicTxPriv.skb = skb;
			memcpy(&nicTxPriv.txInfo, ptxInfo, sizeof(struct tx_info));
			nicTxPriv.ring_num = ring_num;
			nicTxPriv.ingressPort = pPktHdr->ingressPort;
			memcpy(&nicTxPriv.mibUpdateInfo, &pPktHdr->mibUpdateInfo, sizeof(rtk_rg_mibUpdate_entry_t));
			if(rtk_rg_sw_shaper(FALSE, &nicTxPriv, pPktHdr->swMeterOffsetIdx)==RG_FWDENGINE_RET_DROP)
			{
				TRACE("[DROP] drop by sw shaper, meterIdx=%d", pPktHdr->swMeterOffsetIdx+PURE_SW_METER_IDX_OFFSET);
				if(skb) _rtk_rg_dev_kfree_skb_any(skb);
			}
		}
		else
		{
			_rtk_rg_nic_tx(skb, ptxInfo, ring_num, pPktHdr->ingressPort, pPktHdr->mibUpdateInfo);
		}
		
		return;
	}
}

void _rtk_rg_splitJumbo(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb)
{
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	//20170331LUKE: FIXME for 9607C cached address may not start from 0xa0000000.
	unsigned char *skbdata=skb->data;
#else
	unsigned char *skbdata=(unsigned char *)(((u32)skb->data)|0xa0000000);
#endif
	int remainLen=skb->len;
	uint16 l3Offset=pPktHdr->l3Offset;
	int l3HdrLen=((skbdata[l3Offset]&0xf)<<2);
	int l23Len=l3Offset+l3HdrLen;
	int offset=pPktHdr->ipv4FragmentOffset<<3;
	int eachPayloadLen;
#if defined(CONFIG_APOLLO_FPGA_PHY_TEST) || defined(CONFIG_RG_G3_SERIES)	// CONFIG_RG_G3_SERIES_DEVELOPMENT
	unsigned int ori_tx_portmask = rg_kernel.txDesc.tx_tx_portmask;
#endif
	uint8 allocJumboSkb=FALSE;

	if(remainLen>JUMBO_SKB_BUF_SIZE)
	{
		WARNING("[Drop] remainLen of jumbo frame is larger than JUMBO_SKB_BUF_SIZE(%d)", JUMBO_SKB_BUF_SIZE);
		goto send_error;
	}

	//20151030LUKE: we just don't support DS-Lite fragment now.
	if((pPktHdr->tagif&IPV4_TAGIF)==0 || (pPktHdr->egressTagif&DSLITE_TAGIF))
	{
		TRACE("[Drop] non-ipv4 and DS-Lite can't be fragment...DROP!");
		goto send_error;
	}

	if(pPktHdr->overMTU)
	{
		if(pPktHdr->netifIdx==FAIL)
		{
			WARNING("[Drop] Over mtu but pPktHdr->netifIdx==FAIL");
			goto send_error;
		}
#if defined(CONFIG_RG_RTL9600_SERIES)
		if((l3Offset+rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu)>SKB_BUF_SIZE)
		{
			eachPayloadLen=SKB_BUF_SIZE-l23Len;
		}
		else
#endif
		{
			eachPayloadLen=rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu-l3HdrLen;
		}
	}
#if defined(CONFIG_RG_RTL9600_SERIES)
	else if(skb->len>SKB_BUF_SIZE)
	{
		eachPayloadLen=SKB_BUF_SIZE-l23Len;
	}
#endif
	else
	{
		WARNING("[Drop] It's not over mtu");
		goto send_error;
	}


	eachPayloadLen=(eachPayloadLen>>3)<<3;	//align to multiple of 8, because each fragment offset is based on 8
	//DEBUG("Jumbo Frame send to NIC len=%d tagif=0x%x l23Len=%d\n",skb->len,pPktHdr->tagif,l23Len);

	allocJumboSkb = ((l23Len+eachPayloadLen)>SKB_BUF_SIZE) ? TRUE : FALSE;
#if !defined(CONFIG_RG_SUPPORT_JUMBO_FRAME) // not support Jumbo frame
	if(allocJumboSkb)
	{
		WARNING("[Drop] Can not allocate Jumbo skb.");
		goto send_error;
	}
#endif

	remainLen-=l23Len;
	rg_kernel.txDesc.tx_l4cs=0;

	while(remainLen>0)
	{
		struct sk_buff *allocSkb;
		unsigned char *new_data;
#if defined(CONFIG_RG_SUPPORT_JUMBO_FRAME)
		if(allocJumboSkb)
		{
			allocSkb = _rtk_rg_getJumboAlloc(JUMBO_SKB_BUF_SIZE);
		}
		else
#endif
		{
			allocSkb = _rtk_rg_getAlloc(SKB_BUF_SIZE);
		}
		if(allocSkb==NULL)
		{
			WARNING("[Drop] Fail to get free skb buffer");
			goto send_error;
		}
		skb_put(allocSkb, ((remainLen>=eachPayloadLen)?eachPayloadLen:remainLen)+l23Len);
		//allocSkb->len=((remainLen>=eachPayloadLen)?eachPayloadLen:remainLen)+l23Len;

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		//20170331LUKE: FIXME for 9607C cached address may not start from 0xa0000000.
		new_data=allocSkb->data;
#else
		new_data=(unsigned char *)(((u32)allocSkb->data)|0xa0000000);
#endif

		memcpy(new_data, skbdata, l23Len);
		memcpy(new_data+l23Len, skbdata+(skb->len-remainLen), allocSkb->len-l23Len);

		//ACL("Send %x len=%d remainLen=%d l23Len=%d l4sum=%04x eachPayloadLen=%d (skb->len-remainLen)=%d\n",(u32)allocSkb,allocSkb->len,remainLen,l23Len,*pPktHdr->pL4Checksum,eachPayloadLen,(skb->len-remainLen));
		//memDump(allocSkb->data+l23Len,8,"l4");
		remainLen-=eachPayloadLen;

		if(offset==0)
		{
			new_data[l3Offset+6]|=0x20; //set MF
		}
		else
		{
			new_data[l3Offset+6]=offset>>3>>8; //H_offset
			new_data[l3Offset+7]=((offset>>3)&0xff); //L_offset

			if((remainLen>0)||(pPktHdr->ipv4MoreFragment))
				new_data[l3Offset+6]|=0x20; //set MF(when org packet have already MF bit)
		}

		new_data[l3Offset+2]=(allocSkb->len-l3Offset)>>8; //IP hdr total H_length
		new_data[l3Offset+3]=(allocSkb->len-l3Offset)&0xff; //IP hdr total L_length
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
		if(pPktHdr->egressTagif&PPPOE_TAGIF){//PPPoE Hdr len
			new_data[l3Offset-4]=(allocSkb->len-l3Offset+2)>>8;
			new_data[l3Offset-3]=(allocSkb->len-l3Offset+2)&0xff;
		}
#else
		/* switch support pppoe tag offload */
#endif

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_RTL9607C_SERIES)
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20160331LUKE: checksum by sw offload
#else
		//20200910LUKE: if packet size is bigger than RE8670_MAX_ETH_FRAME_SIZE, checksum by sw offload
		if(allocSkb->len > RE8670_MAX_ETH_FRAME_SIZE)	
#endif
		{
			// L3 checksum re-calculate
			*(u16*)((u32)new_data+l3Offset+10)=0;
			*(u16*)((u32)new_data+l3Offset+10)=htons(inet_chksum(new_data+l3Offset,l3HdrLen));
		}
#endif

#if defined(CONFIG_APOLLO_FPGA_PHY_TEST) || defined(CONFIG_RG_G3_SERIES)
		// L3 checksum re-calculate
		*(u16*)(new_data+l3Offset+10)=0;
		*(u16*)(new_data+l3Offset+10)=htons(inet_chksum(new_data+l3Offset,l3HdrLen));
#if defined(CONFIG_RG_RTL9602C_SERIES)
		rg_kernel.txDesc.tx_tx_portmask = ori_tx_portmask&0x3f;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		rg_kernel.txDesc.tx_tx_portmask = ori_tx_portmask&0x3ff;
#endif
#endif
		TRACE("SPLIT VID=0x%x VID_ACT=%d L34KEEP=%d PMSK=0x%x KEEP=%d frag_off=%d"
			,rg_kernel.txDesc.tx_cvlan_vidh<<8|rg_kernel.txDesc.tx_cvlan_vidl
			,rg_kernel.txDesc.tx_tx_cvlan_action
			,rg_kernel.txDesc.tx_l34_keep
			,rg_kernel.txDesc.tx_tx_portmask
			,rg_kernel.txDesc.tx_keep
			,offset);

		offset+=eachPayloadLen;

		_rtk_rg_send_with_txInfo(pPktHdr,allocSkb,(struct tx_info*)&rg_kernel.txDesc,0);

	}
//free skb if packet is dropped.
send_error:
	if(skb) _rtk_rg_dev_kfree_skb_any(skb);
	return;
}

__IRAM_FWDENG
void _rtk_rg_splitJumboSendToNicWithTxInfo(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, struct tx_info* ptxInfo, int ring_num)
{
	if(skb->len<=1522 && (!pPktHdr->overMTU))
	{
		_rtk_rg_send_with_txInfo(pPktHdr,skb,ptxInfo,ring_num);
	}
	else	//skb->len > 1522 || pPktHdr->overMTU == 1
	{
#if !defined(CONFIG_RG_SUPPORT_JUMBO_FRAME) // not support Jumbo frame
		if(pPktHdr->overMTU)
		{
			if(pPktHdr->netifIdx>=0 && ((pPktHdr->l3Offset+rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu)>SKB_BUF_SIZE))
			{
				WARNING("[Drop] Packet's size(mtu) is larger than SKB_BUF_SIZE(%d), drop.", SKB_BUF_SIZE);
				goto send_error;
			}
		}
		else if(skb->len>SKB_BUF_SIZE)
		{
			WARNING("[Drop] Packet's size is larger than SKB_BUF_SIZE(%d), drop.", SKB_BUF_SIZE);
			goto send_error;
		}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
		if(pPktHdr->overMTU || skb->len>SKB_BUF_SIZE)
#else
		if(pPktHdr->overMTU)
#endif
		{
			_rtk_rg_splitJumbo(pPktHdr, skb);
		}
		else
		{
			_rtk_rg_send_with_txInfo(pPktHdr,skb,ptxInfo,ring_num);
		}
	}

	//record number of forwarded packets, it is used to check MC/BC drop
	++pPktHdr->forwardCount;

	return;

#if !defined(CONFIG_RG_SUPPORT_JUMBO_FRAME) // not support Jumbo frame
//free skb if packet is dropped.
send_error:
	if(skb) _rtk_rg_dev_kfree_skb_any(skb);
	return;
#endif
}

void _rtk_rg_psRxMirrorToPort0(struct sk_buff *skb, struct net_device *dev)
{
	char eth0Name[16]="eth0";
#if defined(CONFIG_RG_G3_SERIES)
	char eth1Name[16]="eth1";
#endif
	struct sk_buff *new_skb;
	new_skb=_rtk_rg_getAlloc(RG_FWDENGINE_PKT_LEN);
	DEBUG("Rx Mirror to Port0, original dev is %s", dev->name);

	if(new_skb!=NULL)
	{
		memcpy(new_skb->data,"\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x01\x88\x88",14);
		if(!memcmp(dev->name, eth0Name, 4)
#if defined(CONFIG_RG_G3_SERIES)
			|| !memcmp(dev->name, eth1Name, 4)
#endif
			)
		{
			DEBUG("Rx Mirror to Port0, dev is %s", eth0Name);
			memcpy(new_skb->data+14,eth0Name,16);
		}
		else
		{
			DEBUG("Rx Mirror to Port0, dev is %s", dev->name);
			memcpy(new_skb->data+14,dev->name,16);
		}
		memcpy(new_skb->data+30,skb->data,skb->len);
		new_skb->len=skb->len+30;

		//clear old value
		rg_kernel.txDesc.opts1.dw=0;
		rg_kernel.txDesc.opts2.dw=0;
		rg_kernel.txDesc.opts3.dw=0;
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		rg_kernel.txDesc.opts4.dw=0;
#endif

		//turn on txInfo mask, otherwise value won't be add
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		rg_kernel.txDesc.tx_cputag_ipcs=0;
		rg_kernel.txDesc.tx_cputag_l4cs=0;
#endif
		rg_kernel.txDesc.tx_ipcs=0;
		rg_kernel.txDesc.tx_l4cs=0;
		rg_kernel.txDesc.tx_dislrn=1;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		rg_kernel.txDesc.tx_keep=0; 			//dirtx case: keep must be zero.
#else
		rg_kernel.txDesc.tx_keep=1; 			//20141104LUKE: when L34Keep is on, Keep is also needed for gpon.
#endif

		rg_kernel.txDesc.tx_l34_keep=1;

		if(rg_db.systemGlobal.phyPortStatus&(0x1<<RTK_RG_PORT0))
			rg_kernel.txDesc.tx_tx_portmask=0x1;
		else
			rg_kernel.txDesc.tx_tx_portmask=0x4;

#if defined(CONFIG_RG_G3_SERIES)
		rg_db.pktHdr->l3Offset += 30;
		rg_db.pktHdr->l4Offset += 30;
#endif
		_rtk_rg_send_with_txInfo(rg_db.pktHdr,new_skb,(struct tx_info*)&rg_kernel.txDesc,0);
#if defined(CONFIG_RG_G3_SERIES)
		rg_db.pktHdr->l3Offset -= 30;
		rg_db.pktHdr->l4Offset -= 30;
#endif

	}
	else
	{
		TRACE("skb alloc failed, skip mirror!");
	}
	return;


}


#ifdef CONFIG_MASTER_WLAN0_ENABLE
void _rtk_rg_wifiTxRedirect(struct sk_buff *skb,struct net_device *netdev)
{
	struct sk_buff *new_skb;
	new_skb=_rtk_rg_getAlloc(skb->len+30);

	DEBUG("Wifi Tx redirect to Port0, dev is %s, cb[0]=%d", netdev->name, skb->cb[0]);
	if(new_skb!=NULL)
	{
		memcpy(new_skb->data,"\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x01\x88\x88",14);
		memcpy(new_skb->data+14,netdev->name,16);
		memcpy(new_skb->data+30,skb->data,skb->len);
		new_skb->len=skb->len+30;

		_rtk_rg_dev_kfree_skb_any(skb);

		//clear old value
		rg_kernel.txDesc.opts1.dw=0;
		rg_kernel.txDesc.opts2.dw=0;
		rg_kernel.txDesc.opts3.dw=0;
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		rg_kernel.txDesc.opts4.dw=0;
#endif

		//turn on txInfo mask, otherwise value won't be add
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		rg_kernel.txDesc.tx_cputag_ipcs=0;
		rg_kernel.txDesc.tx_cputag_l4cs=0;
#endif
		rg_kernel.txDesc.tx_ipcs=0;
		rg_kernel.txDesc.tx_l4cs=0;
		rg_kernel.txDesc.tx_dislrn=1;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		rg_kernel.txDesc.tx_keep=0; 			//dirtx case: keep must be zero.
#else
		rg_kernel.txDesc.tx_keep=1; 			//20141104LUKE: when L34Keep is on, Keep is also needed for gpon.
#endif

		rg_kernel.txDesc.tx_l34_keep=1;
		rg_kernel.txDesc.tx_tx_portmask=0x1;

#if defined(CONFIG_RG_RTL9600_SERIES)
		if((rg_db.systemGlobal.congestionCtrlIntervalMicroSecs!=0)&&(rg_kernel.txDesc.tx_tx_portmask&rg_db.systemGlobal.congestionCtrlPortMask))
		{
		}
		else
#endif
		{
			if(rg_db.systemGlobal.fwdStatistic)
			{
				rg_db.systemGlobal.statistic.perPortCnt_NIC_TX[rg_db.pktHdr->ingressPort]--; //already count in wifi_tx.
			}
		}
#if defined(CONFIG_RG_G3_SERIES)
		rg_db.pktHdr->l3Offset += 30;
		rg_db.pktHdr->l4Offset += 30;
#endif
		_rtk_rg_send_with_txInfo(rg_db.pktHdr,new_skb,(struct tx_info*)&rg_kernel.txDesc,0);
#if defined(CONFIG_RG_G3_SERIES)
		rg_db.pktHdr->l3Offset -= 30;
		rg_db.pktHdr->l4Offset -= 30;
#endif

	}
	else
	{
		TRACE("new skb alloc failed!");
	}

}

void inline _rtk_rg_wifiTxDecision(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, struct net_device *dev)
{
	if(rg_db.systemGlobal.fwdStatistic)
	{
		rg_db.systemGlobal.statistic.perPortCnt_WIFI_TX[pPktHdr->ingressPort]++;
	}

	//20210312LUKE: check wmm mapping with pPktHdr->internalPriority
	if(rg_db.systemGlobal.wifi_tx_qos_mapping[pPktHdr->internalPriority]!=RTK_WIFI_TX_QUEUE_VALUE_DISABLED)
		skb->cb[0] = rg_db.systemGlobal.wifi_tx_qos_mapping[pPktHdr->internalPriority];

	if(rg_db.systemGlobal.wifiTxRedirect==1)
	{
		_rtk_rg_wifiTxRedirect(skb,dev);
	}
	else
	{
		//support mib counter of interface
		_rtk_rg_updateMibInfo(pPktHdr, skb);
		if(0<=pPktHdr->swMeterOffsetIdx && pPktHdr->swMeterOffsetIdx<PURE_SW_SHAREMETER_TABLE_SIZE)
		{
			rtk_rg_smp_wifiTx_private_t wifiTxPriv;

			wifiTxPriv.skb = skb;
			wifiTxPriv.dev = dev;
			memcpy(&wifiTxPriv.mibUpdateInfo, &pPktHdr->mibUpdateInfo, sizeof(rtk_rg_mibUpdate_entry_t));
			if(rtk_rg_sw_shaper(TRUE, &wifiTxPriv, pPktHdr->swMeterOffsetIdx)==RG_FWDENGINE_RET_DROP)
			{
				TRACE("[DROP] drop by sw shaper, meterIdx=%d", pPktHdr->swMeterOffsetIdx+PURE_SW_METER_IDX_OFFSET);
				if(skb) _rtk_rg_dev_kfree_skb_any(skb);
			}
		}
		else
		{
			_rtk_rg_wifi_tx(skb, dev, pPktHdr->mibUpdateInfo);
		}
	}
	if(rg_kernel.debug_level&RTK_RG_DEBUG_LEVEL_TRACE_DUMP)
	{
		int trace=1;
		if(rg_kernel.filter_level& RTK_RG_DEBUG_LEVEL_TRACE_DUMP)
		{
			trace = rg_kernel.tracefilterShow;
			//trace=_rtk_rg_trace_filter_compare(pPktHdr->skb,pPktHdr);
		}

		if(trace==1)
		{
			dump_packet(skb->data,skb->len,"trace_dump");
		}
	}
}

rtk_rg_fwdEngineReturn_t _rtk_rg_splitJumboSendToMasterWifi_afterLimit(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, struct net_device *dev)
{
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	//20170331LUKE: FIXME for 9607C cached address may not start from 0xa0000000.
	unsigned char *skbdata=skb->data;
#else
	unsigned char *skbdata=(unsigned char *)(((u32)skb->data)|0xa0000000);
#endif

	if(pPktHdr->ingressLocation == RG_IGR_MC_DATA_BUF)
	{
		//stop send to wifi
		if(skb)
		{
			IGMP("RG_IGR_MC_DATA_BUF Packet Stop to Send!!");
			_rtk_rg_dev_kfree_skb_any(skb);
			skb=NULL;
		}
		return RG_FWDENGINE_RET_SEND_TO_WIFI;
	}

	if(skb->len<=1522 && (!pPktHdr->overMTU))
	{
		_rtk_rg_wifiTxDecision(pPktHdr, skb, dev);
		return RG_FWDENGINE_RET_SEND_TO_WIFI;
	}
	else	//skb->len > 1522 || pPktHdr->overMTU == 1
	{
#if !defined(CONFIG_RG_SUPPORT_JUMBO_FRAME) // not support Jumbo frame
		if(pPktHdr->overMTU)
		{
			if(pPktHdr->netifIdx>=0 && ((pPktHdr->l3Offset+rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu)>SKB_BUF_SIZE))
			{
				WARNING("[Drop] Packet's size(mtu) is larger than SKB_BUF_SIZE(%d), drop.", SKB_BUF_SIZE);
				goto send_error;
			}
		}
		else if(skb->len>SKB_BUF_SIZE)
		{
			WARNING("[Drop] Packet's size is larger than SKB_BUF_SIZE(%d), drop.", SKB_BUF_SIZE);
			goto send_error;
		}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
		if(pPktHdr->overMTU || skb->len>SKB_BUF_SIZE)
#else
		if(pPktHdr->overMTU)
#endif
		{
			int remainLen=skb->len;
			uint16 l3Offset=pPktHdr->l3Offset;
			int l3HdrLen=((skbdata[l3Offset]&0xf)<<2);
			int l23Len=l3Offset+l3HdrLen;
			int offset=pPktHdr->ipv4FragmentOffset<<3;
			int eachPayloadLen;
			uint8 allocJumboSkb=FALSE;

			if(remainLen>JUMBO_SKB_BUF_SIZE)
			{
				WARNING("[Drop] remainLen of jumbo frame is larger than JUMBO_SKB_BUF_SIZE(%d)", JUMBO_SKB_BUF_SIZE);
				goto send_error;
			}

			//20151030LUKE: we just don't support DS-Lite fragment now.
			if((pPktHdr->tagif&IPV4_TAGIF)==0 || (pPktHdr->egressTagif&DSLITE_TAGIF))
			{
				TRACE("[Drop] non-ipv4 and DS-Lite can't be fragment...DROP!");
				goto send_error;
			}

			if(pPktHdr->overMTU)
			{
				if(pPktHdr->netifIdx==FAIL)
				{
					WARNING("[Drop] Over mtu but pPktHdr->netifIdx==FAIL");
					goto send_error;
				}
#if defined(CONFIG_RG_RTL9600_SERIES)
				if((l3Offset+rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu)>SKB_BUF_SIZE)
				{
					eachPayloadLen=SKB_BUF_SIZE-l23Len;
				}
				else
#endif
				{
					eachPayloadLen=rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu-l3HdrLen;
				}
			}
#if defined(CONFIG_RG_RTL9600_SERIES)
			else if(skb->len>SKB_BUF_SIZE)
			{
				eachPayloadLen=SKB_BUF_SIZE-l23Len;
			}
#endif
			else
			{
				WARNING("[Drop] It's not over mtu");
				goto send_error;
			}

			eachPayloadLen=(eachPayloadLen>>3)<<3;	//align to multiple of 8, because each fragment offset is based on 8
			//printk("Jumbo Frame send to NIC len=%d tagif=0x%x l23Len=%d\n",skb->len,pPktHdr->tagif,l23Len);

			allocJumboSkb = ((l23Len+eachPayloadLen)>SKB_BUF_SIZE) ? TRUE : FALSE;
#if !defined(CONFIG_RG_SUPPORT_JUMBO_FRAME) // not support Jumbo frame
			if(allocJumboSkb)
			{
				WARNING("[Drop] Can not allocate Jumbo skb.");
				goto send_error;
			}
#endif

			remainLen-=l23Len;

			while(remainLen>0)
			{
				struct sk_buff *allocSkb;
				unsigned char *new_data;
#if defined(CONFIG_RG_SUPPORT_JUMBO_FRAME)
				if(allocJumboSkb)
				{
					allocSkb = _rtk_rg_getJumboAlloc(JUMBO_SKB_BUF_SIZE);
				}
				else
#endif
				{
					allocSkb = _rtk_rg_getAlloc(SKB_BUF_SIZE);
				}
				if(allocSkb==NULL)
				{
					WARNING("[Drop] Fail to get free skb buffer");
					goto send_error;
				}
				skb_put(allocSkb, ((remainLen>=eachPayloadLen)?eachPayloadLen:remainLen)+l23Len);
				//allocSkb->len=((remainLen>=eachPayloadLen)?eachPayloadLen:remainLen)+l23Len;

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
				//20170331LUKE: FIXME for 9607C cached address may not start from 0xa0000000.
				new_data=allocSkb->data;
#else
				new_data=(unsigned char *)(((u32)allocSkb->data)|0xa0000000);
#endif
				memcpy(new_data, skbdata, l23Len);
				memcpy(new_data+l23Len, skbdata+(skb->len-remainLen), allocSkb->len-l23Len);

				//printk("Send %x len=%d remainLen=%d l23Len=%d l4sum=%04x\n",(u32)allocSkb,allocSkb->len,remainLen,l23Len,*pPktHdr->pL4Checksum);
				//memDump(new_data+l23Len,8,"l4_start");
				//memDump(new_data+allocSkb->len-8,8,"l4_end");

				remainLen-=eachPayloadLen;
				if(eachPayloadLen<=0)
					printk("looping....r=%d e=%d\n",remainLen,eachPayloadLen);

				if(offset==0)
				{
					new_data[l3Offset+6]|=0x20; //set MF
				}
				else
				{
					new_data[l3Offset+6]=offset>>3>>8; //H_offset
					new_data[l3Offset+7]=((offset>>3)&0xff); //L_offset

					if((remainLen>0)||(pPktHdr->ipv4MoreFragment))
						new_data[l3Offset+6]|=0x20; //set MF(when org packet have already MF bit)
				}

				new_data[l3Offset+2]=(allocSkb->len-l3Offset)>>8; //IP hdr total H_length
				new_data[l3Offset+3]=(allocSkb->len-l3Offset)&0xff; //IP hdr total L_length

				if(pPktHdr->egressTagif&PPPOE_TAGIF){//PPPoE Hdr len
					new_data[l3Offset-4]=(allocSkb->len-l3Offset+2)>>8;
					new_data[l3Offset-3]=(allocSkb->len-l3Offset+2)&0xff;
				}

				// L3 checksum re-calculate
				*(u16*)(new_data+l3Offset+10)=0;
				*(u16*)(new_data+l3Offset+10)=htons(inet_chksum(new_data+l3Offset,l3HdrLen));


				TRACE("SPLIT frag_off=%d",offset);

				offset+=eachPayloadLen;

				_rtk_rg_wifiTxDecision(pPktHdr, allocSkb, dev);
			}
			if(skb) _rtk_rg_dev_kfree_skb_any(skb);

		}
		else
		{
			TRACE("Forward jumbo bridge packet directly, length=%d.", skb->len);
			_rtk_rg_wifiTxDecision(pPktHdr, skb, dev);
			return RG_FWDENGINE_RET_SEND_TO_WIFI;
		}
	}
	return RG_FWDENGINE_RET_SEND_TO_WIFI;

//free skb if packet is dropped.
send_error:
	if(skb) _rtk_rg_dev_kfree_skb_any(skb);
	return RG_FWDENGINE_RET_ERROR;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_splitJumboSendToMasterWifi(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, struct net_device *dev)
{
	rtk_rg_fwdEngineReturn_t ret;

#if defined(CONFIG_RG_IPSET_VERSION) && (CONFIG_RG_IPSET_VERSION==2)
	if(pPktHdr->ipsetsPriority != IPSETS_TARGET_LEVEL_DEF){
		if(pPktHdr->ipsetsEgrWlanDevIdx == pPktHdr->egressWlanDevIdx){
			TRACE("[IPSETS] Update internal priority as %d for wlan dev idx %d.", pPktHdr->ipsetsPriority, pPktHdr->ipsetsEgrWlanDevIdx);
			pPktHdr->internalPriority = pPktHdr->ipsetsPriority;
		}else{
			pPktHdr->ipsetsPriority = IPSETS_TARGET_LEVEL_DEF;
			DEBUG("[IPSETS] keep internal priority[%d] due to wlan dev idx %d unmatch %d.", pPktHdr->internalPriority, pPktHdr->egressWlanDevIdx, pPktHdr->ipsetsEgrWlanDevIdx);
		}
	}
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
{
	rtk_rg_port_idx_t portIdx=RTK_RG_EXT_PORT0;
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
	if(pPktHdr->egressWlanDevIdx>=0 )
		_rtk_rg_wlanDevToPort_translator(pPktHdr->egressWlanDevIdx,&portIdx);
	else
	{
		WARNING("Error egressWlanDevIdx=%d ",pPktHdr->egressWlanDevIdx);
		goto OVERLIMIT_DROP;
	}
#else
	portIdx=RTK_RG_EXT_PORT0;
#endif

	if(_modifyPacketByMulticastDecision(skb,pPktHdr,1<<portIdx)==RT_ERR_RG_FAILED)
		goto OVERLIMIT_DROP;
	//if hwforward to cpu we should not modify packet
	if(pPktHdr->pRxDesc->rx_reason==RG_CPU_REASON_NORMAL_FWD )
		goto SEND_DIRECT;
}
#endif

	//20141002LUKE: remove outter IP header, GRE header, PPP header
	//20141017LUKE: remove outter IP header, UDP header, L2TP header, PPP header
	//20150206LUKE: remove outter IPv6 header
	if(pPktHdr->tagif&PPTP_INNER_TAGIF||pPktHdr->tagif&L2TP_INNER_TAGIF||pPktHdr->tagif&DSLITE_INNER_TAGIF||pPktHdr->tagif&VXLAN_TAGIF){
		TRACE("Remove Tunnel tag");
		_rtk_rg_removeTunnelTag(pPktHdr);
	}

	//if hw switch support pppoe tag offload, sw wifi path must add/remove pppoe tag
	_rtk_rg_txPPPoEUpdate(skb, pPktHdr);


	//Ctag/Stag translate in pktbuff
	_rtk_rg_TranslateVlanSvlan2Packet(skb,pPktHdr,1);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
SEND_DIRECT:
#endif

	//20151210LUKE: wifi egress rate limie check here
	if( ((0 <= pPktHdr->egressWlanDevIdx) &&  (pPktHdr->egressWlanDevIdx<MAX_WLAN_DEVICE_NUM)) && rg_db.systemGlobal.wifiEgressRateLimitMeter[pPktHdr->egressWlanDevIdx]){
		if(rg_db.systemGlobal.wifiEgressRateLimitDevOverMask&(0x1<<pPktHdr->egressWlanDevIdx))goto OVERLIMIT_DROP;
		rg_db.systemGlobal.wifiEgressByteCount[pPktHdr->egressWlanDevIdx] += skb->len;
		if(rg_db.systemGlobal.wifiEgressByteCount[pPktHdr->egressWlanDevIdx]/*flow bytes in time period*/ > (rg_db.systemGlobal.wifiEgressRateLimitMeter[pPktHdr->egressWlanDevIdx]<<7/*Bps*/)/*rate limit bytes in time period*/){
			rg_db.systemGlobal.wifiEgressRateLimitDevOverMask|=(0x1<<pPktHdr->egressWlanDevIdx);
			goto OVERLIMIT_DROP;
		}
	}

	if(_rtk_rg_checkEgressWifiCopyToPS(pPktHdr->skb, (struct rx_info *)pPktHdr->pRxDesc, &pPktHdr->pWifiEgressCopyWork, pPktHdr->egressWlanDevIdx)==RG_RET_SUCCESS)
		pPktHdr->wifiEgressPacketCopied=1;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_RG_RTL9600_SERIES)
	if(pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_MIRROR_UDP_ENCAP_ACT_DONE_BIT) //copy egress packet to send, and mirror the packet to PS with IP/UDP encapsulation.
		_rtk_rg_aclUDPencapMirror(skb, pPktHdr);
#endif

	//Send it out!!
	ret = _rtk_rg_splitJumboSendToMasterWifi_afterLimit(pPktHdr, skb, dev);
	//record number of forwarded packets, it is used to check MC/BC drop
	if(ret==RG_FWDENGINE_RET_SEND_TO_WIFI) ++pPktHdr->forwardCount;
	return ret;

OVERLIMIT_DROP:
	TRACE("[Drop] Wlan[%d] egress packet rate higher than %d kbps.",pPktHdr->egressWlanDevIdx,rg_db.systemGlobal.wifiEgressRateLimitMeter[pPktHdr->egressWlanDevIdx]);
	if(skb) _rtk_rg_dev_kfree_skb_any(skb);
	return RG_FWDENGINE_RET_RATE_LIMIT_DROP;
}
#endif

int _rtk_rg_qosDscpRemarking(rtk_rg_mac_port_idx_t egressPort,rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb){
	int dscp_off;
	dscp_off = (pPktHdr->pTos)-(skb->data);
	if(rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[egressPort]){
		TRACE("QoS dscp Remarking by port[%d]:%s",egressPort,rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[egressPort]?"ENABLED":"DISABLED");
		if(rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[egressPort]==ENABLED_DSCP_REMARK_AND_SRC_FROM_INTERNALPRI){
			_rtk_rg_dscpRemarkToSkb(ENABLED_DSCP_REMARK_AND_SRC_FROM_INTERNALPRI,pPktHdr,skb,dscp_off);
		}else if(rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[egressPort]==ENABLED_DSCP_REMARK_AND_SRC_FROM_DSCP){
			_rtk_rg_dscpRemarkToSkb(ENABLED_DSCP_REMARK_AND_SRC_FROM_DSCP,pPktHdr,skb,dscp_off);
		}
	}

	return (RT_ERR_RG_OK);
}

#if defined(CONFIG_RG_8021X_MAC_TABLE_SIZE) && (CONFIG_RG_8021X_MAC_TABLE_SIZE!=0)
__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_accessDot1xFilter(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_fwdEngineReturn_t ret = RG_FWDENGINE_RET_CONTINUE;

	if(rg_db.systemGlobal.accessDot1xCfg.blockingPortmask.portmask &&
		(rg_kernel.txDesc.tx_tx_portmask & rg_db.systemGlobal.accessDot1xCfg.blockingPortmask.portmask))
	{
		if(pPktHdr->etherType == RG_DOT1X_EAPOL_ETHERTYPE)
			return (RG_FWDENGINE_RET_CONTINUE);

		ret=_rtk_rg_dropByAccessDot1x_Check(skb,pPktHdr);
		if(ret == RG_FWDENGINE_RET_DROP){
			if(skb) _rtk_rg_dev_kfree_skb_any(skb);
			return (RG_FWDENGINE_RET_DIRECT_TX);
		}
	}

	return (RG_FWDENGINE_RET_CONTINUE);
}
#endif

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_portIsolationFilter(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	rg_kernel.txDesc.tx_tx_portmask&=rg_db.systemGlobal.portIsolation[pPktHdr->ingressPort].portmask;

	if(rg_kernel.txDesc.tx_tx_portmask)
		return (RG_FWDENGINE_RET_CONTINUE);

	TRACE("[Drop] drop by port isolation filter.");
	if(skb) _rtk_rg_dev_kfree_skb_any(skb);
	return (RG_FWDENGINE_RET_DIRECT_TX);
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_portSourceFilter(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	if(pPktHdr->ingressPort<=RTK_RG_PORT_LASTCPU)
	{
		rg_kernel.txDesc.tx_tx_portmask &= ~(0x1<<pPktHdr->ingressPort);
	}

	if(rg_kernel.txDesc.tx_tx_portmask)
	{
		return (RG_FWDENGINE_RET_CONTINUE);
	}
	else
	{
		TRACE("[Drop] drop by src filter.");
		if(skb) _rtk_rg_dev_kfree_skb_any(skb);
		return (RG_FWDENGINE_RET_DIRECT_TX);
	}
}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_ipVersionFilter(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	uint8 drop=0;

	if(pPktHdr->fwdDecision==RG_FWD_DECISION_INITIAL
		|| pPktHdr->fwdDecision==RG_FWD_DECISION_NORMAL_BC
		|| pPktHdr->fwdDecision==RG_FWD_DECISION_NO_PS_BC
		|| pPktHdr->fwdDecision==RG_FWD_DECISION_TO_PS
		|| pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK)
		return (RG_FWDENGINE_RET_CONTINUE);

	if(pPktHdr->srcNetifIdx>=0 && pPktHdr->srcNetifIdx<MAX_NETIF_SW_TABLE_SIZE)
	{
		if(((pPktHdr->tagif&IPV4_TAGIF) && (rg_db.netif[pPktHdr->srcNetifIdx].rtk_netif.deny_ipv4))
			|| ((pPktHdr->tagif&IPV6_TAGIF) && (rg_db.netif[pPktHdr->srcNetifIdx].rtk_netif.deny_ipv6)))
		{
			TRACE("[Drop] drop by ingress Intf[%d]'s %s deny.", pPktHdr->srcNetifIdx, (pPktHdr->tagif&IPV4_TAGIF)?"IPv4":"IPv6");
			drop=1;
		}
	}
	if(pPktHdr->netifIdx>=0 && pPktHdr->netifIdx<MAX_NETIF_SW_TABLE_SIZE)
	{
		if(((pPktHdr->tagif&IPV4_TAGIF) && (rg_db.netif[pPktHdr->netifIdx].rtk_netif.deny_ipv4))
			|| ((pPktHdr->tagif&IPV6_TAGIF) && (rg_db.netif[pPktHdr->netifIdx].rtk_netif.deny_ipv6)))
		{
			TRACE("[Drop] drop by egress Intf[%d]'s %s deny.", pPktHdr->netifIdx, (pPktHdr->tagif&IPV4_TAGIF)?"IPv4":"IPv6");
			drop=1;
		}
	}

	if(drop==0)
	{
		return (RG_FWDENGINE_RET_CONTINUE);
	}
	else
	{
		TRACE("[Drop] drop by IP version filter.");
		if(skb) _rtk_rg_dev_kfree_skb_any(skb);
		return (RG_FWDENGINE_RET_DIRECT_TX);
	}
}
#endif


__IRAM_FWDENG
void _rtk_rg_egressPacketSend(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	uint32 sw_forceTxPriEn=0;
#if defined(CONFIG_RG_RTL9600_SERIES)
	uint32 pon_is_cfport, rgmii_is_cfport;
	pon_is_cfport = rg_db.systemGlobal.pon_is_cfport;
	rgmii_is_cfport = rg_db.systemGlobal.rgmii_is_cfport;
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(rg_kernel.txDesc.tx_l34_keep && rg_kernel.txDesc.tx_tx_portmask==0x0)
	{
		_rtk_rg_dump_stack();
		dump_packet(skb->data,skb->len,"DirTx(l34_keep)=1, but tx_portmask=0x0");
		WARNING("[Tx desc] DirTx(l34_keep)=1, but tx_portmask=0x0");
	}

#endif

	if(rg_kernel.txDesc.tx_tx_portmask)	//directTx
	{
#if defined(CONFIG_RG_8021X_MAC_TABLE_SIZE) && (CONFIG_RG_8021X_MAC_TABLE_SIZE!=0)
		//802.1x Access Control Protocol
		if(_rtk_rg_accessDot1xFilter(skb, pPktHdr)==RG_FWDENGINE_RET_DIRECT_TX)
			return;
#endif
		//Port isolation
		if(_rtk_rg_portIsolationFilter(skb, pPktHdr)==RG_FWDENGINE_RET_DIRECT_TX)
			return;
		//src filter
		if(_rtk_rg_portSourceFilter(skb, pPktHdr)==RG_FWDENGINE_RET_DIRECT_TX)
			return;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//IP version filter
		if(_rtk_rg_ipVersionFilter(skb, pPktHdr)==RG_FWDENGINE_RET_DIRECT_TX)
			return;
#endif
	}
	if(pPktHdr->naptOutboundIndx >0 && rg_db.naptOut[pPktHdr->naptOutboundIndx].urlPriEn)
	{
		sw_forceTxPriEn=1;
		TRACE("Force Assign Tx Pri %d->%d  by url Priority",pPktHdr->internalPriority,rg_db.systemGlobal.urlHiPri_table_entry[rg_db.naptOut[pPktHdr->naptOutboundIndx].urlPriIdx].urlHighPriEt.urlpri);
		pPktHdr->internalPriority =  rg_db.systemGlobal.urlHiPri_table_entry[rg_db.naptOut[pPktHdr->naptOutboundIndx].urlPriIdx].urlHighPriEt.urlpri;
	}

	//20140528LUKE:for ipv4, we recaculate Layer4 checksum if napt; for ipv6, we just keep the original value
	//20140902LUKE: for packet from shortcut won't be fragmented, so let hw do layer4 checksum.
	//20141203LUKE: for fagment packet, we shoud disable hw L4 checksum offload.
	//20141211LUKE: for IPv6 statful fragment, shortcutStatus will be RG_SC_MATCH, so we can just check packet itself.
	//20161207LUKE: for apollo or apolloFE, GMAC won't recalculate checksum when receive IPv6 packet with fragment extension header.
	if(
#if defined(CONFIG_RG_RTL9600_SERIES)
	//20160331LUKE: checksum by sw offload
	(pPktHdr->egressTagif&PPPOE_TAGIF
#if defined(CONFIG_GPON_FEATURE)
		&&(rg_db.systemGlobal.gpon_pppoe_status!=GPON_PPPOE_MODE_SW_OFFLOAD)
#endif
	)||
#endif
	(pPktHdr->egressTagif&(PPTP_TAGIF|DSLITE_TAGIF|VXLAN_TAGIF))||(pPktHdr->tagif&V6FRAG_TAGIF)||(pPktHdr->ipv6FragPacket)||(pPktHdr->ipv4FragPacket))
		rg_kernel.txDesc.tx_l4cs=0;
	else
		rg_kernel.txDesc.tx_l4cs=1;



	if((pPktHdr->tagif&UDP_TAGIF)&&(ntohs(*pPktHdr->pL4Checksum)==0))
	{
		TRACE("UDP noCS, skip L4CS offload");
		rg_kernel.txDesc.tx_l4cs=0;
	}

#if defined(CONFIG_RG_RTL9602C_SERIES)
	//patch for gmac udp checksum issue
	if((pPktHdr->tagif&IPV6_TAGIF)&&(pPktHdr->tagif&UDP_TAGIF)&&(pPktHdr->l4Len==10))
	{
		rg_kernel.txDesc.tx_l4cs=0;

		if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
			|| pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT || pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR
#endif
			)
		{
			uint16 *pL4Checksum;
			TRACE("recalculate ipv6+udp checksum");
			pL4Checksum=(uint16*)&skb->data[pPktHdr->l4Offset+6];
			*pL4Checksum=0;
			*pL4Checksum=htons(inet_chksum_pseudoV6(skb->data+pPktHdr->l4Offset, skb->len-pPktHdr->l4Offset, pPktHdr->pIpv6Sip, pPktHdr->pIpv6Dip, pPktHdr->ipProtocol));
		}
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
#if defined(CONFIG_RG_RTL9600_SERIES) && defined(CONFIG_GPON_FEATURE)
	if(rg_db.systemGlobal.gpon_pppoe_status==GPON_PPPOE_MODE_SW_OFFLOAD)
	{
		if((pPktHdr->tagif&PPPOE_TAGIF)==0 && (pPktHdr->egressTagif&PPPOE_TAGIF)) //untag => tag
		{
			rg_kernel.txDesc.tx_tx_pppoe_action=RTK_RG_CPUTAG_PPPOEACT_ADD; //keep or add (always tag)
			rg_kernel.txDesc.tx_tx_pppoe_idx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx&0x7;
			//do not enable keep for switch offload pppoe tag
			rg_kernel.txDesc.tx_keep=0;
			//force padding if skb->len <52
			if(skb->len<52)skb->len=52;
		}
		else //untag => untag, tag => tag
		{
			rg_kernel.txDesc.tx_tx_pppoe_action=RTK_RG_CPUTAG_PPPOEACT_KEEP; //keep
			rg_kernel.txDesc.tx_tx_pppoe_idx=0;
		}
	}
#endif
#else	//switch support pppoe tag offload
	if((pPktHdr->tagif&PPPOE_TAGIF)==0 && (pPktHdr->egressTagif&PPPOE_TAGIF)) //untag => tag
	{
		rg_kernel.txDesc.tx_tx_pppoe_action=RTK_RG_CPUTAG_PPPOEACT_ADD; //keep or add (always tag)
		rg_kernel.txDesc.tx_tx_pppoe_idx=pPktHdr->netifIdx&0xf;
		if(pPktHdr->shortcutStatus!=RG_SC_MATCH) pPktHdr->mibTagDelta+=8;
	}
	else if((pPktHdr->tagif&PPPOE_TAGIF) && (pPktHdr->egressTagif&PPPOE_TAGIF)==0) //tag => untag
	{
		rg_kernel.txDesc.tx_tx_pppoe_action=RTK_RG_CPUTAG_PPPOEACT_REMOVE; //remove
		rg_kernel.txDesc.tx_tx_pppoe_idx=0;
		if(pPktHdr->shortcutStatus!=RG_SC_MATCH) pPktHdr->mibTagDelta-=8;
	}
	else //untag => untag, tag => tag
	{
		rg_kernel.txDesc.tx_tx_pppoe_action=RTK_RG_CPUTAG_PPPOEACT_KEEP; //keep
		rg_kernel.txDesc.tx_tx_pppoe_idx=0;
	}
#endif

	//20151023LUKE: for packet to non-PON port, we suppose cputag_psel should be zero for disable NIC padding if necessary.
	//And if CF unmatch action is DROP or Permit_without_PON, we should always set psel to 1.
#if defined(CONFIG_RG_RTL9600_SERIES)
	if((((rg_kernel.txDesc.tx_tx_portmask & (1<<RTK_RG_MAC_PORT_PON))&&pon_is_cfport) || ((rg_kernel.txDesc.tx_tx_portmask & (1<<RTK_RG_MAC_PORT_RGMII)) && rgmii_is_cfport))
		&&(rg_db.systemGlobal.initParam.wanPortGponMode))
#else
	if((rg_kernel.txDesc.tx_tx_portmask & (1<<RTK_RG_MAC_PORT_PON))&&
		(rg_db.systemGlobal.initParam.wanPortGponMode))
#endif
	{
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20160506CHUCK: patch pppoe gpon little-bandwidth issue.  Direct-Tx to RGMII will effect by H/W CF-unmatch-drop (because RGMII doesn't have streamID action, not the same as PON port), so we force change the port back to PON directly (skip loop back directly in software)
		if(rg_db.systemGlobal.pppoeGponSmallbandwithControl){
			if((rg_kernel.txDesc.tx_tx_portmask & (1<<RTK_RG_MAC_PORT_RGMII)))//hit the loop-back patch, translate the port direct to PON.
			{
				rg_kernel.txDesc.tx_tx_portmask &= ~(1<<RTK_RG_MAC_PORT_RGMII);
				rg_kernel.txDesc.tx_tx_portmask |= (1<<RTK_RG_MAC_PORT_PON);
				TRACE("Direct TX translate egress port from RGMII back to PON.");
			}
		}
#endif

#ifdef CONFIG_GPON_FEATURE
	//20151023LUKE: if we are arrived here means we are hit CF rulte to decide stream or LLID.
	#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		rg_kernel.txDesc.tx_cputag_psel=1;
		//20140902LUKE: remarking stream ID only when ponMacMode is GPON
		if(rg_db.systemGlobal.initParam.wanPortGponMode){
			//for GPON, set StreamID from CF
			rg_kernel.txDesc.tx_tx_dst_stream_id=pPktHdr->streamID;
			TRACE("remarking streamID %d!!",pPktHdr->streamID);
		}else{
			//for EPON, always set LLID to zero.
			rg_kernel.txDesc.tx_tx_dst_stream_id=0;	//set LLID to zero
		}
	#elif defined(CONFIG_RG_G3_SERIES)
		if(rg_db.systemGlobal.initParam.wanPortGponMode && !rg_kernel.autoTestMode){
			//for GPON, set StreamID from CF
			rg_kernel.txDesc.tx_tx_dst_stream_id=pPktHdr->streamID;
			TRACE("remarking streamID %d!!",pPktHdr->streamID);
			pPktHdr->egressServiceVlanTagif = 1;		//tx_tpid_sel=0
			pPktHdr->egressServiceVlanID = pPktHdr->streamID;
			pPktHdr->egressServicePriority = pPktHdr->egressVlanTagif ? pPktHdr->egressPriority : 0;
			pPktHdr->egressServiceVlanDei = 0;
		}

	#else
		rg_kernel.txDesc.tx_cputag_psel=1;
		//for PON, set StreamID or LLID from CF
		rg_kernel.txDesc.tx_tx_dst_stream_id=pPktHdr->streamID;
		TRACE("remarking streamID or LLID %d!!",pPktHdr->streamID);
	#endif
#else
		//20151023LUKE: directTX should bypass HW cf unmatch action, since HW can't decide interface index!
		rg_kernel.txDesc.tx_cputag_psel=1;
		rg_kernel.txDesc.tx_tx_dst_stream_id=0;	//don't care
#endif
	}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_GPON_FEATURE)
	if((rg_kernel.txDesc.tx_tx_portmask & (1<<RTK_RG_MAC_PORT_PON))&&
		(rg_db.systemGlobal.initParam.wanPortGponMode==0))
	{
		rg_kernel.txDesc.tx_cputag_psel=1;
		//20180212: Stream ID of EPON: MSB 3-bits(LLID)+LSB 4-bits(QID)
		rg_kernel.txDesc.tx_tx_dst_stream_id=(((pPktHdr->streamID&0x7)<<4)|(pPktHdr->internalPriority&0x7));

#if defined(CONFIG_RG_G3_SERIES)
		if(!rg_kernel.autoTestMode) {
			pPktHdr->egressServiceVlanTagif = 1;		//tx_tpid_sel=0
			pPktHdr->egressServiceVlanID = rg_kernel.txDesc.tx_tx_dst_stream_id;
			pPktHdr->egressServicePriority = pPktHdr->egressVlanTagif ? pPktHdr->egressPriority : 0;
			pPktHdr->egressServiceVlanDei = 0;
		}
#endif

		TRACE("remarking streamID for EPON as %d!!",rg_kernel.txDesc.tx_tx_dst_stream_id);
	}
#endif

	//Assign CPUtag priority
	rg_kernel.txDesc.tx_aspri=0x1;
	rg_kernel.txDesc.tx_cputag_pri=pPktHdr->internalPriority;


#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
{
	//Assign gmac_id
	if((!rg_db.systemGlobal.disableWifiRxAcc)
		&& (RG_RET_MBSSID_MASTER_ROOT_INTF<=pPktHdr->wlan_dev_idx && pPktHdr->wlan_dev_idx<=RG_RET_MBSSID_MASTER_LAST_INTF))
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		rg_kernel.txDesc.tx_gmac_id=2;
#else
		rg_kernel.txDesc.tx_gmac_id=1;
#endif
#else
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		if(rg_db.systemGlobal.disableWifiRxHwlookupHash==0)
			rg_kernel.txDesc.tx_gmac_id=_rtk_rg_cpu_trap_hash(pPktHdr->sport, pPktHdr->dport)==RTK_RG_MAC_PORT_MASTERCPU_CORE0?0:1;
		else if(rg_db.systemGlobal.disableWifiRxHwlookupHash==1)
		{
			rg_kernel.txDesc.tx_gmac_id=rg_db.systemGlobal.masterWifiRRFlag;
			if(rg_db.systemGlobal.masterWifiRRFlag)
				rg_db.systemGlobal.masterWifiRRFlag=0;
			else
				rg_db.systemGlobal.masterWifiRRFlag=1;
		}
		else
#endif
		rg_kernel.txDesc.tx_gmac_id=0;
#endif
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
	else if((!rg_db.systemGlobal.disableSlaveWifiRxAcc)
#else
	else if((!rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
#endif
		&& (RG_RET_MBSSID_SLAVE_ROOT_INTF<=pPktHdr->wlan_dev_idx && pPktHdr->wlan_dev_idx<=RG_RET_MBSSID_SLAVE_LAST_INTF))
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		if(rg_db.systemGlobal.disableWifiRxHwlookupHash==0)
			rg_kernel.txDesc.tx_gmac_id=_rtk_rg_cpu_trap_hash(pPktHdr->sport, pPktHdr->dport)==RTK_RG_MAC_PORT_MASTERCPU_CORE0?0:1;
		else if(rg_db.systemGlobal.disableWifiRxHwlookupHash==1)
		{
			rg_kernel.txDesc.tx_gmac_id=rg_db.systemGlobal.masterWifiRRFlag;
			if(rg_db.systemGlobal.masterWifiRRFlag)
				rg_db.systemGlobal.masterWifiRRFlag=0;
			else
				rg_db.systemGlobal.masterWifiRRFlag=1;
		}
		else
#endif
		rg_kernel.txDesc.tx_gmac_id=0;
#else
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		rg_kernel.txDesc.tx_gmac_id=2;
#else
		rg_kernel.txDesc.tx_gmac_id=1;
#endif
#endif
#ifdef CONFIG_SMP
	else
		rg_kernel.txDesc.tx_gmac_id=rg_db.systemGlobal.smpSelectTxGmacFromCpu[smp_processor_id()];
#endif
}
#endif
#endif	// end CONFIG_RG_FLOW_NEW_WIFI_MODE

	if(pPktHdr->egressUniPortmask!=0)
	{
		rg_kernel.txDesc.tx_tx_portmask=pPktHdr->egressUniPortmask;
	}
#if defined(CONFIG_RG_RTL9607C_SERIES)
	// enable cpu port of tx_dst_stream_id of txDesc if packet is forwarded to cpu port
	if(rg_kernel.txDesc.tx_tx_portmask & ((1<<RTK_RG_MAC_PORT_SLAVECPU) | (1<<RTK_RG_MAC_PORT_MASTERCPU_CORE0) | (1<<RTK_RG_MAC_PORT_MASTERCPU_CORE1)))
	{
		rg_kernel.txDesc.tx_tx_dst_stream_id = 0x1;
	}
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
	if(rg_kernel.txDesc.tx_tx_portmask & (1<<RTK_RG_MAC_PORT_CPU) )
	{
		rg_kernel.txDesc.tx_tx_dst_stream_id = 0x1;
	}
#endif

#if defined(CONFIG_RG_G3_SERIES)
	_rtk_rg_sw_txChecksumUpdate(skb, pPktHdr);
#elif defined(CONFIG_APOLLO_FPGA_PHY_TEST)
	_rtk_rg_sw_txPPPoEUpdate(skb, pPktHdr);
	_rtk_rg_sw_txChecksumUpdate(skb, pPktHdr);
#elif defined(CONFIG_RTL9607C_TEST_CHIP)
	_rtk_rg_sw_txPPPoEUpdate(skb, pPktHdr);
#endif

#if defined(CONFIG_APOLLO_ROMEDRIVER)
	//VLAN remarking for shortcut packets
	_rtk_rg_TranslateVlanSvlan2Packet(skb,pPktHdr,0);
#endif



#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
//=================================================================================================================
/* Don't Move It ! We should drop the packet after	Vlan update but before Start send to Hw */
//=================================================================================================================

	if(pPktHdr->ingressLocation == RG_IGR_MC_DATA_BUF)
	{
		IGMP("RG_IGR_MC_DATA_BUF Packet Stop to Send!!");
		if(skb)
		{
			_rtk_rg_dev_kfree_skb_any(skb);
			skb=NULL;
		}
		return;
	}

#endif


//=================================================================================================================
/*	Start send to Hw		*/
//=================================================================================================================




#if defined(CONFIG_RG_RTL9602C_SERIES)
	//re-calculate the L3 or L4 checksum if using TPID2, because gamc can not offload TPID2 checksum recount.
	if(pPktHdr->egressServiceVlanTagif==0x2 || pPktHdr->egressServiceVlanTagif==0x3)//the CF action could use stag tpid without 0x8100
	{
		if(pPktHdr->tagif&IPV4_TAGIF && (pPktHdr->l3Modify||(pPktHdr->fwdDecision==RG_FWD_DECISION_ROUTING)) &&
			pPktHdr->ipv4Checksum==ntohs(*pPktHdr->pIpv4Checksum)) //update checksum only when checksum is not change
		{

			TRACE("recount L3 checksum");
			//could be outbound
			*pPktHdr->pIpv4Checksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pPktHdr->pIpv4Checksum),pPktHdr->ipv4Sip,pPktHdr->ipv4TTL,pPktHdr->ipProtocol,ntohl(*pPktHdr->pIpv4Sip),*pPktHdr->pIpv4TTL));
			//could be inbound
			*pPktHdr->pIpv4Checksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pPktHdr->pIpv4Checksum),pPktHdr->ipv4Dip,0,pPktHdr->ipProtocol,ntohl(*pPktHdr->pIpv4Dip),0));	//TTL should not count again,assign zero


			if(pPktHdr->l4Modify && pPktHdr->fwdDecision!=RG_FWD_DECISION_ROUTING && pPktHdr->ipv4FragPacket==0 &&
				pPktHdr->l4Checksum==ntohs(*pPktHdr->pL4Checksum)) //update checksum only when checksum is not change
			{

				if(pPktHdr->l4Direction==RG_NAPT_OUTBOUND_FLOW){//outbound
					if(pPktHdr->tagif&TCP_TAGIF){
						TRACE("recount L4 checksum(outbound)");
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
					}else if(pPktHdr->tagif&UDP_TAGIF){
						TRACE("recount L4 checksum(outbound)");
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
					}
				}else if(pPktHdr->l4Direction==RG_NAPTR_INBOUND_FLOW){//inbound
					if(pPktHdr->tagif&TCP_TAGIF){
						TRACE("recount L4 checksum(inbound)");
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
					}
					else if(pPktHdr->tagif&UDP_TAGIF){
						TRACE("recount L4 checksum(inbound)");
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,0,0,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),0,0));
					}
				}
			}
		}
	}
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_RG_RTL9600_SERIES)
	if(pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_MIRROR_UDP_ENCAP_ACT_DONE_BIT) //copy egress packet to send, and mirror the packet to PS with IP/UDP encapsulation.
		_rtk_rg_aclUDPencapMirror(skb, pPktHdr);
#endif

	TRACE("final Tx tx_cputag_pri=%d",rg_kernel.txDesc.tx_cputag_pri);


	//ring num  ->  Master: 0, 2, 4   slave: 1, 3
	if((pPktHdr->etherType==0x8864)&& (pPktHdr->tagif&IPV4_TAGIF)==0x0 && (pPktHdr->tagif&IPV6_TAGIF)==0x0) //garentee PPPoE LCP can send with higher ring to avoid PPPoE dis-connection.
	{
		//Call NIC driver api to send packet with higher ring_num
		DEBUG("PPPoE LCP packet, send with higher NIC ring_num.");
		_rtk_rg_splitJumboSendToNicWithTxInfo(pPktHdr,skb,(struct tx_info*)&rg_kernel.txDesc,4);
	}
	else if((rg_kernel.txDesc.tx_cputag_pri ==0x7) ||(sw_forceTxPriEn && (rg_kernel.txDesc.tx_cputag_pri>3)))
	{
		//Call NIC driver api to send packet with higher ring_num
		DEBUG("Force higher tx priority, send with higher NIC ring_num.");
		_rtk_rg_splitJumboSendToNicWithTxInfo(pPktHdr,skb,(struct tx_info*)&rg_kernel.txDesc,4);
	}
	else
	{
		//Call NIC driver api to send packet
		_rtk_rg_splitJumboSendToNicWithTxInfo(pPktHdr,skb,(struct tx_info*)&rg_kernel.txDesc,0);
	}
	return;
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_fwdEngineReturn_t _rtk_rg_bindingRuleCheck(rtk_rg_pktHdr_t *pPktHdr, int *wanGroupIdx)
{
	//unsigned int srcPort=pPktHdr->ingressMacPort;
	//unsigned int extSpa=pPktHdr->ingressPort;
	rtk_rg_vbind_linkList_t *pVbdEntry;

#if defined(CONFIG_MASTER_WLAN0_ENABLE)
	//20140707LUKE:Check if the WLAN0 devices are binded!
	//TRACE("pPktHdr->ingressPort is %d, pkthdr->wlan_dev_idx is %d",pPktHdr->ingressPort,pPktHdr->wlan_dev_idx);
	if(pPktHdr->wlan_dev_idx!=RG_RET_MBSSID_NOT_FOUND && rg_db.systemGlobal.wlan0BindDecision[pPktHdr->wlan_dev_idx].set_bind)
	{
		TRACE("Hit!! WLAN%d-Device-bind to WAN%d", (pPktHdr->wlan_dev_idx<RG_RET_MBSSID_SLAVE_ROOT_INTF)?0:1, rg_db.systemGlobal.wlan0BindDecision[pPktHdr->wlan_dev_idx].bind_wanIntf);
		*wanGroupIdx=rg_db.systemGlobal.interfaceInfo[rg_db.systemGlobal.wlan0BindDecision[pPktHdr->wlan_dev_idx].bind_wanIntf].lan_or_wan_index;
		return RG_FWDENGINE_RET_HIT_BINDING;
	}
#endif

	//Check port-binding
	if((rg_db.systemGlobal.non_binding_pmsk.portmask&(0x1<<pPktHdr->ingressPort))==0)
	{
		//Check Vlan-Binding if has 1Q tag
		if(pPktHdr->tagif&CVLAN_TAGIF)
		{
			if(!list_empty(&rg_db.vlanBindingListHead[pPktHdr->ingressPort]))
			{
				list_for_each_entry(pVbdEntry,&rg_db.vlanBindingListHead[pPktHdr->ingressPort],vbd_list)
				{
					if(pVbdEntry->vlanId==pPktHdr->ctagVid)
					{
						//Vlan-Binding!!
						TRACE("Hit!! Vlan-bind to WAN%d",pVbdEntry->wanIdx);
						*wanGroupIdx=rg_db.systemGlobal.interfaceInfo[pVbdEntry->wanIdx].lan_or_wan_index;

						return RG_FWDENGINE_RET_HIT_BINDING;
					}
				}

			}
		}

		if(rg_db.systemGlobal.portbinding_wan_idx[pPktHdr->ingressPort]>=0)
		{
			//Port-Binding!!
			TRACE("Hit!! Port-bind to WAN%d",rg_db.systemGlobal.portbinding_wan_idx[pPktHdr->ingressPort]);
			*wanGroupIdx=rg_db.systemGlobal.interfaceInfo[(int)rg_db.systemGlobal.portbinding_wan_idx[pPktHdr->ingressPort]].lan_or_wan_index;

			return RG_FWDENGINE_RET_HIT_BINDING;
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

int _rtk_rg_broadcastForwardWithPkthdr(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb, unsigned int internalVlanID, unsigned int srcPort,unsigned int extSpa)
{
	struct sk_buff *bcSkb=NULL;
	int i,j,isGatewayMac=0;
	int groupIdx;
	int aclRet, aclRetPON = 0;
	unsigned char *pSourceMac;
	unsigned int dpMask,wanPortMask=0,wanSentPortMask=0,bindWanPortMask=0,vlanBindTagPortMask=0,vlanBindUntagPortMask=0, psTxPortMask=0;
	int gw_netifIdx=FAIL;
	unsigned int outputPortIdx = 0, allDestPortMask = 0;
	unsigned char byPassWAN = 0;
	unsigned char aclDecisionforPON = FALSE;	// setup a flag to make sure run PON port ACL checking only one time.
	int orinetifIdx = pPktHdr->netifIdx;
	uint16 l3Offset_ori = pPktHdr->l3Offset;
	uint16 l4Offset_ori = pPktHdr->l4Offset;
	uint16 tagif_ori = pPktHdr->egressVlanTagif;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	rtk_rg_table_flowEntry_t path3action,path4action;
	//uint32 path3PortMsk=0,path4PortMsk=0 ,path3ExtPortMsk=0,path4ExtPortMsk=0 ;
	uint32 ingressByteCnt = 0, egressPktCnt = 0, egressByteCnt = 0;
	uint32 egressPktCnt_wan = 0, egressByteCnt_wan = 0;
	int flowmibIdx = FAIL, flowmibIdx_wan = FAIL;
#endif
#endif

	uint32 egress_filter_portmask=0x0;

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	uint32 internal_vlan_to_ps = 1;
#endif

	//Return RT_ERR_RG_FAILED to protocol stack, return  RT_ERR_RG_OK after packets sended

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	bzero(&path3action,sizeof(path3action));
	bzero(&path4action,sizeof(path4action));
#endif
#endif

	pPktHdr->egressMacPort=CF_UNI_DEFAULT; //for cf check
	//TRACE("srcPort=%d, extSpa=%d",srcPort,extSpa);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_RG_RTL9600_SERIES)
		pPktHdr->cpSkbToPsbyBC = 1;
#endif

#if 1
	if(pPktHdr->ingressLocation==RG_IGR_PHY_PORT && (rg_db.systemGlobal.hybrid_pptp_portmask & (0x1<<pPktHdr->ingressPort))==0x0)
	{
		if(memcmp(skb->data,"\x01\x80\xc2",3)==0)
		{
			TRACE("[To PS] Trap DMAC 01:80:C2:XX:XX:XX to PS");
			return RG_FWDENGINE_RET_TO_PS;
		}
	}
#endif
	if (rg_db.systemGlobal.mcast_resvedMac_hwFwd2pptp && pPktHdr->ingressLocation==RG_IGR_PHY_PORT && (memcmp(skb->data,"\x01\x80\xc2",3)==0 || memcmp(skb->data,"\x01\x00\x0c",3)==0))
	{
		if((1<<pPktHdr->ingressPort) & (rg_db.systemGlobal.wanPortMask.portmask | (1<<RTK_RG_PORT_PON)))
		{
			pPktHdr->multicastMacPortMask.portmask = rg_db.systemGlobal.hybrid_pptp_portmask;
			pPktHdr->fwdDecision=RG_FWD_DECISION_FLOW_RESERVED_MC;
		}
		else if((1<<pPktHdr->ingressPort) & rg_db.systemGlobal.hybrid_pptp_portmask)
		{
			pPktHdr->multicastMacPortMask.portmask = (rg_db.systemGlobal.wanPortMask.portmask| (1<<RTK_RG_PORT_PON));
			pPktHdr->fwdDecision=RG_FWD_DECISION_FLOW_RESERVED_MC;
		}
		IGMP("reserved multicast Mac to pptp port by hardware Pmsk=%x",pPktHdr->multicastMacPortMask.portmask);
	}
	if(pPktHdr->fwdDecision==RG_FWD_DECISION_FLOW_RESERVED_MC)
	{
		//src filter for last port to add flow
		pPktHdr->multicastMacPortMask.portmask &= (~(1<<pPktHdr->ingressPort));
		IGMP("RG_FWD_DECISION_FLOW_RESERVED_MC (after Src filter) Pmsk=%x",pPktHdr->multicastMacPortMask.portmask);
	}


	//control by proc/rg/unknownDA_Trap_to_PS : trap unknownDA packet originally to PS
	if(rg_db.systemGlobal.unknownDA_Trap_to_PS_enable){
		//if((pPktHdr->pDmac[0]&0x1)==0x0){
		if(((pPktHdr->pDmac[0]&0x1)==0x0)&&(RTK_RG_IS_WAN_PORT(pPktHdr->ingressPort))) {
			TRACE("[To PS] Trap unknownDA to PS");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			return RG_FWDENGINE_RET_TO_PS;
		}
	}

	//cpSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
	//if(cpSkb==NULL)	goto OUT_OF_MEM;

	// clear old configed fields.
	//rg_kernel.txDescMask.opts4.dw=0;	//not used now!
	rg_kernel.txDesc.opts1.dw=0;
	rg_kernel.txDesc.opts2.dw=0;
	rg_kernel.txDesc.opts3.dw=0;
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	rg_kernel.txDesc.opts4.dw=0;
#endif

	//rg_kernel.txDescMask.tx_tx_portmask=RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU;
	rg_kernel.txDesc.tx_ipcs=1;
	rg_kernel.txDesc.tx_l4cs=1;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_kernel.txDesc.tx_keep=0; 			//dirtx case: keep must be zero.
#else
	rg_kernel.txDesc.tx_keep=1; 			//20141104LUKE: when L34Keep is on, Keep is also needed for gpon.
#endif

	rg_kernel.txDesc.tx_l34_keep=1;
	rg_kernel.txDesc.tx_dislrn=1;

	//DEBUG("in %s, the internalVlanId is %d, srcport is %d",__FUNCTION__,internalVlanID,srcPort);
	//Check for internalVLAN contains WAN port or not
	pSourceMac=pPktHdr->pSmac;

	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
	{
		if(rg_db.systemGlobal.interfaceInfo[i].valid)
		{
			if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan)
			{
				//WAN interface
				if(memcmp(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.gmac.octet,pSourceMac,ETHER_ADDR_LEN)==0)
				{
					isGatewayMac=1;
					gw_netifIdx = pPktHdr->netifIdx; //keep the gateway index, for broadcast to normalWan the  pPktHdr->netifIdx will be changed.
					break;
				}
			}
#if 0 //BC packet from LAN should not send to WAN
			else
			{
				//LAN interface
				if(memcmp(rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.gmac.octet,pSourceMac,ETHER_ADDR_LEN)==0)
				{
					isGatewayMac=1;
					break;
				}
			}
#endif
		}
	}

	//Do ACL egress pattern check for PON port.
	//Use correct wan intf index if hit binding rule
	if(rg_db.systemGlobal.initParam.macBasedTagDecision &&
		_rtk_rg_bindingRuleCheck(pPktHdr, &groupIdx)==RG_FWDENGINE_RET_HIT_BINDING &&
		rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf != NULL &&
		RTK_RG_IS_WAN_PORT(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_port_idx))	// focus on PON port
	{
		unsigned char sendToBindindWAN = FALSE;
		dpMask=0x1<<rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_port_idx;
		bindWanPortMask|=dpMask;
		pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[groupIdx].index;
		if(rg_db.systemGlobal.port_binding_by_protocal==1){//IPv4 Routing, IPv6 Bridge
			if((rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)||
			((pPktHdr->internalVlanID==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)&&(pPktHdr->tagif&IPV6_TAGIF)&&(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->none_internet==0))||
			((pPktHdr->tagif&PPPOE_TAGIF)))
			{
				sendToBindindWAN = TRUE;
			}
			//patch for PPPoE routing + passthrough hybrid mode.
			else if( rg_db.systemGlobal.pppoe_bc_passthrought_to_bindingWan_enable==RTK_RG_ENABLED
				&& rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_PPPoE
				&& (pPktHdr->tagif&PPPOE_TAGIF))
			{
				sendToBindindWAN = TRUE;
			}//patch for PPPoE routing + passthrough hybrid mode. end
		}else if(rg_db.systemGlobal.port_binding_by_protocal==2){//IPv6 Routing, IPv4 Bridge
			if((rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)||
			((pPktHdr->internalVlanID==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)&&((pPktHdr->tagif&IPV4_TAGIF)||(pPktHdr->tagif&ARP_TAGIF))&&(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->none_internet==0))||
			((pPktHdr->tagif&PPPOE_TAGIF)))
			{
				sendToBindindWAN = TRUE;
			}
			//patch for PPPoE routing + passthrough hybrid mode.
			else if( rg_db.systemGlobal.pppoe_bc_passthrought_to_bindingWan_enable==RTK_RG_ENABLED
				&& rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_PPPoE
				&& (pPktHdr->tagif&PPPOE_TAGIF))
			{
				sendToBindindWAN = TRUE;
			}//patch for PPPoE routing + passthrough hybrid mode. end

		}else{// IPv4+IPv6 both Bridge
			if(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			{
				sendToBindindWAN = TRUE;
			}
			//patch for PPPoE routing + passthrough hybrid mode.
			else if( rg_db.systemGlobal.pppoe_bc_passthrought_to_bindingWan_enable==RTK_RG_ENABLED
				&& rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_PPPoE
				&& (pPktHdr->tagif&PPPOE_TAGIF))
			{
				sendToBindindWAN = TRUE;
			}//patch for PPPoE routing + passthrough hybrid mode. end

		}
		// If packet needs to transmit, process it here.
		if (sendToBindindWAN){

			pPktHdr->internalVlanID = rg_db.netif[pPktHdr->netifIdx].rtk_netif.vlan_id;

		}
	}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// decide upstream egress interface
	if(pPktHdr->netifIdx==FAIL && rg_db.systemGlobal.wanIntfTotalNum!=0
		&& pPktHdr->internalVlanID!=rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET
		&& !(rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER<=pPktHdr->internalVlanID && pPktHdr->internalVlanID<=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET))
	{
		pPktHdr->netifIdx = _rtk_rg_decideNetIfIdx(__ffs(rg_db.systemGlobal.wanPortMask.portmask), RTK_RG_MAC_PORT_PON, (rg_db.vlan[pPktHdr->internalVlanID].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_PON))?0:1, pPktHdr->internalVlanID);
		TRACE("Decide upstream broadcast egress netif idx=%d", pPktHdr->netifIdx);
	}
#endif
	DEBUG("Run Egresss ACL checking and decision for PON port");
	assert_ok(_rtk_rg_egressACLPatternCheck(RG_FWD_DECISION_BRIDGING,0,pPktHdr,skb,0,0,RTK_RG_PORT_PON));	//egressPort use RTK_RG_PORT_PON to pass updtream direction check
	aclRetPON = _rtk_rg_egressACLAction(RG_FWD_DECISION_BRIDGING,pPktHdr);
	memcpy(&rg_db.aclDecisionBackup, &pPktHdr->aclDecision, sizeof(rtk_rg_aclHitAndAction_t));	// backup PON port ACL decision and return value.
	if(aclRetPON==RG_FWDENGINE_RET_TO_PS){
		TRACE("[To PS] Follow ACL Action: TRAP to PS");
		pPktHdr->byPassToPsVlanAclDecision = 1;
		return RG_FWDENGINE_RET_TO_PS;
	}


	//Reset pattern
	pPktHdr->internalVlanID = internalVlanID;
	pPktHdr->netifIdx = orinetifIdx;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// decide downstream egress interface
	if(pPktHdr->netifIdx==FAIL && rg_db.systemGlobal.lanIntfTotalNum!=0)
	{
		pPktHdr->netifIdx = _rtk_rg_decideNetIfIdx(RTK_RG_PORT_MAX, RTK_RG_MAC_PORT_MAX, 1, pPktHdr->internalVlanID);
		TRACE("Decide downstream broadcast egress netif idx=%d", pPktHdr->netifIdx);
	}
#endif
	//Do ACL egress pattern check for non-PON port.
	DEBUG("Run Egresss ACL checking and decision for Non-PON port");
	assert_ok(_rtk_rg_egressACLPatternCheck(RG_FWD_DECISION_BRIDGING,0,pPktHdr,skb,0,0,RTK_RG_PORT_MAX));	//egressPort use RTK_RG_PORT_PON to pass updtream direction check
	aclRet = _rtk_rg_egressACLAction(RG_FWD_DECISION_BRIDGING,pPktHdr);
	if(aclRet==RG_FWDENGINE_RET_DROP) goto BC_PROCESS_END;
	if(aclRet==RG_FWDENGINE_RET_TO_PS){
		TRACE("[To PS] Follow ACL Action: TRAP to PS");
		return RG_FWDENGINE_RET_TO_PS;
	}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	pPktHdr->netifIdx = orinetifIdx;
#endif

	//3/** Broadcast - Path 1. From PS **/
	if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK)
	{
		//WARNING("srcPort is %d, isGatewayMac is %d, rg_kernel.protocolStackTxPortMask is %x",srcPort,isGatewayMac,rg_kernel.protocolStackTxPortMask);
		//20140505LUKE:Check txPortMask, if equals to LAN port, send by VLAN (eth0, eth0.2, eth0.3, eth0.4, eth0.5)
		TRACE("rg_kernel.protocolStackTxPortMask is %x, rg_db.systemGlobal.wanPortMask.portmask is %x",rg_kernel.protocolStackTxPortMask,rg_db.systemGlobal.wanPortMask.portmask);
		//20170925LUKE: remove unnecessary goto statement, otherwise from protocol stack may send more packet to bridge WAN.
		//if((rg_kernel.protocolStackTxPortMask&rg_db.systemGlobal.wanPortMask.portmask)==0x0)
			//goto PERPORT_SCAN;

		//20140505LUKE:Otherwise, send to single port here(WAN)
		//20140509LUKE:From WAN and can not decide interface, we just directTx it!
		//20180606LUKE: from protocol stack but send to unknown DA should send to protocolStackTxPortMask.
		if(pPktHdr->netifIdx==FAIL || pPktHdr->fwdDecision==RG_FWD_DECISION_NO_PS_BC)
		{
			// per port send to rg_kernel.protocolStackTxPortMask only!
			psTxPortMask = rg_kernel.protocolStackTxPortMask;
			DEBUG("Path 1 - srcPort is %d, isGatewayMac is %d, rg_kernel.protocolStackTxPortMask is 0x%x",srcPort,isGatewayMac,rg_kernel.protocolStackTxPortMask);
		}
	}


	// if forward Rsn=0 && mbr=wifi ingore send to physical port
	if((pPktHdr->pRxDesc->rx_reason ==RG_CPU_REASON_NORMAL_FWD ) && FWD_DECISION_IS_MC(pPktHdr->fwdDecision) )
	{
	   allDestPortMask = (pPktHdr->multicastMacPortMask.portmask) ;
	   goto Wireless;
	}


	//for disable snooping and enable proxy hw accelerate
	if(rg_db.systemGlobal.igmpProxyOnly2Wifi && pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)
	{
		if( ( rg_db.systemGlobal.initParam.igmpSnoopingEnable==0 || rg_db.systemGlobal.multicastProtocol ==RG_MC_MLD_ONLY) &&(pPktHdr->tagif&IPV4_TAGIF) && IS_IPV4_MULTICAST_ADDRESS(pPktHdr->ipv4Dip))
		{
			if((pPktHdr->tagif&IPV4_TAGIF) && IN_MULTICAST_RESV_IPV4_ALL(pPktHdr->ipv4Dip))
			{
				//reserved multicast address normal flooding
			}
			else
			{
				//ingore phy-port and  PS flooding , only send to cpu
				TRACE("IPv4 Mulitcast ingore phy-port and  PS flooding , only send to cpu");
				goto Wireless;

			}
		}

		if ( (rg_db.systemGlobal.initParam.igmpSnoopingEnable==0 || rg_db.systemGlobal.multicastProtocol ==RG_MC_IGMP_ONLY) && (pPktHdr->tagif&IPV6_TAGIF) && IS_IPV6_MULTICAST_ADDRESS(((uint32*)pPktHdr->pIpv6Dip)[0]))
		{
			if(((pPktHdr->tagif&IPV6_TAGIF) && IN_MULTICAST_RESV_IPV6_ALL (((uint32*)pPktHdr->pIpv6Dip)[0])) ||((pPktHdr->tagif&IPV6_TAGIF) && IN_MULTICAST6_DATA_NOT_FFXE(((uint32*)pPktHdr->pIpv6Dip)[0])) )
			{
				//reserved multicast address normal flooding
			}
			else
			{
				//ingore phy-port and  PS flooding , only send to cpu
				TRACE("IPv6 Mulitcast ingore phy-port and  PS flooding , only send to cpu");
				goto Wireless;
			}
		}

	}



//PERPORT_SCAN:
WANPORT_SCAN:
	/* Start to check output of each physical port */
	for(outputPortIdx = RTK_RG_MAC_PORT0; outputPortIdx < RTK_RG_MAC_PORT_MAINCPU; outputPortIdx++)
	{
		if(RG_INVALID_MAC_PORT(outputPortIdx)) continue;
		//20210204LUKE: check LAN port first, then copy ACLDecision for PON and check WAN port again
		if(RTK_RG_IS_WAN_PORT(outputPortIdx)^aclDecisionforPON){
			TRACE("Portmask [0x%x] %s, continue...",1<<outputPortIdx,aclDecisionforPON?"LAN port when SCAN WAN":"WAN port when SCAN LAN");
			continue;
		}
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20160506CHUCK: patch pppoe gpon little-bandwidth issue. RGMII is using for loop-back patch, all case should not egress send to RGMII.
		if(rg_db.systemGlobal.pppoeGponSmallbandwithControl){
			if(outputPortIdx==RTK_RG_MAC_PORT_RGMII)//hit the loop-back patch, translate the port direct to PON.
			{
				TRACE("BROADCAST egress port skip RGMII.");
				continue;
			}
		}
#endif
		if( rg_db.portLinkStatusInitDone==TRUE && (rg_db.portLinkupMask & (1<<outputPortIdx))== 0){
			 // If port status is link down, skip checkcing this port. If port status init fail, keep broadcast to all ports
			TRACE("Portmask [0x%x] **STOP** sending packet because port is Link Down, linkup mask = 0x%x ", 1<<outputPortIdx, rg_db.portLinkupMask);
			continue;
		}

		if(outputPortIdx == srcPort){
			// do source port filter in the beginning
			TRACE("Portmask [0x%x] **STOP** sending packet because of src filter", 1<<outputPortIdx);
			continue;
		}

		if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK && gw_netifIdx==FAIL){
			// If path1 [from PS and netifidx==-1], skip those ports which not belong to protocolStackTxPortMask.
			if((psTxPortMask & (0x1<<outputPortIdx)) == 0){
				TRACE("Portmask [0x%x] **STOP** sending packet because of psTxPortMask = 0x%x", 1<<outputPortIdx, psTxPortMask);
				continue;
			}
		}

		//re-init 1p priority. No necessary to init DSCP because original value is saved in skb(-tos).
		pPktHdr->egressPriority=(pPktHdr->tagif&CVLAN_TAGIF?pPktHdr->ctagPri:(rg_db.systemGlobal.qosInternalDecision.qosPortBasedPriority[pPktHdr->ingressMacPort]&0x7));
		rg_kernel.txDesc.tx_cvlan_prio = pPktHdr->egressPriority;
		pPktHdr->egressMacPort=outputPortIdx; //for ACL/CF UNI action of _rtk_rg_modifyPacketByACLAction()
		pPktHdr->netifIdx = orinetifIdx;
		pPktHdr->l3Offset = l3Offset_ori;
		pPktHdr->l4Offset = l4Offset_ori;
		pPktHdr->internalVlanID = internalVlanID;
		pPktHdr->egressVlanID = internalVlanID;
		pPktHdr->egressVlanTagif = tagif_ori;
		if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
			pPktHdr->l3Modify =0;

		DEBUG("BC - process port[%d] *****************", outputPortIdx);
		if (FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
			goto MC_DATA_SEND;

		//3/** Broadcast - Path 2. LAN to Binding WAN **/
		//Check if hit binding rule
		if(rg_db.systemGlobal.initParam.macBasedTagDecision &&
			_rtk_rg_bindingRuleCheck(pPktHdr, &groupIdx)==RG_FWDENGINE_RET_HIT_BINDING &&
			rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf != NULL &&
			rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_port_idx == outputPortIdx)	// output per port
		{
			unsigned char sendToBindindWAN = FALSE;
			DEBUG("Path 2 - LAN to binding wan, groupIdx = %d, netifIdx = %d, wan port id = %d", groupIdx, rg_db.systemGlobal.wanIntfGroup[groupIdx].index, rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_port_idx);
			dpMask=0x1<<rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_port_idx;
			bindWanPortMask|=dpMask;
			pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[groupIdx].index;
			if(rg_db.systemGlobal.port_binding_by_protocal==1){//IPv4 Routing, IPv6 Bridge
				TRACE("IPv4 Routing, IPv6 Bridge");
				if((rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)||
				((pPktHdr->internalVlanID==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)&&(pPktHdr->tagif&IPV6_TAGIF)&&(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->none_internet==0))||
				((pPktHdr->tagif&PPPOE_TAGIF)))
				{
					TRACE("Broadcast to Binding WAN[%d]!!",pPktHdr->netifIdx);
					sendToBindindWAN = TRUE;
				}
				//patch for PPPoE routing + passthrough hybrid mode.
				else if( rg_db.systemGlobal.pppoe_bc_passthrought_to_bindingWan_enable==RTK_RG_ENABLED
					//&& rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_PPPoE
					&& (pPktHdr->tagif&PPPOE_TAGIF))
				{
					TRACE("PPPoE Passthrough to Wan[%d]",pPktHdr->netifIdx);
					sendToBindindWAN = TRUE;
				}//patch for PPPoE routing + passthrough hybrid mode. end
			}else if(rg_db.systemGlobal.port_binding_by_protocal==2){//IPv6 Routing, IPv4 Bridge
				TRACE("IPv6 Routing, IPv4 Bridge");
				if((rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)||
				((pPktHdr->internalVlanID==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)&&((pPktHdr->tagif&IPV4_TAGIF)||(pPktHdr->tagif&ARP_TAGIF))&&(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->none_internet==0))||
				((pPktHdr->tagif&PPPOE_TAGIF)))
				{
					TRACE("Broadcast to Binding WAN[%d]!!",pPktHdr->netifIdx);
					sendToBindindWAN = TRUE;
				}
				//patch for PPPoE routing + passthrough hybrid mode.
				else if( rg_db.systemGlobal.pppoe_bc_passthrought_to_bindingWan_enable==RTK_RG_ENABLED
					//&& rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_PPPoE
					&& (pPktHdr->tagif&PPPOE_TAGIF))
				{
					TRACE("PPPoE Passthrough to Wan[%d]",pPktHdr->netifIdx);
					sendToBindindWAN = TRUE;
				}//patch for PPPoE routing + passthrough hybrid mode. end

			}else{// IPv4+IPv6 both Bridge
				TRACE("IPv4+IPv6 both Bridge");
				if(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
				{
					TRACE("Broadcast to Binding WAN[%d]!!",pPktHdr->netifIdx);
					sendToBindindWAN = TRUE;
				}
				//patch for PPPoE routing + passthrough hybrid mode.
				else if( rg_db.systemGlobal.pppoe_bc_passthrought_to_bindingWan_enable==RTK_RG_ENABLED
					//&& rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type==RTK_RG_PPPoE
					&& (pPktHdr->tagif&PPPOE_TAGIF))
				{
					TRACE("PPPoE Passthrough to Wan[%d]",pPktHdr->netifIdx);
					sendToBindindWAN = TRUE;
				}//patch for PPPoE routing + passthrough hybrid mode. end
			}

			//20170331LUKE: per WAN check option for bridgeToBindingWanByProtocol
			if(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->bridgeToBindingWanByProtocol){
				TRACE("Bridging to Bound WAN: %s!",
					rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->bridgeToBindingWanByProtocol==BGBWP_V4ONLY?"IPv4 or ARP":
					rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->bridgeToBindingWanByProtocol==BGBWP_V6ONLY?"IPv6 Only":"IPv4, ARP and IPv6");
				switch(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->bridgeToBindingWanByProtocol){
					case BGBWP_V4ONLY:
						if((pPktHdr->tagif&ARP_TAGIF)||(pPktHdr->tagif&IPV4_TAGIF))sendToBindindWAN=TRUE;
						break;
					case BGBWP_V6ONLY:
						if((pPktHdr->tagif&IPV6_TAGIF))sendToBindindWAN=TRUE;
						break;
					case BGBWP_V4V6:
						if((pPktHdr->tagif&ARP_TAGIF)||(pPktHdr->tagif&IPV4_TAGIF)||(pPktHdr->tagif&IPV6_TAGIF))sendToBindindWAN=TRUE;
						break;
					default:
						break;
				}
			}

			// If packet needs to transmit, process it here.
			if (sendToBindindWAN){

				pPktHdr->internalVlanID = rg_db.netif[pPktHdr->netifIdx].rtk_netif.vlan_id;
				TRACE("Replace internalVlanID to %d", pPktHdr->internalVlanID);

				_rtk_rg_igmpLeave_portmask_check_and_limit(pPktHdr, &dpMask);
				_rtk_rg_igmpReport_portmask_check_and_limit(pPktHdr, &dpMask);
				_rtk_rg_igmpMldQuery_portmask_check_and_limit(pPktHdr, &dpMask,NULL);
				if(dpMask == 0x0)
				{
					byPassWAN = TRUE;
					goto BYPASS_WAN;
				}

				bcSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
				if(bcSkb==NULL) goto OUT_OF_MEM;

				if(RTK_RG_IS_WAN_PORT(outputPortIdx)){	// Check PON ACL result and use pkthdr for PON if egress port is PON port
					if(aclRetPON==RG_FWDENGINE_RET_DROP){// 20151228 Cheney: CF drop, skip transmitting packet to this wan interface
						TRACE("CF_DROP (skip port mask 0x%x)", dpMask);
						if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
						byPassWAN = TRUE;
						goto BYPASS_WAN;
					}
				}

				aclRet=_rtk_rg_sendBroadcastToWan(pPktHdr,bcSkb,pPktHdr->netifIdx,dpMask);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				if((aclRet == RG_FWDENGINE_RET_CONTINUE) && (pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_FLOWMIB_ACT_DONE_BIT))
				{
					flowmibIdx_wan = pPktHdr->aclDecision.action_flowmib_counter_idx;
					_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt_wan, &egressByteCnt_wan);
				}
#endif

			}
			byPassWAN = TRUE;
			goto BYPASS_WAN;
		}

		//3/** Broadcast - Path 3.  to Bridge WAN **/
		//Normal WAN Check for none-binding packet!!
		if(byPassWAN) goto BYPASS_WAN;	// Cheney: hit binding port, so skip bridge WAN broadcast

		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			pPktHdr->l3Offset = l3Offset_ori;
			pPktHdr->l4Offset = l4Offset_ori;
			pPktHdr->egressVlanTagif = tagif_ori;

			//if((WANMask&(0x1<<(rg_db.systemGlobal.wanIntfGroup[i].index)))>0)
			if(	rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf != NULL &&
				srcPort!=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx &&			/*src block*/
				outputPortIdx == rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx)	// output per port
			{
				dpMask=0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx;
				//20200121LUKE:check per interface MLD/IGMP forbidden bit.
				if(((pPktHdr->tagif&IGMP_TAGIF) && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->forbiddenUnbindIGMP)||
					((pPktHdr->tagif&IPV6_MLD_TAGIF) && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->forbiddenUnbindMLD))
				{
					//20200121LUKE: if the vlan match and IGMP/MLD is forbidden, mark the port as sent.
					if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==pPktHdr->internalVlanID){
						wanPortMask|=dpMask;
						wanSentPortMask|=dpMask;
					}
					TRACE("Wan[%d] forbids unbind %s..",rg_db.systemGlobal.wanIntfGroup[i].index,(pPktHdr->tagif&IGMP_TAGIF)?"IGMP":"MLD");
					continue;
				}
				if(((rg_db.algFunctionMask & RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0) ||	//if pppoe pass through is turn on, all WAN has to be sended
					((srcPort==RTK_RG_MAC_PORT_MAINCPU || srcPort==RTK_RG_MAC_PORT_LASTCPU) && isGatewayMac ) ||					//if src port is CPU and SA==GMAC, send it
					((!rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->none_internet||psTxPortMask&dpMask) &&
					rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE &&
					 (rg_db.vlan[internalVlanID].MemberPortmask.bits[0]&dpMask)>0 &&
					!rg_db.systemGlobal.wanIntfGroup[i].disableBroadcast))				//otherwise only boardcast to (internet||pstxpmsk&wan port) bridge WAN, and this WAN's VLANID didn't to any LAN intf's VLANID
				{
					DEBUG("Path 3 - check bridge wan[%d]", rg_db.systemGlobal.wanIntfGroup[i].index);
					if((srcPort==RTK_RG_MAC_PORT_MAINCPU || srcPort==RTK_RG_MAC_PORT_LASTCPU) && isGatewayMac )
					{
						if(pPktHdr->tagif&CVLAN_TAGIF)
						{
							if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id!=pPktHdr->internalVlanID)
								continue;
						}
						else
						{
							if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on==1)
								continue;
						}
						//20140508LUKE:from procotol stack we should send to only one interface, so compare if this is the one we want!
						if(gw_netifIdx!=rg_db.systemGlobal.wanIntfGroup[i].index)
							continue;
					}

					if((rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE) &&
						(rg_db.systemGlobal.initParam.macBasedTagDecision==0) &&
						(rg_db.vlan[internalVlanID].fidMode==VLAN_FID_IVL))
					{
						// prevent sending broadcast to the bridge WAN which was configured as different VLAN.
						if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf && (rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id!=pPktHdr->internalVlanID))
						{
							DEBUG("The bridge wan egress vlan %d doesn't match with internalVID - skip sending", rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id);
							continue;
						}

					}

					if( pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK && rg_db.systemGlobal.initParam.macBasedTagDecision==1){
						//if broadcast from PS, we should let it compared by egress ACL and assigned sid/cvlan.
						pPktHdr->netifIdx = rg_db.systemGlobal.wanIntfGroup[i].index;
					}

					wanPortMask|=dpMask;
					TRACE("Broadcast to WAN[%d]!!",rg_db.systemGlobal.wanIntfGroup[i].index);

					 _rtk_rg_igmpLeave_portmask_check_and_limit(pPktHdr, &dpMask);
					 _rtk_rg_igmpReport_portmask_check_and_limit(pPktHdr, &dpMask);
					 _rtk_rg_igmpMldQuery_portmask_check_and_limit(pPktHdr, &dpMask,NULL);
					 if(dpMask == 0x0)
						goto BYPASS_WAN;


					bcSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
					if(bcSkb==NULL) goto OUT_OF_MEM;

					if(RTK_RG_IS_WAN_PORT(outputPortIdx)){	// Check PON ACL result and use pkthdr for PON if egress port is PON port
						if(aclRetPON==RG_FWDENGINE_RET_DROP){// 20151224 Cheney: CF drop, skip transmitting packet to this wan interface
							wanSentPortMask|=(0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wan_intf_conf.wan_port_idx);
							TRACE("CF_DROP (skip port mask 0x%x)", wanSentPortMask);
							if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
							continue;
						}
					}
					aclRet=_rtk_rg_sendBroadcastToWan(pPktHdr,bcSkb,rg_db.systemGlobal.wanIntfGroup[i].index,dpMask);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					if((aclRet == RG_FWDENGINE_RET_CONTINUE) && (pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_FLOWMIB_ACT_DONE_BIT))
					{
						flowmibIdx_wan = pPktHdr->aclDecision.action_flowmib_counter_idx;
						_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt_wan, &egressByteCnt_wan);
					}
#endif

					//20140505LUKE:from protocol stack should send to WAN only once!!
					if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK)
					{
						TRACE("[Drop] from protocol stack should send to WAN only once, drop!");
						return RG_FWDENGINE_RET_DROP;
					}

					//20150123LUKE: should not send broadcast to same VLAN more than once!!
					if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==pPktHdr->internalVlanID)
						wanSentPortMask|=(0x1<<rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wan_intf_conf.wan_port_idx);
				}
			}

		}
BYPASS_WAN:

		//3/** Broadcast - Path 4. from VLAN Binding WAN to LAN **/

		//reflash binding Wan decision
		pPktHdr->netifIdx = FAIL;

		//if this broadcast from bridge WAN, send to all Vlan-binding LAN port
		if(rg_db.systemGlobal.initParam.macBasedTagDecision==1 && pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)
		{
			for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
			{
				pPktHdr->l3Offset = l3Offset_ori;
				pPktHdr->l4Offset = l4Offset_ori;
				pPktHdr->egressVlanTagif = tagif_ori;

				//if((WANMask&(0x1<<(rg_db.systemGlobal.wanIntfGroup[i].index)))>0)
				if(	rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf != NULL &&
					srcPort==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx &&
					rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE &&
					rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==internalVlanID)

				{
					//Check VLAN-binding, if any port binding to this WAN, send it back!
					for(j=0;j<MAX_BIND_SW_TABLE_SIZE;j++)
					{
						if(rg_db.bind[j].valid && rg_db.bind[j].rtk_bind.vidLan!=0 && rg_db.nexthop[rg_db.wantype[rg_db.bind[j].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx==rg_db.systemGlobal.wanIntfGroup[i].index)
						{
							//Hit!!Send packet to binding port with tag
							//20140424LUKE:FIXME:directTX can not send to extension port, so ext_port binding won't get packet!!
							if(rg_db.bind[j].rtk_bind.portMask.bits[0]>0 &&
								((rg_db.bind[j].rtk_bind.portMask.bits[0] & (0x1<<outputPortIdx)) > 0))	// output per port
							{
								DEBUG("Path 4 - VLAN binding to LAN");
								dpMask = 0x1<<outputPortIdx;
								vlanBindTagPortMask|=dpMask;
								//20140519LUKE:If get BC packet from Other WAN, it should not receive untag packet for the binding port!
								if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->none_internet)
									vlanBindUntagPortMask|=dpMask;

								// Start handle packet content!
								bcSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
								if(bcSkb==NULL) goto OUT_OF_MEM;

								allDestPortMask = dpMask;	// If vlan binding path hit force forward, now SW still do filter process: _rtk_rg_egressPortMaskCheck()
								// Force being vlan tag and assign vlanID by binding rule
								pPktHdr->egressVlanTagif=1;
								pPktHdr->egressVlanID=rg_db.bind[j].rtk_bind.vidLan;
								_rtk_rg_egressPacketDoQosRemarkingDecision(pPktHdr, skb, bcSkb, dpMask, rg_db.bind[j].rtk_bind.vidLan);

								rg_kernel.txDesc.tx_tx_portmask=dpMask;

								aclRet = _rtk_rg_BroadcastPacketToLanWithEgressACLModification(RG_FWD_DECISION_BRIDGING, 0, pPktHdr,bcSkb,0,0, dpMask, allDestPortMask, -1);
								if(aclRet==RG_FWDENGINE_RET_DROP) {
									//free the copied skb
									if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
								}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
								if((aclRet == RG_FWDENGINE_RET_CONTINUE) && (pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_FLOWMIB_ACT_DONE_BIT))
								{
									flowmibIdx = pPktHdr->aclDecision.action_flowmib_counter_idx;
									_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt, &egressByteCnt);
								}
#endif
							}
						}
					}
				}
			}
		}

		//3/** Broadcast - Path 5 port is belong to Tag or  Untag set **/

MC_DATA_SEND:
		dpMask = (0x1 << outputPortIdx);	//Cheney: output per port

		if (FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
		{

			if((pPktHdr->aclDecision.qos_actions&ACL_ACTION_DS_UNIMASK_BIT)>0 &&
				pPktHdr->aclDecision.action_acl_uni.uniActionDecision==ACL_UNI_FORCE_BY_MASK)
			{
				allDestPortMask=pPktHdr->aclDecision.action_acl_uni.assignedUniPortMask;
				dpMask&=pPktHdr->aclDecision.action_acl_uni.assignedUniPortMask;
				TRACE("ACL Force Forard dpMask=%x",dpMask);
			}
			else if((pPktHdr->aclDecision.ds_action_field&CF_DS_ACTION_UNI_MASK_BIT)>0 &&
				pPktHdr->aclDecision.action_uni.uniActionDecision == ACL_UNI_FORCE_BY_MASK )
			{
				allDestPortMask=pPktHdr->aclDecision.action_uni.assignedUniPortMask;
				dpMask&=pPktHdr->aclDecision.action_uni.assignedUniPortMask;
				TRACE("CF Force Forard dpMask=%x",dpMask);
			}
			else
			{

				dpMask &= pPktHdr->multicastMacPortMask.portmask;
				allDestPortMask = (pPktHdr->multicastMacPortMask.portmask);

				if((pPktHdr->aclDecision.qos_actions&ACL_ACTION_DS_UNIMASK_BIT)>0 &&
					pPktHdr->aclDecision.action_acl_uni.uniActionDecision==ACL_UNI_FWD_TO_PORTMASK_ONLY)
				{
					allDestPortMask&=pPktHdr->aclDecision.action_acl_uni.assignedUniPortMask;
					dpMask&=pPktHdr->aclDecision.action_acl_uni.assignedUniPortMask;
					TRACE("ACL Filter Forard dpMask=%x",dpMask);
				}
				else if((pPktHdr->aclDecision.ds_action_field&CF_DS_ACTION_UNI_MASK_BIT)>0 &&
					pPktHdr->aclDecision.action_uni.uniActionDecision == ACL_UNI_FWD_TO_PORTMASK_ONLY )
				{
					allDestPortMask&=pPktHdr->aclDecision.action_uni.assignedUniPortMask;
					dpMask&=pPktHdr->aclDecision.action_uni.assignedUniPortMask;
					TRACE("CF Filter Forard dpMask=%x",dpMask);
				}

			}

		}
		else
		{
			dpMask&=(~(0x1<<srcPort));
			dpMask&= (~(RTK_RG_ALL_CPU_PORTMASK));	//FIXME:not sending to CPU, but how to WLAN?
			allDestPortMask = rg_db.vlan[internalVlanID].MemberPortmask.bits[0];	//Cheney
			//20140516LUKE:if macBasedDecision is on, all WAN port should be mask here!
			if(rg_db.systemGlobal.initParam.macBasedTagDecision)
			{
				//20140515LUKE:hit binding should mask WAN port!!
				dpMask&=(~bindWanPortMask);
				//20140516LUKE:from Other WAN's packet should not send to vlan-binding port!
				dpMask&=(~vlanBindUntagPortMask);
				//If vlan is not added by cvlan, filter dpMask to prevent redundant packet. e.g. vid 4005.
				if(pPktHdr->internalVlanID==rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET)
					dpMask&=(~rg_db.systemGlobal.wanPortMask.portmask);
				//If packet was sent to bridge wan in path3, filter dpMask to prevent redundant packet.
				if(rg_db.vlan[pPktHdr->internalVlanID].addedAsCustomerVLAN==0)
					dpMask&=(~wanPortMask);
			}
			else
			{
				//20150123LUKE: should not send broadcast to same VLAN more than once!!
				dpMask&=(~wanSentPortMask);
			}
			//20140506LUKE:Check if we are sending packet from eth0.2, eth0.3, eth0.4, eth0.5
			//if so, we should send to tx port only!!
			if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK)
			{
				if(rg_kernel.protocolStackTxPortMask>0)
					dpMask&=rg_kernel.protocolStackTxPortMask;
				else
					dpMask&=(~(rg_db.systemGlobal.wanPortMask.portmask));		//filter all WAN port if send to eth0
			}
		}
		//20140408LUKE:add LAN should not include WAN port, if WAN port is needed to receive packet, just add WAN instead!
		//20140424LUKE:broadcast should follow VLAN member port setting, we should not have any presumptions
		//dpMask&=(~wanPortMask);

		_rtk_rg_igmpLeave_portmask_check_and_limit(pPktHdr, &dpMask);
		_rtk_rg_igmpReport_portmask_check_and_limit(pPktHdr, &dpMask);
		_rtk_rg_igmpMldQuery_portmask_check_and_limit(pPktHdr, &dpMask,NULL);


		if(dpMask == 0)
		{
			TRACE("Portmask [0x%x] **STOP** sending packet because of no needed", 1<<outputPortIdx);
		}
		else
		{
			unsigned char doTAG = FALSE;							// with CVLAN TAG or not
			// Start handle packet content!
			pPktHdr->l3Offset = l3Offset_ori;
			pPktHdr->l4Offset = l4Offset_ori;
			pPktHdr->egressVlanTagif = tagif_ori;

			if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
				pPktHdr->l3Modify =0;


			bcSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
			if(bcSkb==NULL) goto OUT_OF_MEM;

			// Decide: destport is belongs to Tag or Untag set
			if(dpMask & (rg_db.vlan[internalVlanID].MemberPortmask.bits[0]&(~(rg_db.vlan[internalVlanID].UntagPortmask.bits[0])))){
				//port is in Tag set
				doTAG = TRUE;
				//20140516LUKE:from other WAN's packet should not send to vlan-binding port!
				if(vlanBindTagPortMask>0)
					dpMask&=(~vlanBindTagPortMask);
				//if dpMask == 0x0, call continue to skip remaining process.
				if (dpMask == 0x0){
					if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
					continue;
				}

			}
			if(RTK_RG_IS_WAN_PORT(outputPortIdx)){	// Check PON ACL result and use pkthdr for PON if egress port is PON port
				if(aclRetPON==RG_FWDENGINE_RET_DROP){// 20151224 Cheney: CF drop, skip transmitting packet to this wan interface
					TRACE("CF_DROP (skip port mask 0x%x)", dpMask);
					if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
					continue;
				}
			}
			pPktHdr->egressVlanTagif=doTAG;
			pPktHdr->egressVlanID=internalVlanID;

			DEBUG("Path 5 - in [%s] set", doTAG?"Tag":"Untag");

			_rtk_rg_egressPacketDoQosRemarkingDecision(pPktHdr, skb, bcSkb, dpMask, internalVlanID);

			rg_kernel.txDesc.tx_tx_portmask=dpMask;

			//dump_packet(bcSkb->data,bcSkb->len,"broadcast packet");
			aclRet = _rtk_rg_BroadcastPacketToLanWithEgressACLModification(RG_FWD_DECISION_BRIDGING, 0, pPktHdr,bcSkb,0,0, dpMask, allDestPortMask, 0);
			if(aclRet==RG_FWDENGINE_RET_DROP) {
				//free the copied skb
				if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
			}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)

			// after all ports were transmited, the accumulated counter was prepared.
			// todo: call _rtk_rg_fwdEngine_flowMIBUpdate to update flow mib counter.
			if((aclRet == RG_FWDENGINE_RET_CONTINUE) && (pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_FLOWMIB_ACT_DONE_BIT))
			{
				if(RTK_RG_IS_WAN_PORT(outputPortIdx)){
					flowmibIdx_wan = pPktHdr->aclDecision.action_flowmib_counter_idx;
					_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt_wan, &egressByteCnt_wan);
				}
				else{
					flowmibIdx = pPktHdr->aclDecision.action_flowmib_counter_idx;
					_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt, &egressByteCnt);
				}
			}
#endif
		} // end of dpMask != 0

	} // end of outputPort for loop

	//20210204LUKE: check LAN port first, then copy ACLDecision for PON and check WAN port again
	if(!aclDecisionforPON)
	{
		memcpy(&rg_db.systemGlobal.pktHeader_broadcast.aclDecision, &pPktHdr->aclDecision, sizeof(rtk_rg_aclHitAndAction_t));		// rg_db.systemGlobal.pktHeader_broadcast.aclDecision was temporary used for swap
		memcpy(&pPktHdr->aclDecision, &rg_db.aclDecisionBackup, sizeof(rtk_rg_aclHitAndAction_t));	// PON port: recover ACL decision and check return value.
		memcpy(&rg_db.aclDecisionBackup, &rg_db.systemGlobal.pktHeader_broadcast.aclDecision, sizeof(rtk_rg_aclHitAndAction_t));
		aclDecisionforPON=TRUE;
		TRACE("reSCAN WAN PORT now.");
		goto WANPORT_SCAN;
	}

Wireless:

	pPktHdr->egressMacPort=RTK_RG_MAC_PORT_MAINCPU;  //for ACL/CF UNI action of _rtk_rg_modifyPacketByACLAction()

	//20160309LUKE:reassign pktHdr value for consistent.
	pPktHdr->internalVlanID = internalVlanID;
	pPktHdr->egressVlanID = internalVlanID;
	pPktHdr->l3Offset = l3Offset_ori;
	pPktHdr->l4Offset = l4Offset_ori;
	pPktHdr->egressVlanTagif = tagif_ori;
#if defined(CONFIG_RG_G3_SERIES)
	// after pon port tx, reset Svlan decision
	pPktHdr->egressServiceVlanTagif = 0;
	pPktHdr->egressServiceVlanID = 0;
	pPktHdr->egressServicePriority = 0;
	pPktHdr->egressServiceVlanDei = 0;
#endif

	if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
		pPktHdr->l3Modify =0;

	if(aclDecisionforPON)	// restore acl decision which was decided for non-PON port.
	{
		memcpy(&pPktHdr->aclDecision, &rg_db.aclDecisionBackup, sizeof(rtk_rg_aclHitAndAction_t));
	}


	//20140505LUKE:from protocol stack should send to physical LAN only!!
	if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK)
	{
		TRACE("[Drop] from protocol stack should send to physical LAN only, drop!");
		return RG_FWDENGINE_RET_DROP;
	}
	//DEBUG("[wifi] vid=%d, portmask=0x%x, ext pormask=0x%x", internalVlanID, rg_db.vlan[internalVlanID].MemberPortmask.bits[0], rg_db.vlan[internalVlanID].Ext_portmask.bits[0]);
#ifdef CONFIG_RG_WLAN_HWNAT_ACCELERATION

	if((
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#else
		(rg_db.vlan[internalVlanID].MemberPortmask.bits[0]&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)	&&
#endif
		(rg_db.vlan[internalVlanID].Ext_portmask.bits[0]&RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK)) ||

		(FWD_DECISION_IS_MC(pPktHdr->fwdDecision) && (pPktHdr->multicastMacPortMask.portmask&RTK_RG_ALL_REAL_MASTER_EXT_PORTMASK))
	)
	{
		//1 FIXME: from Master to Master, this should not be filtered!!
		//if((srcPort!=RTK_RG_PORT_CPU)||((srcPort==RTK_RG_PORT_CPU)&&(extSpa!=RTK_RG_EXT_PORT0))) //from phyiscal port OR ext1,2,3,4
		//{
			rtk_rg_mbssidDev_t intf_idx;

		if( FWD_DECISION_IS_MC(pPktHdr->fwdDecision) && ((pPktHdr->multicastMacPortMask.portmask&RTK_RG_ALL_REAL_MASTER_EXT_PORTMASK)==0x0))
			goto send_to_master_wifi_end;


			bcSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
			if(bcSkb==NULL) goto OUT_OF_MEM;

			//do aclMidify
			aclRet = _rtk_rg_modifyPacketByACLAction(bcSkb,pPktHdr,RTK_RG_EXT_PORT0);
			if(aclRet==RG_FWDENGINE_RET_DROP){
				if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
				goto send_to_master_wifi_end;
			}

//20180927:Flowbase using software decision we don't need follow hardware limitation
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//20150618LUKE: for multicast packet to wifi, we should check CPU port is in vlan's untag set or not.
			if(rg_db.vlan[pPktHdr->internalVlanID].valid && rg_db.vlan[pPktHdr->internalVlanID].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MAINCPU))
				pPktHdr->egressVlanTagif=0;
			else
				pPktHdr->egressVlanTagif=1;
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			if(rg_db.systemGlobal.gponDsBCModuleEnable && ( (1<<pPktHdr->ingressPort) & (rg_db.systemGlobal.wanPortMask.portmask)) && (pPktHdr->pDmac[0]&0x1 ) )
#else
			if(rg_db.systemGlobal.gponDsBCModuleEnable && (pPktHdr->ingressPort==RTK_RG_PORT_PON) && (((pPktHdr->pDmac[0]&pPktHdr->pDmac[1]&pPktHdr->pDmac[2]&pPktHdr->pDmac[3]&pPktHdr->pDmac[4]&pPktHdr->pDmac[5])==0xff)||(pPktHdr->pDmac[0]==0x01 && pPktHdr->pDmac[1]==0x00 && pPktHdr->pDmac[2]==0x5e)) && (rg_db.systemGlobal.initParam.wanPortGponMode==1))//must be GPON, BC, from PON
#endif
			{
				_rtk_rg_egressPacketSend_for_gponDsBcFilterAndRemarking(bcSkb,pPktHdr,1);
			}
			else
			{
				intf_idx=_rtk_master_wlan_mbssid_tx(pPktHdr,bcSkb);

				if(intf_idx==RG_RET_MBSSID_NOT_FOUND)
				{
					TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
					if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
				}

				if(intf_idx==RG_RET_MBSSID_FLOOD_ALL_INTF)
				{
					TRACE("Broadcast to master WLAN(flooding)");
				}
				else
				{
					TRACE("Broadcast to master WLAN(intf=%d)",intf_idx);
				}
			}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			if((aclRet == RG_FWDENGINE_RET_CONTINUE) && (pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_FLOWMIB_ACT_DONE_BIT))
			{
				flowmibIdx = pPktHdr->aclDecision.action_flowmib_counter_idx;
				_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt, &egressByteCnt);
			}

#endif

			//}end of if((pPktHdr->ingressPort==RTK_RG_PORT_PON) && ((pPktHdr->pDmac[0]&pPktHdr->pDmac[1]&pPktHdr->pDmac[2]&pPktHdr->pDmac[3]&pPktHdr->pDmac[4]&pPktHdr->pDmac[5])==0xff) && (rg_db.systemGlobal.initParam.wanPortGponMode==1))//must be GPON, BC, from PON

		//}
	}
send_to_master_wifi_end:

	//reassign pktHdr value for consistent.
	pPktHdr->internalVlanID = internalVlanID;
	pPktHdr->egressVlanID = internalVlanID;
	pPktHdr->l3Offset = l3Offset_ori;
	pPktHdr->l4Offset = l4Offset_ori;
	pPktHdr->egressVlanTagif = tagif_ori;
	if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
		pPktHdr->l3Modify =0;

#ifdef CONFIG_DUALBAND_CONCURRENT
// send broadcast to slave wifi
	if(((rg_db.vlan[internalVlanID].MemberPortmask.bits[0]&RTK_RG_ALL_MAC_SLAVE_CPU_PORTMASK)&&
		(rg_db.vlan[internalVlanID].Ext_portmask.bits[0]&RTK_RG_ALL_VLAN_SLAVE_EXT_PORTMASK)) ||
		(FWD_DECISION_IS_MC(pPktHdr->fwdDecision) && (pPktHdr->multicastMacPortMask.portmask&RTK_RG_ALL_REAL_SLAVE_EXT_PORTMASK))
	  )
	{

		if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision) && ((pPktHdr->multicastMacPortMask.portmask&RTK_RG_ALL_REAL_SLAVE_EXT_PORTMASK)==0x0))
			goto send_to_slave_wifi_end;

	   if((RTK_RG_ALL_MAC_CPU_PORTMASK&(0x1<<srcPort))==0x0 ||
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
		   (srcPort==RTK_RG_MAC_PORT_CPU && extSpa!=RTK_RG_EXT_PORT1)
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		   (RTK_RG_EXT_PORT0<=extSpa && extSpa<=RTK_RG_MAC10_EXT_PORT5)
#else
#error
#endif
		 	) //from phyiscal port OR ext0,2,3,4(from wifi but not slave)
		{


			if (!rg_db.systemGlobal.initParam.igmpSnoopingEnable)
			{
SNOOPING_DIS:
				egress_filter_portmask = RTK_RG_ALL_REAL_SLAVE_EXT_PORTMASK;
				TRACE("Flood to all VLAN-matched Slave WIFI intf!");
			}
			else
			{
				TRACE("Flood to IGMP indicated Slave WIFI intf!");
				if( !((pPktHdr->tagif&IGMP_TAGIF) || (pPktHdr->tagif&IPV6_MLD_TAGIF)) )
				{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)

					struct rtl_multicastDataInfo multicastDataInfo;
					struct rtl_multicastFwdInfo multicastFwdInfo;
					int retVal;

					bzero(&multicastDataInfo, sizeof(struct rtl_multicastDataInfo));
					multicastDataInfo.vlanId = rg_db.pktHdr->internalVlanID;

					if((pPktHdr->tagif & IPV4_TAGIF && rg_db.systemGlobal.multicastProtocol == RG_MC_MLD_ONLY)|| (pPktHdr->tagif & IPV6_TAGIF && rg_db.systemGlobal.multicastProtocol == RG_MC_IGMP_ONLY))
						goto SNOOPING_DIS;

					if (pPktHdr->tagif & IPV4_TAGIF)
					{
						multicastDataInfo.ipVersion = IP_VERSION4;
						multicastDataInfo.sourceIp[0] = pPktHdr->ipv4Sip;
						multicastDataInfo.groupAddr[0] = pPktHdr->ipv4Dip;

					}
					else if (pPktHdr->tagif & IPV6_TAGIF)
					{
						multicastDataInfo.ipVersion=IP_VERSION6;
						multicastDataInfo.groupAddr[0] = (pPktHdr->pIpv6Dip[0] <<12)+(pPktHdr->pIpv6Dip[1] <<8)+(pPktHdr->pIpv6Dip[2] <<4)+(pPktHdr->pIpv6Dip[3]);
						multicastDataInfo.groupAddr[1] = (pPktHdr->pIpv6Dip[4] <<12)+(pPktHdr->pIpv6Dip[5] <<8)+(pPktHdr->pIpv6Dip[6] <<4)+(pPktHdr->pIpv6Dip[7]);
						multicastDataInfo.groupAddr[2] = (pPktHdr->pIpv6Dip[8] <<12)+(pPktHdr->pIpv6Dip[9] <<8)+(pPktHdr->pIpv6Dip[10]<<4)+(pPktHdr->pIpv6Dip[11]);
						multicastDataInfo.groupAddr[3] = (pPktHdr->pIpv6Dip[12]<<12)+(pPktHdr->pIpv6Dip[13]<<8)+(pPktHdr->pIpv6Dip[14]<<4)+(pPktHdr->pIpv6Dip[15]);
						multicastDataInfo.sourceIp[0] = (pPktHdr->pIpv6Sip[0] <<12)+(pPktHdr->pIpv6Sip[1] <<8)+(pPktHdr->pIpv6Sip[2] <<4)+(pPktHdr->pIpv6Sip[3]);
						multicastDataInfo.sourceIp[1] = (pPktHdr->pIpv6Sip[4] <<12)+(pPktHdr->pIpv6Sip[5] <<8)+(pPktHdr->pIpv6Sip[6] <<4)+(pPktHdr->pIpv6Sip[7]);
						multicastDataInfo.sourceIp[2] = (pPktHdr->pIpv6Sip[8] <<12)+(pPktHdr->pIpv6Sip[9] <<8)+(pPktHdr->pIpv6Sip[10]<<4)+(pPktHdr->pIpv6Sip[11]);
						multicastDataInfo.sourceIp[3] = (pPktHdr->pIpv6Sip[12]<<12)+(pPktHdr->pIpv6Sip[13]<<8)+(pPktHdr->pIpv6Sip[14]<<4)+(pPktHdr->pIpv6Sip[15]);

					}
					else
					{
						IGMP("ignore non-IPv4 or non-IPv6 MC packet");
					}

					retVal = rtl_getMulticastDataFwdInfo(rg_db.systemGlobal.nicIgmpModuleIndex, &multicastDataInfo, &multicastFwdInfo);
					if (retVal!=SUCCESS)
					{
						DEBUG("FAIL: rtl_getMulticastDataFwdInfo\n");
					}

					if ((multicastFwdInfo.srcFilterMode==RTK_RG_IPV4MC_INCLUDE) ||
						(multicastFwdInfo.srcFilterMode==RTK_RG_IPV4MC_DONT_CARE_SRC))
					{
						if (!(multicastFwdInfo.fwdPortMask & RTK_RG_ALL_REAL_SLAVE_EXT_PORTMASK)) //0x100
						{
							DEBUG("in/dc-mode IGMP indicat slave wifi port");
							egress_filter_portmask = (1<<RTK_RG_EXT_PORT1);
						}
					}
					else if (multicastFwdInfo.srcFilterMode==RTK_RG_IPV4MC_EXCLUDE)
					{
						if (!(multicastFwdInfo.l2PortMask & RTK_RG_ALL_REAL_SLAVE_EXT_PORTMASK)) //0x100
						{
							DEBUG("ex-mode IGMP indicat slave wifi port");
							egress_filter_portmask = (1<<RTK_RG_EXT_PORT1);
						}
					}
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
					// 9607C just sent to slave WIFI
					egress_filter_portmask = (1<<RTK_RG_EXT_PORT1);
					TRACE("Multicast Data Sent to Slave WIFI intf!");

#endif
				}
				else
				{
					egress_filter_portmask = (1<<RTK_RG_EXT_PORT1);
					TRACE("IGMP_MLD report/query Flood to all VLAN-matched Slave WIFI intf!");
				}
			}

			_rtk_rg_igmpLeave_portmask_check_and_limit(pPktHdr, &egress_filter_portmask);
			_rtk_rg_igmpReport_portmask_check_and_limit(pPktHdr, &egress_filter_portmask);
			_rtk_rg_igmpMldQuery_portmask_check_and_limit(pPktHdr, &egress_filter_portmask,NULL);
			if(egress_filter_portmask==0x0)
				goto send_to_slave_wifi_end;

			// WLAN port (tag & untag)
			bcSkb=rtk_rg_skbCopyToPreAllocSkb(skb);
			if(bcSkb==NULL) goto OUT_OF_MEM;

			pPktHdr->egressVlanID=CONFIG_DEFAULT_TO_SLAVE_GMAC_VID;
			pPktHdr->egressVlanTagif=1;
			pPktHdr->egressPriority=CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI;

			rg_kernel.txDesc.tx_dislrn=1; // patch for reason 192
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			rg_kernel.txDesc.tx_keep=0; 			//dirtx case: keep must be zero.
			rg_kernel.txDesc.tx_l34_keep=0;			//HWLOOKUP, dirTx(l34_keep) must be zero
#else
			rg_kernel.txDesc.tx_keep=1; 			//20141104LUKE: when L34Keep is on, Keep is also needed for gpon.
			rg_kernel.txDesc.tx_l34_keep=1;
#endif
			rg_kernel.txDesc.tx_tx_portmask=0; //HWLOOKUP (because: HW do not have extension port & CPU port bit)

			//txinfo_debug(&rg_kernel.txDesc);
			//memDump(bcSkb->data,bcSkb->len,"BC-to-WIFI2");
			TRACE("Broadcast to slave WLAN by GMAC(VID=%d,PRI=%d,HWLOOKUP)",CONFIG_DEFAULT_TO_SLAVE_GMAC_VID,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI);

			{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				if(_modifyPacketByMulticastDecision(bcSkb,pPktHdr,1<<RTK_RG_MAC7_EXT_PORT0)==RT_ERR_RG_FAILED)
					_rtk_rg_dev_kfree_skb_any(bcSkb);
#endif
				aclRet = _rtk_rg_modifyPacketByACLAction(bcSkb,pPktHdr,RTK_RG_EXT_PORT1);
				if(aclRet==RG_FWDENGINE_RET_DROP ){
					_rtk_rg_dev_kfree_skb_any(bcSkb);
				}else{
					_rtk_rg_egressPacketSend(bcSkb,pPktHdr);
				}
			}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			if((aclRet == RG_FWDENGINE_RET_CONTINUE) && (pPktHdr->aclDecision.aclEgrDoneAction & RG_EGR_FLOWMIB_ACT_DONE_BIT))
			{
				flowmibIdx = pPktHdr->aclDecision.action_flowmib_counter_idx;
				_rtk_rg_fwdEngine_flowEgressCountPredict(pPktHdr, &ingressByteCnt, &egressPktCnt, &egressByteCnt);
			}

			if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision) && rg_db.systemGlobal.hwnat_enable==1)
			{
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
				//for(i=RTK_RG_MAC7_EXT_PORT0;i<=RTK_RG_MAC7_EXT_PORT5  ;i++)
				//{
					_rtk_rg_multicastRecordFlowData(&path3action,&path4action,&pPktHdr->McFlowPath3PortMsk,&pPktHdr->McFlowPath4PortMsk,&pPktHdr->McFlowPath3ExtPortMsk,&pPktHdr->McFlowPath4ExtPortMsk,pPktHdr,1<<RTK_RG_MAC7_EXT_PORT0,pPktHdr->multicastMacPortMask.portmask);
				//}
#else
#error
#endif

			}
#endif


		}
	}
	else
	{
		TRACE("No BC to slave");
	}

	send_to_slave_wifi_end:

	//20170601LUKE: reassign pktHdr value for consistent.
	pPktHdr->internalVlanID = internalVlanID;
	pPktHdr->egressVlanID = internalVlanID;
	pPktHdr->l3Offset = l3Offset_ori;
	pPktHdr->l4Offset = l4Offset_ori;
	pPktHdr->egressVlanTagif = tagif_ori;
	if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
		pPktHdr->l3Modify =0;
#endif
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// lan port flow-mib action may be different from pon port.
	// count wifi flow mib for each extension port?
	// pPktHdr->flowMIBCounterIdx was not maintained well, so do not use the index as flow mib counting reference.
	if(flowmibIdx==flowmibIdx_wan)
	{
		// prevent to count ingress packet/byte counter twice.
		_rtk_rg_fwdEngine_flowMIBUpdate(flowmibIdx, ingressByteCnt, egressPktCnt+egressPktCnt_wan, egressByteCnt+egressByteCnt_wan);
	}
	else
	{
		_rtk_rg_fwdEngine_flowMIBUpdate(flowmibIdx, ingressByteCnt, egressPktCnt, egressByteCnt);
		_rtk_rg_fwdEngine_flowMIBUpdate(flowmibIdx_wan, ingressByteCnt, egressPktCnt_wan, egressByteCnt_wan);
	}

#endif

	//20170222LUKE: for multicast data packet, we should not send to protocol stack.
	if (FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
	{
		TRACE("multicast data forward stop here!");
		return RG_FWDENGINE_RET_DROP;
	}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Check VLAN contain CPU port or not
	if((0x1<<srcPort) & RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK) //from cpu filter core0/core1
		dpMask=rg_db.vlan[internalVlanID].MemberPortmask.bits[0]&(~(RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK));
	else
#endif
	{
		//Check VLAN contain CPU port or not
		dpMask=rg_db.vlan[internalVlanID].MemberPortmask.bits[0]&(~(0x1<<srcPort));
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#else
		//check to export only for wifi, or actually include CPU port and need to PS
		if(rg_db.vlan[internalVlanID].Ext_portmask.bits[0]&(0x1<<RTK_RG_MAC_EXT_CPU))
		{
			internal_vlan_to_ps = 1;
		}
		else
		{
			internal_vlan_to_ps = 0;
		}
		//DEBUG("internalVlanID=%d Ext_portmask=0x%x",internalVlanID,rg_db.vlan[internalVlanID].Ext_portmask.bits[0]);
		//DEBUG("internal_vlan_to_ps = %d",internal_vlan_to_ps);
#endif
	}

	//DEBUG("dpMask=%x srcPort=%d vlan[%d].mbr=%x extspa=%d",dpMask,srcPort,internalVlanID,rg_db.vlan[internalVlanID].MemberPortmask.bits[0],extSpa);

	//if(((dpMask&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)>0)||(extSpa>RTK_RG_PORT_LASTCPU)) //from EXT Port shall not be src block.
	if((((dpMask&RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK)>0)||(extSpa>RTK_RG_PORT_LASTCPU))
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#else
		&& internal_vlan_to_ps==1
#endif
	)
	{

		//last packet to CPU, if no need to send just return DROP.
		egress_filter_portmask = RTK_RG_ALL_CPU_PORTMASK;
		_rtk_rg_igmpLeave_portmask_check_and_limit(pPktHdr, &egress_filter_portmask);
		_rtk_rg_igmpReport_portmask_check_and_limit(pPktHdr, &egress_filter_portmask);
		_rtk_rg_igmpMldQuery_portmask_check_and_limit(pPktHdr, &egress_filter_portmask,NULL);
		if(egress_filter_portmask==0x0)
		{
			TRACE("[Drop] after portmask checking of igmp and mld, drop!");
			return RG_FWDENGINE_RET_DROP;
		}


		//the original packet continue to protocol stack
		//DEBUG("the original packet continue to protocol stack!");
		//if(cpSkb) _rtk_rg_dev_kfree_skb_any(cpSkb);
		if(pPktHdr->fwdDecision==RG_FWD_DECISION_NO_PS_BC)
		{
			TRACE("[Drop] fwdDecision: RG_FWD_DECISION_NO_PS_BC, drop!");
			return RG_FWDENGINE_RET_DROP;
		}
		//20150616LUKE: sometimes pppoe proxy only allow pppoe-wan-binding packet. if so, we just drop here.
		if(rg_db.systemGlobal.initParam.macBasedTagDecision && rg_db.systemGlobal.pppoeProxyAllowBindingOnly && (pPktHdr->etherType==0x8863)){
			if((_rtk_rg_bindingRuleCheck(pPktHdr, &groupIdx)!=RG_FWDENGINE_RET_HIT_BINDING)||
				(rg_db.systemGlobal.wanIntfGroup[groupIdx].p_wanIntfConf->wan_type!=RTK_RG_PPPoE))
				{
					TRACE("[Drop] pppoe proxy only allow pppoe-wan-binding packet, drop!");
					return RG_FWDENGINE_RET_DROP;
				}
		}

		//REC20131224:recovery egressVlanID which replaced by slave Wifi settings
		pPktHdr->egressVlanID=internalVlanID;
		pPktHdr->egressVlanTagif=((rg_db.vlan[internalVlanID].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_MAINCPU))==0);
		if(rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT_MAINCPU]==RTK_RG_ENABLED)//Qos dotip remarking by internal
			pPktHdr->egressPriority=pPktHdr->internalPriority;
		else//no Qos dot1p remarking
			pPktHdr->egressPriority=pPktHdr->ctagPri;

		//special case: to CPU, check the gponDsBcFilter by original skb, not copied skb.
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		if(rg_db.systemGlobal.gponDsBCModuleEnable && ( (1<<pPktHdr->ingressPort) & (rg_db.systemGlobal.wanPortMask.portmask)) && (pPktHdr->pDmac[0]&0x1 ) )
#else
		if(rg_db.systemGlobal.gponDsBCModuleEnable && (pPktHdr->ingressPort==RTK_RG_PORT_PON) && (((pPktHdr->pDmac[0]&pPktHdr->pDmac[1]&pPktHdr->pDmac[2]&pPktHdr->pDmac[3]&pPktHdr->pDmac[4]&pPktHdr->pDmac[5])==0xff)||(pPktHdr->pDmac[0]==0x01 && pPktHdr->pDmac[1]==0x00 && pPktHdr->pDmac[2]==0x5e)) && (rg_db.systemGlobal.initParam.wanPortGponMode==1))//must be GPON, BC, from PON
#endif
		{
			_rtk_rg_egressPacketSend_for_gponDsBcFilterAndRemarking(skb,pPktHdr,2);
		}

		TRACE("[To PS] VLAN contain CPU port, trap to PS.");
		return RG_FWDENGINE_RET_TO_PS;
	}
	else
	{
		//_rtk_rg_dev_kfree_skb_any(skb);
		TRACE("[Drop] the original packet stop here...internalVlanID=%d dpMask=%x srcPort=%x vlan[%x]",internalVlanID,dpMask,srcPort,rg_db.vlan[internalVlanID].MemberPortmask.bits[0]);
		//if(cpSkb) _rtk_rg_dev_kfree_skb_any(cpSkb);
		return RG_FWDENGINE_RET_DROP;
	}


OUT_OF_MEM:
#if defined(CONFIG_RG_RTL9600_SERIES)
	if(skb->len>SKB_BUF_SIZE)
		DEBUG("[Drop] Fail to get free skb buffer");
	else
#endif
		WARNING("[Drop] Fail to get free skb buffer");
#if RTK_RG_SKB_PREALLOCATE
	FIXME("Out of pre-alloc memory(%s:%d)\n",__FUNCTION__,__LINE__);
#else
	FIXME("Out of memory(%s:%d)\n",__FUNCTION__,__LINE__);
#endif

BC_PROCESS_END:
	if(bcSkb) _rtk_rg_dev_kfree_skb_any(bcSkb);
	//if(cpSkb) _rtk_rg_dev_kfree_skb_any(cpSkb);
	TRACE("[Drop] End of broadcast process.");
	return RG_FWDENGINE_RET_DROP;

	//return RG_FWDENGINE_RET_DIRECT_TX;
}

int _rtk_rg_layer2GarbageCollection(int l2Idx)
{
#if defined(CONFIG_RG_G3_SERIES)	// CONFIG_RG_G3_SERIES_DEVELOPMENT
	return MAX_LUT_HASH_WAY_SIZE;
#else	//1 NOT G3
	int search_idx,count=0,ret,i,invalidNum=0,smallestIdx=MAX_LUT_HASH_WAY_SIZE;
	rtk_l2_addr_table_t l2Entry;
	rtk_rg_port_idx_t portIdx;

	DEBUG("_rtk_rg_layer2GarbageCollection, l2Idx is %d",l2Idx);
	//Compare from l2Idx, if the entry in software table is not in hardware table anymore, the entry will be used for new entry
	do
	{
		search_idx=l2Idx+count;
		l2Entry.method = LUT_READ_METHOD_NEXT_ADDRESS;
		ret=rtk_l2_nextValidEntry_get(&search_idx,&l2Entry);
		if(ret!=RT_ERR_OK)
			return MAX_LUT_HASH_WAY_SIZE;

		if(search_idx>=l2Idx+MAX_LUT_HASH_WAY_SIZE || search_idx<l2Idx)	//no valid entry in this 4-way hased address
		{
			//reset lasting software LUT table to invalid
			invalidNum=MAX_LUT_HASH_WAY_SIZE-count;
			DEBUG("the index after %d is invalid in hw table, so invalid the lasting %d software entries!!",l2Idx+count,invalidNum);

			//------------------ Critical Section start -----------------------//
			//rg_lock(&rg_kernel.saLearningLimitLock);
			_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[l2Idx+count].rtk_lut.entry.l2UcEntry.port, rg_db.lut[l2Idx+count].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
			_rtk_rg_lutExtport_translator(&portIdx);
#endif
			if(rg_db.lut[l2Idx+count].countingInLearningLimit)
				assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[l2Idx+count].wlan_device_idx));

			//20170222: wan access limit only counts SVL lut entry
			if((rg_db.lut[l2Idx+count].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
			{
				//20170301LUKE: modify count when limit field is source mac.
				if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
				{
					if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx) && rg_db.lut[l2Idx+count].permit_for_l34_forward)
						atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
					if(_rtK_rg_checkCategoryPortmask_spa(portIdx)==SUCCESS)
						atomic_dec(&rg_db.systemGlobal.accessWanLimitCategoryCount[(unsigned int)rg_db.lut[l2Idx+count].category]);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					if(portIdx > RTK_RG_PORT_LASTCPU)
					{
						//decrease wlan's device count
						if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
							) && rg_db.lut[l2Idx+count].wlan_device_idx>=0)
						{
							//20170301LUKE: modify count when limit field is source mac.
								if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[l2Idx+count].wlan_device_idx)))
									atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
						}
					}
#endif	
				}
			}
			//------------------ Critical Section End -----------------------//
			//rg_unlock(&rg_kernel.saLearningLimitLock);
			memset(&rg_db.lut[l2Idx+count],0,(sizeof(rtk_rg_table_lut_t)*invalidNum));
			if(smallestIdx>count)
				smallestIdx=count;
			break;
		}

		invalidNum=search_idx-(l2Idx+count);		//how many invalid entries between start_idx and return_idx
		for(i=0;i<invalidNum;i++)
		{
			if(smallestIdx>(count+i))
				smallestIdx=count+i;
			DEBUG("invalid the index %d in software table",l2Idx+count);

			//------------------ Critical Section start -----------------------//
			//rg_lock(&rg_kernel.saLearningLimitLock);
			_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[l2Idx+count].rtk_lut.entry.l2UcEntry.port, rg_db.lut[l2Idx+count].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
			_rtk_rg_lutExtport_translator(&portIdx);
#endif
			if(rg_db.lut[l2Idx+count].countingInLearningLimit)
				assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[l2Idx+count].wlan_device_idx));

			//20170222: wan access limit only counts SVL lut entry
			if((rg_db.lut[l2Idx+count].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
			{
				//20170301LUKE: modify count when limit field is source mac.
				if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
				{
					if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx) && rg_db.lut[l2Idx+count].permit_for_l34_forward)
						atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
					if(_rtK_rg_checkCategoryPortmask_spa(portIdx)==SUCCESS)
						atomic_dec(&rg_db.systemGlobal.accessWanLimitCategoryCount[(unsigned int)rg_db.lut[l2Idx+count].category]);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					if(portIdx > RTK_RG_PORT_LASTCPU)
					{
						//decrease wlan's device count
						if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
							) && rg_db.lut[l2Idx+count].wlan_device_idx>=0)
						{
							//20170301LUKE: modify count when limit field is source mac.
								if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[l2Idx+count].wlan_device_idx)))
									atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
						}
					}
#endif	
				}
			}
			//------------------ Critical Section End -----------------------//
			//rg_unlock(&rg_kernel.saLearningLimitLock);
			memset(&rg_db.lut[l2Idx+count],0,sizeof(rtk_rg_table_lut_t));		//clean invalid entries
		}

		count+=(invalidNum+1);
	}while(count<MAX_LUT_HASH_WAY_SIZE);

	DEBUG("the return of smallestIdx is %d",smallestIdx);
	return smallestIdx;
#endif
}

void _rtk_rg_layer2CleanL34ReferenceTable(int l2Idx)
{
	int i,k;
	ipaddr_t victim_ip;	//may be more than one

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Delete flow entry
	//20170721LUKE: search flow with l2idx only for hw lut.
	if(l2Idx>=0 && l2Idx<MAX_LUT_HW_TABLE_SIZE)
		assert_ok(_rtk_rg_flow_del_by_l2Idx(l2Idx));

#else //1 not CONFIG_RG_FLOW_BASED_PLATFORM

#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	rtk_rg_ipv6_layer4_linkList_t *pV6L4List,*nextEntry;
#endif

#ifdef CONFIG_ROME_NAPT_SHORTCUT
	for(i=0; i<MAX_NAPT_SHORTCUT_SIZE; i++)
	{
#if defined(CONFIG_RG_RTL9600_SERIES)
		if(RG_V4SC_VALID(i) && rg_db.naptShortCut[i].new_lut_idx==l2Idx)
#else	//support lut traffic bit
		if(RG_V4SC_VALID(i) && (rg_db.naptShortCut[i].new_lut_idx==l2Idx || rg_db.naptShortCut[i].smacL2Idx==l2Idx))
#endif
		{
			TABLE("del v4 shortcut[%d].", i);
			_rtk_rg_v4ShortCut_delete(i);
		}
	}
#endif

#ifdef CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT
	for(i=0; i<MAX_NAPT_V6_SHORTCUT_SIZE; i++)
	{
#if defined(CONFIG_RG_RTL9600_SERIES)
		if(RG_V6SC_VALID(i) && rg_db.naptv6ShortCut[i].new_lut_idx==l2Idx)
#else	//support lut traffic bit
		if(RG_V6SC_VALID(i) && (rg_db.naptv6ShortCut[i].new_lut_idx==l2Idx || rg_db.naptv6ShortCut[i].smacL2Idx==l2Idx))
#endif
		{
			TABLE("del v6 shortcut[%d].", i);
			_rtk_rg_v6ShortCut_delete(i);
		}
	}
#endif

#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	for(i=0; i<MAX_IPV6_STATEFUL_HASH_HEAD_SIZE; i++)
	{
		list_for_each_entry_safe(pV6L4List,nextEntry,&rg_db.ipv6Layer4HashListHead[i],layer4_list)
		{
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(pV6L4List->dmacL2Idx==l2Idx)
#else	//support lut traffic bit
			if(pV6L4List->dmacL2Idx==l2Idx || pV6L4List->smacL2Idx==l2Idx)
#endif
			{
				TABLE("del v6 stateful shortcut.");
				//------------------ Critical Section start -----------------------//
				rg_lock(&rg_kernel.ipv6StatefulLock);
				_rtk_rg_fwdEngine_ipv6ConnList_del(pV6L4List);
				//------------------ Critical Section End -----------------------//
				rg_unlock(&rg_kernel.ipv6StatefulLock);
			}
		}
	}
#endif

#endif


	//WARNING("  choose victim from arp_used entry:%d",first_dynArp);
	for(i=0;i<MAX_ARP_SW_TABLE_SIZE;i++)
	{
		if(rg_db.arp[i].rtk_arp.valid && rg_db.arp[i].rtk_arp.nhIdx==l2Idx)
		{
			//look up for napt DIP are same with victim
			victim_ip=rg_db.arp[i].ipv4Addr;
			//WARNING("  Found ARP!! ip is %x",victim_ip);

			for(k=0;k<MAX_NAPT_OUT_SW_TABLE_SIZE;k++)
			{
				int inIdx=rg_db.naptOut[k].rtk_naptOut.hashIdx;
				if(rg_db.naptOut[k].state>0 &&  ((rg_db.naptOut[k].remoteIp==victim_ip)||(rg_db.naptIn[inIdx].rtk_naptIn.intIp==victim_ip)))
				{
					//Delete arp entry!!
					assert_ok(rtk_rg_apollo_naptConnection_del(k));
				}
			}

			//Deleting the ARP and the dynamic bCAM LUT
			assert_ok(rtk_rg_apollo_arpEntry_del(i));
		}
	}

	//scan NXP for deleting entries reference to this LUT entry
	//20140806LUKE: nexthop always point to static LUT which won't be deleted here!
	/*for(i=0;i<MAX_NEXTHOP_HW_TABLE_SIZE;i++)
	{
		if(rg_db.nexthop[i].rtk_nexthop.nhIdx==l2Idx)
		{
			//WARNING("  Found NXP!! idx is %d",i);
			//Delete nexthop entry!!
			WARNING("nexthop[%d] count is %d",j,rg_db.systemGlobal.nxpRefCount[j]);
			assert_ok(_rtk_rg_decreaseNexthopReference(i));
		}
	}*/

	//scan neighbor table for deleting entries reference to this LUT entry
	for(i=0;i<MAX_IPV6_NEIGHBOR_SW_TABLE_SIZE;i++)
	{
		if(rg_db.v6neighbor[i].neighborEntry.valid && rg_db.v6neighbor[i].neighborEntry.staticEntry==0 && rg_db.v6neighbor[i].neighborEntry.l2Idx==l2Idx)
		{
			//WARNING("  Found Neighbor!! idx is %d",i);
			//Detele neighbor entry!!
			assert_ok(rtk_rg_apollo_neighborEntry_del(i));
		}
	}
}


rtk_rg_entryGetReturn_t _rtk_rg_layer2LeastRecentlyUsedReplace(int l2Idx, int lutGroupIdx /*does not LRU lut entries in this lut group*/)
{

#if defined(CONFIG_RG_LAYER2_SOFTWARE_LEARN)

#if defined(CONFIG_RG_RTL9600_SERIES)

	//when the 4-way is full, check the bCAM list for free to add,
	//if the bCAM is also full, look for victim which dynamic unicast first,
	//when there is no more dynamic unicast victim could choose, find a arp-used entry for the victim,
	//first scan all arp-used entries in ARP table, choose no arp entries first, if there is no such l2 entry,
	//choose arp-used and really referenced by ARP entry,
	//scan all ARP, NXP, NAPT, shortcut for referencing this entry and delete it.

	//arpState=0, means no arp entry referenced
	//arpState=1, means arp entry referenced, but arp is dynamic
	//arpState=2, means arp entry referenced, and arp is static
	//arpState=4, means no neighbor entry referenced
	//arpState=8, means neighbor entry referenced, but neighbor is dynamic
	//arpState=16, means neighbor entry referenced, and neighbor is static

	//first_dyn: first L2 entry which it's not static and not arp-used.
	//first_noArp: first L2 entry which it's arp-used(non-static) and not referenced by arp or neighbor entry.
	//first_dynArp: first L2 entry which it's arp-used(non-static) and referenced by arp or neighbor entry.
	int ret,first_dyn=0,first_noArp=0,first_dynArp=0,victim_idx=FAIL;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else
	int i,lut_arpState=0;
#endif
	rtk_rg_lut_linkList_t *pLutBCAMList,*pNextLutBCAMList,*pDynBCAMList=NULL,*pNoArpBCAMList=NULL,*pDynArpBCAMList=NULL;
	rtk_mac_t first_dynArp_mac;

RECHOOSE_BYPASS:
	list_for_each_entry(pLutBCAMList,&rg_db.lutBCAMLinkListHead,lut_list)
	{
		if(rg_db.lut[pLutBCAMList->idx].valid)
		{
			if(rg_db.lut[pLutBCAMList->idx].rtk_lut.entryType==RTK_LUT_L2UC && _rtk_rg_isInLutGroup(lutGroupIdx, pLutBCAMList->idx)==FALSE)
			{
				if(first_dyn==0 && ((rg_db.lut[pLutBCAMList->idx].rtk_lut.entry.l2UcEntry.flags&(RTK_L2_UCAST_FLAG_STATIC|RTK_L2_UCAST_FLAG_ARP_USED))==0) &&  _rtk_rg_lut_is_sw_static(pLutBCAMList->idx)==FALSE)	//dynamic
				{
					first_dyn=pLutBCAMList->idx;
					pDynBCAMList=pLutBCAMList;
				}
//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
				else if((first_noArp==0) && ((rg_db.lut[pLutBCAMList->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0) &&  _rtk_rg_lut_is_sw_static(pLutBCAMList->idx)==FALSE) //non-static and arp-used
				{
					first_noArp=pLutBCAMList->idx;
					pNoArpBCAMList=pLutBCAMList;
				}
#else
				else if((first_noArp==0||first_dynArp==0) && ((rg_db.lut[pLutBCAMList->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0) &&  _rtk_rg_lut_is_sw_static(pLutBCAMList->idx)==FALSE)	//non-static and arp-used
				{
					lut_arpState=0;
					//Check if this arp-used lut did not really referenced by ARP
					for(i=0;i<MAX_ARP_SW_TABLE_SIZE;i++)
					{
						if(rg_db.arp[i].rtk_arp.valid && rg_db.arp[i].rtk_arp.nhIdx==pLutBCAMList->idx)
						{
							if(rg_db.arp[i].staticEntry)
								lut_arpState=2;
							else
								lut_arpState=1;
							break;
						}
					}
					lut_arpState+=4;
					for(i=0;i<MAX_IPV6_NEIGHBOR_SW_TABLE_SIZE;i++)
					{
						if(rg_db.v6neighbor[i].neighborEntry.valid && rg_db.v6neighbor[i].neighborEntry.l2Idx==pLutBCAMList->idx)
						{
							if(rg_db.v6neighbor[i].neighborEntry.staticEntry)
								lut_arpState+=16;
							else
								lut_arpState+=8;
							break;
						}
					}
					if(lut_arpState==4 && first_noArp==0)
					{
						first_noArp=pLutBCAMList->idx;
						pNoArpBCAMList=pLutBCAMList;
					}
					else if((lut_arpState==5||lut_arpState==12||lut_arpState==13) && first_dynArp==0)		//this bCAM entry can be deleted because it is not referenced by static ARP or neighbor!!
					{
						first_dynArp=pLutBCAMList->idx;
						pDynArpBCAMList=pLutBCAMList;
					}
				}
#endif
			}
		}
		else
		{
			//WARNING("add to bCAM idx %d!!",pLutBCAMList->idx);
			return pLutBCAMList->idx;	//find empty, use it
		}
	}

	//WARNING("bCAM is full....");

	//if there is  bCAM had been deleted, move from chosen list back
	if(!list_empty(&rg_db.lutBCAMChosenLinkListHead))
	{
		list_for_each_entry_safe(pLutBCAMList,pNextLutBCAMList,&rg_db.lutBCAMChosenLinkListHead,lut_list)
		{
			if(rg_db.lut[pLutBCAMList->idx].valid==0)
			{
				//WARNING("ADD BACK chosen victim[%d] before return!",pLutBCAMList->idx);
				list_move(&pLutBCAMList->lut_list,&rg_db.lutBCAMLinkListHead);
				return pLutBCAMList->idx;	//find empty, use it
			}
		}
	}

	if(first_dyn!=0)
	{
		//choose this dynamic unicast entry as victim!!
		//invalid the LRU entry, otherwise the new entry won't add
		ret=(pf.rtk_rg_macEntry_del)(first_dyn);
		if(ret!=RT_ERR_OK)
		{
			WARNING("Layer2LRU failed when deleting Dynamic victim[%d]...ret=%x",first_dyn,ret);
		}
		else
		{
			list_move(&pDynBCAMList->lut_list,&rg_db.lutBCAMChosenLinkListHead);
			victim_idx=first_dyn;
			DEBUG("  choose victim from dynamic entry:%d",victim_idx);
		}
	}
	else if(first_noArp!=0)
	{
		//choose this arp-used but no ARP unicast entry as victim!!
		//invalid the LRU entry, otherwise the new entry won't add
		ret=(pf.rtk_rg_macEntry_del)(first_noArp);
		if(ret!=RT_ERR_OK)
		{
			WARNING("Layer2LRU failed when deleting noArp victim[%d]...ret=%x",first_noArp,ret);
		}
		else
		{
			list_move(&pNoArpBCAMList->lut_list,&rg_db.lutBCAMChosenLinkListHead);
			victim_idx=first_noArp;
			DEBUG("  choose victim from noArp entry:%d",victim_idx);
		}
	}
	else
	{
		//WARNING("check if the bCAM is referenced by static ARP...");
		//scan ARP, NAPT and shortcut for deleting entries reference to this LUT entry
		/*list_for_each_entry(pLutBCAMList,&rg_db.lutBCAMLinkListHead,lut_list)
		{
			if(rg_db.lut[pLutBCAMList->idx].valid)
			{
				if(rg_db.lut[pLutBCAMList->idx].rtk_lut.entryType==RTK_LUT_L2UC)
				{
					if((rg_db.lut[pLutBCAMList->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0 && (rg_db.lut[pLutBCAMList->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)>0)	//arp_used, dynamic
					{
						arp_static=0;
						//Check if this lut referenced by static ARP
						for(i=0;i<MAX_ARP_SW_TABLE_SIZE;i++)
						{
							if(rg_db.arp[i].rtk_arp.valid && rg_db.arp[i].rtk_arp.nhIdx==pLutBCAMList->idx && rg_db.arp[i].staticEntry)
							{
								arp_static=1;
								break;
							}
						}
						if(arp_static==0)		//this bCAM entry can be deleted because it is not referenced by static ARP!!
						{
							first_dynArp=pLutBCAMList->idx;
							break;
						}
					}
				}
			}
		}*/
		//WARNING("  the arp_static is %d, first_dynArp is %d",arp_static,first_dynArp);
		if(first_dynArp!=0)
		{
			memcpy(&first_dynArp_mac,&rg_db.lut[first_dynArp].rtk_lut.entry.l2UcEntry.mac,sizeof(rtk_mac_t));

			//invalid the LRU entry, otherwise the new entry won't add
			if(rg_db.lut[first_dynArp].valid && rg_db.lut[first_dynArp].rtk_lut.entryType==RTK_LUT_L2UC && memcmp(&rg_db.lut[first_dynArp].rtk_lut.entry.l2UcEntry.mac,&first_dynArp_mac,sizeof(rtk_mac_t))==0)
			{
				ret=(pf.rtk_rg_macEntry_del)(first_dynArp);
				if(ret!=RT_ERR_OK)
				{
					WARNING("Layer2LRU failed when deleting Arp victim[%d]...ret=%x",first_dynArp,ret);
				}
				else
				{
					list_move(&pDynArpBCAMList->lut_list,&rg_db.lutBCAMChosenLinkListHead);
					victim_idx=first_dynArp;
					//DEBUG("  choose victim from arp entry:%d",victim_idx);
				}
			}
			else
			{
				_rtk_rg_layer2CleanL34ReferenceTable(first_dynArp);
				list_move(&pDynArpBCAMList->lut_list,&rg_db.lutBCAMChosenLinkListHead);
				victim_idx=first_dynArp;
				//DEBUG("  choose victim from arp entry:%d",victim_idx);
			}
		}
		else
		{
			//re-add before victim, and rechoose again!
			list_for_each_entry_safe(pLutBCAMList,pNextLutBCAMList,&rg_db.lutBCAMChosenLinkListHead,lut_list)
			{
				//DEBUG("ADD BACK chosen victim[%d] before...rechoose again",pLutBCAMList->idx);
				list_move(&pLutBCAMList->lut_list,&rg_db.lutBCAMLinkListHead);
			}
			goto RECHOOSE_BYPASS;
		}
	}

	//re-add all before victim back for next time choose
	if(list_empty(&rg_db.lutBCAMLinkListHead))
	{
		list_for_each_entry_safe(pLutBCAMList,pNextLutBCAMList,&rg_db.lutBCAMChosenLinkListHead,lut_list)
		{
			//DEBUG("ADD BACK chosen victim[%d] before return!",pLutBCAMList->idx);
			list_move(&pLutBCAMList->lut_list,&rg_db.lutBCAMLinkListHead);
		}
	}

	return victim_idx;

#else	//1 support lut traffic bit

	//when the 4-way is full, check the bCAM list for free to add,
	//if the bCAM is also full, look for victim.
	//choose longest idle time entry from non-static unicast entries(same L2 hash index) as victim.

	int ret, victim_idx=FAIL;
	uint32 search_index=0, longestIdx=0, longestIdleTime=0, doLRU=FALSE;
	short count=0;
	rtk_rg_lut_linkList_t *pLutCamEntry, *pNextLutCamEntry;

	if(!list_empty(&rg_db.lutBCAMFreeListHead))
	{
		list_for_each_entry_safe(pLutCamEntry,pNextLutCamEntry,&rg_db.lutBCAMFreeListHead,lut_list)	//just return the first entry right behind of head
		{
			victim_idx = pLutCamEntry->idx;
			break;
		}

		return victim_idx;
	}
	else	// 4-way and bcam are full, do LRU
	{
		DEBUG("LutCam is full, do LRU!\n");

		l2Idx=(l2Idx>>MAX_LUT_HASH_WAY_SHIFT)<<MAX_LUT_HASH_WAY_SHIFT;
		do
		{
			search_index = l2Idx+count;

			if(search_index >= MAX_LUT_SW_TABLE_SIZE)
			{
				WARNING("Index of lut is out of range.");
				return RG_RET_ENTRY_NOT_GET;
			}

			if(rg_db.lut[search_index].valid==0) //find empty lut entry
			{
				WARNING("Expect that 4-way lut should not exist empty entry!, empty idx:%d", search_index);
				return RG_RET_ENTRY_NOT_GET;
			}
			else
			{
				if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC
					&& (rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0
					&& _rtk_rg_lut_is_sw_static(search_index)==FALSE
					&& (rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)==0
					&& _rtk_rg_isInLutGroup(lutGroupIdx, search_index)==FALSE)
				{
					if(rg_db.lut[search_index].idleSecs > longestIdleTime)
					{
						doLRU = TRUE;
						longestIdx = search_index;
						longestIdleTime = rg_db.lut[search_index].idleSecs;
					}
				}
			}

			count++; //search from next entry
		}
		while(count < MAX_LUT_HASH_WAY_SIZE);

		list_for_each_entry_safe(pLutCamEntry,pNextLutCamEntry,&rg_db.lutBCAMTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT],lut_list)
		{
			if(pLutCamEntry->idx >= MAX_LUT_SW_TABLE_SIZE)
			{
				WARNING("Index of lut cam is out of range.");
				return RG_RET_ENTRY_NOT_GET;
			}

			if(rg_db.lut[pLutCamEntry->idx].valid==0) //find empty bcam entry
			{
				WARNING("Expect that lutCam should not exist empty entry!, empty idx:%d", pLutCamEntry->idx);
				return RG_RET_ENTRY_NOT_GET;
			}
			else
			{
				if(rg_db.lut[pLutCamEntry->idx].rtk_lut.entryType==RTK_LUT_L2UC
					&& (rg_db.lut[pLutCamEntry->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0
					&& _rtk_rg_lut_is_sw_static(pLutCamEntry->idx)==FALSE
					&& (rg_db.lut[pLutCamEntry->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)==0
					&& _rtk_rg_isInLutGroup(lutGroupIdx, pLutCamEntry->idx)==FALSE)
				{
					if(rg_db.lut[pLutCamEntry->idx].idleSecs > longestIdleTime)
					{
						doLRU = TRUE;
						longestIdx = pLutCamEntry->idx;
						longestIdleTime = rg_db.lut[pLutCamEntry->idx].idleSecs;
					}
				}
			}
		}

		if(doLRU==FALSE)
		{
			uint32 i;
			for(i=0; i<MAX_LUT_HASH_WAY_SIZE; i++)
			{
				count = (rg_db.layer2NextOfNewestCountIdx[l2Idx>>MAX_LUT_HASH_WAY_SHIFT]+i)%MAX_LUT_HASH_WAY_SIZE;
				search_index = l2Idx+count;
				if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC
					&& (rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0
					&& _rtk_rg_lut_is_sw_static(search_index)==FALSE
					&& (rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)==0)
				{
					doLRU = TRUE;
					longestIdx = search_index;
					longestIdleTime = rg_db.lut[search_index].idleSecs;
					break;
				}
			}
		}

		if(doLRU)
		{
			ret = (pf.rtk_rg_macEntry_del)(longestIdx);
			if(ret!=RT_ERR_OK)
			{
				WARNING("Layer2LRU failed when deleting victim[%d]...ret=%x", longestIdx, ret);
			}
			else
			{
				victim_idx = longestIdx;
				DEBUG("Layer2LRU choose victim[%d]", victim_idx);
			}
		}
		else
		{
			WARNING("Layer2LRU failed because longestIdx can not be chosen !!");
		}

		return victim_idx;
	}
#endif
#else // end CONFIG_RG_LAYER2_SOFTWARE_LEARN
	return RG_RET_ENTRY_NOT_GET;
#endif
}


//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
int _rtk_rg_layer2HashedReplace(int l2Idx, int lutGroupIdx /*does not LRU lut entries in this lut group*/)
{
	//check each LUT entry which hashed to same index, if the age is smallest, the entry is least recently used one
	//we choose the LRU entry to be replace for the new entry;if the age are all the same, we choose the biggest index,
	//because the smallest one always means it is first add into the table, since they have the same age value, it indicate
	//that first added one has traffic as well as the last added one, therefore we choose the last added one.
	//If all 4-way are ARP_USED, choose from "next of the newest" index to be our victim.

	//arpState=0, means no arp entry referenced
	//arpState=1, means arp entry referenced, but arp is dynamic
	//arpState=2, means arp entry referenced, and arp is static
	//arpState=4, means no neighbor entry referenced
	//arpState=8, means neighbor entry referenced, but neighbor is dynamic
	//arpState=16, means neighbor entry referenced, and neighbor is static

	int search_idx,LRU_age=8,LRU_index=-1,victim_idx;
	int first_noArp=-1,first_dynArp=-1,lut_arpState=0;
	int ret,i,j;
	rtk_l2_ucastAddr_t *pL2Addr,*pL2NewAddr;
	rtk_mac_t first_dynArp_mac;

	victim_idx=rg_db.layer2NextOfNewestCountIdx[l2Idx>>MAX_LUT_HASH_WAY_SHIFT];
	search_idx=l2Idx+victim_idx;
	for(i=0;i<MAX_LUT_HASH_WAY_SIZE;i++)
	{
		if(search_idx<0) break;
		if(rg_db.lut[search_idx].valid==0)
		{
			//free, use it
			return LRU_index;
		}
		else if(rg_db.lut[search_idx].rtk_lut.entryType==RTK_LUT_L2UC && _rtk_rg_isInLutGroup(lutGroupIdx, search_idx)==FALSE)
		{
			if(((rg_db.lut[search_idx].rtk_lut.entry.l2UcEntry.flags&(RTK_L2_UCAST_FLAG_STATIC|RTK_L2_UCAST_FLAG_ARP_USED))==0) && _rtk_rg_lut_is_sw_static(search_idx)==FALSE)
			{
				//Dynamic
				if(rg_db.lut[search_idx].rtk_lut.entry.l2UcEntry.age<LRU_age)
				{
					LRU_age=rg_db.lut[search_idx].rtk_lut.entry.l2UcEntry.age;
					LRU_index=search_idx;
				}
			}
			else if(i!=4 && (first_noArp==-1||first_dynArp==-1) && ((rg_db.lut[search_idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0) && _rtk_rg_lut_is_sw_static(search_idx)==FALSE)	//only check non-newest 3 entries, to ensure the newest insert entry won't be chosen this time
			{
				//ARP-USED, check if there is ARP or neighbor reference this entry
				//Check if this arp-used lut did not really referenced by ARP
				lut_arpState=0;
				for(j=0;j<MAX_ARP_SW_TABLE_SIZE;j++)
				{
					if(rg_db.arp[j].rtk_arp.valid && rg_db.arp[j].rtk_arp.nhIdx==search_idx)
					{
						if(rg_db.arp[j].staticEntry)
							lut_arpState=2;
						else
							lut_arpState=1;
						break;
					}
				}
				lut_arpState+=4;
				for(j=0;j<MAX_IPV6_NEIGHBOR_SW_TABLE_SIZE;j++)
				{
					if(rg_db.v6neighbor[j].neighborEntry.valid && rg_db.v6neighbor[j].neighborEntry.l2Idx==search_idx)
					{
						if(rg_db.v6neighbor[j].neighborEntry.staticEntry)
							lut_arpState+=16;
						else
							lut_arpState+=8;
						break;
					}
				}
				if(first_noArp==-1 && lut_arpState==4)
				{
					first_noArp=search_idx;
				}
				else if(first_dynArp==-1 && (lut_arpState==5||lut_arpState==12||lut_arpState==13))		//this bCAM entry can be deleted because it is not referenced by static ARP or neighbor!!
				{
					first_dynArp=search_idx;
				}
			}
		}
		victim_idx+=1;
		victim_idx%=MAX_LUT_HASH_WAY_SIZE;
		search_idx=l2Idx+victim_idx;
	}

	victim_idx=FAIL;
	if(LRU_index>=0)
	{
		//choose dynamic to replace, swap to bCAM
		victim_idx=_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, lutGroupIdx);
		if(victim_idx>=0)
		{
			pL2NewAddr=&rg_db.lut[LRU_index].rtk_lut.entry.l2UcEntry;
			pL2NewAddr->index=victim_idx;	//swap
			// [Call RTK_L2_ADDR_ADD directly] swap this lut entry to bcam
			ret=RTK_L2_ADDR_ADD(pL2NewAddr);
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Fail to add] lut entry[%d]", victim_idx);
				return RG_RET_ENTRY_NOT_GET;
			}
			//invalid the LRU entry, otherwise the new entry won't add
			pL2Addr=&rg_db.lut[LRU_index].rtk_lut.entry.l2UcEntry;
			// [Call RTK_L2_ADDR_DEL directly] swap this lut entry to bcam
			ret=RTK_L2_ADDR_DEL(pL2Addr);
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Fail to del] lut entry[%d]", LRU_index);
				return RG_RET_ENTRY_NOT_GET;
			}

			//move ivl lut entries to new svl lut group
			if((rg_db.lut[LRU_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
				_rtk_rg_moveLutGroup(victim_idx, LRU_index);
		}
		else
		{
			//invalid the LRU entry, otherwise the new entry won't add
			ret=(pf.rtk_rg_macEntry_del)(LRU_index);
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Fail to del] lut entry[%d]", LRU_index);
				return RG_RET_ENTRY_NOT_GET;
			}
		}

		//WARNING("  choose victim from dynamic entry:%d",victim_idx);
		victim_idx=LRU_index;
	}
	else if(first_noArp>=0)//Choose ARP-USED but no ARP referenced first
	{
		//choose dynamic to replace, swap to bCAM
		victim_idx=_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, lutGroupIdx);
		if(victim_idx>=0)
		{
			pL2NewAddr=&rg_db.lut[first_noArp].rtk_lut.entry.l2UcEntry;
			pL2NewAddr->index=victim_idx;	//swap
			// [Call RTK_L2_ADDR_ADD directly] swap this lut entry to bcam
			ret=RTK_L2_ADDR_ADD(pL2NewAddr);
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Fail to add] lut entry[%d]", victim_idx);
				return RG_RET_ENTRY_NOT_GET;
			}
			//invalid the LRU entry, otherwise the new entry won't add
			pL2Addr=&rg_db.lut[first_noArp].rtk_lut.entry.l2UcEntry;
			// [Call RTK_L2_ADDR_DEL directly] swap this lut entry to bcam
			ret=RTK_L2_ADDR_DEL(pL2Addr);
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Fail to del] lut entry[%d]", first_noArp);
				return RG_RET_ENTRY_NOT_GET;
			}

			//move ivl lut entries to new svl lut group
			if((rg_db.lut[first_noArp].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
				_rtk_rg_moveLutGroup(victim_idx, first_noArp);
		}
		else
		{
			//invalid the LRU entry, otherwise the new entry won't add
			ret=(pf.rtk_rg_macEntry_del)(first_noArp);
			if(ret!=RT_ERR_OK)
			{
				WARNING("[Fail to del] lut entry[%d]", first_noArp);
				return RG_RET_ENTRY_NOT_GET;
			}
		}

		//WARNING("  choose victim from dynamic entry:%d",victim_idx);
		victim_idx=first_noArp;
	}
	else if(first_dynArp>=0)//if no such entry, choose first ARP as the victim and clean ARP, NEXTHOP, neighbor, napt, shortcut
	{
		memcpy(&first_dynArp_mac,&rg_db.lut[first_dynArp].rtk_lut.entry.l2UcEntry.mac,sizeof(rtk_mac_t));

		//invalid the LRU entry, otherwise the new entry won't add
		if(rg_db.lut[first_dynArp].valid && rg_db.lut[first_dynArp].rtk_lut.entryType==RTK_LUT_L2UC && memcmp(&rg_db.lut[first_dynArp].rtk_lut.entry.l2UcEntry.mac,&first_dynArp_mac,sizeof(rtk_mac_t))==0)
		{
			ret=(pf.rtk_rg_macEntry_del)(first_dynArp);
			if(ret!=RT_ERR_OK)
			{
				WARNING("Layer2LRU failed when deleting Arp victim[%d]...ret=%x",first_dynArp,ret);
			}
			else
			{
				//WARNING("  choose victim from arp entry:%d",victim_idx);
				victim_idx=first_dynArp;
			}
		}
		else
		{
			//WARNING("  choose victim from arp entry:%d",victim_idx);
			_rtk_rg_layer2CleanL34ReferenceTable(first_dynArp);
			victim_idx=first_dynArp;
		}
	}

	return victim_idx;
}
#endif

#if !defined(__KERNEL__)
void _rtk_rg_interfaceVlanIDPriority_directTX(rtk_rg_pktHdr_t *pPktHdr,rtk_rg_intfInfo_t *pStoredInfo,struct tx_info *ptxInfo)
#else
void _rtk_rg_interfaceVlanIDPriority_directTX(rtk_rg_pktHdr_t *pPktHdr,rtk_rg_intfInfo_t *pStoredInfo,rtk_rg_txdesc_t *ptxInfo)
#endif
{
	if(pPktHdr->netifIdx==FAIL){
		//from Layer2 bridge, the egress vlan should be the ingress vlan
		//and the egress priority should be by tagged ctag pri or internal pri

		//printk("->netifIdx==FAIL\n");
		//memDump(skb->data,skb->len,"fail");

		pPktHdr->egressVlanID = pPktHdr->internalVlanID;

		if(pPktHdr->tagif&CVLAN_TAGIF)
			pPktHdr->egressPriority=pPktHdr->ctagPri&0x7;
		else
			pPktHdr->egressPriority=rg_db.systemGlobal.qosInternalDecision.qosPortBasedPriority[pPktHdr->ingressMacPort]&0x7;

		TRACE("Egress netifIdx is FAIL, egressVlanID=%d, egressPriority=%d", pPktHdr->egressVlanID, pPktHdr->egressPriority);
	}else
		_rtk_rg_interfaceVlanIDPriority(pPktHdr, pStoredInfo, ptxInfo);
}

#if !defined(__KERNEL__)
void _rtk_rg_interfaceVlanIDPriority(rtk_rg_pktHdr_t *pPktHdr,rtk_rg_intfInfo_t *pStoredInfo,struct tx_info *ptxInfo)
#else
void _rtk_rg_interfaceVlanIDPriority(rtk_rg_pktHdr_t *pPktHdr,rtk_rg_intfInfo_t *pStoredInfo,rtk_rg_txdesc_t *ptxInfo)
#endif
{
	//DEBUG("%s pStoredInfo->is_wan==%d",__FUNCTION__,pStoredInfo->is_wan);
	//Here we just decide VLANID and priority, tag or untag will postpone to _rtk_rg_fwdEngineDMAC2CVIDTransfer
	if(pStoredInfo->is_wan==0){
		//FIXME: here should consider both LAN and WAN interface
		//ptxInfoMask->opts2.bit.tx_vlan_action=0x3;

		/*if(rg_db.vlan[pStoredInfo->lan_intf.intf_vlan_id].UntagPortmask&)
		{
			ptxInfo->opts2.bit.tx_vlan_action = 0x3;		//remarking tag
			DEBUG("tagged with %d",pStoredInfo->wan_intf.wan_intf_conf.egress_vlan_id);
		}*/

		//set up priority
		if(pPktHdr!=NULL){
			pPktHdr->egressVlanID = pStoredInfo->lan_intf.intf_vlan_id;
			pPktHdr->internalVlanID = pStoredInfo->lan_intf.intf_vlan_id;

			if(pPktHdr->tagif&CVLAN_TAGIF){
				pPktHdr->egressPriority=pPktHdr->ctagPri&0x7;
			}else{
				pPktHdr->egressPriority=rg_db.systemGlobal.qosInternalDecision.qosPortBasedPriority[pPktHdr->ingressMacPort]&0x7;
			}
			TRACE("Egress netifIdx(LAN)=%d, egressVlanID=%d, egressPriority=%d", pPktHdr->netifIdx, pPktHdr->egressVlanID, pPktHdr->egressPriority);
		}
	}else{
		//ptxInfoMask->opts2.bit.tx_vlan_action=0x3;

		//DEBUG("wanVID is%d, the vidl is %x, vidh is %x",pStoredInfo->wan_intf.wan_intf_conf.egress_vlan_id,ptxInfo->opts2.bit.vidl,ptxInfo->opts2.bit.vidh);
		/*if(pStoredInfo->wan_intf.wan_intf_conf.egress_vlan_tag_on)
		{
			ptxInfo->opts2.bit.tx_vlan_action = 0x3;		//remarking tag
			DEBUG("tagged with %d",pStoredInfo->wan_intf.wan_intf_conf.egress_vlan_id);
		}*/

		//set up priority
		if(pPktHdr!=NULL){
			pPktHdr->egressVlanID = pStoredInfo->wan_intf.wan_intf_conf.egress_vlan_id;
			pPktHdr->internalVlanID = pStoredInfo->wan_intf.wan_intf_conf.egress_vlan_id;
			if(pPktHdr->tagif&CVLAN_TAGIF){
				pPktHdr->egressPriority=pPktHdr->ctagPri&0x7;
			}else{
				pPktHdr->egressPriority=rg_db.systemGlobal.qosInternalDecision.qosPortBasedPriority[pPktHdr->ingressMacPort]&0x7;
			}
			TRACE("Egress netifIdx(WAN)=%d, egressVlanID=%d, egressPriority=%d", pPktHdr->netifIdx, pPktHdr->egressVlanID, pPktHdr->egressPriority);
		}
	}
}


int _rtk_rg_arpGeneration(uint8 netIfIdx,ipaddr_t gwIpAddr,rtk_rg_arp_request_t *arpReq)
{
#ifdef __KERNEL__
#if defined(CONFIG_APOLLO_ROMEDRIVER)
	//struct tx_info txInfo,txInfoMask;
	struct sk_buff *skb;
	unsigned char *bufptr;
	int ret_code=0;
	int vlan_offset=0;
	int i;
	uint32 bitmask=0;

	rg_kernel.tracefilterShow =0; //disable tracefilter show
	DEBUG("arp send: request ip=%x\n",arpReq->reqIp);

	skb=_rtk_rg_getAlloc(RG_FWDENGINE_PKT_LEN);
	if(skb==NULL){
		TRACE("alloc skb failed..return");
		return 0;
	}

	//call fwdEngineInput, the alloc counter will be added. so don't need to add again

	if((skb)&&(rg_db.systemGlobal.fwdStatistic))
	{
#if RTK_RG_SKB_PREALLOCATE
		rg_db.systemGlobal.statistic.perPortCnt_skb_pre_alloc_for_uc[rg_db.pktHdr->ingressPort]--;
#else
		rg_db.systemGlobal.statistic.perPortCnt_skb_alloc[rg_db.pktHdr->ingressPort]--;
#endif
	}

	//backup original pkthdr
	rg_db.pktHdr=&rg_db.systemGlobal.pktHeader_2;

	//20180726LUKE: if we disable inpection, using original parameters without change.
	if(!arpReq->disableL3Inspect)
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			//DEBUG("the wan type is %d, ip is %x",rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr);
			if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo!=NULL && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf!=NULL &&
				rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)
			{
				if(((rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr&
					rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask)
					==(arpReq->reqIp&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask))&&
					(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask>bitmask))
				{

					gwIpAddr=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr;
					netIfIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
					bitmask=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask;
				}
			}
		}
	}

	TRACE("ARP requestIp(%x): gwIpAddr=%x netIfIdx=%d!",arpReq->reqIp,gwIpAddr,netIfIdx);

	//use rsvd to save the netif idx for Layer2 forward
	rg_kernel.rxInfoFromARPND.rx_netIfIdx=netIfIdx;

	bzero(skb->data,RG_FWDENGINE_PKT_LEN);//clean ptk buffer
	skb_reserve(skb, RX_OFFSET);
	bufptr=skb->data;


	/* Construct destination MAC */
	memset(bufptr,0xff, ETHER_ADDR_LEN);

	/* Construct source MAC */
	if(rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.is_wan==1)
		memcpy(bufptr + 6,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN);
	else
		memcpy(bufptr + 6,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.lan_intf.gmac.octet,ETHER_ADDR_LEN);

	if(rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.is_wan==1)
	{
		vlan_offset=4;
		*(uint16 *)(bufptr + 12)= htons(0x8100);
		*(uint16 *)(bufptr + 14)= htons(rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
	}


	/* construct Ethtype+ARP header */
	*(uint32 *)(bufptr + 12 + vlan_offset) = htonl(0x08060001);
	*(uint32 *)(bufptr + 16 + vlan_offset) = htonl(0x08000604);
	*(uint16 *)(bufptr + 20 + vlan_offset) = htons(0x0001);
	if(rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.is_wan==1)
		memcpy(bufptr + 22 + vlan_offset,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN);
	else
		memcpy(bufptr + 22 + vlan_offset,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.lan_intf.gmac.octet,ETHER_ADDR_LEN);

	*(uint32 *)(bufptr + 28 + vlan_offset) = htonl(gwIpAddr);
	*(uint32 *)(bufptr + 38 + vlan_offset) = htonl(arpReq->reqIp);

	skb_put(skb, 60);

	/*memset(&txInfo,0,sizeof(txInfo));
	memset(&txInfoMask,0,sizeof(txInfoMask));

	//arp request with vlan tag
	_rtk_rg_interfaceVlanTagged(pStoredInfo,&txInfo,&txInfoMask);

	//FIXME: lookup by vlan table

	txInfoMask.tx_cputag=1;
	txInfo.tx_cputag=1;

	txInfoMask.tx_l34_keep=1;
	txInfoMask.tx_tx_portmask=RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU;

	txInfo.tx_l34_keep=1;
	txInfo.tx_tx_portmask=0;		//let hardware to auto look up
	//txInfo.tx_tx_portmask=(1<<RTK_RG_MAC_PORT0)|(1<<RTK_RG_MAC_PORT_RGMII);
*/
	*(u32*)(skb->data+skb->len)=0; //save null point into end of skb data.(for trace filter debug)
#if defined(CONFIG_APOLLO_ROMEDRIVER)

	ret_code = rtk_rg_fwdEngineInput(skb, &rg_kernel.rxInfoFromARPND);

	//Processing packets
	if(ret_code == RG_FWDENGINE_RET_TO_PS)
	{
		//FIXME:iPhone 5 change wireless connection from master to slave will send strange unicast ARP request for LAN gateway IP, and forwarded by protocol stack
		TRACE("ARP_GEN[%x]: To Protocol-Stack...FREE SKB!!",(POINTER_CAST)skb&0xffff);
		//dump_packet(skb->data,skb->len,"dump_back_to_PS");
		_rtk_rg_dev_kfree_skb_any(skb);
	}
	else if (ret_code == RG_FWDENGINE_RET_DROP)
	{
		TRACE("ARP_GEN[%x]: Drop...FREE SKB!!",(POINTER_CAST)skb&0xffff);
		_rtk_rg_dev_kfree_skb_any(skb);
	}
	else
	{
		TRACE("ARP_GEN[%x]: Forward",(POINTER_CAST)skb&0xffff);
	}
	//point back to original pkthdr
	rg_db.pktHdr=&rg_db_cache.pktHeader_1;
#else
	ret_code=_rtk_rg_broadcastForward(skb,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id,RTK_RG_MAC_PORT_MAINCPU,0);
	if(ret_code==RG_FWDENGINE_RET_DROP)
		_rtk_rg_dev_kfree_skb_any(skb);
#endif
	//memDump(bufptr,skb->len,"ARPGEN");
	//rtk_rg_fwdEngine_xmit(skb,&txInfo,NULL);
	//re8686_send_with_txInfo(skb,&txInfo,0);
	//re8686_send_with_txInfo_and_mask(skb,&txInfo,0,&txInfoMask);
#else
	//FIXME:in module code, we need some other api to send packets
#endif
#endif

	return 0;
}

unsigned short _rtk_rg_checkSumICMPv6(unsigned short *sip,unsigned short *dip,unsigned short payloadLength,unsigned short nextHeader,unsigned short *buffer, int size)
{
    unsigned long cksum=0;
	int ipSize;
    while(size >1)
    {
        cksum+=*buffer++;
        size -=sizeof(unsigned short);
    }
    if(size)
        cksum += *(unsigned char*)buffer;

	//caculate IPv6 pseudo header
	ipSize=IPV6_ADDR_LEN;	//bytes
	while(ipSize >1)
    {
        cksum+=*sip++;
        ipSize -=sizeof(unsigned short);
    }
    if(ipSize)
        cksum += *(unsigned char*)sip;

	ipSize=IPV6_ADDR_LEN;	//bytes
	while(ipSize >1)
    {
        cksum+=*dip++;
        ipSize -=sizeof(unsigned short);
    }
    if(ipSize)
        cksum += *(unsigned char*)dip;

	cksum+=payloadLength;
	cksum+=nextHeader;

	while (cksum >> 16)
	{
		cksum = (cksum & 0xffffUL) + (cksum >> 16);
	}

    return ~(cksum&0xffff);
}

int _rtk_rg_NDGeneration(uint8 netIfIdx,rtk_ipv6_addr_t gwIpAddr,rtk_rg_neighbor_discovery_t *neighborDisc)
{

#ifdef __KERNEL__
#if defined(CONFIG_APOLLO_ROMEDRIVER)
	//struct tx_info txInfo,txInfoMask;
	unsigned short tmpChksum;
	int ret_code=0;
	struct sk_buff *skb;
	unsigned char *bufptr;
	int vlan_offset=0;

	rg_kernel.tracefilterShow =0; //disable tracefilter show
	DEBUG("neighbor send: request ip=%08x:%08x:%08x:%08x\n",*(unsigned int *)neighborDisc->reqIp.ipv6_addr,
		*(unsigned int *)(neighborDisc->reqIp.ipv6_addr+4),
		*(unsigned int *)(neighborDisc->reqIp.ipv6_addr+8),
		*(unsigned int *)(neighborDisc->reqIp.ipv6_addr+12));

	//use rsvd to save the netif idx for Layer2 forward
	rg_kernel.rxInfoFromARPND.rx_netIfIdx=netIfIdx;

	skb=_rtk_rg_getAlloc(RG_FWDENGINE_PKT_LEN);
	if(skb==NULL){
		TRACE("alloc skb failed..return");
		return 0;
	}

	//call fwdEngineInput, the alloc counter will be added. so don't need to add again

	if((skb)&&(rg_db.systemGlobal.fwdStatistic))
	{
#if RTK_RG_SKB_PREALLOCATE
		rg_db.systemGlobal.statistic.perPortCnt_skb_pre_alloc_for_uc[rg_db.pktHdr->ingressPort]--;
#else
		rg_db.systemGlobal.statistic.perPortCnt_skb_alloc[rg_db.pktHdr->ingressPort]--;
#endif
	}

	//backup original pkthdr
	rg_db.pktHdr=&rg_db.systemGlobal.pktHeader_2;

	bzero(skb->data,RG_FWDENGINE_PKT_LEN);//clear pkt buffer

	skb_reserve(skb, RX_OFFSET);
	bufptr=skb->data;

	// Construct destination MAC:
	//33:33:ff plus IPv6 address last 24bits
	*(unsigned char *)(bufptr)=0x33;
	*(unsigned char *)(bufptr+1)=0x33;
	*(unsigned char *)(bufptr+2)=0xff;
	memcpy(bufptr + 3,&neighborDisc->reqIp.ipv6_addr[13],3);

	// Construct source MAC
	memcpy(bufptr + 6,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN);


	if(rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.is_wan==1)
	{
		vlan_offset=4;
		*(uint16 *)(bufptr + 12)= htons(0x8100);
		*(uint16 *)(bufptr + 14)= htons(rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
	}


	// construct IPv6 header
	*(unsigned int *)(bufptr + 12+ vlan_offset) = htonl(0x86dd6000);			//etherType, ipv6 version
	*(unsigned int *)(bufptr + 16+ vlan_offset) = htonl(0x00000020);			//payload length: 32bytes
	*(unsigned short *)(bufptr + 20+ vlan_offset) = htons(0x3aff);			//next header: ICMPv6(58), Hop limit: 255
	memcpy(bufptr + 22+ vlan_offset,&gwIpAddr.ipv6_addr,16);					//source IP
	*(unsigned int *)(bufptr + 38+ vlan_offset) = htonl(0xff020000);			//Destination IP: ff02::1:ff00/104 + ipv6 last 24bits
	*(unsigned int *)(bufptr + 42+ vlan_offset) = htonl(0x00000000);			//Destination IP: ff02::1:ff00/104 + ipv6 last 24bits
	*(unsigned int *)(bufptr + 46+ vlan_offset) = htonl(0x00000001);			//Destination IP: ff02::1:ff00/104 + ipv6 last 24bits
	*(unsigned char *)(bufptr+50+ vlan_offset)=0xff;							//Destination IP: ff02::1:ff00/104 + ipv6 last 24bits
	memcpy(bufptr + 51+ vlan_offset,&neighborDisc->reqIp.ipv6_addr[13],3);	//Destination IP: ff02::1:ff00/104 + ipv6 last 24bits

	// construct ICMPv6 for Neighbor Solicitation
	*(unsigned int *)(bufptr + 54+ vlan_offset) = htonl(0x87000000);		//type:neighbor solicitation(135), code:0, checksum: 0 at first
	*(unsigned int *)(bufptr + 58+ vlan_offset) = htonl(0x00000000);		//reserved:0
	memcpy(bufptr + 62+ vlan_offset,&neighborDisc->reqIp,16);			//Destination IP
	*(unsigned short *)(bufptr + 78+ vlan_offset) = htons(0x0101);		//ICMPv6 optional:type=1,source link-layer address, length=1(8 bytes)
	memcpy(bufptr + 80+ vlan_offset,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN);

	// Caculate checksum
	tmpChksum=_rtk_rg_checkSumICMPv6((unsigned short *)(bufptr+22+ vlan_offset),(unsigned short *)(bufptr+38+ vlan_offset),0x0020,0x003a,(unsigned short *)(bufptr+54+ vlan_offset),32);
	*(unsigned short *)(bufptr + 56+ vlan_offset) = htons(tmpChksum);

	skb_put(skb, 86+vlan_offset); //plus CRC length or not?

	/*memset(&txInfo,0,sizeof(txInfo));
	memset(&txInfoMask,0,sizeof(txInfoMask));

	//neighbor discovery with vlan tag
	_rtk_rg_interfaceVlanTagged(pStoredInfo,&txInfo,&txInfoMask);

	txInfoMask.tx_cputag=1;
	txInfoMask.tx_l34_keep=1;
	txInfoMask.tx_tx_portmask=RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU;

	txInfo.tx_cputag=1;

	txInfoMask.tx_ipcs=1;
	txInfoMask.tx_l4cs=1;
	txInfoMask.tx_cputag_ipcs=1;
	txInfoMask.tx_cputag_l4cs=1;

	txInfo.tx_l34_keep=1;
	txInfo.tx_tx_portmask=0x1<<pStoredInfo->wan_intf.wan_intf_conf.wan_port_idx;		//since we are multicast packet, we should use DirectTX
	//txInfo.tx_tx_portmask=(1<<RTK_RG_MAC_PORT0)|(1<<RTK_RG_MAC_PORT_RGMII);
	txInfo.tx_ipcs=1;
	txInfo.tx_l4cs=1;
	txInfo.tx_cputag_ipcs=1;
	txInfo.tx_cputag_l4cs=1;
	*/

	//memDump(bufptr,skb->len,"ARPGEN");
	//rtk_rg_fwdEngine_xmit(skb,&txInfo,NULL);
	//re8686_send_with_txInfo(skb,&txInfo,0);
	//re8686_send_with_txInfo_and_mask(skb,&txInfo,0,&txInfoMask);
	*(u32*)(skb->data+skb->len)=0; //save null point into end of skb data.(for trace filter debug)
#if defined(CONFIG_APOLLO_ROMEDRIVER)

	ret_code = rtk_rg_fwdEngineInput(skb, &rg_kernel.rxInfoFromARPND);

	//Processing packets
	if(ret_code == RG_FWDENGINE_RET_TO_PS)
	{
		//FIXME:iPhone 5 change wireless connection from master to slave will send strange unicast ARP request for LAN gateway IP, and forwarded by protocol stack
		TRACE("ND_GEN[%x]: To Protocol-Stack...FREE SKB!!",(POINTER_CAST)skb&0xffff);
		//dump_packet(skb->data,skb->len,"dump_back_to_PS");
		_rtk_rg_dev_kfree_skb_any(skb);
	}
	else if (ret_code == RG_FWDENGINE_RET_DROP)
	{
		TRACE("ND_GEN[%x]: Drop...FREE SKB!!",(POINTER_CAST)skb&0xffff);
		_rtk_rg_dev_kfree_skb_any(skb);
	}
	else
	{
		TRACE("ND_GEN[%x]: Forward",(POINTER_CAST)skb&0xffff);
	}
	//point back to original pkthdr
	rg_db.pktHdr=&rg_db_cache.pktHeader_1;
#else
	ret_code=_rtk_rg_broadcastForward(skb,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id,RTK_RG_MAC_PORT_CPU,0);
	if(ret_code==RG_FWDENGINE_RET_DROP)
		_rtk_rg_dev_kfree_skb_any(skb);
#endif
#else
	//FIXME:in module code, we need some other api to send packets
#endif
#endif

	return 0;
}

rtk_rg_err_code_t _rtk_rg_decCountSetStaticForGWMAC(ipaddr_t ipAddr, int l2Idx)
{
	int errorno=RT_ERR_RG_OK;
	rtk_rg_macEntry_t macEt;
	int valid_macIdx;
	rtk_rg_arpInfo_t arpInfo;
	int arp_valid_idx;
	uint32 lutGroupIdx=rg_db.lut[l2Idx].lutGroupIdx;
	rtk_rg_lut_linkList_t *pLutList, *pNextLutList;
	rtk_rg_port_idx_t portIdx;

	if(lutGroupIdx<MAX_LUT_HW_TABLE_SIZE){
		list_for_each_entry_safe(pLutList, pNextLutList, &rg_db.lutGroupTableHead[lutGroupIdx], lut_list)	//just return the first entry right behind of head
		{
			//Get Mac address
			valid_macIdx=pLutList->idx;
			errorno=rtk_rg_apollo_macEntry_find(&macEt, &valid_macIdx);
			if(errorno!=RT_ERR_RG_OK || valid_macIdx!=pLutList->idx)goto RET_ERR;

			if((rg_db.lut[valid_macIdx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0)
			{
				portIdx = macEt.port_idx;
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
				_rtk_rg_lutExtport_translator(&portIdx);
#endif
				if(rg_db.lut[valid_macIdx].countingInLearningLimit)
					assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[valid_macIdx].wlan_device_idx));
				
				//20170222: wan access limit only counts SVL lut entry
				if((rg_db.lut[valid_macIdx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
				{
					//remove from limit count
					//20170301LUKE: modify count when limit field is source mac.
					if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
					{
						if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<(portIdx))&&rg_db.lut[valid_macIdx].permit_for_l34_forward)
							atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						//decrease wlan's device count
						if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
							) && rg_db.lut[valid_macIdx].wlan_device_idx>=0)
						{
							if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[valid_macIdx].wlan_device_idx))&&rg_db.lut[valid_macIdx].permit_for_l34_forward)
								atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
						}
#endif
					}
					//20170301LUKE: modify count when limit field is source mac.
					if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
						if(_rtK_rg_checkCategoryPortmask_spa(portIdx)==SUCCESS)
							atomic_dec(&rg_db.systemGlobal.accessWanLimitCategoryCount[(unsigned int)rg_db.lut[valid_macIdx].category]);
				}
				//Set mac as static for gw
				macEt.static_entry=1;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else			// 20180205: hw(excludes apollo) would check arp_used for L34 linked lut entry.
				//20160907LUKE: for 9602c hw would check arp_used for L34 linked lut entry.
				macEt.arp_used=1;
#endif
				macEt.countingInLearningLimit = 0;
				errorno=(pf.rtk_rg_macEntry_add)(&macEt,&valid_macIdx);
				if(errorno!=RT_ERR_RG_OK || valid_macIdx!=pLutList->idx)goto RET_ERR;
			}
		}
	}else
		WARNING("lutGroupIdx is %d!",lutGroupIdx);

	//20141013LUKE: find ARP and set it to static, too
	arpInfo.arpEntry.ipv4Addr=ipAddr;
	arp_valid_idx=-1;	//find by IP
	if(rtk_rg_apollo_arpEntry_find(&arpInfo, &arp_valid_idx)==RT_ERR_RG_OK && !arpInfo.arpEntry.staticEntry){
		arpInfo.arpEntry.staticEntry=1;
		arpInfo.arpEntry.macEntryIdx=l2Idx;	//20161121LUKE: update macIdx
		errorno=rtk_rg_apollo_arpEntry_add(&arpInfo.arpEntry, &arp_valid_idx);
	}

RET_ERR:
	return (errorno);
}

rtk_rg_err_code_t _rtk_rg_decCountSetStaticForV6GWMAC(unsigned char *ipv6Addr, int l2Idx)
{
	int errorno=RT_ERR_RG_OK;
	rtk_rg_macEntry_t macEt;
	int valid_macIdx;
	rtk_rg_neighborInfo_t neighborInfo;
	int neighbor_valid_idx;
	int rtidx;
	uint32 lutGroupIdx=rg_db.lut[l2Idx].lutGroupIdx;
	rtk_rg_lut_linkList_t *pLutList, *pNextLutList;
	rtk_rg_port_idx_t portIdx;

	if(lutGroupIdx<MAX_LUT_HW_TABLE_SIZE){
		list_for_each_entry_safe(pLutList, pNextLutList, &rg_db.lutGroupTableHead[lutGroupIdx], lut_list)	//just return the first entry right behind of head
		{
			//Get Mac address
			valid_macIdx=pLutList->idx;
			errorno=rtk_rg_apollo_macEntry_find(&macEt, &valid_macIdx);
			if(errorno!=RT_ERR_RG_OK || valid_macIdx!=pLutList->idx)goto RET_ERR;

			if((rg_db.lut[valid_macIdx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)==0)
			{
				portIdx = macEt.port_idx;
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
				_rtk_rg_lutExtport_translator(&portIdx);
#endif
				if(rg_db.lut[valid_macIdx].countingInLearningLimit)
					assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[valid_macIdx].wlan_device_idx));
				
				//20170222: wan access limit only counts SVL lut entry
				if((rg_db.lut[valid_macIdx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
				{
					//remove from limit count
					//20170301LUKE: modify count when limit field is source mac.
					if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
					{
						if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<(portIdx))&&rg_db.lut[valid_macIdx].permit_for_l34_forward)
							atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						//decrease wlan's device count
						if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
							) && rg_db.lut[valid_macIdx].wlan_device_idx>=0)
						{
							if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[valid_macIdx].wlan_device_idx))&&rg_db.lut[valid_macIdx].permit_for_l34_forward)
								atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
						}
#endif
					}
					//20170301LUKE: modify count when limit field is source mac.
					if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
						if(_rtK_rg_checkCategoryPortmask_spa(portIdx)==SUCCESS)
							atomic_dec(&rg_db.systemGlobal.accessWanLimitCategoryCount[(unsigned int)rg_db.lut[valid_macIdx].category]);
				}
				//Set mac as static for gw
				macEt.static_entry=1;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else			// 20180205: hw(excludes apollo) would check arp_used for L34 linked lut entry.
				//20160907LUKE: for 9602c hw would check arp_used for L34 linked lut entry.
				macEt.arp_used=1;
#endif
				macEt.countingInLearningLimit = 0;
				errorno=(pf.rtk_rg_macEntry_add)(&macEt,&valid_macIdx);
				if(errorno!=RT_ERR_RG_OK || valid_macIdx!=pLutList->idx)goto RET_ERR;
			}
		}
	}else
		WARNING("lutGroupIdx is %d!",lutGroupIdx);

	//20160601LUKE: find Neighbor and set it to static, too
	rtidx=_rtk_rg_v6L3lookup(ipv6Addr);
	if(rtidx>=0){
		memcpy(neighborInfo.neighborEntry.interfaceId,ipv6Addr,IPV6_ADDR_LEN);
		neighborInfo.neighborEntry.matchRouteIdx=rtidx;
		neighbor_valid_idx=-1;	//find by IFID
		if(rtk_rg_apollo_neighborEntry_find(&neighborInfo,&neighbor_valid_idx)==RT_ERR_RG_OK && !neighborInfo.neighborEntry.staticEntry){
			neighborInfo.neighborEntry.staticEntry=1;
			neighborInfo.neighborEntry.l2Idx=l2Idx;	//20161121LUKE: update macIdx
			errorno=rtk_rg_apollo_neighborEntry_add(&neighborInfo.neighborEntry,&neighbor_valid_idx);
		}
	}

RET_ERR:
	return (errorno);
}

int _rtk_rg_internal_GWMACSetup_stage2(int matchIdx, int l2Idx)
{
	int i,nxtidx,eipIdx=-1,rtidx=-1,ret,errorno,netmask;
	int ori_l2Idx=rg_db.systemGlobal.defaultTrapLUTIdx;
	int napt_enable=0, default_route=0, static_route_by_arp=0;
	int addNexthopCount;
	rtk_l34_routing_entry_t rtEntry;
    rtk_l34_nexthop_entry_t nxpEt;
	rtk_l34_ext_intip_entry_t extipEntry;
	//rtk_l34_pppoe_entry_t pppoeEt;
    ipaddr_t wan_ext_ip=0,wan_ext_ip_mask=0,remote_gw_ip=0,remote_host_ip=0;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;
	rtk_rg_wan_type_t wan_type;

	//int valid_macIdx;
	//int ori_wantype=0;
	//rtk_wanType_entry_t wantEt;
	if(matchIdx <0 || matchIdx>=MAX_NETIF_SW_TABLE_SIZE)
		return RT_ERR_RG_INVALID_PARAM;

	wan_ext_ip=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ip_addr;
	wan_ext_ip_mask=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ip_network_mask;
	remote_gw_ip=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->gateway_ipv4_addr;
	napt_enable=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->napt_enable;
	default_route=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv4_default_gateway_on;
	static_route_by_arp=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->static_route_with_arp;
	wan_type=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.wan_intf_conf.wan_type;
	netmask=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ip_network_mask;
	remote_host_ip=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->remote_host_ip_addr;

	//nxtidx=RG_GLB_WAN_TYPE[matchIdx];
	nxtidx=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.nexthop_ipv4;
	//20150622LUKE: if the nxtidx is not ready, choose one and use it!
	if(nxtidx<0)
	{
		//Check for empty entry
		errorno=RT_ERR_RG_ENTRY_FULL;
		for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++)
		{
			if(rg_db.systemGlobal.nxpRefCount[i] == 0)
				break;
		}
		if(i==MAX_NEXTHOP_SW_TABLE_SIZE)goto RET_NEXTHOP_ERR;

		nxtidx = i;		//Keep

		//Setup Nexthop table in nxtidx
		errorno=RT_ERR_RG_NXP_SET_FAIL;
		bzero(&nxpEt,sizeof(rtk_l34_nexthop_entry_t));
		nxpEt.ifIdx=matchIdx;
		// if WAN is PPPoE, LAN is untag. (keepPppoe=1 will send untag packet to WAN)
		if((wan_type == RTK_RG_PPPoE)||(wan_type == RTK_RG_PPPoE_DSLITE)){
			nxpEt.type=L34_NH_PPPOE;
			#if defined(CONFIG_RG_RTL9602C_SERIES)
			nxpEt.keepPppoe=2; /* If original tagged, keep. Otherwise add tag with PPPIDX session id */
			#else
			nxpEt.keepPppoe=0;
			#endif
			nxpEt.pppoeIdx=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.pppoe_idx;
		}else{
			nxpEt.type=L34_NH_ETHER;
			nxpEt.keepPppoe=1;
			nxpEt.pppoeIdx=0;
		}

		// FIXME: here should to use binding remote host mac index, if port-binding is set
		nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;		//use this DUMMY index to force packet TRAP to CPU
		rg_db.nexthop[nxtidx].valid=1;
		ret = RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);
		if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
		rg_db.systemGlobal.nxpRefCount[nxtidx]++;	//add for deleting it when del interface
		rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.nexthop_ipv4=nxtidx;
	}

	//Check if we had set nexthop before
	//20140926LUKE: for PPTP and L2TP, we will never add nexthop.
	if(rg_db.nexthop[nxtidx].rtk_nexthop.nhIdx!=l2Idx)
	{
		//errorno=RT_ERR_RG_NXP_GET_FAIL;
		bzero(&nxpEt, sizeof(rtk_l34_nexthop_entry_t));
		memcpy(&nxpEt, &rg_db.nexthop[nxtidx].rtk_nexthop,sizeof(rtk_l34_nexthop_entry_t));
		//ret = rtk_l34_nexthopTable_get(nxtidx, &nxpEt);
		//if(ret!=RT_ERR_OK)goto RET_ERR;

	    //Check for routing table
	    //errorno=RT_ERR_RG_ROUTE_GET_FAIL;
	    //ret = rtk_l34_routingTable_get(MAX_L3_SW_TABLE_SIZE-1, &rtEntry);	//get default route setting
	    //if(ret!=RT_ERR_OK)goto RET_ERR;
		//errorno=RT_ERR_RG_DEF_ROUTE_EXIST;

		//Setup Nexthop table in nxtidx
	    errorno=RT_ERR_RG_NXP_SET_FAIL;
		ori_l2Idx = nxpEt.nhIdx;	//Keep
	    nxpEt.nhIdx = l2Idx;			// TODO:LUT table index point to Gateway
		rg_db.nexthop[nxtidx].valid=1;
	    ret = RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);
	    if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//20170203LUKE: if we are changing remote GW mac, we should delete related flow here.
		if(ori_l2Idx!=rg_db.systemGlobal.defaultTrapLUTIdx)
			_rtk_rg_flow_del_by_l2Idx(ori_l2Idx);
#endif
	}

	//20160524LUKE: check if static route's nexthop point to same interface index
	for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++){
		if(rg_db.nexthop[i].rtk_nexthop.ifIdx==matchIdx &&
			rg_db.nexthop[i].rtk_nexthop.nhIdx==rg_db.systemGlobal.defaultTrapLUTIdx)
		{
			memcpy(&nxpEt,&rg_db.nexthop[i].rtk_nexthop,sizeof(rtk_l34_nexthop_entry_t));
			nxpEt.nhIdx=l2Idx;
			rg_db.nexthop[i].valid=1;
			ret = RTK_L34_NEXTHOPTABLE_SET(i, &nxpEt);
			if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
		}
	}

	//20150610LUKE: Lookup for available extip table index
	//20160128LUKE: for static host route, we do not need extIP entry.
	//20160329LUKE: for routing mode, we should never add extIP entry, even static route.
	if(napt_enable/* || (default_route==0 && remote_gw_ip!=0 && netmask!=0xffffffff)*/)
	{
		if(rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.extip_idx<0)
	   	{
			//Set up Internal External IP table for NAPT or STATIC ROUTE
			//20140328LUKE:STATIC ROUTE should always add IP table, even napt_enable is 0!!
			//20141001LUKE: PPTP should add EXTIP in pptpClientInfoAfterDial_set
			//20141020LUKE: L2TP should add EXTIP in l2tpClientInfoAfterDial_set
			bzero(&extipEntry,sizeof(rtk_l34_ext_intip_entry_t));
		   	extipEntry.intIpAddr=0; 	   //napt special
			extipEntry.extIpAddr=wan_ext_ip;

			//20150107LUKE: update EIP from primitive WAN interface, not from STATIC ROUTE's WAN.
			if(((wan_ext_ip_mask<0xffffffff)&&((wan_ext_ip&wan_ext_ip_mask)==wan_ext_ip)) ||	//subnet IP
				(wan_ext_ip_mask==0xffffffff&&wan_type!=RTK_RG_PPPoE&&wan_type!=RTK_RG_PPPoE_DSLITE&&wan_type!=RTK_RG_PPTP&&wan_type!=RTK_RG_L2TP&&wan_type!=RTK_RG_VXLAN))		//static host route with napt mode
			{
				ret=0;
				for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
				{
					//DEBUG("the wan type is %d, ip is %x",rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr);
					if((rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)&&
						(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask!=0xffffffff)&&
						((rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask)
						==(remote_gw_ip&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask))&&
						(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask>ret))
					{
						extipEntry.extIpAddr=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr;
						//20170208LUKE: old version static route WAN should also use primitive interface's index in nexthop.
						errorno=RT_ERR_RG_NXP_SET_FAIL;
						memcpy(&nxpEt,&rg_db.nexthop[nxtidx].rtk_nexthop,sizeof(nxpEt));
						//20171013LUKE: keep original WAN index in mask for deleting routing entry reference.
						rg_db.nexthop[nxtidx].staticRouteWanIdxMask=0x1<<nxpEt.ifIdx;
						nxpEt.ifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
						ret = RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);
	  	  				if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
						ret=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask;
					}
				}
				if(ret==0)
				{
					for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
					{
						//DEBUG("the wan type is %d, ip is %x",rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr);
						if((rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)&&
							(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask==0xffffffff)&&
							(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv4_addr==remote_gw_ip))
						{
							extipEntry.extIpAddr=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr;
							//20170208LUKE: old version static route WAN should also use primitive interface's index in nexthop.
							errorno=RT_ERR_RG_NXP_SET_FAIL;
							memcpy(&nxpEt,&rg_db.nexthop[nxtidx].rtk_nexthop,sizeof(nxpEt));
							//20171013LUKE: keep original WAN index in mask for deleting routing entry reference.
							rg_db.nexthop[nxtidx].staticRouteWanIdxMask=0x1<<nxpEt.ifIdx;
							nxpEt.ifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
							ret = RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);
		  	  				if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
							ret=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask;
							break;
						}
					}
				}
				if(ret==0)
				{
					DEBUG("Static route but can not find primitive WAN interface");
				}
			}
		   	extipEntry.nhIdx=nxtidx;
		   	extipEntry.prival=0;
		   	extipEntry.pri=0;
		   	extipEntry.type=L34_EXTIP_TYPE_NAPT;
		   	extipEntry.valid=1;

			//20200409LUKE: check for reduplicated entry
			errorno=RT_ERR_RG_ENTRY_FULL;
			ret=-1;
			for(i=0;i<MAX_EXTIP_SW_TABLE_SIZE;i++)
			{
				if(!rg_db.extip[i].rtk_extip.valid && ret<0)
					ret=i;	//first_invalid
				else if(!memcmp(&extipEntry,&rg_db.extip[i].rtk_extip,sizeof(rtk_l34_ext_intip_entry_t)))
					break;
			}
			if(i<MAX_EXTIP_SW_TABLE_SIZE){
				//reuse same entry in EIP table
				eipIdx=i;
			}else if(ret>=0){
				eipIdx=ret;	//keep
				
				errorno=RT_ERR_RG_EXTIP_SET_FAIL;
		   		ret = RTK_L34_EXTINTIPTABLE_SET(eipIdx, &extipEntry);
		   		if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
			}else	//no invalid one and no reduplicated entry
				goto RET_NEXTHOP_ERR;
			
			rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.extip_idx=eipIdx;	//keep in interface structure

	   		//DEBUG("set ext ip table %d as %x, nexthop is %d",matchIdx, wan_ext_ip,nxtidx);
		   	rg_db.systemGlobal.nxpRefCount[nxtidx]++;		   //nexthop reference by IP table
		   	rg_db.systemGlobal.eipRefCount[eipIdx]++;		   //eip reference by interface table
	   	}
	}
	//DEBUG("the wan_ip is %x, napt_enable is %d, default_route is %d  nxtidx is %d static_route_arp is %d...",wan_ext_ip,napt_enable,default_route,nxtidx,static_route_by_arp);

	//Check and setup Routing table for default route
	//WARNING("the default_route is %d, the defaultRouteSet is %d, matchidx is %d",default_route,rg_db.systemGlobal.defaultRouteSet,matchIdx);
    if(default_route == 1)
    {
    	if(rg_db.systemGlobal.defaultRouteSet == matchIdx)
    	{
    		addNexthopCount=1;
    		if(wan_type!=RTK_RG_PPTP && wan_type!=RTK_RG_L2TP && wan_type!=RTK_RG_VXLAN
#if defined(CONFIG_RG_RTL9600_SERIES)
				&& wan_type!=RTK_RG_DSLITE && wan_type!=RTK_RG_PPPoE_DSLITE
#endif
				)
    		{
		    	errorno=RT_ERR_RG_ROUTE_SET_FAIL;
				bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
			    rtEntry.valid=1;
			    rtEntry.process=L34_PROCESS_NH;
				if(napt_enable == 1)
			    	rtEntry.internal=0;		//external interface
			    else
					rtEntry.internal=1;		//internal interface
			    rtEntry.ipAddr=0;
			    rtEntry.ipMask=0;
			    // TODO:if load-balance is needed, here should be changed
			    rtEntry.nhStart=nxtidx; /*exact index*/
				rtEntry.nhNxt=nxtidx;
			    rtEntry.nhNum=0;		//exect Next hop number 1,2,4,8,16
			    rtEntry.nhAlgo=0;		//PER-PACKET
			    rtEntry.ipDomain=6;		//Entry 0~7
			    rtEntry.rt2waninf=1;

				//20161219LUKE: if we are setting same default route one more time, we should not increase nexthop ref count.
				if(rg_db.l3[V4_DEFAULT_ROUTE_IDX].valid && rg_db.l3[V4_DEFAULT_ROUTE_IDX].rtk_l3.process==L34_PROCESS_NH &&
					rg_db.l3[V4_DEFAULT_ROUTE_IDX].rtk_l3.nhStart==nxtidx)addNexthopCount=0;
			}
			else
			{
				//for PPTP and L2TP, we should set default route to TRAP!
				//for DSLITE, too.
				//for VXLAN, too.
				errorno=RT_ERR_RG_ROUTE_SET_FAIL;
				bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
			    rtEntry.valid=1;
			    rtEntry.process=L34_PROCESS_CPU;
				if(napt_enable == 1)
			    	rtEntry.internal=0;		//external interface
			    else
					rtEntry.internal=1;		//internal interface
			    rtEntry.ipAddr=0;
			    rtEntry.ipMask=0;
				rtEntry.netifIdx=matchIdx;
				// TODO:if load-balance is needed, here should be changed
			    rtEntry.nhStart=nxtidx; /*exact index*/
				rtEntry.nhNxt=nxtidx;
			    rtEntry.nhNum=0;		//exect Next hop number 1,2,4,8,16
			    rtEntry.nhAlgo=0;		//PER-PACKET
			    rtEntry.ipDomain=6;		//Entry 0~7
			    rtEntry.rt2waninf=1;
				addNexthopCount=0;
			}

			//WARNING("the added default routing's nexthop is %d, internal is %d, defaultRouteSet is %d, dhcpWAN_sem is %d",
				//rtEntry.nhStart,rtEntry.internal,rg_db.systemGlobal.defaultRouteSet,rg_db.systemGlobal.dhcpWAN_sem);

			//callback information
			bzero(&cb_routEt,sizeof(rtk_rg_ipv4RoutingEntry_t));
			cb_routEt.dest_ip=0;
			cb_routEt.ip_mask=0;
			cb_routEt.nexthop=remote_gw_ip;
			cb_routEt.wan_intf_idx=matchIdx;

			//WARNING("set to hardware table directly!!");
		    ret = RTK_L34_ROUTINGTABLE_SET(V4_DEFAULT_ROUTE_IDX, &rtEntry);		//set default route
		    if(ret!=RT_ERR_OK)goto RET_DEF_ROUTE_ERR;

			// TODO:Call the initParam's routngAddByHwCallBack
			if(rg_db.systemGlobal.initParam.routingAddByHwCallBack != NULL)
			{
				rg_db.systemGlobal.initParam.routingAddByHwCallBack(&cb_routEt);
			}

			if(addNexthopCount)rg_db.systemGlobal.nxpRefCount[nxtidx]++;		//nexthop reference by routing table
		}
	}
	if((default_route != 1)||(wan_type==RTK_RG_DSLITE)||(wan_type==RTK_RG_PPPoE_DSLITE))
	{
		//set STATIC ROUTE for nexthop
		//20150109LUKE: for dslite we should set nexthop information
		if((remote_gw_ip!=0 && !static_route_by_arp)||(wan_type==RTK_RG_DSLITE)||(wan_type==RTK_RG_PPPoE_DSLITE))
		{
			//check which routing entry we are setting
			bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
			for(i=0; i<MAX_L3_SW_TABLE_SIZE ; i++)
        	{
				if(i== V4_DEFAULT_ROUTE_IDX)
					continue;
            	if(rg_db.l3[i].rtk_l3.valid && rg_db.l3[i].rtk_l3.process==L34_PROCESS_CPU &&
					((!(wan_type==RTK_RG_PPPoE && wan_ext_ip_mask==0xffffffff) && (wan_ext_ip&wan_ext_ip_mask)==rg_db.l3[i].rtk_l3.ipAddr && wan_ext_ip_mask==rg_db.l3[i].netmask && wan_ext_ip==rg_db.l3[i].gateway_ip)	//check IP address should matched, not only belong to same domain.
					|| ((wan_type==RTK_RG_PPPoE && wan_ext_ip_mask==0xffffffff && remote_host_ip==0) && remote_gw_ip==rg_db.l3[i].rtk_l3.ipAddr && wan_ext_ip_mask==rg_db.l3[i].netmask)
					|| ((wan_type==RTK_RG_PPPoE && wan_ext_ip_mask==0xffffffff && remote_host_ip!=0) && remote_host_ip==rg_db.l3[i].rtk_l3.ipAddr && wan_ext_ip_mask==rg_db.l3[i].netmask)))
				{
					DEBUG("Match! %d",i);
					rtidx=i;
					break;
            	}
			}

			if(rtidx>=0)
			{
				errorno=RT_ERR_RG_ROUTE_SET_FAIL;
				memcpy(&rtEntry, &rg_db.l3[rtidx].rtk_l3,sizeof(rtk_l34_routing_entry_t));
#if defined(CONFIG_RG_RTL9600_SERIES)
			    if((wan_type!=RTK_RG_DSLITE)&&(wan_type!=RTK_RG_PPPoE_DSLITE))
#endif
					rtEntry.process=L34_PROCESS_NH;
				// TODO:if load-balance is needed, here should be changed
			    rtEntry.nhStart=nxtidx; /*exact index*/
				rtEntry.nhNxt=nxtidx;
			    rtEntry.nhNum=0;		//exect Next hop number 1,2,4,8,16
			    rtEntry.nhAlgo=0;		//PER-PACKET
			    rtEntry.ipDomain=6;		//Entry 0~7
			    rtEntry.rt2waninf=1;

				//20161219LUKE: if we are setting same static route one more time, we should not increase nexthop ref count.
				if((wan_type==RTK_RG_DSLITE)||(wan_type==RTK_RG_PPPoE_DSLITE)||
					(rg_db.l3[rtidx].valid && rg_db.l3[rtidx].rtk_l3.process==L34_PROCESS_NH &&rg_db.l3[rtidx].rtk_l3.nhStart==nxtidx))addNexthopCount=0;
				else addNexthopCount=1;

				//callback information
				bzero(&cb_routEt,sizeof(rtk_rg_ipv4RoutingEntry_t));
				cb_routEt.dest_ip=rtEntry.ipAddr;
				cb_routEt.ip_mask=wan_ext_ip_mask;
				cb_routEt.nexthop=remote_gw_ip;
				cb_routEt.wan_intf_idx=matchIdx;

			    ret = RTK_L34_ROUTINGTABLE_SET(rtidx, &rtEntry);		//set default route
			    if(ret!=RT_ERR_OK)goto RET_DEF_ROUTE_ERR;

				// TODO:Call the initParam's routngAddByHwCallBack
				if(rg_db.systemGlobal.initParam.routingAddByHwCallBack != NULL)
				{
					rg_db.systemGlobal.initParam.routingAddByHwCallBack(&cb_routEt);
				}

				if(addNexthopCount)rg_db.systemGlobal.nxpRefCount[nxtidx]++;		//nexthop reference by routing table
			}
		}
	}


#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if( ((rtidx>=0)&& (rtidx<MAX_L3_SW_TABLE_SIZE)) &&
		  ((((eipIdx >=0) && (eipIdx <MAX_EXTIP_SW_TABLE_SIZE)) && rg_db.extip[eipIdx].valid==SOFTWARE_ONLY_ENTRY) ||
	      (((nxtidx>=0)&& (nxtidx <MAX_NEXTHOP_SW_TABLE_SIZE)) && rg_db.nexthop[nxtidx].valid == SOFTWARE_ONLY_ENTRY) ||
	      ((matchIdx>=MAX_NETIF_HW_TABLE_SIZE)&&(matchIdx<MAX_NETIF_SW_TABLE_SIZE)) ||
	      ((rg_db.l3[rtidx].valid==SOFTWARE_ONLY_ENTRY))))
	{

		if((rg_db.systemGlobal.interfaceInfo[matchIdx].valid & IF_SOFTWARE4_ENTRY) ==0)
		{
			rtk_rg_aclAndCf_reserved_dip_mask_trap_t dip_mask_trap;
			bzero(&dip_mask_trap,sizeof(dip_mask_trap));
			dip_mask_trap.dip=rg_db.l3[rtidx].rtk_l3.ipAddr;
			dip_mask_trap.mask =~((1<<(31-(rg_db.l3[rtidx].rtk_l3.ipMask)))-1);
			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_RULE0_DIP_MASK_TRAP +rtidx, &dip_mask_trap);
			rg_db.systemGlobal.interfaceInfo[matchIdx].valid |= IF_SOFTWARE4_ENTRY;
			WARNING("ReservedRuleAdd software data path eipIdx=%d nxtidx=%d netif=%d L3Idx=%d",eipIdx,nxtidx,matchIdx,rtidx);
		}
	}
	if (rg_db.systemGlobal.interfaceInfo[matchIdx].valid > IF_VALID_ENTRY )// pure software netif
	{
		int iterPort=0;
		//Port bind , trap spa=bindPort packet
		for(iterPort=RTK_RG_MAC_PORT0; iterPort<RTK_RG_MAC_PORT_MAX-1; iterPort++)
		{
			if(RG_INVALID_MAC_PORT(iterPort)) continue;
			if(	rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask & (1<<iterPort))
			{
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP + iterPort, NULL);
				WARNING("ReservedRuleAdd Port Bind trap Port=%d",iterPort);
			}
		}
	}
#endif
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_db.systemGlobal.trap_routing_wan_by_acl)
	{
		if(rg_db.systemGlobal.interfaceInfo[matchIdx].valid&IF_SOFTWARE4_ENTRY)
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv4_TRAP+matchIdx);
	}
#endif


	//20161121LUKE: for dynamically update nexthop's MAC address, we should delete the original one.
	//FIXME: before delete lut we should check all of romote gateway not use ori_l2Idx
	if(!rg_db.systemGlobal.remoteGatewayMacStatically && ori_l2Idx!=rg_db.systemGlobal.defaultTrapLUTIdx)
		(pf.rtk_rg_macEntry_del)(ori_l2Idx);

    return (RT_ERR_RG_OK);


RET_DEF_ROUTE_ERR:
    //Delete the default route entry
    bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
    RTK_L34_ROUTINGTABLE_SET(V4_DEFAULT_ROUTE_IDX, &rtEntry);

	//Decrease eip and nexthop reference count
	if(eipIdx>=0){
		_rtk_rg_decreaseNexthopReference(nxtidx);
		_rtk_rg_decreaseExtIPReference(eipIdx);
	}
RET_NEXTHOP_ERR:
	//Recover original L2 idx
	nxpEt.nhIdx=ori_l2Idx;
	rg_db.nexthop[nxtidx].valid=1;
	RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);

	return (errorno);
}

int _rtk_rg_internal_GWMACSetup(ipaddr_t ipAddr, int l2Idx)
{
    return __rtk_rg_internal_GWMACSetup(ipAddr,l2Idx,1);
}

int _rtk_rg_internal_GWMACSetup_softUpdate(ipaddr_t ipAddr, int l2Idx)
{
	return __rtk_rg_internal_GWMACSetup(ipAddr,l2Idx,0);
}

int __rtk_rg_internal_GWMACSetup(ipaddr_t ipAddr, int l2Idx, int force)
{
    int i,matchIdx=-1,errorno;

    // TODO:After the Gateway mac is learned, we can finish add routing entry
    // TODO:and modify nexthop entry to correct LUT index

    //Check l2Idx for success or timeout
    errorno=RT_ERR_RG_ARP_NOT_FOUND;
    if(l2Idx == -1)goto END;

    //Check each wan interface for matching IPaddr
    for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
	{
    	//Bridge WAN won't be compared with
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			continue;

		if((force||rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gw_mac_auto_learn_for_ipv4) &&
			rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv4_addr == ipAddr)
		{
			matchIdx=rg_db.systemGlobal.wanIntfGroup[i].index;

			errorno=_rtk_rg_decCountSetStaticForGWMAC(ipAddr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			DEBUG("before GWMACsetup_stage 2 !!! ip is %x matchidx is %d, l2idx is %d",ipAddr,matchIdx,l2Idx);
			errorno = _rtk_rg_internal_GWMACSetup_stage2(matchIdx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			rg_db.systemGlobal.intfArpRequest[matchIdx].finished = 1;
			//break;
		}
    }
	errorno=RT_ERR_RG_INVALID_PARAM;
    if(matchIdx == -1)goto END;

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.intfArpRequest[matchIdx].finished = -1;
END:
    RETURN_ERR(errorno);
}

int _rtk_rg_internal_PPTPMACSetup(ipaddr_t ipAddr, int l2Idx)
{
    int i,matchIdx=-1,errorno;

    // TODO:After the Gateway mac is learned, we can finish add routing entry
    // TODO:and modify nexthop entry to correct LUT index

    //Check l2Idx for success or timeout
    errorno=RT_ERR_RG_ARP_NOT_FOUND;
    if(l2Idx == -1)goto RET_ERR;

    //Check each wan interface for matching IPaddr
    for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
    {
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_PPTP)
			continue;

		DEBUG("[%d] gateway %x ipaddr %x",i,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv4_addr,ipAddr);
		if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.pptp_info.before_dial.pptp_ipv4_addr == ipAddr)
		{
			matchIdx=rg_db.systemGlobal.wanIntfGroup[i].index;

			errorno=_rtk_rg_decCountSetStaticForGWMAC(ipAddr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			DEBUG("PPTP before GWMACsetup_stage 2 !!! ip is %x matchidx is %d, l2idx is %d",ipAddr,matchIdx,l2Idx);
			errorno = _rtk_rg_internal_GWMACSetup_stage2(matchIdx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		// software configuration was done, now start to configure flow path6 and extra tag content buffer
		errorno = _rtk_rg_flow_setupPPTP(matchIdx, l2Idx);
		if(errorno!=RT_ERR_RG_OK)goto RET_ERR;
#endif

			rg_db.systemGlobal.intfArpRequest[matchIdx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;
			//break;
		}
    }
	errorno=RT_ERR_RG_INVALID_PARAM;
    if(matchIdx == -1)goto RET_ERR;

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.intfArpRequest[matchIdx+MAX_NETIF_SW_TABLE_SIZE].finished = -1;

    RETURN_ERR(errorno);
}

int _rtk_rg_internal_L2TPMACSetup(ipaddr_t ipAddr, int l2Idx)
{
    int i,matchIdx=-1,errorno;

    // TODO:After the Gateway mac is learned, we can finish add routing entry
    // TODO:and modify nexthop entry to correct LUT index

    //Check l2Idx for success or timeout
    errorno=RT_ERR_RG_ARP_NOT_FOUND;
    if(l2Idx == -1)goto RET_ERR;

    //Check each wan interface for matching IPaddr
    for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
    {
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_L2TP)
			continue;

		DEBUG("[%d] gateway %x ipaddr %x",i,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv4_addr,ipAddr);
		if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.l2tp_info.before_dial.l2tp_ipv4_addr == ipAddr)
		{
			matchIdx=rg_db.systemGlobal.wanIntfGroup[i].index;

			errorno=_rtk_rg_decCountSetStaticForGWMAC(ipAddr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			DEBUG("L2TP before GWMACsetup_stage 2 !!! ip is %x matchidx is %d, l2idx is %d",ipAddr,matchIdx,l2Idx);
			errorno = _rtk_rg_internal_GWMACSetup_stage2(matchIdx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			// software configuration was done, now start to configure flow path6 and extra tag content buffer
			errorno = _rtk_rg_flow_setupL2TP(matchIdx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;
#endif

			rg_db.systemGlobal.intfArpRequest[matchIdx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;
			//break;
		}
    }
	errorno=RT_ERR_RG_INVALID_PARAM;
    if(matchIdx == -1)goto RET_ERR;

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.intfArpRequest[matchIdx+MAX_NETIF_SW_TABLE_SIZE].finished = -1;

    RETURN_ERR(errorno);
}

int _rtk_rg_internal_STATICROUTEMACSetup(ipaddr_t ipAddr, int l2Idx)
{
	int i,nxtidx,errorno;
	rtk_l34_nexthop_entry_t nxpEt;

	for(i=0;i<MAX_STATIC_ROUTE_SIZE;i++){
		if(rg_db.staticRoute[i].valid && !rg_db.staticRoute[i].info.ip_version &&
			rg_db.staticRoute[i].info.ipv4.nexthop==ipAddr){
			nxtidx=rg_db.l3[rg_db.staticRoute[i].route_idx].rtk_l3.nhStart;

			errorno=_rtk_rg_decCountSetStaticForGWMAC(ipAddr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			memcpy(&nxpEt, &rg_db.nexthop[nxtidx].rtk_nexthop, sizeof(rtk_l34_nexthop_entry_t));
			nxpEt.nhIdx=l2Idx;
			rg_db.nexthop[nxtidx].valid=1;
			ASSERT_EQ(RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt),RT_ERR_OK);
			TRACE("set staticRoute[%d]'s nexthop[%d] to Lut[%d]",i,nxtidx,l2Idx);
			//break;
		}
	}

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.staticRouteArpReq[i].finished = -1;

    RETURN_ERR(errorno);
}

int _rtk_rg_internal_STATICROUTEV6MACSetup(unsigned char *ipv6Addr, int l2Idx)
{
	int i,nxtidx,errorno;
	rtk_l34_nexthop_entry_t nxpEt;

	for(i=0;i<MAX_STATIC_ROUTE_SIZE;i++){
		if(rg_db.staticRoute[i].valid && rg_db.staticRoute[i].info.ip_version &&
			!memcmp(&rg_db.staticRoute[i].info.ipv6.nexthop.ipv6_addr,ipv6Addr,IPV6_ADDR_LEN)){
			nxtidx=rg_db.v6route[rg_db.staticRoute[i].route_idx].rtk_v6route.nhOrIfidIdx;

			errorno=_rtk_rg_decCountSetStaticForV6GWMAC(ipv6Addr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			memcpy(&nxpEt, &rg_db.nexthop[nxtidx].rtk_nexthop, sizeof(rtk_l34_nexthop_entry_t));
			nxpEt.nhIdx=l2Idx;
			rg_db.nexthop[nxtidx].valid=1;
			ASSERT_EQ(RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt),RT_ERR_OK);
			TRACE("set staticRoute[%d]'s nexthop[%d] to Lut[%d]",i,nxtidx,l2Idx);
			//break;
		}
	}

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.staticRouteNBDiscovery[i].finished = -1;

    RETURN_ERR(errorno);
}

int _rtk_rg_internal_IPV6WANTYPE_setup(int matchIdx)
{
	int i,nxtidx,ret,errorno;
	rtk_l34_nexthop_entry_t nxpEt;
	rtk_wanType_entry_t wantEt;
	unsigned int tmppmsk,tmpexpmsk;
	rtk_portmask_t out_mac_pmask,out_ext_pmask;
	rtk_rg_wan_type_t wan_type=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.wan_intf_conf.wan_type;

	nxtidx=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.nexthop_ipv6;
	if(nxtidx<0){
		//Check for empty entry
		errorno=RT_ERR_RG_ENTRY_FULL;
		for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++)
		{
			if(rg_db.systemGlobal.nxpRefCount[i] == 0)
				break;
		}
		if(i==MAX_NEXTHOP_SW_TABLE_SIZE)RETURN_ERR(errorno);

		nxtidx=i;	//keep

		//Setup Nexthop table in nxtidx
		errorno=RT_ERR_RG_NXP_SET_FAIL;
		bzero(&nxpEt,sizeof(rtk_l34_nexthop_entry_t));
		nxpEt.ifIdx=matchIdx;
		// if WAN is PPPoE, LAN is untag. (keepPppoe=1 will send untag packet to WAN)
		if((wan_type == RTK_RG_PPPoE)||(wan_type == RTK_RG_PPPoE_DSLITE)){
			nxpEt.type=L34_NH_PPPOE;
			#if defined(CONFIG_RG_RTL9602C_SERIES)
			nxpEt.keepPppoe=2; /* If original tagged, keep. Otherwise add tag with PPPIDX session id */
			#else
			nxpEt.keepPppoe=0;
			#endif
			nxpEt.pppoeIdx=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.pppoe_idx;
		}else{
			nxpEt.type=L34_NH_ETHER;
			nxpEt.keepPppoe=1;
			nxpEt.pppoeIdx=0;
		}

		// FIXME: here should to use binding remote host mac index, if port-binding is set
		nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;		//use this DUMMY index to force packet TRAP to CPU
		rg_db.nexthop[nxtidx].valid=1;
		ret = RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);
		if(ret!=RT_ERR_OK)RETURN_ERR(errorno);
		rg_db.systemGlobal.nxpRefCount[nxtidx]++;	//add for deleting it when del interface
		rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.nexthop_ipv6=nxtidx;
	}

	errorno=RT_ERR_RG_WANTYPE_SET_FAIL;
	bzero(&wantEt, sizeof(rtk_wanType_entry_t));

	wantEt.nhIdx=nxtidx;
	wantEt.wanType=L34_WAN_TYPE_L3_ROUTE;		//IPv6 only routing mode
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	//DEBUG("ipv6_napt_enable=%d",rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv6_napt_enable);
	if(rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv6_napt_enable){
		wantEt.wanType=L34_WAN_TYPE_L34NAT_ROUTE; //IPv6 NAPT
	}
#endif

	for(i=0;i<MAX_WANTYPE_SW_TABLE_SIZE;i++)
	{
		if(rg_db.wantype[i].valid==0)
			break;
	}
	if(i==MAX_WANTYPE_SW_TABLE_SIZE)RETURN_ERR(errorno);

	rg_db.wantype[i].valid=1;
	ret = RTK_L34_WANTYPETABLE_SET(i, &wantEt);
	if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
	{
		errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
		RETURN_ERR(errorno);
	}
	if(ret!=RT_ERR_OK)RETURN_ERR(errorno);

	DEBUG("### Add WANTYPE[%d]:(wanType=%d, wantEt=%d) ",i,wantEt.wanType,wantEt.nhIdx);

	rg_db.systemGlobal.nxpRefCount[wantEt.nhIdx]++;		//nexthop reference by WAN type table
	rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv6=i;
	DEBUG("create IPv6 wantype[%d]!!",rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv6);

	//update binding rules
	_rtk_rg_portmask_translator(rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask,&out_mac_pmask,&out_ext_pmask);
	tmppmsk=out_mac_pmask.bits[0];
	tmpexpmsk=out_ext_pmask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	tmpexpmsk >>= 0x1;	//FIXME:translator contain cpu port, but binding should not contain it, so shift it
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
	_rtk_rg_deletingPortBindFromInterface(matchIdx);
	_rtk_rg_addBindFromPortmask(tmppmsk,tmpexpmsk,matchIdx,rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv4,rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv6);

	//update vlan-binding
	ret=_rtk_rg_updatingVlanBind(matchIdx,rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv6);
	if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);

	return RT_ERR_RG_OK;
}

int _rtk_rg_internal_IPV6GWMACSetup_stage2(int matchIdx, int l2Idx)
{
	int i,nxtidx,rtidx=-1,ret,errorno;
	int ori_l2Idx=rg_db.systemGlobal.defaultTrapLUTIdx;
	int default_route=0;
	int wan_ext_ip_mask;
	int addNexthopCount=1;
	rtk_ipv6Routing_entry_t rtv6Entry;
    rtk_l34_nexthop_entry_t nxpEt;
	//rtk_l34_pppoe_entry_t pppoeEt;
    rtk_ipv6_addr_t wan_ext_ip,remote_gw_ip,zeroIP={{0}};
	rtk_rg_ipv6RoutingEntry_t cb_routv6Et;
	//rtk_wanType_entry_t wantEt;
	//unsigned int tmppmsk,tmpexpmsk;
	//rtk_portmask_t out_mac_pmask,out_ext_pmask;
	rtk_rg_wan_type_t wan_type;
	//int valid_macIdx;
	//int ori_wantype=0;
	//rtk_wanType_entry_t wantEt;
	if( matchIdx <0 || matchIdx>=MAX_NETIF_SW_TABLE_SIZE)
		return RT_ERR_RG_INVALID_PARAM;

	DEBUG("in _rtk_rg_internal_IPV6GWMACSetup_stage2, matchIdx is %d, l2Idx is %d",matchIdx,l2Idx);
	memcpy(&wan_ext_ip,&rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv6_addr,sizeof(rtk_ipv6_addr_t));
	wan_ext_ip_mask=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv6_mask_length;
	memcpy(&remote_gw_ip,&rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->gateway_ipv6_addr,sizeof(rtk_ipv6_addr_t));
	default_route=rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv6_default_gateway_on;
	wan_type=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.wan_intf_conf.wan_type;

	if(rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv6<0)
	{
		ret=_rtk_rg_internal_IPV6WANTYPE_setup(matchIdx);
		if(ret!=RT_ERR_RG_OK)RETURN_ERR(ret);
	}
	nxtidx=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.nexthop_ipv6;
	if(!((nxtidx>=0)&& (nxtidx <MAX_NEXTHOP_SW_TABLE_SIZE))){WARNING("nxtidx config Error nxtidx=%d",nxtidx);  return RT_ERR_RG_INVALID_PARAM;}

	//DEBUG("nxtidx=%d (matchIdx=%d  bind_wan_type_ipv6=%d)",nxtidx,matchIdx,rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.bind_wan_type_ipv6);

	//20180516LUKE:update nexthop only when we are pointed to different lut index.
	if(rg_db.nexthop[nxtidx].rtk_nexthop.nhIdx!=l2Idx)
	{
		bzero(&nxpEt, sizeof(rtk_l34_nexthop_entry_t));
		//20140623LUKE:copy from original nexthop for netifIdx and pppoeIdx
		memcpy(&nxpEt, &rg_db.nexthop[nxtidx].rtk_nexthop,sizeof(rtk_l34_nexthop_entry_t));

		//Setup Nexthop table in nxtidx
	    errorno=RT_ERR_RG_NXP_SET_FAIL;
		ori_l2Idx=nxpEt.nhIdx;	//Keep
	    nxpEt.nhIdx=l2Idx;			// TODO:LUT table index point to Gateway
	    //20140623LUKE:IPv6 should use 8~MAX_NEXTHOP_HW_TABLE_SIZE range
	    //nxtidx+=MAX_NETIF_HW_TABLE_SIZE;
	    rg_db.nexthop[nxtidx].valid=1;
	    ret = RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);
	    if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//20170203LUKE: if we are changing remote GW mac, we should delete related flow here.
		if(ori_l2Idx!=rg_db.systemGlobal.defaultTrapLUTIdx)
			_rtk_rg_flow_del_by_l2Idx(ori_l2Idx);
#endif
		DEBUG("### Add NEXTHOP[%d]:(valid=%d, ifIdx=%d, l2Idx=%d) ",nxtidx,rg_db.nexthop[nxtidx].valid,rg_db.nexthop[nxtidx].rtk_nexthop.ifIdx,rg_db.nexthop[nxtidx].rtk_nexthop.nhIdx);
	}


	//DEBUG("default_route = %d",default_route);
	//Setup Routing table for default route
    if(default_route == 1)
    {
    	//DEBUG("rg_db.systemGlobal.defaultIPV6RouteSet = %d, matchIdx=%d",rg_db.systemGlobal.defaultIPV6RouteSet,matchIdx);
    	if(rg_db.systemGlobal.defaultIPV6RouteSet == matchIdx)
    	{
		    errorno=RT_ERR_RG_ROUTE_SET_FAIL;
			bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
		    rtv6Entry.valid=1;
		    rtv6Entry.type=L34_IPV6_ROUTE_TYPE_GLOBAL;
			rtv6Entry.nhOrIfidIdx=nxtidx;
			rtv6Entry.rt2waninf=1;

			//20161219LUKE: if we are setting same default route one more time, we should not increase nexthop ref count.
			if(rg_db.v6route[V6_DEFAULT_ROUTE_IDX].rtk_v6route.valid && rg_db.v6route[V6_DEFAULT_ROUTE_IDX].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_GLOBAL &&
				rg_db.v6route[V6_DEFAULT_ROUTE_IDX].rtk_v6route.nhOrIfidIdx==nxtidx)addNexthopCount=0;
			else addNexthopCount=1;

			//callback information
			bzero(&cb_routv6Et,sizeof(rtk_rg_ipv6RoutingEntry_t));
			cb_routv6Et.NhOrIntfIdx=nxtidx;
			cb_routv6Et.type=rtv6Entry.type;

			//WARNING("set default route to real ipv6 hw table of %d, next is %d",V6_DEFAULT_ROUTE_IDX,nxtidx);
		    ret=RTK_L34_IPV6ROUTINGTABLE_SET(V6_DEFAULT_ROUTE_IDX, &rtv6Entry);		//set default route
		    if(ret!=RT_ERR_OK)goto RET_DEF_ROUTE_ERR;

			// TODO:Call the initParam's v6RoutingAddByHwCallBack
			if(rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack != NULL)
			{
				rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack(&cb_routv6Et);
			}

			if(addNexthopCount)rg_db.systemGlobal.nxpRefCount[nxtidx]++;		//nexthop reference by v6 routing table
    	}
	}
	else
	{
		//set STATIC ROUTE for nexthop
		if(memcmp(&remote_gw_ip,&zeroIP,sizeof(rtk_ipv6_addr_t)))
		{
			//20170316: trap WAN gateway ip of STATIC ROUTE with reserved acl, remove warning message.
			//WARNING("IPv6 STATIC ROUTE is set, all WANIP subnet will be transfer to remote gateway!! If packets head for this WAN ip, please add ACL rule for trapping it!!");

			//check which routing entry we are setting
			bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
			for(i=0; i<MAX_IPV6_ROUTING_SW_TABLE_SIZE ; i++)
        	{
				if(i == V6_DEFAULT_ROUTE_IDX)
					continue;
            	if(rg_db.v6route[i].rtk_v6route.valid && rg_db.v6route[i].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL &&
					!memcmp(&wan_ext_ip,&rg_db.v6route[i].rtk_v6route.ipv6Addr,sizeof(rtk_ipv6_addr_t)) && (wan_ext_ip_mask==rg_db.v6route[i].rtk_v6route.ipv6PrefixLen))
				{
					//Match!
					rtidx=i;
					break;
            	}
			}

			if(rtidx>=0)
			{
				errorno=RT_ERR_RG_ROUTE_SET_FAIL;
			    rtv6Entry.valid=1;
			    rtv6Entry.type=L34_IPV6_ROUTE_TYPE_GLOBAL;
				rtv6Entry.nhOrIfidIdx=nxtidx;
				rtv6Entry.ipv6PrefixLen=wan_ext_ip_mask;
				memcpy(&rtv6Entry.ipv6Addr,&wan_ext_ip,sizeof(rtk_ipv6_addr_t));
				rtv6Entry.rt2waninf=1;

				//20161219LUKE: if we are setting same static route one more time, we should not increase nexthop ref count.
				if(rg_db.v6route[rtidx].rtk_v6route.valid && rg_db.v6route[rtidx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_GLOBAL &&
					rg_db.v6route[rtidx].rtk_v6route.nhOrIfidIdx==nxtidx)addNexthopCount=0;
				else addNexthopCount=1;

				//callback information
				bzero(&cb_routv6Et,sizeof(rtk_rg_ipv6RoutingEntry_t));
				cb_routv6Et.NhOrIntfIdx=nxtidx;
				cb_routv6Et.type=rtv6Entry.type;

				ret=RTK_L34_IPV6ROUTINGTABLE_SET(rtidx, &rtv6Entry);		//set default route
			    if(ret!=RT_ERR_OK)goto RET_NEXTHOP_ERR;

				// TODO:Call the initParam's v6RoutingAddByHwCallBack
				if(rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack != NULL)
				{
					rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack(&cb_routv6Et);
				}

				if(addNexthopCount)rg_db.systemGlobal.nxpRefCount[nxtidx]++;		//nexthop reference by v6 routing table
			}
		}
	}

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if(((rtidx>=0)&&(rtidx<MAX_IPV6_ROUTING_SW_TABLE_SIZE)) &&
	    ( (rg_db.systemGlobal.interfaceInfo[matchIdx].p_wanStaticInfo->ipv6_napt_enable) ||
	      (rg_db.nexthop[nxtidx].valid == SOFTWARE_ONLY_ENTRY) ||
	      ((matchIdx>=MAX_NETIF_HW_TABLE_SIZE)&&(matchIdx<MAX_NETIF_SW_TABLE_SIZE)) ||
	      ((rg_db.v6route[rtidx].valid==SOFTWARE_ONLY_ENTRY))) )
	{
		if((rg_db.systemGlobal.interfaceInfo[matchIdx].valid &IF_SOFTWARE6_ENTRY) ==0)
		{
			// v6patch
			rtk_rg_aclAndCf_reserved_dipv6_mask_trap_t dipv6_mask_trap;
			int32 byteZeroCount =( (128-rg_db.v6route[rtidx].rtk_v6route.ipv6PrefixLen) /8);
			int32 residue = ( (128-rg_db.v6route[rtidx].rtk_v6route.ipv6PrefixLen) %8);
			bzero(&dipv6_mask_trap,sizeof(dipv6_mask_trap));
			memcpy(&dipv6_mask_trap.dipv6.ipv6_addr[0],&rg_db.v6route[rtidx].rtk_v6route.ipv6Addr.ipv6_addr[0],sizeof(dipv6_mask_trap.dipv6));

			memset(&dipv6_mask_trap.dipv6_mask.ipv6_addr[0],0xff,IPV6_ADDR_LEN);
			if(byteZeroCount)
				memset(&dipv6_mask_trap.dipv6_mask.ipv6_addr[IPV6_ADDR_LEN-byteZeroCount],0,byteZeroCount);
			if(residue)
				dipv6_mask_trap.dipv6_mask.ipv6_addr[IPV6_ADDR_LEN-byteZeroCount-1] &= (~((1<<residue) -1));

			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_RULE0_DIPv6_MASK_TRAP +rtidx, &dipv6_mask_trap);
			rg_db.systemGlobal.interfaceInfo[matchIdx].valid|=IF_SOFTWARE6_ENTRY;
			WARNING("ReservedRuleAdd software data path  nxtidx=%d  netifIdx=%d L3v6Idx=%d",nxtidx,matchIdx,rtidx);

		}

	}
	if (rg_db.systemGlobal.interfaceInfo[matchIdx].valid > IF_VALID_ENTRY )// pure software netif
	{
		int iterPort=0;
		//Port bind , trap spa=bindPort packet
		for(iterPort=RTK_RG_MAC_PORT0; iterPort<RTK_RG_MAC_PORT_MAX-1; iterPort++)
		{
			if(RG_INVALID_MAC_PORT(iterPort)) continue;
			if( rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask & (1<<iterPort))
			{
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP + iterPort, NULL);
				WARNING("ReservedRuleAdd Port Bind trap Port=%d",iterPort);
			}
		}
	}
#endif
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	//20170316: trap WAN gateway ip of IPv6 STATIC ROUTE with reserved acl
	if(rg_db.systemGlobal.interfaceInfo[matchIdx].valid&IF_SOFTWARE6_ENTRY)
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv6_TRAP+matchIdx);
#endif

	//20180517LUKE: for dynamically update nexthop's MAC address, we should delete the original one.
	//FIXME: before delete lut we should check all of romote gateway not use ori_l2Idx
	if(!rg_db.systemGlobal.remoteGatewayMacStatically && ori_l2Idx!=rg_db.systemGlobal.defaultTrapLUTIdx)
		(pf.rtk_rg_macEntry_del)(ori_l2Idx);


	return (RT_ERR_RG_OK);



RET_DEF_ROUTE_ERR:
	TRACE("Set default route error");
    //Delete the default route entry
    bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
    RTK_L34_IPV6ROUTINGTABLE_SET(V6_DEFAULT_ROUTE_IDX, &rtv6Entry);

RET_NEXTHOP_ERR:
	//Recover original L2 idx
	nxpEt.nhIdx=ori_l2Idx;
	rg_db.nexthop[nxtidx].valid=1;
	RTK_L34_NEXTHOPTABLE_SET(nxtidx, &nxpEt);

	return (errorno);
}

int _rtk_rg_internal_IPV6GWMACSetup(unsigned char *ipv6Addr, int l2Idx)
{
    return __rtk_rg_internal_IPV6GWMACSetup(ipv6Addr,l2Idx,1);
}

int _rtk_rg_internal_IPV6GWMACSetup_softUpdate(unsigned char *ipv6Addr, int l2Idx)
{
    return __rtk_rg_internal_IPV6GWMACSetup(ipv6Addr,l2Idx,0);
}

int __rtk_rg_internal_IPV6GWMACSetup(unsigned char *ipv6Addr, int l2Idx, int force)
{
    int i,matchIdx=-1,errorno;

    // TODO:After the Gateway mac is learned, we can finish add routing entry
    // TODO:and modify nexthop entry to correct LUT index
	DEBUG("in __rtk_rg_internal_IPV6GWMACSetup, l2idx is %d, force is %d",l2Idx,force);
    //Check l2Idx for success or timeout
    errorno=RT_ERR_RG_ARP_NOT_FOUND;
    if(l2Idx == -1)goto END;

    //Check each wan interface for matching IPaddr
    for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
    {
		//Bridge WAN won't be compared with
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			continue;

		if((force||rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gw_mac_auto_learn_for_ipv6) &&
			memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr,ipv6Addr,IPV6_ADDR_LEN)==0)
		{
			matchIdx=rg_db.systemGlobal.wanIntfGroup[i].index;

			errorno=_rtk_rg_decCountSetStaticForV6GWMAC(ipv6Addr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			DEBUG("before IPV6GWMACsetup_stage 2 !!! matchidx is %d, l2idx is %d",matchIdx,l2Idx);
			errorno = _rtk_rg_internal_IPV6GWMACSetup_stage2(matchIdx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			rg_db.systemGlobal.intfNeighborDiscovery[matchIdx].finished = 1;
			//break;
		}
    }

	errorno=RT_ERR_RG_INVALID_PARAM;
    if(matchIdx == -1)goto END;

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.intfNeighborDiscovery[matchIdx].finished = -1;
END:
    return (errorno);
}

int _rtk_rg_internal_IPV6AFTRMACSetup(unsigned char *ipv6Addr, int l2Idx)
{
	int i,matchIdx=-1,errorno;
#if defined(CONFIG_RG_RTL9602C_SERIES)
	rtk_l34_dsliteInf_entry_t *dsliteHw;
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//ApolloPro always trap if not hit flow
#else
	rtk_rg_aclAndCf_reserved_intf_dslite_trap_t intf_dslite_trap_para;
#endif

	DEBUG("in _rtk_rg_internal_IPV6AFTRMACSetup, l2idx is %d",l2Idx);
	//Check l2Idx for success or timeout
	errorno=RT_ERR_RG_ARP_NOT_FOUND;
	if(l2Idx == -1)goto RET_ERR;

	//Check each wan interface for matching IPaddr
	for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
	{
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_DSLITE)
			continue;

		if(memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.dslite_info.rtk_dslite.ipAftr.ipv6_addr,ipv6Addr,IPV6_ADDR_LEN)==0)
		{
			matchIdx=rg_db.systemGlobal.wanIntfGroup[i].index;

			errorno=_rtk_rg_decCountSetStaticForV6GWMAC(ipv6Addr, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			DEBUG("before AFTR GWMACsetup_stage 2 !!! matchidx is %d, l2idx is %d",matchIdx,l2Idx);
			errorno = _rtk_rg_internal_GWMACSetup_stage2(matchIdx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;

			rg_db.systemGlobal.intfNeighborDiscovery[matchIdx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			dsliteHw=&rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.dslite_info.rtk_dslite;
			dsliteHw->index=rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.dslite_idx;
			dsliteHw->valid=1;
			ASSERT_EQ(RTK_L34_DSLITEINFTABLE_SET(dsliteHw),RT_ERR_OK);
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//ApolloPro always trap if not hit flow
			// N/A

			// software configuration was done, now start to configure flow path6 and extra tag content buffer
			errorno = _rtk_rg_flow_setupDSLite(matchIdx, l2Idx, FALSE);
			if(errorno!=RT_ERR_RG_OK)goto RET_ERR;
#else
			//enable reserve ACL trap
			if(matchIdx < MAX_NETIF_HW_TABLE_SIZE)
			{
				memcpy(intf_dslite_trap_para.ipv6_dip.ipv6_addr, rg_db.systemGlobal.interfaceInfo[matchIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipB4.ipv6_addr, IPV6_ADDR_LEN);
				memcpy(intf_dslite_trap_para.smac.octet, rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet, ETHER_ADDR_LEN);
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP+matchIdx,&intf_dslite_trap_para);
			}
#endif
			//break;
		}
	}

	errorno=RT_ERR_RG_INVALID_PARAM;
	if(matchIdx == -1)goto RET_ERR;

	return (RT_ERR_RG_OK);

RET_ERR:
	rg_db.systemGlobal.intfNeighborDiscovery[matchIdx+MAX_NETIF_SW_TABLE_SIZE].finished = -1;

	return (errorno);
}

#if defined(CONFIG_SMP)
void _rtk_rg_arpRequestTimerFunc(unsigned long netIfIdx)
#else
//20181019LUKE: disable softirq and tasklet when execute timer function in uniprocessor.
void _rtk_rg_arpRequestTimerFunc_up(unsigned long netIfIdx);
void _rtk_rg_arpRequestTimerFunc(unsigned long netIfIdx)
{
	int smp_id=0;
	rg_inbound_queue_lock(smp_id,&rg_kernel.rg_inbound_queue_lock);
	_rtk_rg_arpRequestTimerFunc_up(netIfIdx);
	rg_inbound_queue_unlock(&rg_kernel.rg_inbound_queue_lock);
}
void _rtk_rg_arpRequestTimerFunc_up(unsigned long netIfIdx)
#endif
{
#ifdef __KERNEL__
	ipaddr_t ipAddr=0;
	rtk_l34_routing_entry_t rtEntry;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;
	int i;
	if(netIfIdx>=MAX_NETIF_SW_TABLE_SIZE) return;

	if(rg_db.systemGlobal.intfArpRequest[netIfIdx].finished==0)
	{
		if(rg_db.systemGlobal.interfaceInfo[netIfIdx].valid  && rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.is_wan == 1)
			ipAddr=rg_db.systemGlobal.interfaceInfo[netIfIdx].p_wanStaticInfo->ip_addr;
		else
			return;

		_rtk_rg_arpGeneration(netIfIdx,ipAddr,&rg_db.systemGlobal.intfArpRequest[netIfIdx]);
		rg_kernel.arpRequestTimerCounter[netIfIdx]++;

		//if(rg_kernel.arpRequestTimerCounter[netIfIdx]<10)
		if(1) //nerver timeout (always send arp): until finished=1
		{
			_rtk_rg_mod_timer(&rg_kernel.arpRequestTimer[netIfIdx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));

		}
		else
		{
			//error happen..recovery what we did before
			//Check which ARP routing entry we added
	        for(i=0; i<MAX_L3_SW_TABLE_SIZE ; i++)	//because idx MAX_L3_SW_TABLE_SIZE-1 is reserved for default route
	        {
				if(i== V4_DEFAULT_ROUTE_IDX)
					continue;
	            //bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
	            //rtk_l34_routingTable_get(i, &rtEntry);
	            //if(rtEntry.ipAddr == ipAddr && rtEntry.process == L34_PROCESS_ARP)
	            if(rg_db.l3[i].rtk_l3.ipAddr == ipAddr && rg_db.l3[i].rtk_l3.process == L34_PROCESS_ARP)
	            {
	            	//Delete the routing entry added and call callback function
	            	bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
					bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
					cb_routEt.dest_ip=rg_db.l3[i].rtk_l3.ipAddr;
					cb_routEt.ip_mask=rg_db.l3[i].netmask;
		            RTK_L34_ROUTINGTABLE_SET(i, &rtEntry);
	            	if(rg_db.systemGlobal.initParam.routingDelByHwCallBack != NULL)
					{
						cb_routEt.nexthop=0;
						cb_routEt.wan_intf_idx=netIfIdx;
						rg_db.systemGlobal.initParam.routingDelByHwCallBack(&cb_routEt);
					}
					break;
	            }
	        }

			//reset Global variable
			bzero(rg_db.systemGlobal.interfaceInfo[netIfIdx].p_wanStaticInfo, sizeof(rtk_rg_ipStaticInfo_t));
			rg_db.systemGlobal.intfArpRequest[netIfIdx].finished=-1;

			rtlglue_printf("the ARP request failed when set up WAN interface..\n");
		}
	}
#endif
}

#if defined(CONFIG_SMP)
void _rtk_rg_staticRouteArpOrNbReqTimerFunc(unsigned long sridx)
#else
//20181019LUKE: disable softirq and tasklet when execute timer function in uniprocessor.
void _rtk_rg_staticRouteArpOrNbReqTimerFunc_up(unsigned long sridx);
void _rtk_rg_staticRouteArpOrNbReqTimerFunc(unsigned long sridx)
{
	int smp_id=0;
	rg_inbound_queue_lock(smp_id,&rg_kernel.rg_inbound_queue_lock);
	_rtk_rg_staticRouteArpOrNbReqTimerFunc_up(sridx);
	rg_inbound_queue_unlock(&rg_kernel.rg_inbound_queue_lock);
}
void _rtk_rg_staticRouteArpOrNbReqTimerFunc_up(unsigned long sridx)
#endif
{
#ifdef __KERNEL__
	if(sridx>=MAX_STATIC_ROUTE_SIZE) return;

	if(rg_db.systemGlobal.staticRouteArpReq[sridx].finished==0){
		_rtk_rg_arpGeneration(rg_db.staticRoute[sridx].nxtip_intfidx,rg_db.l3[rg_db.staticRoute[sridx].nxtip_rtidx].gateway_ip,&rg_db.systemGlobal.staticRouteArpReq[sridx]);
	}else if(rg_db.systemGlobal.staticRouteNBDiscovery[sridx].finished==0){
		_rtk_rg_NDGeneration(rg_db.staticRoute[sridx].nxtip_intfidx,rg_db.v6route[rg_db.staticRoute[sridx].nxtip_rtidx].gateway_ipv6Addr,&rg_db.systemGlobal.staticRouteNBDiscovery[sridx]);
	}
	rg_kernel.staticRouteArpOrNBTimerCounter[sridx]++;

	//if(rg_kernel.staticRouteArpOrNBReqTimer[netIfIdx]<10)
	if(1) //nerver timeout (always send arp): until finished=1
	{
		_rtk_rg_mod_timer(&rg_kernel.staticRouteArpOrNBReqTimer[sridx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));
	}
#endif
}

#if defined(CONFIG_SMP)
void _rtk_rg_PPTPL2TPDiscoveryTimerFunc(unsigned long netIfIdx)
#else
//20181019LUKE: disable softirq and tasklet when execute timer function in uniprocessor.
void _rtk_rg_PPTPL2TPDiscoveryTimerFunc_up(unsigned long netIfIdx);
void _rtk_rg_PPTPL2TPDiscoveryTimerFunc(unsigned long netIfIdx)
{
	int smp_id=0;
	rg_inbound_queue_lock(smp_id,&rg_kernel.rg_inbound_queue_lock);
	_rtk_rg_PPTPL2TPDiscoveryTimerFunc_up(netIfIdx);
	rg_inbound_queue_unlock(&rg_kernel.rg_inbound_queue_lock);
}
void _rtk_rg_PPTPL2TPDiscoveryTimerFunc_up(unsigned long netIfIdx)
#endif
{
#ifdef __KERNEL__
	ipaddr_t ipAddr=0;
	int realIfIdx=netIfIdx-MAX_NETIF_SW_TABLE_SIZE;
	int matchIdx;
	if(netIfIdx>=(MAX_NETIF_SW_TABLE_SIZE<<1)) return;

	if(rg_db.systemGlobal.intfArpRequest[netIfIdx].finished==0){
		if(rg_db.systemGlobal.interfaceInfo[realIfIdx].valid  && rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.is_wan == 1){
			matchIdx=_rtk_rg_l3lookup(rg_db.systemGlobal.intfArpRequest[netIfIdx].reqIp);

			if(rg_db.l3[matchIdx].rtk_l3.process==L34_PROCESS_NH && realIfIdx!=rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.ifIdx){
				//use the NH to get MAC idx!!
				if(rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP)
					_rtk_rg_internal_PPTPMACSetup(rg_db.systemGlobal.intfArpRequest[netIfIdx].reqIp, rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.nhIdx);
				else
					_rtk_rg_internal_L2TPMACSetup(rg_db.systemGlobal.intfArpRequest[netIfIdx].reqIp, rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.nhIdx);
				rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.wan_intf.baseIntf_idx=rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.ifIdx;
				return;
			}else if(rg_db.l3[matchIdx].rtk_l3.process==L34_PROCESS_CPU){
				if((rg_db.systemGlobal.interfaceInfo[rg_db.l3[matchIdx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
					rg_db.systemGlobal.interfaceInfo[rg_db.l3[matchIdx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
					rg_db.systemGlobal.interfaceInfo[rg_db.l3[matchIdx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
					rg_db.systemGlobal.interfaceInfo[rg_db.l3[matchIdx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)&&
					realIfIdx!=rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.ifIdx){
					//use the NH to get MAC idx!!
					if(rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP)
						_rtk_rg_internal_PPTPMACSetup(rg_db.systemGlobal.intfArpRequest[netIfIdx].reqIp, rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.nhIdx);
					else
						_rtk_rg_internal_L2TPMACSetup(rg_db.systemGlobal.intfArpRequest[netIfIdx].reqIp, rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.nhIdx);
					rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.wan_intf.baseIntf_idx=rg_db.nexthop[rg_db.l3[matchIdx].rtk_l3.nhStart].rtk_nexthop.ifIdx;
					return;
				}
			}
			ipAddr=rg_db.systemGlobal.interfaceInfo[realIfIdx].p_wanStaticInfo->ip_addr;
		}else
			return;

		_rtk_rg_arpGeneration(realIfIdx,ipAddr,&rg_db.systemGlobal.intfArpRequest[netIfIdx]);
		rg_kernel.arpRequestTimerCounter[netIfIdx]++;

		//if(rg_kernel.arpRequestTimerCounter[netIfIdx]<10)
		if(1){ //nerver timeout (always send arp): until finished=1
			_rtk_rg_mod_timer(&rg_kernel.arpRequestTimer[netIfIdx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));

		}
	}
#endif
}

void _rtk_rg_PPTPLearningTimerInitialize(int wan_intf_idx)
{
	int arp_req_idx=wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE;

	rg_db.systemGlobal.intfArpRequest[arp_req_idx].finished=0;
	rg_db.systemGlobal.intfArpRequest[arp_req_idx].reqIp=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.before_dial.pptp_ipv4_addr;
	rg_db.systemGlobal.intfArpRequest[arp_req_idx].gwMacReqCallBack=_rtk_rg_internal_PPTPMACSetup;
	rg_db.systemGlobal.intfArpRequest[arp_req_idx].disableL3Inspect=0;

#ifdef __KERNEL__

	_rtk_rg_del_timer(&rg_kernel.arpRequestTimer[arp_req_idx]);
	_rtk_rg_init_timer(&rg_kernel.arpRequestTimer[arp_req_idx]);

	rg_kernel.arpRequestTimer[arp_req_idx].data = (unsigned long)(arp_req_idx);
	rg_kernel.arpRequestTimer[arp_req_idx].function = _rtk_rg_PPTPL2TPDiscoveryTimerFunc;
	rg_kernel.arpRequestTimerCounter[arp_req_idx]=0;
	DEBUG("PPTP miss, request arp=%x\n",rg_db.systemGlobal.intfArpRequest[arp_req_idx].reqIp);
	_rtk_rg_mod_timer(&rg_kernel.arpRequestTimer[arp_req_idx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));


#endif
}

void _rtk_rg_L2TPLearningTimerInitialize(int wan_intf_idx)
{
	int arp_req_idx=wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE;

	rg_db.systemGlobal.intfArpRequest[arp_req_idx].finished=0;
	rg_db.systemGlobal.intfArpRequest[arp_req_idx].reqIp=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.l2tp_info.before_dial.l2tp_ipv4_addr;
	rg_db.systemGlobal.intfArpRequest[arp_req_idx].gwMacReqCallBack=_rtk_rg_internal_L2TPMACSetup;
	rg_db.systemGlobal.intfArpRequest[arp_req_idx].disableL3Inspect=0;

#ifdef __KERNEL__

	_rtk_rg_del_timer(&rg_kernel.arpRequestTimer[arp_req_idx]);
	_rtk_rg_init_timer(&rg_kernel.arpRequestTimer[arp_req_idx]);

	rg_kernel.arpRequestTimer[arp_req_idx].data = (unsigned long)(arp_req_idx);
	rg_kernel.arpRequestTimer[arp_req_idx].function = _rtk_rg_PPTPL2TPDiscoveryTimerFunc;

	rg_kernel.arpRequestTimerCounter[arp_req_idx]=0;
	DEBUG("L2TP miss, request arp=%x\n",rg_db.systemGlobal.intfArpRequest[arp_req_idx].reqIp);
	_rtk_rg_mod_timer(&rg_kernel.arpRequestTimer[arp_req_idx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));


#endif
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_successFailReturn_t _rtk_rg_skipNeighborLearningOrNot(int l3Idx, uint8 *sip, int srcPortIdx, uint8 *smac)
{
	int hashValue, neighborIdx, i, l2Idx;

	if(rg_db.systemGlobal.antiMacSpoofStatus==RTK_RG_ENABLED) {
		hashValue=_rtk_rg_IPv6NeighborHash(sip+8, l3Idx);
		neighborIdx=(hashValue<<MAX_IPV6_NEIGHBOR_HASH_WAY_SHIFT);
		for(i=0; i<MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE; i++)	{	//8-way hash
			//find the same entry first.
			if((rg_db.v6neighbor[neighborIdx+i].neighborEntry.valid)&&
				(rg_db.v6neighbor[neighborIdx+i].neighborEntry.matchRouteIdx==l3Idx)&&
				(_rtk_rg_ipv6IFIDCompare(rg_db.v6route[l3Idx].rtk_v6route.ipv6PrefixLen, sip, rg_db.v6neighbor[neighborIdx+i].neighborEntry.interfaceId))) {

				l2Idx = rg_db.v6neighbor[neighborIdx+i].neighborEntry.l2Idx;
				if(rg_db.lut[l2Idx].rtk_lut.entryType==RTK_LUT_L2UC &&
					memcmp(rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet, smac,ETHER_ADDR_LEN)) {

					TRACE("Anti spoofing: neighbor entry already exist (%d), discard learning !", neighborIdx+i);
					return RG_RET_FAIL;
				}

			}
		}
	}

	return RG_RET_SUCCESS;
}


__SRAM_FWDENG_SLOWPATH
rtk_rg_successFailReturn_t _rtk_rg_skipARPLearningOrNot(int l3Idx, ipaddr_t sip, int srcPortIdx, uint8 *smac)
{

	// 1. Gateway IP should not add to ARP table
	// 2. if anti spoofing is enabled, discard arp update from same IP with diff MAC.

	int i, arpIdx, arpValid=0, l2Idx;
	ipaddr_t ipAddr;

	for(i=0; i<MAX_NETIF_SW_TABLE_SIZE; i++)
	{
		if(rg_db.systemGlobal.interfaceInfo[i].valid==0) continue;
		if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1)
		{
			if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
				continue;
			//not bridge wan
			ipAddr=rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->ip_addr;
		}
		else
		{
			ipAddr=rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.ip_addr;
		}

		if(sip==ipAddr)
		{
			TRACE("source IP equals to interface[%d]'s gateway IP[0x%x]...skip learning", i, ipAddr);
			return RG_RET_FAIL;
		}
	}

	if(rg_db.l3[l3Idx].rtk_l3.valid && rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].valid)
	{
		if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.is_wan)
		{
#if 0	//support multiple WAN using the same IP/subnet, but different VLAN/MAC/Port.
			{
				//Check Src port in interface's VLAN member or not
				if(srcPortIdx>=RTK_RG_PORT_CPU)
				{
					if((rg_db.vlan[rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id].Ext_portmask.bits[0]&(0x1<<(srcPortIdx-RTK_RG_PORT_CPU)))==0)	//extension port not exist
					{
						TRACE("source Extension Port %d is not in WAN interface[%d]'s VLAN[%d]...skip learning",srcPortIdx,rg_db.l3[l3Idx].rtk_l3.netifIdx,rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
						return RG_RET_FAIL;
					}
				}
				/*
				else if((rg_db.vlan[rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id].MemberPortmask.bits[0]&(0x1<<srcPortIdx))==0)	//utp port not exist
				{
					TRACE("source Port %d is not in WAN interface[%d]'s VLAN...skip learning",srcPortIdx,rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
					return RG_RET_FAIL;
				}
				*/
			}
#endif
		} else	{
			if(rg_db.systemGlobal.antiMacSpoofStatus==RTK_RG_ENABLED) {
#if defined(CONFIG_RG_RTL9600_SERIES)
				arpIdx = (rg_db.l3[l3Idx].rtk_l3.arpStart<<2)+(sip & ((1<<(31-rg_db.l3[l3Idx].rtk_l3.ipMask))-1));
				arpValid = rg_db.arp[arpIdx].rtk_arp.valid;

#elif defined(CONFIG_RG_RTL9602C_SERIES)
				rtk_rg_arp_linkList_t *pSwArpList;
				rtk_rg_arp_linkList_t *pHwArpList;

				_rtk_rg_softwareArpTableLookUp(l3Idx,sip,&pSwArpList,1);

				if(pSwArpList) {
					arpValid = 1;
					arpIdx = pSwArpList->idx;
				} else {
					_rtk_rg_hardwareArpTableLookUp(l3Idx,sip,&pHwArpList,1);
					if(pHwArpList) {
						arpValid = 1;
						arpIdx = pHwArpList->idx;
					} else {
						arpValid = 0;
					}
				}
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
				rtk_rg_arp_linkList_t *pSwArpList;

				_rtk_rg_softwareArpTableLookUp(l3Idx,sip,&pSwArpList,1);
				if(pSwArpList)
				{
					arpValid = 1;
					arpIdx = pSwArpList->idx;
				}
#else
#error
#endif
				if(arpValid) {
					l2Idx = rg_db.arp[arpIdx].rtk_arp.nhIdx;

					if(rg_db.lut[l2Idx].rtk_lut.entryType==RTK_LUT_L2UC && memcmp(rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet, smac,ETHER_ADDR_LEN)) {

						TRACE("Anti MAC spoofing: ARP entry already exist, discard learning !");
						return RG_RET_FAIL;
					}

				}
			}

			//Check Src port in interface's VLAN member or not
			if(_rtk_rg_fwdEngineVLANFiltering(rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.lan_intf.intf_vlan_id, rg_db.pktHdr->ingressMacPort, rg_db.pktHdr->ingressMacExtPort, rg_db.pktHdr->wlan_dev_idx)==RG_FWDENGINE_RET_DROP)
			{
				TRACE("source Port %d is not in LAN interface[%d]'s VLAN[%d]...skip learning", srcPortIdx, rg_db.l3[l3Idx].rtk_l3.netifIdx,rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.lan_intf.intf_vlan_id);
				return RG_RET_FAIL;
			}
		}

		return RG_RET_SUCCESS;
	}

	return RG_RET_FAIL;
}

void _rtk_rg_wanAccessLimitCheck(int srcPortIdx, int srcWlanDevIdx, int *pL34Permit)
{
	if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_PORTMASK)
	{
		if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<srcPortIdx)
#ifdef CONFIG_MASTER_WLAN0_ENABLE
				|| (srcPortIdx==RTK_RG_EXT_PORT0 && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<srcWlanDevIdx)))
#endif
			)
		{
			if(*pL34Permit==WanAccessLimitPermit)return;
			//20190422LUKE:check DIP=GWIP, set WanAccessLimitCheck and return
			if(_rtk_rg_checkGwIp(rg_db.pktHdr)==RG_FWDENGINE_RET_TO_PS)
			{
				*pL34Permit=WanAccessLimitCheck;
				return;
			}
			if(rg_db.systemGlobal.accessWanLimitPortMask<=atomic_read(&rg_db.systemGlobal.accessWanLimitPortMaskCount))
			{
				MACLN("Portmask access WAN limit is reached(%d)...action is %s!!",rg_db.systemGlobal.accessWanLimitPortMask,
					rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT?"Permit and Forward":
					rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT_L2?"Permit L2 only":"Drop");
				if(rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT)
					*pL34Permit=WanAccessLimitCheck;
				else
				{
					*pL34Permit=WanAccessLimitForbid;
					if(rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT_L2)
					{
						//trigger for ARP and Neighbor discovery for port, mask, and category
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						_rtk_rg_lutReachLimit_init(RG_ACCESSWAN_TYPE_PORTMASK, _rtk_rg_lutReachLimit_portmask, (unsigned long)(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask|(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member<<16)));
#else
						_rtk_rg_lutReachLimit_init(RG_ACCESSWAN_TYPE_PORTMASK, _rtk_rg_lutReachLimit_portmask, (unsigned long)rg_db.systemGlobal.accessWanLimitPortMask_member.portmask);
#endif
					}
				}
				return;
			}
			atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
			*pL34Permit=WanAccessLimitPermit;
			return;
		}
		else
		{
			if(*pL34Permit==WanAccessLimitPermit)
				atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
			*pL34Permit=WanAccessLimitCheck;
		}
	}
}

uint32 _rtk_rg_arpStatic_check(ipaddr_t checkIp)
{
	int i;

	for(i=0; i<MAX_NETIF_SW_TABLE_SIZE; i++)
	{
		if(rg_db.systemGlobal.interfaceInfo[i].valid==0) continue;
		if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1)
		{
			if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
				continue;
			//not bridge wan
			if(checkIp==rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->ip_addr
				|| checkIp==rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->gateway_ipv4_addr)
				return TRUE;
		}
		else
		{
			if(checkIp==rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.ip_addr)
				return TRUE;
		}
	}

	return FALSE;
}

rtk_rg_successFailReturn_t _rtk_rg_arpAndMacEntryAdd(ipaddr_t sip, int sipL3Idx, uint8 *pSmac, int srcPortIdx, int srcWlanDevIdx, int *pL2Idx, int cvid, int cvidForceAdd, int arpEntryForceAdd)
{
	rtk_rg_arpEntry_t arpEntry;
	rtk_rg_macEntry_t macEntry;
	rtk_rg_arp_linkList_t *pSwArpList;
#if defined(CONFIG_RG_RTL9602C_SERIES)
	rtk_rg_arp_linkList_t *pHwArpList;
#endif
	int arpIdx,l2Idx,l34Permit=WanAccessLimitForbid;
	int ret;
	short l3Idx,search_index,sw_lut_vlan=-1;
	short count=0,first_invalid=-1;
	int8 arp_valid=0,mac_exist=0,addArp=1;//,dmac2CVID_Untag=0;
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLutNext;
	uint32 check_ivl_vid, ivlL2Idx;
	rtk_rg_table_arp_t *pExistArp=NULL;

	if(sipL3Idx==FAIL)
		l3Idx=_rtk_rg_l3lookup(sip);
	else
		l3Idx=sipL3Idx;

	//init
	memset(&macEntry,0,sizeof(rtk_rg_macEntry_t));

	if(rg_db.l3[l3Idx].rtk_l3.process==L34_PROCESS_ARP)
	{
		//Check if we skip ARP learning or not
		ret=_rtk_rg_skipARPLearningOrNot(l3Idx,sip,srcPortIdx, pSmac);
		if(ret!=RG_RET_SUCCESS)return ret;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		goto check_sw_arp;
#elif defined(CONFIG_RG_RTL9600_SERIES)
		arpIdx=(rg_db.l3[l3Idx].rtk_l3.arpStart<<2)+(sip & ((1<<(31-rg_db.l3[l3Idx].rtk_l3.ipMask))-1));
		arp_valid = rg_db.arp[arpIdx].rtk_arp.valid;
		if(arp_valid)
		{
			//20141013LUKE: update ARP idle time
			rg_db.arp[arpIdx].idleSecs=0;
			rg_db.arp[arpIdx].sendReqCount=0;
			//20170302LUKE: minus count when arp is permited and ingress port is in mask, or not permited and ingress port is not in mask.
			pExistArp=&rg_db.arp[arpIdx];
			if(arpEntryForceAdd)
			{
				if(rg_db.arp[arpIdx].staticEntry)		//the static entry should not be replaced
				{
					TRACE("ARP entry is valid and STATIC...skip add ARP");
					//don't add ARP, but create new MAC entry
					addArp=0;
					if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[arpIdx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
				}
			}
			else
			{
				//don't add ARP, but create new MAC entry
				addArp=0;
				if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[arpIdx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
			}
		}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
		_rtk_rg_softwareArpTableLookUp(l3Idx,sip,&pSwArpList,1);
		if(pSwArpList!=NULL)	//sw arp is found
		{
			arp_valid=1;
			//20170302LUKE: minus count when arp is permited and ingress port is in mask, or not permited and ingress port is not in mask.
			pExistArp=&rg_db.arp[pSwArpList->idx];
			if(arpEntryForceAdd)		//need to replace ARP link-list
			{
				if(rg_db.arp[pSwArpList->idx].staticEntry==0)
					addArp=2;	//add to sw link-list
				else
				{
					TRACE("software ARP link-list is valid and STATIC...skip add ARP");

					addArp=0;
					if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[pSwArpList->idx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
				}
			}
			else		//did not add to software ARP table
			{
				TRACE("software ARP entry is added...skip add ARP");

				addArp=0;
				if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[pSwArpList->idx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
			}
		}
		else	// sw arp is not found
		{
			_rtk_rg_hardwareArpTableLookUp(l3Idx,sip,&pHwArpList,1);
			if(pHwArpList!=NULL)	//hw arp is found
			{
				arp_valid = 1;
				//20170302LUKE: minus count when arp is permited and ingress port is in mask, or not permited and ingress port is not in mask.
				pExistArp=&rg_db.arp[pHwArpList->idx];
				if(arpEntryForceAdd)
				{
					if(rg_db.arp[pHwArpList->idx].staticEntry==0)
					{
						TRACE("HW ARP entry is added again...since arpEntryForceAdd==1");
						addArp=1;
					}
					else	//the static entry should not be replaced
					{
						TRACE("HW ARP entry is valid and STATIC...skip add ARP");
						//don't add ARP, but create new MAC entry
						addArp=0;
						if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[pHwArpList->idx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
					}
				}
				else
				{
					TRACE("HW ARP entry is added...skip add ARP");
					//don't add ARP, but create new MAC entry
					addArp=0;
					if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[pHwArpList->idx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
				}
			}
			else	// sw arp and hw arp are not found
			{
				arp_valid=0;
				if(list_empty(&rg_db.hardwareArpFreeListHead))
					addArp=2;	//add to sw link-list
				else
					addArp=1;	//add to hw table
			}
		}

#endif

		//get VID
		if(cvidForceAdd==1)
			macEntry.vlan_id=cvid;	//from ingress vid
		else
			macEntry.vlan_id=rg_db.netif[rg_db.l3[l3Idx].rtk_l3.netifIdx].rtk_netif.vlan_id;
	}
	else if(rg_db.l3[l3Idx].rtk_l3.process==L34_PROCESS_CPU)
	{
		if(rg_db.l3[l3Idx].rtk_l3.ipAddr>0)		//non-default route's TRAP routing should add to sw ARP table
		{
			//Check if we skip ARP learning or not
			ret=_rtk_rg_skipARPLearningOrNot(l3Idx,sip,srcPortIdx, pSmac);
			if(ret!=RG_RET_SUCCESS)return ret;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
check_sw_arp:
#endif
			//FIXME:till now default route to CPU is to protocol, if sw routing link-list is implement,
			//the default route in hw will means routing should check sw routing link-list, too.
			_rtk_rg_softwareArpTableLookUp(l3Idx,sip,&pSwArpList,1);
			if(pSwArpList!=NULL)
			{
				//20170302LUKE: minus count when arp is permited and ingress port is in mask, or not permited and ingress port is not in mask.
				pExistArp=&rg_db.arp[pSwArpList->idx];
				if(arpEntryForceAdd)		//need to replace ARP link-list
				{
					if(rg_db.arp[pSwArpList->idx].staticEntry==0)
						addArp=2;	//add to sw link-list
					else
					{
						TRACE("software ARP link-list is valid and STATIC...skip add ARP");
						arp_valid=1;
						addArp=0;
						if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[pSwArpList->idx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
					}
				}
				else		//did not add to software ARP table
				{
					TRACE("software ARP entry is added...skip add ARP");
					arp_valid=1;
					addArp=0;
					if(pL2Idx!=NULL)*pL2Idx=rg_db.arp[pSwArpList->idx].rtk_arp.nhIdx;	//return the l2 idx which pointed by arp entry
				}
			}
			else
				addArp=2;	//add to sw link-list

			//get VID
			if(cvidForceAdd==1)
				macEntry.vlan_id=cvid;	//from ingress vid
			else
				macEntry.vlan_id=rg_db.netif[rg_db.l3[l3Idx].rtk_l3.netifIdx].rtk_netif.vlan_id;
		}
		else
		{
			TRACE("%x from default route with ingress VID %d!!...skip add ARP",sip,cvid);
			//from default route, do not add ARP
			addArp=0;

			//get VID from ingress VID
			if(rg_db.vlan[cvid].valid)
				macEntry.vlan_id=cvid;
			else
				return RG_RET_FAIL;	//VLAN not exist
		}
	}
	else if(rg_db.l3[l3Idx].rtk_l3.process==L34_PROCESS_NH)		//default route should not add to ARP table, and non-default gateway host should not enable arp_used field
	{
		addArp=0;
		TRACE("from NH interface!!");
		if(rg_db.lut[rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.nhIdx].valid &&
			rg_db.lut[rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.nhIdx].rtk_lut.entryType==RTK_LUT_L2UC &&
			memcmp(rg_db.lut[rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.nhIdx].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)==0)
		{
			//20141013LUKE: update software ARP idle time if match!!
			_rtk_rg_softwareArpTableLookUp(l3Idx, sip, &pSwArpList, 1);
			if(pL2Idx!=NULL)*pL2Idx=rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.nhIdx;
			return RG_RET_SUCCESS;		//default already added
		}

		TRACE("non-default gateway host....add MAC without arp_used!!");

		//get VID
		if(cvidForceAdd==1)
			macEntry.vlan_id=cvid;	//from ingress vid
		else
			macEntry.vlan_id=rg_db.netif[rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.ifIdx].rtk_netif.vlan_id;
	}

	//20170303LUKE: check wan access limit if activeLimitField is RG_ACCESSWAN_LIMIT_BY_SIP
	//20171129LUKE: check limit only when arp will be added with valid sip
	if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP && sip && (addArp||pExistArp)){
		if(pExistArp)l34Permit=pExistArp->permit_for_l34_forward;
		_rtk_rg_wanAccessLimitCheck(srcPortIdx, srcWlanDevIdx, &l34Permit);
		if(pExistArp)pExistArp->permit_for_l34_forward=l34Permit;
		if(l34Permit==WanAccessLimitForbid){//drop
			if(pL2Idx!=NULL)*pL2Idx=FAIL-1;
			pr_err_ratelimited("[Error][WarnLog] Portmask Limit Action: %s. SMAC:%02x-%02x-%02x-%02x-%02x-%02x SIP:%d.%d.%d.%d\n",
					rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT_L2?"Permit L2 only":"Drop",
					pSmac[0],pSmac[1],pSmac[2],pSmac[3],pSmac[4],pSmac[5],(sip>>24)&0xff,(sip>>16)&0xff,(sip>>8)&0xff,(sip)&0xff);
		}
	}

	//if((macEntryForceAdd==0) && (arp_valid==1)) return RG_RET_SUCCESS;

	//Find interface and check VLAN mode
	DEBUG("macEntry.vlan_id is %d, l3Idx is %d",macEntry.vlan_id,l3Idx);
	check_ivl_vid = macEntry.vlan_id;
	//Add SVL lut entry first
	macEntry.isIVL=0;
	macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
	macEntry.arp_used=0;

	l2Idx=_rtk_rg_hash_mac_fid_efid(pSmac,macEntry.fid,0);		//FIXME;current efid is always 0
	l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
	do
	{
		search_index = l2Idx+count;
		//DEBUG("search_idx is %d",search_index);
		if(rg_db.lut[search_index].valid==0)
		{
			if(first_invalid==-1)
				first_invalid=search_index;
			//break;	//empty
			count++; //search from next entry
			continue;
		}

		if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
			(!memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)))
		{
			if((macEntry.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
				(macEntry.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
			{
				//DEBUG("MAC is exist!");
				mac_exist=1;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
				assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif

				break;
			}
		}

		count++; //search from next entry
	} while(count < MAX_LUT_HASH_WAY_SIZE);


	if(count==MAX_LUT_HASH_WAY_SIZE)		//no enough space for new lut entry
	{
		//Check bCAM LUT first, if match, just return.
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
		{
			if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
			{
				if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)==0)
				{
					if((macEntry.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
					(macEntry.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
					{
						//HIT!
//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
						rtk_l2_ucastAddr_t *pL2Addr;
						pL2Addr=&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry;
						TRACE("### delete l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x SPA=%d ###\n",search_index,pL2Addr->mac.octet[0],pL2Addr->mac.octet[1],pL2Addr->mac.octet[2],pL2Addr->mac.octet[3],pL2Addr->mac.octet[4],pL2Addr->mac.octet[5],pL2Addr->port);
						assert_ok((pf.rtk_rg_macEntry_del)(search_index));
#else
						mac_exist=1;
						//support lut traffic bit
						assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
						break;
					}
				}
			}
		}

		if(mac_exist==0 && first_invalid==-1)
		{
			count=_rtk_rg_layer2GarbageCollection(l2Idx);		//check if there is asynchronus between software and hardware table
			if(count==MAX_LUT_HASH_WAY_SIZE)
			{
				//Check mac learning limit
				if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
					&& _rtk_rg_mac_learning_limit_check(srcPortIdx, srcWlanDevIdx)==RG_RET_FAIL)
				{
					TRACE("Mac learning limit is reached...won't add MAC!!");
					return RG_RET_FAIL;
				}

//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
				search_index=_rtk_rg_layer2HashedReplace(l2Idx, FAIL);//_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx);		//replace the least recently used entry for new entry
#else
				search_index=_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, FAIL);		//replace the least recently used entry for new entry
#endif
				if(search_index==RG_RET_ENTRY_NOT_GET)
				{
					FIXME("must add software LUT entry for LUT entry full.");
					return RG_RET_FAIL;
				}
			}
			else
				search_index=l2Idx+count;
		}
	}

	//Check software LUT, if exist, return without add ARP and MAC
	if(!list_empty(&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT]))
	{
		list_for_each_entry_safe(pSoftLut,pSoftLutNext,&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT],lut_list)
		{
			if(memcmp(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)==0)
			{
				if(((macEntry.isIVL==1) && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
				((macEntry.isIVL==0) && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
				{
					//HIT!
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
					//20150429LUKE: from WWAN, if we are using ARP and NEXTHOP to point to L2, we should add it to hw lut table!
					if(rg_db.lut[pSoftLut->idx].wlan_device_idx==RG_WWAN_WLAN0_VXD || rg_db.lut[pSoftLut->idx].wlan_device_idx==RG_WWAN_WLAN1_VXD)
					{
						sw_lut_vlan=rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid;
						//Delete from head list
						list_del_init(&pSoftLut->lut_list);

						//set lut invalid(quicker than set all data to zero)
						rg_db.lut[pSoftLut->idx].valid=0;

						//Add back to free list
						list_add(&pSoftLut->lut_list,&rg_db.softwareLutFreeListHead);
						MACLN("remove sw lut for WWAN, keep vlan as %d",sw_lut_vlan);
						break;
					}
					else
#endif
					{
						rtk_rg_arp_linkList_t *pSoftwareArpEntry;
						MACLN("this LUT had been added to software!! add swARP instead...");
						//20160615LUKE: for sw-lut, we need sw-arp for returning lanNetInfo.
						_rtk_rg_softwareArpTableLookUp(MAX_L3_SW_TABLE_SIZE,sip,&pSoftwareArpEntry,1);
						if(pSoftwareArpEntry==NULL){
							if(_rtk_rg_softwareArpTableAdd(MAX_L3_SW_TABLE_SIZE,sip,pSoftLut->idx,(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)>0?1:0,NULL) != RT_ERR_RG_OK)
								TABLE_FULL("Fail to add sw arp entry");
							rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.flags|=RTK_L2_UCAST_FLAG_ARP_USED;
						}
						break;
					}
				}
			}
		}
	}

	l2Idx=search_index;

	DEBUG("l2Idx is %d, first_invalid is %d, arp_valid %d, addArp %d, arpEntryForceAdd %d, mac_exist %d",l2Idx,first_invalid,arp_valid,addArp,arpEntryForceAdd,mac_exist);
	//20170831LUKE: force check arp exist and mac exist, in case burst to CPU may be overrided by lutLearning without arp_used.
	//20180507LUKE: check if the arp didn't link to the source mac addr, do not enable arp-used here.
	if(arp_valid && mac_exist && pL2Idx!=NULL && *pL2Idx==l2Idx)
	{
		if((rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)==0 && (rg_db.lut[l2Idx].permit_for_l34_forward||rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT))	//20160929LUKE: only enable ARP_USED when this LUT is permited for L34 or wanAccessLimit is off.
		{
			_rtk_rg_lutToMacEntry_translator(rg_db.lut[l2Idx], &macEntry);
			TRACE("### enable arp_used in l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x at port=%d ###\n",l2Idx,pSmac[0],pSmac[1],pSmac[2],pSmac[3],pSmac[4],pSmac[5],macEntry.port_idx);
			macEntry.arp_used=1;
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			assert_ok(ret);
		}
	}
	if(arp_valid==0 || arpEntryForceAdd==1)
	{
		if(mac_exist==0)
		{
			//Use the first meet valid empty index
			if(first_invalid>=0)
			{
				l2Idx=first_invalid;
			}
			//Check mac learning limit
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
				&& _rtk_rg_mac_learning_limit_check(srcPortIdx, srcWlanDevIdx)==RG_RET_FAIL)
			{
				TRACE("Mac learning limit is reached...won't add MAC!!");
				return RG_RET_FAIL;
			}
			
			memcpy(macEntry.mac.octet,pSmac,ETHER_ADDR_LEN);
			//Use interface infomation set MAC entry
			macEntry.port_idx=srcPortIdx;
			macEntry.static_entry=0;
			if(macEntry.isIVL==0)
			{
#if defined(CONFIG_RG_RTL9600_SERIES)
				if(srcPortIdx>=RTK_RG_PORT_CPU)
				{
					if((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_CPU))>0)
						macEntry.vlan_id=0;
				}
				else
				{
					if((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)
						macEntry.vlan_id=0;
				}
#else	// support ctag_if
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
				if(srcPortIdx>=RTK_RG_PORT_CPU)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_CPU))>0)?0:1;
				else
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)?0:1;
#elif defined(CONFIG_RG_RTL9607C_SERIES)
#if 0
				if(RTK_RG_EXT_PORT0<=srcPortIdx && srcPortIdx<=RTK_RG_EXT_PORT5)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MASTERCPU_CORE0))>0)?0:1;
				else if(RTK_RG_MAC10_EXT_PORT0<=srcPortIdx && srcPortIdx<=RTK_RG_MAC10_EXT_PORT5)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MASTERCPU_CORE1))>0)?0:1;
				else if(RTK_RG_MAC7_EXT_PORT0<=srcPortIdx && srcPortIdx<=RTK_RG_MAC7_EXT_PORT5)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_SLAVECPU))>0)?0:1;
				else
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)?0:1;
#else
				if(srcPortIdx==RTK_RG_EXT_PORT0)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MASTERCPU_CORE0))>0)?0:1;
#ifdef CONFIG_DUALBAND_CONCURRENT
				else if(srcPortIdx==RTK_RG_EXT_PORT1)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_SLAVECPU))>0)?0:1;
#endif
				else
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)?0:1;
#endif
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
				if(srcPortIdx==RTK_RG_EXT_PORT0)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_CPU))>0)?0:1;
#else
#error
#endif
#endif
				//20150512LUKE: for lut move from sw to hw, keep the vid without change
				if(sw_lut_vlan>=0)macEntry.vlan_id=sw_lut_vlan;

			}

			TRACE("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,pSmac[0],pSmac[1],pSmac[2],pSmac[3],pSmac[4],pSmac[5]);
			macEntry.arp_used=(addArp)?1:0;
			//20150430LUKE: for WWAN learning
			macEntry.wlan_device_idx=srcWlanDevIdx;
			macEntry.countingInLearningLimit = (rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL) ? 1 : 0;
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			assert_ok(ret);

			//20161004LUKE: if we need to add MAC here, we should always permit for L34.
			rg_db.lut[l2Idx].permit_for_l34_forward=1;

			//add to SA learning count
			if(macEntry.countingInLearningLimit)
				assert_ok(_rtk_rg_mac_learning_limit_count_inc(srcPortIdx, srcWlanDevIdx));
			

		}
		else if((rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)==0 && addArp && (rg_db.lut[l2Idx].permit_for_l34_forward||rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT))	//20160929LUKE: only enable ARP_USED when this LUT is permited for L34 or wanAccessLimit is off.
		{
			_rtk_rg_lutToMacEntry_translator(rg_db.lut[l2Idx], &macEntry);
			TRACE("### enable arp_used in l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x at port=%d ###\n",l2Idx,pSmac[0],pSmac[1],pSmac[2],pSmac[3],pSmac[4],pSmac[5],macEntry.port_idx);
			macEntry.arp_used=1;
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			assert_ok(ret);
		}

#if defined(CONFIG_RG_RTL9602C_SERIES)
		if(rg_kernel.block_communication_between_internet_and_other)
		{
			ret = _rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, srcPortIdx, srcWlanDevIdx);
			if(ret!=RT_ERR_RG_OK)
			{
				WARNING("Fail to create ivl mac entries, ret=0x%x", ret);
				return RG_RET_FAIL;
			}
		}
		else
#endif
		//Add IVL lut entry (Do not move!)
		if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
		{
			ret = _rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, srcPortIdx, srcWlanDevIdx, &ivlL2Idx);
			if(ret!=RT_ERR_RG_OK)
			{
				WARNING("Fail to create the corresponding ivl mac entry, ret=0x%x", ret);
				return RG_RET_FAIL;
			}
			l2Idx = ivlL2Idx;
		}

		//Add arp entry if necessary
		if(addArp==1)		//arp will point to IVL one, or SVL
		{
#if defined(CONFIG_RG_RTL9600_SERIES)
			//20160615LUKE: remove software ARP for sw-lut if any.
			rtk_rg_arp_linkList_t *pSoftwareArpEntry=NULL;
			_rtk_rg_softwareArpTableLookUp(MAX_L3_SW_TABLE_SIZE,sip,&pSoftwareArpEntry,0);
			if(pSoftwareArpEntry)_rtk_rg_softwareArpTableDel(pSoftwareArpEntry);
#endif
			//DEBUG("add ARP %x! l2Idx is %d",sip,l2Idx);
			arpEntry.ipv4Addr=sip;
			arpEntry.macEntryIdx=l2Idx;
			arpEntry.staticEntry=_rtk_rg_arpStatic_check(sip);
			if(pL2Idx!=NULL)*pL2Idx=l2Idx;	//return the l2 idx which pointed by arp entry
			//20160929LUKE: only add ARP when this LUT is permited for L34.
			//20161004LUKE: check this only when wanAccessLimit is turn on!
			if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP || rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT || rg_db.lut[l2Idx].permit_for_l34_forward || rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)
				assert_ok(rtk_rg_apollo_arpEntry_add(&arpEntry,&arpIdx));

			//20170303LUKE: assign permit or not if activeLimitField is RG_ACCESSWAN_LIMIT_BY_SIP
			if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP)
			{
				rg_db.arp[arpIdx].permit_for_l34_forward=l34Permit;
				if(l34Permit==WanAccessLimitForbid)
				{
					if(pL2Idx!=NULL)*pL2Idx=FAIL-1;
					return RG_RET_FAIL;
				}
			}
		}
		else if(addArp==2)		//add arp entry to sw link-list
		{
			TRACE("add software ARP %x! l2Idx is %d",sip,l2Idx);
			if(pL2Idx!=NULL)*pL2Idx=l2Idx;	//return the l2 idx which pointed by arp entry
			//20171011LUKE: only delete swARP from list if the mac index is different.
			if(pSwArpList)
			{
				if(rg_db.arp[pSwArpList->idx].rtk_arp.nhIdx!=l2Idx)
				{
					//Delete old link-list first
					TRACE("delete the old dynamic ARP link-list since arpEntryForceAdd==1");
					//20190114LUKE: readd count if we are deleting permit IP with different MAC address.
					if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP && l34Permit==WanAccessLimitPermit)
						if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_PORTMASK)
							atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
					_rtk_rg_softwareArpTableDel(pSwArpList);
				}
				else
				{
					//Update aging and exit
					rg_db.arp[pSwArpList->idx].idleSecs=0;
					return RG_RET_SUCCESS;
				}
			}
			//20160929LUKE: only add ARP when this LUT is permited for L34.
			//20161004LUKE: check this only when wanAccessLimit is turn on!
			if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP || rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT || rg_db.lut[l2Idx].permit_for_l34_forward || rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)
			{
				if(_rtk_rg_softwareArpTableAdd(l3Idx,sip,l2Idx,_rtk_rg_arpStatic_check(sip),&arpIdx) != RT_ERR_RG_OK)
					TABLE_FULL("Fail to add sw arp entry");
			}

			//20170303LUKE: assign permit or not if activeLimitField is RG_ACCESSWAN_LIMIT_BY_SIP
			if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP)
			{
				rg_db.arp[arpIdx].permit_for_l34_forward=l34Permit;
				if(l34Permit==WanAccessLimitForbid)
				{
					if(pL2Idx!=NULL)*pL2Idx=FAIL-1;
					return RG_RET_FAIL;
				}
			}

		}
		else if(pL2Idx!=NULL)*pL2Idx=l2Idx;	//return the l2 idx only
		return RG_RET_SUCCESS;
	}

	return RG_RET_SUCCESS;
}

#if defined(CONFIG_SMP)
void _rtk_rg_neighborDiscoveryTimerFunc(unsigned long netIfIdx)
#else
//20181019LUKE: disable softirq and tasklet when execute timer function in uniprocessor.
void _rtk_rg_neighborDiscoveryTimerFunc_up(unsigned long netIfIdx);
void _rtk_rg_neighborDiscoveryTimerFunc(unsigned long netIfIdx)
{
	int smp_id=0;
	rg_inbound_queue_lock(smp_id,&rg_kernel.rg_inbound_queue_lock);
	_rtk_rg_neighborDiscoveryTimerFunc_up(netIfIdx);
	rg_inbound_queue_unlock(&rg_kernel.rg_inbound_queue_lock);
}
void _rtk_rg_neighborDiscoveryTimerFunc_up(unsigned long netIfIdx)
#endif
{
#ifdef __KERNEL__
#if defined(CONFIG_APOLLO_ROMEDRIVER)
	rtk_ipv6_addr_t ipAddr;
	//rtk_l34_routing_entry_t rtEntry;
	//rtk_rg_ipv4RoutingEntry_t cb_routEt;
	//int i;
	if(netIfIdx>=MAX_NETIF_SW_TABLE_SIZE) return;

	bzero(ipAddr.ipv6_addr,IPV6_ADDR_LEN);

	if(rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].finished==0)
	{
		if(rg_db.systemGlobal.interfaceInfo[netIfIdx].valid  && rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.is_wan == 1)
			memcpy(&ipAddr,&rg_db.systemGlobal.interfaceInfo[netIfIdx].p_wanStaticInfo->ipv6_addr,sizeof(rtk_ipv6_addr_t));
		else
			return;

		_rtk_rg_NDGeneration(netIfIdx,ipAddr,&rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx]);
		rg_kernel.neighborDiscoveryTimerCounter[netIfIdx]++;

		//if(rg_kernel.arpRequestTimerCounter[netIfIdx]<10)
		if(1) //nerver timeout (always send arp): until finished=1
		{
			_rtk_rg_mod_timer(&rg_kernel.neighborDiscoveryTimer[netIfIdx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));
		}
		else
		{
			//error happen..recovery what we did before
			rtlglue_printf("the Neighbor Discovery failed when set up WAN interface..\n");
		}
	}
#endif
#endif
}

#if defined(CONFIG_SMP)
void _rtk_rg_AFTRDiscoveryTimerFunc(unsigned long netIfIdx)
#else
//20181019LUKE: disable softirq and tasklet when execute timer function in uniprocessor.
void _rtk_rg_AFTRDiscoveryTimerFunc_up(unsigned long netIfIdx);
void _rtk_rg_AFTRDiscoveryTimerFunc(unsigned long netIfIdx)
{
	int smp_id=0;
	rg_inbound_queue_lock(smp_id,&rg_kernel.rg_inbound_queue_lock);
	_rtk_rg_AFTRDiscoveryTimerFunc_up(netIfIdx);
	rg_inbound_queue_unlock(&rg_kernel.rg_inbound_queue_lock);
}
void _rtk_rg_AFTRDiscoveryTimerFunc_up(unsigned long netIfIdx)
#endif
{
#ifdef __KERNEL__
#if defined(CONFIG_APOLLO_ROMEDRIVER)
	int l3Idx;
	rtk_ipv6_addr_t ipAddr;
	int realIfIdx=netIfIdx-MAX_NETIF_SW_TABLE_SIZE;
	if(netIfIdx>=(MAX_NETIF_SW_TABLE_SIZE<<1)) return;

	bzero(ipAddr.ipv6_addr,IPV6_ADDR_LEN);

	if(rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].finished==0)
	{
		l3Idx=_rtk_rg_v6L3lookup(rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].reqIp.ipv6_addr);
		DEBUG("l3Idx is %d",l3Idx);
		if(l3Idx>=0)
		{
			if(rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_GLOBAL)
			{
				DEBUG("set AFTR from nexthop[%d]",rg_db.v6route[l3Idx].rtk_v6route.nhOrIfidIdx);
				_rtk_rg_internal_IPV6AFTRMACSetup(rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].reqIp.ipv6_addr, rg_db.nexthop[rg_db.v6route[l3Idx].rtk_v6route.nhOrIfidIdx].rtk_nexthop.nhIdx);
				return;
			}
			else if(rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL)
			{
				if(rg_db.systemGlobal.interfaceInfo[realIfIdx].valid && rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.is_wan)
					memcpy(&ipAddr,&rg_db.systemGlobal.interfaceInfo[realIfIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipB4,sizeof(rtk_ipv6_addr_t));
				else
					return;

				_rtk_rg_NDGeneration(realIfIdx,ipAddr,&rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx]);
				rg_kernel.neighborDiscoveryTimerCounter[netIfIdx]++;
			}
		}

		//if(rg_kernel.arpRequestTimerCounter[netIfIdx]<10)
		if(1) //nerver timeout (always send arp): until finished=1
		{
			_rtk_rg_mod_timer(&rg_kernel.neighborDiscoveryTimer[netIfIdx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));
		}
		else
		{
			//error happen..recovery what we did before
			rtlglue_printf("the Neighbor Discovery failed when set up WAN interface..\n");
		}
	}
#endif
#endif
}


uint8 _rtk_rg_CompareIFID(uint8* dip, uint64 interfaceid)
{
	return (memcmp(dip, (uint8 *)&interfaceid, 8)==0) ? 1 : 0;
}

uint32 _rtk_rg_neighborStatic_check(uint8 *checkIp)
{
	int i;

	for(i=0; i<MAX_NETIF_SW_TABLE_SIZE; i++)
	{
		if(rg_db.systemGlobal.interfaceInfo[i].valid==0) continue;
		if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1)
		{
			if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
				continue;
			//not bridge wan
			if(!memcmp(checkIp, rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->ipv6_addr.ipv6_addr, IPV6_ADDR_LEN)
				|| !memcmp(checkIp, rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr, IPV6_ADDR_LEN))
				return TRUE;
		}
		else
		{
			if(!memcmp(checkIp, rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.ipv6_addr.ipv6_addr, IPV6_ADDR_LEN))
				return TRUE;
		}
	}

	return FALSE;
}

rtk_rg_successFailReturn_t _rtk_rg_neighborAndMacEntryAdd(unsigned char *sip,int sipOrDipL3Idx,uint8 *pSmac,int srcPortIdx,int srcWlanDevIdx,int *pNeighborOrMacIdx)
{
	rtk_rg_neighborEntry_t neighborEntry;
	rtk_rg_macEntry_t macEntry;
	int l2Idx,ret,i;
	int l3Idx;
	int count=0;
	int neighbor_valid_idx;
	int mac_exist=0,search_index,addNeighbor=1,first_invalid=-1,sw_lut_vlan=-1;//,dmac2CVID_Untag=0;
	int arpUsedEnable=0;
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLutNext;
	uint32 check_ivl_vid, ivlL2Idx;
	//init
	memset(&macEntry,0,sizeof(rtk_rg_macEntry_t));

	//20180822LUKE: fix IPv6 address ordering by ntohl.
	//20140829LUKE: if SIP and DIP are both fe80::/64, we treat it as normal global ip address!
	//20140826LUKE: handle link-local address
	if(ntohl(*((unsigned int *)sip))==0xfe800000 && ntohl(*((unsigned int *)(sip+4)))==0x0 && _rtk_rg_v6L3lookup(sip)!=sipOrDipL3Idx)
	{
		//DEBUG("Link-local address.. add macEntry only!!%d",sipOrDipL3Idx);
		l3Idx=sipOrDipL3Idx;		//use DIP to find VLAN
		if(l3Idx==-1)	//look up fail
			return RG_RET_FAIL;

		//20140904LUKE: for STATIC ROUTE, we add one TRAP before LOCAL route, so we can use it to find out interface!
		if(rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL || rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_TRAP)
			macEntry.vlan_id=rg_db.netif[rg_db.v6route[l3Idx].rtk_v6route.nhOrIfidIdx].rtk_netif.vlan_id;
		else if(rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_GLOBAL)
			macEntry.vlan_id=rg_db.netif[rg_db.nexthop[rg_db.v6route[l3Idx].rtk_v6route.nhOrIfidIdx].rtk_nexthop.ifIdx].rtk_netif.vlan_id;
		else
			return RG_RET_FAIL;

		addNeighbor=0;
		goto LINK_LOCAL;
	}
	else
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_DSLITE &&
				memcmp(sip,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.dslite_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN)==0)
			{
				DEBUG("Match DSLITE AFTR ipaddr!! add mac without neighbor...");
				macEntry.vlan_id=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				if(sipOrDipL3Idx==FAIL)
					l3Idx=_rtk_rg_v6L3lookup(sip);	//check v6route to find matchIdx
				else
					l3Idx=sipOrDipL3Idx;
				//20180705LUKE:if aftr exist ipv6 domain, add neighbor, otherwise add mac only.
				if(l3Idx>=0 && rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL)
					addNeighbor=1;
				else
					addNeighbor=0;
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				arpUsedEnable=1;	//pointed by nexthop
#endif
				goto LINK_LOCAL;
			}else if(!rg_db.systemGlobal.remoteGatewayMacStatically && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE &&
				memcmp(sip,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN)==0)
			{
				DEBUG("Match Remote Gateway IP!! add mac and update neighbor if needed...");
				macEntry.vlan_id=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id;
				l3Idx=_rtk_rg_v6L3lookup(sip);	//check v6route to find matchIdx
				if(l3Idx>=0 && rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL)
					addNeighbor=1;
				else
					addNeighbor=0;
				arpUsedEnable=2;	//pointed by nexthop
				goto LINK_LOCAL;
			}
		}
	}

	if(sipOrDipL3Idx==FAIL)
		l3Idx=_rtk_rg_v6L3lookup(sip);
	else
		l3Idx=sipOrDipL3Idx;

	if(l3Idx==-1)	//look up fail
		return RG_RET_FAIL;

	if(rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL)
	{
		ret=_rtk_rg_skipNeighborLearningOrNot(l3Idx,sip,srcPortIdx, pSmac);
		if(ret!=RG_RET_SUCCESS)return ret;

		//Find interface and check VLAN mode
		//memset(&macEntry,0,sizeof(rtk_rg_macEntry_t));
		macEntry.vlan_id=rg_db.netif[rg_db.v6route[l3Idx].rtk_v6route.nhOrIfidIdx].rtk_netif.vlan_id;
LINK_LOCAL:
		check_ivl_vid = macEntry.vlan_id;
		//Add SVL lut entry first
		macEntry.isIVL=0;
		macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
		macEntry.arp_used=0;

		l2Idx=_rtk_rg_hash_mac_fid_efid(pSmac,macEntry.fid,0);		//FIXME;current efid is always 0
    	l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
   		do
		{
			search_index = l2Idx+count;
			//rtlglue_printf("search_idx is %d\n",search_index);
			if(rg_db.lut[search_index].valid==0)
			{
				if(first_invalid==-1)
					first_invalid=search_index;
				//break;	//empty
				count++; //search from next entry
				continue;
			}

			if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
				(!memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)))
			{
				if((macEntry.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
					(macEntry.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
				{
					mac_exist=1;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
					assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
					break;
				}
			}

			count++; //search from next entry
		}
		while(count < MAX_LUT_HASH_WAY_SIZE);

		if(count==MAX_LUT_HASH_WAY_SIZE)		//no enough space for new lut entry
		{
			//Check bCAM LUT first, if match, just return.
			for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
			{
				if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
				{
					if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)==0)
					{
						if((macEntry.isIVL==1 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
						(macEntry.isIVL==0 && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
						{
							//HIT!
//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
{
							rtk_l2_ucastAddr_t *pL2Addr;
							pL2Addr=&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry;
							TRACE("### delete l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x SPA=%d ###\n",search_index,pL2Addr->mac.octet[0],pL2Addr->mac.octet[1],pL2Addr->mac.octet[2],pL2Addr->mac.octet[3],pL2Addr->mac.octet[4],pL2Addr->mac.octet[5],pL2Addr->port);
							assert_ok((pf.rtk_rg_macEntry_del)(search_index));
}
#else
							mac_exist=1;
							//support lut traffic bit
							assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
							break;
						}
					}
				}
			}

			if(mac_exist==0 && first_invalid==-1)
			{
				count=_rtk_rg_layer2GarbageCollection(l2Idx);		//check if there is asynchronus between software and hardware table
				if(count==MAX_LUT_HASH_WAY_SIZE)
				{
					//Check mac learning limit
					if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
						&& _rtk_rg_mac_learning_limit_check(srcPortIdx, srcWlanDevIdx)==RG_RET_FAIL)
					{
						TRACE("Mac learning limit is reached...won't add MAC!!");
						return RG_RET_FAIL;
					}

//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
					search_index=_rtk_rg_layer2HashedReplace(l2Idx, FAIL);//_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx);		//replace the least recently used entry for new entry
#else
					search_index=_rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, FAIL);		//replace the least recently used entry for new entry
#endif
					if(search_index==RG_RET_ENTRY_NOT_GET)
					{
						FIXME("must add software LUT entry for LUT entry full.");
						return RG_RET_FAIL;
					}
				}
				else
					search_index=l2Idx+count;
			}
		}

		//Check software LUT, if exist, return without add Neighbor and MAC
		if(!list_empty(&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT]))
		{
			list_for_each_entry_safe(pSoftLut,pSoftLutNext,&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT],lut_list)
			{
				if(memcmp(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.mac.octet,pSmac,ETHER_ADDR_LEN)==0)
				{
					if(((macEntry.isIVL==1) && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
					((macEntry.isIVL==0) && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
					{
						//HIT!
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
						//20150429LUKE: from WWAN, if we are using ARP and NEXTHOP to point to L2, we should add it to hw lut table!
						if(rg_db.lut[pSoftLut->idx].wlan_device_idx==RG_WWAN_WLAN0_VXD || rg_db.lut[pSoftLut->idx].wlan_device_idx==RG_WWAN_WLAN1_VXD)
						{
							//Delete from head list
							sw_lut_vlan=rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid;
							list_del_init(&pSoftLut->lut_list);

							//set lut invalid(quicker than set all data to zero)
							rg_db.lut[pSoftLut->idx].valid=0;

							//Add back to free list
							list_add(&pSoftLut->lut_list,&rg_db.softwareLutFreeListHead);
							MACLN("remove sw lut for WWAN, keep vlan as %d",sw_lut_vlan);
							break;
						}
						else
#endif
						{
							MACLN("this LUT had been added to software!! return without add Neighbor...");
							return RG_RET_SUCCESS;
						}
					}
				}
			}
		}

		l2Idx=search_index;

		if(mac_exist==0)
		{
			//Use the first meet valid empty index
			if(first_invalid>=0)
			{
				l2Idx=first_invalid;
			}
			//Check mac learning limit
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
				&& _rtk_rg_mac_learning_limit_check(srcPortIdx, srcWlanDevIdx)==RG_RET_FAIL)
			{
				TRACE("Mac learning limit is reached...won't add MAC!!");
				return RG_RET_FAIL;
			}

			memcpy(macEntry.mac.octet,pSmac,ETHER_ADDR_LEN);

			//Use interface infomation set MAC entry
			macEntry.port_idx=srcPortIdx;
			macEntry.static_entry=0;

			if(macEntry.isIVL==0)
			{
#if defined(CONFIG_RG_RTL9600_SERIES)
				if(srcPortIdx>=RTK_RG_PORT_CPU)
				{
					if((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_CPU))>0)
						macEntry.vlan_id=0;
				}
				else
				{
					if((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)
						macEntry.vlan_id=0;
				}
#else	// support ctag_if
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
				if(srcPortIdx>=RTK_RG_PORT_CPU)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_PORT_CPU))>0)?0:1;
				else
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)?0:1;
#elif defined(CONFIG_RG_RTL9607C_SERIES)
#if 0
				if(RTK_RG_EXT_PORT0<=srcPortIdx && srcPortIdx<=RTK_RG_EXT_PORT5)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MASTERCPU_CORE0))>0)?0:1;
				else if(RTK_RG_MAC10_EXT_PORT0<=srcPortIdx && srcPortIdx<=RTK_RG_MAC10_EXT_PORT5)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MASTERCPU_CORE1))>0)?0:1;
				else if(RTK_RG_MAC7_EXT_PORT0<=srcPortIdx && srcPortIdx<=RTK_RG_MAC7_EXT_PORT5)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_SLAVECPU))>0)?0:1;
				else
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)?0:1;
#else
				if(srcPortIdx==RTK_RG_EXT_PORT0)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MASTERCPU_CORE0))>0)?0:1;
#ifdef CONFIG_DUALBAND_CONCURRENT
				else if(srcPortIdx==RTK_RG_EXT_PORT1)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_SLAVECPU))>0)?0:1;
#endif
				else
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<srcPortIdx))>0)?0:1;
#endif
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
				if(srcPortIdx==RTK_RG_EXT_PORT0)
					macEntry.ctag_if=((rg_db.vlan[macEntry.vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_CPU))>0)?0:1;
#else
#error
#endif
#endif
				//20150512LUKE: for lut move from sw to hw, keep the vid without change
				if(sw_lut_vlan>=0)macEntry.vlan_id=sw_lut_vlan;
			}
			//FIXME("vid=%d\n",macEntry.vlan_id);
			TRACE("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,pSmac[0],pSmac[1],pSmac[2],pSmac[3],pSmac[4],pSmac[5]);
			if(addNeighbor||arpUsedEnable)
				macEntry.arp_used=1;
			//20150430LUKE: for WWAN learning
			macEntry.wlan_device_idx=srcWlanDevIdx;
			macEntry.countingInLearningLimit = (rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL) ? 1 : 0;
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			assert_ok(ret);

			//20161004LUKE: if we need to add MAC here, we should always permit for L34.
			rg_db.lut[l2Idx].permit_for_l34_forward=1;

			//add to SA learning count
			if(macEntry.countingInLearningLimit)
				assert_ok(_rtk_rg_mac_learning_limit_count_inc(srcPortIdx, srcWlanDevIdx));
		}
		else if((rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)==0 && ((addNeighbor && (rg_db.lut[l2Idx].permit_for_l34_forward||rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT))	//20160929LUKE: only enable ARP_USED when this LUT is permited for L34 or wanAccessLimit is off.
			||arpUsedEnable)) 	//Check if this LUT entry has not yet enable arp_used
		{
			_rtk_rg_lutToMacEntry_translator(rg_db.lut[l2Idx], &macEntry);
			TRACE("### enable arp_used in l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,pSmac[0],pSmac[1],pSmac[2],pSmac[3],pSmac[4],pSmac[5]);
			macEntry.arp_used=1;
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			assert_ok(ret);
		}

#if defined(CONFIG_RG_RTL9602C_SERIES)
		if(rg_kernel.block_communication_between_internet_and_other)
		{
			ret = _rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, srcPortIdx, srcWlanDevIdx);
			if(ret!=RT_ERR_RG_OK)
			{
				WARNING("Fail to create ivl mac entries, ret=0x%x", ret);
				return RG_RET_FAIL;
			}
		}
		else
#endif
		//Add IVL lut entry (Do not move!)
		if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
		{
			ret = _rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, srcPortIdx, srcWlanDevIdx, &ivlL2Idx);
			if(ret!=RT_ERR_RG_OK)
			{
				WARNING("Fail to create the corresponding ivl mac entry, ret=0x%x", ret);
				return RG_RET_FAIL;
			}
			l2Idx = ivlL2Idx;
		}

		*pNeighborOrMacIdx=l2Idx;
		//20161221LUKE: if we are update remote gateway here, passed index as negative value.
		if(arpUsedEnable==2)*pNeighborOrMacIdx|=0x80000000;

		if(addNeighbor)
		{
			neighborEntry.l2Idx=l2Idx;
			neighborEntry.matchRouteIdx=l3Idx;
			memcpy(neighborEntry.interfaceId,sip,IPV6_ADDR_LEN);
			neighborEntry.valid=1;
			neighborEntry.staticEntry=_rtk_rg_neighborStatic_check(sip);
			//20160929LUKE: only add ARP when this LUT is permited for L34.
			//20161004LUKE: check this only when wanAccessLimit is turn on!
			if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT || rg_db.lut[l2Idx].permit_for_l34_forward || rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC){
				assert_ok(rtk_rg_apollo_neighborEntry_add(&neighborEntry,&neighbor_valid_idx));
				//20140904LUKE: if we are link-local, we always return MAC index, otherwise we return neighbor Idx.
				//20180715LUKE: we should always return MAC index even we add neighbor for dslite AFTR.
				if(arpUsedEnable==0)*pNeighborOrMacIdx=neighbor_valid_idx;
			}
		}
	}
	return RG_RET_SUCCESS;
}

rtk_rg_ip_updated_t  _rtk_rg_wanStaticInfoReaddCheck(int orig_wan_intf_idx, rtk_rg_ipStaticInfo_t *new_static_info)
{
	rtk_rg_ip_updated_t ip_updated=NO_IP_UPDATED;

	//if any of these information changed, tag IPv4_changed

	if((!(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ip_version==IPVER_V6ONLY&&new_static_info->ip_version==IPVER_V6ONLY))&&(
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->static_route_with_arp != new_static_info->static_route_with_arp ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->napt_enable != new_static_info->napt_enable ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ip_addr != new_static_info->ip_addr ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ip_network_mask != new_static_info->ip_network_mask ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ipv4_default_gateway_on != new_static_info->ipv4_default_gateway_on ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr != new_static_info->gateway_ipv4_addr ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4 != new_static_info->gw_mac_auto_learn_for_ipv4 ||
		(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4==0 &&
		memcmp(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv4.octet,new_static_info->gateway_mac_addr_for_ipv4.octet,ETHER_ADDR_LEN))))	//check mac only when the autoLearn is off
		ip_updated=ONLY_IPV4_UPDATED;

	//if any of these information changed, tag IPv6_changed
	if((!(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ip_version==IPVER_V4ONLY&&new_static_info->ip_version==IPVER_V4ONLY))&&(
		memcmp(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ipv6_addr.ipv6_addr,new_static_info->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN) ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ipv6_mask_length != new_static_info->ipv6_mask_length ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ipv6_napt_enable != new_static_info->ipv6_napt_enable ||
		memcmp(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->nptv6_ipv6_addr.ipv6_addr,new_static_info->nptv6_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN) ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->nptv6_ipv6_mask_length != new_static_info->nptv6_ipv6_mask_length ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->ipv6_default_gateway_on != new_static_info->ipv6_default_gateway_on ||
		memcmp(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr,new_static_info->gateway_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN) ||
		rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv6 != new_static_info->gw_mac_auto_learn_for_ipv6 ||
		(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv6==0 &&
		memcmp(rg_db.systemGlobal.interfaceInfo[orig_wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv6.octet,new_static_info->gateway_mac_addr_for_ipv6.octet,ETHER_ADDR_LEN))))	//check mac only when the autoLearn is off
	{
		if(ip_updated==ONLY_IPV4_UPDATED)
			ip_updated=IPV4_IPV6_UPDATED;
		else
			ip_updated=ONLY_IPV6_UPDATED;
	}

	return ip_updated;
}

int32 _rtk_rg_internal_wanSet(int wan_intf_idx, rtk_rg_ipStaticInfo_t *hw_static_info)
{
	int ret,i,rtidx=-1,static_rtidx=-1,rtv6idx=-1,static_rtv6idx=-1,errorno,routingAdded=0,v6RoutingAdd=0,arpMissed=0,neighborMissed=0,ipv4Enable=0,ipv6Enable=0;
	int neighbor_valid_idx,l2Idx;//,subnet_same_idx;
	uint32 check_ivl_vid, ivlL2Idx;
    unsigned int input_ipmsk,wan_set_mask;
	rtk_rg_ip_updated_t ip_update_state=IPV4_IPV6_UPDATED;
    rtk_l34_netif_entry_t intfEt;
    rtk_l34_routing_entry_t rtEntry;
    rtk_ipv6Routing_entry_t rtv6Entry;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;
	rtk_rg_ipv6RoutingEntry_t cb_routv6Et;
	rtk_rg_macEntry_t macEntry;
	rtk_mac_t zeroMAC={{0}};
	rtk_ipv6_addr_t zeroIPv6={{0}};
#if 0
	rtk_rg_macEntry_t defaultGatewayMAC;
	int defaultGatewayMAC_idx;
	rtk_rg_arpEntry_t defaultGatewayARP;
#endif
	int gateway_NeighborOrMac_idx=FAIL;
	//unsigned short ipv6HashIdx;
	//rtk_rg_wanIntfConf_t wanConfiguration;
	rtk_wanType_entry_t wantEt;
	rtk_rg_neighborInfo_t neighborInfo;
#if defined(CONFIG_RG_RTL9600_SERIES)
	int arp_valid_idx;
	rtk_rg_routing_arpInfo_t newAddingEntry;
#endif
	rtk_l34_ext_intip_entry_t extipEntry;
	rtk_l34_nexthop_entry_t nxpEt;
	rtk_rg_arp_linkList_t *pSoftwareArpEntry;
	rtk_rg_wan_type_t wan_type;
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	uint32 addRsvAcl_trapWanGwV4Ip=0, addRsvAcl_trapWanGwV6Ip=0;
#endif
	if(hw_static_info == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);

	DEBUG("wan_intf_idx:%d",wan_intf_idx);
	DEBUG("IP version:%d",hw_static_info->ip_version);
	DEBUG("napt_enable:%d",hw_static_info->napt_enable);
	DEBUG("ipv6_napt_enable:%d",hw_static_info->ipv6_napt_enable);
	DEBUG("ip addr:%08x",hw_static_info->ip_addr);
	DEBUG("remote host ip addr:%08x",hw_static_info->remote_host_ip_addr);
	DEBUG("ip addr mask:%08x",hw_static_info->ip_network_mask);
	DEBUG("ipv4 default gateway:%d",hw_static_info->ipv4_default_gateway_on);
	DEBUG("ipv4 gateway addr:%08x",hw_static_info->gateway_ipv4_addr);
	DEBUG("ipv6 addr:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",
		hw_static_info->ipv6_addr.ipv6_addr[0],hw_static_info->ipv6_addr.ipv6_addr[1],hw_static_info->ipv6_addr.ipv6_addr[2],hw_static_info->ipv6_addr.ipv6_addr[3],
		hw_static_info->ipv6_addr.ipv6_addr[4],hw_static_info->ipv6_addr.ipv6_addr[5],hw_static_info->ipv6_addr.ipv6_addr[6],hw_static_info->ipv6_addr.ipv6_addr[7],
		hw_static_info->ipv6_addr.ipv6_addr[8],hw_static_info->ipv6_addr.ipv6_addr[9],hw_static_info->ipv6_addr.ipv6_addr[10],hw_static_info->ipv6_addr.ipv6_addr[11],
		hw_static_info->ipv6_addr.ipv6_addr[12],hw_static_info->ipv6_addr.ipv6_addr[13],hw_static_info->ipv6_addr.ipv6_addr[14],hw_static_info->ipv6_addr.ipv6_addr[15]);
	DEBUG("ipv6 mask length:%d",hw_static_info->ipv6_mask_length);
	DEBUG("ipv6 default gateway on:%d",hw_static_info->ipv6_default_gateway_on);
	DEBUG("ipv6 gateway addr:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",
		hw_static_info->gateway_ipv6_addr.ipv6_addr[0],hw_static_info->gateway_ipv6_addr.ipv6_addr[1],hw_static_info->gateway_ipv6_addr.ipv6_addr[2],hw_static_info->gateway_ipv6_addr.ipv6_addr[3],
		hw_static_info->gateway_ipv6_addr.ipv6_addr[4],hw_static_info->gateway_ipv6_addr.ipv6_addr[5],hw_static_info->gateway_ipv6_addr.ipv6_addr[6],hw_static_info->gateway_ipv6_addr.ipv6_addr[7],
		hw_static_info->gateway_ipv6_addr.ipv6_addr[8],hw_static_info->gateway_ipv6_addr.ipv6_addr[9],hw_static_info->gateway_ipv6_addr.ipv6_addr[10],hw_static_info->gateway_ipv6_addr.ipv6_addr[11],
		hw_static_info->gateway_ipv6_addr.ipv6_addr[12],hw_static_info->gateway_ipv6_addr.ipv6_addr[13],hw_static_info->gateway_ipv6_addr.ipv6_addr[14],hw_static_info->gateway_ipv6_addr.ipv6_addr[15]);
	DEBUG("mtu:%d",hw_static_info->mtu);
	DEBUG("ipv4 gw mac auto learn:%d",hw_static_info->gw_mac_auto_learn_for_ipv4);
	DEBUG("ipv4 gmac:%02x-%02x-%02x-%02x-%02x-%02x",
		hw_static_info->gateway_mac_addr_for_ipv4.octet[0],hw_static_info->gateway_mac_addr_for_ipv4.octet[1]
		,hw_static_info->gateway_mac_addr_for_ipv4.octet[2],hw_static_info->gateway_mac_addr_for_ipv4.octet[3]
		,hw_static_info->gateway_mac_addr_for_ipv4.octet[4],hw_static_info->gateway_mac_addr_for_ipv4.octet[5]);
	DEBUG("ipv6 gw mac auto learn:%d",hw_static_info->gw_mac_auto_learn_for_ipv6);
	DEBUG("ipv6 gmac:%02x-%02x-%02x-%02x-%02x-%02x",
		hw_static_info->gateway_mac_addr_for_ipv6.octet[0],hw_static_info->gateway_mac_addr_for_ipv6.octet[1]
		,hw_static_info->gateway_mac_addr_for_ipv6.octet[2],hw_static_info->gateway_mac_addr_for_ipv6.octet[3]
		,hw_static_info->gateway_mac_addr_for_ipv6.octet[4],hw_static_info->gateway_mac_addr_for_ipv6.octet[5]);
	DEBUG("static route with arp:%d",hw_static_info->static_route_with_arp);
	DEBUG("NPTv6 ipv6 addr:%pI6", hw_static_info->nptv6_ipv6_addr.ipv6_addr);
	DEBUG("NPTv6 ipv6 mask length:%d",hw_static_info->nptv6_ipv6_mask_length);

	//Check input parameters
	if((wan_intf_idx >= MAX_NETIF_HW_TABLE_SIZE) && (hw_static_info->ipv4_default_gateway_on || hw_static_info->ipv6_default_gateway_on))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM); // we expect default_gateway  netif < MAX_NETIF_HW_TABLE_SIZE
	if(wan_intf_idx < 0 || wan_intf_idx >= MAX_NETIF_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(hw_static_info->mtu == 0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(hw_static_info->ip_version<0 || hw_static_info->ip_version>=IPVER_END)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(hw_static_info->static_route_with_arp && hw_static_info->remote_host_ip_addr!=0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(hw_static_info->static_route_with_arp && hw_static_info->ipv4_default_gateway_on)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//20170505: remote_host_ip_addr is only for PPPoE static route and ip mask is 0xffffffff
	if(hw_static_info->remote_host_ip_addr!=0 && !(hw_static_info->ip_network_mask==0xffffffff && hw_static_info->ipv4_default_gateway_on==0 && hw_static_info->gateway_ipv4_addr!=0))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

#if defined(CONFIG_RG_RTL9602C_SERIES)
	//patch for mismatching mib ipv6 netif problem
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_BRIDGE
			&& hw_static_info->ip_version==IPVER_V4V6 && hw_static_info->napt_enable==1 && wan_intf_idx>=(MAX_NETIF_HW_TABLE_SIZE/2))
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
	}

	//20200207LUKE: prohibit one or more WAN interface with same vid and same gmac of IPversion has v4.
	if(rg_db.systemGlobal.excludeNAT_refCnt && hw_static_info->ip_version!=IPVER_V6ONLY && hw_static_info->ip_addr){
		rtk_rg_wanIntfConf_t *wanintf=&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf;
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++){
			if(rg_db.systemGlobal.wanIntfGroup[i].index==wan_intf_idx ||
				rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE ||
				rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_version==IPVER_V6ONLY ||
				rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr==0)
				continue;
			
			if(!memcmp(wanintf->gmac.octet,rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,ETHER_ADDR_LEN) &&
				wanintf->egress_vlan_tag_on==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on &&
				wanintf->egress_vlan_id==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id){
				WARNING("exclude NAT could not support two IPv4 L34 WAN with same vid and gmac..");
				RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
			}
		}
	}
#endif

	//Check Wan type
	wan_type=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type;

	if(hw_static_info->static_route_with_arp && (wan_type!=RTK_RG_STATIC && wan_type!=RTK_RG_DHCP))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//20170505: remote_host_ip_addr is only for PPPoE static route and ip mask is 0xffffffff
	if(hw_static_info->remote_host_ip_addr!=0 && wan_type!=RTK_RG_PPPoE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//Check IP version
	if(hw_static_info->ip_version==IPVER_V4ONLY || hw_static_info->ip_version==IPVER_V4V6)
	{
		ipv4Enable=1;
		//Check parameters
		//20140620LUKE:if we set IP as zero, we mean the IP address should be invalided!!
		if(hw_static_info->ip_addr == 0 || hw_static_info->ip_network_mask == 0)
			ipv4Enable=0;//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}
	if(hw_static_info->ip_version==IPVER_V6ONLY || hw_static_info->ip_version==IPVER_V4V6)
	{
		ipv6Enable=1;
		//Check parameters
		//20140620LUKE:if we set IP as zero, we mean the IP address should be invalided!!
		if((*(unsigned int *)hw_static_info->ipv6_addr.ipv6_addr == 0 && *(unsigned int *)(hw_static_info->ipv6_addr.ipv6_addr+4) == 0 &&
			*(unsigned int *)(hw_static_info->ipv6_addr.ipv6_addr+8) == 0 && *(unsigned int *)(hw_static_info->ipv6_addr.ipv6_addr+12) == 0) || hw_static_info->ipv6_mask_length == 0)
			ipv6Enable=0;//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

		if(ipv6Enable && (hw_static_info->ipv6_mask_length>128))	//interface route should not bigger than 128bit
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

		//20140924LUKE: we don't support IPv6 now.
		if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}

	//Check if default gateway is on, gateway ip should be valid
	//if(hw_static_info->default_gateway_on == 1 && hw_static_info->gateway_ipv4_addr == 0)		//without gw ip, we can't set default route
		//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

#ifdef CONFIG_APOLLO_LITEROMEDRIVER
	//for lite-romeDriver, the auto_learn should not be turn on, and MAC address should not be invalid
	if(hw_static_info->gw_mac_auto_learn_for_ipv4 == 1 || (ipv4Enable==1&&memcmp(&hw_static_info->gateway_mac_addr_for_ipv4,&zeroMAC,sizeof(rtk_mac_t))==0))
		RETURN_ERR(RT_ERR_RG_GW_MAC_NOT_SET);
	if(hw_static_info->gw_mac_auto_learn_for_ipv6 == 1 || (ipv6Enable==1&&memcmp(&hw_static_info->gateway_mac_addr_for_ipv6,&zeroMAC,sizeof(rtk_mac_t))==0))
		RETURN_ERR(RT_ERR_RG_GW_MAC_NOT_SET);
#else
	//for romeDriver, if you do not want to send ARP automatically, you must assign one valid MAC address for the valid IP address
	if(hw_static_info->gw_mac_auto_learn_for_ipv4 == 0)
	{
		if((ipv4Enable==1&&hw_static_info->gateway_ipv4_addr>0&&memcmp(&hw_static_info->gateway_mac_addr_for_ipv4,&zeroMAC,sizeof(rtk_mac_t))==0))
			RETURN_ERR(RT_ERR_RG_GW_MAC_NOT_SET);
	}
	//20160128LUKE: support static host route auto-learn now.
	/*else
	{
		//turn on auto-learn, but we are unable to get gateway mac without  ARP routing
		if(ipv4Enable==1&&hw_static_info->ip_network_mask==0xffffffff)	//host route
			RETURN_ERR(RT_ERR_RG_GW_MAC_NOT_SET);
	}*/
	if(hw_static_info->gw_mac_auto_learn_for_ipv6 == 0)
	{
		if((ipv6Enable==1&&memcmp(hw_static_info->gateway_ipv6_addr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN)&&memcmp(&hw_static_info->gateway_mac_addr_for_ipv6,&zeroMAC,sizeof(rtk_mac_t))==0))
			RETURN_ERR(RT_ERR_RG_GW_MAC_NOT_SET);
	}
	else
	{
		//turn on auto-learn, but we are unable to get gateway mac without  ARP routing
		if((ipv6Enable==1&&hw_static_info->ipv6_mask_length==128))	//host route
			RETURN_ERR(RT_ERR_RG_GW_MAC_NOT_SET);
	}
#endif

	//Check if we are set the same WAN interface twice
	if((rg_db.systemGlobal.wanInfoSet & (0x1<<wan_intf_idx)) > 0)
	{
#if 0
		//Get, Del, Re-add wan interface before re-set it
		bzero(&wanConfiguration,sizeof(rtk_rg_wanIntfConf_t));
		memcpy(&wanConfiguration,&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf,sizeof(rtk_rg_wanIntfConf_t));

		//Don't disconnect PPP interface in protocol stack, since we just reset the IP and SessionID into hw table
		if(wanConfiguration.wan_type==RTK_RG_PPPoE)
			rg_db.systemGlobal.not_disconnect_ppp=1;
		rg_db.systemGlobal.intfIdxForReset=wan_intf_idx;
		ret=rtk_rg_interface_del(wan_intf_idx);
		if(ret!=RT_ERR_RG_OK)return ret;

		//Keep wan interface index before add
		ret=rtk_rg_wanInterface_add(&wanConfiguration,&i);
		if(ret!=RT_ERR_RG_OK)return ret;
#else
#if defined(CONFIG_RG_RTL9602C_SERIES) //patch for mismatching mib ipv6 netif problem
		if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
		{
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_BRIDGE
				&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ip_version==IPVER_V4V6
				&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->napt_enable==1
				&& !(hw_static_info->ip_version==IPVER_V4V6 && hw_static_info->napt_enable==1) )
			{
				rtk_l34_netif_entry_t intfV6Entry;

				bzero(&intfV6Entry, sizeof(rtk_l34_netif_entry_t));
	    		ret = RTK_L34_NETIFTABLE_SET(wan_intf_idx+(MAX_NETIF_HW_TABLE_SIZE/2), &intfV6Entry);
				if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_INTF_SET_FAIL);
				//bzero(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx+(MAX_NETIF_SW_TABLE_SIZE/2)], sizeof(rtk_rg_interface_info_global_t));
			}
		}
#endif
		//20140613LUKE:Check if we are just change IPv4 or IPV6 settings,
		//if so, just reset one protocol without change other protocol settings.
		ip_update_state=_rtk_rg_wanStaticInfoReaddCheck(wan_intf_idx,hw_static_info);
		if(ip_update_state==ONLY_IPV4_UPDATED || ip_update_state==IPV4_IPV6_UPDATED)
		{
			DEBUG("change IPv4 settings only!! IPv4 enable is %d",ipv4Enable);
			//just delete IPv4 related setting, do v4_only procedure later
			if(ip_update_state==ONLY_IPV4_UPDATED)ipv6Enable=0;

			//Stop ARP request timer if this WAN interface set IPv4 gatewayIP
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr)
			{
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx].finished = 1;
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx].reqIp = 0;
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx].gwMacReqCallBack = NULL;
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx].disableL3Inspect = 0;
			}

			//Stop ARP request for PPTP and L2TP WAN
			if((rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP)||
				(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP))
			{
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp = 0;
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].gwMacReqCallBack = NULL;
				rg_db.systemGlobal.intfArpRequest[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].disableL3Inspect = 0;
			}

			//20140623LUKE:when delete ARP if need, it should not convert software ARP to HW, since we are going to reset right after!
			rg_db.systemGlobal.intfIdxForReset=wan_intf_idx;
			ret=_rtk_rg_deleteIPv4Routing(wan_intf_idx);
			rg_db.systemGlobal.intfIdxForReset=-1;
			if(ret!=RT_ERR_RG_OK)return ret;

			//Clear software data structure
			if(rg_db.systemGlobal.defaultRouteSet == wan_intf_idx)
				rg_db.systemGlobal.defaultRouteSet=-1;

			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->napt_enable=0;
	        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ip_addr=0;
	        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ip_network_mask=0;
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv4_default_gateway_on=0;
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr=0;
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4=0;
			bzero(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv4,sizeof(rtk_mac_t));
		}
		if(ip_update_state==ONLY_IPV6_UPDATED || ip_update_state==IPV4_IPV6_UPDATED)
		{
			DEBUG("change IPv6 settings only!! ipv6enable is %d",ipv6Enable);
			//just delete IPv6 related setting, do v6_only procedure later
			if(ip_update_state==ONLY_IPV6_UPDATED)ipv4Enable=0;

			//Stop Neighbor Discovery request timer if this WAN interface set IPv6 gatewayIP
			if(*(unsigned int*)rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr!=0||
				*(unsigned int*)(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr+4)!=0||
				*(unsigned int*)(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr+8)!=0||
				*(unsigned int*)(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr+12)!=0)
			{
				rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].finished = 1;
				bzero(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].reqIp.ipv6_addr,IPV6_ADDR_LEN);
				rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].ipv6GwMacReqCallBack = NULL;
			}

			//Stop Neighbor Discovery request for Dslite WAN
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE)
			{
				rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].finished = 1;
				bzero(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp.ipv6_addr,IPV6_ADDR_LEN);
				rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].ipv6GwMacReqCallBack = NULL;
			}

			ret=_rtk_rg_deleteIPv6Routing(wan_intf_idx);
			if(ret!=RT_ERR_RG_OK)return ret;

			//Clear software data structure
			if(rg_db.systemGlobal.defaultIPV6RouteSet == wan_intf_idx)
				rg_db.systemGlobal.defaultIPV6RouteSet=-1;

			bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_mask_length=0;
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_default_gateway_on=0;
			bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv6=0;
			bzero(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv6,sizeof(rtk_mac_t));
			//For NPTv6
			bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->nptv6_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->nptv6_ipv6_mask_length=0;
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_napt_enable=0;
		}
		if(ip_update_state==NO_IP_UPDATED)
			goto SETUP_HW_MTU;
#endif
	}

	//Check if there is default route setup before
	if(ipv4Enable && hw_static_info->ipv4_default_gateway_on && rg_db.systemGlobal.defaultRouteSet != -1)
		RETURN_ERR(RT_ERR_RG_DEF_ROUTE_EXIST);
	if(ipv6Enable && hw_static_info->ipv6_default_gateway_on && rg_db.systemGlobal.defaultIPV6RouteSet != -1)
		RETURN_ERR(RT_ERR_RG_DEF_ROUTE_EXIST);

	//Setup WAN type table
	if(hw_static_info->napt_enable==1 && rg_db.systemGlobal.initParam.macBasedTagDecision)		//L4
	{
		errorno=RT_ERR_RG_WANTYPE_SET_FAIL;
		memcpy(&wantEt, &rg_db.wantype[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype, sizeof(rtk_wanType_entry_t));
		wantEt.wanType=L34_WAN_TYPE_L34NAT_ROUTE;
		rg_db.wantype[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4].valid=1;
		ret = RTK_L34_WANTYPETABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv4, &wantEt);
		if(ret!=RT_ERR_OK) return (errorno);

		//20180702LUKE: for dual stack binding, we should separate wanType earlier. Otherwise v6 binding traffic will be drop.(unmatch_act_L3bindL34=drop)
		if(hw_static_info->ip_version==IPVER_V4V6 && hw_static_info->gw_mac_auto_learn_for_ipv6 && rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6<0)
		{
			ret=_rtk_rg_internal_IPV6WANTYPE_setup(wan_intf_idx);
			if(ret!=RT_ERR_RG_OK) return (errorno);
		}
	}

SETUP_HW_MTU:
	DEBUG("set up MTU to %d",hw_static_info->mtu);
	intfEt=rg_db.netif[wan_intf_idx].rtk_netif;
	intfEt.mtu=hw_static_info->mtu;

#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_kernel.apolloChipId==APOLLOMP_CHIP_ID)
	{
		//Patch for 0601 and 6266, when WAN is pppoe, the L34 will minus extra 8 bytes,
		//therefore we have to patch hardware here to add more 8 bytes for it to subtract
		if(wan_type==RTK_RG_PPPoE)
			intfEt.mtu += PATCH_6266_MTU_PPPOE;

		//Patch for 0601 and 6266, when binding to interface happened,
		//the packet size have 2 byte wouldn't decrease, causing TRAP reason 224.
		//therefore the hardware setting should be set as preferred value plus 2 here
		if(rg_db.systemGlobal.initParam.macBasedTagDecision)
			intfEt.mtu += PATCH_6266_MTU_BINDING;
	}
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		//20151014LUKE: setup interface table's L4 IP address if napt, otherwise set it to zero.
		if(hw_static_info->napt_enable) intfEt.ipAddr=hw_static_info->ip_addr;
		else intfEt.ipAddr=0;
	}
	else if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT1))
	{
		//init
		intfEt.ipAddr=0;
		intfEt.isIpv6=0;
		if(hw_static_info->ip_version==IPVER_V4ONLY || hw_static_info->ip_version==IPVER_V4V6)
		{
			if(hw_static_info->napt_enable) intfEt.ipAddr=hw_static_info->ip_addr;
			else intfEt.ipAddr=0;
		}
		if(hw_static_info->ip_version==IPVER_V6ONLY || hw_static_info->ip_version==IPVER_V4V6)
		{
			intfEt.isIpv6=1;
			//special case: ipv6 only and not-dslite WAN
			if(hw_static_info->ip_version==IPVER_V6ONLY && wan_type!=RTK_RG_DSLITE && wan_type!=RTK_RG_PPPoE_DSLITE) intfEt.ipAddr=0xffffffff;
		}
	}
	//20200210LUKE: if the excludeNAT exist, force the L4 WAN downgrade to L3.
	if(rg_db.systemGlobal.excludeNAT_refCnt && hw_static_info->ip_version!=IPVER_V6ONLY && hw_static_info->napt_enable)
		intfEt.ipAddr=0;
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(hw_static_info->napt_enable)
		intfEt.ipAddr=hw_static_info->ip_addr;
	else
		intfEt.ipAddr=0;

	intfEt.deny_ipv4 = (hw_static_info->ip_version == IPVER_V6ONLY)?TRUE:FALSE;
	intfEt.deny_ipv6 = (hw_static_info->ip_version == IPVER_V4ONLY)?TRUE:FALSE;
#endif

	ret = RTK_L34_NETIFTABLE_SET(wan_intf_idx, &intfEt);
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_INTF_SET_FAIL);

	//reset software MTU should keep original MTU, only hardware MTU need to patch!!
	rg_db.netif[wan_intf_idx].rtk_netif.mtu=hw_static_info->mtu;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->mtu=hw_static_info->mtu;

	//Since we do not need to change IPv4 or IPv6 settings for the already-created WAN, we just return here
	if(ip_update_state==NO_IP_UPDATED)goto DO_INTF_CALLBACK;

	//if 255.255.255.255, we don't need to add routing entry
    if(ipv4Enable==1)
    {
        //Check routing table available or not
        rtidx = MAX_L3_SW_TABLE_SIZE;
		//subnet_same_idx = MAX_L3_SW_TABLE_SIZE;
        for(i=0; i<MAX_L3_SW_TABLE_SIZE ; i++)	//because idx MAX_L3_SW_TABLE_SIZE-1 is reserved for default route
        {
			if(i== V4_DEFAULT_ROUTE_IDX)
				continue;
            if(rg_db.l3[i].rtk_l3.valid == 0 && rtidx == MAX_L3_SW_TABLE_SIZE)
            {
                rtidx = i;	//keep first invalid entry
                //break;
            }
			else
			{
				//Check if there is any same IP-range routing entry added,
				//and the routing entry must point to the netif entry which VLAN is THE SAME
				//20170505: remote_host_ip_addr is only for PPPoE static route and ip mask is 0xffffffff
				if((!(wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff) && (hw_static_info->ip_addr&hw_static_info->ip_network_mask)==rg_db.l3[i].rtk_l3.ipAddr && hw_static_info->ip_network_mask==rg_db.l3[i].netmask)
					|| ((wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff && hw_static_info->remote_host_ip_addr==0) && hw_static_info->gateway_ipv4_addr==rg_db.l3[i].rtk_l3.ipAddr && hw_static_info->ip_network_mask==rg_db.l3[i].netmask)
					|| ((wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff && hw_static_info->remote_host_ip_addr!=0) && hw_static_info->remote_host_ip_addr==rg_db.l3[i].rtk_l3.ipAddr && hw_static_info->ip_network_mask==rg_db.l3[i].netmask))
				{
					//20150226LUKE: return fail if same subnet with different type
					//20160329LUKE: consider routing_type also
					//20170622LUKE: remove the restriction for cmcc.
					//20180721LUKE: check sw_arp and default route at same time.
					errorno=RT_ERR_RG_SUBNET_INTERFACE_ASYMMETRIC;
					if(rg_db.l3[i].rtk_l3.process==L34_PROCESS_ARP||((rg_db.l3[i].rtk_l3.process==L34_PROCESS_CPU)&&(rg_db.l3[i].rtk_l3.ipAddr>0))){
						if((hw_static_info->gateway_ipv4_addr>0)&&(hw_static_info->static_route_with_arp==0))//NH
							continue;//goto RET_CHECK_ERR;
					}else if(rg_db.l3[i].rtk_l3.process==L34_PROCESS_NH){
						if((hw_static_info->gateway_ipv4_addr==0)||(hw_static_info->ipv4_default_gateway_on)||(hw_static_info->static_route_with_arp==1))//ARP
							continue;//goto RET_CHECK_ERR;
					}
					/*
					if(rg_db.netif[wan_intf_idx].rtk_netif.vlan_id != rg_db.netif[rg_db.l3[i].rtk_l3.netifIdx].rtk_netif.vlan_id)
					{
						errorno=RT_ERR_RG_SUBNET_INTERFACE_ASYMMETRIC;
						goto RET_CHECK_ERR;
					}
					*/

					routingAdded=1;
					rtidx=i;
					memcpy(&rtEntry,&rg_db.l3[i].rtk_l3,sizeof(rtk_l34_routing_entry_t));
					break;
				}
			}
        }

		if(routingAdded==1)
		{
			//20170505: add one more routing entry to trap gateway IP for PPPoE static route and ip mask is 0xffffffff
			if(!hw_static_info->static_route_with_arp&&
				((hw_static_info->ipv4_default_gateway_on==0 && hw_static_info->gateway_ipv4_addr!=0 && hw_static_info->napt_enable==0 && (hw_static_info->ip_network_mask!=0xffffffff && ((hw_static_info->ip_addr&hw_static_info->ip_network_mask)!=hw_static_info->ip_addr)))
				|| (hw_static_info->napt_enable==0 && wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff)
#if defined(CONFIG_RG_RTL9602C_SERIES)
				|| (hw_static_info->napt_enable==0&&(wan_type==RTK_RG_DSLITE||wan_type==RTK_RG_PPPoE_DSLITE))	//20160901LUKE: for dslite routing mode, we should add one more trap routing entry for gateway IP.
#endif
				))
			{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
				if(rg_db.systemGlobal.trap_routing_wan_by_acl)
				{
					addRsvAcl_trapWanGwV4Ip = 1;
				}else
#endif
				{
				 	int rtTrapIdx = MAX_L3_SW_TABLE_SIZE;
					rtk_l34_routing_entry_t rtTrapEntry;
					uint8 rtTrapAdd = 0;

					for(i=0; i<MAX_L3_SW_TABLE_SIZE ; i++)	//because idx MAX_L3_SW_TABLE_SIZE-1 is reserved for default route
			        {
						if(i== V4_DEFAULT_ROUTE_IDX)
							continue;
			            if(rg_db.l3[i].rtk_l3.valid==0)
			            {
			            	if(rtTrapIdx==MAX_L3_SW_TABLE_SIZE)
			               		 rtTrapIdx = i;	//keep first invalid entry
			            }
						else
						{
							if(rg_db.l3[i].rtk_l3.ipAddr==hw_static_info->ip_addr && rg_db.l3[i].netmask==0xffffffff && rg_db.l3[i].rtk_l3.process==L34_PROCESS_CPU)
								rtTrapAdd = 1;
						}
					}

					if(rtTrapAdd==0)
					{
						errorno=RT_ERR_RG_ENTRY_FULL;
		        		if(rtTrapIdx == MAX_L3_SW_TABLE_SIZE) goto RET_CHECK_ERR;
						bzero(&rtTrapEntry, sizeof(rtk_l34_routing_entry_t));

						static_rtidx = rtTrapIdx;
						//Set up Routing table -- TRAP
				        rtTrapEntry.netifIdx=wan_intf_idx;
				        rtTrapEntry.valid=1;
				        rtTrapEntry.process=L34_PROCESS_CPU;		//default to sw table
				        rtTrapEntry.ipAddr=hw_static_info->ip_addr;		//20140820: here should equal to gateway IP
						if(hw_static_info->napt_enable)
				        	rtTrapEntry.internal=0;		//external host from outside, NAPT or NAT
				        else
							rtTrapEntry.internal=1;		//pure routing
				        rtTrapEntry.rt2waninf=0;
						input_ipmsk=0xffffffff;

						RG_ONE_COUNT(input_ipmsk);
					    rtTrapEntry.ipMask=input_ipmsk-1;
						errorno=RT_ERR_RG_ROUTE_SET_FAIL;
				        ret = RTK_L34_ROUTINGTABLE_SET(static_rtidx, &rtTrapEntry);
				        if(ret!=RT_ERR_OK)goto RET_STATIC_ROUTE_ERR;

						//20140703LUKE: keep original IP address for check gateway IP
						rg_db.l3[static_rtidx].gateway_ip=hw_static_info->ip_addr;
					}
				}
			}
		}

		if(routingAdded==0)
		{
			//20190111LUKE: move from the end of this bracket, in case pppoe WAN with mask 0xffffffff need not turn it on.
			routingAdded=1;
			//20140528LUKE:when setup STATIC ROUTE for routing mode, we need one more routing entry for traping WAN gateway ip to CPU!!
			//20141107LUKE: when static_route_with_arp is enable, we should add ARP routing.
			//20160321LUKE: for domain IP in routing mode, we can omit this routing entry
			//20160824: when ip mask is 255.255.255.255(point to point connection), we need one more routing entry for traping WAN gateway ip to CPU(it includes napt wan, but it can be delete after learning gw mac).
			//20170505: add one more routing entry to trap gateway IP for PPPoE static route and ip mask is 0xffffffff
			if(!hw_static_info->static_route_with_arp&&
				((hw_static_info->ipv4_default_gateway_on==0 && hw_static_info->gateway_ipv4_addr!=0 && hw_static_info->napt_enable==0 && (hw_static_info->ip_network_mask!=0xffffffff && ((hw_static_info->ip_addr&hw_static_info->ip_network_mask)!=hw_static_info->ip_addr)))
				|| (hw_static_info->napt_enable==0 && wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff)
#if defined(CONFIG_RG_RTL9602C_SERIES)
				|| (hw_static_info->napt_enable==0&&(wan_type==RTK_RG_DSLITE||wan_type==RTK_RG_PPPoE_DSLITE))	//20160901LUKE: for dslite routing mode, we should add one more trap routing entry for gateway IP.
#endif
				))
			{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
				if(rg_db.systemGlobal.trap_routing_wan_by_acl)
				{
					addRsvAcl_trapWanGwV4Ip = 1;
				}else
#endif
				{
					errorno=RT_ERR_RG_ENTRY_FULL;
		       		if(rtidx == MAX_L3_SW_TABLE_SIZE)goto RET_CHECK_ERR;
					bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));

					static_rtidx = rtidx;

					//Set up Routing table -- TRAP
			        rtEntry.netifIdx=wan_intf_idx;
			        rtEntry.valid=1;
			        rtEntry.process=L34_PROCESS_CPU;		//default to sw table
			        rtEntry.ipAddr=hw_static_info->ip_addr;		//20140820: here should equal to gateway IP

					if(hw_static_info->napt_enable)
			        	rtEntry.internal=0;		//external host from outside, NAPT or NAT
			        else
						rtEntry.internal=1;		//pure routing
			        rtEntry.rt2waninf=0;
					input_ipmsk=0xffffffff;

					RG_ONE_COUNT(input_ipmsk);
				    rtEntry.ipMask=input_ipmsk-1;
					errorno=RT_ERR_RG_ROUTE_SET_FAIL;
			        ret = RTK_L34_ROUTINGTABLE_SET(static_rtidx, &rtEntry);
			        if(ret!=RT_ERR_OK)goto RET_STATIC_ROUTE_ERR;

					//20140703LUKE: keep original IP address for check gateway IP
					rg_db.l3[static_rtidx].gateway_ip=hw_static_info->ip_addr;

					rtidx = MAX_L3_SW_TABLE_SIZE;
					bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
					for(i=0; i<MAX_L3_SW_TABLE_SIZE ; i++)	//because idx MAX_L3_SW_TABLE_SIZE-1 is reserved for default route
			        {
						if(i== V4_DEFAULT_ROUTE_IDX)
							continue;
			            if(rg_db.l3[i].rtk_l3.valid == 0 && rtidx == MAX_L3_SW_TABLE_SIZE)
			            {
			                rtidx = i;	//keep first invalid entry
			                break;
			            }
					}
				}
			}

			errorno=RT_ERR_RG_ENTRY_FULL;
		    if(rtidx == MAX_L3_SW_TABLE_SIZE)
		    {
				if(wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff && hw_static_info->remote_host_ip_addr==0 &&
					!((hw_static_info->ipv4_default_gateway_on==0 && hw_static_info->gateway_ipv4_addr!=0)))
				{
					//pppoe default route can be add if no valid rtidx
				}
				else
					goto RET_STATIC_ROUTE_ERR;
		    }
			bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));

			//20140925LUKE: PPTP and L2TP wan should add trap rule for gateway IP!
			if(wan_type==RTK_RG_PPTP || wan_type==RTK_RG_L2TP || wan_type==RTK_RG_VXLAN)
			{
				static_rtidx = rtidx;

				//Set up Routing table -- TRAP
		        rtEntry.netifIdx=wan_intf_idx;
		        rtEntry.valid=1;
		        rtEntry.process=L34_PROCESS_CPU;		//default to sw table
		        rtEntry.ipAddr=hw_static_info->ip_addr;		//20140820: here should equal to gateway IP

				if(hw_static_info->napt_enable)
		        	rtEntry.internal=0;		//external host from outside, NAPT or NAT
		        else
					rtEntry.internal=1;		//pure routing
				rtEntry.rt2waninf=1;
				input_ipmsk=hw_static_info->ip_network_mask;

				// TODO:if load-balance is needed, here should be changed
			    rtEntry.nhStart=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4; /*exact index*/
				rtEntry.nhNxt=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4;
			    rtEntry.nhNum=0;		//exect Next hop number 1,2,4,8,16
			    rtEntry.nhAlgo=0;		//PER-PACKET
			    rtEntry.ipDomain=6;		//Entry 0~7
			    rtEntry.rt2waninf=1;

				RG_ONE_COUNT(input_ipmsk);
			    rtEntry.ipMask=input_ipmsk-1;
				errorno=RT_ERR_RG_ROUTE_SET_FAIL;
		        ret = RTK_L34_ROUTINGTABLE_SET(static_rtidx, &rtEntry);
		        if(ret!=RT_ERR_OK)goto RET_STATIC_ROUTE_ERR;

				//20140703LUKE: keep original IP address for check gateway IP
				rg_db.l3[static_rtidx].gateway_ip=hw_static_info->ip_addr;
			}
			//20140925LUKE: PPTP and L2TP should not occupy ARP table since it just need to trap gateway IP
			//20150108LUKE: dSlite should add trap rule for gateway IP, too.
			//20160824: when ip mask is 255.255.255.255(point to point connection) and it's static wan, we need setup a route entry for remote point.
			//20170505: we need setup a route entry for remote point for PPPoE static route and ip mask is 0xffffffff
			else //if(wan_type!=RTK_RG_PPTP && wan_type!=RTK_RG_L2TP)
			{
			 	if(wan_type==RTK_RG_PPPoE && hw_static_info->ip_network_mask==0xffffffff && hw_static_info->remote_host_ip_addr==0)
			 	{
			 		//20190111LUKE: we not need set routingAdded to 1, since the remote IP's MAC address should be provided by user.
					routingAdded=0;
			 		if(hw_static_info->ipv4_default_gateway_on==0 && hw_static_info->gateway_ipv4_addr!=0)
			 		{
				 		//Set up Routing table -- ARP
				        rtEntry.netifIdx=wan_intf_idx;
				        rtEntry.valid=1;
				        rtEntry.process=L34_PROCESS_CPU;		//default to sw table
						if(hw_static_info->napt_enable)
				        	rtEntry.internal=0;		//external host from outside, NAPT or NAT
				        else
							rtEntry.internal=1;		//pure routing
				        rtEntry.ipAddr=hw_static_info->gateway_ipv4_addr;		//20130301-store IP addr after masked
				        rtEntry.rt2waninf=1;
				        input_ipmsk=0xffffffff;
				        RG_ONE_COUNT(input_ipmsk);
				        rtEntry.ipMask=input_ipmsk-1;

						errorno=RT_ERR_RG_ROUTE_SET_FAIL;
				        ret = RTK_L34_ROUTINGTABLE_SET(rtidx, &rtEntry);
				        if(ret!=RT_ERR_OK)goto RET_ROUTE_ERR;

						//20140703LUKE: keep original IP address for check gateway IP
						rg_db.l3[rtidx].gateway_ip=hw_static_info->ip_addr;
			 		}
					else
					{
						rtidx = static_rtidx;
						if(static_rtidx != FAIL)
							memcpy(&rtEntry, &rg_db.l3[static_rtidx].rtk_l3, sizeof(rtk_l34_routing_entry_t));
					}
			 	}
				else
#if defined(CONFIG_RG_RTL9602C_SERIES)
					//20160901LUKE: for non-default-route dslite or other WAN would we need this routing entry.
					if((wan_type!=RTK_RG_DSLITE && wan_type!=RTK_RG_PPPoE_DSLITE)||((wan_type==RTK_RG_DSLITE || wan_type==RTK_RG_PPPoE_DSLITE)&&hw_static_info->ipv4_default_gateway_on==0))
#endif
				{
			        //Set up Routing table -- ARP
			        rtEntry.netifIdx=wan_intf_idx;
			        rtEntry.valid=1;
			        rtEntry.process=L34_PROCESS_CPU;		//default to sw table
					if(hw_static_info->napt_enable)
			        	rtEntry.internal=0;		//external host from outside, NAPT or NAT
			        else
						rtEntry.internal=1;		//pure routing
					if(hw_static_info->remote_host_ip_addr==0)
			        	rtEntry.ipAddr=hw_static_info->ip_addr&hw_static_info->ip_network_mask;		//20130301-store IP addr after masked
			        else
						rtEntry.ipAddr=hw_static_info->remote_host_ip_addr&hw_static_info->ip_network_mask;		//20130301-store IP addr after masked
			        rtEntry.rt2waninf=1;
			        input_ipmsk=hw_static_info->ip_network_mask;
			        RG_ONE_COUNT(input_ipmsk);
			        rtEntry.ipMask=input_ipmsk-1;

					//for PPPoE WAN 255.255.255.255, we need one host route to trap gateway packets to CPU!!!
					//20140328LUKE: If we add non-default route WAN with gateway address, create STATIC ROUTE!
					//20141107LUKE: when static_route_with_arp is enable, we should add ARP routing here.
					//20150108LUKE: dSlite should not occupy ARP table since it just need to trap gateway IP
					if(wan_type!=RTK_RG_DSLITE && wan_type!=RTK_RG_PPPoE_DSLITE && hw_static_info->ip_network_mask!=0xffffffff &&
						((hw_static_info->ipv4_default_gateway_on==0 && (hw_static_info->gateway_ipv4_addr==0||hw_static_info->static_route_with_arp)) ||
						hw_static_info->ipv4_default_gateway_on==1))
					{
						//20140617LUKE:if add Other WAN, default add to software ARP table
						if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.none_internet)
						{
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
							WARNING("Other-WAN[%d] will be added to software ARP table...",wan_intf_idx);
#endif
						}
						else
						{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_RG_RTL9602C_SERIES)
							rtEntry.process = L34_PROCESS_ARP;
#elif defined(CONFIG_RG_RTL9600_SERIES)
							//Check for ARP table for enough entry
							// TODO:Check for ARP range and add to rg_db.systemGlobal.routingArpInfoArray
							bzero(&newAddingEntry,sizeof(rtk_rg_routing_arpInfo_t));
							newAddingEntry.routingIdx=rtidx;
							newAddingEntry.intfIdx=wan_intf_idx;
							newAddingEntry.notMask=~hw_static_info->ip_network_mask;
							//20140827LUKE: solve corner case: if mask=255.255.255.254
							if(input_ipmsk>=0x1e)
								newAddingEntry.bitNum=2;
							else
								newAddingEntry.bitNum=32-input_ipmsk;
							newAddingEntry.isLan=0;	//WAN

							if(newAddingEntry.bitNum <= 8)	//if need more than or equal to 512 entries, recorded in fwdEngine
							{
								errorno=_rtk_rg_addArpRoutingArray(&newAddingEntry,hw_static_info->ip_addr,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
								if(errorno==RT_ERR_RG_OK)
								{
									rtEntry.arpStart = newAddingEntry.arpStart;
									rtEntry.arpEnd = newAddingEntry.arpEnd;
									rtEntry.process=L34_PROCESS_ARP;
								}
								else if(errorno==RT_ERR_RG_ADD_ARP_TO_SW_TABLE)	//for sw table, routing entry just set process to CPU
								{
									WARNING("HW table is not enough...will add WAN[%d] to software ARP table!",wan_intf_idx);
								}
								else
									goto RET_CHECK_ERR;
							}
							else
							{
								WARNING("HW table is not enough...will add WAN[%d] to software ARP table!",wan_intf_idx);
							}
#endif
						}
					}

			        errorno=RT_ERR_RG_ROUTE_SET_FAIL;
			        ret = RTK_L34_ROUTINGTABLE_SET(rtidx, &rtEntry);
			        if(ret!=RT_ERR_OK)goto RET_ROUTE_ERR;

					//20140703LUKE: keep original IP address for check gateway IP
					rg_db.l3[rtidx].gateway_ip=hw_static_info->ip_addr;
				}
			}
		}
    }

	if(ipv6Enable==1/* && hw_static_info->ipv6_mask_length!=128*/)
    {
    	//20140904LUKE: when setup IPv6 STATIC ROUTE for routing, we need one more routing entry for traping WAN gateway ip to CPU!!
    	//20170316: trap WAN gateway ip of IPv6 STATIC ROUTE with reserved acl
		if(hw_static_info->ipv6_default_gateway_on==0 && memcmp(&hw_static_info->gateway_ipv6_addr,&zeroIPv6,sizeof(rtk_ipv6_addr_t)) && hw_static_info->ipv6_mask_length!=128)
		{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
			addRsvAcl_trapWanGwV6Ip = 1;
#endif
#if 0
			{
			   //Check routing table available or not
		       static_rtv6idx = MAX_IPV6_ROUTING_SW_TABLE_SIZE;
		       for(i=0; i<MAX_IPV6_ROUTING_SW_TABLE_SIZE ; i++)	//because idx 3 is reserved for default route
		        {
					if(i == V6_DEFAULT_ROUTE_IDX)
						continue;

		            if(rg_db.v6route[i].rtk_v6route.valid == 0)
		            {
		                static_rtv6idx = i;	//keep
		                break;
		            }
		        }
				errorno=RT_ERR_RG_ENTRY_FULL;
		        if(static_rtv6idx == MAX_IPV6_ROUTING_SW_TABLE_SIZE)goto RET_ROUTE_ERR;

		        //Set up Routing table -- TRAP
				bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
				rtv6Entry.valid=1;
				rtv6Entry.type=L34_IPV6_ROUTE_TYPE_TRAP;
				rtv6Entry.nhOrIfidIdx=wan_intf_idx;
				rtv6Entry.ipv6PrefixLen=128;
				memcpy(&rtv6Entry.ipv6Addr,&hw_static_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));

				errorno=RT_ERR_RG_ROUTE_SET_FAIL;
				ret = RTK_L34_IPV6ROUTINGTABLE_SET(static_rtv6idx,&rtv6Entry);
				if(ret!=RT_ERR_OK)goto RET_ROUTE_ERR;
			}
#endif
		}

        //Check routing table available or not
        rtv6idx = MAX_IPV6_ROUTING_SW_TABLE_SIZE;
        for(i=0; i<MAX_IPV6_ROUTING_SW_TABLE_SIZE ; i++)	//because idx 3 is reserved for default route
        {
			if(i == V6_DEFAULT_ROUTE_IDX)
				continue;

            if(rg_db.v6route[i].rtk_v6route.valid == 0)
            {
                rtv6idx = i;	//keep
                break;
            }
        }
		errorno=RT_ERR_RG_ENTRY_FULL;
        if(rtv6idx == MAX_IPV6_ROUTING_SW_TABLE_SIZE)goto RET_CHECK_ERR;

        //Set up Routing table -- NEIGHBOR
		bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
		rtv6Entry.valid=1;
		rtv6Entry.type=L34_IPV6_ROUTE_TYPE_LOCAL;
		rtv6Entry.nhOrIfidIdx=wan_intf_idx;
		rtv6Entry.ipv6PrefixLen=hw_static_info->ipv6_mask_length;
		memcpy(&rtv6Entry.ipv6Addr,&hw_static_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
		rtv6Entry.rt2waninf=1;	//local route, routing to WAN

		errorno=RT_ERR_RG_ROUTE_SET_FAIL;

		ret = RTK_L34_IPV6ROUTINGTABLE_SET(rtv6idx,&rtv6Entry);
		if(ret!=RT_ERR_OK)goto RET_ROUTE_ERR;

		//20160601LUKE: keep original IPv6 address for check gateway IP
		memcpy(&rg_db.v6route[rtv6idx].gateway_ipv6Addr,&hw_static_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));

		DEBUG("###add v6Route[%d]: %s prefixLen(%d)     DIP(%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x) ###",
						rtv6idx, (rtv6Entry.rt2waninf==TRUE? "RT2WAN": "RT2LAN"),
						rtv6Entry.ipv6PrefixLen,
						rtv6Entry.ipv6Addr.ipv6_addr[0],rtv6Entry.ipv6Addr.ipv6_addr[1],rtv6Entry.ipv6Addr.ipv6_addr[2],rtv6Entry.ipv6Addr.ipv6_addr[3],
						rtv6Entry.ipv6Addr.ipv6_addr[4],rtv6Entry.ipv6Addr.ipv6_addr[5],rtv6Entry.ipv6Addr.ipv6_addr[6],rtv6Entry.ipv6Addr.ipv6_addr[7],
						rtv6Entry.ipv6Addr.ipv6_addr[8],rtv6Entry.ipv6Addr.ipv6_addr[9],rtv6Entry.ipv6Addr.ipv6_addr[10],rtv6Entry.ipv6Addr.ipv6_addr[11],
						rtv6Entry.ipv6Addr.ipv6_addr[12],rtv6Entry.ipv6Addr.ipv6_addr[13],rtv6Entry.ipv6Addr.ipv6_addr[14],rtv6Entry.ipv6Addr.ipv6_addr[15]);



		v6RoutingAdd=1;

    }


	//store information in Global variable
	if(ip_update_state==IPV4_IPV6_UPDATED)memset(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo,0,sizeof(rtk_rg_ipStaticInfo_t));
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ip_version=hw_static_info->ip_version;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->napt_enable=hw_static_info->napt_enable;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->mtu=hw_static_info->mtu;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv4=hw_static_info->gw_mac_auto_learn_for_ipv4;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gw_mac_auto_learn_for_ipv6=hw_static_info->gw_mac_auto_learn_for_ipv6;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->static_route_with_arp=hw_static_info->static_route_with_arp;
	//Save default gateway wan interface to this index
	if(hw_static_info->ipv4_default_gateway_on == 1)
		rg_db.systemGlobal.defaultRouteSet = wan_intf_idx;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ip_addr=hw_static_info->ip_addr;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->remote_host_ip_addr=hw_static_info->remote_host_ip_addr;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ip_network_mask=hw_static_info->ip_network_mask;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv4_default_gateway_on=hw_static_info->ipv4_default_gateway_on;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv4_addr=hw_static_info->gateway_ipv4_addr;
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv4,&hw_static_info->gateway_mac_addr_for_ipv4, sizeof(rtk_mac_t));

	//Save default gateway wan interface to this index
	if(hw_static_info->ipv6_default_gateway_on == 1)
		rg_db.systemGlobal.defaultIPV6RouteSet = wan_intf_idx;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_napt_enable=hw_static_info->ipv6_napt_enable;
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_addr,&hw_static_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_mask_length=hw_static_info->ipv6_mask_length;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->ipv6_default_gateway_on=hw_static_info->ipv6_default_gateway_on;
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_ipv6_addr,&hw_static_info->gateway_ipv6_addr,sizeof(rtk_ipv6_addr_t));
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->gateway_mac_addr_for_ipv6,&hw_static_info->gateway_mac_addr_for_ipv6, sizeof(rtk_mac_t));

	//For NPTv6
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->nptv6_ipv6_addr,&hw_static_info->nptv6_ipv6_addr,sizeof(rtk_ipv6_addr_t));
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo->nptv6_ipv6_mask_length=hw_static_info->nptv6_ipv6_mask_length;
	
	bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.intf_name,32);
    sprintf(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.intf_name,"%d_%s_%s_%c",
                  wan_intf_idx,
                  hw_static_info->ipv4_default_gateway_on==1?"V4INTERNET":"V4OTHER",
                  hw_static_info->ipv6_default_gateway_on==1?"V6INTERNET":"V6OTHER",
                  wan_type==RTK_RG_BRIDGE?'B':'R'
                 );
	//Set WAN set mask
	rg_db.systemGlobal.wanInfoSet |= (0x1<<wan_intf_idx);

	//Check ARP table first if we add route before, otherwise call ARP request after that
	//20160329LUKE: add nexthop entry with gw_mac assigned, for napt mode, add IP table also.
	if(ipv4Enable==1 || (((hw_static_info->napt_enable==0)||(hw_static_info->gateway_ipv4_addr!=0))&&(hw_static_info->gw_mac_auto_learn_for_ipv4==0)))
	{
		bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
		if(routingAdded==1)
		{
			l2Idx=FAIL;
			if(((hw_static_info->ipv4_default_gateway_on)||(hw_static_info->gateway_ipv4_addr!=0))&&(hw_static_info->gw_mac_auto_learn_for_ipv4==0))
			{
				if(memcmp(&hw_static_info->gateway_mac_addr_for_ipv4, &zeroMAC, sizeof(rtk_mac_t)))		//MAC != 0, otherwise do nothing
				{
					memcpy(macEntry.mac.octet,hw_static_info->gateway_mac_addr_for_ipv4.octet,ETHER_ADDR_LEN);
					//set SVL for lanIntf, patched in 20121203
					//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
					if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
					{
						macEntry.port_idx=RTK_RG_EXT_PORT0;
						macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
					}
					else
					{
						macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
						macEntry.wlan_device_idx=FAIL;
					}
					//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
					if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
						DEBUG("Special change WAN_PORT from PON to RGMII.");
						macEntry.port_idx=RTK_RG_PORT_RGMII;
					}
#endif
					//set mac's vlanid by egress tagif setting
					macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
					check_ivl_vid = macEntry.vlan_id;

					//Add SVL lut entry first
					macEntry.isIVL=0;
					macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
					//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
					if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
						macEntry.vlan_id=0;
#else	// support ctag_if
					macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
					macEntry.static_entry=1;	//won't age out
					macEntry.arp_used=1;		//pointed by nexthop entry
					ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
					if(ret!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;

#if defined(CONFIG_RG_RTL9602C_SERIES)
					if(rg_kernel.block_communication_between_internet_and_other)
					{
						ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
					}
					else
#endif
					//Add IVL lut entry (Do not move!)
					if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
					{
						ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
						l2Idx = ivlL2Idx;
					}

					if(hw_static_info->gateway_ipv4_addr == 0)
					{
						ret = _rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx,l2Idx);
						errorno=ret;
					}
					else
					{
						int wanIntf_cvid=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;

						DEBUG("add ipv4 gateway ARP and MAC entry..");
						errorno=RT_ERR_RG_ADD_ARP_MAC_FAILED;
						//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
						if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
							DEBUG("Special change WAN_PORT from PON to RGMII.");
							ret = _rtk_rg_arpAndMacEntryAdd(hw_static_info->gateway_ipv4_addr,rtidx,hw_static_info->gateway_mac_addr_for_ipv4.octet,RTK_RG_PORT_RGMII,FAIL,NULL,wanIntf_cvid,0,1);
						}else
#endif
							ret = _rtk_rg_arpAndMacEntryAdd(hw_static_info->gateway_ipv4_addr,rtidx,hw_static_info->gateway_mac_addr_for_ipv4.octet,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx,FAIL,NULL,wanIntf_cvid,0,1);
					}

					if(ret!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;
				}
			}

			//Check if ARP and MAC had auto learned before
			if(hw_static_info->gateway_ipv4_addr != 0)
			{
				arpMissed=1;
				if(rtEntry.process==L34_PROCESS_ARP)
				{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					goto check_sw_arp;
#elif defined(CONFIG_RG_RTL9600_SERIES)
					arp_valid_idx=rtEntry.arpStart<<0x2;
					while(arp_valid_idx < ((rtEntry.arpEnd+1)<<0x2))
					{
						if(rg_db.arp[arp_valid_idx].rtk_arp.valid && (rg_db.arp[arp_valid_idx].ipv4Addr==hw_static_info->gateway_ipv4_addr))
						{
							errorno = _rtk_rg_internal_GWMACSetup(rg_db.arp[arp_valid_idx].ipv4Addr, rg_db.arp[arp_valid_idx].rtk_arp.nhIdx);
							if(errorno!=RT_ERR_RG_OK)
							{
								goto RET_GLB_ERR;
							}
							else
							{
								arpMissed=0;
								break;		//arpMissed=0
							}
						}

						arp_valid_idx++;
					}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
{
					//Check for hardware ARP
					_rtk_rg_hardwareArpTableLookUp(rtidx,hw_static_info->gateway_ipv4_addr,&pSoftwareArpEntry,0);
					if(pSoftwareArpEntry==NULL)
					{
						//Check for software ARP
						_rtk_rg_softwareArpTableLookUp(rtidx,hw_static_info->gateway_ipv4_addr,&pSoftwareArpEntry,0);
					}

					if(pSoftwareArpEntry!=NULL)
					{
						arpMissed=0;
						//errorno = _rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx,rg_db.arp[pArpEntry->idx].rtk_arp.nhIdx);
						errorno = _rtk_rg_internal_GWMACSetup(rg_db.arp[pSoftwareArpEntry->idx].ipv4Addr,rg_db.arp[pSoftwareArpEntry->idx].rtk_arp.nhIdx);

						if(errorno!=RT_ERR_RG_OK)
							goto RET_GLB_ERR;
					}
}
#endif

				}
				else if(rtEntry.process==L34_PROCESS_CPU)	//for pppoe WAN
				{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
check_sw_arp:
#endif
					//Check for software ARP
					_rtk_rg_softwareArpTableLookUp(rtidx,hw_static_info->gateway_ipv4_addr,&pSoftwareArpEntry,0);
					if(pSoftwareArpEntry!=NULL)
					{
						arpMissed=0;
						//20140529LUKE:fix STATIC ROUTE nexthop won't be set as static LUT
						//errorno = _rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx,rg_db.arp[pSoftwareArpEntry->idx].rtk_arp.nhIdx);
						errorno = _rtk_rg_internal_GWMACSetup(rg_db.arp[pSoftwareArpEntry->idx].ipv4Addr,rg_db.arp[pSoftwareArpEntry->idx].rtk_arp.nhIdx);

						if(errorno!=RT_ERR_RG_OK)
							goto RET_GLB_ERR;
					}
				}
				else if(rtEntry.process==L34_PROCESS_NH&&hw_static_info->gw_mac_auto_learn_for_ipv4==0)
				{
					//20160329LUKE: for two exactly same WAN with routing process as nexthop, we can add nexthop without waste routing entry.
					arpMissed=0;
					DEBUG("original process is nexthop, and gw mac != zero, add to nexthop directly!");
					errorno = _rtk_rg_internal_GWMACSetup(hw_static_info->gateway_ipv4_addr, l2Idx);
					if(errorno!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;
				}

				//20170505: add nexthop directly for PPPoE static route and ip mask is 0xffffffff
				if(arpMissed && hw_static_info->gw_mac_auto_learn_for_ipv4==0 && l2Idx!=FAIL)
				{
					arpMissed=0;
					DEBUG("if auto learn is disabled and gw mac is learned, add to nexthop directly!");
					errorno = _rtk_rg_internal_GWMACSetup(hw_static_info->gateway_ipv4_addr, l2Idx);
					if(errorno!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;
				}
			}

			//Set up Internal External IP table for NAPT or STATIC ROUTE
			//20140328LUKE:STATIC ROUTE should always add IP table, even napt_enable is 0!!
			//20141001LUKE: PPTP should add EXTIP in pptpClientInfoAfterDial_set
			//20141020LUKE: L2TP should add EXTIP in l2tpClientInfoAfterDial_set
			//20150625LUKE: if we are napt, we need eip table setup, either here or _rtk_rg_internal_GWMACSetup_stage2
		   	if(hw_static_info->napt_enable)
		   	{
		   		if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.extip_idx<0)
	 	 	 	{
					bzero(&extipEntry,sizeof(rtk_l34_ext_intip_entry_t));
					if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4<0)
					{
						//Check for empty entry
						errorno=RT_ERR_RG_ENTRY_FULL;
						for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++)
						{
							if(rg_db.systemGlobal.nxpRefCount[i] == 0)
								break;
						}
						if(i==MAX_NEXTHOP_SW_TABLE_SIZE)goto RET_GLB_ERR;

						extipEntry.nhIdx = i;		//Keep

						//Setup Nexthop table in nxtidx
						errorno=RT_ERR_RG_NXP_SET_FAIL;
						bzero(&nxpEt,sizeof(rtk_l34_nexthop_entry_t));
						nxpEt.ifIdx=wan_intf_idx;
						// if WAN is PPPoE, LAN is untag. (keepPppoe=1 will send untag packet to WAN)
						if((wan_type == RTK_RG_PPPoE)||(wan_type == RTK_RG_PPPoE_DSLITE)){
							nxpEt.type=L34_NH_PPPOE;
							#if defined(CONFIG_RG_RTL9602C_SERIES)
							nxpEt.keepPppoe=2; /* If original tagged, keep. Otherwise add tag with PPPIDX session id */
							#else
							nxpEt.keepPppoe=0;
							#endif
							nxpEt.pppoeIdx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx;
						}else{
							nxpEt.type=L34_NH_ETHER;
							nxpEt.keepPppoe=1;
							nxpEt.pppoeIdx=0;
						}

						// FIXME: here should to use binding remote host mac index, if port-binding is set
						nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;		//use this DUMMY index to force packet TRAP to CPU

						rg_db.nexthop[extipEntry.nhIdx].valid=1;
						ret = RTK_L34_NEXTHOPTABLE_SET(extipEntry.nhIdx, &nxpEt);
						if(ret!=RT_ERR_OK)goto RET_GLB_ERR;
						rg_db.systemGlobal.nxpRefCount[extipEntry.nhIdx]++;	//add for deleting it when del interface
						rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4=extipEntry.nhIdx;
					}
					extipEntry.nhIdx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4;
				   	extipEntry.intIpAddr=0; 	   //napt special
					extipEntry.extIpAddr=hw_static_info->ip_addr;

					//20150107LUKE: update EIP from primitive WAN interface, not from STATIC ROUTE's WAN.
					if(((hw_static_info->ip_network_mask<0xffffffff)&&(hw_static_info->ip_addr&hw_static_info->ip_network_mask)==hw_static_info->ip_addr)||	//subnet IP
						(hw_static_info->ip_network_mask==0xffffffff&&wan_type!=RTK_RG_PPPoE&&wan_type!=RTK_RG_PPPoE_DSLITE&&wan_type!=RTK_RG_PPTP&&wan_type!=RTK_RG_L2TP&&wan_type!=RTK_RG_VXLAN))		//static host route with napt mode
					{
						ret=0;
						for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
						{
							//DEBUG("the wan type is %d, ip is %x",rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr);
							if((rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)&&
								(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask!=0xffffffff)&&
								((rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask)
								==(hw_static_info->gateway_ipv4_addr&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask))&&
								(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask>ret))
							{
								extipEntry.extIpAddr=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr;
								//20170208LUKE: old version static route WAN should also use primitive interface's index in nexthop.
								errorno=RT_ERR_RG_NXP_SET_FAIL;
								memcpy(&nxpEt,&rg_db.nexthop[extipEntry.nhIdx].rtk_nexthop,sizeof(nxpEt));
								//20171013LUKE: keep original WAN index in mask for deleting routing entry reference.
								rg_db.nexthop[extipEntry.nhIdx].staticRouteWanIdxMask=0x1<<nxpEt.ifIdx;
								nxpEt.ifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
								ret = RTK_L34_NEXTHOPTABLE_SET(extipEntry.nhIdx, &nxpEt);
			  	  				if(ret!=RT_ERR_OK)goto RET_GLB_ERR;
								ret=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask;
							}
						}
						if(ret==0)
						{
							for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
							{
								//DEBUG("the wan type is %d, ip is %x",rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr);
								if((rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)&&
									(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask==0xffffffff)&&
									(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->gateway_ipv4_addr==hw_static_info->gateway_ipv4_addr))
								{
									extipEntry.extIpAddr=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr;
									//20170208LUKE: old version static route WAN should also use primitive interface's index in nexthop.
									errorno=RT_ERR_RG_NXP_SET_FAIL;
									memcpy(&nxpEt,&rg_db.nexthop[extipEntry.nhIdx].rtk_nexthop,sizeof(nxpEt));
									//20171013LUKE: keep original WAN index in mask for deleting routing entry reference.
									rg_db.nexthop[extipEntry.nhIdx].staticRouteWanIdxMask=0x1<<nxpEt.ifIdx;
									nxpEt.ifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
									ret = RTK_L34_NEXTHOPTABLE_SET(extipEntry.nhIdx, &nxpEt);
				  	  				if(ret!=RT_ERR_OK)goto RET_GLB_ERR;
									ret=rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_network_mask;
									break;
								}
							}
						}
						if(ret==0)
						{
							DEBUG("Static route but can not find primitive WAN interface");
						}
					}
				   	extipEntry.prival=0;
				   	extipEntry.pri=0;
				   	extipEntry.type=L34_EXTIP_TYPE_NAPT;
				   	extipEntry.valid=1;

					errorno=RT_ERR_RG_ENTRY_FULL;
					ret=-1;
					for(i=0;i<MAX_EXTIP_SW_TABLE_SIZE;i++)
					{
						if(!rg_db.extip[i].rtk_extip.valid && ret<0)
							ret=i;
						else if(!memcmp(&extipEntry,&rg_db.extip[i].rtk_extip,sizeof(rtk_l34_ext_intip_entry_t)))
							break;
					}
					if(i<MAX_EXTIP_SW_TABLE_SIZE){
						//reuse same entry in EIP table
						rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.extip_idx=i;
					}else if(ret>=0){
						rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.extip_idx=ret;	//keep
						
						errorno=RT_ERR_RG_EXTIP_SET_FAIL;
				   		ret = RTK_L34_EXTINTIPTABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.extip_idx, &extipEntry);
				   		if(ret!=RT_ERR_OK)goto RET_GLB_ERR;
					}else	//no invalid one and no reduplicated entry
						goto RET_GLB_ERR;
					
			   		//DEBUG("set ext ip table %d as %x, nexthop is %d",wan_intf_idx, hw_static_info->ip_addr,rg_db.wantype[wan_intf_idx].rtk_wantype.nhIdx);
				   	rg_db.systemGlobal.nxpRefCount[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4]++;		   //nexthop reference by IP table
				   	rg_db.systemGlobal.eipRefCount[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.extip_idx]++;		   	   //eip reference by interface table
		   		}
		   	}
		}
		else if(memcmp(macEntry.mac.octet,hw_static_info->gateway_mac_addr_for_ipv4.octet,ETHER_ADDR_LEN))		//mac is not zero
		{
			//if we are host route(255.255.255.255), must be manual add MAC

			//only add IP table, NEXTHOP table, and l2 table
			bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
			memcpy(macEntry.mac.octet,hw_static_info->gateway_mac_addr_for_ipv4.octet,ETHER_ADDR_LEN);
			//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
			{
				macEntry.port_idx=RTK_RG_EXT_PORT0;
				macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
			}
			else
			{
				macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				macEntry.wlan_device_idx=FAIL;
			}
			//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
				DEBUG("Special change WAN_PORT from PON to RGMII.");
				macEntry.port_idx=RTK_RG_PORT_RGMII;
			}
#endif
			macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			check_ivl_vid = macEntry.vlan_id;

			//Add SVL lut entry first
			macEntry.isIVL=0;
			macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
			//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
			if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
				macEntry.vlan_id=0;
#else	// support ctag_if
			macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
			macEntry.static_entry=1;	//won't age out
			macEntry.arp_used=1;		//pointed by nexthop entry
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			if(ret!=RT_ERR_RG_OK)
				goto RET_GLB_ERR;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if(rg_kernel.block_communication_between_internet_and_other)
			{
				ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
			}
			else
#endif
			//Add IVL lut entry (Do not move!)
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
			{
				ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
				l2Idx = ivlL2Idx;
			}

			DEBUG("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

			errorno = _rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx,l2Idx);

			if(errorno!=RT_ERR_RG_OK)
				goto RET_GLB_ERR;

		}
	}

	// TODO:IPv6 Neighbor Discovery has to be done here!!!!
	//Check Neighbor table first if we add them before, otherwise call Neighbor Discovery after that
	if(ipv6Enable==1 || (hw_static_info->ipv6_default_gateway_on&&(hw_static_info->ipv6_napt_enable!=1)&&(hw_static_info->gw_mac_auto_learn_for_ipv6==0)))
	{
		bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
		if(v6RoutingAdd==1)
		{
			bzero(&zeroIPv6,sizeof(rtk_ipv6_addr_t));
			if(hw_static_info->gw_mac_auto_learn_for_ipv6==0)
			{
				if(memcmp(&hw_static_info->gateway_mac_addr_for_ipv6, &zeroMAC, sizeof(rtk_mac_t)))		//MAC != 0, otherwise do nothing
				{
					//Add gateway mac and Default route
					memcpy(macEntry.mac.octet,hw_static_info->gateway_mac_addr_for_ipv6.octet,ETHER_ADDR_LEN);
					//set SVL for lanIntf, patched in 20121203
					//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
					if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
					{
						macEntry.port_idx=RTK_RG_EXT_PORT0;
						macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
					}
					else
					{
						macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
						macEntry.wlan_device_idx=FAIL;
					}
					//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
					if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
						DEBUG("Special change WAN_PORT from PON to RGMII.");
						macEntry.port_idx=RTK_RG_PORT_RGMII;
					}
#endif
					//set mac's vlanid by egress tagif setting
					macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
					check_ivl_vid = macEntry.vlan_id;

					//Add SVL lut entry first
					macEntry.isIVL=0;
					macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
					//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
					if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
						macEntry.vlan_id=0;
#else	// support ctag_if
					macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
					macEntry.static_entry=1;	//won't age out
					macEntry.arp_used=1;		//pointed by nexthop entry
					ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
					if(ret!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;

#if defined(CONFIG_RG_RTL9602C_SERIES)
					if(rg_kernel.block_communication_between_internet_and_other)
					{
						ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
					}
					else
#endif
					//Add IVL lut entry (Do not move!)
					if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
					{
						ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
						l2Idx = ivlL2Idx;
					}

					DEBUG("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],
						macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

					if(memcmp(&hw_static_info->gateway_ipv6_addr,&zeroIPv6,sizeof(rtk_ipv6_addr_t))==0)	//ipv6 == 0
					{
						errorno = _rtk_rg_internal_IPV6GWMACSetup_stage2(wan_intf_idx,l2Idx);
					}
					else{
						//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
						if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
							DEBUG("Special change WAN_PORT from PON to RGMII.");
							errorno = _rtk_rg_neighborAndMacEntryAdd(hw_static_info->gateway_ipv6_addr.ipv6_addr,rtv6idx,hw_static_info->gateway_mac_addr_for_ipv6.octet,RTK_RG_PORT_RGMII,FAIL,&gateway_NeighborOrMac_idx);
						}
						else
#endif
							errorno = _rtk_rg_neighborAndMacEntryAdd(hw_static_info->gateway_ipv6_addr.ipv6_addr,rtv6idx,hw_static_info->gateway_mac_addr_for_ipv6.octet,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx,FAIL,&gateway_NeighborOrMac_idx);
					}
					if(errorno!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;

				}
			}

			//Check if Neighbor and MAC had auto learned before
			if(memcmp(&hw_static_info->gateway_ipv6_addr,&zeroIPv6,sizeof(rtk_ipv6_addr_t))!=0)	//ipv6 != 0
			{
				//get hash index
				//ipv6HashIdx = _rtk_rg_IPv6NeighborHash(hw_static_info->gateway_ipv6_addr.ipv6_addr+8, rtv6idx);
				memcpy(neighborInfo.neighborEntry.interfaceId,hw_static_info->gateway_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
				neighborInfo.neighborEntry.matchRouteIdx=rtv6idx;
				neighbor_valid_idx=-1;
				ret=rtk_rg_apollo_neighborEntry_find(&neighborInfo,&neighbor_valid_idx);
				if(ret==RT_ERR_RG_OK)
				{
					//Found
					DEBUG("Found old neighbor!! neighbor_valid_idx=%d",neighbor_valid_idx);
					errorno = _rtk_rg_internal_IPV6GWMACSetup(hw_static_info->gateway_ipv6_addr.ipv6_addr, rg_db.v6neighbor[neighbor_valid_idx].neighborEntry.l2Idx);
					if(errorno!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
					//DEBUG("hw_static_info->ipv6_napt_enable=%d, hw_static_info->ipv6_default_gateway_on=%d",hw_static_info->ipv6_napt_enable,hw_static_info->ipv6_default_gateway_on);
					if(hw_static_info->ipv6_napt_enable==1){//IPv6 NAPT Wan
						//Set software IPv6 Routing info
						rg_db.v6route[rtv6idx].internal = 1; //Routing is External (pure software information)
						//Set software IPv6 ExtIp info
						rg_db.v6Extip[wan_intf_idx].valid =1;
						memcpy(rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr,hw_static_info->ipv6_addr.ipv6_addr,sizeof(rtk_ipv6_addr_t));
						rg_db.v6Extip[wan_intf_idx].nextHopIdx = rg_db.wantype[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6].rtk_wantype.nhIdx;
						DEBUG("### add v6ExtIp[%d] (NextHop=%d  EXT_IP %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x) ###",rtv6idx,rg_db.v6Extip[wan_intf_idx].nextHopIdx,
									rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[0],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[1],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[2],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[3],
									rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[4],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[5],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[6],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[7],
									rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[8],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[9],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[10],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[11],
									rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[12],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[13],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[14],rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr[15]);

						if(hw_static_info->ipv6_default_gateway_on){//default gateway routing/naptWan following the Wan setting.
							TRACE("Set ipv6 defaulte route as external");
							rg_db.v6route[V6_DEFAULT_ROUTE_IDX].internal=1; //NaptWan
						}


					}
#endif

				}
				else if(gateway_NeighborOrMac_idx!=FAIL)	//20140904LUKE: link-local case, therefore no neighbor, just return MAC idx
				{

					errorno = _rtk_rg_internal_IPV6GWMACSetup_stage2(wan_intf_idx,gateway_NeighborOrMac_idx);
					if(errorno!=RT_ERR_RG_OK)
						goto RET_GLB_ERR;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
					//DEBUG("hw_static_info->ipv6_napt_enable=%d, hw_static_info->ipv6_default_gateway_on=%d",hw_static_info->ipv6_napt_enable,hw_static_info->ipv6_default_gateway_on);
					if(hw_static_info->ipv6_napt_enable==1){//IPv6 NAPT Wan
						//Set software IPv6 Routing info
						rg_db.v6route[rtv6idx].internal = 1; //Routing is External (pure software information)
						//Set software IPv6 ExtIp info
						rg_db.v6Extip[wan_intf_idx].valid =1;
						memcpy(rg_db.v6Extip[wan_intf_idx].externalIp.ipv6_addr,hw_static_info->ipv6_addr.ipv6_addr,sizeof(rtk_ipv6_addr_t));
						//DEBUG("hw_static_info->ipv6_addr=(%02X%02X)  ExtIp=(%02X%02X)",hw_static_info->ipv6_addr.ipv6_addr[0],hw_static_info->ipv6_addr.ipv6_addr[1],rg_db.v6Extip[rtv6idx].externalIp.ipv6_addr[0],rg_db.v6Extip[rtv6idx].externalIp.ipv6_addr[1]);
						//DEBUG("wan_intf_idx=%d	bind_wan_type_ipv6=%d  rtv6idx=%d rg_db.v6Extip[rtv6idx].nextHopIdx=%d",wan_intf_idx,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6,rtv6idx,rg_db.v6Extip[rtv6idx].nextHopIdx);
						rg_db.v6Extip[wan_intf_idx].nextHopIdx = rg_db.wantype[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.bind_wan_type_ipv6].rtk_wantype.nhIdx;

						if(hw_static_info->ipv6_default_gateway_on){//default gateway routing/naptWan following the Wan setting.
							TRACE("Set ipv6 defaulte route as external");
							rg_db.v6route[V6_DEFAULT_ROUTE_IDX].internal=1; //NaptWan
						}
					}
#endif

				}
				else
					neighborMissed=1;
			}
		}
		else if(memcmp(macEntry.mac.octet,hw_static_info->gateway_mac_addr_for_ipv6.octet,ETHER_ADDR_LEN))	//mac is not zero
		{
			//if we are IPv6 host route(128), do nothing

			//only add NEXTHOP table, and l2 table
			bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
			memcpy(macEntry.mac.octet,hw_static_info->gateway_mac_addr_for_ipv6.octet,ETHER_ADDR_LEN);
			//set SVL for lanIntf, patched in 20121203
			//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
			{
				macEntry.port_idx=RTK_RG_EXT_PORT0;
				macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
			}
			else
			{
				macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				macEntry.wlan_device_idx=FAIL;
			}
			//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
				DEBUG("Special change WAN_PORT from PON to RGMII.");
				macEntry.port_idx=RTK_RG_PORT_RGMII;
			}
#endif
			//set mac's vlanid by egress tagif setting
			macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			check_ivl_vid = macEntry.vlan_id;

			//Add SVL lut entry first
			macEntry.isIVL=0;
			macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
			//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
			if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
				macEntry.vlan_id=0;
#else	// support ctag_if
			macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
			macEntry.static_entry=1;	//won't age out
			macEntry.arp_used=1;		//pointed by nexthop entry
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			if(ret!=RT_ERR_RG_OK)
				goto RET_GLB_ERR;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if(rg_kernel.block_communication_between_internet_and_other)
			{
				ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
			}
			else
#endif
			//Add IVL lut entry (Do not move!)
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
			{
				ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
				l2Idx = ivlL2Idx;
			}

			DEBUG("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],
				macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

			errorno = _rtk_rg_internal_IPV6GWMACSetup_stage2(wan_intf_idx,l2Idx);

			if(errorno!=RT_ERR_RG_OK)
				goto RET_GLB_ERR;

		}
	}

	// TODO:Call the initParam's routngAddByHwCallBack
	if(routingAdded==1 && rg_db.systemGlobal.initParam.routingAddByHwCallBack!=NULL)
	{
		bzero(&cb_routEt, sizeof(rtk_rg_ipv4RoutingEntry_t));
		cb_routEt.dest_ip=hw_static_info->ip_addr;
		cb_routEt.ip_mask=hw_static_info->ip_network_mask;
		cb_routEt.nexthop=0;
		cb_routEt.wan_intf_idx=wan_intf_idx;
		rg_db.systemGlobal.initParam.routingAddByHwCallBack(&cb_routEt);
	}
	// TODO:Call the initParam's v6RoutingAddByHwCallBack
	if(v6RoutingAdd==1 && rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack!=NULL)
	{
		bzero(&cb_routv6Et, sizeof(rtk_rg_ipv6RoutingEntry_t));
		memcpy(&cb_routv6Et.dest_ip,&hw_static_info->ipv6_addr,sizeof(rtk_ipv6_addr_t));
		cb_routv6Et.prefix_len=hw_static_info->ipv6_mask_length;
		cb_routv6Et.NhOrIntfIdx=wan_intf_idx;
		cb_routv6Et.type=rtv6Entry.type;
		rg_db.systemGlobal.initParam.v6RoutingAddByHwCallBack(&cb_routv6Et);
	}

	// TODO:Use ARP protocol to find out default gateway's mac save in L2idx
	//20150109LUKE: for dslite, ipv4 nexthop equal to ipv6
	if(arpMissed==1 && wan_type!=RTK_RG_DSLITE && wan_type!=RTK_RG_PPPoE_DSLITE)
	{
#if defined(CONFIG_APOLLO_ROMEDRIVER)
		rg_db.systemGlobal.intfArpRequest[wan_intf_idx].finished=0;
		rg_db.systemGlobal.intfArpRequest[wan_intf_idx].reqIp=hw_static_info->gateway_ipv4_addr;
		rg_db.systemGlobal.intfArpRequest[wan_intf_idx].gwMacReqCallBack=_rtk_rg_internal_GWMACSetup_softUpdate;
		rg_db.systemGlobal.intfArpRequest[wan_intf_idx].disableL3Inspect=0;

#ifdef __KERNEL__

		_rtk_rg_del_timer(&rg_kernel.arpRequestTimer[wan_intf_idx]);
		_rtk_rg_init_timer(&rg_kernel.arpRequestTimer[wan_intf_idx]);

		rg_kernel.arpRequestTimer[wan_intf_idx].data = (unsigned long)wan_intf_idx;
		rg_kernel.arpRequestTimer[wan_intf_idx].function = _rtk_rg_arpRequestTimerFunc;
		rg_kernel.arpRequestTimerCounter[wan_intf_idx]=0;
		DEBUG("arp miss, request arp=%x\n",rg_db.systemGlobal.intfArpRequest[wan_intf_idx].reqIp);
		_rtk_rg_mod_timer(&rg_kernel.arpRequestTimer[wan_intf_idx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));


#endif
#else
		//for lite romeDriver, here should not be reached
		errorno=RT_ERR_RG_GW_MAC_NOT_SET;
		goto RET_GLB_ERR;
#endif
	}

	// TODO:IPv6 Neighbor Discovery has to be done here!!!!
	if(neighborMissed==1)
	{
#if defined(CONFIG_APOLLO_ROMEDRIVER)
		rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].finished=0;
		memcpy(&rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].reqIp,&hw_static_info->gateway_ipv6_addr,sizeof(rtk_ipv6_addr_t));
		rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].ipv6GwMacReqCallBack=_rtk_rg_internal_IPV6GWMACSetup_softUpdate;
		//DEBUG("wan intf is %d, function pointer is %p",wan_intf_idx,rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].ipv6GwMacReqCallBack);
#ifdef __KERNEL__

		_rtk_rg_del_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx]);
		_rtk_rg_init_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx]);

		rg_kernel.neighborDiscoveryTimer[wan_intf_idx].data = (unsigned long)wan_intf_idx;
		rg_kernel.neighborDiscoveryTimer[wan_intf_idx].function = _rtk_rg_neighborDiscoveryTimerFunc;
		rg_kernel.neighborDiscoveryTimerCounter[wan_intf_idx]=0;
		DEBUG("neighbor miss, discovery neighbor =%08x:%08x:%08x:%08x\n",*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].reqIp.ipv6_addr),
			*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].reqIp.ipv6_addr+4),
			*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].reqIp.ipv6_addr+8),
			*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx].reqIp.ipv6_addr+12));

		_rtk_rg_mod_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));


#endif
#else
		//for lite romeDriver, here should not be reached
		errorno=RT_ERR_RG_GW_MAC_NOT_SET;
		goto RET_GLB_ERR;
#endif

	}

DO_INTF_CALLBACK:
	//add wan-interfcae callback to sync protocal-stack
	if(rg_db.systemGlobal.initParam.interfaceAddByHwCallBack != NULL)
	{
		//rtk_rg_intfInfo_t intfInfo;
		//bzero(&intfInfo,sizeof(intfInfo));
		//memcpy(&intfInfo, &rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo, sizeof(intfInfo));
		rg_db.systemGlobal.initParam.interfaceAddByHwCallBack(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo,&wan_intf_idx);
	}
#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	//20141224LUKE: since IP subnet is modified, we should rearrange ACL which use the WAN interface as egress interface
	if(rg_db.systemGlobal.acl_SW_egress_intf_type_zero_num && ip_update_state!=NO_IP_UPDATED)
		assert_ok(_rtk_rg_acl_user_part_rearrange());
#endif


	assert_ok(_rtk_rg_shortCut_clear());

#if defined(CONFIG_RG_RTL9602C_SERIES) //patch for mismatching mib ipv6 netif problem
	if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT0))
	{
		if(wan_type!=RTK_RG_BRIDGE && hw_static_info->ip_version==IPVER_V4V6 && hw_static_info->napt_enable==1)
		{
			rtk_l34_netif_entry_t intfV6Entry;

			memcpy(&intfV6Entry, &rg_db.netif[wan_intf_idx].rtk_netif, sizeof(rtk_l34_netif_entry_t));
			intfV6Entry.ipAddr = 0;

			errorno = RTK_L34_NETIFTABLE_SET(wan_intf_idx+(MAX_NETIF_HW_TABLE_SIZE/2), &intfV6Entry);
			if(errorno!=RT_ERR_OK)goto RET_GLB_ERR;
			//memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx+(MAX_NETIF_SW_TABLE_SIZE/2)], &rg_db.systemGlobal.interfaceInfo[wan_intf_idx], sizeof(rtk_rg_interface_info_global_t));
		}
	}
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
	//20160418LUKE: for DSlite routing mode, we should trap TCP SYN for MSS clamping.
	if(wan_type==RTK_RG_PPPoE_DSLITE ||	wan_type==RTK_RG_DSLITE)
		_rtk_rg_dslite_routing_reserved_acl_decision();
#endif

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
{
	int32 tmpNexthopv4Idx,tmpExtipIdx,tmpPPPoEIdx,tmpNexthopv6Idx;
	tmpNexthopv4Idx =rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4;
	tmpExtipIdx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.extip_idx;
	tmpPPPoEIdx =rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx;
	tmpNexthopv6Idx = rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv6 ;

	if(ipv4Enable && ((rtidx>=0) && (rtidx<MAX_L3_SW_TABLE_SIZE)) &&
	   ( (((tmpExtipIdx >=0) && (tmpExtipIdx <MAX_EXTIP_SW_TABLE_SIZE)) && rg_db.extip[tmpExtipIdx].valid==SOFTWARE_ONLY_ENTRY) ||
	     (((tmpNexthopv4Idx>=0)&& (tmpNexthopv4Idx <MAX_NEXTHOP_SW_TABLE_SIZE)) && rg_db.nexthop[tmpNexthopv4Idx].valid == SOFTWARE_ONLY_ENTRY) ||
	     ((tmpPPPoEIdx>=MAX_PPPOE_HW_TABLE_SIZE)&&(tmpPPPoEIdx<MAX_PPPOE_SW_TABLE_SIZE)) ||
	     ((wan_intf_idx>=MAX_NETIF_HW_TABLE_SIZE)&&(wan_intf_idx<MAX_NETIF_SW_TABLE_SIZE)) ||
	     ((rg_db.l3[rtidx].valid==SOFTWARE_ONLY_ENTRY)) ))
	{
		if((rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid & IF_SOFTWARE4_ENTRY) ==0)
		{
			rtk_rg_aclAndCf_reserved_dip_mask_trap_t dip_mask_trap;
			bzero(&dip_mask_trap,sizeof(dip_mask_trap));
			dip_mask_trap.dip=rg_db.l3[rtidx].rtk_l3.ipAddr;
			dip_mask_trap.mask =~((1<<(31-(rg_db.l3[rtidx].rtk_l3.ipMask)))-1);
			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_RULE0_DIP_MASK_TRAP +rtidx, &dip_mask_trap);
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid |= IF_SOFTWARE4_ENTRY;
			WARNING("ReservedRuleAdd software data path ExtipIdx=%d Nexthopv4Idx=%d PPPoEIdx=%d netifIdx=%d L3Idx=%d",tmpExtipIdx,tmpNexthopv4Idx,tmpPPPoEIdx,wan_intf_idx,rtidx);
		}
	}

	if(ipv6Enable && ((rtv6idx>=0)&& (rtv6idx<MAX_IPV6_ROUTING_SW_TABLE_SIZE)) &&
		(  (hw_static_info->ipv6_napt_enable)||
	 	   (((tmpNexthopv6Idx>=0)&& (tmpNexthopv6Idx <MAX_NEXTHOP_SW_TABLE_SIZE)) && rg_db.nexthop[tmpNexthopv6Idx].valid == SOFTWARE_ONLY_ENTRY) ||
		   ((tmpPPPoEIdx>=MAX_PPPOE_HW_TABLE_SIZE)&&(tmpPPPoEIdx<MAX_PPPOE_SW_TABLE_SIZE)) ||
		   ((wan_intf_idx>=MAX_NETIF_HW_TABLE_SIZE)&&(wan_intf_idx<MAX_NETIF_SW_TABLE_SIZE)) ||
		   ((rg_db.v6route[rtv6idx].valid==SOFTWARE_ONLY_ENTRY)) ))
	{
		if((rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid &IF_SOFTWARE6_ENTRY) ==0)
		{

			// v6patch
			rtk_rg_aclAndCf_reserved_dipv6_mask_trap_t dipv6_mask_trap;
			int32 byteZeroCount =( (128-rg_db.v6route[rtv6idx].rtk_v6route.ipv6PrefixLen) /8);
			int32 residue = ( (128-rg_db.v6route[rtv6idx].rtk_v6route.ipv6PrefixLen) %8);
			bzero(&dipv6_mask_trap,sizeof(dipv6_mask_trap));
			memcpy(&dipv6_mask_trap.dipv6.ipv6_addr[0],&rg_db.v6route[rtv6idx].rtk_v6route.ipv6Addr.ipv6_addr[0],sizeof(dipv6_mask_trap.dipv6));

			memset(&dipv6_mask_trap.dipv6_mask.ipv6_addr[0],0xff,IPV6_ADDR_LEN);
			if(byteZeroCount)
				memset(&dipv6_mask_trap.dipv6_mask.ipv6_addr[IPV6_ADDR_LEN-byteZeroCount],0,byteZeroCount);
			if(residue)
				dipv6_mask_trap.dipv6_mask.ipv6_addr[IPV6_ADDR_LEN-byteZeroCount-1] &= (~((1<<residue) -1));

			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_RULE0_DIPv6_MASK_TRAP +rtv6idx, &dipv6_mask_trap);
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid|=IF_SOFTWARE6_ENTRY;
			WARNING("ReservedRuleAdd software data path ExtipIdx=%d Nexthopv4Idx=%d PPPoEIdx=%d netifIdx=%d L3v6Idx=%d",tmpExtipIdx,tmpNexthopv4Idx,tmpPPPoEIdx,wan_intf_idx,rtv6idx);

		}

	}


	if (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid > IF_VALID_ENTRY)// pure software netif
	{
		int iterPort=0;
		//Port bind , trap spa=bindPort packet
		for(iterPort=RTK_RG_MAC_PORT0; iterPort<RTK_RG_MAC_PORT_MAX-1; iterPort++)
		{
			if(RG_INVALID_MAC_PORT(iterPort)) continue;
			if(	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.port_binding_mask.portmask & (1<<iterPort))
			{
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PORT0_TRAP + iterPort, NULL);
				WARNING("ReservedRuleAdd Port Bind trap Port=%d",iterPort);
			}
		}
	}
}
#endif
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_db.systemGlobal.trap_routing_wan_by_acl)
	{
		if(addRsvAcl_trapWanGwV4Ip && !(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid&IF_SOFTWARE4_ENTRY))
			_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv4_TRAP+wan_intf_idx ,NULL);
		else
			_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv4_TRAP+wan_intf_idx);
	}
	//20170316: trap WAN gateway ip of IPv6 STATIC ROUTE with reserved acl
	if(addRsvAcl_trapWanGwV6Ip && !(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid&IF_SOFTWARE6_ENTRY))
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv6_TRAP+wan_intf_idx ,NULL);
	else
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_NETIF0_GATEWAY_IPv6_TRAP+wan_intf_idx);
#endif

#if defined(CONFIG_RG_G3_SERIES)
	// Add generic interface of NAPT/Routing wan (excludes PPPoE/PPTP/L2TP/DSLite wan)
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_PPPoE
		&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_PPTP
		&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_L2TP
		&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_DSLITE
		&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type!=RTK_RG_PPPoE_DSLITE)
	{
		ASSERT_EQ(_rtk_rg_generic_wan_intf_add(wan_intf_idx), RT_ERR_RG_OK);
	}
#endif

	return (RT_ERR_RG_OK);

RET_GLB_ERR:
	//Clear global variable
	wan_set_mask=0x1<<wan_intf_idx;
   	rg_db.systemGlobal.wanInfoSet &= ~(wan_set_mask);
   	bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.intf_name, 32);

   	if(hw_static_info->ipv4_default_gateway_on == 1)		//recovery default route interface index
		rg_db.systemGlobal.defaultRouteSet=-1;
	if(hw_static_info->ipv6_default_gateway_on == 1)		//recovery default route interface index
		rg_db.systemGlobal.defaultIPV6RouteSet=-1;

	bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo, sizeof(rtk_rg_ipStaticInfo_t));
RET_ROUTE_ERR:
    //Delete the routing table entry
    if(rtidx>=0)
    {
        bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
        RTK_L34_ROUTINGTABLE_SET(rtidx, &rtEntry);
    }
	if(rtv6idx>=0)
    {
        bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
        RTK_L34_IPV6ROUTINGTABLE_SET(rtv6idx, &rtv6Entry);
    }
RET_STATIC_ROUTE_ERR:
    //Delete the static routing table TRAP entry
    if(static_rtidx>=0)
    {
        bzero(&rtEntry, sizeof(rtk_l34_routing_entry_t));
        RTK_L34_ROUTINGTABLE_SET(static_rtidx, &rtEntry);
    }
	if(static_rtv6idx>=0)
	{
		bzero(&rtv6Entry, sizeof(rtk_ipv6Routing_entry_t));
        RTK_L34_IPV6ROUTINGTABLE_SET(static_rtv6idx, &rtv6Entry);
	}
RET_CHECK_ERR:

	return (errorno);
}



int32 rtk_rg_ipv6_externalIp_set(int index, rtk_rg_table_v6ExtIp_t v6ExtIp_entry){

	if(index<0 || index>=MAX_IPV6_ROUTING_SW_TABLE_SIZE)
		return RT_ERR_RG_INVALID_PARAM;

	rg_db.v6Extip[index] = v6ExtIp_entry;
	return RT_ERR_RG_OK;
}

int32 _rtk_rg_ipv6_externalIp_get(int index, rtk_rg_table_v6ExtIp_t *v6ExtIp_entry){

	if(index<0 || index>=MAX_NETIF_SW_TABLE_SIZE)
		return RT_ERR_RG_INVALID_PARAM;
	if(v6ExtIp_entry==NULL)
		return RT_ERR_RG_NULL_POINTER;

	*v6ExtIp_entry = rg_db.v6Extip[index] ;
	return RT_ERR_RG_OK;
}


rtk_rg_err_code_t rtk_rg_apollo_staticInfo_set(int wan_intf_idx, rtk_rg_ipStaticInfo_t *static_info)
{
	int errorno;//,i,rtidx=-1,errorno,routingAdd=0,arp_valid_idx,arpMissed=0;

//	unsigned int input_ipmsk,last_arp=0;
//	rtk_l34_netif_entry_t intfEt;
//	rtk_l34_routing_entry_t rtEntry;
	//rtk_l34_ext_intip_entry_t extipEt;
//	rtk_rg_ipv4RoutingEntry_t cb_routEt;
	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_STATIC)
			RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);

	//Check if we are reentried
	//rg_lock(&rg_kernel.wanStaticCalled);

	errorno = _rtk_rg_internal_wanSet(wan_intf_idx, static_info);

	//Set up Internal External IP table for NAPT - we will do this at _rtk_rg_internal_GWMACSetup
#if 0
	if(static_info->napt_enable)
	{
		//interface table is 1-by-1 mapping to iP table
		//therefore we do not need to go through whole table

		//Checking table for availability
		/*for(i=0;i<8;i++)
		{
			memset(&extipEt, 0, sizeof(extipEt));
			ret = rtk_l34_extIntIPTable_get(i, &extipEt);
			if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_EXTIP_FAIL);

			if(extipEt.valid == 0)
				break;
		}
		if(i==8 && extipEt.valid == 1)
			RETURN_ERR(RT_ERR_RG_ENTRY_FULL);*/
		errorno=RT_ERR_RG_EXTIP_GET_FAIL;
		bzero(&extipEt, sizeof(rtk_l34_ext_intip_entry_t));
		ret = rtk_l34_extIntIPTable_get(wan_intf_idx, &extipEt);
		if(ret!=RT_ERR_OK || extipEt.valid==1)goto RET_ROUTE_ERR;

		extipEt.intIpAddr=0;		//napt special
		extipEt.extIpAddr=static_info->ip_addr;
		extipEt.nhIdx=0;		//used 0 as reserved entry
		extipEt.prival=0;
		extipEt.pri=0;
		extipEt.type=L34_EXTIP_TYPE_NAPT;
		extipEt.valid=1;

		errorno=RT_ERR_RG_EXTIP_SET_FAIL;
		ret = RTK_L34_EXTINTIPTABLE_SET(wan_intf_idx, &extipEt);
		if(ret!=RT_ERR_OK)goto RET_IPTABLE_ERR;
	}
#endif



	//RG_GLB_STATIC_CALLED=0;		//clear the lock flag
	//rg_unlock(&RG_GLB_STATIC_CALLED);

	//return (RT_ERR_RG_OK);
#if 0
RET_IPTABLE_ERR:
	//Delete the ip table entry
	if(static_info->napt_enable)
	{
		bzero(&extipEt, sizeof(rtk_l34_ext_intip_entry_t));
		RTK_L34_EXTINTIPTABLE_SET(wan_intf_idx, &extipEt);
	}
#endif



	//RG_GLB_STATIC_CALLED=0;		//clear the lock flag
	//rg_unlock(&rg_kernel.wanStaticCalled);

	RETURN_ERR(errorno);
}

rtk_rg_err_code_t _rtk_rg_dsliteInfo_release(int wan_intf_idx, rtk_rg_ipDslitStaticInfo_t *dslite_hw_info)
{
	int i,j,l2Idx,errorno;
	rtk_l34_nexthop_entry_t nxpEt;
	rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].finished=1;
#ifdef __KERNEL__
	_rtk_rg_del_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE]);
#endif
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4>=0)
	{
		l2Idx=rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4].rtk_nexthop.nhIdx;
		//search nexthop for the MAC index, if not exist, delete it and disable ARP and Neighbor pointed to it.
		for(i=0;i<MAX_NEXTHOP_SW_TABLE_SIZE;i++)
		{
			if(i==rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4)continue;
			if(rg_db.nexthop[i].rtk_nexthop.nhIdx==l2Idx)break;
		}
		if(i==MAX_NEXTHOP_SW_TABLE_SIZE)//no other nexthop use the same MAC, delete it!
		{
			for(j=0;j<MAX_ARP_SW_TABLE_SIZE;j++)
				if(rg_db.arp[j].rtk_arp.nhIdx==l2Idx)rtk_rg_apollo_arpEntry_del(j);
			for(j=0;j<MAX_IPV6_NEIGHBOR_SW_TABLE_SIZE;j++)
				if(rg_db.v6neighbor[j].neighborEntry.l2Idx==l2Idx)rtk_rg_apollo_neighborEntry_del(j);
			memcpy(&nxpEt,&rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4].rtk_nexthop,sizeof(rtk_l34_nexthop_entry_t));
			nxpEt.nhIdx=rg_db.systemGlobal.defaultTrapLUTIdx;		//use this DUMMY index to force packet TRAP to CPU
			rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4].valid=1;
			errorno = RTK_L34_NEXTHOPTABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.nexthop_ipv4, &nxpEt);
			if(errorno!=RT_ERR_OK)goto ERR_OUT;
		}
	}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)	
	rg_db.netif[wan_intf_idx].rtk_netif.deny_ipv4 = TRUE;
	rg_db.netif[wan_intf_idx].rtk_netif.deny_ipv6 = TRUE;
	RTK_L34_NETIFTABLE_SET(wan_intf_idx, &rg_db.netif[wan_intf_idx].rtk_netif);
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
	dslite_hw_info->rtk_dslite.index=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_idx;
	dslite_hw_info->rtk_dslite.valid=0;
	ASSERT_EQ(RTK_L34_DSLITEINFTABLE_SET(&dslite_hw_info->rtk_dslite),RT_ERR_OK);
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//ApolloPro always trap if not hit flow
	// N/A

	// For DSLite WAN, delete FB related setting.
	errorno = _rtk_rg_flow_deleteTunnelConfig(wan_intf_idx);
	if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;
#else
	//disable reserve ACL trap
	if(wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
	{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP+wan_intf_idx);
	}
#endif
	//if non-any-dslite-wan delete dsliteMc entry
	{
		uint32 delDsliteMcEntry=1;
		rtk_l34_dsliteMc_entry_t dsliteMcEntry;

		for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
		{
			if( rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan &&
				rg_db.systemGlobal.interfaceInfo[i].valid &&
				(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
				rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE))
			{
				delDsliteMcEntry=0;
				break;
			}
		}

		if(delDsliteMcEntry)
		{
			bzero(&dsliteMcEntry,sizeof(dsliteMcEntry));
			memset(&dsliteMcEntry.ipUPrefix64Mask,0xff,sizeof(rtk_ipv6_addr_t));
			memset(&dsliteMcEntry.ipMPrefix64Mask,0xff,sizeof(rtk_ipv6_addr_t));
			ASSERT_EQ(RTK_L34_DSLITEMULTICAST_SET(&dsliteMcEntry),RT_ERR_RG_OK);
		}
	}

	return RT_ERR_RG_OK;

ERR_OUT:
	//rg_unlock(&rg_kernel.wanDsliteCalled);

	RETURN_ERR(errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_dsliteInfo_set(int wan_intf_idx, rtk_rg_ipDslitStaticInfo_t *dslite_info)
{
	int errorno,l2Idx;
	rtk_rg_macEntry_t macEntry;
	rtk_mac_t zeroMAC={{0}};
	rtk_ipv6_addr_t zeroIPv6={{0}};
	rtk_l34_dsliteMc_entry_t dsliteMcEntry;
#if defined(CONFIG_RG_RTL9602C_SERIES)
	int dsliteIdx;
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//ApolloPro always trap if not hit flow
#else
	rtk_rg_aclAndCf_reserved_intf_dslite_trap_t intf_dslite_trap_para;
#endif
	uint32 check_ivl_vid, ivlL2Idx;

	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	dsliteIdx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_idx;
#endif
	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_DSLITE)
			RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	//if(!memcmp(dslite_info->rtk_dslite.ipB4.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))RETURN_ERR(RT_ERR_RG_B4_IP_NOT_SET);
	//if(!memcmp(dslite_info->rtk_dslite.ipAftr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))RETURN_ERR(RT_ERR_RG_AFTR_IP_NOT_SET);
	if(dslite_info->aftr_mac_auto_learn==0 && !memcmp(dslite_info->aftr_mac_addr.octet,zeroMAC.octet,ETHER_ADDR_LEN) && memcmp(dslite_info->rtk_dslite.ipAftr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))
		RETURN_ERR(RT_ERR_RG_AFTR_MAC_NOT_SET);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(dslite_info->rtk_dslite.hopLimit<=1)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(dslite_info->rtk_dslite.tcOpt>=RTK_L34_DSLITE_TC_OPT_END)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if((dsliteIdx<0)||(!rg_db.dslite[dsliteIdx].rtk_dslite.valid))RETURN_ERR(RT_ERR_RG_DSLITE_UNINIT);
	if(rg_db.dslite[dsliteIdx].intfIdx!=wan_intf_idx)RETURN_ERR(RT_ERR_RG_DSLITE_UNMATCH);
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(dslite_info->rtk_dslite.hopLimit<=1)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(dslite_info->rtk_dslite.tcOpt>RTK_L34_DSLITE_TC_OPT_ASSIGN)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);	// ApolloPro only support static tc value.
#endif

	//20160617LUKE: check if mtu too large for dual header packet
	if(dslite_info->static_info.mtu>MAX_DSLITE_MTU_SIZE)
		WARNING("Caution! MTU too large may cause outer IPv6 header fragmentation.");

	//Check if we are reentried
	//rg_lock(&rg_kernel.wanDsliteCalled);

	//store aftr in global variable
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipB4.ipv6_addr, dslite_info->rtk_dslite.ipB4.ipv6_addr, IPV6_ADDR_LEN);
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipAftr.ipv6_addr, dslite_info->rtk_dslite.ipAftr.ipv6_addr, IPV6_ADDR_LEN);
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.aftr_mac_auto_learn=dslite_info->aftr_mac_auto_learn;
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.aftr_mac_addr.octet,dslite_info->aftr_mac_addr.octet,ETHER_ADDR_LEN);
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite.hopLimit=dslite_info->rtk_dslite.hopLimit&0xff;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite.flowLabel=dslite_info->rtk_dslite.flowLabel&0xfffff;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite.tcOpt=dslite_info->rtk_dslite.tcOpt;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_info.rtk_dslite.tc=dslite_info->rtk_dslite.tc&0xff;
#endif

	errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &dslite_info->static_info);
	if(errorno!=RT_ERR_RG_OK) goto ERR_OUT;

	//query aftr mac address
	if(memcmp(dslite_info->rtk_dslite.ipAftr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))
	{
		//add a dsliteMc entry hit all dsliteMc packet , remove dsliteMc ipv6 header
		bzero(&dsliteMcEntry,sizeof(dsliteMcEntry));
		RTK_L34_DSLITEMULTICAST_SET(&dsliteMcEntry);

		if(dslite_info->aftr_mac_auto_learn)
		{
			rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].finished=0;
			memcpy(&rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp,&dslite_info->rtk_dslite.ipAftr,sizeof(rtk_ipv6_addr_t));
			rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].ipv6GwMacReqCallBack=_rtk_rg_internal_IPV6AFTRMACSetup;
			DEBUG("wan intf is %d, function pointer is %p",wan_intf_idx,rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].ipv6GwMacReqCallBack);
#ifdef __KERNEL__

			_rtk_rg_del_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE]);
			_rtk_rg_init_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE]);
			rg_kernel.neighborDiscoveryTimer[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].data = (unsigned long)(wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE);
			rg_kernel.neighborDiscoveryTimer[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].function = _rtk_rg_AFTRDiscoveryTimerFunc;
			rg_kernel.neighborDiscoveryTimerCounter[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE]=0;
			DEBUG("aftr miss, discovery neighbor =%08x:%08x:%08x:%08x\n",*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp.ipv6_addr),
				*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp.ipv6_addr+4),
				*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp.ipv6_addr+8),
				*(unsigned int *)(rg_db.systemGlobal.intfNeighborDiscovery[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE].reqIp.ipv6_addr+12));
			_rtk_rg_mod_timer(&rg_kernel.neighborDiscoveryTimer[wan_intf_idx+MAX_NETIF_SW_TABLE_SIZE], jiffies+(rg_db.systemGlobal.arp_requset_interval_sec*TICKTIME_PERIOD));
#endif
		}
		else
		{
			//Add gateway mac and Default route
			bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
			memcpy(macEntry.mac.octet,dslite_info->aftr_mac_addr.octet,ETHER_ADDR_LEN);
			//set SVL for lanIntf, patched in 20121203
			//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
			{
				macEntry.port_idx=RTK_RG_EXT_PORT0;
				macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
			}
			else
			{
				macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				macEntry.wlan_device_idx=FAIL;
			}
			//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
				DEBUG("Special change WAN_PORT from PON to RGMII.");
				macEntry.port_idx=RTK_RG_PORT_RGMII;
			}
#endif
			//set mac's vlanid by egress tagif setting
			macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			check_ivl_vid = macEntry.vlan_id;

			//Add SVL lut entry first
			macEntry.isIVL=0;
			macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
			//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
			if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
				macEntry.vlan_id=0;
#else	// support ctag_if
			macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
			macEntry.static_entry=1;	//won't age out
			macEntry.arp_used=1;		//pointed by nexthop entry
			errorno=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if(rg_kernel.block_communication_between_internet_and_other)
			{
				ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
			}
			else
#endif
			//Add IVL lut entry (Do not move!)
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
			{
				ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
				l2Idx = ivlL2Idx;
			}
			DEBUG("### add AFTR l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],
				macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

			errorno=_rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			dslite_info->rtk_dslite.index=dsliteIdx;
			dslite_info->rtk_dslite.valid=1;
			ASSERT_EQ(RTK_L34_DSLITEINFTABLE_SET(&dslite_info->rtk_dslite),RT_ERR_OK);
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//ApolloPro always trap if not hit flow
			// N/A

			// software configuration was done, now start to configure flow path6 and extra tag content buffer
			errorno = _rtk_rg_flow_setupDSLite(wan_intf_idx, l2Idx, FALSE);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;
#else
			//enable reserve ACL trap
			if(wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
			{
				memcpy(intf_dslite_trap_para.ipv6_dip.ipv6_addr, dslite_info->rtk_dslite.ipB4.ipv6_addr, IPV6_ADDR_LEN);
				memcpy(intf_dslite_trap_para.smac.octet, dslite_info->aftr_mac_addr.octet, ETHER_ADDR_LEN);
		   		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP+wan_intf_idx,&intf_dslite_trap_para);
			}
#endif
		}
	}
	else
		return _rtk_rg_dsliteInfo_release(wan_intf_idx, dslite_info);

ERR_OUT:
	//rg_unlock(&rg_kernel.wanDsliteCalled);

	RETURN_ERR(errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_dhcpRequest_set(int wan_intf_idx)
{
	DEBUG("%s is called!!!",__func__);
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//add dhcpRequestByHwCallBack callback to call dhcpc
	{
		if(rg_db.systemGlobal.initParam.dhcpRequestByHwCallBack != NULL)
		{
			rg_db.systemGlobal.initParam.dhcpRequestByHwCallBack(&wan_intf_idx);
		}
	}
	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_dhcpClientInfo_set(int wan_intf_idx, rtk_rg_ipDhcpClientInfo_t *dhcpClient_info)
{
#if 0
    int i,ret,rtidx=-1,errorno,routingAdd=0,arp_valid_idx,arpMissed=0;
    unsigned int input_ipmsk,last_arp=0;
    rtk_l34_routing_entry_t rtEntry;
    //rtk_l34_ext_intip_entry_t extipEt;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;
#endif
    //rtk_l34_netif_entry_t intfEntry;
	int errorno;
	rtk_rg_ip_version_t ip_version;
	rtk_ipv6_addr_t zeroV6={{0}};

    //Check parameter
    if(dhcpClient_info == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(dhcpClient_info->stauts<0 || dhcpClient_info->stauts>=DHCP_STATUS_END)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
    //if(wan_intf_idx<0 || wan_intf_idx>MAX_NETIF_HW_TABLE_SIZE-1)
        //RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//if(dhcpClient_info->hw_info.ip_addr == 0 || dhcpClient_info->hw_info.ip_network_mask == 0 || dhcpClient_info->hw_info.mtu == 0)
        //RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Call after rtk_rg_wanInterface_add, so check if we had already add interface
    //bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
    //ret = rtk_l34_netifTable_get(wan_intf_idx, &intfEntry);
    if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_DHCP)
        RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	ip_version=dhcpClient_info->hw_info.ip_version;
	//20180503LUKE: we could lease IPv4 or IPv6 addresses separately, so return fail only if none of them is valid.
	if(dhcpClient_info->stauts==DHCP_STATUS_LEASED)
	{
		if(ip_version==IPVER_V4ONLY && dhcpClient_info->hw_info.ip_addr==0)RETURN_ERR(RT_ERR_RG_DHCP_LEASED_INVALID_IP);
		if(ip_version==IPVER_V6ONLY && !memcmp(&dhcpClient_info->hw_info.ipv6_addr,&zeroV6,sizeof(rtk_ipv6_addr_t)))RETURN_ERR(RT_ERR_RG_DHCP_LEASED_INVALID_IP);
		if(ip_version==IPVER_V4V6 && dhcpClient_info->hw_info.ip_addr==0 && !memcmp(&dhcpClient_info->hw_info.ipv6_addr,&zeroV6,sizeof(rtk_ipv6_addr_t)))RETURN_ERR(RT_ERR_RG_DHCP_LEASED_INVALID_IP);
	}

	//Check if we are reentried
	//rg_lock(&rg_kernel.wanDHCPCalled);

	//20141107LUKE: if we get status=DHCP_STATUS_RELEASED, we will check ip_version and clear it!!
	if(dhcpClient_info->stauts==DHCP_STATUS_RELEASED && ((rg_db.systemGlobal.wanInfoSet & (0x1<<wan_intf_idx)) > 0))
	{
		memcpy(&dhcpClient_info->hw_info,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].p_wanStaticInfo,sizeof(rtk_rg_ipStaticInfo_t));
		if(ip_version!=IPVER_V6ONLY)
		{
			//Clear V4 setting!!
			dhcpClient_info->hw_info.napt_enable=0;
	        dhcpClient_info->hw_info.ip_addr=0;
	        dhcpClient_info->hw_info.ip_network_mask=0;
			dhcpClient_info->hw_info.ipv4_default_gateway_on=0;
			dhcpClient_info->hw_info.gateway_ipv4_addr=0;
			dhcpClient_info->hw_info.gw_mac_auto_learn_for_ipv4=0;
			bzero(&dhcpClient_info->hw_info.gateway_mac_addr_for_ipv4,sizeof(rtk_mac_t));
		}
		if(ip_version!=IPVER_V4ONLY)
		{
			//Clear V6 setting!!
			bzero(dhcpClient_info->hw_info.ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
			dhcpClient_info->hw_info.ipv6_mask_length=0;
			dhcpClient_info->hw_info.ipv6_default_gateway_on=0;
			bzero(dhcpClient_info->hw_info.gateway_ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
			dhcpClient_info->hw_info.gw_mac_auto_learn_for_ipv6=0;
			bzero(&dhcpClient_info->hw_info.gateway_mac_addr_for_ipv6,sizeof(rtk_mac_t));
		}
		//WARNING("the dhcp status is RELEASED!!");
	}

	errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &dhcpClient_info->hw_info);

    if(errorno==RT_ERR_RG_OK)
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dhcp_client_info.stauts=dhcpClient_info->stauts;

	//RG_GLB_DHCP_CALLED=0;		//clear the lock flag
	//rg_unlock(&rg_kernel.wanDHCPCalled);

    RETURN_ERR(errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_pppoeClientInfoBeforeDial_set(int wan_intf_idx, rtk_rg_pppoeClientInfoBeforeDial_t *app_info)
{
    //int ret;
    //rtk_l34_netif_entry_t intfEntry;
	//rtk_l34_routing_entry_t rtEntry;

    //Check parameter
    if(app_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Call after rtk_rg_wanInterface_add, so check if we had already add interface
    //bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
    //ret = rtk_l34_netifTable_get(wan_intf_idx, &intfEntry);
    if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPPoE)
        RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);

	//Check if there is default route set up before, if so, we have to keep original setting here and set
	//default route to TRAP
	/*bzero(&rtEntry,sizeof(rtk_l34_routing_entry_t));
	rtEntry.process=L34_PROCESS_CPU;
	rtEntry.valid=1;		//turn on

	ret = RTK_L34_ROUTINGTABLE_SET(RTK_L34_ROUTINGTABLE_SET, &rtEntry);	//set default route setting to TRAP, keep other setting
	if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_ROUTE_SET_FAIL);*/

    //Save in global variable
    //bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.username, 4);
    //memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.username, app_info->username, 4);

    bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.username, 32);
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.username, app_info->username, 32);
	//bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.password, 4);
    //memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.password, app_info->password, 4);
	bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.password, 32);
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.password, app_info->password, 32);
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.auth_type=app_info->auth_type;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.pppoe_proxy_enable=app_info->pppoe_proxy_enable;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.max_pppoe_proxy_num=app_info->max_pppoe_proxy_num;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.auto_reconnect=app_info->auto_reconnect;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.dial_on_demond=app_info->dial_on_demond;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.idle_timeout_secs=app_info->idle_timeout_secs;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.stauts=app_info->stauts;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.dialOnDemondCallBack=app_info->dialOnDemondCallBack;
    rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial.idleTimeOutCallBack=app_info->idleTimeOutCallBack;

	//rg_db.systemGlobal.pppoeBeforeCalled = 1;


	//add pppoeBeforeDiagByHwCCallBack callback to call spppdctl
	{
		if(rg_db.systemGlobal.initParam.pppoeBeforeDiagByHwCallBack != NULL)
		{
			rtk_rg_pppoeClientInfoBeforeDial_t before_dial;
			bzero(&before_dial,sizeof(rtk_rg_pppoeClientInfoBeforeDial_t));
			memcpy(&before_dial, &rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.before_dial, sizeof(rtk_rg_pppoeClientInfoBeforeDial_t));
			rg_db.systemGlobal.initParam.pppoeBeforeDiagByHwCallBack(&before_dial,&wan_intf_idx);
		}
	}


    return (RT_ERR_RG_OK);
}

void _rtk_rg_acl_gpon_pppoe_status_protection_add(void);
void _rtk_rg_acl_gpon_pppoe_status_protection_del(void);

rtk_rg_err_code_t rtk_rg_apollo_pppoeClientInfoAfterDial_set(int wan_intf_idx, rtk_rg_pppoeClientInfoAfterDial_t *clientPppoe_info)
{
#if 0
    int i,ret,rtidx=-1,errorno,routingAdd=0,arp_valid_idx,arpMissed=0;
    unsigned int input_ipmsk,last_arp=0;
    rtk_l34_netif_entry_t intfEntry;
    rtk_l34_routing_entry_t rtEntry;
    //rtk_l34_ext_intip_entry_t extipEt;
	rtk_rg_ipv4RoutingEntry_t cb_routEt;
#endif
    //rtk_l34_netif_entry_t intfEntry;
	rtk_l34_pppoe_entry_t pppoeEt;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//ApolloPro always trap if not hit flow
#else
	rtk_rg_aclAndCf_reserved_pppoe_intf_multicast_routing_trap_t intf_gmac;
#endif
	int ret,errorno;


#if defined(CONFIG_RG_RTL9600_SERIES) && defined(CONFIG_GPON_FEATURE)
	int gpon_pppeo_status_fwd_mode=0;
#endif

    //Check parameter
//    if(rg_db.systemGlobal.pppoeBeforeCalled == 0)		//did not call pppoe_before in the past period
//		RETURN_ERR(RT_ERR_RG_PPPOE_UNINIT);
	if(clientPppoe_info==NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(clientPppoe_info->sessionId==0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
    //if(wan_intf_idx<0 || wan_intf_idx>MAX_NETIF_HW_TABLE_SIZE-1)
        //RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//if(clientPppoe_info->hw_info.ip_addr == 0 || clientPppoe_info->hw_info.ip_network_mask == 0 || clientPppoe_info->hw_info.mtu == 0)
        //RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Call after rtk_rg_wanInterface_add, so check if we had already add interface
    //bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
    //ret = rtk_l34_netifTable_get(wan_intf_idx, &intfEntry);
    if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPPoE)
        RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	//Check if we are reentried
	//rg_lock(&rg_kernel.wanPPPOEAfterCalled);
	if((clientPppoe_info->hw_info.ip_network_mask>0 && clientPppoe_info->hw_info.ip_network_mask!=0xffffffff) || (clientPppoe_info->hw_info.ipv6_mask_length>0 && clientPppoe_info->hw_info.ipv6_mask_length!=128) )
		WARNING("PPPoE WAN SUBNET WARNING , point-to-point connection should mask all (v4mask=255.255.255.255 v6mask=128)");

#if defined(CONFIG_RG_RTL9600_SERIES) && defined(CONFIG_GPON_FEATURE)
	//gpon pppoe status protection
	if(rg_db.systemGlobal.initParam.wanPortGponMode)
	{
		int i;
		int ret;
		int sid_rule_found=0;
		uint32 sid=0;
		gpon_pppoe_mode_t mode;

		//search such interface streamID
		for(i=0;i<MAX_ACL_SW_ENTRY_SIZE;i++){
			if(rg_db.systemGlobal.acl_SW_table_entry[i].valid==1 &&
				rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.fwding_type_and_direction==ACL_FWD_TYPE_DIR_INGRESS_OR_EGRESS_L34_UP_STREAMID_CVLAN_SVLAN &&
				(rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.filter_fields & EGRESS_INTF_BIT) && /*check patterb egress_intf_idx*/
				rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.egress_intf_idx== wan_intf_idx &&
				rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.action_type==ACL_ACTION_TYPE_QOS && /*check streamID action is valid*/
				rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.qos_actions&(ACL_ACTION_STREAM_ID_OR_LLID_BIT))
			{
				sid = rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.action_stream_id_or_llid;
				ACL_RSV("Found sid=%d is using for PPPoE_Wan[%d] by RG_ACL[%d].",sid,wan_intf_idx,i);
				sid_rule_found = 1;
				break;
			}
		}

		if(sid_rule_found)
		{
			//check streamID status
			bzero(&mode,sizeof(mode));
			ret = gpon_pppoe_mode_get(sid,&mode);
			if(ret!=RT_ERR_OK)
			{
				WARNING("Gpon pppoe status check fail, ret = 0x%x", ret);
			}
			else
			{
				ACL_RSV("detect from gpon_pppoe_mode_get, mode =%d", mode);
				//pppoe should be protected by ACL[1]
				if((mode == GPON_PPPOE_MODE_SW) || (mode == GPON_PPPOE_MODE_SW_OFFLOAD))
				{
					rg_db.systemGlobal.gpon_pppoe_status = mode;
					_rtk_rg_acl_gpon_pppoe_status_protection_add();
				}
				gpon_pppeo_status_fwd_mode = mode;
			}

		}
		else
		{
			WARNING("Not found exist RG_ACL assign streamID for PPPoE_Wan[%d]",wan_intf_idx);
		}
	}
#endif

    errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &clientPppoe_info->hw_info);

    if(errorno==RT_ERR_RG_OK)
    {
    	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.after_dial.sessionId=clientPppoe_info->sessionId;
#if defined(CONFIG_RG_RTL9600_SERIES) && defined(CONFIG_GPON_FEATURE)
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.after_dial.gpon_pppoe_status = gpon_pppeo_status_fwd_mode;
		ACL_RSV("INTF[%d] gpon_pppoe_status=%d",wan_intf_idx,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_info.after_dial.gpon_pppoe_status);
#endif

		//Set up PPPoE table and next hop table for this interface
		errorno=RT_ERR_RG_PPPOE_SET_FAIL;
		bzero(&pppoeEt, sizeof(rtk_l34_pppoe_entry_t));
		pppoeEt.sessionID=clientPppoe_info->sessionId;

		ret = RTK_L34_PPPOETABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx, &pppoeEt);
		if(ret!=RT_ERR_OK)goto RET_PPPOE_ERR;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		// flow based: pppoe session id was saved in netif table
		ret = _rtk_rg_netifPPPoESession_set(wan_intf_idx, FB_NETIFPPPOE_ACT_ADD, pppoeEt.sessionID);
		if(ret!=RT_ERR_OK)goto RET_PPPOE_ERR;
#endif


#ifdef CONFIG_RG_PPPOE_PASSTHROUGH
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//apolloPro no need this feature
#else

		//Check if LAN has PPPoE Pass Through
		/*if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on == 0)
		{
			for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
			{
				if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->pppoe_passThrough == 1)
					break;
			}
			if(i<rg_db.systemGlobal.lanIntfTotalNum)
			{*/
				//add ACL to transfer WAN to LAN packet with WAN's VLAN
				//1 FIXME: Patch for 201305171900, pppoe pass through has to be disabled!!
				//errorno=RT_ERR_OK;
				//errorno = _rtk_rg_aclFilterSessionID_and_VIDRemarking_add(wan_intf_idx, rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
				errorno = _rtk_rg_acl_reserved_pppoePassthrough_IntfisPppoewan_add(wan_intf_idx,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac);
				if(errorno!=RT_ERR_OK)goto RET_PPPOE_ERR;
				DEBUG("add VID logging success!! to Gmac_%02x:%02x:%02x:%02x:%02x:%02x will be logging(NOP)",
					rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet[0],
					rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet[1],
					rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet[2],
					rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet[3],
					rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet[4],
					rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet[5]);
			//}
		//}
#endif
#endif

   	}
	else
		RETURN_ERR(errorno);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//ApolloPro always trap if not hit flow
#else
	//20150429LUKE: create reserved ACL for multicast packet
	if(wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
	{
		bzero(&intf_gmac,sizeof(intf_gmac));
		memcpy(&intf_gmac.gmac.octet,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN);
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PPPOE_INTF0_MC_ROUTING_TRAP+wan_intf_idx,&intf_gmac);
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)

	if(rg_db.systemGlobal.internalSupportMask&RTK_RG_INTERNAL_SUPPORT_BIT4)
	{
		if(rg_db.systemGlobal.igmp_pppoe_passthrough_learning==0)
		{
			rtk_rg_aclAndCf_reserved_pppoe_multicast_intf_permit_t pppoe_multicast_permit;
			bzero(&pppoe_multicast_permit,sizeof(pppoe_multicast_permit));

			if( rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan &&
				rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE &&
				rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx >=0 &&
				rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid ){

				memcpy(&pppoe_multicast_permit.gmac.octet,rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN);
				//add theintf PPPoE Multicast permit rule if the Interface can be add to H/W
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PPPoE_MULTICAST_INTF0_PERMIT+wan_intf_idx,&pppoe_multicast_permit);
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_PPPoE_MULTICAST_DEFAULT_TRAP, NULL);
			}
		}
	}


	if((rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid & (IF_SOFTWARE4_ENTRY|IF_SOFTWARE6_ENTRY)) != (IF_SOFTWARE4_ENTRY|IF_SOFTWARE6_ENTRY))//wan interface is valid , and could be forward by H/W
	{
		if(rg_db.systemGlobal.pppoeGponSmallbandwithControl==1 &&
			rg_db.systemGlobal.pppoeGponSmallbandwithControlSupportBrigeSameMac==1)
		{

			rtk_rg_aclAndCf_reserved_gpon_smallbw_bridge_port_redirect_t bridge_dmac_support;
			if(clientPppoe_info->hw_info.ip_version==IPVER_V6ONLY){
				memcpy(&bridge_dmac_support.remote_mac.octet[0],&clientPppoe_info->hw_info.gateway_mac_addr_for_ipv6.octet[0],ETHER_ADDR_LEN);
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_GPON_PPPoE_SMALL_BANDWIDTH_BRIDGE_DMAC_SAME_AS_INTF0_REMOTE_MAC+wan_intf_idx,&bridge_dmac_support);
			}else{
				memcpy(&bridge_dmac_support.remote_mac.octet[0],&clientPppoe_info->hw_info.gateway_mac_addr_for_ipv4.octet[0],ETHER_ADDR_LEN);
				_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_GPON_PPPoE_SMALL_BANDWIDTH_BRIDGE_DMAC_SAME_AS_INTF0_REMOTE_MAC+wan_intf_idx,&bridge_dmac_support);
			}
		}
	}
#endif

#if defined(CONFIG_RG_G3_SERIES)
	// Add generic interface of PPPoE wan
	ASSERT_EQ(_rtk_rg_generic_wan_intf_add(wan_intf_idx), RT_ERR_RG_OK);
#endif

	errorno=RT_ERR_RG_OK;
	goto RET_SUCCESS;

RET_PPPOE_ERR:
	//Delete the pppoe etnry
	bzero(&pppoeEt, sizeof(rtk_l34_pppoe_entry_t));
	RTK_L34_PPPOETABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx, &pppoeEt);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_netifPPPoESession_set(wan_intf_idx, FB_NETIFPPPOE_ACT_KEEP, 0);
#endif

RET_SUCCESS:
	//RG_GLB_PPPOE_AFTER_CALLED=0;		//clear the lock flag
	//rg_unlock(&rg_kernel.wanPPPOEAfterCalled);
    RETURN_ERR(errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_pppoeInterfaceIdleTime_get(int intfIdx,uint32 *idleSec)
{
	if(intfIdx <0 || intfIdx>=MAX_NETIF_SW_TABLE_SIZE) RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(idleSec==NULL) RETURN_ERR(RT_ERR_RG_NULL_POINTER);

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPPoE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv4>=0
		&& rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv4].staticRouteWanIdxMask!=0x0)
	{
		DEBUG("Change intfIdx[%d] to intfIdx[%d] for ipv4 static route.", intfIdx, rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv4].rtk_nexthop.ifIdx);
		intfIdx = rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.nexthop_ipv4].rtk_nexthop.ifIdx;
	}
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_idx < 0
		|| rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_idx >= MAX_PPPOE_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	*idleSec = rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.pppoe_idx].idleSecs;

	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_pptpClientInfoBeforeDial_set(int wan_intf_idx, rtk_rg_pptpClientInfoBeforeDial_t *app_info)
{
    //Check parameter
    if(app_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Call after rtk_rg_wanInterface_add, so check if we had already add interface
    if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPTP)
        RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);

	//Save in global variable
	bzero(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.before_dial,sizeof(rtk_rg_pptpClientInfoBeforeDial_t));
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.before_dial,app_info,sizeof(rtk_rg_pptpClientInfoBeforeDial_t));

	//add pptpBeforeDiagByHwCCallBack callback to call spppctl
	if(rg_db.systemGlobal.initParam.pptpBeforeDialByHwCallBack != NULL)
	{
		rtk_rg_pptpClientInfoBeforeDial_t before_dial;
		bzero(&before_dial,sizeof(rtk_rg_pptpClientInfoBeforeDial_t));
		memcpy(&before_dial, &rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.before_dial, sizeof(rtk_rg_pptpClientInfoBeforeDial_t));
		rg_db.systemGlobal.initParam.pptpBeforeDialByHwCallBack(&before_dial,&wan_intf_idx);
	}

	return RT_ERR_RG_OK;
}


rtk_rg_err_code_t rtk_rg_apollo_pptpClientInfoAfterDial_set(int wan_intf_idx, rtk_rg_pptpClientInfoAfterDial_t *clientPptp_info)
{
	int errorno,l2Idx;
	rtk_mac_t zeroMAC={{0}};
	rtk_rg_macEntry_t macEntry;
	rtk_rg_ipStaticInfo_t hw_info;
	uint32 check_ivl_vid, ivlL2Idx;

    //Check parameter
    if(clientPptp_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
    if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPTP)
        RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	if(clientPptp_info->hw_info.gw_mac_auto_learn_for_ipv4==0 && !memcmp(clientPptp_info->hw_info.gateway_mac_addr_for_ipv4.octet,zeroMAC.octet,ETHER_ADDR_LEN))
		RETURN_ERR(RT_ERR_RG_PPTP_MAC_NOT_SET);

	//Check if we are reentried
	//rg_lock(&rg_kernel.wanPPTPAfterCalled);
	memcpy(&hw_info,&clientPptp_info->hw_info,sizeof(rtk_rg_ipStaticInfo_t));
	hw_info.gateway_ipv4_addr=0;
	errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &hw_info);
    if(errorno==RT_ERR_RG_OK)
    {
		memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.after_dial,clientPptp_info,sizeof(rtk_rg_pptpClientInfoAfterDial_t));
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.sw_gre_header_server_sequence=0;
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pptp_info.sw_gre_header_server_sequence_started=0;

		if(clientPptp_info->hw_info.gw_mac_auto_learn_for_ipv4)
		{
			_rtk_rg_PPTPLearningTimerInitialize(wan_intf_idx);
		}
		else
		{
			//Add gateway mac and Default route
			bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
			memcpy(macEntry.mac.octet,clientPptp_info->hw_info.gateway_mac_addr_for_ipv4.octet,ETHER_ADDR_LEN);
			//set SVL for lanIntf, patched in 20121203
			//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
			{
				macEntry.port_idx=RTK_RG_EXT_PORT0;
				macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
			}
			else
			{
				macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				macEntry.wlan_device_idx=FAIL;
			}
			//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
				DEBUG("Special change WAN_PORT from PON to RGMII.");
				macEntry.port_idx=RTK_RG_PORT_RGMII;
			}
#endif
			//set mac's vlanid by egress tagif setting
			macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			check_ivl_vid = macEntry.vlan_id;

			//Add SVL lut entry first
			macEntry.isIVL=0;
			macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
			//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
			if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
				macEntry.vlan_id=0;
#else	// support ctag_if
			macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
			macEntry.static_entry=1;	//won't age out
			macEntry.arp_used=1;		//pointed by nexthop entry
			errorno=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if(rg_kernel.block_communication_between_internet_and_other)
			{
				ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
			}
			else
#endif
			//Add IVL lut entry (Do not move!)
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
			{
				ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
				l2Idx = ivlL2Idx;
			}

			DEBUG("### add PPTP l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],
				macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

			errorno=_rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		// software configuration was done, now start to configure flow path6 and extra tag content buffer
		errorno = _rtk_rg_flow_setupPPTP(wan_intf_idx, l2Idx);
		if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;
#endif
		}

    }
ERR_OUT:
	//rg_unlock(&rg_kernel.wanPPTPAfterCalled);
	return (errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_l2tpClientInfoBeforeDial_set(int wan_intf_idx, rtk_rg_l2tpClientInfoBeforeDial_t *app_info)
{
    //Check parameter
    if(app_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

    //Call after rtk_rg_wanInterface_add, so check if we had already add interface
    if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
        rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_L2TP)
        RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);

	//Save in global variable
    bzero(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.l2tp_info.before_dial, sizeof(rtk_rg_l2tpClientInfoBeforeDial_t));
	memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.l2tp_info.before_dial, app_info, sizeof(rtk_rg_l2tpClientInfoBeforeDial_t));

	//add l2tpBeforeDiagByHwCCallBack callback to call spppctl
	if(rg_db.systemGlobal.initParam.l2tpBeforeDialByHwCallBack != NULL)
	{
		rtk_rg_l2tpClientInfoBeforeDial_t before_dial;
		bzero(&before_dial,sizeof(rtk_rg_l2tpClientInfoBeforeDial_t));
		memcpy(&before_dial, &rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.l2tp_info.before_dial, sizeof(rtk_rg_l2tpClientInfoBeforeDial_t));
		rg_db.systemGlobal.initParam.l2tpBeforeDialByHwCallBack(&before_dial,&wan_intf_idx);
	}

	return RT_ERR_RG_OK;
}

rtk_rg_err_code_t rtk_rg_apollo_l2tpClientInfoAfterDial_set(int wan_intf_idx, rtk_rg_l2tpClientInfoAfterDial_t *clientL2tp_info)
{
	int errorno,l2Idx=0;
	rtk_mac_t zeroMAC={{0}};
	rtk_rg_macEntry_t macEntry;
	rtk_rg_ipStaticInfo_t hw_info;
	uint32 check_ivl_vid, ivlL2Idx;

	//Check parameter
	if(clientL2tp_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_L2TP)
		RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	if(clientL2tp_info->hw_info.gw_mac_auto_learn_for_ipv4==0 && !memcmp(clientL2tp_info->hw_info.gateway_mac_addr_for_ipv4.octet,zeroMAC.octet,ETHER_ADDR_LEN))
		RETURN_ERR(RT_ERR_RG_L2TP_MAC_NOT_SET);

	//Check if we are reentried
	//rg_lock(&rg_kernel.wanL2TPAfterCalled);
	memcpy(&hw_info,&clientL2tp_info->hw_info,sizeof(rtk_rg_ipStaticInfo_t));
	hw_info.gateway_ipv4_addr=0;
	errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &hw_info);
    if(errorno==RT_ERR_RG_OK)
    {
		memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.l2tp_info.after_dial,clientL2tp_info,sizeof(rtk_rg_l2tpClientInfoAfterDial_t));

		if(clientL2tp_info->hw_info.gw_mac_auto_learn_for_ipv4)
		{
			_rtk_rg_L2TPLearningTimerInitialize(wan_intf_idx);
		}
		else
		{
			//Add gateway mac and Default route
			bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
			memcpy(macEntry.mac.octet,clientL2tp_info->hw_info.gateway_mac_addr_for_ipv4.octet,ETHER_ADDR_LEN);
			//set SVL for lanIntf, patched in 20121203
			//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
			if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
			{
				macEntry.port_idx=RTK_RG_EXT_PORT0;
				macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
			}
			else
			{
				macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				macEntry.wlan_device_idx=FAIL;
			}
			//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
				DEBUG("Special change WAN_PORT from PON to RGMII.");
				macEntry.port_idx=RTK_RG_PORT_RGMII;
			}
#endif
			//set mac's vlanid by egress tagif setting
			macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			check_ivl_vid = macEntry.vlan_id;

			//Add SVL lut entry first
			macEntry.isIVL=0;
			macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
			//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
			if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
				macEntry.vlan_id=0;
#else	// support ctag_if
			macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
			macEntry.static_entry=1;	//won't age out
			macEntry.arp_used=1;		//pointed by nexthop entry
			errorno=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if(rg_kernel.block_communication_between_internet_and_other)
			{
				ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
			}
			else
#endif
			//Add IVL lut entry (Do not move!)
			if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
			{
				ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
				l2Idx = ivlL2Idx;
			}

			DEBUG("### add l2tp l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],
				macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

			errorno=_rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;

			#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			// software configuration was done, now start to configure flow path6 and extra tag content buffer
			errorno = _rtk_rg_flow_setupL2TP(wan_intf_idx, l2Idx);
			if(errorno!=RT_ERR_RG_OK)goto ERR_OUT;
			#endif
		}

    }
ERR_OUT:
	//rg_unlock(&rg_kernel.wanL2TPAfterCalled);
	return (errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_pppoeDsliteInfoBeforeDial_set(int wan_intf_idx, rtk_rg_pppoeClientInfoBeforeDial_t *app_info)
{
	//Check parameter
	if(app_info == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPPoE_DSLITE)
		RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);

	//Save in global variable
	bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.username, 32);
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.username, app_info->username, 32);
	bzero(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.password, 32);
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.password, app_info->password, 32);
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.auth_type=app_info->auth_type;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.pppoe_proxy_enable=app_info->pppoe_proxy_enable;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.max_pppoe_proxy_num=app_info->max_pppoe_proxy_num;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.auto_reconnect=app_info->auto_reconnect;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.dial_on_demond=app_info->dial_on_demond;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.idle_timeout_secs=app_info->idle_timeout_secs;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.stauts=app_info->stauts;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.dialOnDemondCallBack=app_info->dialOnDemondCallBack;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial.idleTimeOutCallBack=app_info->idleTimeOutCallBack;

	//add pppoeDsliteBeforeDiagByHwCallBack callback to call spppdctl
	if(rg_db.systemGlobal.initParam.pppoeDsliteBeforeDialByHwCallBack != NULL)
	{
		rtk_rg_pppoeClientInfoBeforeDial_t before_dial;
		bzero(&before_dial,sizeof(rtk_rg_pppoeClientInfoBeforeDial_t));
		memcpy(&before_dial, &rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.before_dial, sizeof(rtk_rg_pppoeClientInfoBeforeDial_t));
		rg_db.systemGlobal.initParam.pppoeDsliteBeforeDialByHwCallBack(&before_dial,&wan_intf_idx);
	}

	return (RT_ERR_RG_OK);
}


rtk_rg_err_code_t rtk_rg_apollo_pppoeDsliteInfoAfterDial_set(int wan_intf_idx, rtk_rg_pppoeDsliteInfoAfterDial_t *pppoeDslite_info)
{
	rtk_l34_pppoe_entry_t pppoeEt;
	int ret,errorno,l2Idx;
	rtk_rg_macEntry_t macEntry;
	rtk_mac_t zeroMAC={{0}};
	rtk_ipv6_addr_t zeroIPv6={{0}};
	rtk_l34_dsliteMc_entry_t dsliteMcEntry;
#if defined(CONFIG_RG_RTL9602C_SERIES)
	int dsliteIdx;
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//ApolloPro always trap if not hit flow
#else
	rtk_rg_aclAndCf_reserved_intf_dslite_trap_t intf_dslite_trap_para;
#endif
	uint32 check_ivl_vid, ivlL2Idx;

	if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	dsliteIdx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.dslite_idx;
#endif

	if(pppoeDslite_info->sessionId==0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
	if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid == IF_INVALID_ENTRY ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan != 1 ||
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type != RTK_RG_PPPoE_DSLITE)
		RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	//if(!memcmp(pppoeDslite_info->dslite_hw_info.rtk_dslite.ipB4.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))RETURN_ERR(RT_ERR_RG_B4_IP_NOT_SET);
	//if(!memcmp(pppoeDslite_info->dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))RETURN_ERR(RT_ERR_RG_AFTR_IP_NOT_SET);
	if(pppoeDslite_info->dslite_hw_info.aftr_mac_auto_learn==0 && !memcmp(pppoeDslite_info->dslite_hw_info.aftr_mac_addr.octet,zeroMAC.octet,ETHER_ADDR_LEN) && memcmp(pppoeDslite_info->dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))
		RETURN_ERR(RT_ERR_RG_AFTR_MAC_NOT_SET);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(pppoeDslite_info->dslite_hw_info.rtk_dslite.tcOpt>=RTK_L34_DSLITE_TC_OPT_END)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(pppoeDslite_info->dslite_hw_info.rtk_dslite.hopLimit <=1)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if((dsliteIdx<0)||(!rg_db.dslite[dsliteIdx].rtk_dslite.valid))RETURN_ERR(RT_ERR_RG_DSLITE_UNINIT);
	if(rg_db.dslite[dsliteIdx].intfIdx!=wan_intf_idx)RETURN_ERR(RT_ERR_RG_DSLITE_UNMATCH);
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(pppoeDslite_info->dslite_hw_info.rtk_dslite.tcOpt>RTK_L34_DSLITE_TC_OPT_ASSIGN)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);// ApolloPro only support static tc value.
	if(pppoeDslite_info->dslite_hw_info.rtk_dslite.hopLimit <=1)RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#endif

	//20160617LUKE: check if mtu too large for dual header packet
	if(pppoeDslite_info->dslite_hw_info.static_info.mtu>MAX_PPPOEDSLITE_MTU_SIZE)
		WARNING("Caution! MTU too large may cause outer IPv6 header fragmentation.");
	if((pppoeDslite_info->dslite_hw_info.static_info.ip_network_mask>0 && pppoeDslite_info->dslite_hw_info.static_info.ip_network_mask!=0xffffffff) || (pppoeDslite_info->dslite_hw_info.static_info.ipv6_mask_length>0 && pppoeDslite_info->dslite_hw_info.static_info.ipv6_mask_length!=128))
		WARNING("PPPoE WAN SUBNET WARNING , point-to-point connection should mask all (v4mask=255.255.255.255 v6mask=128)");

	//Check if we are reentried
	//rg_lock(&rg_kernel.wanPPPOEDSLITEAfterCalled);

	//store aftr in global variable
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipB4.ipv6_addr, pppoeDslite_info->dslite_hw_info.rtk_dslite.ipB4.ipv6_addr, IPV6_ADDR_LEN);
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr, pppoeDslite_info->dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr, IPV6_ADDR_LEN);
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.aftr_mac_auto_learn=pppoeDslite_info->dslite_hw_info.aftr_mac_auto_learn;
	memcpy(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.aftr_mac_addr.octet,pppoeDslite_info->dslite_hw_info.aftr_mac_addr.octet,ETHER_ADDR_LEN);
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.hopLimit=pppoeDslite_info->dslite_hw_info.rtk_dslite.hopLimit&0xff;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.flowLabel=pppoeDslite_info->dslite_hw_info.rtk_dslite.flowLabel&0xfffff;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.tcOpt=pppoeDslite_info->dslite_hw_info.rtk_dslite.tcOpt;
	rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.tc=pppoeDslite_info->dslite_hw_info.rtk_dslite.tc&0xff;
#endif

	errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &pppoeDslite_info->dslite_hw_info.static_info);
	if(errorno!=RT_ERR_RG_OK)
		RETURN_ERR(errorno);
	if(pppoeDslite_info->sessionId != 0)
	{
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.sessionId=pppoeDslite_info->sessionId;

		//Set up PPPoE table and next hop table for this interface
		errorno=RT_ERR_RG_PPPOE_SET_FAIL;
		bzero(&pppoeEt, sizeof(rtk_l34_pppoe_entry_t));
		pppoeEt.sessionID=pppoeDslite_info->sessionId;
		ret = RTK_L34_PPPOETABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx, &pppoeEt);
		if(ret!=RT_ERR_OK)goto RET_PPPOE_ERR;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		// flow based: pppoe session id was saved in netif table
		ret = _rtk_rg_netifPPPoESession_set(wan_intf_idx, FB_NETIFPPPOE_ACT_ADD, pppoeEt.sessionID);
		if(ret!=RT_ERR_OK)goto RET_PPPOE_ERR;
#endif
	}
	else
	{
		//Clear PPPoE table and next hop table for this interface
		errorno=RT_ERR_RG_PPPOE_SET_FAIL;
		bzero(&pppoeEt, sizeof(rtk_l34_pppoe_entry_t));
		pppoeEt.sessionID=0;
		ret = RTK_L34_PPPOETABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx, &pppoeEt);
		if(ret!=RT_ERR_OK)goto RET_PPPOE_ERR;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		// flow based: pppoe session id was saved in netif table
		ret = _rtk_rg_netifPPPoESession_set(wan_intf_idx, FB_NETIFPPPOE_ACT_ADD, pppoeEt.sessionID);
		if(ret!=RT_ERR_OK)goto RET_PPPOE_ERR;
#endif
	}

	if(memcmp(pppoeDslite_info->dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr,zeroIPv6.ipv6_addr,IPV6_ADDR_LEN))
	{
		//Add gateway mac and Default route
		bzero(&macEntry,sizeof(rtk_rg_macEntry_t));
		memcpy(macEntry.mac.octet,pppoeDslite_info->dslite_hw_info.aftr_mac_addr.octet,ETHER_ADDR_LEN);
		//set SVL for lanIntf, patched in 20121203
		//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
		if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
		{
			macEntry.port_idx=RTK_RG_EXT_PORT0;
			macEntry.wlan_device_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wirelessWan;
		}
		else
		{
			macEntry.port_idx=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
			macEntry.wlan_device_idx=FAIL;
		}
		//20160428LUKE: transform from RGMII to PON
#if defined(CONFIG_RG_RTL9600_SERIES)
		if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && (rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx)==RTK_RG_PORT_PON){
			DEBUG("Special change WAN_PORT from PON to RGMII.");
			macEntry.port_idx=RTK_RG_PORT_RGMII;
		}
#endif
		//set mac's vlanid by egress tagif setting
		macEntry.vlan_id=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
		check_ivl_vid = macEntry.vlan_id;

		//Add SVL lut entry first
		macEntry.isIVL=0;
		macEntry.fid=rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
		//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
		if(!rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
			macEntry.vlan_id=0;
#else	// support ctag_if
		macEntry.ctag_if=(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)?1:0;
#endif
		macEntry.static_entry=1;	//won't age out
		macEntry.arp_used=1;		//pointed by nexthop entry
		errorno=(pf.rtk_rg_macEntry_add)(&macEntry,&l2Idx);
		if(errorno!=RT_ERR_RG_OK)goto RET_PPPOE_ERR;

#if defined(CONFIG_RG_RTL9602C_SERIES)
		if(rg_kernel.block_communication_between_internet_and_other)
		{
			ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx), RT_ERR_RG_OK);
		}
		else
#endif
		//Add IVL lut entry (Do not move!)
		if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
		{
			ASSERT_EQ(_rtk_rg_ivlMacEntry_add(l2Idx, check_ivl_vid, macEntry.port_idx, macEntry.wlan_device_idx, &ivlL2Idx), RT_ERR_RG_OK);
			l2Idx = ivlL2Idx;
		}

		DEBUG("### add AFTR l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x ###\n",l2Idx,macEntry.mac.octet[0],macEntry.mac.octet[1],
			macEntry.mac.octet[2],macEntry.mac.octet[3],macEntry.mac.octet[4],macEntry.mac.octet[5]);

		errorno=_rtk_rg_internal_GWMACSetup_stage2(wan_intf_idx, l2Idx);
		if(errorno!=RT_ERR_RG_OK)goto RET_PPPOE_ERR;

		//add a dsliteMc entry hit all dsliteMc packet , remove dsliteMc ipv6 header
		bzero(&dsliteMcEntry,sizeof(dsliteMcEntry));
		RTK_L34_DSLITEMULTICAST_SET(&dsliteMcEntry);

#if defined(CONFIG_RG_RTL9602C_SERIES)
		pppoeDslite_info->dslite_hw_info.rtk_dslite.index=dsliteIdx;
		pppoeDslite_info->dslite_hw_info.rtk_dslite.valid=1;
		ASSERT_EQ(RTK_L34_DSLITEINFTABLE_SET(&pppoeDslite_info->dslite_hw_info.rtk_dslite),RT_ERR_OK);
#elif defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//ApolloPro always trap if not hit flow
		// N/A

		// software configuration was done, now start to configure flow path6 and extra tag content buffer
		errorno = _rtk_rg_flow_setupDSLite(wan_intf_idx, l2Idx, TRUE);
		if(errorno!=RT_ERR_RG_OK)goto RET_PPPOE_ERR;
#else
		//enable reserve ACL trap
		if(wan_intf_idx < MAX_NETIF_HW_TABLE_SIZE)
		{
			memcpy(intf_dslite_trap_para.ipv6_dip.ipv6_addr, pppoeDslite_info->dslite_hw_info.rtk_dslite.ipB4.ipv6_addr, IPV6_ADDR_LEN);
			memcpy(intf_dslite_trap_para.smac.octet, pppoeDslite_info->dslite_hw_info.aftr_mac_addr.octet, ETHER_ADDR_LEN);
		   	_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_INTF0_DSLITE_TRAP+wan_intf_idx,&intf_dslite_trap_para);
		}
#endif
	}
	else
	{
		return _rtk_rg_dsliteInfo_release(wan_intf_idx, &pppoeDslite_info->dslite_hw_info);
	}

	errorno=RT_ERR_RG_OK;
	goto RET_SUCCESS;

RET_PPPOE_ERR:
	//Delete the pppoe etnry
	bzero(&pppoeEt, sizeof(rtk_l34_pppoe_entry_t));
	RTK_L34_PPPOETABLE_SET(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.pppoe_idx, &pppoeEt);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_netifPPPoESession_set(wan_intf_idx, FB_NETIFPPPOE_ACT_KEEP, 0);
#endif

RET_SUCCESS:
	//rg_unlock(&rg_kernel.wanPPPOEDSLITEAfterCalled);
	RETURN_ERR(errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_vxlanClientInfo_set(int wan_intf_idx, rtk_rg_vxlanClientInfoAfterDial_t *vxlanClient_info)
{
	int errorno;
	rtk_mac_t zeroMAC={{0}};
	rtk_rg_ipStaticInfo_t hw_info;

	//Check parameter
	if(vxlanClient_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
    if(wan_intf_idx<0 || wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//Call after rtk_rg_wanInterface_add, so check if we had already add interface
	if(!(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].valid!=IF_INVALID_ENTRY
		&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.is_wan==1
		&& rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN))
		RETURN_ERR(RT_ERR_RG_ENTRY_NOT_EXIST);
	if(vxlanClient_info->vxlan_mode > VXLAN_MODE_L3)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(vxlanClient_info->vxlan_remote_ipv4_addr==0)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(!memcmp(vxlanClient_info->vxlan_remote_ipv4_gatewayMac.octet, zeroMAC.octet, ETHER_ADDR_LEN))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(vxlanClient_info->vxlan_network_identifier>0xffffff) // VNI only has 24 bits
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(vxlanClient_info->vxlan_baseIntf_idx>=MAX_NETIF_SW_TABLE_SIZE)
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//VXLAN wan only can be based on static/dhcp/pppoe wan
	if(!(rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].valid!=IF_INVALID_ENTRY
		&& rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.is_wan==1
		&& (rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_STATIC
			|| rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DHCP
			|| rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)))
        RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	
	if(vxlanClient_info->vxlan_mode==VXLAN_MODE_L2)
	{	
		//L2 vxlan need not to set mtu
		//if(vxlanClient_info->hw_info.mtu==0)
			//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		errorno = RT_ERR_RG_OK;
	}
	else // VXLAN_MODE_L3
	{
		if(vxlanClient_info->hw_info.ipv4_default_gateway_on)
			RETURN_ERR(RT_ERR_RG_DRIVER_NOT_SUPPORT);
		//Not support gw mac auto learn for vxlan
		if(vxlanClient_info->hw_info.gw_mac_auto_learn_for_ipv4 || (vxlanClient_info->hw_info.gw_mac_auto_learn_for_ipv4==0 && !memcmp(vxlanClient_info->hw_info.gateway_mac_addr_for_ipv4.octet, zeroMAC.octet, ETHER_ADDR_LEN)))
			RETURN_ERR(RT_ERR_RG_VXLAN_MAC_NOT_SET);
		
		memcpy(&hw_info, &vxlanClient_info->hw_info, sizeof(rtk_rg_ipStaticInfo_t));
		if(vxlanClient_info->hw_info.gw_mac_auto_learn_for_ipv4)
			hw_info.gateway_ipv4_addr=0;
		errorno = _rtk_rg_internal_wanSet(wan_intf_idx, &hw_info);
	    if(errorno==RT_ERR_RG_OK)
	    {			
			if(vxlanClient_info->hw_info.gw_mac_auto_learn_for_ipv4)
			{
				//1TODO: Not support gw mac auto learn for vxlan
			}
	    }
	}
	if(errorno==RT_ERR_RG_OK)
	{
		//check whether that vxlan_remote_ipv4_gateway_mac is changed or not
		if(memcmp(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.after_dial.vxlan_remote_ipv4_gatewayMac.octet, vxlanClient_info->vxlan_remote_ipv4_gatewayMac.octet, ETHER_ADDR_LEN)
			&& (0<=rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx && rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx<MAX_LUT_SW_TABLE_SIZE))
		{
			if(rg_db.lut[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx].valid && rg_db.lut[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx].vxlanStaticRefCnt>0)
				rg_db.lut[rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx].vxlanStaticRefCnt--;
			rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx = FAIL;
		}		
		if(rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx==FAIL)
		{
			int l2Idx;
			if((l2Idx = _rtk_rg_macLookup(vxlanClient_info->vxlan_remote_ipv4_gatewayMac.octet, rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id, FALSE))!=RG_RET_LOOKUPIDX_NOT_FOUND)
			{
				rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx = l2Idx;
				rg_db.lut[l2Idx].vxlanStaticRefCnt++;
			}
			else
			{
				rtk_rg_macEntry_t macEntry;
				memset(&macEntry, 0, sizeof(rtk_rg_macEntry_t));
				memcpy(macEntry.mac.octet, vxlanClient_info->vxlan_remote_ipv4_gatewayMac.octet, ETHER_ADDR_LEN);
				//20150527LUKE: for WWAN we should add remote gateway mac at ext-port0
				if(rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wirelessWan!=RG_WWAN_WIRED)
				{
					macEntry.port_idx = RTK_RG_EXT_PORT0;
					macEntry.wlan_device_idx = rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wirelessWan;
				}
				else
				{
					macEntry.port_idx = rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
					macEntry.wlan_device_idx = FAIL;
				}
				macEntry.vlan_id = rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
				macEntry.isIVL = (rg_db.vlan[macEntry.vlan_id].fidMode==VLAN_FID_IVL) ? 1 : 0;
				macEntry.fid = rg_db.vlan[macEntry.vlan_id].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
				//Because Forced_DMAC2CVID is turn on, the LUT's VLANID should enter zero if untag!!
				if(!rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on)
					macEntry.vlan_id = 0;
#else	// support ctag_if
				macEntry.ctag_if = (rg_db.systemGlobal.interfaceInfo[vxlanClient_info->vxlan_baseIntf_idx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_tag_on) ? 1 : 0;
#endif			
				errorno = (pf.rtk_rg_macEntry_add)(&macEntry, &l2Idx);
				if(errorno!=RT_ERR_RG_OK)
				{
					WARNING("Fail to add lut of vxlan_remote_ipv4_gateway_mac=%pM", macEntry.mac.octet);
					goto ERR_OUT;
				}
				rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx = l2Idx;
				rg_db.lut[l2Idx].vxlanStaticRefCnt++;
			}
		}
		//store info of vxlan
		memcpy(&rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.after_dial, vxlanClient_info, sizeof(rtk_rg_vxlanClientInfoAfterDial_t));
		rg_db.systemGlobal.interfaceInfo[wan_intf_idx].storedInfo.wan_intf.vxlan_info.ipv4_header_identifier = 0;
	}
ERR_OUT:	
	return (errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_svlanTpid_set(uint32 svlan_tag_id){
	assert_ok(RTK_SVLAN_TPIDENTRY_SET(0, svlan_tag_id));
	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_svlanTpid_get(uint32 *pSvlanTagId){
	if(pSvlanTagId == NULL) RETURN_ERR(RT_ERR_RG_NULL_POINTER);
#if defined(CONFIG_RG_G3_SERIES)
	// slan related rtk api is not supported
	*pSvlanTagId=rg_db.systemGlobal.tpid;
#else

	assert_ok(rtk_svlan_tpidEntry_get(0, pSvlanTagId));
	if(*pSvlanTagId!=rg_db.systemGlobal.tpid)WARNING("Svlan TPID is different between software and hardware. Please check if RG APIs is mixed with RTK APIs!");
#endif
	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_svlanServicePort_set(rtk_port_t port, rtk_enable_t enable)
{
	//DEBUG("\ndebug: rtk_rg_apollo_svlanServicePort_set port=0x%x enable=%d\n", port, enable);
	if(RG_INVALID_PORT(port)) RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	assert_ok(RTK_SVLAN_SERVICEPORT_SET(port, enable));
	if (rg_db.systemGlobal.service_pmsk.portmask)
		rg_kernel.stag_enable=RTK_RG_ENABLED;
	else
		rg_kernel.stag_enable=RTK_RG_DISABLED;
	_rtk_rg_default_svlan_manipulate();

	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_svlanServicePort_get(rtk_port_t port, rtk_enable_t *pEnable)
{
	if(pEnable==NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(RG_INVALID_PORT(port)) RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
#if defined(CONFIG_RG_G3_SERIES)
	// slan related rtk api is not supported
	*pEnable = rg_kernel.stag_enable;
#else
	assert_ok(RTK_SVLAN_SERVICEPORT_GET(port, pEnable));
	if((*pEnable==ENABLED && ((rg_db.systemGlobal.service_pmsk.portmask&(0x1<<port))==0))||
		(*pEnable==DISABLED && (rg_db.systemGlobal.service_pmsk.portmask&(0x1<<port))))
		WARNING("Svlan service port is different between software and hardware. Please check if RG APIs is mixed with RTK APIs!");
#endif
	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_stpBlockingPortmask_set(rtk_rg_portmask_t portMask)
{
	rtk_rg_port_isolation_t isolation_entry;
	int i;
	rg_db.systemGlobal.stpBlockingPortmask.portmask = (portMask.portmask & RTK_RG_ALL_MAC_PORTMASK);	//CPU, LAN and WAN port
	//printk("\nrtk_rg_apollo_stpBlockingPortmask_set Mask=0x%x\n",Mask);


	if(rg_db.systemGlobal.stpBlockingPortmask.portmask)
	{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_STPBLOCKING);
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_STPBLOCKING,NULL);
		if(rg_db.systemGlobal.storedInfo.valid == 0){
			rg_db.systemGlobal.storedInfo.mask.portmask = rg_db.systemGlobal.stpBlockingPortmask.portmask;
			for(i=0;i<=RTK_RG_PORT_LASTCPU;i++){
				if(RG_INVALID_PORT(i)) continue;
				rg_db.systemGlobal.storedInfo.portmask[i].portmask = rg_db.systemGlobal.portIsolation[i].portmask;
				isolation_entry.port = i;
				isolation_entry.portmask.portmask =  ((~portMask.portmask) & rg_db.systemGlobal.portIsolation[i].portmask);
				rtk_rg_apollo_portIsolation_set(isolation_entry);
			}
			rg_db.systemGlobal.storedInfo.valid = 1;
		}
	}
	else	//portmask is zero
	{
		_rtk_rg_aclAndCfReservedRuleDel(RTK_RG_ACLANDCF_RESERVED_STPBLOCKING);
		if(rg_db.systemGlobal.storedInfo.valid == 1){
			rg_db.systemGlobal.storedInfo.valid = 0;
			for(i=0;i<=RTK_RG_PORT_LASTCPU;i++){
					if(RG_INVALID_PORT(i)) continue;
					isolation_entry.port = i;
					isolation_entry.portmask.portmask = rg_db.systemGlobal.storedInfo.portmask[i].portmask;
					rtk_rg_apollo_portIsolation_set(isolation_entry);
			}
		}
	}
	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_stpBlockingPortmask_get(rtk_rg_portmask_t *pportMask)
{
	if(pportMask==NULL)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	*pportMask = rg_db.systemGlobal.stpBlockingPortmask;
	//printk("\nrtk_rg_apollo_stpBlockingPortmask_get Mask=0x%x\n",*pMask);
	return (RT_ERR_RG_OK);
}

//VLAN function
rtk_rg_err_code_t rtk_rg_apollo_cvlan_add(rtk_rg_cvlan_info_t *cvlan_info)
{
	int i,ret,errorno,VLAN_USED_BY_INTERFACE=0;
	rtk_vlan_t vlanID;
	rtk_fidMode_t fidMode;
	rtk_portmask_t mac_pmask,ext_pmask,untag_pmask;

	//Check parameter
	if(cvlan_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(rg_db.systemGlobal.initParam.macBasedTagDecision && cvlan_info->isIVL)		//IVL can not be set when DMAC2CVID is trun on
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(cvlan_info->isIVL)
	{
		if(cvlan_info->vlanId<0 || cvlan_info->vlanId>=MAX_VLAN_HW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}
	else
	{
		if(cvlan_info->vlanId<0 || cvlan_info->vlanId>=MAX_VLAN_SW_TABLE_SIZE)
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	}
	if(cvlan_info->vlan_based_pri_enable==RTK_RG_ENABLED && (cvlan_info->vlan_based_pri<0 || cvlan_info->vlan_based_pri>7))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//Check if VLAN init
    if(rg_db.systemGlobal.vlanInit==0)
        RETURN_ERR(RT_ERR_RG_NOT_INIT);

	if(RG_INVALID_PORTMASK(cvlan_info->memberPortMask.portmask))
		WARNING("CVLAN port_mask(0x%x) is not valid", (cvlan_info->memberPortMask.portmask));
	if(RG_INVALID_MAC_PORTMASK(cvlan_info->untagPortMask.portmask))
		WARNING("CVLAN untag_mask(0x%x) is not valid",(cvlan_info->untagPortMask.portmask));
#ifdef CONFIG_MASTER_WLAN0_ENABLE
#ifdef CONFIG_DUALBAND_CONCURRENT
	if(cvlan_info->wlan0DevMask>>WLAN_DEVICE_NUM)WARNING("CVLAN wlan0_mask(%x) shoud not bigger than %x",cvlan_info->wlan0DevMask,(0x1<<WLAN_DEVICE_NUM)-1);
	if(cvlan_info->wlan0UntagMask>>WLAN_DEVICE_NUM)WARNING("CVLAN wlan0_untag_mask(%x) shoud not bigger than %x",cvlan_info->wlan0UntagMask,(0x1<<WLAN_DEVICE_NUM)-1);
#else
	if((MAX_WLAN_DEVICE_NUM<(sizeof(cvlan_info->wlan0DevMask)*8))
		&& (cvlan_info->wlan0DevMask>>MAX_WLAN_DEVICE_NUM))
		WARNING("CVLAN wlan0_mask(%x) shoud not bigger than %x",cvlan_info->wlan0DevMask,((uint64)0x1<<MAX_WLAN_DEVICE_NUM)-1);
	if((MAX_WLAN_DEVICE_NUM<(sizeof(cvlan_info->wlan0UntagMask)*8))
		&& (cvlan_info->wlan0UntagMask>>MAX_WLAN_DEVICE_NUM))
		WARNING("CVLAN wlan0_untag_mask(%x) shoud not bigger than %x",cvlan_info->wlan0UntagMask,((uint64)0x1<<MAX_WLAN_DEVICE_NUM)-1);
#endif
	//20160524LUKE: check wlan-device existence
	//_rtk_rg_check_wlan_device_exist_or_not();
#endif

	vlanID=cvlan_info->vlanId;

#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (cvlan_info->memberPortMask.portmask & (1<<RTK_RG_PORT_PON))){
		DEBUG("patch for pppoeGponSmallbandwithControl,so add RGMII to memberPortMask.");
		cvlan_info->memberPortMask.portmask |= (1<<RTK_RG_PORT_RGMII);
	}
#endif

	//Check the VLAN ID, it can not be used in interface setting or vlan-binding
	//20150615LUKE: for more flexible usage, CVLAN add can forced override interface's VLAN setting. MUST BE CAREFULLY WHEN USING!!
	for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		if(vlanID==rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id){
			VLAN_USED_BY_INTERFACE=1;break;}//RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_INTERFACE);
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		if(vlanID==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id){
			VLAN_USED_BY_INTERFACE=rg_db.systemGlobal.wanIntfGroup[i].index;
			//change original member here
			if(rg_db.systemGlobal.wanVlanMemAppend[VLAN_USED_BY_INTERFACE].portmask)
				_rtk_rg_portmask_translator(cvlan_info->memberPortMask,&rg_db.systemGlobal.wanVlanMemAppend_origMem[VLAN_USED_BY_INTERFACE],&rg_db.systemGlobal.wanVlanMemAppend_origExt[VLAN_USED_BY_INTERFACE]);
		}//RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_INTERFACE);
	if((rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].valid && vlanID == rg_db.systemGlobal.initParam.fwdVLAN_CPU) ||
#if !defined(CONFIG_RG_RTL9600_SERIES)
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN].valid && vlanID == rg_db.systemGlobal.initParam.fwdVLAN_CPU_SVLAN) ||
#endif
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block].valid && vlanID == rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block) ||
		(rg_db.systemGlobal.initParam.macBasedTagDecision==1 && (vlanID == rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET /*||
		(vlanID >= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		vlanID <= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET)*/)))
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);
	if(rg_db.vlan[vlanID].valid)
	{
		if(rg_db.vlan[vlanID].addedAsCustomerVLAN || VLAN_USED_BY_INTERFACE)		//created before
			DEBUG("vlanID[%d] is %s..",vlanID,VLAN_USED_BY_INTERFACE?"used by intf":"exist");//RETURN_ERR(RT_ERR_RG_CVLAN_CREATED);
		//else
			//RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_VLANBINDING);			//used in vlan-binding
	}

	//Transfer RG portmask to RTK portmask
	_rtk_rg_portmask_translator(cvlan_info->memberPortMask,&mac_pmask,&ext_pmask);
	memset(&untag_pmask,0,sizeof(rtk_portmask_t));
	untag_pmask.bits[0]|=cvlan_info->untagPortMask.portmask;

	//20160524LUKE: for multicast routing packet will use ingress's VLAN untag set, therefore set all none-member port as untag!!
	//20200514LUKE: change RTK_RG_ALL_MAC_PORTMASK to RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU to prevent RT_ERR_RG_CPU_TAG_DIFF_BRIDGE_WAN.
	untag_pmask.bits[0]|=(~(mac_pmask.bits[0]))&RTK_RG_ALL_MAC_PORTMASK_WITHOUT_CPU;

	ret = RTK_VLAN_CREATE(vlanID);
	//if(ret==RT_ERR_VLAN_EXIST)
		//RETURN_ERR(RT_ERR_RG_CVLAN_RESERVED);		//the vlan had been created for system use
	//20150615LUKE: if we are changing existing VLAN, do not touch addedAsCustomerVLAN
	if(ret==RT_ERR_OK)
	{
		//Indicate that this vlan is created by customer vlan APIs
		rg_db.vlan[vlanID].addedAsCustomerVLAN=1;
	}
	else if(ret!=RT_ERR_VLAN_EXIST)
		RETURN_ERR(RT_ERR_RG_VLAN_SET_FAIL);

	//Setting VLAN
	errorno=RT_ERR_RG_VLAN_SET_FAIL;
	if(cvlan_info->isIVL)
		fidMode=VLAN_FID_IVL;
	else
		fidMode=VLAN_FID_SVL;

	ret = RTK_VLAN_FIDMODE_SET(vlanID, fidMode);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	ret = RTK_VLAN_FID_SET(vlanID, LAN_FID);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	ret = RTK_VLAN_PORT_SET(vlanID, &mac_pmask, &untag_pmask);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	ret = RTK_VLAN_EXTPORT_SET(vlanID, &ext_pmask);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

#ifdef CONFIG_MASTER_WLAN0_ENABLE
	//20160308LUKE: assign CVLAN's wlan0 devMask and untagMask for filter.
	rg_db.vlan[vlanID].wlan0DevMask=cvlan_info->wlan0DevMask;
	rg_db.vlan[vlanID].wlan0UntagMask=cvlan_info->wlan0UntagMask;

	//20160524LUKE: for multicast routing packet will use ingress's VLAN untag set, therefore set all none-member port as untag!!
	rg_db.vlan[vlanID].wlan0UntagMask|=(~(rg_db.vlan[vlanID].wlan0DevMask))&(0xffffffff>>(32-MAX_WLAN_DEVICE_NUM));

#endif

	//Setting up priority, if enable
	if(cvlan_info->vlan_based_pri_enable==RTK_RG_ENABLED)
	{
#ifdef CONFIG_DUALBAND_CONCURRENT
		if(cvlan_info->vlan_based_pri==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI)
		{
			errorno=RT_ERR_RG_VLAN_PRI_CONFLICT_WIFI;
			goto RET_VLAN_ERR;
		}
#endif

#if defined(CONFIG_RG_RTL9602C_SERIES)
		WARNING("[FIXME]for 9602C, we can't set priority for VLAN directly...");
		//errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
		//goto RET_VLAN_ERR;
#else

		ret = RTK_VLAN_PRIORITYENABLE_SET(vlanID,ENABLED);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
		ret = RTK_VLAN_PRIORITY_SET(vlanID,cvlan_info->vlan_based_pri);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
#endif
	}
	else
	{
#if defined(CONFIG_RG_RTL9602C_SERIES)
#else
		ret = RTK_VLAN_PRIORITYENABLE_SET(vlanID,DISABLED);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
#endif
	}
#if defined(CONFIG_RG_G3_SERIES)
	_rtk_rg_reflash_lut_table();
#endif

	return (RT_ERR_RG_OK);

RET_VLAN_ERR:
	//Delete the customer VLAN created
    RTK_VLAN_DESTROY(vlanID);

    RETURN_ERR(errorno);
}

rtk_rg_err_code_t rtk_rg_apollo_cvlan_del(int cvlan_id)
{
	if(cvlan_id<0||cvlan_id>=MAX_VLAN_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//Check if the VLAN ID is created by customer vlan API before
	if(rg_db.vlan[cvlan_id].addedAsCustomerVLAN==0)
		RETURN_ERR(RT_ERR_RG_VLAN_NOT_CREATED_BY_CVLAN);

	//Delete the customer VLAN created
    RTK_VLAN_DESTROY(cvlan_id);

#if defined(CONFIG_RG_G3_SERIES)
	_rtk_rg_reflash_lut_table();
#endif

	return (RT_ERR_RG_OK);
}

rtk_rg_err_code_t rtk_rg_apollo_cvlan_get(rtk_rg_cvlan_info_t *cvlan_info)
{
	rtk_vlan_t vlanID;

	//Check parameter
	if(cvlan_info == NULL)
        RETURN_ERR(RT_ERR_RG_NULL_POINTER);

	//Check if VLAN init
    if(rg_db.systemGlobal.vlanInit==0)
        RETURN_ERR(RT_ERR_RG_NOT_INIT);

	vlanID=cvlan_info->vlanId;
	//Check if the vlanID valid
	if(vlanID>=MAX_VLAN_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	else if(!rg_db.vlan[vlanID].valid)	//invalid vid
		return (RT_ERR_RG_CVLAN_INVALID);

	cvlan_info->memberPortMask.portmask=rg_db.vlan[vlanID].MemberPortmask.bits[0];
	if(rg_db.vlan[vlanID].Ext_portmask.bits[0])
	{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		cvlan_info->memberPortMask.portmask|=1<<RTK_RG_PORT_CPU;
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
#else
#error
#endif
		cvlan_info->memberPortMask.portmask|=(rg_db.vlan[vlanID].Ext_portmask.bits[0]<<RTK_RG_EXT_BASED_PORT);
	}
	cvlan_info->untagPortMask.portmask=rg_db.vlan[vlanID].UntagPortmask.bits[0];
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	cvlan_info->wlan0DevMask=rg_db.vlan[vlanID].wlan0DevMask;
	cvlan_info->wlan0UntagMask=rg_db.vlan[vlanID].wlan0UntagMask;
#endif
	cvlan_info->isIVL=(rg_db.vlan[vlanID].fidMode==VLAN_FID_IVL?1:0);
	cvlan_info->vlan_based_pri_enable=rg_db.vlan[vlanID].priorityEn;
	cvlan_info->vlan_based_pri=rg_db.vlan[vlanID].priority;
	cvlan_info->addedAsCustomerVLAN=rg_db.vlan[vlanID].addedAsCustomerVLAN;

    return (RT_ERR_RG_OK);
}

//VLAN Binding
int _rtk_rg_vbdLinkListAdd(rtk_rg_port_idx_t portIdx, int wanIdx, int vlanId)
{
	rtk_rg_vbind_linkList_t *pVbdEntry;

	//Check if we have not-used free list
	if(list_empty(&rg_db.vlanBindingFreeListHead))
	{
		DEBUG("all free VLan-bind list are allocated...");
		RETURN_ERR(RT_ERR_RG_FAILED);
	}

	//Get one from free list
	pVbdEntry=list_first_entry(&rg_db.vlanBindingFreeListHead, rtk_rg_vbind_linkList_t, vbd_list);
	list_del_init(&pVbdEntry->vbd_list);

	//Setup information
	pVbdEntry->wanIdx=wanIdx;
	pVbdEntry->vlanId=vlanId;

	//Add to hash head list
	list_add(&pVbdEntry->vbd_list,&rg_db.vlanBindingListHead[portIdx]);

	return (RT_ERR_RG_OK);
}

int _rtk_rg_vbdLinkListDel(rtk_rg_port_idx_t portIdx, int wanIdx, int vlanId)
{
	rtk_rg_vbind_linkList_t *pVbdEntry,*pNextEntry;

	list_for_each_entry_safe(pVbdEntry,pNextEntry,&rg_db.vlanBindingListHead[portIdx],vbd_list)
	{
		if(pVbdEntry->vlanId==vlanId && pVbdEntry->wanIdx==wanIdx)
		{
			//Delete from head list
			list_del_init(&pVbdEntry->vbd_list);

			//Add back to free list
			list_add(&pVbdEntry->vbd_list,&rg_db.vlanBindingFreeListHead);
		}
	}

	return (RT_ERR_RG_OK);
}


rtk_rg_err_code_t rtk_rg_apollo_vlanBinding_add(rtk_rg_vlanBinding_t *vlan_binding_info, int *vlan_binding_idx)
{
	int errorno=RT_ERR_RG_OK;
	int i,ret,bdIdx=0,vlan_exist=0,vlanID,intfIdx,bridge_wan_vlan=0;//,wantype_exist=0,nxpIdx=0;
	//unsigned int tmppmsk,tmpexpmsk;
	//rtk_l34_netif_entry_t intfEntry;
	rtk_binding_entry_t vbindEt;
	//rtk_classify_cfg_t cfEntry;
	rtk_portmask_t mbpmsk,etpmsk,untagPmsk;
	rtk_portmask_t port_mask,ext_port_mask;
	rtk_portmask_t wanPmsk;
	rtk_rg_table_vlan_t ori_vlanEntry,ori_wanVlanEntry;
	rtk_rg_bindingEntry_t cb_bindEt;
	rtk_rg_wanIntfConf_t *bindWanConf;
	//rtk_wanType_entry_t wantEt;
	//rtk_l34_nexthop_entry_t nxpEt;

	//Check parameter
	if(vlan_binding_info == NULL || vlan_binding_idx == NULL)
		RETURN_ERR(RT_ERR_RG_NULL_POINTER);
	if(RG_INVALID_PORT(vlan_binding_info->port_idx) || vlan_binding_info->port_idx>RTK_RG_EXT_PORT1)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	//20140423LUKE:at time, we just can't return VLAN-tagged packet to ext-port, therefore we prohibited such setting!
	if(RTK_RG_ALL_CPU_PORTMASK & (0x1<<vlan_binding_info->port_idx))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(rg_db.systemGlobal.lanIntfTotalNum==0)
		RETURN_ERR(RT_ERR_RG_LAN_NOT_EXIST);
	if(vlan_binding_info->wan_intf_idx<0 || vlan_binding_info->wan_intf_idx>=MAX_NETIF_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(rg_db.systemGlobal.interfaceInfo[vlan_binding_info->wan_intf_idx].valid==IF_INVALID_ENTRY || rg_db.systemGlobal.interfaceInfo[vlan_binding_info->wan_intf_idx].storedInfo.is_wan==0)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(vlan_binding_info->ingress_vid<0 || vlan_binding_info->ingress_vid>=MAX_VLAN_HW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(rg_db.systemGlobal.initParam.macBasedTagDecision==0) 	//binding is turn off
		RETURN_ERR(RT_ERR_RG_BIND_WITH_UNBIND_WAN);
	if(rg_db.systemGlobal.vlanBindTotalNum==MAX_BIND_SW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20170308LUKE: policy route may failed if there is binding rule exist.
		for(i=0;i<MAX_ACL_SW_ENTRY_SIZE;i++)
		{
			if(rg_db.systemGlobal.acl_SW_table_entry[i].valid==RTK_RG_ENABLED && rg_db.systemGlobal.acl_SW_table_entry[i].acl_filter.action_type==ACL_ACTION_TYPE_POLICY_ROUTE)
			{
				WARNING("Binidng could not coexist with Policy Route at this platform!");
				RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
			}
		}
#endif

	//Check if VLAN init
	if(rg_db.systemGlobal.vlanInit==0)
		RETURN_ERR(RT_ERR_RG_NOT_INIT);

	vlanID=vlan_binding_info->ingress_vid;

	if((rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_CPU].valid && vlanID == rg_db.systemGlobal.initParam.fwdVLAN_CPU) ||
		(rg_db.vlan[rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block].valid && vlanID == rg_db.systemGlobal.initParam.fwdVLAN_Proto_Block) ||
		vlanID == rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET ||
		(vlanID >= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER &&
		vlanID <= rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET))
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_SYSTEM);

	//Check if vlanID has been used in LAN, WAN or 1Q VLAN
	for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		if(vlanID==rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id)
			RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_INTERFACE);
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		if(vlan_binding_info->port_idx==(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_port_idx))
			RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
		/*if(vlanID==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			{
				WARNING("This VLAN used by Bridge-WAN!!");
			}
			else
				RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_INTERFACE);
		}*/
	}
	if(rg_db.vlan[vlanID].valid && rg_db.vlan[vlanID].addedAsCustomerVLAN)
		RETURN_ERR(RT_ERR_RG_VLAN_USED_BY_CVLAN);
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_kernel.wanDmac2cvidDisabled==0)
		WARNING("Binding conflict DMAC2CVID if multi-vlan host exist at WAN!");//RETURN_ERR(RT_ERR_RG_BINDING_DMAC2CVID_CONFLICT);
#endif

	intfIdx=vlan_binding_info->wan_intf_idx;
	bindWanConf=&rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf;
	//Turn port index to mask
	if(vlan_binding_info->port_idx <= RTK_RG_PORT_LASTCPU)	//MAC port
	{
		port_mask.bits[0]=0x1<<(vlan_binding_info->port_idx-RTK_RG_PORT0);
		ext_port_mask.bits[0]=0x0;
	}
	else		//EXT port
	{
		ext_port_mask.bits[0]=0x1<<(vlan_binding_info->port_idx-RTK_RG_EXT_PORT0);
		port_mask.bits[0]=0x0;
	}

	for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
	{
		//bzero(&vbindEt, sizeof(rtk_binding_entry_t));
		//ret = dal_apollomp_l34_bindingTable_get(i, &vbindEt); 	//FIXME:no RTK APIs
		//ret = rtk_l34_bindingTable_get(i, &vbindEt);
		//if(ret==RT_ERR_CHIP_NOT_SUPPORTED)RETURN_ERR(RT_ERR_RG_CHIP_NOT_SUPPORT);
		//if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_PORT_BIND_GET_FAIL);

		//we should not assign the same port binding and vlan with same port'
		//20140718LUKE: we need to support dynamic replace port binding when add WAN, so display WARNING instead return error.
		if((rg_db.bind[i].rtk_bind.portMask.bits[0]&port_mask.bits[0])||(rg_db.bind[i].rtk_bind.extPortMask.bits[0]&ext_port_mask.bits[0]))
		{
			if(rg_db.bind[i].rtk_bind.vidLan==0){
				WARNING("%sPortmask 0x%x is setup port-binding to WAN[%d], make sure this situation is correct!",ext_port_mask.bits[0]==0x0?"":"Ext",
				rg_db.bind[i].rtk_bind.portMask.bits[0],rg_db.nexthop[rg_db.wantype[rg_db.bind[i].rtk_bind.wanTypeIdx].rtk_wantype.nhIdx].rtk_nexthop.ifIdx);//RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
			}else if(rg_db.bind[i].rtk_bind.vidLan==vlanID){
				RETURN_ERR(RT_ERR_RG_ENTRY_EXIST);
			}
		}
	}

	//Have to call after rtk_rg_wanInterface_add, so check if we had already add interface and it's binding WAN
	/*bzero(&intfEntry, sizeof(rtk_l34_netif_entry_t));
	ret = rtk_l34_netifTable_get(intfIdx, &intfEntry);
	if(ret!=RT_ERR_OK || intfEntry.valid == 0 || */
	if(rg_db.systemGlobal.interfaceInfo[intfIdx].valid==IF_INVALID_ENTRY || rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan!=1)
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	//Patch for binding L2 bug
	//unnecessary here, since we had patched when WAN interface added.
	/*if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
	{
		intfEntry.mtu=1502;
		ret = RTK_L34_NETIFTABLE_SET(intfIdx, &intfEntry);
		if(ret!=RT_ERR_OK)RETURN_ERR(RT_ERR_RG_INTF_SET_FAIL);
	}
	*/

	//Set up VLAN
	memset(&ori_vlanEntry,0,sizeof(rtk_rg_table_vlan_t));

	errorno=RT_ERR_RG_VLAN_SET_FAIL;
	ret = RTK_VLAN_CREATE(vlanID);
	if(ret == RT_ERR_VLAN_EXIST)
	{
		//keep all information of original VLAN
		memcpy(&ori_vlanEntry, &rg_db.vlan[vlanID],sizeof(rtk_rg_table_vlan_t));

		vlan_exist=1;
	}
	else if(ret!=RT_ERR_OK)
		goto RET_VLAN_ERR;

	//Set up its member port, extension port set, and FID mode
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_kernel.block_communication_between_internet_and_other)
		ret = RTK_VLAN_FIDMODE_SET(vlanID, VLAN_FID_IVL);
	else
#endif
		ret = RTK_VLAN_FIDMODE_SET(vlanID, VLAN_FID_SVL);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	mbpmsk.bits[0]=port_mask.bits[0]|ori_vlanEntry.MemberPortmask.bits[0];
	mbpmsk.bits[0]|=RTK_RG_ALL_MAC_MASTER_CPU_PORTMASK;		//CPUport always on

	etpmsk.bits[0]=ori_vlanEntry.Ext_portmask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	etpmsk.bits[0]|=(ext_port_mask.bits[0]<<1); 	//vlan's extPmsk begin at CPU
	etpmsk.bits[0]|=0x1;							//CPUport always on
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
	etpmsk.bits[0]|=ext_port_mask.bits[0];
	//In order to be forward compatible, ext0 stands for all wifi device of master cpu, and ext1 stands for all wifi device of slave cpu.
	etpmsk.bits[0] &= ((0x1<<(RTK_RG_EXT_PORT0-RTK_RG_EXT_BASED_PORT)) | (0x1<<(RTK_RG_EXT_PORT1-RTK_RG_EXT_BASED_PORT)));
	if(etpmsk.bits[0] & (0x1<<(RTK_RG_EXT_PORT0-RTK_RG_EXT_BASED_PORT)))
		etpmsk.bits[0] |= RTK_RG_ALL_VLAN_MASTER_EXT_PORTMASK;
	if(etpmsk.bits[0] & (0x1<<(RTK_RG_EXT_PORT1-RTK_RG_EXT_BASED_PORT)))
		etpmsk.bits[0] |= RTK_RG_ALL_VLAN_SLAVE_EXT_PORTMASK;
#elif defined(CONFIG_RG_G3_SERIES)
	/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
	etpmsk.bits[0]|=ext_port_mask.bits[0];
#else
#error
#endif
	//20170612: set port of vlan binding to tag format
	untagPmsk.bits[0]=ori_vlanEntry.UntagPortmask.bits[0];
	if(vlan_binding_info->port_idx <= RTK_RG_PORT_LASTCPU)
		untagPmsk.bits[0]&=~(0x1<<vlan_binding_info->port_idx);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	else if(vlan_binding_info->port_idx == RTK_RG_EXT_PORT0)
		rg_db.vlan[vlanID].wlan0UntagMask&=~((0x1<<WLAN_DEVICE_NUM)-1);
#endif

	ret = RTK_VLAN_PORT_SET(vlanID, &mbpmsk, &untagPmsk);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	ret = RTK_VLAN_EXTPORT_SET(vlanID, &etpmsk);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	ret = RTK_VLAN_FID_SET(vlanID,LAN_FID);
	if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;

	if(bindWanConf->wan_type==RTK_RG_BRIDGE)
	{
		rtk_portmask_t _vlanExtPmsk;

		bridge_wan_vlan=bindWanConf->egress_vlan_id;
		_vlanExtPmsk.bits[0]=rg_db.vlan[bridge_wan_vlan].Ext_portmask.bits[0];
		memcpy(&ori_wanVlanEntry,&rg_db.vlan[bridge_wan_vlan],sizeof(rtk_rg_table_vlan_t));
		rg_db.vlan[bridge_wan_vlan].MemberPortmask.bits[0]|=port_mask.bits[0];
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		//rg_db.vlan[bridge_wan_vlan].Ext_portmask.bits[0]|=(ext_port_mask.bits[0]<<1);
		_vlanExtPmsk.bits[0]|=(ext_port_mask.bits[0]<<1);
#elif defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		/*Note!! For FB: bit'0 stands for ext0 not cpu port*/
		//rg_db.vlan[bridge_wan_vlan].Ext_portmask.bits[0]|=ext_port_mask.bits[0];
		_vlanExtPmsk.bits[0]|=ext_port_mask.bits[0];
#else
#error
#endif
		//add the binding port to WAN's VLAN member
		ret = RTK_VLAN_PORT_SET(bridge_wan_vlan, &rg_db.vlan[bridge_wan_vlan].MemberPortmask, &ori_wanVlanEntry.UntagPortmask); //don't touch untag set
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
		ret = RTK_VLAN_EXTPORT_SET(bridge_wan_vlan, &_vlanExtPmsk);
		if(ret!=RT_ERR_OK)goto RET_VLAN_ERR;
	}

	//Pick one binding entry that not occupied before
	for(i=0; i<MAX_BIND_SW_TABLE_SIZE; i++) 	//Port-vlan binding start from the top of Binding Table
	{
		//if(rg_db.systemGlobal.bindToIntf[i] == -1)
		if(rg_db.bind[i].valid == 0)
			break;
	}
	if(i==MAX_BIND_SW_TABLE_SIZE)goto RET_BINDING_ERR;

	bdIdx=i;	//Keep

	//rg_db.systemGlobal.bindToIntf[bdIdx]=intfIdx;
	//rg_db.systemGlobal.bindWithVLAN[bdIdx]=vlanID;		//save the vlan
	//RG_GLB_VLANBD_IDX[bdIdx]=i;

	//Add binding entry once a time
	errorno=RT_ERR_RG_PORT_BIND_SET_FAIL;
	bzero(&vbindEt, sizeof(rtk_binding_entry_t));
	vbindEt.vidLan=vlanID;
	vbindEt.wanTypeIdx=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.bind_wan_type_ipv4;
	vbindEt.bindProto=L34_BIND_PROTO_ALL;		//ALL protocol in L3, and L2
	vbindEt.portMask=port_mask;
	vbindEt.extPortMask=ext_port_mask;

	//ret = dal_apollomp_l34_bindingTable_set(i, &vbindEt); 	//FIXME:no RTK APIs
	ret = RTK_L34_BINDINGTABLE_SET(bdIdx, &vbindEt);
	if(ret==RT_ERR_CHIP_NOT_SUPPORTED)
	{
		errorno=RT_ERR_RG_CHIP_NOT_SUPPORT;
		goto RET_BINDING_ERR;
	}
	if(ret!=RT_ERR_OK)goto RET_BINDING_ERR;

	DEBUG("add binding(%d) vid=%d portMas=0x%x \n",bdIdx,rg_db.bind[bdIdx].rtk_bind.vidLan,rg_db.bind[bdIdx].rtk_bind.portMask.bits[0]);

	//20140807LUKE: add one more binding rule for v6 if needed
	errorno=_rtk_rg_updatingVlanBind(intfIdx,rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.bind_wan_type_ipv6);
	if(errorno!=RT_ERR_RG_OK)goto RET_BINDING_ERR;

	//20140725LUKE: update to WAN's vlan-binding-mask
	bindWanConf->vlan_binding_mask.portmask|=(0x1<<vlan_binding_info->port_idx);

	//Update non binding portmask, if portmask is zero, remove WAN port from fwdVLAN_BIND_INTERNET
	//otherwise add WAN port to fwdVLAN_BIND_INTERNET!
	//20160428LUKE: transform from RGMII to PON
	wanPmsk.bits[0]=0x1<<bindWanConf->wan_port_idx;
#if defined(CONFIG_RG_RTL9600_SERIES)
	if(rg_db.systemGlobal.pppoeGponSmallbandwithControl && (bindWanConf->wan_type&(RTK_RG_PPPoE||RTK_RG_PPPoE_DSLITE)) && bindWanConf->wan_port_idx==RTK_RG_PORT_PON){
		DEBUG("Special add RGMII to WAN_PORT_MASK.");
		wanPmsk.bits[0]|=0x1<<RTK_RG_PORT_RGMII;
	}
#endif
	_rtk_rg_updateNoneBindingPortmask(wanPmsk.bits[0]);

	//add to link-list for bindingRuleCheck
	_rtk_rg_vbdLinkListAdd(vlan_binding_info->port_idx,vlan_binding_info->wan_intf_idx,vlan_binding_info->ingress_vid);

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	//add vlan-bind for pure software netif
	if(	rg_db.systemGlobal.interfaceInfo[intfIdx].valid >IF_VALID_ENTRY)
	{
		rtk_rg_aclAndCf_reserved_vlan_bind_trap_t vlan_bind_trap;
		bzero(&vlan_bind_trap,sizeof(vlan_bind_trap));
		vlan_bind_trap.portmask=port_mask.bits[0];
		vlan_bind_trap.vid=vlanID;
		_rtk_rg_aclAndCfReservedRuleAdd(RTK_RG_ACLANDCF_RESERVED_VLANBIND0_TRAP+ bdIdx, &vlan_bind_trap);		//(n=0~31,  1-to-1 mapping binding table)
		WARNING("ReservedRuleAdd Vlan binding bdIdx=%d vid=%d pmask=%x",bdIdx,vlan_bind_trap.vid,vlan_bind_trap.portmask);
	}
#endif

#if CONFIG_ACL_EGRESS_WAN_INTF_TRANSFORM
	//20141224LUKE: since vlan-binding is modified, we should rearrange ACL which use the WAN interface as egress interface of the binding
	if(rg_db.systemGlobal.acl_SW_egress_intf_type_zero_num)
		ASSERT_EQ(_rtk_rg_acl_user_part_rearrange(),RT_ERR_RG_OK);
#endif

	// TODO:Call the initParam's bindingAddByHwCallBack
	if(rg_db.systemGlobal.initParam.bindingAddByHwCallBack != NULL)
	{
		cb_bindEt.type=BIND_TYPE_VLAN;
		cb_bindEt.vlan.vlan_bind_port_idx=vlan_binding_info->port_idx;
		cb_bindEt.vlan.vlan_bind_vlan_id=vlanID;
		cb_bindEt.wan_intf_idx=intfIdx;
		rg_db.systemGlobal.initParam.bindingAddByHwCallBack(&cb_bindEt);
	}

#if 0
	tmppmsk=port_mask.bits[0];
	tmpexpmsk=ext_port_mask.bits[0];

	//Add port-binding we have to set

	count=tmppmsk;
	RG_ONE_COUNT(count);
	for(j=0; j<count; j++)
	{
		errorno=RT_ERR_RG_ENTRY_FULL;
		for(i=0; i<32; i++) 	//Port-vlan binding start fro