/*
 * Copyright (C) 2012 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
*/



/*
 * Include Files
 */

#if defined(CONFIG_APOLLO_ROMEDRIVER)

//MOVE TO RTK_RG_DEFINE_H
//#define CONFIG_ROME_NAPT_SHORTCUT

#ifdef __KERNEL__

#include <linux/interrupt.h>
#include <linux/skbuff.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/timer.h>
#include <linux/delay.h>
#include <linux/proc_fs.h>
#include <linux/if_ether.h>
#include <linux/ip.h>
#include <linux/ipv6.h>
#include <linux/in.h>
#include <linux/if_vlan.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/smp.h>	//for IPI

#else
unsigned long int jiffies=0;
#endif





#ifdef CONFIG_APOLLO_MODEL

#include "utility.h"
#include "rtl_types.h"
#include <rtl_glue.h>
#include <rtl_utils.h>
//#include <re8686.h>
#include <time.h>		//for time in fragment queuing
#endif

#include <rtk_rg_fwdEngine.h>
#include <rtk_rg_cpuReason.h>
#include <common/error.h>
#include <rtk/init.h>
#include <rtk/l34.h>

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
#include <rtk/pbo.h>	//for swpbo
#endif

#include <rtk_rg_profile.h>
#include <rtk_rg_callback.h>	//for aclUDPencapMirrorLoopBackCallBack
//#ifdef CONFIG_RG_DEBUG
#include <rtk_rg_debug.h>
//#endif

/*siyuan add for alg function*/
#include <rtk_rg_ipsec.h>
#include <rtk_rg_sip.h>
#include <rtk_rg_ftp.h>
#include <rtk_rg_tftp.h>
#include <rtk_rg_fcc.h>
#include <rtk_rg_pptp.h>
#include <rtk_rg_alg_tool.h>

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#include <rtk_rg_apolloPro_internal.h>
#include <rtk_rg_apolloPro_liteRomeDriver.h>
#if defined(CONFIG_RG_G3_SERIES)
#include <rtk_rg_g3_internal.h>
#include <aal_l3_te_cb.h>
#include <aal_l3_te.h>
#include <aal_l2_tm.h>
#endif
#endif

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
int _rtk_rg_acl_egressIntfIdx_precheck(rtk_rg_pktHdr_t *pPktHdr);
#endif


#include <rtk_rg_igmpsnooping.h>
extern struct rtl_mCastTimerParameters rtl_mCastTimerParas;
extern struct rtl_multicastModule rtl_mCastModuleArray[MAX_MCAST_MODULE_NUM];
extern int32 rtl_compareMacAddr(uint8* macAddr1, uint8* macAddr2);
extern int32 rtl_compareIpv6Addr(uint32* ipv6Addr1, uint32* ipv6Addr2);
extern int32 rtl_checkMCastAddrMapping(uint32 ipVersion, uint32 *ipAddr, uint8* macAddr);

static void _rtk_rg_igmpPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr);
static void _rtk_rg_mospfPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr);
static void _rtk_rg_pimfPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr);
static void _rtk_rg_mldPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr);
#if defined(CONFIG_RG_G3_SERIES)
extern int drv_nic_register_rxhook(int portmask,int priority,p2rfunc_t rx);
extern int drv_nic_unregister_rxhook(int portmask,int priority,p2rfunc_t rx);
static uint32 l3te_voq_thrsh_profile_3_thh=CA_UINT32_INVALID;
static uint32 l3te_port_thrsh_profile_3_lth=CA_UINT32_INVALID;
#endif	// end CONFIG_RG_G3_SERIES

#if defined(CONFIG_CTC_AWIFI_KERNEL_JITUAN)
#if defined(CONFIG_RTK_L34_ENABLE)
extern int rtk_rg_apollo_naptConnection_info_lookup(unsigned int sip, unsigned short sport, unsigned int dip, unsigned short dport, int isTcp);
#endif

int wifidog_enable = 0;

// 0:ignore, bit0: LAN1, bit1:LAN2, bit2:LAN3, bit3:LAN4, bit4:WLAN0, bit5:WLAN0-VAP0, bit6:WLAN0-VAP1, bit7:WLAN0-VAP2, bit8:WLAN0-VAP3
unsigned int wifidog_interface = 0x20;

int _rtk_rg_wifdog_packet_check(struct sk_buff *skb);
#endif

#ifdef CONFIG_RG_WMUX_SUPPORT
#include <rtk_rg_wmux.h>
#endif

#ifdef __KERNEL__
/*cp is the NIC private data*/

//FIXME:since _re_dev_private defined in re8686.c, and we just need re_private's pointer which at the first field,
//we just define another similar structure here.
//20140502LUKE:we need txPortMask to decide which port for sending packet from protocol stack, so we copy all
//fields from _re_dev_private defined in re8686.c.
//20181022LUKE: since nic driver had moved re_dev_private to header file, we do not need this structure here.
/*struct _rg_re_dev_private {
	struct re_private* pCp;
	struct net_device_stats net_stats;
	unsigned char txPortMask;
};*/
#else
int model_nic_rx_skb (struct re_private *cp, struct sk_buff *skb, struct rx_info *pRxInfo)
{
	printf("FIXME %s %d\n",__FUNCTION__,__LINE__);
	return 0;
}

#endif

#ifdef CONFIG_DUALBAND_CONCURRENT
static rtk_mac_t master_ipc_macAddr;
//static rtk_mac_t slave_ipc_macAddr;
#endif

/*void _rtk_rg_fwdEngineTxDescSetting(void *pTxInfoPtr,void *ptxPtr,void *ptxMaskPtr)
{
	rtk_rg_txdesc_t *pTxInfo=(rtk_rg_txdesc_t *)pTxInfoPtr;
	rtk_rg_txdesc_t *ptx=(rtk_rg_txdesc_t *)ptxPtr;
	rtk_rg_txdesc_t *ptxMask=(rtk_rg_txdesc_t *)ptxMaskPtr;

	if(ptxMask == NULL)
	{
		pTxInfo->tx_ipcs = ptx->tx_ipcs;
		pTxInfo->tx_l4cs = ptx->tx_l4cs;
		pTxInfo->tx_cputag_ipcs = ptx->tx_cputag_ipcs;
		pTxInfo->tx_cputag_l4cs = ptx->tx_cputag_l4cs;
		pTxInfo->opts2.dw = ptx->opts2.dw;
		pTxInfo->opts3.dw = ptx->opts3.dw;
		pTxInfo->opts4.dw = ptx->opts4.dw;
	}
	else
	{
		if(ptxMask->opts1.dw)
		{
			pTxInfo->opts1.dw &= (~ptxMask->opts1.dw);
			pTxInfo->opts1.dw |= (ptx->opts1.dw & ptxMask->opts1.dw);
		}
		if(ptxMask->opts2.dw)
		{
			pTxInfo->opts2.dw &= (~ptxMask->opts2.dw);
			pTxInfo->opts2.dw |= (ptx->opts2.dw & ptxMask->opts2.dw);
		}
		if(ptxMask->opts3.dw)
		{
			pTxInfo->opts3.dw &= (~ptxMask->opts3.dw);
			pTxInfo->opts3.dw |= (ptx->opts3.dw & ptxMask->opts3.dw);
		}
		if(ptxMask->opts4.dw)
		{
			pTxInfo->opts4.dw &= (~ptxMask->opts4.dw);
			pTxInfo->opts4.dw |= (ptx->opts4.dw & ptxMask->opts4.dw);
		}
	}
}*/
rtk_rg_fwdEngineReturn_t _rtk_rg_dslite_multicast_unmatch_check(void)
{
	//Check unmatch action
	switch(rg_db.systemGlobal.dsliteControlSet[L34_DSLITE_CTRL_MC_PREFIX_UNMATCH]){
		case RTK_L34_DSLITE_UNMATCH_ACT_DROP:
			TRACE("[Drop] dslite multicast unmatch...DROP!");
			return RG_FWDENGINE_RET_DROP;
		case RTK_L34_DSLITE_UNMATCH_ACT_TRAP:
			TRACE("[To PS] dslite multicast unmatch...TRAP to PS !");
			return RG_FWDENGINE_RET_TO_PS;
		default:
			WARNING("[Drop] dslite multicast unmatch action error...%d",rg_db.systemGlobal.dsliteControlSet[L34_DSLITE_CTRL_MC_PREFIX_UNMATCH]);
			return RG_FWDENGINE_RET_DROP;
	}
}

rtk_rg_fwdEngineReturn_t _rtk_rg_dslite_multicast_v4Check(rtk_rg_pktHdr_t *pPktHdr)
{
	if(*((unsigned int *)(pPktHdr->pIpv6Dip+12))==htonl(pPktHdr->ipv4Dip) &&
		*((unsigned int *)(pPktHdr->pIpv6Sip+12))==htonl(pPktHdr->ipv4Sip))
	{
		TRACE("dsliteMc IPv4 address also match!!");
		return RG_FWDENGINE_RET_CONTINUE;
	}
	return _rtk_rg_dslite_multicast_unmatch_check();
}

rtk_rg_fwdEngineReturn_t _rtk_rg_dslite_multicast_v6Check(rtk_rg_pktHdr_t *pPktHdr)
{
	int i,j;

	for(i=0;i<MAX_DSLITEMC_SW_TABLE_SIZE;i++)
	{
		for(j=0;j<8;j++)
		{
			//DIPv6 (GIPv6) check
			if((rg_db.dsliteMc[i].rtk_dsliteMc.ipMPrefix64.ipv6_addr[j]&rg_db.dsliteMc[i].rtk_dsliteMc.ipMPrefix64Mask.ipv6_addr[j])!=(pPktHdr->pIpv6Dip[j] &rg_db.dsliteMc[i].rtk_dsliteMc.ipMPrefix64Mask.ipv6_addr[j])) break;
			//SIPv6 check
			if((rg_db.dsliteMc[i].rtk_dsliteMc.ipUPrefix64.ipv6_addr[j]&rg_db.dsliteMc[i].rtk_dsliteMc.ipUPrefix64Mask.ipv6_addr[j])!=(pPktHdr->pIpv6Sip[j] &rg_db.dsliteMc[i].rtk_dsliteMc.ipUPrefix64Mask.ipv6_addr[j])) break;
		}
		if(j==8){
			//Match!!
			TRACE("Match dsliteMc[%d]!",i);
			pPktHdr->tagif&=(~IPV6_TAGIF);
			pPktHdr->tagif|=DSLITEMC_INNER_TAGIF;
			return RG_FWDENGINE_RET_CONTINUE;
		}
	}
	return _rtk_rg_dslite_multicast_unmatch_check();
}

rtk_rg_fwdEngineReturn_t _rtk_rg_ICMPV6_neighbor_advertisement_solicitation_parsing(u8 *pData, int off, rtk_rg_pktHdr_t *pPktHdr)
{
	int tmpOff;
	pPktHdr->ICMPv6Flag=(ntohl(*(u32*)&pData[off+4])&0xf0000000)>>28;	//for solicitation packet, all zero(reserved) here.
	pPktHdr->pICMPv6TargetAddr=&pData[off+8];
	tmpOff=off+24;
	pPktHdr->pICMPv6TargetLinkAddr=NULL;
	pPktHdr->pICMPv6SourceLinkAddr=NULL;
ICMPV6_OPT:
	if(tmpOff+2<pPktHdr->skb->len){
		if(pData[tmpOff+1]==0x0){
			//for option length equals to zero, we should discard it.(rfc 4861)
			rtlglue_printf("[Drop] Discard at %s %d\n",__FUNCTION__,__LINE__);
			return RG_FWDENGINE_RET_DROP;
		}
		switch(pData[tmpOff]){
			case 0x1:	//Source link-layer Address
				pPktHdr->pICMPv6SourceLinkAddr=&pData[tmpOff+2];
				tmpOff+=pData[tmpOff+1]<<3;
				goto ICMPV6_OPT;
				break;
			case 0x2:	//Target link-layer Address
				pPktHdr->pICMPv6TargetLinkAddr=&pData[tmpOff+2];
				tmpOff+=pData[tmpOff+1]<<3;
				goto ICMPV6_OPT;
				break;
			default:
				break;
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_packetParser(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	u8 *pData=skb->data;
	u32 len=skb->len;

    int i,off=0,v6HeaderOff,tmpOff;
    u8 protocol=RG_IP_PROTO_RESERVED;
	rtk_rg_pptpMsgHead_t *pPPTPHdr;
	unsigned int pptpMagic;
	rtk_rg_wanIntfInfo_t *pWan_intf;
	uint32 ret = RG_FWDENGINE_RET_CONTINUE;

	if(len==0)
	{
		rtlglue_printf("[Drop] length of packet is zero at %s %d\n",__FUNCTION__,__LINE__);
		//20190703LUKE: add count here because we drop before parser.
		if(rg_db.systemGlobal.fwdStatistic)rg_db.systemGlobal.statistic.perPortCnt_zeroLen[pPktHdr->ingressPort]++;
		return RG_FWDENGINE_RET_DROP;
	}
	pPktHdr->skbLen = skb->len;
	
	//init
	pPktHdr->tagif=0;
	pPktHdr->egressTagif=0;
	pPktHdr->overMTU=0;
	pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;

	pPktHdr->pDmac=&pData[0]; //DA
#if defined(CONFIG_RG_RTL9602C_SERIES)
	memcpy(pPktHdr->dmac,pData,ETHER_ADDR_LEN); //apolloFE need the original Dmac in shortcut to determind MIB Interface.
#endif

	pPktHdr->pSmac=&pData[6]; //SA

	if(rg_db.systemGlobal.fwdStatistic)
	{
		int reason=pPktHdr->pRxDesc->rx_reason;
		int mass=(len>MASS_PACKET_SIZE)?0x4:0;
		if((pData[0]&0x1)!=0)
		{
			if(pData[0]==0xff){
				if(mass)
					rg_db.systemGlobal.statistic.perPortCnt_mass_broadcast[pPktHdr->ingressPort]++;
				else
					rg_db.systemGlobal.statistic.perPortCnt_broadcast[pPktHdr->ingressPort]++;
			}else{
				if(mass)
					rg_db.systemGlobal.statistic.perPortCnt_mass_multicast[pPktHdr->ingressPort]++;
				else
					rg_db.systemGlobal.statistic.perPortCnt_multicast[pPktHdr->ingressPort]++;
			}
		}
		else
		{
			if(mass)
				rg_db.systemGlobal.statistic.perPortCnt_mass_unicast[pPktHdr->ingressPort]++;
			else
				rg_db.systemGlobal.statistic.perPortCnt_unicast[pPktHdr->ingressPort]++;
		}

		if((reason<256)&&(pPktHdr->ingressPort<RTK_RG_EXT_PORT2))
			rg_db.systemGlobal.statistic.perPortCnt_Reason[reason][pPktHdr->ingressPort]++;

	}

    off=12;

/*
	In order to allow Ethernet II and IEEE 802.3 framing to be used on the same Ethernet segment, a unifying standard,
	IEEE 802.3x-1997, was introduced that required that EtherType values be greater than or equal to 1536.
*/
	if((*(u16*)(pData+off)) <= htons(0x600))
	{
		TRACE("Receive etherType %x  <= 0x600 ingore parsing L3/L4 header",(*(u16*)(pData+off)));
		return RG_FWDENGINE_RET_CONTINUE;
	}


#ifdef CONFIG_DUALBAND_CONCURRENT
	if((*(u16*)(pData+off))==htons(SLAVE_SSID_TAG_ETH))//CTAG
	{
		WARNING("[Drop] SSID-tag not parsing...Please echo 1 > /proc/rg/slaveWifiBind!!");
		return RG_FWDENGINE_RET_DROP;
	}
#endif

#if 0 //cpu tag will parse by GMAC
    if((pData[off]==0x88)&&(pData[off+1]==0x99)) //CPU TAG
    {

        if(((pData[off+8]==0x88)&&(pData[off+9]==0xa8))||((pData[off+8]==0x81)&&(pData[off+9]==0x00))||((pData[off+8]==0x88)&&((pData[off+9]==0x63)||(pData[off+9]==0x64)))||
                ((pData[off+8]==0x86)&&(pData[off+9]==0xdd))||((pData[off]==0x08)&&(pData[off+1]==0x00)))
        {
            //TO CPU
            off+=8;
        }
        else
        {
            //FROM CPU
            off+=12;
        }
    }
#endif
#if defined(CONFIG_RG_RTL9600_SERIES)
	//patch for ingress unStag but CF add Stag case: del Stag(svid=0, spri=0) : chuck
	if(((*(u16*)(pData+off))==htons(rg_db.systemGlobal.tpid)) && ((*(u16*)(pData+off+2))==0x0)){
		//DEBUG("####packetLen(before del Stag)=%d####\n",len);
		//memDump(skb->data,len,"before pkt remove stag:");

		if(!_vlan_remove_tag(pPktHdr,skb,rg_db.systemGlobal.tpid)){
				rtlglue_printf("[Drop] Fail to remove stag at %s %d\n",__FUNCTION__,__LINE__);
				return RG_FWDENGINE_RET_DROP;
		}


		len -= 4; //sync this local varibal
//		off+=4;	//skip parsing the tag into pktHdr

		pData=skb->data; //sync this local varibal
		pPktHdr->pDmac=&skb->data[0]; //DA, fix the pointer
		pPktHdr->pSmac=&skb->data[6]; //SA, fix the pointer

		//DEBUG("####packetLen(after del Stag)=%d####\n",len);
		//memDump(skb->data,len,"after pkt remove stag:");
	}

#endif

#if 1 //CVLAN/SVLAN Tag is removed by GMAC, so it will parsed by _rtk_rg_ingressVlanDecision(). the value should comes from CPUTag.
	//if((*(u16*)(pData+off))==htons(0x88a8))//STAG
    //if((pData[off]==0x88)&&(pData[off+1]==0xa8)) //STAG
    //if((*(u16*)(pData+off))==htons(rg_db.systemGlobal.tpid) && (*(u16*)(pData+off+4))==htons(0x8100))//STAG "MUST" outside of CTAG
    //20140502: if tpid is 8100 & only one tag, this tag is STAG.(follow HW behavior)
#if defined(CONFIG_RG_RTL9600_SERIES)
    if((rg_db.systemGlobal.internalSupportMask & RTK_RG_INTERNAL_SUPPORT_BIT1))
#endif
	{
	    if(rg_db.systemGlobal.service_pmsk.portmask&(0x1<<pPktHdr->ingressMacPort))
		{
		    if((*(u16*)(pData+off))==htons(rg_db.systemGlobal.tpid))
		    {
				pPktHdr->tagif|=SVLAN_TAGIF;
		    	pPktHdr->pSVlanTag=&pData[off];
				pPktHdr->stagPri=pData[off+2]>>5;
				pPktHdr->stagDei=(pData[off+2]>>4)&1;
				pPktHdr->stagVid=((pData[off+2]&0xf)<<8)|(pData[off+3]);
				pPktHdr->stagTpid= ntohs(*(u16*)(pData+off));
		        off+=4;
		    }
#if defined(CONFIG_RG_RTL9600_SERIES)
#else // support tpid2
			else if( (rg_db.systemGlobal.tpid2_en==1)&&(*(u16*)(pData+off))==htons(rg_db.systemGlobal.tpid2))
			{
				pPktHdr->tagif|=SVLAN_TAGIF;
				pPktHdr->pSVlanTag=&pData[off];
				pPktHdr->stagPri=pData[off+2]>>5;
				pPktHdr->stagDei=(pData[off+2]>>4)&1;
				pPktHdr->stagVid=((pData[off+2]&0xf)<<8)|(pData[off+3]);
				pPktHdr->stagTpid= ntohs(*(u16*)(pData+off));
				off+=4;
			}
#endif
	    }
    }
#endif

VXLAN_INNER:
#if 1
	if((*(u16*)(pData+off))==htons(0x8100))//CTAG
	//if((pData[off]==0x81)&&(pData[off+1]==0x00)) //CTAG
	{
		pPktHdr->tagif|=CVLAN_TAGIF;
		pPktHdr->pCVlanTag=&pData[off];
		pPktHdr->ctagVid=((pData[off+2]&0xf)<<8)|(pData[off+3]);
		pPktHdr->ctagPri=pData[off+2]>>5;
		pPktHdr->ctagCfi=(pData[off+2]>>4)&1;
		off+=4;
	}
#endif

	pPktHdr->etherType=ntohs(*(u16 *)&pData[off]);
	if(((*(u16*)(pData+off))==htons(RG_PPPOED_ETHERTYPE))||((*(u16*)(pData+off))==htons(RG_PPPOES_ETHERTYPE)))//PPPoE
	//if((pData[off]==0x88)&&((pData[off+1]==0x63)||(pData[off+1]==0x64))) //PPPoE
	{
   		pPktHdr->tagif|=PPPOE_TAGIF;
		pPktHdr->egressTagif|=PPPOE_TAGIF;
		pPktHdr->pppoeVerTypeCode=ntohs(*(u16*)&pData[off+2]);
		pPktHdr->sessionId=ntohs(*(u16*)&pData[off+4]);
		pPktHdr->pPppoeLength=(u16*)&pData[off+6];
		off+=8;
		pPktHdr->pppProtocal = ntohs(*(u16*)(pData+off));	//IPv4:0x0021 or 0xC021, IPv6:0x0057 or 0xC057
	}

TUUNEL_INNER:
	if(((*(u16*)(pData+off))==htons(RG_IPV4_ETHERTYPE))||((((*(u16*)(pData+off))==htons(0x0021))||(pData[off]==0x21)) && (pPktHdr->tagif&PPPOE_TAGIF||pPktHdr->tagif&L2TP_INNER_TAGIF||pPktHdr->tagif&PPTP_INNER_TAGIF)))//IPv4 or IPv4 with PPPoE,L2TP,PPTP
	{
		//TRACE("parsing IPv4");

		//20150420LUKE: ppp protocol field could be 8bits or 16bits
		if(pData[off]==0x21)off-=1;
DSLITE_INNER:
		pPktHdr->l3Offset=off+2;

		//20191213LUKE: if we receive a IPv4 ethertype but IP version or header is illegal, continue as non-IP packet.
		if((pData[pPktHdr->l3Offset]<0x45)||(pData[pPktHdr->l3Offset]>0x4f)){
			TRACE("Ethertype as IPv4 but IPVersion_HdrLen is illegal 4(%x)...continue as non-IP packet!",pData[pPktHdr->l3Offset]);
			return RG_FWDENGINE_RET_CONTINUE;
		}

		pPktHdr->ipv4HeaderLen = (pData[off+2]&0xf)<<2;		//IHL multiply 32 equals how many bits, so multiply 4 equals to bytes!
		pPktHdr->tos = pData[off+3];
		pPktHdr->pTos = (u8*)&pData[off+3];

		if((pData[off+8]>>6)&1)
			pPktHdr->ipv4DontFragment=1;	//DF=1
		else
			pPktHdr->ipv4DontFragment=0;
		if((pData[off+8]>>5)&1)
			pPktHdr->ipv4MoreFragment=1; //MF=1
		else
			pPktHdr->ipv4MoreFragment=0;
		pPktHdr->ipv4FragmentOffset=((pData[off+8]&0x1f)<<8)|pData[off+9];	//Fragment Offset
		if((pPktHdr->ipv4MoreFragment!=0)||(pPktHdr->ipv4FragmentOffset!=0))
			pPktHdr->ipv4FragPacket=1;
		else
			pPktHdr->ipv4FragPacket=0;

		if(pPktHdr==&rg_db.systemGlobal.pktHeader_frag && pPktHdr->ipv4FragmentOffset)
		{
			DEBUG("Assign sport/dport(%d/%d) of non-first fragment.", pPktHdr->sport_firstFrag, pPktHdr->dport_firstFrag);
			pPktHdr->sport = pPktHdr->sport_firstFrag;
			pPktHdr->dport = pPktHdr->dport_firstFrag;
		}

		pPktHdr->l3Len=(pData[off+4]<<8)|pData[off+5];
		pPktHdr->pL3Len=(u16*)&pData[off+4];

		//if(pPktHdr->ipv4FragPacket)
			pPktHdr->ipv4Identification=ntohs(*(u16*)&pData[off+6]);
		pPktHdr->ipv4TTL=pData[off+10];
		pPktHdr->pIpv4TTL=(u8*)&pData[off+10];
		pPktHdr->tagif|=IPV4_TAGIF;
		pPktHdr->ipv4Sip=ntohl(*(u32*)&pData[off+14]);
		pPktHdr->ipv4Dip=ntohl(*(u32*)&pData[off+18]);
		pPktHdr->pIpv4Sip=(u32*)&pData[off+14];
		pPktHdr->pIpv4Dip=(u32*)&pData[off+18];
		pPktHdr->ipv4Checksum=ntohs(*(u16*)&pData[off+12]);
		pPktHdr->pIpv4Checksum=(u16*)&pData[off+12];

		protocol=pData[off+11];

		//proc/rg/igmp_trap_to_PS : trap igmp packet original to PS
		if((rg_db.systemGlobal.igmp_Trap_to_PS_enable)&&(pPktHdr->ingressLocation==RG_IGR_PHY_PORT)){
			if(protocol==RG_IP_PROTO_IGMP){//igmp
				TRACE("[To PS] TRAP Igmp to PS");
				pPktHdr->byPassToPsVlanAclDecision = 1;
				ret = RG_FWDENGINE_RET_TO_PS;
			}
		}

		//20151007LUKE: check for dslite multicast's IPv4 address!
		if(pPktHdr->tagif&DSLITEMC_INNER_TAGIF){
			int dsliteMc_ret=_rtk_rg_dslite_multicast_v4Check(pPktHdr);
			if(dsliteMc_ret!=RG_FWDENGINE_RET_CONTINUE) return dsliteMc_ret;
		}

		//20201218LUKE: for dip as global broadcast address but dmac not broadcast, trap to ps!
		//20201219LUKE: only check for not-from-wan and not-from-ps packets.
		if((rg_db.systemGlobal.bc_dip_with_non_bc_dmac_Trap_to_PS_enable)&&(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)&&
			((0x1<<pPktHdr->ingressPort) & rg_db.systemGlobal.lanPortMask.portmask)&&(pPktHdr->ipv4Dip==0xffffffff)&&(*pPktHdr->pDmac!=0xff)){
			TRACE("[To PS] TRAP broadcast dip packet with non-broadcast dmac from LAN to PS");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			ret = RG_FWDENGINE_RET_TO_PS;
		}

		off+=((pData[off+2]&0xf)<<2)+2;
	}
	else if(((*(u16*)(pData+off))==htons(RG_IPV6_ETHERTYPE))|| ((((*(u16*)(pData+off))==htons(0x0057))||(pData[off]==0x57)) && (pPktHdr->tagif&PPPOE_TAGIF||pPktHdr->tagif&L2TP_INNER_TAGIF||pPktHdr->tagif&PPTP_INNER_TAGIF)))//IPv6 or IPv6 with PPPoE,L2TP,PPTP
    //else if(((pData[off]==0x86)&&(pData[off+1]==0xdd)) || ((pData[off]==0x00)&&(pData[off+1]==0x57)))		//IPv6 or IPv6 with PPPoE
	{
		//TRACE("parsing IPv6");
		//20150420LUKE: ppp protocol field could be 8bits or 16bits
		if(pData[off]==0x57)off-=1;
#if 0
        rtlglue_printf("IPv6:[" COLOR_Y "Ver" COLOR_NM "=%d][" COLOR_Y "TC" COLOR_NM "=%02x][" COLOR_Y "FL" COLOR_NM "=%02x%02x%x][" COLOR_Y "Len" COLOR_NM "=%d][" COLOR_Y "NxHdr" COLOR_NM "=%d][" COLOR_Y "HopLimit" COLOR_NM "=%d]\n"
                       ,pData[off+2]>>4, (pData[off+2]&0xf)+(pData[off+3]>>4), (pData[off+3]&0xf)+(pData[off+4]>>4), (pData[off+4]&0xf)+(pData[off+5]>>4), (pData[off+5]&0xf), pData[off+6]+pData[off+7], pData[off+8], pData[off+9]);
#endif
		pPktHdr->tagif|=IPV6_TAGIF;

		pPktHdr->l3Offset=off+2;
		pPktHdr->tos = ((pData[off+2]<<4)&0xf0)|((pData[off+3]>>4)&0xf);
		pPktHdr->pTos=(u8*)&pData[off+2];		//IPv6's traffic class is between version and flow label


		pPktHdr->pIpv6FlowLebal= (u8*)&pData[off+3];//first 4 bits are IPv6's traffic class,
		pPktHdr->ipv6FlowLebal=((pData[off+3]&0xf)<<16) | ((pData[off+4])<<8) | ((pData[off+5]));


		pPktHdr->ipv6PayloadLen=(pData[off+6]<<8)|pData[off+7];
		pPktHdr->pIPv6HopLimit=&pData[off+9];
		pPktHdr->pIpv6Sip=&pData[off+10];
		pPktHdr->pIpv6Dip=&pData[off+26];
		memcpy(pPktHdr->ipv6_sip_addr, pPktHdr->pIpv6Sip, IPV6_ADDR_LEN);
		memcpy(pPktHdr->ipv6_dip_addr, pPktHdr->pIpv6Dip, IPV6_ADDR_LEN);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->ipv6Sip_hash=_rtk_rg_sw_flowHashIPv6SrcAddr_get(pPktHdr->pIpv6Sip);
		pPktHdr->ipv6Dip_hash=_rtk_rg_sw_flowHashIPv6DstAddr_get(pPktHdr->pIpv6Dip);
		//20170623: sip/dip of ipv6 must use same hash function for L2/L3 tcp tracking.
		pPktHdr->tcpUdpTracking_ipv6SipHash=pPktHdr->ipv6Sip_hash;
		pPktHdr->tcpUdpTracking_ipv6DipHash=_rtk_rg_sw_flowHashIPv6SrcAddr_get(pPktHdr->pIpv6Dip);
#endif

        protocol=pData[off+8];
		pPktHdr->l3Len=42;		//header length plus ether type

		off+=pPktHdr->l3Len;
		pPktHdr->l3Len+=pPktHdr->ipv6PayloadLen-2;

MORE_IPV6_EXT:
		//process extension headers
		switch(protocol)
		{
			case RG_IP_PROTO_IPinIP:		//IP in IP
				//20150108LUKE: check for dslite WAN
				if((pPktHdr->tagif&DSLITE_INNER_TAGIF)==0){
					if(pPktHdr->pIpv6Dip[0]==0xff){
						//20151007LUKE: check for dslite multicast's IPv6 address!
						int dsliteMc_ret=_rtk_rg_dslite_multicast_v6Check(pPktHdr);
						if(dsliteMc_ret!=RG_FWDENGINE_RET_CONTINUE) return dsliteMc_ret;
						off-=2; //minus ethertype
						goto DSLITE_INNER;
					}else{
						//Check if match DSlite WAN's IP and gateway IP
						for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
						{
							pWan_intf=&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf;
							if(pWan_intf->wan_intf_conf.wan_type==RTK_RG_DSLITE &&
								(memcmp(pPktHdr->pIpv6Dip,pWan_intf->dslite_info.rtk_dslite.ipB4.ipv6_addr,IPV6_ADDR_LEN)==0) &&
								(memcmp(pPktHdr->pIpv6Sip,pWan_intf->dslite_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN)==0)){
								TRACE("Match DSLITE[%d]!",i);
								if(pPktHdr->tagif&V6FRAG_TAGIF)
								{
									TRACE("[To PS] dslite and its ipv6 header has fragment extension header");
									return RG_FWDENGINE_RET_TO_PS;   //frag to PS
								}
								pPktHdr->tagif&=(~IPV6_TAGIF);
								pPktHdr->tagif|=DSLITE_INNER_TAGIF;
								off-=2; //minus ethertype
								break;
							}
							else if((pPktHdr->tagif&PPPOE_TAGIF) && pWan_intf->wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE &&
								(memcmp(pPktHdr->pIpv6Dip,pWan_intf->pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipB4.ipv6_addr,IPV6_ADDR_LEN)==0) &&
								(memcmp(pPktHdr->pIpv6Sip,pWan_intf->pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN)==0)){
								TRACE("Match PPPoE_DSLITE[%d]!",i);
								if(pPktHdr->tagif&V6FRAG_TAGIF)
								{
									TRACE("[To PS] dslite and its ipv6 header has fragment extension header");
									return RG_FWDENGINE_RET_TO_PS;   //frag to PS
								}
								pPktHdr->tagif&=(~IPV6_TAGIF);
								pPktHdr->tagif|=DSLITE_INNER_TAGIF;
								off-=2; //minus ethertype
								break;
							}
						}
						if(pPktHdr->tagif&DSLITE_INNER_TAGIF)goto DSLITE_INNER;
					}
				}
				break;
			case RG_IP_PROTO_HOPOPT:		//Hop-by-hop
			{
				//uint8 optionType;
				//uint8 optionDataLen;
				TRACE("IPv6 Hop-by-hop. Trap to protocol stack if L3/L4");
				pPktHdr->tagif|=V6TRAP_TAGIF;

				protocol=pData[off];
				v6HeaderOff=(pData[off+1]+1)<<3;	//length didn't count the first 8 octets, so we have to add 1 here
				//pPktHdr->l3Len+=(v6HeaderOff+2);	//pPktHdr->l3Len+=2;
				//off+=(v6HeaderOff+2);	//off+=2
				//pPktHdr->l3Len+=v6HeaderOff;	//pPktHdr->l3Len+=2;
				off+=v6HeaderOff;	//off+=2
				#if 0
				/* check all the type/length of hop-by-hop options are correct */
				while (off - pPktHdr->l3Offset < v6HeaderOff)
				{
					//optionType=pData[off]; switch (optionType)
					switch (pData[off])
					{
						case 0: /*pad1 option*/
							off++;
							continue;
						#if 1
						case 1: /* padN option*/
							optionDataLen=pData[off+1];
							off=off+optionDataLen+2;
							continue;
						#endif
						default:
							/*router alter option*/
							if (ntohl(*(uint32 *)(&pData[off]))==IPV6_ROUTER_ALTER_OPTION)
							{
								//ipv6RAO=IPV6_ROUTER_ALTER_OPTION;
								off+=4;
								continue;
							}
						//case 1: /* padN option*/
							/* other TLV option*/
							optionDataLen=pData[off+1];
							off=off+optionDataLen+2;
							continue;
					}
				}
				if (off - pPktHdr->l3Offset -40 != v6HeaderOff)
					rtlglue_printf("ipv6 ext hop-by-hop packet parse error\n");
				#endif
				pPktHdr->ipv6PayloadLen-=v6HeaderOff;
				goto MORE_IPV6_EXT;
			}
			case RG_IP_PROTO_IPv6_Route:	//Routing Header
				protocol=pData[off];
				v6HeaderOff=(pData[off+1]+1)<<3;	//length didn't count the first 8 octets, so we have to add 1 here
				off+=v6HeaderOff;
				//pPktHdr->l3Len+=v6HeaderOff;
				/*
				if (pData[off+3]>0)
				{
					//Routing Head
				}
				*/
				pPktHdr->ipv6PayloadLen-=v6HeaderOff;
				goto MORE_IPV6_EXT;
			case RG_IP_PROTO_IPV6_OPTS:	//Destionation Options Header
				protocol=pData[off];
				v6HeaderOff=(pData[off+1]+1)<<3;	//length didn't count the first 8 octets, so we have to add 1 here

				//pPktHdr->l3Len+=v6HeaderOff;
				off+=v6HeaderOff;
				pPktHdr->ipv6PayloadLen-=v6HeaderOff;
				goto MORE_IPV6_EXT;
			case RG_IP_PROTO_IPv6_Frag:	//Fragment Header
				//TRACE("protocol is frag, next is %d",pData[off]);
				pPktHdr->tagif|=V6FRAG_TAGIF;
				protocol=pData[off];
				v6HeaderOff=8;

				pPktHdr->ipv6MoreFragment=pData[off+3]&0x1;
				pPktHdr->ipv6FragmentOffset=(pData[off+2]<<5)|((pData[off+3]&0xf8)>>3);	//Fragment Offset
				pPktHdr->ipv6FragId=ntohl(*(u32*)&pData[off+4]);
				pPktHdr->ipv6FragId_First=ntohs(*(u16*)&pData[off+4]);
				pPktHdr->ipv6FragId_Second=ntohs(*(u16*)&pData[off+6]);
				if((pPktHdr->ipv6MoreFragment!=0)||(pPktHdr->ipv6FragmentOffset!=0))
					pPktHdr->ipv6FragPacket=1;
				else
					pPktHdr->ipv6FragPacket=0;

				if(pPktHdr==&rg_db.systemGlobal.pktHeader_frag && pPktHdr->ipv6FragmentOffset)
				{
					DEBUG("Assign sport/dport(%d/%d) of non-first fragment.", pPktHdr->sport_firstFrag, pPktHdr->dport_firstFrag);
					pPktHdr->sport = pPktHdr->sport_firstFrag;
					pPktHdr->dport = pPktHdr->dport_firstFrag;
				}
				//TRACE("IPv6 frag:M=%d, Off=%d, Id=%04x%04x",pPktHdr->ipv6MoreFragment,
					//pPktHdr->ipv6FragmentOffset,pPktHdr->ipv6FragId_First,pPktHdr->ipv6FragId_Second);
				//pPktHdr->l3Len+=v6HeaderOff;
				off+=v6HeaderOff;
				pPktHdr->ipv6PayloadLen-=v6HeaderOff;
				goto MORE_IPV6_EXT;
			case RG_IP_PROTO_AH:	//Authentication Header, [RFC4302]
				protocol=pData[off];
				v6HeaderOff=(pData[off+1]+2)<<2;	//This field specifies the length of AH in 32-bit words (4-byte units), minus "2"
				//pPktHdr->l3Len+=v6HeaderOff;
				off+=v6HeaderOff;
				pPktHdr->ipv6PayloadLen-=v6HeaderOff;
				goto MORE_IPV6_EXT;
			case RG_IP_PROTO_PIM:	//PIM
				//if (protocol==103) TRACE("got IPv6 Packet with Next Header={103 | PIM}");
					break;
			case RG_IP_PROTO_OSPF:	//OSPF or MOSPF
				//if (protocol==89) TRACE("got IPv6 Packet with Next Header={89 | MOSPF}");
					break;
			case RG_IP_PROTO_TCP:		//TCP
			case RG_IP_PROTO_IGP:		//IGP(used in Cisco IGRP)
			case RG_IP_PROTO_UDP:	//UDP
			case RG_IP_PROTO_IPv6:	//IPv6 Header, for Tunnel
			case RG_IP_PROTO_IDRP:	//Inerdomain Routing Protocol(IDRP)
			case RG_IP_PROTO_RSVP:	//Resource Reservation Protocol(RSVP)
			case RG_IP_PROTO_ESP:	//Encapsulating Security Payload, [RFC4303]
				//if (protocol==50) TRACE("got IPv6 Packet with Next Header={50 | Encapsulating Security Payload}");
			case RG_IP_PROTO_ICMPv6:	//ICMPv6
				//if (protocol==58) TRACE("got IPv6 Packet with Next Header={58 | ICMPv6}");
			//case 130:	//MLDv1/MLDv2 Query
				//if (protocol==130) TRACE("got IPv6 Packet with Next Header={130 | MLDv1/MLDv2 Query}");
			//case 131:	//MLDv1 Report
				//if (protocol==131) TRACE("got IPv6 Packet with Next Header={131 | MLDv1 Report}");
			//case 143:	//MLDv2 Report
				//if (protocol==143) TRACE("got IPv6 Packet with Next Header={131 | MLDv2 Report}");
			case RG_IP_PROTO_IPv6_NoNxt:	//No Next Header
			case RG_IP_PROTO_EIGRP:	//EIGRP
			case RG_IP_PROTO_IPComp:	//IP Payload Compression Protocol
			case RG_IP_PROTO_L2TP:	//Layer2 Tunneling Protocol(L2TP)
			case RG_IP_PROTO_SCTP:	//Stream Control Transmission Protocol(SCTP) ???????
				//if (protocol==89) TRACE("got IPv6 Packet with Next Header={132 | MLD Done}");
			case RG_IP_PROTO_Mob_Header:	//Mobility Header, [RFC6275]
			case RG_IP_PROTO_HIP:	//Experimental use, Host Identity Protocol [RFC5201]
			case RG_IP_PROTO_Shim6:	//Shim6 Protocol, [RFC5533]
			case 253:	//Use for experimentation and testing, [RFC3692], [RFC4727]
			case 254:	//Use for experimentation and testing, [RFC3692], [RFC4727]
				TRACE("v6 nextHeader value %d. Continue",protocol);
				break;
			default:
				TRACE("v6 unknown nextHeader value %d. Trap to protocol stack if L4");
				pPktHdr->tagif|=UNKNOWN_L4_TAGIF;
				break;
		}
	}
	else if((*(u16*)(pData+off))==htons(RG_ARP_ETHERTYPE)) //ARP
	//else if((pData[off]==0x08)&&(pData[off+1]==0x06))
	{
		pPktHdr->tagif|=ARP_TAGIF;
		pPktHdr->arpOpCode=ntohs(*(u16*)&pData[off+8]);
		pPktHdr->ipv4Sip=ntohl(*(u32*)&pData[off+16]);
		pPktHdr->ipv4Dip=ntohl(*(u32*)&pData[off+26]);
		pPktHdr->pIpv4Sip=(u32*)&pData[off+16];
		pPktHdr->pIpv4Dip=(u32*)&pData[off+26];

		if(rg_db.systemGlobal.fwdStatistic)
		{
			if(pPktHdr->arpOpCode==1)
				rg_db.systemGlobal.statistic.perPortCnt_ARP_request[pPktHdr->ingressPort]++;
			else if(pPktHdr->arpOpCode==2)
				rg_db.systemGlobal.statistic.perPortCnt_ARP_reply[pPktHdr->ingressPort]++;
		}
	}

	pPktHdr->ipProtocol=protocol;

	if(protocol==RG_IP_PROTO_ESP) //ESP
	{
		pPktHdr->tagif|=ESP_TAGIF;  /*siyuan add for alg IPsec passthrough*/
		pPktHdr->l4Offset=off;
	}


	if(((pPktHdr->tagif&IPV4_TAGIF)&&(pPktHdr->ipv4FragmentOffset>0))||((pPktHdr->tagif&IPV6_TAGIF)&&(pPktHdr->ipv6FragmentOffset>0)))
		return RG_FWDENGINE_RET_CONTINUE;

	if(protocol==RG_IP_PROTO_TCP) //TCP
	{
    	//dump_packet(pData,len,"par");
		pPktHdr->l4Offset=off;
		pPktHdr->tagif|=TCP_TAGIF;
		pPktHdr->sport=ntohs(*(u16*)&pData[off]);
		pPktHdr->pSport=(u16*)&pData[off];
		pPktHdr->dport=ntohs(*(u16*)&pData[off+2]);
		pPktHdr->pDport=(u16*)&pData[off+2];
		pPktHdr->tcpSeq=ntohl(*(u32*)&pData[off+4]);
		pPktHdr->pTcpSeq=(u32*)&pData[off+4];
		pPktHdr->tcpAck=ntohl(*(u32*)&pData[off+8]);
		pPktHdr->pTcpAck=(u32*)&pData[off+8];
		*((u8*)(&pPktHdr->tcpFlags))=pData[off+13];

		if(rg_db.systemGlobal.fwdStatistic)
		{
			rg_db.systemGlobal.statistic.perPortCnt_TCP[pPktHdr->ingressPort]++;
			if(pPktHdr->tcpFlags.ack==0)
			{
				if(*((u8*)(&pPktHdr->tcpFlags))==0x2) rg_db.systemGlobal.statistic.perPortCnt_SYN[pPktHdr->ingressPort]++;
				else if(*((u8*)(&pPktHdr->tcpFlags))==0x1) rg_db.systemGlobal.statistic.perPortCnt_FIN[pPktHdr->ingressPort]++;
				else if(*((u8*)(&pPktHdr->tcpFlags))==0x4) rg_db.systemGlobal.statistic.perPortCnt_RST[pPktHdr->ingressPort]++;
			}
			else
			{
				if(*((u8*)(&pPktHdr->tcpFlags))==0x10) rg_db.systemGlobal.statistic.perPortCnt_ACK[pPktHdr->ingressPort]++;
				else if(*((u8*)(&pPktHdr->tcpFlags))==0x12) rg_db.systemGlobal.statistic.perPortCnt_SYN_ACK[pPktHdr->ingressPort]++;
				else if(*((u8*)(&pPktHdr->tcpFlags))==0x11) rg_db.systemGlobal.statistic.perPortCnt_FIN_ACK[pPktHdr->ingressPort]++;
				else if(*((u8*)(&pPktHdr->tcpFlags))==0x14) rg_db.systemGlobal.statistic.perPortCnt_RST_ACK[pPktHdr->ingressPort]++;
				else if(*((u8*)(&pPktHdr->tcpFlags))==0x19) rg_db.systemGlobal.statistic.perPortCnt_FIN_PSH_ACK[pPktHdr->ingressPort]++;
			}
		}

		pPktHdr->headerLen=pData[off+12]>>4<<2;
		pPktHdr->tcpWindow=ntohs(*(u16*)&pData[off+14]);
		pPktHdr->l4Checksum=ntohs(*(u16*)&pData[off+16]);
		pPktHdr->pL4Checksum=(u16*)&pData[off+16];
		//DEBUG("sip=%x dip=%x sport=0x%x dport=0x%x ip_protocol=%d syn=%d ack=%d fin=%d rst=%d\n",pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,pPktHdr->ipProtocol,pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);

		if(pPktHdr->tcpFlags.syn==1)
		{
			//parsing mss optins
			if(pPktHdr->headerLen>20) //tcp header len > 20 (have options)
			{
				int i;
				//memDump(&pData[off+20],pPktHdr->headerLen-20,"options");
				for(i=20;i<pPktHdr->headerLen;i++)
				{
					if(pData[off+i]==1) //No-Operation
					{
						//skip NOP
					}
					else if(pData[off+i]==2) //Maximum Segment Size
					{
						pPktHdr->tagif|=MSS_TAGIF;
						pPktHdr->pMssLength=(uint16 *)&pData[off+i+2];
						//printk("mss=%d\n",*pPktHdr->pMssLength);
						break;
					}
					else if(pData[off+i]==0) //End of Option List
					{
						break;
					}
					else
					{
						if(pData[off+i+1]>=2)
							i+=(pData[off+i+1]-1);
						else //maybe packet format is error.
							break;
					}
				}
			}
		}
		off+=pPktHdr->headerLen;

		//check HTTP request first packet & assign payloadbuff
		pPktHdr->httpFirstPacket=0;
		pPktHdr->httpsClientHelloPacket=0;
		pPktHdr->pL4Payload=NULL;
		if((off < skb->len)&&((pPktHdr->tagif&TCP_TAGIF)||(pPktHdr->tagif&UDP_TAGIF))){//only TCP or UDP have l4Payload.
			pPktHdr->pL4Payload=&pData[off];
		}
		if( rg_db.systemGlobal.urlHiPri_En || _check_urlFilter_is_enabled(pPktHdr) || !list_empty(&rg_db.redirectHttpURLListHead) || rg_db.systemGlobal.gatherLanNetInfo || rg_db.systemGlobal.dpi_accelerate_enable)
		{
			if(off+2<=len)
			{
				if((pData[off]=='G')&&(pData[off+1]=='E')){
					pPktHdr->httpFirstPacket=1;
					pPktHdr->pL4Payload=&pData[off];
				}
				else if((pData[off]=='P')&&(pData[off+1]=='O')){
					pPktHdr->httpFirstPacket=1;
					pPktHdr->pL4Payload=&pData[off];
				}
			}
		}
		if(((rg_db.algFunctionMask & RTK_RG_ALG_RTSP_TCP_BIT)&&(pPktHdr->sport==rg_db.algTcpFunctionMapping[RTK_RG_ALG_RTSP_TCP].portNum)) || ((rg_db.algFunctionMask & RTK_RG_ALG_RTSP_TCP_SRV_IN_LAN_BIT)&&(pPktHdr->sport==rg_db.algTcpFunctionMapping[RTK_RG_ALG_RTSP_TCP_SRV_IN_LAN].portNum)))
		{
			if(off+4<=len)
			{
				if(pData[off]!='$')
				{
					TRACE("the RTSP is not interleaved frame!! goto slow path!!");
					pPktHdr->tagif|=RTSP_NON_INTERLEAVED_FRAME_TAGIF;
				}
				else
					TRACE("receiving RTSP interleaved frame!");
			}
		}

		if(pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort)
		{
			//TLS Record header
			if(((off+5)<=len) && (pData[off]==0x16) && (pData[off+1]==0x3) && (0x1<=pData[off+2] && pData[off+2]<=0x3))
			{
				uint16 payloadLength = *(uint16 *)(pData + off + 3);

				DEBUG("off=%d, TLS payloadLength=%d, skb->len=%d", off, payloadLength, len);
				if(((off+5+payloadLength)<=len) && (pData[off+5]==0x1)/*Client Hello*/)
				{
					DEBUG("Https Client Hello packet");
					pPktHdr->httpsClientHelloPacket = 1;
				}
			}
		}

		//Check for PPTP packet
		//Verify data length, if the length is unable to analyze outgoing-call-request or outgoing-call-reply, this should be invalid PPTP control packet
		if (off + sizeof(rtk_rg_pptpMsgHead_t) + sizeof(rtk_rg_pptpCallIds_t) <= len)	//pptpMsgHead and pptpCallIds are just enough to get session ID and Peer's call ID
		{
			// Move up to PPTP message header
			pPPTPHdr = (rtk_rg_pptpMsgHead_t *) (((u8 *) pData) + off);

			// Verify PPTP Control Message
			pptpMagic = ntohl(pPPTPHdr->magic);
			if ((ntohs(pPPTPHdr->msgType) == PPTP_CTRL_MSG_TYPE) && (pptpMagic == PPTP_MAGIC))
			{
				// When packet is reply type, must have result code and error code to decide whether ID field is valid
				if ((ntohs(pPPTPHdr->type) == PPTP_OutCallReply || ntohs(pPPTPHdr->type) == PPTP_InCallReply))
				{
					// Verify data length:
					if((off + sizeof(rtk_rg_pptpMsgHead_t) + sizeof(rtk_rg_pptpCallIds_t) + sizeof(rtk_rg_pptpCodes_t)) <= len)
					{
						pPktHdr->tagif|=PPTP_TAGIF;
						pPktHdr->pptpCtrlType = ntohs(pPPTPHdr->type);
						pPktHdr->pPptpCallId = (rtk_rg_pptpCallIds_t *) (pPPTPHdr + 1);
						pPktHdr->pptpCodes = *(rtk_rg_pptpCodes_t *) (pPktHdr->pPptpCallId + 1);
						//DEBUG("PPTP CTRL TYPE is %d, CID1 is %04x, CID2 is %04x, resCode is %d, errCode is %d",pPktHdr->pptpCtrlType,pPktHdr->pPptpCallId->cid1,pPktHdr->pPptpCallId->cid2,
							//pPktHdr->pptpCodes.resCode,pPktHdr->pptpCodes.errCode);
					}
				}
				else
				{
					pPktHdr->tagif|=PPTP_TAGIF;
					pPktHdr->pptpCtrlType = ntohs(pPPTPHdr->type);
					pPktHdr->pPptpCallId = (rtk_rg_pptpCallIds_t *) (pPPTPHdr + 1);
					//DEBUG("PPTP CTRL TYPE is %d, CID1 is %04x, CID2 is %04x",pPktHdr->pptpCtrlType,pPktHdr->pPptpCallId->cid1,pPktHdr->pPptpCallId->cid2);
				}
			}
		}
	}
	else if(protocol==RG_IP_PROTO_UDP) //UDP
	{
		if(rg_db.systemGlobal.fwdStatistic)
		{
			rg_db.systemGlobal.statistic.perPortCnt_UDP[pPktHdr->ingressPort]++;
		}

		pPktHdr->l4Offset=off;
		pPktHdr->tagif|=UDP_TAGIF;
		pPktHdr->sport=ntohs(*(u16*)&pData[off]);
		pPktHdr->pSport=(u16*)&pData[off];
		pPktHdr->dport=ntohs(*(u16*)&pData[off+2]);
		pPktHdr->pDport=(u16*)&pData[off+2];
		pPktHdr->l4Checksum=ntohs(*(u16*)&pData[off+6]);
		pPktHdr->pL4Checksum=(u16*)&pData[off+6];
		//siyuan add for alg function which may change the udp data length
		pPktHdr->pL4Len = (u16*)&pData[off+4];
		pPktHdr->l4Len = ntohs(*(u16*)&pData[off+4]);
		off+=8;

		if((pPktHdr->tagif&VXLAN_TAGIF)==0)
		{
			//Check if match VXLAN WAN's IP, port number, and VNI
			for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
			{
				pWan_intf = &rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf;
				if(pWan_intf->wan_intf_conf.wan_type==RTK_RG_VXLAN) 
				{
					if(pPktHdr->dport==pWan_intf->vxlan_info.after_dial.outer_udp_dport &&
					((pPktHdr->tagif&IPV4_TAGIF) && pPktHdr->ipv4Sip==pWan_intf->vxlan_info.after_dial.vxlan_remote_ipv4_addr))
					{
						if((*(u32*)&pData[off])!=htonl(0x8000000))
						{
							TRACE("[Check wan %d] VXLAN flags is error", rg_db.systemGlobal.wanIntfGroup[i].index);
							continue;
						}
						if((*(u32*)&pData[off+4])!=htonl(pWan_intf->vxlan_info.after_dial.vxlan_network_identifier<<8))
						{
							TRACE("[Check wan %d] VNI is not matched", rg_db.systemGlobal.wanIntfGroup[i].index);
							continue;
						}
						TRACE("Match VXLAN wan[%d]", rg_db.systemGlobal.wanIntfGroup[i].index);
						if(pWan_intf->vxlan_info.after_dial.vxlan_mode==VXLAN_MODE_L3)
						{
							protocol = RG_IP_PROTO_RESERVED;
							off += 8;							
							//store outer flow info here
							if(rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_mechanism){
								pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
								pPktHdr->srcNetifIdx=pWan_intf->vxlan_info.after_dial.vxlan_baseIntf_idx;
								_rtk_rg_vxlanInNaptShortcutUpdate(pPktHdr);
								//20200702LUKE: fix downstream packet entered before upstream will cause downstream packet length doesn't minus the vxlan header length.
								if(rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length==0){
									rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length=off;
									if(pPktHdr->tagif&SVLAN_TAGIF)rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-=4;
									if(pPktHdr->tagif&CVLAN_TAGIF)rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-=4;
									if(pPktHdr->tagif&PPPOE_TAGIF)rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-=8;
								}
								//20200702LUKE: fix downstream packet flow-miss should modify ingress port to wan port.
								rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx=pPktHdr->netifIdx;
							}
							pPktHdr->tagif = VXLAN_TAGIF;
							pPktHdr->pVxlan_inner_data = &pData[off];
							//Reset DMAC and SMAC pointer
							pPktHdr->pDmac = &pData[off];
							pPktHdr->pSmac = &pData[off+ETHER_ADDR_LEN];
#if defined(CONFIG_RG_RTL9602C_SERIES)
							memcpy(pPktHdr->dmac, pPktHdr->pDmac, ETHER_ADDR_LEN); //apolloFE need the original Dmac in shortcut to determind MIB Interface.
#endif
							off += (ETHER_ADDR_LEN<<1);
							TRACE("[VXLAN L3 mode] Go to parse inner payload, off=%d", off);
							goto VXLAN_INNER;
						}
						else	//VXLAN_MODE_L2
						{
							pPktHdr->byPassToPsVlanAclDecision = 1;
							TRACE("[To PS] VXLAN mode is L2");
							return RG_FWDENGINE_RET_TO_PS;
						}
					}
				}
			}
		}
		if((pPktHdr->tagif&L2TP_INNER_TAGIF)==0)
		{
			//Check if match L2TP WAN's IP and port number
			for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
			{
				pWan_intf=&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf;
				if(pWan_intf->wan_intf_conf.wan_type==RTK_RG_L2TP &&
					pPktHdr->dport==pWan_intf->l2tp_info.after_dial.outer_port &&
					pPktHdr->sport==pWan_intf->l2tp_info.after_dial.gateway_outer_port &&
					pPktHdr->ipv4Sip==pWan_intf->l2tp_info.before_dial.l2tp_ipv4_addr)
				{
					//Match IP, check tunnel ID and session ID
					pPktHdr->l2tpFlagVersion = ntohs(*(u16*)&pData[off]);
					if(pPktHdr->l2tpFlagVersion&0x8000)break;		//skip control packet parsing
					if((pPktHdr->l2tpFlagVersion&0xf)!=0x2)break;	//only support version 2 now

					//L2tp version 2, need to parse each bit for Length, Ns, Nr, Offset.
					tmpOff=2;
					if(pPktHdr->l2tpFlagVersion&0x4000)	//Length bit
						tmpOff=4;
					if(ntohs(*(u16*)&pData[off+tmpOff])==pWan_intf->l2tp_info.after_dial.tunnelId &&
						ntohs(*(u16*)&pData[off+tmpOff+2])==pWan_intf->l2tp_info.after_dial.sessionId)
					{
						TRACE("Match L2TP!!");
						tmpOff+=4;
						if(pPktHdr->l2tpFlagVersion&0x0800)	//Sequence bit
							tmpOff+=4;
						if(pPktHdr->l2tpFlagVersion&0x0200)	//Offset bit
							tmpOff+=ntohs(*(u16*)&pData[off+tmpOff])+2;

						pPktHdr->tagif&=(~UDP_TAGIF);
						protocol=RG_IP_PROTO_RESERVED;
						pPktHdr->tagif&=(~IPV4_TAGIF);
						//pPktHdr->tagif&=(~IPV6_TAGIF);

						//20151201LUKE: check if the Address and Control field be omitted
						if(*(u16*)(pData+off+tmpOff)==htons(0xff03))
							off+=tmpOff+2;		//PPP
						else
							off+=tmpOff;
						pPktHdr->tagif|=L2TP_INNER_TAGIF;
						break;
					}
				}
			}
			if(pPktHdr->tagif&L2TP_INNER_TAGIF)goto TUUNEL_INNER;
		}
	}
	else if(protocol==RG_IP_PROTO_ICMP) //ICMP
	{
		//TRACE("parsing ICMP");
		pPktHdr->tagif|=ICMP_TAGIF;
		pPktHdr->l4Offset=off;
		pPktHdr->ICMPType=(ntohs(*(u16*)&pData[off])&0xff00)>>8;
		pPktHdr->ICMPCode=ntohs(*(u16*)&pData[off])&0xff;
		pPktHdr->ICMPIdentifier=ntohs(*(u16*)&pData[off+4]);
		pPktHdr->ICMPSeqNum=ntohs(*(u16*)&pData[off+6]);
		pPktHdr->l4Checksum=ntohs(*(u16*)&pData[off+2]);
		pPktHdr->pL4Checksum=(u16*)&pData[off+2];

		if(rg_db.systemGlobal.fwdStatistic)
		{
			if(pPktHdr->ICMPType==8)
				rg_db.systemGlobal.statistic.perPortCnt_ICMP_REQ[pPktHdr->ingressPort]++;
			else if(pPktHdr->ICMPType==0)
				rg_db.systemGlobal.statistic.perPortCnt_ICMP_REP[pPktHdr->ingressPort]++;
		}
	}
	else if(protocol==RG_IP_PROTO_IGMP) //IGMP
	{
		pPktHdr->l4Offset=off;
		if (pPktHdr->tagif&IPV4_TAGIF)
		{
			_rtk_rg_igmpPacketParser(off, pData, pPktHdr);
		}
	}
	else if (protocol==RG_IP_PROTO_OSPF) //MOSPF
	{
		pPktHdr->l4Offset=off;
		_rtk_rg_mospfPacketParser(off, pData, pPktHdr);
	}
	else if (protocol==RG_IP_PROTO_PIM) //PIM
	{
		pPktHdr->l4Offset=off;
		_rtk_rg_pimfPacketParser(off, pData, pPktHdr);
	}
	else if(protocol==RG_IP_PROTO_ICMPv6)	//ICMPv6
	{
		pPktHdr->tagif|=ICMPV6_TAGIF;
		//Leo: Fix Parsing Error
		//off=off-2;

		pPktHdr->l4Offset=off;
		pPktHdr->ICMPv6Type=(ntohs(*(u16*)&pData[off])&0xff00)>>8;
		TRACE("got ICMPv6 Type=%d", pPktHdr->ICMPv6Type);
		if(pPktHdr->ICMPv6Type==0x88||pPktHdr->ICMPv6Type==0x87){	//136, Neighbor Advertisement or 135, Neighbor Solicitation
			ret=_rtk_rg_ICMPV6_neighbor_advertisement_solicitation_parsing(pData, off, pPktHdr);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;
		}

		if(rg_db.systemGlobal.fwdStatistic)
		{
			if(pPktHdr->ICMPv6Type==0x87)
			{
				TRACE("parsing ICMPv6/fwdStatistic/solicitation(87)");
				rg_db.systemGlobal.statistic.perPortCnt_NB_solicitation[pPktHdr->ingressPort]++;
			}
			else if(pPktHdr->ICMPv6Type==0x88)
			{
				TRACE("parsing ICMPv6/fwdStatistic/adverticsement(88)");
				rg_db.systemGlobal.statistic.perPortCnt_NB_advertisement[pPktHdr->ingressPort]++;
			}
		}

		//next header start from 8 byte later
		//check mld
		if(pPktHdr->ICMPv6Type==130/*Multicast Listener Query*/
		|| pPktHdr->ICMPv6Type==131/*Multicast Listener Report*/
		|| pPktHdr->ICMPv6Type==132/*Multicast Listener Done*/
		|| pPktHdr->ICMPv6Type==143/*Multicast Listener Discovery (MLDv2) reports */)
		{
			_rtk_rg_mldPacketParser(off, pData, pPktHdr);
		}
		//proc/rg/mld_trap_to_PS : trap mld packet original to PS
		if((rg_db.systemGlobal.mld_Trap_to_PS_enable)&&(pPktHdr->ingressLocation==RG_IGR_PHY_PORT)){
			if(pPktHdr->tagif&IPV6_MLD_TAGIF){//mld
				TRACE("[To PS] TRAP mld to PS");
				pPktHdr->byPassToPsVlanAclDecision = 1;
				ret = RG_FWDENGINE_RET_TO_PS;
			}
		}

		//20181227LUKE: forcedly trap Echo request/reply to protocol stack by forcedlyTrapICMPv6Echo
		if(rg_db.systemGlobal.forcedlyTrapICMPv6Echo && (pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK) && (pPktHdr->ICMPv6Type==0x80 || pPktHdr->ICMPv6Type==0x81))
		{
			TRACE("[To PS] TRAP ICMPv6 Echo %s to PS",pPktHdr->ICMPv6Type==0x80?"Request":"Reply");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			ret = RG_FWDENGINE_RET_TO_PS;
		}
	}
	else if(protocol==RG_IP_PROTO_GRE)	//GRE
	{
		tmpOff=8;	//GRE
		pPktHdr->tagif|=GRE_TAGIF;
		pPktHdr->pGRECallID=(u16*)&pData[off+6];
		//DEBUG("flags and version %x, protocol type is %x, len is %x, callID is %x",ntohs(*(u16*)&pData[off]),ntohs(*(u16*)&pData[off+2]),ntohs(*(u16*)&pData[off+4]),ntohs(*pPktHdr->pGRECallID));
		if(ntohs(*(u16*)&pData[off])&0x1000)
		{
			pPktHdr->tagif|=GRE_SEQ_TAGIF;
			pPktHdr->pGRESequence=(u32*)&pData[off+tmpOff];
			pPktHdr->GRESequence=ntohl(*pPktHdr->pGRESequence);
			//DEBUG("sequence is %d",pPktHdr->GRESequence);
			tmpOff+=4;
		}
		if(ntohs(*(u16*)&pData[off])&0x80)
		{
			pPktHdr->tagif|=GRE_ACK_TAGIF;
			pPktHdr->pGREAcknowledgment=(u32*)&pData[off+tmpOff];
			pPktHdr->GREAcknowledgment=ntohl(*pPktHdr->pGREAcknowledgment);
			//DEBUG("ack is %d",pPktHdr->GREAcknowledgment);
			tmpOff+=4;
		}
		//20150420LUKE: check if the Address and Control field be omitted
		if(*(u16*)(pData+off+tmpOff)==htons(0xff03))
			tmpOff+=2;

		if((pPktHdr->tagif&PPTP_INNER_TAGIF)==0)
		{
			for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
			{
				pWan_intf=&rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf;
				if(pWan_intf->wan_intf_conf.wan_type==RTK_RG_PPTP &&
					pPktHdr->ipv4Sip==pWan_intf->pptp_info.before_dial.pptp_ipv4_addr &&
					ntohs(*pPktHdr->pGRECallID)==pWan_intf->pptp_info.after_dial.callId)
				{
					TRACE("Match PPTP WAN[%d]!! update acknowledgment to %d",rg_db.systemGlobal.wanIntfGroup[i].index,pPktHdr->GRESequence);
					pPktHdr->tagif&=(~GRE_TAGIF);
					if(pPktHdr->tagif&GRE_SEQ_TAGIF){
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
						// update gre ack to sync with HW
						rtk_rg_asic_dualHdrInfo_set(FB_DUALHDR_GREACK, rg_db.systemGlobal.wanIntfGroup[i].index, pPktHdr->GRESequence);
#else
						pWan_intf->pptp_info.gre_header_acknowledgment=pPktHdr->GRESequence;
#endif
					}
					//20150617LUKE: from WAN may send to protocol stack, we should change ack to seq stored when protocol stack send packet!
					if(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK){
						if(pPktHdr->tagif&GRE_ACK_TAGIF)
							*pPktHdr->pGREAcknowledgment=htonl(pWan_intf->pptp_info.sw_gre_header_sequence);
						if(pPktHdr->tagif&GRE_SEQ_TAGIF)
							pPktHdr->pServerGRESequence=&pWan_intf->pptp_info.sw_gre_header_server_sequence;
						if(!pWan_intf->pptp_info.sw_gre_header_server_sequence_started){
							pWan_intf->pptp_info.sw_gre_header_server_sequence=pPktHdr->GRESequence;
							pWan_intf->pptp_info.sw_gre_header_server_sequence_started=1;
						}
					}
					off+=tmpOff;
					pPktHdr->tagif|=PPTP_INNER_TAGIF;
					break;
				}
			}
			if(pPktHdr->tagif&PPTP_INNER_TAGIF)goto TUUNEL_INNER;
		}
	}


	return ret;
}

static void _rtk_rg_igmpPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr)
{
	pPktHdr->IGMPType = (ntohs(*(u16*)&pData[off])&0xff00)>>8;

	TRACE("parsing IGMP");

	/*check DVMRP*/
	if (pPktHdr->IGMPType==DVMRP_TYPE && (pPktHdr->ipv4Dip==htonl(DVMRP_ADDR)))
	{
		pPktHdr->tagif|=DVMRP_TAGIF;
	}
	else
	{
		//if(rtl_checkMCastAddrMapping(IP_VERSION4,pPktHdr->pIpv4Dip,pPktHdr->pDmac)==TRUE)
		{
			pPktHdr->tagif|=IGMP_TAGIF;
		}
	}

}

static void _rtk_rg_mospfPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr)
{

	if (pPktHdr->tagif&IPV4_TAGIF)
	{
		TRACE("parsing MOSPFv4");
		if (pPktHdr->ipv4Dip==htonl(IPV4_MOSPF_ADDR1) || pPktHdr->ipv4Dip==htonl(IPV4_MOSPF_ADDR2))
		{
			pPktHdr->tagif|=MOSPF_TAGIF;
		}
	}
	else if (pPktHdr->tagif&IPV6_TAGIF)
	{
		TRACE("parsing MOSPFv6");
		//if (IS_IPV6_MOSPF_ADDR1(ipAddr) || IS_IPV6_MOSPF_ADDR2(ipAddr))
		if ((memcmp(pPktHdr->pIpv6Dip, IPV6_MOSPF_ADDR1, 16))
		||  (memcmp(pPktHdr->pIpv6Dip, IPV6_MOSPF_ADDR2, 16)))
		{
			pPktHdr->tagif|=MOSPF_TAGIF;
		}
	}
}

static void _rtk_rg_pimfPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr)
{

	if (pPktHdr->tagif&IPV4_TAGIF)
	{
		TRACE("parsing PIMv4");
		if (pPktHdr->ipv4Dip==htonl(IPV4_PIM_ADDR))
		{
			pPktHdr->tagif|=PIM_TAGIF;
		}
	}
	else if (pPktHdr->tagif&IPV6_TAGIF)
	{
		TRACE("parsing PIMv6");
		//if (IS_IPV6_PIM_ADDR(ipAddr))
		if (memcmp(pPktHdr->pIpv6Dip,IPV6_PIM_ADDR,16))
		{
			pPktHdr->tagif|=PIM_TAGIF;
		}
	}

}

void _rtk_rg_mldPacketParser(int off, u8 *pData, rtk_rg_pktHdr_t *pPktHdr)
{
	pPktHdr->tagif|=IPV6_MLD_TAGIF;
	pPktHdr->IGMPv6Type = pPktHdr->ICMPv6Type;
	switch (pPktHdr->IGMPv6Type)
	{
	case 130:
		TRACE("got ICMPv6/MLDv1-Query");
		break;
	case 131:
		TRACE("got ICMPv6/MLDv1-Report");
		break;
	case 132:
		TRACE("got ICMPv6/MLDv1-Done");
		break;
	case 143:
		TRACE("got ICMPv6/MLDv2-Report");
		break;
	default :
		TRACE("Unknown Error for MLD type");
		break;
	}
 	//rtl_checkMCastAddrMapping(IP_VERSION6, (uint32*)pPktHdr->pIpv6Dip, pData);

}

rtk_rg_successFailReturn_t _rtk_rg_algCheckEnable(unsigned char isTCP, unsigned short checkPort)
{
	int algIdx=checkPort>>5;

	//DEBUG("the algIdx is %d, TCPPortEnable is %x, algbitvalue is %x",
		//algIdx,rg_db.algTcpExternPortEnabled[algIdx],algBitValue);

	if(isTCP)
	{
		if(rg_test_bit(checkPort&0x1f,(void *)&rg_db.algTcpExternPortEnabled[algIdx]))
		{
			//DEBUG("the TCP port %d has enabled ALG!!",checkPort);
			return RG_RET_SUCCESS;
		}
	}
	else
	{
		if(rg_test_bit(checkPort&0x1f,(void *)&rg_db.algUdpExternPortEnabled[algIdx]))
		{
			//DEBUG("the UDP port %d is ALG enabled!!",checkPort);
			return RG_RET_SUCCESS;
		}
	}

	return RG_RET_FAIL;
}

rtk_rg_successFailReturn_t _rtk_rg_algSrvInLanCheckEnable(unsigned char isTCP, unsigned short checkPort)
{
	int algIdx=checkPort>>5;

	//DEBUG("the algIdx is %d, TCPPortEnable is %x, algbitvalue is %x",
		//algIdx,rg_db.algTcpExternPortEnabled[algIdx],algBitValue);

	if(isTCP)
	{
		if(rg_test_bit(checkPort&0x1f,(void *)&rg_db.algTcpExternPortEnabled_SrvInLan[algIdx]))
		{
			//DEBUG("the TCP port %d has enabled ALG when Server In LAN!!",checkPort);
			return RG_RET_SUCCESS;
		}
	}
	else
	{
		if(rg_test_bit(checkPort&0x1f,(void *)&rg_db.algUdpExternPortEnabled_SrvInLan[algIdx]))
		{
			//DEBUG("the UDP port %d has enabled ALG when Server In LAN!!",checkPort);
			return RG_RET_SUCCESS;
		}
	}

	return RG_RET_FAIL;
}

void _rtk_rg_algDynamicPortCheck(rtk_rg_pktHdr_t *pPktHdr, int checkPort, int isTCP, int serverInLan)
{
	rtk_rg_alg_dynamicPort_t *pList;

	//Check Dynamic Port first!!
	//------------------ Critical Section start -----------------------//
	rg_lock(&rg_kernel.algDynamicLock);
	if(!list_empty(&rg_db.algDynamicCheckListHead))
	{
		list_for_each_entry(pList,&rg_db.algDynamicCheckListHead,alg_list)
		{
			if(pList->portNum==checkPort && pList->isTCP==isTCP && pList->serverInLan==serverInLan)
			{
				if(pList->algFun!=NULL)
				{
					DEBUG("Hit %s %d for serverIn%s dynamic ALG!! funtion is %p",isTCP?"TCP":"UDP",checkPort,serverInLan==1?"LAN":"WAN",pList->algFun);
					pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
				}
				else
				{
					DEBUG("Hit %s %d for serverIn%s dynamic ALG!! funtion is NULL",isTCP?"TCP":"UDP",checkPort,serverInLan==1?"LAN":"WAN");
					pPktHdr->algAction=RG_ALG_ACT_TO_PS;
				}

				pPktHdr->algRegFun=pList->algFun;
				break;
			}
		}
	}
	//------------------ Critical Section End -----------------------//
	rg_unlock(&rg_kernel.algDynamicLock);

}

rtk_rg_fwdEngineReturn_t _rtk_rg_algFunctionCheck(rtk_rg_naptDirection_t direct, rtk_rg_pktHdr_t *pPktHdr, uint8 serverInLan)
{
	int i,checkPort,checkPort_SrvInLan;
	unsigned int checkSetting;

	if(direct == NAPT_DIRECTION_OUTBOUND)
	{
		checkPort_SrvInLan=pPktHdr->sport;
		checkPort=pPktHdr->dport;
	}
	else	//NAPT_DIRECTION_INBOUND
	{
		checkPort_SrvInLan=pPktHdr->dport;
		checkPort=pPktHdr->sport;
	}

	//**** If the ALG register function is NULL, and the ALG is turn on, we will trap this packet to protocol stack directly.

	//DEBUG("%s packet, the mask is %x, check port is %d, check port in LAN is %d",pPktHdr->tagif&TCP_TAGIF?"TCP":"UDP",rg_db.algFunctionMask,checkPort,checkPort_SrvInLan);

	//initial algAction
	pPktHdr->algAction=RG_ALG_ACT_NORMAL;

	if(pPktHdr->tagif&TCP_TAGIF)
	{
		if(serverInLan==0 && _rtk_rg_algCheckEnable(1,checkPort)==SUCCESS)
		{
			pPktHdr->algAction=RG_ALG_ACT_NORMAL;
			_rtk_rg_algDynamicPortCheck(pPktHdr,checkPort,1,0);
			if(pPktHdr->algAction!=RG_ALG_ACT_NORMAL)
				goto ALG_DYNAMIC_RET;

			//DEBUG("Port %d enable!!",checkPort);
			//do the matching alg hook function
			//20130806 Luke:
			//Since SrvInWan will check before SrvInLan,
			//if this packet hit SrvInWan here, it will use SrvInWan's register function correctly,
			//therefore it doesn't need to change!!
			checkSetting=rg_db.algFunctionMask;
			i=ffs(checkSetting);
			while(i--){
				if(rg_db.algTcpFunctionMapping[i].portNum==checkPort){
					DEBUG("TCP before execute function...%x, port %d, isNULL?%s",0x1<<i,rg_db.algTcpFunctionMapping[i].portNum,rg_db.algTcpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
					if(rg_db.algTcpFunctionMapping[i].registerFunction!=NULL)
						pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
					else
						pPktHdr->algAction=RG_ALG_ACT_TO_PS;
					pPktHdr->algRegFun=rg_db.algTcpFunctionMapping[i].registerFunction;
					pPktHdr->algKeepExtPort=rg_db.algTcpFunctionMapping[i].keepExtPort;

					return RG_FWDENGINE_RET_CONTINUE;
				}else{
					checkSetting&=(~(0x1<<i));
					i=ffs(checkSetting);
				}
			}

			//algPort enable but no hit any register function mask, goto slow path without add to shortcut!!
			pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
			//pPktHdr->algFunctionMappingIdx=-1;
			pPktHdr->algRegFun=NULL;
		}
		if(serverInLan==1 && _rtk_rg_algSrvInLanCheckEnable(1,checkPort_SrvInLan)==SUCCESS)
		{
			pPktHdr->algAction=RG_ALG_ACT_NORMAL;
			_rtk_rg_algDynamicPortCheck(pPktHdr,checkPort_SrvInLan,1,1);
			if(pPktHdr->algAction!=RG_ALG_ACT_NORMAL)
				goto ALG_DYNAMIC_RET;

			//DEBUG("Port %d enable in SrvInLan!!",checkPort_SrvInLan);
			//do the matching alg hook function
			checkSetting=((rg_db.algFunctionMask>>ALG_SRV_IN_LAN_IDX)<<ALG_SRV_IN_LAN_IDX);
			i=ffs(checkSetting);
			while(i--){
				if(rg_db.algTcpFunctionMapping[i].portNum==checkPort_SrvInLan){
					DEBUG("TCP SrvInLAN before execute function...%x, port %d, isNULL?%s",0x1<<i,rg_db.algTcpFunctionMapping[i].portNum,	rg_db.algTcpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
					if(rg_db.algTcpFunctionMapping[i].registerFunction!=NULL)
						pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
					else
						pPktHdr->algAction=RG_ALG_ACT_TO_PS;
					pPktHdr->algRegFun=rg_db.algTcpFunctionMapping[i].registerFunction;
					pPktHdr->algKeepExtPort=rg_db.algTcpFunctionMapping[i].keepExtPort;

					return RG_FWDENGINE_RET_CONTINUE;
				}else{
					checkSetting&=(~(0x1<<i));
					i=ffs(checkSetting);
				}
			}

			//algPort enable but no hit any register function mask, goto slow path without add to shortcut!!
			pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
			//pPktHdr->algFunctionMappingIdx=-1;
			pPktHdr->algRegFun=NULL;
		}
	}
	else if(pPktHdr->tagif&UDP_TAGIF)
	{
		if(serverInLan==0 && _rtk_rg_algCheckEnable(0,checkPort)==SUCCESS)
		{
			pPktHdr->algAction=RG_ALG_ACT_NORMAL;
			_rtk_rg_algDynamicPortCheck(pPktHdr,checkPort,0,0);
			if(pPktHdr->algAction!=RG_ALG_ACT_NORMAL)
				goto ALG_DYNAMIC_RET;

			//DEBUG("UDP Port %d enable!!",checkPort);
			//do the matching alg hook function
			checkSetting=rg_db.algFunctionMask;
			i=ffs(checkSetting);
			while(i--){
				if(rg_db.algUdpFunctionMapping[i].portNum==checkPort){
					DEBUG("UDP before execute function...%x, port %d, isNULL?%s",0x1<<i,rg_db.algUdpFunctionMapping[i].portNum,rg_db.algUdpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
					if(rg_db.algUdpFunctionMapping[i].registerFunction!=NULL)
						pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
					else
						pPktHdr->algAction=RG_ALG_ACT_TO_PS;
					pPktHdr->algRegFun=rg_db.algUdpFunctionMapping[i].registerFunction;
					pPktHdr->algKeepExtPort=rg_db.algUdpFunctionMapping[i].keepExtPort;

					return RG_FWDENGINE_RET_CONTINUE;
				}else{
					checkSetting&=(~(0x1<<i));
					i=ffs(checkSetting);
				}
			}

			//algPort enable but no hit any register function mask, goto slow path without add to shortcut!!
			pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
			//pPktHdr->algFunctionMappingIdx=-1;
			pPktHdr->algRegFun=NULL;
		}
		if(serverInLan==1 && _rtk_rg_algSrvInLanCheckEnable(0,checkPort_SrvInLan)==SUCCESS)
		{
			pPktHdr->algAction=RG_ALG_ACT_NORMAL;
			_rtk_rg_algDynamicPortCheck(pPktHdr,checkPort_SrvInLan,0,1);
			if(pPktHdr->algAction!=RG_ALG_ACT_NORMAL)
				goto ALG_DYNAMIC_RET;

			//DEBUG("UDP Port %d enable in SrvInLan!!",checkPort_SrvInLan);
			//do the matching alg hook function
			checkSetting=((rg_db.algFunctionMask>>ALG_SRV_IN_LAN_IDX)<<ALG_SRV_IN_LAN_IDX);
			i=ffs(checkSetting);
			while(i--){
				if(rg_db.algUdpFunctionMapping[i].portNum==checkPort_SrvInLan){
					DEBUG("UDP SrvInLAN before execute function...%x, port %d, isNULL?%s",0x1<<i,rg_db.algUdpFunctionMapping[i].portNum,rg_db.algUdpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
					if(rg_db.algUdpFunctionMapping[i].registerFunction!=NULL)
						pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
					else
						pPktHdr->algAction=RG_ALG_ACT_TO_PS;
					pPktHdr->algRegFun=rg_db.algUdpFunctionMapping[i].registerFunction;
					pPktHdr->algKeepExtPort=rg_db.algUdpFunctionMapping[i].keepExtPort;

					return RG_FWDENGINE_RET_CONTINUE;
				}else{
					checkSetting&=(~(0x1<<i));
					i=ffs(checkSetting);
				}
			}

			//algPort enable but no hit any register function mask, goto slow path without add to shortcut!!
			pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
			//pPktHdr->algFunctionMappingIdx=-1;
			pPktHdr->algRegFun=NULL;
		}
	}

ALG_DYNAMIC_RET:
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineAlgReturn_t _rtk_rg_algForward(int direct, u8 after, struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_fwdEngineAlgReturn_t ret=RG_FWDENGINE_ALG_RET_FAIL;
#if 0
	int i,checkPort,checkPort_SrvInLan;
	unsigned int checkSetting;

	if(direct == NAPT_DIRECTION_OUTBOUND)
	{
		checkPort_SrvInLan=pPktHdr->sport;
		checkPort=pPktHdr->dport;
	}
	else
	{
		checkPort_SrvInLan=pPktHdr->dport;
		checkPort=pPktHdr->sport;
	}
#endif


	//DEBUG("%s packet, the mask is %x, check port is %d",pPktHdr->tagif&TCP_TAGIF?"TCP":"UDP",checkSetting,checkPort);

	//Check ServerInWAN and Passthrough first, then check ServerInLAN:
	if(pPktHdr->tagif&TCP_TAGIF)
	{
		if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE && pPktHdr->algRegFun!=NULL)
		{
			DEBUG("do the TCP register function %p",pPktHdr->algRegFun);
			ret = pPktHdr->algRegFun(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
		}
//20130814LUKE:Close it for normal packet can bypass
#if 0
		else
		{
			//siyuan add for alg h323
			ret = rtk_rg_alg_expect_forward(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
		}
#endif
#if 0
		if(_rtk_rg_algCheckEnable(1,checkPort)==SUCCESS)
		{
			//DEBUG("Port %d enable!!",checkPort);
			//do the matching alg hook function
			checkSetting=rg_db.algFunctionMask;
			i=0;
			while(checkSetting>0 || i<MAX_ALG_FUNCTIONS)
			{
				//DEBUG("TCP before execute function...%d, port %d, isNULL?%s",(rg_db.algFunctionMask&(0x1<<i)),rg_db.algTcpFunctionMapping[i].portNum,	rg_db.algTcpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
				if(((rg_db.algFunctionMask&(0x1<<i))>0) &&
					(rg_db.algTcpFunctionMapping[i].portNum==checkPort) &&
					(rg_db.algTcpFunctionMapping[i].registerFunction!=NULL))
				{
					//DEBUG("do the register function[%d]!%p",i,rg_db.algTcpFunctionMapping[i].registerFunction);
					ret = rg_db.algTcpFunctionMapping[i].registerFunction(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
					break;
				}
				else
				{
					//check next
					checkSetting>>=1;
					i++;
				}
			}
		}
		if(_rtk_rg_algSrvInLanCheckEnable(1,checkPort_SrvInLan)==SUCCESS)
		{
			//do the matching alg hook function
			checkSetting=rg_db.algFunctionMask;
			i=0;
			while(checkSetting>0 || i<MAX_ALG_FUNCTIONS)
			{
				//DEBUG("TCP SrvInLAN before execute function...%d, port %d, isNULL?%s",(rg_db.algFunctionMask&(0x1<<i)),rg_db.algTcpFunctionMapping[i].portNum,	rg_db.algTcpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
				if(((rg_db.algFunctionMask&(0x1<<i))>0) &&
					(rg_db.algTcpFunctionMapping[i].portNum==checkPort_SrvInLan) &&
					(rg_db.algTcpFunctionMapping[i].registerFunction!=NULL))
				{
					//DEBUG("do the register function[%d]!%p",i,rg_db.algTcpFunctionMapping[i].registerFunction);
					ret = rg_db.algTcpFunctionMapping[i].registerFunction(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
					break;
				}
				else
				{
					//check next
					checkSetting>>=1;
					i++;
				}
			}
		}
#endif
	}
	else if(pPktHdr->tagif&UDP_TAGIF)
	{
		if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE && pPktHdr->algRegFun!=NULL)
		{
			DEBUG("do the UDP register function %p",pPktHdr->algRegFun);
			ret = pPktHdr->algRegFun(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
		}
//20130814LUKE:Close it for normal packet can bypass
#if 0
		else
		{
			//siyuan add for alg h323
			ret = rtk_rg_alg_expect_forward(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
		}
#endif
#if 0
		if(_rtk_rg_algCheckEnable(0,checkPort)==SUCCESS)
		{
			//do the matching alg hook function
			checkSetting=rg_db.algFunctionMask;
			i=0;
			while(checkSetting>0 || i<MAX_ALG_FUNCTIONS)
			{
				//DEBUG("UDP before execute function...%d, port %d, isNULL?%s",(rg_db.algFunctionMask&(0x1<<i)),rg_db.algUdpFunctionMapping[i].portNum,rg_db.algUdpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
				if(((rg_db.algFunctionMask&(0x1<<i))>0) &&
					(rg_db.algUdpFunctionMapping[i].portNum==checkPort) &&
					(rg_db.algUdpFunctionMapping[i].registerFunction!=NULL))
				{
					ret = rg_db.algUdpFunctionMapping[i].registerFunction(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
					break;
				}
				else
				{
					//check next
					checkSetting>>=1;
					i++;
				}
			}
		}
		if(_rtk_rg_algSrvInLanCheckEnable(0,checkPort_SrvInLan)==SUCCESS)
		{
			//do the matching alg hook function
			checkSetting=rg_db.algFunctionMask;
			i=0;
			while(checkSetting>0 || i<MAX_ALG_FUNCTIONS)
			{
				//DEBUG("UDP SrvInLAN before execute function...%d, port %d, isNULL?%s",(rg_db.algFunctionMask&(0x1<<i)),rg_db.algUdpFunctionMapping[i].portNum,rg_db.algUdpFunctionMapping[i].registerFunction!=NULL?"NO":"YES");
				if(((rg_db.algFunctionMask&(0x1<<i))>0) &&
					(rg_db.algUdpFunctionMapping[i].portNum==checkPort_SrvInLan) &&
					(rg_db.algUdpFunctionMapping[i].registerFunction!=NULL))
				{
					ret = rg_db.algUdpFunctionMapping[i].registerFunction(direct,after,(unsigned char *)skb,(unsigned char *)pPktHdr);
					break;
				}
				else
				{
					//check next
					checkSetting>>=1;
					i++;
				}
			}
		}
#endif
	}

	if(ret!=RG_FWDENGINE_ALG_RET_FAIL)
	{
		TRACE("ALG FINISHED..ret=%d",ret);
	}
	return ret;
}

//20130821LUKE:close it because implemented by separate module
#if 0
rtk_rg_pptpGreEntry_t *_rtk_rg_lookupPPTPOutboundGreFlow(int netifIdx, unsigned int internalIp,unsigned short internalCallID, unsigned int remoteIp)
{
	rtk_rg_pptpGreLinkList_t *pEntry=NULL;

	for (pEntry = rg_db.pPPTPGreOutboundHead[netifIdx]->pPrev; pEntry != rg_db.pPPTPGreOutboundHead[netifIdx]; pEntry = pEntry->pPrev)
	{
		if((pEntry->greEntry.valid==1) &&
			(pEntry->greEntry.internalIpAddr==internalIp)&&
			(pEntry->greEntry.internalCallID==internalCallID)&&
			(pEntry->greEntry.remoteIpAddr==remoteIp))
			break;
	}
	if(pEntry == rg_db.pPPTPGreOutboundHead[netifIdx])		//not found
		return NULL;

	return &pEntry->greEntry;
}

rtk_rg_pptpGreEntry_t *_rtk_rg_lookupPPTPOutboundGreFlowByCallID(int netifIdx, unsigned short externalCallID, unsigned short remoteCallID, unsigned int remoteIp)
{
	rtk_rg_pptpGreLinkList_t *pEntry=NULL;

	for (pEntry = rg_db.pPPTPGreOutboundHead[netifIdx]->pPrev; pEntry != rg_db.pPPTPGreOutboundHead[netifIdx]; pEntry = pEntry->pPrev)
	{
		if(pEntry->greEntry.valid==1 &&
			pEntry->greEntry.remoteIpAddr==remoteIp &&
			((externalCallID>=0 && (pEntry->greEntry.externalCallID==externalCallID)) ||
			(remoteCallID>=0 && (pEntry->greEntry.remoteCallID==remoteCallID))))
			break;
	}
	if(pEntry == rg_db.pPPTPGreOutboundHead[netifIdx])		//not found
		return NULL;

	return &pEntry->greEntry;
}

int _rtk_rg_PPTPExtCallIDGetAndUse(uint16 wishCallID)
{
	int wishIdx;
	uint32 wishBitValue;
	int i;

	i=wishCallID;
	while(1)
	{
		wishIdx=i>>5; // =wishCallID/32
		wishBitValue=1<<(i&0x1f);

		if((rg_db.algPPTPExtCallIDEnabled[wishIdx]&wishBitValue)==0)
		{
			//DEBUG("callID %d is set!",i);
			rg_db.algPPTPExtCallIDEnabled[wishIdx]|=wishBitValue;
			return i;
		}

		i++;
		i&=0xffff;
		if(i==wishCallID) break;
	}
	return RG_RET_FAIL;
}

void _rtk_rg_PPTPExtCallIDFree(int callID)
{
	int idx;
	uint32 bitValue;
	int i;

	i=callID;
	idx=i>>5; // =callID/32
	bitValue=1<<(i&0x1f);

	if((rg_db.algPPTPExtCallIDEnabled[idx]&bitValue)>0)
		rg_db.algPPTPExtCallIDEnabled[idx]&=(~bitValue);
}

int _rtk_rg_PPTP_GREModify(rtk_rg_naptDirection_t direct, struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	int ret;
	rtk_rg_pptpGreEntry_t *pGreEntry;

	if(((rg_db.algFunctionMask & RTK_RG_ALG_PPTP_TCP_PASSTHROUGH_BIT) > 0 && rg_db.algTcpFunctionMapping[RTK_RG_ALG_PPTP_TCP_PASSTHROUGH].registerFunction!=NULL) ||
		((rg_db.algFunctionMask & RTK_RG_ALG_PPTP_UDP_PASSTHROUGH_BIT) > 0 && rg_db.algUdpFunctionMapping[RTK_RG_ALG_PPTP_UDP_PASSTHROUGH].registerFunction!=NULL))
	{
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			//DEBUG("$$$$ PPTP_GREModify:  OUTBOUND packet to WAN[%d], orig SIP is %x",pPktHdr->netifIdx,pPktHdr->ipv4Sip);

			//lookup flow from remoteCallID
			pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktHdr->netifIdx,-1,ntohs(*pPktHdr->pGRECallID),pPktHdr->ipv4Dip);
			if(pGreEntry!=NULL)
			{
				//Turn on action to prevent adding to shortCut
				pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,0, pPktHdr,skb,1,0);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				//DEBUG("SIP change to %x",ntohl(*pPktHdr->pIpv4Sip));

				return RG_FWDENGINE_RET_DIRECT_TX;
			}
		}
		else
		{
			//DEBUG("$$$$ PPTP_GREModify:  INBOUND packet from WAN[%d], orig DIP is %x",pPktHdr->netifIdx,pPktHdr->ipv4Dip);

			//lookup DIP from CallID in key(ExtCallID)
			pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktHdr->netifIdx,ntohs(*pPktHdr->pGRECallID),-1,pPktHdr->ipv4Sip);		//peer's CallID is the external CallID
			if(pGreEntry!=NULL)
			{
				//Turn on action to prevent adding to shortCut
				pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;

				//Change DIP to internal IP
				*pPktHdr->pIpv4Dip=htonl(pGreEntry->internalIpAddr);
				pPktHdr->ipv4Dip=pGreEntry->internalIpAddr;

				//Change CallID in key to IntCallID
				*pPktHdr->pGRECallID=htons(pGreEntry->internalCallID);

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,0,pPktHdr,skb,0,0);
				//dump_packet(skb->data,skb->len,"new");
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				//DEBUG("DIP change to %x, callID change to %x",pGreEntry->internalIpAddr,pGreEntry->internalCallID);

				return RG_FWDENGINE_RET_DIRECT_TX;
			}
		}
	}

	return RG_FWDENGINE_RET_TO_PS;
}

int _rtk_rg_algRegFunc_TCP_PPTP(int direct, int after, unsigned char *pSkb,unsigned char *pPktHdr)
{
//FIXME:here should be rewrite for model code
#ifdef __KERNEL__
	rtk_rg_pktHdr_t *pPktInfo;
	struct sk_buff *skb;
	rtk_rg_pptpGreEntry_t *pGreEntry;
	int usableCallID=-1;

	pPktInfo=(rtk_rg_pktHdr_t *)pPktHdr;
	skb=(struct sk_buff *)pSkb;

	if((pPktInfo->tagif&PPTP_TAGIF)==0)		//not PPTP packet
		return RG_RET_FAIL;
/*
	PPTP_StartCtrlConnRequest	= 1,
	PPTP_StartCtrlConnReply 	= 2,
	PPTP_StopCtrlConnRequest	= 3,
	PPTP_StopCtrlConnReply	= 4,
	PPTP_EchoRequest			= 5,
	PPTP_EchoReply			= 6,
	PPTP_OutCallRequest 		= 7,
	PPTP_OutCallReply			= 8,
	PPTP_InCallRequest		= 9,
	PPTP_InCallReply			= 10,
	PPTP_InCallConn 			= 11,
	PPTP_CallClearRequest		= 12,
	PPTP_CallDiscNotify 		= 13,
	PPTP_WanErrorNotify 		= 14,
	PPTP_SetLinkInfo			= 15
*/

	if(after==0)
	{
		//Pre function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			switch(pPktInfo->pptpCtrlType)
			{
				case PPTP_OutCallRequest:
					//find ExtCallID for use
					//Keep internalIpAddr and MAC
					//Keep internalCallID
					DEBUG("$$$$ PRE PPTP_OutCallRequest  pPktInfo->netifIdx is %d",pPktInfo->netifIdx);
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlow(pPktInfo->netifIdx,pPktInfo->ipv4Sip,pPktInfo->pPptpCallId->cid1,pPktInfo->ipv4Dip);
					if(pGreEntry==NULL)
					{
						usableCallID=_rtk_rg_PPTPExtCallIDGetAndUse(pPktInfo->pPptpCallId->cid1);
						if(usableCallID==RG_RET_FAIL)
						{
							DEBUG("PPTP_OutCallRequest: Thers is no usable CallID now...");
							return RG_RET_FAIL;
						}
						//Setup this entry
						pGreEntry=&rg_db.pPPTPGreOutboundHead[pPktInfo->netifIdx]->greEntry;

						bzero(pGreEntry,sizeof(rtk_rg_pptpGreEntry_t));
						pGreEntry->internalIpAddr=pPktInfo->ipv4Sip;
						memcpy(pGreEntry->internalMacAddr.octet,pPktInfo->pSmac,ETHER_ADDR_LEN);
						pGreEntry->remoteIpAddr=pPktInfo->ipv4Dip;
						pGreEntry->internalCallID=pPktInfo->pPptpCallId->cid1;
						//Find out usable extCallID and keep it in greEntry
						pGreEntry->externalCallID=usableCallID;
						pGreEntry->valid=1;
						DEBUG("@@@the GreEntry has been set in PRE:internalIP=%08x, internalMac=%02x:%02x:%02x:%02x:%02x:%02x, internalCallID is %d, externalCallID is %d",
							pGreEntry->internalIpAddr,
							pGreEntry->internalMacAddr.octet[0],
							pGreEntry->internalMacAddr.octet[1],
							pGreEntry->internalMacAddr.octet[2],
							pGreEntry->internalMacAddr.octet[3],
							pGreEntry->internalMacAddr.octet[4],
							pGreEntry->internalMacAddr.octet[5],
							pGreEntry->internalCallID,pGreEntry->externalCallID);

						rg_db.pPPTPGreOutboundHead[pPktInfo->netifIdx]=rg_db.pPPTPGreOutboundHead[pPktInfo->netifIdx]->pNext;
					}

					//Replace internal CallID to external CallID
					pPktInfo->pPptpCallId->cid1=pGreEntry->externalCallID;
					break;
				case PPTP_CallClearRequest:
					DEBUG("$$$$ PRE PPTP_CallClearRequest  pPktInfo->netifIdx is %d",pPktInfo->netifIdx);
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlow(pPktInfo->netifIdx,pPktInfo->ipv4Sip,pPktInfo->pPptpCallId->cid1,pPktInfo->ipv4Dip);
					if(pGreEntry==NULL)
					{
						DEBUG("PPTP_CallClearRequest: Error..we can not find the GRE entry ..");
						return RG_RET_FAIL;
					}

					//Replace internal CallID to external CallID
					pPktInfo->pPptpCallId->cid1=pGreEntry->externalCallID;
					break;
				default:
					break;
			}

		}
		else
		{
			//INBOUND
			switch(pPktInfo->pptpCtrlType)
			{
				case PPTP_OutCallReply:
					//Keep remoteCallID
					DEBUG("$$$$ PPTP_OutCallReply  pPktInfo->netifIdx is %d",pPktInfo->netifIdx);
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktInfo->netifIdx,pPktInfo->pPptpCallId->cid2,-1,pPktInfo->ipv4Sip);		//peer's CallID
					if(pGreEntry==NULL)
					{
						DEBUG("PPTP_OutCallReply: Error..we can not find the GRE entry from ExternalCallID %d..",pPktInfo->pPptpCallId->cid2);
						return RG_RET_FAIL;
					}
					pGreEntry->remoteCallID=pPktInfo->pPptpCallId->cid1;
					DEBUG("@@@ the GreEntry has been set in PRE:retmoteCallID is %d",pGreEntry->remoteCallID);
					//Replace externalCallID by internalCallID
					pPktInfo->pPptpCallId->cid2=pGreEntry->internalCallID;
					break;
				case PPTP_WanErrorNotify:
					//replace peer's CallID to internalCallID
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktInfo->netifIdx,pPktInfo->pPptpCallId->cid1,-1,pPktInfo->ipv4Sip);		//peer's CallID
					if(pGreEntry==NULL)
					{
						DEBUG("PPTP_WanErrorNotify: Error..we can not find the GRE entry from ExternalCallID %d..",pPktInfo->pPptpCallId->cid1);
						return RG_RET_FAIL;
					}
					//Replace externalCallID by internalCallID
					pPktInfo->pPptpCallId->cid1=pGreEntry->internalCallID;
					break;
				case PPTP_CallDiscNotify:
					//release GRE entry if we receive CallDisconnectNotify from WAN interface
					DEBUG("$$$$ PPTP_CallDiscNotify  pPktInfo->netifIdx is %d",pPktInfo->netifIdx);
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktInfo->netifIdx,-1,pPktInfo->pPptpCallId->cid1,pPktInfo->ipv4Sip);
					if(pGreEntry==NULL)
					{
						DEBUG("PPTP_CallDiscNotify: Error..we can not find the GRE entry from RemoteCallID %d..",pPktInfo->pPptpCallId->cid1);
						return RG_RET_FAIL;
					}
					pGreEntry->valid=0;
					break;
				default:
					break;
			}
		}
	}
	else
	{
		//Post function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			switch(pPktInfo->pptpCtrlType)
			{
				case PPTP_OutCallRequest:
					//use ExtCallID to find match entry
					DEBUG("$$$$ POST PPTP_OutCallRequest  pPktInfo->netifIdx is %d",pPktInfo->netifIdx);
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktInfo->netifIdx,pPktInfo->pPptpCallId->cid1,-1,pPktInfo->ipv4Dip);
					if(pGreEntry==NULL)
					{
						DEBUG("PPTP_OutCallRequest: Error..we can not find the GRE entry from ExternalCallID %d..",pPktInfo->pPptpCallId->cid1);
						return RG_RET_FAIL;
					}
					//Keep remoteIpAddr and MAC
					//pGreEntry->remoteIpAddr=pPktInfo->ipv4Dip;
					memcpy(pGreEntry->remoteMacAddr.octet,pPktInfo->pDmac,ETHER_ADDR_LEN);
					DEBUG("@@@ the GreEntry has been set in PRE:remoteIP is %08x, remoteMac is %02x:%02x:%02x:%02x:%02x:%02x",
						pGreEntry->remoteIpAddr,pGreEntry->remoteMacAddr.octet[0],pGreEntry->remoteMacAddr.octet[1],pGreEntry->remoteMacAddr.octet[2],
						pGreEntry->remoteMacAddr.octet[3],pGreEntry->remoteMacAddr.octet[4],pGreEntry->remoteMacAddr.octet[5]);
					break;
				default:
					break;
			}
		}
		else
		{
			//INBOUND
			switch(pPktInfo->pptpCtrlType)
			{
				case PPTP_CallDiscNotify:
					//release GRE entry if we receive CallDisconnectNotify from LAN interface
					DEBUG("$$$$ PPTP_CallDiscNotify  pPktInfo->netifIdx is %d",pPktInfo->netifIdx);
					pGreEntry=_rtk_rg_lookupPPTPOutboundGreFlowByCallID(pPktInfo->netifIdx,-1,pPktInfo->pPptpCallId->cid1,pPktInfo->ipv4Sip);
					if(pGreEntry==NULL)
					{
						DEBUG("PPTP_CallDiscNotify: Error..we can not find the GRE entry from RemoteCallID %d..",pPktInfo->pPptpCallId->cid1);
						return RG_RET_FAIL;
					}
					pGreEntry->valid=0;
					break;
				default:
					break;
			}
		}
	}

#endif
	return RG_RET_SUCCESS;
}
#endif

#ifdef CONFIG_RG_ROMEDRIVER_ALG_BATTLENET_SUPPORT
rtk_rg_fwdEngineAlgReturn_t _rtk_rg_algRegFunc_TCP_BattleNet(int direct, int after, unsigned char *pSkb,unsigned char *pPktHdr)
{
	rtk_rg_pktHdr_t *pPktInfo;
	unsigned char *pData;
	struct sk_buff *skb;
	int dlen;
	int doff;
	int i;

	skb= (struct sk_buff *)pSkb;
	pData=(unsigned char *)skb->data;
	pPktInfo = (rtk_rg_pktHdr_t *)pPktHdr;

	if(after==1)
	{
		dump_packet(pData,skb->len,"BNCS data[Before]");
		doff = (pPktInfo->l4Offset+pPktInfo->headerLen);
		dlen = skb->len-doff;
		DEBUG("BNCS header offset:%d BNCS data length:%d\n",doff,dlen);
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			//Outbound
			if(pPktInfo->tagif&TCP_TAGIF)
			{
				pData+=doff;
				if(pData[0]==0xff) //Header : BNCS
				{
					if((pData[1]==0x09) || (pData[1]==0x50)) //SID_GETADVLISTEX or SID_AUTH_INFO
					{
						int i;
						for(i=0;i<dlen;i++)
						{
							if(memcmp(&pData[i],(void *)(&pPktInfo->ipv4Sip),4)==0)
							{
								memcpy(&pData[i],pPktInfo->pIpv4Sip,4);
								dump_packet(skb->data,skb->len,"BNCS data[After]");
								break;
							}
						}
					}
				}
			}
		}
		else
		{
			//Inbound
			if(*(pData+doff)==0xff) //Header : BNCS
			{
				if((*(pData+doff+1)==0x09) || (*(pData+doff+1)==0x50)) //SID_GETADVLISTEX or SID_AUTH_INFO
				{
					rtk_rg_upnpConnection_t upnp;
					int upnpIdx;
					for(i=0;i<RTK_RG_MAX_SC_CLIENT;i++)
					{
						if(rg_db.algBnetSCClient[i]==ntohl(*pPktInfo->pIpv4Dip)) break;
						if(rg_db.algBnetSCClient[i]!=0) continue;

						rg_db.algBnetSCClient[i]=ntohl(*pPktInfo->pIpv4Dip);
						memset(&upnp,0,sizeof(rtk_rg_upnpConnection_t));
						upnp.is_tcp=0;
						upnp.valid=1;
						upnp.wan_intf_idx=pPktInfo->netifIdx;
						upnp.gateway_port=6112;
						upnp.local_ip=rg_db.algBnetSCClient[i];
						upnp.local_port=6112;
						upnp.limit_remote_ip=0;
						upnp.limit_remote_port=0;
						upnp.remote_ip=0;
						upnp.remote_port=0;
						upnp.type=UPNP_TYPE_PERSIST;
						upnp.timeout=rg_db.algUserDefinedTimeout[RTK_RG_ALG_BATTLENET_TCP];	//auto time out if the server do not connect to this WAN
						ASSERT_EQ((pf.rtk_rg_upnpConnection_add)(&upnp,&upnpIdx),RT_ERR_RG_OK);
					}
				}
			}
		}
	}
	return RG_FWDENGINE_ALG_RET_SUCCESS;
}
#endif

//LUKE20130816: move to separate ALG file
#if 0
rtk_rg_ftpCtrlFlowEntry_t *_rtk_rg_lookupFTPCtrlFlow(unsigned int internalIp,unsigned short int internalPort, unsigned int remoteIp, unsigned short int remotePort)
{
	rtk_rg_ftpCtrlFlowEntry_t *pEntry=NULL;

	/*DEBUG("the input is %s, int %x,%d ret %x,%d",
		isTcp==1?"TCP":"UDP",
		internalIp,internalPort,
		remoteIp,remotePort);*/

	for (pEntry = rg_db.pAlgFTPCtrlFlowHead->pPrev; pEntry != rg_db.pAlgFTPCtrlFlowHead; pEntry = pEntry->pPrev)
	{
		/*DEBUG("the entry is %s, int %x,%d ret %x,%d",
			pEntry->isTcp==1?"TCP":"UDP",
			pEntry->internalIpAddr,pEntry->internalPort,
			pEntry->remoteIpAddr,pEntry->remotePort);*/
		if((pEntry->internalIpAddr==internalIp)&&
			(pEntry->internalPort==internalPort)&&
			(pEntry->remoteIpAddr==remoteIp)&&
			(pEntry->remotePort==remotePort))
			break;
	}
	if(pEntry == rg_db.pAlgFTPCtrlFlowHead)		//not found
		return NULL;

	return pEntry;
}

int _rtk_rg_algRegFunc_TCP_FTP(int direct, int after, unsigned char *pSkb,unsigned char *pPktHdr)
{
//FIXME:here should be rewrite for model code
#ifdef __KERNEL__
	char *startCP,*endCP,*pData;
	char portString[30]={0};
	unsigned int ipAddr,gwIPAddr;
	int newLen,newDelta;
	unsigned short portNum;
	int dataLen=0,dataOff=0,ret,flowIdx;
	rtk_rg_naptEntry_t naptEntry;
	rtk_rg_pktHdr_t *pPktInfo;
	struct sk_buff *skb;
	rtk_rg_ftpCtrlFlowEntry_t *pFtpCtrlFlow;
	pPktInfo = (rtk_rg_pktHdr_t *)pPktHdr;
	skb= (struct sk_buff *)pSkb;

	pData=skb->data;

	dataOff = pPktInfo->l4Offset + pPktInfo->headerLen;
	//if(pPktInfo->tagif&PPPOE_TAGIF)dataOff+=8;		//shift for pppoe packet
	dataLen = skb->len - dataOff;

	//DEBUG("the l4offset is %d, headerlen is %d, skb->len is %d, dataLen is %d, dataoff is %d",pPktInfo->l4Offset,pPktInfo->headerLen,skb->len,dataLen,dataOff);

	if(after==0)
	{
		//Pre function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			//DEBUG("the data is %x, port is %x",*((unsigned int *)(pData+dataOff)),htonl(FTP_PORT_STR));

			//Check if we had add FTP-flow 5-tuple link list entry
			//if not, add one, set Delta to 0
			//check each list entry, if not add, add
			pFtpCtrlFlow = _rtk_rg_lookupFTPCtrlFlow(pPktInfo->ipv4Sip,pPktInfo->sport,pPktInfo->ipv4Dip,pPktInfo->dport);
			if(pFtpCtrlFlow == NULL)
			{
				//DEBUG("ADD NEW CTRL FLOW of FTP!!DIP is %x, DPORT is %d",pPktInfo->ipv4Dip,pPktInfo->dport);
				//add one
				rg_db.pAlgFTPCtrlFlowHead->remoteIpAddr=pPktInfo->ipv4Dip;
				rg_db.pAlgFTPCtrlFlowHead->internalIpAddr=pPktInfo->ipv4Sip;
				rg_db.pAlgFTPCtrlFlowHead->remotePort=pPktInfo->dport;
				rg_db.pAlgFTPCtrlFlowHead->internalPort=pPktInfo->sport;

				//move to next one
				rg_db.pAlgFTPCtrlFlowHead = rg_db.pAlgFTPCtrlFlowHead->pNext;
			}
			else if((pPktInfo->tcpFlags.syn==1)&&(pPktInfo->tcpFlags.ack==0))	//If the same Ctrl Flow send SYN packet, we need to reset Delta to 0
			{
				//DEBUG("Got SYN at same ctrl-flow..reset Delta!");
				pFtpCtrlFlow->Delta=0;
			}
			else if(pFtpCtrlFlow->Delta != 0)
			{
				*pPktInfo->pTcpSeq=htonl(pPktInfo->tcpSeq + pFtpCtrlFlow->Delta);
				//DEBUG("pre outbound Delta is %d",pFtpCtrlFlow->Delta);
			}
		}
		else
		{
			//Do nothing
		}
	}
	else
	{
		//Post function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			if(dataLen > 0 && *((unsigned int *)(pData+dataOff)) == htonl(FTP_PORT_STR))
			{
				//DEBUG("len is %d, l4offset is %d, headerlen is %d",dataLen,pPktInfo->l4Offset, pPktInfo->headerLen);
				//DEBUG("POST_FUNCTION outbound: i am in _rtk_rg_algRegFunc_TCP_FTP!! data len is %d dport is %d",dataLen,pPktInfo->dport);
				//DEBUG("DATA is:");

				startCP=pData+dataOff+5;		//bypass string "PORT_"
				ipAddr = simple_strtoul(startCP,&endCP,0);

				ipAddr<<=8;

				startCP=endCP+1;
				ipAddr += simple_strtoul(startCP,&endCP,0);

				ipAddr<<=8;

				startCP=endCP+1;
				ipAddr += simple_strtoul(startCP,&endCP,0);

				ipAddr<<=8;

				startCP=endCP+1;
				ipAddr += simple_strtoul(startCP,&endCP,0);

				//DEBUG("the ipAddr is %x",ipAddr);

				startCP=endCP+1;
				portNum = simple_strtoul(startCP,&endCP,0);

				portNum<<=8;

				startCP=endCP+1;
				portNum += simple_strtoul(startCP,&endCP,0);

				//DEBUG("the port is %d",portNum);

				gwIPAddr=ntohl(*pPktInfo->pIpv4Sip);
				snprintf(portString,sizeof(portString),"PORT %d,%d,%d,%d,%d,%d\r\n",
					(gwIPAddr>>24)&0xff,
					(gwIPAddr>>16)&0xff,
					(gwIPAddr>>8)&0xff,
					gwIPAddr&0xff,
					portNum>>8,
					portNum&0xff);

				//DEBUG("the modified port command is \"%s\"",portString);
				//DEBUG("data before len is %d, after is %d",dataLen,strlen(portString));

				newLen=strlen(portString);
				newDelta=(newLen-dataLen);
				//DEBUG("the newDelta is %d",newDelta);

				if(skb->tail+newDelta > skb->end)
				{
					//need to re-alloc skb data structure
					FIXME("Overflow! we need to re-alloc skb data stucture...");
				}
				else
				{
					//copy the new string into skb and enlarge or shrink the length
					memcpy(skb->data+dataOff,portString,newLen);

					//fix packet length
					//DEBUG("sip is %x, sport is %d",pPktInfo->ipv4Sip,pPktInfo->sport);
					if(newDelta != 0)
					{
						skb->len += newDelta;
						*pPktInfo->pL3Len=htons(pPktInfo->l3Len + newDelta);
					}
				}

				pFtpCtrlFlow = _rtk_rg_lookupFTPCtrlFlow(pPktInfo->ipv4Sip,pPktInfo->sport,pPktInfo->ipv4Dip,pPktInfo->dport);
				if(pFtpCtrlFlow!=NULL)pFtpCtrlFlow->Delta+=newDelta;

				//Add to napt connection here
				bzero(&naptEntry,sizeof(naptEntry));
				naptEntry.is_tcp=1;
				naptEntry.local_ip=pPktInfo->ipv4Sip;
				naptEntry.remote_ip=pPktInfo->ipv4Dip;
				naptEntry.local_port=portNum;
				naptEntry.remote_port=RTK_RG_ALG_FTP_DATA_TCP_PORT;
				naptEntry.external_port=portNum;
				naptEntry.wan_intf_idx=pPktInfo->extipIdx;
				ret = rtk_rg_naptConnection_add(&naptEntry,&flowIdx);
				if(ret!=RT_ERR_RG_OK && ret!=RT_ERR_RG_NAPT_FLOW_DUPLICATE)
					assert_ok(ret);
			}
		}
		else
		{
			pFtpCtrlFlow = _rtk_rg_lookupFTPCtrlFlow(ntohl(*pPktInfo->pIpv4Dip),ntohs(*pPktInfo->pDport),pPktInfo->ipv4Sip,pPktInfo->sport);

			if(pFtpCtrlFlow != NULL && pFtpCtrlFlow->Delta != 0)
			{
				//DEBUG("post inbound Delta is %d, old ack is %x",pFtpCtrlFlow->Delta,*pPktInfo->pTcpAck);
				*pPktInfo->pTcpAck=htonl(pPktInfo->tcpAck - pFtpCtrlFlow->Delta);
				//DEBUG("new ack is %x",*pPktInfo->pTcpAck);
			}
		}
	}
#endif
	return RG_RET_SUCCESS;
}


int _rtk_rg_algSrvInLanRegFunc_TCP_FTP(int direct, int after, unsigned char *pSkb,unsigned char *pPktHdr)
{
//FIXME:here should be rewrite for model code
#ifdef __KERNEL__
	char *startCP,*endCP,*pData;
	char portString[60]={0};
	unsigned int ipAddr,gwIPAddr;
	int i,newLen,newDelta;
	unsigned short portNum,newPort;
	int dataLen=0,dataOff=0,ret;//,flowIdx;
	//rtk_rg_naptEntry_t naptEntry;
	rtk_rg_pktHdr_t *pPktInfo;
	struct sk_buff *skb;
	rtk_rg_ftpCtrlFlowEntry_t *pFtpCtrlFlow;
	rtk_rg_upnpConnection_t upnpConn;


	pPktInfo = (rtk_rg_pktHdr_t *)pPktHdr;
	skb= (struct sk_buff *)pSkb;

	pData=skb->data;

	dataOff = pPktInfo->l4Offset + pPktInfo->headerLen;
	//if(pPktInfo->tagif&PPPOE_TAGIF)dataOff+=8;		//shift for pppoe packet
	dataLen = skb->len - dataOff;

	//DEBUG("the l4offset is %d, headerlen is %d, skb->len is %d, dataLen is %d, dataoff is %d",pPktInfo->l4Offset,pPktInfo->headerLen,skb->len,dataLen,dataOff);

	if(after==0)
	{
		//Pre function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			pFtpCtrlFlow = _rtk_rg_lookupFTPCtrlFlow(pPktInfo->ipv4Sip,pPktInfo->sport,pPktInfo->ipv4Dip,pPktInfo->dport);

			if(pFtpCtrlFlow != NULL && pFtpCtrlFlow->Delta != 0)
			{
				*pPktInfo->pTcpSeq=htonl(pPktInfo->tcpSeq + pFtpCtrlFlow->Delta);
				//DEBUG("post outbound Delta is %d",pFtpCtrlFlow->Delta);
			}
		}
		else
		{
			//Do nothing
		}
	}
	else
	{
		//Post function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			if(dataLen > 0 && *((unsigned int *)(pData+dataOff)) == htonl(FTP_PASV_RESP_STR))		//"227_"
			{
				//DEBUG("len is %d, l4offset is %d, headerlen is %d",dataLen,pPktInfo->l4Offset, pPktInfo->headerLen);
				//DEBUG("POST_FUNCTION outbound: i am in _rtk_rg_algSrvInLanRegFunc_TCP_FTP!! data len is %d dport is %d",dataLen,pPktInfo->dport);
				//DEBUG("DATA is:");

				startCP=pData+dataOff+27;	//bypass string "227_Entering_Passive_Mode_("
				ipAddr = simple_strtoul(startCP,&endCP,0);

				ipAddr<<=8;

				startCP=endCP+1;
				ipAddr += simple_strtoul(startCP,&endCP,0);

				ipAddr<<=8;

				startCP=endCP+1;
				ipAddr += simple_strtoul(startCP,&endCP,0);

				ipAddr<<=8;

				startCP=endCP+1;
				ipAddr += simple_strtoul(startCP,&endCP,0);

				//DEBUG("the ipAddr is %x",ipAddr);

				startCP=endCP+1;
				portNum = simple_strtoul(startCP,&endCP,0);

				portNum<<=8;

				startCP=endCP+1;
				portNum += simple_strtoul(startCP,&endCP,0);

				//DEBUG("the port is %d",portNum);

				//Chekc if the external port could be used or not
				newPort=_rtk_rg_extPort_get(1,portNum);
				if(newPort==RG_RET_FAIL) return RG_RET_SUCCESS;

				//DEBUG("the new port is %d",newPort);

				gwIPAddr=ntohl(*pPktInfo->pIpv4Sip);
				snprintf(portString,sizeof(portString),"227 Entering Passive Mode (%d,%d,%d,%d,%d,%d)\r\n",
					(gwIPAddr>>24)&0xff,
					(gwIPAddr>>16)&0xff,
					(gwIPAddr>>8)&0xff,
					gwIPAddr&0xff,
					newPort>>8,
					newPort&0xff);

				//DEBUG("the modified port response is\"%s\"",portString);
				//DEBUG("data before len is %d, after is %d",dataLen,strlen(portString));

				newLen=strlen(portString);
				newDelta=(newLen-dataLen);
				//DEBUG("the newDelta is %d",newDelta);

				if(skb->tail+newDelta > skb->end)
				{
					//need to re-alloc skb data structure
					FIXME("Overflow! we need to re-alloc skb data stucture...");
				}
				else
				{
					//copy the new string into skb and enlarge or shrink the length
					memcpy(skb->data+dataOff,portString,newLen);

					//fix packet length
					//DEBUG("sip is %x, sport is %d",pPktInfo->ipv4Sip,pPktInfo->sport);
					if(newDelta != 0)
					{
						skb->len += newDelta;
						*pPktInfo->pL3Len=htons(pPktInfo->l3Len + newDelta);
					}
				}

				pFtpCtrlFlow = _rtk_rg_lookupFTPCtrlFlow(pPktInfo->ipv4Sip,pPktInfo->sport,pPktInfo->ipv4Dip,pPktInfo->dport);
				if(pFtpCtrlFlow!=NULL)pFtpCtrlFlow->Delta+=newDelta;

				//Add a one-shot UPnP flow for incoming connection to each L4 WAN
				for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
				{
					if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE &&
						rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->napt_enable)		//L4 WAN
					{
						upnpConn.is_tcp=1;
						upnpConn.wan_intf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
						upnpConn.gateway_port=newPort;
						upnpConn.local_ip=ipAddr;
						upnpConn.local_port=portNum;
						upnpConn.limit_remote_ip=1;
						upnpConn.limit_remote_port=0;		//can't restrict client using which port to connect
						upnpConn.remote_ip=pPktInfo->ipv4Dip;
						upnpConn.remote_port=0;
						upnpConn.type=UPNP_TYPE_ONESHOT;
						upnpConn.timeout=FTP_PASV_UPNP_TIMEOUT;	//auto time out after 10 second if the client do not connect by this WAN
						assert_ok(rtk_rg_upnpConnection_add(&upnpConn,&ret));
					}
				}
			}
		}
		else
		{
			//DEBUG("the data is %x, port is %x",*((unsigned int *)(pData+dataOff)),htonl(FTP_PORT_STR));

			//Check if we had add FTP-flow 5-tuple link list entry
			//if not, add one, set Delta to 0
			//check each list entry, if not add, add
			pFtpCtrlFlow = _rtk_rg_lookupFTPCtrlFlow(ntohl(*pPktInfo->pIpv4Dip),ntohs(*pPktInfo->pDport),pPktInfo->ipv4Sip,pPktInfo->sport);
			if(pFtpCtrlFlow == NULL)
			{
				//DEBUG("ADD NEW CTRL FLOW of SrvInLan FTP!!DIP is %x, DPORT is %d",*pPktInfo->pIpv4Dip,*pPktInfo->pDport);
				//add one
				rg_db.pAlgFTPCtrlFlowHead->remoteIpAddr=pPktInfo->ipv4Sip;
				rg_db.pAlgFTPCtrlFlowHead->internalIpAddr=ntohl(*pPktInfo->pIpv4Dip);
				rg_db.pAlgFTPCtrlFlowHead->remotePort=pPktInfo->sport;
				rg_db.pAlgFTPCtrlFlowHead->internalPort=ntohs(*pPktInfo->pDport);

				//move to next one
				rg_db.pAlgFTPCtrlFlowHead = rg_db.pAlgFTPCtrlFlowHead->pNext;
			}
			else if((pPktInfo->tcpFlags.syn==1)&&(pPktInfo->tcpFlags.ack==0))	//If the same Ctrl Flow send SYN packet, we need to reset Delta to 0
			{
				//DEBUG("Got SYN at same ctrl-flow..reset Delta!");
				pFtpCtrlFlow->Delta=0;
			}
			else if(pFtpCtrlFlow->Delta != 0)
			{
				//DEBUG("post inbound Delta is %d, old ack is %x",pFtpCtrlFlow->Delta,*pPktInfo->pTcpAck);
				*pPktInfo->pTcpAck=htonl(pPktInfo->tcpAck - pFtpCtrlFlow->Delta);
			}
		}
	}
#endif
	return RG_RET_SUCCESS;
}
#endif
void _rtk_rg_l2tpTunnelIDFree(uint16 tunnID)
{
	int idx;
	uint32 bitValue;
	int i;

	i=tunnID;
	idx=i>>5; // =port/32
	bitValue=1<<(i&0x1f);
	if((rg_db.algL2TPExternTulIDUsed[idx]&bitValue)>0)
	{
		rg_db.algL2TPExternTulIDUsed[idx]&=(~bitValue);
	}
}

rtk_rg_lookupIdxReturn_t _rtk_rg_l2tpTunnelIDGetAndUse(uint16 wishTunnID)
{
	int wishIdx;
	uint32 wishBitValue;
	int i;

	i=wishTunnID;

	while(1)
	{
		wishIdx=i>>5; // =wishPort/32
		wishBitValue=1<<(i&0x1f);

		if(((rg_db.algL2TPExternTulIDUsed[wishIdx]&wishBitValue)==0))
		{
			rg_db.algL2TPExternTulIDUsed[wishIdx]|=wishBitValue;
			return i;
		}

		i++;
		i&=0xffff;
		if(i==wishTunnID) break;
	}
	return RG_RET_LOOKUPIDX_NOT_FOUND;
}


rtk_rg_alg_l2tp_flow_t *_rtk_rg_lookupL2TPCtrlFlow(unsigned int internalIp,unsigned short int internalID, unsigned int remoteIp, unsigned short int externalID)
{
	rtk_rg_alg_l2tp_linkList_t *pEntry=NULL;

	DEBUG("the input is: int %x,%d ret %x,%d",internalIp,internalID,remoteIp,externalID);

	for (pEntry = rg_db.pAlgL2TPCtrlFlowHead->pPrev; pEntry != rg_db.pAlgL2TPCtrlFlowHead; pEntry = pEntry->pPrev)
	{
		if(pEntry->l2tpFlow.valid)
			DEBUG("the entry is %s int %x,%d ret %x,%d",pEntry->l2tpFlow.valid==1?"VALID":"INVALID",pEntry->l2tpFlow.internalIP,pEntry->l2tpFlow.IntTulID,pEntry->l2tpFlow.remoteIP,pEntry->l2tpFlow.ExtTulID);
		if(pEntry->l2tpFlow.valid &&
			(internalIp==0 || pEntry->l2tpFlow.internalIP==internalIp)&&
			(internalID==0 || pEntry->l2tpFlow.IntTulID==internalID)&&
			(pEntry->l2tpFlow.remoteIP==remoteIp)&&
			(externalID==0 || pEntry->l2tpFlow.ExtTulID==externalID))
			break;
	}
	if(pEntry == rg_db.pAlgL2TPCtrlFlowHead)		//not found
		return NULL;

	return &pEntry->l2tpFlow;
}


rtk_rg_fwdEngineAlgReturn_t _rtk_rg_algRegFunc_UDP_L2TP(int direct, int after, unsigned char *pSkb,unsigned char *pPktHdr)
{
//FIXME:here should be rewrite for model code
#ifdef __KERNEL__
	char *pData;
	//char portString[60]={0};
	//unsigned int ipAddr,gwIPAddr;
	//int i,newLen,newDelta;
	//unsigned short portNum,newPort;
	int dataLen=0,dataOff=0,hdrLength;
	//rtk_rg_naptEntry_t naptEntry;
	rtk_rg_pktHdr_t *pPktInfo;
	struct sk_buff *skb;

	rtk_rg_alg_l2tp_flow_t *pL2TPCtrlFlow;
	rtk_rg_alg_l2tp_ctrlHeader_t *pLl2tpHdr;
	rtk_rg_alg_l2tp_avpHeader_t *pAvpHdr;
	unsigned char *pAvpNext;


	pPktInfo = (rtk_rg_pktHdr_t *)pPktHdr;
	skb= (struct sk_buff *)pSkb;

	pData=skb->data;

	dataOff = pPktInfo->l4Offset + 8;//pPktInfo->headerLen;		//UDP header length are always 8 bytes
	//if(pPktInfo->tagif&PPPOE_TAGIF)dataOff+=8;		//shift for pppoe packet
	dataLen = skb->len - dataOff;
	pLl2tpHdr = (rtk_rg_alg_l2tp_ctrlHeader_t *)(pData+dataOff);

	DEBUG("the l4offset is %d, headerlen is %d, skb->len is %d, dataLen is %d, dataoff is %d",pPktInfo->l4Offset,pPktInfo->headerLen,skb->len,dataLen,dataOff);

	if(after==0)
	{
		//Pre function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			//Check if this packet is SCCRQ(TunnelID=0, SessionID=0, has Assigned TunnelID AVP)
			if(dataLen > 0 && pLl2tpHdr->flag==htons(L2TP_CTRL_MSG_STR))
			{
				pAvpHdr=(rtk_rg_alg_l2tp_avpHeader_t *)(pLl2tpHdr+1);
				if(pLl2tpHdr->tunnel_id==0 && pLl2tpHdr->session_id==0)
				{
					//Check each AVP for (Assigned Tunnel ID AVP), true value length = length - 6
					if(pAvpHdr->attType==0 && *(unsigned short *)(pAvpHdr+1)==1)	//control Message: Start_Control_Request
					{
						hdrLength=pLl2tpHdr->length - sizeof(rtk_rg_alg_l2tp_ctrlHeader_t);
						while(hdrLength>0)
						{
							if(pAvpHdr->attType==9)		//Assigned Tunnel ID
							{
								DEBUG("AVP: Assigned Tunnel ID!!");
								//Check if the assigned tunnel ID had been used
								pL2TPCtrlFlow=_rtk_rg_lookupL2TPCtrlFlow(pPktInfo->ipv4Sip,*(unsigned short *)(pAvpHdr+1),pPktInfo->ipv4Dip,0);	//since the external ID is not decide, use 0 to bypass this check
								if(pL2TPCtrlFlow==NULL)
								{
									int ret;
									//if so, replace it, otherwise keep the ID untouched
									//create new control flow for l2tp

									rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.remoteIP=pPktInfo->ipv4Dip;
									rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.internalIP=pPktInfo->ipv4Sip;
									rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.IntTulID=*(unsigned short *)(pAvpHdr+1);
									ret=_rtk_rg_l2tpTunnelIDGetAndUse(rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.IntTulID);
									if(ret==RG_RET_LOOKUPIDX_NOT_FOUND)return RG_FWDENGINE_ALG_RET_FAIL;
									rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.ExtTulID=ret;
									if(rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.IntTulID!=rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.ExtTulID)
										*(unsigned short *)(pAvpHdr+1)=rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.ExtTulID;

									DEBUG("ADD NEW CTRL FLOW of L2TP!!SIP is %x, DIP is %x, IntTunnID is %d, ExtTunnID is %d",pPktInfo->ipv4Sip,pPktInfo->ipv4Dip,rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.IntTulID,rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.ExtTulID);

									//move to next one
									rg_db.pAlgL2TPCtrlFlowHead->l2tpFlow.valid=1;
									rg_db.pAlgL2TPCtrlFlowHead = rg_db.pAlgL2TPCtrlFlowHead->pNext;
								}
								else
								{
									//Change from old id to external id
									*(unsigned short *)(pAvpHdr+1)=pL2TPCtrlFlow->ExtTulID;
								}
								break;
							}
							else
							{
								//other AVP, omit it
								pAvpNext=(unsigned char *)pAvpHdr;
								pAvpNext+=pAvpHdr->length;	//move to next avp
								hdrLength-=pAvpHdr->length;	//decrease length to check
								pAvpHdr=(rtk_rg_alg_l2tp_avpHeader_t *)pAvpNext;
								//DEBUG("Check Next AVP...length remain %d",hdrLength);
							}
						}
					}
				}
				else
				{
					if(pAvpHdr->attType==0 && *(unsigned short *)(pAvpHdr+1)==4)	//control Message: Stop_Control_Request
					{
						DEBUG("OUTBOUND!!! StopCCN from %x!!! TunnelID is %d",pPktInfo->ipv4Sip,pLl2tpHdr->tunnel_id);
						pL2TPCtrlFlow=_rtk_rg_lookupL2TPCtrlFlow(pPktInfo->ipv4Sip,pLl2tpHdr->tunnel_id,pPktInfo->ipv4Dip,0);	//since the external ID is unknown, use 0 to bypass this check
						if(pL2TPCtrlFlow!=NULL)
						{
							//release the external ID for next one to use
							_rtk_rg_l2tpTunnelIDFree(pL2TPCtrlFlow->ExtTulID);
						}
					}
				}
			}
		}
		else
		{
			//Do nothing
		}
	}
	else
	{
		//Post function
		if(direct==NAPT_DIRECTION_OUTBOUND)
		{
			//Do nothing
		}
		else
		{
			DEBUG("INBOUND!!! from %x with tunnel ID is %d",pPktInfo->ipv4Sip,pLl2tpHdr->tunnel_id);
			if(pLl2tpHdr->tunnel_id>0)
			{
				pL2TPCtrlFlow=_rtk_rg_lookupL2TPCtrlFlow(0,0,pPktInfo->ipv4Sip,pLl2tpHdr->tunnel_id);
				if(pL2TPCtrlFlow!=NULL)
				{
					//replace internal IP and TunnID
					*pPktInfo->pIpv4Dip=htonl(pL2TPCtrlFlow->internalIP);
					pLl2tpHdr->tunnel_id=pL2TPCtrlFlow->IntTulID;
					DEBUG("INBOUND!!! INTIP changes to %x, TUNNID changes to %d",htonl(pL2TPCtrlFlow->internalIP),pLl2tpHdr->tunnel_id);
					if(dataLen > 0 && pLl2tpHdr->flag==htons(L2TP_CTRL_MSG_STR))
					{
						pAvpHdr=(rtk_rg_alg_l2tp_avpHeader_t *)(pLl2tpHdr+1);
						if(pAvpHdr->attType==0 && *(unsigned short *)(pAvpHdr+1)==4)	//control Message: Stop_Control_Request
						{
							//release the external ID for next one to use
							_rtk_rg_l2tpTunnelIDFree(pL2TPCtrlFlow->ExtTulID);
						}
					}
				}
				else
					DEBUG("pL2TPCtrlFlow is not found, do nothing....");
			}
			else
				DEBUG("pL2TPCtrlFlow is not found, do nothing....");
		}
	}
#endif
	return RG_FWDENGINE_ALG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_checkARPForMacLimit(rtk_rg_saLearningLimitProbe_t *limitInfo,rtk_rg_pktHdr_t *pPktHdr)
{
	if(atomic_read(&limitInfo->activity)>0 && limitInfo->arpReq.finished==0)
	{
		//Check IP if match
		if(pPktHdr->ipv4Sip==limitInfo->arpReq.reqIp)
		{
			limitInfo->arpReq.finished=1;
			limitInfo->arpCounter=-1;
			return RG_RET_SUCCESS;
		}
	}

	return RG_RET_FAIL;
}

void _rtk_rg_setupL2TP_PPTP_MAC_from_NH(rtk_rg_wan_type_t wanType, int intIdx, int nexthopIdx)
{
	if(wanType==RTK_RG_PPTP)
		_rtk_rg_internal_PPTPMACSetup(rg_db.systemGlobal.intfArpRequest[intIdx].reqIp, rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx);
	else
		_rtk_rg_internal_L2TPMACSetup(rg_db.systemGlobal.intfArpRequest[intIdx].reqIp, rg_db.nexthop[nexthopIdx].rtk_nexthop.nhIdx);
}

rtk_rg_successFailReturn_t _rtk_rg_checkARPForL2TP_PPTP(rtk_rg_wanIntfInfo_t *wan_intf, int intIdx, rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	rtk_rg_interface_info_global_t *intfInfo;

	for(i=0;i<MAX_L3_SW_TABLE_SIZE;i++){
		if(rg_db.l3[i].rtk_l3.valid){
			switch(rg_db.l3[i].rtk_l3.process){
				case L34_PROCESS_NH:
					if(rg_db.nexthop[rg_db.l3[i].rtk_l3.nhStart].rtk_nexthop.ifIdx==pPktHdr->aclPolicyRoute){
						TRACE("get NH from interface!!");
						_rtk_rg_setupL2TP_PPTP_MAC_from_NH(wan_intf->wan_intf_conf.wan_type,intIdx, rg_db.l3[i].rtk_l3.nhStart);
						wan_intf->baseIntf_idx=pPktHdr->aclPolicyRoute;
						return RG_RET_SUCCESS;
					}
					break;
				case L34_PROCESS_ARP:
					{
						int aclPolicyRouteIdx = pPktHdr->aclPolicyRoute;
						if(aclPolicyRouteIdx>0)
						{
							if(rg_db.l3[i].rtk_l3.netifIdx==aclPolicyRouteIdx && rg_db.systemGlobal.interfaceInfo[aclPolicyRouteIdx].valid &&
								rg_db.systemGlobal.interfaceInfo[aclPolicyRouteIdx].p_wanStaticInfo->static_route_with_arp)
							{
								TRACE("get NH from interface which static route with ARP!!");
								_rtk_rg_setupL2TP_PPTP_MAC_from_NH(wan_intf->wan_intf_conf.wan_type,intIdx, rg_db.systemGlobal.interfaceInfo[aclPolicyRouteIdx].storedInfo.wan_intf.nexthop_ipv4);
								wan_intf->baseIntf_idx=aclPolicyRouteIdx;
								return RG_RET_SUCCESS;
							}
						}
				}
					break;
				case L34_PROCESS_CPU:
					intfInfo=&rg_db.systemGlobal.interfaceInfo[rg_db.l3[i].rtk_l3.netifIdx];
					if(rg_db.l3[i].rtk_l3.netifIdx==pPktHdr->aclPolicyRoute && intfInfo->valid && intfInfo->storedInfo.is_wan){
						if(intfInfo->storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
							intfInfo->storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP){
							TRACE("process=CPU, get NH from interface!!");
							_rtk_rg_setupL2TP_PPTP_MAC_from_NH(wan_intf->wan_intf_conf.wan_type,intIdx, intfInfo->storedInfo.wan_intf.nexthop_ipv4);
							wan_intf->baseIntf_idx=pPktHdr->aclPolicyRoute;
							return RG_RET_SUCCESS;
						}else if(rg_db.l3[i].rtk_l3.ipAddr>0 && intfInfo->p_wanStaticInfo->static_route_with_arp){
							TRACE("process=CPU, get NH from interface which static route with ARP!!");
							_rtk_rg_setupL2TP_PPTP_MAC_from_NH(wan_intf->wan_intf_conf.wan_type,intIdx, intfInfo->storedInfo.wan_intf.nexthop_ipv4);
							wan_intf->baseIntf_idx=pPktHdr->aclPolicyRoute;
							return RG_RET_SUCCESS;
						}
					}
					break;
				default:
					break;
			}
		}
	}

	return RG_RET_FAIL;
}

rtk_rg_successFailReturn_t _rtk_rg_arpAgent(u8 *pData, u32 len, rtk_rg_pktHdr_t *pPktHdr)
{
	int i,l2Idx=-1;
	rtk_rg_successFailReturn_t ret=RG_RET_FAIL;

	TRACE("ARP Agent, arpOpCode=%d",pPktHdr->arpOpCode);
	pPktHdr->arpAgentCalled=1;

	//20170306: skip arp learning if packet is L2 arp from wan port
	if(rg_db.systemGlobal.wanPortMask.portmask&(0x1<<pPktHdr->ingressPort))
	{
		uint8 skipLearn=TRUE;
		if(pPktHdr->pDmac[0]==0xff && pPktHdr->pDmac[1]==0xff && pPktHdr->pDmac[2]==0xff && pPktHdr->pDmac[3]==0xff && pPktHdr->pDmac[4]==0xff && pPktHdr->pDmac[5]==0xff)
		{
			for(i=0; i<MAX_NETIF_SW_TABLE_SIZE; i++)
			{
				if(rg_db.systemGlobal.interfaceInfo[i].valid==0) continue;
				if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1)
				{
					if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
						continue;
					//not bridge wan
					if(pPktHdr->ipv4Dip==rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->ip_addr ||
						(pPktHdr->ipv4Sip==pPktHdr->ipv4Dip && pPktHdr->ipv4Dip==rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->gateway_ipv4_addr))	//20190212LUKE: bypass gratuitous ARP from remote gateway
					{
						skipLearn = FALSE;
						break;
					}
				}
				else
				{
					if(pPktHdr->ipv4Dip==rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.ip_addr)
					{
						skipLearn = FALSE;
						break;
					}
				}
			}
		}
		else	//not broadcast
		{
			if(pPktHdr->isGatewayPacket)
				skipLearn = FALSE;
		}

		if(skipLearn)
		{
			TRACE("skip L2 arp learning from wan port");
			return RG_RET_SUCCESS;
		}
	}

	if(pPktHdr->arpOpCode==2 || pPktHdr->arpOpCode==1)		//check both ARP reply and request for complete rg add wan interface
	{
#ifdef CONFIG_RG_NAPT_ARP_AUTO_LEARN
		ret=_rtk_rg_arpAndMacEntryAdd(pPktHdr->ipv4Sip,pPktHdr->sipL3Idx,pPktHdr->pSmac,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&l2Idx,pPktHdr->ingressDecideVlanID,1,1);
#endif
		//lookup for MAC limit req
		if(rg_db.systemGlobal.activeLimitFunction!=RG_ACCESSWAN_TYPE_UNLIMIT){
			_rtk_rg_checkARPForMacLimit(&rg_kernel.lutReachLimit_portmask, pPktHdr);
			for(i=0;i<WanAccessCategoryNum;i++){
				_rtk_rg_checkARPForMacLimit(&rg_kernel.lutReachLimit_category[i], pPktHdr);
			}
		}

		for(i=0;i<(MAX_NETIF_SW_TABLE_SIZE<<1);i++){
			//20161121LUKE: if we didn't turn on remoteGatewayMacStatically, always update MAC address when receive ARP.
			if(rg_db.systemGlobal.intfArpRequest[i].finished==0||!rg_db.systemGlobal.remoteGatewayMacStatically){
				if(pPktHdr->ipv4Sip==rg_db.systemGlobal.intfArpRequest[i].reqIp && ret==RG_RET_SUCCESS){
					if(rg_db.systemGlobal.intfArpRequest[i].gwMacReqCallBack!=NULL){
						rg_db.systemGlobal.intfArpRequest[i].gwMacReqCallBack(rg_db.systemGlobal.intfArpRequest[i].reqIp,l2Idx);
					}
					TRACE("netif=%d ipv4Sip=%x ipv4Dip=%x reqIp=%x policy route=%d\n",i,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,rg_db.systemGlobal.intfArpRequest[i].reqIp,pPktHdr->aclPolicyRoute);
					rg_db.systemGlobal.intfArpRequest[i].finished=1;
					//break;
				}
				if((pPktHdr->ipv4Dip==rg_db.systemGlobal.intfArpRequest[i].reqIp)&&(pPktHdr->aclPolicyRoute>=0)&&
					(rg_db.systemGlobal.interfaceInfo[i-MAX_NETIF_SW_TABLE_SIZE].storedInfo.is_wan)&&
					((rg_db.systemGlobal.interfaceInfo[i-MAX_NETIF_SW_TABLE_SIZE].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP)||
					(rg_db.systemGlobal.interfaceInfo[i-MAX_NETIF_SW_TABLE_SIZE].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP))){	//20150911LUKE: check for policy route may route l2tp/pptp server IP to some other WAN!
					if(_rtk_rg_checkARPForL2TP_PPTP(&rg_db.systemGlobal.interfaceInfo[i-MAX_NETIF_SW_TABLE_SIZE].storedInfo.wan_intf,i,pPktHdr)==RG_RET_SUCCESS){
						//break;
					}
				}
			}
		}

		for(i=0;i<MAX_STATIC_ROUTE_SIZE;i++){
			//20161121LUKE: if we didn't turn on remoteGatewayMacStatically, always update MAC address when receive ARP.
			if(rg_db.systemGlobal.staticRouteArpReq[i].finished==0||!rg_db.systemGlobal.remoteGatewayMacStatically){
				if(pPktHdr->ipv4Sip==rg_db.systemGlobal.staticRouteArpReq[i].reqIp && ret==RG_RET_SUCCESS){
					if(rg_db.systemGlobal.staticRouteArpReq[i].gwMacReqCallBack!=NULL){
						rg_db.systemGlobal.staticRouteArpReq[i].gwMacReqCallBack(rg_db.systemGlobal.staticRouteArpReq[i].reqIp,l2Idx);
					}
					TRACE("netif=%d ipv4Sip=%x ipv4Dip=%x reqIp=%x policy route=%d\n",i,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,rg_db.systemGlobal.staticRouteArpReq[i].reqIp,pPktHdr->aclPolicyRoute);
					rg_db.systemGlobal.staticRouteArpReq[i].finished=1;
					//break;
				}
			}
		}
	}
	return ret;
}

rtk_rg_successFailReturn_t _rtk_rg_checkNeighborForMacLimit(rtk_rg_saLearningLimitProbe_t *limitInfo,rtk_rg_pktHdr_t *pPktHdr)
{
	if(atomic_read(&limitInfo->activity)>0 && limitInfo->neighborReq.finished==0)
	{
		//Check IPv6 if match
		if(memcmp(pPktHdr->pIpv6Sip,limitInfo->neighborReq.reqIp.ipv6_addr,IPV6_ADDR_LEN)==0)
		{
			limitInfo->neighborReq.finished=1;
			limitInfo->neighborCounter=-1;
			return RG_RET_SUCCESS;
		}
	}

	return RG_RET_FAIL;
}

rtk_rg_successFailReturn_t _rtk_rg_setupIpv6GwMac(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr, uint32 netIfIdx, uint8 isStaticRoute)
{
	int neighborIdx=-1, macIdx=0xffffffff, l3Idx, dsliteNetIfIdx=-1;

	//FIXME: there may have other options in the future[rfc 4861]
	if(pPktHdr->pICMPv6TargetLinkAddr==NULL){	//ICMPv6 option: Target link-layer address
		DEBUG("Neighbor learning fail: ICMPv6 option: Target link-layer address, option data=0x%x",skb->data[pPktHdr->l4Offset+24]);
		return RG_RET_FAIL;
	}
	DEBUG("MATCH!!%x%x%x%x%x%x",pPktHdr->pICMPv6TargetLinkAddr[0],pPktHdr->pICMPv6TargetLinkAddr[1],
		pPktHdr->pICMPv6TargetLinkAddr[2],pPktHdr->pICMPv6TargetLinkAddr[3],
		pPktHdr->pICMPv6TargetLinkAddr[4],pPktHdr->pICMPv6TargetLinkAddr[5]);

	//over MAX_NETIF_SIZE belong to DSLITE
	if(isStaticRoute==0)
	{
		if(netIfIdx>=MAX_NETIF_SW_TABLE_SIZE)
			dsliteNetIfIdx=netIfIdx-MAX_NETIF_SW_TABLE_SIZE;
		else
			dsliteNetIfIdx=netIfIdx;
	}

	//20180822LUKE: fix IPv6 address ordering by ntohl.
	//20140826LUKE: handle link-local address
	if(ntohl(*((unsigned int *)pPktHdr->pICMPv6TargetAddr))==0xfe800000 && ntohl(*((unsigned int *)(pPktHdr->pICMPv6TargetAddr+4)))==0x0){
		l3Idx=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
		DEBUG("Link-local address.. use DIP to find VLAN, %d",l3Idx);
		_rtk_rg_neighborAndMacEntryAdd(pPktHdr->pICMPv6TargetAddr,l3Idx,pPktHdr->pICMPv6TargetLinkAddr,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&macIdx);
	}else if((isStaticRoute==0)&&(netIfIdx>=MAX_NETIF_SW_TABLE_SIZE)&&(rg_db.systemGlobal.interfaceInfo[dsliteNetIfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE)){
		DEBUG("DSLITE, we just add mac without neighbor since we don't have ipv6 route");
		_rtk_rg_neighborAndMacEntryAdd(pPktHdr->pICMPv6TargetAddr,pPktHdr->sipL3Idx,pPktHdr->pICMPv6TargetLinkAddr,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&macIdx);
	}else{
		_rtk_rg_neighborAndMacEntryAdd(pPktHdr->pICMPv6TargetAddr,pPktHdr->sipL3Idx,pPktHdr->pICMPv6TargetLinkAddr,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&neighborIdx);
		//20161221LUKE: if we are update remote gateway here, passed index as negative value.
		if(neighborIdx&0x80000000)macIdx=(neighborIdx&0x7fffffff);
		else macIdx=rg_db.v6neighbor[neighborIdx].neighborEntry.l2Idx;
	}

	//20191220LUKE: check if the macIdx had been updated, otherwise return without calling ipv6GwMacReqCallBack.
	if(macIdx!=0xffffffff){
		//20180822LUKE: if we are update remote gateway here, recovery index from negative value.
		if(macIdx&0x80000000)macIdx&=0x7fffffff;

		if(isStaticRoute==0){
			if(rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].ipv6GwMacReqCallBack!=NULL){
				rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].ipv6GwMacReqCallBack(rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].reqIp.ipv6_addr,macIdx);
			}
			rg_db.systemGlobal.intfNeighborDiscovery[netIfIdx].finished=1;
		}
		else{
			if(rg_db.systemGlobal.staticRouteNBDiscovery[netIfIdx].ipv6GwMacReqCallBack!=NULL){
				rg_db.systemGlobal.staticRouteNBDiscovery[netIfIdx].ipv6GwMacReqCallBack(rg_db.systemGlobal.staticRouteNBDiscovery[netIfIdx].reqIp.ipv6_addr,macIdx);
			}
			rg_db.systemGlobal.staticRouteNBDiscovery[netIfIdx].finished=1;
		}
	}

	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_neighborAgent(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	int neighborIdx=-1,i;

	TRACE("Neighbor Agent, ICMPv6 type=%d",pPktHdr->ICMPv6Type);
	pPktHdr->neighborAgentCalled=1;
	//Check for Neighbor advertisement packet
	if((rg_db.pktHdr->tagif&ICMPV6_TAGIF) && ((pPktHdr->ICMPv6Type==0x88)||(pPktHdr->ICMPv6Type==0x87)))
	{
		//Check for validation
		if(*pPktHdr->pIPv6HopLimit!=255)	//hop limit should be 255, solicitation flag should be set
		{
			TRACE("skip NB learning due to check validation fail!");
			return RG_RET_FAIL;
		}

#ifdef CONFIG_RG_IPV6_NEIGHBOR_AUTO_LEARN
		//20170914LUKE: we learning neighbor by target IP and source link layer address for NS, target link layer address for NA.(refer to kernel)
		//20170912LUKE: if neighbor advertisement target IP is different with sip, learning neighbor with target IP instead!!
		//Learning source IP with source Link-layer address and keep in neighbor table
		if(pPktHdr->pICMPv6SourceLinkAddr)_rtk_rg_neighborAndMacEntryAdd(pPktHdr->pIpv6Sip,pPktHdr->sipL3Idx,pPktHdr->pICMPv6SourceLinkAddr,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&neighborIdx);
		else if(pPktHdr->pICMPv6TargetLinkAddr)_rtk_rg_neighborAndMacEntryAdd(pPktHdr->pICMPv6TargetAddr,pPktHdr->sipL3Idx,pPktHdr->pICMPv6TargetLinkAddr,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&neighborIdx);
#endif
		//Check for solicited Neighbor Advetisement packets for complete RG WAN interface addition
		if((pPktHdr->ICMPv6Flag&0x2)==0) //ICMPv6Type=0x88
			return RG_RET_FAIL; //ICMPv6Type=0x87 will exit here.

		//lookup for MAC limit req
		if(rg_db.systemGlobal.activeLimitFunction!=RG_ACCESSWAN_TYPE_UNLIMIT){
			_rtk_rg_checkNeighborForMacLimit(&rg_kernel.lutReachLimit_portmask, pPktHdr);
			for(i=0;i<WanAccessCategoryNum;i++){
				_rtk_rg_checkNeighborForMacLimit(&rg_kernel.lutReachLimit_category[i], pPktHdr);
			}
		}

		for(i=0;i<(MAX_NETIF_SW_TABLE_SIZE<<1);i++){
			//20161121LUKE: if we didn't turn on remoteGatewayMacStatically, always update MAC address when receive ARP.
			if(rg_db.systemGlobal.intfNeighborDiscovery[i].finished==0||!rg_db.systemGlobal.remoteGatewayMacStatically){
				/*
				DEBUG("Neighbor Agent, Intf[%d] request IP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",i,
					rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[0],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[1],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[2],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[3],
					rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[4],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[5],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[6],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[7],
					rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[8],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[9],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[10],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[11],
					rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[12],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[13],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[14],rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr[15]);

				int j;
				DEBUG("the target address is");
				for(j=0;j<16;j++)
					DEBUG("%02x ",skb->data[pPktHdr->l4Offset+8+j]);
				*/
				if(!memcmp(pPktHdr->pICMPv6TargetAddr,rg_db.systemGlobal.intfNeighborDiscovery[i].reqIp.ipv6_addr,IPV6_ADDR_LEN)){
					if(_rtk_rg_setupIpv6GwMac(skb, pPktHdr, i, 0)!=RG_RET_SUCCESS)
						return RG_RET_FAIL;
					//break;
				}
			}
		}

		for(i=0;i<MAX_STATIC_ROUTE_SIZE;i++){
			//20161121LUKE: if we didn't turn on remoteGatewayMacStatically, always update MAC address when receive ARP.
			if(rg_db.systemGlobal.staticRouteNBDiscovery[i].finished==0||!rg_db.systemGlobal.remoteGatewayMacStatically){
				/*
				int j;
				DEBUG("Neighbor Agent, Intf[%d] request IP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",i,
					rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[0],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[1],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[2],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[3],
					rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[4],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[5],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[6],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[7],
					rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[8],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[9],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[10],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[11],
					rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[12],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[13],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[14],rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr[15]);
				DEBUG("the target address is (off=%d)",pPktHdr->l4Offset);
				for(j=0;j<16;j++)
					DEBUG("%02x ",pPktHdr->pICMPv6TargetAddr[j]);
				*/
				if(!memcmp(pPktHdr->pICMPv6TargetAddr,rg_db.systemGlobal.staticRouteNBDiscovery[i].reqIp.ipv6_addr,IPV6_ADDR_LEN)){
					if(_rtk_rg_setupIpv6GwMac(skb, pPktHdr, i, 1)!=RG_RET_SUCCESS)
						return RG_RET_FAIL;
					//break;
				}
			}
		}
	}
	return RG_RET_SUCCESS;
}

__IRAM_FWDENG_L2
rtk_rg_successFailReturn_t _rtk_rg_portAndProtocolBasedVlanCheck(rtk_rg_pktHdr_t *pPktHdr, int *interVLANId)
{
	int groupID;
	rtk_vlan_protoVlanCfg_t *pVlanCfg;

	//Check ingress port(MAC only, no extension port)
	//Check protocol Group, if match, use the VLAN ID as the ingress ID
	for(groupID=0;groupID<MAX_PORT_PROTO_GROUP_SIZE;groupID++)
	{
		pVlanCfg=&rg_db.systemGlobal.protoBasedVID[pPktHdr->ingressMacPort].protoVLANCfg[groupID];
		if(pVlanCfg->valid==0)
			continue;

		switch(rg_db.systemGlobal.protoGroup[groupID].frametype)
		{
			case FRAME_TYPE_ETHERNET:
				if(pPktHdr->etherType==rg_db.systemGlobal.protoGroup[groupID].framevalue)
				{
					//TRACE("Protocol Match!!using VLANID %d as ingress VLAN for untag packets!!",pVlanCfg->vid)
					*interVLANId=pVlanCfg->vid;
					return RG_RET_SUCCESS;
				}
				//else
					//DEBUG("Protocol unMatch...pkt=%04x, protoGroup=%04x...",pPktHdr->etherType,rg_db.systemGlobal.protoGroup[groupID].framevalue);
				break;
	    	case FRAME_TYPE_RFC1042:
	    	case FRAME_TYPE_LLCOTHER:
			default:
				//FIXME("ProtoGroup has un-supported frametype %d, fail to check...",rg_db.systemGlobal.protoGroup[groupID].frametype);
				break;
		}
	}

	return RG_RET_FAIL;

}

rtk_rg_successFailReturn_t _rtk_rg_ingressVlanDecision(rtk_rg_pktHdr_t *pPktHdr, uint16 *interVLANId)
{
	rtk_rg_successFailReturn_t ret;
	int protoVLANID;
	//The decided internal VLAN ID will be returned by reference of interVLANId
	//FIXME:here should be check ACL before 1Q and other VLAN decision
	//uint8 cVlanPri;
	if(pPktHdr->ingressLocation==RG_IGR_IGMP_OR_MLD)		//from IGMP module, vlan will carried by skb!!
	{
		TRACE("IGMP or MLD will use rxInfoFromIGMPMLD.opts2.bit.cvlan_tag:%d",rg_kernel.rxInfoFromIGMPMLD.rx_cvlan_tag);
		*interVLANId=rg_kernel.rxInfoFromIGMPMLD.rx_cvlan_tag;
	}
	else if(pPktHdr->tagif&CVLAN_TAGIF)
	{
		TRACE("1Q-based VLAN %d(by tag)",pPktHdr->ctagVid);
		*interVLANId=pPktHdr->ctagVid;
	}
#if 0
	else if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK && pPktHdr->pRxDesc->rx_ctagva)		//PATCH for rtk_rg_fwdEngine_xmit may use ctagva to indicate tagging
	{
		//1Q-based VLAN (by descriptor)
		*interVLANId=((pPktHdr->pRxDesc->rx_cvlan_tag&0xf)<<0x8)+((pPktHdr->pRxDesc->rx_cvlan_tag&0xff00)>>0x8);
		TRACE("1Q from Protocol stack, interVLANId=%d\n",*interVLANId);
		//update for pPktHdr VLAN message, because gw removed vlan: chuck
		pPktHdr->tagif |= CVLAN_TAGIF;
		pPktHdr->ctagVid=*interVLANId;
		pPktHdr->egressVlanID = *interVLANId;
		pPktHdr->ctagPri=((pPktHdr->pRxDesc->rx_cvlan_tag&0xf0)>>5);
		pPktHdr->egressPriority = pPktHdr->ctagPri;
		pPktHdr->ctagCfi=((pPktHdr->pRxDesc->rx_cvlan_tag&0x10)>>4);
	}
#endif
	else
	{
		ret=_rtk_rg_portAndProtocolBasedVlanCheck(pPktHdr,&protoVLANID);
		if(ret==RG_RET_SUCCESS)
		{
			*interVLANId=protoVLANID;
			TRACE("Port-Proto-Based interVLANId=%d\n",*interVLANId);
		}
		else
		{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			//20150610LUKE: from WLAN0 untag we can use per ssid vid as it's ingress vlan id
			if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<pPktHdr->ingressPort))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
				|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<pPktHdr->ingressPort))
#endif
				) && pPktHdr->wlan_dev_idx>=0)
			{
				//ssid-based VLAN
				*interVLANId=rg_db.systemGlobal.wlan0DeviceBasedVID[pPktHdr->wlan_dev_idx];
				TRACE("WLAN SSID-Based interVLANId[%d]=%d\n",pPktHdr->wlan_dev_idx,*interVLANId);
			}else{
				//port-based VLAN
				*interVLANId=rg_db.systemGlobal.portBasedVID[pPktHdr->ingressPort];
				TRACE("Port-Based interVLANId=%d\n",*interVLANId);
			}
#else
			//port-based VLAN
			*interVLANId=rg_db.systemGlobal.portBasedVID[pPktHdr->ingressPort];
			TRACE("Port-Based interVLANId=%d\n",*interVLANId);
#endif
		}
	}

	/*Ingress ACL cvid action check and replace interVLANId if hit*/
	assert_ok(_rtk_rg_ingressACLPatternCheck(pPktHdr,rg_db.systemGlobal.acl_SWindex_sorting_by_weight_and_ingress_cvid_action));


	pPktHdr->ingressDecideVlanID=*interVLANId;
	pPktHdr->egressVlanID=*interVLANId;

	DEBUG("Ingress cvid=%d, Internal cvid=%d", pPktHdr->ingressDecideVlanID, pPktHdr->internalVlanID);

	return RG_RET_SUCCESS;
}


rtk_rg_ipClassification_t _rtk_rg_ipv6_sip_classification(uint8 *pIpv6Sip, rtk_rg_pktHdr_t *pPktHdr)
{
	int l3Idx=_rtk_rg_v6L3lookup(pIpv6Sip);
	TRACE("SIP Lookup hit Routing[%d]",l3Idx);
	if(l3Idx>=0){
		if(rg_db.v6route[l3Idx].internal==1)
			return IP_CLASS_RP;
	}
	return IP_CLASS_NPI;
}

rtk_rg_ipClassification_t _rtk_rg_ipv6_dip_classification(uint8 *pIpv6Dip, rtk_rg_pktHdr_t *pPktHdr)
{
	int i ;
	int l3Idx;
	rtk_rg_table_v6ExtIp_t v6ExtIp_entry;
	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++){
		bzero(&v6ExtIp_entry,sizeof(v6ExtIp_entry));
		_rtk_rg_ipv6_externalIp_get(i, &v6ExtIp_entry);

		if(!memcmp(pIpv6Dip,v6ExtIp_entry.externalIp.ipv6_addr,IPV6_ADDR_LEN)){ //DIP hit externapIP
			pPktHdr->extipIdx = i; //also record the expIp idex
			return IP_CLASS_NPE;
		}
	}

	//judge for routing
	l3Idx=_rtk_rg_v6L3lookup(pIpv6Dip);
	TRACE("DIP Lookup hit Routing[%d]",l3Idx);
	if(l3Idx>=0){
		if(rg_db.v6route[l3Idx].internal==0)
			return IP_CLASS_NPI;
	}

	return IP_CLASS_RP;
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_ipClassification_t _rtk_rg_sip_classification(ipaddr_t sip, rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	int internal;
	rtk_l34_ext_intip_entry_t *pExtip;

	pPktHdr->sipL3Idx=_rtk_rg_l3lookup(sip);
	internal=rg_db.l3[pPktHdr->sipL3Idx].rtk_l3.internal;
	for(i=0;i<MAX_EXTIP_SW_TABLE_SIZE;i++)
	{
		pExtip=&rg_db.extip[i].rtk_extip;
		if(pExtip->valid==1 && sip==pExtip->intIpAddr)
		{
			return internal?IP_CLASS_NI:IP_CLASS_LP;
		}
	}

	return internal?IP_CLASS_NPI:IP_CLASS_RP;
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_ipClassification_t _rtk_rg_dip_classification(ipaddr_t dip, rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	rtk_l34_ext_intip_entry_t *pExtip;

	for(i=0;i<MAX_EXTIP_SW_TABLE_SIZE;i++)
	{
		pExtip=&rg_db.extip[i].rtk_extip;
		if(pExtip->valid==1  && dip==pExtip->extIpAddr)
		{
			switch(pExtip->type)
			{
				case L34_EXTIP_TYPE_NAPT:
					return IP_CLASS_NPE;
				case L34_EXTIP_TYPE_NAT:
					return IP_CLASS_NE;
				case L34_EXTIP_TYPE_LP:
					return IP_CLASS_LP;
				default:
					return IP_CLASS_FAIL;
			}
		}
	}

	pPktHdr->dipL3Idx=_rtk_rg_l3lookup(dip);
	if(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.internal==1)
	{
		//20140829LUKE: here return NPI or NI will produce same result.
		return IP_CLASS_NPI;
	}
	else
		return IP_CLASS_RP;
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_fwdEngineReturn_t _rtk_rg_unmatchBindingAct(rtk_rg_pktHdr_t *pPktHdr, rtk_l34_bindAct_t bindAction, rtk_rg_sipDipClassification_t *sipDipClass)
{
	switch(bindAction)
	{
		case L34_BIND_ACT_DROP:
			TRACE("Unmatch Binding Action: do Drop");
			return (RG_FWDENGINE_RET_DROP);
		case L34_BIND_ACT_TRAP:
			TRACE("Unmatch Binding Action: do Trap");
			return (RG_FWDENGINE_RET_TO_PS);
		case L34_BIND_ACT_FORCE_L2BRIDGE:
			TRACE("Unmatch Binding Action: do Forced Bridge");		//for L2_bind_to_L3 or L2_bind_to_L34
			break;
		case L34_BIND_ACT_PERMIT_L2BRIDGE:
			TRACE("Unmatch Binding Action: do Permit");
			if(pPktHdr->layer2BindNetifIdx!=FAIL)pPktHdr->layer2BindNetifIdx=FAIL;	//for L3_bind_to_L2 or L2_bind_to_customized
			break;
		case L34_BIND_ACT_IPV4_LOOKUPL4TABLE_IPV6_TRAP:
			TRACE("Unmatch Binding Action: do L4 or Trap");
			if(pPktHdr->tagif&IPV6_TAGIF)return (RG_FWDENGINE_RET_TO_PS);	//for L3_bind_to_L34 or L3_bind_to_customized
			if(sipDipClass!=NULL)*sipDipClass=SIP_DIP_CLASS_NAPT;			//for L3_bind_to_L34 or L3_bind_to_customized
			break;
		case L34_BIND_ACT_FORCE_BINDL3_SKIP_LOOKUPL4:
			TRACE("Unmatch Binding Action: do L3 bind and skip L4");
			if(sipDipClass!=NULL)*sipDipClass=SIP_DIP_CLASS_ROUTING;			//for L34_bind_to_L3 or L34_bind_to_customized
			break;
 		case L34_BIND_ACT_FORCE_BINDL3:
			TRACE("Unmatch Binding Action: do bind L3");		//for L3_bind_to_L3 or L3_bind_to_customized
			break;
		case L34_BIND_ACT_NORMAL_LOOKUPL34:
			TRACE("Unmatch Binding Action: do Normal L34");
			if(pPktHdr->bindNextHopIdx!=FAIL)pPktHdr->bindNextHopIdx=FAIL;	//for L34_bind_to_customized
			break;
		default:
			break;
	}

	return (RG_FWDENGINE_RET_CONTINUE);
}

__IRAM_FWDENG_L34
rtk_rg_fwdEngineReturn_t _rtk_rg_routingProcessing(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_arp_linkList_t *pSoftwareArpEntry;

	/* arp table decision */
	if(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process==L34_PROCESS_ARP)
	{
		pPktHdr->netifIdx=rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx; //for Normal Route SMAC

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		goto check_sw_arp;
#elif defined(CONFIG_RG_RTL9600_SERIES)
{
#ifdef CONFIG_APOLLO_MODEL
		pPktHdr->dipArpOrNBIdx=(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.arpStart<<2)+((htonl(*pPktHdr->pIpv4Dip))& ((1<<(31-rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.ipMask))-1));
#else

		pPktHdr->dipArpOrNBIdx=(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.arpStart<<2)+((ntohl(*pPktHdr->pIpv4Dip))& ((1<<(31-rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.ipMask))-1));
#endif
}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
{
		_rtk_rg_softwareArpTableLookUp(pPktHdr->dipL3Idx,ntohl((*pPktHdr->pIpv4Dip)),&pSoftwareArpEntry,0);
		if(pSoftwareArpEntry==NULL)	// sw arp is not found
			_rtk_rg_hardwareArpTableLookUp(pPktHdr->dipL3Idx,ntohl((*pPktHdr->pIpv4Dip)),&pSoftwareArpEntry,0);
		else
			TRACE("Dip hit SW arp table.");
		if(pSoftwareArpEntry!=NULL)
			pPktHdr->dipArpOrNBIdx = pSoftwareArpEntry->idx;
}
#endif

		//if ARP miss, return to PS
		if(pPktHdr->dipArpOrNBIdx==FAIL || rg_db.arp[pPktHdr->dipArpOrNBIdx].rtk_arp.valid==0)
		{
			if(_rtk_rg_fwdengine_handleArpMissInRoutingLookUp(pPktHdr)==RG_FWDENGINE_RET_TO_PS)
				return RG_FWDENGINE_RET_TO_PS;	//trap gateway packet to protocol stack

			//if this packet hit ALG, just drop it, otherwise the ALG function will never be executed!!
			//if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE)
			//{
				//TRACE("Drop!");
				//return RG_FWDENGINE_RET_DROP;
			//}

			TRACE("[Drop] ARP miss, DROP!");
			return RG_FWDENGINE_RET_DROP;
			//return RG_FWDENGINE_RET_DROP; //fixed for no HW arp entry will trap to PS, the SW l4 connection can't create in fwdEngine. ==> but this patch will cause packet to prtocol-stack droped when arp-miss.
		}

		pPktHdr->dmacL2Idx=rg_db.arp[pPktHdr->dipArpOrNBIdx].rtk_arp.nhIdx;
		pPktHdr->aclPolicyRoute_arp2Dmac=1;
		TRACE("ARP netif=%d arp=%d l2=%d\n",pPktHdr->netifIdx,pPktHdr->dipArpOrNBIdx,pPktHdr->dmacL2Idx);
	}

	/* nexthop table decision */
	else if(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process==L34_PROCESS_NH)
	{
		pPktHdr->nexthopIdx=rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.nhStart; //for Normal Route DMAC
		pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Normal Route DMAC
		pPktHdr->netifIdx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.ifIdx; //for Normal Route SMAC
		TRACE("NH netif=%d nh=%d l2=%d\n",pPktHdr->netifIdx,pPktHdr->nexthopIdx,pPktHdr->dmacL2Idx);
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
		if(rg_db.systemGlobal.trap_routing_wan_by_acl)
		{
			return _rtk_rg_checkGwIp(pPktHdr);
		}
#endif
	}
	else if(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process==L34_PROCESS_CPU)
	{
		if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].valid &&
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.is_wan &&
			(rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE))
		{
			pPktHdr->nexthopIdx=rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.nhStart; //for Normal Route DMAC
			pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Normal Route DMAC
			pPktHdr->netifIdx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.ifIdx; //for Normal Route SMAC
			pPktHdr->addNaptSwOnly=1;
			if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
				TRACE("do VXLAN forwarding! netif=%d, dmac=%d, algAction=%d",pPktHdr->netifIdx,pPktHdr->dmacL2Idx,pPktHdr->algAction);
			else
				TRACE("do %s forwarding! netif=%d, dmac=%d, algAction=%d",rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP?"PPTP":
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP?"L2TP":rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE?"DSLITE":"PPPoeDSLITE"
					,pPktHdr->netifIdx,pPktHdr->dmacL2Idx,pPktHdr->algAction);

			return _rtk_rg_checkGwIp(pPktHdr);
		}
		else if(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.ipAddr > 0)
		{
			pPktHdr->netifIdx=rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.netifIdx; //for Normal Route SMAC

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
check_sw_arp:
#endif
			//FIXME:till now default route to CPU is to protocol, if sw routing link-list is implement,
			//the default route in hw will means routing should check sw routing link-list, too.
			TRACE("L34_PROCESS_CPU:software ARP table lookup l3idx=%d",pPktHdr->dipL3Idx);
#ifdef CONFIG_APOLLO_MODEL
			_rtk_rg_softwareArpTableLookUp(pPktHdr->dipL3Idx,(htonl(*pPktHdr->pIpv4Dip)),&pSoftwareArpEntry,0);
#else
			_rtk_rg_softwareArpTableLookUp(pPktHdr->dipL3Idx,ntohl((*pPktHdr->pIpv4Dip)),&pSoftwareArpEntry,0);
#endif
			if(pSoftwareArpEntry==NULL)
			{
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
				//20180726LUKE: for different domain with binding wan, send it directly without request ARP.
				if(pPktHdr->bindNextHopIdx!=FAIL &&	!_rtk_rg_ipv4MatchBindingDomain(pPktHdr->ipv4Dip,pPktHdr->bindNextHopIdx))
				{
					TRACE("outer domain ARP-miss with binding! Send to NH directly!");
					return RG_FWDENGINE_RET_CONTINUE;
				}
#endif
				if(_rtk_rg_fwdengine_handleArpMissInRoutingLookUp(pPktHdr)==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_TO_PS;	//trap gateway packet to protocol stack

				//if this packet hit ALG, just drop it, otherwise the ALG function will never be executed!!
				//if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE)
				//{
					//TRACE("Drop!");
					//return RG_FWDENGINE_RET_DROP;
				//}

				TRACE("[Drop] ARP miss, DROP!");
				return RG_FWDENGINE_RET_DROP;
				//return RG_FWDENGINE_RET_TO_PS;	//arp not valid
			}

			pPktHdr->dipArpOrNBIdx=pSoftwareArpEntry->idx;
			pPktHdr->dmacL2Idx=rg_db.arp[pSoftwareArpEntry->idx].rtk_arp.nhIdx;
			pPktHdr->aclPolicyRoute_arp2Dmac=1;
			TRACE("ARP netif=%d arp=%d l2=%d\n",pPktHdr->netifIdx,pPktHdr->dipArpOrNBIdx,pPktHdr->dmacL2Idx);
		}
		else
		{
			//if this packet hit ALG, just drop it, otherwise the ALG function will never be executed!!
			if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE)
			{
				TRACE("[Drop] hit alg but ipaddr of l3 routing(L34_PROCESS_CPU) entry < 0 , drop!");
				return RG_FWDENGINE_RET_DROP;
			}
			TRACE("[To PS] return to PROTOCOL STACK(Check for policy route or binding first)!");
			return RG_FWDENGINE_RET_ROUTING_TRAP;
		}
	}else {//if(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process==L34_PROCESS_DROP){
		TRACE("L3Decision: Drop!");
		return RG_FWDENGINE_RET_ROUTING_DROP;
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

/* this function will lookup routing,netif,arp,nexthop,extip,l2 tables idx */
rtk_rg_fwdEngineReturn_t _rtk_rg_routingDecisionTablesLookup(rtk_rg_pktHdr_t *pPktHdr, rtk_rg_sipDipClassification_t *sipDipClass)
{
	int wanGroupIdx;
	rtk_rg_fwdEngineReturn_t ret;
	rtk_l34_bindAct_t bindAction=L34_BIND_ACT_END;
	if(*sipDipClass==SIP_DIP_CLASS_HAIRPIN_NAT)
	{
		TRACE("the class is Hairpin NAT");
	}
	else
	{
		TRACE("the class is %s",*sipDipClass==SIP_DIP_CLASS_NAPT?"NAPT":"NAPTR or ROUTING");
	}
	/* Only outbound packet will hit binding table. */
	//20140423LUKE:policyRoute>Binding>normal route, so hit binding only if policyRoute is FAIL!!
	if(rg_db.systemGlobal.initParam.macBasedTagDecision && pPktHdr->aclPolicyRoute==FAIL && ((*sipDipClass==SIP_DIP_CLASS_NAPT) || (*sipDipClass==SIP_DIP_CLASS_ROUTING)) && (rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.rt2waninf==1))
	{
		if(_rtk_rg_bindingRuleCheck(pPktHdr,&wanGroupIdx)==RG_FWDENGINE_RET_HIT_BINDING)
		{
			pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index;	//for Port/VLAN Bidning Route SMAC
			pPktHdr->bindNextHopIdx=rg_db.wantype[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype.nhIdx; //nextHopIdx for pPktHdr->bindNextHopIdx
			if(*sipDipClass==SIP_DIP_CLASS_NAPT)
			{
				switch(rg_db.wantype[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype.wanType)
				{
					case L34_WAN_TYPE_L2_BRIDGE:	//unmatch: follow hw register setting
						TRACE("Unmatch for L34 binding to L2 WAN...");
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L34L2];
						break;
					case L34_WAN_TYPE_L3_ROUTE:	//unmatch: follow hw register setting
						TRACE("Unmatch for L34 binding to L3 WAN...");
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L34L3];
						break;
					case L34_WAN_TYPE_L34NAT_ROUTE:
						TRACE("L4 binding look up success! nhidx = %d",pPktHdr->bindNextHopIdx);
						break;
					case L34_WAN_TYPE_L34_CUSTOMIZED:	//unmatch: follow hw register setting
						TRACE("Unmatch for L34 binding to customized WAN...");
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_CUSTOMIZED_L34];
						break;
					default:
						break;
				}
			}
			else
			{
				switch(rg_db.wantype[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.bind_wan_type_ipv4].rtk_wantype.wanType)
				{
					case L34_WAN_TYPE_L2_BRIDGE:	//unmatch: follow hw register setting
						TRACE("Unmatch for L3 binding to L2 WAN...");
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L3L2];
						break;
					case L34_WAN_TYPE_L3_ROUTE:
						TRACE("Unmatch for L3 binding to L3 WAN...nhidx = %d",pPktHdr->bindNextHopIdx);
						//20140717LUKE: this is special case, though we are binding from L3 to L3, we can have option to trap such packet.
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L3L3];
						break;
					case L34_WAN_TYPE_L34NAT_ROUTE:	//unmatch: follow hw register setting
						TRACE("Unmatch for L3 binding to L34 WAN...");
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L3L34];
						break;
					case L34_WAN_TYPE_L34_CUSTOMIZED:	//unmatch: follow hw register setting
						TRACE("Unmatch for L3 binding to customized WAN...");
						bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_CUSTOMIZED_L3];
						break;
					default:
						break;
				}
			}

			//if unmatch, do action!!
			ret=_rtk_rg_unmatchBindingAct(pPktHdr,bindAction,sipDipClass);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;

			if(pPktHdr->bindNextHopIdx!=FAIL)
			{
				//do the normal route process for DA!!
				ret=_rtk_rg_routingProcessing(pPktHdr);
#if defined(CONFIG_RG_RTL9600_SERIES)
				if(ret==RG_FWDENGINE_RET_ROUTING_TRAP)return RG_FWDENGINE_RET_TO_PS;	//bind must no policy route
				else if(ret==RG_FWDENGINE_RET_ROUTING_DROP)return RG_FWDENGINE_RET_DROP;
#else
				if(ret==RG_FWDENGINE_RET_ROUTING_TRAP || ret==RG_FWDENGINE_RET_ROUTING_DROP)
					TRACE("L3 Binding will over normal route TRAP/DROP.");
#endif
				else if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;

				/* Rome driver should make sure that binding->nexthop is equal to napt->nexthop. */
				pPktHdr->nexthopIdx=pPktHdr->bindNextHopIdx; //for Port/VLAN Bidning Route SMAC/DMAC
				pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index;	//for Port/VLAN Bidning Route SMAC

#if defined(CONFIG_RG_RTL9600_SERIES)
				/* Special case: for binding but interface route, DMAC decision should be from L3->ARP->L2 */
				if(pPktHdr->dipL3Idx==V4_DEFAULT_ROUTE_IDX)
#else
				//20151012LUKE: for ARP-routing, destination address index retrieved from CAM.
				if(pPktHdr->aclPolicyRoute_arp2Dmac==0)
#endif
					pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Port/VLAN Bidning Route DMAC

				/* ext ip table decision */
				pPktHdr->extipIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.extip_idx; /* for NAPT:DMAC, SMAC */
				TRACE("Binding to interface pPktHdr->netifIdx = %d, extipIdx = %d",pPktHdr->netifIdx,pPktHdr->extipIdx);

				//for PPTP or L2TP wan, we add to software napt-list
#if defined(CONFIG_RG_RTL9600_SERIES)
				//20150120LUKE: Dslite, too
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN ||
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
					pPktHdr->addNaptSwOnly=1;
#else
				//20160317LUKE: for ApolloFE, we can use hw to accelerate it.
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
					pPktHdr->addNaptSwOnly=1;
#endif

				//Check MTU
				//TRACE("rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu= %d ,pPktHdr->l3Len %d",rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu,pPktHdr->l3Len);
				if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)		//TooBig, trap to protocol stack
				{
					//FIXME: ip fragment should be done in fwdEngine, not protocol stack...
					//and we should check "Don't fragmets" flag, if enable, we should return ICMP "Packet is too big" infomation.

					pPktHdr->overMTU=1;

					TRACE("packet L3 size(%d) is bigger than interface[%d]'s MTU(%d), DF=%d",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu,pPktHdr->ipv4DontFragment);
					if(pPktHdr->ipv4DontFragment)
					{
						TRACE("[To PS] over mtu but do not fragment");
						return RG_FWDENGINE_RET_TO_PS;
					}
				}

				return RG_FWDENGINE_RET_CONTINUE;
			}
		}
#if 0
		//Port/VLAN Binding
		if(pPktHdr->bindingDecision==RG_BINDING_NOT_FINISHED)
		{
			pPktHdr->bindNextHopIdx=_rtk_rg_portBindingLookup(pPktHdr->ingressMacPort,0,pPktHdr->internalVlanID,*sipDipClass,pPktHdr);
			if(pPktHdr->bindNextHopIdx!=FAIL)
			{
				/* Rome driver should make sure that binding->nexthop is equal to napt->nexthop. */
				pPktHdr->nexthopIdx=pPktHdr->bindNextHopIdx; //for Port/VLAN Bidning Route SMAC/DMAC

				/* Special case: for binding but interface route, DMAC decision should be from L3->ARP->L2 */
				if((pPktHdr->dipL3Idx!=7) && (rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process==L34_PROCESS_ARP))
				{
					pPktHdr->dipArpOrNBIdx=(rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.arpStart<<2)+(ntohl(*pPktHdr->pIpv4Dip)& ((0x1<<(31-rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.ipMask))-1));
					pPktHdr->dmacL2Idx=rg_db.arp[pPktHdr->dipArpOrNBIdx].rtk_arp.nhIdx;
				}
				else
				{
					pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Port/VLAN Bidning Route DMAC
				}
				pPktHdr->netifIdx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.ifIdx; //for Port/VLAN Bidning Route SMAC
				/* ext ip table decision */
				pPktHdr->extipIdx=pPktHdr->netifIdx; /* for NAPT:DMAC, SMAC */
				//DEBUG("Binding to interface pPktHdr->netifIdx = %d",pPktHdr->netifIdx);
				return RG_FWDENGINE_RET_CONTINUE;
			}
		}
		else
		{
			if(pPktHdr->bindNextHopIdx!=FAIL) return RG_FWDENGINE_RET_CONTINUE;
		}
#endif
	}

	//Interface Routing
	if((*sipDipClass==SIP_DIP_CLASS_NAPTR)||(*sipDipClass==SIP_DIP_CLASS_HAIRPIN_NAT))
#ifdef CONFIG_APOLLO_MODEL
		pPktHdr->dipL3Idx=_rtk_rg_l3lookup(htonl(*pPktHdr->pIpv4Dip));
#else
		pPktHdr->dipL3Idx=_rtk_rg_l3lookup(ntohl(*pPktHdr->pIpv4Dip));
#endif
	//DEBUG("ipv4=%x dipL3Idx=%d process=%d\n",*pPktHdr->pIpv4Dip,pPktHdr->dipL3Idx,rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process);
	pPktHdr->aclPolicyRoute_arp2Dmac=0;
	ret=_rtk_rg_routingProcessing(pPktHdr);
	//TRACE("_rtk_rg_routingProcessing  ret=%d ",ret);
	if(ret!=RG_FWDENGINE_RET_CONTINUE && ret!=RG_FWDENGINE_RET_ROUTING_TRAP && ret!=RG_FWDENGINE_RET_ROUTING_DROP)
		return ret;

	//1 Use Policy Route WAN intf instead interface route decision!!
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if( pPktHdr->aclPolicyRoute!=FAIL && ((*sipDipClass==SIP_DIP_CLASS_NAPT) || (*sipDipClass==SIP_DIP_CLASS_ROUTING))	//only L3/L4(TCP, UDP, ICMP) will do policy route!!
		&& (rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo!=NULL))
#else
	if(*sipDipClass==SIP_DIP_CLASS_NAPT && pPktHdr->aclPolicyRoute!=FAIL &&
		rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo!=NULL &&
		rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo->napt_enable)		//only L4(TCP, UDP, ICMP) will do policy route!!only for napt WAN!!
#endif
	{
		TRACE("use WAN%d as policy route",pPktHdr->aclPolicyRoute);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo->napt_enable)
		{
			if(*sipDipClass != SIP_DIP_CLASS_NAPT)
			{
				TRACE("[PolicyRoute] update sipDipClass to NAPT due to WAN%d enable napt",pPktHdr->aclPolicyRoute);
				*sipDipClass = SIP_DIP_CLASS_NAPT;
			}
		}
		else
		{
			if(*sipDipClass != SIP_DIP_CLASS_ROUTING)
			{
				TRACE("[PolicyRoute] update sipDipClass to ROUTING due to WAN%d disable napt",pPktHdr->aclPolicyRoute);
				*sipDipClass = SIP_DIP_CLASS_ROUTING;
			}
		}
#endif
		pPktHdr->netifIdx=pPktHdr->aclPolicyRoute;
		//20141111LUKE: for normal route as ARP, policy route should not change it's DMAC to nexthop, but keep original ARP decision.
		if(!pPktHdr->aclPolicyRoute_arp2Dmac)
		{
			if(pPktHdr->tagif&IPV4_TAGIF){
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.nexthop_ipv4>=0)
					pPktHdr->dmacL2Idx=rg_db.nexthop[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.nexthop_ipv4].rtk_nexthop.nhIdx;
				else{
					TRACE("[To PS] Get IPv4 nexthop fail(%d)...trap!",rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.nexthop_ipv4);
					return RG_FWDENGINE_RET_TO_PS;
				}
			}
		}

		//for PPTP or L2TP wan, we add to software napt-list
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20150120LUKE: Dslite, too
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
			pPktHdr->addNaptSwOnly=1;
#else
		//20160317LUKE: for ApolloFE, we can use hw to accelerate it.
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
			pPktHdr->addNaptSwOnly=1;
#endif
	}
	else if(ret==RG_FWDENGINE_RET_ROUTING_TRAP)return RG_FWDENGINE_RET_TO_PS;	//no Policy-route, trap to protocol stack..
	else if(ret==RG_FWDENGINE_RET_ROUTING_DROP)return RG_FWDENGINE_RET_DROP;	//no Policy-route, drop..

	//Check MTU
	//TRACE("rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu= %d ,pPktHdr->l3Len %d",rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu,pPktHdr->l3Len);
	if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)		//TooBig, trap to protocol stack
	{
		//FIXME: ip fragment should be done in fwdEngine, not protocol stack...
		//and we should check "Don't fragmets" flag, if enable, we should return ICMP "Packet is too big" infomation.

		pPktHdr->overMTU=1;

		TRACE("packet L3 size(%d) is bigger than interface[%d]'s MTU(%d), DF=%d",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu,pPktHdr->ipv4DontFragment);
		if(pPktHdr->ipv4DontFragment)
		{
			TRACE("[To PS] over mtu but do not fragment");
			return RG_FWDENGINE_RET_TO_PS;
		}
	}

	/* ext ip table decision */
	pPktHdr->extipIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.extip_idx; /* for NAPT:DMAC, SMAC */

	//20160527LUKE: if routing table point to different nexthop, we should follow routing table's nexthop
	if(pPktHdr->aclPolicyRoute==FAIL && pPktHdr->nexthopIdx>=0 && pPktHdr->extipIdx>=0 && rg_db.nexthop[pPktHdr->nexthopIdx].extIPMask)
		if(rg_db.nexthop[pPktHdr->nexthopIdx].extIPMask!=(0x1<<pPktHdr->extipIdx))
			for(pPktHdr->extipIdx=0;pPktHdr->extipIdx<MAX_EXTIP_SW_TABLE_SIZE && (rg_db.nexthop[pPktHdr->nexthopIdx].extIPMask>>(pPktHdr->extipIdx+1))>0;pPktHdr->extipIdx++);

	//TRACE("_rtk_rg_routingDecisionTablesLookup ret RG_FWDENGINE_RET_CONTINUE");
	return RG_FWDENGINE_RET_CONTINUE;
}
#if 0
int _rtk_rg_v6RoutingDecisionTablesLookup(rtk_rg_pktHdr_t *pPktHdr, int isLAN2WAN)
{
	rtk_ipv6Neighbor_entry_t *neighbor;
	int ret,neighbor_valid_idx,nb_hash_idx,i;
	if(isLAN2WAN==1) //Only for LAN to WAN packet will hit binding table.
	{
		//Port/VLAN Binding
		if(pPktHdr->bindLookUpFinished==0)
		{
			pPktHdr->bindNextHopIdx=_rtk_rg_portBindingLookup(pPktHdr->ingressMacPort,0,pPktHdr->ctagVid);
			pPktHdr->bindLookUpFinished=1;
			if(pPktHdr->bindNextHopIdx!=FAIL)
			{
				DEBUG("binding hit!");
				pPktHdr->nexthopIdx=pPktHdr->bindNextHopIdx; //for Port/VLAN Bidning Route SMAC/DMAC
				pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Port/VLAN Bidning Route DMAC
				pPktHdr->netifIdx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.ifIdx; //for Port/VLAN Bidning Route SMAC
				/* ext ip table decision */
				//pPktHdr->extipIdx=pPktHdr->netifIdx; /* for NAPT:DMAC, SMAC */
				//DEBUG("pPktHdr->netifIdx = %d",pPktHdr->netifIdx);
				return RG_FWDENGINE_RET_DIRECT_TX;
			}
		}
		else if(pPktHdr->bindNextHopIdx!=FAIL)
			return RG_FWDENGINE_RET_DIRECT_TX;

	}

	//Interface Routing
	ret=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
	if(ret<0)return RG_FWDENGINE_RET_TO_PS;

	pPktHdr->dipL3Idx=ret;
	//DEBUG("ipv4=%x dipL3Idx=%d process=%d\n",pPktHdr->ipv4Dip,pPktHdr->dipL3Idx,rg_db.l3[pPktHdr->dipL3Idx].rtk_l3.process);
	DEBUG("the rout type is %x",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.type)
	switch(rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.type)
	{
		/* neighbor table decision */
		case L34_IPV6_ROUTE_TYPE_LOCAL:
		{
			pPktHdr->netifIdx=rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.nhOrIfidIdx; //for Normal Route SMAC
			ret=0;
			nb_hash_idx = _rtk_rg_IPv6NeighborHash(pPktHdr->pIpv6Dip+8, (unsigned char)pPktHdr->dipL3Idx);
			for(i=0;i<8;i++)
			{
				neighbor_valid_idx=(nb_hash_idx<<3)+i;
				//rtlglue_printf("the matchNeighbor idx = %d\n",matchNeighbor);
				DEBUG("the valid neighbor idx is %d",neighbor_valid_idx);
				neighbor = &rg_db.v6neighbor[neighbor_valid_idx].rtk_v6neighbor;
				//rtlglue_printf("the neighbor.ipv6RouteIdx = %d, matchEntry = %d\n",neighbor.ipv6RouteIdx,matchEntry);
				if(neighbor->valid &&
					(neighbor->ipv6RouteIdx == pPktHdr->dipL3Idx)&&
					(_rtk_rg_CompareIFID(pPktHdr->pIpv6Dip+8, neighbor->ipv6Ifid)))
				{
					//rtlglue_printf("HIT!!!!!\n");
					DEBUG("IPv6: Hit neighbor table!L2IDX = %d rt=%d",neighbor->l2Idx,pPktHdr->dipL3Idx);
					ret = 1;
					break;
				}
			}
			if(ret==0)	//neighbor lookup miss
			{
				DEBUG("before ret to PS in RDTL");
				return RG_FWDENGINE_RET_TO_PS;
			}
			pPktHdr->dipArpOrNBIdx=neighbor_valid_idx;
			pPktHdr->dmacL2Idx=neighbor->l2Idx;
			//DEBUG("Local netif=%d nb=%d l2=%d\n",pPktHdr->netifIdx,pPktHdr->dipArpOrNBIdx,pPktHdr->dmacL2Idx);
			break;
		}
		/* nexthop table decision */
		case L34_IPV6_ROUTE_TYPE_GLOBAL:
		{
			pPktHdr->nexthopIdx=rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.nhOrIfidIdx; //for Normal Route DMAC
			pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Normal Route DMAC
			pPktHdr->netifIdx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.ifIdx; //for Normal Route SMAC
			//DEBUG("Global netif=%d nh=%d l2=%d\n",pPktHdr->netifIdx,pPktHdr->nexthopIdx,pPktHdr->dmacL2Idx);
			break;
		}
		case L34_IPV6_ROUTE_TYPE_TRAP:
			return RG_FWDENGINE_RET_TO_PS;
		default:	//L34_IPV6_ROUTE_TYPE_DROP
			return RG_FWDENGINE_RET_DROP;
	}

	return RG_FWDENGINE_RET_DIRECT_TX;
}
#endif

//void dump_packet(u8 *pkt,u32 size,char *memo);

#ifdef CONFIG_ROME_NAPT_LRU
#else
rtk_rg_successFailReturn_t _rtk_rg_fwdEngineNaptEarlyDrop(int16 ignorePort)
{
	int score,high_score=0;
	int earlyDropCandicate=-1;
	//int idleDropCandicate=-1;
	//int longestIdleTime=0;
	int i;

	for(i=0;i<MAX_NAPT_OUT_SW_TABLE_SIZE;i++) //Lookup SW dropable entry
	{
		if((rg_db.naptOut[i].state==INVALID) || (rg_db.naptOut[i].state==TCP_CONNECTED) || (rg_db.naptOut[i].state==UDP_CONNECTED)) continue;
		if(rg_db.naptOut[i].extPort==ignorePort) continue;

		score=((rg_db.naptOut[i].state==FIRST_FIN)||(rg_db.naptOut[i].state==RST_RECV))?2:1;
		if(score>high_score)
		{
			high_score=score;
			earlyDropCandicate = i;
		}
		//DEBUG("Drop score:%d secs drop candicate:%d\n",score,earlyDropCandicate);
		if(score >= 2) break;
	}
	if(earlyDropCandicate>=0)
	{
		rtlglue_printf("NAPT Full, delete non-established entry :%d num:%d\n",earlyDropCandicate,atomic_read(&rg_db.naptForwardEngineEntryNumber[0]));
		(pf.rtk_rg_naptConnection_del)(earlyDropCandicate);
	}
	else
	{
		if(rg_db.longestIdleNaptIdx==FAIL)
		{
			WARNING("NAPT Full, delete longest expired entry failly!\n");
			return RG_RET_FAIL;
		}

		rtlglue_printf("NAPT Full, delete longest expired entry :%d num:%d\n",rg_db.longestIdleNaptIdx,atomic_read(&rg_db.naptForwardEngineEntryNumber[0]));
		(pf.rtk_rg_naptConnection_del)(rg_db.longestIdleNaptIdx);
		rg_db.longestIdleNaptIdx = FAIL;
	}
	return RG_RET_SUCCESS;
}
#endif

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
rtk_rg_extPortGetReturn_t _rtk_rg_ipv6_naptExtPortInUsedCheckint (int isTcp,uint16 wishPort)
{
	int wishIdx;
	uint32 wishBitValue;

	wishIdx=wishPort>>5; // =wishPort/32
	wishBitValue=1<<(wishPort&0x1f);

	if(isTcp)
	{
		if(((rg_db.ipv6naptTcpExternPortUsed[wishIdx]&wishBitValue)==0))
		{
			rg_db.ipv6naptTcpExternPortUsed[wishIdx]|=wishBitValue;
			return 0; //free
		}else{
			DEBUG("wishPort(%d) is already used!",wishPort);
		}
	}
	else
	{
		if(((rg_db.ipv6naptUdpExternPortUsed[wishIdx]&wishBitValue)==0))
		{
			rg_db.ipv6naptUdpExternPortUsed[wishIdx]|=wishBitValue;
			return 0; //free
		}else{
			DEBUG("wishPort(%d) is already used!",wishPort);
		}
	}

	return RG_RET_EXTPORT_NOT_GET; //used
}



rtk_rg_extPortGetReturn_t _rtk_rg_ipv6_naptExtPortGetAndUse(int isTcp,uint16 wishPort){
	int i;
	i=wishPort;

	while(1)
	{
		if(_rtk_rg_ipv6_naptExtPortInUsedCheckint(isTcp,i)==0) // free
		{
			return i;
		}
		i++;
		i&=0xffff;

		//all port in used
		if(i==wishPort) break;

	}

	//no port can be used
	return RG_RET_EXTPORT_NOT_GET;
}


rtk_rg_successFailReturn_t _rtk_rg_ipv6_naptExtPortFree(int isTcp,uint16 wishPort){

	int wishIdx;
	uint32 wishBitValue;

	wishIdx=wishPort>>5; // =wishPort/32
	wishBitValue=1<<(wishPort&0x1f);


	DEBUG("Free IPv6 NAPT Extport(%d), isTcp=%d, wishIdx=%d, wishBitValue=0x%x",wishPort,isTcp,wishIdx,wishBitValue);
	if(isTcp)
	{
		if(((rg_db.ipv6naptTcpExternPortUsed[wishIdx]&wishBitValue)))
		{
			rg_db.ipv6naptTcpExternPortUsed[wishIdx]&=(~wishBitValue);
			//DEBUG("rg_db.ipv6naptTcpExternPortUsed[%d]=0x%x",wishIdx,rg_db.ipv6naptTcpExternPortUsed[wishIdx]);
			return RG_RET_SUCCESS; //free
		}else{
			DEBUG("wishPort(%d) is already free!",wishPort);
		}
	}
	else
	{
		if(((rg_db.ipv6naptUdpExternPortUsed[wishIdx]&wishBitValue)))
		{
			rg_db.ipv6naptUdpExternPortUsed[wishIdx]&=(~wishBitValue);
			//DEBUG("rg_db.ipv6naptUdpExternPortUsed[%d]=0x%x",wishIdx,rg_db.ipv6naptTcpExternPortUsed[wishIdx]);
			return RG_RET_SUCCESS; //free
		}else{
			DEBUG("wishPort(%d) is already free!",wishPort);
		}
	}
	return RG_RET_FAIL;

}

#endif


/* force: Force to use the wishPort. For inbound connection, we don't modify the wishPort number. */
__SRAM_FWDENG_SLOWPATH
rtk_rg_extPortGetReturn_t _rtk_rg_naptExtPortGetAndUse(int force, int isTcp, uint32 internalIp, uint16 internalPort, uint16 wishPort, uint32 *pIp, int addRefCnt, int naptrLookupHit)
{
	int i;
	int maxFindHwInCnt=16;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	uint32 shiftBits=2;
	uint32 naptWay=3;	//4-way
#endif

#if defined(CONFIG_RG_NAPT_NEW_EXTPORT_MECHANISM)
{
	uint16 extPortIdx;
	if(_rtk_rg_napt_extPort_record_find(force, isTcp, internalIp, internalPort, &extPortIdx)==RT_ERR_RG_OK)
	{
		if(addRefCnt)
		{
			atomic_inc(&rg_db.naptForwardEngineEntryNumber[isTcp]);
			assert_ok(_rtk_rg_napt_extPort_record_add(force, isTcp, internalIp, internalPort, extPortIdx));
		}
		return extPortIdx;
	}
}
#endif

	i=wishPort;
	while(1)
	{
		if(!force)
		{
			//skip port range used by protocol stack
			if(!(rg_kernel.lowerBoundPortUsedByPS==0 && rg_kernel.upperBoundPortUsedByPS==0) &&
				rg_kernel.lowerBoundPortUsedByPS<=i && i<=rg_kernel.upperBoundPortUsedByPS)
			{
				DEBUG("skip port range %d ~ %d used by PS", rg_kernel.lowerBoundPortUsedByPS, rg_kernel.upperBoundPortUsedByPS);
				if(i==wishPort) wishPort=rg_kernel.lowerBoundPortUsedByPS-1;
				i=rg_kernel.upperBoundPortUsedByPS+1;
				if(i==wishPort) break;
			}
		}

		if(_rtk_rg_naptExtPortInUsedCheck(force, isTcp, internalIp, internalPort, i, FALSE, naptrLookupHit, TRUE)==0) // free
		{
			if((force==FALSE)&&(rg_db.systemGlobal.enableL4ChoiceHwIn==1)&&(pIp!=NULL))
			{
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				int hashIdx,j;

				hashIdx=_rtk_rg_naptTcpUdpInHashIndex(isTcp,ntohl(*pIp),i);
				for(j=(hashIdx<<shiftBits)+naptWay;j>=(hashIdx<<shiftBits);j--)
				{
					if(rg_db.naptIn[j].rtk_naptIn.valid==0)
					{
						if(addRefCnt)
						{
							atomic_inc(&rg_db.naptForwardEngineEntryNumber[isTcp]);
							_rtk_rg_naptExtPortInUsedCheck(force, isTcp, internalIp, internalPort, i, TRUE, naptrLookupHit, TRUE);
						}
						return i; //found a valid entry in this hashIdx
					}
				}
#else	// CONFIG_RG_FLOW_BASED_PLATFORM
				uint32 canAddToHw = FALSE;
				if(rg_db.pktHdr->fwdDecision==RG_FWD_DECISION_NAPT)
					canAddToHw = _rtk_rg_flow_canAddNaptInboundInHw(rg_db.pktHdr->ipv4Dip, ntohl(*pIp), rg_db.pktHdr->dport, i, isTcp);
				else	//RG_FWD_DECISION_NAPTR
					canAddToHw = _rtk_rg_flow_canAddNaptInboundInHw(rg_db.pktHdr->ipv4Sip, ntohl(*pIp), rg_db.pktHdr->sport, i, isTcp);

				if(canAddToHw)
				{
					if(addRefCnt)
					{
						atomic_inc(&rg_db.naptForwardEngineEntryNumber[isTcp]);
						_rtk_rg_naptExtPortInUsedCheck(force, isTcp, internalIp, internalPort, i, TRUE, naptrLookupHit, TRUE);
					}
					return i; //found a valid entry in this hashIdx
				}
#endif

				maxFindHwInCnt--;
				if(maxFindHwInCnt<=0)
				{
					if(addRefCnt)
					{
						atomic_inc(&rg_db.naptForwardEngineEntryNumber[isTcp]);
						_rtk_rg_naptExtPortInUsedCheck(force, isTcp, internalIp, internalPort, i, TRUE, naptrLookupHit, TRUE);
					}
					return i; //not find any free HW inbound entry.
				}
			}
			else
			{
				if(addRefCnt)
				{
					atomic_inc(&rg_db.naptForwardEngineEntryNumber[isTcp]);
					_rtk_rg_naptExtPortInUsedCheck(force, isTcp, internalIp, internalPort, i, TRUE, naptrLookupHit, TRUE);
				}
#ifdef CONFIG_ROME_NAPT_LRU
#else
				DEBUG("[NAPT] Add forwarding engine connection flow:%d\n",atomic_read(&rg_db.naptForwardEngineEntryNumber[0])+atomic_read(&rg_db.naptForwardEngineEntryNumber[1]));
				if((atomic_read(&rg_db.naptForwardEngineEntryNumber[0])+atomic_read(&rg_db.naptForwardEngineEntryNumber[1]))>MAX_NAPT_OUT_SW_TABLE_SIZE)
				{
					if(_rtk_rg_fwdEngineNaptEarlyDrop(i)!=RG_RET_FAIL)
						return RG_RET_EXTPORT_NOT_GET;
				}
#endif
				return i;
			}
		}
		i++;
		i&=0xffff;


		if(i==wishPort) break;

	}
	return RG_RET_EXTPORT_NOT_GET;
}

#ifdef CONFIG_ROME_NAPT_SHORTCUT
rtk_rg_entryGetReturn_t _rtk_rg_shortcutARPFind(int routingIdx, ipaddr_t ipAddr)
{
	int arpIdx=RG_RET_ENTRY_NOT_GET;
	rtk_rg_arp_linkList_t *pSwArpList;

	if(routingIdx>=0)
	{
		if(rg_db.l3[routingIdx].rtk_l3.process==L34_PROCESS_ARP)
		{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			goto check_sw_arp;
#elif defined(CONFIG_RG_RTL9600_SERIES)
			arpIdx=(rg_db.l3[routingIdx].rtk_l3.arpStart<<2)+(ipAddr & ((1<<(31-rg_db.l3[routingIdx].rtk_l3.ipMask))-1));
			if(!rg_db.arp[arpIdx].rtk_arp.valid)
				arpIdx=RG_RET_ENTRY_NOT_GET;
#elif defined(CONFIG_RG_RTL9602C_SERIES)
			_rtk_rg_hardwareArpTableLookUp(routingIdx,ipAddr,&pSwArpList,0);
			if(pSwArpList==NULL)
				_rtk_rg_softwareArpTableLookUp(routingIdx,ipAddr,&pSwArpList,0);
			if(pSwArpList!=NULL)
			{
				arpIdx=pSwArpList->idx;
				if(!rg_db.arp[arpIdx].rtk_arp.valid)
					arpIdx=RG_RET_ENTRY_NOT_GET;
			}
#endif
		}
		else if((rg_db.l3[routingIdx].rtk_l3.process==L34_PROCESS_CPU)&&(rg_db.l3[routingIdx].rtk_l3.ipAddr>0))
		{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
check_sw_arp:
#endif
			_rtk_rg_softwareArpTableLookUp(routingIdx,ipAddr,&pSwArpList,0);
			if(pSwArpList!=NULL)
			{
				arpIdx=pSwArpList->idx;
				if(!rg_db.arp[arpIdx].rtk_arp.valid)
					arpIdx=RG_RET_ENTRY_NOT_GET;
			}
		}
	}

	return arpIdx;
}

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
rtk_rg_entryGetReturn_t _rtk_rg_v4ShortCutFreeEntryGet(int hashIdx, uint32 sip, uint32 dip, uint16 sport, uint16 dport, uint8 isTcp)
{
	int i, first_invalid;
	uint32 longestIdx, longestIdletime;

	first_invalid = FAIL;
	longestIdx = hashIdx;
	longestIdletime = 0;
	for(i=hashIdx; i<hashIdx+MAX_NAPT_SHORTCUT_WAYS; i++)
	{
		if(!RG_V4SC_VALID(i))
		{
			if(first_invalid==FAIL)
				first_invalid = i;
			continue;
		}
		if((rg_db.naptShortCut[i].sip==sip) &&
			(rg_db.naptShortCut[i].dip==dip) &&
			(rg_db.naptShortCut[i].sport==sport) &&
			(rg_db.naptShortCut[i].dport==dport) &&
			(rg_db.naptShortCut[i].isTcp==isTcp))
			return i;

		if(rg_db.naptShortCut[i].idleSecs > longestIdletime)
		{
			longestIdx = i;
			longestIdletime = rg_db.naptShortCut[i].idleSecs;
		}
	}

	if(first_invalid!=FAIL)
		return first_invalid;

	if(longestIdletime==0) //choose last add index+1
	{
		DEBUG("V4shortcut LRU, do round robin!");
		longestIdx += ((rg_db.v4ShortCut_lastAddIdx[hashIdx>>MAX_NAPT_SHORTCUT_WAYS_SHIFT]+1) & (MAX_NAPT_SHORTCUT_WAYS-1));
		longestIdletime = rg_db.naptShortCut[longestIdx].idleSecs;
	}

	DEBUG("V4shortcut LRU choose victim[%d], idletime: %d secs", longestIdx, longestIdletime);
	_rtk_rg_v4ShortCut_delete(longestIdx);

	if(rg_db.systemGlobal.fwdStatistic)
		rg_db.systemGlobal.statistic.perPortCnt_v4ShortcutLRU[rg_db.pktHdr->ingressPort]++;

	return longestIdx;

}
#endif

__SRAM_FWDENG_SLOWPATH
void _rtk_rg_naptShortcutUpdate(rtk_rg_pktHdr_t *pPktHdr,int dir,int naptIdx, int isNapt, int isBridge)
{
	int isTcp=0;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	int freeIdx=0;
	int shortcutIdx=0;
#endif

	if(pPktHdr->aclHit) 
	{	
		TRACE("ACL hit...don't update shortCut!");
		return;
	}


	if(pPktHdr->tagif&TCP_TAGIF)
		isTcp=1;
	//Check for ALG
	if(isNapt && pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE)
		//((_rtk_rg_algCheckEnable(isTcp,pPktHdr->dport)==SUCCESS) || (_rtk_rg_algCheckEnable(isTcp,pPktHdr->sport)==SUCCESS)	 ||	//check ALG serverInWan outbound and inbound port
		//(_rtk_rg_algSrvInLanCheckEnable(isTcp,pPktHdr->sport)==SUCCESS) || (_rtk_rg_algSrvInLanCheckEnable(isTcp,pPktHdr->dport)==SUCCESS)))	//check ALG serverInLan outbound and inbound port
	{
		TRACE("ALG enable port...don't update shortCut!");
		return;
	}

	//20180417LUKE: bypass DIP as 255.255.255.255
	if(pPktHdr->ipv4Dip==0xffffffff)
	{
		TRACE("broadcast DIP...don't update shortCut!");
		return;
	}

	//20170816LUKE: enable overMTU forwarded by shortcut.
	/*if(pPktHdr->overMTU==1)
	{
		TRACE("over MTU...don't update shortCut!");
		return;
	}*/

	//20160224LUKE: prevent http downstream into shortcut
	if((rg_db.redirectHttpRsp.enable)&&(isTcp)&&(pPktHdr->sport==rg_db.systemGlobal.httpMonitorPort)){
		TRACE("redirect Http response is enable...don't update shortCut!");
		return;
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if((pPktHdr->isHairpinNat)&&(dir==NAPT_DIRECTION_OUTBOUND))
	{
		pPktHdr->pCurrentShortcutEntry=&rg_db.hairpinNatShortcut;
	}
	else
	{
		pPktHdr->pCurrentShortcutEntry=&rg_db.currentShortcut;
	}
#else	//not CONFIG_RG_FLOW_BASED_PLATFORM
	//20140813LUKE: use hash to get index!!
	shortcutIdx=_rtk_rg_shortcutHashIndex(pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
	freeIdx = _rtk_rg_v4ShortCutFreeEntryGet(shortcutIdx, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->sport, pPktHdr->dport, isTcp);
	if(freeIdx==RG_RET_ENTRY_NOT_GET)
	{
		WARNING("Can not get free v4 shortcut entry!");
		return;
	}
	pPktHdr->currentShortcutIdx=freeIdx;
	pPktHdr->pCurrentShortcutEntry=&rg_db.naptShortCut[freeIdx];
	rg_db.v4ShortCutValidSet[freeIdx>>5] |= (0x1<<(freeIdx&0x1f));
	rg_db.v4ShortCut_lastAddIdx[shortcutIdx>>MAX_NAPT_SHORTCUT_WAYS_SHIFT] = (freeIdx-shortcutIdx);
#endif
	memset(pPktHdr->pCurrentShortcutEntry, 0, sizeof(rtk_rg_napt_shortcut_t));
	pPktHdr->pCurrentShortcutEntry->idleSecs= 0;
	if((pPktHdr->isHairpinNat)&&(dir==NAPT_DIRECTION_OUTBOUND))
	{
		pPktHdr->pCurrentShortcutEntry->notFinishUpdated=0;
		pPktHdr->pCurrentShortcutEntry->isHairpinNat=1;
	}
	else
	{
		pPktHdr->pCurrentShortcutEntry->notFinishUpdated=1;
		pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE_BEFORE_SEND;
	}
	pPktHdr->pCurrentShortcutEntry->sip=pPktHdr->ipv4Sip; //SIP
	pPktHdr->pCurrentShortcutEntry->dip=pPktHdr->ipv4Dip; //DIP
	pPktHdr->pCurrentShortcutEntry->sport=pPktHdr->sport; //SPORT
	pPktHdr->pCurrentShortcutEntry->dport=pPktHdr->dport; //DPORT

#if defined(SHORTCUT_BITFILED_DEBUG)
	assert(pPktHdr->ingressPort >= 0 && pPktHdr->ingressPort < (1 << BFW_SPA));
	assert(isTcp >= 0 && isTcp < (1 << BFW_ISTCP));
	assert(pPktHdr->dmacL2Idx < (1 << (BFW_LUTIDX-1)));
	assert(pPktHdr->netifIdx < (1 << (BFW_INTFIDX-1)));
	assert(pPktHdr->extipIdx < (1 << (BFW_EIPIDX-1)));
	assert(naptIdx < (1 << (BFW_NAPTIDX)));
	assert(isNapt >= 0 && isNapt < (1 << (BFW_ISNAPT)));
	assert(isBridge >= 0 && isBridge < (1 << (BFW_ISBRIDGE)));
	assert(dir >= 0 && dir < (1 << (BFW_DIR)));
	assert(_rtk_rg_shortcutARPFind(pPktHdr->sipL3Idx, pPktHdr->ipv4Sip) < (1 << (BFW_ARPIDX-1)));
#endif

	pPktHdr->pCurrentShortcutEntry->spa=pPktHdr->ingressPort;
	pPktHdr->pCurrentShortcutEntry->srcWlanDevIdx=pPktHdr->wlan_dev_idx;
	pPktHdr->pCurrentShortcutEntry->isTcp=isTcp;
	pPktHdr->pCurrentShortcutEntry->new_lut_idx=pPktHdr->dmacL2Idx; //DMAC
	pPktHdr->pCurrentShortcutEntry->new_intf_idx=pPktHdr->netifIdx; //SMAC
	pPktHdr->pCurrentShortcutEntry->new_eip_idx=pPktHdr->extipIdx; //for outbound sip
	pPktHdr->pCurrentShortcutEntry->naptIdx=naptIdx;	//routing won't referenced this field
	pPktHdr->pCurrentShortcutEntry->isNapt=isNapt;		//routing won't referenced this field
	pPktHdr->pCurrentShortcutEntry->isBridge=isBridge;	//routing won't referenced this field
	pPktHdr->pCurrentShortcutEntry->isLocalInNapt=pPktHdr->isLocalInNapt;
	pPktHdr->pCurrentShortcutEntry->direction=dir;
	//20150115LUKE: keep ARP idx in shortcut for updating.
	pPktHdr->pCurrentShortcutEntry->arpIdx=_rtk_rg_shortcutARPFind(pPktHdr->sipL3Idx, pPktHdr->ipv4Sip);
	//20150922: keep smac L2 index in shoutcut for updating.
	pPktHdr->pCurrentShortcutEntry->smacL2Idx = pPktHdr->smacL2Idx;
	pPktHdr->pCurrentShortcutEntry->naptFilterRateLimitIdx = pPktHdr->naptFilterRateLimitIdx;
	pPktHdr->pCurrentShortcutEntry->naptFilterPktCntIdx = pPktHdr->naptFilterPktCntIdx;
	pPktHdr->pCurrentShortcutEntry->naptFilterByteCnttIdx = pPktHdr->naptFilterByteCnttIdx;
	pPktHdr->pCurrentShortcutEntry->naptFilterCopyCnt = pPktHdr->naptFilterCopyCnt;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	pPktHdr->pCurrentShortcutEntry->flowmib_idx = pPktHdr->flowMIBCounterIdx;

	TRACE("[Update SC] dir:%s da=%d sa_intf=%d eipIdx=%d naptIdx=%d",(dir==NAPT_DIRECTION_INBOUND)?"IN":"OUT",pPktHdr->dmacL2Idx,pPktHdr->netifIdx,pPktHdr->extipIdx,naptIdx);
	TRACE("isTcp:%d src:0x%x:%d dst:0x%x:%d",isTcp,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
	TABLE("Add SC: [sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d][isHairpin=%d][naptRateIdx=%d][naptPktCntIdx=%d][naptByteCntIdx=%d][naptCopyCnt=%d]",pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,isTcp,pPktHdr->pCurrentShortcutEntry->isHairpinNat,pPktHdr->pCurrentShortcutEntry->naptFilterRateLimitIdx,pPktHdr->pCurrentShortcutEntry->naptFilterPktCntIdx,pPktHdr->pCurrentShortcutEntry->naptFilterByteCnttIdx,pPktHdr->pCurrentShortcutEntry->naptFilterCopyCnt);
#else
	TRACE("[Update SC:%d] dir:%s da=%d sa_intf=%d eipIdx=%d naptIdx=%d",freeIdx,(dir==NAPT_DIRECTION_INBOUND)?"IN":"OUT",pPktHdr->dmacL2Idx,pPktHdr->netifIdx,pPktHdr->extipIdx,naptIdx);
	TRACE("isTcp:%d src:0x%x:%d dst:0x%x:%d",isTcp,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
	TABLE("Add SC: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d][isHairpin=%d][naptRateIdx=%d][naptPktCntIdx=%d][naptByteCntIdx=%d][naptCopyCnt=%d]",freeIdx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,isTcp,pPktHdr->pCurrentShortcutEntry->isHairpinNat,pPktHdr->pCurrentShortcutEntry->naptFilterRateLimitIdx,pPktHdr->pCurrentShortcutEntry->naptFilterPktCntIdx,pPktHdr->pCurrentShortcutEntry->naptFilterByteCnttIdx,pPktHdr->pCurrentShortcutEntry->naptFilterCopyCnt);
#endif
	//20140811LUKE: add dual direction shortcut to acclerate SYN-ACK when tcp_hw_learning_at_syn is on!!
	//20161230: does not add inbound shortcut if it is hairpin nat
	//20180427LUKE: add inbound shortcut if we accelerate DPI.
	if(isNapt && isTcp && ((rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)||(rg_db.systemGlobal.dpi_accelerate_enable&&time_is_after_jiffies(rg_db.systemGlobal.dpi_accelerate_jiffies))) && dir==NAPT_DIRECTION_OUTBOUND && pPktHdr->isHairpinNat==0)
	{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->pInboundShortcutEntry=&rg_db.inboundShortcut;
#else	//not CONFIG_RG_FLOW_BASED_PLATFORM
		shortcutIdx=_rtk_rg_shortcutHashIndex(pPktHdr->ipv4Dip,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,pPktHdr->dport,rg_db.naptOut[naptIdx].extPort);
		freeIdx = _rtk_rg_v4ShortCutFreeEntryGet(shortcutIdx, pPktHdr->ipv4Dip, rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr, pPktHdr->dport, rg_db.naptOut[naptIdx].extPort, isTcp);
		if(freeIdx==RG_RET_ENTRY_NOT_GET)
		{
			WARNING("Can not get free v4 shortcut entry!");
			return;
		}
		pPktHdr->inboundShortcutIdx=freeIdx;
		pPktHdr->pInboundShortcutEntry=&rg_db.naptShortCut[freeIdx];
		rg_db.v4ShortCutValidSet[freeIdx>>5] |= (0x1<<(freeIdx&0x1f));
		rg_db.v4ShortCut_lastAddIdx[shortcutIdx>>MAX_NAPT_SHORTCUT_WAYS_SHIFT] = (freeIdx-shortcutIdx);
#endif
		memset(pPktHdr->pInboundShortcutEntry, 0, sizeof(rtk_rg_napt_shortcut_t));
		pPktHdr->pInboundShortcutEntry->idleSecs=0;
		pPktHdr->pInboundShortcutEntry->notFinishUpdated=1;
		pPktHdr->pInboundShortcutEntry->sip=pPktHdr->ipv4Dip;
		pPktHdr->pInboundShortcutEntry->dip=rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr;	//WAN IP
		pPktHdr->pInboundShortcutEntry->sport=pPktHdr->dport;
		pPktHdr->pInboundShortcutEntry->dport=rg_db.naptOut[naptIdx].extPort;	//external port
		pPktHdr->pInboundShortcutEntry->spa=RTK_RG_PORT_MAX;	//decided when inbound
		pPktHdr->pInboundShortcutEntry->srcWlanDevIdx=FAIL;

#if defined(SHORTCUT_BITFILED_DEBUG)
		assert(isTcp >= 0  && isTcp < (1 << BFW_ISTCP));
		assert(pPktHdr->smacL2Idx < (1 << (BFW_LUTIDX-1)));
		assert(pPktHdr->srcNetifIdx < (1 << (BFW_INTFIDX-1)));
		assert(rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx >= 0 && rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx < (1 << (BFW_NAPTIDX)));
		assert(isNapt >= 0 && isNapt < (1 << (BFW_ISNAPT)));
		assert(isBridge >= 0 && isBridge < (1 << (BFW_ISBRIDGE)));
		assert(_rtk_rg_shortcutARPFind(_rtk_rg_l3lookup(pPktHdr->ipv4Dip), pPktHdr->ipv4Dip) < (1 << (BFW_ARPIDX-1)));
		assert(pPktHdr->dmacL2Idx < (1 << (BFW_SMACL2IDX-1)));
		assert(pPktHdr->internalVlanID >= 0 && pPktHdr->internalVlanID < (1 << (BFW_VLANID)));

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
		assert(pPktHdr->dmacL2Idx < (1 << (BFW_SMACL2IDX-1)));
#endif

#ifdef CONFIG_GPON_FEATURE
		assert(pPktHdr->streamID >= 0 && pPktHdr->streamID < (1 << (BFW_STREAMID)));
#endif
		assert(pPktHdr->ingressDecideVlanID >= 0 && pPktHdr->ingressDecideVlanID < (1 << (BFW_INTERVLANID)));
#endif
		pPktHdr->pInboundShortcutEntry->isTcp=isTcp;
		pPktHdr->pInboundShortcutEntry->new_lut_idx=pPktHdr->smacL2Idx; //DMAC
		pPktHdr->pInboundShortcutEntry->new_intf_idx=pPktHdr->srcNetifIdx; //SMAC
		pPktHdr->pInboundShortcutEntry->new_eip_idx=pPktHdr->srcNetifIdx; //for outbound sip
		pPktHdr->pInboundShortcutEntry->naptIdx=rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx;	//routing won't referenced this field
		pPktHdr->pInboundShortcutEntry->isNapt=isNapt;		//routing won't referenced this field
		pPktHdr->pInboundShortcutEntry->isBridge=isBridge;	//routing won't referenced this field
		pPktHdr->pInboundShortcutEntry->isLocalInNapt=0;
		pPktHdr->pInboundShortcutEntry->direction=NAPT_DIRECTION_INBOUND;		//routing won't referenced this field
		//20150115LUKE: keep ARP idx in shortcut for updating.
		pPktHdr->pInboundShortcutEntry->arpIdx=_rtk_rg_shortcutARPFind(_rtk_rg_l3lookup(pPktHdr->ipv4Dip), pPktHdr->ipv4Dip);
		//20150922: keep smac L2 index in shoutcut for updating.
		pPktHdr->pInboundShortcutEntry->smacL2Idx = pPktHdr->dmacL2Idx;
		pPktHdr->pInboundShortcutEntry->naptFilterRateLimitIdx = FAIL;	//for learned_at_syn we can't decide limit index here, so just set to FAIL!!!
		pPktHdr->pInboundShortcutEntry->naptFilterPktCntIdx = FAIL;
		pPktHdr->pInboundShortcutEntry->naptFilterByteCnttIdx = FAIL;
		pPktHdr->pInboundShortcutEntry->naptFilterCopyCnt = 0;
#ifdef CONFIG_GPON_FEATURE
		pPktHdr->pInboundShortcutEntry->streamID=pPktHdr->streamID;
#endif
		pPktHdr->pInboundShortcutEntry->vlanID=pPktHdr->internalVlanID;
		pPktHdr->pInboundShortcutEntry->vlanTagif=(pPktHdr->tagif&CVLAN_TAGIF)>0;
		pPktHdr->pInboundShortcutEntry->dmac2cvlanID=FAIL;
		pPktHdr->pInboundShortcutEntry->dmac2cvlanTagif=0;

		pPktHdr->pInboundShortcutEntry->internalVlanID = pPktHdr->ingressDecideVlanID; //learn at syn, we should give it a reasonable internalVlan(now ithe vlan comes from _rtk_rg_ingressVlanDecision())

		if(rg_db.vlan[pPktHdr->internalVlanID].priorityEn==1)
		{
			pPktHdr->pInboundShortcutEntry->priority=rg_db.vlan[pPktHdr->internalVlanID].priority&0x7;
		}
		else
			pPktHdr->pInboundShortcutEntry->priority=0;
		pPktHdr->pInboundShortcutEntry->internalCFPri=0;
		pPktHdr->pInboundShortcutEntry->dscp=FAIL;
		pPktHdr->pInboundShortcutEntry->notFinishUpdated=0;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		TRACE("[Update SC] dir:IN da=%d sa_intf=%d eipIdx=%d naptIdx=%d",pPktHdr->smacL2Idx,pPktHdr->srcNetifIdx,pPktHdr->srcNetifIdx,rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx);
		TRACE("isTcp:%d src:0x%x:%d dst:0x%x:%d",isTcp,pPktHdr->ipv4Dip,pPktHdr->dport,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,rg_db.naptOut[naptIdx].extPort);
		TABLE("Add SC: [sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d][isHairpin=%d]",pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,isTcp,pPktHdr->pCurrentShortcutEntry->isHairpinNat);
#else
		TRACE("[Update SC:%d] dir:IN da=%d sa_intf=%d eipIdx=%d naptIdx=%d",freeIdx,pPktHdr->smacL2Idx,pPktHdr->srcNetifIdx,pPktHdr->srcNetifIdx,rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx);
		TRACE("isTcp:%d src:0x%x:%d dst:0x%x:%d",isTcp,pPktHdr->ipv4Dip,pPktHdr->dport,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,rg_db.naptOut[naptIdx].extPort);
		TABLE("Add SC: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d][isHairpin=%d]",freeIdx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,isTcp,pPktHdr->pCurrentShortcutEntry->isHairpinNat);
#endif
	}
}

__SRAM_FWDENG_SLOWPATH
void _rtk_rg_localInNaptShortcutUpdate(rtk_rg_pktHdr_t *pPktHdr)
{
	int32 i, naptWanGroupIdx=FAIL;
	uint32 isTcp=(pPktHdr->tagif&TCP_TAGIF)?TRUE:FALSE;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	int32 localInIdx=0;
	uint32 localInHashIdx;
#endif

	//check local out napt/routing
	//1  must sync to _rtk_rg_gatewayServicePort_check() and _rtk_rg_gatewayPortRange_check()
	for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
	{
		if(i>=MAX_NETIF_SW_TABLE_SIZE)
			break;
		if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE)
			continue;

		if(memcmp(pPktHdr->pSmac, rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet, ETHER_ADDR_LEN)==0)
		{
#if 0	// no need, because port range that is used by kernel is always synchronized
			//if we does not sync port range that is used by kernel
			if(rg_kernel.lowerBoundPortUsedByPS==0 && rg_kernel.upperBoundPortUsedByPS==0)
			{
				naptWanGroupIdx = i;
			}
			else
			{
				if(rg_kernel.lowerBoundPortUsedByPS<=pPktHdr->sport && pPktHdr->sport<=rg_kernel.upperBoundPortUsedByPS)
				{
					naptWanGroupIdx = i;
				}
			}
#else
			if(!(rg_kernel.lowerBoundPortUsedByPS==0 && rg_kernel.upperBoundPortUsedByPS==0)
				&& (rg_kernel.lowerBoundPortUsedByPS<=pPktHdr->sport && pPktHdr->sport<=rg_kernel.upperBoundPortUsedByPS))
			{
				naptWanGroupIdx = i;
			}
#endif
			if(naptWanGroupIdx==FAIL)
			{
				for(i=0;i<MAX_GATEWAYSERVICEPORT_TABLE_SIZE;i++)
				{
					if(rg_db.gatewayServicePortEntry[i].valid==ENABLED)
					{
						if(rg_db.gatewayServicePortEntry[i].type==GATEWAY_SERVER_SERVICE)
						{
							if(pPktHdr->sport==rg_db.gatewayServicePortEntry[i].port_num)
							{
								naptWanGroupIdx = i;
								break;
							}
						}
					}
				}
			}

			if(naptWanGroupIdx!=FAIL)
				break;
		}
	}
	if(naptWanGroupIdx==FAIL) return; //not local out napt/routing

#if 0	// no need, because port range that is used by kernel is always synchronized
	//if we does not sync port range that is used by kernel
	if(rg_kernel.lowerBoundPortUsedByPS==0 && rg_kernel.upperBoundPortUsedByPS==0)
	{
		uint32 naptExtIp;

		//delete napt flows which use same extPort
		for(i=0; i<MAX_NAPT_OUT_SW_TABLE_SIZE; i++)
		{
			naptExtIp = rg_db.extip[rg_db.naptIn[rg_db.naptOut[i].rtk_naptOut.hashIdx].rtk_naptIn.extIpIdx].rtk_extip.extIpAddr;
			if(naptExtIp==pPktHdr->ipv4Sip && rg_db.naptOut[i].extPort==pPktHdr->sport)
				assert_ok((pf.rtk_rg_naptConnection_del)(i));
		}

		//set extPort to used state
		atomic_inc(&rg_db.naptProtcolStackEntryNumber[isTcp]);
		_rtk_rg_naptExtPortInUsedCheck(TRUE, isTcp, pPktHdr->sport, TRUE, FALSE);
	}
#endif
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	pPktHdr->pLocalInNaptShortcutEntry=&rg_db.localInNaptShortcut;
#else	//not CONFIG_RG_FLOW_BASED_PLATFORM
	localInHashIdx = _rtk_rg_shortcutHashIndex(pPktHdr->ipv4Dip,pPktHdr->ipv4Sip,pPktHdr->dport,pPktHdr->sport);
	localInIdx = _rtk_rg_v4ShortCutFreeEntryGet(localInHashIdx, pPktHdr->ipv4Dip, pPktHdr->ipv4Sip, pPktHdr->dport, pPktHdr->sport, isTcp);
	if(localInIdx==RG_RET_ENTRY_NOT_GET)
	{
		WARNING("Can not get free v4 shortcut entry!");
		return;
	}

	//pPktHdr->localInNaptShortcutIdx = localInIdx;
	pPktHdr->pLocalInNaptShortcutEntry = &rg_db.naptShortCut[localInIdx];
	rg_db.v4ShortCutValidSet[localInIdx>>5] |= (0x1<<(localInIdx&0x1f));
	rg_db.v4ShortCut_lastAddIdx[localInHashIdx>>MAX_NAPT_SHORTCUT_WAYS_SHIFT] = (localInIdx-localInHashIdx);
#endif
	memset(pPktHdr->pLocalInNaptShortcutEntry, 0, sizeof(rtk_rg_napt_shortcut_t));
	pPktHdr->pLocalInNaptShortcutEntry->idleSecs = 0;
	pPktHdr->pLocalInNaptShortcutEntry->isLocalInNapt=1;
	pPktHdr->pLocalInNaptShortcutEntry->sip=pPktHdr->ipv4Dip;
	pPktHdr->pLocalInNaptShortcutEntry->dip=pPktHdr->ipv4Sip;
	pPktHdr->pLocalInNaptShortcutEntry->sport=pPktHdr->dport;
	pPktHdr->pLocalInNaptShortcutEntry->dport=pPktHdr->sport;
	pPktHdr->pLocalInNaptShortcutEntry->isTcp=isTcp;
	pPktHdr->pLocalInNaptShortcutEntry->spa=RTK_RG_PORT_MAX;	//decided when inbound

	pPktHdr->pLocalInNaptShortcutEntry->new_lut_idx=pPktHdr->smacL2Idx; //DMAC
	pPktHdr->pLocalInNaptShortcutEntry->new_intf_idx=FAIL; //SMAC
	pPktHdr->pLocalInNaptShortcutEntry->new_eip_idx=FAIL; //for outbound sip

	pPktHdr->pLocalInNaptShortcutEntry->direction=0;
	pPktHdr->pLocalInNaptShortcutEntry->naptIdx=0;
	pPktHdr->pLocalInNaptShortcutEntry->isNapt=0;
	pPktHdr->pLocalInNaptShortcutEntry->isBridge=1;

	//20150115LUKE: keep ARP idx in shortcut for updating.
	pPktHdr->pLocalInNaptShortcutEntry->arpIdx=_rtk_rg_shortcutARPFind(_rtk_rg_l3lookup(pPktHdr->ipv4Dip), pPktHdr->ipv4Dip);
	pPktHdr->pLocalInNaptShortcutEntry->naptFilterRateLimitIdx = FAIL;	//for localin we can't decide limit index here, so just set to FAIL!!!
	pPktHdr->pLocalInNaptShortcutEntry->naptFilterPktCntIdx = FAIL;
	pPktHdr->pLocalInNaptShortcutEntry->naptFilterByteCnttIdx = FAIL;
	pPktHdr->pLocalInNaptShortcutEntry->naptFilterCopyCnt = 0;
#ifdef CONFIG_GPON_FEATURE
	pPktHdr->pLocalInNaptShortcutEntry->streamID=0;
#endif
	pPktHdr->pLocalInNaptShortcutEntry->vlanID=pPktHdr->internalVlanID;
	pPktHdr->pLocalInNaptShortcutEntry->vlanTagif=(pPktHdr->tagif&CVLAN_TAGIF)?1:0;
	pPktHdr->pLocalInNaptShortcutEntry->dmac2cvlanID=FAIL;
	pPktHdr->pLocalInNaptShortcutEntry->dmac2cvlanTagif=0;

	pPktHdr->pLocalInNaptShortcutEntry->internalVlanID = pPktHdr->ingressDecideVlanID; //learn at syn, we should give it a reasonable internalVlan(now ithe vlan comes from _rtk_rg_ingressVlanDecision())

	if(rg_db.vlan[pPktHdr->internalVlanID].priorityEn==1)
	{
		pPktHdr->pLocalInNaptShortcutEntry->priority=rg_db.vlan[pPktHdr->internalVlanID].priority&0x7;
	}
	else
		pPktHdr->pLocalInNaptShortcutEntry->priority=0;
	pPktHdr->pLocalInNaptShortcutEntry->internalCFPri=0;
	pPktHdr->pLocalInNaptShortcutEntry->dscp=FAIL;
	pPktHdr->pLocalInNaptShortcutEntry->notFinishUpdated=0;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	TRACE("Update SC[local in napt/routing]: [sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",pPktHdr->ipv4Dip,pPktHdr->ipv4Sip,pPktHdr->dport,pPktHdr->sport,isTcp);
	TABLE("Add SC[local in napt/routing]: [sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",pPktHdr->ipv4Dip,pPktHdr->ipv4Sip,pPktHdr->dport,pPktHdr->sport,isTcp);
#else
	TRACE("Update SC[local in napt/routing]: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",localInIdx,pPktHdr->ipv4Dip,pPktHdr->ipv4Sip,pPktHdr->dport,pPktHdr->sport,isTcp);
	TABLE("Add SC[local in napt/routing]: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",localInIdx,pPktHdr->ipv4Dip,pPktHdr->ipv4Sip,pPktHdr->dport,pPktHdr->sport,isTcp);
#endif
}

#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)	
__SRAM_FWDENG_SLOWPATH
void _rtk_rg_vxlanInNaptShortcutUpdate(rtk_rg_pktHdr_t *pPktHdr)
{
	int32 vxlanInIdx=0;
	//uint32 naptExtIp;
	uint32 isTcp=(pPktHdr->tagif&TCP_TAGIF)?TRUE:FALSE;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)	
	rtk_l34_netif_entry_t intfEntry;
#else
	uint32 vxlanInHashIdx;
#endif

	if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx>=0 &&
		rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx>=0){
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->pVxlanInNaptShortcutEntry=&rg_db.vxlanInNaptShortcut;
		//20200612LUKE: change the MTU of VXLAN wan to based WAN
		memcpy(&intfEntry, &rg_db.netif[pPktHdr->netifIdx].rtk_netif, sizeof(rtk_l34_netif_entry_t));
		intfEntry.mtu=rg_db.netif[pPktHdr->srcNetifIdx].rtk_netif.mtu;
		assert_ok(RTK_L34_NETIFTABLE_SET(pPktHdr->netifIdx, &intfEntry));
		//20200612LUKE: if the based WAN is pppoe WAN, remove the pppoe header before going to CPU for acceleration.
		assert_ok(_rtk_rg_netifPPPoESession_set(pPktHdr->netifIdx, FB_NETIFPPPOE_ACT_REMOVE, 0));
#else	//not CONFIG_RG_FLOW_BASED_PLATFORM
		vxlanInHashIdx = _rtk_rg_shortcutHashIndex(pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
		vxlanInIdx = _rtk_rg_v4ShortCutFreeEntryGet(vxlanInHashIdx, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->sport, pPktHdr->dport, isTcp);
		if(vxlanInIdx==RG_RET_ENTRY_NOT_GET)
		{
			WARNING("Can not get free v4 shortcut entry!");
			return;
		}

		pPktHdr->pVxlanInNaptShortcutEntry = &rg_db.naptShortCut[vxlanInIdx];
		rg_db.v4ShortCutValidSet[vxlanInIdx>>5] |= (0x1<<(vxlanInIdx&0x1f));
		rg_db.v4ShortCut_lastAddIdx[vxlanInHashIdx>>MAX_NAPT_SHORTCUT_WAYS_SHIFT] = (vxlanInIdx-vxlanInHashIdx);
#endif
		memset(pPktHdr->pVxlanInNaptShortcutEntry, 0, sizeof(rtk_rg_napt_shortcut_t));
		pPktHdr->pVxlanInNaptShortcutEntry->idleSecs = 0;
		pPktHdr->pVxlanInNaptShortcutEntry->isLocalInNapt=0;
		pPktHdr->pVxlanInNaptShortcutEntry->sip=pPktHdr->ipv4Sip;
		pPktHdr->pVxlanInNaptShortcutEntry->dip=pPktHdr->ipv4Dip;
		pPktHdr->pVxlanInNaptShortcutEntry->sport=pPktHdr->sport;
		pPktHdr->pVxlanInNaptShortcutEntry->dport=pPktHdr->dport;
		pPktHdr->pVxlanInNaptShortcutEntry->isTcp=isTcp;
		pPktHdr->pVxlanInNaptShortcutEntry->spa=pPktHdr->ingressPort;
		pPktHdr->pVxlanInNaptShortcutEntry->src_intf_idx=pPktHdr->srcNetifIdx;

		pPktHdr->pVxlanInNaptShortcutEntry->smacL2Idx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.vxlan_info.vxlan_remote_ipv4_gatewayMac_l2Idx; //SMAC
		pPktHdr->pVxlanInNaptShortcutEntry->new_lut_idx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx; //DMAC
		pPktHdr->pVxlanInNaptShortcutEntry->new_intf_idx=pPktHdr->netifIdx; //SMAC
		pPktHdr->pVxlanInNaptShortcutEntry->new_eip_idx=FAIL; //for outbound sip

		pPktHdr->pVxlanInNaptShortcutEntry->direction=0;
		pPktHdr->pVxlanInNaptShortcutEntry->naptIdx=0;
		pPktHdr->pVxlanInNaptShortcutEntry->isNapt=0;
		pPktHdr->pVxlanInNaptShortcutEntry->isBridge=0;
		
		//20150115LUKE: keep ARP idx in shortcut for updating.
		pPktHdr->pVxlanInNaptShortcutEntry->arpIdx=FAIL;
		pPktHdr->pVxlanInNaptShortcutEntry->naptFilterRateLimitIdx = FAIL;
		pPktHdr->pVxlanInNaptShortcutEntry->naptFilterPktCntIdx = FAIL;
		pPktHdr->pVxlanInNaptShortcutEntry->naptFilterByteCnttIdx = FAIL;
		pPktHdr->pVxlanInNaptShortcutEntry->naptFilterCopyCnt = 0;
#ifdef CONFIG_GPON_FEATURE		
		pPktHdr->pVxlanInNaptShortcutEntry->streamID=0;	//no needed for downstream
#endif
		pPktHdr->pVxlanInNaptShortcutEntry->vlanID=(pPktHdr->tagif&CVLAN_TAGIF)?pPktHdr->ctagVid:0;				//for flow hash
		pPktHdr->pVxlanInNaptShortcutEntry->vlanTagif=0;
		pPktHdr->pVxlanInNaptShortcutEntry->priority=(pPktHdr->tagif&CVLAN_TAGIF)?pPktHdr->ctagPri:0;			//for flow hash
		pPktHdr->pVxlanInNaptShortcutEntry->serviceVlanTagif=0;
		pPktHdr->pVxlanInNaptShortcutEntry->serviceVlanID=(pPktHdr->tagif&SVLAN_TAGIF)?pPktHdr->stagVid:0;		//for flow hash
		pPktHdr->pVxlanInNaptShortcutEntry->servicePriority=(pPktHdr->tagif&SVLAN_TAGIF)?pPktHdr->stagPri:0;	//for flow hash
		
		pPktHdr->pVxlanInNaptShortcutEntry->igr_cvlanTagif=(pPktHdr->tagif&CVLAN_TAGIF)?1:0;
		pPktHdr->pVxlanInNaptShortcutEntry->igr_svlanTagif=(pPktHdr->tagif&SVLAN_TAGIF)?1:0;
		pPktHdr->pVxlanInNaptShortcutEntry->igr_pppoeTagif=(pPktHdr->tagif&PPPOE_TAGIF)?1:0;
		
		pPktHdr->pVxlanInNaptShortcutEntry->dmac2cvlanID=FAIL;
		pPktHdr->pVxlanInNaptShortcutEntry->dmac2cvlanTagif=0;

		pPktHdr->pVxlanInNaptShortcutEntry->internalVlanID = pPktHdr->ingressDecideVlanID; //learn at syn, we should give it a reasonable internalVlan(now the vlan comes from _rtk_rg_ingressVlanDecision()) 

		pPktHdr->pVxlanInNaptShortcutEntry->internalCFPri=0;
		pPktHdr->pVxlanInNaptShortcutEntry->dscp=pPktHdr->tos>>2;												//for flow hash			
		pPktHdr->pVxlanInNaptShortcutEntry->notFinishUpdated=0;

		if(rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamInfo_prepared==0 && rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamInfo_prepared==0){
			rg_db_dynamic_sram.vxlan_acc.vxlan_downstream_txAddrOffset=RX_OFFSET+8+8+20+14;
		
			bzero(&rg_db_dynamic_sram.vxlan_acc.vxlan_downstream_txInfo,sizeof(rg_db_dynamic_sram.vxlan_acc.vxlan_downstream_txInfo));
			rg_db_dynamic_sram.vxlan_acc.vxlan_downstream_txInfo.opts2.bit.cputag=1;
			rg_db_dynamic_sram.vxlan_acc.vxlan_downstream_txInfo.opts3.bit.dislrn=1;
			
			rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamInfo_prepared=1;
			rg_db_dynamic_sram.vxlan_acc.vxlan_extra_downstreamInfo_prepared=1;
		}

		TRACE("Update SC[vxlan in]: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",vxlanInIdx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,isTcp);
		TABLE("Add SC[vxlan in]: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",vxlanInIdx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport,isTcp);
	}
}

__SRAM_FWDENG_SLOWPATH
void _rtk_rg_vxlanOutNaptShortcutUpdate(rtk_rg_pktHdr_t *pPktHdr)
{
	unsigned char gmac_num;
	int32 vxlanOutIdx=0;
	rtk_rg_vxlanClientInfo_t *pVXLANInfo;
	//uint32 naptExtIp;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)	
#else
	uint32 vxlanOutHashIdx;
#endif
	pVXLANInfo=&rg_db.systemGlobal.interfaceInfo[pPktHdr->dualHdrNetifIdx].storedInfo.wan_intf.vxlan_info;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	pPktHdr->pVxlanOutNaptShortcutEntry=&rg_db.vxlanOutNaptShortcut;
#else	//not CONFIG_RG_FLOW_BASED_PLATFORM
	vxlanOutHashIdx = _rtk_rg_shortcutHashIndex(pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
	vxlanOutIdx = _rtk_rg_v4ShortCutFreeEntryGet(vxlanOutHashIdx, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->sport, pPktHdr->dport, 0);
	if(vxlanOutIdx==RG_RET_ENTRY_NOT_GET)
	{
		WARNING("Can not get free v4 shortcut entry!");
		return;
	}

	pPktHdr->pVxlanOutNaptShortcutEntry = &rg_db.naptShortCut[vxlanOutIdx];
	rg_db.v4ShortCutValidSet[vxlanOutIdx>>5] |= (0x1<<(vxlanOutIdx&0x1f));
	rg_db.v4ShortCut_lastAddIdx[vxlanOutHashIdx>>MAX_NAPT_SHORTCUT_WAYS_SHIFT] = (vxlanOutIdx-vxlanOutHashIdx);
#endif
	memset(pPktHdr->pVxlanOutNaptShortcutEntry, 0, sizeof(rtk_rg_napt_shortcut_t));
	pPktHdr->pVxlanOutNaptShortcutEntry->idleSecs = 0;
	pPktHdr->pVxlanOutNaptShortcutEntry->isLocalInNapt=0;
	pPktHdr->pVxlanOutNaptShortcutEntry->sip=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->ip_addr;
	pPktHdr->pVxlanOutNaptShortcutEntry->dip=pVXLANInfo->after_dial.vxlan_remote_ipv4_addr;
	
	if((0x1<<pPktHdr->ingressPort)&rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_extraPmsk){
		pPktHdr->pVxlanOutNaptShortcutEntry->sport=RG_VXLAN_ACC_EPHEMERAL_SPORT;
		gmac_num=rg_db_dynamic_sram.vxlan_acc.vxlan_extraGmac;
	}else{
		pPktHdr->pVxlanOutNaptShortcutEntry->sport=pVXLANInfo->after_dial.outer_udp_sport;
		gmac_num=rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamGmac;
	}
	pPktHdr->pVxlanOutNaptShortcutEntry->dport=pVXLANInfo->after_dial.outer_udp_dport;
	pPktHdr->pVxlanOutNaptShortcutEntry->isTcp=0;
	if(rg_kernel.apolloChipId==RTL9607C_CHIP_ID){
		if(gmac_num==1)
			pPktHdr->pVxlanOutNaptShortcutEntry->spa = RTK_RG_MAC10_EXT_PORT3;
		else if(gmac_num==2)
			pPktHdr->pVxlanOutNaptShortcutEntry->spa = RTK_RG_MAC7_EXT_PORT3;
		else
			pPktHdr->pVxlanOutNaptShortcutEntry->spa = RTK_RG_EXT_PORT3;
	}else
		pPktHdr->pVxlanOutNaptShortcutEntry->spa = RTK_RG_EXT_PORT3;
	pPktHdr->pVxlanOutNaptShortcutEntry->src_intf_idx=pPktHdr->dualHdrNetifIdx;

	pPktHdr->pVxlanOutNaptShortcutEntry->smacL2Idx=rg_db.netif[pPktHdr->netifIdx].l2_idx;
	pPktHdr->pVxlanOutNaptShortcutEntry->new_lut_idx=pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx;
	pPktHdr->pVxlanOutNaptShortcutEntry->new_intf_idx=pPktHdr->netifIdx;	//for pppoe idx
	pPktHdr->pVxlanOutNaptShortcutEntry->new_eip_idx=FAIL; //for outbound sip

	pPktHdr->pVxlanOutNaptShortcutEntry->direction=0;
	pPktHdr->pVxlanOutNaptShortcutEntry->naptIdx=0;
	pPktHdr->pVxlanOutNaptShortcutEntry->isNapt=0;
	pPktHdr->pVxlanOutNaptShortcutEntry->isBridge=1;	//path3
	
	//20150115LUKE: keep ARP idx in shortcut for updating.
	pPktHdr->pVxlanOutNaptShortcutEntry->arpIdx=FAIL;
	pPktHdr->pVxlanOutNaptShortcutEntry->naptFilterRateLimitIdx = FAIL;
	pPktHdr->pVxlanOutNaptShortcutEntry->naptFilterPktCntIdx = FAIL;
	pPktHdr->pVxlanOutNaptShortcutEntry->naptFilterByteCnttIdx = FAIL;
	pPktHdr->pVxlanOutNaptShortcutEntry->naptFilterCopyCnt = 0;
	
	pPktHdr->pVxlanOutNaptShortcutEntry->igr_cvlanTagif=0;
	pPktHdr->pVxlanOutNaptShortcutEntry->igr_svlanTagif=0;
	pPktHdr->pVxlanOutNaptShortcutEntry->igr_pppoeTagif=0;
	
	pPktHdr->pVxlanOutNaptShortcutEntry->notFinishUpdated=0;

	TRACE("Update SC[vxlan out]: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",vxlanOutIdx,pPktHdr->pVxlanOutNaptShortcutEntry->sip,pPktHdr->pVxlanOutNaptShortcutEntry->dip,pPktHdr->pVxlanOutNaptShortcutEntry->sport,pPktHdr->pVxlanOutNaptShortcutEntry->dport,0);
	TABLE("Add SC[vxlan out]: [idx=%d][sip=0x%x][dip=0x%x][sport=%d][dport=%d][isTcp=%d]",vxlanOutIdx,pPktHdr->pVxlanOutNaptShortcutEntry->sip,pPktHdr->pVxlanOutNaptShortcutEntry->dip,pPktHdr->pVxlanOutNaptShortcutEntry->sport,pPktHdr->pVxlanOutNaptShortcutEntry->dport,0);
}

extern uint32 dynamic_sram_desc;
__SRAM_FWDENG_SLOWPATH
void _rtk_rg_nptv6HwlookupShortcutUpdate(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_naptv6_shortcut_t *pNptv6ShortcutEntry = &rg_db.nptv6HwlookupShortcut;

	memcpy(pNptv6ShortcutEntry, &rg_db.currentV6Shortcut, sizeof(rtk_rg_naptv6_shortcut_t));
	if(pPktHdr->isNPTv6==1)
	{
		memcpy(pNptv6ShortcutEntry->sip.ipv6_addr, pPktHdr->pIpv6Sip, IPV6_ADDR_LEN); //SIP
		if(dynamic_sram_desc==0)
			pNptv6ShortcutEntry->spa = rg_db_dynamic_sram.nptv6_acc.upstreamExtport;
		else
			pNptv6ShortcutEntry->spa = ((pPktHdr->ingressPort & 0x1)==0) ? rg_db_dynamic_sram.nptv6_acc.upstreamExtport : rg_db_dynamic_sram.nptv6_acc.upstream0Extport;
	}
	else if(pPktHdr->isNPTv6==2)
	{
		memcpy(pNptv6ShortcutEntry->dip.ipv6_addr, pPktHdr->pIpv6Dip, IPV6_ADDR_LEN); //DIP
		if(dynamic_sram_desc==0)
			pNptv6ShortcutEntry->spa = rg_db_dynamic_sram.nptv6_acc.downstreamExtport;
		else
			pNptv6ShortcutEntry->spa = ((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.port & 0x1)==0) ? rg_db_dynamic_sram.nptv6_acc.downstreamExtport : rg_db_dynamic_sram.nptv6_acc.downstream0Extport;
	}	
	pNptv6ShortcutEntry->smacL2Idx = rg_db.netif[pPktHdr->netifIdx].l2_idx;
	pNptv6ShortcutEntry->isBridge = 1;
#ifdef CONFIG_GPON_FEATURE		
	pNptv6ShortcutEntry->streamID = pPktHdr->streamID;
#endif
	pNptv6ShortcutEntry->vlanID = pPktHdr->egressVlanID;
	pNptv6ShortcutEntry->vlanTagif = pPktHdr->egressVlanTagif;
	pNptv6ShortcutEntry->serviceVlanID = pPktHdr->egressServiceVlanID;
	pNptv6ShortcutEntry->serviceVlanTagif = pPktHdr->egressServiceVlanTagif;
	pNptv6ShortcutEntry->dmac2cvlanID = FAIL;//pPktHdr->dmac2VlanID;
	pNptv6ShortcutEntry->dmac2cvlanTagif = 0;//pPktHdr->dmac2VlanTagif;
	pNptv6ShortcutEntry->priority = pPktHdr->egressPriority;
	pNptv6ShortcutEntry->servicePriority = pPktHdr->egressServicePriority;
}
#endif
#endif

#if defined(CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT)||defined(CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT)
rtk_rg_entryGetReturn_t _rtk_rg_shortcutNEIGHBORFind(unsigned char *ipv6Addr)
{
	int i,neighborIdx=RG_RET_ENTRY_NOT_GET,hashValue,l3Idx;

	l3Idx=_rtk_rg_v6L3lookup(ipv6Addr);
	if(l3Idx>=0 && rg_db.v6route[l3Idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL)
	{
		hashValue=_rtk_rg_IPv6NeighborHash(ipv6Addr+8,l3Idx);
		DEBUG("Neighbor hashValue=%d  l3Idx=%d interfaceId(%02x%02x:%02x%02x:%02x%02x:%02x%02x) ",hashValue,l3Idx,
			ipv6Addr[8],ipv6Addr[9],ipv6Addr[10],ipv6Addr[11],ipv6Addr[12],ipv6Addr[13],ipv6Addr[14],ipv6Addr[15]);
		neighborIdx=(hashValue<<MAX_IPV6_NEIGHBOR_HASH_WAY_SHIFT);
		for(i=0;i<MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE;i++)		//MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE-way hash
		{
			//find the same entry first.
			if((rg_db.v6neighbor[neighborIdx+i].neighborEntry.valid)&&
				(rg_db.v6neighbor[neighborIdx+i].neighborEntry.matchRouteIdx==l3Idx)&&
				_rtk_rg_ipv6IFIDCompare(rg_db.v6route[l3Idx].rtk_v6route.ipv6PrefixLen, ipv6Addr, rg_db.v6neighbor[neighborIdx+i].neighborEntry.interfaceId))
				break;
		}
		if(i==MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE)neighborIdx=RG_RET_ENTRY_NOT_GET;		//not found
	}

	return neighborIdx;
}
#endif

#ifdef CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
rtk_rg_entryGetReturn_t _rtk_rg_v6ShortCutFreeEntryGet(int hashIdx, uint8* v6Sip, uint8* v6Dip, uint16 sport, uint16 dport, uint8 isTcp)
{
	int i, first_invalid;
	uint32 longestIdx, longestIdletime;

	first_invalid = FAIL;
	longestIdx = hashIdx;
	longestIdletime = 0;
	for(i=hashIdx; i<hashIdx+MAX_NAPT_V6_SHORTCUT_WAYS; i++)
	{
		if(!RG_V6SC_VALID(i)) //invalid
		{
			if(first_invalid==FAIL)
				first_invalid = i;
			continue;
		}
		if((!memcmp(rg_db.naptv6ShortCut[i].sip.ipv6_addr, v6Sip, IPV6_ADDR_LEN)) &&
			(!memcmp(rg_db.naptv6ShortCut[i].dip.ipv6_addr, v6Dip, IPV6_ADDR_LEN)) &&
			(rg_db.naptv6ShortCut[i].sport==sport) &&
			(rg_db.naptv6ShortCut[i].dport==dport) &&
			(rg_db.naptv6ShortCut[i].isTcp==isTcp))
			return i;

		if(rg_db.naptv6ShortCut[i].idleSecs > longestIdletime)
		{
			longestIdx = i;
			longestIdletime = rg_db.naptv6ShortCut[i].idleSecs;
		}
	}

	if(first_invalid!=FAIL)
		return first_invalid;

	if(longestIdletime==0) //choose last add index+1
	{
		DEBUG("V6shortcut LRU, do round robin!");
		longestIdx += ((rg_db.v6ShortCut_lastAddIdx[hashIdx>>MAX_NAPT_V6_SHORTCUT_WAYS_SHIFT]+1) & (MAX_NAPT_V6_SHORTCUT_WAYS-1));
		longestIdletime = rg_db.naptv6ShortCut[longestIdx].idleSecs;
	}

	DEBUG("V6shortcut LRU choose victim[%d], idletime: %d secs", longestIdx, longestIdletime);
	_rtk_rg_v6ShortCut_delete(longestIdx);

	if(rg_db.systemGlobal.fwdStatistic)
		rg_db.systemGlobal.statistic.perPortCnt_v6ShortcutLRU[rg_db.pktHdr->ingressPort]++;

	return longestIdx;

}
#endif

__SRAM_FWDENG_SLOWPATH
void _rtk_rg_naptV6ShortcutUpdate(rtk_rg_pktHdr_t *pPktHdr, int isBridge)
{
	int isTcp=0;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	int freeIdx=0;
	int shortcutIdx=0;
#endif

	if(pPktHdr->aclHit) return;

	if(pPktHdr->tagif&TCP_TAGIF)
		isTcp=1;

	//20170816LUKE: didn't enable overMTU forwarded by shortcut here since we won't frag IPv6 overMTU packet.
	if(pPktHdr->overMTU==1)
	{
		TRACE("over MTU...don't update shortCut!");
		return;
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	pPktHdr->pCurrentV6ShortcutEntry=&rg_db.currentV6Shortcut;
#else
	//20140813LUKE: use hash to get index!!
	shortcutIdx=_rtk_rg_ipv6ShortcutHashIndex(*((unsigned int *)(pPktHdr->pIpv6Sip+12)),*((unsigned int *)(pPktHdr->pIpv6Dip+12)),pPktHdr->sport,pPktHdr->dport);
	freeIdx = _rtk_rg_v6ShortCutFreeEntryGet(shortcutIdx, pPktHdr->pIpv6Sip, pPktHdr->pIpv6Dip, pPktHdr->sport, pPktHdr->dport, isTcp);
	if(freeIdx==RG_RET_ENTRY_NOT_GET)
	{
		WARNING("Can not get free v6 shortcut entry!");
		return;
	}

	pPktHdr->currentV6ShortcutIdx=freeIdx;
	pPktHdr->pCurrentV6ShortcutEntry=&rg_db.naptv6ShortCut[freeIdx];
	rg_db.v6ShortCutValidSet[freeIdx>>5] |= (0x1<<(freeIdx&0x1f));
	rg_db.v6ShortCut_lastAddIdx[shortcutIdx>>MAX_NAPT_V6_SHORTCUT_WAYS_SHIFT] = (freeIdx-shortcutIdx);
#endif
	memset(pPktHdr->pCurrentV6ShortcutEntry, 0, sizeof(rtk_rg_naptv6_shortcut_t));
	pPktHdr->pCurrentV6ShortcutEntry->idleSecs= 0;
	pPktHdr->pCurrentV6ShortcutEntry->notFinishUpdated=1;
	pPktHdr->shortcutStatus=RG_SC_V6_NEED_UPDATE_BEFORE_SEND;
	memcpy(pPktHdr->pCurrentV6ShortcutEntry->sip.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN); //SIP
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)	
	if(pPktHdr->isNPTv6==2) //inbound
		memcpy(pPktHdr->pCurrentV6ShortcutEntry->dip.ipv6_addr,pPktHdr->ipv6Dip_addr.ipv6_addr,IPV6_ADDR_LEN); //DIP
	else
#endif		
		memcpy(pPktHdr->pCurrentV6ShortcutEntry->dip.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN); //DIP
	pPktHdr->pCurrentV6ShortcutEntry->sport=pPktHdr->sport; //SPORT
	pPktHdr->pCurrentV6ShortcutEntry->dport=pPktHdr->dport; //DPORT

#if defined(SHORTCUT_BITFILED_DEBUG)
	assert(pPktHdr->ingressPort >= 0 && pPktHdr->ingressPort < (1 << (BFW_SPA)));
	assert(isTcp >= 0 && isTcp < (1 << (BFW_ISTCP)));
	assert(isBridge >=0 && isBridge < (1 << (BFW_ISBRIDGE)));
	assert(pPktHdr->dmacL2Idx < (1 << (BFW_LUTIDX-1)));
	assert(pPktHdr->netifIdx < (1 << (BFW_INTFIDX-1)));
	assert(_rtk_rg_shortcutNEIGHBORFind(pPktHdr->pIpv6Sip) < (1 << (BFW_NEIGHBORIDX-1)));
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	assert(pPktHdr->smacL2Idx < (1 << (BFW_SMACL2IDX-1)));
#endif

#endif

	pPktHdr->pCurrentV6ShortcutEntry->spa=pPktHdr->ingressPort;
	pPktHdr->pCurrentV6ShortcutEntry->srcWlanDevIdx=pPktHdr->wlan_dev_idx;
	pPktHdr->pCurrentV6ShortcutEntry->isTcp=isTcp;
	pPktHdr->pCurrentV6ShortcutEntry->isBridge=isBridge;
	pPktHdr->pCurrentV6ShortcutEntry->new_lut_idx=pPktHdr->dmacL2Idx; //DMAC
	pPktHdr->pCurrentV6ShortcutEntry->new_intf_idx=pPktHdr->netifIdx; //SMAC
	//20150115LUKE: keep Neighbor idx in shortcut for updating.
	pPktHdr->pCurrentV6ShortcutEntry->neighborIdx=_rtk_rg_shortcutNEIGHBORFind(pPktHdr->pIpv6Sip);
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	pPktHdr->pCurrentV6ShortcutEntry->smacL2Idx = pPktHdr->smacL2Idx;
#endif

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	TRACE("[Update V6SC] da=%d sa_intf=%d\n",pPktHdr->dmacL2Idx,pPktHdr->netifIdx);
#else
	TRACE("[Update V6SC:%d] da=%d sa_intf=%d\n",freeIdx,pPktHdr->dmacL2Idx,pPktHdr->netifIdx);
#endif
	TRACE("isTcp:%d src:%08x:%08x:%08x:%08x:%d dst:%08x:%08x:%08x:%08x:%d",isTcp,
		*((unsigned int *)pPktHdr->pIpv6Sip),
		*((unsigned int *)(pPktHdr->pIpv6Sip+4)),
		*((unsigned int *)(pPktHdr->pIpv6Sip+8)),
		*((unsigned int *)(pPktHdr->pIpv6Sip+12)),
		pPktHdr->sport,
		*((unsigned int *)pPktHdr->pIpv6Dip),
		*((unsigned int *)(pPktHdr->pIpv6Dip+4)),
		*((unsigned int *)(pPktHdr->pIpv6Dip+8)),
		*((unsigned int *)(pPktHdr->pIpv6Dip+12)),
		pPktHdr->dport);
}
#endif

rtk_rg_successFailReturn_t _rtk_rg_getNaptOutFreeList(rtk_rg_table_naptOut_linkList_t	**pNaptOutFreeList)
{
	if(rg_db.pNaptOutFreeListHead==NULL) return RG_RET_FAIL;
	*pNaptOutFreeList=rg_db.pNaptOutFreeListHead;
	rg_db.pNaptOutFreeListHead=rg_db.pNaptOutFreeListHead->pNext;
	(*pNaptOutFreeList)->pNext=NULL;
	//DEBUG("FreeList=%d(%p)\n",(*pNaptOutFreeList)->idx,*pNaptOutFreeList);
	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_getNaptInFreeList(rtk_rg_table_naptIn_linkList_t	**pNaptInFreeList)
{
	if(rg_db.pNaptInFreeListHead==NULL) return RG_RET_FAIL;
	*pNaptInFreeList=rg_db.pNaptInFreeListHead;
	rg_db.pNaptInFreeListHead=rg_db.pNaptInFreeListHead->pNext;
	(*pNaptInFreeList)->pNext=NULL;
//	DEBUG("FreeList=%d(%x)\n",(*pNaptInFreeList)->idx,*pNaptInFreeList);
	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_addNaptOutHashList(int naptHashOutIdx,int *pNaptOutIdx)
{
	rtk_rg_table_naptOut_linkList_t *pNaptFreeOutList;
	ptrdiff_t naptFreeOutListIdx;
	if(_rtk_rg_getNaptOutFreeList(&pNaptFreeOutList)==RG_RET_FAIL) return RG_RET_FAIL;

	rg_lock(&rg_kernel.naptTableLock);
	//========================critical region start=========================
	if(rg_db.pNaptOutHashListHead[naptHashOutIdx]==NULL)
	{
		rg_db.pNaptOutHashListHead[naptHashOutIdx]=pNaptFreeOutList;
	}
	else
	{
		pNaptFreeOutList->pNext=rg_db.pNaptOutHashListHead[naptHashOutIdx];
		rg_db.pNaptOutHashListHead[naptHashOutIdx]=pNaptFreeOutList;
	}
	naptFreeOutListIdx = _rtk_rg_list_entry_idx(pNaptFreeOutList, &(rg_db.naptOutFreeList[0])) + MAX_NAPT_OUT_HW_TABLE_SIZE;//use address-based method to get naptOutFreeList entry index. (naptOutFreeList[i] mapping to naptOut[i+MAX_NAPT_OUT_HW_TABLE_SIZE])
	*pNaptOutIdx=naptFreeOutListIdx;
#if defined(NAPT_TABLE_SIZE_DEBUG)
    assert(naptHashOutIdx < MAX_NAPT_OUT_HASH_SIZE);
#endif
	rg_db.naptOut[*pNaptOutIdx].hashOutIdx=naptHashOutIdx;


	rg_unlock(&rg_kernel.naptTableLock);
	//========================critical region end=========================


	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_addNaptInHashList(int naptHashInIdx,int *pNaptInIdx)
{
	rtk_rg_table_naptIn_linkList_t *pNaptFreeInList;
	ptrdiff_t naptFreeInListIdx;
	if(_rtk_rg_getNaptInFreeList(&pNaptFreeInList)==RG_RET_FAIL) return RG_RET_FAIL;

	rg_lock(&rg_kernel.naptTableLock);
	//========================critical region start=========================

	if(rg_db.pNaptInHashListHead[naptHashInIdx]==NULL)
	{
		rg_db.pNaptInHashListHead[naptHashInIdx]=pNaptFreeInList;
	}
	else
	{
		pNaptFreeInList->pNext=rg_db.pNaptInHashListHead[naptHashInIdx];
		rg_db.pNaptInHashListHead[naptHashInIdx]=pNaptFreeInList;
	}
	naptFreeInListIdx = _rtk_rg_list_entry_idx(pNaptFreeInList, &(rg_db.naptInFreeList[0])) + MAX_NAPT_IN_HW_TABLE_SIZE;//use address-based method to get naptInFreeList entry index. (naptInFreeList[i] mapping to naptin[i+MAX_NAPT_IN_HW_TABLE_SIZE])
	*pNaptInIdx=naptFreeInListIdx;
#if defined(NAPT_TABLE_SIZE_DEBUG)
    assert(naptHashInIdx < (1 << MAX_NAPT_IN_SW_ENTRY_WIDTH));
#endif
	rg_db.naptIn[*pNaptInIdx].hashIdx=naptHashInIdx;
	rg_unlock(&rg_kernel.naptTableLock);
	//========================critical region end=========================
	return RG_RET_SUCCESS;
}

void _rtk_rg_freeFragOutList(rtk_rg_ipv4_fragment_out_t *pReleaseOutList)
{
	list_move_tail(&(pReleaseOutList->fragout_list), &rg_db.fragOutFreeListHead);
	//DEBUG("###### free out list..%p",pReleaseOutList);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(pReleaseOutList->flowHitIdx>=0)
		_rtk_rg_flow_fragmentUsedBit_reset_by_flowIndex(pReleaseOutList->flowHitIdx);
#endif
}

void _rtk_rg_freeFragInList(rtk_rg_ipv4_fragment_in_t *pReleaseInList)
{
	list_move_tail(&(pReleaseInList->fragin_list), &rg_db.fragInFreeListHead);
	//DEBUG("###### free in list..%p",pReleaseInList);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(pReleaseInList->flowHitIdx>=0)
		_rtk_rg_flow_fragmentUsedBit_reset_by_flowIndex(pReleaseInList->flowHitIdx);
#endif
}

void _rtk_rg_freeAllFragOutList(void)
{
	int i;
#if 1
	//init fragment Out free link list
	INIT_LIST_HEAD(&rg_db.fragOutFreeListHead);

	//20180905LUKE: free all queued_skb before reset the outbound list
	for(i=0;i<MAX_IPV4_FRAGMENT_QUEUE_SIZE;i++)
	{
		if(rg_db.ipv4FragmentQueue[i].occupied && rg_db.ipv4FragmentQueue[i].direction==NAPT_DIRECTION_OUTBOUND)
		{	
			rtk_rg_pktHdr_t *orig_pktHdr=rg_db.pktHdr;
			
			rg_db.pktHdr = &rg_db.systemGlobal.pktHeader_2;
			rg_db.pktHdr->ingressPort = rg_db.ipv4FragmentQueue[i].queue_pktInfo.ingressPort;
			if(rg_db.ipv4FragmentQueue[i].queue_skb)
				_rtk_rg_dev_kfree_skb_any(rg_db.ipv4FragmentQueue[i].queue_skb);
			rg_db.systemGlobal.ipv4FragmentQueueNum--;
			if(rg_db.systemGlobal.fwdStatistic)rg_db.systemGlobal.statistic.perPortCnt_v4FragQueued[rg_db.pktHdr->ingressPort]--;
			rg_db.ipv4FragmentQueue[i].occupied = 0;
			rg_db.ipv4FragmentQueue[i].queue_time = 0;
			rg_db.pktHdr=orig_pktHdr;	//point back to original pkthdr		
		}
	}

	for(i=0;i<MAX_FRAG_OUT_FREE_TABLE_SIZE;i++)
	{
		bzero(&rg_db.fragOutFreeList[i],sizeof(rtk_rg_ipv4_fragment_out_t));
		INIT_LIST_HEAD(&rg_db.fragOutFreeList[i].fragout_list);
		//add free list to free list head
		list_add_tail(&rg_db.fragOutFreeList[i].fragout_list, &rg_db.fragOutFreeListHead);
	}

	//init fragment out hash index link list
	for(i=0;i<IPV4_FRAGMENT_OUT_HASH_MASK_SHIFT;i++)
		INIT_LIST_HEAD(&rg_db.fragOutHashListHead[i]);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_flow_fragmentUsedBit_clear();
	_rtk_rg_L2L3_flow_fragmentUsedBit_reset();
	_rtk_rg_L4_flow_fragmentInUsedBit_reset();
#endif

#else
	rtk_rg_ipv4_fragment_out_t *pCur, *pNext;

	for(i=0;i<IPV4_FRAGMENT_OUT_HASH_MASK_SHIFT;i++)
	{
		if(!list_empty(&rg_db.fragOutHashListHead[i]))
		{
			list_for_each_entry_safe(pCur, pNext, &rg_db.fragOutHashListHead[i], fragout_list)
			{
				_rtk_rg_freeFragOutList(pCur);
			}
		}
	}
#endif
}

void _rtk_rg_freeAllFragInList(void)
{
	int i;
#if 1
	//init fragment In free link list
	INIT_LIST_HEAD(&rg_db.fragInFreeListHead);

	//20180905LUKE: free all queued_skb before reset the inbound list
	for(i=0;i<MAX_IPV4_FRAGMENT_QUEUE_SIZE;i++)
	{
		if(rg_db.ipv4FragmentQueue[i].occupied && rg_db.ipv4FragmentQueue[i].direction==NAPT_DIRECTION_INBOUND)
		{
			rtk_rg_pktHdr_t *orig_pktHdr=rg_db.pktHdr;

			rg_db.pktHdr = &rg_db.systemGlobal.pktHeader_2;
			rg_db.pktHdr->ingressPort = rg_db.ipv4FragmentQueue[i].queue_pktInfo.ingressPort;
			if(rg_db.ipv4FragmentQueue[i].queue_skb)
				_rtk_rg_dev_kfree_skb_any(rg_db.ipv4FragmentQueue[i].queue_skb);
			rg_db.systemGlobal.ipv4FragmentQueueNum--;
			if(rg_db.systemGlobal.fwdStatistic)rg_db.systemGlobal.statistic.perPortCnt_v4FragQueued[rg_db.pktHdr->ingressPort]--;
			rg_db.ipv4FragmentQueue[i].occupied = 0;
			rg_db.ipv4FragmentQueue[i].queue_time = 0;
			rg_db.pktHdr=orig_pktHdr;	//point back to original pkthdr
		}
	}

	for(i=0;i<MAX_FRAG_IN_FREE_TABLE_SIZE;i++)
	{
		bzero(&rg_db.fragInFreeList[i],sizeof(rtk_rg_ipv4_fragment_in_t));
		INIT_LIST_HEAD(&rg_db.fragInFreeList[i].fragin_list);
		//add free list to free list head
		list_add_tail(&rg_db.fragInFreeList[i].fragin_list, &rg_db.fragInFreeListHead);
	}

	//init fragment In hash index link list
	for(i=0;i<IPV4_FRAGMENT_IN_HASH_MASK_SHIFT;i++)
		INIT_LIST_HEAD(&rg_db.fragInHashListHead[i]);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_flow_fragmentUsedBit_clear();
	_rtk_rg_L2L3_flow_fragmentUsedBit_reset();
	_rtk_rg_L4_flow_fragmentOutUsedBit_reset();
#endif

#else
	rtk_rg_ipv4_fragment_in_t *pCur, *pNext;

	for(i=0;i<IPV4_FRAGMENT_IN_HASH_MASK_SHIFT;i++)
	{
		if(!list_empty(&rg_db.fragInHashListHead[i]))
		{
			list_for_each_entry_safe(pCur, pNext, &rg_db.fragInHashListHead[i], fragin_list)
			{
				_rtk_rg_freeFragInList(pCur);
			}
		}
	}
#endif
}

void _rtk_rg_getFragOutFreeList(rtk_rg_ipv4_fragment_out_t **pFragOutFreeList)
{
	if(list_empty(&rg_db.fragOutFreeListHead))
	{
		//Clear all hashHead
		//mibdump_frag();
		DEBUG("============================== start clear OUT ======================");
		_rtk_rg_freeAllFragOutList();
		//mibdump_frag();
	}
	*pFragOutFreeList=list_first_entry(&rg_db.fragOutFreeListHead, rtk_rg_ipv4_fragment_out_t, fragout_list);
	list_del_init(&(*pFragOutFreeList)->fragout_list);
	//DEBUG("get Free out List=%p\n",*pFragOutFreeList);
}

void _rtk_rg_getFragInFreeList(rtk_rg_ipv4_fragment_in_t **pFragInFreeList)
{
	if(list_empty(&rg_db.fragInFreeListHead))
	{
		//Clear all hashHead
		//mibdump_frag();
		DEBUG("============================== start clear IN ======================");
		_rtk_rg_freeAllFragInList();
		//mibdump_frag();
	}
	*pFragInFreeList=list_first_entry(&rg_db.fragInFreeListHead, rtk_rg_ipv4_fragment_in_t, fragin_list);
	list_del_init(&(*pFragInFreeList)->fragin_list);
	//DEBUG("get Free in List=%p\n",*pFragInFreeList);
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_entryGetReturn_t _rtk_rg_swNaptOutFreeEntryGet(int naptHashOutIdx)
{
	int naptOutIdx=FAIL;

	//found a free naptOut from link list
	if(_rtk_rg_addNaptOutHashList(naptHashOutIdx,&naptOutIdx)==RG_RET_SUCCESS)
	{
		TRACE("free SW NaptOutIdx=%d",naptOutIdx);
		return naptOutIdx;
	}
	else
	{
#ifdef CONFIG_ROME_NAPT_LRU
		uint32 i, hashIdx, longestIdleSec;
		int firstValidIdx=FAIL, longestIdleIdx, ret;
		rtk_rg_table_naptOut_linkList_t *pNaptOutList,*pPreNaptOutList;
		ptrdiff_t naptOutListIdx;

		for(i=0; i<MAX_NAPT_OUT_HASH_SIZE; i++)
		{
			hashIdx = (naptHashOutIdx+i)%MAX_NAPT_OUT_HASH_SIZE;
			if(rg_db.pNaptOutHashListHead[hashIdx] != NULL)
			{
				longestIdleIdx = FAIL;
				longestIdleSec = 0;
				pPreNaptOutList = rg_db.pNaptOutHashListHead[hashIdx];
				pNaptOutList = pPreNaptOutList;
				while(pNaptOutList!=NULL)
				{
					naptOutListIdx = _rtk_rg_list_entry_idx(pNaptOutList, &(rg_db.naptOutFreeList[0])) + MAX_NAPT_OUT_HW_TABLE_SIZE; //use address-based method to get naptOutFreeList entry index. (naptOutFreeList[i] mapping to naptOut[i+MAX_NAPT_OUT_HW_TABLE_SIZE])
					if(firstValidIdx==FAIL)
						firstValidIdx = naptOutListIdx;
					if(rg_db.naptOut[naptOutListIdx].idleSecs > longestIdleSec)
					{
						longestIdleIdx = naptOutListIdx;
						longestIdleSec = rg_db.naptOut[naptOutListIdx].idleSecs;

					}
					pPreNaptOutList=pNaptOutList;
					pNaptOutList=pNaptOutList->pNext;
				}
				if(longestIdleIdx!=FAIL)
				{
					ret = (pf.rtk_rg_naptConnection_del)(longestIdleIdx);
					if(ret!=RT_ERR_RG_OK)
						WARNING("rtk_rg_naptConnection_del(longestIdleIdx:%d)=[ret:%x]", longestIdleIdx, ret);
					else
					{
						ret = _rtk_rg_addNaptOutHashList(naptHashOutIdx, &naptOutIdx);
						if(ret!=RG_RET_SUCCESS)
							WARNING("_rtk_rg_addNaptOutHashList=[ret:%x]", ret);
						else
						{
							TABLE("[NAPT] Outbound full, delete the longest idle connection[%d]. IdleTime=%d secs", longestIdleIdx, longestIdleSec);
							break;
						}
					}
				}
			}
		}
		if(naptOutIdx==FAIL)
		{
			if(firstValidIdx!=FAIL && ((pf.rtk_rg_naptConnection_del)(firstValidIdx))==RT_ERR_RG_OK && _rtk_rg_addNaptOutHashList(naptHashOutIdx, &naptOutIdx)==RG_RET_SUCCESS)
			{
				TABLE("[NAPT] Outbound full, delete the first valid connection[%d]", firstValidIdx);
			}
			else
			{
				TABLE_FULL("can't find any free NAPT entry to delete!");
				return RG_RET_ENTRY_NOT_GET;
			}
		}
		if(rg_db.systemGlobal.fwdStatistic)
			rg_db.systemGlobal.statistic.perPortCnt_naptOutLRU[rg_db.pktHdr->ingressPort]++;

		return naptOutIdx;
#else
		return RG_RET_ENTRY_NOT_GET;
#endif
	}
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_entryGetReturn_t _rtk_rg_swNaptInFreeEntryGet(int naptHashInIdx)
{
	int naptInIdx=FAIL;

	//found a free naptIn from link list
	if(_rtk_rg_addNaptInHashList(naptHashInIdx,&naptInIdx)==RG_RET_SUCCESS)
	{
		TRACE("free SW NaptInIdx=%d",naptInIdx);
		return naptInIdx;
	}
	else
	{
#ifdef CONFIG_ROME_NAPT_LRU
		uint32 i, hashIdx, longestIdleSec;
		int firstValidIdx=FAIL, longestIdleIdx, ret;
		rtk_rg_table_naptIn_linkList_t *pNaptInList,*pPreNaptInList;
		ptrdiff_t naptInListIdx;

		for(i=0; i<MAX_NAPT_IN_HASH_SIZE; i++)
		{
			hashIdx = (naptHashInIdx+i)%MAX_NAPT_IN_HASH_SIZE;
			if(rg_db.pNaptInHashListHead[hashIdx] != NULL)
			{
				longestIdleIdx = FAIL;
				longestIdleSec = 0;
				pPreNaptInList = rg_db.pNaptInHashListHead[hashIdx];
				pNaptInList = pPreNaptInList;
				while(pNaptInList!=NULL)
				{
					naptInListIdx = _rtk_rg_list_entry_idx(pNaptInList, &(rg_db.naptInFreeList[0])) + MAX_NAPT_IN_HW_TABLE_SIZE; //use address-based method to get naptInFreeList entry index. (naptInFreeList[i] mapping to naptin[i+MAX_NAPT_IN_HW_TABLE_SIZE])
					if(rg_db.naptIn[naptInListIdx].coneType==NAPT_IN_TYPE_SYMMETRIC_NAPT)
					{
						if(firstValidIdx==FAIL)
							firstValidIdx = naptInListIdx;
						if(rg_db.naptIn[naptInListIdx].idleSecs > longestIdleSec)
						{
							longestIdleIdx = naptInListIdx;
							longestIdleSec = rg_db.naptIn[naptInListIdx].idleSecs;

						}
					}
					pPreNaptInList=pNaptInList;
					pNaptInList=pNaptInList->pNext;
				}
				if(longestIdleIdx!=FAIL)
				{
					ret = (pf.rtk_rg_naptConnection_del)(rg_db.naptIn[longestIdleIdx].symmetricNaptOutIdx);
					if(ret!=RT_ERR_RG_OK)
						WARNING("rtk_rg_naptConnection_del(longestIdleIdx:%d)=[ret:%x]", rg_db.naptIn[longestIdleIdx].symmetricNaptOutIdx, ret);
					else
					{
						ret = _rtk_rg_addNaptInHashList(naptHashInIdx, &naptInIdx);
						if(ret!=RG_RET_SUCCESS)
							WARNING("_rtk_rg_addNaptInHashList=[ret:%x]", ret);
						else
						{
							TABLE("[NAPT] Inbound full, delete the longest idle connection[%d]. IdleTime=%d secs", longestIdleIdx, longestIdleSec);
							break;
						}
					}
				}
			}
		}
		if(naptInIdx==FAIL)
		{
			if(firstValidIdx!=FAIL && ((pf.rtk_rg_naptConnection_del)(rg_db.naptIn[firstValidIdx].symmetricNaptOutIdx))==RT_ERR_RG_OK && _rtk_rg_addNaptInHashList(naptHashInIdx, &naptInIdx)==RG_RET_SUCCESS)
			{
				TABLE("[NAPT] Inbound full, delete the first valid connection[%d]", firstValidIdx);
			}
			else
			{
				TABLE_FULL("can't find any free NAPT entry to delete!");
				return RG_RET_ENTRY_NOT_GET;
			}
		}
		if(rg_db.systemGlobal.fwdStatistic)
			rg_db.systemGlobal.statistic.perPortCnt_naptInLRU[rg_db.pktHdr->ingressPort]++;

		return naptInIdx;
#else
		return RG_RET_ENTRY_NOT_GET;
#endif
	}
}


/*naptOutIdx 4-way search hardware invalid or canBeReplaced entry  if find return index else return RG_RET_ENTRY_NOT_GET*/
__SRAM_FWDENG_SLOWPATH
rtk_rg_entryGetReturn_t _rtk_rg_naptTcpUdpOutFreeEntryGetHardware(int32 naptOutIdx)
{

	int i;
	for(i=naptOutIdx;i<naptOutIdx+4;i++)
	{
		if(rg_db.naptOut[i].rtk_naptOut.valid==0)
		{
			return i;
		}
	}

	if(rg_db.systemGlobal.tcpDoNotDelWhenRstFin==1)
	{
		for(i=naptOutIdx;i<naptOutIdx+4;i++)
		{
			if(rg_db.naptOut[i].canBeReplaced==1)
			{
				return i;
			}
		}
	}
	return RG_RET_ENTRY_NOT_GET;

}



__SRAM_FWDENG_SLOWPATH
rtk_rg_entryGetReturn_t _rtk_rg_naptTcpUdpOutFreeEntryGet(int addNaptSwOnly, rtk_rg_algAction_t algAction, int8 isTcp, ipaddr_t srcAddr, uint16 srcPort, ipaddr_t destAddr, uint16 destPort,int *pHashOutIdx)
{
	int naptHashOutIdx;
	int naptOutIdx;

	//found a free naptOut entry
	naptHashOutIdx=_rtk_rg_naptTcpUdpOutHashIndex(isTcp,srcAddr,srcPort,destAddr,destPort);
	if(pHashOutIdx!=NULL) *pHashOutIdx=naptHashOutIdx;
	naptOutIdx=naptHashOutIdx<<2;

	//Check for ALG
	if(algAction==RG_ALG_ACT_TO_FWDENGINE || addNaptSwOnly)
	{
		//DEBUG("Add to pure software..naptHashOutIdx=%d %p",naptHashOutIdx,rg_db.pNaptOutFreeListHead);
		goto PURESW;
	}

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)	 //flow-based platform only support sw napt
	naptOutIdx = _rtk_rg_naptTcpUdpOutFreeEntryGetHardware(naptOutIdx);
	if(naptOutIdx !=RG_RET_ENTRY_NOT_GET )
	{	//find a free hardware entry return!
		return naptOutIdx;
	}
#endif

PURESW:
	//FIXME("NAPT 4-ways is full - found link list");
	return _rtk_rg_swNaptOutFreeEntryGet(naptHashOutIdx);

}


/* naptInIdx (4-way/1-way) search hardware Reuse_Full-Cone/invalid/canBeReplaced entry  if find return index else return RG_RET_ENTRY_NOT_GET*/
__SRAM_FWDENG_SLOWPATH
rtk_rg_entryGetReturn_t _rtk_rg_naptTcpUdpInFreeEntryGetHardware(int naptInIdx,int isTcp,int extIp,int extPort)
{
	int inBoundHashWay=4;
	int i;

	/* Search the same inbound full cone entry first in 4-way, reuse this entry if found */
#ifdef CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT

	if((rg_db.pktHdr->naptrLookupHit==2)&&(rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack==_rtk_rg_fwdEngine_virtualServerCheck))
	{
		for(i=naptInIdx;i<naptInIdx+inBoundHashWay;i++)
		{
			if((rg_db.naptIn[i].rtk_naptIn.valid==ASIC_NAPT_IN_TYPE_FULL_CONE)&&
				(rg_db.extip[rg_db.naptIn[i].rtk_naptIn.extIpIdx].rtk_extip.extIpAddr==extIp)&&
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				((rg_db.naptIn[i].rtk_naptIn.extPortHSB<<8 | rg_db.naptIn[i].rtk_naptIn.extPortLSB)==extPort)&&
#else
				((rg_db.naptIn[i].rtk_naptIn.extPortLSB&0xff)==(extPort&0xff))&&
#endif
				(rg_db.naptIn[i].rtk_naptIn.isTcp==isTcp))
			{

				TRACE("Reuse Full-Cone inbound NAPT index[%d]",i);
				return i;
			}
		}
	}
#endif

	for(i=naptInIdx;i<naptInIdx+inBoundHashWay;i++)
	{
		if(rg_db.naptIn[i].rtk_naptIn.valid==ASIC_NAPT_IN_TYPE_INVALID)
		{
			TRACE("free HW NaptInIdx=%d",i);
			return i;
		}
	}


	if(rg_db.systemGlobal.tcpDoNotDelWhenRstFin)
	{
		for(i=naptInIdx;i<naptInIdx+inBoundHashWay;i++)
		{
			if(rg_db.naptIn[i].canBeReplaced==1)
			{
				return i;
			}
		}
	}

	return RG_RET_ENTRY_NOT_GET;
}


/*
	if hw has free return hw_idx first
	else if sw has free return software second
	else {#if CONFIG_ROME_NAPT_LRU try to delete napt by longest idle connection and return idx} return RG_RET_FAIL
*/
__SRAM_FWDENG_SLOWPATH
rtk_rg_entryGetReturn_t _rtk_rg_naptTcpUdpInFreeEntryGet(int addNaptSwOnly, rtk_rg_algAction_t algAction, int8 isTcp,int extIp,int extPort,int *pHashInIdx)
{
	int naptHashInIdx;
	int naptInIdx;

	naptHashInIdx=_rtk_rg_naptTcpUdpInHashIndex(isTcp,extIp,extPort);
	naptInIdx=naptHashInIdx<<2;

	if(pHashInIdx) *pHashInIdx=naptHashInIdx;

	//Check for ALG
	if(algAction==RG_ALG_ACT_TO_FWDENGINE || addNaptSwOnly)
	{
		//DEBUG("Add to pure software..naptHashOutIdx=%d %p",naptHashOutIdx,rg_db.pNaptOutFreeListHead);
		goto PURESW;
	}

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)	 //flow-based platform only support sw napt
	naptInIdx = _rtk_rg_naptTcpUdpInFreeEntryGetHardware(naptInIdx,isTcp,extIp,extPort);
	if(naptInIdx !=RG_RET_ENTRY_NOT_GET)
	{	//find a free hardware entry return!
		return naptInIdx;
	}
#endif

PURESW:
	//FIXME("NAPTR 4-ways is full - found link list");
	return _rtk_rg_swNaptInFreeEntryGet(naptHashInIdx);

}

#if	defined(CONFIG_RG_NAPT_UPNP_SUPPORT)
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_upnpCheck(void *data,ipaddr_t *transIP,uint16 *transPort)
{
	int upnpIdx;
	int ret;
	rtk_rg_upnpConnection_t upnp;
	rtk_rg_pktHdr_t *pPktHdr=(rtk_rg_pktHdr_t *)data;

	DEBUG("UPNP Check...");
	memset(&upnp,0,sizeof(upnp));

	for(upnpIdx=0;upnpIdx<MAX_UPNP_SW_TABLE_SIZE;upnpIdx++)
	{
		ret = (pf.rtk_rg_upnpConnection_find)(&upnp,&upnpIdx);
		if(ret!=RT_ERR_RG_OK) break;

		if(((upnp.is_tcp && (pPktHdr->tagif&TCP_TAGIF)) || (upnp.is_tcp==0 && (pPktHdr->tagif&UDP_TAGIF)))&&
			(upnp.gateway_port == pPktHdr->dport) &&
			(upnp.wan_intf_idx == pPktHdr->netifIdx) &&
			((upnp.limit_remote_ip==0) || (upnp.remote_ip==pPktHdr->ipv4Sip)) &&
			((upnp.limit_remote_port==0) || (upnp.remote_port==pPktHdr->sport)))
		{
			*transIP = upnp.local_ip;
			*transPort = upnp.local_port;
			DEBUG("hit. ==> [localIP:0x%x] [localPort:0x%x]\n",*transIP,*transPort);
			rg_db.upnp[upnpIdx].conn_create_idle = 0; //a new connection is create, reset the connection idle timer.

			if(upnp.type == UPNP_TYPE_ONESHOT)
				(pf.rtk_rg_upnpConnection_del)(upnpIdx);

			//for PPTP and L2TP WAN, we just add to sw napt list!!
#if defined(CONFIG_RG_RTL9602C_SERIES)
			//20160317LUKE: for ApolloFE, we can use hw to accelerate it.
			if(rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
				rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
				rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
				pPktHdr->addNaptSwOnly=1;
#else
			//Dslite, too
			if(rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
				rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
				rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN ||
				rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
				rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
				pPktHdr->addNaptSwOnly=1;
#endif
			if(rg_db.systemGlobal.interfaceInfo[upnp.wan_intf_idx].valid &IF_SOFTWARE4_ENTRY)
				pPktHdr->addNaptSwOnly=1;

			return RG_RET_SUCCESS;
		}
	}
	DEBUG("not hit.\n");
	return RG_RET_FAIL;
}
#endif

#if	defined(CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT)
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_virtualServerCheck(void *data,ipaddr_t *transIP,uint16 *transPort)
{
	int vsIdx;
	int ret;
	int off;
	rtk_rg_virtualServer_t virtualServer;
	rtk_rg_pktHdr_t *pPktHdr=(rtk_rg_pktHdr_t *)data;
	unsigned int tmpmask;

	DEBUG("Virtual Server Check...");

	memset(&virtualServer,0,sizeof(virtualServer));

	for(vsIdx=0;vsIdx<MAX_VIRTUAL_SERVER_SW_TABLE_SIZE;vsIdx++)
	{
		ret = (pf.rtk_rg_virtualServer_find)(&virtualServer,&vsIdx);
		if(ret!=RT_ERR_RG_OK) break;

		if(((virtualServer.is_tcp && (pPktHdr->tagif&TCP_TAGIF)) || (virtualServer.is_tcp==0 && (pPktHdr->tagif&UDP_TAGIF)))&&
			((virtualServer.disable_wan_check)||(virtualServer.wan_intf_idx == pPktHdr->netifIdx)) &&
			((pPktHdr->dport>=virtualServer.gateway_port_start) && (pPktHdr->dport<(virtualServer.gateway_port_start+virtualServer.mappingPortRangeCnt))) &&
			((virtualServer.remote_ip==0)||(virtualServer.remote_ip==pPktHdr->ipv4Sip)) &&
			((virtualServer.enable_limit_remote_src_port==0) || (virtualServer.enable_limit_remote_src_port && (pPktHdr->sport >= virtualServer.remote_src_port_start) && (pPktHdr->sport <= virtualServer.remote_src_port_end))))
		{
			off=pPktHdr->dport-virtualServer.gateway_port_start;
			*transIP = virtualServer.local_ip;
			if(virtualServer.mappingType==VS_MAPPING_N_TO_N)
				*transPort = virtualServer.local_port_start+off;
			else
				*transPort = virtualServer.local_port_start;

			DEBUG("Virtual Server HIT.==> [localIP:0x%x] [remoteIP:0x%x] [localPort:0x%x] mappingType=[%s]\n",*transIP,pPktHdr->ipv4Sip,*transPort,(virtualServer.mappingType==VS_MAPPING_N_TO_N)?"N-to-N":"N-to-1");

			//for PPTP and L2TP WAN, we just add to sw napt list!!
#if defined(CONFIG_RG_RTL9602C_SERIES)
			//20160317LUKE: for ApolloFE, we can use hw to accelerate it.
			if(rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
				rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP)
				pPktHdr->addNaptSwOnly=1;
#else
			//Dslite, too
			if(rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
				rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
				rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
				rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
				pPktHdr->addNaptSwOnly=1;
#endif
			if(rg_db.systemGlobal.interfaceInfo[virtualServer.wan_intf_idx].valid &IF_SOFTWARE4_ENTRY)
				pPktHdr->addNaptSwOnly=1;

			//20150114LUKE: for sever-in-lan ALG while hit virtualServer
			if(virtualServer.hookAlgType && (pPktHdr->algAction==RG_ALG_ACT_NORMAL))
			{
				ret=0;
				tmpmask=virtualServer.hookAlgType;
				while(tmpmask>>=1)ret++;
				pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;
				if(virtualServer.is_tcp)
					pPktHdr->algRegFun=rg_db.algTcpFunctionMapping[ret].registerFunction;
				else
					pPktHdr->algRegFun=rg_db.algUdpFunctionMapping[ret].registerFunction;
				pPktHdr->addNaptSwOnly=1;
				TRACE("Hook ALG[%x]!!",virtualServer.hookAlgType);
			}
			return RG_RET_SUCCESS;
		}
	}

	DEBUG("not hit.\n");
	return RG_RET_FAIL;
}
#endif

#if	defined(CONFIG_RG_NAPT_DMZ_SUPPORT)
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_dmzCheck(void *data,ipaddr_t *transIP,uint16 *transPort)
{
	rtk_rg_pktHdr_t *pPktHdr=(rtk_rg_pktHdr_t *)data;
	DEBUG("DMZ Check netifIdx=%d...",pPktHdr->netifIdx);

	if(rg_db.dmzInfo[pPktHdr->netifIdx].enabled && (rg_db.dmzInfo[pPktHdr->netifIdx].mac_mapping_enabled==0))
	{
		*transIP = rg_db.dmzInfo[pPktHdr->netifIdx].private_ip;
		DEBUG("hit. ==> [localIP:0x%x] [localPort:0x%x]\n",*transIP,*transPort);

		//for PPTP and L2TP WAN, we just add to sw napt list!!
#if defined(CONFIG_RG_RTL9602C_SERIES)
		//20160317LUKE: for ApolloFE, we can use hw to accelerate it.
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP)
			pPktHdr->addNaptSwOnly=1;
#else
		//Dslite, too
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
			rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)
			pPktHdr->addNaptSwOnly=1;
#endif
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].valid &IF_SOFTWARE4_ENTRY )
			pPktHdr->addNaptSwOnly=1;

	}
	else
	{
		DEBUG("not hit.\n");
		return RG_RET_FAIL;
	}

	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_outbound_dmzCheckSip(rtk_rg_pktHdr_t *pPktHdr,ipaddr_t outboundSip)
{

	//int i=0;
	DEBUG("DMZ Check SIP...");
	DEBUG("pPktHdr->netifIdx=%d",pPktHdr->netifIdx);

	//for(i=0 ; i<MAX_DMZ_TABLE_SIZE ; i++)
	if(rg_db.dmzInfo[pPktHdr->netifIdx].enabled && (rg_db.dmzInfo[pPktHdr->netifIdx].mac_mapping_enabled==0))
	{
		if(rg_db.dmzInfo[pPktHdr->netifIdx].private_ip == outboundSip)
		{
			TRACE("DMZ SIP Outbound");
			return RG_RET_SUCCESS;
		}
	}

	DEBUG("not hit.\n");
	return RG_RET_FAIL;

}

#endif

rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_portTriggerCheck(void *data,ipaddr_t *transIP,uint16 *transPort)
{
	int matchHeadIdx;
	rtk_rg_pktHdr_t *pPktHdr=(rtk_rg_pktHdr_t *)data;
	rtk_rg_portTrigger_list_t *pRelateEntry;
	
	DEBUG("Port Trigger check...");

	matchHeadIdx=(pPktHdr->tagif&TCP_TAGIF)>0;
	if(!list_empty(rg_db.systemGlobal.pPortTrigger_related_head[matchHeadIdx])){
		list_for_each_entry(pRelateEntry, rg_db.systemGlobal.pPortTrigger_related_head[matchHeadIdx], trigger_list){
			if(!(pRelateEntry->relate_port_start>pPktHdr->dport || pRelateEntry->relate_port_end<pPktHdr->dport)){
				*transIP = pRelateEntry->local_ip;
				DEBUG("Port Trigger HIT.==> [localIP:0x%x] [remoteIP:0x%x] [localPort:0x%x]",*transIP,pPktHdr->ipv4Sip,*transPort);
				return RG_RET_SUCCESS;
			}
		}
	}

	DEBUG("not hit.");
	return RG_RET_FAIL;
}

//20160525LUKE: check if we are receive packet from serverInLan's IP address.
rtk_rg_fwdEngineReturn_t _rtk_rg_serverInLanIP_check(rtk_rg_pktHdr_t *pPktHdr)
{
	int serviceIdx;
	int ret;
#if	defined(CONFIG_RG_NAPT_UPNP_SUPPORT)
	rtk_rg_upnpConnection_t upnp;
#endif
#if	defined(CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT)
	rtk_rg_virtualServer_t virtualServer;
#endif
#if	defined(CONFIG_RG_NAPT_DMZ_SUPPORT)
	rtk_rg_dmzInfo_t dmz_info;
#endif
	rtk_rg_staticRoute_t staticRoute;

#if	defined(CONFIG_RG_NAPT_UPNP_SUPPORT)
	bzero(&upnp,sizeof(upnp));
	DEBUG("UPNP Check...");
	for(serviceIdx=0;serviceIdx<MAX_UPNP_SW_TABLE_SIZE;serviceIdx++){
		ret = (pf.rtk_rg_upnpConnection_find)(&upnp,&serviceIdx);
		if(ret!=RT_ERR_RG_OK) break;

		if((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) &&
			upnp.local_ip==pPktHdr->ipv4Sip)return RG_FWDENGINE_RET_CONTINUE;
	}
#endif
#if	defined(CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT)
	bzero(&virtualServer,sizeof(virtualServer));
	DEBUG("Virtual Server Check...");
	for(serviceIdx=0;serviceIdx<MAX_VIRTUAL_SERVER_SW_TABLE_SIZE;serviceIdx++){
		ret = (pf.rtk_rg_virtualServer_find)(&virtualServer,&serviceIdx);
		if(ret!=RT_ERR_RG_OK) break;

		if((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && virtualServer.ipversion!=1){
			if(virtualServer.local_ip==pPktHdr->ipv4Sip)
				return RG_FWDENGINE_RET_CONTINUE;
		}else if(pPktHdr->tagif&IPV6_TAGIF && virtualServer.ipversion!=0){
			if(!memcmp(virtualServer.local_ipv6.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN))
				return RG_FWDENGINE_RET_CONTINUE;
		}
	}
#endif
#if	defined(CONFIG_RG_NAPT_DMZ_SUPPORT)
	bzero(&dmz_info,sizeof(dmz_info));
	DEBUG("DMZ Check...");
	for(serviceIdx=0;serviceIdx<MAX_DMZ_TABLE_SIZE;serviceIdx++){
		ret=(pf.rtk_rg_dmzHost_get)(serviceIdx,&dmz_info);
		if(ret!=RT_ERR_RG_OK) break;

		if(dmz_info.enabled)
		{
			if((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && dmz_info.ipversion!=1){
				if(dmz_info.private_ip==pPktHdr->ipv4Sip)
					return RG_FWDENGINE_RET_CONTINUE;
			}else if(pPktHdr->tagif&IPV6_TAGIF && dmz_info.ipversion!=0){
				if(!memcmp(dmz_info.private_ipv6.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN))
					return RG_FWDENGINE_RET_CONTINUE;
			}
		}
	}
#endif
	DEBUG("Static Route Check...");
	for(serviceIdx=0;serviceIdx<MAX_STATIC_ROUTE_SIZE;serviceIdx++){
		ret=(pf.rtk_rg_staticRoute_find)(&staticRoute,&serviceIdx);
		if(ret!=RT_ERR_RG_OK) break;

		if((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && !staticRoute.ip_version){
			if(staticRoute.ipv4.nexthop==pPktHdr->ipv4Sip)
				return RG_FWDENGINE_RET_CONTINUE;
		}else if(pPktHdr->tagif&IPV6_TAGIF && staticRoute.ip_version){
			if(!memcmp(staticRoute.ipv6.nexthop.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN))
				return RG_FWDENGINE_RET_CONTINUE;
		}
	}

	DEBUG("Unhit...add to swLUT!!");
	return RG_FWDENGINE_RET_L2FORWARDED;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_gatewayServicePort_check(rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	//1 must sync to _rtk_rg_localInNaptShortcutUpdate()
	if(pPktHdr->tagif & (TCP_TAGIF|UDP_TAGIF))
	{
		for(i=0;i<MAX_GATEWAYSERVICEPORT_TABLE_SIZE;i++){
			if(rg_db.gatewayServicePortEntry[i].valid==ENABLED){
				if(rg_db.gatewayServicePortEntry[i].type==GATEWAY_SERVER_SERVICE){//check dport
					if(pPktHdr->dport==rg_db.gatewayServicePortEntry[i].port_num){
						TRACE("[To PS] Hit gatewayServicePort[%d]: port_num=%d type=%s. trap to PS",i,rg_db.gatewayServicePortEntry[i].port_num,rg_db.gatewayServicePortEntry[i].type?"CLIENT(sport)":"SERVER(dport)");
						return RG_FWDENGINE_RET_TO_PS;
					}
				}else if(rg_db.gatewayServicePortEntry[i].type==GATEWAY_CLIENT_SERVICE){//check sport
					if(pPktHdr->sport==rg_db.gatewayServicePortEntry[i].port_num){
						TRACE("[To PS] Hit gatewayServicePort[%d]: port_num=%d type=%s. trap to PS",i,rg_db.gatewayServicePortEntry[i].port_num,rg_db.gatewayServicePortEntry[i].type?"CLIENT(sport)":"SERVER(dport)");
						return RG_FWDENGINE_RET_TO_PS;
					}
				}
			}
		}
	}

	TRACE("Does not hit Gateway service port");
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_gatewayPortRange_check(rtk_rg_pktHdr_t *pPktHdr)
{
	//1 must sync to _rtk_rg_localInNaptShortcutUpdate()
	//trap packet which its dport is in port range used by protocol stack
	if(pPktHdr->tagif & (TCP_TAGIF|UDP_TAGIF))
	{
		if(!(rg_kernel.lowerBoundPortUsedByPS==0 && rg_kernel.upperBoundPortUsedByPS==0) &&
			rg_kernel.lowerBoundPortUsedByPS<=pPktHdr->dport && pPktHdr->dport<=rg_kernel.upperBoundPortUsedByPS)
		{
			TRACE("[To PS] dport[%d] is protocol stack used.", pPktHdr->dport);
			return RG_FWDENGINE_RET_TO_PS;
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT

#if	defined(CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT)
int _rtk_rg_fwdEngine_ipv6VirtualServerCheck(void *data,rtk_ipv6_addr_t *transIP,uint16 *transPort)
{
	int vsIdx=0;
	int ret;
	int off;
	rtk_rg_virtualServer_t virtualServer;
	rtk_rg_pktHdr_t *pPktHdr=(rtk_rg_pktHdr_t *)data;

	DEBUG("Virtual Server Check...");

	memset(&virtualServer,0,sizeof(virtualServer));

	for(vsIdx=0;vsIdx<MAX_VIRTUAL_SERVER_SW_TABLE_SIZE;vsIdx++)
	{
		ret = rtk_rg_apollo_virtualServer_find(&virtualServer,&vsIdx);
		if(ret!=RT_ERR_RG_OK) continue;

		if(((pPktHdr->extipIdx!=FAIL))&&
			(virtualServer.valid==ENABLED)&&
			((virtualServer.is_tcp && (pPktHdr->tagif&TCP_TAGIF)) || (virtualServer.is_tcp==0 && (pPktHdr->tagif&UDP_TAGIF)))&&
			(virtualServer.wan_intf_idx == rg_db.nexthop[rg_db.extip[pPktHdr->extipIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx) &&
			((pPktHdr->dport>=virtualServer.gateway_port_start) && (pPktHdr->dport<(virtualServer.gateway_port_start+virtualServer.mappingPortRangeCnt))))
		{
			off=pPktHdr->dport-virtualServer.gateway_port_start;
			memcpy(transIP->ipv6_addr,virtualServer.local_ipv6.ipv6_addr,IPV6_ADDR_LEN);
			if(virtualServer.mappingType==VS_MAPPING_N_TO_N)
				*transPort = virtualServer.local_port_start+off;
			else
				*transPort = virtualServer.local_port_start;

			//record to pktHdr
			pPktHdr->ipv6_serverInLanLookup.serverInLanHit = RTK_RG_IPV6_LOOKUP_VIRTUALSERVER_HIT;
			pPktHdr->ipv6_serverInLanLookup.hitIndex = vsIdx;
			memcpy(pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,virtualServer.local_ipv6.ipv6_addr,IPV6_ADDR_LEN);
			pPktHdr->ipv6_serverInLanLookup.transPort=*transPort;

			TRACE("Virtual Server HIT.==> [localIP: %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x] [localPort:0x%x] mappingType=[%s]\n",
				transIP->ipv6_addr[0],transIP->ipv6_addr[1],transIP->ipv6_addr[2],transIP->ipv6_addr[3],
				transIP->ipv6_addr[4],transIP->ipv6_addr[5],transIP->ipv6_addr[6],transIP->ipv6_addr[7],
				transIP->ipv6_addr[8],transIP->ipv6_addr[9],transIP->ipv6_addr[10],transIP->ipv6_addr[11],
				transIP->ipv6_addr[12],transIP->ipv6_addr[13],transIP->ipv6_addr[14],transIP->ipv6_addr[15],
				*transPort,(virtualServer.mappingType==VS_MAPPING_N_TO_N)?"N-to-N":"N-to-1");

			return RT_ERR_RG_OK;
		}
	}

	DEBUG("not hit.\n");
	return RT_ERR_RG_FAILED;
}
#endif




#if	defined(CONFIG_RG_NAPT_DMZ_SUPPORT)
int _rtk_rg_fwdEngine_ipv6DmzCheck(void *data,rtk_ipv6_addr_t *transIP,uint16 *transPort)
{
	int netifIdx;
	rtk_rg_pktHdr_t *pPktHdr=(rtk_rg_pktHdr_t *)data;

	DEBUG("DMZ Check...");

	if(pPktHdr->extipIdx!=FAIL){
		netifIdx=rg_db.nexthop[rg_db.extip[pPktHdr->extipIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
		DEBUG("netifIdx=%d, enabled=%d mac_mapping_enabled=%d",netifIdx,rg_db.dmzInfo[netifIdx].enabled,rg_db.dmzInfo[netifIdx].mac_mapping_enabled);
		if(rg_db.dmzInfo[netifIdx].enabled && (rg_db.dmzInfo[netifIdx].mac_mapping_enabled==0))
		{
			//bring to up layer function for DIP lookup.
			memcpy(transIP->ipv6_addr,rg_db.dmzInfo[netifIdx].private_ipv6.ipv6_addr,IPV6_ADDR_LEN);

			//record to pktHdr
			pPktHdr->ipv6_serverInLanLookup.serverInLanHit = RTK_RG_IPV6_LOOKUP_DMZ_HIT;
			pPktHdr->ipv6_serverInLanLookup.hitIndex = netifIdx;
			memcpy(pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,rg_db.dmzInfo[netifIdx].private_ipv6.ipv6_addr,IPV6_ADDR_LEN);
			pPktHdr->ipv6_serverInLanLookup.transPort=*transPort;

			DEBUG("hit DMZ[%d]. ==> [localIP %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x] \n",netifIdx,
				transIP->ipv6_addr[0],transIP->ipv6_addr[1],transIP->ipv6_addr[2],transIP->ipv6_addr[3],
				transIP->ipv6_addr[4],transIP->ipv6_addr[5],transIP->ipv6_addr[6],transIP->ipv6_addr[7],
				transIP->ipv6_addr[8],transIP->ipv6_addr[9],transIP->ipv6_addr[10],transIP->ipv6_addr[11],
				transIP->ipv6_addr[12],transIP->ipv6_addr[13],transIP->ipv6_addr[14],transIP->ipv6_addr[15]);
			return RT_ERR_RG_OK;
		}
	}

	DEBUG("not hit.\n");
	return RT_ERR_RG_FAILED;
}
#endif


int _rtk_rg_fwdEngine_ipv6ConnType_lookup(rtk_rg_pktHdr_t *pPktHdr, rtk_ipv6_addr_t *transIP, int16 *transPort)
{
	int r1=-1,r2=-1,r3=-1;
	if((pPktHdr==NULL) || (transIP==NULL) || (transPort==NULL)) return RG_FWDENGINE_RET_TO_PS;

	//IPv6 use another set of l4_port
	//ret = _rtk_rg_gatewayServicePort_check(pPktHdr);
	//if(ret==RG_FWDENGINE_RET_TO_PS) return RG_FWDENGINE_RET_TO_PS;

	pPktHdr->ipv6_serverInLanLookup.serverInLanHit = RTK_RG_IPV6_LOOKUP_NONE_HIT;
	//Inbound connection table lookup, e.g. UPNP,virtual server & DMZ tables.
	if(((rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupFirstCallBack!=NULL) && ((r1=rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupFirstCallBack(pPktHdr,transIP,transPort))==RT_ERR_OK)) ||
		((rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupSecondCallBack!=NULL) && ((r2=rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupSecondCallBack(pPktHdr,transIP,transPort))==RT_ERR_OK)) ||
		((rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupThirdCallBack!=NULL) && ((r3=rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupThirdCallBack(pPktHdr,transIP,transPort))==RT_ERR_OK)))
	{
		if(r1==RT_ERR_OK)
		{
#if	defined(CONFIG_RG_NAPT_UPNP_SUPPORT)

			//pPktHdr->ipv6_serverInLanLookup.serverInLanHit = RTK_RG_IPV6_LOOKUP_UPNP_HIT;
			//if(rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupFirstCallBack==_rtk_rg_fwdEngine_ipv6UpnpCheck)
			//{
				//TRACE("UPnP entry hit!");
			//}
#endif
		}
		else if(r2==RT_ERR_OK)
		{
#ifdef CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT

			pPktHdr->ipv6_serverInLanLookup.serverInLanHit = RTK_RG_IPV6_LOOKUP_VIRTUALSERVER_HIT;
			if(rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupSecondCallBack==_rtk_rg_fwdEngine_ipv6VirtualServerCheck)
			{
				TRACE("Server Port entry hit!");
			}
#endif

		}
		else if(r3==RT_ERR_OK)
		{
#ifdef CONFIG_RG_NAPT_DMZ_SUPPORT
			pPktHdr->ipv6_serverInLanLookup.serverInLanHit = RTK_RG_IPV6_LOOKUP_DMZ_HIT;
			if(rg_db.systemGlobal.initParam.ipv6NaptInboundConnLookupThirdCallBack==_rtk_rg_fwdEngine_ipv6DmzCheck)
			{
				TRACE("DMZ hit!");
			}
#endif
		}
		return RG_FWDENGINE_RET_CONTINUE;
	}

	return RG_FWDENGINE_RET_TO_PS;
}
#endif


rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_connType_lookup(rtk_rg_pktHdr_t *pPktHdr, ipaddr_t *transIP, int16 *transPort)
{
	rtk_rg_fwdEngineReturn_t ret;

	if((pPktHdr==NULL) || (transIP==NULL) || (transPort==NULL)) return RG_FWDENGINE_RET_TO_PS;

	pPktHdr->naptrLookupHit=0;
	//Inbound connection table lookup, e.g. UPNP > Virtual server > Gateway service port > DMZ tables.
	if((rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack!=NULL) && (rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack(pPktHdr,transIP,transPort)==RG_RET_SUCCESS))
	{
#if	defined(CONFIG_RG_NAPT_UPNP_SUPPORT)
		pPktHdr->naptrLookupHit=1;
		if(rg_db.systemGlobal.initParam.naptInboundConnLookupFirstCallBack==_rtk_rg_fwdEngine_upnpCheck)
		{
			TRACE("UPNP entry hit!");
			return RG_FWDENGINE_RET_CONTINUE;
		}
#endif
	}

	if((rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack!=NULL) && (rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack(pPktHdr,transIP,transPort)==RG_RET_SUCCESS))
	{
#ifdef CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT
		pPktHdr->naptrLookupHit=2;
		if(rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack==_rtk_rg_fwdEngine_virtualServerCheck)
		{
			TRACE("Virtual server entry hit!");
			return RG_FWDENGINE_RET_CONTINUE;
		}
#endif
	}

	if((pPktHdr->tagif&L2TP_INNER_TAGIF)==0x0)
	{
		ret=_rtk_rg_gatewayServicePort_check(pPktHdr);
		if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
	}

	if(_rtk_rg_fwdEngine_portTriggerCheck(pPktHdr,transIP,transPort)==RG_RET_SUCCESS)
	{
		pPktHdr->naptrLookupHit=4;
		TRACE("Port Trigger hit!");
		return RG_FWDENGINE_RET_CONTINUE;
	}

	if((rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack!=NULL) && (rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack(pPktHdr,transIP,transPort)==RG_RET_SUCCESS))
	{
#ifdef CONFIG_RG_NAPT_DMZ_SUPPORT
		pPktHdr->naptrLookupHit=3;
		if(rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack==_rtk_rg_fwdEngine_dmzCheck)
		{
			TRACE("DMZ hit!");
			return RG_FWDENGINE_RET_CONTINUE;
		}
#endif
	}

	TRACE("[%s] Inbound flow is not found in NAPTR table. And it does not hit UPNP/DMZ/Virtual server and Gateway service port", (rg_db.systemGlobal.inboundL4UnknownUdpConnDrop && (pPktHdr->tagif&UDP_TAGIF))?"Drop":"To PS");
	return (rg_db.systemGlobal.inboundL4UnknownUdpConnDrop && (pPktHdr->tagif&UDP_TAGIF)) ? RG_FWDENGINE_RET_DROP : RG_FWDENGINE_RET_TO_PS;
}


int _url_parsing_accept(rtk_rg_pktHdr_t *pPktHdr)
{
	char *accept_head,*accept_tail,*accept_type;

	if(pPktHdr->pL4Payload){
		accept_head = strstr(pPktHdr->pL4Payload, "Accept: ");
		if(accept_head){
			accept_tail = strchr(accept_head, '\r');
			accept_type = strstr(accept_head, "text/");
			if(accept_type && accept_tail && accept_type<=accept_tail){
				return 1;
			}
		}
	}

	return 0;
}


void _url_parsing_string(rtk_rg_pktHdr_t *pPktHdr, char *fqdn, char *url_head, char *url_tail, char *path_head, char *path_tail)
{
	char space = 0x20;
	char sep[3];
	int url_len = 0;
	int path_len = 0;

	/*use for parsing Host:*/
	sep[0]=0x0d;
	sep[1]=0x0a;
	sep[2]='\0';

	bzero(fqdn, MAX_URL_FILTER_BUF_LENGTH);

	if(pPktHdr->pL4Payload!=NULL){
		path_head = strstr(pPktHdr->pL4Payload, "/");
	}else{
		//rtlglue_printf("pL4Payload is null\n");
	}

	if(path_head!=NULL){
		//rtlglue_printf("path_head:%s.\n",url_head);
		path_tail = strchr(path_head, space);
	}else{
		DEBUG("[URL_PARSER]path_head is null\n");
	}

	if(path_tail!=NULL){
		//rtlglue_printf("path_tail:%s.\n",url_tail);
		DEBUG("[URL_PARSER]Lookup for \"Referer:\"\n");
		url_head = strstr(path_tail, "Referer:");
		if(url_head!=NULL){
			url_head = strchr(url_head, space);//cut the "Referer:"
			if(url_head!=NULL)
				url_head = &url_head[1];//cut the " "
		}
		if(!url_head){
			DEBUG("[URL_PARSER]Lookup for \"Host:\"\n");
			url_head = strstr(path_tail, "Host:");
			if(url_head!=NULL){
				url_head = strchr(url_head, space);//cut the "Host:"
				if(url_head!=NULL)
					url_head = &url_head[1];//cut the " "
			}
		}
	}else{
		DEBUG("[URL_PARSER]path_tail is null\n");
	}

	if(url_head!=NULL){
		//rtlglue_printf("path_head:%s.\n",path_head);
		url_tail = strstr(url_head, sep);
	}else{
		DEBUG("[URL_PARSER]url_head is null\n");
	}

	if(url_tail!=NULL){
		//rtlglue_printf("url_tail:%s.\n",path_tail);
	}else{
		DEBUG("[URL_PARSER]url_tail is null\n");
	}

	if(url_head!=NULL && url_tail!=NULL && path_head!=NULL && path_tail!=NULL){
		url_len = url_tail - url_head;
		path_len = path_tail - path_head;
		if(url_len>=MAX_URL_FILTER_BUF_LENGTH)
		{
			//dump_packet(pData,len,"urlFilter Packet");
			DEBUG("[URL_PARSER]fqdn too long url_len=%d!!!\n",url_len);
			strncpy(fqdn,url_head,MAX_URL_FILTER_BUF_LENGTH);
			fqdn[MAX_URL_FILTER_BUF_LENGTH-1]='\0';
		}
		else if((url_len+path_len)>=MAX_URL_FILTER_BUF_LENGTH)
		{
			DEBUG("[URL_PARSER]fqdn too long url_len=%d  path_len=%d!!!\n",url_len,path_len);
			strncpy(fqdn,url_head,url_len);
			path_len=MAX_URL_FILTER_BUF_LENGTH-url_len;
			strncpy((fqdn+url_len),path_head,path_len);
			fqdn[MAX_URL_FILTER_BUF_LENGTH-1]='\0';
		}
		else
		{
			strncpy(fqdn,url_head,url_len);
			strncpy((fqdn+url_len),path_head,path_len);
			fqdn[url_len+path_len]='\0';
		}
	}else{
		//dump_packet(pData,len,"urlFilter Packet");
		//rtlglue_printf("fqdn: can not parse, trap!!! \n");
		fqdn=NULL;
	}

	return;
}

void _https_url_parsing_string(rtk_rg_pktHdr_t *pPktHdr, char *fqdn)
{
	char *pData, *pSsl_start, *pSsl_extHdr_end;
	uint32 ssl_len = pPktHdr->skb->len - pPktHdr->l4Offset - pPktHdr->headerLen;
	uint32 ssl_extHdr_len, len, type;

	bzero(fqdn, MAX_URL_FILTER_BUF_LENGTH);
	pData = pSsl_start = pPktHdr->pL4Payload;

	//skip handshake header and random field
	pData += 43; // 5+6+32
	//skip session ID field
	len = *pData;
	pData += (1+len);
	//skip cipher suites fields
	len = ntohs(*(uint16 *)pData);
	pData += (2+len);
	//skip compression methods files
	len = *pData;
	pData += (1+len);
	//check if there is still more data
	if(pData >= (pSsl_start+ssl_len)) return;
	//record ssl extension length
	ssl_extHdr_len = ntohs(*(uint16 *)pData);
	pData += 2;
	//check if there is still more data
	if((pSsl_start+ssl_len-pData) < ssl_extHdr_len) return;
	//parse extension fields, and finding server name
	pSsl_extHdr_end = pData + ssl_extHdr_len;
	while(pData < pSsl_extHdr_end)
	{
		type = ntohs(*(uint16 *)pData);
		len = ntohs(*(uint16 *)(pData+2));
		pData += 4;
		if(type==0 /*server name*/)
		{
			len = ntohs(*(uint16 *)(pData+3));
			//find server name;
			strncpy(fqdn, pData+5, len);
			fqdn[len] = '\0';
			TRACE("[Https url filter] Find server name indication extension list and server name is %s", fqdn);
			return;
		}
		else
		{
			pData += len;
		}
	}

	TRACE("[Https url filter] There is no server name indication extension list in this client hello packet");
	return;
}

static char keyword_fqdn[MAX_URL_FILTER_STR_LENGTH+MAX_URL_FILTER_PATH_LENGTH];// urlfilter url_filter_string(128) + urlfilter path_filter_string(256)

rtk_rg_fwdEngineReturn_t _rtk_rg_urlFilter(u8 *pData, u32 len, rtk_rg_pktHdr_t *pPktHdr)
{

	char *fqdn=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *keyword; //urlfilter url_filter_string
	char *path;//urlfilter path_filter_string

	char *parseSuccess=NULL;
	char *url_head=NULL;
	char *url_tail=NULL;
	char *path_head=NULL;
	char *path_tail=NULL;
	int keyword_url_len = 0;
	int keyword_path_len = 0;
	rtk_rg_filterControlType_t macFilterMode=RG_FILTER_NONE;
	rtk_rg_urlFilterEntry_t *urlEntry=NULL;
	rtk_rg_urlFilterEntry_t *urlEntryTmp=NULL;

	rtk_rg_naptInfo_t naptInfo;
	int valid_idx;
	int ret=FAIL; 

	//accelerate
	if(_check_urlFilter_is_enabled(pPktHdr)==FALSE)
		return RG_FWDENGINE_RET_CONTINUE;

	if(pPktHdr->pL4Payload==NULL){
		TRACE("[URLFILTER]urlFilter get a Empty payload packet, %s it!\n",rg_db.systemGlobal.urlFilterMode==RG_FILTER_WHITE?"DROP":"CONTINUE");
		if(rg_db.systemGlobal.urlFilterMode==RG_FILTER_WHITE)
		{
			TRACE("[DROP] drop by url filter");
			TRACE("[DROP] empty payload packet dropped by white_list mode. SMAC:%02x-%02x-%02x-%02x-%02x-%02x SIP:%d.%d.%d.%d DIP:%d.%d.%d.%d\n",
							pPktHdr->smac[0],pPktHdr->smac[1],pPktHdr->smac[2],pPktHdr->smac[3],pPktHdr->smac[4],pPktHdr->smac[5],
							(pPktHdr->ipv4Sip>>24)&0xff,(pPktHdr->ipv4Sip>>16)&0xff,(pPktHdr->ipv4Sip>>8)&0xff,(pPktHdr->ipv4Sip)&0xff,
							(pPktHdr->ipv4Dip>>24)&0xff,(pPktHdr->ipv4Dip>>16)&0xff,(pPktHdr->ipv4Dip>>8)&0xff,(pPktHdr->ipv4Dip)&0xff);
			return RG_FWDENGINE_RET_DROP;
		}
		else
			return RG_FWDENGINE_RET_CONTINUE;
	}

	/*parsing FQDN*/
	if(pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort)
		_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);
	else if(pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort)
		_https_url_parsing_string(pPktHdr, fqdn);
	else
	{
		bzero(fqdn, MAX_URL_FILTER_BUF_LENGTH);
		TRACE("[URLFILTER] dport is neither http(%d) nor https(%d)", rg_db.systemGlobal.httpMonitorPort, rg_db.systemGlobal.httpsMonitorPort);
		return RG_FWDENGINE_RET_CONTINUE;
	}

	if(fqdn==NULL)
		DEBUG("[URLFILTER]fqdn:NULL\n");
	else
		DEBUG("[URLFILTER]fqdn:%s\n",fqdn);

	//check urlFilterSmacFirst
	list_for_each_entry_safe(urlEntry,urlEntryTmp,&rg_db.systemGlobal.urlFilterBySmacHash[rtk_rg_apollo_urlFilterBySmacHash(pPktHdr->smac)],urlfilter_list)
	{
		if(memcmp(urlEntry->urlFilter.urlfilterSamc,pPktHdr->smac,ETHER_ADDR_LEN)) continue;
		keyword = urlEntry->urlFilter.url_filter_string;
		path = urlEntry->urlFilter.path_filter_string;
		//we are sure the mac urlfilterSmacMode always same
		if(macFilterMode==RG_FILTER_NONE)
			macFilterMode = urlEntry->urlFilter.urlfilterSmacMode;					
		
		if(fqdn==NULL || keyword==NULL || path==NULL || strlen(keyword)==0 )
		{
			DEBUG("[URLFILTER]urlFilter get a NULL keyword or path!");
			continue;
		}
		if(urlEntry->urlFilter.path_exactly_match)
		{
			keyword_url_len = strlen(urlEntry->urlFilter.url_filter_string);
			keyword_path_len = strlen(urlEntry->urlFilter.path_filter_string);
			DEBUG("[URLFILTER]keyword_url_len=%d keyword_path_len=%d\n",keyword_url_len,keyword_path_len);
			strncpy(keyword_fqdn,urlEntry->urlFilter.url_filter_string,keyword_url_len);
			strncpy((keyword_fqdn+keyword_url_len),urlEntry->urlFilter.path_filter_string,keyword_path_len);
			keyword_fqdn[keyword_url_len+keyword_path_len]='\0';

			DEBUG("[URLFILTER]keyword_fqdn:%s \n",keyword_fqdn);

			if(strlen(fqdn)!=strlen(keyword_fqdn)){
				DEBUG("[URLFILTER]len not the same! fqdn_len=%d  keyword_len=%d\n\n\n",strlen(fqdn),strlen(keyword_fqdn));
				//return RG_RET_SUCCESS;
			}else if(strcmp(fqdn,keyword_fqdn)){
				/*strcmp return true if fqdn & keyword not the same */
				DEBUG("[URLFILTER]strcmp not the same! keyword=%s \n\n\n",keyword);
				//return RG_RET_SUCCESS;
			}else{
				if(macFilterMode==RG_FILTER_BLACK)
				{
					bzero(&naptInfo,sizeof(naptInfo));
					valid_idx= -1;
					naptInfo.naptTuples.is_tcp=1;
					naptInfo.naptTuples.local_ip=pPktHdr->ipv4Sip;
					naptInfo.naptTuples.local_port=pPktHdr->sport;
					naptInfo.naptTuples.remote_ip=pPktHdr->ipv4Dip;
					naptInfo.naptTuples.remote_port=pPktHdr->dport;
					if((pf.rtk_rg_naptConnection_find)(&naptInfo,&valid_idx)==RT_ERR_RG_OK){
						DEBUG("[URLFILTER_MAC]del napt[%d]: sip=0x%x dip=0x%x sport=%d dport=%d\n",valid_idx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
						assert_ok((pf.rtk_rg_naptConnection_del)(valid_idx));
					}
					urlEntry->urlFilter.urlBlockAllowTimes++;
					TRACE("[URLFILTER_MAC]URL PACKET HAS BEEN DROP!\n\n\n");
					ret=RG_FWDENGINE_RET_DROP;
				}
				else
				{
					urlEntry->urlFilter.urlBlockAllowTimes++;
					TRACE("[URLFILTER_MAC]URL PACKET HAS BEEN CONTINUE!\n\n\n");
					ret = RG_FWDENGINE_RET_CONTINUE;
				}
			}
		}
		else
		{
			//keyword only
			DEBUG("[URLFILTER]keyword: %s \n",keyword);
			parseSuccess = strstr(fqdn, keyword);
			if(parseSuccess!=NULL){
				if(macFilterMode==RG_FILTER_BLACK)
				{
					bzero(&naptInfo,sizeof(naptInfo));
					valid_idx= -1;
					naptInfo.naptTuples.is_tcp=1;
					naptInfo.naptTuples.local_ip=pPktHdr->ipv4Sip;
					naptInfo.naptTuples.local_port=pPktHdr->sport;
					naptInfo.naptTuples.remote_ip=pPktHdr->ipv4Dip;
					naptInfo.naptTuples.remote_port=pPktHdr->dport;

					if((pf.rtk_rg_naptConnection_find)(&naptInfo,&valid_idx)==RT_ERR_RG_OK){
						DEBUG("[URLFILTER_MAC]del napt[%d]: sip=0x%x dip=0x%x sport=%d dport=%d\n",valid_idx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
						assert_ok((pf.rtk_rg_naptConnection_del)(valid_idx));
					}
					urlEntry->urlFilter.urlBlockAllowTimes++;
					TRACE("[URLFILTER_MAC]URL PACKET HAS BEEN DROP!");
					ret= RG_FWDENGINE_RET_DROP;
				}
				else
				{
					urlEntry->urlFilter.urlBlockAllowTimes++;
					TRACE("[URLFILTER_MAC]URL PACKET HAS BEEN CONTINUE!");
					ret=RG_FWDENGINE_RET_CONTINUE;
				}
			}
		}
	}		
	//non-hit any rule give a default action for this mac
	if(macFilterMode==RG_FILTER_BLACK && ret==FAIL)
	{
		TRACE("Using mac defualt rule RG_FWDENGINE_RET_CONTINUE");
		ret = RG_FWDENGINE_RET_CONTINUE;
	}
	else if(macFilterMode==RG_FILTER_WHITE && ret==FAIL)
	{
		TRACE("Using mac defualt rule RG_FWDENGINE_RET_DROP");
		ret=RG_FWDENGINE_RET_DROP;
	}

		//and check global
	list_for_each_entry_safe(urlEntry,urlEntryTmp,&rg_db.systemGlobal.urlFilterByString,urlfilter_list)
	{

		keyword = urlEntry->urlFilter.url_filter_string;
		path = urlEntry->urlFilter.path_filter_string;
		if(fqdn==NULL || keyword==NULL || path==NULL || strlen(keyword)==0)
		{
			DEBUG("[URLFILTER]urlFilter get a NULL keyword or path!");
			continue;
		}

		if(urlEntry->urlFilter.path_exactly_match)
		{
			keyword_url_len = strlen(urlEntry->urlFilter.url_filter_string);
			keyword_path_len = strlen(urlEntry->urlFilter.path_filter_string);
			DEBUG("[URLFILTER]keyword_url_len=%d keyword_path_len=%d\n",keyword_url_len,keyword_path_len);
			strncpy(keyword_fqdn,urlEntry->urlFilter.url_filter_string,keyword_url_len);
			strncpy((keyword_fqdn+keyword_url_len),urlEntry->urlFilter.path_filter_string,keyword_path_len);
			keyword_fqdn[keyword_url_len+keyword_path_len]='\0';

			DEBUG("[URLFILTER]keyword_fqdn:%s \n",keyword_fqdn);

			if(strlen(fqdn)!=strlen(keyword_fqdn)){
				DEBUG("[URLFILTER]len not the same! fqdn_len=%d  keyword_len=%d\n\n\n",strlen(fqdn),strlen(keyword_fqdn));
				//return RG_RET_SUCCESS;
			}else if(strcmp(fqdn,keyword_fqdn)){
				/*strcmp return true if fqdn & keyword not the same */
				DEBUG("[URLFILTER]strcmp not the same! keyword=%s \n\n\n",keyword);
				//return RG_RET_SUCCESS;
			}else{
				if(rg_db.systemGlobal.urlFilterMode==RG_FILTER_BLACK)
				{
					if(ret==FAIL)
					{
						bzero(&naptInfo,sizeof(naptInfo));
						valid_idx= -1;
						naptInfo.naptTuples.is_tcp=1;
						naptInfo.naptTuples.local_ip=pPktHdr->ipv4Sip;
						naptInfo.naptTuples.local_port=pPktHdr->sport;
						naptInfo.naptTuples.remote_ip=pPktHdr->ipv4Dip;
						naptInfo.naptTuples.remote_port=pPktHdr->dport;

						if((pf.rtk_rg_naptConnection_find)(&naptInfo,&valid_idx)==RT_ERR_RG_OK){
							DEBUG("[URLFILTER]del napt[%d]: sip=0x%x dip=0x%x sport=%d dport=%d",valid_idx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
							assert_ok((pf.rtk_rg_naptConnection_del)(valid_idx));
						}

						urlEntry->urlFilter.urlBlockAllowTimes++;
						TRACE("[URLFILTER]URL PACKET HAS BEEN DROP!");
						ret=RG_FWDENGINE_RET_DROP;
					}
					else if (ret==RG_FWDENGINE_RET_DROP)
					{
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_BLACK and HitMacAction==RG_FWDENGINE_RET_DROP Only Update urlBlockAllowTimes");
						urlEntry->urlFilter.urlBlockAllowTimes++;
					}
					else if (ret==RG_FWDENGINE_RET_CONTINUE)
					{
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_BLACK and HitMacAction==RG_FWDENGINE_RET_CONTINUE  do nothing");
						//do nothing
					}


				}
				else
				{
					if(ret==FAIL)
					{
						urlEntry->urlFilter.urlBlockAllowTimes++;
						TRACE("[URLFILTER]URL PACKET HAS BEEN CONTINUE!\n\n\n");
						ret = RG_FWDENGINE_RET_CONTINUE;
					}
					else if (ret==RG_FWDENGINE_RET_DROP)
					{
						//do nothing
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_WHITE and HitMacAction==RG_FWDENGINE_RET_DROP  do nothing");
					}
					else if (ret==RG_FWDENGINE_RET_CONTINUE)
					{
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_WHITE and HitMacAction==RG_FWDENGINE_RET_CONTINUE Only Update urlBlockAllowTimes");
						urlEntry->urlFilter.urlBlockAllowTimes++;
					}
				}
			}
		}
		else
		{
			//keyword only
			DEBUG("[URLFILTER]keyword: %s \n",keyword);
			parseSuccess = strstr(fqdn, keyword);

			if(parseSuccess!=NULL){
				if(rg_db.systemGlobal.urlFilterMode==RG_FILTER_BLACK)
				{
					if(ret==FAIL)
					{
						bzero(&naptInfo,sizeof(naptInfo));
						valid_idx= -1;
						naptInfo.naptTuples.is_tcp=1;
						naptInfo.naptTuples.local_ip=pPktHdr->ipv4Sip;
						naptInfo.naptTuples.local_port=pPktHdr->sport;
						naptInfo.naptTuples.remote_ip=pPktHdr->ipv4Dip;
						naptInfo.naptTuples.remote_port=pPktHdr->dport;

						if((pf.rtk_rg_naptConnection_find)(&naptInfo,&valid_idx)==RT_ERR_RG_OK){
							DEBUG("[URLFILTER]del napt[%d]: sip=0x%x dip=0x%x sport=%d dport=%d\n",valid_idx,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
							assert_ok((pf.rtk_rg_naptConnection_del)(valid_idx));
						}
						urlEntry->urlFilter.urlBlockAllowTimes++;
						TRACE("[URLFILTER]URL PACKET HAS BEEN DROP!\n\n\n");
						ret= RG_FWDENGINE_RET_DROP;
					}
					else if (ret==RG_FWDENGINE_RET_DROP)
					{
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_BLACK and HitMacAction==RG_FWDENGINE_RET_DROP Only Update urlBlockAllowTimes");
						urlEntry->urlFilter.urlBlockAllowTimes++;
					}
					else if (ret==RG_FWDENGINE_RET_CONTINUE)
					{
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_BLACK and HitMacAction==RG_FWDENGINE_RET_CONTINUE  do nothing");
						//do nothing
					}

				}
				else
				{
					if(ret==FAIL)
					{
						urlEntry->urlFilter.urlBlockAllowTimes++;
						TRACE("[URLFILTER]URL PACKET HAS BEEN CONTINUE!\n\n\n");
						ret=RG_FWDENGINE_RET_CONTINUE;
					}
					else if (ret==RG_FWDENGINE_RET_DROP)
					{
						//do nothing
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_WHITE and HitMacAction==RG_FWDENGINE_RET_DROP  do nothing");
					}
					else if (ret==RG_FWDENGINE_RET_CONTINUE)
					{
						TRACE("[URLFILTER]URL Multi-Hit Global hit RG_FILTER_WHITE and HitMacAction==RG_FWDENGINE_RET_CONTINUE Only Update urlBlockAllowTimes");
						urlEntry->urlFilter.urlBlockAllowTimes++;
					}
				}
			}
			else
				DEBUG("parseSuccess NULL");
		}
	}

	//non-hit any global rule give a global default action
	if(rg_db.systemGlobal.urlFilterMode==RG_FILTER_BLACK && ret==FAIL)
	{
		TRACE("Using global RG_FILTER_BLACK defualt action RG_FWDENGINE_RET_CONTINUE");
		ret = RG_FWDENGINE_RET_CONTINUE;
	}
	else if(rg_db.systemGlobal.urlFilterMode==RG_FILTER_WHITE && ret==FAIL)
	{
		TRACE("Using global RG_FILTER_WHITE defualt action RG_FWDENGINE_RET_DROP");
		ret=RG_FWDENGINE_RET_DROP;
	}

	return ret;


}


void _rtk_rg_fillMaxL4Ways(int naptOutIdx,int naptInIdx,int naptOutHashIdx,int naptInHashIdx)
{
	int i,inIdx,wanIntfIdx,wayIdx=0;
	ptrdiff_t naptOutListIdx, naptInListIdx;

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(naptOutIdx>=MAX_NAPT_OUT_HW_TABLE_SIZE)
	{
		rtk_rg_table_naptOut_linkList_t *pNaptOutList;
		wayIdx=4;
		pNaptOutList=rg_db.pNaptOutHashListHead[naptOutHashIdx];
		while(pNaptOutList!=NULL)
		{
			if(rg_db.systemGlobal.enableL4WaysList==1)
			{
				if(wayIdx==4)
				{
					rtlglue_printf("outHashIdx=%d\n",naptOutHashIdx);
					for(i=naptOutHashIdx<<2;i<(naptOutHashIdx<<2)+4;i++)
					{
						if(rg_db.naptOut[i].rtk_naptOut.valid!=0)
						{
							inIdx=rg_db.naptOut[i].rtk_naptOut.hashIdx;
							wanIntfIdx=rg_db.nexthop[rg_db.extip[rg_db.naptIn[inIdx].rtk_naptIn.extIpIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
							rtlglue_printf("[O:%04d] [0x%08x:%d]-->[WANIF:%d:%d]-->[0x%08x:%d] %s\n",i,
								rg_db.naptIn[inIdx].rtk_naptIn.intIp,
								rg_db.naptIn[inIdx].rtk_naptIn.intPort,
								wanIntfIdx,
								rg_db.naptOut[i].extPort,
								rg_db.naptOut[i].remoteIp,
								rg_db.naptOut[i].remotePort,
								(rg_db.naptIn[inIdx].rtk_naptIn.isTcp)?"TCP":"UDP");
						}

					}
				}
				naptOutListIdx = _rtk_rg_list_entry_idx(pNaptOutList, &(rg_db.naptOutFreeList[0])) + MAX_NAPT_OUT_HW_TABLE_SIZE; //use address-based method to get naptOutFreeList entry index. (naptOutFreeList[i] mapping to naptOut[i+MAX_NAPT_OUT_HW_TABLE_SIZE])
				i=naptOutListIdx;
				if(rg_db.naptOut[i].rtk_naptOut.valid!=0)
				{
					inIdx=rg_db.naptOut[i].rtk_naptOut.hashIdx;
					wanIntfIdx=rg_db.nexthop[rg_db.extip[rg_db.naptIn[inIdx].rtk_naptIn.extIpIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
					rtlglue_printf("[O:%04d] [0x%08x:%d]-->[WANIF:%d:%d]-->[0x%08x:%d] %s\n",i,
						rg_db.naptIn[inIdx].rtk_naptIn.intIp,
						rg_db.naptIn[inIdx].rtk_naptIn.intPort,
						wanIntfIdx,
						rg_db.naptOut[i].extPort,
						rg_db.naptOut[i].remoteIp,
						rg_db.naptOut[i].remotePort,
						(rg_db.naptIn[inIdx].rtk_naptIn.isTcp)?"TCP":"UDP"
						);
				}
			}

			pNaptOutList=pNaptOutList->pNext;
			wayIdx++;
		}
	}
	else
	{
		wayIdx=(naptOutIdx&3)+1;
	}
	if(wayIdx>rg_db.systemGlobal.l4OutboundMaxWays[naptOutHashIdx]) rg_db.systemGlobal.l4OutboundMaxWays[naptOutHashIdx]=wayIdx;

	if(naptInIdx>=MAX_NAPT_IN_HW_TABLE_SIZE)
	{
		rtk_rg_table_naptIn_linkList_t *pNaptInList;
		wayIdx=4;
		pNaptInList=rg_db.pNaptInHashListHead[naptInHashIdx];
		while(pNaptInList!=NULL)
		{
			if(rg_db.systemGlobal.enableL4WaysList==1)
			{
				if(wayIdx==4)
				{
					rtlglue_printf("inHashIdx=%d\n",naptInHashIdx);
					for(i=naptInHashIdx<<2;i<(naptInHashIdx<<2)+4;i++)
					{
						if(rg_db.naptIn[i].rtk_naptIn.valid!=0)
						{
							wanIntfIdx=rg_db.nexthop[rg_db.extip[rg_db.naptIn[i].rtk_naptIn.extIpIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
							rtlglue_printf("[I:%04d] [RHASH:%x]-->[WANIF:%d:PORT:0x%x] %s\n",i,
								rg_db.naptIn[i].rtk_naptIn.remHash,
								wanIntfIdx,
								(rg_db.naptIn[i].rtk_naptIn.extPortHSB<<8) | rg_db.naptIn[i].rtk_naptIn.extPortLSB,
								(rg_db.naptIn[i].rtk_naptIn.isTcp)?"TCP":"UDP");
#else
							rtlglue_printf("[I:%04d] [RHASH:%x]-->[WANIF:%d:LSB:0x%x] %s\n",i,
								rg_db.naptIn[i].rtk_naptIn.remHash,
								wanIntfIdx,
								rg_db.naptIn[i].rtk_naptIn.extPortLSB,
								(rg_db.naptIn[i].rtk_naptIn.isTcp)?"TCP":"UDP");
#endif
						}
					}
				}
				naptInListIdx = _rtk_rg_list_entry_idx(pNaptInList, &(rg_db.naptInFreeList[0])) + MAX_NAPT_IN_HW_TABLE_SIZE; //use address-based method to get naptInFreeList entry index. (naptInFreeList[i] mapping to naptin[i+MAX_NAPT_IN_HW_TABLE_SIZE])
				i=naptInListIdx;
				if(rg_db.naptIn[i].rtk_naptIn.valid!=0)
				{
					wanIntfIdx=rg_db.nexthop[rg_db.extip[rg_db.naptIn[i].rtk_naptIn.extIpIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					rtlglue_printf("[I:%04d] [RHASH:%x]-->[WANIF:%d:PORT:0x%x] %s\n",i,
						rg_db.naptIn[i].rtk_naptIn.remHash,
						wanIntfIdx,
						(rg_db.naptIn[i].rtk_naptIn.extPortHSB<<8) | rg_db.naptIn[i].rtk_naptIn.extPortLSB,
						(rg_db.naptIn[i].rtk_naptIn.isTcp)?"TCP":"UDP");
#else
					rtlglue_printf("[I:%04d] [RHASH:%x]-->[WANIF:%d:LSB:0x%x] %s\n",i,
						rg_db.naptIn[i].rtk_naptIn.remHash,
						wanIntfIdx,
						rg_db.naptIn[i].rtk_naptIn.extPortLSB,
						(rg_db.naptIn[i].rtk_naptIn.isTcp)?"TCP":"UDP");
#endif
				}

			}

			pNaptInList=pNaptInList->pNext;
			wayIdx++;
		}
	}
	else
	{
		wayIdx=(naptInIdx&3)+1;
	}
	if(wayIdx>rg_db.systemGlobal.l4InboundMaxWays[naptInHashIdx]) rg_db.systemGlobal.l4InboundMaxWays[naptInHashIdx]=wayIdx;

#else //CONFIG_RG_FLOW_BASED_PLATFORM

	{
		rtk_rg_table_naptOut_linkList_t *pNaptOutList;
		wayIdx=0;
		pNaptOutList=rg_db.pNaptOutHashListHead[naptOutHashIdx];
		while(pNaptOutList!=NULL)
		{
			if(rg_db.systemGlobal.enableL4WaysList==1)
			{
				naptOutListIdx = _rtk_rg_list_entry_idx(pNaptOutList, &(rg_db.naptOutFreeList[0])) + MAX_NAPT_OUT_HW_TABLE_SIZE; //use address-based method to get naptOutFreeList entry index. (naptOutFreeList[i] mapping to naptOut[i+MAX_NAPT_OUT_HW_TABLE_SIZE])
				i=naptOutListIdx;
				if(rg_db.naptOut[i].rtk_naptOut.valid!=0)
				{
					inIdx=rg_db.naptOut[i].rtk_naptOut.hashIdx;
					wanIntfIdx=rg_db.nexthop[rg_db.extip[rg_db.naptIn[inIdx].rtk_naptIn.extIpIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
					rtlglue_printf("[O:%04d] [0x%08x:%d]-->[WANIF:%d:%d]-->[0x%08x:%d] %s\n",i,
						rg_db.naptIn[inIdx].rtk_naptIn.intIp,
						rg_db.naptIn[inIdx].rtk_naptIn.intPort,
						wanIntfIdx,
						rg_db.naptOut[i].extPort,
						rg_db.naptOut[i].remoteIp,
						rg_db.naptOut[i].remotePort,
						(rg_db.naptIn[inIdx].rtk_naptIn.isTcp)?"TCP":"UDP"
						);
				}
			}
			pNaptOutList=pNaptOutList->pNext;
			wayIdx++;
		}
	}
	if(wayIdx>rg_db.systemGlobal.l4OutboundMaxWays[naptOutHashIdx]) rg_db.systemGlobal.l4OutboundMaxWays[naptOutHashIdx]=wayIdx;

	{
		rtk_rg_table_naptIn_linkList_t *pNaptInList;
		wayIdx=0;
		pNaptInList=rg_db.pNaptInHashListHead[naptInHashIdx];
		while(pNaptInList!=NULL)
		{
			if(rg_db.systemGlobal.enableL4WaysList==1)
			{
				naptInListIdx = _rtk_rg_list_entry_idx(pNaptInList, &(rg_db.naptInFreeList[0])) + MAX_NAPT_IN_HW_TABLE_SIZE; //use address-based method to get naptInFreeList entry index. (naptInFreeList[i] mapping to naptin[i+MAX_NAPT_IN_HW_TABLE_SIZE])
				i=naptInListIdx;
				if(rg_db.naptIn[i].rtk_naptIn.valid!=0)
				{
					wanIntfIdx=rg_db.nexthop[rg_db.extip[rg_db.naptIn[i].rtk_naptIn.extIpIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;
					rtlglue_printf("[I:%04d] [RHASH:%x]-->[WANIF:%d:PORT:0x%x] %s\n",i,
						rg_db.naptIn[i].rtk_naptIn.remHash,
						wanIntfIdx,
						(rg_db.naptIn[i].rtk_naptIn.extPortHSB<<8) | rg_db.naptIn[i].rtk_naptIn.extPortLSB,
						(rg_db.naptIn[i].rtk_naptIn.isTcp)?"TCP":"UDP");
				}

			}

			pNaptInList=pNaptInList->pNext;
			wayIdx++;
		}
	}
	if(wayIdx>rg_db.systemGlobal.l4InboundMaxWays[naptInHashIdx]) rg_db.systemGlobal.l4InboundMaxWays[naptInHashIdx]=wayIdx;

#endif

}

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
void _rtk_rg_recycleReusedSymmetricEntry(int naptOutIdx,int naptInIdx)
{
	// outbound reuse, del old inbound flow
	if(rg_db.naptOut[naptOutIdx].canBeReplaced==1)
	{
		int inIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;

		if(rg_db.naptIn[inIdx].rtk_naptIn.valid==ASIC_NAPT_IN_TYPE_PORT_RESTRICTED_CONE)
		{
			//20151202LUKE: call softwareNaptInfoDelete callback here.
			if(rg_db.systemGlobal.initParam.softwareNaptInfoDeleteCallBack != NULL){
				rtk_rg_naptInfo_t naptInfo;
#if 0//def __KERNEL__
				rtk_rg_wq_union_t *softwareNaptDelWq=wq_callbackAssign();
#endif
				//20151202LUKE: collect info from NAPT/NAPTR table.
				_rtk_rg_naptInfoCollectForCallback(naptOutIdx, &naptInfo);
#if 0//def __KERNEL__
				if(softwareNaptDelWq){
					INIT_WORK(&(softwareNaptDelWq->work), wq_do_softwareNaptDelCallBack);
					memcpy(&(softwareNaptDelWq->naptInfo),&naptInfo,sizeof(rtk_rg_naptInfo_t));
					schedule_work(&(softwareNaptDelWq->work));
				}
#else
				rg_db.systemGlobal.initParam.softwareNaptInfoDeleteCallBack(&naptInfo);
#endif
			}

			// only set software valid to zero, let next entry can be replaced.
			rg_db.naptIn[inIdx].rtk_naptIn.valid=ASIC_NAPT_IN_TYPE_INVALID;
			rg_db.naptIn[inIdx].canBeReplaced=0;
			_rtk_rg_naptExtPortFree(rg_db.naptOut[naptOutIdx].forceExtPort, rg_db.naptIn[inIdx].rtk_naptIn.isTcp, rg_db.naptIn[inIdx].rtk_naptIn.intIp, rg_db.naptIn[inIdx].rtk_naptIn.intPort, rg_db.naptOut[naptOutIdx].extPort, 0);
		}
	}

	// inbound reuse, del old outbound flow.
	if(rg_db.naptIn[naptInIdx].canBeReplaced==1) //only hit when valid==ASIC_NAPT_IN_TYPE_PORT_RESTRICTED_CONE
	{
		int outIdx=rg_db.naptIn[naptInIdx].symmetricNaptOutIdx;

		if(rg_db.naptOut[outIdx].rtk_naptOut.valid==1)
		{
			//20151202LUKE: call softwareNaptInfoDelete callback here.
			if(rg_db.systemGlobal.initParam.softwareNaptInfoDeleteCallBack != NULL){
				rtk_rg_naptInfo_t naptInfo;
#if 0//def __KERNEL__
				rtk_rg_wq_union_t *softwareNaptDelWq=wq_callbackAssign();
#endif
				//20151202LUKE: collect info from NAPT/NAPTR table.
				_rtk_rg_naptInfoCollectForCallback(outIdx, &naptInfo);
#if 0//def __KERNEL__
				if(softwareNaptDelWq){
					INIT_WORK(&(softwareNaptDelWq->work), wq_do_softwareNaptDelCallBack);
					memcpy(&(softwareNaptDelWq->naptInfo),&naptInfo,sizeof(rtk_rg_naptInfo_t));
					schedule_work(&(softwareNaptDelWq->work));
				}
#else
				rg_db.systemGlobal.initParam.softwareNaptInfoDeleteCallBack(&naptInfo);
#endif
			}

			// only set software valid to zero, let next entry can be replaced.
			rg_db.naptOut[outIdx].rtk_naptOut.valid=0;
			rg_db.naptOut[outIdx].canBeReplaced=0;
			_rtk_rg_naptExtPortFree(rg_db.naptOut[outIdx].forceExtPort, rg_db.naptIn[naptInIdx].rtk_naptIn.isTcp, rg_db.naptIn[naptInIdx].rtk_naptIn.intIp, rg_db.naptIn[naptInIdx].rtk_naptIn.intPort, rg_db.naptOut[outIdx].extPort, 0);
		}
	}
}

/*
	if (interface > hardware limit){ add NAPT software only}
	if (napt || naptr index > hardware entry ){ add NAPT software only}
*/
void rtk_rg_AddNaptSwPreProces(int8 isTcp, ipaddr_t local_ip, uint16 local_port, ipaddr_t remote_ip, uint16 remote_port,ipaddr_t ext_ip, uint16 ext_port)
{
	int naptOutIdx,naptOutHash;
	int naptInIdx,naptInHash;

	naptOutHash =_rtk_rg_naptTcpUdpOutHashIndex(isTcp,local_ip,local_port,remote_ip,remote_port);
	naptOutIdx=naptOutHash<<2;
	naptOutIdx = _rtk_rg_naptTcpUdpOutFreeEntryGetHardware(naptOutIdx);

	naptInHash=_rtk_rg_naptTcpUdpInHashIndex(isTcp,ext_ip,ext_port);
	naptInIdx=naptInHash<<2;
	naptInIdx = _rtk_rg_naptTcpUdpInFreeEntryGetHardware(naptInIdx,isTcp,ext_ip,ext_port);


	if((naptInIdx!=RG_RET_ENTRY_NOT_GET)  && (rg_db.naptIn[naptInIdx].rtk_naptIn.valid==ASIC_NAPT_IN_TYPE_FULL_CONE))
	{
		//ingore full_cone
	}
	else
	{
		if((naptInIdx==RG_RET_ENTRY_NOT_GET ) || (naptOutIdx==RG_RET_ENTRY_NOT_GET))
		{
			TABLE(" naptInIdx or naptOutIdx is software entry ADD software NAPT/NAPTR Only!");
			rg_db.pktHdr->addNaptSwOnly = 1;
		}

		if( (rg_db.systemGlobal.interfaceInfo[rg_db.pktHdr->netifIdx].storedInfo.is_wan)&& (rg_db.systemGlobal.interfaceInfo[rg_db.pktHdr->netifIdx].valid &IF_SOFTWARE4_ENTRY))
		{
			TABLE("egress wan netif is software interface ADD software NAPT/NAPTR Only!");
			rg_db.pktHdr->addNaptSwOnly = 1;
		}
	}

	return ;
}
#endif	// not CONFIG_RG_FLOW_BASED_PLATFORM

#ifdef CONFIG_RG_NAPT_INBOUND_TRACKING
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_inbound_fillNaptInfo(int *outIdx, rtk_rg_pktHdr_t *pPktHdr, ipaddr_t transIP, uint16 transPort)
{
	rtk_rg_extPortGetReturn_t extPort;
	rtk_rg_entryGetReturn_t naptOutIdx,naptInIdx=0;
	int isTCP=0;
	int hashOutIdx,hashInIdx;
	uint32 forceExtPort = TRUE;

	// Check napt access limit number
	if(rg_db.systemGlobal.naptAccessLimitNumber >= 0)
	{
		if(rg_db.systemGlobal.naptAccessLimitNumber <= atomic_read(&rg_db.systemGlobal.naptAccessLimitCount))
		{
			TRACE("[To PS] Limit napt access number(%d)", rg_db.systemGlobal.naptAccessLimitNumber);
			return RG_RET_FAIL;
		}
	}

	if(pPktHdr->tagif&TCP_TAGIF) isTCP=1;

	//found a free ext Port first.
	extPort=_rtk_rg_naptExtPortGetAndUse(forceExtPort, isTCP, transIP, transPort, ntohs(*pPktHdr->pDport), pPktHdr->pIpv4Dip, TRUE, pPktHdr->naptrLookupHit);

	assert(extPort!=RG_RET_EXTPORT_NOT_GET);
	if(extPort==RG_RET_EXTPORT_NOT_GET) return RG_RET_FAIL;
	DEBUG("Found external port:%d\n",extPort);

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//naptinbound pre-process
	rtk_rg_AddNaptSwPreProces(isTCP,transIP,transPort,pPktHdr->ipv4Sip,pPktHdr->sport,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,extPort);
#else //flow-based platform only support sw napt
	pPktHdr->addNaptSwOnly=1;
#endif

	//found a free naptOut entry
	naptOutIdx=_rtk_rg_naptTcpUdpOutFreeEntryGet(pPktHdr->addNaptSwOnly,pPktHdr->algAction,isTCP,transIP,transPort,pPktHdr->ipv4Sip,pPktHdr->sport,&hashOutIdx);
	assert(naptOutIdx!=RG_RET_ENTRY_NOT_GET);
	if(naptOutIdx==RG_RET_ENTRY_NOT_GET) return RG_RET_FAIL;

	//found a free naptIn entry
	naptInIdx=_rtk_rg_naptTcpUdpInFreeEntryGet(pPktHdr->addNaptSwOnly,pPktHdr->algAction,isTCP,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,extPort,&hashInIdx);
	assert(naptInIdx!=RG_RET_ENTRY_NOT_GET);
	if(naptInIdx==RG_RET_ENTRY_NOT_GET) return RG_RET_FAIL;

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(rg_db.systemGlobal.tcpDoNotDelWhenRstFin) _rtk_rg_recycleReusedSymmetricEntry(naptOutIdx,naptInIdx);
#endif

	rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx=naptInIdx;
	rg_db.naptOut[naptOutIdx].rtk_naptOut.valid=1;
	rg_db.naptOut[naptOutIdx].rtk_naptOut.priValid=0;
	rg_db.naptOut[naptOutIdx].rtk_naptOut.priValue=0;
	rg_db.naptOut[naptOutIdx].extPort=extPort;
	rg_db.naptOut[naptOutIdx].state=INVALID;
	rg_db.naptOut[naptOutIdx].canBeReplaced=0;
	rg_db.naptOut[naptOutIdx].cannotAddToHw=RG_FWDENGINE_FORWARDCB_CONTINUE_DPI;	//check DPI if hook registerd
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_init_list_head(&rg_db.naptOut[naptOutIdx].flowListHead);
#endif

	rg_db.naptIn[naptInIdx].rtk_naptIn.extIpIdx=pPktHdr->extipIdx;
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_db.naptIn[naptInIdx].rtk_naptIn.extPortHSB=(extPort>>8)&0xff;
#endif
	rg_db.naptIn[naptInIdx].rtk_naptIn.extPortLSB=extPort&0xff;
	rg_db.naptIn[naptInIdx].rtk_naptIn.intIp=transIP;
	rg_db.naptIn[naptInIdx].rtk_naptIn.intPort=transPort;
	rg_db.naptIn[naptInIdx].rtk_naptIn.isTcp=isTCP;
	rg_db.naptIn[naptInIdx].rtk_naptIn.priId=0;
	rg_db.naptIn[naptInIdx].rtk_naptIn.priValid=0;
	rg_db.naptIn[naptInIdx].rtk_naptIn.remHash=_rtk_rg_NAPTRemoteHash_get(pPktHdr->ipv4Sip,pPktHdr->sport);
	rg_db.naptIn[naptInIdx].canBeReplaced=0;
	rg_db.naptIn[naptInIdx].cannotAddToHw=RG_FWDENGINE_FORWARDCB_CONTINUE_DPI;		//check DPI if hook registerd

	rg_db.naptOut[naptOutIdx].remoteIp=pPktHdr->ipv4Sip;
	rg_db.naptOut[naptOutIdx].remotePort=pPktHdr->sport;

#if	defined(CONFIG_RG_NAPT_VIRTUAL_SERVER_SUPPORT)
	if((pPktHdr->naptrLookupHit==2)&&(rg_db.systemGlobal.initParam.naptInboundConnLookupSecondCallBack==_rtk_rg_fwdEngine_virtualServerCheck))
	{
		rg_db.naptIn[naptInIdx].rtk_naptIn.valid=ASIC_NAPT_IN_TYPE_FULL_CONE;
		rg_db.naptIn[naptInIdx].coneType=NAPT_IN_TYPE_FULL_CONE;
		rg_db.naptIn[naptInIdx].symmetricNaptOutIdx=0; //non-used field

	}
	else
#endif
	{
		rg_db.naptIn[naptInIdx].rtk_naptIn.valid=ASIC_NAPT_IN_TYPE_PORT_RESTRICTED_CONE;
		rg_db.naptIn[naptInIdx].coneType=NAPT_IN_TYPE_SYMMETRIC_NAPT;
#if defined(NAPT_TABLE_SIZE_DEBUG)
        assert(naptOutIdx < (1 << MAX_NAPT_IN_NAPTOUTIDX_WIDTH));
#endif
		rg_db.naptIn[naptInIdx].symmetricNaptOutIdx=naptOutIdx;
	}
	rg_db.naptIn[naptInIdx].refCount=1;
	if(rg_db.systemGlobal.enableL4MaxWays==1) _rtk_rg_fillMaxL4Ways(naptOutIdx,naptInIdx,hashOutIdx,hashInIdx);


	*outIdx=naptOutIdx;

	TABLE("Set NAPT in[%d] out[%d] Entry",naptInIdx,naptOutIdx);

	//Record valid NAPT entry
	rg_db.naptValidSet[naptOutIdx>>5] |= (0x1<<(naptOutIdx&31));

	// Record napt access count
	rg_db.naptOut[naptOutIdx].recordedInLimitCount = 1;
	atomic_inc(&rg_db.systemGlobal.naptAccessLimitCount);

	rg_db.naptOut[naptOutIdx].naptrLookupHit = pPktHdr->naptrLookupHit;
	rg_db.naptOut[naptOutIdx].forceExtPort = forceExtPort;

	TRACE("[add napt counter(%d)] napt outIdx[%d]", atomic_read(&rg_db.systemGlobal.naptAccessLimitCount), naptOutIdx);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Record cpri of napt
	rg_db.naptOut[naptOutIdx].src_cpri_en 	= FALSE;
	rg_db.naptOut[naptOutIdx].src_cpri 		= 0;
	rg_db.naptOut[naptOutIdx].dst_cpri_en 	= (rg_db.systemGlobal.flow_based_cpri_decision_portmask & (0x1<<pPktHdr->ingressPort)) ? TRUE : FALSE;
	rg_db.naptOut[naptOutIdx].dst_cpri 		= ((rg_db.systemGlobal.flow_based_cpri_decision_portmask & (0x1<<pPktHdr->ingressPort)) && (pPktHdr->tagif&CVLAN_TAGIF)) ? pPktHdr->ctagPri : 0;
#endif

	//20151126LUKE: call softwareNaptInfoAdd callback here.
	if(rg_db.systemGlobal.initParam.softwareNaptInfoAddCallBack != NULL){
		rtk_rg_naptInfo_t naptInfo;
#if 0//def __KERNEL__
		rtk_rg_wq_union_t *softwareNaptAddWq=wq_callbackAssign();
#endif
		//20151202LUKE: collect info from NAPT/NAPTR table.
		_rtk_rg_naptInfoCollectForCallback(naptOutIdx, &naptInfo);
#if 0//def __KERNEL__
		if(softwareNaptAddWq){
			INIT_WORK(&(softwareNaptAddWq->work), wq_do_softwareNaptAddCallBack);
			memcpy(&(softwareNaptAddWq->naptInfo),&naptInfo,sizeof(rtk_rg_naptInfo_t));
			schedule_work(&(softwareNaptAddWq->work));
		}
#else
		rg_db.systemGlobal.initParam.softwareNaptInfoAddCallBack(&naptInfo);
#endif
	}

	return RG_RET_SUCCESS;
}
#endif

/*
input:pPktHdr
output:outIdx
find inIdx/outIdx and fill software table  rg_db.naptOut/rg_db.naptIn return *outIdx=outIdx
*/
__SRAM_FWDENG_SLOWPATH
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_outbound_fillNaptInfo(int *outIdx, rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_extPortGetReturn_t extPort;
	rtk_rg_entryGetReturn_t naptOutIdx,naptInIdx;
//	int sipArpIdx;
	int isTCP=0;
	int hashOutIdx,hashInIdx;
	uint16 srcPort = pPktHdr->sport;
	uint32 forceExtPort = (pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE) ? pPktHdr->algKeepExtPort : FALSE;

	// Check napt access limit number
	if(rg_db.systemGlobal.naptAccessLimitNumber >= 0)
	{
		if(rg_db.systemGlobal.naptAccessLimitNumber <= atomic_read(&rg_db.systemGlobal.naptAccessLimitCount))
		{
			TRACE("[Drop] Limit napt access number(%d)", rg_db.systemGlobal.naptAccessLimitNumber);
			return RG_RET_FAIL;
		}
	}

	if(pPktHdr->tagif&TCP_TAGIF) isTCP=1;

	//20151008LUKE: check for Extip valid or not, if invalid, return RG_RET_FAIL
	if(pPktHdr->extipIdx<0 || !rg_db.extip[pPktHdr->extipIdx].rtk_extip.valid){ TRACE("rg_db.extip[%d].rtk_extip.valid=%d",pPktHdr->extipIdx,rg_db.extip[pPktHdr->extipIdx].rtk_extip.valid); return RG_RET_FAIL;}

	if(pPktHdr->isHairpinNat && (pPktHdr->sport==pPktHdr->dport)) {
		srcPort = pPktHdr->sport+1;
		TRACE("[HairpinNat] SP=DP=%d, so replace SP as %d to prevent mismatch.", pPktHdr->sport, srcPort);
	}

	//found a free ext Port first.
	if(pPktHdr->algAction==RG_ALG_ACT_TO_FWDENGINE)
	{
		extPort=_rtk_rg_naptExtPortGetAndUse(forceExtPort, isTCP, pPktHdr->ipv4Sip, pPktHdr->sport, srcPort, &rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr, TRUE, pPktHdr->naptrLookupHit);
		assert(extPort!=RG_RET_EXTPORT_NOT_GET);
		if(extPort==RG_RET_EXTPORT_NOT_GET){ TRACE("extPort=%d",extPort); return RG_RET_FAIL; }
	}
	else	//RG_ALG_ACT_NORMAL
	{
		extPort=_rtk_rg_naptExtPortGetAndUse(forceExtPort, isTCP, pPktHdr->ipv4Sip, pPktHdr->sport, srcPort, &rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr, TRUE, pPktHdr->naptrLookupHit);
		assert(extPort!=RG_RET_EXTPORT_NOT_GET);
		if(extPort==RG_RET_EXTPORT_NOT_GET){ TRACE("extPort=%d",extPort); return RG_RET_FAIL; }
	}

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//naptinbound rtk_rg_AddNaptSwPreProces
	rtk_rg_AddNaptSwPreProces(isTCP,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,extPort);
#else //flow-based platform only support sw napt
	pPktHdr->addNaptSwOnly=1;
#endif

	//found a free naptOut entry
	naptOutIdx=_rtk_rg_naptTcpUdpOutFreeEntryGet(pPktHdr->addNaptSwOnly,pPktHdr->algAction,isTCP,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport,&hashOutIdx);
	assert(naptOutIdx!=RG_RET_ENTRY_NOT_GET);
	if(naptOutIdx==RG_RET_ENTRY_NOT_GET){ TRACE("naptOutIdx=%d",naptOutIdx); return RG_RET_FAIL;}

	//found a free naptIn entry
	naptInIdx=_rtk_rg_naptTcpUdpInFreeEntryGet(pPktHdr->addNaptSwOnly,pPktHdr->algAction,isTCP,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,extPort,&hashInIdx);
	assert(naptInIdx!=RG_RET_ENTRY_NOT_GET);
	if(naptInIdx==RG_RET_ENTRY_NOT_GET){ TRACE("naptInIdx=%d",naptInIdx); return RG_RET_FAIL;}

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(rg_db.systemGlobal.tcpDoNotDelWhenRstFin) _rtk_rg_recycleReusedSymmetricEntry(naptOutIdx,naptInIdx);
#endif

	rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx=naptInIdx;
	rg_db.naptOut[naptOutIdx].rtk_naptOut.valid=1;
	rg_db.naptOut[naptOutIdx].rtk_naptOut.priValid=0;
	rg_db.naptOut[naptOutIdx].rtk_naptOut.priValue=0;
	rg_db.naptOut[naptOutIdx].extPort=extPort;
	rg_db.naptOut[naptOutIdx].state=INVALID;
	rg_db.naptOut[naptOutIdx].canBeReplaced=0;
	rg_db.naptOut[naptOutIdx].cannotAddToHw=RG_FWDENGINE_FORWARDCB_CONTINUE_DPI;		//check DPI if hook registerd
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	_rtk_rg_init_list_head(&rg_db.naptOut[naptOutIdx].flowListHead);
#endif

	rg_db.naptIn[naptInIdx].rtk_naptIn.extIpIdx=pPktHdr->extipIdx;
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_db.naptIn[naptInIdx].rtk_naptIn.extPortHSB=(extPort>>8)&0xff;
#endif
	rg_db.naptIn[naptInIdx].rtk_naptIn.extPortLSB=extPort&0xff;
	rg_db.naptIn[naptInIdx].rtk_naptIn.intIp=pPktHdr->ipv4Sip;
	rg_db.naptIn[naptInIdx].rtk_naptIn.intPort=pPktHdr->sport;
	rg_db.naptIn[naptInIdx].rtk_naptIn.isTcp=isTCP;
	rg_db.naptIn[naptInIdx].rtk_naptIn.priId=0;
	rg_db.naptIn[naptInIdx].rtk_naptIn.priValid=0;
	rg_db.naptIn[naptInIdx].rtk_naptIn.remHash=_rtk_rg_NAPTRemoteHash_get(pPktHdr->ipv4Dip,pPktHdr->dport);
	rg_db.naptIn[naptInIdx].canBeReplaced=0;
	rg_db.naptIn[naptInIdx].cannotAddToHw=RG_FWDENGINE_FORWARDCB_CONTINUE_DPI;		//check DPI if hook registerd
	rg_db.naptIn[naptInIdx].rtk_naptIn.valid=ASIC_NAPT_IN_TYPE_PORT_RESTRICTED_CONE;

	rg_db.naptOut[naptOutIdx].remoteIp=pPktHdr->ipv4Dip;
	rg_db.naptOut[naptOutIdx].remotePort=pPktHdr->dport;
	rg_db.naptIn[naptInIdx].coneType=NAPT_IN_TYPE_SYMMETRIC_NAPT;
#if defined(NAPT_TABLE_SIZE_DEBUG)
    assert(naptOutIdx < (1 << MAX_NAPT_IN_NAPTOUTIDX_WIDTH));
#endif
	rg_db.naptIn[naptInIdx].symmetricNaptOutIdx=naptOutIdx;
	rg_db.naptIn[naptInIdx].refCount = 1;
	if(rg_db.systemGlobal.enableL4MaxWays==1) _rtk_rg_fillMaxL4Ways(naptOutIdx,naptInIdx,hashOutIdx,hashInIdx);

	//TABLE("Add napt ==> %x:%d<-->%x:%d<-->%x:%d\n",rg_db.naptIn[naptInIdx].rtk_naptIn.intIp,rg_db.naptIn[naptInIdx].rtk_naptIn.intPort,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr,extPort,rg_db.naptOut[naptOutIdx].remoteIp,rg_db.naptOut[naptOutIdx].remotePort);

	*outIdx=naptOutIdx;

	TABLE("Set NAPT in[%d] out[%d] entry",naptInIdx,naptOutIdx);

	//Record valid NAPT entry
	rg_db.naptValidSet[naptOutIdx>>5] |= (0x1<<(naptOutIdx&31));

	// Record napt access count
	rg_db.naptOut[naptOutIdx].recordedInLimitCount = 1;
	atomic_inc(&rg_db.systemGlobal.naptAccessLimitCount);

	rg_db.naptOut[naptOutIdx].naptrLookupHit = pPktHdr->naptrLookupHit;
	rg_db.naptOut[naptOutIdx].forceExtPort = forceExtPort;

	TRACE("[add napt counter(%d)] napt outIdx[%d]", atomic_read(&rg_db.systemGlobal.naptAccessLimitCount), naptOutIdx);

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//Record cpri of napt
	rg_db.naptOut[naptOutIdx].src_cpri_en 	= (rg_db.systemGlobal.flow_based_cpri_decision_portmask & (0x1<<pPktHdr->ingressPort)) ? TRUE : FALSE;
	rg_db.naptOut[naptOutIdx].src_cpri 		= ((rg_db.systemGlobal.flow_based_cpri_decision_portmask & (0x1<<pPktHdr->ingressPort)) && (pPktHdr->tagif&CVLAN_TAGIF)) ? pPktHdr->ctagPri : 0;
	rg_db.naptOut[naptOutIdx].dst_cpri_en 	= FALSE;
	rg_db.naptOut[naptOutIdx].dst_cpri 		= 0;
#endif

	//dnf game mechanism check
	_rtk_rg_dnf_game_mechanism_check(naptOutIdx, pPktHdr->netifIdx);

	//20151126LUKE: call softwareNaptInfoAdd callback here.
	if(rg_db.systemGlobal.initParam.softwareNaptInfoAddCallBack != NULL){
		rtk_rg_naptInfo_t naptInfo;
#if 0//def __KERNEL__
		rtk_rg_wq_union_t *softwareNaptAddWq=wq_callbackAssign();
#endif
		//20151202LUKE: collect info from NAPT/NAPTR table.
		_rtk_rg_naptInfoCollectForCallback(naptOutIdx, &naptInfo);
#if 0//def __KERNEL__
		if(softwareNaptAddWq){
			INIT_WORK(&(softwareNaptAddWq->work), wq_do_softwareNaptAddCallBack);
			memcpy(&(softwareNaptAddWq->naptInfo),&naptInfo,sizeof(rtk_rg_naptInfo_t));
			schedule_work(&(softwareNaptAddWq->work));
		}
#else
		rg_db.systemGlobal.initParam.softwareNaptInfoAddCallBack(&naptInfo);
#endif
	}

	return RG_RET_SUCCESS;
}

void _rtk_rg_addPPPoETag(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb,int l3Modify,int l4Modify)
{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
	int i;
	u16 len;
	u16 sid;
	//int total_len;
#ifdef CONFIG_APOLLO_MODEL
#else
	//add pppoe here
	if(skb_headroom(skb)<8)
	{
		FIXME("no more free skb buff in header room");
	}
	else
#endif
#if defined(CONFIG_RG_RTL9600_SERIES) && defined(CONFIG_GPON_FEATURE)
	if(rg_db.systemGlobal.gpon_pppoe_status==GPON_PPPOE_MODE_SW_OFFLOAD)
	{
		rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].idleSecs=0; //update pppoe idleTime

		pPktHdr->egressTagif|=PPPOE_TAGIF;
	}
	else
#endif
	{
		len = pPktHdr->l3Len + 2;

		rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].idleSecs=0; //update pppoe idleTime

		sid=rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].rtk_pppoe.sessionID;
		//DEBUG("SID is %d",sid);

		//DEBUG("before add pppoe header l3off=%d l4off=%d len=%d, total_len=%d",pPktHdr->l3Offset,pPktHdr->l4Offset,skb->len,total_len);

		skb->data-=8;
		//skb->len=total_len+8;
		skb->len+=8;
		skb_reset_mac_header(skb);

		//DA,SA
		for(i=0;i<pPktHdr->l3Offset-2;i++)
			skb->data[i]=skb->data[i+8];

		//reset DMAC and SMAC pointer
		pPktHdr->pDmac=&skb->data[0];
		pPktHdr->pSmac=&skb->data[6];

		//8864
		skb->data[pPktHdr->l3Offset-2]=0x88;
		skb->data[pPktHdr->l3Offset-1]=0x64;

		//Code
		skb->data[pPktHdr->l3Offset]=0x11;
		skb->data[pPktHdr->l3Offset+1]=0;

		//session id
		skb->data[pPktHdr->l3Offset+2]=sid>>8;
		skb->data[pPktHdr->l3Offset+3]=sid&0xff;

		//len
		skb->data[pPktHdr->l3Offset+4]=len>>8;
		skb->data[pPktHdr->l3Offset+5]=len&0xff;
		pPktHdr->pPppoeLength=(u16*)&skb->data[pPktHdr->l3Offset+4];

		//ppp = IPv4:0x0021, IPv6:0x0057
		if(pPktHdr->tagif&IPV6_TAGIF)
		{
			skb->data[pPktHdr->l3Offset+6]=0x00;
			skb->data[pPktHdr->l3Offset+7]=0x57;
		}
		else
		{
			skb->data[pPktHdr->l3Offset+6]=0x00;
			skb->data[pPktHdr->l3Offset+7]=0x21;
		}

		//reset tagif and L3/4 offset
		if(pPktHdr->l4Offset>0)
			pPktHdr->l4Offset+=8;
		if(pPktHdr->l3Offset>0)
			pPktHdr->l3Offset+=8;
		//DEBUG("add pppoe header l3off=%d l4off=%d len=%d",pPktHdr->l3Offset,pPktHdr->l4Offset,skb->len);
		//dump_packet(skb->data,skb->len,"pppoe_add_after");
		pPktHdr->egressTagif|=PPPOE_TAGIF;
	}

#else	//switch support pppoe tag offload

	rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].idleSecs=0; //update pppoe idleTime

	pPktHdr->egressTagif|=PPPOE_TAGIF;
#endif
}

void _rtk_rg_removePPPoETag_disableHwOffload(rtk_rg_pktHdr_t *pPktHdr, uint8 diableHwOffload)
{
	//remove pppoe header
	int i;

	//update pppoe idleTime
	for(i=0;i<MAX_PPPOE_SW_TABLE_SIZE;i++)
	{
		if(rg_db.pppoe[i].rtk_pppoe.sessionID==pPktHdr->sessionId)
		{
			rg_db.pppoe[i].idleSecs=0;
			break;
		}
	}

	//if we are PPTP or L2TP or DSLITE, we can remove pppoe tag with PPTP or L2TP or DSLITE at one time.
	if(pPktHdr->tagif&PPTP_INNER_TAGIF||pPktHdr->tagif&L2TP_INNER_TAGIF||pPktHdr->tagif&DSLITE_INNER_TAGIF||pPktHdr->tagif&VXLAN_TAGIF)
		return;

	if(diableHwOffload){
		int total_len;
		struct sk_buff *skb;

		skb=pPktHdr->skb;

		if(pPktHdr->tagif&IPV6_TAGIF)
		{
			total_len=pPktHdr->l3Offset+pPktHdr->l3Len;
			skb->data[pPktHdr->l3Offset-2]=0x86;
			skb->data[pPktHdr->l3Offset-1]=0xdd;
		}
		else
		{
			total_len=pPktHdr->l3Offset+pPktHdr->l3Len;
			skb->data[pPktHdr->l3Offset-2]=0x08;
			skb->data[pPktHdr->l3Offset-1]=0x00;
		}

		//DEBUG("%s...total len is %d",pPktHdr->tagif&IPV6_TAGIF?"IPV6":"IPv4",total_len);
		//remove pppoe header here
		//DEBUG("tot_len=%d l3off=%d l3len=%d l4off=%d",total_len,pPktHdr->l3Offset,pPktHdr->l3Len,pPktHdr->l4Offset);
		//dump_packet(skb->data,skb->len,"pppoe_del_before");

		//copy new DA/SA
		for(i=pPktHdr->l3Offset-3;i>=8;i--)
			skb->data[i]=skb->data[i-8];
		//use memcpy to accelerate this copy process
		//memcpy(skb->data+16,skb->data+8,pPktHdr->l3Offset-18);
		//memcpy(skb->data+8,skb->data,8);

		//FIXME for vlan tag
		skb->data+=8;
		skb->len=total_len-8;
		skb_reset_mac_header(skb);

		//dump_packet(skb->data,skb->len,"pppoe_del_after");

		//reset DMAC and SMAC pointer
		pPktHdr->pDmac=&skb->data[0];
		pPktHdr->pSmac=&skb->data[6];

		//reset tagif and L3/4 offset

		// Hairpin NAT must clear egressTagIf for turning on L34 hw checksum offload.
		pPktHdr->egressTagif&=(~PPPOE_TAGIF);

		if(pPktHdr->l4Offset>0)
			pPktHdr->l4Offset-=8;
		if(pPktHdr->l3Offset>0)
			pPktHdr->l3Offset-=8;

		//DEBUG("remove pppoe header skb->len=%d l4_len=%d",skb->len,total_len-pPktHdr->l4Offset);
		//dump_packet(skb->data,skb->len,"pppoe_del");
	}else{
		//switch support pppoe tag offload
		pPktHdr->egressTagif&=(~PPPOE_TAGIF);
	}
}

void _rtk_rg_removePPPoETag(rtk_rg_pktHdr_t *pPktHdr)
{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_XDSL_NEW_HWNAT_DRIVER)
	_rtk_rg_removePPPoETag_disableHwOffload(pPktHdr, TRUE);
#else
	_rtk_rg_removePPPoETag_disableHwOffload(pPktHdr, FALSE);
#endif
}

void _rtk_rg_txPPPoEUpdate(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
#else	//switch support pppoe tag offload
	u32 i;
	u16 sid, total_len, l3Len=0;

	if((pPktHdr->tagif&PPPOE_TAGIF)==0 && (pPktHdr->egressTagif&PPPOE_TAGIF)) //untag => tag
	{
		//add pppoe here
		if(skb_headroom(skb)<8)
		{
			WARNING("no more free skb buff in header room");
		}
		else
		{
			sid=rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].rtk_pppoe.sessionID;
			l3Len = pPktHdr->l3Len;
			if((pPktHdr->egressTagif&PPTP_TAGIF) || (pPktHdr->egressTagif&L2TP_TAGIF))
				l3Len += 40;
			// l3 len stands for the total length of outer L3 header
			DEBUG("before add pppoe header[sid=%d] l3off=%d l4off=%d outer_l3len=%d skb->len=%d", sid, pPktHdr->l3Offset, pPktHdr->l4Offset, l3Len, skb->len);

			skb->data-=8;
			skb->len+=8;
			skb_reset_mac_header(skb);

			//DA,SA
			for(i=0;i<pPktHdr->l3Offset-2;i++)
				skb->data[i]=skb->data[i+8];

			//reset DMAC and SMAC pointer
			//pPktHdr->pDmac=&skb->data[0];
			//pPktHdr->pSmac=&skb->data[6];

			//8864
			skb->data[pPktHdr->l3Offset-2]=0x88;
			skb->data[pPktHdr->l3Offset-1]=0x64;

			//Code
			skb->data[pPktHdr->l3Offset]=0x11;
			skb->data[pPktHdr->l3Offset+1]=0;

			//session id
			skb->data[pPktHdr->l3Offset+2]=sid>>8;
			skb->data[pPktHdr->l3Offset+3]=sid&0xff;

			//len
			skb->data[pPktHdr->l3Offset+4]=(l3Len+2)>>8;
			skb->data[pPktHdr->l3Offset+5]=(l3Len+2)&0xff;
			pPktHdr->pPppoeLength=(u16*)&skb->data[pPktHdr->l3Offset+4];

			//ppp = IPv4:0x0021, IPv6:0x0057
			if(pPktHdr->tagif&IPV6_TAGIF)
			{
				skb->data[pPktHdr->l3Offset+6]=0x00;
				skb->data[pPktHdr->l3Offset+7]=0x57;
			}
			else
			{
				skb->data[pPktHdr->l3Offset+6]=0x00;
				skb->data[pPktHdr->l3Offset+7]=0x21;
			}

			//reset tagif and L3/4 offset
			if(pPktHdr->l4Offset>0)
				pPktHdr->l4Offset+=8;
			if(pPktHdr->l3Offset>0)
				pPktHdr->l3Offset+=8;
		}
	}
	else if((pPktHdr->tagif&PPPOE_TAGIF) && (pPktHdr->egressTagif&PPPOE_TAGIF)==0) //tag => untag
	{
		if(pPktHdr->tagif&IPV6_TAGIF)
		{
			total_len=pPktHdr->l3Offset+pPktHdr->l3Len;
			skb->data[pPktHdr->l3Offset-2]=0x86;
			skb->data[pPktHdr->l3Offset-1]=0xdd;
		}
		else
		{
			total_len=pPktHdr->l3Offset+pPktHdr->l3Len;
			skb->data[pPktHdr->l3Offset-2]=0x08;
			skb->data[pPktHdr->l3Offset-1]=0x00;
		}

		//DEBUG("%s...total len is %d",pPktHdr->tagif&IPV6_TAGIF?"IPV6":"IPv4",total_len);
		//remove pppoe header here
		DEBUG("before remove pppoe header, tot_len=%d l3off=%d l3len=%d l4off=%d",total_len,pPktHdr->l3Offset,pPktHdr->l3Len,pPktHdr->l4Offset);
		//dump_packet(skb->data,skb->len,"pppoe_del_before");

		//copy new DA/SA
		for(i=pPktHdr->l3Offset-3;i>=8;i--)
			skb->data[i]=skb->data[i-8];

		//FIXME for vlan tag
		skb->data+=8;
		skb->len=total_len-8;
		skb_reset_mac_header(skb);

		//dump_packet(skb->data,skb->len,"pppoe_del_after");

		//reset DMAC and SMAC pointer
		//pPktHdr->pDmac=&skb->data[0];
		//pPktHdr->pSmac=&skb->data[6];

		if(pPktHdr->l4Offset>0)
			pPktHdr->l4Offset-=8;
		if(pPktHdr->l3Offset>0)
			pPktHdr->l3Offset-=8;
	}
#endif
}

rtk_rg_fwdEngineReturn_t _rtk_rg_lookupBasedWANForSourceIP(int *pNetIfIdx,ipaddr_t gateway_ipv4_addr)
{
	int l3Idx;

	l3Idx=_rtk_rg_l3lookup(gateway_ipv4_addr);

	if(rg_db.l3[l3Idx].rtk_l3.process==L34_PROCESS_NH && rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.ifIdx!=*pNetIfIdx)
	{
		*pNetIfIdx=rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.ifIdx;
	}
	else if(rg_db.l3[l3Idx].rtk_l3.process==L34_PROCESS_ARP && rg_db.l3[l3Idx].rtk_l3.netifIdx!=*pNetIfIdx)
	{
		*pNetIfIdx=rg_db.l3[l3Idx].rtk_l3.netifIdx;
	}
	else if(rg_db.l3[l3Idx].rtk_l3.process==L34_PROCESS_CPU)
	{
		if(rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].valid &&
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.is_wan &&
			(rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPTP ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_L2TP ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_DSLITE ||
			rg_db.systemGlobal.interfaceInfo[rg_db.l3[l3Idx].rtk_l3.netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE_DSLITE)&&
			rg_db.l3[l3Idx].rtk_l3.netifIdx!=*pNetIfIdx)
		{
			*pNetIfIdx=rg_db.nexthop[rg_db.l3[l3Idx].rtk_l3.nhStart].rtk_nexthop.ifIdx;
		}
		else if(rg_db.l3[l3Idx].rtk_l3.ipAddr > 0 && rg_db.l3[l3Idx].rtk_l3.netifIdx!=*pNetIfIdx)
		{
			*pNetIfIdx=rg_db.l3[l3Idx].rtk_l3.netifIdx;
		}
		else
			return RG_FWDENGINE_RET_ERROR;
	}
	else
		return RG_FWDENGINE_RET_ERROR;

	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_vxlan_wan_check(rtk_rg_pktHdr_t *pPktHdr)
{
	int wanGroupIdx;

	if(pPktHdr->aclPolicyRoute!=FAIL
		&& rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN
		&& rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].storedInfo.wan_intf.vxlan_info.after_dial.vxlan_mode==VXLAN_MODE_L2)
	{
		TRACE("[To PS] ACL policy to L2 VXLAN WAN[%d]", pPktHdr->aclPolicyRoute);
		return RG_FWDENGINE_RET_TO_PS;
	}
	if(_rtk_rg_bindingRuleCheck(pPktHdr, &wanGroupIdx)==RG_FWDENGINE_RET_HIT_BINDING
		&& rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_wanIntfConf->wan_type==RTK_RG_VXLAN
		&& rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.vxlan_info.after_dial.vxlan_mode==VXLAN_MODE_L2)
	{
		TRACE("[To PS] Bind to L2 VXLAN WAN[%d]", rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index);
		return RG_FWDENGINE_RET_TO_PS;
	}
		
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_err_code_t _rtk_rg_addVXLANTag(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb)
{
	int baseIntfIdx, Inner_vlanTag_Off=0, PPPoEHDR_Off=0, vlanTag_Off=0, TUNN_tag_len=50/*L2 header(14)+IPv4 header(20)+UDP(8)+VXLAN(8)*/, extended_headroom=0;
	uint16 sid=0, Inner_vid=0;
	unsigned char *pData, *pInnerData;
	rtk_rg_vxlanClientInfo_t *pVXLANInfo;
	rtk_rg_wanIntfInfo_t *wan_intf;
	char *pSmac, *pDmac;
	ipaddr_t *pIpv4_sip_addr, *pIpv4_dip_addr;
	struct iphdr *pIph;
	struct udphdr *pUdph;
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
#else	//switch support pppoe tag offload
	uint8 addPPPoE=FALSE;
#endif

	pVXLANInfo	= &rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.vxlan_info;
	wan_intf	= &rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf;
	baseIntfIdx = pVXLANInfo->after_dial.vxlan_baseIntf_idx;
	Inner_vid	= (wan_intf->wan_intf_conf.egress_vlan_tag_on) ? wan_intf->wan_intf_conf.egress_vlan_id : 0;
	Inner_vlanTag_Off = (wan_intf->wan_intf_conf.egress_vlan_tag_on) ? 4 : 0;
		
	//Outer DMAC
	pDmac = pVXLANInfo->after_dial.vxlan_remote_ipv4_gatewayMac.octet;
	//Outer DIP
	pIpv4_dip_addr = &pVXLANInfo->after_dial.vxlan_remote_ipv4_addr;	
	if(rg_db.systemGlobal.interfaceInfo[baseIntfIdx].valid!=IF_INVALID_ENTRY && rg_db.systemGlobal.interfaceInfo[baseIntfIdx].storedInfo.is_wan)
	{
		//Outer SMAC
		pSmac = rg_db.systemGlobal.interfaceInfo[baseIntfIdx].storedInfo.wan_intf.wan_intf_conf.gmac.octet;
		//Outer SIP
		pIpv4_sip_addr = &rg_db.systemGlobal.interfaceInfo[baseIntfIdx].p_wanStaticInfo->ip_addr;
		//if base-WAN if PPPoE, we add PPPoE tag, too.
		if(rg_db.systemGlobal.interfaceInfo[baseIntfIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)
		{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
			PPPoEHDR_Off=8;
#else	//switch support pppoe tag offload
			addPPPoE=TRUE;
#endif
			rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[baseIntfIdx].storedInfo.wan_intf.pppoe_idx].idleSecs = 0; //update pppoe idleTime
			sid = rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[baseIntfIdx].storedInfo.wan_intf.pppoe_idx].rtk_pppoe.sessionID;
		}
	}
	else
	{
		TRACE("based WAN[%d] do not exist! drop...", baseIntfIdx);
		return RT_ERR_RG_ENTRY_NOT_EXIST;
	}

	if(pPktHdr->tagif&SVLAN_TAGIF)
		vlanTag_Off += 4;
	if(pPktHdr->tagif&CVLAN_TAGIF)
		vlanTag_Off += 4;

	extended_headroom = TUNN_tag_len + PPPoEHDR_Off + Inner_vlanTag_Off;
	if(skb_cow_head(skb, extended_headroom)<0)
	{
		WARNING("skb head room is not enough %d..return without insert VXLAN tag", extended_headroom);
	}
	else
	{
		//recalculate inner L3&L4 checksum for NAPT&Routing
		if(pPktHdr->tagif&IPV4_TAGIF)
		{
			//Routing also need to recalculate L3 checksum due to ttl
			//if(pPktHdr->l3Modify)
				*pPktHdr->pIpv4Checksum = htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pPktHdr->pIpv4Checksum), pPktHdr->ipv4Sip, pPktHdr->ipv4TTL, pPktHdr->ipProtocol, ntohl(*pPktHdr->pIpv4Sip), *pPktHdr->pIpv4TTL));
			if(pPktHdr->l4Modify && pPktHdr->ipv4FragPacket==0)
			{
				if(pPktHdr->tagif&TCP_TAGIF)
					*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack, ntohs(*pPktHdr->pL4Checksum), pPktHdr->ipv4Sip, pPktHdr->sport, pPktHdr->tcpSeq, pPktHdr->tcpAck, ntohl(*pPktHdr->pIpv4Sip), ntohs(*pPktHdr->pSport), ntohl(*pPktHdr->pTcpSeq), ntohl(*pPktHdr->pTcpAck)));
				else if(pPktHdr->tagif&UDP_TAGIF)
					*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0, ntohs(*pPktHdr->pL4Checksum), pPktHdr->ipv4Sip, pPktHdr->sport, 0, 0, ntohl(*pPktHdr->pIpv4Sip), ntohs(*pPktHdr->pSport), 0, 0));
			}
		}
		
		TRACE("add VXLAN tag");
		pPktHdr->egressTagif |= VXLAN_TAGIF;
		
		pData = skb_push(skb, extended_headroom);
		pInnerData = pData+extended_headroom;
		//Outer DMAC and SMAC
		memcpy(pData, pDmac, ETHER_ADDR_LEN);
		memcpy(pData+ETHER_ADDR_LEN, pSmac, ETHER_ADDR_LEN);
		//reset DMAC and SMAC pointer
		pPktHdr->pDmac = pData;
		pPktHdr->pSmac = pData+ETHER_ADDR_LEN;
		//Outer VLAN, copy from originer inner vlan tag
		if(vlanTag_Off)
			memcpy(pData+(ETHER_ADDR_LEN<<1), pInnerData+(ETHER_ADDR_LEN<<1), vlanTag_Off);
		//Inner DMAC and SMAC
		if(vlanTag_Off!=Inner_vlanTag_Off)
		{
			memmove(pInnerData+vlanTag_Off-Inner_vlanTag_Off, pInnerData, (ETHER_ADDR_LEN<<1));
			pInnerData = pInnerData+vlanTag_Off-Inner_vlanTag_Off;
		}
		//Inner VLAN
		if(Inner_vlanTag_Off)
		{
			*(uint16 *)(pInnerData + (ETHER_ADDR_LEN<<1)) = htons(0x8100);
			*(uint16 *)(pInnerData + (ETHER_ADDR_LEN<<1) + 2) = htons(Inner_vid);
		}
		//Outer IP
		pPktHdr->l3Offset = (ETHER_ADDR_LEN<<1) + vlanTag_Off + PPPoEHDR_Off + 2;
		pIph = (struct iphdr *)(pData + pPktHdr->l3Offset);
		pIph->version	= 4;
		pIph->ihl		= 5;
		pIph->tos		= 0;
		pIph->tot_len	= htons(skb->len - pPktHdr->l3Offset);
		pIph->id		= htons(pVXLANInfo->ipv4_header_identifier++);
		pIph->frag_off	= htons(0);
		pIph->ttl		= 64;
		pIph->protocol	= 17;
		pIph->check 	= htons(0); //Header checksum(caculate by hw)
		pIph->saddr 	= htonl(*pIpv4_sip_addr);
		pIph->daddr 	= htonl(*pIpv4_dip_addr);
		//Outer UDP
		pPktHdr->l4Offset = pPktHdr->l3Offset + sizeof(struct iphdr);
		pUdph = (struct udphdr *)(pData + pPktHdr->l4Offset);
		if((0x1<<pPktHdr->ingressPort)&rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_extraPmsk)
			pUdph->source	= htons(RG_VXLAN_ACC_EPHEMERAL_SPORT);
		else
			pUdph->source	= htons(pVXLANInfo->after_dial.outer_udp_sport);
		pUdph->dest 	= htons(pVXLANInfo->after_dial.outer_udp_dport);
		pUdph->len		= htons(skb->len - pPktHdr->l4Offset);
		pUdph->check	= htons(0); //Header checksum(ingore)
		//Outer VXLAN tag
		*(uint32 *)(pData + pPktHdr->l4Offset + sizeof(struct udphdr)) = htonl(0x8000000);
		*(uint32 *)(pData + pPktHdr->l4Offset + sizeof(struct udphdr) + 4) = htonl(pVXLANInfo->after_dial.vxlan_network_identifier<<8);
		//Outer PPPoE
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
		if(PPPoEHDR_Off)
		{
			uint16 pppoe_payload_len = pIph->tot_len + 2/*EtherType*/;
			//insert PPPoE header
			*(uint32 *)(pData + (ETHER_ADDR_LEN<<1) + vlanTag_Off) = htonl(0x88641100); 	//EtherType, Code
			*(uint16 *)(pData + (ETHER_ADDR_LEN<<1) + vlanTag_Off + 4) = htons(sid&0xffff); //session ID
			*(uint16 *)(pData + (ETHER_ADDR_LEN<<1) + vlanTag_Off + 6) = htons(pppoe_payload_len);	//total Len
			//insert EtherType
			*(uint16 *)(pData + pPktHdr->l3Offset - 2) = htons(0x0021);
			pPktHdr->egressTagif|=PPPOE_TAGIF;
		}
		else
		{
			//insert EtherType
			*(uint16 *)(pData + pPktHdr->l3Offset - 2) = htons(0x0800);
		}
#else	//switch support pppoe tag offload
		//insert EtherType
		*(uint16 *)(pData + pPktHdr->l3Offset - 2) = htons(0x0800);
		if(addPPPoE)
			pPktHdr->egressTagif|=PPPOE_TAGIF;
#endif

		//for egress acl, hw pppoe offload
		pPktHdr->dualHdrNetifIdx = pPktHdr->netifIdx;
		pPktHdr->netifIdx = baseIntfIdx;
		if(0<=pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx && pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx<MAX_LUT_SW_TABLE_SIZE)
		{
			if(rg_db.lut[pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx].valid)
				pPktHdr->dmacL2Idx = pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx;
			else
				WARNING("lut[%d] is invalid", pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx);
		}
		else
			WARNING("vxlan_remote_ipv4_gatewayMac_l2Idx=%d is out of range", pVXLANInfo->vxlan_remote_ipv4_gatewayMac_l2Idx);

		if(pPktHdr->isVXLAN_and_flowMiss==0 && rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_mechanism){
			//update shortcut for upstream hwlookup
			_rtk_rg_vxlanOutNaptShortcutUpdate(pPktHdr);
			if(rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamInfo_prepared==0||rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamInfo_prepared==0){
				rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length=pPktHdr->l4Offset + sizeof(struct udphdr) + 8;
				rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_udp_length_offset=14+20+4;
				rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_ip_length_offset=14+2;
				rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx=pPktHdr->dualHdrNetifIdx;

				bzero(&rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_txInfo,sizeof(rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_txInfo));
				rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_txInfo.opts2.bit.cputag=1;
				rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_txInfo.opts3.bit.dislrn=1;

				memcpy(rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_dmac,pInnerData,4);
				
				if(rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length & 0xf)
					rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_txAddrOffset=16-((rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-RX_OFFSET)-((rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length>>4)<<4));
				else
					rg_db_dynamic_sram.vxlan_acc.vxlan_upstream_txAddrOffset=0;

				if((0x1<<pPktHdr->ingressPort)&rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_extraPmsk){
					memcpy(rg_db_dynamic_sram.vxlan_acc.vxlan_extra_preallocated_outer,pData,rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length);
					//obliterate the outer vlan tag
					if(vlanTag_Off){
						memmove(rg_db_dynamic_sram.vxlan_acc.vxlan_extra_preallocated_outer+(ETHER_ADDR_LEN<<1),rg_db_dynamic_sram.vxlan_acc.vxlan_extra_preallocated_outer+(ETHER_ADDR_LEN<<1)+vlanTag_Off,rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-(ETHER_ADDR_LEN<<1)-vlanTag_Off);
						rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-=vlanTag_Off;
					}
					rg_db_dynamic_sram.vxlan_acc.vxlan_extra_upstreamInfo_prepared=1;
				}else{
					memcpy(rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer,pData,rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length);
					//obliterate the outer vlan tag
					if(vlanTag_Off){
						memmove(rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer+(ETHER_ADDR_LEN<<1),rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer+(ETHER_ADDR_LEN<<1)+vlanTag_Off,rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-(ETHER_ADDR_LEN<<1)-vlanTag_Off);
						rg_db_dynamic_sram.vxlan_acc.vxlan_preallocated_outer_length-=vlanTag_Off;
					}
					rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamInfo_prepared=1;
				}
			}
		}

		//dump_packet(skb->data, skb->len, "Outer packet");
		//dump_packet(skb->data+extended_headroom, skb->len-extended_headroom, "Inner packet");
	}

	return RT_ERR_RG_OK;
}


rtk_rg_err_code_t _rtk_rg_addTunnelTag(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb, rtk_rg_wan_type_t wan_type)
{
	int sid=0,PPPoEHDR_Off=0,vlanTag_Off=0,TUNN_tag_len=40;	//IP(20)+GRE(16)+PPP(4) for PPTP, IP(20)+UDP(8)+L2TP(8)+PPP(4) for L2TP
	unsigned short middle_header_len;
	unsigned char *pData;
	rtk_rg_ipPPTPClientInfo_t *pPPTPInfo;
	rtk_rg_ipL2TPClientInfo_t *pL2TPInfo;
	rtk_rg_wanIntfInfo_t *wan_intf;
	unsigned short *pIpv4_header_identifier;
	ipaddr_t *pIpv4_addr,*pGateway_ipv4_addr;
	unsigned int IP_flag_fragment_TTL_protocol;
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
	int len;
#else	//switch support pppoe tag offload
	uint8 addPPPoE=FALSE;
#endif
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
	int tunnelIntfIdx = pPktHdr?pPktHdr->netifIdx:0;
	int tunnelInfo = 0;
#endif
	if(pPktHdr->tagif&SVLAN_TAGIF)
		vlanTag_Off += 4;
	if(pPktHdr->tagif&CVLAN_TAGIF)
		vlanTag_Off += 4;

	if(skb_cow_head(skb, TUNN_tag_len)<0)
	{
		WARNING("skb head room is not enough..return without insert %s tag",wan_type==RTK_RG_PPTP?"PPTP":"L2TP");
	}
	else
	{
		if(wan_type==RTK_RG_PPTP)
		{
			TRACE("add PPTP tag");
			pPktHdr->egressTagif|=PPTP_TAGIF;
			pPPTPInfo=&rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pptp_info;
			wan_intf=&rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf;
			middle_header_len=pPktHdr->l3Len+4;	//PPP(4)
			if(wan_intf->baseIntf_idx>=0)
				pPktHdr->netifIdx=wan_intf->baseIntf_idx;
			else{
				//20150916LUKE: if we can't decide which base WAN to use, drop the packet!
				if(_rtk_rg_lookupBasedWANForSourceIP(&pPktHdr->netifIdx, pPPTPInfo->before_dial.pptp_ipv4_addr)==RG_FWDENGINE_RET_ERROR){
					TRACE("based WAN do not exist! drop...");
					return RT_ERR_RG_ENTRY_NOT_EXIST;
				}
				wan_intf->baseIntf_idx=pPktHdr->netifIdx;
			}
			pPktHdr->extipIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.extip_idx;
			pIpv4_addr=&pPktHdr->ipv4Sip;
			if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan)
			{
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->napt_enable)
					pIpv4_addr=&rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr;
				//if base-WAN if PPPoE, we add PPPoE tag, too.
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)
				{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
					PPPoEHDR_Off=8;
#else	//switch support pppoe tag offload
					addPPPoE=TRUE;
#endif
					rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].idleSecs=0; //update pppoe idleTime
					sid=rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].rtk_pppoe.sessionID;
				}
			}
			pGateway_ipv4_addr=&pPPTPInfo->before_dial.pptp_ipv4_addr;
			pIpv4_header_identifier=&pPPTPInfo->ipv4_header_identifier;
			IP_flag_fragment_TTL_protocol=0x0000402f;	//protocol = GRE

			pData=skb_push(skb, TUNN_tag_len+PPPoEHDR_Off);
			//copy the mac addresses to the beginning of the new header.
			//since we push the length longer than 2 MACs address, we use memcpy to replace memmove for speed.
			memcpy(skb->data, skb->data + TUNN_tag_len + PPPoEHDR_Off, (VLAN_ETH_ALEN<<1)+vlanTag_Off);
			skb->mac_header -= (TUNN_tag_len+PPPoEHDR_Off);
			//reset DMAC and SMAC pointer
			pPktHdr->pDmac=pData;
			pPktHdr->pSmac=pData+VLAN_ETH_ALEN;
			pData+=PPPoEHDR_Off;
			pData+=vlanTag_Off;

			//insert GRE header
			*(uint32 *)(pData + 34) = htonl(0x3081880b);								//Flags, version, Protocol Type=PPP
			*(uint16 *)(pData + 38) = htons(middle_header_len);							//Payload length
			*(uint16 *)(pData + 40) = htons(pPPTPInfo->after_dial.gateway_callId);		//Peer CallID

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
			// update gre seq. by sync from hw register, hw add 1 automatically after reading.
			rtk_rg_asic_dualHdrInfo_get(FB_DUALHDR_GRESEQ, tunnelIntfIdx, &tunnelInfo);
			pPPTPInfo->gre_header_sequence = tunnelInfo;
			rtk_rg_asic_dualHdrInfo_get(FB_DUALHDR_GREACK, tunnelIntfIdx, &tunnelInfo);
			pPPTPInfo->gre_header_acknowledgment = tunnelInfo;
			*(uint32 *)(pData + 42) = htonl(pPPTPInfo->gre_header_sequence);			//Sequence Num
			*(uint32 *)(pData + 46) = htonl(pPPTPInfo->gre_header_acknowledgment);		//Acknowledgment Num
#else
			*(uint32 *)(pData + 42) = htonl(++pPPTPInfo->gre_header_sequence);			//Sequence Num
			*(uint32 *)(pData + 46) = htonl(pPPTPInfo->gre_header_acknowledgment);		//Acknowledgment Num
#endif
		}
		else	//L2TP
		{
			TRACE("add L2TP tag");
			pPktHdr->egressTagif|=L2TP_TAGIF;
			pL2TPInfo=&rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.l2tp_info;
			wan_intf=&rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf;
			middle_header_len=pPktHdr->l3Len+20;	//UDP(8)+L2TP(8)+PPP(4)
			if(wan_intf->baseIntf_idx>=0)
				pPktHdr->netifIdx=wan_intf->baseIntf_idx;
			else{
				//20150916LUKE: if we can't decide which base WAN to use, drop the packet!
				if(_rtk_rg_lookupBasedWANForSourceIP(&pPktHdr->netifIdx, pL2TPInfo->before_dial.l2tp_ipv4_addr)==RG_FWDENGINE_RET_ERROR){
					TRACE("based WAN do not exist! drop...");
					return RT_ERR_RG_ENTRY_NOT_EXIST;
				}
				wan_intf->baseIntf_idx=pPktHdr->netifIdx;
			}
			pPktHdr->extipIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.extip_idx;
			pIpv4_addr=&pPktHdr->ipv4Sip;
			if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan)
			{
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->napt_enable)
					pIpv4_addr=&rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr;
				//if base-WAN if PPPoE, we add PPPoE tag, too.
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_PPPoE)
				{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
					PPPoEHDR_Off=8;
#else	//switch support pppoe tag offload
					addPPPoE=TRUE;
#endif
					rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].idleSecs=0; //update pppoe idleTime
					sid=rg_db.pppoe[rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_idx].rtk_pppoe.sessionID;
				}
			}
			pGateway_ipv4_addr=&pL2TPInfo->before_dial.l2tp_ipv4_addr;
			pIpv4_header_identifier=&pL2TPInfo->ipv4_header_identifier;
			IP_flag_fragment_TTL_protocol=0x00004011;	//protocol = UDP

			pData=skb_push(skb, TUNN_tag_len+PPPoEHDR_Off);
			//copy the mac addresses to the beginning of the new header.
			//since we push the length longer than 2 MACs address, we use memcpy to replace memmove for speed.
			memcpy(skb->data, skb->data + TUNN_tag_len + PPPoEHDR_Off, (VLAN_ETH_ALEN<<1)+vlanTag_Off);
			skb->mac_header -= (TUNN_tag_len+PPPoEHDR_Off);
			//reset DMAC and SMAC pointer
			pPktHdr->pDmac=pData;
			pPktHdr->pSmac=pData+VLAN_ETH_ALEN;
			pData+=PPPoEHDR_Off;
			pData+=vlanTag_Off;

			//insert UDP header
			*(uint16 *)(pData + 34) = htons(pL2TPInfo->after_dial.outer_port);				//Source port
			*(uint16 *)(pData + 36) = htons(pL2TPInfo->after_dial.gateway_outer_port);		//Destination port
			*(uint16 *)(pData + 38) = htons(middle_header_len);								//Total length
			*(uint16 *)(pData + 40) = htons(0x0);											//Header checksum(caculated by gmac hw)

			//insert L2TP header
			*(uint16 *)(pData + 42) = htons(0x4002);									//Type(0), Length(1), Sequence(0), Offset(0), Priority(0), Version(2)
			*(uint16 *)(pData + 44) = htons(middle_header_len-8);						//Total length
			*(uint16 *)(pData + 46) = htons(pL2TPInfo->after_dial.gateway_tunnelId);	//Peer's Tunnel ID
			*(uint16 *)(pData + 48) = htons(pL2TPInfo->after_dial.gateway_sessionId);	//Peer's Session ID

			//20160628LUKE: calculate inner IP and L4 checksum first, then calculate outer UDP checksum if necessary
			*pPktHdr->pIpv4Checksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pPktHdr->pIpv4Checksum),pPktHdr->ipv4Sip,pPktHdr->ipv4TTL,pPktHdr->ipProtocol,ntohl(*pPktHdr->pIpv4Sip),*pPktHdr->pIpv4TTL));
			if(pPktHdr->ipv4FragPacket==0){
				if(pPktHdr->tagif&TCP_TAGIF)
					*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
				else if(pPktHdr->tagif&UDP_TAGIF)
					*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
			}
		}

		*(uint16 *)(pData + 16) = htons(pPktHdr->l3Len+TUNN_tag_len);		//Total length

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
		// update ipid by sync from hw register, hw add 1 automatically after reading.
		rtk_rg_asic_dualHdrInfo_get(FB_DUALHDR_OUTER_IPV4ID, tunnelIntfIdx, &tunnelInfo);
		*pIpv4_header_identifier = tunnelInfo;
		*(uint16 *)(pData + 18) = htons(*pIpv4_header_identifier);
#else
		// update ipid by pure software counting
		*(uint16 *)(pData + 18) = htons((*pIpv4_header_identifier)++);		//Identification
#endif

		*(uint32 *)(pData + 20) = htonl(IP_flag_fragment_TTL_protocol);		//Flags, Fragment offset, TTL, protocol=GRE
		*(uint16 *)(pData + 24) = htons(0x0);								//Header checksum(caculate by hw)
		*(uint32 *)(pData + 26) = htonl(*pIpv4_addr);						//SIP
		*(uint32 *)(pData + 30) = htonl(*pGateway_ipv4_addr);				//DIP

		//insert PPP header
		*(uint32 *)(pData + 50) = htonl(0xff030021);						//Address, Control, Protocol=IPv4

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
		if(PPPoEHDR_Off)
		{
			len=pPktHdr->l3Len+2+TUNN_tag_len;
			//insert PPPoE header
			*(uint32 *)(pData + 12 - PPPoEHDR_Off) = htonl(0x88641100);						//EtherType, Code
			*(uint16 *)(pData + 16 - PPPoEHDR_Off) = htons(sid&0xffff);						//session ID
			*(uint16 *)(pData + 18 - PPPoEHDR_Off) = htons(len&0xffff);						//total Len
			pPktHdr->pPppoeLength=(uint16 *)(pData + 18 - PPPoEHDR_Off);

			//reset tagif and L3/4 offset
			pPktHdr->l4Offset+=8;
			pPktHdr->l3Offset+=8;
			pPktHdr->egressTagif|=PPPOE_TAGIF;

			//insert IP header
			*(uint32 *)(pData + 12) = htonl(0x00214500);						//EtherType, version, header length, DS field

#if defined(CONFIG_RG_RTL9600_SERIES)
			//20160624LUKE: recalculate outer IP checksum when over PPPoE interface
			*(uint16 *)(pData + 24) = htons(inet_chksum(pData + 14,20));
#if !defined(CONFIG_RG_PPPOE_L2TP_UDP_NOCS)
			//20160628LUKE: recalculate outer UDP checksum when over PPPoE interface
			if(wan_type==RTK_RG_L2TP)
				*(uint16 *)(pData + 40) = htons(inet_chksum_pseudo(pData + 34,middle_header_len,*pIpv4_addr,*pGateway_ipv4_addr,0x11));
#endif
#endif
		}
		else
		{
			//insert IP header
			*(uint32 *)(pData + 12) = htonl(0x08004500);						//EtherType, version, header length, DS field
		}

#else	//switch support pppoe tag offload

		//insert IP header
		*(uint32 *)(pData + 12) = htonl(0x08004500);							//EtherType, version, header length, DS field
		if(addPPPoE)
			pPktHdr->egressTagif|=PPPOE_TAGIF;

#endif


		//pPktHdr->l3Offset += TUNN_tag_len;	//offset to outter IP header
		// pPktHdr->l3Len is inner l3 length
		pPktHdr->l4Offset += TUNN_tag_len;	//offset to inner Layer4 header
		// only for PPTP/L2TP
		pPktHdr->outer_l3Offset = (ETHER_ADDR_LEN<<1)+vlanTag_Off+PPPoEHDR_Off+2;
		pPktHdr->outer_ipv4HeaderLen = 20;
	}

	return RT_ERR_RG_OK;
}

void _rtk_rg_addDSLITETag(rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb, rtk_rg_wan_type_t wan_type)
{
	int TUNN_tag_len=40,vlanTag_Off=0;
	unsigned char *pData;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else
	uint32 ihl_tc_flow;
#endif
	if(pPktHdr->tagif&SVLAN_TAGIF)
		vlanTag_Off += 4;
	if(pPktHdr->tagif&CVLAN_TAGIF)
		vlanTag_Off += 4;

	if(skb_cow_head(skb, TUNN_tag_len)<0)
	{
		WARNING("skb head room is not enough..return without insert DSLITE tag");
	}
	else
	{
		pData=skb_push(skb, TUNN_tag_len);
		//copy the mac addresses to the beginning of the new header.
		//since we push the length longer than 2 MACs address, we use memcpy to replace memmove for speed.
		memcpy(skb->data, skb->data + TUNN_tag_len, (VLAN_ETH_ALEN<<1)+vlanTag_Off);
		skb->mac_header -= TUNN_tag_len;

		//reset DMAC and SMAC pointer
		pPktHdr->pDmac=pData;
		pPktHdr->pSmac=pData+VLAN_ETH_ALEN;
		pData+=vlanTag_Off;

		//insert IPv6 header
#if defined(CONFIG_RG_RTL9600_SERIES)
		*(uint32 *)(pData + 12) = htonl(0x86dd6000);						//EtherType, version, traffic class, Flow label upper 4bits
		*(uint16 *)(pData + 16) = htons(0x0000);							//Flow label 16bits
		*(uint16 *)(pData + 18) = htons(pPktHdr->l3Len);					//Payload length
		*(uint16 *)(pData + 20) = htons(0x04ff);							//Next header, Hop limit

		if(wan_type==RTK_RG_DSLITE)
		{
			memcpy(pData + 22,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipB4.ipv6_addr,IPV6_ADDR_LEN);
			memcpy(pData + 22 + IPV6_ADDR_LEN,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN);
		}
		else
		{
			memcpy(pData + 22,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipB4.ipv6_addr,IPV6_ADDR_LEN);
			memcpy(pData + 22 + IPV6_ADDR_LEN,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN);
		}
#else
		if(wan_type==RTK_RG_DSLITE)
		{
			*(uint16 *)(pData + 12) = htons(RG_IPV6_ETHERTYPE);
			if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.tcOpt==RTK_L34_DSLITE_TC_OPT_ASSIGN)
				ihl_tc_flow=((rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.tc)|0x600)<<20;
			else
				ihl_tc_flow=((pPktHdr->tos)|0x600)<<20;
			ihl_tc_flow|=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.flowLabel;
			*(uint32 *)(pData + 14) = htonl(ihl_tc_flow);
			*(uint16 *)(pData + 18) = htons(pPktHdr->l3Len);					//Payload length
			*(uint16 *)(pData + 20) = htons(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.hopLimit|0x0400);	//Next header, Hop limit
			memcpy(pData + 22,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipB4.ipv6_addr,IPV6_ADDR_LEN);
			memcpy(pData + 22 + IPV6_ADDR_LEN,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.dslite_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN);
		}
		else //if(wan_type==RTK_RG_PPPoE_DSLITE)
		{
			*(uint16 *)(pData + 12) = htons(RG_IPV6_ETHERTYPE);
			if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.tcOpt==RTK_L34_DSLITE_TC_OPT_ASSIGN)
				ihl_tc_flow=((rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.tc)|0x600)<<20;
			else
				ihl_tc_flow=((pPktHdr->tos)|0x600)<<20;
			ihl_tc_flow|=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.flowLabel;
			*(uint32 *)(pData + 14) = htonl(ihl_tc_flow);
			*(uint16 *)(pData + 18) = htons(pPktHdr->l3Len);					//Payload length
			*(uint16 *)(pData + 20) = htons(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.hopLimit|0x0400);	//Next header, Hop limit
			memcpy(pData + 22,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipB4.ipv6_addr,IPV6_ADDR_LEN);
			memcpy(pData + 22 + IPV6_ADDR_LEN,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.pppoe_dslite_info.after_dial.dslite_hw_info.rtk_dslite.ipAftr.ipv6_addr,IPV6_ADDR_LEN);
		}
#endif
		//20170425LUKE: complete IPv6 fields in pktHdr.
		//pPktHdr->pTos=(uint8 *)(pData + 14);//since we care inner IPv4's tos, we didn't overwrite it here!
		pPktHdr->pIPv6HopLimit=(uint8 *)(pData + 21);
		pPktHdr->pIpv6Sip=(uint8 *)(pData + 22);
		pPktHdr->pIpv6Dip=(uint8 *)(pData + 22 + IPV6_ADDR_LEN);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->ipv6Sip_hash=_rtk_rg_sw_flowHashIPv6SrcAddr_get(pPktHdr->pIpv6Sip);
		pPktHdr->ipv6Dip_hash=_rtk_rg_sw_flowHashIPv6DstAddr_get(pPktHdr->pIpv6Dip);
#endif
		pPktHdr->ipv6PayloadLen=pPktHdr->l3Len;
		pPktHdr->l3Len+=TUNN_tag_len;
		pPktHdr->l4Offset+=TUNN_tag_len;
		pPktHdr->egressTagif|=DSLITE_TAGIF;
		pPktHdr->tagif|=IPV6_TAGIF;
	}
}

__IRAM_FWDENG
void _rtk_rg_removeTunnelTag(rtk_rg_pktHdr_t *pPktHdr)
{
	if(pPktHdr->tagif&VXLAN_TAGIF)
	{
		unsigned int i, tmpOffset = pPktHdr->pVxlan_inner_data - pPktHdr->skb->data;

		DEBUG("VXLAN tmpOffset=%d", tmpOffset);

		pPktHdr->skb->data = pPktHdr->pVxlan_inner_data;
		pPktHdr->skb->len -= tmpOffset;
		skb_reset_mac_header(pPktHdr->skb);
		//remove pppoe tag
		if(pPktHdr->egressTagif&PPPOE_TAGIF)
		{
			//update pppoe idleTime
			for(i=0;i<MAX_PPPOE_SW_TABLE_SIZE;i++)
			{
				if(rg_db.pppoe[i].rtk_pppoe.sessionID==pPktHdr->sessionId)
				{
					rg_db.pppoe[i].idleSecs=0;
					break;
				}
			}
	 		pPktHdr->egressTagif &= (~PPPOE_TAGIF);
		}
	}
	else
	{
		unsigned int tmpOffset,vlanOffset=0;
		unsigned int pppoeOffset=0; // 0: remove pppoe tag, 8: does not remove pppoe tag
		int i;

		//remove pppoe tag
		if(pPktHdr->egressTagif&PPPOE_TAGIF)
		{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_G3_SERIES)
			pppoeOffset=0;	//remove pppoe tag
#else	//switch support pppoe tag offload
			pppoeOffset=8;	//does not remove pppoe tag
#endif
			//update pppoe idleTime
			for(i=0;i<MAX_PPPOE_SW_TABLE_SIZE;i++)
			{
				if(rg_db.pppoe[i].rtk_pppoe.sessionID==pPktHdr->sessionId)
				{
					rg_db.pppoe[i].idleSecs=0;
					break;
				}
			}
	 		pPktHdr->egressTagif&=(~PPPOE_TAGIF);
		}

		//dump_packet(skb->data,skb->len,"before remove packet");
		//move the mac addresses to the beginning of the new offset
		if(pPktHdr->tagif&CVLAN_TAGIF) vlanOffset+=4;
		if(pPktHdr->tagif&SVLAN_TAGIF) vlanOffset+=4;
		tmpOffset=pPktHdr->l3Offset - (VLAN_ETH_ALEN<<1) - 2 - vlanOffset - pppoeOffset;
		//since the length we remove must longer than 2 MACs address, we use memcpy to replace memmove for speed.
		memcpy(pPktHdr->skb->data + tmpOffset, pPktHdr->skb->data, (VLAN_ETH_ALEN<<1)+vlanOffset+pppoeOffset);
		pPktHdr->skb->data+=tmpOffset;
		pPktHdr->skb->len-=tmpOffset;
		skb_reset_mac_header(pPktHdr->skb);
		if(pPktHdr->l4Offset>0)
			pPktHdr->l4Offset-=tmpOffset;
		if(pPktHdr->l3Offset>0)
			pPktHdr->l3Offset-=tmpOffset;
		if(pPktHdr->tagif&IPV4_TAGIF)
			*(unsigned short *)(pPktHdr->skb->data+(VLAN_ETH_ALEN<<1)+vlanOffset+pppoeOffset)=(pppoeOffset)?htons(RG_IPV4_PPP_PROTOCOL):htons(RG_IPV4_ETHERTYPE);
		else
			*(unsigned short *)(pPktHdr->skb->data+(VLAN_ETH_ALEN<<1)+vlanOffset+pppoeOffset)=(pppoeOffset)?htons(RG_IPV6_PPP_PROTOCOL):htons(RG_IPV6_ETHERTYPE);
		//reset DMAC and SMAC pointer
	 	pPktHdr->pDmac=&(pPktHdr->skb->data[0]);
	 	pPktHdr->pSmac=&(pPktHdr->skb->data[6]);


	// 	DEBUG("DA %x-%x-%x-%x-%x-%x  SA %x-%x-%x-%x-%x-%x",
	// 		pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5],
	// 		pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5]);

	//	dump_packet(pPktHdr->skb->data,pPktHdr->skb->len,"after remove packet");
	}
}

void _rtk_rg_TCP_MSS_clamping_by_MTU(rtk_rg_pktHdr_t *pPktHdr)
{
	if(pPktHdr->srcNetifIdx==FAIL || pPktHdr->netifIdx==FAIL)
	{
		TRACE("srcNetifIdx is %d, netifIdx is %d...return",pPktHdr->srcNetifIdx,pPktHdr->netifIdx);
		return;
	}

	if(pPktHdr->tagif&(IPV4_TAGIF|IPV6_TAGIF))
	{
		int offset=40;
		u16 netOrderOrgMss;
		u32 netifMss,cacheMss=DEFAULT_MSSCACHE_VALUE;

		if(pPktHdr->tagif&IPV6_TAGIF)
		{
			offset+=20;
			cacheMss=DEFAULT_V6MSSCACHE_VALUE;
		}

		netOrderOrgMss=ntohs(*pPktHdr->pMssLength);

		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan)
		{
#if defined(CONFIG_RG_WAN_MSS_CACHE)
			if(pPktHdr->tagif&IPV4_TAGIF)
				cacheMss=_rtk_rg_mssCache_search(pPktHdr->netifIdx, pPktHdr->ipv4Dip);
			else
				cacheMss=_rtk_rg_v6mssCache_search(pPktHdr->netifIdx, pPktHdr->pIpv6Dip);
#endif
			netifMss=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->mtu-offset;
			if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].storedInfo.is_wan)
			{
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_wanStaticInfo->mtu <
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->mtu)
					netifMss=rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_wanStaticInfo->mtu-offset;
			}
			else
			{
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_lanIntfConf->mtu <
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->mtu)
					netifMss=rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_lanIntfConf->mtu-offset;
			}
		}
		else
		{
			netifMss=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_lanIntfConf->mtu-offset;
			if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].storedInfo.is_wan)
			{
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_wanStaticInfo->mtu <
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_lanIntfConf->mtu)
					netifMss=rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_wanStaticInfo->mtu-offset;
			}
			else
			{
				if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_lanIntfConf->mtu <
					rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_lanIntfConf->mtu)
					netifMss=rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].p_lanIntfConf->mtu-offset;
			}
		}

		if(cacheMss>netifMss)cacheMss=netifMss;

		//20181114LUKE: we should compare ingress and egress interface MTU and choose smaller one for clamping.
		//20160923LUKE: if we receive MSS smaller than MTU minus offset, we would bypass this.
		if(netOrderOrgMss>cacheMss)
		{
			*pPktHdr->pMssLength=htons(cacheMss);
			//20160331LUKE: keep checksum by sw offload in case we add dual header after MSS clamping
			*pPktHdr->pL4Checksum=htons(_rtk_rg_fwdengine_L4checksumUpdateForMss(ntohs(*pPktHdr->pL4Checksum),netOrderOrgMss,cacheMss));

			//20161125LUKE: Since we need to update other fields before send packet to WLAN,
			//we update original checksum here for PRETENDING WE ARE NOT UPDATE L4 CHECKSUM YET!!!
			pPktHdr->l4Checksum=ntohs(*pPktHdr->pL4Checksum);

			TRACE("modify MSS from %d to %d, update L4 chksum(BOTH ORIGINAL AND POINTER)\n",netOrderOrgMss,cacheMss);
		}
#if defined(CONFIG_RG_WAN_MSS_CACHE)
		//20181114LUKE: store MSS for src IP.
		//20170727LUKE: store the inbound MSS for the remote IP
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->srcNetifIdx].storedInfo.is_wan)
		{
			if(pPktHdr->tagif&IPV4_TAGIF)
				_rtk_rg_mssCache_add(pPktHdr->srcNetifIdx, pPktHdr->ipv4Sip, ntohs(*pPktHdr->pMssLength));
			else
				_rtk_rg_v6mssCache_add(pPktHdr->srcNetifIdx, pPktHdr->pIpv6Sip, ntohs(*pPktHdr->pMssLength));
		}
#endif
	}
}

__IRAM_FWDENG
rtk_rg_err_code_t _rtk_rg_fwdEngine_shortCutNaptPacketModify(int direct, int naptIdx, rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb,int l3Modify,int l4Modify)
{
	//DEBUG("direct is %s",direct==NAPT_DIRECTION_OUTBOUND?"OUTBOUND":"INBOUND");

	if(pPktHdr->dmacL2Idx==rg_db.systemGlobal.defaultTrapLUTIdx)
	{
		TRACE("[Drop] dmacL2Idx is dummyIdx(mac=0:0:0:0:0:0), drop.");
		return RT_ERR_RG_DUMMY_DMAC_IDX;
	}

	//TTL minus one
	if(pPktHdr->pIpv4TTL!=NULL)
	{
		if(pPktHdr->isHairpinNat==0 || direct==NAPT_DIRECTION_INBOUND)
			*pPktHdr->pIpv4TTL-=1;
	}
	else
	{
		dump_packet(skb->data,skb->len,"NULL packet..");
		return RT_ERR_RG_DROP;
	}



	if((direct==NAPT_DIRECTION_OUTBOUND)||(direct==NAPT_DIRECTION_ROUTING))
	{

		if(pPktHdr->shortcutStatus!=RG_SC_MATCH){
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				rtk_rg_fwdEngineReturn_t aclRet=RG_FWDENGINE_RET_DIRECT_TX;
				//call to ACL
				assert_ok(_rtk_rg_egressACLPatternCheck(pPktHdr->fwdDecision,naptIdx,pPktHdr,skb,pPktHdr->l3Modify,pPktHdr->l4Modify,RG_ACL_EGRESS_BYPASS_PORT_ESPECIAL_TO_PS_CHECK));
				aclRet = _rtk_rg_egressACLAction(pPktHdr->fwdDecision,pPktHdr);
				//just care Permit/Trap_to_PS, due to pattern limit!
				if(aclRet==RG_FWDENGINE_RET_TO_PS)
				{
					//roll-back *pPktHdr->pIpv4TTL
					if(pPktHdr->pIpv4TTL!=NULL)
					{
						*pPktHdr->pIpv4TTL=pPktHdr->ipv4TTL;
					}

					TRACE("[To PS] ret: RG_FWDENGINE_RET_TO_PS");
					return RT_ERR_RG_ACL_TRAP_TO_PS;
				}
#endif



			// calling ALG_before after the _rtk_rg_egressACLPatternCheck() to avoid packet modified
			if(l3Modify && l4Modify)
			{
				//Alg pre function check
				if(_rtk_rg_algForward(direct,0,skb,pPktHdr)==RG_FWDENGINE_ALG_RET_DROP)
				{
					TRACE("[Drop] Drop by PRE-ALG");
					return RG_FWDENGINE_RET_DROP;
				}
			}
		}



		// fool-proofing & debug
		if(l3Modify || l4Modify) assert(naptIdx<MAX_NAPT_OUT_SW_TABLE_SIZE);

		//update shortcut before packet modification
#ifdef CONFIG_ROME_NAPT_SHORTCUT
		if(pPktHdr->shortcutStatus==RG_SC_NEED_UPDATE)
		{
			//if Routing, l3modify, l4modify, and naptIdx are all zero
			//otherwise NAPT will set to one, respectively
			_rtk_rg_naptShortcutUpdate(pPktHdr,direct,naptIdx,(l3Modify&l4Modify),0);
		}
#endif

		/*
		FIXME("l2idx=%d mac=%02x:%02x:%02x:%02x:%02x:%02x\n",l2Idx,rg_db.mac[l2Idx].macAddr.octet[0]
		,rg_db.mac[l2Idx].macAddr.octet[1],rg_db.mac[l2Idx].macAddr.octet[2]
		,rg_db.mac[l2Idx].macAddr.octet[3],rg_db.mac[l2Idx].macAddr.octet[4]
		,rg_db.mac[l2Idx].macAddr.octet[5]);
		*/

		// fill DA
		if(pPktHdr->dmacL2Idx<0 || pPktHdr->dmacL2Idx>=MAX_LUT_SW_TABLE_SIZE){
			TRACE("[DROP] invalid dmacL2Idx(%d)!",pPktHdr->dmacL2Idx);
			return RG_FWDENGINE_RET_DROP;
		}
		memcpy(pPktHdr->pDmac,rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN);

		//fill SIP
		if(l3Modify)
		{
			*pPktHdr->pIpv4Sip=htonl(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr);
#ifdef CONFIG_APOLLO_MODEL
			TRACE("modify SIP to %d.%d.%d.%d",(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr>>24)&0xff,(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr>>16)&0xff,(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr>>8)&0xff,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr&0xff);
#else
			TRACE("modify SIP to %d.%d.%d.%d",(ntohl(*pPktHdr->pIpv4Sip)>>24)&0xff,(ntohl(*pPktHdr->pIpv4Sip)>>16)&0xff,(ntohl(*pPktHdr->pIpv4Sip)>>8)&0xff,ntohl(*pPktHdr->pIpv4Sip)&0xff);
#endif
		}

		//fill SPORT
		if(l4Modify)
		{
			*pPktHdr->pSport=htons(rg_db.naptOut[naptIdx].extPort);
#ifdef CONFIG_APOLLO_MODEL
			TRACE("modify SPORT to %d",rg_db.naptOut[naptIdx].extPort);
#else
			TRACE("modify SPORT to %d",ntohs(*pPktHdr->pSport));
#endif
		}

		assert(pPktHdr->netifIdx<MAX_NETIF_SW_TABLE_SIZE);

		//Alg post function check
		if((pPktHdr->shortcutStatus!=RG_SC_MATCH) && l3Modify && l4Modify)
		{
			if(_rtk_rg_algForward(direct,1,skb,pPktHdr)==RG_FWDENGINE_ALG_RET_DROP)
			{
				TRACE("[Drop] Drop by POST-ALG");
				return RG_FWDENGINE_RET_DROP;
			}
		}
		
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan==1)
		{
			//20200717LUKE: for Hairpin NAT, we should not add tunnel tag since we will going to LAN immediately.
			if(pPktHdr->isHairpinNat==0){
				rtk_rg_wan_type_t wan_type=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type;
				if(wan_type==RTK_RG_DSLITE||wan_type==RTK_RG_PPPoE_DSLITE)
				{
					_rtk_rg_addDSLITETag(pPktHdr,skb,wan_type);
				}
				else if(wan_type==RTK_RG_PPTP||wan_type==RTK_RG_L2TP)
				{
					//add pptp or l2tp header
					if(_rtk_rg_addTunnelTag(pPktHdr,skb,wan_type)==RT_ERR_RG_ENTRY_NOT_EXIST)
					{
						TRACE("[Drop] Fail to add pptp/l2tp tag");
						return RG_FWDENGINE_RET_DROP;
					}
				}

				switch(wan_type)
				{
#if defined(CONFIG_RG_RTL9600_SERIES)
					case RTK_RG_PPPoE:
					case RTK_RG_PPPoE_DSLITE:
						//add pppoe header
						_rtk_rg_addPPPoETag(pPktHdr,skb,l3Modify,l4Modify);
#if defined(CONFIG_GPON_FEATURE)
						if(rg_db.systemGlobal.gpon_pppoe_status==GPON_PPPOE_MODE_SW_OFFLOAD)
							break;
#endif
						//20160331LUKE: checksum by sw offload
#else	//gmac support checksum offload with pppoe tag
					case RTK_RG_PPPoE:
						//add pppoe header
						_rtk_rg_addPPPoETag(pPktHdr,skb,l3Modify,l4Modify);
						break;
					case RTK_RG_PPPoE_DSLITE:
						//add pppoe header
						_rtk_rg_addPPPoETag(pPktHdr,skb,l3Modify,l4Modify);
#endif
					case RTK_RG_PPTP:
					//20160629LUKE: for L2TP, we calculate these checksum inside of _rtk_rg_addTunnelTag!
					//case RTK_RG_L2TP:
					case RTK_RG_DSLITE:
						//FIXME: should we recaculate IP checksum for the new IP header in PPTP or L2TP??YES, inner checksum should update here
						//fragment checksum re-cal because GMAC cannot offload PPPoE packets
						//if(pPktHdr->ipv4FragPacket)
						// 20130731: normal PPPoE can't checksum offload. because directTX turn on L34_KEEP.
						//if(pPktHdr->isHairpinNat==0)
						{
							if(pPktHdr->ipv4Checksum==ntohs(*pPktHdr->pIpv4Checksum))*pPktHdr->pIpv4Checksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pPktHdr->pIpv4Checksum),pPktHdr->ipv4Sip,pPktHdr->ipv4TTL,pPktHdr->ipProtocol,ntohl(*pPktHdr->pIpv4Sip),*pPktHdr->pIpv4TTL));
							//20140625LUKE:when packet are fragemented, we should not re-caculate checksum here!!
							if(pPktHdr->ipv4FragPacket==0 && pPktHdr->pL4Checksum && (pPktHdr->l4Checksum==ntohs(*pPktHdr->pL4Checksum))){
								if(pPktHdr->tagif&TCP_TAGIF)
									*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
								else if(pPktHdr->tagif&UDP_TAGIF)
									*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
							}
						}
						break;
					default:
						break;
				}
			}
		}
		else	//to LAN
		{
			//20170309LUKE: if we are routing to LAN with PPPoE tag, we should remove it.
			if(pPktHdr->egressTagif&PPPOE_TAGIF)
				_rtk_rg_removePPPoETag(pPktHdr);
		}

		if(pPktHdr->isHairpinNat==1)
		{
			if(pPktHdr->ipv4Checksum==ntohs(*pPktHdr->pIpv4Checksum))*pPktHdr->pIpv4Checksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pPktHdr->pIpv4Checksum),pPktHdr->ipv4Sip,0,pPktHdr->ipProtocol,ntohl(*pPktHdr->pIpv4Sip),0));
			if(pPktHdr->ipv4FragPacket==0 && pPktHdr->pL4Checksum && (pPktHdr->l4Checksum==ntohs(*pPktHdr->pL4Checksum))){
				if(pPktHdr->tagif&TCP_TAGIF)
					*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
				else if(pPktHdr->tagif&UDP_TAGIF)
					*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
			}
		}

		//fill SA
		memcpy(pPktHdr->pSmac,rg_db.netif[pPktHdr->netifIdx].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN);

		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan==1
			&& rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_VXLAN)
		{
			if(_rtk_rg_addVXLANTag(pPktHdr, skb)==RT_ERR_RG_ENTRY_NOT_EXIST)
			{
				TRACE("[Drop] Fail to add vxlan tag");
				return RG_FWDENGINE_RET_DROP;
			}
		}
		
		if((pPktHdr->overMTU==1)&&(pPktHdr->ipv4FragPacket==0)&&(pPktHdr->pL4Checksum)&&(pPktHdr->l4Checksum==ntohs(*pPktHdr->pL4Checksum))
#if defined(CONFIG_RG_RTL9600_SERIES)
			//20160331LUKE: checksum by sw offload
			&&((pPktHdr->egressTagif&PPPOE_TAGIF)==0)&&((pPktHdr->egressTagif&PPTP_TAGIF)==0)&&((pPktHdr->egressTagif&L2TP_TAGIF)==0)&&((pPktHdr->egressTagif&DSLITE_TAGIF)==0)&&((pPktHdr->egressTagif&VXLAN_TAGIF)==0)
#endif
			){
			if(pPktHdr->tagif&TCP_TAGIF)
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
			else if(pPktHdr->tagif&UDP_TAGIF)
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
			TRACE("OverMTU checksum calculate by software ID=0x%x checksum==>0x%04x!",pPktHdr->ipv4Identification,ntohs(*pPktHdr->pL4Checksum) );
		}//else{
			// PPPoE, PPTP, L2TP L4 checksum already calculated when add tag
			// none-overMTU IPoE L4 checksum calculated by HW
			// fragmented packet checksum calculated in Layer34 forward if needed
		//}
	}else{ //INBOUND
		//ipaddr_t originalDIP;
		//int16 originalDPort;
		int32 ret;
		// fool-proofing & debug
		if(l3Modify || l4Modify) assert(naptIdx<MAX_NAPT_IN_SW_TABLE_SIZE);

		//originalDIP=pPktHdr->ipv4Dip;
		//originalDPort=pPktHdr->dport;

		//fill DIP
		if(l3Modify){
			*pPktHdr->pIpv4Dip=htonl(rg_db.naptIn[naptIdx].rtk_naptIn.intIp);
#ifdef CONFIG_APOLLO_MODEL
			TRACE("modify DIP to %d.%d.%d.%d",(rg_db.naptIn[naptIdx].rtk_naptIn.intIp>>24)&0xff,(rg_db.naptIn[naptIdx].rtk_naptIn.intIp>>16)&0xff,(rg_db.naptIn[naptIdx].rtk_naptIn.intIp>>8)&0xff,rg_db.naptIn[naptIdx].rtk_naptIn.intIp&0xff);
#else
			TRACE("modify DIP to %d.%d.%d.%d [by NAPT inIdx=%d]",(ntohl(*pPktHdr->pIpv4Dip)>>24)&0xff,(ntohl(*pPktHdr->pIpv4Dip)>>16)&0xff,(ntohl(*pPktHdr->pIpv4Dip)>>8)&0xff,ntohl(*pPktHdr->pIpv4Dip)&0xff,naptIdx);
#endif

			//Decide DMACL2Idx using New DIP (*pPktHdr->pIpv4Dip)
		}
		//else
		//{
			//Decide DMACL2Idx using Original DIP (*pPktHdr->pIpv4Dip)
		//}
		if(pPktHdr->shortcutStatus!=RG_SC_MATCH){
			rtk_rg_sipDipClassification_t sipdipClass=SIP_DIP_CLASS_NAPTR;
			ret = _rtk_rg_routingDecisionTablesLookup(pPktHdr,&sipdipClass);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)
			{
				{
					TRACE("arp is not found");
					return RT_ERR_RG_ARP_NOT_FOUND;
				}
			}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			{
				rtk_rg_fwdEngineReturn_t aclRet=RG_FWDENGINE_RET_DIRECT_TX;
				//call to ACL
				assert_ok(_rtk_rg_egressACLPatternCheck(pPktHdr->fwdDecision,naptIdx,pPktHdr,skb,pPktHdr->l3Modify,pPktHdr->l4Modify,RG_ACL_EGRESS_BYPASS_PORT_ESPECIAL_TO_PS_CHECK));
				aclRet = _rtk_rg_egressACLAction(pPktHdr->fwdDecision,pPktHdr);

				//just care Permit/Trap_to_PS, due to pattern limit!
				if(aclRet==RG_FWDENGINE_RET_TO_PS)
				{
					//roll-back *pPktHdr->pIpv4Dip
					*pPktHdr->pIpv4Dip = htonl(pPktHdr->ipv4Dip);

					//roll-back *pPktHdr->pIpv4TTL
					if(pPktHdr->pIpv4TTL!=NULL)
					{
						*pPktHdr->pIpv4TTL=pPktHdr->ipv4TTL;
					}

					TRACE("[To PS] ret: RG_FWDENGINE_RET_TO_PS");
					return RT_ERR_RG_ACL_TRAP_TO_PS;
				}
			}
#endif

			// calling ALG_before after the _rtk_rg_egressACLPatternCheck() to avoid packet modified
			if(l3Modify && l4Modify)
			{
				//Alg pre function check
				if(_rtk_rg_algForward(direct,0,skb,pPktHdr)==RG_FWDENGINE_ALG_RET_DROP)
				{
					TRACE("[Drop] Drop by PRE-ALG");
					return RG_FWDENGINE_RET_DROP;
				}
			}
		}


#ifdef CONFIG_ROME_NAPT_SHORTCUT
		if(pPktHdr->shortcutStatus==RG_SC_NEED_UPDATE)	//for UDP inbound packet
			_rtk_rg_naptShortcutUpdate(pPktHdr,direct,naptIdx,1,0);
#endif

		//fill DPORT
		if(l4Modify){
			*pPktHdr->pDport=htons(rg_db.naptIn[naptIdx].rtk_naptIn.intPort);
#ifdef CONFIG_APOLLO_MODEL
			TRACE("modify DPORT to %d",rg_db.naptIn[naptIdx].rtk_naptIn.intPort);
#else
			TRACE("modify DPORT to %d",ntohs(*pPktHdr->pDport));
#endif
		}


		//fill DA
		//assert_ok(rtk_rg_macEntry_find(&mac,&l2Idx));
		//memcpy(pPktHdr->pDmac,mac.mac.octet,6);

		//Check DMAC
#if 0
		{
			/* For inbound connection, the very first SYN packet will be forwarding to internal host but the MAC of host may be unknownd. */
			int zeroDA[6] = {0};
			int result = 0;
			result = memcmp(&zeroDA[0],pPktHdr->pDmac,ETHER_ADDR_LEN);

			//DA is not valid MAC address.
			if(result==0)
			{
				DEBUG("MAC miss....send arp packet...\n");
				_rtk_rg_fwdengine_handleArpMiss(pPktHdr);
				return RT_ERR_RG_L2_ENTRY_NOT_FOUND;
			}
		}
#else
		if(pPktHdr->dmacL2Idx<0 || pPktHdr->dmacL2Idx>=MAX_LUT_SW_TABLE_SIZE || rg_db.lut[pPktHdr->dmacL2Idx].valid==0){
			TRACE("DMAC miss...send ARP request!");
			_rtk_rg_fwdengine_handleArpMiss(pPktHdr);
			return RT_ERR_RG_L2_ENTRY_NOT_FOUND;
		}else
			memcpy(pPktHdr->pDmac,rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN);
#endif
		//fill SA
		assert(pPktHdr->netifIdx<MAX_NETIF_SW_TABLE_SIZE);
		memcpy(pPktHdr->pSmac,rg_db.netif[pPktHdr->netifIdx].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN);

		if(pPktHdr->egressTagif&PPPOE_TAGIF)
			_rtk_rg_removePPPoETag(pPktHdr);

		//20141209LUKE: fix inbound overMTU didn't recalculate checksum problem
		if((pPktHdr->overMTU==1)&&(pPktHdr->ipv4FragPacket==0))
		{
			if(pPktHdr->tagif&TCP_TAGIF)
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
			else if(pPktHdr->tagif&UDP_TAGIF)
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,0,0,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),0,0));
			TRACE("OverMTU checksum calculate by software ID=0x%x checksum==>0x%04x!",pPktHdr->ipv4Identification,ntohs(*pPktHdr->pL4Checksum));
		}
#if defined(CONFIG_RG_WAN_MSS_CACHE_FRAGMENT_DEGENERACY)
		//20190925LUKE: check MSS cache for matching SIP, change its MSS to predefined value.
		if(pPktHdr->ipv4FragPacket && pPktHdr->ipProtocol==RG_IP_PROTO_TCP){
			_rtk_rg_mssCache_update(pPktHdr->srcNetifIdx, pPktHdr->ipv4Sip, CONFIG_RG_WAN_MSS_CACHE_FRAGMENT_DEGENERACY);
		}
#endif

		//Alg post function check
		if((pPktHdr->shortcutStatus!=RG_SC_MATCH) && l3Modify && l4Modify)
		{
			if(_rtk_rg_algForward(direct,1,skb,pPktHdr)==RG_FWDENGINE_ALG_RET_DROP)
			{
				TRACE("[Drop] Drop by POST-ALG");
				return RG_FWDENGINE_RET_DROP;
			}
		}
	}

	if(rg_db.systemGlobal.fwdStatistic && !(pPktHdr->isHairpinNat && direct==NAPT_DIRECTION_OUTBOUND)){
		if(l3Modify)
			rg_db.systemGlobal.statistic.perPortCnt_L4FWD[pPktHdr->ingressPort]++;
		else
			rg_db.systemGlobal.statistic.perPortCnt_IPv4_L3FWD[pPktHdr->ingressPort]++;
	}

	return RT_ERR_RG_OK;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_redirectHttpRspCheck(int direct, int naptIdx, rtk_rg_pktHdr_t *pPktHdr)
{
	char *tmpptr=NULL,*statusCodeptr=NULL;

	tmpptr = strchr(pPktHdr->pL4Payload,' ');
	if (tmpptr!=NULL){
		tmpptr+=1;//move to head of status code
		statusCodeptr=strsep(&tmpptr," ");
		if(rg_db.redirectHttpRsp.statusCode==simple_strtol(statusCodeptr, NULL, 0)){
			TRACE("Match response Http statusCode %d...redirect to \"%s\"!!",rg_db.redirectHttpRsp.statusCode,rg_db.redirectHttpRsp.url_str);
			_rtk_rg_redirectGeneration(pPktHdr,FAIL-1,rg_db.redirectHttpRsp.url_str);
#if 0	// 20161226: if it has hw napt connection or shortcut, it does not go into slowpath.
			//Delete connection and shortcut
			if(direct!=NAPT_DIRECTION_ROUTING){
				(pf.rtk_rg_naptConnection_del)(rg_db.naptIn[naptIdx].symmetricNaptOutIdx);
			}
#ifdef CONFIG_ROME_NAPT_SHORTCUT
			else{
				int i,j;
				rtk_rg_napt_shortcut_t *pNaptSc;
				//Upstream
				i=_rtk_rg_shortcutHashIndex(pPktHdr->ipv4Dip,pPktHdr->ipv4Sip,pPktHdr->dport,pPktHdr->sport);
				for(j=i;j<i+MAX_NAPT_SHORTCUT_WAYS;j++){
					pNaptSc=&rg_db.naptShortCut[j];
					if(pNaptSc->direction==NAPT_DIRECTION_ROUTING){
						if(pPktHdr->ipv4Dip!=pNaptSc->sip) continue;
						if(pPktHdr->dport!=pNaptSc->sport) continue;
						if(pPktHdr->sport!=pNaptSc->dport) continue;
						if(pPktHdr->ipv4Sip!=pNaptSc->dip) continue;
						if(!pNaptSc->isTcp) continue;

						TABLE("Clear ROUTING Up shortcut [%d]\n",j);
						//pNaptSc->sip=0;
						_rtk_rg_v4ShortCut_delete(j);
						break;
					}
				}
				//Downstream
				i=_rtk_rg_shortcutHashIndex(pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->sport,pPktHdr->dport);
				for(j=i;j<i+MAX_NAPT_SHORTCUT_WAYS;j++){
					pNaptSc=&rg_db.naptShortCut[j];
					if(pNaptSc->direction==NAPT_DIRECTION_ROUTING){
						if(pPktHdr->ipv4Sip!=pNaptSc->sip) continue;
						if(pPktHdr->sport!=pNaptSc->sport) continue;
						if(pPktHdr->dport!=pNaptSc->dport) continue;
						if(pPktHdr->ipv4Dip!=pNaptSc->dip) continue;
						if(!pNaptSc->isTcp) continue;

						TABLE("Clear ROUTING Down shortcut [%d]\n",j);
						//pNaptSc->sip=0;
						_rtk_rg_v4ShortCut_delete(j);
						break;
					}
				}
			}
#endif
#endif
			TRACE("[Drop] drop by http redirect");
			return RG_FWDENGINE_RET_DROP;
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_naptPacketModify(int direct, int naptIdx, rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb,int l3Modify,int l4Modify)
{
	int naptFilterRet;
	rtk_rg_err_code_t ret;
	int naptOutIdx, naptInIdx;

	//rtk_rg_macEntry_t mac;

	//DEBUG("pPktHdr->dmacL2Idx=%d\n",pPktHdr->dmacL2Idx);

	//20151211LUKE: execute pre-route callback for DPI check.
	if(direct!=NAPT_DIRECTION_ROUTING && l4Modify && rg_db.systemGlobal.initParam.naptPreRouteDPICallBack!=NULL){
		//20190816LUKE: check cannotAddToHw for executing hook or not.
		if((direct==NAPT_DIRECTION_OUTBOUND && rg_db.naptOut[naptIdx].cannotAddToHw==RG_FWDENGINE_FORWARDCB_FINISH_DPI)||
			(direct==NAPT_DIRECTION_INBOUND && rg_db.naptIn[naptIdx].cannotAddToHw==RG_FWDENGINE_FORWARDCB_FINISH_DPI)){
			TRACE("DPI had returned FINISH, bypass preroute hook.");
		}else{
			rtk_rg_naptPreRouteCallBackReturn_t ret=(rtk_rg_naptPreRouteCallBackReturn_t)rg_db.systemGlobal.initParam.naptPreRouteDPICallBack((void *)pPktHdr,direct);
			//20190819LUKE: add counter after hook.
			if(rg_db.systemGlobal.fwdStatistic)
				rg_db.systemGlobal.statistic.perPortCnt_dpiPreRouteHook[pPktHdr->ingressPort]++;
			if(ret==RG_FWDENGINE_PREROUTECB_DROP){
				TRACE("[Drop] PreRoute DPI CallBack return: DROP!");
				return RG_FWDENGINE_RET_DROP;
			}else if(ret==RG_FWDENGINE_PREROUTECB_TRAP){
				TRACE("[To PS] PreRoute DPI CallBack return: TRAP to protocol stack!");
				return RG_FWDENGINE_RET_TO_PS;
			}
			TRACE("PreRoute DPI CallBack return: Continue.");
		}
	}

#if 1
	if((pPktHdr->tagif&TCP_TAGIF)||(pPktHdr->tagif&UDP_TAGIF)||(pPktHdr->tagif&ICMP_TAGIF))
	{
		//support naptFilter trap_to_PS and packet_count with ingress_pattern before napt modify
		if( (rg_db.systemGlobal.pValidUsNaptPriorityRuleStart!= NULL) || (rg_db.systemGlobal.pValidDsNaptPriorityRuleStart!=NULL)){//check naptFilter while any rule is set. else save the time.
			naptFilterRet=_rtk_rg_napt_trap_to_ps(direct,pPktHdr,naptIdx,l3Modify,l4Modify);

			//only pre-check trap_to_ps/packet_count, other actions will do after _rtk_rg_naptPriority_assign.
			if (naptFilterRet==RG_FWDENGINE_RET_TO_PS){
				if(pPktHdr->tagif&ICMP_TAGIF){
					//the IP field is changed if the packet is ICMP, raw back.
					*pPktHdr->pIpv4Dip = htonl(pPktHdr->ipv4Dip);
					*pPktHdr->pIpv4Sip = htonl(pPktHdr->ipv4Sip);
				}
				return RG_FWDENGINE_RET_TO_PS;
			}
		}
	}
#endif
	//fill MSS
	if(pPktHdr->tagif&MSS_TAGIF)_rtk_rg_TCP_MSS_clamping_by_MTU(pPktHdr);

	//DEBUG("skb is %p, pkthdr is %p, ttl is %p",skb,pPktHdr,pPktHdr->pIpv4TTL);
	pPktHdr->l3Modify=l3Modify;
	pPktHdr->l4Modify=l4Modify;
	ret = _rtk_rg_fwdEngine_shortCutNaptPacketModify(direct,naptIdx,pPktHdr,skb,l3Modify,l4Modify);
	if(ret==RT_ERR_RG_DUMMY_DMAC_IDX)
	{
		TRACE("[Drop] ret: RT_ERR_RG_DUMMY_DMAC_IDX");
		return RG_FWDENGINE_RET_DROP;
	}
	else if(ret==RT_ERR_RG_ACL_DROP || ret==RT_ERR_RG_DROP)
	{
		TRACE("[Drop] ret: RG_FWDENGINE_RET_DROP");
		return RG_FWDENGINE_RET_DROP;
	}
	else if(ret==RT_ERR_RG_ACL_TRAP_TO_PS)
	{
		TRACE("[To PS] ret: RG_FWDENGINE_RET_TO_PS");
		return RG_FWDENGINE_RET_TO_PS;
	}
	else if(ret==RT_ERR_RG_TRAP_TO_PS)
	{
		TRACE("[To PS] ret: RT_ERR_RG_TRAP_TO_PS");
		return RG_FWDENGINE_RET_TO_PS;
	}



	DEBUG("naptPacketModify: l3Modify=%d, l4Modify=%d, naptIdx=%d direct=%d",l3Modify,l4Modify,naptIdx,direct);
	if((l3Modify && l4Modify && naptIdx>=0) || (pPktHdr->tagif&ICMP_TAGIF))
	{//naptPriority only supported in NAPT mode
		assert(naptIdx<MAX_NAPT_OUT_SW_TABLE_SIZE);

		if((pPktHdr->tagif&TCP_TAGIF) || (pPktHdr->tagif&UDP_TAGIF)||(pPktHdr->tagif&ICMP_TAGIF))
		{
			if((pPktHdr->tagif&TCP_TAGIF) || (pPktHdr->tagif&UDP_TAGIF))
			{
				//Napt index only check while NAPT(TCP/UDP) flow
			naptOutIdx = pPktHdr->naptOutboundIndx;
			naptInIdx = pPktHdr->naptrInboundIndx;

			if((pPktHdr->naptOutboundIndx<0) || (pPktHdr->naptOutboundIndx >= MAX_NAPT_OUT_SW_TABLE_SIZE)) {
				rtlglue_printf("naptPriority assign failed!!! naptOutIdx=%d is out of valid SW NAPT range!\n",pPktHdr->naptOutboundIndx);
				goto skipNaptPriorityAssign;
			}

			if((pPktHdr->naptrInboundIndx<0) || (pPktHdr->naptrInboundIndx >= MAX_NAPT_IN_SW_TABLE_SIZE)) {
				rtlglue_printf("naptPriority assign failed!!! naptInIdx=%d is out of valid SW NAPTr range!\n",pPktHdr->naptrInboundIndx);
				goto skipNaptPriorityAssign;
			}

			TRACE("naptPriority get naptOutIdx=%d naptInIdx=%d",pPktHdr->naptOutboundIndx,pPktHdr->naptrInboundIndx);
			}
			else
			{
				TRACE("naptPriority for ICMP packet without naptOutIdx/naptInIdx");
			}
			if(	(rg_db.systemGlobal.pValidUsNaptPriorityRuleStart!= NULL) || (rg_db.systemGlobal.pValidDsNaptPriorityRuleStart!=NULL)){//check naptFilter while any rule is set. else save the time.
				naptFilterRet=_rtk_rg_naptPriority_assign(direct,pPktHdr,&rg_db.naptOut[pPktHdr->naptOutboundIndx],&rg_db.naptIn[pPktHdr->naptrInboundIndx],naptIdx,l3Modify,l4Modify);
				if(naptFilterRet==RG_FWDENGINE_RET_DROP){
					return RG_FWDENGINE_RET_DROP;
				}else if (naptFilterRet==RG_FWDENGINE_RET_TO_PS){
					return RG_FWDENGINE_RET_TO_PS;
				}
			}
		}
	}

skipNaptPriorityAssign:
	if(ret!=RT_ERR_RG_OK)
	{
		TRACE("[Drop] Drop by Shortcut Modify!");
		return RG_FWDENGINE_RET_DROP;
	}

	//20151211LUKE: execute forward callback for DPI check.
	if(direct!=NAPT_DIRECTION_ROUTING && l4Modify && rg_db.systemGlobal.initParam.naptForwardDPICallBack!=NULL)
	{
		//20190816LUKE: check cannotAddToHw for executing hook or not.
		if((direct==NAPT_DIRECTION_OUTBOUND && rg_db.naptOut[naptIdx].cannotAddToHw==RG_FWDENGINE_FORWARDCB_FINISH_DPI)||
			(direct==NAPT_DIRECTION_INBOUND && rg_db.naptIn[naptIdx].cannotAddToHw==RG_FWDENGINE_FORWARDCB_FINISH_DPI)){
			TRACE("DPI had returned FINISH, bypass forward hook.");
		}else{
			if(rg_db.systemGlobal.dpi_accelerate_enable && time_is_after_jiffies(rg_db.systemGlobal.dpi_accelerate_jiffies))
			{
				if(direct==NAPT_DIRECTION_OUTBOUND){
					rg_db.naptOut[naptIdx].cannotAddToHw=0;
					rg_db.naptIn[rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx].cannotAddToHw=0;
					//20170317LUKE: add to hw if napt is CONNECTED and need not be checked by sw for http/https mechanism.
					if((rg_db.naptOut[naptIdx].state==TCP_CONNECTED&&!pPktHdr->checkHttpKeepInSw&&!pPktHdr->checkHttpsKeepInSw)||rg_db.naptOut[naptIdx].state==UDP_CONNECTED)pPktHdr->addNaptAfterNicTx=1;
				}else{
					rg_db.naptIn[naptIdx].cannotAddToHw=0;
					rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].cannotAddToHw=0;
					//20170317LUKE: add to hw if napt is CONNECTED and need not be checked by sw for http/https mechanism.
					if((rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].state==TCP_CONNECTED&&!pPktHdr->checkHttpKeepInSw&&!pPktHdr->checkHttpsKeepInSw)||rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].state==UDP_CONNECTED)pPktHdr->addNaptAfterNicTx=1;
				}
			}
			else
			{
				struct sk_buff *dpi_skb=rtk_rg_skbCopyToPreAllocSkb(skb);
				if(dpi_skb){
					rtk_rg_naptForwardCallBackReturn_t dpi_ret;
					rtk_rg_pktHdr_t *dpi_pPktHdr=&rg_db.systemGlobal.pktHeader_dpi;

					memcpy(&rg_db.systemGlobal.pktHeader_dpi,pPktHdr,sizeof(rtk_rg_pktHdr_t));
					dpi_pPktHdr->skb=dpi_skb;
					dpi_pPktHdr->egressVlanTagif=0x0;
					dpi_pPktHdr->egressServiceVlanTagif=0x0;
					//20160623LUKE: packet send to DPI should keep SMAC, SIP, SPORT, and remove CTAG, STAG, PPPoE TAG, DUAL HDR.
					memcpy(dpi_skb->data+6,pPktHdr->smac,ETHER_ADDR_LEN);
					if(pPktHdr->tagif&IPV4_TAGIF)*(unsigned int *)(dpi_skb->data+(POINTER_CAST)pPktHdr->pIpv4Sip-(POINTER_CAST)skb->data)=htonl(pPktHdr->ipv4Sip);
					if(pPktHdr->tagif&TCP_TAGIF||pPktHdr->tagif&UDP_TAGIF)*(unsigned short *)(dpi_skb->data+(POINTER_CAST)pPktHdr->pSport-(POINTER_CAST)skb->data)=htons(pPktHdr->sport);
					if((dpi_pPktHdr->tagif&CVLAN_TAGIF)||(dpi_pPktHdr->tagif&SVLAN_TAGIF))
						_rtk_rg_vlanSvlanTag2SkbBuffer(dpi_skb,dpi_pPktHdr);
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_XDSL_NEW_HWNAT_DRIVER)
					if(dpi_pPktHdr->egressTagif&PPPOE_TAGIF)
#else
					//20210114LUKE: forcibly remove pppoe tag for downstream packets since hw support pppoe offloading
					if(dpi_pPktHdr->tagif&PPPOE_TAGIF)
#endif
						_rtk_rg_removePPPoETag_disableHwOffload(dpi_pPktHdr, TRUE);
					if(dpi_pPktHdr->tagif&PPTP_INNER_TAGIF||dpi_pPktHdr->tagif&L2TP_INNER_TAGIF||dpi_pPktHdr->tagif&DSLITE_INNER_TAGIF||dpi_pPktHdr->tagif&VXLAN_TAGIF)
						_rtk_rg_removeTunnelTag(dpi_pPktHdr);

					dpi_ret=(rtk_rg_naptForwardCallBackReturn_t)rg_db.systemGlobal.initParam.naptForwardDPICallBack((void *)dpi_pPktHdr,direct);
					//free dpi_skb
					_rtk_rg_dev_kfree_skb_any(dpi_skb);
					//20190819LUKE: add counter after hook.
					if(rg_db.systemGlobal.fwdStatistic)
						rg_db.systemGlobal.statistic.perPortCnt_dpiForwardHook[pPktHdr->ingressPort]++;
					if(dpi_ret==RG_FWDENGINE_FORWARDCB_CONTINUE_DPI||dpi_ret==RG_FWDENGINE_FORWARDCB_SW_COUNTING){
						TRACE("Forward DPI CallBack return: %s!",dpi_ret==RG_FWDENGINE_FORWARDCB_CONTINUE_DPI?"DPI_CONTINUE_CHECK":"SW_COUNTING");
						//Do not add to hw for this flow, also remove shortcut created if countinue check
						if(pPktHdr->addNaptAfterNicTx){
							//20170317LUKE: if we are ready addNaptAfterNicTx, we should have state as CONNECTED in case the flow deleted by short timeout.
							if(pPktHdr->tagif&TCP_TAGIF)
								rg_db.naptOut[naptIdx].state=TCP_CONNECTED;
							else
								rg_db.naptOut[naptIdx].state=UDP_CONNECTED;
						}
						pPktHdr->addNaptAfterNicTx=0;
						if(!rg_db.systemGlobal.dpi_accelerate_shortcut)
						{
							if(dpi_ret==RG_FWDENGINE_FORWARDCB_CONTINUE_DPI && pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
								pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
								pPktHdr->pCurrentShortcutEntry=NULL;
								pPktHdr->pInboundShortcutEntry=NULL;
#else
								//pPktHdr->pCurrentShortcutEntry->sip=0;
								_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
								if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
									if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
										//pPktHdr->pInboundShortcutEntry->sip=0;
										_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
								}
#endif
							}
						}
						if(direct==NAPT_DIRECTION_OUTBOUND){
							rg_db.naptOut[naptIdx].cannotAddToHw=dpi_ret;
							rg_db.naptIn[rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx].cannotAddToHw=dpi_ret;
						}else{
							rg_db.naptIn[naptIdx].cannotAddToHw=dpi_ret;
							rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].cannotAddToHw=dpi_ret;
						}
					}else if(dpi_ret==RG_FWDENGINE_FORWARDCB_DROP){
						TRACE("Forward DPI CallBack return: DROP!");
						return RG_FWDENGINE_RET_DROP;
					}else{
						TRACE("Forward DPI CallBack return: DPI_FINISH_CHECK.");
						if(direct==NAPT_DIRECTION_OUTBOUND){
							rg_db.naptOut[naptIdx].cannotAddToHw=0;
							rg_db.naptIn[rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx].cannotAddToHw=0;
							//20170317LUKE: add to hw if napt is CONNECTED and need not be checked by sw for http/https mechanism.
							if((rg_db.naptOut[naptIdx].state==TCP_CONNECTED&&!pPktHdr->checkHttpKeepInSw&&!pPktHdr->checkHttpsKeepInSw)||rg_db.naptOut[naptIdx].state==UDP_CONNECTED)pPktHdr->addNaptAfterNicTx=1;
						}else{
							rg_db.naptIn[naptIdx].cannotAddToHw=0;
							rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].cannotAddToHw=0;
							//20170317LUKE: add to hw if napt is CONNECTED and need not be checked by sw for http/https mechanism.
							if((rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].state==TCP_CONNECTED&&!pPktHdr->checkHttpKeepInSw&&!pPktHdr->checkHttpsKeepInSw)||rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].state==UDP_CONNECTED)pPktHdr->addNaptAfterNicTx=1;
						}
					}
				}
				else
				{
#if defined(CONFIG_RG_RTL9600_SERIES)
					if(skb->len>SKB_BUF_SIZE)
						DEBUG("DPI forward SKB allocated failed...Pass.");
					else
#endif
						WARNING("DPI forward SKB allocated failed...Pass.");
				}
			}
		}
	}else if(naptIdx>=0){
		//20190816LUKE: set cannotAddToHw to zero since we don't need DPI here.
		if(direct==NAPT_DIRECTION_OUTBOUND){
			rg_db.naptOut[naptIdx].cannotAddToHw=0;
			rg_db.naptIn[rg_db.naptOut[naptIdx].rtk_naptOut.hashIdx].cannotAddToHw=0;
		}else{
			rg_db.naptIn[naptIdx].cannotAddToHw=0;
			rg_db.naptOut[rg_db.naptIn[naptIdx].symmetricNaptOutIdx].cannotAddToHw=0;
		}
	}

	//20160224LUKE: check for Http response status code
	if((rg_db.redirectHttpRsp.enable)&&(pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->sport==rg_db.systemGlobal.httpMonitorPort)&&(pPktHdr->pL4Payload)){
		return _rtk_rg_redirectHttpRspCheck(direct, naptIdx, pPktHdr);
	}

	//dump_packet(skb->data,skb->len,"new");
	return RG_FWDENGINE_RET_CONTINUE;
}

__IRAM_FWDENG
void _rtk_rg_fwdEngine_ipv6ShortCutPacketModify(int direct, int intfType,rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb)
{
	int l2Idx=pPktHdr->dmacL2Idx;
	if(l2Idx<0 || l2Idx>=MAX_LUT_SW_TABLE_SIZE)
	{
		TRACE("[NOP] invalid dmacL2Idx(%d)!",l2Idx);
		return;
	}

	*pPktHdr->pIPv6HopLimit-=1;

	if(rg_db.systemGlobal.fwdStatistic){
		rg_db.systemGlobal.statistic.perPortCnt_IPv6_L3FWD[pPktHdr->ingressPort]++;
	}

	//update shortcut before packet modification
#ifdef CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT
	if(pPktHdr->shortcutStatus==RG_SC_NEED_UPDATE)_rtk_rg_naptV6ShortcutUpdate(pPktHdr,0);
#endif
	if(direct==NAPT_DIRECTION_OUTBOUND || direct==IPV6_ROUTE_OUTBOUND){
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)		
		//check NPTv6 for outbound packet
		_rtk_rg_NPTv6_outbound_check(pPktHdr);
		if(pPktHdr->isNPTv6==3) return;
#endif	
		// fill DA
		memcpy(pPktHdr->pDmac,rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN);

		//fill SA
		memcpy(pPktHdr->pSmac,rg_db.netif[pPktHdr->netifIdx].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN);

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
		//fill EXTPORT
		DEBUG("direct = %d",direct);
		if(direct==NAPT_DIRECTION_OUTBOUND && ((pPktHdr->tagif&TCP_TAGIF)||(pPktHdr->tagif&UDP_TAGIF))){
			//SIP
			memcpy(pPktHdr->pIpv6Sip,rg_db.v6Extip[pPktHdr->pIPv6StatefulList->extipIdx].externalIp.ipv6_addr,IPV6_ADDR_LEN);
			TRACE("modify SIP to %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",
				pPktHdr->pIpv6Sip[0],pPktHdr->pIpv6Sip[1],pPktHdr->pIpv6Sip[2],pPktHdr->pIpv6Sip[3],
				pPktHdr->pIpv6Sip[4],pPktHdr->pIpv6Sip[5],pPktHdr->pIpv6Sip[6],pPktHdr->pIpv6Sip[7],
				pPktHdr->pIpv6Sip[8],pPktHdr->pIpv6Sip[9],pPktHdr->pIpv6Sip[10],pPktHdr->pIpv6Sip[11],
				pPktHdr->pIpv6Sip[12],pPktHdr->pIpv6Sip[13],pPktHdr->pIpv6Sip[14],pPktHdr->pIpv6Sip[15]);

			//Sport
			*pPktHdr->pSport=htons(pPktHdr->pIPv6StatefulList->externalPort);
			TRACE("modify SPORT to %d",pPktHdr->pIPv6StatefulList->externalPort);
		}
#endif

		//add pppoe header
		if(intfType==L34_NH_PPPOE)
		{
#if defined(CONFIG_RG_RTL9600_SERIES)
			_rtk_rg_addPPPoETag(pPktHdr,skb,0,0);
#else	// support pppoe keep
			if((pPktHdr->tagif&PPPOE_TAGIF) == 0)
				_rtk_rg_addPPPoETag(pPktHdr,skb,0,0);
#endif
		}
		else if(pPktHdr->egressTagif&PPPOE_TAGIF)
			_rtk_rg_removePPPoETag(pPktHdr);	//remove pppoe header while routing mode

	}else{ //INBOUND
		//fill DA
		//assert_ok(rtk_rg_macEntry_find(&mac,&l2Idx));
		//memcpy(pPktHdr->pDmac,mac.mac.octet,6);
		memcpy(pPktHdr->pDmac,rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN);

		//fill SA
		memcpy(pPktHdr->pSmac,rg_db.netif[pPktHdr->netifIdx].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN);





#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
		DEBUG("direct = %d",direct);
		if(direct==NAPT_DIRECTION_INBOUND && ((pPktHdr->tagif&TCP_TAGIF)||(pPktHdr->tagif&UDP_TAGIF))){
			DEBUG("pPktHdr->pIPv6StatefulList is %p",pPktHdr->pIPv6StatefulList);
			//DIP
			memcpy(pPktHdr->pIpv6Dip,pPktHdr->pIPv6StatefulList->internalIP.ipv6_addr,IPV6_ADDR_LEN);
			TRACE("modify DIP to %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",
				pPktHdr->pIpv6Dip[0],pPktHdr->pIpv6Dip[1],pPktHdr->pIpv6Dip[2],pPktHdr->pIpv6Dip[3],
				pPktHdr->pIpv6Dip[4],pPktHdr->pIpv6Dip[5],pPktHdr->pIpv6Dip[6],pPktHdr->pIpv6Dip[7],
				pPktHdr->pIpv6Dip[8],pPktHdr->pIpv6Dip[9],pPktHdr->pIpv6Dip[10],pPktHdr->pIpv6Dip[11],
				pPktHdr->pIpv6Dip[12],pPktHdr->pIpv6Dip[13],pPktHdr->pIpv6Dip[14],pPktHdr->pIpv6Dip[15]);

			//Dport
			*pPktHdr->pDport=htons(pPktHdr->pIPv6StatefulList->internalPort);
			TRACE("modify DPORT to %d",pPktHdr->pIPv6StatefulList->internalPort);
		}
#endif

		//remove pppoe header
		if(pPktHdr->egressTagif&PPPOE_TAGIF)
			_rtk_rg_removePPPoETag(pPktHdr);
	}

}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_ipv6PacketModify(rtk_rg_naptDirection_t direct, rtk_l34_nexthop_type_t intfType,rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb)
{
	//Hop Limit minus one with checking
	if(*pPktHdr->pIPv6HopLimit<=1)
	{
		TRACE("[To PS] ipv6 hop limit <= 1, trap to PS.");
		return RG_FWDENGINE_RET_TO_PS;
	}

	if(pPktHdr->dmacL2Idx==rg_db.systemGlobal.defaultTrapLUTIdx)
	{
		TRACE("[Drop] dmacL2Idx is dummyIdx(mac=0:0:0:0:0:0), drop.");
		return RG_FWDENGINE_RET_DROP;
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(pPktHdr->shortcutStatus!=RG_SC_MATCH)
	{
		rtk_rg_fwdEngineReturn_t aclRet=RG_FWDENGINE_RET_DIRECT_TX;

		assert(pPktHdr->dmacL2Idx!=FAIL);

		//call to ACL
		assert_ok(_rtk_rg_egressACLPatternCheck(pPktHdr->fwdDecision,0,pPktHdr,skb,pPktHdr->l3Modify,pPktHdr->l4Modify,RG_ACL_EGRESS_BYPASS_PORT_ESPECIAL_TO_PS_CHECK));
		aclRet = _rtk_rg_egressACLAction(pPktHdr->fwdDecision,pPktHdr);
		//just care Permit/Trap_to_PS, due to pattern limit!
		if(aclRet==RG_FWDENGINE_RET_TO_PS)
		{
			TRACE("[To PS] ret: RG_FWDENGINE_RET_TO_PS");
			return RG_FWDENGINE_RET_TO_PS;
		}
	}
#endif

	//fill MSS
	if(pPktHdr->tagif&MSS_TAGIF)_rtk_rg_TCP_MSS_clamping_by_MTU(pPktHdr);
#if defined(CONFIG_RG_WAN_MSS_CACHE_FRAGMENT_DEGENERACY)
	//20190925LUKE: check MSS cache for matching SIP, change its MSS to predefined value.
	if(pPktHdr->ipv6FragPacket && pPktHdr->ipProtocol==RG_IP_PROTO_TCP){
		_rtk_rg_v6mssCache_update(pPktHdr->srcNetifIdx, pPktHdr->pIpv6Sip, CONFIG_RG_WAN_MSS_CACHE_FRAGMENT_DEGENERACY);
	}
#endif

	_rtk_rg_fwdEngine_ipv6ShortCutPacketModify(direct,intfType,pPktHdr,skb);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)
	if(pPktHdr->isNPTv6==3)
	{
		TRACE("[To PS] Fail to do NPTv6...trap to PS.");
		return RG_FWDENGINE_RET_TO_PS;
	}
#endif	
	return RG_FWDENGINE_RET_CONTINUE;
}

const unsigned char fragHashTable[256] =
{
    98,  6, 85,150, 36, 23,112,164,135,207,169,  5, 26, 64,165,219, //  1
    61, 20, 68, 89,130, 63, 52,102, 24,229,132,245, 80,216,195,115, //  2
    90,168,156,203,177,120,  2,190,188,  7,100,185,174,243,162, 10, //  3
   237, 18,253,225,  8,208,172,244,255,126,101, 79,145,235,228,121, //  4
   123,251, 67,250,161,  0,107, 97,241,111,181, 82,249, 33, 69, 55, //  5
    59,153, 29,  9,213,167, 84, 93, 30, 46, 94, 75,151,114, 73,222, //  6
   197, 96,210, 45, 16,227,248,202, 51,152,252,125, 81,206,215,186, //  7
    39,158,178,187,131,136,  1, 49, 50, 17,141, 91, 47,129, 60, 99, //  8
   154, 35, 86,171,105, 34, 38,200,147, 58, 77,118,173,246, 76,254, //  9
   133,232,196,144,198,124, 53,  4,108, 74,223,234,134,230,157,139, // 10
   189,205,199,128,176, 19,211,236,127,192,231, 70,233, 88,146, 44, // 11
   183,201, 22, 83, 13,214,116,109,159, 32, 95,226,140,220, 57, 12, // 12
   221, 31,209,182,143, 92,149,184,148, 62,113, 65, 37, 27,106,166, // 13
     3, 14,204, 72, 21, 41, 56, 66, 28,193, 40,217, 25, 54,179,117, // 14
   238, 87,240,155,180,170,242,212,191,163, 78,218,137,194,175,110, // 15
    43,119,224, 71,122,142, 42,160,104, 48,247,103, 15, 11,138,239  // 16
};

__IRAM_FWDENG
unsigned int _rtk_rg_hashFun_xPear(uint8 len, uint8 ipProto, uint32 srcAddr, uint32 destAddr, uint32 identification)
{
	unsigned char *x, ch, h, i;
	unsigned int hex;
	unsigned short hh[len>>1];

	ch=ipProto;
	for (i=0; i<(len>>1); i++)
	{
		// standard Pearson hash (output is h)
		h=0;
		h=fragHashTable[h ^ ch];		//ipProtocol
		if(srcAddr!=0)		//inbound hash will assign srcAddr as 0
		{
			x=(uint8 *)&srcAddr;
			h=fragHashTable[h ^ *x];
			h=fragHashTable[h ^ *(x+1)];
			h=fragHashTable[h ^ *(x+2)];
			h=fragHashTable[h ^ *(x+3)];
		}
		x=(uint8 *)&destAddr;
		h=fragHashTable[h ^ *x];
		h=fragHashTable[h ^ *(x+1)];
		h=fragHashTable[h ^ *(x+2)];
		h=fragHashTable[h ^ *(x+3)];
		x=(uint8 *)&identification;
		h=fragHashTable[h ^ *(x)];
		h=fragHashTable[h ^ *(x+1)];
		h=fragHashTable[h ^ *(x+2)];
		h=fragHashTable[h ^ *(x+3)];

		hh[i]=h;	// store result
		ch=ch+1; // increment first data byte by 1
	}

	//FIXME("hh[0].a is %02x, hh[1].a is %02x",hh[0].a,hh[1].a);
	if(len==4)
		hex = ((hh[0]&0xff)<<8) + (hh[1]&0xff);		//16bits//hex = ((hh[0].a&0xff)<<8) + (hh[1].a&0xff);		//16bits
	else
		hex = hh[0]&0xff;		//8bits//hex = hh[0].a&0xff;		//8bits

	return hex;
}

uint32 _rtk_rg_ipv4FragInHashIndex(uint8 ipProto, uint32 destAddr, uint16 identification)
{
	return _rtk_rg_hashFun_xPear(2,ipProto,0,destAddr,identification)&IPV4_FRAGMENT_IN_HASH_MASK;
}

uint32 _rtk_rg_ipv4FragOutHashIndex(uint8 ipProto, uint32 srcAddr, uint32 destAddr, uint16 identification)
{
	return _rtk_rg_hashFun_xPear(4,ipProto,srcAddr,destAddr,identification)&IPV4_FRAGMENT_OUT_HASH_MASK;
}

#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
uint32 _rtk_rg_ipv6StatefulHashIndex(uint8 ipProto, uint8 *intAddr, uint8 *remoteAddr, uint16 intPort, uint16 remotePort)
{
	uint32 in,rem;

	in = (*(uint32 *)intAddr) ^ (*(uint32 *)(intAddr+4)) ^ (*(uint32 *)(intAddr+8)) ^ (*(uint32 *)(intAddr+12));
	rem = (*(uint32 *)remoteAddr) ^ (*(uint32 *)(remoteAddr+4)) ^ (*(uint32 *)(remoteAddr+8)) ^ (*(uint32 *)(remoteAddr+12));

	//return _rtk_rg_hashFun_xPear(4,ipProto,in,rem,intPort^remotePort)&0x1ff;
	return _rtk_rg_hashFun_xPear(2,ipProto,in,rem,intPort^remotePort);	//8bits
	//return ((in ^ rem)&0x1ff);
}
#endif

#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
__IRAM_FWDENG
uint32 _rtk_rg_shortcutHashIndex(uint32 srcIP, uint32 destIP, uint16 srcPort, uint16 destPort)
{
	//one-way
	uint32 in=0,rem=0;
#if 0
	uint32 mask;
	mask=(MAX_NAPT_SHORTCUT_SIZE>>MAX_NAPT_SHORTCUT_WAYS_SHIFT)-1;
	in=(srcIP&0xffff)^(srcIP>>16)^srcPort^destPort;
	while(in>0)
	{
		rem^=(in&mask);
		in>>=FWD_SHORTCUT_BIT_NUM;
	}
#else
	in=(srcPort<<6)+destPort+srcIP+destIP;
	rem=(in<<31)+(in<<29)-(in<<25)+(in<<22)-(in<<19)-(in<<16)+in;
	rem=rem>>(32-FWD_SHORTCUT_BIT_NUM);
#endif

	return (rem<<MAX_NAPT_SHORTCUT_WAYS_SHIFT);
}

__IRAM_FWDENG
uint32 _rtk_rg_ipv6ShortcutHashIndex(uint32 srcIP, uint32 destIP, uint16 srcPort, uint16 destPort)
{
	//one-way
	uint32 in=0,rem=0;
#if 0
	uint32 mask;
	mask=(MAX_NAPT_V6_SHORTCUT_SIZE>>MAX_NAPT_V6_SHORTCUT_WAYS_SHIFT)-1;
	in=(srcPort<<6)+destPort+srcIP;
	while(in>0)
	{
		rem+=(in&mask);
		in>>=FWD_V6_SHORTCUT_BIT_NUM;
	}
	rem=((rem&mask)+(rem>>MAX_NAPT_V6_SHORTCUT_SIZE_SHIFT))&mask;
#else
	in=(srcPort<<6)+destPort+srcIP+destIP;
	rem=(in<<31)+(in<<29)-(in<<25)+(in<<22)-(in<<19)-(in<<16)+in;
	rem=rem>>(32-FWD_V6_SHORTCUT_BIT_NUM);
#endif
	return (rem<<MAX_NAPT_V6_SHORTCUT_WAYS_SHIFT);
}
#endif

void _rtk_rg_fwdEngine_fragmentPacketQueuing(rtk_rg_naptDirection_t direction, struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	int i,queueIdx;
	unsigned long compareTime;
	//------------------ Critical Section start -----------------------//
	rg_lock(&rg_kernel.ipv4FragQueueLock);

	//DEBUG("the queueTime is %ld",jiffies);
	queueIdx=0;
	compareTime=0;

	//find the first valid one or smallest queue_time(oldest) to use

	for(i=0;i<MAX_IPV4_FRAGMENT_QUEUE_SIZE;i++)
	{
		if(rg_db.ipv4FragmentQueue[i].occupied==0)
		{
			compareTime = 0;
			queueIdx = i;
			rg_db.systemGlobal.ipv4FragmentQueueNum++;
			if(rg_db.systemGlobal.fwdStatistic)rg_db.systemGlobal.statistic.perPortCnt_v4FragQueued[pPktHdr->ingressPort]++;
			break;
		}
		else if(rg_db.ipv4FragmentQueue[i].queue_time < compareTime || compareTime == 0)
		{
			compareTime = rg_db.ipv4FragmentQueue[i].queue_time;
			queueIdx = i;
		}
	}

	//free the oldest one skb
	if(compareTime>0)
	{
		rtk_rg_pktHdr_t *orig_pktHdr=rg_db.pktHdr; 
		
		rg_db.pktHdr = &rg_db.systemGlobal.pktHeader_2;
		rg_db.pktHdr->ingressPort = rg_db.ipv4FragmentQueue[queueIdx].queue_pktInfo.ingressPort;
		_rtk_rg_dev_kfree_skb_any(rg_db.ipv4FragmentQueue[queueIdx].queue_skb);
		rg_db.pktHdr=orig_pktHdr;	//point back to original pkthdr
	}

	//insert new packet into this idx
	rg_db.ipv4FragmentQueue[queueIdx].queue_pktInfo.ingressPort=pPktHdr->ingressPort;
	rg_db.ipv4FragmentQueue[queueIdx].queue_pktInfo.ipv4Sip=pPktHdr->ipv4Sip;
	rg_db.ipv4FragmentQueue[queueIdx].queue_pktInfo.ipv4Identification=pPktHdr->ipv4Identification;
	rg_db.ipv4FragmentQueue[queueIdx].queue_skb=skb;
	memcpy(&rg_db.ipv4FragmentQueue[queueIdx].queue_rx_info,pPktHdr->pRxDesc,sizeof(struct rx_info));
	rg_db.ipv4FragmentQueue[queueIdx].queue_time=jiffies;
	rg_db.ipv4FragmentQueue[queueIdx].occupied=1;
	rg_db.ipv4FragmentQueue[queueIdx].direction=direction;

	//------------------ Critical Section End -----------------------//
	rg_unlock(&rg_kernel.ipv4FragQueueLock);

}

void _rtk_rg_fwdEngine_fragmentQueueProcessing(int aclRet, rtk_rg_pktHdr_t *pPktHdr)
{
	int i,totalQueueNum;
	//If we are the first fragment packet:
	//Check the queue to see if there is any packet has same identification and SIP,DIP
	//Loop if match:
	//	no need to recompute the L3 checksum, let HW do it
	//	Forward the packet
	//	Move the last one to the proceed queue position
	//	Queue number --
	//------------------ Critical Section start -----------------------//
	rg_lock(&rg_kernel.ipv4FragQueueLock);
	totalQueueNum=rg_db.systemGlobal.ipv4FragmentQueueNum;
	for(i=0;i<MAX_IPV4_FRAGMENT_QUEUE_SIZE&&totalQueueNum>0;i++)
	{
		//DEBUG("rg_db.systemGlobal.ipv4FragmentQueueNum is %d",rg_db.systemGlobal.ipv4FragmentQueueNum);
		//DEBUG("rg_db.ipv4FragmentQueue[i].occupied = %d",rg_db.ipv4FragmentQueue[i].occupied);

		if(rg_db.ipv4FragmentQueue[i].occupied)
		{
			totalQueueNum--;
			if(pPktHdr->ipv4Sip==rg_db.ipv4FragmentQueue[i].queue_pktInfo.ipv4Sip &&
				pPktHdr->ipv4Identification==rg_db.ipv4FragmentQueue[i].queue_pktInfo.ipv4Identification)
			{
				//DEBUG("queue [%d] Match!!",i);
				if(rg_db.ipv4FragmentQueue[i].queue_skb)
				{
					int _extra_datapath_to_PS_forwarding(struct sk_buff *skb, rtk_rg_rxdesc_t *pRxDesc, int rg_fwdengine_ret_code);
					void _hostPolicingCounterUpdate(void);
					struct sk_buff *skb=rg_db.ipv4FragmentQueue[i].queue_skb;
					rtk_rg_rxdesc_t *pRxDesc=&rg_db.ipv4FragmentQueue[i].queue_rx_info;
					int ret, rg_fwdengine_ret_code=0;
					
					//backup original pkthdr
					rg_db.systemGlobal.pktHeader_frag.sport_firstFrag = pPktHdr->sport;
					rg_db.systemGlobal.pktHeader_frag.dport_firstFrag = pPktHdr->dport;			
					rg_db.pktHdr=&rg_db.systemGlobal.pktHeader_frag;

					if(rg_db.systemGlobal.fwdStatistic)
						rg_db.systemGlobal.statistic.perPortCnt_L4FragQueuedReentrance[pPktHdr->ingressPort]++;

					rg_fwdengine_ret_code = rtk_rg_fwdEngineInput(skb, pRxDesc);
					//Processing packets
					if(rg_fwdengine_ret_code==RG_FWDENGINE_RET_TO_PS)
					{
						ret = _extra_datapath_to_PS_forwarding(skb, pRxDesc, rg_fwdengine_ret_code);
						_hostPolicingCounterUpdate();
						if(ret == RE8670_RX_STOP)
						{
							TRACE("FRG_OUT[%lx]: Free before forward to PS", (POINTER_CAST)skb&0xffff);
							_rtk_rg_dev_kfree_skb_any(skb);
						}
						else
						{
							TRACE("FRG_OUT[%lx]: Forward to PS decision, ret=%d",(POINTER_CAST)skb&0xffff,ret);
							//from master wifi
							if((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<rg_db.pktHdr->ingressPort))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
								|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<rg_db.pktHdr->ingressPort))
#endif
								)
							{
								skb->protocol = eth_type_trans(skb, skb->dev);
								netif_rx(skb);
							}
							else
							{
#if defined(CONFIG_RG_G3_SERIES)
								nic_rxhook_default(NULL, skb->dev, skb, NULL);
#else
								re8670_rx_skb(((struct re_dev_private*)skb->dev->priv)->pCp, skb, (struct rx_info *)pRxDesc);
#endif
							}
						}
					}
					else if(rg_fwdengine_ret_code==RG_FWDENGINE_RET_DROP)
					{
						TRACE("FRG_OUT[%lx]: Free skb if any", (POINTER_CAST)skb&0xffff);
						_rtk_rg_dev_kfree_skb_any(skb);												
					}
					else if(rg_fwdengine_ret_code==RG_FWDENGINE_RET_DIRECT_TX && rg_db.pktHdr->forwardCount==0)
					{
						//the SKB had been freed, kfree is no need
						TRACE("FRG_OUT[%lx]: Stop by port isolation/ip version filter/source port filter, ...", (POINTER_CAST)skb&0xffff);	
					}
					else//cxy: fwd engine processed skb
					{
						//the SKB had been freed, kfree is no need
						TRACE("FRG_OUT[%lx]: Processed.(ret=%d)", (POINTER_CAST)skb&0xffff, rg_fwdengine_ret_code);
					}
					
					//point back to original pkthdr
					rg_db.pktHdr=&rg_db_cache.pktHeader_1;
				}
				rg_db.systemGlobal.ipv4FragmentQueueNum--;
				if(rg_db.systemGlobal.fwdStatistic)
					rg_db.systemGlobal.statistic.perPortCnt_v4FragQueued[pPktHdr->ingressPort]--;
				rg_db.ipv4FragmentQueue[i].occupied = 0;
				rg_db.ipv4FragmentQueue[i].queue_time = 0;
			}
		}
	}
	//------------------ Critical Section End -----------------------//
	rg_unlock(&rg_kernel.ipv4FragQueueLock);
}

rtk_rg_lookupIdxReturn_t _rtk_rg_fwdEngine_fragmentOutHashIndexLookup(rtk_rg_ipv4_fragment_out_t **pRetFragOutList, uint8 ipProto, ipaddr_t srcAddr, ipaddr_t destAddr, uint16 identification, uint16 receiveLength)
{
	int ret=RG_RET_LOOKUPIDX_NOT_FOUND;
	uint32 naptHashOutIdx;
	//int naptInIdx;
	rtk_rg_ipv4_fragment_out_t *pFragOutList,*pNextFragList;
	rtk_rg_pkthdr_tagif_t layer4Type;

	switch(ipProto)
	{
		case 0x1:
			layer4Type=ICMP_TAGIF;
			break;
		case 0x6:
			layer4Type=TCP_TAGIF;
			break;
		case 0x11:
			layer4Type=UDP_TAGIF;
			break;
		case 0x2f:
			layer4Type=GRE_TAGIF;
			break;
		case 0x32:
			layer4Type=ESP_TAGIF;
			break;
		default:
			layer4Type=UNKNOWN_L4_TAGIF;
			break;
	}
	naptHashOutIdx=_rtk_rg_ipv4FragOutHashIndex(ipProto,srcAddr,destAddr,identification);
	//FIXME("the frag lookup index is %d",naptHashOutIdx);

	if(!list_empty(&rg_db.fragOutHashListHead[naptHashOutIdx]))
	{
		list_for_each_entry_safe(pFragOutList, pNextFragList, &rg_db.fragOutHashListHead[naptHashOutIdx], fragout_list)
		{
			if(pFragOutList->layer4Type&layer4Type && identification==pFragOutList->identification && srcAddr==pFragOutList->intIp)
			{
				if(layer4Type&ICMP_TAGIF||layer4Type&GRE_TAGIF||layer4Type&ESP_TAGIF)
				{
					*pRetFragOutList=pFragOutList;
					pFragOutList->beginIdleTime=jiffies;
					pFragOutList->receivedLength+=receiveLength;
					//*icmpCtrlFlow=pFragOutList->pktInfo.pICMPCtrlFlow;
					//DEBUG("found ICMPCtrlFlow = %p, ret=%d, received %d bytes",pFragOutList,ret,pFragOutList->receivedLength);
					//FIXME("get ICMP out list!");
					break;
				}
				else if(layer4Type&TCP_TAGIF||layer4Type&UDP_TAGIF)
				{
					*pRetFragOutList=pFragOutList;
					pFragOutList->beginIdleTime=jiffies;
					pFragOutList->receivedLength+=receiveLength;
					ret=pFragOutList->pktInfo.napt.NaptOutboundEntryIndex;
					//DEBUG("found naptOutIdx = %d, received %d bytes",ret,pFragOutList->receivedLength);
					//FIXME("get NAPT out list!");
					break;
				}
			}

			if(time_is_before_eq_jiffies(pFragOutList->beginIdleTime+(rg_db.systemGlobal.fragment_timeout*TICKTIME_PERIOD)))		//too old
			{
				//FIXME("free old %s %p",pFragOutList->pktType==FRAG_TYPE_ICMP?"ICMP":"NAPT",pFragOutList);
				//free it
				_rtk_rg_freeFragOutList(pFragOutList);
			}
		}
	}
	return ret;
}

void _rtk_rg_fwdEngine_fillOutFragmentInfo(rtk_rg_fwdEngineReturn_t fragAction, unsigned int realNaptIdx, rtk_rg_pktHdr_t *pPktHdr, rtk_rg_ipv4_fragment_out_t **pFragList)
{
	//int i;
	//int isTCP=0;
	uint32 naptHashOutIdx;
	//int32 naptOutIdx;
	rtk_rg_ipv4_fragment_out_t *pFragFreeOutList;
	rtk_rg_pkthdr_tagif_t layer4Type;

	switch(pPktHdr->ipProtocol)
	{
		case 0x1:
			layer4Type=ICMP_TAGIF;
			break;
		case 0x6:
			layer4Type=TCP_TAGIF;
			break;
		case 0x11:
			layer4Type=UDP_TAGIF;
			break;
		case 0x2f:
			layer4Type=GRE_TAGIF;
			break;
		case 0x32:
			layer4Type=ESP_TAGIF;
			break;
		default:
			layer4Type=UNKNOWN_L4_TAGIF;
			break;
	}

	//then fill the fragment table
	naptHashOutIdx=_rtk_rg_ipv4FragOutHashIndex(pPktHdr->ipProtocol,pPktHdr->ipv4Sip,pPktHdr->ipv4Dip,pPktHdr->ipv4Identification);
	//DEBUG("the fill out hash index is %d",naptHashOutIdx);

	_rtk_rg_getFragOutFreeList(&pFragFreeOutList);

	pFragFreeOutList->intIp=pPktHdr->ipv4Sip;
	//DEBUG("fragAction is %d",fragAction);
	if(layer4Type&TCP_TAGIF||layer4Type&UDP_TAGIF)	//NAPT
	{
		DEBUG("the add fragment table hashIdx is %d, napt index is %d",naptHashOutIdx,realNaptIdx);
		pFragFreeOutList->pktInfo.napt.sport=pPktHdr->sport;
		pFragFreeOutList->pktInfo.napt.dport=pPktHdr->dport;
		pFragFreeOutList->pktInfo.napt.NaptOutboundEntryIndex=realNaptIdx;
		//pFragFreeOutList->pktInfo.napt.pNaptOutboundEntry=&rg_db.naptOut[realNaptIdx].rtk_naptOut;
		//pFragFreeOutList->pktInfo.napt.identification=pPktHdr->ipv4Identification;
	}
	*pFragList = pFragFreeOutList;
	pFragFreeOutList->layer4Type=layer4Type;
	pFragFreeOutList->fragAction=fragAction;
	pFragFreeOutList->beginIdleTime=jiffies;
	pFragFreeOutList->identification=pPktHdr->ipv4Identification;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_ROME_NAPT_SHORTCUT)
	pFragFreeOutList->flowHitIdx=FAIL;
#endif
	pFragFreeOutList->receivedLength=pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
	if(!pPktHdr->ipv4MoreFragment)
		pFragFreeOutList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pFragFreeOutList->receivedLength;
	else
		pFragFreeOutList->totalLength=0;
	//DEBUG("totalLength is %d, receivedLength is %d",pFragFreeOutList->totalLength,pFragFreeOutList->receivedLength);
	pFragFreeOutList->queueCount=0;

	list_add(&pFragFreeOutList->fragout_list, &rg_db.fragOutHashListHead[naptHashOutIdx]);
}

rtk_rg_lookupIdxReturn_t _rtk_rg_fwdEngine_fragmentInHashIndexLookup(rtk_rg_ipv4_fragment_in_t **pRetFragInList, uint8 ipProto, ipaddr_t srcAddr, ipaddr_t destAddr, uint16 identification, uint16 receiveLength)
{
	int ret=RG_RET_LOOKUPIDX_NOT_FOUND;
	uint32 naptHashInIdx;
	//int naptOutIdx;
	rtk_rg_ipv4_fragment_in_t *pFragInList,*pNextFragList;
	rtk_rg_pkthdr_tagif_t layer4Type;

	switch(ipProto)
	{
		case 0x1:
			layer4Type=ICMP_TAGIF;
			break;
		case 0x6:
			layer4Type=TCP_TAGIF;
			break;
		case 0x11:
			layer4Type=UDP_TAGIF;
			break;
		case 0x2f:
			layer4Type=GRE_TAGIF;
			break;
		case 0x32:
			layer4Type=ESP_TAGIF;
			break;
		default:
			layer4Type=UNKNOWN_L4_TAGIF;
			break;
	}

	naptHashInIdx=_rtk_rg_ipv4FragInHashIndex(ipProto,destAddr,identification);
	//DEBUG("the inbound frag lookup index is %d",naptHashInIdx);
	//naptOutIdx=naptHashOutIdx<<2;

	if(!list_empty(&rg_db.fragInHashListHead[naptHashInIdx]))
	{
		list_for_each_entry_safe(pFragInList, pNextFragList, &rg_db.fragInHashListHead[naptHashInIdx], fragin_list)
		{
			if(pFragInList->layer4Type&layer4Type && identification==pFragInList->identification && srcAddr==pFragInList->remoteIp)
			{
				if(layer4Type&ICMP_TAGIF||layer4Type&GRE_TAGIF||layer4Type&ESP_TAGIF)
				{
					*pRetFragInList=pFragInList;
					pFragInList->beginIdleTime=jiffies;
					pFragInList->receivedLength+=receiveLength;
					//*icmpCtrlFlow=pFragInList->pktInfo.pICMPCtrlFlow;
					DEBUG("found %s frag, ret= %d, action=%d, received %d bytes",layer4Type&ICMP_TAGIF?"ICMP":layer4Type&GRE_TAGIF?"GRE":"ESP",
						ret,pFragInList->fragAction,pFragInList->receivedLength);
					break;
				}
				else if(layer4Type&TCP_TAGIF||layer4Type&UDP_TAGIF)
				{
					*pRetFragInList=pFragInList;
					pFragInList->beginIdleTime=jiffies;
					pFragInList->receivedLength+=receiveLength;
					ret=pFragInList->pktInfo.napt.NaptOutboundEntryIndex;
					DEBUG("found naptOutIdx = %d, action=%d, received %d bytes",ret,pFragInList->fragAction,pFragInList->receivedLength);
					break;
				}
			}
			if(time_is_before_eq_jiffies(pFragInList->beginIdleTime+(rg_db.systemGlobal.fragment_timeout*TICKTIME_PERIOD)))		//too old
			{
				FIXME("free old %s %p",layer4Type&ICMP_TAGIF?"ICMP":layer4Type&GRE_TAGIF?"GRE":layer4Type&ESP_TAGIF?"ESP":"NAPT",pFragInList);
				//free it
				//------------------ Critical Section End -----------------------//
				//rg_unlock(&rg_kernel.ipv4FragLock);

				_rtk_rg_freeFragInList(pFragInList);

				//------------------ Critical Section start -----------------------//
				//rg_lock(&rg_kernel.ipv4FragLock);
			}
		}
	}
	return ret;
}

void _rtk_rg_fwdEngine_fillInFragmentInfo(rtk_rg_fwdEngineReturn_t fragAction, int realNaptOutIdx, void * pVp, rtk_rg_pktHdr_t *pPktHdr, rtk_rg_ipv4_fragment_in_t **pFragList)
{
	//int i;
	uint32 naptHashInIdx;
	//int32 naptOutIdx;
	rtk_rg_ipv4_fragment_in_t *pFragFreeInList;
	rtk_rg_pkthdr_tagif_t layer4Type;

	//then fill the fragment table
	naptHashInIdx=_rtk_rg_ipv4FragInHashIndex(pPktHdr->ipProtocol,pPktHdr->ipv4Dip,pPktHdr->ipv4Identification);
	//DEBUG("the fill in hash index is %d",naptHashInIdx);
	//naptOutIdx=naptHashOutIdx<<2;

	_rtk_rg_getFragInFreeList(&pFragFreeInList);

	DEBUG("fragAction is %d",fragAction);

	switch(pPktHdr->ipProtocol)
	{
		case 0x1:
			{
				rtk_rg_table_icmp_flow_t *icmpCtrlFlow=(rtk_rg_table_icmp_flow_t *)pVp;
				layer4Type=ICMP_TAGIF;
				DEBUG("record icmp ctrl flow id=%x, remoteIp=%x,internalIp=%x",pPktHdr->ICMPIdentifier,pPktHdr->ipv4Sip,(icmpCtrlFlow!=NULL?icmpCtrlFlow->internalIP:0x0));
				//pFragFreeInList->pktInfo.icmp.identification=pPktHdr->ICMPIdentifier;
				pFragFreeInList->remoteIp=pPktHdr->ipv4Sip;
				if(icmpCtrlFlow!=NULL)pFragFreeInList->pktInfo.other.intIp=icmpCtrlFlow->internalIP;
				break;
			}
		case 0x6:
		case 0x11:
			layer4Type=TCP_TAGIF;
			if(pPktHdr->ipProtocol==0x11)layer4Type=UDP_TAGIF;
			DEBUG("the add fragment table hashindex is %d, napt index is %d",naptHashInIdx,realNaptOutIdx);
			pFragFreeInList->remoteIp=pPktHdr->ipv4Sip;
			pFragFreeInList->pktInfo.napt.sport=pPktHdr->sport;
			pFragFreeInList->pktInfo.napt.dport=pPktHdr->dport;
			//pFragFreeInList->pktInfo.napt.NaptInboundEntryIndex=realNaptInIdx;
			pFragFreeInList->pktInfo.napt.NaptOutboundEntryIndex=realNaptOutIdx;		//FAIL if napt is not exist
			//pFragFreeInList->pktInfo.napt.pNaptInboundEntry=&rg_db.naptIn[realNaptInIdx].rtk_naptIn;
			break;
		case 0x2f:
			{
				rtk_rg_alg_connection_t *pConn=(rtk_rg_alg_connection_t *)pVp;
				layer4Type=GRE_TAGIF;
				pFragFreeInList->remoteIp=pPktHdr->ipv4Sip;
				if(pConn!=NULL)pFragFreeInList->pktInfo.other.intIp=pConn->tuple.internalIp.ip;
				break;
			}
		case 0x32:
			{
				rtk_rg_isakmp_t * pIsakmp=(rtk_rg_isakmp_t *)pVp;
				layer4Type=ESP_TAGIF;
				pFragFreeInList->remoteIp=pPktHdr->ipv4Sip;
				if(pIsakmp!=NULL)pFragFreeInList->pktInfo.other.intIp=pIsakmp->local_ip;
				break;
			}
		default:
			layer4Type=UNKNOWN_L4_TAGIF;
			break;
	}

	*pFragList = pFragFreeInList;
	pFragFreeInList->layer4Type=layer4Type;
	pFragFreeInList->fragAction=fragAction;
	pFragFreeInList->beginIdleTime=jiffies;
	pFragFreeInList->identification=pPktHdr->ipv4Identification;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) || defined(CONFIG_ROME_NAPT_SHORTCUT)
	pFragFreeInList->flowHitIdx=FAIL;
#endif
	pFragFreeInList->receivedLength=pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
	if(!pPktHdr->ipv4MoreFragment)
		pFragFreeInList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pFragFreeInList->receivedLength;
	else
		pFragFreeInList->totalLength=0;
	//DEBUG("totalLength is %d, receivedLength is %d",pFragFreeInList->totalLength,pFragFreeInList->receivedLength);
	pFragFreeInList->queueCount=0;

	list_add(&pFragFreeInList->fragin_list, &rg_db.fragInHashListHead[naptHashInIdx]);
}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_shortcutCheckFragList(rtk_rg_pktHdr_t *pPktHdr, int32 flowHitIdx)
{
	rtk_rg_table_flow_t *pFlow;
	rtk_rg_table_flowEntry_t *pFlowEntry;
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	if(rg_db.systemGlobal.fragShortcut_off)goto RET_FAIL;

	pFlow = &rg_db.flow[flowHitIdx];
	pFlowEntry = RG_PFLOW(flowHitIdx);	

	//20191106LUKE: if we receive first fragment packet for local in flow, we should goto slow path for queued-packets handling.
	if(pFlow->isLocalInNapt)goto RET_FAIL;

	//20170802LUKE: check if we don't have any queue packets, and create list for following frag packets.
	switch(pFlowEntry->path1.in_path)
	{
		case FB_PATH_34:
			{
				assert_ok(_rtk_rg_L2L3_fragmentListLookUp(pPktHdr, &pPktHdr->L2L3FragListIdx));
				if(pPktHdr->L2L3FragListIdx!=FAIL && rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].queueCount>0)
					goto RET_FAIL;
				return RG_RET_SUCCESS;
			}
			break;
		case FB_PATH_5:
			if(pFlowEntry->path5.out_l4_act)	//napt
			{
				if(pFlowEntry->path5.out_l4_direction)
				{
					//Caution! here should not change receivedLength!
					_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
					//20190509LUKE: we should enter slow path when outbound for hairpin nat, even we didn't queue packet in frag list.
					if(pFragList && (pFragList->queueCount>0 || pFlow->isHairpinNat))
						goto RET_FAIL;
					return RG_RET_SUCCESS;
				}
				else
				{
					//Caution! here should not change receivedLength!
					_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
					if(pFragInList && pFragInList->queueCount>0)
						goto RET_FAIL;
					return RG_RET_SUCCESS;
				}
			}
			else	//routing
			{
				assert_ok(_rtk_rg_L2L3_fragmentListLookUp(pPktHdr, &pPktHdr->L2L3FragListIdx));
				if(pPktHdr->L2L3FragListIdx!=FAIL && rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].queueCount>0)
					goto RET_FAIL;
				return RG_RET_SUCCESS;
			}
			break;
		default:
			break;
	}

RET_FAIL:
	TRACE("Queued frag or hairpin frag goto slowpath");
	return RG_RET_FAIL;
}

void _rtk_rg_fwdEngine_shortcutCheckFrag_afterModify(rtk_rg_pktHdr_t *pPktHdr, int32 flowHitIdx, rtk_rg_fwdEngineReturn_t fragAction)
{
	rtk_rg_table_flow_t *pFlow;
	rtk_rg_table_flowEntry_t *pFlowEntry;
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	if(rg_db.systemGlobal.fragShortcut_off)return;

	pFlow = &rg_db.flow[flowHitIdx];
	pFlowEntry = RG_PFLOW(flowHitIdx);
	switch(pFlowEntry->path1.in_path)
	{
		case FB_PATH_34:
			{
				assert_ok(_rtk_rg_L2L3_fragmentListAdd(pPktHdr, fragAction, &pPktHdr->L2L3FragListIdx));
				DEBUG("L2/L3 fragList[%d] flowHitIdx is %d", pPktHdr->L2L3FragListIdx, flowHitIdx);
				rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].flowHitIdx = flowHitIdx;
				pFlow->isUsedByFrag = 1;
			}
			break;
		case FB_PATH_5:
			if(pFlowEntry->path5.out_l4_act)	//napt
			{
				if(pFlowEntry->path5.out_l4_direction)
				{
					_rtk_rg_fwdEngine_fillOutFragmentInfo(fragAction,pFlow->naptOrTcpUdpGroupIdx,pPktHdr,&pFragList);
					DEBUG("NAPT fragOutList's flowHitIdx is %d",flowHitIdx);
					pFragList->flowHitIdx=flowHitIdx;
					pFlow->isUsedByFrag = 1;
					if(pPktHdr->tagif&TCP_TAGIF)
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
					else	//UDP
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
				}
				else
				{
					_rtk_rg_fwdEngine_fillInFragmentInfo(fragAction,pFlow->naptOrTcpUdpGroupIdx,NULL,pPktHdr,&pFragInList);
					DEBUG("NAPTR fragInList's flowHitIdx is %d",flowHitIdx);
					pFragInList->flowHitIdx=flowHitIdx;
					pFlow->isUsedByFrag = 1;
					if(pPktHdr->tagif&TCP_TAGIF)
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
					else	//UDP
						*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,0,0,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),0,0));
				}
			}
			else	//routing
			{
				assert_ok(_rtk_rg_L2L3_fragmentListAdd(pPktHdr, fragAction, &pPktHdr->L2L3FragListIdx));
				DEBUG("L2/L3 fragList[%d] flowHitIdx is %d", pPktHdr->L2L3FragListIdx, flowHitIdx);
				rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].flowHitIdx = flowHitIdx;
				pFlow->isUsedByFrag = 1;
			}
			break;
		default:
			break;
	}

	return;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_fragmentsShortcut(rtk_rg_pktHdr_t *pPktHdr, int32 *pFlowHitIdx)
{
	rtk_rg_fwdEngineReturn_t ret=RG_FWDENGINE_RET_CONTINUE;
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	if(rg_db.systemGlobal.fragShortcut_off)return ret;

	//since we can not decide direction here, we just try to lookup each direction!
	_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
	if(pFragList && pFragList->fragAction!=RG_FWDENGINE_RET_QUEUE_FRAG)
	{
		//Check frag action from first packet
		if(pFragList->flowHitIdx>=0)
		{
			rtk_rg_table_flowEntry_t *pFlowEntry = RG_PFLOW(pFragList->flowHitIdx);
			if(pFlowEntry->path1.in_path==FB_PATH_5 &&
				pFlowEntry->path5.in_ipv4_or_ipv6==0 &&	//ipv4
				pFlowEntry->path5.out_l4_act &&	//NAPT
				pFlowEntry->path5.in_l4_src_port==pFragList->pktInfo.napt.sport &&
				pFlowEntry->path5.in_l4_dst_port==pFragList->pktInfo.napt.dport &&
				((pFlowEntry->path5.in_l4proto==0 && (pFragList->layer4Type&UDP_TAGIF))||
				(pFlowEntry->path5.in_l4proto && (pFragList->layer4Type&TCP_TAGIF))) &&
				pFlowEntry->path5.in_src_ipv4_addr==pPktHdr->ipv4Sip &&
				((pFlowEntry->path5.out_l4_direction==0 && rg_db.netif[pFlowEntry->path5.in_intf_idx].rtk_netif.ipAddr==pPktHdr->ipv4Dip)||
				(pFlowEntry->path5.out_l4_direction && pFlowEntry->path5.in_dst_ipv4_addr==pPktHdr->ipv4Dip)))
				TRACE("Flow Match! use it.");
			else	//unmatch, clear it!
				pFragList->flowHitIdx=FAIL;
		}
		*pFlowHitIdx=pFragList->flowHitIdx;
		ret=pFragList->fragAction;
		TRACE("do frag action(%d)", ret);
		//20200116LUKE: if the flow match or fragAction is drop/trap, increase counter and free frag list if necessary.
		if(pFragList->flowHitIdx>=0 || ret==RG_FWDENGINE_RET_DROP || ret==RG_FWDENGINE_RET_TO_PS)
		{
			//add received length here for action not queue_frag.
			pFragList->receivedLength+=pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;

			//forward, drop, or trap
			//DEBUG("later fragment modify...");
			if(pPktHdr->ipv4MoreFragment == 0)		//we can not free fragList here, unless there are all packets had forwarded
				pFragList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
			//DEBUG("totalLength is %d",pFragList->totalLength);
			//Check total fragment length
			if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
			{
				DEBUG("[outBound]fragments(%d) are all received(%d)!! free the list %p...",pFragList->totalLength,pFragList->receivedLength,pFragList);
				_rtk_rg_freeFragOutList(pFragList);	//although pFragList is return to free list, since we still hold ipv4FragOutLock, there is no one can acquire this "free" entry.
			}
		}
		return ret;
	}

	_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
	if(pFragInList && pFragInList->fragAction!=RG_FWDENGINE_RET_QUEUE_FRAG)
	{
		//Check frag action from first packet
		if(pFragInList->flowHitIdx>=0)
		{
			rtk_rg_table_flowEntry_t *pFlowEntry = RG_PFLOW(pFragInList->flowHitIdx);
			if(pFlowEntry->path1.in_path==FB_PATH_5 &&
				pFlowEntry->path5.in_ipv4_or_ipv6==0 &&	//ipv4
				pFlowEntry->path5.out_l4_act &&	//NAPT
				pFlowEntry->path5.in_l4_src_port==pFragInList->pktInfo.napt.sport &&
				pFlowEntry->path5.in_l4_dst_port==pFragInList->pktInfo.napt.dport &&
				((pFlowEntry->path5.in_l4proto==0 && (pFragInList->layer4Type&UDP_TAGIF))||
				(pFlowEntry->path5.in_l4proto && (pFragInList->layer4Type&TCP_TAGIF))) &&
				pFlowEntry->path5.in_src_ipv4_addr==pPktHdr->ipv4Sip &&
				((pFlowEntry->path5.out_l4_direction==0 && rg_db.netif[pFlowEntry->path5.in_intf_idx].rtk_netif.ipAddr==pPktHdr->ipv4Dip)||
				(pFlowEntry->path5.out_l4_direction && pFlowEntry->path5.in_dst_ipv4_addr==pPktHdr->ipv4Dip)))
				TRACE("Flow Match! use it.");
			else	//unmatch, clear it!
				pFragInList->flowHitIdx=FAIL;
		}
		*pFlowHitIdx=pFragInList->flowHitIdx;
		ret=pFragInList->fragAction;
		TRACE("do frag action(%d)", ret);
		//20200116LUKE: if the flow match or fragAction is drop/trap, increase counter and free frag list if necessary.
		if(pFragInList->flowHitIdx>=0 || ret==RG_FWDENGINE_RET_DROP || ret==RG_FWDENGINE_RET_TO_PS)
		{
			//add received length here for action not queue_frag.
			pFragInList->receivedLength+=pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;

			//forward, drop, or trap
			DEBUG("later fragment modify...");
			if(pPktHdr->ipv4MoreFragment == 0)		//we can not free fragList here, unless there are all packets had forwarded
				pFragInList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
			//DEBUG("totalLength is %d",pFragInList->totalLength);
			//Check total fragment length
			if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
			{
				DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
				_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
			}
		}
		return ret;
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

#else
rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_shortcutCheckFragList(rtk_rg_pktHdr_t *pPktHdr, rtk_rg_napt_shortcut_t *pNaptSc)
{
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	if(rg_db.systemGlobal.fragShortcut_off)goto RET_FAIL;

	//20191106LUKE: if we receive first fragment packet for local in flow, we should goto slow path for queued-packets handling.
	if(pNaptSc->isLocalInNapt)goto RET_FAIL;

	//20170802LUKE: check if we don't have any queue packets, and create list for following frag packets.
	if(pNaptSc->isNapt)
	{
		if(pNaptSc->direction==NAPT_DIRECTION_OUTBOUND)
		{
			//Caution! here should not change receivedLength!
			_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
			//20190509LUKE: we should enter slow path when outbound for hairpin nat, even we didn't queue packet in frag list.
			if(pFragList && (pFragList->queueCount>0 || pNaptSc->isHairpinNat))goto RET_FAIL;
			return RG_RET_SUCCESS;
		}
		else
		{
			//Caution! here should not change receivedLength!
			_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
			if(pFragInList && pFragInList->queueCount>0)goto RET_FAIL;
			return RG_RET_SUCCESS;
		}
	}
RET_FAIL:
	TRACE("Queued frag or hairpin frag goto slowpath");
	return RG_RET_FAIL;
}

void _rtk_rg_fwdEngine_shortcutCheckFrag_afterModify(rtk_rg_pktHdr_t *pPktHdr, int32 flowHitIdx)
{
	rtk_rg_napt_shortcut_t *pNaptSc;
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	if(rg_db.systemGlobal.fragShortcut_off)return;

	pNaptSc=&rg_db.naptShortCut[flowHitIdx];
	if(pNaptSc->isNapt)
	{
		if(pNaptSc->direction==NAPT_DIRECTION_OUTBOUND)
		{
			_rtk_rg_fwdEngine_fillOutFragmentInfo(RG_FWDENGINE_RET_CONTINUE,pNaptSc->naptIdx,pPktHdr,&pFragList);
			DEBUG("fragList flowHitIdx is %d",flowHitIdx);
			pFragList->flowHitIdx=flowHitIdx;
			if(pPktHdr->tagif&TCP_TAGIF)
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
			else	//UDP
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
		}
		else
		{
			_rtk_rg_fwdEngine_fillInFragmentInfo(RG_FWDENGINE_RET_CONTINUE,pNaptSc->naptIdx,NULL,pPktHdr,&pFragInList);
			DEBUG("fragInList flowHitIdx is %d",flowHitIdx);
			pFragInList->flowHitIdx=flowHitIdx;
			if(pPktHdr->tagif&TCP_TAGIF)
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
			else	//UDP
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,0,0,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),0,0));
		}
	}
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_fragmentsShortcut(rtk_rg_pktHdr_t *pPktHdr, int32 *pFlowHitIdx)
{
	rtk_rg_fwdEngineReturn_t ret=RG_FWDENGINE_RET_CONTINUE;
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	if(rg_db.systemGlobal.fragShortcut_off)return ret;

	//since we can not decide direction here, we just try to lookup each direction!
	_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
	if(pFragList && pFragList->fragAction!=RG_FWDENGINE_RET_QUEUE_FRAG)
	{
		//Check frag action from first packet
		if(pFragList->flowHitIdx>=0)
		{
			rtk_rg_napt_shortcut_t *pNaptSc=&rg_db.naptShortCut[pFragList->flowHitIdx];
			if(pNaptSc->isNapt &&
				pNaptSc->sip==pPktHdr->ipv4Sip &&
				pNaptSc->dip==pPktHdr->ipv4Dip &&
				pNaptSc->sport==pFragList->pktInfo.napt.sport &&
				pNaptSc->dport==pFragList->pktInfo.napt.dport &&
				((pNaptSc->isTcp==0 && (pFragList->layer4Type&UDP_TAGIF))||
				(pNaptSc->isTcp && (pFragList->layer4Type&TCP_TAGIF))))
				TRACE("SC Match! use it.");
			else	//unmatch, clear it!
				pFragList->flowHitIdx=FAIL;
		}
		*pFlowHitIdx=pFragList->flowHitIdx;
		ret=pFragList->fragAction;
		TRACE("do frag action(%d)", ret);
		//20200116LUKE: if the flow match or fragAction is drop/trap, increase counter and free frag list if necessary.
		if(pFragList->flowHitIdx>=0 || ret==RG_FWDENGINE_RET_DROP || ret==RG_FWDENGINE_RET_TO_PS)
		{
			//add received length here for action not queue_frag.
			pFragList->receivedLength+=pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;

			//forward, drop, or trap
			//DEBUG("later fragment modify...");
			if(pPktHdr->ipv4MoreFragment == 0)		//we can not free fragList here, unless there are all packets had forwarded
				pFragList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
			//DEBUG("totalLength is %d",pFragList->totalLength);
			//Check total fragment length
			if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
			{
				DEBUG("[outBound]fragments(%d) are all received(%d)!! free the list %p...",pFragList->totalLength,pFragList->receivedLength,pFragList);
				_rtk_rg_freeFragOutList(pFragList);	//although pFragList is return to free list, since we still hold ipv4FragOutLock, there is no one can acquire this "free" entry.
			}
		}
		return ret;
	}

	_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, 0);
	if(pFragInList && pFragInList->fragAction!=RG_FWDENGINE_RET_QUEUE_FRAG)
	{
		//Check frag action from first packet
		if(pFragInList->flowHitIdx>=0)
		{
			rtk_rg_napt_shortcut_t *pNaptSc=&rg_db.naptShortCut[pFragInList->flowHitIdx];
			if(pNaptSc->isNapt &&
				pNaptSc->sip==pPktHdr->ipv4Sip &&
				pNaptSc->dip==pPktHdr->ipv4Dip &&
				pNaptSc->sport==pFragInList->pktInfo.napt.sport &&
				pNaptSc->dport==pFragInList->pktInfo.napt.dport &&
				((pNaptSc->isTcp==0 && (pFragInList->layer4Type&UDP_TAGIF))||
				(pNaptSc->isTcp && (pFragInList->layer4Type&TCP_TAGIF))))
				TRACE("SC Match! use it.");
			else	//unmatch, clear it!
				pFragInList->flowHitIdx=FAIL;
		}
		*pFlowHitIdx=pFragInList->flowHitIdx;
		ret=pFragInList->fragAction;
		TRACE("do frag action(%d)", ret);
		//20200116LUKE: if the flow match or fragAction is drop/trap, increase counter and free frag list if necessary.
		if(pFragInList->flowHitIdx>=0 || ret==RG_FWDENGINE_RET_DROP || ret==RG_FWDENGINE_RET_TO_PS)
		{
			//add received length here for action not queue_frag.
			pFragInList->receivedLength+=pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;

			//forward, drop, or trap
			DEBUG("later fragment modify...");
			if(pPktHdr->ipv4MoreFragment == 0)		//we can not free fragList here, unless there are all packets had forwarded
				pFragInList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
			//DEBUG("totalLength is %d",pFragInList->totalLength);
			//Check total fragment length
			if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
			{
				DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
				_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
			}
		}
		return ret;
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

#endif

#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
void _rtk_rg_fwdEngine_ipv6ConnList_del(rtk_rg_ipv6_layer4_linkList_t *pConnList)
{
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	int ret;
#endif
	//this function do not protect by semaphore, please take care at outside caller function!!
	rtk_rg_ipv6_layer4_linkList_t *pPairConnList=pConnList->pPair_list;
	//DEBUG("[Before pair del]: pConnList->prev=%p, pConnList->next=%p",pConnList->layer4_list.prev,pConnList->layer4_list.next);
	if(pPairConnList!=NULL)
	{

		TABLE("del v6 stateful list[%p]'s pair list[%p], too.", pConnList, pPairConnList);
		//TRACE("Delete LIST[%p]'s PAIR[%p],too!!",pConnList,pPairConnList);
		//DEBUG("[Before pair del]: pPairConnList->prev=%p, pPairConnList->next=%p",pPairConnList->layer4_list.prev,pPairConnList->layer4_list.next);
		list_del_init(&pPairConnList->layer4_list);
		//DEBUG("[After pair del]: pConnList->prev=%p, pConnList->next=%p",pConnList->layer4_list.prev,pConnList->layer4_list.next);

		pPairConnList->state=INVALID;
		pPairConnList->valid=0;
		pPairConnList->pPair_list=NULL;
		atomic_dec(&rg_db.systemGlobal.v6StatefulConnectionNum);
		//Add back to free list
		list_add(&pPairConnList->layer4_list,&rg_db.ipv6Layer4FreeListHead);
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
		if(pConnList->direction==NAPT_DIRECTION_OUTBOUND || pConnList->direction==NAPT_DIRECTION_INBOUND){
			ret=_rtk_rg_ipv6_naptExtPortFree(pConnList->isTCP,pConnList->externalPort);
			if(ret!=RG_RET_SUCCESS)
				DEBUG("_rtk_rg_ipv6_naptExtPortFree FAIL!");
		}
#endif

	}

	//Force replace the victim and it's pair
	list_del_init(&pConnList->layer4_list);
	pConnList->state=INVALID;
	pConnList->valid=0;
	pConnList->pPair_list=NULL;
	atomic_dec(&rg_db.systemGlobal.v6StatefulConnectionNum);
	//Add back to free list
	list_add(&pConnList->layer4_list,&rg_db.ipv6Layer4FreeListHead);
	TABLE("del v6 stateful list[%p].", pConnList);
}

rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_ipv6ConnList_LRU(uint32 hashIndex)
{
	int i,checkHash=hashIndex,longest_idle=-1;
	rtk_rg_ipv6_layer4_linkList_t *pTmpList,*pLongestIdleList=NULL;

	for(i=0;i<MAX_IPV6_STATEFUL_HASH_HEAD_SIZE;i++)
	{
		if(!list_empty(&rg_db.ipv6Layer4HashListHead[checkHash]))
		{
			list_for_each_entry(pTmpList,&rg_db.ipv6Layer4HashListHead[checkHash],layer4_list)
			{
				WARNING("pTmpList[%p]->idleSecs is %d",pTmpList,pTmpList->idleSecs);
				//Lookup for the longest idleSecs
				if(longest_idle<0 || pTmpList->idleSecs>longest_idle)
				{
					WARNING("pTmpList[%p] is longest idle!!",pTmpList);
					pLongestIdleList=pTmpList;
					longest_idle=pTmpList->idleSecs;
				}
			}
			WARNING("FORCED REPLACE LIST[%p] in hash[%d]!!",pLongestIdleList,checkHash);
			_rtk_rg_fwdEngine_ipv6ConnList_del(pLongestIdleList);

			return RG_RET_SUCCESS;
		}
		checkHash++;
		if(checkHash>=MAX_IPV6_STATEFUL_HASH_HEAD_SIZE)checkHash=0;
	}
	return RG_RET_FAIL;
}

rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_ipv6ConnList_get(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, uint32 hashIndex)
{
	rtk_rg_ipv6_layer4_linkList_t *pListEntry;

	//------------------ Critical Section start -----------------------//
	rg_lock(&rg_kernel.ipv6StatefulLock);

	//Check if we have not-used free arp list
	if(list_empty(&rg_db.ipv6Layer4FreeListHead))
	{
		WARNING("all free IPv6 ConnList are allocated...LRU is needed!!");
		if(_rtk_rg_fwdEngine_ipv6ConnList_LRU(hashIndex)!=RG_RET_SUCCESS)
		{
			//------------------ Critical Section End -----------------------//
			rg_unlock(&rg_kernel.ipv6StatefulLock);
			return RG_RET_FAIL;
		}
	}

	//Get one from free list
	pListEntry=list_first_entry(&rg_db.ipv6Layer4FreeListHead, rtk_rg_ipv6_layer4_linkList_t, layer4_list);
	list_del_init(&pListEntry->layer4_list);

 	DEBUG("the free IPv6 ConnList %p",pListEntry);

	atomic_inc(&rg_db.systemGlobal.v6StatefulConnectionNum);
	//Add to hash head list
	list_add(&pListEntry->layer4_list,&rg_db.ipv6Layer4HashListHead[hashIndex]);
	//------------------ Critical Section End -----------------------//
	rg_unlock(&rg_kernel.ipv6StatefulLock);

	*pIPv6ConnList=pListEntry;

	return RG_RET_SUCCESS;
}

void _rtk_rg_fwdEngine_ipv6ConnList_lookup(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, int32 *pHashIndex, uint8 *srcIP, uint8 *destIP, uint16 srcPort, uint16 destPort, int isTCP, int isFrag)
{
	rtk_rg_ipv6_layer4_linkList_t *pTempList;

	//DEBUG("pHashIndex before search = %d",*pHashIndex);
	if(*pHashIndex<0)
	{
		if(isTCP)
			*pHashIndex=_rtk_rg_ipv6StatefulHashIndex(0x6,srcIP,destIP,srcPort,destPort);
		else
			*pHashIndex=_rtk_rg_ipv6StatefulHashIndex(0x11,srcIP,destIP,srcPort,destPort);
	}

	DEBUG(" srcIP %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x   Sport:%d",
		srcIP[0],srcIP[1],srcIP[2],srcIP[3],
		srcIP[4],srcIP[5],srcIP[6],srcIP[7],
		srcIP[8],srcIP[9],srcIP[10],srcIP[11],
		srcIP[12],srcIP[13],srcIP[14],srcIP[15],
		srcPort);

	DEBUG(" destIP %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x   Dport:%d",
		destIP[0],destIP[1],destIP[2],destIP[3],
		destIP[4],destIP[5],destIP[6],destIP[7],
		destIP[8],destIP[9],destIP[10],destIP[11],
		destIP[12],destIP[13],destIP[14],destIP[15],
		destPort);
	DEBUG(" isTcp=%d  isFrag=%d",isTCP,isFrag);


	TRACE("hash idx is %d",*pHashIndex);
	//*pIPv6ConnList=NULL;
	//------------------ Critical Section start -----------------------//
	rg_lock(&rg_kernel.ipv6StatefulLock);
	if(!list_empty(&rg_db.ipv6Layer4HashListHead[*pHashIndex]))
	{
		//TRACE("head[%d] is not empty!",*pHashIndex);
		list_for_each_entry(pTempList,&rg_db.ipv6Layer4HashListHead[*pHashIndex],layer4_list)
		{
			//TRACE("Comparing pTempList is %p, srcport:%d, destport:%d",pTempList,pTempList->srcPort,pTempList->destPort);

			DEBUG(" pTempList.srcIP %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x   pTempList->Sport:%d",
				pTempList->srcIP.ipv6_addr[0],pTempList->srcIP.ipv6_addr[1],pTempList->srcIP.ipv6_addr[2],pTempList->srcIP.ipv6_addr[3],
				pTempList->srcIP.ipv6_addr[4],pTempList->srcIP.ipv6_addr[5],pTempList->srcIP.ipv6_addr[6],pTempList->srcIP.ipv6_addr[7],
				pTempList->srcIP.ipv6_addr[8],pTempList->srcIP.ipv6_addr[9],pTempList->srcIP.ipv6_addr[10],pTempList->srcIP.ipv6_addr[11],
				pTempList->srcIP.ipv6_addr[12],pTempList->srcIP.ipv6_addr[13],pTempList->srcIP.ipv6_addr[14],pTempList->srcIP.ipv6_addr[15],
				pTempList->srcPort);

			DEBUG(" pTempList.destIP %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x   pTempList->Dport:%d",
				pTempList->destIP.ipv6_addr[0],pTempList->destIP.ipv6_addr[1],pTempList->destIP.ipv6_addr[2],pTempList->destIP.ipv6_addr[3],
				pTempList->destIP.ipv6_addr[4],pTempList->destIP.ipv6_addr[5],pTempList->destIP.ipv6_addr[6],pTempList->destIP.ipv6_addr[7],
				pTempList->destIP.ipv6_addr[8],pTempList->destIP.ipv6_addr[9],pTempList->destIP.ipv6_addr[10],pTempList->destIP.ipv6_addr[11],
				pTempList->destIP.ipv6_addr[12],pTempList->destIP.ipv6_addr[13],pTempList->destIP.ipv6_addr[14],pTempList->destIP.ipv6_addr[15],
				pTempList->destPort);

			DEBUG(" pTempList.notFinishUpdated=%d",pTempList->notFinishUpdated);


			if(pTempList->isTCP==isTCP && pTempList->notFinishUpdated==0 && pTempList->isFrag==isFrag &&
				!memcmp(pTempList->srcIP.ipv6_addr,srcIP,IPV6_ADDR_LEN) &&
				!memcmp(pTempList->destIP.ipv6_addr,destIP,IPV6_ADDR_LEN) &&
				pTempList->srcPort==srcPort && pTempList->destPort==destPort)
			{
				//Hit!!
				*pIPv6ConnList=pTempList;
				TRACE("Found *pIPv6ConnList is %p",*pIPv6ConnList);
				break;
			}
		}

	}
	TRACE("end of ipv6ConnList lookup..");
	//------------------ Critical Section End -----------------------//
	rg_unlock(&rg_kernel.ipv6StatefulLock);
}

rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_fillIpv6StatefulInfo(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, uint32 hashIndex, rtk_rg_pktHdr_t *pPktHdr)
{
	int isTCP=0;
	rtk_rg_successFailReturn_t ret;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	int extport=0;
	int32	pairboundhashIndex;
	rtk_rg_ipv6_layer4_linkList_t *pPairboundIPv6ConnList=NULL;
#endif

	if(pPktHdr->tagif&TCP_TAGIF) isTCP=1;

	ret=_rtk_rg_fwdEngine_ipv6ConnList_get(pIPv6ConnList,hashIndex);
	if(ret==RG_RET_FAIL)return RG_RET_FAIL;

	//fill all information abount this connection
	memcpy((*pIPv6ConnList)->srcIP.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN);
	memcpy((*pIPv6ConnList)->destIP.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN);
	(*pIPv6ConnList)->srcPort=pPktHdr->sport;
	(*pIPv6ConnList)->destPort=pPktHdr->dport;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT){
		extport = _rtk_rg_ipv6_naptExtPortGetAndUse(isTCP,pPktHdr->sport);
		memcpy((*pIPv6ConnList)->internalIP.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN);
		(*pIPv6ConnList)->externalPort=extport;
		(*pIPv6ConnList)->internalPort=pPktHdr->sport;
		(*pIPv6ConnList)->extipIdx=pPktHdr->extipIdx;
		(*pIPv6ConnList)->direction=NAPT_DIRECTION_OUTBOUND; //???
	}else if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR){
		extport = _rtk_rg_ipv6_naptExtPortGetAndUse(isTCP,pPktHdr->dport);
		memcpy((*pIPv6ConnList)->internalIP.ipv6_addr,pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,IPV6_ADDR_LEN);
		(*pIPv6ConnList)->externalPort=pPktHdr->dport;
		(*pIPv6ConnList)->internalPort=pPktHdr->ipv6_serverInLanLookup.transPort;
		(*pIPv6ConnList)->extipIdx=pPktHdr->extipIdx;
		(*pIPv6ConnList)->direction=NAPT_DIRECTION_INBOUND; //???
	}
#endif
	(*pIPv6ConnList)->isTCP=isTCP;
	(*pIPv6ConnList)->spa=pPktHdr->ingressPort;
	(*pIPv6ConnList)->srcWlanDevIdx=pPktHdr->wlan_dev_idx;
	(*pIPv6ConnList)->state=INVALID;
	(*pIPv6ConnList)->idleSecs=0;
	(*pIPv6ConnList)->pPair_list=NULL;
	(*pIPv6ConnList)->valid=1;
	(*pIPv6ConnList)->notFinishUpdated=1;	//not finished

	(*pIPv6ConnList)->isFrag=0;
	(*pIPv6ConnList)->fragAction=RG_FWDENGINE_RET_UN_INIT;
	(*pIPv6ConnList)->beginIdleTime=jiffies;
	(*pIPv6ConnList)->queueCount=0;
	(*pIPv6ConnList)->receivedLength=0;
	(*pIPv6ConnList)->totalLength=0;
	(*pIPv6ConnList)->netifIdx=pPktHdr->netifIdx;
	(*pIPv6ConnList)->dmacL2Idx=pPktHdr->dmacL2Idx;
	//20150922LUKE: keep Neighbor idx in stateful for updating.
	(*pIPv6ConnList)->neighborIdx=_rtk_rg_shortcutNEIGHBORFind(pPktHdr->pIpv6Sip);
	(*pIPv6ConnList)->smacL2Idx=pPktHdr->smacL2Idx;



#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	//if NAPT, also fill inipvInboundConn!
	if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT){

			if(isTCP){
				pairboundhashIndex=_rtk_rg_ipv6StatefulHashIndex(0x6,pPktHdr->pIpv6Dip,rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr,pPktHdr->dport,extport);
			}else{
				pairboundhashIndex=_rtk_rg_ipv6StatefulHashIndex(0x11,pPktHdr->pIpv6Dip,rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr,pPktHdr->dport,extport);
			}
			//DEBUG("inboundhashIndex=%d",inboundhashIndex);
			ret=_rtk_rg_fwdEngine_ipv6ConnList_get(&pPairboundIPv6ConnList,pairboundhashIndex);
			if(ret==RG_RET_FAIL)return RG_RET_FAIL;

			//fill all information abount this connection
			memcpy((pPairboundIPv6ConnList)->srcIP.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN);
			memcpy((pPairboundIPv6ConnList)->destIP.ipv6_addr,rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr,IPV6_ADDR_LEN);
			memcpy((pPairboundIPv6ConnList)->internalIP.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN);
			(pPairboundIPv6ConnList)->srcPort=pPktHdr->dport;
			(pPairboundIPv6ConnList)->destPort=extport;
			(pPairboundIPv6ConnList)->internalPort=pPktHdr->sport;
			(pPairboundIPv6ConnList)->externalPort=extport;
			(pPairboundIPv6ConnList)->extipIdx=pPktHdr->extipIdx;
			(pPairboundIPv6ConnList)->isTCP=isTCP;
			(pPairboundIPv6ConnList)->spa=RTK_RG_PORT_MAX;
			(pPairboundIPv6ConnList)->srcWlanDevIdx=FAIL;
			(pPairboundIPv6ConnList)->state=INVALID;
			(pPairboundIPv6ConnList)->idleSecs=0;
			(pPairboundIPv6ConnList)->valid=1;
			(pPairboundIPv6ConnList)->isFrag=0;
			(pPairboundIPv6ConnList)->fragAction=RG_FWDENGINE_RET_UN_INIT;
			(pPairboundIPv6ConnList)->beginIdleTime=0;
			(pPairboundIPv6ConnList)->queueCount=0;
			(pPairboundIPv6ConnList)->netifIdx=pPktHdr->srcNetifIdx;
			(pPairboundIPv6ConnList)->dmacL2Idx=pPktHdr->smacL2Idx;
			//20151012LUKE: keep Neighbor idx in stateful for updating.
			(pPairboundIPv6ConnList)->neighborIdx=_rtk_rg_shortcutNEIGHBORFind(pPktHdr->pIpv6Dip);
			(pPairboundIPv6ConnList)->smacL2Idx=pPktHdr->dmacL2Idx;
			(pPairboundIPv6ConnList)->pPair_list=(*pIPv6ConnList);
			(pPairboundIPv6ConnList)->direction=NAPT_DIRECTION_INBOUND;
			(pPairboundIPv6ConnList)->notFinishUpdated=0;	//finished, just create for inbound

			//set outbound pIPv6ConnList pPair_list
			(*pIPv6ConnList)->pPair_list=pPairboundIPv6ConnList;

	}else if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR){
		if(isTCP){
			pairboundhashIndex=_rtk_rg_ipv6StatefulHashIndex(0x6,pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,pPktHdr->pIpv6Sip,pPktHdr->ipv6_serverInLanLookup.transPort,pPktHdr->sport);
		}else{
			pairboundhashIndex=_rtk_rg_ipv6StatefulHashIndex(0x11,pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,pPktHdr->pIpv6Sip,pPktHdr->ipv6_serverInLanLookup.transPort,pPktHdr->sport);
		}

		//DEBUG("inboundhashIndex=%d",inboundhashIndex);
		ret=_rtk_rg_fwdEngine_ipv6ConnList_get(&pPairboundIPv6ConnList,pairboundhashIndex);
		if(ret==RG_RET_FAIL)return RG_RET_FAIL;

		//fill all information about this connection
		memcpy((pPairboundIPv6ConnList)->srcIP.ipv6_addr,pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,IPV6_ADDR_LEN);
		memcpy((pPairboundIPv6ConnList)->destIP.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN);
		memcpy((pPairboundIPv6ConnList)->internalIP.ipv6_addr,pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr,IPV6_ADDR_LEN);
		(pPairboundIPv6ConnList)->srcPort=pPktHdr->ipv6_serverInLanLookup.transPort;
		(pPairboundIPv6ConnList)->destPort=pPktHdr->sport;
		(pPairboundIPv6ConnList)->internalPort=pPktHdr->ipv6_serverInLanLookup.transPort;
		(pPairboundIPv6ConnList)->externalPort=extport;
		(pPairboundIPv6ConnList)->extipIdx=pPktHdr->extipIdx;//is this valid when outbound?
		(pPairboundIPv6ConnList)->isTCP=isTCP;
		(pPairboundIPv6ConnList)->spa=RTK_RG_PORT_MAX;
		(pPairboundIPv6ConnList)->srcWlanDevIdx=FAIL;
		(pPairboundIPv6ConnList)->state=INVALID;
		(pPairboundIPv6ConnList)->idleSecs=0;
		(pPairboundIPv6ConnList)->valid=1;
		(pPairboundIPv6ConnList)->isFrag=0;
		(pPairboundIPv6ConnList)->fragAction=RG_FWDENGINE_RET_UN_INIT;
		(pPairboundIPv6ConnList)->beginIdleTime=0;
		(pPairboundIPv6ConnList)->queueCount=0;
		(pPairboundIPv6ConnList)->netifIdx=pPktHdr->netifIdx;//is this valid when outbound?
		(pPairboundIPv6ConnList)->dmacL2Idx=pPktHdr->smacL2Idx;
		//20151012LUKE: keep Neighbor idx in stateful for updating.
		(pPairboundIPv6ConnList)->neighborIdx=_rtk_rg_shortcutNEIGHBORFind(pPktHdr->ipv6_serverInLanLookup.transIP.ipv6_addr);
		(pPairboundIPv6ConnList)->smacL2Idx=pPktHdr->dmacL2Idx;
		(pPairboundIPv6ConnList)->pPair_list=(*pIPv6ConnList);
		(pPairboundIPv6ConnList)->direction=NAPT_DIRECTION_OUTBOUND;
		(pPairboundIPv6ConnList)->notFinishUpdated=0;	//finished, just create for inbound

		//set outbound pIPv6ConnList pPair_list
		(*pIPv6ConnList)->pPair_list=pPairboundIPv6ConnList;

	}


	//DEBUG("pPktHdr->extipIdx=%d",pPktHdr->extipIdx);
	TABLE("Add IPv6 Connection(valid=%d, state=%d, isFrag=%d, direction=%d, neighbor=%d) ==> from SIP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x SPort:%d (extIP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x extPort:%d)--> DIP: %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x DPort:%d\n",
		(*pIPv6ConnList)->valid,(*pIPv6ConnList)->state,(*pIPv6ConnList)->isFrag,(*pIPv6ConnList)->direction,(*pIPv6ConnList)->neighborIdx,
		(*pIPv6ConnList)->srcIP.ipv6_addr[0],(*pIPv6ConnList)->srcIP.ipv6_addr[1],(*pIPv6ConnList)->srcIP.ipv6_addr[2],(*pIPv6ConnList)->srcIP.ipv6_addr[3],
		(*pIPv6ConnList)->srcIP.ipv6_addr[4],(*pIPv6ConnList)->srcIP.ipv6_addr[5],(*pIPv6ConnList)->srcIP.ipv6_addr[6],(*pIPv6ConnList)->srcIP.ipv6_addr[7],
		(*pIPv6ConnList)->srcIP.ipv6_addr[8],(*pIPv6ConnList)->srcIP.ipv6_addr[9],(*pIPv6ConnList)->srcIP.ipv6_addr[10],(*pIPv6ConnList)->srcIP.ipv6_addr[11],
		(*pIPv6ConnList)->srcIP.ipv6_addr[12],(*pIPv6ConnList)->srcIP.ipv6_addr[13],(*pIPv6ConnList)->srcIP.ipv6_addr[14],(*pIPv6ConnList)->srcIP.ipv6_addr[15],
		(*pIPv6ConnList)->srcPort,
		rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[0],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[1],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[2],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[3],
		rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[4],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[5],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[6],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[7],
		rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[8],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[9],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[10],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[11],
		rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[12],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[13],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[14],rg_db.v6Extip[pPktHdr->extipIdx].externalIp.ipv6_addr[15],
		(*pIPv6ConnList)->externalPort,
		(*pIPv6ConnList)->destIP.ipv6_addr[0],(*pIPv6ConnList)->destIP.ipv6_addr[1],(*pIPv6ConnList)->destIP.ipv6_addr[2],(*pIPv6ConnList)->destIP.ipv6_addr[3],
		(*pIPv6ConnList)->destIP.ipv6_addr[4],(*pIPv6ConnList)->destIP.ipv6_addr[5],(*pIPv6ConnList)->destIP.ipv6_addr[6],(*pIPv6ConnList)->destIP.ipv6_addr[7],
		(*pIPv6ConnList)->destIP.ipv6_addr[8],(*pIPv6ConnList)->destIP.ipv6_addr[9],(*pIPv6ConnList)->destIP.ipv6_addr[10],(*pIPv6ConnList)->destIP.ipv6_addr[11],
		(*pIPv6ConnList)->destIP.ipv6_addr[12],(*pIPv6ConnList)->destIP.ipv6_addr[13],(*pIPv6ConnList)->destIP.ipv6_addr[14],(*pIPv6ConnList)->destIP.ipv6_addr[15],
		(*pIPv6ConnList)->destPort);

	if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT || pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR ){
		TABLE("Add IPv6 pair Connection(valid=%d, state=%d, isFrag=%d, direction=%d, neighbor=%d) ==> from SIP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x SPort:%d --> GatewaIP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x extPort:%d (internalIP:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x internalPort:%d)\n",
			(pPairboundIPv6ConnList)->valid,(pPairboundIPv6ConnList)->state,(pPairboundIPv6ConnList)->isFrag,(pPairboundIPv6ConnList)->direction,(pPairboundIPv6ConnList)->neighborIdx,
			(pPairboundIPv6ConnList)->srcIP.ipv6_addr[0],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[1],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[2],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[3],
			(pPairboundIPv6ConnList)->srcIP.ipv6_addr[4],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[5],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[6],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[7],
			(pPairboundIPv6ConnList)->srcIP.ipv6_addr[8],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[9],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[10],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[11],
			(pPairboundIPv6ConnList)->srcIP.ipv6_addr[12],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[13],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[14],(pPairboundIPv6ConnList)->srcIP.ipv6_addr[15],
			(pPairboundIPv6ConnList)->srcPort,
			(pPairboundIPv6ConnList)->destIP.ipv6_addr[0],(pPairboundIPv6ConnList)->destIP.ipv6_addr[1],(pPairboundIPv6ConnList)->destIP.ipv6_addr[2],(pPairboundIPv6ConnList)->destIP.ipv6_addr[3],
			(pPairboundIPv6ConnList)->destIP.ipv6_addr[4],(pPairboundIPv6ConnList)->destIP.ipv6_addr[5],(pPairboundIPv6ConnList)->destIP.ipv6_addr[6],(pPairboundIPv6ConnList)->destIP.ipv6_addr[7],
			(pPairboundIPv6ConnList)->destIP.ipv6_addr[8],(pPairboundIPv6ConnList)->destIP.ipv6_addr[9],(pPairboundIPv6ConnList)->destIP.ipv6_addr[10],(pPairboundIPv6ConnList)->destIP.ipv6_addr[11],
			(pPairboundIPv6ConnList)->destIP.ipv6_addr[12],(pPairboundIPv6ConnList)->destIP.ipv6_addr[13],(pPairboundIPv6ConnList)->destIP.ipv6_addr[14],(pPairboundIPv6ConnList)->destIP.ipv6_addr[15],
			(pPairboundIPv6ConnList)->destPort,
			(pPairboundIPv6ConnList)->internalIP.ipv6_addr[0],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[1],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[2],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[3],
			(pPairboundIPv6ConnList)->internalIP.ipv6_addr[4],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[5],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[6],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[7],
			(pPairboundIPv6ConnList)->internalIP.ipv6_addr[8],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[9],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[10],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[11],
			(pPairboundIPv6ConnList)->internalIP.ipv6_addr[12],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[13],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[14],(pPairboundIPv6ConnList)->internalIP.ipv6_addr[15],
			(pPairboundIPv6ConnList)->internalPort);
	}

#else
	TABLE("Add IPv6 Connection ==> from %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x Port:%d --> %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x Port:%d\n",
		(*pIPv6ConnList)->srcIP.ipv6_addr[0],(*pIPv6ConnList)->srcIP.ipv6_addr[1],(*pIPv6ConnList)->srcIP.ipv6_addr[2],(*pIPv6ConnList)->srcIP.ipv6_addr[3],
		(*pIPv6ConnList)->srcIP.ipv6_addr[4],(*pIPv6ConnList)->srcIP.ipv6_addr[5],(*pIPv6ConnList)->srcIP.ipv6_addr[6],(*pIPv6ConnList)->srcIP.ipv6_addr[7],
		(*pIPv6ConnList)->srcIP.ipv6_addr[8],(*pIPv6ConnList)->srcIP.ipv6_addr[9],(*pIPv6ConnList)->srcIP.ipv6_addr[10],(*pIPv6ConnList)->srcIP.ipv6_addr[11],
		(*pIPv6ConnList)->srcIP.ipv6_addr[12],(*pIPv6ConnList)->srcIP.ipv6_addr[13],(*pIPv6ConnList)->srcIP.ipv6_addr[14],(*pIPv6ConnList)->srcIP.ipv6_addr[15],
		(*pIPv6ConnList)->srcPort,
		(*pIPv6ConnList)->destIP.ipv6_addr[0],(*pIPv6ConnList)->destIP.ipv6_addr[1],(*pIPv6ConnList)->destIP.ipv6_addr[2],(*pIPv6ConnList)->destIP.ipv6_addr[3],
		(*pIPv6ConnList)->destIP.ipv6_addr[4],(*pIPv6ConnList)->destIP.ipv6_addr[5],(*pIPv6ConnList)->destIP.ipv6_addr[6],(*pIPv6ConnList)->destIP.ipv6_addr[7],
		(*pIPv6ConnList)->destIP.ipv6_addr[8],(*pIPv6ConnList)->destIP.ipv6_addr[9],(*pIPv6ConnList)->destIP.ipv6_addr[10],(*pIPv6ConnList)->destIP.ipv6_addr[11],
		(*pIPv6ConnList)->destIP.ipv6_addr[12],(*pIPv6ConnList)->destIP.ipv6_addr[13],(*pIPv6ConnList)->destIP.ipv6_addr[14],(*pIPv6ConnList)->destIP.ipv6_addr[15],
		(*pIPv6ConnList)->destPort);
#endif

	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_fwdEngine_fillIpv6StatefulFragmentInfo(rtk_rg_ipv6_layer4_linkList_t **pIPv6FragList, rtk_rg_pktHdr_t *pPktHdr)
{
	int isTCP=0,hashIndex;
	rtk_rg_successFailReturn_t ret;

	if(pPktHdr->ipProtocol==0x6) isTCP=1;

	if(isTCP)
		hashIndex=_rtk_rg_ipv6StatefulHashIndex(0x6,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->ipv6FragId_First,pPktHdr->ipv6FragId_Second);
	else
		hashIndex=_rtk_rg_ipv6StatefulHashIndex(0x11,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->ipv6FragId_First,pPktHdr->ipv6FragId_Second);

	ret=_rtk_rg_fwdEngine_ipv6ConnList_get(pIPv6FragList,hashIndex);
	if(ret==RG_RET_FAIL)return RG_RET_FAIL;

	//fill all information abount this connection
	memcpy((*pIPv6FragList)->srcIP.ipv6_addr,pPktHdr->pIpv6Sip,IPV6_ADDR_LEN);
	memcpy((*pIPv6FragList)->destIP.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN);
	(*pIPv6FragList)->srcPort=pPktHdr->ipv6FragId_First;		//use fragment id to hash
	(*pIPv6FragList)->destPort=pPktHdr->ipv6FragId_Second;		//use fragment id to hash
	(*pIPv6FragList)->isTCP=isTCP;
	(*pIPv6FragList)->spa=pPktHdr->ingressPort;
	(*pIPv6FragList)->srcWlanDevIdx=pPktHdr->wlan_dev_idx;
	(*pIPv6FragList)->state=INVALID;
	(*pIPv6FragList)->idleSecs=0;
	(*pIPv6FragList)->pPair_list=NULL;
	(*pIPv6FragList)->valid=1;
	(*pIPv6FragList)->notFinishUpdated=0;	//fragment no need update

	(*pIPv6FragList)->isFrag=1;
	(*pIPv6FragList)->fragAction=RG_FWDENGINE_RET_DROP;
	(*pIPv6FragList)->beginIdleTime=jiffies;
	(*pIPv6FragList)->receivedLength=pPktHdr->ipv6PayloadLen;
	if(!pPktHdr->ipv6MoreFragment)
		(*pIPv6FragList)->totalLength=(pPktHdr->ipv6FragmentOffset<<3)+(*pIPv6FragList)->receivedLength;
	else
		(*pIPv6FragList)->totalLength=0;
	DEBUG("fillInfo, received is %d, total is %d",(*pIPv6FragList)->receivedLength,(*pIPv6FragList)->totalLength);
	(*pIPv6FragList)->queueCount=0;

	(*pIPv6FragList)->netifIdx=pPktHdr->netifIdx;
	(*pIPv6FragList)->dmacL2Idx=pPktHdr->dmacL2Idx;
	(*pIPv6FragList)->smacL2Idx=pPktHdr->smacL2Idx;

	TABLE("Add IPv6 FragList ==> from %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x --> %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x ID:%04x%04x\n",
		(*pIPv6FragList)->srcIP.ipv6_addr[0],(*pIPv6FragList)->srcIP.ipv6_addr[1],(*pIPv6FragList)->srcIP.ipv6_addr[2],(*pIPv6FragList)->srcIP.ipv6_addr[3],
		(*pIPv6FragList)->srcIP.ipv6_addr[4],(*pIPv6FragList)->srcIP.ipv6_addr[5],(*pIPv6FragList)->srcIP.ipv6_addr[6],(*pIPv6FragList)->srcIP.ipv6_addr[7],
		(*pIPv6FragList)->srcIP.ipv6_addr[8],(*pIPv6FragList)->srcIP.ipv6_addr[9],(*pIPv6FragList)->srcIP.ipv6_addr[10],(*pIPv6FragList)->srcIP.ipv6_addr[11],
		(*pIPv6FragList)->srcIP.ipv6_addr[12],(*pIPv6FragList)->srcIP.ipv6_addr[13],(*pIPv6FragList)->srcIP.ipv6_addr[14],(*pIPv6FragList)->srcIP.ipv6_addr[15],
		(*pIPv6FragList)->destIP.ipv6_addr[0],(*pIPv6FragList)->destIP.ipv6_addr[1],(*pIPv6FragList)->destIP.ipv6_addr[2],(*pIPv6FragList)->destIP.ipv6_addr[3],
		(*pIPv6FragList)->destIP.ipv6_addr[4],(*pIPv6FragList)->destIP.ipv6_addr[5],(*pIPv6FragList)->destIP.ipv6_addr[6],(*pIPv6FragList)->destIP.ipv6_addr[7],
		(*pIPv6FragList)->destIP.ipv6_addr[8],(*pIPv6FragList)->destIP.ipv6_addr[9],(*pIPv6FragList)->destIP.ipv6_addr[10],(*pIPv6FragList)->destIP.ipv6_addr[11],
		(*pIPv6FragList)->destIP.ipv6_addr[12],(*pIPv6FragList)->destIP.ipv6_addr[13],(*pIPv6FragList)->destIP.ipv6_addr[14],(*pIPv6FragList)->destIP.ipv6_addr[15],
		(*pIPv6FragList)->srcPort,(*pIPv6FragList)->destPort);

	return RG_RET_SUCCESS;
}


rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_ipv6TCPOutboundConnectionTracking(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, rtk_rg_pktHdr_t *pPktHdr)
{
	int32 ret;

	//*pIPv6ConnList=NULL;
	//look up if we add this connection before
	_rtk_rg_fwdEngine_ipv6ConnList_lookup(pIPv6ConnList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,1,0);

	if(!((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0)))
	{
		//Connection not found, and not SYN packet, drop..
		if((*pIPv6ConnList)==NULL)
		{
			TRACE("[Drop] Connection isn't found and isn't SYN packet, drop it!");
			return RG_FWDENGINE_RET_DROP;
		}
	}

	if((*pIPv6ConnList)!=NULL && (*pIPv6ConnList)->state==TCP_CONNECTED)
	{
		if(pPktHdr->tcpFlags.fin==1)
		{
			//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			(*pIPv6ConnList)->state=FIRST_FIN;
			if((*pIPv6ConnList)->pPair_list!=NULL)
				(*pIPv6ConnList)->pPair_list->state=FIRST_FIN;
		}
		else if(pPktHdr->tcpFlags.reset==1)
		{
			//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			(*pIPv6ConnList)->state=RST_RECV;
			if((*pIPv6ConnList)->pPair_list!=NULL)
				(*pIPv6ConnList)->pPair_list->state=RST_RECV;
		}
	}
	else
	{
		if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0))
		{
			//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n%p",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset,rg_db.pNaptOutFreeListHead);
			if((*pIPv6ConnList)==NULL)
			{
				ret = _rtk_rg_fwdEngine_fillIpv6StatefulInfo(pIPv6ConnList,pPktHdr->ipv6StatefulHashValue,pPktHdr);
	            if(ret!=RG_RET_SUCCESS)
				{
					TRACE("[Drop] Fail to fill ipv6 stateful list");
					return RG_FWDENGINE_RET_DROP;
				}
				if((*pIPv6ConnList)->state>SYN_RECV)
				{
					WARNING("pIPv6ConnList->state>SYN_RECV=%d",(*pIPv6ConnList)->state);
				}
				(*pIPv6ConnList)->state=SYN_RECV;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
				if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT || pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR){
					if((*pIPv6ConnList)->pPair_list!=NULL)(*pIPv6ConnList)->pPair_list->state=SYN_RECV;
				}
#endif
			}
		}
		else if((pPktHdr->tcpFlags.syn==0)&&(pPktHdr->tcpFlags.ack==1))
		{
			if((*pIPv6ConnList)->state==SYN_ACK_RECV)
			{
				//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
				//assert(rg_db.naptOut[*pNaptOutIdx].state==SYN_ACK_RECV);
				(*pIPv6ConnList)->state=TCP_CONNECTED;
				if((*pIPv6ConnList)->pPair_list!=NULL)
					(*pIPv6ConnList)->pPair_list->state=TCP_CONNECTED;

				TRACE("IPv6 TCP Connection is CONNECTED!");
			}
		}
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
		else if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==1))//Server in Lan case
		{
			DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			if((*pIPv6ConnList)==NULL){
				TRACE("[Drop] not found outbound pIPv6ConnList, DROP!");
				return RG_FWDENGINE_RET_DROP;
			}

			if((*pIPv6ConnList)->pPair_list==NULL){//the pair connList should be add while SYN packet from WAN (Server in Lan case)
				TRACE("[Drop] not found inbound pair pIPv6ConnList, DROP!");
				return RG_FWDENGINE_RET_DROP;
			}

			if((*pIPv6ConnList)->state==INVALID)
			{
				TRACE("[Drop] loss SYN packet, DROP!");
				return RG_FWDENGINE_RET_DROP;
			}

			if((*pIPv6ConnList)->state<=SYN_ACK_RECV)
			{
				(*pIPv6ConnList)->state=SYN_ACK_RECV;
			}
			(*pIPv6ConnList)->state=SYN_ACK_RECV;
			(*pIPv6ConnList)->pPair_list->state=SYN_ACK_RECV;

		}

#endif

	}
	return RG_FWDENGINE_RET_NAPT_OK;
}
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_ipv6TCPInboundConnectionTracking(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, rtk_rg_pktHdr_t *pPktHdr)
{
	int32 ret;
	rtk_rg_ipv6_layer4_linkList_t *pIPv6OutboundList=NULL,*pIPv6InboundList=NULL;

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	if(pPktHdr->fwdDecision!=RG_FWD_DECISION_V6NAPTR)//{ //The inbound connection is already added while NAPT outbound process.
#endif
	{
		//look up if we add outbound list before
		_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pIPv6OutboundList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Dip,pPktHdr->pIpv6Sip,pPktHdr->dport,pPktHdr->sport,1,0);
	}
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	/*}*/else{
		if(pPktHdr->ipv6_serverInLanLookup.serverInLanHit!=RTK_RG_IPV6_LOOKUP_NONE_HIT){
			//Server in lan case: pIPv6OutboundList could be NULL, do not access directly.
			//if it is inbound SYN: it doesn't have setup the connList yet!  the connList will be add after _rtk_rg_fwdEngine_fillIpv6StatefulInfo() called.
			//if it is inbound ACK: it will find the connList.
		}else{
			//Normal inbound case: pIPv6InboundList has been lookup while searching DIP(pPktHdr->pIPv6StatefulList and pPktHdr->ipv6StatefulHashValue have assigned!), look up pIPv6OutboundList list which record in pIPv6InboundList
			pIPv6OutboundList = pPktHdr->pIPv6StatefulList->pPair_list;
			TRACE("Get pIPv6OutboundList[%p] by pair",pIPv6OutboundList);
		}
	}
#endif

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	if(pIPv6OutboundList==NULL && pPktHdr->ipv6_serverInLanLookup.serverInLanHit==RTK_RG_IPV6_LOOKUP_NONE_HIT)
#else
	if(pIPv6OutboundList==NULL)
#endif
	{
		//not server in lan case, the outbound connList should be created when outbound SYN  packet!
		TRACE("[Drop] there is no outbound list...DROP");
		return RG_FWDENGINE_RET_DROP;
	}

	if((pIPv6OutboundList!=NULL) && (pIPv6OutboundList->state==TCP_CONNECTED))
	{
		if(pPktHdr->tcpFlags.fin==1)
		{
			DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			pIPv6OutboundList->state=FIRST_FIN;
			if(pIPv6OutboundList->pPair_list!=NULL)pIPv6OutboundList->pPair_list->state=FIRST_FIN;
		}
		else if(pPktHdr->tcpFlags.reset==1)
		{
			DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			pIPv6OutboundList->state=RST_RECV;
			if(pIPv6OutboundList->pPair_list!=NULL)pIPv6OutboundList->pPair_list->state=RST_RECV;
		}
	}
	else
	{
		DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
		if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==1))
		{
			DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			if(pIPv6OutboundList->state==INVALID)
			{
				TRACE("[Drop] loss SYN packet, DROP!");
				return RG_FWDENGINE_RET_DROP;
			}

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
			if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR){ //The inbound connection is already added while NAPT outbound process. (pIPv6InboundList has been lookup while searching DIP)
				pIPv6InboundList = pPktHdr->pIPv6StatefulList;
				if(pIPv6OutboundList->state<=SYN_ACK_RECV)
				{
					pIPv6OutboundList->state=SYN_ACK_RECV;
				}
				pIPv6InboundList->state=SYN_ACK_RECV;
			}else{
#endif
				pPktHdr->ipv6StatefulHashValue=-1;
				_rtk_rg_fwdEngine_ipv6ConnList_lookup(pIPv6ConnList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,1,0);
				if((*pIPv6ConnList)==NULL)
				{
					ret = _rtk_rg_fwdEngine_fillIpv6StatefulInfo(&pIPv6InboundList,pPktHdr->ipv6StatefulHashValue,pPktHdr);
					if(ret!=RG_RET_SUCCESS)
					{
						TRACE("[Drop] Fail to fill ipv6 stateful list");
						return RG_FWDENGINE_RET_DROP;
					}

					//keep inbound list pointer in outbound list, for deleting when timeout
					pIPv6OutboundList->pPair_list=pIPv6InboundList;

					if(pIPv6OutboundList->state<=SYN_ACK_RECV)
					{
						pIPv6OutboundList->state=SYN_ACK_RECV;
					}
					pIPv6InboundList->state=SYN_ACK_RECV;
					pIPv6InboundList->pPair_list=pIPv6OutboundList;

					*pIPv6ConnList=pIPv6InboundList;
				}

				//keep inbound list pointer in outbound list, for deleting when timeout
				pIPv6OutboundList->pPair_list=pIPv6InboundList;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
			} //End of if pPktHdr->fwdDecision!=RG_FWD_DECISION_V6NAPTR
#endif
			*pIPv6ConnList=pIPv6InboundList;
		}
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
		else if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0))//Server in lan case
		{
			if(pPktHdr->ipv6_serverInLanLookup.serverInLanHit==RTK_RG_IPV6_LOOKUP_NONE_HIT){
				TRACE("[Drop] Drop SYN from WAN, Server in Lan none hit!");
				return RG_FWDENGINE_RET_DROP;
			}

			//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n %p",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset,rg_db.pNaptOutFreeListHead);
			//the connList should not be found, but we have to get an empty connList
			pPktHdr->ipv6StatefulHashValue=-1;
			_rtk_rg_fwdEngine_ipv6ConnList_lookup(pIPv6ConnList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,1,0);

			if((*pIPv6ConnList)==NULL)
			{
				ret = _rtk_rg_fwdEngine_fillIpv6StatefulInfo(pIPv6ConnList,pPktHdr->ipv6StatefulHashValue,pPktHdr);
	            if(ret!=SUCCESS)
				{
					TRACE("[Drop] Fail to fill ipv6 stateful list");
					return RG_FWDENGINE_RET_DROP;
				}
				if((*pIPv6ConnList)->state>SYN_RECV)
				{
					WARNING("pIPv6ConnList->state>SYN_RECV=%d",(*pIPv6ConnList)->state);
				}
				(*pIPv6ConnList)->state=SYN_RECV;
				if((*pIPv6ConnList)->pPair_list!=NULL)
					(*pIPv6ConnList)->pPair_list->state=SYN_RECV;
			}
		}
		else if((pPktHdr->tcpFlags.syn==0)&&(pPktHdr->tcpFlags.ack==1))//Server in lan case
		{
			//the connList should be found
			pPktHdr->ipv6StatefulHashValue=-1;
			_rtk_rg_fwdEngine_ipv6ConnList_lookup(pIPv6ConnList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,1,0);
			if((*pIPv6ConnList)==NULL){
				TRACE("[Drop] pIPv6ConnList not found, drop!");
				return RG_FWDENGINE_RET_DROP;
			}

			if((*pIPv6ConnList)->state==SYN_ACK_RECV)
			{
				//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
				//assert(rg_db.naptOut[*pNaptOutIdx].state==SYN_ACK_RECV);
				(*pIPv6ConnList)->state=TCP_CONNECTED;
				if((*pIPv6ConnList)->pPair_list!=NULL)
					(*pIPv6ConnList)->pPair_list->state=TCP_CONNECTED;

				TRACE("IPv6 TCP Connection is CONNECTED!");
			}
		}
#endif
	}
	return RG_FWDENGINE_RET_NAPT_OK;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_ipv6UDPOutboundConnectionTracking(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, rtk_rg_pktHdr_t *pPktHdr)
{
	//build connection when the first packet send out!
	rtk_rg_successFailReturn_t ret;

	//look up if we add this connection before
	_rtk_rg_fwdEngine_ipv6ConnList_lookup(pIPv6ConnList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,0,0);

	if((*pIPv6ConnList)==NULL)
	{
		ret = _rtk_rg_fwdEngine_fillIpv6StatefulInfo(pIPv6ConnList,pPktHdr->ipv6StatefulHashValue,pPktHdr);
		if(ret!=RG_RET_SUCCESS)
		{
			TRACE("[Drop] Fail to fill ipv6 stateful list");
			return RG_FWDENGINE_RET_DROP;
		}
	}

	if((*pIPv6ConnList)!=NULL)//suppose the pIPv6ConnList will be found or added by _rtk_rg_fwdEngine_fillIpv6StatefulInfo()
		(*pIPv6ConnList)->state=UDP_CONNECTED;

	return RG_FWDENGINE_RET_NAPT_OK;
}
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_ipv6UDPInboundConnectionTracking(rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, rtk_rg_pktHdr_t *pPktHdr)
{
	//build connection when the outbound is built and receive first inbound packet!
	rtk_rg_successFailReturn_t ret;
	rtk_rg_ipv6_layer4_linkList_t *pIPv6OutboundList=NULL,*pIPv6InboundList=NULL;

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	//support for server in lan
	//rtk_ipv6_addr_t transIP;
	//int16 transPort;

	if(pPktHdr->fwdDecision!=RG_FWD_DECISION_V6NAPTR){ //Routing case
#endif
		//look up if we add outbound list before
		_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pIPv6OutboundList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Dip,pPktHdr->pIpv6Sip,pPktHdr->dport,pPktHdr->sport,0,0);

		if(pIPv6OutboundList==NULL)
		{
			TRACE("[Drop] there is no outbound list, drop it!");
			return RG_FWDENGINE_RET_DROP;
		}

		//for UDP, when packet enter fwdEngine_input, the hashvalue will be caculated and stored in pPktHdr->ipv6StatefulHashValue
		//so we can use it directly.
		//if(pPktHdr->ipv6StatefulHashValue<0)
			//pPktHdr->ipv6StatefulHashValue=_rtk_rg_ipv6StatefulHashIndex(0x11,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport);


		//look up for inbound list
		pPktHdr->ipv6StatefulHashValue=-1;
		_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pIPv6InboundList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,0,0);
		if(pIPv6InboundList==NULL){
			ret = _rtk_rg_fwdEngine_fillIpv6StatefulInfo(&pIPv6InboundList,pPktHdr->ipv6StatefulHashValue,pPktHdr);
		    if(ret!=RG_RET_SUCCESS)
			{
				TRACE("[Drop] Fail to fill ipv6 stateful list");
				return RG_FWDENGINE_RET_DROP;
		    }
		}

		//keep inbound list pointer in outbound list, for deleting when timeout
		pIPv6OutboundList->pPair_list=pIPv6InboundList;

		pIPv6InboundList->state=UDP_CONNECTED;
		pIPv6InboundList->pPair_list=pIPv6OutboundList;

		*pIPv6ConnList=pIPv6InboundList;

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	}
	else //NAPTR case
	{
		if(pPktHdr->ipv6_serverInLanLookup.serverInLanHit!=RTK_RG_IPV6_LOOKUP_NONE_HIT){//Server in Lan case is hit.
			pPktHdr->ipv6StatefulHashValue=-1;
			_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pIPv6InboundList,&pPktHdr->ipv6StatefulHashValue,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,0,0);
			if(pIPv6InboundList==NULL)
			{
				ret = _rtk_rg_fwdEngine_fillIpv6StatefulInfo(&pIPv6InboundList,pPktHdr->ipv6StatefulHashValue,pPktHdr);
				if(ret!=RG_RET_SUCCESS)
				{
					TRACE("[Drop] Fail to fill ipv6 stateful list");
					return RG_FWDENGINE_RET_DROP;
				}

				*pIPv6ConnList=pIPv6InboundList;
				pPktHdr->pIPv6StatefulList = *pIPv6ConnList;
				pIPv6InboundList->state=UDP_CONNECTED;
			}

		}else{//normal NAPTR case:The inbound connection is usually already added while NAPT outbound process.
			if(pPktHdr->pIPv6StatefulList==NULL){ //connList not found
				TRACE("[Drop] Inbound connList not found, drop it!");
				return RG_FWDENGINE_RET_DROP;
			}
			//pIPv6InboundList has been lookup while searching DIP(pPktHdr->pIPv6StatefulList and pPktHdr->ipv6StatefulHashValue have assigned!), look up pIPv6OutboundList list which record in pIPv6InboundList
			pIPv6InboundList=pPktHdr->pIPv6StatefulList;
			*pIPv6ConnList = pIPv6InboundList;
			pIPv6InboundList->state=UDP_CONNECTED;
		}
	}
#endif
	return RG_FWDENGINE_RET_NAPT_OK;
}

void _rtk_rg_fwdEngine_v6FragmentPacketQueuing(rtk_rg_naptDirection_t direction, rtk_l34_nexthop_type_t	wanType, struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	int i,queueIdx;
	unsigned long compareTime;

	//------------------ Critical Section start -----------------------//
	rg_lock(&rg_kernel.ipv6FragQueueLock);

	queueIdx=0;
	compareTime=0;

	//find the first valid one or smallest queue_time(oldest) to use
	for(i=0;i<MAX_IPV6_FRAGMENT_QUEUE_SIZE;i++)
	{
		if(rg_db.ipv6FragmentQueue[i].occupied==0)
		{
			compareTime = 0;
			queueIdx = i;
			rg_db.systemGlobal.ipv6FragmentQueueNum++;
			break;
		}
		else if(rg_db.ipv6FragmentQueue[i].queue_time < compareTime)
		{
			compareTime = rg_db.ipv6FragmentQueue[i].queue_time;
			queueIdx = i;
		}
	}

	//free the oldest one skb
	if(compareTime>0)
		_rtk_rg_dev_kfree_skb_any(rg_db.ipv6FragmentQueue[queueIdx].queue_skb);

	//insert new packet into this idx
	rg_db.ipv6FragmentQueue[queueIdx].queue_skb=skb;
	memcpy(&rg_db.ipv6FragmentQueue[queueIdx].queue_pktHdr,pPktHdr,sizeof(rtk_rg_pktHdr_t));
	memcpy(&rg_db.ipv6FragmentQueue[queueIdx].queue_rx_info,pPktHdr->pRxDesc,sizeof(struct rx_info));
	rg_db.ipv6FragmentQueue[queueIdx].queue_time=jiffies;
	rg_db.ipv6FragmentQueue[queueIdx].occupied=1;
	rg_db.ipv6FragmentQueue[queueIdx].direction=direction;
	rg_db.ipv6FragmentQueue[queueIdx].wanType=wanType;

	//------------------ Critical Section End -----------------------//
	rg_unlock(&rg_kernel.ipv6FragQueueLock);

}

void _rtk_rg_fwdEngine_v6FragmentQueueProcessing(int aclRet, rtk_rg_pktHdr_t *pPktHdr, rtk_rg_ipv6_layer4_linkList_t *pFragList)
{
	int i,totalQueueNum;
	//If we are the first fragment packet:
	//Check the queue to see if there is any packet has same identification and SIP,DIP
	//Loop if match:
	//	Forward the packet
	//	Move the last one to the proceed queue position
	//	Queue number --
	totalQueueNum=rg_db.systemGlobal.ipv6FragmentQueueNum;
	for(i=0;i<MAX_IPV6_FRAGMENT_QUEUE_SIZE&&totalQueueNum>0;i++)
	{
		DEBUG("rg_db.systemGlobal.ipv6FragmentQueueNum is %d",rg_db.systemGlobal.ipv6FragmentQueueNum);
		DEBUG("rg_db.ipv6FragmentQueue[%d].occupied = %d",i,rg_db.ipv6FragmentQueue[i].occupied);
		DEBUG("*rg_db.ipv6FragmentQueue[%d].queue_pktHdr.ipv6FragIdentification = %02x%02x",i,rg_db.ipv6FragmentQueue[i].queue_pktHdr.ipv6FragId_First,rg_db.ipv6FragmentQueue[i].queue_pktHdr.ipv6FragId_Second);
		//------------------ Critical Section start -----------------------//
		rg_lock(&rg_kernel.ipv6FragQueueLock);
		if(rg_db.ipv6FragmentQueue[i].occupied)
		{
			totalQueueNum--;
			if(!memcmp(pPktHdr->pIpv6Sip,rg_db.ipv6FragmentQueue[i].queue_pktHdr.pIpv6Sip,IPV6_ADDR_LEN) &&
				pPktHdr->ipv6FragId_First==rg_db.ipv6FragmentQueue[i].queue_pktHdr.ipv6FragId_First &&
				pPktHdr->ipv6FragId_Second==rg_db.ipv6FragmentQueue[i].queue_pktHdr.ipv6FragId_Second)
			{
				DEBUG("queue [%d] Match!! payload size is %d, v6payloadLength is %d",i,rg_db.ipv6FragmentQueue[i].queue_pktHdr.l3Len,rg_db.ipv6FragmentQueue[i].queue_pktHdr.ipv6PayloadLen);
				pFragList->queueCount--;

				//Check ACL action by first packet
				if(aclRet==RG_FWDENGINE_RET_TO_PS)
				{
					DEBUG("return to Protocol stack!!");
#ifdef __KERNEL__
					//from master wifi
					if((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<rg_db.ipv6FragmentQueue[i].queue_pktHdr.ingressPort))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
						|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<rg_db.ipv6FragmentQueue[i].queue_pktHdr.ingressPort))
#endif
						)
					{
						rg_db.ipv6FragmentQueue[i].queue_skb->data+=ETH_HLEN;
						rg_db.ipv6FragmentQueue[i].queue_skb->len-=ETH_HLEN;
						TRACE("WLAN0 queue_v6packet trap to netif_rx\n");
						netif_rx(rg_db.ipv6FragmentQueue[i].queue_skb);
					}
					else
#if defined(CONFIG_RG_G3_SERIES)
						nic_rxhook_default(NULL, rg_db.ipv6FragmentQueue[i].queue_skb->dev, rg_db.ipv6FragmentQueue[i].queue_skb , NULL);
#else
						re8670_rx_skb(((struct re_dev_private*)rg_db.ipv6FragmentQueue[i].queue_skb->dev->priv)->pCp,rg_db.ipv6FragmentQueue[i].queue_skb,(struct rx_info *)&rg_db.ipv6FragmentQueue[i].queue_rx_info);
#endif
#else
					model_nic_rx_skb(((struct re_dev_private*)rg_db.ipv6FragmentQueue[i].queue_skb->dev->priv)->pCp,rg_db.ipv6FragmentQueue[i].queue_skb,(struct rx_info *)&rg_db.ipv6FragmentQueue[i].queue_rx_info);
#endif
				}
				else if(aclRet==RG_FWDENGINE_RET_DROP)
				{
					DEBUG("Drop packet[%d]!!",i);
					_rtk_rg_dev_kfree_skb_any(rg_db.ipv6FragmentQueue[i].queue_skb);
				}
				else
				{
					_rtk_rg_fwdEngine_ipv6PacketModify(rg_db.ipv6FragmentQueue[i].direction,rg_db.ipv6FragmentQueue[i].wanType,&rg_db.ipv6FragmentQueue[i].queue_pktHdr,rg_db.ipv6FragmentQueue[i].queue_skb);

					DEBUG("send the queued fragment packet [%d]!",i);
#ifdef CONFIG_APOLLO_MODEL
#else
					_rtk_rg_fwdEngineDirectTx(rg_db.ipv6FragmentQueue[i].queue_skb,&rg_db.ipv6FragmentQueue[i].queue_pktHdr);
#endif
				}
				rg_db.systemGlobal.ipv6FragmentQueueNum--;
				rg_db.ipv6FragmentQueue[i].occupied = 0;
				rg_db.ipv6FragmentQueue[i].queue_time = 0;
			}
		}
		//------------------ Critical Section End -----------------------//
		rg_unlock(&rg_kernel.ipv6FragQueueLock);
	}

}


rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_v6FragmentHandling(rtk_rg_naptDirection_t direction, rtk_l34_nexthop_type_t	wanType,rtk_rg_ipv6_layer4_linkList_t **pIPv6ConnList, rtk_rg_pktHdr_t *pPktHdr, struct sk_buff *skb)
{
	int hashIndex=-1,fragAction=RG_FWDENGINE_RET_CONTINUE;
	rtk_rg_ipv6_layer4_linkList_t *pFragList=NULL;
	rtk_rg_fwdEngineReturn_t ret;

	//First Fragment Packet
	if(pPktHdr->ipv6MoreFragment && pPktHdr->ipv6FragmentOffset==0)
	{
		//first check it's state
		//then create fragment list
		//modify packet and send!
		ret=RG_FWDENGINE_RET_NAPT_OK;
		if(direction==NAPT_DIRECTION_OUTBOUND || direction==IPV6_ROUTE_OUTBOUND)
		{
			if(pPktHdr->tagif&TCP_TAGIF)
				ret=_rtk_rg_fwdEngine_ipv6TCPOutboundConnectionTracking(pIPv6ConnList,pPktHdr);
			else if(pPktHdr->tagif&UDP_TAGIF)
				ret=_rtk_rg_fwdEngine_ipv6UDPOutboundConnectionTracking(pIPv6ConnList,pPktHdr);
			if(ret!=RG_FWDENGINE_RET_NAPT_OK)fragAction=ret;
		}
		else
		{
			if(pPktHdr->tagif&TCP_TAGIF)
				ret=_rtk_rg_fwdEngine_ipv6TCPInboundConnectionTracking(pIPv6ConnList,pPktHdr);
			else if(pPktHdr->tagif&UDP_TAGIF)
				ret=_rtk_rg_fwdEngine_ipv6UDPInboundConnectionTracking(pIPv6ConnList,pPktHdr);
			if(ret!=RG_FWDENGINE_RET_NAPT_OK)fragAction=ret;
		}

		//update direction and wanType(ether or pppoe)
		if((*pIPv6ConnList)!=NULL)
		{
			(*pIPv6ConnList)->direction=direction;
			(*pIPv6ConnList)->wanType=wanType;
			pPktHdr->pIPv6StatefulList=(*pIPv6ConnList);
			pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
			pPktHdr->pIPv6StatefulList->idleSecs=0;
		}

		if(pPktHdr->pIPv6FragmentList==NULL)
		{
			if(_rtk_rg_fwdEngine_fillIpv6StatefulFragmentInfo(&pFragList,pPktHdr)!=RG_RET_SUCCESS)
				return RG_FWDENGINE_RET_FRAG_ONE_DROP;
		}
		else
			pFragList=pPktHdr->pIPv6FragmentList;

		ret = _rtk_rg_fwdEngine_ipv6PacketModify(direction,wanType,pPktHdr,skb);
		if(ret!=RG_FWDENGINE_RET_CONTINUE) fragAction=ret;	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP
		pFragList->fragAction=fragAction;
		pFragList->pPair_list=(*pIPv6ConnList);
		DEBUG("pFragList[%p]->fragAction is %d, receivedLength became %d, total is %d",pFragList,pFragList->fragAction,pFragList->receivedLength,pFragList->totalLength);

		pPktHdr->pIPv6FragmentList=pFragList;

		if(fragAction==RG_FWDENGINE_RET_DROP)
		{
			TRACE("[Drop] drop all same identification in queue");
			return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
		}
		else if(fragAction==RG_FWDENGINE_RET_TO_PS)
		{
			TRACE("[To PS] trap all same identification in queue");
			return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
		}

		if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
		{
			DEBUG("all frag packet are out, free the list...");
			pFragList->pPair_list=NULL;		//leave conn list un-touch
			//------------------ Critical Section start -----------------------//
			rg_lock(&rg_kernel.ipv6StatefulLock);
			_rtk_rg_fwdEngine_ipv6ConnList_del(pFragList);
			//------------------ Critical Section End -----------------------//
			rg_unlock(&rg_kernel.ipv6StatefulLock);
		}

		return RG_FWDENGINE_RET_FRAGMENT_ONE;
	}
	else	//other fragment packet
	{
		DEBUG("other fragment");
		if(pPktHdr->ipProtocol==0x6)
			_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pFragList,&hashIndex,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->ipv6FragId_First,pPktHdr->ipv6FragId_Second,1,1);
		else if(pPktHdr->ipProtocol==0x11)
			_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pFragList,&hashIndex,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->ipv6FragId_First,pPktHdr->ipv6FragId_Second,0,1);
		if(pFragList!=NULL)
		{
			//hit, do what first packet do

			//filled by first packet or other early fragment packets
			if(pPktHdr->ipv6MoreFragment==0)		//we can not free fragList here, unless there are all packets had forwarded
				pFragList->totalLength=(pPktHdr->ipv6FragmentOffset<<3)+pPktHdr->ipv6PayloadLen;
			DEBUG("pFragList[%p]->fragAction is %d, receivedLength became %d, total is %d",pFragList,pFragList->fragAction,pFragList->receivedLength,pFragList->totalLength);
			//DEBUG("later fragment modify... fragIdx=%d",fragIdx);
			if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)		//we can not free fragList here, unless there are all packets had forwarded
			{
				DEBUG("all frag packet are out, free the list...");
				fragAction=pFragList->fragAction;
				pFragList->pPair_list=NULL;		//leave conn list un-touch
				//------------------ Critical Section start -----------------------//
				rg_lock(&rg_kernel.ipv6StatefulLock);
				_rtk_rg_fwdEngine_ipv6ConnList_del(pFragList);
				//------------------ Critical Section End -----------------------//
				rg_unlock(&rg_kernel.ipv6StatefulLock);
			}

			//Check frag action from first packet
			DEBUG("pFragList[%p]->fragAction is %d",pFragList,pFragList->fragAction);
			if(pFragList->fragAction==RG_FWDENGINE_RET_TO_PS || pFragList->fragAction==RG_FWDENGINE_RET_DROP)
			{
				TRACE("[%s] do frag action", (pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
				return pFragList->fragAction;
			}
			if(pFragList->fragAction==RG_FWDENGINE_RET_QUEUE_FRAG)	//first packet not come in yet
				goto IPV6_FRAG_QUEUE;

			ret = _rtk_rg_fwdEngine_ipv6PacketModify(direction,wanType,pPktHdr,skb);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP
			DEBUG("before ret fragment..");
			return RG_FWDENGINE_RET_FRAGMENT;
		}
		else
		{
			//Otherwise we need to queue this packet for later proceed
			if(_rtk_rg_fwdEngine_fillIpv6StatefulFragmentInfo(&pFragList,pPktHdr)!=RG_RET_SUCCESS)
				return RG_FWDENGINE_RET_FRAG_ONE_DROP;

			pFragList->fragAction=RG_FWDENGINE_RET_QUEUE_FRAG;

IPV6_FRAG_QUEUE:
			DEBUG("queuing packet.....");

			//Check if we already queue same identification for MAX_FRAGMENT_QUEUE_THRESHOLD times
			pFragList->queueCount++;
			if(pFragList->queueCount>=MAX_FRAGMENT_QUEUE_THRESHOLD)
			{
				//clear same identification in queue
				pFragList->queueCount=0;
				pFragList->fragAction=RG_FWDENGINE_RET_DROP;
				_rtk_rg_fwdEngine_v6FragmentQueueProcessing(pFragList->fragAction,pPktHdr,pFragList);
				TRACE("[Drop] queueCount of v6 fragment >= MAX_FRAGMENT_QUEUE_THRESHOLD(%d)", MAX_FRAGMENT_QUEUE_THRESHOLD);
				return RG_FWDENGINE_RET_DROP;
			}
			else
			{
				//Put the fragment packet into queue
				_rtk_rg_fwdEngine_v6FragmentPacketQueuing(direction,wanType,skb,pPktHdr);
				return RG_FWDENGINE_RET_QUEUE_FRAG;
			}
		}
	}
}
#endif

#if 1
rtk_rg_err_code_t _rtk_rg_fwdEngine_ICMPInboundControlFlowTracking(rtk_rg_pktHdr_t *pPktHdr, rtk_rg_table_icmp_flow_t **icmpCtrlList);
rtk_rg_entryGetReturn_t _rtk_rg_naptPriority_pattern_check(int rule_direction, int pkt_direction, rtk_rg_pktHdr_t *pPktHdr, rtk_rg_sw_naptFilterAndQos_t *pNaptPriorityRuleStart,int direct, int naptIdx,int l3Modify,int l4Modify){
	//the egress pattern will be filled to pPktHdr after _rtk_rg_fwdEngine_shortCutNaptPacketModify()
	//egress pattern should consider direction

	int l2Idx=FAIL;
	int	dipL3Idx=FAIL;
	int	dipArpOrNBIdx=FAIL;
	int netifIdx=FAIL; //egress intf
	rtk_rg_arp_linkList_t *pSoftwareArpEntry;
	uint8 egress_dmac[ETHER_ADDR_LEN];
	uint8 egress_smac[ETHER_ADDR_LEN];
	uint32 egress_sip;
	uint32 egress_dip;
	uint16 egress_sport;
	uint16 egress_dport;

	int i=0; //double make sure don't go into infinity loop
	int check_direct=CHECK_BOUND_PKT_WITH_BOUND_RULE_END;
	rtk_rg_sw_naptFilterAndQos_t *pCurrentCheckRule=NULL;
	if(pPktHdr==NULL) return RG_RET_ENTRY_NOT_GET; //no information can be compared
	if(pNaptPriorityRuleStart==NULL) return RG_RET_ENTRY_NOT_GET; //no rules need to check


	DEBUG("NaptFilter, %s rule Checking:",(rule_direction==RG_FWD_DECISION_NAPT)?"outbound":"inbound");
	if(pkt_direction==NAPT_DIRECTION_OUTBOUND&& rule_direction==RG_FWD_DECISION_NAPT){
		check_direct = CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE;
	}else if(pkt_direction==NAPT_DIRECTION_OUTBOUND && rule_direction==RG_FWD_DECISION_NAPTR){
		check_direct = CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE;
	}else if(pkt_direction==NAPT_DIRECTION_INBOUND && rule_direction==RG_FWD_DECISION_NAPT){
		check_direct = CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE;
	}else if(pkt_direction==NAPT_DIRECTION_INBOUND && rule_direction==RG_FWD_DECISION_NAPTR){
		check_direct = CHECK_INBOUND_PKT_WITH_INBOUND_RULE;
	}else{
		DEBUG("naptFilter can not judge direction, check failed!");
		//goto unhit;
		return RG_RET_ENTRY_NOT_GET;
	}


	//DEBUG("check_direct=%d direct=%d, naptIdx=%d, l3Modify=%d, l4Modify=%d",check_direct,direct,naptIdx,l3Modify,l4Modify);


	//pre-search egress value of the packet.
	{
		//init by original ingress packet value
		egress_sip = pPktHdr->ipv4Sip;
		egress_dip = pPktHdr->ipv4Dip;
		egress_sport = pPktHdr->sport;
		egress_dport = pPktHdr->dport;
		memcpy(egress_dmac, pPktHdr->dmac,ETHER_ADDR_LEN);
		memcpy(egress_smac, pPktHdr->smac,ETHER_ADDR_LEN);


		if((direct==NAPT_DIRECTION_OUTBOUND)||(direct==NAPT_DIRECTION_ROUTING))
		{

			// fool-proofing & debug
			if(l3Modify || l4Modify) assert(naptIdx<MAX_NAPT_OUT_SW_TABLE_SIZE);

			l2Idx=pPktHdr->dmacL2Idx;
			assert((l2Idx!=FAIL) && (l2Idx<MAX_LUT_SW_TABLE_SIZE));
			/*
			FIXME("l2idx=%d mac=%02x:%02x:%02x:%02x:%02x:%02x\n",l2Idx,rg_db.mac[l2Idx].macAddr.octet[0]
			,rg_db.mac[l2Idx].macAddr.octet[1],rg_db.mac[l2Idx].macAddr.octet[2]
			,rg_db.mac[l2Idx].macAddr.octet[3],rg_db.mac[l2Idx].macAddr.octet[4]
			,rg_db.mac[l2Idx].macAddr.octet[5]);
			*/

			// fill DA
			memcpy(/*pPktHdr->pDmac*/egress_dmac,rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN);
			//DEBUG("egress_dmac=%02x:%02x:%02x:%02x:%02x:%02x\n",egress_dmac[0],egress_dmac[1],egress_dmac[2],egress_dmac[3],egress_dmac[4],egress_dmac[5]);

			//fill SIP
			if(l3Modify)
			{
				/* *pPktHdr->pIpv4Sip*/egress_sip=rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr;
				//DEBUG("modify egress_sip to %d.%d.%d.%d",(egress_sip>>24)&0xff,(egress_sip>>16)&0xff,(egress_sip>>8)&0xff,egress_sip&0xff);
			}

			//fill SPORT
			if(l4Modify)
			{
				/* *pPktHdr->pSport*/egress_sport=rg_db.naptOut[naptIdx].extPort;
				//DEBUG("modify egress_sport to %d",egress_sport);
			}

			//fill SA
			memcpy(/*pPktHdr->pSmac*/egress_smac,rg_db.netif[pPktHdr->netifIdx].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN);
			//DEBUG("egress_smac=%02x:%02x:%02x:%02x:%02x:%02x\n",egress_smac[0],egress_smac[1],egress_smac[2],egress_smac[3],egress_smac[4],egress_smac[5]);

		}
		else //INBOUND
		{

			// fool-proofing & debug
			if(l3Modify || l4Modify) assert(naptIdx<MAX_NAPT_IN_SW_TABLE_SIZE);


			if(pPktHdr->tagif&ICMP_TAGIF){
				if(pPktHdr->icmpCtrlFlowForNaptFilter==NULL)
				{
					TRACE("ICMPR lookup fail!");
					goto egressPattern_preDecision_end;
				}

				egress_dip=pPktHdr->icmpCtrlFlowForNaptFilter->internalIP;
				DEBUG("egress_dip=0x%x",egress_dip);
			}


			//fill DIP
			if(l3Modify){
				/* *pPktHdr->pIpv4Dip*/egress_dip=rg_db.naptIn[naptIdx].rtk_naptIn.intIp;
				DEBUG("modify egress_dip to %d.%d.%d.%d [by NAPT inIdx=%d]",(egress_dip>>24)&0xff,(egress_dip>>16)&0xff,(egress_dip>>8)&0xff,egress_dip&0xff,naptIdx);

			}

			//fill DPORT
			if(l4Modify){
				/* *pPktHdr->pDport*/egress_dport=rg_db.naptIn[naptIdx].rtk_naptIn.intPort;
				DEBUG("modify egress_dport to %d",egress_dport);
			}

			dipL3Idx=_rtk_rg_l3lookup(egress_dip);

			netifIdx=rg_db.l3[dipL3Idx].rtk_l3.netifIdx; //for Normal Route SMAC

			DEBUG("dipL3Idx is %d",dipL3Idx);
			/* arp table decision */
			if(rg_db.l3[dipL3Idx].rtk_l3.process==L34_PROCESS_ARP)
			{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				goto check_sw_arp;
#elif defined(CONFIG_RG_RTL9600_SERIES)
				{
					dipArpOrNBIdx=(rg_db.l3[dipL3Idx].rtk_l3.arpStart<<2)+(egress_dip & ((1<<(31-rg_db.l3[dipL3Idx].rtk_l3.ipMask))-1));
				}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
				{
					_rtk_rg_softwareArpTableLookUp(dipL3Idx,egress_dip,&pSoftwareArpEntry,0);
					if(pSoftwareArpEntry==NULL){	// sw arp is not found
						_rtk_rg_hardwareArpTableLookUp(dipL3Idx,egress_dip,&pSoftwareArpEntry,0);
					}else{
						//DEBUG("Dip hit SW arp table.");
					}
					if(pSoftwareArpEntry!=NULL)
						dipArpOrNBIdx = pSoftwareArpEntry->idx;
				}
#endif


			}
			else if(rg_db.l3[dipL3Idx].rtk_l3.process==L34_PROCESS_CPU)
			{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
check_sw_arp:
#endif
				_rtk_rg_softwareArpTableLookUp(dipL3Idx,egress_dip,&pSoftwareArpEntry,0);
				if(pSoftwareArpEntry!=NULL)
					dipArpOrNBIdx = pSoftwareArpEntry->idx;
			}
			//if ARP miss, return to PS
			if(dipArpOrNBIdx==FAIL || rg_db.arp[dipArpOrNBIdx].rtk_arp.valid==0)
			{
				//DEBUG("ARP miss");
				l2Idx=FAIL;
			}
			else
			{
				l2Idx=rg_db.arp[dipArpOrNBIdx].rtk_arp.nhIdx;
			}
			//DEBUG("ARP arp=%d l2=%d\n",dipArpOrNBIdx,l2Idx);

			//fill DA
			assert((l2Idx!=FAIL) && (l2Idx<MAX_LUT_SW_TABLE_SIZE));
			if(rg_db.lut[l2Idx].valid==0){
				DEBUG("DMAC miss...");
			}else
				memcpy(/*pPktHdr->pDmac*/egress_dmac,rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.mac.octet,ETHER_ADDR_LEN);

			DEBUG("egress_dmac=%02x:%02x:%02x:%02x:%02x:%02x\n",egress_dmac[0],egress_dmac[1],egress_dmac[2],egress_dmac[3],egress_dmac[4],egress_dmac[5]);

			//fill SA
			assert((netifIdx!=FAIL) && (netifIdx<MAX_NETIF_SW_TABLE_SIZE));
			memcpy(/*pPktHdr->pSmac*/egress_smac,rg_db.netif[netifIdx].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN);
			DEBUG("egress_smac=%02x:%02x:%02x:%02x:%02x:%02x\n",egress_smac[0],egress_smac[1],egress_smac[2],egress_smac[3],egress_smac[4],egress_smac[5]);

		}
	}

egressPattern_preDecision_end:

	pCurrentCheckRule = pNaptPriorityRuleStart;
	while(pCurrentCheckRule!=NULL && i<MAX_NAPT_FILER_SW_ENTRY_SIZE){
		DEBUG("Checking naptFilterRule[%d], followDirectionMatch=%d",pCurrentCheckRule->sw_index,pCurrentCheckRule->naptFilter.followDirectionMatch);
		if(pCurrentCheckRule->naptFilter.followDirectionMatch &&
			((pCurrentCheckRule->naptFilter.direction==RTK_RG_NAPT_FILTER_OUTBOUND && pkt_direction==NAPT_DIRECTION_INBOUND)||
				(pCurrentCheckRule->naptFilter.direction==RTK_RG_NAPT_FILTER_INBOUND && pkt_direction==NAPT_DIRECTION_OUTBOUND))){
			DEBUG("naptFilter.direction %s is different with pkt_direction %s, unhit!",pCurrentCheckRule->naptFilter.direction==RTK_RG_NAPT_FILTER_OUTBOUND?"OUTBOUND":"INBOUND",pkt_direction==NAPT_DIRECTION_OUTBOUND?"OUTBOUND":"INBOUND");
			goto unhit;
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_SIP){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->ipv4Sip!=pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr){
						DEBUG("INGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr){
						DEBUG("INGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(/* *(pPktHdr->pIpv4Dip)*/egress_dip!=pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr){
						DEBUG("INGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",/* *(pPktHdr->pIpv4Dip)*/egress_dip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->ipv4Sip!=pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr){
						DEBUG("INGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr);
						goto unhit;
					}
					break;
			}

		}
		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_SIP){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(/* *(pPktHdr->pIpv4Sip)*/egress_sip!=pCurrentCheckRule->naptFilter.egress_src_ipv4_addr){
						DEBUG("EGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",/* *(pPktHdr->pIpv4Sip)*/egress_sip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.egress_src_ipv4_addr){
						DEBUG("EGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.egress_src_ipv4_addr){
						DEBUG("EGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(/* *(pPktHdr->pIpv4Sip)*/egress_sip!=pCurrentCheckRule->naptFilter.egress_src_ipv4_addr){
						DEBUG("EGRESS_SIP UNHIT: pkt=0x%x rule=0x%x",/* *(pPktHdr->pIpv4Sip)*/egress_sip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr);
						goto unhit;
					}
					break;
			}

		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_DIP){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr){
						DEBUG("INGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(/* *(pPktHdr->pIpv4Sip)*/egress_sip!=pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr){
						DEBUG("INGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",/* *(pPktHdr->pIpv4Sip)*/egress_sip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->ipv4Sip!=pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr){
						DEBUG("INGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr){
						DEBUG("INGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_DIP){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr){
						DEBUG("EGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->ipv4Sip!=pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr){
						DEBUG("EGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->ipv4Sip!=pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr){
						DEBUG("EGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(/* *(pPktHdr->pIpv4Dip)*/egress_dip!=pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr){
						DEBUG("EGRESS_DIP UNHIT: pkt=0x%x rule=0x%x",/* *(pPktHdr->pIpv4Dip)*/egress_dip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr);
						goto unhit;
					}
					break;
			}

		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_SPORT){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("INGRESS_SPORT UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->sport!=pCurrentCheckRule->naptFilter.ingress_src_l4_port){
						DEBUG("INGRESS_SPORT UNHIT: pkt=%d rule=%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.ingress_src_l4_port);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->dport!=pCurrentCheckRule->naptFilter.ingress_src_l4_port){
						DEBUG("INGRESS_SPORT UNHIT: pkt=%d rule=%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.ingress_src_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(/* *(pPktHdr->pDport)*/egress_dport!=pCurrentCheckRule->naptFilter.ingress_src_l4_port){
						DEBUG("INGRESS_SPORT UNHIT: pkt=%d rule=%d",/* *(pPktHdr->pDport)*/egress_dport,pCurrentCheckRule->naptFilter.ingress_src_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->sport!=pCurrentCheckRule->naptFilter.ingress_src_l4_port){
						DEBUG("INGRESS_SPORT UNHIT: pkt=%d rule=%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.ingress_src_l4_port);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_SPORT){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("EGRESS_SPORT UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(/* *(pPktHdr->pSport)*/egress_sport!=pCurrentCheckRule->naptFilter.egress_src_l4_port){
						DEBUG("EGRESS_SPORT UNHIT: pkt=%d rule=%d",/* *(pPktHdr->pSport)*/egress_sport,pCurrentCheckRule->naptFilter.egress_src_l4_port);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->dport!=pCurrentCheckRule->naptFilter.egress_src_l4_port){
						DEBUG("EGRESS_SPORT UNHIT: pkt=%d rule=%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.egress_src_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->dport!=pCurrentCheckRule->naptFilter.egress_src_l4_port){
						DEBUG("EGRESS_SPORT UNHIT: pkt=%d rule=%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.egress_src_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(/* *(pPktHdr->pSport)*/egress_sport!=pCurrentCheckRule->naptFilter.egress_src_l4_port){
						DEBUG("EGRESS_SPORT UNHIT: pkt=%d rule=%d",/* *(pPktHdr->pSport)*/egress_sport,pCurrentCheckRule->naptFilter.egress_src_l4_port);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_DPORT){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("INGRESS_DPORT UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->dport!=pCurrentCheckRule->naptFilter.ingress_dest_l4_port){
						DEBUG("INGRESS_DPORT UNHIT: pkt=%d rule=%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->sport!=pCurrentCheckRule->naptFilter.ingress_dest_l4_port){
						DEBUG("INGRESS_DPORT UNHIT: pkt=%d rule=%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(/* *(pPktHdr->pSport)*/egress_sport!=pCurrentCheckRule->naptFilter.ingress_dest_l4_port){
						DEBUG("INGRESS_DPORT UNHIT: pkt=%d rule=%d",/* *(pPktHdr->pSport)*/egress_sport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->dport!=pCurrentCheckRule->naptFilter.ingress_dest_l4_port){
						DEBUG("INGRESS_DPORT UNHIT: pkt=%d rule=%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_DPORT){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("EGRESS_DPORT UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(/* *(pPktHdr->pDport)*/egress_dport!=pCurrentCheckRule->naptFilter.egress_dest_l4_port){
						DEBUG("EGRESS_DPORT UNHIT: pkt=%d rule=%d",/* *(pPktHdr->pDport)*/egress_dport,pCurrentCheckRule->naptFilter.egress_dest_l4_port);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(pPktHdr->sport!=pCurrentCheckRule->naptFilter.egress_dest_l4_port){
						DEBUG("EGRESS_DPORT UNHIT: pkt=%d rule=%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.egress_dest_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(pPktHdr->sport!=pCurrentCheckRule->naptFilter.egress_dest_l4_port){
						DEBUG("EGRESS_DPORT UNHIT: pkt=%d rule=%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.egress_dest_l4_port);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(/* *(pPktHdr->pDport)*/egress_dport!=pCurrentCheckRule->naptFilter.egress_dest_l4_port){
						DEBUG("EGRESS_DPORT UNHIT: pkt=%d rule=%d",/* *(pPktHdr->pDport)*/egress_dport,pCurrentCheckRule->naptFilter.egress_dest_l4_port);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & L4_PROTOCAL){
			if(pPktHdr->ipProtocol!=pCurrentCheckRule->naptFilter.ingress_l4_protocal){
				DEBUG("L4_PROTOCAL UNHIT: pkt=%d rule=%d",pPktHdr->ipProtocol,pCurrentCheckRule->naptFilter.ingress_l4_protocal);
				goto unhit;
			}
		}

		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_SIP_RANGE){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if(( pPktHdr->ipv4Sip < pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start) ||
						( pPktHdr->ipv4Sip > pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end) ){
						DEBUG("INGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(( pPktHdr->ipv4Dip < pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start) ||
						( pPktHdr->ipv4Dip > pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end) ){
						DEBUG("INGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((/* *(pPktHdr->pIpv4Dip)*/egress_dip < pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start) ||
						(/* *(pPktHdr->pIpv4Dip)*/egress_dip > pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end) ){
						DEBUG("INGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",/* *(pPktHdr->pIpv4Dip)*/egress_dip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(( pPktHdr->ipv4Sip < pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start) ||
						( pPktHdr->ipv4Sip > pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end) ){
						DEBUG("INGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_DIP_RANGE){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->ipv4Dip < pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start) ||
						(pPktHdr->ipv4Dip > pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end) ){
						DEBUG("INGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if((/*(*(pPktHdr->pIpv4Sip) */egress_sip < pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start) ||
						(/* *(pPktHdr->pIpv4Sip) */egress_sip > pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end) ){
						DEBUG("INGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",/* *(pPktHdr->pIpv4Sip)*/egress_sip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->ipv4Sip < pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start) ||
						(pPktHdr->ipv4Sip > pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end) ){
						DEBUG("INGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->ipv4Dip < pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start) ||
						(pPktHdr->ipv4Dip > pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end) ){
						DEBUG("INGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.ingress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_SPORT_RANGE){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("INGRESS_SPORT_RANGE UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->sport < pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start) ||
						(pPktHdr->sport > pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end)){
						DEBUG("INGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->dport < pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start) ||
						(pPktHdr->dport > pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end)){
						DEBUG("INGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((/* *(pPktHdr->pDport)*/egress_dport < pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start) ||
						(/* *(pPktHdr->pDport)*/egress_dport > pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end)){
						DEBUG("INGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",/* *(pPktHdr->pDport)*/egress_dport,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->sport < pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start) ||
						(pPktHdr->sport > pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end)){
						DEBUG("INGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_src_l4_port_range_end);
						goto unhit;
					}
					break;
			}
		}
		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_DPORT_RANGE){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("INGRESS_DPORT_RANGE UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->dport < pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start) ||
						(pPktHdr->dport > pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end)){
						DEBUG("INGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->sport < pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start) ||
						(pPktHdr->sport > pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end)){
						DEBUG("INGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((/* *(pPktHdr->pSport)*/egress_sport < pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start) ||
						(/* *(pPktHdr->pSport)*/egress_sport > pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end)){
						DEBUG("INGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",/* *(pPktHdr->pSport)*/egress_sport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->dport < pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start) ||
						(pPktHdr->dport > pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end)){
						DEBUG("INGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.ingress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
			}
		}


		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_SIP_RANGE){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((/* *(pPktHdr->pIpv4Sip)*/egress_sip < pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start) ||
						( /* *(pPktHdr->pIpv4Sip)*/egress_sip > pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end) ){
						DEBUG("EGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",/* *(pPktHdr->pIpv4Sip)*/egress_sip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if(( pPktHdr->ipv4Dip < pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start) ||
						( pPktHdr->ipv4Dip > pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end) ){
						DEBUG("EGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(( pPktHdr->ipv4Dip < pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start) ||
						( pPktHdr->ipv4Dip > pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end) ){
						DEBUG("EGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(( /* *(pPktHdr->pIpv4Sip)*/egress_sip < pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start) ||
						( /* *(pPktHdr->pIpv4Sip)*/egress_sip > pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end) ){
						DEBUG("EGRESS_SIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",/* *(pPktHdr->pIpv4Sip)*/egress_sip,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_src_ipv4_addr_range_end);
						goto unhit;
					}
					break;
			}
		}


		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_DIP_RANGE){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->ipv4Dip < pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start) ||
						(pPktHdr->ipv4Dip > pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end) ){
						DEBUG("EGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Dip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->ipv4Sip < pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start) ||
						(pPktHdr->ipv4Sip > pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end) ){
						DEBUG("EGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->ipv4Sip < pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start) ||
						(pPktHdr->ipv4Sip > pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end) ){
						DEBUG("EGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",pPktHdr->ipv4Sip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if((/* *(pPktHdr->pIpv4Dip)*/egress_dip < pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start) ||
						(/* *(pPktHdr->pIpv4Dip)*/egress_dip > pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end) ){
						DEBUG("EGRESS_DIP_RANGE UNHIT: pkt=0x%x rule=0x%x~0x%x",/* *(pPktHdr->pIpv4Dip)*/egress_dip,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_start,pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr_range_end);
						goto unhit;
					}
					break;
			}
		}


		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_SPORT_RANGE){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("INGRESS_SPORT_RANGE UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((/* *(pPktHdr->pSport)*/egress_sport< pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start) ||
						(/* *(pPktHdr->pSport)*/egress_sport > pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end)){
						DEBUG("EGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",/* *(pPktHdr->pSport)*/egress_sport,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->dport < pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start) ||
						(pPktHdr->dport > pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end)){
						DEBUG("EGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->dport < pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start) ||
						(pPktHdr->dport > pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end)){
						DEBUG("EGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->dport,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if((/* *(pPktHdr->pSport)*/egress_sport < pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start) ||
						(/* *(pPktHdr->pSport)*/egress_sport > pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end)){
						DEBUG("EGRESS_SPORT_RANGE UNHIT: pkt=%d rule=%d~%d",/* *(pPktHdr->pSport)*/egress_sport,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_src_l4_port_range_end);
						goto unhit;
					}
					break;
			}
		}


		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_DPORT_RANGE){
			if(pPktHdr->tagif&ICMP_TAGIF){
				DEBUG("INGRESS_DPORT_RANGE UNHIT: pkt is ICMP rule=%d",pCurrentCheckRule->naptFilter.ingress_src_l4_port);
				goto unhit;
			}
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
					if((/* *(pPktHdr->pDport)*/egress_dport < pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start) ||
						(/* *(pPktHdr->pDport)*/egress_dport > pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end)){
						DEBUG("EGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",/* *(pPktHdr->pDport)*/egress_dport,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
					if((pPktHdr->sport < pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start) ||
						(pPktHdr->sport > pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end)){
						DEBUG("EGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if((pPktHdr->sport < pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start) ||
						(pPktHdr->sport > pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end)){
						DEBUG("EGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",pPktHdr->sport,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if((/* *(pPktHdr->pDport)*/egress_dport < pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start) ||
						(/* *(pPktHdr->pDport)*/egress_dport > pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end)){
						DEBUG("EGRESS_DPORT_RANGE UNHIT: pkt=%d rule=%d~%d",/* *(pPktHdr->pDport)*/egress_dport,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_start,pCurrentCheckRule->naptFilter.egress_dest_l4_port_range_end);
						goto unhit;
					}
					break;
			}
		}



		if(pCurrentCheckRule->naptFilter.filter_fields & INGRESS_SMAC){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(memcmp(pPktHdr->smac,pCurrentCheckRule->naptFilter.ingress_smac.octet,ETHER_ADDR_LEN)!=0){
						DEBUG("INGRESS_SMAC UNHIT: pkt=%02x:%02x:%02x:%02x:%02x:%02x rule=%02x:%02x:%02x:%02x:%02x:%02x",
							pPktHdr->smac[0],pPktHdr->smac[1],pPktHdr->smac[2],pPktHdr->smac[3],pPktHdr->smac[4],pPktHdr->smac[5],
							pCurrentCheckRule->naptFilter.ingress_smac.octet[0],pCurrentCheckRule->naptFilter.ingress_smac.octet[1],pCurrentCheckRule->naptFilter.ingress_smac.octet[2],pCurrentCheckRule->naptFilter.ingress_smac.octet[3],pCurrentCheckRule->naptFilter.ingress_smac.octet[4],pCurrentCheckRule->naptFilter.ingress_smac.octet[5]);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(memcmp(egress_dmac,pCurrentCheckRule->naptFilter.ingress_smac.octet,ETHER_ADDR_LEN)!=0){
						DEBUG("INGRESS_SMAC UNHIT: pkt=%02x:%02x:%02x:%02x:%02x:%02x rule=%02x:%02x:%02x:%02x:%02x:%02x",
								egress_dmac[0],egress_dmac[1],egress_dmac[2],egress_dmac[3],egress_dmac[4],egress_dmac[5],
								pCurrentCheckRule->naptFilter.ingress_smac.octet[0],pCurrentCheckRule->naptFilter.ingress_smac.octet[1],pCurrentCheckRule->naptFilter.ingress_smac.octet[2],pCurrentCheckRule->naptFilter.ingress_smac.octet[3],pCurrentCheckRule->naptFilter.ingress_smac.octet[4],pCurrentCheckRule->naptFilter.ingress_smac.octet[5]);
						goto unhit;
					}
					break;
			}
		}


		if(pCurrentCheckRule->naptFilter.filter_fields & EGRESS_DMAC){
			switch(check_direct){
				case CHECK_OUTBOUND_PKT_WITH_OUTBOUND_RULE:
				case CHECK_INBOUND_PKT_WITH_INBOUND_RULE:
					if(memcmp(/*pPktHdr->pDmac*/egress_dmac,pCurrentCheckRule->naptFilter.egress_dmac.octet,ETHER_ADDR_LEN)!=0){ //pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr
							DEBUG("EGRESS_DMAC UNHIT: pkt=%02x:%02x:%02x:%02x:%02x:%02x rule=%02x:%02x:%02x:%02x:%02x:%02x",
								egress_dmac[0],egress_dmac[1],egress_dmac[2],egress_dmac[3],egress_dmac[4],egress_dmac[5],
								pCurrentCheckRule->naptFilter.egress_dmac.octet[0],pCurrentCheckRule->naptFilter.egress_dmac.octet[1],pCurrentCheckRule->naptFilter.egress_dmac.octet[2],pCurrentCheckRule->naptFilter.egress_dmac.octet[3],pCurrentCheckRule->naptFilter.egress_dmac.octet[4],pCurrentCheckRule->naptFilter.egress_dmac.octet[5]);
						goto unhit;
					}
					break;
				case CHECK_OUTBOUND_PKT_WITH_INBOUND_RULE:
				case CHECK_INBOUND_PKT_WITH_OUTBOUND_RULE:
					if(memcmp(/*pPktHdr->smac*/egress_smac,pCurrentCheckRule->naptFilter.egress_dmac.octet,ETHER_ADDR_LEN)!=0){ //pPktHdr->ipv4Dip!=pCurrentCheckRule->naptFilter.egress_dest_ipv4_addr
							DEBUG("EGRESS_DMAC UNHIT: pkt=%02x:%02x:%02x:%02x:%02x:%02x rule=%02x:%02x:%02x:%02x:%02x:%02x",
								egress_smac[0],egress_smac[1],egress_smac[2],egress_smac[3],egress_smac[4],egress_smac[5],
								pCurrentCheckRule->naptFilter.egress_dmac.octet[0],pCurrentCheckRule->naptFilter.egress_dmac.octet[1],pCurrentCheckRule->naptFilter.egress_dmac.octet[2],pCurrentCheckRule->naptFilter.egress_dmac.octet[3],pCurrentCheckRule->naptFilter.egress_dmac.octet[4],pCurrentCheckRule->naptFilter.egress_dmac.octet[5]);
						goto unhit;
					}
					break;
			}
		}


//hit:
		if(rule_direction==RG_FWD_DECISION_NAPT){
			TRACE("Hit Upstream NaptFilter[%d]",pCurrentCheckRule->sw_index);
		}else{
			TRACE("Hit Downstream NaptFilter[%d]",pCurrentCheckRule->sw_index);
		}
		return pCurrentCheckRule->sw_index;

unhit:
		pCurrentCheckRule = pCurrentCheckRule->pNextValid;
		i++;
	}

	return RG_RET_ENTRY_NOT_GET;

}

void _rtk_rg_copyWork_handler(struct work_struct *work)
{
	rtk_rg_sw_copyToPSWork_t *copyWork;
	copyWork = container_of(work, rtk_rg_sw_copyToPSWork_t, copy_work);

	copyWork->copy_skb->fwd_drop=1;	//drop it when protocol stack send out the copy packet
	//WARNING("the copyWork->copy_skb dev is %s, port_num is %d",copyWork->copy_skb->dev->name,(((rtk_rg_rxdesc_t *)&copyWork->copy_rxInfo)->rx_src_port_num));
	//dump_packet(copyWork->copy_skb->data,copyWork->copy_skb->len,"copy to netif_rx");
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	if(copyWork->copy_wlan_idx!=RG_RET_MBSSID_NOT_FOUND)
	{
		if(_rtk_rg_fwdEngine_fromWifiToProtocolStack(copyWork->copy_skb, copyWork->copy_wlan_idx)==RG_RET_FAIL)
			_rtk_rg_dev_kfree_skb_any(copyWork->copy_skb);
		else
			netif_rx(copyWork->copy_skb);
	}
	else
#endif
#if defined(CONFIG_RG_G3_SERIES)
		nic_rxhook_default(NULL, copyWork->copy_skb->dev, copyWork->copy_skb , NULL);
#else	
		re8670_rx_skb(((struct re_dev_private*)copyWork->copy_skb->dev->priv)->pCp,copyWork->copy_skb,&copyWork->copy_rxInfo);
#endif
		

	//garbage collection
	//if(naptWork->copy_skb)_rtk_rg_dev_kfree_skb_any(naptWork->copy_skb);
	rtk_rg_free(copyWork);
}

void _rtk_rg_naptFilterCopyToPS(rtk_rg_pktHdr_t *pPktHdr)
{
	pPktHdr->pFlowCopyWork=rtk_rg_malloc(sizeof(rtk_rg_sw_copyToPSWork_t));
	if(pPktHdr->pFlowCopyWork)
	{
		pPktHdr->pFlowCopyWork->copy_skb=rtk_rg_skbCopyToPreAllocSkb(pPktHdr->skb);
		if(pPktHdr->pFlowCopyWork->copy_skb)
		{
			//keep original skb dev here
			pPktHdr->pFlowCopyWork->copy_skb->dev=pPktHdr->skb->dev;
			memcpy(&pPktHdr->pFlowCopyWork->copy_rxInfo,(struct rx_info *)pPktHdr->pRxDesc,sizeof(struct rx_info));
#if defined(CONFIG_MASTER_WLAN0_ENABLE)
			pPktHdr->pFlowCopyWork->copy_wlan_idx=pPktHdr->wlan_dev_idx;
#endif
			INIT_WORK(&pPktHdr->pFlowCopyWork->copy_work, _rtk_rg_copyWork_handler);
		}
	}
}

rtk_rg_fwdEngineReturn_t _rtk_rg_napt_trap_to_ps(int direct, rtk_rg_pktHdr_t *pPktHdr, int naptIdx,int l3Modify,int l4Modify){

	//int ret;
	rtk_rg_entryGetReturn_t outBoundHitIdx;
	rtk_rg_entryGetReturn_t inBoundHitIdx;

	outBoundHitIdx = _rtk_rg_naptPriority_pattern_check(RG_FWD_DECISION_NAPT, direct ,pPktHdr, rg_db.systemGlobal.pValidUsNaptPriorityRuleStart,direct,naptIdx,l3Modify,l4Modify);
	if(outBoundHitIdx!=RG_RET_ENTRY_NOT_GET)
	{
		if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_TRAP_TO_PS)
		{
			//packet count musct at the same trap rule, otherwise the packet_count will do at _rtk_rg_naptPriority_assign
			if((rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT)||(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT))
			{
				pPktHdr->addNaptAfterNicTx=0;
				
				if(direct == NAPT_DIRECTION_OUTBOUND){
					if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT){
						rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.packet_count++;		
						DEBUG("naptFilter[%d] packet count: %d",outBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.packet_count);
					}
					if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT){
						rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.byte_count+=pPktHdr->skb->len;		
						DEBUG("naptFilter[%d] byte count: %d",outBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.byte_count);
					}
				}
				
				//delete shortcut
				if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
					pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					pPktHdr->pCurrentShortcutEntry=NULL;
					pPktHdr->pInboundShortcutEntry=NULL;
#else				
					_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
					if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
						if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
							_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
					}
#endif
				}		
			}

			if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.ruleType==RTK_RG_NAPT_FILTER_ONE_SHOT){
				(pf.rtk_rg_naptFilterAndQos_del)(outBoundHitIdx);
				TRACE("naptFilter[%d] outbound one shot rule is hit and removed!",outBoundHitIdx);
			}

			//Do not add to hw for this flow, also remove shortcut created
			pPktHdr->addNaptAfterNicTx=0;
			if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
				pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				pPktHdr->pCurrentShortcutEntry=NULL;
				pPktHdr->pInboundShortcutEntry=NULL;
#else
				_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
				if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
					if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
						_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
				}
#endif
			}

			TRACE("[To PS] Trap to PS by naptFilter!(before NAPT modificastion)");			
			return RG_FWDENGINE_RET_TO_PS;
		}
		else if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_COPY_TO_PS)
		{
			pPktHdr->naptFilterCopyCnt = rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.assign_copy_num;
			DEBUG("naptFilter[%d] should copy original packet %d times when directTx",outBoundHitIdx,pPktHdr->naptFilterCopyCnt);
			//copy skb, allocate work here
			_rtk_rg_naptFilterCopyToPS(pPktHdr);
			TRACE("Copy to PS by naptFilter!(before NAPT modification)");
			return RG_FWDENGINE_RET_CONTINUE;
		}
	}

	inBoundHitIdx = _rtk_rg_naptPriority_pattern_check(RG_FWD_DECISION_NAPTR, direct, pPktHdr, rg_db.systemGlobal.pValidDsNaptPriorityRuleStart,direct,naptIdx,l3Modify,l4Modify);	
	if(inBoundHitIdx!=RG_RET_ENTRY_NOT_GET)
	{
		if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_TRAP_TO_PS)
		{
			if((rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT)||(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT))
			{
				pPktHdr->addNaptAfterNicTx=0;

				if(direct == NAPT_DIRECTION_INBOUND){
					if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT){
						rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.packet_count++;
						DEBUG("naptFilter[%d] packet count: %d",inBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.packet_count);
					}
					
					if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT){
						rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.byte_count+=pPktHdr->skb->len;
						DEBUG("naptFilter[%d] byte count: %d",inBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.byte_count);
					}
				}

				//delete shortcut
				if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
					pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					pPktHdr->pCurrentShortcutEntry=NULL;
					pPktHdr->pInboundShortcutEntry=NULL;
#else				
					_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
					if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
						if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
							_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
					}
#endif
				}
			}

			//Do not add to hw for this flow, also remove shortcut created
			pPktHdr->addNaptAfterNicTx=0;
			if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
				pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				pPktHdr->pCurrentShortcutEntry=NULL;
				pPktHdr->pInboundShortcutEntry=NULL;
#else
				_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
				if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
					if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
						_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
				}
#endif
			}

			TRACE("[To PS] Trap to PS by naptFilter!");
			return RG_FWDENGINE_RET_TO_PS;
		}
		else if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_COPY_TO_PS)
		{
			pPktHdr->naptFilterCopyCnt = rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.assign_copy_num;
			DEBUG("naptFilter[%d] should copy original packet %d times when directTx",inBoundHitIdx,pPktHdr->naptFilterCopyCnt);
			//copy skb, allocate work here
			_rtk_rg_naptFilterCopyToPS(pPktHdr);
			TRACE("Copy to PS by naptFilter!(before NAPT modification)");
			return RG_FWDENGINE_RET_CONTINUE;
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_naptPriority_assign(int direct, rtk_rg_pktHdr_t *pPktHdr, rtk_rg_table_naptOut_t *naptout_entry, rtk_rg_table_naptIn_t *naptin_entry,int naptIdx,int l3Modify,int l4Modify){

	//int ret;
	rtk_rg_entryGetReturn_t outBoundHitIdx;
	rtk_rg_entryGetReturn_t inBoundHitIdx;

	outBoundHitIdx = _rtk_rg_naptPriority_pattern_check(RG_FWD_DECISION_NAPT, direct ,pPktHdr, rg_db.systemGlobal.pValidUsNaptPriorityRuleStart,direct,naptIdx,l3Modify,l4Modify);
	if(outBoundHitIdx!=RG_RET_ENTRY_NOT_GET){

		if((rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT)||(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT))
		{
			pPktHdr->addNaptAfterNicTx=0;

			if(direct == NAPT_DIRECTION_OUTBOUND){
				if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT){
					pPktHdr->naptFilterPktCntIdx = outBoundHitIdx;
					DEBUG("naptFilter[%d] should add packet count when directTx",outBoundHitIdx);
					//rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.packet_count++;
					//DEBUG("naptFilter[%d] packet count: %d",outBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.packet_count);
				}
				if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT){
					pPktHdr->naptFilterByteCnttIdx = outBoundHitIdx;
					DEBUG("naptFilter[%d] should add byte count when directTx",outBoundHitIdx);
					//rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.byte_count+=pPktHdr->skb->len;
					//DEBUG("naptFilter[%d] byte count: %d",outBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.byte_count);
				}
			}

		}

		if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_DROP_BIT){
			if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT)
			{
				DEBUG("naptFilter[%d] should add packet count before drop",outBoundHitIdx);
				rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.packet_count++;
			}
			if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT)
			{
				DEBUG("naptFilter[%d] should add byte count before drop",outBoundHitIdx);
				rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.byte_count+=pPktHdr->skb->len;
			}
			TRACE("[Drop] Drop by naptFilter!");
			return RG_FWDENGINE_RET_DROP;
		}
		else if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_TRAP_TO_PS){
			//Do not add to hw for this flow, also remove shortcut created
			pPktHdr->addNaptAfterNicTx=0;
			if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
				pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				pPktHdr->pCurrentShortcutEntry=NULL;
				pPktHdr->pInboundShortcutEntry=NULL;
#else
				_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
				if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
					if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
						_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
				}
#endif
			}

			TRACE("[To PS] Trap to PS by naptFilter!(after NAPT modification)");
			return RG_FWDENGINE_RET_TO_PS;
		}
		else if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_PERMIT_BIT)
		{
			//Do not add to hw for this flow, also remove shortcut created
			pPktHdr->addNaptAfterNicTx=0;
			if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
				pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				pPktHdr->pCurrentShortcutEntry=NULL;
				pPktHdr->pInboundShortcutEntry=NULL;
#else
				_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
				if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
					if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
						_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
				}
#endif
			}
			TRACE("Permit naptFilter!");
			//do nothing
		}
		if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & ASSIGN_NAPT_PRIORITY_BIT){
			if(pPktHdr->tagif&ICMP_TAGIF){
				TRACE("ICMP packet not suport napt_out priority assign! The naptFilter[%d] is useless!",outBoundHitIdx);
			}else{
			//sw
			naptout_entry->priValid=1;
			naptout_entry->priValue=rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.assign_priority;
			//hw
			naptout_entry->rtk_naptOut.priValid=1;
			naptout_entry->rtk_naptOut.priValue=rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.assign_priority;

			TRACE("assign napt_out[%d] priority to %d",naptout_entry->hashOutIdx,naptout_entry->priValue);
			}
		}
		if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.action_fields & NAPT_SW_RATE_LIMIT_BIT){

				pPktHdr->addNaptAfterNicTx=0;
				TRACE("Hit rate limit napt_out by naptFilter[%d], skip add HW NAPT/NAPTr entry.",rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].sw_index);

				if(direct==NAPT_DIRECTION_OUTBOUND)//outbound rule limit rate only for outbound flow
				{
					pPktHdr->naptFilterRateLimitIdx = rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].sw_index;
					TRACE("Rate Limit napt_out by naptFilter[%d]",rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].sw_index);
					//packet exceeding rate will be dropped when directTX
				}
		}



		if(rg_db.systemGlobal.napt_SW_table_entry[outBoundHitIdx].naptFilter.ruleType==RTK_RG_NAPT_FILTER_ONE_SHOT){
			(pf.rtk_rg_naptFilterAndQos_del)(outBoundHitIdx);
			TRACE("naptFilter[%d] outbound one shot rule is hit and removed!",outBoundHitIdx);
		}

	}

	inBoundHitIdx = _rtk_rg_naptPriority_pattern_check(RG_FWD_DECISION_NAPTR, direct, pPktHdr, rg_db.systemGlobal.pValidDsNaptPriorityRuleStart,direct,naptIdx,l3Modify,l4Modify);
	if(inBoundHitIdx!=RG_RET_ENTRY_NOT_GET){

		if((rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT)||(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT))
		{
			pPktHdr->addNaptAfterNicTx=0;

			if(direct == NAPT_DIRECTION_INBOUND){
				if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT){
					pPktHdr->naptFilterPktCntIdx = inBoundHitIdx;
					DEBUG("naptFilter[%d] should add packet count when directTx");
					//rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.packet_count++;
					//DEBUG("naptFilter[%d] packet count: %d",inBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.packet_count);
				}
				if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT){
					pPktHdr->naptFilterByteCnttIdx = inBoundHitIdx;
					DEBUG("naptFilter[%d] should add byte count when directTx");
					//rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.byte_count+=pPktHdr->skb->len;
					//DEBUG("naptFilter[%d] byte count: %d",inBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.byte_count);
				}
			}
		}

		if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_DROP_BIT){

			//Do not add to hw for this flow, also remove shortcut created
			pPktHdr->addNaptAfterNicTx=0;
			if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
				pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				pPktHdr->pCurrentShortcutEntry=NULL;
				pPktHdr->pInboundShortcutEntry=NULL;
#else
				_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
				if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
					if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
						_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
				}
#endif
			}

			if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_PACKET_COUNT)
			{
				rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.packet_count++;
				DEBUG("naptFilter[%d] should add packet count before drop (packet count: %d)",inBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.packet_count);
			}
			if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_BYTE_COUNT)
			{
				rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.byte_count+=pPktHdr->skb->len;
				DEBUG("naptFilter[%d] should add byte count before drop (byte count: %d)",inBoundHitIdx,rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.byte_count);
			}

			TRACE("[Drop] Drop by naptFilter!");
			return RG_FWDENGINE_RET_DROP;
		}
		else if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_TRAP_TO_PS){
			//Do not add to hw for this flow, also remove shortcut created
			pPktHdr->addNaptAfterNicTx=0;
			if(pPktHdr->shortcutStatus!=RG_SC_NORMAL_PATH){
				pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				pPktHdr->pCurrentShortcutEntry=NULL;
				pPktHdr->pInboundShortcutEntry=NULL;
#else
				_rtk_rg_v4ShortCut_delete(pPktHdr->currentShortcutIdx);
				if((direct==NAPT_DIRECTION_OUTBOUND)&&(pPktHdr->tagif&TCP_TAGIF)){
					if(rg_db.systemGlobal.tcp_hw_learning_at_syn==1 && rg_db.systemGlobal.tcp_in_shortcut_learning_at_syn)
						_rtk_rg_v4ShortCut_delete(pPktHdr->inboundShortcutIdx);
				}
#endif
			}

			TRACE("[To PS] Trap to PS by naptFilter!");
			return RG_FWDENGINE_RET_TO_PS;

		}
		else if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_PERMIT_BIT)
		{
			TRACE("Permit naptFilter!");
			//do nothing
		}
		if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & ASSIGN_NAPT_PRIORITY_BIT){

			if(pPktHdr->tagif&ICMP_TAGIF){
				TRACE("ICMP packet not suport napt_in priority assign! The naptFilter[%d] is useless!",inBoundHitIdx);
			}else{
			//sw
			naptin_entry->priValid=1;
			naptin_entry->priValue=rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.assign_priority;
			//hw
			naptin_entry->rtk_naptIn.priValid=1;
			naptin_entry->rtk_naptIn.priId=rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.assign_priority;
			TRACE("assign napt_in[%d] priority to %d",naptin_entry->hashIdx,naptin_entry->priValue);
			}
		}
		if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.action_fields & NAPT_SW_RATE_LIMIT_BIT){

				pPktHdr->addNaptAfterNicTx=0;
				TRACE("Hit rate limit napt_in by naptFilter[%d], skip add HW NAPT/NAPTr entry.",rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].sw_index);

				if(direct==NAPT_DIRECTION_INBOUND) //outbound rule limit rate only for outbound flow
				{
					pPktHdr->naptFilterRateLimitIdx = rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].sw_index;
					TRACE("Rate Limit napt_in by naptFilter[%d].",rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].sw_index);
					//packet exceeding rate will be dropped when directTX
				}
		}

		if(rg_db.systemGlobal.napt_SW_table_entry[inBoundHitIdx].naptFilter.ruleType==RTK_RG_NAPT_FILTER_ONE_SHOT){
			(pf.rtk_rg_naptFilterAndQos_del)(inBoundHitIdx);
			TRACE("naptFilter[%d] inbound one shot rule is hit and removed!",inBoundHitIdx);
		}

	}

	return RG_FWDENGINE_RET_CONTINUE;
}
#endif

__IRAM_FWDENG
void _rtk_rg_tcpSwapConnection(rtk_rg_pktHdr_t *pPktHdr, uint32 naptOutIdx)
{
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	int new_outIdx=RG_RET_ENTRY_NOT_GET, new_inIdx=RG_RET_ENTRY_NOT_GET;
	int inIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;

	if(naptOutIdx<MAX_NAPT_OUT_HW_TABLE_SIZE && inIdx<MAX_NAPT_IN_HW_TABLE_SIZE){
#if defined(CONFIG_RG_NAPT_NEW_EXTPORT_MECHANISM)
		assert(_rtk_rg_naptExtPortGetAndUse(rg_db.naptOut[naptOutIdx].forceExtPort, rg_db.naptIn[inIdx].rtk_naptIn.isTcp, rg_db.naptIn[inIdx].rtk_naptIn.intIp, rg_db.naptIn[inIdx].rtk_naptIn.intPort, rg_db.naptOut[naptOutIdx].extPort, NULL, TRUE, rg_db.naptOut[naptOutIdx].naptrLookupHit) == rg_db.naptOut[naptOutIdx].extPort);
#else
		assert(_rtk_rg_naptExtPortGetAndUse(TRUE, rg_db.naptIn[inIdx].rtk_naptIn.isTcp, rg_db.naptIn[inIdx].rtk_naptIn.intIp, rg_db.naptIn[inIdx].rtk_naptIn.intPort, rg_db.naptOut[naptOutIdx].extPort, NULL, TRUE, rg_db.naptOut[naptOutIdx].naptrLookupHit) == rg_db.naptOut[naptOutIdx].extPort);
#endif
		new_outIdx=_rtk_rg_swNaptOutFreeEntryGet(naptOutIdx>>2);
		assert(new_outIdx>=0);
		new_inIdx=_rtk_rg_swNaptInFreeEntryGet(inIdx>>2);
		assert(new_inIdx>=0);
		if(new_outIdx>=0 && new_inIdx>=0){
			memcpy(&rg_db.naptOut[new_outIdx],&rg_db.naptOut[naptOutIdx],sizeof(rtk_rg_table_naptOut_t));
			memcpy(&rg_db.naptIn[new_inIdx],&rg_db.naptIn[inIdx],sizeof(rtk_rg_table_naptIn_t));
			rg_db.naptOut[new_outIdx].rtk_naptOut.hashIdx=new_inIdx;
			rg_db.naptOut[new_outIdx].hashOutIdx=naptOutIdx>>2;
			rg_db.naptOut[new_outIdx].idleSecs=0;
			rg_db.naptOut[new_outIdx].pContext=NULL;
			rg_db.naptIn[new_inIdx].symmetricNaptOutIdx=new_outIdx;
			rg_db.naptIn[new_inIdx].hashIdx=inIdx>>2;
			rg_db.naptIn[new_inIdx].idleSecs=0;
			if(rg_db.naptOut[new_outIdx].recordedInLimitCount==1)
			{
				atomic_inc(&rg_db.systemGlobal.naptAccessLimitCount);
				TRACE("[add napt counter(%d)] napt outIdx[%d]", atomic_read(&rg_db.systemGlobal.naptAccessLimitCount), new_outIdx);
			}
			pPktHdr->delNaptConnection=1;
		}
	}
#else // CONFIG_RG_FLOW_BASED_PLATFORM
	assert_ok(_rtk_rg_swapHwFlowOfNaptToSw(naptOutIdx));
#endif
}

void _rtk_rg_tcpShortTimeoutRecycle(uint16 naptOutIdx)
{
	if(rg_db.tcpShortTimeoutFreedIdx==rg_db.tcpShortTimeoutRecycleIdx && rg_db.tcpShortTimeoutRing[rg_db.tcpShortTimeoutRecycleIdx].naptOutIdx!=FAIL)
	{
		_rtk_rg_tcpShortTimeoutHouseKeepingHandler(rg_db.tcpShortTimeoutRing[rg_db.tcpShortTimeoutRecycleIdx].naptOutIdx);
		rg_db.tcpShortTimeoutForceRecycleCnt++;
	}
	rg_db.tcpShortTimeoutRing[rg_db.tcpShortTimeoutRecycleIdx].naptOutIdx=naptOutIdx;
	rg_db.tcpShortTimeoutRing[rg_db.tcpShortTimeoutRecycleIdx].timeoutJiffies=(u32)jiffies+rg_db.systemGlobal.tcpShortTimeoutHousekeepJiffies;
	rg_db.tcpShortTimeoutRecycleIdx++;
	if(rg_db.tcpShortTimeoutRecycleIdx>=MAX_TCP_SHORT_TIMEOUT_HOUSEKEEP_RING_SIZE)
		rg_db.tcpShortTimeoutRecycleIdx=0;
}

__IRAM_FWDENG
void _rtk_rg_fwdEngine_receivedTCPReset(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
	//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
	rg_db.naptOut[*pNaptOutIdx].state=RST_RECV;

	//20160823LUKE: for disable TCP stateful tracking, we should not delete connection when receive RST here.
	if(rg_db.systemGlobal.tcpSwapFinDelRst && !rg_db.systemGlobal.tcpDisableStatefulTracking){
		//20160705LUKE: delete rst_receive connection
		pPktHdr->delNaptConnection=1;
	}else if(rg_db.systemGlobal.tcpDoNotDelWhenRstFin){
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
{
		int inIdx;
		inIdx=rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.hashIdx;
		//20151208LUKE: we must make sure both inbound and outbound entries are locate in hw table, otherwise this flow can't be replace.
		if((*pNaptOutIdx<MAX_NAPT_OUT_HW_TABLE_SIZE)&&(inIdx<MAX_NAPT_IN_HW_TABLE_SIZE)){
			rg_db.naptOut[*pNaptOutIdx].canBeReplaced=1;
			rg_db.naptIn[inIdx].canBeReplaced=1;
		}
}
#else // CONFIG_RG_FLOW_BASED_PLATFORM
{
		rtk_rg_naptRecorded_flow_linkList_t *pFlowEntry, *pNextFlowEntry;
		ptrdiff_t flowEntryIdx;

		if(!_rtk_rg_list_head_empty(&rg_db.naptOut[*pNaptOutIdx].flowListHead))
		{
			_rtk_rg_list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &(rg_db.naptRecordedFlowList[0]), &rg_db.naptOut[*pNaptOutIdx].flowListHead, flow_idxList) //just return the first entry right behind of head
			{
				flowEntryIdx = _rtk_rg_list_entry_idx(pFlowEntry, &(rg_db.naptRecordedFlowList[0])); //use address-based method to get naptRecordedFlowList entry index. (naptRecordedFlowList[i] mapping to flow[i])
				rg_db.flow[flowEntryIdx].canBeReplaced=1;
			}
		}
}
#endif
	}else if(rg_db.systemGlobal.tcpShortTimeoutHousekeepJiffies){
		_rtk_rg_tcpShortTimeoutRecycle(*pNaptOutIdx);
	}else if(rg_db.systemGlobal.tcp_short_timeout<=1){
		pPktHdr->delNaptConnection=1;
	}
}
__IRAM_FWDENG
void _rtk_rg_fwdEngine_receivedTCPFin(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx, rtk_rg_naptState_t newState)
{
	int inIdx;
	//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
	if(rg_db.naptOut[*pNaptOutIdx].state==TCP_CONNECTED)
	{
		rg_db.naptOut[*pNaptOutIdx].state=newState;

		if(rg_db.systemGlobal.tcpSwapFinDelRst){
			//20160705LUKE: swap fin_receive connection to sw napt and delete hw napt
			_rtk_rg_tcpSwapConnection(pPktHdr,*pNaptOutIdx);
		}else if(rg_db.systemGlobal.tcpDoNotDelWhenRstFin){
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
{
			inIdx=rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.hashIdx;
			//20151208LUKE: we must make sure both inbound and outbound entries are locate in hw table, otherwise this flow can't be replace.
			if((*pNaptOutIdx<MAX_NAPT_OUT_HW_TABLE_SIZE)&&(inIdx<MAX_NAPT_IN_HW_TABLE_SIZE)){
				rg_db.naptOut[*pNaptOutIdx].canBeReplaced=1;
				rg_db.naptIn[inIdx].canBeReplaced=1;
			}
}
#else // CONFIG_RG_FLOW_BASED_PLATFORM
{
		rtk_rg_naptRecorded_flow_linkList_t *pFlowEntry, *pNextFlowEntry;
		ptrdiff_t flowEntryIdx;

		if(!_rtk_rg_list_head_empty(&rg_db.naptOut[*pNaptOutIdx].flowListHead))
		{
			_rtk_rg_list_for_each_entry_safe(pFlowEntry, pNextFlowEntry, &(rg_db.naptRecordedFlowList[0]), &rg_db.naptOut[*pNaptOutIdx].flowListHead, flow_idxList)	//just return the first entry right behind of head
			{
				flowEntryIdx = _rtk_rg_list_entry_idx(pFlowEntry, &(rg_db.naptRecordedFlowList[0])); //use address-based method to get naptRecordedFlowList entry index. (naptRecordedFlowList[i] mapping to flow[i])
				rg_db.flow[flowEntryIdx].canBeReplaced=1;
			}
		}
}
#endif
		}else if(rg_db.systemGlobal.tcpShortTimeoutHousekeepJiffies){
			_rtk_rg_tcpShortTimeoutRecycle(*pNaptOutIdx);
		}
	}
	else if(rg_db.naptOut[*pNaptOutIdx].state!=newState)	//FIN_IN come with FIN_OUT or FIN_OUT come with FIN_IN
	{
		rg_db.naptOut[*pNaptOutIdx].state=FIN_SEND_AND_RECV;
		inIdx=rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.hashIdx;

		if(!rg_db.systemGlobal.tcpDoNotDelWhenRstFin && !rg_db.systemGlobal.tcpSwapFinDelRst)
		{
			if(rg_db.systemGlobal.tcp_short_timeout<=1)
			{
				// delete HW entry but keep software entry for the last ack.
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.valid=ASIC_NAPT_IN_TYPE_INVALID; //let outbound last ack is able to handle by software.
				RTK_L34_NAPTOUTBOUNDTABLE_SET(1,*pNaptOutIdx,&rg_db.naptOut[*pNaptOutIdx].rtk_naptOut);
				rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.valid=1;
				TABLE("del NAPT HW entry out[%d]",*pNaptOutIdx);

				if(rg_db.naptIn[inIdx].rtk_naptIn.valid==ASIC_NAPT_IN_TYPE_PORT_RESTRICTED_CONE)
				{
					rg_db.naptIn[inIdx].rtk_naptIn.valid=ASIC_NAPT_IN_TYPE_INVALID; //let inbound last ack is able to handle by software.
					RTK_L34_NAPTINBOUNDTABLE_SET(1,inIdx,&rg_db.naptIn[inIdx].rtk_naptIn);
					rg_db.naptIn[inIdx].rtk_naptIn.valid=ASIC_NAPT_IN_TYPE_PORT_RESTRICTED_CONE;
					TABLE("del NAPT HW entry in[%d]",inIdx);
				}
				//Clear shortcut for Last_ACK enter slow path to finish the connection.
				_rtk_rg_delNaptShortCutEntrybyOutboundIdx(*pNaptOutIdx);
#else // CONFIG_RG_FLOW_BASED_PLATFORM
				assert_ok(_rtk_rg_flow_del_by_naptOutIdx(*pNaptOutIdx, TRUE));
				if(rg_db.naptOut[*pNaptOutIdx].urlPriEn)
				{
					rtk_rg_hiPriEntryIdx_t* p_hiPriEtIdx;
					rtk_rg_hiPriEntryIdx_t* p_hiPriEtIdx_tmp;
					list_for_each_entry_safe(p_hiPriEtIdx,p_hiPriEtIdx_tmp,&rg_db.systemGlobal.urlHiPri_table_entry[rg_db.naptOut[*pNaptOutIdx].urlPriIdx].hiPriEntryIdxListHdr,hiPriEntryIdx_list) 
					{
						if(p_hiPriEtIdx->connectId==(*pNaptOutIdx))
						{
							rtk_rg_apolloPro_HiPriEntry_del(p_hiPriEtIdx->hiPriEntryIdx);
							rtk_rg_apolloPro_HiPriEntry_del(p_hiPriEtIdx->hiPriEntryIdx2);						
							list_move(&p_hiPriEtIdx->hiPriEntryIdx_list,&rg_db.systemGlobal.urlHiPriIdxfreeEntry); 
							break;
						}
					}
				}

#endif


			}
		}
	}

	//if(rg_db.systemGlobal.tcp_short_timeout<=1) pPktHdr->delNaptConnection=1;
}
static char* rgHttpRedirectHead =
	"HTTP/1.1 302 Object Moved\r\n"
	"Location: http://%s%s\r\n"
	"Server: adsl-router-gateway\r\n"
	"Content-Type: text/html\r\n"
	"Content-Length: %d\r\n"
	"\r\n"
	"%s";
static char* rgHttpRedirectContent =
	"<html><head><title>Object Moved</title></head>"
	"<body><h1>Object Moved</h1>This Object may be found in "
	"<a HREF=\"http://%s%s\">here</a>.</body><html>";


#if defined(CONFIG_APOLLO_ROMEDRIVER)
static char szRedirectPack[512];
static char szRedirectContent[260];
#endif
int _rtk_rg_redirectGeneration(rtk_rg_pktHdr_t *pPktHdr, int type_idx, char *url_string)
{
#ifdef __KERNEL__
#if defined(CONFIG_APOLLO_ROMEDRIVER)
	struct sk_buff *skb;
	unsigned char *bufptr;
	int ret_code=0;
	int vlan_offset=0;
	int totalLen=0,dataLen=0;
	char *att_url="";
	char *fqdn=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *url_head=NULL;
	char *url_tail=NULL;
	char *path_head=NULL;
	char *path_tail=NULL;
	char *dataStart;
	//use rsvd to save the netif idx for Layer2 forward
	rg_kernel.tracefilterShow =0; //disable tracefilter show
	rg_kernel.rxInfoFromARPND.rx_netIfIdx=pPktHdr->srcNetifIdx;

	skb=_rtk_rg_getAlloc(RG_FWDENGINE_PKT_LEN);
	if(skb==NULL){
		TRACE("alloc skb failed..return");
		return 0;
	}
	//call fwdEngineInput, the alloc counter will be added. so don't need to add again

	if((skb)&&(rg_db.systemGlobal.fwdStatistic))
	{
#if RTK_RG_SKB_PREALLOCATE
		rg_db.systemGlobal.statistic.perPortCnt_skb_pre_alloc_for_uc[rg_db.pktHdr->ingressPort]--;
#else
		rg_db.systemGlobal.statistic.perPortCnt_skb_alloc[rg_db.pktHdr->ingressPort]--;
#endif
	}

	bzero(skb->data,RG_FWDENGINE_PKT_LEN);//clean ptk buffer
	skb_reserve(skb, RX_OFFSET);
	bufptr=skb->data;

	/* Construct destination MAC */
	memcpy(bufptr,pPktHdr->pSmac,ETHER_ADDR_LEN);

	/* Construct source MAC */
	memcpy(bufptr + 6,pPktHdr->pDmac,ETHER_ADDR_LEN);

	if(pPktHdr->tagif&CVLAN_TAGIF)
	{
		unsigned short ctagdata=0;
		vlan_offset=4;
		*(uint16 *)(bufptr + 12)= htons(0x8100);
		ctagdata=(pPktHdr->ctagVid&0xfff);
		ctagdata|=((pPktHdr->ctagCfi&1)<<12);
		ctagdata|=((pPktHdr->ctagPri&0x7)<<13);
		*(uint16 *)(bufptr + 14)= htons(ctagdata);
	}

	//20160514LUKE: support http redirection in bridge mode
	if(pPktHdr->tagif&PPPOE_TAGIF)
	{
		*(uint16 *)(bufptr + 12 + vlan_offset) = htons(0x8864);
		*(uint16 *)(bufptr + 12 + vlan_offset + 2) = htons(pPktHdr->pppoeVerTypeCode);
		*(uint16 *)(bufptr + 12 + vlan_offset + 4) = htons(pPktHdr->sessionId);
		vlan_offset+=8;

		/* construct IP header */
		*(uint32 *)(bufptr + 12 + vlan_offset) = htonl(0x00214500);							//EtherType, version, header length, DS field
	}else{
		/* construct IP header */
		*(uint32 *)(bufptr + 12 + vlan_offset) = htonl(0x08004500);							//EtherType, version, header length, DS field
	}

	/* construct IP header */
	*(uint16 *)(bufptr + 18 + vlan_offset) = htons(0);									//Identification
	*(uint32 *)(bufptr + 20 + vlan_offset) = htonl(0x4000ff06);							//Flags, Fragment offset, TTL, protocol=TCP
	*(uint16 *)(bufptr + 24 + vlan_offset) = htons(0x0);								//Header checksum(caculate by hw)

	if(type_idx<FAIL){
		//20160225LUKE: for redirectHttpRsp, we just replace payload with original header
		*(uint32 *)(bufptr + 26 + vlan_offset) = htonl(pPktHdr->ipv4Sip);					//SIP
		*(uint32 *)(bufptr + 30 + vlan_offset) = htonl(pPktHdr->ipv4Dip);					//DIP
		/* construct TCP header */
		*(uint16 *)(bufptr + 34 + vlan_offset) = htons(pPktHdr->sport);						//SPORT
		*(uint16 *)(bufptr + 36 + vlan_offset) = htons(pPktHdr->dport);						//DPORT
		*(uint32 *)(bufptr + 38 + vlan_offset) = htonl(pPktHdr->tcpSeq);					//Sequence
		*(uint32 *)(bufptr + 42 + vlan_offset) = htonl(pPktHdr->tcpAck);					//Acknowledgment
	}else{
		*(uint32 *)(bufptr + 26 + vlan_offset) = htonl(pPktHdr->ipv4Dip);					//SIP
		*(uint32 *)(bufptr + 30 + vlan_offset) = htonl(pPktHdr->ipv4Sip);					//DIP
		/* construct TCP header */
		*(uint16 *)(bufptr + 34 + vlan_offset) = htons(pPktHdr->dport);						//SPORT
		*(uint16 *)(bufptr + 36 + vlan_offset) = htons(pPktHdr->sport);						//DPORT
		*(uint32 *)(bufptr + 38 + vlan_offset) = htonl(pPktHdr->tcpAck);					//Sequence
		*(uint32 *)(bufptr + 42 + vlan_offset) = htonl(pPktHdr->tcpSeq+(pPktHdr->l3Len-pPktHdr->ipv4HeaderLen-pPktHdr->headerLen));					//Acknowledgment
	}
	*(uint16 *)(bufptr + 46 + vlan_offset) = htons(0x5019);								//DataOff, Flag as reset
	*(uint16 *)(bufptr + 48 + vlan_offset) = htons(pPktHdr->tcpWindow);					//Window
	*(uint32 *)(bufptr + 50 + vlan_offset) = htonl(0);									//Checksum, urgent point

	dataStart = bufptr+54+vlan_offset;

	//20160113LUKE: if we got pushweb content, use it as payload.
	if(rg_db.redirectHttpAll.enable && type_idx==0){
		char *s, *t;
		//20160321LUKE: we have to check pushweb for count, if count equals to zero, continue without redirect!!
		if(rg_db.redirectHttpAll.count!=-1 && rg_db.redirectHttpAll.count--==0){
			_rtk_rg_dev_kfree_skb_any(skb);
			return rg_db.redirectHttpAll.count++;
		}
		//20160204LUKE: if enable is 2, we should write original URL to pushweb!!
		if(rg_db.redirectHttpAll.enable==2){
			_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);
			if(fqdn){
				//cut final '/' if necessary
				if(fqdn[strlen(fqdn)-1]=='/')fqdn[strlen(fqdn)-1]='\0';
				att_url=fqdn;
			}else{
				TRACE("[REDIRECT]can't parse fqdn string, Drop it!");
				_rtk_rg_dev_kfree_skb_any(skb);
				return 0;
			}
			for(t = rg_db.redirectHttpAll.pushweb, s = strstr(rg_db.redirectHttpAll.pushweb, "%s"); s != NULL; t = s+2, s = strstr(t, "%s")) {
				strncat(dataStart, t, s-t);
				strcat(dataStart, att_url);
			}

			strncat(dataStart, t, s-t);
		}else
			memcpy(dataStart, rg_db.redirectHttpAll.pushweb, strlen(rg_db.redirectHttpAll.pushweb));

		dataLen = strlen(dataStart);
		totalLen = 40+dataLen;
		*(uint16 *)(bufptr + 16 + vlan_offset) = htons(totalLen);			//Total length
		if(pPktHdr->tagif&PPPOE_TAGIF)*(uint16 *)(bufptr + 12 + vlan_offset - 2) = htons(totalLen+2);			//pppoe length=Total length+2(0x0021)
		skb_put(skb, 54+vlan_offset+dataLen);

	}else if(rg_db.redirectHttpCount.enable && type_idx==FAIL){

		char *s, *t;
		//20160426LUKE: check for count
		if(rg_db.redirectHttpCount.count!=-1 && rg_db.redirectHttpCount.count--==0){
			_rtk_rg_dev_kfree_skb_any(skb);
			return rg_db.redirectHttpCount.count++;
		}
		if(rg_db.redirectHttpCount.enable==2){
			_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);
			if(fqdn){
				//cut final '/' if necessary
				if(fqdn[strlen(fqdn)-1]=='/')fqdn[strlen(fqdn)-1]='\0';
				att_url=fqdn;
			}else{
				TRACE("[REDIRECT]can't parse fqdn string, Drop it!");
				_rtk_rg_dev_kfree_skb_any(skb);
				return 0;
			}
			for(t = rg_db.redirectHttpCount.pushweb, s = strstr(rg_db.redirectHttpCount.pushweb, "%s"); s != NULL; t = s+2, s = strstr(t, "%s")) {
				strncat(dataStart, t, s-t);
				strcat(dataStart, att_url);
			}
			strncat(dataStart, t, s-t);
		}else
			memcpy(dataStart, rg_db.redirectHttpCount.pushweb, strlen(rg_db.redirectHttpCount.pushweb));

		dataLen = strlen(dataStart);
		totalLen = 40+dataLen;
		*(uint16 *)(bufptr + 16 + vlan_offset) = htons(totalLen);			//Total length
		if(pPktHdr->tagif&PPPOE_TAGIF)*(uint16 *)(bufptr + 12 + vlan_offset - 2) = htons(totalLen+2);			//pppoe length=Total length+2(0x0021
		skb_put(skb, 54+vlan_offset+dataLen);
	}else{
		//20160225LUKE: for redirectHttpRsp, we redirect to specific destination URL.
		//20160113LUKE: for redirectHttpURL, we redirect to specific destination URL.
		if(url_string!=NULL){
			sprintf(szRedirectContent, rgHttpRedirectContent, url_string, att_url);
			sprintf(szRedirectPack, rgHttpRedirectHead, url_string, att_url,
				strlen(szRedirectContent), szRedirectContent);
		}else{
			//20160114LUKE: if we get dst_URL end as "&url=", we need to attach original URL to it.
			if(rg_db.systemGlobal.forcePortal_url_list[type_idx].attach_orig_url){
				_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);
				if(fqdn){
					//cut final '/' if necessary
					if(fqdn[strlen(fqdn)-1]=='/')fqdn[strlen(fqdn)-1]='\0';
					att_url=fqdn;
				}else{
					TRACE("[REDIRECT]can't parse fqdn string, Drop it!");
					_rtk_rg_dev_kfree_skb_any(skb);
					return 0;
				}
			}
			sprintf(szRedirectContent, rgHttpRedirectContent, rg_db.systemGlobal.forcePortal_url_list[type_idx].url_string, att_url);
			sprintf(szRedirectPack, rgHttpRedirectHead, rg_db.systemGlobal.forcePortal_url_list[type_idx].url_string, att_url,
				strlen(szRedirectContent), szRedirectContent);
		}
		memcpy(dataStart, szRedirectPack, strlen(szRedirectPack));
		totalLen = 40+strlen(szRedirectPack);
		*(uint16 *)(bufptr + 16 + vlan_offset) = htons(totalLen);			//Total length
		if(pPktHdr->tagif&PPPOE_TAGIF)*(uint16 *)(bufptr + 12 + vlan_offset - 2) = htons(totalLen+2);			//pppoe length=Total length+2(0x0021
		skb_put(skb, 54+vlan_offset+strlen(szRedirectPack));
	}
	//dump_packet(skb->data,skb->len,"redirect_dump");

	*(u32*)(skb->data+skb->len)=0; //save null point into end of skb data.(for trace filter debug)

	//20170831LUKE: firx for wifi device didn't caclulate checksum problem.
	if(pPktHdr->wlan_dev_idx>=0
#if defined(CONFIG_RG_RTL9600_SERIES)
		//20160514LUKE: support http redirection in bridge mode
		||(pPktHdr->tagif&PPPOE_TAGIF)
#endif
	)
	{
		//IP checksum
		*(uint16 *)(bufptr + 24 + vlan_offset) = htons(inet_chksum(bufptr + 14 + vlan_offset,20));
		//TCP checksum
		*(uint16 *)(bufptr + 50 + vlan_offset) = htons(inet_chksum_pseudo(bufptr + 34 + vlan_offset,totalLen - 20,*(uint32 *)(bufptr + 26 + vlan_offset),*(uint32 *)(bufptr + 30 + vlan_offset),0x6));
	}

	//backup original pkthdr
	rg_db.pktHdr=&rg_db.systemGlobal.pktHeader_2;
#if defined(CONFIG_APOLLO_ROMEDRIVER)

	ret_code = rtk_rg_fwdEngineInput(skb, &rg_kernel.rxInfoFromARPND);

	//Processing packets
	if(ret_code == RG_FWDENGINE_RET_TO_PS)
	{
		//FIXME:iPhone 5 change wireless connection from master to slave will send strange unicast ARP request for LAN gateway IP, and forwarded by protocol stack
		TRACE("RED_GEN[%x]: To Protocol-Stack...FREE SKB!!",(POINTER_CAST)skb&0xffff);
		//dump_packet(skb->data,skb->len,"dump_back_to_PS");
		_rtk_rg_dev_kfree_skb_any(skb);
	}
	else if (ret_code == RG_FWDENGINE_RET_DROP)
	{
		TRACE("RED_GEN[%x]: Drop...FREE SKB!!",(POINTER_CAST)skb&0xffff);
		_rtk_rg_dev_kfree_skb_any(skb);
	}
	else
	{
		TRACE("RED_GEN[%x]: Forward",(POINTER_CAST)skb&0xffff);
	}
	//point back to original pkthdr
	rg_db.pktHdr=&rg_db_cache.pktHeader_1;
#else
	ret_code=_rtk_rg_broadcastForward(skb,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id,RTK_RG_MAC_PORT_MAINCPU,0);
	if(ret_code==RG_FWDENGINE_RET_DROP)
		_rtk_rg_dev_kfree_skb_any(skb);
#endif
	//memDump(bufptr,skb->len,"ARPGEN");
	//rtk_rg_fwdEngine_xmit(skb,&txInfo,NULL);
	//re8686_send_with_txInfo(skb,&txInfo,0);
	//re8686_send_with_txInfo_and_mask(skb,&txInfo,0,&txInfoMask);
#else
	//FIXME:in module code, we need some other api to send packets
#endif
#endif

	return 0;
}

void _user_agent_parsing_string(rtk_rg_pktHdr_t *pPktHdr, char **input_str, char *str_head, char *str_tail)
{
	char space = 0x20;
	char sep[3];
	char *capStr;
	char *user_agent_str=*input_str;
	int str_len = 0;

	/*use for parsing Host:*/
	sep[0]=0x0d;
	sep[1]=0x0a;
	sep[2]='\0';

	bzero(user_agent_str, MAX_URL_FILTER_BUF_LENGTH);

	if(pPktHdr->pL4Payload!=NULL){
		//rtlglue_printf("path_tail:%s.\n",url_tail);
		//DEBUG("[USERAG_PARSER]Lookup for \"Referer:\"\n");
		str_head = strstr(pPktHdr->pL4Payload, "User-Agent:");
		if(str_head!=NULL){
			str_head = strchr(str_head, space);//cut the "User-Agent:"
			if(str_head!=NULL)
				str_head = &str_head[1];//cut the " "
		}
	}else{
		DEBUG("[USERAG_PARSER]pL4Payload is null\n");
	}

	if(str_head!=NULL){
		//DEBUG("str_head:%s.\n",str_head);
		str_tail = strstr(str_head, sep);
	}else{
		DEBUG("[USERAG_PARSER]str_head is null\n");
	}


	if(str_head!=NULL && str_tail!=NULL){
		str_len = str_tail - str_head;
		if(str_len>=MAX_URL_FILTER_BUF_LENGTH){
			//dump_packet(pData,len,"urlFilter Packet");
			DEBUG("[USERAG_PARSER]user agent too long str_len=%d!!!\n",str_len);
			strncpy(user_agent_str,str_head,MAX_URL_FILTER_BUF_LENGTH);
			user_agent_str[MAX_URL_FILTER_BUF_LENGTH-1]='\0';
		}else{
			strncpy(user_agent_str,str_head,str_len);
			user_agent_str[str_len]='\0';
		}
		capStr = user_agent_str;
		//Captilize all letters in user-agent string
		while(*capStr != '\0')
            if (*capStr >= 'a' && *capStr <= 'z')
				*(capStr)-=0x20;
			else
				capStr++;
	}else{
		//dump_packet(pData,len,"urlFilter Packet");
		DEBUG("user_agent_str: can not parse... \n");
		*input_str=NULL;
	}
}

rtk_rg_fwdEngineReturn_t _check_avoidPortal_URL(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_avoidPortalURL_linkList_t *pEntry=NULL;
	char *fqdn=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *url_head=NULL;
	char *url_tail=NULL;
	char *path_head=NULL;
	char *path_tail=NULL;

	_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);

	if(fqdn==NULL){
		TRACE("[AVOID_URL]can't parse fqdn string, drop it!");
		return RG_FWDENGINE_RET_DROP;
	}else{
		DEBUG("[AVOID_URL]Check fqdn is %s",fqdn);
		//Check if we were added same URL before
		list_for_each_entry(pEntry,&rg_db.avoidPortalURLListHead,avoidPortal_list){
			//compare URL first
			if(!strncmp(fqdn,pEntry->url_str,pEntry->url_len)){//match!!
				TRACE("[AVOID URL]match!! Do not force portal!!");
				return RG_FWDENGINE_RET_CONTINUE;
			}
		}
	}

	return RG_FWDENGINE_RET_DROP;
}

rtk_rg_fwdEngineReturn_t _forcePortal_check(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx, int type_idx)
{
	char *l4_payload_str=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *url_head=NULL;
	char *url_tail=NULL;
	char *path_head=NULL;
	char *path_tail=NULL;
	char *userAgn_head=NULL;
	char *userAgn_tail=NULL;
	int i;

	//fragment won't handle
	if(pPktHdr->ipv4FragPacket||pPktHdr->ipv6FragPacket)
		return RG_FWDENGINE_RET_CONTINUE;

	if(pPktHdr->pL4Payload==NULL){
		TRACE("ForcePortal got a empty payload packet, just forward it without check!");
		return RG_FWDENGINE_RET_CONTINUE;
	}

	//check if match http command
	for(i=0; rg_http_request_cmd[i]; i++) {
		if (memcmp(pPktHdr->pL4Payload, rg_http_request_cmd[i], strlen(rg_http_request_cmd[i])) == 0) {

			_url_parsing_string(pPktHdr, l4_payload_str, url_head, url_tail, path_head, path_tail);
			if(l4_payload_str==NULL){
				TRACE("[REDIRECT_URL]can't parse fqdn string, drop it!");
			}else{
				TRACE("[REDIRECT_URL]url=%s", l4_payload_str);
				if(!strncmp(l4_payload_str,rg_db.systemGlobal.forcePortal_url_list[type_idx].url_string,strlen(l4_payload_str)-1)){
					TRACE("Received HTTP GET of URL=%s", l4_payload_str);
				}
			}

			// Permit browser
			_user_agent_parsing_string(pPktHdr, &l4_payload_str, userAgn_head, userAgn_tail);
			if(l4_payload_str==NULL){
				TRACE("[USERAG_PARSER]can't parse user agent string...");
				return RG_FWDENGINE_RET_DROP;
			}else{
				TRACE("[USERAG_PARSER]Check user_agent_str is %s", l4_payload_str);
				for(i=0;rg_forcePortal_browser_type[i]!=NULL;i++){
					if(strstr(l4_payload_str,rg_forcePortal_browser_type[i])){
						// Denial unexpected URL
						//20170822LUKE: avoid force portal if URL matched.
						if(!list_empty(&rg_db.avoidPortalURLListHead) && _check_avoidPortal_URL(pPktHdr)==RG_FWDENGINE_RET_CONTINUE){
							TRACE("Avoid to redirect this URL");
							return RG_FWDENGINE_RET_CONTINUE;
						}
						TRACE("HTTP request detected !!");
						goto SEND_REDIRECT;
					}
				}
			}
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;

	//send back redirect http
SEND_REDIRECT:
	if(rg_db.redirectHttpCount.enable && type_idx==FAIL)
		//20160518LUKE: check if receive frequent http request in short time
		if(rg_db.lut[pPktHdr->smacL2Idx].redirect_http_jiffies!=0 && time_before(jiffies,rg_db.lut[pPktHdr->smacL2Idx].redirect_http_jiffies+(TICKTIME_PERIOD*rg_db.redirectHttpCount.denialSecs)))
			return RG_FWDENGINE_RET_CONTINUE;

	//type_idx = 0xff means force drop for this host
	if(type_idx==0xff){
		TRACE("[Drop] ForcePortal check lut for redirect_http_req equals to 0xFF.");
	}else{
		//20170831LUKE: check for "text/" type for redirect
		//20160518LUKE: check if http request for text/ type
		if(!_url_parsing_accept(pPktHdr))return RG_FWDENGINE_RET_CONTINUE;

		//20160321LUKE: we have to check pushweb for count, if count equals to zero, continue without redirect!!
		if(_rtk_rg_redirectGeneration(pPktHdr, type_idx, NULL))return RG_FWDENGINE_RET_CONTINUE;

		if(!rg_db.systemGlobal.forcePortal_url_list[type_idx].manually_clear_req)rg_db.lut[pPktHdr->smacL2Idx].redirect_http_req=0;
		if(rg_db.redirectHttpCount.enable && type_idx==FAIL){
			rg_db.lut[pPktHdr->smacL2Idx].redirect_http_jiffies=jiffies;
		}
	}

	//reset the original connection
	//pPktHdr->tcpFlags.reset=1;
	//_rtk_rg_fwdEngine_receivedTCPReset(pPktHdr, pNaptOutIdx);
	//Delete connection and shortcut
	if(*pNaptOutIdx>=0)(pf.rtk_rg_naptConnection_del)(*pNaptOutIdx);

	TRACE("[Drop] drop by forcePortal checking");
	return RG_FWDENGINE_RET_DROP;
}

rtk_rg_fwdEngineReturn_t _check_Http_URL(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
	int match_white_list;
	rtk_rg_redirectHttpURL_linkList_t *pURLEntry;
	rtk_rg_redirectHttpWhiteList_linkList_t *pWhiteEntry;
	char *fqdn=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *url_head=NULL;
	char *url_tail=NULL;
	char *path_head=NULL;
	char *path_tail=NULL;
	char *keyword_head=NULL;

	if(pPktHdr->pL4Payload==NULL){
		TRACE("[REDIRECT_URL]get a empty payload packet, drop it!");
		return RG_FWDENGINE_RET_DROP;
	}

	_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);

	if(fqdn==NULL){
		TRACE("[REDIRECT_URL]can't parse fqdn string, drop it!");
		return RG_FWDENGINE_RET_DROP;
	}else{
		DEBUG("Check fqdn is %s",fqdn);
		list_for_each_entry(pURLEntry,&rg_db.redirectHttpURLListHead,url_list){
			if(atomic_read(&pURLEntry->count)!=0){
				DEBUG("pRedEntry->count is %d, str is %s",atomic_read(&pURLEntry->count),pURLEntry->url_data.url_str);
				//compare URL first
				if(!strncmp(fqdn,pURLEntry->url_data.url_str,pURLEntry->url_len)){//match!!
					//match URL, then compare White list
					keyword_head=strstr(fqdn,"?");
					DEBUG("keyword string is %s",keyword_head);
					if(keyword_head==NULL || list_empty(&rg_db.redirectHttpWhiteListListHead)){
						if(atomic_dec_return(&pURLEntry->count)<0)atomic_set(&pURLEntry->count,-1);
						DEBUG("no keyword or no whiteList, do redirect..");
						goto DO_REDIRECT;
					}else{
						match_white_list=0;
						list_for_each_entry(pWhiteEntry,&rg_db.redirectHttpWhiteListListHead,white_list){
							DEBUG("check white list %s %s...",pWhiteEntry->white_data.url_str,pWhiteEntry->white_data.keyword_str);
							if(!strncmp(fqdn,pWhiteEntry->white_data.url_str,pWhiteEntry->url_len) &&
								strstr(keyword_head,pWhiteEntry->white_data.keyword_str)!=NULL){
								//match white list, should not be redirected!!
								DEBUG("hit white list!! continue!!");
								match_white_list=1;
								break;
							}
						}
						if(match_white_list){
							break;	//leave outside list_for_each_entry
						}else{
							if(atomic_dec_return(&pURLEntry->count)<0)atomic_set(&pURLEntry->count,-1);
							DEBUG("not hit whiteList, do redirect..");
							goto DO_REDIRECT;
						}
					}
				}
			}
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;

DO_REDIRECT:
	DEBUG("Redirect to dstURL:%s",pURLEntry->url_data.dst_url_str);
	_rtk_rg_redirectGeneration(pPktHdr, 0, pURLEntry->url_data.dst_url_str);

	//reset the original connection
	//pPktHdr->tcpFlags.reset=1;
	//_rtk_rg_fwdEngine_receivedTCPReset(pPktHdr, pNaptOutIdx);
	//Delete connection and shortcut
	if(*pNaptOutIdx>=0)(pf.rtk_rg_naptConnection_del)(*pNaptOutIdx);

	TRACE("[Drop] drop by http url checking");
	return RG_FWDENGINE_RET_DROP;
}

rtk_rg_fwdEngineReturn_t _parse_Http_UserAgent(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_arpInfo_t arpInfo;
	int i,j,arpIdx;
	rtk_rg_lanNet_device_type_t device_type;
	rtk_rg_lanNet_brand_t brand=RG_BRAND_OTHER;
	rtk_rg_lanNet_model_t model_type=RG_MODEL_OTHER;
	rtk_rg_lanNet_os_t os_type=RG_OS_OTHER;
	char *user_agent_str=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *str_head=NULL;
	char *str_tail=NULL;

	if(pPktHdr->pL4Payload==NULL){
		TRACE("[USERAG_PARSER]get a empty payload packet...");
		return RG_FWDENGINE_RET_CONTINUE;
	}

	_user_agent_parsing_string(pPktHdr, &user_agent_str, str_head, str_tail);

	if(user_agent_str==NULL){
		TRACE("[USERAG_PARSER]can't parse user agent string...");
		if(rg_db.systemGlobal.dpi_accelerate_enable&&pPktHdr->skb->len<200)
		{
			rg_db.systemGlobal.dpi_accelerate_jiffies=jiffies+(TICKTIME_PERIOD*rg_db.systemGlobal.dpi_accelerate_enable);
//20181120LUKE: since we need SYN ACK for MSS clamping, we could not forward it by hwnat.
#if 0//defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
			//20180427LUKE: forward SYN ACK packet when we accelerate DPI.
			RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_TCP_SYN_ACK, DISABLED);
#endif
		}
		arpIdx=-1;
		arpInfo.arpEntry.ipv4Addr=pPktHdr->ipv4Sip;
		if((pf.rtk_rg_arpEntry_find)(&arpInfo,&arpIdx)==RT_ERR_RG_OK)
			if(++rg_db.arp[arpIdx].lanNetInfo.checked>=MAX_LANNET_PARSE_COUNT)return RG_FWDENGINE_RET_NAPT_OK;
	}else{
		DEBUG("Check user_agent_str is %s",user_agent_str);
		//Check for device type
		for(i=0;rg_lanNet_phone_type[i]!=NULL;i++){
			if(strstr(user_agent_str,rg_lanNet_phone_type[i])){
				device_type=RG_LANNET_TYPE_PHONE;
				break;
			}
		}
		if(rg_lanNet_phone_type[i]==NULL){
			for(i=0;rg_lanNet_computer_type[i]!=NULL;i++){
				if(strstr(user_agent_str,rg_lanNet_computer_type[i])){
					device_type=RG_LANNET_TYPE_COMPUTER;
					break;
				}
			}
		}
		if(rg_lanNet_computer_type[i]==NULL)device_type=RG_LANNET_TYPE_OTHER;
		DEBUG("Device type is %s",device_type==RG_LANNET_TYPE_PHONE?"Phone.":device_type==RG_LANNET_TYPE_COMPUTER?"Computer.":"Other.");
		//Check for brand
		for(i=RG_BRAND_OTHER+1;i<RG_BRAND_END;i++)
			for(j=0;rg_lanNet_brand[i][j]!=NULL;j++)
				if(strstr(user_agent_str, rg_lanNet_brand[i][j])){
					brand=(rtk_rg_lanNet_brand_t)i;
					i=RG_BRAND_END;
					break;
				}
		DEBUG("BRAND is %s",brand==RG_BRAND_OTHER?"Other":rg_lanNet_brand[(int)brand][0]);

		//Check for model_type
		for(i=RG_MODEL_OTHER+1;i<RG_MODEL_END;i++)
			for(j=0;rg_lanNet_model[i][j]!=NULL;j++)
				if(strstr(user_agent_str, rg_lanNet_model[i][j])){
					model_type=(rtk_rg_lanNet_model_t)i;
					i=RG_MODEL_END;
					break;
				}
		DEBUG("Model is %s\n",model_type==RG_MODEL_OTHER?"Other":rg_lanNet_model[(int)model_type][0]);

		//Check for os_type
		for(i=RG_OS_OTHER+1;i<RG_OS_END;i++)
			for(j=0;rg_lanNet_os[i][j]!=NULL;j++)
				if(strstr(user_agent_str, rg_lanNet_os[i][j])){
					os_type=(rtk_rg_lanNet_os_t)i;
					i=RG_OS_END;
					break;
				}
		DEBUG("OS is %s",os_type==RG_OS_OTHER?"Other":rg_lanNet_os[(int)os_type][0]);

		//Special Device
		if(device_type==RG_LANNET_TYPE_PHONE && os_type==RG_OS_MACINTOSH)os_type=RG_OS_IOS;	//for iPad safari

		//Find the ARP of SIP
		arpIdx=-1;
		arpInfo.arpEntry.ipv4Addr=pPktHdr->ipv4Sip;
		if((pf.rtk_rg_arpEntry_find)(&arpInfo,&arpIdx)==RT_ERR_RG_OK){
			rg_db.arp[arpIdx].lanNetInfo.dev_type=device_type;
			rg_db.arp[arpIdx].lanNetInfo.brand=brand;
			rg_db.arp[arpIdx].lanNetInfo.model=model_type;
			rg_db.arp[arpIdx].lanNetInfo.os=os_type;
			if((RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<rg_db.lut[rg_db.arp[arpIdx].rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.port))
				&& rg_db.lut[rg_db.arp[arpIdx].rtk_arp.nhIdx].rtk_lut.entry.l2UcEntry.ext_port!=RTK_RG_MAC_EXT_CPU)
				rg_db.lut[rg_db.arp[arpIdx].rtk_arp.nhIdx].conn_type=RG_CONN_WIFI;
			else
				rg_db.lut[rg_db.arp[arpIdx].rtk_arp.nhIdx].conn_type=RG_CONN_MAC_PORT;
			DEBUG("ARP[%d] dev_type:%s brand:%s model:%s os:%s connType:%s check:%d",arpIdx,
				rg_db.arp[arpIdx].lanNetInfo.dev_type==RG_LANNET_TYPE_PHONE?"Phone":rg_db.arp[arpIdx].lanNetInfo.dev_type==RG_LANNET_TYPE_COMPUTER?"Computer":"Other",
				rg_lanNet_brand[(int)rg_db.arp[arpIdx].lanNetInfo.brand][0],
				rg_lanNet_model[(int)rg_db.arp[arpIdx].lanNetInfo.model][0],
				rg_lanNet_os[(int)rg_db.arp[arpIdx].lanNetInfo.os][0],
				rg_db.lut[rg_db.arp[arpIdx].rtk_arp.nhIdx].conn_type==RG_CONN_MAC_PORT?"MacPort":"Wifi",
				rg_db.arp[arpIdx].lanNetInfo.checked);
			if(++rg_db.arp[arpIdx].lanNetInfo.checked>=MAX_LANNET_PARSE_COUNT)return RG_FWDENGINE_RET_NAPT_OK;
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

int _check_urlFilter_is_enabled(rtk_rg_pktHdr_t *pPktHdr)
{
	if((rg_db.systemGlobal.urlFilterMode==RG_FILTER_WHITE)||
		(!list_empty(&rg_db.systemGlobal.urlFilterByString))||
		(!list_empty(&rg_db.systemGlobal.urlFilterBySmacHash[rtk_rg_apollo_urlFilterBySmacHash(pPktHdr->smac)])))
		return TRUE;
	else
		return FALSE;
}

rtk_rg_fwdEngineReturn_t _check_Https_urlFilter(rtk_rg_pktHdr_t *pPktHdr)
{
	int ret;

	pPktHdr->addNaptAfterNicTx = 0;
	pPktHdr->checkHttpsKeepInSw = 1;
	
	if(pPktHdr->httpsClientHelloPacket==1)
	{
		ret=_rtk_rg_urlFilter(pPktHdr->skb->data, pPktHdr->skb->len, pPktHdr);
		if(ret==RG_FWDENGINE_RET_CONTINUE)
		{
			pPktHdr->addNaptAfterNicTx = 1;
			pPktHdr->checkHttpsKeepInSw = 0;
			return RG_FWDENGINE_RET_NAPT_OK;
		}
		else
			return ret; //DROP
	}

	return RG_FWDENGINE_RET_CONTINUE;
}


int32 _check_urlAssignPri(rtk_rg_pktHdr_t *pPktHdr,int32 connectId)
{

	char *fqdn=rg_db.systemGlobal.urlFilter_parsingBuf;
	char *keyword; // url_string
	char *path;// path__string
	char *parseSuccess=NULL;
	char *url_head=NULL;
	char *url_tail=NULL;
	char *path_head=NULL;
	char *path_tail=NULL;
	int keyword_url_len = 0;
	int keyword_path_len = 0;
	int hit=0;

	TRACE("[URLPRI] Check urlPri function");
	if(pPktHdr->pL4Payload==NULL)
	{
		TRACE("[URLPRI]urlPri get a Empty payload packet, CONTINUE it!\n");
			return FALSE;
	}
	if(connectId < 0)
	{
		TRACE("[URLPRI]Can't get napt connectionID\n");
			return FALSE;		
	}
	if(rg_db.naptOut[connectId].urlPriEn)
	{
		TRACE("[URLPRI]connectId[%d] already urlPriEn ingore add hipriEt\n",connectId);
		return FALSE;		
	}
	

	/*parsing FQDN*/
	if(pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort)
		_url_parsing_string(pPktHdr, fqdn, url_head, url_tail, path_head, path_tail);
	else if(pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort)
		_https_url_parsing_string(pPktHdr, fqdn);
	else
	{
		bzero(fqdn, MAX_URL_FILTER_BUF_LENGTH);
		TRACE("[URLPRI] dport is neither http(%d) nor https(%d)", rg_db.systemGlobal.httpMonitorPort, rg_db.systemGlobal.httpsMonitorPort);
		return FALSE;
	}

	if(fqdn!=NULL)
	{

		int i;
		HTTP("[%d]URL:%s\n",pPktHdr->dport,fqdn);
		for(i=0 ; i<MAX_URL_HiPri_ENTRY_SIZE ; i++)
		{
			if(!rg_db.systemGlobal.urlHiPri_table_entry[i].valid)
				continue;

			keyword = rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.url_filter_string;
			path = 	rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.path_filter_string;
			if(keyword==NULL || path==NULL || strlen(keyword)==0)
			{
				DEBUG("[URLPRI] get a NULL keyword or path!");
				continue;
			}
			if(rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.path_exactly_match)
			{
				keyword_url_len = strlen(keyword);
				keyword_path_len = strlen(path);
				DEBUG("[URLPRI]keyword_url_len=%d keyword_path_len=%d\n",keyword_url_len,keyword_path_len);
				strncpy(keyword_fqdn,keyword,keyword_url_len);
				strncpy((keyword_fqdn+keyword_url_len),path,keyword_path_len);
				keyword_fqdn[keyword_url_len+keyword_path_len]='\0';
				DEBUG("[URLPRI]keyword_fqdn:%s \n",keyword_fqdn);
				if(strlen(fqdn)==strlen(keyword_fqdn) && strcmp(fqdn,keyword_fqdn)==0)
					hit=1;
			}
			else
			{
				//keyword only
				DEBUG("[URLFILTER]keyword: %s \n",keyword);
				parseSuccess = strstr(fqdn, keyword);
				if(parseSuccess!=NULL)
					hit=1;
				else
					DEBUG("parseSuccess NULL");
			}

			if(hit)
			{
				rtk_rg_table_highPriPatten_t hiPriEntry;
				rtk_rg_hiPriEntryIdx_t *hiPriEntryIdx;
				int index,index2;

				//add DIP
				bzero(&hiPriEntry,sizeof(hiPriEntry));
				hiPriEntry.careDipEn=1;
				hiPriEntry.assignFlowPriEn=1;
				
				if(pPktHdr->tagif&IPV4_TAGIF)
				{
					DEBUG("[URLPRI] Hit Add HiPriEntry DIP=%pI4h !! ",(&pPktHdr->ipv4Dip));
					hiPriEntry.hp_dip[0]= pPktHdr->ipv4Dip;
				}
				else if (pPktHdr->tagif&IPV6_TAGIF)
				{
					hiPriEntry.isIpv6=1;
					memcpy(hiPriEntry.hp_dip,pPktHdr->ipv6_dip_addr,sizeof(hiPriEntry.hp_dip));
					DEBUG("[URLPRI] Hit Add HiPriEntry DIP=%pI6 !! ",pPktHdr->ipv6_dip_addr);
				}
				hiPriEntry.hp_flowPri= rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.urlpri;
				
				(pf.rtk_rg_flowHiPriEntry_add)(hiPriEntry,&index);
				
				//add SIP
				bzero(&hiPriEntry,sizeof(hiPriEntry));
				hiPriEntry.careSipEn=1;
				hiPriEntry.assignFlowPriEn=1;
				
				if(pPktHdr->tagif&IPV4_TAGIF)
				{
					DEBUG("[URLPRI] Hit Add HiPriEntry SIP=%pI4h !! ",(&pPktHdr->ipv4Dip));
					hiPriEntry.hp_sip[0]= pPktHdr->ipv4Dip;
				}
				else if (pPktHdr->tagif&IPV6_TAGIF)
				{
					hiPriEntry.isIpv6=1;
					memcpy(hiPriEntry.hp_sip,pPktHdr->ipv6_dip_addr,sizeof(hiPriEntry.hp_sip));
					DEBUG("[URLPRI] Hit Add HiPriEntry SIP=%pI6 !! ",pPktHdr->ipv6_dip_addr);
				}
				hiPriEntry.hp_flowPri= rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.urlpri;
				
				(pf.rtk_rg_flowHiPriEntry_add)(hiPriEntry,&index2);
				
				if(list_empty(&rg_db.systemGlobal.urlHiPriIdxfreeEntry))
				{
					DEBUG("[URLPRI] urlHiPriIdxfreeEntry full");
					RETURN_ERR(RT_ERR_RG_ENTRY_FULL);
				}
				hiPriEntryIdx = list_first_entry(&rg_db.systemGlobal.urlHiPriIdxfreeEntry,rtk_rg_hiPriEntryIdx_t,hiPriEntryIdx_list); 
				hiPriEntryIdx->hiPriEntryIdx = index;
				hiPriEntryIdx->hiPriEntryIdx2 = index2;
				hiPriEntryIdx->connectId = connectId;
				list_move(&hiPriEntryIdx->hiPriEntryIdx_list,&rg_db.systemGlobal.urlHiPri_table_entry[i].hiPriEntryIdxListHdr); 				

				pPktHdr->urlPriHit=1;
				pPktHdr->urlPriHitIdx=i;
				TRACE("Assign internalPriority to %d by urlpri", rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.urlpri);
				pPktHdr->internalPriority = rg_db.systemGlobal.urlHiPri_table_entry[i].urlHighPriEt.urlpri;
				break;
			}
			
		}

	}
	
	return (hit) ? TRUE : FALSE;

}



int _check_Https_keep_in_sw(rtk_rg_pktHdr_t *pPktHdr)
{

	pPktHdr->checkHttpsKeepInSw=0;

	if(_check_urlFilter_is_enabled(pPktHdr) || rg_db.systemGlobal.urlHiPri_En)
	{
		pPktHdr->checkHttpsKeepInSw=1;
	}

	return pPktHdr->checkHttpsKeepInSw;
}

rtk_rg_fwdEngineReturn_t _check_Http_mechanism(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
	int ret;

	//20160224LUKE: if http response has to be check, we can't add to hardware.
	pPktHdr->addNaptAfterNicTx = 0;
	pPktHdr->checkHttpKeepInSw = 1;

	if(rg_db.lut[pPktHdr->smacL2Idx].redirect_http_req || rg_db.redirectHttpCount.enable){
		ret=_forcePortal_check(pPktHdr, pNaptOutIdx, rg_db.lut[pPktHdr->smacL2Idx].redirect_http_req==0xff?rg_db.lut[pPktHdr->smacL2Idx].redirect_http_req:rg_db.lut[pPktHdr->smacL2Idx].redirect_http_req-1);
		if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;
	}else if(pPktHdr->httpFirstPacket==1){//Parse URL
		int retLanNet=RG_FWDENGINE_RET_CONTINUE;
		//20160120LUKE: parsing lan netInfo from user Agent field in Http request
		if(rg_db.systemGlobal.gatherLanNetInfo||rg_db.systemGlobal.dpi_accelerate_enable)
			retLanNet=_parse_Http_UserAgent(pPktHdr);
		if(!list_empty(&rg_db.redirectHttpURLListHead)){
			ret=_check_Http_URL(pPktHdr, pNaptOutIdx);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;
		}

		ret=_rtk_rg_urlFilter(pPktHdr->skb->data,pPktHdr->skb->len,pPktHdr);
		if(ret!=RG_FWDENGINE_RET_CONTINUE)
			return ret;//DROP
		
		if(retLanNet==RG_FWDENGINE_RET_NAPT_OK)
		{
			if(!rg_db.redirectHttpRsp.enable)
			{
				pPktHdr->addNaptAfterNicTx = 1;
				pPktHdr->checkHttpKeepInSw = 0;
			}
			return retLanNet;//NAPT_OK
		}
	}

	//int naptInIdx = rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.hashIdx;
	//TRACE("HTTP packet checked by urlfilter: add naptOut[%d] naptIn[%d]",*pNaptOutIdx,naptInIdx);
	return RG_FWDENGINE_RET_CONTINUE;
}

int _check_Http_keep_in_sw(rtk_rg_pktHdr_t *pPktHdr)
{

	pPktHdr->checkHttpKeepInSw=0;
	//Http packet(l4_dport==rg_db.systemGlobal.httpMonitorPort) should establish NAPT-flow after checked  by urlfilter and forcePortal and redirectHttp check.
	if((rg_db.redirectHttpRsp.enable)||
		_check_urlFilter_is_enabled(pPktHdr) ||
		(rg_db.lut[pPktHdr->smacL2Idx].redirect_http_req)||
		(rg_db.redirectHttpCount.enable && rg_db.redirectHttpCount.count!=0)||
		(!list_empty(&rg_db.redirectHttpURLListHead))||
		rg_db.systemGlobal.gatherLanNetInfo||rg_db.systemGlobal.dpi_accelerate_enable||
		rg_db.systemGlobal.urlHiPri_En)
	{
			//20170320LUKE: for this we should not add to hw after all.
			pPktHdr->checkHttpKeepInSw=1;
	}

	return pPktHdr->checkHttpKeepInSw;
}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
//0: L2, 1:L3
uint32 _rtk_rg_fwdEngine_isL2OrL3(rtk_rg_pktHdr_t *pPktHdr)
{
	int i;

	if(pPktHdr->isGatewayPacket)
	{
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo!=NULL)
			{
				if(((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_addr==pPktHdr->ipv4Dip) ||
					(pPktHdr->tagif&IPV6_TAGIF && !memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ipv6_addr.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN)))
				{
					TRACE("L2 packet for TcpUdpConnectionTracking, Dip=LAN interface's ip");
					return 0; //L2
				}
			}
		}

		//Check Wan interface IP address
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo!=NULL && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf!=NULL &&
				rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)
			{
				if(((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr==pPktHdr->ipv4Dip) ||
					(pPktHdr->tagif&IPV6_TAGIF && !memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ipv6_addr.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN)))
				{
					TRACE("L2 packet for TcpUdpConnectionTracking, Dip=WAN interface's ip");
					return 0; //L2
				}
			}
		}

		TRACE("L3 packet for TcpUdpConnectionTracking");
		return 1; //L3
	}
	else
	{
		TRACE("L2 packet for TcpUdpConnectionTracking");
		return 0; //L2
	}
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_L2L3_TcpUdpConnectionTracking(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_flow_tcpUdpTracking_group_linkList_t *pTcpUdpTrackingGroup=NULL;
	uint32 isL2OrL3; //0: L2, 1:L3

	if(pPktHdr->tcpUdpTrackingDone)
		return RG_FWDENGINE_RET_CONTINUE;
	else
		pPktHdr->tcpUdpTrackingDone=1;

	if(!(pPktHdr->ingressLocation==RG_IGR_PHY_PORT || pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK || pPktHdr->ingressLocation==RG_IGR_MC_DATA_BUF))
		return RG_FWDENGINE_RET_CONTINUE;

	//skip non-ip
	if(!(pPktHdr->tagif&(IPV4_TAGIF|IPV6_TAGIF)))
		return RG_FWDENGINE_RET_CONTINUE;

	if(pPktHdr->pDmac[0]&0x1)
		return RG_FWDENGINE_RET_CONTINUE;

	//unknown DA unicast's pPktHdr->fwdDecision is RG_FWD_DECISION_NORMAL_BC or RG_FWD_DECISION_NO_PS_BC
	if(pPktHdr->fwdDecision!=RG_FWD_DECISION_BRIDGING
		&& pPktHdr->fwdDecision!=RG_FWD_DECISION_ROUTING
		&& pPktHdr->fwdDecision!=RG_FWD_DECISION_V6ROUTING
		&& pPktHdr->fwdDecision!=RG_FWD_DECISION_NORMAL_BC
		&& pPktHdr->fwdDecision!=RG_FWD_DECISION_NO_PS_BC
		&& pPktHdr->fwdDecision!=RG_FWD_DECISION_TO_PS)
		return RG_FWDENGINE_RET_CONTINUE;

	if(pPktHdr->tagif&UDP_TAGIF)
	{
		if(pPktHdr->shortcutStatus!=RG_SC_MATCH)	//from slowpath
		{
			isL2OrL3 = _rtk_rg_fwdEngine_isL2OrL3(pPktHdr);

			if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK || pPktHdr->fwdDecision==RG_FWD_DECISION_TO_PS || (isL2OrL3==0 && pPktHdr->isGatewayPacket))
			{
				TRACE("No need to add L2/L3 udp connection...packet is to/from PS");
				//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
					pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
			}
			else	// packet is forwarded
			{
				assert_ok(_rtk_rg_L2L3_flowTcpUdpTrackingGroupLookUp(pPktHdr, &pPktHdr->tcpUdpTrackingGroupIdx));

				if(pPktHdr->tcpUdpTrackingGroupIdx<0)
				{
					if(((isL2OrL3==0 && rg_db.systemGlobal.L2TcpUdpStatefulTracking==RG_STATEFUL_TRACKING_ENABLE_FIREWALL) || (isL2OrL3 && rg_db.systemGlobal.L3TcpUdpStatefulTracking==RG_STATEFUL_TRACKING_ENABLE_FIREWALL))
						&& ((rg_db.systemGlobal.lanPortMask.portmask&(0x1<<pPktHdr->ingressPort))==0))
					{
						TRACE("[Drop] First packet(UDP) does not come from lan port...drop by %s firewall", (isL2OrL3)?"L3":"L2");
						return RG_FWDENGINE_RET_DROP;
					}

					if(_rtk_rg_L2L3_flowTcpUdpTrackingGroupAdd(pPktHdr, &pPktHdr->tcpUdpTrackingGroupIdx)==RT_ERR_RG_OK)
					{
						//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
							pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
						TRACE("UDP stateful tracking: add L2/L3 udp connection[%d]", pPktHdr->tcpUdpTrackingGroupIdx);
					}
					else
					{
						TRACE("[Drop] Fail to add L2/L3 udp connection.");
						return RG_FWDENGINE_RET_DROP;
					}
				}
				else
				{
					//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
						pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
					TRACE("UDP stateful tracking: Hit L2/L3 udp connection[%d]", pPktHdr->tcpUdpTrackingGroupIdx);
				}
			}
		}
		else	//from shortcut
		{
			//WARNING("%s should not be called when this packet hits shortcut", __func__);
			return RG_FWDENGINE_RET_CONTINUE;
		}
	}
	else if(pPktHdr->tagif&TCP_TAGIF)
	{
		isL2OrL3 = _rtk_rg_fwdEngine_isL2OrL3(pPktHdr);
		
		if(pPktHdr->tcpUdpTrackingGroupIdx<0 && pPktHdr->shortcutStatus!=RG_SC_MATCH)	//from slowpath
		{
			assert_ok(_rtk_rg_L2L3_flowTcpUdpTrackingGroupLookUp(pPktHdr, &pPktHdr->tcpUdpTrackingGroupIdx));
			//check tcp disable stateful
			if(pPktHdr->tcpUdpTrackingGroupIdx<0)
			{
                if((pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK || pPktHdr->fwdDecision==RG_FWD_DECISION_TO_PS || (isL2OrL3==0 && pPktHdr->isGatewayPacket))
					|| (isL2OrL3==0 && rg_db.systemGlobal.L2TcpUdpStatefulTracking==RG_STATEFUL_TRACKING_DISABLE)
                   	|| (isL2OrL3 && rg_db.systemGlobal.L3TcpUdpStatefulTracking==RG_STATEFUL_TRACKING_DISABLE))
				{
					if(_rtk_rg_L2L3_flowTcpUdpTrackingGroupAdd(pPktHdr, &pPktHdr->tcpUdpTrackingGroupIdx)==RT_ERR_RG_OK)
					{
						rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx].tcpState = TCP_STATE_TCP_CONNECTED;
						//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
							pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
						TRACE("TCP disable stateful tracking: add L2/L3 tcp connection[%d]", pPktHdr->tcpUdpTrackingGroupIdx);
					}
					else
					{
						TRACE("[Drop] Fail to add L2/L3 tcp connection.");
						return RG_FWDENGINE_RET_DROP;
					}
				}
			}
		}
		if(pPktHdr->tcpUdpTrackingGroupIdx>=0 && pPktHdr->tcpUdpTrackingGroupIdx<MAX_FLOW_TCP_UDP_TRACKING_GROUP_SIZE)
		{
			pTcpUdpTrackingGroup = &rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx];
			DEBUG("tcpState=%d", pTcpUdpTrackingGroup->tcpState);
		}

		if(pPktHdr->tcpUdpTrackingGroupIdx<0)
		{
			if(!((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0)))
			{
				TRACE("[Drop] TCP Connection is not in L2/L3 tcp tracking table, Drop!");
				return RG_FWDENGINE_RET_DROP;
			}
		}else if(pPktHdr->tcpUdpTrackingGroupIdx>=MAX_FLOW_TCP_UDP_TRACKING_GROUP_SIZE){
			TRACE("[Drop] Fail to add L2/L3 tcp connection.");
			return RG_FWDENGINE_RET_DROP;
		}
		if((pPktHdr->tcpUdpTrackingGroupIdx>=0) && (pPktHdr->tcpFlags.reset==1))
		{
			TRACE("L2/L3 tcp connection[%d] receive RST packet.", pPktHdr->tcpUdpTrackingGroupIdx);
			pTcpUdpTrackingGroup->tcpState=TCP_STATE_RST_RECV;
			assert_ok(_rtk_rg_L2L3_flowTcpUdpTrackingGroupDel(pPktHdr->tcpUdpTrackingGroupIdx));
			pPktHdr->tcpUdpTrackingGroupIdx=FAIL;
		}
		else if((pPktHdr->tcpUdpTrackingGroupIdx>=0) && ((pTcpUdpTrackingGroup->tcpState==TCP_STATE_TCP_CONNECTED) || (pTcpUdpTrackingGroup->tcpState==TCP_STATE_FIRST_FIN)))
		{
			if(pPktHdr->tcpFlags.fin==1)
			{
				if(pTcpUdpTrackingGroup->tcpState==TCP_STATE_TCP_CONNECTED)
				{
					TRACE("L2/L3 tcp connection[%d] receive first FIN packet.", pPktHdr->tcpUdpTrackingGroupIdx);
					pTcpUdpTrackingGroup->tcpState=TCP_STATE_FIRST_FIN;
				}	
				else
				{
					TRACE("L2/L3 tcp connection[%d] receive FIN+ACK packet.", pPktHdr->tcpUdpTrackingGroupIdx);
					assert_ok(_rtk_rg_flow_del_by_tcpUdpTrackingGroup(pPktHdr->tcpUdpTrackingGroupIdx, TRUE));
					pTcpUdpTrackingGroup->tcpState=TCP_STATE_FIN_SEND_AND_RECV;
				}	
			}
			//20210913: all packets need to be checked by url filter(test by youhua)
			//else if(pTcpUdpTrackingGroup->tcpState==TCP_STATE_TCP_CONNECTED)
			{
				//check url filter
				if(!(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK || pPktHdr->fwdDecision==RG_FWD_DECISION_TO_PS || (isL2OrL3==0 && pPktHdr->isGatewayPacket)))
				{
					if((pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort) || (pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort))
					{
						DEBUG("dport=%d, httpFirstPacket=%d, httpsClientHelloPacket=%d", pPktHdr->dport, pPktHdr->httpFirstPacket, pPktHdr->httpsClientHelloPacket);
						if(pPktHdr->httpFirstPacket==1 || pPktHdr->httpsClientHelloPacket==1)
						{
							if(_rtk_rg_urlFilter(pPktHdr->skb->data, pPktHdr->skb->len, pPktHdr)==RG_FWDENGINE_RET_DROP)
							{
								TRACE("[DROP] http/https packet is dropped by urlfilter");
								if(pPktHdr->tcpUdpTrackingGroupIdx>=0)
								{
									TRACE("Delete tcpUdpTrackingGroup Idx[%d] ... due to urlfilter", pPktHdr->tcpUdpTrackingGroupIdx);
									assert_ok(_rtk_rg_L2L3_flowTcpUdpTrackingGroupDel(pPktHdr->tcpUdpTrackingGroupIdx));
									pPktHdr->tcpUdpTrackingGroupIdx=FAIL;
								}
								return RG_FWDENGINE_RET_DROP;
							}
							else
								TRACE("http first packet/https client hello pakcet already pass urlfilter !! ");
						}
						else // not http/https first/hello packets should not update flow until the packet is checked by _rtk_rg_urlFilter()
						{
							TRACE("keep in sw for checking http/https url filter later!!");
							if(pPktHdr->shortcutStatus==RG_SC_NEED_UPDATE)
								pPktHdr->shortcutStatus = RG_SC_NORMAL_PATH;

							return RG_FWDENGINE_RET_CONTINUE;
						}
					}
				}
				if(pPktHdr->shortcutStatus!=RG_SC_MATCH)	//from slowpath
				{
					TRACE("Update L2/L3 tcp connection[%d]'s flow.", pPktHdr->tcpUdpTrackingGroupIdx);
					//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
						pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
				}
			}
		}
		else
		{
			if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0))
			{
				if(pPktHdr->tcpUdpTrackingGroupIdx<0)
				{
					if((rg_db.systemGlobal.lanPortMask.portmask&(0x1<<pPktHdr->ingressPort))==0)
					{
	                    if(!(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK || pPktHdr->fwdDecision==RG_FWD_DECISION_TO_PS || (isL2OrL3==0 && pPktHdr->isGatewayPacket)) &&
							((isL2OrL3==0 && rg_db.systemGlobal.L2TcpUdpStatefulTracking==RG_STATEFUL_TRACKING_ENABLE_FIREWALL)
		                   		|| (isL2OrL3 && rg_db.systemGlobal.L3TcpUdpStatefulTracking==RG_STATEFUL_TRACKING_ENABLE_FIREWALL)))
						{
							TRACE("[Drop] First packet(TCP syn) does not come from lan port...drop by %s firewall", (isL2OrL3)?"L3":"L2");
							return RG_FWDENGINE_RET_DROP;
						}
					}
					if(_rtk_rg_L2L3_flowTcpUdpTrackingGroupAdd(pPktHdr, &pPktHdr->tcpUdpTrackingGroupIdx)!=RT_ERR_RG_OK ||
						pPktHdr->tcpUdpTrackingGroupIdx<0 || pPktHdr->tcpUdpTrackingGroupIdx>=MAX_FLOW_TCP_UDP_TRACKING_GROUP_SIZE)
					{
						TRACE("[Drop] Fail to add L2/L3 tcp connection.");
						return RG_FWDENGINE_RET_DROP;
					}
					pTcpUdpTrackingGroup = &rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx];
				}
				pTcpUdpTrackingGroup->tcpState=TCP_STATE_SYN_RECV;
				
				//20181015LUKE: only prohibit simultaneous SYN packet from WAN.
				if(((1<<pPktHdr->ingressPort)&rg_db.systemGlobal.wanPortMask.portmask) && rg_db.systemGlobal.tcpDisableSimultaneousSYN)
				{
					TRACE("[DROP] TCP simultaneous SYN is disabled..The SYN packet with existing flow would be droped!");
					return RG_FWDENGINE_RET_DROP;
				}
			}
			else if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==1))
			{
				if(pTcpUdpTrackingGroup->tcpState==TCP_STATE_INVALID)
				{
					TRACE("[To PS] L2/L3 tcp loss syn packet");
					return RG_FWDENGINE_RET_TO_PS;
				}
				if(pTcpUdpTrackingGroup->tcpState<=TCP_STATE_SYN_RECV)
				{
					pTcpUdpTrackingGroup->tcpState=TCP_STATE_SYN_ACK_RECV;
					//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
					if((pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort || pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort) && _check_urlFilter_is_enabled(pPktHdr))
						TRACE("keep in sw for checking http/https url filter later!!");
					else
						pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
				}
			}
			else if((pPktHdr->tcpFlags.syn==0)&&(pPktHdr->tcpFlags.ack==1)&&(pPktHdr->tcpFlags.fin==0))
			{
				if(pTcpUdpTrackingGroup->tcpState==TCP_STATE_SYN_ACK_RECV)
				{
					pTcpUdpTrackingGroup->tcpState=TCP_STATE_TCP_CONNECTED;
					//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
					if((pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort || pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort) && _check_urlFilter_is_enabled(pPktHdr))
					{
						TRACE("keep in sw for checking http/https url filter later!!");	
						if(pPktHdr->httpFirstPacket==1 || pPktHdr->httpsClientHelloPacket==1)
						{
							DEBUG("dport=%d, httpFirstPacket=%d, httpsClientHelloPacket=%d", pPktHdr->dport, pPktHdr->httpFirstPacket, pPktHdr->httpsClientHelloPacket);
							if(_rtk_rg_urlFilter(pPktHdr->skb->data, pPktHdr->skb->len, pPktHdr)==RG_FWDENGINE_RET_DROP)
							{
								TRACE("[DROP] http/https packet is dropped by urlfilter");
								if(pPktHdr->tcpUdpTrackingGroupIdx>=0)
								{
									TRACE("Delete tcpUdpTrackingGroup Idx[%d] ... due to urlfilter", pPktHdr->tcpUdpTrackingGroupIdx);
									assert_ok(_rtk_rg_L2L3_flowTcpUdpTrackingGroupDel(pPktHdr->tcpUdpTrackingGroupIdx));
									pPktHdr->tcpUdpTrackingGroupIdx=FAIL;
								}
								return RG_FWDENGINE_RET_DROP;
							}
						}
					}
					else
						pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
				}
				else if(pTcpUdpTrackingGroup->tcpState==TCP_STATE_FIN_SEND_AND_RECV)
				{
					TRACE("L2/L3 tcp connection[%d] receive LAST ACK packet.", pPktHdr->tcpUdpTrackingGroupIdx);
					pTcpUdpTrackingGroup->tcpState=TCP_STATE_LAST_ACK;
					//20170619: For avalanche, tcp connection should not be delete immediately.
					//assert_ok(_rtk_rg_L2L3_flowTcpUdpTrackingGroupDel(pPktHdr->tcpUdpTrackingGroupIdx));
					pPktHdr->tcpUdpTrackingGroupIdx=FAIL;
				}
			}
		}
	}
	else	//not TCP/UDP
	{
		if(pPktHdr->fwdDecision==RG_FWD_DECISION_ROUTING || pPktHdr->fwdDecision==RG_FWD_DECISION_V6ROUTING)
		{
			if(pPktHdr->ipv4FragmentOffset==0 && pPktHdr->ipv6FragmentOffset==0)
			{
				TRACE("[Update shortcut] It's routing without TCP/UDP");
				pPktHdr->shortcutStatus = RG_SC_NEED_UPDATE;
			}
			else
			{
				TRACE("[Skip update shortcut] It's fragment routing without TCP/UDP");
			}
		}
		else
		{
			TRACE("[Skip update shortcut] It's not TCP/UDP");
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}
#endif

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_TCPConnectionTracking(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
	int ret=0;
	rtk_rg_naptDirection_t direct;
	uint8 serverInLan;
	ipaddr_t transIP = pPktHdr->ipv4Dip;
	uint16 transPort = pPktHdr->dport;

	if(*pNaptOutIdx<0)
	{
		if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT){
			// Never trap any forwarding NAPT connection packets to PS. (for syncing issue)
			if(!((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0))){
				//NAPT 4-ways not found, and not SYN packet
#ifdef CONFIG_ROME_NAPT_LRU
				TRACE("[Drop] flow is not in NAPT table, Drop!");
				return RG_FWDENGINE_RET_DROP;
#else
				TRACE("[To PS] flow is not in NAPT table, trap to PS");
				return RG_FWDENGINE_RET_TO_PS;
#endif
			}
			direct = NAPT_DIRECTION_OUTBOUND;
			serverInLan = 0;
		}else{
			if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0)){
#ifdef CONFIG_RG_NAPT_INBOUND_TRACKING
				//There are no NAPT flows, lookup UPNP/virtual server/DMZ tables.
				// FAIL: entry not found.  -2: Inbound entry is found, but Outbound entry is not found.
				ret = _rtk_rg_fwdEngine_connType_lookup(pPktHdr,&transIP,&transPort);
				if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
#endif
			}else{
				//NAPT 4-ways not found, and not SYN packet, trap to CPU handle
				TRACE("[To PS] flow is not in NAPT table, trap to PS");
				return RG_FWDENGINE_RET_TO_PS;
			}
			direct = NAPT_DIRECTION_INBOUND;
			serverInLan = 1;
		}
	}else{	//*pNaptOutIdx>=0
		direct = (pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)?NAPT_DIRECTION_OUTBOUND:NAPT_DIRECTION_INBOUND;
		if(rg_db.naptIn[rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.hashIdx].coneType!=NAPT_IN_TYPE_FULL_CONE)
			serverInLan = 0;
		else
			serverInLan = 1;
	}


	//Check ALG
	if(pPktHdr->algAction==RG_ALG_ACT_NORMAL)_rtk_rg_algFunctionCheck(direct, pPktHdr, serverInLan);
	DEBUG("algAction=%d, algRegFun is %s", pPktHdr->algAction, pPktHdr->algRegFun==NULL?"NULL":"not NULL");
	if(pPktHdr->algAction==RG_ALG_ACT_TO_PS){
		TRACE("[To PS] hit ALG and registered function is NULL, to PS!");
		return RG_FWDENGINE_RET_TO_PS;
	}

	if((*pNaptOutIdx>=0) && (pPktHdr->tcpFlags.reset==1)){
		_rtk_rg_fwdEngine_receivedTCPReset(pPktHdr, pNaptOutIdx);
	}else if((*pNaptOutIdx>=0) && ((rg_db.naptOut[*pNaptOutIdx].state==TCP_CONNECTED)||(rg_db.naptOut[*pNaptOutIdx].state==FIRST_FIN)||(rg_db.naptOut[*pNaptOutIdx].state==FIRST_FIN_IN)||(rg_db.naptOut[*pNaptOutIdx].state==FIRST_FIN_OUT)
		//20190515LUKE: support piggyback http GET.
		||(rg_db.naptOut[*pNaptOutIdx].state==SYN_ACK_RECV&&(pPktHdr->tcpFlags.ack==1)&&(pPktHdr->tcpFlags.push==1)))){
		//check rg_db.naptOut[*pNaptOutIdx].state==FIN_SEND_AND_RECV in case we get retransmit
		if(pPktHdr->tcpFlags.fin==1){
			if(direct == NAPT_DIRECTION_OUTBOUND)
				_rtk_rg_fwdEngine_receivedTCPFin(pPktHdr, pNaptOutIdx, FIRST_FIN_OUT);
			else
				_rtk_rg_fwdEngine_receivedTCPFin(pPktHdr, pNaptOutIdx, FIRST_FIN_IN);
		}else{
#ifdef CONFIG_ROME_NAPT_SHORTCUT
			if(rg_db.naptOut[*pNaptOutIdx].state==TCP_CONNECTED && pPktHdr->shortcutStatus!=RG_SC_MATCH){
				//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
				//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
					pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
			}
#endif

			//check for HTTPS/HTTPS packet
			if((pPktHdr->httpsClientHelloPacket==1 || pPktHdr->httpFirstPacket==1)&& rg_db.systemGlobal.urlHiPri_En &&(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)&&(pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort || pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort))
			{
				_check_urlAssignPri(pPktHdr,*pNaptOutIdx);
				if(pPktHdr->urlPriHit)
				{
					rg_db.naptOut[*pNaptOutIdx].urlPriEn=pPktHdr->urlPriHit;
					rg_db.naptOut[*pNaptOutIdx].urlPriIdx=pPktHdr->urlPriHitIdx;
				}
			}		
		}
		//20210913: all packets need to be checked by url filter(test by youhua)
		//check for HTTP packet
		if((pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)&&(pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort)){
			ret=_check_Http_mechanism(pPktHdr, pNaptOutIdx);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;
			pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
		}
		//check for HTTPS packet
		if((pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)&&(pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort)){
			ret=_check_Https_urlFilter(pPktHdr);
			if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;
			pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
		}
	}else{
		if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==0)){
			//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n%p",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset,rg_db.pNaptOutFreeListHead);

			//Lookup and write to free SW NAPT entry
			if(*pNaptOutIdx<0)
			{
				if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT){
	            	ret = _rtk_rg_fwdEngine_outbound_fillNaptInfo(pNaptOutIdx,pPktHdr);
#ifdef CONFIG_ROME_NAPT_LRU
					if(ret!=RG_RET_SUCCESS)
					{
						TRACE("[Drop] Fail to fill ipv4 napt info");
						return RG_FWDENGINE_RET_DROP;
					}
#else
					if(ret!=RG_RET_SUCCESS)
					{
						TRACE("[To PS] Fail to fill ipv4 napt info");
						return RG_FWDENGINE_RET_TO_PS;
					}
#endif
				}else{
					ret = _rtk_rg_fwdEngine_inbound_fillNaptInfo(pNaptOutIdx,pPktHdr,transIP,transPort);
					//DEBUG("set napt out[%d] software entry",*pNaptOutIdx);
					if(ret!=SUCCESS)
					{
						TRACE("[To PS] Fail to fill ipv4 napt info");
						return RG_FWDENGINE_RET_TO_PS;
					}
				}

				if(rg_db.naptOut[*pNaptOutIdx].state>SYN_RECV)
				{
					WARNING("rg_db.naptOut[*pNaptOutIdx(%d)].state>SYN_RECV=%d",*pNaptOutIdx,rg_db.naptOut[*pNaptOutIdx].state);
				}
			}
			//20181015LUKE: only prohibit simultaneous SYN packet from WAN.
			else if((pPktHdr->fwdDecision==RG_FWD_DECISION_NAPTR) && rg_db.systemGlobal.tcpDisableSimultaneousSYN){
				TRACE("[DROP] TCP simultaneous SYN is disabled..The SYN packet with existing flow would be droped!");
				return RG_FWDENGINE_RET_DROP;
			}
			rg_db.naptOut[*pNaptOutIdx].state=SYN_RECV;
			//20180427LUKE: recovery SYN ACK TRAP setting if we do not accelerate DPI.
			if(rg_db.systemGlobal.dpi_accelerate_enable)
			{
				if(time_is_after_jiffies(rg_db.systemGlobal.dpi_accelerate_jiffies))
					goto LEARNING_AT_SYN;
//20181120LUKE: since we need SYN ACK for MSS clamping, we could not forward it by hwnat.
#if 0//defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
				else
					RTK_RG_ASIC_GLOBALSTATE_SET(FB_GLOBAL_TRAP_TCP_SYN_ACK, rg_db.systemGlobal.tcp_hw_syn_ack_forward?DISABLED:ENABLED);
#endif
			}
		}
		if(((pPktHdr->tcpFlags.syn==0)&&(pPktHdr->tcpFlags.ack==1)&&(pPktHdr->tcpFlags.fin==0)&&(pPktHdr->tcpFlags.push==0))||
			((pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)&&(rg_db.systemGlobal.tcp_hw_learning_at_syn==1)&&(rg_db.naptOut[*pNaptOutIdx].state==SYN_RECV)))
		{
			if((rg_db.naptOut[*pNaptOutIdx].state==SYN_ACK_RECV)||(rg_db.naptOut[*pNaptOutIdx].state==SYN_RECV))
			{
				if((pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)&&(pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort)&&_check_Http_keep_in_sw(pPktHdr)){
					DEBUG("keep in sw for checking http mechanism later!!");
					//naptInIdx = rg_db.naptOut[*pNaptOutIdx].rtk_naptOut.hashIdx;
					rg_db.naptOut[*pNaptOutIdx].state=TCP_CONNECTED;
					//TRACE("Http Packet(dport==80), delay adding TCP naptOut[%d],naptIn[%d] until urlFilter or forcePortal Check.",*pNaptOutIdx,naptInIdx);
					//http80 always go normal path
				}else if((pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)&&(pPktHdr->dport==rg_db.systemGlobal.httpsMonitorPort)&&_check_Https_keep_in_sw(pPktHdr)){
					DEBUG("keep in sw for checking https url filter later!!");
					rg_db.naptOut[*pNaptOutIdx].state=TCP_CONNECTED;
				}else{
LEARNING_AT_SYN:
					DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);

					pPktHdr->addNaptAfterNicTx=1;
#ifdef CONFIG_ROME_NAPT_SHORTCUT
					//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
					//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
						pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
				}

			}
			else if(rg_db.naptOut[*pNaptOutIdx].state==FIN_SEND_AND_RECV)
			{
				rg_db.naptOut[*pNaptOutIdx].state=LAST_ACK;
				if(!rg_db.systemGlobal.tcpDoNotDelWhenRstFin)
				{
					if(rg_db.systemGlobal.tcpShortTimeoutHousekeepJiffies)
						_rtk_rg_tcpShortTimeoutRecycle(*pNaptOutIdx);
					else if(rg_db.systemGlobal.tcp_short_timeout<=1)
						pPktHdr->delNaptConnection=1;
				}
			}
		}
		else if((pPktHdr->tcpFlags.syn==1)&&(pPktHdr->tcpFlags.ack==1))
		{
			//DEBUG("SYN:%d ACK:%d FIN:%d RST:%d\n",pPktHdr->tcpFlags.syn,pPktHdr->tcpFlags.ack,pPktHdr->tcpFlags.fin,pPktHdr->tcpFlags.reset);
			if(rg_db.naptOut[*pNaptOutIdx].state==INVALID)
			{
				//DEBUG("loss syn naptOutIdx=%d",*pNaptOutIdx);
				TRACE("[To PS] loss syn packet");
				return RG_FWDENGINE_RET_TO_PS;
			}
			if(rg_db.naptOut[*pNaptOutIdx].state<=SYN_ACK_RECV)
			{
				rg_db.naptOut[*pNaptOutIdx].state=SYN_ACK_RECV;

				// the 3 ways handshake maybe forward by HW, so must add hw entry at this time.
				//20150908LUKE: handle for virtual server with full cone
				if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)pPktHdr->addNaptAfterNicTx=1;

#ifdef CONFIG_ROME_NAPT_SHORTCUT
				if(rg_db.systemGlobal.urlHiPri_En &&(pPktHdr->sport==rg_db.systemGlobal.httpsMonitorPort || pPktHdr->sport==rg_db.systemGlobal.httpMonitorPort) )
				{
					pPktHdr->shortcutStatus=RG_SC_NORMAL_PATH;
					TRACE("url=priority En We add to hardware next pakcet");
				}
				else
				{
					//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
					//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
					pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
				}
#endif
			}
		}
	}
	return RG_FWDENGINE_RET_NAPT_OK;
}

void _rtk_rg_force_tcp_add_connection(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
	if(_rtk_rg_fwdEngine_outbound_fillNaptInfo(pNaptOutIdx,pPktHdr)==RG_RET_SUCCESS){
		rg_db.naptOut[*pNaptOutIdx].state=TCP_CONNECTED;
		pPktHdr->addNaptAfterNicTx=1;
		TRACE("TCP disable stateful tracking: add naptOut[%d]",*pNaptOutIdx);
#ifdef CONFIG_ROME_NAPT_SHORTCUT
		//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
			pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
	}
}

void _rtk_rg_force_tcp_add_inbound_connection(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx, ipaddr_t transIP, uint16 transPort)
{	
	if(_rtk_rg_fwdEngine_inbound_fillNaptInfo(pNaptOutIdx, pPktHdr, transIP, transPort)==RG_RET_SUCCESS){
		rg_db.naptOut[*pNaptOutIdx].state=TCP_CONNECTED;
		pPktHdr->addNaptAfterNicTx=1;
		TRACE("[Enhanced dmz] add naptOut[%d]",*pNaptOutIdx);
#ifdef CONFIG_ROME_NAPT_SHORTCUT
		if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
			pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
	}
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_TCPOutboundConnectionTracking(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
	//20151207LUKE: disable TCP stateful tracking
	if(rg_db.systemGlobal.tcpDisableStatefulTracking && *pNaptOutIdx<0)
		_rtk_rg_force_tcp_add_connection(pPktHdr, pNaptOutIdx);
	return _rtk_rg_fwdEngine_TCPConnectionTracking(pPktHdr, pNaptOutIdx);
}


__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_TCPInboundConnectionTracking(rtk_rg_pktHdr_t *pPktHdr, int *pNaptOutIdx)
{
#if	defined(CONFIG_RG_NAPT_DMZ_SUPPORT)
	ipaddr_t transIP = pPktHdr->ipv4Dip;
	uint16 transPort = pPktHdr->dport;
	if(rg_db.systemGlobal.enhanced_dmz && *pNaptOutIdx<0 && _rtk_rg_fwdEngine_dmzCheck(pPktHdr, &transIP, &transPort)==RG_RET_SUCCESS)
		_rtk_rg_force_tcp_add_inbound_connection(pPktHdr, pNaptOutIdx, transIP, transPort);
#endif
	return _rtk_rg_fwdEngine_TCPConnectionTracking(pPktHdr, pNaptOutIdx);
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_UDPOutboundConnectionTracking(rtk_rg_pktHdr_t *pPktHdr, int *retIdx)
{
	int naptOutIdx=0,naptInIdx=0;
	rtk_rg_successFailReturn_t sf_ret=RG_RET_SUCCESS;
	uint8 serverInLan;

	//naptOutIdx=_rtk_rg_naptTcpUdpOutHashIndexLookup(0,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
	naptOutIdx=_rtk_rg_naptTcpUdpOutHashIndexLookupByPktHdr(0,pPktHdr);

	if(naptOutIdx<0) //RG_RET_LOOKUPIDX_NOT_FOUND
	{
		//Check ALG
		serverInLan = 0;
		_rtk_rg_algFunctionCheck(NAPT_DIRECTION_OUTBOUND, pPktHdr, serverInLan);
		DEBUG("algAction=%d, algRegFun is %s", pPktHdr->algAction, pPktHdr->algRegFun==NULL?"NULL":"not NULL");
		if(pPktHdr->algAction==RG_ALG_ACT_TO_PS){
			TRACE("[To PS] hit ALG and registered function is NULL, to PS!");
			return RG_FWDENGINE_RET_TO_PS;
		}

		//Lookup and set NAPT SW tables
		sf_ret = _rtk_rg_fwdEngine_outbound_fillNaptInfo(&naptOutIdx,pPktHdr);
#ifdef CONFIG_ROME_NAPT_LRU
		if(sf_ret!=RG_RET_SUCCESS)
		{
			TRACE("[Drop] Fail to fill ipv4 napt info");
			return RG_FWDENGINE_RET_DROP; //all fwdEngine sw-entry is full.(NEVER HAPPEN)
		}
#else
		if(sf_ret!=SUCCESS)
		{
			TRACE("[To PS] Fail to fill ipv4 napt info");
			return RG_FWDENGINE_RET_TO_PS;
		}
#endif
		rg_db.naptOut[naptOutIdx].state=UDP_FIRST;
		//DEBUG("UDP state=%d extport=%d\n",rg_db.naptOut[naptOutIdx].state,rg_db.naptOut[naptOutIdx].extPort);
	}
	else
	{
		//Check ALG
		if(rg_db.naptIn[rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx].coneType!=NAPT_IN_TYPE_FULL_CONE)
			serverInLan = 0;
		else
			serverInLan = 1;
		_rtk_rg_algFunctionCheck(NAPT_DIRECTION_OUTBOUND, pPktHdr, serverInLan);
		DEBUG("algAction=%d, algRegFun is %s", pPktHdr->algAction, pPktHdr->algRegFun==NULL?"NULL":"not NULL");
		if(pPktHdr->algAction==RG_ALG_ACT_TO_PS){
			TRACE("[To PS] hit ALG and registered function is NULL, to PS!");
			return RG_FWDENGINE_RET_TO_PS;
		}

		if(rg_db.naptOut[naptOutIdx].state==UDP_FIRST)
		{
			rg_db.naptOut[naptOutIdx].state=UDP_SECOND;
			//DEBUG("UDP state=%d extport=%d\n",rg_db.naptOut[naptOutIdx].state,rg_db.naptOut[naptOutIdx].extPort);
		}
		else if(rg_db.naptOut[naptOutIdx].state==UDP_SECOND)
		{
			//rg_db.naptOut[naptOutIdx].state=UDP_CONNECTED;
			//DEBUG("UDP state=%d extport=%d\n",rg_db.naptOut[naptOutIdx].state,rg_db.naptOut[naptOutIdx].extPort);
			//Add NAPT connection to ASIC
			naptInIdx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
			pPktHdr->addNaptAfterNicTx = 1;
			//ret = _rtk_rg_naptConnection_add(naptOutIdx,&rg_db.naptOut[naptOutIdx].rtk_naptOut,&rg_db.naptIn[naptInIdx].rtk_naptIn);
			//assert_ok(ret);

			//TRACE("add UDP naptOut[%d],naptIn[%d] extPort=%d",naptOutIdx,naptInIdx,rg_db.naptOut[naptOutIdx].extPort);
#ifdef CONFIG_ROME_NAPT_SHORTCUT
			//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
			//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
				pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
		}
		else if(rg_db.naptOut[naptOutIdx].state==UDP_CONNECTED)
		{
			//since the connection is created, we can updat shortcut to accelerate the data path!!
			if(pPktHdr->shortcutStatus==RG_SC_NORMAL_PATH)
			{
				//DEBUG("in %s, the state is %d, we should update shortcut!!",__FUNCTION__,rg_db.naptOut[naptOutIdx].state);
#ifdef CONFIG_ROME_NAPT_SHORTCUT
				//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
				//if(pPktHdr->ipv4FragPacket==0)	//fragment	packets should always go normal path
					pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
			}
		}
	}
	*retIdx = naptOutIdx;

	return RG_FWDENGINE_RET_NAPT_OK;
}

int _rtk_rg_fwdEngine_ICMPOutboundControlFlowTracking(rtk_rg_pktHdr_t *pPktHdr, rtk_rg_table_icmp_flow_t **icmpCtrlList)
{
	rtk_rg_table_icmp_flow_t *pEntry;

	//create new control flow in link-list
	pEntry=&rg_db.pICMPCtrlFlowHead->icmpFlow;
	rg_db.pICMPCtrlFlowHead=rg_db.pICMPCtrlFlowHead->pNext;

	pEntry->valid=1;
	pEntry->internalIP=pPktHdr->ipv4Sip;
	pEntry->remoteIP=pPktHdr->ipv4Dip;
	pEntry->IPID=pPktHdr->ipv4Identification;
	//pEntry->ICMPType=pPktHdr->ICMPType;
	//pEntry->ICMPCode=pPktHdr->ICMPCode;
	pEntry->ICMPID=pPktHdr->ICMPIdentifier;
	pEntry->ICMPSeqNum = pPktHdr->ICMPSeqNum;
	pEntry->jiffies = jiffies;
	if(pPktHdr->ingressLocation == RG_IGR_PROTOCOL_STACK)
		pEntry->psConnection = 1;
	else
		pEntry->psConnection = 0;

	TRACE("internalIP=%pI4h remoteIP=%pI4h",&pEntry->internalIP,&pEntry->remoteIP);
	*icmpCtrlList=pEntry;
	return RG_FWDENGINE_RET_NAPT_OK;
}

rtk_rg_err_code_t _rtk_rg_fwdEngine_ICMPInboundControlFlowTracking(rtk_rg_pktHdr_t *pPktHdr, rtk_rg_table_icmp_flow_t **icmpCtrlList)
{
	rtk_rg_table_icmp_linkList_t *pEntry;

	//lookup all link-list
	for(pEntry=rg_db.pICMPCtrlFlowHead->pPrev;pEntry!=rg_db.pICMPCtrlFlowHead;pEntry=pEntry->pPrev)
	{
		//TRACE("valid=%d id1=%d id2=%d ip1=%x ip2=%x seq1=%d seq2=%d",
		// 	pEntry->icmpFlow.valid,pEntry->icmpFlow.ICMPID,pPktHdr->ICMPIdentifier,pEntry->icmpFlow.remoteIP,pPktHdr->ipv4Sip,pEntry->icmpFlow.ICMPSeqNum,pPktHdr->ICMPSeqNum);

		//DEBUG("[!!FOUND] valid=%d id1=%d id2=%d ip1=%x ip2=%x seq1=%d seq2=%d en->jiff=%lu jiffie=%lu delta_jiffies=%lu",
		//	pEntry->icmpFlow.valid,pEntry->icmpFlow.ICMPID,pPktHdr->ICMPIdentifier,pEntry->icmpFlow.remoteIP,pPktHdr->ipv4Sip,pEntry->icmpFlow.ICMPSeqNum,pPktHdr->ICMPSeqNum,
		//	pEntry->icmpFlow.jiffies,jiffies, (jiffies-(rg_db.systemGlobal.icmp_timeout*TICKTIME_PERIOD)));

		if(pEntry->icmpFlow.valid==1 &&
			pEntry->icmpFlow.ICMPID==pPktHdr->ICMPIdentifier &&
			pEntry->icmpFlow.ICMPSeqNum == pPktHdr->ICMPSeqNum &&
			pEntry->icmpFlow.remoteIP==pPktHdr->ipv4Sip &&
			time_before((jiffies-(rg_db.systemGlobal.icmp_timeout*TICKTIME_PERIOD)), pEntry->icmpFlow.jiffies))
		{
			//match
			DEBUG("ICMP inbound entry found!");
			if(pEntry->icmpFlow.psConnection)
			{
				TRACE("[To PS] this ICMP connection is for local in/out...delete this icmp connection");
				pEntry->icmpFlow.valid = 0;
				return RT_ERR_RG_TRAP_TO_PS;
			}
			else
			{
				*icmpCtrlList = &pEntry->icmpFlow;
				return RT_ERR_RG_OK;
			}
		}

	}

	//unmatch
	return RT_ERR_RG_ENTRY_NOT_FOUND;
}

#if 0
rtk_rg_table_icmp_flow_t * _rtk_rg_fwdEngine_ICMPOutboundFragmentLookup(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_table_icmp_linkList_t *pEntry;

	//lookup all link-list
	for(pEntry=rg_db.pICMPCtrlFlowHead->pPrev;pEntry!=rg_db.pICMPCtrlFlowHead;pEntry=pEntry->pPrev)
	{
		if(pEntry->icmpFlow.valid==1 && pEntry->icmpFlow.internalIP==pPktHdr->ipv4Sip && pEntry->icmpFlow.IPID==pPktHdr->ipv4Identification)
		{
			//match
			return &pEntry->icmpFlow;
		}
	}

	//unmatch
	return NULL;
}

rtk_rg_table_icmp_flow_t * _rtk_rg_fwdEngine_ICMPInboundFragmentLookup(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_table_icmp_linkList_t *pEntry;

	//lookup all link-list
	for(pEntry=rg_db.pICMPCtrlFlowHead->pPrev;pEntry!=rg_db.pICMPCtrlFlowHead;pEntry=pEntry->pPrev)
	{
		if(pEntry->icmpFlow.valid==1 && pEntry->icmpFlow.remoteIP==pPktHdr->ipv4Sip && pEntry->icmpFlow.inboundIPID==pPktHdr->ipv4Identification)
		{
			//match
			return &pEntry->icmpFlow;
		}
	}

	//unmatch
	return NULL;
}
#endif

#ifdef CONFIG_RG_NAPT_INBOUND_TRACKING
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngine_UDPInboundConnectionTracking(rtk_rg_pktHdr_t *pPktHdr, int *retIdx)
{
	rtk_rg_lookupIdxReturn_t naptOutIdx=0,naptInIdx=0;
	rtk_rg_fwdEngineReturn_t ret=0;
	rtk_rg_successFailReturn_t sf_ret=RG_RET_SUCCESS;
	ipaddr_t transIP = pPktHdr->ipv4Dip;
	uint16 transPort = pPktHdr->dport;
	uint8 serverInLan;

	naptOutIdx=_rtk_rg_naptTcpUdpInHashIndexLookup(0,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);

	if(naptOutIdx<0) // FAIL: entry not found.  -2: Inbound entry is found, but Outbound entry is not found.
	{
		ret = _rtk_rg_fwdEngine_connType_lookup(pPktHdr,&transIP,&transPort);
		if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;

		//Check ALG
		serverInLan = 1;
		_rtk_rg_algFunctionCheck(NAPT_DIRECTION_INBOUND, pPktHdr, serverInLan);
		DEBUG("algAction=%d, algRegFun is %s", pPktHdr->algAction, pPktHdr->algRegFun==NULL?"NULL":"not NULL");
		if(pPktHdr->algAction==RG_ALG_ACT_TO_PS){
			TRACE("[To PS] hit ALG and registered function is NULL, to PS!");
			return RG_FWDENGINE_RET_TO_PS;
		}

		//Lookup and set NAPT SW tables
		sf_ret = _rtk_rg_fwdEngine_inbound_fillNaptInfo(&naptOutIdx,pPktHdr,transIP,transPort);
		if(sf_ret!=RG_RET_SUCCESS)
		{
			TRACE("[To PS] Fail to fill ipv4 napt info");
			return RG_FWDENGINE_RET_TO_PS;
		}
		rg_db.naptOut[naptOutIdx].state=UDP_FIRST;
		//DEBUG("UDP state=%d extport=%d\n",rg_db.naptOut[naptOutIdx].state,rg_db.naptOut[naptOutIdx].extPort);
	}
	else
	{
		//Check ALG
		if(rg_db.naptIn[rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx].coneType!=NAPT_IN_TYPE_FULL_CONE)
			serverInLan = 0;
		else
			serverInLan = 1;
		_rtk_rg_algFunctionCheck(NAPT_DIRECTION_INBOUND, pPktHdr, serverInLan);
		DEBUG("algAction=%d, algRegFun is %s", pPktHdr->algAction, pPktHdr->algRegFun==NULL?"NULL":"not NULL");
		if(pPktHdr->algAction==RG_ALG_ACT_TO_PS){
			TRACE("[To PS] hit ALG and registered function is NULL, to PS!");
			return RG_FWDENGINE_RET_TO_PS;
		}

		if(rg_db.naptOut[naptOutIdx].state==UDP_FIRST)
		{
			rg_db.naptOut[naptOutIdx].state=UDP_SECOND;
			//DEBUG("UDP state=%d extport=%d\n",rg_db.naptOut[naptOutIdx].state,rg_db.naptOut[naptOutIdx].extPort);
		}
		else if(rg_db.naptOut[naptOutIdx].state==UDP_SECOND)
		{
			//rg_db.naptOut[naptOutIdx].state=UDP_CONNECTED;
			//DEBUG("UDP state=%d extport=%d\n",rg_db.naptOut[naptOutIdx].state,rg_db.naptOut[naptOutIdx].extPort);
			//Add NAPT connection to ASIC
			naptInIdx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
			pPktHdr->addNaptAfterNicTx = 1;
			//ret = _rtk_rg_naptConnection_add(naptOutIdx,&rg_db.naptOut[naptOutIdx].rtk_naptOut,&rg_db.naptIn[naptInIdx].rtk_naptIn);
			//TRACE("add UDP naptOut[%d],naptIn[%d] extPort=%d",naptOutIdx,naptInIdx,rg_db.naptOut[naptOutIdx].extPort);
			//pPktHdr->ipv4Dip = rg_db.naptIn[naptInIdx].rtk_naptIn.intIp;
#ifdef CONFIG_ROME_NAPT_SHORTCUT
			//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
			//if(pPktHdr->ipv4FragPacket==0)	//fragment	packets should always go normal path
				pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
			//assert_ok(ret);
		}
		else if(rg_db.naptOut[naptOutIdx].state==UDP_CONNECTED)
		{
			//since the connection is created, we can updat shortcut to accelerate the data path!!
			if(pPktHdr->shortcutStatus==RG_SC_NORMAL_PATH)
			{
				//DEBUG("in %s, the state is %d, we should update shortcut!!",__FUNCTION__,rg_db.naptOut[naptOutIdx].state);
#ifdef CONFIG_ROME_NAPT_SHORTCUT
				//DEBUG("%s,%d  WE NEED UPDATE HERE!!",__FUNCTION__,__LINE__);
				//if(pPktHdr->ipv4FragPacket==0)	//fragment  packets should always go normal path
					pPktHdr->shortcutStatus=RG_SC_NEED_UPDATE;
#endif
			}
		}
	}
	*retIdx = naptOutIdx;

	return RG_FWDENGINE_RET_NAPT_OK;
}
#endif

int _rtk_rg_fwdengine_handleArpMiss(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_arp_request_t arpReq;
	ipaddr_t ipAddr;
	int ret;
	rtk_rg_sipDipClassification_t sipdipClass;

	pPktHdr->dipL3Idx=_rtk_rg_l3lookup(ntohl(*pPktHdr->pIpv4Dip));

	sipdipClass=SIP_DIP_CLASS_ROUTING;
	ret=_rtk_rg_routingDecisionTablesLookup(pPktHdr,&sipdipClass);
	if(pPktHdr->netifIdx==FAIL/*ret!=RG_FWDENGINE_RET_CONTINUE*/)
		return ret;

	if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan==1)
	{
		ipAddr=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].p_wanStaticInfo->ip_addr;
	}
	else
	{
		ipAddr=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.lan_intf.ip_addr;
	}

	if(ntohl(*pPktHdr->pIpv4Dip)!=ipAddr) //skip gateway ip arp request
	{
		arpReq.finished=0;
		arpReq.gwMacReqCallBack=NULL;
		arpReq.reqIp=ntohl(*pPktHdr->pIpv4Dip);
		arpReq.disableL3Inspect=0;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)&&(defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC))
		//20180726LUKE: disable inpection if we hit binding.
		if(pPktHdr->bindNextHopIdx!=FAIL)arpReq.disableL3Inspect=1;
#endif
		DEBUG("ARP [0x%x] Miss, Send ARP Request!",ntohl(*pPktHdr->pIpv4Dip));
		_rtk_rg_arpGeneration(pPktHdr->netifIdx,ipAddr,&arpReq);
	}

	return RG_FWDENGINE_RET_L2FORWARDED;
}

int _rtk_rg_fwdengine_handleArpMissInRoutingLookUp(rtk_rg_pktHdr_t *pPktHdr)
{
	int i,netifIdx=pPktHdr->netifIdx;
	rtk_rg_arp_request_t arpReq;
	ipaddr_t ipAddr;

	//20181220LUKE: if not hit, trap to cpu if rg_db.systemGlobal.trapICMPWhenNeighMiss
	if((pPktHdr->tagif&ICMP_TAGIF) && rg_db.systemGlobal.trapICMPWhenNeighMiss)
	{
		TRACE("[To PS] IPv4: ARP table un-hit for ICMP, TRAP!");
		return RG_FWDENGINE_RET_TO_PS;
	}

	for(i=0; i<MAX_NETIF_SW_TABLE_SIZE; i++)
	{
		if(rg_db.systemGlobal.interfaceInfo[i].valid==0) continue;
		if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.is_wan==1)
		{
			if(rg_db.systemGlobal.interfaceInfo[i].storedInfo.wan_intf.wan_intf_conf.wan_type==RTK_RG_BRIDGE)
				continue;
			//not bridge wan
			ipAddr=rg_db.systemGlobal.interfaceInfo[i].p_wanStaticInfo->ip_addr;
		}
		else
		{
			ipAddr=rg_db.systemGlobal.interfaceInfo[i].storedInfo.lan_intf.ip_addr;
		}

		if(ntohl(*pPktHdr->pIpv4Dip)==ipAddr)
		{
			TRACE("[To PS] DIP equal to gateway IP(0x%x), TRAP!!",ipAddr);
			return RG_FWDENGINE_RET_TO_PS;
		}
	}

	// generate arp request
	ipAddr=rg_db.l3[pPktHdr->dipL3Idx].gateway_ip;
	arpReq.disableL3Inspect=0;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)&&(defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC))
	//20180726LUKE: disable inpection if we hit binding.
	if(pPktHdr->bindNextHopIdx!=FAIL)
	{
		netifIdx=rg_db.nexthop[pPktHdr->bindNextHopIdx].rtk_nexthop.ifIdx;
		arpReq.disableL3Inspect=1;
		ipAddr=0;
	}
#endif
	if(ipAddr==0)
	{
		if(rg_db.systemGlobal.interfaceInfo[netifIdx].storedInfo.is_wan==1)
			ipAddr=rg_db.systemGlobal.interfaceInfo[netifIdx].p_wanStaticInfo->ip_addr;
		else
			ipAddr=rg_db.systemGlobal.interfaceInfo[netifIdx].storedInfo.lan_intf.ip_addr;
	}
	arpReq.finished=0;
	arpReq.gwMacReqCallBack=NULL;
	arpReq.reqIp=ntohl(*pPktHdr->pIpv4Dip);
	TRACE("ARP [0x%x] Miss, Send ARP Request!from gwIP %x..",ntohl(*pPktHdr->pIpv4Dip),ipAddr);
	_rtk_rg_arpGeneration(netifIdx,ipAddr,&arpReq);

	return RG_FWDENGINE_RET_L2FORWARDED;
}


int _rtk_rg_fwdengine_handleNeighborMiss(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_neighbor_discovery_t neighborDisc;
	rtk_ipv6_addr_t ipAddr;
	int ret,netIfIdx;
	//DEBUG("handle neighbor miss!");
	//_rtk_rg_v6RoutingDecisionTablesLookup(pPktHdr,0 /*It's not LAN to WAN*/);
	ret=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
	//DEBUG("the v6L3lookup ret is %d",ret);
	if(ret<0)return RG_FWDENGINE_RET_L2FORWARDED;

	if(rg_db.v6route[ret].rtk_v6route.type == L34_IPV6_ROUTE_TYPE_LOCAL)
	{
		netIfIdx=rg_db.v6route[ret].rtk_v6route.nhOrIfidIdx;
	}
	else if(rg_db.v6route[ret].rtk_v6route.type == L34_IPV6_ROUTE_TYPE_GLOBAL)
	{
		netIfIdx=rg_db.nexthop[rg_db.v6route[ret].rtk_v6route.nhOrIfidIdx].rtk_nexthop.ifIdx;
	}
	else
		return RG_FWDENGINE_RET_L2FORWARDED;

	memcpy(ipAddr.ipv6_addr,rg_db.v6route[ret].gateway_ipv6Addr.ipv6_addr,IPV6_ADDR_LEN);
	/*DEBUG("the ipaddr is %08x:%08x:%08x:%08x",*(unsigned int *)ipAddr.ipv6_addr,
		*(unsigned int *)(ipAddr.ipv6_addr+4),
		*(unsigned int *)(ipAddr.ipv6_addr+8),
		*(unsigned int *)(ipAddr.ipv6_addr+12));*/
	if(memcmp(pPktHdr->pIpv6Dip,ipAddr.ipv6_addr,IPV6_ADDR_LEN))	//skip gateway ip neighbor discovery
	{
		neighborDisc.finished=0;
		neighborDisc.ipv6GwMacReqCallBack=NULL;
		memcpy(neighborDisc.reqIp.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN);
		DEBUG("Neighbor [0x%08x:%08x:%08x:%08x] Miss, Send Neighbor Discovery!",
			*(unsigned int *)pPktHdr->pIpv6Dip,
			*(unsigned int *)(pPktHdr->pIpv6Dip+4),
			*(unsigned int *)(pPktHdr->pIpv6Dip+8),
			*(unsigned int *)(pPktHdr->pIpv6Dip+12));
		_rtk_rg_NDGeneration(netIfIdx,ipAddr,&neighborDisc);
		//return RG_FWDENGINE_RET_TO_PS;
	}

	return RG_FWDENGINE_RET_L2FORWARDED;
}

uint16 _rtk_rg_CompareByte(uint8 char_a, uint8 char_b, uint8 mask)
{
	uint8 tmp_a,tmp_b,res;
	tmp_a = char_a&mask;
	tmp_b = char_b&mask;
	res = tmp_a^tmp_b;
	if (res == 0)	//tmp_a == tmp_b
		return 1;
	else
		return 0;
}

rtk_rg_successFailReturn_t _rtk_rg_getInternalPriByPortbased(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){

	if(pPktHdr->ingressMacPort < RTK_RG_MAC_PORT_MAX){
		*internalPri = rg_db.systemGlobal.qosInternalDecision.qosPortBasedPriority[pPktHdr->ingressMacPort];
		TRACE("Internal Pri:%d choosed by Portbased[%d]",*internalPri,pPktHdr->ingressMacPort);
		return RG_RET_SUCCESS;
	}
	return RG_RET_FAIL;
}

int _rtk_rg_getInternalPriByDot1q(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){

	if(pPktHdr->tagif & CVLAN_TAGIF){
		*internalPri = rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemapToInternalPriTbl[pPktHdr->ctagPri];
		TRACE("Internal Pri:%d choosed by dot1q[%d]",*internalPri,pPktHdr->ctagPri);
		return RT_ERR_RG_OK;
	}

	return RT_ERR_RG_FAILED;
}

int _rtk_rg_getInternalPriByDscp(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){
	uint8 dscp;
	if(pPktHdr->pTos!=NULL){
		dscp = (pPktHdr->tos>>2);
	}else{
		return RT_ERR_RG_FAILED; //no dscp field
	}

	if((pPktHdr->tagif & IPV4_TAGIF) || (pPktHdr->tagif & IPV6_TAGIF)){
		if(pPktHdr->pTos!=NULL){
			*internalPri = rg_db.systemGlobal.qosInternalDecision.qosDscpRemapToInternalPri[dscp];
			TRACE("Internal Pri:%d choosed by dscp[%d]",*internalPri,dscp);
			return RT_ERR_RG_OK;
		}
	}
	return RT_ERR_RG_FAILED;
}

int _rtk_rg_getInternalPriByVlan(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){

	int internalVid;
	internalVid = pPktHdr->internalVlanID;
	if(rg_db.vlan[internalVid].priorityEn==ENABLED){
		*internalPri = rg_db.vlan[internalVid].priority;
		TRACE("Internal Pri:%d choosed by Vlan[%d]",*internalPri,internalVid);
		return RT_ERR_RG_OK;
	}
	return RT_ERR_RG_FAILED;
}

int _rtk_rg_getInternalPriByLayer4(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){
	if(pPktHdr->l4Direction==RG_NAPT_OUTBOUND_FLOW){
		if(pPktHdr->naptOutboundIndx>=0 && rg_db.naptOut[pPktHdr->naptOutboundIndx].rtk_naptOut.priValid){
			*internalPri = rg_db.naptOut[pPktHdr->naptOutboundIndx].rtk_naptOut.priValue;
			TRACE("Internal Pri:%d choosed by NAPT[%d]",*internalPri,pPktHdr->naptOutboundIndx);
			return RT_ERR_RG_OK;
		}
	}else if(pPktHdr->l4Direction==RG_NAPTR_INBOUND_FLOW){
		if(pPktHdr->naptrInboundIndx>=0 && rg_db.naptIn[pPktHdr->naptrInboundIndx].rtk_naptIn.priValid){
			*internalPri = rg_db.naptIn[pPktHdr->naptrInboundIndx].rtk_naptIn.priId;
			TRACE("Internal Pri:%d choosed by NAPTR[%d]",*internalPri,pPktHdr->naptrInboundIndx);
			return RT_ERR_RG_OK;
		}
	}
	return RT_ERR_RG_FAILED;
}

int _rtk_rg_getInternalPriByAcl(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){

	rtk_rg_mac_port_idx_t ingressMacPort;
	rtk_rg_mac_ext_port_idx_t ingressMacExtPort;

	if((pPktHdr->tagif&TCP_TAGIF) && 
		(((pPktHdr->tcpFlags.syn==1) && rg_db.systemGlobal.trapSpecificLengthSyn.portMask) 
			|| ((pPktHdr->tcpFlags.ack==1) && rg_db.systemGlobal.trapSpecificLengthAck.portMask))){
		
		_rtk_rg_portToMacPort_translator(pPktHdr->ingressPort, &ingressMacPort, &ingressMacExtPort);
		
		if((pPktHdr->tcpFlags.syn==1) && RTK_RG_PROC_CHECK_SYN_IMPACT(ingressMacPort, pPktHdr->skb->len))
		{
			*internalPri  = rg_db.systemGlobal.trapSpecificLengthSyn.priority;
			TRACE("Internal Pri:%d choosed by ACL(/proc/rg/assign_syn_priority_or_trap)",*internalPri);
			return RT_ERR_RG_OK;
		}
		if((pPktHdr->tcpFlags.ack==1) && RTK_RG_PROC_CHECK_ACK_IMPACT(ingressMacPort, pPktHdr->skb->len))
		{
			*internalPri  = rg_db.systemGlobal.trapSpecificLengthAck.priority;
			TRACE("Internal Pri:%d choosed by ACL(/proc/rg/assign_ack_priority_or_trap)",*internalPri);
			return RT_ERR_RG_OK;
		}
	}

	if(pPktHdr->aclPriority!=-1/*acl internal action will change this value*/){
		*internalPri  = pPktHdr->aclPriority;
		TRACE("Internal Pri:%d choosed by ACL",*internalPri);
		return RT_ERR_RG_OK;
	}
	return RT_ERR_RG_FAILED;
}

#if !defined(CONFIG_RG_RTL9602C_SERIES)
int _rtk_rg_getInternalPriByLut(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb, uint8 *internalPri){

	int i;

	//search the lut
	for(i=0;i<MAX_LUT_SW_TABLE_SIZE;i++){
		if(rg_db.lut[i].valid==1 && rg_db.lut[i].rtk_lut.entryType==RTK_LUT_L2UC){//check vlaid and is unicast

			if(rg_db.lut[i].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL){//IVL compatre vid
				if(pPktHdr->internalVlanID != rg_db.lut[i].rtk_lut.entry.l2UcEntry.vid) continue;
			}else{//SVL compare fid
				//FID defined at LAN_FID/WAN_FID, now the setting is the same!
			}

			//compare dmac
			if(rg_db.lut[i].rtk_lut.entry.l2UcEntry.mac.octet[0] == pPktHdr->pDmac[0] &&
				rg_db.lut[i].rtk_lut.entry.l2UcEntry.mac.octet[1] == pPktHdr->pDmac[1] &&
				rg_db.lut[i].rtk_lut.entry.l2UcEntry.mac.octet[2] == pPktHdr->pDmac[2] &&
				rg_db.lut[i].rtk_lut.entry.l2UcEntry.mac.octet[3] == pPktHdr->pDmac[3] &&
				rg_db.lut[i].rtk_lut.entry.l2UcEntry.mac.octet[4] == pPktHdr->pDmac[4] &&
				rg_db.lut[i].rtk_lut.entry.l2UcEntry.mac.octet[5] == pPktHdr->pDmac[5]){

				if(rg_db.lut[i].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_FWD_PRI){//lutFwd priority is enabled
					*internalPri  = rg_db.lut[i].rtk_lut.entry.l2UcEntry.priority;
					TRACE("Internal Pri:%d choosed by LUT(l2Idx=%d)",*internalPri,i);
					return RT_ERR_RG_OK;
				}else{
					break;
				}
			}else{
				continue;
			}
		}
	}

	//no entry found, return failed
	return RT_ERR_RG_FAILED;
}
#endif

rtk_rg_successFailReturn_t _rtk_rg_internalPrioritySelect(rtk_rg_pktHdr_t *pPktHdr,struct sk_buff *skb){

	int i,j;
	rtk_rg_successFailReturn_t ret;
	uint8 highestWeight;
	uint8 internalPri=0;

	//DEBUG("================================================");

	/*if no need to remarking, then we don't need to calculate the internal Prioirty.*/
	/* ACL filter egress_ctag_pri need this information
	if(rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT0]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT1]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT2]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT3]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT_PON]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT_RGMII]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[RTK_RG_MAC_PORT_CPU]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT0]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT1]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT2]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT3]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT_PON]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT_RGMII]==DISABLED&&
		rg_db.systemGlobal.qosInternalDecision.qosDscpRemarkEgressPortEnableAndSrcSelect[RTK_RG_MAC_PORT_CPU]==DISABLED){
		return RT_ERR_RG_OK;
	}
	*/

	i=15; /*search from the highest weight(15)*/
findHighestValidWeight:
	highestWeight = WEIGHT_OF_END;
	while(i>=0){
		//rtlglue_printf("search i=%d\n",i);
		for(j=0;j<WEIGHT_OF_END;j++){
			//TRACE("rg_db.systemGlobal.qosInternalDecision.internalPriSelectWeight[%d]=%d",j,rg_db.systemGlobal.qosInternalDecision.internalPriSelectWeight[j]);
			if(rg_db.systemGlobal.qosInternalDecision.internalPriSelectWeight[j]==i){
				highestWeight = j;
				break;
			}
		}
		i--; /*search next hight*/
		if(highestWeight!=WEIGHT_OF_END){
			//DEBUG("Internal Pri weight by(%d): %d",j,i);
			break;
		}

		/*all kind of weight is 0 is imposible*/
		if(i==0)
			return RT_ERR_RG_FAILED;
	}

	//TRACE("highestWeight=%d",highestWeight);
	switch(highestWeight){
		case WEIGHT_OF_PORTBASED:
			ret = _rtk_rg_getInternalPriByPortbased(pPktHdr,skb,&internalPri);
			if(ret!=RG_RET_SUCCESS) goto findHighestValidWeight;
			break;
		case WEIGHT_OF_DOT1Q:
			ret = _rtk_rg_getInternalPriByDot1q(pPktHdr,skb,&internalPri);
			if(ret!=RG_RET_SUCCESS) goto findHighestValidWeight;
			break;
		case WEIGHT_OF_DSCP:
			ret = _rtk_rg_getInternalPriByDscp(pPktHdr,skb,&internalPri);
			if(ret!=RG_RET_SUCCESS) goto findHighestValidWeight;
			break;
		case WEIGHT_OF_VLANBASED:
			ret = _rtk_rg_getInternalPriByVlan(pPktHdr,skb,&internalPri);
			if(ret!=RG_RET_SUCCESS) goto findHighestValidWeight;
			break;
		case WEIGHT_OF_L4BASED:
			ret = _rtk_rg_getInternalPriByLayer4(pPktHdr,skb,&internalPri);
			if(ret!=RG_RET_SUCCESS) goto findHighestValidWeight;
			break;
		case WEIGHT_OF_ACL:
			ret = _rtk_rg_getInternalPriByAcl(pPktHdr,skb,&internalPri);
			if(ret!=RG_RET_SUCCESS) goto findHighestValidWeight;
			break;
		case WEIGHT_OF_LUTFWD:
			//ret = _rtk_rg_getInternalPriByLut(pPktHdr,skb,&internalPri);
			//if(ret!=RT_ERR_RG_OK) goto findHighestValidWeight;
			//break;
		case WEIGHT_OF_SABASED:
		case WEIGHT_OF_SVLANBASED:

		default:
			goto findHighestValidWeight;
			/*FIXME: else weight should supported!*/
			break;
	}

#ifdef CONFIG_RG_QOS_DEF_SET
	if (internalPri < 3) internalPri = 3;
#endif

	pPktHdr->internalPriority = internalPri;
	//TRACE("Internal Priority:%d",pPktHdr->internalPriority);



	return RT_ERR_RG_OK;
}

void _rtk_rg_checkWlanUntagMask(rtk_rg_pktHdr_t *pPktHdr)
{

#ifdef CONFIG_MASTER_WLAN0_ENABLE
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)


	if(FWD_DECISION_IS_MC(pPktHdr->fwdDecision))
	{
		// Mc: BcMcGponDownStreamFilter > Acl/CF > igmp_auto_learn_ctagif > normal
		if(pPktHdr->gponDsBcModuleRuleHit || (pPktHdr->aclDecision.aclEgrDoneAction&RG_EGR_CVLAN_ACT_DONE_BIT) ||rg_db.systemGlobal.igmp_auto_learn_ctagif  )
		{
			//do nothing , we change egressVlanID/egressVlanTagif before this function
		}
		else
		{
			if(rg_db.vlan[pPktHdr->egressVlanID].wlan0UntagMask&(0x1<<pPktHdr->egressWlanDevIdx)){
				pPktHdr->egressVlanTagif = 0;
			}else{
				pPktHdr->egressVlanTagif = 1;
			}
			TRACE("Check WlanDev[%d] Vlan[%d]'s wlanUntagMask[%x]: %s!!",pPktHdr->egressWlanDevIdx,pPktHdr->egressVlanID,rg_db.vlan[pPktHdr->egressVlanID].wlan0UntagMask,pPktHdr->egressVlanTagif==1?"Tagged":"Untagged");
		}
	}
	else
	{
		// Uc/Bc/unknowMc: BcMcGponDownStreamFilter > Acl/CF > Dmac2cvid > Normal
		if(pPktHdr->gponDsBcModuleRuleHit || (pPktHdr->aclDecision.aclEgrDoneAction&RG_EGR_CVLAN_ACT_DONE_BIT) || pPktHdr->dmac2VlanID!=FAIL)
		{
			//do nothing , we change egressVlanID/egressVlanTagif before this function
		}
		else
		{
			if(rg_db.vlan[pPktHdr->egressVlanID].wlan0UntagMask&(0x1<<pPktHdr->egressWlanDevIdx)){
				pPktHdr->egressVlanTagif = 0;
			}else{
				pPktHdr->egressVlanTagif = 1;
			}
			TRACE("Check WlanDev[%d] Vlan[%d]'s wlanUntagMask[%x]: %s!!",pPktHdr->egressWlanDevIdx,pPktHdr->egressVlanID,rg_db.vlan[pPktHdr->egressVlanID].wlan0UntagMask,pPktHdr->egressVlanTagif==1?"Tagged":"Untagged");
		}
	}
#else
	//20160509LUKE: we should keep dmac2cvid if match!!
	if(pPktHdr->dmac2VlanID==FAIL)
	{
		if(rg_db.vlan[pPktHdr->egressVlanID].wlan0UntagMask&(0x1<<pPktHdr->egressWlanDevIdx)){
			pPktHdr->egressVlanTagif = 0;
		}else{
			pPktHdr->egressVlanTagif = 1;
		}
		TRACE("Check WlanDev[%d] Vlan[%d]'s wlanUntagMask[%x]: %s!!",pPktHdr->egressWlanDevIdx,pPktHdr->egressVlanID,rg_db.vlan[pPktHdr->egressVlanID].wlan0UntagMask,pPktHdr->egressVlanTagif==1?"Tagged":"Untagged");
	}
#endif

#endif
}

/*
* _rtk_rg_get_aclActionAccelerationType is used for check if fix pktBuff is needed
* @dataPathToWifi: 0 means to HW or wifi slave datapath,  1 means to wifi master datapath
* return:
*   RG_FWDENGINE_ACL_ACC_TYPE_TX_PKTBUFF: pkt related with Stag, must have to modified pktbuff and slow efficiency
*   RG_FWDENGINE_ACL_ACC_TYPE_TX_DESC: pkt vlanTag can handeld by tx_desc, more efficiency.
*/
void _rtk_rg_get_stagCtagAccelerationType(rtk_rg_pktHdr_t *pPktHdr,uint32 dataPathToWifi){
	uint32 txPortMask = 0;
	//master wifi do not have tx_desc, and must send untagged. always handel by skbuff
	if(dataPathToWifi)
	{
		if(pPktHdr->gponDsBcModuleRuleHit)
		{
			TRACE("tagging by gponDsBcModuleRule for master wifi!");
			//continue by internal tagging decision.
			//20160316LUKE: check WLAN's untag set in VLAN!!
			_rtk_rg_checkWlanUntagMask(pPktHdr);
		}
		else
		{
			//20160304LUKE: for packet to wifi should follow untag set of VLAN now.

			if(rg_db.systemGlobal.forceWifiUntag && !rg_db.systemGlobal.initParam.macBasedTagDecision
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
				//20150507LUKE: to WWAN, we should not always untag
				&& (int)pPktHdr->wlan_dev_idx!=(int)RG_WWAN_WLAN0_VXD && (int)pPktHdr->wlan_dev_idx!=(int)RG_WWAN_WLAN1_VXD
#endif
			){
				//20150310LUKE: if macBasedTagDecision is off, we should always remove vlan-tag here!
				TRACE("force unCTag for master wifi if macBasedTagDecision disabled!");
				pPktHdr->egressVlanTagif = 0; //force untag c
				pPktHdr->egressServiceVlanTagif = 0; // //force untag s

			}else{
				//20160316LUKE: check WLAN's untag set in VLAN!!
				_rtk_rg_checkWlanUntagMask(pPktHdr);
			}
		}
		pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_PKTBUFF;
		goto BEFORE_RET;
	}
#ifdef CONFIG_DUALBAND_CONCURRENT
	//slave wifi, force using skbuff, too.
	if(pPktHdr->egressVlanTagif==1 &&
		pPktHdr->egressVlanID==CONFIG_DEFAULT_TO_SLAVE_GMAC_VID &&
		pPktHdr->egressPriority==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI){
		//TRACE("datapath for slave wifi!");
		pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_PKTBUFF;
		goto BEFORE_RET;
	}
#endif
#ifdef CONFIG_RG_G3_SERIES	// CONFIG_RG_G3_SERIES_DEVELOPMENT
	TRACE("for g3 development, we didn't use hw offload ctag/stag!!!");
	pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_PKTBUFF;
#else
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	/*only following 3 cases can using TX_DESC*/
	//(in)untag => (out)untag
	//(in)untag => (out)ctag
	//(in)ctag => (out)untag
	//20160513CHUCK: H/W gmac can not offload ingress vlan modified to egress vlan case, so this knid of case have to offload by S/W ,  exclude case (in)ctag => (out)ctag
	if(((pPktHdr->tagif & CVLAN_TAGIF)==0x0 &&
		(pPktHdr->tagif & SVLAN_TAGIF)==0x0 &&
		(pPktHdr->egressVlanTagif)==0x0 &&
		(pPktHdr->egressServiceVlanTagif)==0x0)){
		pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_DESC;
	}
	else if((pPktHdr->tagif & CVLAN_TAGIF)==0x0 &&
		(pPktHdr->tagif & SVLAN_TAGIF)==0x0 &&
		(pPktHdr->egressVlanTagif) &&
		(pPktHdr->egressServiceVlanTagif)==0x0){
		pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_DESC;
		//add 4 byte for CVLAN in mib counter
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
		pPktHdr->mibTagDelta=4;
#endif
	}
	else if((pPktHdr->tagif & CVLAN_TAGIF) &&
		(pPktHdr->tagif & SVLAN_TAGIF)==0x0 &&
		(pPktHdr->egressVlanTagif)==0x0 &&
		(pPktHdr->egressServiceVlanTagif)==0x0){
		//minus 4 byte for CVLAN in mib counter
		pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_DESC;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
		pPktHdr->mibTagDelta=-4;
#endif
	//rest should handeled by pktbuff
	}else
		pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_PKTBUFF;
#else	//1 gmac support stag/ctag offload

	pPktHdr->egressTagAccType=RG_FWDENGINE_ACL_ACC_TYPE_TX_DESC;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
	if((pPktHdr->tagif&CVLAN_TAGIF)==0 && (pPktHdr->egressVlanTagif))	//untag => tag
		pPktHdr->mibTagDelta+=4;
	else if((pPktHdr->tagif&CVLAN_TAGIF) && (pPktHdr->egressVlanTagif)==0)	//tag => untag
		pPktHdr->mibTagDelta-=4;
	if((pPktHdr->tagif&SVLAN_TAGIF)==0 && (pPktHdr->egressServiceVlanTagif))	//untag => tag
		pPktHdr->mibTagDelta+=4;
	else if((pPktHdr->tagif&SVLAN_TAGIF) && (pPktHdr->egressServiceVlanTagif)==0)	//tag => untag
		pPktHdr->mibTagDelta-=4;
#endif
#endif
#endif

BEFORE_RET:
	if(pPktHdr->egressUniPortmask!=0)
		txPortMask = pPktHdr->egressUniPortmask;
	else
		txPortMask = rg_kernel.txDesc.tx_tx_portmask;

	//TRACE("Portmask [0x%x] Qos accType: %s", txPortMask, pPktHdr->egressTagAccType?"ACC BY TX_DESC":"MUST MODIFY PKTBUFF");
	if(dataPathToWifi)
	{
		TRACE("Master wifi Egress(CVID:%d CTAG_IF:%d STAG_IF:%d) [NIC TX: CVLAN HW offload(%s)]",
			pPktHdr->egressVlanID,
			pPktHdr->egressVlanTagif,
			pPktHdr->egressServiceVlanTagif,
			pPktHdr->egressTagAccType?"on":"off");
	}
	else
	{
		TRACE("Portmask [0x%x] Egress(CVID:%d CTAG_IF:%d STAG_IF:%d) [NIC TX: CVLAN HW offload(%s)]",
			txPortMask,
			pPktHdr->egressVlanID,
			pPktHdr->egressVlanTagif,
			pPktHdr->egressServiceVlanTagif,
			pPktHdr->egressTagAccType?"on":"off");
	}

	//update accType
	if(pPktHdr->shortcutStatus==RG_SC_NEED_UPDATE_BEFORE_SEND){
#ifdef CONFIG_ROME_NAPT_SHORTCUT
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
		pPktHdr->pCurrentShortcutEntry->mibTagDelta=pPktHdr->mibTagDelta;
#endif
		pPktHdr->pCurrentShortcutEntry->tagAccType=pPktHdr->egressTagAccType;
		//20160308LUKE: update vlanTagif from egressVlanTagif which may be changed of Wifi path.
		pPktHdr->pCurrentShortcutEntry->vlanTagif=pPktHdr->egressVlanTagif;
		pPktHdr->pCurrentShortcutEntry->notFinishUpdated=0;
#endif
	}
#ifdef CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT
	else if(pPktHdr->shortcutStatus==RG_SC_V6_NEED_UPDATE_BEFORE_SEND){
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
		pPktHdr->pCurrentV6ShortcutEntry->mibTagDelta=pPktHdr->mibTagDelta;
#endif
		pPktHdr->pCurrentV6ShortcutEntry->tagAccType=pPktHdr->egressTagAccType;
		//20160308LUKE: update vlanTagif from egressVlanTagif which may be changed of Wifi path.
		pPktHdr->pCurrentV6ShortcutEntry->vlanTagif=pPktHdr->egressVlanTagif;
		pPktHdr->pCurrentV6ShortcutEntry->notFinishUpdated=0;
	}
#endif
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	else if(pPktHdr->shortcutStatus==RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND){
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support mib counter of interface
		pPktHdr->pIPv6StatefulList->mibTagDelta=pPktHdr->mibTagDelta;
#endif
		pPktHdr->pIPv6StatefulList->tagAccType=pPktHdr->egressTagAccType;
		//20160308LUKE: update vlanTagif from egressVlanTagif which may be changed of Wifi path.
		pPktHdr->pIPv6StatefulList->vlanTagif=pPktHdr->egressVlanTagif;
		pPktHdr->pIPv6StatefulList->notFinishUpdated=0;
	}
#endif
}

void _rtk_rg_vlanSvlanTag2SkbBuffer(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	uint16 vlanContent,svlanContent;

	//init with just intact
	rg_kernel.txDesc.tx_tx_cvlan_action=0;

	//ingress untag
	if((pPktHdr->tagif & CVLAN_TAGIF)==0x0 && (pPktHdr->tagif & SVLAN_TAGIF)==0x0){
		if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif==0x0){ //untag => untag
			TRACE("VLAN decision: (in)untag => (out)untag");
			// no need to change
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif==0x0){ //untag => ctag
			TRACE("VLAN decision: (in)untag => (out)ctag[VID:%d]",pPktHdr->egressVlanID);
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			_vlan_insert_tag(pPktHdr,skb,1,0x8100,vlanContent,0,0x0,0x0);

		}
		else if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif){ //untag => stag: insert stag to pktbuff
			TRACE("VLAN decision: (in)untag => (out)stag[VID:%d]",pPktHdr->egressServiceVlanID);
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid2,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				//ingress without stag, force using TPID
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}
#else //9600series
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_insert_tag(pPktHdr,skb,1,0x8100,svlanContent,0,0x0,0x0);
			}
#endif
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif){ //untag => s+c tag: insert stag & ctag to pktbuff
			TRACE("VLAN decision: (in)untag => (out)s+c tag[SVID:%d,CVID:%d]",pPktHdr->egressServiceVlanID,pPktHdr->egressVlanID);
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
#if defined(CONFIG_RG_RTL9602C_SERIES)
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,1,0x8100,vlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid2,svlanContent,1,0x8100,vlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				//ingress without stag, force using TPID
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,1,0x8100,vlanContent);
			}
#else //9600series
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,1,0x8100,vlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_insert_tag(pPktHdr,skb,1,0x8100,svlanContent,1,0x8100,vlanContent);
			}
#endif
		}
	}

	//ingress with Ctag only
	else if((pPktHdr->tagif & CVLAN_TAGIF) && (pPktHdr->tagif & SVLAN_TAGIF)==0x0){
		if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif==0x0){ //ctag => untag
			TRACE("VLAN decision: (in)ctag => (out)untag");
			_vlan_remove_tag(pPktHdr,skb,0x8100);

		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif==0x0){ //ctag => ctag
			TRACE("VLAN decision: (in)ctag => (out)ctag[VID:%d]",pPktHdr->egressVlanID);
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			_vlan_modify_tag(pPktHdr, skb, 0x8100, 0x8100, vlanContent);
		}
		else if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif){ //ctag => stag
			TRACE("VLAN decision: (in)ctag => (out)stag[VID=%d]",pPktHdr->egressServiceVlanID);


#if defined(CONFIG_RG_RTL9602C_SERIES)
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid2, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				//ingress without stag, force using TPID
				svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid, svlanContent);
			}
#else //9600series
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
				_vlan_modify_tag(pPktHdr, skb, 0x8100, 0x8100, svlanContent);
			}
#endif
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif){ //ctag => s+c tag
			TRACE("VLAN decision: (in)ctag => (out)s+c tag[SVID:%d,CVID:%d]",pPktHdr->egressServiceVlanID,pPktHdr->egressVlanID);
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));
			//modified ctag
			_vlan_modify_tag(pPktHdr, skb, 0x8100, 0x8100, vlanContent);
#if defined(CONFIG_RG_RTL9602C_SERIES)
			//insert stag
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid2,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				//ingress without stag, force using TPID
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}
#else //9600series
			//insert stag
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_insert_tag(pPktHdr,skb,1,0x8100,svlanContent,0,0x0,0x0);
			}
#endif
		}

	}

	//ingress with Stag only
	else if((pPktHdr->tagif & CVLAN_TAGIF)==0x0 && (pPktHdr->tagif & SVLAN_TAGIF)){
		if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif==0x0){ //stag => untag
			TRACE("VLAN decision: (in)stag => (out)untag");

#if defined(CONFIG_RG_RTL9602C_SERIES)
			//del stag: ingress only consider original tpid.
			_vlan_remove_tag(pPktHdr,skb,pPktHdr->stagTpid);
#else //9600 series
			//del stag: ingress only consider tpid case.
			_vlan_remove_tag(pPktHdr,skb,rg_db.systemGlobal.tpid);
#endif
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif==0x0){ //stag => ctag
			TRACE("VLAN decision: (in)stag => (out)ctag[VID:%d]",pPktHdr->egressVlanID);
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
#if defined(CONFIG_RG_RTL9602C_SERIES)
			//modified stag to ctag
			_vlan_modify_tag(pPktHdr, skb, pPktHdr->stagTpid, 0x8100, vlanContent);
#else
			//modified stag to ctag
			_vlan_modify_tag(pPktHdr, skb, rg_db.systemGlobal.tpid, 0x8100, vlanContent);
#endif
		}
		else if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif){ //stag => stag
			TRACE("VLAN decision: (in)stag => (out)stag[VID:%d]",pPktHdr->egressServiceVlanID);
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_modify_tag(pPktHdr, skb, pPktHdr->stagTpid, rg_db.systemGlobal.tpid, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_modify_tag(pPktHdr, skb, pPktHdr->stagTpid, rg_db.systemGlobal.tpid2, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				_vlan_modify_tag(pPktHdr, skb, pPktHdr->stagTpid, pPktHdr->stagTpid, svlanContent);
			}
#else //9600series
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_modify_tag(pPktHdr, skb, rg_db.systemGlobal.tpid, rg_db.systemGlobal.tpid, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_modify_tag(pPktHdr, skb, rg_db.systemGlobal.tpid, 0x8100, svlanContent);
			}
#endif
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif){ //stag => s+c tag
			TRACE("VLAN decision: (in)stag => (out)s+c tag[SVID:%d,CVID:%d]",pPktHdr->egressServiceVlanID,pPktHdr->egressVlanID);
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));

#if defined(CONFIG_RG_RTL9602C_SERIES)

			//modify stag to ctag
			_vlan_modify_tag(pPktHdr, skb, pPktHdr->stagTpid, 0x8100, vlanContent);

			//insert stag
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid2,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,pPktHdr->stagTpid,svlanContent,0,0x0,0x0);
			}
#else //9600series
			//modify stag to ctag
			_vlan_modify_tag(pPktHdr, skb, rg_db.systemGlobal.tpid, 0x8100, vlanContent);

			//insert stag
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_insert_tag(pPktHdr,skb,1,rg_db.systemGlobal.tpid,svlanContent,0,0x0,0x0);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_insert_tag(pPktHdr,skb,1,0x8100,svlanContent,0,0x0,0x0);
			}
#endif
		}
	}

	//ingress with S+C tag
	else if((pPktHdr->tagif & CVLAN_TAGIF) && (pPktHdr->tagif & SVLAN_TAGIF)){
		if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif==0x0){ //s+c tag => untag
			TRACE("VLAN decision: (in)s+c tag => (out)untag");
			_vlan_remove_doubleTag(pPktHdr,skb);
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif==0x0){ //s+c tag => ctag
			TRACE("VLAN decision: (in)s+c tag => (out)ctag[VID:%d]",pPktHdr->egressVlanID);
#if defined(CONFIG_RG_RTL9602C_SERIES)
			//del stag
			_vlan_remove_tag(pPktHdr,skb,pPktHdr->stagTpid);
#else //9600series
			//del stag
			_vlan_remove_tag(pPktHdr,skb,rg_db.systemGlobal.tpid);
#endif
			//modify ctag
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			_vlan_modify_tag(pPktHdr, skb, 0x8100, 0x8100, vlanContent);
		}
		else if(pPktHdr->egressVlanTagif==0x0 && pPktHdr->egressServiceVlanTagif){ //s+c tag => stag
			TRACE("VLAN decision: (in)s+c tag => (out)stag[VID:%d]",pPktHdr->egressServiceVlanID);
#if defined(CONFIG_RG_RTL9602C_SERIES)
			//del stag
			_vlan_remove_tag(pPktHdr,skb,pPktHdr->stagTpid);

			//modify ctag to stag
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));

			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid2, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				_vlan_modify_tag(pPktHdr, skb, 0x8100, pPktHdr->stagTpid, svlanContent);
			}
#else //9600series
			//del stag
			_vlan_remove_tag(pPktHdr,skb,rg_db.systemGlobal.tpid);

			//modify ctag to stag
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));

			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_modify_tag(pPktHdr, skb, 0x8100, rg_db.systemGlobal.tpid, svlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_modify_tag(pPktHdr, skb, 0x8100, 0x8100, svlanContent);
			}
#endif
		}
		else if(pPktHdr->egressVlanTagif==0x1 && pPktHdr->egressServiceVlanTagif){ //s+c tag => s+c tag
			TRACE("VLAN decision: (in)s+c tag => (out)s+c tag[SVID:%d,CVID:%d]",pPktHdr->egressServiceVlanID,pPktHdr->egressVlanID);
			//modify s+c tag
			vlanContent = (((pPktHdr->egressPriority&0x7)<<13)|((pPktHdr->egressVlanCfi&0x1)<<12)|(pPktHdr->egressVlanID&0xfff));
			svlanContent = (((pPktHdr->egressServicePriority&0x7)<<13)|((pPktHdr->egressServiceVlanDei&0x1)<<12)|(pPktHdr->egressServiceVlanID&0xfff));

#if defined(CONFIG_RG_RTL9602C_SERIES)
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_modify_doubleTag(pPktHdr,skb,rg_db.systemGlobal.tpid,svlanContent,0x8100,vlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with TPID2*/){
				_vlan_modify_doubleTag(pPktHdr,skb,rg_db.systemGlobal.tpid2,svlanContent,0x8100,vlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x3/*tag with original stag tpid*/){
				_vlan_modify_doubleTag(pPktHdr,skb,pPktHdr->stagTpid,svlanContent,0x8100,vlanContent);
			}
#else //9600series
			if( pPktHdr->egressServiceVlanTagif==0x1/*tagged with tpid*/){
				_vlan_modify_doubleTag(pPktHdr,skb,rg_db.systemGlobal.tpid,svlanContent,0x8100,vlanContent);
			}else if(pPktHdr->egressServiceVlanTagif==0x2/*tag with 0x8100*/){
				_vlan_modify_doubleTag(pPktHdr,skb,0x8100,svlanContent,0x8100,vlanContent);
			}
#endif
		}
	}
}

void _rtk_rg_vlanTag2SkbBuffer_wifiFF(struct sk_buff *skb, rtk_rg_lookupIdxReturn_t mbssid_idx)
{
	uint16 vlanContent;
	rtk_rg_pkthdr_tagif_t tagif=0;
	u8 *pData=skb->data;
	int off=(ETHER_ADDR_LEN<<1);
	uint8	ctagPri=0;
	uint8	ctagCfi=0;
	uint16	ctagVid=0;
	uint8 egressVlanTagif=0;

	//20161221LUKE: check forceWifiUntag setting for removing cvlan tag forcely
	if(rg_db.systemGlobal.initParam.macBasedTagDecision){
		//do dmac2cvid by mbssid table.
		egressVlanTagif=rg_db.wlanMbssid[mbssid_idx].vlan_tag_if;
		TRACE("DMAC2CVID by mbssid table(tagif=%d, VID=%d)",egressVlanTagif,ctagVid);
	}else if(rg_db.systemGlobal.forceWifiUntag){
		//FIXME: this may encounter problem when using WWAN.
		TRACE("ForceWifiUntag");
	}else{
		//if forceWifiUntag and macBasedTagDecision is off, we should keep original cvlan format.
		return;
	}

	//simple parsing
	if((*(u16*)(pData+off))==htons(0x8100))//CTAG
	{
		tagif|=CVLAN_TAGIF;
		ctagVid=((pData[off+2]&0xf)<<8)|(pData[off+3]);
		ctagPri=pData[off+2]>>5;
		ctagCfi=(pData[off+2]>>4)&1;
	}

	if(egressVlanTagif==0)
		ctagVid=0;
	else
		ctagVid=rg_db.wlanMbssid[mbssid_idx].vid;

	//ingress untag
	if((tagif & CVLAN_TAGIF)==0x0){
		if(egressVlanTagif==0x0){ //untag => untag
			TRACE("VLAN decision: (in)untag => (out)untag");
			// no need to change
		}
		else if(egressVlanTagif==0x1){ //untag => ctag
			TRACE("VLAN decision: (in)untag => (out)ctag[VID:%d]",ctagVid);
			vlanContent = (((ctagPri&0x7)<<13)|((ctagCfi&0x1)<<12)|(ctagVid&0xfff));
			_vlan_insert_tag(NULL,skb,1,0x8100,vlanContent,0,0x0,0x0);
		}
	}

	//ingress with Ctag only
	else{
		if(egressVlanTagif==0x0){ //ctag => untag
			TRACE("VLAN decision: (in)ctag => (out)untag");
			_vlan_remove_tag(NULL,skb,0x8100);
			skb->protocol=(*(u16*)(pData+off));//when we remove the vlan tag, we should recover skb->protocol from etherType
		}
		else if(egressVlanTagif==0x1){ //ctag => ctag
			TRACE("VLAN decision: (in)ctag => (out)ctag[VID:%d]",ctagVid);
			vlanContent = (((ctagPri&0x7)<<13)|((ctagCfi&0x1)<<12)|(ctagVid&0xfff));
			_vlan_modify_tag(NULL, skb, 0x8100, 0x8100, vlanContent);
		}
	}
}

/*
* Tranlate pPktHdr->(final cvlan/svlan decition) into tx_desc or pktbuff.
*/
__IRAM_FWDENG
int _rtk_rg_TranslateVlanSvlan2Packet(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr, uint32 dataPathToWifi)
{
	//20140721LUKE: check for dmac2cvid or not!!
	if(pPktHdr->dmac2VlanID!=FAIL)
	{
		DEBUG("rg_db.systemGlobal.dmac2cvidDisabledPortmask=0x%x, egressMacPort[%d]",rg_db.systemGlobal.dmac2cvidDisabledPortmask, pPktHdr->egressMacPort);
		if(!(rg_db.systemGlobal.dmac2cvidDisabledPortmask & (1<<pPktHdr->egressMacPort))
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			|| (pPktHdr->fwdDecision==RG_FWD_DECISION_BRIDGING && pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)
#endif
			)
		{
			TRACE("DMAC2CVID decision: egressVlan=>%d, egressTagif=>%s",pPktHdr->dmac2VlanID,pPktHdr->dmac2VlanTagif==1?"TAG":"UNTAG");
			pPktHdr->egressVlanID=pPktHdr->dmac2VlanID;
			pPktHdr->egressVlanTagif=pPktHdr->dmac2VlanTagif;
		}
		else	//force diabled PON DAMC2CVID
		{
			TRACE("rg_db.systemGlobal.dmac2cvidDisabledPortmask=0x%x, force disbled DAMC2CVID to port[%d]!",rg_db.systemGlobal.dmac2cvidDisabledPortmask, pPktHdr->egressMacPort);
		}
	}

	/* do Stag/Ctag final Tx decision, by tx_desc or modify pktbuff*/
	if(pPktHdr->shortcutStatus!=RG_SC_MATCH)
		_rtk_rg_get_stagCtagAccelerationType(pPktHdr,dataPathToWifi);

#if defined(CONFIG_APOLLO_FPGA_PHY_TEST) || defined(CONFIG_RTL9607C_TEST_CHIP)
	pPktHdr->egressTagAccType = RG_FWDENGINE_ACL_ACC_TYPE_TX_PKTBUFF;
#endif

	if(pPktHdr->egressTagAccType==RG_FWDENGINE_ACL_ACC_TYPE_TX_DESC){
		//cvlan
		if(pPktHdr->egressVlanTagif==1){//Tag
			rg_kernel.txDesc.tx_tx_cvlan_action=0x3;//remarking
			rg_kernel.txDesc.tx_cvlan_vidl=(pPktHdr->egressVlanID&0xff);
			rg_kernel.txDesc.tx_cvlan_vidh=((pPktHdr->egressVlanID&0xf00)>>8);
			rg_kernel.txDesc.tx_cvlan_prio=pPktHdr->egressPriority;
			rg_kernel.txDesc.tx_cvlan_cfi=pPktHdr->egressVlanCfi;

		}else{//Untag
			rg_kernel.txDesc.tx_tx_cvlan_action=0x2;//remove ctag
		}
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
#else	// gmac support stag offload
		//svlan
		if(pPktHdr->egressServiceVlanTagif){//Tag
			rg_kernel.txDesc.tx_tx_svlan_action=0x3;//remarking
			rg_kernel.txDesc.tx_svlan_vidl=(pPktHdr->egressServiceVlanID&0xff);
			rg_kernel.txDesc.tx_svlan_vidh=((pPktHdr->egressServiceVlanID&0xf00)>>8);
			rg_kernel.txDesc.tx_svlan_prio=pPktHdr->egressServicePriority;
			rg_kernel.txDesc.tx_svlan_cfi=pPktHdr->egressServiceVlanDei;
			//tpid
			if(pPktHdr->egressServiceVlanTagif==1)
				rg_kernel.txDesc.tx_tpid_sel=0;
			else if(pPktHdr->egressServiceVlanTagif==2)
				rg_kernel.txDesc.tx_tpid_sel=1;
			else if(pPktHdr->egressServiceVlanTagif==3)
			{
				if(rg_db.systemGlobal.tpid2_en && pPktHdr->stagTpid==rg_db.systemGlobal.tpid2)
					rg_kernel.txDesc.tx_tpid_sel=1;
				else
					rg_kernel.txDesc.tx_tpid_sel=0;
			}
		}else{//Untag
			rg_kernel.txDesc.tx_tx_svlan_action=0x2;//remove stag
		}
#endif
	}else	{
		_rtk_rg_vlanSvlanTag2SkbBuffer(skb, pPktHdr);
	}

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
#else	// gmac support stag offload
	rg_kernel.txDesc.tx_stag_aware=0x1;
#endif


#if 0

	if(rg_kernel.debug_level&RTK_RG_DEBUG_LEVEL_TRACE_DUMP){
		if(pPktHdr->egressVlanTagif==1 &&
			pPktHdr->egressVlanID==CONFIG_DEFAULT_TO_SLAVE_GMAC_VID &&
			pPktHdr->egressPriority==CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI){
				//FIXEME: Test by dump_packet
				dump_packet(skb->data,64,"wifi slave packet:");
		}else if(dataPathFormWifi==1){
				//FIXEME: Test by dump_packet
				dump_packet(skb->data,64,"wifi master packet:");
		}else{
			//FIXEME: Test by dump_packet
			dump_packet(skb->data,64,"HW packet:");
		}
	}
#endif

	return RT_ERR_RG_OK;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_ipv6BindingDecision(rtk_rg_pktHdr_t *pPktHdr)
{
	int wanGroupIdx,wanTypeIdx;
	rtk_rg_fwdEngineReturn_t ret=RG_FWDENGINE_RET_CONTINUE;
	rtk_l34_bindAct_t bindAction=L34_BIND_ACT_END;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(pPktHdr->aclPolicyRoute==FAIL && _rtk_rg_bindingRuleCheck(pPktHdr,&wanGroupIdx)==RG_FWDENGINE_RET_HIT_BINDING)
#else
	if(_rtk_rg_bindingRuleCheck(pPktHdr,&wanGroupIdx)==RG_FWDENGINE_RET_HIT_BINDING)
#endif
	{
		pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index;
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.bind_wan_type_ipv6>=0)
			wanTypeIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.bind_wan_type_ipv6;
		else
			wanTypeIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.bind_wan_type_ipv4;
		pPktHdr->bindNextHopIdx=rg_db.wantype[wanTypeIdx].rtk_wantype.nhIdx; //nextHopIdx for pPktHdr->bindNextHopIdx
		switch(rg_db.wantype[wanTypeIdx].rtk_wantype.wanType)
		{
			case L34_WAN_TYPE_L2_BRIDGE:	//unmatch: follow hw register setting
				TRACE("Unmatch for L3 binding to L2 WAN...");
				bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L3L2];
				break;
			case L34_WAN_TYPE_L3_ROUTE:
				TRACE("Unmatch for L3 binding to L3 WAN...nhidx = %d",rg_db.wantype[wanTypeIdx].rtk_wantype.nhIdx);
				//20140717LUKE: this is special case, though we are binding from L3 to L3, we can have option to trap such packet.
				bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L3L3];
				break;
			case L34_WAN_TYPE_L34NAT_ROUTE:	//unmatch: drop!!
				TRACE("Unmatch for L3 binding to L34 WAN...DROP!!");
				//FIXME: if one binding rule contain v4 and v6, and v4 is set to NAPT, then v6 will go here...forced drop!
				bindAction=L34_BIND_ACT_DROP;//rg_db.systemGlobal.l34BindAction[L34_BIND_UNMATCHED_L3L34];
				break;
			case L34_WAN_TYPE_L34_CUSTOMIZED:	//unmatch: follow hw register setting
				TRACE("Unmatch for L3 binding to customized WAN...");
				bindAction=rg_db.systemGlobal.l34BindAction[L34_BIND_CUSTOMIZED_L3];
				break;
			default:
				break;
		}

		//if unmatch, do action!!
		ret=_rtk_rg_unmatchBindingAct(pPktHdr,bindAction,NULL);
	}

	return ret;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_ipv6L34Forward(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	int i,ret=0;
	int8 gatewayIP = -1;
	//int8 compareBit;
	uint8 nb_hash_idx;
	//uint16 index;
	//uint16 max;
	uint16 res;
	uint16 matchNeighbor;
	rtk_rg_naptDirection_t toWANIntf=IPV6_ROUTE_OUTBOUND;
	rtk_ipv6_addr_t unspecidiedIP={{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};
	rtk_l34_nexthop_entry_t *nexthopEntry;
	rtk_ipv6Routing_entry_t *entry;
	rtk_rg_neighborEntry_t *neighbor;
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	rtk_rg_ipv6_layer4_linkList_t *pIPv6ConnList;
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	rtk_rg_ipClassification_t sipClass,dipClass;
	rtk_rg_sipDipClassification_t sipDipClass;
#endif
#endif
	TRACE("IPv6 L34 Forward");

	//Trap IPv6 Routing Link Local to protocal stack.
	if(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK){
		if(pPktHdr->pIpv6Dip[0]==0xfe && pPktHdr->pIpv6Dip[1]==0x80){
			TRACE("[To PS] IPv6 Routing to Link local address, Trap to PS!");
			return RG_FWDENGINE_RET_TO_PS;
		}else if(pPktHdr->tagif&V6TRAP_TAGIF){
			TRACE("[To PS] IPv6 Routing with Hop-by-hop, Trap to PS withou ACL!");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			return RG_FWDENGINE_RET_TO_PS;
		}else if(!memcmp(pPktHdr->pIpv6Sip,&unspecidiedIP,sizeof(rtk_ipv6_addr_t))){
			TRACE("[Drop] IPv6 Routing with unspecified address, Drop!");
			return RG_FWDENGINE_RET_DROP;
		}
	}

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT
	sipClass=_rtk_rg_ipv6_sip_classification(pPktHdr->pIpv6Sip,pPktHdr);
	dipClass=_rtk_rg_ipv6_dip_classification(pPktHdr->pIpv6Dip,pPktHdr);
	sipDipClass=rg_db.systemGlobal.sipDipClass[sipClass][dipClass];
	TRACE("sipClass=%d, dipClass=%d, sipDipClass=%d",sipClass,dipClass,sipDipClass);
	if(sipDipClass==SIP_DIP_CLASS_NAPT){
		pPktHdr->fwdDecision=RG_FWD_DECISION_V6NAPT;
		if(pPktHdr->tagif&ESP_TAGIF)
		{
			TRACE("[To PS] IPv6 ESP with NAPT, Trap to PS withou ACL!");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			return RG_FWDENGINE_RET_TO_PS;
		}
		if(pPktHdr->tagif&UNKNOWN_L4_TAGIF)
		{
			TRACE("[To PS] IPv6 NAPT with unknown L4 header, Trap to PS!");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			return RG_FWDENGINE_RET_TO_PS;
		}
	}else if(sipDipClass==SIP_DIP_CLASS_NAPTR){
		pPktHdr->fwdDecision=RG_FWD_DECISION_V6NAPTR;
		if(pPktHdr->tagif&ESP_TAGIF)
		{
			TRACE("[To PS] IPv6 ESP with NAPTR, Trap to PS withou ACL!");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			return RG_FWDENGINE_RET_TO_PS;
		}
		if(pPktHdr->tagif&UNKNOWN_L4_TAGIF)
		{
			TRACE("[To PS] IPv6 NAPTR with unknown L4 header, Trap to PS!");
			pPktHdr->byPassToPsVlanAclDecision = 1;
			return RG_FWDENGINE_RET_TO_PS;
		}
	}else{
		pPktHdr->fwdDecision=RG_FWD_DECISION_V6ROUTING;
	}
#endif

	//Check if hop limit reach
	if((pPktHdr->pIPv6HopLimit==NULL)||(pPktHdr->pIPv6HopLimit!=NULL && *pPktHdr->pIPv6HopLimit<=1))
	{
		TRACE("[To PS] IPV6: Hop limit reach, trap to PS!");
		return RG_FWDENGINE_RET_TO_PS;
	}

	//check ingress PPPoE
#if defined(CONFIG_RG_RTL9602C_SERIES) || defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(pPktHdr->tagif&PPPOE_TAGIF)
#else
	if((pPktHdr->tagif&PPPOE_TAGIF) && (rg_db.systemGlobal.l34GlobalState[L34_GLOBAL_PPPKEEP_STATE]==DISABLED))
#endif
	{
		for (i=0;i<MAX_PPPOE_SW_TABLE_SIZE;i++)
		{
			if(pPktHdr->sessionId == rg_db.pppoe[i].rtk_pppoe.sessionID)
				break;
		}
		if (i==MAX_PPPOE_SW_TABLE_SIZE)	//unmatch, trap
		{
			TRACE("[To PS] IPV6: PPPoE ID lookup miss, trap to PS!");
			return RG_FWDENGINE_RET_TO_PS;
		}
	}


	//learning neighbor for syn packet or ICMPv6 packet
	pPktHdr->sipL3Idx=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Sip);
	if(((pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->tcpFlags.syn==1))||(pPktHdr->tagif&ICMPV6_TAGIF))
		_rtk_rg_v6NeighborAutoLearned(pPktHdr);

#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT //Seperate for pPktHdr->fwdDecision is NAPT/NAPTR case

	//learning neighbor for NA packet in NAPT, NAPTR mode
	if(pPktHdr->ICMPv6Type==0x88 &&(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT || pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR)){
		pPktHdr->dipL3Idx=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
		if(pPktHdr->dipL3Idx>=0){
			//make sure DA is to gwteway IP
			if(memcmp(pPktHdr->pIpv6Dip,rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.ipv6Addr.ipv6_addr,IPV6_ADDR_LEN)==0){
				DEBUG("NA packet DA=gatewayIP, dipL3Idx=%d",pPktHdr->dipL3Idx);
				_rtk_rg_neighborAgent(skb,pPktHdr);
				TRACE("[To PS] IPv6: either packet-to-gateway or neighbor advertisement, to PS!");
				return RG_FWDENGINE_RET_TO_PS;
			}
		}
	}

	if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPT){

			pPktHdr->dipL3Idx=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);

			if(pPktHdr->dipL3Idx>=0)
			{
				TRACE("IPv6(NAPT): routing table lookup, Hit Routing[%d]",pPktHdr->dipL3Idx);
			}

			if (pPktHdr->dipL3Idx == -1)
			{
				//no entry matched, Trap
				TRACE("IPv6: routing table lookup failed, to PS!");
			}
			else
			{
				//20150731LUKE:if we are routing with link-local address, drop it!
				if(pPktHdr->pIpv6Sip[0]==0xfe && pPktHdr->pIpv6Sip[1]==0x80){
					TRACE("[To PS] IPv6 Routing with Link local address, Trap!");
					return RG_FWDENGINE_RET_TO_PS;
				}
				//hit! check process column
				switch (rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.type)
				{
					case L34_IPV6_ROUTE_TYPE_DROP:
						//sprintf(msg,"After bindForward, Drop!");
						TRACE("[Drop] IPv6: Drop by routing table!");
						return RG_FWDENGINE_RET_DROP;
					case L34_IPV6_ROUTE_TYPE_TRAP:
						//sprintf(msg,"After bindForward, trap to CPU!");
						TRACE("[To PS] IPv6: Trap to PS by routing table!");
						return RG_FWDENGINE_RET_TO_PS;
					case L34_IPV6_ROUTE_TYPE_GLOBAL:
					{
						/* Read NextHop */
						TRACE("IPv6: Global routing..%s",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf?"rt2WAN":"rt2LAN");
						//since the entry should be the one we matched when we left the loop,
						//there is no need to get it out once again!
						entry=&rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route;
						/* Read NextHop (Routing) */
						pPktHdr->nexthopIdx=entry->nhOrIfidIdx;
						nexthopEntry=&rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop;
						pPktHdr->dmacL2Idx=nexthopEntry->nhIdx;
						pPktHdr->netifIdx=nexthopEntry->ifIdx;
						pPktHdr->extipIdx=pPktHdr->netifIdx;

						//20150310LUKE: Check MTU, if over, just return to protocol stack since we can't split here
						if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)
						{
							pPktHdr->overMTU=1;
							TRACE("[To PS] v6Packet L3 size(%d) is bigger than interface[%d]'s MTU(%d)",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu);
							return RG_FWDENGINE_RET_TO_PS;
						}
						//DEBUG("pPktHdr->dipL3Idx=%d",pPktHdr->dipL3Idx);
						//DEBUG("pPktHdr->nexthopIdx=%d",pPktHdr->nexthopIdx);
						//DEBUG("pPktHdr->netifIdx=%d",pPktHdr->netifIdx);
						//DEBUG("pPktHdr->extipIdx=%d",pPktHdr->extipIdx);
						//DEBUG("pPktHdr->dmacL2Idx=%d",pPktHdr->dmacL2Idx);

						if(entry->rt2waninf)
						{
							toWANIntf=NAPT_DIRECTION_OUTBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,nexthopEntry->type,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=nexthopEntry->type;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
						}
						else
						{
							TRACE("[Drop] NAPT, but hit Routing[%d]! The routing should not to Lan! Drop!!!",pPktHdr->dipL3Idx);
							return RG_FWDENGINE_RET_DROP;
						}

						ret = _rtk_rg_fwdEngine_ipv6PacketModify(toWANIntf,nexthopEntry->type,pPktHdr,skb);
						if(ret!=RG_FWDENGINE_RET_CONTINUE)
							return ret; 	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP

						return RG_FWDENGINE_RET_DIRECT_TX;
					}

					case L34_IPV6_ROUTE_TYPE_LOCAL:
					{
						TRACE("IPv6: Local routing..%s",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf?"rt2WAN":"rt2LAN");
						//lookup for neighbor table
						res = 0;
						nb_hash_idx = _rtk_rg_IPv6NeighborHash(pPktHdr->pIpv6Dip+8, (uint8)pPktHdr->dipL3Idx);

						for(i=0;i<MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE;i++)
						{
							matchNeighbor = (nb_hash_idx<<MAX_IPV6_NEIGHBOR_HASH_WAY_SHIFT)+i;
							//TRACE("the matchNeighbor idx = %d\n",matchNeighbor);
							//ASSERT_EQ(dal_apollomp_l34_ipv6NeighborTable_get(matchNeighbor, &neighbor), RT_ERR_OK);
							neighbor = &rg_db.v6neighbor[matchNeighbor].neighborEntry;
							//TRACE("the neighbor.ipv6RouteIdx = %d, matchEntry = %d\n",neighbor->ipv6RouteIdx,matchEntry);
							if(neighbor->valid &&
								(neighbor->matchRouteIdx == pPktHdr->dipL3Idx)&&
								_rtk_rg_ipv6IFIDCompare(rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.ipv6PrefixLen,pPktHdr->pIpv6Dip,neighbor->interfaceId))
							{
								//rtlglue_printf("HIT!!!!!\n");
								TRACE("IPv6: Hit neighbor table!L2IDX = %d rt=%d",neighbor->l2Idx,pPktHdr->dipL3Idx);
								rg_db.v6neighbor[matchNeighbor].idleSecs=0;
								res = 1;
								break;
							}
						}

						if (res == 0)
						{
							//20181220LUKE: if not hit, trap to cpu if rg_db.systemGlobal.trapICMPWhenNeighMiss
							if((pPktHdr->tagif&ICMPV6_TAGIF) && rg_db.systemGlobal.trapICMPWhenNeighMiss)
							{
								TRACE("[To PS] IPv6: Neighbor table un-hit for ICMPv6, TRAP!");
								return RG_FWDENGINE_RET_TO_PS;
							}
							TRACE("[Drop] IPv6: Neighbor table un-hit, DROP!");
							_rtk_rg_fwdengine_handleNeighborMiss(pPktHdr);
							return RG_FWDENGINE_RET_DROP;
						}

						entry=&rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route;

						pPktHdr->dmacL2Idx=neighbor->l2Idx;
						pPktHdr->netifIdx=entry->nhOrIfidIdx&0x7;
						pPktHdr->extipIdx=pPktHdr->netifIdx;

						//20150310LUKE: Check MTU, if over, just return to protocol stack since we can't split here
						if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)
						{
							pPktHdr->overMTU=1;
							TRACE("[To PS] v6Packet L3 size(%d) is bigger than interface[%d]'s MTU(%d)",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu);
							return RG_FWDENGINE_RET_TO_PS;
						}
						//DEBUG("pPktHdr->dipL3Idx=%d",pPktHdr->dipL3Idx);
						//DEBUG("pPktHdr->netifIdx=%d",pPktHdr->netifIdx);
						//DEBUG("pPktHdr->extipIdx=%d",pPktHdr->extipIdx);
						//DEBUG("pPktHdr->dmacL2Idx=%d",pPktHdr->dmacL2Idx);

						if(entry->rt2waninf==1)
						{
							toWANIntf=NAPT_DIRECTION_OUTBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,L34_NH_ETHER,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=L34_NH_ETHER;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
						}
						else
						{
							TRACE("[Drop] NAPT, but hit Routing[%d]! The routing should not to Lan! Drop!!!",pPktHdr->dipL3Idx);
							return RG_FWDENGINE_RET_DROP;
						}
						ret = _rtk_rg_fwdEngine_ipv6PacketModify(toWANIntf,L34_NH_ETHER,pPktHdr,skb);
						if(ret!=RG_FWDENGINE_RET_CONTINUE)
							return ret; 	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP

						return RG_FWDENGINE_RET_DIRECT_TX;
					}
					default:
						//we should not get here
						assert_ok(0);
						break;

				}

			}


	}else if(pPktHdr->fwdDecision==RG_FWD_DECISION_V6NAPTR){

			int32 hashIndex=-1, isTcp=0;
			rtk_rg_ipv6_layer4_linkList_t *pIPv6InboundList=NULL;
			rtk_ipv6_addr_t transIP;
			uint16 transPort;

			if(pPktHdr->tagif&TCP_TAGIF)
				isTcp=1;
			else
				isTcp=0;

			//search for the pIPv6InboundList
			_rtk_rg_fwdEngine_ipv6ConnList_lookup(&pIPv6InboundList,&hashIndex,pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,pPktHdr->sport,pPktHdr->dport,isTcp,0);

			if(pIPv6InboundList==NULL)
			{
				//not found inbound connList, check upnp, virtual server,dmz
				//initial with original sip, sport
				memcpy(transIP.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN);
				transPort = pPktHdr->dport;
				ret = _rtk_rg_fwdEngine_ipv6ConnType_lookup(pPktHdr, &transIP, &transPort);
				if(ret == RG_FWDENGINE_RET_CONTINUE){
					//DMZ or Virtual Server or Upnp hit.
					TRACE("Server in Lan check success... start to fill connList!");
				}else{
					TRACE("[Drop] Does not hit GatewayServicePort(UPNP/DMZ/Virtual server)...DROP");
					return RG_FWDENGINE_RET_DROP;
				}

			}else{
				//found inbound connList
				pPktHdr->ipv6StatefulHashValue = hashIndex;
				pPktHdr->pIPv6StatefulList = pIPv6InboundList;
				TRACE("Found inbound pIPv6InboundList[%d] %p",pPktHdr->ipv6StatefulHashValue,pPktHdr->pIPv6StatefulList);

				//get routing entry of lan IP
				memcpy(transIP.ipv6_addr,pIPv6InboundList->internalIP.ipv6_addr,IPV6_ADDR_LEN);
			}

			DEBUG("transIP is %02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x",
				transIP.ipv6_addr[0],transIP.ipv6_addr[1],transIP.ipv6_addr[2],transIP.ipv6_addr[3],
				transIP.ipv6_addr[4],transIP.ipv6_addr[5],transIP.ipv6_addr[6],transIP.ipv6_addr[7],
				transIP.ipv6_addr[8],transIP.ipv6_addr[9],transIP.ipv6_addr[10],transIP.ipv6_addr[11],
				transIP.ipv6_addr[12],transIP.ipv6_addr[13],transIP.ipv6_addr[14],transIP.ipv6_addr[15]);


			pPktHdr->dipL3Idx=_rtk_rg_v6L3lookup(transIP.ipv6_addr);
			TRACE("v6L3lookup dipL3Idx=%d",pPktHdr->dipL3Idx);

			if(pPktHdr->dipL3Idx>=0)
			{
				TRACE("IPv6(NAPT): routing table lookup, Hit Routing[%d]",pPktHdr->dipL3Idx);
			}

			if (pPktHdr->dipL3Idx == -1)
			{
				//no entry matched, Trap
				TRACE("[To PS] IPv6: routing table lookup failed, to PS!");
				return RG_FWDENGINE_RET_TO_PS;
			}
			else
			{
				//20150731LUKE:if we are routing with link-local address, drop it!
				if(pPktHdr->pIpv6Sip[0]==0xfe && pPktHdr->pIpv6Sip[1]==0x80){
					TRACE("[To PS] IPv6 Routing with Link local address, Trap!");
					return RG_FWDENGINE_RET_TO_PS;
				}
				//hit! check process column
				switch (rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.type)
				{
					case L34_IPV6_ROUTE_TYPE_DROP:
						//sprintf(msg,"After bindForward, Drop!");
						TRACE("[Drop] IPv6: Drop by routing table!");
						return RG_FWDENGINE_RET_DROP;
					case L34_IPV6_ROUTE_TYPE_TRAP:
						//sprintf(msg,"After bindForward, trap to CPU!");
						TRACE("[To PS] IPv6: Trap to PS by routing table!");
						return RG_FWDENGINE_RET_TO_PS;
					case L34_IPV6_ROUTE_TYPE_GLOBAL:
					{
						/* Read NextHop */
						TRACE("IPv6: Global routing..%s",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf?"rt2WAN":"rt2LAN");
						//since the entry should be the one we matched when we left the loop,
						//there is no need to get it out once again!
						entry=&rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route;
						/* Read NextHop (Routing) */
						pPktHdr->nexthopIdx=entry->nhOrIfidIdx;
						nexthopEntry=&rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop;
						pPktHdr->dmacL2Idx=nexthopEntry->nhIdx;
						pPktHdr->netifIdx=nexthopEntry->ifIdx;

						//20150310LUKE: Check MTU, if over, just return to protocol stack since we can't split here
						if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)
						{
							pPktHdr->overMTU=1;
							TRACE("[To PS] v6Packet L3 size(%d) is bigger than interface[%d]'s MTU(%d)",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu);
							return RG_FWDENGINE_RET_TO_PS;
						}
						if(entry->rt2waninf)
						{
							TRACE("[Drop] NAPTR, but hit Routing[%d]! The routing should not to Wan! Drop!!!",pPktHdr->dipL3Idx);
							return RG_FWDENGINE_RET_DROP;
						}
						else
						{
							toWANIntf=NAPT_DIRECTION_INBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,nexthopEntry->type,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=nexthopEntry->type;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
						}
						ret = _rtk_rg_fwdEngine_ipv6PacketModify(toWANIntf,nexthopEntry->type,pPktHdr,skb);
						if(ret!=RG_FWDENGINE_RET_CONTINUE)
							return ret; 	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP

						return RG_FWDENGINE_RET_DIRECT_TX;
					}
					case L34_IPV6_ROUTE_TYPE_LOCAL:
					{
						TRACE("IPv6: Local routing..%s",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf?"rt2WAN":"rt2LAN");
						//lookup for neighbor table
						res = 0;
						nb_hash_idx = _rtk_rg_IPv6NeighborHash(transIP.ipv6_addr+8, (uint8)pPktHdr->dipL3Idx);
						DEBUG("nb_hash_idx=%d pPktHdr->dipL3Idx=%d internalIP[64:128](%02x%02x:%02x%02x:%02x%02x:%02x%02x)",
							nb_hash_idx,pPktHdr->dipL3Idx,
							transIP.ipv6_addr[8],transIP.ipv6_addr[9],transIP.ipv6_addr[10],transIP.ipv6_addr[11],
							transIP.ipv6_addr[12],transIP.ipv6_addr[13],transIP.ipv6_addr[14],transIP.ipv6_addr[15]);

						for(i=0;i<MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE;i++)
						{
							matchNeighbor = (nb_hash_idx<<MAX_IPV6_NEIGHBOR_HASH_WAY_SHIFT)+i;
							//TRACE("the matchNeighbor idx = %d\n",matchNeighbor);
							//ASSERT_EQ(dal_apollomp_l34_ipv6NeighborTable_get(matchNeighbor, &neighbor), RT_ERR_OK);
							neighbor = &rg_db.v6neighbor[matchNeighbor].neighborEntry;
							//TRACE("the neighbor.ipv6RouteIdx = %d, matchEntry = %d\n",neighbor->ipv6RouteIdx,matchEntry);
							if(neighbor->valid &&
								(neighbor->matchRouteIdx == pPktHdr->dipL3Idx)&&
								_rtk_rg_ipv6IFIDCompare(rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.ipv6PrefixLen,transIP.ipv6_addr,neighbor->interfaceId))
							{
								//rtlglue_printf("HIT!!!!!\n");
								TRACE("IPv6: Hit neighbor table!L2IDX = %d rt=%d",neighbor->l2Idx,pPktHdr->dipL3Idx);
								rg_db.v6neighbor[matchNeighbor].idleSecs=0;
								res = 1;
								break;
							}
						}

						if (res == 0)
						{
							//20181220LUKE: if not hit, trap to cpu if rg_db.systemGlobal.trapICMPWhenNeighMiss
							if((pPktHdr->tagif&ICMPV6_TAGIF) && rg_db.systemGlobal.trapICMPWhenNeighMiss)
							{
								TRACE("[To PS] IPv6: Neighbor table un-hit for ICMPv6, TRAP!");
								return RG_FWDENGINE_RET_TO_PS;
							}
							TRACE("[Drop] IPv6: Neighbor table un-hit, DROP!");
							_rtk_rg_fwdengine_handleNeighborMiss(pPktHdr);
							return RG_FWDENGINE_RET_DROP;
						}

						entry=&rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route;

						pPktHdr->dmacL2Idx=neighbor->l2Idx;
						pPktHdr->netifIdx=entry->nhOrIfidIdx&0x7;

						//20150310LUKE: Check MTU, if over, just return to protocol stack since we can't split here
						if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)
						{
							pPktHdr->overMTU=1;
							TRACE("[To PS] v6Packet L3 size(%d) is bigger than interface[%d]'s MTU(%d)",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu);
							return RG_FWDENGINE_RET_TO_PS;
						}
						//DEBUG("pPktHdr->dipL3Idx=%d",pPktHdr->dipL3Idx);
						//DEBUG("pPktHdr->netifIdx=%d",pPktHdr->netifIdx);
						//DEBUG("pPktHdr->extipIdx=%d",pPktHdr->extipIdx);
						//DEBUG("pPktHdr->dmacL2Idx=%d",pPktHdr->dmacL2Idx);

						if(entry->rt2waninf==1)
						{
							TRACE("[Drop] NAPTR, but hit Routing[%d]! The routing should not to Wan! Drop!!!",pPktHdr->dipL3Idx);
							return RG_FWDENGINE_RET_DROP;
						}
						else
						{
							toWANIntf=NAPT_DIRECTION_INBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,L34_NH_ETHER,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=L34_NH_ETHER;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
						}

						ret = _rtk_rg_fwdEngine_ipv6PacketModify(toWANIntf,L34_NH_ETHER,pPktHdr,skb);
						if(ret!=RG_FWDENGINE_RET_CONTINUE)
							return ret; 	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP

						return RG_FWDENGINE_RET_DIRECT_TX;
					}
					default:
						//we should not get here
						assert_ok(0);
						break;

				}

			}

	}else{//routing
#endif //End of : #ifdef CONFIG_RG_IPV6_NAPT_SUPPORT //Seperate for pPktHdr->fwdDecision is NAPT/NAPTR case

			pPktHdr->dipL3Idx=_rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
			if(pPktHdr->dipL3Idx>=0)
			{
				//Check gwteway IP
				if(memcmp(pPktHdr->pIpv6Dip,rg_db.v6route[pPktHdr->dipL3Idx].gateway_ipv6Addr.ipv6_addr,IPV6_ADDR_LEN)==0)
					gatewayIP=pPktHdr->dipL3Idx;
			}

			//either packet-to-gateway or neighbor advertisement
			if(gatewayIP != -1 || ((rg_db.pktHdr->tagif&ICMPV6_TAGIF)&&(pPktHdr->ICMPv6Type==0x88)))
			{
				DEBUG("gatewayIP idx=%d",gatewayIP);
				_rtk_rg_neighborAgent(skb,pPktHdr);
				TRACE("[To PS] IPv6: either packet-to-gateway or neighbor advertisement, to PS!");
				return RG_FWDENGINE_RET_TO_PS;
			}
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)
			//check NPTv6 for inbound packet
			_rtk_rg_NPTv6_inbound_check(pPktHdr);
			if(pPktHdr->isNPTv6==3)
			{
				TRACE("[To PS] Fail to do NPTv6...trap to PS.");
				return RG_FWDENGINE_RET_TO_PS;
			}
			else if(pPktHdr->isNPTv6==2)
				pPktHdr->dipL3Idx = _rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
#endif
			if (pPktHdr->dipL3Idx == -1 || pPktHdr->sipL3Idx == -1)
			{
				//no entry matched, Trap
				TRACE("[To PS] IPv6: routing table lookup failed, to PS!");
				return RG_FWDENGINE_RET_TO_PS;
			}
			else
			{
				pPktHdr->fwdDecision=RG_FWD_DECISION_V6ROUTING;

				//20150731LUKE:if we are routing with link-local address, trap it!
				if(pPktHdr->pIpv6Sip[0]==0xfe && pPktHdr->pIpv6Sip[1]==0x80){
					TRACE("[To PS] IPv6 Routing with Link local address, Trap!");
					return RG_FWDENGINE_RET_TO_PS;
				}

				//20190121LUKE: check packet from LAN should have legal routing entry index.
				if(((0x1<<pPktHdr->ingressPort)&rg_db.systemGlobal.wanPortMask.portmask)==0
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
					&& pPktHdr->wlan_dev_idx!=RG_RET_MBSSID_MASTER_CLIENT_INTF && pPktHdr->wlan_dev_idx!=RG_RET_MBSSID_SLAVE_CLIENT_INTF
#endif
					)
				{
					if(pPktHdr->sipL3Idx==V6_DEFAULT_ROUTE_IDX)
					{
						TRACE("[To PS] IPv6 source address from LAN is undetermined, Trap!");
						return RG_FWDENGINE_RET_TO_PS;
					}
				}

				//hit! check process column
				switch (rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.type)
				{
					case L34_IPV6_ROUTE_TYPE_DROP:
						//sprintf(msg,"After bindForward, Drop!");
						//FIXME: SW not support ipv6 force forwarding if policy route & binding dip lookup action is drop or trap.
						TRACE("[Drop] IPv6: Drop by routing table!");
						return RG_FWDENGINE_RET_DROP;
					case L34_IPV6_ROUTE_TYPE_TRAP:
						//sprintf(msg,"After bindForward, trap to CPU!");
						//FIXME: SW not support ipv6 force forwarding if policy route & binding dip lookup action is drop or trap.
						TRACE("[To PS] IPv6: Trap to PS by routing table!(check binding first if rt2wan!)");
#if defined(CONFIG_RG_RTL9600_SERIES)
#else
						//20171031LUKE: check binding before goto protocol stack.
						if(rg_db.systemGlobal.initParam.macBasedTagDecision && rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf)
						{
							_rtk_rg_ipv6BindingDecision(pPktHdr);
							if(pPktHdr->bindNextHopIdx!=FAIL)goto DO_BINDING;
						}
#endif
						return RG_FWDENGINE_RET_TO_PS;
					case L34_IPV6_ROUTE_TYPE_GLOBAL:
						/* Read NextHop */
						TRACE("IPv6: Global routing..%s",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf?"rt2WAN":"rt2LAN");
						//since the entry should be the one we matched when we left the loop,
						//there is no need to get it out once again!
						entry=&rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route;
						/* Read NextHop (Routing) */
						pPktHdr->nexthopIdx=entry->nhOrIfidIdx;
						nexthopEntry=&rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop;
						pPktHdr->dmacL2Idx=nexthopEntry->nhIdx;
						pPktHdr->netifIdx=nexthopEntry->ifIdx;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
						//1 Use Policy Route WAN intf instead interface route decision!!
						if( pPktHdr->aclPolicyRoute!=FAIL &&
							rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo!=NULL &&
							((rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo->ip_version==IPVER_V6ONLY) || (rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo->ip_version==IPVER_V4V6)))
						{
							TRACE("use WAN[%d] as policy route, and skip binding",pPktHdr->aclPolicyRoute);
							pPktHdr->netifIdx=pPktHdr->aclPolicyRoute;
							if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.nexthop_ipv6>=0) {
								pPktHdr->nexthopIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.nexthop_ipv6;
								nexthopEntry=&rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop;
								pPktHdr->dmacL2Idx=nexthopEntry->nhIdx;
								TRACE("update DMAC by policy route as next hop of WAN[%d]",pPktHdr->aclPolicyRoute);
							}
							else{
								TRACE("[To PS] Get IPv6 nexthop fail(%d)...trap!",rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.nexthop_ipv6);
								return RG_FWDENGINE_RET_TO_PS;
							}
						}
#endif

						//20150310LUKE: Check MTU, if over, just return to protocol stack since we can't split here
						if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)
						{
							pPktHdr->overMTU=1;
							TRACE("[To PS] v6Packet L3 size(%d) is bigger than interface[%d]'s MTU(%d)",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu);
							return RG_FWDENGINE_RET_TO_PS;
						}
						if(entry->rt2waninf)
						{
							//20140814LUKE: binding only activated when rt2WAN!!
							if(rg_db.systemGlobal.initParam.macBasedTagDecision)
							{
								ret=_rtk_rg_ipv6BindingDecision(pPktHdr);
								if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;

								if(pPktHdr->bindNextHopIdx!=FAIL)
								{
#if defined(CONFIG_RG_RTL9600_SERIES)
#else
DO_BINDING:
#endif
									/* Rome driver should make sure that binding->nexthop is equal to napt->nexthop. */
									pPktHdr->nexthopIdx=pPktHdr->bindNextHopIdx; //for Port/VLAN Bidning Route SMAC/DMAC
									nexthopEntry=&rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop;
#if defined(CONFIG_RG_RTL9600_SERIES)
									/* Special case: for binding but default route, DMAC decision should be from BD->WT->NH->L2 */
									if(pPktHdr->dipL3Idx==V6_DEFAULT_ROUTE_IDX)
#endif
										pPktHdr->dmacL2Idx=rg_db.nexthop[pPktHdr->nexthopIdx].rtk_nexthop.nhIdx; //for Port/VLAN Bidning Route DMAC
									TRACE("Binding to interface pPktHdr->netifIdx = %d",pPktHdr->netifIdx);
								}
							}	
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
							toWANIntf=IPV6_ROUTE_OUTBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,nexthopEntry->type,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=nexthopEntry->type;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
#endif
						}
						else
						{
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
							toWANIntf=IPV6_ROUTE_INBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,nexthopEntry->type,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=nexthopEntry->type;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
#endif
						}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT)
						ret = _rtk_rg_fwdEngine_L2L3_TcpUdpConnectionTracking(pPktHdr);
						if(pPktHdr->ipv6FragPacket)
						{
							ret = _rtk_rg_L2L3_fragmentHandler(pPktHdr, skb, ret);
						}
						if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
#else	// not CONFIG_RG_FLOW_BASED_PLATFORM
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
						if(pPktHdr->shortcutStatus!=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND)
#endif
						{
							//20160908LUKE: only TCP and UDP will add to shortcut.
							pPktHdr->shortcutStatus = (pPktHdr->tagif&(TCP_TAGIF|UDP_TAGIF)) ? RG_SC_NEED_UPDATE : RG_SC_NORMAL_PATH;
						}
#endif
						ret = _rtk_rg_fwdEngine_ipv6PacketModify(toWANIntf,nexthopEntry->type,pPktHdr,skb);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT)
						if(pPktHdr->L2L3FragListIdx!=FAIL && pPktHdr->ipv6MoreFragment && pPktHdr->ipv6FragmentOffset==0)
						{
							rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].fragAction = ret;
							assert_ok(_rtk_rg_L2L3_fragmentQueueProcessing(pPktHdr, rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].fragAction));
						}
#endif
						if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret; 	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP

						return RG_FWDENGINE_RET_DIRECT_TX;

					case L34_IPV6_ROUTE_TYPE_LOCAL:
						TRACE("IPv6: Local routing..%s",rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.rt2waninf?"rt2WAN":"rt2LAN");
						//lookup for neighbor table
						res = 0;
						nb_hash_idx = _rtk_rg_IPv6NeighborHash(pPktHdr->pIpv6Dip+8, (uint8)pPktHdr->dipL3Idx);

						for(i=0;i<MAX_IPV6_NEIGHBOR_HASH_WAY_SIZE;i++)
						{
							matchNeighbor = (nb_hash_idx<<MAX_IPV6_NEIGHBOR_HASH_WAY_SHIFT)+i;
							//TRACE("the matchNeighbor idx = %d\n",matchNeighbor);
							//ASSERT_EQ(dal_apollomp_l34_ipv6NeighborTable_get(matchNeighbor, &neighbor), RT_ERR_OK);
							neighbor = &rg_db.v6neighbor[matchNeighbor].neighborEntry;
							//TRACE("the neighbor.ipv6RouteIdx = %d, matchEntry = %d\n",neighbor->ipv6RouteIdx,matchEntry);
							if(neighbor->valid &&
								(neighbor->matchRouteIdx == pPktHdr->dipL3Idx)&&
								_rtk_rg_ipv6IFIDCompare(rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route.ipv6PrefixLen,pPktHdr->pIpv6Dip,neighbor->interfaceId))
							{
								//rtlglue_printf("HIT!!!!!\n");
								TRACE("IPv6: Hit neighbor table!L2IDX = %d rt=%d",neighbor->l2Idx,pPktHdr->dipL3Idx);
								rg_db.v6neighbor[matchNeighbor].idleSecs=0;
								res = 1;
								break;
							}
						}

						if (res == 0)
						{
							//20181220LUKE: if not hit, trap to cpu if rg_db.systemGlobal.trapICMPWhenNeighMiss
							if((pPktHdr->tagif&ICMPV6_TAGIF) && rg_db.systemGlobal.trapICMPWhenNeighMiss)
							{
								TRACE("[To PS] IPv6: Neighbor table un-hit for ICMPv6, TRAP!");
								return RG_FWDENGINE_RET_TO_PS;
							}
							TRACE("[Drop] IPv6: Neighbor table un-hit, DROP!");
							_rtk_rg_fwdengine_handleNeighborMiss(pPktHdr);
							return RG_FWDENGINE_RET_DROP;
						}

						entry=&rg_db.v6route[pPktHdr->dipL3Idx].rtk_v6route;

						pPktHdr->dmacL2Idx=neighbor->l2Idx;
						pPktHdr->netifIdx=entry->nhOrIfidIdx&0x7;

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
						//1 Use Policy Route WAN intf instead interface route decision!!
						if( pPktHdr->aclPolicyRoute!=FAIL &&
							rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo!=NULL &&
							((rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo->ip_version==IPVER_V6ONLY) || (rg_db.systemGlobal.interfaceInfo[pPktHdr->aclPolicyRoute].p_wanStaticInfo->ip_version==IPVER_V4V6)))
						{
							TRACE("use WAN[%d] as policy route, and skip binding",pPktHdr->aclPolicyRoute);
							pPktHdr->netifIdx=pPktHdr->aclPolicyRoute;
						}
#endif

						//20150310LUKE: Check MTU, if over, just return to protocol stack since we can't split here
						if(rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len)
						{
							pPktHdr->overMTU=1;
							TRACE("[To PS] v6Packet L3 size(%d) is bigger than interface[%d]'s MTU(%d)",pPktHdr->l3Len,pPktHdr->netifIdx,rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu);
							return RG_FWDENGINE_RET_TO_PS;
						}

						if(entry->rt2waninf==1)
						{
							//20140814LUKE: binding only activated when rt2WAN!!
							if(rg_db.systemGlobal.initParam.macBasedTagDecision)
							{
								ret=_rtk_rg_ipv6BindingDecision(pPktHdr);
								if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;

								if(pPktHdr->bindNextHopIdx!=FAIL)
								{
									/* Rome driver should make sure that binding->nexthop is equal to napt->nexthop. */
									pPktHdr->nexthopIdx=pPktHdr->bindNextHopIdx; //for Port/VLAN Bidning Route SMAC/DMAC

									TRACE("Binding to interface pPktHdr->netifIdx = %d",pPktHdr->netifIdx);
								}
							}
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
							toWANIntf=IPV6_ROUTE_OUTBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,L34_NH_ETHER,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPOutboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=L34_NH_ETHER;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
#endif
						}
						else
						{
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
							toWANIntf=IPV6_ROUTE_INBOUND;
							pIPv6ConnList=NULL;
							if(pPktHdr->tagif&V6FRAG_TAGIF)
							{
								return _rtk_rg_fwdEngine_v6FragmentHandling(toWANIntf,L34_NH_ETHER,&pIPv6ConnList,pPktHdr,skb);
							}
							else	//unfragment
							{
								//ipv6 stateful connection tracking, if outbound first time, fill software data structure
								//if inbound without outbound, drop it.
								ret=RG_FWDENGINE_RET_NAPT_OK;
								if(pPktHdr->tagif&TCP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6TCPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								else if(pPktHdr->tagif&UDP_TAGIF)
									ret=_rtk_rg_fwdEngine_ipv6UDPInboundConnectionTracking(&pIPv6ConnList,pPktHdr);
								if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
							}

							//update direction and wanType(ether or pppoe)
							if(pIPv6ConnList!=NULL)
							{
								pIPv6ConnList->direction=toWANIntf;
								pIPv6ConnList->wanType=L34_NH_ETHER;
								pPktHdr->pIPv6StatefulList=pIPv6ConnList;
								pPktHdr->shortcutStatus=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND;
								pPktHdr->pIPv6StatefulList->idleSecs=0;
							}
#endif
						}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT)
						ret = _rtk_rg_fwdEngine_L2L3_TcpUdpConnectionTracking(pPktHdr);
						if(pPktHdr->ipv6FragPacket)
						{
							ret = _rtk_rg_L2L3_fragmentHandler(pPktHdr, skb, ret);
						}
						if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
#else	// not CONFIG_RG_FLOW_BASED_PLATFORM
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
						if(pPktHdr->shortcutStatus!=RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND)
#endif
						{
							//20160908LUKE: only TCP and UDP will add to shortcut.
							pPktHdr->shortcutStatus = (pPktHdr->tagif&(TCP_TAGIF|UDP_TAGIF)) ? RG_SC_NEED_UPDATE : RG_SC_NORMAL_PATH;
						}
#endif
						ret = _rtk_rg_fwdEngine_ipv6PacketModify(toWANIntf,L34_NH_ETHER,pPktHdr,skb);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT)
						if(pPktHdr->L2L3FragListIdx!=FAIL && pPktHdr->ipv6MoreFragment && pPktHdr->ipv6FragmentOffset==0)
						{
							rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].fragAction = ret;
							assert_ok(_rtk_rg_L2L3_fragmentQueueProcessing(pPktHdr, rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].fragAction));
						}
#endif
						if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;	// RG_FWDENGINE_RET_TO_PS or RG_FWDENGINE_RET_DROP

						return RG_FWDENGINE_RET_DIRECT_TX;

					default:
						//we should not get here
						assert_ok(0);
						break;

				}

			}
#ifdef CONFIG_RG_IPV6_NAPT_SUPPORT //Seperate for pPktHdr->fwdDecision is NAPT/NAPTR case
	}//End of else{//routing
#endif
	TRACE("[To PS] classfication type is to PS");
	return RG_FWDENGINE_RET_TO_PS;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_ICMP_specialTypeProcess(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr, rtk_rg_naptDirection_t direction)
{
	rtk_rg_table_icmp_flow_t *icmpCtrlFlow=NULL;
	uint8 *ipHdr;
	uint8 *l4Hdr;
	uint8 protocol;
	uint32 sip, dip;
	uint32 *pSip, *pDip;
	uint16 sport=0, dport=0, ipChecksum=0, l4Checksum=0;
	uint16 *pSport=NULL, *pDport=NULL, *pIpChecksum=NULL, *pL4Checksum=NULL;

	DEBUG("pPktHdr->ICMPType=%d, direction=%d", pPktHdr->ICMPType, direction);
	if(!((pPktHdr->ICMPType==11 /*TTL Exceeded*/) || (pPktHdr->ICMPType==3 /*Destination unreachable*/)))
		return RG_FWDENGINE_RET_CONTINUE;
	if(!((direction==NAPT_DIRECTION_OUTBOUND) || (direction==NAPT_DIRECTION_INBOUND)))
		return RG_FWDENGINE_RET_CONTINUE;

	//must NAPTR by ICMP payload
	ipHdr=skb->data+pPktHdr->l4Offset+8;
	//memDump(ipHdr,skb->len-pPktHdr->l4Offset-8,"icmp");
	if((ipHdr[0]&0xf0)!=0x40)
	{
		if(pPktHdr->ICMPType==11)
		{
			TRACE("Unkown ICMP TTL exceeded payload(1)!");
		}
		else
		{
			TRACE("Unkown ICMP Destination unreachable payload(1)!");
		}
	}
	else
	{
		protocol=ipHdr[9];
		if(!((protocol==0x6)||(protocol==0x11)||(protocol==0x1))) //TCP,UDP,ICMP
		{
			if(pPktHdr->ICMPType==11)
			{
				TRACE("Unkown ICMP TTL exceeded payload(2)!");
			}
			else
			{
				TRACE("Unkown ICMP Destination unreachable payload(2)!");
			}
		}
		else
		{
			int naptOutIdx,naptInIdx;
			pSip=(uint32 *)&ipHdr[12];
			sip=ntohl(*pSip);
			pDip=(uint32 *)&ipHdr[16];
			dip=ntohl(*pDip);
			pIpChecksum=(uint16*)&ipHdr[10];
			ipChecksum=ntohs(*pIpChecksum);
			l4Hdr=&ipHdr[(ipHdr[0]&0xf)<<2];
			if(protocol==0x6 || protocol==0x11)
			{
				pSport=(uint16 *)&l4Hdr[0];
				sport=ntohs(*pSport);
				pDport=(uint16 *)&l4Hdr[2];
				dport=ntohs(*pDport);
				pL4Checksum=(protocol==0x6)?((uint16*)&l4Hdr[16]):((uint16*)&l4Hdr[6]);
				l4Checksum=ntohs(*pL4Checksum);
			}

			if(pPktHdr->ICMPType==11)
			{
				TRACE("ICMP TTL exceeded([%s] %s SIP=0x%x DIP=0x%x SPORT=%d DPORT=%d)",(direction==NAPT_DIRECTION_OUTBOUND)?"Outbound":"Inbound",(protocol==0x6)?"TCP":(protocol==0x11)?"UDP":"ICMP",sip,dip,sport,dport);
			}
			else
			{
				TRACE("ICMP Destination unreachable([%s] %s SIP=0x%x DIP=0x%x SPORT=%d DPORT=%d)",(direction==NAPT_DIRECTION_OUTBOUND)?"Outbound":"Inbound",(protocol==0x6)?"TCP":(protocol==0x11)?"UDP":"ICMP",sip,dip,sport,dport);
			}
			if(protocol==0x6 || protocol==0x11)
			{
				if(direction==NAPT_DIRECTION_OUTBOUND)
					naptOutIdx=_rtk_rg_naptTcpUdpOutHashIndexLookup((protocol==0x6)?1:0,dip,dport,sip,sport);
				else
					naptOutIdx=_rtk_rg_naptTcpUdpInHashIndexLookup((protocol==0x6)?1:0,dip,dport,sip,sport);
			}
			else
			{
				naptOutIdx = FAIL;
			}

			if(naptOutIdx>=0) //for linux trace route
			{
				rtk_rg_err_code_t rg_ret;
				naptInIdx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;

				if(direction==NAPT_DIRECTION_OUTBOUND)
				{
					*pPktHdr->pIpv4Sip=htonl(rg_db.extip[rg_db.naptIn[naptInIdx].rtk_naptIn.extIpIdx].rtk_extip.extIpAddr);
					*pDip=*pPktHdr->pIpv4Sip;
					*pDport=htons(rg_db.naptOut[naptOutIdx].extPort);
					TRACE("Forward to WAN from extIP(0x%x)/extPORT(0x%x), modify DIP/DPORT of ICMP payload.", ntohl(*pDip), ntohs(*pDport));

					*pIpChecksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pIpChecksum), dip, 0, protocol, ntohl(*pDip), 0));

					if(pPktHdr->ipv4FragPacket==0)
						*pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(0, ntohs(*pL4Checksum), dip, dport, 0, 0, ntohl(*pDip), ntohs(*pDport), 0, 0));

					//20181217LUKE: since payload changed, we should update ICMP checksum here for wifi client.
					*pPktHdr->pL4Checksum=htons(_rtk_rg_fwdengine_ICMPchecksumUpdate(ntohs(*pPktHdr->pL4Checksum), dip, dport, ipChecksum, l4Checksum, ntohl(*pDip), ntohs(*pDport), ntohs(*pIpChecksum), ntohs(*pL4Checksum)));
				}
				else // NAPT_DIRECTION_INBOUND
				{
					*pPktHdr->pIpv4Dip=htonl(rg_db.naptIn[naptInIdx].rtk_naptIn.intIp);
					*pSip=*pPktHdr->pIpv4Dip;
					*pSport=htons(rg_db.naptIn[naptInIdx].rtk_naptIn.intPort);
					TRACE("Forward to LAN IP(0x%x)/PORT(0x%x), modify SIP/SPORT of ICMP payload.", ntohl(*pSip), ntohs(*pSport));

					*pIpChecksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pIpChecksum), sip, 0, protocol, ntohl(*pSip), 0));

					if(pPktHdr->ipv4FragPacket==0)
						*pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(0, ntohs(*pL4Checksum), sip, sport, 0, 0, ntohl(*pSip), ntohs(*pSport), 0, 0));

					//20181217LUKE: since payload changed, we should update ICMP checksum here for wifi client.
					*pPktHdr->pL4Checksum=htons(_rtk_rg_fwdengine_ICMPchecksumUpdate(ntohs(*pPktHdr->pL4Checksum), sip, sport, ipChecksum, l4Checksum, ntohl(*pSip), ntohs(*pSport), ntohs(*pIpChecksum), ntohs(*pL4Checksum)));
				}

				rg_ret = _rtk_rg_fwdEngine_shortCutNaptPacketModify(direction,FAIL,pPktHdr,skb,0,0);
				if(rg_ret!=RT_ERR_RG_OK)
				{
					TRACE("[Drop] after packet modify");
					return RG_FWDENGINE_RET_DROP;
				}
				//20181217LUKE: enable l34 modify for wireless client to recalculate IP and L4 checksum.
				pPktHdr->l3Modify=1;
				return RG_FWDENGINE_RET_DIRECT_TX;
			}
			else //for windows trace route
			{
				if((direction==NAPT_DIRECTION_INBOUND)&&(pPktHdr->ICMPType==11)&&(protocol==0x1))
				{
					rtk_rg_err_code_t rg_ret;
					uint16 ICMPIdentifier=pPktHdr->ICMPIdentifier;
					uint16 ICMPSeqNum=pPktHdr->ICMPSeqNum;
					uint32 ipv4Sip=pPktHdr->ipv4Sip;

					//parsing inner tag for icmp lookup
					pPktHdr->ICMPIdentifier=ntohs(*(uint16*)&l4Hdr[4]);
					pPktHdr->ICMPSeqNum=ntohs(*(uint16*)&l4Hdr[6]);
					pPktHdr->ipv4Sip=ntohl(*(uint32*)(&ipHdr[16]));
					rg_ret = _rtk_rg_fwdEngine_ICMPInboundControlFlowTracking(pPktHdr, &icmpCtrlFlow);
					//recovery pkthdr
					pPktHdr->ICMPIdentifier=ICMPIdentifier;
					pPktHdr->ICMPSeqNum=ICMPSeqNum;
					pPktHdr->ipv4Sip=ipv4Sip;

					if(rg_ret==RT_ERR_RG_ENTRY_NOT_FOUND)
					{
						TRACE("[To PS] ICMPR lookup fail...return to PS");
						return RG_FWDENGINE_RET_TO_PS;
					}
					else if(rg_ret==RT_ERR_RG_TRAP_TO_PS)
					{
						return RG_FWDENGINE_RET_TO_PS;
					}

					*pPktHdr->pIpv4Dip=htonl(icmpCtrlFlow->internalIP);
					*pSip=*pPktHdr->pIpv4Dip;
					*pIpChecksum=htons(_rtk_rg_fwdengine_L3checksumUpdate(ntohs(*pIpChecksum), sip, 0, protocol, ntohl(*pSip), 0));

					//invalid this ctrl flow
					icmpCtrlFlow->valid=0;

					rg_ret = _rtk_rg_fwdEngine_shortCutNaptPacketModify(direction,FAIL,pPktHdr,skb,0,0);
					if(rg_ret!=RT_ERR_RG_OK)
					{
						if(rg_ret==RT_ERR_RG_DUMMY_DMAC_IDX)
						{
							TRACE("[Drop] after packet modify");
							return RG_FWDENGINE_RET_DROP;
						}
						else
						{
							TRACE("[Drop] after packet modify");
							return RG_FWDENGINE_RET_DROP;
						}
					}
					pPktHdr->l3Modify=1;	//20141023LUKE: for wifi to check if recalculate chksum or not
					return RG_FWDENGINE_RET_DIRECT_TX;


				}
			}
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_pppoeSessionidCheckForL34(rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	for(i=0;i<MAX_PPPOE_SW_TABLE_SIZE;i++)
	{
		if(rg_db.pppoe[i].valid && rg_db.pppoe[i].rtk_pppoe.sessionID==pPktHdr->sessionId)
			return RG_FWDENGINE_RET_CONTINUE;
	}
	//unmatch any pppoe sessionID..
	return RG_FWDENGINE_RET_DROP;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_layer34Forward(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
//	int isL34=0;
	//int sipArpIdx;
	rtk_rg_ipClassification_t sipClass,dipClass;
	rtk_rg_sipDipClassification_t sipDipClass;
	//u8 *pData=skb->data;
	//u32 len=skb->len;
	rtk_rg_fwdEngineReturn_t ret=RG_FWDENGINE_RET_DIRECT_TX;
	rtk_rg_err_code_t rg_ret;
	rtk_rg_lookupIdxReturn_t naptOutIdx=0,naptInIdx=0;
	uint16 checksumBefore;
	rtk_rg_table_icmp_flow_t *icmpCtrlFlow=NULL;
	rtk_rg_ipv4_fragment_out_t *pFragList=NULL;
	rtk_rg_ipv4_fragment_in_t *pFragInList=NULL;

	//DEBUG("L34 Input");

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// Flow Based Wan Access Limit
	if(CONFIG_RG_ACCESSWAN_VERSION==3 && (rg_db.systemGlobal.lanPortMask.portmask & (1<<pPktHdr->ingressPort)))
	{
		if(_rtk_rg_l34WanAccessLimit(pPktHdr) != RT_ERR_RG_OK)
		{
			TRACE("[Drop] Drop by Wan Access Limit");
			return RG_FWDENGINE_RET_DROP;
		}
	}
#endif //CONFIG_RG_FLOW_BASED_PLATFORM

	//20170901LUKE: check pppoe session id exist or not.
	if(pPktHdr->tagif&PPPOE_TAGIF && _rtk_rg_pppoeSessionidCheckForL34(pPktHdr)!=RG_FWDENGINE_RET_CONTINUE)
	{
		TRACE("[Drop] Drop by unknown PPPoE sessionID before L34 Forward");
		return RG_FWDENGINE_RET_DROP;
	}

	if(pPktHdr->tagif&IPV6_TAGIF)
		return _rtk_rg_ipv6L34Forward(skb,pPktHdr);

	TRACE("IPv4 L34 Forward");

	sipClass=_rtk_rg_sip_classification(pPktHdr->ipv4Sip,pPktHdr);
	dipClass=_rtk_rg_dip_classification(pPktHdr->ipv4Dip,pPktHdr);
	if(dipClass==IP_CLASS_FAIL)
	{
		WARNING("[Drop] DIP can not be classified.");
		return RG_FWDENGINE_RET_DROP;
	}
	sipDipClass=rg_db.systemGlobal.sipDipClass[sipClass][dipClass];
	if((sipClass==IP_CLASS_NPI)&&(dipClass==IP_CLASS_NPE))
	{
		// 20141129: When 2nd WAN is routing WAN. RP-->NPE will become NPI-->NPE. so we do this patch.
		if((1<<pPktHdr->ingressPort)&rg_db.systemGlobal.wanPortMask.portmask)
		{
			sipDipClass=SIP_DIP_CLASS_NAPTR;
		}
		//20190508LUKE: support hairpin nat with fragmented packet
		else if((pPktHdr->ipProtocol==RG_IP_PROTO_TCP)||(pPktHdr->ipProtocol==RG_IP_PROTO_UDP)) // 20150420: support Hairpin NAT
		{
			sipDipClass=SIP_DIP_CLASS_HAIRPIN_NAT;
			pPktHdr->isHairpinNat=1;
		}
	}
	if(rg_db.systemGlobal.wanPortMask.portmask&(1<<pPktHdr->ingressPort)){
		//20200211LUKE: for NPI to RP and comes from WAN port mask
		//              transform NAPT to pure-routing for exclude NAT LAN subnet(rt.internal=0).
		//				This situation will happen when the default route constructed by pure-routing WAN.
		if(sipDipClass==SIP_DIP_CLASS_NAPT){
			TRACE("NPI to RP and come from WAN port mask, do pure-routing for exclude NAT subnet.");
			sipDipClass=SIP_DIP_CLASS_ROUTING;
		}
	}else{
		//20200206LUKE: for exclude NAT LAN subnet(rt.internal=0) to proceed routing when head to pure-routing WAN(rt.internal=1).
		if((sipClass==IP_CLASS_RP)&&(dipClass==IP_CLASS_NPI)){
			TRACE("RP to NPI and not from WAN port mask, do pure-routing for exclude NAT subnet.");
			sipDipClass=SIP_DIP_CLASS_ROUTING;
		}
	}
	TRACE("sipClass[%d] dipClass[%d] sipDipClass[%d]",sipClass,dipClass,sipDipClass);
	
	if((pPktHdr->pIpv4TTL==NULL)||(pPktHdr->pIpv4TTL!=NULL && *pPktHdr->pIpv4TTL<=1))
	{
		TRACE("[To PS] TTL fail, to PS!");
		return RG_FWDENGINE_RET_TO_PS;
	}

	if(pPktHdr->tagif&IPV4_TAGIF)
	{
		int l2Idx=FAIL;
		//dump_packet(skb->data,skb->len,"learn arp");
		//DEBUG("L34 learning ARP...");
		_rtk_rg_arpAndMacEntryAdd(pPktHdr->ipv4Sip,pPktHdr->sipL3Idx,pPktHdr->pSmac,pPktHdr->ingressPort,pPktHdr->wlan_dev_idx,&l2Idx,pPktHdr->ingressDecideVlanID,1,0);
		//20170306LUKE: check l2Idx as forwarding decision.
		if(l2Idx<FAIL){
			//20170322LUKE: fix unpermited host could not send packet to protocol stack problem.
			ret=_rtk_rg_checkGwIp(pPktHdr);
			if(ret==RG_FWDENGINE_RET_TO_PS)
				return ret;
			TRACE("[Drop] wanAccessLimit decision: DROP");
			return RG_FWDENGINE_RET_DROP;
		}
	}

	if( (sipDipClass==SIP_DIP_CLASS_ROUTING) && (pPktHdr->tagif&ICMP_TAGIF) && (rg_db.systemGlobal.icmpRedirectToDMZ && (pPktHdr->ICMPType==0 || pPktHdr->ICMPType==8)))
	{
		//invalid local in/out icmp connection
		rg_ret = _rtk_rg_fwdEngine_ICMPInboundControlFlowTracking(pPktHdr, &icmpCtrlFlow);
		if(rg_ret==RT_ERR_RG_TRAP_TO_PS)
			return RG_FWDENGINE_RET_TO_PS;
	}


	//do binding check first!!for unmatch L34L3 or L3L34
	if((sipDipClass==SIP_DIP_CLASS_NAPT) || (sipDipClass==SIP_DIP_CLASS_ROUTING))
	{
		ret=_rtk_rg_routingDecisionTablesLookup(pPktHdr,&sipDipClass);
		if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
	}

	if(sipDipClass==SIP_DIP_CLASS_HAIRPIN_NAT)
	{
		pPktHdr->extipIdx = _rtk_rg_eiplookup(pPktHdr->ipv4Dip);
		if(pPktHdr->extipIdx<0||pPktHdr->extipIdx>=MAX_EXTIP_SW_TABLE_SIZE)	//For NAPTR packet, external ip table lookup will not miss.
		{
			TRACE("[Drop] invalid extipIdx(%d)!",pPktHdr->extipIdx);
			return RG_FWDENGINE_RET_DROP;
		}
		pPktHdr->netifIdx = rg_db.nexthop[rg_db.extip[pPktHdr->extipIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;

		//assign gateway mac to dmacL2Idx
		pPktHdr->dmacL2Idx = rg_db.netif[pPktHdr->netifIdx].l2_idx;
	}

	if((sipDipClass==SIP_DIP_CLASS_NAPT)||(sipDipClass==SIP_DIP_CLASS_HAIRPIN_NAT))
	{
		pPktHdr->fwdDecision=RG_FWD_DECISION_NAPT;

		//DEBUG("skb is %p, ppkthdr is %p, l3offset is %d, l3len is %d",skb,pPktHdr,pPktHdr->l3Offset,pPktHdr->l3Len);
		//DEBUG("before mf and fragoffset check:mf=%d,fragoffset=%d",pPktHdr->ipv4MoreFragment,pPktHdr->ipv4FragmentOffset);

		if(pPktHdr->ipv4FragPacket==0) //normal packet (non-fragment)
		{
#ifdef CONFIG_RG_NAPT_TCP_AUTO_LEARN
			if(pPktHdr->tagif&TCP_TAGIF)
			{
				naptOutIdx=_rtk_rg_naptTcpUdpOutHashIndexLookupByPktHdr(1,pPktHdr);
				ret = _rtk_rg_fwdEngine_TCPOutboundConnectionTracking(pPktHdr,&naptOutIdx);
				if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;

				assert(naptOutIdx>=0);

				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPT_OUTBOUND_FLOW;
				pPktHdr->naptOutboundIndx = naptOutIdx;
				pPktHdr->naptrInboundIndx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;

				/* Packet forwarded by Forwarding Engine, reset idle time */
				rg_db.naptOut[naptOutIdx].idleSecs=0;

//					dump_packet(skb->data,skb->len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,naptOutIdx, pPktHdr,skb,1,1);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
				//assert_ok(ret);
				//dump_packet(skb->data,skb->len,"new");
				if(sipDipClass!=SIP_DIP_CLASS_HAIRPIN_NAT)
					return RG_FWDENGINE_RET_DIRECT_TX;
			}
#endif

			//UDP auto-learning
			if(pPktHdr->tagif&UDP_TAGIF)
			{
				ret = _rtk_rg_fwdEngine_UDPOutboundConnectionTracking(pPktHdr, &naptOutIdx);
				//DEBUG("ret from _rtk_rg_fwdEngine_UDPOutboundConnectionTracking is %d",ret);
				if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;

				assert(naptOutIdx>=0);

				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPT_OUTBOUND_FLOW;
				pPktHdr->naptOutboundIndx = naptOutIdx;
				pPktHdr->naptrInboundIndx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;

				/* Packet forwarded by Forwarding Engine, reset idle time */
				rg_db.naptOut[naptOutIdx].idleSecs=0;

				//dump_packet(pData,len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,naptOutIdx,pPktHdr,skb,1,1);
				//DEBUG("ret from _rtk_rg_fwdEngine_naptPacketModify is %d",ret);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
				//assert_ok(ret);
				//dump_packet(skb->data,skb->len,"new");
				if(sipDipClass!=SIP_DIP_CLASS_HAIRPIN_NAT)
					return RG_FWDENGINE_RET_DIRECT_TX;
			}

			//ICMP forwarding
			if(pPktHdr->tagif&ICMP_TAGIF)
			{
				ret = _rtk_rg_ICMP_specialTypeProcess(skb, pPktHdr, NAPT_DIRECTION_OUTBOUND);
				if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;

				//DEBUG("before add ICMP control flow!! pPktHdr->overMTU is %d",pPktHdr->overMTU);
				_rtk_rg_fwdEngine_ICMPOutboundControlFlowTracking(pPktHdr,&icmpCtrlFlow);

				//Check MTU
				if(pPktHdr->overMTU)
				{
					TRACE("Normal Packet ICMP Over MTU");
					//return RG_FWDENGINE_RET_TO_PS;
				}

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,FAIL,pPktHdr,skb,1,0);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				if(rg_db.systemGlobal.initParam.naptInboundConnLookupThirdCallBack==_rtk_rg_fwdEngine_dmzCheck && rg_db.systemGlobal.icmpRedirectToDMZ && (pPktHdr->ICMPType==0 || pPktHdr->ICMPType==8))
				{
					//do not record this icmp if hit dmz sip
					if(_rtk_rg_fwdEngine_outbound_dmzCheckSip(pPktHdr,pPktHdr->ipv4Sip)==RG_RET_SUCCESS)
						icmpCtrlFlow->valid=0;
				}

				//assert_ok(ret);
				//dump_packet(skb->data,skb->len,"new");
				return RG_FWDENGINE_RET_DIRECT_TX;
			}

#ifdef __KERNEL__ //model skip alg
			if(pPktHdr->tagif&GRE_TAGIF)
			{
				//check PPTP flow for modify GRE packets, only inbound need to change internal IP according to external CallID
				//if the flow is not found, trap to PS
				return _rtk_rg_PPTP_GREModify(NAPT_DIRECTION_OUTBOUND,skb,pPktHdr);
			}

			/*siyuan add for alg IPsec passthrough*/
			if(pPktHdr->tagif & ESP_TAGIF)
			{
				rtk_rg_isakmp_t * pIsakmp = NULL; /* siyuan add for alg IPsec passthrough */
				ALG("Handle ESP OUTBOUND Packet");
				ret = rtk_rg_alg_ESP(NAPT_DIRECTION_OUTBOUND, (unsigned char *)skb, (unsigned char *)pPktHdr, &pIsakmp);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,FAIL,pPktHdr,skb,1,0);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				return RG_FWDENGINE_RET_DIRECT_TX;
			}
#endif
		}

		//fwdEngine only support TCP,UDP,ICMP fragment now
		//first packet which has L4 header of these fragments
		else if(pPktHdr->ipv4MoreFragment && pPktHdr->ipv4FragmentOffset==0)
		{
			//Add software NAPT entry(TCP or UDP)
#ifdef CONFIG_RG_NAPT_TCP_AUTO_LEARN
			if(pPktHdr->tagif&TCP_TAGIF)
			{
				naptOutIdx=_rtk_rg_naptTcpUdpOutHashIndexLookupByPktHdr(1,pPktHdr);
				ret = _rtk_rg_fwdEngine_TCPOutboundConnectionTracking(pPktHdr,&naptOutIdx);

				//before add to fragment table, lookup for created frag list
				pFragList = NULL;
				_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragList!=NULL)
				{
					//DEBUG("totalLength is %d",pFragList->receivedLength);
					// set sport/dport for checking ACL
					pFragList->pktInfo.napt.sport=pPktHdr->sport;
					pFragList->pktInfo.napt.dport=pPktHdr->dport;				
					//20190508LUKE: for outbound list we should keep outIdx in it!!
					pFragList->pktInfo.napt.NaptOutboundEntryIndex=naptOutIdx;
					
					if(pFragList->fragAction==RG_FWDENGINE_RET_DROP || pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragList->fragAction;
					}
					else
					{
						//DEBUG("set pFragList->fragAction to %d",ret);
						pFragList->fragAction=ret;	//forward, drop, or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillOutFragmentInfo(ret,naptOutIdx,pPktHdr,&pFragList);

				//Check total fragment length
				if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
				{
					DEBUG("[outBound]fragments(%d) are all received(%d)!! free the list %p...",pFragList->totalLength,pFragList->receivedLength,pFragList);
					_rtk_rg_freeFragOutList(pFragList);	//although pFragList is return to free list, since we still hold ipv4FragOutLock, there is no one can acquire this "free" entry.
				}

				if(ret==RG_FWDENGINE_RET_DROP)
				{
					TRACE("[Drop] L4 lookup fail, DROP");
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				}
				else if(ret==RG_FWDENGINE_RET_TO_PS)
				{
					TRACE("[To PS] L4 lookup miss, to PS");
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				}

				assert(naptOutIdx>=0);
				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPT_OUTBOUND_FLOW;
				pPktHdr->naptOutboundIndx = naptOutIdx;
				pPktHdr->naptrInboundIndx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
				//dump_packet(pData,len,"org");
				//DEBUG("the shortcut state is %d!!",pPktHdr->shortcutStatus);
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,naptOutIdx, pPktHdr,skb,1,1);
				pFragList->fragAction=ret;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_ROME_NAPT_SHORTCUT)
				//for flow-based we update flow after direct TX.
				pFragList->flowHitIdx=pPktHdr->currentShortcutIdx;
#endif
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue

				//Recaculate L4 checksum, let HW do L3 checksum
				checksumBefore=ntohs(*pPktHdr->pL4Checksum);
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));
				TRACE("First Fragment TCP checksum calculate by software ID=0x%x checksum=0x%04x==>0x%04x!",pPktHdr->ipv4Identification,checksumBefore,ntohs(*pPktHdr->pL4Checksum) );
				//dump_packet(pData,len,"new");
				//20190508LUKE: support hairpin nat with fragmented packet
				if(sipDipClass!=SIP_DIP_CLASS_HAIRPIN_NAT)
					return RG_FWDENGINE_RET_FRAGMENT_ONE;

			}
#endif
			//UDP auto-learning
			if(pPktHdr->tagif&UDP_TAGIF)
			{
				ret = _rtk_rg_fwdEngine_UDPOutboundConnectionTracking(pPktHdr, &naptOutIdx);

				//before add to fragment table, lookup for created frag list
				pFragList = NULL;
				_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragList!=NULL)
				{
					//DEBUG("totalLength is %d",pFragList->totalLength);
					// set sport/dport for checking ACL
					pFragList->pktInfo.napt.sport=pPktHdr->sport;
					pFragList->pktInfo.napt.dport=pPktHdr->dport;
					//20190508LUKE: for outbound list we should keep outIdx in it!!
					pFragList->pktInfo.napt.NaptOutboundEntryIndex=naptOutIdx;
					
					if(pFragList->fragAction==RG_FWDENGINE_RET_DROP || pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragList->fragAction;
					}
					else
					{
						//DEBUG("set pFragList->fragAction to %d",ret);
						pFragList->fragAction=ret;	//forward, drop, or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillOutFragmentInfo(ret,naptOutIdx,pPktHdr,&pFragList);

				//Check total fragment length
				if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
				{
					DEBUG("[outBound]fragments(%d) are all received(%d)!! free the list %p...",pFragList->totalLength,pFragList->receivedLength,pFragList);
					_rtk_rg_freeFragOutList(pFragList);	//although pFragList is return to free list, since we still hold ipv4FragOutLock, there is no one can acquire this "free" entry.
				}

				if(ret==RG_FWDENGINE_RET_DROP)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				}
				else if(ret==RG_FWDENGINE_RET_TO_PS)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				}

				assert(naptOutIdx>=0);
				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPT_OUTBOUND_FLOW;
				pPktHdr->naptOutboundIndx = naptOutIdx;
				pPktHdr->naptrInboundIndx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
				//dump_packet(pData,len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,naptOutIdx,pPktHdr,skb,1,1);
				pFragList->fragAction=ret;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_ROME_NAPT_SHORTCUT)
				//for flow-based we update flow after direct TX.
				pFragList->flowHitIdx=pPktHdr->currentShortcutIdx;
#endif
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue

				//Recaculate L4 checksum, let HW do L3 checksum
				//DEBUG("the original checksum is %x",*pPktHdr->pL4Checksum);
				checksumBefore=ntohs(*pPktHdr->pL4Checksum);
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Sip,pPktHdr->sport,0,0,ntohl(*pPktHdr->pIpv4Sip),ntohs(*pPktHdr->pSport),0,0));
				TRACE("First Fragment UDP checksum calculate by software ID=0x%x checksum=0x%04x==>0x%04x!",pPktHdr->ipv4Identification,checksumBefore,ntohs(*pPktHdr->pL4Checksum) );
				//DEBUG("the new checksum is %x",*pPktHdr->pL4Checksum);
				//DEBUG("UDP first packet modify for fragment...");

				//dump_packet(pData,len,"new");
				//20190508LUKE: support hairpin nat with fragmented packet
				if(sipDipClass!=SIP_DIP_CLASS_HAIRPIN_NAT)
					return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}

			//ICMP forwarding
			if(pPktHdr->tagif&ICMP_TAGIF
#ifdef __KERNEL__ //model skip alg
				||pPktHdr->tagif&GRE_TAGIF||pPktHdr->tagif&ESP_TAGIF	//GRE/ESP forwarding
#endif
				)
			{
				//Check MTU
				if(pPktHdr->overMTU)
				{
					TRACE("First Fragment Packet Over MTU");
					//return RG_FWDENGINE_RET_FRAG_ONE_PS;
				}

				//DEBUG("before add ICMP control flow!!(first fragment packet)");

				//before add to fragment table, lookup for created frag list
				pFragList = NULL;
				_rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragList!=NULL)
				{
					//DEBUG("totalLength is %d",pFragList->totalLength);
					if(pFragList->fragAction==RG_FWDENGINE_RET_DROP || pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragList->fragAction;
					}
					else
						pFragList->fragAction=RG_FWDENGINE_RET_NAPT_OK;	//forward, drop, or to_ps
				}
				else
				{
					if(pPktHdr->tagif&ICMP_TAGIF)
					{
						ret = _rtk_rg_fwdEngine_ICMPOutboundControlFlowTracking(pPktHdr,&icmpCtrlFlow);
					}
#ifdef __KERNEL__ //model skip alg
					else if(pPktHdr->tagif&GRE_TAGIF)
					{
						rtk_rg_alg_connection_t * pConn;
						rtk_rg_alg_tuple_t tuple;
						memset(&tuple, 0, sizeof(rtk_rg_alg_tuple_t));

						_rtk_rg_alg_init_tuple(NAPT_DIRECTION_OUTBOUND, 0, pPktHdr, &tuple);
						pConn = _rtk_rg_alg_PPTPconn_findByRemCallID(NAPT_DIRECTION_OUTBOUND, 0, &tuple, ntohs(*pPktHdr->pGRECallID));
						DEBUG("$$$$ PPTP_GREModify:  OUTBOUND packet to WAN[%d], orig SIP is %x",pPktHdr->netifIdx,pPktHdr->ipv4Sip);
						if(pConn==NULL)
						{
							TRACE("[To PS] GRE conn lookup failed in NAPT..ret=to_PS");
							//dump_packet(skb->data,skb->len,"first return to PS");
							ret = RG_FWDENGINE_RET_TO_PS;
						}
						else
							ret = RG_FWDENGINE_RET_NAPT_OK;
					}
					else if(pPktHdr->tagif&ESP_TAGIF)
					{
						rtk_rg_isakmp_t *pIsakmp = NULL; /* siyuan add for alg IPsec passthrough */
						DEBUG("Handle ESP OUTBOUND Packet");
						ret = rtk_rg_alg_ESP(NAPT_DIRECTION_OUTBOUND, (unsigned char *)skb, (unsigned char *)pPktHdr, &pIsakmp);
						if(ret==RG_FWDENGINE_RET_CONTINUE)
							ret = RG_FWDENGINE_RET_NAPT_OK;
					}
#endif
					else
					{
						TRACE("Unsupported protocol! action is trap to procotol stack.");
						ret=RG_FWDENGINE_RET_TO_PS;
					}
					_rtk_rg_fwdEngine_fillOutFragmentInfo(ret,FAIL,pPktHdr,&pFragList);
				}

				//Check total fragment length
				if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
				{
					DEBUG("[outBound]fragments(%d) are all received(%d)!! free the list %p...",pFragList->totalLength,pFragList->receivedLength,pFragList);
					_rtk_rg_freeFragOutList(pFragList);	//although pFragList is return to free list, since we still hold ipv4FragOutLock, there is no one can acquire this "free" entry.
				}

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,FAIL,pPktHdr,skb,1,0);
				pFragList->fragAction=ret;
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue

				//dump_packet(skb->data,skb->len,"ICMP first fragment");
				return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}
		}
		else if(pPktHdr->ipv4FragmentOffset>0)	//other fragments
		{
			//DEBUG("i am non-first fragment packets...");
			pFragList = NULL;
			naptOutIdx = _rtk_rg_fwdEngine_fragmentOutHashIndexLookup(&pFragList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);

			if(pFragList!=NULL)		//filled by first packet or other early fragment packets
			{
				//DEBUG("later fragment modify...");
				// set sport/dport for checking ACL
				if(pPktHdr->ipProtocol==RG_IP_PROTO_TCP || pPktHdr->ipProtocol==RG_IP_PROTO_UDP)
				{
					pPktHdr->sport = pFragList->pktInfo.napt.sport;
					pPktHdr->dport = pFragList->pktInfo.napt.dport;
				}
				if(pPktHdr->ipv4MoreFragment == 0)		//we can not free fragList here, unless there are all packets had forwarded
					pFragList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
				//DEBUG("totalLength is %d",pFragList->totalLength);
				//Check total fragment length
				if(pFragList->totalLength>0 && pFragList->receivedLength>=pFragList->totalLength)
				{
					DEBUG("[outBound]fragments(%d) are all received(%d)!! free the list %p...",pFragList->totalLength,pFragList->receivedLength,pFragList);
					_rtk_rg_freeFragOutList(pFragList);	//although pFragList is return to free list, since we still hold ipv4FragOutLock, there is no one can acquire this "free" entry.
				}

				//Check frag action from first packet
				ret=pFragList->fragAction;
				if(ret==RG_FWDENGINE_RET_TO_PS || ret==RG_FWDENGINE_RET_DROP)
				{
					TRACE("[%s] do frag action", (ret==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
					return ret;
				}
				if(ret==RG_FWDENGINE_RET_QUEUE_FRAG)	//first packet not come in yet
					goto OUTBOUND_FRAG_QUEUE;
				if(naptOutIdx>=0)	//TCP or UDP
				{
					/*record result for internalPri decision*/
					pPktHdr->l4Direction = RG_NAPT_OUTBOUND_FLOW;
					pPktHdr->naptOutboundIndx = naptOutIdx;
					pPktHdr->naptrInboundIndx = rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
					//Modify the SIP and forward it
					ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,naptOutIdx,pPktHdr,skb,1,0);
					if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
					//assert_ok(ret);

					//20190508LUKE: support hairpin nat with fragmented packet
					if(sipDipClass!=SIP_DIP_CLASS_HAIRPIN_NAT)
						return RG_FWDENGINE_RET_FRAGMENT;
				}
				else		//Other
				{
					//Check MTU
					if(pPktHdr->overMTU)
					{
						TRACE("Offset>0 Fragment Packet Over MTU");
						//return RG_FWDENGINE_RET_TO_PS;
					}

					//DEBUG("later fragment modify... fragIdx=%d",fragIdx);
					//if(pPktHdr->ipv4MoreFragment == 0 && fragIdx != FAIL)		//we can not free fragList here, if the last one is coming before other frags....
						//_rtk_rg_freeFragOutList(fragIdx,pFragList);

					ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_OUTBOUND,FAIL,pPktHdr,skb,1,0);
					if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
					//assert_ok(ret);
					//dump_packet(skb->data,skb->len,"ICMP outbound(frag)");
					return RG_FWDENGINE_RET_FRAGMENT;
				}
			}
			else
			{
				//Otherwise we need to queue this packet for later proceed
				_rtk_rg_fwdEngine_fillOutFragmentInfo(RG_FWDENGINE_RET_QUEUE_FRAG,FAIL,pPktHdr,&pFragList);

				//DEBUG("queuing packet.....");
OUTBOUND_FRAG_QUEUE:
				//20190508LUKE: support hairpin nat with fragmented packet
				if(sipDipClass!=SIP_DIP_CLASS_HAIRPIN_NAT)
				{
					//Check if we already queue same identification for MAX_FRAGMENT_QUEUE_THRESHOLD times
					pFragList->queueCount++;
					if(pFragList->queueCount>=MAX_FRAGMENT_QUEUE_THRESHOLD)
					{
						//clear same identification in queue
						pFragList->queueCount=0;
						pFragList->fragAction=RG_FWDENGINE_RET_DROP;
						_rtk_rg_fwdEngine_fragmentQueueProcessing(pFragList->fragAction,pPktHdr);
						TRACE("[Drop] queueCount of v4 fragment >= MAX_FRAGMENT_QUEUE_THRESHOLD(%d)", MAX_FRAGMENT_QUEUE_THRESHOLD);
						return RG_FWDENGINE_RET_DROP;
					}
					else
					{
						//Put the fragment packet into queue
						_rtk_rg_fwdEngine_fragmentPacketQueuing(NAPT_DIRECTION_OUTBOUND,skb,pPktHdr);
						//do not count received length if the packet is queued
						pFragList->receivedLength -= (pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
						return RG_FWDENGINE_RET_QUEUE_FRAG;
					}
				}
				else
				{
					//20190508LUKE: change SIP here, otherwise inbound frag list won't hit.
					*pPktHdr->pIpv4Sip=htonl(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr);
#ifdef CONFIG_APOLLO_MODEL
					TRACE("modify SIP to %d.%d.%d.%d",(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr>>24)&0xff,(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr>>16)&0xff,(rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr>>8)&0xff,rg_db.extip[pPktHdr->extipIdx].rtk_extip.extIpAddr&0xff);
#else
					TRACE("modify SIP to %d.%d.%d.%d",(ntohl(*pPktHdr->pIpv4Sip)>>24)&0xff,(ntohl(*pPktHdr->pIpv4Sip)>>16)&0xff,(ntohl(*pPktHdr->pIpv4Sip)>>8)&0xff,ntohl(*pPktHdr->pIpv4Sip)&0xff);
#endif
				}
			}
		}
	}

	if(sipDipClass==SIP_DIP_CLASS_HAIRPIN_NAT)
	{
		TRACE("Hairpin NAPT is finished and Hairpin NAPTR will start.");
		_rtk_rg_fwdEngine_updateFlowStatus(pPktHdr);
		pPktHdr->ipv4Sip=ntohl(*pPktHdr->pIpv4Sip);
		if((pPktHdr->tagif&TCP_TAGIF)||(pPktHdr->tagif&UDP_TAGIF))pPktHdr->sport=ntohs(*pPktHdr->pSport);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->hairpinNat_naptOutboundIndx = pPktHdr->naptOutboundIndx;
		pPktHdr->hairpinNatr_srcNetifIdx = pPktHdr->netifIdx;
#endif
	}

	if((sipDipClass==SIP_DIP_CLASS_NAPTR)||(sipDipClass==SIP_DIP_CLASS_HAIRPIN_NAT))
	{
		pPktHdr->fwdDecision=RG_FWD_DECISION_NAPTR;

		// From which WAN?
		pPktHdr->extipIdx = _rtk_rg_eiplookup(pPktHdr->ipv4Dip);
		if(pPktHdr->extipIdx<0||pPktHdr->extipIdx>=MAX_EXTIP_SW_TABLE_SIZE)	//For NAPTR packet, external ip table lookup will not miss.
		{
			TRACE("[Drop] invalid extipIdx(%d)!",pPktHdr->extipIdx);
			return RG_FWDENGINE_RET_DROP;
		}
		pPktHdr->netifIdx = rg_db.nexthop[rg_db.extip[pPktHdr->extipIdx].rtk_extip.nhIdx].rtk_nexthop.ifIdx;

#ifdef CONFIG_RG_SIMPLE_PROTOCOL_STACK
		//Keep WAN interface index in CP structure
		/*for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].index==pPktHdr->netifIdx)
			{
				cp->wanInterfaceIdx=i;
				break;
			}
		}*/
		if(skb->dev->priv && ((struct re_dev_private*)skb->dev->priv)->pCp)((struct re_dev_private*)skb->dev->priv)->pCp->wanInterfaceIdx=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index;
		//DEBUG("this packet came from WAN index %d (eth%d)",rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index,rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index+1);
#endif

		if(pPktHdr->ipv4FragPacket==0) //normal packet (non-fragment)
		{
#ifdef CONFIG_RG_NAPT_TCP_AUTO_LEARN
			if(pPktHdr->tagif&TCP_TAGIF)
			{

				naptOutIdx=_rtk_rg_naptTcpUdpInHashIndexLookup(1,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
				ret = _rtk_rg_fwdEngine_TCPInboundConnectionTracking(pPktHdr,&naptOutIdx);
				if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;

				assert(naptOutIdx>=0);
				if(naptOutIdx<0)
				{
					TRACE("[To PS] napt connection is not found in napt table for inbound packet");
					return RG_FWDENGINE_RET_TO_PS;
				}

				naptInIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPTR_INBOUND_FLOW;
				pPktHdr->naptOutboundIndx = naptOutIdx;	//value get in _rtk_rg_fwdEngine_TCPInboundConnectionTracking()
				pPktHdr->naptrInboundIndx = naptInIdx;

				/* Packet forwarded by Forwarding Engine, reset idle time */
				rg_db.naptOut[naptOutIdx].idleSecs=0;

				//packet modify and directTX
				//dump_packet(skb->data,skb->len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,naptInIdx,pPktHdr,skb,1,1);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
				//assert_ok(ret);
				//dump_packet(skb->data,skb->len,"new");
				return RG_FWDENGINE_RET_DIRECT_TX;
			}
#endif
			if(pPktHdr->tagif&UDP_TAGIF)
			{
#ifdef CONFIG_RG_NAPT_INBOUND_TRACKING
				ret = _rtk_rg_fwdEngine_UDPInboundConnectionTracking(pPktHdr, &naptOutIdx);
				if(ret!=RG_FWDENGINE_RET_NAPT_OK)return ret;
#else
				naptOutIdx=_rtk_rg_naptTcpUdpInHashIndexLookup(0,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
#endif

				assert(naptOutIdx>=0);
				if(naptOutIdx<0)
				{
					TRACE("[To PS] napt connection is not found in napt table for inbound packet");
					return RG_FWDENGINE_RET_TO_PS;
				}

				naptInIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPTR_INBOUND_FLOW;
				pPktHdr->naptrInboundIndx = naptInIdx;
				pPktHdr->naptOutboundIndx = naptOutIdx;//value get in _rtk_rg_fwdEngine_UDPInboundConnectionTracking()

				/* Packet forwarded by Forwarding Engine, reset idle time */
				rg_db.naptOut[naptOutIdx].idleSecs=0;

				//packet modify and directTX
				//dump_packet(pData,len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,naptInIdx,pPktHdr,skb,1,1);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
				//assert_ok(ret);
				//if(ret!=RT_ERR_RG_OK) return RG_FWDENGINE_RET_DROP;
				//dump_packet(pData,len,"new");
				return RG_FWDENGINE_RET_DIRECT_TX;
			}

			//ICMP link list lookup
			if(pPktHdr->tagif&ICMP_TAGIF)
			{
				ipaddr_t transIP = pPktHdr->ipv4Dip;
				uint16 transPort = pPktHdr->dport;

				ret = _rtk_rg_ICMP_specialTypeProcess(skb, pPktHdr, NAPT_DIRECTION_INBOUND);
				if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;

				//DEBUG("before ICMP flow lookup!");
				rg_ret = _rtk_rg_fwdEngine_ICMPInboundControlFlowTracking(pPktHdr, &icmpCtrlFlow);

				if(rg_ret==RT_ERR_RG_ENTRY_NOT_FOUND)
				{
					if(rg_db.systemGlobal.icmpRedirectToDMZ && (pPktHdr->ICMPType==0 || pPktHdr->ICMPType==8))
					{
						ret = _rtk_rg_fwdEngine_connType_lookup(pPktHdr,&transIP,&transPort);
						if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
					}
					if(rg_db.systemGlobal.icmpRedirectToDMZ && pPktHdr->naptrLookupHit==3 && (pPktHdr->ICMPType==0 || pPktHdr->ICMPType==8))
					{
						//we will not record this icmpCtrlFlow because Dmz redirect to internalIP  is default action for icmp if icmpRedirectToDMZ==1
						TRACE("ICMP connect not found ICMP redirect to DMZ internalIP=%pI4h remoteIP=%pI4h ExtIP=%pI4h",&transIP,&pPktHdr->ipv4Sip,&pPktHdr->ipv4Dip);
						_rtk_rg_fwdEngine_ICMPOutboundControlFlowTracking(pPktHdr,&icmpCtrlFlow);
						icmpCtrlFlow->internalIP = transIP;
						icmpCtrlFlow->remoteIP =pPktHdr->ipv4Sip;
					}
					else
					{
						TRACE("[To PS] packet in ICMPR...before return to PS");
						//dump_packet(skb->data,skb->len,"return to PS");
						return RG_FWDENGINE_RET_TO_PS;
					}
				}
				else if(rg_ret==RT_ERR_RG_TRAP_TO_PS)
				{
					return RG_FWDENGINE_RET_TO_PS;
				}

				//1 FIXME:Here should check MTU size, too!!!
				if(pPktHdr->overMTU)
				{
					TRACE("OVER MTU !!");
					//return RG_FWDENGINE_RET_TO_PS;
				}
				DEBUG("the internal IP from ICMP flow is %x",icmpCtrlFlow->internalIP);
				//Modify DIP
				*pPktHdr->pIpv4Dip=htonl(icmpCtrlFlow->internalIP);
				//pPktHdr->ipv4Dip=icmpCtrlFlow->internalIP;

				//invalid this ctrl flow
				icmpCtrlFlow->valid=0;

				//record the ICMP tracking flow for naptFilterAndQoS checking later.
				pPktHdr->icmpCtrlFlowForNaptFilter = icmpCtrlFlow;
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,FAIL,pPktHdr,skb,0,0); //DIP already be modified by this function. Don't need to modify again.
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
				//assert_ok(ret);
				//dump_packet(skb->data,skb->len,"ICMP inbound");
				pPktHdr->l3Modify=1;	//20141023LUKE: for wifi to check if recalculate chksum or not
				return RG_FWDENGINE_RET_DIRECT_TX;

			}

#ifdef __KERNEL__ //model skip alg
			if(pPktHdr->tagif&GRE_TAGIF)
			{
				//check PPTP flow for modify GRE packets, only inbound need to change internal IP according to external CallID
				//if the flow is not found, trap to PS
				return _rtk_rg_PPTP_GREModify(NAPT_DIRECTION_INBOUND,skb,pPktHdr);
			}

			/*siyuan add for alg IPsec passthrough*/
			if(pPktHdr->tagif & ESP_TAGIF)
			{
				rtk_rg_isakmp_t * pIsakmp = NULL; /* siyuan add for alg IPsec passthrough */
				ALG("Handle ESP INBOUND Packet");
				ret = rtk_rg_alg_ESP(NAPT_DIRECTION_INBOUND, (unsigned char *)skb, (unsigned char *)pPktHdr, &pIsakmp);
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				*pPktHdr->pIpv4Dip=htonl(pIsakmp->local_ip);
				//pPktHdr->ipv4Dip=pIsakmp->local_ip;

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,FAIL,pPktHdr,skb,0,0); //DIP already be modified by this function. Don't need to modify again.
				if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP

				return RG_FWDENGINE_RET_DIRECT_TX;
			}
#endif
		}
		else if(pPktHdr->ipv4MoreFragment && pPktHdr->ipv4FragmentOffset==0)	//first packet which has L4 header of these fragments
		{
#ifdef CONFIG_RG_NAPT_TCP_AUTO_LEARN
			if(pPktHdr->tagif&TCP_TAGIF)
			{
				naptOutIdx=_rtk_rg_naptTcpUdpInHashIndexLookup(1,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
				ret = _rtk_rg_fwdEngine_TCPInboundConnectionTracking(pPktHdr,&naptOutIdx);

				//before add to fragment table, look up for created frag list
				pFragInList = NULL;
				_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragInList!=NULL)
				{
					//DEBUG("totalLength is %d",pFragInList->totalLength);
					// set sport/dport for checking ACL
					pFragInList->pktInfo.napt.sport=pPktHdr->sport;
					pFragInList->pktInfo.napt.dport=pPktHdr->dport;
					//20141119LUKE: for inbound list we should keep outIdx in it!!
					pFragInList->pktInfo.napt.NaptOutboundEntryIndex=naptOutIdx;
					
					if(pFragInList->fragAction==RG_FWDENGINE_RET_DROP || pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragInList->fragAction;
					}
					else
					{
						//DEBUG("set pFragInList->fragAction to %d",ret);
						pFragInList->fragAction=ret;	//forward, drop, or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillInFragmentInfo(ret,naptOutIdx,NULL,pPktHdr,&pFragInList);

				//Check total fragment length
				if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
				{
					DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
					_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
				}

				//20180906LUKE: the first fragment should carry queued fragment as same action.
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;

				assert(naptOutIdx>=0);
				naptInIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPTR_INBOUND_FLOW;
				pPktHdr->naptrInboundIndx = naptInIdx;
				pPktHdr->naptOutboundIndx = naptOutIdx;	//value get in _rtk_rg_fwdEngine_TCPInboundConnectionTracking()

				/* Packet forwarded by Forwarding Engine, reset idle time */
				rg_db.naptOut[naptOutIdx].idleSecs=0;

				//packet modify and directTX
				//dump_packet(skb->data,skb->len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,naptInIdx,pPktHdr,skb,1,1);
				pFragInList->fragAction=ret;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_ROME_NAPT_SHORTCUT)
				//for flow-based we update flow after direct TX.
				pFragInList->flowHitIdx=pPktHdr->currentShortcutIdx;
#endif
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue

				//Recaculate L4 checksum, let HW do L3 checksum
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_L4checksumUpdate(pPktHdr->tcpFlags.ack,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,pPktHdr->tcpSeq,pPktHdr->tcpAck,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),ntohl(*pPktHdr->pTcpSeq),ntohl(*pPktHdr->pTcpAck)));

				//dump_packet(skb->data,skb->len,"new");
				return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}
#endif

			if(pPktHdr->tagif&UDP_TAGIF)
			{
#ifdef CONFIG_RG_NAPT_INBOUND_TRACKING
				ret = _rtk_rg_fwdEngine_UDPInboundConnectionTracking(pPktHdr, &naptOutIdx);
#else
				naptOutIdx=_rtk_rg_naptTcpUdpInHashIndexLookup(0,pPktHdr->ipv4Sip,pPktHdr->sport,pPktHdr->ipv4Dip,pPktHdr->dport);
				ret = RG_FWDENGINE_RET_NAPT_OK;
				if(naptOutIdx<0)
				{
					//dump_packet(pData,len,"outIdx=fail");
					ret = RG_FWDENGINE_RET_TO_PS;
				}
#endif

				//before add to fragment table, look up for created frag list
				pFragInList = NULL;
				_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragInList!=NULL)
				{
					//DEBUG("totalLength is %d",pFragInList->totalLength);
					// set sport/dport for checking ACL
					pFragInList->pktInfo.napt.sport=pPktHdr->sport;
					pFragInList->pktInfo.napt.dport=pPktHdr->dport;
					//20141119LUKE: for inbound list we should keep outIdx in it!!
					pFragInList->pktInfo.napt.NaptOutboundEntryIndex=naptOutIdx;
					
					if(pFragInList->fragAction==RG_FWDENGINE_RET_DROP || pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragInList->fragAction;
					}
					else
					{
						//DEBUG("set pFragInList->fragAction to %d",ret);
						pFragInList->fragAction=ret;	//forward or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillInFragmentInfo(ret,naptOutIdx,NULL,pPktHdr,&pFragInList);

				//Check total fragment length
				if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
				{
					DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
					_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
				}

				if(ret==RG_FWDENGINE_RET_DROP)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				}
				else if(ret==RG_FWDENGINE_RET_TO_PS)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				}

				assert(naptOutIdx>=0);
				naptInIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
				/*record result for internalPri decision*/
				pPktHdr->l4Direction = RG_NAPTR_INBOUND_FLOW;
				pPktHdr->naptrInboundIndx = naptInIdx;
				pPktHdr->naptOutboundIndx = naptOutIdx;	//value get in _rtk_rg_fwdEngine_UDPInboundConnectionTracking()

				/* Packet forwarded by Forwarding Engine, reset idle time */
				rg_db.naptOut[naptOutIdx].idleSecs=0;

				//packet modify and directTX
				//dump_packet(pData,len,"org");
				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,naptInIdx,pPktHdr,skb,1,1);
				pFragInList->fragAction=ret;
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_ROME_NAPT_SHORTCUT)
				//for flow-based we update flow after direct TX.
				pFragInList->flowHitIdx=pPktHdr->currentShortcutIdx;
#endif
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue

				//Recaculate L4 checksum, let HW do L3 checksum
				*pPktHdr->pL4Checksum = htons(_rtk_rg_fwdengine_UDPchecksumUpdate(0,ntohs(*pPktHdr->pL4Checksum),pPktHdr->ipv4Dip,pPktHdr->dport,0,0,ntohl(*pPktHdr->pIpv4Dip),ntohs(*pPktHdr->pDport),0,0));
				//dump_packet(pData,len,"new");
				return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}

			if(pPktHdr->tagif&ICMP_TAGIF)
			{
				//DEBUG("before lookup ICMP control flow!!(first inbound fragment packet)");
				rg_ret = _rtk_rg_fwdEngine_ICMPInboundControlFlowTracking(pPktHdr, &icmpCtrlFlow);

				if(rg_ret==RT_ERR_RG_ENTRY_NOT_FOUND)
				{
					TRACE("[To PS] ICMP flow lookup failed in NAPTR..ret=to_PS");
					//dump_packet(skb->data,skb->len,"first return to PS");
					ret = RG_FWDENGINE_RET_TO_PS;
				}
				else if(rg_ret==RT_ERR_RG_TRAP_TO_PS)
				{
					ret = RG_FWDENGINE_RET_TO_PS;
				}
				else if(rg_ret==RT_ERR_RG_OK)
				{
					//Keep IP identifier for other fragment packets
					icmpCtrlFlow->inboundIPID=pPktHdr->ipv4Identification;
					ret = RG_FWDENGINE_RET_NAPT_OK;
				}

				//1 FIXME:Here should check MTU size, too!!!

				//before add to fragment table, look up for created frag list
				pFragInList = NULL;
				_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragInList!=NULL)
				{
					//20190116LUKE: we should keep internal IP in fragInList.
					if(icmpCtrlFlow)pFragInList->pktInfo.other.intIp=icmpCtrlFlow->internalIP;
					//DEBUG("totalLength is %d",pFragInList->totalLength);
					if(pFragInList->fragAction==RG_FWDENGINE_RET_DROP || pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragInList->fragAction;
					}
					else
					{
						//DEBUG("set pFragInList->fragAction to %d",ret);
						pFragInList->fragAction=ret;	//forward  or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillInFragmentInfo(ret,FAIL,(void *)icmpCtrlFlow,pPktHdr,&pFragInList);

				//Check total fragment length
				if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
				{
					DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
					_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
				}

				if(ret==RG_FWDENGINE_RET_TO_PS)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				}

				//Modify DIP
				*pPktHdr->pIpv4Dip=htonl(icmpCtrlFlow->internalIP);
				//pPktHdr->ipv4Dip=icmpCtrlFlow->internalIP;

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,FAIL,pPktHdr,skb,0,0);
				pFragInList->fragAction=ret;
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				pPktHdr->l3Modify=1;	//20141023LUKE: for wifi to check if recalculate chksum or not
				return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}

#ifdef __KERNEL__ //model skip alg
			if(pPktHdr->tagif&GRE_TAGIF)
			{
				rtk_rg_alg_connection_t *pConn;
				rtk_rg_alg_tuple_t tuple;
				memset(&tuple, 0, sizeof(rtk_rg_alg_tuple_t));

				_rtk_rg_alg_init_tuple(NAPT_DIRECTION_INBOUND, 0, pPktHdr, &tuple);

				pConn = _rtk_rg_alg_PPTPconn_findByExtCallID(&tuple, ntohs(*pPktHdr->pGRECallID));
				DEBUG("$$$$ PPTP_GREModify:  INBOUND packet from WAN[%d], orig DIP is %x",pPktHdr->netifIdx,pPktHdr->ipv4Dip);

				if(pConn==NULL)
				{
					TRACE("[To PS] GRE conn lookup failed in NAPTR..ret=to_PS");
					//dump_packet(skb->data,skb->len,"first return to PS");
					ret = RG_FWDENGINE_RET_TO_PS;
				}
				else
				{
					ret = RG_FWDENGINE_RET_NAPT_OK;
				}

				//1 FIXME:Here should check MTU size, too!!!

				//before add to fragment table, look up for created frag list
				pFragInList = NULL;
				_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragInList!=NULL)
				{
					//20190116LUKE: we should keep internal IP in fragInList.
					if(pConn)pFragInList->pktInfo.other.intIp=pConn->tuple.internalIp.ip;
					//DEBUG("totalLength is %d",pFragInList->totalLength);
					if(pFragInList->fragAction==RG_FWDENGINE_RET_DROP || pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragInList->fragAction;
					}
					else
					{
						//DEBUG("set pFragInList->fragAction to %d",ret);
						pFragInList->fragAction=ret;	//forward  or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillInFragmentInfo(ret,FAIL,(void *)pConn,pPktHdr,&pFragInList);

				//Check total fragment length
				if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
				{
					DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
					_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
				}

				if(ret==RG_FWDENGINE_RET_DROP)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				}
				else if(ret==RG_FWDENGINE_RET_TO_PS)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				}

				//Turn on action to prevent adding to shortCut
				pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;

				//Change DIP to internal IP
				*pPktHdr->pIpv4Dip=htonl(pConn->tuple.internalIp.ip);

				DEBUG("DIP change to %x, callID change from %d to %d",pConn->tuple.internalIp.ip,ntohs(*pPktHdr->pGRECallID),pConn->app.pptp.internalCallID);
				//Change CallID in key to IntCallID
				*pPktHdr->pGRECallID=htons(pConn->app.pptp.internalCallID);

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,FAIL,pPktHdr,skb,0,0);
				pFragInList->fragAction=ret;
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				pPktHdr->l3Modify=1;	//20141023LUKE: for wifi to check if recalculate chksum or not
				return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}

			if(pPktHdr->tagif & ESP_TAGIF)
			{
				rtk_rg_isakmp_t * pIsakmp = NULL; /* siyuan add for alg IPsec passthrough */
				DEBUG("Handle ESP INBOUND Packet");
				ret = rtk_rg_alg_ESP(NAPT_DIRECTION_INBOUND, (unsigned char *)skb, (unsigned char *)pPktHdr, &pIsakmp);

				if(ret==RG_FWDENGINE_RET_CONTINUE)
					ret = RG_FWDENGINE_RET_NAPT_OK;

				//1 FIXME:Here should check MTU size, too!!!

				//before add to fragment table, look up for created frag list
				pFragInList = NULL;
				_rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
				if(pFragInList!=NULL)
				{
					//20190116LUKE: we should keep internal IP in fragInList.
					if(pIsakmp)pFragInList->pktInfo.other.intIp=pIsakmp->local_ip;
					//DEBUG("totalLength is %d",pFragInList->totalLength);
					if(pFragInList->fragAction==RG_FWDENGINE_RET_DROP || pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)
					{
						TRACE("[%s] do frag action", (pFragInList->fragAction==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
						return pFragInList->fragAction;
					}
					else
					{
						//DEBUG("set pFragInList->fragAction to %d",ret);
						pFragInList->fragAction=ret;	//forward  or to_ps
					}
				}
				else
					_rtk_rg_fwdEngine_fillInFragmentInfo(ret,FAIL,(void *)pIsakmp,pPktHdr,&pFragInList);

				//Check total fragment length
				if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
				{
					DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
					_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
				}

				if(ret==RG_FWDENGINE_RET_DROP)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				}
				else if(ret==RG_FWDENGINE_RET_TO_PS)
				{
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				}

				//Turn on action to prevent adding to shortCut
				pPktHdr->algAction=RG_ALG_ACT_TO_FWDENGINE;

				*pPktHdr->pIpv4Dip=htonl(pIsakmp->local_ip);
				//pPktHdr->ipv4Dip=pIsakmp->local_ip;

				ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,FAIL,pPktHdr,skb,0,0);
				pFragInList->fragAction=ret;
				if(ret==RG_FWDENGINE_RET_DROP)
					return RG_FWDENGINE_RET_FRAG_ONE_DROP;		//drop all same identification in queue
				else if(ret==RG_FWDENGINE_RET_TO_PS)
					return RG_FWDENGINE_RET_FRAG_ONE_PS;		//trap all same identification in queue
				pPktHdr->l3Modify=1;	//20141023LUKE: for wifi to check if recalculate chksum or not
				return RG_FWDENGINE_RET_FRAGMENT_ONE;
			}
#endif
		}
		else if(pPktHdr->ipv4FragmentOffset>0)	//other fragments
		{
			pFragInList = NULL;
			naptOutIdx = _rtk_rg_fwdEngine_fragmentInHashIndexLookup(&pFragInList, pPktHdr->ipProtocol, pPktHdr->ipv4Sip, pPktHdr->ipv4Dip, pPktHdr->ipv4Identification, pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);

			if(pFragInList!=NULL)		//filled by first packet or other early fragment packets
			{
				//DEBUG("later fragment modify... fragIdx=%d,pktcnt=%d",fragIdx,pFragInList->pktCount);
				// set sport/dport for checking ACL
				if(pPktHdr->ipProtocol==RG_IP_PROTO_TCP || pPktHdr->ipProtocol==RG_IP_PROTO_UDP)
				{
					pPktHdr->sport = pFragInList->pktInfo.napt.sport;
					pPktHdr->dport = pFragInList->pktInfo.napt.dport;
				}
				if(pPktHdr->ipv4MoreFragment == 0)		//we can not free fragList here, unless there are all packets had forwarded
					pFragInList->totalLength=(pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen;
				//DEBUG("totalLength is %d",pFragInList->totalLength);
				//Check total fragment length
				if(pFragInList->totalLength>0 && pFragInList->receivedLength>=pFragInList->totalLength)
				{
					DEBUG("[inBound]fragments(%d) are all received(%d)!! free the list %p...",pFragInList->totalLength,pFragInList->receivedLength,pFragInList);
					_rtk_rg_freeFragInList(pFragInList);	//although pFragInList is return to free list, since we still hold ipv4FragInLock, there is no one can acquire this "free" entry.
				}

				DEBUG("Check for frag action:%d",pFragInList->fragAction);
				//Check frag action from first packet
				ret=pFragInList->fragAction;
				if(ret==RG_FWDENGINE_RET_TO_PS || ret==RG_FWDENGINE_RET_DROP)
				{
					TRACE("[%s] do frag action", (ret==RG_FWDENGINE_RET_TO_PS)?"To PS":"Drop");
					return ret;
				}
				if(ret==RG_FWDENGINE_RET_QUEUE_FRAG)	//first packet not come in yet
					goto INBOUND_FRAG_QUEUE;
				//DEBUG("normal forward!");
				if(naptOutIdx>=0)		//TCP or UDP
				{
					naptInIdx=rg_db.naptOut[naptOutIdx].rtk_naptOut.hashIdx;
					/*record result for internalPri decision*/
					pPktHdr->l4Direction = RG_NAPTR_INBOUND_FLOW;
					pPktHdr->naptOutboundIndx = naptOutIdx;
					pPktHdr->naptrInboundIndx = naptInIdx;

					/* Packet forwarded by Forwarding Engine, reset idle time */
					rg_db.naptOut[naptOutIdx].idleSecs=0;

					//DEBUG("UDP last fragment modify...");
					//if(pPktHdr->ipv4MoreFragment == 0 && fragIdx != FAIL)		//we can not free fragList here, if the last one is coming before other frags....
						//_rtk_rg_freeFragInList(fragIdx,pFragInList);

					//Modify the DIP and forward it
					ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,naptInIdx,pPktHdr,skb,1,0);		//fragment packet without dport
					if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
					//assert_ok(ret);

					return RG_FWDENGINE_RET_FRAGMENT;
				}
				else	//Other
				{
					DEBUG("find the inbound fragment flow!! inboundIPID is %d",pFragInList->identification);

					//Modify DIP
					*pPktHdr->pIpv4Dip=htonl(pFragInList->pktInfo.other.intIp);
					//pPktHdr->ipv4Dip=pFragInList->pktInfo.icmp.intIp;

					//DEBUG("ICMP last fragment modify...");
					//if(pPktHdr->ipv4MoreFragment == 0 && fragIdx != FAIL)		//we can not free fragList here, if the last one is coming before other frags....
					//{
						//pFragInList->pktInfo.pICMPCtrlFlow->valid=0;
						//_rtk_rg_freeFragInList(fragIdx,pFragInList);
					//}

					ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_INBOUND,FAIL,pPktHdr,skb,0,0); //DIP already be modified by this function.Don't need to modify again.
					if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
					//assert_ok(ret);
					//dump_packet(skb->data,skb->len,"ICMP fragment");
					pPktHdr->l3Modify=1;	//20141023LUKE: for wifi to check if recalculate chksum or not
					return RG_FWDENGINE_RET_FRAGMENT;
				}
			}
			else
			{
				//1 FIXME:Here should check MTU size, too!!!

				//Otherwise we need to queue this packet for later proceed
				_rtk_rg_fwdEngine_fillInFragmentInfo(RG_FWDENGINE_RET_QUEUE_FRAG,FAIL,NULL,pPktHdr,&pFragInList);

INBOUND_FRAG_QUEUE:
				//DEBUG("queuing packet.....");

				//Check if we already queue same identification for MAX_FRAGMENT_QUEUE_THRESHOLD times
				pFragInList->queueCount++;
				if(pFragInList->queueCount>=MAX_FRAGMENT_QUEUE_THRESHOLD)
				{
					//clear same identification in queue
					pFragInList->queueCount=0;
					pFragInList->fragAction=RG_FWDENGINE_RET_DROP;
					_rtk_rg_fwdEngine_fragmentQueueProcessing(pFragInList->fragAction,pPktHdr);
					TRACE("[Drop] queueCount of v4 fragment >= MAX_FRAGMENT_QUEUE_THRESHOLD(%d)", MAX_FRAGMENT_QUEUE_THRESHOLD);
					return RG_FWDENGINE_RET_DROP;
				}
				else
				{
					//Put the fragment packet into queue
					_rtk_rg_fwdEngine_fragmentPacketQueuing(NAPT_DIRECTION_INBOUND,skb,pPktHdr);
					//do not count received length if the packet is queued
					pFragInList->receivedLength -= (pPktHdr->l3Len-pPktHdr->ipv4HeaderLen);
					return RG_FWDENGINE_RET_QUEUE_FRAG;
				}
			}
		}
	}

	if(sipDipClass==SIP_DIP_CLASS_ROUTING)
	{
		pPktHdr->fwdDecision=RG_FWD_DECISION_ROUTING;
		
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		ret = _rtk_rg_fwdEngine_L2L3_TcpUdpConnectionTracking(pPktHdr);
		if(pPktHdr->ipv4FragPacket)
		{
			ret = _rtk_rg_L2L3_fragmentHandler(pPktHdr, skb, ret);
		}
		if(ret!=RG_FWDENGINE_RET_CONTINUE) return ret;
#else	// not CONFIG_RG_FLOW_BASED_PLATFORM
		//20160908LUKE: only TCP and UDP will add to shortcut.
		pPktHdr->shortcutStatus = (pPktHdr->tagif&(TCP_TAGIF|UDP_TAGIF)) ? RG_SC_NEED_UPDATE : RG_SC_NORMAL_PATH;
#endif
		if((rg_db.redirectHttpAll.enable||rg_db.redirectHttpCount.enable)&&
			(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)&&(pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->dport==rg_db.systemGlobal.httpMonitorPort))
		{
			int naptOutIdx=FAIL;
			_check_Http_mechanism(pPktHdr,&naptOutIdx);

			//prevent from adding to shortcut
			pPktHdr->shortcutStatus = RG_SC_NORMAL_PATH;
		}

		//dump_packet(skb->data,skb->len,"org");
		TRACE("Routing...modify packet and update shortcut");
		ret = _rtk_rg_fwdEngine_naptPacketModify(NAPT_DIRECTION_ROUTING,FAIL,pPktHdr,skb,0,0);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		if(pPktHdr->L2L3FragListIdx!=FAIL && pPktHdr->ipv4MoreFragment && pPktHdr->ipv4FragmentOffset==0)
		{
			rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].fragAction = ret;
			assert_ok(_rtk_rg_L2L3_fragmentQueueProcessing(pPktHdr, rg_db.L2L3FragList[pPktHdr->L2L3FragListIdx].fragAction));
		}
#endif
		if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;		//TO PS or DROP
		//assert_ok(ret);

		return RG_FWDENGINE_RET_DIRECT_TX;
	}

	TRACE("[To PS] classfication type is to PS");
	return RG_FWDENGINE_RET_TO_PS;
}

static rtk_rg_fwdEngineReturn_t _rtk_rg_multicastRxCheck(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr, int pid)
{

	unsigned int  vlanRelayPortMask=0;

	if(RTK_RG_ALL_CPU_PORTMASK & (0x1<<pPktHdr->ingressPort))
		return RG_FWDENGINE_RET_CONTINUE;
	if(((pPktHdr->pDmac[0]==0x01 && pPktHdr->pDmac[1]==0x00 && pPktHdr->pDmac[2]==0x5e) ||
	    (((pPktHdr->pDmac[0]&1)==0)&&((pPktHdr->tagif&(PPPOE_TAGIF|IPV4_TAGIF))==(PPPOE_TAGIF|IPV4_TAGIF))&&(pPktHdr->ipv4Dip>=0xe0000000))
	   ))
	{
		if(pPktHdr->tagif&IGMP_TAGIF && rg_db.systemGlobal.multicastProtocol!=RG_MC_MLD_ONLY)
		{
			rtl_igmpMldProcess(rg_db.systemGlobal.nicIgmpModuleIndex, skb->data, pPktHdr, pid, &vlanRelayPortMask);
			//20130722:multicast should continue to broadcast module in fwdEngine, not directly return to protocol stack
		}
	}



	if ((pPktHdr->pDmac[0]==0x33 && pPktHdr->pDmac[1]==0x33 && pPktHdr->pDmac[2]!=0xff) ||
		(((pPktHdr->pDmac[0]&1)==0)&&((pPktHdr->tagif&(PPPOE_TAGIF|IPV6_TAGIF))==(PPPOE_TAGIF|IPV6_TAGIF))&&(pPktHdr->pIpv6Dip[0]==0xff)))	//for pppoe_multicast_v6
	{
		if(pPktHdr->tagif&IPV6_MLD_TAGIF && rg_db.systemGlobal.multicastProtocol!=RG_MC_IGMP_ONLY)
		{
			/*icmpv6 packet*/
			rtl_igmpMldProcess(rg_db.systemGlobal.nicIgmpModuleIndex, skb->data, pPktHdr, pid, &vlanRelayPortMask);
			//20130722:multicast should continue to broadcast module in fwdEngine, not directly return to protocol stack
		}
	}


	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngineDestinationLookup(rtk_rg_pktHdr_t *pPktHdr)
{
	//First use packet's vlan value to find SVL or IVL,
	//then use packet header's Destination Mac address to look up for the destination port
	rtk_fidMode_t fidMode;
	int l2Idx,VLANId,FId,EFId,i,search_index;
	rtk_rg_lut_linkList_t *pSoftLut;

	if(pPktHdr->netifIdx==FAIL)	//L2
	{
		//DEBUG("$$$$$$$$$$$$$$$$ in %s, the pkthdr internal VID is %d",__FUNCTION__,pPktHdr->internalVlanID);
		VLANId=pPktHdr->internalVlanID;
		fidMode=rg_db.vlan[VLANId].fidMode;
		FId=rg_db.vlan[VLANId].fid;
		EFId=0;		//FIXME:we did not store efid right now
	}
	else
	{
		//DEBUG("$$$$$$$$$$$$$$ the netif idx is %d",pPktHdr->netifIdx);
		if(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.is_wan)
		{
			VLANId=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
			fidMode=rg_db.vlan[VLANId].fidMode;
			FId=rg_db.vlan[VLANId].fid;
			EFId=0;		//FIXME:we did not store efid right now
			//DEBUG("WAN!! pPktHdr->netifIdx is %d, VLANID is %d",pPktHdr->netifIdx,VLANId);
		}
		else
		{
			VLANId=rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo.lan_intf.intf_vlan_id;
			fidMode=rg_db.vlan[VLANId].fidMode;
			FId=rg_db.vlan[VLANId].fid;
			EFId=0;		//FIXME:we did not store efid right now
			//DEBUG("LAN!! pPktHdr->netifIdx is %d, VLANID is %d",pPktHdr->netifIdx,VLANId);
		}
	}

	if(fidMode==VLAN_FID_IVL)
		l2Idx=_rtk_rg_hash_mac_vid_efid(pPktHdr->pDmac,VLANId,EFId);
	else
		l2Idx=_rtk_rg_hash_mac_fid_efid(pPktHdr->pDmac,FId,EFId);

	l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
	for(i=0;i<MAX_LUT_HASH_WAY_SIZE;i++)
	{
		search_index=l2Idx+i;
		if(rg_db.lut[search_index].valid==0)
			continue;

		if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
			(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pPktHdr->pDmac,ETHER_ADDR_LEN)==0))
		{
			if((fidMode==VLAN_FID_IVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==VLANId) ||
				(fidMode==VLAN_FID_SVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==FId))
			{
				//rg_kernel.txDescMask.tx_tx_portmask=0x3f;
				//rg_kernel.txDescMask.tx_l34_keep=1;

				//rg_kernel.txDesc.tx_tx_portmask=0x1<<rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port;
				//rg_kernel.txDesc.tx_l34_keep=0;
				//DEBUG("lookup! to portmask %x",0x1<<rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port);
				goto LUT_FOUND;
			}
		}
	}
	if(i==MAX_LUT_HASH_WAY_SIZE)
	{
		//Check bCAM LUT, if match, just return
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
		{
			if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
			{
				if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pPktHdr->pDmac,ETHER_ADDR_LEN)==0)
				{
					if((fidMode==VLAN_FID_IVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==VLANId) ||
					(fidMode==VLAN_FID_SVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==FId))
					{
						//HIT!
						goto LUT_FOUND;
					}
				}
			}
		}
	}

	//look up software LUT link-list
	if(!list_empty(&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT]))
	{
		list_for_each_entry(pSoftLut,&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT],lut_list)
		{
			if(memcmp(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.mac.octet,pPktHdr->pDmac,ETHER_ADDR_LEN)==0)
			{
				if((fidMode==VLAN_FID_IVL && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid==VLANId) ||
				(fidMode==VLAN_FID_SVL && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.fid==FId))
				{
					//HIT!
					search_index=pSoftLut->idx;
					goto LUT_FOUND;
				}
			}
		}
	}

	TRACE("DA Lookup Fail: unknown DA..do broadcast!");
	//unknown DA rate limit check
	if(rg_db.systemGlobal.unKnownDARateLimitPortMask&(1<<(pPktHdr->ingressPort)))
	{
		if(_rtk_rg_unknownDARateLimit_check(pPktHdr->skb,pPktHdr)==RG_FWDENGINE_RET_DROP)
			return RG_FWDENGINE_RET_DROP;
	}
	pPktHdr->fwdDecision=RG_FWD_DECISION_NO_PS_BC;		//do not goto protocol stack!
	pPktHdr->directTxResult=_rtk_rg_broadcastForwardWithPkthdr(pPktHdr,pPktHdr->skb,pPktHdr->internalVlanID,pPktHdr->ingressMacPort,pPktHdr->ingressPort);
	if(pPktHdr->forwardCount==0)
	{
		TRACE("MC/BC packet do not be forwarded to any port(excludes To PS)");
		if(rg_db.systemGlobal.fwdStatistic)
			rg_db.systemGlobal.statistic.perPortCnt_MCBC_DROP[pPktHdr->ingressPort]++;
	}
	pPktHdr->dmacL2Idx = FAIL;
	return RG_FWDENGINE_RET_CONTINUE;
LUT_FOUND:
	pPktHdr->dmacL2Idx = search_index;
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngineVLANFiltering(uint32 vlanId, rtk_rg_mac_port_idx_t mac_port, rtk_rg_mac_ext_port_idx_t mac_extPort, rtk_rg_mbssidDev_t wlan_dev)
{
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
{
	rtk_rg_port_idx_t portIdx;
	if(wlan_dev >= 0)
	{
		_rtk_rg_wlanDevToPort_translator(wlan_dev, &portIdx);
		_rtk_rg_portToMacPort_translator(portIdx, &mac_port, &mac_extPort);
		TRACE("Translate wlanDevIdx[%d] into port(%d) extPort(%d) to do vlan filtering.", wlan_dev, mac_port, mac_extPort);
	}
}
#endif
#endif
	TRACE("Filter VLAN(%d) by using port(%d) extPort(%d)", vlanId, mac_port, mac_extPort);
	if(_rtk_rg_isVlanMember(vlanId, mac_port, mac_extPort))
	{
		return RG_FWDENGINE_RET_CONTINUE;
	}
	else
	{
		return RG_FWDENGINE_RET_DROP;
	}
}

int _rtk_rg_fwdEngineMacFilter(rtk_rg_pktHdr_t *pPktHdr)
{
	int32 l2Idx;

	//SA
	l2Idx=_rtk_rg_macLookup(pPktHdr->pSmac,pPktHdr->internalVlanID, TRUE);
	if(l2Idx!=FAIL && l2Idx<MAX_LUT_HW_TABLE_SIZE)
	{
		if(rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_SA_BLOCK)
		{
			TRACE("[Drop] Drop by SA macfilter!");
			return (RG_FWDENGINE_RET_DROP);
		}
	}

	//DA
	l2Idx=_rtk_rg_macLookup(pPktHdr->pDmac,pPktHdr->internalVlanID, TRUE);
	if(l2Idx!=FAIL && l2Idx<MAX_LUT_HW_TABLE_SIZE)
	{
		if(rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_DA_BLOCK)
		{
			TRACE("[Drop] Drop by DA macfilter!");
			return (RG_FWDENGINE_RET_DROP);
		}
	}

	return (RG_FWDENGINE_RET_CONTINUE);
}

rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngineDMAC2CVIDTransfer(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	//Use packet header's Destination Mac address to look up for the vlanid and destination port
	int VLANId;
	int aclRet;
	int i,naptIdx=0;
	int bridge_netf_idx=FAIL;
#if defined(CONFIG_RG_RTL9602C_SERIES)
	int isEgressFiltering=1;
#endif

	//20150528LUKE: only non-shortcut will do dport lookup and egress ACL
	//Assign Port
	pPktHdr->egressMacPort=rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.port;
	pPktHdr->egressMacExtPort=rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.ext_port;
	TRACE("dmacL2Idx[%d] port(%d) extPort(%d) ", pPktHdr->dmacL2Idx, pPktHdr->egressMacPort, pPktHdr->egressMacExtPort);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
	_rtk_rg_egressExtPort_translator(pPktHdr);
#endif

	//20140711LUKE:only apply egressVlanId and netif when egressMacPort is in WAN
	if((0x1<<pPktHdr->egressMacPort)&rg_db.systemGlobal.wanPortMask.portmask){
		if(pPktHdr->layer2BindNetifIdx!=FAIL){//binding to bridgeWan
			pPktHdr->netifIdx=pPktHdr->layer2BindNetifIdx;
			_rtk_rg_interfaceVlanIDPriority(pPktHdr,&rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo,NULL);
			TRACE("Apply Binding interface index:%d, egress VLAN changes to %d",pPktHdr->netifIdx,pPktHdr->egressVlanID);
		}
	}

#if defined(CONFIG_RG_RTL9602C_SERIES)
	DEBUG("rg_db.systemGlobal.dmac2cvidDisabledPortmask=0x%x, force disbled DAMC2CVID to port[%d]!",rg_db.systemGlobal.dmac2cvidDisabledPortmask, pPktHdr->egressMacPort);
	if(rg_db.systemGlobal.dmac2cvidDisabledPortmask & (1<<pPktHdr->egressMacPort))//force diabled PON DAMC2CVID
	{
		TRACE("rg_db.systemGlobal.dmac2cvidDisabledPortmask=0x%x, force disbled DAMC2CVID to port[%d]!",rg_db.systemGlobal.dmac2cvidDisabledPortmask, pPktHdr->egressMacPort);
	}
	else
	{
		//20150925LUKE: for 9602C, vlan egress filtering should include DMAC2CVID decision!
		//20170314: Check IVL/SVL of lut entry of dmac to do dmac2cvid action
		if((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0
			&& ((rg_db.systemGlobal.svlan_EP_DMAC_CTRL_pmsk.portmask&(0x1<<(rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.port))) || (pPktHdr->egressMacPort==RTK_RG_MAC_PORT_CPU)))
		{
			//assign DMAC2CVID to internalVlanID !!
			pPktHdr->internalVlanID = rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.vid;
			//if((pPktHdr->tagif&CVLAN_TAGIF)==0)
			if((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)==0)
			{
				TRACE("Disable Egress filtering");
				isEgressFiltering=0;
			}
			//pPktHdr->dmac2VlanID = VLANId;
			//pPktHdr->dmac2VlanTagif=((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)>0);
			//TRACE("Do DMAC2CVID before filtering...VID=%d(%s)",VLANId,pPktHdr->dmac2VlanTagif?"TAGGED":"UNTAG");
		}
	}
#endif

	//20140707LUKE:since DMAC2CVID only change VLANID and tagif in hw, we should use egressVlanID to check egress filterv before DMAC2CVID!!
	//20150325CHUCK: egress vlan filter should filter internal VLAN(not include CF and DAM2CVID)
	//20150924LUKE: for 9602C, egress vlan filter contains DMAC2CVID decision!!
	//VLAN egress filter
	if (
#if defined(CONFIG_RG_RTL9602C_SERIES)
	(isEgressFiltering) &&
#endif
	(_rtk_rg_fwdEngineVLANFiltering(pPktHdr->internalVlanID,pPktHdr->egressMacPort,pPktHdr->egressMacExtPort, FAIL)==RG_FWDENGINE_RET_DROP)
	)
	{
		TRACE("[Drop] drop by VLAN(%d) Egress filter",pPktHdr->internalVlanID);
		return RG_FWDENGINE_RET_DROP;
	}

	//20150520LUKE: for packet from protocol stack we should keep its original format of cvlan if keepPsOrigCvlan is on.
	if(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK && rg_db.systemGlobal.keepPsOrigCvlan)
	{
		pPktHdr->egressVlanTagif=(pPktHdr->tagif&CVLAN_TAGIF?1:0);
		pPktHdr->egressPriority=(pPktHdr->tagif&CVLAN_TAGIF?pPktHdr->ctagPri:0);
	}
	else	//does not from protocol stack (or keepPsOrigCvlan is off).
	{
		VLANId = pPktHdr->egressVlanID;
		if(rg_db.vlan[VLANId].UntagPortmask.bits[0]&(0x1<<pPktHdr->egressMacPort)){
			TRACE("%s:untagged!", (rg_db.vlan[VLANId].fidMode==VLAN_FID_IVL)?"IVL":"SVL");
			pPktHdr->egressVlanTagif=0;
		}else{
			TRACE("%s:tagged!", (rg_db.vlan[VLANId].fidMode==VLAN_FID_IVL)?"IVL":"SVL");
			pPktHdr->egressVlanTagif=1;
		}

		//do dmac2cvid if lut entry of dmac is SVL
		if((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)==0)
		{
			//Check if we turn on DMAC2CVID or not
			//20150925LUKE: for 9602C, dmac2VlanID would be decided above, so check it here!
			//20150313LUKE: from protocol stack should do DMAC2CVID, too!!
			//20140715LUKE:binding and packet from protocol stack won't proceed DMAC2CVID!
			if(rg_db.systemGlobal.initParam.macBasedTagDecision
#if !defined(CONFIG_RG_RTL9602C_SERIES)	// BINDING > DMAC2CVID in 9600 and 9607C,  DMAC2CVID > BINDING in 9602C.
				&& pPktHdr->layer2BindNetifIdx==FAIL 				//no Layer2 binding
				&& pPktHdr->bindNextHopIdx==FAIL 					//no Layer34 binding
#endif
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				&& 	(pPktHdr->aclDecision.qos_actions&ACL_ACTION_ACL_CVLANTAG_BIT)==0x0	//not hit CF, do damc2cvid
#endif
			)
			{
				//Get VLANId from LUT, it will be 0 if learned by untag!
				VLANId=rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.vid;
				//pPktHdr->egressVlanID = VLANId; //egress VID change to DMAC2CVID
				pPktHdr->dmac2VlanID = VLANId;
				//if(rg_db.vlan[VLANId].fidMode==VLAN_FID_SVL)
#if defined(CONFIG_RG_RTL9600_SERIES)
				if(VLANId==0)
#else
				if((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)==0)
#endif
				{
					TRACE("dmac2cvid:untagged!");
					pPktHdr->dmac2VlanTagif=0;
				}else if((rg_db.systemGlobal.fix_l34_to_untag_enable) && (rg_db.lut[pPktHdr->dmacL2Idx].fix_l34_vlan) &&
						(pPktHdr->fwdDecision == RG_FWD_DECISION_ROUTING ||
						 pPktHdr->fwdDecision == RG_FWD_DECISION_V6ROUTING ||
						 pPktHdr->fwdDecision == RG_FWD_DECISION_NAPT ||
						 pPktHdr->fwdDecision == RG_FWD_DECISION_NAPTR))
				{
					MACLN("For smart STB issue: Do not add vlan %d for router packet!!",VLANId);
					TRACE("dmac2cvid:L34 untagged!");
					pPktHdr->dmac2VlanTagif=0;
				}else
				{
					//Assign VLAN by DMAC2CVID, and this VLAN should be the same with VLAN above
					TRACE("dmac2cvid:tagged!");
					pPktHdr->dmac2VlanTagif=1;
				}
			}
		}

		if(pPktHdr->egressVlanTagif==1 || pPktHdr->dmac2VlanTagif==1)
		{
			//Qos remarking: Chuck
			if(rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[pPktHdr->egressMacPort])
			{
				TRACE("QoS dop1p Remarking by port[%d]:%s, CRI %d",pPktHdr->egressMacPort,rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPriEgressPortEnable[pPktHdr->egressMacPort]?"ENABLED":"DISABLED",rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPri[pPktHdr->internalPriority]);
				//record egressPri
				pPktHdr->egressPriority=rg_db.systemGlobal.qosInternalDecision.qosDot1pPriRemarkByInternalPri[pPktHdr->internalPriority];
			}
		}
		//DSCP remarking:Chuck
		_rtk_rg_qosDscpRemarking(pPktHdr->egressMacPort,pPktHdr,skb);
	}


	if((0x1<<pPktHdr->egressMacPort)&rg_db.systemGlobal.wanPortMask.portmask){//from Lan to Wan
		if(pPktHdr->layer2BindNetifIdx!=FAIL){//binding to bridgeWan
			bridge_netf_idx=pPktHdr->layer2BindNetifIdx;
		}else if(pPktHdr->netifIdx==FAIL){//normal bridge to bridgeWan
			//search the egress wan interface by egressVLAN
			for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++){
				if( (pPktHdr->isGatewayPacket==0) && (pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK/*none local out*/) && rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo!=NULL && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf!=NULL &&
					rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE){
					if(rg_db.systemGlobal.initParam.macBasedTagDecision){

#if defined(CONFIG_RG_RTL9600_SERIES)
						if(rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.vid==0 && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on==0){//get the bridgeWan netif_index from DMAC2CVID (untag bridgeWan)
							//check the bridgeWan netif index by vlanID from DMAC2CVID
							bridge_netf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
							TRACE("Apply Normal BridgeWan interface index:%d, upstream egress VLAN is %d with DMAC2CVID (internal VLAN is %d)",bridge_netf_idx,pPktHdr->egressVlanID,pPktHdr->internalVlanID);
						}else if(rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.vid!=0 && rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.vid==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id){//get the bridgeWan netif_index from DMAC2CVID (Lan/bridgeWan with different VLAN)
							//check the bridgeWan netif index by vlanID from DMAC2CVID
							bridge_netf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
							TRACE("Apply Normal BridgeWan interface index:%d, upstream egress VLAN is %d with DMAC2CVID (internal VLAN is %d)",bridge_netf_idx,pPktHdr->egressVlanID,pPktHdr->internalVlanID);
						}
#else	// support ctag_if
						if((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_CTAG_IF)==0x0 && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_tag_on==0){//get the bridgeWan netif_index from DMAC2CVID (untag bridgeWan)
							//check the bridgeWan netif index by vlanID from DMAC2CVID
							bridge_netf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
							TRACE("Apply Normal BridgeWan interface index:%d, upstream egress VLAN is %d with DMAC2CVID (internal VLAN is %d)",bridge_netf_idx,pPktHdr->egressVlanID,pPktHdr->internalVlanID);
						}else if((rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_CTAG_IF) && rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.vid==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id){//get the bridgeWan netif_index from DMAC2CVID (Lan/bridgeWan with different VLAN)
							//check the bridgeWan netif index by vlanID from DMAC2CVID
							bridge_netf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
							TRACE("Apply Normal BridgeWan interface index:%d, upstream egress VLAN is %d with DMAC2CVID (internal VLAN is %d)",bridge_netf_idx,pPktHdr->egressVlanID,pPktHdr->internalVlanID);
						}
#endif

					}else{
						if(pPktHdr->internalVlanID==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id){//get the bridgeWan netif_index
							//check the bridgeWan netif index by internal vlanID
							bridge_netf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
							TRACE("Apply Normal BridgeWan interface index:%d, upstream egress VLAN is %d wouthout DMAC2CVID (internal VLAN is %d)",bridge_netf_idx,pPktHdr->egressVlanID,pPktHdr->internalVlanID);
						}
					}
				}
			}
		}
	}
//20181130LUKE: since we could not specify ingress interface index from same vlan bridges, so let ACL to do the decision!
#if 0
	else if((0x1<<pPktHdr->ingressPort)&rg_db.systemGlobal.wanPortMask.portmask){//from Wan to Lan
		//search the ingress wan interface by ingressVLAN(bridgeWan: ingressVLAN==internalVLAN)
		for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++){
			if( (pPktHdr->isGatewayPacket==0) && (pPktHdr->isLocalInNapt==0 /*none local in*/) && rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo!=NULL && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf!=NULL &&
				rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE){

				if(pPktHdr->internalVlanID==rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id){//get the bridgeWan netif_index (Wan to Lan compare by internal Vlan)
					bridge_netf_idx=rg_db.systemGlobal.wanIntfGroup[i].index;
					TRACE("Apply Normal BridgeWan interface index:%d, downstream (internal VLAN is %d)",bridge_netf_idx,pPktHdr->internalVlanID);
				}
			}
		}
	}
#endif
	//20140916 Chuck: Supporting IPv4/IPv6 portocal drop by Wan_type
	if(bridge_netf_idx!=FAIL && rg_db.systemGlobal.interfaceInfo[bridge_netf_idx].valid && rg_db.systemGlobal.interfaceInfo[bridge_netf_idx].storedInfo.is_wan==1){
		if(rg_db.systemGlobal.bridge_netIfIdx_drop_by_portocal[bridge_netf_idx]==1){//drop IPv6
			//bridgeWan for IPv4_only, drop IPv6 related packet
			if(pPktHdr->etherType==RG_IPV6_ETHERTYPE || pPktHdr->pppProtocal==0x8057 || pPktHdr->pppProtocal==0x0057){
				TRACE("[Drop] Drop by IPv4_only bridgeWan");
				return RG_FWDENGINE_RET_DROP;
			}

		}
		if(rg_db.systemGlobal.bridge_netIfIdx_drop_by_portocal[bridge_netf_idx]==2){//drop IPv4
			//bridgeWan for IPv6_only, drop IPv4 related packet
			if(pPktHdr->etherType==RG_IPV4_ETHERTYPE || pPktHdr->pppProtocal==0x8021 || pPktHdr->pppProtocal==0x0021){
				TRACE("[Drop] Drop by IPv6_only bridgeWan");
				return RG_FWDENGINE_RET_DROP;
			}
		}
		//20200121LUKE:check per interface MLD/IGMP forbidden bit.
		if(pPktHdr->layer2BindNetifIdx==FAIL && (((pPktHdr->tagif&IGMP_TAGIF) && rg_db.systemGlobal.interfaceInfo[bridge_netf_idx].storedInfo.wan_intf.wan_intf_conf.forbiddenUnbindIGMP)||
			((pPktHdr->tagif&IPV6_MLD_TAGIF) && rg_db.systemGlobal.interfaceInfo[bridge_netf_idx].storedInfo.wan_intf.wan_intf_conf.forbiddenUnbindMLD)))
		{
			TRACE("[Drop] Drop by wan %s-unbindForbidden",(pPktHdr->tagif&IGMP_TAGIF)?"IGMP":"MLD");
			return RG_FWDENGINE_RET_DROP;
		}
	}

	//especial filter IPCP/IP6CP with especial vid for port_binding_by_protocal
	if((0x1<<pPktHdr->ingressPort)&rg_db.systemGlobal.wanPortMask.portmask){//ingress  from Wan
		if(((pPktHdr->tagif&CVLAN_TAGIF)&&(pPktHdr->ctagVid==rg_db.systemGlobal.port_binding_by_protocal_filter_vid))||
			(((pPktHdr->tagif&CVLAN_TAGIF)== 0x0)&&(0==rg_db.systemGlobal.port_binding_by_protocal_filter_vid))){//packet with assigned PPPoE Vid decision
			if(rg_db.systemGlobal.port_binding_by_protocal==1 && pPktHdr->isGatewayPacket==0){//IPv4 Routing, IPv6 Bridge => drop downstream IPCP
				if(pPktHdr->etherType==RG_PPPOES_ETHERTYPE && (pPktHdr->pppProtocal==0x8021 || pPktHdr->pppProtocal==0x0021)){
					TRACE("[Drop] IPCP drop by  binding by protocal, IPv4 us routing");
					return RG_FWDENGINE_RET_DROP;
				}

			}else if(rg_db.systemGlobal.port_binding_by_protocal==2 && pPktHdr->isGatewayPacket==0){//IPv6 Routing, IPv4 Bridge => drop downstream IP6CP
				if(pPktHdr->etherType==RG_PPPOES_ETHERTYPE && ( pPktHdr->pppProtocal==0x8057 || pPktHdr->pppProtocal==0x0057)){
					TRACE("[Drop] IP6CP drop by  binding by protocal, IPv6 is routing");
					return RG_FWDENGINE_RET_DROP;
				}
			}
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//decide bridge egress interface
	if(pPktHdr->netifIdx==FAIL)
	{
		rtk_rg_port_idx_t egressPort;
		uint16 	egressVlanID;
		uint8 	egressVlanTagif; //0:untag  1:tagged

		//20181113LUKE: we should lookup wan interface by egress VLAN for normal bridge.
		//decide egress ctag format
		/*if(pPktHdr->dmac2VlanID!=FAIL
			&& ((pPktHdr->fwdDecision==RG_FWD_DECISION_BRIDGING && pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK) || !(rg_db.systemGlobal.dmac2cvidDisabledPortmask & (1<<pPktHdr->egressMacPort))))
		{
			egressVlanID=pPktHdr->dmac2VlanID;
			egressVlanTagif=pPktHdr->dmac2VlanTagif;
		}
		else*/
		{
			egressVlanID=pPktHdr->egressVlanID;
			egressVlanTagif=pPktHdr->egressVlanTagif;
		}
		_rtk_rg_macPortToPort_translator(&egressPort, pPktHdr->egressMacPort, pPktHdr->egressMacExtPort);

		pPktHdr->netifIdx = _rtk_rg_decideNetIfIdx(egressPort, pPktHdr->egressMacPort, (egressVlanTagif)?1:0, egressVlanID);
	}
#endif
	{
		//Do ACL egress check
		if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT){
			naptIdx = pPktHdr->naptOutboundIndx;
		}else if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPTR){
			naptIdx = pPktHdr->naptrInboundIndx;
		}
		assert_ok(_rtk_rg_egressACLPatternCheck(pPktHdr->fwdDecision,naptIdx,pPktHdr,skb,pPktHdr->l3Modify,pPktHdr->l4Modify,pPktHdr->egressMacPort));
		 ACL("call to _rtk_rg_egressACLAction by FWD_DMAC2CVID	direct=%d",pPktHdr->fwdDecision);
		aclRet = _rtk_rg_egressACLAction(pPktHdr->fwdDecision,pPktHdr);
		if(aclRet==RG_FWDENGINE_RET_DROP){
			TRACE("[Drop] Drop by Egress ACL Action");
			return RG_FWDENGINE_RET_DROP;
		}else if(aclRet==RG_FWDENGINE_RET_TO_PS){
			TRACE("[To PS] Trap by Egress ACL Action");
			return RG_FWDENGINE_RET_TO_PS;
		}
	}

	//Modify Packet by ACL actions: L2/L34 qos action act here.
	aclRet = _rtk_rg_modifyPacketByACLAction(skb,pPktHdr,pPktHdr->egressMacPort);
	if(aclRet==RG_FWDENGINE_RET_DROP){
		TRACE("[Drop] Drop by Egress ACL Action: final forward to 0x0");
		return RG_FWDENGINE_RET_DROP;
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	// flow-based cpri
	if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPT)
	{
		if(pPktHdr->naptOutboundIndx>=0 && rg_db.naptOut[pPktHdr->naptOutboundIndx].dst_cpri_en)
		{
			pPktHdr->egressPriority = rg_db.naptOut[pPktHdr->naptOutboundIndx].dst_cpri;
			TRACE("flow-based cpri of outbound NAPT[%d] is %d", pPktHdr->naptOutboundIndx, pPktHdr->egressPriority);
		}
	}
	else if(pPktHdr->fwdDecision==RG_FWD_DECISION_NAPTR)
	{
		if(pPktHdr->naptOutboundIndx>=0 && rg_db.naptOut[pPktHdr->naptOutboundIndx].src_cpri_en)
		{
			pPktHdr->egressPriority = rg_db.naptOut[pPktHdr->naptOutboundIndx].src_cpri;
			TRACE("flow-based cpri of inbound NAPT[%d] is %d", pPktHdr->naptOutboundIndx, pPktHdr->egressPriority);
		}
	}
	else if(pPktHdr->fwdDecision==RG_FWD_DECISION_ROUTING || pPktHdr->fwdDecision==RG_FWD_DECISION_V6ROUTING || pPktHdr->fwdDecision==RG_FWD_DECISION_BRIDGING)
	{
		if(pPktHdr->tcpUdpTrackingGroupIdx>=0)
		{
			if(rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx].sip == ((pPktHdr->tagif&IPV4_TAGIF)?pPktHdr->ipv4Sip:pPktHdr->tcpUdpTracking_ipv6SipHash))
			{
				if(rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx].dst_cpri_en)
				{
					pPktHdr->egressPriority = rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx].dst_cpri;
					TRACE("flow-based dst_cpri of L2/L3 tracking connection[%d] is %d", pPktHdr->tcpUdpTrackingGroupIdx, pPktHdr->egressPriority);
				}
			}
			else
			{
				if(rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx].src_cpri_en)
				{
					pPktHdr->egressPriority = rg_db.flowTcpUdpTrackingGroupList[pPktHdr->tcpUdpTrackingGroupIdx].src_cpri;
					TRACE("flow-based src_cpri of L2/L3 tracking connection[%d] is %d", pPktHdr->tcpUdpTrackingGroupIdx, pPktHdr->egressPriority);
				}
			}
		}
	}
#endif

	if(pPktHdr->shortcutStatus==RG_SC_NEED_UPDATE_BEFORE_SEND){
#ifdef CONFIG_ROME_NAPT_SHORTCUT
		//update vlan, priority, dscp, and streamID to shortcut
		TRACE("RG_SC_NEED_UPDATE_BEFORE_SEND!! SC_addr=[%p] VLAN[%d] Pri[%d] SVLANTAGIF[%d] SVLAN[%d] SPri[%d] dscp[%d]!!",pPktHdr->pCurrentShortcutEntry,pPktHdr->egressVlanID,pPktHdr->egressPriority,pPktHdr->egressServiceVlanTagif,pPktHdr->egressServiceVlanID,pPktHdr->egressServicePriority,pPktHdr->egressDSCP);
		if(pPktHdr->pCurrentShortcutEntry->isBridge)
		{
			pPktHdr->pCurrentShortcutEntry->new_lut_idx=pPktHdr->dmacL2Idx;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			pPktHdr->pCurrentShortcutEntry->new_intf_idx=pPktHdr->netifIdx;
#endif
		}
#ifdef CONFIG_GPON_FEATURE
		pPktHdr->pCurrentShortcutEntry->streamID=pPktHdr->streamID;
#endif
		pPktHdr->pCurrentShortcutEntry->vlanID=pPktHdr->egressVlanID;
		pPktHdr->pCurrentShortcutEntry->vlanTagif=pPktHdr->egressVlanTagif;
		pPktHdr->pCurrentShortcutEntry->serviceVlanID=pPktHdr->egressServiceVlanID;
		pPktHdr->pCurrentShortcutEntry->serviceVlanTagif=pPktHdr->egressServiceVlanTagif;
		pPktHdr->pCurrentShortcutEntry->dmac2cvlanID=pPktHdr->dmac2VlanID;
		pPktHdr->pCurrentShortcutEntry->dmac2cvlanTagif=pPktHdr->dmac2VlanTagif;
		//pPktHdr->pCurrentShortcutEntry->macPort=pPktHdr->egressMacPort;
		//pPktHdr->pCurrentShortcutEntry->extPort=pPktHdr->egressMacExtPort;
		pPktHdr->pCurrentShortcutEntry->priority=pPktHdr->egressPriority;
		pPktHdr->pCurrentShortcutEntry->servicePriority=pPktHdr->egressServicePriority;
		pPktHdr->pCurrentShortcutEntry->internalVlanID=pPktHdr->internalVlanID;
		pPktHdr->pCurrentShortcutEntry->internalCFPri=pPktHdr->internalPriority;
		pPktHdr->pCurrentShortcutEntry->dscp=pPktHdr->egressDSCP;
		pPktHdr->pCurrentShortcutEntry->uniPortmask=pPktHdr->egressUniPortmask;
		pPktHdr->pCurrentShortcutEntry->naptFilterRateLimitIdx = pPktHdr->naptFilterRateLimitIdx;
		pPktHdr->pCurrentShortcutEntry->naptFilterPktCntIdx = pPktHdr->naptFilterPktCntIdx;
		pPktHdr->pCurrentShortcutEntry->naptFilterByteCnttIdx = pPktHdr->naptFilterByteCnttIdx;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->pCurrentShortcutEntry->flowmib_idx = pPktHdr->flowMIBCounterIdx;
#endif
		pPktHdr->pCurrentShortcutEntry->pAlgConn = pPktHdr->pAlgConn;

#if defined(CONFIG_RG_RTL9602C_SERIES)
		//mib counter and cf decision
		pPktHdr->pCurrentShortcutEntry->mibNetifIdx=pPktHdr->mibNetifIdx;
		pPktHdr->pCurrentShortcutEntry->mibDirect=pPktHdr->mibDirect;
#endif
		if(pPktHdr->pLocalInNaptShortcutEntry!=NULL)
			pPktHdr->pLocalInNaptShortcutEntry->smacL2Idx = pPktHdr->dmacL2Idx;
		if(pPktHdr->isLocalInNapt) pPktHdr->pCurrentShortcutEntry->notFinishUpdated=0;
#endif
	}
#ifdef CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT
	else if(pPktHdr->shortcutStatus==RG_SC_V6_NEED_UPDATE_BEFORE_SEND){
		//update vlan, priority, dscp, and streamID to shortcut
		TRACE("RG_SC_V6_NEED_UPDATE_BEFORE_SEND!! v6SC_addr=[%p] VLAN[%d] Pri[%d] SVLANTAGIF[%d] SVLAN[%d] SPri[%d] dscp[%d]!!",pPktHdr->pCurrentV6ShortcutEntry,pPktHdr->egressVlanID,pPktHdr->egressPriority,pPktHdr->egressServiceVlanTagif,pPktHdr->egressServiceVlanID,pPktHdr->egressServicePriority,pPktHdr->egressDSCP);
		if(pPktHdr->pCurrentV6ShortcutEntry->isBridge)
		{
			pPktHdr->pCurrentV6ShortcutEntry->new_lut_idx=pPktHdr->dmacL2Idx;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			pPktHdr->pCurrentV6ShortcutEntry->new_intf_idx=pPktHdr->netifIdx;
#endif
		}
#ifdef CONFIG_GPON_FEATURE
		pPktHdr->pCurrentV6ShortcutEntry->streamID=pPktHdr->streamID;
#endif
		pPktHdr->pCurrentV6ShortcutEntry->vlanID=pPktHdr->egressVlanID;
		pPktHdr->pCurrentV6ShortcutEntry->vlanTagif=pPktHdr->egressVlanTagif;
		pPktHdr->pCurrentV6ShortcutEntry->serviceVlanID=pPktHdr->egressServiceVlanID;
		pPktHdr->pCurrentV6ShortcutEntry->serviceVlanTagif=pPktHdr->egressServiceVlanTagif;
		pPktHdr->pCurrentV6ShortcutEntry->dmac2cvlanID=pPktHdr->dmac2VlanID;
		pPktHdr->pCurrentV6ShortcutEntry->dmac2cvlanTagif=pPktHdr->dmac2VlanTagif;
		//pPktHdr->pCurrentV6ShortcutEntry->macPort=pPktHdr->egressMacPort;
		//pPktHdr->pCurrentV6ShortcutEntry->extPort=pPktHdr->egressMacExtPort;
		pPktHdr->pCurrentV6ShortcutEntry->priority=pPktHdr->egressPriority;
		pPktHdr->pCurrentV6ShortcutEntry->servicePriority=pPktHdr->egressServicePriority;
		pPktHdr->pCurrentV6ShortcutEntry->internalVlanID=pPktHdr->internalVlanID;
		pPktHdr->pCurrentV6ShortcutEntry->internalCFPri=pPktHdr->internalPriority;
		pPktHdr->pCurrentV6ShortcutEntry->dscp=pPktHdr->egressDSCP;
		pPktHdr->pCurrentV6ShortcutEntry->uniPortmask=pPktHdr->egressUniPortmask;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->pCurrentV6ShortcutEntry->flowmib_idx = pPktHdr->flowMIBCounterIdx;
#endif
#if defined(CONFIG_RG_RTL9602C_SERIES)
		//mib counter and cf decision
		pPktHdr->pCurrentV6ShortcutEntry->mibNetifIdx=pPktHdr->mibNetifIdx;
		pPktHdr->pCurrentV6ShortcutEntry->mibDirect=pPktHdr->mibDirect;
#endif
	}
#endif
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	else if(pPktHdr->shortcutStatus==RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND){
		//update vlan, priority, dscp, and streamID to stateful linkList
		TRACE("RG_SC_STATEFUL_NEED_UPDATE_BEFORE_SEND!! linkList=[%p] VLAN[%d] Pri[%d] SVLANTAGIF[%d] SVLAN[%d] SPri[%d] dscp[%d]!!",pPktHdr->pIPv6StatefulList,pPktHdr->egressVlanID,pPktHdr->egressPriority,pPktHdr->egressServiceVlanTagif,pPktHdr->egressServiceVlanID,pPktHdr->egressServicePriority,pPktHdr->egressDSCP);
#ifdef CONFIG_GPON_FEATURE
		pPktHdr->pIPv6StatefulList->streamID=pPktHdr->streamID;
#endif
		pPktHdr->pIPv6StatefulList->vlanID=pPktHdr->egressVlanID;
		pPktHdr->pIPv6StatefulList->vlanTagif=pPktHdr->egressVlanTagif;
		pPktHdr->pIPv6StatefulList->serviceVlanID=pPktHdr->egressServiceVlanID;
		pPktHdr->pIPv6StatefulList->serviceVlanTagif=pPktHdr->egressServiceVlanTagif;
		pPktHdr->pIPv6StatefulList->dmac2cvlanID=pPktHdr->dmac2VlanID;
		pPktHdr->pIPv6StatefulList->dmac2cvlanTagif=pPktHdr->dmac2VlanTagif;
		pPktHdr->pIPv6StatefulList->macPort=pPktHdr->egressMacPort;
		pPktHdr->pIPv6StatefulList->extPort=pPktHdr->egressMacExtPort;
		pPktHdr->pIPv6StatefulList->priority=pPktHdr->egressPriority;
		pPktHdr->pIPv6StatefulList->servicePriority=pPktHdr->egressServicePriority;
		pPktHdr->pIPv6StatefulList->internalVlanID=pPktHdr->internalVlanID;
		pPktHdr->pIPv6StatefulList->internalCFPri=pPktHdr->internalPriority;
		pPktHdr->pIPv6StatefulList->dscp=pPktHdr->egressDSCP;
		pPktHdr->pIPv6StatefulList->uniPortmask=pPktHdr->egressUniPortmask;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		pPktHdr->pIPv6StatefulList->flowmib_idx = pPktHdr->flowMIBCounterIdx;
#endif
#if defined(CONFIG_RG_RTL9602C_SERIES)
		//mib counter and cf decision
		pPktHdr->pIPv6StatefulList->mibNetifIdx=pPktHdr->mibNetifIdx;
		pPktHdr->pIPv6StatefulList->mibDirect=pPktHdr->mibDirect;
#endif
	}
#endif

	return RG_FWDENGINE_RET_CONTINUE;
}

#ifdef CONFIG_RG_WLAN_HWNAT_ACCELERATION
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngineWIFITransfer(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_port_idx_t egressPort;

	_rtk_rg_macPortToPort_translator(&egressPort, pPktHdr->egressMacPort, pPktHdr->egressMacExtPort);

	if((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<egressPort))
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<egressPort))
#endif
		) // to wifi device of master cpu
	
	{
		TRACE("send to wifi device of master cpu");

		if(_rtk_master_wlan_mbssid_tx(pPktHdr,skb)==RG_RET_MBSSID_NOT_FOUND)
		{
			TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			pPktHdr->addPureL2Flow = FALSE;
#endif
			_rtk_rg_dev_kfree_skb_any(skb);
		}
		return RG_FWDENGINE_RET_SEND_TO_WIFI;
	}
#ifdef CONFIG_DUALBAND_CONCURRENT
	else if(RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<egressPort)) // to wifi device of slave cpu
	{
		TRACE("send to wifi device of slave cpu, do hardware lookup");

		if(unlikely(pPktHdr->dmacL2Idx>=MAX_LUT_HW_TABLE_SIZE))
		{
			TRACE("hit software LUT...change egressVID to %d,pri to %d",CONFIG_DEFAULT_TO_SLAVE_GMAC_VID,CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI);
			pPktHdr->egressVlanID=CONFIG_DEFAULT_TO_SLAVE_GMAC_VID;
			pPktHdr->egressVlanTagif=1;
			pPktHdr->egressPriority=CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI;
			//dismiss DMAC2CVID decision
			pPktHdr->dmac2VlanID=FAIL;
		}
		return RG_FWDENGINE_RET_HWLOOKUP;
	}
#endif

	// to CPU
	pPktHdr->fwdDecision=RG_FWD_DECISION_TO_PS;
	TRACE("[To PS] egressMacPort is cpu port, but egressMacExtPort is neither Ext0 nor Ext1");
	return RG_FWDENGINE_RET_TO_PS;
}
#endif

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngineCheckDestination(rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_fwdEngineReturn_t ret;

	if(pPktHdr->dmacL2Idx<0||pPktHdr->dmacL2Idx>=MAX_LUT_SW_TABLE_SIZE)
	{
		//20150909LUKE:pPktHdr->dmacL2Idx will be assigned at _rtk_rg_fwdEngineDestinationLookup
		ret=_rtk_rg_fwdEngineDestinationLookup(pPktHdr);
		if(ret!=RG_FWDENGINE_RET_CONTINUE)
			return ret;
		if(pPktHdr->dmacL2Idx<0||pPktHdr->dmacL2Idx>=MAX_LUT_SW_TABLE_SIZE)
		{
			TRACE("Direct tx result of broadcast: %d", pPktHdr->directTxResult);
			return pPktHdr->directTxResult;
		}
	}
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	if((0<=pPktHdr->dmacL2Idx && pPktHdr->dmacL2Idx<MAX_LUT_SW_TABLE_SIZE)
		&& (rg_db.lut[pPktHdr->dmacL2Idx].idleSecs>=rg_db.systemGlobal.l2_timeout))
	{
		TRACE("Dmac's L2 index is timeout, do broadcast!");
		pPktHdr->fwdDecision = RG_FWD_DECISION_NO_PS_BC;		//do not goto protocol stack!
		pPktHdr->directTxResult = _rtk_rg_broadcastForwardWithPkthdr(pPktHdr,pPktHdr->skb,pPktHdr->internalVlanID,pPktHdr->ingressMacPort,pPktHdr->ingressPort);
		if(pPktHdr->forwardCount==0)
		{
			TRACE("MC/BC packet do not be forwarded to any port(excludes To PS)");
			if(rg_db.systemGlobal.fwdStatistic)
				rg_db.systemGlobal.statistic.perPortCnt_MCBC_DROP[pPktHdr->ingressPort]++;
		}
		return pPktHdr->directTxResult;
	}
#endif

#if defined(CONFIG_RG_RTL9600_SERIES)
	TRACE("DA Lookup Success: DmacL2Idx[%d], PhyPort(%d), ExtPort(%d), Cvid(%d), egressVlanID(%d)", pPktHdr->dmacL2Idx, rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.port, rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.ext_port, rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.ctag_vid, pPktHdr->egressVlanID);
#else	// support ctag_if
	TRACE("DA Lookup Success: DmacL2Idx[%d], PhyPort(%d), ExtPort(%d), Cvid(%d), CtagIf(%d), egressVlanID(%d)", pPktHdr->dmacL2Idx, rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.port, rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.ext_port, rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.ctag_vid, (rg_db.lut[pPktHdr->dmacL2Idx].rtk_lut.entry.l2UcEntry.flags & RTK_L2_UCAST_FLAG_CTAG_IF)?1:0, pPktHdr->egressVlanID);
#endif

	if(pPktHdr->shortcutStatus==RG_SC_MATCH){
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
		_rtk_rg_egressExtPort_translator(pPktHdr);
#endif
		if(pPktHdr->egressDSCP>=0){
			//uint8 tos;
			if(pPktHdr->tagif&IPV6_TAGIF){
				//dscp is the MSB 6 bits of traffic class
				//tos = pPktHdr->egressDSCP>>0x2; //dscp MSB 4 bits
				//tos |= (*pPktHdr->pTos)&0xf0;		//keep version 4 bits
				//*pPktHdr->pTos=tos;
				*pPktHdr->pTos = (pPktHdr->egressDSCP>>0x2)|((*pPktHdr->pTos)&0xf0);

				//tos = (pPktHdr->egressDSCP&0x3)<<0x6;	//dscp LSB 2 bits
				//tos |= (*(pPktHdr->pTos+1))&0x3f;		//keep original traffic label LSB 2 bits and flow label MSB 4 bits
				//*(pPktHdr->pTos+1)=tos;
				*(pPktHdr->pTos+1) = ((pPktHdr->egressDSCP&0x3)<<0x6)|((*(pPktHdr->pTos+1))&0x3f);
			}else if(pPktHdr->tagif&IPV4_TAGIF){
				//tos = pPktHdr->egressDSCP<<0x2;
				//tos |= (*pPktHdr->pTos)&0x3;		//keep 2 bits from LSB
				//*pPktHdr->pTos=tos; 	//remarking tos of packet
				*pPktHdr->pTos = (pPktHdr->egressDSCP<<0x2)|((*pPktHdr->pTos)&0x3);
			}
		}
		if(pPktHdr->egressECN>=0){
			if(pPktHdr->tagif&IPV6_TAGIF){
				//ecn is the LSB 2 bits of traffic class, keep original dscp LSB 2 bits and flow label MSB 4 bits
				*(pPktHdr->pTos+1) = ((pPktHdr->egressECN)<<0x4)|((*(pPktHdr->pTos+1))&0xcf);
			}else if(pPktHdr->tagif&IPV4_TAGIF){
				*pPktHdr->pTos = (pPktHdr->egressECN)|((*pPktHdr->pTos)&0xfc);
			}
		}
	}else{
		ret=_rtk_rg_fwdEngineDMAC2CVIDTransfer(pPktHdr->skb,pPktHdr);
		if(ret!=RG_FWDENGINE_RET_CONTINUE)return ret;
	}

	if(RTK_RG_ALL_MAC_CPU_PORTMASK&(0x1<<pPktHdr->egressMacPort))
	{
#ifdef CONFIG_RG_WLAN_HWNAT_ACCELERATION
		return _rtk_rg_fwdEngineWIFITransfer(pPktHdr->skb,pPktHdr);
#else
		//20151130LUKE: forward to CPU here!
		pPktHdr->fwdDecision=RG_FWD_DECISION_TO_PS;
		TRACE("[To PS] egressMacPort is cpu port.");
		return RG_FWDENGINE_RET_TO_PS;
#endif
	}

	//Record egress tos value
	if(pPktHdr->tagif & (IPV4_TAGIF|IPV6_TAGIF))
		pPktHdr->egr_tos = *pPktHdr->pTos;

	return RG_FWDENGINE_RET_DIRECT_TX;
}

__IRAM_FWDENG
rtk_rg_fwdEngineReturn_t _rtk_rg_fwdEngineDirectTx(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{

	//VLAN and Priority can retrived from shortcut. if match!!
	if(pPktHdr->shortcutStatus!=RG_SC_MATCH){	//normal path
		_rtk_rg_interfaceVlanIDPriority_directTX(pPktHdr,&rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].storedInfo,&rg_kernel.txDesc);
	}

#if defined(CONFIG_RG_LAYER2_SOFTWARE_LEARN)
	//To Master Wifi or unknown DA will return here!
{
	rtk_rg_fwdEngineReturn_t ret;
	//To Master Wifi or unknown DA will return FAIL and just return here!
	ret=_rtk_rg_fwdEngineCheckDestination(pPktHdr);
	TRACE("Check Destination:%d",ret);
	switch(ret)
	{
		case RG_FWDENGINE_RET_SEND_TO_WIFI:
			TRACE("Send to wifi!");
			return ret;
		case RG_FWDENGINE_RET_TO_PS:
			TRACE("To PS!");
			return ret;
		case RG_FWDENGINE_RET_DROP:
			TRACE("Drop!");
			return ret;
		default:
			break;
	}
}
#endif


	//20141210LUKE: recalculate unicast packets' IP-checksum for pppoe WAN if DSCP remarking
	//20150731LUKE:we don't use egressTagIf to check because bridge packet from protocol stack will be needed recalculate ckecksum if dscp remarking, either.
	if(pPktHdr->tagif&IPV4_TAGIF)*pPktHdr->pIpv4Checksum=htons(_rtk_rg_fwdengine_L3checksumUpdateDSCP(ntohs(*pPktHdr->pIpv4Checksum), pPktHdr->ipv4HeaderLen, pPktHdr->tos, *pPktHdr->pTos));

	//20141002LUKE: remove outter IP header, GRE header, PPP header
	//20141017LUKE: remove outter IP header, UDP header, L2TP header, PPP header
	//20150206LUKE: remove outter IPv6 header
	if(pPktHdr->tagif&PPTP_INNER_TAGIF||pPktHdr->tagif&L2TP_INNER_TAGIF||pPktHdr->tagif&DSLITE_INNER_TAGIF||pPktHdr->tagif&VXLAN_TAGIF){
		TRACE("Remove Tunnel tag");
		_rtk_rg_removeTunnelTag(pPktHdr);
	}

	//clear old value
	rg_kernel.txDesc.opts1.dw=0;
	rg_kernel.txDesc.opts2.dw=0;
	rg_kernel.txDesc.opts3.dw=0;
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	rg_kernel.txDesc.opts4.dw=0;
#endif

	//turn on txInfo mask, otherwise value won't be add
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	rg_kernel.txDesc.tx_cputag_ipcs=0;	//disable switch L3 offload
	rg_kernel.txDesc.tx_cputag_l4cs=0;	//disable switch L4 offload
#endif
#if defined(CONFIG_RG_RTL9600_SERIES)
	//20160331LUKE: checksum by sw offload
	//20141222LUKE: disable PPPoE L3 offload
	if(pPktHdr->egressTagif&PPPOE_TAGIF
#if defined(CONFIG_GPON_FEATURE)
		&&(rg_db.systemGlobal.gpon_pppoe_status!=GPON_PPPOE_MODE_SW_OFFLOAD)
#endif
	)
		rg_kernel.txDesc.tx_ipcs=0;
	else
#endif
		rg_kernel.txDesc.tx_ipcs=1;

	rg_kernel.txDesc.tx_dislrn=1;			//disable HW to check and learn SA, prevent port-moving to CPU
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	rg_kernel.txDesc.tx_keep=0;				//dirtx case: keep must be zero.
#else
	rg_kernel.txDesc.tx_keep=1;				//20141104LUKE: when L34Keep is on, Keep is also needed for gpon.
#endif
	rg_kernel.txDesc.tx_l34_keep=1;			//ensure switch won't modify or filter packet

	//Assign tx port mask before return
	rg_kernel.txDesc.tx_tx_portmask=0x1<<pPktHdr->egressMacPort;

	_rtk_rg_egressPacketSend(skb,pPktHdr);
		return RG_FWDENGINE_RET_DIRECT_TX;
}

void _rtk_rg_fwdEngineHwLookup(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	//clear old value
	rg_kernel.txDesc.opts1.dw=0;
	rg_kernel.txDesc.opts2.dw=0;
	rg_kernel.txDesc.opts3.dw=0;
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	rg_kernel.txDesc.opts4.dw=0;
#endif

	//turn on txInfo mask, otherwise value won't be add

	//2 REC20131203:from protocol stack packets, the CVLAN info will be carried by skb->vlan_tci,
	//2 therefore we should not override it by txDescMask and txDesc!!

#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RG_RTL9602C_SERIES)
	rg_kernel.txDesc.tx_cputag_ipcs=0;	//disable switch L3 offload
	rg_kernel.txDesc.tx_cputag_l4cs=0;	//disable switch L4 offload
#endif


	if((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<pPktHdr->ingressPort))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
		|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<pPktHdr->ingressPort))
#endif
		)
	{
		//rg_kernel.txDesc.tx_cvlan_vidl=1;
		//rg_kernel.txDesc.tx_tx_cvlan_action=3;
		rg_kernel.txDesc.tx_extspa=0x1;
		rg_kernel.txDesc.tx_dislrn=0;	// if packet is from extension port, must auto learn to hw.
	}
	else
	{
		rg_kernel.txDesc.tx_dislrn=1;		//disable HW to check and learn SA, prevent port-moving to CPU
	}

	//20141222LUKE: disable PPPoE L3 offload
	if(pPktHdr->egressTagif&PPPOE_TAGIF)
		rg_kernel.txDesc.tx_ipcs=0;
	else
		rg_kernel.txDesc.tx_ipcs=1;

	//20140528LUKE:for ipv4, we recaculate Layer4 checksum if napt; for ipv6, we just keep the original value
	//20140902LUKE: for packet from shortcut won't be fragmented, so let hw do layer4 checksum.
	//20141203LUKE: for fagment packet, we shoud disable hw L4 checksum offload.
	//20141222LUKE: disable PPPoE L4 offload
	//20161207LUKE: for apollo or apolloFE, GMAC won't recalculate checksum when receive IPv6 packet with fragment extension header.
	if((pPktHdr->egressTagif&PPPOE_TAGIF)||(pPktHdr->egressTagif&PPTP_TAGIF)||(pPktHdr->tagif&V6FRAG_TAGIF)||(pPktHdr->ipv6FragPacket)||(pPktHdr->ipv4FragPacket))
		rg_kernel.txDesc.tx_l4cs=0;
	else
		rg_kernel.txDesc.tx_l4cs=1;

	//CPri remarking: Chuck
	//Patch20131122:GMAC disable deTAG function, therefore we just keep packet VLAN status "INTACT"!
#if 0
	if(pRxDesc->rx_ctagva){//original packet with vlanTag, keep original value.
		//TRACE("Original CTag: 0x%x",pRxDesc->rx_cvlan_tag);
		rg_kernel.txDescMask.tx_tx_cvlan_action=0x3;
		rg_kernel.txDescMask.tx_cvlan_vidl=0xff;
		rg_kernel.txDescMask.tx_cvlan_vidh=0xf;
		rg_kernel.txDescMask.tx_cvlan_prio=0x7;
		rg_kernel.txDescMask.tx_cvlan_cfi=0x1;

		rg_kernel.txDesc.tx_tx_cvlan_action=0x3;//remark
		rg_kernel.txDesc.tx_cvlan_vidh=((pRxDesc->rx_cvlan_tag))&0xf;
		rg_kernel.txDesc.tx_cvlan_vidl=((pRxDesc->rx_cvlan_tag)>>8)&0xff;
		rg_kernel.txDesc.tx_cvlan_prio=((pRxDesc->rx_cvlan_tag)>>5)&0x7;
		rg_kernel.txDesc.tx_cvlan_cfi=((pRxDesc->rx_cvlan_tag))&0x1;

	}else{//original packet without vlan
		rg_kernel.txDescMask.tx_tx_cvlan_action=0x3;
		rg_kernel.txDesc.tx_tx_cvlan_action=0x2;//remove
	}
#else
	rg_kernel.txDesc.tx_tx_cvlan_action=0x0;//intact
#endif

	//DSCP Remarking: Chuck
	//DSCP will handeled by HW Qos API. No need to modify.


	/*DEBUG("before hardware lookup");
	dump_packet(skb->data,skb->len,"hardward lookup");
	DEBUG("txDesc.opts1 is %x, txDesc.opts2 is %x,txDesc.opts3 is %x",
		rg_kernel.txDesc.opts1.dw,rg_kernel.txDesc.opts2.dw,rg_kernel.txDesc.opts3.dw);
	DEBUG("txDescMask.opts1 is %x, txDescMask.opts2 is %x,txDescMask.opts3 is %x",
		rg_kernel.txDescMask.opts1.dw,rg_kernel.txDescMask.opts2.dw,rg_kernel.txDescMask.opts3.dw);*/
	_rtk_rg_egressPacketSend(skb,pPktHdr);
	//_rtk_rg_splitJumboSendToNicWithTxInfoAndMask(pPktHdr,skb,(struct tx_info*)&rg_kernel.txDesc,0,(struct tx_info*)&rg_kernel.txDescMask);
}

//LAN Interface Multilayer-Decision-Base Control.
void _rtk_rg_fwdEngineLIMDBC(rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	//initialize
	pPktHdr->isGatewayPacket=0;

	/* lookup DA in netIf table */
	for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
	{
		if(rg_db.netif[i].rtk_netif.valid == 1)
		{
			if(memcmp(pPktHdr->pDmac,rg_db.netif[i].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN)==0)
			{
				pPktHdr->isGatewayPacket=1;
				//20140811LUKE: keep the ingress net interface!!
				pPktHdr->srcNetifIdx=i;
				break;
			}
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	//rechoose ingress interface if dip of packet is different from ip address of matched interface
	if( (!IS_CLASSD_ADDR(pPktHdr->ipv4Dip)) && ((0x1<<pPktHdr->ingressPort) & rg_db.systemGlobal.wanPortMask.portmask) && (pPktHdr->tagif&IPV4_TAGIF)
		&& pPktHdr->isGatewayPacket && pPktHdr->srcNetifIdx!=FAIL
		&& (/*rg_db.netif[pPktHdr->srcNetifIdx].rtk_netif.ipAddr!=0 && */rg_db.netif[pPktHdr->srcNetifIdx].rtk_netif.ipAddr!=pPktHdr->ipv4Dip))
	{
		uint32 firstMatchedIntf = pPktHdr->srcNetifIdx;
		for(i=firstMatchedIntf+1; i<MAX_NETIF_SW_TABLE_SIZE; i++)
		{
			if(rg_db.netif[i].rtk_netif.valid==1)
			{
				if(memcmp(pPktHdr->pDmac, rg_db.netif[i].rtk_netif.gateway_mac.octet, ETHER_ADDR_LEN)==0
					&& (rg_db.netif[i].rtk_netif.ipAddr!=0 && rg_db.netif[i].rtk_netif.ipAddr==pPktHdr->ipv4Dip))
				{
					pPktHdr->srcNetifIdx=i;
					break;
				}
			}
		}
		if(firstMatchedIntf==pPktHdr->srcNetifIdx)
		{
			DEBUG("Downstream ingress L34 intf[%d]'s ip(0x%x) is different from packet's dip(0x%x)", pPktHdr->srcNetifIdx, rg_db.netif[pPktHdr->srcNetifIdx].rtk_netif.ipAddr, pPktHdr->ipv4Dip);
		}
	}
#endif
}

rtk_rg_successFailReturn_t _rtk_rg_lutReachLimit_clearARPNeighbor(int l2Idx, rtk_rg_saLearningLimitProbe_t *limitInfo)
{
	//find all L34 table used this l2Idx, and clear them. Finally clear l2Idx also.
	MACLN("L2[%d] is deleting now!!",l2Idx);
	(pf.rtk_rg_macEntry_del)(l2Idx);

	atomic_set(&limitInfo->activity,0);
	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_lutReachLimit_sendARPAndModTimer(rtk_rg_saLearningLimitProbe_t *limitInfo)
{
	int intfIdx,routingIdx;
	ipaddr_t gwipAddr;

	limitInfo->arpReq.finished=0;
	limitInfo->arpReq.gwMacReqCallBack=NULL;
	limitInfo->arpReq.reqIp=limitInfo->v4IP;
	limitInfo->arpReq.disableL3Inspect=0;
	routingIdx=_rtk_rg_l3lookup(limitInfo->v4IP);
	intfIdx=rg_db.l3[routingIdx].rtk_l3.netifIdx;
	gwipAddr=rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.lan_intf.ip_addr;
	_rtk_rg_arpGeneration(intfIdx,gwipAddr,&limitInfo->arpReq);
	//increase counter, modify timer, return
	limitInfo->arpCounter++;
	_rtk_rg_mod_timer(&limitInfo->timer, jiffies+(TICKTIME_PERIOD*rg_db.systemGlobal.wanAccessLimit_interval/1000));

	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_lutReachLimit_sendNeighborAndModTimer(rtk_rg_saLearningLimitProbe_t *limitInfo)
{
	int netIfIdx;
	rtk_ipv6_addr_t ipAddr;

	netIfIdx=rg_db.v6route[limitInfo->v6Route].rtk_v6route.nhOrIfidIdx;

	memcpy(ipAddr.ipv6_addr,rg_db.systemGlobal.interfaceInfo[netIfIdx].storedInfo.lan_intf.ipv6_addr.ipv6_addr,IPV6_ADDR_LEN);
	limitInfo->neighborReq.finished=0;
	limitInfo->neighborReq.ipv6GwMacReqCallBack=NULL;
	memcpy(limitInfo->neighborReq.reqIp.ipv6_addr,limitInfo->v6IP.ipv6_addr,IPV6_ADDR_LEN);
	_rtk_rg_NDGeneration(netIfIdx,ipAddr,&limitInfo->neighborReq);
	//increase counter, modify timer, return
	limitInfo->neighborCounter++;
	_rtk_rg_mod_timer(&limitInfo->timer, jiffies+(TICKTIME_PERIOD*rg_db.systemGlobal.wanAccessLimit_interval/1000));
	return RG_RET_SUCCESS;
}

//SUCCESS: 1. ARP or Neighbor had been sent. 2. the MAC and ARP(Neighbor) had been cleared.
//FAIL: this MAC is on-line, continue to next
rtk_rg_successFailReturn_t _rtk_rg_lutReachLimit_lookup(int l2Idx, rtk_rg_saLearningLimitProbe_t *limitInfo)
{
	int i;

	if(limitInfo->neighborIdx>=0)
	{
		if(limitInfo->neighborCounter==3)
		{
			//off-line, clear all ARP and Neighbor reference this MAC
			MACLN("the l2Idx[%d] maybe off-line...kick it out!!",l2Idx);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//20170126LUKE: check version for flow-based or not.
			if(CONFIG_RG_ACCESSWAN_VERSION==3)
				_rtk_rg_l34WanAccessLimit_delL2Idx(l2Idx);
#endif
			return _rtk_rg_lutReachLimit_clearARPNeighbor(l2Idx,limitInfo);
		}
		if(limitInfo->neighborCounter!=-1)
		{
			//send Neighbor Discovery for the IPv6
			MACLN("ask the l2Idx[%d] for response by Neighbor Discovery...",l2Idx);
			return _rtk_rg_lutReachLimit_sendNeighborAndModTimer(limitInfo);
		}

		//reach here means MAC on-line, search another Neighbor
		goto Next_Neighbor;
	}

	if(limitInfo->arpIdx>=0)
	{
		MACLN("the arpIdx is %d, l2Idx is %d, counter is %d",limitInfo->arpIdx,l2Idx,limitInfo->arpCounter);
		//check counter
		if(limitInfo->arpCounter==3)
		{
			//off-line, clear all ARP and Neighbor reference this MAC
			MACLN("the l2Idx[%d] maybe off-line...kick it out!!",l2Idx);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//20170126LUKE: check version for flow-based or not.
			if(CONFIG_RG_ACCESSWAN_VERSION==3)
				_rtk_rg_l34WanAccessLimit_delL2Idx(l2Idx);
#endif
			return _rtk_rg_lutReachLimit_clearARPNeighbor(l2Idx,limitInfo);
		}
		if(limitInfo->arpCounter!=-1)
		{
			//send ARP request for the IP
			MACLN("ask the l2Idx[%d] for response by ARP request...",l2Idx);
			return _rtk_rg_lutReachLimit_sendARPAndModTimer(limitInfo);
		}

		//reach here means MAC on-line, search another ARP
		MACLN("search another ARP...");
	}

	//lookup ARP for the l2Idx, if no ARP, goto Send_Neighbor
	for(i=limitInfo->arpIdx+1;i<MAX_ARP_SW_TABLE_SIZE;i++)
	{
		if(rg_db.arp[i].rtk_arp.valid && rg_db.arp[i].rtk_arp.nhIdx==l2Idx)
		{
			//Hit!!
			limitInfo->arpIdx=i;
			limitInfo->v4IP=rg_db.arp[i].ipv4Addr;
			limitInfo->arpCounter=0;
			//send ARP request for the IP
			MACLN("ARP[%d]->[%x] found! ask the l2Idx[%d] for response by ARP request...",i,rg_db.arp[i].ipv4Addr,l2Idx);
			return _rtk_rg_lutReachLimit_sendARPAndModTimer(limitInfo);
		}
	}
	MACLN("find new neighbor");

Next_Neighbor:
	//lookup Neighbor for the l2Idx, if no Neighbor, find next MAC
	for(i=limitInfo->neighborIdx+1;i<MAX_IPV6_NEIGHBOR_SW_TABLE_SIZE;i++)
	{
		if(rg_db.v6neighbor[i].neighborEntry.valid && rg_db.v6neighbor[i].neighborEntry.l2Idx==l2Idx)
		{
			//Hit!!
			limitInfo->neighborIdx=i;
			limitInfo->v6Route=rg_db.v6neighbor[i].neighborEntry.matchRouteIdx;
			//20180420LUKE: neighbor keep originally complete address now.
			memcpy(limitInfo->v6IP.ipv6_addr,rg_db.v6neighbor[i].neighborEntry.interfaceId,IPV6_ADDR_LEN);
			limitInfo->neighborCounter=0;
			//send Neighbor Discovery for the IPv6
			MACLN("Neighbor[%d]->[%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x] found! ask the l2Idx[%d] for response by Neighbor Discovery...",i,
				limitInfo->v6IP.ipv6_addr[0],limitInfo->v6IP.ipv6_addr[1],limitInfo->v6IP.ipv6_addr[2],limitInfo->v6IP.ipv6_addr[3],
				limitInfo->v6IP.ipv6_addr[4],limitInfo->v6IP.ipv6_addr[5],limitInfo->v6IP.ipv6_addr[6],limitInfo->v6IP.ipv6_addr[7],
				limitInfo->v6IP.ipv6_addr[8],limitInfo->v6IP.ipv6_addr[9],limitInfo->v6IP.ipv6_addr[10],limitInfo->v6IP.ipv6_addr[11],
				limitInfo->v6IP.ipv6_addr[12],limitInfo->v6IP.ipv6_addr[13],limitInfo->v6IP.ipv6_addr[14],limitInfo->v6IP.ipv6_addr[15],
				l2Idx);
			return _rtk_rg_lutReachLimit_sendNeighborAndModTimer(limitInfo);
		}
	}
	MACLN("no more arp or neighbor can ask..");

	//reach here means no ARP or Neighbor of this MAC any more
	//return _rtk_rg_lutReachLimit_clearARPNeighbor(l2Idx,limitInfo);
	limitInfo->arpIdx=-1;
	limitInfo->neighborIdx=-1;
	return RG_RET_FAIL;

}

void _rtk_rg_lutReachLimit_portmask(unsigned long portmsk)
{
	int i=0;
	rtk_rg_successFailReturn_t ret=RG_RET_FAIL;
	unsigned int phyPortmask=portmsk&0xffff;
#ifdef CONFIG_MASTER_WLAN0_ENABLE
	unsigned int wlan0Devmask=(portmsk>>16)&0xffff;
#endif
	rtk_rg_port_idx_t portIdx;


	if(atomic_read(&rg_kernel.lutReachLimit_portmask.activity)==0)
		return;

	//lookup LUT for MAC at all port under system port-mask, search ARP first and Neighbor later
	if(rg_kernel.lutReachLimit_portmask.l2Idx!=-1)
	{
		MACLN("Lookup for previous-l2Idx[%d] at PORTMASK[%lx]...",rg_kernel.lutReachLimit_portmask.l2Idx,phyPortmask);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
		MACLN("Also lookup for previous-l2Idx[%d] at WLAN0DEVMASK[%lx]...",rg_kernel.lutReachLimit_portmask.l2Idx,wlan0Devmask);
#endif
		ret=_rtk_rg_lutReachLimit_lookup(rg_kernel.lutReachLimit_portmask.l2Idx,&rg_kernel.lutReachLimit_portmask);
		if(ret==RG_RET_SUCCESS)
			return;
		else
		{
			i=rg_kernel.lutReachLimit_portmask.l2Idx+1;
			rg_kernel.lutReachLimit_portmask.l2Idx=-1;
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	for(;i<MAX_LUT_HW_TABLE_SIZE;i++)
#else
	for(;i<MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;i++)
#endif
	{
		if(rg_db.lut[i].valid && rg_db.lut[i].rtk_lut.entryType==RTK_LUT_L2UC && !(rg_db.lut[i].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC))
		{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//20170126LUKE: check version for flow-based or not.
			if(CONFIG_RG_ACCESSWAN_VERSION==3){
				// only care the l2idx saved in WANAccessLimit table
				int32 walIdx = 0;
				uint8 found = FALSE;
				// only care the l2idx saved in WANAccessLimit table
				for(walIdx = 0, found = FALSE; walIdx < MAX_WANACCESSLIMIT_TABLE_SIZE; walIdx++)
					if(rg_db.wanAccessLimit[walIdx].wanAllowEnt.valid && rg_db.wanAccessLimit[walIdx].wanAllowEnt.sa_idx == i)
						found = TRUE;
				if(!found)
					continue;
			}else
#endif
			{
				_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[i].rtk_lut.entry.l2UcEntry.port, rg_db.lut[i].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
				_rtk_rg_lutExtport_translator(&portIdx);
#endif
				if(phyPortmask&(0x1<<portIdx))
				{
					//Match system port-mask!
					MACLN("Lookup for l2Idx[%d] of PORT_IDX[%d] at PORTMASK[%lx]...",i,portIdx,phyPortmask);
					rg_kernel.lutReachLimit_portmask.l2Idx=i;
					ret=_rtk_rg_lutReachLimit_lookup(i,&rg_kernel.lutReachLimit_portmask);
					if(ret==RG_RET_SUCCESS)
						break;
				}
				if(portIdx > RTK_RG_PORT_LASTCPU)
				{

#ifdef CONFIG_MASTER_WLAN0_ENABLE
					if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
						|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
						) && rg_db.lut[i].wlan_device_idx>=0)
					{
						if(wlan0Devmask&(0x1<<rg_db.lut[i].wlan_device_idx))
						{
							//Match system port-mask!
							MACLN("Lookup for l2Idx[%d] of WLAN0DEV[%d] at DEVMASK[%lx]...",i,rg_db.lut[i].wlan_device_idx,wlan0Devmask);
							rg_kernel.lutReachLimit_portmask.l2Idx=i;
							ret=_rtk_rg_lutReachLimit_lookup(i,&rg_kernel.lutReachLimit_portmask);
							if(ret==RG_RET_SUCCESS)
								break;
						}
					}
#endif
				}
			}
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(i==MAX_LUT_HW_TABLE_SIZE)
#else
	if(i==MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE)
#endif
	{
		atomic_inc(&rg_kernel.lutReachLimit_portmask.activity);
		MACLN("#### activity is %d",atomic_read(&rg_kernel.lutReachLimit_portmask.activity)-1);
	}

	if(atomic_read(&rg_kernel.lutReachLimit_portmask.activity)>0)
	{
		//20170126LUKE: check version for flow-based or not.
		if(CONFIG_RG_ACCESSWAN_VERSION!=3){
			if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)ret=RG_RET_FAIL;
			else ret=RG_RET_SUCCESS;//limit by sip won't add sw lut, so omit here.
			for(i=MAX_LUT_HW_TABLE_SIZE;i<MAX_LUT_SW_TABLE_SIZE;i++)
			{
				if(rg_db.lut[i].valid && rg_db.lut[i].rtk_lut.entryType==RTK_LUT_L2UC)
				{
					_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[i].rtk_lut.entry.l2UcEntry.port, rg_db.lut[i].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
					_rtk_rg_lutExtport_translator(&portIdx);
#endif
					//portmask may change, so we have to use global variable to check!
					if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx))
					{
						ret=RG_RET_SUCCESS;
						break;
					}
					if(portIdx > RTK_RG_PORT_LASTCPU)
					{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
							) && rg_db.lut[i].wlan_device_idx>=0)
						{
							if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<rg_db.lut[i].wlan_device_idx))
							{
								ret=RG_RET_SUCCESS;
								break;
							}
						}
#endif
					}
				}
			}
		}

		if(ret==RG_RET_FAIL || atomic_read(&rg_kernel.lutReachLimit_portmask.activity)>MAX_WanAccessARPCount)
			atomic_set(&rg_kernel.lutReachLimit_portmask.activity,0);
		else
			_rtk_rg_mod_timer(&rg_kernel.lutReachLimit_portmask.timer, jiffies+(TICKTIME_PERIOD*rg_db.systemGlobal.wanAccessLimit_interval/1000));	//not found.. and still have software LUTwaiting...repeat after seconds
	}

	return;
}

void _rtk_rg_lutReachLimit_category(unsigned long category)
{
	int i=0,ret=SUCCESS;

	if(atomic_read(&rg_kernel.lutReachLimit_category[category].activity)==0)
		return;

	//lookup LUT for MAC at same category, search ARP first and Neighbor later
	if(rg_kernel.lutReachLimit_category[category].l2Idx!=-1)
	{
		MACLN("Lookup for previous-l2Idx[%d] at CATEGORY[%ld]...",rg_kernel.lutReachLimit_category[category].l2Idx,category);
		ret=_rtk_rg_lutReachLimit_lookup(rg_kernel.lutReachLimit_category[category].l2Idx,&rg_kernel.lutReachLimit_category[category]);
		if(ret==SUCCESS)
			return;
		else
		{
			i=rg_kernel.lutReachLimit_category[category].l2Idx+1;
			rg_kernel.lutReachLimit_category[category].l2Idx=-1;
		}
	}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	for(;i<MAX_LUT_HW_TABLE_SIZE;i++)
#else
	for(;i<MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;i++)
#endif
	{
		if(rg_db.lut[i].valid && rg_db.lut[i].rtk_lut.entryType==RTK_LUT_L2UC && !(rg_db.lut[i].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC) && rg_db.lut[i].category==category)
		{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//20170126LUKE: check version for flow-based or not.
			if(CONFIG_RG_ACCESSWAN_VERSION==3){
				// only care the l2idx saved in WANAccessLimit table
				int32 walIdx = 0;
				uint8 found = FALSE;
				for(walIdx = 0; walIdx < MAX_WANACCESSLIMIT_TABLE_SIZE; walIdx++)
					if(rg_db.wanAccessLimit[walIdx].wanAllowEnt.valid && rg_db.wanAccessLimit[walIdx].wanAllowEnt.sa_idx == i)
						found = TRUE;
				if(!found)
					continue;
			}
#endif

			//Match same category!
			MACLN("Lookup for l2Idx[%d] at CATEGORY[%ld]...",i,category);
			rg_kernel.lutReachLimit_category[category].l2Idx=i;
			ret=_rtk_rg_lutReachLimit_lookup(i,&rg_kernel.lutReachLimit_category[category]);
			if(ret==SUCCESS)
				break;
		}
	}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(i==MAX_LUT_HW_TABLE_SIZE)
#else
	if(i==MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE)
#endif
	{
		atomic_inc(&rg_kernel.lutReachLimit_category[category].activity);
		MACLN("#### activity is %d",atomic_read(&rg_kernel.lutReachLimit_category[category].activity)-1);
	}

	if(atomic_read(&rg_kernel.lutReachLimit_category[category].activity)>0)
	{
		//20170126LUKE: check version for flow-based or not.
		if(CONFIG_RG_ACCESSWAN_VERSION!=3){
			ret=FAIL;
			for(i=MAX_LUT_HW_TABLE_SIZE;i<MAX_LUT_SW_TABLE_SIZE;i++)
			{
				if(rg_db.lut[i].valid && rg_db.lut[i].rtk_lut.entryType==RTK_LUT_L2UC && rg_db.lut[i].category==category)
				{
					ret=SUCCESS;
					break;
				}
			}
		}

		if(ret==FAIL || atomic_read(&rg_kernel.lutReachLimit_category[category].activity)>MAX_WanAccessARPCount)
			atomic_set(&rg_kernel.lutReachLimit_category[category].activity,0);
		else
			_rtk_rg_mod_timer(&rg_kernel.lutReachLimit_category[category].timer, jiffies+(TICKTIME_PERIOD*rg_db.systemGlobal.wanAccessLimit_interval/1000));	//not found.. and still have software LUTwaiting...repeat after seconds
	}

	return;
}

void _rtk_rg_lutReachLimit_init(rtk_rg_accessWanLimitType_t type, void (*function)(unsigned long), unsigned long data)
{
	rtk_rg_saLearningLimitProbe_t *limitInfo=NULL;

	switch(type)
	{
		case RG_ACCESSWAN_TYPE_PORTMASK:
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			if(((data>>16)&0xffff)>0)
			{
				MACLN("#### Start to check all MACs at WLAN0DEVMASK[%ld]",data>>16);
			}
			else
#endif
			{
				MACLN("#### Start to check all MACs at PORTMASK[%lx]",data);
			}
			limitInfo=&rg_kernel.lutReachLimit_portmask;
			break;
		case RG_ACCESSWAN_TYPE_CATEGORY:
			MACLN("#### Start to check all MACs at same CATEGORY[%ld]",data);
			limitInfo=&rg_kernel.lutReachLimit_category[data];
			break;
		default:
			break;
	}

	if(limitInfo==NULL)
		return;

	if(atomic_read(&limitInfo->activity)==0)
	{
		_rtk_rg_del_timer(&limitInfo->timer);
		_rtk_rg_init_timer(&limitInfo->timer);
		limitInfo->timer.function = function;
		limitInfo->timer.data = data;

		limitInfo->l2Idx=-1;
		limitInfo->arpIdx=-1;
		limitInfo->arpCounter=0;
		memset(&limitInfo->arpReq,0,sizeof(rtk_rg_arp_request_t));
		limitInfo->neighborIdx=-1;
		limitInfo->neighborCounter=0;
		memset(&limitInfo->neighborReq,0,sizeof(rtk_rg_neighbor_discovery_t));
		limitInfo->v4IP=0;
		memset(&limitInfo->v6IP,0,sizeof(rtk_ipv6_addr_t));
		limitInfo->v6Route=-1;
		atomic_set(&limitInfo->activity,1);

		_rtk_rg_mod_timer(&limitInfo->timer, jiffies+(TICKTIME_PERIOD*rg_db.systemGlobal.wanAccessLimit_interval/1000));
	}
	else
		MACLN("#### The limit is active now...");
}

rtk_rg_successFailReturn_t _rtk_rg_softwareLut_addFromHw(int l2Idx, char category)
{
	rtk_rg_lut_linkList_t *pLutListEntry;
	rtk_l2_ucastAddr_t *softLut;
	int hashIdx=l2Idx>>MAX_LUT_HASH_WAY_SHIFT;

	//Check if we have not-used free arp list
	if(list_empty(&rg_db.softwareLutFreeListHead))
	{
		FIXME("all free LUT list are allocated...");
			return RG_RET_FAIL;
	}

	//Get one from free list
	pLutListEntry=list_first_entry(&rg_db.softwareLutFreeListHead, rtk_rg_lut_linkList_t, lut_list);
	list_del_init(&pLutListEntry->lut_list);

 	DEBUG("the free LUT %p idx is %d",pLutListEntry,pLutListEntry->idx);

	softLut=&rg_db.lut[pLutListEntry->idx].rtk_lut.entry.l2UcEntry;

	//Setup LUT information
	memcpy(softLut,&rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry,sizeof(rtk_l2_ucastAddr_t));
	rg_db.lut[pLutListEntry->idx].rtk_lut.entryType=RTK_LUT_L2UC;
	rg_db.lut[pLutListEntry->idx].valid=1;
	rg_db.lut[pLutListEntry->idx].category=category;
	rg_db.lut[pLutListEntry->idx].wlan_device_idx=rg_db.lut[l2Idx].wlan_device_idx;
	rg_db.lut[pLutListEntry->idx].fix_l34_vlan=rg_db.lut[l2Idx].fix_l34_vlan;

	//Add to hash head list
	list_add(&pLutListEntry->lut_list,&rg_db.softwareLutTableHead[hashIdx]);

	return RG_RET_SUCCESS;
}


int32 _rtk_rg_softwareLut_add(rtk_rg_macEntry_t *macEntry, int hashIdx, char category, char wlan_dev_index)
{
	rtk_rg_lut_linkList_t *pLutListEntry;
	rtk_l2_ucastAddr_t *softLut;
	rtk_rg_mac_port_idx_t mac_port;
	rtk_rg_mac_ext_port_idx_t mac_extPort;

	//Check if we have not-used free arp list
	if(list_empty(&rg_db.softwareLutFreeListHead))
	{
		WARNING("all free LUT list are allocated...");
		return RG_RET_FAIL;
	}

	//Get one from free list
	pLutListEntry=list_first_entry(&rg_db.softwareLutFreeListHead, rtk_rg_lut_linkList_t, lut_list);
	list_del_init(&pLutListEntry->lut_list);

 	DEBUG("the free LUT %p idx is %d",pLutListEntry,pLutListEntry->idx);

	softLut=&rg_db.lut[pLutListEntry->idx].rtk_lut.entry.l2UcEntry;

	//Setup LUT information
	memcpy(softLut->mac.octet,macEntry->mac.octet,ETHER_ADDR_LEN);
	softLut->fid=macEntry->fid;
	softLut->vid=macEntry->vlan_id;
	softLut->age=7;

#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
	if(wlan_dev_index>=0)
		_rtk_rg_wlanDevToPort_translator(wlan_dev_index, &macEntry->port_idx);
#endif
	_rtk_rg_portToMacPort_translator(macEntry->port_idx, &mac_port, &mac_extPort);
	softLut->port=mac_port;
	softLut->ext_port=mac_extPort;
#ifdef CONFIG_DUALBAND_CONCURRENT
	if(macEntry->port_idx > RTK_RG_PORT_LASTCPU)
	{
#if 1 	//20130722: if the packet is from ext0, this packet will hit ACL rule.(modify dpmask to 8)
		// the GMAC hw will reference CPU_RRING_ROUTING.
		if(macEntry->port_idx==RTK_RG_EXT_PORT1)
		{
			//lut.flags|=(RTK_L2_UCAST_FLAG_FWD_PRI|RTK_L2_UCAST_FLAG_STATIC); // must set static becasue unknow DA can't forward to CPU2(trap to CPU1 again)
		#if !defined(CONFIG_RG_RTL9602C_SERIES)
			softLut->flags|=(RTK_L2_UCAST_FLAG_FWD_PRI); //2013071
		#endif
			softLut->priority=CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI;
		}
#endif
	}
#endif


	if(macEntry->static_entry)
		softLut->flags|=RTK_L2_UCAST_FLAG_STATIC;
	if(macEntry->isIVL)
		softLut->flags|=RTK_L2_UCAST_FLAG_IVL;
	if(macEntry->arp_used)
		softLut->flags|=RTK_L2_UCAST_FLAG_ARP_USED;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	// support ctag_if
	if(macEntry->ctag_if)
		softLut->flags|=RTK_L2_UCAST_FLAG_CTAG_IF;
	else
		softLut->flags&=(~RTK_L2_UCAST_FLAG_CTAG_IF);
#endif

	rg_db.lut[pLutListEntry->idx].rtk_lut.entryType=RTK_LUT_L2UC;
	rg_db.lut[pLutListEntry->idx].valid=1;
	//20160113LUKE: if we had registered default URL for redirect, set redirect_http_req of lut in LAN.
	if(((rg_db.systemGlobal.forcePortal_url_list[0].valid)||(rg_db.redirectHttpAll.enable))
		&& (rg_db.systemGlobal.lanPortMask.portmask&(0x1<<macEntry->port_idx)) && (RTK_RG_ALL_CPU_PORTMASK&(0x1<<macEntry->port_idx))==0x0)
		rg_db.lut[pLutListEntry->idx].redirect_http_req=1;
	rg_db.lut[pLutListEntry->idx].category=category;
	rg_db.lut[pLutListEntry->idx].wlan_device_idx=wlan_dev_index;
	rg_db.lut[pLutListEntry->idx].fix_l34_vlan=macEntry->fix_l34_vlan;

	//Add to hash head list
	list_add(&pLutListEntry->lut_list,&rg_db.softwareLutTableHead[hashIdx]);

	return pLutListEntry->idx;
}

rtk_rg_successFailReturn_t _rtk_rg_softwareLut_checkAndDelete(rtk_l2_ucastAddr_t *lutEntry, int hashIdx)
{
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLutNext;

	//Check if we had been add to software LUT link-list
	if(!list_empty(&rg_db.softwareLutTableHead[hashIdx]))
	{
		list_for_each_entry_safe(pSoftLut,pSoftLutNext,&rg_db.softwareLutTableHead[hashIdx],lut_list)
		{
			if(memcmp(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.mac.octet,lutEntry->mac.octet,ETHER_ADDR_LEN)==0)
			{
				if(((lutEntry->flags&RTK_L2_UCAST_FLAG_IVL)>0 && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid==lutEntry->vid) ||
				((lutEntry->flags&RTK_L2_UCAST_FLAG_IVL)==0 && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.fid==lutEntry->fid))
				{
					if(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.port!=lutEntry->port ||
						rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.ext_port!=lutEntry->ext_port)
					{
						MACLN("software LUT had been added before and port-moving....delete it!");
						//Delete from head list
						list_del_init(&pSoftLut->lut_list);

						//set lut invalid(quicker than set all data to zero)
						rg_db.lut[pSoftLut->idx].valid=0;

						//Add back to free list
						list_add(&pSoftLut->lut_list,&rg_db.softwareLutFreeListHead);
						return RG_RET_SUCCESS;
					}
				}
			}
		}
	}

	return RG_RET_FAIL;
}

rtk_rg_successFailReturn_t _rtk_rg_softwareLut_checkAllAndDelete(rtk_l2_ucastAddr_t *lutEntry)
{
	int i;
	rtk_rg_successFailReturn_t ret;

	//Check if we had been add to software LUT in all link-list-head
	for(i=0;i<MAX_LUT_SW_TABLE_HEAD;i++)
	{
		ret=_rtk_rg_softwareLut_checkAndDelete(lutEntry,i);
		if(ret==RG_RET_SUCCESS)
			return ret;
	}

	return RG_RET_FAIL;
}

void _rtk_rg_softwareLut_allDelete(void)
{
	int i;
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLutNext;

	//Check if we had been add to software LUT in all link-list-head
	for(i=0;i<MAX_LUT_SW_TABLE_HEAD;i++)
	{
		if(!list_empty(&rg_db.softwareLutTableHead[i]))
		{
			list_for_each_entry_safe(pSoftLut,pSoftLutNext,&rg_db.softwareLutTableHead[i],lut_list)
			{
				//Delete from head list
				list_del_init(&pSoftLut->lut_list);

				//set lut invalid(quicker than set to zero)
				rg_db.lut[pSoftLut->idx].valid=0;

				//Add back to free list
				list_add(&pSoftLut->lut_list,&rg_db.softwareLutFreeListHead);
			}
		}
	}

}

void _rtk_rg_softwareLut_portDelete(rtk_rg_port_idx_t port_idx)
{
	int i;
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLutNext;

	//Check if we had been add to software LUT in all link-list-head
	for(i=0;i<MAX_LUT_SW_TABLE_HEAD;i++)
	{
		if(!list_empty(&rg_db.softwareLutTableHead[i]))
		{
			list_for_each_entry_safe(pSoftLut,pSoftLutNext,&rg_db.softwareLutTableHead[i],lut_list)
			{
				if((port_idx==RTK_RG_EXT_PORT0 && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.port==RTK_RG_MAC_PORT_CPU && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.ext_port==RTK_RG_MAC_EXT_PORT0)||
#ifdef CONFIG_DUALBAND_CONCURRENT
				(port_idx==RTK_RG_EXT_PORT1 && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.port==RTK_RG_MAC_PORT_CPU && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.ext_port==RTK_RG_MAC_EXT_PORT1)||
#endif
				(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.port==port_idx))
				{
					//Delete from head list
					list_del_init(&pSoftLut->lut_list);

					//set lut invalid(quicker than set to zero)
					rg_db.lut[pSoftLut->idx].valid=0;

					//Add back to free list
					list_add(&pSoftLut->lut_list,&rg_db.softwareLutFreeListHead);
				}
			}
		}
	}

}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
void _rtk_rg_softwareLut_wlan0DevDelete(int dev_idx)
{
	int i;
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLutNext;

	//Check if we had been add to software LUT in all link-list-head
	for(i=0;i<MAX_LUT_SW_TABLE_HEAD;i++)
	{
		if(!list_empty(&rg_db.softwareLutTableHead[i]))
		{
			list_for_each_entry_safe(pSoftLut,pSoftLutNext,&rg_db.softwareLutTableHead[i],lut_list)
			{
				if(rg_db.lut[pSoftLut->idx].wlan_device_idx==dev_idx)
				{
					//Delete from head list
					list_del_init(&pSoftLut->lut_list);

					//set lut invalid(quicker than set to zero)
					rg_db.lut[pSoftLut->idx].valid=0;

					//Add back to free list
					list_add(&pSoftLut->lut_list,&rg_db.softwareLutFreeListHead);
				}
			}
		}
	}
}
#endif

rtk_rg_fwdEngineReturn_t _rtk_rg_checkGwIp(rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
	{
		if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo!=NULL)
		{
			if(((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_addr==pPktHdr->ipv4Dip) ||
				(pPktHdr->tagif&IPV6_TAGIF && !memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ipv6_addr.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN)))
			{
				TRACE("[To PS] Packet to LAN interface %d, to PS!",rg_db.systemGlobal.lanIntfGroup[i].index);
				return RG_FWDENGINE_RET_TO_PS;
			}
		}
	}

	//Check Wan interface IP address
	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		//DEBUG("the wan type is %d, ip is %x",rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr);
		if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo!=NULL && rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf!=NULL &&
			rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE)
		{
			if(((pPktHdr->tagif&IPV4_TAGIF||pPktHdr->tagif&ARP_TAGIF) && rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr==pPktHdr->ipv4Dip) ||
				(pPktHdr->tagif&IPV6_TAGIF && !memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ipv6_addr.ipv6_addr,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN)))
			{
				TRACE("[To PS] Packet to WAN interface %d, to PS!",rg_db.systemGlobal.wanIntfGroup[i].index);
				//dump_packet(skb->data,skb->len,"arp packet");
#ifdef CONFIG_RG_SIMPLE_PROTOCOL_STACK
				if(skb->dev->priv && ((struct re_dev_private*)skb->dev->priv)->pCp)((struct re_dev_private*)skb->dev->priv)->pCp->wanInterfaceIdx=i;
#endif
				return RG_FWDENGINE_RET_TO_PS;
			}
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

void _rtk_rg_layer2DeleteDiffCTagifShortcut(int l2Idx, int new_dmac2cvlanTagif, uint8 isOnlyVlanChanged)
{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)

	//Delete flow entry
	if(isOnlyVlanChanged)
		assert_ok(_rtk_rg_flow_del_by_dmacL2Idx_and_dmac2cvid(l2Idx));
	else
		assert_ok(_rtk_rg_flow_del_by_l2Idx(l2Idx));

#else //1 not CONFIG_RG_FLOW_BASED_PLATFORM

	int i;
#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	rtk_rg_ipv6_layer4_linkList_t *pV6L4List,*nextEntry;
#endif

	TRACE("Start to check..");
#ifdef CONFIG_ROME_NAPT_SHORTCUT
	for(i=0; i<MAX_NAPT_SHORTCUT_SIZE; i++){
		if(RG_V4SC_VALID(i) && rg_db.naptShortCut[i].new_lut_idx==l2Idx && rg_db.naptShortCut[i].dmac2cvlanTagif!=new_dmac2cvlanTagif){
			TABLE("del v4 shortcut[%d] for dmac2cvlanTagif(%d->%d).", i, rg_db.naptShortCut[i].dmac2cvlanTagif, new_dmac2cvlanTagif);
			_rtk_rg_v4ShortCut_delete(i);
		}
	}
#endif

#ifdef CONFIG_RG_IPV6_SOFTWARE_SHORTCUT_SUPPORT
	for(i=0; i<MAX_NAPT_V6_SHORTCUT_SIZE; i++){
		if(RG_V6SC_VALID(i) && rg_db.naptv6ShortCut[i].new_lut_idx==l2Idx && rg_db.naptv6ShortCut[i].dmac2cvlanTagif!=new_dmac2cvlanTagif){
			TABLE("del v6 shortcut[%d] for dmac2cvlanTagif(%d->%d).", i, rg_db.naptv6ShortCut[i].dmac2cvlanTagif, new_dmac2cvlanTagif);
			_rtk_rg_v6ShortCut_delete(i);
		}
	}
#endif

#ifdef CONFIG_RG_IPV6_STATEFUL_ROUTING_SUPPORT
	for(i=0; i<MAX_IPV6_STATEFUL_HASH_HEAD_SIZE; i++){
		list_for_each_entry_safe(pV6L4List,nextEntry,&rg_db.ipv6Layer4HashListHead[i],layer4_list){
			if(pV6L4List->dmacL2Idx==l2Idx && pV6L4List->dmac2cvlanTagif!=new_dmac2cvlanTagif){
				TABLE("del v6 stateful shortcut for dmac2cvlanTagif(%d->%d).", pV6L4List->dmac2cvlanTagif, new_dmac2cvlanTagif);
				//------------------ Critical Section start -----------------------//
				rg_lock(&rg_kernel.ipv6StatefulLock);
				_rtk_rg_fwdEngine_ipv6ConnList_del(pV6L4List);
				//------------------ Critical Section End -----------------------//
				rg_unlock(&rg_kernel.ipv6StatefulLock);
			}
		}
	}
#endif
#endif
}

void _rtk_rg_wanAccessResetIPPermit(int l2Idx)
{
	int i;
	for(i=0;i<MAX_ARP_SW_TABLE_SIZE;i++)
		if(rg_db.arp[i].rtk_arp.nhIdx==l2Idx){
			if(rg_db.arp[i].permit_for_l34_forward==WanAccessLimitPermit)atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
			rg_db.arp[i].permit_for_l34_forward=WanAccessLimitForbid;
		}
}

void _rtk_rg_lutToMacEntry_translator(rtk_rg_table_lut_t lutEntry, rtk_rg_macEntry_t *macEntry)
{
	memset(macEntry, 0, sizeof(rtk_rg_macEntry_t));
	memcpy(macEntry->mac.octet, lutEntry.rtk_lut.entry.l2UcEntry.mac.octet, ETHER_ADDR_LEN);
	macEntry->isIVL = (lutEntry.rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)?1:0;
	macEntry->fid = lutEntry.rtk_lut.entry.l2UcEntry.fid;
	macEntry->vlan_id = lutEntry.rtk_lut.entry.l2UcEntry.vid;
	_rtk_rg_macPortToPort_translator(&macEntry->port_idx, lutEntry.rtk_lut.entry.l2UcEntry.port, lutEntry.rtk_lut.entry.l2UcEntry.ext_port);
	macEntry->arp_used = (lutEntry.rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)?1:0;
	macEntry->static_entry = (lutEntry.rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)?1:0;
	macEntry->sa_block = (lutEntry.rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_SA_BLOCK)?1:0;
	macEntry->da_block = (lutEntry.rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_DA_BLOCK)?1:0;
	macEntry->fix_l34_vlan = lutEntry.fix_l34_vlan;
	macEntry->auth = lutEntry.rtk_lut.entry.l2UcEntry.auth;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	// support ctag_if
	macEntry->ctag_if = (lutEntry.rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0;
#endif
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
	macEntry->idleSecs = 0;
#endif
	macEntry->wlan_device_idx = lutEntry.wlan_device_idx;
	macEntry->countingInLearningLimit = lutEntry.countingInLearningLimit;
}

rtk_rg_err_code_t _rtk_rg_ivlMacEntry_add(uint32 svlL2Idx, uint32 ivlVlanId, rtk_rg_port_idx_t ingressPort, rtk_rg_mbssidDev_t wlan_dev_idx, uint32 *ivlL2Idx)
{
	rtk_rg_macEntry_t macEntry;
	int ret, l2Idx, search_index, first_invalid=FAIL, count=0, lut_matchIdx=FAIL;
	int lut_orig=FAIL, port_move_orig=FAIL, wlan_move_orig=FAIL;
	rtk_rg_port_idx_t portIdx;

	if(svlL2Idx>=MAX_LUT_HW_TABLE_SIZE)
		RETURN_ERR(RT_ERR_RG_INDEX_OUT_OF_RANGE);
	if(rg_db.lut[svlL2Idx].valid==0 || (rg_db.lut[svlL2Idx].valid && (rg_db.lut[svlL2Idx].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL)))
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);
	if(rg_db.vlan[ivlVlanId].valid==0 || rg_db.vlan[ivlVlanId].fidMode==VLAN_FID_SVL)		//unknown 1Q vlan should't learn
		RETURN_ERR(RT_ERR_RG_INVALID_PARAM);

	_rtk_rg_lutToMacEntry_translator(rg_db.lut[svlL2Idx], &macEntry);
	macEntry.isIVL = 1;
	macEntry.vlan_id = ivlVlanId;
	if(ingressPort!=FAIL)
		macEntry.port_idx = ingressPort;
	if(wlan_dev_idx!=FAIL)
		macEntry.wlan_device_idx = wlan_dev_idx;

#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
	if(macEntry.wlan_device_idx>=0)
		_rtk_rg_wlanDevToPort_translator(macEntry.wlan_device_idx, &macEntry.port_idx);
#endif
	// add count of mac learning limit if this lut is non-static
	macEntry.countingInLearningLimit = (macEntry.static_entry) ? 0 : 1;

	//IVL hash
	l2Idx = _rtk_rg_hash_mac_vid_efid(macEntry.mac.octet, macEntry.vlan_id, 0) << MAX_LUT_HASH_WAY_SHIFT;		//FIXME:EFID is 0 now
	count=0;
	do
	{
		search_index = l2Idx+count;
		if(rg_db.lut[search_index].valid==0)
		{
			if(first_invalid==FAIL)
				first_invalid=search_index;
			count++; //search from next entry
			continue;
		}
		if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC
			&& (memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet, macEntry.mac.octet, ETHER_ADDR_LEN)==0))
		{
			if((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id)
			{
				//Record matched index of lut
				lut_matchIdx=search_index;

				_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
				_rtk_rg_lutExtport_translator(&portIdx);
#endif
				if(!(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC))
				{
					if((portIdx!=macEntry.port_idx)
						|| ((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<macEntry.port_idx)) && macEntry.wlan_device_idx>=0 && macEntry.wlan_device_idx!=rg_db.lut[search_index].wlan_device_idx)
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
						||((RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<macEntry.port_idx)) && macEntry.wlan_device_idx>=0 && macEntry.wlan_device_idx!=rg_db.lut[search_index].wlan_device_idx)
#endif
						)
					{
						TRACE("the port moving..");

						if(rg_db.lut[search_index].countingInLearningLimit)
							assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));

						port_move_orig = portIdx;
						wlan_move_orig = rg_db.lut[search_index].wlan_device_idx;
						lut_orig = search_index;			
						break;
					}
				}

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
				assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
				*ivlL2Idx = search_index;
				return (RT_ERR_RG_OK);		//exist, do nothing
			}
		}

		count++; //search from next entry
	}while(count < MAX_LUT_HASH_WAY_SIZE);

	if(count==MAX_LUT_HASH_WAY_SIZE)
	{
		//Check bCAM LUT first, if match, just return
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE; search_index<MAX_LUT_HW_TABLE_SIZE; search_index++)
		{
			if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC
				&& (memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet, macEntry.mac.octet, ETHER_ADDR_LEN)==0))
			{
				if((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_IVL) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id)
				{
//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
					if(macEntry.arp_used)
					{
						// [Call RTK_L2_ADDR_DEL directly] only delete ivl lut entry, not all lut entries in this lut group
						assert_ok(RTK_L2_ADDR_DEL(&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry));
						break;
					}
#endif
					//Record matched index of lut
					lut_matchIdx=search_index;

					_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
					_rtk_rg_lutExtport_translator(&portIdx);
#endif
					if(!(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC))
					{
						if((portIdx!=macEntry.port_idx)
							|| ((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<macEntry.port_idx)) && macEntry.wlan_device_idx>=0 && macEntry.wlan_device_idx!=rg_db.lut[search_index].wlan_device_idx)
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							||((RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<macEntry.port_idx)) && macEntry.wlan_device_idx>=0 && macEntry.wlan_device_idx!=rg_db.lut[search_index].wlan_device_idx)
#endif
							)
						{
							TRACE("the port moving..");

							if(rg_db.lut[search_index].countingInLearningLimit)
								assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));

							port_move_orig = portIdx;
							wlan_move_orig = rg_db.lut[search_index].wlan_device_idx;
							lut_orig = search_index;			
							break;
						}
				}

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
					assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
					*ivlL2Idx = search_index;
					return (RT_ERR_RG_OK);		//exist, do nothing
				}
			}
		}
	}

	//Check mac learning limit
	if(macEntry.countingInLearningLimit==1
		&& _rtk_rg_mac_learning_limit_check(macEntry.port_idx, macEntry.wlan_device_idx)==RG_RET_FAIL)
	{
		TRACE("Mac learning limit is reached...won't add MAC!!");
		if(lut_orig >= 0)
		{
			if(rg_db.lut[lut_orig].countingInLearningLimit)
				assert_ok(_rtk_rg_mac_learning_limit_count_inc(port_move_orig, wlan_move_orig));
			if(port_move_orig>=0 || wlan_move_orig>=0)
			{
				//delete original hw mac
				_rtk_rg_shortCut_clear();
				(pf.rtk_rg_macEntry_del)(lut_orig);
			}
		}
		return (RT_ERR_RG_FAILED);
	}

	//Decide lut index
	if(lut_matchIdx>=0 && rg_db.lut[lut_matchIdx].valid==0)
	{
		if(lut_matchIdx<LUT_HW_TABLE_SIZE)
		{
			if(first_invalid<0 || (first_invalid>=0 && lut_matchIdx<first_invalid))
				first_invalid = lut_matchIdx;
		}
		lut_matchIdx = FAIL;
	}
	if(lut_matchIdx>=0)
	{
		search_index = lut_matchIdx;
	}
	else
	{
		if(first_invalid>=0)
		{
			search_index = first_invalid;
		}
		else	//When the 4-way is full, check the bCAM list for free to add. If the bCAM is also full, do LRU.
		{
//Since 6266's ARP, neighbor, nexthop only have 11 bits for l2Idx, they can never pointer to bCAM adress which after 2048
#if defined(CONFIG_RG_RTL9600_SERIES)
			if(macEntry.arp_used)
				search_index = _rtk_rg_layer2HashedReplace(l2Idx, svlL2Idx);
			else
#else
				search_index = _rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, svlL2Idx);
#endif
			if(search_index==RG_RET_ENTRY_NOT_GET)
			{
				FIXME("must add software LUT entry for LUT entry full.");
				*ivlL2Idx = FAIL;
				return (RT_ERR_RG_ENTRY_FULL);
			}

		}
	}

	MACLN("add to HW LUT!!");
	//add to both software and hardware
	ret=(pf.rtk_rg_macEntry_add)(&macEntry, &search_index);
	assert_ok(ret);
	TRACE("IVL Vid[%d] MAC[%d](%02x:%02x:%02x:%02x:%02x:%02x) learning at Port=%d\n",
		macEntry.vlan_id,
		search_index,
		macEntry.mac.octet[0],
		macEntry.mac.octet[1],
		macEntry.mac.octet[2],
		macEntry.mac.octet[3],
		macEntry.mac.octet[4],
		macEntry.mac.octet[5],
		macEntry.port_idx);
	
	if(macEntry.countingInLearningLimit)
	{
		assert_ok(_rtk_rg_mac_learning_limit_count_inc(macEntry.port_idx, macEntry.wlan_device_idx));
	}
	rg_db.lut[search_index].category = 0;
	rg_db.lut[search_index].permit_for_l34_forward=1;

	*ivlL2Idx = search_index;

	return (RT_ERR_RG_OK);
}


#if defined(CONFIG_RG_RTL9602C_SERIES)
rtk_rg_err_code_t _rtk_rg_create_ivlMacEntries_of_internalUsedVid(uint32 svlL2Idx, uint32 ingressVid, rtk_rg_port_idx_t ingressPort, rtk_rg_mbssidDev_t wlan_dev_idx)
{
	uint32 addIvlLut=FALSE, i, check_ivl_vid, ivlL2Idx;

	if(ingressPort==FAIL)	//forcibly add
	{
		addIvlLut = TRUE;
	}
	else
	{
		if((0x1<<ingressPort) & rg_db.systemGlobal.lanPortMask.portmask)	//from lan
		{
			addIvlLut = TRUE;
		}
		if((0x1<<ingressPort) & rg_db.systemGlobal.wanPortMask.portmask)	//from wan
		{
			for(i=0; i<rg_db.systemGlobal.wanIntfTotalNum; i++)
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_BRIDGE
					&& rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id==ingressVid)
				{
					addIvlLut = TRUE;
					break;
				}
			}
		}
	}

	if(addIvlLut)
	{
		check_ivl_vid = rg_db.systemGlobal.initParam.fwdVLAN_BIND_INTERNET;
		if(rg_db.vlan[check_ivl_vid].valid && rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
		{
			DEBUG("create IVL vid[%d] lut entry for SVL lut[%d]", check_ivl_vid, svlL2Idx);
			ASSERT_EQ(_rtk_rg_ivlMacEntry_add(svlL2Idx, check_ivl_vid, ingressPort, wlan_dev_idx, &ivlL2Idx), RT_ERR_RG_OK);
		}

		for(check_ivl_vid=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER; check_ivl_vid<=rg_db.systemGlobal.initParam.fwdVLAN_BIND_OTHER+DEFAULT_BIND_LAN_OFFSET; check_ivl_vid++)
		{
			if(rg_db.vlan[check_ivl_vid].valid && rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
			{
				DEBUG("create IVL vid[%d] lut entry for SVL lut[%d]", check_ivl_vid, svlL2Idx);
				ASSERT_EQ(_rtk_rg_ivlMacEntry_add(svlL2Idx, check_ivl_vid, ingressPort, wlan_dev_idx, &ivlL2Idx), RT_ERR_RG_OK);
			}
		}

		for(i=0;i<MAX_BIND_SW_TABLE_SIZE;i++)
		{
			if(rg_db.bind[i].valid && rg_db.bind[i].rtk_bind.vidLan!=0)
			{
				check_ivl_vid = rg_db.bind[i].rtk_bind.vidLan;
				if(rg_db.vlan[check_ivl_vid].valid && rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
				{
					DEBUG("create IVL vid[%d] lut entry for SVL lut[%d]", check_ivl_vid, svlL2Idx);
					ASSERT_EQ(_rtk_rg_ivlMacEntry_add(svlL2Idx, check_ivl_vid, ingressPort, wlan_dev_idx, &ivlL2Idx), RT_ERR_RG_OK);
				}
			}
		}
	}

	return (RT_ERR_RG_OK);
}
rtk_rg_err_code_t _rtk_rg_update_lanIntf_ivlMacEntries(void)
{
	uint32 i, svlL2Idx, ingressVid;

	for(i=0; i<rg_db.systemGlobal.lanIntfTotalNum; i++)
	{
		svlL2Idx = rg_db.netif[rg_db.systemGlobal.lanIntfGroup[i].index].l2_idx;
		ingressVid = rg_db.netif[rg_db.systemGlobal.lanIntfGroup[i].index].rtk_netif.vlan_id;
		ASSERT_EQ(_rtk_rg_create_ivlMacEntries_of_internalUsedVid(svlL2Idx, ingressVid, FAIL, FAIL), RT_ERR_RG_OK);
	}

	return (RT_ERR_RG_OK);
}
#endif

rtk_rg_successFailReturn_t _rtk_rg_vlanGroupMacLimit_check(rtk_rg_pktHdr_t *pPktHdr, int l2Hash)
{
	int ret,matchMac=0;
	int ctagVid=pPktHdr->tagif&CVLAN_TAGIF?pPktHdr->ctagVid:-1;
	uint32 vlanMacGroupIdx;
	rtk_rg_vlanGroupMacLimit_mac_t *pMac,*pNextMac;

	MACLN("[VGLIMIT] Check vlan group mac limit!");

	//check if any MAC-equal entries exist, delete them all for port-moving
	if(!list_empty(&rg_db.systemGlobal.vlanGroupMACLimit_macHead[l2Hash]))
	{
		list_for_each_entry_safe(pMac, pNextMac, &rg_db.systemGlobal.vlanGroupMACLimit_macHead[l2Hash], mac_list)
		{
			//check port-moving
			if(!memcmp(pMac->mac.octet,pPktHdr->smac,ETHER_ADDR_LEN))
			{
				if(pMac->pGroup && pMac->pGroup->group_info.port!=pPktHdr->ingressMacPort)
				{
					MACLN("[VGLIMIT] port-moving..delete MAC vlan %d",pMac->vlanId);
					atomic_dec(&pMac->pGroup->group_info.mac_count);
					list_del(&pMac->group_list);
					list_del(&pMac->mac_list);
					rtk_rg_free(pMac);
				}
				else if(pMac->vlanId==ctagVid)
				{
					//match, just return
					MACLN("[VGLIMIT] match exist MAC.");
					matchMac=1;
				}
			}
		}
	}

	ret=(pf.rtk_rg_vlanGroupMacLimit_find)(pPktHdr->ingressMacPort,ctagVid,&vlanMacGroupIdx);
	if(ret==RT_ERR_RG_OK)
	{
		//group found, now check limit and check if the mac had already been learned.
		MACLN("[VGLIMIT] the vlanMacGroup index is %d",vlanMacGroupIdx);
		if(!matchMac)
		{
			//check limit, create new MAC if avalable
			if(atomic_read(&rg_db.systemGlobal.vlanGroupMACLimit_group[vlanMacGroupIdx].group_info.mac_count)<rg_db.systemGlobal.vlanGroupMACLimit_group[vlanMacGroupIdx].group_info.mac_limit_number)
			{
				pMac=rtk_rg_malloc(sizeof(rtk_rg_vlanGroupMacLimit_mac_t));
				if(pMac)
				{
					MACLN("[VGLIMIT] create new mac for group[%d]",vlanMacGroupIdx);
					memcpy(pMac->mac.octet,pPktHdr->smac,ETHER_ADDR_LEN);
					if(pPktHdr->tagif&CVLAN_TAGIF)
						pMac->vlanId=pPktHdr->ctagVid;
					else
						pMac->vlanId=-1;
					list_add_tail(&pMac->mac_list, &rg_db.systemGlobal.vlanGroupMACLimit_macHead[l2Hash]);
					atomic_inc(&rg_db.systemGlobal.vlanGroupMACLimit_group[vlanMacGroupIdx].group_info.mac_count);
					pMac->pGroup=&rg_db.systemGlobal.vlanGroupMACLimit_group[vlanMacGroupIdx];
					list_add_tail(&pMac->group_list, &rg_db.systemGlobal.vlanGroupMACLimit_group[vlanMacGroupIdx].mac_head);
				}
				else
				{
					MACLN("[VGLIMIT] no memory..drop packet.");
					return RG_RET_FAIL;
				}
			}
			else
			{
				MACLN("[VGLIMIT] the group is full..drop packet.");
				return RG_RET_FAIL;
			}
		}
	}

	return RG_RET_SUCCESS;
}

rtk_rg_successFailReturn_t _rtk_rg_layer2LutLearningV2(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
#if defined(CONFIG_RG_RTL9600_SERIES)
	rtk_rg_macEntry_t macEntry={{{0}},0,0,0,0,0,0,0,0};
#else
	rtk_rg_macEntry_t macEntry={{{0}},0,0,0,0,0,0,0,0,0,0};
#endif
	rtk_rg_lut_linkList_t *pSoftLut,*pSoftLut_hit=NULL;
	int ret,l2Idx,search_index,count=0,first_invalid=-1,port_move_orig=-1,category_orig=0,lut_orig=-1,permit_orig=0,lut_matchIdx=FAIL;
	rtk_rg_port_idx_t portIdx;
	uint32 ingressPort=pPktHdr->ingressPort;
	int i=0,wlan_move_orig=-1;
	int8 limit_action_mask=0,matchLanPort=0,matchLanMac=0,matchLanIP=0,check_category=0;
	uint32 check_ivl_vid=pPktHdr->ingressDecideVlanID, ivlL2Idx;
	uint32 isVlanChange = FALSE, isOtherChange = FALSE;

	//DEBUG("@@@ port%d %02x:%02x:%02x:%02x:%02x:%02x @@@\n",pPktHdr->ingressMacPort,pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
		//pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5]);

	if(ingressPort>=RTK_RG_PORT_MAX){
		DEBUG("illegal ingressPort[%d]..",ingressPort);
		return RG_RET_FAIL;
	}

	if(rg_db.vlan[pPktHdr->ingressDecideVlanID].valid==0)		//unknown 1Q vlan should't learn
	{
		DEBUG("ingressVID=%d valid=%d\n",pPktHdr->ingressDecideVlanID,rg_db.vlan[pPktHdr->ingressDecideVlanID].valid);
		return RG_RET_FAIL;
	}

	//Add SVL lut entry first
	macEntry.isIVL=0;
	macEntry.fid=rg_db.vlan[pPktHdr->ingressDecideVlanID].fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
	macEntry.vlan_id=(pPktHdr->tagif&CVLAN_TAGIF)?pPktHdr->ctagVid:0;
#else	// support ctag_if
	macEntry.ctag_if=(pPktHdr->tagif&CVLAN_TAGIF)?1:0;
	macEntry.vlan_id=(pPktHdr->tagif&CVLAN_TAGIF)?pPktHdr->ctagVid:pPktHdr->ingressDecideVlanID;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	//20180615LUKE: for priority-tag, we should treat lut as untag.
	if(macEntry.vlan_id==0) macEntry.ctag_if = 0;
#endif
#endif
	//DEBUG("the ingressDecideVlanID is %d, fid is %d",pPktHdr->ingressDecideVlanID,macEntry.fid);

	l2Idx=_rtk_rg_hash_mac_fid_efid(pPktHdr->pSmac,macEntry.fid,0);			//FIXME:EFID is 0 now
	l2Idx<<=MAX_LUT_HASH_WAY_SHIFT;
	do
	{
		search_index = l2Idx+count;
		//DEBUG("search_idx is %d\n",search_index);
		if(rg_db.lut[search_index].valid==0)
		{
			if(first_invalid==-1)
				first_invalid=search_index;
			//break;	//empty, just add
			count++; //search from next entry
			continue;
		}

		if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
			(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pPktHdr->pSmac,ETHER_ADDR_LEN)==0))
		{
			if(((macEntry.isIVL==1) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
			((macEntry.isIVL==0) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
			{
				//Record matched index of lut
				lut_matchIdx=search_index;

				_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
				_rtk_rg_lutExtport_translator(&portIdx);
#endif
				if(pPktHdr->pRxDesc->rx_reason==RG_CPU_REASON_L2_LEARN_LIMIT_PERPORT /* SA learning limit */ || pPktHdr->pRxDesc->rx_reason==RG_CPU_REASON_UNKNOWN_SA /* unknown SA action */)
				{
					if(portIdx==ingressPort)
					{
						//Force SA learning
						TRACE("Forced SA learning...reason=%d",pPktHdr->pRxDesc->rx_reason);

						if(rg_db.lut[search_index].countingInLearningLimit)
							assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));

						//20170301LUKE: modify count when limit field is source mac.
						if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
						{
							if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx)&&rg_db.lut[search_index].permit_for_l34_forward)
								atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
							//decrease wlan's device count
							if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
								|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
								) && rg_db.lut[search_index].wlan_device_idx>=0)
							{
								if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx))&&rg_db.lut[search_index].permit_for_l34_forward)
									atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);

								wlan_move_orig=rg_db.lut[search_index].wlan_device_idx;
							}
#endif
						}
						port_move_orig=portIdx;		
						lut_orig=search_index;
						category_orig=rg_db.lut[search_index].category;
						permit_orig=rg_db.lut[search_index].permit_for_l34_forward;
						break;
					}
				}
				//DEBUG("match!!fix_l34_vlan:%d",rg_db.lut[search_index].fix_l34_vlan);
				//FIXME: here reserved for WiFi interface may also need to handle port-moving in the future.
				//FB: allow L2 bridge packet from disabled dmac2cvid port to update lut entry even this lut entry is static
				if(	!(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					|| (rg_db.systemGlobal.initParam.macBasedTagDecision && (rg_db.systemGlobal.dmac2cvidDisabledPortmask & (0x1<<ingressPort)) && (portIdx==ingressPort) && pPktHdr->isGatewayPacket==0)
#endif
					)
				{
					//20140722LUKE: drop strange packet learned not in WAN but comeback in WAN
					if(portIdx!=ingressPort)
						if(((0x1<<ingressPort)&rg_db.systemGlobal.wanPortMask.portmask)&&(rg_db.systemGlobal.strangeSA_drop==RG_HWNAT_ENABLE))
							return RG_RET_FAIL;

					if(rg_db.systemGlobal.initParam.macBasedTagDecision &&
						((rg_db.systemGlobal.dmac2cvidDisabledPortmask & (0x1<<ingressPort))==0x0 || pPktHdr->isGatewayPacket==0) &&
#if defined(CONFIG_RG_RTL9600_SERIES)
						(macEntry.vlan_id!=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid && !rg_db.lut[search_index].fix_l34_vlan)
#else	// support ctag_if
						//20160818LUKE: check vlan-id only when we are tagif!!
						((macEntry.ctag_if && ((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0) && macEntry.vlan_id!=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid && !rg_db.lut[search_index].fix_l34_vlan)
							|| (macEntry.ctag_if!=((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0) && !rg_db.lut[search_index].fix_l34_vlan))
#endif
						)
					{
						if((((pPktHdr->tagif&IPV4_TAGIF)&&((pPktHdr->ipv4Dip&0xf0000000)==0xe0000000)) || ((pPktHdr->tagif&IPV6_TAGIF)&&((pPktHdr->pIpv6Dip[0])==0xff)))
							&& !((pPktHdr->tagif&PPPOE_TAGIF) && (pPktHdr->isGatewayPacket==0)))
						{
							TRACE("[L2 learning] Skip cvlan learning of multicast packet.");
						}
						else
						{
							TRACE("[L2 learning] Cvlan is changed !!");
							isVlanChange = TRUE;
						}
					}

					if((portIdx!=ingressPort)
						|| ((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<ingressPort)) && pPktHdr->wlan_dev_idx>=0 && pPktHdr->wlan_dev_idx!=rg_db.lut[search_index].wlan_device_idx)
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
						|| ((RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<ingressPort)) && pPktHdr->wlan_dev_idx>=0 && pPktHdr->wlan_dev_idx!=rg_db.lut[search_index].wlan_device_idx)
#endif
						|| (rg_db.systemGlobal.activeLimitFunction!=RG_ACCESSWAN_TYPE_UNLIMIT&&!rg_db.lut[search_index].permit_for_l34_forward)	//20160814LUKE: if we are not permited, continue check
						)
					{
						TRACE("[L2 learning] SPA/WlanDevice/permit_for_l34_forward is changed !!");
						isOtherChange = TRUE;
					}

					if((isVlanChange==TRUE) || (isOtherChange==TRUE))
					{
						//Mac port-moving or Vlan-moving or wlan-moving, update LUT table without change ARP_USED flag and auth field
						//------------------ Critical Section start -----------------------//
						//rg_lock(&rg_kernel.saLearningLimitLock);
						if(rg_db.lut[search_index].countingInLearningLimit)
							assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));
						
						//20170301LUKE: modify count when limit field is source mac.
						if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
						{
							if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx) && rg_db.lut[search_index].permit_for_l34_forward)
								atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
						}
						else
						{
							//20170306LUKE: clear IP permit when port is moving out wan access limit port mask.
							if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx))
								_rtk_rg_wanAccessResetIPPermit(search_index);
						}
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						//decrease wlan's device count
						if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
							|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
							) && rg_db.lut[search_index].wlan_device_idx>=0)
						{
							//20170301LUKE: modify count when limit field is source mac.
							if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
							{
								if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx))&&rg_db.lut[search_index].permit_for_l34_forward)
									atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
							}
							else
							{
								//20170306LUKE: clear IP permit when port is moving out wan access limit port mask.
								if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx)))
									_rtk_rg_wanAccessResetIPPermit(search_index);
							}
							wlan_move_orig=rg_db.lut[search_index].wlan_device_idx;
						}
#endif
						port_move_orig=portIdx;
						
						if(portIdx <= RTK_RG_PORT_LASTCPU)
						{
							if(rg_db.systemGlobal.fix_l34_to_untag_enable==RG_HWNAT_ENABLE && (macEntry.vlan_id!=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid))
							{
								if(macEntry.vlan_id==0)
									macEntry.vlan_id=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid;
								MACLN("set fix_l34_vlan");
								macEntry.fix_l34_vlan=1;
							}
						}
						lut_orig=search_index;
						category_orig=rg_db.lut[search_index].category;
						permit_orig=rg_db.lut[search_index].permit_for_l34_forward;
						//------------------ Critical Section End -----------------------//
						//rg_unlock(&rg_kernel.saLearningLimitLock);

						macEntry.arp_used=((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)>0)?1:0;
						macEntry.auth=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.auth;
						TRACE("the port moving or vlan changing..arp used is %d, auth is %d\n",macEntry.arp_used,macEntry.auth);
						break;
					}
				}
				
				//hit hardware! check if we had already add to sw, if port-moving, delete sw one...
				_rtk_rg_softwareLut_checkAndDelete(&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry,l2Idx>>MAX_LUT_HASH_WAY_SHIFT);

				//Increase count of mac learning limit if match
				if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
					&& rg_db.lut[search_index].countingInLearningLimit==0)
				{
					//Check mac learning limit
					if(_rtk_rg_mac_learning_limit_check(portIdx, rg_db.lut[search_index].wlan_device_idx)==RG_RET_FAIL)
					{
						TRACE("Mac learning limit is reached...won't add MAC!!");
						return RG_RET_FAIL;
					}
					assert_ok(_rtk_rg_mac_learning_limit_count_inc(portIdx, rg_db.lut[search_index].wlan_device_idx));
					rg_db.lut[search_index].countingInLearningLimit = 1;
				}

				//Check vlan group mac learning limit
				if(_rtk_rg_vlanGroupMacLimit_check(pPktHdr, l2Idx>>MAX_LUT_HASH_WAY_SHIFT)==RG_RET_FAIL)
					return RG_RET_FAIL;

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
				assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
				//20140811LUKE: keep src mac lut idx!!
				pPktHdr->smacL2Idx=search_index;

				goto ADD_IVL_LUT;
			}
		}

		count++; //search from next entry
	}while(count < MAX_LUT_HASH_WAY_SIZE);

	if(count==MAX_LUT_HASH_WAY_SIZE)
	{
		//Check bCAM LUT first, if match, just return
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
		{
			if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
			{
				if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pPktHdr->pSmac,ETHER_ADDR_LEN)==0)
				{
					if(((macEntry.isIVL==1) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
					((macEntry.isIVL==0) && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
					{
						//Record matched index of lut
						lut_matchIdx=search_index;

						_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.port, rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
						_rtk_rg_lutExtport_translator(&portIdx);
#endif
						if(pPktHdr->pRxDesc->rx_reason==RG_CPU_REASON_L2_LEARN_LIMIT_PERPORT /* SA learning limit */ || pPktHdr->pRxDesc->rx_reason==RG_CPU_REASON_UNKNOWN_SA /* unknown SA action */)
						{
							if(portIdx==ingressPort)
							{
								//Force SA learning
								TRACE("Forced SA learning...reason=%d",pPktHdr->pRxDesc->rx_reason);

								if(rg_db.lut[search_index].countingInLearningLimit)
									assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));

								//20170301LUKE: modify count when limit field is source mac.
								if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
								{
									if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx)&&rg_db.lut[search_index].permit_for_l34_forward)
										atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
									//decrease wlan's device count
									if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
										|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
										) && rg_db.lut[search_index].wlan_device_idx>=0)
									{
										if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx))&&rg_db.lut[search_index].permit_for_l34_forward)
											atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);

										wlan_move_orig=rg_db.lut[search_index].wlan_device_idx;
									}
#endif
								}
								port_move_orig=portIdx;		
								lut_orig=search_index;
								category_orig=rg_db.lut[search_index].category;
								permit_orig=rg_db.lut[search_index].permit_for_l34_forward;
								break;
							}
						}
						//DEBUG("match!!fix_l34_vlan:%d",rg_db.lut[search_index].fix_l34_vlan);
						//FIXME: here reserved for WiFi interface may also need to handle port-moving in the future.
						//FB: allow L2 bridge packet from disabled dmac2cvid port to update lut entry even this lut entry is static
						if(	!(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
							|| (rg_db.systemGlobal.initParam.macBasedTagDecision && (rg_db.systemGlobal.dmac2cvidDisabledPortmask & (0x1<<ingressPort)) && (portIdx==ingressPort) && pPktHdr->isGatewayPacket==0)
#endif
							)
						{
							//20140722LUKE: drop strange packet learned not in WAN but comeback in WAN
							if(portIdx!=ingressPort)
								if(((0x1<<ingressPort)&rg_db.systemGlobal.wanPortMask.portmask)&&(rg_db.systemGlobal.strangeSA_drop==RG_HWNAT_ENABLE))
									return RG_RET_FAIL;

							if(rg_db.systemGlobal.initParam.macBasedTagDecision &&
								((rg_db.systemGlobal.dmac2cvidDisabledPortmask & (0x1<<ingressPort))==0x0 || pPktHdr->isGatewayPacket==0) &&
#if defined(CONFIG_RG_RTL9600_SERIES)
								(macEntry.vlan_id!=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid && !rg_db.lut[search_index].fix_l34_vlan)
#else	// support ctag_if
								//20160818LUKE: check vlan-id only when we are tagif!!
								((macEntry.ctag_if && ((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0) && macEntry.vlan_id!=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid && !rg_db.lut[search_index].fix_l34_vlan)
									|| (macEntry.ctag_if!=((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0) && !rg_db.lut[search_index].fix_l34_vlan))
#endif
								)
							{
								if((((pPktHdr->tagif&IPV4_TAGIF)&&((pPktHdr->ipv4Dip&0xf0000000)==0xe0000000)) || ((pPktHdr->tagif&IPV6_TAGIF)&&((pPktHdr->pIpv6Dip[0])==0xff)))
									&& !((pPktHdr->tagif&PPPOE_TAGIF) && (pPktHdr->isGatewayPacket==0)))
								{
									TRACE("[L2 learning] Skip cvlan learning of multicast packet.");
								}
								else
								{
									TRACE("[L2 learning] Cvlan is changed !!");
									isVlanChange = TRUE;
								}
							}

							if((portIdx!=ingressPort)
								|| ((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<ingressPort)) && pPktHdr->wlan_dev_idx>=0 && pPktHdr->wlan_dev_idx!=rg_db.lut[search_index].wlan_device_idx)
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
								|| ((RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<ingressPort)) && pPktHdr->wlan_dev_idx>=0 && pPktHdr->wlan_dev_idx!=rg_db.lut[search_index].wlan_device_idx)
#endif
								|| (rg_db.systemGlobal.activeLimitFunction!=RG_ACCESSWAN_TYPE_UNLIMIT&&!rg_db.lut[search_index].permit_for_l34_forward)	//20160814LUKE: if we are not permited, continue check
								)
							{
								TRACE("[L2 learning] SPA/WlanDevice/permit_for_l34_forward is changed !!");
								isOtherChange = TRUE;
							}

							if((isVlanChange==TRUE) || (isOtherChange==TRUE))
							{
								//Mac port-moving or Vlan-moving or wlan-moving, update LUT table without change ARP_USED flag and auth field
								//------------------ Critical Section start -----------------------//
								//rg_lock(&rg_kernel.saLearningLimitLock);
								if(rg_db.lut[search_index].countingInLearningLimit)
									assert_ok(_rtk_rg_mac_learning_limit_count_dec(portIdx, rg_db.lut[search_index].wlan_device_idx));
								
								//20170301LUKE: modify count when limit field is source mac.
								if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
								{
									if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx) && rg_db.lut[search_index].permit_for_l34_forward)
										atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
								}
								else
								{
									//20170306LUKE: clear IP permit when port is moving out wan access limit port mask.
									if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<portIdx))
										_rtk_rg_wanAccessResetIPPermit(search_index);
								}
#ifdef CONFIG_MASTER_WLAN0_ENABLE
								//decrease wlan's device count
								if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<portIdx))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
									|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<portIdx))
#endif
									) && rg_db.lut[search_index].wlan_device_idx>=0)
								{
									//20170301LUKE: modify count when limit field is source mac.
									if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
									{
										if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx))&&rg_db.lut[search_index].permit_for_l34_forward)
											atomic_dec(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
									}
									else
									{
										//20170306LUKE: clear IP permit when port is moving out wan access limit port mask.
										if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx)))
											_rtk_rg_wanAccessResetIPPermit(search_index);
									}
									wlan_move_orig=rg_db.lut[search_index].wlan_device_idx;
								}
#endif
								port_move_orig=portIdx;
								
								if(portIdx <= RTK_RG_PORT_LASTCPU)
								{
									if(rg_db.systemGlobal.fix_l34_to_untag_enable==RG_HWNAT_ENABLE && (macEntry.vlan_id!=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid))
									{
										if(macEntry.vlan_id==0)
											macEntry.vlan_id=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid;
										MACLN("set fix_l34_vlan");
										macEntry.fix_l34_vlan=1;
									}
								}
								lut_orig=search_index;
								category_orig=rg_db.lut[search_index].category;
								permit_orig=rg_db.lut[search_index].permit_for_l34_forward;
								//------------------ Critical Section End -----------------------//
								//rg_unlock(&rg_kernel.saLearningLimitLock);

								macEntry.arp_used=((rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_ARP_USED)>0)?1:0;
								macEntry.auth=rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.auth;
								TRACE("the port moving or vlan changing..arp used is %d, auth is %d\n",macEntry.arp_used,macEntry.auth);
								break;
							}
						}
						
						//hit hardware! check if we had already add to sw, if port-moving, delete sw one...
						_rtk_rg_softwareLut_checkAndDelete(&rg_db.lut[search_index].rtk_lut.entry.l2UcEntry,l2Idx>>MAX_LUT_HASH_WAY_SHIFT);

						//Increase count of mac learning limit if match
						if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
							&& rg_db.lut[search_index].countingInLearningLimit==0)
						{
							//Check mac learning limit
							if(_rtk_rg_mac_learning_limit_check(portIdx, rg_db.lut[search_index].wlan_device_idx)==RG_RET_FAIL)
							{
								TRACE("Mac learning limit is reached...won't add MAC!!");
								return RG_RET_FAIL;
							}
							assert_ok(_rtk_rg_mac_learning_limit_count_inc(portIdx, rg_db.lut[search_index].wlan_device_idx));
							rg_db.lut[search_index].countingInLearningLimit = 1;
						}

						//Check vlan group mac learning limit
						if(_rtk_rg_vlanGroupMacLimit_check(pPktHdr, l2Idx>>MAX_LUT_HASH_WAY_SHIFT)==RG_RET_FAIL)
							return RG_RET_FAIL;

#if defined(CONFIG_RG_RTL9600_SERIES)
#else	//support lut traffic bit
						assert_ok(_rtk_rg_update_lutIdleTime(search_index));
#endif
						//20140811LUKE: keep src mac lut idx!!
						pPktHdr->smacL2Idx=search_index;

						goto ADD_IVL_LUT;
					}
				}
			}
		}

		if(first_invalid==-1)
			count=_rtk_rg_layer2GarbageCollection(l2Idx);		//check if there is asynchronus between software and hardware table
	}

	//Check if we had been add to software LUT link-list
	if(!list_empty(&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT]))
	{
		list_for_each_entry(pSoftLut,&rg_db.softwareLutTableHead[l2Idx>>MAX_LUT_HASH_WAY_SHIFT],lut_list)
		{
			if(memcmp(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.mac.octet,pPktHdr->pSmac,ETHER_ADDR_LEN)==0)
			{
				if(((macEntry.isIVL==1) && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid==macEntry.vlan_id) ||
				((macEntry.isIVL==0) && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.fid==macEntry.fid))
				{
					//HIT!
					MACLN("software LUT had been added before!!");
					pSoftLut_hit=pSoftLut;
					pPktHdr->smacL2Idx=pSoftLut->idx;
					break;
				}
			}
		}
	}

#if defined(CONFIG_RG_G3_SERIES)
	//20180508LUKE: unlearned sa rate limit check
	//20190620LUKE: if we are learned as soft lut, do not check limit.
	if(pSoftLut_hit==NULL && _rtk_rg_unlearnedSARateLimit_check()==RG_FWDENGINE_RET_DROP)
	{
		/*20180511LUKE: add count here because we drop before parser.
		if(rg_db.systemGlobal.fwdStatistic)rg_db.systemGlobal.statistic.perPortCnt_swLimt[ingressPort]++;*/
		return RG_RET_FAIL;
	}
#endif

	//Check vlan group mac learning limit
	if(_rtk_rg_vlanGroupMacLimit_check(pPktHdr, l2Idx>>MAX_LUT_HASH_WAY_SHIFT)==RG_RET_FAIL)
		return RG_RET_FAIL;

	//Check mac learning limit
	if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL
		&& _rtk_rg_mac_learning_limit_check(ingressPort, pPktHdr->wlan_dev_idx)==RG_RET_FAIL)
	{
		TRACE("Mac learning limit is reached...won't add MAC!!");
		if(lut_orig >= 0)
		{
			if(rg_db.lut[lut_orig].countingInLearningLimit)
				assert_ok(_rtk_rg_mac_learning_limit_count_inc(port_move_orig, wlan_move_orig));
			if(port_move_orig>=0 || wlan_move_orig>=0)
			{
				//delete original hw mac
				_rtk_rg_shortCut_clear();
				(pf.rtk_rg_macEntry_del)(lut_orig);
				//recovery count
				if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
				{
					if((port_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<port_move_orig)) && permit_orig)
						atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE					
					if((wlan_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<wlan_move_orig)) && permit_orig)
						atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#endif					
				}
			}
		}
		//exist software LUT, delete it before we drop
		if(pSoftLut_hit!=NULL)
		{
			//Delete from head list
			list_del_init(&pSoftLut_hit->lut_list);

			//Clear data
			//memset(&rg_db.lut[pSoftLut_hit->idx],0,sizeof(rtk_rg_table_lut_t));
			rg_db.lut[pSoftLut_hit->idx].valid=0;

			//Add back to free list
			list_add(&pSoftLut_hit->lut_list,&rg_db.softwareLutFreeListHead);
		}
		
		return RG_RET_FAIL;
	}

	//------------------ Critical Section start -----------------------//
	//rg_lock(&rg_kernel.saLearningLimitLock);
	if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_UNLIMIT)
	{
		TRACE("Wan Access Limit is turn off.");
	}
	else if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SIP)
	{
		//20170301LUKE: check mac limit only when field is source mac.
		TRACE("Wan Access Limit is By SIP.");
	}
	else
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
		if((int)pPktHdr->wlan_dev_idx!=(int)RG_WWAN_WLAN0_VXD && (int)pPktHdr->wlan_dev_idx!=(int)RG_WWAN_WLAN1_VXD)	//20150514LUKE: packet from WWAN should not check access limit
#endif
	{
		MACLN("Check portmask or category access WAN limit, dip is %x, dmac is %02x:%02x:%02x:%02x:%02x:%02x",pPktHdr->ipv4Dip,
			pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5]);

		//At first check spa locate at LAN or not
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->port_mask.portmask&(0x1<<ingressPort))
			{
				matchLanPort=1;
				if(_rtk_rg_serverInLanIP_check(pPktHdr)==RG_FWDENGINE_RET_CONTINUE){
					//20160525LUKE: check server-in-lan services for source IP!
					MACLN("server-in-lan service IP matched...learned to hw!");
					matchLanMac=1;
					break;
				}else if(memcmp(pPktHdr->pDmac,rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,ETHER_ADDR_LEN)==0){
					MACLN("Hit LAN[%d]!!Check if we are going to protocol stack or WAN",i);
					matchLanMac=1;
					ret=_rtk_rg_checkGwIp(pPktHdr);
					if(ret==RG_FWDENGINE_RET_TO_PS)
					{
						MACLN("goto protocol stack, so we just need software LUT as usual..");
						limit_action_mask|=0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2;
						matchLanIP=1;
						break;
					}
				}
			}
		}
		if(matchLanPort==1 && pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK)	//only care about LAN host
		{
			if(matchLanMac==0)
			{
				//20140716LUKE:if the wan access type is CATEGORY, layer2 traffic will add to software-LUT first
				if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_CATEGORY)
				{
					//Category:default set to category 0, if not learned before
					if(pSoftLut_hit==NULL)
					{
						//new added!! check default category
						if(port_move_orig<0 && wlan_move_orig<0)
						{
							check_category=1;
							category_orig=0;
						}

						//otherwise won't check category!!because we are already in hw..
					}
					else
					{
						//Check if this software LUT can add to hw
						check_category=1;
						category_orig=rg_db.lut[pSoftLut_hit->idx].category;
					}

					//Check if the spa is under LAN portmask
					if(_rtK_rg_checkCategoryPortmask_spa(ingressPort)!=SUCCESS)
						category_orig=0;

					if(check_category==1)
					{
						if(rg_db.systemGlobal.accessWanLimitCategory[category_orig]>=0 && rg_db.systemGlobal.accessWanLimitCategory[category_orig]<=atomic_read(&rg_db.systemGlobal.accessWanLimitCategoryCount[category_orig]))
						{
							MACLN("Category %d access WAN limit is reached(%d)...action is %s!!",category_orig,rg_db.systemGlobal.accessWanLimitCategory[category_orig],
								rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]==SA_LEARN_EXCEED_ACTION_PERMIT?"Permit and Forward":
								rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]==SA_LEARN_EXCEED_ACTION_PERMIT_L2?"Permit L2 only":"Drop");

							if(pSoftLut_hit!=NULL)
							{
								//maybe port-moving, renew sw LUT data
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
								if(pPktHdr->wlan_dev_idx>=0)
								{
									portIdx=ingressPort;
									_rtk_rg_wlanDevToPort_translator(pPktHdr->wlan_dev_idx, &portIdx);
									_rtk_rg_portToMacPort_translator(portIdx, &rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.port, &rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.ext_port);
								}else
#endif
								{
									rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.port=pPktHdr->ingressMacPort;
									rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.ext_port=pPktHdr->ingressMacExtPort;
								}

								if(ingressPort>RTK_RG_PORT_LASTCPU)
								{
									rg_db.lut[pSoftLut_hit->idx].wlan_device_idx=pPktHdr->wlan_dev_idx;
								}

								//maybe vlan-moving, renew sw LUT data
								rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.vid=macEntry.vlan_id;
								rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.fid=macEntry.fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	// support ctag_if
								if(macEntry.ctag_if)
									rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.flags|=RTK_L2_UCAST_FLAG_CTAG_IF;
								else
									rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.flags&=(~RTK_L2_UCAST_FLAG_CTAG_IF);
#endif
							}
							if(rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]==SA_LEARN_EXCEED_ACTION_DROP)
							{
								MACLN("Category Limit Action: DROP..");
								pr_err_ratelimited("[Error][WarnLog] Category Limit Action: Drop. SMAC:%02x-%02x-%02x-%02x-%02x-%02x SIP:%d.%d.%d.%d\n",
										pPktHdr->smac[0],pPktHdr->smac[1],pPktHdr->smac[2],pPktHdr->smac[3],pPktHdr->smac[4],pPktHdr->smac[5],
										(pPktHdr->ipv4Sip>>24)&0xff,(pPktHdr->ipv4Sip>>16)&0xff,(pPktHdr->ipv4Sip>>8)&0xff,(pPktHdr->ipv4Sip)&0xff);
								return RG_RET_FAIL;
							}

							//permit or permit_l2
							limit_action_mask|=0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2;
						}
						else
							limit_action_mask|=0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2;	//even the limit is not reach, L2 packet should not add to hw
					}
				}
				else if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_PORTMASK)
				{
					if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<(ingressPort))
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						|| (ingressPort==RTK_RG_EXT_PORT0 && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<pPktHdr->wlan_dev_idx)))
#endif
					)
					{
						if(rg_db.systemGlobal.accessWanLimitPortMask<=atomic_read(&rg_db.systemGlobal.accessWanLimitPortMaskCount))
						{
							MACLN("Portmask access WAN limit is reached(%d)...action is %s!!",rg_db.systemGlobal.accessWanLimitPortMask,
								rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT?"Permit and Forward":
								rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT_L2?"Permit L2 only":"Drop");

							//port-moving fail, recovery old count
							if((port_move_orig>=0 || wlan_move_orig>=0) && permit_orig)
							{
								//delete original hw mac
								_rtk_rg_shortCut_clear();
								(pf.rtk_rg_macEntry_del)(lut_orig);
							}
							if(rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_DROP)
							{
								if(lut_orig >= 0)
								{
									if(rg_db.lut[lut_orig].countingInLearningLimit)
										assert_ok(_rtk_rg_mac_learning_limit_count_inc(port_move_orig, wlan_move_orig));

									//recovery count
									if((port_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<port_move_orig)) && permit_orig)
										atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE					
									if((wlan_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<wlan_move_orig)) && permit_orig)
										atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#endif
								}

								//exist software LUT, delete it before we drop
								if(pSoftLut_hit!=NULL)
								{
									//Delete from head list
									list_del_init(&pSoftLut_hit->lut_list);

									//Clear data
									//memset(&rg_db.lut[pSoftLut_hit->idx],0,sizeof(rtk_rg_table_lut_t));
									rg_db.lut[pSoftLut_hit->idx].valid=0;
									MACLN("lut[%d] is set to invalid!",pSoftLut_hit->idx);

									//Add back to free list
									list_add(&pSoftLut_hit->lut_list,&rg_db.softwareLutFreeListHead);
								}
								MACLN("Portmask Limit Action: DROP..");
								pr_err_ratelimited("[Error][WarnLog] Portmask Limit Action: Drop. SMAC:%02x-%02x-%02x-%02x-%02x-%02x SIP:%d.%d.%d.%d\n",
										pPktHdr->smac[0],pPktHdr->smac[1],pPktHdr->smac[2],pPktHdr->smac[3],pPktHdr->smac[4],pPktHdr->smac[5],
										(pPktHdr->ipv4Sip>>24)&0xff,(pPktHdr->ipv4Sip>>16)&0xff,(pPktHdr->ipv4Sip>>8)&0xff,(pPktHdr->ipv4Sip)&0xff);
								return RG_RET_FAIL;
							}
							//permit_l2
							limit_action_mask|=0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2;
						}
						else
							limit_action_mask|=0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2;	//even the limit is not reach, L2 packet should not add to hw
					}
				}
			}
			else if(matchLanIP==0)
			{
				//to WAN!!we have to check limit, if over limit, add to SW and trigger ReachLimit
				//if not over limit, add to HW, and add count
				MACLN("to WAN or server-in-lan service!! activeLimitFunction is %d",rg_db.systemGlobal.activeLimitFunction);
				if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_CATEGORY)
				{
					//Category:default set to category 0, if not learned before
					if(pSoftLut_hit==NULL)
					{
						//new added!! check default category
						if(port_move_orig<0 && wlan_move_orig<0)
						{
							check_category=1;
							category_orig=0;
						}

						//otherwise won't check category!!because we are already in hw..
					}
					else
					{
						//Check if this software LUT can add to hw
						check_category=1;
						category_orig=rg_db.lut[pSoftLut_hit->idx].category;
					}

					//Check if the spa is under LAN portmask
					if(_rtK_rg_checkCategoryPortmask_spa(ingressPort)!=SUCCESS)
						category_orig=0;

					if(check_category==1 && rg_db.systemGlobal.accessWanLimitCategory[category_orig]>=0 &&
						rg_db.systemGlobal.accessWanLimitCategory[category_orig]<=atomic_read(&rg_db.systemGlobal.accessWanLimitCategoryCount[category_orig]))	//no way to learn
					{
						//------------------ Critical Section End -----------------------//
						//rg_unlock(&rg_kernel.saLearningLimitLock);
						MACLN("Category %d access WAN limit is reached(%d)...action is %s!!",category_orig,rg_db.systemGlobal.accessWanLimitCategory[category_orig],
							rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]==SA_LEARN_EXCEED_ACTION_PERMIT?"Permit and Forward":
							rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]==SA_LEARN_EXCEED_ACTION_PERMIT_L2?"Permit L2 only":"Drop");

						if(rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]!=SA_LEARN_EXCEED_ACTION_PERMIT)
						{
							if(pSoftLut_hit!=NULL)
							{
								//maybe port-moving, renew sw LUT data
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
								if(pPktHdr->wlan_dev_idx>=0)
								{
									portIdx=ingressPort;
									_rtk_rg_wlanDevToPort_translator(pPktHdr->wlan_dev_idx, &portIdx);
									_rtk_rg_portToMacPort_translator(portIdx, &rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.port, &rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.ext_port);
								}else
#endif
								{
									rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.port=pPktHdr->ingressMacPort;
									rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.ext_port=pPktHdr->ingressMacExtPort;
								}

								if(ingressPort>RTK_RG_PORT_LASTCPU)
								{
									rg_db.lut[pSoftLut_hit->idx].wlan_device_idx=pPktHdr->wlan_dev_idx;
								}
							}
							if(rg_db.systemGlobal.accessWanLimitCategoryAction[category_orig]==SA_LEARN_EXCEED_ACTION_DROP)
							{
								MACLN("Category Limit Action: DROP..");
								pr_err_ratelimited("[Error][WarnLog] Category Limit Action: Drop. SMAC:%02x-%02x-%02x-%02x-%02x-%02x SIP:%d.%d.%d.%d\n",
										pPktHdr->smac[0],pPktHdr->smac[1],pPktHdr->smac[2],pPktHdr->smac[3],pPktHdr->smac[4],pPktHdr->smac[5],
										(pPktHdr->ipv4Sip>>24)&0xff,(pPktHdr->ipv4Sip>>16)&0xff,(pPktHdr->ipv4Sip>>8)&0xff,(pPktHdr->ipv4Sip)&0xff);
								return RG_RET_FAIL;
							}

							//permit_l2
							limit_action_mask|=0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2;
						}
					}
				}
				else
				{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					MACLN("portmask is %x, wlan_dev_mask is %x, spa is %x, wlan_dev_idx is %x, limit is %d count is %d",
						rg_db.systemGlobal.accessWanLimitPortMask_member.portmask,
						rg_db.systemGlobal.accessWanLimitPortMask_wlan0member,
						0x1<<ingressPort,pPktHdr->wlan_dev_idx,rg_db.systemGlobal.accessWanLimitPortMask,
						atomic_read(&rg_db.systemGlobal.accessWanLimitPortMaskCount));
#endif
					if(rg_db.systemGlobal.accessWanLimitPortMask<=atomic_read(&rg_db.systemGlobal.accessWanLimitPortMaskCount))
					{

						if((rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<(ingressPort)))
#ifdef CONFIG_MASTER_WLAN0_ENABLE
							|| (ingressPort==RTK_RG_EXT_PORT0 && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<pPktHdr->wlan_dev_idx)))
#endif
						)
						{
							MACLN("Portmask access WAN limit is reached(%d)...action is %s!!",rg_db.systemGlobal.accessWanLimitPortMask,
								rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT?"Permit and Forward":
								rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_PERMIT_L2?"Permit L2 only":"Drop");

							if(rg_db.systemGlobal.accessWanLimitPortMaskAction!=SA_LEARN_EXCEED_ACTION_PERMIT)
							{
								if((port_move_orig>=0 || wlan_move_orig>=0) && permit_orig)
								{
									//delete original hw mac
									_rtk_rg_shortCut_clear();
									(pf.rtk_rg_macEntry_del)(lut_orig);
								}								
								if(rg_db.systemGlobal.accessWanLimitPortMaskAction==SA_LEARN_EXCEED_ACTION_DROP)
								{
									//port-moving fail, recovery old count
									if(lut_orig >= 0)
									{
										if(rg_db.lut[lut_orig].countingInLearningLimit)
											assert_ok(_rtk_rg_mac_learning_limit_count_inc(port_move_orig, wlan_move_orig));

										//recovery count
										if((port_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<port_move_orig)) && permit_orig)
											atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#ifdef CONFIG_MASTER_WLAN0_ENABLE
										if((wlan_move_orig>=0) && (rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<wlan_move_orig)) && permit_orig)
											atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
#endif
									}
									
									//exist software LUT, delete it before we drop
									if(pSoftLut_hit!=NULL)
									{
										//Delete from head list
										list_del_init(&pSoftLut_hit->lut_list);

										//Clear data
										//memset(&rg_db.lut[pSoftLut_hit->idx],0,sizeof(rtk_rg_table_lut_t));
										rg_db.lut[pSoftLut_hit->idx].valid=0;
										MACLN("lut[%d] is set to invalid!",pSoftLut_hit->idx);

										//Add back to free list
										list_add(&pSoftLut_hit->lut_list,&rg_db.softwareLutFreeListHead);
									}
									MACLN("Portmask Limit Action: DROP..");
									pr_err_ratelimited("[Error][WarnLog] Portmask Limit Action: Drop. SMAC:%02x-%02x-%02x-%02x-%02x-%02x SIP:%d.%d.%d.%d\n",
											pPktHdr->smac[0],pPktHdr->smac[1],pPktHdr->smac[2],pPktHdr->smac[3],pPktHdr->smac[4],pPktHdr->smac[5],
											(pPktHdr->ipv4Sip>>24)&0xff,(pPktHdr->ipv4Sip>>16)&0xff,(pPktHdr->ipv4Sip>>8)&0xff,(pPktHdr->ipv4Sip)&0xff);
									return RG_RET_FAIL;
								}
								//permit_l2
								limit_action_mask|=(0x1<<rg_db.systemGlobal.accessWanLimitPortMaskAction);
							}
						}
					}
				}
			}
		}
	}
	//------------------ Critical Section End -----------------------//
	//rg_unlock(&rg_kernel.saLearningLimitLock

	//Decide lut index
	if(lut_matchIdx>=0 && rg_db.lut[lut_matchIdx].valid==0)
	{
		if(lut_matchIdx<LUT_HW_TABLE_SIZE)
		{
			if(first_invalid<0 || (first_invalid>=0 && lut_matchIdx<first_invalid))
				first_invalid = lut_matchIdx;
		}
		lut_matchIdx = FAIL;
	}
	if(lut_matchIdx>=0)
	{
		search_index = lut_matchIdx;
	}
	else
	{
		if(first_invalid>=0)
		{
			search_index = first_invalid;
		}
		else	//When the 4-way is full, check the bCAM list for free to add. If the bCAM is also full, do LRU.
		{
			search_index = _rtk_rg_layer2LeastRecentlyUsedReplace(l2Idx, FAIL);
			if(search_index==RG_RET_ENTRY_NOT_GET)
			{
				FIXME("must add software LUT entry for LUT entry full.");
				return RG_RET_FAIL;
			}

		}
	}

	memcpy(macEntry.mac.octet,pPktHdr->pSmac,ETHER_ADDR_LEN);
	//set SVL for lanIntf, patched in 201221203
	//macEntry.fid=LAN_FID;
	//macEntry.isIVL=0;
	macEntry.port_idx=ingressPort;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
	if(lut_orig>=0)
		macEntry.static_entry=(rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_STATIC)?1:0;
	else
#endif
		macEntry.static_entry=0;	//FIXME:here turn off static entry to enable hardware auto age-out and port-moving

	//20150515LUKE: for WWAN port-moving, we should update hw directly without add sw lut
	if(limit_action_mask>0
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
	 || (port_move_orig<0 && ((int)pPktHdr->wlan_dev_idx==(int)RG_WWAN_WLAN0_VXD || (int)pPktHdr->wlan_dev_idx==(int)RG_WWAN_WLAN1_VXD))
#endif
	)
	{
		MACLN("add to software LUT only..");

		//over limit!!if not added before and not port-moving, add to software link list
		if(pSoftLut_hit==NULL)
		{
			MACLN("add new MAC[sw]!!");
			//move MAC from hardward to software
			ret=_rtk_rg_softwareLut_add(&macEntry,l2Idx>>MAX_LUT_HASH_WAY_SHIFT,0,pPktHdr->wlan_dev_idx);
			if(ret==RG_RET_FAIL)
			{
				TRACE("add sw lut fail!!");
			}
			else
			{
				pPktHdr->smacL2Idx=ret;
				DEBUG("### add sw l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x SPA=%d ###\n", pPktHdr->smacL2Idx, pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
					pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],ingressPort);
				TRACE("sw l2[%d](%02x:%02x:%02x:%02x:%02x:%02x) learning at Port=%d\n", pPktHdr->smacL2Idx, pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
					pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],ingressPort);
			}
		}
		else
		{
			//maybe port-moving, renew sw LUT data
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
			if(pPktHdr->wlan_dev_idx>=0)
			{
				portIdx=ingressPort;
				_rtk_rg_wlanDevToPort_translator(pPktHdr->wlan_dev_idx, &portIdx);
				_rtk_rg_portToMacPort_translator(portIdx, &rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.port, &rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.ext_port);
			}else
#endif
			{
				rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.port=pPktHdr->ingressMacPort;
				rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.ext_port=pPktHdr->ingressMacExtPort;
			}

			if(ingressPort>RTK_RG_PORT_LASTCPU)
			{
				rg_db.lut[pSoftLut_hit->idx].wlan_device_idx=pPktHdr->wlan_dev_idx;
			}
			else
			{
				if(rg_db.systemGlobal.fix_l34_to_untag_enable==RG_HWNAT_ENABLE && (macEntry.vlan_id!=rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.vid))
				{
					if(rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.vid==0)
						rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.vid=macEntry.vlan_id;
					MACLN("set fix_l34_vlan");
					rg_db.lut[pSoftLut_hit->idx].fix_l34_vlan=1;
				}
			}

			//maybe vlan-moving, renew sw LUT data
			rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.vid=macEntry.vlan_id;
			rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.fid=macEntry.fid;
#if defined(CONFIG_RG_RTL9600_SERIES)
#else	// support ctag_if
			if(macEntry.ctag_if)
				rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.flags|=RTK_L2_UCAST_FLAG_CTAG_IF;
			else
				rg_db.lut[pSoftLut_hit->idx].rtk_lut.entry.l2UcEntry.flags&=(~RTK_L2_UCAST_FLAG_CTAG_IF);
#endif

			//20160310LUKE: if ctagif changes, modify shortcut's dmac2cvidTagif for new_lut_idx as this one.
#if !defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			_rtk_rg_layer2DeleteDiffCTagifShortcut(pSoftLut_hit->idx,(pPktHdr->tagif&CVLAN_TAGIF)>0?1:0, FALSE);
#endif
		}

		//trigger for ARP and Neighbor discovery for port, mask, and category
		//if this packet match LANIP, just pass lookup procedure
		if(matchLanIP==0 && matchLanMac==1)
		{
			//port-moving fail, recovery old count
			if(port_move_orig>=0 && permit_orig)
			{
				//20170301LUKE: modify count when limit field is source mac.
				if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC){
					if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<(port_move_orig)))
						atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
				}
			}

			switch(rg_db.systemGlobal.activeLimitFunction)
			{
				//send by all ARP and ND of all port in port mask
				case RG_ACCESSWAN_TYPE_PORTMASK:
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					_rtk_rg_lutReachLimit_init(RG_ACCESSWAN_TYPE_PORTMASK, _rtk_rg_lutReachLimit_portmask, (unsigned long)(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask|(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member<<16)));
#else
					_rtk_rg_lutReachLimit_init(RG_ACCESSWAN_TYPE_PORTMASK, _rtk_rg_lutReachLimit_portmask, (unsigned long)rg_db.systemGlobal.accessWanLimitPortMask_member.portmask);
#endif
					break;
				//send by all ARP and ND of same category
				case RG_ACCESSWAN_TYPE_CATEGORY:
					_rtk_rg_lutReachLimit_init(RG_ACCESSWAN_TYPE_CATEGORY, _rtk_rg_lutReachLimit_category, (unsigned long)category_orig);
					break;
				default:
					break;
			}
		}

		if(limit_action_mask&(0x1<<SA_LEARN_EXCEED_ACTION_PERMIT_L2))
		{
			pPktHdr->swLutL2Only=1;
		}
		// Only RG_ACCESSWAN_TYPE_PORTMASK or RG_ACCESSWAN_TYPE_CATEGORY will go into this block
		//if(rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_PORTMASK || rg_db.systemGlobal.activeLimitFunction==RG_ACCESSWAN_TYPE_CATEGORY)
		{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			//dose not update cvid if this L34 packet is from disabled dmac2cvid port.
			if(lut_orig>=0 && rg_db.systemGlobal.initParam.macBasedTagDecision && (rg_db.systemGlobal.dmac2cvidDisabledPortmask & (0x1<<ingressPort)) && pPktHdr->isGatewayPacket)
			{
				DEBUG("L34 packet is from disabled dmac2cvid port, skip vid learning. use origianl vid[%d] tagif=%d", rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.vid, (rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0);
				macEntry.vlan_id=rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.vid;
				macEntry.ctag_if=(rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0;
			}
#endif
			macEntry.wlan_device_idx=pPktHdr->wlan_dev_idx;
			macEntry.countingInLearningLimit = (rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL) ? 1 : 0;
				
			//20160814LUKE: for bridge MAC we add to hw here.
			ret=(pf.rtk_rg_macEntry_add)(&macEntry,&search_index);
			//DEBUG("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x SPA=%d ###\n",search_index,pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
			//	pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],ingressPort);
			TRACE("MAC[%d](%02x:%02x:%02x:%02x:%02x:%02x) learning at Port=%d\n",search_index,pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
				pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],ingressPort);
			assert_ok(ret);

			if(macEntry.countingInLearningLimit)
			{
				assert_ok(_rtk_rg_mac_learning_limit_count_inc(ingressPort, pPktHdr->wlan_dev_idx));
			}
			
			pPktHdr->smacL2Idx=search_index;
			//20160822LUKE: if we are do bridging only, turn off permit bit.
			if(permit_orig>0)rg_db.lut[search_index].permit_for_l34_forward=0;				
		}
	}
	else
	{
		MACLN("add to HW LUT!!");
		//exist software LUT, delete it before we add to HW
		if(pSoftLut_hit!=NULL)
		{
			//Delete from head list
			list_del_init(&pSoftLut_hit->lut_list);

			//Clear data
			//memset(&rg_db.lut[pSoftLut_hit->idx],0,sizeof(rtk_rg_table_lut_t));
			rg_db.lut[pSoftLut_hit->idx].valid=0;

			//Add back to free list
			list_add(&pSoftLut_hit->lut_list,&rg_db.softwareLutFreeListHead);
		}
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		//dose not update cvid if this L34 packet is from disabled dmac2cvid port.
		if(lut_orig>=0 && rg_db.systemGlobal.initParam.macBasedTagDecision && (rg_db.systemGlobal.dmac2cvidDisabledPortmask & (0x1<<ingressPort)) && pPktHdr->isGatewayPacket)
		{
			DEBUG("L34 packet is from disabled dmac2cvid port, skip vid learning. use origianl vid[%d] tagif=%d", rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.vid, (rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0);
			macEntry.vlan_id=rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.vid;
			macEntry.ctag_if=(rg_db.lut[lut_orig].rtk_lut.entry.l2UcEntry.flags&RTK_L2_UCAST_FLAG_CTAG_IF)?1:0;
		}
#endif
		macEntry.wlan_device_idx=pPktHdr->wlan_dev_idx;
		macEntry.countingInLearningLimit = (rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_SVL) ? 1 : 0;
		
		//add to both software and hardware
		ret=(pf.rtk_rg_macEntry_add)(&macEntry,&search_index);
		//DEBUG("### add l2[%d]=%02x:%02x:%02x:%02x:%02x:%02x SPA=%d ###\n",search_index,pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
		//	pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],spa);
		TRACE("MAC[%d](%02x:%02x:%02x:%02x:%02x:%02x) learning at Port=%d\n",search_index,pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],
			pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],ingressPort);
		assert_ok(ret);

#ifdef CONFIG_RG_WLAN_HWNAT_ACCELERATION
		if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<ingressPort))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
			|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<ingressPort))
#endif
			) && pPktHdr->wlan_dev_idx>=0) //update mbssid table
		{
			_rtk_rg_wlanMbssidLearning(pPktHdr->pSmac,pPktHdr);
		}
#endif

		if(macEntry.countingInLearningLimit)
		{
			assert_ok(_rtk_rg_mac_learning_limit_count_inc(ingressPort, pPktHdr->wlan_dev_idx));
		}

		//------------------ Critical Section start -----------------------//
		//rg_lock(&rg_kernel.saLearningLimitLock);
		//if MAC already added in hw, recovery it's category from old record
		rg_db.lut[search_index].category=category_orig;
		rg_db.lut[search_index].permit_for_l34_forward=1;

		//20170301LUKE: modify count when limit field is source mac.
		if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
		{
			if((port_move_orig<0||pSoftLut_hit!=NULL) && (category_orig>=0) && _rtK_rg_checkCategoryPortmask_spa(ingressPort)==SUCCESS)
				atomic_inc(&rg_db.systemGlobal.accessWanLimitCategoryCount[category_orig]);
			if(rg_db.systemGlobal.accessWanLimitPortMask_member.portmask&(0x1<<ingressPort))
				atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
		}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
		//increase wlan's device count
		if(((RTK_RG_ALL_MASTER_EXT_PORTMASK&(0x1<<ingressPort))
#if defined(CONFIG_DUALBAND_CONCURRENT) || defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
			|| (RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<ingressPort))
#endif
			) && rg_db.lut[search_index].wlan_device_idx>=0)
		{
			//20170301LUKE: modify count when limit field is source mac.
			if(rg_db.systemGlobal.activeLimitField==RG_ACCESSWAN_LIMIT_BY_SMAC)
				if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<(rg_db.lut[search_index].wlan_device_idx)))
					atomic_inc(&rg_db.systemGlobal.accessWanLimitPortMaskCount);
		}
#endif
		//20140811LUKE: keep src mac lut idx!!
		pPktHdr->smacL2Idx=search_index;
		//20160310LUKE: if ctagif changes, modify shortcut's dmac2cvidTagif for new_lut_idx as this one.
		if(lut_orig>=0)_rtk_rg_layer2DeleteDiffCTagifShortcut(search_index,(pPktHdr->tagif&CVLAN_TAGIF)>0?1:0, (isVlanChange==TRUE && isOtherChange==FALSE)?TRUE:FALSE);
		//------------------ Critical Section End -----------------------//
		//rg_unlock(&rg_kernel.saLearningLimitLock);
	}

ADD_IVL_LUT:
#if defined(CONFIG_RG_RTL9602C_SERIES)
	if(rg_kernel.block_communication_between_internet_and_other)
	{
		ret = _rtk_rg_create_ivlMacEntries_of_internalUsedVid(search_index, check_ivl_vid, ingressPort, pPktHdr->wlan_dev_idx);
		if(ret!=RT_ERR_RG_OK)
		{
			WARNING("Fail to create ivl mac entries, ret=0x%x", ret);
			return RG_RET_FAIL;
		}
	}
	else
#endif
	//Add IVL lut entry (Do not move!)
	if(rg_db.vlan[check_ivl_vid].fidMode==VLAN_FID_IVL)
	{
		ret = _rtk_rg_ivlMacEntry_add(search_index, check_ivl_vid, ingressPort, pPktHdr->wlan_dev_idx, &ivlL2Idx);
		if(ret!=RT_ERR_RG_OK)
		{
			WARNING("Fail to create the corresponding ivl mac entry, ret=0x%x", ret);
			return RG_RET_FAIL;
		}
	}

	return RG_RET_SUCCESS;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_layer2Agent(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	rtk_rg_successFailReturn_t sf_ret=RG_RET_SUCCESS;

	//20190801LUKE: avoid layer2Agent mutiple entrance.
	if(pPktHdr->l2AgentCalled)return RG_FWDENGINE_RET_L2FORWARDED;

 	//Drop multicast SMAC here
 	if((pPktHdr->pSmac[0]&0x1)>0)
 	{
  		//dump_hs();
  		//dump_packet(skb->data,64,"");
#if 0//def __KERNEL__
  		printk("Strange multicast source mac len=%d, psmac=0x%x",skb->len,(unsigned int)((POINTER_CAST)pPktHdr->pSmac&0xffff));
		//memDump((u8*)((u32)skb->data),64,"");
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
		//20170331LUKE: FIXME for 9607C cached address may not start from 0xa0000000.
		dump_packet(skb->data,64,"");
#else
		dump_packet((u8*)((u32)skb->data|0xa0000000),64,"");
#endif
#endif
  		DEBUG("[Drop] Drop strange multicast packet...");
		rg_db.systemGlobal.statistic.perPortCnt_MC_SMAC_Drop[pPktHdr->ingressPort]++;
  		return RG_FWDENGINE_RET_DROP;
 	}

	if((RTK_RG_ALL_CPU_PORTMASK&(0x1<<pPktHdr->ingressPort))==0)
	{
		//20160816LUKE: for bridge MAC learned in sw, use version 1, otherwise use version 2.
		switch(CONFIG_RG_ACCESSWAN_VERSION){
			case 1:
			case 2:
			default:
	 			sf_ret=_rtk_rg_layer2LutLearningV2(skb,pPktHdr);
	 			break;
		}
	}

	if(pPktHdr->smacL2Idx==FAIL)
	{
		for(i=0;i<MAX_NETIF_SW_TABLE_SIZE;i++)
		{
			if(rg_db.netif[i].rtk_netif.valid == 1)
			{
				if(memcmp(pPktHdr->pSmac,rg_db.netif[i].rtk_netif.gateway_mac.octet,ETHER_ADDR_LEN)==0)
				{
					pPktHdr->smacL2Idx=rg_db.netif[i].l2_idx;
					break;
				}
			}
		}
		if(pPktHdr->smacL2Idx==FAIL)
		{
			TRACE("SMAC is not found in lut table, pPktHdr->smacL2Idx=%d(dummy index)", rg_db.systemGlobal.defaultTrapLUTIdx);
			pPktHdr->smacL2Idx=rg_db.systemGlobal.defaultTrapLUTIdx;
		}
	}
	else
	{
		//update ip address
		if(pPktHdr->tagif&IPV4_TAGIF)
		{
			rg_db.lut[pPktHdr->smacL2Idx].lutIP4addr=pPktHdr->ipv4Sip;
		}
		else if (pPktHdr->tagif&IPV6_TAGIF)
		{
			memcpy(rg_db.lut[pPktHdr->smacL2Idx].lutIP6addr,pPktHdr->pIpv6Sip,16);
		}	

	}

	pPktHdr->l2AgentCalled=1;
	if(sf_ret==RG_RET_SUCCESS)
		return RG_FWDENGINE_RET_L2FORWARDED;
	else
	{
		TRACE("[Drop] drop because sa learning limit action or unknown VLAN id");
		return RG_FWDENGINE_RET_DROP;		//drop because sa learning limit action or unknown VLAN id
	}
}

rtk_rg_err_code_t _rtk_rg_l2_nextValidEntry_get(int32 *pScanIdx, rtk_l2_addr_table_t *pL2Entry)
{
	int32 startIdx;

	if(pScanIdx==NULL || pL2Entry==NULL)
		RETURN_ERR (RT_ERR_RG_NULL_POINTER);
	if(*pScanIdx<0 || *pScanIdx>=MAX_LUT_HW_TABLE_SIZE)
		RETURN_ERR (RT_ERR_RG_INVALID_PARAM);

	startIdx = *pScanIdx;
	do
	{
		if(rg_db.lut[*pScanIdx].valid)
		{
			memcpy(pL2Entry, &rg_db.lut[*pScanIdx].rtk_lut, sizeof(rtk_l2_addr_table_t));
			return RT_ERR_RG_OK;
		}

		(*pScanIdx)++;
		if(*pScanIdx>=MAX_LUT_HW_TABLE_SIZE) *pScanIdx = 0;
	}while(*pScanIdx!=startIdx);

	return RT_ERR_RG_ENTRY_NOT_FOUND;
}

// Return matched or free lut index
rtk_rg_lutIdx_return_t _rtk_rg_lutIdx_find(u8 *pMac, int vlanId, int *lutIdx)
{
	int i, l2Idx, search_index, matchedIdx=FAIL, firstFreeIdx=FAIL;

	if(rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL)
	{
		l2Idx=_rtk_rg_hash_mac_vid_efid(pMac,vlanId,0); 	//FIXME;current efid is always 0
	}
	else
	{
		l2Idx=_rtk_rg_hash_mac_fid_efid(pMac,rg_db.vlan[vlanId].fid,0); 	//FIXME;current efid is always 0
	}

	for(i=0; i<MAX_LUT_HASH_WAY_SIZE; i++)
	{
		search_index= (l2Idx<<MAX_LUT_HASH_WAY_SHIFT) + i;

		if(rg_db.lut[search_index].valid==0)
		{
			if(firstFreeIdx==FAIL)
				firstFreeIdx = search_index;

			continue;
		}
		if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC
			&& (!memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet, pMac, ETHER_ADDR_LEN)))
		{
			if((rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==vlanId) ||
				(rg_db.vlan[vlanId].fidMode==VLAN_FID_SVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==rg_db.vlan[vlanId].fid))
			{
				//HIT!
				matchedIdx = search_index;
				break;
			}
		}
	}

	if(matchedIdx==FAIL)
	{
		//Check CAM LUT, if match, just return
		for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE; search_index<MAX_LUT_HW_TABLE_SIZE; search_index++)
		{
			if(rg_db.lut[search_index].valid==0)
			{
				if(firstFreeIdx==FAIL)
					firstFreeIdx = search_index;

				continue;
			}
			if(rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC
				&& (memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pMac,ETHER_ADDR_LEN)==0))
			{
				if((rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==vlanId) ||
					(rg_db.vlan[vlanId].fidMode==VLAN_FID_SVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==rg_db.vlan[vlanId].fid))
				{
					//HIT!
					matchedIdx = search_index;
					break;
				}
			}
		}
	}

	if(matchedIdx != FAIL)
	{
		TRACE("Find matched lut[%d] of %pM, isIVL=%d", matchedIdx, pMac, (rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL)?1:0);
		*lutIdx = matchedIdx;
		return RG_RET_LUTIDX_FOUND;
	}
	else if(firstFreeIdx != FAIL)
	{
		TRACE("Find free lut[%d] for %pM, isIVL=%d", firstFreeIdx, pMac, (rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL)?1:0);
		*lutIdx = firstFreeIdx;
		return RG_RET_LUTIDX_NOT_FOUND;
	}
	else
	{
		TRACE("No free lut entry for %pM, isIVL=%d", pMac, (rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL)?1:0);
		return RG_RET_LUTIDX_NOFREE;
	}

}


rtk_rg_lookupIdxReturn_t _rtk_rg_macLookup(u8 *pMac, int vlanId, uint8 checkSwlut)
{
	int l2Idx,search_index;
	int count=0;
	rtk_rg_lut_linkList_t *pSoftLut;

	if(rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL)
	{
		l2Idx=_rtk_rg_hash_mac_vid_efid(pMac,vlanId,0);		//FIXME;current efid is always 0
	}
	else
	{
		l2Idx=_rtk_rg_hash_mac_fid_efid(pMac,rg_db.vlan[vlanId].fid,0);		//FIXME;current efid is always 0
	}

	do
	{
		search_index= (l2Idx<<MAX_LUT_HASH_WAY_SHIFT)+count;
		//TRACE("search Idx=%d vlanID=%d FID=%d",search_index,vlanId,rg_db.vlan[vlanId].fid);
		if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC &&
			(!memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pMac,ETHER_ADDR_LEN)))
		{
			if((rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==vlanId) ||
				(rg_db.vlan[vlanId].fidMode==VLAN_FID_SVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==rg_db.vlan[vlanId].fid))
			{
				return search_index;
			}
		}

		count++; //search from next entry
	}
	while(count < MAX_LUT_HASH_WAY_SIZE);

	//Check bCAM LUT, if match, just return
	for(search_index=MAX_LUT_HW_TABLE_SIZE-MAX_LUT_BCAM_TABLE_SIZE;search_index<MAX_LUT_HW_TABLE_SIZE;search_index++)
	{
		if(rg_db.lut[search_index].valid && rg_db.lut[search_index].rtk_lut.entryType==RTK_LUT_L2UC)
		{
			if(memcmp(rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.mac.octet,pMac,ETHER_ADDR_LEN)==0)
			{
				if((rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.vid==vlanId) ||
				(rg_db.vlan[vlanId].fidMode==VLAN_FID_SVL && rg_db.lut[search_index].rtk_lut.entry.l2UcEntry.fid==rg_db.vlan[vlanId].fid))
				{
					//HIT!
					return search_index;
				}
			}
		}
	}

	if(checkSwlut)
	{
		//Check if we had been add to software LUT link-list
		if(!list_empty(&rg_db.softwareLutTableHead[l2Idx]))
		{
			list_for_each_entry(pSoftLut,&rg_db.softwareLutTableHead[l2Idx],lut_list)
			{
				if(memcmp(rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.mac.octet,pMac,ETHER_ADDR_LEN)==0)
				{
					if((rg_db.vlan[vlanId].fidMode==VLAN_FID_IVL && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.vid==vlanId) ||
					(rg_db.vlan[vlanId].fidMode==VLAN_FID_SVL && rg_db.lut[pSoftLut->idx].rtk_lut.entry.l2UcEntry.fid==rg_db.vlan[vlanId].fid))
					{
						//HIT!
						MACLN("software LUT had been learned before!!");
						return pSoftLut->idx;
					}
				}
			}
		}
	}

	return RG_RET_LOOKUPIDX_NOT_FOUND;

}

rtk_rg_fwdEngineReturn_t _rtk_rg_checkIPv6MulticastScope(rtk_rg_pktHdr_t *pPktHdr)
{
	if(rg_db.systemGlobal.mcast_resvedAddr_hwFwd2pptp)
		return RG_FWDENGINE_RET_BROADCAST;

	switch(pPktHdr->pIpv6Dip[1]&0xf){
		case 0x0:	// 0  reserved
		case 0x1:	// 1   Interface-Local scope
		//case 0x2:	// 2  Link-Local scope
			TRACE("[Drop] drop by checking of ipv6 multicast scope");
			return RG_FWDENGINE_RET_DROP;
		default:
			return RG_FWDENGINE_RET_BROADCAST;
	}
}

__SRAM_FWDENG_SLOWPATH
rtk_rg_fwdEngineReturn_t _rtk_rg_layer2Forward(struct sk_buff *skb, rtk_rg_pktHdr_t *pPktHdr)
{
	rtk_rg_fwdEngineReturn_t ret;
	int l2Idx;
	//uint8 WANIntfMask=0;
	l2Idx=FAIL;

	/* Handle software Learning of LUT table*/
#ifdef CONFIG_RG_LAYER2_SOFTWARE_LEARN
	//if(pPktHdr->isGatewayPacket == 0)	//DA =\= Gateway MAC, do Layer2 agent
	//{
		ret=_rtk_rg_layer2Agent(skb,pPktHdr);
		if(ret!=RG_FWDENGINE_RET_L2FORWARDED)return ret;		//multicast packet may return to PS
	//}
#endif

	/* Handle multicast IGMP/MLD packet*/
#ifdef __KERNEL__
	if(rg_db.systemGlobal.initParam.igmpSnoopingEnable)
	{
		rtk_rg_port_idx_t portIdx=pPktHdr->ingressPort;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
		if(pPktHdr->wlan_dev_idx>=0)
		{
			_rtk_rg_wlanDevToPort_translator(pPktHdr->wlan_dev_idx,&portIdx);
		}
#endif
		ret=_rtk_rg_multicastRxCheck(skb,pPktHdr,portIdx);
		if (rg_db.pktHdr->ingressIgmpMldDrop)
		{
			TRACE("[Drop] ingress igmp/mld drop by igmp module");
			return RG_FWDENGINE_RET_DROP;
		}
	}
#endif

	/* Handle packet has special CPU trap reason*/
#if !defined(CONFIG_RG_G3_SERIES)
	switch(pPktHdr->pRxDesc->rx_reason)
	{
   	    case RG_CPU_REASON_NORMAL_FWD: //normal forward
   	    case RG_CPU_REASON_NAT_L4_FRAGMENT:	//8: NAT/NAPT (Layer 4) Fragmented IPv4 packets
		case RG_CPU_REASON_NAT_L3_FRAGMENT:	//9: Routed (Layer 3) Fragmented IPv4/v6 packets
		case RG_CPU_REASON_NAT_LOOKUP_MISS: //34: NAPT lookup miss
   	    	break;

		case RG_CPU_REASON_NAT_PPPOE_ID_LOOKUP_MISS:	//6: PPPoE ID lookup miss for Layer 3/4 forwarding
			DEBUG("PPPoE ID lookup miss for L34 forwarding");
			return RG_FWDENGINE_RET_DROP;
		case RG_CPU_REASON_NAT_ARP_ND_MISS:	//21: ARP or Neighbor miss
			/* layer2 no need to do ARP,  The ARP miss procedure will be done by L34 dataPath.
			if((pPktHdr->tagif&IPV6_TAGIF)==0)
			{
				ret=_rtk_rg_fwdengine_handleArpMiss(pPktHdr);
				//if(ret==RG_FWDENGINE_RET_TO_PS)return ret;
				//return RG_FWDENGINE_RET_DROP;
			}
			else
			{
				ret=_rtk_rg_fwdengine_handleNeighborMiss(pPktHdr);
				//if(ret==RG_FWDENGINE_RET_TO_PS)return ret;
			}
			*/
			break;
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
		case CPU_REASON_MTU:
		case CPU_REASON_MTU_S2:
#else
		case RG_CPU_REASON_NAT_OVER_MTU: //22: over MTU Size
#endif
			if(pPktHdr->isGatewayPacket)
				pPktHdr->overMTU=1;
			break;
		case RG_CPU_REASON_UKNOWNDA_UC:	//204: unknown DA for unicast packet
			if(pPktHdr->isGatewayPacket==0)
			{
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
				if((pPktHdr->pDmac[0]&1)==1)  //unknow_uc and unknow_mc using same trap reason
					break;
#endif
				l2Idx=_rtk_rg_macLookup(pPktHdr->pDmac,pPktHdr->internalVlanID, FALSE);
				if(l2Idx!=RG_RET_LOOKUPIDX_NOT_FOUND)
				{
					rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.age=7;
					if(l2Idx >= MAX_LUT_HW_TABLE_SIZE)
					{
						TRACE("unicast unknown DA %02x:%02x:%02x:%02x:%02x:%02x in SW-LUT-Link-list...update SW-LUT age time",pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5]);
					}
					else
					{
						// [Call RTK_L2_ADDR_ADD directly] sync sw lut to hw
						RTK_L2_ADDR_ADD(&rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry);
						TRACE("unicast unknown DA %02x:%02x:%02x:%02x:%02x:%02x in SW-LUT...force sync to HW-LUT",pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5]);
					}
					break;
				}

				//unknown DA rate limit check
				if(rg_db.systemGlobal.unKnownDARateLimitPortMask&(1<<(pPktHdr->ingressPort))){
					ret=_rtk_rg_unknownDARateLimit_check(skb,pPktHdr);
					if(ret==RG_FWDENGINE_RET_DROP)
						return RG_FWDENGINE_RET_DROP;
				}
				pPktHdr->fwdDecision=RG_FWD_DECISION_NO_PS_BC;
				TRACE("unicast unknown DA %02x:%02x:%02x:%02x:%02x:%02x...go to broadcast",pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5]);
				return RG_FWDENGINE_RET_BROADCAST;
			}
			break;
		default:
			TRACE("not be handled reason=%d\n",pPktHdr->pRxDesc->rx_reason);
			break;
	}
#endif

	/* Handle packet has special etherType*/
	switch(pPktHdr->etherType)
	{
//		case 0x8809:										/* pass OAM packet */
//#ifdef CONFIG_DUALBAND_CONCURRENT
//		case CONFIG_DEFAULT_IPC_SEND_ETHERTYPE:
//		case CONFIG_DEFAULT_IPC_RECV_ETHERTYPE:
//		case CONFIG_DEFAULT_IPC_SIGNAL_ETHERTYPE:
//#endif
//			return RG_FWDENGINE_RET_TO_PS;
		case RG_ARP_ETHERTYPE:										/* Handle ARP packet */
			//memDump(skb->data,skb->len,"rx 0806 data");
			_rtk_rg_arpAgent(skb->data,skb->len,pPktHdr);

			ret=_rtk_rg_checkGwIp(pPktHdr);
			if(ret==RG_FWDENGINE_RET_TO_PS)
				return ret;
			break;
		case RG_PPPOED_ETHERTYPE:										/* Handle PPPoE control packet */
			//if((rg_db.algFunctionMask & RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0)		/* Handle broadcast packet to routing WAN if PPPoE pass through is turn on*/
			//{
				//DEBUG("Pass through turn on!!");
				//Check DA for WAN interface, return to PS if match
				/*for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
				{
					if(memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.wan_intf_conf.gmac.octet,pPktHdr->pDmac,6)==0)
					{
						//DEBUG("match WAN! to PS now");
						return RG_FWDENGINE_RET_TO_PS;
					}

					//get all WAN should be put in broadcast mask

				}*/
				if(pPktHdr->isGatewayPacket == 1)
				{
					//packet should be learned in layer2Agent before goto protocol stack!!
					//ret=_rtk_rg_layer2Agent(skb,pPktHdr);
					//if(ret!=RG_FWDENGINE_RET_L2FORWARDED)return ret;		//multicast packet may return to PS

					//DEBUG("8863 packet, before return to protocol stack");
					//dump_packet(skb->data,skb->len,"8863 packet");
#ifdef CONFIG_RG_SIMPLE_PROTOCOL_STACK
					int i;
					//Check Lan MAC address, actually this may not be needed, since PPPoE should on WAN interface only....
					/*for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
					{
						if(memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,pPktHdr->pDmac,6)==0)
						{
							cp->wanInterfaceIdx=0;
							goto RET_TO_PS;
						}
					}*/

					//Check Wan
					for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
					{
						if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type==RTK_RG_PPPoE &&
							memcmp(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,pPktHdr->pDmac,ETHER_ADDR_LEN)==0)
						{
							if(skb->dev->priv && ((struct re_dev_private*)skb->dev->priv)->pCp)((struct re_dev_private*)skb->dev->priv)->pCp->wanInterfaceIdx=i;
							break;
						}
					}
//RET_TO_PS:
					//DEBUG("the cp->waninterfaceIdx is %d",cp->wanInterfaceIdx);
#endif
					TRACE("[To PS] DMAC=GMAC & ETHTYPE=0x8863, to PS!");
					return RG_FWDENGINE_RET_TO_PS;
				}

				if((pPktHdr->pDmac[0]&pPktHdr->pDmac[1]&pPktHdr->pDmac[2]&pPktHdr->pDmac[3]&pPktHdr->pDmac[4]&pPktHdr->pDmac[5])==0xff)
				{
					//DEBUG("layer2 broadcast packet");
					if((rg_db.algFunctionMask & RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0)		/* Handle broadcast packet to routing WAN if PPPoE pass through is turn on*/
						pPktHdr->internalVlanID=rg_db.systemGlobal.initParam.fwdVLAN_CPU;	//pass through between LAN and WAN interface
					return RG_FWDENGINE_RET_BROADCAST;
				}
				else
				{
#ifdef CONFIG_RG_BRIDGE_PPP_STATUS
					//20160318LUKE: invoke callback function if existed
					//20160324WPENG: PADT should be parsed too...
					if(rg_db.systemGlobal.initParam.pppoeLCPStateCallBack!= NULL)
					{
						struct sk_buff *lcp_skb=NULL;
						lcp_skb=rtk_rg_skbCopyToPreAllocSkb(skb);
						if(lcp_skb)
							rg_db.systemGlobal.initParam.pppoeLCPStateCallBack((void *)&lcp_skb);
					}
#endif
					if((rg_db.algFunctionMask & RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0)		/* Handle broadcast packet to routing WAN if PPPoE pass through is turn on*/
						pPktHdr->internalVlanID=rg_db.systemGlobal.initParam.fwdVLAN_CPU;	//pass through between LAN and WAN interface, and DA search if original vlan is IVL (using SVL vlan fwdVLAN_CPU to let it find DA)

					//DEBUG("layer2 unicast packet...hardware lookup");
					goto layer2_return;		//unicast L2 packet should be forwarded as hardware lookup
				}

			//Otherwise 8863 will be sended to protocol stack
			//return RG_FWDENGINE_RET_TO_PS;
		case RG_PPPOES_ETHERTYPE:									/* Handle PPPoE data packet */
			//Check layer2 packet(without IP header)
			if(pPktHdr->isGatewayPacket==1)
			{
				if((pPktHdr->tagif&(IPV4_TAGIF|IPV6_TAGIF))==0)
				{
					TRACE("[To PS] DMAC=GMAC & ETHTYPE=0x8864 & Not (IPv4 or IPv6), to PS!");
					return RG_FWDENGINE_RET_TO_PS;
				}
				else{
					if((pPktHdr->tagif&IPV6_TAGIF)&&(pPktHdr->pIpv6Dip[0]==0xff)){
						return _rtk_rg_checkIPv6MulticastScope(pPktHdr);
					}

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
					//flow-base pppoe multicast
					if((pPktHdr->tagif&IPV4_TAGIF)&&((pPktHdr->ipv4Dip&0xf0000000)==0xe0000000))
						return RG_FWDENGINE_RET_BROADCAST;
#endif
					return RG_FWDENGINE_RET_CONTINUE;	//continue to L34 forward
				}
			}else{
#ifdef CONFIG_RG_BRIDGE_PPP_STATUS
				//20160318LUKE: invoke callback function if existed
				if(rg_db.systemGlobal.initParam.pppoeLCPStateCallBack!= NULL)
				{
					struct sk_buff *lcp_skb=NULL;
					lcp_skb=rtk_rg_skbCopyToPreAllocSkb(skb);
					if(lcp_skb)
						rg_db.systemGlobal.initParam.pppoeLCPStateCallBack((void *)&lcp_skb);
				}
#endif
			}

			if((rg_db.algFunctionMask & RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0)		/* Handle broadcast packet to routing WAN if PPPoE pass through is turn on*/
			{
				if((pPktHdr->pDmac[0]&pPktHdr->pDmac[1]&pPktHdr->pDmac[2]&pPktHdr->pDmac[3]&pPktHdr->pDmac[4]&pPktHdr->pDmac[5])==0xff)
				{
					//DEBUG("broadcast packet");
					if((rg_db.algFunctionMask & RTK_RG_ALG_PPPOE_PASSTHROUGH_BIT) > 0)		/* Handle broadcast packet to routing WAN if PPPoE pass through is turn on*/
						pPktHdr->internalVlanID=rg_db.systemGlobal.initParam.fwdVLAN_CPU;	//pass through between LAN and WAN interface
					return RG_FWDENGINE_RET_BROADCAST;
				}
				else
				{
					/* Handle broadcast packet to routing WAN if PPPoE pass through is turn on*/
					pPktHdr->internalVlanID=rg_db.systemGlobal.initParam.fwdVLAN_CPU;	//pass through between LAN and WAN interface, and DA search if original vlan is IVL (using SVL vlan fwdVLAN_CPU to let it find DA)

					//DEBUG("the packet is PPPoE data unicast packet to %02x:%02x:%02x:%02x:%02x:%02x, just bridging..",
						//pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5]);
					goto layer2_return;		//unicast L2 packet should be forwarded as hardware lookup
	 				//Unicast packet in PPPoE Passthrough, change VID and port from DMAC2CVID
					//dump_packet(skb->data,skb->len,"sc");
				}
			}

#if 0
			if((pPktHdr->tagif&ICMPV6_TAGIF)&&(pPktHdr->ICMPv6Type==0x87)) //IPv6 Neighbor Solicitation
			{
				unsigned char zero[16]={0};
				if(memcmp(pPktHdr->pIpv6Sip,zero,16)!=0)
					_rtk_rg_neighborAgent(skb,pPktHdr);
			}
#endif

			break;
		case RG_IPV4_ETHERTYPE:	//IPv4
			break;
		case RG_IPV6_ETHERTYPE:	//IPv6
#if 0
			if((pPktHdr->tagif&ICMPV6_TAGIF)&&(pPktHdr->ICMPv6Type==0x87)) //IPv6 Neighbor Solicitation
			{
				unsigned char zero[16]={0};
				if(memcmp(pPktHdr->pIpv6Sip,zero,16)!=0)
					_rtk_rg_neighborAgent(skb,pPktHdr);
			}
#endif
			//20150520LUKE: for FF:XX...XX IPv6 address, we should always broadcast it!
			if((pPktHdr->tagif&(IPV6_TAGIF))&&(pPktHdr->pIpv6Dip[0]==0xff)){
				return _rtk_rg_checkIPv6MulticastScope(pPktHdr);
			}
			break;
		default:
			if(pPktHdr->isGatewayPacket) //unknown ethertype & DMAC=GMAC
			{
				TRACE("[To PS] DMAC=GMAC & Ethertype can't handle by FwdEngine, to PS!");
				return RG_FWDENGINE_RET_TO_PS;
			}
			break;
	}

	//Continue to L34forward
	if(pPktHdr->isGatewayPacket) //known ethertype & DMAC=GMAC
	{
		//20140403LUKE:if learning limit is reach and action is SA_LEARN_EXCEED_ACTION_PERMIT_L2, we can't do L34
		if(pPktHdr->swLutL2Only==1)
		{
			//Check if we are heading to PS
			ret=_rtk_rg_checkGwIp(pPktHdr);
			if(ret==RG_FWDENGINE_RET_TO_PS)
			{
				TRACE("[To PS] trap by gateway ip checking");
				return ret;
			}
			else
			{
				//20190621LUKE: check if the IPv6 destination IP is link-local, if so, trap to PS.
				if(pPktHdr->ingressLocation!=RG_IGR_PROTOCOL_STACK && pPktHdr->tagif&IPV6_TAGIF && pPktHdr->pIpv6Dip[0]==0xfe && pPktHdr->pIpv6Dip[1]==0x80)
				{
					TRACE("[To PS] IPv6 head to Link Local address, Trap to PS!");
					return RG_FWDENGINE_RET_TO_PS;
				}
				else
				{
					TRACE("[Drop] drop by gateway ip checking");
					return RG_FWDENGINE_RET_DROP;
				}
			}
		}
		else
			return RG_FWDENGINE_RET_CONTINUE;
	}

	/* Handle broadcast packet or unknown DA unicast packet*/
	if((pPktHdr->pDmac[0]&1)==1)
	{
		return RG_FWDENGINE_RET_BROADCAST;
	}

layer2_return:
	TRACE("Layer2 Forward");
	return RG_FWDENGINE_RET_L2FORWARDED;
}


__IRAM_FWDENG
void _rtk_rg_extIngressPortDecision(rtk_rg_pktHdr_t *pPktHdr,rtk_rg_rxdesc_t	*pRxDesc)
{
	//init
#if defined(CONFIG_RG_RTL9600_SERIES)
{
	pPktHdr->ingressLocation=RG_IGR_PHY_PORT;
	if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_CPU){
		pPktHdr->ingressPort=RTK_RG_PORT_CPU;
		if(pRxDesc->rx_dst_port_mask==0x8){ //from EXT0 (Using ACL modify EXT_SPA to DST_PMSK)
			pPktHdr->ingressPort=RTK_RG_EXT_PORT0;
		}
#ifdef CONFIG_DUALBAND_CONCURRENT
		else if(pRxDesc->rx_dst_port_mask==0x10){ //from EXT1 (Using ACL modify EXT_SPA to DST_PMSK)
			pPktHdr->ingressPort=RTK_RG_EXT_PORT1;
		}
#endif
		else if(pRxDesc->rx_dst_port_mask==0x20){
			if(pRxDesc->rx_igrLocation==0x0){	//from protocol statck
				pPktHdr->ingressLocation=RG_IGR_PROTOCOL_STACK;
			}else if(pRxDesc->rx_igrLocation==0x1){	//from ARP or ND
				pPktHdr->ingressLocation=RG_IGR_ARP_OR_ND;
			}else if(pRxDesc->rx_igrLocation==0x2){	//from IGMP or MLD
				pPktHdr->ingressLocation=RG_IGR_IGMP_OR_MLD;
			}
		}else{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			if(pRxDesc==(rtk_rg_rxdesc_t *)&rg_db_cache.rxInfoFromWLAN){
				pPktHdr->ingressPort=RTK_RG_EXT_PORT0;
			}
#endif
		}
	}else{
		pPktHdr->ingressPort=pRxDesc->rx_src_port_num;
	}
}
#elif defined(CONFIG_RG_RTL9602C_SERIES)
{
	pPktHdr->ingressLocation=RG_IGR_PHY_PORT;
	if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_CPU){
		pPktHdr->ingressPort=RTK_RG_PORT_CPU;
		if(pRxDesc->rx_dst_port_mask==0x20){
			if(pRxDesc->rx_igrLocation==0x0){	//from protocol statck
				pPktHdr->ingressLocation=RG_IGR_PROTOCOL_STACK;
			}else if(pRxDesc->rx_igrLocation==0x1){	//from ARP or ND
				pPktHdr->ingressLocation=RG_IGR_ARP_OR_ND;
			}else if(pRxDesc->rx_igrLocation==0x2){	//from IGMP or MLD
				pPktHdr->ingressLocation=RG_IGR_IGMP_OR_MLD;
			}
		}else{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
			pPktHdr->ingressPort=RTK_RG_EXT_PORT0;
#endif
		}
	}else{
		pPktHdr->ingressPort=pRxDesc->rx_src_port_num;
	}
}
#elif defined(CONFIG_RG_RTL9607C_SERIES)
{
	pPktHdr->ingressLocation=RG_IGR_PHY_PORT;
	if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_MASTERCPU_CORE0)
	{
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_PORT_MAX)
		{
			pPktHdr->ingressPort = RTK_RG_PORT_MASTERCPU_CORE0;
			if(pRxDesc->rx_igrLocation==0x0){	//from protocol statck
				pPktHdr->ingressLocation=RG_IGR_PROTOCOL_STACK;
			}else if(pRxDesc->rx_igrLocation==0x1){	//from ARP or ND
				pPktHdr->ingressLocation=RG_IGR_ARP_OR_ND;
			}else if(pRxDesc->rx_igrLocation==0x2){	//from IGMP or MLD
				pPktHdr->ingressLocation=RG_IGR_IGMP_OR_MLD;
			}else if(pRxDesc->rx_igrLocation==0x3){	//from MC Data Buf
				pPktHdr->ingressLocation=RG_IGR_MC_DATA_BUF;
			}
		}
		else if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU)
			pPktHdr->ingressPort = RTK_RG_PORT_MASTERCPU_CORE0;
		else //extspa is not 0
			pPktHdr->ingressPort = RTK_RG_EXT_PORT0; //1 FIXME: compatible with apollo/apollo fe
			//pPktHdr->ingressPort = RTK_RG_EXT_PORT0+(pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT0);
	}
	else if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_MASTERCPU_CORE1)
	{
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_PORT_MAX)
		{
			pPktHdr->ingressPort = RTK_RG_PORT_MASTERCPU_CORE1;
			if(pRxDesc->rx_igrLocation==0x0){	//from protocol statck
				pPktHdr->ingressLocation=RG_IGR_PROTOCOL_STACK;
			}else if(pRxDesc->rx_igrLocation==0x1){	//from ARP or ND
				pPktHdr->ingressLocation=RG_IGR_ARP_OR_ND;
			}else if(pRxDesc->rx_igrLocation==0x2){	//from IGMP or MLD
				pPktHdr->ingressLocation=RG_IGR_IGMP_OR_MLD;
			}else if(pRxDesc->rx_igrLocation==0x3){	//from MC Data Buf
				pPktHdr->ingressLocation=RG_IGR_MC_DATA_BUF;
			}
		}
		else if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU)
			pPktHdr->ingressPort = RTK_RG_PORT_MASTERCPU_CORE1;
		else //extspa is not 0
			pPktHdr->ingressPort = RTK_RG_EXT_PORT0; //1 FIXME: compatible with apollo/apollo fe
			//pPktHdr->ingressPort = RTK_RG_MAC10_EXT_PORT0+(pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT0);
	}
	else if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_SLAVECPU)
	{
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU)
			pPktHdr->ingressPort = RTK_RG_PORT_SLAVECPU;
		else //extspa is not 0
#if defined(CONFIG_DUALBAND_CONCURRENT)
			pPktHdr->ingressPort = RTK_RG_EXT_PORT1; //1 FIXME: compatible with apollo/apollo fe
#else
			pPktHdr->ingressPort = RTK_RG_EXT_PORT0;
#endif
			//pPktHdr->ingressPort = RTK_RG_MAC7_EXT_PORT0+(pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT0);
	}
	else	// not from cpu port
	{
		pPktHdr->ingressPort=pRxDesc->rx_src_port_num;
	}
	//20200702LUKE: fix downstream packet flow-miss should modify ingress port to wan port.
	if(rg_db_dynamic_sram.vxlan_acc.vxlan_acceleration_mechanism){
		//20200716LUKE: fix downstream packet may coming from different CPU port.
		int downstreamCpuPort=-1,upstreamCpuPort=-1;
		switch(rg_db_dynamic_sram.vxlan_acc.vxlan_downstreamGmac){
			case 0:
				downstreamCpuPort=RTK_RG_MAC_PORT_MASTERCPU_CORE0;
				break;
			case 1:
				downstreamCpuPort=RTK_RG_MAC_PORT_MASTERCPU_CORE1;
				break;
			case 2:
				downstreamCpuPort=RTK_RG_MAC_PORT_SLAVECPU;
				break;
			default:
				break;
		}	
		switch(rg_db_dynamic_sram.vxlan_acc.vxlan_upstreamGmac){
			case 0:
				upstreamCpuPort=RTK_RG_MAC_PORT_MASTERCPU_CORE0;
				break;
			case 1:
				upstreamCpuPort=RTK_RG_MAC_PORT_MASTERCPU_CORE1;
				break;
			case 2:
				upstreamCpuPort=RTK_RG_MAC_PORT_SLAVECPU;
				break;
			default:
				break;
		}
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU && pRxDesc->rx_reason){
			if(pRxDesc->rx_src_port_num==downstreamCpuPort && !memcmp(pPktHdr->skb->data,rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN)){
				//pRxDesc->rx_src_port_num = rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				//pPktHdr->ingressPort = pRxDesc->rx_src_port_num;
				TRACE("Vxlan downstream packet trap!! delete downstream outer flow by dmacIdx of vxlan downstream:%d",rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx);
				_rtk_rg_hwFlow_del_by_dmacL2Idx(rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_downstreamL2Idx);
				pPktHdr->ingressLocation=RG_IGR_DROP;
			}else if(pRxDesc->rx_src_port_num==upstreamCpuPort && !memcmp(pPktHdr->skb->data,rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.after_dial.vxlan_remote_ipv4_gatewayMac.octet,ETHER_ADDR_LEN) && 
				rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_upstreamL2Idx>=0){
				TRACE("Vxlan upstream packet trap!! delete all upstream inner flow by dmacIdx of vxlan upstream:%d",rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_upstreamL2Idx);
				_rtk_rg_hwFlow_del_by_dmacL2Idx(rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_upstreamL2Idx);
				pPktHdr->ingressLocation=RG_IGR_DROP;
			}
		}
		switch(rg_db_dynamic_sram.vxlan_acc.vxlan_extraGmac){
			case 0:
				downstreamCpuPort=RTK_RG_MAC_PORT_MASTERCPU_CORE0;
				break;
			case 1:
				downstreamCpuPort=RTK_RG_MAC_PORT_MASTERCPU_CORE1;
				break;
			case 2:
				downstreamCpuPort=RTK_RG_MAC_PORT_SLAVECPU;
				break;
			default:
				downstreamCpuPort=-1;
				break;
		}	
		upstreamCpuPort=downstreamCpuPort;
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU && pRxDesc->rx_reason){
			if(pRxDesc->rx_src_port_num==downstreamCpuPort && !memcmp(pPktHdr->skb->data,rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.wan_intf_conf.gmac.octet,ETHER_ADDR_LEN)){
				//pRxDesc->rx_src_port_num = rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.wan_intf_conf.wan_port_idx;
				//pPktHdr->ingressPort = pRxDesc->rx_src_port_num;
				TRACE("Vxlan downstream packet trap!! delete downstream outer flow by dmacIdx of vxlan downstream:%d",rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx);
				_rtk_rg_hwFlow_del_by_dmacL2Idx(rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_downstreamL2Idx);
				pPktHdr->ingressLocation=RG_IGR_DROP;
			}else if(pRxDesc->rx_src_port_num==upstreamCpuPort && !memcmp(pPktHdr->skb->data,rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.after_dial.vxlan_remote_ipv4_gatewayMac.octet,ETHER_ADDR_LEN) && 
				rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_upstreamL2Idx>=0){
				TRACE("Vxlan extra upstream packet trap!! delete all upstream inner flow by dmacIdx of vxlan extra upstream:%d",rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_upstreamL2Idx);
				_rtk_rg_hwFlow_del_by_dmacL2Idx(rg_db.systemGlobal.interfaceInfo[rg_db_dynamic_sram.vxlan_acc.vxlan_accelerated_intf_idx].storedInfo.wan_intf.vxlan_info.vxlan_accelerate_extra_upstreamL2Idx);
				pPktHdr->ingressLocation=RG_IGR_DROP;
			}
		}
	}
}
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
{
	pPktHdr->ingressLocation=RG_IGR_PHY_PORT;
	if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_CPU)
	{
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_PORT_MAX)
		{
			pPktHdr->ingressPort = RTK_RG_PORT_CPU;
			if(pRxDesc->rx_igrLocation==0x0){	//from protocol statck
				pPktHdr->ingressLocation=RG_IGR_PROTOCOL_STACK;
			}else if(pRxDesc->rx_igrLocation==0x1){	//from ARP or ND
				pPktHdr->ingressLocation=RG_IGR_ARP_OR_ND;
			}else if(pRxDesc->rx_igrLocation==0x2){	//from IGMP or MLD
				pPktHdr->ingressLocation=RG_IGR_IGMP_OR_MLD;
			}else if(pRxDesc->rx_igrLocation==0x3){	//from MC Data Buf
				pPktHdr->ingressLocation=RG_IGR_MC_DATA_BUF;
			}
		}
		else if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU)
			pPktHdr->ingressPort = RTK_RG_PORT_CPU;
		else //extspa is not 0
			pPktHdr->ingressPort = RTK_RG_EXT_PORT0;
	}
	else	// not from cpu port
	{
		pPktHdr->ingressPort=pRxDesc->rx_src_port_num;
	}
}
#elif defined(CONFIG_RG_G3_SERIES)
{
	pPktHdr->ingressLocation=RG_IGR_PHY_PORT;
	if(pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_CPU)
	{
		if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_PORT_MAX)
		{
			pPktHdr->ingressPort = RTK_RG_PORT_CPU;
			if(pRxDesc->rx_igrLocation==0x0){	//from protocol statck
				pPktHdr->ingressLocation=RG_IGR_PROTOCOL_STACK;
			}else if(pRxDesc->rx_igrLocation==0x1){	//from ARP or ND
				pPktHdr->ingressLocation=RG_IGR_ARP_OR_ND;
			}else if(pRxDesc->rx_igrLocation==0x2){	//from IGMP or MLD
				pPktHdr->ingressLocation=RG_IGR_IGMP_OR_MLD;
			}else if(pRxDesc->rx_igrLocation==0x3){	//from MC Data Buf
				pPktHdr->ingressLocation=RG_IGR_MC_DATA_BUF;
			}
		}
		else if(pRxDesc->rx_extspa==RTK_RG_MAC_EXT_CPU)
			pPktHdr->ingressPort = RTK_RG_PORT_CPU;
		else //extspa is not 0
			pPktHdr->ingressPort = RTK_RG_EXT_PORT0; //1 FIXME: compatible with apollo/apollo fe
	}
	else	// not from cpu port
	{
		pPktHdr->ingressPort=pRxDesc->rx_src_port_num;
	}
	if(pPktHdr->ingressPort==AAL_LPORT_MC && (pPktHdr->skb->data[0]&1) && rg_db.systemGlobal.initParam.igmpSnoopingEnable==0)
	{
		TRACE("multciast change sport from AAL_LPORT_MC(0x1b) to RTK_RG_PORT_PON");
		pPktHdr->ingressPort = RTK_RG_PORT_PON;
	}


}

#endif

	_rtk_rg_portToMacPort_translator(pPktHdr->ingressPort, &pPktHdr->ingressMacPort, &pPktHdr->ingressMacExtPort);
	DEBUG("IngressPort=%d, IngressMacPort=%d, IngressMacExtPort=%d, IngressLocation=%s", pPktHdr->ingressPort, pPktHdr->ingressMacPort, pPktHdr->ingressMacExtPort, (pPktHdr->ingressLocation==RG_IGR_PHY_PORT)?"PHYSICAL PORT":(pPktHdr->ingressLocation==RG_IGR_PROTOCOL_STACK)?"PROTOCOL STACK":(pPktHdr->ingressLocation==RG_IGR_ARP_OR_ND)?"ARP/ND":(pPktHdr->ingressLocation==RG_IGR_IGMP_OR_MLD)?"IGMP/MLD":(pPktHdr->ingressLocation==RG_IGR_MC_DATA_BUF)?"MC_DATA_BUF":"DROP");
}

rtk_rg_fwdEngineReturn_t _rtk_rg_wlanExtraDataPathDecision(rtk_rg_pktHdr_t *pPktHdr,rtk_rg_rxdesc_t *pRxDesc,struct sk_buff *skb)
{
#ifdef CONFIG_RG_WLAN_HWNAT_ACCELERATION
		//check from which WLAN interface(root,vap0,vap1,vap2,vap3)

#ifdef CONFIG_MASTER_WLAN0_ENABLE

		if(pRxDesc==(rtk_rg_rxdesc_t *)&rg_db_cache.rxInfoFromWLAN)
		{
			_rtk_rg_wlanMbssidLearning(&skb->data[6],pPktHdr);
			TRACE("the wlan device is from %d",pPktHdr->wlan_dev_idx);
		}

#endif

		if(pPktHdr->ingressMacPort==RTK_RG_MAC_PORT_MAINCPU) //from CPU,EXT0,EXT1
		{
ingress_port_changed:
			if(pPktHdr->ingressPort==RTK_RG_EXT_PORT0) //from EXT0, wireless WAN
			{
				if((skb->data[0]&1)==1) //from EXT0 BC/MC to-PS
				{
					TRACE("(from EXT0 BC/MC), into FwdEngine!"); //let IGMP packets learn to HW.
					return RG_FWDENGINE_RET_SLOWPATH;
				}
				else //Unicsat
				{
					if(pRxDesc==(rtk_rg_rxdesc_t *)&rg_db_cache.rxInfoFromWLAN) //from WIFI directly, not trap from GMAC trap
					{
#if 0//def CONFIG_DUALBAND_CONCURRENT
						//ARP should not use shortcut, otherwise won't learn in hw
						if(pPktHdr->tagif&ARP_TAGIF)
							return RG_FWDENGINE_RET_SLOWPATH;

						//Disable HWNAT should continue to slow path.
						if(rg_db.systemGlobal.hwnat_enable == RG_HWNAT_DISABLE)
							return RG_FWDENGINE_RET_SLOWPATH;
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						if(rg_db.systemGlobal.wlan0BindDecision[pPktHdr->wlan_dev_idx].set_bind)
						{
							TRACE("From EXT0 UC which from WIFI1 hit Binding, into FwdEngine!");
							return RG_FWDENGINE_RET_SLOWPATH;
						}

						if(rg_db.systemGlobal.accessWanLimitPortMask_wlan0member&(0x1<<pPktHdr->wlan_dev_idx))
						{
							TRACE("Wan Access Limit had been set for dev[%d], into FwdEngine!",pPktHdr->wlan_dev_idx);
							return RG_FWDENGINE_RET_SLOWPATH;
						}
#endif
						if(rg_db.systemGlobal.wlanDevPatternValidInACL){
							TRACE("RG ACL exist WLANDEV compare rules, into FwdEngine!");
							return RG_FWDENGINE_RET_SLOWPATH;
						}

						//20141030LUKE: we should not hwlookup ip-fragment packet, since gmac and switch both could't offload L4CS
						//20141104LUKE: and hwlookup through gmac will cause Layer4 checksum offload to wrong value,
						//after trap fwdEngine can't recalculate to correct one since we are using difference update.
						//20141112LUKE: Consider IPv6 also.
						if((pPktHdr->ipv4FragPacket||pPktHdr->ipv6FragPacket) && ((pPktHdr->tagif&TCP_TAGIF)||(pPktHdr->tagif&UDP_TAGIF))){
							TRACE("IP fragment packet, into FwdEngine!");
							return RG_FWDENGINE_RET_SLOWPATH;
						}

						//20141112LUKE: When TCP SYN packet from wifi to pure-routing WAN, we should go to slow path in case neighbor or ARP can be learned
						if((pPktHdr->tagif&TCP_TAGIF)&&(pPktHdr->tcpFlags.syn==1))
						{
							TRACE("TCP packet with SYN, into FwdEngine!");
							return RG_FWDENGINE_RET_SLOWPATH;
						}

						//20160304LUKE: from WLAN or WWAN with DIP equals to GWIP, we should goto slow path and trap(or drop for NAPTR lookmiss from WWAN).
						if(_rtk_rg_checkGwIp(pPktHdr)==RG_FWDENGINE_RET_TO_PS){
							TRACE("packet from WLAN or WWAN with DIP equals to GWIP, into FwdEngine!");
							return RG_FWDENGINE_RET_SLOWPATH;
						}

						//HWLOOKUP
						TRACE("From EXT0 UC which from WIFI1, forward by HWLOOKUP.");
						return RG_FWDENGINE_RET_HWLOOKUP;
#else
						//20160304LUKE: for single wifi, hwlookup is unnecessary.
						//20160804LUKE: for dual wifi, we still can check data path in slow path and create shortcut, so direct enter slow path here.
						TRACE("From EXT0 UC which from WIFI1, into FwdEngine.");
						return RG_FWDENGINE_RET_SLOWPATH;
#endif
					}
					else
					{
						//if from GMAC and without trap reason, just send to Master; otherwise goto slow path
						if(pRxDesc->rx_reason==RG_CPU_REASON_NORMAL_FWD)
						{
							//20140122LUKE:if there is no any interface, we just let directTX to forward.
							if(rg_db.systemGlobal.lanIntfTotalNum==0)
							{
								TRACE("there is no any LAN interface...into FwdEngine!");
								return RG_FWDENGINE_RET_SLOWPATH;	//goto normal path
							}

							TRACE("Sending EXT0 UC to WIFI1 if DMAC had been learned");
							if(_rtk_master_wlan_mbssid_tx(pPktHdr,skb)==RG_RET_MBSSID_NOT_FOUND)
							{
								TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
								return RG_FWDENGINE_RET_DROP;
							}

							return RG_FWDENGINE_RET_CONTINUE;
						}
					}
				}
				// from EXT0 UC normal forward
			}
#ifdef CONFIG_DUALBAND_CONCURRENT
			else if((pPktHdr->ingressPort==RTK_RG_EXT_PORT1)&&((skb->data[0]&1)==0))	//from EXT1 Unicast
			{
				if(pRxDesc->rx_reason==RG_CPU_REASON_NORMAL_FWD)
				{
					int i;

					if(memcmp(master_ipc_macAddr.octet,skb->data,ETHER_ADDR_LEN)==0)
					{
						// DMAC=GMAC to Protocol Stack
						TRACE("[To PS] from (WIFI2)EXT1 UC to LAN_MAC to PS!");
						return RG_FWDENGINE_RET_TO_PS;
					}

					//20160428LUKE: forwarded from slave CPU, do slow path
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
					if(rg_db.systemGlobal.enableSlaveSSIDBind && pPktHdr->ingressMacExtPort==RTK_RG_MAC_EXT_PORT5)
#else
					if(rg_db.systemGlobal.enableSlaveSSIDBind)
#endif
					{
						TRACE("from (WIFI2)EXT1 UC...Continue!");
						return RG_FWDENGINE_RET_SLOWPATH;	//goto normal path
					}

					//normal forward to Master CPU
					for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
					{
						if(memcmp(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,skb->data,ETHER_ADDR_LEN)==0)
						{
							// DMAC=GMAC to Protocol Stack
							TRACE("[To PS] from (WIFI2)EXT1 UC to LAN_MAC to PS!");
							return RG_FWDENGINE_RET_TO_PS;
						}
					}

					//20140122LUKE:if there is no any interface, we just let directTX to forward.
					if(rg_db.systemGlobal.lanIntfTotalNum==0)
					{
						TRACE("there is no any LAN interface...into FwdEngine!");
						return RG_FWDENGINE_RET_SLOWPATH;	//goto normal path
					}
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					if(wlan_root_netdev!=NULL)
					{
						TRACE("from (WIFI2)EXT1 UC to WIFI1(EXT0)!\n");

						if(_rtk_master_wlan_mbssid_tx(pPktHdr,skb)==RG_RET_MBSSID_NOT_FOUND)
						{
							TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
							return RG_FWDENGINE_RET_DROP;
						}
						return RG_FWDENGINE_RET_CONTINUE; //free skb by wifi driver.
					}
					else
					{
						TRACE("[Drop] wlan_root_netdev is null");
						return RG_FWDENGINE_RET_DROP;
					}
#endif

				}
				else
				{
					TRACE("from (WIFI2)EXT1 UC to Master-CPU(trap) into fwdEngine!");
				}
			}
			else if((pPktHdr->ingressPort==RTK_RG_EXT_PORT1)&&((skb->data[0]&1)==1))	//from EXT1 MC/BC
			{
				if(skb->data[0]==0xff)
				{
					TRACE("from (WIFI2)EXT1 BC to Master-CPU goto FwdEngine, skb_len=%d!",skb->len);
					return RG_FWDENGINE_RET_SLOWPATH;	//goto normal path
				}
				else
				{
					TRACE("from (WIFI2)EXT1 MC to Master-CPU goto FwdEngine, skb_len=%d!",skb->len);
					return RG_FWDENGINE_RET_SLOWPATH;	//goto normal path
				}
			}
			else if(pRxDesc->rx_dst_port_mask==0x4) // to EXT1
			{
				TRACE("[Drop] unknow from CPU to (WIFI2)EXT1 packet, skb_len=%d, Drop!",skb->len);
				return RG_FWDENGINE_RET_DROP;
			}
#endif

#ifdef CONFIG_MASTER_WLAN0_ENABLE

			else if(pRxDesc->rx_dst_port_mask==0x2) // to EXT0
			{
				if(wlan_root_netdev!=NULL)
				{
					TRACE("CPU(GMAC1) to EXT0(WIFI1) packet, skb_len=%d!",skb->len);

					if(_rtk_master_wlan_mbssid_tx(pPktHdr,skb)==RG_RET_MBSSID_NOT_FOUND)
					{
						TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
						return RG_FWDENGINE_RET_DROP;
					}
					return RG_FWDENGINE_RET_CONTINUE; //free skb by wifi driver
				}
				else
				{
					TRACE("[Drop] wlan_root_netdev is null");
					return RG_FWDENGINE_RET_DROP;
				}
			}
#endif

			else  // from CPU to CPU
			{
				//patch for ACL+CF rule will over-write acl(src ext-port  to dest-ext-portmask) rule.
				//trace SMAC is from which port? if from EXT port, modify ingress port and goto ingress_port_changed.
				if(pRxDesc->rx_reason==RG_CPU_REASON_NORMAL_FWD)
				{
					int l2Idx=_rtk_rg_macLookup(pPktHdr->pSmac,pPktHdr->internalVlanID, FALSE);
					if(l2Idx!=RG_RET_LOOKUPIDX_NOT_FOUND)
					{
						if((RTK_RG_ALL_MAC_CPU_PORTMASK & (0x1<<rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.port))
							&& rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.ext_port!=RTK_RG_MAC_EXT_CPU)
						{
							rtk_rg_port_idx_t portIdx;

							_rtk_rg_macPortToPort_translator(&portIdx, rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.port, rg_db.lut[l2Idx].rtk_lut.entry.l2UcEntry.ext_port);
#if defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
							_rtk_rg_lutExtport_translator(&portIdx);
#endif
							TRACE("*** SMAC lookups from vlan %d and modifies ingress port(%d) to %d ***",pPktHdr->internalVlanID,pPktHdr->ingressPort,portIdx);
							pPktHdr->ingressPort=portIdx;
							_rtk_rg_portToMacPort_translator(pPktHdr->ingressPort, &pPktHdr->ingressMacPort, &pPktHdr->ingressMacExtPort);
							if(pPktHdr->ingressPort==RTK_RG_EXT_PORT0)
								pRxDesc->rx_dst_port_mask=0x8;
							else if(pPktHdr->ingressPort==RTK_RG_EXT_PORT1)
								pRxDesc->rx_dst_port_mask=0x10;
							goto ingress_port_changed;
						}
					}
				}
				else // have trap reason
				{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
					rtk_rg_mbssidDev_t wlan_dev_idx;
					rtk_rg_lookupIdxReturn_t retIdx=_rtk_rg_wlanMbssidLookup(pPktHdr->pSmac,&wlan_dev_idx);
					if(retIdx!=RG_RET_LOOKUPIDX_NOT_FOUND)
					{
						// This is a patch for ACL+CF latch can't get src ext port info by ACL.
						// If the packet is from Master-CPU(EXT0), the learn_jiffies will expect very close to jiffies.
						// otherwise, it is from Slave-CPU(EXT1).
						if(time_before(jiffies,rg_db.wlanMbssid[retIdx].learn_jiffies+HZ))
						{
							TRACE("This packet is from EXT0, because it is found in master mbssid table and just update the aging time.");
							//20160330LUKE: retrieve wlan_dev_idx from wlanMbssid table.
							pPktHdr->wlan_dev_idx=wlan_dev_idx;
							pPktHdr->ingressPort=RTK_RG_EXT_PORT0;
							_rtk_rg_portToMacPort_translator(pPktHdr->ingressPort, &pPktHdr->ingressMacPort, &pPktHdr->ingressMacExtPort);
							pRxDesc->rx_dst_port_mask=0x8;
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
							//20150427LUKE: from vxd but trap to cpu, we should not treat it as from ext0!
							if((int)wlan_dev_idx==(int)RG_WWAN_WLAN0_VXD)pPktHdr->wlan_dev_idx=RG_WWAN_WLAN0_VXD;
							else if((int)wlan_dev_idx==(int)RG_WWAN_WLAN1_VXD)pPktHdr->wlan_dev_idx=RG_WWAN_WLAN1_VXD;
#endif
							goto ingress_port_changed;
						}
						else
						{
							TRACE("This packet is guessed from EXT1(It is found in master mbssid table but not update the aging time > 1sec)");
							DEBUG("#### DELETE MBSSID INFO, MAC=%02x:%02x:%02x:%02x:%02x:%02x WLAN_DEV_IDX=%d ####",
							rg_db.wlanMbssid[retIdx].mac.octet[0],
							rg_db.wlanMbssid[retIdx].mac.octet[1],
							rg_db.wlanMbssid[retIdx].mac.octet[2],
							rg_db.wlanMbssid[retIdx].mac.octet[3],
							rg_db.wlanMbssid[retIdx].mac.octet[4],
							rg_db.wlanMbssid[retIdx].mac.octet[5],
							rg_db.wlanMbssid[retIdx].wlan_dev_idx);
							memset(&rg_db.wlanMbssid[retIdx],0,sizeof(rtk_rg_table_wlan_mbssid_t));
						}
					}
					else
#endif
#ifdef CONFIG_DUALBAND_CONCURRENT
					{
						TRACE("This packet is guessed from EXT1(It doesn't found in master mbssid table)");
					}

					//we assume that this packet is from EXT1, go back to decide again!
					pPktHdr->ingressPort=RTK_RG_EXT_PORT1;
					_rtk_rg_portToMacPort_translator(pPktHdr->ingressPort, &pPktHdr->ingressMacPort, &pPktHdr->ingressMacExtPort);
					pRxDesc->rx_dst_port_mask=0x10;
					goto ingress_port_changed;
#else
					FIXME("unknow from CPU packet, trap reason is %d!",pRxDesc->rx_reason);
#endif
				}

#if 0
				if(pRxDesc->rx_reason==RG_CPU_REASON_UKNOWNDA_IPV6MC) //Unkown IPv6 MC
				{
					TRACE("From PS unkown MC DA trap to here, and will forward by FwdEngine\n");
					return RG_FWDENGINE_RET_SLOWPATH; //goto slow path (flooding to each interface)
				}
#endif
				TRACE("[Drop] CPU to CPU: Drop by src port filter, skb_len=%d! SPA=%d dstPmsk=0x%x",skb->len,pPktHdr->ingressMacPort,pRxDesc->rx_dst_port_mask);
				return RG_FWDENGINE_RET_DROP;
			}
		}
		else //NOT FROM CPU
		{

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
			if(pRxDesc->rx_reason != RG_CPU_REASON_NORMAL_FWD )
			{
				TRACE("not from cpu and trap to cpu, goto Slowpath");
				return RG_FWDENGINE_RET_SLOWPATH;
			}
#endif

			if((skb->data[0]&1)==0) //Unicast
			{
				if(pRxDesc->rx_dst_port_mask==0x2)  //from Physical Port to EXT0 Unicast
				{
		#ifdef CONFIG_MASTER_WLAN0_ENABLE
					if(wlan_root_netdev!=NULL)
					{
						int dip_lookup_idx=-1,intfIdx=-1;
						TRACE("from Physical Port to EXT0 Unicast, send to WIFI1, skb_len=%d!",skb->len);


						//Routing/L34 to EXT0 has vlan problem (vlan already traslate by H/W)
						if(pRxDesc->rx_l3routing==1)//Wan routing to  EXT0
						{
							//20160926LUKE: fix for WWAN, too.
							//Lookup SA for LAN interface, if match, change egressVLANID
							//20150325CHUCK: if H/W routing from physical wan port to wifi, the vlan wcould be removed  by H/W and fwd to software. then vlan will be consider as WAN PVID, need to change it for egress vlan filter.
							//comprae DIPv4 & DIPv6 in Lan IP subnet
							if(pPktHdr->tagif&IPV4_TAGIF)
							{
								dip_lookup_idx = _rtk_rg_l3lookup(pPktHdr->ipv4Dip);
								if(rg_db.l3[dip_lookup_idx].rtk_l3.process==L34_PROCESS_ARP)
									intfIdx=rg_db.l3[dip_lookup_idx].rtk_l3.netifIdx;
								else if(rg_db.l3[dip_lookup_idx].rtk_l3.process==L34_PROCESS_NH)
									intfIdx=rg_db.nexthop[rg_db.l3[dip_lookup_idx].rtk_l3.nhStart].rtk_nexthop.ifIdx;
							}
							else if(pPktHdr->tagif&IPV6_TAGIF)
							{
								dip_lookup_idx = _rtk_rg_v6L3lookup(pPktHdr->pIpv6Dip);
								if(dip_lookup_idx>=0){
									if(rg_db.v6route[dip_lookup_idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_LOCAL)
										intfIdx=rg_db.v6route[dip_lookup_idx].rtk_v6route.nhOrIfidIdx;
									else if(rg_db.v6route[dip_lookup_idx].rtk_v6route.type==L34_IPV6_ROUTE_TYPE_GLOBAL)
										intfIdx=rg_db.nexthop[rg_db.v6route[dip_lookup_idx].rtk_v6route.nhOrIfidIdx].rtk_nexthop.ifIdx;
								}
							}

							if(intfIdx>=0 && rg_db.systemGlobal.interfaceInfo[intfIdx].valid)
							{
								if(rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.is_wan==0)//valid lan intf
								{
									TRACE("to Lan[%d]..change egressVLANID to %d",intfIdx, rg_db.systemGlobal.interfaceInfo[intfIdx].p_lanIntfConf->intf_vlan_id);
									pPktHdr->egressVlanID= rg_db.systemGlobal.interfaceInfo[dip_lookup_idx].p_lanIntfConf->intf_vlan_id;
								}
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
								else //valid wwan intf
								{
									TRACE("to WWan[%d]..change egressVLANID to %d",intfIdx, rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id);
									pPktHdr->egressVlanID = rg_db.systemGlobal.interfaceInfo[intfIdx].storedInfo.wan_intf.wan_intf_conf.egress_vlan_id;
								}
#endif
							}
						}

						if(_rtk_master_wlan_mbssid_tx(pPktHdr,skb)==RG_RET_MBSSID_NOT_FOUND)
						{
							TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
							return RG_FWDENGINE_RET_DROP;
						}

						return RG_FWDENGINE_RET_CONTINUE;
					}
					else
					{
						TRACE("[Drop] wlan_root_netdev is null");
						return RG_FWDENGINE_RET_DROP;
					}

		#endif
				}
#ifdef CONFIG_DUALBAND_CONCURRENT
				else if(pRxDesc->rx_dst_port_mask==0x4) //from Physical Port to EXT1 Unicast
				{
					TRACE("To EXT1 UC packets which trap to master CPU must be forwarded by fwdEngine");
				}
#endif
			}
			else if(skb->data[0]==0xff) //Broadcast
			{
				TRACE("not from CPU Broadcast goto FwdEngine, skb_len=%d!",skb->len);
				return RG_FWDENGINE_RET_SLOWPATH;
			}
			else if((skb->data[0]&1)==1) //Multicast
			{

				/*
					Note:

					if forward extensionPort >=2  oriForward to CPU forwardRsn=RG_CPU_REASON_NORMAL_FWD && origformat=1
					if forward extensionPort ==1  forward to cpu but packet not origformat, change SA/TTL by hardware

					for 9600Series igmpSnoopingEnable==2 ForwardToCPU by groupTable rx_reason=0 and rx_dst_port_mask=0x7 , will flooding to ext0/ext1
				*/
				//DEBUG("rx_reason=%d  rx_dst_port_mask=%x pRxDesc->rx_origformat=%d",pRxDesc->rx_reason,pRxDesc->rx_dst_port_mask,pRxDesc->rx_origformat);
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
				if(pPktHdr->tagif & DSLITEMC_INNER_TAGIF)
				{
					TRACE("dul header go to shlow path to remove header");
					return RG_FWDENGINE_RET_SLOWPATH;
				}

				//we only fully support 9607C in slow path
				if(pRxDesc->rx_reason==RG_CPU_REASON_NORMAL_FWD && pRxDesc->rx_origformat==1 )
				{
					TRACE("forward extPort >=2 goto slow path");
					return RG_FWDENGINE_RET_SLOWPATH;
				}
#endif
#endif	// end CONFIG_RG_FLOW_BASED_PLATFORM
				if(rg_db.systemGlobal.initParam.igmpSnoopingEnable==0)
				{
					TRACE("snooping off go to slowpath");
					return RG_FWDENGINE_RET_SLOWPATH; //must send to phyiscal port when igmp snooping is disabled.
				}


				if(pRxDesc->rx_dst_port_mask&0x1)
				{
					if(pRxDesc->rx_reason!=RG_CPU_REASON_NORMAL_FWD)
					{
						TRACE("Unkown Trap Reason, goto to slow path.");
						return RG_FWDENGINE_RET_SLOWPATH;
					}
					else if((pPktHdr->tagif&IPV4_TAGIF)&&(pPktHdr->ipv4Dip>=0xe0000100)&&(pPktHdr->ipv4Dip<=0xeeffffff))
					{
						if(rg_db.systemGlobal.multicastProtocol == RG_MC_MLD_ONLY)//don't do anything here
							return RG_FWDENGINE_RET_SLOWPATH;
						TRACE("Drop IPv4 multicast data to CPU packet...(just send to WIFI)");
					}
					else if((pPktHdr->tagif&IPV6_TAGIF)&&(pPktHdr->pIpv6Dip[0]==0xff)&&((pPktHdr->pIpv6Dip[1]&0x0f)==0xe))
					{
						if(rg_db.systemGlobal.multicastProtocol == RG_MC_IGMP_ONLY)	//don't do anything here
							return RG_FWDENGINE_RET_SLOWPATH;
						TRACE("Drop IPv6 multicast data to CPU packet...(just send to WIFI)");
					}
					/*else if((pPktHdr->tagif&IPV4_TAGIF)&&(pPktHdr->ipv4Dip==0xeffffffa))
					{
						TRACE("SSDP multicast data, to PS!");
						return RG_FWDENGINE_RET_TO_PS;
					}*/
					else
					{
						TRACE("Unkown Multicast packets send to CPU and go to slow path.");
						return RG_FWDENGINE_RET_SLOWPATH;
					}
				}

				if(pRxDesc->rx_dst_port_mask&0x6)  //from Physical Port to EXT1 or EXT0 Multicast,
				{
					TRACE("Multicast packets to EXT0 or EXT1 port will forward by master CPU.");

					if(memcmp(skb->data,"\x01\x80\xc2",3)==0)
					{
						TRACE("[To PS] Reserved MAC: 01:80:C2:%02x:%02x:%02x, to PS!",skb->data[3],skb->data[4],skb->data[5]);
						return RG_FWDENGINE_RET_TO_PS;
					}



					if(pRxDesc->rx_dst_port_mask&0x4)
					{
#ifdef CONFIG_DUALBAND_CONCURRENT
						struct sk_buff *skb_new=NULL;

						skb_new=_rtk_rg_skb_clone(skb,GFP_ATOMIC);
						if(skb_new==NULL)
						{
							WARNING("[Drop] Fail to get free skb buffer");
							return RG_FWDENGINE_RET_DROP;
						}

						//send to WIFI2(EXT1)
						rg_kernel.txDesc.opts1.dw=0;
						rg_kernel.txDesc.opts2.dw=0;
						rg_kernel.txDesc.opts3.dw=0;
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
						rg_kernel.txDesc.opts4.dw=0;
#endif

						rg_kernel.txDesc.tx_dislrn=1; // patch for reason 192
						rg_kernel.txDesc.tx_tx_portmask=0; //HWLOOKUP (because: HW do not have extension port & CPU port bit)
						rg_kernel.txDesc.tx_tx_cvlan_action=0;// intact

						pPktHdr->egressVlanID=CONFIG_DEFAULT_TO_SLAVE_GMAC_VID;
						pPktHdr->egressVlanTagif=1;
						pPktHdr->egressPriority=CONFIG_DEFAULT_TO_SLAVE_GMAC_PRI;


						TRACE("Multicast from master CPU to WIFI2 by GMAC(VID=1,PRI=4,HWLOOKUP)");
						_rtk_rg_egressPacketSend(skb_new,pPktHdr);
#endif
					}


					if(pRxDesc->rx_dst_port_mask&0x2)
					{
#ifdef CONFIG_MASTER_WLAN0_ENABLE
						if(wlan_root_netdev)
						{
							TRACE("Multicast to WIFI1(EXT0)");
							if(_rtk_master_wlan_mbssid_tx(pPktHdr,skb)==RG_RET_MBSSID_NOT_FOUND)
							{
								TRACE("[Drop] master wifi tx but DMAC is not found in MBSSID table, drop!");
								return RG_FWDENGINE_RET_DROP;
							}
						}
						else
						{
							TRACE("[Drop] wlan_root_netdev is null");
							return RG_FWDENGINE_RET_DROP;
						}
#else //for slave only
						TRACE("[Drop] wlan_root_netdev is null");
						return RG_FWDENGINE_RET_DROP;
#endif
					}
					return RG_FWDENGINE_RET_DROP;
				}
				else
				{
					TRACE("[Drop] Multicast from Physical Port but not to EXT1 or EXT0");
					return RG_FWDENGINE_RET_DROP;
				}

			}
		}

#endif
	return RG_FWDENGINE_RET_SLOWPATH;

}

void _rtk_rg_updatePPTPInfo(int wanGroupIdx, rtk_rg_pktHdr_t *pPktHdr)
{

#if defined(CONFIG_RG_FLOW_BASED_PLATFORM)
#if !defined(CONFIG_RG_G3_SERIES)
	uint32 tunnelInfo;
#endif //!defined(CONFIG_RG_G3_SERIES)
#endif

	if(rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_wanIntfConf->wan_type==RTK_RG_PPTP)
	{
		if(pPktHdr->tagif&GRE_SEQ_TAGIF)
		{
			//20150617LUKE: store seq from protocol stack, for response packet can restore it's ack
			rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.pptp_info.sw_gre_header_sequence=pPktHdr->GRESequence;
			//update sequence to next value
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
			// get actually sequence number from HW reg.
			rtk_rg_asic_dualHdrInfo_get(FB_DUALHDR_GRESEQ, rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index, &tunnelInfo);
			// Sync to HW reg (next: seq+1) or Sync HW reg to current packet
			if(pPktHdr->GRESequence>tunnelInfo){
				rtk_rg_asic_dualHdrInfo_set(FB_DUALHDR_GRESEQ, rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index, pPktHdr->GRESequence+1);
			}
			else{
				// HW reg has been added one automatically, no need to set +1 again.
				*pPktHdr->pGRESequence=htonl(tunnelInfo);
			}
#else
			//rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.pptp_info.gre_header_sequence=pPktHdr->GRESequence+1;
			if(pPktHdr->GRESequence>rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.pptp_info.gre_header_sequence)
				rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.pptp_info.gre_header_sequence=pPktHdr->GRESequence;
			else
				*pPktHdr->pGRESequence=htonl(++rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.pptp_info.gre_header_sequence);
#endif

		}
		if(pPktHdr->tagif&GRE_ACK_TAGIF)
		{
			//update acknowledgment for packet from protocol stack by WAN's acknowledgment value
#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && !defined(CONFIG_RG_G3_SERIES)
			rtk_rg_asic_dualHdrInfo_get(FB_DUALHDR_GREACK, rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].index, &tunnelInfo);
			*pPktHdr->pGREAcknowledgment=htonl(tunnelInfo);
#else
			*pPktHdr->pGREAcknowledgment=htonl(rg_db.systemGlobal.wanIntfGroup[wanGroupIdx].p_intfInfo->storedInfo.wan_intf.pptp_info.gre_header_acknowledgment);
#endif
		}
	}
}

rtk_rg_fwdEngineReturn_t _rtk_rg_checkFromProtocolStackInterface(rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	rtk_rg_table_icmp_flow_t *icmpCtrlFlow=NULL;
	rtk_ipv6_addr_t zeroV6Addr={{0}};

	//20140122LUKE:if there is no any interface, we just let directTX to forward.
	if(rg_db.systemGlobal.lanIntfTotalNum==0 && rg_db.systemGlobal.wanIntfTotalNum==0)
		goto egress_acl_check_and_direct_tx;

	//choose SA and SIP both match interface first, then choose SA match only interface
	//broadcast should not check LAN interface...LAN should follow VLAN decision!!

	if(rg_db.systemGlobal.icmpRedirectToDMZ && (pPktHdr->tagif&ICMP_TAGIF) && (pPktHdr->ICMPType==0 || pPktHdr->ICMPType==8))
	{
		//record from PS icmp connection
		TRACE("record from PS icmp connection lutDaIdx=%d",pPktHdr->dmacL2Idx);
		_rtk_rg_fwdEngine_ICMPOutboundControlFlowTracking(pPktHdr,&icmpCtrlFlow);
	}


	if(pPktHdr->fwdDecision!=RG_FWD_DECISION_NORMAL_BC)
	{
		for(i=0;i<rg_db.systemGlobal.lanIntfTotalNum;i++)
		{
			if(((pPktHdr->tagif&CVLAN_TAGIF) && pPktHdr->ctagVid!=rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id) ||
				((pPktHdr->tagif&CVLAN_TAGIF)==0 && (rg_db.vlan[rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->intf_vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MAINCPU))==0))
				continue;

			if(!memcmp(pPktHdr->pSmac,rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->gmac.octet,ETHER_ADDR_LEN))
			{
				if(pPktHdr->netifIdx==FAIL)
					pPktHdr->netifIdx=rg_db.systemGlobal.lanIntfGroup[i].index; //keep first MAC match LAN interface

				if(pPktHdr->tagif&IPV4_TAGIF || pPktHdr->tagif&ARP_TAGIF)
				{
					if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_version!=IPVER_V6ONLY && pPktHdr->ipv4Sip!=0 &&
						pPktHdr->ipv4Sip==rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_addr)
					{
						pPktHdr->netifIdx=rg_db.systemGlobal.lanIntfGroup[i].index;
						TRACE("HIT LAN MAC[%02x:%02x:%02x:%02x:%02x:%02x] with IP[%x]! netifIdx is %d",
							pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],
							pPktHdr->pSmac[4],pPktHdr->pSmac[5],pPktHdr->ipv4Sip,pPktHdr->netifIdx);
						goto egress_acl_check_and_direct_tx;
					}
				}
				else if(pPktHdr->tagif&IPV6_TAGIF)
				{
					if(rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ip_version!=IPVER_V4ONLY &&
						memcmp(pPktHdr->pIpv6Sip,zeroV6Addr.ipv6_addr,IPV6_ADDR_LEN) &&
						!memcmp(pPktHdr->pIpv6Sip,rg_db.systemGlobal.lanIntfGroup[i].p_intfInfo->p_lanIntfConf->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN))
					{
						pPktHdr->netifIdx=rg_db.systemGlobal.lanIntfGroup[i].index;
						TRACE("HIT LAN MAC[%02x:%02x:%02x:%02x:%02x:%02x] with IP[%x%x:%x%x:%x%x:%x%x:%x%x:%x%x:%x%x:%x%x]! netifIdx is %d",
							pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],
							pPktHdr->pIpv6Sip[0],pPktHdr->pIpv6Sip[1],pPktHdr->pIpv6Sip[2],pPktHdr->pIpv6Sip[3],
							pPktHdr->pIpv6Sip[4],pPktHdr->pIpv6Sip[5],pPktHdr->pIpv6Sip[6],pPktHdr->pIpv6Sip[7],
							pPktHdr->pIpv6Sip[8],pPktHdr->pIpv6Sip[9],pPktHdr->pIpv6Sip[10],pPktHdr->pIpv6Sip[11],
							pPktHdr->pIpv6Sip[12],pPktHdr->pIpv6Sip[13],pPktHdr->pIpv6Sip[14],pPktHdr->pIpv6Sip[15],
							pPktHdr->netifIdx);
						goto egress_acl_check_and_direct_tx;
					}
				}
			}
		}
		if(pPktHdr->netifIdx!=FAIL)
		{
			TRACE("HIT LAN MAC[%02x:%02x:%02x:%02x:%02x:%02x]! netifIdx is %d",
				pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],
				pPktHdr->pSmac[4],pPktHdr->pSmac[5],pPktHdr->netifIdx);
			goto egress_acl_check_and_direct_tx;	//no IP-MAC match, so choose MAC match
		}
	}

	//20150407LUKE: check PPTP WAN first!!
	if((pPktHdr->tagif&GRE_TAGIF)&&(pPktHdr->tagif&IPV4_TAGIF))
	{
		for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
		{
			if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_PPTP)
				continue;

			//20150408LUKE: PPTP WAN may has different MAC address with Based WAN, so we don't check MAC here.
			//if(!memcmp(pPktHdr->pSmac,rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,ETHER_ADDR_LEN))
			//{
				//DEBUG("*pPktHdr->pGRECallID is %d, gateway is %d",*pPktHdr->pGRECallID,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.pptp_info.after_dial.gateway_callId);
				if(rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_version!=IPVER_V6ONLY && pPktHdr->ipv4Dip!=0 &&
					pPktHdr->ipv4Dip==rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.pptp_info.before_dial.pptp_ipv4_addr &&
					ntohs(*pPktHdr->pGRECallID)==rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->storedInfo.wan_intf.pptp_info.after_dial.gateway_callId)
				{
					pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
					TRACE("HIT PPTP WAN MAC[%02x:%02x:%02x:%02x:%02x:%02x] with IP[%x]! netifIdx is %d",
						pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],
						pPktHdr->pSmac[4],pPktHdr->pSmac[5],pPktHdr->ipv4Sip,pPktHdr->netifIdx);
					//20150107LUKE: check for PPTP WAN, update the sequence and acknowledgment
					_rtk_rg_updatePPTPInfo(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index,pPktHdr);
					goto egress_acl_check_and_direct_tx;
				}
			//}
		}
	}

	for(i=0;i<rg_db.systemGlobal.wanIntfTotalNum;i++)
	{
		if(((pPktHdr->tagif&CVLAN_TAGIF) && pPktHdr->ctagVid!=rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id)||
			((pPktHdr->tagif&CVLAN_TAGIF)==0 && (rg_db.vlan[rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->egress_vlan_id].UntagPortmask.bits[0]&(0x1<<RTK_RG_MAC_PORT_MAINCPU))==0))
			continue;

		if(!memcmp(pPktHdr->pSmac,rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->gmac.octet,ETHER_ADDR_LEN))
		{
			if(pPktHdr->netifIdx==FAIL)
				pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[i].index; //keep first MAC match WAN interface

			if(pPktHdr->tagif&IPV4_TAGIF || pPktHdr->tagif&ARP_TAGIF)
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE &&
					rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_version!=IPVER_V6ONLY && pPktHdr->ipv4Sip!=0 &&
					pPktHdr->ipv4Sip==rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_addr)
				{
					pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
					TRACE("HIT WAN MAC[%02x:%02x:%02x:%02x:%02x:%02x] with IP[%x]! netifIdx is %d",
						pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],
						pPktHdr->pSmac[4],pPktHdr->pSmac[5],pPktHdr->ipv4Sip,pPktHdr->netifIdx);
					//20150107LUKE: check for PPTP WAN, update the sequence and acknowledgment
					_rtk_rg_updatePPTPInfo(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index,pPktHdr);
					goto egress_acl_check_and_direct_tx;
				}
			}
			else if(pPktHdr->tagif&IPV6_TAGIF)
			{
				if(rg_db.systemGlobal.wanIntfGroup[i].p_wanIntfConf->wan_type!=RTK_RG_BRIDGE &&
					rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ip_version!=IPVER_V4ONLY &&
					memcmp(pPktHdr->pIpv6Sip,zeroV6Addr.ipv6_addr,IPV6_ADDR_LEN) &&
					!memcmp(pPktHdr->pIpv6Sip,rg_db.systemGlobal.wanIntfGroup[i].p_intfInfo->p_wanStaticInfo->ipv6_addr.ipv6_addr,IPV6_ADDR_LEN))
				{
					pPktHdr->netifIdx=rg_db.systemGlobal.wanIntfGroup[i].index;
					TRACE("HIT WAN MAC[%02x:%02x:%02x:%02x:%02x:%02x] with IP[%x%x:%x%x:%x%x:%x%x:%x%x:%x%x:%x%x:%x%x]! netifIdx is %d",
						pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],
						pPktHdr->pIpv6Sip[0],pPktHdr->pIpv6Sip[1],pPktHdr->pIpv6Sip[2],pPktHdr->pIpv6Sip[3],
						pPktHdr->pIpv6Sip[4],pPktHdr->pIpv6Sip[5],pPktHdr->pIpv6Sip[6],pPktHdr->pIpv6Sip[7],
						pPktHdr->pIpv6Sip[8],pPktHdr->pIpv6Sip[9],pPktHdr->pIpv6Sip[10],pPktHdr->pIpv6Sip[11],
						pPktHdr->pIpv6Sip[12],pPktHdr->pIpv6Sip[13],pPktHdr->pIpv6Sip[14],pPktHdr->pIpv6Sip[15],
						pPktHdr->netifIdx);
					//20150107LUKE: check for PPTP WAN, update the sequence and acknowledgment
					_rtk_rg_updatePPTPInfo(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index,pPktHdr);
					goto egress_acl_check_and_direct_tx;
				}
			}
		}
	}
	if(pPktHdr->netifIdx!=FAIL)
	{
		TRACE("HIT WAN MAC[%02x:%02x:%02x:%02x:%02x:%02x]! netifIdx is %d",
			pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],
			pPktHdr->pSmac[4],pPktHdr->pSmac[5],pPktHdr->netifIdx);
		//20141002LUKE: check for PPTP WAN, update the sequence and acknowledgment
		_rtk_rg_updatePPTPInfo(rg_db.systemGlobal.interfaceInfo[pPktHdr->netifIdx].lan_or_wan_index,pPktHdr);
		goto egress_acl_check_and_direct_tx;	//no IP-MAC match, so choose MAC match
	}

#ifdef CONFIG_DUALBAND_CONCURRENT
	//from master WiFi IPC, let it do layer2 forward by hardware lookup;
	if(!memcmp(pPktHdr->pSmac,master_ipc_macAddr.octet,ETHER_ADDR_LEN) /*|| !memcmp(pPktHdr->pSmac,slave_ipc_macAddr.octet,ETHER_ADDR_LEN)*/)
		return RG_FWDENGINE_RET_HWLOOKUP;
#endif

	//from protocol stack don't match any gateway mac??dump it here....
	TRACE("strange packet from protocol stack...SA=%02x:%02x:%02x:%02x:%02x:%02x, DA=%02x:%02x:%02x:%02x:%02x:%02x.......Continue!",
	pPktHdr->pSmac[0],pPktHdr->pSmac[1],pPktHdr->pSmac[2],pPktHdr->pSmac[3],pPktHdr->pSmac[4],pPktHdr->pSmac[5],
	pPktHdr->pDmac[0],pPktHdr->pDmac[1],pPktHdr->pDmac[2],pPktHdr->pDmac[3],pPktHdr->pDmac[4],pPktHdr->pDmac[5]);
	//dump_packet(skb->data,skb->len,"do not match smac packet");
	return RG_FWDENGINE_RET_CONTINUE;

egress_acl_check_and_direct_tx:
	if((0<=pPktHdr->netifIdx && pPktHdr->netifIdx<MAX_NETIF_SW_TABLE_SIZE) && (rg_db.netif[pPktHdr->netifIdx].rtk_netif.mtu < pPktHdr->l3Len))
	{
		pPktHdr->overMTU=1;
		TRACE("From PS and its egress netif is %d and it's overMtu", pPktHdr->netifIdx);
	}
	return RG_FWDENGINE_RET_DIRECT_TX;
}

#ifdef CONFIG_MASTER_WLAN0_ENABLE
#if 0
int _rtk_rg_wlanInsert1QTag(rtk_rg_pktHdr_t *pPktHdr)
{
	//Insert CVLAN tag only DeviceVID is different to PortBasedVID of ext0 port.
	if(rg_db.systemGlobal.portBasedVID[RTK_RG_EXT_PORT0]!=rg_db.systemGlobal.wlan0DeviceBasedVID[pPktHdr->wlan_dev_idx])
	{
		uint16 vlanContent;
		vlanContent = (((rg_db.vlan[rg_db.systemGlobal.wlan0DeviceBasedVID[pPktHdr->wlan_dev_idx]].priority&0x7)<<13)|(rg_db.systemGlobal.wlan0DeviceBasedVID[pPktHdr->wlan_dev_idx]&0xfff));
		_vlan_insert_tag(NULL,pPktHdr->skb,1,0x8100,vlanContent,0,0x0,0x0);

		TRACE("WLAN_TX_O[%x]: from Ext0 Dev[%d] insert CVLAN tag(VID=%d, Pri=%d)",(unsigned int)pPktHdr->skb&0xffff,pPktHdr->wlan_dev_idx,rg_db.systemGlobal.wlan0DeviceBasedVID[pPktHdr->wlan_dev_idx],rg_db.vlan[rg_db.systemGlobal.wlan0DeviceBasedVID[pPktHdr->wlan_dev_idx]].priority);
	}
	return (RG_FWDENGINE_RET_CONTINUE);
}
#endif

#ifdef CONFIG_DUALBAND_CONCURRENT
rtk_rg_mbssidDev_t _rtk_rg_parsing_SSID_tag(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
	if(*((unsigned short *)(&skb->data[ETHER_ADDR_LEN<<1]))==SLAVE_SSID_TAG_ETH){
		//parse SSID tag here and store wlan dev index in pkthdr!
		pPktHdr->wlan_dev_idx=RG_RET_MBSSID_SLAVE_ROOT_INTF+((rtk_rg_mbssidDev_t)(*(unsigned short *)(&skb->data[(ETHER_ADDR_LEN<<1)+2])));

		//copy new DA/SA
		for(i=ETHER_ADDR_LEN<<1;i>0;i--)
			skb->data[i+SLAVE_SSID_TAG_LEN-1]=skb->data[i-1];

		skb->data+=SLAVE_SSID_TAG_LEN;
		skb->len-=SLAVE_SSID_TAG_LEN;
		skb_reset_mac_header(skb);
	}

	return pPktHdr->wlan_dev_idx;
}
#endif

rtk_rg_fwdEngineReturn_t _rtk_rg_wlan_decision(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr)
{
	int i;
#ifdef CONFIG_DUALBAND_CONCURRENT
#if defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
	if(RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<pPktHdr->ingressPort))
	{
		switch(pPktHdr->ingressMacExtPort)
		{
			case RTK_RG_MAC_EXT_PORT0:
			case RTK_RG_MAC_EXT_PORT1:
			case RTK_RG_MAC_EXT_PORT2:
			case RTK_RG_MAC_EXT_PORT3:
			case RTK_RG_MAC_EXT_PORT4:
				pPktHdr->wlan_dev_idx = RG_RET_MBSSID_SLAVE_ROOT_INTF+(pPktHdr->ingressMacExtPort-RTK_RG_MAC_EXT_PORT0);
				break;
			case RTK_RG_MAC_EXT_PORT5:
				if(rg_db.systemGlobal.enableSlaveSSIDBind)
					_rtk_rg_parsing_SSID_tag(skb, pPktHdr);
				break;
			default:
				break;
		}
		if(pPktHdr->wlan_dev_idx!=RG_RET_MBSSID_NOT_FOUND)
			goto SLAVE_WLAN_IDX;
		else
		{
			DEBUG("wlan_dev_idx is not found, IngressMacPort=%d, IngressMacExtPort=%d, enableSlaveSSIDBind=%d", pPktHdr->ingressMacPort, pPktHdr->ingressMacExtPort, rg_db.systemGlobal.enableSlaveSSIDBind);
			return RG_FWDENGINE_RET_CONTINUE;
		}
	}
#else	// not CONFIG_RG_FLOW_NEW_WIFI_MODE
	if((RTK_RG_ALL_SLAVE_EXT_PORTMASK&(0x1<<pPktHdr->ingressPort)) && rg_db.systemGlobal.enableSlaveSSIDBind)
	{
		_rtk_rg_parsing_SSID_tag(skb, pPktHdr);

		if(pPktHdr->wlan_dev_idx!=RG_RET_MBSSID_NOT_FOUND)
			goto SLAVE_WLAN_IDX;
		else
		{
			DEBUG("wlan_dev_idx is not found, IngressMacPort=%d, IngressMacExtPort=%d, enableSlaveSSIDBind=%d", pPktHdr->ingressMacPort, pPktHdr->ingressMacExtPort, rg_db.systemGlobal.enableSlaveSSIDBind);
			return RG_FWDENGINE_RET_CONTINUE;
		}
	}
#endif
#endif

#if defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
#if defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES) || defined(CONFIG_RG_RTL9603CVD_SERIES)
	if(pPktHdr->pRxDesc==(rtk_rg_rxdesc_t *)&rg_db_cache.rxInfoFromWLAN)
#endif
#endif	// end CONFIG_RG_FLOW_NEW_WIFI_MODE
	{
		//decide src wlan device index
		for(i=0;i<MAX_WLAN_DEVICE_NUM;i++)
		{
			switch(i)
			{
				case RG_RET_MBSSID_MASTER_ROOT_INTF:
					if(wlan_root_netdev && skb->dev==wlan_root_netdev)pPktHdr->wlan_dev_idx=i;
					break;
				case RG_RET_MBSSID_MASTER_VAP0_INTF:
				case RG_RET_MBSSID_MASTER_VAP1_INTF:
				case RG_RET_MBSSID_MASTER_VAP2_INTF:
				case RG_RET_MBSSID_MASTER_VAP3_INTF:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
				case RG_RET_MBSSID_MASTER_VAP4_INTF:
				case RG_RET_MBSSID_MASTER_VAP5_INTF:
				case RG_RET_MBSSID_MASTER_VAP6_INTF:
#endif
					if(wlan_vap_netdev[i-RG_RET_MBSSID_MASTER_VAP0_INTF] && skb->dev==wlan_vap_netdev[i-RG_RET_MBSSID_MASTER_VAP0_INTF])pPktHdr->wlan_dev_idx=i;
					break;
#if defined(CONFIG_RTL_WDS_SUPPORT)
				case RG_RET_MBSSID_MASTER_WDS0_INTF:
				case RG_RET_MBSSID_MASTER_WDS1_INTF:
				case RG_RET_MBSSID_MASTER_WDS2_INTF:
				case RG_RET_MBSSID_MASTER_WDS3_INTF:
				case RG_RET_MBSSID_MASTER_WDS4_INTF:
				case RG_RET_MBSSID_MASTER_WDS5_INTF:
				case RG_RET_MBSSID_MASTER_WDS6_INTF:
#ifdef CONFIG_RTL_MESH_SUPPORT
				if(wlan_wds_netdev[i-RG_RET_MBSSID_MASTER_WDS0_INTF] && skb->dev==wlan_wds_netdev[i-RG_RET_MBSSID_MASTER_WDS0_INTF])pPktHdr->wlan_dev_idx=i;
					break;
				case RG_RET_MBSSID_MASTER_MESH_INTF:
					if(wlan_mesh_netdev && skb->dev==wlan_mesh_netdev)pPktHdr->wlan_dev_idx=i;
					break;
#else	// not CONFIG_RTL_MESH_SUPPORT
				case RG_RET_MBSSID_MASTER_WDS7_INTF:
					if(wlan_wds_netdev[i-RG_RET_MBSSID_MASTER_WDS0_INTF] && skb->dev==wlan_wds_netdev[i-RG_RET_MBSSID_MASTER_WDS0_INTF])pPktHdr->wlan_dev_idx=i;
					break;
#endif	// end CONFIG_RTL_MESH_SUPPORT
#else	// not CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_MESH_SUPPORT
				case RG_RET_MBSSID_MASTER_MESH_INTF:
					if(wlan_mesh_netdev && skb->dev==wlan_mesh_netdev)pPktHdr->wlan_dev_idx=i;
					break;
#endif	// end CONFIG_RTL_MESH_SUPPORT
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
				case RG_RET_MBSSID_MASTER_CLIENT_INTF:
					if(wlan_vxd_netdev && skb->dev==wlan_vxd_netdev)pPktHdr->wlan_dev_idx=i;
					break;
#endif
#if defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION)
				case RG_RET_MBSSID_SLAVE_ROOT_INTF:
					if(wlan1_root_netdev && skb->dev==wlan1_root_netdev)pPktHdr->wlan_dev_idx=i;
					break;
				case RG_RET_MBSSID_SLAVE_VAP0_INTF:
				case RG_RET_MBSSID_SLAVE_VAP1_INTF:
				case RG_RET_MBSSID_SLAVE_VAP2_INTF:
				case RG_RET_MBSSID_SLAVE_VAP3_INTF:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
				case RG_RET_MBSSID_SLAVE_VAP4_INTF:
				case RG_RET_MBSSID_SLAVE_VAP5_INTF:
				case RG_RET_MBSSID_SLAVE_VAP6_INTF:
#endif
					if(wlan1_vap_netdev[i-RG_RET_MBSSID_SLAVE_VAP0_INTF] && skb->dev==wlan1_vap_netdev[i-RG_RET_MBSSID_SLAVE_VAP0_INTF])pPktHdr->wlan_dev_idx=i;
					break;
#if defined(CONFIG_RTL_WDS_SUPPORT)
				case RG_RET_MBSSID_SLAVE_WDS0_INTF:
				case RG_RET_MBSSID_SLAVE_WDS1_INTF:
				case RG_RET_MBSSID_SLAVE_WDS2_INTF:
				case RG_RET_MBSSID_SLAVE_WDS3_INTF:
				case RG_RET_MBSSID_SLAVE_WDS4_INTF:
				case RG_RET_MBSSID_SLAVE_WDS5_INTF:
				case RG_RET_MBSSID_SLAVE_WDS6_INTF:
				case RG_RET_MBSSID_SLAVE_WDS7_INTF:
					if(wlan1_wds_netdev[i-RG_RET_MBSSID_SLAVE_WDS0_INTF] && skb->dev==wlan1_wds_netdev[i-RG_RET_MBSSID_SLAVE_WDS0_INTF])pPktHdr->wlan_dev_idx=i;
					break;
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
				case RG_RET_MBSSID_SLAVE_CLIENT_INTF:
					if(wlan1_vxd_netdev && skb->dev==wlan1_vxd_netdev)pPktHdr->wlan_dev_idx=i;
					break;
#endif
#endif
				default:
					break;
			}
			if(pPktHdr->wlan_dev_idx!=RG_RET_MBSSID_NOT_FOUND)break;
		}
	}
#if defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
#if defined(CONFIG_RG_G3_SERIES)
	else
	{
		switch(pPktHdr->pRxDesc->rx_extspa)
		{
			case RTK_RG_MAC_EXT_PORT_WLAN0_ROOT:
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP0:
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP1:
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP2:
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP3:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP4:
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP5:
			case RTK_RG_MAC_EXT_PORT_WLAN0_VAP6:
#endif
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
			pPktHdr->wlan_dev_idx = RG_RET_MBSSID_SLAVE_ROOT_INTF + (pPktHdr->pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT_WLAN0_ROOT);
#else
			pPktHdr->wlan_dev_idx = RG_RET_MBSSID_MASTER_ROOT_INTF + (pPktHdr->pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT_WLAN0_ROOT);
#endif
				break;
			case RTK_RG_MAC_EXT_PORT_WLAN1_ROOT:
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP0:
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP1:
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP2:
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP3:
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP4:
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP5:
			case RTK_RG_MAC_EXT_PORT_WLAN1_VAP6:
#endif
#if defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
			pPktHdr->wlan_dev_idx = RG_RET_MBSSID_MASTER_ROOT_INTF + (pPktHdr->pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT_WLAN1_ROOT);
#else
			pPktHdr->wlan_dev_idx = RG_RET_MBSSID_SLAVE_ROOT_INTF + (pPktHdr->pRxDesc->rx_extspa-RTK_RG_MAC_EXT_PORT_WLAN1_ROOT);
#endif
				break;
			default:
				break;
		}
	}
#elif defined(CONFIG_RG_RTL9607C_SERIES)
	else
	{
		//20170419LUKE: if we are trap from switch, we can get wlan_dev_idx from rxDesc's extspa.
		switch(pPktHdr->pRxDesc->rx_extspa)
		{
			case RTK_RG_MAC_EXT_PORT0://root
			case RTK_RG_MAC_EXT_PORT1://vap0
			case RTK_RG_MAC_EXT_PORT2://vap1
			case RTK_RG_MAC_EXT_PORT3://vap2
			case RTK_RG_MAC_EXT_PORT4://vap3
				pPktHdr->wlan_dev_idx = RG_RET_MBSSID_MASTER_ROOT_INTF+pPktHdr->pRxDesc->rx_extspa-RTK_RG_MAC_EXT_BASED_PORT;
#if defined(CONFIG_RG_FLOW_ENHANCED_WIFI_MODE)
				if(pPktHdr->pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_SLAVECPU)
#elif defined(CONFIG_GMAC1_USABLE) && (defined(CONFIG_WLAN0_2G_WLAN1_5G) || defined(CONFIG_BAND_2G_ON_WLAN0))
				if(pPktHdr->pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_MASTERCPU_CORE0 && !rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
#else
				if(pPktHdr->pRxDesc->rx_src_port_num==RTK_RG_MAC_PORT_MASTERCPU_CORE1 && !rg_kernel.disableSlaveWifiRxAcc_and_enableForwardHash)
#endif
					pPktHdr->wlan_dev_idx += RG_RET_MBSSID_SLAVE_ROOT_INTF;
				break;
			default:
				break;
		}
	}
#elif defined(CONFIG_RG_RTL9603CVD_SERIES)
	else
	{
		//20170419LUKE: if we are trap from switch, we can get wlan_dev_idx from rxDesc's extspa.
		switch(pPktHdr->pRxDesc->rx_extspa)
		{
			case RTK_RG_MAC_EXT_PORT0://root
			case RTK_RG_MAC_EXT_PORT1://vap0
			case RTK_RG_MAC_EXT_PORT2://vap1
			case RTK_RG_MAC_EXT_PORT3://vap2
			case RTK_RG_MAC_EXT_PORT4://vap3
				pPktHdr->wlan_dev_idx = RG_RET_MBSSID_MASTER_ROOT_INTF+pPktHdr->pRxDesc->rx_extspa-RTK_RG_MAC_EXT_BASED_PORT;
				break;
			default:
				break;
		}
	}
#endif
#endif	// end CONFIG_RG_FLOW_NEW_WIFI_MODE

	if(pPktHdr->wlan_dev_idx==RG_RET_MBSSID_NOT_FOUND)
	{
		if(_rtk_rg_wlanMbssidLookup(skb->data+6,&pPktHdr->wlan_dev_idx)==RG_RET_LOOKUPIDX_NOT_FOUND)
		{
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
			//20150515LUKE: from WWAN to WLAN will do hwlookup and forward to CPU,
			//therefore we can't decide src wlan_dev_idx, but we can still forward this packet for known DMAC
			if((!pPktHdr->pRxDesc->rx_origformat)&&(pPktHdr->pRxDesc->rx_l3routing))
			{
				TRACE("packet from wifi to wifi...try to send!");
				return RG_FWDENGINE_RET_CONTINUE;
			}
#endif
			//20180820LUKE: for packets from unknown wifi, trap to protocol stack.
			TRACE("[Trap] strange master wifi packet....can't decide wlan_dev_idx, Trap!");
			//20181121LUKE: internal vlan is not confirmed yet, enter protocol stack without vlan decision.
			pPktHdr->byPassToPsVlanAclDecision=1;
			return RG_FWDENGINE_RET_TO_PS;
		}
	}
#ifdef CONFIG_DUALBAND_CONCURRENT
SLAVE_WLAN_IDX:
#endif
	TRACE("pPkthdr->wlan_dev_idx is %d",pPktHdr->wlan_dev_idx);
	//20150610LUKE: we didn't add 1Q since we can decide ingress cvid from ssid by wlan idx
	//if(!pPktHdr->pRxDesc->rx_reason)
	//{
		//ret=_rtk_rg_wlanInsert1QTag(pPktHdr);
	//}
	//20190729LUKE: copy original packet to protocol stack if match copyToPSWifiDevMask
	if(rg_db.systemGlobal.copyToPSWifiDevMask&(0x1<<pPktHdr->wlan_dev_idx))
	{
		//copy skb, allocate work here
		if(_rtk_rg_checkIngressWifiCopyToPS(pPktHdr->skb,(struct rx_info *)pPktHdr->pRxDesc,&pPktHdr->pWifiIngressCopyWork,pPktHdr->wlan_dev_idx)==RG_RET_SUCCESS)
			pPktHdr->wifiIngressPacketCopied=1;
	}

	//20151106LUKE: wifi ingress rate limie check here
	if(rg_db.systemGlobal.wifiIngressRateLimitMeter[pPktHdr->wlan_dev_idx]){
		if(rg_db.systemGlobal.wifiIngressRateLimitDevOverMask&(0x1<<pPktHdr->wlan_dev_idx))goto OVERLIMIT_DROP;
		rg_db.systemGlobal.wifiIngressByteCount[pPktHdr->wlan_dev_idx] += skb->len;
		if(rg_db.systemGlobal.wifiIngressByteCount[pPktHdr->wlan_dev_idx]/*flow bytes in time period*/ > (rg_db.systemGlobal.wifiIngressRateLimitMeter[pPktHdr->wlan_dev_idx]<<7/*Bps*/)/*rate limit bytes in time period*/){
			rg_db.systemGlobal.wifiIngressRateLimitDevOverMask|=(0x1<<pPktHdr->wlan_dev_idx);
			goto OVERLIMIT_DROP;
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;

OVERLIMIT_DROP:
	TRACE("[Drop] Wlan[%d] ingress packet rate higher than %d kbps.",pPktHdr->wlan_dev_idx,rg_db.systemGlobal.wifiIngressRateLimitMeter[pPktHdr->wlan_dev_idx]);
	return RG_FWDENGINE_RET_DROP;
}
#endif

rtk_rg_fwdEngineReturn_t _rtk_rg_unlearnedSARateLimit_check()
{
	if(rg_db.systemGlobal.unlearnedSALimit<0) return RG_FWDENGINE_RET_CONTINUE;

	if(time_is_after_jiffies(rg_db.systemGlobal.unlearnedSAJiffies))
	{
		if((++rg_db.systemGlobal.unlearnedSACount)>=rg_db.systemGlobal.unlearnedSALimit)
		{
			TRACE("[Drop] unlearned sa packet count overlimit(%d >= %d)",rg_db.systemGlobal.unlearnedSACount,rg_db.systemGlobal.unlearnedSALimit);
			return RG_FWDENGINE_RET_DROP;
		}
	}
	else
	{
		rg_db.systemGlobal.unlearnedSACount=0;
		rg_db.systemGlobal.unlearnedSAJiffies=jiffies+TICKTIME_PERIOD;
	}

	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_overMTURateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr)
{
	u32 len=skb->len;
	//uint32 rate;
	//rtk_rg_enable_t ifgInclude;

	if(rg_db.systemGlobal.vlanInit==0) RETURN_ERR(RT_ERR_RG_NOT_INIT);

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	//rate check
	if(rg_db.systemGlobal.overMTURateLimitShareMeterIdx >=0 && rg_db.systemGlobal.overMTURateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.overMTURateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
			if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.overMTURateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
			{
				TRACE("[Drop] overMTU packet rate higher than shareMeter[%d]",rg_db.systemGlobal.overMTURateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#if 0
			rg_db.systemGlobal.overMTUByteCount += len;
			assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.overMTURateLimitShareMeterIdx, &rate , &ifgInclude));
			if(rg_db.systemGlobal.overMTUByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
				TRACE("[Drop] overMTU packet rate higher than shareMeter[%d]",rg_db.systemGlobal.overMTURateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#endif
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_ArpReqRateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr)
{
	u32 len=skb->len;
	//uint32 rate;
	//rtk_rg_enable_t ifgInclude;

	if(rg_db.systemGlobal.vlanInit==0) RETURN_ERR(RT_ERR_RG_NOT_INIT);

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	//rate check
	if(rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx>=0 && rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.ArpReqRateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
			if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
			{
				TRACE("[Drop] Arp request packet rate higher than shareMeter[%d]",rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#if 0
			rg_db.systemGlobal.ArpReqByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
			assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx, &rate , &ifgInclude));
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
			if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
				assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx, &rate , &ifgInclude));
			else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
			{
				rtk_rg_funcbasedMeterConf_t funcMeter;

				funcMeter.type = RTK_RG_METER_PROC;
				funcMeter.idx = rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx;
				assert_ok((pf.rtk_rg_funcbasedMeter_get)(&funcMeter));
				if(funcMeter.state != RTK_RG_DISABLED)
				{
					rate = funcMeter.rate;
					ifgInclude = funcMeter.ifgInclude;
				}
				else
				{
					//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
			}
			else
			{
				//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
				rate = MAX_SWITCH_METER_RATE;
				ifgInclude = ENABLE;
			}
#endif
			if(rg_db.systemGlobal.ArpReqByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
				TRACE("[Drop] Arp request packet rate higher than shareMeter[%d]",rg_db.systemGlobal.ArpReqRateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#endif
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

int _rtk_rg_dosRateLimitValidRule_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr,uint8 *dos_rate_limit_idx)
{
	int i=0;

	RTK_RG_DOS_RATE_LIMIT_VALID_SCAN(i)
	{
		//only need to check this feature when match one of rule
		if((((pPktHdr->tagif&CVLAN_TAGIF) && rg_db.systemGlobal.dosRateLimit[i].ctagif && rg_db.systemGlobal.dosRateLimit[i].ctagVid==pPktHdr->ctagVid) || ((pPktHdr->tagif&CVLAN_TAGIF)==0x0 && rg_db.systemGlobal.dosRateLimit[i].ctagif==0))
			&& (!memcmp(rg_db.systemGlobal.dosRateLimit[i].ingressDmac.octet, pPktHdr->pDmac, ETHER_ADDR_LEN))
			&& ((pPktHdr->tagif&IPV4_TAGIF) && pPktHdr->ipv4Dip==rg_db.systemGlobal.dosRateLimit[i].ingressDip)
			&& (((pPktHdr->tagif&TCP_TAGIF) && rg_db.systemGlobal.dosRateLimit[i].isTcp) || ((pPktHdr->tagif&UDP_TAGIF) && rg_db.systemGlobal.dosRateLimit[i].isTcp==0))
			&& ((skb->len>=rg_db.systemGlobal.dosRateLimit[i].pktLenStart) && (skb->len<=rg_db.systemGlobal.dosRateLimit[i].pktLenEnd)))
		{
			*dos_rate_limit_idx = i;
			return TRUE;
		}
	}

	return FALSE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_dosRateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr,uint8 dos_rate_limit_idx)
{
	u32 len=skb->len;

	if(rg_db.systemGlobal.vlanInit==0) RETURN_ERR(RT_ERR_RG_NOT_INIT);

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	//rate check
	if(rg_db.systemGlobal.dosRateLimit[dos_rate_limit_idx].portmask & (1<<(pPktHdr->ingressPort))){//valid port
		//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
		if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.dosRateLimit[dos_rate_limit_idx].shareMeterIdx, len, 1, RTK_RG_METER_PROC))
		{
			TRACE("[Drop] Dos packet[%d] rate higher than shareMeter[%d]",dos_rate_limit_idx, rg_db.systemGlobal.dosRateLimit[dos_rate_limit_idx].shareMeterIdx);
			return RG_FWDENGINE_RET_DROP;
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_igmpRateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr)
{
	u32 len=skb->len;
	//uint32 rate;
	//rtk_rg_enable_t ifgInclude;

	if(rg_db.systemGlobal.vlanInit==0) RETURN_ERR(RT_ERR_RG_NOT_INIT);

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	//rate check
	if(rg_db.systemGlobal.igmpRateLimitShareMeterIdx>=0 && rg_db.systemGlobal.igmpRateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.igmpRateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
			if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.igmpRateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
			{
				TRACE("[Drop] IGMP packet rate higher than shareMeter[%d]",rg_db.systemGlobal.igmpRateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#if 0
			rg_db.systemGlobal.igmpByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
			assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.igmpRateLimitShareMeterIdx, &rate , &ifgInclude));
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
			if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
				assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.igmpRateLimitShareMeterIdx, &rate , &ifgInclude));
			else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
			{
				rtk_rg_funcbasedMeterConf_t funcMeter;

				funcMeter.type = RTK_RG_METER_PROC;
				funcMeter.idx = rg_db.systemGlobal.igmpRateLimitShareMeterIdx;
				assert_ok((pf.rtk_rg_funcbasedMeter_get)(&funcMeter));
				if(funcMeter.state != RTK_RG_DISABLED)
				{
					rate = funcMeter.rate;
					ifgInclude = funcMeter.ifgInclude;
				}
				else
				{
					//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
			}
			else
			{
				//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
				rate = MAX_SWITCH_METER_RATE;
				ifgInclude = ENABLE;
			}
#endif
			if(rg_db.systemGlobal.igmpByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
				TRACE("[Drop] IGMP packet rate higher than shareMeter[%d]",rg_db.systemGlobal.igmpRateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#endif
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_dhcpRateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr)
{
	u32 len=skb->len;
	//uint32 rate;
	//rtk_rg_enable_t ifgInclude;

	if(rg_db.systemGlobal.vlanInit==0) RETURN_ERR(RT_ERR_RG_NOT_INIT);

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	//rate check
	if(rg_db.systemGlobal.dhcpRateLimitShareMeterIdx>=0 && rg_db.systemGlobal.dhcpRateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.dhcpRateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
			if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.dhcpRateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
			{
				TRACE("[Drop] DHCP packet rate higher than shareMeter[%d]",rg_db.systemGlobal.dhcpRateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#if 0
			rg_db.systemGlobal.dhcpByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
			assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.dhcpRateLimitShareMeterIdx, &rate , &ifgInclude));
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
			if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
				assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.dhcpRateLimitShareMeterIdx, &rate , &ifgInclude));
			else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
			{
				rtk_rg_funcbasedMeterConf_t funcMeter;

				funcMeter.type = RTK_RG_METER_PROC;
				funcMeter.idx = rg_db.systemGlobal.dhcpRateLimitShareMeterIdx;
				assert_ok((pf.rtk_rg_funcbasedMeter_get)(&funcMeter));
				if(funcMeter.state != RTK_RG_DISABLED)
				{
					rate = funcMeter.rate;
					ifgInclude = funcMeter.ifgInclude;
				}
				else
				{
					//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
			}
			else
			{
				//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
				rate = MAX_SWITCH_METER_RATE;
				ifgInclude = ENABLE;
			}
#endif
			if(rg_db.systemGlobal.dhcpByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
				TRACE("[Drop] DHCP packet rate higher than shareMeter[%d]",rg_db.systemGlobal.dhcpRateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
#endif
		}
	}
	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_unknownDARateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr){

	u32 len=skb->len;

	if(rg_db.systemGlobal.vlanInit==0) RETURN_ERR(RT_ERR_RG_NOT_INIT);

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	//rate check
	if(rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx >=0 && rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx<(PURE_SW_METER_IDX_OFFSET+PURE_SW_SHAREMETER_TABLE_SIZE))	//meterIdx valid
#if 1
		{
			//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
			if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
			{
				TRACE("[Drop] unknownDA packet rate higher than shareMeter[%d]",rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx);
				return RG_FWDENGINE_RET_DROP;
			}
		}
#else
		{
			int ret = RG_RET_SUCCESS;;
			rg_db.systemGlobal.unKnownDAByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
			ret=(pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx, &rate , &ifgInclude);
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
			if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
				ret=(pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx, &rate , &ifgInclude);
			else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
			{
				rtk_rg_funcbasedMeterConf_t funcMeter;

				funcMeter.type = RTK_RG_METER_PROC;
				funcMeter.idx = rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx;
				ret = ((pf.rtk_rg_funcbasedMeter_get)(&funcMeter));
				if(funcMeter.state != RTK_RG_DISABLED)
				{
					rate = funcMeter.rate;
					ifgInclude = funcMeter.ifgInclude;
				}
				else
				{
					//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
			}
			else
			{
				//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
				rate = MAX_SWITCH_METER_RATE;
				ifgInclude = ENABLE;
			}
#endif
			assert_ok(ret);
			//rtlglue_printf("_rtk_rg_unknownDARateLimit_check couint=%d rate_limit=%d\n",rg_db.systemGlobal.unKnownDAByteCount*8,(rate*1024*RTK_RG_SWRATELIMIT_SECOND/16));
			if(rg_db.systemGlobal.unKnownDAByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
				TRACE("[Drop] unknownDA packet rate higher than shareMeter[%d]",rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx);
				//rtlglue_printf("Drop! unknownDA packet rate higher than shareMeter[%d] byte_count=%d\n\n",rg_db.systemGlobal.unKnownDARateLimitShareMeterIdx,rg_db.systemGlobal.unKnownDAByteCount);
				return RG_FWDENGINE_RET_DROP;
			}
		}
#endif
	return RG_FWDENGINE_RET_CONTINUE;
}


rtk_rg_fwdEngineReturn_t _rtk_rg_BCMCRateLimit_check(struct sk_buff *skb,rtk_rg_pktHdr_t *pPktHdr){

	u8 *pData=skb->data;
	u32 len=skb->len;
	//uint32 rate;
	//rtk_rg_enable_t ifgInclude;

	if(rg_db.systemGlobal.vlanInit==0) return RG_FWDENGINE_RET_CONTINUE;

    if(len==0) return RG_FWDENGINE_RET_CONTINUE;

	if(pPktHdr->ingressLocation!=RG_IGR_PHY_PORT)
		return RG_FWDENGINE_RET_CONTINUE;


	//BC check
	if(rg_db.systemGlobal.BCRateLimitShareMeterIdx >=0 && rg_db.systemGlobal.BCRateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.BCRateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			if(pData[0]==0xff && pData[1]==0xff && pData[2]==0xff &&
				pData[3]==0xff && pData[4]==0xff && pData[5]==0xff){
				//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
				if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.BCRateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
				{
					TRACE("[Drop] BC packet rate higher than shareMeter[%d]",rg_db.systemGlobal.BCRateLimitShareMeterIdx);
					return RG_FWDENGINE_RET_DROP;
				}
#if 0
				int ret  = RG_RET_SUCCESS;;

				rg_db.systemGlobal.BCByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
				ret=(pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.BCRateLimitShareMeterIdx, &rate , &ifgInclude);
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
				if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
					ret=(pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.BCRateLimitShareMeterIdx, &rate , &ifgInclude);
				else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
				{
					rtk_rg_funcbasedMeterConf_t funcMeter;

					funcMeter.type = RTK_RG_METER_PROC;
					funcMeter.idx = rg_db.systemGlobal.BCRateLimitShareMeterIdx;
					ret = (pf.rtk_rg_funcbasedMeter_get)(&funcMeter);
					if(funcMeter.state != RTK_RG_DISABLED)
					{
						rate = funcMeter.rate;
						ifgInclude = funcMeter.ifgInclude;
					}
					else
					{
						//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
						rate = MAX_SWITCH_METER_RATE;
						ifgInclude = ENABLE;
					}
				}
				else
				{
					//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
#endif

				assert_ok(ret);
				if(rg_db.systemGlobal.BCByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
					TRACE("[Drop] BC packet rate higher than shareMeter[%d]",rg_db.systemGlobal.BCRateLimitShareMeterIdx);
					return RG_FWDENGINE_RET_DROP;
				}
#endif
			}
		}
	}

	//IPv6 MC check
	if(rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx >=0 && rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.IPv6MCRateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			if(pData[0]==0x33 && pData[1]==0x33){
				//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
				if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
				{
					TRACE("[Drop] IPv6 MC packet rate higher than shareMeter[%d]",rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx);
					return RG_FWDENGINE_RET_DROP;
				}
#if 0
				rg_db.systemGlobal.IPv6MCByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
				assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx, &rate , &ifgInclude));
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
				if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
					assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx, &rate , &ifgInclude));
				else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
				{
					rtk_rg_funcbasedMeterConf_t funcMeter;

					funcMeter.type = RTK_RG_METER_PROC;
					funcMeter.idx = rg_db.systemGlobal.IPv6MCRateLimitShareMeterIdx;
					assert_ok((pf.rtk_rg_funcbasedMeter_get)(&funcMeter));
					if(funcMeter.state != RTK_RG_DISABLED)
					{
						rate = funcMeter.rate;
						ifgInclude = funcMeter.ifgInclude;
					}
					else
					{
						//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
						rate = MAX_SWITCH_METER_RATE;
						ifgInclude = ENABLE;
					}
				}
				else
				{
					//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
#endif

				if(rg_db.systemGlobal.IPv6MCByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
					TRACE("[Drop] IPv6 MC packet rate higher than shareMeter[%d]",rg_db.systemGlobal.BCRateLimitShareMeterIdx);
					return RG_FWDENGINE_RET_DROP;
				}
#endif
			}
		}
	}

	//IPv4 MC check
	if(rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx >=0 && rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx<MAX_SHAREMETER_TABLE_SIZE){//meterIdx valid
		if(rg_db.systemGlobal.IPv4MCRateLimitPortMask & (1<<(pPktHdr->ingressPort))){//valid port
			if(pData[0]==0x01 && pData[1]==0x00 && pData[2]==0x5e){
				//20190219LUKE: check rate limit by sharemeter, therefore we don't have to care the meter mode(byte or packet) at all.
				if(RG_FWDENGINE_RET_DROP == _rtk_rg_dropBySwRateLimit_check(rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx, len, 1, RTK_RG_METER_PROC))
				{
					TRACE("[Drop] IPv4 MC packet rate higher than shareMeter[%d]",rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx);
					return RG_FWDENGINE_RET_DROP;
				}
#if 0
				rg_db.systemGlobal.IPv4MCByteCount += len;
#if !defined(CONFIG_RG_RTL9607C_SERIES) && !defined(CONFIG_RG_G3_SERIES) && !defined(CONFIG_RG_RTL9603CVD_SERIES)
				assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx, &rate , &ifgInclude));
#else // defined(CONFIG_RG_RTL9607C_SERIES) || defined(CONFIG_RG_G3_SERIES)
				if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_HW_INDEX)
					assert_ok((pf.rtk_rg_shareMeter_get)(rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx, &rate , &ifgInclude));
				else if(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_SW_INDEX)
				{
					rtk_rg_funcbasedMeterConf_t funcMeter;

					funcMeter.type = RTK_RG_METER_PROC;
					funcMeter.idx = rg_db.systemGlobal.IPv4MCRateLimitShareMeterIdx;
					assert_ok((pf.rtk_rg_funcbasedMeter_get)(&funcMeter));
					if(funcMeter.state != RTK_RG_DISABLED)
					{
						rate = funcMeter.rate;
						ifgInclude = funcMeter.ifgInclude;
					}
					else
					{
						//funcMeter.state == RTK_RG_DISABLED, represents that its funcbased has not been set. Use the MAX rate.
						rate = MAX_SWITCH_METER_RATE;
						ifgInclude = ENABLE;
					}
				}
				else
				{
					//(rg_db.systemGlobal.funbasedMeter_mode == RTK_RG_METERMODE_NOT_INIT)), represents that no meter related configuration has been set. Use the MAX rate.
					rate = MAX_SWITCH_METER_RATE;
					ifgInclude = ENABLE;
				}
#endif

				if(rg_db.systemGlobal.IPv4MCByteCount*8/*flow bits in time period*/ > (rate*1024/*Kbps*/*RTK_RG_SWRATELIMIT_SECOND/16/*unit:(1/16)sec*/)/*rate limit bits in time period*/){
					TRACE("[Drop] IPv4 MC packet rate higher than shareMeter[%d]",rg_db.systemGlobal.BCRateLimitShareMeterIdx);
					return RG_FWDENGINE_RET_DROP;
				}
#endif
			}
		}
	}

	return RG_FWDENGINE_RET_CONTINUE;


}


rtk_rg_fwdEngineReturn_t _rtk_rg_naptSwRateLimit_check(rtk_rg_pktHdr_t *pPktHdr, int limit_naptFilter_idx){

	u32 len=pPktHdr->skb->len;
	uint32 rate;

	if(rg_db.systemGlobal.vlanInit==0) return RG_FWDENGINE_RET_CONTINUE;
    if(len==0) return RG_FWDENGINE_RET_CONTINUE;
	if(limit_naptFilter_idx==FAIL) return RG_FWDENGINE_RET_CONTINUE; // no need to limit

	if((limit_naptFilter_idx < FAIL/*FAIL*/)||(limit_naptFilter_idx >= MAX_NAPT_FILER_SW_ENTRY_SIZE)){  TRACE("naptSwRateLimit weired!!! the limit_naptFilter_idx[%d] is not exist!",limit_naptFilter_idx); return RG_FWDENGINE_RET_CONTINUE;}


	rate = rg_db.systemGlobal.naptSwRateLimitSpeed[limit_naptFilter_idx];
	rg_db.systemGlobal.naptSwRateLimitByteCount[limit_naptFilter_idx]+=len;

	if(rg_db.systemGlobal.naptSwRateLimitByteCount[limit_naptFilter_idx]/*flow bytes in time period*/ > (rate<<7/*Bps*/)){
		DEBUG("Drop!");
		TRACE("[Drop] flow packet rate higher than naptFilter[%d] assigned rate limitation.",limit_naptFilter_idx);
		return RG_FWDENGINE_RET_DROP;
	}


	return RG_FWDENGINE_RET_CONTINUE;
}

rtk_rg_fwdEngineReturn_t _rtk_rg_swDoS_check(rtk_rg_pktHdr_t *pPktHdr)
{
#if defined(CONFIG_RG_G3_SERIES)
	//DAEQSA check
	if(!memcmp(pPktHdr->pSmac,pPktHdr->pDmac,ETHER_ADDR_LEN) && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_DAEQSA_DENY]==RTK_RG_DOS_ACTION_DROP)
	{
		TRACE("[Drop] swDos:DAEQSA...return drop");
		return RG_FWDENGINE_RET_DROP;
	}
	//LANDATTACK check
	if((((pPktHdr->tagif&IPV4_TAGIF)&&pPktHdr->ipv4Sip==pPktHdr->ipv4Dip)||((pPktHdr->tagif&IPV6_TAGIF)&&!memcmp(pPktHdr->pIpv6Sip,pPktHdr->pIpv6Dip,IPV6_ADDR_LEN)))
		&& rg_db.systemGlobal.swDosAction[RTK_RG_DOS_LAND_DENY]==RTK_RG_DOS_ACTION_DROP)
	{
		TRACE("[Drop] swDos:LANDATTACKS...return drop");
		return RG_FWDENGINE_RET_DROP;
	}
	if(pPktHdr->tagif&TCP_TAGIF)
	{
		//BLATATTACK check
		if(pPktHdr->sport==pPktHdr->dport && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_BLAT_DENY]==RTK_RG_DOS_ACTION_DROP)
			goto DROP_BLATATTACK;
		//XMASCAN check
		if(pPktHdr->tcpSeq==0 && *((u8*)(&pPktHdr->tcpFlags))==0x29 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_XMA_DENY]==RTK_RG_DOS_ACTION_DROP)
		{
			TRACE("[Drop] swDos:XMASCAN...return drop");
			return RG_FWDENGINE_RET_DROP;
		}
		//NULLSCAN check
		if(pPktHdr->tcpSeq==0 && *((u8*)(&pPktHdr->tcpFlags))==0 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_NULLSCAN_DENY]==RTK_RG_DOS_ACTION_DROP)
		{
			TRACE("[Drop] swDos:NULLSCAN...return drop");
			return RG_FWDENGINE_RET_DROP;
		}
		//SYN1024 check
		if(*((u8*)(&pPktHdr->tcpFlags))==0x2 && pPktHdr->sport<1024 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_SYN_SPORTL1024_DENY]==RTK_RG_DOS_ACTION_DROP)
		{
			TRACE("[Drop] swDos:SYN1024...return drop");
			return RG_FWDENGINE_RET_DROP;
		}

		if(pPktHdr->tagif&IPV4_TAGIF)
		{
			if(pPktHdr->ipv4FragPacket)
			{
				if(pPktHdr->ipv4FragmentOffset==0)
				{
					//TCPSHORTHDR check
					if(pPktHdr->headerLen<MIN_TCP_HDR_LEN && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_TCPHDR_MIN_CHECK]==RTK_RG_DOS_ACTION_DROP)
						goto DROP_TCPSHORTHDR;
					//SYNWITHDATA
					if(*((u8*)(&pPktHdr->tcpFlags))==0x2 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_SYNWITHDATA_DENY]==RTK_RG_DOS_ACTION_DROP)
						goto DROP_SYNWITHDATA;
				}
				//TCPFRAGERROR check
				if(pPktHdr->ipv4FragmentOffset==1 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_TCP_FRAG_OFF_MIN_CHECK]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_TCPFRAGERROR;
				//PINGOFDEATH
				if((pPktHdr->ipv4FragmentOffset<<3)+pPktHdr->l3Len-pPktHdr->ipv4HeaderLen>MAX_L3_LEN && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_POD_DENY]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_PINGOFDEATH;
			}
			else
			{
				//TCPSHORTHDR check
				if(pPktHdr->headerLen<MIN_TCP_HDR_LEN && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_TCPHDR_MIN_CHECK]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_TCPSHORTHDR;
				//SYNWITHDATA
				if(*((u8*)(&pPktHdr->tcpFlags))==0x2 && pPktHdr->l3Len-pPktHdr->ipv4HeaderLen>pPktHdr->headerLen
					&& rg_db.systemGlobal.swDosAction[RTK_RG_DOS_SYNWITHDATA_DENY]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_SYNWITHDATA;
			}
		}
		else if(pPktHdr->tagif&IPV6_TAGIF)
		{
			if(pPktHdr->ipv6FragPacket)
			{
				if(pPktHdr->ipv6FragmentOffset==0)
				{
					//TCPSHORTHDR check
					if(pPktHdr->headerLen<MIN_TCP_HDR_LEN && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_TCPHDR_MIN_CHECK]==RTK_RG_DOS_ACTION_DROP)
						goto DROP_TCPSHORTHDR;
					//SYNWITHDATA
					if(*((u8*)(&pPktHdr->tcpFlags))==0x2 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_SYNWITHDATA_DENY]==RTK_RG_DOS_ACTION_DROP)
						goto DROP_SYNWITHDATA;
				}
				//TCPFRAGERROR check
				if(pPktHdr->ipv6FragmentOffset==1 && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_TCP_FRAG_OFF_MIN_CHECK]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_TCPFRAGERROR;
				//PINGOFDEATH
				if((pPktHdr->ipv6FragmentOffset<<3)+pPktHdr->ipv6PayloadLen>MAX_L3_LEN && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_POD_DENY]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_PINGOFDEATH;
			}
			else
			{
				//TCPSHORTHDR check
				if(pPktHdr->headerLen<MIN_TCP_HDR_LEN && rg_db.systemGlobal.swDosAction[RTK_RG_DOS_TCPHDR_MIN_CHECK]==RTK_RG_DOS_ACTION_DROP)
					goto DROP_TCPSHORTHDR;
				//SYNWITHDATA
				if(*((u8*)(&pPktHdr->tcpFlags))==0x2 && pPktHdr->ipv6PayloadLen>pPktHdr->headerLen
					&& rg_db.systemGlobal.swDo