#ifndef RTK_RG_PORT_H
#define RTK_RG_PORT_H


typedef enum rtk_rg_mac_port_idx_e
{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RTL9601B_SERIES)

	RTK_RG_MAC_PORT0=0,
	RTK_RG_MAC_PORT1,
	RTK_RG_MAC_PORT2,
	RTK_RG_MAC_PORT3,
	RTK_RG_MAC_PORT_PON,
	RTK_RG_MAC_PORT_RGMII,
	RTK_RG_MAC_PORT_CPU,
	RTK_RG_MAC_PORT_MAX,

#elif defined(CONFIG_RG_RTL9602C_SERIES)

	RTK_RG_MAC_PORT0=0,
	RTK_RG_MAC_PORT1,
	RTK_RG_MAC_PORT_PON,
	RTK_RG_MAC_PORT_CPU,
	RTK_RG_MAC_PORT_MAX,

#elif defined(CONFIG_RG_RTL9607C_SERIES)

	RTK_RG_MAC_PORT0=0,
	RTK_RG_MAC_PORT1=1,
	RTK_RG_MAC_PORT2=2,
	RTK_RG_MAC_PORT3=3,
	RTK_RG_MAC_PORT4=4,
	RTK_RG_MAC_PORT_PON=5,
	RTK_RG_MAC_PORT_iNIC=6,
	RTK_RG_MAC_PORT_SLAVECPU=7,
	RTK_RG_MAC_PORT_RGMII=8,
	RTK_RG_MAC_PORT_MASTERCPU_CORE0=9,
	RTK_RG_MAC_PORT_MASTERCPU_CORE1=10,
	RTK_RG_MAC_PORT_MAX,

#elif defined(CONFIG_RG_RTL9603CVD_SERIES)

	RTK_RG_MAC_PORT0=0,
	RTK_RG_MAC_PORT1=1,
	RTK_RG_MAC_PORT2=2,
	RTK_RG_MAC_PORT3=3,
	RTK_RG_MAC_PORT_PON=4,
	RTK_RG_MAC_PORT_CPU=5,
	RTK_RG_MAC_PORT_MAX,

#elif defined(CONFIG_RG_G3_SERIES)

	RTK_RG_MAC_PORT0=0,
	RTK_RG_MAC_PORT1=1,
	RTK_RG_MAC_PORT2=2,
	RTK_RG_MAC_PORT3=3,
#if defined(CONFIG_ARCH_CORTINA_G3HGU)
	RTK_RG_MAC_PORT4=4,
	RTK_RG_MAC_PORT5=5,
	RTK_RG_MAC_PORT6=6,
#if defined(CONFIG_RG_G3_WAN_PORT_INDEX)
	RTK_RG_MAC_PORT_PON=CONFIG_RG_G3_WAN_PORT_INDEX,
#else
	RTK_RG_MAC_PORT_PON=7,
#endif
#else
	RTK_RG_MAC_PORT_PON=7,
#endif
	RTK_RG_MAC_PORT_CPU=0x10,
	RTK_RG_MAC_PORT_CPU_WLAN0_ROOT=0x12,
	RTK_RG_MAC_PORT_CPU_WLAN0_VAP0=0x13,
	RTK_RG_MAC_PORT_CPU_WLAN0_VAP1=0x14,
	RTK_RG_MAC_PORT_CPU_WLAN0_VAP2=0x15,
	RTK_RG_MAC_PORT_CPU_WLAN0_VAP3=0x16,
	RTK_RG_MAC_PORT_CPU_WLAN1_AND_OTHERS=0x17,
	RTK_RG_MAC_PORT_MAX,

#endif

} rtk_rg_mac_port_idx_t;

typedef enum rtk_rg_mac_ext_port_idx_e
{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RTL9601B_SERIES)

	RTK_RG_MAC_EXT_CPU=0,
	RTK_RG_MAC_EXT_PORT0=1,
	RTK_RG_MAC_EXT_PORT1=2,
	RTK_RG_MAC_EXT_PORT2=3,
	RTK_RG_MAC_EXT_PORT3=4,
	RTK_RG_MAC_EXT_PORT4=5,
	RTK_RG_MAC_EXT_PORT_MAX,

#elif defined(CONFIG_RG_RTL9602C_SERIES)

	RTK_RG_MAC_EXT_CPU=0,
	RTK_RG_MAC_EXT_PORT0=1,
	RTK_RG_MAC_EXT_PORT1=2,
	RTK_RG_MAC_EXT_PORT2=3,
	RTK_RG_MAC_EXT_PORT3=4,
	RTK_RG_MAC_EXT_PORT4=5,
	RTK_RG_MAC_EXT_PORT5=6,
	RTK_RG_MAC_EXT_PORT_MAX,

#elif defined(CONFIG_RG_RTL9607C_SERIES)

	RTK_RG_MAC_EXT_CPU=0,
	RTK_RG_MAC_EXT_PORT0=1,
	RTK_RG_MAC_EXT_PORT1=2,
	RTK_RG_MAC_EXT_PORT2=3,
	RTK_RG_MAC_EXT_PORT3=4,
	RTK_RG_MAC_EXT_PORT4=5,
	RTK_RG_MAC_EXT_PORT5=6,
	RTK_RG_MAC_EXT_PORT_MAX,

#elif defined(CONFIG_RG_RTL9603CVD_SERIES)

	RTK_RG_MAC_EXT_CPU=0,
	RTK_RG_MAC_EXT_PORT0=1,
	RTK_RG_MAC_EXT_PORT1=2,
	RTK_RG_MAC_EXT_PORT2=3,
	RTK_RG_MAC_EXT_PORT3=4,
	RTK_RG_MAC_EXT_PORT4=5,
	RTK_RG_MAC_EXT_PORT5=6,
	RTK_RG_MAC_EXT_PORT_MAX,

#elif defined(CONFIG_RG_G3_SERIES)

	RTK_RG_MAC_EXT_CPU=0,
	RTK_RG_MAC_EXT_PORT0=1,		// wlan0_root
	RTK_RG_MAC_EXT_PORT1=2,		// wlan0_vap0
	RTK_RG_MAC_EXT_PORT2=3,		// wlan0_vap1
	RTK_RG_MAC_EXT_PORT3=4,		// wlan0_vap2
	RTK_RG_MAC_EXT_PORT4=5,		// wlan0_vap3
	RTK_RG_MAC_EXT_PORT5=6,		// others

	RTK_RG_MAC_EXT_PORT_WLAN0_ROOT=RTK_RG_MAC_EXT_PORT0,	// 11ac root
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP0=RTK_RG_MAC_EXT_PORT1,	// 11ac vap0
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP1=RTK_RG_MAC_EXT_PORT2,	// 11ac vap1
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP2=RTK_RG_MAC_EXT_PORT3,	// 11ac vap2
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP3=RTK_RG_MAC_EXT_PORT4,	// 11ac vap3
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP4,							// 11ac vap4
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP5,							// 11ac vap5
	RTK_RG_MAC_EXT_PORT_WLAN0_VAP6,							// 11ac vap6
#endif
	RTK_RG_MAC_EXT_PORT_WLAN1_ROOT,							// 11n root
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP0,							// 11n vap0
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP1,							// 11n vap1
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP2,							// 11n vap2
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP3,							// 11n vap3
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP4,							// 11n vap4
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP5,							// 11n vap5
	RTK_RG_MAC_EXT_PORT_WLAN1_VAP6,							// 11n vap6
#endif
	RTK_RG_MAC_EXT_PORT_MAX,								// 17

#endif

} rtk_rg_mac_ext_port_idx_t;

//#if defined(CONFIG_RG_FLOW_BASED_PLATFORM) && defined(CONFIG_MASTER_WLAN0_ENABLE) && defined(CONFIG_RG_FLOW_NEW_WIFI_MODE)
#if defined(CONFIG_RG_G3_SERIES)
#define RTK_RG_MAC_EXT_PORT_WIFI_ACC_MAX 8	// root(1) + vap(7)
#else
#define RTK_RG_MAC_EXT_PORT_WIFI_ACC_MAX RTK_RG_MAC_EXT_PORT4
#endif
//#endif

typedef enum rtk_rg_port_idx_e
{
#if defined(CONFIG_RG_RTL9600_SERIES) || defined(CONFIG_RTL9601B_SERIES)

	RTK_RG_PORT0=0,
	RTK_RG_PORT1,
	RTK_RG_PORT2,
	RTK_RG_PORT3,
	RTK_RG_PORT_PON,
	RTK_RG_PORT_RGMII,
	RTK_RG_PORT_CPU,
	RTK_RG_EXT_PORT0=7,
	RTK_RG_EXT_PORT1,
	RTK_RG_EXT_PORT2,
	RTK_RG_EXT_PORT3,
	RTK_RG_EXT_PORT4,
	RTK_RG_PORT_MAX,

#elif defined(CONFIG_RG_RTL9602C_SERIES)

	RTK_RG_PORT0=0,
	RTK_RG_PORT1,
	RTK_RG_PORT_PON,
	RTK_RG_PORT_CPU,
	RTK_RG_EXT_PORT0=4,
	RTK_RG_EXT_PORT1,
	RTK_RG_EXT_PORT2,
	RTK_RG_EXT_PORT3,
	RTK_RG_EXT_PORT4,
	RTK_RG_EXT_PORT5,
	RTK_RG_PORT_MAX,

#elif defined(CONFIG_RG_RTL9607C_SERIES)

	RTK_RG_PORT0=0,
	RTK_RG_PORT1,
	RTK_RG_PORT2,
	RTK_RG_PORT3,
	RTK_RG_PORT4,
	RTK_RG_PORT_PON=5,
	RTK_RG_PORT_iNIC,
	RTK_RG_PORT_SLAVECPU=7,
	RTK_RG_PORT_RGMII,
	RTK_RG_PORT_MASTERCPU_CORE0=9,
	RTK_RG_PORT_MASTERCPU_CORE1=10,
	RTK_RG_EXT_PORT0=11,	// MAC9
	RTK_RG_EXT_PORT1,
	RTK_RG_EXT_PORT2,
	RTK_RG_EXT_PORT3,
	RTK_RG_EXT_PORT4,
	RTK_RG_EXT_PORT5,
	RTK_RG_MAC10_EXT_PORT0=17,
	RTK_RG_MAC10_EXT_PORT1,
	RTK_RG_MAC10_EXT_PORT2,
	RTK_RG_MAC10_EXT_PORT3,
	RTK_RG_MAC10_EXT_PORT4,
	RTK_RG_MAC10_EXT_PORT5,
	RTK_RG_MAC7_EXT_PORT0=23,
	RTK_RG_MAC7_EXT_PORT1,
	RTK_RG_MAC7_EXT_PORT2,
	RTK_RG_MAC7_EXT_PORT3,
	RTK_RG_MAC7_EXT_PORT4,
	RTK_RG_MAC7_EXT_PORT5,
	RTK_RG_PORT_MAX=29,

#elif defined(CONFIG_RG_RTL9603CVD_SERIES)

	RTK_RG_PORT0=0,
	RTK_RG_PORT1,
	RTK_RG_PORT2,
	RTK_RG_PORT3,
	RTK_RG_PORT_PON=4,
	RTK_RG_PORT_CPU,
	RTK_RG_EXT_PORT0=6,
	RTK_RG_EXT_PORT1,
	RTK_RG_EXT_PORT2,
	RTK_RG_EXT_PORT3,
	RTK_RG_EXT_PORT4,
	RTK_RG_EXT_PORT5,
	RTK_RG_PORT_MAX,

#elif defined(CONFIG_RG_G3_SERIES)

	RTK_RG_PORT0=0,
	RTK_RG_PORT1=1,
	RTK_RG_PORT2=2,
	RTK_RG_PORT3=3,
#if defined(CONFIG_ARCH_CORTINA_G3HGU)
	RTK_RG_PORT4=4,
	RTK_RG_PORT5=5,
	RTK_RG_PORT6=6,
#if defined(CONFIG_RG_G3_WAN_PORT_INDEX)
	RTK_RG_PORT_PON=CONFIG_RG_G3_WAN_PORT_INDEX,
#else
	RTK_RG_PORT_PON=7,
#endif
#else
	RTK_RG_PORT_PON=7,
#endif
	RTK_RG_PORT_CPU=0x10,
	RTK_RG_PORT_CPU_WLAN0_ROOT=0x12,
	RTK_RG_PORT_CPU_WLAN0_VAP0=0x13,
	RTK_RG_PORT_CPU_WLAN0_VAP1=0x14,
	RTK_RG_PORT_CPU_WLAN0_VAP2=0x15,
	RTK_RG_PORT_CPU_WLAN0_VAP3=0x16,
	RTK_RG_PORT_CPU_WLAN1_AND_OTHERS=0x17,
	RTK_RG_EXT_PORT0=0x18,	// virtual port for master wifi
	RTK_RG_EXT_PORT1=0x19,	// virtual port for slave wifi
	RTK_RG_EXT_PORT2=0x1a,	// for wwan(vxd)
	RTK_RG_EXT_PORT3=0x1b,	// for wwan(vxd)
	RTK_RG_PORT_MAX,

#endif
} rtk_rg_port_idx_t;

#define RTK_RG_PORT_WLAN_OF_MASTER_CPU RTK_RG_EXT_PORT0
#define RTK_RG_PORT_WLAN_OF_SLAVE_CPU RTK_RG_EXT_PORT1

#endif
