#ifndef _RTK_RG_WLAN_DEFINE_H_
#define _RTK_RG_WLAN_DEFINE_H_

#ifdef __KERNEL__
#include <linux/netdevice.h>
#include <linux/kernel.h>
#endif
#include <rtk_rg_error.h>

#if defined(CONFIG_WLAN_MBSSID_NUM)
#if (CONFIG_WLAN_MBSSID_NUM!=4) && (CONFIG_WLAN_MBSSID_NUM!=7)
#error "[WARNING] CONFIG_WLAN_MBSSID_NUM(vap number of wlan0/wlan1) is neither 4 nor 7"
#endif
#define RG_WLAN_VAP_NUM CONFIG_WLAN_MBSSID_NUM
#else
#define RG_WLAN_VAP_NUM 4
#endif

#if defined(CONFIG_RTL_WDS_SUPPORT)
#define RG_WLAN_WDS_NUM 8
#else
#ifdef CONFIG_RTL_MESH_SUPPORT
#define RG_WLAN_WDS_NUM 1		//occupied same index with wds 7th device
#else
#define RG_WLAN_WDS_NUM 0
#endif
#endif

#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
#define WLAN_DEVICE_NUM		(1+RG_WLAN_VAP_NUM+RG_WLAN_WDS_NUM+1)	//root(1)+vap(RG_WLAN_VAP_NUM)+wds_and_or_mesh(RG_WLAN_WDS_NUM)+vxd(1), support dualband at one cpu
#else
#define WLAN_DEVICE_NUM		(1+RG_WLAN_VAP_NUM+RG_WLAN_WDS_NUM)	//root(1)+vap(RG_WLAN_VAP_NUM)+wds_and_or_mesh(RG_WLAN_WDS_NUM), support dualband at one cpu
#endif

#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)	//1 vap num is 7
#if defined(CONFIG_RTL_WDS_SUPPORT) && defined(CONFIG_RTL_REPEATER_MODE_SUPPORT)
#error "Number of bits of wlan device mask is overflow"
#endif
#define RTK_RG_WLAN0_USED_DEVICE_MASK ((1<<RG_RET_MBSSID_MASTER_ROOT_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP0_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP1_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP2_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP3_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP4_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP5_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP6_INTF))
#define RTK_RG_WLAN1_USED_DEVICE_MASK ((1<<RG_RET_MBSSID_SLAVE_ROOT_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP0_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP1_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP2_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP3_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP4_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP5_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP6_INTF))
#else	//1  vap num is 4
#define RTK_RG_WLAN0_USED_DEVICE_MASK ((1<<RG_RET_MBSSID_MASTER_ROOT_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP0_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP1_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP2_INTF) | (1<<RG_RET_MBSSID_MASTER_VAP3_INTF))
#define RTK_RG_WLAN1_USED_DEVICE_MASK ((1<<RG_RET_MBSSID_SLAVE_ROOT_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP0_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP1_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP2_INTF) | (1<<RG_RET_MBSSID_SLAVE_VAP3_INTF))
#endif	// end defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#define MAX_WLAN_DEVICE_NUM	(WLAN_DEVICE_NUM<<1)

typedef enum rtk_rg_mbssidDev_e
{
	RG_RET_MBSSID_NOT_FOUND			= -1,
	RG_RET_MBSSID_MASTER_ROOT_INTF	=  0,
	RG_RET_MBSSID_MASTER_VAP0_INTF,
	RG_RET_MBSSID_MASTER_VAP1_INTF,
	RG_RET_MBSSID_MASTER_VAP2_INTF,
	RG_RET_MBSSID_MASTER_VAP3_INTF,
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
	RG_RET_MBSSID_MASTER_VAP4_INTF,
	RG_RET_MBSSID_MASTER_VAP5_INTF,
	RG_RET_MBSSID_MASTER_VAP6_INTF,
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
	RG_RET_MBSSID_MASTER_WDS0_INTF,
	RG_RET_MBSSID_MASTER_WDS1_INTF,
	RG_RET_MBSSID_MASTER_WDS2_INTF,
	RG_RET_MBSSID_MASTER_WDS3_INTF,
	RG_RET_MBSSID_MASTER_WDS4_INTF,
	RG_RET_MBSSID_MASTER_WDS5_INTF,
	RG_RET_MBSSID_MASTER_WDS6_INTF,
#ifdef CONFIG_RTL_MESH_SUPPORT
	RG_RET_MBSSID_MASTER_MESH_INTF,
#else	// not CONFIG_RTL_MESH_SUPPORT
	RG_RET_MBSSID_MASTER_WDS7_INTF,
#endif	// end CONFIG_RTL_MESH_SUPPORT
#else	// not CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_MESH_SUPPORT
	RG_RET_MBSSID_MASTER_MESH_INTF,
#endif	// end CONFIG_RTL_MESH_SUPPORT
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
	RG_RET_MBSSID_MASTER_CLIENT_INTF,
#endif
	RG_RET_MBSSID_SLAVE_ROOT_INTF	= WLAN_DEVICE_NUM,
	RG_RET_MBSSID_SLAVE_VAP0_INTF,
	RG_RET_MBSSID_SLAVE_VAP1_INTF,
	RG_RET_MBSSID_SLAVE_VAP2_INTF,
	RG_RET_MBSSID_SLAVE_VAP3_INTF,
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
	RG_RET_MBSSID_SLAVE_VAP4_INTF,
	RG_RET_MBSSID_SLAVE_VAP5_INTF,
	RG_RET_MBSSID_SLAVE_VAP6_INTF,
#endif
#if defined(CONFIG_RTL_WDS_SUPPORT)
	RG_RET_MBSSID_SLAVE_WDS0_INTF,
	RG_RET_MBSSID_SLAVE_WDS1_INTF,
	RG_RET_MBSSID_SLAVE_WDS2_INTF,
	RG_RET_MBSSID_SLAVE_WDS3_INTF,
	RG_RET_MBSSID_SLAVE_WDS4_INTF,
	RG_RET_MBSSID_SLAVE_WDS5_INTF,
	RG_RET_MBSSID_SLAVE_WDS6_INTF,
	RG_RET_MBSSID_SLAVE_WDS7_INTF,
#endif	// end CONFIG_RTL_WDS_SUPPORT
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
	RG_RET_MBSSID_SLAVE_CLIENT_INTF,
#endif
	RG_RET_MBSSID_FLOOD_ALL_INTF	= 100,

}rtk_rg_mbssidDev_t;

#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
#define RG_RET_MBSSID_MASTER_LAST_INTF RG_RET_MBSSID_MASTER_CLIENT_INTF
#define RG_RET_MBSSID_SLAVE_LAST_INTF RG_RET_MBSSID_SLAVE_CLIENT_INTF
#else
#ifdef CONFIG_RTL_MESH_SUPPORT
#define RG_RET_MBSSID_MASTER_LAST_INTF RG_RET_MBSSID_MASTER_MESH_INTF
#else	// not CONFIG_RTL_MESH_SUPPORT
#if defined(CONFIG_RTL_WDS_SUPPORT)
#define RG_RET_MBSSID_MASTER_LAST_INTF RG_RET_MBSSID_MASTER_WDS7_INTF
#else	// not CONFIG_RTL_WDS_SUPPORT
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#define RG_RET_MBSSID_MASTER_LAST_INTF RG_RET_MBSSID_MASTER_VAP6_INTF
#else	// not defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#define RG_RET_MBSSID_MASTER_LAST_INTF RG_RET_MBSSID_MASTER_VAP3_INTF
#endif	// end defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#endif	// end CONFIG_RTL_WDS_SUPPORT
#endif	// end CONFIG_RTL_MESH_SUPPORT

#if defined(CONFIG_RTL_WDS_SUPPORT)
#define RG_RET_MBSSID_SLAVE_LAST_INTF RG_RET_MBSSID_SLAVE_WDS7_INTF
#else	// not CONFIG_RTL_WDS_SUPPORT
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#define RG_RET_MBSSID_SLAVE_LAST_INTF RG_RET_MBSSID_SLAVE_VAP6_INTF
#else	// not defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#define RG_RET_MBSSID_SLAVE_LAST_INTF RG_RET_MBSSID_SLAVE_VAP3_INTF
#endif  // end defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#endif	// end CONFIG_RTL_WDS_SUPPORT
#endif

#if defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION) && !defined(CONFIG_ARCH_LUNA_SLAVE)
// wlan0
extern struct net_device *wlan_root_netdev;
extern struct net_device *wlan_vap_netdev[RG_WLAN_VAP_NUM];
#if defined(CONFIG_RTL_WDS_SUPPORT)
extern struct net_device *wlan_wds_netdev[8];
#endif
#ifdef CONFIG_RTL_MESH_SUPPORT
extern struct net_device *wlan_mesh_netdev;
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
extern struct net_device *wlan_vxd_netdev;
#endif
// wlan1
extern struct net_device *wlan1_root_netdev;
extern struct net_device *wlan1_vap_netdev[RG_WLAN_VAP_NUM];
#if defined(CONFIG_RTL_WDS_SUPPORT)
extern struct net_device *wlan1_wds_netdev[8];
#endif
#ifdef CONFIG_RTL_REPEATER_MODE_SUPPORT
extern struct net_device *wlan1_vxd_netdev;
#endif

/* Function Name:
 *      rtk_rg_wlan_netDevice_set
 * Description:
 *      Set address of net device of wlan
 * Input:
 *      wlanDevIdx	- wlan device index(refer to rtk_rg_mbssidDev_t)
 *      pDev		- address of net device of wlan
 * Output:
 *      None
 * Return:
 *      RT_ERR_RG_OK
 *      RT_ERR_RG_INDEX_OUT_OF_RANGE
 *      RT_ERR_RG_NULL_POINTER
 */
rtk_rg_err_code_t rtk_rg_wlan_netDevice_set(rtk_rg_mbssidDev_t wlanDevIdx, struct net_device *pDev);
void rtk_rg_wlan_netDevice_show(void);
#endif	// end defined(CONFIG_RG_WLAN_HWNAT_ACCELERATION) && !defined(CONFIG_ARCH_LUNA_SLAVE)

#endif //end of #ifndef _RTK_RG_WLAN_DEFINE_H_
