/*
 * Copyright (C) 2018 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: $
 * $Date: $
 *
 * Purpose : Definition of CLS API
 *
 * Feature : The file includes the following modules and sub-modules
 *           (1) CLS
 */


#ifndef __DAL_RT_RTL9607F_CLS_H__
#define __DAL_RT_RTL9607F_CLS_H__


/*
 * Include Files
 */
#include <common/rt_type.h>
#include <rtk/rt/rt_cls.h>
#include <rtk/rt/rt_ponmisc.h>

/*
 * Symbol Definition
 */
/*
 * Data Declaration
 */


/*
 * Function Declaration
 */
 
/* Function Name:
 *      dal_rt_rtl9607f_cls_init
 * Description:
 *      add classification rule
 * Input:
 *      pClsRule   - classification rule
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 * Note:
 */

extern int32 dal_rt_rtl9607f_cls_init(void);


/* Function Name:
 *      dal_rt_rtl9607f_cls_veip_port_rule_set
 * Description:
 *      Enable/Disable VEIP port default rule
 * Input:
 *      port   - Port index
 *      state  - VEIP port state
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_PORT_ID      - invalid port id
 *      RT_ERR_FAILED       - Failed
 * Note:
 */

extern int32 dal_rt_rtl9607f_cls_veipPortRule_set(rtk_port_t port, rtk_enable_t state);

/* Function Name:
 *      dal_rt_rtl9607f_cls_rule_add
 * Description:
 *      add classification rule
 * Input:
 *      pClsRule   - classification rule
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 * Note:
 */

extern int32 dal_rt_rtl9607f_cls_rule_add(rt_cls_rule_t *pClsRule);

/* Function Name:
 *      dal_rt_rtl9607f_cls_rule_delete
 * Description:
 *      delete classification rule
 * Input:
 *      index   - classification rule index
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 * Note:
 */

extern int32 dal_rt_rtl9607f_cls_rule_delete(uint32 ruleIndex);

/* Function Name:
 *      dal_rt_rtl9607f_cls_pon_sid_set
 * Description:
 *      Set pon sid info
 * Input:
 *      sid     - Stream ID
 *      sidInfo - Stream ID information
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 * Note:
 */

extern int32 dal_rt_rtl9607f_cls_pon_sid_set(uint16 sid,rt_ponmisc_sidInfo_t sidInfo);

/* Function Name:
 *      dal_rt_rtl9607f_cls_fwdPort_set
 * Description:
 *      Set veip port default forward port
 * Input:
 *      port    - port ID
 *      fwdPort - default forward port in VEIP mode
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 * Note:
 */

extern int32 dal_rt_rtl9607f_cls_fwdPort_set(rt_port_t port, rt_port_t fwdPort);

#endif /* __DAL_RT_RTL9607F_CLS_H__ */
