#include <stdio.h>
#include <string.h>
#include <common/rt_type.h>
#include <common/rt_error.h>
#include <common/util/rt_util.h>
#include <diag_util.h>
#include <diag_str.h>
#include <parser/cparser_priv.h>
#include <rtk/rt/rt_trap.h>

/*
 * rt_trap init
 */
cparser_result_t
cparser_cmd_rt_trap_init(
    cparser_context_t *context)
{
    int32 ret = RT_ERR_FAILED;
    DIAG_UTIL_PARAM_CHK();

    DIAG_UTIL_ERR_CHK(rt_trap_init(), ret);

    return CPARSER_OK;
}    /* end of cparser_cmd_rt_trap_init */

/*
 * rt_trap get oam state
 */
cparser_result_t 
cparser_cmd_rt_trap_get_oam_state(
    cparser_context_t *context)
{
    int32 ret = RT_ERR_FAILED;
    rt_action_t action;
    rt_enable_t state;

    DIAG_UTIL_PARAM_CHK();

    DIAG_UTIL_ERR_CHK(rt_trap_oamPduAction_get(&action), ret);

    if(action == ACTION_TRAP2CPU)
        state = ENABLED;
    else
        state = DISABLED;

    diag_util_printf("\n OAM Trap : %s\n", diagStr_enable[state]);

    return CPARSER_OK;
}    /* end of cparser_cmd_rt_trap_get_oam_state */

/*
 * rt_trap set oam state ( disable | enable )
 */
cparser_result_t 
cparser_cmd_rt_trap_set_oam_state_disable_enable(
    cparser_context_t *context)
{
    int32 ret = RT_ERR_FAILED;
    rt_action_t action;

    DIAG_UTIL_PARAM_CHK();

    if('e' == TOKEN_CHAR(4, 0))
        action = ACTION_TRAP2CPU;
    else
        action = ACTION_FORWARD;

    DIAG_UTIL_ERR_CHK(rt_trap_oamPduAction_set(action), ret);

    return CPARSER_OK;
}    /* end of cparser_cmd_rt_trap_set_oam_state_disable_enable */

/*
 * rt_trap get omci state
 */
cparser_result_t 
cparser_cmd_rt_trap_get_omci_state(
    cparser_context_t *context)
{
    int32 ret = RT_ERR_FAILED;
    rt_action_t action;
    rt_enable_t state;

    DIAG_UTIL_PARAM_CHK();

    DIAG_UTIL_ERR_CHK(rt_trap_omciAction_get(&action), ret);

    if(action == ACTION_TRAP2CPU)
        state = ENABLED;
    else
        state = DISABLED;

    diag_util_printf("\n OMCI Trap : %s\n", diagStr_enable[state]);

    return CPARSER_OK;
}    /* end of cparser_cmd_rt_trap_get_omci_state */

/*
 * rt_trap set omci state ( disable | enable )
 */
cparser_result_t 
cparser_cmd_rt_trap_set_omci_state_disable_enable(cparser_context_t *context)
{
    int32 ret = RT_ERR_FAILED;
    rt_action_t action;

    DIAG_UTIL_PARAM_CHK();

    if('e' == TOKEN_CHAR(4, 0))
        action = ACTION_TRAP2CPU;
    else
        action = ACTION_FORWARD;

    DIAG_UTIL_ERR_CHK(rt_trap_omciAction_set(action), ret);

    return CPARSER_OK;
}    /* end of cparser_cmd_rt_trap_set_omci_state_disable_enable */
