/* 
 * Copyright (C) 2014 Realtek Semiconductor Corp.
 * All Rights Reserved.
 * 
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 * 
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 * 
 */


#ifndef __MIB_SIPAGENTCONFIGDATA_TABLE_H__
#define __MIB_SIPAGENTCONFIGDATA_TABLE_H__

/* Table SIPAgentConfigData attribute for STRING type define each entry length */
#define MIB_TABLE_SOFTSWITCH_LEN (4)

/* Table SIPAgentConfigData attribute index */
#define MIB_TABLE_SIPAGENTCONFIGDATA_ATTR_NUM (15)
#define MIB_TABLE_SIPAGENTCONFIGDATA_ENTITYID_INDEX ((MIB_ATTR_INDEX)1)
#define MIB_TABLE_SIPAGENTCONFIGDATA_PROXYSERVERADDRESSPOINTER_INDEX ((MIB_ATTR_INDEX)2)
#define MIB_TABLE_SIPAGENTCONFIGDATA_OUTBOUNDPROXYADDRESSPOINTER_INDEX ((MIB_ATTR_INDEX)3)
#define MIB_TABLE_SIPAGENTCONFIGDATA_PRIMARYSIPDNS_INDEX ((MIB_ATTR_INDEX)4)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SECONDARYSIPDNS_INDEX ((MIB_ATTR_INDEX)5)
#define MIB_TABLE_SIPAGENTCONFIGDATA_TCPUDPPOINTER_INDEX ((MIB_ATTR_INDEX)6)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SIPREGEXPTIME_INDEX ((MIB_ATTR_INDEX)7)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SIPREREGHEADSTARTTIME_INDEX ((MIB_ATTR_INDEX)8)
#define MIB_TABLE_SIPAGENTCONFIGDATA_HOSTPARTURI_INDEX ((MIB_ATTR_INDEX)9)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SIPSTATUS_INDEX ((MIB_ATTR_INDEX)10)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SIPREGISTRAR_INDEX ((MIB_ATTR_INDEX)11)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SOFTSWITCH_INDEX ((MIB_ATTR_INDEX)12)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SIPOPTIONTRANSMITCONTROL_INDEX ((MIB_ATTR_INDEX)13)
#define MIB_TABLE_SIPAGENTCONFIGDATA_SIPURIFORMAT_INDEX ((MIB_ATTR_INDEX)14)
#define MIB_TABLE_SIPAGENTCONFIGDATA_REDUNDANTSIPAGENTPOINTER_INDEX ((MIB_ATTR_INDEX)15)

/* Table SIPAgentConfigData attribute len, only string attrubutes have length definition */
typedef struct {
	UINT16   EntityId;
	UINT16   ProxyServerAddressPointer;
	UINT16   OutboundProxyAddressPointer;
	UINT32   PrimarySIPDNS;
	UINT32   SecondarySIPDNS;
	UINT16   TCPUDPPointer;
	UINT32   SIPRegExpTime;
	UINT32   SIPReregHeadStartTime;
	UINT16   HostPartURI;
	UINT8    SIPStatus;
	UINT16   SIPRegistrar;
	CHAR     Softswitch[MIB_TABLE_SOFTSWITCH_LEN+1];
	UINT8    SIPOptionTransmitControl;
	UINT8    SIPURIFormat;
	UINT16   RedundantSIPAgentPointer;
} __attribute__((packed)) MIB_TABLE_SIPAGENTCONFIGDATA_T;

#endif /* __MIB_SIPAGENTCONFIGDATA_TABLE_H__ */
