/*
 * Copyright (C) 2014 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 */


#ifndef __MIB_VOIPAPPLICATIONSERVICEPROFILE_TABLE_H__
#define __MIB_VOIPAPPLICATIONSERVICEPROFILE_TABLE_H__

/* Table VoIPApplicationServiceProfile attribute for STRING type define each entry length */

/* Table VoIPApplicationServiceProfile attribute index */
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_ATTR_NUM (9)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_ENTITYID_INDEX ((MIB_ATTR_INDEX)1)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_CIDFEATURES_INDEX ((MIB_ATTR_INDEX)2)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_CALLWAITINGFEATURES_INDEX ((MIB_ATTR_INDEX)3)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_CALLPROGRESSORTRANSFERFEATURES_INDEX ((MIB_ATTR_INDEX)4)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_CALLPRESENTATIONFEATURES_INDEX ((MIB_ATTR_INDEX)5)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_DIRECTCONNECTFEATURE_INDEX ((MIB_ATTR_INDEX)6)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_DIRECTCONNECTURIPOINTER_INDEX ((MIB_ATTR_INDEX)7)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_BRIDGEDLINEAGENTURIPOINTER_INDEX ((MIB_ATTR_INDEX)8)
#define MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_CONFERENCEFACTORYURIPOINTER_INDEX ((MIB_ATTR_INDEX)9)

typedef enum {
    VOIP_APP_SVC_PROFILE_CID_FEATURE_CALLING_NUMBER	                    = (1 << 0),
    VOIP_APP_SVC_PROFILE_CID_FEATURE_CALLING_NAME	                    = (1 << 1),
    VOIP_APP_SVC_PROFILE_CID_FEATURE_CID_BLOCKING	                    = (1 << 2),
    VOIP_APP_SVC_PROFILE_CID_FEATURE_CID_NUMBER		                    = (1 << 3),
    VOIP_APP_SVC_PROFILE_CID_FEATURE_CID_NAME		                    = (1 << 4),
    VOIP_APP_SVC_PROFILE_CID_FEATURE_ACR                                = (1 << 5),
} voip_app_svc_profile_cid_feature_t;

typedef enum {
    VOIP_APP_SVC_PROFILE_CALL_WAITING_FEATURE_CALL_WAITING          	= (1 << 0),
    VOIP_APP_SVC_PROFILE_CALL_WAITING_FEATURE_CALLER_ID_ANNOUNCEMENT	= (1 << 1),
} voip_app_svc_profile_call_waiting_feature_t;

typedef enum {
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_3WAY          	= (1 << 0),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_CALL_TRANSFER	= (1 << 1),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_CALL_HOLD	    = (1 << 2),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_CALL_PARK	    = (1 << 3),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_DONOT_DISTURB	= (1 << 4),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_EMERGENCY_CALL   = (1 << 5),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_EMERGENCY_HOLD   = (1 << 6),
    VOIP_APP_SVC_PROFILE_CALL_PROG_OR_TRANSFER_FEATURE_6WAY             = (1 << 7),
} voip_app_svc_profile_call_prog_or_transfer_feature_t;

typedef enum {
    VOIP_APP_SVC_PROFILE_CALL_PRESENTATION_FEATURE_MSG_WAITING_IND_SPLASH_RING      = (1 << 0),
    VOIP_APP_SVC_PROFILE_CALL_PRESENTATION_FEATURE_MSG_WAITING_IND_SPECIAL_DIAL_TONE= (1 << 1),
    VOIP_APP_SVC_PROFILE_CALL_PRESENTATION_FEATURE_MSG_WAITING_IND_VISUAL_IND       = (1 << 2),
    VOIP_APP_SVC_PROFILE_CALL_PRESENTATION_FEATURE_CALL_FWDING_IND                  = (1 << 3),
} voip_app_svc_profile_call_presentation_feature_t;

typedef enum {
    VOIP_APP_SVC_PROFILE_DIRECT_CONNECT_FEATURE_ENABLED          	    = (1 << 0),
    VOIP_APP_SVC_PROFILE_DIRECT_CONNECT_FEATURE_DIAL_TONE_DELAY_OPT	    = (1 << 1),
} voip_app_svc_profile_direct_connect_feature_t;

/* Table VoIPApplicationServiceProfile attribute len, only string attrubutes have length definition */
typedef struct {
	UINT16   EntityId;
	UINT8    CIDFeatures;
	UINT8    CallWaitingFeatures;
	UINT16   CallProgressOrTransferFeatures;
	UINT16   CallPresentationFeatures;
	UINT8    DirectConnectFeature;
	UINT16   DirectConnectURIPointer;
	UINT16   BridgedLineAgentURIPointer;
	UINT16   ConferenceFactoryURIPointer;
} __attribute__((packed)) MIB_TABLE_VOIPAPPLICATIONSERVICEPROFILE_T;

#endif /* __MIB_VOIPAPPLICATIONSERVICEPROFILE_TABLE_H__ */
