/* 
 * Copyright (C) 2014 Realtek Semiconductor Corp.
 * All Rights Reserved.
 * 
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 * 
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 * 
 */


#ifndef __MIB_VOIPFEATUREACCESSCODES_TABLE_H__
#define __MIB_VOIPFEATUREACCESSCODES_TABLE_H__

/* Table VoIPFeatureAccessCodes attribute for STRING type define each entry length */
#define MIB_TABLE_CANCELCALLWAITING_LEN (5)
#define MIB_TABLE_CANCELHOLD_LEN (5)
#define MIB_TABLE_CANCELPARK_LEN (5)
#define MIB_TABLE_CANCELIDACTIVATE_LEN (5)
#define MIB_TABLE_CANCELIDDEACTIVATE_LEN (5)
#define MIB_TABLE_DONOTDISTURBACTIVATE_LEN (5)
#define MIB_TABLE_DONOTDISTURBDEACTIVATE_LEN (5)
#define MIB_TABLE_DONOTDISTURBPINCHANGE_LEN (5)
#define MIB_TABLE_EMERGENCYSERVICENUMBER_LEN (5)
#define MIB_TABLE_INTERCOMSERVICE_LEN (5)
#define MIB_TABLE_UNATTENDEDBLINDCALLTRANSFER_LEN (5)
#define MIB_TABLE_ATTENDEDCALLTRANSFER_LEN (5)

/* Table VoIPFeatureAccessCodes attribute index */
#define MIB_TABLE_VOIPFEATUREACCESSCODES_ATTR_NUM (13)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_ENTITYID_INDEX ((MIB_ATTR_INDEX)1)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_CANCELCALLWAITING_INDEX ((MIB_ATTR_INDEX)2)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_CANCELHOLD_INDEX ((MIB_ATTR_INDEX)3)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_CANCELPARK_INDEX ((MIB_ATTR_INDEX)4)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_CANCELIDACTIVATE_INDEX ((MIB_ATTR_INDEX)5)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_CANCELIDDEACTIVATE_INDEX ((MIB_ATTR_INDEX)6)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_DONOTDISTURBACTIVATE_INDEX ((MIB_ATTR_INDEX)7)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_DONOTDISTURBDEACTIVATE_INDEX ((MIB_ATTR_INDEX)8)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_DONOTDISTURBPINCHANGE_INDEX ((MIB_ATTR_INDEX)9)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_EMERGENCYSERVICENUMBER_INDEX ((MIB_ATTR_INDEX)10)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_INTERCOMSERVICE_INDEX ((MIB_ATTR_INDEX)11)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_UNATTENDEDBLINDCALLTRANSFER_INDEX ((MIB_ATTR_INDEX)12)
#define MIB_TABLE_VOIPFEATUREACCESSCODES_ATTENDEDCALLTRANSFER_INDEX ((MIB_ATTR_INDEX)13)

/* Table VoIPFeatureAccessCodes attribute len, only string attrubutes have length definition */
typedef struct {
	UINT16   EntityId;
	CHAR     CancelCallWaiting[MIB_TABLE_CANCELCALLWAITING_LEN+1];
	CHAR     CancelHold[MIB_TABLE_CANCELHOLD_LEN+1];
	CHAR     CancelPark[MIB_TABLE_CANCELPARK_LEN+1];
	CHAR     CancelIDActivate[MIB_TABLE_CANCELIDACTIVATE_LEN+1];
	CHAR     CancelIDdeactivate[MIB_TABLE_CANCELIDDEACTIVATE_LEN+1];
	CHAR     DoNotDisturbActivate[MIB_TABLE_DONOTDISTURBACTIVATE_LEN+1];
	CHAR     DoNotDisturbDeactivate[MIB_TABLE_DONOTDISTURBDEACTIVATE_LEN+1];
	CHAR     DoNotDisturbPINChange[MIB_TABLE_DONOTDISTURBPINCHANGE_LEN+1];
	CHAR     EmergencyServiceNumber[MIB_TABLE_EMERGENCYSERVICENUMBER_LEN+1];
	CHAR     IntercomService[MIB_TABLE_INTERCOMSERVICE_LEN+1];
	CHAR     UnattendedBlindCallTransfer[MIB_TABLE_UNATTENDEDBLINDCALLTRANSFER_LEN+1];
	CHAR     AttendedCallTransfer[MIB_TABLE_ATTENDEDCALLTRANSFER_LEN+1];
} __attribute__((packed)) MIB_TABLE_VOIPFEATUREACCESSCODES_T;

#endif /* __MIB_VOIPFEATUREACCESSCODES_TABLE_H__ */
