/*
 * Copyright (C) 2018 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 */

/*
 * Include Files
 */
#include <common/debug/rt_log.h>
#include <dal/dal_mapper.h>
#include <dal/dal_common.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_mapper.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_acl.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_epon.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_mirror.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_stp.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_ponmac.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_switch.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_stat.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_svlan.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_vlan.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_trap.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_intr.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_classify.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_port.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_pbo.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_sec.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_rldp.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_rate.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_oam.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_qos.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_gpio.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_i2c.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_led.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_l2.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_cpu.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_time.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_ppstod.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_gpon.h>

#if 0
#include <dal/rtl9603cvd/dal_rtl9603cvd_mdio.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_dot1x.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_l34.h>
#include <dal/rtl9603cvd/dal_rtl9603cvd_trunk.h>
#endif




/*
 * Symbol Definition
 */
static int32 dal_rtl9603cvd_fakeInit(void);


/*
 * Data Declaration
 */
static dal_mapper_t dal_rtl9603cvd_mapper =
{
    RTL9603CVD_CHIP_ID,
    ._init = dal_rtl9603cvd_init,



    /* Switch */
    .switch_init = dal_rtl9603cvd_switch_init,
    .switch_phyPortId_get = dal_rtl9603cvd_switch_phyPortId_get,
    .switch_logicalPort_get = dal_rtl9603cvd_switch_logicalPort_get,
    .switch_port2PortMask_set = dal_rtl9603cvd_switch_port2PortMask_set,
    .switch_port2PortMask_clear = dal_rtl9603cvd_switch_port2PortMask_clear,
    .switch_portIdInMask_check = dal_rtl9603cvd_switch_portIdInMask_check,
    .switch_maxPktLenLinkSpeed_get = NULL,
    .switch_maxPktLenLinkSpeed_set = NULL,
    .switch_mgmtMacAddr_get = dal_rtl9603cvd_switch_mgmtMacAddr_get,
    .switch_mgmtMacAddr_set = dal_rtl9603cvd_switch_mgmtMacAddr_set,
    .switch_chip_reset = dal_rtl9603cvd_switch_chip_reset,
    .switch_version_get = dal_rtl9603cvd_switch_version_get,
    .switch_patch_info_get = NULL,
    .switch_csExtId_get = NULL,
    .switch_maxPktLenByPort_get = dal_rtl9603cvd_switch_maxPktLenByPort_get,
    .switch_maxPktLenByPort_set = dal_rtl9603cvd_switch_maxPktLenByPort_set,
    .switch_changeDuplex_get = dal_rtl9603cvd_switch_changeDuplex_get,
    .switch_changeDuplex_set = dal_rtl9603cvd_switch_changeDuplex_set,
    .switch_system_init = dal_rtl9603cvd_switch_system_init,
    .switch_thermal_get = dal_dal9603cvd_switch_thermal_get,


    /*sec*/
    .sec_init = dal_rtl9603cvd_sec_init,
    .sec_portAttackPreventState_get = dal_rtl9603cvd_sec_portAttackPreventState_get,
    .sec_portAttackPreventState_set = dal_rtl9603cvd_sec_portAttackPreventState_set,
    .sec_attackPrevent_get = dal_rtl9603cvd_sec_attackPrevent_get,
    .sec_attackPrevent_set = dal_rtl9603cvd_sec_attackPrevent_set,
    .sec_attackFloodThresh_get = dal_rtl9603cvd_sec_attackFloodThresh_get,
    .sec_attackFloodThresh_set = dal_rtl9603cvd_sec_attackFloodThresh_set,
    .sec_attackFloodThreshUnit_get = dal_rtl9603cvd_sec_attackFloodThreshUnit_get,
    .sec_attackFloodThreshUnit_set = dal_rtl9603cvd_sec_attackFloodThreshUnit_set,

    /* statistics */
    .stat_init                                  = dal_rtl9603cvd_stat_init,
    .stat_global_reset                          = dal_rtl9603cvd_stat_global_reset,
    .stat_port_reset                            = dal_rtl9603cvd_stat_port_reset,
    .stat_log_reset                             = dal_rtl9603cvd_stat_log_reset,
    .stat_hostCnt_reset                         = dal_rtl9603cvd_stat_hostCnt_reset,
    .stat_hostCnt_get                           = dal_rtl9603cvd_stat_hostCnt_get,
    .stat_hostState_get                         = dal_rtl9603cvd_stat_hostState_get,
    .stat_hostState_set                         = dal_rtl9603cvd_stat_hostState_set,
    .stat_rst_cnt_value_set                     = dal_rtl9603cvd_stat_rst_cnt_value_set,
    .stat_rst_cnt_value_get                     = dal_rtl9603cvd_stat_rst_cnt_value_get,
    .stat_global_get                            = dal_rtl9603cvd_stat_global_get,
    .stat_global_getAll                         = dal_rtl9603cvd_stat_global_getAll,
    .stat_port_get                              = dal_rtl9603cvd_stat_port_get,
    .stat_port_getAll                           = dal_rtl9603cvd_stat_port_getAll,
    .stat_log_get                               = dal_rtl9603cvd_stat_log_get,
    .stat_log_ctrl_set                          = dal_rtl9603cvd_stat_log_ctrl_set,
    .stat_log_ctrl_get                          = dal_rtl9603cvd_stat_log_ctrl_get,
    .stat_mib_cnt_mode_get                      = dal_rtl9603cvd_stat_mib_cnt_mode_get,
    .stat_mib_cnt_mode_set                      = dal_rtl9603cvd_stat_mib_cnt_mode_set,
    .stat_mib_latch_timer_get                   = dal_rtl9603cvd_stat_mib_latch_timer_get,
    .stat_mib_latch_timer_set                   = dal_rtl9603cvd_stat_mib_latch_timer_set,
    .stat_mib_sync_mode_get                     = dal_rtl9603cvd_stat_mib_sync_mode_get,
    .stat_mib_sync_mode_set                     = dal_rtl9603cvd_stat_mib_sync_mode_set,
    .stat_pktInfo_get                           = dal_rtl9603cvd_stat_pktInfo_get,

    /* Port */
    .port_init                                  = dal_rtl9603cvd_port_init,
    .port_link_get                              = dal_rtl9603cvd_port_link_get,
    .port_speedDuplex_get                       = dal_rtl9603cvd_port_speedDuplex_get,
    .port_flowctrl_get                          = dal_rtl9603cvd_port_flowctrl_get,
    .port_phyAutoNegoEnable_get                 = dal_rtl9603cvd_port_phyAutoNegoEnable_get,
    .port_phyAutoNegoEnable_set                 = dal_rtl9603cvd_port_phyAutoNegoEnable_set,
    .port_phyAutoNegoAbility_get                = dal_rtl9603cvd_port_phyAutoNegoAbility_get,
    .port_phyAutoNegoAbility_set                = dal_rtl9603cvd_port_phyAutoNegoAbility_set,
    .port_phyForceModeAbility_get               = dal_rtl9603cvd_port_phyForceModeAbility_get,
    .port_phyForceModeAbility_set               = dal_rtl9603cvd_port_phyForceModeAbility_set,
    .port_phyMasterSlave_get                    = dal_rtl9603cvd_port_phyMasterSlave_get,
    .port_phyMasterSlave_set                    = dal_rtl9603cvd_port_phyMasterSlave_set,
    .port_phyTestMode_get                       = dal_rtl9603cvd_port_phyTestMode_get,
    .port_phyTestMode_set                       = dal_rtl9603cvd_port_phyTestMode_set,
    .port_phyReg_get                            = dal_rtl9603cvd_port_phyReg_get,
    .port_phyReg_set                            = dal_rtl9603cvd_port_phyReg_set,
    .port_cpuPortId_get                         = dal_rtl9603cvd_port_cpuPortId_get,
    .port_isolation_get                         = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolation_set                         = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationExt_get                      = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationExt_set                      = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationL34_get                      = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationL34_set                      = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationExtL34_get                   = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationExtL34_set                   = (int32 (*)(rtk_port_t, rtk_portmask_t *, rtk_portmask_t *))dal_common_unavail,
    .port_isolationEntry_get                    = dal_rtl9603cvd_port_isolationEntry_get,
    .port_isolationEntry_set                    = dal_rtl9603cvd_port_isolationEntry_set,
    .port_isolationEntryExt_get                 = dal_rtl9603cvd_port_isolationEntryExt_get,
    .port_isolationEntryExt_set                 = dal_rtl9603cvd_port_isolationEntryExt_set,
    .port_isolationCtagPktConfig_get            = NULL,
    .port_isolationCtagPktConfig_set            = NULL,
    .port_isolationL34PktConfig_get             = NULL,
    .port_isolationL34PktConfig_set             = NULL,
    .port_isolationIpmcLeaky_get                = dal_rtl9603cvd_port_isolationIpmcLeaky_get,
    .port_isolationIpmcLeaky_set                = dal_rtl9603cvd_port_isolationIpmcLeaky_set,
    .port_isolationPortLeaky_get                = dal_rtl9603cvd_port_isolationPortLeaky_get,
    .port_isolationPortLeaky_set                = dal_rtl9603cvd_port_isolationPortLeaky_set,
    .port_isolationLeaky_get                    = dal_rtl9603cvd_port_isolationLeaky_get,
    .port_isolationLeaky_set                    = dal_rtl9603cvd_port_isolationLeaky_set,
    .port_macRemoteLoopbackEnable_get           = dal_rtl9603cvd_port_macRemoteLoopbackEnable_get,
    .port_macRemoteLoopbackEnable_set           = dal_rtl9603cvd_port_macRemoteLoopbackEnable_set,
    .port_macLocalLoopbackEnable_get            = dal_rtl9603cvd_port_macLocalLoopbackEnable_get,
    .port_macLocalLoopbackEnable_set            = dal_rtl9603cvd_port_macLocalLoopbackEnable_set,
    .port_adminEnable_get                       = dal_rtl9603cvd_port_adminEnable_get,
    .port_adminEnable_set                       = dal_rtl9603cvd_port_adminEnable_set,
    .port_specialCongest_get                    = dal_rtl9603cvd_port_specialCongest_get,
    .port_specialCongest_set                    = dal_rtl9603cvd_port_specialCongest_set,
    .port_specialCongestStatus_get              = dal_rtl9603cvd_port_specialCongestStatus_get,
    .port_specialCongestStatus_clear            = dal_rtl9603cvd_port_specialCongestStatus_clear,
    .port_greenEnable_get                       = dal_rtl9603cvd_port_greenEnable_get,
    .port_greenEnable_set                       = dal_rtl9603cvd_port_greenEnable_set,
    .port_phyCrossOverMode_get                  = dal_rtl9603cvd_port_phyCrossOverMode_get,
    .port_phyCrossOverMode_set                  = dal_rtl9603cvd_port_phyCrossOverMode_set,
    .port_phyPowerDown_set                      = dal_rtl9603cvd_port_phyPowerDown_set,
    .port_phyPowerDown_tryset                   = dal_rtl9603cvd_port_phyPowerDown_tryset,
    .port_phyPowerDown_get                      = dal_rtl9603cvd_port_phyPowerDown_get,
    .port_enhancedFid_get                       = (int32 (*)(rtk_port_t, rtk_efid_t *))dal_common_unavail,
    .port_enhancedFid_set                       = (int32 (*)(rtk_port_t, rtk_efid_t ))dal_common_unavail,
    .port_rtctResult_get                        = dal_rtl9603cvd_port_rtctResult_get,
    .port_rtct_start                            = dal_rtl9603cvd_port_rtct_start,
    .port_macForceAbility_set                   = dal_rtl9603cvd_port_macForceAbility_set,
    .port_macForceAbility_get                   = dal_rtl9603cvd_port_macForceAbility_get,
    .port_macForceAbilityState_set              = dal_rtl9603cvd_port_macForceAbilityState_set,
    .port_macForceAbilityState_get              = dal_rtl9603cvd_port_macForceAbilityState_get,
    .port_macExtMode_set                        = NULL,
    .port_macExtMode_get                        = NULL,
    .port_macExtRgmiiDelay_set                  = NULL,
    .port_macExtRgmiiDelay_get                  = NULL,
    .port_gigaLiteEnable_set                    = dal_rtl9603cvd_port_gigaLiteEnable_set,
    .port_gigaLiteEnable_get                    = dal_rtl9603cvd_port_gigaLiteEnable_get,
    .port_serdesMode_set                        = NULL,
    .port_serdesMode_get                        = NULL,
    .port_serdesNWay_set                        = NULL,
    .port_serdesNWay_get                        = NULL,
    .port_eeeEnable_get                         = dal_rtl9603cvd_port_eeeEnable_get,
    .port_eeeEnable_set                         = dal_rtl9603cvd_port_eeeEnable_set,

    /*oam*/
    .oam_init                                   = dal_rtl9603cvd_oam_init,
    .oam_parserAction_set                       = dal_rtl9603cvd_oam_parserAction_set,
    .oam_parserAction_get                       = dal_rtl9603cvd_oam_parserAction_get,
    .oam_multiplexerAction_set                  = dal_rtl9603cvd_oam_multiplexerAction_set,
    .oam_multiplexerAction_get                  = dal_rtl9603cvd_oam_multiplexerAction_get,

    /* Trap */
    .trap_init                                  = dal_rtl9603cvd_trap_init,
    .trap_reasonTrapToCpuPriority_get           = dal_rtl9603cvd_trap_reasonTrapToCpuPriority_get,
    .trap_reasonTrapToCpuPriority_set           = dal_rtl9603cvd_trap_reasonTrapToCpuPriority_set,
    .trap_igmpCtrlPkt2CpuEnable_get             = dal_rtl9603cvd_trap_igmpCtrlPkt2CpuEnable_get,
    .trap_igmpCtrlPkt2CpuEnable_set             = dal_rtl9603cvd_trap_igmpCtrlPkt2CpuEnable_set,
    .trap_mldCtrlPkt2CpuEnable_get              = dal_rtl9603cvd_trap_mldCtrlPkt2CpuEnable_get,
    .trap_mldCtrlPkt2CpuEnable_set              = dal_rtl9603cvd_trap_mldCtrlPkt2CpuEnable_set,
    .trap_portIgmpMldCtrlPktAction_get          = dal_rtl9603cvd_trap_portIgmpMldCtrlPktAction_get,
    .trap_portIgmpMldCtrlPktAction_set          = dal_rtl9603cvd_trap_portIgmpMldCtrlPktAction_set,
    .trap_l2McastPkt2CpuEnable_get              = dal_rtl9603cvd_trap_l2McastPkt2CpuEnable_get,
    .trap_l2McastPkt2CpuEnable_set              = dal_rtl9603cvd_trap_l2McastPkt2CpuEnable_set,
    .trap_ipMcastPkt2CpuEnable_get              = dal_rtl9603cvd_trap_ipMcastPkt2CpuEnable_get,
    .trap_ipMcastPkt2CpuEnable_set              = dal_rtl9603cvd_trap_ipMcastPkt2CpuEnable_set,
    .trap_rmaAction_get                         = dal_rtl9603cvd_trap_rmaAction_get,
    .trap_rmaAction_set                         = dal_rtl9603cvd_trap_rmaAction_set,
    .trap_rmaPri_get                            = dal_rtl9603cvd_trap_rmaPri_get,
    .trap_rmaPri_set                            = dal_rtl9603cvd_trap_rmaPri_set,
    .trap_portOamPduAction_get                  = dal_rtl9603cvd_trap_portOamPduAction_get,
    .trap_portOamPduAction_set                  = dal_rtl9603cvd_trap_portOamPduAction_set,
    .trap_oamPduPri_get                         = dal_rtl9603cvd_trap_oamPduPri_get,
    .trap_oamPduPri_set                         = dal_rtl9603cvd_trap_oamPduPri_set,
    .trap_uniTrapPriorityEnable_set             = dal_rtl9603cvd_trap_uniTrapPriorityEnable_set,
    .trap_uniTrapPriorityEnable_get             = dal_rtl9603cvd_trap_uniTrapPriorityEnable_get,
    .trap_uniTrapPriorityPriority_set           = dal_rtl9603cvd_trap_uniTrapPriorityPriority_set,
    .trap_uniTrapPriorityPriority_get           = dal_rtl9603cvd_trap_uniTrapPriorityPriority_get,
    .trap_cpuTrapHashMask_set                   = NULL,
    .trap_cpuTrapHashMask_get                   = NULL,
    .trap_cpuTrapHashPort_set                   = NULL,
    .trap_cpuTrapHashPort_get                   = NULL,
    .trap_cpuTrapHashState_set                  = NULL,
    .trap_cpuTrapHashState_get                  = NULL,
    .trap_cpuTrapInicHashState_set              = NULL,
    .trap_cpuTrapInicHashState_get              = NULL,
    .trap_cpuTrapInicHashSelect_set             = NULL,
    .trap_cpuTrapInicHashSelect_get             = NULL,

    /*SVLAN*/
    .svlan_init = dal_rtl9603cvd_svlan_init,
    .svlan_create = dal_rtl9603cvd_svlan_create,
    .svlan_destroy = dal_rtl9603cvd_svlan_destroy,
    .svlan_portSvid_get = dal_rtl9603cvd_svlan_portSvid_get,
    .svlan_portSvid_set = dal_rtl9603cvd_svlan_portSvid_set,
    .svlan_servicePort_get = dal_rtl9603cvd_svlan_servicePort_get,
    .svlan_servicePort_set = dal_rtl9603cvd_svlan_servicePort_set,
    .svlan_memberPort_set = dal_rtl9603cvd_svlan_memberPort_set,
    .svlan_memberPort_get = dal_rtl9603cvd_svlan_memberPort_get,
    .svlan_tpidEntry_get = dal_rtl9603cvd_svlan_tpidEntry_get,
    .svlan_tpidEntry_set = dal_rtl9603cvd_svlan_tpidEntry_set,
    .svlan_priorityRef_set = dal_rtl9603cvd_svlan_priorityRef_set,
    .svlan_priorityRef_get = dal_rtl9603cvd_svlan_priorityRef_get,
    .svlan_sp2c_add = dal_rtl9603cvd_svlan_sp2c_add,
    .svlan_sp2c_get = dal_rtl9603cvd_svlan_sp2c_get,
    .svlan_sp2c_del = dal_rtl9603cvd_svlan_sp2c_del,
    .svlan_untagAction_set = dal_rtl9603cvd_svlan_untagAction_set,
    .svlan_untagAction_get = dal_rtl9603cvd_svlan_untagAction_get,
    .svlan_trapPri_get                          = dal_rtl9603cvd_svlan_trapPri_get,
    .svlan_trapPri_set                          = dal_rtl9603cvd_svlan_trapPri_set,
    .svlan_deiKeepState_get                     = dal_rtl9603cvd_svlan_deiKeepState_get,
    .svlan_deiKeepState_set                     = dal_rtl9603cvd_svlan_deiKeepState_set,
    .svlan_svlanFunctionEnable_get              = dal_rtl9603cvd_svlan_svlanFunctionEnable_get,
    .svlan_svlanFunctionEnable_set              = dal_rtl9603cvd_svlan_svlanFunctionEnable_set,
    .svlan_tpidEnable_get                       = dal_rtl9603cvd_svlan_tpidEnable_get,
    .svlan_tpidEnable_set                       = dal_rtl9603cvd_svlan_tpidEnable_set,
    .svlan_sp2cPriority_add                     = dal_rtl9603cvd_svlan_sp2cPriority_add,
    .svlan_sp2cPriority_get                     = dal_rtl9603cvd_svlan_sp2cPriority_get,
    .svlan_extPortPvid_get                      = dal_rtl9603cvd_svlan_extPortPvid_get,
    .svlan_extPortPvid_set                      = dal_rtl9603cvd_svlan_extPortPvid_set,



     /* VLAN */
    .vlan_init                                  = dal_rtl9603cvd_vlan_init,
    .vlan_create                                = dal_rtl9603cvd_vlan_create,
    .vlan_destroy                               = dal_rtl9603cvd_vlan_destroy,
    .vlan_destroyAll                            = dal_rtl9603cvd_vlan_destroyAll,
    .vlan_fid_get                               = dal_rtl9603cvd_vlan_fid_get,
    .vlan_fid_set                               = dal_rtl9603cvd_vlan_fid_set,
    .vlan_fidMode_get                           = dal_rtl9603cvd_vlan_fidMode_get,
    .vlan_fidMode_set                           = dal_rtl9603cvd_vlan_fidMode_set,
    .vlan_port_get                              = dal_rtl9603cvd_vlan_port_get,
    .vlan_port_set                              = dal_rtl9603cvd_vlan_port_set,
    .vlan_stg_get                               = dal_rtl9603cvd_vlan_stg_get,
    .vlan_stg_set                               = dal_rtl9603cvd_vlan_stg_set,
    .vlan_portAcceptFrameType_get               = dal_rtl9603cvd_vlan_portAcceptFrameType_get,
    .vlan_portAcceptFrameType_set               = dal_rtl9603cvd_vlan_portAcceptFrameType_set,
    .vlan_vlanFunctionEnable_get                = dal_rtl9603cvd_vlan_vlanFunctionEnable_get,
    .vlan_vlanFunctionEnable_set                = dal_rtl9603cvd_vlan_vlanFunctionEnable_set,
    .vlan_portIgrFilterEnable_get               = dal_rtl9603cvd_vlan_portIgrFilterEnable_get,
    .vlan_portIgrFilterEnable_set               = dal_rtl9603cvd_vlan_portIgrFilterEnable_set,
    .vlan_leaky_get                             = dal_rtl9603cvd_vlan_leaky_get,
    .vlan_leaky_set                             = dal_rtl9603cvd_vlan_leaky_set,
    .vlan_portLeaky_get                         = dal_rtl9603cvd_vlan_portLeaky_get,
    .vlan_portLeaky_set                         = dal_rtl9603cvd_vlan_portLeaky_set,
    .vlan_keepType_get                          = dal_rtl9603cvd_vlan_keepType_get,
    .vlan_keepType_set                          = dal_rtl9603cvd_vlan_keepType_set,
    .vlan_portPvid_get                          = dal_rtl9603cvd_vlan_portPvid_get,
    .vlan_portPvid_set                          = dal_rtl9603cvd_vlan_portPvid_set,
    .vlan_extPortPvid_get                       = dal_rtl9603cvd_vlan_extPortPvid_get,
    .vlan_extPortPvid_set                       = dal_rtl9603cvd_vlan_extPortPvid_set,
    .vlan_protoGroup_get                        = dal_rtl9603cvd_vlan_protoGroup_get,
    .vlan_protoGroup_set                        = dal_rtl9603cvd_vlan_protoGroup_set,
    .vlan_portProtoVlan_get                     = dal_rtl9603cvd_vlan_portProtoVlan_get,
    .vlan_portProtoVlan_set                     = dal_rtl9603cvd_vlan_portProtoVlan_set,
    .vlan_tagMode_get                           = dal_rtl9603cvd_vlan_tagMode_get,
    .vlan_tagMode_set                           = dal_rtl9603cvd_vlan_tagMode_set,
    .vlan_cfiKeepEnable_get                     = dal_rtl9603cvd_vlan_cfiKeepEnable_get,
    .vlan_cfiKeepEnable_set                     = dal_rtl9603cvd_vlan_cfiKeepEnable_set,
    .vlan_reservedVidAction_get                 = dal_rtl9603cvd_vlan_reservedVidAction_get,
    .vlan_reservedVidAction_set                 = dal_rtl9603cvd_vlan_reservedVidAction_set,
    .vlan_tagModeIp4mc_get                      = dal_rtl9603cvd_vlan_tagModeIp4mc_get,
    .vlan_tagModeIp4mc_set                      = dal_rtl9603cvd_vlan_tagModeIp4mc_set,
    .vlan_tagModeIp6mc_get                      = dal_rtl9603cvd_vlan_tagModeIp6mc_get,
    .vlan_tagModeIp6mc_set                      = dal_rtl9603cvd_vlan_tagModeIp6mc_set,
    .vlan_lutSvlanHashState_set                 = dal_rtl9603cvd_vlan_lutSvlanHashState_set,
    .vlan_lutSvlanHashState_get                 = dal_rtl9603cvd_vlan_lutSvlanHashState_get,
    .vlan_extPortProtoVlan_set                  = dal_rtl9603cvd_vlan_extProtoVlan_set,
    .vlan_extPortProtoVlan_get                  = dal_rtl9603cvd_vlan_extProtoVlan_get,
    .vlan_extPortmaskIndex_set                  = dal_rtl9603cvd_vlan_extPmaskIdx_set,
    .vlan_extPortmaskIndex_get                  = dal_rtl9603cvd_vlan_extPmaskIdx_get,
    .vlan_extPortmaskCfg_set                    = dal_rtl9603cvd_vlan_extPortmaskCfg_set,
    .vlan_extPortmaskCfg_get                    = dal_rtl9603cvd_vlan_extPortmaskCfg_get,

    /* Mirror */
    .mirror_init                                = dal_rtl9603cvd_mirror_init,
    .mirror_portBased_set                       = dal_rtl9603cvd_mirror_portBased_set,
    .mirror_portBased_get                       = dal_rtl9603cvd_mirror_portBased_get,
    .mirror_portIso_set                         = dal_rtl9603cvd_mirror_portIso_set,
    .mirror_portIso_get                         = dal_rtl9603cvd_mirror_portIso_get,

    /* STP */
    .stp_init = dal_rtl9603cvd_stp_init,
    .stp_mstpState_get = dal_rtl9603cvd_stp_mstpState_get,
    .stp_mstpState_set = dal_rtl9603cvd_stp_mstpState_set,
    /*rate*/
    .rate_init = dal_rtl9603cvd_rate_init,
    .rate_portIgrBandwidthCtrlRate_get = dal_rtl9603cvd_rate_portIgrBandwidthCtrlRate_get,
    .rate_portIgrBandwidthCtrlRate_set = dal_rtl9603cvd_rate_portIgrBandwidthCtrlRate_set,
    .rate_portIgrBandwidthCtrlIncludeIfg_get = dal_rtl9603cvd_rate_portIgrBandwidthCtrlIncludeIfg_get,
    .rate_portIgrBandwidthCtrlIncludeIfg_set = dal_rtl9603cvd_rate_portIgrBandwidthCtrlIncludeIfg_set,
    .rate_portEgrBandwidthCtrlRate_get = dal_rtl9603cvd_rate_portEgrBandwidthCtrlRate_get,
    .rate_portEgrBandwidthCtrlRate_set = dal_rtl9603cvd_rate_portEgrBandwidthCtrlRate_set,
    .rate_egrBandwidthCtrlIncludeIfg_get = dal_rtl9603cvd_rate_egrBandwidthCtrlIncludeIfg_get,
    .rate_egrBandwidthCtrlIncludeIfg_set = dal_rtl9603cvd_rate_egrBandwidthCtrlIncludeIfg_set,
    .rate_portEgrBandwidthCtrlIncludeIfg_get = dal_rtl9603cvd_rate_portEgrBandwidthCtrlIncludeIfg_get,
    .rate_portEgrBandwidthCtrlIncludeIfg_set = dal_rtl9603cvd_rate_portEgrBandwidthCtrlIncludeIfg_set,
    .rate_egrQueueBwCtrlEnable_get = dal_rtl9603cvd_rate_egrQueueBwCtrlEnable_get,
    .rate_egrQueueBwCtrlEnable_set = dal_rtl9603cvd_rate_egrQueueBwCtrlEnable_set,
    .rate_egrQueueBwCtrlMeterIdx_get = dal_rtl9603cvd_rate_egrQueueBwCtrlMeterIdx_get,
    .rate_egrQueueBwCtrlMeterIdx_set = dal_rtl9603cvd_rate_egrQueueBwCtrlMeterIdx_set,
    .rate_stormControlMeterIdx_get = dal_rtl9603cvd_rate_stormControlMeterIdx_get,
    .rate_stormControlMeterIdx_set = dal_rtl9603cvd_rate_stormControlMeterIdx_set,
    .rate_stormControlPortEnable_get = dal_rtl9603cvd_rate_stormControlPortEnable_get,
    .rate_stormControlPortEnable_set = dal_rtl9603cvd_rate_stormControlPortEnable_set,
    .rate_stormControlEnable_get = NULL,
    .rate_stormControlEnable_set = NULL,
    .rate_stormBypass_set = dal_rtl9603cvd_rate_stormBypass_set,
    .rate_stormBypass_get = dal_rtl9603cvd_rate_stormBypass_get,
    .rate_shareMeter_set = dal_rtl9603cvd_rate_shareMeter_set,
    .rate_shareMeter_get = dal_rtl9603cvd_rate_shareMeter_get,
    .rate_shareMeterBucket_set = dal_rtl9603cvd_rate_shareMeterBucket_set,
    .rate_shareMeterBucket_get = dal_rtl9603cvd_rate_shareMeterBucket_get,
    .rate_shareMeterExceed_get = dal_rtl9603cvd_rate_shareMeterExceed_get,
    .rate_shareMeterExceed_clear = dal_rtl9603cvd_rate_shareMeterExceed_clear,
    .rate_shareMeterMode_set = dal_rtl9603cvd_rate_shareMeterMode_set,
    .rate_shareMeterMode_get = dal_rtl9603cvd_rate_shareMeterMode_get,
    .rate_hostIgrBwCtrlState_set = dal_rtl9603cvd_rate_hostIgrBwCtrlState_set,
    .rate_hostIgrBwCtrlState_get = dal_rtl9603cvd_rate_hostIgrBwCtrlState_get,
    .rate_hostEgrBwCtrlState_set = dal_rtl9603cvd_rate_hostEgrBwCtrlState_set,
    .rate_hostEgrBwCtrlState_get = dal_rtl9603cvd_rate_hostEgrBwCtrlState_get,
    .rate_hostBwCtrlMeterIdx_set = dal_rtl9603cvd_rate_hostBwCtrlMeterIdx_set,
    .rate_hostBwCtrlMeterIdx_get = dal_rtl9603cvd_rate_hostBwCtrlMeterIdx_get,
    .rate_hostMacAddr_set = dal_rtl9603cvd_rate_hostMacAddr_set,
    .rate_hostMacAddr_get = dal_rtl9603cvd_rate_hostMacAddr_get,
    .rate_hostIgrBwCtrlMeterIdx_get = dal_rtl9603cvd_rate_hostIgrBwCtrlMeterIdx_get,
    .rate_hostIgrBwCtrlMeterIdx_set = dal_rtl9603cvd_rate_hostIgrBwCtrlMeterIdx_set,
    .rate_hostEgrBwCtrlMeterIdx_get = dal_rtl9603cvd_rate_hostEgrBwCtrlMeterIdx_get,
    .rate_hostEgrBwCtrlMeterIdx_set = dal_rtl9603cvd_rate_hostEgrBwCtrlMeterIdx_set,


    /* PTP Function */
    .time_portTransparentEnable_set = dal_rtl9603cvd_time_portTransparentEnable_set,
    .time_portTransparentEnable_get = dal_rtl9603cvd_time_portTransparentEnable_get,
    .time_init = dal_rtl9603cvd_time_init,
    .time_portPtpEnable_get = dal_rtl9603cvd_time_portPtpEnable_get,
    .time_portPtpEnable_set = dal_rtl9603cvd_time_portPtpEnable_set,
    .time_curTime_latch = dal_rtl9603cvd_time_curTime_latch,
    .time_curTime_get = dal_rtl9603cvd_time_curTime_get,
    .time_refTime_get = dal_rtl9603cvd_time_refTime_get,
    .time_refTime_set = dal_rtl9603cvd_time_refTime_set,
    .time_frequency_set = dal_rtl9603cvd_time_frequency_set,
    .time_frequency_get = dal_rtl9603cvd_time_frequency_get,
    .time_ptpIgrMsgAction_set = dal_rtl9603cvd_time_ptpIgrMsgAction_set,
    .time_ptpIgrMsgAction_get = dal_rtl9603cvd_time_ptpIgrMsgAction_get,
    .time_ptpEgrMsgAction_set = dal_rtl9603cvd_time_ptpEgrMsgAction_set,
    .time_ptpEgrMsgAction_get = dal_rtl9603cvd_time_ptpEgrMsgAction_get,
    .time_meanPathDelay_set = dal_rtl9603cvd_time_meanPathDelay_set,
    .time_meanPathDelay_get = dal_rtl9603cvd_time_meanPathDelay_get,
    .time_rxTime_set = dal_rtl9603cvd_time_rxTime_set,
    .time_rxTime_get = dal_rtl9603cvd_time_rxTime_get,
    .time_ponTodTime_set = dal_rtl9603cvd_time_ponTodTime_set,
    .time_ponTodTime_get = dal_rtl9603cvd_time_ponTodTime_get,
    .time_portPtpTxIndicator_get = dal_rtl9603cvd_time_portPtpTxIndicator_get,
    .time_todEnable_get = dal_rtl9603cvd_time_todEnable_get,
    .time_todEnable_set = dal_rtl9603cvd_time_todEnable_set,
    .time_ppsEnable_get = dal_rtl9603cvd_time_ppsEnable_get,
    .time_ppsEnable_set = dal_rtl9603cvd_time_ppsEnable_set,
    .time_ppsMode_get = dal_rtl9603cvd_time_ppsMode_get,
    .time_ppsMode_set = dal_rtl9603cvd_time_ppsMode_set,
    .time_freeTime_get = dal_rtl9603cvd_time_freeTime_get,

#if 1
    /*acl*/
    .acl_init = dal_rtl9603cvd_acl_init,
    .acl_template_set = dal_rtl9603cvd_acl_template_set,
    .acl_template_get = dal_rtl9603cvd_acl_template_get,
    .acl_fieldSelect_set = dal_rtl9603cvd_acl_fieldSelect_set,
    .acl_fieldSelect_get = dal_rtl9603cvd_acl_fieldSelect_get,
    .acl_igrRuleEntry_get = dal_rtl9603cvd_acl_igrRuleEntry_get,
    .acl_igrRuleField_add = dal_rtl9603cvd_acl_igrRuleField_add,
    .acl_igrRuleEntry_add = dal_rtl9603cvd_acl_igrRuleEntry_add,
    .acl_igrRuleEntry_del = dal_rtl9603cvd_acl_igrRuleEntry_del,
    .acl_igrRuleEntry_delAll = dal_rtl9603cvd_acl_igrRuleEntry_delAll,
    .acl_igrUnmatchAction_set = dal_rtl9603cvd_acl_igrUnmatchAction_set,
    .acl_igrUnmatchAction_get = dal_rtl9603cvd_acl_igrUnmatchAction_get,
    .acl_igrState_set = dal_rtl9603cvd_acl_igrState_set,
    .acl_igrState_get = dal_rtl9603cvd_acl_igrState_get,
    .acl_ipRange_set = dal_rtl9603cvd_acl_ipRange_set,
    .acl_ipRange_get = dal_rtl9603cvd_acl_ipRange_get,
    .acl_vidRange_set = dal_rtl9603cvd_acl_vidRange_set,
    .acl_vidRange_get = dal_rtl9603cvd_acl_vidRange_get,
    .acl_portRange_set = dal_rtl9603cvd_acl_portRange_set,
    .acl_portRange_get = dal_rtl9603cvd_acl_portRange_get,
    .acl_packetLengthRange_set = dal_rtl9603cvd_acl_packetLengthRange_set,
    .acl_packetLengthRange_get = dal_rtl9603cvd_acl_packetLengthRange_get,
    .acl_igrPermitState_set = dal_rtl9603cvd_acl_igrPermitState_set,
    .acl_igrPermitState_get = dal_rtl9603cvd_acl_igrPermitState_get,
    .acl_dbgInfo_get = dal_rtl9603cvd_acl_dbgInfo_get,
    .acl_dbgHitReason_get = dal_rtl9603cvd_acl_dbgHitReason_get,


#endif

#if 0
    /*dot1x*/
    .dot1x_init = dal_rtl9603cvd_dot1x_init,
    .dot1x_unauthPacketOper_get = dal_rtl9603cvd_dot1x_unauthPacketOper_get,
    .dot1x_unauthPacketOper_set = dal_rtl9603cvd_dot1x_unauthPacketOper_set,
    .dot1x_portBasedEnable_get = dal_rtl9603cvd_dot1x_portBasedEnable_get,
    .dot1x_portBasedEnable_set = dal_rtl9603cvd_dot1x_portBasedEnable_set,
    .dot1x_portBasedAuthStatus_get = dal_rtl9603cvd_dot1x_portBasedAuthStatus_get,
    .dot1x_portBasedAuthStatus_set = dal_rtl9603cvd_dot1x_portBasedAuthStatus_set,
    .dot1x_portBasedDirection_get = dal_rtl9603cvd_dot1x_portBasedDirection_get,
    .dot1x_portBasedDirection_set = dal_rtl9603cvd_dot1x_portBasedDirection_set,
    .dot1x_macBasedEnable_get = dal_rtl9603cvd_dot1x_macBasedEnable_get,
    .dot1x_macBasedEnable_set = dal_rtl9603cvd_dot1x_macBasedEnable_set,
    .dot1x_macBasedDirection_get = dal_rtl9603cvd_dot1x_macBasedDirection_get,
    .dot1x_macBasedDirection_set = dal_rtl9603cvd_dot1x_macBasedDirection_set,
    .dot1x_guestVlan_get = NULL,
    .dot1x_guestVlan_set = NULL,
    .dot1x_guestVlanBehavior_get = NULL,
    .dot1x_guestVlanBehavior_set = NULL,
    .dot1x_trapPri_get = dal_rtl9603cvd_dot1x_trapPri_get,
    .dot1x_trapPri_set = dal_rtl9603cvd_dot1x_trapPri_set,
#endif
     
    /* L2 */
    .l2_init                                    = dal_rtl9603cvd_l2_init,
    .l2_flushLinkDownPortAddrEnable_get         = dal_rtl9603cvd_l2_flushLinkDownPortAddrEnable_get,
    .l2_flushLinkDownPortAddrEnable_set         = dal_rtl9603cvd_l2_flushLinkDownPortAddrEnable_set,
    .l2_ucastAddr_flush                         = dal_rtl9603cvd_l2_ucastAddr_flush,
    .l2_table_clear                             = dal_rtl9603cvd_l2_table_clear,
    .l2_limitLearningOverStatus_get             = dal_rtl9603cvd_l2_limitLearningOverStatus_get,
    .l2_limitLearningOverStatus_clear           = dal_rtl9603cvd_l2_limitLearningOverStatus_clear,
    .l2_learningCnt_get                         = dal_rtl9603cvd_l2_learningCnt_get,
    .l2_limitLearningCnt_get                    = dal_rtl9603cvd_l2_limitLearningCnt_get,
    .l2_limitLearningCnt_set                    = dal_rtl9603cvd_l2_limitLearningCnt_set,
    .l2_limitLearningCntAction_get              = dal_rtl9603cvd_l2_limitLearningCntAction_get,
    .l2_limitLearningCntAction_set              = dal_rtl9603cvd_l2_limitLearningCntAction_set,
    .l2_limitLearningEntryAction_get            = dal_rtl9603cvd_l2_limitLearningEntryAction_get,
    .l2_limitLearningEntryAction_set            = dal_rtl9603cvd_l2_limitLearningEntryAction_set,
    .l2_limitLearningPortMask_get               = dal_rtl9603cvd_l2_limitLearningPortMask_get,
    .l2_limitLearningPortMask_set               = dal_rtl9603cvd_l2_limitLearningPortMask_set,
    .l2_portLimitLearningOverStatus_get         = dal_rtl9603cvd_l2_portLimitLearningOverStatus_get,
    .l2_portLimitLearningOverStatus_clear       = dal_rtl9603cvd_l2_portLimitLearningOverStatus_clear,
    .l2_portLearningCnt_get                     = dal_rtl9603cvd_l2_portLearningCnt_get,
    .l2_portLimitLearningCnt_get                = dal_rtl9603cvd_l2_portLimitLearningCnt_get,
    .l2_portLimitLearningCnt_set                = dal_rtl9603cvd_l2_portLimitLearningCnt_set,
    .l2_portLimitLearningCntAction_get          = dal_rtl9603cvd_l2_portLimitLearningCntAction_get,
    .l2_portLimitLearningCntAction_set          = dal_rtl9603cvd_l2_portLimitLearningCntAction_set,
    .l2_aging_get                               = dal_rtl9603cvd_l2_aging_get,
    .l2_aging_set                               = dal_rtl9603cvd_l2_aging_set,
    .l2_portAgingEnable_get                     = dal_rtl9603cvd_l2_portAgingEnable_get,
    .l2_portAgingEnable_set                     = dal_rtl9603cvd_l2_portAgingEnable_set,
    .l2_lookupMissAction_get                    = dal_rtl9603cvd_l2_lookupMissAction_get,
    .l2_lookupMissAction_set                    = dal_rtl9603cvd_l2_lookupMissAction_set,
    .l2_portLookupMissAction_get                = dal_rtl9603cvd_l2_portLookupMissAction_get,
    .l2_portLookupMissAction_set                = dal_rtl9603cvd_l2_portLookupMissAction_set,
    .l2_lookupMissFloodPortMask_get             = dal_rtl9603cvd_l2_lookupMissFloodPortMask_get,
    .l2_lookupMissFloodPortMask_set             = dal_rtl9603cvd_l2_lookupMissFloodPortMask_set,
    .l2_lookupMissFloodPortMask_add             = dal_rtl9603cvd_l2_lookupMissFloodPortMask_add,
    .l2_lookupMissFloodPortMask_del             = dal_rtl9603cvd_l2_lookupMissFloodPortMask_del,
    .l2_newMacOp_get                            = dal_rtl9603cvd_l2_newMacOp_get,
    .l2_newMacOp_set                            = dal_rtl9603cvd_l2_newMacOp_set,
    .l2_nextValidAddr_get                       = dal_rtl9603cvd_l2_nextValidAddr_get,
    .l2_nextValidAddrOnPort_get                 = dal_rtl9603cvd_l2_nextValidAddrOnPort_get,
    .l2_nextValidMcastAddr_get                  = dal_rtl9603cvd_l2_nextValidMcastAddr_get,
    .l2_nextValidIpMcastAddr_get                = dal_rtl9603cvd_l2_nextValidIpMcastAddr_get,
    .l2_nextValidEntry_get                      = dal_rtl9603cvd_l2_nextValidEntry_get,
    .l2_addr_add                                = dal_rtl9603cvd_l2_addr_add,
    .l2_addr_del                                = dal_rtl9603cvd_l2_addr_del,
    .l2_addr_get                                = dal_rtl9603cvd_l2_addr_get,
    .l2_addr_delAll                             = dal_rtl9603cvd_l2_addr_delAll,
    .l2_mcastAddr_add                           = dal_rtl9603cvd_l2_mcastAddr_add,
    .l2_mcastAddr_del                           = dal_rtl9603cvd_l2_mcastAddr_del,
    .l2_mcastAddr_get                           = dal_rtl9603cvd_l2_mcastAddr_get,
    .l2_illegalPortMoveAction_get               = dal_rtl9603cvd_l2_illegalPortMoveAction_get,
    .l2_illegalPortMoveAction_set               = dal_rtl9603cvd_l2_illegalPortMoveAction_set,
    .l2_ipmcMode_get                            = dal_rtl9603cvd_l2_ipmcMode_get,
    .l2_ipmcMode_set                            = dal_rtl9603cvd_l2_ipmcMode_set,
    .l2_ipmcVlanMode_get                        = dal_rtl9603cvd_l2_ipmcVlanMode_get,
    .l2_ipmcVlanMode_set                        = dal_rtl9603cvd_l2_ipmcVlanMode_set,
    .l2_ipv6mcMode_get                          = NULL,
    .l2_ipv6mcMode_set                          = NULL,
    .l2_ipmcGroupLookupMissHash_get             = NULL,
    .l2_ipmcGroupLookupMissHash_set             = NULL,
    .l2_ipmcGroup_add                           = dal_rtl9603cvd_l2_ipmcGroup_add,
    .l2_ipmcGroupExtPortmask_add                = NULL,
    .l2_ipmcGroupExtMemberIdx_add               = dal_rtl9603cvd_l2_ipmcGroupExtMemberIdx_add,
    .l2_ipmcGroup_del                           = dal_rtl9603cvd_l2_ipmcGroup_del,
    .l2_ipmcGroup_get                           = dal_rtl9603cvd_l2_ipmcGroup_get,
    .l2_ipmcGroupExtPortmask_get                = NULL,
    .l2_ipmcGroupExtMemberIdx_get               = dal_rtl9603cvd_l2_ipmcGroupExtMemberIdx_get,
    .l2_ipmcSipFilter_set                       = NULL,
    .l2_ipmcSipFilter_get                       = NULL,
    .l2_portIpmcAction_get                      = dal_rtl9603cvd_l2_portIpmcAction_get,
    .l2_portIpmcAction_set                      = dal_rtl9603cvd_l2_portIpmcAction_set,
    .l2_ipMcastAddr_add                         = dal_rtl9603cvd_l2_ipMcastAddr_add,
    .l2_ipMcastAddr_del                         = dal_rtl9603cvd_l2_ipMcastAddr_del,
    .l2_ipMcastAddr_get                         = dal_rtl9603cvd_l2_ipMcastAddr_get,
    .l2_srcPortEgrFilterMask_get                = dal_rtl9603cvd_l2_srcPortEgrFilterMask_get,
    .l2_srcPortEgrFilterMask_set                = dal_rtl9603cvd_l2_srcPortEgrFilterMask_set,
    .l2_extPortEgrFilterMask_get                = dal_rtl9603cvd_l2_extPortEgrFilterMask_get,
    .l2_extPortEgrFilterMask_set                = dal_rtl9603cvd_l2_extPortEgrFilterMask_set,
    .l2_camState_set                            = dal_rtl9603cvd_l2_camState_set,
    .l2_camState_get                            = dal_rtl9603cvd_l2_camState_get,
    .l2_vidUnmatchAction_get                    = dal_rtl9603cvd_l2_vidUnmatchAction_get,
    .l2_vidUnmatchAction_set                    = dal_rtl9603cvd_l2_vidUnmatchAction_set,
    .l2_extMemberConfig_get                     = dal_rtl9603cvd_l2_extMemberConfig_get,
    .l2_extMemberConfig_set                     = dal_rtl9603cvd_l2_extMemberConfig_set,
    .l2_ip6mcReservedAddrEnable_set             = dal_rtl9603cvd_l2_ip6mcReservedAddrEnable_set,
    .l2_ip6mcReservedAddrEnable_get             = dal_rtl9603cvd_l2_ip6mcReservedAddrEnable_get,
    .l2_hashValue_get                           = dal_rtl9603cvd_l2_hashValue_get,

     /*interrupt*/
    .intr_init = dal_rtl9603cvd_intr_init,
    .intr_polarity_set = dal_rtl9603cvd_intr_polarity_set,
    .intr_polarity_get = dal_rtl9603cvd_intr_polarity_get,
    .intr_imr_set = dal_rtl9603cvd_intr_imr_set,
    .intr_imr_get = dal_rtl9603cvd_intr_imr_get,
    .intr_ims_get = dal_rtl9603cvd_intr_ims_get,
    .intr_ims_clear = dal_rtl9603cvd_intr_ims_clear,
    .intr_speedChangeStatus_get = dal_rtl9603cvd_intr_speedChangeStatus_get,
    .intr_speedChangeStatus_clear = dal_rtl9603cvd_intr_speedChangeStatus_clear,
    .intr_linkupStatus_get = dal_rtl9603cvd_intr_linkupStatus_get,
    .intr_linkupStatus_clear = dal_rtl9603cvd_intr_linkupStatus_clear,
    .intr_linkupPortStatus_clear = dal_rtl9603cvd_intr_linkupPortStatus_clear,
    .intr_linkdownStatus_get = dal_rtl9603cvd_intr_linkdownStatus_get,
    .intr_linkdownStatus_clear = dal_rtl9603cvd_intr_linkdownStatus_clear,
    .intr_linkdownPortStatus_clear = dal_rtl9603cvd_intr_linkdownPortStatus_clear,
    .intr_gphyStatus_get = dal_rtl9603cvd_intr_gphyStatus_get,
    .intr_gphyStatus_clear = dal_rtl9603cvd_intr_gphyStatus_clear,
    .intr_imr_restore = dal_rtl9603cvd_intr_imr_restore,
    .intr_isr_set = dal_rtl9603cvd_intr_isr_set,
    .intr_isr_get = dal_rtl9603cvd_intr_isr_get,
    .intr_isr_counter_dump = dal_rtl9603cvd_intr_isr_counter_dump,


    /*cpu*/
    .cpu_init = dal_rtl9603cvd_cpu_init,
    .cpu_awarePortMask_set = NULL,
    .cpu_awarePortMask_get = NULL,
    .cpu_tagFormat_set = NULL,
    .cpu_tagFormat_get = NULL,
    .cpu_trapInsertTag_set = dal_rtl9603cvd_cpu_trapInsertTag_set,
    .cpu_trapInsertTag_get = dal_rtl9603cvd_cpu_trapInsertTag_get,
    .cpu_tagAware_set = dal_rtl9603cvd_cpu_tagAware_set,
    .cpu_tagAware_get = dal_rtl9603cvd_cpu_tagAware_get,
    .cpu_trapInsertTagByPort_set = NULL,
    .cpu_trapInsertTagByPort_get = NULL,
    .cpu_tagAwareByPort_set = NULL,
    .cpu_tagAwareByPort_get = NULL,

    /* QoS */
    .qos_init = dal_rtl9603cvd_qos_init,
    .qos_priSelGroup_get = dal_rtl9603cvd_qos_priSelGroup_get,
    .qos_priSelGroup_set = dal_rtl9603cvd_qos_priSelGroup_set,
    .qos_portPri_get = dal_rtl9603cvd_qos_portPri_get,
    .qos_portPri_set = dal_rtl9603cvd_qos_portPri_set,
    .qos_dscpPriRemapGroup_get = dal_rtl9603cvd_qos_dscpPriRemapGroup_get,
    .qos_dscpPriRemapGroup_set = dal_rtl9603cvd_qos_dscpPriRemapGroup_set,
    .qos_1pPriRemapGroup_get = dal_rtl9603cvd_qos_1pPriRemapGroup_get,
    .qos_1pPriRemapGroup_set = dal_rtl9603cvd_qos_1pPriRemapGroup_set,
    .qos_priMap_get = dal_rtl9603cvd_qos_priMap_get,
    .qos_priMap_set = dal_rtl9603cvd_qos_priMap_set,
    .qos_portPriMap_get = dal_rtl9603cvd_qos_portPriMap_get,
    .qos_portPriMap_set = dal_rtl9603cvd_qos_portPriMap_set,
    .qos_1pRemarkEnable_get = dal_rtl9603cvd_qos_1pRemarkEnable_get,
    .qos_1pRemarkEnable_set = dal_rtl9603cvd_qos_1pRemarkEnable_set,
    .qos_1pRemarkGroup_get = dal_rtl9603cvd_qos_1pRemarkGroup_get,
    .qos_1pRemarkGroup_set = dal_rtl9603cvd_qos_1pRemarkGroup_set,
    .qos_dscpRemarkEnable_get = dal_rtl9603cvd_qos_dscpRemarkEnable_get,
    .qos_dscpRemarkEnable_set = dal_rtl9603cvd_qos_dscpRemarkEnable_set,
    .qos_dscpRemarkGroup_get = dal_rtl9603cvd_qos_dscpRemarkGroup_get,
    .qos_dscpRemarkGroup_set = dal_rtl9603cvd_qos_dscpRemarkGroup_set,
    .qos_fwd2CpuPriRemap_get = dal_rtl9603cvd_qos_fwd2CpuPriRemap_get,
    .qos_fwd2CpuPriRemap_set = dal_rtl9603cvd_qos_fwd2CpuPriRemap_set,
    .qos_portDscpRemarkSrcSel_get = dal_rtl9603cvd_qos_portDscpRemarkSrcSel_get,
    .qos_portDscpRemarkSrcSel_set = dal_rtl9603cvd_qos_portDscpRemarkSrcSel_set,
    .qos_dscp2DscpRemarkGroup_get = dal_rtl9603cvd_qos_dscp2DscpRemarkGroup_get,
    .qos_dscp2DscpRemarkGroup_set = dal_rtl9603cvd_qos_dscp2DscpRemarkGroup_set,
    .qos_schedulingQueue_get = dal_rtl9603cvd_qos_schedulingQueue_get,
    .qos_schedulingQueue_set = dal_rtl9603cvd_qos_schedulingQueue_set,
    .qos_portPriSelGroup_get = dal_rtl9603cvd_qos_portPriSelGroup_get,
    .qos_portPriSelGroup_set = dal_rtl9603cvd_qos_portPriSelGroup_set,
    .qos_schedulingType_get = dal_rtl9603cvd_qos_schedulingType_get,
    .qos_schedulingType_set = dal_rtl9603cvd_qos_schedulingType_set,
    .qos_portDot1pRemarkSrcSel_get = dal_rtl9603cvd_qos_portDot1pRemarkSrcSel_get,
    .qos_portDot1pRemarkSrcSel_set = dal_rtl9603cvd_qos_portDot1pRemarkSrcSel_set,

    /* Classification */
    .classify_init                              = dal_rtl9603cvd_fakeInit,
#if 0 /*remove classify function*/
    .classify_cfgEntry_add                      = dal_rtl9603cvd_classify_cfgEntry_add,
    .classify_cfgEntry_get                      = dal_rtl9603cvd_classify_cfgEntry_get,
    .classify_cfgEntry_del                      = dal_rtl9603cvd_classify_cfgEntry_del,
    .classify_field_add                         = dal_rtl9603cvd_classify_field_add,
    .classify_unmatchAction_set                 = dal_rtl9603cvd_classify_unmatchAction_set,
    .classify_unmatchAction_get                 = dal_rtl9603cvd_classify_unmatchAction_get,
    .classify_cf_sel_set                        = dal_rtl9603cvd_classify_cf_sel_set,
    .classify_cf_sel_get                        = dal_rtl9603cvd_classify_cf_sel_get,
    .classify_trapPri_set                       = dal_rtl9603cvd_classify_trap_pri_set,
    .classify_trapPri_get                       = dal_rtl9603cvd_classify_trap_pri_get,
#endif

    /* GPON */
    .gpon_init = dal_rtl9603cvd_gpon_init,
    .gpon_resetState_set = dal_rtl9603cvd_gpon_resetState_set,
    .gpon_resetDoneState_get = dal_rtl9603cvd_gpon_resetDoneState_get,
    .gpon_version_get = dal_rtl9603cvd_gpon_version_get,
    .gpon_test_get = dal_rtl9603cvd_gpon_test_get,
    .gpon_test_set = dal_rtl9603cvd_gpon_test_set,
    .gpon_topIntrMask_get = dal_rtl9603cvd_gpon_topIntrMask_get,
    .gpon_topIntrMask_set = dal_rtl9603cvd_gpon_topIntrMask_set,
    .gpon_topIntr_get = dal_rtl9603cvd_gpon_topIntr_get,
    .gpon_topIntr_disableAll = dal_rtl9603cvd_gpon_topIntr_disableAll,
    .gpon_gtcDsIntr_get = dal_rtl9603cvd_gpon_gtcDsIntr_get,
    .gpon_gtcDsIntrDlt_get = dal_rtl9603cvd_gpon_gtcDsIntrDlt_get,
    .gpon_gtcDsIntrMask_get = dal_rtl9603cvd_gpon_gtcDsIntrMask_get,
    .gpon_gtcDsIntrMask_set = dal_rtl9603cvd_gpon_gtcDsIntrMask_set,
    .gpon_onuId_set = dal_rtl9603cvd_gpon_onuId_set,
    .gpon_onuId_get = dal_rtl9603cvd_gpon_onuId_get,
    .gpon_onuState_set = dal_rtl9603cvd_gpon_onuState_set,
    .gpon_onuState_get = dal_rtl9603cvd_gpon_onuState_get,
    .gpon_dsBwmapCrcCheckState_set = dal_rtl9603cvd_gpon_dsBwmapCrcCheckState_set,
    .gpon_dsBwmapCrcCheckState_get = dal_rtl9603cvd_gpon_dsBwmapCrcCheckState_get,
    .gpon_dsBwmapFilterOnuIdState_set = dal_rtl9603cvd_gpon_dsBwmapFilterOnuIdState_set,
    .gpon_dsBwmapFilterOnuIdState_get = dal_rtl9603cvd_gpon_dsBwmapFilterOnuIdState_get,
    .gpon_dsPlendStrictMode_set = dal_rtl9603cvd_gpon_dsPlendStrictMode_set,
    .gpon_dsPlendStrictMode_get = dal_rtl9603cvd_gpon_dsPlendStrictMode_get,
    .gpon_dsScrambleState_set = dal_rtl9603cvd_gpon_dsScrambleState_set,
    .gpon_dsScrambleState_get = dal_rtl9603cvd_gpon_dsScrambleState_get,
    .gpon_dsFecBypass_set = dal_rtl9603cvd_gpon_dsFecBypass_set,
    .gpon_dsFecBypass_get = dal_rtl9603cvd_gpon_dsFecBypass_get,
    .gpon_dsFecThrd_set = dal_rtl9603cvd_gpon_dsFecThrd_set,
    .gpon_dsFecThrd_get = dal_rtl9603cvd_gpon_dsFecThrd_get,
    .gpon_extraSnTxTimes_set = dal_rtl9603cvd_gpon_extraSnTxTimes_set,
    .gpon_extraSnTxTimes_get = dal_rtl9603cvd_gpon_extraSnTxTimes_get,
    .gpon_dsPloamNomsg_set = dal_rtl9603cvd_gpon_dsPloamNomsg_set,
    .gpon_dsPloamNomsg_get = dal_rtl9603cvd_gpon_dsPloamNomsg_get,
    .gpon_dsPloamOnuIdFilterState_set = dal_rtl9603cvd_gpon_dsPloamOnuIdFilterState_set,
    .gpon_dsPloamOnuIdFilterState_get = dal_rtl9603cvd_gpon_dsPloamOnuIdFilterState_get,
    .gpon_dsPloamBcAcceptState_set = dal_rtl9603cvd_gpon_dsPloamBcAcceptState_set,
    .gpon_dsPloamBcAcceptState_get = dal_rtl9603cvd_gpon_dsPloamBcAcceptState_get,
    .gpon_dsPloamDropCrcState_set = dal_rtl9603cvd_gpon_dsPloamDropCrcState_set,
    .gpon_dsPloamDropCrcState_get = dal_rtl9603cvd_gpon_dsPloamDropCrcState_get,
    .gpon_cdrLosStatus_get = dal_rtl9603cvd_gpon_cdrLosStatus_get,
    .gpon_optLosStatus_get = dal_rtl9603cvd_gpon_optLosStatus_get,
    .gpon_losCfg_set = dal_rtl9603cvd_gpon_losCfg_set,
    .gpon_losCfg_get = dal_rtl9603cvd_gpon_losCfg_get,
    .gpon_dsPloam_get = dal_rtl9603cvd_gpon_dsPloam_get,
    .gpon_dsPloam_getAll = dal_rtl9603cvd_gpon_dsPloam_getAll,
    .gpon_tcont_get = dal_rtl9603cvd_gpon_tcont_get,
    .gpon_tcont_set = dal_rtl9603cvd_gpon_tcont_set,
    .gpon_tcont_del = dal_rtl9603cvd_gpon_tcont_del,
    .gpon_dsGemPort_get = dal_rtl9603cvd_gpon_dsGemPort_get,
    .gpon_dsGemPort_set = dal_rtl9603cvd_gpon_dsGemPort_set,
    .gpon_dsGemPort_del = dal_rtl9603cvd_gpon_dsGemPort_del,
    .gpon_dsGemPortPktCnt_get = dal_rtl9603cvd_gpon_dsGemPortPktCnt_get,
    .gpon_dsGemPortByteCnt_get = dal_rtl9603cvd_gpon_dsGemPortByteCnt_get,
    .gpon_dsGtcMiscCnt_get = dal_rtl9603cvd_gpon_dsGtcMiscCnt_get,
    .gpon_dsOmciPti_set = dal_rtl9603cvd_gpon_dsOmciPti_set,
    .gpon_dsOmciPti_get = dal_rtl9603cvd_gpon_dsOmciPti_get,
    .gpon_dsEthPti_set = dal_rtl9603cvd_gpon_dsEthPti_set,
    .gpon_dsEthPti_get = dal_rtl9603cvd_gpon_dsEthPti_get,
    .gpon_aesKeySwitch_set = dal_rtl9603cvd_gpon_aesKeySwitch_set,
    .gpon_aesKeySwitch_get = dal_rtl9603cvd_gpon_aesKeySwitch_get,
    .gpon_aesKeyWord_set = dal_rtl9603cvd_gpon_aesKeyWord_set,
    .gpon_aesKeyWordActive_set = dal_rtl9603cvd_gpon_aesKeyWordActive_set,
    .gpon_irq_get = dal_rtl9603cvd_gpon_irq_get,
    .gpon_dsGemPortEthRxCnt_get = dal_rtl9603cvd_gpon_dsGemPortEthRxCnt_get,
    .gpon_dsGemPortEthFwdCnt_get = dal_rtl9603cvd_gpon_dsGemPortEthFwdCnt_get,
    .gpon_dsGemPortMiscCnt_get = dal_rtl9603cvd_gpon_dsGemPortMiscCnt_get,
    .gpon_dsGemPortFcsCheckState_get = dal_rtl9603cvd_gpon_dsGemPortFcsCheckState_get,
    .gpon_dsGemPortFcsCheckState_set = dal_rtl9603cvd_gpon_dsGemPortFcsCheckState_set,
    .gpon_dsGemPortBcPassState_set = dal_rtl9603cvd_gpon_dsGemPortBcPassState_set,
    .gpon_dsGemPortBcPassState_get = dal_rtl9603cvd_gpon_dsGemPortBcPassState_get,
    .gpon_dsGemPortNonMcPassState_set = dal_rtl9603cvd_gpon_dsGemPortNonMcPassState_set,
    .gpon_dsGemPortNonMcPassState_get = dal_rtl9603cvd_gpon_dsGemPortNonMcPassState_get,
    .gpon_dsGemPortMacFilterMode_set = dal_rtl9603cvd_gpon_dsGemPortMacFilterMode_set,
    .gpon_dsGemPortMacFilterMode_get = dal_rtl9603cvd_gpon_dsGemPortMacFilterMode_get,
    .gpon_dsGemPortMacForceMode_set = dal_rtl9603cvd_gpon_dsGemPortMacForceMode_set,
    .gpon_dsGemPortMacForceMode_get = dal_rtl9603cvd_gpon_dsGemPortMacForceMode_get,
    .gpon_dsGemPortMacEntry_set = dal_rtl9603cvd_gpon_dsGemPortMacEntry_set,
    .gpon_dsGemPortMacEntry_get = dal_rtl9603cvd_gpon_dsGemPortMacEntry_get,
    .gpon_dsGemPortMacEntry_del = dal_rtl9603cvd_gpon_dsGemPortMacEntry_del,
    .gpon_dsGemPortFrameTimeOut_set = dal_rtl9603cvd_gpon_dsGemPortFrameTimeOut_set,
    .gpon_dsGemPortFrameTimeOut_get = dal_rtl9603cvd_gpon_dsGemPortFrameTimeOut_get,
    .gpon_ipv4McAddrPtn_get = dal_rtl9603cvd_gpon_ipv4McAddrPtn_get,
    .gpon_ipv4McAddrPtn_set = dal_rtl9603cvd_gpon_ipv4McAddrPtn_set,
    .gpon_ipv6McAddrPtn_get = dal_rtl9603cvd_gpon_ipv6McAddrPtn_get,
    .gpon_ipv6McAddrPtn_set = dal_rtl9603cvd_gpon_ipv6McAddrPtn_set,
    .gpon_gtcUsIntr_get = dal_rtl9603cvd_gpon_gtcUsIntr_get,
    .gpon_gtcUsIntrDlt_get = dal_rtl9603cvd_gpon_gtcUsIntrDlt_get,
    .gpon_gtcUsIntrMask_get = dal_rtl9603cvd_gpon_gtcUsIntrMask_get,
    .gpon_gtcUsIntrMask_set = dal_rtl9603cvd_gpon_gtcUsIntrMask_set,
    .gpon_forceLaser_set = dal_rtl9603cvd_gpon_forceLaser_set,
    .gpon_forceLaser_get = dal_rtl9603cvd_gpon_forceLaser_get,
    .gpon_forcePRBS_set = dal_rtl9603cvd_gpon_forcePRBS_set,
    .gpon_forcePRBS_get = dal_rtl9603cvd_gpon_forcePRBS_get,
    .gpon_ploamState_set = dal_rtl9603cvd_gpon_ploamState_set,
    .gpon_ploamState_get = dal_rtl9603cvd_gpon_ploamState_get,
    .gpon_indNrmPloamState_set = dal_rtl9603cvd_gpon_indNrmPloamState_set,
    .gpon_indNrmPloamState_get = dal_rtl9603cvd_gpon_indNrmPloamState_get,
    .gpon_dbruState_set = dal_rtl9603cvd_gpon_dbruState_set,
    .gpon_dbruState_get = dal_rtl9603cvd_gpon_dbruState_get,
    .gpon_usScrambleState_set = dal_rtl9603cvd_gpon_usScrambleState_set,
    .gpon_usScrambleState_get = dal_rtl9603cvd_gpon_usScrambleState_get,
    .gpon_usBurstPolarity_set = dal_rtl9603cvd_gpon_usBurstPolarity_set,
    .gpon_usBurstPolarity_get = dal_rtl9603cvd_gpon_usBurstPolarity_get,
    .gpon_eqd_set = dal_rtl9603cvd_gpon_eqd_set,
    .gpon_eqd_get = dal_rtl9603cvd_gpon_eqd_get,
    .gpon_laserTime_set = dal_rtl9603cvd_gpon_laserTime_set,
    .gpon_laserTime_get = dal_rtl9603cvd_gpon_laserTime_get,
    .gpon_burstOverhead_set = dal_rtl9603cvd_gpon_burstOverhead_set,
    .gpon_usPloam_set = dal_rtl9603cvd_gpon_usPloam_set,
    .gpon_usAutoPloam_set = dal_rtl9603cvd_gpon_usAutoPloam_set,
    .gpon_usPloamCrcGenState_set = dal_rtl9603cvd_gpon_usPloamCrcGenState_set,
    .gpon_usPloamCrcGenState_get = dal_rtl9603cvd_gpon_usPloamCrcGenState_get,
    .gpon_usPloamOnuIdFilterState_set = dal_rtl9603cvd_gpon_usPloamOnuIdFilterState_set,
    .gpon_usPloamOnuIdFilter_get = dal_rtl9603cvd_gpon_usPloamOnuIdFilter_get,
    .gpon_usPloamBuf_flush = dal_rtl9603cvd_gpon_usPloamBuf_flush,
    .gpon_usGtcMiscCnt_get = dal_rtl9603cvd_gpon_usGtcMiscCnt_get,
    .gpon_rdi_set = dal_rtl9603cvd_gpon_rdi_set,
    .gpon_rdi_get = dal_rtl9603cvd_gpon_rdi_get,
    .gpon_usSmalSstartProcState_set = dal_rtl9603cvd_gpon_usSmalSstartProcState_set,
    .gpon_usSmalSstartProcState_get = dal_rtl9603cvd_gpon_usSmalSstartProcState_get,
    .gpon_usSuppressLaserState_set = dal_rtl9603cvd_gpon_usSuppressLaserState_set,
    .gpon_usSuppressLaserState_get = dal_rtl9603cvd_gpon_usSuppressLaserState_get,
    .gpon_gemUsIntr_get = dal_rtl9603cvd_gpon_gemUsIntr_get,
    .gpon_gemUsIntrMask_get = dal_rtl9603cvd_gpon_gemUsIntrMask_get,
    .gpon_gemUsIntrMask_set = dal_rtl9603cvd_gpon_gemUsIntrMask_set,
    .gpon_gemUsForceIdleState_set = dal_rtl9603cvd_gpon_gemUsForceIdleState_set,
    .gpon_gemUsForceIdleState_get = dal_rtl9603cvd_gpon_gemUsForceIdleState_get,
    .gpon_gemUsPtiVector_set = dal_rtl9603cvd_gpon_gemUsPtiVector_set,
    .gpon_gemUsPtiVector_get = dal_rtl9603cvd_gpon_gemUsPtiVector_get,
    .gpon_gemUsEthCnt_get = dal_rtl9603cvd_gpon_gemUsEthCnt_get,
    .gpon_gemUsGemCnt_get = dal_rtl9603cvd_gpon_gemUsGemCnt_get,
    .gpon_gemUsPortCfg_set = dal_rtl9603cvd_gpon_gemUsPortCfg_set,
    .gpon_gemUsPortCfg_get = dal_rtl9603cvd_gpon_gemUsPortCfg_get,
    .gpon_gemUsDataByteCnt_get = dal_rtl9603cvd_gpon_gemUsDataByteCnt_get,
    .gpon_gemUsIdleByteCnt_get = dal_rtl9603cvd_gpon_gemUsIdleByteCnt_get,
    .gpon_dbruPeriod_get = dal_rtl9603cvd_gpon_dbruPeriod_get,
    .gpon_dbruPeriod_set = dal_rtl9603cvd_gpon_dbruPeriod_set,
    .gpon_gtcDsIntrDlt_check = dal_rtl9603cvd_gpon_gtcDsIntrDlt_check,
    .gpon_gtcUsIntrDlt_check = dal_rtl9603cvd_gpon_gtcUsIntrDlt_check,
    .gpon_gemUsIntrDlt_check = dal_rtl9603cvd_gpon_gemUsIntrDlt_check,
    .gpon_rogueOnt_set = dal_rtl9603cvd_gpon_rogueOnt_set,
    .gpon_drainOutDefaultQueue_set = dal_rtl9603cvd_gpon_drainOutDefaultQueue_set,
    .gpon_autoDisTx_set = dal_rtl9603cvd_gpon_autoDisTx_set,
    .gpon_scheInfo_get = dal_rtl9603cvd_gpon_scheInfo_get,
    .gpon_dataPath_reset = dal_rtl9603cvd_gpon_dataPath_reset,
    .gpon_dsOmciCnt_get = dal_rtl9603cvd_gpon_dsOmciCnt_get,
    .gpon_usOmciCnt_get = dal_rtl9603cvd_gpon_usOmciCnt_get,
    .gpon_gtcDsTodSuperFrame_set = dal_rtl9603cvd_gponGtcDsTodSuperFrame_set,
    .gpon_gtcDsTodSuperFrame_get = dal_rtl9603cvd_gponGtcDsTodSuperFrame_get,
    .gpon_dbruBlockSize_get = dal_rtl9603cvd_gpon_dbruBlockSize_get,
    .gpon_dbruBlockSize_set = dal_rtl9603cvd_gpon_dbruBlockSize_set,
    .gpon_usLaserDefault_get = NULL,
    .gpon_flowctrl_adjust_byFlowNum = dal_rtl9603cvd_gpon_flowctrl_adjust_byFlowNum,
    .gpon_autoDG_set = dal_rtl9603cvd_gpon_autoDG_set,
    .gpon_autoDG_get = dal_rtl9603cvd_gpon_autoDG_get,
    .gpon_DgCnt_get = dal_rtl9603cvd_gpon_DgCnt_get,
    .gpon_DgThreshold_set = dal_rtl9603cvd_gpon_DgThreshold_set,
    .gpon_DgThreshold_get = dal_rtl9603cvd_gpon_DgThreshold_get,

    /* EPON */
    .epon_init = dal_rtl9603cvd_epon_init,
    .epon_intrMask_get = dal_rtl9603cvd_epon_intrMask_get,
    .epon_intrMask_set = dal_rtl9603cvd_epon_intrMask_set,
    .epon_intr_get = dal_rtl9603cvd_epon_intr_get,
    .epon_intr_disableAll = dal_rtl9603cvd_epon_intr_disableAll,
    .epon_llid_entry_set = dal_rtl9603cvd_epon_llid_entry_set,
    .epon_llid_entry_get = dal_rtl9603cvd_epon_llid_entry_get,
    .epon_forceLaserState_set = dal_rtl9603cvd_epon_forceLaserState_set,
    .epon_forceLaserState_get = dal_rtl9603cvd_epon_forceLaserState_get,
    .epon_laserTime_set = dal_rtl9603cvd_epon_laserTime_set,
    .epon_laserTime_get = dal_rtl9603cvd_epon_laserTime_get,
    .epon_syncTime_get = dal_rtl9603cvd_epon_syncTime_get,
    .epon_registerReq_get = dal_rtl9603cvd_epon_registerReq_get,
    .epon_registerReq_set = dal_rtl9603cvd_epon_registerReq_set,
    .epon_churningKey_set = dal_rtl9603cvd_epon_churningKey_set,
    .epon_churningKey_get = dal_rtl9603cvd_epon_churningKey_get,
    .epon_usFecState_get = dal_rtl9603cvd_epon_usFecState_get,
    .epon_usFecState_set = dal_rtl9603cvd_epon_usFecState_set,
    .epon_dsFecState_get = dal_rtl9603cvd_epon_dsFecState_get,
    .epon_dsFecState_set = dal_rtl9603cvd_epon_dsFecState_set,
    .epon_mibCounter_get = dal_rtl9603cvd_epon_mibCounter_get,
    .epon_mibGlobal_reset = dal_rtl9603cvd_epon_mibGlobal_reset,
    .epon_mibLlidIdx_reset = dal_rtl9603cvd_epon_mibLlidIdx_reset,
    .epon_losState_get = dal_rtl9603cvd_epon_losState_get,
    .epon_mpcpTimeoutVal_get = dal_rtl9603cvd_epon_mpcpTimeoutVal_get,
    .epon_mpcpTimeoutVal_set = dal_rtl9603cvd_epon_mpcpTimeoutVal_set,
    .epon_opticalPolarity_set = dal_rtl9603cvd_epon_opticalPolarity_set,
    .epon_opticalPolarity_get = dal_rtl9603cvd_epon_opticalPolarity_get,
    .epon_fecState_get = NULL,
    .epon_fecState_set = NULL,
    .epon_llidEntryNum_get = dal_rtl9603cvd_epon_llidEntryNum_get,
    .epon_thresholdReport_set = dal_rtl9603cvd_epon_thresholdReport_set,
    .epon_thresholdReport_get = dal_rtl9603cvd_epon_thresholdReport_get,
    .epon_dbgInfo_get = dal_rtl9603cvd_epon_dbgInfo_get,
    .epon_multiLlidMode_set = dal_rtl9603cvd_epon_multiLlidMode_set,
    .epon_multiLlidMode_get = dal_rtl9603cvd_epon_multiLlidMode_get,
    .epon_reportQueueSet_set = dal_rtl9603cvd_epon_reportQueueSet_set,
    .epon_reportQueueSet_get = dal_rtl9603cvd_epon_reportQueueSet_get,
    .epon_queueThresholdReport_set = dal_rtl9603cvd_epon_queueThresholdReport_set,
    .epon_queueThresholdReport_get = dal_rtl9603cvd_epon_queueThresholdReport_get,
    .epon_autoPowerSavingState_get = dal_rtl9603cvd_epon_autoPowerSavingState_get,
    .epon_autoPowerSavingState_set = dal_rtl9603cvd_epon_autoPowerSavingState_set,
    .epon_autoPowerSavingOeRecoverTime_get = dal_rtl9603cvd_epon_autoPowerSavingOeRecoverTime_get,
    .epon_autoPowerSavingOeRecoverTime_set = dal_rtl9603cvd_epon_autoPowerSavingOeRecoverTime_set,
    .epon_forcePRBS_set = dal_rtl9603cvd_epon_forcePRBS_set,
    .epon_forcePRBS_get = dal_rtl9603cvd_epon_forcePRBS_get,
    .epon_info_notify_callback_register = dal_rtl9603cvd_epon_info_notify_callback_register,
    .epon_mpcpTimeout_get = dal_rtl9603cvd_epon_mpcpTimeout_get,
    .epon_mpcpTimeout_set = dal_rtl9603cvd_epon_mpcpTimeout_set,


    
    /*PON MAC*/
    .ponmac_init = dal_rtl9603cvd_ponmac_init,
    .ponmac_queue_add = dal_rtl9603cvd_ponmac_queue_add,
    .ponmac_queue_get = dal_rtl9603cvd_ponmac_queue_get,
    .ponmac_queue_del = dal_rtl9603cvd_ponmac_queue_del,
    .ponmac_flow2Queue_set = dal_rtl9603cvd_ponmac_flow2Queue_set,
    .ponmac_flow2Queue_get = dal_rtl9603cvd_ponmac_flow2Queue_get,
    .ponmac_mode_get = dal_rtl9603cvd_ponmac_mode_get,
    .ponmac_mode_set = dal_rtl9603cvd_ponmac_mode_set,
    .ponmac_queueDrainOut_set  = dal_rtl9603cvd_ponmac_queueDrainOut_set,
    .ponmac_opticalPolarity_get = dal_rtl9603cvd_ponmac_opticalPolarity_get,
    .ponmac_opticalPolarity_set = dal_rtl9603cvd_ponmac_opticalPolarity_set,

    .ponmac_losState_get = dal_rtl9603cvd_ponmac_losState_get,
    .ponmac_serdesCdr_reset = dal_rtl9603cvd_ponmac_serdesCdr_reset,
    .ponmac_linkState_get = dal_rtl9603cvd_ponmac_linkState_get,

    .ponmac_forceBerNotify_set = NULL,
    .ponmac_bwThreshold_set = NULL,
    .ponmac_bwThreshold_get = NULL,
    .ponmac_maxPktLen_set = dal_rtl9603cvd_ponmac_maxPktLen_set,
    .ponmac_sidValid_get = dal_rtl9603cvd_ponmac_sidValid_get,
    .ponmac_sidValid_set = dal_rtl9603cvd_ponmac_sidValid_set,
    .ponmac_schedulingType_get = dal_rtl9603cvd_ponmac_schedulingType_get,
    .ponmac_schedulingType_set = dal_rtl9603cvd_ponmac_schedulingType_set,
    .ponmac_egrBandwidthCtrlRate_get = dal_rtl9603cvd_ponmac_egrBandwidthCtrlRate_get,
    .ponmac_egrBandwidthCtrlRate_set = dal_rtl9603cvd_ponmac_egrBandwidthCtrlRate_set,
    .ponmac_egrScheduleIdRate_get = dal_rtl9603cvd_ponmac_egrScheduleIdRate_get,
    .ponmac_egrScheduleIdRate_set = dal_rtl9603cvd_ponmac_egrScheduleIdRate_set,
    .ponmac_egrBandwidthCtrlIncludeIfg_get = dal_rtl9603cvd_ponmac_egrBandwidthCtrlIncludeIfg_get,
    .ponmac_egrBandwidthCtrlIncludeIfg_set = dal_rtl9603cvd_ponmac_egrBandwidthCtrlIncludeIfg_set,
    .ponmac_egrScheduleIdIncludeIfg_get = dal_rtl9603cvd_ponmac_egrScheduleIdIncludeIfg_get,
    .ponmac_egrScheduleIdIncludeIfg_set = dal_rtl9603cvd_ponmac_egrScheduleIdIncludeIfg_set,
    .ponmac_aggTcontState_get = dal_rtl9603cvd_ponmac_aggTcontState_get,
    .ponmac_aggTcontState_set = dal_rtl9603cvd_ponmac_aggTcontState_set,
	.ponmac_txDisableGpio_get = dal_rtl9603cvd_ponmac_txDisableGpio_get,
	.ponmac_txDisableGpio_set = dal_rtl9603cvd_ponmac_txDisableGpio_set,



    /*gpio function*/
    .gpio_init = dal_rtl9603cvd_gpio_init,
    .gpio_state_set = dal_rtl9603cvd_gpio_state_set,
    .gpio_state_get = dal_rtl9603cvd_gpio_state_get,
    .gpio_mode_set = dal_rtl9603cvd_gpio_mode_set,
    .gpio_mode_get = dal_rtl9603cvd_gpio_mode_get,
    .gpio_databit_get = dal_rtl9603cvd_gpio_databit_get,
    .gpio_databit_set = dal_rtl9603cvd_gpio_databit_set,
    .gpio_intr_get = dal_rtl9603cvd_gpio_intr_get,
    .gpio_intr_set = dal_rtl9603cvd_gpio_intr_set,
    .gpio_intrStatus_get = dal_rtl9603cvd_gpio_intrStatus_get,
    .gpio_intrStatus_clean = dal_rtl9603cvd_gpio_intrStatus_clean,


#if 0
    /* L34 Function */
    .l34_init = dal_rtl9603cvd_l34_init,
    .l34_netifTable_set = dal_rtl9603cvd_l34_netifTable_set,
    .l34_netifTable_get = dal_rtl9603cvd_l34_netifTable_get,
    .l34_arpTable_set = dal_rtl9603cvd_l34_arpTable_set,
    .l34_arpTable_get = dal_rtl9603cvd_l34_arpTable_get,
    .l34_arpTable_del = dal_rtl9603cvd_l34_arpTable_del,
    .l34_pppoeTable_set = dal_rtl9603cvd_l34_pppoeTable_set,
    .l34_pppoeTable_get = dal_rtl9603cvd_l34_pppoeTable_get,
    .l34_routingTable_set = dal_rtl9603cvd_l34_routingTable_set,
    .l34_routingTable_get = dal_rtl9603cvd_l34_routingTable_get,
    .l34_routingTable_del = dal_rtl9603cvd_l34_routingTable_del,
    .l34_nexthopTable_set = dal_rtl9603cvd_l34_nexthopTable_set,
    .l34_nexthopTable_get = dal_rtl9603cvd_l34_nexthopTable_get,
    .l34_extIntIPTable_set = dal_rtl9603cvd_l34_extIntIPTable_set,
    .l34_extIntIPTable_get = dal_rtl9603cvd_l34_extIntIPTable_get,
    .l34_extIntIPTable_del = dal_rtl9603cvd_l34_extIntIPTable_del,
    .l34_naptInboundTable_set = dal_rtl9603cvd_l34_naptInboundTable_set,
    .l34_naptInboundTable_get = dal_rtl9603cvd_l34_naptInboundTable_get,
    .l34_naptOutboundTable_set = dal_rtl9603cvd_l34_naptOutboundTable_set,
    .l34_naptOutboundTable_get = dal_rtl9603cvd_l34_naptOutboundTable_get,
    .l34_ipmcTransTable_set = dal_rtl9603cvd_l34_ipmcTransTable_set,
    .l34_ipmcTransTable_get = dal_rtl9603cvd_l34_ipmcTransTable_get,
    .l34_table_reset = dal_rtl9603cvd_l34_table_reset,
    .l34_bindingTable_set = dal_rtl9603cvd_l34_bindingTable_set,
    .l34_bindingTable_get = dal_rtl9603cvd_l34_bindingTable_get,
    .l34_bindingAction_set = dal_rtl9603cvd_l34_bindingAction_set,
    .l34_bindingAction_get = dal_rtl9603cvd_l34_bindingAction_get,
    .l34_wanTypeTable_set = dal_rtl9603cvd_l34_wanTypeTable_set,
    .l34_wanTypeTable_get = dal_rtl9603cvd_l34_wanTypeTable_get,
    .l34_ipv6RoutingTable_set = dal_rtl9603cvd_l34_ipv6RoutingTable_set,
    .l34_ipv6RoutingTable_get = dal_rtl9603cvd_l34_ipv6RoutingTable_get,
    .l34_ipv6NeighborTable_set = dal_rtl9603cvd_l34_ipv6NeighborTable_set,
    .l34_ipv6NeighborTable_get = dal_rtl9603cvd_l34_ipv6NeighborTable_get,

    .l34_hsabMode_set = dal_rtl9603cvd_l34_hsbaMode_set,
    .l34_hsabMode_get = dal_rtl9603cvd_l34_hsbaMode_get,
    .l34_hsaData_get = dal_rtl9603cvd_l34_hsaData_get,
    .l34_hsbData_get = dal_rtl9603cvd_l34_hsbData_get,
    .l34_portWanMap_set = dal_rtl9603cvd_l34_portWanMap_set,
    .l34_portWanMap_get = dal_rtl9603cvd_l34_portWanMap_get,
    .l34_globalState_set = dal_rtl9603cvd_l34_globalState_set,
    .l34_globalState_get = dal_rtl9603cvd_l34_globalState_get,
    .l34_lookupMode_set = dal_rtl9603cvd_l34_lookupMode_set,
    .l34_lookupMode_get = dal_rtl9603cvd_l34_lookupMode_get,
    .l34_lookupPortMap_set = NULL,
    .l34_lookupPortMap_get = NULL,
    .l34_wanRoutMode_set = dal_rtl9603cvd_l34_wanRoutMode_set,
    .l34_wanRoutMode_get = dal_rtl9603cvd_l34_wanRoutMode_get,
    .l34_arpTrfIndicator_get = dal_rtl9603cvd_l34_arpTrfIndicator_get,
    .l34_arpTrfTb_get = NULL,
    .l34_hwArpTrfWrkTbl_Clear = NULL,
    .l34_arpTrfIndicator_get_all = NULL,
    .l34_hwArpTrfWrkTbl_set = NULL,
    .l34_hwArpTrfWrkTbl_get = NULL,
    .l34_naptTrfIndicator_get = dal_rtl9603cvd_l34_naptTrfIndicator_get,
    .l34_naptTrfIndicator_get_all = NULL,
    .l34_hwL4TrfWrkTbl_set = NULL,
    .l34_hwL4TrfWrkTbl_get = NULL,
    .l34_l4TrfTb_get = NULL,
    .l34_hwL4TrfWrkTbl_Clear = NULL,
    .l34_pppTrfIndicator_get = dal_rtl9603cvd_l34_pppTrfIndicator_get,
    .l34_neighTrfIndicator_get = dal_rtl9603cvd_l34_neighTrfIndicator_get,
    .l34_flowRouteTable_set = dal_rtl9603cvd_l34_flowRouteTable_set,
    .l34_flowRouteTable_get = dal_rtl9603cvd_l34_flowRouteTable_get,
    .l34_flowTrfIndicator_get = dal_rtl9603cvd_l34_flowTrfIndicator_get,
    .l34_hsdState_set = dal_rtl9603cvd_l34_hsdState_set,
    .l34_hsdState_get = dal_rtl9603cvd_l34_hsdState_get,

    .l34_ip6mcRoutingTransIdx_set = dal_rtl9603cvd_l34_ip6mcRoutingTransIdx_set,
    .l34_ip6mcRoutingTransIdx_get = dal_rtl9603cvd_l34_ip6mcRoutingTransIdx_get,
    .l34_dsliteInfTable_set = dal_rtl9603cvd_l34_dsliteInfTable_set,
    .l34_dsliteInfTable_get = dal_rtl9603cvd_l34_dsliteInfTable_get,
    .l34_dsliteMcTable_set = dal_rtl9603cvd_l34_dsliteMcTable_set,
    .l34_dsliteMcTable_get = dal_rtl9603cvd_l34_dsliteMcTable_get,
    .l34_dsliteControl_set = dal_rtl9603cvd_l34_dsliteControl_set,
    .l34_dsliteControl_get = dal_rtl9603cvd_l34_dsliteControl_get,
    .l34_mib_get = dal_rtl9603cvd_l34_mib_get,
    .l34_mib_reset = dal_rtl9603cvd_l34_mib_reset,
    .l34_lutLookupMiss_set = dal_rtl9603cvd_l34_lutLookupMiss_set,
    .l34_lutLookupMiss_get = dal_rtl9603cvd_l34_lutLookupMiss_get,

    /* STP */
    .stp_init = dal_rtl9603cvd_stp_init,
    .stp_mstpState_get = dal_rtl9603cvd_stp_mstpState_get,
    .stp_mstpState_set = dal_rtl9603cvd_stp_mstpState_set,


    /* Trunk */
    .trunk_init                                 = dal_rtl9603cvd_trunk_init,
    .trunk_distributionAlgorithm_get            = dal_rtl9603cvd_trunk_distributionAlgorithm_get,
    .trunk_distributionAlgorithm_set            = dal_rtl9603cvd_trunk_distributionAlgorithm_set,
    .trunk_port_get                             = dal_rtl9603cvd_trunk_port_get,
    .trunk_port_set                             = dal_rtl9603cvd_trunk_port_set,
    .trunk_hashMappingTable_get                 = dal_rtl9603cvd_trunk_hashMappingTable_get,
    .trunk_hashMappingTable_set                 = dal_rtl9603cvd_trunk_hashMappingTable_set,
    .trunk_mode_get                             = dal_rtl9603cvd_trunk_mode_get,
    .trunk_mode_set                             = dal_rtl9603cvd_trunk_mode_set,
    .trunk_trafficSeparate_get                  = dal_rtl9603cvd_trunk_trafficSeparate_get,
    .trunk_trafficSeparate_set                  = dal_rtl9603cvd_trunk_trafficSeparate_set,
    .trunk_portQueueEmpty_get                   = dal_rtl9603cvd_trunk_portQueueEmpty_get,
    .trunk_trafficPause_get                     = dal_rtl9603cvd_trunk_trafficPause_get,
    .trunk_trafficPause_set                     = dal_rtl9603cvd_trunk_trafficPause_set,
#endif


#if 0 /*RTL9603CVD remove RLPP feature*/
    /* RLDP and RLPP */
    .rldp_init = dal_rtl9603cvd_rldp_init,
    .rldp_config_set = dal_rtl9603cvd_rldp_config_set,
    .rldp_config_get = dal_rtl9603cvd_rldp_config_get,
    .rldp_portConfig_set = dal_rtl9603cvd_rldp_portConfig_set,
    .rldp_portConfig_get = dal_rtl9603cvd_rldp_portConfig_get,
    .rldp_status_get = dal_rtl9603cvd_rldp_status_get,
    .rldp_portStatus_get = dal_rtl9603cvd_rldp_portStatus_get,
    .rldp_portStatus_clear = dal_rtl9603cvd_rldp_portStatus_clear,
    .rlpp_init = NULL,
    .rlpp_trapType_set = NULL,
    .rlpp_trapType_get = NULL,
#endif

    /*led*/
    .led_init               = dal_rtl9603cvd_led_init,
    .led_operation_get      = dal_rtl9603cvd_led_operation_get,
    .led_operation_set      = dal_rtl9603cvd_led_operation_set,
    .led_serialMode_get     = dal_rtl9603cvd_led_serialMode_get,
    .led_serialMode_set     = dal_rtl9603cvd_led_serialMode_set,
    .led_blinkRate_get      = dal_rtl9603cvd_led_blinkRate_get,
    .led_blinkRate_set      = dal_rtl9603cvd_led_blinkRate_set,
    .led_config_set         = dal_rtl9603cvd_led_config_set,
    .led_config_get         = dal_rtl9603cvd_led_config_get,
    .led_modeForce_get      = dal_rtl9603cvd_led_modeForce_get,
    .led_modeForce_set      = dal_rtl9603cvd_led_modeForce_set,
    .led_parallelEnable_get = dal_rtl9603cvd_led_parallelEnable_get,
    .led_parallelEnable_set = dal_rtl9603cvd_led_parallelEnable_set,
    .led_ponAlarm_get       = dal_rtl9603cvd_led_ponAlarm_get,
    .led_ponAlarm_set       = dal_rtl9603cvd_led_ponAlarm_set,
    .led_ponWarning_get     = dal_rtl9603cvd_led_ponWarning_get,
    .led_ponWarning_set     = dal_rtl9603cvd_led_ponWarning_set,
    .led_parallelMode_get   = dal_rtl9603cvd_led_parallelMode_get,
    .led_parallelMode_set   = dal_rtl9603cvd_led_parallelMode_set,

    /* I2C */
    .i2c_init = dal_rtl9603cvd_i2c_init,
    .i2c_enable_set = dal_rtl9603cvd_i2c_enable_set,
    .i2c_enable_get = dal_rtl9603cvd_i2c_enable_get,
    .i2c_width_set = dal_rtl9603cvd_i2c_width_set,
    .i2c_width_get = dal_rtl9603cvd_i2c_width_get,
    .i2c_write = dal_rtl9603cvd_i2c_write,
    .i2c_seq_write = dal_rtl9603cvd_i2c_seq_write,
    .i2c_read = dal_rtl9603cvd_i2c_read,
    .i2c_seq_read = dal_rtl9603cvd_i2c_seq_read,
    .i2c_curr_read = dal_rtl9603cvd_i2c_curr_read,
    .i2c_seqCurr_read = dal_rtl9603cvd_i2c_seqCurr_read,
    .i2c_clock_set = dal_rtl9603cvd_i2c_clock_set,
    .i2c_clock_get = dal_rtl9603cvd_i2c_clock_get,
    .i2c_addrWidth_set = dal_rtl9603cvd_i2c_addrWidth_set,
    .i2c_addrWidth_get = dal_rtl9603cvd_i2c_addrWidth_get,
    .i2c_dataWidth_set = dal_rtl9603cvd_i2c_dataWidth_set,
    .i2c_dataWidth_get = dal_rtl9603cvd_i2c_dataWidth_get,

    .ppstod_init = dal_rtl9603cvd_ppstod_init,
    .ppstod_delay_get = dal_rtl9603cvd_ppstod_delay_get,
    .ppstod_delay_set = dal_rtl9603cvd_ppstod_delay_set,
    .ppstod_pulseWidth_get = dal_rtl9603cvd_ppstod_pulseWidth_get,
    .ppstod_pulseWidth_set = dal_rtl9603cvd_ppstod_pulseWidth_set,
    .ppstod_mode_get = dal_rtl9603cvd_ppstod_mode_get,
    .ppstod_mode_set = dal_rtl9603cvd_ppstod_mode_set,
    .ppstod_sarpGpsWeek_get = dal_rtl9603cvd_ppstod_sarpGpsWeek_get,
    .ppstod_sarpGpsWeek_set = dal_rtl9603cvd_ppstod_sarpGpsWeek_set,
    .ppstod_sarpUtcSec_get = dal_rtl9603cvd_ppstod_sarpUtcSec_get,
    .ppstod_sarpUtcSec_set = dal_rtl9603cvd_ppstod_sarpUtcSec_set,
    .ppstod_frameLen_get = dal_rtl9603cvd_ppstod_frameLen_get,
    .ppstod_frameLen_set = dal_rtl9603cvd_ppstod_frameLen_set,
    .ppstod_frameData_get = dal_rtl9603cvd_ppstod_frameData_get,
    .ppstod_frameData_set = dal_rtl9603cvd_ppstod_frameData_set,
    .ppstod_baudrate_get = dal_rtl9603cvd_ppstod_baudrate_get,
    .ppstod_baudrate_set = dal_rtl9603cvd_ppstod_baudrate_set,

    /* PBO */
    /* PON PBO */
    .pbo_init = dal_rtl9603cvd_pbo_init,
    /* Switch PBO */
    .swPbo_init = dal_rtl9603cvd_swPbo_init,
    .swPbo_portState_set = dal_rtl9603cvd_swPbo_portState_set,
    .swPbo_portState_get = dal_rtl9603cvd_swPbo_portState_get,
    .swPbo_portAutoConf_set = dal_rtl9603cvd_swPbo_portAutoConf_set,
    .swPbo_portAutoConf_get = dal_rtl9603cvd_swPbo_portAutoConf_get,
    .swPbo_portThreshold_set = dal_rtl9603cvd_swPbo_portThreshold_set,
    .swPbo_portThreshold_get = dal_rtl9603cvd_swPbo_portThreshold_get,
    .swPbo_queueThreshold_set = dal_rtl9603cvd_swPbo_queueThreshold_set,
    .swPbo_queueThreshold_get = dal_rtl9603cvd_swPbo_queueThreshold_get,
    .swPbo_portUsedPageCount_get = dal_rtl9603cvd_swPbo_portUsedPageCount_get,
    .swPbo_portUsedPageCount_clear = dal_rtl9603cvd_swPbo_portUsedPageCount_clear,
    .swPbo_queueUsedPageCount_get = dal_rtl9603cvd_swPbo_queueUsedPageCount_get,
    .swPbo_queueUsedPageCount_clear = dal_rtl9603cvd_swPbo_queueUsedPageCount_clear,
    .swPbo_portDscCount_get = dal_rtl9603cvd_swPbo_portDscCount_get,
    .swPbo_portDscCount_clear = dal_rtl9603cvd_swPbo_portDscCount_clear,

#if 0
    /*MDIO*/
    .mdio_init = dal_rtl9603cvd_mdio_init,
    .mdio_cfg_set = dal_rtl9603cvd_mdio_cfg_set,
    .mdio_cfg_get = dal_rtl9603cvd_mdio_cfg_get,
    .mdio_c22_write = dal_rtl9603cvd_mdio_c22_write,
    .mdio_c22_read = dal_rtl9603cvd_mdio_c22_read,
    .mdio_c45_write = dal_rtl9603cvd_mdio_c45_write,
    .mdio_c45_read = dal_rtl9603cvd_mdio_c45_read,
#endif

};

/*
 * Macro Declaration
 */

/*
 * Function Declaration
 */
static int32 dal_rtl9603cvd_fakeInit(void)
{
    return RT_ERR_OK;
}


/* Module Name    :  */

/* Function Name:
 *      dal_rtl9603cvd_init
 * Description:
 *      Initilize DAL of smart switch
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK     - initialize success
 *      RT_ERR_FAILED - initialize fail
 * Note:
 *      RTK must call this function before do other kind of action.
 */
int32 dal_rtl9603cvd_init(void)
{
    return RT_ERR_OK;
} /* end of dal_rtl9603cvd_init */



/* Function Name:
 *      dal_rtl9603cvd_mapper_get
 * Description:
 *      Get DAL mapper function
 * Input:
 *      None
 * Output:
 *      None
 * Return:
 *      dal_mapper_t *     - mapper pointer
 * Note:
 */
dal_mapper_t *dal_rtl9603cvd_mapper_get(void)
{

    return &dal_rtl9603cvd_mapper;
} /* end of dal_rtl9603cvd_mapper_get */

