/*
 * Copyright (C) 2018 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 *
 *
 * $Revision: $
 * $Date: $
 *
 * Purpose : EPON kernel drivers
 *
 * Feature : This module install EPON kernel callbacks and other 
 * kernel functions
 *
 */

#ifdef CONFIG_10G_EPON_FEATURE
/*
 * Include Files
 */
#include <linux/module.h> 
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/seq_file.h>

#include "ca_rtk_epon_drv_main.h"

#define BD_OAM_NUM 2
//rx
unsigned char OAM_RX_LEN[BD_OAM_NUM] = {60,60};
unsigned char OAM_RX[BD_OAM_NUM][MAX_S_OAM_SIZE]={
    {
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x84, 0x79, 0x73, 0xe4, 0x00, 0x3a, 0x88, 0x09, 0x03, 0x00, 
        0x08, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x05, 0xee, 0x00, 0x13, 0x25, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x84, 0x79, 0x73, 0xe4, 0x00, 0x3a, 0x88, 0x09, 0x03, 0x00, 
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x05, 0xee, 0x00, 0x13, 0x25, 0x00, 0x00, 
        0x00, 0x00, 0x02, 0x10, 0x01, 0x00, 0x01, 0x00, 0x14, 0x05, 0xee, 0x00, 0x13, 0x25, 0x52, 0x54, 
        0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
};
//tx
unsigned char OAM_TX_LEN[BD_OAM_NUM] = {60,60};
unsigned char OAM_TX[BD_OAM_NUM][MAX_S_OAM_SIZE]={
    {
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x10, 0x88, 0x09, 0x03, 0x00,
        0x30, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x00, 0x14, 0x05, 0xee, 0x00, 0x13, 0x25, 0x52, 0x54,
        0x4b, 0x00, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x05, 0xee, 0x00, 0x13, 0x25, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x10, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x00, 0x14, 0x05, 0xee, 0x00, 0x13, 0x25, 0x52, 0x54,
        0x4b, 0x00, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0f, 0x05, 0xee, 0x00, 0x13, 0x25, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
};
#if 0
#define C300_OAM_NUM 3
unsigned char OAM_RX_LEN[C300_OAM_NUM] = {60,60,81};
unsigned char OAM_RX[C300_OAM_NUM][MAX_S_OAM_SIZE]={
    {/*1*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x08, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*2*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00, 0x02, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*3*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x05, 0xdc, 0x00, 0x0f, 0x3e, 0x52, 0x01,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x05, 0xee, 0xff, 0xff, 0xff, 0x00, 0x00,
        0x00, 0x00, 0xfe, 0x1f, 0x11, 0x11, 0x11, 0x01, 0x01, 0x11, 0x11, 0x11, 0x30, 0x11, 0x11, 0x11,
        0x21, 0x11, 0x11, 0x11, 0xaa, 0x11, 0x11, 0x11, 0x20, 0x11, 0x11, 0x11, 0x13, 0x11, 0x11, 0x11,
        0x01,
    },
};
unsigned char OAM_TX_LEN[C300_OAM_NUM] = {50,50,50};
unsigned char OAM_TX[C300_OAM_NUM][MAX_S_OAM_SIZE]={
    {/*1*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x30, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00,
    },
    {/*2*/

        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00,
    },
    {/*3*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x05, 0xdc, 0x00, 0x0f, 0x3e, 0x52, 0x01,
        0x00, 0x01,
    },
};
#endif

#if 0
#define C300_OAM_NUM 16
unsigned char OAM_RX_LEN[C300_OAM_NUM] = {60,60,81,60,60,60,60,60,60,60,60,60,60,60,60};
unsigned char OAM_RX[C300_OAM_NUM][MAX_S_OAM_SIZE]={
    {/*1*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x08, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*2*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00, 0x02, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*3*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x05, 0xdc, 0x00, 0x0f, 0x3e, 0x52, 0x01,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x05, 0xee, 0xff, 0xff, 0xff, 0x00, 0x00,
        0x00, 0x00, 0xfe, 0x1f, 0x11, 0x11, 0x11, 0x01, 0x01, 0x11, 0x11, 0x11, 0x30, 0x11, 0x11, 0x11,
        0x21, 0x11, 0x11, 0x11, 0xaa, 0x11, 0x11, 0x11, 0x20, 0x11, 0x11, 0x11, 0x13, 0x11, 0x11, 0x11,
        0x01,
    },
    {/*4*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x05, 0xdc, 0x00, 0x0f, 0x3e, 0x52, 0x01,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00, 0xfe, 0x07, 0x11, 0x11, 0x11, 0x01, 0x30, 0x00, 0x00, 0x00,
    },
    {/*5*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x01, 0xc7, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*6*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x01, 0xc7, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*7*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x01, 0xc7, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*8*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x01, 0xc7, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*9*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x03, 0xc7, 0x80, 0x24, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*10*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x01, 0xc7, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*11*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x01, 0xc7, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*12*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x03, 0x07, 0x01, 0x3a, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*13*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x03, 0xc7, 0x80, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*14*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x03, 0xc7, 0x80, 0x08, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*15*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x03, 0x37, 0x00, 0x01, 0x04, 0x01, 0x00, 0x00, 0x01, 0xc7, 0x00,
        0x12, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*16*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0xd0, 0xd0, 0x9d, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x03, 0x37, 0x00, 0x01, 0x04, 0x01, 0x00, 0x00, 0x02, 0xc7, 0x00,
        0x12, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
};
unsigned char OAM_TX_LEN[C300_OAM_NUM] = {50,50,81,57,60,82,60,60,60,60,60,60,60,60,60,60};
unsigned char OAM_TX[C300_OAM_NUM][MAX_S_OAM_SIZE]={
    {/*1*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x30, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00,
    },
    {/*2*/

        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x1f, 0x05, 0xee, 0x11, 0x11, 0x11, 0x00, 0x00,
        0x00, 0x00,
    },
    {/*3*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x05, 0xdc, 0x00, 0x0f, 0x3e, 0x52, 0x01,
        0x00, 0x01, 0xfe, 0x1f, 0x11, 0x11, 0x11, 0x01, 0x00, 0x11, 0x11, 0x11, 0x01, 0x11, 0x11, 0x11,
        0x13, 0x11, 0x11, 0x11, 0x20, 0x11, 0x11, 0x11, 0x21, 0x11, 0x11, 0x11, 0x30, 0x11, 0x11, 0x11,
        0xc1,
    },
    {/*4*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x09, 0x03, 0x00,
        0x50, 0x00, 0x01, 0x10, 0x01, 0x00, 0x01, 0x06, 0x14, 0x05, 0xee, 0x00, 0x0d, 0xb6, 0x20, 0x00,
        0x00, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00, 0x0d, 0x05, 0xdc, 0x00, 0x0f, 0x3e, 0x52, 0x01,
        0x00, 0x01, 0xfe, 0x07, 0x11, 0x11, 0x11, 0x01, 0x30,
    },
    {/*5*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x02, 0xc7, 0x00, 0x07, 0x16, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
        0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*6*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x02, 0xc7, 0x00, 0x01, 0x36, 0x32, 0x30, 0x31, 0x31, 0x38, 0x31,
        0x30, 0x65, 0x00, 0x13, 0x25, 0xab, 0xcd, 0xef, 0x48, 0x47, 0x38, 0x31, 0x30, 0x65, 0x00, 0x00,
        0x56, 0x31, 0x30, 0x30, 0x52, 0x30, 0x30, 0x31, 0x43, 0x30, 0x31, 0x42, 0x30, 0x35, 0x32, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x31, 0x30, 0x65,
        0x00, 0x00,
    },
    {/*7*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x02, 0xc7, 0x00, 0x03, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*8*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x02, 0xc7, 0x00, 0x0c, 0x03, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*9*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x04, 0xc7, 0x80, 0x24, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*10*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x02, 0xc7, 0x00, 0x02, 0x0b, 0x30, 0x30, 0x2e, 0x30, 0x32, 0x2e,
        0x30, 0x35, 0x2e, 0x30, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*11*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x02, 0xc7, 0x00, 0x07, 0x16, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
        0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*12*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x04, 0x07, 0x01, 0x3a, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*13*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x04, 0xc7, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*14*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x04, 0xc7, 0x80, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*15*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x04, 0x37, 0x00, 0x01, 0x04, 0x01, 0x00, 0x00, 0x01, 0xc7, 0x00,
        0x12, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    {/*16*/
        0x01, 0x80, 0xc2, 0x00, 0x00, 0x02, 0x00, 0x13, 0x25, 0x00, 0x00, 0x01, 0x88, 0x09, 0x03, 0x00,
        0x50, 0xfe, 0x11, 0x11, 0x11, 0x04, 0x37, 0x00, 0x01, 0x04, 0x01, 0x00, 0x00, 0x02, 0xc7, 0x00,
        0x12, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
};
#endif

int __init ca_rtk_epon_test_init(void)
{
    int i,j;
    s_oam_t reg_oam;
    reg_oam.num = BD_OAM_NUM;
    for(i=0;i<reg_oam.num;i++)
    {
        reg_oam.rx_len[i] = OAM_RX_LEN[i];
        for(j=0;j<reg_oam.rx_len[i];j++)
            reg_oam.rx[i][j] = OAM_RX[i][j];

        reg_oam.tx_len[i] = OAM_TX_LEN[i];
        for(j=0;j<reg_oam.tx_len[i];j++)
            reg_oam.tx[i][j] = OAM_TX[i][j];
    }

    s_oam_register(&reg_oam);

    return 0;
}

void __exit ca_rtk_epon_test_exit(void)
{
    s_oam_unregister();
}

module_init(ca_rtk_epon_test_init);
module_exit(ca_rtk_epon_test_exit);
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("CA RealTek EPON test module");
MODULE_AUTHOR("Realtek");
#endif
