/*
 * Copyright (C) 2009 Realtek Semiconductor Corp.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Purpose : Realtek Switch SDK Rtdrv Netfilter Module in the SDK.
 *
 * Feature : Realtek Switch SDK Rtdrv Netfilter Module
 *
 */

#ifndef __RTDRV_NETFILTER_H__
#define __RTDRV_NETFILTER_H__

/*
 * Include Files
*/
#include <hal/mac/reg.h>
#include <rtk/acl.h>
#include <rtk/classify.h>
#include <rtk/cpu.h>
#include <rtk/debug.h>
#include <rtk/dot1x.h>
#include <rtk/intr.h>
#include <rtk/l2.h>
#include <rtk/led.h>
#include <rtk/mirror.h>
#include <rtk/oam.h>
#include <rtk/ponmac.h>
#include <rtk/port.h>
#include <rtk/qos.h>
#include <rtk/rate.h>
#include <rtk/rldp.h>
#include <rtk/sec.h>
#include <rtk/stat.h>
#include <rtk/stp.h>
#include <rtk/svlan.h>
#include <rtk/switch.h>
#include <rtk/trap.h>
#include <rtk/trunk.h>
#include <rtk/vlan.h>
#include <rtk/rtusr/rtusr_pkt.h>
#include <rtk/gpio.h>
#include <rtk/i2c.h>
#ifdef CONFIG_XDSL_RG_DIAGSHELL
#include <rtk_rg_xdsl_struct.h>
#else
#include <rtk/l34.h>
#include <rtk/l34lite.h>
#endif
#include <rtk/epon.h>
#include <rtk/time.h>
#include <rtk/pon_led.h>
#include <rtk/ppstod.h>
#include <rtk/pbo.h>
#include <rtk/mdio.h>

#if (CONFIG_GPON_VERSION == 1)
#include <rtk/gpon.h>
#else
#include <rtk/gponv2.h>
#include <module/gpon/gpon.h>
#endif

#if defined(CONFIG_EUROPA_FEATURE)
#include <rtk/ldd.h>
#endif

#if defined(CONFIG_COMMON_RT_API)
#include <rtk/rt/rt_switch.h>
#include <rtk/rt/rt_gpon.h>
#include <rtk/rt/rt_stat.h>
#include <rtk/rt/rt_rate.h>
#include <rtk/rt/rt_qos.h>
#include <rtk/rt/rt_intr.h>
#include <rtk/rt/rt_sec.h>
#include <rtk/rt/rt_trap.h>
#include <rtk/rt/rt_i2c.h>
#include <rtk/rt/rt_port.h>
#include <rtk/rt/rt_epon.h>
#include <rtk/rt/rt_cls.h>
#include <rtk/rt/rt_l2.h>
#include <rtk/rt/rt_ponmisc.h>
#include <rtk/rt/rt_mirror.h>
#if defined(CONFIG_RTK_L34_FLEETCONNTRACK_ENABLE) && defined(CONFIG_COMMON_RT_API)
#include <rtdrv_ext_netfilter.h>
#endif

#endif

#include "rtdrv_cmdoffset.h"

/***** RTDRV_SET *****/
#define RTDRV_INIT_RTKAPI                       (RTDRV_BASE_CTL)
#define RTDRV_SET_MAX                           (RTDRV_BASE_CTL + RTDRV_END_OFFSET)

enum rtdrv_reg_set_e
{
    RTDRV_REG_REGISTER_SET = (RTDRV_BASE_CTL + RTDRV_REG_OFFSET),
    RTDRV_TABLE_WRITE,
    RTDRV_REG_ADDRESS_SET,
    RTDRV_PHY_REG_SET,
    RTDRV_SOC_ADDRESS_SET
};

enum rtdrv_acl_set_e
{
    RTDRV_ACL_BASED_SET= (RTDRV_BASE_CTL + RTDRV_ACL_OFFSET + 1),
    RTDRV_ACL_INIT,
    RTDRV_ACL_TEMPLATE_SET,
    RTDRV_ACL_FIELDSELECT_SET,
    RTDRV_ACL_IGRRULEFIELD_ADD,
    RTDRV_ACL_IGRRULEENTRY_ADD,
    RTDRV_ACL_IGRRULEENTRY_DEL,
    RTDRV_ACL_IGRRULEENTRY_DELALL,
    RTDRV_ACL_IGRUNMATCHACTION_SET,
    RTDRV_ACL_IGRSTATE_SET,
    RTDRV_ACL_IPRANGE_SET,
    RTDRV_ACL_VIDRANGE_SET,
    RTDRV_ACL_PORTRANGE_SET,
    RTDRV_ACL_PACKETLENGTHRANGE_SET,
    RTDRV_ACL_IGRRULEMODE_SET,
    RTDRV_ACL_IGRPERMITSTATE_SET,
};

enum rtdrv_classify_set_e
{
    RTDRV_CLASSIFY_BASED_SET= (RTDRV_BASE_CTL + RTDRV_CLASSIFY_OFFSET + 1),
    RTDRV_CLASSIFY_INIT,
    RTDRV_CLASSIFY_CFGENTRY_ADD,
    RTDRV_CLASSIFY_CFGENTRY_DEL,
    RTDRV_CLASSIFY_FIELD_ADD,
    RTDRV_CLASSIFY_UNMATCHACTION_SET,
    RTDRV_CLASSIFY_UNMATCHACTION_DS_SET,
    RTDRV_CLASSIFY_PORTRANGE_SET,
    RTDRV_CLASSIFY_IPRANGE_SET,
    RTDRV_CLASSIFY_CFSEL_SET,
    RTDRV_CLASSIFY_CFPRI2DSCP_SET,
    RTDRV_CLASSIFY_PERMIT_SEL_SET,
    RTDRV_CLASSIFY_US1PREMARK_PRIOR_SET,
    RTDRV_CLASSIFY_TEMPLATECFGPATTERN0_SET,
    RTDRV_CLASSIFY_ENTRYNUMPATTERN1_SET,
    RTDRV_CLASSIFY_DEFAULTWANIF_SET,
    RTDRV_CLASSIFY_TRAPPRI_SET,

};

enum rtdrv_cpu_set_e
{
    RTDRV_CPU_BASED_SET= (RTDRV_BASE_CTL + RTDRV_CPU_OFFSET + 1),
    RTDRV_CPU_INIT,
    RTDRV_CPU_AWAREPORTMASK_SET,
    RTDRV_CPU_TAGFORMAT_SET,
    RTDRV_CPU_TRAPINSERTTAG_SET,
    RTDRV_CPU_TAGAWARE_SET,
    RTDRV_CPU_TRAPINSERTTAGBYPORT_SET,
    RTDRV_CPU_TAGAWAREBYPORT_SET,

};

enum rtdrv_debug_set_e
{
    RTDRV_DEBUG_BASED_SET= (RTDRV_BASE_CTL + RTDRV_DEBUG_OFFSET + 1),
    RTDRV_DEBUG_ADDRESS_DUMP_SET,
    RTDRV_DEBUG_EN_LOG_SET,
    RTDRV_DEBUG_LOGLV_SET,
    RTDRV_DEBUG_LOGLVMASK_SET,
    RTDRV_DEBUG_LOGTYPE_SET,
    RTDRV_DEBUG_LOGFORMAT_SET,
    RTDRV_DEBUG_MODMASK_SET,
};

enum rtdrv_dot1x_set_e
{
    RTDRV_DOT1X_BASED_SET= (RTDRV_BASE_CTL + RTDRV_DOT1X_OFFSET + 1),
    RTDRV_DOT1X_INIT,
    RTDRV_DOT1X_UNAUTHPACKETOPER_SET,
    RTDRV_DOT1X_PORTBASEDENABLE_SET,
    RTDRV_DOT1X_PORTBASEDAUTHSTATUS_SET,
    RTDRV_DOT1X_PORTBASEDDIRECTION_SET,
    RTDRV_DOT1X_MACBASEDENABLE_SET,
    RTDRV_DOT1X_MACBASEDDIRECTION_SET,
    RTDRV_DOT1X_GUESTVLAN_SET,
    RTDRV_DOT1X_GUESTVLANBEHAVIOR_SET,
    RTDRV_DOT1X_TRAPPRI_SET,
};

enum rtdrv_intr_set_e
{
    RTDRV_INTR_BASED_SET= (RTDRV_BASE_CTL + RTDRV_INTR_OFFSET + 1),
    RTDRV_INTR_INIT,
    RTDRV_INTR_POLARITY_SET,
    RTDRV_INTR_IMR_SET,
    RTDRV_INTR_IMS_CLEAR,
    RTDRV_INTR_SPEEDCHANGESTATUS_CLEAR,
    RTDRV_INTR_LINKUPSTATUS_CLEAR,
    RTDRV_INTR_LINKDOWNSTATUS_CLEAR,
    RTDRV_INTR_GPHYSTATUS_CLEAR,
    RTDRV_INTR_IMR_RESTORE,
    RTDRV_INTR_ISR_SET,
    RTDRV_INTR_LINKUPPORTSTATUS_CLEAR,
    RTDRV_INTR_LINKDOWNPORTSTATUS_CLEAR,
};

enum rtdrv_l2_set_e
{
    RTDRV_L2_BASED_SET= (RTDRV_BASE_CTL + RTDRV_L2_OFFSET + 1),
    RTDRV_L2_INIT,
    RTDRV_L2_FLUSHLINKDOWNPORTADDRENABLE_SET,
    RTDRV_L2_TABLE_CLEAR,
    RTDRV_L2_LIMITLEARNINGOVERSTATUS_CLEAR,
    RTDRV_L2_LIMITLEARNINGCNT_SET,
    RTDRV_L2_LIMITLEARNINGCNTACTION_SET,
    RTDRV_L2_LIMITLEARNINGPORTMASK_SET,
    RTDRV_L2_PORTLIMITLEARNINGOVERSTATUS_CLEAR,
    RTDRV_L2_PORTLIMITLEARNINGCNT_SET,
    RTDRV_L2_PORTLIMITLEARNINGCNTACTION_SET,
    RTDRV_L2_AGING_SET,
    RTDRV_L2_PORTAGINGENABLE_SET,
    RTDRV_L2_LOOKUPMISSACTION_SET,
    RTDRV_L2_PORTLOOKUPMISSACTION_SET,
    RTDRV_L2_LOOKUPMISSFLOODPORTMASK_SET,
    RTDRV_L2_LOOKUPMISSFLOODPORTMASK_ADD,
    RTDRV_L2_LOOKUPMISSFLOODPORTMASK_DEL,
    RTDRV_L2_NEWMACOP_SET,
    RTDRV_L2_ADDR_ADD,
    RTDRV_L2_ADDR_DEL,
    RTDRV_L2_ADDR_DELALL,
    RTDRV_L2_MCASTADDR_ADD,
    RTDRV_L2_MCASTADDR_DEL,
    RTDRV_L2_ILLEGALPORTMOVEACTION_SET,
    RTDRV_L2_IPMCMODE_SET,
    RTDRV_L2_IPMCVLANMODE_SET,
    RTDRV_L2_IPV6MCMODE_SET,
    RTDRV_L2_IPMCGROUPLOOKUPMISSHASH_SET,
    RTDRV_L2_IPMCGROUP_ADD,
    RTDRV_L2_IPMCGROUPEXT_ADD,
    RTDRV_L2_IPMCGROUPEXTIDX_ADD,
    RTDRV_L2_IPMCGROUP_DEL,
    RTDRV_L2_PORTIPMCACTION_SET,
    RTDRV_L2_IPMCASTADDR_ADD,
    RTDRV_L2_IPMCASTADDR_DEL,
    RTDRV_L2_SRCPORTEGRFILTERMASK_SET,
    RTDRV_L2_EXTPORTEGRFILTERMASK_SET,
    RTDRV_L2_CAM_STATE_SET,
    RTDRV_L2_IPMCSIPFILTER_SET,
    RTDRV_L2_LIMITLEARNINGENTRYACTION_SET,
    RTDRV_L2_VIDUNMATCHACTION_SET,
    RTDRV_L2_EXTMEMBERCONFIG_SET,
    RTDRV_L2_IP6MCRSVADDR_SET
};

enum rtdrv_l34_set_e
{
    RTDRV_L34_BASED_SET= (RTDRV_BASE_CTL + RTDRV_L34_OFFSET + 1),
    RTDRV_L34_INIT,
    RTDRV_L34_NETIFTABLE_SET,
    RTDRV_L34_ARPTABLE_SET,
    RTDRV_L34_ARPTABLE_DEL,
    RTDRV_L34_PPPOETABLE_SET,
    RTDRV_L34_ROUTINGTABLE_SET,
    RTDRV_L34_ROUTINGTABLE_DEL,
    RTDRV_L34_NEXTHOPTABLE_SET,
    RTDRV_L34_EXTINTIPTABLE_SET,
    RTDRV_L34_EXTINTIPTABLE_DEL,
    RTDRV_L34_NAPTINBOUNDTABLE_SET,
    RTDRV_L34_NAPTOUTBOUNDTABLE_SET,
    RTDRV_L34_IPMCTRANSTABLE_SET,
    RTDRV_L34_TABLE_RESET,
    RTDRV_L34_BINDINGTABLE_SET,
    RTDRV_L34_BINDINGACTION_SET,
    RTDRV_L34_WANTYPETABLE_SET,
    RTDRV_L34_IPV6ROUTINGTABLE_SET,
    RTDRV_L34_IPV6NEIGHBORTABLE_SET,
    RTDRV_L34_HSABMODE_SET,
    RTDRV_L34_PORTWANMAP_SET,
    RTDRV_L34_GLOBALSTATE_SET,
    RTDRV_L34_LOOKUPMODE_SET,
    RTDRV_L34_LOOKUPPORTMAP_SET,
    RTDRV_L34_WANROUTMODE_SET,
    RTDRV_L34_HSDSTATE_SET,
    RTDRV_L34_HWL4TRFWRKTBL_SET,
    RTDRV_L34_HWARPTRFWRKTBL_SET,
    RTDRV_L34_IPV6MCROUTINGTRANSIDX_SET,
    RTDRV_L34_DSLITEINFTABLE_SET,
    RTDRV_L34_DSLITEMCTABLE_SET,
    RTDRV_L34_DSLITECONTROL_SET,
    RTDRV_L34_FLOWROUTE_SET,
    RTDRV_L34_MIB_RESET,
    RTDRV_L34_LUTMISS_SET,
};

enum rtdrv_led_set_e
{
    RTDRV_LED_BASED_SET= (RTDRV_BASE_CTL + RTDRV_LED_OFFSET + 1),
    RTDRV_LED_INIT,
    RTDRV_LED_OPERATION_SET,
    RTDRV_LED_SERIALMODE_SET,
    RTDRV_LED_BLINKRATE_SET,
    RTDRV_LED_CONFIG_SET,
    RTDRV_LED_MODEFORCE_SET,
    RTDRV_LED_PARALLELENABLE_SET,
    RTDRV_LED_PONALARM_SET,
    RTDRV_LED_PONWARNING_SET,
    RTDRV_LED_PONPORT_SET,
    RTDRV_LED_PARALLELMODE_SET,
};

enum rtdrv_mirror_set_e
{
    RTDRV_MIRROR_BASED_SET= (RTDRV_BASE_CTL + RTDRV_MIRROR_OFFSET + 1),
    RTDRV_MIRROR_INIT,
    RTDRV_MIRROR_PORTBASED_SET,
    RTDRV_MIRROR_PORTISO_SET,

};

enum rtdrv_oam_set_e
{
    RTDRV_OAM_BASED_SET= (RTDRV_BASE_CTL + RTDRV_OAM_OFFSET + 1),
    RTDRV_OAM_INIT,
    RTDRV_OAM_PARSERACTION_SET,
    RTDRV_OAM_MULTIPLEXERACTION_SET
};

enum rtdrv_ponmac_set_e
{
    RTDRV_PONMAC_BASED_SET= (RTDRV_BASE_CTL + RTDRV_PONMAC_OFFSET + 1),
    RTDRV_PONMAC_INIT,
    RTDRV_PONMAC_QUEUE_ADD,
    RTDRV_PONMAC_QUEUE_DEL,
    RTDRV_PONMAC_FLOW2QUEUE_SET,
    RTDRV_PONMAC_QUEUEDRAINOUT_SET,
    RTDRV_PONMAC_MODE_SET,
    RTDRV_PONMAC_SERDESCDR_RESET,
    RTDRV_PONMAC_BWTHRESHOLD_SET,
    RTDRV_PONMAC_SCHEDULINGTYPE_SET,
    RTDRV_PONMAC_EGRBANDWIDTHCTRLRATE_SET,
    RTDRV_PONMAC_EGRSCHEDULEIDRATE_SET,
    RTDRV_PONMAC_FLOWVALID_SET,
    RTDRV_PONMAC_SYNCE_SET,
    RTDRV_PONMAC_EGRBANDWIDTHCTRLINCLUDEIFG_SET,
    RTDRV_PONMAC_EGRSCHEDULEIDINCLUDEIFG_SET,
    RTDRV_PONMAC_AGGTCONTSTATE_SET,
    RTDRV_PONMAC_TXDISABLEGPIO_SET,
    RTDRV_PONMAC_TXPOWERDISABLEGPIO_SET,
    RTDRV_PONMAC_SWITCHBUFFER_SET,
};

enum rtdrv_port_set_e
{
    RTDRV_PORT_BASED_SET= (RTDRV_BASE_CTL + RTDRV_PORT_OFFSET + 1),
    RTDRV_PORT_INIT,
    RTDRV_PORT_PHYAUTONEGOENABLE_SET,
    RTDRV_PORT_PHYAUTONEGOABILITY_SET,
    RTDRV_PORT_PHYFORCEMODEABILITY_SET,
    RTDRV_PORT_PHYREG_SET,
    RTDRV_PORT_PHYMASTERSLAVE_SET,
    RTDRV_PORT_PHYTESTMODE_SET,
    RTDRV_PORT_ISOLATION_SET,
    RTDRV_PORT_ISOLATIONEXT_SET,
    RTDRV_PORT_ISOLATIONL34_SET,
    RTDRV_PORT_ISOLATIONEXTL34_SET,
    RTDRV_PORT_ISOLATIONENTRY_SET,
    RTDRV_PORT_ISOLATIONENTRYEXT_SET,
    RTDRV_PORT_ISOLATIONCTAGPKTCONFIG_SET,
    RTDRV_PORT_ISOLATIONL34PKTCONFIG_SET,
    RTDRV_PORT_ISOLATIONIPMCLEAKY_SET,
    RTDRV_PORT_ISOLATIONPORTLEAKY_SET,
    RTDRV_PORT_ISOLATIONLEAKY_SET,
    RTDRV_PORT_MACREMOTELOOPBACKENABLE_SET,
    RTDRV_PORT_MACLOCALLOOPBACKENABLE_SET,
    RTDRV_PORT_ADMINENABLE_SET,
    RTDRV_PORT_SPECIALCONGEST_SET,
    RTDRV_PORT_SPECIALCONGESTSTATUS_CLEAR,
    RTDRV_PORT_GREENENABLE_SET,
    RTDRV_PORT_PHYCROSSOVERMODE_SET,
    RTDRV_PORT_ENHANCEDFID_SET,
    RTDRV_PORT_MACFORCEABILITY_SET,
    RTDRV_PORT_MACFORCEABILITYSTATE_SET,
    RTDRV_PORT_MACEXTMODE_SET,
    RTDRV_PORT_MACEXTRGMIIDELAY_SET,
    RTDRV_PORT_GIGALITEENABLE_SET,
    RTDRV_PORT_EEEENABLE_SET,
    RTDRV_PORT_PHYPOWERDOWN_SET,
    RTDRV_PORT_PHYPOWERDOWN_TRYSET,
    RTDRV_PORT_SERDESMODE_SET,
    RTDRV_PORT_SERDESNWAY_SET,
};

enum rtdrv_qos_set_e
{
    RTDRV_QOS_BASED_SET= (RTDRV_BASE_CTL + RTDRV_QOS_OFFSET + 1),
    RTDRV_QOS_INIT,
    RTDRV_QOS_PRISELGROUP_SET,
    RTDRV_QOS_PORTPRI_SET,
    RTDRV_QOS_DSCPPRIREMAPGROUP_SET,
    RTDRV_QOS_1PPRIREMAPGROUP_SET,
    RTDRV_QOS_PRIMAP_SET,
    RTDRV_QOS_PORTPRIMAP_SET,
    RTDRV_QOS_1PREMARKENABLE_SET,
    RTDRV_QOS_1PREMARKGROUP_SET,
    RTDRV_QOS_DSCPREMARKENABLE_SET,
    RTDRV_QOS_DSCPREMARKGROUP_SET,
    RTDRV_QOS_PORTDSCPREMARKSRCSEL_SET,
    RTDRV_QOS_DSCP2DSCPREMARKGROUP_SET,
    RTDRV_QOS_FWD2CPUPRIREMAP_SET,
    RTDRV_QOS_SCHEDULINGQUEUE_SET,
    RTDRV_QOS_PORTPRISELGROUP_SET,
    RTDRV_QOS_SCHEDULINGTYPE_SET,
    RTDRV_QOS_PORTDOT1PREMARKSRCSEL_SET,

};

enum rtdrv_rldp_set_e
{
    RTDRV_RLDP_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RLDP_OFFSET + 1),
    RTDRV_RLDP_INIT,
    RTDRV_RLDP_CONFIG_SET,
    RTDRV_RLDP_PORTCONFIG_SET,
    RTDRV_RLDP_PORTSTATUS_CLEAR,
    RTDRV_RLPP_INIT,
    RTDRV_RLPP_TRAPTYPE_SET,
};

enum rtdrv_sec_set_e
{
    RTDRV_SEC_BASED_SET= (RTDRV_BASE_CTL + RTDRV_SEC_OFFSET + 1),
    RTDRV_SEC_INIT,
    RTDRV_SEC_PORTATTACKPREVENTSTATE_SET,
    RTDRV_SEC_ATTACKPREVENT_SET,
    RTDRV_SEC_ATTACKFLOODTHRESH_SET,
    RTDRV_SEC_ATTACKFLOODTHRESHUNIT_SET,
};

typedef struct rtdrv_timeCfg_s
{
    rtk_port_t                      port;
    rtk_enable_t                    enable;
    rtk_pon_tod_t                   ponTod;
    uint32                          sign;
    uint32                          freq;
    rtk_time_ptpMsgType_t           type;
    rtk_time_ptpIgrMsg_action_t     igr_action;
    rtk_time_ptpEgrMsg_action_t     egr_action;
    uint32                          delay;
    rtk_time_ptpPpsMode_t           mode;
    rtk_time_freerun_t              freeTime;
}rtdrv_timeCfg_t;

typedef struct rtdrv_ppstodCfg_s
{
    uint8                           delay;
    uint8                           width;
    rtk_ppstod_manualMode_t         mode;
    uint16                          week;
    uint32                          sec;
    uint8                           len;
    uint8                           offset;
    uint8                           val;
    uint32                          rate;
}rtdrv_ppstodCfg_t;


enum rtdrv_stat_set_e
{
    RTDRV_STAT_BASED_SET= (RTDRV_BASE_CTL + RTDRV_STAT_OFFSET + 1),
    RTDRV_STAT_INIT,
    RTDRV_STAT_GLOBAL_RESET,
    RTDRV_STAT_PORT_RESET,
    RTDRV_STAT_LOG_RESET,
    RTDRV_STAT_RSTCNTVALUE_SET,
    RTDRV_STAT_LOGCTRL_SET,
    RTDRV_STAT_MIBCNTMODE_SET,
    RTDRV_STAT_MIBLATCHTIMER_SET,
    RTDRV_STAT_MIBSYNCMODE_SET,
    RTDRV_STAT_MIBCNTTAGLEN_SET,
    RTDRV_STAT_HOSTCNT_RESET,
    RTDRV_STAT_HOSTSTATE_SET,

};

enum rtdrv_stp_set_e
{
    RTDRV_STP_BASED_SET= (RTDRV_BASE_CTL + RTDRV_STP_OFFSET + 1),
    RTDRV_STP_INIT,
    RTDRV_STP_MSTPSTATE_SET,
};


enum rtdrv_svlan_set_e
{
    RTDRV_SVLAN_BASED_SET= (RTDRV_BASE_CTL + RTDRV_SVLAN_OFFSET + 1),
    RTDRV_SVLAN_INIT,
    RTDRV_SVLAN_CREATE,
    RTDRV_SVLAN_DESTROY,
    RTDRV_SVLAN_PORTSVID_SET,
    RTDRV_SVLAN_SERVICEPORT_SET,
    RTDRV_SVLAN_MEMBERPORT_SET,
    RTDRV_SVLAN_TPIDENTRY_SET,
    RTDRV_SVLAN_PRIORITYREF_SET,
    RTDRV_SVLAN_MEMBERPORTENTRY_SET,
    RTDRV_SVLAN_IPMC2S_ADD,
    RTDRV_SVLAN_IPMC2S_DEL,
    RTDRV_SVLAN_L2MC2S_ADD,
    RTDRV_SVLAN_L2MC2S_DEL,
    RTDRV_SVLAN_SP2C_ADD,
    RTDRV_SVLAN_SP2C_DEL,
    RTDRV_SVLAN_DMACVIDSELSTATE_SET,
    RTDRV_SVLAN_UNMATCHACTION_SET,
    RTDRV_SVLAN_UNTAGACTION_SET,
    RTDRV_SVLAN_C2S_ADD,
    RTDRV_SVLAN_C2S_DEL,
    RTDRV_SVLAN_TRAPPRI_SET,
    RTDRV_SVLAN_DEIKEEPSTATE_SET,
    RTDRV_SVLAN_LOOKUPTYPE_SET,
    RTDRV_SVLAN_SP2CUNMATCHCTAGGING_SET,
    RTDRV_SVLAN_PRIORITY_SET,
    RTDRV_SVLAN_FID_SET,
    RTDRV_SVLAN_FIDENABLE_SET,
    RTDRV_SVLAN_ENHANCEDFID_SET,
    RTDRV_SVLAN_ENHANCEDFIDENABLE_SET,
    RTDRV_SVLAN_DMACVIDSELFORCEDSTATE_SET,
    RTDRV_SVLAN_SVLANFUNCTIONENABLE_SET,
    RTDRV_SVLAN_TPIDENABLE_SET,
    RTDRV_SVLAN_SP2CPRIORITY_ADD,
    RTDRV_SVLAN_EXTPORTPVID_SET,
};

enum rtdrv_switch_set_e
{
    RTDRV_SWITCH_BASED_SET= (RTDRV_BASE_CTL + RTDRV_SWITCH_OFFSET + 1),
    RTDRV_SWITCH_INIT,
    RTDRV_SWITCH_PORT2PORTMASK_SET,
    RTDRV_SWITCH_PORT2PORTMASK_CLEAR,
    RTDRV_SWITCH_ALLPORTMASK_SET,
    RTDRV_SWITCH_ALLEXTPORTMASK_SET,
    RTDRV_SWITCH_MAXPKTLENLINKSPEED_SET,
    RTDRV_SWITCH_MGMTMACADDR_SET,
    RTDRV_SWITCH_CHIP_RESET,
    RTDRV_SWITCH_MAXPKTLENBYPORT_SET,
    RTDRV_SWITCH_CHANGEDUPLEX_SET,
    RTDRV_SWITCH_SYSTEM_INIT,
};

enum rtdrv_trap_set_e
{
    RTDRV_TRAP_BASED_SET= (RTDRV_BASE_CTL + RTDRV_TRAP_OFFSET + 1),
    RTDRV_TRAP_INIT,
    RTDRV_TRAP_REASONTRAPTOCPUPRIORITY_SET,
    RTDRV_TRAP_IGMPCTRLPKT2CPUENABLE_SET,
    RTDRV_TRAP_MLDCTRLPKT2CPUENABLE_SET,
    RTDRV_TRAP_PORTIGMPMLDCTRLPKTACTION_SET,
    RTDRV_TRAP_IPMCASTPKT2CPUENABLE_SET,
    RTDRV_TRAP_L2MCASTPKT2CPUENABLE_SET,
    RTDRV_TRAP_RMAACTION_SET,
    RTDRV_TRAP_RMAPRI_SET,
    RTDRV_TRAP_OAMPDUACTION_SET,
    RTDRV_TRAP_PORTOAMPDUACTION_SET,
    RTDRV_TRAP_OAMPDUPRI_SET,
    RTDRV_TRAP_UNITRAPPRIORITYENABLE_SET,
    RTDRV_TRAP_UNITRAPPRIORITYPRIORITY_SET,
    RTDRV_TRAP_CPUTRAPHASHMASK_SET,
    RTDRV_TRAP_CPUTRAPHASHPORT_SET,
    RTDRV_TRAP_CPUTRAPHASHSTATE_SET,
    RTDRV_TRAP_CPUTRAPINICHASHSTATE_SET,
    RTDRV_TRAP_CPUTRAPINICHASHSELECT_SET,
};

enum rtdrv_trunk_set_e
{
    RTDRV_TRUNK_BASED_SET= (RTDRV_BASE_CTL + RTDRV_TRUNK_OFFSET + 1),
    RTDRV_TRUNK_INIT,
    RTDRV_TRUNK_DISTRIBUTIONALGORITHM_SET,
    RTDRV_TRUNK_PORT_SET,
    RTDRV_TRUNK_HASHMAPPINGTABLE_SET,
    RTDRV_TRUNK_MODE_SET,
    RTDRV_TRUNK_TRAFFICSEPARATE_SET,
    RTDRV_TRUNK_TRAFFICPAUSE_SET,

};

enum rtdrv_vlan_set_e
{
    RTDRV_VLAN_BASED_SET= (RTDRV_BASE_CTL + RTDRV_VLAN_OFFSET + 1),
    RTDRV_VLAN_INIT,
    RTDRV_VLAN_CREATE,
    RTDRV_VLAN_DESTROY,
    RTDRV_VLAN_DESTROYALL,
    RTDRV_VLAN_FID_SET,
    RTDRV_VLAN_FIDMODE_SET,
    RTDRV_VLAN_PORT_SET,
    RTDRV_VLAN_EXTPORT_SET,
    RTDRV_VLAN_STG_SET,
    RTDRV_VLAN_PRIORITY_SET,
    RTDRV_VLAN_PRIORITYENABLE_SET,
    RTDRV_VLAN_POLICINGENABLE_SET,
    RTDRV_VLAN_POLICINGMETERIDX_SET,
    RTDRV_VLAN_PORTACCEPTFRAMETYPE_SET,
    RTDRV_VLAN_VLANFUNCTIONENABLE_SET,
    RTDRV_VLAN_PORTIGRFILTERENABLE_SET,
    RTDRV_VLAN_LEAKY_SET,
    RTDRV_VLAN_PORTLEAKY_SET,
    RTDRV_VLAN_KEEPTYPE_SET,
    RTDRV_VLAN_PORTPVID_SET,
    RTDRV_VLAN_EXTPORTPVID_SET,
    RTDRV_VLAN_PROTOGROUP_SET,
    RTDRV_VLAN_PORTPROTOVLAN_SET,
    RTDRV_VLAN_TAGMODE_SET,
    RTDRV_VLAN_PORTFID_SET,
    RTDRV_VLAN_PORTPRIORITY_SET,
    RTDRV_VLAN_PORTEGRTAGKEEPTYPE_SET,
    RTDRV_VLAN_TRANSPARENTENABLE_SET,
    RTDRV_VLAN_CFIKEEPENABLE_SET,
    RTDRV_VLAN_RESERVEDVIDACTION_SET,
    RTDRV_VLAN_TAGMODEIP4MC_SET,
    RTDRV_VLAN_TAGMODEIP6MC_SET,
    RTDRV_VLAN_LUTSVLANHASHSTATE_SET,
    RTDRV_VLAN_EXTPORTPROTOVLAN_SET,
    RTDRV_VLAN_EXTPORTMASKINDEX_SET,
    RTDRV_VLAN_EXTPORTMASKCFG_SET,

};

enum rtdrv_rate_set_e
{
    RTDRV_RATE_INIT = (RTDRV_BASE_CTL + RTDRV_RATE_OFFSET),
    RTDRV_RATE_PORTIGRBANDWIDTHCTRLRATE_SET,
    RTDRV_RATE_PORTIGRBANDWIDTHCTRLINCLUDEIFG_SET,
    RTDRV_RATE_PORTEGRBANDWIDTHCTRLRATE_SET,
    RTDRV_RATE_EGRBANDWIDTHCTRLINCLUDEIFG_SET,
    RTDRV_RATE_PORTEGRBANDWIDTHCTRLINCLUDEIFG_SET,
    RTDRV_RATE_EGRQUEUEBWCTRLENABLE_SET,
    RTDRV_RATE_EGRQUEUEBWCTRLMETERIDX_SET,
    RTDRV_RATE_STORMCONTROLMETERIDX_SET,
    RTDRV_RATE_STORMCONTROLPORTENABLE_SET,
    RTDRV_RATE_STORMCONTROLENABLE_SET,
    RTDRV_RATE_STORMBYPASS_SET,
    RTDRV_RATE_SHAREMETER_SET,
    RTDRV_RATE_SHAREMETERBUCKET_SET,
    RTDRV_RATE_SHAREMETEREXCEED_CLEAR,
    RTDRV_RATE_SHAREMETERMODE_SET,
    RTDRV_RATE_HOSTIGRBWCTRLSTATE_SET,
    RTDRV_RATE_HOSTEGRBWCTRLSTATE_SET,
    RTDRV_RATE_HOSTBWCTRLMETERIDX_SET,
    RTDRV_RATE_HOSTMACADDR_SET,
    RTDRV_RATE_HOSTIGRBWCTRLMETERIDX_SET,
    RTDRV_RATE_HOSTEGRBWCTRLMETERIDX_SET,

};

enum rtdrv_gpon_set_e
{
    RTDRV_GPON_SN_SET = (RTDRV_BASE_CTL + RTDRV_GPON_OFFSET),
    RTDRV_GPON_PWD_SET,
    RTDRV_GPON_ACTIVE,
    RTDRV_GPON_DEACTIVE,
    RTDRV_GPON_PARA_SET,
    RTDRV_GPON_TCONT_ADD,
    RTDRV_GPON_TCONT_DEL,
    RTDRV_GPON_DS_FLOW_ADD,
    RTDRV_GPON_US_FLOW_ADD,
    RTDRV_GPON_BC_PASS_SET,
    RTDRV_GPON_NON_MC_PASS_SET,
    RTDRV_GPON_IP_PTN_SET,
    RTDRV_GPON_FLT_MODE_SET,
    RTDRV_GPON_FS_MODE_SET,
    RTDRV_GPON_MAC_ENTRY_ADD,
    RTDRV_GPON_MAC_ENTRY_DEL,
    RTDRV_GPON_RDI_SET,
    RTDRV_GPON_PWR_LEVEL_SET,
    RTDRV_GPON_TX_LASER_SET,
    RTDRV_GPON_FS_IDLE_SET,
    RTDRV_GPON_FS_PRBS_SET,
    RTDRV_GPON_TEST_SET,
    RTDRV_GPON_INITIAL,
    RTDRV_GPON_DEINITIAL,
    RTDRV_GPON_DEBUG_SET,
    RTDRV_GPON_UNIT_TEST,
#if defined(OLD_FPGA_DEFINED)
    RTDRV_GPON_PKTGEN_CFG,
    RTDRV_GPON_PKTGEN_BUF,
#endif
    RTDRV_GPON_OMCI_TX,
    RTDRV_GPON_AUTO_TCONT_SET,
    RTDRV_GPON_AUTO_BOH_SET,
    RTDRV_GPON_EQD_OFFSET_SET,
    RTDRV_GPON_AUTODISTX_SET,
    RTDRV_GPON_EXTMSG_SET,
    RTDRV_GPON_RGIGMP_CFGMSG_SET,
    RTDRV_GPON_DBRU_BLOCK_SIZE_SET,
    RTDRV_GPON_ROGUE_ONT_SET,
    RTDRV_GPON_BER_TIMER_ENABLE_SET
};

enum rtdrv_pkt_set_e
{
    RTDRV_PKT_SEND = (RTDRV_BASE_CTL + RTDRV_PKT_OFFSET),
    RTDRV_PKT_RXDUMP_ENABLE,
    RTDRV_PKT_RXDUMP_CLEAR,
    RTDRV_PKT_CONTINUS_SEND,
    RTDRV_PKT_CONTINUSCNT_SET,
    RTDRV_PKT_RXGMAC_SET,
};

enum rtdrv_gpio_set_e
{
    RTDRV_GPIO_INIT= (RTDRV_BASE_CTL + RTDRV_GPIO_OFFSET),
    RTDRV_GPIO_STATE_SET,
    RTDRV_GPIO_MODE_SET,
    RTDRV_GPIO_DATABIT_SET,
    RTDRV_GPIO_INTR_SET,
    RTDRV_GPIO_IMS_SET,
};

enum rtdrv_i2c_set_e
{
    RTDRV_I2C_INIT = (RTDRV_BASE_CTL + RTDRV_I2C_OFFSET),
    RTDRV_I2C_ENABLE_SET,
    RTDRV_I2C_WIDTH_SET,
    RTDRV_I2C_WRITE,
    RTDRV_I2C_CLOCK_SET,
    RTDRV_I2C_EEPMIRROR_SET,
    RTDRV_I2C_EEPMIRROR_WRITE,
    RTDRV_I2C_DATAWIDTH_SET,
    RTDRV_I2C_ADDRWIDTH_SET,
    RTDRV_I2C_SEQ_WRITE,
    RTDRV_I2C_NOWAIT_WRITE,
};

enum rtdrv_l34lite_set_e
{
    RTDRV_L34_LITE_INIT = (RTDRV_BASE_CTL + RTDRV_L34_LITE_OFFSET),
    RTDRV_L34_NETIF_CREATE,
    RTDRV_L34_NETIFPPPOE_SET,
    RTDRV_L34_NETIFVLAN_SET,
    RTDRV_L34_NETIFROUTINGSTATE_SET,
    RTDRV_L34_NETIFMTU_SET,
    RTDRV_L34_NETIFIPADDR_SET,
    RTDRV_L34_NETIFNAT_SET,
    RTDRV_L34_NETIFSTATE_SET,
    RTDRV_L34_NETIF_DEL,
    RTDRV_L34_ARP_ADD,
    RTDRV_L34_ARP_DEL,
    RTDRV_L34_ROUTE_ADD,
    RTDRV_L34_ROUTE_DEL,
    RTDRV_L34_CONNECTTRACK_ADD,
    RTDRV_L34_CONNECTTRACK_DEL,
    RTDRV_L34_ROUTE6_ADD,
    RTDRV_L34_ROUTE6_DEL,
    RTDRV_L34_NEIGH6_ADD,
    RTDRV_L34_NEIGH6_DEL,
    RTDRV_L34_NETIFIP6ADDR_ADD,
    RTDRV_L34_NETIFIP6ADDR_DEL,
    RTDRV_L34_NETIFGATEWAY_SET,
    RTDRV_L34_NETIF_SET,
    RTDRV_L34_NETIFMAC_SET,
};


enum rtdrv_epon_set_e
{
    RTDRV_EPON_INIT = (RTDRV_BASE_CTL + RTDRV_EPON_OFFSET),
    RTDRV_EPON_INTRMASK_SET,
    RTDRV_EPON_INTR_DISABLEALL,
    RTDRV_EPON_LLID_ENTRY_SET,
    RTDRV_EPON_FORCELASERSTATE_SET,
    RTDRV_EPON_LASERTIME_SET,
    RTDRV_EPON_REGISTERREQ_SET,
    RTDRV_EPON_CHURNINGKEY_SET,
    RTDRV_EPON_USFECSTATE_SET,
    RTDRV_EPON_DSFECSTATE_SET,
    RTDRV_EPON_MIBGLOBAL_RESET,
    RTDRV_EPON_MIBLLIDIDX_RESET,
    RTDRV_EPON_MPCPTIMEOUTVAL_SET,
    RTDRV_EPON_OPTICALPOLARITY_SET,
    RTDRV_EPON_FECSTATE_SET,
    RTDRV_EPON_THRESHOLDREPORT_SET,
    RTDRV_EPON_FORCEPRBS_SET,
    RTDRV_EPON_MULTILLIDMODE_SET,
    RTDRV_EPON_REPORTQUEUESET_SET,
    RTDRV_EPON_QUEUETHRESHOLDREPORT_SET,
    RTDRV_EPON_AUTOPOWERSAVINGSTATE_SET,
    RTDRV_EPON_AUTOPOWERSAVINGOERECOVERTIME_SET,

};

enum rtdrv_time_set_e
{
    RTDRV_TIME_BASED_SET= (RTDRV_BASE_CTL + RTDRV_TIME_OFFSET + 1),
    RTDRV_TIME_PORTTRANSPARENTENABLE_SET,
    RTDRV_TIME_INIT,
    RTDRV_TIME_PORTPTPENABLE_SET,
    RTDRV_TIME_REFTIME_SET,
    RTDRV_TIME_FREQUENCY_SET,
    RTDRV_TIME_PTPIGRMSGACTION_SET,
    RTDRV_TIME_PTPEGRMSGACTION_SET,
    RTDRV_TIME_MEANPATHDELAY_SET,
    RTDRV_TIME_RXTIME_SET,
    RTDRV_TIME_PONTOD_SET,
    RTDRV_TIME_TODENABLE_SET,
    RTDRV_TIME_PPSENABLE_SET,
    RTDRV_TIME_PPSMODE_SET,

};

enum rtdrv_ppstod_set_e
{
    RTDRV_PPSTOD_BASED_SET= (RTDRV_BASE_CTL + RTDRV_PPSTOD_OFFSET + 1),
    RTDRV_PPSTOD_INIT,
    RTDRV_PPSTOD_DELAY_SET,
    RTDRV_PPSTOD_PULSEWIDTH_SET,
    RTDRV_PPSTOD_MODE_SET,
    RTDRV_PPSTOD_SARPGPSWEEK_SET,
    RTDRV_PPSTOD_SARPUTCSEC_SET,
    RTDRV_PPSTOD_FRAMELEN_SET,
    RTDRV_PPSTOD_FRAMEDATA_SET,
    RTDRV_PPSTOD_BAUDRATE_SET,
};

enum rtdrv_ponled_set_e
{
    RTDRV_PONLED_BASED_SET= (RTDRV_BASE_CTL + RTDRV_PONLED_OFFSET + 1),
    RTDRV_PONLED_SPECTYPE_SET,
    RTDRV_PONLED_STATUS_SET,
    RTDRV_PONLED_GROUP_SET,
};

enum rtdrv_pbo_set_e
{
    RTDRV_PBO_BASED_SET= (RTDRV_BASE_CTL + RTDRV_PBO_OFFSET + 1),
    RTDRV_PBO_INIT,
    RTDRV_SWPBO_INIT,
    RTDRV_SWPBO_PORTSTATE_SET,
    RTDRV_SWPBO_PORTAUTOCONF_SET,
    RTDRV_SWPBO_PORTTHRESHOLD_SET,
    RTDRV_SWPBO_QUEUETHRESHOLD_SET,
    RTDRV_SWPBO_PORTUSEDPAGE_CLEAR,
    RTDRV_SWPBO_QUEUEUSEDPAGE_CLEAR,
    RTDRV_SWPBO_PORTDSC_CLEAR,
};

enum rtdrv_mdio_set_e
{
    RTDRV_MDIO_BASED_SET= (RTDRV_BASE_CTL + RTDRV_MDIO_OFFSET + 1),
    RTDRV_MDIO_INIT,
    RTDRV_MDIO_CFG_SET,
    RTDRV_MDIO_C22_WRITE,
    RTDRV_MDIO_C45_WRITE,
};

#if defined(CONFIG_COMMON_RT_API)
enum rtdrv_rt_switch_set_e
{
    RTDRV_RT_SWITCH_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_SWITCH_OFFSET + 1),
    RTDRV_RT_SWITCH_INIT,
    RTDRV_RT_SWITCH_MAXPKTLENBYPORT_SET,
};

enum rtdrv_rt_gpon_set_e
{
    RTDRV_RT_GPON_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_GPON_OFFSET + 1),
    RTDRV_RT_GPON_INIT,
    RTDRV_RT_GPON_SERIALNUMBER_SET,
    RTDRV_RT_GPON_REGISTRATIONID_SET,
    RTDRV_RT_GPON_TCONT_SET,
    RTDRV_RT_GPON_TCONT_DEL,
    RTDRV_RT_GPON_USFLOW_SET,
    RTDRV_RT_GPON_USFLOW_DEL,
    RTDRV_RT_GPON_USFLOW_DELALL,
    RTDRV_RT_GPON_DSFLOW_SET,
    RTDRV_RT_GPON_DSFLOW_DEL,
    RTDRV_RT_GPON_DSFLOW_DELALL,
    RTDRV_RT_GPON_LOOPGEM_SET,
    RTDRV_RT_GPON_PONQUEUE_SET,
    RTDRV_RT_GPON_PONQUEUE_DEL,
    RTDRV_RT_GPON_MSK_SET,
    RTDRV_RT_GPON_MCKEY_SET,
    RTDRV_RT_GPON_EGRBANDWIDTHCTRLRATE_SET,
    RTDRV_RT_GPON_ATTRIBUTE_SET,
    RTDRV_RT_GPON_OMCI_MIRROR_SET,
	RTDRV_RT_GPON_EMERGENCY_STOP_SET,
};

enum rtdrv_rt_stat_set_e
{
    RTDRV_RT_STAT_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_STAT_OFFSET + 1),
    RTDRV_RT_STAT_INIT,
    RTDRV_RT_STAT_PORT_RESET,
};

enum rtdrv_rt_rate_set_e
{
    RTDRV_RT_RATE_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_RATE_OFFSET + 1),
    RTDRV_RT_RATE_INIT,
    RTDRV_RT_RATE_PORTIGRBANDWIDTHCTRLRATE_SET,
    RTDRV_RT_RATE_PORTEGRBANDWIDTHCTRLRATE_SET,
    RTDRV_RT_RATE_STORMCONTROLMETERIDX_SET,
    RTDRV_RT_RATE_STORMCONTROLPORTENABLE_SET,
    RTDRV_RT_RATE_SHAREMETERTYPE_DEL,
    RTDRV_RT_RATE_SHAREMETERRATE_SET,
    RTDRV_RT_RATE_SHAREMETERBUCKET_SET,
    RTDRV_RT_RATE_SHAREMETERIFGINCLUDE_SET,
};

enum rtdrv_rt_qos_set_e
{
    RTDRV_RT_QOS_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_QOS_OFFSET + 1),
    RTDRV_RT_QOS_INIT,
    RTDRV_RT_QOS_SCHEDULINGQUEUE_SET,
    RTDRV_RT_QOS_DCSP2PBIT_SET,
};

enum rtdrv_rt_intr_set_e
{
    RTDRV_RT_INTR_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_INTR_OFFSET + 1),
    RTDRV_RT_INTR_INIT,
    RTDRV_RT_INTR_IMR_SET,
};

enum rtdrv_rt_sec_set_e
{
    RTDRV_RT_SEC_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_SEC_OFFSET + 1),
    RTDRV_RT_SEC_INIT,
    RTDRV_RT_SEC_PORTATTACKPREVENTSTATE_SET,
    RTDRV_RT_SEC_ATTACKPREVENT_SET,
    RTDRV_RT_SEC_ATTACKFLOODTHRESH_SET,
    RTDRV_RT_SEC_ATTACKFLOODTHRESHUNIT_SET
};

enum rtdrv_rt_trap_set_e
{
    RTDRV_RT_TRAP_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_TRAP_OFFSET + 1),
    RTDRV_RT_TRAP_INIT,
    RTDRV_RT_TRAP_PORTIGMPMLDCTRLPKTACTION_SET,
    RTDRV_RT_TRAP_OAMPDUACTION_SET,
    RTDRV_RT_TRAP_OMCIACTION_SET,
};

enum rtdrv_rt_i2c_set_e
{
    RTDRV_RT_I2C_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_I2C_OFFSET + 1),
    RTDRV_RT_I2C_INIT,
    RTDRV_RT_I2C_ENABLE_SET,
    RTDRV_RT_I2C_WRITE,
    RTDRV_RT_I2C_SEQ_WRITE,
    RTDRV_RT_I2C_CLOCK_SET,
};

enum rtdrv_rt_port_set_e
{
    RTDRV_RT_PORT_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_PORT_OFFSET + 1),
    RTDRV_RT_PORT_INIT,
    RTDRV_RT_PORT_PHYAUTONEGOENABLE_SET,
    RTDRV_RT_PORT_PHYAUTONEGOABILITY_SET,
    RTDRV_RT_PORT_PHYFORCEMODEABILITY_SET,
    RTDRV_RT_PORT_PHYREG_SET,
    RTDRV_RT_PORT_ADMINENABLE_SET,
    RTDRV_RT_PORT_ISOLATIONENTRY_SET,
    RTDRV_RT_PORT_UNITYPE_SET,
    RTDRV_RT_PORT_PHYPOWERDOWN_SET,
};

enum rtdrv_rt_l2_set_e
{
    RTDRV_RT_L2_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_L2_OFFSET + 1),
    RTDRV_RT_L2_INIT,
    RTDRV_RT_L2_PORTLIMITLEARNINGCNT_SET,
    RTDRV_RT_L2_NEWMACOP_SET,
    RTDRV_RT_L2_ADDR_ADD,
    RTDRV_RT_L2_ADDR_DEL,
    RTDRV_RT_L2_ILLEGALPORTMOVEACTION_SET,
    RTDRV_RT_L2_AGETIME_SET,
    RTDRV_RT_L2_IVLSVL_SET,
};

enum rtdrv_rt_epon_set_e
{
    RTDRV_RT_EPON_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_EPON_OFFSET + 1),
    RTDRV_RT_EPON_INIT,
    RTDRV_RT_EPON_LLID_ENTRY_SET,
    RTDRV_RT_EPON_REGISTERREQ_SET,
    RTDRV_RT_EPON_CHURNINGKEY_SET,
    RTDRV_RT_EPON_USFECSTATE_SET,
    RTDRV_RT_EPON_DSFECSTATE_SET,
    RTDRV_RT_EPON_PONQUEUE_SET,
    RTDRV_RT_EPON_PONQUEUE_DEL,
    RTDRV_RT_EPON_EGRBANDWIDTHCTRLRATE_SET,
    RTDRV_RT_EPON_MPCP_QUEUE_THRESHOLD_SET,
};

enum rtdrv_rt_cls_set_e
{
    RTDRV_RT_CLS_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_CLS_OFFSET + 1),
    RTDRV_RT_CLS_INIT,
    RTDRV_RT_CLS_RULE_ADD,
    RTDRV_RT_CLS_RULE_DELETE,
    RTDRV_RT_CLS_FWDPORT_SET,
};

enum rtdrv_rt_ponmisc_set_e
{
    RTDRV_RT_PONMISC_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_PONMISC_OFFSET + 1),
    RTDRV_RT_PONMISC_INIT,
    RTDRV_RT_PONMISC_MODESPEED_SET,
    RTDRV_RT_PONMISC_SID_SET,
    RTDRV_RT_PONMISC_BURSTPOLARITYREVERSE_SET,
    RTDRV_RT_PONMISC_FORCELASER_SET,
    RTDRV_RT_PONMISC_FORCEPRBS_SET,
};

enum rtdrv_rt_mirror_set_e
{
    RTDRV_RT_MIRROR_BASED_SET= (RTDRV_BASE_CTL + RTDRV_RT_MIRROR_OFFSET + 1),
    RTDRV_RT_MIRROR_INIT,
    RTDRV_RT_MIRROR_PORTBASED_SET,
};
#endif

#if defined(CONFIG_EUROPA_FEATURE)
enum rtdrv_ldd_set_e
{
    RTDRV_LDD_BASED_SET= (RTDRV_BASE_CTL + RTDRV_LDD_OFFSET + 1),
    RTDRV_LDD_I2C_INIT,
    RTDRV_LDD_GPIO_INIT,
    RTDRV_LDD_RESET,
    RTDRV_LDD_CALIBRATION_STATE_SET,
    RTDRV_LDD_PARAMETER_SET,
    RTDRV_LDD_LOOP_MODE_SET,
    RTDRV_LDD_LASER_LUT_SET,
    RTDRV_LDD_APD_LUT_SET,
    RTDRV_LDD_APC_ENABLE_SET,
    RTDRV_LDD_TX_ENABLE_SET,
    RTDRV_LDD_RX_ENABLE_SET,
    RTDRV_LDD_TX_BIAS_SET,
    RTDRV_LDD_TX_MOD_SET,
    RTDRV_LDD_STEERING_MODE_SET,
    RTDRV_LDD_INTEGRATION_MODE_SET,
    RTDRV_LDD_STEERING_MODE_FIXUP,
    RTDRV_LDD_INTEGRATION_MODE_FIXUP,
    RTDRV_LDD_CONFIG_REFRESH,
    RTDRV_LDD_TXCROSS_SET,
    RTDRV_LDD_APC_IAVG_SET,
    RTDRV_LDD_APC_ER_SET,    
    RTDRV_LDD_APC_ERTRIM_SET,    
    RTDRV_LDD_RXLOS_REFDAC_SET,    
    RTDRV_LDD_RXLOS_HYSTSEL_SET,            
    RTDRV_LDD_CHIP_INIT,
    RTDRV_LDD_API_TEST,
};
#endif

/***** end of RTDRV_SET *****/



/***** RTDRV_GET *****/
#define RTDRV_GET_MAX                           (RTDRV_BASE_CTL + RTDRV_END_OFFSET)

enum rtdrv_reg_get_e
{
    RTDRV_REG_REGISTER_GET = (RTDRV_BASE_CTL + RTDRV_REG_OFFSET),
    RTDRV_REG_IDX2ADDR_GET,
    RTDRV_REG_IDXMAX_GET,
    RTDRV_REG_INFO_GET,
    RTDRV_TABLE_READ,
    RTDRV_REG_ADDRESS_GET,
    RTDRV_PHY_REG_GET,
    RTDRV_SOC_ADDRESS_GET
};

enum rtdrv_acl_get_e
{
    RTDRV_ACL_BASED_GET= (RTDRV_BASE_CTL + RTDRV_ACL_OFFSET + 1),
    RTDRV_ACL_TEMPLATE_GET,
    RTDRV_ACL_FIELDSELECT_GET,
    RTDRV_ACL_IGRRULEENTRY_GET,
    RTDRV_ACL_IGRUNMATCHACTION_GET,
    RTDRV_ACL_IGRSTATE_GET,
    RTDRV_ACL_IPRANGE_GET,
    RTDRV_ACL_VIDRANGE_GET,
    RTDRV_ACL_PORTRANGE_GET,
    RTDRV_ACL_PACKETLENGTHRANGE_GET,
    RTDRV_ACL_IGRRULEMODE_GET,
    RTDRV_ACL_IGRPERMITSTATE_GET,
    RTDRV_ACL_DBGINFO_GET,
    RTDRV_ACL_HITREASON_GET

};

enum rtdrv_classify_get_e
{
    RTDRV_CLASSIFY_BASED_GET= (RTDRV_BASE_CTL + RTDRV_CLASSIFY_OFFSET + 1),
    RTDRV_CLASSIFY_CFGENTRY_GET,
    RTDRV_CLASSIFY_UNMATCHACTION_GET,
    RTDRV_CLASSIFY_UNMATCHACTION_DS_GET,
    RTDRV_CLASSIFY_PORTRANGE_GET,
    RTDRV_CLASSIFY_IPRANGE_GET,
    RTDRV_CLASSIFY_CFSEL_GET,
    RTDRV_CLASSIFY_CFPRI2DSCP_GET,
    RTDRV_CLASSIFY_PERMIT_SEL_GET,
    RTDRV_CLASSIFY_US1PREMARK_PRIOR_GET,
    RTDRV_CLASSIFY_TEMPLATECFGPATTERN0_GET,
    RTDRV_CLASSIFY_ENTRYNUMPATTERN1_GET,
    RTDRV_CLASSIFY_DEFAULTWANIF_GET,
    RTDRV_CLASSIFY_TRAPPRI_GET,

};

enum rtdrv_cpu_get_e
{
    RTDRV_CPU_BASED_GET= (RTDRV_BASE_CTL + RTDRV_CPU_OFFSET + 1),
    RTDRV_CPU_AWAREPORTMASK_GET,
    RTDRV_CPU_TAGFORMAT_GET,
    RTDRV_CPU_TRAPINSERTTAG_GET,
    RTDRV_CPU_TAGAWARE_GET,
    RTDRV_CPU_TRAPINSERTTAGBYPORT_GET,
    RTDRV_CPU_TAGAWAREBYPORT_GET,

};

enum rtdrv_debug_get_e
{
    RTDRV_DEBUG_BASED_GET= (RTDRV_BASE_CTL + RTDRV_DEBUG_OFFSET + 1),
    RTDRV_DEBUG_EN_LOG_GET,
    RTDRV_DEBUG_LOGLV_GET,
    RTDRV_DEBUG_LOGLVMASK_GET,
    RTDRV_DEBUG_LOGTYPE_GET,
    RTDRV_DEBUG_LOGFORMAT_GET,
    RTDRV_DEBUG_MODMASK_GET,
    RTDRV_DEBUG_LOGCFG_GET,
};

enum rtdrv_dot1x_get_e
{
    RTDRV_DOT1X_BASED_GET= (RTDRV_BASE_CTL + RTDRV_DOT1X_OFFSET + 1),
    RTDRV_DOT1X_UNAUTHPACKETOPER_GET,
    RTDRV_DOT1X_PORTBASEDENABLE_GET,
    RTDRV_DOT1X_PORTBASEDAUTHSTATUS_GET,
    RTDRV_DOT1X_PORTBASEDDIRECTION_GET,
    RTDRV_DOT1X_MACBASEDENABLE_GET,
    RTDRV_DOT1X_MACBASEDDIRECTION_GET,
    RTDRV_DOT1X_GUESTVLAN_GET,
    RTDRV_DOT1X_GUESTVLANBEHAVIOR_GET,
    RTDRV_DOT1X_TRAPPRI_GET,
};

enum rtdrv_intr_get_e
{
    RTDRV_INTR_BASED_GET= (RTDRV_BASE_CTL + RTDRV_INTR_OFFSET + 1),
    RTDRV_INTR_POLARITY_GET,
    RTDRV_INTR_IMR_GET,
    RTDRV_INTR_IMS_GET,
    RTDRV_INTR_SPEEDCHANGESTATUS_GET,
    RTDRV_INTR_LINKUPSTATUS_GET,
    RTDRV_INTR_LINKDOWNSTATUS_GET,
    RTDRV_INTR_GPHYSTATUS_GET,
    RTDRV_INTR_ISR_GET,
    RTDRV_INTR_ISR_COUNTER_DUMP,
};

enum rtdrv_l2_get_e
{
    RTDRV_L2_BASED_GET= (RTDRV_BASE_CTL + RTDRV_L2_OFFSET + 1),
    RTDRV_L2_FLUSHLINKDOWNPORTADDRENABLE_GET,
    RTDRV_L2_UCASTADDR_FLUSH,
    RTDRV_L2_LIMITLEARNINGOVERSTATUS_GET,
    RTDRV_L2_LEARNINGCNT_GET,
    RTDRV_L2_LIMITLEARNINGCNT_GET,
    RTDRV_L2_LIMITLEARNINGCNTACTION_GET,
    RTDRV_L2_LIMITLEARNINGPORTMASK_GET,
    RTDRV_L2_PORTLIMITLEARNINGOVERSTATUS_GET,
    RTDRV_L2_PORTLEARNINGCNT_GET,
    RTDRV_L2_PORTLIMITLEARNINGCNT_GET,
    RTDRV_L2_PORTLIMITLEARNINGCNTACTION_GET,
    RTDRV_L2_AGING_GET,
    RTDRV_L2_PORTAGINGENABLE_GET,
    RTDRV_L2_LOOKUPMISSACTION_GET,
    RTDRV_L2_PORTLOOKUPMISSACTION_GET,
    RTDRV_L2_LOOKUPMISSFLOODPORTMASK_GET,
    RTDRV_L2_NEWMACOP_GET,
    RTDRV_L2_NEXTVALIDADDR_GET,
    RTDRV_L2_NEXTVALIDADDRONPORT_GET,
    RTDRV_L2_NEXTVALIDMCASTADDR_GET,
    RTDRV_L2_NEXTVALIDIPMCASTADDR_GET,
    RTDRV_L2_NEXTVALIDENTRY_GET,
    RTDRV_L2_ADDR_GET,
    RTDRV_L2_MCASTADDR_GET,
    RTDRV_L2_ILLEGALPORTMOVEACTION_GET,
    RTDRV_L2_IPMCMODE_GET,
    RTDRV_L2_IPMCVLANMODE_GET,
    RTDRV_L2_IPV6MCMODE_GET,
    RTDRV_L2_IPMCGROUPLOOKUPMISSHASH_GET,
    RTDRV_L2_IPMCGROUP_GET,
    RTDRV_L2_IPMCGROUPEXT_GET,
    RTDRV_L2_IPMCGROUPEXTIDX_GET,
    RTDRV_L2_PORTIPMCACTION_GET,
    RTDRV_L2_IPMCASTADDR_GET,
    RTDRV_L2_SRCPORTEGRFILTERMASK_GET,
    RTDRV_L2_EXTPORTEGRFILTERMASK_GET,
    RTDRV_L2_CAM_STATE_GET,
    RTDRV_L2_IPMCSIPFILTER_GET,
    RTDRV_L2_LIMITLEARNINGENTRYACTION_GET,
    RTDRV_L2_VIDUNMATCHACTION_GET,
    RTDRV_L2_EXTMEMBERCONFIG_GET,
    RTDRV_L2_IP6MCRSVADDR_GET,
    RTDRV_L2_HASHVALUE_GET,
};

enum rtdrv_l34_get_e
{
    RTDRV_L34_BASED_GET= (RTDRV_BASE_CTL + RTDRV_L34_OFFSET + 1),
    RTDRV_L34_NETIFTABLE_GET,
    RTDRV_L34_ARPTABLE_GET,
    RTDRV_L34_PPPOETABLE_GET,
    RTDRV_L34_ROUTINGTABLE_GET,
    RTDRV_L34_NEXTHOPTABLE_GET,
    RTDRV_L34_EXTINTIPTABLE_GET,
    RTDRV_L34_NAPTINBOUNDTABLE_GET,
    RTDRV_L34_NAPTOUTBOUNDTABLE_GET,
    RTDRV_L34_IPMCTRANSTABLE_GET,
    RTDRV_L34_BINDINGTABLE_GET,
    RTDRV_L34_BINDINGACTION_GET,
    RTDRV_L34_WANTYPETABLE_GET,
    RTDRV_L34_IPV6ROUTINGTABLE_GET,
    RTDRV_L34_IPV6NEIGHBORTABLE_GET,
    RTDRV_L34_HSABMODE_GET,
    RTDRV_L34_HSADATA_GET,
    RTDRV_L34_HSBDATA_GET,
    RTDRV_L34_PORTWANMAP_GET,
    RTDRV_L34_GLOBALSTATE_GET,
    RTDRV_L34_LOOKUPMODE_GET,
    RTDRV_L34_LOOKUPPORTMAP_GET,
    RTDRV_L34_WANROUTMODE_GET,
    RTDRV_L34_ARPTRFINDICATOR_GET,
    RTDRV_L34_NAPTTRFINDICATOR_GET,
    RTDRV_L34_PPPTRFINDICATOR_GET,
    RTDRV_L34_NEIGHTRFINDICATOR_GET,
    RTDRV_L34_HSDSTATE_GET,
    RTDRV_L34_HWL4TRFWRKTBL_GET,
    RTDRV_L34_L4TRFTB_GET,
    RTDRV_L34_HWL4TRFWRKTBL_CLEAR,
    RTDRV_L34_HWARPTRFWRKTBL_GET,
    RTDRV_L34_ARPTRFTB_GET,
    RTDRV_L34_HWARPTRFWRKTBL_CLEAR,
    RTDRV_L34_NAPTTRFINDICATOR_GET_ALL,
    RTDRV_L34_ARPTRFINDICATOR_GET_ALL,
    RTDRV_L34_PPPTRFINDICATOR_GET_ALL,
    RTDRV_L34_IPV6MCROUTINGTRANSIDX_GET,
    RTDRV_L34_DSLITEINFTABLE_GET,
    RTDRV_L34_DSLITEMCTABLE_GET,
    RTDRV_L34_DSLITECONTROL_GET,
    RTDRV_L34_FLOWROUTE_GET,
    RTDRV_L34_FLOWTRFINDICATOR_GET,
    RTDRV_L34_MIB_GET,
    RTDRV_L34_LUTMISS_GET,
};

enum rtdrv_led_get_e
{
    RTDRV_LED_BASED_GET= (RTDRV_BASE_CTL + RTDRV_LED_OFFSET + 1),
    RTDRV_LED_OPERATION_GET,
    RTDRV_LED_SERIALMODE_GET,
    RTDRV_LED_BLINKRATE_GET,
    RTDRV_LED_CONFIG_GET,
    RTDRV_LED_MODEFORCE_GET,
    RTDRV_LED_PARALLELENABLE_GET,
    RTDRV_LED_PONALARM_GET,
    RTDRV_LED_PONWARNING_GET,
    RTDRV_LED_PARALLELMODE_GET,
};

enum rtdrv_mirror_get_e
{
    RTDRV_MIRROR_BASED_GET= (RTDRV_BASE_CTL + RTDRV_MIRROR_OFFSET + 1),
    RTDRV_MIRROR_PORTBASED_GET,
    RTDRV_MIRROR_PORTISO_GET,

};

enum rtdrv_oam_get_e
{
    RTDRV_OAM_BASED_GET= (RTDRV_BASE_CTL + RTDRV_OAM_OFFSET + 1),
    RTDRV_OAM_PARSERACTION_GET,
    RTDRV_OAM_MULTIPLEXERACTION_GET
};

enum rtdrv_ponmac_get_e
{
    RTDRV_PONMAC_BASED_GET= (RTDRV_BASE_CTL + RTDRV_PONMAC_OFFSET + 1),
    RTDRV_PONMAC_QUEUE_GET,
    RTDRV_PONMAC_FLOW2QUEUE_GET,
    RTDRV_PONMAC_TRANSCEIVER_GET,
    RTDRV_PONMAC_MODE_GET,
    RTDRV_PONMAC_LINKSTATE_GET,
    RTDRV_PONMAC_BWTHRESHOLD_GET,
    RTDRV_PONMAC_SCHEDULINGTYPE_GET,
    RTDRV_PONMAC_EGRBANDWIDTHCTRLRATE_GET,
    RTDRV_PONMAC_EGRSCHEDULEIDRATE_GET,
    RTDRV_PONMAC_FLOWVALID_GET,
    RTDRV_PONMAC_LOSSTATE_GET,
    RTDRV_PONMAC_SYNCE_GET,
    RTDRV_PONMAC_EGRBANDWIDTHCTRLINCLUDEIFG_GET,
    RTDRV_PONMAC_EGRSCHEDULEIDINCLUDEIFG_GET,
    RTDRV_PONMAC_TXDISGPIOID_GET,
    RTDRV_PONMAC_TXPOWERGPIOID_GET,
    RTDRV_PONMAC_AGGTCONTSTATE_GET,
    RTDRV_PONMAC_TXDISABLEGPIO_GET,
    RTDRV_PONMAC_TXPOWERDISABLEGPIO_GET,
};

enum rtdrv_port_get_e
{
    RTDRV_PORT_BASED_GET= (RTDRV_BASE_CTL + RTDRV_PORT_OFFSET + 1),
    RTDRV_PORT_LINK_GET,
    RTDRV_PORT_SPEEDDUPLEX_GET,
    RTDRV_PORT_FLOWCTRL_GET,
    RTDRV_PORT_PHYAUTONEGOENABLE_GET,
    RTDRV_PORT_PHYAUTONEGOABILITY_GET,
    RTDRV_PORT_PHYFORCEMODEABILITY_GET,
    RTDRV_PORT_PHYREG_GET,
    RTDRV_PORT_PHYMASTERSLAVE_GET,
    RTDRV_PORT_PHYTESTMODE_GET,
    RTDRV_PORT_CPUPORTID_GET,
    RTDRV_PORT_ISOLATION_GET,
    RTDRV_PORT_ISOLATIONEXT_GET,
    RTDRV_PORT_ISOLATIONL34_GET,
    RTDRV_PORT_ISOLATIONEXTL34_GET,
    RTDRV_PORT_ISOLATIONENTRY_GET,
    RTDRV_PORT_ISOLATIONENTRYEXT_GET,
    RTDRV_PORT_ISOLATIONCTAGPKTCONFIG_GET,
    RTDRV_PORT_ISOLATIONL34PKTCONFIG_GET,
    RTDRV_PORT_ISOLATIONIPMCLEAKY_GET,
    RTDRV_PORT_ISOLATIONPORTLEAKY_GET,
    RTDRV_PORT_ISOLATIONLEAKY_GET,
    RTDRV_PORT_MACREMOTELOOPBACKENABLE_GET,
    RTDRV_PORT_MACLOCALLOOPBACKENABLE_GET,
    RTDRV_PORT_ADMINENABLE_GET,
    RTDRV_PORT_SPECIALCONGEST_GET,
    RTDRV_PORT_SPECIALCONGESTSTATUS_GET,
    RTDRV_PORT_GREENENABLE_GET,
    RTDRV_PORT_PHYCROSSOVERMODE_GET,
    RTDRV_PORT_ENHANCEDFID_GET,
    RTDRV_PORT_RTCTRESULT_GET,
    RTDRV_PORT_RTCT_START,
    RTDRV_PORT_MACFORCEABILITY_GET,
    RTDRV_PORT_MACFORCEABILITYSTATE_GET,
    RTDRV_PORT_MACEXTMODE_GET,
    RTDRV_PORT_MACEXTRGMIIDELAY_GET,
    RTDRV_PORT_GIGALITEENABLE_GET,
    RTDRV_PORT_EEEENABLE_GET,
    RTDRV_PORT_PHYPOWERDOWN_GET,
    RTDRV_PORT_SERDESMODE_GET,
    RTDRV_PORT_SERDESNWAY_GET,
};

enum rtdrv_qos_get_e
{
    RTDRV_QOS_BASED_GET= (RTDRV_BASE_CTL + RTDRV_QOS_OFFSET + 1),
    RTDRV_QOS_PRISELGROUP_GET,
    RTDRV_QOS_PORTPRI_GET,
    RTDRV_QOS_DSCPPRIREMAPGROUP_GET,
    RTDRV_QOS_1PPRIREMAPGROUP_GET,
    RTDRV_QOS_PRIMAP_GET,
    RTDRV_QOS_PORTPRIMAP_GET,
    RTDRV_QOS_1PREMARKENABLE_GET,
    RTDRV_QOS_1PREMARKGROUP_GET,
    RTDRV_QOS_DSCPREMARKENABLE_GET,
    RTDRV_QOS_DSCPREMARKGROUP_GET,
    RTDRV_QOS_PORTDSCPREMARKSRCSEL_GET,
    RTDRV_QOS_DSCP2DSCPREMARKGROUP_GET,
    RTDRV_QOS_FWD2CPUPRIREMAP_GET,
    RTDRV_QOS_SCHEDULINGQUEUE_GET,
    RTDRV_QOS_PORTPRISELGROUP_GET,
    RTDRV_QOS_SCHEDULINGTYPE_GET,
    RTDRV_QOS_PORTDOT1PREMARKSRCSEL_GET,pon
};

enum rtdrv_rldp_get_e
{
    RTDRV_RLDP_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RLDP_OFFSET + 1),
    RTDRV_RLDP_CONFIG_GET,
    RTDRV_RLDP_PORTCONFIG_GET,
    RTDRV_RLDP_STATUS_GET,
    RTDRV_RLDP_PORTSTATUS_GET,
    RTDRV_RLPP_TRAPTYPE_GET,
};

enum rtdrv_sec_get_e
{
    RTDRV_SEC_BASED_GET= (RTDRV_BASE_CTL + RTDRV_SEC_OFFSET + 1),
    RTDRV_SEC_PORTATTACKPREVENTSTATE_GET,
    RTDRV_SEC_ATTACKPREVENT_GET,
    RTDRV_SEC_ATTACKFLOODTHRESH_GET,
    RTDRV_SEC_ATTACKFLOODTHRESHUNIT_GET,
};

enum rtdrv_stat_get_e
{
    RTDRV_STAT_BASED_GET= (RTDRV_BASE_CTL + RTDRV_STAT_OFFSET + 1),
    RTDRV_STAT_RSTCNTVALUE_GET,
    RTDRV_STAT_GLOBAL_GET,
    RTDRV_STAT_GLOBAL_GETALL,
    RTDRV_STAT_PORT_GET,
    RTDRV_STAT_PORT_GETALL,
    RTDRV_STAT_LOG_GET,
    RTDRV_STAT_LOGCTRL_GET,
    RTDRV_STAT_MIBCNTMODE_GET,
    RTDRV_STAT_MIBLATCHTIMER_GET,
    RTDRV_STAT_MIBSYNCMODE_GET,
    RTDRV_STAT_MIBCNTTAGLEN_GET,
    RTDRV_STAT_PKTINFO_GET,
    RTDRV_STAT_HOSTCNT_GET,
    RTDRV_STAT_HOSTSTATE_GET,

};

enum rtdrv_stp_get_e
{
    RTDRV_STP_BASED_GET= (RTDRV_BASE_CTL + RTDRV_STP_OFFSET + 1),
    RTDRV_STP_MSTPSTATE_GET,
};

enum rtdrv_svlan_get_e
{
    RTDRV_SVLAN_BASED_GET= (RTDRV_BASE_CTL + RTDRV_SVLAN_OFFSET + 1),
    RTDRV_SVLAN_PORTSVID_GET,
    RTDRV_SVLAN_SERVICEPORT_GET,
    RTDRV_SVLAN_MEMBERPORT_GET,
    RTDRV_SVLAN_TPIDENTRY_GET,
    RTDRV_SVLAN_PRIORITYREF_GET,
    RTDRV_SVLAN_MEMBERPORTENTRY_GET,
    RTDRV_SVLAN_IPMC2S_GET,
    RTDRV_SVLAN_L2MC2S_GET,
    RTDRV_SVLAN_SP2C_GET,
    RTDRV_SVLAN_DMACVIDSELSTATE_GET,
    RTDRV_SVLAN_UNMATCHACTION_GET,
    RTDRV_SVLAN_UNTAGACTION_GET,
    RTDRV_SVLAN_C2S_GET,
    RTDRV_SVLAN_TRAPPRI_GET,
    RTDRV_SVLAN_DEIKEEPSTATE_GET,
    RTDRV_SVLAN_LOOKUPTYPE_GET,
    RTDRV_SVLAN_SP2CUNMATCHCTAGGING_GET,
    RTDRV_SVLAN_PRIORITY_GET,
    RTDRV_SVLAN_FID_GET,
    RTDRV_SVLAN_FIDENABLE_GET,
    RTDRV_SVLAN_ENHANCEDFID_GET,
    RTDRV_SVLAN_ENHANCEDFIDENABLE_GET,
    RTDRV_SVLAN_DMACVIDSELFORCEDSTATE_GET,
    RTDRV_SVLAN_SVLANFUNCTIONENABLE_GET,
    RTDRV_SVLAN_TPIDENABLE_GET,
    RTDRV_SVLAN_SP2CPRIORITY_GET,
    RTDRV_SVLAN_EXTPORTPVID_GET,

};

enum rtdrv_switch_get_e
{
    RTDRV_SWITCH_BASED_GET= (RTDRV_BASE_CTL + RTDRV_SWITCH_OFFSET + 1),
    RTDRV_SWITCH_DEVICEINFO_GET,
    RTDRV_SWITCH_PHYPORTID_GET,
    RTDRV_SWITCH_LOGICALPORT_GET,
    RTDRV_SWITCH_PORTIDINMASK_CHECK,
    RTDRV_SWITCH_PORTMASK_CLEAR,
    RTDRV_SWITCH_NEXTPORTINMASK_GET,
    RTDRV_SWITCH_MAXPKTLENLINKSPEED_GET,
    RTDRV_SWITCH_MGMTMACADDR_GET,
    RTDRV_SWITCH_MAXPKTLENBYPORT_GET,
    RTDRV_SWITCH_CHANGEDUPLEX_GET,
    RTDRV_SWITCH_VERSION_GET,
    RTDRV_SWITCH_PATCH_INFO_GET,
    RTDRV_SWITCH_CSEXTID_GET,
    RTDRV_SWITCH_THERMAL_GET
};

enum rtdrv_trap_get_e
{
    RTDRV_TRAP_BASED_GET= (RTDRV_BASE_CTL + RTDRV_TRAP_OFFSET + 1),
    RTDRV_TRAP_REASONTRAPTOCPUPRIORITY_GET,
    RTDRV_TRAP_IGMPCTRLPKT2CPUENABLE_GET,
    RTDRV_TRAP_MLDCTRLPKT2CPUENABLE_GET,
    RTDRV_TRAP_PORTIGMPMLDCTRLPKTACTION_GET,
    RTDRV_TRAP_IPMCASTPKT2CPUENABLE_GET,
    RTDRV_TRAP_L2MCASTPKT2CPUENABLE_GET,
    RTDRV_TRAP_RMAACTION_GET,
    RTDRV_TRAP_RMAPRI_GET,
    RTDRV_TRAP_OAMPDUACTION_GET,
    RTDRV_TRAP_PORTOAMPDUACTION_GET,
    RTDRV_TRAP_OAMPDUPRI_GET,
    RTDRV_TRAP_UNITRAPPRIORITYENABLE_GET,
    RTDRV_TRAP_UNITRAPPRIORITYPRIORITY_GET,
    RTDRV_TRAP_CPUTRAPHASHMASK_GET,
    RTDRV_TRAP_CPUTRAPHASHPORT_GET,
    RTDRV_TRAP_CPUTRAPHASHSTATE_GET,
    RTDRV_TRAP_CPUTRAPINICHASHSTATE_GET,
    RTDRV_TRAP_CPUTRAPINICHASHSELECT_GET,
};

enum rtdrv_trunk_get_e
{
    RTDRV_TRUNK_BASED_GET= (RTDRV_BASE_CTL + RTDRV_TRUNK_OFFSET + 1),
    RTDRV_TRUNK_DISTRIBUTIONALGORITHM_GET,
    RTDRV_TRUNK_PORT_GET,
    RTDRV_TRUNK_HASHMAPPINGTABLE_GET,
    RTDRV_TRUNK_MODE_GET,
    RTDRV_TRUNK_TRAFFICSEPARATE_GET,
    RTDRV_TRUNK_PORTQUEUEEMPTY_GET,
    RTDRV_TRUNK_TRAFFICPAUSE_GET,

};

enum rtdrv_vlan_get_e
{
    RTDRV_VLAN_BASED_GET= (RTDRV_BASE_CTL + RTDRV_VLAN_OFFSET + 1),
    RTDRV_VLAN_FID_GET,
    RTDRV_VLAN_FIDMODE_GET,
    RTDRV_VLAN_PORT_GET,
    RTDRV_VLAN_EXTPORT_GET,
    RTDRV_VLAN_STG_GET,
    RTDRV_VLAN_PRIORITY_GET,
    RTDRV_VLAN_PRIORITYENABLE_GET,
    RTDRV_VLAN_POLICINGENABLE_GET,
    RTDRV_VLAN_POLICINGMETERIDX_GET,
    RTDRV_VLAN_PORTACCEPTFRAMETYPE_GET,
    RTDRV_VLAN_VLANFUNCTIONENABLE_GET,
    RTDRV_VLAN_PORTIGRFILTERENABLE_GET,
    RTDRV_VLAN_LEAKY_GET,
    RTDRV_VLAN_PORTLEAKY_GET,
    RTDRV_VLAN_KEEPTYPE_GET,
    RTDRV_VLAN_PORTPVID_GET,
    RTDRV_VLAN_EXTPORTPVID_GET,
    RTDRV_VLAN_PROTOGROUP_GET,
    RTDRV_VLAN_PORTPROTOVLAN_GET,
    RTDRV_VLAN_TAGMODE_GET,
    RTDRV_VLAN_PORTFID_GET,
    RTDRV_VLAN_PORTPRIORITY_GET,
    RTDRV_VLAN_PORTEGRTAGKEEPTYPE_GET,
    RTDRV_VLAN_TRANSPARENTENABLE_GET,
    RTDRV_VLAN_CFIKEEPENABLE_GET,
    RTDRV_VLAN_RESERVEDVIDACTION_GET,
    RTDRV_VLAN_TAGMODEIP4MC_GET,
    RTDRV_VLAN_TAGMODEIP6MC_GET,
    RTDRV_VLAN_LUTSVLANHASHSTATE_GET,
    RTDRV_VLAN_EXTPORTPROTOVLAN_GET,
    RTDRV_VLAN_EXTPORTMASKINDEX_GET,
    RTDRV_VLAN_EXTPORTMASKCFG_GET,

};

enum rtdrv_rate_get_e
{
    RTDRV_RATE_PORTIGRBANDWIDTHCTRLRATE_GET= (RTDRV_BASE_CTL + RTDRV_RATE_OFFSET + 1),
    RTDRV_RATE_PORTIGRBANDWIDTHCTRLINCLUDEIFG_GET,
    RTDRV_RATE_PORTEGRBANDWIDTHCTRLRATE_GET,
    RTDRV_RATE_EGRBANDWIDTHCTRLINCLUDEIFG_GET,
    RTDRV_RATE_PORTEGRBANDWIDTHCTRLINCLUDEIFG_GET,
    RTDRV_RATE_EGRQUEUEBWCTRLENABLE_GET,
    RTDRV_RATE_EGRQUEUEBWCTRLMETERIDX_GET,
    RTDRV_RATE_STORMCONTROLMETERIDX_GET,
    RTDRV_RATE_STORMCONTROLPORTENABLE_GET,
    RTDRV_RATE_STORMCONTROLENABLE_GET,
    RTDRV_RATE_STORMBYPASS_GET,
    RTDRV_RATE_SHAREMETER_GET,
    RTDRV_RATE_SHAREMETERBUCKET_GET,
    RTDRV_RATE_SHAREMETEREXCEED_GET,
    RTDRV_RATE_SHAREMETERMODE_GET,
    RTDRV_RATE_HOSTIGRBWCTRLSTATE_GET,
    RTDRV_RATE_HOSTEGRBWCTRLSTATE_GET,
    RTDRV_RATE_HOSTBWCTRLMETERIDX_GET,
    RTDRV_RATE_HOSTMACADDR_GET,
    RTDRV_RATE_HOSTIGRBWCTRLMETERIDX_GET,
    RTDRV_RATE_HOSTEGRBWCTRLMETERIDX_GET,

};

enum rtdrv_gpon_get_e
{
    RTDRV_GPON_SN_GET = (RTDRV_BASE_CTL + RTDRV_GPON_OFFSET),
    RTDRV_GPON_PWD_GET,
    RTDRV_GPON_STATE_GET,
    RTDRV_GPON_ALARM_GET,
    RTDRV_GPON_PARA_GET,
    RTDRV_GPON_TCONT_GET,
    RTDRV_GPON_DS_FLOW_GET,
    RTDRV_GPON_US_FLOW_GET,
    RTDRV_GPON_BC_PASS_GET,
    RTDRV_GPON_NON_MC_PASS_GET,
    RTDRV_GPON_IP_PTN_GET,
    RTDRV_GPON_FLT_MODE_GET,
    RTDRV_GPON_FS_MODE_GET,
    RTDRV_GPON_MAC_ENTRY_GET,
    RTDRV_GPON_RDI_GET,
    RTDRV_GPON_PWR_LEVEL_GET,
    RTDRV_GPON_TX_LASER_GET,
    RTDRV_GPON_FS_IDLE_GET,
    RTDRV_GPON_FS_PRBS_GET,
    RTDRV_GPON_DS_FEC_GET,
    RTDRV_GPON_VERSION_SHOW,
    RTDRV_GPON_DEV_SHOW,
    RTDRV_GPON_GTC_SHOW,
    RTDRV_GPON_TCONT_SHOW,
    RTDRV_GPON_DS_FLOW_SHOW,
    RTDRV_GPON_US_FLOW_SHOW,
    RTDRV_GPON_MAC_TABLE_SHOW,
    RTDRV_GPON_GLB_CNT_SHOW,
    RTDRV_GPON_GLB_CNT_GET,
    RTDRV_GPON_TCONT_CNT_SHOW,
    RTDRV_GPON_TCONT_CNT_GET,
    RTDRV_GPON_FLOW_CNT_SHOW,

    RTDRV_GPON_FLOW_CNT_GET,
    RTDRV_GPON_TEST_GET,
    RTDRV_GPON_AUTO_TCONT_GET,
    RTDRV_GPON_AUTO_BOH_GET,
    RTDRV_GPON_EQD_OFFSET_GET,
    RTDRV_GPON_EXTMSG_GET,
    RTDRV_GPON_AES_KEY_SWITCH_GET,
    RTDRV_GPON_BER_INTERVAL_GET,
    RTDRV_GPON_US_FEC_GET,
    RTDRV_GPON_DBRU_BLOCK_SIZE_GET,
    RTDRV_GPON_ROGUE_SD_CNT_GET,
    RTDRV_GPON_PPS_CNT_GET,
    RTDRV_GPON_FEC_GET,
    RTDRV_GPON_EQD_GET,
};

enum rtdrv_pkt_get_e
{
    RTDRV_PKT_RXDUMP_GET = (RTDRV_BASE_CTL + RTDRV_PKT_OFFSET),
    RTDRV_PKTFIFO_RXDUMP_GET,
    RTDRV_PKT_CONTINUSCNT_GET,
    RTDRV_PKT_RXGMAC_GET,
};

enum rtdrv_gpio_get_e
{
    RTDRV_GPIO_STATE_GET= (RTDRV_BASE_CTL + RTDRV_GPIO_OFFSET),
    RTDRV_GPIO_MODE_GET,
    RTDRV_GPIO_DATABIT_GET,
    RTDRV_GPIO_INTR_GET,
    RTDRV_GPIO_IMS_GET,
};

enum rtdrv_i2c_get_e
{
    RTDRV_I2C_ENABLE_GET = (RTDRV_BASE_CTL + RTDRV_I2C_OFFSET),
    RTDRV_I2C_WIDTH_GET,
    RTDRV_I2C_READ,
    RTDRV_I2C_CLOCK_GET,
    RTDRV_I2C_EEPMIRROR_GET,
    RTDRV_I2C_EEPMIRROR_READ,
    RTDRV_I2C_DATAWIDTH_GET,
    RTDRV_I2C_ADDRWIDTH_GET,
    RTDRV_I2C_SEQ_READ,
    RTDRV_I2C_CURR_READ,
    RTDRV_I2C_SEQCURR_READ,
};

enum rtdrv_l34lite_get_e
{
    RTDRV_L34_NETIF_GET = (RTDRV_BASE_CTL + RTDRV_L34_LITE_OFFSET),
    RTDRV_L34_ARP_GET,
    RTDRV_L34_ROUTE_GET,
    RTDRV_L34_CONNECTTRACK_GET,
    RTDRV_L34_GLOBALCFG_GET,
    RTDRV_L34_ROUTE6_GET,
    RTDRV_L34_NEIGH6_GET,

};


enum rtdrv_epon_get_e
{
    RTDRV_EPON_INTRMASK_GET = (RTDRV_BASE_CTL + RTDRV_EPON_OFFSET),
    RTDRV_EPON_INTR_GET,
    RTDRV_EPON_LLID_ENTRY_GET,
    RTDRV_EPON_FORCELASERSTATE_GET,
    RTDRV_EPON_LASERTIME_GET,
    RTDRV_EPON_SYNCTIME_GET,
    RTDRV_EPON_REGISTERREQ_GET,
    RTDRV_EPON_CHURNINGKEY_GET,
    RTDRV_EPON_USFECSTATE_GET,
    RTDRV_EPON_DSFECSTATE_GET,
    RTDRV_EPON_MIBCOUNTER_GET,
    RTDRV_EPON_LOSSTATE_GET,
    RTDRV_EPON_MPCPTIMEOUTVAL_GET,
    RTDRV_EPON_OPTICALPOLARITY_GET,
    RTDRV_EPON_FECSTATE_GET,
    RTDRV_EPON_LLIDENTRYNUM_GET,
    RTDRV_EPON_THRESHOLDREPORT_GET,
    RTDRV_EPON_DBGINFO_GET,
    RTDRV_EPON_CHURNINGSTATUS_GET,
    RTDRV_EPON_FORCEPRBS_GET,
    RTDRV_EPON_MULTILLIDMODE_GET,
    RTDRV_EPON_REPORTQUEUESET_GET,
    RTDRV_EPON_QUEUETHRESHOLDREPORT_GET,
    RTDRV_EPON_AUTOPOWERSAVINGSTATE_GET,
    RTDRV_EPON_AUTOPOWERSAVINGOERECOVERTIME_GET,
};

enum rtdrv_time_get_e
{
    RTDRV_TIME_BASED_GET= (RTDRV_BASE_CTL + RTDRV_TIME_OFFSET + 1),
    RTDRV_TIME_PORTTRANSPARENTENABLE_GET,
    RTDRV_TIME_PORTPTPENABLE_GET,
    RTDRV_TIME_CURTIME_GET,
    RTDRV_TIME_CURTIME_LATCH,
    RTDRV_TIME_REFTIME_GET,
    RTDRV_TIME_FREQUENCY_GET,
    RTDRV_TIME_PTPIGRMSGACTION_GET,
    RTDRV_TIME_PTPEGRMSGACTION_GET,
    RTDRV_TIME_MEANPATHDELAY_GET,
    RTDRV_TIME_RXTIME_GET,
    RTDRV_TIME_PONTOD_GET,
    RTDRV_TIME_PORTPTPTXINDICATOR_GET,
    RTDRV_TIME_TODENABLE_GET,
    RTDRV_TIME_PPSENABLE_GET,
    RTDRV_TIME_PPSMODE_GET,
    RTDRV_TIME_FREETIME_GET,
};

enum rtdrv_ppstod_get_e
{
    RTDRV_PPSTOD_BASED_GET= (RTDRV_BASE_CTL + RTDRV_PPSTOD_OFFSET + 1),
    RTDRV_PPSTOD_DELAY_GET,
    RTDRV_PPSTOD_PULSEWIDTH_GET,
    RTDRV_PPSTOD_MODE_GET,
    RTDRV_PPSTOD_SARPGPSWEEK_GET,
    RTDRV_PPSTOD_SARPUTCSEC_GET,
    RTDRV_PPSTOD_FRAMELEN_GET,
    RTDRV_PPSTOD_FRAMEDATA_GET,
    RTDRV_PPSTOD_BAUDRATE_GET,
};

enum rtdrv_ponled_get_e
{
    RTDRV_PONLED_BASED_GET= (RTDRV_BASE_CTL + RTDRV_PONLED_OFFSET + 1),
    RTDRV_PONLED_SPECTYPE_GET,
    RTDRV_PONLED_STATUS_GET,
    RTDRV_PONLED_GROUP_GET,
};

enum rtdrv_pbo_get_e
{
    RTDRV_PBO_BASED_GET= (RTDRV_BASE_CTL + RTDRV_PBO_OFFSET + 1),
    RTDRV_SWPBO_PORTSTATE_GET,
    RTDRV_SWPBO_PORTAUTOCONF_GET,
    RTDRV_SWPBO_PORTTHRESHOLD_GET,
    RTDRV_SWPBO_QUEUETHRESHOLD_GET,
    RTDRV_SWPBO_PORTUSEDPAGE_GET,
    RTDRV_SWPBO_QUEUEUSEDPAGE_GET,
    RTDRV_SWPBO_PORTDSC_GET,
};

enum rtdrv_mdio_get_e
{
    RTDRV_MDIO_BASED_GET= (RTDRV_BASE_CTL + RTDRV_MDIO_OFFSET + 1),
    RTDRV_MDIO_CFG_GET,
    RTDRV_MDIO_C22_READ,
    RTDRV_MDIO_C45_READ,
};

#if defined(CONFIG_COMMON_RT_API)
enum rtdrv_rt_switch_get_e
{
    RTDRV_RT_SWITCH_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_SWITCH_OFFSET + 1),
    RTDRV_RT_SWITCH_PHYPORTID_GET,
    RTDRV_RT_SWITCH_VERSION_GET,
    RTDRV_RT_SWITCH_MAXPKTLENBYPORT_GET,
    RTDRV_RT_SWITCH_DEVICEINFO_GET,
};

enum rtdrv_rt_gpon_get_e
{
    RTDRV_RT_GPON_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_GPON_OFFSET + 1),
    RTDRV_RT_GPON_ACTIVATE,
    RTDRV_RT_GPON_DEACTIVATE,
    RTDRV_RT_GPON_ONUSTATE_GET,
    RTDRV_RT_GPON_TCONT_GET,
    RTDRV_RT_GPON_USFLOW_GET,
    RTDRV_RT_GPON_DSFLOW_GET,
    RTDRV_RT_GPON_LOOPGEM_GET,
    RTDRV_RT_GPON_PONQUEUE_GET,
    RTDRV_RT_GPON_SCHEINFO_GET,
    RTDRV_RT_GPON_FLOWCOUNTER_GET,
    RTDRV_RT_GPON_PMCOUNTER_GET,
    RTDRV_RT_GPON_PONTAG_GET,
    RTDRV_RT_GPON_OMCI_MIC_GENERATE,
    RTDRV_RT_GPON_EGRBANDWIDTHCTRLRATE_GET,
    RTDRV_RT_GPON_ATTRIBUTE_GET,
    RTDRV_RT_GPON_OMCC_GET,
    RTDRV_RT_GPON_FEC_GET,
    RTDRV_RT_GPON_REGISTRATIONID_GET,
    RTDRV_RT_GPON_TCONTCOUNTER_GET,
    RTDRV_RT_GPON_SERIALNUMBER_GET,
};

enum rtdrv_rt_stat_get_e
{
    RTDRV_RT_STAT_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_STAT_OFFSET + 1),
    RTDRV_RT_STAT_PORT_GET,
    RTDRV_RT_STAT_PORT_GETALL,
};

enum rtdrv_rt_rate_get_e
{
    RTDRV_RT_RATE_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_RATE_OFFSET + 1),
    RTDRV_RT_RATE_PORTIGRBANDWIDTHCTRLRATE_GET,
    RTDRV_RT_RATE_PORTEGRBANDWIDTHCTRLRATE_GET,
    RTDRV_RT_RATE_STORMCONTROLMETERIDX_GET,
    RTDRV_RT_RATE_STORMCONTROLPORTENABLE_GET,
    RTDRV_RT_RATE_SHAREMETERTYPE_ADD,
    RTDRV_RT_RATE_SHAREMETERTYPE_GET,
    RTDRV_RT_RATE_SHAREMETERRATE_GET,
    RTDRV_RT_RATE_SHAREMETERMAPPINGHW_GET,
    RTDRV_RT_RATE_SHAREMETERMAPPINGVIRTUAL_GET,
    RTDRV_RT_RATE_SHAREMETERBUCKET_GET,
    RTDRV_RT_RATE_SHAREMETERIFGINCLUDE_GET,
};

enum rtdrv_rt_qos_get_e
{
    RTDRV_RT_QOS_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_QOS_OFFSET + 1),
    RTDRV_RT_QOS_SCHEDULINGQUEUE_GET,
    RTDRV_RT_QOS_DSCP2PBIT_GET,
};

enum rtdrv_rt_intr_get_e
{
    RTDRV_RT_INTR_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_INTR_OFFSET + 1),
    RTDRV_RT_INTR_IMR_GET,
};

enum rtdrv_rt_sec_get_e
{
    RTDRV_RT_SEC_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_SEC_OFFSET + 1),
    RTDRV_RT_SEC_PORTATTACKPREVENTSTATE_GET,
    RTDRV_RT_SEC_ATTACKPREVENT_GET,
    RTDRV_RT_SEC_ATTACKFLOODTHRESH_GET,
    RTDRV_RT_SEC_ATTACKFLOODTHRESHUNIT_GET,
};

enum rtdrv_rt_trap_get_e
{
    RTDRV_RT_TRAP_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_TRAP_OFFSET + 1),
    RTDRV_RT_TRAP_PORTIGMPMLDCTRLPKTACTION_GET,
    RTDRV_RT_TRAP_OAMPDUACTION_GET,
    RTDRV_RT_TRAP_OMCIACTION_GET,
};

enum rtdrv_rt_i2c_get_e
{
    RTDRV_RT_I2C_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_I2C_OFFSET + 1),
    RTDRV_RT_I2C_ENABLE_GET,
    RTDRV_RT_I2C_READ,
    RTDRV_RT_I2C_SEQ_READ,
    RTDRV_RT_I2C_CLOCK_GET,
};

enum rtdrv_rt_port_get_e
{
    RTDRV_RT_PORT_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_PORT_OFFSET + 1),
    RTDRV_RT_PORT_LINK_GET,
    RTDRV_RT_PORT_SPEEDDUPLEX_GET,
    RTDRV_RT_PORT_FLOWCTRL_GET,
    RTDRV_RT_PORT_PHYAUTONEGOENABLE_GET,
    RTDRV_RT_PORT_PHYAUTONEGOABILITY_GET,
    RTDRV_RT_PORT_PHYFORCEMODEABILITY_GET,
    RTDRV_RT_PORT_PHYREG_GET,
    RTDRV_RT_PORT_ADMINENABLE_GET,
    RTDRV_RT_PORT_ISOLATIONENTRY_GET,
    RTDRV_RT_PORT_UNITYPE_GET,
    RTDRV_RT_PORT_PORTDEF_GET,
    RTDRV_RT_PORT_PHYPOWERDOWN_GET,
};

enum rtdrv_rt_l2_get_e
{
    RTDRV_RT_L2_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_L2_OFFSET + 1),
    RTDRV_RT_L2_PORTLIMITLEARNINGCNT_GET,
    RTDRV_RT_L2_NEWMACOP_GET,
    RTDRV_RT_L2_ADDR_GET,
    RTDRV_RT_L2_NEXTVALIDADDR_GET,
    RTDRV_RT_L2_NEXTVALIDADDRONPORT_GET,
    RTDRV_RT_L2_ILLEGALPORTMOVEACTION_GET,
    RTDRV_RT_L2_AGETIME_GET,
    RTDRV_RT_L2_IVLSVL_GET,
};

enum rtdrv_rt_epon_get_e
{
    RTDRV_RT_EPON_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_EPON_OFFSET + 1),
    RTDRV_RT_EPON_LLID_ENTRY_GET,
    RTDRV_RT_EPON_REGISTERREQ_GET,
    RTDRV_RT_EPON_CHURNINGKEY_GET,
    RTDRV_RT_EPON_USFECSTATE_GET,
    RTDRV_RT_EPON_DSFECSTATE_GET,
    RTDRV_RT_EPON_MIBCOUNTER_GET,
    RTDRV_RT_EPON_LOSSTATE_GET,
    RTDRV_RT_EPON_PONQUEUE_GET,
    RTDRV_RT_EPON_EGRBANDWIDTHCTRLRATE_GET,
    RTDRV_RT_EPON_MPCP_INFO_GET,
    RTDRV_RT_EPON_MPCP_QUEUE_THRESHOLD_GET,
};

enum rtdrv_rt_cls_get_e
{
    RTDRV_RT_CLS_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_CLS_OFFSET + 1),
};

enum rtdrv_rt_ponmisc_get_e
{
    RTDRV_RT_PONMISC_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_PONMISC_OFFSET + 1),
    RTDRV_RT_PONMISC_MODESPEED_GET,
    RTDRV_RT_PONMISC_SID_GET,
    RTDRV_RT_PONMISC_TRX_GET,
    RTDRV_RT_PONMISC_BURSTPOLARITYREVERSE_GET,
    RTDRV_RT_PONMISC_FORCELASER_GET,
    RTDRV_RT_PONMISC_FORCEPRBS_GET,
};

enum rtdrv_rt_mirror_get_e
{
    RTDRV_RT_MIRROR_BASED_GET= (RTDRV_BASE_CTL + RTDRV_RT_MIRROR_OFFSET + 1),
    RTDRV_RT_MIRROR_PORTBASED_GET,
};
#endif

#if defined(CONFIG_EUROPA_FEATURE)
enum rtdrv_ldd_get_e
{
    RTDRV_LDD_BASED_GET= (RTDRV_BASE_CTL + RTDRV_LDD_OFFSET + 1),
    RTDRV_LDD_PARAMETER_GET,
    RTDRV_LDD_POWER_ON_GET,
    RTDRV_LDD_TX_POWER_GET,
    RTDRV_LDD_RX_POWER_GET,
    RTDRV_LDD_RSSI_VOLTAGE_GET,
    RTDRV_LDD_RSSI_V0_GET,
    RTDRV_LDD_VDD_GET,
    RTDRV_LDD_MPD0_GET,
    RTDRV_LDD_TEMPERATURE_GET,
    RTDRV_LDD_TX_BIAS_GET,
    RTDRV_LDD_TX_MOD_GET,
    RTDRV_LDD_DRIVER_VERSION_GET,
    RTDRV_LDD_TXCROSS_GET,
    RTDRV_LDD_APC_IAVG_GET,
    RTDRV_LDD_APC_ER_GET,    
    RTDRV_LDD_APC_ERTRIM_GET,    
    RTDRV_LDD_RXLOS_REFDAC_GET, 
    RTDRV_LDD_RXLOS_HYSTSEL_GET,        
};
#endif

/***** end of RTDRV_GET *****/



/*module API parameter*/
typedef struct rtdrv_regCfg_s
{
    uint32  reg;
    uint32  bit;
    uint32  value;
} rtdrv_regCfg_t;




typedef struct rtdrv_addrCfg_s
{
    uint32  address;
    uint32  value;
} rtdrv_addrCfg_t;


/*
 * Data Declaration
 */
typedef struct rtdrv_logCfg_s
{
    uint32 log_level;
    uint32 log_level_mask;
    uint32 log_level_type;
    uint32 log_module_mask;
    uint32 log_format;
} rtdrv_logCfg_t;

typedef struct rtdrv_ponAlarm_s
{
    rtk_gpon_alarm_type_t   type;
    int32                   status;
} rtdrv_ponAlarm_t;

typedef union rtdrv_pon_union_u
{
    rtk_gpon_onu_activation_para_t  timer;
    rtk_gpon_laser_para_t           laser;
    rtk_gpon_ds_physical_para_t     ds_phy;
    rtk_gpon_ds_ploam_para_t        ds_plm;
    rtk_gpon_ds_bwMap_para_t        ds_bw;
    rtk_gpon_ds_gem_para_t          ds_gem;
    rtk_gpon_ds_eth_para_t          ds_eth;
    rtk_gpon_ds_omci_para_t         ds_omci;
    rtk_gpon_us_physical_para_t     us_phy;
    rtk_gpon_us_ploam_para_t        us_plm;
    rtk_gpon_us_dbr_para_t          us_dbr;

} rtdrv_pon_union_t;

typedef struct rtdrv_ponPara_s
{
    rtk_gpon_patameter_type_t   type;
    rtdrv_pon_union_t           para;
} rtdrv_ponPara_t;

typedef struct rtdrv_tcont_s
{
    rtk_gpon_tcont_ind_t        ind;
    rtk_gpon_tcont_attr_t       attr;
} rtdrv_tcont_t;

typedef struct rtdrv_dsFlow_s
{
    uint32                  flowId;
    rtk_gpon_dsFlow_attr_t  attr;
} rtdrv_dsFlow_t;

typedef struct rtdrv_usFlow_s
{
    uint32                  flowId;
    rtk_gpon_usFlow_attr_t  attr;
} rtdrv_usFlow_t;

typedef struct rtdrv_tcont_cnt_s
{
    uint32                              tcont;
    rtk_gpon_tcont_performance_type_t   cnt_type;
} rtdrv_tcont_cnt_t;

typedef struct rtdrv_flow_cnt_s
{
    uint32                              flow;
    rtk_gpon_flow_performance_type_t    cnt_type;
} rtdrv_flow_cnt_t;

typedef struct rtdrv_ip_ptn_s
{
    uint32 ipv4_pattern;
    uint32 ipv6_pattern;

} rtdrv_ip_ptn_t;

typedef struct rtdrv_fs_mode_s
{
    rtk_gpon_mc_force_mode_t ipv4;
    rtk_gpon_mc_force_mode_t ipv6;

} rtdrv_fs_mode_t;


typedef struct rtdrv_mac_entry_s
{
    uint32                      index;
    rtk_gpon_macTable_entry_t   entry;
} rtdrv_mac_entry_t;



#if defined(OLD_FPGA_DEFINED)
typedef struct rtdrv_pktGen_s
{
    uint32  item;
    uint32  tcont;
    uint32  gem;
    int32   omci;
    uint32  buf_len;
    uint8   buf[2048];
} rtdrv_pktGen_t;
#endif

typedef struct rtdrv_phyCfg_s
{
    uint8   phy_id;
    uint8   reg;
    uint16  value;
} rtdrv_phyCfg_t;


typedef struct rtdrv_pktdbg_s
{
    struct  pkt_dbg_tx_info tx_info;
    struct  pkt_dbg_rx_info rx_info;
    uint32  tx_count;
    uint32  enable;
    uint32  tx_enable;
    uint16  length;
    uint16  rx_length;
    uint32  rx_gmac;
    uint8   buf[2048];
} rtdrv_pktdbg_t;

typedef struct rtdrv_pktfifodbg_s
{
    uint16   fifo_idx;
    uint8   valid;
    uint8   buf[64];
} rtdrv_pktfifodbg_t;

typedef struct rtdrv_rateCfg_s
{
    rtk_port_t      port;
    uint32          rate;
    rtk_enable_t    ifgInclude;
    rtk_enable_t    enable;
    rtk_qid_t       queue;
    uint32          meterIndex;
    rtk_rate_storm_group_t  stormType;
    uint32                  index;
    rtk_rate_storm_group_ctrl_t  stormCtrl;
    rtk_storm_bypass_t type;
    uint32 bucketSize;
    uint32 isExceed;
    rtk_rate_metet_mode_t meterMode;
    rtk_mac_t             mac;
} rtdrv_rateCfg_t;


typedef struct rtdrv_aclCfg_s
{
    rtk_acl_template_t              aclTemplate;
    rtk_acl_field_entry_t           fieldEntry;
    rtk_acl_ingress_entry_t         aclRule;
    rtk_acl_field_t                 aclField;
    uint32                          index;
    rtk_port_t                      port;
    rtk_filter_unmatch_action_type_t    action;
    rtk_enable_t                    state;
    rtk_acl_rangeCheck_ip_t         ipRangeEntry;
    rtk_acl_rangeCheck_vid_t        vidRangeEntry;
    rtk_acl_rangeCheck_l4Port_t     l4PortRangeEntry;
    rtk_acl_rangeCheck_pktLength_t  pktLenRangeEntry;
    rtk_acl_igr_rule_mode_t         mode;
    rtk_acl_dbgCnt_t                dbgCnt;
    rtk_acl_debug_reason_t          hitReason;
}rtdrv_aclCfg_t;

typedef struct rtdrv_vlanCfg_s
{
    rtk_vlan_t                      vid;
    uint32                          restoreDefaultVlan;
    rtk_fid_t                       fid;
    rtk_fidMode_t                   mode;
    rtk_portmask_t                  memberPortmask;
    rtk_portmask_t                  untagPortmask;
    rtk_portmask_t                  member_portmask;
    rtk_portmask_t                  untag_portmask;
    rtk_portmask_t                  ext_portmask;
    rtk_stg_t                       stg;
    rtk_pri_t                       priority;
    rtk_enable_t                    enable;
    uint32                          index;
    rtk_port_t                      port;
    rtk_vlan_acceptFrameType_t      acceptFrameType;
    rtk_leaky_type_t                leakyType;
    rtk_vlan_keep_type_t            keepType;
    uint32                          pvid;
    uint32                          extPort;
    uint32                          protoGroupIdx;
    rtk_vlan_protoGroup_t           protoGroup;
    rtk_vlan_protoVlanCfg_t         vlanCfg;
    rtk_vlan_tagMode_t              tagMode;
    rtk_port_t                      egr_port;
    rtk_portmask_t                  igr_portmask;
    rtk_vlan_tagKeepType_t          type;
    rtk_vlan_resVidAction_t         action_vid0;
    rtk_vlan_resVidAction_t         action_vid4095;
    rtk_vlan_tagModeIpmc_t          tagModeIpmc;
}rtdrv_vlanCfg_t;

typedef struct rtdrv_portCfg_s
{
    rtk_port_t                      port;
    rtk_port_linkStatus_t           linkStatus;
    rtk_port_speed_t                speed;
    rtk_port_duplex_t               duplex;
    uint32                          txStatus;
    uint32                          rxStatus;
    rtk_enable_t                    enable;
    rtk_port_phy_ability_t          ability;
    rtk_enable_t                    flowControl;
    uint32                          page;
    rtk_port_phy_reg_t              reg;
    uint32                          data;
    rtk_port_masterSlave_t          masterSlave;
    rtk_port_phy_test_mode_t        testMode;
    rtk_portmask_t                  portmask;
    rtk_portmask_t                  extPortmask;
    rtk_port_isoConfig_t            mode;
    rtk_leaky_type_t                type;
    uint32                          second;
    uint32                          status;
    rtk_port_crossOver_mode_t       crossoverMode;
    rtk_efid_t                      efid;
    rtk_rtctResult_t                result;
    rtk_port_macAbility_t           macAbility;
    rtk_port_ext_mode_t             ext_mode;
    uint32                          txDelay;
    uint32                          rxDelay;
    uint8                           num;
    uint8                           cfg;
}rtdrv_portCfg_t;

typedef struct rtdrv_unitCfg_s
{
    uint32  data;
    uint64  data64;
} rtdrv_unitCfg_t;

typedef struct rtdrv_gpioCfg_s
{
    uint32                          gpioId;
    rtk_enable_t                    enable;
    rtk_gpio_mode_t                 mode;
    uint32                          data;
    rtk_gpio_intrMode_t             intrMode;

}rtdrv_gpioCfg_t;

typedef struct rtdrv_i2cCfg_s
{
    rtk_i2c_port_t                  port;
    rtk_enable_t                    enable;
    rtk_i2c_width_t                 width;
    uint32                          devID;
    uint32                          regAddr;
    uint32                          data;
    uint32                          clock;
    rtk_i2c_addr_ext_mode_t         addrExtMode;
    uint32                          *pSeqData;
    uint32                          seqCnt;
}rtdrv_i2cCfg_t;

typedef struct rtdrv_intrCfg_s
{
    rtk_intr_polarity_t             polar;
    rtk_intr_type_t                 intr;
    rtk_enable_t                    enable;
    rtk_enable_t                    status;
    rtk_portmask_t                  portMask;
    uint32                          imrValue;
    rtk_intr_type_t                 type;
    uint32                          counter;
}rtdrv_intrCfg_t;


typedef struct rtdrv_rldpCfg_s
{
    rtk_rldp_config_t               config;
    rtk_port_t                      port;
    rtk_rldp_portConfig_t           portConfig;
    rtk_rldp_status_t               status;
    rtk_rldp_portStatus_t           portStatus;
    rtk_rlpp_trapType_t             type;
}rtdrv_rldpCfg_t;


typedef struct rtdrv_ponmacCfg_s
{
    rtk_ponmac_queue_t              queue;
    rtk_ponmac_queueCfg_t           queueCfg;
    uint32                          flow;
    rtk_qos_scheduling_type_t       queueType;
    rtk_transceiver_parameter_type_t    type;
    rtk_transceiver_data_t              data;
    rtk_ponmac_mode_t               mode;
    uint32                          sdState;
    uint32                          syncState;
    uint32                          bwThreshold;
    uint32                          reqBwThreshold;
    uint32                          rate;
    uint32                          scheduleId;
    rtk_enable_t                    state;
    rtk_enable_t                    enable;
    uint32                          gpioPinId;
    rtk_flowctrl_patch_t            bufferMode;
}rtdrv_ponmacCfg_t;


typedef struct rtdrv_stpCfg_s
{
    uint32                          msti;
    rtk_port_t                      port;
    rtk_stp_state_t                 stpState;
}rtdrv_stpCfg_t;


typedef struct rtdrv_switchCfg_s
{
    rtk_switch_devInfo_t            devInfo;
    rtk_switch_port_name_t          portName;
    int32                           portId;
    rtk_portmask_t                  portMask;
    rtk_switch_maxPktLen_linkSpeed_t    speed;
    uint32                          len;
    rtk_mac_t                       mac;
    uint32                          chipId;
    uint32                          rev;
    uint32                          subtype;
    uint32                          patchIdx;
    uint32                          patchData;
    uint32                          csExtId;
    rtk_enable_t                    state;
    rtk_switch_system_mode_t        mode;
    int32                           thermalIntger;
    int32                           thermalDecimal;
}rtdrv_switchCfg_t;


typedef struct rtdrv_ledCfg_s
{
    rtk_led_operation_t             opMode;
    rtk_led_active_t                active;
    rtk_led_blinkGroup_t            group;
    rtk_led_blink_rate_t            blinkRate;
    uint32                          ledIdx;
    rtk_led_type_t                  type;
    rtk_led_config_t                config;
    rtk_led_force_mode_t            mode;
    rtk_enable_t                    state;
}rtdrv_ledCfg_t;


typedef struct rtdrv_svlanCfg_s
{
    rtk_vlan_t                      svid;
    rtk_port_t                      port;
    rtk_enable_t                    enable;
    rtk_portmask_t                  svlanPortmask;
    rtk_portmask_t                  svlanUntagPortmask;
    uint32                          svlanIndex;
    uint32                          svlanTagId;
    uint32                          svlan_index;
    uint32                          svlan_tag_id;
    rtk_svlan_pri_ref_t             ref;
    rtk_svlan_memberCfg_t           svlan_cfg;
    ipaddr_t                        ipmc;
    ipaddr_t                        ipmcMsk;
    rtk_mac_t                       mac;
    rtk_mac_t                       macMsk;
    rtk_port_t                      dstPort;
    rtk_vlan_t                      cvid;
    rtk_svlan_action_t              action;
    rtk_pri_t                       priority;
    rtk_svlan_lookupType_t          type;
    rtk_enable_t                    state;
    rtk_fid_t                       fid;
    rtk_efid_t                      efid;
    uint32                          pvid;
    uint32                          extPort;
}rtdrv_svlanCfg_t;


typedef struct rtdrv_qosCfg_s
{
    uint32                          grpIdx;
    rtk_qos_priSelWeight_t          weightOfPriSel;
    rtk_port_t                      port;
    rtk_pri_t                       intPri;
    uint32                          dscp;
    uint32                          dp;
    rtk_pri_t                       dot1pPri;
    uint32                          group;
    rtk_qos_pri2queue_t             pri2qid;
    rtk_enable_t                    enable;
    rtk_qos_dscpRmkSrc_t            type;
    uint32                          rmkDscp;
    rtk_pri_t                       rempPri;
    rtk_qos_queue_weights_t         qweights;
    uint32                          priSelGrpIdx;
    rtk_qos_scheduling_type_t       queueType;
    rtk_qos_do1pRmkSrc_t            dot1pRmkSrc;
}rtdrv_qosCfg_t;

typedef struct rtdrv_classifyCfg_s
{
    rtk_classify_cfg_t                  classifyCfg;
    uint32                              entryIdx;
    rtk_classify_field_t                classifyField;
    rtk_classify_unmatch_action_t       action;
    rtk_classify_unmatch_action_ds_t    dsaction;
    rtk_classify_rangeCheck_l4Port_t    rangeEntry;
    rtk_classify_rangeCheck_ip_t        ipRangeEntry;
    rtk_port_t                          port;
    rtk_classify_cf_sel_t               cfSel;
    rtk_pri_t                           pri;
    rtk_dscp_t                          dscp;
    rtk_classify_permit_sel_t           permitSel;
    rtk_classify_us_1premark_prior_t    prior;
    rtk_classify_template_cfg_pattern0_t p0TemplateCfg;
    uint32                              entryNum;
    rtk_classify_default_wanIf_t        defaultWanIf;
    rtk_pri_t                           trapPri;
}rtdrv_classifyCfg_t;

typedef struct rtdrv_l2Cfg_s
{
    rtk_enable_t                    enable;
    rtk_l2_flushCfg_t               config;
    uint32                          status;
    uint32                          macCnt;
    rtk_l2_limitLearnCntAction_t    learningAction;
    rtk_port_t                      port;
    uint32                          agingTime;
    rtk_l2_lookupMissType_t         type;
    rtk_action_t                    action;
    rtk_portmask_t                  flood_portmask;
    rtk_port_t                      flood_port;
    rtk_l2_newMacLrnMode_t          lrnMode;
    rtk_action_t                    fwdAction;
    int32                           scanIdx;
    rtk_l2_ucastAddr_t              l2UcastData;
    rtk_l2_mcastAddr_t              l2McastData;
    rtk_l2_ipMcastAddr_t            ipMcastData;
    rtk_l2_addr_table_t             l2Entry;
    rtk_l2_ucastAddr_t              l2Addr;
    uint32                          includeStatic;
    rtk_l2_mcastAddr_t              mcastAddr;
    rtk_l2_ipmcMode_t               mode;
    rtk_l2_ipmcHashOp_t             ipmcHash;
    ipaddr_t                        ip;
    rtk_portmask_t                  portmask;
    rtk_l2_ipMcastAddr_t            ipmcastAddr;
    rtk_portmask_t                  filter_portmask;
    rtk_portmask_t                  ext_portmask;
    uint32                          index;
    rtk_l2_limitLearnEntryAction_t  learningEntryAction;
    rtk_l2_ip6McReservedAddr_t      addrRsvIp6Mc;
    rtk_l2_hashType_t               hashType;
    rtk_l2_hashData_t               hashData;
    uint32                          hashValue;
}rtdrv_l2Cfg_t;


typedef struct rtdrv_l34Cfg_s
{
    uint32                              idx;
    rtk_l34_netif_entry_t           netifEntry;
    rtk_l34_arp_entry_t             arpEntry;
    rtk_l34_pppoe_entry_t           ppEntry;
    rtk_l34_routing_entry_t         routEntry;
    rtk_l34_nexthop_entry_t         nextHopEntry;
    rtk_l34_ext_intip_entry_t       extIpEntry;
    int8                                forced;
    rtk_l34_naptInbound_entry_t     naptrEntry;
    rtk_l34_naptOutbound_entry_t    naptEntry;
    rtk_l34_ipmcTrans_entry_t       ipmcEntry;
    rtk_l34_table_type_t            type;
    rtk_binding_entry_t                 bindEntry;
    rtk_l34_bindType_t              bindType;
    rtk_l34_bindAct_t                   bindAction;
    rtk_wanType_entry_t             wanTypeEntry;
    rtk_ipv6Routing_entry_t         ipv6RoutEntry;
    rtk_ipv6Neighbor_entry_t        ipv6NeighborEntry;
    rtk_l34_hsba_mode_t             hsabMode;
    rtk_l34_hsa_t                       hsaData;
    rtk_l34_hsb_t                       hsbData;
    rtk_l34_portWanMapType_t        portWanMapType;
    rtk_l34_portWanMap_entry_t      portWanMapEntry;
    rtk_l34_globalStateType_t       stateType;
    rtk_enable_t                        state;
    rtk_l34_lookupMode_t            lookupMode;
    rtk_l34_portType_t              portType;
    uint32                              portId;
    uint32                              wanIdx;
    rtk_l34_wanRouteMode_t          wanRouteMode;
    uint32                              index;
    rtk_enable_t                        arpIndicator;
    rtk_enable_t                        naptIndicator;
    rtk_enable_t                        pppIndicator;
    rtk_enable_t                        neighIndicator;
    rtk_enable_t                           hsdState;
    rtk_l34_l4_trf_t                    l4TrfTable;
    uint32                              l4EntryIndex;
    rtk_enable_t                        indicator;
    rtk_l34_arp_trf_t                   arpTrfTable;
    uint32                              arpEntryIndex;
    uint32                              naptMaps;
    uint32                              arpMaps;
    rtk_l34_ppp_trf_all_t                       pppTrfAll;
    rtk_l34_flowRoute_entry_t           flowRouteEntry;
    rtk_enable_t                        flowIndicator;
    rtk_l34_dsliteInf_entry_t           dsliteInfEntry;
    rtk_l34_dsliteMc_entry_t            dsliteMcEntry;
    rtk_l34_dsliteCtrlType_t            dsliteCtrlType;
    uint32                              dsliteCtrlAct;
    rtk_l34_mib_t                       l34Cnts;
    rtk_l34_lutMissAct_t                lutMissAct;

}rtdrv_l34Cfg_t;


typedef struct rtdrv_l34liteCfg_s
{
    uint32                          netifId;
    rtk_l34_netifType_t             netifType;
    rtk_mac_t                       ifmac;
    rtk_enable_t                    pppState;
    uint32                          sessionId;
    rtk_enable_t                    passThroughState;
    rtk_vlan_t                      vid;
    rtk_pri_t                       defaultPri;
    rtk_enable_t                    routingState;
    uint32                          mtu;
    rtk_ip_addr_t                   ipaddr;
    uint32                          ipmask;
    rtk_l34_natType_t               natType;
    rtk_ip_addr_t                   internalp;
    rtk_enable_t                    ifState;
    rtk_l34_netifInfo_t             netifInfo;
    rtk_mac_t                       mac;
    rtk_l34_arpInfo_t               arpInfo;
    rtk_l34_routeType_t             routeType;
    rtk_l34_routeTable_t            routeTable;
    uint32                          routeIndex;
    rtk_l34_routeInfo_t             routeInfo;
    rtk_l34_direct_t                dir;
    rtk_l34_tuple_t                 tuple;
    rtk_l34_nat_info_t              natInfo;
    rtk_l34_connectInfo_t           connectInfo;
    rtk_l34_global_cfg_t            globalCfg;
    rtk_l34_ipv6RouteType_t         route6Type;
    rtk_l34_route6Table_t           route6Table;
    rtk_ipv6_addr_t                 ip6addr;
    uint32                          prefixLen;
    uint32                          index;
    rtk_l34_route6Info_t            route6Info;
    rtk_l34_neigh6Info_t            neigh6Info;
    rtk_mac_t                       gatewayMac;
    rtk_mac_t                       hwAddr;
}rtdrv_l34liteCfg_t;


typedef struct rtdrv_trunkCfg_s
{
    uint32                          trkGid;
    uint32                          algoBitmask;
    rtk_portmask_t                  trunkMemberPortmask;
    uint32                          trk_gid;
    rtk_trunk_hashVal2Port_t        hash2Port_array;
    rtk_trunk_mode_t                mode;
    rtk_trunk_separateType_t        separateType;
    rtk_portmask_t                  empty_portmask;
    rtk_enable_t                    enable;
}rtdrv_trunkCfg_t;


typedef struct rtdrv_mirrorCfg_s
{
    rtk_port_t                      mirroringPort;
    rtk_portmask_t                  mirroredRxPortmask;
    rtk_portmask_t                  mirroredTxPortmask;
    rtk_enable_t                    enable;
}rtdrv_mirrorCfg_t;


typedef struct rtdrv_dot1xCfg_s
{
    rtk_port_t                      port;
    rtk_action_t                    unauthAction;
    rtk_enable_t                    enable;
    rtk_dot1x_auth_status_t         port_auth;
    rtk_dot1x_direction_t           port_direction;
    rtk_dot1x_direction_t           mac_direction;
    rtk_vlan_t                      guest_vlan;
    rtk_dot1x_guestVlanBehavior_t   behavior;
    rtk_pri_t                       priority;
}rtdrv_dot1xCfg_t;

typedef struct rtdrv_cpuCfg_s
{
    rtk_port_t                      port;
    rtk_portmask_t                  port_mask;
    rtk_cpu_tag_fmt_t               mode;
    rtk_enable_t                    state;
}rtdrv_cpuCfg_t;

typedef struct rtdrv_trapCfg_s
{
    rtk_trap_reason_type_t          type;
    rtk_pri_t                       priority;
    rtk_enable_t                    enable;
    rtk_port_t                      port;
    rtk_trap_igmpMld_type_t         igmpMldType;
    rtk_action_t                    action;
    rtk_mac_t                       rmaFrame;
    rtk_trap_rma_action_t           rmaAction;
    rtk_trap_hash_t                 hashType;
    uint32                          hashValue;
    rtk_enable_t                    state;
    uint32                          select;
}rtdrv_trapCfg_t;

typedef struct rtdrv_eponCfg_s
{
    rtk_epon_intrType_t             intrType;
    rtk_enable_t                    state;
    uint8                           llidIdx;
    rtk_epon_llid_entry_t           llidEntry;
    rtk_epon_laser_status_t         laserStatus;
    uint8                           lasetOnTime;
    uint8                           lasetOffTime;
    uint8                           syncTime;
    rtk_epon_regReq_t               regEntry;
    rtk_epon_churningKeyEntry_t     entry;
    rtk_epon_counter_t              counter;
    uint32                          timeVal;
    rtk_epon_polarity_t             polarity;
    uint32                          num;
    rtk_epon_report_threshold_t     thresholdRpt;
    rtk_epon_dbgCnt_t               dbgCnt;
    rtk_epon_prbs_t                 prbsCfg;
    rtk_epon_multiLlidMode_t        mode;
    uint8                           queueSetNum;
    uint8                           queue;
    rtk_enable_t                    enable;
    int                             recoverTime;
}rtdrv_eponCfg_t;

typedef struct rtdrv_glbPmPara_s
{
    rtk_gpon_global_performance_type_t   type;
    rtk_gpon_global_counter_t           para;
} rtdrv_glbPmPara_t;

typedef struct rtdrv_tcontPmPara_s
{
    uint32 tcontId;
    rtk_gpon_tcont_performance_type_t type;
    rtk_gpon_tcont_counter_t para;
} rtdrv_tcontPmPara_t;

typedef struct rtdrv_flowPmPara_s
{
    uint32 flowId;
    rtk_gpon_flow_performance_type_t type;
    rtk_gpon_flow_counter_t para;
} rtdrv_flowPmPara_t;

typedef struct rtdrv_oamCfg_s
{
    rtk_port_t                      port;
    rtk_oam_parser_act_t            action;
    rtk_oam_multiplexer_act_t       multAction;
}rtdrv_oamCfg_t;


typedef struct rtdrv_statCfg_s
{
    rtk_port_t                      port;
    uint32                          index;
    rtk_mib_rst_value_t             rstValue;
    rtk_stat_global_type_t          cntrIdx;
    uint64                          cntr;
    rtk_stat_global_cntr_t          globalCntrs;
    rtk_stat_port_type_t            portCntrIdx;
    rtk_stat_port_cntr_t            portCntrs;
    rtk_stat_log_ctrl_t             ctrl;
    rtk_mib_count_mode_t            cnt_mode;
    uint32                          timer;
    rtk_mib_sync_mode_t             sync_mode;
    rtk_mib_tag_cnt_dir_t           direction;
    rtk_mib_tag_cnt_state_t         state;
    uint32                          code;
    rtk_enable_t                    enState;

    rtk_stat_host_cnt_type_t        hostCntrsIdx;
}rtdrv_statCfg_t;


typedef struct rtdrv_secCfg_s
{
    rtk_port_t                      port;
    rtk_enable_t                    enable;
    rtk_sec_attackType_t            attackType;
    rtk_action_t                    action;
    rtk_sec_attackFloodType_t       type;
    uint32                          floodThresh;
    uint32                          floodThreshUnit;
}rtdrv_secCfg_t;

typedef struct rtdrv_omci_msg_s{
    uint8 msg[RTK_GPON_OMCI_MSG_LEN_TX];
}rtdrv_omci_msg_t;

typedef struct rtdrv_ponLed_s
{
    rtk_pon_led_spec_type_t         specType;
    rtk_pon_led_pon_mode_t          ponMode;
    uint32                          ponStatus;
    rtk_pon_led_group_t             ponLedGroup;
    uint32                          ledGroupIdx;
}rtdrv_ponLed_t;

typedef struct rtdrv_pboCfg_s
{
    rtk_pbo_initParam_t             initParam;
    rtk_swPbo_initParam_t           swPboInitParam;
    rtk_port_t                      port;
    rtk_qid_t                       qid;
    rtk_enable_t                    enable;
    uint32                          threshold;
    uint32                          currPage, maxPage;
    uint32                          currDscSram, currDscDram, maxDscSram, maxDscDram;
}rtdrv_pboCfg_t;

#if defined(CONFIG_EUROPA_FEATURE)
typedef struct rtdrv_lddCfg_s
{
    uint32                  rssi_v0;
    uint32                  rssi_voltage;
    uint32                  vdd;
    uint32                  rssi_i;
    uint32                  mpd0;
    uint32                  mpd1;
    uint32                  mpd_i;
    rtk_i2c_port_t          i2cPort;
    uint32                  length;
    uint32                  offset;
    uint8                   *flash_data;
    rtk_ldd_reset_mode_t    reset;
    uint32                  result;
    uint16                  count;
    uint32                  value;
    rtk_ldd_apc_func_t      apc_func;
    rtk_ldd_loop_mode_t     loop_mode;
    rtk_ldd_tx_func_t       tx_func;
    rtk_ldd_rx_func_t       rx_func;
    uint16                  temperature;
    uint32                  tx_bias;
    uint32                  tx_mod;
    rtk_enable_t            state;
    uint32                  driver_version;
} rtdrv_lddCfg_t;
#endif

typedef struct rtdrv_mdioCfg_s
{
    uint8                           set;
    uint8                           port;
    uint8                           phyid;
    rtk_mdio_format_t               fmt;
    uint8                           c22_reg;
    uint16                          c45_reg;
    uint8                           dev;
    uint16                          data;
}rtdrv_mdioCfg_t;

#if defined(CONFIG_COMMON_RT_API)
typedef struct rtdrv_rt_switchCfg_s
{
    rtk_switch_port_name_t          portName;
    int32                           portId;
    uint32                          chipId;
    uint32                          rev;
    uint32                          subtype;
    rtk_port_t                      port;
    uint32                          len;
    rt_switch_devInfo_t             devInfo;
}rtdrv_rt_switchCfg_t;

typedef struct rtdrv_rt_gponCfg_s
{
    rt_gpon_serialNumber_t              sN;
    rt_gpon_registrationId_t            regId;
    rt_gpon_initialState_t              initState;
    rt_gpon_onuState_t                  onuState;
    uint32                              msgLen;
    uint8                               msg;
    uint32                              tcontId;
    uint32                              allocId;
    uint32                              usFlowId;
    rt_gpon_usFlow_t                    usFlow;
    uint32                              dsFlowId;
    rt_gpon_dsFlow_t                    dsFlow;
    uint32                              tcQueueId;
    rt_gpon_queueCfg_t                  queuecfg;
    rt_gpon_schedule_info_t             scheInfo;
    uint32                              flowId;
    rt_gpon_flow_counter_type_t         flowCntType;
    rt_gpon_flow_counter_t              flowCnt;
    rt_gpon_pm_type_t               	pmCntType;
    rt_gpon_pm_counter_t            pmCnt;
    rt_gpon_ponTag_t                ponTag;
    rt_gpon_msk_t                   msk;
    uint32                      	dir;
    uint32                      	mic;
    rt_gpon_mc_key_t                    mcKey;
    uint32                          rate;
    rt_gpon_attribute_type_t        attributeType;
    rt_gpon_attribute_t             attributeValue;
    rt_enable_t                     mirrorEn;
    rt_port_t                       mirroringPort;
    rt_gpon_omcc_t                  omcc;
    rt_gpon_fec_status_t            fec;
	rt_gpon_tcont_counter_t         tcontCnt;
	rt_enable_t                     emergencyStop;
    rt_enable_t                     loopGemEn;
    uint32                          loopGemPortId;
}rtdrv_rt_gponCfg_t;

typedef struct rtdrv_rt_statCfg_s
{
    rt_port_t                       port;
    rt_stat_port_type_t             cntrIdx;
    uint64                          cntr;
    rt_stat_port_cntr_t             portCntrs;
}rtdrv_rt_statCfg_t;

typedef struct rtdrv_rt_rateCfg_s
{
    rt_port_t                       port;
    uint32                          rate;
    rt_rate_storm_group_t           stormType;
    uint32                          index;
    rt_enable_t                     enable;
    rt_rate_storm_group_ctrl_t      stormCtrl;
    rt_rate_meter_type_t            type;
    uint32                          v_index;
    rt_rate_meter_mapping_t         meterMap;
    uint32                          bucketSize;
    rtk_enable_t                    ifgInclude;
}rtdrv_rt_rateCfg_t;

typedef struct rtdrv_rt_qosCfg_s
{
    rt_port_t                       port;
    rt_qos_queue_weights_t          qweights;
    rt_qos_dscp2Pbit_t              dscp2Pbit;
}rtdrv_rt_qosCfg_t;

typedef struct rtdrv_rt_intrCfg_s
{
    rt_intr_type_t                  intr;
    rt_enable_t                     enable;
}rtdrv_rt_intrCfg_t;

typedef struct rtdrv_rt_secCfg_s
{
    rt_port_t                       port;
    rt_enable_t                     enable;
    rt_sec_attackType_t             attackType;
    rt_action_t                     action;
    rt_sec_attackFloodType_t        type;
    uint32                          floodThresh;
    uint32                          floodThreshUnit;
}rtdrv_rt_secCfg_t;

typedef struct rtdrv_rt_trapCfg_s
{
    rt_port_t                       port;
    rt_trap_igmpMld_type_t          igmpMldType;
    rt_action_t                     action;
}rtdrv_rt_trapCfg_t;

typedef struct rtdrv_rt_i2cCfg_s
{
    rt_i2c_port_t                   i2cPort;
    rt_enable_t                     enable;
    uint32                          devID;
    uint32                          regAddr;
    uint32                          data;
    uint32                          *pSeqData;
    uint32                          seqCnt;
    uint32                          clock;
}rtdrv_rt_i2cCfg_t;

typedef struct rtdrv_rt_portCfg_s
{
    rt_port_t                       port;
    rt_port_linkStatus_t            linkStatus;
    rt_port_speed_t                 speed;
    rt_port_duplex_t                duplex;
    uint32                          txStatus;
    uint32                          rxStatus;
    rt_enable_t                     enable;
    rt_port_phy_ability_t           ability;
    rt_enable_t                     flowControl;
    uint32                          page;
    rt_port_phy_reg_t               reg;
    uint32                          data;
    rt_port_isoConfig_t             mode;
    rt_portmask_t                   portmask;
    rt_portmask_t                   extPortmask;
    rt_port_uniType_t               uniType;
    uint32                          rt_port0;
    uint32                          rt_port1;
    uint32                          rt_port2;
    uint32                          rt_port3;
    uint32                          rt_port4;
    uint32                          rt_port5;
    uint32                          rt_port6;
    uint32                          rt_port7;
    uint32                          rt_port_pon;
    uint32                          rt_port_cpu0;
    uint32                          rt_port_cpu1;
    uint32                          rt_port_cpu2;
    uint32                          rt_port_cpu3;
    uint32                          rt_port_cpu4;
    uint32                          rt_port_cpu5;
    uint32                          rt_port_cpu6;
    uint32                          rt_port_cpu7;
    uint32                          rt_port_max;
}rtdrv_rt_portCfg_t;

typedef struct rtdrv_rt_l2Cfg_s
{
    rt_port_t                       port;
    int32                           macCnt;
    rt_action_t                     fwdAction;
    rt_l2_ucastAddr_t               l2UcastData;
    int32                           scanIdx;
    uint32                          ageTime;
    rt_enable_t                     ivlEn;
}rtdrv_rt_l2Cfg_t;

typedef struct rtdrv_rt_eponCfg_s
{
    rt_epon_llid_entry_t            llidEntry;
    rt_epon_regReq_t                regEntry;
    rt_epon_churningKeyEntry_t      entry;
    rt_enable_t                     state;
    rt_epon_counter_t               counter;
    uint32                          msgLen;
    uint8                           msg;
    rt_epon_oam_rx_callback         oamRx;
    uint32                          llid;
    uint32                          queueId;
    rt_epon_queueCfg_t              queuecfg;
    uint32                          rate;
    rt_epon_report_threshold_t      thresholdRpt;
    rt_epon_mpcp_info_t             info;
}rtdrv_rt_eponCfg_t;

typedef struct rtdrv_rt_clsCfg_s
{
    rt_cls_rule_t                   clsRule;
    uint32                          index;
    rt_port_t                       port;
    rt_port_t                       fwdPort;
}rtdrv_rt_clsCfg_t;

typedef struct rtdrv_rt_ponmiscCfg_s
{
    rt_ponmisc_ponMode_t            ponMode;
    rt_ponmisc_ponSpeed_t           ponSpeed;
    uint16                          sid;
    rt_ponmisc_sidInfo_t            sidInfo;
    rt_transceiver_parameter_type_t trxDataType;
    rt_transceiver_data_t           trxData;
    rt_ponmisc_polarity_t           burstPolarity;
    rt_ponmisc_laser_status_t       laserStatus;
    rt_ponmisc_prbs_t               prbs;
}rtdrv_rt_ponmiscCfg_t;

typedef struct rtdrv_rt_mirrorCfg_s
{
    rt_port_t                   	mirroringPort;
    rt_portmask_t               	mirroredRxPortmask;
    rt_portmask_t               	mirroredTxPortmask;
}rtdrv_rt_mirrorCfg_t;
#endif

typedef union rtdrv_union_u
{
    rtdrv_unitCfg_t         unit_cfg;
    rtdrv_logCfg_t          log_cfg;
    rtdrv_regCfg_t          reg_cfg;
    rtdrv_addrCfg_t         addr_cfg;
    rtdrv_phyCfg_t          phy_cfg;
    uint32                              index;
    rtdrv_rateCfg_t                     rate_cfg;
    rtdrv_aclCfg_t                      acl_cfg;
    rtdrv_vlanCfg_t                     vlan_cfg;
    rtdrv_gpioCfg_t                     gpio_cfg;
    rtdrv_i2cCfg_t                      i2c_cfg;
    rtdrv_intrCfg_t                     intr_cfg;
    rtdrv_rldpCfg_t                     rldp_cfg;
    rtdrv_ponmacCfg_t                   ponmac_cfg;
    rtdrv_stpCfg_t                      stp_cfg;
    rtdrv_switchCfg_t                   switch_cfg;
    rtdrv_ledCfg_t                      led_cfg;
    rtdrv_qosCfg_t                      qos_cfg;
    rtdrv_svlanCfg_t                    svlan_cfg;
    rtdrv_classifyCfg_t                 classify_cfg;
    rtdrv_l2Cfg_t                       l2_cfg;
    rtdrv_l34Cfg_t                      l34_cfg;
    rtdrv_l34liteCfg_t                  l34lite_cfg;
    rtdrv_portCfg_t                     port_cfg;
    rtdrv_trunkCfg_t                    trunk_cfg;
    rtdrv_mirrorCfg_t                   mirror_cfg;
    rtdrv_dot1xCfg_t                    dot1x_cfg;
    rtdrv_cpuCfg_t                      cpu_cfg;
    rtdrv_trapCfg_t                     trap_cfg;
    rtdrv_eponCfg_t                     epon_cfg;
    rtdrv_ponAlarm_t                    alarm_state;
    rtdrv_ponPara_t                     pon_cfg;
    rtk_gpon_fsm_status_t               pon_state;
    rtdrv_tcont_t                       tcont_cfg;
    rtdrv_dsFlow_t                      ds_flow_cfg;
    rtdrv_usFlow_t                      us_flow_cfg;
    rtdrv_ip_ptn_t                      ip_ptn;
    rtk_gpon_macTable_exclude_mode_t    filter_mode;
    rtdrv_fs_mode_t                     fs_mode;
    rtdrv_mac_entry_t                   mac_entry;
    int32                               state;
    rtk_gpon_laser_status_t             tx_laser;
    rtk_gpon_prbs_t                     prbs_cfg;
    rtdrv_glbPmPara_t                       glb_pm;
    rtdrv_tcontPmPara_t                 tcont_pm;
    rtdrv_flowPmPara_t                      flow_pm;
    rtk_gpon_serialNumber_t             sn_cfg;
    rtk_gpon_password_t                 pwd_cfg;
    rtk_gpon_initialState_t             init_state_cfg;
#if (CONFIG_GPON_VERSION > 1)
    rtk_gpon_extMsg_t                   gponExt_cfg;
    rtk_gpon_rgIgmp_cfg_msg_t           rgIgmp_cfg;
#endif
#if defined(OLD_FPGA_DEFINED)
    rtdrv_pktGen_t                      pkt_gen;
#endif
    rtdrv_omci_msg_t                    omci;
    rtdrv_oamCfg_t                      oam_cfg;
    rtdrv_statCfg_t                     stat_cfg;
    rtdrv_secCfg_t                      sec_cfg;
    rtdrv_timeCfg_t                     time_cfg;
    rtdrv_ponLed_t                      ponLed;
#if defined(CONFIG_EUROPA_FEATURE)
    rtk_ldd_cfg_t                      ldd_cfg;
#endif
    rtk_gpon_rogue_sd_cnt_t             rogue_sd_cnt;
    rtdrv_ppstodCfg_t                   ppstod_cfg;
    rtdrv_pboCfg_t                      pbo_cfg;
    rtdrv_mdioCfg_t                     mdio_cfg;
    rtk_gpon_fec_status_t               fec;
    uint32                              eqd;
#if defined(CONFIG_COMMON_RT_API)
    rtdrv_rt_switchCfg_t                rt_switch_cfg;
    rtdrv_rt_gponCfg_t                  rt_gpon_cfg;
    rtdrv_rt_statCfg_t                  rt_stat_cfg;
    rtdrv_rt_rateCfg_t                  rt_rate_cfg;
    rtdrv_rt_qosCfg_t                   rt_qos_cfg;
    rtdrv_rt_intrCfg_t                  rt_intr_cfg;
    rtdrv_rt_secCfg_t                   rt_sec_cfg;
    rtdrv_rt_trapCfg_t                  rt_trap_cfg;
    rtdrv_rt_i2cCfg_t                   rt_i2c_cfg;
    rtdrv_rt_portCfg_t                  rt_port_cfg;
    rtdrv_rt_eponCfg_t                  rt_epon_cfg;
    rtdrv_rt_clsCfg_t                   rt_cls_cfg;
    rtdrv_rt_l2Cfg_t                    rt_l2_cfg;
    rtdrv_rt_ponmiscCfg_t               rt_ponmisc_cfg;
    rtdrv_rt_mirrorCfg_t                rt_mirror_cfg;
#endif
} rtdrv_union_t;

#endif /* __RTDRV_NETFILTER_H__ */
