/******************************************************************************
 *
 * Copyright(c) 2007 - 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#define _RTW_MLME_EXT_C_

#include <drv_types.h>
#include "../phl/hal_g6/hal_general_def.h"
#include "../phl/hal_g6/hal_def.h"
#if defined(CONFIG_RTW_BRSC) || defined(CONFIG_RTL_EXT_PORT_SUPPORT)
#include <net/rtl/rtl_brsc.h>
#endif
#ifdef CONFIG_RTL_EXT_PORT_SUPPORT
#include <net/rtl/rtl865x_netif.h>
#endif
#ifdef CONFIG_REPEATER_PREFER_BAND_SUPPORT
#include <net/rtl/rtw_band_dev.h>
#endif

struct mlme_handler mlme_sta_tbl[] = {
	{WIFI_ASSOCREQ,		"OnAssocReq",	&OnAssocReq},
	{WIFI_ASSOCRSP,		"OnAssocRsp",	&OnAssocRsp},
	{WIFI_REASSOCREQ,	"OnReAssocReq",	&OnAssocReq},
	{WIFI_REASSOCRSP,	"OnReAssocRsp",	&OnAssocRsp},
	{WIFI_PROBEREQ,		"OnProbeReq",	&OnProbeReq},
	{WIFI_PROBERSP,		"OnProbeRsp",		&OnProbeRsp},

	/*----------------------------------------------------------
					below 2 are reserved
	-----------------------------------------------------------*/
	{0,					"DoReserved",		&DoReserved},
	{0,					"DoReserved",		&DoReserved},
	{WIFI_BEACON,		"OnBeacon",		&OnBeacon},
	{WIFI_ATIM,			"OnATIM",		&OnAtim},
	{WIFI_DISASSOC,		"OnDisassoc",		&OnDisassoc},
	{WIFI_AUTH,			"OnAuth",		&OnAuthClient},
	{WIFI_DEAUTH,		"OnDeAuth",		&OnDeAuth},
	{WIFI_ACTION,		"OnAction",		&OnAction},
	{WIFI_ACTION_NOACK, "OnActionNoAck",	&OnAction},
};

#ifdef _CONFIG_NATIVEAP_MLME_
struct mlme_handler mlme_ap_tbl[] = {
	{WIFI_ASSOCREQ,		"OnAssocReq",	&OnAssocReq},
	{WIFI_ASSOCRSP,		"OnAssocRsp",	&OnAssocRsp},
	{WIFI_REASSOCREQ,	"OnReAssocReq",	&OnAssocReq},
	{WIFI_REASSOCRSP,	"OnReAssocRsp",	&OnAssocRsp},
	{WIFI_PROBEREQ,		"OnProbeReq",	&OnProbeReq},
	{WIFI_PROBERSP,		"OnProbeRsp",		&OnProbeRsp},

	/*----------------------------------------------------------
					below 2 are reserved
	-----------------------------------------------------------*/
	{0,					"DoReserved",		&DoReserved},
	{0,					"DoReserved",		&DoReserved},
	{WIFI_BEACON,		"OnBeacon",		&OnBeacon},
	{WIFI_ATIM,			"OnATIM",		&OnAtim},
	{WIFI_DISASSOC,		"OnDisassoc",		&OnDisassoc},
	{WIFI_AUTH,			"OnAuth",		&OnAuth},
	{WIFI_DEAUTH,		"OnDeAuth",		&OnDeAuth},
	{WIFI_ACTION,		"OnAction",		&OnAction},
	{WIFI_ACTION_NOACK, "OnActionNoAck",	&OnAction},
};
#endif

struct action_handler OnAction_tbl[] = {
	{RTW_WLAN_CATEGORY_SPECTRUM_MGMT,	 "ACTION_SPECTRUM_MGMT", on_action_spct},
	{RTW_WLAN_CATEGORY_QOS, "ACTION_QOS", &OnAction_qos},
	{RTW_WLAN_CATEGORY_DLS, "ACTION_DLS", &OnAction_dls},
	{RTW_WLAN_CATEGORY_BACK, "ACTION_BACK", &OnAction_back},
	{RTW_WLAN_CATEGORY_PUBLIC, "ACTION_PUBLIC", on_action_public},
	{RTW_WLAN_CATEGORY_PROTECTED_PUBLIC, "ACTION_PROTECTED_PUBLIC", on_action_public},
	{RTW_WLAN_CATEGORY_RADIO_MEAS, "ACTION_RADIO_MEAS", &on_action_rm},
	{RTW_WLAN_CATEGORY_FT, "ACTION_FT",	&OnAction_ft},
	{RTW_WLAN_CATEGORY_HT,	"ACTION_HT",	&OnAction_ht},
#ifdef CONFIG_IEEE80211W
	{RTW_WLAN_CATEGORY_SA_QUERY, "ACTION_SA_QUERY", &OnAction_sa_query},
#else
	{RTW_WLAN_CATEGORY_SA_QUERY, "ACTION_SA_QUERY", &DoReserved},
#endif /* CONFIG_IEEE80211W */
#ifdef CONFIG_RTW_WNM
	{RTW_WLAN_CATEGORY_WNM, "ACTION_WNM", &on_action_wnm},
#endif
	{RTW_WLAN_CATEGORY_UNPROTECTED_WNM, "ACTION_UNPROTECTED_WNM", &DoReserved},
#ifdef CONFIG_RTW_MESH
	{RTW_WLAN_CATEGORY_MESH, "ACTION_MESH", &on_action_mesh},
	{RTW_WLAN_CATEGORY_SELF_PROTECTED, "ACTION_SELF_PROTECTED", &on_action_self_protected},
#endif
	{RTW_WLAN_CATEGORY_WMM, "ACTION_WMM", &OnAction_wmm},
	{RTW_WLAN_CATEGORY_VHT, "ACTION_VHT", &OnAction_vht},
	{RTW_WLAN_CATEGORY_HE, "ACTION_HE", &OnAction_he},
	{RTW_WLAN_CATEGORY_PROTECTED_HE, "ACTION_PROTECTED_HE", &OnAction_protected_he},
	{RTW_WLAN_CATEGORY_P2P, "ACTION_P2P", &OnAction_p2p},
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	{RTW_WLAN_CATEGORY_TBTX, "ACTION_TBTX_TOKEN", &OnAction_tbtx_token},
#endif
	{RTW_WLAN_CATEGORY_UNPROTECTED_S1G, "ACTION_S1G", &on_action_s1g},
};


u8	null_addr[ETH_ALEN] = {0, 0, 0, 0, 0, 0};

/**************************************************
OUI definitions for the vendor specific IE
***************************************************/
unsigned char	RTW_WPA_OUI[] = {0x00, 0x50, 0xf2, 0x01};
unsigned char WMM_OUI[] = {0x00, 0x50, 0xf2, 0x02};
unsigned char	WPS_OUI[] = {0x00, 0x50, 0xf2, 0x04};
unsigned char	P2P_OUI[] = {0x50, 0x6F, 0x9A, 0x09};
unsigned char	WFD_OUI[] = {0x50, 0x6F, 0x9A, 0x0A};
unsigned char	MBO_OUI[] = {0x50, 0x6F, 0x9A, 0x16};
unsigned char	DPP_OUI[] = {0x50, 0x6F, 0x9A, 0x1A};

unsigned char	OWE_TRANSITION_OUI[] = {0x50, 0x6F, 0x9A, 0x1C};

unsigned char	WMM_INFO_OUI[] = {0x00, 0x50, 0xf2, 0x02, 0x00, 0x01};
unsigned char	WMM_PARA_OUI[] = {0x00, 0x50, 0xf2, 0x02, 0x01, 0x01};

unsigned char WPA_TKIP_CIPHER[4] = {0x00, 0x50, 0xf2, 0x02};
unsigned char RSN_TKIP_CIPHER[4] = {0x00, 0x0f, 0xac, 0x02};

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
unsigned char REALTEK_TBTX_IE[] = {0x00, 0xe0, 0x4c, 0x01, 0x00, 0x00, 0x00, 0x00};
#endif
extern unsigned char REALTEK_96B_IE[];

static void init_channel_list(_adapter *padapter, RT_CHANNEL_INFO *channel_set
	, struct p2p_channels *channel_list)
{
	struct registry_priv *regsty = adapter_to_regsty(padapter);

	struct p2p_oper_class_map op_class[] = {
		{ IEEE80211G,  81,   1,  13,  1, BW20 },
		{ IEEE80211G,  82,  14,  14,  1, BW20 },
#if 0 /* Do not enable HT40 on 2 GHz */
		{ IEEE80211G,  83,   1,   9,  1, BW40PLUS },
		{ IEEE80211G,  84,   5,  13,  1, BW40MINUS },
#endif
		{ IEEE80211A, 115,  36,  48,  4, BW20 },
		{ IEEE80211A, 116,  36,  44,  8, BW40PLUS },
		{ IEEE80211A, 117,  40,  48,  8, BW40MINUS },
		{ IEEE80211A, 124, 149, 161,  4, BW20 },
		{ IEEE80211A, 125, 149, 169,  4, BW20 },
		{ IEEE80211A, 126, 149, 157,  8, BW40PLUS },
		{ IEEE80211A, 127, 153, 161,  8, BW40MINUS },
		{ -1, 0, 0, 0, 0, BW20 }
	};

	int cla, op;

	cla = 0;

	for (op = 0; op_class[op].op_class; op++) {
		u8 ch;
		struct p2p_oper_class_map *o = &op_class[op];
		struct p2p_reg_class *reg = NULL;

		for (ch = o->min_chan; ch <= o->max_chan; ch += o->inc) {
			if (rtw_chset_search_ch(channel_set, ch) == -1)
				continue;
#if defined(CONFIG_80211N_HT) || defined(CONFIG_80211AC_VHT) /* CONFIG_80211AX_HE_TODO */
			if ((padapter->registrypriv.ht_enable == 0) && (o->inc == 8))
				continue;

			if ((REGSTY_IS_BW_5G_SUPPORT(regsty, ch_width_to_bw_cap(CHANNEL_WIDTH_40))) &&
			    ((o->bw == BW40MINUS) || (o->bw == BW40PLUS)))
				continue;
#endif
			if (reg == NULL) {
				reg = &channel_list->reg_class[cla];
				cla++;
				reg->reg_class = o->op_class;
				reg->channels = 0;
			}
			reg->channel[reg->channels] = ch;
			reg->channels++;
		}
	}
	channel_list->reg_classes = cla;

}

#if CONFIG_TXPWR_LIMIT
void rtw_txpwr_init_regd(struct rf_ctl_t *rfctl)
{
	u8 regd;
	u8 txpwr_lmt;
	bool country_txpwr_lmt_override = 0;
	struct regd_exc_ent *exc;
	struct txpwr_lmt_ent *ent;

	_rtw_mutex_lock_interruptible(&rfctl->txpwr_lmt_mutex);

	rfctl->txpwr_lmt_name = NULL;

	if (rfctl->txpwr_lmt_num == 0) {
		RTW_PRINT("there is no any txpwr_regd\n");
		goto release_lock;
	}

	/* search from exception mapping */
	exc = _rtw_regd_exc_search(rfctl
		, rfctl->country_ent ? rfctl->country_ent->alpha2 : NULL
		, rfctl->ChannelPlan);
	if (exc) {
		u8 has_country = (exc->country[0] == '\0' && exc->country[1] == '\0') ? 0 : 1;

		if (strcmp(exc->lmt_name, txpwr_lmt_str(TXPWR_LMT_NONE)) == 0)
			rfctl->txpwr_lmt_name = txpwr_lmt_str(TXPWR_LMT_NONE);
		else if (strcmp(exc->lmt_name, txpwr_lmt_str(TXPWR_LMT_WW)) == 0)
			rfctl->txpwr_lmt_name = txpwr_lmt_str(TXPWR_LMT_WW);
		else {
			ent = _rtw_txpwr_lmt_get_by_name(rfctl, exc->lmt_name);
			if (ent)
				rfctl->txpwr_lmt_name = ent->name;
		}

		RTW_PRINT("exception mapping country:%c%c domain:0x%02x to%s txpwr_lmt:%s\n"
			, has_country ? exc->country[0] : '0'
			, has_country ? exc->country[1] : '0'
			, exc->domain
			, rfctl->txpwr_lmt_name ? "" : " unknown"
			, exc->lmt_name
		);
		if (rfctl->txpwr_lmt_name)
			goto release_lock;
	}

	/* follow default channel plan mapping */
	if (rfctl->country_ent && rfctl->country_ent->txpwr_lmt_override != TXPWR_LMT_DEF) {
		country_txpwr_lmt_override = 1;
		txpwr_lmt = rfctl->country_ent->txpwr_lmt_override;
	} else {
		regd = rtw_chplan_get_default_regd(rfctl->ChannelPlan);
		txpwr_lmt = rtw_regd_to_txpwr_lmt(regd);
	}
	if (txpwr_lmt == TXPWR_LMT_NONE || txpwr_lmt == TXPWR_LMT_WW)
		rfctl->txpwr_lmt_name = txpwr_lmt_str(txpwr_lmt);
	else {
		ent = _rtw_txpwr_lmt_get_by_name(rfctl, txpwr_lmt_str(txpwr_lmt));
		if (ent)
			rfctl->txpwr_lmt_name = ent->name;
	}

	if (country_txpwr_lmt_override) {
		RTW_PRINT("default mapping country:%c%c to%s txpwr_lmt:%s\n"
			, rfctl->country_ent->alpha2[0], rfctl->country_ent->alpha2[1]
			, rfctl->txpwr_lmt_name ? "" : " unknown"
			, txpwr_lmt_str(txpwr_lmt)
		);
	} else {
		RTW_PRINT("default mapping domain:0x%02x to%s txpwr_lmt:%s\n"
			, rfctl->ChannelPlan
			, rfctl->txpwr_lmt_name ? "" : " unknown"
			, txpwr_lmt_str(txpwr_lmt)
		);
	}
	if (rfctl->txpwr_lmt_name)
		goto release_lock;

	switch (TXPWR_LMT_ALTERNATE_DEFINED(txpwr_lmt)) {
	case 1:
		/*
		* To support older chips without new predefined txpwr_lmt:
		* - use txpwr_lmt_alternate() to get alternate if the selection is  not found
		*/
		txpwr_lmt = txpwr_lmt_alternate(txpwr_lmt);
		ent = _rtw_txpwr_lmt_get_by_name(rfctl, txpwr_lmt_str(txpwr_lmt));
		if (ent)
			rfctl->txpwr_lmt_name = ent->name;
		RTW_PRINT("alternate txpwr_lmt:%s %s\n"
			, txpwr_lmt_str(txpwr_lmt)
			, rfctl->txpwr_lmt_name ? "is used" : "not found"
		);
		if (rfctl->txpwr_lmt_name)
			break;
		/* fall through */
	default:
		rfctl->txpwr_lmt_name = txpwr_lmt_str(TXPWR_LMT_WW);
		RTW_PRINT("assign %s for default case\n", txpwr_lmt_str(TXPWR_LMT_WW));
		break;
	};

release_lock:
	_rtw_mutex_unlock(&rfctl->txpwr_lmt_mutex);
}
#endif /* CONFIG_TXPWR_LIMIT */

int rtw_rfctl_init(struct dvobj_priv *dvobj)
{
	struct registry_priv *regsty = dvobj_to_regsty(dvobj);
	struct rf_ctl_t *rfctl = dvobj_to_rfctl(dvobj);
	_adapter *adapter = dvobj_get_primary_adapter(dvobj);
	int ret;

	/* rfctl->ChannelPlan init from Hal_EfuseParseChnlPlan->hal_com_config_channel_plan
	decide by efuse / registrypriv.channel_plan / registrypriv.alpha2*/
	/*TODO, load default channel plan from HW or SW.*/

#ifdef RTW_WKARD_REGD_DEFAULT_SET
	/* Set to FCC */
	rfctl->ChannelPlan = 0x76;
#endif

#if CONFIG_TXPWR_LIMIT
	_rtw_mutex_init(&rfctl->txpwr_lmt_mutex);
	_rtw_init_listhead(&rfctl->reg_exc_list);
	_rtw_init_listhead(&rfctl->txpwr_lmt_list);
#endif

	rfctl->ch_sel_within_same_band = 1;

	rtw_rfctl_dfs_init(rfctl,regsty);

	ret = op_class_pref_init(adapter);
	if (ret != _SUCCESS)
		op_class_pref_deinit(adapter);

#ifdef CONFIG_CSA_IE
	rtw_init_timer(&rfctl->set_csa_timer, rtw_set_csa_timer_hdl, adapter);
#endif

	return ret;
}

void rtw_rfctl_deinit(struct dvobj_priv *dvobj)
{
	struct rf_ctl_t *rfctl = dvobj_to_rfctl(dvobj);
	_adapter *adapter = dvobj_get_primary_adapter(dvobj);

	_rtw_mutex_free(&rfctl->offch_mutex);

	if (rfctl->country_ent) {
		rtw_mfree(rfctl->country_ent, sizeof(struct country_chplan));
		rfctl->country_ent = NULL;
	}
#if CONFIG_TXPWR_LIMIT
	rtw_regd_exc_list_free(rfctl);
	rtw_txpwr_lmt_list_free(rfctl);
	_rtw_mutex_free(&rfctl->txpwr_lmt_mutex);
#endif

	op_class_pref_deinit(adapter);
}

void rtw_rfctl_chplan_init(struct dvobj_priv *dvobj)
{
	struct rf_ctl_t *rfctl = dvobj_to_rfctl(dvobj);
	_adapter *adapter = dvobj_get_primary_adapter(dvobj);

	rfctl->max_chan_nums = init_channel_set(adapter);
	op_class_pref_apply_regulatory(adapter, REG_CHANGE);
	init_channel_list(adapter, rfctl->channel_set, &rfctl->channel_list);
}

#if 0
void rtw_rfctl_update_op_mode(struct rf_ctl_t *rfctl, u8 ifbmp_mod, u8 if_op)
{
	struct dvobj_priv *dvobj = rfctl_to_dvobj(rfctl);
	_adapter *iface;
	struct mlme_ext_priv *mlmeext;
	u8 op_class = 0;
	u8 op_ch = 0;
	s16 op_txpwr_max;
	u8 if_op_class[CONFIG_IFACE_NUMBER] = {0};
	u8 if_op_ch[CONFIG_IFACE_NUMBER] = {0};
	u8 ch, bw, offset;
	u8 u_ch = 0, u_bw, u_offset;
	bool notify = 0;
	int i;

	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		if (!iface)
			continue;
		mlmeext = &iface->mlmeextpriv;

		if (ifbmp_mod & BIT(i)) {
			if (!if_op)
				continue;
		} else if (!MLME_IS_ASOC(iface) || MLME_IS_OPCH_SW(iface))
			continue;

		ch = mlmeext->chandef.chan;
		bw = mlmeext->chandef.bw;
		offset = mlmeext->chandef.offset;
		if_op_class[i] = rtw_get_op_class_by_chbw(ch, bw, offset);
		if_op_ch[i] = if_op_class[i] ? ch : 0;

		if (!u_ch) {
			u_ch = ch;
			u_bw = bw;
			u_offset = offset;
		} else {
			rtw_warn_on(!rtw_is_chbw_grouped(u_ch, u_bw, u_offset, ch, bw, offset));
			rtw_sync_chbw(&ch, &bw, &offset, &u_ch, &u_bw, &u_offset);
		}
	}

	op_class = rtw_get_op_class_by_chbw(u_ch, u_bw, u_offset);
	op_ch = op_class ? u_ch : 0;
	op_txpwr_max = rtw_rfctl_get_oper_txpwr_max_mbm(rfctl, u_ch, u_bw, u_offset, ifbmp_mod, if_op, 1);

	if (op_class != rfctl->op_class
		|| op_ch != rfctl->op_ch
		|| op_txpwr_max != rfctl->op_txpwr_max
		|| _rtw_memcmp(if_op_class, rfctl->if_op_class, sizeof(u8) * CONFIG_IFACE_NUMBER) == _FALSE
		|| _rtw_memcmp(if_op_ch, rfctl->if_op_ch, sizeof(u8) * CONFIG_IFACE_NUMBER) == _FALSE)
		notify = 1;

	rfctl->op_class = op_class;
	rfctl->op_ch = op_ch;
	rfctl->op_txpwr_max = op_txpwr_max;
	_rtw_memcpy(rfctl->if_op_class, if_op_class, sizeof(u8) * CONFIG_IFACE_NUMBER);
	_rtw_memcpy(rfctl->if_op_ch, if_op_ch, sizeof(u8) * CONFIG_IFACE_NUMBER);

	if (0)
		RTW_INFO("radio: %u,%u,%u %d notify:%d\n", u_ch, u_bw, u_offset, op_txpwr_max, notify);
	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		if (!iface)
			continue;
		mlmeext = &iface->mlmeextpriv;

		if (ifbmp_mod & BIT(i)) {
			if (!if_op)
				continue;
		} else if (!MLME_IS_ASOC(iface))
			continue;
		if (0)
			RTW_INFO(ADPT_FMT": %u,%u,%u\n", ADPT_ARG(iface)
				, mlmeext->chandef.chan, mlmeext->chandef.bw, mlmeext->chandef.offset);
	}

	if (notify)
		rtw_nlrtw_radio_opmode_notify(rfctl);
}
#endif


#define RTW_CHF_FMT "%s%s%s%s%s%s"

#define RTW_CHF_ARG_NO_IR(flags)		(flags & RTW_CHF_NO_IR) ? " NO_IR" : ""
#define RTW_CHF_ARG_DFS(flags)			, (flags & RTW_CHF_DFS) ? " DFS" : ""
#define RTW_CHF_ARG_NO_HT40U(flags)		, (flags & RTW_CHF_NO_HT40U) ? " NO_40M+" : ""
#define RTW_CHF_ARG_NO_HT40L(flags)		, (flags & RTW_CHF_NO_HT40L) ? " NO_40M-" : ""
#define RTW_CHF_ARG_NO_80MHZ(flags)		, (flags & RTW_CHF_NO_80MHZ) ? " NO_80M" : ""
#define RTW_CHF_ARG_NO_160MHZ(flags)	, (flags & RTW_CHF_NO_160MHZ) ? " NO_160M" : ""

#define RTW_CHF_ARG(flags) \
	RTW_CHF_ARG_NO_IR(flags) \
	RTW_CHF_ARG_DFS(flags) \
	RTW_CHF_ARG_NO_HT40U(flags) \
	RTW_CHF_ARG_NO_HT40L(flags) \
	RTW_CHF_ARG_NO_80MHZ(flags) \
	RTW_CHF_ARG_NO_160MHZ(flags)

/* WNC-NMR0000-[Ducati]-Libera-20240924-Display of radar detection results-start */
#if 1	/* WNC-NMR0000-[Ducati]-Libera-20250417-libnfw-TYPE_GETST_WLAN_DFS_INFO-start */
// Two 255 size buffer, one is for W53 another one is for W56.
void dump_nec_dfs_record(void *sel, RT_CHANNEL_INFO *ch_set, u8 chset_num)
{
	struct seq_file *m = (struct seq_file *)sel;
	struct net_device *dev = m->private;
	_adapter *adapter = (_adapter *)rtw_netdev_priv(dev);
	int i=0, j=0, max_dfs_record_nums=0;
	DetectedDFSRecord *temp_records = NULL; // combine two arrays
	int total_records = 0;
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);

	//printk("[DDD] max_dfs_record_nums_52_64=%d, max_dfs_record_nums_100_144=%d,[%s] (%d)\n",rfctl->max_dfs_record_nums_52_64,rfctl->max_dfs_record_nums_100_144,__FUNCTION__,__LINE__);
	max_dfs_record_nums = rfctl->max_dfs_record_nums_52_64 + rfctl->max_dfs_record_nums_100_144;
	//printk("[DDD] max_dfs_record_nums=%d, [%s] (%d)\n",max_dfs_record_nums,__FUNCTION__,__LINE__);

	if (max_dfs_record_nums <= 0 || max_dfs_record_nums > 510) {
		printk("[WNC] Invalid DFS record count: %d, [%s] (%d)\n", max_dfs_record_nums,__FUNCTION__,__LINE__);
		return;
	}

    	// Dynamically allocate memory for temp_records
	temp_records = kmalloc_array(max_dfs_record_nums, sizeof(DetectedDFSRecord), GFP_KERNEL);
	if (!temp_records) {
		printk("[WNC] Memory allocation for temp_records failed! [%s] (%d)\n",__FUNCTION__,__LINE__);
		return;
	}

	// Combine dfs_record_52_64 and dfs_record_100_144
	for (i = 0; i < rfctl->max_dfs_record_nums_52_64; i++) {
	    temp_records[total_records++] = rfctl->dfs_record_52_64[i];
	}
	for (i = 0; i < rfctl->max_dfs_record_nums_100_144; i++) {
	    temp_records[total_records++] = rfctl->dfs_record_100_144[i];
	}
	//printk("[DDD] total_records=%d, [%s] (%d)\n",total_records,__FUNCTION__,__LINE__);

	// Sort it by time order.
	for (i = 0; i < total_records - 1; i++) {
		for (j = i + 1; j < total_records; j++) {
			if (temp_records[i].year > temp_records[j].year ||
				(temp_records[i].year == temp_records[j].year && temp_records[i].month > temp_records[j].month) ||
				(temp_records[i].year == temp_records[j].year && temp_records[i].month == temp_records[j].month && temp_records[i].day > temp_records[j].day) ||
				(temp_records[i].year == temp_records[j].year && temp_records[i].month == temp_records[j].month && temp_records[i].day == temp_records[j].day && temp_records[i].hour > temp_records[j].hour) ||
				(temp_records[i].year == temp_records[j].year && temp_records[i].month == temp_records[j].month && temp_records[i].day == temp_records[j].day && temp_records[i].hour == temp_records[j].hour && temp_records[i].minute > temp_records[j].minute)) {
				// exchange record
				DetectedDFSRecord temp = temp_records[i];
				temp_records[i] = temp_records[j];
				temp_records[j] = temp;
			}
		}
    }
	
	RTW_PRINT_SEL(sel, "=========== NEC DFS record-start ===========\n");
	for( i=0; i < total_records; i++){
		RTW_PRINT_SEL(sel, "%04d/%02d/%02d %02d:%02d %d %d %d\n",
			temp_records[i].year,temp_records[i].month, temp_records[i].day,
			temp_records[i].hour, temp_records[i].minute, 
			temp_records[i].channel, temp_records[i].bw, temp_records[i].central_channel
		);
	}

	RTW_PRINT_SEL(sel, "total dfs_record_nums=%d (Max=255(W53)+255(W56))\n",total_records);
	RTW_PRINT_SEL(sel, "=========== NEC DFS record-end ===========\n");
	
	kfree(temp_records);
}
#endif	/* WNC-NMR0000-[Ducati]-Libera-20250417-libnfw-TYPE_GETST_WLAN_DFS_INFO-end */

#if 0	// Lancia spec. one buffer (10) for all DFS channel
void dump_nec_dfs_record(void *sel, RT_CHANNEL_INFO *ch_set, u8 chset_num)
{
	struct seq_file *m = (struct seq_file *)sel;
	struct net_device *dev = m->private;
	_adapter *adapter = (_adapter *)rtw_netdev_priv(dev);
	int i=0;
	
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);

	RTW_PRINT_SEL(sel, "=========== NEC DFS record-start ===========\n");
	//if (rfctl->radar_detect_enabled && rfctl->max_dfs_record_nums) {
	if (rfctl->max_dfs_record_nums) {
		for(i=0; i < MAX_NEC_DFS_RECORD_NUM && i<rfctl->max_dfs_record_nums; i++){
			RTW_PRINT_SEL(sel, "%04d/%02d/%02d %02d:%02d %d %d %d\n",
				rfctl->dfs_record[i].year, rfctl->dfs_record[i].month, rfctl->dfs_record[i].day,
				rfctl->dfs_record[i].hour, rfctl->dfs_record[i].minute, 
				rfctl->dfs_record[i].channel, rfctl->dfs_record[i].bw, rfctl->dfs_record[i].central_channel
			);
		}
	}
	RTW_PRINT_SEL(sel, "total dfs_record_nums=%d (max=10)\n",rfctl->max_dfs_record_nums);
	RTW_PRINT_SEL(sel, "=========== NEC DFS record-end ===========\n");
}
#endif
/* WNC-NMR0000-[Ducati]-Libera-20240924-Display of radar detection results-end */

void dump_chset(void *sel, RT_CHANNEL_INFO *ch_set, u8 chset_num)
{
	char buf_non_ocp[8];
	char buf_cac[8];
	u8 i;
	struct seq_file *m = (struct seq_file *)sel;
	struct net_device *dev = m->private;
	_adapter *adapter = (_adapter *)rtw_netdev_priv(dev);

#ifdef CONFIG_DFS_MASTER
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);
	u32 non_ocp_ms;
	u32 cac_ms;
	u32 cur_hi, cur_lo, hi, lo;
	u8 in_rd_range = 0;
#endif
	RTW_PRINT_SEL(sel, "oper_ch=%d, oper_bw=%d, oper_ch_offet=%d\n",
		adapter->mlmeextpriv.cur_channel, adapter->mlmeextpriv.cur_bwmode, adapter->mlmeextpriv.cur_ch_offset);

	RTW_PRINT_SEL(sel, "======================\n");
	RTW_PRINT_SEL(sel, "%-3s %-4s %-4s %-3s flags\n", "ch", "freq", "non_ocp", "cac");

	for (i = 0; i < MAX_CHANNEL_NUM && i < chset_num && ch_set[i].ChannelNum != 0; i++) {
		#ifdef CONFIG_DFS_MASTER
		if ((ch_set[i].flags & RTW_CHF_DFS) && CH_IS_NON_OCP(&ch_set[i]))
			snprintf(buf_non_ocp, 8, "%d", rtw_systime_to_ms(ch_set[i].non_ocp_end_time - rtw_get_current_time()) / 1000);
		else
		#endif
			snprintf(buf_non_ocp, 8, "0");

		#ifdef CONFIG_DFS_MASTER
		if (rfctl->radar_detect_enabled) {
			in_rd_range = 0;

			if (rtw_chbw_to_freq_range(ch_set[i].ChannelNum,0, 0, &hi, &lo) == _FALSE) {
				RTW_ERR("input range ch:%u, bw:%u, offset:%u\n", ch_set[i].ChannelNum, 0, 0);
				rtw_warn_on(1);
			}

			if (rtw_chbw_to_freq_range(rfctl->radar_detect_ch, rfctl->radar_detect_bw, rfctl->radar_detect_offset, &cur_hi, &cur_lo) == _FALSE) {
				RTW_ERR("cur detection range ch:%u, bw:%u, offset:%u\n", rfctl->radar_detect_ch, rfctl->radar_detect_bw, rfctl->radar_detect_offset);
				rtw_warn_on(1);
			}

			if (rtw_is_range_a_in_b(hi, lo, cur_hi, cur_lo))
				in_rd_range = 1;

		}

		if (IS_UNDER_CAC(rfctl)
			&& !CH_IS_NON_OCP(&ch_set[i])
			&& in_rd_range)
			snprintf(buf_cac, 8, "%d", rtw_systime_to_ms(rfctl->cac_end_time - rtw_get_current_time()) / 1000);
		else
		#endif
			snprintf(buf_cac, 8, "0");

		RTW_PRINT_SEL(sel, "%3u %4u %4s %4s"RTW_CHF_FMT"\n"
			, ch_set[i].ChannelNum
			, rtw_ch2freq_by_band(ch_set[i].band, ch_set[i].ChannelNum)
			, buf_non_ocp
			, buf_cac
			, RTW_CHF_ARG(ch_set[i].flags)
		);

	}

#ifdef CONFIG_FIND_BEST_CHANNEL
		_RTW_PRINT_SEL(sel, ", rx_count:%u", ch_set[i].rx_count);
#endif

	RTW_PRINT_SEL(sel, "total ch number:%d\n", i);
	RTW_PRINT_SEL(sel, "\n");
}

void dump_cur_chset(void *sel, struct rf_ctl_t *rfctl)
{
	struct dvobj_priv *dvobj = rfctl_to_dvobj(rfctl);
	struct registry_priv *regsty = dvobj_to_regsty(dvobj);
	int i;

	if (rfctl->country_ent)
		dump_country_chplan(sel, rfctl->country_ent);
	else {
		RTW_PRINT_SEL(sel, "chplan:0x%02X\n", rfctl->ChannelPlan);
		#if CONFIG_IEEE80211_BAND_6GHZ
		RTW_PRINT_SEL(sel, "chplan_6g:0x%02X\n", rfctl->chplan_6g);
		#endif
	}

#if CONFIG_TXPWR_LIMIT
	RTW_PRINT_SEL(sel, "txpwr_lmt:%s\n", rfctl->txpwr_lmt_name);
#endif

#ifdef CONFIG_DFS_MASTER
	RTW_PRINT_SEL(sel, "dfs_domain:%u\n", rtw_dfs_get_region_domain(dvobj));
#endif

	for (i = 0; i < MAX_CHANNEL_NUM_2G_5G; i++)
		if (regsty->excl_chs[i] != 0)
			break;

	if (i < MAX_CHANNEL_NUM_2G_5G) {
		RTW_PRINT_SEL(sel, "excl_chs:");
		for (i = 0; i < MAX_CHANNEL_NUM_2G_5G; i++) {
			if (regsty->excl_chs[i] == 0)
				break;
			_RTW_PRINT_SEL(sel, "%u ", regsty->excl_chs[i]);
		}
		_RTW_PRINT_SEL(sel, "\n");
	}

#if CONFIG_IEEE80211_BAND_6GHZ
	for (i = 0; i < MAX_CHANNEL_NUM_6G; i++)
		if (regsty->excl_chs_6g[i] != 0)
			break;

	if (i < MAX_CHANNEL_NUM_6G) {
		RTW_PRINT_SEL(sel, "excl_chs_6g:");
		for (i = 0; i < MAX_CHANNEL_NUM_6G; i++) {
			if (regsty->excl_chs_6g[i] == 0)
				break;
			_RTW_PRINT_SEL(sel, "%u ", regsty->excl_chs_6g[i]);
		}
		_RTW_PRINT_SEL(sel, "\n");
	}
#endif

	dump_chset(sel, rfctl->channel_set, MAX_CHANNEL_NUM);
/* WNC-NMR0000-[Ducati]-Libera-20240924-Display of radar detection results-start */
	dump_nec_dfs_record(sel, rfctl->channel_set, MAX_CHANNEL_NUM);
/* WNC-NMR0000-[Ducati]-Libera-20240924-Display of radar detection results-end */
}

/*
 * Search the @param ch in given @param ch_set
 * @ch_set: the given channel set
 * @ch: the given channel number
 *
 * return the index of channel_num in channel_set, -1 if not found
 */
int rtw_chset_search_ch(RT_CHANNEL_INFO *ch_set, const u32 ch)
{
	int i;

	if (ch == 0)
		return -1;

	for (i = 0; i < MAX_CHANNEL_NUM && ch_set[i].ChannelNum != 0; i++) {
		if (ch == ch_set[i].ChannelNum)
			return i;
	}

	return -1;
}

/*
 * Search the @param ch of @param band in given @param ch_set
 * @ch_set: the given channel set
 * @band: the given band
 * @ch: the given channel number
 *
 * return the index of channel_num in channel_set, -1 if not found
 */
int rtw_chset_search_ch_by_band(RT_CHANNEL_INFO *ch_set, enum band_type band, const u32 ch)
{
	int i;

	if (ch == 0)
		return -1;

	for (i = 0; i < MAX_CHANNEL_NUM && ch_set[i].ChannelNum != 0; i++) {
		if (band == ch_set[i].band && ch == ch_set[i].ChannelNum)
			return i;
	}

	return -1;
}

/*
 * Check if the @param ch, bw, offset is valid for the given @param ch_set
 * @ch_set: the given channel set
 * @ch: the given channel number
 * @bw: the given bandwidth
 * @offset: the given channel offset
 *
 * return valid (1) or not (0)
 */
u8 rtw_chset_is_chbw_valid(RT_CHANNEL_INFO *ch_set, u8 ch, u8 bw, u8 offset
	, bool allow_primary_passive, bool allow_passive)
{
	u8 cch;
	u8 *op_chs;
	u8 op_ch_num;
	u8 valid = 0;
	int i;
	int ch_idx;

	cch = rtw_get_center_ch(ch, bw, offset);

	if (!rtw_get_op_chs_by_cch_bw(cch, bw, &op_chs, &op_ch_num))
		goto exit;

	for (i = 0; i < op_ch_num; i++) {
		if (0)
			RTW_INFO("%u,%u,%u - cch:%u, bw:%u, op_ch:%u\n", ch, bw, offset, cch, bw, *(op_chs + i));

		if (rtw_chset_is_chbw_non_ocp(ch_set, ch, bw, offset))
			break;

		ch_idx = rtw_chset_search_ch(ch_set, *(op_chs + i));
		if (ch_idx == -1)
			break;
		if (ch_set[ch_idx].flags & RTW_CHF_NO_IR) {
			if ((!allow_primary_passive && ch_set[ch_idx].ChannelNum == ch)
				|| (!allow_passive && ch_set[ch_idx].ChannelNum != ch))
			break;
		}
		if (bw >= CHANNEL_WIDTH_40) {
			if ((ch_set[ch_idx].flags & RTW_CHF_NO_HT40U) && i % 2 == 0)
				break;
			if ((ch_set[ch_idx].flags & RTW_CHF_NO_HT40L) && i % 2 == 1)
				break;
		}
		if (bw >= CHANNEL_WIDTH_80 && (ch_set[ch_idx].flags & RTW_CHF_NO_80MHZ))
			break;
		if (bw >= CHANNEL_WIDTH_160 && (ch_set[ch_idx].flags & RTW_CHF_NO_160MHZ))
			break;
	}

	if (op_ch_num != 0 && i == op_ch_num)
		valid = 1;

exit:
	RTW_INFO("[%s] ret=%u\n", __func__, valid);
	return valid;
}

/**
 * rtw_chset_sync_chbw - obey g_ch, adjust g_bw, g_offset, bw, offset to fit in channel plan
 * @ch_set: channel plan to check
 * @req_ch: pointer of the request ch, may be modified further
 * @req_bw: pointer of the request bw, may be modified further
 * @req_offset: pointer of the request offset, may be modified further
 * @g_ch: pointer of the ongoing group ch
 * @g_bw: pointer of the ongoing group bw, may be modified further
 * @g_offset: pointer of the ongoing group offset, may be modified further
 * @allow_primary_passive: if allow passive primary ch when deciding chbw
 * @allow_passive: if allow passive ch (not primary) when deciding chbw
 */
void rtw_chset_sync_chbw(RT_CHANNEL_INFO *ch_set, u8 *req_ch, u8 *req_bw, u8 *req_offset
	, u8 *g_ch, u8 *g_bw, u8 *g_offset, bool allow_primary_passive, bool allow_passive)
{
	u8 r_ch, r_bw, r_offset;
	u8 u_ch, u_bw, u_offset;
	u8 cur_bw = *req_bw;

	while (1) {
		r_ch = *req_ch;
		r_bw = cur_bw;
		r_offset = *req_offset;
		u_ch = *g_ch;
		u_bw = *g_bw;
		u_offset = *g_offset;

		rtw_sync_chbw(&r_ch, &r_bw, &r_offset, &u_ch, &u_bw, &u_offset);

		if (rtw_chset_is_chbw_valid(ch_set, r_ch, r_bw, r_offset, allow_primary_passive, allow_passive))
			break;
		if (cur_bw == CHANNEL_WIDTH_20) {
			rtw_warn_on(1);
			break;
		}
		cur_bw--;
	};

	*req_ch = r_ch;
	*req_bw = r_bw;
	*req_offset = r_offset;
	*g_ch = u_ch;
	*g_bw = u_bw;
	*g_offset = u_offset;
}

/*
 * Check the @param ch is fit with setband setting of @param adapter
 * @adapter: the given adapter
 * @ch: the given channel number
 *
 * return _TRUE when check valid, _FALSE not valid
 */
bool rtw_mlme_band_check(_adapter *adapter, const u32 ch)
{
	if (adapter->setband == WIFI_FREQUENCY_BAND_AUTO /* 2.4G and 5G */
		|| (adapter->setband == WIFI_FREQUENCY_BAND_2GHZ && ch < 35) /* 2.4G only */
		|| (adapter->setband == WIFI_FREQUENCY_BAND_5GHZ && ch > 35) /* 5G only */
	)
		return _TRUE;
	return _FALSE;
}
inline void RTW_SET_SCAN_BAND_SKIP(_adapter *padapter, int skip_band)
{
	int bs = ATOMIC_READ(&padapter->bandskip);

	bs |= skip_band;
	ATOMIC_SET(&padapter->bandskip, bs);
}

inline void RTW_CLR_SCAN_BAND_SKIP(_adapter *padapter, int skip_band)
{
	int bs = ATOMIC_READ(&padapter->bandskip);

	bs &= ~(skip_band);
	ATOMIC_SET(&padapter->bandskip, bs);
}
inline int RTW_GET_SCAN_BAND_SKIP(_adapter *padapter)
{
	return ATOMIC_READ(&padapter->bandskip);
}

#define RTW_IS_SCAN_BAND_SKIP(padapter, skip_band) (ATOMIC_READ(&padapter->bandskip) & (skip_band))

bool rtw_mlme_ignore_chan(_adapter *adapter, const u32 ch)
{
	if (RTW_IS_SCAN_BAND_SKIP(adapter, BAND_24G) && ch < 35) /* SKIP 2.4G Band channel */
		return _TRUE;
	if (RTW_IS_SCAN_BAND_SKIP(adapter, BAND_5G)  && ch > 35) /* SKIP 5G Band channel */
		return _TRUE;

	return _FALSE;
}


/****************************************************************************

Following are the initialization functions for WiFi MLME

*****************************************************************************/

int init_hw_mlme_ext(_adapter *padapter)
{
	struct	mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	HAL_DATA_TYPE *pHalData = GET_HAL_DATA(adapter_to_dvobj(padapter));
	u8 rx_bar_enble = _TRUE;

	/*
	 * Sync driver status and hardware setting
	 */
#if 0 /*GEORGIA_TODO_FIXIT*/

	/* Modify to make sure first time change channel(band) would be done properly */
	pHalData->current_channel = 0;
	pHalData->current_channel_bw = CHANNEL_WIDTH_MAX;
	#if CONFIG_IEEE80211_BAND_5GHZ
	pHalData->current_band_type = BAND_MAX;
	#else
	pHalData->current_band_type = BAND_ON_24G;
	#endif
#endif
	/* set_opmode_cmd(padapter, infra_client_with_mlme); */ /* removed */
	rtw_hal_set_hwreg(padapter, HW_VAR_ENABLE_RX_BAR, &rx_bar_enble);
	set_channel_bwmode(padapter,
			pmlmeext->cur_channel,
			pmlmeext->cur_ch_offset,
			pmlmeext->cur_bwmode,
			_FALSE);

	return _SUCCESS;
}

void init_mlme_default_rate_set(_adapter *padapter)
{
	struct	mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	unsigned	char end_set[1] = {0xff};
	u8	offset_datarate = 0;
	u8	offset_basicrate = 0;
#ifdef CONFIG_80211N_HT
	unsigned char	supported_mcs_set[16] = {0xff, 0xff, 0xff, 0xff, 0x00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};
#endif

	if (is_supported_tx_cck(padapter->registrypriv.wireless_mode)) {

		unsigned char	datarate_b[B_MODE_RATE_NUM] ={_1M_RATE_, _2M_RATE_, _5M_RATE_, _11M_RATE_};
		_rtw_memcpy(pmlmeext->datarate, datarate_b, B_MODE_RATE_NUM);
		_rtw_memcpy(pmlmeext->basicrate, datarate_b, B_MODE_RATE_NUM);
		offset_datarate += B_MODE_RATE_NUM;
		offset_basicrate += B_MODE_RATE_NUM;
		RTW_INFO("%s: support CCK\n", __func__);
	}
	if(is_suuported_tx_ofdm(padapter->registrypriv.wireless_mode)) {
		unsigned char	datarate_g[G_MODE_RATE_NUM] ={_6M_RATE_, _9M_RATE_, _12M_RATE_, _18M_RATE_,_24M_RATE_, _36M_RATE_, _48M_RATE_, _54M_RATE_};
		unsigned char	basicrate_g[G_MODE_BASIC_RATE_NUM] = {_6M_RATE_, _12M_RATE_, _24M_RATE_};
		_rtw_memcpy(pmlmeext->datarate + offset_datarate, datarate_g, G_MODE_RATE_NUM);
		_rtw_memcpy(pmlmeext->basicrate + offset_basicrate,basicrate_g, G_MODE_BASIC_RATE_NUM);
		offset_datarate += G_MODE_RATE_NUM;
		offset_basicrate += G_MODE_BASIC_RATE_NUM;
		RTW_INFO("%s: support OFDM\n", __func__);

	}
	_rtw_memcpy(pmlmeext->datarate + offset_datarate, end_set, 1);
	_rtw_memcpy(pmlmeext->basicrate + offset_basicrate, end_set, 1);

#ifdef CONFIG_80211N_HT
	if( padapter->registrypriv.ht_enable && is_supported_ht(padapter->registrypriv.wireless_mode))
		_rtw_memcpy(pmlmeext->default_supported_mcs_set, supported_mcs_set, sizeof(pmlmeext->default_supported_mcs_set));
#endif
}

static void init_mlme_ext_priv_value(_adapter *padapter)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	ATOMIC_SET(&pmlmeext->event_seq, 0);
	pmlmeext->mgnt_seq = 0;/* reset to zero when disconnect at client mode */
#ifdef CONFIG_IEEE80211W
	pmlmeext->sa_query_seq = 0;
#endif
	pmlmeext->cur_channel = padapter->registrypriv.channel;
	pmlmeext->cur_bwmode = CHANNEL_WIDTH_20;
	pmlmeext->cur_ch_offset = CHAN_OFFSET_NO_EXT;

	pmlmeext->retry = 0;

	pmlmeext->cur_wireless_mode = padapter->registrypriv.wireless_mode;
	init_mlme_default_rate_set(padapter);

	if ((pmlmeext->cur_channel > 14) || ((padapter->registrypriv.wireless_mode & WLAN_MD_11B) == 0))
		pmlmeext->tx_rate = IEEE80211_OFDM_RATE_6MB;
	else
		pmlmeext->tx_rate = IEEE80211_CCK_RATE_1MB;

	mlmeext_set_scan_state(pmlmeext, SCAN_DISABLE);
	#if 0
	pmlmeext->sitesurvey_res.channel_idx = 0;
	#endif
	pmlmeext->sitesurvey_res.bss_cnt = 0;
	pmlmeext->sitesurvey_res.scan_ch_ms = SURVEY_TO;
	pmlmeext->sitesurvey_res.rx_ampdu_accept = RX_AMPDU_ACCEPT_INVALID;
	pmlmeext->sitesurvey_res.rx_ampdu_size = RX_AMPDU_SIZE_INVALID;
#ifdef CONFIG_SCAN_BACKOP
	mlmeext_assign_scan_backop_flags_sta(pmlmeext, /*SS_BACKOP_EN|*/SS_BACKOP_PS_ANNC | SS_BACKOP_TX_RESUME);
	#ifdef CONFIG_AP_MODE
	mlmeext_assign_scan_backop_flags_ap(pmlmeext, SS_BACKOP_EN | SS_BACKOP_PS_ANNC | SS_BACKOP_TX_RESUME);
	#endif
	#ifdef CONFIG_RTW_MESH
	mlmeext_assign_scan_backop_flags_mesh(pmlmeext, /*SS_BACKOP_EN | */SS_BACKOP_PS_ANNC | SS_BACKOP_TX_RESUME);
	#endif
	#if 0
	pmlmeext->sitesurvey_res.scan_cnt = 0;
	#endif
	pmlmeext->sitesurvey_res.scan_cnt_max = RTW_SCAN_NUM_OF_CH;
	pmlmeext->sitesurvey_res.backop_ms = RTW_BACK_OP_CH_MS;
#endif
#if defined(CONFIG_ANTENNA_DIVERSITY) || defined(DBG_SCAN_SW_ANTDIV_BL)
	pmlmeext->sitesurvey_res.is_sw_antdiv_bl_scan = 0;
#endif
	pmlmeext->scan_abort = _FALSE;
	pmlmeext->scan_abort_to = _FALSE;

	pmlmeinfo->state = WIFI_FW_NULL_STATE;
	pmlmeinfo->reauth_count = 0;
	pmlmeinfo->reassoc_count = 0;
	pmlmeinfo->link_count = 0;
	pmlmeinfo->auth_seq = 0;
	pmlmeinfo->auth_algo = dot11AuthAlgrthm_Open;
	pmlmeinfo->key_index = 0;
	pmlmeinfo->iv = 0;

	pmlmeinfo->enc_algo = _NO_PRIVACY_;
	pmlmeinfo->authModeToggle = 0;

	_rtw_memset(pmlmeinfo->chg_txt, 0, 128);

	pmlmeinfo->slotTime = SHORT_SLOT_TIME;
	pmlmeinfo->preamble_mode = PREAMBLE_AUTO;

	pmlmeinfo->dialogToken = 0;

	pmlmeext->action_public_rxseq = 0xffff;
	pmlmeext->action_public_dialog_token = 0xff;
#ifdef ROKU_PRIVATE
/*infra mode, used to store AP's info*/
	_rtw_memset(pmlmeinfo->SupportedRates_infra_ap, 0, NDIS_802_11_LENGTH_RATES_EX);
	pmlmeinfo->ht_vht_received = 0;
#endif /* ROKU_PRIVATE */
}

void init_mlme_ext_timer(_adapter *padapter)
{
	struct	mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;

#if 0
	rtw_init_timer(&pmlmeext->survey_timer, survey_timer_hdl, padapter);
#endif
	rtw_init_timer(&pmlmeext->link_timer, link_timer_hdl, padapter);
#ifdef CONFIG_RTW_80211R
	rtw_init_timer(&pmlmeext->ft_link_timer, rtw_ft_link_timer_hdl, padapter);
	rtw_init_timer(&pmlmeext->ft_roam_timer, rtw_ft_roam_timer_hdl, padapter);
#endif
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	rtw_init_timer(&pmlmeext->tbtx_xmit_timer, rtw_tbtx_xmit_timer_hdl, padapter);
	rtw_init_timer(&pmlmeext->tbtx_token_dispatch_timer, rtw_tbtx_token_dispatch_timer_hdl, padapter);
#endif
#ifdef REPORT_TIMER_SUPPORT
	if(is_primary_adapter(padapter)){
		rtw_init_timer(&(pmlmeext->report_timer), report_timer_hdl, padapter);
		set_report_timer(pmlmeext, 120000);
		RTW_PRINT("init_mlme_ext_timer\n");
	}
#endif

}

int	init_mlme_ext_priv(_adapter *padapter)
{
	int	res = _SUCCESS;
	struct registry_priv *pregistrypriv = &padapter->registrypriv;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	/* We don't need to memset padapter->XXX to zero, because adapter is allocated by rtw_zvmalloc(). */
	/* _rtw_memset((u8 *)pmlmeext, 0, sizeof(struct mlme_ext_priv)); */

	pmlmeext->padapter = padapter;

	init_mlme_ext_priv_value(padapter);
	pmlmeinfo->bAcceptAddbaReq = pregistrypriv->bAcceptAddbaReq;

	init_mlme_ext_timer(padapter);

#ifdef CONFIG_AP_MODE
	init_mlme_ap_info(padapter);
#endif

	pmlmeext->last_scan_time = 0;


#ifdef CONFIG_ACTIVE_KEEP_ALIVE_CHECK
	pmlmeext->active_keep_alive_check = _TRUE;
#else
	pmlmeext->active_keep_alive_check = _FALSE;
#endif

#ifdef DBG_FIXED_CHAN
	pmlmeext->fixed_chan = 0xFF;
#endif

#ifdef CONFIG_SUPPORT_STATIC_SMPS
	pmlmeext->ssmps_en = _FALSE;
	pmlmeext->ssmps_tx_tp_th = SSMPS_TX_TP_TH;/*Mbps*/
	pmlmeext->ssmps_rx_tp_th = SSMPS_RX_TP_TH;/*Mbps*/
	#ifdef DBG_STATIC_SMPS
	pmlmeext->ssmps_test = _FALSE;
	#endif
#endif

#ifdef CONFIG_CTRL_TXSS_BY_TP
	pmlmeext->txss_ctrl_en = _TRUE;
	pmlmeext->txss_tp_th = TXSS_TP_TH;
	pmlmeext->txss_tp_chk_cnt = TXSS_TP_CHK_CNT;
#endif

	return res;

}

void free_mlme_ext_priv(struct mlme_ext_priv *pmlmeext)
{
	_adapter *padapter = pmlmeext->padapter;

	if (!padapter)
		return;

	if (dev_is_drv_stopped(adapter_to_dvobj(padapter))) {
		/* _cancel_timer_ex(&pmlmeext->survey_timer); */
		_cancel_timer_ex(&pmlmeext->link_timer);
#ifdef REPORT_TIMER_SUPPORT
		if(is_primary_adapter(padapter)){
			_cancel_timer_ex(&pmlmeext->report_timer);
		}
#endif
	}
}

#ifdef CONFIG_PATCH_JOIN_WRONG_CHANNEL
static u8 cmp_pkt_chnl_diff(_adapter *padapter, u8 *pframe, uint packet_len)
{
	/* if the channel is same, return 0. else return channel differential	 */
	uint len;
	u8 channel;
	u8 *p;

	p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _DSSET_IE_, &len, packet_len - _BEACON_IE_OFFSET_);
	if (p) {
		channel = *(p + 2);
		if (padapter->mlmeextpriv.cur_channel >= channel)
			return padapter->mlmeextpriv.cur_channel - channel;
		else
			return channel - padapter->mlmeextpriv.cur_channel;
	} else
		return 0;
}
#endif /* CONFIG_PATCH_JOIN_WRONG_CHANNEL */

static void _mgt_dispatcher(_adapter *padapter, struct mlme_handler *ptable, union recv_frame *precv_frame)
{
	u8 bc_addr[ETH_ALEN] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	u8 *pframe = precv_frame->u.hdr.rx_data;

	if (ptable->func) {
		/* receive the frames that ra(a1) is my address or ra(a1) is bc address. */
		if (!_rtw_memcmp(GetAddr1Ptr(pframe), adapter_mac_addr(padapter), ETH_ALEN) &&
		    !_rtw_memcmp(GetAddr1Ptr(pframe), bc_addr, ETH_ALEN))
		{
#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
			struct rtw_wdev_priv *pwdev_priv = adapter_wdev_data(padapter);

			if (!MLME_IS_STA(padapter))
				return;

		    if (check_fwstate(&padapter->mlmepriv, WIFI_ASOC_STATE) == _TRUE)
				return;

		    if ( pwdev_priv->pno_mac_addr[0] == 0xFF)
				return;

		    if (!_rtw_memcmp(GetAddr1Ptr(pframe), adapter_pno_mac_addr(padapter), ETH_ALEN))
				return;
#else
#ifdef RTW_CORE_PKT_TRACE
			if(padapter->pkt_trace_enable)
				RTW_RX_TRACE(padapter,&precv_frame->u.hdr.attrib.pktinfo);
#endif
			return;
#endif
		}

		ptable->func(padapter, precv_frame);
	}

}

void mgt_dispatcher(_adapter *padapter, union recv_frame *precv_frame)
{
	int index;
	struct mlme_handler *ptable;
	u8 bc_addr[ETH_ALEN] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	u8 *pframe = precv_frame->u.hdr.rx_data;
	struct sta_info *psta = rtw_get_stainfo(&padapter->stapriv, get_addr2_ptr(pframe));
	struct recv_priv  *precvpriv = &padapter->recvpriv;


#if 0
	{
		u8 *pbuf;
		pbuf = GetAddr1Ptr(pframe);
		RTW_INFO("A1-%x:%x:%x:%x:%x:%x\n", *pbuf, *(pbuf + 1), *(pbuf + 2), *(pbuf + 3), *(pbuf + 4), *(pbuf + 5));
		pbuf = get_addr2_ptr(pframe);
		RTW_INFO("A2-%x:%x:%x:%x:%x:%x\n", *pbuf, *(pbuf + 1), *(pbuf + 2), *(pbuf + 3), *(pbuf + 4), *(pbuf + 5));
		pbuf = GetAddr3Ptr(pframe);
		RTW_INFO("A3-%x:%x:%x:%x:%x:%x\n", *pbuf, *(pbuf + 1), *(pbuf + 2), *(pbuf + 3), *(pbuf + 4), *(pbuf + 5));
	}
#endif

	if (GetFrameType(pframe) != WIFI_MGT_TYPE) {
#ifdef RTW_CORE_PKT_TRACE
		if(padapter->pkt_trace_enable)
			RTW_RX_TRACE(padapter,&precv_frame->u.hdr.attrib.pktinfo);
#endif
		return;
	}

	/* receive the frames that ra(a1) is my address or ra(a1) is bc address. */
	if (!_rtw_memcmp(GetAddr1Ptr(pframe), adapter_mac_addr(padapter), ETH_ALEN) &&
	    !_rtw_memcmp(GetAddr1Ptr(pframe), bc_addr, ETH_ALEN))
		{
#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
			struct rtw_wdev_priv *pwdev_priv = adapter_wdev_data(padapter);

			if (!MLME_IS_STA(padapter))
				return;

			if (check_fwstate(&padapter->mlmepriv, WIFI_ASOC_STATE) == _TRUE)
				return;

			if ( pwdev_priv->pno_mac_addr[0] == 0xFF)
				return;

			if (!_rtw_memcmp(GetAddr1Ptr(pframe), adapter_pno_mac_addr(padapter), ETH_ALEN))
				return;
#else
#ifdef RTW_CORE_PKT_TRACE
			if(padapter->pkt_trace_enable)
				RTW_RX_TRACE(padapter,&precv_frame->u.hdr.attrib.pktinfo);
#endif
			return;
#endif
		}

	ptable = mlme_sta_tbl;

	index = get_frame_sub_type(pframe) >> 4;

#ifdef CONFIG_TDLS
	if ((index << 4) == WIFI_ACTION) {
		/* category==public (4), action==TDLS_DISCOVERY_RESPONSE */
		if (*(pframe + 24) == RTW_WLAN_CATEGORY_PUBLIC && *(pframe + 25) == TDLS_DISCOVERY_RESPONSE) {
			RTW_INFO("[TDLS] Recv %s from "MAC_FMT"\n", rtw_tdls_action_txt(TDLS_DISCOVERY_RESPONSE), MAC_ARG(get_addr2_ptr(pframe)));
			On_TDLS_Dis_Rsp(padapter, precv_frame);
		}
	}
#endif /* CONFIG_TDLS */

	if (index >= (sizeof(mlme_sta_tbl) / sizeof(struct mlme_handler))) {
#ifdef RTW_CORE_PKT_TRACE
		if(padapter->pkt_trace_enable)
			RTW_RX_TRACE(padapter,&precv_frame->u.hdr.attrib.pktinfo);
#endif
		return;
	}
	ptable += index;

#if 1
	if (psta != NULL) {
		if (GetRetry(pframe)) {
			if (precv_frame->u.hdr.attrib.seq_num == psta->RxMgmtFrameSeqNum) {
				/* drop the duplicate management frame */
				precvpriv->dbg_rx_dup_mgt_frame_drop_count++;
				RTW_INFO("Drop duplicate management frame with seq_num = %d.\n", precv_frame->u.hdr.attrib.seq_num);
#ifdef RTW_CORE_PKT_TRACE
				if(padapter->pkt_trace_enable)
					RTW_RX_TRACE(padapter,&precv_frame->u.hdr.attrib.pktinfo);
#endif
				return;
			}
		}
		psta->RxMgmtFrameSeqNum = precv_frame->u.hdr.attrib.seq_num;
	}
#else

	if (GetRetry(pframe)) {
		/* return; */
	}
#endif

#ifdef RTW_CORE_PKT_TRACE
	if(padapter->pkt_trace_enable)
		RTW_RX_TRACE(padapter,&precv_frame->u.hdr.attrib.pktinfo);
#endif

#ifdef CONFIG_AP_MODE
	switch (get_frame_sub_type(pframe)) {
	case WIFI_AUTH:
		if (MLME_IS_AP(padapter) || MLME_IS_MESH(padapter))
			ptable->func = &OnAuth;
		else
			ptable->func = &OnAuthClient;
		/* fall through */
	case WIFI_ASSOCREQ:
	case WIFI_REASSOCREQ:
		_mgt_dispatcher(padapter, ptable, precv_frame);
		#ifdef CONFIG_HOSTAPD_MLME
		if (MLME_IS_AP(padapter))
			rtw_hostapd_mlme_rx(padapter, precv_frame);
		#endif
		break;
	case WIFI_PROBEREQ:
		_mgt_dispatcher(padapter, ptable, precv_frame);
		#ifdef CONFIG_HOSTAPD_MLME
		if (MLME_IS_AP(padapter))
			rtw_hostapd_mlme_rx(padapter, precv_frame);
		#endif
		break;
	case WIFI_BEACON:
		_mgt_dispatcher(padapter, ptable, precv_frame);
		break;
	case WIFI_ACTION:
		_mgt_dispatcher(padapter, ptable, precv_frame);
		break;
	default:
		_mgt_dispatcher(padapter, ptable, precv_frame);
		#ifdef CONFIG_HOSTAPD_MLME
		if (MLME_IS_AP(padapter))
			rtw_hostapd_mlme_rx(padapter, precv_frame);
		#endif
		break;
	}
#else

	_mgt_dispatcher(padapter, ptable, precv_frame);

#endif

}

#ifdef CONFIG_P2P
u32 p2p_listen_state_process(_adapter *padapter, unsigned char *da)
{
	bool response = _TRUE;

#ifdef CONFIG_IOCTL_CFG80211
	if (padapter->wdinfo.driver_interface == DRIVER_CFG80211) {
		if (rtw_cfg80211_get_is_roch(padapter) == _FALSE
			|| rtw_get_oper_ch(padapter) != padapter->wdinfo.listen_channel
			|| adapter_wdev_data(padapter)->p2p_enabled == _FALSE
			|| padapter->mlmepriv.wps_probe_resp_ie == NULL
			|| padapter->mlmepriv.p2p_probe_resp_ie == NULL
		) {
#ifdef CONFIG_DEBUG_CFG80211
			RTW_INFO(ADPT_FMT" DON'T issue_probersp_p2p: p2p_enabled:%d, wps_probe_resp_ie:%p, p2p_probe_resp_ie:%p\n"
				, ADPT_ARG(padapter)
				, adapter_wdev_data(padapter)->p2p_enabled
				, padapter->mlmepriv.wps_probe_resp_ie
				, padapter->mlmepriv.p2p_probe_resp_ie);
			RTW_INFO(ADPT_FMT" DON'T issue_probersp_p2p: is_ro_ch:%d, op_ch:%d, p2p_listen_channel:%d\n"
				, ADPT_ARG(padapter)
				, rtw_cfg80211_get_is_roch(padapter)
				, rtw_get_oper_ch(padapter)
				, padapter->wdinfo.listen_channel);
#endif
			response = _FALSE;
		}
	} else
#endif /* CONFIG_IOCTL_CFG80211 */
		if (padapter->wdinfo.driver_interface == DRIVER_WEXT) {
			/*	do nothing if the device name is empty */
			if (!padapter->wdinfo.device_name_len)
				response	= _FALSE;
		}

	if (response == _TRUE)
		issue_probersp_p2p(padapter, da);

	return _SUCCESS;
}
#endif /* CONFIG_P2P */


/****************************************************************************

Following are the callback functions for each subtype of the management frames

*****************************************************************************/

unsigned int OnProbeReq(_adapter *padapter, union recv_frame *precv_frame)
{
	unsigned int	ielen;
	unsigned char	*p;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX	*cur = &(pmlmeinfo->network);
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint len = precv_frame->u.hdr.len;
	u8 is_valid_p2p_probereq = _FALSE;
#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	int vendor_ie_num = 0;
	unsigned char	*pvsie=NULL;
	unsigned char tmpbuf[256+ETH_ALEN];

#endif
#if defined(CONFIG_IOCTL_CFG80211) || defined(CONFIG_ATMEL_RC_PATCH)
	u8                        *wps_ie = NULL;
	uint                       wps_ielen = 0;
#ifdef CONFIG_IOCTL_CFG80211
	u8 is_wps_trigger = 0;
#endif
#endif
#ifdef CONFIG_ATMEL_RC_PATCH
	u8 *target_ie = NULL;
	u8 *start;
	uint search_len = 0, target_ielen = 0;
	struct sta_info	*psta;
	struct sta_priv *pstapriv = &padapter->stapriv;
#endif

#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
	struct rx_pkt_attrib	*pattrib = &precv_frame->u.hdr.attrib;
	u8 wifi_test_chk_rate = 1;
#endif

#ifdef CONFIG_WLAN_MANAGER
	u8 rssi = precv_frame->u.hdr.attrib.phy_info.signal_strength;
	rtw_netlink_send_frame_rpt_msg(padapter, WIFI_PROBEREQ, get_sa(pframe), rssi);
#endif

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, get_addr2_ptr(pframe), 0, "Probe Request", (pframe+WLAN_HDR_A3_LEN), (len-WLAN_HDR_A3_LEN));
#endif

#ifdef CONFIG_RTW_MBO
	/* AP is under BSS termination duration*/
	if (MLME_IS_AP(padapter) &&
		(pmlmepriv->mbopriv.bss_termination_phase == BSS_TERMINATION_DUR)) {
		RTW_DBG("%s : ignore probe request since AP is under BSS termination duration\n",
			__func__);
		return _FAIL;
	}
#endif

#if CONFIG_RTW_MACADDR_ACL
	if (rtw_access_ctrl(padapter, get_sa(pframe)) == _FALSE) {
		RTW_DBG("%s : ignore probe request since STA is blocked by ACL rules\n",
			__func__);
		return _FAIL;
	}
#endif

#ifdef CONFIG_RTW_BL_FASTCON_HOOK
	if(padapter->registrypriv.wifi_mib.fastcon_en && rtw_fastcon_rx_check(padapter, precv_frame)== SUCCESS){
		rtw_fastcon_mlme_rx(padapter, precv_frame);
		return _SUCCESS;
	}
#endif

#ifdef CONFIG_IOCTL_CFG80211
	if (MLME_IS_AP(padapter)) {
		wps_ie = rtw_get_wps_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_,
								len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_,
								NULL,
								&wps_ielen);
		if (wps_ie) {
			u16 wps_devicepassword_id = 0x0000;
			uint wps_devicepassword_id_len = 0;
			wps_devicepassword_id_len = sizeof(wps_devicepassword_id);
			rtw_get_wps_attr_content(wps_ie, wps_ielen, WPS_ATTR_DEVICE_PWID, (u8 *) &wps_devicepassword_id, &wps_devicepassword_id_len);
			wps_devicepassword_id = be16_to_cpu(wps_devicepassword_id);
			if (wps_devicepassword_id == WPS_DPID_PBC)
				is_wps_trigger = 1;
		}
	}
	if ((MLME_IS_AP(padapter) &&
		(GET_CFG80211_REPORT_MGMT(adapter_wdev_data(padapter), IEEE80211_STYPE_PROBE_REQ) == _TRUE)) || (is_primary_adapter(padapter) && MLME_IS_AP(padapter) && (is_wps_trigger == 1))) {
		rtw_cfg80211_rx_probe_request(padapter, precv_frame);
		return _SUCCESS;
	}
#endif /* CONFIG_IOCTL_CFG80211 */

#ifdef CONFIG_P2P
	if (!rtw_p2p_chk_state(pwdinfo, P2P_STATE_NONE) &&
	    !rtw_p2p_chk_state(pwdinfo, P2P_STATE_IDLE) &&
	    !rtw_p2p_chk_role(pwdinfo, P2P_ROLE_CLIENT) &&
	    !rtw_p2p_chk_state(pwdinfo, P2P_STATE_FIND_PHASE_SEARCH) &&
	    !rtw_p2p_chk_state(pwdinfo, P2P_STATE_SCAN)
	   ) {
		/*	Commented by Albert 2011/03/17 */
		/*	mcs_rate = 0->CCK 1M rate */
		/*	mcs_rate = 1->CCK 2M rate */
		/*	mcs_rate = 2->CCK 5.5M rate */
		/*	mcs_rate = 3->CCK 11M rate */
		/*	In the P2P mode, the driver should not support the CCK rate */

		/*	Commented by Kurt 2012/10/16 */
		/*	IOT issue: Google Nexus7 use 1M rate to send p2p_probe_req after GO nego completed and Nexus7 is client */
		if (padapter->registrypriv.wifi_spec == 1) {
			if (pattrib->data_rate <= DESC_RATE11M)
				wifi_test_chk_rate = 0;
		}

		if (wifi_test_chk_rate == 1) {
			is_valid_p2p_probereq = process_probe_req_p2p_ie(pwdinfo, pframe, len);
			if (is_valid_p2p_probereq == _TRUE) {
				if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_DEVICE)) {
					/* FIXME */
					if (padapter->wdinfo.driver_interface == DRIVER_WEXT)
						report_survey_event(padapter, precv_frame);

					p2p_listen_state_process(padapter,  get_sa(pframe));

					return _SUCCESS;
				}

				if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO))
					goto _continue;
			}
		}
	}

_continue:
#endif /* CONFIG_P2P */

	if (MLME_IS_STA(padapter))
		return _SUCCESS;

	if (check_fwstate(pmlmepriv, WIFI_ASOC_STATE) == _FALSE &&
	    check_fwstate(pmlmepriv, WIFI_ADHOC_MASTER_STATE | WIFI_AP_STATE | WIFI_MESH_STATE) == _FALSE)
		return _SUCCESS;


	/* RTW_INFO("+OnProbeReq\n"); */


#ifdef CONFIG_ATMEL_RC_PATCH
	wps_ie = rtw_get_wps_ie(
			      pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_,
			      len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_,
			      NULL, &wps_ielen);
	if (wps_ie)
		target_ie = rtw_get_wps_attr_content(wps_ie, wps_ielen, WPS_ATTR_MANUFACTURER, NULL, &target_ielen);
	if ((target_ie && (target_ielen == 4)) && (_TRUE == _rtw_memcmp((void *)target_ie, "Ozmo", 4))) {
		/* psta->flag_atmel_rc = 1; */
		unsigned char *sa_addr = get_sa(pframe);
		printk("%s: Find Ozmo RC -- %02x:%02x:%02x:%02x:%02x:%02x  \n\n",
		       __func__, *sa_addr, *(sa_addr + 1), *(sa_addr + 2), *(sa_addr + 3), *(sa_addr + 4), *(sa_addr + 5));
		_rtw_memcpy(pstapriv->atmel_rc_pattern, get_sa(pframe), ETH_ALEN);
	}
#endif


#ifdef CONFIG_AUTO_AP_MODE
	if (check_fwstate(pmlmepriv, WIFI_ASOC_STATE) == _TRUE &&
	    pmlmepriv->cur_network.join_res == _TRUE) {
		struct sta_info	*psta;
		u8 *mac_addr, *peer_addr;
		struct sta_priv *pstapriv = &padapter->stapriv;
		u8 RC_OUI[4] = {0x00, 0xE0, 0x4C, 0x0A};
		/* EID[1] + EID_LEN[1] + RC_OUI[4] + MAC[6] + PairingID[2] + ChannelNum[2] */

		p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _VENDOR_SPECIFIC_IE_, (int *)&ielen,
			       len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);

		if (!p || ielen != 14)
			goto _non_rc_device;

		if (!_rtw_memcmp(p + 2, RC_OUI, sizeof(RC_OUI)))
			goto _non_rc_device;

		if (!_rtw_memcmp(p + 6, get_sa(pframe), ETH_ALEN)) {
			RTW_INFO("%s, do rc pairing ("MAC_FMT"), but mac addr mismatch!("MAC_FMT")\n", __FUNCTION__,
				 MAC_ARG(get_sa(pframe)), MAC_ARG(p + 6));

			goto _non_rc_device;
		}

		RTW_INFO("%s, got the pairing device("MAC_FMT")\n", __FUNCTION__,  MAC_ARG(get_sa(pframe)));

		/* new a station */
		psta = rtw_get_stainfo(pstapriv, get_sa(pframe));
		if (psta == NULL) {
			/* allocate a new one */
			RTW_INFO("going to alloc stainfo for rc="MAC_FMT"\n",  MAC_ARG(get_sa(pframe)));
			psta = rtw_alloc_stainfo(pstapriv, get_sa(pframe), PHL_CMD_DIRECTLY);
			if (psta == NULL) {
				/* TODO: */
				RTW_INFO(" Exceed the upper limit of supported clients...\n");
				return _SUCCESS;
			}

			_rtw_spinlock_bh(&pstapriv->asoc_list_lock);
			if (rtw_is_list_empty(&psta->asoc_list)) {
				psta->expire_to = pstapriv->expire_to;
				rtw_list_insert_tail(&psta->asoc_list, &pstapriv->asoc_list);
				pstapriv->asoc_list_cnt++;
				#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
				if (psta->tbtx_enable)
					pstapriv->tbtx_asoc_list_cnt++;
				#endif
			}
			_rtw_spinunlock_bh(&pstapriv->asoc_list_lock);

			/* generate pairing ID */
			mac_addr = adapter_mac_addr(padapter);
			peer_addr = psta->phl_sta->mac_addr;
			psta->pid = (u16)(((mac_addr[4] << 8) + mac_addr[5]) + ((peer_addr[4] << 8) + peer_addr[5]));

			/* update peer stainfo */
			psta->isrc = _TRUE;

			/* AID assignment */
			if (psta->phl_sta->aid > 0)
				RTW_INFO(FUNC_ADPT_FMT" old AID=%d\n", FUNC_ADPT_ARG(padapter), psta->phl_sta->aid);
			else {
				if (!rtw_aid_alloc(padapter, psta)) {
					RTW_INFO(FUNC_ADPT_FMT" no room for more AIDs\n", FUNC_ADPT_ARG(padapter));
					return _SUCCESS;
				}
				RTW_INFO(FUNC_ADPT_FMT" allocate new AID=%d\n", FUNC_ADPT_ARG(padapter), psta->phl_sta->aid);
			}

			psta->qos_option = 1;
			psta->phl_sta->chandef.bw = CHANNEL_WIDTH_20;
			psta->ieee8021x_blocked = _FALSE;
#ifdef CONFIG_80211N_HT
			if(padapter->registrypriv.ht_enable &&
				is_supported_ht(padapter->registrypriv.wireless_mode)) {
				psta->htpriv.ht_option = _TRUE;
				psta->htpriv.ampdu_enable = _FALSE;
				psta->htpriv.sgi_20m = _FALSE;
				psta->htpriv.sgi_40m = _FALSE;
				psta->htpriv.ch_offset = CHAN_OFFSET_NO_EXT;
				psta->htpriv.agg_enable_bitmap = 0x0;/* reset */
				psta->htpriv.candidate_tid_bitmap = 0x0;/* reset */
			}
#endif

			rtw_hal_set_phydm_var(padapter, HAL_PHYDM_STA_INFO, psta, _TRUE);

			_rtw_memset((void *)&psta->sta_stats, 0, sizeof(struct stainfo_stats));

			_rtw_spinlock_bh(&psta->lock);
			psta->state |= WIFI_ASOC_STATE;
			_rtw_spinunlock_bh(&psta->lock);

			report_add_sta_event(padapter, psta->phl_sta->mac_addr);

		}

		issue_probersp(padapter, get_sa(pframe), _FALSE);

		return _SUCCESS;

	}

_non_rc_device:

	return _SUCCESS;

#endif /* CONFIG_AUTO_AP_MODE */


#ifdef CONFIG_CONCURRENT_MODE
	if (MLME_IN_AP_STATE(pmlmeinfo) &&
	    rtw_mi_buddy_check_fwstate(padapter, WIFI_UNDER_LINKING | WIFI_UNDER_SURVEY)) {
		/* don't process probe req */
		return _SUCCESS;
	}
#endif

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	rtw_parse_vendor_ie(padapter, NULL, pframe,
			pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);
#endif

	if (pmlmeext->cur_channel <= 14) {
		p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_,
			       _DSSET_IE_, (int *)&ielen,
			       len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);
		if (p && ielen && (p[2] != pmlmeext->cur_channel))
			return _SUCCESS;
	}

	p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _SSID_IE_, (int *)&ielen,
		       len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);


	/* check (wildcard) SSID */
	if (p != NULL) {
#ifdef CONFIG_P2P
		if (is_valid_p2p_probereq == _TRUE)
			goto _issue_probersp;
#endif

		if ((ielen != 0 &&
                     (ielen != cur->Ssid.SsidLength || _FALSE == _rtw_memcmp((void *)(p + 2), (void *)cur->Ssid.Ssid, ielen)))
			|| (ielen == 0 && pmlmeinfo->hidden_ssid_mode))
			goto exit;

		#ifdef CONFIG_RTW_MESH
		if (MLME_IS_MESH(padapter)) {
			p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, WLAN_EID_MESH_ID, (int *)&ielen,
					len - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);

			if (!p)
				goto exit;
			if (ielen != 0 && _rtw_memcmp((void *)(p + 2), (void *)cur->mesh_id.Ssid, cur->mesh_id.SsidLength) == _FALSE)
				goto exit;
		}
		#endif

_issue_probersp:
		if (((check_fwstate(pmlmepriv, WIFI_ASOC_STATE) == _TRUE &&
		      pmlmepriv->cur_network.join_res == _TRUE)) || check_fwstate(pmlmepriv, WIFI_ADHOC_MASTER_STATE)) {
			/* RTW_INFO("+issue_probersp during ap mode\n"); */
			issue_probersp(padapter, get_sa(pframe), is_valid_p2p_probereq);
		}

	}

exit:
	return _SUCCESS;

}

unsigned int OnProbeRsp(_adapter *padapter, union recv_frame *precv_frame)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	u8	*pframe = precv_frame->u.hdr.rx_data;
#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &padapter->wdinfo;
#endif

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, get_addr2_ptr(pframe), 0, "Probe Response", (pframe+WLAN_HDR_A3_LEN), (precv_frame->u.hdr.len-WLAN_HDR_A3_LEN));
#endif

#ifdef CONFIG_P2P
	if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_TX_PROVISION_DIS_REQ)) {
		if (_TRUE == pwdinfo->tx_prov_disc_info.benable) {
			if (_rtw_memcmp(pwdinfo->tx_prov_disc_info.peerIFAddr, get_addr2_ptr(pframe), ETH_ALEN)) {
				if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_CLIENT)) {
					pwdinfo->tx_prov_disc_info.benable = _FALSE;
					issue_p2p_provision_request(padapter,
						pwdinfo->tx_prov_disc_info.ssid.Ssid,
						pwdinfo->tx_prov_disc_info.ssid.SsidLength,
						pwdinfo->tx_prov_disc_info.peerDevAddr);
				} else if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_DEVICE) || rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
					pwdinfo->tx_prov_disc_info.benable = _FALSE;
					issue_p2p_provision_request(padapter,
								    NULL,
								    0,
						pwdinfo->tx_prov_disc_info.peerDevAddr);
				}
			}
		}
		return _SUCCESS;
	} else if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_GONEGO_ING)) {
		if (_TRUE == pwdinfo->nego_req_info.benable) {
			RTW_INFO("[%s] P2P State is GONEGO ING!\n", __FUNCTION__);
			if (_rtw_memcmp(pwdinfo->nego_req_info.peerDevAddr, get_addr2_ptr(pframe), ETH_ALEN)) {
				pwdinfo->nego_req_info.benable = _FALSE;
				issue_p2p_GO_request(padapter, pwdinfo->nego_req_info.peerDevAddr);
			}
		}
	} else if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_TX_INVITE_REQ)) {
		if (_TRUE == pwdinfo->invitereq_info.benable) {
			RTW_INFO("[%s] P2P_STATE_TX_INVITE_REQ!\n", __FUNCTION__);
			if (_rtw_memcmp(pwdinfo->invitereq_info.peer_macaddr, get_addr2_ptr(pframe), ETH_ALEN)) {
				pwdinfo->invitereq_info.benable = _FALSE;
				issue_p2p_invitation_request(padapter, pwdinfo->invitereq_info.peer_macaddr);
			}
		}
	}
#endif


	if ((mlmeext_chk_scan_state(pmlmeext, SCAN_PROCESS))
		|| (MLME_IS_MESH(padapter) && check_fwstate(&padapter->mlmepriv, WIFI_ASOC_STATE))
	) {
		struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);

		if (_rtw_memcmp(GetAddr3Ptr(pframe), get_my_bssid(&pmlmeinfo->network), ETH_ALEN)
			&& MLME_IS_STATE(pmlmeinfo, WIFI_FW_STATION_STATE)
			&& MLME_HAS_STATE(pmlmeinfo, WIFI_FW_ASSOC_SUCCESS)
		) {
			if (!rtw_check_bcn_info(padapter, pframe, precv_frame->u.hdr.len)) {
				RTW_PRINT(FUNC_ADPT_FMT" ap has changed, disconnect now\n", FUNC_ADPT_ARG(padapter));
				receive_disconnect(padapter, pmlmeinfo->network.MacAddress , 0, _FALSE);
			}
		}

		rtw_mi_report_survey_event(padapter, precv_frame);
		return _SUCCESS;
	}

#if 0 /* move to validate_recv_mgnt_frame */
	if (_rtw_memcmp(GetAddr3Ptr(pframe), get_my_bssid(&pmlmeinfo->network), ETH_ALEN)) {
		if (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS) {
			psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
			if (psta != NULL)
				psta->sta_stats.rx_mgnt_pkts++;
		}
	}
#endif

	return _SUCCESS;

}

/* for 11n Logo 4.2.31/4.2.32 */
static void rtw_check_legacy_ap(_adapter *padapter, u8 *pframe, u32 len)
{

	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
#if 0
	if (!padapter->registrypriv.wifi_spec)
		return;
#endif

	if(!MLME_IS_AP(padapter))
		return;


	if (pmlmeext->bstart_bss == _TRUE) {
		int left;
		unsigned char *pos;
		struct rtw_ieee802_11_elems elems;
#ifdef CONFIG_80211N_HT
		u16 cur_op_mode;
#endif
		/* checking IEs */
		left = len - sizeof(struct rtw_ieee80211_hdr_3addr) - _BEACON_IE_OFFSET_;
		pos = pframe + sizeof(struct rtw_ieee80211_hdr_3addr) + _BEACON_IE_OFFSET_;
		if (rtw_ieee802_11_parse_elems(pos, left, &elems, 1) == ParseFailed) {
			RTW_INFO("%s: parse fail for "MAC_FMT"\n", __func__, MAC_ARG(GetAddr3Ptr(pframe)));
			return;
		}
#ifdef CONFIG_80211N_HT
		cur_op_mode = pmlmepriv->ht_op_mode & HT_INFO_OPERATION_MODE_OP_MODE_MASK;
#endif
		/* for legacy ap */
		if (elems.ht_capabilities == NULL && elems.ht_capabilities_len == 0) {

			if (0)
				RTW_INFO("%s: "MAC_FMT" is legacy ap\n", __func__, MAC_ARG(GetAddr3Ptr(pframe)));

			ATOMIC_SET(&pmlmepriv->olbc_ap, _TRUE);
		} else if (elems.ht_operation && elems.ht_operation_len == HT_OP_IE_LEN) {
			if (GET_HT_OP_ELE_HT_PROTECT(elems.ht_operation) == OP_MODE_MIXED) {
				RTW_DBG("Detect protection mode = 3, BSSID = "MAC_FMT"\n", MAC_ARG(GetAddr3Ptr(pframe)));
				ATOMIC_SET(&pmlmepriv->olbc_sta, _TRUE);
			}
		}

	}
}

#ifdef CONFIG_WIFI_DIAGNOSIS
static void rtw_wifi_diag_onBeacon_bss(_adapter *adapter, union recv_frame *precv_frame)
{
	struct wifi_diag_obj *wifi_diag = &(adapter->dvobj->wifi_diag);
	struct wifi_diag_bss_entry *ent = NULL;
	struct beacon_keys recv_bcn;
	WLAN_BSSID_EX pbss;
	u8  *pframe = precv_frame->u.hdr.rx_data;
	u32  len = precv_frame->u.hdr.len;
	u8   i;

	if (wifi_diag->mode != DIAG_UNASSOC_STA
	    && wifi_diag->mode != DIAG_SPEC_STA)
		return;

	if (!wifi_diag->diag_ongoing)
		return;

	if (wifi_diag->bss_list_num >= WIFI_DIAG_ENTRY_NUM)
		return;

	if (collect_bss_info(adapter, precv_frame, &pbss) == _FAIL)
		return;

	if (rtw_get_bcn_keys(adapter, pframe, len, &recv_bcn) == _FAIL)
		return;

	for (i = 0; i < wifi_diag->bss_list_num; i++) {
		ent = &(wifi_diag->bss_list[i]);
		/* already in the list */
		if (_rtw_memcmp(ent->bssid, pbss.MacAddress, ETH_ALEN) == _TRUE)
			return;
	}

	/* Insert entry to current idx*/
	ent = &(wifi_diag->bss_list[wifi_diag->bss_list_num]);
	_rtw_memcpy(ent->bssid, pbss.MacAddress, ETH_ALEN);
	_rtw_memcpy(ent->ssid, recv_bcn.ssid, recv_bcn.ssid_len);
	ent->ssid_length = recv_bcn.ssid_len;
	ent->encrypt = recv_bcn.encryp_protocol;
	ent->pairwise_cipher = recv_bcn.pairwise_cipher;
	ent->group_cipher = recv_bcn.group_cipher;
	ent->akm = recv_bcn.akm;
	wifi_diag->bss_list_num++;

	return;
}
#endif

unsigned int OnBeacon(_adapter *padapter, union recv_frame *precv_frame)
{
	struct sta_info	*psta;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct sta_priv	*pstapriv = &padapter->stapriv;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint len = precv_frame->u.hdr.len;
	WLAN_BSSID_EX *pbss;
	int ret = _SUCCESS;
#ifdef CONFIG_TDLS
	struct sta_info *ptdls_sta;
	struct tdls_info *ptdlsinfo = &padapter->tdlsinfo;
#ifdef CONFIG_TDLS_CH_SW
	struct tdls_ch_switch *pchsw_info = &padapter->tdlsinfo.chsw_info;
#endif
#endif /* CONFIG_TDLS */

#ifndef RTW_PHL_TEST_FPGA
	if (validate_beacon_len(pframe, len) == _FALSE)
		return _SUCCESS;
#endif

#ifdef CONFIG_WIFI_DIAGNOSIS
	rtw_wifi_diag_onBeacon_bss(padapter, precv_frame);
#endif

#ifdef AP_NEIGHBOR_INFO
	rtw_add_ap_neighbor_info(padapter, precv_frame);
#endif


	if (mlmeext_chk_scan_state(pmlmeext, SCAN_PROCESS)
		|| (MLME_IS_MESH(padapter) && check_fwstate(pmlmepriv, WIFI_ASOC_STATE))
	) {
		if (_rtw_memcmp(GetAddr3Ptr(pframe), get_my_bssid(&pmlmeinfo->network), ETH_ALEN)
			&& MLME_IS_STATE(pmlmeinfo, WIFI_FW_STATION_STATE)
			&& MLME_HAS_STATE(pmlmeinfo, WIFI_FW_ASSOC_SUCCESS)
		) {
#ifndef RTW_PHL_TEST_FPGA
			if (!rtw_check_bcn_info(padapter, pframe, len)) {
				RTW_PRINT(FUNC_ADPT_FMT" ap has changed, disconnect now\n", FUNC_ADPT_ARG(padapter));
				receive_disconnect(padapter, pmlmeinfo->network.MacAddress , 0, _FALSE);
			}
#endif
		}

#ifdef RTW_SURVEY_EVENT_REFINE
		report_survey_event(padapter, precv_frame); /* only report to current adapter */
#else
		rtw_mi_report_survey_event(padapter, precv_frame);
#endif
		return _SUCCESS;
	}

	rtw_check_legacy_ap(padapter, pframe, len);

#ifdef CONFIG_CSA_IE
#if (CONFIG_RTW_MULTI_AP_DFS_EN) && (CONFIG_DFS)
	if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_AP_STATE)
	   && (is_primary_adapter(padapter))
	   && (padapter->multi_ap_mode == MAP_MODE_FRONT_AP)
	   && (adapter_to_rfctl(padapter)->radar_detected == 0)
	   && (is_supported_5g(padapter->registrypriv.band_type))
	   && (is_multiap_neighbor(padapter, GetAddr3Ptr(pframe)))) {
		process_map_member_csa_ie(padapter
			, pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_
			, len - (WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_));
	}
#endif
#endif

	if (_rtw_memcmp(GetAddr3Ptr(pframe), get_my_bssid(&pmlmeinfo->network), ETH_ALEN)) {
		if ((pmlmeinfo->state & WIFI_FW_AUTH_NULL)
			&& (rtw_sta_linking_test_wait_done() || pmlmeext->join_abort)
		) {
			if (rtw_sta_linking_test_force_fail() || pmlmeext->join_abort) {
				set_link_timer(pmlmeext, 1);
				return _SUCCESS;
			}

			/* we should update current network before auth, or some IE is wrong */
			pbss = (WLAN_BSSID_EX *)rtw_malloc(sizeof(WLAN_BSSID_EX));
			if (pbss) {
				if (collect_bss_info(padapter, precv_frame, pbss) == _SUCCESS) {
					struct beacon_keys recv_beacon;

					update_network(&(pmlmepriv->cur_network.network), pbss, padapter, _TRUE);

					/* update bcn keys */
#ifdef RTW_PHL_TEST_FPGA
					if (1)
#else
					if (rtw_get_bcn_keys(padapter, pframe, len, &recv_beacon) == _TRUE)
#endif
					{
						RTW_INFO("%s: beacon keys ready\n", __func__);
						_rtw_memcpy(&pmlmepriv->cur_beacon_keys,
							&recv_beacon, sizeof(recv_beacon));
						if (is_hidden_ssid(recv_beacon.ssid, recv_beacon.ssid_len)) {
							_rtw_memcpy(pmlmepriv->cur_beacon_keys.ssid, pmlmeinfo->network.Ssid.Ssid, IW_ESSID_MAX_SIZE);
							pmlmepriv->cur_beacon_keys.ssid_len = pmlmeinfo->network.Ssid.SsidLength;
						}
					} else {
						RTW_ERR("%s: get beacon keys failed\n", __func__);
						_rtw_memset(&pmlmepriv->cur_beacon_keys, 0, sizeof(recv_beacon));
					}
				}
				rtw_mfree((u8 *)pbss, sizeof(WLAN_BSSID_EX));
			}

			/* check the vendor of the assoc AP */
			pmlmeinfo->assoc_AP_vendor = check_assoc_AP(pframe + sizeof(struct rtw_ieee80211_hdr_3addr), len - sizeof(struct rtw_ieee80211_hdr_3addr));

			/* update TSF Value */
			update_TSF(pmlmeext, pframe, len);
			pmlmeext->bcn_cnt = 0;
			pmlmeext->last_bcn_cnt = 0;

#ifdef CONFIG_P2P_PS
			/* Comment by YiWei , in wifi p2p spec the "3.3 P2P Power Management" , "These mechanisms are available in a P2P Group in which only P2P Devices are associated." */
			/* process_p2p_ps_ie(padapter, (pframe + WLAN_HDR_A3_LEN), (len - WLAN_HDR_A3_LEN)); */
#endif /* CONFIG_P2P_PS */

#if defined(CONFIG_P2P) && defined(CONFIG_CONCURRENT_MODE)
			if (padapter->registrypriv.wifi_spec) {
				if (process_p2p_cross_connect_ie(padapter, (pframe + WLAN_HDR_A3_LEN), (len - WLAN_HDR_A3_LEN)) == _FALSE) {
					if (rtw_mi_buddy_check_mlmeinfo_state(padapter, WIFI_FW_AP_STATE)
					    #ifdef CONFIG_RTW_SUPPORT_MBSSID_VAP
					    || rtw_mi_buddy_check_mlmeinfo_state(padapter, WIFI_FW_VAP_STATE)
					    #endif
					) {
						RTW_PRINT("no issue auth, P2P cross-connect does not permit\n ");
						return _SUCCESS;
					}
				}
			}
#endif /* CONFIG_P2P CONFIG_P2P and CONFIG_CONCURRENT_MODE */

			/* start auth */
			start_clnt_auth(padapter);

			return _SUCCESS;
		}

		if (   MLME_IS_STATE(pmlmeinfo, WIFI_FW_STATION_STATE)
		    && MLME_HAS_STATE(pmlmeinfo, WIFI_FW_ASSOC_SUCCESS)) {
			psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
			if (psta != NULL) {
#ifdef CONFIG_PATCH_JOIN_WRONG_CHANNEL
				/* Merge from 8712 FW code */
				if (cmp_pkt_chnl_diff(padapter, pframe, len) != 0) {
					/* join wrong channel, deauth and reconnect           */
					issue_deauth(padapter, (&(pmlmeinfo->network))->MacAddress, WLAN_REASON_DEAUTH_LEAVING);

					report_del_sta_event(padapter, (&(pmlmeinfo->network))->MacAddress, WLAN_REASON_JOIN_WRONG_CHANNEL, _TRUE, _FALSE);
					pmlmeinfo->state &= (~WIFI_FW_ASSOC_SUCCESS);
					return _SUCCESS;
				}
#endif /* CONFIG_PATCH_JOIN_WRONG_CHANNEL */
#ifdef CONFIG_RTW_80211R
				rtw_ft_update_bcn(padapter, precv_frame);
#endif
#ifdef RTW_PHL_TEST_FPGA
				ret = 1;
#else
				ret = rtw_check_bcn_info(padapter, pframe, len);
#endif
				if (!ret) {
					RTW_PRINT(FUNC_ADPT_FMT" ap has changed, disconnect now\n", FUNC_ADPT_ARG(padapter));
					receive_disconnect(padapter, pmlmeinfo->network.MacAddress , 0, _FALSE);
					return _SUCCESS;
				}
				/* update WMM, ERP in the beacon */
				/* todo: the timer is used instead of the number of the beacon received */
				if ((sta_rx_pkts(psta) & 0xf) == 0) {
					/* RTW_INFO("update_bcn_info\n"); */
					update_beacon_info(padapter, pframe, len, psta);
				}

				if (pmlmepriv->cur_network_scanned)
				pmlmepriv->cur_network_scanned->network.Rssi = precv_frame->u.hdr.attrib.phy_info.recv_signal_power;
				pmlmeext->bcn_cnt++;
#ifdef CONFIG_BCN_RECV_TIME
				rtw_rx_bcn_time_update(padapter, len, precv_frame->u.hdr.attrib.data_rate);
#endif
#ifdef CONFIG_TDLS
#ifdef CONFIG_TDLS_CH_SW
				if (rtw_tdls_is_chsw_allowed(padapter) == _TRUE) {
					/* Send TDLS Channel Switch Request when receiving Beacon */
					if ((padapter->tdlsinfo.chsw_info.ch_sw_state & TDLS_CH_SW_INITIATOR_STATE) && (ATOMIC_READ(&pchsw_info->chsw_on) == _TRUE)
					    && (pmlmeext->cur_channel == rtw_get_oper_ch(padapter))) {
						ptdls_sta = rtw_get_stainfo(&padapter->stapriv, padapter->tdlsinfo.chsw_info.addr);
						if (ptdls_sta != NULL) {
							if (ptdls_sta->tdls_sta_state | TDLS_LINKED_STATE)
								_set_timer(&ptdls_sta->stay_on_base_chnl_timer, TDLS_CH_SW_STAY_ON_BASE_CHNL_TIMEOUT);
						}
					}
				}
#endif
#endif /* CONFIG_TDLS */

#ifdef CONFIG_CSA_IE
				process_csa_ie(padapter
					, pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_
					, len - (WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_));
#endif

#ifdef CONFIG_P2P_PS
				process_p2p_ps_ie(padapter, (pframe + WLAN_HDR_A3_LEN), (len - WLAN_HDR_A3_LEN));
#endif /* CONFIG_P2P_PS */


#if 0 /* move to validate_recv_mgnt_frame */
				psta->sta_stats.rx_mgnt_pkts++;
#endif
#ifdef CONFIG_NEC_TAKEOVER_SSID
				rtw_take_over_ssid(padapter, pframe, len);
#endif
			}

		} else if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_ADHOC_STATE)) {
			u8 rate_set[16];
			u8 rate_num = 0;

			psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
			if (psta != NULL) {
				/*
				* update WMM, ERP in the beacon
				* todo: the timer is used instead of the number of the beacon received
				*/
				if ((sta_rx_pkts(psta) & 0xf) == 0)
					update_beacon_info(padapter, pframe, len, psta);
			} else {
				rtw_ies_get_supported_rate(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, len - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_, rate_set, &rate_num);
				if (rate_num == 0) {
					RTW_INFO(FUNC_ADPT_FMT" RX beacon with no supported rate\n", FUNC_ADPT_ARG(padapter));
					goto _END_ONBEACON_;
				}

				psta = rtw_alloc_stainfo(pstapriv, get_addr2_ptr(pframe), PHL_CMD_DIRECTLY);
				if (psta == NULL) {
					RTW_INFO(FUNC_ADPT_FMT" Exceed the upper limit of supported clients\n", FUNC_ADPT_ARG(padapter));
					goto _END_ONBEACON_;
				}

				psta->expire_to = pstapriv->adhoc_expire_to;

				_rtw_memcpy(psta->bssrateset, rate_set, rate_num);
				psta->bssratelen = rate_num;

				/* update TSF Value */
				update_TSF(pmlmeext, pframe, len);

				/* report sta add event */
				report_add_sta_event(padapter, get_addr2_ptr(pframe));
			}
		}
	}

_END_ONBEACON_:

	return _SUCCESS;

}

static u32 rtw_get_sta_num_by_state(_adapter *padapter, u32 state)
{
	_list	*plist, *phead;
	u32	index, sta_num = 0;
	struct sta_info *psta = NULL;
	struct sta_priv *pstapriv = &(padapter->stapriv);

	_rtw_spinlock_bh(&pstapriv->sta_hash_lock);
	for (index = 0; index < NUM_STA; index++) {
		phead = &(pstapriv->sta_hash[index]);
		plist = get_next(phead);
		while ((rtw_end_of_queue_search(phead, plist)) == _FALSE) {
			psta = LIST_CONTAINOR(plist, struct sta_info , hash_list);
			if ((psta->state & (state)))
				sta_num++;
			plist = get_next(plist);
		}
	}
	_rtw_spinunlock_bh(&pstapriv->sta_hash_lock);

	/* RTW_INFO("%s : waiting for %u sta under linking \n", __func__, sta_num); */
	return sta_num;
}

static u8  rtw_defs_attack_chk(_adapter *padapter)
{
	struct mlme_priv *mlme = &(padapter->mlmepriv);
	u8 is_reject = _FALSE;
	u32 sta_limit = 0;
	u32 stime = rtw_systime_to_ms(rtw_get_current_time());
	static u32 ptime = 0;

	/* RTW_INFO("%s : ptime=%u, stime=%u, diff=%u\n", __func__, ptime, stime, (stime - ptime)); */
	if ((ptime > 0) && ((stime - ptime) < mlme->defs_lmt_time)) {
		sta_limit = rtw_get_sta_num_by_state(padapter, WIFI_FW_LINKING_STATE);
		if (sta_limit >= mlme->defs_lmt_sta)
			is_reject = _TRUE;
	}

	ptime = stime;
	/* RTW_INFO("%s : current linking num=%u\n", __func__, sta_limit); */
	return is_reject;
}

inline u8 auth_check_assoc_sta_num(_adapter *padapter)
{
	u8 sta_num = 0, up_if_num = 0, i = 0;
	_adapter *iface = NULL;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
#ifndef CONFIG_LIMITED_STA_NUM
	u8 sta_num_limt = (MACID_NUM_SW_LIMIT-CONFIG_LIMITED_AP_NUM-1);
#else
	u8 sta_num_limt = CONFIG_LIMITED_STA_NUM;
#endif

	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		if (!rtw_is_adapter_up(iface))
			continue;
		up_if_num++;
	}
	sta_num = NUM_STA - pstapriv->pfree_sta_queue->qlen - up_if_num;
	if(sta_num < sta_num_limt){
		return true;
	}else{
		RTW_PRINT("%s : reject Auth request since assoc cnt %d reach max %d\n",
			__func__, sta_num, sta_num_limt);
		return false;
	}
}
unsigned int OnAuth(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_AP_MODE
	unsigned int	auth_mode, seq, ie_len;
	unsigned char	*sa, *p;
	u16	algorithm;
	int	status;
	struct	sta_info	*pstat = NULL;
	struct	sta_priv *pstapriv = &padapter->stapriv;
	struct security_priv *psecuritypriv = &padapter->securitypriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint len = precv_frame->u.hdr.len;
	struct rx_pkt_attrib *prxattrib = &precv_frame->u.hdr.attrib;
	u8 offset = 0;
	u8 offload_cfg80211 = 0;

#ifdef RTW_WKARD_REDUCE_CONNECT_LOG
	if(!padapter->vw_enable)
#endif
	{
		RTW_PRINT(FUNC_ADPT_FMT" sa="MAC_FMT"\n", FUNC_ADPT_ARG(padapter), MAC_ARG(get_addr2_ptr(pframe)));
	}

#ifdef CONFIG_CONCURRENT_MODE
	if (MLME_IN_AP_STATE(pmlmeinfo) &&
	    rtw_mi_buddy_check_fwstate(padapter, WIFI_UNDER_LINKING | WIFI_UNDER_SURVEY)) {
		/* don't process auth request; */
		return _SUCCESS;
	}
#endif /* CONFIG_CONCURRENT_MODE */

	if (!MLME_IN_AP_STATE(pmlmeinfo))
		return _FAIL;

	if (!MLME_IS_ASOC(padapter))
		return _SUCCESS;

	if(auth_check_assoc_sta_num(padapter) == false){
		return _FAIL;
	}

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, get_addr2_ptr(pframe), 0, "Authentication", (pframe+WLAN_HDR_A3_LEN), (len-WLAN_HDR_A3_LEN));
#endif

#ifdef CONFIG_RTW_MBO
	/* AP is under BSS termination duration*/
	if (pmlmepriv->mbopriv.bss_termination_phase == BSS_TERMINATION_DUR) {
		RTW_INFO("%s : reject Auth request since AP is under BSS termination duration\n",
			__func__);
		return _FAIL;
	}
#endif

#if defined(CONFIG_IOCTL_CFG80211) && defined(CONFIG_RTW_MESH)
	if (MLME_IS_MESH(padapter))
		return rtw_mesh_on_auth(padapter, precv_frame);
#endif

	sa = get_addr2_ptr(pframe);

	if((padapter->registrypriv.wifi_mib.sta_asoc_rssi_th) &&
		(precv_frame->u.hdr.attrib.phy_info.signal_strength) &&
		padapter->registrypriv.wifi_mib.sta_asoc_rssi_th > precv_frame->u.hdr.attrib.phy_info.signal_strength){
		RTW_PRINT("%s : refused sa "MAC_FMT", because rssi(%d) lower than rssi_th(%d)!\n",
			__func__, MAC_ARG(sa), precv_frame->u.hdr.attrib.phy_info.signal_strength,
			padapter->registrypriv.wifi_mib.sta_asoc_rssi_th);
		return _FAIL;
	}

	auth_mode = psecuritypriv->dot11AuthAlgrthm;

	if (GetPrivacy(pframe)) {
		u8	*iv;
		struct rx_pkt_attrib	*prxattrib = &(precv_frame->u.hdr.attrib);

		prxattrib->hdrlen = WLAN_HDR_A3_LEN;
		prxattrib->encrypt = _WEP40_;

		iv = pframe + prxattrib->hdrlen;
		prxattrib->key_index = ((iv[3] >> 6) & 0x3);

		prxattrib->iv_len = 4;
		prxattrib->icv_len = 4;

		rtw_wep_decrypt(padapter, (u8 *)precv_frame);

		offset = 4;
	}

	algorithm = le16_to_cpu(*(u16 *)((SIZE_PTR)pframe + WLAN_HDR_A3_LEN + offset));
	seq	= le16_to_cpu(*(u16 *)((SIZE_PTR)pframe + WLAN_HDR_A3_LEN + offset + 2));

	RTW_INFO("auth alg=%x, seq=%X\n", algorithm, seq);

	if (rtw_check_invalid_mac_address(sa, _FALSE)){
		RTW_INFO("%s : reject invalid AUTH-req "MAC_FMT"\n",
			__func__, MAC_ARG(get_addr2_ptr(pframe)));
		return _FAIL;
	}

#if defined(CONFIG_VW_REFINE) || defined(CONFIG_ONE_TXQ)
	if (0)
#endif
	{
		if(rtw_defs_attack_chk(padapter))  {
			struct sta_info *_psta;
			_psta = rtw_get_stainfo(pstapriv, sa);
			if ((_psta == NULL) || !(_psta->state & WIFI_FW_ASSOC_SUCCESS)) {
				status = _STATS_REFUSED_TEMPORARILY_;
				RTW_ERR("%s : refused temporarily for sa "MAC_FMT" !\n", __func__, MAC_ARG(sa));
#ifdef CTC_WIFI_DIAG
				ctcwifi_assoc_err(padapter, sa, "Authentication failed [refused temporarily]\n");
#endif
				goto auth_fail;
			}
		}

		if (rtw_ap_linking_test_force_auth_fail()) {
			status = rtw_ap_linking_test_force_auth_fail();
			RTW_INFO(FUNC_ADPT_FMT" force auth fail with status:%u\n"
				, FUNC_ADPT_ARG(padapter), status);
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, sa, "Authentication failed [force auth fail]\n");
#endif
			goto auth_fail;
		}
	}

	if ((auth_mode == 2) && (algorithm != WLAN_AUTH_SAE) &&
		#ifdef CONFIG_RTW_80211R
		(algorithm != WLAN_AUTH_FT) &&
		#endif
	    (psecuritypriv->dot11PrivacyAlgrthm != _WEP40_) &&
	    (psecuritypriv->dot11PrivacyAlgrthm != _WEP104_))
		auth_mode = 0;

	if ((algorithm > 0 && auth_mode == 0) ||	/* rx a shared-key auth but shared not enabled */
	    (algorithm == 0 && auth_mode == 1)) {	/* rx a open-system auth but shared-key is enabled */
		RTW_INFO("auth rejected due to bad alg [alg=%d, auth_mib=%d] %02X%02X%02X%02X%02X%02X\n",
			algorithm, auth_mode, sa[0], sa[1], sa[2], sa[3], sa[4], sa[5]);

		status = _STATS_NO_SUPP_ALG_;
		offload_cfg80211 = 1;

#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, sa, "Authentication failed [auth rejected due to bad alg, alg=%d, auth_mib=%d]\n", algorithm, auth_mode);
#endif
		goto auth_fail;
	}

#if CONFIG_RTW_MACADDR_ACL
	if (rtw_access_ctrl(padapter, sa) == _FALSE) {
		status = _STATS_UNABLE_HANDLE_STA_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, sa, "Rejected by blacklist [auth abort because ACL!]\n");
#endif
#ifdef RTK_WLAN_EVENT_INDICATE
		rtk_wlan_event_indicate(padapter->pnetdev->name, WIFI_ACL_EVENT, sa, 0);
#endif
		goto auth_fail;
	}
#endif

#ifdef CONFIG_WLAN_MANAGER
	{
		u8 rssi = precv_frame->u.hdr.attrib.phy_info.signal_strength;
		rtw_netlink_send_frame_rpt_msg(padapter, WIFI_AUTH, get_sa(pframe), rssi);
	}
#endif

	pstat = rtw_get_stainfo(pstapriv, sa);
	if (pstat == NULL) {

		/* allocate a new one */
		RTW_INFO("going to alloc stainfo for sa="MAC_FMT"\n",  MAC_ARG(sa));

		//pstat = rtw_alloc_stainfo_sw(pstapriv, sa);
		pstat = rtw_alloc_stainfo(pstapriv, sa, PHL_CMD_DIRECTLY);



		if (pstat == NULL) {
			RTW_INFO(" Exceed the upper limit of supported clients...\n");
			status = _STATS_UNABLE_HANDLE_STA_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, sa, "Rejected by STA limitation [Exceed the upper limit of supported clients...]\n");
#endif
			goto auth_fail;
		}

#ifdef TX_BEAMFORMING
		pstat->phl_sta->is_zld_exist_csi = false;
		pstat->phl_sta->hal_sta->stbc_info.stbc_disable = false;
		ATOMIC_SET(&pstat->phl_sta->wd_stbc_cnt, false);
		ATOMIC_SET(&pstat->phl_sta->already_inform_txbf_to_fw, false);

#endif
		pstat->state = WIFI_FW_AUTH_NULL;
		pstat->auth_seq = 0;

#ifdef CONFIG_IOCTL_CFG80211
		if (pstat->pcommit) {
			rtw_mfree(pstat->pcommit, pstat->commit_len);
			pstat->pcommit = NULL;
			pstat->commit_len = 0;
		}
#endif
		/* pstat->flags = 0; */
		/* pstat->capability = 0; */
	} else {
#ifdef CONFIG_IOCTL_CFG80211
		if (pstat->state & WIFI_ASOC_STATE) {
			if (pstat->pcommit) {
				rtw_mfree(pstat->pcommit, pstat->commit_len);
				pstat->pcommit = NULL;
				pstat->commit_len = 0;
			}
		}
#endif
#ifdef CONFIG_IEEE80211W
		if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
			|| !(pstat->flags & WLAN_STA_MFP))
#endif /* CONFIG_IEEE80211W */
		{

			if (pstat->state & WIFI_ASOC_STATE)
				rtw_init_stainfo(padapter, pstat);

			_rtw_spinlock_bh(&pstapriv->asoc_list_lock);
			if (rtw_is_list_empty(&pstat->asoc_list) == _FALSE) {
				rtw_list_delete(&pstat->asoc_list);
				pstapriv->asoc_list_cnt--;
				#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
				if (pstat->tbtx_enable)
					pstapriv->tbtx_asoc_list_cnt--;
				#endif
				if (pstat->expire_to > 0)
					;/* TODO: STA re_auth within expire_to */
			}
			_rtw_spinunlock_bh(&pstapriv->asoc_list_lock);

			if (seq == 1)
				; /* TODO: STA re_auth and auth timeout */

			if (pstat->state & WIFI_DELETE_STATE) {
				RTW_PRINT("[%s] This station info is going to be Deleted..\n", __func__);
				pstat->auth_seq = 2;
				status = _STATS_OUT_OF_AUTH_SEQ_;
				issue_auth(padapter, pstat, (unsigned short)status);
				return _FAIL;
			}
		}
	}

#ifdef CONFIG_IEEE80211W
	if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
		|| !(pstat->flags & WLAN_STA_MFP))
#endif /* CONFIG_IEEE80211W */
	{
		_rtw_spinlock_bh(&pstapriv->auth_list_lock);
		if (rtw_is_list_empty(&pstat->auth_list)) {

			rtw_list_insert_tail(&pstat->auth_list, &pstapriv->auth_list);
			pstapriv->auth_list_cnt++;
		}
		_rtw_spinunlock_bh(&pstapriv->auth_list_lock);
	}

	if (pstat->auth_seq == 0)
		pstat->expire_to = pstapriv->auth_to;

#ifdef CONFIG_IOCTL_CFG80211
	if (GET_CFG80211_REPORT_MGMT(adapter_wdev_data(padapter), IEEE80211_STYPE_AUTH) == _TRUE) {
		if ((algorithm == WLAN_AUTH_SAE) &&
			(auth_mode == dot11AuthAlgrthm_8021X)) {
			pstat->authalg = algorithm;
			pstat->expire_to = 40; /* SAE-4.2.3 */

			rtw_cfg80211_rx_mframe(padapter, precv_frame, NULL);
			return _SUCCESS;
		}
		#ifdef CONFIG_RTW_80211R
		else if (rtw_ft_enable(padapter) && (algorithm == WLAN_AUTH_FT)) {
			RTW_PRINT("[FT] recv ft-auth-req (" MAC_FMT "), offload to hostapd\n", MAC_ARG(sa));
			pstat->ft_roaming = _TRUE;
			pstat->state &= ~WIFI_FW_AUTH_NULL;
			pstat->state |= WIFI_FW_AUTH_SUCCESS;
			pstat->expire_to = pstapriv->assoc_to;
			pstat->authalg = algorithm;
			pstat->auth_seq = seq + 1;
			pstat->ft_support = _TRUE;

			rtw_cfg80211_rx_mframe(padapter, precv_frame, NULL);
			return _SUCCESS;
		}
		#endif
	}
#endif /* CONFIG_IOCTL_CFG80211 */

	if ((pstat->auth_seq + 1) != seq) {
		RTW_INFO("(1)auth rejected because out of seq [rx_seq=%d, exp_seq=%d]!\n",
			 seq, pstat->auth_seq + 1);
		status = _STATS_OUT_OF_AUTH_SEQ_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Authentication failed [auth rejected because out of seq rx_seq=%d, exp_seq=%d]\n", seq, pstat->auth_seq+1);
#endif
		goto auth_fail;
	}
#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
	if (algorithm == 0 && (auth_mode == 0 || auth_mode == 2 || auth_mode == 3 || auth_mode == dot11AuthAlgrthm_WAPI))
#else
	if (algorithm == 0 && (auth_mode == 0 || auth_mode == 2 || auth_mode == 3))
#endif
	{
		if (seq == 1) {
#ifdef CONFIG_IEEE80211W
			if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
				|| !(pstat->flags & WLAN_STA_MFP))
#endif /* CONFIG_IEEE80211W */
			{
				pstat->state &= ~WIFI_FW_AUTH_NULL;
				pstat->state |= WIFI_FW_AUTH_SUCCESS;
				pstat->expire_to = pstapriv->assoc_to;
			}
			pstat->authalg = algorithm;
		} else {
			RTW_INFO("(2)auth rejected because out of seq [rx_seq=%d, exp_seq=%d]!\n",
				 seq, pstat->auth_seq + 1);
			status = _STATS_OUT_OF_AUTH_SEQ_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Authentication failed [auth rejected because out of seq rx_seq=%d, exp_seq=%d]\n", seq, pstat->auth_seq+1);
#endif
			goto auth_fail;
		}
	} else { /* shared system or auto authentication */
		if (seq == 1) {
			/* prepare for the challenging txt... */

			/* get_random_bytes((void *)pstat->chg_txt, 128); */ /* TODO: */
			_rtw_memset((void *)pstat->chg_txt, 78, 128);
#ifdef CONFIG_IEEE80211W
			if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
				|| !(pstat->flags & WLAN_STA_MFP))
#endif /* CONFIG_IEEE80211W */
			{
				pstat->state &= ~WIFI_FW_AUTH_NULL;
				pstat->state |= WIFI_FW_AUTH_STATE;
			}
			pstat->authalg = algorithm;
			pstat->auth_seq = 2;
		} else if (seq == 3) {
			/* checking for challenging txt... */
			RTW_INFO("checking for challenging txt...\n");

			p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + 4 + _AUTH_IE_OFFSET_ , _CHLGETXT_IE_, (int *)&ie_len,
				len - WLAN_HDR_A3_LEN - _AUTH_IE_OFFSET_ - 4);

			if ((p == NULL) || (ie_len <= 0)) {
				RTW_INFO("auth rejected because challenge failure!(1)\n");
				status = _STATS_CHALLENGE_FAIL_;
#ifdef CTC_WIFI_DIAG
				ctcwifi_assoc_err(padapter, sa, "Authentication failed [auth rejected because challenge failure!]\n");
#endif
				goto auth_fail;
			}

			if (_rtw_memcmp((void *)(p + 2), pstat->chg_txt, 128)) {
#ifdef CONFIG_IEEE80211W
				if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
					|| !(pstat->flags & WLAN_STA_MFP))
#endif /* CONFIG_IEEE80211W */
				{
					pstat->state &= (~WIFI_FW_AUTH_STATE);
					pstat->state |= WIFI_FW_AUTH_SUCCESS;
					/* challenging txt is correct... */
					pstat->expire_to =  pstapriv->assoc_to;
				}
			} else {
				RTW_INFO("auth rejected because challenge failure!\n");
				status = _STATS_CHALLENGE_FAIL_;
#ifdef CTC_WIFI_DIAG
				ctcwifi_assoc_err(padapter, sa, "Authentication failed [auth rejected because challenge failure!]\n");
#endif
				goto auth_fail;
			}
		} else {
			RTW_INFO("(3)auth rejected because out of seq [rx_seq=%d, exp_seq=%d]!\n",
				 seq, pstat->auth_seq + 1);
			status = _STATS_OUT_OF_AUTH_SEQ_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Authentication failed [auth rejected because out of seq rx_seq=%d, exp_seq=%d]\n", seq, pstat->auth_seq+1);
#endif
			goto auth_fail;
		}
	}

	/* Now, we are going to issue_auth... */
	pstat->auth_seq = seq + 1;

	/* Update STA's association RSSI from packet's PHY info */
	if (prxattrib->phy_info.signal_strength != 0
		/* && pstat->phl_sta->hal_sta->rssi_stat.assoc_rssi == 0 */) {
		u8 auth_rssi = prxattrib->phy_info.signal_strength;
		/*
		if (auth_rssi < 60)
			auth_rssi = 60;
		*/
		RTW_INFO(ADPT_FMT " apply %d (%d) assoc RSSI from auth req for \""MAC_FMT"\"\n",
			ADPT_ARG(padapter), auth_rssi, prxattrib->phy_info.signal_strength, MAC_ARG(sa));
		pstat->phl_sta->hal_sta->rssi_stat.assoc_rssi = auth_rssi;
	}

#ifdef CONFIG_NATIVEAP_MLME
	issue_auth(padapter, pstat, (unsigned short)(_STATS_SUCCESSFUL_));
#endif

	if ((pstat->state & WIFI_FW_AUTH_SUCCESS) || (pstat->state & WIFI_FW_ASSOC_SUCCESS))
		pstat->auth_seq = 0;


	return _SUCCESS;

auth_fail:

#ifdef CONFIG_RTW_MULTI_AP_R2
	//Client Failed Connection message
	if(GET_PRIMARY_ADAPTER(padapter)->registrypriv.wifi_mib.multiap_report_fail_assoc)
		core_map_send_sta_failed_conn_event(pstat, status, _RSON_RESERVED_);
#endif

#ifdef CONFIG_IOCTL_CFG80211
	if (GET_CFG80211_REPORT_MGMT(adapter_wdev_data(padapter), IEEE80211_STYPE_AUTH) == _TRUE
		&& offload_cfg80211 == 1) {
		rtw_cfg80211_rx_mframe(padapter, precv_frame, NULL);
	}
#endif /* CONFIG_IOCTL_CFG80211 */

	if (pstat) {
		pstat->auth_seq = 2;
		#ifdef CONFIG_NATIVEAP_MLME
		issue_auth(padapter, pstat, (unsigned short)status);
		#endif
		rtw_free_stainfo(padapter , pstat);
	}

#endif
	return _FAIL;

}

unsigned int OnAuthClient(_adapter *padapter, union recv_frame *precv_frame)
{
	unsigned int	seq, len, status, algthm, offset;
	unsigned char	*p;
	unsigned int	go2asoc = 0;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint pkt_len = precv_frame->u.hdr.len;

	RTW_INFO("%s\n", __FUNCTION__);

#ifdef CONFIG_IOCTL_CFG80211
	if (GET_CFG80211_REPORT_MGMT(adapter_wdev_data(padapter), IEEE80211_STYPE_AUTH) == _TRUE) {
		if (rtw_sec_chk_auth_type(padapter, MLME_AUTHTYPE_SAE)) {
			if (rtw_cached_pmkid(padapter, get_my_bssid(&pmlmeinfo->network)) != -1) {
				RTW_INFO("SAE: PMKSA cache entry found\n");
				goto normal;
			}
			rtw_cfg80211_rx_mframe(padapter, precv_frame, NULL);
			return _SUCCESS;
		}
	}

normal:
#endif /* CONFIG_IOCTL_CFG80211 */

	/* check A1 matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), get_da(pframe), ETH_ALEN))
		return _SUCCESS;

	if (!(pmlmeinfo->state & WIFI_FW_AUTH_STATE) || pmlmeext->join_abort)
		return _SUCCESS;

	offset = (GetPrivacy(pframe)) ? 4 : 0;

	algthm	= le16_to_cpu(*(unsigned short *)((SIZE_PTR)pframe + WLAN_HDR_A3_LEN + offset));
	seq	= le16_to_cpu(*(unsigned short *)((SIZE_PTR)pframe + WLAN_HDR_A3_LEN + offset + 2));
	status	= le16_to_cpu(*(unsigned short *)((SIZE_PTR)pframe + WLAN_HDR_A3_LEN + offset + 4));

	if (status != 0) {
		RTW_INFO("clnt auth fail, status: %d\n", status);
		if (status == 13) { /* && pmlmeinfo->auth_algo == dot11AuthAlgrthm_Auto) */
			if (pmlmeinfo->auth_algo == dot11AuthAlgrthm_Shared)
				pmlmeinfo->auth_algo = dot11AuthAlgrthm_Open;
			else
				pmlmeinfo->auth_algo = dot11AuthAlgrthm_Shared;
			/* pmlmeinfo->reauth_count = 0; */
		}

		pmlmeinfo->auth_status = status;
		set_link_timer(pmlmeext, 1);
		goto authclnt_fail;
	}

	if (seq == 2) {
		if (pmlmeinfo->auth_algo == dot11AuthAlgrthm_Shared) {
			/* legendary shared system */
			p = rtw_get_ie(pframe + WLAN_HDR_A3_LEN + _AUTH_IE_OFFSET_, _CHLGETXT_IE_, (int *)&len,
				pkt_len - WLAN_HDR_A3_LEN - _AUTH_IE_OFFSET_);

			if (p == NULL) {
				/* RTW_INFO("marc: no challenge text?\n"); */
				goto authclnt_fail;
			}
			if(sizeof(pmlmeinfo->chg_txt) < len)
				goto authclnt_fail;
			_rtw_memcpy((void *)(pmlmeinfo->chg_txt), (void *)(p + 2), len);
			pmlmeinfo->auth_seq = 3;
			issue_auth(padapter, NULL, 0);
			set_link_timer(pmlmeext, REAUTH_TO);

			return _SUCCESS;
		} else {
			/* open, or 802.11r FTAA system */
			go2asoc = 1;
		}
	} else if (seq == 4) {
		if (pmlmeinfo->auth_algo == dot11AuthAlgrthm_Shared)
			go2asoc = 1;
		else
			goto authclnt_fail;
	} else {
		/* this is also illegal */
		/* RTW_INFO("marc: clnt auth failed due to illegal seq=%x\n", seq); */
		goto authclnt_fail;
	}

	if (go2asoc) {
#ifdef CONFIG_RTW_80211R
		if (rtw_ft_update_auth_rsp_ies(padapter, pframe, pkt_len))
			return _SUCCESS;
#endif
		RTW_PRINT("auth success, start assoc\n");
		start_clnt_assoc(padapter);
		return _SUCCESS;
	}

authclnt_fail:

	/* pmlmeinfo->state &= ~(WIFI_FW_AUTH_STATE); */

	return _FAIL;

}

static u8 rtw_deny_legacy_sta(_adapter *padapter, struct sta_info *pstat)
{
	struct registry_priv *pregpriv = &padapter->registrypriv;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	u8 res = _FALSE;

	sta_info_update(padapter, pstat);
	rtw_ap_set_sta_wmode(padapter, pstat);

	if (pmlmeext->cur_wireless_mode == WLAN_MD_11BGAX) {
		if ((pregpriv->deny_legacy == WLAN_MD_11BG) &&
			!(pstat->phl_sta->wmode & WLAN_MD_11N) && !(pstat->phl_sta->wmode & WLAN_MD_11AX))
			/* 2.4G N+AX */
			res = _TRUE;
		else if ((pregpriv->deny_legacy == WLAN_MD_11BGN) &&
				 !(pstat->phl_sta->wmode & WLAN_MD_11AX))
			/* 2.4G AX only */
			res = _TRUE;
		else if ((pregpriv->deny_legacy == WLAN_MD_11B) &&
				 (pstat->phl_sta->wmode == WLAN_MD_11B))
			/* 2.4G G+N+AX */
			res = _TRUE;
	} else if (pmlmeext->cur_wireless_mode == WLAN_MD_11BGN) {
		if ((pregpriv->deny_legacy == WLAN_MD_11BG) &&
			!(pstat->phl_sta->wmode & WLAN_MD_11N))
			/* 2.4G N only */
			res = _TRUE;
		else if ((pregpriv->deny_legacy == WLAN_MD_11B) &&
				 (pstat->phl_sta->wmode == WLAN_MD_11B))
			/* 2.4G G+N */
			res = _TRUE;
	} else if (pmlmeext->cur_wireless_mode == WLAN_MD_11BG) {
		if ((pregpriv->deny_legacy == WLAN_MD_11B) &&
			(pstat->phl_sta->wmode == WLAN_MD_11B))
			/* 2.4G G only */
			res = _TRUE;
	} else if (pmlmeext->cur_wireless_mode == WLAN_MD_11A_AX) {
		if ((pregpriv->deny_legacy == WLAN_MD_11AN) &&
			!(pstat->phl_sta->wmode & WLAN_MD_11AC) && !(pstat->phl_sta->wmode & WLAN_MD_11AX))
			/* 5G AC+AX */
			res = _TRUE;
		else if ((pregpriv->deny_legacy == WLAN_MD_11ANAC) &&
				 !(pstat->phl_sta->wmode & WLAN_MD_11AX))
			/* 5G AX only*/
			res = _TRUE;
		else if ((pregpriv->deny_legacy == WLAN_MD_11A) &&
				 (pstat->phl_sta->wmode == WLAN_MD_11A))
			/* 5G N+AC+AX */
			res = _TRUE;
	} else if (pmlmeext->cur_wireless_mode == WLAN_MD_11A_AC) {
		if ((pregpriv->deny_legacy == WLAN_MD_11AN) &&
			!(pstat->phl_sta->wmode & WLAN_MD_11AC))
			/* 5G AC only */
			res = _TRUE;
		else if ((pregpriv->deny_legacy == WLAN_MD_11A) &&
				 (pstat->phl_sta->wmode == WLAN_MD_11A))
			/* 5G N+AC */
			res = _TRUE;
	} else if (pmlmeext->cur_wireless_mode == WLAN_MD_11AN) {
		if ((pregpriv->deny_legacy == WLAN_MD_11A) &&
			(pstat->phl_sta->wmode == WLAN_MD_11A))
			/* 5G N only */
			res = _TRUE;
	}

return res;
}

#ifdef CONFIG_VW_REFINE
u8 continus_sta_num = 0;
u8 min = 0xff;
u8 max = 0;
extern void rtw_core_set_gt3(_adapter *padapter, u8 enable, long timeout);

void rtw_parse_vendor_vw_sta(_adapter *padapter, struct sta_info *pstat)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	extern u8 phl_log_level;
	u8 tx_mode_flag = 0;

#if defined(CONFIG_AX_SHARE_XTAL) && defined(CONFIG_RTL8832BR)
	struct rtw_proc_cmd cmd;
	u8 out_buf[256];
#endif

	/* special handle for cmcc spirent */
	if (pstat->vendor == HT_IOT_PEER_SPIRENT) {
		//continus_sta_addr[continus_sta_num] = pstat->phl_sta->mac_addr[5];
		continus_sta_num++;

		if(pstat->phl_sta->mac_addr[5] <= min)
				min = pstat->phl_sta->mac_addr[5];
			
		if(pstat->phl_sta->mac_addr[5] >= max)
			max = pstat->phl_sta->mac_addr[5];
	}

	if(continus_sta_num >= 5) {
		if (max == (min+continus_sta_num-1)) {
			tx_mode_flag = 1;
		}
	}

	if(!padapter->registrypriv.wifi_mib.tx_mode_auto)
		return;

	if ((pstat->vendor == HT_IOT_PEER_VERIWAVE || 
		(pstat->vendor == HT_IOT_PEER_SPIRENT && tx_mode_flag == 1)) &&
		(padapter->vw_enable == 0 || padapter->vw_enable == 2)) {

		if (padapter->vw_enable == 0)
			padapter->vw_enable = 1;

		if (pstat->vendor == HT_IOT_PEER_SPIRENT)
			padapter->tc_enable = 1;

		if (padapter->dvobj->tx_mode == 0) {
			padapter->dvobj->tx_mode = 1;

			if (padapter->vw_enable == 2)
				padapter->sta_sn_gap = 256;
			else
				padapter->sta_sn_gap = 127;

			rtw_core_set_gt3(padapter, 1, 1000);
			rtw_phl_set_one_txring_mode(dvobj->phl, 1);
		}
		if(phl_log_level) {
			phl_log_level = 0;
			RTW_PRINT("under vw testing, set phl_log_level to 0\n");
		}

#if defined(CONFIG_AX_SHARE_XTAL) && defined(CONFIG_RTL8832BR)
		cmd.in_type = RTW_ARG_TYPE_ARRAY;
		cmd.in_cnt_len = 3;
		strncpy(cmd.in.vector[0], "ability", 7);
		strncpy(cmd.in.vector[1], "6", 1);
		strncpy(cmd.in.vector[2], "1", 1);

		rtw_phl_proc_cmd(GET_HAL_INFO(adapter_to_dvobj(padapter)),
				RTW_PROC_CMD_BB, &cmd, out_buf, 256);

		RTW_PRINT("%s\n", out_buf);
#endif
	}
}
#endif

#if defined (CONFIG_RTL_EXT_PORT_SUPPORT)
extern int rtl_wifi_fdb_add_hook(const unsigned char *addr);
extern void update_hw_l2table(const char *srcName,const unsigned char *addr);
#endif
unsigned int OnAssocReq(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_AP_MODE
	u16 listen_interval;
	struct rtw_ieee802_11_elems elems;
	struct sta_info	*pstat;
	unsigned char		reassoc, *pos;
	int		left;
	unsigned short		status = _STATS_SUCCESSFUL_;
	unsigned short		frame_type, ie_offset = 0;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	WLAN_BSSID_EX	*cur = &(pmlmeinfo->network);
	struct sta_priv *pstapriv = &padapter->stapriv;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint pkt_len = precv_frame->u.hdr.len;
#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
	u8 p2p_status_code = P2P_STATUS_SUCCESS;
	u8 *p2pie;
	u32 p2pielen = 0;
#endif /* CONFIG_P2P */
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	u8 sta_tbtx_enable = _FALSE;
#endif
#ifdef CONFIG_RTW_MULTI_AP
	_adapter *primary_adapter = GET_PRIMARY_ADAPTER(padapter);
#endif
	struct registry_priv *pregpriv = &padapter->registrypriv;

#ifdef RTW_WKARD_REDUCE_CONNECT_LOG
	if(!padapter->vw_enable)
#endif
	{
		RTW_PRINT(FUNC_ADPT_FMT" sa="MAC_FMT"\n", FUNC_ADPT_ARG(padapter), MAC_ARG(get_addr2_ptr(pframe)));
	}

#ifdef CONFIG_CONCURRENT_MODE
	if (MLME_IN_AP_STATE(pmlmeinfo) &&
	    rtw_mi_buddy_check_fwstate(padapter, WIFI_UNDER_LINKING | WIFI_UNDER_SURVEY)) {
		/* don't process assoc request; */
		return _SUCCESS;
	}
#endif /* CONFIG_CONCURRENT_MODE */

	if (!MLME_IN_AP_STATE(pmlmeinfo))
		return _FAIL;

	if (rtw_check_invalid_mac_address(get_addr2_ptr(pframe), _FALSE)) {
		RTW_INFO("%s : reject invalid ASSOC-req "MAC_FMT"\n",
			__func__, MAC_ARG(get_addr2_ptr(pframe)));
		return _FAIL;
	}
#ifdef CONFIG_RTW_MBO
	/* AP is under BSS termination duration*/
	if (pmlmepriv->mbopriv.bss_termination_phase == BSS_TERMINATION_DUR) {
		RTW_INFO("%s : reject ASSOC-req "MAC_FMT" since AP is under BSS termination duration\n",
			__func__, MAC_ARG(get_addr2_ptr(pframe)));
		return _FAIL;
	}
#endif

	frame_type = get_frame_sub_type(pframe);
	if (frame_type == WIFI_ASSOCREQ) {
		reassoc = 0;
		ie_offset = _ASOCREQ_IE_OFFSET_;
	} else { /* WIFI_REASSOCREQ */
		reassoc = 1;
		ie_offset = _REASOCREQ_IE_OFFSET_;
	}


	if (pkt_len < IEEE80211_3ADDR_LEN + ie_offset) {
		RTW_INFO("handle_assoc(reassoc=%d) - too short payload (len=%lu)"
			 "\n", reassoc, (unsigned long)pkt_len);
		return _FAIL;
	}

	if((padapter->registrypriv.wifi_mib.sta_asoc_rssi_th) &&
		(precv_frame->u.hdr.attrib.phy_info.signal_strength) &&
		padapter->registrypriv.wifi_mib.sta_asoc_rssi_th > precv_frame->u.hdr.attrib.phy_info.signal_strength){
		RTW_PRINT("%s : refused sa "MAC_FMT", because rssi(%d) lower than rssi_th(%d)!\n",
			__func__, MAC_ARG(get_addr2_ptr(pframe)), precv_frame->u.hdr.attrib.phy_info.signal_strength,
			padapter->registrypriv.wifi_mib.sta_asoc_rssi_th);
		return _FAIL;
	}

	pstat = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
	if (pstat == (struct sta_info *)NULL) {
		status = _RSON_CLS2_;
		goto asoc_class2_error;
	}

#ifdef RTW_PHL_TEST_FPGA
	DBGP(" [%s][%d] force assoc \n", __FUNCTION__, __LINE__);
	pstat->state = WIFI_ASOC_STATE;
	pstat->state |= WIFI_FW_ASSOC_SUCCESS;
	issue_asocrsp(padapter, status, pstat, WIFI_ASSOCRSP);
	return _SUCCESS;
#endif

	if (pstat->authalg == WLAN_AUTH_SAE) {
		/* WPA3-SAE */
		if (((pstat->state) & WIFI_FW_AUTH_NULL)) {
			/* TODO:
			   Queue AssocReq and Proccess
			   by external auth trigger. */
			RTW_INFO("%s: wait external auth trigger\n", __func__);
			return _SUCCESS;
		}
	}

#if defined(CONFIG_IEEE80211W) && defined(CONFIG_IOCTL_CFG80211)
	if (pstat->bpairwise_key_installed == _TRUE && (pstat->flags & WLAN_STA_MFP)
#ifdef CONFIG_RTW_80211R
		&& (pstat->ft_roaming != _TRUE)
#endif
	) {
		_rtw_spinlock_bh(&pstat->lock);
		if (pstat->passoc_req) {
			rtw_mfree(pstat->passoc_req, pstat->assoc_req_len);
			pstat->passoc_req = NULL;
			pstat->assoc_req_len = 0;
		}
		pstat->passoc_req =  rtw_zmalloc(pkt_len);
		if (pstat->passoc_req) {
			_rtw_memcpy(pstat->passoc_req, pframe, pkt_len);
			pstat->assoc_req_len = pkt_len;
		}
		_rtw_spinunlock_bh(&pstat->lock);
		report_add_sta_event(padapter, pstat->phl_sta->mac_addr);
		return _SUCCESS;
	}
#endif
	/* check if this stat has been successfully authenticated/assocated */
	if (!((pstat->state) & WIFI_FW_AUTH_SUCCESS)) {
		if (!((pstat->state) & WIFI_FW_ASSOC_SUCCESS)) {
			status = _RSON_CLS2_;
			goto asoc_class2_error;
		} else {
			pstat->state &= (~WIFI_FW_ASSOC_SUCCESS);
			pstat->state |= WIFI_FW_ASSOC_STATE;
		}
	} else {
		pstat->state &= (~WIFI_FW_AUTH_SUCCESS);
		pstat->state |= WIFI_FW_ASSOC_STATE;
	}

#ifdef CTC_WIFI_DIAG
	if (frame_type == WIFI_REASSOCREQ) {
		ctcwifi_diag_log(padapter, pstat->phl_sta->mac_addr, 0, "Reassociation Request", (pframe+WLAN_HDR_A3_LEN), (pkt_len-WLAN_HDR_A3_LEN));
	} else {
		ctcwifi_diag_log(padapter, pstat->phl_sta->mac_addr, 0, "Association Request", (pframe+WLAN_HDR_A3_LEN), (pkt_len-WLAN_HDR_A3_LEN));
	}
#endif
	if (frame_type == WIFI_REASSOCREQ)
		pstat->assoc_type = WIFI_REASSOCRSP;
	else
		pstat->assoc_type = WIFI_ASSOCRSP;

#if 0/* todo:tkip_countermeasures */
	if (hapd->tkip_countermeasures) {
		resp = WLAN_REASON_MICHAEL_MIC_FAILURE;
		goto fail;
	}
#endif
	/*GEORGIA_TODO_MOVE_CODE_TO_DBG_SYS*/
	if (rtw_ap_linking_test_force_asoc_fail()) {
		status = rtw_ap_linking_test_force_asoc_fail();
		RTW_INFO(FUNC_ADPT_FMT" force asoc fail with status:%u\n"
			, FUNC_ADPT_ARG(padapter), status);
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Authentication failed [force asoc fail]\n");
#endif
		goto OnAssocReqFail;
	}

	/* now parse all ieee802_11 ie to point to elems */
	left = pkt_len - (IEEE80211_3ADDR_LEN + ie_offset);
	pos = pframe + (IEEE80211_3ADDR_LEN + ie_offset);
	if (rtw_ieee802_11_parse_elems(pos, left, &elems, 1) == ParseFailed) {
		RTW_INFO("STA " MAC_FMT " sent invalid association request\n",
			 MAC_ARG(pstat->phl_sta->mac_addr));
		status = _STATS_FAILURE_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Authentication failed [AssocReq IE parse fail]\n");
#endif
		goto OnAssocReqFail;
	}

#ifdef CONFIG_RTW_MULTI_AP
	if (primary_adapter->multi_ap_mode & MAP_MODE_FRONT_AP) {
		if(rtw_blacklist_find_in_list(&padapter->black_list, get_addr2_ptr(pframe))) {
			status = _STATS_FAILURE_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Rejected by blacklist [auth abort by MULTI_AP]\n");
#endif
			goto OnAssocReqFail;
		}
	}
#endif

	rtw_ap_parse_sta_capability(padapter, pstat, pframe + WLAN_HDR_A3_LEN);
	rtw_ap_parse_sta_ext_capability(padapter, pstat, &elems);

	listen_interval = RTW_GET_LE16(pframe + WLAN_HDR_A3_LEN + 2);
#if 0/* todo: */
	/* check listen_interval */
	if (listen_interval > hapd->conf->max_listen_interval) {
		hostapd_logger(hapd, mgmt->sa, HOSTAPD_MODULE_IEEE80211,
			       HOSTAPD_LEVEL_DEBUG,
			       "Too large Listen Interval (%d)",
			       listen_interval);
		resp = WLAN_STATUS_ASSOC_DENIED_LISTEN_INT_TOO_LARGE;
		goto fail;
	}

	pstat->listen_interval = listen_interval;
#endif

	/* now we should check all the fields... */
	/* checking SSID */
	if (elems.ssid == NULL
		|| elems.ssid_len == 0
		|| elems.ssid_len != cur->Ssid.SsidLength
		|| _rtw_memcmp(elems.ssid, cur->Ssid.Ssid, cur->Ssid.SsidLength) == _FALSE
	) {
		status = _STATS_FAILURE_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Capability checking failed [SSID does not match]\n");
#endif
		goto OnAssocReqFail;
	}

	/* (Extended) Supported rates */
	status = rtw_ap_parse_sta_supported_rates(padapter, pstat
		, pframe + WLAN_HDR_A3_LEN + ie_offset, pkt_len - WLAN_HDR_A3_LEN - ie_offset);
	if (status != _STATS_SUCCESSFUL_) {
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Capability checking failed [Supported rates is wrong]\n");
#endif
		goto OnAssocReqFail;
	}

	/* check RSN/WPA/WPS */
	status = rtw_ap_parse_sta_security_ie(padapter, pstat, &elems);
	if (status != _STATS_SUCCESSFUL_) {
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Capability checking failed [Security IE is wrong]\n");
#endif
		goto OnAssocReqFail;
	}

	/* check if there is WMM IE & support WWM-PS */
	rtw_ap_parse_sta_wmm_ie(padapter, pstat
		, pframe + WLAN_HDR_A3_LEN + ie_offset, pkt_len - WLAN_HDR_A3_LEN - ie_offset);

#ifdef CONFIG_RTW_MULTI_AP
	if (primary_adapter->multi_ap_mode & MAP_MODE_FRONT_AP) {
		core_map_check_sta_ie(padapter, pstat, pos, left);
	}
#ifndef CONFIG_RTW_MULTI_AP_LOGO
	if((GET_MAP_BSS_TYPE(padapter) & MULTI_AP_BACKHAUL_BSS) &&
		!(GET_MAP_BSS_TYPE(padapter) & MULTI_AP_FRONTHAUL_BSS) &&
		!(pstat->flags & WLAN_STA_MULTI_AP_BACKHAUL_STA)) {
		RTW_PRINT("Reject connection between non multiap sta and only backhaul bss.\n");
		goto OnAssocReqFail;
	}
#endif
#endif

#ifdef CONFIG_RTS_FULL_BW
	/*check vendor IE*/
	rtw_parse_sta_vendor_ie_8812(padapter, pstat
		, pframe + WLAN_HDR_A3_LEN + ie_offset, pkt_len - WLAN_HDR_A3_LEN - ie_offset);
#endif/*CONFIG_RTS_FULL_BW*/

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	rtw_parse_vendor_ie(padapter, pstat, pframe,
		pframe + WLAN_HDR_A3_LEN + ie_offset, pkt_len - WLAN_HDR_A3_LEN - ie_offset);
#endif

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	if (elems.tbtx_cap && elems.tbtx_cap_len != 0) {
		if(rtw_is_tbtx_capabilty(elems.tbtx_cap, elems.tbtx_cap_len)) {
			sta_tbtx_enable = _TRUE;
		}
	}

#endif

#ifdef CONFIG_WLAN_MANAGER
	{
		u8 rssi = precv_frame->u.hdr.attrib.phy_info.signal_strength;
		rtw_netlink_send_frame_rpt_msg(padapter, WIFI_ASSOCREQ, get_sa(pframe), rssi);
		rtw_parse_opclass_ie(padapter, pstat, pframe,
			pframe + WLAN_HDR_A3_LEN + ie_offset, pkt_len - WLAN_HDR_A3_LEN - ie_offset);
		if(is_supported_24g(padapter->registrypriv.band_type))
			pstat->supported_band |= BAND_CAP_2G;
		else if(is_supported_5g(padapter->registrypriv.band_type))
			pstat->supported_band |= BAND_CAP_5G;
	}
#endif
#ifdef CONFIG_BAND_STEERING
	if (_band_steering_block_chk(padapter, get_sa(pframe))) {
		status = _STATS_REFUSED_TEMPORARILY_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Association ignored by band steering [block list check]\n");
#endif
		goto OnAssocReqFail;
	}
#endif
#ifdef RTW_BLOCK_STA_CONNECT
	if(block_sta_conn_chk(padapter, get_sa(pframe))){
		unsigned char *sa_t = get_sa(pframe);
		printk("(%s)block sta(%02x%02x%02x%02x%02x%02x) connect\n", __FUNCTION__,sa_t[0],sa_t[1],sa_t[2],sa_t[3],sa_t[4],sa_t[5]);
		status = _STATS_REFUSED_TEMPORARILY_;
		goto OnAssocReqFail;
	}
#endif

	rtw_ap_parse_sta_ht_ie(padapter, pstat, &elems);
	rtw_ap_parse_sta_vht_ie(padapter, pstat, &elems);
	rtw_ap_parse_sta_he_ie(padapter, pstat, &elems);

	if (pregpriv->deny_legacy && rtw_deny_legacy_sta(padapter, pstat)) {
		RTW_INFO("Deny legacy STA " MAC_FMT " association\n",
			 MAC_ARG(pstat->phl_sta->mac_addr));
		status = WLAN_STATUS_UNSPECIFIED_FAILURE;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Capability checking failed [Deny legacy STA association!]\n");
#endif
		goto OnAssocReqFail;
	}

	if (((pstat->flags & WLAN_STA_HT) || (pstat->flags & WLAN_STA_VHT) || (pstat->flags & WLAN_STA_HE)) &&
	    ((pstat->wpa2_pairwise_cipher & WPA_CIPHER_TKIP) ||
	     (pstat->wpa_pairwise_cipher & WPA_CIPHER_TKIP))) {

		RTW_INFO("HT/VHT/HE: " MAC_FMT " TKIP association\n", MAC_ARG(pstat->phl_sta->mac_addr));

		pstat->flags &= ~WLAN_STA_HT;
		pstat->flags &= ~WLAN_STA_VHT;
		pstat->flags &= ~WLAN_STA_HE;
#ifdef WIFI_LOGO_VHT_4_2_44
		if (padapter->mlmeextpriv.mlmext_info.is_VHT_4_2_44) {
			status = WLAN_STATUS_CAPS_UNSUPPORTED;
			RTW_INFO("HT/VHT/HE: " MAC_FMT " Deny TKIP association\n", MAC_ARG(pstat->phl_sta->mac_addr));
			goto OnAssocReqFail;
		}
#endif

	}

#ifdef CONFIG_P2P
	pstat->is_p2p_device = _FALSE;
	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
		p2pie = rtw_get_p2p_ie(pframe + WLAN_HDR_A3_LEN + ie_offset , pkt_len - WLAN_HDR_A3_LEN - ie_offset , NULL, &p2pielen);
		if (p2pie) {
			pstat->is_p2p_device = _TRUE;
			p2p_status_code = (u8)process_assoc_req_p2p_ie(pwdinfo, pframe, pkt_len, pstat);
			if (p2p_status_code > 0) {
				pstat->p2p_status_code = p2p_status_code;
				status = _STATS_CAP_FAIL_;
#ifdef CTC_WIFI_DIAG
				ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Capability checking failed [P2P IE is wrong]\n");
#endif
				goto OnAssocReqFail;
			}
		}
#ifdef CONFIG_WFD
		rtw_process_wfd_ies(padapter, pframe + WLAN_HDR_A3_LEN + ie_offset, pkt_len - WLAN_HDR_A3_LEN - ie_offset, __func__);
#endif
	}
	pstat->p2p_status_code = p2p_status_code;
#endif /* CONFIG_P2P */

	/* TODO: identify_proprietary_vendor_ie(); */
	/* Realtek proprietary IE */
	/* identify if this is Broadcom sta */
	/* identify if this is ralink sta */
	/* Customer proprietary IE */

#ifdef CONFIG_RTW_80211K
	rtw_ap_parse_sta_rm_en_cap(padapter, pstat, &elems);
#endif

#ifdef CONFIG_RTW_MBO
	if (pmlmepriv->mbopriv.enable == _TRUE) {
		if(pmlmepriv->mbopriv.assoc_disallow != 0){
			RTW_INFO("Reject STA " MAC_FMT ":MBO association disallowed\n",
			 MAC_ARG(pstat->phl_sta->mac_addr));
			status = WLAN_STATUS_AP_UNABLE_TO_HANDLE_NEW_STA;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Capability checking failed [MBO association disallowed]\n");
#endif
			goto OnAssocReqFail;
		}
		rtw_ap_parse_sta_mbo_element(padapter, pstat,
						pframe + WLAN_HDR_A3_LEN + ie_offset,
						pkt_len - WLAN_HDR_A3_LEN - ie_offset);
	}
#endif /*CONFIG_RTW_MBO*/

#ifdef CONFIG_RTW_80211R
	if (elems.mdie && elems.mdie_len) {
		pstat->ft_support = _TRUE;
	}
#endif /* CONFIG_RTW_80211R */

	/* AID assignment */
	if (pstat->phl_sta->aid > 0)
		RTW_INFO(FUNC_ADPT_FMT" old AID=%d\n", FUNC_ADPT_ARG(padapter), pstat->phl_sta->aid);
	else {
		if (!rtw_aid_alloc(padapter, pstat)) {
			RTW_INFO(FUNC_ADPT_FMT" no room for more AIDs\n", FUNC_ADPT_ARG(padapter));
			status = WLAN_STATUS_AP_UNABLE_TO_HANDLE_NEW_STA;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Rejected by STA limitation [No room for more AIDs]\n");
#endif
			goto OnAssocReqFail;
		}
		RTW_INFO(FUNC_ADPT_FMT" allocate new AID=%d\n", FUNC_ADPT_ARG(padapter), pstat->phl_sta->aid);
	}

	pstat->state &= (~WIFI_FW_ASSOC_STATE);
	pstat->state |= WIFI_FW_ASSOC_SUCCESS;
	/* RTW_INFO("==================%s, %d,  (%x), bpairwise_key_installed=%d, MAC:"MAC_FMT"\n"
	, __func__, __LINE__, pstat->state, pstat->bpairwise_key_installed, MAC_ARG(pstat->phl_sta->mac_addr)); */
#ifdef CONFIG_IEEE80211W
	if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
		|| !(pstat->flags & WLAN_STA_MFP)
#ifdef CONFIG_RTW_80211R
            || (pstat->ft_roaming == _TRUE)
#endif
           )
#endif /* CONFIG_IEEE80211W */
	{
		_rtw_spinlock_bh(&pstapriv->auth_list_lock);
		if (!rtw_is_list_empty(&pstat->auth_list)) {
			rtw_list_delete(&pstat->auth_list);
			pstapriv->auth_list_cnt--;
		}
		_rtw_spinunlock_bh(&pstapriv->auth_list_lock);

		_rtw_spinlock_bh(&pstapriv->asoc_list_lock);
		if (rtw_is_list_empty(&pstat->asoc_list)) {
			pstat->expire_to = pstapriv->expire_to;
			rtw_list_insert_tail(&pstat->asoc_list, &pstapriv->asoc_list);
			pstapriv->asoc_list_cnt++;
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
			if (sta_tbtx_enable) {
				pstat->tbtx_enable = _TRUE;
				pstapriv->tbtx_asoc_list_cnt++;
			}
#endif
		}
		_rtw_spinunlock_bh(&pstapriv->asoc_list_lock);
	}

	/* now the station is qualified to join our BSS...	 */
#if defined(CONFIG_RTW_BRSC) || defined(CONFIG_RTL_EXT_PORT_SUPPORT)
	rtw_flush_brsc_info(NULL, get_addr2_ptr(pframe));
#endif
	rtw_update_stainfo_by_asoc(padapter, get_addr2_ptr(pframe));
	if (pstat && (pstat->state & WIFI_FW_ASSOC_SUCCESS) && (_STATS_SUCCESSFUL_ == status)) {

#ifdef CONFIG_RTW_MULTI_AP
		if (primary_adapter->multi_ap_mode & MAP_MODE_FRONT_AP) {
			pstat->assoc_req_length = ((pkt_len - WLAN_HDR_A3_LEN) > sizeof(pstat->assoc_req_body) ?
					sizeof(pstat->assoc_req_body) : (pkt_len - WLAN_HDR_A3_LEN));
			_rtw_memset(pstat->assoc_req_body, 0 , sizeof(pstat->assoc_req_body));
			_rtw_memcpy(pstat->assoc_req_body, pframe + WLAN_HDR_A3_LEN, pstat->assoc_req_length);
		}
		core_map_send_client_join_notify(padapter->mac_addr, pstat->phl_sta->mac_addr);
#endif

#ifdef WIFI_LOGO_HE_4_52_1
		pstat->om_step = 0;
		pstat->om_time = 0;
#endif

		rtw_parse_vendor_info(pstat, pos, left);
#ifdef CONFIG_VW_REFINE
	    rtw_parse_vendor_vw_sta(padapter, pstat);
#endif
#ifdef CONFIG_OCTOSCOPE_REFINE
		if (padapter->octoscope_enable && (pstat->vendor == HT_IOT_PEER_OCTOSCOPE))
			padapter->octoscope_sta_cnt++;
#endif

#ifdef CONFIG_NATIVEAP_MLME
#ifdef CONFIG_IEEE80211W
		if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
			|| !(pstat->flags & WLAN_STA_MFP)
#ifdef CONFIG_RTW_80211R
			|| (pstat->ft_roaming == _TRUE)
#endif
                   )
#endif /* CONFIG_IEEE80211W */
		{
			/* .1 bss_cap_update & sta_info_update */
			bss_cap_update_on_sta_join(padapter, pstat);
			sta_info_update(padapter, pstat);
#if defined(CONFIG_IEEE80211W) && !defined(CONFIG_IOCTL_CFG80211)
			pstat->sa_query_cnt = 0;
			pstat->sa_query_timed_out = 0;
#endif
		}
#ifdef CONFIG_IEEE80211W
		if (pstat->bpairwise_key_installed == _TRUE && (pstat->flags & WLAN_STA_MFP)) {
			status = _STATS_REFUSED_TEMPORARILY_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(padapter, pstat->phl_sta->mac_addr, "Authentication failed [temporary reject]\n");
#endif
		}
#endif /* CONFIG_IEEE80211W */
		/* .2 issue assoc rsp before notify station join event. */
#ifdef CONFIG_IOCTL_CFG80211
		RTW_INFO("recv %s-req (" MAC_FMT "), offload to hostapd\n",
			(frame_type == WIFI_ASSOCREQ)?"assoc":"re-assoc", MAC_ARG(pstat->phl_sta->mac_addr));
#if defined(WIFI_LOGO_MBO_4_2_5_3)
		if(pmlmeinfo->is_MBO_4_2_5_3) {
			if (frame_type == WIFI_ASSOCREQ)
				issue_asocrsp(padapter, status, pstat, WIFI_ASSOCRSP);
			else
				issue_asocrsp(padapter, status, pstat, WIFI_REASSOCRSP);
		}
#endif
#else
		if (frame_type == WIFI_ASSOCREQ)
			issue_asocrsp(padapter, status, pstat, WIFI_ASSOCRSP);
		else
			issue_asocrsp(padapter, status, pstat, WIFI_REASSOCRSP);
#endif /* CONFIG_IOCTL_CFG80211 */

#ifdef CONFIG_RTW_MULTI_AP_R2
		if(frame_type==WIFI_ASSOCREQ)
			core_map_send_tunneled_message(padapter, get_addr2_ptr(pframe), TUNNELED_MSG_ASSOREQ, pkt_len - WLAN_HDR_A3_LEN, pframe + WLAN_HDR_A3_LEN);
		else
			core_map_send_tunneled_message(padapter, get_addr2_ptr(pframe), TUNNELED_MSG_REASSOREQ, pkt_len - WLAN_HDR_A3_LEN, pframe + WLAN_HDR_A3_LEN);
#endif
#ifdef CONFIG_RTL_EXT_PORT_SUPPORT
		update_hw_l2table(RTL_WLAN_NAME, (const unsigned char *)pstat->phl_sta->mac_addr);
#endif
#ifdef CONFIG_IOCTL_CFG80211
		_rtw_spinlock_bh(&pstat->lock);
		if (pstat->passoc_req) {
			rtw_mfree(pstat->passoc_req, pstat->assoc_req_len);
			pstat->passoc_req = NULL;
			pstat->assoc_req_len = 0;
		}

		pstat->passoc_req =  rtw_zmalloc(pkt_len);
		if (pstat->passoc_req) {
			_rtw_memcpy(pstat->passoc_req, pframe, pkt_len);
			pstat->assoc_req_len = pkt_len;
		}
		_rtw_spinunlock_bh(&pstat->lock);
#endif /* CONFIG_IOCTL_CFG80211 */
#if defined(CONFIG_IEEE80211W) && !defined(CONFIG_IOCTL_CFG80211)
		if ((pstat->bpairwise_key_installed != _TRUE && (pstat->flags & WLAN_STA_MFP))
			|| !(pstat->flags & WLAN_STA_MFP)
#ifdef CONFIG_RTW_80211R
			|| (pstat->ft_roaming == _TRUE)
#endif
                   )
#endif /* CONFIG_IEEE80211W */
		{
			/* .3-(1) report sta add event */
#ifdef CONFIG_WLAN_MANAGER
			rtw_netlink_send_new_sta_msg(padapter, pstat->phl_sta->mac_addr);
#endif
			report_add_sta_event(padapter, pstat->phl_sta->mac_addr);
		}
#ifdef CONFIG_RTW_80211R
		pstat->ft_roaming = _FALSE;
#endif

#if defined(CONFIG_IEEE80211W) && !defined(CONFIG_IOCTL_CFG80211)
		if (pstat->bpairwise_key_installed == _TRUE && (pstat->flags & WLAN_STA_MFP)) {
			RTW_INFO(MAC_FMT"\n", MAC_ARG(pstat->phl_sta->mac_addr));
			if (pstat->sa_query_cnt == 0 && !pstat->sa_query_timed_out) {
				pstat->sa_query_cnt++;
				pstat->sa_query_timed_out = 0;
				pstat->sa_query_end = jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_MAX_TO);
				issue_action_SA_Query(padapter, pstat->phl_sta->mac_addr, 0, 0, IEEE80211W_RIGHT_KEY);
				_set_timer(&pstat->dot11w_expire_timer, SA_QUERY_RETRY_TO);
			}
		}
#endif /* CONFIG_IEEE80211W */
#endif /* CONFIG_NATIVEAP_MLME */
	}

#ifdef CONFIG_VW_REFINE
	if (padapter->vw_enable) {
		u32 i, init_seq;

		init_seq = ( pstat->phl_sta->macid * padapter->sta_sn_gap) & 0xfff;
		for (i = 0; i < 8; i++)
			pstat->sta_xmitpriv.txseq_tid[i] = init_seq;
#ifdef CONFIG_RTW_TXSC_USE_HW_SEQ
		rtw_phl_set_dctrl_tbl_seq(padapter->dvobj->phl,
			padapter->phl_role,pstat->phl_sta, init_seq);
#endif
	}
#endif

#if defined(CONFIG_RTL_EXT_PORT_SUPPORT)
	rtl_wifi_fdb_add_hook(pstat->phl_sta->mac_addr);
#endif

	return _SUCCESS;

asoc_class2_error:

#ifdef CONFIG_RTW_MULTI_AP_R2
	//Client Failed Connection message
	if(primary_adapter->registrypriv.wifi_mib.multiap_report_fail_assoc)
		core_map_send_sta_failed_conn_event(pstat, status, _RSON_RESERVED_);
#endif

#ifdef CONFIG_NATIVEAP_MLME
	issue_deauth(padapter, (void *)get_addr2_ptr(pframe), status);
#endif

	return _FAIL;

OnAssocReqFail:

#ifdef CONFIG_RTW_MULTI_AP_R2
	//Client Failed Connection message
	if(primary_adapter->registrypriv.wifi_mib.multiap_report_fail_assoc)
		core_map_send_sta_failed_conn_event(pstat, status, _RSON_RESERVED_);
#endif

#ifdef CONFIG_NATIVEAP_MLME
	/* pstat->phl_sta->aid = 0; */
	if (frame_type == WIFI_ASSOCREQ)
		issue_asocrsp(padapter, status, pstat, WIFI_ASSOCRSP);
	else
		issue_asocrsp(padapter, status, pstat, WIFI_REASSOCRSP);
#endif

	if (pstat)
		rtw_free_stainfo(padapter, pstat);

#endif /* CONFIG_AP_MODE */

	return _FAIL;

}

#if defined(CONFIG_LAYER2_ROAMING) && defined(CONFIG_RTW_80211K)
void rtw_roam_nb_discover(_adapter *padapter, u8 bfroce)
{
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *psta;
	u8 nb_req_issue = _FALSE;

	if (!check_fwstate(pmlmepriv, WIFI_ASOC_STATE))
		return;

	if (!rtw_chk_roam_flags(padapter, RTW_ROAM_ACTIVE))
		return;

	psta = rtw_get_stainfo(pstapriv, pmlmeinfo->network.MacAddress);
	if (!psta)
		return;

	if (bfroce || (!pmlmepriv->nb_info.nb_rpt_is_same))
		nb_req_issue = _TRUE;

	if (nb_req_issue && (psta->rm_en_cap[0] & RTW_RRM_NB_RPT_EN))
		rm_add_nb_req(padapter, psta);
}
#endif

static void rtw_ie_handler(struct _ADAPTER *padapter, u8 *ie, u32 ie_len)
{
	int i;
	struct _NDIS_802_11_VARIABLE_IEs *p;


	if (!ie || (ie_len == 0))
		return;

	for (i = 0; i < ie_len;) {
		p = (struct _NDIS_802_11_VARIABLE_IEs *)(ie + i);
		switch (p->ElementID) {
		case _VENDOR_SPECIFIC_IE_:
			if (_rtw_memcmp(p->data, WMM_PARA_OUI, 6))	/* WMM */
				WMM_param_handler(padapter, p);
#if defined(CONFIG_P2P) && defined(CONFIG_WFD)
			else if (_rtw_memcmp(p->data, WFD_OUI, 4))		/* WFD */
				rtw_process_wfd_ie(padapter, (u8 *)p, p->Length, __func__);
#endif
			break;

#ifdef CONFIG_WAPI_SUPPORT
		case _WAPI_IE_:
			pWapiIE = p;
			break;
#endif

		case _HT_CAPABILITY_IE_:	/* HT caps */
			HT_caps_handler(padapter, p);
#ifdef ROKU_PRIVATE
			HT_caps_handler_infra_ap(padapter, p);
#endif /* ROKU_PRIVATE */
			break;

		case _HT_EXTRA_INFO_IE_:	/* HT info */
			HT_info_handler(padapter, p);
			break;

#ifdef CONFIG_80211AC_VHT
		case EID_VHTCapability:
			VHT_caps_handler(padapter, p);
#ifdef ROKU_PRIVATE
			VHT_caps_handler_infra_ap(padapter, p);
#endif /* ROKU_PRIVATE */
			break;

		case EID_VHTOperation:
			VHT_operation_handler(padapter, p);
			break;
#endif

#ifdef CONFIG_80211AX_HE
		case WLAN_EID_EXTENSION:
			if (p->data[0] == WLAN_EID_EXTENSION_HE_CAPABILITY)
				HE_caps_handler(padapter, p);
			else if (p->data[0] == WLAN_EID_EXTENSION_HE_OPERATION)
				HE_operation_handler(padapter, p);
			break;
#endif

		case _ERPINFO_IE_:
			ERP_IE_handler(padapter, p);
			break;
#ifdef CONFIG_TDLS
		case _EXT_CAP_IE_:
			if (check_ap_tdls_prohibited(p->data, p->Length) == _TRUE)
				padapter->tdlsinfo.ap_prohibited = _TRUE;
			if (check_ap_tdls_ch_switching_prohibited(p->data, p->Length) == _TRUE)
				padapter->tdlsinfo.ch_switch_prohibited = _TRUE;
			break;
#endif /* CONFIG_TDLS */

#ifdef CONFIG_RTW_80211K
		case _EID_RRM_EN_CAP_IE_:
			RM_IE_handler(padapter, p);
			break;
#endif

#ifdef ROKU_PRIVATE
		/* Infra mode, used to store AP's info , Parse the supported rates from AssocRsp */
		case _SUPPORTEDRATES_IE_:
			Supported_rate_infra_ap(padapter, p);
			break;

		case _EXT_SUPPORTEDRATES_IE_:
			Extended_Supported_rate_infra_ap(padapter, p);
			break;
#endif /* ROKU_PRIVATE */
		default:
			break;
		}

		i += (p->Length + 2);
	}
}

#ifdef CONFIG_RTW_MANUAL_EDCA
static void process_WMM_para_ie(_adapter *padapter, unsigned char *p)
{
	int ACI = (p[0] >> 5) & 0x03;
	/*avoid unaligned load*/
	unsigned short txoplimit;
	memcpy(&txoplimit,&p[2],sizeof(unsigned short));
//	if ((ACI >= 0) && (ACI <= 3)) {
		switch(ACI) {
			case 0:
				GET_STA_AC_BE_PARA.acm = (p[0] >> 4) & 0x01;
				GET_STA_AC_BE_PARA.aifsn = p[0] & 0x0f;
				GET_STA_AC_BE_PARA.ecw_min = p[1] & 0x0f;
				GET_STA_AC_BE_PARA.ecw_max = p[1] >> 4;
				GET_STA_AC_BE_PARA.txop_limit = le16_to_cpu(txoplimit);
				break;
			case 3:
				GET_STA_AC_VO_PARA.acm = (p[0] >> 4) & 0x01;
				GET_STA_AC_VO_PARA.aifsn = p[0] & 0x0f;
				GET_STA_AC_VO_PARA.ecw_min = p[1] & 0x0f;
				GET_STA_AC_VO_PARA.ecw_max = p[1] >> 4;
				GET_STA_AC_VO_PARA.txop_limit = le16_to_cpu(txoplimit);
				break;
			case 2:
				GET_STA_AC_VI_PARA.acm = (p[0] >> 4) & 0x01;
				GET_STA_AC_VI_PARA.aifsn = p[0] & 0x0f;
				GET_STA_AC_VI_PARA.ecw_min = p[1] & 0x0f;
				GET_STA_AC_VI_PARA.ecw_max = p[1] >> 4;
				GET_STA_AC_VI_PARA.txop_limit = le16_to_cpu(txoplimit);
				break;
			default:
				GET_STA_AC_BK_PARA.acm = (p[0] >> 4) & 0x01;
				GET_STA_AC_BK_PARA.aifsn = p[0] & 0x0f;
				GET_STA_AC_BK_PARA.ecw_min = p[1] & 0x0f;
				GET_STA_AC_BK_PARA.ecw_max = p[1] >> 4;
				GET_STA_AC_BK_PARA.txop_limit = le16_to_cpu(txoplimit);
				break;
		}
//	}
//	else
//		printk("WMM AP EDCA Parameter IE error!\n");
}

static void sta_config_EDCA_para(_adapter *padapter)
{
	unsigned int slot_time = 20, sifs_time = 10;
	unsigned int vo_edca = 0, vi_edca = 0, be_edca = 0, bk_edca = 0;

	if ((padapter->registrypriv.wireless_mode & WLAN_MD_11N ) ||
		(padapter->registrypriv.wireless_mode & WLAN_MD_11G))
		slot_time = 9;

	if (padapter->registrypriv.wireless_mode & WLAN_MD_11N)
		sifs_time = 16;


	if (GET_STA_AC_VO_PARA.aifsn) {
		vo_edca = (((unsigned short)(GET_STA_AC_VO_PARA.txop_limit)) << 16)
			| (((unsigned char)(GET_STA_AC_VO_PARA.ecw_max)) << 12)
			| (((unsigned char)(GET_STA_AC_VO_PARA.ecw_min)) << 8)
			| (sifs_time + GET_STA_AC_VO_PARA.aifsn * slot_time);

		rtw_hw_set_edca(padapter, WMM_VOICE, vo_edca);
	}

	if (GET_STA_AC_VI_PARA.aifsn) {
		vi_edca = (((unsigned short)(GET_STA_AC_VI_PARA.txop_limit)) << 16)
			| (((unsigned char)(GET_STA_AC_VI_PARA.ecw_max)) << 12)
			| (((unsigned char)(GET_STA_AC_VI_PARA.ecw_min)) << 8)
			| (sifs_time + GET_STA_AC_VI_PARA.aifsn * slot_time);

		rtw_hw_set_edca(padapter, WMM_VIDEO, vi_edca);
	}

	if (GET_STA_AC_BE_PARA.aifsn) {
		be_edca = (((unsigned short)(GET_STA_AC_BE_PARA.txop_limit)) << 16)
			| (((unsigned char)(GET_STA_AC_BE_PARA.ecw_max)) << 12)
			| (((unsigned char)(GET_STA_AC_BE_PARA.ecw_min)) << 8)
			| (sifs_time + GET_STA_AC_BE_PARA.aifsn * slot_time);

		rtw_hw_set_edca(padapter, WMM_BEST_EFFORT, be_edca);
	}

	if (GET_STA_AC_BK_PARA.aifsn) {
		bk_edca = (((unsigned short)(GET_STA_AC_BK_PARA.txop_limit)) << 16)
			| (((unsigned char)(GET_STA_AC_BK_PARA.ecw_max)) << 12)
			| (((unsigned char)(GET_STA_AC_BK_PARA.ecw_min)) << 8)
			| (sifs_time + GET_STA_AC_BK_PARA.aifsn * slot_time);

		rtw_hw_set_edca(padapter, WMM_BACKGROUND, bk_edca);
	}
}
#endif

unsigned int OnAssocRsp(_adapter *padapter, union recv_frame *precv_frame)
{
	uint i;
	int res;
	unsigned short	status;
	PNDIS_802_11_VARIABLE_IEs	pIE;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	/* WLAN_BSSID_EX 		*cur_network = &(pmlmeinfo->network); */
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint pkt_len = precv_frame->u.hdr.len;
#if defined(CONFIG_APPEND_VENDOR_IE_ENABLE) || defined(CONFIG_RTW_MULTI_AP)
	struct sta_info	*pstat = NULL;
	struct sta_priv *pstapriv = &padapter->stapriv;
#endif
#ifdef CONFIG_WAPI_SUPPORT
	PNDIS_802_11_VARIABLE_IEs	pWapiIE = NULL;
#endif
#if 0
#ifdef CONFIG_RTW_MANUAL_EDCA
	unsigned char WMM_PARA_IE[6] = {0x00, 0x50, 0xf2, 0x02, 0x01, 0x01};
	u8 *p;
	int len;
#endif
#endif
#ifdef CONFIG_REPEATER_PREFER_BAND_SUPPORT
	unsigned long age = 0;
	int tmp_band = -1;
#endif

	RTW_INFO("%s\n", __FUNCTION__);

#ifdef CONFIG_REPEATER_PREFER_BAND_SUPPORT
	if(MLME_IS_STA(padapter) && !is_primary_adapter(padapter))
	{
		if(padapter->registrypriv.band_type == BAND_CAP_5G)
			tmp_band = DEV_BAND_5G;
		else if(padapter->registrypriv.band_type == BAND_CAP_2G)
			tmp_band = DEV_BAND_2G;

		if(tmp_band != -1)
		{
			if(padapter->registrypriv.wifi_mib.wps_multi_cred_enable == 0 && !padapter->registrypriv.wifi_mib.band_prefer)
			{
				if(!band_check_exist(tmp_band))
				{
					printk("assoc reject, other band not up\n");
					if(jiffies/HZ >= pmlmepriv->last_assocresp_sec)
						age = jiffies/HZ - pmlmepriv->last_assocresp_sec;
					else
						age = jiffies/HZ + ~(unsigned long)0/HZ - pmlmepriv->last_assocresp_sec;

					if(pmlmepriv->last_assocresp_sec==0 || age < WAIT_TIME)
					{
						printk("assoc reject, timer not meet %lu %lu\n",pmlmepriv->last_assocresp_sec, jiffies/HZ);
						if(pmlmepriv->last_assocresp_sec==0)
							pmlmepriv->last_assocresp_sec = jiffies/HZ;
						pmlmeinfo->state = WIFI_FW_NULL_STATE;
						res = -4;
						goto report_assoc_result;
					}

				}
				else
				{
					if(jiffies/HZ >= pmlmepriv->last_assocresp_sec)
						age = jiffies/HZ - pmlmepriv->last_assocresp_sec;
					else
						age = jiffies/HZ + ~(unsigned long)0/HZ - pmlmepriv->last_assocresp_sec;

					if(pmlmepriv->last_assocresp_sec==0 || (band_check_assoc(tmp_band) && band_check_ssid_same(tmp_band)) || age < WAIT_TIME)
					{
						printk("assoc reject, timer not meet %lu %lu\n",pmlmepriv->last_assocresp_sec, jiffies/HZ);
						if(pmlmepriv->last_assocresp_sec==0)
							pmlmepriv->last_assocresp_sec = jiffies/HZ;
						pmlmeinfo->state = WIFI_FW_NULL_STATE;
						res = -4;
						goto report_assoc_result;
					}
					else if(age > WAIT_TIME)
					{
						if(band_check_prefer(tmp_band) && band_check_ssid_same(tmp_band))
						{
							if(band_check_assoc(tmp_band) || age <= SECOND_WAIT_TIME)
							{
								printk("assoc reject, not prefer band %lu %lu\n",pmlmepriv->last_assocresp_sec, jiffies/HZ);
								pmlmeinfo->state = WIFI_FW_NULL_STATE;
								res = -4;
								goto report_assoc_result;
							}
						}
					}
				}
			}

			if(padapter->registrypriv.wifi_mib.wps_multi_cred_enable == 0 && padapter->registrypriv.wifi_mib.band_prefer)
			{
				if(band_check_assoc(tmp_band) && band_check_ssid_same(tmp_band))
				{
					printk("assoc reject, the other band is connect\n");
					pmlmeinfo->state = WIFI_FW_NULL_STATE;
					res = -4;
					goto report_assoc_result;
				}
			}
		}
	}
#endif

	/* check A1 matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), get_da(pframe), ETH_ALEN))
		return _SUCCESS;

	if (!(pmlmeinfo->state & (WIFI_FW_AUTH_SUCCESS | WIFI_FW_ASSOC_STATE)) || pmlmeext->join_abort)
		return _SUCCESS;

	if (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS)
		return _SUCCESS;

	_cancel_timer_ex(&pmlmeext->link_timer);

	/* status */
	status = le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN + 2));
	if (status > 0) {
		RTW_INFO("assoc reject, status code: %d\n", status);
		pmlmeinfo->state = WIFI_FW_NULL_STATE;
		res = -4;
		goto report_assoc_result;
	}

#if defined(CONFIG_RTW_A4_STA) || defined(CONFIG_RTW_MULTI_AP) || defined(CONFIG_APPEND_VENDOR_IE_ENABLE)
	pstat = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
#endif

/*Set a4 sta enable*/
#ifdef CONFIG_RTW_A4_STA
	if (pstat && padapter->a4_enable == 1) {
		pstat->flags |= WLAN_STA_A4;
	}
#endif

	/* get capabilities */
	pmlmeinfo->capability = le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN));

	/* set slot time */
	pmlmeinfo->slotTime = (pmlmeinfo->capability & BIT(10)) ? 9 : 20;

	/* AID assignment move to rtw_joinbss_update_stainfo */
	res = (int)(le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN + 4)) & 0x3fff);

#ifdef RTW_PHL_TEST_FPGA
	res = 1;
#endif

	/* check aid value */
	if (res < 1 || res > 2007) {
		RTW_INFO("assoc reject, aid: %d\n", res);
		pmlmeinfo->state = WIFI_FW_NULL_STATE;
		res = -4;
		goto report_assoc_result;
	}

	/* following are moved to join event callback function */
	/* to handle HT, WMM, rate adaptive, update MAC reg */
	/* for not to handle the synchronous IO in the tasklet */

	rtw_ie_handler(padapter, pframe + 6 + WLAN_HDR_A3_LEN,
		       pkt_len - 6 - WLAN_HDR_A3_LEN);

#if defined(CONFIG_RTW_MULTI_AP)
	if(pstat && (GET_MAP_BSS_TYPE(padapter) & MULTI_AP_BACKHAUL_STA))
	{
		core_map_check_sta_ie(padapter, pstat, pframe + 6 + WLAN_HDR_A3_LEN, pkt_len - 6 - WLAN_HDR_A3_LEN);
#ifndef CONFIG_RTW_MULTI_AP_LOGO
		if(!pstat->multiap_profile)
		{
			RTW_ERR("[%s %d] Target AP is not a Multi AP BSS, assoc reject.\n", __FUNCTION__, __LINE__);
			res = -4;
			goto report_assoc_result;
		}
#endif
	}
#endif

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	rtw_parse_vendor_ie(padapter, pstat, pframe,
		pframe + 6 + WLAN_HDR_A3_LEN, pkt_len - 6 - WLAN_HDR_A3_LEN);
#endif

#ifdef CONFIG_WAPI_SUPPORT
	rtw_wapi_on_assoc_ok(padapter, pIE);
#endif

	pmlmeinfo->state &= (~WIFI_FW_ASSOC_STATE);
	pmlmeinfo->state |= WIFI_FW_ASSOC_SUCCESS;

#if 0
#ifdef CONFIG_RTW_MANUAL_EDCA
	if(padapter->registrypriv.manual_ap_sta_edca) {
		len = 0;

		for (p = pframe + WLAN_HDR_A3_LEN + _ASOCRSP_IE_OFFSET_;; p += (len + 2)) {
			p = rtw_get_ie(p, _VENDOR_SPECIFIC_IE_, &len, pkt_len - (p - pframe));

			if (p && len > 0) {
				if (!memcmp(p+2, WMM_PARA_IE, 6)) {

					//capture the EDCA para
					p += 10;  // start of EDCA parameters

					for (i = 0; i <4; i++) {
						process_WMM_para_ie(padapter, p);  //get the info
						p += 4;
					}


					RTW_INFO("BE: ACM %d, AIFSN %d, ECWmin %d, ECWmax %d, TXOP %d\n",
						GET_STA_AC_BE_PARA.acm, GET_STA_AC_BE_PARA.aifsn,
						GET_STA_AC_BE_PARA.ecw_min, GET_STA_AC_BE_PARA.ecw_max,
						GET_STA_AC_BE_PARA.txop_limit);
					RTW_INFO("VO: ACM %d, AIFSN %d, ECWmin %d, ECWmax %d, TXOP %d\n",
						GET_STA_AC_VO_PARA.acm, GET_STA_AC_VO_PARA.aifsn,
						GET_STA_AC_VO_PARA.ecw_min, GET_STA_AC_VO_PARA.ecw_max,
						GET_STA_AC_VO_PARA.txop_limit);
					RTW_INFO("VI: ACM %d, AIFSN %d, ECWmin %d, ECWmax %d, TXOP %d\n",
						GET_STA_AC_VI_PARA.acm, GET_STA_AC_VI_PARA.aifsn,
						GET_STA_AC_VI_PARA.ecw_min, GET_STA_AC_VI_PARA.ecw_max,
						GET_STA_AC_VI_PARA.txop_limit);
					RTW_INFO("BK: ACM %d, AIFSN %d, ECWmin %d, ECWmax %d, TXOP %d\n",
						GET_STA_AC_BK_PARA.acm, GET_STA_AC_BK_PARA.aifsn,
						GET_STA_AC_BK_PARA.ecw_min, GET_STA_AC_BK_PARA.ecw_max,
						GET_STA_AC_BK_PARA.txop_limit);

#if defined(CONFIG_RTW_CROSSBAND_REPEATER_SUPPORT) || defined(CONFIG_RTW_SUPPORT_MBSSID_VAP)
					if (is_primary_adapter(padapter))
#endif
					{
						sta_config_EDCA_para(padapter);
					}

					break;

				}
			}
			else
				break;
		}
	}
#endif
#endif

	/* Update Basic Rate Table for spec, 2010-12-28 , by thomas */
	UpdateBrateTbl(padapter, pmlmeinfo->network.SupportedRates);

report_assoc_result:
	if (res > 0)
		rtw_buf_update(&pmlmepriv->assoc_rsp, &pmlmepriv->assoc_rsp_len, pframe, pkt_len);
	else
		rtw_buf_free(&pmlmepriv->assoc_rsp, &pmlmepriv->assoc_rsp_len);

	report_join_res(padapter, res, status);

#if defined(CONFIG_LAYER2_ROAMING) && defined(CONFIG_RTW_80211K)
	rtw_roam_nb_discover(padapter, _TRUE);
#endif

#ifdef CONFIG_REPEATER_PREFER_BAND_SUPPORT
	if(MLME_IS_STA(padapter) && !is_primary_adapter(padapter))
	{
		if(res > 0)
			pmlmepriv->last_assocresp_sec = 0;
	}
#endif

	return _SUCCESS;
}

unsigned int OnDeAuth(_adapter *padapter, union recv_frame *precv_frame)
{
	unsigned short	reason;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 *pframe = precv_frame->u.hdr.rx_data;
	bool active = _FALSE;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P */
#ifdef CONFIG_VW_REFINE
	u8 i;
#endif

#ifdef RTW_WKARD_REDUCE_CONNECT_LOG
	if(!padapter->vw_enable)
#endif
	{
		reason = le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN));
		RTW_PRINT(FUNC_ADPT_FMT" reason=%u, sa="MAC_FMT"\n", FUNC_ADPT_ARG(padapter),
				  reason, MAC_ARG(get_addr2_ptr(pframe)));
	}

	/* check A3 */
	if (!(_rtw_memcmp(GetAddr3Ptr(pframe), get_my_bssid(&pmlmeinfo->network), ETH_ALEN)))
		return _SUCCESS;

	RTW_INFO(FUNC_ADPT_FMT" - Start to Disconnect\n", FUNC_ADPT_ARG(padapter));

#ifdef CONFIG_P2P
	if (pwdinfo->rx_invitereq_info.scan_op_ch_only) {
		_cancel_timer_ex(&pwdinfo->reset_ch_sitesurvey);
		_set_timer(&pwdinfo->reset_ch_sitesurvey, 10);
	}
#endif /* CONFIG_P2P */

	reason = le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN));

#ifdef CONFIG_AP_MODE
	if (MLME_IS_AP(padapter)) {
		struct sta_info *psta;
		struct sta_priv *pstapriv = &padapter->stapriv;

		/* _rtw_spinlock_bh(&(pstapriv->sta_hash_lock));		 */
		/* rtw_free_stainfo(padapter, psta); */
		/* _rtw_spinunlock_bh(&(pstapriv->sta_hash_lock));		 */

		psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
		if (psta) {
			u8 updated = _FALSE;
#ifdef CTC_WIFI_DIAG
			ctcwifi_diag_log(padapter, psta->phl_sta->mac_addr, 0, "Deauthentication", (pframe+WLAN_HDR_A3_LEN), (precv_frame->u.hdr.len-WLAN_HDR_A3_LEN));
			ctcwifi_assoc_err(padapter, psta->phl_sta->mac_addr, "De-authed [receive deauth, reason %d]\n", reason);
#endif

#ifdef CONFIG_VW_REFINE
			i = psta->phl_sta->macid % MAX_SKB_XMIT_QUEUE;
#endif

			_rtw_spinlock_bh(&pstapriv->asoc_list_lock);
			if (rtw_is_list_empty(&psta->asoc_list) == _FALSE) {
				rtw_list_delete(&psta->asoc_list);
				pstapriv->asoc_list_cnt--;
				#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
				if (psta->tbtx_enable)
					pstapriv->tbtx_asoc_list_cnt--;
				#endif

#ifdef CONFIG_IEEE80211W
				/* pmf: 4.3.3.2 */
				if (psta->flags & WLAN_STA_MFP) {
					psta->flags &= ~WLAN_STA_MFP;
					reason = _RSON_CLS2_;
					active = _TRUE;
				}
#endif
				updated = ap_free_sta(padapter, psta, active, reason, _TRUE, _FALSE);

			}
			_rtw_spinunlock_bh(&pstapriv->asoc_list_lock);

			associated_clients_update(padapter, updated, STA_INFO_UPDATE_ALL);
		}


		return _SUCCESS;
	} else
#endif
	if (!MLME_IS_MESH(padapter)) {
		int	ignore_received_deauth = 0;

		/*	Commented by Albert 20130604 */
		/*	Before sending the auth frame to start the STA/GC mode connection with AP/GO,  */
		/*	we will send the deauth first. */
		/*	However, the Win8.1 with BRCM Wi-Fi will send the deauth with reason code 6 to us after receieving our deauth. */
		/*	Added the following code to avoid this case. */
		if ((pmlmeinfo->state & WIFI_FW_AUTH_STATE) ||
		    (pmlmeinfo->state & WIFI_FW_ASSOC_STATE)) {
			if (reason == WLAN_REASON_CLASS2_FRAME_FROM_NONAUTH_STA)
				ignore_received_deauth = 1;
			else if (WLAN_REASON_PREV_AUTH_NOT_VALID == reason) {
				/* TODO: 802.11r */
				ignore_received_deauth = 1;
			}
		}
#ifdef RTW_WKARD_REDUCE_CONNECT_LOG
		if(!padapter->vw_enable)
#endif
                {
			RTW_PRINT(FUNC_ADPT_FMT" reason=%u, ta="MAC_FMT", ignore=%d\n"
				, FUNC_ADPT_ARG(padapter), reason, MAC_ARG(get_addr2_ptr(pframe)), ignore_received_deauth);
                }
		if (0 == ignore_received_deauth)
			receive_disconnect(padapter, get_addr2_ptr(pframe), reason, _FALSE);
	}
	pmlmepriv->LinkDetectInfo.bBusyTraffic = _FALSE;
	return _SUCCESS;

}

unsigned int OnDisassoc(_adapter *padapter, union recv_frame *precv_frame)
{
	unsigned short	reason;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 *pframe = precv_frame->u.hdr.rx_data;
	bool active = _FALSE;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P */

#ifdef RTW_WKARD_REDUCE_CONNECT_LOG
	if(!padapter->vw_enable)
#endif
	{
		reason = le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN));
		RTW_PRINT(FUNC_ADPT_FMT" reason=%u, sa="MAC_FMT"\n", FUNC_ADPT_ARG(padapter),
			  	  reason, MAC_ARG(get_addr2_ptr(pframe)));
	}

	/* check A3 */
	if (!(_rtw_memcmp(GetAddr3Ptr(pframe), get_my_bssid(&pmlmeinfo->network), ETH_ALEN)))
		return _SUCCESS;

	RTW_INFO(FUNC_ADPT_FMT" - Start to Disconnect\n", FUNC_ADPT_ARG(padapter));

#ifdef CONFIG_P2P
	if (pwdinfo->rx_invitereq_info.scan_op_ch_only) {
		_cancel_timer_ex(&pwdinfo->reset_ch_sitesurvey);
		_set_timer(&pwdinfo->reset_ch_sitesurvey, 10);
	}
#endif /* CONFIG_P2P */

	reason = le16_to_cpu(*(unsigned short *)(pframe + WLAN_HDR_A3_LEN));

#ifdef CONFIG_AP_MODE
	if (MLME_IS_AP(padapter)) {
		struct sta_info *psta;
		struct sta_priv *pstapriv = &padapter->stapriv;

		/* _rtw_spinlock_bh(&(pstapriv->sta_hash_lock));	 */
		/* rtw_free_stainfo(padapter, psta); */
		/* _rtw_spinunlock_bh(&(pstapriv->sta_hash_lock));		 */

		psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));
		if (psta) {
			u8 updated = _FALSE;
#ifdef CTC_WIFI_DIAG
			ctcwifi_diag_log(padapter, psta->phl_sta->mac_addr, 0, "Disassociation", (pframe+WLAN_HDR_A3_LEN), (precv_frame->u.hdr.len-WLAN_HDR_A3_LEN));
			ctcwifi_assoc_err(padapter, psta->phl_sta->mac_addr, "De-authed [receive disassoc, reason %d]\n", reason);
#endif

			_rtw_spinlock_bh(&pstapriv->asoc_list_lock);
			if (rtw_is_list_empty(&psta->asoc_list) == _FALSE) {
				rtw_list_delete(&psta->asoc_list);
				pstapriv->asoc_list_cnt--;
				#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
				if (psta->tbtx_enable)
					pstapriv->tbtx_asoc_list_cnt--;
				#endif

#ifdef CONFIG_IEEE80211W
				/* pmf: 4.3.3.1 */
				if (psta->flags & WLAN_STA_MFP) {
					psta->flags &= ~WLAN_STA_MFP;
					reason = _RSON_CLS2_;
					active = _TRUE;
				}
#endif
				updated = ap_free_sta(padapter, psta, active, reason, _TRUE, _FALSE);

			}
			_rtw_spinunlock_bh(&pstapriv->asoc_list_lock);

			associated_clients_update(padapter, updated, STA_INFO_UPDATE_ALL);
		}

		return _SUCCESS;
	} else
#endif
	if (!MLME_IS_MESH(padapter)) {
		RTW_PRINT(FUNC_ADPT_FMT" reason=%u, ta="MAC_FMT"\n"
			, FUNC_ADPT_ARG(padapter), reason, MAC_ARG(get_addr2_ptr(pframe)));

		receive_disconnect(padapter, get_addr2_ptr(pframe), reason, _FALSE);
	}
	pmlmepriv->LinkDetectInfo.bBusyTraffic = _FALSE;
	return _SUCCESS;

}

unsigned int OnAtim(_adapter *padapter, union recv_frame *precv_frame)
{
	RTW_INFO("%s\n", __FUNCTION__);
	return _SUCCESS;
}

unsigned int on_action_spct_ch_switch(_adapter *padapter, struct sta_info *psta, u8 *ies, uint ies_len)
{
	unsigned int ret = _FAIL;
	struct mlme_ext_priv *mlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(mlmeext->mlmext_info);

	if (!(pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS)) {
		ret = _SUCCESS;
		goto exit;
	}

	if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_STATION_STATE)) {

		int ch_switch_mode = -1, ch = -1, ch_switch_cnt = -1;
		int ch_offset = -1;
		u8 bwmode;
		struct ieee80211_info_element *ie;

		RTW_INFO(FUNC_NDEV_FMT" from "MAC_FMT"\n",
			FUNC_NDEV_ARG(padapter->pnetdev), MAC_ARG(psta->phl_sta->mac_addr));

		for_each_ie(ie, ies, ies_len) {
			if (ie->id == WLAN_EID_CHANNEL_SWITCH) {
				ch_switch_mode = ie->data[0];
				ch = ie->data[1];
				ch_switch_cnt = ie->data[2];
				RTW_INFO("ch_switch_mode:%d, ch:%d, ch_switch_cnt:%d\n",
					 ch_switch_mode, ch, ch_switch_cnt);
			} else if (ie->id == WLAN_EID_SECONDARY_CHANNEL_OFFSET) {
				ch_offset = secondary_ch_offset_to_hal_ch_offset(ie->data[0]);
				RTW_INFO("ch_offset:%d\n", ch_offset);
			}
		}

		if (ch == -1)
			return _SUCCESS;

		if (ch_offset == -1)
			bwmode = mlmeext->cur_bwmode;
		else
			bwmode = (ch_offset == CHAN_OFFSET_NO_EXT) ?
				 CHANNEL_WIDTH_20 : CHANNEL_WIDTH_40;

		ch_offset = (ch_offset == -1) ? mlmeext->cur_ch_offset : ch_offset;

		/* todo:
		 * 1. the decision of channel switching
		 * 2. things after channel switching
		 */

		ret = rtw_set_chbw_cmd(padapter, ch, bwmode, ch_offset, 0);
	}

exit:
	return ret;
}

unsigned int on_action_spct(_adapter *padapter, union recv_frame *precv_frame)
{
	unsigned int ret = _FAIL;
	struct sta_info *psta = NULL;
	struct sta_priv *pstapriv = &padapter->stapriv;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint frame_len = precv_frame->u.hdr.len;
	u8 *frame_body = (u8 *)(pframe + sizeof(struct rtw_ieee80211_hdr_3addr));
	u8 category;
	u8 action;

	psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));

	if (!psta)
		goto exit;

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_SPECTRUM_MGMT)
		goto exit;

	action = frame_body[1];

	RTW_INFO(FUNC_ADPT_FMT" action:%u\n", FUNC_ADPT_ARG(padapter), action);

	switch (action) {
	case RTW_WLAN_ACTION_SPCT_MSR_REQ:
	case RTW_WLAN_ACTION_SPCT_MSR_RPRT:
	case RTW_WLAN_ACTION_SPCT_TPC_REQ:
	case RTW_WLAN_ACTION_SPCT_TPC_RPRT:
		break;
	case RTW_WLAN_ACTION_SPCT_CHL_SWITCH:
#ifdef CONFIG_SPCT_CH_SWITCH
		ret = on_action_spct_ch_switch(padapter, psta
				, frame_body + 2, frame_len - (frame_body - pframe) - 2);
#elif defined(CONFIG_CSA_IE)
		if (MLME_IS_STA(padapter) && MLME_IS_ASOC(padapter)) {
			process_csa_ie(padapter
				, frame_body + 2, frame_len - (frame_body - pframe) - 2);
		}
#endif
		break;
	default:
		break;
	}

exit:
	return ret;
}

unsigned int OnAction_qos(_adapter *padapter, union recv_frame *precv_frame)
{
	return _SUCCESS;
}

unsigned int OnAction_dls(_adapter *padapter, union recv_frame *precv_frame)
{
	return _SUCCESS;
}

#ifdef CONFIG_RTW_WNM
unsigned int on_action_wnm(_adapter *adapter, union recv_frame *rframe)
{
	unsigned int ret = _FAIL;
	struct sta_info *sta = NULL;
	struct mlme_priv *pmlmepriv = &(adapter->mlmepriv);
	struct sta_priv *stapriv = &(adapter->stapriv);
	u8 *frame = rframe->u.hdr.rx_data;
	u32 frame_len = rframe->u.hdr.len;
	u8 *frame_body = (u8 *)(frame + sizeof(struct rtw_ieee80211_hdr_3addr));
	u32 frame_body_len = frame_len - sizeof(struct rtw_ieee80211_hdr_3addr);
	u8 category, action;
	int cnt = 0;
	char msg[16];
	u8 reason = frame_body[3];
	u32 list_len;
	struct rx_pkt_attrib *pattrib = &rframe->u.hdr.attrib;

	sta = rtw_get_stainfo(stapriv, get_addr2_ptr(frame));
	if (!sta)
		goto exit;

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_WNM)
		goto exit;

	action = frame_body[1];

	switch (action) {
#ifdef CONFIG_RTW_80211R
	case RTW_WLAN_ACTION_WNM_BTM_REQ:
		if (MLME_IS_STA(adapter)) {
			RTW_INFO("WNM: RTW_WLAN_ACTION_WNM_BTM_REQ recv.\n");
			rtw_wnm_process_btm_req(adapter, frame_body, frame_body_len);
		}
		ret = _SUCCESS;
		break;
#endif
	case RTW_WLAN_ACTION_WNM_NOTIFICATION_REQ:
		if (MLME_IS_AP(adapter)) {
			RTW_INFO("WNM: RTW_WLAN_ACTION_WNM_NOTIFICATION_REQ recv.\n");
			rtw_wnm_process_wnm_notification_req(adapter, frame_body, frame_body_len, sta);
#ifdef CONFIG_RTW_MULTI_AP_R2
			core_map_send_tunneled_message(adapter, get_addr2_ptr(frame), TUNNELED_MSG_WNMNOTIFYREQ, frame_body_len, frame_body);
#endif
		}
		ret = _SUCCESS;
		break;
	case RTW_WLAN_ACTION_WNM_BTM_QUERY:
		if (MLME_IS_AP(adapter)) {
			reason  = frame_body[3];
			RTW_INFO("WNM: RTW_WLAN_ACTION_WNM_BTM_QUERY recv[%d]\n", reason);
			if(reason ==_WNM_PREFERED_BSS_TRANS_LIST_INCLUDED_){
				list_len = frame_body_len - 4;
				if(list_len > MAX_LIST_LEN){
					return _FAIL;
				}
			}else
				RTW_INFO("WNM_PREFERED BSS TRANS LIST NOT INCLUDED!\n");
#ifdef CONFIG_RTW_MULTI_AP_R2
			core_map_send_tunneled_message(adapter, get_addr2_ptr(frame), TUNNELED_MSG_BTMQUERY, frame_body_len, frame_body);
#endif
#ifdef CONFIG_IOCTL_CFG80211
			rtw_cfg80211_rx_action(adapter, rframe, msg);
#endif
		}
		ret = _SUCCESS;
		break;
	case RTW_WLAN_ACTION_WNM_BTM_RSP:
		RTW_PRINT("WNM: RTW_WLAN_ACTION_WNM_BTM_RSP recv. (status=%d)\n", frame_body[3]);
		if (MLME_IS_AP(adapter)) {
			rtw_wnm_process_btm_resp(adapter, sta, frame_body, frame_body_len);
		}
		/* fall through */
	default:
		#ifdef CONFIG_IOCTL_CFG80211
		cnt += sprintf((msg + cnt), "ACT_WNM %u", action);
		rtw_cfg80211_rx_action(adapter, rframe, msg);
		#endif
		ret = _SUCCESS;
		break;
	}

exit:
	return ret;
}
#endif /* CONFIG_RTW_WNM */

/**
 * rtw_rx_ampdu_size - Get the target RX AMPDU buffer size for the specific @adapter
 * @adapter: the adapter to get target RX AMPDU buffer size
 *
 * Returns: the target RX AMPDU buffer size
 */
u8 rtw_rx_ampdu_size(_adapter *adapter)
{
	u8 size;

	/* for scan */
	if (!mlmeext_chk_scan_state(&adapter->mlmeextpriv, SCAN_DISABLE)
	    && !mlmeext_chk_scan_state(&adapter->mlmeextpriv, SCAN_COMPLETE)
	    && adapter->mlmeextpriv.sitesurvey_res.rx_ampdu_size != RX_AMPDU_SIZE_INVALID
	   ) {
		size = adapter->mlmeextpriv.sitesurvey_res.rx_ampdu_size;
		goto exit;
	}

	if (adapter->fix_rx_ampdu_size != RX_AMPDU_SIZE_INVALID)
		size = adapter->fix_rx_ampdu_size;
	else
		rtw_hal_get_def_var(adapter, HW_VAR_MAX_RX_AMPDU_NUM, (void *)&size);

exit:

	/* default HW ampdu num = 256 */
	//if (REGSTY_IS_11AX_ENABLE(pregistrypriv) && adapter->driver_rx_ampdu_factor == 0xFF)
	//	size = 256 - 1;

#ifdef WIFI_LOGO_HE_4_7_1
	if (adapter->mlmeextpriv.mlmext_info.is_HE_4_7_1)
		size = 32;
#endif

	return size;
}

/**
 * rtw_rx_ampdu_is_accept - Get the permission if RX AMPDU should be set up for the specific @adapter
 * @adapter: the adapter to get the permission if RX AMPDU should be set up
 *
 * Returns: accept or not
 */
bool rtw_rx_ampdu_is_accept(_adapter *adapter)
{
	bool accept;

	if (adapter->fix_rx_ampdu_accept != RX_AMPDU_ACCEPT_INVALID) {
		accept = adapter->fix_rx_ampdu_accept;
		goto exit;
	}

	/* for scan */
	if (!mlmeext_chk_scan_state(&adapter->mlmeextpriv, SCAN_DISABLE)
	    && !mlmeext_chk_scan_state(&adapter->mlmeextpriv, SCAN_COMPLETE)
	    && adapter->mlmeextpriv.sitesurvey_res.rx_ampdu_accept != RX_AMPDU_ACCEPT_INVALID
	   ) {
		accept = adapter->mlmeextpriv.sitesurvey_res.rx_ampdu_accept;
		goto exit;
	}

	/* default value for other cases */
	accept = adapter->mlmeextpriv.mlmext_info.bAcceptAddbaReq;

exit:
	return accept;
}

/**
 * rtw_rx_ampdu_set_size - Set the target RX AMPDU buffer size for the specific @adapter and specific @reason
 * @adapter: the adapter to set target RX AMPDU buffer size
 * @size: the target RX AMPDU buffer size to set
 * @reason: reason for the target RX AMPDU buffer size setting
 *
 * Returns: whether the target RX AMPDU buffer size is changed
 */
bool rtw_rx_ampdu_set_size(_adapter *adapter, u8 size, u8 reason)
{
	bool is_adj = _FALSE;
	struct mlme_ext_priv *mlmeext;
	struct mlme_ext_info *mlmeinfo;

	mlmeext = &adapter->mlmeextpriv;
	mlmeinfo = &mlmeext->mlmext_info;

	if (reason == RX_AMPDU_DRV_FIXED) {
		if (adapter->fix_rx_ampdu_size != size) {
			adapter->fix_rx_ampdu_size = size;
			is_adj = _TRUE;
			RTW_INFO(FUNC_ADPT_FMT" fix_rx_ampdu_size:%u\n", FUNC_ADPT_ARG(adapter), size);
		}
	} else if (reason == RX_AMPDU_DRV_SCAN) {
		struct ss_res *ss = &adapter->mlmeextpriv.sitesurvey_res;

		if (ss->rx_ampdu_size != size) {
			ss->rx_ampdu_size = size;
			is_adj = _TRUE;
			RTW_INFO(FUNC_ADPT_FMT" ss.rx_ampdu_size:%u\n", FUNC_ADPT_ARG(adapter), size);
		}
	}

	return is_adj;
}

/**
 * rtw_rx_ampdu_set_accept - Set the permission if RX AMPDU should be set up for the specific @adapter and specific @reason
 * @adapter: the adapter to set if RX AMPDU should be set up
 * @accept: if RX AMPDU should be set up
 * @reason: reason for the permission if RX AMPDU should be set up
 *
 * Returns: whether the permission if RX AMPDU should be set up is changed
 */
bool rtw_rx_ampdu_set_accept(_adapter *adapter, u8 accept, u8 reason)
{
	bool is_adj = _FALSE;
	struct mlme_ext_priv *mlmeext;
	struct mlme_ext_info *mlmeinfo;

	mlmeext = &adapter->mlmeextpriv;
	mlmeinfo = &mlmeext->mlmext_info;

	if (reason == RX_AMPDU_DRV_FIXED) {
		if (adapter->fix_rx_ampdu_accept != accept) {
			adapter->fix_rx_ampdu_accept = accept;
			is_adj = _TRUE;
			RTW_INFO(FUNC_ADPT_FMT" fix_rx_ampdu_accept:%u\n", FUNC_ADPT_ARG(adapter), accept);
		}
	} else if (reason == RX_AMPDU_DRV_SCAN) {
		if (adapter->mlmeextpriv.sitesurvey_res.rx_ampdu_accept != accept) {
			adapter->mlmeextpriv.sitesurvey_res.rx_ampdu_accept = accept;
			is_adj = _TRUE;
			RTW_INFO(FUNC_ADPT_FMT" ss.rx_ampdu_accept:%u\n", FUNC_ADPT_ARG(adapter), accept);
		}
	}

	return is_adj;
}

/**
 * rx_ampdu_apply_sta_tid - Apply RX AMPDU setting to the specific @sta and @tid
 * @adapter: the adapter to which @sta belongs
 * @sta: the sta to be checked
 * @tid: the tid to be checked
 * @accept: the target permission if RX AMPDU should be set up
 * @size: the target RX AMPDU buffer size
 *
 * Returns:
 * 0: no canceled
 * 1: canceled by no permission
 * 2: canceled by different buffer size
 * 3: canceled by potential mismatched status
 *
 * Blocking function, may sleep
 */
u8 rx_ampdu_apply_sta_tid(_adapter *adapter, struct sta_info *sta, u8 tid, u8 accept, u8 size)
{
	u8 ret = 0;
	struct recv_reorder_ctrl *reorder_ctl = &sta->recvreorder_ctrl[tid];

	if (reorder_ctl->enable == _FALSE) {
		if (reorder_ctl->ampdu_size != RX_AMPDU_SIZE_INVALID) {
			send_delba_sta_tid_wait_ack(adapter, 0, sta, tid, 1);
			ret = 3;
		}
		goto exit;
	}

	if (accept == _FALSE) {
		send_delba_sta_tid_wait_ack(adapter, 0, sta, tid, 0);
		ret = 1;
	} else if (reorder_ctl->ampdu_size != size) {
		send_delba_sta_tid_wait_ack(adapter, 0, sta, tid, 0);
		ret = 2;
	}

exit:
	return ret;
}

u8 rx_ampdu_size_sta_limit(_adapter *adapter, struct sta_info *sta)
{
	u8 sz_limit = 0xFF;

#ifdef CONFIG_80211N_HT
	struct registry_priv *regsty = adapter_to_regsty(adapter);
	struct mlme_priv *mlme = &adapter->mlmepriv;
	struct mlme_ext_info *mlmeinfo = &adapter->mlmeextpriv.mlmext_info;
	s8 nss = -1;
	u8 bw = rtw_min(sta->phl_sta->chandef.bw, adapter->mlmeextpriv.cur_bwmode);

	#ifdef CONFIG_80211AC_VHT
	#ifdef CONFIG_80211AX_HE
	/* CONFIG_80211AX_HE_TODO */
	#endif
	if (is_supported_vht(sta->phl_sta->wmode)) {
		nss = rtw_min(rtw_vht_mcsmap_to_nss(mlme->vhtpriv.vht_mcs_map)
				, rtw_vht_mcsmap_to_nss(sta->vhtpriv.vht_mcs_map));
	} else
	#endif
	if (is_supported_ht(sta->phl_sta->wmode)) {
		nss = rtw_min(rtw_ht_mcsset_to_nss(mlmeinfo->HT_caps.u.HT_cap_element.MCS_rate)
				, rtw_ht_mcsset_to_nss(sta->htpriv.ht_cap.supp_mcs_set));
	}

	if (nss >= 1)
		sz_limit = regsty->rx_ampdu_sz_limit_by_nss_bw[nss - 1][bw];
#endif /* CONFIG_80211N_HT */

	return sz_limit;
}

/**
 * rx_ampdu_apply_sta - Apply RX AMPDU setting to the specific @sta
 * @adapter: the adapter to which @sta belongs
 * @sta: the sta to be checked
 * @accept: the target permission if RX AMPDU should be set up
 * @size: the target RX AMPDU buffer size
 *
 * Returns: number of the RX AMPDU assciation canceled for applying current target setting
 *
 * Blocking function, may sleep
 */
u8 rx_ampdu_apply_sta(_adapter *adapter, struct sta_info *sta, u8 accept, u8 size)
{
	u8 change_cnt = 0;
	int i;

	for (i = 0; i < TID_NUM; i++) {
		if (rx_ampdu_apply_sta_tid(adapter, sta, i, accept, size) != 0)
			change_cnt++;
	}

	return change_cnt;
}

/**
 * rtw_rx_ampdu_apply - Apply the current target RX AMPDU setting for the specific @adapter
 * @adapter: the adapter to be applied
 *
 * Returns: number of the RX AMPDU assciation canceled for applying current target setting
 */
u16 rtw_rx_ampdu_apply(_adapter *adapter)
{
	u16 adj_cnt = 0;
	struct sta_info *sta;
	u8 accept = rtw_rx_ampdu_is_accept(adapter);
	u8 size;

	if (adapter->fix_rx_ampdu_size != RX_AMPDU_SIZE_INVALID)
		size = adapter->fix_rx_ampdu_size;
	else
		size = rtw_rx_ampdu_size(adapter);

	if (MLME_IS_STA(adapter)) {
		sta = rtw_get_stainfo(&adapter->stapriv, get_bssid(&adapter->mlmepriv));
		if (sta) {
			u8 sta_size = size;

			if (adapter->fix_rx_ampdu_size == RX_AMPDU_SIZE_INVALID)
				sta_size = rtw_min(size, rx_ampdu_size_sta_limit(adapter, sta));
			adj_cnt += rx_ampdu_apply_sta(adapter, sta, accept, sta_size);
		}
		/* TODO: TDLS peer */

	} else if (MLME_IS_AP(adapter) || MLME_IS_MESH(adapter)) {
		_list *phead, *plist;
		u8 peer_num = 0;
		char peers[NUM_STA];
		struct sta_priv *pstapriv = &adapter->stapriv;
		int i;

		_rtw_spinlock_bh(&pstapriv->asoc_list_lock);

		phead = &pstapriv->asoc_list;
		plist = get_next(phead);

		while ((rtw_end_of_queue_search(phead, plist)) == _FALSE) {
			int stainfo_offset;

			sta = LIST_CONTAINOR(plist, struct sta_info, asoc_list);
			plist = get_next(plist);

			stainfo_offset = rtw_stainfo_offset(pstapriv, sta);
			if (stainfo_offset_valid(stainfo_offset))
				peers[peer_num++] = stainfo_offset;
		}

		_rtw_spinunlock_bh(&pstapriv->asoc_list_lock);

		for (i = 0; i < peer_num; i++) {
			sta = rtw_get_stainfo_by_offset(pstapriv, peers[i]);
			if (sta) {
				u8 sta_size = size;

				if (adapter->fix_rx_ampdu_size == RX_AMPDU_SIZE_INVALID)
					sta_size = rtw_min(size, rx_ampdu_size_sta_limit(adapter, sta));
				adj_cnt += rx_ampdu_apply_sta(adapter, sta, accept, sta_size);
			}
		}
	}

	/* TODO: ADHOC */

	return adj_cnt;
}

unsigned int OnAction_back(_adapter *padapter, union recv_frame *precv_frame)
{
	u8 *addr;
	struct sta_info *psta = NULL;
	struct recv_reorder_ctrl *preorder_ctrl;
	unsigned char		*frame_body;
	unsigned char		category, action;
	unsigned short	tid, status, reason_code = 0;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 *pframe = precv_frame->u.hdr.rx_data;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct registry_priv *pregpriv = &padapter->registrypriv;

#ifdef CONFIG_80211N_HT

	RTW_INFO("%s\n", __FUNCTION__);

	/* check RA matches or not	 */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN))
		return _SUCCESS;

#if 0
	/* check A1 matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), get_da(pframe), ETH_ALEN))
		return _SUCCESS;
#endif

	if (!MLME_IN_AP_STATE(pmlmeinfo))
		if (!(pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS))
			return _SUCCESS;

	addr = get_addr2_ptr(pframe);
	psta = rtw_get_stainfo(pstapriv, addr);

	if (psta == NULL)
		return _SUCCESS;

	frame_body = (unsigned char *)(pframe + sizeof(struct rtw_ieee80211_hdr_3addr));

	category = frame_body[0];
	if (category == RTW_WLAN_CATEGORY_BACK) { /* representing Block Ack */
#ifdef CONFIG_TDLS
		if ((psta->tdls_sta_state & TDLS_LINKED_STATE) &&
		    (psta->htpriv.ht_option == _TRUE) &&
		    (psta->htpriv.ampdu_enable == _TRUE))
			RTW_INFO("Recv [%s] from direc link\n", __FUNCTION__);
		else
#endif /* CONFIG_TDLS */
			if (!pmlmeinfo->HT_enable)
				return _SUCCESS;

		action = frame_body[1];
		RTW_INFO("%s, action=%d\n", __FUNCTION__, action);
		switch (action) {
		case RTW_WLAN_ACTION_ADDBA_REQ: /* ADDBA request */

			_rtw_memcpy(&(pmlmeinfo->ADDBA_req), &(frame_body[2]), sizeof(struct ADDBA_request));
			/* process_addba_req(padapter, (u8*)&(pmlmeinfo->ADDBA_req), GetAddr3Ptr(pframe)); */
			process_addba_req(padapter, (u8 *)&(pmlmeinfo->ADDBA_req), addr);

			break;

		case RTW_WLAN_ACTION_ADDBA_RESP: /* ADDBA response */

			/* status = frame_body[3] | (frame_body[4] << 8); */ /* endian issue */
			status = RTW_GET_LE16(&frame_body[3]);
			tid = ((frame_body[5] >> 2) & 0x7);
			if (status == 0) {
				/* successful					 */
				u16 ba_param = RTW_GET_LE16(&frame_body[5]);
				u16 buf_num = ba_param >> 6;

				RTW_INFO("agg_enable %u for TID=%d\n", buf_num, tid);
				psta->htpriv.agg_enable_bitmap |= 1 << tid;
				psta->htpriv.candidate_tid_bitmap &= ~BIT(tid);
				/* amsdu in ampdu */
				if (pregpriv->tx_ampdu_amsdu == 0)
					psta->htpriv.tx_amsdu_enable = _FALSE;
				else if (pregpriv->tx_ampdu_amsdu == 1)
					psta->htpriv.tx_amsdu_enable = _TRUE;
				else {
					if (ba_param & 1)
						psta->htpriv.tx_amsdu_enable = _TRUE;
				}
				#ifndef CONFIG_RTW_LINK_PHL_MASTER
				// 0e4f259e97da0b12ecb3c222aee6fef52b61b7c2 freddie.ho
				rtw_phl_cmd_change_stainfo(padapter->dvobj->phl, psta->phl_sta,
				                           STA_CHG_AGG_NUM,
				                           (u8 *)&buf_num, sizeof(u16),
				                           PHL_CMD_DIRECTLY, 0);
				#endif /* CONFIG_RTW_LINK_PHL_MASTER */

				RTW_INFO("[ADDBA_RESP] from %pM bw:%d tid:%d ampdu_num:%d\n",
								psta->phl_sta->mac_addr, psta->phl_sta->chandef.bw, tid, buf_num);
			} else
				psta->htpriv.agg_enable_bitmap &= ~BIT(tid);

			if (psta->state & WIFI_STA_ALIVE_CHK_STATE) {
				RTW_INFO("%s alive check - rx ADDBA response\n", __func__);
				psta->htpriv.agg_enable_bitmap &= ~BIT(tid);
				psta->expire_to = pstapriv->expire_to;
				psta->state ^= WIFI_STA_ALIVE_CHK_STATE;
			}

			/* RTW_INFO("marc: ADDBA RSP: %x\n", pmlmeinfo->agg_enable_bitmap); */
			break;

		case RTW_WLAN_ACTION_DELBA: /* DELBA */
			if ((frame_body[3] & BIT(3)) == 0) {
				psta->htpriv.agg_enable_bitmap &= ~(1 << ((frame_body[3] >> 4) & 0xf));
				psta->htpriv.candidate_tid_bitmap &= ~(1 << ((frame_body[3] >> 4) & 0xf));

				/* reason_code = frame_body[4] | (frame_body[5] << 8); */
				reason_code = RTW_GET_LE16(&frame_body[4]);
			} else if ((frame_body[3] & BIT(3)) == BIT(3)) {
				tid = (frame_body[3] >> 4) & 0x0F;

				preorder_ctrl = &psta->recvreorder_ctrl[tid];
				preorder_ctrl->enable = _FALSE;
				preorder_ctrl->ampdu_size = RX_AMPDU_SIZE_INVALID;
				rtw_delba_cmd(padapter, addr, tid);
			}

			RTW_INFO("%s(): DELBA: %x(%x)\n", __FUNCTION__, pmlmeinfo->agg_enable_bitmap, reason_code);
			/* todo: how to notify the host while receiving DELETE BA */
			break;

		default:
			break;
		}
	}
#endif /* CONFIG_80211N_HT */
	return _SUCCESS;
}

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
u32 rtw_build_vendor_ie(_adapter *padapter , unsigned char **pframe , u8 mgmt_frame_tyte)
{
	int vendor_ie_num = 0;
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	u32 len = 0;

	for (vendor_ie_num = 0 ; vendor_ie_num < WLAN_MAX_VENDOR_IE_NUM ; vendor_ie_num++) {
		if (pmlmepriv->vendor_ielen[vendor_ie_num] > 0 && pmlmepriv->vendor_ie_mask[vendor_ie_num] & mgmt_frame_tyte) {
			if(pmlmepriv->vendor_mac_is_set[vendor_ie_num] == 0 || (pmlmepriv->vendor_mac_is_set[vendor_ie_num] && pmlmepriv->vendor_mac_is_same[vendor_ie_num]))
			{
				_rtw_memcpy(*pframe , pmlmepriv->vendor_ie[vendor_ie_num] , pmlmepriv->vendor_ielen[vendor_ie_num]);
				*pframe +=  pmlmepriv->vendor_ielen[vendor_ie_num];
				len += pmlmepriv->vendor_ielen[vendor_ie_num];
			}
		}
	}

	return len;
}
#endif

#ifdef CONFIG_NEC_MULTI_STAGE
inline u8 *rtw_set_multistage_ie(_adapter *padapter, u8 *buf, u32 *buf_len)
{
	u8 stage = padapter->registrypriv.wifi_mib.stage;
	u8 VS_STAGE_IE[] = {0x00, 0x0d, 0x02, 0x05, 0x01, 0x00, 0x00};

	if(stage && (stage <= 5))
	{
		VS_STAGE_IE[6] = (1 << (8 - stage));
		return rtw_set_ie(buf, _VENDOR_SPECIFIC_IE_, sizeof(VS_STAGE_IE), VS_STAGE_IE, buf_len);
	}

	return buf;
}
#endif /*CONFIG_NEC_MULTI_STAGE*/

#ifdef CONFIG_NEC_TV_MODE
inline u8 *rtw_set_tvmode_ie(_adapter *padapter, u8 *buf, u32 *buf_len)
{
	u8 VS_TVMODE_IE[] = {0x00, 0x0d, 0x02, 0x03, 0x01, 0x00, 0x00};

	if(padapter->tv_mode_status & BIT0)
		VS_TVMODE_IE[6] |= BIT7;
	else
		VS_TVMODE_IE[6] &= ~BIT7;

	return rtw_set_ie(buf, _VENDOR_SPECIFIC_IE_, sizeof(VS_TVMODE_IE), VS_TVMODE_IE, buf_len);
}
#endif /*CONFIG_NEC_TV_MODE*/

#ifdef CONFIG_P2P
int get_reg_classes_full_count(struct p2p_channels *channel_list)
{
	int cnt = 0;
	int i;

	for (i = 0; i < channel_list->reg_classes; i++)
		cnt += channel_list->reg_class[i].channels;

	return cnt;
}

void issue_p2p_GO_request(_adapter *padapter, u8 *raddr)
{
	struct p2p_channels *ch_list = &(adapter_to_rfctl(padapter)->channel_list);
	unsigned char category = RTW_WLAN_CATEGORY_PUBLIC;
	u8			action = P2P_PUB_ACTION_ACTION;
	u32			p2poui = cpu_to_be32(P2POUI);
	u8			oui_subtype = P2P_GO_NEGO_REQ;
	u8			wpsie[255] = { 0x00 }, p2pie[255] = { 0x00 };
	u8			wpsielen = 0, p2pielen = 0;
	u16			len_channellist_attr = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);


	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	RTW_INFO("[%s] In\n", __FUNCTION__);
	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, adapter_mac_addr(padapter), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *) &(p2poui), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(oui_subtype), &(pattrib->pktlen));
	pwdinfo->negotiation_dialog_token = 1;	/*	Initialize the dialog value */
	pframe = rtw_set_fixed_ie(pframe, 1, &pwdinfo->negotiation_dialog_token, &(pattrib->pktlen));



	/*	WPS Section */
	wpsielen = 0;
	/*	WPS OUI */
	*(u32 *)(wpsie) = cpu_to_be32(WPSOUI);
	wpsielen += 4;

	/*	WPS version */
	/*	Type: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_VER1);
	wpsielen += 2;

	/*	Length: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
	wpsielen += 2;

	/*	Value: */
	wpsie[wpsielen++] = WPS_VERSION_1;	/*	Version 1.0 */

	/*	Device Password ID */
	/*	Type: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_DEVICE_PWID);
	wpsielen += 2;

	/*	Length: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0002);
	wpsielen += 2;

	/*	Value: */

	if (pwdinfo->ui_got_wps_info == P2P_GOT_WPSINFO_PEER_DISPLAY_PIN)
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_USER_SPEC);
	else if (pwdinfo->ui_got_wps_info == P2P_GOT_WPSINFO_SELF_DISPLAY_PIN)
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_REGISTRAR_SPEC);
	else if (pwdinfo->ui_got_wps_info == P2P_GOT_WPSINFO_PBC)
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_PBC);

	wpsielen += 2;

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, wpsielen, (unsigned char *) wpsie, &pattrib->pktlen);


	/*	P2P IE Section. */

	/*	P2P OUI */
	p2pielen = 0;
	p2pie[p2pielen++] = 0x50;
	p2pie[p2pielen++] = 0x6F;
	p2pie[p2pielen++] = 0x9A;
	p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

	/*	Commented by Albert 20110306 */
	/*	According to the P2P Specification, the group negoitation request frame should contain 9 P2P attributes */
	/*	1. P2P Capability */
	/*	2. Group Owner Intent */
	/*	3. Configuration Timeout */
	/*	4. Listen Channel */
	/*	5. Extended Listen Timing */
	/*	6. Intended P2P Interface Address */
	/*	7. Channel List */
	/*	8. P2P Device Info */
	/*	9. Operating Channel */


	/*	P2P Capability */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CAPABILITY;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	/*	Device Capability Bitmap, 1 byte */
	p2pie[p2pielen++] = DMP_P2P_DEVCAP_SUPPORT;

	/*	Group Capability Bitmap, 1 byte */
	if (pwdinfo->persistent_supported)
		p2pie[p2pielen++] = P2P_GRPCAP_CROSS_CONN | P2P_GRPCAP_PERSISTENT_GROUP;
	else
		p2pie[p2pielen++] = P2P_GRPCAP_CROSS_CONN;


	/*	Group Owner Intent */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_GO_INTENT;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0001);
	p2pielen += 2;

	/*	Value: */
	/*	Todo the tie breaker bit. */
	p2pie[p2pielen++] = ((pwdinfo->intent << 1) &  0xFE);

	/*	Configuration Timeout */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CONF_TIMEOUT;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P GO */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P Client */


	/*	Listen Channel */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_LISTEN_CH;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Operating Class */
	p2pie[p2pielen++] = 0x51;	/*	Copy from SD7 */

	/*	Channel Number */
	p2pie[p2pielen++] = pwdinfo->listen_channel;	/*	listening channel number */


	/*	Extended Listen Timing ATTR */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_EX_LISTEN_TIMING;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0004);
	p2pielen += 2;

	/*	Value: */
	/*	Availability Period */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0xFFFF);
	p2pielen += 2;

	/*	Availability Interval */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0xFFFF);
	p2pielen += 2;


	/*	Intended P2P Interface Address */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_INTENDED_IF_ADDR;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(ETH_ALEN);
	p2pielen += 2;

	/*	Value: */
	_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
	p2pielen += ETH_ALEN;


	/*	Channel List */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CH_LIST;

	/* Length: */
	/* Country String(3) */
	/* + ( Operating Class (1) + Number of Channels(1) ) * Operation Classes (?) */
	/* + number of channels in all classes */
	len_channellist_attr = 3
		       + (1 + 1) * (u16)(ch_list->reg_classes)
		       + get_reg_classes_full_count(ch_list);

#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0)
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(5 + 1);
	else
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);
#else

	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);

#endif
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Channel Entry List */

#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0) {
		u8 union_ch = rtw_mi_get_union_chan(padapter);

		/*	Operating Class */
		if (union_ch > 14) {
			if (union_ch >= 149)
				p2pie[p2pielen++] = 0x7c;
			else
				p2pie[p2pielen++] = 0x73;
		} else
			p2pie[p2pielen++] = 0x51;


		/*	Number of Channels */
		/*	Just support 1 channel and this channel is AP's channel */
		p2pie[p2pielen++] = 1;

		/*	Channel List */
		p2pie[p2pielen++] = union_ch;
	} else
#endif /* CONFIG_CONCURRENT_MODE */
	{
		int i, j;
		for (j = 0; j < ch_list->reg_classes; j++) {
			/*	Operating Class */
			p2pie[p2pielen++] = ch_list->reg_class[j].reg_class;

			/*	Number of Channels */
			p2pie[p2pielen++] = ch_list->reg_class[j].channels;

			/*	Channel List */
			for (i = 0; i < ch_list->reg_class[j].channels; i++)
				p2pie[p2pielen++] = ch_list->reg_class[j].channel[i];
		}
	}

	/*	Device Info */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_DEVICE_INFO;

	/*	Length: */
	/*	21->P2P Device Address (6bytes) + Config Methods (2bytes) + Primary Device Type (8bytes)  */
	/*	+ NumofSecondDevType (1byte) + WPS Device Name ID field (2bytes) + WPS Device Name Len field (2bytes) */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(21 + pwdinfo->device_name_len);
	p2pielen += 2;

	/*	Value: */
	/*	P2P Device Address */
	_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
	p2pielen += ETH_ALEN;

	/*	Config Method */
	/*	This field should be big endian. Noted by P2P specification. */

	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(pwdinfo->supported_wps_cm);

	p2pielen += 2;

	/*	Primary Device Type */
	/*	Category ID */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_CID_MULIT_MEDIA);
	p2pielen += 2;

	/*	OUI */
	*(u32 *)(p2pie + p2pielen) = cpu_to_be32(WPSOUI);
	p2pielen += 4;

	/*	Sub Category ID */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_SCID_MEDIA_SERVER);
	p2pielen += 2;

	/*	Number of Secondary Device Types */
	p2pie[p2pielen++] = 0x00;	/*	No Secondary Device Type List */

	/*	Device Name */
	/*	Type: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
	p2pielen += 2;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(pwdinfo->device_name_len);
	p2pielen += 2;

	/*	Value: */
	_rtw_memcpy(p2pie + p2pielen, pwdinfo->device_name , pwdinfo->device_name_len);
	p2pielen += pwdinfo->device_name_len;


	/*	Operating Channel */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_OPERATING_CH;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Operating Class */
	if (pwdinfo->operating_channel <= 14) {
		/*	Operating Class */
		p2pie[p2pielen++] = 0x51;
	} else if ((pwdinfo->operating_channel >= 36) && (pwdinfo->operating_channel <= 48)) {
		/*	Operating Class */
		p2pie[p2pielen++] = 0x73;
	} else {
		/*	Operating Class */
		p2pie[p2pielen++] = 0x7c;
	}

	/*	Channel Number */
	p2pie[p2pielen++] = pwdinfo->operating_channel;	/*	operating channel number */

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);

#ifdef CONFIG_WFD
	wfdielen = build_nego_req_wfd_ie(pwdinfo, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	return;

}


void issue_p2p_GO_response(_adapter *padapter, u8 *raddr, u8 *frame_body, uint len, u8 result)
{
	struct p2p_channels *ch_list = &(adapter_to_rfctl(padapter)->channel_list);
	unsigned char category = RTW_WLAN_CATEGORY_PUBLIC;
	u8			action = P2P_PUB_ACTION_ACTION;
	u32			p2poui = cpu_to_be32(P2POUI);
	u8			oui_subtype = P2P_GO_NEGO_RESP;
	u8			wpsie[255] = { 0x00 }, p2pie[255] = { 0x00 };
	u8			p2pielen = 0;
	uint			wpsielen = 0;
	u16			wps_devicepassword_id = 0x0000;
	uint			wps_devicepassword_id_len = 0;
	u16			len_channellist_attr = 0;

	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);

#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	RTW_INFO("[%s] In, result = %d\n", __FUNCTION__,  result);
	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, adapter_mac_addr(padapter), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *) &(p2poui), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(oui_subtype), &(pattrib->pktlen));
	pwdinfo->negotiation_dialog_token = frame_body[7];	/*	The Dialog Token of provisioning discovery request frame. */
	pframe = rtw_set_fixed_ie(pframe, 1, &(pwdinfo->negotiation_dialog_token), &(pattrib->pktlen));

	/*	Commented by Albert 20110328 */
	/*	Try to get the device password ID from the WPS IE of group negotiation request frame */
	/*	WiFi Direct test plan 5.1.15 */
	rtw_get_wps_ie(frame_body + _PUBLIC_ACTION_IE_OFFSET_, len - _PUBLIC_ACTION_IE_OFFSET_, wpsie, &wpsielen);
	wps_devicepassword_id_len = sizeof(wps_devicepassword_id);
	rtw_get_wps_attr_content(wpsie, wpsielen, WPS_ATTR_DEVICE_PWID, (u8 *) &wps_devicepassword_id, &wps_devicepassword_id_len);
	wps_devicepassword_id = be16_to_cpu(wps_devicepassword_id);

	_rtw_memset(wpsie, 0x00, 255);
	wpsielen = 0;

	/*	WPS Section */
	wpsielen = 0;
	/*	WPS OUI */
	*(u32 *)(wpsie) = cpu_to_be32(WPSOUI);
	wpsielen += 4;

	/*	WPS version */
	/*	Type: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_VER1);
	wpsielen += 2;

	/*	Length: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
	wpsielen += 2;

	/*	Value: */
	wpsie[wpsielen++] = WPS_VERSION_1;	/*	Version 1.0 */

	/*	Device Password ID */
	/*	Type: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_DEVICE_PWID);
	wpsielen += 2;

	/*	Length: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0002);
	wpsielen += 2;

	/*	Value: */
	if (wps_devicepassword_id == WPS_DPID_USER_SPEC)
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_REGISTRAR_SPEC);
	else if (wps_devicepassword_id == WPS_DPID_REGISTRAR_SPEC)
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_USER_SPEC);
	else
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_PBC);
	wpsielen += 2;

	/*	Commented by Kurt 20120113 */
	/*	If some device wants to do p2p handshake without sending prov_disc_req */
	/*	We have to get peer_req_cm from here. */
	if (_rtw_memcmp(pwdinfo->rx_prov_disc_info.strconfig_method_desc_of_prov_disc_req, "000", 3)) {
		if (wps_devicepassword_id == WPS_DPID_USER_SPEC)
			_rtw_memcpy(pwdinfo->rx_prov_disc_info.strconfig_method_desc_of_prov_disc_req, "dis", 3);
		else if (wps_devicepassword_id == WPS_DPID_REGISTRAR_SPEC)
			_rtw_memcpy(pwdinfo->rx_prov_disc_info.strconfig_method_desc_of_prov_disc_req, "pad", 3);
		else
			_rtw_memcpy(pwdinfo->rx_prov_disc_info.strconfig_method_desc_of_prov_disc_req, "pbc", 3);
	}

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, wpsielen, (unsigned char *) wpsie, &pattrib->pktlen);


	/*	P2P IE Section. */

	/*	P2P OUI */
	p2pielen = 0;
	p2pie[p2pielen++] = 0x50;
	p2pie[p2pielen++] = 0x6F;
	p2pie[p2pielen++] = 0x9A;
	p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

	/*	Commented by Albert 20100908 */
	/*	According to the P2P Specification, the group negoitation response frame should contain 9 P2P attributes */
	/*	1. Status */
	/*	2. P2P Capability */
	/*	3. Group Owner Intent */
	/*	4. Configuration Timeout */
	/*	5. Operating Channel */
	/*	6. Intended P2P Interface Address */
	/*	7. Channel List */
	/*	8. Device Info */
	/*	9. Group ID	( Only GO ) */


	/*	ToDo: */

	/*	P2P Status */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_STATUS;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0001);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = result;

	/*	P2P Capability */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CAPABILITY;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	/*	Device Capability Bitmap, 1 byte */

	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_CLIENT)) {
		/*	Commented by Albert 2011/03/08 */
		/*	According to the P2P specification */
		/*	if the sending device will be client, the P2P Capability should be reserved of group negotation response frame */
		p2pie[p2pielen++] = 0;
	} else {
		/*	Be group owner or meet the error case */
		p2pie[p2pielen++] = DMP_P2P_DEVCAP_SUPPORT;
	}

	/*	Group Capability Bitmap, 1 byte */
	if (pwdinfo->persistent_supported)
		p2pie[p2pielen++] = P2P_GRPCAP_CROSS_CONN | P2P_GRPCAP_PERSISTENT_GROUP;
	else
		p2pie[p2pielen++] = P2P_GRPCAP_CROSS_CONN;

	/*	Group Owner Intent */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_GO_INTENT;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0001);
	p2pielen += 2;

	/*	Value: */
	if (pwdinfo->peer_intent & 0x01) {
		/*	Peer's tie breaker bit is 1, our tie breaker bit should be 0 */
		p2pie[p2pielen++] = (pwdinfo->intent << 1);
	} else {
		/*	Peer's tie breaker bit is 0, our tie breaker bit should be 1 */
		p2pie[p2pielen++] = ((pwdinfo->intent << 1) | BIT(0));
	}


	/*	Configuration Timeout */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CONF_TIMEOUT;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P GO */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P Client */

	/*	Operating Channel */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_OPERATING_CH;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Operating Class */
	if (pwdinfo->operating_channel <= 14) {
		/*	Operating Class */
		p2pie[p2pielen++] = 0x51;
	} else if ((pwdinfo->operating_channel >= 36) && (pwdinfo->operating_channel <= 48)) {
		/*	Operating Class */
		p2pie[p2pielen++] = 0x73;
	} else {
		/*	Operating Class */
		p2pie[p2pielen++] = 0x7c;
	}

	/*	Channel Number */
	p2pie[p2pielen++] = pwdinfo->operating_channel;	/*	operating channel number */

	/*	Intended P2P Interface Address	 */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_INTENDED_IF_ADDR;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(ETH_ALEN);
	p2pielen += 2;

	/*	Value: */
	_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
	p2pielen += ETH_ALEN;

	/*	Channel List */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CH_LIST;

	/* Country String(3) */
	/* + ( Operating Class (1) + Number of Channels(1) ) * Operation Classes (?) */
	/* + number of channels in all classes */
	len_channellist_attr = 3
		       + (1 + 1) * (u16)ch_list->reg_classes
		       + get_reg_classes_full_count(ch_list);

#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0)
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(5 + 1);
	else
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);
#else
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);

#endif
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Channel Entry List */

#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0) {

		u8 union_chan = rtw_mi_get_union_chan(padapter);

		/*Operating Class*/
		if (union_chan > 14) {
			if (union_chan >= 149)
				p2pie[p2pielen++] = 0x7c;
			else
				p2pie[p2pielen++] = 0x73;

		} else
			p2pie[p2pielen++] = 0x51;

		/*	Number of Channels
			Just support 1 channel and this channel is AP's channel*/
		p2pie[p2pielen++] = 1;

		/*Channel List*/
		p2pie[p2pielen++] = union_chan;
	} else
#endif /* CONFIG_CONCURRENT_MODE */
	{
		int i, j;
		for (j = 0; j < ch_list->reg_classes; j++) {
			/*	Operating Class */
			p2pie[p2pielen++] = ch_list->reg_class[j].reg_class;

			/*	Number of Channels */
			p2pie[p2pielen++] = ch_list->reg_class[j].channels;

			/*	Channel List */
			for (i = 0; i < ch_list->reg_class[j].channels; i++)
				p2pie[p2pielen++] = ch_list->reg_class[j].channel[i];
		}
	}

	/*	Device Info */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_DEVICE_INFO;

	/*	Length: */
	/*	21->P2P Device Address (6bytes) + Config Methods (2bytes) + Primary Device Type (8bytes)  */
	/*	+ NumofSecondDevType (1byte) + WPS Device Name ID field (2bytes) + WPS Device Name Len field (2bytes) */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(21 + pwdinfo->device_name_len);
	p2pielen += 2;

	/*	Value: */
	/*	P2P Device Address */
	_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
	p2pielen += ETH_ALEN;

	/*	Config Method */
	/*	This field should be big endian. Noted by P2P specification. */

	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(pwdinfo->supported_wps_cm);

	p2pielen += 2;

	/*	Primary Device Type */
	/*	Category ID */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_CID_MULIT_MEDIA);
	p2pielen += 2;

	/*	OUI */
	*(u32 *)(p2pie + p2pielen) = cpu_to_be32(WPSOUI);
	p2pielen += 4;

	/*	Sub Category ID */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_SCID_MEDIA_SERVER);
	p2pielen += 2;

	/*	Number of Secondary Device Types */
	p2pie[p2pielen++] = 0x00;	/*	No Secondary Device Type List */

	/*	Device Name */
	/*	Type: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
	p2pielen += 2;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(pwdinfo->device_name_len);
	p2pielen += 2;

	/*	Value: */
	_rtw_memcpy(p2pie + p2pielen, pwdinfo->device_name , pwdinfo->device_name_len);
	p2pielen += pwdinfo->device_name_len;

	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
		/*	Group ID Attribute */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_GROUP_ID;

		/*	Length: */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(ETH_ALEN + pwdinfo->nego_ssidlen);
		p2pielen += 2;

		/*	Value: */
		/*	p2P Device Address */
		_rtw_memcpy(p2pie + p2pielen , pwdinfo->device_addr, ETH_ALEN);
		p2pielen += ETH_ALEN;

		/*	SSID */
		_rtw_memcpy(p2pie + p2pielen, pwdinfo->nego_ssid, pwdinfo->nego_ssidlen);
		p2pielen += pwdinfo->nego_ssidlen;

	}

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);

#ifdef CONFIG_WFD
	wfdielen = build_nego_resp_wfd_ie(pwdinfo, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	return;

}

void issue_p2p_GO_confirm(_adapter *padapter, u8 *raddr, u8 result)
{

	unsigned char category = RTW_WLAN_CATEGORY_PUBLIC;
	u8			action = P2P_PUB_ACTION_ACTION;
	u32			p2poui = cpu_to_be32(P2POUI);
	u8			oui_subtype = P2P_GO_NEGO_CONF;
	u8			p2pie[255] = { 0x00 };
	u8			p2pielen = 0;

	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	RTW_INFO("[%s] In\n", __FUNCTION__);
	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, adapter_mac_addr(padapter), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *) &(p2poui), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(oui_subtype), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(pwdinfo->negotiation_dialog_token), &(pattrib->pktlen));



	/*	P2P IE Section. */

	/*	P2P OUI */
	p2pielen = 0;
	p2pie[p2pielen++] = 0x50;
	p2pie[p2pielen++] = 0x6F;
	p2pie[p2pielen++] = 0x9A;
	p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

	/*	Commented by Albert 20110306 */
	/*	According to the P2P Specification, the group negoitation request frame should contain 5 P2P attributes */
	/*	1. Status */
	/*	2. P2P Capability */
	/*	3. Operating Channel */
	/*	4. Channel List */
	/*	5. Group ID	( if this WiFi is GO ) */

	/*	P2P Status */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_STATUS;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0001);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = result;

	/*	P2P Capability */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CAPABILITY;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	/*	Device Capability Bitmap, 1 byte */
	p2pie[p2pielen++] = DMP_P2P_DEVCAP_SUPPORT;

	/*	Group Capability Bitmap, 1 byte */
	if (pwdinfo->persistent_supported)
		p2pie[p2pielen++] = P2P_GRPCAP_CROSS_CONN | P2P_GRPCAP_PERSISTENT_GROUP;
	else
		p2pie[p2pielen++] = P2P_GRPCAP_CROSS_CONN;


	/*	Operating Channel */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_OPERATING_CH;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;


	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_CLIENT)) {
		if (pwdinfo->peer_operating_ch <= 14) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x51;
		} else if ((pwdinfo->peer_operating_ch >= 36) && (pwdinfo->peer_operating_ch <= 48)) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x73;
		} else {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x7c;
		}

		p2pie[p2pielen++] = pwdinfo->peer_operating_ch;
	} else {
		if (pwdinfo->operating_channel <= 14) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x51;
		} else if ((pwdinfo->operating_channel >= 36) && (pwdinfo->operating_channel <= 48)) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x73;
		} else {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x7c;
		}

		/*	Channel Number */
		p2pie[p2pielen++] = pwdinfo->operating_channel;		/*	Use the listen channel as the operating channel */
	}


	/*	Channel List */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CH_LIST;

	*(u16 *)(p2pie + p2pielen) = 6;
	p2pielen += 2;

	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Value: */
	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_CLIENT)) {
		if (pwdinfo->peer_operating_ch <= 14) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x51;
		} else if ((pwdinfo->peer_operating_ch >= 36) && (pwdinfo->peer_operating_ch <= 48)) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x73;
		} else {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x7c;
		}
		p2pie[p2pielen++] = 1;
		p2pie[p2pielen++] = pwdinfo->peer_operating_ch;
	} else {
		if (pwdinfo->operating_channel <= 14) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x51;
		} else if ((pwdinfo->operating_channel >= 36) && (pwdinfo->operating_channel <= 48)) {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x73;
		} else {
			/*	Operating Class */
			p2pie[p2pielen++] = 0x7c;
		}

		/*	Channel Number */
		p2pie[p2pielen++] = 1;
		p2pie[p2pielen++] = pwdinfo->operating_channel;		/*	Use the listen channel as the operating channel */
	}

	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
		/*	Group ID Attribute */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_GROUP_ID;

		/*	Length: */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(ETH_ALEN + pwdinfo->nego_ssidlen);
		p2pielen += 2;

		/*	Value: */
		/*	p2P Device Address */
		_rtw_memcpy(p2pie + p2pielen , pwdinfo->device_addr, ETH_ALEN);
		p2pielen += ETH_ALEN;

		/*	SSID */
		_rtw_memcpy(p2pie + p2pielen, pwdinfo->nego_ssid, pwdinfo->nego_ssidlen);
		p2pielen += pwdinfo->nego_ssidlen;
	}

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);

#ifdef CONFIG_WFD
	wfdielen = build_nego_confirm_wfd_ie(pwdinfo, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	return;

}

void issue_p2p_invitation_request(_adapter *padapter, u8 *raddr)
{
	struct p2p_channels *ch_list = &(adapter_to_rfctl(padapter)->channel_list);
	unsigned char category = RTW_WLAN_CATEGORY_PUBLIC;
	u8			action = P2P_PUB_ACTION_ACTION;
	u32			p2poui = cpu_to_be32(P2POUI);
	u8			oui_subtype = P2P_INVIT_REQ;
	u8			p2pie[255] = { 0x00 };
	u8			p2pielen = 0;
	u8			dialogToken = 3;
	u16			len_channellist_attr = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);


	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, raddr,  ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *) &(p2poui), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(oui_subtype), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(dialogToken), &(pattrib->pktlen));

	/*	P2P IE Section. */

	/*	P2P OUI */
	p2pielen = 0;
	p2pie[p2pielen++] = 0x50;
	p2pie[p2pielen++] = 0x6F;
	p2pie[p2pielen++] = 0x9A;
	p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

	/*	Commented by Albert 20101011 */
	/*	According to the P2P Specification, the P2P Invitation request frame should contain 7 P2P attributes */
	/*	1. Configuration Timeout */
	/*	2. Invitation Flags */
	/*	3. Operating Channel	( Only GO ) */
	/*	4. P2P Group BSSID	( Should be included if I am the GO ) */
	/*	5. Channel List */
	/*	6. P2P Group ID */
	/*	7. P2P Device Info */

	/*	Configuration Timeout */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CONF_TIMEOUT;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P GO */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P Client */

	/*	Invitation Flags */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_INVITATION_FLAGS;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0001);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = P2P_INVITATION_FLAGS_PERSISTENT;


	/*	Operating Channel */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_OPERATING_CH;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Operating Class */
	if (pwdinfo->invitereq_info.operating_ch <= 14)
		p2pie[p2pielen++] = 0x51;
	else if ((pwdinfo->invitereq_info.operating_ch >= 36) && (pwdinfo->invitereq_info.operating_ch <= 48))
		p2pie[p2pielen++] = 0x73;
	else
		p2pie[p2pielen++] = 0x7c;

	/*	Channel Number */
	p2pie[p2pielen++] = pwdinfo->invitereq_info.operating_ch;	/*	operating channel number */

	if (_rtw_memcmp(adapter_mac_addr(padapter), pwdinfo->invitereq_info.go_bssid, ETH_ALEN)) {
		/*	P2P Group BSSID */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_GROUP_BSSID;

		/*	Length: */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(ETH_ALEN);
		p2pielen += 2;

		/*	Value: */
		/*	P2P Device Address for GO */
		_rtw_memcpy(p2pie + p2pielen, pwdinfo->invitereq_info.go_bssid, ETH_ALEN);
		p2pielen += ETH_ALEN;
	}

	/*	Channel List */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CH_LIST;


	/*	Length: */
	/* Country String(3) */
	/* + ( Operating Class (1) + Number of Channels(1) ) * Operation Classes (?) */
	/* + number of channels in all classes */
	len_channellist_attr = 3
		       + (1 + 1) * (u16)ch_list->reg_classes
		       + get_reg_classes_full_count(ch_list);

#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0)
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(5 + 1);
	else
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);
#else
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);
#endif
	p2pielen += 2;

	/*	Value: */
	/*	Country String */
	p2pie[p2pielen++] = 'X';
	p2pie[p2pielen++] = 'X';

	/*	The third byte should be set to 0x04. */
	/*	Described in the "Operating Channel Attribute" section. */
	p2pie[p2pielen++] = 0x04;

	/*	Channel Entry List */
#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0) {
		u8 union_ch =  rtw_mi_get_union_chan(padapter);

		/*	Operating Class */
		if (union_ch > 14) {
			if (union_ch >= 149)
				p2pie[p2pielen++] = 0x7c;
			else
				p2pie[p2pielen++] = 0x73;
		} else
			p2pie[p2pielen++] = 0x51;


		/*	Number of Channels */
		/*	Just support 1 channel and this channel is AP's channel */
		p2pie[p2pielen++] = 1;

		/*	Channel List */
		p2pie[p2pielen++] = union_ch;
	} else
#endif /* CONFIG_CONCURRENT_MODE */
	{
		int i, j;
		for (j = 0; j < ch_list->reg_classes; j++) {
			/*	Operating Class */
			p2pie[p2pielen++] = ch_list->reg_class[j].reg_class;

			/*	Number of Channels */
			p2pie[p2pielen++] = ch_list->reg_class[j].channels;

			/*	Channel List */
			for (i = 0; i < ch_list->reg_class[j].channels; i++)
				p2pie[p2pielen++] = ch_list->reg_class[j].channel[i];
		}
	}


	/*	P2P Group ID */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_GROUP_ID;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(6 + pwdinfo->invitereq_info.ssidlen);
	p2pielen += 2;

	/*	Value: */
	/*	P2P Device Address for GO */
	_rtw_memcpy(p2pie + p2pielen, pwdinfo->invitereq_info.go_bssid, ETH_ALEN);
	p2pielen += ETH_ALEN;

	/*	SSID */
	_rtw_memcpy(p2pie + p2pielen, pwdinfo->invitereq_info.go_ssid, pwdinfo->invitereq_info.ssidlen);
	p2pielen += pwdinfo->invitereq_info.ssidlen;


	/*	Device Info */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_DEVICE_INFO;

	/*	Length: */
	/*	21->P2P Device Address (6bytes) + Config Methods (2bytes) + Primary Device Type (8bytes)  */
	/*	+ NumofSecondDevType (1byte) + WPS Device Name ID field (2bytes) + WPS Device Name Len field (2bytes) */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(21 + pwdinfo->device_name_len);
	p2pielen += 2;

	/*	Value: */
	/*	P2P Device Address */
	_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
	p2pielen += ETH_ALEN;

	/*	Config Method */
	/*	This field should be big endian. Noted by P2P specification. */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_CONFIG_METHOD_DISPLAY);
	p2pielen += 2;

	/*	Primary Device Type */
	/*	Category ID */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_CID_MULIT_MEDIA);
	p2pielen += 2;

	/*	OUI */
	*(u32 *)(p2pie + p2pielen) = cpu_to_be32(WPSOUI);
	p2pielen += 4;

	/*	Sub Category ID */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_SCID_MEDIA_SERVER);
	p2pielen += 2;

	/*	Number of Secondary Device Types */
	p2pie[p2pielen++] = 0x00;	/*	No Secondary Device Type List */

	/*	Device Name */
	/*	Type: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
	p2pielen += 2;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_be16(pwdinfo->device_name_len);
	p2pielen += 2;

	/*	Value: */
	_rtw_memcpy(p2pie + p2pielen, pwdinfo->device_name, pwdinfo->device_name_len);
	p2pielen += pwdinfo->device_name_len;

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);

#ifdef CONFIG_WFD
	wfdielen = build_invitation_req_wfd_ie(pwdinfo, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	return;

}

void issue_p2p_invitation_response(_adapter *padapter, u8 *raddr, u8 dialogToken, u8 status_code)
{
	struct p2p_channels *ch_list = &(adapter_to_rfctl(padapter)->channel_list);
	unsigned char category = RTW_WLAN_CATEGORY_PUBLIC;
	u8			action = P2P_PUB_ACTION_ACTION;
	u32			p2poui = cpu_to_be32(P2POUI);
	u8			oui_subtype = P2P_INVIT_RESP;
	u8			p2pie[255] = { 0x00 };
	u8			p2pielen = 0;
	u16			len_channellist_attr = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);


	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, raddr,  ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *) &(p2poui), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(oui_subtype), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(dialogToken), &(pattrib->pktlen));

	/*	P2P IE Section. */

	/*	P2P OUI */
	p2pielen = 0;
	p2pie[p2pielen++] = 0x50;
	p2pie[p2pielen++] = 0x6F;
	p2pie[p2pielen++] = 0x9A;
	p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

	/*	Commented by Albert 20101005 */
	/*	According to the P2P Specification, the P2P Invitation response frame should contain 5 P2P attributes */
	/*	1. Status */
	/*	2. Configuration Timeout */
	/*	3. Operating Channel	( Only GO ) */
	/*	4. P2P Group BSSID	( Only GO ) */
	/*	5. Channel List */

	/*	P2P Status */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_STATUS;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0001);
	p2pielen += 2;

	/*	Value: */
	/*	When status code is P2P_STATUS_FAIL_INFO_UNAVAILABLE. */
	/*	Sent the event receiving the P2P Invitation Req frame to DMP UI. */
	/*	DMP had to compare the MAC address to find out the profile. */
	/*	So, the WiFi driver will send the P2P_STATUS_FAIL_INFO_UNAVAILABLE to NB. */
	/*	If the UI found the corresponding profile, the WiFi driver sends the P2P Invitation Req */
	/*	to NB to rebuild the persistent group. */
	p2pie[p2pielen++] = status_code;

	/*	Configuration Timeout */
	/*	Type: */
	p2pie[p2pielen++] = P2P_ATTR_CONF_TIMEOUT;

	/*	Length: */
	*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
	p2pielen += 2;

	/*	Value: */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P GO */
	p2pie[p2pielen++] = 200;	/*	2 seconds needed to be the P2P Client */

	if (status_code == P2P_STATUS_SUCCESS) {
		if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
			/*	The P2P Invitation request frame asks this Wi-Fi device to be the P2P GO */
			/*	In this case, the P2P Invitation response frame should carry the two more P2P attributes. */
			/*	First one is operating channel attribute. */
			/*	Second one is P2P Group BSSID attribute. */

			/*	Operating Channel */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_OPERATING_CH;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
			p2pielen += 2;

			/*	Value: */
			/*	Country String */
			p2pie[p2pielen++] = 'X';
			p2pie[p2pielen++] = 'X';

			/*	The third byte should be set to 0x04. */
			/*	Described in the "Operating Channel Attribute" section. */
			p2pie[p2pielen++] = 0x04;

			/*	Operating Class */
			p2pie[p2pielen++] = 0x51;	/*	Copy from SD7 */

			/*	Channel Number */
			p2pie[p2pielen++] = pwdinfo->operating_channel;	/*	operating channel number */


			/*	P2P Group BSSID */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_GROUP_BSSID;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(ETH_ALEN);
			p2pielen += 2;

			/*	Value: */
			/*	P2P Device Address for GO */
			_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
			p2pielen += ETH_ALEN;

		}

		/*	Channel List */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_CH_LIST;

		/*	Length: */
		/* Country String(3) */
		/* + ( Operating Class (1) + Number of Channels(1) ) * Operation Classes (?) */
		/* + number of channels in all classes */
		len_channellist_attr = 3
			+ (1 + 1) * (u16)ch_list->reg_classes
			+ get_reg_classes_full_count(ch_list);

#ifdef CONFIG_CONCURRENT_MODE
		if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0)
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(5 + 1);
		else
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);
#else
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(len_channellist_attr);
#endif
		p2pielen += 2;

		/*	Value: */
		/*	Country String */
		p2pie[p2pielen++] = 'X';
		p2pie[p2pielen++] = 'X';

		/*	The third byte should be set to 0x04. */
		/*	Described in the "Operating Channel Attribute" section. */
		p2pie[p2pielen++] = 0x04;

		/*	Channel Entry List */
#ifdef CONFIG_CONCURRENT_MODE
		if (rtw_mi_check_status(padapter, MI_LINKED) && padapter->registrypriv.full_ch_in_p2p_handshake == 0) {
			u8 union_ch = rtw_mi_get_union_chan(padapter);

			/*	Operating Class */
			if (union_ch > 14) {
				if (union_ch >= 149)
					p2pie[p2pielen++]  = 0x7c;
				else
					p2pie[p2pielen++] = 0x73;
			} else
				p2pie[p2pielen++] = 0x51;


			/*	Number of Channels */
			/*	Just support 1 channel and this channel is AP's channel */
			p2pie[p2pielen++] = 1;

			/*	Channel List */
			p2pie[p2pielen++] = union_ch;
		} else
#endif /* CONFIG_CONCURRENT_MODE */
		{
			int i, j;
			for (j = 0; j < ch_list->reg_classes; j++) {
				/*	Operating Class */
				p2pie[p2pielen++] = ch_list->reg_class[j].reg_class;

				/*	Number of Channels */
				p2pie[p2pielen++] = ch_list->reg_class[j].channels;

				/*	Channel List */
				for (i = 0; i < ch_list->reg_class[j].channels; i++)
					p2pie[p2pielen++] = ch_list->reg_class[j].channel[i];
			}
		}
	}

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);

#ifdef CONFIG_WFD
	wfdielen = build_invitation_resp_wfd_ie(pwdinfo, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	return;

}

void issue_p2p_provision_request(_adapter *padapter, u8 *pssid, u8 ussidlen, u8 *pdev_raddr)
{
	unsigned char category = RTW_WLAN_CATEGORY_PUBLIC;
	u8			action = P2P_PUB_ACTION_ACTION;
	u8			dialogToken = 1;
	u32			p2poui = cpu_to_be32(P2POUI);
	u8			oui_subtype = P2P_PROVISION_DISC_REQ;
	u8			wpsie[100] = { 0x00 };
	u8			wpsielen = 0;
	u32			p2pielen = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);


	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	RTW_INFO("[%s] In\n", __FUNCTION__);
	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, pdev_raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, pdev_raddr, ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *) &(p2poui), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(oui_subtype), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(dialogToken), &(pattrib->pktlen));

	p2pielen = build_prov_disc_request_p2p_ie(pwdinfo, pframe, pssid, ussidlen, pdev_raddr);

	pframe += p2pielen;
	pattrib->pktlen += p2pielen;

	wpsielen = 0;
	/*	WPS OUI */
	*(u32 *)(wpsie) = cpu_to_be32(WPSOUI);
	wpsielen += 4;

	/*	WPS version */
	/*	Type: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_VER1);
	wpsielen += 2;

	/*	Length: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
	wpsielen += 2;

	/*	Value: */
	wpsie[wpsielen++] = WPS_VERSION_1;	/*	Version 1.0 */

	/*	Config Method */
	/*	Type: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_CONF_METHOD);
	wpsielen += 2;

	/*	Length: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0002);
	wpsielen += 2;

	/*	Value: */
	*(u16 *)(wpsie + wpsielen) = cpu_to_be16(pwdinfo->tx_prov_disc_info.wps_config_method_request);
	wpsielen += 2;

	pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, wpsielen, (unsigned char *) wpsie, &pattrib->pktlen);


#ifdef CONFIG_WFD
	wfdielen = build_provdisc_req_wfd_ie(pwdinfo, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	return;

}


u8 is_matched_in_profilelist(u8 *peermacaddr, struct profile_info *profileinfo)
{
	u8 i, match_result = 0;

	RTW_INFO("[%s] peermac = %.2X %.2X %.2X %.2X %.2X %.2X\n", __FUNCTION__,
		peermacaddr[0], peermacaddr[1], peermacaddr[2], peermacaddr[3], peermacaddr[4], peermacaddr[5]);

	for (i = 0; i < P2P_MAX_PERSISTENT_GROUP_NUM; i++, profileinfo++) {
		RTW_INFO("[%s] profileinfo_mac = %.2X %.2X %.2X %.2X %.2X %.2X\n", __FUNCTION__,
			profileinfo->peermac[0], profileinfo->peermac[1], profileinfo->peermac[2], profileinfo->peermac[3], profileinfo->peermac[4], profileinfo->peermac[5]);
		if (_rtw_memcmp(peermacaddr, profileinfo->peermac, ETH_ALEN)) {
			match_result = 1;
			RTW_INFO("[%s] Match!\n", __FUNCTION__);
			break;
		}
	}

	return match_result ;
}

void issue_probersp_p2p(_adapter *padapter, unsigned char *da)
{
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	unsigned char					*mac;
	struct xmit_priv	*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	/* WLAN_BSSID_EX 		*cur_network = &(pmlmeinfo->network); */
	u16					beacon_interval = 100;
	u16					capInfo = 0;
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
	u8					wpsie[255] = { 0x00 };
	u32					wpsielen = 0, p2pielen = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	/* RTW_INFO("%s\n", __FUNCTION__); */

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	if (IS_CCK_RATE(pattrib->rate)) {
		/* force OFDM 6M rate */
		pattrib->rate = MGN_6M;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	mac = adapter_mac_addr(padapter);

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;
	_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, mac, ETH_ALEN);

	/*	Use the device address for BSSID field.	 */
	_rtw_memcpy(pwlanhdr->addr3, mac, ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(fctrl, WIFI_PROBERSP);

	pattrib->hdrlen = sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = pattrib->hdrlen;
	pframe += pattrib->hdrlen;

	/* timestamp will be inserted by hardware */
	pframe += 8;
	pattrib->pktlen += 8;

	/* beacon interval: 2 bytes */
	_rtw_memcpy(pframe, (unsigned char *) &beacon_interval, 2);
	pframe += 2;
	pattrib->pktlen += 2;

	/*	capability info: 2 bytes */
	/*	ESS and IBSS bits must be 0 (defined in the 3.1.2.1.1 of WiFi Direct Spec) */
	capInfo |= cap_ShortPremble;
	capInfo |= cap_ShortSlot;

	_rtw_memcpy(pframe, (unsigned char *) &capInfo, 2);
	pframe += 2;
	pattrib->pktlen += 2;


	/* SSID */
	pframe = rtw_set_ie(pframe, _SSID_IE_, 7, pwdinfo->p2p_wildcard_ssid, &pattrib->pktlen);

	/* supported rates... */
	/*	Use the OFDM rate in the P2P probe response frame. ( 6(B), 9(B), 12, 18, 24, 36, 48, 54 ) */
	pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_, 8, pwdinfo->support_rate, &pattrib->pktlen);

	/* DS parameter set */
	pframe = rtw_set_ie(pframe, _DSSET_IE_, 1, (unsigned char *)&pwdinfo->listen_channel, &pattrib->pktlen);

#ifdef CONFIG_IOCTL_CFG80211
	if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211) {
		if (pmlmepriv->wps_probe_resp_ie != NULL && pmlmepriv->p2p_probe_resp_ie != NULL) {
			/* WPS IE */
			_rtw_memcpy(pframe, pmlmepriv->wps_probe_resp_ie, pmlmepriv->wps_probe_resp_ie_len);
			pattrib->pktlen += pmlmepriv->wps_probe_resp_ie_len;
			pframe += pmlmepriv->wps_probe_resp_ie_len;

			/* P2P IE */
			_rtw_memcpy(pframe, pmlmepriv->p2p_probe_resp_ie, pmlmepriv->p2p_probe_resp_ie_len);
			pattrib->pktlen += pmlmepriv->p2p_probe_resp_ie_len;
			pframe += pmlmepriv->p2p_probe_resp_ie_len;
		}
	} else
#endif /* CONFIG_IOCTL_CFG80211		 */
	{

		/*	Todo: WPS IE */
		/*	Noted by Albert 20100907 */
		/*	According to the WPS specification, all the WPS attribute is presented by Big Endian. */

		wpsielen = 0;
		/*	WPS OUI */
		*(u32 *)(wpsie) = cpu_to_be32(WPSOUI);
		wpsielen += 4;

		/*	WPS version */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_VER1);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
		wpsielen += 2;

		/*	Value: */
		wpsie[wpsielen++] = WPS_VERSION_1;	/*	Version 1.0 */

		/*	WiFi Simple Config State */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_SIMPLE_CONF_STATE);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
		wpsielen += 2;

		/*	Value: */
		wpsie[wpsielen++] = WPS_WSC_STATE_NOT_CONFIG;	/*	Not Configured. */

		/*	Response Type */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_RESP_TYPE);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
		wpsielen += 2;

		/*	Value: */
		wpsie[wpsielen++] = WPS_RESPONSE_TYPE_8021X;

		/*	UUID-E */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_UUID_E);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0010);
		wpsielen += 2;

		/*	Value: */
		if (pwdinfo->external_uuid == 0) {
			_rtw_memset(wpsie + wpsielen, 0x0, 16);
			_rtw_memcpy(wpsie + wpsielen, mac, ETH_ALEN);
		} else
			_rtw_memcpy(wpsie + wpsielen, pwdinfo->uuid, 0x10);
		wpsielen += 0x10;

		/*	Manufacturer */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_MANUFACTURER);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0007);
		wpsielen += 2;

		/*	Value: */
		_rtw_memcpy(wpsie + wpsielen, "Realtek", 7);
		wpsielen += 7;

		/*	Model Name */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_MODEL_NAME);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0006);
		wpsielen += 2;

		/*	Value: */
		_rtw_memcpy(wpsie + wpsielen, "8192CU", 6);
		wpsielen += 6;

		/*	Model Number */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_MODEL_NUMBER);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
		wpsielen += 2;

		/*	Value: */
		wpsie[wpsielen++] = 0x31;		/*	character 1 */

		/*	Serial Number */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_SERIAL_NUMBER);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(ETH_ALEN);
		wpsielen += 2;

		/*	Value: */
		_rtw_memcpy(wpsie + wpsielen, "123456" , ETH_ALEN);
		wpsielen += ETH_ALEN;

		/*	Primary Device Type */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_PRIMARY_DEV_TYPE);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0008);
		wpsielen += 2;

		/*	Value: */
		/*	Category ID */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_PDT_CID_MULIT_MEDIA);
		wpsielen += 2;

		/*	OUI */
		*(u32 *)(wpsie + wpsielen) = cpu_to_be32(WPSOUI);
		wpsielen += 4;

		/*	Sub Category ID */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_PDT_SCID_MEDIA_SERVER);
		wpsielen += 2;

		/*	Device Name */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(pwdinfo->device_name_len);
		wpsielen += 2;

		/*	Value: */
		_rtw_memcpy(wpsie + wpsielen, pwdinfo->device_name, pwdinfo->device_name_len);
		wpsielen += pwdinfo->device_name_len;

		/*	Config Method */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_CONF_METHOD);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0002);
		wpsielen += 2;

		/*	Value: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(pwdinfo->supported_wps_cm);
		wpsielen += 2;


		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, wpsielen, (unsigned char *) wpsie, &pattrib->pktlen);


		p2pielen = build_probe_resp_p2p_ie(pwdinfo, pframe);
		pframe += p2pielen;
		pattrib->pktlen += p2pielen;
	}

#ifdef CONFIG_WFD
	wfdielen = rtw_append_probe_resp_wfd_ie(padapter, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

/* Vendor Specific IE */
#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_P2P_PROBERESP_VENDOR_IE_BIT);
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;


	dump_mgntframe(padapter, pmgntframe);

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, da, 1, "Probe Response p2p", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

	return;

}

int _issue_probereq_p2p(_adapter *padapter, u8 *da, int wait_ack)
{
	int ret = _FAIL;
	struct xmit_frame		*pmgntframe;
	struct pkt_attrib		*pattrib;
	unsigned char			*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short		*fctrl;
	unsigned char			*mac;
	struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	u8	bc_addr[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
	u8					wpsie[255] = { 0x00 }, p2pie[255] = { 0x00 };
	u16					wpsielen = 0, p2pielen = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif

	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);


	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}

	if (IS_CCK_RATE(pattrib->rate)) {
		/* force OFDM 6M rate */
		pattrib->rate = MGN_6M;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	mac = adapter_mac_addr(padapter);

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	if (da) {
		_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, da, ETH_ALEN);
	} else {
		if ((pwdinfo->p2p_info.scan_op_ch_only) || (pwdinfo->rx_invitereq_info.scan_op_ch_only)) {
			/*	This two flags will be set when this is only the P2P client mode. */
			_rtw_memcpy(pwlanhdr->addr1, pwdinfo->p2p_peer_interface_addr, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, pwdinfo->p2p_peer_interface_addr, ETH_ALEN);
		} else {
			/*	broadcast probe request frame */
			_rtw_memcpy(pwlanhdr->addr1, bc_addr, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, bc_addr, ETH_ALEN);
		}
	}
	_rtw_memcpy(pwlanhdr->addr2, mac, ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_PROBEREQ);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_TX_PROVISION_DIS_REQ))
		pframe = rtw_set_ie(pframe, _SSID_IE_, pwdinfo->tx_prov_disc_info.ssid.SsidLength, pwdinfo->tx_prov_disc_info.ssid.Ssid, &(pattrib->pktlen));
	else
		pframe = rtw_set_ie(pframe, _SSID_IE_, P2P_WILDCARD_SSID_LEN, pwdinfo->p2p_wildcard_ssid, &(pattrib->pktlen));
	/*	Use the OFDM rate in the P2P probe request frame. ( 6(B), 9(B), 12(B), 24(B), 36, 48, 54 ) */
	pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_, 8, pwdinfo->support_rate, &pattrib->pktlen);

#ifdef CONFIG_IOCTL_CFG80211
	if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211) {
		if (pmlmepriv->wps_probe_req_ie != NULL && pmlmepriv->p2p_probe_req_ie != NULL) {
			/* WPS IE */
			_rtw_memcpy(pframe, pmlmepriv->wps_probe_req_ie, pmlmepriv->wps_probe_req_ie_len);
			pattrib->pktlen += pmlmepriv->wps_probe_req_ie_len;
			pframe += pmlmepriv->wps_probe_req_ie_len;

			/* P2P IE */
			_rtw_memcpy(pframe, pmlmepriv->p2p_probe_req_ie, pmlmepriv->p2p_probe_req_ie_len);
			pattrib->pktlen += pmlmepriv->p2p_probe_req_ie_len;
			pframe += pmlmepriv->p2p_probe_req_ie_len;
		}
	} else
#endif /* CONFIG_IOCTL_CFG80211 */
	{

		/*	WPS IE */
		/*	Noted by Albert 20110221 */
		/*	According to the WPS specification, all the WPS attribute is presented by Big Endian. */

		wpsielen = 0;
		/*	WPS OUI */
		*(u32 *)(wpsie) = cpu_to_be32(WPSOUI);
		wpsielen += 4;

		/*	WPS version */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_VER1);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0001);
		wpsielen += 2;

		/*	Value: */
		wpsie[wpsielen++] = WPS_VERSION_1;	/*	Version 1.0 */

		if (pmlmepriv->wps_probe_req_ie == NULL) {
			/*	UUID-E */
			/*	Type: */
			*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_UUID_E);
			wpsielen += 2;

			/*	Length: */
			*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0010);
			wpsielen += 2;

			/*	Value: */
			if (pwdinfo->external_uuid == 0) {
				_rtw_memset(wpsie + wpsielen, 0x0, 16);
				_rtw_memcpy(wpsie + wpsielen, mac, ETH_ALEN);
			} else
				_rtw_memcpy(wpsie + wpsielen, pwdinfo->uuid, 0x10);
			wpsielen += 0x10;

			/*	Config Method */
			/*	Type: */
			*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_CONF_METHOD);
			wpsielen += 2;

			/*	Length: */
			*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0002);
			wpsielen += 2;

			/*	Value: */
			*(u16 *)(wpsie + wpsielen) = cpu_to_be16(pwdinfo->supported_wps_cm);
			wpsielen += 2;
		}

		/*	Device Name */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(pwdinfo->device_name_len);
		wpsielen += 2;

		/*	Value: */
		_rtw_memcpy(wpsie + wpsielen, pwdinfo->device_name, pwdinfo->device_name_len);
		wpsielen += pwdinfo->device_name_len;

		/*	Primary Device Type */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_PRIMARY_DEV_TYPE);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0008);
		wpsielen += 2;

		/*	Value: */
		/*	Category ID */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_PDT_CID_RTK_WIDI);
		wpsielen += 2;

		/*	OUI */
		*(u32 *)(wpsie + wpsielen) = cpu_to_be32(WPSOUI);
		wpsielen += 4;

		/*	Sub Category ID */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_PDT_SCID_RTK_DMP);
		wpsielen += 2;

		/*	Device Password ID */
		/*	Type: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_ATTR_DEVICE_PWID);
		wpsielen += 2;

		/*	Length: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(0x0002);
		wpsielen += 2;

		/*	Value: */
		*(u16 *)(wpsie + wpsielen) = cpu_to_be16(WPS_DPID_REGISTRAR_SPEC);	/*	Registrar-specified */
		wpsielen += 2;

		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, wpsielen, (unsigned char *) wpsie, &pattrib->pktlen);

		/*	P2P OUI */
		p2pielen = 0;
		p2pie[p2pielen++] = 0x50;
		p2pie[p2pielen++] = 0x6F;
		p2pie[p2pielen++] = 0x9A;
		p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

		/*	Commented by Albert 20110221 */
		/*	According to the P2P Specification, the probe request frame should contain 5 P2P attributes */
		/*	1. P2P Capability */
		/*	2. P2P Device ID if this probe request wants to find the specific P2P device */
		/*	3. Listen Channel */
		/*	4. Extended Listen Timing */
		/*	5. Operating Channel if this WiFi is working as the group owner now */

		/*	P2P Capability */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_CAPABILITY;

		/*	Length: */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
		p2pielen += 2;

		/*	Value: */
		/*	Device Capability Bitmap, 1 byte */
		p2pie[p2pielen++] = DMP_P2P_DEVCAP_SUPPORT;

		/*	Group Capability Bitmap, 1 byte */
		if (pwdinfo->persistent_supported)
			p2pie[p2pielen++] = P2P_GRPCAP_PERSISTENT_GROUP | DMP_P2P_GRPCAP_SUPPORT;
		else
			p2pie[p2pielen++] = DMP_P2P_GRPCAP_SUPPORT;

		/*	Listen Channel */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_LISTEN_CH;

		/*	Length: */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
		p2pielen += 2;

		/*	Value: */
		/*	Country String */
		p2pie[p2pielen++] = 'X';
		p2pie[p2pielen++] = 'X';

		/*	The third byte should be set to 0x04. */
		/*	Described in the "Operating Channel Attribute" section. */
		p2pie[p2pielen++] = 0x04;

		/*	Operating Class */
		p2pie[p2pielen++] = 0x51;	/*	Copy from SD7 */

		/*	Channel Number */
		p2pie[p2pielen++] = pwdinfo->listen_channel;	/*	listen channel */


		/*	Extended Listen Timing */
		/*	Type: */
		p2pie[p2pielen++] = P2P_ATTR_EX_LISTEN_TIMING;

		/*	Length: */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0004);
		p2pielen += 2;

		/*	Value: */
		/*	Availability Period */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0xFFFF);
		p2pielen += 2;

		/*	Availability Interval */
		*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0xFFFF);
		p2pielen += 2;

		if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
			/*	Operating Channel (if this WiFi is working as the group owner now) */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_OPERATING_CH;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0005);
			p2pielen += 2;

			/*	Value: */
			/*	Country String */
			p2pie[p2pielen++] = 'X';
			p2pie[p2pielen++] = 'X';

			/*	The third byte should be set to 0x04. */
			/*	Described in the "Operating Channel Attribute" section. */
			p2pie[p2pielen++] = 0x04;

			/*	Operating Class */
			p2pie[p2pielen++] = 0x51;	/*	Copy from SD7 */

			/*	Channel Number */
			p2pie[p2pielen++] = pwdinfo->operating_channel;	/*	operating channel number */

		}

		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);

	}

#ifdef CONFIG_WFD
	wfdielen = rtw_append_probe_req_wfd_ie(padapter, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif

/* Vendor Specific IE */
#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_P2P_PROBEREQ_VENDOR_IE_BIT);
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;


	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, da, 1, "Probe Request p2p", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

exit:
	return ret;
}

inline void issue_probereq_p2p(_adapter *adapter, u8 *da)
{
	_issue_probereq_p2p(adapter, da, _FALSE);
}

/*
 * wait_ms == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 * wait_ms > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 * try_cnt means the maximal TX count to try
 */
int issue_probereq_p2p_ex(_adapter *adapter, u8 *da, int try_cnt, int wait_ms)
{
	int ret;
	int i = 0;
	systime start = rtw_get_current_time();

	do {
		ret = _issue_probereq_p2p(adapter, da, wait_ms > 0 ? _TRUE : _FALSE);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(adapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		goto exit;
#endif
	}

	if (try_cnt && wait_ms) {
		if (da)
			RTW_INFO(FUNC_ADPT_FMT" to "MAC_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(adapter), MAC_ARG(da), rtw_get_oper_ch(adapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
		else
			RTW_INFO(FUNC_ADPT_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(adapter), rtw_get_oper_ch(adapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:
	return ret;
}

#endif /* CONFIG_P2P */

s32 rtw_action_public_decache(union recv_frame *rframe, u8 token_offset)
{
	_adapter *adapter = rframe->u.hdr.adapter;
	struct mlme_ext_priv *mlmeext = &(adapter->mlmeextpriv);
	u8 *frame = rframe->u.hdr.rx_data;
	u16 seq_ctrl = ((rframe->u.hdr.attrib.seq_num & 0xffff) << 4) | (rframe->u.hdr.attrib.frag_num & 0xf);
	u8 token = *(rframe->u.hdr.rx_data + sizeof(struct rtw_ieee80211_hdr_3addr) + token_offset);

	if (GetRetry(frame)) {
		if ((seq_ctrl == mlmeext->action_public_rxseq)
		    && (token == mlmeext->action_public_dialog_token)
		   ) {
			RTW_INFO(FUNC_ADPT_FMT" seq_ctrl=0x%x, rxseq=0x%x, token:%d\n",
				FUNC_ADPT_ARG(adapter), seq_ctrl, mlmeext->action_public_rxseq, token);
			return _FAIL;
		}
	}

	/* TODO: per sta seq & token */
	mlmeext->action_public_rxseq = seq_ctrl;
	mlmeext->action_public_dialog_token = token;

	return _SUCCESS;
}

unsigned int on_action_public_p2p(union recv_frame *precv_frame)
{
	_adapter *padapter = precv_frame->u.hdr.adapter;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint len = precv_frame->u.hdr.len;
	u8 *frame_body;
#ifdef CONFIG_P2P
	u8 *p2p_ie;
	u32	p2p_ielen;
	struct	wifidirect_info	*pwdinfo = &(padapter->wdinfo);
	u8	result = P2P_STATUS_SUCCESS;
	u8	empty_addr[ETH_ALEN] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
	u8 *merged_p2pie = NULL;
	u32 merged_p2p_ielen = 0;
#endif /* CONFIG_P2P */

	frame_body = (unsigned char *)(pframe + sizeof(struct rtw_ieee80211_hdr_3addr));

#ifdef CONFIG_P2P
	_cancel_timer_ex(&pwdinfo->reset_ch_sitesurvey);
#ifdef CONFIG_IOCTL_CFG80211
	if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211)
		rtw_cfg80211_rx_p2p_action_public(padapter, precv_frame);
	else
#endif /* CONFIG_IOCTL_CFG80211 */
	{
		/*	Do nothing if the driver doesn't enable the P2P function. */
		if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_NONE) || rtw_p2p_chk_state(pwdinfo, P2P_STATE_IDLE))
			return _SUCCESS;

		len -= sizeof(struct rtw_ieee80211_hdr_3addr);

		switch (frame_body[6]) { /* OUI Subtype */
		case P2P_GO_NEGO_REQ: {
			RTW_INFO("[%s] Got GO Nego Req Frame\n", __FUNCTION__);
			_rtw_memset(&pwdinfo->groupid_info, 0x00, sizeof(struct group_id_info));

			if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_RX_PROVISION_DIS_REQ))
				rtw_p2p_set_state(pwdinfo, rtw_p2p_pre_state(pwdinfo));

			if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_GONEGO_FAIL)) {
				/*	Commented by Albert 20110526 */
				/*	In this case, this means the previous nego fail doesn't be reset yet. */
				_cancel_timer_ex(&pwdinfo->restore_p2p_state_timer);
				/*	Restore the previous p2p state */
				rtw_p2p_set_state(pwdinfo, rtw_p2p_pre_state(pwdinfo));
				RTW_INFO("[%s] Restore the previous p2p state to %d\n", __FUNCTION__, rtw_p2p_state(pwdinfo));
			}
#ifdef CONFIG_CONCURRENT_MODE
			if (rtw_mi_buddy_check_fwstate(padapter, WIFI_ASOC_STATE))
				_cancel_timer_ex(&pwdinfo->ap_p2p_switch_timer);
#endif /* CONFIG_CONCURRENT_MODE */

			/*	Commented by Kurt 20110902 */
			/* Add if statement to avoid receiving duplicate prov disc req. such that pre_p2p_state would be covered. */
			if (!rtw_p2p_chk_state(pwdinfo, P2P_STATE_GONEGO_ING))
				rtw_p2p_set_pre_state(pwdinfo, rtw_p2p_state(pwdinfo));

			/*	Commented by Kurt 20120113 */
			/*	Get peer_dev_addr here if peer doesn't issue prov_disc frame. */
			if (_rtw_memcmp(pwdinfo->rx_prov_disc_info.peerDevAddr, empty_addr, ETH_ALEN))
				_rtw_memcpy(pwdinfo->rx_prov_disc_info.peerDevAddr, get_addr2_ptr(pframe), ETH_ALEN);

			result = process_p2p_group_negotation_req(pwdinfo, frame_body, len);
			issue_p2p_GO_response(padapter, get_addr2_ptr(pframe), frame_body, len, result);

			/*	Commented by Albert 20110718 */
			/*	No matter negotiating or negotiation failure, the driver should set up the restore P2P state timer. */
#ifdef CONFIG_CONCURRENT_MODE
			/*	Commented by Albert 20120107 */
			_set_timer(&pwdinfo->restore_p2p_state_timer, 3000);
#else /* CONFIG_CONCURRENT_MODE */
			_set_timer(&pwdinfo->restore_p2p_state_timer, 5000);
#endif /* CONFIG_CONCURRENT_MODE */
			break;
		}
		case P2P_GO_NEGO_RESP: {
			RTW_INFO("[%s] Got GO Nego Resp Frame\n", __FUNCTION__);

			if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_GONEGO_ING)) {
				/*	Commented by Albert 20110425 */
				/*	The restore timer is enabled when issuing the nego request frame of rtw_p2p_connect function. */
				_cancel_timer_ex(&pwdinfo->restore_p2p_state_timer);
				pwdinfo->nego_req_info.benable = _FALSE;
				result = process_p2p_group_negotation_resp(pwdinfo, frame_body, len);
				issue_p2p_GO_confirm(pwdinfo->padapter, get_addr2_ptr(pframe), result);
				if (P2P_STATUS_SUCCESS == result) {
					if (rtw_p2p_role(pwdinfo) == P2P_ROLE_CLIENT) {
						pwdinfo->p2p_info.operation_ch[0] = pwdinfo->peer_operating_ch;
#ifdef CONFIG_P2P_OP_CHK_SOCIAL_CH
						pwdinfo->p2p_info.operation_ch[1] = 1;	/* Check whether GO is operating in channel 1; */
						pwdinfo->p2p_info.operation_ch[2] = 6;	/* Check whether GO is operating in channel 6; */
						pwdinfo->p2p_info.operation_ch[3] = 11;	/* Check whether GO is operating in channel 11; */
#endif /* CONFIG_P2P_OP_CHK_SOCIAL_CH */
						pwdinfo->p2p_info.scan_op_ch_only = 1;
						_set_timer(&pwdinfo->reset_ch_sitesurvey2, P2P_RESET_SCAN_CH);
					}
				}

				/*	Reset the dialog token for group negotiation frames. */
				pwdinfo->negotiation_dialog_token = 1;

				if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_GONEGO_FAIL))
					_set_timer(&pwdinfo->restore_p2p_state_timer, 5000);
			} else
				RTW_INFO("[%s] Skipped GO Nego Resp Frame (p2p_state != P2P_STATE_GONEGO_ING)\n", __FUNCTION__);

			break;
		}
		case P2P_GO_NEGO_CONF: {
			RTW_INFO("[%s] Got GO Nego Confirm Frame\n", __FUNCTION__);
			result = process_p2p_group_negotation_confirm(pwdinfo, frame_body, len);
			if (P2P_STATUS_SUCCESS == result) {
				if (rtw_p2p_role(pwdinfo) == P2P_ROLE_CLIENT) {
					pwdinfo->p2p_info.operation_ch[0] = pwdinfo->peer_operating_ch;
#ifdef CONFIG_P2P_OP_CHK_SOCIAL_CH
					pwdinfo->p2p_info.operation_ch[1] = 1;	/* Check whether GO is operating in channel 1; */
					pwdinfo->p2p_info.operation_ch[2] = 6;	/* Check whether GO is operating in channel 6; */
					pwdinfo->p2p_info.operation_ch[3] = 11;	/* Check whether GO is operating in channel 11; */
#endif /* CONFIG_P2P_OP_CHK_SOCIAL_CH */
					pwdinfo->p2p_info.scan_op_ch_only = 1;
					_set_timer(&pwdinfo->reset_ch_sitesurvey2, P2P_RESET_SCAN_CH);
				}
			}
			break;
		}
		case P2P_INVIT_REQ: {
			/*	Added by Albert 2010/10/05 */
			/*	Received the P2P Invite Request frame. */

			RTW_INFO("[%s] Got invite request frame!\n", __FUNCTION__);
			p2p_ie = rtw_get_p2p_ie(frame_body + _PUBLIC_ACTION_IE_OFFSET_, len - _PUBLIC_ACTION_IE_OFFSET_, NULL, &p2p_ielen);
			if (p2p_ie) {
				/*	Parse the necessary information from the P2P Invitation Request frame. */
				/*	For example: The MAC address of sending this P2P Invitation Request frame. */
				u32	attr_contentlen = 0;
				u8	status_code = P2P_STATUS_FAIL_INFO_UNAVAILABLE;
				struct group_id_info group_id;
				u8	invitation_flag = 0;

				merged_p2p_ielen = rtw_get_p2p_merged_ies_len(frame_body + _PUBLIC_ACTION_IE_OFFSET_, len - _PUBLIC_ACTION_IE_OFFSET_);

				merged_p2pie = rtw_zmalloc(merged_p2p_ielen + 2);	/* 2 is for EID and Length */
				if (merged_p2pie == NULL) {
					RTW_INFO("[%s] Malloc p2p ie fail\n", __FUNCTION__);
					goto exit;
				}
				_rtw_memset(merged_p2pie, 0x00, merged_p2p_ielen);

				merged_p2p_ielen = rtw_p2p_merge_ies(frame_body + _PUBLIC_ACTION_IE_OFFSET_, len - _PUBLIC_ACTION_IE_OFFSET_, merged_p2pie);

				attr_contentlen = sizeof(invitation_flag);
				rtw_get_p2p_attr_content(merged_p2pie, merged_p2p_ielen, P2P_ATTR_INVITATION_FLAGS, &invitation_flag, &attr_contentlen);
				if (attr_contentlen) {

					attr_contentlen = sizeof(pwdinfo->p2p_peer_interface_addr);
					rtw_get_p2p_attr_content(merged_p2pie, merged_p2p_ielen, P2P_ATTR_GROUP_BSSID, pwdinfo->p2p_peer_interface_addr, &attr_contentlen);
					/*	Commented by Albert 20120510 */
					/*	Copy to the pwdinfo->p2p_peer_interface_addr. */
					/*	So that the WFD UI ( or Sigma ) can get the peer interface address by using the following command. */
					/*	#> iwpriv wlan0 p2p_get peer_ifa */
					/*	After having the peer interface address, the sigma can find the correct conf file for wpa_supplicant. */

					if (attr_contentlen) {
						RTW_INFO("[%s] GO's BSSID = %.2X %.2X %.2X %.2X %.2X %.2X\n", __FUNCTION__,
							pwdinfo->p2p_peer_interface_addr[0], pwdinfo->p2p_peer_interface_addr[1],
							pwdinfo->p2p_peer_interface_addr[2], pwdinfo->p2p_peer_interface_addr[3],
							pwdinfo->p2p_peer_interface_addr[4], pwdinfo->p2p_peer_interface_addr[5]);
					}

					if (invitation_flag & P2P_INVITATION_FLAGS_PERSISTENT) {
						/*	Re-invoke the persistent group. */

						_rtw_memset(&group_id, 0x00, sizeof(struct group_id_info));
						attr_contentlen = sizeof(struct group_id_info);
						rtw_get_p2p_attr_content(merged_p2pie, merged_p2p_ielen, P2P_ATTR_GROUP_ID, (u8 *) &group_id, &attr_contentlen);
						if (attr_contentlen) {
							if (_rtw_memcmp(group_id.go_device_addr, adapter_mac_addr(padapter), ETH_ALEN)) {
								/*	The p2p device sending this p2p invitation request wants this Wi-Fi device to be the persistent GO. */
								rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_GO);
								rtw_p2p_set_role(pwdinfo, P2P_ROLE_GO);
								status_code = P2P_STATUS_SUCCESS;
							} else {
								/*	The p2p device sending this p2p invitation request wants to be the persistent GO. */
								if (is_matched_in_profilelist(pwdinfo->p2p_peer_interface_addr, &pwdinfo->profileinfo[0])) {
									u8 operatingch_info[5] = { 0x00 };
									attr_contentlen = sizeof(operatingch_info);
									if (rtw_get_p2p_attr_content(merged_p2pie, merged_p2p_ielen, P2P_ATTR_OPERATING_CH, operatingch_info,
										&attr_contentlen)) {
										if (rtw_chset_search_ch(adapter_to_chset(padapter), (u32)operatingch_info[4]) >= 0) {
											/*	The operating channel is acceptable for this device. */
											pwdinfo->rx_invitereq_info.operation_ch[0] = operatingch_info[4];
#ifdef CONFIG_P2P_OP_CHK_SOCIAL_CH
											pwdinfo->rx_invitereq_info.operation_ch[1] = 1;		/* Check whether GO is operating in channel 1; */
											pwdinfo->rx_invitereq_info.operation_ch[2] = 6;		/* Check whether GO is operating in channel 6; */
											pwdinfo->rx_invitereq_info.operation_ch[3] = 11;		/* Check whether GO is operating in channel 11; */
#endif /* CONFIG_P2P_OP_CHK_SOCIAL_CH */
											pwdinfo->rx_invitereq_info.scan_op_ch_only = 1;
											_set_timer(&pwdinfo->reset_ch_sitesurvey, P2P_RESET_SCAN_CH);
											rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_MATCH);
											rtw_p2p_set_role(pwdinfo, P2P_ROLE_CLIENT);
											status_code = P2P_STATUS_SUCCESS;
										} else {
											/*	The operating channel isn't supported by this device. */
											rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_DISMATCH);
											rtw_p2p_set_role(pwdinfo, P2P_ROLE_DEVICE);
											status_code = P2P_STATUS_FAIL_NO_COMMON_CH;
											_set_timer(&pwdinfo->restore_p2p_state_timer, 3000);
										}
									} else {
										/*	Commented by Albert 20121130 */
										/*	Intel will use the different P2P IE to store the operating channel information */
										/*	Workaround for Intel WiDi 3.5 */
										rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_MATCH);
										rtw_p2p_set_role(pwdinfo, P2P_ROLE_CLIENT);
										status_code = P2P_STATUS_SUCCESS;
									}
								} else {
									rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_DISMATCH);
									status_code = P2P_STATUS_FAIL_UNKNOWN_P2PGROUP;
								}
							}
						} else {
							RTW_INFO("[%s] P2P Group ID Attribute NOT FOUND!\n", __FUNCTION__);
							status_code = P2P_STATUS_FAIL_INFO_UNAVAILABLE;
						}
					} else {
						/*	Received the invitation to join a P2P group. */

						_rtw_memset(&group_id, 0x00, sizeof(struct group_id_info));
						attr_contentlen = sizeof(struct group_id_info);
						rtw_get_p2p_attr_content(merged_p2pie, merged_p2p_ielen, P2P_ATTR_GROUP_ID, (u8 *) &group_id, &attr_contentlen);
						if (attr_contentlen) {
							if (_rtw_memcmp(group_id.go_device_addr, adapter_mac_addr(padapter), ETH_ALEN)) {
								/*	In this case, the GO can't be myself. */
								rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_DISMATCH);
								status_code = P2P_STATUS_FAIL_INFO_UNAVAILABLE;
							} else {
								/*	The p2p device sending this p2p invitation request wants to join an existing P2P group */
								/*	Commented by Albert 2012/06/28 */
								/*	In this case, this Wi-Fi device should use the iwpriv command to get the peer device address. */
								/*	The peer device address should be the destination address for the provisioning discovery request. */
								/*	Then, this Wi-Fi device should use the iwpriv command to get the peer interface address. */
								/*	The peer interface address should be the address for WPS mac address */
								_rtw_memcpy(pwdinfo->p2p_peer_device_addr, group_id.go_device_addr , ETH_ALEN);
								rtw_p2p_set_role(pwdinfo, P2P_ROLE_CLIENT);
								rtw_p2p_set_state(pwdinfo, P2P_STATE_RECV_INVITE_REQ_JOIN);
								status_code = P2P_STATUS_SUCCESS;
							}
						} else {
							RTW_INFO("[%s] P2P Group ID Attribute NOT FOUND!\n", __FUNCTION__);
							status_code = P2P_STATUS_FAIL_INFO_UNAVAILABLE;
						}
					}
				} else {
					RTW_INFO("[%s] P2P Invitation Flags Attribute NOT FOUND!\n", __FUNCTION__);
					status_code = P2P_STATUS_FAIL_INFO_UNAVAILABLE;
				}

				RTW_INFO("[%s] status_code = %d\n", __FUNCTION__, status_code);

				pwdinfo->inviteresp_info.token = frame_body[7];
				issue_p2p_invitation_response(padapter, get_addr2_ptr(pframe), pwdinfo->inviteresp_info.token, status_code);
				_set_timer(&pwdinfo->restore_p2p_state_timer, 3000);
			}
			break;
		}
		case P2P_INVIT_RESP: {
			u8	attr_content = 0x00;
			u32	attr_contentlen = 0;

			RTW_INFO("[%s] Got invite response frame!\n", __FUNCTION__);
			_cancel_timer_ex(&pwdinfo->restore_p2p_state_timer);
			p2p_ie = rtw_get_p2p_ie(frame_body + _PUBLIC_ACTION_IE_OFFSET_, len - _PUBLIC_ACTION_IE_OFFSET_, NULL, &p2p_ielen);
			if (p2p_ie) {
				attr_contentlen = sizeof(attr_content);
				rtw_get_p2p_attr_content(p2p_ie, p2p_ielen, P2P_ATTR_STATUS, &attr_content, &attr_contentlen);

				if (attr_contentlen == 1) {
					RTW_INFO("[%s] Status = %d\n", __FUNCTION__, attr_content);
					pwdinfo->invitereq_info.benable = _FALSE;

					if (attr_content == P2P_STATUS_SUCCESS) {
						if (_rtw_memcmp(pwdinfo->invitereq_info.go_bssid, adapter_mac_addr(padapter), ETH_ALEN))
							rtw_p2p_set_role(pwdinfo, P2P_ROLE_GO);
						else
							rtw_p2p_set_role(pwdinfo, P2P_ROLE_CLIENT);

						rtw_p2p_set_state(pwdinfo, P2P_STATE_RX_INVITE_RESP_OK);
					} else {
						rtw_p2p_set_role(pwdinfo, P2P_ROLE_DEVICE);
						rtw_p2p_set_state(pwdinfo, P2P_STATE_RX_INVITE_RESP_FAIL);
					}
				} else {
					rtw_p2p_set_role(pwdinfo, P2P_ROLE_DEVICE);
					rtw_p2p_set_state(pwdinfo, P2P_STATE_RX_INVITE_RESP_FAIL);
				}
			} else {
				rtw_p2p_set_role(pwdinfo, P2P_ROLE_DEVICE);
				rtw_p2p_set_state(pwdinfo, P2P_STATE_RX_INVITE_RESP_FAIL);
			}

			if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_RX_INVITE_RESP_FAIL))
				_set_timer(&pwdinfo->restore_p2p_state_timer, 5000);
			break;
		}
		case P2P_DEVDISC_REQ:

			process_p2p_devdisc_req(pwdinfo, pframe, len);

			break;

		case P2P_DEVDISC_RESP:

			process_p2p_devdisc_resp(pwdinfo, pframe, len);

			break;

		case P2P_PROVISION_DISC_REQ:
			RTW_INFO("[%s] Got Provisioning Discovery Request Frame\n", __FUNCTION__);
			process_p2p_provdisc_req(pwdinfo, pframe, len);
			_rtw_memcpy(pwdinfo->rx_prov_disc_info.peerDevAddr, get_addr2_ptr(pframe), ETH_ALEN);

			/* 20110902 Kurt */
			/* Add the following statement to avoid receiving duplicate prov disc req. such that pre_p2p_state would be covered. */
			if (!rtw_p2p_chk_state(pwdinfo, P2P_STATE_RX_PROVISION_DIS_REQ))
				rtw_p2p_set_pre_state(pwdinfo, rtw_p2p_state(pwdinfo));

			rtw_p2p_set_state(pwdinfo, P2P_STATE_RX_PROVISION_DIS_REQ);
			_set_timer(&pwdinfo->restore_p2p_state_timer, P2P_PROVISION_TIMEOUT);
			break;

		case P2P_PROVISION_DISC_RESP:
			/*	Commented by Albert 20110707 */
			/*	Should we check the pwdinfo->tx_prov_disc_info.bsent flag here?? */
			RTW_INFO("[%s] Got Provisioning Discovery Response Frame\n", __FUNCTION__);
			/*	Commented by Albert 20110426 */
			/*	The restore timer is enabled when issuing the provisioing request frame in rtw_p2p_prov_disc function. */
			_cancel_timer_ex(&pwdinfo->restore_p2p_state_timer);
			rtw_p2p_set_state(pwdinfo, P2P_STATE_RX_PROVISION_DIS_RSP);
			process_p2p_provdisc_resp(pwdinfo, pframe);
			_set_timer(&pwdinfo->restore_p2p_state_timer, P2P_PROVISION_TIMEOUT);
			break;

		}
	}


exit:

	if (merged_p2pie)
		rtw_mfree(merged_p2pie, merged_p2p_ielen + 2);
#endif /* CONFIG_P2P */
	return _SUCCESS;
}

unsigned int on_action_public_vendor(union recv_frame *precv_frame)
{
	unsigned int ret = _FAIL;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	u8 *frame_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	_adapter *adapter = precv_frame->u.hdr.adapter;
	struct dvobj_priv *dvobj = adapter_to_dvobj(adapter);

	int cnt = 0;
	char msg[64];

	if (_rtw_memcmp(frame_body + 2, P2P_OUI, 4) == _TRUE) {
		if (rtw_action_public_decache(precv_frame, 7) == _FAIL)
			goto exit;

		if (!rtw_hw_chk_wl_func(dvobj, WL_FUNC_MIRACAST))
			rtw_rframe_del_wfd_ie(precv_frame, 8);

		ret = on_action_public_p2p(precv_frame);
	} else if (_rtw_memcmp(frame_body + 2, DPP_OUI, 4) == _TRUE) {
		u8 dpp_type = frame_body[7];

#ifdef CONFIG_IOCTL_CFG80211
		cnt += sprintf((msg + cnt), "DPP(type:%u)", dpp_type);
		rtw_cfg80211_rx_action(adapter, precv_frame, msg);
#endif
	}

exit:
	return ret;
}

unsigned int on_action_public_default(union recv_frame *precv_frame, u8 action)
{
	unsigned int ret = _FAIL;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	u8 *frame_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	u8 token;
	_adapter *adapter = precv_frame->u.hdr.adapter;
	int cnt = 0;
	char msg[64];

	token = frame_body[2];

	if (rtw_action_public_decache(precv_frame, 2) == _FAIL)
		goto exit;

#ifdef CONFIG_IOCTL_CFG80211
	cnt += sprintf((msg + cnt), "%s(token:%u)", action_public_str(action), token);
	rtw_cfg80211_rx_action(adapter, precv_frame, msg);
#endif

	ret = _SUCCESS;

exit:
	return ret;
}

unsigned int on_action_public(_adapter *padapter, union recv_frame *precv_frame)
{
	unsigned int ret = _FAIL;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint frame_len = precv_frame->u.hdr.len;
	u8 *frame_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	u8 category, action;
	struct rx_pkt_attrib *pattrib = &precv_frame->u.hdr.attrib;

	/* check RA matches or not */
#if defined(CONFIG_RTW_MULTI_AP_R3) && defined(CONFIG_RTW_MULTI_AP_LOGO)
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN) && !is_broadcast_mac_addr(GetAddr1Ptr(pframe)))
#else
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN))
#endif
		goto exit;

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_PUBLIC && category != RTW_WLAN_CATEGORY_PROTECTED_PUBLIC)
		goto exit;

	action = frame_body[1];
	switch (action) {
	case ACT_PUBLIC_BSSCOEXIST:
#ifdef CONFIG_80211N_HT
#ifdef CONFIG_AP_MODE
		/*20/40 BSS Coexistence Management frame is a Public Action frame*/
		if (check_fwstate(&padapter->mlmepriv, WIFI_AP_STATE) == _TRUE)
			rtw_process_public_act_bsscoex(padapter, pframe, frame_len);
#endif /*CONFIG_AP_MODE*/
#endif /*CONFIG_80211N_HT*/
		break;
	case ACT_PUBLIC_VENDOR:
		ret = on_action_public_vendor(precv_frame);
		break;
	case ACT_PUBLIC_GAS_INITIAL_REQ:
		RTW_INFO("[GAS]: recv GAS_INITIAL_REQ\n");
		if (MLME_IS_AP(padapter)) {
#ifdef CONFIG_RTW_MULTI_AP_R2
			core_map_send_tunneled_message(padapter, get_addr2_ptr(pframe), TUNNELED_MSG_ANQPREQ, frame_len - WLAN_HDR_A3_LEN, frame_body);
#endif
		}
		ret = on_action_public_default(precv_frame, action);
		break;
	default:
		ret = on_action_public_default(precv_frame, action);
		break;
	}

exit:
	return ret;
}

#if defined(CONFIG_RTW_WNM) || defined(CONFIG_RTW_80211K)
static u8 rtw_wnm_nb_elem_parsing(
	u8* pdata, u32 data_len, u8 from_btm,
	u32 *nb_rpt_num, u8 *nb_rpt_is_same,
	struct roam_nb_info *pnb, struct wnm_btm_cant *pcandidates)
{
	u8 bfound = _FALSE, ret = _SUCCESS;
	u8 *ptr, *pend, *op;
	u32 elem_len, subelem_len, op_len;
	u32 i, nb_rpt_entries = 0;
	struct nb_rpt_hdr *pie;
	struct wnm_btm_cant *pcandidate;

	if ((!pdata) || (!pnb))
		return _FAIL;

	if ((from_btm) && (!pcandidates))
		return _FAIL;

	ptr = pdata;
	pend = ptr + data_len;
	elem_len = data_len;
	subelem_len = (u32)*(pdata+1);

	for (i=0; i < RTW_MAX_NB_RPT_NUM; i++) {
		if (((ptr + 7) > pend) || (elem_len < subelem_len))
			break;

		if (*ptr != 0x34) {
			RTW_ERR("WNM: invalid data(0x%2x)!\n", *ptr);
			ret = _FAIL;
			break;
		}

		pie = (struct nb_rpt_hdr *)ptr;
		if (from_btm) {
			op = rtw_get_ie((u8 *)(ptr+15),
				WNM_BTM_CAND_PREF_SUBEID,
				&op_len, (subelem_len - 15));
		}

		ptr = (u8 *)(ptr + subelem_len + 2);
		elem_len -= (subelem_len +2);
		subelem_len = *(ptr+1);
		if (from_btm) {
			pcandidate = (pcandidates + i);
			_rtw_memcpy(&pcandidate->nb_rpt, pie, sizeof(struct nb_rpt_hdr));
			if (op && (op_len !=0)) {
				pcandidate->preference = *(op + 2);
				bfound = _TRUE;
			} else
				pcandidate->preference = 0;

			RTW_DBG("WNM: preference check bssid("MAC_FMT
				") ,bss_info(0x%04X), reg_class(0x%02X), ch(%d),"
				" phy_type(0x%02X), preference(0x%02X)\n",
				MAC_ARG(pcandidate->nb_rpt.bssid), pcandidate->nb_rpt.bss_info,
				pcandidate->nb_rpt.reg_class, pcandidate->nb_rpt.ch_num,
				pcandidate->nb_rpt.phy_type, pcandidate->preference);
		} else {
			if (_rtw_memcmp(&pnb->nb_rpt[i], pie, sizeof(struct nb_rpt_hdr)) == _FALSE)
				*nb_rpt_is_same = _FALSE;
			_rtw_memcpy(&pnb->nb_rpt[i], pie, sizeof(struct nb_rpt_hdr));
		}
		nb_rpt_entries++;
	}

	if (from_btm)
		pnb->preference_en = (bfound)?_TRUE:_FALSE;

	*nb_rpt_num = nb_rpt_entries;
	return ret;
}

/* selection sorting based on preference value
 *  : 		nb_rpt_entries - candidate num
 * / :	pcandidates	- candidate list
 * return : TRUE - means pcandidates is updated.
 */
static u8 rtw_wnm_candidates_sorting(
	u32 nb_rpt_entries, struct wnm_btm_cant *pcandidates)
{
	u8 updated = _FALSE;
	u32 i, j, pos;
	struct wnm_btm_cant swap;
	struct wnm_btm_cant *pcant_1, *pcant_2;

	if ((!nb_rpt_entries) || (!pcandidates))
		return updated;

	for (i=0; i < (nb_rpt_entries - 1); i++) {
		pos = i;
		for (j=(i + 1); j < nb_rpt_entries; j++) {
			pcant_1 = pcandidates+pos;
			pcant_2 = pcandidates+j;
			if ((pcant_1->preference) < (pcant_2->preference))
				pos = j;
		}

		if (pos != i) {
			updated = _TRUE;
			_rtw_memcpy(&swap, (pcandidates+i), sizeof(struct wnm_btm_cant));
			_rtw_memcpy((pcandidates+i), (pcandidates+pos), sizeof(struct wnm_btm_cant));
			_rtw_memcpy((pcandidates+pos), &swap, sizeof(struct wnm_btm_cant));
		}
	}
	return updated;
}

static void rtw_wnm_nb_info_update(
	u32 nb_rpt_entries, u8 from_btm,
	struct roam_nb_info *pnb, struct wnm_btm_cant *pcandidates,
	u8 *nb_rpt_is_same)
{
	u8 is_found;
	u32 i, j;
	struct wnm_btm_cant *pcand;

	if (!pnb)
		return;

	pnb->nb_rpt_ch_list_num = 0;
	for (i=0; i<nb_rpt_entries; i++) {
		is_found = _FALSE;
		if (from_btm) {
			pcand = (pcandidates+i);
			if (_rtw_memcmp(&pnb->nb_rpt[i], &pcand->nb_rpt,
					sizeof(struct nb_rpt_hdr)) == _FALSE)
				*nb_rpt_is_same = _FALSE;
			_rtw_memcpy(&pnb->nb_rpt[i], &pcand->nb_rpt, sizeof(struct nb_rpt_hdr));
		}

		RTW_DBG("WNM: bssid(" MAC_FMT
			") , bss_info(0x%04X), reg_class(0x%02X), ch_num(%d), phy_type(0x%02X)\n",
			MAC_ARG(pnb->nb_rpt[i].bssid), pnb->nb_rpt[i].bss_info,
			pnb->nb_rpt[i].reg_class, pnb->nb_rpt[i].ch_num,
			pnb->nb_rpt[i].phy_type);

		if (pnb->nb_rpt[i].ch_num == 0)
			continue;

		for (j=0; j<nb_rpt_entries; j++) {
			if (pnb->nb_rpt[i].ch_num == pnb->nb_rpt_ch_list[j].hw_value) {
				is_found = _TRUE;
				break;
			}
		}

		if (!is_found) {
			pnb->nb_rpt_ch_list[pnb->nb_rpt_ch_list_num].hw_value = pnb->nb_rpt[i].ch_num;
				pnb->nb_rpt_ch_list_num++;
		}
	}
}

static void rtw_wnm_btm_candidate_select(_adapter *padapter)
{
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct roam_nb_info *pnb = &(padapter->mlmepriv.nb_info);
	struct wlan_network *pnetwork;
	u8 bfound = _FALSE;
	u32 i;
#ifdef RTW_MI_SHARE_BSS_LIST
	_queue *queue = &padapter->dvobj->scanned_queue;
#else
	_queue *queue = &pmlmepriv->scanned_queue;
#endif


	for (i = 0; i < pnb->last_nb_rpt_entries; i++) {
		pnetwork = rtw_find_network(
				queue,
				pnb->nb_rpt[i].bssid);

		if (pnetwork) {
			bfound = _TRUE;
			break;
		}
	}

	if (bfound) {
		_rtw_memcpy(pnb->roam_target_addr, pnb->nb_rpt[i].bssid, ETH_ALEN);
		RTW_INFO("WNM : select btm entry(%d) - %s("MAC_FMT", ch%u) rssi:%d\n"
			, i
			, pnetwork->network.Ssid.Ssid
			, MAC_ARG(pnetwork->network.MacAddress)
			, pnetwork->network.Configuration.DSConfig
			, (int)pnetwork->network.Rssi);
	} else
		_rtw_memset(pnb->roam_target_addr,0, ETH_ALEN);
}

u32 rtw_wnm_btm_candidates_survey(
	_adapter *padapter, u8* pframe, u32 elem_len, u8 from_btm)
{
	struct roam_nb_info *pnb = &(padapter->mlmepriv.nb_info);
	struct wnm_btm_cant *pcandidate_list = NULL;
	u8 nb_rpt_is_same = _TRUE;
	u32	ret = _FAIL;
	u32 nb_rpt_entries = 0;

	if (from_btm) {
		u32 mlen = sizeof(struct wnm_btm_cant) * RTW_MAX_NB_RPT_NUM;
		pcandidate_list = (struct wnm_btm_cant *)rtw_malloc(mlen);
		if (pcandidate_list == NULL)
			goto exit;
	}

	/*clean the status set last time*/
	_rtw_memset(&pnb->nb_rpt_ch_list, 0, sizeof(pnb->nb_rpt_ch_list));
	pnb->nb_rpt_valid = _FALSE;
	if (!rtw_wnm_nb_elem_parsing(
			pframe, elem_len, from_btm,
			&nb_rpt_entries, &nb_rpt_is_same,
			pnb, pcandidate_list))
		goto exit;

	if (nb_rpt_entries != 0) {
		if ((from_btm) && (rtw_wnm_btm_preference_cap(padapter)))
			rtw_wnm_candidates_sorting(nb_rpt_entries, pcandidate_list);

		rtw_wnm_nb_info_update(
			nb_rpt_entries, from_btm,
			pnb, pcandidate_list, &nb_rpt_is_same);
	}

	RTW_INFO("nb_rpt_is_same = %d, nb_rpt_entries = %d, last_nb_rpt_entries = %d\n",
		nb_rpt_is_same, nb_rpt_entries, pnb->last_nb_rpt_entries);
	if ((nb_rpt_is_same == _TRUE) && (nb_rpt_entries == pnb->last_nb_rpt_entries))
		pnb->nb_rpt_is_same = _TRUE;
	else {
		pnb->nb_rpt_is_same = _FALSE;
		pnb->last_nb_rpt_entries = nb_rpt_entries;
	}

	if ((from_btm) && (nb_rpt_entries != 0))
		rtw_wnm_btm_candidate_select(padapter);

	pnb->nb_rpt_valid = _TRUE;
	ret = _SUCCESS;

exit:
	if (from_btm && pcandidate_list)
		rtw_mfree((u8 *)pcandidate_list, sizeof(struct wnm_btm_cant) * RTW_MAX_NB_RPT_NUM);

	return ret;
}

int _rm_parse_nb_report(_adapter *padapter, const u8 *pbuf, struct nb_rpt_hdr *report)
{
	struct mlme_priv *mlme = &padapter->mlmepriv;
	int offset = 1;
	u8 sub_id = 0;
	u8 sub_len = 0;

	if(report == NULL)
		return _FAIL;

	_rtw_memset(report, 0, sizeof(struct nb_rpt_hdr));

	report->len = *(pbuf + offset);
	offset += 1;

	_rtw_memcpy(report->bssid, pbuf + offset, MAC_ADDR_LEN);
	offset += MAC_ADDR_LEN;

	report->bss_info = RTW_GET_LE32(pbuf + offset);
	offset += 4;

	report->reg_class = *(pbuf + offset);
	offset += 1;

	report->ch_num = *(pbuf + offset);
	offset += 1;

	report->phy_type = *(pbuf + offset);
	offset += 1;

	while (offset < report->len + 2) {
		sub_id = *(pbuf + offset);
		sub_len = *(pbuf + offset + 1);
		if(sub_id == WNM_BTM_CAND_PREF_SUBEID) {
			report->preference = *(pbuf + offset + 2);
			break;
		}
		offset += sub_len + 2;
	}

	return _SUCCESS;
}

int _rm_construct_nb_report(_adapter *padapter, u8 *pbuf, struct nb_rpt_hdr report,
							u8 disassoc_imminent, u8 preference_sta)
{
	struct mlme_priv *mlme = &padapter->mlmepriv;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX *cur_network = &(pmlmeinfo->network);
	u8 sub_len = 16;

	u8 *pbuf_ptr = pbuf;

	RTW_DBG("[%s]Insert nb report, "MAC_FMT"\n", __func__, MAC_ARG(report.bssid));
	/* id */
	*pbuf_ptr = _NEIGHBOR_REPORT_IE_;
	pbuf_ptr += 1;

	/* length */
	*pbuf_ptr = sub_len;
	pbuf_ptr += 1;

	/* BSSID */
	_rtw_memcpy(pbuf_ptr, report.bssid, ETH_ALEN);
	pbuf_ptr += ETH_ALEN;

	RTW_PUT_LE32(pbuf_ptr, report.bss_info);
	pbuf_ptr += 4;

	*pbuf_ptr = report.reg_class;
	pbuf_ptr += 1;

	*pbuf_ptr = report.ch_num;
	pbuf_ptr += 1;

	*pbuf_ptr = report.phy_type;
	pbuf_ptr += 1;

	*pbuf_ptr = WNM_BTM_CAND_PREF_SUBEID;
	pbuf_ptr += 1;

	*pbuf_ptr = 1;
	pbuf_ptr += 1;
	if (disassoc_imminent &&
	   (_rtw_memcmp(report.bssid, cur_network->MacAddress, ETH_ALEN) == _TRUE)) {
	   RTW_DBG("[%s]disassoc_imminent = 1, set preference to 0\n", __func__);
	   *pbuf_ptr = 0;
	} else {
		*pbuf_ptr = preference_sta;
	}
	pbuf_ptr += 1;

	return (pbuf_ptr - pbuf);
}

/* return inserted index
 * return 0xff if table is full
 */
u8 rtw_rm_insert_nb_report(_adapter *padapter, struct nb_rpt_hdr report)
{
	struct mlme_priv *mlme = &padapter->mlmepriv;
	struct wlan_network *cur_network = &(mlme->cur_network);
	struct roam_nb_info *nb_info = &mlme->nb_info;
	int empty_slot;
	int i;
	u32 oldest_age = 0;
	int oldest_idx = -1;

	for (i = 0, empty_slot = -1; i < RTW_MAX_NB_RPT_NUM; i++) {
		if(!nb_info->nb_rpt[i].enable) {
			if (empty_slot == -1)
				empty_slot = i;
		} else if (_TRUE == _rtw_memcmp(report.bssid, nb_info->nb_rpt[i].bssid, ETH_ALEN)) {
			break;
		}
		if (oldest_age < nb_info->nb_rpt[i].aging &&
		    _FALSE == _rtw_memcmp(nb_info->nb_rpt[i].bssid, cur_network->network.MacAddress, MAC_ADDR_LEN)) {
			oldest_age = nb_info->nb_rpt[i].aging;
			oldest_idx = i;
		}
	}
	if (i == RTW_MAX_NB_RPT_NUM) {
		if (empty_slot != -1) {
			/*not found, and has empty slot*/
			i = empty_slot;
			nb_info->nb_rpt_num += 1;
		} else {
			/* replace the oldest neighbor report */
			if(oldest_idx == -1)
				return 0xff;
			i = oldest_idx;
		}
	}

	report.enable = 1;
	report.aging = 0;
	report.tag = 0;
	_rtw_memcpy(&nb_info->nb_rpt[i], &report, sizeof(struct nb_rpt_hdr));
	nb_info->nb_rpt[i].enable = 1;
	return i;
}
#endif

unsigned int OnAction_ft(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_RTW_80211R
	u32	ret = _FAIL;
	u32	frame_len = 0;
	u8	action_code = 0;
	u8	category = 0;
	u8	*pframe = NULL;
	u8	*pframe_body = NULL;
	u8	sta_addr[ETH_ALEN] = {0};
	u8	*target_ap = NULL;
	u8	*pie = NULL;
	u32	ft_ie_len = 0;
	u32 status_code = 0;
	struct mlme_ext_priv *pmlmeext = NULL;
	struct mlme_ext_info *pmlmeinfo = NULL;
	struct mlme_priv *pmlmepriv = NULL;
	struct wlan_network *proam_target = NULL;
	struct ft_roam_info *pft_roam = NULL;

	pmlmeext = &(padapter->mlmeextpriv);
	pmlmeinfo = &(pmlmeext->mlmext_info);
	pmlmepriv = &(padapter->mlmepriv);
	pft_roam = &(pmlmepriv->ft_roam);
	pframe = precv_frame->u.hdr.rx_data;
	frame_len = precv_frame->u.hdr.len;
	pframe_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	category = pframe_body[0];

	if (category != RTW_WLAN_CATEGORY_FT)
		goto exit;

	action_code = pframe_body[1];
	target_ap = pframe_body + 8;
	switch (action_code) {
	case RTW_WLAN_ACTION_FT_RSP:
		RTW_INFO("FT: RTW_WLAN_ACTION_FT_RSP recv.\n");
		if (!_rtw_memcmp(adapter_mac_addr(padapter), &pframe_body[2], ETH_ALEN)) {
			RTW_ERR("FT: Unmatched STA MAC Address "MAC_FMT"\n", MAC_ARG(&pframe_body[2]));
			goto exit;
		}

		status_code = le16_to_cpu(*(u16 *)((SIZE_PTR)pframe +  sizeof(struct rtw_ieee80211_hdr_3addr) + 14));
		if (status_code != 0) {
			RTW_ERR("FT: WLAN ACTION FT RESPONSE fail, status: %d\n", status_code);
			goto exit;
		}

		if (is_zero_mac_addr(target_ap) || is_broadcast_mac_addr(target_ap)) {
			RTW_ERR("FT: Invalid Target MAC Address "MAC_FMT"\n", MAC_ARG(padapter->mlmepriv.roam_tgt_addr));
			goto exit;
		}

		pie = rtw_get_ie(pframe_body, _MDIE_, &ft_ie_len, frame_len);
		if (pie) {
			if (!_rtw_memcmp(&pft_roam->mdid, pie+2, 2)) {
				RTW_ERR("FT: Invalid MDID\n");
				goto exit;
			}
		}

		rtw_ft_set_status(padapter, RTW_FT_REQUESTED_STA);
		_cancel_timer_ex(&pmlmeext->ft_link_timer);

		/*Disconnect current AP*/
		receive_disconnect(padapter, pmlmepriv->cur_network.network.MacAddress, WLAN_REASON_ACTIVE_ROAM, _FALSE);

		pft_roam->ft_action_len = frame_len;
		_rtw_memcpy(pft_roam->ft_action, pframe, rtw_min(frame_len, RTW_FT_MAX_IE_SZ));
		ret = _SUCCESS;
		break;
	case RTW_WLAN_ACTION_FT_REQ:
#ifdef CONFIG_IOCTL_CFG80211
		RTW_PRINT("[FT] recv ft-action\n");
		rtw_cfg80211_rx_action(padapter, precv_frame, NULL);
#endif
		break;
	case RTW_WLAN_ACTION_FT_CONF:
	case RTW_WLAN_ACTION_FT_ACK:
	default:
		RTW_ERR("FT: Unsupported FT Action!\n");
		break;
	}

exit:
	return ret;
#else
	return _SUCCESS;
#endif
}

#ifdef CONFIG_RTW_WNM
u8 rtw_wmn_btm_rsp_reason_decision(_adapter *padapter, u8* req_mode)
{
	struct recv_priv *precvpriv = &padapter->recvpriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	u8 reason = 0;

	if (!rtw_wnm_btm_diff_bss(padapter)) {
		/* Reject - No suitable BSS transition candidates */
		reason = 7;
		goto candidate_remove;
	}

#ifdef CONFIG_RTW_80211R
	if (rtw_ft_chk_flags(padapter, RTW_FT_BTM_ROAM)) {
		/* Accept */
		reason = 0;
		goto under_survey;
	}
#endif

	if (((*req_mode) & DISASSOC_IMMINENT) == 0) {
		/* Reject - Unspecified reject reason */
		reason = 1;
		goto candidate_remove;
	}

	if (precvpriv->signal_strength_data.avg_val >= pmlmepriv->roam_rssi_threshold) {
		reason = 1;
		goto candidate_remove;
	}

under_survey:
	if (check_fwstate(pmlmepriv, WIFI_UNDER_SURVEY)) {
		RTW_INFO("%s reject due to WIFI_UNDER_SURVEY\n", __func__);
		reason = 1;
	}

candidate_remove:
	if (reason !=0)
		rtw_wnm_reset_btm_candidate(&padapter->mlmepriv.nb_info);

	return reason;
}

static u32 rtw_wnm_btm_candidates_offset_get(u8* pframe)
{
	u8 *pos = pframe;
	u32 offset = 0;

	if (!pframe)
		return 0;

	offset += 7;
	pos += offset;

	/* BSS Termination Duration check */
	if (wnm_btm_bss_term_inc(pframe)) {
		offset += 12;
		pos += offset;
	}

	/* Session Information URL check*/
	if (wnm_btm_ess_disassoc_im(pframe)) {
		/*URL length field + URL variable length*/
		offset = 1 + *(pframe + offset);
		pos += offset;
	}

	offset = (pos - pframe);
	return offset;
}

static void rtw_wnm_btm_req_hdr_parsing(u8* pframe, struct btm_req_hdr *phdr)
{
	u8 *pos = pframe;
	u32 offset = 0;

	if (!pframe || !phdr)
		return;

	_rtw_memset(phdr, 0, sizeof(struct btm_req_hdr));
	phdr->req_mode  = wnm_btm_req_mode(pframe);
	phdr->disassoc_timer = wnm_btm_disassoc_timer(pframe);
	phdr->validity_interval = wnm_btm_valid_interval(pframe);
	if (wnm_btm_bss_term_inc(pframe)) {
		_rtw_memcpy(&phdr->term_duration,
			wnm_btm_term_duration_offset(pframe),
			sizeof(struct btm_term_duration));
	}

	RTW_DBG("WNM: req_mode(%1x), disassoc_timer(%02x), interval(%x)\n",
		phdr->req_mode, phdr->disassoc_timer, phdr->validity_interval);
	if (wnm_btm_bss_term_inc(pframe))
		RTW_INFO("WNM: tsf(%llx), duration(%2x)\n",
			phdr->term_duration.tsf, phdr->term_duration.duration);
}

void rtw_wnm_roam_scan_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);

	if (rtw_is_scan_deny(padapter))
		RTW_INFO("WNM: roam scan would abort by scan_deny!\n");

	pmlmepriv->need_to_roam = _TRUE;
	rtw_drv_scan_by_self(padapter, RTW_AUTO_SCAN_REASON_ROAM);
}

static void rtw_wnm_roam_scan(_adapter *padapter)
{
	struct roam_nb_info *pnb = &(padapter->mlmepriv.nb_info);

	if (rtw_is_scan_deny(padapter)) {
		_cancel_timer_ex(&pnb->roam_scan_timer);
		_set_timer(&pnb->roam_scan_timer, 1000);
	} else
		rtw_wnm_roam_scan_hdl((void *)padapter);
}

void _wnm_update_bss_status_code(_adapter *padapter, u8 *da, u8 reason)
{
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *psta = NULL;

	psta = rtw_get_stainfo(pstapriv, da);
	if(!psta) {
		RTW_ERR("[%s]psta is NULL!\n", __func__);
		goto exit;
	}

	psta->bss_trans_status_code = reason;

exit:
	return;

}

void _wnm_update_bss_trans_support(_adapter *padapter, struct nb_rpt_hdr report)
{
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *psta = NULL;

	psta = rtw_get_stainfo(pstapriv, report.bssid);

	if(!psta) {
		RTW_ERR("[%s]psta is NULL!\n", __func__);
		goto exit;
	}

	if(report.enable)
		psta->bss_trans_support = 1;

exit:
	return;
}

void rtw_wnm_process_btm_req(_adapter *padapter, u8* pframe, u32 frame_len)
{
	struct roam_nb_info *pnb = &(padapter->mlmepriv.nb_info);
	struct btm_req_hdr req_hdr;
	u8 *ptr, reason;
	u32 elem_len, offset;

	rtw_wnm_btm_req_hdr_parsing(pframe, &req_hdr);
	offset = rtw_wnm_btm_candidates_offset_get(pframe);
	if ((offset == 0) || ((frame_len - offset) <= 15))
		return;

	ptr = (pframe + offset);
	elem_len = (frame_len - offset);
	rtw_wnm_btm_candidates_survey(padapter, ptr, elem_len, _TRUE);
	reason = rtw_wmn_btm_rsp_reason_decision(padapter, &pframe[3]);
	rtw_wnm_issue_action(padapter,
		RTW_WLAN_ACTION_WNM_BTM_RSP, reason);

	if (reason == 0)
		rtw_wnm_roam_scan(padapter);
}

void rtw_wnm_process_wnm_notification_req(_adapter *padapter, u8 *pframe,
									u32 frame_len, struct sta_info *sta)
{
	u8 WIFI_ALLIANCE_OUI[] = {0x50, 0x6f, 0x9a};
	u8 offset = 4;
#ifdef CONFIG_RTW_MBO
	if (pframe[3] == _VENDOR_SPECIFIC_IE_) { /* type */
		while (offset < frame_len) {
			/* check non-prefer channel list header */
			if ((pframe[offset] == _VENDOR_SPECIFIC_IE_) && /* subelement id */
				(pframe[offset + 1] >= 4) && /* subelement length */
				(_rtw_memcmp(pframe + offset + 2, WIFI_ALLIANCE_OUI, 3) == _TRUE) && /* OUI */
				(pframe[offset + 5] == NON_PREFER_CHANNEL_RPT)) { /* OUI type */
				rtw_mbo_fill_non_prefer_channel_list(padapter, &sta->mbopriv,
													pframe + offset + 6, pframe[offset + 1] - 4);
				break;
			}
			offset += *(pframe + offset + 1) + 2;
		}
	}
#endif
}

void rtw_wnm_process_btm_resp(_adapter *padapter, struct sta_info *psta, u8 *pframe, u32 frame_len)
{
	u8 dialog_token;
	u8 status_code;
	u8 bss_termination_delay;
	u8 frlen = 5;
#ifdef CONFIG_CTC_FEATURE
	u8 tmpbuf[ETH_ALEN+1];
#endif

	/*802.11v required item >= 5byte */
	if (frame_len < frlen)
		return;

	if(!psta->phl_sta)
		return;

	dialog_token = pframe[2];
	status_code = pframe[3];
	bss_termination_delay = pframe[4];
#ifdef CONFIG_CTC_FEATURE
	if(padapter->registrypriv.wifi_mib.roaming_enable)
	{
#ifdef CONFIG_WLAN_EVENT_INDICATE_GENL
		_rtw_memcpy(tmpbuf, &status_code, 1);
		_rtw_memcpy(tmpbuf + 1, psta->phl_sta->mac_addr, ETH_ALEN);
		genl_wlan_IndicateEvent(padapter, EVENT_CTC_ROAMING_BSS_TRANSMIT_RESP, tmpbuf);
#endif /* CONFIG_WLAN_EVENT_INDICATE_GENL */
	}
#endif /* CONFIG_CTC_FEATURE */

#ifdef CONFIG_RTW_MULTI_AP
	if (frame_len - frlen) {
		core_map_send_btm_response_notify(padapter, padapter->mac_addr, psta->phl_sta->mac_addr, &pframe[5], status_code);
	}
	else {
		u8 empty_bssid[6] = {0};
		core_map_send_btm_response_notify(padapter, padapter->mac_addr, psta->phl_sta->mac_addr, empty_bssid, status_code);
	}
#endif
}

void rtw_wnm_reset_btm_candidate(struct roam_nb_info *pnb)
{
	pnb->preference_en = _FALSE;
	_rtw_memset(pnb->roam_target_addr, 0, ETH_ALEN);
}

void rtw_wnm_reset_btm_state(_adapter *padapter)
{
	struct roam_nb_info *pnb = &(padapter->mlmepriv.nb_info);

	pnb->last_nb_rpt_entries = 0;
	pnb->nb_rpt_is_same = _TRUE;
	pnb->nb_rpt_valid = _FALSE;
	pnb->nb_rpt_ch_list_num = 0;
	rtw_wnm_reset_btm_candidate(pnb);
	_rtw_memset(&pnb->nb_rpt, 0, sizeof(pnb->nb_rpt));
	_rtw_memset(&pnb->nb_rpt_ch_list, 0, sizeof(pnb->nb_rpt_ch_list));
}

void rtw_wnm_issue_action(_adapter *padapter, u8 action, u8 reason)
{
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct xmit_priv *pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct xmit_frame *pmgntframe;
	struct rtw_ieee80211_hdr *pwlanhdr;
	struct pkt_attrib *pattrib;
	u8 category, dialog_token, termination_delay, *pframe;
	u16 *fctrl;

	if ((pmgntframe = alloc_mgtxmitframe(pxmitpriv)) == NULL)
		return ;

	pattrib = &(pmgntframe->attrib);
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}
	_rtw_memset(pmgntframe->buf_addr, 0, (WLANHDR_OFFSET + TXDESC_OFFSET));

	pframe = (u8 *)(pmgntframe->buf_addr + TXDESC_OFFSET);
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&pmlmeinfo->network), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&pmlmeinfo->network), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	category = RTW_WLAN_CATEGORY_WNM;
	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));

	switch (action) {
		case RTW_WLAN_ACTION_WNM_BTM_QUERY:
			pframe = rtw_set_fixed_ie(pframe, 1, &(dialog_token), &(pattrib->pktlen));
			pframe = rtw_set_fixed_ie(pframe, 1, &(reason), &(pattrib->pktlen));
			RTW_INFO("WNM: RTW_WLAN_ACTION_WNM_BTM_QUERY sent.\n");
			break;
		case RTW_WLAN_ACTION_WNM_BTM_RSP:
			termination_delay = 0;
			pframe = rtw_set_fixed_ie(pframe, 1, &(dialog_token), &(pattrib->pktlen));
			pframe = rtw_set_fixed_ie(pframe, 1, &(reason), &(pattrib->pktlen));
			pframe = rtw_set_fixed_ie(pframe, 1, &(termination_delay), &(pattrib->pktlen));
			if (!is_zero_mac_addr(pmlmepriv->nb_info.roam_target_addr)) {
				pframe = rtw_set_fixed_ie(pframe, 6,
					pmlmepriv->nb_info.roam_target_addr, &(pattrib->pktlen));
			}
			RTW_INFO("WNM: RTW_WLAN_ACTION_WNM_BTM_RSP sent. reason = %d\n", reason);
			break;
		default:
			rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
			RTW_ERR("WNM: unknown action = %d.\n", action);
			goto exit;
	}

	_wnm_update_bss_status_code(padapter,get_my_bssid(&pmlmeinfo->network),reason);

	pattrib->last_txcmdsz = pattrib->pktlen;
	dump_mgntframe(padapter, pmgntframe);

exit:
	return;
}

 boolean
_u64_add(
	u32 x_l,
	u32 x_h,
	u32 y_l,
	u32 y_h,
	u32 *out_l,
	u32 *out_h
)
{
	u8 bcalc = false, boverflow = false;
	/* calculate for low 4-byte*/
	if ((0xFFFFFFFF - x_l) < y_l) {
		*out_l = y_l - (0xFFFFFFFF - x_l) - 1;
		boverflow = true;
	} else {
		*out_l = x_l + y_l;
	}
	if ((0xFFFFFFFF - x_h) < y_h) {
		RTW_ERR("_u64_add(): overflow for high 4-byte, skip calculate\n");
	} else {
		/* calculate for high 4-byte*/
		*out_h = x_h + y_h;
		bcalc = true;
	}
	/* calculate for overflow of low 4-byte*/
	if (true == bcalc && true == boverflow) {
		if ((0xFFFFFFFF - *out_h ) < 1) {
			RTW_ERR("_u64_add(): overflow for high 4-byte, skip calculate it\n");
			bcalc = false;
		} else {
			*out_h = *out_h + 1;
		}
	}

	RTW_INFO("_u64_add(): bcalc:%d, x_l:0x%x, x_h:0x%x, y_l:0x%x, y_h:0x%x, out_l:0x%x, out_h:0x%x\n",
		bcalc, x_l, x_h, y_l, y_h, *out_l, *out_h);
	return bcalc;
}

/* 5 sec for MBO logo */
#define BSS_TERMINATION_TIMEOUT 5000
#define BSS_TERMINATION_TIMEOUT_EARLY 250
void rtw_wnm_check_frames_tx(_adapter *padapter, const u8 **dump_buf, size_t *dump_len)
{
	enum rtw_phl_status pstatus = RTW_PHL_STATUS_FAILURE;
	struct mlme_priv *mlme = &padapter->mlmepriv;
	struct roam_nb_info *nb_info = &mlme->nb_info;
	void *phl = padapter->dvobj->phl;
	u8 *new_buf = NULL;
	u8 *tmp_buf = NULL;
	const u8 *subelement_ptr = *dump_buf;
	const u8 *subelement_ptr_orig;
	size_t new_len = 0;
	size_t orig_len = *dump_len;
	int subelement_offset = sizeof(struct rtw_ieee80211_hdr_3addr) + 7;
	int bss_term_offset = sizeof(struct rtw_ieee80211_hdr_3addr) + 7;
	int cur_offset = 0;
	int new_offset = 0;
	u8 subelement_id;
	u8 subelement_len;
	struct nb_rpt_hdr report;
	int ret = 0;
	u8 idx = 0;
	u8 exist_nb_report_cnt = 0;
	u8 nb_report_len = 18;
	u8 da[ETH_ALEN];
	struct sta_info *psta = NULL;
	u8 disassoc_imminent = 0;
	u8 bss_termination = 0;
	u8 preference_sta = 0;
	size_t append_len = 0;
	u32 bss_termination_delay = BSS_TERMINATION_TIMEOUT*1000; /*hardcode BSS_TERMINATION_TIMEOUT msec*/
	u8 use_default_nb = 0;
	u8 nb_count = 0;
	struct rtw_phl_port_tsf cur_tsf;

#if 0
	if(mlme->mbopriv.enable != _TRUE)
		goto exit;
#endif
	if(subelement_ptr[sizeof(struct rtw_ieee80211_hdr_3addr) + 3] & DISASSOC_IMMINENT)
		disassoc_imminent = 1;
	if(subelement_ptr[sizeof(struct rtw_ieee80211_hdr_3addr) + 3] & BSS_TERMINATION_INCLUDED)
		bss_termination = 1;

	if (bss_termination) {
		/* John: hostapd bss termination TSF is not current configurable, so driver should hardcode one for MBO logo*/
		mlme->mbopriv.bss_termination_tsf_l = LE_BITS_TO_4BYTE(subelement_ptr + subelement_offset + 2, 0, 32);
		mlme->mbopriv.bss_termination_tsf_h = LE_BITS_TO_4BYTE(subelement_ptr + subelement_offset + 6, 0, 32);
		mlme->mbopriv.bss_termination_dur = LE_BITS_TO_2BYTE(subelement_ptr + subelement_offset + 10, 0, 16);

		/* get current TSF and update */
		pstatus = rtl_phl_cmd_get_cur_tsf(phl, &cur_tsf,
				padapter->phl_role,
				PHL_CMD_WAIT, 0);
		if (RTW_PHL_STATUS_FAILURE == pstatus)
			goto exit;
		_u64_add(cur_tsf.tsf_l, cur_tsf.tsf_h,
			bss_termination_delay, 0,
			&mlme->mbopriv.bss_termination_tsf_l,
			&mlme->mbopriv.bss_termination_tsf_h);

		/* setup timer */
		if (mlme->mbopriv.bss_termination_phase == BSS_TERMINATION_NONE ||
			mlme->mbopriv.bss_termination_phase == BSS_TERMINATION_WAIT) {
			_set_timer(&mlme->mbopriv.bss_termination_timer, BSS_TERMINATION_TIMEOUT - BSS_TERMINATION_TIMEOUT_EARLY);
		} else {
			RTW_ERR("[%s]BSS termination is under process\n", __func__);
		}

		subelement_offset += 12;
		RTW_INFO("[%s]bss_termination_tsf_l = %u, bss_termination_tsf_h = %u, bss_termination_dur = %u\n",
				__func__,
				mlme->mbopriv.bss_termination_tsf_l,
				mlme->mbopriv.bss_termination_tsf_h,
				mlme->mbopriv.bss_termination_dur);
	}
	cur_offset = subelement_offset;
	new_offset = subelement_offset;

	_rtw_memcpy(da, subelement_ptr + 4, ETH_ALEN);
	psta = rtw_get_stainfo(&padapter->stapriv, da);

	if(!psta) {
		RTW_ERR("[%s]psta is NULL!\n", __func__);
		goto exit;
	}

	if(nb_info->nb_rpt_tag) /*count only tagged neighbor reports */
		append_len = nb_info->nb_rpt_tag*nb_report_len;
	else /*count all stored neighbor reports */
		append_len = nb_info->nb_rpt_num*nb_report_len;

	if (!append_len)
		RTW_PRINT("[WNM] keep wnm req content\n");

	tmp_buf = rtw_malloc(orig_len + append_len + 16);
	if (!tmp_buf) {
		rtw_warn_on(1);
		goto exit;
	}

	_rtw_memcpy(tmp_buf, *dump_buf, subelement_offset);
	new_len += subelement_offset;

	if (bss_termination) {
		SET_BITS_TO_LE_4BYTE(tmp_buf + bss_term_offset + 2, 0, 32, mlme->mbopriv.bss_termination_tsf_l);
		SET_BITS_TO_LE_4BYTE(tmp_buf + bss_term_offset + 6, 0, 32, mlme->mbopriv.bss_termination_tsf_h);
	}

	/* check _NEIGHBOR_REPORT_IE_ */
	while (cur_offset + 2 < orig_len) {
		subelement_id = *(subelement_ptr + cur_offset);
		subelement_len = *(subelement_ptr + cur_offset + 1);
		if(cur_offset + 2 + subelement_len > orig_len)
			break;
		subelement_ptr_orig = subelement_ptr + cur_offset;
		cur_offset += subelement_len + 2;

		_rtw_memcpy(tmp_buf + new_len, subelement_ptr_orig, subelement_len + 2);

		if (subelement_id == _NEIGHBOR_REPORT_IE_) {
			RTW_PRINT("[WNM] Found carried NB report\n");
			use_default_nb = 1;
			/* append preference subid (hostapd doesn't carry this subid) */
			*(tmp_buf + new_len + 2 + subelement_len) = WNM_BTM_CAND_PREF_SUBEID;
			*(tmp_buf + new_len + 2 + subelement_len + 1) = 1;
			*(tmp_buf + new_len + 2 + subelement_len + 2) = 0xff;
			subelement_len += 3;
			*(tmp_buf + new_len + 1) = subelement_len;
		}
		new_len += subelement_len + 2;
	}

	for (idx = 0; idx < RTW_MAX_NB_RPT_NUM; idx++) {
		if (1 == nb_info->nb_rpt[idx].enable) {
			nb_count++;
		}
	}

	if (use_default_nb == 0) {
		/* If new neighbor report is added, enable CANDIDATE_LIST_INCLUDED bit */
		if (append_len)
			tmp_buf[sizeof(struct rtw_ieee80211_hdr_3addr) + 3] |= PREFERRED_CANDIDATE_LIST_INCLUDED;

		for (idx = 0; idx < RTW_MAX_NB_RPT_NUM; idx++) {
			if(nb_info->nb_rpt[idx].enable == 0)
				continue;
			if(nb_info->nb_rpt_tag && !nb_info->nb_rpt[idx].tag)
				continue;
			if ((!bss_termination) &&
				(1 == nb_count) &&
				(_rtw_memcmp(nb_info->nb_rpt[idx].bssid, padapter->mac_addr, ETH_ALEN) == _TRUE)) {
				preference_sta = 0xff;
			} else {
				preference_sta = nb_info->nb_rpt[idx].preference;
			}

#ifdef CONFIG_RTW_MBO
			ret = rtw_mbo_check_channel_valid(padapter, nb_info->nb_rpt[idx], psta);
			if (ret == _FAIL) {
				RTW_INFO("rtw_mbo_check_channel_valid fail!\n");
				preference_sta = 0;
			}
#endif
			/* reset tag */
			nb_info->nb_rpt[idx].tag = 0;
			if(nb_info->nb_rpt_tag)
				nb_info->nb_rpt_tag--;

			/* check length should not larger than allocated buffer */
			if(new_len + nb_report_len > orig_len + append_len)
				continue;
			new_len += _rm_construct_nb_report(padapter, tmp_buf + new_len,
											nb_info->nb_rpt[idx], disassoc_imminent,
											preference_sta);
		}
	}

	/* alloc new buf with exactly length*/
	new_buf = rtw_malloc(new_len);
	if (!new_buf) {
		rtw_warn_on(1);
		goto exit;
	}

	/* copy content, and free tmp buffer */
	_rtw_memcpy(new_buf, tmp_buf, new_len);
	rtw_mfree(tmp_buf, orig_len + append_len + 16);

	*dump_len = new_len;
	*dump_buf = new_buf;

exit:
	return;
}

int rtw_wnm_issue_btm_request(_adapter *padapter, u8 *da,
							u8 *target_bssid, u8 channel,
							struct btm_req_hdr btm_para,
							u8 pref)
{
	int ret = _FAIL;
	int i;
	u16 val16;
	u8 action = RTW_WLAN_ACTION_WNM_BTM_REQ;
	u8 category = RTW_WLAN_CATEGORY_WNM;
	struct sta_info *psta = NULL;
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	unsigned char					*mac, *bssid;
	struct xmit_priv	*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct mlme_priv *mlme = &padapter->mlmepriv;
	struct roam_nb_info *nb_info = &mlme->nb_info;
	WLAN_BSSID_EX		*cur_network = &(pmlmeinfo->network);

	psta = rtw_get_stainfo(&padapter->stapriv, da);

	if(psta == NULL)
		goto exit;

	/* station supports 11v bss transition */
	if(!rtw_wnm_get_ext_cap_btm(psta->ext_capab_ie_data))
		goto exit;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	mac = adapter_mac_addr(padapter);
	bssid = cur_network->MacAddress;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;
	_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, mac, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, bssid, ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(fctrl, WIFI_ACTION);

	pattrib->hdrlen = sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = pattrib->hdrlen;
	pframe += pattrib->hdrlen;

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));

	if (!(++psta->dialog_token)) /* dialog token set to a non-zero value */
		psta->dialog_token++;

	pframe = rtw_set_fixed_ie(pframe, 1, &(psta->dialog_token), &(pattrib->pktlen));

	val16 = cpu_to_le16(btm_para.disassoc_timer);

	pframe = rtw_set_fixed_ie(pframe, 1, &(btm_para.req_mode), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)&(val16), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(btm_para.validity_interval), &(pattrib->pktlen));

#ifdef CONFIG_RTW_80211K
	for (i = 0; i < RTW_MAX_NB_RPT_NUM; i++) {
		if(!nb_info->nb_rpt[i].enable)
			continue;
		if(_rtw_memcmp(nb_info->nb_rpt[i].bssid, target_bssid, ETH_ALEN) != _TRUE)
			continue;
		pattrib->pktlen += _rm_construct_nb_report(padapter, pframe,
												nb_info->nb_rpt[i], 0,
												(pref ? pref : nb_info->nb_rpt[i].preference));
		break;
	}
#endif

	dump_mgntframe(padapter, pmgntframe);
	ret = _SUCCESS;
exit:
	return ret;
}

#endif

#ifdef CONFIG_RTW_MBO
void rtw_gas_init_req_check_frames_tx(_adapter *padapter, const u8 **dump_buf, size_t *dump_len)
{
	struct mlme_priv *mlme = &padapter->mlmepriv;
	struct roam_nb_info *nb_info = &mlme->nb_info;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX *cur_network = &(pmlmeinfo->network);
	u8 *new_buf = NULL;
	u8 *tmp_buf = NULL;
	const u8 *subelement_ptr = *dump_buf;
	const u8 *subelement_ptr_orig;
	size_t new_len = 0;
	size_t tmp_len = 0;
	size_t orig_len = *dump_len;
	int subelement_offset = sizeof(struct rtw_ieee80211_hdr_3addr) + 7;
	int cur_offset = subelement_offset;
	int new_offset = subelement_offset;
	u8 subelement_id;
	u8 subelement_len;
	u16 new_query_rsp_len = 0;
	u16 old_query_rsp_len = 0;
	struct nb_rpt_hdr report;
	int ret = 0;
	u8 nb_report_bitmask[(RTW_MAX_NB_RPT_NUM + 7)/8] = {0};
	u8 idx = 0;
	u8 exist_nb_report_cnt = 0;
	u16 nb_report_len = 18;
	u16 nb_rpt_element_id = 272;

	if(mlme->mbopriv.enable != _TRUE)
		goto exit;

	subelement_offset += subelement_ptr[subelement_offset + 1] + 2;

	tmp_buf = rtw_malloc(orig_len + nb_report_len + 4);
	if (!tmp_buf) {
		rtw_warn_on(1);
		goto exit;
	}

	_rtw_memcpy(tmp_buf, *dump_buf, orig_len);

	/* Advertisement Protocol element + Query Response Length*/

	old_query_rsp_len = le16_to_cpu(*(u16 *)((SIZE_PTR)tmp_buf + subelement_offset));
	new_query_rsp_len = old_query_rsp_len + nb_report_len + 4;
	RTW_INFO("[%s]old_query_rsp_len = %d, new_query_rsp_len = %d\n", __func__, old_query_rsp_len, new_query_rsp_len);
	new_query_rsp_len = cpu_to_le16(new_query_rsp_len);
	_rtw_memcpy((void*)(tmp_buf + subelement_offset), (void*)&new_query_rsp_len, 2);

	new_offset = orig_len;

	/* neighbor report element id 272 */
	nb_rpt_element_id = cpu_to_le16(nb_rpt_element_id);
	_rtw_memcpy((void*)(tmp_buf + new_offset), (void*)&nb_rpt_element_id, 2);
	new_offset += 2;

	/* neighbor report element length 18 */
	nb_report_len = cpu_to_le16(nb_report_len);
	_rtw_memcpy((void*)(tmp_buf + new_offset), (void*)&nb_report_len, 2);
	new_offset += 2;

	/* insert self nb report */
	for (idx = 0; idx < RTW_MAX_NB_RPT_NUM; idx++) {
		if(nb_info->nb_rpt[idx].enable == 0)
			continue;
		if(nb_report_bitmask[idx>>3] & (1<<(idx&7)))
			continue;
		if(_rtw_memcmp(nb_info->nb_rpt[idx].bssid, cur_network->MacAddress, ETH_ALEN) == _FALSE)
			continue;

		new_offset += _rm_construct_nb_report(padapter, tmp_buf + new_offset,
												nb_info->nb_rpt[idx], 0,
												nb_info->nb_rpt[idx].preference);
		break;
	}

	*dump_len = new_offset;
	*dump_buf = tmp_buf;

exit:
	return;
}
#endif

unsigned int OnAction_ht(_adapter *padapter, union recv_frame *precv_frame)
{
	u8 *pframe = precv_frame->u.hdr.rx_data;
	u8 *frame_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	u8 category, action;

	/* check RA matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN))
		goto exit;

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_HT)
		goto exit;

	action = frame_body[1];
	switch (action) {
	case RTW_WLAN_ACTION_HT_SM_PS:
#ifdef CONFIG_80211N_HT
#ifdef CONFIG_AP_MODE
		if (check_fwstate(&padapter->mlmepriv, WIFI_AP_STATE) == _TRUE)
			rtw_process_ht_action_smps(padapter, get_addr2_ptr(pframe), frame_body[2]);
#endif /*CONFIG_AP_MODE*/
#endif /*CONFIG_80211N_HT*/
		break;
	case RTW_WLAN_ACTION_HT_COMPRESS_BEAMFORMING:
#ifdef CONFIG_BEAMFORMING
		/*RTW_INFO("RTW_WLAN_ACTION_HT_COMPRESS_BEAMFORMING\n");*/
		rtw_beamforming_get_report_frame(padapter, precv_frame);
#endif /*CONFIG_BEAMFORMING*/
		break;
	default:
		break;
	}

exit:

	return _SUCCESS;
}

#ifdef CONFIG_IEEE80211W
unsigned int OnAction_sa_query(_adapter *padapter, union recv_frame *precv_frame)
{
	u8 *pframe = precv_frame->u.hdr.rx_data;
	struct rx_pkt_attrib *pattrib = &precv_frame->u.hdr.attrib;
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct sta_info		*psta;
	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	u16 tid;
	u8 idx = 0;
	/* Baron */

	RTW_INFO("OnAction_sa_query\n");

	psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(pframe));

#ifdef CONFIG_IOCTL_CFG80211
	if (psta != NULL) {
		RTW_PRINT("recv SA Query rsp (" MAC_FMT "), offload to hostapd\n", MAC_ARG(psta->phl_sta->mac_addr));
	}

	rtw_cfg80211_rx_action(padapter, precv_frame, NULL);
#else
	switch (pframe[WLAN_HDR_A3_LEN + 1]) {
	case 0: /* SA Query req */
		_rtw_memcpy(&tid, &pframe[WLAN_HDR_A3_LEN + 2], sizeof(u16));
		RTW_INFO("OnAction_sa_query request,action=%d, tid=%04x, pframe=%02x-%02x\n"
			, pframe[WLAN_HDR_A3_LEN + 1], tid, pframe[WLAN_HDR_A3_LEN + 2], pframe[WLAN_HDR_A3_LEN + 3]);
		issue_action_SA_Query(padapter, get_addr2_ptr(pframe), 1, tid, IEEE80211W_RIGHT_KEY);
		break;

	case 1: /* SA Query rsp */
		_rtw_memcpy(&tid, &pframe[WLAN_HDR_A3_LEN + 2], sizeof(u16));
		if (psta != NULL) {
			for (idx = 1; idx <= psta->sa_query_cnt; idx++) {
				if (psta->sa_query_tid[idx] == tid)
					break;
			}
			if (idx > psta->sa_query_cnt) { /* No match */
				RTW_INFO("macid %d: RX 11W_SA_Rsp but comeback timeout\n", psta->phl_sta->macid);
				break;
			}
			_cancel_timer_ex(&psta->dot11w_expire_timer);
			psta->sa_query_cnt = 0;
			psta->sa_query_timed_out = 0;
		}

		RTW_INFO("OnAction_sa_query response,action=%d, tid=%04x, cancel timer\n", pframe[WLAN_HDR_A3_LEN + 1], tid);
		break;
	default:
		break;
	}
#endif
	if (0) {
		int pp;
		printk("pattrib->pktlen = %d =>", pattrib->pkt_len);
		for (pp = 0; pp < pattrib->pkt_len; pp++)
			printk(" %02x ", pframe[pp]);
		printk("\n");
	}

	return _SUCCESS;
}
#endif /* CONFIG_IEEE80211W */

unsigned int on_action_rm(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_RTW_80211K
	return rm_on_action(padapter, precv_frame);
#else
	return _SUCCESS;
#endif  /* CONFIG_RTW_80211K */
}

unsigned int OnAction_wmm(_adapter *padapter, union recv_frame *precv_frame)
{
	return _SUCCESS;
}

unsigned int OnAction_vht(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_80211AC_VHT
	u8 *pframe = precv_frame->u.hdr.rx_data;
	struct rtw_ieee80211_hdr_3addr *whdr = (struct rtw_ieee80211_hdr_3addr *)pframe;
	u8 *frame_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	u8 category, action;
	struct sta_info *psta = NULL;
	struct rx_pkt_attrib *prxattrib = &precv_frame->u.hdr.attrib;


	/* check RA matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN))
		goto exit;

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_VHT)
		goto exit;

	action = frame_body[1];
	switch (action) {
	case RTW_WLAN_ACTION_VHT_COMPRESSED_BEAMFORMING:
#ifdef TX_BEAMFORMING
		/*RTW_INFO("RTW_WLAN_ACTION_VHT_COMPRESSED_BEAMFORMING\n");*/
		psta = rtw_get_stainfo(&padapter->stapriv, whdr->addr2);

		if (psta && (psta->phl_sta->is_zld_exist_csi == false)) {
			if(prxattrib->is_zld_exist){
				psta->phl_sta->is_zld_exist_csi = true;
			}
		}


		rtw_bf_get_report_packet(padapter, precv_frame);
#endif /*CONFIG_BEAMFORMING*/
		break;
	case RTW_WLAN_ACTION_VHT_OPMODE_NOTIFICATION:
		/* CategoryCode(1) + ActionCode(1) + OpModeNotification(1) */
		/* RTW_INFO("RTW_WLAN_ACTION_VHT_OPMODE_NOTIFICATION\n"); */
		psta = rtw_get_stainfo(&padapter->stapriv, whdr->addr2);
		if (psta)
			rtw_process_vht_op_mode_notify(padapter, &frame_body[2], psta);
		break;
	case RTW_WLAN_ACTION_VHT_GROUPID_MANAGEMENT:
#ifdef CONFIG_BEAMFORMING
		rtw_beamforming_get_vht_gid_mgnt_frame(padapter, precv_frame);
#endif /* CONFIG_BEAMFORMING */
		break;
	default:
		break;
	}

exit:
#endif /* CONFIG_80211AC_VHT */

	return _SUCCESS;
}

unsigned int OnAction_he(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_80211AX_HE
	u8 *pframe = precv_frame->u.hdr.rx_data;
	struct rtw_ieee80211_hdr_3addr *whdr = (struct rtw_ieee80211_hdr_3addr *)pframe;
	u8 *frame_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
	u8 category, action;
	struct sta_info *psta = NULL;
	struct rx_pkt_attrib *prxattrib = &precv_frame->u.hdr.attrib;
	void *phl = padapter->dvobj->phl;
	struct phl_info_t *phl_info = (struct phl_info_t *)phl;

	/* check RA matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN))
		goto exit;

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_HE)
		goto exit;

	action = frame_body[1];
	switch (action) {
	case RTW_WLAN_ACTION_HE_COMPRESSED_BEAMFORMING_CQI:
#ifdef TX_BEAMFORMING
		/*RTW_INFO("RTW_WLAN_ACTION_VHT_COMPRESSED_BEAMFORMING\n");*/
		psta = rtw_get_stainfo(&padapter->stapriv, whdr->addr2);

		if (psta && (psta->phl_sta->is_zld_exist_csi == false)) {
			if(prxattrib->is_zld_exist){
				psta->phl_sta->is_zld_exist_csi = true;
			}
		}

		rtw_bf_get_report_packet(padapter, precv_frame);
#endif /*CONFIG_BEAMFORMING*/
		break;

	default:
		break;
	}

exit:

#endif /* CONFIG_80211AX_HE */

	return _SUCCESS;
}

unsigned int OnAction_protected_he(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_80211AX_HE
	/* CONFIG_80211AX_HE_TODO */
#endif /* CONFIG_80211AX_HE */

	return _SUCCESS;
}


unsigned int OnAction_p2p(_adapter *padapter, union recv_frame *precv_frame)
{
#ifdef CONFIG_P2P
	u8 *frame_body;
	u8 category, OUI_Subtype, dialogToken = 0;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint len = precv_frame->u.hdr.len;
	struct	wifidirect_info	*pwdinfo = &(padapter->wdinfo);

	/* check RA matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter), GetAddr1Ptr(pframe), ETH_ALEN))
		return _SUCCESS;

	frame_body = (unsigned char *)(pframe + sizeof(struct rtw_ieee80211_hdr_3addr));

	category = frame_body[0];
	if (category != RTW_WLAN_CATEGORY_P2P)
		return _SUCCESS;

	if (cpu_to_be32(*((u32 *)(frame_body + 1))) != P2POUI)
		return _SUCCESS;

#ifdef CONFIG_IOCTL_CFG80211
	if (adapter_wdev_data(padapter)->p2p_enabled
		&& pwdinfo->driver_interface == DRIVER_CFG80211
	) {
		rtw_cfg80211_rx_action_p2p(padapter, precv_frame);
		return _SUCCESS;
	} else
#endif /* CONFIG_IOCTL_CFG80211 */
	{
		len -= sizeof(struct rtw_ieee80211_hdr_3addr);
		OUI_Subtype = frame_body[5];
		dialogToken = frame_body[6];

		switch (OUI_Subtype) {
		case P2P_NOTICE_OF_ABSENCE:

			break;

		case P2P_PRESENCE_REQUEST:

			process_p2p_presence_req(pwdinfo, pframe, len);

			break;

		case P2P_PRESENCE_RESPONSE:

			break;

		case P2P_GO_DISC_REQUEST:

			break;

		default:
			break;

		}
	}
#endif /* CONFIG_P2P */

	return _SUCCESS;

}

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
unsigned int OnAction_tbtx_token(_adapter *padapter, union recv_frame *precv_frame)
{
#define TOKEN_REQ 0x00
#define TOKEN_REL 0x01

	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *psta;
	u32 xmit_time;
	u8 *src=NULL, *pframe = precv_frame->u.hdr.rx_data;
	u8 tbtx_action_code;
	u8 i, nr_send;
	uint tx_duration = 0;

	if (padapter->tbtx_capability == _FALSE)
		goto exit;

	tbtx_action_code = *(pframe + WLAN_HDR_A3_LEN + 1);


	switch (tbtx_action_code)
	{
		case TOKEN_REQ:
			// parse duration
			tx_duration = le32_to_cpu(*(uint *)(pframe + WLAN_HDR_A3_LEN + 2));
			padapter->tbtx_duration = tx_duration/1000; // Mirocsecond to Millisecond
			ATOMIC_SET(&padapter->tbtx_tx_pause, _FALSE);
			rtw_tx_control_cmd(padapter);
			_set_timer(&pmlmeext->tbtx_xmit_timer, padapter->tbtx_duration);
			ATOMIC_SET(&padapter->tbtx_remove_tx_pause, _FALSE);
#if defined(CONFIG_SDIO_HCI) && !defined(CONFIG_SDIO_TX_TASKLET)
			_rtw_up_sema(&pxmitpriv->SdioXmitSema);
#else
			rtw_tasklet_hi_schedule(&pxmitpriv->xmit_tasklet);
#endif
			break;
#ifdef CONFIG_AP_MODE
		case TOKEN_REL:
			src = get_addr2_ptr(pframe);
			if (!src)
				goto exit;
			psta = rtw_get_stainfo(&padapter->stapriv, src);
			if (!psta)
				goto exit;

			if (ATOMIC_READ(&pstapriv->nr_token_keeper) < 1)
				goto exit;

			for (i=0; i< NR_MAXSTA_INSLOT; i++) {
				if (pstapriv->token_holder[i] == psta) {
					pstapriv->token_holder[i] = NULL;
					//RTW_INFO("macaddr1:" MAC_FMT "\n", MAC_ARG(psta->phl_sta->mac_addr));
					ATOMIC_DEC(&pstapriv->nr_token_keeper);
					break;
				}
			}

			if (ATOMIC_READ(&pstapriv->nr_token_keeper) == 0)
				_set_timer(&pmlmeext->tbtx_token_dispatch_timer, 1);

			break;
#endif
		default:
			RTW_INFO("Undefined Action Code\n");
			goto exit;
			break;
	}

exit:
	return _SUCCESS;
}

void rtw_issue_action_token_rel(_adapter *padapter)
{

	// Todo:
	// gen token
	/* Token Release Format
		Category code : 	1 Byte
		Action code : 		1 Byte */
	int ret = _FAIL;
	//u16	*fctrl;
	u8	val = 0x01;
	u8	category = RTW_WLAN_CATEGORY_TBTX;
	u8	*pframe;
	struct xmit_frame		*pmgntframe;
	struct pkt_attrib		*pattrib;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	struct	mlme_priv		*pmlmepriv = &padapter->mlmepriv;
	struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	//struct sta_info			*psta;
	//struct sta_priv			*pstapriv = &padapter->stapriv;
	//struct registry_priv		*pregpriv = &padapter->registrypriv;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/*update attribute */
	pattrib = &pmgntframe->attrib;
	update_mgnt_tx_rate(padapter, IEEE80211_OFDM_RATE_24MB); // issue action request using OFDM rate? 20190322 Bruce add
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	//fctrl = &(pwlanhdr->frame_ctl);
	//*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	// SetSeqNum??
	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(val), &(pattrib->pktlen));

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

	//RTW_INFO("%s\n", __func__);

}
#endif

unsigned int on_action_s1g(_adapter *padapter, union recv_frame *precv_frame)
{
	u8 ret = _FAIL;
	u8 *pframe = NULL;
	u8 *pframe_body = NULL;
	u8 action_code = 0;
	struct rtw_ieee80211_hdr_3addr *whdr;
	struct sta_info *psta;
	u32 frame_len = 0;

	pframe = precv_frame->u.hdr.rx_data;

	/* check RA matches or not */
	if (!_rtw_memcmp(adapter_mac_addr(padapter),
		GetAddr1Ptr(pframe), ETH_ALEN))
		goto exit;

	whdr = (struct rtw_ieee80211_hdr_3addr *)pframe;
    pframe_body = (unsigned char *)(pframe +
	sizeof(struct rtw_ieee80211_hdr_3addr));

	frame_len = precv_frame->u.hdr.len - WLAN_HDR_A3_LEN;

	action_code = pframe_body[1];
	RTW_INFO("[%s]action_code = %d\n",__func__, action_code);

	switch (action_code) {
#ifdef CONFIG_RTW_TWT
		case RTW_WLAN_ACTION_UNPROETCT_S1G_TWTSETUP:
		case RTW_WLAN_ACTION_UNPROETCT_S1G_TWTTEARDOWN:
		case RTW_WLAN_ACTION_UNPROETCT_S1G_TWTINFO:
			ret = rtw_core_twt_on_action(padapter, whdr->addr2,
										pframe_body, frame_len);
			break;
#endif
		default:
			break;
	}

exit:
	return ret;
}

unsigned int OnAction(_adapter *padapter, union recv_frame *precv_frame)
{
	int i;
	unsigned char	category;
	struct action_handler *ptable;
	unsigned char	*frame_body;
	u8 *pframe = precv_frame->u.hdr.rx_data;

	frame_body = (unsigned char *)(pframe + sizeof(struct rtw_ieee80211_hdr_3addr));

	category = frame_body[0];

	for (i = 0; i < sizeof(OnAction_tbl) / sizeof(struct action_handler); i++) {
		ptable = &OnAction_tbl[i];

		if (category == ptable->num)
			ptable->func(padapter, precv_frame);

	}

	return _SUCCESS;
}

unsigned int DoReserved(_adapter *padapter, union recv_frame *precv_frame)
{

	/* RTW_INFO("rcvd mgt frame(%x, %x)\n", (get_frame_sub_type(pframe) >> 4), *(unsigned int *)GetAddr1Ptr(pframe)); */
	return _SUCCESS;
}

struct xmit_frame *_alloc_mgtxmitframe(struct xmit_priv *pxmitpriv, bool once)
{
	struct xmit_frame *pmgntframe;

	if (once)
		pmgntframe = rtw_alloc_xmitframe_once(pxmitpriv);
	else
		pmgntframe = rtw_alloc_xmitframe_ext(pxmitpriv);

	if (pmgntframe == NULL) {
		RTW_WARN(FUNC_ADPT_FMT" alloc xmitframe fail, once:%d\n",
			 FUNC_ADPT_ARG(pxmitpriv->adapter), once);
		goto exit;
	}
#if 0 /*CONFIG_CORE_XMITBUF*/
	struct xmit_buf *pxmitbuf;
	pxmitbuf = rtw_alloc_xmitbuf_ext(pxmitpriv);
	if (pxmitbuf == NULL) {
		RTW_INFO(FUNC_ADPT_FMT" alloc xmitbuf fail\n", FUNC_ADPT_ARG(pxmitpriv->adapter));
		rtw_free_xmitframe(pxmitpriv, pmgntframe);
		pmgntframe = NULL;
		goto exit;
	}

	pmgntframe->frame_tag = MGNT_FRAMETAG;
	pmgntframe->pxmitbuf = pxmitbuf;
	pmgntframe->buf_addr = pxmitbuf->pbuf;
	pxmitbuf->priv_data = pmgntframe;
#else
	pmgntframe->frame_tag = MGNT_FRAMETAG;
#endif

exit:
	return pmgntframe;

}

inline struct xmit_frame *alloc_mgtxmitframe(struct xmit_priv *pxmitpriv)
{
	return _alloc_mgtxmitframe(pxmitpriv, _FALSE);
}

inline struct xmit_frame *alloc_mgtxmitframe_once(struct xmit_priv *pxmitpriv)
{
	return _alloc_mgtxmitframe(pxmitpriv, _TRUE);
}


/****************************************************************************

Following are some TX fuctions for WiFi MLME

*****************************************************************************/

void update_mgnt_tx_rate(_adapter *padapter, u8 rate)
{
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);

	pmlmeext->tx_rate = rate;
	/* RTW_INFO("%s(): rate = %x\n",__FUNCTION__, rate); */
}


void update_monitor_frame_attrib(_adapter *padapter, struct pkt_attrib *pattrib)
{
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(adapter_to_dvobj(padapter));
	u8	wireless_mode;
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct xmit_priv		*pxmitpriv = &padapter->xmitpriv;
	struct sta_info		*psta = NULL;
	struct sta_info		*bmc_sta = NULL;
	struct sta_priv		*pstapriv = &padapter->stapriv;

	psta = rtw_get_stainfo(pstapriv, pattrib->ra);
	bmc_sta = rtw_get_bcmc_stainfo(padapter);

	if (bmc_sta == NULL) {
		RTW_ERR("%s bmc_sta=NULL\n", __func__);
		return;
	}

	pattrib->hdrlen = 24;
	pattrib->nr_frags = 1;
	pattrib->priority = 7;
	pattrib->mac_id = bmc_sta->phl_sta->macid;
	pattrib->qsel = rtw_hal_get_qsel(padapter, QSLT_MGNT_ID);

	pattrib->pktlen = 0;

	if (pmlmeext->tx_rate == IEEE80211_CCK_RATE_1MB)
		wireless_mode = WLAN_MD_11B;
	else
		wireless_mode = WLAN_MD_11G;


#ifdef CONFIG_80211AC_VHT
	pattrib->rate = MGN_VHT1SS_MCS9;
#else
	pattrib->rate = MGN_MCS7;
#endif

#ifdef CONFIG_80211AX_HE
	/* CONFIG_80211AX_HE_TODO */
#endif

	pattrib->encrypt = _NO_PRIVACY_;
	pattrib->bswenc = _FALSE;

	pattrib->qos_en = _FALSE;
	pattrib->ht_en = 1;
	pattrib->bwmode = CHANNEL_WIDTH_20;
	pattrib->ch_offset = CHAN_OFFSET_NO_EXT;
	pattrib->sgi = _FALSE;

	pattrib->seqnum = pmlmeext->mgnt_seq;

	pattrib->retry_ctrl = _TRUE;

	pattrib->mbssid = 0;
	pattrib->hw_ssn_sel = pxmitpriv->hw_ssn_seq_no;

}


sint update_mgntframe_attrib(_adapter *padapter, struct pkt_attrib *pattrib)
{
	u8	wireless_mode;
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct xmit_priv		*pxmitpriv = &padapter->xmitpriv;
	struct sta_info		*bmc_sta = NULL;

#ifdef CONFIG_P2P_PS_NOA_USE_MACID_SLEEP
	struct wifidirect_info *pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P_PS_NOA_USE_MACID_SLEEP */

	/* _rtw_memset((u8 *)(pattrib), 0, sizeof(struct pkt_attrib)); */

	bmc_sta = rtw_get_bcmc_stainfo(padapter);
	if (bmc_sta == NULL) {
		RTW_ERR("%s bmc_sta=NULL\n", __func__);
		return _FAIL;
	}
	pattrib->type = WIFI_MGT_TYPE;
	pattrib->hdrlen = 24;
	pattrib->nr_frags = 1;
	pattrib->priority = 0;
	pattrib->mac_id = bmc_sta->phl_sta->macid;
	pattrib->qsel = rtw_hal_get_qsel(padapter, QSLT_MGNT_ID);

#ifdef CONFIG_MCC_MODE
	update_mcc_mgntframe_attrib(padapter, pattrib);
#endif


#ifdef CONFIG_P2P_PS_NOA_USE_MACID_SLEEP
#ifdef CONFIG_CONCURRENT_MODE
	if (rtw_mi_buddy_check_fwstate(padapter, WIFI_ASOC_STATE))
#endif /* CONFIG_CONCURRENT_MODE */
		if (MLME_IS_GC(padapter)) {
			if (pwdinfo->p2p_ps_mode > P2P_PS_NONE) {
				struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
				struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
				WLAN_BSSID_EX *cur_network = &(pmlmeinfo->network);
				struct sta_priv *pstapriv = &padapter->stapriv;
				struct sta_info *psta;

				psta = rtw_get_stainfo(pstapriv, cur_network->MacAddress);
				if (psta) {
					/* use macid sleep during NoA, mgmt frame use ac queue & ap macid */
					pattrib->mac_id = psta->phl_sta->macid;
					pattrib->qsel = rtw_hal_get_qsel(padapter, QSLT_VO_ID);
				} else {
					if (pwdinfo->p2p_ps_state != P2P_PS_DISABLE)
						RTW_ERR("%s , psta was NULL\n", __func__);
				}
			}
		}
#endif /* CONFIG_P2P_PS_NOA_USE_MACID_SLEEP */


	pattrib->pktlen = 0;

	if (IS_CCK_RATE(pmlmeext->tx_rate))
		wireless_mode = WLAN_MD_11B;
	else
		wireless_mode = WLAN_MD_11G;
	pattrib->rate = pmlmeext->tx_rate;

	pattrib->encrypt = _NO_PRIVACY_;
	pattrib->bswenc = _FALSE;

	pattrib->qos_en = _FALSE;
	pattrib->ht_en = _FALSE;
	pattrib->bwmode = CHANNEL_WIDTH_20;
	pattrib->ch_offset = CHAN_OFFSET_NO_EXT;
	pattrib->sgi = _FALSE;

	pattrib->seqnum = pmlmeext->mgnt_seq;

	pattrib->retry_ctrl = _TRUE;

	pattrib->mbssid = 0;
	pattrib->hw_ssn_sel = pxmitpriv->hw_ssn_seq_no;
#ifdef CONFIG_24G_256QAM
	pattrib->tx_force_rate = INV_TXFORCE_VAL;
#endif
	return _SUCCESS;
}

void update_mgntframe_attrib_addr(_adapter *padapter, struct xmit_frame *pmgntframe)
{
	u8	*pframe;
	struct pkt_attrib	*pattrib = &pmgntframe->attrib;
#if defined(CONFIG_BEAMFORMING) || defined(CONFIG_ANTENNA_DIVERSITY)
	struct sta_info		*sta = NULL;
#endif

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;

	_rtw_memcpy(pattrib->ra, GetAddr1Ptr(pframe), ETH_ALEN);
	_rtw_memcpy(pattrib->ta, get_addr2_ptr(pframe), ETH_ALEN);

#if defined(CONFIG_BEAMFORMING) || defined(CONFIG_ANTENNA_DIVERSITY)
	sta = pattrib->psta;
	if (!sta) {
		sta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
		pattrib->psta = sta;
	}
	#ifdef CONFIG_BEAMFORMING
	if (sta)
		update_attrib_txbf_info(padapter, pattrib, sta);
	#endif
#endif /* defined(CONFIG_BEAMFORMING) || defined(CONFIG_ANTENNA_DIVERSITY) */
}

s32 dump_mgntframe(_adapter *padapter, struct xmit_frame *pmgntframe)
{
	if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)) || (padapter->netif_up == _FALSE)) {
		#if 0 /*CONFIG_CORE_XMITBUF*/
		rtw_free_xmitbuf(&padapter->xmitpriv, pmgntframe->pxmitbuf);
		#endif
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		RTW_WARN(FUNC_ADPT_FMT" cancle TX MGNT. (%pX)\n",
			 FUNC_ADPT_ARG(padapter), pmgntframe);
		return _FAIL;
	}

	/*rtw_hal_mgnt_xmit(padapter, pmgntframe);*/
	return rtw_mgnt_xmit(padapter, pmgntframe);
}

s32 dump_mgntframe_and_wait(_adapter *padapter, struct xmit_frame *pmgntframe, int timeout_ms)
{
	s32 ret = _FAIL;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;

	#if 0 /*CONFIG_CORE_XMITBUF*/
	struct xmit_buf *pxmitbuf = pmgntframe->pxmitbuf;
	struct submit_ctx sctx;
	unsigned long sp_flags;

	if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter))) {
		rtw_free_xmitbuf(&padapter->xmitpriv, pmgntframe->pxmitbuf);
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return ret;
	}

	rtw_sctx_init(&sctx, timeout_ms);
	pxmitbuf->sctx = &sctx;

	/*ret = rtw_hal_mgnt_xmit(padapter, pmgntframe);*/
	ret = rtw_mgnt_xmit(padapter, pmgntframe);

	if (ret == _SUCCESS)
		ret = rtw_sctx_wait(&sctx, __func__);

	_rtw_spinlock_irq(&pxmitpriv->lock_sctx, &sp_flags);
	pxmitbuf->sctx = NULL;
	_rtw_spinunlock_irq(&pxmitpriv->lock_sctx, &sp_flags);
	#else
	if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter))) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return ret;
	}
	#endif
	return ret;
}

static void _mgnt_txsts(struct rtw_txfb_t *txfb)
{
	if (txfb == NULL) {
		RTW_ERR("%s: NULL TXFB\n", __FUNCTION__);
		return;
	}

	#ifdef CONFIG_RTW_DBG_TX_MGNT
	do {
		struct xmit_frame *pmgntframe = txfb->drvpriv;
		_adapter *padapter;

		padapter = pmgntframe ? pmgntframe->padapter : NULL;

		if (padapter == NULL) {
			RTW_WARN("%s: NULL adapter\n", __FUNCTION__);
		} else if (padapter->dbg_tx_mgnt) {
			RTW_PRINT(ADPT_FMT" TX MGNT done: %u (%pX)\n",
				  ADPT_ARG(padapter), txfb->txsts,
				  pmgntframe);
		}
	} while (0);
	#endif /* CONFIG_RTW_DBG_TX_MGNT */

	if (txfb->ctx) {
		struct submit_ctx *sctx = txfb->ctx;

		rtw_sctx_done_err((struct submit_ctx **)&txfb->ctx,
				  (  txfb->txsts == TX_STATUS_TX_DONE
				   ? RTW_SCTX_DONE_SUCCESS
				   : RTW_SCTX_DONE_UNKNOWN));
		rtw_sctx_free(sctx);
	} else {
		RTW_ERR("%s: NULL sctx\n", __FUNCTION__);
	}
}

s32 dump_mgntframe_and_wait_ack_timeout(_adapter *padapter,
                                        struct xmit_frame *pmgntframe,
                                        int timeout_ms)
{
#if 0 /*def CONFIG_XMIT_ACK*/
	static u8 seq_no = 0;
	s32 ret = _FAIL;
	struct xmit_priv	*pxmitpriv = &(GET_PRIMARY_ADAPTER(padapter))->xmitpriv;

	if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter))) {
		rtw_free_xmitbuf(&padapter->xmitpriv, pmgntframe->pxmitbuf);
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return -1;
	}

	_rtw_mutex_lock_interruptible(&pxmitpriv->ack_tx_mutex);
	pxmitpriv->ack_tx = _TRUE;
	pxmitpriv->seq_no = seq_no++;
	pmgntframe->ack_report = 1;
	rtw_sctx_init(&(pxmitpriv->ack_tx_ops), timeout_ms);
	/*if (rtw_hal_mgnt_xmit(padapter, pmgntframe) == _SUCCESS)*/
	if (rtw_intf_mgnt_xmit(padapter, pmgntframe) == _SUCCESS)
		ret = rtw_sctx_wait(&(pxmitpriv->ack_tx_ops), __func__);

	pxmitpriv->ack_tx = _FALSE;
	_rtw_mutex_unlock(&pxmitpriv->ack_tx_mutex);

	return ret;
#else /* !CONFIG_XMIT_ACK */
	s32 ret = _SUCCESS;
	struct rtw_txfb_t *txfb;
	struct submit_ctx *sctx = rtw_sctx_alloc(padapter);

	if (sctx == NULL) {
		RTW_WARN(ADPT_FMT" OOM! TX managment without wait.\n",
		         ADPT_ARG(padapter));

		ret = dump_mgntframe(padapter, pmgntframe);
		return ret;
	}

	#ifdef CONFIG_XMIT_MGMT_ACK
	txfb = &pmgntframe->ack_rpt.txfb;
	pmgntframe->ack_rpt.ctx_buf_len = 0;
	#else /* CONFIG_XMIT_MGMT_ACK */
	txfb = (struct rtw_txfb_t *)(pmgntframe->buf_addr + 1024);
	#endif /* CONFIG_XMIT_MGMT_ACK */

	rtw_sctx_init(sctx, timeout_ms);

	txfb->ctx = sctx;
	txfb->drvpriv = pmgntframe;
	txfb->txfb_cb = _mgnt_txsts;
	pmgntframe->phl_txreq->txfb = txfb;

	/* Increase reference count for TX so that later one to call
	  rtw_sctx_free could free sctx. */
	ATOMIC_INC(&sctx->ref_count);
	ret = dump_mgntframe(padapter, pmgntframe);

	if (ret == _SUCCESS) {
		ret = rtw_sctx_wait(sctx, __func__);
	} else {
		RTW_WARN(FUNC_ADPT_FMT" TX MGNT failed. (%pX)\n",
		         FUNC_ADPT_ARG(padapter), pmgntframe);
		/* Not successfully put to TX. Reduce the use count */
		ATOMIC_DEC(&sctx->ref_count);
	}

	rtw_sctx_free(sctx);

	#if 0 /* def CONFIG_RTW_DBG_TX_MGNT */
	if (padapter->dbg_tx_mgnt)  {
		u8 ba[] = {0x01, 0x23, 0x45,0x67, 0x89, 0xab};
		issue_probereq(padapter, NULL, ba);
	}
	#endif

	return ret;
#endif /* !CONFIG_XMIT_ACK */
}

s32 dump_mgntframe_and_wait_ack(_adapter *padapter, struct xmit_frame *pmgntframe)
{
	/* In this case, use 500 ms as the default wait_ack timeout */
#ifdef PLATFORM_ECOS
	return dump_mgntframe(padapter, pmgntframe);
#else
	return dump_mgntframe_and_wait_ack_timeout(padapter, pmgntframe, 500);
#endif
}

#ifdef RTW_PHL_BCN //core ops
s32 rtw_core_issue_beacon(_adapter *padapter, struct xmit_frame *pmgntframe)
{
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct rtw_wifi_role_t	*wrole = padapter->phl_role;
	struct rtw_bcn_info_cmn *bcn_cmn = NULL;
	struct pkt_attrib	*pattrib = &pmgntframe->attrib;
	#ifdef RTW_WKARD_BCNINT_DBG
	struct wifi_mib_priv *mib = &GET_PRIMARY_ADAPTER(padapter)->registrypriv.wifi_mib;
	#endif
	u8	*pframe = (u8 *)(pmgntframe->buf_addr);
	void *phl = padapter->dvobj->phl;
	u8 *pie_start, *pie_get = NULL;
	u32 total_ielen, get_ielen = 0;

	if(!wrole)
		return _FAIL;

	if(pattrib->pktlen > MAX_BCN_SIZE)
		return _FAIL;

	bcn_cmn = &wrole->bcn_cmn;

	_rtw_memcpy(bcn_cmn->bcn_buf, pframe, pattrib->pktlen);
	bcn_cmn->bcn_length = pattrib->pktlen;

	/* set ie offset */
	pie_start = pframe + (sizeof(struct rtw_ieee80211_hdr_3addr) + _FIXED_IE_LENGTH_);
	total_ielen = pattrib->pktlen - (sizeof(struct rtw_ieee80211_hdr_3addr) + _FIXED_IE_LENGTH_);

	pie_get = rtw_get_ie(pie_start, _TIM_IE_, &get_ielen, total_ielen);

	if (pie_get)
		bcn_cmn->ie_offset_tim = (u32)(pie_get - pie_start) + _FIXED_IE_LENGTH_;

#ifdef CONFIG_CSA_IE
	if ((pie_get = rtw_get_ie(pie_start, WLAN_EID_CHANNEL_SWITCH, &get_ielen, total_ielen)) != NULL) {
		bcn_cmn->offset_csa_cntdown = (u32)(pie_get - pframe) + 4;

		RTW_INFO("CSA beacon, pktlen: %u, pframe: %p, pie_start: %p, pie_get: %p, total_ielen: %u, csa_offset: %u, value: %u\n",
			pattrib->pktlen, pframe, pie_start, pie_get, total_ielen, bcn_cmn->offset_csa_cntdown, (u8)*(pframe + bcn_cmn->offset_csa_cntdown));

	} else {
		bcn_cmn->offset_csa_cntdown = 0;
	}
#endif
#ifdef CONFIG_ECSA_IE
	if ((pie_get = rtw_get_ie(pie_start, WLAN_EID_EXTENDED_CHANNEL_SWITCH, &get_ielen, total_ielen)) != NULL) {
		bcn_cmn->offset_ecsa_cntdown = (u32)(pie_get - pframe) + 5;

		RTW_INFO("ECSA beacon, pktlen: %u, pframe: %p, pie_start: %p, pie_get: %p, total_ielen: %u, csa_offset: %u, value: %u\n",
			pattrib->pktlen, pframe, pie_start, pie_get, total_ielen, bcn_cmn->offset_ecsa_cntdown, (u8)*(pframe + bcn_cmn->offset_ecsa_cntdown));

	} else {
		bcn_cmn->offset_ecsa_cntdown = 0;
	}
#endif

	if (bcn_cmn->bcn_added) {
		#ifdef RTW_WKARD_BCNINT_DBG
		if (mib->bcnint) {
			RTW_INFO(ADPT_FMT": beacon interval using mib setting from %u to %u.\n",
			          ADPT_ARG(padapter), bcn_cmn->bcn_interval,
			          mib->bcnint);
			bcn_cmn->bcn_interval = mib->bcnint;
		} else
		#endif
		if (bcn_cmn->bcn_interval != pmlmeinfo->bcn_interval) {
			RTW_INFO(ADPT_FMT": beacon interval changed from %u to %u.\n",
			          ADPT_ARG(padapter), bcn_cmn->bcn_interval,
			          pmlmeinfo->bcn_interval);
			bcn_cmn->bcn_interval = pmlmeinfo->bcn_interval;
		}
		if (bcn_cmn->bcn_dtim != pmlmeinfo->dtim_period) {
			RTW_INFO(ADPT_FMT": DTIM count changed from %u to %u.\n",
			          ADPT_ARG(padapter), bcn_cmn->bcn_dtim,
			          pmlmeinfo->dtim_period);
			bcn_cmn->bcn_dtim = wrole->dtim_period = pmlmeinfo->dtim_period;
		}

		rtw_phl_cmd_issue_beacon(phl, padapter->phl_role, bcn_cmn, PHL_CMD_DIRECTLY, 0);
	} else {
		WLAN_BSSID_EX *cur_network = &(pmlmeinfo->network);

		_rtw_memcpy(bcn_cmn->bssid, get_my_bssid(cur_network), ETH_ALEN);
		bcn_cmn->bcn_id = padapter->iface_id;
		bcn_cmn->role_idx = wrole->id;
		bcn_cmn->bcn_interval = pmlmeinfo->bcn_interval;
		bcn_cmn->bcn_offload = (BIT(BCN_HW_SEQ) | BIT(BCN_HW_TIM));

		if (pmlmeext->cur_channel <= 14)
			bcn_cmn->bcn_rate = RTW_DATA_RATE_CCK1;
		else
			bcn_cmn->bcn_rate = RTW_DATA_RATE_OFDM6;
		rtw_phl_cmd_issue_beacon(phl, padapter->phl_role, bcn_cmn, PHL_CMD_DIRECTLY, 0);
		bcn_cmn->bcn_added = 1;

		/*
				[todo]
				bcn_id: mbssid-ieee
				bcn_offload: tbd
				bcn_rate, 0=cck 1=ofdm, 2mac can NOT cck
		*/
	}

	return _SUCCESS;
}
#endif

int update_hidden_ssid(u8 *ies, u32 ies_len, u8 hidden_ssid_mode)
{
	u8 *ssid_ie;
	sint ssid_len_ori;
	int len_diff = 0;

	ssid_ie = rtw_get_ie(ies,  WLAN_EID_SSID, &ssid_len_ori, ies_len);

	/* RTW_INFO("%s hidden_ssid_mode:%u, ssid_ie:%p, ssid_len_ori:%d\n", __FUNCTION__, hidden_ssid_mode, ssid_ie, ssid_len_ori); */

	if (ssid_ie && ssid_len_ori > 0) {
		switch (hidden_ssid_mode) {
		case 1: {
			u8 *next_ie = ssid_ie + 2 + ssid_len_ori;
			u32 remain_len = 0;

			remain_len = ies_len - (next_ie - ies);

			ssid_ie[1] = 0;
			_rtw_memcpy(ssid_ie + 2, next_ie, remain_len);
			len_diff -= ssid_len_ori;

			break;
		}
		case 2:
			_rtw_memset(&ssid_ie[2], 0, ssid_len_ori);
			break;
		default:
			break;
		}
	}

	return len_diff;
}

void issue_beacon(_adapter *padapter, int timeout_ms)
{
	struct xmit_frame	*pmgntframe;
	struct pkt_attrib	*pattrib;
	unsigned char	*pframe;
	struct rtw_ieee80211_hdr *pwlanhdr;
	unsigned short *fctrl;
	unsigned int	rate_len;
	struct xmit_priv	*pxmitpriv = &(padapter->xmitpriv);
#if defined(CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME)
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
#endif /* #if defined (CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME) */
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX		*cur_network = &(pmlmeinfo->network);
	u8	bc_addr[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P */
#ifdef CONFIG_CSA_IE
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
#endif
	bool reorder = 0;

	/* RTW_INFO("%s\n", __FUNCTION__); */

#if 0 /*def CONFIG_BCN_ICF*/
	pmgntframe = rtw_alloc_bcnxmitframe(pxmitpriv);
#else
	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
#endif
	if (pmgntframe == NULL)
	{
		RTW_ERR("%s, alloc mgnt frame fail\n", __FUNCTION__);
		return;
	}

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

#if defined(CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME)
	_rtw_spinlock_bh(&pmlmepriv->bcn_update_lock);
#endif /* #if defined (CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME) */

	pattrib->qsel = rtw_hal_get_qsel(padapter,QSLT_BEACON_ID);

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;


	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, bc_addr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(cur_network), ETH_ALEN);

	SetSeqNum(pwlanhdr, 0/*pmlmeext->mgnt_seq*/);
	/* pmlmeext->mgnt_seq++; */
	set_frame_sub_type(pframe, WIFI_BEACON);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->hdrlen = sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	if (MLME_IS_AP(padapter) || MLME_IS_MESH(padapter)) {
		/* RTW_INFO("ie len=%d\n", cur_network->IELength); */
#ifdef CONFIG_P2P
		/* for P2P : Primary Device Type & Device Name */
		u32 wpsielen = 0, insert_len = 0;
		u8 *wpsie = NULL;
		wpsie = rtw_get_wps_ie(cur_network->IEs + _FIXED_IE_LENGTH_, cur_network->IELength - _FIXED_IE_LENGTH_, NULL, &wpsielen);

		if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO) && wpsie && wpsielen > 0) {
			uint wps_offset, remainder_ielen;
			u8 *premainder_ie, *pframe_wscie;

			wps_offset = (uint)(wpsie - cur_network->IEs);

			premainder_ie = wpsie + wpsielen;

			remainder_ielen = cur_network->IELength - wps_offset - wpsielen;

#ifdef CONFIG_IOCTL_CFG80211
			if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211) {
				if (pmlmepriv->wps_beacon_ie && pmlmepriv->wps_beacon_ie_len > 0) {
					_rtw_memcpy(pframe, cur_network->IEs, wps_offset);
					pframe += wps_offset;
					pattrib->pktlen += wps_offset;

					_rtw_memcpy(pframe, pmlmepriv->wps_beacon_ie, pmlmepriv->wps_beacon_ie_len);
					pframe += pmlmepriv->wps_beacon_ie_len;
					pattrib->pktlen += pmlmepriv->wps_beacon_ie_len;

					/* copy remainder_ie to pframe */
					_rtw_memcpy(pframe, premainder_ie, remainder_ielen);
					pframe += remainder_ielen;
					pattrib->pktlen += remainder_ielen;
				} else {
					_rtw_memcpy(pframe, cur_network->IEs, cur_network->IELength);
					pframe += cur_network->IELength;
					pattrib->pktlen += cur_network->IELength;
				}
			} else
#endif /* CONFIG_IOCTL_CFG80211 */
			{
				pframe_wscie = pframe + wps_offset;
				_rtw_memcpy(pframe, cur_network->IEs, wps_offset + wpsielen);
				pframe += (wps_offset + wpsielen);
				pattrib->pktlen += (wps_offset + wpsielen);

				/* now pframe is end of wsc ie, insert Primary Device Type & Device Name */
				/*	Primary Device Type */
				/*	Type: */
				*(u16 *)(pframe + insert_len) = cpu_to_be16(WPS_ATTR_PRIMARY_DEV_TYPE);
				insert_len += 2;

				/*	Length: */
				*(u16 *)(pframe + insert_len) = cpu_to_be16(0x0008);
				insert_len += 2;

				/*	Value: */
				/*	Category ID */
				*(u16 *)(pframe + insert_len) = cpu_to_be16(WPS_PDT_CID_MULIT_MEDIA);
				insert_len += 2;

				/*	OUI */
				*(u32 *)(pframe + insert_len) = cpu_to_be32(WPSOUI);
				insert_len += 4;

				/*	Sub Category ID */
				*(u16 *)(pframe + insert_len) = cpu_to_be16(WPS_PDT_SCID_MEDIA_SERVER);
				insert_len += 2;


				/*	Device Name */
				/*	Type: */
				*(u16 *)(pframe + insert_len) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
				insert_len += 2;

				/*	Length: */
				*(u16 *)(pframe + insert_len) = cpu_to_be16(pwdinfo->device_name_len);
				insert_len += 2;

				/*	Value: */
				_rtw_memcpy(pframe + insert_len, pwdinfo->device_name, pwdinfo->device_name_len);
				insert_len += pwdinfo->device_name_len;


				/* update wsc ie length */
				*(pframe_wscie + 1) = (wpsielen - 2) + insert_len;

				/* pframe move to end */
				pframe += insert_len;
				pattrib->pktlen += insert_len;

				/* copy remainder_ie to pframe */
				_rtw_memcpy(pframe, premainder_ie, remainder_ielen);
				pframe += remainder_ielen;
				pattrib->pktlen += remainder_ielen;
			}
		} else
#endif /* CONFIG_P2P */
		{
			int len_diff=0;
			_rtw_memcpy(pframe, cur_network->IEs, cur_network->IELength);
			if(cur_network->IELength >= (u32)_BEACON_IE_OFFSET_){
				len_diff = update_hidden_ssid(
						   pframe + _BEACON_IE_OFFSET_
					   , cur_network->IELength - _BEACON_IE_OFFSET_
						   , pmlmeinfo->hidden_ssid_mode
					   );
			}else{
				RTW_PRINT("IELength:%d\n", cur_network->IELength);
			}
			pframe += (cur_network->IELength + len_diff);
			pattrib->pktlen += (cur_network->IELength + len_diff);
		}

		{
			u8 *wps_ie;
			uint wps_ielen;
			u8 sr = 0;
			wps_ie = rtw_get_wps_ie(pmgntframe->buf_addr + TXDESC_OFFSET + sizeof(struct rtw_ieee80211_hdr_3addr) + _BEACON_IE_OFFSET_,
				pattrib->pktlen - sizeof(struct rtw_ieee80211_hdr_3addr) - _BEACON_IE_OFFSET_, NULL, &wps_ielen);
			if (wps_ie && wps_ielen > 0)
				rtw_get_wps_attr_content(wps_ie,  wps_ielen, WPS_ATTR_SELECTED_REGISTRAR, (u8 *)(&sr), NULL);
			if (sr != 0)
				set_fwstate(pmlmepriv, WIFI_UNDER_WPS);
			else
				_clr_fwstate_(pmlmepriv, WIFI_UNDER_WPS);
		}

#if 0 /* hostapd may have bring RM Capability down, don't need to construct again*/
#ifdef CONFIG_RTW_80211K
		pframe = rtw_set_ie(pframe, _EID_RRM_EN_CAP_IE_,
			sizeof(padapter->rmpriv.rm_en_cap_def),
			padapter->rmpriv.rm_en_cap_def, &pattrib->pktlen);
#endif
#endif

#ifdef CONFIG_P2P
		if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
			u32 len;
#ifdef CONFIG_IOCTL_CFG80211
			if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211) {
				len = pmlmepriv->p2p_beacon_ie_len;
				if (pmlmepriv->p2p_beacon_ie && len > 0)
					_rtw_memcpy(pframe, pmlmepriv->p2p_beacon_ie, len);
			} else
#endif /* CONFIG_IOCTL_CFG80211 */
			{
				len = build_beacon_p2p_ie(pwdinfo, pframe);
			}

			pframe += len;
			pattrib->pktlen += len;

#ifdef CONFIG_MCC_MODE
			pframe = rtw_hal_mcc_append_go_p2p_ie(padapter, pframe, &pattrib->pktlen);
#endif /* CONFIG_MCC_MODE*/

#ifdef CONFIG_WFD
			len = rtw_append_beacon_wfd_ie(padapter, pframe);
			pframe += len;
			pattrib->pktlen += len;
#endif
		}
#endif /* CONFIG_P2P */

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
		pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_BEACON_VENDOR_IE_BIT);
#endif


#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
		if (padapter->tbtx_capability == _TRUE)
			pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, 8, REALTEK_TBTX_IE, &pattrib->pktlen);
#endif

#ifdef CONFIG_CSA_IE
		if (rfctl->csa_ch) {
			u8 csa_bw = pmlmeext->cur_bwmode;
			u8 csa_offset = pmlmeext->cur_ch_offset;

			if (rtw_get_bw_offset_by_op_class_ch(rfctl->csa_op_class, rfctl->csa_ch, &csa_bw, &csa_offset) == 0) {
				RTW_ERR("[%s %d] invalid op_class(%u) and ch(%u), change to use current bw(%u) and offset(%u)\n",
					__func__, __LINE__, rfctl->csa_op_class, rfctl->csa_ch, csa_bw, csa_offset);
				rfctl->csa_op_class = rtw_get_op_class_by_chbw(rfctl->csa_ch, csa_bw, csa_offset);
			}

#ifdef CONFIG_ECSA_IE
			if (rfctl->ecsa_set_ie) {
				pframe = rtw_set_ie_extended_ch_switch(pframe, &(pattrib->pktlen),
					rfctl->csa_switch_mode, rfctl->csa_op_class, rfctl->csa_ch, rfctl->csa_cntdown);
				reorder = 1;
			}
#endif

			if (rfctl->csa_set_ie) {
				pframe = rtw_set_ie_ch_switch(pframe, &(pattrib->pktlen),
					rfctl->csa_switch_mode, rfctl->csa_ch, rfctl->csa_cntdown);
				reorder = 1;
			}

			if (rfctl->csa_set_ie
#ifdef CONFIG_ECSA_IE
				|| rfctl->ecsa_set_ie
#endif
				) {
				pframe = rtw_set_ie_ch_switch_wrapper(pframe, &(pattrib->pktlen), csa_bw,
					rtw_get_center_ch(rfctl->csa_ch, csa_bw, csa_offset));
				reorder = 1;
			}

			RTW_INFO("[%s %u] csa_bw: %u, csa_offset: %u\n", __func__, __LINE__, csa_bw, csa_offset);
		}
#endif
#ifdef CONFIG_NEC_MULTI_STAGE
		if(padapter->registrypriv.wifi_mib.stage)
			pframe = rtw_set_multistage_ie(padapter, pframe, &(pattrib->pktlen));
#endif
#ifdef CONFIG_NEC_TV_MODE
		pframe = rtw_set_tvmode_ie(padapter, pframe, &(pattrib->pktlen));
#endif
		goto _issue_bcn;
	}

	/* below for ad-hoc mode */

	/* timestamp will be inserted by hardware */
	pframe += 8;
	pattrib->pktlen += 8;

	/* beacon interval: 2 bytes */

	_rtw_memcpy(pframe, (unsigned char *)(rtw_get_beacon_interval_from_ie(cur_network->IEs)), 2);

	pframe += 2;
	pattrib->pktlen += 2;

	/* capability info: 2 bytes */

	_rtw_memcpy(pframe, (unsigned char *)(rtw_get_capability_from_ie(cur_network->IEs)), 2);

	pframe += 2;
	pattrib->pktlen += 2;

	/* SSID */
	pframe = rtw_set_ie(pframe, _SSID_IE_, cur_network->Ssid.SsidLength, cur_network->Ssid.Ssid, &pattrib->pktlen);

	/* supported rates... */
	rate_len = rtw_get_rateset_len(cur_network->SupportedRates);
	pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_, ((rate_len > 8) ? 8 : rate_len), cur_network->SupportedRates, &pattrib->pktlen);

	/* DS parameter set */
	pframe = rtw_set_ie(pframe, _DSSET_IE_, 1, (unsigned char *)&(cur_network->Configuration.DSConfig), &pattrib->pktlen);

	/* if( (pmlmeinfo->state&0x03) == WIFI_FW_ADHOC_STATE) */
	{
		u8 erpinfo = 0;
		u32 ATIMWindow;
		/* IBSS Parameter Set... */
		/* ATIMWindow = cur->Configuration.ATIMWindow; */
		ATIMWindow = 0;
		pframe = rtw_set_ie(pframe, _IBSS_PARA_IE_, 2, (unsigned char *)(&ATIMWindow), &pattrib->pktlen);

		/* ERP IE */
		pframe = rtw_set_ie(pframe, _ERPINFO_IE_, 1, &erpinfo, &pattrib->pktlen);
	}


	/* EXTERNDED SUPPORTED RATE */
	if (rate_len > 8)
		pframe = rtw_set_ie(pframe, _EXT_SUPPORTEDRATES_IE_, (rate_len - 8), (cur_network->SupportedRates + 8), &pattrib->pktlen);


	/* todo:HT for adhoc */

_issue_bcn:
	if (reorder) {
		pframe = (u8 *)pwlanhdr;
		pattrib->pktlen += rtw_fix_ie(pframe +
					      pattrib->hdrlen +
					      _BEACON_IE_OFFSET_,
					      pattrib->pktlen -
					      pattrib->hdrlen -
					      _BEACON_IE_OFFSET_,
					      WIFI_BEACON);
	}

#if defined(CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME)
	pmlmepriv->update_bcn = _FALSE;

	_rtw_spinunlock_bh(&pmlmepriv->bcn_update_lock);
#endif /* #if defined (CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME) */

	if ((pattrib->pktlen + TXDESC_SIZE) > MAX_BEACON_LEN) {
		RTW_ERR("beacon frame too large ,len(%d,%d)\n",
			(pattrib->pktlen + TXDESC_SIZE), MAX_BEACON_LEN);
		rtw_warn_on(1);
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	pattrib->last_txcmdsz = pattrib->pktlen;

	/* RTW_INFO("issue bcn_sz=%d\n", pattrib->last_txcmdsz); */

#ifdef RTW_PHL_BCN
	rtw_core_issue_beacon(padapter, pmgntframe);

	#if 0 /*CONFIG_CORE_XMITBUF*/
	rtw_free_xmitbuf(&padapter->xmitpriv, pmgntframe->pxmitbuf);
	#endif
	rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
#else
	if (timeout_ms > 0)
		dump_mgntframe_and_wait(padapter, pmgntframe, timeout_ms);
	else
		dump_mgntframe(padapter, pmgntframe);
#endif

}

void issue_probersp(_adapter *padapter, unsigned char *da, u8 is_valid_p2p_probereq)
{
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	unsigned char					*mac, *bssid;
	struct xmit_priv	*pxmitpriv = &(padapter->xmitpriv);
#if defined(CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME)
	u8 *pwps_ie;
	uint wps_ielen;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
#endif /* #if defined (CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME) */
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX		*cur_network = &(pmlmeinfo->network);
	unsigned int	rate_len;
#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P */
#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	u32 vendor_ie_num=0;
	_timeval tv;
#endif
	/* RTW_INFO("%s\n", __FUNCTION__); */

	if (da == NULL)
		return;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

#ifdef CONFIG_BAND_STEERING
	if (_band_steering_block_chk(padapter, da))
		return;
#endif
#ifdef RTW_BLOCK_STA_CONNECT
	if(block_sta_conn_chk(padapter, da)){
		printk("(%s)block sta(%02x%02x%02x%02x%02x%02x) connect\n", __FUNCTION__,da[0],da[1],da[2],da[3],da[4],da[5]);
		return;
	}
#endif

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL) {
		RTW_INFO("%s, alloc mgnt frame fail\n", __FUNCTION__);
		return;
	}


	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	mac = adapter_mac_addr(padapter);
	bssid = cur_network->MacAddress;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;
	_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, mac, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, bssid, ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(fctrl, WIFI_PROBERSP);

	pattrib->hdrlen = sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = pattrib->hdrlen;
	pframe += pattrib->hdrlen;


	if (cur_network->IELength > MAX_IE_SZ)
	{
		RTW_ERR("probersp IELength too large ,len(%d,%d)\n", cur_network->IELength, MAX_IE_SZ);
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

#if defined(CONFIG_AP_MODE) && defined (CONFIG_NATIVEAP_MLME)
	if (MLME_IN_AP_STATE(pmlmeinfo)) {
		pwps_ie = rtw_get_wps_ie(cur_network->IEs + _FIXED_IE_LENGTH_, cur_network->IELength - _FIXED_IE_LENGTH_, NULL, &wps_ielen);

		/* inerset & update wps_probe_resp_ie */
		if ((pmlmepriv->wps_probe_resp_ie != NULL) && pwps_ie && (wps_ielen > 0)) {
			uint wps_offset, remainder_ielen;
			u8 *premainder_ie;

			wps_offset = (uint)(pwps_ie - cur_network->IEs);

			premainder_ie = pwps_ie + wps_ielen;

			remainder_ielen = cur_network->IELength - wps_offset - wps_ielen;

			_rtw_memcpy(pframe, cur_network->IEs, wps_offset);
			pframe += wps_offset;
			pattrib->pktlen += wps_offset;

			wps_ielen = (uint)pmlmepriv->wps_probe_resp_ie[1];/* to get ie data len */
			if ((wps_offset + wps_ielen + 2) <= MAX_IE_SZ) {
				_rtw_memcpy(pframe, pmlmepriv->wps_probe_resp_ie, wps_ielen + 2);
				pframe += wps_ielen + 2;
				pattrib->pktlen += wps_ielen + 2;
			}

			if ((wps_offset + wps_ielen + 2 + remainder_ielen) <= MAX_IE_SZ) {
				_rtw_memcpy(pframe, premainder_ie, remainder_ielen);
				pframe += remainder_ielen;
				pattrib->pktlen += remainder_ielen;
			}
		} else {
			_rtw_memcpy(pframe, cur_network->IEs, cur_network->IELength);
			pframe += cur_network->IELength;
			pattrib->pktlen += cur_network->IELength;
		}

		/* TIM IE only within Beacon frames, remove it. (aprouter3721) */
		{
			u8 *p = NULL, *pie = NULL;
			sint ielen = 0, ttl_ielen = 0, rm_ret = _FALSE;

			pie = pmgntframe->buf_addr + TXDESC_OFFSET + sizeof(struct rtw_ieee80211_hdr_3addr);
			ttl_ielen = pattrib->pktlen - (TXDESC_OFFSET + sizeof(struct rtw_ieee80211_hdr_3addr));

			p = rtw_get_ie(pie + _FIXED_IE_LENGTH_, _TIM_IE_, &ielen, ttl_ielen - _FIXED_IE_LENGTH_);
			if(p != NULL && ielen > 0) {
				rm_ret = rtw_ies_remove_ie(pie, &ttl_ielen, _BEACON_IE_OFFSET_, _TIM_IE_, NULL, 0);
				if(rm_ret == _SUCCESS) {
					pframe -= (ielen+2); //IE_ID(1)+IE_LEN(1)+ielen
					pattrib->pktlen -= (ielen+2); //IE_ID(1)+IE_LEN(1)+ielen
				} else
					RTW_ERR("%s, remove TIM IE failed.\n", __FUNCTION__);
			}
		}

		/* retrieve SSID IE from cur_network->Ssid */
		{
			u8 *ssid_ie;
			sint ssid_ielen;
			sint ssid_ielen_diff;
			u8 buf[MAX_IE_SZ];
			u8 *ies = pmgntframe->buf_addr + TXDESC_OFFSET + sizeof(struct rtw_ieee80211_hdr_3addr);

			ssid_ie = rtw_get_ie(ies + _FIXED_IE_LENGTH_, _SSID_IE_, &ssid_ielen,
				     (pframe - ies) - _FIXED_IE_LENGTH_);

			ssid_ielen_diff = cur_network->Ssid.SsidLength - ssid_ielen;

			if (ssid_ie &&  cur_network->Ssid.SsidLength) {
				uint remainder_ielen;
				u8 *remainder_ie;
				remainder_ie = ssid_ie + 2;
				remainder_ielen = (pframe - remainder_ie);

				if (remainder_ielen > MAX_IE_SZ) {
					RTW_WARN(FUNC_ADPT_FMT" remainder_ielen > MAX_IE_SZ\n", FUNC_ADPT_ARG(padapter));
					remainder_ielen = MAX_IE_SZ;
				}

				_rtw_memcpy(buf, remainder_ie, remainder_ielen);
				_rtw_memcpy(remainder_ie + ssid_ielen_diff, buf, remainder_ielen);
				*(ssid_ie + 1) = cur_network->Ssid.SsidLength;
				_rtw_memcpy(ssid_ie + 2, cur_network->Ssid.Ssid, cur_network->Ssid.SsidLength);

				pframe += ssid_ielen_diff;
				pattrib->pktlen += ssid_ielen_diff;
			}
		}

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
		for (vendor_ie_num = 0 ; vendor_ie_num < WLAN_MAX_VENDOR_IE_NUM ; vendor_ie_num++)
		{
			if (pmlmepriv->vendor_ielen[vendor_ie_num] > 0 && pmlmepriv->vendor_ie_mask[vendor_ie_num] & WIFI_PROBERESP_VENDOR_IE_BIT)
			{
				if(padapter->mlmepriv.vendor_mac_is_set[vendor_ie_num] && _rtw_memcmp(padapter->mlmepriv.vendor_mac[vendor_ie_num], da, ETH_ALEN) == _TRUE)
				{
					padapter->mlmepriv.vendor_mac_is_same[vendor_ie_num] = 1;
					padapter->mlmepriv.vendor_timestamp_is_set[vendor_ie_num] = 1;
					rtw_do_gettimeofday(&tv);
					padapter->mlmepriv.vendor_timestamp[vendor_ie_num] = (u64)tv.tv_sec;
				}
				else
					padapter->mlmepriv.vendor_mac_is_same[vendor_ie_num] = 0;
			}
		}

		pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_PROBERESP_VENDOR_IE_BIT);
#endif
	} else
#endif
	{

		/* timestamp will be inserted by hardware */
		pframe += 8;
		pattrib->pktlen += 8;

		/* beacon interval: 2 bytes */

		_rtw_memcpy(pframe, (unsigned char *)(rtw_get_beacon_interval_from_ie(cur_network->IEs)), 2);

		pframe += 2;
		pattrib->pktlen += 2;

		/* capability info: 2 bytes */

		_rtw_memcpy(pframe, (unsigned char *)(rtw_get_capability_from_ie(cur_network->IEs)), 2);

		pframe += 2;
		pattrib->pktlen += 2;

		/* below for ad-hoc mode */

		/* SSID */
		pframe = rtw_set_ie(pframe, _SSID_IE_, cur_network->Ssid.SsidLength, cur_network->Ssid.Ssid, &pattrib->pktlen);

		/* supported rates... */
		rate_len = rtw_get_rateset_len(cur_network->SupportedRates);
		pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_, ((rate_len > 8) ? 8 : rate_len), cur_network->SupportedRates, &pattrib->pktlen);

		/* DS parameter set */
		pframe = rtw_set_ie(pframe, _DSSET_IE_, 1, (unsigned char *)&(cur_network->Configuration.DSConfig), &pattrib->pktlen);

		if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_ADHOC_STATE)) {
			u8 erpinfo = 0;
			u32 ATIMWindow;
			/* IBSS Parameter Set... */
			/* ATIMWindow = cur->Configuration.ATIMWindow; */
			ATIMWindow = 0;
			pframe = rtw_set_ie(pframe, _IBSS_PARA_IE_, 2, (unsigned char *)(&ATIMWindow), &pattrib->pktlen);

			/* ERP IE */
			pframe = rtw_set_ie(pframe, _ERPINFO_IE_, 1, &erpinfo, &pattrib->pktlen);
		}


		/* EXTERNDED SUPPORTED RATE */
		if (rate_len > 8)
			pframe = rtw_set_ie(pframe, _EXT_SUPPORTEDRATES_IE_, (rate_len - 8), (cur_network->SupportedRates + 8), &pattrib->pktlen);


		/* todo:HT for adhoc */

	}

#ifdef CONFIG_P2P
	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)
	    /* IOT issue, When wifi_spec is not set, send probe_resp with P2P IE even if probe_req has no P2P IE */
	    && (is_valid_p2p_probereq || !padapter->registrypriv.wifi_spec)) {
		u32 len;
#ifdef CONFIG_IOCTL_CFG80211
		if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211) {
			/* if pwdinfo->role == P2P_ROLE_DEVICE will call issue_probersp_p2p() */
			len = pmlmepriv->p2p_go_probe_resp_ie_len;
			if (pmlmepriv->p2p_go_probe_resp_ie && len > 0)
				_rtw_memcpy(pframe, pmlmepriv->p2p_go_probe_resp_ie, len);
		} else
#endif /* CONFIG_IOCTL_CFG80211 */
		{
			len = build_probe_resp_p2p_ie(pwdinfo, pframe);
		}

		pframe += len;
		pattrib->pktlen += len;

#ifdef CONFIG_MCC_MODE
		pframe = rtw_hal_mcc_append_go_p2p_ie(padapter, pframe, &pattrib->pktlen);
#endif /* CONFIG_MCC_MODE*/

#ifdef CONFIG_WFD
		len = rtw_append_probe_resp_wfd_ie(padapter, pframe);
		pframe += len;
		pattrib->pktlen += len;
#endif
	}
#endif /* CONFIG_P2P */


#ifdef CONFIG_AUTO_AP_MODE
	{
		struct sta_info	*psta;
		struct sta_priv *pstapriv = &padapter->stapriv;

		RTW_INFO("(%s)\n", __FUNCTION__);

		/* check rc station */
		psta = rtw_get_stainfo(pstapriv, da);
		if (psta && psta->isrc && psta->pid > 0) {
			u8 RC_OUI[4] = {0x00, 0xE0, 0x4C, 0x0A};
			u8 RC_INFO[14] = {0};
			/* EID[1] + EID_LEN[1] + RC_OUI[4] + MAC[6] + PairingID[2] + ChannelNum[2] */
			u16 cu_ch = (u16)cur_network->Configuration.DSConfig;

			RTW_INFO("%s, reply rc(pid=0x%x) device "MAC_FMT" in ch=%d\n", __FUNCTION__,
				 psta->pid, MAC_ARG(psta->phl_sta->mac_addr), cu_ch);

			/* append vendor specific ie */
			_rtw_memcpy(RC_INFO, RC_OUI, sizeof(RC_OUI));
			_rtw_memcpy(&RC_INFO[4], mac, ETH_ALEN);
			_rtw_memcpy(&RC_INFO[10], (u8 *)&psta->pid, 2);
			_rtw_memcpy(&RC_INFO[12], (u8 *)&cu_ch, 2);

			pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, sizeof(RC_INFO), RC_INFO, &pattrib->pktlen);
		}
	}
#endif /* CONFIG_AUTO_AP_MODE */

	/* Skip for now as current Probe Response frames don't contain IEs
	 * that need to be reordered or removed (except TIM IE which has been
	 * removed above) */
#if 0
	pframe = (u8 *)pwlanhdr;
	pattrib->pktlen += rtw_fix_ie(pframe +
				      pattrib->hdrlen +
				      _PROBERSP_IE_OFFSET_,
				      pattrib->pktlen -
				      pattrib->hdrlen -
				      _PROBERSP_IE_OFFSET_,
				      WIFI_PROBERSP);
#endif
#ifdef CONFIG_NEC_MULTI_STAGE
		if(padapter->registrypriv.wifi_mib.stage)
			pframe = rtw_set_multistage_ie(padapter, pframe, &(pattrib->pktlen));
#endif
#ifdef CONFIG_NEC_TV_MODE
		pframe = rtw_set_tvmode_ie(padapter, pframe, &(pattrib->pktlen));
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;


	dump_mgntframe(padapter, pmgntframe);

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, da, 1, "Probe Response", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

	return;

}

int _issue_probereq(_adapter *padapter, const NDIS_802_11_SSID *pssid, const u8 *da, u8 ch, bool append_wps, int wait_ack)
{
	int ret = _FAIL;
	struct xmit_frame		*pmgntframe;
	struct pkt_attrib		*pattrib;
	unsigned char			*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short		*fctrl;
	unsigned char			*mac;
	unsigned char			bssrate[NumRates];
	struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	int	bssrate_len = 0;
	u8	bc_addr[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
	struct rtw_wdev_priv *pwdev_priv = adapter_wdev_data(padapter);
#endif

#ifdef CONFIG_PROBEREQ_ADD_HT_VHT_HE
	u8 *p;
	_adapter *pri_adapter = GET_PRIMARY_ADAPTER(padapter);
	struct mlme_ext_priv	*pri_pmlmeext = &(pri_adapter->mlmeextpriv);
	struct mlme_ext_info	*pri_pmlmeinfo = &(pri_pmlmeext->mlmext_info);
	WLAN_BSSID_EX *pri_cur_network = &(pri_pmlmeinfo->network);
	u8 *ie = pri_cur_network->IEs;
	uint ie_len = 0;
	u8 he_cap_eid_ext = WLAN_EID_EXT_HE_CAPABILITIES;
#endif

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
	if ((pwdev_priv->pno_mac_addr[0] != 0xFF)
	    && (MLME_IS_STA(padapter))
	    && (check_fwstate(&padapter->mlmepriv, WIFI_ASOC_STATE) == _FALSE))
		mac = pwdev_priv->pno_mac_addr;
	else
#endif
	mac = adapter_mac_addr(padapter);

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	if (da) {
		/*	unicast probe request frame */
		_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, da, ETH_ALEN);
	} else {
		/*	broadcast probe request frame */
		_rtw_memcpy(pwlanhdr->addr1, bc_addr, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, bc_addr, ETH_ALEN);
	}

	_rtw_memcpy(pwlanhdr->addr2, mac, ETH_ALEN);

#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
	if ((pwdev_priv->pno_mac_addr[0] != 0xFF)
	    && (MLME_IS_STA(padapter))
	    && (check_fwstate(&padapter->mlmepriv, WIFI_ASOC_STATE) == _FALSE)) {
#ifdef CONFIG_RTW_DEBUG
		RTW_DBG("%s pno_scan_seq_num: %d\n", __func__,
			 pwdev_priv->pno_scan_seq_num);
#endif
		SetSeqNum(pwlanhdr, pwdev_priv->pno_scan_seq_num);
		pattrib->seqnum = pwdev_priv->pno_scan_seq_num;
		pattrib->qos_en = 1;
		pwdev_priv->pno_scan_seq_num++;
	} else
#endif
	{
		SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
		pmlmeext->mgnt_seq++;
	}
	set_frame_sub_type(pframe, WIFI_PROBEREQ);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	if (pssid && !MLME_IS_MESH(padapter))
		pframe = rtw_set_ie(pframe, _SSID_IE_, pssid->SsidLength, pssid->Ssid, &(pattrib->pktlen));
	else
		pframe = rtw_set_ie(pframe, _SSID_IE_, 0, NULL, &(pattrib->pktlen));

	get_rate_set(padapter, bssrate, &bssrate_len);

	if (bssrate_len > 8) {
		pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_ , 8, bssrate, &(pattrib->pktlen));
		pframe = rtw_set_ie(pframe, _EXT_SUPPORTEDRATES_IE_ , (bssrate_len - 8), (bssrate + 8), &(pattrib->pktlen));
	} else
		pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_ , bssrate_len , bssrate, &(pattrib->pktlen));

	/* should decide by TX freq, though */
	if (ch && (ch <= 14))
		pframe = rtw_set_ie(pframe, _DSSET_IE_, 1, &ch, &pattrib->pktlen);

#ifdef CONFIG_PROBEREQ_ADD_HT_VHT_HE
	/* Parsing HT CAP IE */
	p = rtw_get_ie(ie + _BEACON_IE_OFFSET_, EID_HTCapability, &ie_len, (pri_cur_network->IELength - _BEACON_IE_OFFSET_));
	if (p && ie_len > 0) {
		pframe = rtw_set_ie(pframe, EID_HTCapability, ie_len, p + 2, &(pattrib->pktlen));
	}
#endif

#ifdef CONFIG_RTW_MESH
	if (MLME_IS_MESH(padapter)) {
		if (pssid)
			pframe = rtw_set_ie_mesh_id(pframe, &pattrib->pktlen, pssid->Ssid, pssid->SsidLength);
		else
			pframe = rtw_set_ie_mesh_id(pframe, &pattrib->pktlen, NULL, 0);
	}
#endif

#ifdef CONFIG_PROBEREQ_ADD_HT_VHT_HE
	/* Parsing VHT CAP IE */
	p = rtw_get_ie(ie + _BEACON_IE_OFFSET_, EID_VHTCapability, &ie_len, (pri_cur_network->IELength - _BEACON_IE_OFFSET_));
	if (p && ie_len > 0) {
		pframe = rtw_set_ie(pframe, EID_VHTCapability, ie_len, p + 2, &(pattrib->pktlen));
	}

	/* Parsing HE CAP IE */
	p = rtw_get_ie_ex(ie + _BEACON_IE_OFFSET_,
			  pri_cur_network->IELength - _BEACON_IE_OFFSET_,
			  WLAN_EID_EXTENSION,
			  &he_cap_eid_ext,
			  1,
			  NULL,
			  &ie_len);
	if (p && ie_len > 0) {
		pframe = rtw_set_ie(pframe, WLAN_EID_EXTENSION, ie_len - 2, p + 2, &(pattrib->pktlen));
	}
#endif

	if (append_wps) {
		/* add wps_ie for wps2.0 */
		if (pmlmepriv->wps_probe_req_ie_len > 0 && pmlmepriv->wps_probe_req_ie) {
			_rtw_memcpy(pframe, pmlmepriv->wps_probe_req_ie, pmlmepriv->wps_probe_req_ie_len);
			pframe += pmlmepriv->wps_probe_req_ie_len;
			pattrib->pktlen += pmlmepriv->wps_probe_req_ie_len;
			/* pmlmepriv->wps_probe_req_ie_len = 0 ; */ /* reset to zero */
		}
	}

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_PROBEREQ_VENDOR_IE_BIT);
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, pwlanhdr->addr1/*da*/, 1, "Probe Request", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

exit:
	return ret;
}

inline void issue_probereq(_adapter *padapter, const NDIS_802_11_SSID *pssid, const u8 *da)
{
	_issue_probereq(padapter, pssid, da, 0, 1, _FALSE);
}

/*
 * wait_ms == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 * wait_ms > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 * try_cnt means the maximal TX count to try
 */
int issue_probereq_ex(_adapter *padapter, const NDIS_802_11_SSID *pssid, const u8 *da, u8 ch, bool append_wps,
		      int try_cnt, int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	do {
		ret = _issue_probereq(padapter, pssid, da, ch, append_wps, wait_ms > 0 ? _TRUE : _FALSE);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		goto exit;
#endif
	}

	if (try_cnt && wait_ms) {
		if (da)
			RTW_INFO(FUNC_ADPT_FMT" to "MAC_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), MAC_ARG(da), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
		else
			RTW_INFO(FUNC_ADPT_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:
	return ret;
}

static void _auth_data_txsts(struct rtw_txfb_t *txfb)
{
	struct xmit_frame *pmgntframe = (struct xmit_frame *)txfb->ctx;
	struct rtw_xmit_req *txreq;
	struct sta_info *psta;
	_adapter *padapter = (_adapter *)txfb->drvpriv;
	u8 *pframe;
	struct rtw_ieee80211_hdr *pwlanhdr;

	if (pmgntframe == NULL)
		return;

	txreq = pmgntframe->phl_txreq;
	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	RTW_INFO("%s Auth "MAC_FMT" TX status: %u\n", __func__,
	          MAC_ARG(pwlanhdr->addr1), txfb->txsts);

#ifdef CONFIG_DBG_HNDSK_MGMT
	upd_ap_recycle_sts(padapter, txfb->txsts, txreq->mdata.type, HNDSK_AUTH_PKT);
#endif

	return;
}

/* if psta == NULL, indiate we are station(client) now... */
void issue_auth(_adapter *padapter, struct sta_info *psta, unsigned short status)
{
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	unsigned int					val32;
	unsigned short				val16;
	int use_shared_key = 0;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct security_priv *psecuritypriv = &padapter->securitypriv;
	struct rtw_txfb_t *txfb;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;
	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_AUTH);
	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	#ifdef CONFIG_XMIT_MGMT_ACK
	txfb = &pmgntframe->ack_rpt.txfb;
	pmgntframe->ack_rpt.ctx_buf_len = 0;
	#else
	txfb = (struct rtw_txfb_t *)(pframe + 512);
	#endif /* CONFIG_XMIT_MGMT_ACK */

	txfb->ctx = pmgntframe;
	txfb->drvpriv = padapter;
	txfb->txfb_cb = _auth_data_txsts;
	pmgntframe->phl_txreq->txfb = txfb;

	if (psta) { /* for AP mode */
#ifdef CONFIG_NATIVEAP_MLME
		_rtw_memcpy(pwlanhdr->addr1, psta->phl_sta->mac_addr, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, adapter_mac_addr(padapter), ETH_ALEN);


		/* setting auth algo number */
		val16 = (u16)psta->authalg;

		if (status != _STATS_SUCCESSFUL_)
			val16 = 0;

		if (val16)	{
			val16 = cpu_to_le16(val16);
			use_shared_key = 1;
		}

		pframe = rtw_set_fixed_ie(pframe, _AUTH_ALGM_NUM_, (unsigned char *)&val16, &(pattrib->pktlen));

		/* setting auth seq number */
		val16 = (u16)psta->auth_seq;
		val16 = cpu_to_le16(val16);
		pframe = rtw_set_fixed_ie(pframe, _AUTH_SEQ_NUM_, (unsigned char *)&val16, &(pattrib->pktlen));

		/* setting status code... */
		val16 = status;
		val16 = cpu_to_le16(val16);
		pframe = rtw_set_fixed_ie(pframe, _STATUS_CODE_, (unsigned char *)&val16, &(pattrib->pktlen));

		/* added challenging text... */
		if ((psta->auth_seq == 2) && (psta->state & WIFI_FW_AUTH_STATE) && (use_shared_key == 1))
			pframe = rtw_set_ie(pframe, _CHLGETXT_IE_, 128, psta->chg_txt, &(pattrib->pktlen));

#ifdef CONFIG_RTW_80211R
		rtw_ft_build_auth_rsp_ies(padapter, pattrib, &pframe);
#endif /* CONFIG_RTW_80211R */

#ifdef CONFIG_DBG_HNDSK_MGMT
		padapter->tx_logs.core_hndsk_tx_cnt[HNDSK_AUTH_PKT]++;
#endif

#endif
	} else {
		_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&pmlmeinfo->network), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&pmlmeinfo->network), ETH_ALEN);

#ifdef CONFIG_RTW_80211R
		if (rtw_ft_roam(padapter)) {
			/* 2: 802.11R FTAA */
			val16 = cpu_to_le16(2);
		} else
#endif
		{
			/* setting auth algo number */
			val16 = (pmlmeinfo->auth_algo == dot11AuthAlgrthm_Shared) ? 1 : 0;	/* 0:OPEN System, 1:Shared key */
			if (val16) {
				val16 = cpu_to_le16(val16);
				use_shared_key = 1;
			}
		}

		/* RTW_INFO("%s auth_algo= %s auth_seq=%d\n",__FUNCTION__,(pmlmeinfo->auth_algo==0)?"OPEN":"SHARED",pmlmeinfo->auth_seq); */

		/* setting IV for auth seq #3 */
		if ((pmlmeinfo->auth_seq == 3) && (pmlmeinfo->state & WIFI_FW_AUTH_STATE) && (use_shared_key == 1)) {
			/* RTW_INFO("==> iv(%d),key_index(%d)\n",pmlmeinfo->iv,pmlmeinfo->key_index); */
			val32 = ((pmlmeinfo->iv++) | (psecuritypriv->dot11PrivacyKeyIndex << 30));
			val32 = cpu_to_le32(val32);
			pframe = rtw_set_fixed_ie(pframe, 4, (unsigned char *)&val32, &(pattrib->pktlen));

			pattrib->iv_len = 4;
		}
		pframe = rtw_set_fixed_ie(pframe, _AUTH_ALGM_NUM_, (unsigned char *)&val16, &(pattrib->pktlen));

		/* setting auth seq number */
		val16 = pmlmeinfo->auth_seq;
		val16 = cpu_to_le16(val16);
		pframe = rtw_set_fixed_ie(pframe, _AUTH_SEQ_NUM_, (unsigned char *)&val16, &(pattrib->pktlen));


		/* setting status code... */
		val16 = status;
		val16 = cpu_to_le16(val16);
		pframe = rtw_set_fixed_ie(pframe, _STATUS_CODE_, (unsigned char *)&val16, &(pattrib->pktlen));

#ifdef CONFIG_RTW_80211R
		rtw_ft_build_auth_req_ies(padapter, pattrib, &pframe);
#endif

		/* then checking to see if sending challenging text... */
		if ((pmlmeinfo->auth_seq == 3) && (pmlmeinfo->state & WIFI_FW_AUTH_STATE) && (use_shared_key == 1)) {
			pframe = rtw_set_ie(pframe, _CHLGETXT_IE_, 128, pmlmeinfo->chg_txt, &(pattrib->pktlen));

			SetPrivacy(fctrl);

			pattrib->hdrlen = sizeof(struct rtw_ieee80211_hdr_3addr);

			pattrib->encrypt = _WEP40_;

			pattrib->icv_len = 4;

			pattrib->pktlen += pattrib->icv_len;

			pattrib->bswenc = _TRUE;
		}

	}

	pattrib->last_txcmdsz = pattrib->pktlen;

	/* do SW encryption in core_wlan_sw_encrypt */
	RTW_INFO(FUNC_ADPT_FMT" R="MAC_FMT" T="MAC_FMT" status=%d\n",
		 FUNC_ADPT_ARG(padapter), MAC_ARG(pwlanhdr->addr1),
		 MAC_ARG(pwlanhdr->addr2), status);
	dump_mgntframe(padapter, pmgntframe);

#ifdef CTC_WIFI_DIAG
	if (psta)
		ctcwifi_diag_log(padapter, psta->phl_sta->mac_addr, 1, "Authentication", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

	return;
}

static void _asocrsp_data_txsts(struct rtw_txfb_t *txfb)
{
	struct xmit_frame *pmgntframe = (struct xmit_frame *)txfb->ctx;
	struct rtw_xmit_req *txreq;
	struct sta_info *psta;
	_adapter *padapter = (_adapter *)txfb->drvpriv;
	u8 *pframe;
	struct rtw_ieee80211_hdr *pwlanhdr;

	if (pmgntframe == NULL)
		return;

	txreq = pmgntframe->phl_txreq;
	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	RTW_INFO("%s Assoc response "MAC_FMT" TX status: %u\n", __func__,
	          MAC_ARG(pwlanhdr->addr1), txfb->txsts);

#ifdef CONFIG_DBG_HNDSK_MGMT
	upd_ap_recycle_sts(padapter, txfb->txsts, txreq->mdata.type, HNDSK_ASSOC_RSP_PKT);
#endif

	return;
}


void issue_asocrsp(_adapter *padapter, unsigned short status, struct sta_info *pstat, int pkt_type)
{
#ifdef CONFIG_AP_MODE
	struct xmit_frame	*pmgntframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	struct pkt_attrib *pattrib;
	unsigned char	*pbuf, *pframe;
	unsigned short val, ie_status;
	unsigned short *fctrl;
	struct xmit_priv *pxmitpriv = &(padapter->xmitpriv);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct security_priv *psecuritypriv = &padapter->securitypriv;
	struct rtw_txfb_t *txfb;
	WLAN_BSSID_EX *pnetwork = &(pmlmeinfo->network);
	u8 *ie = pnetwork->IEs;
	uint ie_len = 0;
#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif
#endif /* CONFIG_P2P */
#ifdef CONFIG_RTW_MBO
	u8 WIFI_ALLIANCE_OUI[] = {0x50, 0x6f, 0x9a};
#endif
#ifdef CONFIG_RTW_MULTI_AP
	_adapter *primary_adapter = GET_PRIMARY_ADAPTER(padapter);
#endif
	u8 *pwps_ie=NULL;
	uint wps_ielen=0;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

	RTW_INFO("%s sta="MAC_FMT"\n", __FUNCTION__, MAC_ARG(pstat->phl_sta->mac_addr));

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy((void *)GetAddr1Ptr(pwlanhdr), pstat->phl_sta->mac_addr, ETH_ALEN);
	_rtw_memcpy((void *)get_addr2_ptr(pwlanhdr), adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy((void *)GetAddr3Ptr(pwlanhdr), get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);


	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	if ((pkt_type == WIFI_ASSOCRSP) || (pkt_type == WIFI_REASSOCRSP))
	{
		set_frame_sub_type(pwlanhdr, pkt_type);
	}
	else
	{
		RTW_ERR("asocrsp unknown pkt type = %d\n", pkt_type);
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	pattrib->hdrlen = sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen += pattrib->hdrlen;
	pframe += pattrib->hdrlen;

	#ifdef CONFIG_XMIT_MGMT_ACK
	txfb = &pmgntframe->ack_rpt.txfb;
	pmgntframe->ack_rpt.ctx_buf_len = 0;
	#else
	txfb = (struct rtw_txfb_t *)(pframe + 512);
	#endif /* CONFIG_XMIT_MGMT_ACK */

	txfb->ctx = pmgntframe;
	txfb->drvpriv = padapter;
	txfb->txfb_cb = _asocrsp_data_txsts;
	pmgntframe->phl_txreq->txfb = txfb;

	/* capability */
	val = *(unsigned short *)rtw_get_capability_from_ie(ie);

	pframe = rtw_set_fixed_ie(pframe, _CAPABILITY_ , (unsigned char *)&val, &(pattrib->pktlen));

	ie_status = cpu_to_le16(status);
	pframe = rtw_set_fixed_ie(pframe , _STATUS_CODE_ , (unsigned char *)&ie_status, &(pattrib->pktlen));

	val = cpu_to_le16(pstat->phl_sta->aid | BIT(14) | BIT(15));
	pframe = rtw_set_fixed_ie(pframe, _ASOC_ID_ , (unsigned char *)&val, &(pattrib->pktlen));

	pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, _SUPPORTEDRATES_IE_, &ie_len, pnetwork->IELength - _BEACON_IE_OFFSET_);
	if (pbuf && ie_len) {
		_rtw_memcpy(pframe, pbuf, 2 + ie_len);
		pframe += 2 + ie_len;
		pattrib->pktlen += 2 + ie_len;
	}

	pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, _EXT_SUPPORTEDRATES_IE_, &ie_len, pnetwork->IELength - _BEACON_IE_OFFSET_);
	if (pbuf && ie_len) {
		_rtw_memcpy(pframe, pbuf, 2 + ie_len);
		pframe += 2 + ie_len;
		pattrib->pktlen += 2 + ie_len;
	}

#ifdef CONFIG_RTW_80211K
	/* Adding RM capability IE */
	if (padapter->rmpriv.enable == _TRUE) {
		pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, _EID_RRM_EN_CAP_IE_, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_));
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len + 2);
			pframe += (ie_len + 2);
			pattrib->pktlen += (ie_len + 2);
		}
	}
#endif /* CONFIG_RTW_80211K */

#if defined(CONFIG_HAPD_OWE) || defined(DIRECT_HAPD_RSN_IE)
	if (pstat->rsn_ie_len) {
		_rtw_memcpy(pframe, pstat->rsn_ie, pstat->rsn_ie_len);
		pframe += pstat->rsn_ie_len;
		pattrib->pktlen += pstat->rsn_ie_len;
		pstat->rsn_ie_len = 0;
	}
#endif /* CONFIG_HAPD_OWE || DIRECT_HAPD_RSN_IE */

#ifdef CONFIG_RTW_80211R
	rtw_ft_build_assoc_rsp_ies(padapter, (pkt_type == WIFI_REASSOCRSP), pattrib, &pframe);
#endif /* CONFIG_RTW_80211R */

#ifdef CONFIG_IEEE80211W
#if !defined(CONFIG_IOCTL_CFG80211) || (defined(CONFIG_ATP_COMMON) && !defined(CONFIG_RTW_80211R) && !defined(CONFIG_HAPD_OWE))
	if (status == _STATS_REFUSED_TEMPORARILY_) {
		u8 timeout_itvl[5];
		u32 timeout_interval = 3000;
		/* Association Comeback time */
		timeout_itvl[0] = 0x03;
		timeout_interval = cpu_to_le32(timeout_interval);
		_rtw_memcpy(timeout_itvl + 1, &timeout_interval, 4);
		pframe = rtw_set_ie(pframe, _TIMEOUT_ITVL_IE_, 5, timeout_itvl, &(pattrib->pktlen));
	}
#else
	if (pstat->pmf_timeout_ie_len) {
		pframe = rtw_set_ie(pframe, _TIMEOUT_ITVL_IE_, pstat->pmf_timeout_ie_len, pstat->pmf_timeout_ie, &(pattrib->pktlen));
		pstat->pmf_timeout_ie_len = 0;
	}
#endif
#endif /* CONFIG_IEEE80211W */

#ifdef CONFIG_80211N_HT
	if ((pstat->flags & WLAN_STA_HT) && (pmlmepriv->htpriv.ht_option)) {
		/* FILL HT CAP INFO IE */
		/* p = hostapd_eid_ht_capabilities_info(hapd, p); */
		pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, _HT_CAPABILITY_IE_, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_));
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len + 2);
			pframe += (ie_len + 2);
			pattrib->pktlen += (ie_len + 2);
		}

		/* FILL HT ADD INFO IE */
		/* p = hostapd_eid_ht_operation(hapd, p); */
		pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, _HT_ADD_INFO_IE_, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_));
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len + 2);
			pframe += (ie_len + 2);
			pattrib->pktlen += (ie_len + 2);
		}
	}
#endif

	/* adding EXT_CAPAB_IE */
	if (pmlmepriv->ext_capab_ie_len > 0) {
		pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, _EXT_CAP_IE_, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_));
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len + 2);
			pframe += (ie_len + 2);
			pattrib->pktlen += (ie_len + 2);
		}
	}

#ifdef CONFIG_80211AC_VHT
	if (((pstat->flags & WLAN_STA_VHT)
#ifdef CONFIG_24G_256QAM
	     || ((pstat->flags & WLAN_STA_HT) && (padapter->registrypriv.wifi_mib.vht_proprietary & VHT_2G_ASOCRSP_IE))
#endif /* CONFIG_24G_256QAM */
	    ) && (pmlmepriv->vhtpriv.vht_option)
	    && (pstat->wpa_pairwise_cipher != WPA_CIPHER_TKIP)
	    && (pstat->wpa2_pairwise_cipher != WPA_CIPHER_TKIP)) {
		/* FILL VHT CAP IE */
		pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, EID_VHTCapability, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_));
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len + 2);
			pframe += (ie_len + 2);
			pattrib->pktlen += (ie_len + 2);
		}

		/* FILL VHT OPERATION IE */
		pbuf = rtw_get_ie(ie + _BEACON_IE_OFFSET_, EID_VHTOperation, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_));
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len + 2);
			pframe += (ie_len + 2);
			pattrib->pktlen += (ie_len + 2);
		}
	}
#endif /* CONFIG_80211AC_VHT */

	/* WPA3 R3 RSNXE IE */
	if (psecuritypriv->rsn_xe_len) {
		_rtw_memcpy(pframe, psecuritypriv->rsn_xe, psecuritypriv->rsn_xe_len);
		pframe += psecuritypriv->rsn_xe_len;
		pattrib->pktlen += psecuritypriv->rsn_xe_len;
	}

#ifdef CONFIG_80211AX_HE
	if ((pstat->flags & WLAN_STA_HE) && (pmlmepriv->hepriv.he_option)) {
		u8 he_cap_eid_ext = WLAN_EID_EXTENSION_HE_CAPABILITY;
		u8 he_op_eid_ext = WLAN_EID_EXTENSION_HE_OPERATION;
		u8 mu_edca_eid_ext = WLAN_EID_EXTENSION_MU_EDCA;

		/* FILL HE CAP IE */
		pbuf = rtw_get_ie_ex(ie + _BEACON_IE_OFFSET_, pnetwork->IELength - _BEACON_IE_OFFSET_,
				     WLAN_EID_EXTENSION, &he_cap_eid_ext, 1, NULL, &ie_len);
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len);
			pframe += ie_len;
			pattrib->pktlen += ie_len;
		}

		/* FILL HE OPERATION IE */
		pbuf = rtw_get_ie_ex(ie + _BEACON_IE_OFFSET_, pnetwork->IELength - _BEACON_IE_OFFSET_,
				     WLAN_EID_EXTENSION, &he_op_eid_ext, 1, NULL, &ie_len);
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len);
			pframe += ie_len;
			pattrib->pktlen += ie_len;
		}

		/* FILL MU EDCA IE */
		pbuf = rtw_get_ie_ex(ie + _BEACON_IE_OFFSET_, pnetwork->IELength - _BEACON_IE_OFFSET_,
				     WLAN_EID_EXTENSION, &mu_edca_eid_ext, 1, NULL, &ie_len);
		if (pbuf && ie_len > 0) {
			_rtw_memcpy(pframe, pbuf, ie_len);
			pframe += ie_len;
			pattrib->pktlen += ie_len;
		}
	}
#endif /* CONFIG_80211AX_HE */

#ifdef CONFIG_HAPD_OWE
	/* OWE is defined by RFC8110 instead of 802.11 spec and its order
	 * is not specified, place it before vendor IEs anyway */
	if (pstat->owe_dh_ie_len) {
		_rtw_memcpy(pframe, pstat->owe_dh_ie, OWE_DH_IE_LEN);
		pframe += OWE_DH_IE_LEN;
		pattrib->pktlen += OWE_DH_IE_LEN;
	}
#endif /* CONFIG_HAPD_OWE */

	/* FILL WMM IE */
	if ((pstat->flags & WLAN_STA_WME) && (pmlmepriv->qospriv.qos_option)) {
		unsigned char WMM_PARA_IE[] = {0x00, 0x50, 0xf2, 0x02, 0x01, 0x01};

		ie_len = 0;
		for (pbuf = ie + _BEACON_IE_OFFSET_; ; pbuf += (ie_len + 2)) {
			pbuf = rtw_get_ie(pbuf, _VENDOR_SPECIFIC_IE_, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_ - (ie_len + 2)));
			if (pbuf && _rtw_memcmp(pbuf + 2, WMM_PARA_IE, 6)) {
				_rtw_memcpy(pframe, pbuf, ie_len + 2);
				pframe += (ie_len + 2);
				pattrib->pktlen += (ie_len + 2);
				break;
			}

			if ((pbuf == NULL) || (ie_len == 0))
				break;
		}
	}

	pwps_ie = rtw_get_wps_ie(ie + _FIXED_IE_LENGTH_, pnetwork->IELength - _FIXED_IE_LENGTH_, NULL, &wps_ielen);
	if (pwps_ie && (wps_ielen > 0)) {
		_rtw_memcpy(pframe, pwps_ie, wps_ielen);
		pframe += wps_ielen;
		pattrib->pktlen += wps_ielen;
	} else if (pmlmepriv->wps_assoc_resp_ie && pmlmepriv->wps_assoc_resp_ie_len > 0) {
		_rtw_memcpy(pframe, pmlmepriv->wps_assoc_resp_ie, pmlmepriv->wps_assoc_resp_ie_len);

		pframe += pmlmepriv->wps_assoc_resp_ie_len;
		pattrib->pktlen += pmlmepriv->wps_assoc_resp_ie_len;
	}

#ifdef CONFIG_RTW_MULTI_AP
	if (primary_adapter->multi_ap_mode & MAP_MODE_FRONT_AP) {
		if (WLAN_STA_MULTI_AP & pstat->flags) {
			if (MAP_MODE_FRONT_AP == padapter->multi_ap_mode)
				pframe = core_map_append_multi_ap_ie(pframe,
					&pattrib->pktlen, MULTI_AP_FRONTHAUL_BSS,
					primary_adapter->registrypriv.wifi_mib.multiap_profile,
					padapter->registrypriv.wifi_mib.multiap_vlan_id);
			else if (MAP_MODE_BACKHAL_AP == padapter->multi_ap_mode)
				pframe = core_map_append_multi_ap_ie(pframe,
					&pattrib->pktlen, MULTI_AP_BACKHAUL_BSS,
					primary_adapter->registrypriv.wifi_mib.multiap_profile,
					padapter->registrypriv.wifi_mib.multiap_vlan_id);
			else if (MAP_MODE_FRONT_BACKHAUL_AP == padapter->multi_ap_mode)
				pframe = core_map_append_multi_ap_ie(pframe,
					&pattrib->pktlen, (MULTI_AP_BACKHAUL_BSS | MULTI_AP_FRONTHAUL_BSS),
					primary_adapter->registrypriv.wifi_mib.multiap_profile,
					padapter->registrypriv.wifi_mib.multiap_vlan_id);
		}
	}
#endif

#ifdef CONFIG_P2P
	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO) && (pstat->is_p2p_device == _TRUE)) {
		u32 len;

		if (padapter->wdinfo.driver_interface == DRIVER_CFG80211) {
			len = 0;
			if (pmlmepriv->p2p_assoc_resp_ie && pmlmepriv->p2p_assoc_resp_ie_len > 0) {
				len = pmlmepriv->p2p_assoc_resp_ie_len;
				_rtw_memcpy(pframe, pmlmepriv->p2p_assoc_resp_ie, len);
			}
		} else
			len = build_assoc_resp_p2p_ie(pwdinfo, pframe, pstat->p2p_status_code);
		pframe += len;
		pattrib->pktlen += len;
	}

#ifdef CONFIG_WFD
	if (rtw_p2p_chk_role(pwdinfo, P2P_ROLE_GO)) {
		wfdielen = rtw_append_assoc_resp_wfd_ie(padapter, pframe);
		pframe += wfdielen;
		pattrib->pktlen += wfdielen;
	}
#endif
#endif /* CONFIG_P2P */

#ifdef CONFIG_RTW_MBO
	if (pmlmepriv->mbopriv.enable == _TRUE) {
		ie_len = 0;
		for (pbuf = ie + _BEACON_IE_OFFSET_; ; pbuf += (ie_len + 2)) {
			pbuf = rtw_get_ie(pbuf, _SSN_IE_1_, &ie_len, (pnetwork->IELength - _BEACON_IE_OFFSET_ - (ie_len + 2)));
			if ((pbuf) && (_rtw_memcmp(pbuf + 2, WIFI_ALLIANCE_OUI, 3)) && (*(pbuf+5) == MBO_OUI_TYPE)) {
				/* find MBO-OCE information element */
				_rtw_memcpy(pframe, pbuf, ie_len + 2);
				pframe += (ie_len + 2);
				pattrib->pktlen += (ie_len + 2);
				break;
			}
			if ((pbuf == NULL) || (ie_len == 0))
				break;
		}
	}
#endif /* CONFIG_RTW_MBO */

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_ASSOCRESP_VENDOR_IE_BIT);
#endif

	if (pmlmeinfo->assoc_AP_vendor == HT_IOT_PEER_REALTEK)
		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, 6 , REALTEK_96B_IE, &(pattrib->pktlen));

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	if (padapter->tbtx_capability == _TRUE)
		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, 8, REALTEK_TBTX_IE, &pattrib->pktlen);
#endif

#ifdef CONFIG_NEC_TV_MODE
	pframe = rtw_set_tvmode_ie(padapter, pframe, &(pattrib->pktlen));
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;

#ifdef CONFIG_DBG_HNDSK_MGMT
	padapter->tx_logs.core_hndsk_tx_cnt[HNDSK_ASSOC_RSP_PKT]++;
#endif

	dump_mgntframe(padapter, pmgntframe);

#ifdef CTC_WIFI_DIAG
	if (pkt_type == WIFI_REASSOCRSP) {
		ctcwifi_diag_log(padapter, pstat->phl_sta->mac_addr, 1, "Reassociation Response", (unsigned char *)pwlanhdr, pattrib->pktlen);
	} else {
		ctcwifi_diag_log(padapter, pstat->phl_sta->mac_addr, 1, "Association Response", (unsigned char *)pwlanhdr, pattrib->pktlen);
	}
#endif

#ifdef CONFIG_IEEE80211W
	if ((status == _STATS_SUCCESSFUL_) &&
	    (pstat->flags & WLAN_STA_MFP) &&
	    (pstat->bpairwise_key_installed == _TRUE)) {
		/* Maybe we should re-add the station here ... */
#ifdef CONFIG_CORE_TXSC
		core_txsc_clean_entry(padapter, pstat);
#endif /* CONFIG_CORE_TXSC */
	}
#endif /* CONFIG_IEEE80211W */

#endif
}

static u32 rtw_append_assoc_req_owe_ie(_adapter *adapter, u8 *pbuf)
{
	struct security_priv *sec = &adapter->securitypriv;
	u32 len = 0;

	if (sec == NULL)
		goto exit;
	else {
		if (sec->owe_ie_len > 0) {
			len = sec->owe_ie_len;
			_rtw_memcpy(pbuf, sec->owe_ie, len);
		}
	}

exit:
	return len;
}

void _issue_assocreq(_adapter *padapter, u8 is_reassoc)
{
	int ret = _FAIL;
	struct xmit_frame				*pmgntframe;
	struct pkt_attrib				*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr			*pwlanhdr;
	unsigned short				*fctrl;
	unsigned short				val16;
	unsigned int					i, j, index = 0;
	unsigned char					bssrate[NumRates], sta_bssrate[NumRates];
	PNDIS_802_11_VARIABLE_IEs	pIE;
	struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	int	bssrate_len = 0, sta_bssrate_len = 0;
	u8	vs_ie_length = 0;
	struct security_priv *psecuritypriv = &padapter->securitypriv;
#ifdef CONFIG_P2P
	struct wifidirect_info	*pwdinfo = &(padapter->wdinfo);
	u8					p2pie[255] = { 0x00 };
	u16					p2pielen = 0;
#ifdef CONFIG_WFD
	u32					wfdielen = 0;
#endif
#endif /* CONFIG_P2P */
	WLAN_BSSID_EX *pnetwork = &(pmlmeinfo->network);
	u8 *p = NULL;
	uint ie_len = 0;
#if CONFIG_DFS
	u16	cap;
#endif
#ifdef CONFIG_RTW_WPS_MULTI_CREDENTIAL_SUPPORT
	unsigned char wps_multi_cred_ie[9]={0xdd, 0x07, 0x00, 0x0d, 0x02, 0x06, 0x01, 0x00, 0x80};
#endif
#ifdef CONFIG_RTW_MULTI_AP
	_adapter *primary_adapter = GET_PRIMARY_ADAPTER(padapter);
#endif

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;
	_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	if (is_reassoc == _TRUE)
		set_frame_sub_type(pframe, WIFI_REASSOCREQ);
	else
		set_frame_sub_type(pframe, WIFI_ASSOCREQ);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	/* caps */

#if CONFIG_DFS
	_rtw_memcpy(&cap, rtw_get_capability_from_ie(pmlmeinfo->network.IEs), 2);
	cap |= cap_SpecMgmt;
	_rtw_memcpy(pframe, &cap, 2);
#else
	_rtw_memcpy(pframe, rtw_get_capability_from_ie(pmlmeinfo->network.IEs), 2);
#endif

	pframe += 2;
	pattrib->pktlen += 2;

	/* listen interval */
	/* todo: listen interval for power saving */
	val16 = cpu_to_le16(3);
	_rtw_memcpy(pframe , (unsigned char *)&val16, 2);
	pframe += 2;
	pattrib->pktlen += 2;

	/*Construct Current AP Field for Reassoc-Req only*/
	if (is_reassoc == _TRUE) {
		_rtw_memcpy(pframe, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
		pframe += ETH_ALEN;
		pattrib->pktlen += ETH_ALEN;
	}

	/* SSID */
	pframe = rtw_set_ie(pframe, _SSID_IE_,  pmlmeinfo->network.Ssid.SsidLength, pmlmeinfo->network.Ssid.Ssid, &(pattrib->pktlen));

	/* supported rate & extended supported rate */

#if 1	/* Check if the AP's supported rates are also supported by STA. */
	get_rate_set(padapter, sta_bssrate, &sta_bssrate_len);
	/* RTW_INFO("sta_bssrate_len=%d\n", sta_bssrate_len); */

	if (pmlmeext->cur_channel == 14) /* for JAPAN, channel 14 can only uses B Mode(CCK) */
		sta_bssrate_len = 4;


	/* for (i = 0; i < sta_bssrate_len; i++) { */
	/*	RTW_INFO("sta_bssrate[%d]=%02X\n", i, sta_bssrate[i]); */
	/* } */

	for (i = 0; i < NDIS_802_11_LENGTH_RATES_EX; i++) {
		if (pmlmeinfo->network.SupportedRates[i] == 0)
			break;
		RTW_INFO("network.SupportedRates[%d]=%02X\n", i, pmlmeinfo->network.SupportedRates[i]);
	}


	for (i = 0; i < NDIS_802_11_LENGTH_RATES_EX; i++) {
		if (pmlmeinfo->network.SupportedRates[i] == 0)
			break;


		/* Check if the AP's supported rates are also supported by STA. */
		for (j = 0; j < sta_bssrate_len; j++) {
			/* Avoid the proprietary data rate (22Mbps) of Handlink WSG-4000 AP */
			if ((pmlmeinfo->network.SupportedRates[i] | IEEE80211_BASIC_RATE_MASK)
			    == (sta_bssrate[j] | IEEE80211_BASIC_RATE_MASK)) {
				/* RTW_INFO("match i = %d, j=%d\n", i, j); */
				break;
			} else {
				/* RTW_INFO("not match: %02X != %02X\n", (pmlmeinfo->network.SupportedRates[i]|IEEE80211_BASIC_RATE_MASK), (sta_bssrate[j]|IEEE80211_BASIC_RATE_MASK)); */
			}
		}

		if (j == sta_bssrate_len) {
			/* the rate is not supported by STA */
			RTW_INFO("%s(): the rate[%d]=%02X is not supported by STA!\n", __FUNCTION__, i, pmlmeinfo->network.SupportedRates[i]);
		} else {
			/* the rate is supported by STA */
			bssrate[index++] = pmlmeinfo->network.SupportedRates[i];
		}
	}

	bssrate_len = index;
	RTW_INFO("bssrate_len = %d\n", bssrate_len);

#else	/* Check if the AP's supported rates are also supported by STA. */
#if 0
	get_rate_set(padapter, bssrate, &bssrate_len);
#else
	for (bssrate_len = 0; bssrate_len < NumRates; bssrate_len++) {
		if (pmlmeinfo->network.SupportedRates[bssrate_len] == 0)
			break;

		if (pmlmeinfo->network.SupportedRates[bssrate_len] == 0x2C) /* Avoid the proprietary data rate (22Mbps) of Handlink WSG-4000 AP */
			break;

		bssrate[bssrate_len] = pmlmeinfo->network.SupportedRates[bssrate_len];
	}
#endif
#endif /* Check if the AP's supported rates are also supported by STA. */

	if ((bssrate_len == 0) && (pmlmeinfo->network.SupportedRates[0] != 0)) {
		#if 0 /*CONFIG_CORE_XMITBUF*/
		rtw_free_xmitbuf(pxmitpriv, pmgntframe->pxmitbuf);
		#endif
		rtw_free_xmitframe(pxmitpriv, pmgntframe);
		goto exit; /* don't connect to AP if no joint supported rate */
	}

	if (bssrate_len > 8) {
		pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_ , 8, bssrate, &(pattrib->pktlen));
		pframe = rtw_set_ie(pframe, _EXT_SUPPORTEDRATES_IE_ , (bssrate_len - 8), (bssrate + 8), &(pattrib->pktlen));
	} else if (bssrate_len > 0)
		pframe = rtw_set_ie(pframe, _SUPPORTEDRATES_IE_ , bssrate_len , bssrate, &(pattrib->pktlen));
	else
		RTW_INFO("%s: Connect to AP without 11b and 11g data rate!\n", __FUNCTION__);

#if CONFIG_IEEE80211_BAND_5GHZ && CONFIG_DFS
	/* Dot H */
	if (pmlmeext->cur_channel > 14) {
		struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
		u8 pow_cap_ele[2] = { 0x00 };
		u8 sup_ch[30 * 2] = {0x00 }, sup_ch_idx = 0, idx_5g = 2;	/* For supported channel */

		pow_cap_ele[0] = 13;	/* Minimum transmit power capability */
		pow_cap_ele[1] = 21;	/* Maximum transmit power capability */
		pframe = rtw_set_ie(pframe, EID_PowerCap, 2, pow_cap_ele, &(pattrib->pktlen));

		/* supported channels */
		while (sup_ch_idx < rfctl->max_chan_nums && rfctl->channel_set[sup_ch_idx].ChannelNum != 0) {
			if (rfctl->channel_set[sup_ch_idx].ChannelNum <= 14) {
				/* TODO: fix 2.4G supported channel when channel doesn't start from 1 and continuous */
				sup_ch[0] = 1;	/* First channel number */
				sup_ch[1] = rfctl->channel_set[sup_ch_idx].ChannelNum;	/* Number of channel */
			} else {
				sup_ch[idx_5g++] = rfctl->channel_set[sup_ch_idx].ChannelNum;
				sup_ch[idx_5g++] = 1;
			}
			sup_ch_idx++;
		}
		pframe = rtw_set_ie(pframe, EID_SupportedChannels, idx_5g, sup_ch, &(pattrib->pktlen));
	}
#endif /* CONFIG_IEEE80211_BAND_5GHZ && CONFIG_DFS */

	/* RSN */
	p = rtw_get_ie(pnetwork->IEs + _FIXED_IE_LENGTH_, EID_WPA2, &ie_len,
		       pnetwork->IELength - _FIXED_IE_LENGTH_);
	if (p && ie_len) {
#ifdef CONFIG_RTW_80211R
		if (is_reassoc && rtw_ft_roam(padapter))
			rtw_ft_update_rsnie(padapter, _TRUE, pattrib, &pframe);
		else
#endif
		{
#ifdef CONFIG_IOCTL_CFG80211
			if (rtw_sec_chk_auth_alg(padapter, WLAN_AUTH_OPEN) &&
			    rtw_sec_chk_auth_type(padapter, MLME_AUTHTYPE_SAE)) {
				s32 entry = rtw_cached_pmkid(padapter, pmlmepriv->assoc_bssid);

				rtw_rsn_sync_pmkid(padapter, p, 2 + ie_len, entry);
			}
#endif /* CONFIG_IOCTL_CFG80211 */

			pframe = rtw_set_ie(pframe, EID_WPA2, ie_len, p + 2, &pattrib->pktlen);
		}
	}

#ifdef CONFIG_WAPI_SUPPORT
	rtw_build_assoc_req_wapi_ie(padapter, pframe, pattrib);
#endif

#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
	p = rtw_get_ie(pnetwork->IEs + _FIXED_IE_LENGTH_, EID_WAPI, &ie_len,
		       pnetwork->IELength - _FIXED_IE_LENGTH_);
	if (p && ie_len)
		pframe = rtw_set_ie(pframe, EID_WAPI, ie_len, p + 2, &pattrib->pktlen);
#endif

#ifdef CONFIG_RTW_80211K
	if (pmlmeinfo->network.PhyInfo.rm_en_cap[0] /* RM Enabled Capabilities */
	    | pmlmeinfo->network.PhyInfo.rm_en_cap[1]
	    | pmlmeinfo->network.PhyInfo.rm_en_cap[2]
	    | pmlmeinfo->network.PhyInfo.rm_en_cap[3]
	    | pmlmeinfo->network.PhyInfo.rm_en_cap[4])
		pframe = rtw_set_ie(pframe, _EID_RRM_EN_CAP_IE_, 5,
				    (u8 *)padapter->rmpriv.rm_en_cap_def, &(pattrib->pktlen));
#endif /* CONFIG_RTW_80211K */

#ifdef CONFIG_RTW_80211R
	rtw_ft_build_assoc_req_ies(padapter, is_reassoc, pattrib, &pframe);
#endif

#ifdef CONFIG_80211N_HT
	if ((padapter->mlmepriv.htpriv.ht_option == _TRUE) &&
	    !is_ap_in_tkip(padapter)) {
		p = rtw_get_ie(pnetwork->IEs + _FIXED_IE_LENGTH_, EID_HTCapability, &ie_len,
			       pnetwork->IELength - _FIXED_IE_LENGTH_);
		if (p && ie_len) {
			_rtw_memcpy(&pmlmeinfo->HT_caps, p + 2, sizeof(struct HT_caps_element));
			pframe = rtw_set_ie(pframe, EID_HTCapability, ie_len , p + 2, &pattrib->pktlen);
		}
	}
#endif /* CONFIG_80211N_HT */

	p = rtw_get_ie(pnetwork->IEs + _FIXED_IE_LENGTH_, EID_EXTCapability, &ie_len,
		       pnetwork->IELength - _FIXED_IE_LENGTH_);
	if (p && ie_len)
		pframe = rtw_set_ie(pframe, EID_EXTCapability, ie_len, p + 2, &pattrib->pktlen);

#ifdef CONFIG_80211AC_VHT
	if (padapter->mlmepriv.vhtpriv.vht_option == _TRUE) {
		p = rtw_get_ie(pnetwork->IEs + _FIXED_IE_LENGTH_, EID_VHTCapability, &ie_len,
			       pnetwork->IELength - _FIXED_IE_LENGTH_);
		if (p && ie_len)
			pframe = rtw_set_ie(pframe, EID_VHTCapability, ie_len, p + 2, &pattrib->pktlen);

		p = rtw_get_ie(pnetwork->IEs + _FIXED_IE_LENGTH_, EID_OpModeNotification, &ie_len,
			       pnetwork->IELength - _FIXED_IE_LENGTH_);
		if (p && ie_len)
			pframe = rtw_set_ie(pframe, EID_OpModeNotification, ie_len, p + 2, &pattrib->pktlen);
	}
#endif /* CONFIG_80211AC_VHT */

	/* WPA3 R3 RSNXE IE */
	if (psecuritypriv->rsn_xe_len) {
		_rtw_memcpy(pframe, psecuritypriv->rsn_xe, psecuritypriv->rsn_xe_len);
		pframe += psecuritypriv->rsn_xe_len;
		pattrib->pktlen += psecuritypriv->rsn_xe_len;
	}

#ifdef CONFIG_80211AX_HE
	if (padapter->mlmepriv.hepriv.he_option == _TRUE) {
		u8 he_cap_eid_ext = WLAN_EID_EXT_HE_CAPABILITIES;

		p = rtw_get_ie_ex(pnetwork->IEs + _FIXED_IE_LENGTH_,
				  pnetwork->IELength - _FIXED_IE_LENGTH_,
				  WLAN_EID_EXTENSION,
				  &he_cap_eid_ext,
				  1,
				  NULL,
				  &ie_len);
		if (p && ie_len)
			pframe = rtw_set_ie(pframe, WLAN_EID_EXTENSION, ie_len - 2, p + 2, &pattrib->pktlen);
	}
#endif /* CONFIG_80211AX_HE */

	/* OWE */
	{
		u32 owe_ie_len;

		owe_ie_len = rtw_append_assoc_req_owe_ie(padapter, pframe);
		pframe += owe_ie_len;
		pattrib->pktlen += owe_ie_len;
	}

	/* vendor specific IE, such as WPA, WMM, WPS */
	for (i = sizeof(NDIS_802_11_FIXED_IEs); i < pmlmeinfo->network.IELength;) {
		pIE = (PNDIS_802_11_VARIABLE_IEs)(pmlmeinfo->network.IEs + i);

		if ((pIE->ElementID == _VENDOR_SPECIFIC_IE_) &&
		    ((_rtw_memcmp(pIE->data, RTW_WPA_OUI, 4)) ||
		     (_rtw_memcmp(pIE->data, WMM_OUI, 4)) ||
		     (_rtw_memcmp(pIE->data, WPS_OUI, 4)))) {
			vs_ie_length = pIE->Length;
			if ((!padapter->registrypriv.wifi_spec) && (_rtw_memcmp(pIE->data, WPS_OUI, 4))) {
				/* Commented by Kurt 20110629 */
				/* In some older APs, WPS handshake */
				/* would be fail if we append vender extensions informations to AP */

				vs_ie_length = 14;
			}

			pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, vs_ie_length, pIE->data, &(pattrib->pktlen));
		}

		i += (pIE->Length + 2);
	}

#ifdef CONFIG_P2P
#ifdef CONFIG_IOCTL_CFG80211
	if (adapter_wdev_data(padapter)->p2p_enabled && pwdinfo->driver_interface == DRIVER_CFG80211) {
		if (pmlmepriv->p2p_assoc_req_ie && pmlmepriv->p2p_assoc_req_ie_len > 0) {
			_rtw_memcpy(pframe, pmlmepriv->p2p_assoc_req_ie, pmlmepriv->p2p_assoc_req_ie_len);
			pframe += pmlmepriv->p2p_assoc_req_ie_len;
			pattrib->pktlen += pmlmepriv->p2p_assoc_req_ie_len;
		}
	} else
#endif /* CONFIG_IOCTL_CFG80211 */
	{
		if (!rtw_p2p_chk_state(pwdinfo, P2P_STATE_NONE) && !rtw_p2p_chk_state(pwdinfo, P2P_STATE_IDLE)) {
			/*	Should add the P2P IE in the association request frame.	 */
			/*	P2P OUI */

			p2pielen = 0;
			p2pie[p2pielen++] = 0x50;
			p2pie[p2pielen++] = 0x6F;
			p2pie[p2pielen++] = 0x9A;
			p2pie[p2pielen++] = 0x09;	/*	WFA P2P v1.0 */

			/*	Commented by Albert 20101109 */
			/*	According to the P2P Specification, the association request frame should contain 3 P2P attributes */
			/*	1. P2P Capability */
			/*	2. Extended Listen Timing */
			/*	3. Device Info */
			/*	Commented by Albert 20110516 */
			/*	4. P2P Interface */

			/*	P2P Capability */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_CAPABILITY;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0002);
			p2pielen += 2;

			/*	Value: */
			/*	Device Capability Bitmap, 1 byte */
			p2pie[p2pielen++] = DMP_P2P_DEVCAP_SUPPORT;

			/*	Group Capability Bitmap, 1 byte */
			if (pwdinfo->persistent_supported)
				p2pie[p2pielen++] = P2P_GRPCAP_PERSISTENT_GROUP | DMP_P2P_GRPCAP_SUPPORT;
			else
				p2pie[p2pielen++] = DMP_P2P_GRPCAP_SUPPORT;

			/*	Extended Listen Timing */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_EX_LISTEN_TIMING;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x0004);
			p2pielen += 2;

			/*	Value: */
			/*	Availability Period */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0xFFFF);
			p2pielen += 2;

			/*	Availability Interval */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0xFFFF);
			p2pielen += 2;

			/*	Device Info */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_DEVICE_INFO;

			/*	Length: */
			/*	21->P2P Device Address (6bytes) + Config Methods (2bytes) + Primary Device Type (8bytes)  */
			/*	+ NumofSecondDevType (1byte) + WPS Device Name ID field (2bytes) + WPS Device Name Len field (2bytes) */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(21 + pwdinfo->device_name_len);
			p2pielen += 2;

			/*	Value: */
			/*	P2P Device Address */
			_rtw_memcpy(p2pie + p2pielen, adapter_mac_addr(padapter), ETH_ALEN);
			p2pielen += ETH_ALEN;

			/*	Config Method */
			/*	This field should be big endian. Noted by P2P specification. */
			if ((pwdinfo->ui_got_wps_info == P2P_GOT_WPSINFO_PEER_DISPLAY_PIN) ||
			    (pwdinfo->ui_got_wps_info == P2P_GOT_WPSINFO_SELF_DISPLAY_PIN))
				*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_CONFIG_METHOD_DISPLAY);
			else
				*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_CONFIG_METHOD_PBC);

			p2pielen += 2;

			/*	Primary Device Type */
			/*	Category ID */
			*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_CID_MULIT_MEDIA);
			p2pielen += 2;

			/*	OUI */
			*(u32 *)(p2pie + p2pielen) = cpu_to_be32(WPSOUI);
			p2pielen += 4;

			/*	Sub Category ID */
			*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_PDT_SCID_MEDIA_SERVER);
			p2pielen += 2;

			/*	Number of Secondary Device Types */
			p2pie[p2pielen++] = 0x00;	/*	No Secondary Device Type List */

			/*	Device Name */
			/*	Type: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_be16(WPS_ATTR_DEVICE_NAME);
			p2pielen += 2;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_be16(pwdinfo->device_name_len);
			p2pielen += 2;

			/*	Value: */
			_rtw_memcpy(p2pie + p2pielen, pwdinfo->device_name, pwdinfo->device_name_len);
			p2pielen += pwdinfo->device_name_len;

			/*	P2P Interface */
			/*	Type: */
			p2pie[p2pielen++] = P2P_ATTR_INTERFACE;

			/*	Length: */
			*(u16 *)(p2pie + p2pielen) = cpu_to_le16(0x000D);
			p2pielen += 2;

			/*	Value: */
			_rtw_memcpy(p2pie + p2pielen, pwdinfo->device_addr, ETH_ALEN);	/*	P2P Device Address */
			p2pielen += ETH_ALEN;

			p2pie[p2pielen++] = 1;	/*	P2P Interface Address Count */

			_rtw_memcpy(p2pie + p2pielen, pwdinfo->device_addr, ETH_ALEN);	/*	P2P Interface Address List */
			p2pielen += ETH_ALEN;

			pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, p2pielen, (unsigned char *) p2pie, &pattrib->pktlen);
		}
	}

#ifdef CONFIG_WFD
	wfdielen = rtw_append_assoc_req_wfd_ie(padapter, pframe);
	pframe += wfdielen;
	pattrib->pktlen += wfdielen;
#endif
#endif /* CONFIG_P2P */

#ifdef CONFIG_RTW_A4_STA
	if (padapter->a4_enable) {
#if 0
		struct sta_info *sta;
		sta = rtw_get_stainfo(&padapter->stapriv , get_my_bssid(&(pmlmeinfo->network)));
		if (sta) {
			sta->flags |= WLAN_STA_A4;
		}
#endif
#ifdef CONFIG_RTW_MULTI_AP
		if (MAP_MODE_BACKHAL_STA == padapter->multi_ap_mode) {
			pframe = core_map_append_multi_ap_ie(pframe, &pattrib->pktlen, MULTI_AP_BACKHAUL_STA,
							     primary_adapter->registrypriv.wifi_mib.multiap_profile, 0);
		}
#endif
	}
#endif

#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	pattrib->pktlen += rtw_build_vendor_ie(padapter , &pframe , WIFI_ASSOCREQ_VENDOR_IE_BIT);
#endif

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	if (padapter->tbtx_capability == _TRUE)
		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, 8 , REALTEK_TBTX_IE, &(pattrib->pktlen));
#endif

	if (pmlmeinfo->assoc_AP_vendor == HT_IOT_PEER_REALTEK)
		pframe = rtw_set_ie(pframe, _VENDOR_SPECIFIC_IE_, 6 , REALTEK_96B_IE, &(pattrib->pktlen));

#ifdef CONFIG_RTW_WPS_MULTI_CREDENTIAL_SUPPORT
	if(padapter->registrypriv.wifi_mib.wps_multi_cred_enable == 1)
	{
		printk("[%s] (%d)%s add multi cred in assocreq\n",__FUNCTION__,__LINE__,padapter->pnetdev->name);
		_rtw_memcpy(pframe , wps_multi_cred_ie, 9);
		pframe += 9;
		pattrib->pktlen += 9;
	}
#endif

	pattrib->last_txcmdsz = pattrib->pktlen;
	dump_mgntframe(padapter, pmgntframe);

	ret = _SUCCESS;

exit:
	if (ret == _SUCCESS)
		rtw_buf_update(&pmlmepriv->assoc_req, &pmlmepriv->assoc_req_len, (u8 *)pwlanhdr, pattrib->pktlen);
	else
		rtw_buf_free(&pmlmepriv->assoc_req, &pmlmepriv->assoc_req_len);

	return;
}

void issue_assocreq(_adapter *padapter)
{
	_issue_assocreq(padapter, _FALSE);
}

void issue_reassocreq(_adapter *padapter)
{
	_issue_assocreq(padapter, _TRUE);
}

/* Null data TX status call back for client keep alive check in AP mode */
static void _null_data_txsts(struct rtw_txfb_t *txfb)
{
	struct xmit_frame *pmgntframe = (struct xmit_frame *)txfb->ctx;
	struct sta_info *psta;
	_adapter *padapter = (_adapter *)txfb->drvpriv;
	u8 *pframe;
	struct rtw_ieee80211_hdr *pwlanhdr;

	if (pmgntframe == NULL)
		return;

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	RTW_PRINT("Keep alive "MAC_FMT" status: %u\n",
	          MAC_ARG(pwlanhdr->addr1), txfb->txsts);

	if (txfb->txsts != TX_STATUS_TX_DONE)
		return;

	psta = pmgntframe->attrib.psta;

	if (psta == NULL)
		return;

	if (   ((psta->state & WIFI_ASOC_STATE) == 0)
	    || (padapter->netif_up == 0)) {
		RTW_PRINT("%s: Invalid station or adapter state.\n", __FUNCTION__);
		return;
	}

#if 0
	if ((psta->state & WIFI_STA_ALIVE_CHK_STATE) == 0)
		return;

	psta->state ^= WIFI_STA_ALIVE_CHK_STATE;
#else
	psta->state &= ~WIFI_STA_ALIVE_CHK_STATE;
#endif
	/* update for keep alive inactive_time */
	psta->sta_stats.last_rx_time = rtw_get_current_time();
	RTW_PRINT(ADPT_FMT": "MAC_FMT" status updated.\n",
	          ADPT_ARG(padapter), MAC_ARG(pwlanhdr->addr1));
}

/* when wait_ack is ture, this function shoule be called at process context */
static int _issue_nulldata(_adapter *padapter, unsigned char *da, unsigned int power_mode, int wait_ack, u32 rate)
{
	int ret = _FAIL;
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl, *qc;
	struct xmit_priv	*pxmitpriv;
	struct mlme_ext_priv	*pmlmeext;
	struct mlme_ext_info	*pmlmeinfo;
	u8 a4_shift;
	struct sta_info *psta = NULL;
	struct sta_priv *pstapriv = NULL;

	if (!padapter)
		goto exit;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pxmitpriv = &(padapter->xmitpriv);
	pmlmeext = &(padapter->mlmeextpriv);
	pmlmeinfo = &(pmlmeext->mlmext_info);
	pstapriv = &(padapter->stapriv);

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	psta = rtw_get_stainfo(pstapriv, da);
	if (psta != NULL) {
		pmgntframe->attrib.psta = psta;
		RTW_INFO("[%s] station mac : %02x:%02x:%02x:%02x:%02x:%02x\n", __func__,
			psta->phl_sta->mac_addr[0], psta->phl_sta->mac_addr[1], psta->phl_sta->mac_addr[2],
			psta->phl_sta->mac_addr[3], psta->phl_sta->mac_addr[4], psta->phl_sta->mac_addr[5]);
	}

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}
	pattrib->retry_ctrl = _FALSE;

#ifdef CONFIG_24G_256QAM
	pattrib->tx_force_rate = rate;
#endif

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	if (MLME_IS_AP(padapter)) {
		SetFrDs(fctrl);
		/* PS bit in AP mode is used to polling client */
		if (power_mode && pmgntframe->attrib.psta) {
			struct rtw_txfb_t *txfb;

			#ifdef CONFIG_XMIT_MGMT_ACK
			txfb = &pmgntframe->ack_rpt.txfb;
			pmgntframe->ack_rpt.ctx_buf_len = 0;
			#else
			txfb = (struct rtw_txfb_t *)(pframe + 512);
			#endif /* CONFIG_XMIT_MGMT_ACK */

			txfb->ctx = pmgntframe;
			txfb->drvpriv = padapter;
			txfb->txfb_cb = _null_data_txsts;
			pmgntframe->phl_txreq->txfb = txfb;
			/* TX feedback is set. Not wait for ack */
			wait_ack = 0;
		}
	} else if (MLME_IS_STA(padapter))
		SetToDs(fctrl);
	else if (MLME_IS_MESH(padapter)) {
		SetToDs(fctrl);
		SetFrDs(fctrl);
	}

	if (power_mode)
		SetPwrMgt(fctrl);

	if (get_tofr_ds(fctrl) == 3) {
		_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr4, adapter_mac_addr(padapter), ETH_ALEN);
		a4_shift = ETH_ALEN;
		pattrib->hdrlen += ETH_ALEN;
	} else {
		_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
		a4_shift = 0;
	}

	/* set null data to priority 0 (be) */
	qc = (unsigned short *)(pframe + pattrib->hdrlen - 2);
	SetPriority(qc, 0);
	pattrib->priority = 0;

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_DATA_NULL);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr) + a4_shift;
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr) + a4_shift;

	pattrib->last_txcmdsz = pattrib->pktlen;

	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

exit:
	return ret;
}

/*
 * When wait_ms > 0, this function should be called at process context
 * wait_ms == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 * wait_ms > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 * try_cnt means the maximal TX count to try
 * da == NULL for station mode
 */
int issue_nulldata(_adapter *padapter, unsigned char *da, unsigned int power_mode, int try_cnt, int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	/* da == NULL, assum it's null data for sta to ap */
	if (da == NULL)
		da = get_my_bssid(&(pmlmeinfo->network));

	do {
		ret = _issue_nulldata(padapter, da, power_mode, wait_ms > 0 ? _TRUE : _FALSE, INV_TXFORCE_VAL);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		goto exit;
#endif
	}

	if (try_cnt && wait_ms) {
		if (da)
			RTW_INFO(FUNC_ADPT_FMT" to "MAC_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), MAC_ARG(da), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
		else
			RTW_INFO(FUNC_ADPT_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:
	return ret;
}

#ifdef CONFIG_24G_256QAM
/* Send null data to check if the specific data rate is supported */
int issue_check_rate_nulldata(_adapter *padapter, unsigned char *da, unsigned int power_mode, int try_cnt, int wait_ms, u32 rate)
{
	int ret = -1;
	int i = 0;
	systime start = rtw_get_current_time();
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	/* da == NULL, assum it's null data for sta to ap */
	if (da == NULL)
		da = get_my_bssid(&(pmlmeinfo->network));

	do {
		ret = _issue_nulldata(padapter, da, power_mode, wait_ms > 0 ? _TRUE : _FALSE, rate);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL)
		ret = _SUCCESS;

exit:
	return ret;
}

/* Send null data to check if a 2G HT STA supports VHT */
int rtw_vht_2g_survey(_adapter *padapter, struct sta_info *psta)
{
	u8 mac[6], bwmode, nss, rssi;
	u16 snr;
	int ret;
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	if (!is_supported_24g(padapter->registrypriv.band_type) ||
	    !is_supported_ht(psta->phl_sta->wmode) ||
	    is_supported_vht(psta->phl_sta->wmode)) {
		psta->vht_2g_chk_cnt = 255;
		return _FAIL;
	}

	snprintf(mac, sizeof(mac), MAC_FMT, MAC_ARG(psta->phl_sta->mac_addr));
	bwmode = psta->phl_sta->chandef.bw;
	nss = rtw_get_sta_tx_nss(padapter, psta);
	rssi = rtw_phl_get_sta_rssi(psta->phl_sta);
	snr = psta->phl_sta->hal_sta->rssi_stat.snr_ma >> 4;

	RTW_INFO("[%s] "MAC_FMT" bwmode=%d, nss=%d, rssi=%d, snr=%d\n", __FUNCTION__, MAC_ARG(mac), bwmode, nss, rssi, snr);

	if (rssi < 50 || snr < 30) {
		RTW_INFO("[%s] "MAC_FMT" rssi(%d) or snr(%d) is lower than threshold\n", __FUNCTION__, MAC_ARG(mac), rssi, snr);
		return _FAIL;
	}

	ret = issue_check_rate_nulldata(padapter, psta->phl_sta->mac_addr, 0, 1, 1,
		(nss == 2 ? RTW_DATA_RATE_VHT_NSS2_MCS8 : RTW_DATA_RATE_VHT_NSS1_MCS8));

	if (ret == _SUCCESS) {
		psta->vht_2g_chk_cnt += 1;
		psta->phl_sta->vht_2g_supported = 1;
		if (padapter->registrypriv.wifi_mib.vht_proprietary & VHT_2G_UPT_RA)
			rtw_phl_ra_update(dvobj->phl, psta->phl_sta);
	} else if (ret == _FAIL) {
		psta->vht_2g_chk_cnt += 1;
	}

	return _SUCCESS;
}
#endif /* CONFIG_24G_256QAM */

static inline void _ps_announce(_adapter *adapter, bool ps)
{
	RTW_INFO(FUNC_ADPT_FMT" issue_null(%d)\n", FUNC_ADPT_ARG(adapter), ps);
	if (MLME_IS_STA(adapter)) {
		if (is_client_associated_to_ap(adapter) == _TRUE) {
			/*issue_nulldata(adapter, NULL, ps, 3, 500);*/
			issue_nulldata(adapter, NULL, ps, 1, 0);
		}
	}
	#ifdef CONFIG_RTW_MESH
	else if (MLME_IS_MESH(adapter)) {
		rtw_mesh_ps_annc(adapter, ps);
	}
	#endif
}

bool rtw_core_issu_null_data(void *priv, u8 ridx, bool ps)
{
	struct dvobj_priv *obj = (struct dvobj_priv *)priv;
	_adapter *iface = NULL;

	if (ridx >= CONFIG_IFACE_NUMBER) {
		RTW_ERR("%s ridx:%d invalid\n", __func__, ridx);
		rtw_warn_on(1);
		goto _error;
	}

	iface = obj->padapters[ridx];
	if (!rtw_is_adapter_up(iface))
		goto _error;

	_ps_announce(iface, ps);

	return _SUCCESS;
_error:
	return _FAIL;
}

/* when wait_ack is ture, this function shoule be called at process context */
static int _issue_qos_nulldata(_adapter *padapter, unsigned char *da, u16 tid, u8 ps, int wait_ack)
{
	int ret = _FAIL;
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl, *qc;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 a4_shift;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	/* RTW_INFO("%s\n", __FUNCTION__); */

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}

	pattrib->hdrlen += 2;
	pattrib->qos_en = _TRUE;
	pattrib->eosp = 1;
	pattrib->ack_policy = 0;
	pattrib->mdata = 0;

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	if (MLME_IS_AP(padapter))
		SetFrDs(fctrl);
	else if (MLME_IS_STA(padapter))
		SetToDs(fctrl);
	else if (MLME_IS_MESH(padapter)) {
		SetToDs(fctrl);
		SetFrDs(fctrl);
	}

	if (ps)
		SetPwrMgt(fctrl);

	if (pattrib->mdata)
		SetMData(fctrl);

	if (get_tofr_ds(fctrl) == 3) {
		_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr4, adapter_mac_addr(padapter), ETH_ALEN);
		a4_shift = ETH_ALEN;
		pattrib->hdrlen += ETH_ALEN;
	} else {
		_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
		a4_shift = 0;
	}

	qc = (unsigned short *)(pframe + pattrib->hdrlen - 2);

	SetPriority(qc, tid);
	pattrib->priority = tid;

	SetEOSP(qc, pattrib->eosp);

	SetAckpolicy(qc, pattrib->ack_policy);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_QOS_DATA_NULL);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr_qos) + a4_shift;
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr_qos) + a4_shift;

	pattrib->last_txcmdsz = pattrib->pktlen;

	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

exit:
	return ret;
}

/*
 * when wait_ms >0 , this function should be called at process context
 * wait_ms == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 * wait_ms > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 * try_cnt means the maximal TX count to try
 * da == NULL for station mode
 */
int issue_qos_nulldata(_adapter *padapter, unsigned char *da, u16 tid, u8 ps, int try_cnt, int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	/* da == NULL, assum it's null data for sta to ap*/
	if (da == NULL)
		da = get_my_bssid(&(pmlmeinfo->network));

	do {
		ret = _issue_qos_nulldata(padapter, da, tid, ps, wait_ms > 0 ? _TRUE : _FALSE);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		goto exit;
#endif
	}

	if (try_cnt && wait_ms) {
		if (da)
			RTW_INFO(FUNC_ADPT_FMT" to "MAC_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), MAC_ARG(da), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
		else
			RTW_INFO(FUNC_ADPT_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:
	return ret;
}

static int _issue_deauth(_adapter *padapter, unsigned char *da, unsigned short reason, u8 wait_ack, u8 key_type)
{
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	int ret = _FAIL;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P	 */

	/* RTW_INFO("%s to "MAC_FMT"\n", __func__, MAC_ARG(da)); */

#ifdef CONFIG_P2P
	if (!(rtw_p2p_chk_state(pwdinfo, P2P_STATE_NONE)) && (pwdinfo->rx_invitereq_info.scan_op_ch_only)) {
		_cancel_timer_ex(&pwdinfo->reset_ch_sitesurvey);
		_set_timer(&pwdinfo->reset_ch_sitesurvey, 10);
	}
#endif /* CONFIG_P2P */

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}
	pattrib->retry_ctrl = _FALSE;
	pattrib->key_type = key_type;
	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_DEAUTH);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	reason = cpu_to_le16(reason);
	pframe = rtw_set_fixed_ie(pframe, _RSON_CODE_ , (unsigned char *)&reason, &(pattrib->pktlen));

	pattrib->last_txcmdsz = pattrib->pktlen;


	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, da, 1, "Deauthentication", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

exit:
	return ret;
}

int issue_deauth(_adapter *padapter, unsigned char *da, unsigned short reason)
{
	RTW_PRINT("%s reason(%u) to "MAC_FMT"\n", __func__, reason, MAC_ARG(da));
	return _issue_deauth(padapter, da, reason, _FALSE, IEEE80211W_RIGHT_KEY);
}

#ifdef CONFIG_IEEE80211W
int issue_deauth_11w(_adapter *padapter, unsigned char *da, unsigned short reason, u8 key_type)
{
	RTW_PRINT("%s reason(%u) to "MAC_FMT"\n", __func__, reason, MAC_ARG(da));
	return _issue_deauth(padapter, da, reason, _FALSE, key_type);
}
#endif /* CONFIG_IEEE80211W */

/*
 * wait_ms == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 * wait_ms > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 * try_cnt means the maximal TX count to try
 */
int issue_deauth_ex(_adapter *padapter, u8 *da, unsigned short reason, int try_cnt,
		    int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();

	RTW_PRINT("%s reason(%u) to "MAC_FMT"\n", __func__, reason, MAC_ARG(da));

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	do {
		ret = _issue_deauth(padapter, da, reason, wait_ms > 0 ? _TRUE : _FALSE, IEEE80211W_RIGHT_KEY);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		goto exit;
#endif
	}

	if (try_cnt && wait_ms) {
		if (da)
			RTW_INFO(FUNC_ADPT_FMT" to "MAC_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), MAC_ARG(da), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
		else
			RTW_INFO(FUNC_ADPT_FMT", ch:%u%s, %d/%d in %u ms\n",
				FUNC_ADPT_ARG(padapter), rtw_get_oper_ch(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:
	return ret;
}

static int _issue_disassoc(_adapter *padapter, unsigned char *da, unsigned short reason, u8 wait_ack, u8 key_type)
{
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	int ret = _FAIL;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &(padapter->wdinfo);
#endif /* CONFIG_P2P	 */

	/* RTW_INFO("%s to "MAC_FMT"\n", __func__, MAC_ARG(da)); */

#ifdef CONFIG_P2P
	if (!(rtw_p2p_chk_state(pwdinfo, P2P_STATE_NONE)) && (pwdinfo->rx_invitereq_info.scan_op_ch_only)) {
		_cancel_timer_ex(&pwdinfo->reset_ch_sitesurvey);
		_set_timer(&pwdinfo->reset_ch_sitesurvey, 10);
	}
#endif /* CONFIG_P2P */

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}
	pattrib->retry_ctrl = _FALSE;
	pattrib->key_type = key_type;
	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, da, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_DISASSOC);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	reason = cpu_to_le16(reason);
	pframe = rtw_set_fixed_ie(pframe, _RSON_CODE_ , (unsigned char *)&reason, &(pattrib->pktlen));

	pattrib->last_txcmdsz = pattrib->pktlen;


	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(padapter, da, 1, "Disassociation", (unsigned char *)pwlanhdr, pattrib->pktlen);
#endif

exit:
	return ret;
}

int issue_disassoc(_adapter *padapter, unsigned char *da, unsigned short reason)
{
	RTW_PRINT("%s reason(%u) to "MAC_FMT"\n", __func__, reason, MAC_ARG(da));
	return _issue_disassoc(padapter, da, reason, _FALSE, IEEE80211W_RIGHT_KEY);
}

void issue_action_spct_ch_switch(_adapter *padapter, u8 *ra, u8 new_ch, u8 ch_offset)
{
	struct xmit_frame *pmgntframe;
	struct pkt_attrib *pattrib;
	unsigned char				*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short			*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

	RTW_INFO(FUNC_NDEV_FMT" ra="MAC_FMT", ch:%u, offset:%u\n",
		FUNC_NDEV_ARG(padapter->pnetdev), MAC_ARG(ra), new_ch, ch_offset);

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, ra, ETH_ALEN); /* RA */
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN); /* TA */
	_rtw_memcpy(pwlanhdr->addr3, ra, ETH_ALEN); /* DA = RA */

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	/* category, action */
	{
		u8 category, action;
		category = RTW_WLAN_CATEGORY_SPECTRUM_MGMT;
		action = RTW_WLAN_ACTION_SPCT_CHL_SWITCH;

		pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
		pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));
	}

#ifdef CONFIG_CSA_IE
	pframe = rtw_set_ie_ch_switch(pframe, &(pattrib->pktlen), 0, new_ch, 0);
#endif
	pframe = rtw_set_ie_secondary_ch_offset(pframe, &(pattrib->pktlen),
			hal_ch_offset_to_secondary_ch_offset(ch_offset));

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

}

#if defined(CONFIG_IEEE80211W) && !defined(CONFIG_IOCTL_CFG80211)
void issue_action_SA_Query(_adapter *padapter, unsigned char *raddr, unsigned char action, unsigned short tid, u8 key_type)
{
	u8	category = RTW_WLAN_CATEGORY_SA_QUERY;
	u16	reason_code;
	struct xmit_frame		*pmgntframe;
	struct pkt_attrib		*pattrib;
	u8					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	u16					*fctrl;
	struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct sta_info		*psta;
	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct registry_priv		*pregpriv = &padapter->registrypriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

	RTW_INFO("%s, %04x\n", __FUNCTION__, tid);

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL) {
		RTW_INFO("%s: alloc_mgtxmitframe fail\n", __FUNCTION__);
		return;
	}

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	pattrib->key_type = key_type;
	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	if (raddr)
		_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	else
		_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &category, &pattrib->pktlen);
	pframe = rtw_set_fixed_ie(pframe, 1, &action, &pattrib->pktlen);

	switch (action) {
	case 0: /* SA Query req */
		pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)&pmlmeext->sa_query_seq, &pattrib->pktlen);
		/* send sa query request to AP, AP should reply sa query response in 1 second */
		if (pattrib->key_type == IEEE80211W_RIGHT_KEY) {
			psta = rtw_get_stainfo(pstapriv, pwlanhdr->addr1);
			if (psta != NULL) {
				psta->sa_query_tid[psta->sa_query_cnt] = pmlmeext->sa_query_seq;
			}
		}
		pmlmeext->sa_query_seq++;
		break;

	case 1: /* SA Query rsp */
		/* RTW_INFO("rtw_set_fixed_ie, %04x\n", tid); */
		pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)&tid, &pattrib->pktlen);
		break;
	default:
		break;
	}

	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);
}
#endif /* CONFIG_IEEE80211W */

/**
 * issue_action_ba - internal function to TX Block Ack action frame
 * @padapter: the adapter to TX
 * @raddr: receiver address
 * @action: Block Ack Action
 * @tid: tid
 * @size: the announced AMPDU buffer size. used by ADDBA_RESP
 * @paddba_req: used by ADDBA_RESP
 * @status: status/reason code. used by ADDBA_RESP, DELBA
 * @initiator: if we are the initiator of AMPDU association. used by DELBA
 * @wait_ack: used xmit ack
 *
 * Returns:
 * _SUCCESS: No xmit ack is used or acked
 * _FAIL: not acked when using xmit ack
 */
static int issue_action_ba(_adapter *padapter, unsigned char *raddr,
			   unsigned char action, u8 tid, u8 size,
			   struct ADDBA_request *paddba_req, u16 status,
			   u8 initiator, int wait_ack)
{
	int ret = _FAIL;
	u8	category = RTW_WLAN_CATEGORY_BACK;
	u16	start_seq;
	u16	BA_para_set;
	u16	BA_timeout_value;
	u16	BA_starting_seqctrl;
	struct xmit_frame		*pmgntframe;
	struct pkt_attrib		*pattrib;
	u8					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	u16					*fctrl;
	struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct sta_info		*psta;
	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct registry_priv		*pregpriv = &padapter->registrypriv;

#ifdef CONFIG_80211N_HT

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		goto exit;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		goto exit;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	/* _rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN); */
	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));

	if (category == 3) {
		switch (action) {
		case RTW_WLAN_ACTION_ADDBA_REQ:
			do {
				pmlmeinfo->dialogToken++;
			} while (pmlmeinfo->dialogToken == 0);
			pframe = rtw_set_fixed_ie(pframe, 1, &(pmlmeinfo->dialogToken), &(pattrib->pktlen));

			/* ToDo: Pass in STA instead of looking it up */
			psta = rtw_get_stainfo(pstapriv, raddr);
			if (psta == NULL) {
				RTW_ERR("NULL STA to ADDBA\n");
				rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
				return _FAIL;
			}

			/* Still set buffer size to 64, because when the negotiated buffer size is larger than 64,
			   some HE STAs cannot transmit 256-bit bitmap BA, and then let throughput degrade. */

			/* buffer size from cap */
			BA_para_set = (psta->phl_sta->asoc_cap.num_ampdu << 6);
			if (   psta->hepriv.he_option
				&& (padapter->phl_role->proto_role_cap.num_ampdu > 64)) {
				/* buffer size from cap */
				/* if sta or ap in BW80, max ampdu size is 128 */
				BA_para_set = (padapter->phl_role->proto_role_cap.num_ampdu << 6);
			} else /* default */
				BA_para_set = (64 << 6); /* 64 buffer size */

			if (padapter->driver_tx_max_agg_num != 0xFFFF)
				BA_para_set = (padapter->driver_tx_max_agg_num << 6);

			/* immediate ack */
			BA_para_set |= (0x2 | ((tid & 0xf) << 2));

			RTW_INFO("BA_para_set = 0x%x for agg_num=%d\n", BA_para_set, (BA_para_set >> 6));

			RTW_INFO("[issue ADDBA_REQ] to %pM bw:%d tid:%d ampdu_num:%d\n",
				psta->phl_sta->mac_addr, psta->phl_sta->chandef.bw, tid, (BA_para_set >> 6));

#ifdef CONFIG_TX_AMSDU
			if (padapter->tx_amsdu >= 1) /* TX AMSDU  enabled */
				BA_para_set |= BIT(0);
			else /* TX AMSDU disabled */
				BA_para_set &= ~BIT(0);
#endif
			BA_para_set = cpu_to_le16(BA_para_set);
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(BA_para_set)), &(pattrib->pktlen));

			/* BA_timeout_value = 0xffff; */ /* max: 65535 TUs(~ 65 ms) */
			#if 0
			BA_timeout_value = 0xffff;/* ~ 5ms */
			BA_timeout_value = cpu_to_le16(BA_timeout_value);
			#else
			BA_timeout_value = 0;
			#endif
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(BA_timeout_value)), &(pattrib->pktlen));

			/* if ((psta = rtw_get_stainfo(pstapriv, pmlmeinfo->network.MacAddress)) != NULL) */
			#ifdef CONFIG_RTW_TXSC_USE_HW_SEQ
			#ifndef CONFIG_RTW_LINK_PHL_MASTER
			// 11882df8e498e6ed1ae021bfe39d2c7ed7046736 ystang
			start_seq = rtw_phl_get_hw_seq(padapter->dvobj->phl,
							psta->phl_sta, tid);/* CONFIG_RTW_TXSC_USE_HW_SEQ */
				#endif /* CONFIG_RTW_LINK_PHL_MASTER */
			#else /* CONFIG_RTW_TXSC_USE_HW_SEQ */
			start_seq = (psta->sta_xmitpriv.txseq_tid[tid & 0x07] & 0xfff) + 1;
			#endif /* CONFIG_RTW_TXSC_USE_HW_SEQ */

			RTW_INFO("BA_starting_seqctrl = %d for TID=%d\n", start_seq, tid & 0x07);

			psta->BA_starting_seqctrl[tid & 0x07] = start_seq;

			BA_starting_seqctrl = start_seq << 4;
			BA_starting_seqctrl = cpu_to_le16(BA_starting_seqctrl);
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(BA_starting_seqctrl)), &(pattrib->pktlen));
			break;

		case RTW_WLAN_ACTION_ADDBA_RESP:
			pframe = rtw_set_fixed_ie(pframe, 1, &(paddba_req->dialog_token), &(pattrib->pktlen));
			status = cpu_to_le16(status);
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&status), &(pattrib->pktlen));

			BA_para_set = le16_to_cpu(paddba_req->BA_para_set);

			BA_para_set &= ~IEEE80211_ADDBA_PARAM_TID_MASK;
			BA_para_set |= (tid << 2) & IEEE80211_ADDBA_PARAM_TID_MASK;

			BA_para_set &= ~RTW_IEEE80211_ADDBA_PARAM_BUF_SIZE_MASK;
			BA_para_set |= (size << 6) & RTW_IEEE80211_ADDBA_PARAM_BUF_SIZE_MASK;

			if (!padapter->registrypriv.wifi_spec) {
				if (pregpriv->rx_ampdu_amsdu == 0) /* disabled */
					BA_para_set &= ~BIT(0);
				else if (pregpriv->rx_ampdu_amsdu == 1) /* enabled */
					BA_para_set |= BIT(0);
			}

			if (raddr)
				RTW_INFO("[issue ADDBA_RESP] to %pM tid:%d ampdu_num:%d\n", raddr, tid, size);

			BA_para_set = cpu_to_le16(BA_para_set);

			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(BA_para_set)), &(pattrib->pktlen));
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(paddba_req->BA_timeout_value)), &(pattrib->pktlen));
			break;

		case RTW_WLAN_ACTION_DELBA:
			BA_para_set = 0;
			BA_para_set |= (tid << 12) & IEEE80211_DELBA_PARAM_TID_MASK;
			BA_para_set |= (initiator << 11) & IEEE80211_DELBA_PARAM_INITIATOR_MASK;

			BA_para_set = cpu_to_le16(BA_para_set);
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(BA_para_set)), &(pattrib->pktlen));
			status = cpu_to_le16(status);
			pframe = rtw_set_fixed_ie(pframe, 2, (unsigned char *)(&(status)), &(pattrib->pktlen));
			break;
		default:
			break;
		}
	}

	pattrib->last_txcmdsz = pattrib->pktlen;

	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

exit:
#endif /* CONFIG_80211N_HT */
	return ret;
}

/**
 * issue_addba_req - TX ADDBA_REQ
 * @adapter: the adapter to TX
 * @ra: receiver address
 * @tid: tid
 */
inline void issue_addba_req(_adapter *adapter, unsigned char *ra, u8 tid)
{
	issue_action_ba(adapter, ra, RTW_WLAN_ACTION_ADDBA_REQ
			, tid
			, 0 /* unused */
			, NULL /* unused */
			, 0 /* unused */
			, 0 /* unused */
			, _FALSE
		       );
	RTW_INFO(FUNC_ADPT_FMT" ra="MAC_FMT" tid=%u\n"
		 , FUNC_ADPT_ARG(adapter), MAC_ARG(ra), tid);

}

/**
 * issue_addba_rsp - TX ADDBA_RESP
 * @adapter: the adapter to TX
 * @ra: receiver address
 * @tid: tid
 * @status: status code
 * @size: the announced AMPDU buffer size
 * @paddba_req: used by ADDBA_RESP
 */
inline void issue_addba_rsp(_adapter *adapter, unsigned char *ra, u8 tid,
			    u16 status, u8 size,
			    struct ADDBA_request *paddba_req)
{
	issue_action_ba(adapter, ra, RTW_WLAN_ACTION_ADDBA_RESP
			, tid
			, size
			, paddba_req
			, status
			, 0 /* unused */
			, _FALSE
		       );
	RTW_INFO(FUNC_ADPT_FMT" ra="MAC_FMT" status=%u, tid=%u, size=%u\n"
		 , FUNC_ADPT_ARG(adapter), MAC_ARG(ra), status, tid, size);
}

/**
 * issue_addba_rsp_wait_ack - TX ADDBA_RESP and wait ack
 * @adapter: the adapter to TX
 * @ra: receiver address
 * @tid: tid
 * @status: status code
 * @size: the announced AMPDU buffer size
 * @paddba_req: used by ADDBA_RESP
 * @try_cnt: the maximal TX count to try
 * @wait_ms: == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 *           > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 */
inline u8 issue_addba_rsp_wait_ack(_adapter *adapter, unsigned char *ra, u8 tid,
				   u16 status, u8 size,
				   struct ADDBA_request *paddba_req, int try_cnt,
				   int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(adapter)))
		goto exit;

	do {
		ret = issue_action_ba(adapter, ra, RTW_WLAN_ACTION_ADDBA_RESP
				      , tid
				      , size
				      , paddba_req
				      , status
				      , 0 /* unused */
				      , _TRUE
				     );

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(adapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		/* goto exit; */
#endif
	}

	if (try_cnt && wait_ms) {
		RTW_INFO(FUNC_ADPT_FMT" ra="MAC_FMT" status:=%u tid=%u size:%u%s, %d/%d in %u ms\n"
			, FUNC_ADPT_ARG(adapter), MAC_ARG(ra), status, tid, size
			, ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}

exit:
	return ret;
}

/**
 * issue_del_ba - TX DELBA
 * @adapter: the adapter to TX
 * @ra: receiver address
 * @tid: tid
 * @reason: reason code
 * @initiator: if we are the initiator of AMPDU association. used by DELBA
 */
inline void issue_del_ba(_adapter *adapter, unsigned char *ra, u8 tid, u16 reason, u8 initiator)
{
	issue_action_ba(adapter, ra, RTW_WLAN_ACTION_DELBA
			, tid
			, 0 /* unused */
			, NULL /* unused */
			, reason
			, initiator
			, _FALSE
		       );
	RTW_INFO(FUNC_ADPT_FMT" ra="MAC_FMT" reason=%u, tid=%u, initiator=%u\n"
		 , FUNC_ADPT_ARG(adapter), MAC_ARG(ra), reason, tid, initiator);
}

/**
 * issue_del_ba_ex - TX DELBA with xmit ack options
 * @adapter: the adapter to TX
 * @ra: receiver address
 * @tid: tid
 * @reason: reason code
 * @initiator: if we are the initiator of AMPDU association. used by DELBA
 * @try_cnt: the maximal TX count to try
 * @wait_ms: == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 *           > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 */
int issue_del_ba_ex(_adapter *adapter, unsigned char *ra, u8 tid, u16 reason, u8 initiator
		    , int try_cnt, int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(adapter)))
		goto exit;

	do {
		ret = issue_action_ba(adapter, ra, RTW_WLAN_ACTION_DELBA
				      , tid
				      , 0 /* unused */
				      , NULL /* unused */
				      , reason
				      , initiator
				      , wait_ms > 0 ? _TRUE : _FALSE
				     );

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(adapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		/* goto exit; */
#endif
	}

	if (try_cnt && wait_ms) {
		RTW_INFO(FUNC_ADPT_FMT" ra="MAC_FMT" reason=%u, tid=%u, initiator=%u%s, %d/%d in %u ms\n"
			, FUNC_ADPT_ARG(adapter), MAC_ARG(ra), reason, tid, initiator
			, ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:
	return ret;
}

void issue_action_BSSCoexistPacket(_adapter *padapter)
{
	_list		*plist, *phead;
	unsigned char category, action;
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char				*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short			*fctrl;
	struct	wlan_network	*pnetwork = NULL;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
#ifdef RTW_MI_SHARE_BSS_LIST
	_queue *queue = &padapter->dvobj->scanned_queue;
#else
	_queue *queue = &pmlmepriv->scanned_queue;
#endif

	u8 InfoContent[16] = {0};
	u8 ICS[8][15];
#ifdef CONFIG_80211N_HT
	if ((pmlmepriv->num_FortyMHzIntolerant == 0) && (pmlmepriv->num_sta_no_ht == 0))
		return;

	if (_TRUE == pmlmeinfo->bwmode_updated)
		return;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return;

	RTW_INFO("%s\n", __FUNCTION__);


	category = RTW_WLAN_CATEGORY_PUBLIC;
	action = ACT_PUBLIC_BSSCOEXIST;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));

	/* TODO calculate 40Mhz intolerant via ch and ch offset */
	/* if (pmlmepriv->num_FortyMHzIntolerant > 0) */
	{
		u8 iedata = 0;

		iedata |= BIT(2);/* 20 MHz BSS Width Request */
		pframe = rtw_set_ie(pframe, EID_BSSCoexistence,  1, &iedata, &(pattrib->pktlen));
	}

	/*  */
	_rtw_memset(ICS, 0, sizeof(ICS));
	if (pmlmepriv->num_sta_no_ht > 0) {
		int i;

		_rtw_spinlock_bh(&(queue->lock));

		phead = get_list_head(queue);
		plist = get_next(phead);

		while (1) {
			int len;
			u8 *p;
			WLAN_BSSID_EX *pbss_network;

			if (rtw_end_of_queue_search(phead, plist) == _TRUE)
				break;

			pnetwork = LIST_CONTAINOR(plist, struct wlan_network, list);

			plist = get_next(plist);

			pbss_network = (WLAN_BSSID_EX *)&pnetwork->network;

			p = rtw_get_ie(pbss_network->IEs + _FIXED_IE_LENGTH_, _HT_CAPABILITY_IE_, &len, pbss_network->IELength - _FIXED_IE_LENGTH_);
			if ((p == NULL) || (len == 0)) { /* non-HT */
				if ((pbss_network->Configuration.DSConfig <= 0) || (pbss_network->Configuration.DSConfig > 14))
					continue;

				ICS[0][pbss_network->Configuration.DSConfig] = 1;

				if (ICS[0][0] == 0)
					ICS[0][0] = 1;
			}

		}

		_rtw_spinunlock_bh(&(queue->lock));


		for (i = 0; i < 8; i++) {
			if (ICS[i][0] == 1) {
				int j, k = 0;

				InfoContent[k] = i;
				/* SET_BSS_INTOLERANT_ELE_REG_CLASS(InfoContent,i); */
				k++;

				for (j = 1; j <= 14; j++) {
					if (ICS[i][j] == 1) {
						if (k < 16) {
							InfoContent[k] = j; /* channel number */
							/* SET_BSS_INTOLERANT_ELE_CHANNEL(InfoContent+k, j); */
							k++;
						}
					}
				}

				pframe = rtw_set_ie(pframe, EID_BSSIntolerantChlReport, k, InfoContent, &(pattrib->pktlen));

			}

		}


	}


	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);
#endif /* CONFIG_80211N_HT */
}

/* Spatial Multiplexing Powersave (SMPS) action frame */
int _issue_action_SM_PS(_adapter *padapter ,  unsigned char *raddr , u8 NewMimoPsMode ,  u8 wait_ack)
{

	int ret = _FAIL;
	unsigned char category = RTW_WLAN_CATEGORY_HT;
	u8 action = RTW_WLAN_ACTION_HT_SM_PS;
	u8 sm_power_control = 0;
	struct xmit_frame			*pmgntframe;
	struct pkt_attrib			*pattrib;
	unsigned char					*pframe;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	unsigned short				*fctrl;
	struct xmit_priv			*pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);


	if (NewMimoPsMode == WLAN_HT_CAP_SM_PS_DISABLED) {
		sm_power_control = sm_power_control  & ~(BIT(0)); /* SM Power Save Enable = 0 SM Power Save Disable */
	} else if (NewMimoPsMode == WLAN_HT_CAP_SM_PS_STATIC) {
		sm_power_control = sm_power_control | BIT(0);    /* SM Power Save Enable = 1 SM Power Save Enable  */
		sm_power_control = sm_power_control & ~(BIT(1)); /* SM Mode = 0 Static Mode */
	} else if (NewMimoPsMode == WLAN_HT_CAP_SM_PS_DYNAMIC) {
		sm_power_control = sm_power_control | BIT(0); /* SM Power Save Enable = 1 SM Power Save Enable  */
		sm_power_control = sm_power_control | BIT(1); /* SM Mode = 1 Dynamic Mode */
	} else
		return ret;

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		return ret;

	RTW_INFO("%s, sm_power_control=%u, NewMimoPsMode=%u\n", __FUNCTION__ , sm_power_control , NewMimoPsMode);

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return ret;

	/* update attribute */
	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return ret;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;

	fctrl = &(pwlanhdr->frame_ctl);
	*(fctrl) = 0;

	_rtw_memcpy(pwlanhdr->addr1, raddr, ETH_ALEN); /* RA */
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN); /* TA */
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&(pmlmeinfo->network)), ETH_ALEN); /* DA = RA */

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	/* category, action */
	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));

	pframe = rtw_set_fixed_ie(pframe, 1, &(sm_power_control), &(pattrib->pktlen));

	pattrib->last_txcmdsz = pattrib->pktlen;

	if (wait_ack)
		ret = dump_mgntframe_and_wait_ack(padapter, pmgntframe);
	else {
		dump_mgntframe(padapter, pmgntframe);
		ret = _SUCCESS;
	}

	if (ret != _SUCCESS)
		RTW_INFO("%s, ack to\n", __func__);

	return ret;
}

/*
 * wait_ms == 0 means that there is no need to wait ack through C2H_CCX_TX_RPT
 * wait_ms > 0 means you want to wait ack through C2H_CCX_TX_RPT, and the value of wait_ms means the interval between each TX
 * try_cnt means the maximal TX count to try
 */
int issue_action_SM_PS_wait_ack(_adapter *padapter, unsigned char *raddr, u8 NewMimoPsMode, int try_cnt, int wait_ms)
{
	int ret = _FAIL;
	int i = 0;
	systime start = rtw_get_current_time();

	if (rtw_rfctl_is_tx_blocked_by_ch_waiting(adapter_to_rfctl(padapter)))
		goto exit;

	do {
		ret = _issue_action_SM_PS(padapter, raddr, NewMimoPsMode , wait_ms > 0 ? _TRUE : _FALSE);

		i++;

		if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
			break;

		if (i < try_cnt && wait_ms > 0 && ret == _FAIL)
			rtw_msleep_os(wait_ms);

	} while ((i < try_cnt) && ((ret == _FAIL) || (wait_ms == 0)));

	if (ret != _FAIL) {
		ret = _SUCCESS;
#ifndef DBG_XMIT_ACK
		goto exit;
#endif
	}

	if (try_cnt && wait_ms) {
		if (raddr)
			RTW_INFO(FUNC_ADPT_FMT" to "MAC_FMT", %s , %d/%d in %u ms\n",
				 FUNC_ADPT_ARG(padapter), MAC_ARG(raddr),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
		else
			RTW_INFO(FUNC_ADPT_FMT", %s , %d/%d in %u ms\n",
				 FUNC_ADPT_ARG(padapter),
				ret == _SUCCESS ? ", acked" : "", i, try_cnt, rtw_get_passing_time_ms(start));
	}
exit:

	return ret;
}

int issue_action_SM_PS(_adapter *padapter ,  unsigned char *raddr , u8 NewMimoPsMode)
{
	RTW_INFO("%s to "MAC_FMT"\n", __func__, MAC_ARG(raddr));
	return _issue_action_SM_PS(padapter, raddr, NewMimoPsMode , _FALSE);
}

/**
 * _send_delba_sta_tid - Cancel the AMPDU association for the specific @sta, @tid
 * @adapter: the adapter to which @sta belongs
 * @initiator: if we are the initiator of AMPDU association
 * @sta: the sta to be checked
 * @tid: the tid to be checked
 * @force: cancel and send DELBA even when no AMPDU association is setup
 * @wait_ack: send delba with xmit ack (valid when initiator == 0)
 *
 * Returns:
 * _FAIL if sta is NULL
 * when initiator is 1, always _SUCCESS
 * when initiator is 0, _SUCCESS if DELBA is acked
 */
static unsigned int _send_delba_sta_tid(_adapter *adapter, u8 initiator, struct sta_info *sta, u8 tid
					, u8 force, int wait_ack)
{
	int ret = _SUCCESS;

	if (sta == NULL) {
		ret = _FAIL;
		goto exit;
	}

	if (initiator == 0) {
		/* recipient */
		if (force || sta->recvreorder_ctrl[tid].enable == _TRUE) {
			u8 ampdu_size_bak = sta->recvreorder_ctrl[tid].ampdu_size;

			/* Stop PHL BA session */
			rtw_phl_stop_rx_ba_session(sta->phl_sta->wrole->phl_com->phl_priv,
			                           sta->phl_sta, tid);

			sta->recvreorder_ctrl[tid].enable = _FALSE;
			sta->recvreorder_ctrl[tid].ampdu_size = RX_AMPDU_SIZE_INVALID;

			if (rtw_del_rx_ampdu_test_trigger_no_tx_fail())
				ret = _FAIL;
			else if (wait_ack)
				ret = issue_del_ba_ex(adapter, sta->phl_sta->mac_addr, tid, 37, initiator, 3, 1);
			else
				issue_del_ba(adapter, sta->phl_sta->mac_addr, tid, 37, initiator);

			if (ret == _FAIL && sta->recvreorder_ctrl[tid].enable == _FALSE)
				sta->recvreorder_ctrl[tid].ampdu_size = ampdu_size_bak;
		}
	} else if (initiator == 1) {
		/* originator */
#ifdef CONFIG_80211N_HT
		if (force || sta->htpriv.agg_enable_bitmap & BIT(tid)) {
			sta->htpriv.agg_enable_bitmap &= ~BIT(tid);
			sta->htpriv.candidate_tid_bitmap &= ~BIT(tid);
			issue_del_ba(adapter, sta->phl_sta->mac_addr, tid, 37, initiator);
		}
#endif
	}

exit:
	return ret;
}

inline unsigned int send_delba_sta_tid(_adapter *adapter, u8 initiator, struct sta_info *sta, u8 tid
				       , u8 force)
{
	return _send_delba_sta_tid(adapter, initiator, sta, tid, force, 0);
}

inline unsigned int send_delba_sta_tid_wait_ack(_adapter *adapter, u8 initiator, struct sta_info *sta, u8 tid
		, u8 force)
{
	return _send_delba_sta_tid(adapter, initiator, sta, tid, force, 1);
}

unsigned int send_delba(_adapter *padapter, u8 initiator, u8 *addr)
{
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *psta = NULL;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u16 tid;

	if (!MLME_IN_AP_STATE(pmlmeinfo))
		if (!(pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS))
			return _SUCCESS;

	psta = rtw_get_stainfo(pstapriv, addr);
	if (psta == NULL)
		return _SUCCESS;

#if 0
	RTW_INFO("%s:%s\n", __func__, (initiator == 0) ? "RX_DIR" : "TX_DIR");
	if (initiator == 1) /* originator */
		RTW_INFO("tx agg_enable_bitmap(0x%08x)\n", psta->htpriv.agg_enable_bitmap);
#endif

	for (tid = 0; tid < TID_NUM; tid++)
		send_delba_sta_tid(padapter, initiator, psta, tid, 0);

	return _SUCCESS;
}

unsigned int send_beacon(_adapter *padapter)
{
	bool func_off = 0;

	func_off = padapter->registrypriv.wifi_mib.func_off;
	if (func_off)
		return _SUCCESS;
#ifdef RTW_PHL_BCN

	/* bypass TX BCN queue because op ch is switching/waiting */
	if (!(MLME_IS_MESH(padapter) ||
			MLME_IS_AP(padapter) ||
			MLME_IS_ADHOC_MASTER(padapter)) ||
		check_fwstate(&padapter->mlmepriv, WIFI_OP_CH_SWITCHING) ||
		IS_CH_WAITING(adapter_to_rfctl(padapter))
	)
		return _SUCCESS;

#ifdef CONFIG_AP_MODE
	/* bypass when beacon content is NOT ready */
	if ((MLME_IS_AP(padapter) || MLME_IS_MESH(padapter))
		&& padapter->mlmeextpriv.bstart_bss == _FALSE)
		return _SUCCESS;
#endif

#if 1//WNC add
		if ((padapter->registrypriv.wifi_mib.func_off == 1) ||
			  /* WNC-NMR4068-MikeYeh-20220120-Beacon transmission from invalid I/F. */
			 (rtw_is_adapter_up(padapter) && MLME_IS_STA(padapter) && !is_primary_adapter(padapter)) /* check vxd interface */)
				return _SUCCESS;
#endif//WNC add end

	issue_beacon(padapter, 0);

	/* maybe need some mechanism to check bcn ready here */

	return _SUCCESS;
#else
#if defined(CONFIG_PCI_HCI) && !defined(CONFIG_PCI_BCN_POLLING)

	/* bypass TX BCN queue because op ch is switching/waiting */
	if (check_fwstate(&padapter->mlmepriv, WIFI_OP_CH_SWITCHING)
		|| IS_CH_WAITING(adapter_to_rfctl(padapter))
	)
		return _SUCCESS;

	/* RTW_INFO("%s\n", __FUNCTION__); */

	rtw_hal_set_hwreg(padapter, HW_VAR_BCN_VALID, NULL);
	rtw_hal_set_hwreg(padapter, HW_VAR_DL_BCN_SEL, NULL);


	issue_beacon(padapter, 0);

	return _SUCCESS;
#endif

/* CONFIG_PCI_BCN_POLLING is for pci interface beacon polling mode */
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)|| defined(CONFIG_PCI_BCN_POLLING)
	u8 bxmitok = _FALSE;
	int issue = 0;
	int poll = 0;
	systime start = rtw_get_current_time();

	/* bypass TX BCN queue because op ch is switching/waiting */
	if (check_fwstate(&padapter->mlmepriv, WIFI_OP_CH_SWITCHING)
		|| IS_CH_WAITING(adapter_to_rfctl(padapter))
	)
		return _SUCCESS;

	rtw_hal_set_hwreg(padapter, HW_VAR_BCN_VALID, NULL);
	rtw_hal_set_hwreg(padapter, HW_VAR_DL_BCN_SEL, NULL);
	do {
		#if defined(CONFIG_PCI_BCN_POLLING)
		issue_beacon(padapter, 0);
		#else
		issue_beacon(padapter, 100);
		#endif
		issue++;
		do {
			#if defined(CONFIG_PCI_BCN_POLLING)
			rtw_msleep_os(1);
			#else
			rtw_yield_os();
			#endif
			rtw_hal_get_hwreg(padapter, HW_VAR_BCN_VALID, (u8 *)(&bxmitok));
			poll++;
		} while ((poll % 10) != 0 && _FALSE == bxmitok && !RTW_CANNOT_RUN(adapter_to_dvobj(padapter)));
		#if defined(CONFIG_PCI_BCN_POLLING)
		rtw_hal_unmap_beacon_icf(padapter);
		#endif
	} while (bxmitok == _FALSE && (issue < 100) && !RTW_CANNOT_RUN(adapter_to_dvobj(padapter)));

	if (RTW_CANNOT_RUN(adapter_to_dvobj(padapter)))
		return _FAIL;


	if (_FALSE == bxmitok) {
		RTW_INFO("%s fail! %u ms\n", __FUNCTION__, rtw_get_passing_time_ms(start));
		return _FAIL;
	} else {
		u32 passing_time = rtw_get_passing_time_ms(start);

		if (passing_time > 100 || issue > 3)
			RTW_INFO("%s success, issue:%d, poll:%d, %u ms\n", __FUNCTION__, issue, poll, rtw_get_passing_time_ms(start));
		else if (0)
			RTW_INFO("%s success, issue:%d, poll:%d, %u ms\n", __FUNCTION__, issue, poll, rtw_get_passing_time_ms(start));

		return _SUCCESS;
	}

#endif /*defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)*/
#endif /* RTW_PHL_BCN */
}

/****************************************************************************

Following are some utitity fuctions for WiFi MLME

*****************************************************************************/

BOOLEAN IsLegal5GChannel(
	_adapter *adapter,
	u8			channel)
{

	int i = 0;
	u8 Channel_5G[45] = {36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58,
		60, 62, 64, 100, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122,
		124, 126, 128, 130, 132, 134, 136, 138, 140, 149, 151, 153, 155, 157, 159,
			     161, 163, 165
			    };
	for (i = 0; i < sizeof(Channel_5G); i++)
		if (channel == Channel_5G[i])
			return _TRUE;
	return _FALSE;
}

/* collect bss info from Beacon and Probe request/response frames. */
u8 collect_bss_info(_adapter *padapter, union recv_frame *precv_frame, WLAN_BSSID_EX *bssid)
{
	int	i;
	sint len;
	u8	*p;
	u8	rf_path;
	u16	val16, subtype;
	u8	*pframe = precv_frame->u.hdr.rx_data;
	u32	packet_len = precv_frame->u.hdr.len;
	u8 ie_offset;
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct registry_priv	*pregistrypriv = &padapter->registrypriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 oper_bw = CHANNEL_WIDTH_20, oper_offset = CHAN_OFFSET_NO_EXT;

	len = packet_len - sizeof(struct rtw_ieee80211_hdr_3addr);

	if (len > MAX_IE_SZ) {
		/* RTW_INFO("IE too long for survey event\n"); */
		return _FAIL;
	}

	_rtw_memset(bssid, 0, sizeof(WLAN_BSSID_EX));

	subtype = get_frame_sub_type(pframe);

	if (subtype == WIFI_BEACON) {
		bssid->Reserved[0] = BSS_TYPE_BCN;
		ie_offset = _BEACON_IE_OFFSET_;
	} else {
		/* FIXME : more type */
		if (subtype == WIFI_PROBERSP) {
			ie_offset = _PROBERSP_IE_OFFSET_;
			bssid->Reserved[0] = BSS_TYPE_PROB_RSP;
		} else if (subtype == WIFI_PROBEREQ) {
			ie_offset = _PROBEREQ_IE_OFFSET_;
			bssid->Reserved[0] = BSS_TYPE_PROB_REQ;
		} else {
			bssid->Reserved[0] = BSS_TYPE_UNDEF;
			ie_offset = _FIXED_IE_LENGTH_;
		}
	}

	bssid->Length = sizeof(WLAN_BSSID_EX) - MAX_IE_SZ + len;

	/* below is to copy the information element */
	bssid->IELength = len;
	_rtw_memcpy(bssid->IEs, (pframe + sizeof(struct rtw_ieee80211_hdr_3addr)), bssid->IELength);

	/* get the signal strength */
	/* bssid->Rssi = precv_frame->u.hdr.attrib.SignalStrength; */ /* 0-100 index. */
	bssid->Rssi = precv_frame->u.hdr.attrib.phy_info.recv_signal_power; /* in dBM.raw data */
	bssid->PhyInfo.SignalQuality = precv_frame->u.hdr.attrib.phy_info.signal_quality;/* in percentage */
	bssid->PhyInfo.SignalStrength = precv_frame->u.hdr.attrib.phy_info.signal_strength;/* in percentage */

	/* get rx_snr */
	if (precv_frame->u.hdr.attrib.data_rate >= DESC_RATE11M) {
		bssid->PhyInfo.is_cck_rate = 0;
		for (rf_path = 0; rf_path < GET_HAL_RFPATH_NUM(dvobj); rf_path++)
			bssid->PhyInfo.rx_snr[rf_path] =
				precv_frame->u.hdr.attrib.phy_info.rx_snr[rf_path];
	} else
		bssid->PhyInfo.is_cck_rate = 1;

#ifdef CONFIG_ANTENNA_DIVERSITY
	rtw_hal_get_phydm_var(padapter, HAL_PHYDM_ANTDIV_SELECT, &(bssid->PhyInfo.Optimum_antenna), NULL);
#endif

	/* checking SSID */
	p = rtw_get_ie(bssid->IEs + ie_offset, _SSID_IE_, &len, bssid->IELength - ie_offset);
	if (p == NULL) {
		RTW_INFO("marc: cannot find SSID for survey event\n");
		return _FAIL;
	}

	if (*(p + 1)) {
		if (len > NDIS_802_11_LENGTH_SSID) {
			RTW_INFO("%s()-%d: IE too long (%d) for survey event\n", __FUNCTION__, __LINE__, len);
			return _FAIL;
		}
		_rtw_memcpy(bssid->Ssid.Ssid, (p + 2), *(p + 1));
		bssid->Ssid.SsidLength = *(p + 1);
	} else
		bssid->Ssid.SsidLength = 0;

	_rtw_memset(bssid->SupportedRates, 0, NDIS_802_11_LENGTH_RATES_EX);

	/* checking rate info... */
	i = 0;
	p = rtw_get_ie(bssid->IEs + ie_offset, _SUPPORTEDRATES_IE_, &len, bssid->IELength - ie_offset);
	if (p != NULL) {
		if (len > NDIS_802_11_LENGTH_RATES_EX) {
			RTW_INFO("%s()-%d: IE too long (%d) for survey event\n", __FUNCTION__, __LINE__, len);
			return _FAIL;
		}
#ifndef RTW_PHL_TEST_FPGA
		if (rtw_validate_value(_SUPPORTEDRATES_IE_, p+2, len) == _FALSE) {
			rtw_absorb_ssid_ifneed(padapter, bssid, pframe);
			RTW_DBG_DUMP("Invalidated Support Rate IE --", p, len+2);
			return _FAIL;
		}
#endif
		_rtw_memcpy(bssid->SupportedRates, (p + 2), len);
		i = len;
	}

	p = rtw_get_ie(bssid->IEs + ie_offset, _EXT_SUPPORTEDRATES_IE_, &len, bssid->IELength - ie_offset);
	if (p != NULL) {
		if (len > (NDIS_802_11_LENGTH_RATES_EX - i)) {
			RTW_INFO("%s()-%d: IE too long (%d) for survey event\n", __FUNCTION__, __LINE__, len);
			return _FAIL;
		}
#ifndef RTW_PHL_TEST_FPGA
		if (rtw_validate_value(_EXT_SUPPORTEDRATES_IE_, p+2, len) == _FALSE) {
			rtw_absorb_ssid_ifneed(padapter, bssid, pframe);
			RTW_DBG_DUMP("Invalidated EXT Support Rate IE --", p, len+2);
			//return _FAIL;
		}
		else
#endif
		_rtw_memcpy(bssid->SupportedRates + i, (p + 2), len);
	}

#ifdef CONFIG_P2P
	if (subtype == WIFI_PROBEREQ) {
		u8 *p2p_ie;
		u32	p2p_ielen;
		/* Set Listion Channel */
		p2p_ie = rtw_get_p2p_ie(bssid->IEs, bssid->IELength, NULL, &p2p_ielen);
		if (p2p_ie) {
			u32	attr_contentlen = 0;
			u8 listen_ch[5] = { 0x00 };

			attr_contentlen = sizeof(listen_ch);
			rtw_get_p2p_attr_content(p2p_ie, p2p_ielen, P2P_ATTR_LISTEN_CH, listen_ch, &attr_contentlen);
			bssid->Configuration.DSConfig = listen_ch[4];
		} else {
			/* use current channel */
			bssid->Configuration.DSConfig = padapter->mlmeextpriv.cur_channel;
			RTW_INFO("%s()-%d: Cannot get p2p_ie. set DSconfig to op_ch(%d)\n", __FUNCTION__, __LINE__, bssid->Configuration.DSConfig);
		}

		/* FIXME */
		bssid->InfrastructureMode = Ndis802_11Infrastructure;
		_rtw_memcpy(bssid->MacAddress, get_addr2_ptr(pframe), ETH_ALEN);
		bssid->Privacy = 1;
		return _SUCCESS;
	}
#endif /* CONFIG_P2P */

	if (bssid->IELength < 12)
		return _FAIL;

	/* Checking for DSConfig */
	p = rtw_get_ie(bssid->IEs + ie_offset, _DSSET_IE_, &len, bssid->IELength - ie_offset);

	bssid->Configuration.DSConfig = 0;
	bssid->Configuration.Length = 0;

	if (p)
		bssid->Configuration.DSConfig = *(p + 2);

	if(bssid->Configuration.DSConfig == 0)
	{
		/* In 5G, some ap do not have DSSET IE */
		/* In 5G, some ap DSConfig is zero in DSSET IE*/
		/* checking HT info for channel */
		p = rtw_get_ie(bssid->IEs + ie_offset, _HT_ADD_INFO_IE_, &len, bssid->IELength - ie_offset);
		if (p) {
			struct HT_info_element *HT_info = (struct HT_info_element *)(p + 2);
			bssid->Configuration.DSConfig = HT_info->primary_channel;
		} else {
			/* use current channel */
			bssid->Configuration.DSConfig = rtw_get_oper_ch(padapter);
		}
	}

	//TIM
	p = rtw_get_ie(bssid->IEs + ie_offset, _TIM_IE_, &len, bssid->IELength - ie_offset);
	if(p && len == 4)
	{
		bssid->dtim_prd = *(p + 2 + 1);
	}

	_rtw_memcpy(&bssid->Configuration.BeaconPeriod, rtw_get_beacon_interval_from_ie(bssid->IEs), 2);
	bssid->Configuration.BeaconPeriod = le32_to_cpu(bssid->Configuration.BeaconPeriod);

	val16 = rtw_get_capability((WLAN_BSSID_EX *)bssid);

	if ((val16 & 0x03) == cap_ESS) {
		bssid->InfrastructureMode = Ndis802_11Infrastructure;
		_rtw_memcpy(bssid->MacAddress, get_addr2_ptr(pframe), ETH_ALEN);
	} else if ((val16 & 0x03) == cap_IBSS){
		bssid->InfrastructureMode = Ndis802_11IBSS;
		_rtw_memcpy(bssid->MacAddress, GetAddr3Ptr(pframe), ETH_ALEN);
	} else if ((val16 & 0x03) == 0x00){
		u8 *mesh_id_ie, *mesh_conf_ie;
		sint mesh_id_ie_len, mesh_conf_ie_len;

		mesh_id_ie = rtw_get_ie(bssid->IEs + ie_offset, WLAN_EID_MESH_ID, &mesh_id_ie_len, bssid->IELength - ie_offset);
		mesh_conf_ie = rtw_get_ie(bssid->IEs + ie_offset, WLAN_EID_MESH_CONFIG, &mesh_conf_ie_len, bssid->IELength - ie_offset);
		if (mesh_id_ie || mesh_conf_ie) {
			if (!mesh_id_ie) {
				RTW_INFO("cannot find Mesh ID for survey event\n");
				return _FAIL;
			}
			if (mesh_id_ie_len) {
				if (mesh_id_ie_len > NDIS_802_11_LENGTH_SSID) {
					RTW_INFO("Mesh ID too long (%d) for survey event\n", mesh_id_ie_len);
					return _FAIL;
				}
				_rtw_memcpy(bssid->mesh_id.Ssid, (mesh_id_ie + 2), mesh_id_ie_len);
				bssid->mesh_id.SsidLength = mesh_id_ie_len;
			} else
				bssid->mesh_id.SsidLength = 0;

			if (!mesh_conf_ie) {
				RTW_INFO("cannot find Mesh config for survey event\n");
				return _FAIL;
			}
			if (mesh_conf_ie_len != 7) {
				RTW_INFO("invalid Mesh conf IE len (%d) for survey event\n", mesh_conf_ie_len);
				return _FAIL;
			}

			bssid->InfrastructureMode = Ndis802_11_mesh;
			_rtw_memcpy(bssid->MacAddress, GetAddr3Ptr(pframe), ETH_ALEN);
		} else {
			/* default cases */
			bssid->InfrastructureMode = Ndis802_11IBSS;
			_rtw_memcpy(bssid->MacAddress, GetAddr3Ptr(pframe), ETH_ALEN);
		}
	}

	if (val16 & BIT(4))
		bssid->Privacy = 1;
	else
		bssid->Privacy = 0;

	bssid->Configuration.ATIMWindow = 0;

	/* 20/40 BSS Coexistence check */
	if ((pregistrypriv->wifi_spec == 1) && (_FALSE == pmlmeinfo->bwmode_updated)) {
		struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
#ifdef CONFIG_80211N_HT
		p = rtw_get_ie(bssid->IEs + ie_offset, _HT_CAPABILITY_IE_, &len, bssid->IELength - ie_offset);
		if (p && len > 0) {
			struct HT_caps_element	*pHT_caps;
			pHT_caps = (struct HT_caps_element *)(p + 2);

			if (pHT_caps->u.HT_cap_element.HT_caps_info & cpu_to_le16(BIT14))
				pmlmepriv->num_FortyMHzIntolerant++;
		} else
			pmlmepriv->num_sta_no_ht++;
#endif /* CONFIG_80211N_HT */

	}

#if defined(DBG_RX_SIGNAL_DISPLAY_SSID_MONITORED) & 1
	if (strcmp(bssid->Ssid.Ssid, DBG_RX_SIGNAL_DISPLAY_SSID_MONITORED) == 0) {
		RTW_INFO("Receiving %s("MAC_FMT", DSConfig:%u) from ch%u with ss:%3u, sq:%3u, RawRSSI:%3ld\n"
			, bssid->Ssid.Ssid, MAC_ARG(bssid->MacAddress), bssid->Configuration.DSConfig
			 , rtw_get_oper_ch(padapter)
			, bssid->PhyInfo.SignalStrength, bssid->PhyInfo.SignalQuality, bssid->Rssi
			);
	}
#endif

	/* mark bss info receving from nearby channel as SignalQuality 101 */
	if (bssid->Configuration.DSConfig != rtw_get_oper_ch(padapter))
		bssid->PhyInfo.SignalQuality = 101;

#ifdef CONFIG_RTW_80211K
	p = rtw_get_ie(bssid->IEs + ie_offset, _EID_RRM_EN_CAP_IE_, &len, bssid->IELength - ie_offset);
	if (p)
		_rtw_memcpy(bssid->PhyInfo.rm_en_cap, (p + 2), MIN(*(p + 1),
			sizeof(bssid->PhyInfo.rm_en_cap)));

	/* save freerun counter */
	bssid->PhyInfo.free_cnt = precv_frame->u.hdr.attrib.free_cnt;
#endif

	/* Checking for bw/offset */
	p = rtw_get_ie(bssid->IEs + ie_offset, _HT_ADD_INFO_IE_, &len, bssid->IELength - ie_offset);

	if (p && len == HT_OP_IE_LEN) {
		if (GET_HT_OP_ELE_STA_CHL_WIDTH(p + 2)) {
			switch (GET_HT_OP_ELE_2ND_CHL_OFFSET(p + 2)) {
			case IEEE80211_SCA:
				oper_bw = CHANNEL_WIDTH_40;
				oper_offset = CHAN_OFFSET_UPPER;
				break;
			case IEEE80211_SCB:
				oper_bw = CHANNEL_WIDTH_40;
				oper_offset = CHAN_OFFSET_LOWER;
				break;
			default:
				break;
			}
		}
	}

	if (oper_bw == CHANNEL_WIDTH_40) {
		u8 c_freq1 = 0, c_freq2 = 0, c_freq_gap = 0;
		p = rtw_get_ie(bssid->IEs + ie_offset, EID_VHTOperation, &len, bssid->IELength - ie_offset);

		if (p && len == VHT_OP_IE_LEN) {
			switch (GET_VHT_OPERATION_ELE_CHL_WIDTH(p + 2)) {
			case 0: /* 20/40 MHz */
				break;
			case 1: /* 80/160/80+80 MHz */
				c_freq1 = GET_VHT_OPERATION_ELE_CENTER_FREQ1(p + 2);
				c_freq2 = GET_VHT_OPERATION_ELE_CENTER_FREQ2(p + 2);
				c_freq_gap = (c_freq2 - c_freq1);

				if(c_freq2 == 0) {
					oper_bw = CHANNEL_WIDTH_80;
				} else {
					if (c_freq_gap == 8)
						oper_bw = CHANNEL_WIDTH_160;
					else if (c_freq_gap > 16)
						oper_bw = CHANNEL_WIDTH_80_80;
					else {
						RTW_ERR("Center Freq out of spec, set oper bw 160M. (freq1=%d, freq2=%d)", c_freq1, c_freq2);
						oper_bw = CHANNEL_WIDTH_160;
					}
				}
				break;
			case 2: /* 160MHz (deprecated)*/
				oper_bw = CHANNEL_WIDTH_160;
				break;
			case 3: /* 80+80 (deprecated)*/
				oper_bw = CHANNEL_WIDTH_80_80;
				break;
			default:
				break;
			}
		}
	}

	bssid->Configuration.Bw = oper_bw;
	bssid->Configuration.Offset = oper_offset;

	return _SUCCESS;
}

void start_create_ibss(_adapter *padapter)
{
	unsigned short	caps;
	u8	val8;
	u8	join_type;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX		*pnetwork = (WLAN_BSSID_EX *)(&(pmlmeinfo->network));
	u8 do_rfk = _FALSE;
	pmlmeext->cur_channel = (u8)pnetwork->Configuration.DSConfig;
	pmlmeinfo->bcn_interval = get_beacon_interval(pnetwork);

	/* update wireless mode */
	update_wireless_mode(padapter);

	/* udpate capability */
	caps = rtw_get_capability((WLAN_BSSID_EX *)pnetwork);
	update_capinfo(padapter, caps);
	if (caps & cap_IBSS) { /* adhoc master */
		/* set_opmode_cmd(padapter, adhoc); */ /* removed */

		rtw_hal_set_hwreg(padapter, HW_VAR_SEC_CFG, NULL);

		do_rfk = _TRUE;
		/* switch channel */
		set_channel_bwmode(padapter,
				pmlmeext->cur_channel,
				CHAN_OFFSET_NO_EXT,
				CHANNEL_WIDTH_20,
				do_rfk);

		beacon_timing_control(padapter);

		/* set msr to WIFI_FW_ADHOC_STATE */
		pmlmeinfo->state = WIFI_FW_ADHOC_STATE;
		rtw_hal_set_network_type(padapter, (pmlmeinfo->state & 0x3));

		/* issue beacon */
		if (send_beacon(padapter) == _FAIL) {

			report_join_res(padapter, -1, WLAN_STATUS_UNSPECIFIED_FAILURE);
			pmlmeinfo->state = WIFI_FW_NULL_STATE;
		} else {
			rtw_hal_set_hwreg(padapter, HW_VAR_BSSID, padapter->registrypriv.dev_network.MacAddress);
			rtw_hal_rcr_set_chk_bssid(padapter, MLME_ADHOC_STARTED);
			join_type = 0;
			rtw_hal_set_hwreg(padapter, HW_VAR_MLME_JOIN, (u8 *)(&join_type));

			report_join_res(padapter, 1, WLAN_STATUS_SUCCESS);
			pmlmeinfo->state |= WIFI_FW_ASSOC_SUCCESS;
			rtw_indicate_connect(padapter);
		}
	} else {
		RTW_INFO("start_create_ibss, invalid cap:%x\n", caps);
		return;
	}
	/* update bc/mc sta_info */
	update_bmc_sta(padapter);

}

void start_clnt_join(_adapter *padapter)
{
	unsigned short	caps;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX		*pnetwork = (WLAN_BSSID_EX *)(&(pmlmeinfo->network));
	int beacon_timeout;
	u8 ASIX_ID[] = {0x00, 0x0E, 0xC6};

	/* update wireless mode */
	update_wireless_mode(padapter);

	/* udpate capability */
	caps = rtw_get_capability((WLAN_BSSID_EX *)pnetwork);
	update_capinfo(padapter, caps);

	/* check if sta is ASIX peer and fix IOT issue if it is. */
	/*GEORGIA_TODO_FIXIT_HAL_DEP*/
	if (_rtw_memcmp(get_my_bssid(&pmlmeinfo->network) , ASIX_ID , 3)) {
		u8 iot_flag = _TRUE;
		rtw_hal_set_hwreg(padapter, HW_VAR_ASIX_IOT, (u8 *)(&iot_flag));
	}

	if (caps & cap_ESS) {
		rtw_hal_set_network_type(padapter, WIFI_FW_STATION_STATE);
		rtw_hal_set_hwreg(padapter, HW_VAR_SEC_CFG, NULL);

#ifdef CONFIG_DEAUTH_BEFORE_CONNECT
		/* Because of AP's not receiving deauth before */
		/* AP may: 1)not response auth or 2)deauth us after link is complete */
		/* issue deauth before issuing auth to deal with the situation */

		/*	Commented by Albert 2012/07/21 */
		/*	For the Win8 P2P connection, it will be hard to have a successful connection if this Wi-Fi doesn't connect to it. */
		{
#ifdef CONFIG_P2P
		#ifdef RTW_MI_SHARE_BSS_LIST
			_queue *queue = &padapter->dvobj->scanned_queue;
		#else
			_queue *queue = &(padapter->mlmepriv.scanned_queue);
		#endif
			_list	*head = get_list_head(queue);
			_list *pos = get_next(head);
			struct wlan_network *scanned = NULL;
			u8 ie_offset = 0;
			bool has_p2p_ie = _FALSE;

			_rtw_spinlock_bh(&(queue->lock));

			for (pos = get_next(head); !rtw_end_of_queue_search(head, pos); pos = get_next(pos)) {

				scanned = LIST_CONTAINOR(pos, struct wlan_network, list);

				if (_rtw_memcmp(&(scanned->network.Ssid), &(pnetwork->Ssid), sizeof(NDIS_802_11_SSID)) == _TRUE
				    && _rtw_memcmp(scanned->network.MacAddress, pnetwork->MacAddress, sizeof(NDIS_802_11_MAC_ADDRESS)) == _TRUE
				   ) {
					ie_offset = (scanned->network.Reserved[0] == BSS_TYPE_PROB_REQ ? 0 : 12);
					if (rtw_get_p2p_ie(scanned->network.IEs + ie_offset, scanned->network.IELength - ie_offset, NULL, NULL))
						has_p2p_ie = _TRUE;
					break;
				}
			}

			_rtw_spinunlock_bh(&(queue->lock));

			if (scanned == NULL || rtw_end_of_queue_search(head, pos) || has_p2p_ie == _FALSE)
#endif /* CONFIG_P2P */
				/* To avoid connecting to AP fail during resume process, change retry count from 5 to 1 */
				issue_deauth_ex(padapter, pnetwork->MacAddress, WLAN_REASON_DEAUTH_LEAVING, 1, 100);
		}
#endif /* CONFIG_DEAUTH_BEFORE_CONNECT */

		/* here wait for receiving the beacon to start auth */
		/* and enable a timer */
		beacon_timeout = decide_wait_for_beacon_timeout(pmlmeinfo->bcn_interval);
		set_link_timer(pmlmeext, beacon_timeout);
		_set_timer(&padapter->mlmepriv.assoc_timer,
			(REAUTH_TO * REAUTH_LIMIT) + (REASSOC_TO * REASSOC_LIMIT) + beacon_timeout);

#ifdef CONFIG_RTW_80211R
		if (rtw_ft_roam(padapter)) {
			rtw_ft_start_clnt_join(padapter);
		} else
#endif
		{
			rtw_sta_linking_test_set_start();
			pmlmeinfo->state = WIFI_FW_AUTH_NULL | WIFI_FW_STATION_STATE;
		}

#ifdef CONFIG_DRV_FAKE_AP
		_set_timer(&adapter_to_dvobj(padapter)->fakeap.bcn_timer, 5);
#endif /* CONFIG_DRV_FAKE_AP */
	} else if (caps & cap_IBSS) { /* adhoc client */
		rtw_hal_set_network_type(padapter, WIFI_FW_ADHOC_STATE);

		rtw_hal_set_hwreg(padapter, HW_VAR_SEC_CFG, NULL);

		beacon_timing_control(padapter);

		pmlmeinfo->state = WIFI_FW_ADHOC_STATE;

		report_join_res(padapter, 1, WLAN_STATUS_SUCCESS);
	} else {
		/* RTW_INFO("marc: invalid cap:%x\n", caps); */
		return;
	}

}

void start_clnt_auth(_adapter *padapter)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	_cancel_timer_ex(&pmlmeext->link_timer);

	pmlmeinfo->state &= (~WIFI_FW_AUTH_NULL);
	pmlmeinfo->state |= WIFI_FW_AUTH_STATE;

	pmlmeinfo->auth_seq = 1;
	pmlmeinfo->reauth_count = 0;
	pmlmeinfo->reassoc_count = 0;
	pmlmeinfo->link_count = 0;
	pmlmeext->retry = 0;

#ifdef CONFIG_RTW_80211R
	if (rtw_ft_roam(padapter)) {
		rtw_ft_set_status(padapter, RTW_FT_AUTHENTICATING_STA);
		RTW_PRINT("start ft auth\n");
	} else
#endif
		RTW_PRINT("start auth\n");

#ifdef CONFIG_IOCTL_CFG80211
	if (rtw_sec_chk_auth_type(padapter, MLME_AUTHTYPE_SAE)) {
		if (rtw_cached_pmkid(padapter, get_my_bssid(&pmlmeinfo->network)) != -1) {
			RTW_INFO("SAE: PMKSA cache entry found\n");
			padapter->securitypriv.auth_alg = WLAN_AUTH_OPEN;
			goto no_external_auth;
		}

		RTW_PRINT("SAE: start external auth\n");
		rtw_cfg80211_external_auth_request(padapter, NULL);
		return;
	}
no_external_auth:
#endif /* CONFIG_IOCTL_CFG80211 */

	issue_auth(padapter, NULL, 0);

	set_link_timer(pmlmeext, REAUTH_TO);

}


void start_clnt_assoc(_adapter *padapter)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	_cancel_timer_ex(&pmlmeext->link_timer);

	pmlmeinfo->state &= (~(WIFI_FW_AUTH_NULL | WIFI_FW_AUTH_STATE));
	pmlmeinfo->state |= (WIFI_FW_AUTH_SUCCESS | WIFI_FW_ASSOC_STATE);

#ifdef CONFIG_RTW_80211R
	if (rtw_ft_roam(padapter))
		issue_reassocreq(padapter);
	else
#endif
		issue_assocreq(padapter);

	set_link_timer(pmlmeext, REASSOC_TO);
}

unsigned int receive_disconnect(_adapter *padapter, unsigned char *MacAddr, unsigned short reason, u8 locally_generated)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	if (!(_rtw_memcmp(MacAddr, get_my_bssid(&pmlmeinfo->network), ETH_ALEN)))
		return _SUCCESS;

	RTW_INFO("%s\n", __FUNCTION__);

	if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_STATION_STATE)) {
		if (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS) {
			if (report_del_sta_event(padapter, MacAddr, reason, _TRUE, locally_generated) != _FAIL)
				pmlmeinfo->state = WIFI_FW_NULL_STATE;
		} else if (pmlmeinfo->state & WIFI_FW_LINKING_STATE) {
			if (report_join_res(padapter, -2, reason) != _FAIL)
				pmlmeinfo->state = WIFI_FW_NULL_STATE;
		} else
			RTW_INFO(FUNC_ADPT_FMT" - End to Disconnect\n", FUNC_ADPT_ARG(padapter));
#ifdef CONFIG_RTW_80211R
		rtw_ft_roam_status_reset(padapter);
#endif
#ifdef CONFIG_RTW_WNM
		rtw_wnm_reset_btm_state(padapter);
#endif
	}

	return _SUCCESS;
}
/*
 * Return channel index of struct dvobj_priv.rf_ctl.channel_set[] ==
 * bss->Configuration.DSConfig, or -1 if not found.
 */
static int rtw_hidden_ssid_bss_count(_adapter *adapter, WLAN_BSSID_EX *bss)
{
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);
	RT_CHANNEL_INFO *chset = rfctl->channel_set;
	int chset_idx;

	if (bss->InfrastructureMode != Ndis802_11Infrastructure)
		return -1;

	if (!hidden_ssid_ap(bss))
		return -1;

	chset_idx = rtw_chset_search_ch(chset, bss->Configuration.DSConfig);
	if (chset_idx < 0)
		return chset_idx;

	chset[chset_idx].hidden_bss_cnt++;
	return chset_idx;
}

/****************************************************************************

Following are the functions to report events

*****************************************************************************/

void report_survey_event(_adapter *padapter, union recv_frame *precv_frame)
{
	struct cmd_obj *pcmd_obj;
	u8 *pevtcmd;
	u32 cmdsz;
	struct survey_event *psurvey_evt;
	struct rtw_evt_header *evt_hdr;
	struct mlme_ext_priv *pmlmeext;
	struct cmd_priv *pcmdpriv;
	/* u8 *pframe = precv_frame->u.hdr.rx_data; */
	/* uint len = precv_frame->u.hdr.len; */
#ifdef RTW_WKARD_CMD_SCAN_EXTEND_ACTIVE_SCAN
	RT_CHANNEL_INFO *chset;
	int ch_set_idx = -1;
#endif /* RTW_WKARD_CMD_SCAN_EXTEND_ACTIVE_SCAN */

	if (!padapter)
		return;

	pmlmeext = &padapter->mlmeextpriv;
	pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;
	chset = adapter_to_chset(padapter);


	pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (pcmd_obj == NULL)
		return;
	pcmd_obj->padapter = padapter;

	cmdsz = (sizeof(struct survey_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		return;
	}

	_rtw_init_listhead(&pcmd_obj->list);

	pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
	pcmd_obj->cmdsz = cmdsz;
	pcmd_obj->parmbuf = pevtcmd;

	pcmd_obj->rsp = NULL;
	pcmd_obj->rspsz  = 0;

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct survey_event);
	evt_hdr->id = EVT_SURVEY;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	psurvey_evt = (struct survey_event *)(pevtcmd + sizeof(struct rtw_evt_header));

	if (collect_bss_info(padapter, precv_frame, (WLAN_BSSID_EX *)&psurvey_evt->bss) == _FAIL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		rtw_mfree((u8 *)pevtcmd, cmdsz);
		return;
	}

#ifdef RTW_WKARD_CMD_SCAN_EXTEND_ACTIVE_SCAN
	ch_set_idx = rtw_hidden_ssid_bss_count(padapter, &psurvey_evt->bss);

	chset = adapter_to_chset(padapter);
	if ((ch_set_idx >= 0) && (chset[ch_set_idx].hidden_bss_cnt == 1)
		&& pmlmeext->sitesurvey_res.scan_param) {
		struct rtw_phl_scan_param *phl_scan;
		struct phl_module_op_info op_info = {0};
		u8 ch;
		int i;

		phl_scan = pmlmeext->sitesurvey_res.scan_param;
		ch = chset[ch_set_idx].ChannelNum;
		for (i = 0; i < phl_scan->ch_num; i++) {
			if (phl_scan->ch[i].channel != ch)
				continue;
			if (phl_scan->ch[i].type != RTW_PHL_SCAN_PASSIVE)
				break;

			phl_scan->ch[i].ext_act_scan = EXT_ACT_SCAN_ENABLE;
			if (phl_scan->scan_ch)
				phl_scan->scan_ch->ext_act_scan = EXT_ACT_SCAN_ENABLE;
			op_info.op_code = FG_REQ_OP_NOTIFY_BCN_RCV;
			op_info.inbuf = &ch;
			op_info.inlen = 1;
			rtw_phl_set_cur_cmd_info(adapter_to_dvobj(padapter)->phl,
						 padapter->phl_role->hw_band,
						 &op_info);
			break;
		}
	}
#else /* !RTW_WKARD_CMD_SCAN_EXTEND_ACTIVE_SCAN */
		rtw_hidden_ssid_bss_count(padapter, &psurvey_evt->bss);
#endif /* !RTW_WKARD_CMD_SCAN_EXTEND_ACTIVE_SCAN */


#if defined(RTW_WKARD_AP_CMD_DISPATCH) || defined(RTW_SURVEY_EVENT_REFINE)
	rtw_survey_event_callback(padapter, (u8 *)&psurvey_evt->bss);
	rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
	rtw_mfree((u8 *)pevtcmd, cmdsz);
#else
	rtw_enqueue_cmd(pcmdpriv, pcmd_obj);
#endif

	pmlmeext->sitesurvey_res.bss_cnt++;

	return;

}

/*
* @acs: aim to trigger channel selection
*/
void report_surveydone_event(_adapter *padapter, bool acs, u8 flags)
{
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;

	if (flags & RTW_CMDF_DIRECTLY) {
		struct surveydone_event survey_done;

		survey_done.bss_cnt = pmlmeext->sitesurvey_res.bss_cnt;
		survey_done.activate_ch_cnt = pmlmeext->sitesurvey_res.activate_ch_cnt;
		survey_done.acs = acs;
		RTW_INFO("survey done event(%x) band:%d for "ADPT_FMT"\n",
			survey_done.bss_cnt, padapter->setband, ADPT_ARG(padapter));
		rtw_surveydone_event_callback(padapter, (u8 *)&survey_done);
	} else {

		struct cmd_obj *pcmd_obj;
		u8 *pevtcmd;
		u32 cmdsz;
		struct surveydone_event *psurveydone_evt;
		struct rtw_evt_header *evt_hdr;

		struct cmd_priv *pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;

		pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
		if (pcmd_obj == NULL)
			return;
		pcmd_obj->padapter = padapter;

		cmdsz = (sizeof(struct surveydone_event) + sizeof(struct rtw_evt_header));
		pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
		if (pevtcmd == NULL) {
			rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
			return;
		}

		_rtw_init_listhead(&pcmd_obj->list);

		pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
		pcmd_obj->cmdsz = cmdsz;
		pcmd_obj->parmbuf = pevtcmd;

		pcmd_obj->rsp = NULL;
		pcmd_obj->rspsz  = 0;

		evt_hdr = (struct rtw_evt_header *)(pevtcmd);
		evt_hdr->len = sizeof(struct surveydone_event);
		evt_hdr->id = EVT_SURVEY_DONE;
		evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

		psurveydone_evt = (struct surveydone_event *)(pevtcmd + sizeof(struct rtw_evt_header));
		psurveydone_evt->bss_cnt = pmlmeext->sitesurvey_res.bss_cnt;
		psurveydone_evt->activate_ch_cnt = pmlmeext->sitesurvey_res.activate_ch_cnt;
		psurveydone_evt->acs = acs;

		RTW_INFO("survey done event(%x) band:%d for "ADPT_FMT"\n",
			psurveydone_evt->bss_cnt, padapter->setband, ADPT_ARG(padapter));

		rtw_enqueue_cmd(pcmdpriv, pcmd_obj);
	}

	return;
}

u32 report_join_res(_adapter *padapter, int aid_res, u16 status)
{
	struct cmd_obj *pcmd_obj;
	u8	*pevtcmd;
	u32 cmdsz;
	struct joinbss_event *pjoinbss_evt;
	struct rtw_evt_header *evt_hdr;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct cmd_priv *pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;
	u32 ret = _FAIL;

	pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (pcmd_obj == NULL)
		goto exit;
	pcmd_obj->padapter = padapter;

	cmdsz = (sizeof(struct joinbss_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		goto exit;
	}

	_rtw_init_listhead(&pcmd_obj->list);

	pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
	pcmd_obj->cmdsz = cmdsz;
	pcmd_obj->parmbuf = pevtcmd;

	pcmd_obj->rsp = NULL;
	pcmd_obj->rspsz  = 0;

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct joinbss_event);
	evt_hdr->id = EVT_JOINBSS;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	pjoinbss_evt = (struct joinbss_event *)(pevtcmd + sizeof(struct rtw_evt_header));
	_rtw_memcpy((unsigned char *)(&(pjoinbss_evt->network.network)), &(pmlmeinfo->network), sizeof(WLAN_BSSID_EX));
	pjoinbss_evt->network.join_res = pjoinbss_evt->network.aid = aid_res;

	RTW_INFO("report_join_res(%d, %u)\n", aid_res, status);


	rtw_joinbss_event_prehandle(padapter, (u8 *)&pjoinbss_evt->network, status);


	ret = rtw_enqueue_cmd(pcmdpriv, pcmd_obj);

exit:
	return ret;
}

void report_wmm_edca_update(_adapter *padapter)
{
	struct cmd_obj *pcmd_obj;
	u8 *pevtcmd;
	u32 cmdsz;
	struct wmm_event *pwmm_event;
	struct rtw_evt_header *evt_hdr;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct cmd_priv *pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;

	pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (pcmd_obj == NULL)
		return;
	pcmd_obj->padapter = padapter;

	cmdsz = (sizeof(struct wmm_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		return;
	}

	_rtw_init_listhead(&pcmd_obj->list);

	pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
	pcmd_obj->cmdsz = cmdsz;
	pcmd_obj->parmbuf = pevtcmd;

	pcmd_obj->rsp = NULL;
	pcmd_obj->rspsz  = 0;

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct wmm_event);
	evt_hdr->id = EVT_WMM_UPDATE;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	pwmm_event = (struct wmm_event *)(pevtcmd + sizeof(struct rtw_evt_header));
	pwmm_event->wmm = 0;

	rtw_enqueue_cmd(pcmdpriv, pcmd_obj);

	return;

}

u32 report_del_sta_event(_adapter *padapter, unsigned char *MacAddr, unsigned short reason, bool enqueue, u8 locally_generated)
{
	struct cmd_obj *pcmd_obj;
	u8 *pevtcmd;
	u32 cmdsz;
	struct sta_info *psta;
	int mac_id = -1;
	struct stadel_event *pdel_sta_evt;
	struct rtw_evt_header *evt_hdr;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct cmd_priv *pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;
	u8 res = _SUCCESS;

	/* prepare cmd parameter */
	cmdsz = (sizeof(struct stadel_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		res = _FAIL;
		goto exit;
	}

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct stadel_event);
	evt_hdr->id = EVT_DEL_STA;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	pdel_sta_evt = (struct stadel_event *)(pevtcmd + sizeof(struct rtw_evt_header));
	_rtw_memcpy((unsigned char *)(&(pdel_sta_evt->macaddr)), MacAddr, ETH_ALEN);
	_rtw_memcpy((unsigned char *)(pdel_sta_evt->rsvd), (unsigned char *)(&reason), 2);
	psta = rtw_get_stainfo(&padapter->stapriv, MacAddr);
	if (psta && psta->phl_sta)
		mac_id = (int)psta->phl_sta->macid;
	else
		mac_id = (-1);
	pdel_sta_evt->mac_id = mac_id;
	pdel_sta_evt->locally_generated = locally_generated;

	if (!enqueue) {
		/* do directly */
		rtw_stadel_event_callback(padapter, (u8 *)pdel_sta_evt);
		rtw_mfree(pevtcmd, cmdsz);
	} else {
		pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
		if (pcmd_obj == NULL) {
			rtw_mfree(pevtcmd, cmdsz);
			res = _FAIL;
			goto exit;
		}
		pcmd_obj->padapter = padapter;

		_rtw_init_listhead(&pcmd_obj->list);
		pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
		pcmd_obj->cmdsz = cmdsz;
		pcmd_obj->parmbuf = pevtcmd;

		pcmd_obj->rsp = NULL;
		pcmd_obj->rspsz  = 0;

		res = rtw_enqueue_cmd(pcmdpriv, pcmd_obj);
	}

exit:

	RTW_INFO(FUNC_ADPT_FMT" "MAC_FMT" mac_id=%d, enqueue:%d, res:%u\n"
		, FUNC_ADPT_ARG(padapter), MAC_ARG(MacAddr), mac_id, enqueue, res);

	return res;
}

void report_add_sta_event(_adapter *padapter, unsigned char *MacAddr)
{
	struct cmd_obj *pcmd_obj;
	u8 *pevtcmd;
	u32 cmdsz;
	struct stassoc_event *padd_sta_evt;
	struct rtw_evt_header *evt_hdr;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct cmd_priv *pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;

	pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (pcmd_obj == NULL)
		return;
	pcmd_obj->padapter = padapter;

	cmdsz = (sizeof(struct stassoc_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		return;
	}

	_rtw_init_listhead(&pcmd_obj->list);

	pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
	pcmd_obj->cmdsz = cmdsz;
	pcmd_obj->parmbuf = pevtcmd;

	pcmd_obj->rsp = NULL;
	pcmd_obj->rspsz  = 0;

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct stassoc_event);
	evt_hdr->id = EVT_ADD_STA;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	padd_sta_evt = (struct stassoc_event *)(pevtcmd + sizeof(struct rtw_evt_header));
	_rtw_memcpy((unsigned char *)(&(padd_sta_evt->macaddr)), MacAddr, ETH_ALEN);

	RTW_INFO("report_add_sta_event: add STA\n");

	rtw_enqueue_cmd(pcmdpriv, pcmd_obj);

	return;
}

/****************************************************************************

Following are the event callback functions

*****************************************************************************/

/* for sta/adhoc mode */
void update_sta_info(_adapter *padapter, struct sta_info *psta)
{
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	/* ERP */
	VCS_update(padapter, psta);

#ifdef CONFIG_80211N_HT
	/* HT */
	if (pmlmepriv->htpriv.ht_option) {
		psta->htpriv.ht_option = _TRUE;

		psta->htpriv.ampdu_enable = pmlmepriv->htpriv.ampdu_enable;

		psta->htpriv.rx_ampdu_min_spacing = (pmlmeinfo->HT_caps.u.HT_cap_element.AMPDU_para & IEEE80211_HT_CAP_AMPDU_DENSITY) >> 2;

		if (support_short_GI(padapter, &(pmlmeinfo->HT_caps), CHANNEL_WIDTH_20))
			psta->htpriv.sgi_20m = _TRUE;

		if (support_short_GI(padapter, &(pmlmeinfo->HT_caps), CHANNEL_WIDTH_40))
			psta->htpriv.sgi_40m = _TRUE;

		psta->qos_option = _TRUE;

		psta->htpriv.ldpc_cap = pmlmepriv->htpriv.ldpc_cap;
		psta->htpriv.stbc_cap = pmlmepriv->htpriv.stbc_cap;
		psta->htpriv.beamform_cap = pmlmepriv->htpriv.beamform_cap;

		_rtw_memcpy(&psta->htpriv.ht_cap, &pmlmeinfo->HT_caps, sizeof(struct rtw_ieee80211_ht_cap));
		#ifdef CONFIG_BEAMFORMING
		psta->htpriv.beamform_cap = pmlmepriv->htpriv.beamform_cap;
		psta->phl_sta->bf_info.ht_beamform_cap = pmlmepriv->htpriv.beamform_cap;
		#endif
	} else
#endif /* CONFIG_80211N_HT */
	{
#ifdef CONFIG_80211N_HT
		psta->htpriv.ht_option = _FALSE;
		psta->htpriv.ampdu_enable = _FALSE;
		psta->htpriv.tx_amsdu_enable = _FALSE;
		psta->htpriv.sgi_20m = _FALSE;
		psta->htpriv.sgi_40m = _FALSE;
#endif /* CONFIG_80211N_HT */
		psta->qos_option = _FALSE;

	}

#ifdef CONFIG_80211N_HT
	psta->htpriv.ch_offset = pmlmeext->cur_ch_offset;

	psta->htpriv.agg_enable_bitmap = 0x0;/* reset */
	psta->htpriv.candidate_tid_bitmap = 0x0;/* reset */
#endif /* CONFIG_80211N_HT */

	psta->phl_sta->chandef.bw = pmlmeext->cur_bwmode;

	/* QoS */
	if (pmlmepriv->qospriv.qos_option)
		psta->qos_option = _TRUE;

#ifdef CONFIG_80211AC_VHT
	_rtw_memcpy(&psta->vhtpriv, &pmlmepriv->vhtpriv, sizeof(struct vht_priv));
	if (psta->vhtpriv.vht_option) {
		/* ToDo: need to API to inform hal_sta->ra_info.is_vht_enable  */
		/* psta->phl_sta->ra_info.is_vht_enable = _TRUE; */
		#ifdef CONFIG_BEAMFORMING
		psta->vhtpriv.beamform_cap = pmlmepriv->vhtpriv.beamform_cap;
		psta->phl_sta->bf_info.vht_beamform_cap = pmlmepriv->vhtpriv.beamform_cap;
		#endif /*CONFIG_BEAMFORMING*/
	}
#endif /* CONFIG_80211AC_VHT */

#ifdef CONFIG_80211AX_HE
	_rtw_memcpy(&psta->hepriv, &pmlmepriv->hepriv, sizeof(struct he_priv));
#endif /* CONFIG_80211AX_HE */

	/* ToDo: need to API to inform hal_sta->ra_info.is_support_sgi  */
	/* psta->phl_sta->ra_info.is_support_sgi = query_ra_short_GI(psta, rtw_get_tx_bw_mode(padapter, psta)); */
	update_ldpc_stbc_cap(psta);

	_rtw_spinlock_bh(&psta->lock);
	psta->state = WIFI_ASOC_STATE;
	_rtw_spinunlock_bh(&psta->lock);

}

void update_sta_wset(_adapter *adapter, struct sta_info *psta)
{
#if 0
	u8 w_set = 0;

	if (psta->wireless_mode & WIRELESS_11B)
		w_set |= WIRELESS_CCK;

	if ((psta->wireless_mode & WIRELESS_11G) || (psta->wireless_mode & WIRELESS_11A))
		w_set |= WIRELESS_OFDM;

	if (psta->wireless_mode & WIRELESS_11_24N)
		w_set |= WIRELESS_HT;

	if ((psta->wireless_mode & WIRELESS_11AC) || (psta->wireless_mode & WIRELESS_11_5N))
		w_set |= WIRELESS_VHT;

	psta->phl_sta->support_wireless_set = w_set;
#endif
}

void update_sta_mimo_type(_adapter *adapter, struct sta_info *psta)
{
	s8 tx_nss, rx_nss;
	/* get adapter tx nss */
	tx_nss = rtw_get_sta_tx_nss(adapter, psta);
	/* get adapter rx nss */
	rx_nss =  rtw_get_sta_rx_nss(adapter, psta);

	/* peer sta tx should referece adapter rx_nss */
	psta->phl_sta->asoc_cap.nss_tx = rx_nss;
	/* peer sta rx should referece adapter tx_nss */
	psta->phl_sta->asoc_cap.nss_rx = tx_nss;

#ifdef CONFIG_CTRL_TXSS_BY_TP
	rtw_ctrl_txss_update_mimo_type(adapter, psta);
#endif

	RTW_INFO("STA - MAC_ID:%d, Tx - %d SS, Rx - %d SS\n",
			psta->phl_sta->macid, tx_nss, rx_nss);
}

void update_sta_smps_cap(_adapter *adapter, struct sta_info *psta)
{
	/*Spatial Multiplexing Power Save*/
#if 0
	if (check_fwstate(&adapter->mlmepriv, WIFI_AP_STATE) == _TRUE) {
		#ifdef CONFIG_80211N_HT
		if (psta->htpriv.ht_option) {
			if (psta->htpriv.smps_cap == 0)
				psta->phl_sta->sm_ps = SM_PS_STATIC;
			else if (psta->htpriv.smps_cap == 1)
				psta->phl_sta->sm_ps = SM_PS_DYNAMIC;
			else
				psta->phl_sta->sm_ps = SM_PS_DISABLE;
		}
		#endif /* CONFIG_80211N_HT */
	} else
#endif
		psta->phl_sta->asoc_cap.sm_ps = SM_PS_DISABLE;

	RTW_INFO("STA - MAC_ID:%d, SM_PS %d\n",
			psta->phl_sta->macid, psta->phl_sta->asoc_cap.sm_ps);
}

void update_sta_rate_mask(_adapter *padapter, struct sta_info *psta)
{
	u8 i, tx_nss;
	u64 tx_ra_bitmap = 0, tmp64=0;

	if (psta == NULL)
		return;

	/* b/g mode ra_bitmap  */
	for (i = 0; i < sizeof(psta->bssrateset); i++) {
		if (psta->bssrateset[i])
			tx_ra_bitmap |= rtw_get_bit_value_from_ieee_value(psta->bssrateset[i] & 0x7f);
	}

#ifdef CONFIG_80211N_HT
	if (padapter->registrypriv.ht_enable && is_supported_ht(padapter->registrypriv.wireless_mode)) {
		tx_nss = GET_HAL_TX_NSS(adapter_to_dvobj(padapter));
#ifdef CONFIG_80211AC_VHT
		if (psta->vhtpriv.vht_option) {
			/* AC mode ra_bitmap */
			tx_ra_bitmap |= (rtw_vht_mcs_map_to_bitmap(psta->vhtpriv.vht_mcs_map, tx_nss) << 12);
		} else
#endif /* CONFIG_80211AC_VHT */
		{
			if (psta->htpriv.ht_option) {
				/* n mode ra_bitmap */

				/* Handling SMPS mode for AP MODE only*/
				if (check_fwstate(&padapter->mlmepriv, WIFI_AP_STATE) == _TRUE) {
				/*0:static SMPS, 1:dynamic SMPS, 3:SMPS disabled, 2:reserved*/
					if (psta->htpriv.smps_cap == 0 || psta->htpriv.smps_cap == 1)
						/*operate with only one active receive chain // 11n-MCS rate <= MSC7*/
						tx_nss = rtw_min(tx_nss, 1);
				}

				tmp64 = rtw_ht_mcs_set_to_bitmap(psta->htpriv.ht_cap.supp_mcs_set, tx_nss);
				tx_ra_bitmap |= (tmp64 << 12);
			}
		}
	}
#endif /* CONFIG_80211N_HT */
	/* ToDo: Need API to inform hal_sta->ra_info.ramask */
	/* psta->phl_sta->ra_info.ramask = tx_ra_bitmap;*/
	psta->init_rate = get_highest_rate_idx(tx_ra_bitmap) & 0x3f;
}

void update_sta_ra_info(_adapter *padapter, struct sta_info *psta)
{
	update_sta_mimo_type(padapter, psta);
	update_sta_smps_cap(padapter, psta);
	update_sta_rate_mask(padapter, psta);
}

static void rtw_mlmeext_disconnect(_adapter *padapter)
{
	struct mlme_priv		*pmlmepriv = &padapter->mlmepriv;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8 self_action = MLME_ACTION_UNKNOWN;
	u8 state_backup = (pmlmeinfo->state & WIFI_FW_STATE_MASK);
	u8 ASIX_ID[] = {0x00, 0x0E, 0xC6};
	u8 *mac;
	struct sta_info *sta;

	if (MLME_IS_AP(padapter))
		self_action = MLME_AP_STOPPED;
	else if (MLME_IS_MESH(padapter))
		self_action = MLME_MESH_STOPPED;
	else if (MLME_IS_STA(padapter))
		self_action = MLME_STA_DISCONNECTED;
	else if (MLME_IS_ADHOC(padapter) || MLME_IS_ADHOC_MASTER(padapter))
		self_action = MLME_ADHOC_STOPPED;
	else {
		RTW_INFO("state:0x%x\n", MLME_STATE(padapter));
		rtw_warn_on(1);
	}

	/* set_opmode_cmd(padapter, infra_client_with_mlme); */

	if (self_action == MLME_STA_DISCONNECTED)
		rtw_mi_ap_correct_tsf(padapter, self_action);

	/* check if sta is ASIX peer and fix IOT issue if it is. */
	if (_rtw_memcmp(get_my_bssid(&pmlmeinfo->network) , ASIX_ID , 3)) {
		u8 iot_flag = _FALSE;
		rtw_hal_set_hwreg(padapter, HW_VAR_ASIX_IOT, (u8 *)(&iot_flag));
	}
	pmlmeinfo->state = WIFI_FW_NULL_STATE;

#ifdef CONFIG_MCC_MODE
	/* mcc disconnect setting before download LPS rsvd page */
	rtw_hal_set_mcc_setting_disconnect(padapter);
#endif /* CONFIG_MCC_MODE */

	/* switch to the 20M Hz mode after disconnect */
	pmlmeext->cur_bwmode = CHANNEL_WIDTH_20;
	pmlmeext->cur_ch_offset = CHAN_OFFSET_NO_EXT;
#ifdef CONFIG_CTRL_TXSS_BY_TP
	pmlmeext->txss_1ss = _FALSE;
#endif

#ifdef CONFIG_FCS_MODE
	if (EN_FCS(padapter))
		rtw_hal_set_hwreg(padapter, HW_VAR_STOP_FCS_MODE, NULL);
#endif

	if (!(MLME_IS_STA(padapter) && MLME_IS_OPCH_SW(padapter))) {
		/* DFS and channel status no need to check here for STA under OPCH_SW */
		u8 ch, bw, offset;

		#ifdef CONFIG_DFS_MASTER
		rtw_dfs_rd_en_decision(padapter, self_action, 0);
		#endif

		if (rtw_mi_get_ch_setting_union_no_self(padapter, &ch, &bw, &offset) != 0) {
			set_channel_bwmode(padapter, ch, offset, bw, _FALSE);
			rtw_mi_update_union_chan_inf(padapter, ch, offset, bw);
		}
	}

	_cancel_timer_ex(&pmlmeext->link_timer);

	/* pmlmepriv->LinkDetectInfo.TrafficBusyState = _FALSE; */
	pmlmepriv->LinkDetectInfo.TrafficTransitionCount = 0;
	pmlmepriv->LinkDetectInfo.LowPowerTransitionCount = 0;

#ifdef CONFIG_TDLS
	padapter->tdlsinfo.ap_prohibited = _FALSE;

	/* For TDLS channel switch, currently we only allow it to work in wifi logo test mode */
	if (padapter->registrypriv.wifi_spec == 1)
		padapter->tdlsinfo.ch_switch_prohibited = _FALSE;
#endif /* CONFIG_TDLS */

#ifdef CONFIG_WMMPS_STA
	 if (MLME_IS_STA(padapter)) {
		/* reset currently related uapsd setting when the connection has broken */
		pmlmepriv->qospriv.uapsd_max_sp_len = 0;
		pmlmepriv->qospriv.uapsd_tid = 0;
		pmlmepriv->qospriv.uapsd_tid_delivery_enabled = 0;
		pmlmepriv->qospriv.uapsd_tid_trigger_enabled = 0;
		pmlmepriv->qospriv.uapsd_ap_supported = 0;
	}
#endif /* CONFIG_WMMPS_STA */
#ifdef CONFIG_RTS_FULL_BW
	rtw_set_rts_bw(padapter);
#endif/*CONFIG_RTS_FULL_BW*/

	mac = pmlmeinfo->network.MacAddress;
	sta = rtw_get_stainfo(&padapter->stapriv, mac);
	if (sta)
		rtw_hw_disconnect(padapter, sta);
	else
		RTW_ERR(FUNC_ADPT_FMT ": can't find drv sta info for "
			MAC_FMT " !\n", FUNC_ADPT_ARG(padapter), MAC_ARG(mac));
}

void rtw_set_hw_after_join(struct _ADAPTER *a, int join_res)
{
	struct mlme_priv *mlme = &a->mlmepriv;
	struct sta_info *sta;
	u8 *mac;


	if (mlme->wpa_phase == _TRUE)
		mlme->wpa_phase = _FALSE;

	mac = (u8*)a->mlmeextpriv.mlmext_info.network.MacAddress;
	sta = rtw_get_stainfo(&a->stapriv, mac);
	if (!sta) {
		RTW_ERR(FUNC_ADPT_FMT ": drv sta_info(" MAC_FMT ") not exist!\n",
			FUNC_ADPT_ARG(a), MAC_ARG(mac));
		return;
	}

	if (join_res < 0) {
		rtw_hw_connect_abort(a, sta);
		return;
	}

#ifdef CONFIG_ARP_KEEP_ALIVE
	mlme->bGetGateway = 1;
	mlme->GetGatewayTryCnt = 0;
#endif

#ifdef CONFIG_AP_MODE
	if (MLME_IS_STATE(&a->mlmeextpriv.mlmext_info, WIFI_FW_ADHOC_STATE)) {
		/* update bc/mc sta_info */
		update_bmc_sta(a);
	}
#endif

	rtw_ap_set_sta_wmode(a, sta);
	//sta->phl_sta->wmode = a->mlmeextpriv.cur_wireless_mode;
	rtw_hw_connected(a, sta);
	rtw_xmit_queue_clear(sta);
#ifdef CONFIG_TXSC_AMSDU
	txsc_amsdu_sta_init(a, sta);
#endif
	if (is_wep_enc(a->securitypriv.dot11PrivacyAlgrthm))
		rtw_ap_wep_pk_setting(a, sta);
}

/* currently only adhoc mode will go here */
void mlmeext_sta_add_event_callback(_adapter *padapter, struct sta_info *psta)
{
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	u8	join_type;

	RTW_INFO("%s\n", __FUNCTION__);

	if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_ADHOC_STATE)) {
		if (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS) { /* adhoc master or sta_count>1 */
			/* nothing to do */
		} else { /* adhoc client */
			/* update TSF Value */
			/* update_TSF(pmlmeext, pframe, len);			 */

			/* correcting TSF */
			rtw_mi_ap_correct_tsf(padapter, MLME_ADHOC_STARTED);

			/* start beacon */
			if (send_beacon(padapter) == _FAIL)
				rtw_warn_on(1);

			pmlmeinfo->state |= WIFI_FW_ASSOC_SUCCESS;
		}

		join_type = 2;
		rtw_hal_set_hwreg(padapter, HW_VAR_MLME_JOIN, (u8 *)(&join_type));
	}

	/* update adhoc sta_info */
	update_sta_info(padapter, psta);

	update_sta_ra_info(padapter, psta);

	/* ToDo: HT for Ad-hoc */
	psta->phl_sta->wmode = rtw_check_network_type(psta->bssrateset, psta->bssratelen, pmlmeext->cur_channel);
	rtw_hal_set_phydm_var(padapter, HAL_PHYDM_STA_INFO, psta, _TRUE);

	/* rate radaptive */
	rtw_hal_sta_ra_registed(psta);
}

void mlmeext_sta_del_event_callback(_adapter *padapter)
{
	if (is_client_associated_to_ap(padapter) || is_IBSS_empty(padapter))
		rtw_mlmeext_disconnect(padapter);
}

/****************************************************************************

Following are the functions for the timer handlers

*****************************************************************************/
void _linked_info_dump(_adapter *padapter)
{
	if (padapter->bLinkInfoDump) {
		rtw_hal_get_def_var(padapter, HW_DEF_RA_INFO_DUMP, RTW_DBGDUMP);
		rtw_hal_set_phydm_var(padapter, HAL_PHYDM_RX_INFO_DUMP, RTW_DBGDUMP, _FALSE);
	}
}
/********************************************************************

When station does not receive any packet in MAX_CONTINUAL_NORXPACKET_COUNT*2 seconds,
recipient station will teardown the block ack by issuing DELBA frame.

*********************************************************************/
void rtw_delba_check(_adapter *padapter, struct sta_info *psta, u8 from_timer)
{
	int	i = 0;
	int ret = _SUCCESS;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	/*
		IOT issue,occur Broadcom ap(Buffalo WZR-D1800H,Netgear R6300).
		AP is originator.AP does not transmit unicast packets when STA response its BAR.
		This case probably occur ap issue BAR after AP builds BA.

		Follow 802.11 spec, STA shall maintain an inactivity timer for every negotiated Block Ack setup.
		The inactivity timer is not reset when MPDUs corresponding to other TIDs are received.
	*/
	if (pmlmeinfo->assoc_AP_vendor == HT_IOT_PEER_BROADCOM) {
		for (i = 0; i < TID_NUM ; i++) {
			if ((psta->recvreorder_ctrl[i].enable) &&
                        (sta_rx_data_qos_pkts(psta, i) == sta_last_rx_data_qos_pkts(psta, i)) ) {
					if (_TRUE == rtw_inc_and_chk_continual_no_rx_packet(psta, i)) {
						/* send a DELBA frame to the peer STA with the Reason Code field set to TIMEOUT */
						if (!from_timer)
							ret = issue_del_ba_ex(padapter, psta->phl_sta->mac_addr, i, 39, 0, 3, 1);
						else
							issue_del_ba(padapter,  psta->phl_sta->mac_addr, i, 39, 0);
						psta->recvreorder_ctrl[i].enable = _FALSE;
						if (ret != _FAIL)
							psta->recvreorder_ctrl[i].ampdu_size = RX_AMPDU_SIZE_INVALID;
						rtw_reset_continual_no_rx_packet(psta, i);
					}
			} else {
				/* The inactivity timer is reset when MPDUs to the TID is received. */
				rtw_reset_continual_no_rx_packet(psta, i);
			}
		}
	}
}

u8 chk_ap_is_alive(_adapter *padapter, struct sta_info *psta)
{
	u8 ret = _FALSE;
#ifdef DBG_EXPIRATION_CHK
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	RTW_INFO(FUNC_ADPT_FMT" rx:"STA_PKTS_FMT", beacon:%llu, probersp_to_self:%llu"
		/*", probersp_bm:%llu, probersp_uo:%llu, probereq:%llu, BI:%u"*/
		 ", retry:%u\n"
		 , FUNC_ADPT_ARG(padapter)
		 , STA_RX_PKTS_DIFF_ARG(psta)
		, psta->sta_stats.rx_beacon_pkts - psta->sta_stats.last_rx_beacon_pkts
		, psta->sta_stats.rx_probersp_pkts - psta->sta_stats.last_rx_probersp_pkts
		/*, psta->sta_stats.rx_probersp_bm_pkts - psta->sta_stats.last_rx_probersp_bm_pkts
		, psta->sta_stats.rx_probersp_uo_pkts - psta->sta_stats.last_rx_probersp_uo_pkts
		, psta->sta_stats.rx_probereq_pkts - psta->sta_stats.last_rx_probereq_pkts
		 , pmlmeinfo->bcn_interval*/
		 , pmlmeext->retry
		);

	RTW_INFO(FUNC_ADPT_FMT" tx_pkts:%llu, link_count:%u\n", FUNC_ADPT_ARG(padapter)
		 , sta_tx_pkts(psta)
		 , pmlmeinfo->link_count
		);
#endif

	if ((sta_rx_data_pkts(psta) == sta_last_rx_data_pkts(psta))
	    && sta_rx_beacon_pkts(psta) == sta_last_rx_beacon_pkts(psta)
	    && sta_rx_probersp_pkts(psta) == sta_last_rx_probersp_pkts(psta)
	   )
		ret = _FALSE;
	else
		ret = _TRUE;

	sta_update_last_rx_pkts(psta);

	return ret;
}

u8 chk_adhoc_peer_is_alive(struct sta_info *psta)
{
	u8 ret = _TRUE;

#ifdef DBG_EXPIRATION_CHK
	RTW_INFO("sta:"MAC_FMT", rssi:%d, rx:"STA_PKTS_FMT", beacon:%llu, probersp_to_self:%llu"
		/*", probersp_bm:%llu, probersp_uo:%llu, probereq:%llu, BI:%u"*/
		 ", expire_to:%u\n"
		 , MAC_ARG(psta->phl_sta->mac_addr)
		 , 0 /* TODO: psta->phl_sta->hal_sta->rssi_stat.rssi */
		 , STA_RX_PKTS_DIFF_ARG(psta)
		, psta->sta_stats.rx_beacon_pkts - psta->sta_stats.last_rx_beacon_pkts
		, psta->sta_stats.rx_probersp_pkts - psta->sta_stats.last_rx_probersp_pkts
		/*, psta->sta_stats.rx_probersp_bm_pkts - psta->sta_stats.last_rx_probersp_bm_pkts
		, psta->sta_stats.rx_probersp_uo_pkts - psta->sta_stats.last_rx_probersp_uo_pkts
		, psta->sta_stats.rx_probereq_pkts - psta->sta_stats.last_rx_probereq_pkts
		 , pmlmeinfo->bcn_interval*/
		 , psta->expire_to
		);
#endif

	if (sta_rx_data_pkts(psta) == sta_last_rx_data_pkts(psta)
	    && sta_rx_beacon_pkts(psta) == sta_last_rx_beacon_pkts(psta)
	    && sta_rx_probersp_pkts(psta) == sta_last_rx_probersp_pkts(psta))
		ret = _FALSE;

	sta_update_last_rx_pkts(psta);

	return ret;
}

#ifdef CONFIG_TDLS
u8 chk_tdls_peer_sta_is_alive(_adapter *padapter, struct sta_info *psta)
{
	if ((psta->sta_stats.rx_data_pkts == psta->sta_stats.last_rx_data_pkts)
	    && (psta->sta_stats.rx_tdls_disc_rsp_pkts == psta->sta_stats.last_rx_tdls_disc_rsp_pkts))
		return _FALSE;

	return _TRUE;
}

void linked_status_chk_tdls(_adapter *padapter)
{
	struct candidate_pool {
		struct sta_info *psta;
		u8 addr[ETH_ALEN];
	};
	struct sta_priv *pstapriv = &padapter->stapriv;
	u8 ack_chk;
	struct sta_info *psta;
	int i, num_teardown = 0, num_checkalive = 0;
	_list	*plist, *phead;
	struct tdls_txmgmt txmgmt;
	struct candidate_pool checkalive[MAX_ALLOWED_TDLS_STA_NUM];
	struct candidate_pool teardown[MAX_ALLOWED_TDLS_STA_NUM];
	u8 tdls_sta_max = _FALSE;

#define ALIVE_MIN 2
#define ALIVE_MAX 5

	_rtw_memset(&txmgmt, 0x00, sizeof(struct tdls_txmgmt));
	_rtw_memset(checkalive, 0x00, sizeof(checkalive));
	_rtw_memset(teardown, 0x00, sizeof(teardown));

	if ((padapter->tdlsinfo.link_established == _TRUE)) {
		_rtw_spinlock_bh(&pstapriv->sta_hash_lock);
		for (i = 0; i < NUM_STA; i++) {
			phead = &(pstapriv->sta_hash[i]);
			plist = get_next(phead);

			while ((rtw_end_of_queue_search(phead, plist)) == _FALSE) {
				psta = LIST_CONTAINOR(plist, struct sta_info, hash_list);
				plist = get_next(plist);

				if (psta->tdls_sta_state & TDLS_LINKED_STATE) {
					psta->alive_count++;
					if (psta->alive_count >= ALIVE_MIN) {
						if (chk_tdls_peer_sta_is_alive(padapter, psta) == _FALSE) {
							if (psta->alive_count < ALIVE_MAX) {
								_rtw_memcpy(checkalive[num_checkalive].addr, psta->phl_sta->mac_addr, ETH_ALEN);
								checkalive[num_checkalive].psta = psta;
								num_checkalive++;
							} else {
								_rtw_memcpy(teardown[num_teardown].addr, psta->phl_sta->mac_addr, ETH_ALEN);
								teardown[num_teardown].psta = psta;
								num_teardown++;
							}
						} else
							psta->alive_count = 0;
					}
					psta->sta_stats.last_rx_data_pkts = psta->sta_stats.rx_data_pkts;
					psta->sta_stats.last_rx_tdls_disc_rsp_pkts = psta->sta_stats.rx_tdls_disc_rsp_pkts;

					if ((num_checkalive >= MAX_ALLOWED_TDLS_STA_NUM) || (num_teardown >= MAX_ALLOWED_TDLS_STA_NUM)) {
						tdls_sta_max = _TRUE;
						break;
					}
				}
			}

			if (tdls_sta_max == _TRUE)
				break;
		}
		_rtw_spinunlock_bh(&pstapriv->sta_hash_lock);

		if (num_checkalive > 0) {
			for (i = 0; i < num_checkalive; i++) {
				_rtw_memcpy(txmgmt.peer, checkalive[i].addr, ETH_ALEN);
				issue_tdls_dis_req(padapter, &txmgmt);
				issue_tdls_dis_req(padapter, &txmgmt);
				issue_tdls_dis_req(padapter, &txmgmt);
			}
		}

		if (num_teardown > 0) {
			for (i = 0; i < num_teardown; i++) {
				RTW_INFO("[%s %d] Send teardown to "MAC_FMT"\n", __FUNCTION__, __LINE__, MAC_ARG(teardown[i].addr));
				txmgmt.status_code = _RSON_TDLS_TEAR_TOOFAR_;
				_rtw_memcpy(txmgmt.peer, teardown[i].addr, ETH_ALEN);
				issue_tdls_teardown(padapter, &txmgmt, _FALSE);
			}
		}
	}

}
#endif /* CONFIG_TDLS */

inline int rtw_get_rx_chk_limit(_adapter *adapter, bool w53w56)
{
	return w53w56 ? adapter->stapriv.rx_chk_limit_w53w56 : adapter->stapriv.rx_chk_limit;
}

inline void rtw_set_rx_chk_limit(_adapter *adapter, int limit, int limit_w53w56)
{
	adapter->stapriv.rx_chk_limit = limit;
	adapter->stapriv.rx_chk_limit_w53w56= limit_w53w56;
}

/* from_timer == 1 means driver is in LPS */
void linked_status_chk(_adapter *padapter, u8 from_timer)
{
	u32	i;
	struct sta_info		*psta;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct sta_priv		*pstapriv = &padapter->stapriv;
#if defined(CONFIG_ARP_KEEP_ALIVE) || defined(CONFIG_LAYER2_ROAMING)
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
#endif
#ifdef CONFIG_LAYER2_ROAMING
	struct recv_priv	*precvpriv = &padapter->recvpriv;
#endif

	if (padapter->registrypriv.mp_mode == _TRUE)
		return;

	if (is_client_associated_to_ap(padapter)) {
		/* linked infrastructure client mode */

		int tx_chk = _SUCCESS, rx_chk = _SUCCESS;
		int rx_chk_limit;
		int link_count_limit;

#if defined(CONFIG_LAYER2_ROAMING)
		if (rtw_chk_roam_flags(padapter, RTW_ROAM_ACTIVE)) {
			RTW_INFO("signal_strength_data.avg_val = %d\n", precvpriv->signal_strength_data.avg_val);
			if ((precvpriv->signal_strength_data.avg_val < pmlmepriv->roam_rssi_threshold)
				&& (rtw_get_passing_time_ms(pmlmepriv->last_roaming) >= pmlmepriv->roam_scan_int*2000)) {
#ifdef CONFIG_RTW_80211K
				rtw_roam_nb_discover(padapter, _FALSE);
#endif
				pmlmepriv->need_to_roam = _TRUE;
				rtw_drv_scan_by_self(padapter, RTW_AUTO_SCAN_REASON_ROAM);
				pmlmepriv->last_roaming = rtw_get_current_time();
			} else
				pmlmepriv->need_to_roam = _FALSE;
		}
#endif
#ifdef CONFIG_MCC_MODE
		/*
		 * due to tx ps null date to ao, so ap doest not tx pkt to driver
		 * we may check chk_ap_is_alive fail, and may issue_probereq to wrong channel under sitesurvey
		 * don't keep alive check under MCC
		 */
		if (rtw_hal_mcc_link_status_chk(padapter, __func__) == _FALSE)
			return;
#endif
		if (padapter->dvobj->oper_channel >= 52 && padapter->dvobj->oper_channel <= 64)
			rx_chk_limit = rtw_get_rx_chk_limit(padapter, 1);
		else if (padapter->dvobj->oper_channel >= 100 && padapter->dvobj->oper_channel <= 144)
			rx_chk_limit = rtw_get_rx_chk_limit(padapter, 1);
		else
			rx_chk_limit = rtw_get_rx_chk_limit(padapter, 0);

#ifdef CONFIG_ARP_KEEP_ALIVE
		if (!from_timer && pmlmepriv->bGetGateway == 1 && pmlmepriv->GetGatewayTryCnt < 3) {
			RTW_INFO("do rtw_gw_addr_query() : %d\n", pmlmepriv->GetGatewayTryCnt);
			pmlmepriv->GetGatewayTryCnt++;
			if (rtw_gw_addr_query(padapter) == 0)
				pmlmepriv->bGetGateway = 0;
			else {
				_rtw_memset(pmlmepriv->gw_ip, 0, 4);
				_rtw_memset(pmlmepriv->gw_mac_addr, 0, ETH_ALEN);
			}
		}
#endif
#ifdef CONFIG_P2P
		if (!rtw_p2p_chk_state(&padapter->wdinfo, P2P_STATE_NONE)) {
			if (!from_timer)
				link_count_limit = 3; /* 8 sec */
			else
				link_count_limit = 15; /* 32 sec */
		} else
#endif /* CONFIG_P2P */
		{
			if (!from_timer)
				link_count_limit = 7; /* 16 sec */
			else
				link_count_limit = 29; /* 60 sec */
		}

#ifdef CONFIG_TDLS
#ifdef CONFIG_TDLS_CH_SW
		if (ATOMIC_READ(&padapter->tdlsinfo.chsw_info.chsw_on) == _TRUE)
			return;
#endif /* CONFIG_TDLS_CH_SW */

#ifdef CONFIG_TDLS_AUTOCHECKALIVE
		linked_status_chk_tdls(padapter);
#endif /* CONFIG_TDLS_AUTOCHECKALIVE */
#endif /* CONFIG_TDLS */

		psta = rtw_get_stainfo(pstapriv, pmlmeinfo->network.MacAddress);
		if (psta != NULL) {
			bool is_p2p_enable = _FALSE;
#ifdef CONFIG_P2P
			is_p2p_enable = !rtw_p2p_chk_state(&padapter->wdinfo, P2P_STATE_NONE);
#endif

#ifdef CONFIG_ISSUE_DELBA_WHEN_NO_TRAFFIC
			/*issue delba when ap does not tx data packet that is Broadcom ap */
			rtw_delba_check(padapter, psta, from_timer);
#endif
			if (chk_ap_is_alive(padapter, psta) == _FALSE)
				rx_chk = _FAIL;

			if (sta_last_tx_pkts(psta) == sta_tx_pkts(psta))
				tx_chk = _FAIL;

#ifdef CONFIG_ACTIVE_KEEP_ALIVE_CHECK
			if (!from_timer && pmlmeext->active_keep_alive_check && (rx_chk == _FAIL || tx_chk == _FAIL)
			) {
				u8 backup_ch = 0, backup_bw = 0, backup_offset = 0;
				u8 union_ch = 0, union_bw = 0, union_offset = 0;
				u8 switch_channel_by_drv = _TRUE;


#ifdef CONFIG_MCC_MODE
				if (MCC_EN(padapter)) {
					/* driver doesn't switch channel under MCC */
					if (rtw_hal_check_mcc_status(padapter, MCC_STATUS_DOING_MCC))
						switch_channel_by_drv = _FALSE;
				}
#endif
				if (switch_channel_by_drv) {
					if (!rtw_mi_get_ch_setting_union(padapter, &union_ch, &union_bw, &union_offset)
						|| pmlmeext->cur_channel != union_ch)
							goto bypass_active_keep_alive;

					/* switch to correct channel of current network  before issue keep-alive frames */
					if (rtw_get_oper_ch(padapter) != pmlmeext->cur_channel) {
						backup_ch = rtw_get_oper_ch(padapter);
						backup_bw = rtw_get_oper_bw(padapter);
						backup_offset = rtw_get_oper_choffset(padapter);
						set_channel_bwmode(padapter, union_ch, union_offset, union_bw, _FALSE);
					}
				}

				if (rx_chk != _SUCCESS)
					issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, psta->phl_sta->mac_addr, 0, 0, 3, 1);

				if ((tx_chk != _SUCCESS && pmlmeinfo->link_count++ == link_count_limit) || rx_chk != _SUCCESS) {
					if (rtw_mi_check_fwstate(padapter, WIFI_UNDER_SURVEY))
						tx_chk = issue_nulldata(padapter, psta->phl_sta->mac_addr, 1, 3, 1);
					else
						tx_chk = issue_nulldata(padapter, psta->phl_sta->mac_addr, 0, 3, 1);
					/* if tx acked and p2p disabled, set rx_chk _SUCCESS to reset retry count */
					if (tx_chk == _SUCCESS && !is_p2p_enable)
						rx_chk = _SUCCESS;
				}

				/* back to the original operation channel */
				if (backup_ch > 0 && switch_channel_by_drv)
					set_channel_bwmode(padapter, backup_ch, backup_offset, backup_bw, _FALSE);

bypass_active_keep_alive:
				;
			} else
#endif /* CONFIG_ACTIVE_KEEP_ALIVE_CHECK */
			{
				if (rx_chk != _SUCCESS) {
					if (pmlmeext->retry == 0) {
#ifdef DBG_EXPIRATION_CHK
						RTW_INFO("issue_probereq to trigger probersp, retry=%d\n", pmlmeext->retry);
#endif
						issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, pmlmeinfo->network.MacAddress, 0, 0, 0, (from_timer ? 0 : 1));
						issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, pmlmeinfo->network.MacAddress, 0, 0, 0, (from_timer ? 0 : 1));
						issue_probereq_ex(padapter, &pmlmeinfo->network.Ssid, pmlmeinfo->network.MacAddress, 0, 0, 0, (from_timer ? 0 : 1));
					}
				}

				if (tx_chk != _SUCCESS && pmlmeinfo->link_count++ == link_count_limit
#ifdef CONFIG_MCC_MODE
				    /* FW tx nulldata under MCC mode, we just check  ap is alive */
				    && (!rtw_hal_check_mcc_status(padapter, MCC_STATUS_NEED_MCC))
#endif /* CONFIG_MCC_MODE */
				) {
					#ifdef DBG_EXPIRATION_CHK
					RTW_INFO("%s issue_nulldata(%d)\n", __FUNCTION__, from_timer ? 1 : 0);
					#endif
					if (from_timer || rtw_mi_check_fwstate(padapter, WIFI_UNDER_SURVEY))
						tx_chk = issue_nulldata(padapter, NULL, 1, 0, 0);
					else
						tx_chk = issue_nulldata(padapter, NULL, 0, 1, 1);
				}
			}

			if (rx_chk == _FAIL) {
				pmlmeext->retry++;
				if (pmlmeext->retry > rx_chk_limit) {
					RTW_PRINT(FUNC_ADPT_FMT" disconnect or roaming\n",
						  FUNC_ADPT_ARG(padapter));
					receive_disconnect(padapter, pmlmeinfo->network.MacAddress
						, WLAN_REASON_EXPIRATION_CHK, _FALSE);
					return;
				}
			} else
				pmlmeext->retry = 0;

			if (tx_chk == _FAIL)
				pmlmeinfo->link_count %= (link_count_limit + 1);
			else {
				psta->sta_stats.last_tx_pkts = psta->sta_stats.tx_pkts;
				pmlmeinfo->link_count = 0;
			}

		} /* end of if ((psta = rtw_get_stainfo(pstapriv, passoc_res->network.MacAddress)) != NULL) */

	} else if (is_client_associated_to_ibss(padapter)) {
		_list *phead, *plist, dlist;

		_rtw_init_listhead(&dlist);

		_rtw_spinlock_bh(&pstapriv->sta_hash_lock);

		for (i = 0; i < NUM_STA; i++) {

			phead = &(pstapriv->sta_hash[i]);
			plist = get_next(phead);
			while ((rtw_end_of_queue_search(phead, plist)) == _FALSE) {
				psta = LIST_CONTAINOR(plist, struct sta_info, hash_list);
				plist = get_next(plist);

				if (is_broadcast_mac_addr(psta->phl_sta->mac_addr))
					continue;

				if (chk_adhoc_peer_is_alive(psta) || !psta->expire_to)
					psta->expire_to = pstapriv->adhoc_expire_to;
				else
					psta->expire_to--;

				if (psta->expire_to <= 0) {
					rtw_list_delete(&psta->hash_list);
					rtw_list_insert_tail(&psta->hash_list, &dlist);
				}
			}
		}

		_rtw_spinunlock_bh(&pstapriv->sta_hash_lock);

		plist = get_next(&dlist);
		while (rtw_end_of_queue_search(&dlist, plist) == _FALSE) {
			psta = LIST_CONTAINOR(plist, struct sta_info, hash_list);
			plist = get_next(plist);
			rtw_list_delete(&psta->hash_list);
			RTW_INFO(FUNC_ADPT_FMT" ibss expire "MAC_FMT"\n"
				, FUNC_ADPT_ARG(padapter), MAC_ARG(psta->phl_sta->mac_addr));
			report_del_sta_event(padapter, psta->phl_sta->mac_addr, WLAN_REASON_EXPIRATION_CHK, from_timer ? _TRUE : _FALSE, _FALSE);
		}
	}

}

#ifdef REPORT_TIMER_SUPPORT
void report_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	unsigned char *buffer=NULL;

	buffer=rtw_malloc(WLAN_INFO_LEN);
	if(buffer == NULL)
	{
		RTW_ERR("%s %d rtw malloc failed\n",__func__,__LINE__);
		return;
	}
#ifdef RTL_LINK_ROAMING_REPORT
	if (padapter->netif_up){
		_rtw_memset(buffer, 0, sizeof(WLAN_INFO_LEN));
		RTW_WARN("(%s)(%s)\n", __FUNCTION__, padapter->pnetdev->name);
		general_wlan_IndicateEvent(padapter, EVENT_ROAMING_INFO_RPT, buffer);
	}
#endif
#ifdef MONITOR_UNASSOC_STA
	if (padapter->netif_up){
		_rtw_memset(buffer, 0, sizeof(WLAN_INFO_LEN));
		general_wlan_IndicateEvent(padapter, EVENT_UNASSOC_STA_RPT, buffer);
	}
#endif

	set_report_timer(pmlmeext, 5000);
	rtw_mfree(buffer,WLAN_INFO_LEN);
}
#endif


#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
void rtw_tbtx_xmit_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;

	if (ATOMIC_READ(&padapter->tbtx_remove_tx_pause) == _TRUE){
		ATOMIC_SET(&padapter->tbtx_tx_pause, _FALSE);
		rtw_tx_control_cmd(padapter);
	}else {
		rtw_issue_action_token_rel(padapter);
		ATOMIC_SET(&padapter->tbtx_tx_pause, _TRUE);
		rtw_tx_control_cmd(padapter);
		_set_timer(&pmlmeext->tbtx_xmit_timer, MAX_TXPAUSE_DURATION);
		ATOMIC_SET(&padapter->tbtx_remove_tx_pause, _TRUE);
	}
}

#ifdef CONFIG_AP_MODE
void rtw_tbtx_token_dispatch_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	_irqL irqL;
	struct sta_info *psta = NULL;
	struct sta_priv *pstapriv = &padapter->stapriv;
	_list *phead, *plist;
	int i, found = _FALSE;
	u8 nr_send, th_idx = 0;

	_rtw_spinlock_bh(&pstapriv->asoc_list_lock, &irqL);
	RTW_DBG("%s:asoc_cnt: %d\n",__func__, pstapriv->tbtx_asoc_list_cnt);

	// check number of TBTX sta
	if (padapter->stapriv.tbtx_asoc_list_cnt < 2)
		goto exit;

	// dispatch token

	nr_send = RTW_DIV_ROUND_UP(pstapriv->tbtx_asoc_list_cnt, NR_TBTX_SLOT);

	phead = &pstapriv->asoc_list;
	plist = get_next(phead);
	while ((rtw_end_of_queue_search(phead, plist)) == _FALSE) {
		psta = LIST_CONTAINOR(plist, struct sta_info, asoc_list);
		/* psta is supporting TBTX */
		if ((!psta) || (!psta->tbtx_enable))
			RTW_DBG("sta tbtx_enable is false\n");
		else {
			for (i = 0; i < nr_send; i++) {
				if (pstapriv->last_token_holder == psta) {
					found = _TRUE;
					goto outof_loop;
				}
			}
		}
		plist = get_next(plist);
	}
outof_loop:

	RTW_DBG("rtw_tbtx_token_dispatch_timer_hdl()   th_idx=%d,  nr_send=%d, phead=%p, plist=%p, found=%d\n ", th_idx ,  nr_send, phead, plist, found);
	if (!found) {
		plist = get_next(phead);
		while(rtw_end_of_queue_search(phead, plist) == _FALSE) {
			psta = LIST_CONTAINOR(plist, struct sta_info, asoc_list);
			if ((!psta) || (!psta->tbtx_enable))
				RTW_DBG("sta tbtx_enable is false\n");
			else {
					pstapriv->token_holder[th_idx] = psta;
					rtw_issue_action_token_req(padapter, pstapriv->token_holder[th_idx++]);
					break;
			}
			plist = get_next(plist);
		}
	}

	for (i=th_idx; i<nr_send;) {
		plist = get_next(plist);
		if (plist == phead)
			plist = get_next(plist);
		psta = LIST_CONTAINOR(plist, struct sta_info, asoc_list);
		if ((!psta) || (!psta->tbtx_enable))
			RTW_DBG("sta tbtx_enable is false\n");
		else {
			pstapriv->token_holder[th_idx] = psta;
			rtw_issue_action_token_req(padapter, pstapriv->token_holder[th_idx++]);
			i++;
		}
	}
	ATOMIC_SET(&pstapriv->nr_token_keeper, nr_send);


exit:
	// set_timer
	_rtw_spinunlock_bh(&pstapriv->asoc_list_lock, &irqL);
	_set_timer(&pmlmeext->tbtx_token_dispatch_timer, TBTX_TX_DURATION);
}
#endif /* CONFIG_AP_MODE */
#endif /* CONFIG_RTW_TOKEN_BASED_XMIT */

void link_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	/* static unsigned int		rx_pkt = 0; */
	/* static u64				tx_cnt = 0; */
	/* struct xmit_priv		*pxmitpriv = &(padapter->xmitpriv); */
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	/* struct sta_priv		*pstapriv = &padapter->stapriv; */
#ifdef CONFIG_RTW_80211R
	struct	sta_priv		*pstapriv = &padapter->stapriv;
	struct	sta_info		*psta = NULL;
	WLAN_BSSID_EX		*pnetwork = (WLAN_BSSID_EX *)(&(pmlmeinfo->network));
#endif

	if (rtw_sta_linking_test_force_fail())
		RTW_INFO("rtw_sta_linking_test_force_fail\n");

	if (pmlmeext->join_abort && pmlmeinfo->state != WIFI_FW_NULL_STATE) {
		RTW_INFO(FUNC_ADPT_FMT" join abort\n", FUNC_ADPT_ARG(padapter));
		pmlmeinfo->state = WIFI_FW_NULL_STATE;
		report_join_res(padapter, -4, WLAN_STATUS_UNSPECIFIED_FAILURE);
		goto exit;
	}

	if (pmlmeinfo->state & WIFI_FW_AUTH_NULL) {
		RTW_INFO("link_timer_hdl:no beacon while connecting\n");
		pmlmeinfo->state = WIFI_FW_NULL_STATE;
		report_join_res(padapter, -3, WLAN_STATUS_UNSPECIFIED_FAILURE);
	} else if (pmlmeinfo->state & WIFI_FW_AUTH_STATE) {

#ifdef CONFIG_IOCTL_CFG80211
		if (rtw_sec_chk_auth_type(padapter, MLME_AUTHTYPE_SAE))
			return;
#endif /* CONFIG_IOCTL_CFG80211 */

		/* re-auth timer */
		if (++pmlmeinfo->reauth_count > REAUTH_LIMIT) {
			/* if (pmlmeinfo->auth_algo != dot11AuthAlgrthm_Auto) */
			/* { */
			pmlmeinfo->state = 0;
			if (pmlmeinfo->auth_status) {
				report_join_res(padapter, -1, pmlmeinfo->auth_status);
				pmlmeinfo->auth_status = 0; /* reset */
			} else
				report_join_res(padapter, -1, WLAN_STATUS_UNSPECIFIED_FAILURE);
			return;
			/* } */
			/* else */
			/* { */
			/*	pmlmeinfo->auth_algo = dot11AuthAlgrthm_Shared; */
			/*	pmlmeinfo->reauth_count = 0; */
			/* } */
		}

		RTW_INFO("link_timer_hdl: auth timeout and try again\n");
		pmlmeinfo->auth_seq = 1;
		issue_auth(padapter, NULL, 0);
		set_link_timer(pmlmeext, REAUTH_TO);
	} else if (pmlmeinfo->state & WIFI_FW_ASSOC_STATE) {
		/* re-assoc timer */
		if (++pmlmeinfo->reassoc_count > REASSOC_LIMIT) {
			pmlmeinfo->state = WIFI_FW_NULL_STATE;
#ifdef CONFIG_RTW_80211R
			if (rtw_ft_roam(padapter)) {
				psta = rtw_get_stainfo(pstapriv, pmlmeinfo->network.MacAddress);
				if (psta)
					rtw_free_stainfo(padapter,  psta);
			}
#endif
			report_join_res(padapter, -2, WLAN_STATUS_UNSPECIFIED_FAILURE);
			return;
		}

#ifdef CONFIG_RTW_80211R
		if (rtw_ft_roam(padapter)) {
			RTW_INFO("link_timer_hdl: reassoc timeout and try again\n");
			issue_reassocreq(padapter);
		} else
#endif
		{
			RTW_INFO("link_timer_hdl: assoc timeout and try again\n");
			issue_assocreq(padapter);
		}

		set_link_timer(pmlmeext, REASSOC_TO);
	}

exit:
	return;
}

void addba_timer_hdl(void *ctx)
{
	struct sta_info *psta = (struct sta_info *)ctx;

#ifdef CONFIG_80211N_HT
	struct ht_priv	*phtpriv;

	if (!psta)
		return;

	phtpriv = &psta->htpriv;

	if ((phtpriv->ht_option == _TRUE) && (phtpriv->ampdu_enable == _TRUE)) {
		if (phtpriv->candidate_tid_bitmap)
			phtpriv->candidate_tid_bitmap = 0x0;

	}
#endif /* CONFIG_80211N_HT */
}

void report_sta_timeout_event(_adapter *padapter, u8 *MacAddr, unsigned short reason)
{
	struct cmd_obj *pcmd_obj;
	u8 *pevtcmd;
	u32 cmdsz;
	struct sta_info *psta;
	int	mac_id;
	struct stadel_event *pdel_sta_evt;
	struct rtw_evt_header *evt_hdr;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct cmd_priv *pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;

	pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (pcmd_obj == NULL)
		return;
	pcmd_obj->padapter = padapter;

	cmdsz = (sizeof(struct stadel_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		return;
	}

	_rtw_init_listhead(&pcmd_obj->list);

	pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
	pcmd_obj->cmdsz = cmdsz;
	pcmd_obj->parmbuf = pevtcmd;

	pcmd_obj->rsp = NULL;
	pcmd_obj->rspsz  = 0;

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct stadel_event);
	evt_hdr->id = EVT_TIMEOUT_STA;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	pdel_sta_evt = (struct stadel_event *)(pevtcmd + sizeof(struct rtw_evt_header));
	_rtw_memcpy((unsigned char *)(&(pdel_sta_evt->macaddr)), MacAddr, ETH_ALEN);
	_rtw_memcpy((unsigned char *)(pdel_sta_evt->rsvd), (unsigned char *)(&reason), 2);


	psta = rtw_get_stainfo(&padapter->stapriv, MacAddr);
	if (psta)
		mac_id = (int)psta->phl_sta->macid;
	else
		mac_id = (-1);

	pdel_sta_evt->mac_id = mac_id;

	RTW_INFO("report_sta_timeout_event: delete STA, mac_id=%d\n", mac_id);

	rtw_enqueue_cmd(pcmdpriv, pcmd_obj);

	return;
}

#if defined(CONFIG_IEEE80211W) && !defined(CONFIG_IOCTL_CFG80211)
void clnt_sa_query_timeout(_adapter *padapter)
{
	struct mlme_ext_priv *mlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *mlmeinfo = &(mlmeext->mlmext_info);

	RTW_INFO(FUNC_ADPT_FMT"\n", FUNC_ADPT_ARG(padapter));
	receive_disconnect(padapter, get_my_bssid(&(mlmeinfo->network)), WLAN_REASON_SA_QUERY_TIMEOUT, _FALSE);
}


u8 check_sa_query_timeout(struct sta_info *psta)
{
	if(time_after_eq(jiffies, psta->sa_query_end)) {
		psta->sa_query_timed_out = 1;
		psta->sa_query_cnt = 0;
		return 1;
	}
	return 0;
}

void sa_query_timer_hdl(void *ctx)
{
	struct sta_info *psta = (struct sta_info *)ctx;
	_adapter *padapter = psta->padapter;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;

	if (   psta->sa_query_timed_out
	    || (padapter->netif_up == _FALSE)
	    || ((psta->state & WIFI_ASOC_STATE) == 0))
		return;

	if (psta->sa_query_cnt > 0 && check_sa_query_timeout(psta)) {
		RTW_ERR("macid %d: sa query time out\n", psta->phl_sta->macid);
		if (MLME_IS_STA(padapter) &&
			check_fwstate(pmlmepriv, WIFI_ASOC_STATE) == _TRUE)
			clnt_sa_query_timeout(padapter);
		else if (check_fwstate(pmlmepriv, WIFI_AP_STATE) == _TRUE)
			report_sta_timeout_event(padapter, psta->phl_sta->mac_addr, WLAN_REASON_PREV_AUTH_NOT_VALID);
	} else if(psta->sa_query_cnt < SA_QUERY_MAX_NUM) {
		psta->sa_query_cnt++;
		RTW_ERR("[%s]macid %d, issue SA query req, cnt = %d\n",
				__func__, psta->phl_sta->macid, psta->sa_query_cnt);
		issue_action_SA_Query(padapter, psta->phl_sta->mac_addr, 0, 0, IEEE80211W_RIGHT_KEY);
		_set_timer(&psta->dot11w_expire_timer, SA_QUERY_RETRY_TO);
	}
}

#endif /* CONFIG_IEEE80211W */

#ifdef CONFIG_RTW_80211R
void rtw_ft_update_bcn(_adapter *padapter, union recv_frame *precv_frame)
{
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	u8 *pframe = precv_frame->u.hdr.rx_data;
	uint len = precv_frame->u.hdr.len;
	WLAN_BSSID_EX *pbss;

	if (rtw_ft_chk_status(padapter,RTW_FT_ASSOCIATED_STA)
		&& (pmlmepriv->ft_roam.ft_updated_bcn == _FALSE)) {
		pbss = (WLAN_BSSID_EX*)rtw_malloc(sizeof(WLAN_BSSID_EX));
		if (pbss) {
			if (collect_bss_info(padapter, precv_frame, pbss) == _SUCCESS) {
				struct beacon_keys recv_beacon;

				update_network(&(pmlmepriv->cur_network.network), pbss, padapter, _TRUE);

				/* update bcn keys */
				if (rtw_get_bcn_keys(padapter, pframe, len, &recv_beacon) == _TRUE) {
					RTW_INFO("%s: beacon keys ready\n", __func__);
					_rtw_memcpy(&pmlmepriv->cur_beacon_keys,
						&recv_beacon, sizeof(recv_beacon));
					if (is_hidden_ssid(recv_beacon.ssid, recv_beacon.ssid_len)) {
						_rtw_memcpy(pmlmepriv->cur_beacon_keys.ssid, pmlmeinfo->network.Ssid.Ssid, IW_ESSID_MAX_SIZE);
						pmlmepriv->cur_beacon_keys.ssid_len = pmlmeinfo->network.Ssid.SsidLength;
					}
				} else {
					RTW_ERR("%s: get beacon keys failed\n", __func__);
					_rtw_memset(&pmlmepriv->cur_beacon_keys, 0, sizeof(recv_beacon));
				}
			}
			rtw_mfree((u8*)pbss, sizeof(WLAN_BSSID_EX));
		}

		/* check the vendor of the assoc AP */
		pmlmeinfo->assoc_AP_vendor =
			check_assoc_AP(pframe+sizeof(struct rtw_ieee80211_hdr_3addr),
				(len - sizeof(struct rtw_ieee80211_hdr_3addr)));

		/* update TSF Value */
		update_TSF(pmlmeext, pframe, len);
		pmlmeext->bcn_cnt = 0;
		pmlmeext->last_bcn_cnt = 0;
		pmlmepriv->ft_roam.ft_updated_bcn = _TRUE;
	}
}

void rtw_ft_start_clnt_join(_adapter *padapter)
{
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct	mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct ft_roam_info *pft_roam = &(pmlmepriv->ft_roam);

	if (rtw_ft_otd_roam(padapter)) {
		pmlmeinfo->state = WIFI_FW_AUTH_SUCCESS | WIFI_FW_STATION_STATE;
		pft_roam->ft_event.ies =
			(pft_roam->ft_action + sizeof(struct rtw_ieee80211_hdr_3addr) + 16);
		pft_roam->ft_event.ies_len =
			(pft_roam->ft_action_len - sizeof(struct rtw_ieee80211_hdr_3addr));

		/*Not support RIC*/
		pft_roam->ft_event.ric_ies =  NULL;
		pft_roam->ft_event.ric_ies_len = 0;
		rtw_ft_report_evt(padapter);
		return;
	}

	pmlmeinfo->state = WIFI_FW_AUTH_NULL | WIFI_FW_STATION_STATE;
	start_clnt_auth(padapter);
}

u8 rtw_ft_update_rsnie(
	_adapter *padapter, u8 bwrite,
	struct pkt_attrib *pattrib, u8 **pframe)
{
	struct ft_roam_info *pft_roam = &(padapter->mlmepriv.ft_roam);
	u8 *pie;
	u32 len;

	pie = rtw_get_ie(pft_roam->updated_ft_ies, EID_WPA2, &len,
			pft_roam->updated_ft_ies_len);

	if (!bwrite)
		return (pie)?_SUCCESS:_FAIL;

	if (pie) {
		*pframe = rtw_set_ie(((u8 *)*pframe), EID_WPA2, len,
						pie+2, &(pattrib->pktlen));
	} else
		return _FAIL;

	return _SUCCESS;
}

static u8 rtw_ft_update_mdie(
	_adapter *padapter, struct pkt_attrib *pattrib, u8 **pframe)
{
	struct ft_roam_info *pft_roam = &(padapter->mlmepriv.ft_roam);
	u8 *pie, mdie[3];
	u32 len = 3;

	if (rtw_ft_roam(padapter)) {
		if ((pie = rtw_get_ie(pft_roam->updated_ft_ies, _MDIE_,
				&len, pft_roam->updated_ft_ies_len))) {
			pie = (pie + 2); /* ignore md-id & length */
		} else
			return _FAIL;
	} else {
		*((u16 *)&mdie[0]) = pft_roam->mdid;
		mdie[2] = pft_roam->ft_cap;
		pie = &mdie[0];
	}

	*pframe = rtw_set_ie(((u8 *)*pframe), _MDIE_, len , pie, &(pattrib->pktlen));
	return _SUCCESS;
}

static u8 rtw_ft_update_ftie(
	_adapter *padapter, struct pkt_attrib *pattrib, u8 **pframe)
{
	struct ft_roam_info *pft_roam = &(padapter->mlmepriv.ft_roam);
	u8 *pie;
	u32 len;

	if ((pie = rtw_get_ie(pft_roam->updated_ft_ies, _FTIE_, &len,
				pft_roam->updated_ft_ies_len)) != NULL) {
		*pframe = rtw_set_ie(*pframe, _FTIE_, len ,
					(pie+2), &(pattrib->pktlen));
	} else
		return _FAIL;

	return _SUCCESS;
}

void rtw_ft_build_auth_req_ies(_adapter *padapter,
	struct pkt_attrib *pattrib, u8 **pframe)
{
	u8 ftie_append = _TRUE;

	if (!pattrib || !(*pframe))
		return;

	if (!rtw_ft_roam(padapter))
		return;

	ftie_append = rtw_ft_update_rsnie(padapter, _TRUE, pattrib, pframe);
	rtw_ft_update_mdie(padapter, pattrib, pframe);
	if (ftie_append)
		rtw_ft_update_ftie(padapter, pattrib, pframe);
}

void rtw_ft_build_auth_rsp_ies(_adapter *padapter,
	struct pkt_attrib *pattrib, u8 **pframe)
{
	u8 ftie_append = _TRUE;

	if (!pattrib || !(*pframe))
		return;

	if (!rtw_ft_enable(padapter))
		return;

	ftie_append = rtw_ft_update_rsnie(padapter, _TRUE, pattrib, pframe);
	rtw_ft_update_mdie(padapter, pattrib, pframe);
	if (ftie_append)
		rtw_ft_update_ftie(padapter, pattrib, pframe);
}

void rtw_ft_build_assoc_req_ies(_adapter *padapter,
	u8 is_reassoc, struct pkt_attrib *pattrib, u8 **pframe)
{
	if (!pattrib || !(*pframe))
		return;

	if (rtw_ft_chk_flags(padapter, RTW_FT_PEER_EN))
		rtw_ft_update_mdie(padapter, pattrib, pframe);

	if ((!is_reassoc) || (!rtw_ft_roam(padapter)))
		return;

	if (rtw_ft_update_rsnie(padapter, _FALSE, pattrib, pframe))
		rtw_ft_update_ftie(padapter, pattrib, pframe);
}

void rtw_ft_build_assoc_rsp_ies(_adapter *padapter,
	u8 is_reassoc, struct pkt_attrib *pattrib, u8 **pframe)
{
	if (!pattrib || !(*pframe))
		return;

	if (!rtw_ft_enable(padapter))
		return;

#if !defined(CONFIG_HAPD_OWE) && !defined(DIRECT_HAPD_RSN_IE)
	if (is_reassoc)
		rtw_ft_update_rsnie(padapter, _TRUE, pattrib, pframe);
#endif /* !CONFIG_HAPD_OWE && !DIRECT_HAPD_RSN_IE */

	rtw_ft_update_mdie(padapter, pattrib, pframe);
	rtw_ft_update_ftie(padapter, pattrib, pframe);
}

u8 rtw_ft_update_auth_rsp_ies(_adapter *padapter, u8 *pframe, u32 len)
{
	u8 ret = _SUCCESS;
	u8 target_ap_addr[ETH_ALEN] = {0};
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct ft_roam_info *pft_roam = &(pmlmepriv->ft_roam);

	if (!rtw_ft_roam(padapter))
		return _FAIL;

	/*rtw_ft_report_reassoc_evt already,
	 * and waiting for cfg80211_rtw_update_ft_ies */
	if (rtw_ft_authed_sta(padapter))
		return ret;

	if (!pframe || !len)
		return _FAIL;

	rtw_buf_update(&pmlmepriv->auth_rsp,
		&pmlmepriv->auth_rsp_len, pframe, len);
	pft_roam->ft_event.ies =
		(pmlmepriv->auth_rsp + sizeof(struct rtw_ieee80211_hdr_3addr) + 6);
	pft_roam->ft_event.ies_len =
		(pmlmepriv->auth_rsp_len - sizeof(struct rtw_ieee80211_hdr_3addr) - 6);

	/*Not support RIC*/
	pft_roam->ft_event.ric_ies =  NULL;
	pft_roam->ft_event.ric_ies_len =  0;
	_rtw_memcpy(target_ap_addr, pmlmepriv->assoc_bssid, ETH_ALEN);
	rtw_ft_report_reassoc_evt(padapter, target_ap_addr);

	return ret;
}

static void rtw_ft_start_clnt_action(_adapter *padapter, u8 *pTargetAddr)
{
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;

	rtw_ft_set_status(padapter, RTW_FT_REQUESTING_STA);
	rtw_ft_issue_action_req(padapter, pTargetAddr);
	_set_timer(&pmlmeext->ft_link_timer, REASSOC_TO);
}

void rtw_ft_start_roam(_adapter *padapter, u8 *pTargetAddr)
{
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;

	if (rtw_ft_otd_roam(padapter)) {
		rtw_ft_start_clnt_action(padapter, pTargetAddr);
	} else {
		/*wait a little time to retrieve packets buffered in the current ap while scan*/
		_set_timer(&pmlmeext->ft_roam_timer, 30);
	}
}

void rtw_ft_issue_action_req(_adapter *padapter, u8 *pTargetAddr)
{
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct xmit_priv *pxmitpriv = &(padapter->xmitpriv);
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct xmit_frame *pmgntframe;
	struct rtw_ieee80211_hdr *pwlanhdr;
	struct pkt_attrib *pattrib;
	u8 *pframe;
	u8 category = RTW_WLAN_CATEGORY_FT;
	u8 action = RTW_WLAN_ACTION_FT_REQ;

	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL)
		return;

	pattrib = &pmgntframe->attrib;
	if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
		rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
		return;
	}
	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);

	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;
	pwlanhdr->frame_ctl = 0;

	_rtw_memcpy(pwlanhdr->addr1, get_my_bssid(&pmlmeinfo->network), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr2, adapter_mac_addr(padapter), ETH_ALEN);
	_rtw_memcpy(pwlanhdr->addr3, get_my_bssid(&pmlmeinfo->network), ETH_ALEN);

	SetSeqNum(pwlanhdr, pmlmeext->mgnt_seq);
	pmlmeext->mgnt_seq++;
	set_frame_sub_type(pframe, WIFI_ACTION);

	pframe += sizeof(struct rtw_ieee80211_hdr_3addr);
	pattrib->pktlen = sizeof(struct rtw_ieee80211_hdr_3addr);

	pframe = rtw_set_fixed_ie(pframe, 1, &(category), &(pattrib->pktlen));
	pframe = rtw_set_fixed_ie(pframe, 1, &(action), &(pattrib->pktlen));

	_rtw_memcpy(pframe, adapter_mac_addr(padapter), ETH_ALEN);
	pframe += ETH_ALEN;
	pattrib->pktlen += ETH_ALEN;

	_rtw_memcpy(pframe, pTargetAddr, ETH_ALEN);
	pframe += ETH_ALEN;
	pattrib->pktlen += ETH_ALEN;

	rtw_ft_update_mdie(padapter, pattrib, &pframe);
	if (rtw_ft_update_rsnie(padapter, _TRUE, pattrib, &pframe))
		rtw_ft_update_ftie(padapter, pattrib, &pframe);

	pattrib->last_txcmdsz = pattrib->pktlen;
	dump_mgntframe(padapter, pmgntframe);
}

void rtw_ft_report_evt(_adapter *padapter)
{
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct ft_roam_info *pft_roam = &(pmlmepriv->ft_roam);
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX *pnetwork = (WLAN_BSSID_EX *)&(pmlmeinfo->network);
	struct cfg80211_ft_event_params ft_evt_parms;

	_rtw_memset(&ft_evt_parms, 0, sizeof(ft_evt_parms));
	rtw_ft_update_stainfo(padapter, pnetwork);

	if (!pnetwork)
		goto err_2;

	ft_evt_parms.ies_len = pft_roam->ft_event.ies_len;
	ft_evt_parms.ies =  rtw_zmalloc(ft_evt_parms.ies_len);
	if (ft_evt_parms.ies)
		_rtw_memcpy((void *)ft_evt_parms.ies, pft_roam->ft_event.ies, ft_evt_parms.ies_len);
	 else
		goto err_2;

	ft_evt_parms.target_ap = rtw_zmalloc(ETH_ALEN);
	if (ft_evt_parms.target_ap)
		_rtw_memcpy((void *)ft_evt_parms.target_ap, pnetwork->MacAddress, ETH_ALEN);
	else
		goto err_1;

	ft_evt_parms.ric_ies = pft_roam->ft_event.ric_ies;
	ft_evt_parms.ric_ies_len = pft_roam->ft_event.ric_ies_len;

	rtw_ft_lock_set_status(padapter, RTW_FT_AUTHENTICATED_STA);
	rtw_cfg80211_ft_event(padapter, &ft_evt_parms);
	RTW_INFO("FT: rtw_ft_report_evt\n");
	rtw_mfree((u8 *)pft_roam->ft_event.target_ap, ETH_ALEN);
err_1:
	rtw_mfree((u8 *)ft_evt_parms.ies, ft_evt_parms.ies_len);
err_2:
	return;
}

void rtw_ft_report_reassoc_evt(_adapter *padapter, u8 *pMacAddr)
{
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct cmd_priv *pcmdpriv = &(adapter_to_dvobj(padapter)->cmdpriv);
	struct cmd_obj *pcmd_obj = NULL;
	struct stassoc_event *passoc_sta_evt = NULL;
	struct rtw_evt_header *evt_hdr = NULL;
	u8 *pevtcmd = NULL;
	u32 cmdsz = 0;

	pcmd_obj = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (pcmd_obj == NULL)
		return;
	pcmd_obj->padapter = padapter;

	cmdsz = (sizeof(struct stassoc_event) + sizeof(struct rtw_evt_header));
	pevtcmd = (u8 *)rtw_zmalloc(cmdsz);
	if (pevtcmd == NULL) {
		rtw_mfree((u8 *)pcmd_obj, sizeof(struct cmd_obj));
		return;
	}

	_rtw_init_listhead(&pcmd_obj->list);
	pcmd_obj->cmdcode = CMD_SET_MLME_EVT;
	pcmd_obj->cmdsz = cmdsz;
	pcmd_obj->parmbuf = pevtcmd;
	pcmd_obj->rsp = NULL;
	pcmd_obj->rspsz  = 0;

	evt_hdr = (struct rtw_evt_header *)(pevtcmd);
	evt_hdr->len = sizeof(struct stassoc_event);
	evt_hdr->id = EVT_FT_REASSOC;
	evt_hdr->seq = ATOMIC_INC_RETURN(&pmlmeext->event_seq);

	passoc_sta_evt = (struct stassoc_event *)(pevtcmd + sizeof(struct rtw_evt_header));
	_rtw_memcpy((unsigned char *)(&(passoc_sta_evt->macaddr)), pMacAddr, ETH_ALEN);
	rtw_enqueue_cmd(pcmdpriv, pcmd_obj);
}

void rtw_ft_link_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct ft_roam_info *pft_roam = &(pmlmepriv->ft_roam);

	if (rtw_ft_chk_status(padapter, RTW_FT_REQUESTING_STA)) {
		if (pft_roam->ft_req_retry_cnt < RTW_FT_ACTION_REQ_LMT) {
			pft_roam->ft_req_retry_cnt++;
			rtw_ft_issue_action_req(padapter, (u8 *)pmlmepriv->roam_network->network.MacAddress);
			_set_timer(&pmlmeext->ft_link_timer, REASSOC_TO);
		} else {
			pft_roam->ft_req_retry_cnt = 0;
			if (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS)
				rtw_ft_set_status(padapter, RTW_FT_ASSOCIATED_STA);
			else
				rtw_ft_reset_status(padapter);
		}
	}
}

void rtw_ft_roam_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);

	receive_disconnect(padapter, pmlmepriv->cur_network.network.MacAddress
				, WLAN_REASON_ACTIVE_ROAM, _FALSE);
}

void rtw_ft_roam_status_reset(_adapter *padapter)
{
	struct ft_roam_info *pft_roam = &(padapter->mlmepriv.ft_roam);

	if ((rtw_to_roam(padapter) > 0) &&
		(!rtw_ft_chk_status(padapter, RTW_FT_REQUESTED_STA))) {
		rtw_ft_reset_status(padapter);
	}

	padapter->mlmepriv.ft_roam.ft_updated_bcn = _FALSE;
}
#endif

#ifdef CONFIG_AUTO_AP_MODE
void rtw_auto_ap_rx_msg_dump(_adapter *padapter, union recv_frame *precv_frame, u8 *ehdr_pos)
{
	struct rx_pkt_attrib *pattrib = &precv_frame->u.hdr.attrib;
	struct sta_info *psta = precv_frame->u.hdr.psta;
	struct ethhdr *ehdr = (struct ethhdr *)ehdr_pos;

	RTW_INFO("eth rx: got eth_type=0x%x\n", ntohs(ehdr->h_proto));

	if (psta && psta->isrc && psta->pid > 0) {
		u16 rx_pid;

		rx_pid = *(u16 *)(ehdr_pos + ETH_HLEN);

		RTW_INFO("eth rx(pid=0x%x): sta("MAC_FMT") pid=0x%x\n",
			 rx_pid, MAC_ARG(psta->phl_sta->mac_addr), psta->pid);

		if (rx_pid == psta->pid) {
			int i;
			u16 len = *(u16 *)(ehdr_pos + ETH_HLEN + 2);
			/* u16 ctrl_type = *(u16 *)(ehdr_pos + ETH_HLEN + 4); */

			/* RTW_INFO("eth, RC: len=0x%x, ctrl_type=0x%x\n", len, ctrl_type);  */
			RTW_INFO("eth, RC: len=0x%x\n", len);

			for (i = 0; i < len; i++)
				RTW_INFO("0x%x\n", *(ehdr_pos + ETH_HLEN + 4 + i));
			/* RTW_INFO("0x%x\n", *(ehdr_pos + ETH_HLEN + 6 + i)); */

			RTW_INFO("eth, RC-end\n");
		}
	}

}

void rtw_start_auto_ap(_adapter *adapter)
{
	RTW_INFO("%s\n", __FUNCTION__);

	rtw_set_802_11_infrastructure_mode(adapter, Ndis802_11APMode, 0);

	rtw_setopmode_cmd(adapter, Ndis802_11APMode, RTW_CMDF_WAIT_ACK);
}

static int rtw_auto_ap_start_beacon(_adapter *adapter)
{
	int ret = 0;
	u8 *pbuf = NULL;
	uint len;
	u8	supportRate[16];
	int	sz = 0, rateLen;
	u8	*ie;
	u8	wireless_mode, oper_channel;
	u8 ssid[3] = {0}; /* hidden ssid */
	u32 ssid_len = sizeof(ssid);
	struct mlme_priv *pmlmepriv = &(adapter->mlmepriv);

	if (check_fwstate(pmlmepriv, WIFI_AP_STATE) != _TRUE)
		return -EINVAL;


	len = 128;
	pbuf = rtw_zmalloc(len);
	if (!pbuf)
		return -ENOMEM;


	/* generate beacon */
	ie = pbuf;

	/* timestamp will be inserted by hardware */
	sz += 8;
	ie += sz;

	/* beacon interval : 2bytes */
	*(u16 *)ie = cpu_to_le16((u16)100); /* BCN_INTERVAL=100; */
	sz += 2;
	ie += 2;

	/* capability info */
	*(u16 *)ie = 0;
	*(u16 *)ie |= cpu_to_le16(cap_ESS);
	*(u16 *)ie |= cpu_to_le16(cap_ShortPremble);
	/* *(u16*)ie |= cpu_to_le16(cap_Privacy); */
	sz += 2;
	ie += 2;

	/* SSID */
	ie = rtw_set_ie(ie, _SSID_IE_, ssid_len, ssid, &sz);

	/* Get OP ch */
	if (rtw_mi_check_status(adapter, MI_LINKED))
		oper_channel = rtw_mi_get_union_chan(adapter);
	else
		oper_channel = adapter_to_dvobj(adapter)->oper_channel;

	/* supported rates */
	wireless_mode = (WIRELESS_11BG_24N & adapter->registrypriv.wireless_mode);
	rtw_set_supported_rate(supportRate, wireless_mode, oper_channel);
	rateLen = rtw_get_rateset_len(supportRate);
	if (rateLen > 8)
		ie = rtw_set_ie(ie, _SUPPORTEDRATES_IE_, 8, supportRate, &sz);
	else
		ie = rtw_set_ie(ie, _SUPPORTEDRATES_IE_, rateLen, supportRate, &sz);

	/* DS parameter set */
	ie = rtw_set_ie(ie, _DSSET_IE_, 1, &oper_channel, &sz);

	/* ext supported rates */
	if (rateLen > 8)
		ie = rtw_set_ie(ie, _EXT_SUPPORTEDRATES_IE_, (rateLen - 8), (supportRate + 8), &sz);

	RTW_INFO("%s, start auto ap beacon sz=%d\n", __FUNCTION__, sz);

	/* lunch ap mode & start to issue beacon */
	if (rtw_check_beacon_data(adapter, pbuf,  sz) == _SUCCESS) {

	} else
		ret = -EINVAL;


	rtw_mfree(pbuf, len);

	return ret;

}
#endif/* CONFIG_AUTO_AP_MODE */

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
u8 tx_control_hdl(_adapter *adapter)
{
	u8 val;

	if(ATOMIC_READ(&adapter->tbtx_tx_pause))
		val = 0xff;
	else
		val = 0x00;

	rtw_hal_set_hwreg(adapter, HW_VAR_TXPAUSE, &val);

	return H2C_SUCCESS;
}
#endif

#ifdef CONFIG_AP_MODE
u8 stop_ap_hdl(_adapter *adapter)
{
	void *phl = GET_HAL_INFO(adapter_to_dvobj(adapter));
	struct rtw_wifi_role_t *wrole = adapter->phl_role;
	int chanctx_num = 0;
	struct rtw_chan_def chan_def = {0};

	RTW_INFO(FUNC_ADPT_FMT"\n", FUNC_ADPT_ARG(adapter));

	rtw_set_802_11_infrastructure_mode(adapter, Ndis802_11Infrastructure, RTW_CMDF_DIRECTLY);
	rtw_setopmode_cmd(adapter, Ndis802_11Infrastructure, RTW_CMDF_DIRECTLY);

	rtw_phl_free_bcn_entry(phl, adapter->phl_role);
	_rtw_memset(&wrole->bcn_cmn, 0, sizeof(wrole->bcn_cmn));

	chanctx_num = rtw_phl_chanctx_del(phl, adapter->phl_role, &chan_def);

	if (chanctx_num && chan_def.chan != 0)
		RTW_ERR("[%s]chan_def.chan is not 0!\n", __func__);

	return H2C_SUCCESS;
}
#endif

u8 setopmode_hdl(_adapter *padapter, u8 *pbuf)
{
	u8			type;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct setopmode_parm	*psetop = (struct setopmode_parm *)pbuf;

	switch (psetop->mode) {
		case Ndis802_11APMode:
		case Ndis802_11_mesh:
			pmlmeinfo->state = WIFI_FW_AP_STATE;
			#ifdef CONFIG_RTW_SUPPORT_MBSSID_VAP
			/* Virtual interface is VAP if primary adapter is AP */
			if (   !is_primary_adapter(padapter)
			    && (MLME_IS_AP(GET_PRIMARY_ADAPTER(padapter)))) {
				pmlmeinfo->state = WIFI_FW_VAP_STATE;
				type = _HW_STATE_VAP_;
				break;
			}
			#endif /* CONFIG_RTW_SUPPORT_MBSSID_VAP */
			type = _HW_STATE_AP_;
			break;
		case Ndis802_11Infrastructure:
			pmlmeinfo->state &= ~WIFI_FW_STATE_MASK; /* clear state */
			pmlmeinfo->state |= WIFI_FW_STATION_STATE;/* set to 	STATION_STATE */
			type = _HW_STATE_STATION_;
			break;
		case Ndis802_11IBSS:
			type = _HW_STATE_ADHOC_;
			break;
		case Ndis802_11Monitor:
			type = _HW_STATE_MONITOR_;
			break;
		default:
			type = _HW_STATE_NOLINK_;
			break;
	}

	if (NULL == padapter->phl_role
		|| _FAIL == rtw_hw_iface_type_change(padapter, type)) {
		RTW_ERR("%s %s - change iface type fails !\n", __func__,
			padapter->pnetdev->name);
		return H2C_CMD_FAIL;
	}

#ifdef CONFIG_AP_PORT_SWAP
	rtw_hal_set_hwreg(padapter, HW_VAR_PORT_SWITCH, (u8 *)(&type));
#endif

	rtw_hal_set_hwreg(padapter, HW_VAR_SET_OPMODE, (u8 *)(&type));

#ifdef CONFIG_AUTO_AP_MODE
	if (psetop->mode == Ndis802_11APMode)
		rtw_auto_ap_start_beacon(padapter);
#endif

	return H2C_SUCCESS;

}

u8 createbss_hdl(_adapter *padapter, u8 *pbuf)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX	*pnetwork = (WLAN_BSSID_EX *)(&(pmlmeinfo->network));
	WLAN_BSSID_EX	*pdev_network = &padapter->registrypriv.dev_network;
	struct createbss_parm *parm = (struct createbss_parm *)pbuf;
	u8 ret = H2C_SUCCESS;
	/* u8	initialgain; */

#if defined(CONFIG_RTW_DEBUG_MBSSID_VAP) && (CONFIG_RTW_DEBUG_MBSSID_VAP > 0)
	RTW_INFO(FUNC_ADPT_FMT" RC%u ST%u\n", FUNC_ADPT_ARG(padapter),
	         parm->req_ch, pmlmeinfo->state);
#endif /* CONFIG_RTW_DEBUG_MBSSID_VAP */

#ifdef CONFIG_AP_MODE
	if (   ((parm->req_ch == 0) && MLME_IN_AP_STATE(pmlmeinfo))
	    || parm->req_ch != 0) {
		start_bss_network(padapter, parm);
		goto exit;
	}
#endif

	/* below is for ad-hoc master */
	if (parm->adhoc) {
		rtw_warn_on(pdev_network->InfrastructureMode != Ndis802_11IBSS);
		rtw_joinbss_reset(padapter);

		pmlmeext->cur_bwmode = CHANNEL_WIDTH_20;
		pmlmeext->cur_ch_offset = CHAN_OFFSET_NO_EXT;
		pmlmeinfo->ERP_enable = 0;
		pmlmeinfo->WMM_enable = 0;
		pmlmeinfo->HT_enable = 0;
		pmlmeinfo->HT_caps_enable = 0;
		pmlmeinfo->HT_info_enable = 0;
		pmlmeinfo->agg_enable_bitmap = 0;
		pmlmeinfo->candidate_tid_bitmap = 0;

		/* cancel link timer */
		_cancel_timer_ex(&pmlmeext->link_timer);

		/* clear CAM */
		flush_all_cam_entry(padapter);

		pdev_network->Length = get_WLAN_BSSID_EX_sz(pdev_network);
		_rtw_memcpy(pnetwork, pdev_network, FIELD_OFFSET(WLAN_BSSID_EX, IELength));
		pnetwork->IELength = pdev_network->IELength;

		if (pnetwork->IELength > MAX_IE_SZ) {
			ret = H2C_PARAMETERS_ERROR;
			goto ibss_post_hdl;
		}

		_rtw_memcpy(pnetwork->IEs, pdev_network->IEs, pnetwork->IELength);
		start_create_ibss(padapter);
	} else {
		rtw_warn_on(1);
		ret = H2C_PARAMETERS_ERROR;
	}

ibss_post_hdl:
	rtw_create_ibss_post_hdl(padapter, ret);

exit:
	return ret;
}

static void set_hw_before_join(struct _ADAPTER *a)
{
	struct mlme_ext_priv *pmlmeext = &a->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &pmlmeext->mlmext_info;
	struct _WLAN_BSSID_EX *pnetwork = &pmlmeinfo->network;
	struct sta_info *sta;
	enum mlme_state mlme_sts;

	/* check already connecting to AP or not */
	if (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS) {
		if (pmlmeinfo->state & WIFI_FW_STATION_STATE)
			issue_deauth_ex(a, pnetwork->MacAddress,
					WLAN_REASON_DEAUTH_LEAVING, 1, 100);
		pmlmeinfo->state = WIFI_FW_NULL_STATE;
		_cancel_timer_ex(&pmlmeext->link_timer);

		sta = rtw_get_stainfo(&a->stapriv, pnetwork->MacAddress);
		if (sta)
			rtw_hw_disconnect(a, sta);
		else
			RTW_ERR(FUNC_ADPT_FMT ": can't find drv sta info for "
				MAC_FMT " !\n",
				FUNC_ADPT_ARG(a),
				MAC_ARG(pnetwork->MacAddress));
	}

	mlme_sts = MLME_LINKING;
	/*reset hw before connection if necessary*/

}

static void update_join_info(struct _ADAPTER *a,
				   struct _WLAN_BSSID_EX *pbuf)
{
	struct mlme_ext_priv *pmlmeext = &a->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &pmlmeext->mlmext_info;
	struct wifi_mib_priv *pmibpriv = &a->registrypriv.wifi_mib;
	struct _WLAN_BSSID_EX *pnetwork = &pmlmeinfo->network;
	struct _NDIS_802_11_VARIABLE_IEs *pIE;
	u32 i;
	u8 join_type;
	u8 ht = 0, vht = 0;

	a->mlmepriv.num_FortyMHzIntolerant = 0;
	a->mlmepriv.num_sta_no_ht = 0;
	a->mlmepriv.htpriv.ampdu_enable = _FALSE;/* reset to disabled */

	pmlmeinfo->ERP_enable = 0;
	pmlmeinfo->WMM_enable = 0;
	pmlmeinfo->HT_enable = 0;
	pmlmeinfo->HT_caps_enable = 0;
	pmlmeinfo->HT_info_enable = 0;
	pmlmeinfo->agg_enable_bitmap = 0;
	pmlmeinfo->candidate_tid_bitmap = 0;
	pmlmeinfo->bwmode_updated = _FALSE;
	/* pmlmeinfo->assoc_AP_vendor = HT_IOT_PEER_MAX; */
	pmlmeinfo->VHT_enable = 0;
	pmlmeinfo->HE_enable = 0;
#ifdef ROKU_PRIVATE
	pmlmeinfo->ht_vht_received = 0;
	_rtw_memset(pmlmeinfo->SupportedRates_infra_ap, 0, NDIS_802_11_LENGTH_RATES_EX);
#endif /* ROKU_PRIVATE */
	_rtw_memcpy(pnetwork, pbuf, FIELD_OFFSET(WLAN_BSSID_EX, IELength));
	pnetwork->IELength = pbuf->IELength;
	_rtw_memcpy(pnetwork->IEs, ((WLAN_BSSID_EX *)pbuf)->IEs, pnetwork->IELength);

	pmlmeinfo->bcn_interval = get_beacon_interval(pnetwork);

	/* sizeof(NDIS_802_11_FIXED_IEs)	 */
	for (i = _FIXED_IE_LENGTH_; i < (pnetwork->IELength - 2);) {
		pIE = (struct _NDIS_802_11_VARIABLE_IEs*)(pnetwork->IEs + i);

		switch (pIE->ElementID) {
		case _VENDOR_SPECIFIC_IE_: /* Get WMM IE. */
			if (_rtw_memcmp(pIE->data, WMM_OUI, 4))
				WMM_param_handler(a, pIE);
			break;

#ifdef CONFIG_80211N_HT
		case _HT_CAPABILITY_IE_:	/* Get HT Cap IE. */
			pmlmeinfo->HT_enable = 1;
			pmlmeinfo->HT_caps_enable = 1;
			break;

		case _HT_EXTRA_INFO_IE_:	/* Get HT Info IE. */
			pmlmeinfo->HT_enable = 1;
			pmlmeinfo->HT_info_enable = 1;
			break;
#endif /* CONFIG_80211N_HT */

#ifdef CONFIG_80211AC_VHT
		case EID_VHTCapability: /* Get VHT Cap IE. */
			pmlmeinfo->VHT_enable = 1;
			break;

		case EID_VHTOperation: /* Get VHT Operation IE. */
			break;
#endif /* CONFIG_80211AC_VHT */

#ifdef CONFIG_80211AX_HE
		case WLAN_EID_EXTENSION:
			if (pIE->data[0] == WLAN_EID_EXTENSION_HE_CAPABILITY)
				pmlmeinfo->HE_enable = 1;
			break;
#endif /* CONFIG_80211AX_HE */

		default:
			break;
		}

		i += (pIE->Length + 2);
	}

	if (pmlmeinfo->HT_enable && (pmibpriv->band & WLAN_MD_11N))
		ht = 1;
	if (pmlmeinfo->VHT_enable && (pmibpriv->band & WLAN_MD_11AC))
		vht = 1;

	/*get chan/bw/offset info from IEs*/
	rtw_bss_get_chbw(pnetwork,
			 &pmlmeext->cur_channel, &pmlmeext->cur_bwmode,
			 &pmlmeext->cur_ch_offset, ht, vht);

	/*adjust chan/bw/offset with registary and hw cap*/
	rtw_adjust_chbw(a, pmlmeext->cur_channel, &pmlmeext->cur_bwmode,
			&pmlmeext->cur_ch_offset);
}
static void set_hw_prepare_connect(_adapter *padapter, struct sta_info *sta)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &pmlmeext->mlmext_info;
	WLAN_BSSID_EX		*pnetwork = &pmlmeinfo->network;

#ifdef CONFIG_ANTENNA_DIVERSITY
	rtw_antenna_select_cmd(padapter, pnetwork->PhyInfo.Optimum_antenna, _FALSE);
#endif
	rtw_hw_prepare_connect(padapter, sta, pnetwork->MacAddress);
}

u8 rtw_join_cmd_hdl(_adapter *padapter, u8 *pbuf)
{
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &pmlmeext->mlmext_info;
	WLAN_BSSID_EX		*pnetwork = &pmlmeinfo->network;
	struct sta_info *sta = NULL;
	u8 u_ch, u_bw, u_offset;

	/* Check pbuf->IELength */
	if (((struct _WLAN_BSSID_EX*)pbuf)->IELength > MAX_IE_SZ)
		return H2C_PARAMETERS_ERROR;

	if (((struct _WLAN_BSSID_EX*)pbuf)->IELength < 2) {
		report_join_res(padapter, (-4), WLAN_STATUS_UNSPECIFIED_FAILURE);
		return H2C_SUCCESS;
	}

	set_hw_before_join(padapter);

	/*update HT/VHT/HE CAP and chan/bw/offset from join_info-pbuf*/
	update_join_info(padapter, (struct _WLAN_BSSID_EX *)pbuf);

	sta = rtw_get_stainfo(&padapter->stapriv, padapter->phl_role->mac_addr);
	rtw_free_stainfo(padapter, sta);
	sta = rtw_get_stainfo(&padapter->stapriv, pnetwork->MacAddress);
	rtw_free_stainfo(padapter, sta);
	sta = rtw_alloc_stainfo(&padapter->stapriv, pnetwork->MacAddress, PHL_CMD_DIRECTLY);
	if (sta == NULL) {
		RTW_ERR("alloc sta "MAC_FMT" fail\n", MAC_ARG(pnetwork->MacAddress));
		return H2C_CMD_FAIL;
	}

	/* update channel, band */
	sta->phl_sta->chandef.chan = pnetwork->Configuration.DSConfig;
	sta->phl_sta->chandef.band = (pnetwork->Configuration.DSConfig > 14) ? BAND_ON_5G : BAND_ON_24G;

	/* check channel, bandwidth, offset and switch */
	/* TODO : rtw_phl_mi_chan_ctx check*/
	if (rtw_chk_start_clnt_join(padapter, &u_ch, &u_bw, &u_offset) == _FAIL) {
		report_join_res(padapter, (-4), WLAN_STATUS_UNSPECIFIED_FAILURE);
		return H2C_SUCCESS;
	}

	/*allow for connection*/
	set_hw_prepare_connect(padapter, sta);

	rtw_hw_update_chan_def(padapter);
	set_channel_bwmode(padapter, u_ch, u_offset, u_bw, _TRUE);
	rtw_mi_update_union_chan_inf(padapter, u_ch, u_offset, u_bw);

	/* cancel link timer */
	_cancel_timer_ex(&pmlmeext->link_timer);

	/*Client and AD-Hoc client*/
	start_clnt_join(padapter);

	return H2C_SUCCESS;
}

u8 disconnect_hdl(_adapter *padapter, unsigned char *pbuf)
{
#if CONFIG_DFS
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
#endif
	struct disconnect_parm *param = (struct disconnect_parm *)pbuf;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	WLAN_BSSID_EX		*pnetwork = (WLAN_BSSID_EX *)(&(pmlmeinfo->network));
	u8 val8;

	/* For STA, disconnect flow only for conneted case */
	if (MLME_IS_STA(padapter) && !MLME_IS_ASOC(padapter))
		goto exit;

	if (is_client_associated_to_ap(padapter)
#if CONFIG_DFS
		&& !IS_RADAR_DETECTED(rfctl)
#endif
		&& !rfctl->csa_ch
	) {
		#ifdef CONFIG_PLATFORM_ROCKCHIPS
		/* To avoid connecting to AP fail during resume process, change retry count from 5 to 1 */
		issue_deauth_ex(padapter, pnetwork->MacAddress, WLAN_REASON_DEAUTH_LEAVING, 1, 100);
		#else
		issue_deauth_ex(padapter, pnetwork->MacAddress, WLAN_REASON_DEAUTH_LEAVING, param->deauth_timeout_ms / 100, 100);
		#endif /* CONFIG_PLATFORM_ROCKCHIPS */
	}

	if (MLME_IS_STATE(pmlmeinfo, WIFI_FW_ADHOC_STATE) || MLME_IN_AP_STATE(pmlmeinfo)) {
		/* Stop BCN */
		val8 = 0;
		rtw_hal_set_hwreg(padapter, HW_VAR_BCN_FUNC, (u8 *)(&val8));
	}

	rtw_mlmeext_disconnect(padapter);

	rtw_free_uc_swdec_pending_queue(padapter);

	rtw_sta_mstatus_report(padapter);

exit:
	return	H2C_SUCCESS;
}
#if 0 /*#ifndef CONFIG_PHL_ARCH*/
void survey_timer_hdl(void *ctx)
{
	_adapter *padapter = (_adapter *)ctx;
	struct cmd_obj *cmd;
	struct sitesurvey_parm *psurveyPara;
	struct cmd_priv	*pcmdpriv = &adapter_to_dvobj(padapter)->cmdpriv;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;

	if (mlmeext_scan_state(pmlmeext) > SCAN_DISABLE) {
		cmd = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
		if (cmd == NULL) {
			rtw_warn_on(1);
			goto exit;
		}
		cmd->padapter = padapter;

		psurveyPara = (struct sitesurvey_parm *)rtw_zmalloc(sizeof(struct sitesurvey_parm));
		if (psurveyPara == NULL) {
			rtw_warn_on(1);
			rtw_mfree((unsigned char *)cmd, sizeof(struct cmd_obj));
			goto exit;
		}

		init_h2fwcmd_w_parm_no_rsp(cmd, psurveyPara, CMD_SITE_SURVEY);
		rtw_enqueue_cmd(pcmdpriv, cmd);
	}

exit:
	return;
}

static const char *const _scan_state_str[] = {
	"SCAN_DISABLE",
	"SCAN_START",
	"SCAN_PS_ANNC_WAIT",
	"SCAN_ENTER",
	"SCAN_PROCESS",
	"SCAN_BACKING_OP",
	"SCAN_BACK_OP",
	"SCAN_LEAVING_OP",
	"SCAN_LEAVE_OP",
	"SCAN_SW_ANTDIV_BL",
	"SCAN_TO_P2P_LISTEN",
	"SCAN_P2P_LISTEN",
	"SCAN_COMPLETE",
	"SCAN_STATE_MAX",
};

const char *scan_state_str(u8 state)
{
	state = (state >= SCAN_STATE_MAX) ? SCAN_STATE_MAX : state;
	return _scan_state_str[state];
}

static bool scan_abort_hdl(_adapter *adapter)
{
	struct mlme_ext_priv *pmlmeext = &adapter->mlmeextpriv;
	struct ss_res *ss = &pmlmeext->sitesurvey_res;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &adapter->wdinfo;
#endif
	bool ret = _FALSE;

	if (pmlmeext->scan_abort == _TRUE) {
#ifdef CONFIG_P2P
		if (!rtw_p2p_chk_state(&adapter->wdinfo, P2P_STATE_NONE)) {
			rtw_p2p_findphase_ex_set(pwdinfo, P2P_FINDPHASE_EX_MAX);
			ss->channel_idx = 3;
			RTW_INFO("%s idx:%d, cnt:%u\n", __FUNCTION__
				 , ss->channel_idx
				 , pwdinfo->find_phase_state_exchange_cnt
				);
		} else
#endif
		{
			ss->channel_idx = ss->ch_num;
			RTW_INFO("%s idx:%d\n", __FUNCTION__
				 , ss->channel_idx
				);
		}
		pmlmeext->scan_abort = _FALSE;
		ret = _TRUE;
	}

	return ret;
}

static void sitesurvey_res_reset(_adapter *adapter, struct sitesurvey_parm *parm)
{
	struct ss_res *ss = &adapter->mlmeextpriv.sitesurvey_res;
	RT_CHANNEL_INFO *chset = adapter_to_chset(adapter);
	int i;

	ss->bss_cnt = 0;
	ss->channel_idx = 0;
	ss->force_ssid_scan = 0;
	ss->igi_scan = 0;
	ss->igi_before_scan = 0;
#ifdef CONFIG_SCAN_BACKOP
	ss->scan_cnt = 0;
#endif
#if defined(CONFIG_ANTENNA_DIVERSITY) || defined(DBG_SCAN_SW_ANTDIV_BL)
	ss->is_sw_antdiv_bl_scan = 0;
#endif
	ss->ssid_num = 0;
	for (i = 0; i < RTW_SSID_SCAN_AMOUNT; i++) {
		if (parm->ssid[i].SsidLength) {
			_rtw_memcpy(ss->ssid[i].Ssid, parm->ssid[i].Ssid, IW_ESSID_MAX_SIZE);
			ss->ssid[i].SsidLength = parm->ssid[i].SsidLength;
			ss->ssid_num++;
		} else
			ss->ssid[i].SsidLength = 0;
	}

	ss->ch_num = rtw_scan_ch_decision(adapter
					, ss->ch, RTW_CHANNEL_SCAN_AMOUNT
					, parm->ch, parm->ch_num
					, parm->acs
				);

	for (i = 0; i < MAX_CHANNEL_NUM; i++)
		chset[i].hidden_bss_cnt = 0;

	ss->bw = parm->bw;
	ss->igi = parm->igi;
	ss->token = parm->token;
	ss->duration = parm->duration;
	ss->scan_mode = parm->scan_mode;
	ss->token = parm->token;
	ss->acs = parm->acs;
}

static u8 sitesurvey_pick_ch_behavior(_adapter *padapter, u8 *ch,
					enum rtw_phl_scan_type *type)
{
	u8 next_state;
	u8 scan_ch = 0;
	enum rtw_phl_scan_type stype = RTW_PHL_SCAN_PASSIVE;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct ss_res *ss = &pmlmeext->sitesurvey_res;
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
	int ch_set_idx;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &padapter->wdinfo;
#endif
#ifdef CONFIG_SCAN_BACKOP
	u8 backop_flags = 0;
#endif

	/* handle scan abort request */
	scan_abort_hdl(padapter);

#ifdef CONFIG_P2P
	if (pwdinfo->rx_invitereq_info.scan_op_ch_only || pwdinfo->p2p_info.scan_op_ch_only) {
		if (pwdinfo->rx_invitereq_info.scan_op_ch_only)
			scan_ch = pwdinfo->rx_invitereq_info.operation_ch[ss->channel_idx];
		else
			scan_ch = pwdinfo->p2p_info.operation_ch[ss->channel_idx];
		stype = RTW_PHL_SCAN_ACTIVE;
	} else if (rtw_p2p_findphase_ex_is_social(pwdinfo)) {
		/*
		* Commented by Albert 2011/06/03
		* The driver is in the find phase, it should go through the social channel.
		*/
		scan_ch = pwdinfo->social_chan[ss->channel_idx];
		ch_set_idx = rtw_chset_search_ch(rfctl->channel_set, scan_ch);
		if (ch_set_idx >= 0)
			stype = rfctl->channel_set[ch_set_idx].flags & RTW_CHF_NO_IR ? RTW_PHL_SCAN_PASSIVE : RTW_PHL_SCAN_ACTIVE;
		else
			stype = RTW_PHL_SCAN_ACTIVE;
	} else
#endif /* CONFIG_P2P */
	{
		struct rtw_ieee80211_channel *ch;

		#ifdef CONFIG_SCAN_BACKOP
		backop_flags = rtw_scan_backop_decision(padapter);
		#endif

		#ifdef CONFIG_SCAN_BACKOP
		if (!(backop_flags && ss->scan_cnt >= ss->scan_cnt_max))
		#endif
		{
			#ifdef CONFIG_RTW_WIFI_HAL
			if (adapter_to_dvobj(padapter)->nodfs) {
				while (ss->channel_idx < ss->ch_num && rtw_chset_is_dfs_ch(rfctl->channel_set, ss->ch[ss->channel_idx].hw_value))
					ss->channel_idx++;
			} else
			#endif
			if (ss->channel_idx != 0 && ss->force_ssid_scan == 0
				&& pmlmeext->sitesurvey_res.ssid_num
				&& (ss->ch[ss->channel_idx - 1].flags & RTW_IEEE80211_CHAN_PASSIVE_SCAN)
			) {
				ch_set_idx = rtw_chset_search_ch(rfctl->channel_set, ss->ch[ss->channel_idx - 1].hw_value);
				if (ch_set_idx != -1 && rfctl->channel_set[ch_set_idx].hidden_bss_cnt
					&& (!IS_DFS_SLAVE_WITH_RD(rfctl)
						|| rtw_hal_dfs_domain_unknown(rfctl_to_dvobj(rfctl))
						|| !CH_IS_NON_OCP(&rfctl->channel_set[ch_set_idx]))
				) {
					ss->channel_idx--;
					ss->force_ssid_scan = 1;
				}
			} else
				ss->force_ssid_scan = 0;
		}

		if (ss->channel_idx < ss->ch_num) {
			ch = &ss->ch[ss->channel_idx];
			scan_ch = ch->hw_value;

			#if defined(CONFIG_RTW_ACS) && defined(CONFIG_RTW_ACS_DBG)
			if (IS_ACS_ENABLE(padapter) && rtw_is_acs_passiv_scan(padapter))
				stype = RTW_PHL_SCAN_PASSIVE;
			else
			#endif /*CONFIG_RTW_ACS*/
				stype = (ch->flags & RTW_IEEE80211_CHAN_PASSIVE_SCAN) ? RTW_PHL_SCAN_PASSIVE : RTW_PHL_SCAN_ACTIVE;
		}
	}

	if (scan_ch != 0) {
		next_state = SCAN_PROCESS;

		#ifdef CONFIG_SCAN_BACKOP
		if (backop_flags) {
			if (ss->scan_cnt < ss->scan_cnt_max)
				ss->scan_cnt++;
			else {
				mlmeext_assign_scan_backop_flags(pmlmeext, backop_flags);
				next_state = SCAN_BACKING_OP;
			}
		}
		#endif

	} else if (rtw_p2p_findphase_ex_is_needed(pwdinfo)) {
		/* go p2p listen */
		next_state = SCAN_TO_P2P_LISTEN;

#ifdef CONFIG_ANTENNA_DIVERSITY
	} else if (rtw_hal_antdiv_before_linked(padapter)) {
		/* go sw antdiv before link */
		next_state = SCAN_SW_ANTDIV_BL;
#endif
	} else {
		next_state = SCAN_COMPLETE;

#if defined(DBG_SCAN_SW_ANTDIV_BL)
		{
			/* for SCAN_SW_ANTDIV_BL state testing */
			struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
			int i;
			bool is_linked = _FALSE;

			for (i = 0; i < dvobj->iface_nums; i++) {
				if (rtw_linked_check(dvobj->padapters[i]))
					is_linked = _TRUE;
			}

			if (!is_linked) {
				static bool fake_sw_antdiv_bl_state = 0;

				if (fake_sw_antdiv_bl_state == 0) {
					next_state = SCAN_SW_ANTDIV_BL;
					fake_sw_antdiv_bl_state = 1;
				} else
					fake_sw_antdiv_bl_state = 0;
			}
		}
#endif /* defined(DBG_SCAN_SW_ANTDIV_BL) */
	}

#ifdef CONFIG_SCAN_BACKOP
	if (next_state != SCAN_PROCESS)
		ss->scan_cnt = 0;
#endif


#ifdef DBG_FIXED_CHAN
	if (pmlmeext->fixed_chan != 0xff && next_state == SCAN_PROCESS)
		scan_ch = pmlmeext->fixed_chan;
#endif

	if (ch)
		*ch = scan_ch;
	if (type)
		*type = stype;

	return next_state;
}

void site_survey(_adapter *padapter, u8 survey_channel,
	enum rtw_phl_scan_type ScanType)
{
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct ss_res *ss = &pmlmeext->sitesurvey_res;
	u8 ssid_scan = 0;

#ifdef CONFIG_P2P
#ifndef CONFIG_IOCTL_CFG80211
	struct wifidirect_info *pwdinfo = &(padapter->wdinfo);
#endif
#endif

	if (survey_channel != 0) {
		set_channel_bwmode(padapter,
				survey_channel,
				CHAN_OFFSET_NO_EXT,
				CHANNEL_WIDTH_20,
				_FALSE);

		if (ScanType == RTW_PHL_SCAN_PASSIVE && ss->force_ssid_scan)
			ssid_scan = 1;
		else if (ScanType == RTW_PHL_SCAN_ACTIVE) {
#ifdef CONFIG_P2P
			#ifdef CONFIG_IOCTL_CFG80211
			if (rtw_cfg80211_is_p2p_scan(padapter))
			#else
			if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_SCAN)
				|| rtw_p2p_chk_state(pwdinfo, P2P_STATE_FIND_PHASE_SEARCH))
			#endif
			{
				issue_probereq_p2p(padapter, NULL);
				issue_probereq_p2p(padapter, NULL);
				issue_probereq_p2p(padapter, NULL);
			} else
#endif /* CONFIG_P2P */
			{
				if (pmlmeext->sitesurvey_res.scan_mode == RTW_PHL_SCAN_ACTIVE) {
					/* IOT issue, When wifi_spec is not set, send one probe req without WPS IE. */
					if (padapter->registrypriv.wifi_spec)
						issue_probereq(padapter, NULL, NULL);
					else
						issue_probereq_ex(padapter, NULL, NULL, 0, 0, 0, 0);
					issue_probereq(padapter, NULL, NULL);
				}

				ssid_scan = 1;
			}
		}

		if (ssid_scan) {
			int i;

			for (i = 0; i < RTW_SSID_SCAN_AMOUNT; i++) {
				if (pmlmeext->sitesurvey_res.ssid[i].SsidLength) {
					/* IOT issue, When wifi_spec is not set, send one probe req without WPS IE. */
					if (padapter->registrypriv.wifi_spec)
						issue_probereq(padapter, &(pmlmeext->sitesurvey_res.ssid[i]), NULL);
					else
						issue_probereq_ex(padapter, &(pmlmeext->sitesurvey_res.ssid[i]), NULL, 0, 0, 0, 0);
					issue_probereq(padapter, &(pmlmeext->sitesurvey_res.ssid[i]), NULL);
				}
			}
		}
	} else {
		/* channel number is 0 or this channel is not valid. */
		rtw_warn_on(1);
	}

	return;
}

void survey_done_set_ch_bw(_adapter *padapter)
{
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	u8 cur_channel = 0;
	u8 cur_bwmode;
	u8 cur_ch_offset;

#ifdef CONFIG_MCC_MODE
	if (!rtw_hal_mcc_change_scan_flag(padapter, &cur_channel, &cur_bwmode, &cur_ch_offset)) {
		if (0)
			RTW_INFO(FUNC_ADPT_FMT" back to AP channel - ch:%u, bw:%u, offset:%u\n",
				FUNC_ADPT_ARG(padapter), cur_channel, cur_bwmode, cur_ch_offset);
		goto exit;
	}
#endif

	if (rtw_mi_get_ch_setting_union(padapter, &cur_channel, &cur_bwmode, &cur_ch_offset) != 0) {
		if (0)
			RTW_INFO(FUNC_ADPT_FMT" back to linked/linking union - ch:%u, bw:%u, offset:%u\n",
				FUNC_ADPT_ARG(padapter), cur_channel, cur_bwmode, cur_ch_offset);
	} else {
#ifdef CONFIG_P2P
		struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
		_adapter *iface;
		int i;

		for (i = 0; i < dvobj->iface_nums; i++) {
			iface = dvobj->padapters[i];
			if (!iface)
				continue;

#ifdef CONFIG_IOCTL_CFG80211
			if (iface->wdinfo.driver_interface == DRIVER_CFG80211 && !adapter_wdev_data(iface)->p2p_enabled)
				continue;
#endif

			if (rtw_p2p_chk_state(&iface->wdinfo, P2P_STATE_LISTEN)) {
				cur_channel = iface->wdinfo.listen_channel;
				cur_bwmode = CHANNEL_WIDTH_20;
				cur_ch_offset = CHAN_OFFSET_NO_EXT;
				if (0)
					RTW_INFO(FUNC_ADPT_FMT" back to "ADPT_FMT"'s listen ch - ch:%u, bw:%u, offset:%u\n",
						FUNC_ADPT_ARG(padapter), ADPT_ARG(iface), cur_channel, cur_bwmode, cur_ch_offset);
				break;
			}
		}
#endif /* CONFIG_P2P */

		if (cur_channel == 0) {
			cur_channel = pmlmeext->cur_channel;
			cur_bwmode = pmlmeext->cur_bwmode;
			cur_ch_offset = pmlmeext->cur_ch_offset;
			if (0)
				RTW_INFO(FUNC_ADPT_FMT" back to ch:%u, bw:%u, offset:%u\n",
					FUNC_ADPT_ARG(padapter), cur_channel, cur_bwmode, cur_ch_offset);
		}
	}
#ifdef CONFIG_MCC_MODE
exit:
#endif
	set_channel_bwmode(padapter, cur_channel, cur_ch_offset, cur_bwmode, _FALSE);
}

void sitesurvey_set_igi(_adapter *adapter)
{
	struct mlme_ext_priv *mlmeext = &adapter->mlmeextpriv;
	struct ss_res *ss = &mlmeext->sitesurvey_res;
	u8 igi;
#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &adapter->wdinfo;
#endif

	switch (mlmeext_scan_state(mlmeext)) {
	case SCAN_ENTER:
		#ifdef CONFIG_P2P
		#ifdef CONFIG_IOCTL_CFG80211
		if (pwdinfo->driver_interface == DRIVER_CFG80211 && rtw_cfg80211_is_p2p_scan(adapter))
			igi = 0x30;
		else
		#endif /* CONFIG_IOCTL_CFG80211 */
		if (!rtw_p2p_chk_state(pwdinfo, P2P_STATE_NONE))
			igi = 0x28;
		else
		#endif /* CONFIG_P2P */

		if (ss->igi)
			igi = ss->igi;
		else
		#if defined(CONFIG_RTW_ACS) && defined(CONFIG_RTW_ACS_DBG)
		if (IS_ACS_ENABLE(adapter) && rtw_is_acs_igi_valid(adapter))
			igi = rtw_acs_get_adv_igi(adapter);
		else
		#endif /*CONFIG_RTW_ACS*/
			igi = 0x1e;

		/* record IGI status */
		ss->igi_scan = igi;
		rtw_hal_get_phydm_var(adapter, HAL_PHYDM_IGI, &ss->igi_before_scan, NULL);

		/* disable DIG and set IGI for scan */
		rtw_hal_set_phydm_var(adapter, HAL_PHYDM_IGI, &igi, _FALSE);
		break;
	case SCAN_COMPLETE:
	case SCAN_TO_P2P_LISTEN:
		/* enable DIG and restore IGI */
		igi = 0xff;
		rtw_hal_set_phydm_var(adapter, HAL_PHYDM_IGI, &igi, _FALSE);
		break;
#ifdef CONFIG_SCAN_BACKOP
	case SCAN_BACKING_OP:
		/* write IGI for op channel when DIG is not enabled */
		rtw_hal_set_phydm_var(adapter, HAL_PHYDM_IGI_W, &ss->igi_before_scan, _FALSE);
		break;
	case SCAN_LEAVE_OP:
		/* write IGI for scan when DIG is not enabled */
		rtw_hal_set_phydm_var(adapter, HAL_PHYDM_IGI_W, &ss->igi_scan, _FALSE);
		break;
#endif /* CONFIG_SCAN_BACKOP */
	default:
		rtw_warn_on(1);
		break;
	}
}
void sitesurvey_set_msr(_adapter *adapter, bool enter)
{
	u8 network_type;
	struct mlme_ext_priv *pmlmeext = &adapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);

	if (enter) {
		/* set MSR to no link state */
		network_type = _HW_STATE_NOLINK_;
	} else {
		network_type = pmlmeinfo->state & 0x3;
	}
	rtw_hal_set_network_type(adapter, network_type);
}
#endif

/**
 * rtw_ps_annc - check and doing ps announcement for all the adapters
 * @adapter: the requesting adapter
 * @ps: power saving or not
 *
 * Returns: 0: no ps announcement is doing. 1: ps announcement is doing
 */
u8 rtw_ps_annc(_adapter *adapter, bool ps)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(adapter);
	_adapter *iface;
	int i;
	u8 ps_anc = 0;

	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		if (!iface)
			continue;

		if (MLME_IS_STA(iface)) {
			if (is_client_associated_to_ap(iface) == _TRUE) {
				/* TODO: TDLS peers */
				#ifdef CONFIG_MCC_MODE
				/* for two station case */
				if (MCC_EN(adapter) && rtw_hal_check_mcc_status(adapter, MCC_STATUS_NEED_MCC)) {
					u8 ch = iface->mlmeextpriv.cur_channel;
					u8 offset = iface->mlmeextpriv.cur_ch_offset;
					u8 bw = iface->mlmeextpriv.cur_bwmode;

					set_channel_bwmode(iface, ch, offset, bw, _FALSE);
				}
				#endif /* CONFIG_MCC_MODE */
				issue_nulldata(iface, NULL, ps, 3, 500);
				ps_anc = 1;
			}
		#ifdef CONFIG_RTW_MESH
		} else if (MLME_IS_MESH(iface)) {
			if (rtw_mesh_ps_annc(iface, ps))
				ps_anc = 1;
		#endif
		}
	}
	return ps_anc;
}

#ifdef CONFIG_SCAN_BACKOP
u8 rtw_scan_backop_decision(_adapter *adapter)
{
	struct mlme_ext_priv *mlmeext = &adapter->mlmeextpriv;
	struct mi_state mstate;
	u8 backop_flags = 0;

	rtw_mi_status(adapter, &mstate);

	if ((MSTATE_STA_LD_NUM(&mstate) && mlmeext_chk_scan_backop_flags_sta(mlmeext, SS_BACKOP_EN))
		|| (MSTATE_STA_NUM(&mstate) && mlmeext_chk_scan_backop_flags_sta(mlmeext, SS_BACKOP_EN_NL)))
		backop_flags |= mlmeext_scan_backop_flags_sta(mlmeext);

#ifdef CONFIG_AP_MODE
	if ((MSTATE_AP_LD_NUM(&mstate) && mlmeext_chk_scan_backop_flags_ap(mlmeext, SS_BACKOP_EN))
		|| (MSTATE_AP_NUM(&mstate) && mlmeext_chk_scan_backop_flags_ap(mlmeext, SS_BACKOP_EN_NL)))
		backop_flags |= mlmeext_scan_backop_flags_ap(mlmeext);
#endif

#ifdef CONFIG_RTW_MESH
	if ((MSTATE_MESH_LD_NUM(&mstate) && mlmeext_chk_scan_backop_flags_mesh(mlmeext, SS_BACKOP_EN))
		|| (MSTATE_MESH_NUM(&mstate) && mlmeext_chk_scan_backop_flags_mesh(mlmeext, SS_BACKOP_EN_NL)))
		backop_flags |= mlmeext_scan_backop_flags_mesh(mlmeext);
#endif

	return backop_flags;
}
#endif

void sitesurvey_set_offch_state(_adapter *adapter, u8 scan_state)
{
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);

	_rtw_mutex_lock_interruptible(&rfctl->offch_mutex);

	switch (scan_state) {
	case SCAN_DISABLE:
	case SCAN_BACK_OP:
		rfctl->offch_state = OFFCHS_NONE;
		break;
	case SCAN_START:
	case SCAN_LEAVING_OP:
		rfctl->offch_state = OFFCHS_LEAVING_OP;
		break;
	case SCAN_ENTER:
	case SCAN_LEAVE_OP:
		rfctl->offch_state = OFFCHS_LEAVE_OP;
		break;
	case SCAN_COMPLETE:
	case SCAN_BACKING_OP:
		rfctl->offch_state = OFFCHS_BACKING_OP;
		break;
	default:
		break;
	}

	_rtw_mutex_unlock(&rfctl->offch_mutex);
}

#define SCANNING_TIMEOUT_EX	2000
u32 rtw_scan_timeout_decision(_adapter *padapter, struct rtw_phl_scan_param *phl_param)
{
	u32 back_op_times= 0;
	u8 max_chan_num = 0;
	u16 scan_ms;
	u16 ext_act_ms = 0;
	int i;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct ss_res *ss = &pmlmeext->sitesurvey_res;

	max_chan_num += (is_supported_5g(padapter->registrypriv.band_type)) ? MAX_CHANNEL_NUM_5G : 0;
	max_chan_num += (is_supported_24g(padapter->registrypriv.band_type)) ? MAX_CHANNEL_NUM_2G : 0;

	#ifdef CONFIG_SCAN_BACKOP
	if (rtw_scan_backop_decision(padapter))
		back_op_times = (max_chan_num / ss->scan_cnt_max) * ss->backop_ms;
	#endif

	#ifdef CONFIG_NEC_SCAN
	if (ss->defered_ss)
		back_op_times = padapter->registrypriv.wifi_mib.ss_delay;	//3000
	#endif

	if (ss->duration)
		scan_ms = ss->duration;
	else
	#if defined(CONFIG_RTW_ACS) && defined(CONFIG_RTW_ACS_DBG)
	if (IS_ACS_ENABLE(padapter) && rtw_is_acs_st_valid(padapter))
		scan_ms = rtw_acs_get_adv_st(padapter);
	else
	#endif /*CONFIG_RTW_ACS*/
		scan_ms = ss->scan_ch_ms;

	/* Extended active scan time */
	for (i = 0; i < phl_param->ch_num; i++) {
		if (phl_param->ch[i].ext_act_scan == EXT_ACT_SCAN_ENABLE)
			ext_act_ms += phl_param->ext_act_scan_period;
	}

	ss->scan_timeout_ms = (scan_ms * max_chan_num) + back_op_times + SCANNING_TIMEOUT_EX + ext_act_ms;
	#ifdef DBG_SITESURVEY
	RTW_INFO(FUNC_ADPT_FMT ": scan_timeout_ms=%u, ch_num:%u scan_ms=%u, "
		 "back_op_times=%u, ext_act_ms=%u\n",
		 FUNC_ADPT_ARG(padapter), ss->scan_timeout_ms,
		 max_chan_num, scan_ms, back_op_times, ext_act_ms);
	#endif /*DBG_SITESURVEY*/
	return ss->scan_timeout_ms;
}

void rtw_leave_opch(_adapter *adapter)
{
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);

#ifdef CONFIG_MCC_MODE
	if (MCC_EN(adapter) && rtw_hal_check_mcc_status(adapter, MCC_STATUS_DOING_MCC))
		return;
#endif

	_rtw_mutex_lock_interruptible(&rfctl->offch_mutex);

	if (rfctl->offch_state == OFFCHS_NONE) {
		/* prepare to leave operating channel */
		rfctl->offch_state = OFFCHS_LEAVING_OP;

		/* clear HW TX queue */
		rtw_hal_set_hwreg(adapter, HW_VAR_CHECK_TXBUF, 0);

		rtw_hal_macid_sleep_all_used(adapter);

		rtw_ps_annc(adapter, 1);

		rfctl->offch_state = OFFCHS_LEAVE_OP;
	}

	_rtw_mutex_unlock(&rfctl->offch_mutex);
}

void rtw_back_opch(_adapter *adapter)
{
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);

#ifdef CONFIG_MCC_MODE
	if (MCC_EN(adapter) && rtw_hal_check_mcc_status(adapter, MCC_STATUS_DOING_MCC))
		return;
#endif

	_rtw_mutex_lock_interruptible(&rfctl->offch_mutex);

	if (rfctl->offch_state != OFFCHS_NONE) {
		rfctl->offch_state = OFFCHS_BACKING_OP;
		rtw_hal_macid_wakeup_all_used(adapter);
		rtw_ps_annc(adapter, 0);

		rfctl->offch_state = OFFCHS_NONE;
		rtw_mi_os_xmit_schedule(adapter);
	}

	_rtw_mutex_unlock(&rfctl->offch_mutex);
}

u8 rtw_scan_sparse(_adapter *adapter, struct rtw_ieee80211_channel *ch, u8 ch_num)
{
	/* interval larger than this is treated as backgroud scan */
#ifndef RTW_SCAN_SPARSE_BG_INTERVAL_MS
#define RTW_SCAN_SPARSE_BG_INTERVAL_MS 12000
#endif

#ifndef RTW_SCAN_SPARSE_CH_NUM_MIRACAST
#define RTW_SCAN_SPARSE_CH_NUM_MIRACAST 1
#endif
#ifndef RTW_SCAN_SPARSE_CH_NUM_BG
#define RTW_SCAN_SPARSE_CH_NUM_BG 4
#endif
#ifdef CONFIG_LAYER2_ROAMING
#ifndef RTW_SCAN_SPARSE_CH_NUM_ROAMING_ACTIVE
#define RTW_SCAN_SPARSE_CH_NUM_ROAMING_ACTIVE 1
#endif
#endif

#define SCAN_SPARSE_CH_NUM_INVALID 255

	static u8 token = 255;
	u32 interval;
	bool busy_traffic = _FALSE;
	bool miracast_enabled = _FALSE;
	bool bg_scan = _FALSE;
	u8 max_allow_ch = SCAN_SPARSE_CH_NUM_INVALID;
	u8 scan_division_num;
	u8 ret_num = ch_num;
	struct mlme_ext_priv *mlmeext = &adapter->mlmeextpriv;

	if (mlmeext->last_scan_time == 0)
		mlmeext->last_scan_time = rtw_get_current_time();

	interval = rtw_get_passing_time_ms(mlmeext->last_scan_time);


	if (rtw_mi_busy_traffic_check(adapter))
		busy_traffic = _TRUE;

	if (rtw_mi_check_miracast_enabled(adapter))
		miracast_enabled = _TRUE;

	if (interval > RTW_SCAN_SPARSE_BG_INTERVAL_MS)
		bg_scan = _TRUE;

	/* max_allow_ch by conditions*/

#if RTW_SCAN_SPARSE_MIRACAST
	if (miracast_enabled == _TRUE && busy_traffic == _TRUE)
		max_allow_ch = rtw_min(max_allow_ch, RTW_SCAN_SPARSE_CH_NUM_MIRACAST);
#endif

#if RTW_SCAN_SPARSE_BG
	if (bg_scan == _TRUE)
		max_allow_ch = rtw_min(max_allow_ch, RTW_SCAN_SPARSE_CH_NUM_BG);
#endif

#if  defined(CONFIG_LAYER2_ROAMING) && defined(RTW_SCAN_SPARSE_ROAMING_ACTIVE)
	if (rtw_chk_roam_flags(adapter, RTW_ROAM_ACTIVE)) {
		if (busy_traffic == _TRUE && adapter->mlmepriv.need_to_roam == _TRUE)
			max_allow_ch = rtw_min(max_allow_ch, RTW_SCAN_SPARSE_CH_NUM_ROAMING_ACTIVE);
	}
#endif


	if (max_allow_ch != SCAN_SPARSE_CH_NUM_INVALID) {
		int i;
		int k = 0;

		/* COV: the result of (ch_num % max_allow_ch) is always true, so mark unnecessary code */
		scan_division_num = (ch_num / max_allow_ch) ;//+ ((ch_num % max_allow_ch) ? 1 : 0);
		token = (token + 1) % scan_division_num;

		if (0)
			RTW_INFO("scan_division_num:%u, token:%u\n", scan_division_num, token);

		for (i = 0; i < ch_num; i++) {
			if (ch[i].hw_value && (i % scan_division_num) == token
			   ) {
				if (i != k)
					_rtw_memcpy(&ch[k], &ch[i], sizeof(struct rtw_ieee80211_channel));
				k++;
			}
		}

		_rtw_memset(&ch[k], 0, sizeof(struct rtw_ieee80211_channel));

		ret_num = k;
		mlmeext->last_scan_time = rtw_get_current_time();
	}

	return ret_num;
}

int rtw_scan_ch_decision(_adapter *padapter, struct rtw_ieee80211_channel *out,
		u32 out_num, struct rtw_ieee80211_channel *in, u32 in_num, bool no_sparse)
{
	int i, j;
	int set_idx;
	u8 chan;
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
	struct registry_priv *regsty = dvobj_to_regsty(adapter_to_dvobj(padapter));

	/* clear first */
	_rtw_memset(out, 0, sizeof(struct rtw_ieee80211_channel) * out_num);

	/* acquire channels from in */
	j = 0;
	for (i = 0; i < in_num; i++) {

		if (0)
			RTW_INFO(FUNC_ADPT_FMT" "CHAN_FMT"\n", FUNC_ADPT_ARG(padapter), CHAN_ARG(&in[i]));

		if (!in[i].hw_value || (in[i].flags & RTW_IEEE80211_CHAN_DISABLED))
			continue;
		if (rtw_mlme_band_check(padapter, in[i].hw_value) == _FALSE)
			continue;

		set_idx = rtw_chset_search_ch(rfctl->channel_set, in[i].hw_value);
		if (set_idx >= 0) {
			if (j >= out_num) {
				RTW_PRINT(FUNC_ADPT_FMT" out_num:%u not enough\n",
					  FUNC_ADPT_ARG(padapter), out_num);
				break;
			}

			_rtw_memcpy(&out[j], &in[i], sizeof(struct rtw_ieee80211_channel));

			if (rfctl->channel_set[set_idx].flags & (RTW_CHF_NO_IR | RTW_CHF_DFS))
				out[j].flags |= RTW_IEEE80211_CHAN_PASSIVE_SCAN;

			j++;
		}
		if (j >= out_num)
			break;
	}

	/* if out is empty, use channel_set as default */
	if (j == 0) {
		for (i = 0; i < rfctl->max_chan_nums; i++) {
			chan = rfctl->channel_set[i].ChannelNum;
			if (rtw_mlme_band_check(padapter, chan) == _TRUE) {
				if (rtw_mlme_ignore_chan(padapter, chan) == _TRUE)
					continue;

				if (0)
					RTW_INFO(FUNC_ADPT_FMT" ch:%u\n", FUNC_ADPT_ARG(padapter), chan);

				if (j >= out_num) {
					RTW_PRINT(FUNC_ADPT_FMT" out_num:%u not enough\n",
						FUNC_ADPT_ARG(padapter), out_num);
					break;
				}

				out[j].hw_value = chan;

				if (rfctl->channel_set[i].flags & (RTW_CHF_NO_IR | RTW_CHF_DFS))
					out[j].flags |= RTW_IEEE80211_CHAN_PASSIVE_SCAN;

				j++;
			}
		}
	}

	if (!no_sparse
		&& !regsty->wifi_spec
		&& j > 6 /* assume ch_num > 6 is normal scan */
	) {
		/* scan_sparse */
		j = rtw_scan_sparse(padapter, out, j);
	}

	return j;
}

#if 0
u8 sitesurvey_cmd_hdl(_adapter *padapter, u8 *pbuf)
{
	struct sitesurvey_parm	*pparm = (struct sitesurvey_parm *)pbuf;
#ifdef DBG_CHECK_FW_PS_STATE
	struct dvobj_priv *dvobj = padapter->dvobj;
	struct debug_priv *pdbgpriv = &dvobj->drv_dbg;
#endif
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct ss_res *ss = &pmlmeext->sitesurvey_res;
#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
	struct rtw_wdev_priv *pwdev_priv = adapter_wdev_data(padapter);
#endif
	u8 val8;

#ifdef CONFIG_P2P
	struct wifidirect_info *pwdinfo = &padapter->wdinfo;
#endif

#ifdef DBG_CHECK_FW_PS_STATE
	if (rtw_fw_ps_state(padapter) == _FAIL) {
		RTW_INFO("scan without leave 32k\n");
		pdbgpriv->dbg_scan_pwr_state_cnt++;
	}
#endif /* DBG_CHECK_FW_PS_STATE */

	/* increase channel idx */
	if (mlmeext_chk_scan_state(pmlmeext, SCAN_PROCESS))
		ss->channel_idx++;

	/* update scan state to next state (assigned by previous cmd hdl) */
	if (mlmeext_scan_state(pmlmeext) != mlmeext_scan_next_state(pmlmeext))
		mlmeext_set_scan_state(pmlmeext, mlmeext_scan_next_state(pmlmeext));

operation_by_state:
	switch (mlmeext_scan_state(pmlmeext)) {

	case SCAN_DISABLE:
		/*
		* SW parameter initialization
		*/

		sitesurvey_res_reset(padapter, pparm);
		mlmeext_set_scan_state(pmlmeext, SCAN_START);
		goto operation_by_state;

	case SCAN_START:
#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
		if ((pwdev_priv->pno_mac_addr[0] != 0xFF)
			    && (MLME_IS_STA(padapter))
	    	    && (check_fwstate(&padapter->mlmepriv, WIFI_ASOC_STATE) == _FALSE)) {
			u16 seq_num;

			rtw_hal_pno_random_gen_mac_addr(padapter);
			rtw_hal_set_hw_mac_addr(padapter, pwdev_priv->pno_mac_addr);
			get_random_bytes(&seq_num, 2);
			pwdev_priv->pno_scan_seq_num = seq_num & 0xFFF;
			RTW_INFO("%s pno_scan_seq_num %d\n", __func__,
				 pwdev_priv->pno_scan_seq_num);
		}
#endif

		/*
		* prepare to leave operating channel
		*/

#ifdef CONFIG_MCC_MODE
		rtw_hal_set_mcc_setting_scan_start(padapter);
#endif /* CONFIG_MCC_MODE */

		/* apply rx ampdu setting */
		if (ss->rx_ampdu_accept != RX_AMPDU_ACCEPT_INVALID
			|| ss->rx_ampdu_size != RX_AMPDU_SIZE_INVALID)
			rtw_rx_ampdu_apply(padapter);

		/* clear HW TX queue before scan */
		rtw_hal_set_hwreg(padapter, HW_VAR_CHECK_TXBUF, 0);

		rtw_hal_macid_sleep_all_used(padapter);

		/* power save state announcement */
		if (rtw_ps_annc(padapter, 1)) {
			mlmeext_set_scan_state(pmlmeext, SCAN_PS_ANNC_WAIT);
			mlmeext_set_scan_next_state(pmlmeext, SCAN_ENTER);
			set_survey_timer(pmlmeext, 50); /* delay 50ms to protect nulldata(1) */
		} else {
			mlmeext_set_scan_state(pmlmeext, SCAN_ENTER);
			goto operation_by_state;
		}

		break;

	case SCAN_ENTER:
		/*
		* HW register and DM setting for enter scan
		*/

		rtw_phydm_ability_backup(padapter);

		sitesurvey_set_igi(padapter);

		/* config dynamic functions for off channel */
		rtw_phydm_func_for_offchannel(padapter);
		/* set network type to no link state */
		sitesurvey_set_msr(padapter, _TRUE);

		val8 = 1; /* under site survey */
		rtw_hal_set_hwreg(padapter, HW_VAR_MLME_SITESURVEY, (u8 *)(&val8));

		mlmeext_set_scan_state(pmlmeext, SCAN_PROCESS);
		goto operation_by_state;

	case SCAN_PROCESS: {
		u8 scan_ch;
		enum rtw_phl_scan_type stype;
		u8 next_state;
		u32 scan_ms;

#ifdef CONFIG_RTW_ACS
		if (IS_ACS_ENABLE(padapter))
			rtw_acs_get_rst(padapter);
#endif

		next_state = sitesurvey_pick_ch_behavior(padapter, &scan_ch, &stype);

		if (next_state != SCAN_PROCESS) {
			mlmeext_set_scan_state(pmlmeext, next_state);
			goto operation_by_state;
		}

		/* still SCAN_PROCESS state */
		#ifdef DBG_SITESURVEY
			#ifdef CONFIG_P2P
			RTW_INFO(FUNC_ADPT_FMT" %s ch:%u (cnt:%u,idx:%d) at %dms, %c%c%c%c\n"
				, FUNC_ADPT_ARG(padapter)
				, mlmeext_scan_state_str(pmlmeext)
				, scan_ch
				, pwdinfo->find_phase_state_exchange_cnt, ss->channel_idx
				, rtw_get_passing_time_ms(padapter->mlmepriv.scan_start_time)
				, stype ? 'A' : 'P', ss->scan_mode ? 'A' : 'P'
				, ss->ssid[0].SsidLength ? 'S' : ' '
				, ss->force_ssid_scan ? 'F' : ' '
			);
			#else
			RTW_INFO(FUNC_ADPT_FMT" %s ch:%u (idx:%d) at %dms, %c%c%c%c\n"
				, FUNC_ADPT_ARG(padapter)
				, mlmeext_scan_state_str(pmlmeext)
				, scan_ch
				, ss->channel_idx
				, rtw_get_passing_time_ms(padapter->mlmepriv.scan_start_time)
				, stype ? 'A' : 'P', ss->scan_mode ? 'A' : 'P'
				, ss->ssid[0].SsidLength ? 'S' : ' '
				, ss->force_ssid_scan ? 'F' : ' '
			);
			#endif /* CONFIG_P2P */
		#endif /*DBG_SITESURVEY*/
#ifdef DBG_FIXED_CHAN
		if (pmlmeext->fixed_chan != 0xff)
			RTW_INFO(FUNC_ADPT_FMT" fixed_chan:%u\n", pmlmeext->fixed_chan);
#endif

		site_survey(padapter, scan_ch, stype);

#if defined(CONFIG_ATMEL_RC_PATCH)
		if (check_fwstate(pmlmepriv, WIFI_ASOC_STATE) == _TRUE)
			scan_ms = 20;
		else
			scan_ms = 40;
#else
		#if defined(CONFIG_RTW_ACS) && defined(CONFIG_RTW_ACS_DBG)
		if (IS_ACS_ENABLE(padapter) && rtw_is_acs_st_valid(padapter))
			scan_ms = rtw_acs_get_adv_st(padapter);
		else
		#endif /*CONFIG_RTW_ACS*/
			scan_ms = ss->scan_ch_ms;
#endif

#if defined(CONFIG_ANTENNA_DIVERSITY) || defined(DBG_SCAN_SW_ANTDIV_BL)
		if (ss->is_sw_antdiv_bl_scan)
			scan_ms = scan_ms / 2;
#endif

#ifdef CONFIG_RTW_ACS
		if (IS_ACS_ENABLE(padapter)) {
			if (pparm->token)
				rtw_acs_trigger(padapter, scan_ms, scan_ch, NHM_PID_IEEE_11K_HIGH);
			else
				rtw_acs_trigger(padapter, scan_ms, scan_ch, NHM_PID_ACS);
		}
#endif

		set_survey_timer(pmlmeext, scan_ms);
		break;
	}

#ifdef CONFIG_SCAN_BACKOP
	case SCAN_BACKING_OP: {
		u8 back_ch, back_bw, back_ch_offset;
		u8 need_ch_setting_union = _TRUE;

#ifdef CONFIG_MCC_MODE
		need_ch_setting_union = rtw_hal_mcc_change_scan_flag(padapter,
				&back_ch, &back_bw, &back_ch_offset);
#endif /* CONFIG_MCC_MODE */

		if (need_ch_setting_union) {
			if (rtw_mi_get_ch_setting_union(padapter, &back_ch, &back_bw, &back_ch_offset) == 0) {
				rtw_warn_on(1);
				back_ch = pmlmeext->cur_channel;
				back_bw = pmlmeext->cur_bwmode;
				back_ch_offset = pmlmeext->cur_ch_offset;
			}
		}

		#ifdef DBG_SITESURVEY
			RTW_INFO(FUNC_ADPT_FMT" %s ch:%u, bw:%u, offset:%u at %dms\n"
				 , FUNC_ADPT_ARG(padapter)
				 , mlmeext_scan_state_str(pmlmeext)
				 , back_ch, back_bw, back_ch_offset
				, rtw_get_passing_time_ms(padapter->mlmepriv.scan_start_time)
				);
		#endif /*DBG_SITESURVEY*/
		set_channel_bwmode(padapter, back_ch, back_ch_offset, back_bw, _FALSE);

		sitesurvey_set_msr(padapter, _FALSE);

		val8 = 0; /* survey done */
		rtw_hal_set_hwreg(padapter, HW_VAR_MLME_SITESURVEY, (u8 *)(&val8));

		if (mlmeext_chk_scan_backop_flags(pmlmeext, SS_BACKOP_PS_ANNC)) {
			sitesurvey_set_igi(padapter);
			rtw_hal_macid_wakeup_all_used(padapter);
			rtw_ps_annc(padapter, 0);
		}

		mlmeext_set_scan_state(pmlmeext, SCAN_BACK_OP);
		ss->backop_time = rtw_get_current_time();

		if (mlmeext_chk_scan_backop_flags(pmlmeext, SS_BACKOP_TX_RESUME))
			rtw_mi_os_xmit_schedule(padapter);

		goto operation_by_state;
	}

	case SCAN_BACK_OP:
		if (rtw_get_passing_time_ms(ss->backop_time) >= ss->backop_ms
		    || pmlmeext->scan_abort
		   ) {
			mlmeext_set_scan_state(pmlmeext, SCAN_LEAVING_OP);
			goto operation_by_state;
		}
		set_survey_timer(pmlmeext, 50);
		break;

	case SCAN_LEAVING_OP:
		/*
		 * prepare to leave operating channel
		 */

		/* clear HW TX queue before scan */
		rtw_hal_set_hwreg(padapter, HW_VAR_CHECK_TXBUF, 0);

		rtw_hal_macid_sleep_all_used(padapter);
		if (mlmeext_chk_scan_backop_flags(pmlmeext, SS_BACKOP_PS_ANNC)
			&& rtw_ps_annc(padapter, 1)
		) {
			mlmeext_set_scan_state(pmlmeext, SCAN_PS_ANNC_WAIT);
			mlmeext_set_scan_next_state(pmlmeext, SCAN_LEAVE_OP);
			set_survey_timer(pmlmeext, 50); /* delay 50ms to protect nulldata(1) */
		} else {
			mlmeext_set_scan_state(pmlmeext, SCAN_LEAVE_OP);
			goto operation_by_state;
		}

		break;

	case SCAN_LEAVE_OP:
		/*
		* HW register and DM setting for enter scan
		*/

		if (mlmeext_chk_scan_backop_flags(pmlmeext, SS_BACKOP_PS_ANNC))
			sitesurvey_set_igi(padapter);

		sitesurvey_set_msr(padapter, _TRUE);

		val8 = 1; /* under site survey */
		rtw_hal_set_hwreg(padapter, HW_VAR_MLME_SITESURVEY, (u8 *)(&val8));

		mlmeext_set_scan_state(pmlmeext, SCAN_PROCESS);
		goto operation_by_state;

#endif /* CONFIG_SCAN_BACKOP */

#if defined(CONFIG_ANTENNA_DIVERSITY) || defined(DBG_SCAN_SW_ANTDIV_BL)
	case SCAN_SW_ANTDIV_BL:
		/*
		* 20100721
		* For SW antenna diversity before link, it needs to switch to another antenna and scan again.
		* It compares the scan result and select better one to do connection.
		*/
		ss->bss_cnt = 0;
		ss->channel_idx = 0;
		ss->is_sw_antdiv_bl_scan = 1;

		mlmeext_set_scan_next_state(pmlmeext, SCAN_PROCESS);
		set_survey_timer(pmlmeext, ss->scan_ch_ms);
		break;
#endif

#ifdef CONFIG_P2P
	case SCAN_TO_P2P_LISTEN:
		/*
		* Set the P2P State to the listen state of find phase
		* and set the current channel to the listen channel
		*/
		set_channel_bwmode(padapter,
				pwdinfo->listen_channel,
				CHAN_OFFSET_NO_EXT,
				CHANNEL_WIDTH_20,
				_FALSE);
		rtw_p2p_set_state(pwdinfo, P2P_STATE_FIND_PHASE_LISTEN);

		/* turn on phy-dynamic functions */
		rtw_phydm_ability_restore(padapter);

		sitesurvey_set_igi(padapter);

		mlmeext_set_scan_state(pmlmeext, SCAN_P2P_LISTEN);
		_set_timer(&pwdinfo->find_phase_timer, (u32)((u32)pwdinfo->listen_dwell * 100));
		break;

	case SCAN_P2P_LISTEN:
		mlmeext_set_scan_state(pmlmeext, SCAN_PROCESS);
		ss->channel_idx = 0;
		goto operation_by_state;
#endif /* CONFIG_P2P */

	case SCAN_COMPLETE:
#ifdef CONFIG_RTW_CFGVENDOR_RANDOM_MAC_OUI
		rtw_hal_set_hw_mac_addr(padapter, adapter_mac_addr(padapter));
#endif
#ifdef CONFIG_P2P
		if (rtw_p2p_chk_state(pwdinfo, P2P_STATE_SCAN)
		    || rtw_p2p_chk_state(pwdinfo, P2P_STATE_FIND_PHASE_SEARCH)
		   ) {
#ifdef CONFIG_CONCURRENT_MODE
			if (pwdinfo->driver_interface == DRIVER_WEXT) {
				if (rtw_mi_check_status(padapter, MI_LINKED))
					_set_timer(&pwdinfo->ap_p2p_switch_timer, 500);
			}
#endif

			rtw_p2p_set_state(pwdinfo, rtw_p2p_pre_state(pwdinfo));
		}
		rtw_p2p_findphase_ex_set(pwdinfo, P2P_FINDPHASE_EX_NONE);
#endif /* CONFIG_P2P */

		/* switch channel */
		survey_done_set_ch_bw(padapter);

		sitesurvey_set_msr(padapter, _FALSE);

		val8 = 0; /* survey done */
		rtw_hal_set_hwreg(padapter, HW_VAR_MLME_SITESURVEY, (u8 *)(&val8));

		/* turn on phy-dynamic functions */
		rtw_phydm_ability_restore(padapter);

		sitesurvey_set_igi(padapter);

#ifdef CONFIG_MCC_MODE
		/* start MCC fail, then tx null data */
		if (!rtw_hal_set_mcc_setting_scan_complete(padapter))
#endif
		{
			rtw_hal_macid_wakeup_all_used(padapter);
			rtw_ps_annc(padapter, 0);
		}

		/* apply rx ampdu setting */
		rtw_rx_ampdu_apply(padapter);

		mlmeext_set_scan_state(pmlmeext, SCAN_DISABLE);

		report_surveydone_event(padapter, ss->acs);
#ifdef CONFIG_RTW_ACS
		if (IS_ACS_ENABLE(padapter))
			rtw_acs_select_best_chan(padapter);
#endif

		issue_action_BSSCoexistPacket(padapter);
		issue_action_BSSCoexistPacket(padapter);
		issue_action_BSSCoexistPacket(padapter);

#ifdef CONFIG_RTW_80211K
		if (ss->token)
			rm_post_event(padapter, ss->token, RM_EV_survey_done);
#endif /* CONFIG_RTW_80211K */

		break;
	}

	return H2C_SUCCESS;
}

#endif

u8 setauth_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct setauth_parm *pparm = (struct setauth_parm *)pbuf;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);

	if (pparm->mode < dot11AuthAlgrthm_MaxNum)
		pmlmeinfo->auth_algo = pparm->mode;

	return H2C_SUCCESS;
}

#ifdef CONFIG_CMD_DISP
/*Set WEP key or Group Key*/
u8 setkey_hdl(struct _ADAPTER *a, struct setkey_parm *key,
	enum phl_cmd_type cmd_type,  u32 cmd_timeout)
{
	struct mlme_ext_info *info = &a->mlmeextpriv.mlmext_info;
	u8 keytype = 1; /* 1 for Group Key */
	u8 *mac;
	struct sta_info *sta;
	struct mlme_priv *pmlmepriv = &a->mlmepriv;


	if (MLME_IN_AP_STATE(info)
	    || MLME_IS_STATE(info, WIFI_FW_ADHOC_STATE))
		mac = adapter_mac_addr(a);
	else
		mac = get_bssid(&a->mlmepriv);
	sta = rtw_get_stainfo(&a->stapriv, mac);
	if (!sta) {
		RTW_ERR("%s: sta %pM not found\n", __func__, mac);
		goto exit;
	}

	/* main tx key for wep. */
	if (key->set_tx)
		a->mlmeextpriv.mlmext_info.key_index = key->keyid;

#ifdef CONFIG_LPS_PG
	if (adapter_to_pwrctl(a)->lps_level == LPS_PG)
		LPS_Leave(a, "SET_KEY");
#endif

	/* Change to Unicast for WEP */
	if (is_wep_enc(key->algorithm))
		keytype = 0;

	#ifdef CONFIG_IEEE80211W
	if (key->algorithm == _BIP_CMAC_128_)
		keytype = 2;
	#endif

	RTW_PRINT("%s: set %s key for %pM, kid:%d type:%u algo:%s\n",
		  __func__, is_wep_enc(key->algorithm)?"WEP":"group", mac,
		  key->keyid, keytype, security_type_str(key->algorithm));

	rtw_hw_add_key(a, sta, key->keyid, key->algorithm, keytype, key->key, cmd_type, cmd_timeout);
	if (pmlmepriv->cur_network.join_res != _TRUE)
		pmlmepriv->cur_network.join_res = -2;

exit:
	return H2C_SUCCESS;
}
#else
u8 setkey_hdl(struct _ADAPTER *a, u8 *pbuf)
{
	struct setkey_parm *key = (struct setkey_parm *)pbuf;
	struct mlme_ext_info *info = &a->mlmeextpriv.mlmext_info;
	u8 keytype = 1; /* 1 for Group Key */
	u8 *mac;
	struct sta_info *sta;
	struct mlme_priv *pmlmepriv = &a->mlmepriv;


	if (MLME_IN_AP_STATE(info)
	    || MLME_IS_STATE(info, WIFI_FW_ADHOC_STATE))
		mac = adapter_mac_addr(a);
	else
		mac = get_bssid(&a->mlmepriv);
	sta = rtw_get_stainfo(&a->stapriv, mac);
	if (!sta) {
		RTW_ERR("%s: sta %pM not found\n", __func__, mac);
		goto exit;
	}

	/* main tx key for wep. */
	if (key->set_tx)
		a->mlmeextpriv.mlmext_info.key_index = key->keyid;

#ifdef CONFIG_LPS_PG
	if (adapter_to_pwrctl(a)->lps_level == LPS_PG)
		LPS_Leave(a, "SET_KEY");
#endif

	/* Change to Unicast for WEP */
	if (is_wep_enc(key->algorithm))
		keytype = 0;

	#ifdef CONFIG_IEEE80211W
	if (key->algorithm == _BIP_CMAC_128_)
		keytype = 2;
	#endif

	RTW_PRINT("%s: set %s key for %pM, kid:%d type:%u algo:%s\n",
		  __func__, is_wep_enc(key->algorithm)?"WEP":"group", mac,
		  key->keyid, keytype, security_type_str(key->algorithm));

	rtw_hw_add_key(a, sta, key->keyid, key->algorithm, keytype, key->key, PHL_CMD_DIRECTLY, 0);
	if (pmlmepriv->cur_network.join_res != _TRUE)
		pmlmepriv->cur_network.join_res = -2;

exit:
	return H2C_SUCCESS;
}
#endif

void rtw_ap_wep_pk_setting(_adapter *adapter, struct sta_info *psta)
{
	struct security_priv *psecuritypriv = &adapter->securitypriv;
	u32 keyid = psecuritypriv->dot11PrivacyKeyIndex;
	struct set_stakey_parm sta_pparm;

	if (!is_wep_enc(psecuritypriv->dot11PrivacyAlgrthm))
		return;

	if (!(psecuritypriv->key_mask & BIT(keyid))) {
		RTW_ERR("%s: default key is not set! (mask %d, index %u)\n",
			__func__, psecuritypriv->key_mask, keyid);
		return;
	}

	_rtw_memset(&sta_pparm, 0, sizeof(sta_pparm));
	_rtw_memcpy(sta_pparm.addr, psta->phl_sta->mac_addr, ETH_ALEN);
	sta_pparm.algorithm = psecuritypriv->dot11PrivacyAlgrthm;
	sta_pparm.keyid = keyid;
	_rtw_memcpy(sta_pparm.key,
		    psecuritypriv->dot11DefKey[keyid].skey,
		    psecuritypriv->dot11DefKeylen[keyid]);
	sta_pparm.gk = 0;

	RTW_INFO("%s: set WEP key%d for %pM\n",
		 __func__, sta_pparm.keyid, sta_pparm.addr);

#ifdef CONFIG_CMD_DISP
	set_stakey_hdl(adapter, &sta_pparm, PHL_CMD_DIRECTLY, 0);
#else
	set_stakey_hdl(adapter, (u8 *)&sta_pparm);
#endif
}

#ifdef CONFIG_CMD_DISP
u8 set_stakey_hdl(struct _ADAPTER *a, struct set_stakey_parm *key,
					enum phl_cmd_type cmd_type,  u32 cmd_timeout)
{
	struct sta_priv *pstapriv = &a->stapriv;
	struct sta_info *sta;
	int err = 0;
	u8 ret = H2C_SUCCESS;


	sta = rtw_get_stainfo(pstapriv, key->addr);
	if (!sta) {
		RTW_ERR("%s: sta %pM not found\n", __func__, key->addr);
		ret = H2C_REJECTED;
		goto exit;
	}

	a->mlmeextpriv.mlmext_info.enc_algo = key->algorithm;

#ifdef CONFIG_LPS_PG
	if (adapter_to_pwrctl(a)->lps_level == LPS_PG)
		LPS_Leave(a, "SET_KEY");
#endif

	if (key->algorithm == _NO_PRIVACY_) {
		RTW_INFO("%s: del all key for %pM for _NO_PRIVACY_\n",
			 __func__, key->addr);
		err = rtw_hw_del_all_key(a, sta, PHL_CMD_DIRECTLY, 0);
	} else {
		RTW_INFO("%s: set %s key for %pM, kid:%d algo:%s\n",
			 __func__, key->gk?"group":"pairwise",
			 key->addr, key->keyid,
			 security_type_str(key->algorithm));

		err = rtw_hw_add_key(a, sta, key->keyid, key->algorithm,
				     key->gk, key->key, PHL_CMD_DIRECTLY, 0);
	}
	if (!(key->gk))
		ATOMIC_INC(&sta->keytrack);	/*CVE-2020-24587*/

	if (err)
		RTW_ERR("%s: FAIL to set %s key for %pM, kid:%d algo:%s !\n",
			__func__, key->gk?"group":"pairwise",
			key->addr, key->keyid,
			security_type_str(key->algorithm));
	#ifdef CONFIG_CORE_TXSC
	else {
		if (key->algorithm != _NO_PRIVACY_ && !key->gk)
			sta->txsc_sec_cam_idx = txsc_update_sec_cam_idx(a, sta, key->keyid);
		else
			sta->txsc_sec_cam_idx = 0;
	}
	#endif
	ret = H2C_SUCCESS_RSP;

exit:
	return ret;
}
#else
u8 set_stakey_hdl(struct _ADAPTER *a, u8 *pbuf)
{
	struct set_stakey_parm *key = (struct set_stakey_parm *)pbuf;
	struct sta_priv *pstapriv = &a->stapriv;
	struct sta_info *sta;
	int err = 0;
	u8 ret = H2C_SUCCESS;


	sta = rtw_get_stainfo(pstapriv, key->addr);
	if (!sta) {
		RTW_ERR("%s: sta %pM not found\n", __func__, key->addr);
		ret = H2C_REJECTED;
		goto exit;
	}

	a->mlmeextpriv.mlmext_info.enc_algo = key->algorithm;

#ifdef CONFIG_LPS_PG
	if (adapter_to_pwrctl(a)->lps_level == LPS_PG)
		LPS_Leave(a, "SET_KEY");
#endif

	if (key->algorithm == _NO_PRIVACY_) {
		RTW_INFO("%s: del all key for %pM for _NO_PRIVACY_\n",
			 __func__, key->addr);
		err = rtw_hw_del_all_key(a, sta, PHL_CMD_DIRECTLY, 0);
	} else {
		RTW_INFO("%s: set %s key for %pM, kid:%d algo:%s\n",
			 __func__, key->gk?"group":"pairwise",
			 key->addr, key->keyid,
			 security_type_str(key->algorithm));

		err = rtw_hw_add_key(a, sta, key->keyid, key->algorithm,
				     key->gk, key->key, PHL_CMD_DIRECTLY, 0);
	}
	if (!(key->gk))
		ATOMIC_INC(&sta->keytrack);	/*CVE-2020-24587*/

	if (err)
		RTW_ERR("%s: FAIL to set %s key for %pM, kid:%d algo:%s !\n",
			__func__, key->gk?"group":"pairwise",
			key->addr, key->keyid,
			security_type_str(key->algorithm));
	#ifdef CONFIG_CORE_TXSC
	else {
		if (key->algorithm != _NO_PRIVACY_ && !key->gk)
			sta->txsc_sec_cam_idx = txsc_update_sec_cam_idx(a, sta, key->keyid);
		else
			sta->txsc_sec_cam_idx = 0;
	}
	#endif
	ret = H2C_SUCCESS_RSP;

exit:
	return ret;
}
#endif

u8 add_ba_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct addBaReq_parm	*pparm = (struct addBaReq_parm *)pbuf;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	struct sta_info *psta = rtw_get_stainfo(&padapter->stapriv, pparm->addr);

	if (!psta)
		return	H2C_SUCCESS;

#ifdef CONFIG_80211N_HT
	if ((MLME_HAS_STATE(pmlmeinfo, WIFI_FW_ASSOC_SUCCESS) && (pmlmeinfo->HT_enable)) ||
	    MLME_IN_AP_STATE(pmlmeinfo)) {
		/* pmlmeinfo->ADDBA_retry_count = 0; */
		/* pmlmeinfo->candidate_tid_bitmap |= (0x1 << pparm->tid);		 */
		/* psta->htpriv.candidate_tid_bitmap |= BIT(pparm->tid); */
#ifdef CONFIG_24G_256QAM
		if (padapter->registrypriv.wifi_mib.vht_proprietary & VHT_2G_SURVEY &&
		    psta->vht_2g_chk_cnt < 5 &&
		    !psta->phl_sta->vht_2g_supported)
			rtw_vht_2g_survey(padapter, psta);
#endif /* CONFIG_24G_256QAM */
		issue_addba_req(padapter, pparm->addr, (u8)pparm->tid);
		_set_timer(&psta->addba_retry_timer, ADDBA_TO);
	}
#ifdef CONFIG_TDLS
	else if ((psta->tdls_sta_state & TDLS_LINKED_STATE) &&
		 (psta->htpriv.ht_option == _TRUE) &&
		 (psta->htpriv.ampdu_enable == _TRUE)) {
		issue_addba_req(padapter, pparm->addr, (u8)pparm->tid);
		_set_timer(&psta->addba_retry_timer, ADDBA_TO);
	}
#endif /* CONFIG */
	else
		psta->htpriv.candidate_tid_bitmap &= ~BIT(pparm->tid);
#endif /* CONFIG_80211N_HT */
	return	H2C_SUCCESS;
}


u8 add_ba_rsp_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct addBaRsp_parm *pparm = (struct addBaRsp_parm *)pbuf;
	struct recv_reorder_ctrl *preorder_ctrl;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *psta;
	u8 ret = _TRUE;

	psta = rtw_get_stainfo(pstapriv, pparm->addr);
	if (!psta)
		goto exit;

	if (pparm->status == 0) {
		rtw_phl_start_rx_ba_session(padapter->dvobj->phl, psta->phl_sta,
					    pparm->preq.dialog_token, 3,
					    pparm->start_seq, 0, pparm->tid,
					    pparm->size);
	}

	preorder_ctrl = &psta->recvreorder_ctrl[pparm->tid];

#ifdef CONFIG_24G_256QAM
	if (padapter->registrypriv.wifi_mib.vht_proprietary & VHT_2G_SURVEY &&
	    psta->vht_2g_chk_cnt < 5 &&
	    !psta->phl_sta->vht_2g_supported)
		rtw_vht_2g_survey(padapter, psta);
#endif /* CONFIG_24G_256QAM */

	#if 1
	issue_addba_rsp(padapter, pparm->addr, pparm->tid,
				       pparm->status, (padapter->registrypriv.agg_num_buf)?padapter->registrypriv.agg_num_buf:pparm->size,
				       &(pparm->preq));
	#else
	ret = issue_addba_rsp_wait_ack(padapter, pparm->addr, pparm->tid,
				       pparm->status, pparm->size,
				       &(pparm->preq), 3, 50);
	#endif

#ifdef CONFIG_UPDATE_INDICATE_SEQ_WHILE_PROCESS_ADDBA_REQ
	/* status = 0 means accept this addba req, so update indicate seq = start_seq under this compile flag */
	if (pparm->status == 0) {
		preorder_ctrl->indicate_seq = pparm->start_seq;
		#ifdef DBG_RX_SEQ
		RTW_INFO("DBG_RX_SEQ "FUNC_ADPT_FMT" tid:%u SN_UPDATE indicate_seq:%d, start_seq:%d\n"
			, FUNC_ADPT_ARG(padapter), preorder_ctrl->tid, preorder_ctrl->indicate_seq, pparm->start_seq);
		#endif
	}
#else
	rtw_set_bit(RTW_RECV_ACK_OR_TIMEOUT, &preorder_ctrl->rec_abba_rsp_ack);
	#ifdef DBG_RX_SEQ
	RTW_INFO("DBG_RX_SEQ "FUNC_ADPT_FMT" tid:%u SN_CLEAR indicate_seq:%d, "
                 "start_seq:%d preorder_ctrl->rec_abba_rsp_ack =%lu "
                 "pparm->preq.dialog_token=%d pparm->preq.ba_p_set=%d\n"
		, FUNC_ADPT_ARG(padapter)
		, preorder_ctrl->tid
		, preorder_ctrl->indicate_seq
		, pparm->start_seq
		, preorder_ctrl->rec_abba_rsp_ack
		, pparm->preq.dialog_token
		, pparm->preq.ba_p_set
		);
	#endif
#endif

	/*
	  * status = 0 means accept this addba req
	  * status = 37 means reject this addba req
	  */
	if (pparm->status == 0) {
		preorder_ctrl->enable = _TRUE;
		preorder_ctrl->ampdu_size = pparm->size;
	} else if (pparm->status == 37)
		preorder_ctrl->enable = _FALSE;

exit:
	return H2C_SUCCESS;
}

u8 delba_hdl(struct _ADAPTER *a, unsigned char *pbuf)
{
	struct addBaReq_parm *parm = (struct addBaReq_parm *)pbuf;
	struct sta_info *sta;


	sta = rtw_get_stainfo(&a->stapriv, parm->addr);
	if (!sta) {
		RTW_WARN(FUNC_ADPT_FMT ": No STA(" MAC_FMT ") for DELBA!\n",
			 FUNC_ADPT_ARG(a), MAC_ARG(parm->addr));
		return	H2C_SUCCESS;
	}

	rtw_phl_stop_rx_ba_session(a->dvobj->phl, sta->phl_sta, parm->tid);

	return	H2C_SUCCESS;
}

u8 chk_bmc_sleepq_cmd(_adapter *padapter)
{
	struct cmd_obj *cmd;
	struct cmd_priv *pcmdpriv = &(adapter_to_dvobj(padapter)->cmdpriv);
	u8 res = _SUCCESS;


	cmd = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (cmd == NULL) {
		res = _FAIL;
		goto exit;
	}
	cmd->padapter = padapter;

	init_h2fwcmd_w_parm_no_parm_rsp(cmd, CMD_CHK_BMCSLEEPQ);

	res = rtw_enqueue_cmd(pcmdpriv, cmd);

exit:
	return res;
}

u8 set_tx_beacon_cmd(_adapter *padapter, u8 flags)
{
	struct cmd_obj	*cmd;
	struct Tx_Beacon_param	*ptxBeacon_parm;
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct cmd_priv	*pcmdpriv = &(dvobj->cmdpriv);
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);
	struct submit_ctx sctx;
	u8	res = _SUCCESS, idx;
	int len_diff = 0, run_bit;

#ifdef  RTW_WKARD_AP_CMD_DISPATCH
	if(H2C_SUCCESS ==  tx_beacon_hdl(padapter, NULL))
		res = _SUCCESS;
	else
		res = _FAIL;
#else
	if (!rtw_test_and_set_bit(RTW_BCN_MSG_HDL_BIT_SET, &padapter->bcn_msg_hdl_state)) {

		idx = padapter->bcn_msg_hdl_idx;
		run_bit = (idx == 0) ? RTW_BCN_MSG_HDL_BIT_RUN_IDX0 : RTW_BCN_MSG_HDL_BIT_RUN_IDX1;

		if (!rtw_test_bit(run_bit, &padapter->bcn_msg_hdl_state) &&
			rtw_phl_is_dispr_msg_active(dvobj->phl, padapter->phl_role->hw_band, &padapter->bcn_msg_hdl[idx])) {
			/* there is already a beacon cmd in disp */
			RTW_DBG("[%s %d][%s][cpu%d] already exist, bypass\n", __func__, __LINE__, padapter->pnetdev->name, smp_processor_id());
			rtw_clear_bit(RTW_BCN_MSG_HDL_BIT_SET, &padapter->bcn_msg_hdl_state);
			goto exit;
		}

		/* another idx is free now */
		idx = (idx + 1) & 1;
		padapter->bcn_msg_hdl[idx] = 0;

		run_bit = (idx == 0) ? RTW_BCN_MSG_HDL_BIT_RUN_IDX0 : RTW_BCN_MSG_HDL_BIT_RUN_IDX1;
		rtw_clear_bit(run_bit, &padapter->bcn_msg_hdl_state);

		/*prepare cmd parameter*/
		ptxBeacon_parm = (struct Tx_Beacon_param *)rtw_zmalloc(sizeof(struct Tx_Beacon_param));
		if (ptxBeacon_parm == NULL) {
			res = _FAIL;
			rtw_clear_bit(RTW_BCN_MSG_HDL_BIT_SET, &padapter->bcn_msg_hdl_state);
			goto exit;
		}

		_rtw_memcpy(&(ptxBeacon_parm->network), &(pmlmeinfo->network), sizeof(WLAN_BSSID_EX));

		len_diff = update_hidden_ssid(
							ptxBeacon_parm->network.IEs + _BEACON_IE_OFFSET_
							, ptxBeacon_parm->network.IELength - _BEACON_IE_OFFSET_
							, pmlmeinfo->hidden_ssid_mode
						);

		ptxBeacon_parm->network.IELength += len_diff;
		ptxBeacon_parm->msg_hdl_idx = idx;

		/* need enqueue, prepare cmd_obj and enqueue */
		cmd = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
		if (cmd == NULL) {
			res = _FAIL;
			rtw_mfree((u8 *)ptxBeacon_parm, sizeof(*ptxBeacon_parm));
			rtw_clear_bit(RTW_BCN_MSG_HDL_BIT_SET, &padapter->bcn_msg_hdl_state);
			goto exit;
		}
		cmd->padapter = padapter;
		cmd->msg_hdl = &padapter->bcn_msg_hdl[idx];

		init_h2fwcmd_w_parm_no_rsp(cmd, ptxBeacon_parm, CMD_TX_BEACON);

		if (flags & RTW_CMDF_WAIT_ACK) {
			cmd->sctx = &sctx;
			rtw_sctx_init(&sctx, 10 * 1000);
		}

		res = rtw_enqueue_cmd(pcmdpriv, cmd);

		if (padapter->bcn_msg_hdl[idx] != 0) {
			padapter->bcn_msg_hdl_idx = idx;
			RTW_DBG("[%s %d][%s][cpu%d] set tx beacon cmd\n", __func__, __LINE__, padapter->pnetdev->name, smp_processor_id());
		}

		/* clear bit before wait ack */
		rtw_clear_bit(RTW_BCN_MSG_HDL_BIT_SET, &padapter->bcn_msg_hdl_state);

		if (res == _SUCCESS && (flags & RTW_CMDF_WAIT_ACK)) {
			rtw_sctx_wait(&sctx, __func__);
			_rtw_mutex_lock_interruptible(&pcmdpriv->sctx_mutex);
			if (sctx.status == RTW_SCTX_SUBMITTED)
				cmd->sctx = NULL;
			_rtw_mutex_unlock(&pcmdpriv->sctx_mutex);
		}
	}
#endif
exit:
	return res;
}

char UNKNOWN_EVT[16] = "UNKNOWN_EVT";
char *rtw_evt_name(struct rtw_evt_header *pev)
{
	if (pev->id >= EVT_ID_MAX)
		return UNKNOWN_EVT;

	return wlanevents[pev->id].name;
}

u8 mlme_evt_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct rtw_evt_header *evt_hdr;
	u8 *peventbuf;
	void (*event_callback)(_adapter *dev, u8 *pbuf);
	struct evt_priv *pevt_priv = &(padapter->evtpriv);

	if (pbuf == NULL)
		goto _abort_event_;

	evt_hdr = (struct rtw_evt_header *)pbuf;
	peventbuf = pbuf + sizeof(struct rtw_evt_header);

#ifdef CHECK_EVENT_SEQ
	/* checking event sequence...		 */
	if (evt_hdr->seq != (ATOMIC_READ(&pevt_priv->event_seq) & 0x7f)) {
		pevt_priv->event_seq = (evt_hdr->seq + 1) & 0x7f;
		goto _abort_event_;
	}
#endif

	/* checking if event code is valid */
	if (evt_hdr->id >= EVT_ID_MAX) {
		goto _abort_event_;
	}

	/* checking if event size match the event parm size	 */
	if ((wlanevents[evt_hdr->id].parmsize != 0) &&
	    (wlanevents[evt_hdr->id].parmsize != evt_hdr->len)) {

		goto _abort_event_;

	}

	ATOMIC_INC(&pevt_priv->event_seq);

	if (peventbuf) {
		event_callback = wlanevents[evt_hdr->id].event_callback;
		event_callback(padapter, (u8 *)peventbuf);
		pevt_priv->evt_done_cnt++;
	}

_abort_event_:
	return H2C_SUCCESS;

}

u8 chk_bmc_sleepq_hdl(_adapter *padapter, unsigned char *pbuf)
{
#ifdef CONFIG_AP_MODE
	struct sta_info *psta_bmc;
	_list	*xmitframe_plist, *xmitframe_phead;
	struct xmit_frame *pxmitframe = NULL;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct sta_priv  *pstapriv = &padapter->stapriv;

	/* for BC/MC Frames */
	psta_bmc = rtw_get_bcmc_stainfo(padapter);
	if (!psta_bmc)
		return H2C_SUCCESS;

	if (rtw_tim_map_is_set(padapter, pstapriv->tim_bitmap, 0) && (psta_bmc->sleep_q.qlen > 0)) {
#ifndef CONFIG_PCI_HCI
		rtw_msleep_os(10);/* 10ms, ATIM(HIQ) Windows */
#endif

		if (rtw_get_intf_type(padapter) != RTW_HCI_PCIE) {
			/* check hi queue and bmc_sleepq */
			rtw_chk_hi_queue_cmd(padapter);
		}
	}
#endif

	return H2C_SUCCESS;
}

u8 tx_beacon_hdl(_adapter *padapter, unsigned char *pbuf)
{
	/*RTW_INFO(FUNC_ADPT_FMT, FUNC_ADPT_ARG(padapter));*/
	if (send_beacon(padapter) == _FAIL) {
		RTW_INFO("issue_beacon, fail!\n");
		return H2C_PARAMETERS_ERROR;
	}

	/* tx bc/mc frames after update TIM */
	chk_bmc_sleepq_hdl(padapter, NULL);
	return H2C_SUCCESS;
}

/* for CMD_TX_BEACON only */
u8 tx_beacon_cmd_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct Tx_Beacon_param *ptxBeacon_parm = (struct Tx_Beacon_param *)pbuf;
	int run_bit = (ptxBeacon_parm->msg_hdl_idx == 0) ? RTW_BCN_MSG_HDL_BIT_RUN_IDX0 : RTW_BCN_MSG_HDL_BIT_RUN_IDX1;;

	rtw_set_bit(run_bit, &padapter->bcn_msg_hdl_state);

	return tx_beacon_hdl(padapter, pbuf);
}

/*
* according to channel
* add/remove WLAN_BSSID_EX.IEs's ERP ie
* set WLAN_BSSID_EX.SupportedRates
* update WLAN_BSSID_EX.IEs's Supported Rate and Extended Supported Rate ie
*/
void change_band_update_ie(_adapter *padapter, WLAN_BSSID_EX *pnetwork, u8 ch)
{
	u8	network_type, rate_len, total_rate_len, remainder_rate_len;
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
	u8	erpinfo = 0x4;

	if (ch >= 36) {
		network_type = WLAN_MD_11A;
		total_rate_len = IEEE80211_NUM_OFDM_RATESLEN;
		rtw_remove_bcn_ie(padapter, pnetwork, _ERPINFO_IE_);
		#ifdef CONFIG_80211AC_VHT
		/* if channel in 5G band, then add vht ie . */
		if ((pmlmepriv->htpriv.ht_option == _TRUE)
			&& REGSTY_IS_11AC_ENABLE(&padapter->registrypriv)
			&& is_supported_vht(padapter->registrypriv.wireless_mode)
			&& (!rfctl->country_ent || COUNTRY_CHPLAN_EN_11AC(rfctl->country_ent))
		) {
			if (REGSTY_IS_11AC_AUTO(&padapter->registrypriv)
				|| pmlmepriv->ori_vht_en)
				rtw_vht_ies_attach(padapter, pnetwork);
		}
		#endif
		#ifdef CONFIG_80211AX_HE
		/* CONFIG_80211AX_HE_TODO */
		#endif
	} else {
		network_type = 0;
		total_rate_len = 0;
		if (padapter->registrypriv.wireless_mode & WLAN_MD_11B) {
			network_type |= WLAN_MD_11B;
			total_rate_len += IEEE80211_CCK_RATE_LEN;
		}
		if (padapter->registrypriv.wireless_mode & WLAN_MD_11G) {
			network_type |= WLAN_MD_11G;
			total_rate_len += IEEE80211_NUM_OFDM_RATESLEN;
		}
		rtw_add_bcn_ie(padapter, pnetwork, _ERPINFO_IE_, &erpinfo, 1);
		#if defined(CONFIG_80211AC_VHT) && !defined(CONFIG_24G_256QAM)
		rtw_vht_ies_detach(padapter, pnetwork);
		#endif /* defined(CONFIG_80211AC_VHT) && !defined(CONFIG_24G_256QAM) */
		#ifdef CONFIG_80211AX_HE
		/* CONFIG_80211AX_HE_TODO */
		#endif
	}

	rtw_set_supported_rate(pnetwork->SupportedRates, network_type, ch);

	UpdateBrateTbl(padapter, pnetwork->SupportedRates);

	if (total_rate_len > 8) {
		rate_len = 8;
		remainder_rate_len = total_rate_len - 8;
	} else {
		rate_len = total_rate_len;
		remainder_rate_len = 0;
	}

	rtw_add_bcn_ie(padapter, pnetwork, _SUPPORTEDRATES_IE_, pnetwork->SupportedRates, rate_len);

	if (remainder_rate_len)
		rtw_add_bcn_ie(padapter, pnetwork, _EXT_SUPPORTEDRATES_IE_, (pnetwork->SupportedRates + 8), remainder_rate_len);
	else
		rtw_remove_bcn_ie(padapter, pnetwork, _EXT_SUPPORTEDRATES_IE_);

	pnetwork->Length = get_WLAN_BSSID_EX_sz(pnetwork);
}

void rtw_upt_all_chanctx(_adapter *adapter, u8 ch, u8 offset, u8 bw)
{
	_adapter *iface = NULL;
	struct dvobj_priv *dvobj = NULL;
	struct mlme_priv *mlme = NULL;
	struct rtw_chan_def new_chdef = {0};
	struct rtw_mr_chctx_info mr_cc_info = {0};
	bool is_chctx_add = false;
	int i = 0, chanctx_num = 0;

	dvobj = adapter_to_dvobj(adapter);

	new_chdef.chan = ch;
	new_chdef.bw = bw;
	new_chdef.offset = offset;
	new_chdef.band = rtw_phl_get_band_type(new_chdef.chan);

	RTW_INFO(FUNC_ADPT_FMT"new chdef: CH:%d, BW:%d OFF:%d\n",
			FUNC_ADPT_ARG(adapter), new_chdef.chan, new_chdef.bw, new_chdef.offset);

	/* delete chanctx */
	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		mlme = &iface->mlmepriv;

		if (!iface || iface == adapter)
			continue;

		if ((MLME_IS_AP(iface) || MLME_IS_MESH(iface))
			&& check_fwstate(mlme, WIFI_ASOC_STATE)
		) {
			chanctx_num = rtw_phl_chanctx_del(dvobj->phl, iface->phl_role, NULL);

			RTW_INFO(FUNC_ADPT_FMT"chctx_del: num:%d\n",
				FUNC_ADPT_ARG(adapter), chanctx_num);
		}
	}

	/* add chanctx */
	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		mlme = &iface->mlmepriv;

		if (!iface || iface == adapter)
			continue;

		if ((MLME_IS_AP(iface) || MLME_IS_MESH(iface))
			&& check_fwstate(mlme, WIFI_ASOC_STATE)
		) {
			is_chctx_add = rtw_phl_chanctx_add(dvobj->phl, iface->phl_role,
						&new_chdef, &mr_cc_info);

			RTW_INFO(FUNC_ADPT_FMT"chctx_add:%s\n",
				FUNC_ADPT_ARG(adapter), (is_chctx_add) ? "Y" : "N");
			RTW_INFO(FUNC_ADPT_FMT"PHL- CH:%d, BW:%d OFF:%d\n",
				FUNC_ADPT_ARG(adapter), new_chdef.chan, new_chdef.bw, new_chdef.offset);
		}
	}

	return;
}

#ifdef CONFIG_NEC_SYNC_REMOTEAP_BW
void nec_sync_bw_to_ap(_adapter *adapter, u8 u_ch, u8 u_bw, u8 u_offset)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(adapter);
	_adapter *iface = NULL;
	u8 idx = 0;
	u32 ifbmp = 0;

	/* get all ap bmp */
	for (idx = 0; idx < dvobj->iface_nums; idx++) {
		iface = dvobj->padapters[idx];
		if (!iface)
			continue;

		if (CHK_MLME_STATE(iface, WIFI_AP_STATE) && iface->netif_up) {
			ifbmp |= BIT(idx);
		}
	}

	if (ifbmp) {
		RTW_PRINT(FUNC_ADPT_FMT" sync C(%u) B(%u) O(%u) ifbmp(%x)\n",
			FUNC_ADPT_ARG(adapter), u_ch, u_bw, u_offset, ifbmp);

		rtw_change_bss_chbw_cmd(adapter, RTW_CMDF_WAIT_ACK, ifbmp, 0, u_ch, u_bw, u_offset);
	}
}
#endif /*CONFIG_NEC_SYNC_REMOTEAP_BW*/

void rtw_join_done_chk_ch(_adapter *adapter, int join_res)
{
#define DUMP_ADAPTERS_STATUS 0

	struct dvobj_priv *dvobj;
	_adapter *iface;
	struct mlme_priv *mlme;
	struct mlme_ext_priv *mlmeext;
	u8 u_ch, u_offset, u_bw;
	int i, ret;

	dvobj = adapter_to_dvobj(adapter);

	if (DUMP_ADAPTERS_STATUS) {
		RTW_INFO(FUNC_ADPT_FMT" enter\n", FUNC_ADPT_ARG(adapter));
		dump_adapters_status(RTW_DBGDUMP , dvobj);
	}

	ret = rtw_mi_get_ch_setting_union(adapter, &u_ch, &u_bw, &u_offset);
	if (join_res >= 0 && ret <= 0) {
		join_res = -1;
		dump_adapters_status(RTW_DBGDUMP , dvobj);
		RTW_PRINT("Find union about ch, bw, ch_offset of all linked/linking interfaces fail\n");
	}

	if (join_res >= 0) {
#ifdef CONFIG_MCC_MODE
		/* MCC setting success, don't go to ch union process */
		if (rtw_hal_set_mcc_setting_join_done_chk_ch(adapter))
			return;
#endif /* CONFIG_MCC_MODE */

		for (i = 0; i < dvobj->iface_nums; i++) {
			iface = dvobj->padapters[i];
			mlme = &iface->mlmepriv;
			mlmeext = &iface->mlmeextpriv;

			if (!iface || iface == adapter)
				continue;

			if ((MLME_IS_AP(iface) || MLME_IS_MESH(iface))
				&& check_fwstate(mlme, WIFI_ASOC_STATE)
			) {
				u8 ori_ch, ori_bw, ori_offset;
				bool is_grouped = rtw_is_chbw_grouped(u_ch, u_bw, u_offset
					, mlmeext->cur_channel, mlmeext->cur_bwmode, mlmeext->cur_ch_offset);

				if (is_grouped == _FALSE) {
					/* handle AP which need to switch ch setting */

					ori_ch = mlmeext->cur_channel;
					ori_bw = mlmeext->cur_bwmode;
					ori_offset = mlmeext->cur_ch_offset;

					/* restore original bw, adjust bw by registry setting on target ch */
					mlmeext->cur_bwmode = mlme->ori_bw;
					mlmeext->cur_channel = u_ch;
					rtw_adjust_chbw(iface, mlmeext->cur_channel, &mlmeext->cur_bwmode, &mlmeext->cur_ch_offset);
					#ifdef CONFIG_RTW_MESH
					if (MLME_IS_MESH(iface))
						rtw_mesh_adjust_chbw(mlmeext->cur_channel, &mlmeext->cur_bwmode, &mlmeext->cur_ch_offset);
					#endif

					rtw_chset_sync_chbw(adapter_to_chset(adapter)
						, &mlmeext->cur_channel, &mlmeext->cur_bwmode, &mlmeext->cur_ch_offset
						, &u_ch, &u_bw, &u_offset, 1, 0);

					RTW_INFO(FUNC_ADPT_FMT" %u,%u,%u => %u,%u,%u\n", FUNC_ADPT_ARG(iface)
						, ori_ch, ori_bw, ori_offset
						, mlmeext->cur_channel, mlmeext->cur_bwmode, mlmeext->cur_ch_offset);

					rtw_ap_update_bss_chbw(iface, &(mlmeext->mlmext_info.network)
						, mlmeext->cur_channel, mlmeext->cur_bwmode, mlmeext->cur_ch_offset);

					_rtw_memcpy(&(mlme->cur_network.network), &(mlmeext->mlmext_info.network), sizeof(WLAN_BSSID_EX));

					rtw_start_bss_hdl_after_chbw_decided(iface);

					{
						#if defined(CONFIG_IOCTL_CFG80211) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 5, 0))
						u8 ht_option = 0;

						#ifdef CONFIG_80211N_HT
						ht_option = mlme->htpriv.ht_option;
						#endif

						rtw_cfg80211_ch_switch_notify(iface
							, mlmeext->cur_channel, mlmeext->cur_bwmode, mlmeext->cur_ch_offset
							, ht_option, 0);
						#endif
					}
				}

				clr_fwstate(mlme, WIFI_OP_CH_SWITCHING);
				update_beacon(iface, 0xFFF, NULL, _TRUE, 0);
			}
		}

#ifdef CONFIG_DFS_MASTER
		rtw_dfs_rd_en_decision(adapter, MLME_STA_CONNECTED, 0);
#endif
	} else {
		for (i = 0; i < dvobj->iface_nums; i++) {
			iface = dvobj->padapters[i];
			mlme = &iface->mlmepriv;
			mlmeext = &iface->mlmeextpriv;

			if (!iface || iface == adapter)
				continue;

			if ((MLME_IS_AP(iface) || MLME_IS_MESH(iface))
				&& check_fwstate(mlme, WIFI_ASOC_STATE)
			) {
				clr_fwstate(mlme, WIFI_OP_CH_SWITCHING);
				update_beacon(iface, 0xFFF, NULL, _TRUE, 0);
			}
		}
#ifdef CONFIG_DFS_MASTER
		rtw_dfs_rd_en_decision(adapter, MLME_STA_DISCONNECTED, 0);
#endif
	}

	if (rtw_mi_get_ch_setting_union(adapter, &u_ch, &u_bw, &u_offset)) {
		RTW_INFO(FUNC_ADPT_FMT" union:%u,%u,%u\n", FUNC_ADPT_ARG(adapter), u_ch, u_bw, u_offset);
#ifdef CONFIG_NEC_SYNC_REMOTEAP_BW
		RTW_PRINT(FUNC_ADPT_FMT" change bw config: (%u,%u,%u) => (%u,%u,%u)\n",
			FUNC_ADPT_ARG(adapter), u_ch, u_bw, u_offset,
			adapter->mlmeextpriv.cur_channel,
			adapter->mlmeextpriv.cur_bwmode,
			adapter->mlmeextpriv.cur_ch_offset);
		u_ch = adapter->mlmeextpriv.cur_channel;
		u_bw = adapter->mlmeextpriv.cur_bwmode;
		u_offset = adapter->mlmeextpriv.cur_ch_offset;
#endif /*CONFIG_NEC_SYNC_REMOTEAP_BW*/

		set_channel_bwmode(adapter, u_ch, u_offset, u_bw, _FALSE);
		rtw_mi_update_union_chan_inf(adapter, u_ch, u_offset, u_bw);
		rtw_upt_all_chanctx(adapter, u_ch, u_offset, u_bw);
	}

	if (DUMP_ADAPTERS_STATUS) {
		RTW_INFO(FUNC_ADPT_FMT" exit\n", FUNC_ADPT_ARG(adapter));
		dump_adapters_status(RTW_DBGDUMP , dvobj);
	}
#ifdef CONFIG_NEC_SYNC_REMOTEAP_BW
	nec_sync_bw_to_ap(adapter, u_ch, u_bw, u_offset);
#endif
}

int rtw_chk_start_clnt_join(_adapter *adapter, u8 *ch, u8 *bw, u8 *offset)
{
#ifdef CONFIG_CONCURRENT_MODE
	bool chbw_allow = _TRUE;
#endif
	bool connect_allow = _TRUE;
	struct mlme_ext_priv	*pmlmeext = &adapter->mlmeextpriv;
	u8 cur_ch, cur_bw, cur_ch_offset;
	u8 u_ch, u_offset, u_bw;

	u_ch = cur_ch = pmlmeext->cur_channel;
	u_bw = cur_bw = pmlmeext->cur_bwmode;
	u_offset = cur_ch_offset = pmlmeext->cur_ch_offset;

	if (!ch || !bw || !offset) {
		connect_allow = _FALSE;
		RTW_ERR(FUNC_ADPT_FMT" ch/bw/offset is NULL! ch: %p bw: %p offset: %p\n"
			, FUNC_ADPT_ARG(adapter), ch, bw, offset);
		goto exit;
	}

	if (cur_ch == 0) {
		connect_allow = _FALSE;
		RTW_ERR(FUNC_ADPT_FMT" cur_ch:%u\n"
			, FUNC_ADPT_ARG(adapter), cur_ch);
		goto exit;
	}
	RTW_INFO(FUNC_ADPT_FMT" req: %u,%u,%u\n", FUNC_ADPT_ARG(adapter), u_ch, u_bw, u_offset);

#ifdef CONFIG_CONCURRENT_MODE
	{
		struct dvobj_priv *dvobj;
		_adapter *iface;
		struct mlme_priv *mlme;
		struct mlme_ext_priv *mlmeext;
		struct mi_state mstate;
		int i;

		dvobj = adapter_to_dvobj(adapter);

		rtw_mi_status_no_self(adapter, &mstate);
		RTW_INFO(FUNC_ADPT_FMT" others ld_sta_num:%u, ap_num:%u, mesh_num:%u\n"
			, FUNC_ADPT_ARG(adapter), MSTATE_STA_LD_NUM(&mstate)
			, MSTATE_AP_NUM(&mstate), MSTATE_MESH_NUM(&mstate));

		if (!MSTATE_STA_LD_NUM(&mstate) && !MSTATE_AP_NUM(&mstate) && !MSTATE_MESH_NUM(&mstate)) {
			/* consider linking STA? */
			goto connect_allow_hdl;
		}

		if (rtw_mi_get_ch_setting_union_no_self(adapter, &u_ch, &u_bw, &u_offset) <= 0) {
			dump_adapters_status(RTW_DBGDUMP , dvobj);
			RTW_ERR(FUNC_ADPT_FMT" get u_ch, u_bw, u_offset error\n"
				, FUNC_ADPT_ARG(adapter));
		}
		RTW_INFO(FUNC_ADPT_FMT" others union:%u,%u,%u\n"
			 , FUNC_ADPT_ARG(adapter), u_ch, u_bw, u_offset);

		/* chbw_allow? */
		chbw_allow = rtw_is_chbw_grouped(pmlmeext->cur_channel, pmlmeext->cur_bwmode, pmlmeext->cur_ch_offset
						 , u_ch, u_bw, u_offset);

		RTW_INFO(FUNC_ADPT_FMT" chbw_allow:%d\n"
			 , FUNC_ADPT_ARG(adapter), chbw_allow);

#ifdef CONFIG_MCC_MODE
		/* check setting success, don't go to ch union process */
		if (rtw_hal_set_mcc_setting_chk_start_clnt_join(adapter, &u_ch, &u_bw, &u_offset, chbw_allow))
			goto exit;
#endif

		if (chbw_allow == _TRUE) {
			rtw_sync_chbw(&cur_ch, &cur_bw, &cur_ch_offset, &u_ch, &u_bw, &u_offset);
			/*
			rtw_warn_on(cur_ch != pmlmeext->cur_channel);
			rtw_warn_on(cur_bw != pmlmeext->cur_bwmode);
			rtw_warn_on(cur_ch_offset != pmlmeext->cur_ch_offset);
			*/
			goto connect_allow_hdl;
		}

#ifdef CONFIG_CFG80211_ONECHANNEL_UNDER_CONCURRENT
		/* chbw_allow is _FALSE, connect allow? */
		for (i = 0; i < dvobj->iface_nums; i++) {
			iface = dvobj->padapters[i];
			mlme = &iface->mlmepriv;

			if (MLME_IS_STA(iface)
			    && check_fwstate(mlme, WIFI_ASOC_STATE)
#if defined(CONFIG_P2P)
			    && rtw_p2p_chk_state(&(iface->wdinfo), P2P_STATE_NONE)
#endif
			   ) {
				connect_allow = _FALSE;
				break;
			}
		}
#endif /* CONFIG_CFG80211_ONECHANNEL_UNDER_CONCURRENT */

		if (MSTATE_STA_LD_NUM(&mstate) + MSTATE_AP_LD_NUM(&mstate) + MSTATE_MESH_LD_NUM(&mstate) >= 4)
			connect_allow = _FALSE;

		RTW_INFO(FUNC_ADPT_FMT" connect_allow:%d\n"
			 , FUNC_ADPT_ARG(adapter), connect_allow);

		if (connect_allow == _FALSE)
			goto exit;

connect_allow_hdl:
		/* connect_allow == _TRUE */

		if (chbw_allow == _FALSE) {
			u_ch = cur_ch;
			u_bw = cur_bw;
			u_offset = cur_ch_offset;

			for (i = 0; i < dvobj->iface_nums; i++) {
				iface = dvobj->padapters[i];
				mlme = &iface->mlmepriv;

				if (!iface || iface == adapter)
					continue;

				if ((MLME_IS_AP(iface) || MLME_IS_MESH(iface))
					&& check_fwstate(mlme, WIFI_ASOC_STATE)
				) {
					#ifdef CONFIG_SPCT_CH_SWITCH
					if (1)
						rtw_ap_inform_ch_switch(iface, pmlmeext->cur_channel , pmlmeext->cur_ch_offset);
					else
					#endif
						rtw_sta_flush(iface, _FALSE, _FALSE);

					rtw_hal_set_hwreg(iface, HW_VAR_CHECK_TXBUF, 0);
					set_fwstate(mlme, WIFI_OP_CH_SWITCHING);

				} else if (MLME_IS_STA(iface)
					&& check_fwstate(mlme, WIFI_ASOC_STATE)
				) {
					rtw_disassoc_cmd(iface, 500, RTW_CMDF_DIRECTLY);
					rtw_indicate_disconnect(iface, 0, _FALSE);
					rtw_free_assoc_resources(iface, _TRUE);
				}
			}
		}

		#ifdef CONFIG_DFS_MASTER
		rtw_dfs_rd_en_decision(adapter, MLME_STA_CONNECTING, 0);
		#endif
	}
#endif /* CONFIG_CONCURRENT_MODE */

exit:

	if (connect_allow == _TRUE) {
		RTW_INFO(FUNC_ADPT_FMT" union: %u,%u,%u\n", FUNC_ADPT_ARG(adapter), u_ch, u_bw, u_offset);
		*ch = u_ch;
		*bw = u_bw;
		*offset = u_offset;

#if defined(CONFIG_IOCTL_CFG80211) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 5, 0))
		{
			u8 ht_option = 0;

#ifdef CONFIG_80211N_HT
			ht_option = adapter->mlmepriv.htpriv.ht_option;
#endif /* CONFIG_80211N_HT */

			/*
				when supplicant send the mlme frame,
				the bss freq is updated by channel switch event.
			*/
			rtw_cfg80211_ch_switch_notify(adapter,
				cur_ch, cur_bw, cur_ch_offset, ht_option, 1);
		}
#endif
	}

	return connect_allow == _TRUE ? _SUCCESS : _FAIL;
}

void rtw_set_external_auth_status(_adapter *padapter,
	const void *data, int len)
{
#ifdef CONFIG_IOCTL_CFG80211
	struct net_device *dev = padapter->pnetdev;
	struct wiphy *wiphy = adapter_to_wiphy(padapter);
	struct cfg80211_external_auth_params params = {0};

	/* convert data to external_auth_params */
	params.action = RTW_GET_BE32((u8 *)data);
	_rtw_memcpy(&params.bssid, (u8 *)data + 4, ETH_ALEN);
	_rtw_memcpy(&params.ssid.ssid, (u8 *)data + 10, WLAN_SSID_MAXLEN);
	params.ssid.ssid_len = RTW_GET_BE64((u8 *)data + 42);
	params.key_mgmt_suite = RTW_GET_BE32((u8 *)data + 58);
	params.status = RTW_GET_BE16((u8 *)data + 62);
	params.pmkid = (u8 *)data + 64;

	rtw_cfg80211_external_auth_status(wiphy, dev, &params);
#endif /* CONFIG_IOCTL_CFG80211 */
}

u8 rtw_set_chbw_hdl(_adapter *padapter, u8 *pbuf)
{
	struct set_ch_parm *set_ch_parm;
	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;

	if (!pbuf)
		return H2C_PARAMETERS_ERROR;

	set_ch_parm = (struct set_ch_parm *)pbuf;

	RTW_INFO(FUNC_NDEV_FMT" ch:%u, bw:%u, ch_offset:%u\n",
		 FUNC_NDEV_ARG(padapter->pnetdev),
		 set_ch_parm->ch, set_ch_parm->bw, set_ch_parm->ch_offset);

	pmlmeext->cur_channel = set_ch_parm->ch;
	pmlmeext->cur_ch_offset = set_ch_parm->ch_offset;
	pmlmeext->cur_bwmode = set_ch_parm->bw;

	set_channel_bwmode(padapter,
				set_ch_parm->ch,
				set_ch_parm->ch_offset,
				set_ch_parm->bw,
				set_ch_parm->do_rfk);

	return	H2C_SUCCESS;
}

static bool rtw_set_country_ent(_adapter *padapter, const struct country_chplan *country_ent)
{
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
	u8 ret = _TRUE;

	if (country_ent) {
		if (rfctl->country_ent) {
			_rtw_memcpy(rfctl->country_ent, country_ent, sizeof(struct country_chplan));
		} else {
			rfctl->country_ent = rtw_malloc(sizeof(struct country_chplan));
			if (!rfctl->country_ent) {
				RTW_ERR(FUNC_NDEV_FMT"allocate country_ent fail\n", FUNC_NDEV_ARG(padapter->pnetdev));
				ret = _FALSE;
			} else {
				_rtw_memcpy(rfctl->country_ent, country_ent, sizeof(struct country_chplan));
			}
		}

	} else {
		if (rfctl->country_ent) {
			rtw_mfree(rfctl->country_ent, sizeof(struct country_chplan));
			rfctl->country_ent = NULL;
		}
	}

	return ret;
}

u8 set_chplan_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct SetChannelPlan_param *setChannelPlan_param;
	struct rf_ctl_t *rfctl = adapter_to_rfctl(padapter);
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	if (!pbuf)
		return H2C_PARAMETERS_ERROR;

	setChannelPlan_param = (struct SetChannelPlan_param *)pbuf;

	if (!rtw_is_channel_plan_valid(setChannelPlan_param->channel_plan))
		return H2C_PARAMETERS_ERROR;

	if (!rtw_set_country_ent(padapter, setChannelPlan_param->country_ent))
		return H2C_CMD_FAIL;

	rfctl->ChannelPlan = setChannelPlan_param->channel_plan;
#if CONFIG_IEEE80211_BAND_6GHZ
	rfctl->chplan_6g = setChannelPlan_param->channel_plan_6g;
#endif

#if CONFIG_TXPWR_LIMIT
	rtw_txpwr_init_regd(rfctl);
#endif

	rtw_rfctl_chplan_init(dvobj);

#ifdef CONFIG_IOCTL_CFG80211
	rtw_regd_apply_flags(adapter_to_wiphy(padapter));
#endif

	return	H2C_SUCCESS;
}

u8 led_blink_hdl(_adapter *padapter, unsigned char *pbuf)
{
	struct LedBlink_param *ledBlink_param;

	if (!pbuf)
		return H2C_PARAMETERS_ERROR;

	ledBlink_param = (struct LedBlink_param *)pbuf;

#ifdef CONFIG_RTW_LED_HANDLED_BY_CMD_THREAD
	BlinkHandler((PLED_DATA)ledBlink_param->pLed);
#endif

	return	H2C_SUCCESS;
}

u8 set_csa_hdl(_adapter *adapter, unsigned char *pbuf)
{
#ifndef RTW_PHL_TEST_FPGA
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);

	if (rfctl->csa_ch)
		rtw_ch_switch_hdl(adapter_to_dvobj(adapter));
#endif

	return	H2C_SUCCESS;
}

u8 tdls_hdl(_adapter *padapter, unsigned char *pbuf)
{
#ifdef CONFIG_TDLS
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(adapter_to_dvobj(padapter));
	struct tdls_info *ptdlsinfo = &padapter->tdlsinfo;
#ifdef CONFIG_TDLS_CH_SW
	struct tdls_ch_switch *pchsw_info = &ptdlsinfo->chsw_info;
#endif
	struct TDLSoption_param *TDLSoption;
	struct sta_info *ptdls_sta = NULL;
	struct mlme_ext_priv *pmlmeext = &padapter->mlmeextpriv;
	struct mlme_ext_info *pmlmeinfo = &pmlmeext->mlmext_info;
	struct sta_info *ap_sta = rtw_get_stainfo(&padapter->stapriv, get_my_bssid(&(pmlmeinfo->network)));
	u8 survey_channel, i, min, option;
	struct tdls_txmgmt txmgmt;
	u32 setchtime, resp_sleep = 0, wait_time;
	u8 zaddr[ETH_ALEN] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	u8 ret;
	u8 do_rfk;
	u64 tx_ra_bitmap = 0;

	if (!pbuf)
		return H2C_PARAMETERS_ERROR;

	TDLSoption = (struct TDLSoption_param *)pbuf;
	option = TDLSoption->option;

	if (!_rtw_memcmp(TDLSoption->addr, zaddr, ETH_ALEN)) {
		ptdls_sta = rtw_get_stainfo(&(padapter->stapriv), TDLSoption->addr);
		if (ptdls_sta == NULL)
			return H2C_REJECTED;
	} else {
		if (!(option == TDLS_RS_RCR))
			return H2C_REJECTED;
	}

	/* _rtw_spinlock_bh(&(ptdlsinfo->hdl_lock)); */
	/* RTW_INFO("[%s] option:%d\n", __FUNCTION__, option); */

	switch (option) {
	case TDLS_ESTABLISHED: {
		/* As long as TDLS handshake success, we should set RCR_CBSSID_DATA bit to 0 */
		/* So we can receive all kinds of data frames. */
		u8 sta_band = 0;

		/* leave ALL PS when TDLS is established */
		rtw_pwr_wakeup(padapter);

		rtw_hal_rcr_set_chk_bssid(padapter, MLME_TDLS_LINKED);
		RTW_INFO("Created Direct Link with "MAC_FMT"\n", MAC_ARG(ptdls_sta->phl_sta->mac_addr));

		/* Set TDLS sta rate. */
		/* Update station supportRate */
		update_sta_ra_info(padapter, ptdls_sta);
		tx_ra_bitmap = ptdls_sta->phl_sta->ra_info.ramask;

		if (pmlmeext->cur_channel > 14) {
			if (tx_ra_bitmap & 0xffff000)
				sta_band |= WIRELESS_11_5N ;

			if (tx_ra_bitmap & 0xff0)
				sta_band |= WIRELESS_11A;

			/* 5G band */
#ifdef CONFIG_80211AC_VHT
			if (ptdls_sta->vhtpriv.vht_option)
				sta_band = WIRELESS_11_5AC;
#endif

		} else {
			if (tx_ra_bitmap & 0xffff000)
				sta_band |= WIRELESS_11_24N;

			if (tx_ra_bitmap & 0xff0)
				sta_band |= WIRELESS_11G;

			if (tx_ra_bitmap & 0x0f)
				sta_band |= WIRELESS_11B;
		}
		ptdls_sta->phl_sta->wmode = sta_band;
		update_sta_wset(padapter, ptdls_sta);
		/* Sta mode */
		rtw_hal_set_phydm_var(padapter, HAL_PHYDM_STA_INFO, ptdls_sta, _TRUE);

		rtw_hal_sta_ra_registed(ptdls_sta);
		rtw_sta_media_status_rpt(padapter, ptdls_sta, 1);
		break;
	}
	case TDLS_ISSUE_PTI:
		ptdls_sta->tdls_sta_state |= TDLS_WAIT_PTR_STATE;
		issue_tdls_peer_traffic_indication(padapter, ptdls_sta);
		_set_timer(&ptdls_sta->pti_timer, TDLS_PTI_TIME);
		break;
#ifdef CONFIG_TDLS_CH_SW
	case TDLS_CH_SW_RESP:
		_rtw_memset(&txmgmt, 0x00, sizeof(struct tdls_txmgmt));
		txmgmt.status_code = 0;
		_rtw_memcpy(txmgmt.peer, ptdls_sta->phl_sta->mac_addr, ETH_ALEN);

		if (ap_sta)
			rtw_hal_macid_sleep(padapter, ap_sta->phl_sta->macid);
		issue_nulldata(padapter, NULL, 1, 3, 3);

		RTW_INFO("[TDLS ] issue tdls channel switch response\n");
		ret = issue_tdls_ch_switch_rsp(padapter, &txmgmt, _TRUE);

		/* If we receive TDLS_CH_SW_REQ at off channel which it's target is AP's channel */
		/* then we just switch to AP's channel*/
		if (padapter->mlmeextpriv.cur_channel == pchsw_info->off_ch_num) {
			rtw_tdls_cmd(padapter, ptdls_sta->phl_sta->mac_addr, TDLS_CH_SW_END_TO_BASE_CHNL);
			break;
		}

		if (ret == _SUCCESS)
			rtw_tdls_cmd(padapter, ptdls_sta->phl_sta->mac_addr, TDLS_CH_SW_TO_OFF_CHNL);
		else
			RTW_INFO("[TDLS] issue_tdls_ch_switch_rsp wait ack fail !!!!!!!!!!\n");

		break;
	case TDLS_CH_SW_PREPARE:
		pchsw_info->ch_sw_state |= TDLS_CH_SWITCH_PREPARE_STATE;

		/* to collect IQK info of off-chnl */
		do_rfk = _TRUE;
		set_channel_bwmode(padapter,
				pchsw_info->off_ch_num,
				pchsw_info->ch_offset,
				(pchsw_info->ch_offset) ? CHANNEL_WIDTH_40 : CHANNEL_WIDTH_20,
				do_rfk);

		do_rfk = _FALSE;
		/* switch back to base-chnl */
		set_channel_bwmode(padapter,
				pmlmeext->cur_channel,
				pmlmeext->cur_ch_offset,
				pmlmeext->cur_bwmode,
				do_rfk);

		rtw_tdls_cmd(padapter, ptdls_sta->phl_sta->mac_addr, TDLS_CH_SW_START);

		pchsw_info->ch_sw_state &= ~(TDLS_CH_SWITCH_PREPARE_STATE);

		break;
	case TDLS_CH_SW_START:
		rtw_tdls_set_ch_sw_oper_control(padapter, _TRUE);
		break;
	case TDLS_CH_SW_TO_OFF_CHNL:
		if (ap_sta)
			rtw_hal_macid_sleep(padapter, ap_sta->phl_sta->macid);
		issue_nulldata(padapter, NULL, 1, 3, 3);

		if (padapter->registrypriv.wifi_spec == 0) {
		if (!(pchsw_info->ch_sw_state & TDLS_CH_SW_INITIATOR_STATE))
			_set_timer(&ptdls_sta->ch_sw_timer, (u32)(ptdls_sta->ch_switch_timeout) / 1000);
		}

		if (rtw_tdls_do_ch_sw(padapter, ptdls_sta, TDLS_CH_SW_OFF_CHNL, pchsw_info->off_ch_num,
			pchsw_info->ch_offset, (pchsw_info->ch_offset) ? CHANNEL_WIDTH_40 : CHANNEL_WIDTH_20, ptdls_sta->ch_switch_time) == _SUCCESS) {
			pchsw_info->ch_sw_state &= ~(TDLS_PEER_AT_OFF_STATE);
			if (pchsw_info->ch_sw_state & TDLS_CH_SW_INITIATOR_STATE) {
				if (issue_nulldata_to_TDLS_peer_STA(ptdls_sta->padapter, ptdls_sta->phl_sta->mac_addr, 0, 1,
					(padapter->registrypriv.wifi_spec == 0) ? 3 : 0) == _FAIL)
					rtw_tdls_cmd(padapter, ptdls_sta->phl_sta->mac_addr, TDLS_CH_SW_TO_BASE_CHNL);
			}
		} else {
			if (!(pchsw_info->ch_sw_state & TDLS_CH_SW_INITIATOR_STATE))
				_cancel_timer_ex(&ptdls_sta->ch_sw_timer);
		}


		break;
	case TDLS_CH_SW_END:
	case TDLS_CH_SW_END_TO_BASE_CHNL:
		rtw_tdls_set_ch_sw_oper_control(padapter, _FALSE);
		_cancel_timer_ex(&ptdls_sta->ch_sw_timer);
		_cancel_timer_ex(&ptdls_sta->stay_on_base_chnl_timer);
		_cancel_timer_ex(&ptdls_sta->ch_sw_monitor_timer);
#if 0
		_rtw_memset(pHalData->tdls_ch_sw_iqk_info_base_chnl, 0x00, sizeof(pHalData->tdls_ch_sw_iqk_info_base_chnl));
		_rtw_memset(pHalData->tdls_ch_sw_iqk_info_off_chnl, 0x00, sizeof(pHalData->tdls_ch_sw_iqk_info_off_chnl));
#endif

		if (option == TDLS_CH_SW_END_TO_BASE_CHNL)
			rtw_tdls_cmd(padapter, ptdls_sta->phl_sta->mac_addr, TDLS_CH_SW_TO_BASE_CHNL);

		break;
	case TDLS_CH_SW_TO_BASE_CHNL_UNSOLICITED:
	case TDLS_CH_SW_TO_BASE_CHNL:
		pchsw_info->ch_sw_state &= ~(TDLS_PEER_AT_OFF_STATE | TDLS_WAIT_CH_RSP_STATE);

		if (option == TDLS_CH_SW_TO_BASE_CHNL_UNSOLICITED) {
			if (ptdls_sta != NULL) {
				/* Send unsolicited channel switch rsp. to peer */
				_rtw_memset(&txmgmt, 0x00, sizeof(struct tdls_txmgmt));
				txmgmt.status_code = 0;
				_rtw_memcpy(txmgmt.peer, ptdls_sta->phl_sta->mac_addr, ETH_ALEN);
				issue_tdls_ch_switch_rsp(padapter, &txmgmt, _FALSE);
			}
		}

		if (rtw_tdls_do_ch_sw(padapter, ptdls_sta, TDLS_CH_SW_BASE_CHNL, pmlmeext->cur_channel,
			pmlmeext->cur_ch_offset, pmlmeext->cur_bwmode, ptdls_sta->ch_switch_time) == _SUCCESS) {
			if (ap_sta)
				rtw_hal_macid_wakeup(padapter, ap_sta->phl_sta->macid);
			issue_nulldata(padapter, NULL, 0, 3, 3);
			/* set ch sw monitor timer for responder */
			if (!(pchsw_info->ch_sw_state & TDLS_CH_SW_INITIATOR_STATE))
				_set_timer(&ptdls_sta->ch_sw_monitor_timer, TDLS_CH_SW_MONITOR_TIMEOUT);
		}

		break;
#endif
	case TDLS_RS_RCR:
		rtw_hal_rcr_set_chk_bssid(padapter, MLME_TDLS_NOLINK);
		break;
	case TDLS_TEARDOWN_STA:
	case TDLS_TEARDOWN_STA_NO_WAIT:
		_rtw_memset(&txmgmt, 0x00, sizeof(struct tdls_txmgmt));
		txmgmt.status_code = _RSON_TDLS_TEAR_UN_RSN_;
		_rtw_memcpy(txmgmt.peer, ptdls_sta->phl_sta->mac_addr, ETH_ALEN);

		issue_tdls_teardown(padapter, &txmgmt, (option == TDLS_TEARDOWN_STA) ? _TRUE : _FALSE);

		break;
	case TDLS_TEARDOWN_STA_LOCALLY:
	case TDLS_TEARDOWN_STA_LOCALLY_POST:
#ifdef CONFIG_TDLS_CH_SW
		if (_rtw_memcmp(TDLSoption->addr, pchsw_info->addr, ETH_ALEN) == _TRUE) {
			pchsw_info->ch_sw_state &= ~(TDLS_CH_SW_INITIATOR_STATE |
						     TDLS_CH_SWITCH_ON_STATE |
						     TDLS_PEER_AT_OFF_STATE);
			rtw_tdls_set_ch_sw_oper_control(padapter, _FALSE);
			_rtw_memset(pchsw_info->addr, 0x00, ETH_ALEN);
		}
#endif

		if (option == TDLS_TEARDOWN_STA_LOCALLY)
			rtw_tdls_teardown_pre_hdl(padapter, ptdls_sta);

		rtw_tdls_teardown_post_hdl(padapter, ptdls_sta, _FALSE);

		if (ptdlsinfo->tdls_sctx != NULL)
			rtw_sctx_done(&(ptdlsinfo->tdls_sctx));

		break;
	}

	/* _rtw_spinunlock_bh(&(ptdlsinfo->hdl_lock)); */

	return H2C_SUCCESS;
#else
	return H2C_REJECTED;
#endif /* CONFIG_TDLS */

}

u8 run_in_thread_hdl(_adapter *padapter, u8 *pbuf)
{
	struct RunInThread_param *p;


	if (NULL == pbuf)
		return H2C_PARAMETERS_ERROR;
	p = (struct RunInThread_param *)pbuf;

	if (p->func)
		p->func(p->context);

	return H2C_SUCCESS;
}

u8 set_run_cmd_en_hdl(_adapter *adapter, u8 *pbuf)
{
	struct SetRunCmdEn_param *param;

	if (!pbuf)
		return H2C_PARAMETERS_ERROR;

	param = (struct SetRunCmdEn_param *)pbuf;

	adapter->run_cmd_en = param->value;

	return H2C_SUCCESS;
}

int rtw_sae_preprocess(_adapter *adapter, const u8 *buf, u32 len, u8 tx)
{
#ifdef CONFIG_IOCTL_CFG80211
	const u8 *frame_body = buf + sizeof(struct rtw_ieee80211_hdr_3addr);
	u16 alg;
	u16 seq;
	u16 status;
	int ret = _FAIL;
	struct sta_priv *pstapriv = &adapter->stapriv;
	struct sta_info	*psta = NULL;

	alg = RTW_GET_LE16(frame_body);
	if (alg != WLAN_AUTH_SAE)
		goto exit;

	seq = RTW_GET_LE16(frame_body + 2);
	status = RTW_GET_LE16(frame_body + 4);

	RTW_INFO("RTW_%s:AUTH alg:0x%04x, seq:0x%04x, status:0x%04x, mesg:%s\n",
		(tx == _TRUE) ? "Tx" : "Rx", alg, seq, status,
		(seq == 1) ? "Commit" : "Confirm");

	ret = _SUCCESS;

#ifdef CONFIG_RTW_MESH
	if (MLME_IS_MESH(adapter)) {
		rtw_mesh_sae_check_frames(adapter, buf, len, tx, alg, seq, status);
		goto exit;
	}
#endif

	if (tx == 0 && (seq == 1) && (status == 0) && MLME_IS_AP(adapter)) {
		psta = rtw_get_stainfo(pstapriv, get_addr2_ptr(buf));
		if (psta) {
			if (psta->pcommit
				&& psta->commit_len == len
				&& _rtw_memcmp(psta->pcommit+WLAN_HDR_A3_LEN,
					frame_body, len-WLAN_HDR_A3_LEN) == _TRUE) {
				ret = 2;
				goto exit;
			}

			if (psta->pcommit) {
				rtw_mfree(psta->pcommit, psta->commit_len);
				psta->pcommit = NULL;
				psta->commit_len = 0;
			}

			psta->pcommit = rtw_zmalloc(len);
			if (psta->pcommit) {
				_rtw_memcpy(psta->pcommit, buf, len);
				psta->commit_len = len;
			}
		}
	}

	if (tx && (seq == 2) && (status == 0) && MLME_IS_AP(adapter)) {
		/* queue confirm frame until external auth status update */
		psta = rtw_get_stainfo(pstapriv, GetAddr1Ptr(buf));
		if (psta) {
			_rtw_spinlock_bh(&psta->lock);
			if (psta->pauth_frame) {
				rtw_mfree(psta->pauth_frame, psta->auth_len);
				psta->pauth_frame = NULL;
				psta->auth_len = 0;
			}

			psta->pauth_frame =  rtw_zmalloc(len);
			if (psta->pauth_frame) {
				_rtw_memcpy(psta->pauth_frame, buf, len);
				psta->auth_len = len;
			}
			_rtw_spinunlock_bh(&psta->lock);

			ret = 2;
		}
	}
exit:
	return ret;
#else
	return _SUCCESS;
#endif /* CONFIG_IOCTL_CFG80211 */
}


void rtw_ft_preprocess(_adapter *padapter, const u8 *buf, u32 len, int type)
{
#if defined(CONFIG_IOCTL_CFG80211) && defined(CONFIG_RTW_80211R)
	struct sta_info *pstat;
	struct sta_priv *pstapriv = &padapter->stapriv;
	u8 ie_offset;
	struct ft_roam_info *pft_roam = &(padapter->mlmepriv.ft_roam);
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct ieee80211_mgmt *mgmt = (struct ieee80211_mgmt *)buf;
	u16 status;
	u8 *pkt_name;

	if (!rtw_ft_enable(padapter))
		goto exit;

	/* check sta exist */
	pstat = rtw_get_stainfo(pstapriv, GetAddr1Ptr(buf));
	if (pstat == (struct sta_info *)NULL)
		goto exit;

	if (type == WIFI_AUTH) {
		ie_offset = _AUTH_IE_OFFSET_;
		pkt_name = "auth";
	} else if (type == WIFI_ASSOCRSP) {
		ie_offset = _ASOCRSP_IE_OFFSET_;
		pkt_name = "assoc";
	} else if (type == WIFI_REASSOCRSP) {
		ie_offset = _REASOCRSP_IE_OFFSET_;
		pkt_name = "reassoc";
	} else
		goto exit;

	if (pstat->ft_support) {
		RTW_PRINT("[FT] issue ft-%s-rsp to "MAC_FMT"\n", pkt_name, MAC_ARG(pstat->phl_sta->mac_addr));
	} else {
		RTW_INFO("[FT] skip ft-%s-rsp to "MAC_FMT" casue sta not support 11r\n",
			pkt_name, MAC_ARG(pstat->phl_sta->mac_addr));
			goto exit;
	}

	_rtw_spinlock_bh(&pmlmepriv->lock);
	_rtw_memset(pft_roam->updated_ft_ies, 0, RTW_FT_MAX_IE_SZ);
	pft_roam->updated_ft_ies_len = len - (IEEE80211_3ADDR_LEN + ie_offset);

	_rtw_memcpy(pft_roam->updated_ft_ies,
		buf + (IEEE80211_3ADDR_LEN + ie_offset),
		pft_roam->updated_ft_ies_len);
	_rtw_spinunlock_bh(&pmlmepriv->lock);

	/* send rsp packet according to type */
	if (type == WIFI_AUTH)
		issue_auth(padapter, pstat, le16_to_cpu(mgmt->u.auth.status_code));

exit:
	return;
#endif /* CONFIG_IOCTL_CFG80211 */
}

void rtw_assoc_preprocess(_adapter *padapter, const u8 *buf, u32 len, int type)
{
#ifdef CONFIG_IOCTL_CFG80211
	struct sta_info *pstat;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct ieee80211_mgmt *mgmt = (struct ieee80211_mgmt *)buf;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	u8 ie_offset;
	u16 status;
	u8 *ptr_tmp = NULL;
	int ie_len = 0;
#ifdef CONFIG_HAPD_OWE
	struct rsne_info info;
#endif

	/* check sta exist */
	pstat = rtw_get_stainfo(pstapriv, GetAddr1Ptr(buf));
	if (pstat == (struct sta_info *)NULL)
		goto exit;

	if ((type == WIFI_ASSOCRSP || type == WIFI_REASSOCRSP) &&
		(pstat->assoc_type == WIFI_ASSOCRSP || pstat->assoc_type == WIFI_REASSOCRSP)) {
		type = pstat->assoc_type;
	}

	if (type == WIFI_ASSOCRSP) {
		ie_offset = _ASOCRSP_IE_OFFSET_;
		status = le16_to_cpu(mgmt->u.assoc_resp.status_code);
	} else if (type == WIFI_REASSOCRSP) {
		ie_offset = _REASOCRSP_IE_OFFSET_;
		status = le16_to_cpu(mgmt->u.reassoc_resp.status_code);
	} else
		goto exit;

#ifdef CONFIG_IEEE80211W
	ptr_tmp = rtw_get_ie(buf + IEEE80211_3ADDR_LEN + ie_offset, EID_Timeout, &ie_len, len - (IEEE80211_3ADDR_LEN + ie_offset));
	if (ptr_tmp && (ie_len <= sizeof(pstat->pmf_timeout_ie))) {
		_rtw_memcpy(pstat->pmf_timeout_ie, ptr_tmp + 2, ie_len);
		pstat->pmf_timeout_ie_len = ie_len;
	}
#endif
#if defined(CONFIG_HAPD_OWE) || defined(DIRECT_HAPD_RSN_IE)
		ptr_tmp = rtw_get_ie(buf + IEEE80211_3ADDR_LEN + ie_offset, _RSN_IE_2_, &ie_len, len - (IEEE80211_3ADDR_LEN + ie_offset));
		if (ptr_tmp) {
			pstat->rsn_ie_len = ptr_tmp[1] + 2;
			if (pstat->rsn_ie_len <= sizeof(pstat->rsn_ie))
				_rtw_memcpy(pstat->rsn_ie, ptr_tmp, pstat->rsn_ie_len);
			else {
				RTW_PRINT("[OWE] rsn ie length wrong, len = %u\n", pstat->rsn_ie_len);
				goto exit;
			}
		}
#endif /* CONFIG_HAPD_OWE || DIRECT_HAPD_RSN_IE*/

#ifdef CONFIG_HAPD_OWE
	ptr_tmp = rtw_get_ie(buf + IEEE80211_3ADDR_LEN + ie_offset, WLAN_EID_EXTENSION, &ie_len, len - (IEEE80211_3ADDR_LEN + ie_offset));
	if (ptr_tmp && ptr_tmp[2] == WLAN_EID_EXT_OWE_DH_PARAM) {
		RTW_INFO("get OWE DH group IE\n");
		if (OWE_DH_IE_LEN <= sizeof(pstat->owe_dh_ie))
			_rtw_memcpy(pstat->owe_dh_ie, ptr_tmp, OWE_DH_IE_LEN);
		pstat->owe_dh_ie_len = OWE_DH_IE_LEN;
	}

	rtw_rsne_info_parse(pstat->rsn_ie, pstat->rsn_ie_len, &info);

	if (info.pmkid_cnt) {
		RTW_INFO("clean OWE DH group IE\n");
		pstat->owe_dh_ie_len = 0;
	}
#endif /* CONFIG_HAPD_OWE */

	issue_asocrsp(padapter, le16_to_cpu(mgmt->u.assoc_resp.status_code), pstat, type);

#ifdef CONFIG_RTW_80211R
	if (pstat->ft_support && type == WIFI_REASSOCRSP && status == 0) {
		RTW_PRINT("[FT][%s] set pairwise key\n", __func__);

		pstat->ieee8021x_blocked = _FALSE;
		pstat->bpairwise_key_installed = _TRUE;
		pstat->state &= (~WIFI_UNDER_KEY_HANDSHAKE);

		rtw_ap_set_pairwise_key(padapter, pstat);
	}
#endif

exit:
	return;
#endif /* CONFIG_IOCTL_CFG80211 */
}


