/******************************************************************************
 *
 * Copyright(c) 2007 - 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#define _RTW_XMIT_C_

#include <drv_types.h>

static u8 P802_1H_OUI[P80211_OUI_LEN] = { 0x00, 0x00, 0xf8 };
static u8 RFC1042_OUI[P80211_OUI_LEN] = { 0x00, 0x00, 0x00 };

#ifdef CONFIG_RTW_TXSC_USE_HW_SEQ
enum rtw_phl_status rtw_phl_set_dctrl_tbl_seq(void *phl,
struct rtw_wifi_role_t *wrole, struct rtw_phl_stainfo_t *sta, u32 init_seq)
{
	return rtw_phl_cmd_cfg_hw_seq(phl,
		wrole,
		sta,
		init_seq,
		RTW_DATA_RATE_OFDM54,
		PHL_CMD_DIRECTLY,
		0
		);
}
#endif

enum rtw_phl_status rtw_phl_set_gt3(void *phl, u8 enable, u32 timeout)
{
	bool count_en = false, gt3_en = false, sort_en = false;
	u8 mode = 0; /* counter mode */

	if (enable) {
		count_en = true;
		gt3_en = true;
	}

	return rtw_phl_cfg_gtimer_register(phl, count_en, mode, gt3_en, sort_en, timeout);
}

enum rtw_phl_status rtw_phl_getpkt(void *phl,
struct rtw_wifi_role_t *wrole, u8 macid, u8 pkttype)
{
	return RTW_PHL_STATUS_FAILURE;
}

s32 check_net_lmt( _adapter *padapter )
{
#ifdef WIFI_LOGO_HT_4_2_47
	if (padapter->mlmeextpriv.mlmext_info.is_HT_4_2_47)
		return 1;
#endif
	return 0;
}

static void _init_txservq(struct tx_servq *ptxservq)
{
	_rtw_init_listhead(&ptxservq->tx_pending);
	_rtw_init_queue(&ptxservq->queue);
	ptxservq->qcnt = 0;
}


void	_rtw_init_sta_xmit_priv(struct sta_xmit_priv *psta_xmitpriv)
{
	int i;

	_rtw_memset((unsigned char *)psta_xmitpriv, 0, sizeof(struct sta_xmit_priv));

	_rtw_spinlock_init(&psta_xmitpriv->lock);

	for (i = 0; i < MAX_TXQ; i++){
		struct sta_tx_queue *txq = &psta_xmitpriv->txq[i];
		skb_queue_head_init(&txq->qhead);
	}
	_rtw_init_queue(&psta_xmitpriv->mgt_q);
	ATOMIC_SET(&psta_xmitpriv->txq_total_len, 0);
	_rtw_init_listhead(&psta_xmitpriv->tx_pending);
	_rtw_init_listhead(&psta_xmitpriv->ps_trigger);

	_init_txservq(&psta_xmitpriv->be_q);
	_init_txservq(&psta_xmitpriv->bk_q);
	_init_txservq(&psta_xmitpriv->vi_q);
	_init_txservq(&psta_xmitpriv->vo_q);
	_rtw_init_listhead(&psta_xmitpriv->legacy_dz);
	_rtw_init_listhead(&psta_xmitpriv->apsd);


}

void rtw_init_xmit_block(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	_rtw_spinlock_init(&dvobj->xmit_block_lock);
	_rtw_spinlock_bh(&dvobj->xmit_block_lock);
	dvobj->xmit_block = XMIT_BLOCK_NONE;
	_rtw_spinunlock_bh(&dvobj->xmit_block_lock);

}
void rtw_free_xmit_block(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	_rtw_spinlock_free(&dvobj->xmit_block_lock);
}

#ifdef RTW_PHL_TX /* TXREQ_QMGT */
u8 alloc_txring(_adapter * padapter)
{
	u32 idx, alloc_sz=0, alloc_sz_txreq=0;
	u8 res = _SUCCESS;
	u8 **tx_pool_ring = NULL;
	struct xmit_txreq_buf *ptxreq_buf = NULL;

#ifdef PLATFORM_ECOS
	u32 offset_head = N_BYTE_ALIGNMENT((sizeof(struct rtw_xmit_req) * RTW_MAX_FRAG_NUM), SMP_CACHE_BYTES);
	u32 offset_tail = N_BYTE_ALIGNMENT((offset_head + (SZ_HEAD_BUF * RTW_MAX_FRAG_NUM)), SMP_CACHE_BYTES);
	u32 offset_list = N_BYTE_ALIGNMENT((offset_tail + (SZ_TAIL_BUF * RTW_MAX_FRAG_NUM)), SMP_CACHE_BYTES);
#else
	u32 offset_head = _ALIGN((sizeof(struct rtw_xmit_req) * RTW_MAX_FRAG_NUM), 4);
    u32 offset_tail = _ALIGN((offset_head + (SZ_HEAD_BUF * RTW_MAX_FRAG_NUM)), 4);
    u32 offset_list = _ALIGN((offset_tail + (SZ_TAIL_BUF * RTW_MAX_FRAG_NUM)), 4);
#endif

	PHLTX_ENTER;
	padapter->max_tx_ring_cnt = GET_HAL_SPEC(padapter->dvobj)->band_cap & BAND_CAP_5G ? MAX_TX_RING_NUM_5G : MAX_TX_RING_NUM_2G;
	if (is_primary_adapter(padapter)) {

		alloc_sz = (SZ_TX_RING * RTW_MAX_FRAG_NUM);
		alloc_sz_txreq = padapter->max_tx_ring_cnt * (sizeof(struct xmit_txreq_buf));

		RTW_INFO("[%s] alloc_sz = %d, alloc_sz_txreq = %d\n", __FUNCTION__, alloc_sz, alloc_sz_txreq);

		padapter->pxmit_txreq_buf = rtw_vmalloc(alloc_sz_txreq);
		if (padapter->pxmit_txreq_buf == NULL) {
			RTW_ERR("[%s] alloc xmit_txreq_buf fail(%d)\n", __func__, alloc_sz_txreq);
			return _FAIL;
		}

		padapter->tx_pool_ring_ptr = rtw_zmalloc(sizeof(u8 *) * padapter->max_tx_ring_cnt);
		if (padapter->tx_pool_ring_ptr == NULL) {
			RTW_ERR("[%s] alloc tx_pool_ring_ptr fail(%zu)\n", __func__, sizeof(u8 *) * padapter->max_tx_ring_cnt);
			goto free;
		}

		ptxreq_buf = (struct xmit_txreq_buf *)padapter->pxmit_txreq_buf;

		padapter->pfree_txreq_queue = rtw_zvmalloc(sizeof(_queue));
		if (padapter->pfree_txreq_queue == NULL) {
			RTW_ERR("[%s] alloc free_txreq_queue fail(%zu)\n", __func__, sizeof(_queue));
			goto free;
		}
		_rtw_init_queue(padapter->pfree_txreq_queue);

		for(idx=0; idx<(padapter->max_tx_ring_cnt); idx++){
			tx_pool_ring = padapter->tx_pool_ring_ptr + idx;
			*tx_pool_ring = rtw_zmalloc(alloc_sz);
			if (!*tx_pool_ring) {
				RTW_ERR("[core] alloc txring fail, plz check.\n");
				goto free;
			}
			_rtw_init_listhead(&ptxreq_buf->list);
			ptxreq_buf->txreq = *tx_pool_ring;
			ptxreq_buf->head = *tx_pool_ring + offset_head;
			ptxreq_buf->tail = *tx_pool_ring + offset_tail;
			ptxreq_buf->pkt_list = *tx_pool_ring + offset_list;

			rtw_list_insert_tail(&(ptxreq_buf->list), &(padapter->pfree_txreq_queue->queue));

			ptxreq_buf++;
		}

		padapter->pfree_txreq_queue->qlen = padapter->max_tx_ring_cnt;

	} else {
		_adapter *pri_adapter = GET_PRIMARY_ADAPTER(padapter);
		padapter->pfree_txreq_queue = pri_adapter->pfree_txreq_queue;
	}

	return res;

free:
	if (padapter->tx_pool_ring_ptr != NULL) {
		for(idx = 0; idx < padapter->max_tx_ring_cnt; idx++) {
			tx_pool_ring = padapter->tx_pool_ring_ptr + idx;
			if(*tx_pool_ring)
				rtw_mfree(*tx_pool_ring, alloc_sz);
		}
		rtw_mfree(padapter->tx_pool_ring_ptr, sizeof(u8 *) * padapter->max_tx_ring_cnt);
	}
	if (padapter->pfree_txreq_queue != NULL)
		rtw_vmfree(padapter->pfree_txreq_queue, sizeof(_queue));
	if (padapter->pxmit_txreq_buf != NULL)
		rtw_vmfree(padapter->pxmit_txreq_buf, alloc_sz_txreq);

	return _FAIL;
}

/* TXREQ_QMGT */
void free_txring(_adapter * padapter)
{
	u32 idx, alloc_sz = 0, alloc_sz_txreq = 0;
#ifdef CONFIG_CORE_TXSC
	struct rtw_xmit_req *txreq = NULL;
	struct xmit_txreq_buf *txreq_buf = NULL;
	u8 j, *tx_pool_ring = NULL;
#endif

	PHLTX_ENTER;

	if (is_primary_adapter(padapter)) {

		alloc_sz = (SZ_TX_RING * RTW_MAX_FRAG_NUM);
		alloc_sz_txreq = padapter->max_tx_ring_cnt * (sizeof(struct xmit_txreq_buf));

		RTW_INFO("[%s] alloc_sz = %d,  alloc_sz_txreq = %d\n", __FUNCTION__, alloc_sz, alloc_sz_txreq);

		for(idx = 0; idx < padapter->max_tx_ring_cnt; idx++){
			tx_pool_ring = *(padapter->tx_pool_ring_ptr + idx);
			if(tx_pool_ring){
#ifdef CONFIG_CORE_TXSC
				txreq = (struct rtw_xmit_req *)tx_pool_ring;
				if(txreq->treq_type == RTW_PHL_TREQ_TYPE_CORE_TXSC){
					txreq_buf = (struct xmit_txreq_buf *)txreq->os_priv;
					if(txreq_buf){
						/* CONFGI_TXSC_AMSDU */
						for(j = 0; j < txreq_buf->pkt_cnt; j++){
							if(txreq_buf->pkt[j])
								rtw_os_pkt_complete(padapter, (void *)txreq_buf->pkt[j]);
						}
					}
				}
#endif
				rtw_mfree(tx_pool_ring, alloc_sz);
			}
		}

		_rtw_spinlock_free(&padapter->pfree_txreq_queue->lock);
		rtw_mfree(padapter->tx_pool_ring_ptr, sizeof(u8 *) * padapter->max_tx_ring_cnt);
		rtw_vmfree(padapter->pxmit_txreq_buf, alloc_sz_txreq);

		if (padapter->pfree_txreq_queue)
			rtw_vmfree(padapter->pfree_txreq_queue, sizeof(_queue));
	}
}

#endif


s32 _rtw_init_xmit_priv(struct xmit_priv *pxmitpriv, _adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	int i;
	#if 0 /*CONFIG_CORE_XMITBUF*/
	struct xmit_buf *pxmitbuf;
	#endif
	struct xmit_frame *pxframe;
	sint res = _SUCCESS;
	/* MGT_TXREQ_MGT */
	u8 *txreq = NULL, *pkt_list = NULL;
	u32 nr_xmitframe_cnt = GET_HAL_SPEC(dvobj)->band_cap & BAND_CAP_5G ? NR_XMITFRAME_5G : NR_XMITFRAME_2G;

	#if 0 /*CONFIG_CORE_XMITBUF*/
	u8 xmitbuf_nr = GET_HAL_XMITBUF_NR(dvobj);
	u16 xmitbuf_sz= GET_HAL_XMITBUF_SZ(dvobj);

	u8 xmitbuf_ext_nr = GET_HAL_XMITBUF_EXT_NR(dvobj);
	u16 xmitbuf_ext_sz= GET_HAL_XMITBUF_EXT_SZ(dvobj);
	#endif

	/* We don't need to memset padapter->XXX to zero, because adapter is allocated by rtw_zvmalloc(). */
	/* _rtw_memset((unsigned char *)pxmitpriv, 0, sizeof(struct xmit_priv)); */

	_rtw_spinlock_init(&pxmitpriv->lock);
	_rtw_spinlock_init(&pxmitpriv->lock_sctx);
	#if 0 /*def CONFIG_XMIT_THREAD_MODE*/
	_rtw_init_sema(&pxmitpriv->xmit_sema, 0);
	#endif

	/*
	Please insert all the queue initializaiton using _rtw_init_queue below
	*/

	pxmitpriv->adapter = padapter;

	/* for(i = 0 ; i < MAX_NUMBLKS; i++) */
	/*	_rtw_init_queue(&pxmitpriv->blk_strms[i]); */

	_rtw_init_queue(&pxmitpriv->be_pending);
	_rtw_init_queue(&pxmitpriv->bk_pending);
	_rtw_init_queue(&pxmitpriv->vi_pending);
	_rtw_init_queue(&pxmitpriv->vo_pending);
	_rtw_init_queue(&pxmitpriv->bm_pending);

	/* _rtw_init_queue(&pxmitpriv->legacy_dz_queue); */
	/* _rtw_init_queue(&pxmitpriv->apsd_queue); */

#if !defined(USE_HIQ)
	_rtw_init_listhead(&pxmitpriv->bmc_list);
#endif

	_rtw_init_queue(&pxmitpriv->free_xmit_queue);

#ifndef CONFIG_DYN_ALLOC_XMITFRAME
	/*
	Please allocate memory with the sz = (struct xmit_frame) * NR_XMITFRAME,
	and initialize free_xmit_frame below.
	Please also apply  free_txobj to link_up all the xmit_frames...
	*/

	pxmitpriv->pallocated_frame_buf = rtw_zvmalloc(nr_xmitframe_cnt * sizeof(struct xmit_frame) + 4);

	if (pxmitpriv->pallocated_frame_buf  == NULL) {
		pxmitpriv->pxmit_frame_buf = NULL;
		res = _FAIL;
		goto exit;
	}
	pxmitpriv->pxmit_frame_buf = (u8 *)N_BYTE_ALIGMENT((SIZE_PTR)(pxmitpriv->pallocated_frame_buf), 4);
	/* pxmitpriv->pxmit_frame_buf = pxmitpriv->pallocated_frame_buf + 4 - */
	/*						((SIZE_PTR) (pxmitpriv->pallocated_frame_buf) &3); */

	pxframe = (struct xmit_frame *) pxmitpriv->pxmit_frame_buf;

	for (i = 0; i < nr_xmitframe_cnt; i++) {
		_rtw_init_listhead(&(pxframe->list));

		pxframe->padapter = padapter;
		pxframe->frame_tag = NULL_FRAMETAG;

		pxframe->pkt = NULL;

		#if 0 /*CONFIG_CORE_XMITBUF*/
		pxframe->buf_addr = NULL;
		pxframe->pxmitbuf = NULL;
		#else
		/*alloc buf_addr*/
		/*rtw_os_xmit_resource_alloc(padapter, pxframe);*/
		#endif

		rtw_list_insert_tail(&(pxframe->list), &(pxmitpriv->free_xmit_queue.queue));

		pxframe++;
	}
#endif
	pxmitpriv->free_xmitframe_cnt = nr_xmitframe_cnt;

	pxmitpriv->frag_len = MAX_FRAG_THRESHOLD;


	#if 0/* XFRAME_CMD */
	_rtw_init_queue(&pxmitpriv->free_xframe_cmd_queue);

	pxmitpriv->xframe_cmd_alloc_addr = rtw_zvmalloc(NR_XMITFRAME_CMD * sizeof(struct xmit_frame) + 4);
	if (pxmitpriv->xframe_cmd_alloc_addr  == NULL) {
		pxmitpriv->xframe_cmd = NULL;
		res = _FAIL;
		goto exit;
	}

	pxmitpriv->xframe_cmd = (u8 *)N_BYTE_ALIGMENT((SIZE_PTR)(pxmitpriv->xframe_cmd_alloc_addr), 4);
	pxframe = (struct xmit_frame *) pxmitpriv->xframe_cmd;

	for (i = 0; i < NR_XMITFRAME_CMD; i++) {
		_rtw_init_listhead(&(pxframe->list));

		pxframe->padapter = padapter;
		pxframe->frame_tag = NULL_FRAMETAG;
		pxframe->pkt = NULL;
		pxframe->buf_addr = NULL;
		#if 0 /*CONFIG_CORE_XMITBUF*/
		pxframe->pxmitbuf = NULL;
		#endif
		pxframe->ext_tag = 2;

		rtw_list_insert_tail(&(pxframe->list), &(pxmitpriv->free_xframe_cmd_queue.queue));

		pxframe++;
	}

	pxmitpriv->free_xframe_cmd_cnt = NR_XMITFRAME_CMD;
	/* XFRAME_CMD */
	#endif

	#if 0 /*CONFIG_CORE_XMITBUF*/
	/* init xmit_buf */
	_rtw_init_queue(&pxmitpriv->free_xmitbuf_queue);
	_rtw_init_queue(&pxmitpriv->pending_xmitbuf_queue);

	pxmitpriv->pallocated_xmitbuf = rtw_zvmalloc(xmitbuf_nr * sizeof(struct xmit_buf) + 4);

	if (pxmitpriv->pallocated_xmitbuf  == NULL) {
		res = _FAIL;
		goto exit;
	}

	pxmitpriv->pxmitbuf = (u8 *)N_BYTE_ALIGMENT((SIZE_PTR)(pxmitpriv->pallocated_xmitbuf), 4);
	/* pxmitpriv->pxmitbuf = pxmitpriv->pallocated_xmitbuf + 4 - */
	/*						((SIZE_PTR) (pxmitpriv->pallocated_xmitbuf) &3); */

	pxmitbuf = (struct xmit_buf *)pxmitpriv->pxmitbuf;

	for (i = 0; i < xmitbuf_nr; i++) {
		_rtw_init_listhead(&pxmitbuf->list);

		pxmitbuf->priv_data = NULL;
		pxmitbuf->padapter = padapter;
		pxmitbuf->buf_tag = XMITBUF_DATA;

		/* Tx buf allocation may fail sometimes, so sleep and retry. */
		res = rtw_os_xmit_resource_alloc(padapter, pxmitbuf,
					(xmitbuf_sz + XMITBUF_ALIGN_SZ), _TRUE);
		if (res == _FAIL) {
			rtw_msleep_os(10);
			res = rtw_os_xmit_resource_alloc(padapter, pxmitbuf,
					(xmitbuf_sz + XMITBUF_ALIGN_SZ), _TRUE);
			if (res == _FAIL)
				goto exit;
		}

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
		pxmitbuf->phead = pxmitbuf->pbuf;
		pxmitbuf->pend = pxmitbuf->pbuf + xmitbuf_sz;
		pxmitbuf->len = 0;
		pxmitbuf->pdata = pxmitbuf->ptail = pxmitbuf->phead;
#endif

		pxmitbuf->flags = XMIT_VO_QUEUE;

		rtw_list_insert_tail(&pxmitbuf->list, &(pxmitpriv->free_xmitbuf_queue.queue));
#ifdef DBG_XMIT_BUF
		pxmitbuf->no = i;
#endif

		pxmitbuf++;

	}

	pxmitpriv->free_xmitbuf_cnt = xmitbuf_nr;
	#endif
	/* init xframe_ext queue,  the same count as extbuf */
	_rtw_init_queue(&pxmitpriv->free_xframe_ext_queue);

#ifndef CONFIG_DYN_ALLOC_XMITFRAME
	pxmitpriv->xframe_ext_alloc_addr = rtw_zvmalloc(NR_XMITFRAME_EXT * sizeof(struct xmit_frame) + 4);

	if (pxmitpriv->xframe_ext_alloc_addr  == NULL) {
		pxmitpriv->xframe_ext = NULL;
		res = _FAIL;
		goto exit;
	}
	pxmitpriv->xframe_ext = (u8 *)N_BYTE_ALIGMENT((SIZE_PTR)(pxmitpriv->xframe_ext_alloc_addr), 4);
	pxframe = (struct xmit_frame *)pxmitpriv->xframe_ext;

	/* MGT_TXREQ_QMGT */
	pxmitpriv->xframe_ext_txreq_alloc_addr = rtw_zmalloc(NR_XMITFRAME_EXT * SZ_MGT_RING);
	if (pxmitpriv->xframe_ext_txreq_alloc_addr  == NULL) {
		pxmitpriv->xframe_ext_txreq = NULL;
		res = _FAIL;
		goto exit;
	}
	pxmitpriv->xframe_ext_txreq = pxmitpriv->xframe_ext_txreq_alloc_addr;
	txreq = pxmitpriv->xframe_ext_txreq;
	pkt_list = pxmitpriv->xframe_ext_txreq + sizeof(struct rtw_xmit_req);

	for (i = 0; i < NR_XMITFRAME_EXT; i++) {
		_rtw_init_listhead(&(pxframe->list));

		pxframe->padapter = padapter;
		pxframe->frame_tag = NULL_FRAMETAG;

		pxframe->pkt = NULL;

		#if 0 /*CONFIG_CORE_XMITBUF*/
		pxframe->buf_addr = NULL;
		pxframe->pxmitbuf = NULL;
		#else
		/*alloc buf_addr*/
		rtw_os_xmit_resource_alloc(padapter, pxframe);
		#endif


		pxframe->ext_tag = 1;

		/* MGT_TXREQ_QMGT */
		pxframe->phl_txreq = (struct rtw_xmit_req *)txreq;
		pxframe->phl_txreq->pkt_list = pkt_list;

		rtw_list_insert_tail(&(pxframe->list), &(pxmitpriv->free_xframe_ext_queue.queue));

		pxframe++;
		/* MGT_TXREQ_QMGT */
		txreq += SZ_MGT_RING;
		pkt_list += SZ_MGT_RING;
	}
#endif

		pxmitpriv->free_xframe_ext_cnt = NR_XMITFRAME_EXT;

#if 0 /*CONFIG_CORE_XMITBUF*/
	/* Init xmit extension buff */
	_rtw_init_queue(&pxmitpriv->free_xmit_extbuf_queue);

	pxmitpriv->pallocated_xmit_extbuf = rtw_zvmalloc(xmitbuf_ext_nr * sizeof(struct xmit_buf) + 4);

	if (pxmitpriv->pallocated_xmit_extbuf  == NULL) {
		res = _FAIL;
		goto exit;
	}

	pxmitpriv->pxmit_extbuf = (u8 *)N_BYTE_ALIGMENT((SIZE_PTR)(pxmitpriv->pallocated_xmit_extbuf), 4);

	pxmitbuf = (struct xmit_buf *)pxmitpriv->pxmit_extbuf;

	for (i = 0; i < xmitbuf_ext_nr; i++) {
		_rtw_init_listhead(&pxmitbuf->list);

		pxmitbuf->priv_data = NULL;
		pxmitbuf->padapter = padapter;
		pxmitbuf->buf_tag = XMITBUF_MGNT;

		res = rtw_os_xmit_resource_alloc(padapter, pxmitbuf,
					xmitbuf_ext_sz + XMITBUF_ALIGN_SZ, _TRUE);
		if (res == _FAIL) {
			res = _FAIL;
			goto exit;
		}

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
		pxmitbuf->phead = pxmitbuf->pbuf;
		pxmitbuf->pend = pxmitbuf->pbuf + xmitbuf_ext_sz;
		pxmitbuf->len = 0;
		pxmitbuf->pdata = pxmitbuf->ptail = pxmitbuf->phead;
#endif

		rtw_list_insert_tail(&pxmitbuf->list, &(pxmitpriv->free_xmit_extbuf_queue.queue));
#ifdef DBG_XMIT_BUF_EXT
		pxmitbuf->no = i;
#endif
		pxmitbuf++;

	}

	pxmitpriv->free_xmit_extbuf_cnt = xmitbuf_ext_nr;

	/*GEORGIA_TODO_FIXIT_IC_GEN_DEPENDENCE*/
	for (i = 0; i < CMDBUF_MAX; i++) {
		pxmitbuf = &pxmitpriv->pcmd_xmitbuf[i];
		if (pxmitbuf) {
			_rtw_init_listhead(&pxmitbuf->list);

			pxmitbuf->priv_data = NULL;
			pxmitbuf->padapter = padapter;
			pxmitbuf->buf_tag = XMITBUF_CMD;

			res = rtw_os_xmit_resource_alloc(padapter, pxmitbuf,
					MAX_CMDBUF_SZ + XMITBUF_ALIGN_SZ, _TRUE);
			if (res == _FAIL) {
				res = _FAIL;
				goto exit;
			}

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
			pxmitbuf->phead = pxmitbuf->pbuf;
			pxmitbuf->pend = pxmitbuf->pbuf + MAX_CMDBUF_SZ;
			pxmitbuf->len = 0;
			pxmitbuf->pdata = pxmitbuf->ptail = pxmitbuf->phead;
#endif
			pxmitbuf->alloc_sz = MAX_CMDBUF_SZ + XMITBUF_ALIGN_SZ;
		}
	}
#endif

	rtw_alloc_hwxmits(padapter);
	rtw_init_hwxmits(pxmitpriv->hwxmits, pxmitpriv->hwxmit_entry);

	for (i = 0; i < 4; i++)
		pxmitpriv->wmm_para_seq[i] = i;

#ifdef CONFIG_USB_HCI
	pxmitpriv->txirp_cnt = 1;

	_rtw_init_sema(&(pxmitpriv->tx_retevt), 0);

	/* per AC pending irp */
	pxmitpriv->beq_cnt = 0;
	pxmitpriv->bkq_cnt = 0;
	pxmitpriv->viq_cnt = 0;
	pxmitpriv->voq_cnt = 0;
#endif


#ifdef CONFIG_XMIT_ACK
	pxmitpriv->ack_tx = _FALSE;
	_rtw_mutex_init(&pxmitpriv->ack_tx_mutex);
	rtw_sctx_init(&pxmitpriv->ack_tx_ops, 0);
#endif

#ifdef CONFIG_TX_AMSDU
	rtw_init_timer(&(pxmitpriv->amsdu_vo_timer),
		rtw_amsdu_vo_timeout_handler, padapter);
	pxmitpriv->amsdu_vo_timeout = RTW_AMSDU_TIMER_UNSET;

	rtw_init_timer(&(pxmitpriv->amsdu_vi_timer),
		rtw_amsdu_vi_timeout_handler, padapter);
	pxmitpriv->amsdu_vi_timeout = RTW_AMSDU_TIMER_UNSET;

	rtw_init_timer(&(pxmitpriv->amsdu_be_timer),
		rtw_amsdu_be_timeout_handler, padapter);
	pxmitpriv->amsdu_be_timeout = RTW_AMSDU_TIMER_UNSET;

	rtw_init_timer(&(pxmitpriv->amsdu_bk_timer),
		rtw_amsdu_bk_timeout_handler, padapter);
	pxmitpriv->amsdu_bk_timeout = RTW_AMSDU_TIMER_UNSET;

	pxmitpriv->amsdu_debug_set_timer = 0;
	pxmitpriv->amsdu_debug_timeout = 0;
	pxmitpriv->amsdu_debug_coalesce_one = 0;
	pxmitpriv->amsdu_debug_coalesce_two = 0;
	pxmitpriv->amsdu_debug_tasklet = 0;
	pxmitpriv->amsdu_debug_enqueue = 0;
	pxmitpriv->amsdu_debug_dequeue = 0;
#endif
#ifdef DBG_TXBD_DESC_DUMP
	pxmitpriv->dump_txbd_desc = 0;
#endif
	rtw_init_xmit_block(padapter);
	rtw_intf_init_xmit_priv(padapter);

#ifdef RTW_PHL_TX //alloc xmit resource
	if(alloc_txring(padapter) == _FAIL){
		RTW_ERR("[core] alloc_txring fail !!!\n");
		res = _FAIL;
		goto exit;
	}
#endif

#if defined(CONFIG_CORE_TXSC)
	_rtw_spinlock_init(&pxmitpriv->txsc_lock);
#endif

#ifdef CONFIG_TX_DEFER
	rtw_init_timer(&(pxmitpriv->tx_defer_timer), txdefer_timer_handler, padapter);
#endif

exit:

	return res;
}

void  rtw_mfree_xmit_priv_lock(struct xmit_priv *pxmitpriv)
{
	_rtw_spinlock_free(&pxmitpriv->lock);
	#if 0 /*def CONFIG_XMIT_THREAD_MODE*/
	_rtw_free_sema(&pxmitpriv->xmit_sema);
	#endif

	_rtw_spinlock_free(&pxmitpriv->be_pending.lock);
	_rtw_spinlock_free(&pxmitpriv->bk_pending.lock);
	_rtw_spinlock_free(&pxmitpriv->vi_pending.lock);
	_rtw_spinlock_free(&pxmitpriv->vo_pending.lock);
	_rtw_spinlock_free(&pxmitpriv->bm_pending.lock);

	/* _rtw_spinlock_free(&pxmitpriv->legacy_dz_queue.lock); */
	/* _rtw_spinlock_free(&pxmitpriv->apsd_queue.lock); */

	_rtw_spinlock_free(&pxmitpriv->free_xmit_queue.lock);
	#if 0 /*CONFIG_CORE_XMITBUF*/
	_rtw_spinlock_free(&pxmitpriv->free_xmitbuf_queue.lock);
	_rtw_spinlock_free(&pxmitpriv->pending_xmitbuf_queue.lock);
	#endif
}


void _rtw_free_xmit_priv(struct xmit_priv *pxmitpriv)
{
	int i;
	_adapter *padapter = pxmitpriv->adapter;
	struct xmit_frame *pxmitframe;
	u32 nr_xmitframe_cnt = (GET_PRIMARY_ADAPTER(padapter)->mlmeextpriv.cur_channel <= 14) ? NR_XMITFRAME_2G: NR_XMITFRAME_5G;
	#if 0 /*CONFIG_CORE_XMITBUF*/
	struct xmit_buf *pxmitbuf = (struct xmit_buf *)pxmitpriv->pxmitbuf;
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	u8 xmitbuf_nr = GET_HAL_XMITBUF_NR(dvobj);
	u16 xmitbuf_sz= GET_HAL_XMITBUF_SZ(dvobj);

	u8 xmitbuf_ext_nr = GET_HAL_XMITBUF_EXT_NR(dvobj);
	u16 xmitbuf_ext_sz= GET_HAL_XMITBUF_EXT_SZ(dvobj);
	#endif

	rtw_intf_free_xmit_priv(padapter);

	rtw_mfree_xmit_priv_lock(pxmitpriv);

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	if(pxmitpriv->free_xmitframe_cnt != nr_xmitframe_cnt) {
		_list *plist, *phead;
		int allocated_xframe = nr_xmitframe_cnt - pxmitpriv->free_xmitframe_cnt;
		for (i = 0; i < allocated_xframe; i++) {
			phead = get_list_head(&pxmitpriv->free_xmit_queue);
			plist = get_next(phead);

			if (plist == NULL || plist == phead) {
				printk("err free free_xmit_queue\r\n");
				/* If plist is null, pxmitframe is null */
				break;
			}

			pxmitframe = LIST_CONTAINOR(plist, struct xmit_frame, list);
			rtw_list_delete(&pxmitframe->list);
			rtw_os_xmit_complete(padapter, pxmitframe);
			//free
			rtw_mfree(pxmitframe->alloc_addr, sizeof(struct xmit_frame) + 4);
		}
	}
#else
	if (pxmitpriv->pxmit_frame_buf == NULL)
		goto out;

	pxmitframe = (struct xmit_frame *) pxmitpriv->pxmit_frame_buf;

	for (i = 0; i < nr_xmitframe_cnt; i++) {
		rtw_os_xmit_complete(padapter, pxmitframe);

		pxmitframe++;
	}
#endif

	#if 0 /* XFRAME_CMD */
	pxmitframe = (struct xmit_frame *) pxmitpriv->xframe_cmd;
	for (i = 0; i < NR_XMITFRAME_CMD; i++) {
		rtw_os_xmit_complete(padapter, pxmitframe);
		pxmitframe++;
	}
	#endif
	#if 0 /*CONFIG_CORE_XMITBUF*/
	for (i = 0; i < xmitbuf_nr; i++) {
		rtw_os_xmit_resource_free(padapter, pxmitbuf,
			(xmitbuf_sz + XMITBUF_ALIGN_SZ), _TRUE);

		pxmitbuf++;
	}
	#endif
	if (pxmitpriv->pallocated_frame_buf)
		rtw_vmfree(pxmitpriv->pallocated_frame_buf,
			nr_xmitframe_cnt * sizeof(struct xmit_frame) + 4);

	#if 0 /*CONFIG_CORE_XMITBUF*/
	if (pxmitpriv->pallocated_xmitbuf)
		rtw_vmfree(pxmitpriv->pallocated_xmitbuf,
			xmitbuf_nr * sizeof(struct xmit_buf) + 4);
	#endif

	/* free xframe_ext queue,  the same count as extbuf */
#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	if(pxmitpriv->free_xframe_ext_cnt != NR_XMITFRAME_EXT)
	{
		_list *plist, *phead;
		int allocated_xframe_ext = NR_XMITFRAME_EXT - pxmitpriv->free_xframe_ext_cnt;
		for (i = 0; i < allocated_xframe_ext; i++)
		{
			phead = get_list_head(&pxmitpriv->free_xframe_ext_queue);

			plist = get_next(phead);

			if(plist == NULL || plist == phead)
			{
				printk("err free free_xmit_queue\r\n");
			}

			pxmitframe = LIST_CONTAINOR(plist, struct xmit_frame, list);
			rtw_list_delete(&pxmitframe->list);
			rtw_os_xmit_complete(padapter, pxmitframe);
			//free
			if(pxmitframe->phl_txreq)
				rtw_mfree(pxmitframe->phl_txreq, SZ_MGT_RING);
			rtw_os_xmit_resource_free(padapter, pxmitframe);
			rtw_mfree(pxmitframe->alloc_addr, sizeof(struct xmit_frame) + 4);
		}

	}
#else
	if (pxmitpriv->xframe_ext == NULL)
		goto out;

	pxmitframe = (struct xmit_frame *)pxmitpriv->xframe_ext;
	for (i = 0; i < NR_XMITFRAME_EXT; i++) {
		rtw_os_xmit_complete(padapter, pxmitframe);
		/*free buf_addr*/
		rtw_os_xmit_resource_free(padapter, pxmitframe);
		pxmitframe++;
	}
#endif
	if (pxmitpriv->xframe_ext_alloc_addr)
		rtw_vmfree(pxmitpriv->xframe_ext_alloc_addr,
			NR_XMITFRAME_EXT * sizeof(struct xmit_frame) + 4);
	_rtw_spinlock_free(&pxmitpriv->free_xframe_ext_queue.lock);

	/* MGT_TXREQ_QMGT */
	if(pxmitpriv->xframe_ext_txreq_alloc_addr)
		rtw_mfree(pxmitpriv->xframe_ext_txreq_alloc_addr,
			NR_XMITFRAME_EXT * SZ_MGT_RING);

#if 0 /*CONFIG_CORE_XMITBUF*/

	/* free xmit extension buff */
	_rtw_spinlock_free(&pxmitpriv->free_xmit_extbuf_queue.lock);

	pxmitbuf = (struct xmit_buf *)pxmitpriv->pxmit_extbuf;
	for (i = 0; i < xmitbuf_ext_nr; i++) {
		rtw_os_xmit_resource_free(padapter, pxmitbuf,
			(xmitbuf_ext_sz + XMITBUF_ALIGN_SZ), _TRUE);

		pxmitbuf++;
	}

	if (pxmitpriv->pallocated_xmit_extbuf)
		rtw_vmfree(pxmitpriv->pallocated_xmit_extbuf,
			xmitbuf_ext_nr * sizeof(struct xmit_buf) + 4);

	for (i = 0; i < CMDBUF_MAX; i++) {
		pxmitbuf = &pxmitpriv->pcmd_xmitbuf[i];
		if (pxmitbuf != NULL)
			rtw_os_xmit_resource_free(padapter, pxmitbuf,
				MAX_CMDBUF_SZ + XMITBUF_ALIGN_SZ , _TRUE);
	}
#endif

	rtw_free_hwxmits(padapter);

#ifdef RTW_PHL_TX
	free_txring(padapter);
#endif
#ifdef CONFIG_CORE_TXSC
	txsc_clear(padapter, 0);
	_rtw_spinlock_free(&pxmitpriv->txsc_lock);
#endif

#ifdef CONFIG_XMIT_ACK
	_rtw_mutex_free(&pxmitpriv->ack_tx_mutex);
#endif
	rtw_free_xmit_block(padapter);
out:
	return;
}

u8 rtw_init_lite_xmit_resource(struct dvobj_priv *dvobj)
{

	u8 ret = _SUCCESS;
/*YiWei_todo need use correct litexmitbuf_nr urb_nr*/
	u32 litexmitbuf_nr = RTW_LITEXMITBUF_NR;
	u32 litexmitbuf_ext_nr = RTW_LITEXMITBUF_NR;
	struct lite_data_buf *litexmitbuf;
	struct trx_data_buf_q  *litexmitbuf_q = &dvobj->litexmitbuf_q;
	struct trx_data_buf_q  *litexmit_extbuf_q = &dvobj->litexmit_extbuf_q;
	int i;
#ifdef CONFIG_USB_HCI
	struct trx_urb_buf_q *xmit_urb_q = &dvobj->xmit_urb_q;
	struct data_urb *xmiturb;
	u32 urb_nr = RTW_XMITURB_NR;
#endif

	/* init lite_xmit_buf */
	_rtw_init_queue(&litexmitbuf_q->free_data_buf_queue);

	litexmitbuf_q->alloc_data_buf =
		rtw_zvmalloc(litexmitbuf_nr * sizeof(struct lite_data_buf) + 4);

	if (litexmitbuf_q->alloc_data_buf  == NULL) {
		ret = _FAIL;
		goto exit;
	}

	litexmitbuf_q->data_buf=
	(u8 *)N_BYTE_ALIGNMENT((SIZE_PTR)(litexmitbuf_q->alloc_data_buf), 4);

	litexmitbuf = (struct lite_data_buf *)litexmitbuf_q->data_buf;

	for (i = 0; i < litexmitbuf_nr; i++) {
		_rtw_init_listhead(&litexmitbuf->list);
		rtw_list_insert_tail(&litexmitbuf->list,
			&(litexmitbuf_q->free_data_buf_queue.queue));
		litexmitbuf++;
	}
	litexmitbuf_q->free_data_buf_cnt = litexmitbuf_nr;


	/* Init lite xmit extension buff */
	_rtw_init_queue(&litexmit_extbuf_q->free_data_buf_queue);

	litexmit_extbuf_q->alloc_data_buf=
	rtw_zvmalloc(litexmitbuf_ext_nr * sizeof(struct lite_data_buf) + 4);

	if (litexmit_extbuf_q->alloc_data_buf  == NULL) {
		ret = _FAIL;
		goto exit;
	}

	litexmit_extbuf_q->data_buf=
	(u8 *)N_BYTE_ALIGNMENT((SIZE_PTR)(litexmit_extbuf_q->alloc_data_buf), 4);

	litexmitbuf = (struct lite_data_buf *)litexmit_extbuf_q->data_buf;

	for (i = 0; i < litexmitbuf_ext_nr; i++) {
		_rtw_init_listhead(&litexmitbuf->list);
		rtw_list_insert_tail(&litexmitbuf->list,
			&(litexmit_extbuf_q->free_data_buf_queue.queue));
		litexmitbuf++;
	}
	litexmit_extbuf_q->free_data_buf_cnt= litexmitbuf_ext_nr;

#ifdef CONFIG_USB_HCI
	/* init xmit_urb */
	_rtw_init_queue(&xmit_urb_q->free_urb_buf_queue);
	xmit_urb_q->alloc_urb_buf=
		rtw_zvmalloc(urb_nr * sizeof(struct data_urb) + 4);
	if (xmit_urb_q->alloc_urb_buf== NULL) {
		ret = _FAIL;
		goto exit;
	}

	xmit_urb_q->urb_buf =
		(u8 *)N_BYTE_ALIGNMENT((SIZE_PTR)(xmit_urb_q->alloc_urb_buf), 4);

	xmiturb = (struct data_urb *)xmit_urb_q->urb_buf;
	for (i = 0; i < urb_nr; i++) {
		_rtw_init_listhead(&xmiturb->list);
		ret = rtw_os_urb_resource_alloc(xmiturb);
		rtw_list_insert_tail(&xmiturb->list,
			&(xmit_urb_q->free_urb_buf_queue.queue));
		xmiturb++;
	}
	xmit_urb_q->free_urb_buf_cnt = urb_nr;
#endif

exit:
	return ret;
}

void rtw_free_lite_xmit_resource(struct dvobj_priv *dvobj)
{
	u8 ret = _SUCCESS;
/*YiWei_todo need use correct litexmitbuf_nr urb_nr*/
	u32 litexmitbuf_nr = RTW_LITEXMITBUF_NR;
	u32 litexmitbuf_ext_nr = RTW_LITEXMITBUF_NR;
	struct trx_data_buf_q  *litexmitbuf_q = &dvobj->litexmitbuf_q;
	struct trx_data_buf_q  *litexmit_extbuf_q = &dvobj->litexmit_extbuf_q;
#ifdef CONFIG_USB_HCI
	struct data_urb *xmiturb;
	struct trx_urb_buf_q *xmit_urb_q = &dvobj->xmit_urb_q;
	u32 urb_nr = RTW_XMITURB_NR;
	int i;
#endif

	if (litexmitbuf_q->alloc_data_buf)
		rtw_vmfree(litexmitbuf_q->alloc_data_buf,
			litexmitbuf_nr * sizeof(struct lite_data_buf) + 4);

	if (litexmit_extbuf_q->alloc_data_buf)
		rtw_vmfree(litexmit_extbuf_q->alloc_data_buf,
			litexmitbuf_ext_nr * sizeof(struct lite_data_buf) + 4);

#ifdef CONFIG_USB_HCI
	xmiturb = (struct data_urb *)xmit_urb_q->urb_buf;
	for (i = 0; i < urb_nr; i++) {
		rtw_os_urb_resource_free(xmiturb);
		xmiturb++;
	}

	if (xmit_urb_q->alloc_urb_buf)
		rtw_vmfree(xmit_urb_q->alloc_urb_buf,
			urb_nr * sizeof(struct data_urb) + 4);
#endif

}


u8 rtw_get_tx_bw_mode(_adapter *adapter, struct sta_info *sta)
{
	u8 bw;

	bw = sta->phl_sta->chandef.bw;
	if (MLME_STATE(adapter) & WIFI_ASOC_STATE) {
		if (adapter->mlmeextpriv.cur_channel <= 14)
			bw = rtw_min(bw, ADAPTER_TX_BW_2G(adapter));
		else
			bw = rtw_min(bw, ADAPTER_TX_BW_5G(adapter));
	}

	return bw;
}

void rtw_get_adapter_tx_rate_bmp_by_bw(_adapter *adapter, u8 bw, u16 *r_bmp_cck_ofdm, u32 *r_bmp_ht, u64 *r_bmp_vht)
{
/* ToDo */
#if 0
	struct dvobj_priv *dvobj = adapter_to_dvobj(adapter);
	struct macid_ctl_t *macid_ctl = dvobj_to_macidctl(dvobj);
	u8 fix_bw = 0xFF;
	u16 bmp_cck_ofdm = 0;
	u32 bmp_ht = 0;
	u64 bmp_vht = 0;
	int i;

	if (adapter->fix_rate != NO_FIX_RATE && adapter->fix_bw != NO_FIX_BW)
		fix_bw = adapter->fix_bw;

	/* TODO: adapter->fix_rate */

	for (i = 0; i < macid_ctl->num; i++) {
		if (!rtw_macid_is_used(macid_ctl, i))
			continue;
		if (!rtw_macid_is_iface_specific(macid_ctl, i, adapter))
			continue;

		if (bw == CHANNEL_WIDTH_20) /* CCK, OFDM always 20MHz */
			bmp_cck_ofdm |= macid_ctl->rate_bmp0[i] & 0x00000FFF;

		/* bypass mismatch bandwidth for HT, VHT */
		if ((fix_bw != 0xFF && fix_bw != bw) || (fix_bw == 0xFF && macid_ctl->bw[i] != bw))
			continue;

		if (macid_ctl->vht_en[i])
			bmp_vht |= (macid_ctl->rate_bmp0[i] >> 12) | (macid_ctl->rate_bmp1[i] << 20);
		else
			bmp_ht |= (macid_ctl->rate_bmp0[i] >> 12) | (macid_ctl->rate_bmp1[i] << 20);
	}

	/* TODO: mlmeext->tx_rate*/

	if (r_bmp_cck_ofdm)
		*r_bmp_cck_ofdm = bmp_cck_ofdm;
	if (r_bmp_ht)
		*r_bmp_ht = bmp_ht;
	if (r_bmp_vht)
		*r_bmp_vht = bmp_vht;
#endif
}

void rtw_get_shared_macid_tx_rate_bmp_by_bw(struct dvobj_priv *dvobj, u8 bw, u16 *r_bmp_cck_ofdm, u32 *r_bmp_ht, u64 *r_bmp_vht)
{
/* ToDo */
#if 0
	struct macid_ctl_t *macid_ctl = dvobj_to_macidctl(dvobj);
	u16 bmp_cck_ofdm = 0;
	u32 bmp_ht = 0;
	u64 bmp_vht = 0;
	int i;

	for (i = 0; i < macid_ctl->num; i++) {
		if (!rtw_macid_is_used(macid_ctl, i))
			continue;
		if (!rtw_macid_is_iface_shared(macid_ctl, i))
			continue;

		if (bw == CHANNEL_WIDTH_20) /* CCK, OFDM always 20MHz */
			bmp_cck_ofdm |= macid_ctl->rate_bmp0[i] & 0x00000FFF;

		/* bypass mismatch bandwidth for HT, VHT */
		if (macid_ctl->bw[i] != bw)
			continue;

		if (macid_ctl->vht_en[i])
			bmp_vht |= (macid_ctl->rate_bmp0[i] >> 12) | (macid_ctl->rate_bmp1[i] << 20);
		else
			bmp_ht |= (macid_ctl->rate_bmp0[i] >> 12) | (macid_ctl->rate_bmp1[i] << 20);
	}

	if (r_bmp_cck_ofdm)
		*r_bmp_cck_ofdm = bmp_cck_ofdm;
	if (r_bmp_ht)
		*r_bmp_ht = bmp_ht;
	if (r_bmp_vht)
		*r_bmp_vht = bmp_vht;
#endif
}

void rtw_update_tx_rate_bmp(struct dvobj_priv *dvobj)
{
#if 0 /*GEORGIA_TODO_FIXIT*/

	struct rf_ctl_t *rf_ctl = dvobj_to_rfctl(dvobj);
	_adapter *adapter = dvobj_get_primary_adapter(dvobj);
	HAL_DATA_TYPE *hal_data = GET_HAL_DATA(dvobj);
	u8 bw;
	u16 bmp_cck_ofdm, tmp_cck_ofdm;
	u32 bmp_ht, tmp_ht, ori_bmp_ht[2];
	u64 bmp_vht, tmp_vht, ori_bmp_vht[4];
	int i;

	for (bw = CHANNEL_WIDTH_20; bw <= CHANNEL_WIDTH_160; bw++) {
		/* backup the original ht & vht bmp */
		if (bw <= CHANNEL_WIDTH_40)
			ori_bmp_ht[bw] = rf_ctl->rate_bmp_ht_by_bw[bw];
		if (bw <= CHANNEL_WIDTH_160)
			ori_bmp_vht[bw] = rf_ctl->rate_bmp_vht_by_bw[bw];

		bmp_cck_ofdm = bmp_ht = bmp_vht = 0;
		if (rtw_hw_is_band_support(dvobj, bw)) {
			for (i = 0; i < dvobj->iface_nums; i++) {
				if (!dvobj->padapters[i])
					continue;
				rtw_get_adapter_tx_rate_bmp_by_bw(dvobj->padapters[i], bw, &tmp_cck_ofdm, &tmp_ht, &tmp_vht);
				bmp_cck_ofdm |= tmp_cck_ofdm;
				bmp_ht |= tmp_ht;
				bmp_vht |= tmp_vht;
			}
			rtw_get_shared_macid_tx_rate_bmp_by_bw(dvobj, bw, &tmp_cck_ofdm, &tmp_ht, &tmp_vht);
			bmp_cck_ofdm |= tmp_cck_ofdm;
			bmp_ht |= tmp_ht;
			bmp_vht |= tmp_vht;
		}
		if (bw == CHANNEL_WIDTH_20)
			rf_ctl->rate_bmp_cck_ofdm = bmp_cck_ofdm;
		if (bw <= CHANNEL_WIDTH_40)
			rf_ctl->rate_bmp_ht_by_bw[bw] = bmp_ht;
		if (bw <= CHANNEL_WIDTH_160)
			rf_ctl->rate_bmp_vht_by_bw[bw] = bmp_vht;
	}

#if CONFIG_TXPWR_LIMIT
#ifndef DBG_HIGHEST_RATE_BMP_BW_CHANGE
#define DBG_HIGHEST_RATE_BMP_BW_CHANGE 0
#endif

	if (hal_data->txpwr_limit_loaded) {
		u8 ori_highest_ht_rate_bw_bmp;
		u8 ori_highest_vht_rate_bw_bmp;
		u8 highest_rate_bw;
		u8 highest_rate_bw_bmp;
		u8 update_ht_rs = _FALSE;
		u8 update_vht_rs = _FALSE;

		/* backup the original ht & vht highest bw bmp */
		ori_highest_ht_rate_bw_bmp = rf_ctl->highest_ht_rate_bw_bmp;
		ori_highest_vht_rate_bw_bmp = rf_ctl->highest_vht_rate_bw_bmp;

		highest_rate_bw_bmp = BW_CAP_20M;
		highest_rate_bw = CHANNEL_WIDTH_20;
		for (bw = CHANNEL_WIDTH_20; bw <= CHANNEL_WIDTH_40; bw++) {
			if (rf_ctl->rate_bmp_ht_by_bw[highest_rate_bw] < rf_ctl->rate_bmp_ht_by_bw[bw]) {
				highest_rate_bw_bmp = ch_width_to_bw_cap(bw);
				highest_rate_bw = bw;
			} else if (rf_ctl->rate_bmp_ht_by_bw[highest_rate_bw] == rf_ctl->rate_bmp_ht_by_bw[bw])
				highest_rate_bw_bmp |= ch_width_to_bw_cap(bw);
		}
		rf_ctl->highest_ht_rate_bw_bmp = highest_rate_bw_bmp;

		if (ori_highest_ht_rate_bw_bmp != rf_ctl->highest_ht_rate_bw_bmp
			|| largest_bit(ori_bmp_ht[highest_rate_bw]) != largest_bit(rf_ctl->rate_bmp_ht_by_bw[highest_rate_bw])
		) {
			if (DBG_HIGHEST_RATE_BMP_BW_CHANGE) {
				RTW_INFO("highest_ht_rate_bw_bmp:0x%02x=>0x%02x\n", ori_highest_ht_rate_bw_bmp, rf_ctl->highest_ht_rate_bw_bmp);
				RTW_INFO("rate_bmp_ht_by_bw[%u]:0x%08x=>0x%08x\n", highest_rate_bw, ori_bmp_ht[highest_rate_bw], rf_ctl->rate_bmp_ht_by_bw[highest_rate_bw]);
			}
			if (rf_ctl->rate_bmp_ht_by_bw[highest_rate_bw])
				update_ht_rs = _TRUE;
		}

		highest_rate_bw_bmp = BW_CAP_20M;
		highest_rate_bw = CHANNEL_WIDTH_20;
		for (bw = CHANNEL_WIDTH_20; bw <= CHANNEL_WIDTH_160; bw++) {
			if (rf_ctl->rate_bmp_vht_by_bw[highest_rate_bw] < rf_ctl->rate_bmp_vht_by_bw[bw]) {
				highest_rate_bw_bmp = ch_width_to_bw_cap(bw);
				highest_rate_bw = bw;
			} else if (rf_ctl->rate_bmp_vht_by_bw[highest_rate_bw] == rf_ctl->rate_bmp_vht_by_bw[bw])
				highest_rate_bw_bmp |= ch_width_to_bw_cap(bw);
		}
		rf_ctl->highest_vht_rate_bw_bmp = highest_rate_bw_bmp;

		if (ori_highest_vht_rate_bw_bmp != rf_ctl->highest_vht_rate_bw_bmp
			|| largest_bit_64(ori_bmp_vht[highest_rate_bw]) != largest_bit_64(rf_ctl->rate_bmp_vht_by_bw[highest_rate_bw])
		) {
			if (DBG_HIGHEST_RATE_BMP_BW_CHANGE) {
				RTW_INFO("highest_vht_rate_bw_bmp:0x%02x=>0x%02x\n", ori_highest_vht_rate_bw_bmp, rf_ctl->highest_vht_rate_bw_bmp);
				RTW_INFO("rate_bmp_vht_by_bw[%u]:0x%016llx=>0x%016llx\n", highest_rate_bw, ori_bmp_vht[highest_rate_bw], rf_ctl->rate_bmp_vht_by_bw[highest_rate_bw]);
			}
			if (rf_ctl->rate_bmp_vht_by_bw[highest_rate_bw])
				update_vht_rs = _TRUE;
		}

		/* TODO: per rfpath and rate section handling? */
		if (update_ht_rs == _TRUE || update_vht_rs == _TRUE)
			rtw_hal_set_tx_power_level(dvobj_get_primary_adapter(dvobj), hal_data->current_channel);
	}
#endif /* CONFIG_TXPWR_LIMIT */
#endif
}

u8 rtw_get_tx_bw_bmp_of_ht_rate(struct dvobj_priv *dvobj, u8 rate, u8 max_bw)
{
	struct rf_ctl_t *rf_ctl = dvobj_to_rfctl(dvobj);
	u8 bw;
	u8 bw_bmp = 0;
	u32 rate_bmp;

	if (!IS_HT_RATE(rate)) {
		rtw_warn_on(1);
		goto exit;
	}

	rate_bmp = 1 << (rate - MGN_MCS0);

	if (max_bw > CHANNEL_WIDTH_40)
		max_bw = CHANNEL_WIDTH_40;

	for (bw = CHANNEL_WIDTH_20; bw <= max_bw; bw++) {
		/* RA may use lower rate for retry */
		if (rf_ctl->rate_bmp_ht_by_bw[bw] >= rate_bmp)
			bw_bmp |= ch_width_to_bw_cap(bw);
	}

exit:
	return bw_bmp;
}

u8 rtw_get_tx_bw_bmp_of_vht_rate(struct dvobj_priv *dvobj, u8 rate, u8 max_bw)
{
	struct rf_ctl_t *rf_ctl = dvobj_to_rfctl(dvobj);
	u8 bw;
	u8 bw_bmp = 0;
	u64 rate_bmp;

	if (!IS_VHT_RATE(rate)) {
		rtw_warn_on(1);
		goto exit;
	}

	rate_bmp = 1ULL << (rate - MGN_VHT1SS_MCS0);

	if (max_bw > CHANNEL_WIDTH_160)
		max_bw = CHANNEL_WIDTH_160;

	for (bw = CHANNEL_WIDTH_20; bw <= max_bw; bw++) {
		/* RA may use lower rate for retry */
		if (rf_ctl->rate_bmp_vht_by_bw[bw] >= rate_bmp)
			bw_bmp |= ch_width_to_bw_cap(bw);
	}

exit:
	return bw_bmp;
}

s16 rtw_rfctl_get_oper_txpwr_max_mbm(struct rf_ctl_t *rfctl, u8 ch, u8 bw, u8 offset, u8 ifbmp_mod, u8 if_op, bool eirp)
{
	/* TODO: get maximum txpower of current operating class & channel belongs to this radio */
	s16 mbm = 2000;
	return mbm;
}

s16 rtw_rfctl_get_reg_max_txpwr_mbm(struct rf_ctl_t *rfctl, u8 ch, u8 bw, u8 offset, bool eirp)
{
	/* TODO: get maximum txpower of current operating class & channel belongs to this radio allowed by regulatory */
	s16 mbm = 1300;
	return mbm;
}

u8 query_ra_short_GI(struct sta_info *psta, u8 bw)
{
	u8	sgi = _FALSE, sgi_20m = _FALSE, sgi_40m = _FALSE, sgi_80m = _FALSE;

#ifdef CONFIG_80211N_HT
#ifdef CONFIG_80211AC_VHT
#ifdef CONFIG_80211AX_HE
	/* CONFIG_80211AX_HE_TODO */
#endif /* CONFIG_80211AX_HE */
	if (psta->vhtpriv.vht_option)
		sgi_80m = psta->vhtpriv.sgi_80m;
#endif
	sgi_20m = psta->htpriv.sgi_20m;
	sgi_40m = psta->htpriv.sgi_40m;
#endif

	switch (bw) {
	case CHANNEL_WIDTH_80:
		sgi = sgi_80m;
		break;
	case CHANNEL_WIDTH_40:
		sgi = sgi_40m;
		break;
	case CHANNEL_WIDTH_20:
	default:
		sgi = sgi_20m;
		break;
	}

	return sgi;
}

static void update_attrib_vcs_info(_adapter *padapter, struct xmit_frame *pxmitframe)
{
	u32	sz;
	struct pkt_attrib	*pattrib = &pxmitframe->attrib;
	/* struct sta_info	*psta = pattrib->psta; */
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info	*pmlmeinfo = &(pmlmeext->mlmext_info);

	/*
		if(pattrib->psta)
		{
			psta = pattrib->psta;
		}
		else
		{
			RTW_INFO("%s, call rtw_get_stainfo()\n", __func__);
			psta=rtw_get_stainfo(&padapter->stapriv ,&pattrib->ra[0] );
		}

		if(psta==NULL)
		{
			RTW_INFO("%s, psta==NUL\n", __func__);
			return;
		}

		if(!(psta->state &WIFI_ASOC_STATE))
		{
			RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
			return;
		}
	*/

	if (pattrib->nr_frags != 1)
		sz = padapter->xmitpriv.frag_len;
	else /* no frag */
		sz = pattrib->last_txcmdsz;

	/* (1) RTS_Threshold is compared to the MPDU, not MSDU. */
	/* (2) If there are more than one frag in  this MSDU, only the first frag uses protection frame. */
	/*		Other fragments are protected by previous fragment. */
	/*		So we only need to check the length of first fragment. */
	if (pmlmeext->cur_wireless_mode < WLAN_MD_11N  || padapter->registrypriv.wifi_spec) {
		if (sz > padapter->registrypriv.rts_thresh)
			pattrib->vcs_mode = RTS_CTS;
		else {
			if (pattrib->rtsen)
				pattrib->vcs_mode = RTS_CTS;
			else if (pattrib->cts2self)
				pattrib->vcs_mode = CTS_TO_SELF;
			else
				pattrib->vcs_mode = NONE_VCS;
		}
	} else {
		while (_TRUE) {
#if 0 /* Todo */
			/* check IOT action */
			if (pHTInfo->IOTAction & HT_IOT_ACT_FORCED_CTS2SELF) {
				pattrib->vcs_mode = CTS_TO_SELF;
				pattrib->rts_rate = MGN_24M;
				break;
			} else if (pHTInfo->IOTAction & (HT_IOT_ACT_FORCED_RTS | HT_IOT_ACT_PURE_N_MODE)) {
				pattrib->vcs_mode = RTS_CTS;
				pattrib->rts_rate = MGN_24M;
				break;
			}
#endif

			/* IOT action */
			if ((pmlmeinfo->assoc_AP_vendor == HT_IOT_PEER_ATHEROS) && (pattrib->ampdu_en == _TRUE) &&
			    (padapter->securitypriv.dot11PrivacyAlgrthm == _AES_)) {
				pattrib->vcs_mode = CTS_TO_SELF;
				break;
			}


			/* check ERP protection */
			if (pattrib->rtsen || pattrib->cts2self) {
				if (pattrib->rtsen)
					pattrib->vcs_mode = RTS_CTS;
				else if (pattrib->cts2self)
					pattrib->vcs_mode = CTS_TO_SELF;

				break;
			}

			/* check HT op mode */
			if (pattrib->ht_en) {
				u8 HTOpMode = pmlmeinfo->HT_protection;
				if ((pmlmeext->cur_bwmode && (HTOpMode == 2 || HTOpMode == 3)) ||
				    (!pmlmeext->cur_bwmode && HTOpMode == 3)) {
					pattrib->vcs_mode = RTS_CTS;
					break;
				}
			}

			/* check rts */
			if (sz > padapter->registrypriv.rts_thresh) {
				pattrib->vcs_mode = RTS_CTS;
				break;
			}

			/* to do list: check MIMO power save condition. */

			/* check AMPDU aggregation for TXOP */
			if (pattrib->ampdu_en == _TRUE) {
				pattrib->vcs_mode = RTS_CTS;
				break;
			}

			pattrib->vcs_mode = NONE_VCS;
			break;
		}
	}

	/* for debug : force driver control vrtl_carrier_sense. */
	if (padapter->driver_vcs_en == 1) {
		/* u8 driver_vcs_en; */ /* Enable=1, Disable=0 driver control vrtl_carrier_sense. */
		/* u8 driver_vcs_type; */ /* force 0:disable VCS, 1:RTS-CTS, 2:CTS-to-self when vcs_en=1. */
		pattrib->vcs_mode = padapter->driver_vcs_type;
	}

}

#ifdef CONFIG_WMMPS_STA
/*
 * update_attrib_trigger_frame_info
 * For Station mode, if a specific TID of driver setting and an AP support uapsd function, the data
 * frame with corresponding TID will be a trigger frame when driver is in wmm power saving mode.
 *
 * Arguments:
 * @padapter: _adapter pointer.
 * @pattrib: pkt_attrib pointer.
 *
 * Auther: Arvin Liu
 * Date: 2017/06/05
 */
static void update_attrib_trigger_frame_info(_adapter *padapter, struct pkt_attrib *pattrib) {
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct pwrctrl_priv 	*pwrpriv = adapter_to_pwrctl(padapter);
	struct qos_priv 	*pqospriv = &pmlmepriv->qospriv;
	u8 trigger_frame_en = 0;

	if (MLME_IS_STA(padapter)) {
		if ((pwrpriv->pwr_mode == PM_PS_MODE_MIN) || (pwrpriv->pwr_mode == PM_PS_MODE_MAX)) {
			if((pqospriv->uapsd_ap_supported) && ((pqospriv->uapsd_tid & BIT(pattrib->priority)) == _TRUE)) {
				trigger_frame_en = 1;
				RTW_INFO("[WMMPS]"FUNC_ADPT_FMT": This is a Trigger Frame\n", FUNC_ADPT_ARG(padapter));
			}
		}
	}

	pattrib->trigger_frame = trigger_frame_en;
}
#endif /* CONFIG_WMMPS_STA */

static void update_attrib_phy_info(_adapter *padapter, struct pkt_attrib *pattrib, struct sta_info *psta)
{
	struct mlme_ext_priv *mlmeext = &padapter->mlmeextpriv;
	u8 bw;

	pattrib->rtsen = psta->phl_sta->rts_en;
	pattrib->cts2self = psta->phl_sta->cts2self;

	pattrib->mdata = 0;
	pattrib->eosp = 0;
	pattrib->triggered = 0;
	pattrib->ampdu_spacing = 0;

	/* ht_en, init rate, ,bw, ch_offset, sgi */

	/* ToDo: Need API to inform hal_sta->ra_info.rate_id */
	/* pattrib->raid = psta->phl_sta->ra_info.rate_id; */

	bw = rtw_get_tx_bw_mode(padapter, psta);
	pattrib->bwmode = rtw_min(bw, mlmeext->cur_bwmode);
	pattrib->sgi = query_ra_short_GI(psta, pattrib->bwmode);

	if (psta->phl_sta->wmode & WLAN_MD_11AX) {
		pattrib->ldpc = psta->phl_sta->asoc_cap.he_ldpc;
		pattrib->stbc = (psta->phl_sta->asoc_cap.stbc_he_rx > 0) ? 1:0;
	} else if (psta->phl_sta->wmode & WLAN_MD_11AC) {
		pattrib->ldpc = psta->phl_sta->asoc_cap.vht_ldpc;
		pattrib->stbc = (psta->phl_sta->asoc_cap.stbc_vht_rx > 0) ? 1:0;
	} else if (psta->phl_sta->wmode & WLAN_MD_11N) {
		pattrib->ldpc = psta->phl_sta->asoc_cap.ht_ldpc;
		pattrib->stbc = (psta->phl_sta->asoc_cap.stbc_ht_rx > 0) ? 1:0;
	} else {
		pattrib->ldpc = 0;
		pattrib->stbc = 0;
	}

#ifdef CONFIG_80211N_HT
	if(padapter->registrypriv.ht_enable &&
		is_supported_ht(padapter->registrypriv.wireless_mode)) {
		pattrib->ht_en = psta->htpriv.ht_option;
		pattrib->ch_offset = psta->htpriv.ch_offset;
		pattrib->ampdu_en = _FALSE;

		if (padapter->driver_ampdu_spacing != 0xFF) /* driver control AMPDU Density for peer sta's rx */
			pattrib->ampdu_spacing = padapter->driver_ampdu_spacing;
		else
			pattrib->ampdu_spacing = psta->htpriv.rx_ampdu_min_spacing;

		/* check if enable ampdu */
		if (pattrib->ht_en && psta->htpriv.ampdu_enable) {
			if (psta->htpriv.agg_enable_bitmap & BIT(pattrib->priority)) {
				pattrib->ampdu_en = _TRUE;
				if (psta->htpriv.tx_amsdu_enable == _TRUE)
					pattrib->amsdu_ampdu_en = _TRUE;
				else
					pattrib->amsdu_ampdu_en = _FALSE;
			}
		}
	}
#endif /* CONFIG_80211N_HT */
	/* if(pattrib->ht_en && psta->htpriv.ampdu_enable) */
	/* { */
	/*	if(psta->htpriv.agg_enable_bitmap & BIT(pattrib->priority)) */
	/*		pattrib->ampdu_en = _TRUE; */
	/* }	 */

#ifdef CONFIG_TDLS
	if (pattrib->direct_link == _TRUE) {
		psta = pattrib->ptdls_sta;

		pattrib->raid = psta->phl_sta->ra_info.rate_id;
#ifdef CONFIG_80211N_HT
	if(padapter->registrypriv.ht_enable &&
		is_supported_ht(padapter->registrypriv.wireless_mode)) {
			pattrib->bwmode = rtw_get_tx_bw_mode(padapter, psta);
			pattrib->ht_en = psta->htpriv.ht_option;
			pattrib->ch_offset = psta->htpriv.ch_offset;
			pattrib->sgi = query_ra_short_GI(psta, pattrib->bwmode);
	}
#endif /* CONFIG_80211N_HT */
	}
#endif /* CONFIG_TDLS */

	pattrib->retry_ctrl = _FALSE;
}

static s32 update_attrib_sec_iv_info(_adapter *padapter, struct pkt_attrib *pattrib)
{
	struct sta_info *psta = pattrib->psta;

	if (!psta)
		return _FAIL;

	switch (pattrib->encrypt) {
	case _WEP40_:
	case _WEP104_:
		UPDATE_WEP_PN(pattrib->pn, psta->dot11txpn);
		WEP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
		break;

	case _TKIP_:
		UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, psta->dot11txpn);
		TKIP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
		break;

	case _AES_:
	case _CCMP_256_:
		UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, psta->dot11txpn);
		CCMP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
		break;

	case _GCMP_:
	case _GCMP_256_:
		UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, psta->dot11txpn);
		GCMP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
		break;

#if defined(CONFIG_WAPI_SUPPORT)
	case _SMS4_:
	case _GCM_SM4_:
		rtw_wapi_get_iv(padapter, pattrib->ra, pattrib->iv);
		break;
#endif

#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
	case _SMS4_:
	case _GCM_SM4_:
		if (IS_MCAST(pattrib->ra))
			rtw_wapi_get_iv(padapter, NULL, pattrib->key_idx, pattrib->iv);
		else
			rtw_wapi_get_iv(padapter, psta, pattrib->key_idx, pattrib->iv);
		break;
#endif

	default:
		break;
	}

	return _SUCCESS;
}

static s32 update_attrib_sec_info(_adapter *padapter, struct pkt_attrib *pattrib, struct sta_info *psta, enum eap_type eapol_type)
{
	sint res = _SUCCESS;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct security_priv *psecuritypriv = &padapter->securitypriv;
	sint bmcast = IS_MCAST(pattrib->ra);
	s8 hw_decrypted = _FALSE;
	u8 hw_security_zero_hdrlen = _FALSE;
	#define UNENC_EAPOL_TIMER 500

	_rtw_memset(pattrib->dot118021x_UncstKey.skey, 0, 16);
	_rtw_memset(pattrib->dot11tkiptxmickey.skey, 0, 16);
	pattrib->mac_id = psta->phl_sta->macid;

	/* Comment by Owen at 2020/05/19
	 * Issue: RTK STA sends encrypted 4-way 4/4 when AP thinks the 4-way incomplete
	 * In TCL pressure test, AP may resend 4-way 3/4 with new replay counter in 2 ms.
	 * In this situation, STA sends unencrypted 4-way 4/4 with old replay counter after more
	 * than 2 ms, followed by the encrypted 4-way 4/4 with new replay counter. Because the
	 * AP only accepts unencrypted 4-way 4/4 with a new play counter, and the STA encrypts
	 * each 4-way 4/4 at this time, the 4-way handshake cannot be completed.
	 * So we modified that after STA receives unencrypted 4-way 1/4 and 4-way 3/4,
	 * 4-way 2/4 and 4-way 4/4 sent by STA in the next 100 ms are not encrypted.
	 */
	if (psta->ieee8021x_blocked == _TRUE ||
		((eapol_type == EAPOL_1_4 || eapol_type == EAPOL_2_4 || eapol_type == EAPOL_3_4 || eapol_type == EAPOL_4_4)
		/*&& rtw_get_passing_time_ms(psta->resp_nonenc_eapol_key_starttime) <= UNENC_EAPOL_TIMER*/)) {

		if (eapol_type == EAPOL_1_4 || eapol_type == EAPOL_2_4 || eapol_type == EAPOL_3_4 || eapol_type == EAPOL_4_4)
			RTW_INFO(ADPT_FMT" send unencrypted eapol key, eapol_type=%d/4\n",
					 ADPT_ARG(padapter), eapol_type - EAPOL_1_4 + 1);

		pattrib->encrypt = 0;

		if ((pattrib->ether_type != 0x888e) &&
#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
		    (pattrib->ether_type != 0x88B4) &&
#endif
		    (check_fwstate(pmlmepriv, WIFI_MP_STATE) == _FALSE)) {
#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s psta->ieee8021x_blocked == _TRUE,  pattrib->ether_type(%04x) != 0x888e\n", __FUNCTION__, pattrib->ether_type);
#endif
			res = _FAIL;
			goto exit;
		}
	} else {
		GET_ENCRY_ALGO(psecuritypriv, psta, pattrib->encrypt, bmcast);

		if (rtw_sec_algo_drv2phl(pattrib->encrypt) == RTW_ENC_MAX) {
			RTW_PRINT("[SEC_WRONG] STA[%pM] wrong enc_algo:0x%x bmcast:%d auth_algo:%d, privcylgo:%d 8021x:%d sta_8021x:%d\n",
						psta->phl_sta->mac_addr, pattrib->encrypt, bmcast,
						psecuritypriv->dot11AuthAlgrthm,
						psecuritypriv->dot11PrivacyAlgrthm,
						psecuritypriv->dot118021XGrpPrivacy,
						psta->dot118021XPrivacy);

			/* workaround for psta 8021xPrivacy wrong value */
			if (padapter->securitypriv.dot11AuthAlgrthm == dot11AuthAlgrthm_8021X)
				psta->dot118021XPrivacy = padapter->securitypriv.dot11PrivacyAlgrthm;
			GET_ENCRY_ALGO(psecuritypriv, psta, pattrib->encrypt, bmcast);

			RTW_PRINT("[FIX_IT] enc_algo:0x%x\n", pattrib->encrypt);
		}


#if defined(CONFIG_WAPI_SUPPORT) || defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
		if (pattrib->ether_type == 0x88B4)
			pattrib->encrypt = _NO_PRIVACY_;
#endif

		switch (psecuritypriv->dot11AuthAlgrthm) {
		case dot11AuthAlgrthm_Open:
		case dot11AuthAlgrthm_Shared:
		case dot11AuthAlgrthm_Auto:
			pattrib->key_idx = (u8)psecuritypriv->dot11PrivacyKeyIndex;
			break;
		case dot11AuthAlgrthm_8021X:
			if (bmcast)
				pattrib->key_idx = (u8)psecuritypriv->dot118021XGrpKeyid;
			else
				pattrib->key_idx = 0;
			break;

#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
		case dot11AuthAlgrthm_WAPI:
			if (bmcast)
				pattrib->key_idx = padapter->wapiApInfo.keyIdx;
			else
				pattrib->key_idx = psta->wapiStaInfo.keyIdx;
			break;
#endif

		default:
			pattrib->key_idx = 0;
			break;
		}

		/* For WPS 1.0 WEP, driver should not encrypt EAPOL Packet for WPS handshake. */
		if (((pattrib->encrypt == _WEP40_) || (pattrib->encrypt == _WEP104_)) && (pattrib->ether_type == 0x888e))
			pattrib->encrypt = _NO_PRIVACY_;

	}

#ifdef CONFIG_TDLS
	if (pattrib->direct_link == _TRUE) {
		if (pattrib->encrypt > 0)
			pattrib->encrypt = _AES_;
	}
#endif

	switch (pattrib->encrypt) {
	case _WEP40_:
	case _WEP104_:
		pattrib->iv_len = 4;
		pattrib->icv_len = 4;
		hw_security_zero_hdrlen = _TRUE;
		break;

	case _TKIP_:
		pattrib->iv_len = 8;
		pattrib->icv_len = 4;
		hw_security_zero_hdrlen = _TRUE;

		if (psecuritypriv->busetkipkey == _FAIL) {
#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s psecuritypriv->busetkipkey(%d)==_FAIL drop packet\n", __FUNCTION__, psecuritypriv->busetkipkey);
#endif
			res = _FAIL;
			goto exit;
		}

		_rtw_memcpy(pattrib->dot11tkiptxmickey.skey, psta->dot11tkiptxmickey.skey, 16);

		break;

	case _AES_:

		pattrib->iv_len = 8;
		pattrib->icv_len = 8;
		hw_security_zero_hdrlen = _TRUE;

		break;

	case _GCMP_:
	case _GCMP_256_:

		pattrib->iv_len = 8;
		pattrib->icv_len = 16;
		hw_security_zero_hdrlen = _TRUE;

		break;

	case _CCMP_256_:

		pattrib->iv_len = 8;
		pattrib->icv_len = 16;
		hw_security_zero_hdrlen = _TRUE;

		break;

#if defined(CONFIG_WAPI_SUPPORT) || defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
	case _SMS4_:
	case _GCM_SM4_:
		pattrib->iv_len = 18;
		pattrib->icv_len = 16;
		break;
#endif
	default:
		pattrib->iv_len = 0;
		pattrib->icv_len = 0;
		break;
	}

	if (pattrib->encrypt > 0) {
		_rtw_memcpy(pattrib->dot118021x_UncstKey.skey
			, psta->dot118021x_UncstKey.skey
			, (pattrib->encrypt & _SEC_TYPE_256_) ? 32 : 16);
	}

	if (!bmcast)
		hw_decrypted = psta->hw_decrypted;
	else
		hw_decrypted = psecuritypriv->hw_decrypted;

	if (pattrib->encrypt &&
		(padapter->securitypriv.sw_encrypt == _TRUE || pattrib->encrypt == _TKIP_ ||
		 pattrib->encrypt == _WEP40_ || pattrib->encrypt == _WEP104_)) {
		pattrib->bswenc = _TRUE;
	} else {
		pattrib->bswenc = _FALSE;
	}

#if defined(CONFIG_CONCURRENT_MODE)
	pattrib->bmc_camid = padapter->securitypriv.dot118021x_bmc_cam_id;
#endif

#ifdef CONFIG_WAPI_SUPPORT
	if (pattrib->encrypt == _SMS4_)
		pattrib->bswenc = _FALSE;
#endif

	if ((pattrib->bswenc == _FALSE) &&
	    (hw_security_zero_hdrlen == _TRUE) &&
	    (padapter->dvobj->phl_com->dev_cap.sec_cap.hw_form_hdr)) {
		pattrib->iv_len = 0;
	}

exit:

	return res;

}

u8	qos_acm(u8 acm_mask, u8 priority)
{
	u8	change_priority = priority;

	switch (priority) {
	case 0:
	case 3:
		if (acm_mask & BIT(1))
			change_priority = 1;
		break;
	case 1:
	case 2:
		break;
	case 4:
	case 5:
		if (acm_mask & BIT(2))
			change_priority = 0;
		break;
	case 6:
	case 7:
		if (acm_mask & BIT(3))
			change_priority = 5;
		break;
	default:
		RTW_INFO("qos_acm(): invalid pattrib->priority: %d!!!\n", priority);
		break;
	}

	return change_priority;
}

#if 0 //RTW_PHL_TX: mark un-finished codes for reading
static void set_qos_core(struct xmit_frame *pxframe)
{
	s32 UserPriority = 0;

	if (!XF_SKB)
		goto null_pkt;

	/* get UserPriority from IP hdr */
	if (XF_ETHTYPE == 0x0800) {
		struct pkt_file ppktfile;
		struct ethhdr etherhdr;
		struct iphdr ip_hdr;

		_rtw_open_pktfile(XF_SKB, &ppktfile);
		_rtw_pktfile_read(&ppktfile, (unsigned char *)&etherhdr, ETH_HLEN);
		_rtw_pktfile_read(&ppktfile, (u8 *)&ip_hdr, sizeof(ip_hdr));
		UserPriority = tos_to_up(ip_hdr.tos);
	}


	#ifdef CONFIG_ICMP_VOQ
	if(XF_ICMP == 1)/*use VO queue to send icmp packet*/
		UserPriority = 7;
	#endif
	#ifdef CONFIG_IP_R_MONITOR
	if (XF_ETHTYPE == ETH_P_ARP)
		UserPriority = 7;
	#endif/*CONFIG_IP_R_MONITOR*/

null_pkt:
	XF_WL_TID= UserPriority;
	XF_WL_HDRLEN = WLAN_HDR_A3_QOS_LEN;
	XF_WL_SUBTYPE = WIFI_QOS_DATA_TYPE;
}
#endif

static void set_qos(_adapter *padapter, struct sk_buff *pkt, struct pkt_attrib *pattrib)
{
	s32 UserPriority = 0;

	if (!pkt)
		goto null_pkt;

#if 0
	/* get UserPriority from IP hdr */
	if (pattrib->ether_type == 0x0800) {
		struct pkt_file ppktfile;
		struct ethhdr etherhdr;
		struct iphdr ip_hdr;

		_rtw_open_pktfile(pkt, &ppktfile);
		_rtw_pktfile_read(&ppktfile, (unsigned char *)&etherhdr, ETH_HLEN);
		_rtw_pktfile_read(&ppktfile, (u8 *)&ip_hdr, sizeof(ip_hdr));
		UserPriority = (ntohs(ip_hdr.tos) >> 5) & 0x3;
	}
#else
	/* Apply priority processed previously */
	UserPriority = pkt->cb[_SKB_CB_PRIORITY];
#endif

	#ifdef CONFIG_ICMP_VOQ
	if(pattrib->icmp_pkt==1)/*use VO queue to send icmp packet*/
		UserPriority = 7;
	#endif
	#ifdef CONFIG_IP_R_MONITOR
	if (pattrib->ether_type == ETH_P_ARP)
		UserPriority = 7;
	#endif/*CONFIG_IP_R_MONITOR*/

#ifdef CONFIG_RTW_MULTI_AP_R3
	core_map_tx_set_qos_priority(padapter, pkt, &UserPriority);
#endif

null_pkt:
	pattrib->priority = UserPriority;
	pattrib->hdrlen = WLAN_HDR_A3_QOS_LEN;
	pattrib->subtype = WIFI_QOS_DATA_TYPE;
}

#ifdef CONFIG_TDLS
u8 rtw_check_tdls_established(_adapter *padapter, struct pkt_attrib *pattrib)
{
	pattrib->ptdls_sta = NULL;

	pattrib->direct_link = _FALSE;
	if (padapter->tdlsinfo.link_established == _TRUE) {
		pattrib->ptdls_sta = rtw_get_stainfo(&padapter->stapriv, pattrib->dst);
#if 1
		if ((pattrib->ptdls_sta != NULL) &&
		    (pattrib->ptdls_sta->tdls_sta_state & TDLS_LINKED_STATE) &&
		    (pattrib->ether_type != 0x0806)) {
			pattrib->direct_link = _TRUE;
			/* RTW_INFO("send ptk to "MAC_FMT" using direct link\n", MAC_ARG(pattrib->dst)); */
		}
#else
		if (pattrib->ptdls_sta != NULL &&
		    pattrib->ptdls_sta->tdls_sta_state & TDLS_LINKED_STATE) {
			pattrib->direct_link = _TRUE;
#if 0
			RTW_INFO("send ptk to "MAC_FMT" using direct link\n", MAC_ARG(pattrib->dst));
#endif
		}

		/* ARP frame may be helped by AP*/
		if (pattrib->ether_type != 0x0806)
			pattrib->direct_link = _FALSE;
#endif
	}

	return pattrib->direct_link;
}

s32 update_tdls_attrib(_adapter *padapter, struct pkt_attrib *pattrib)
{

	struct sta_info *psta = NULL;
	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct security_priv	*psecuritypriv = &padapter->securitypriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct qos_priv		*pqospriv = &pmlmepriv->qospriv;

	s32 res = _SUCCESS;

	psta = rtw_get_stainfo(pstapriv, pattrib->ra);
	if (psta == NULL)	{
		res = _FAIL;
		goto exit;
	}

	pattrib->mac_id = psta->phl_sta->macid;
	pattrib->psta = psta;
	pattrib->ack_policy = 0;
	/* get ether_hdr_len */
	pattrib->pkt_hdrlen = ETH_HLEN;

	pattrib->qos_en = psta->qos_option;

	/* [TDLS] TODO: setup req/rsp should be AC_BK */
	if (pqospriv->qos_option &&  psta->qos_option) {
		pattrib->priority = 4;	/* tdls management frame should be AC_VI */
		pattrib->hdrlen = WLAN_HDR_A3_QOS_LEN;
		pattrib->subtype = WIFI_QOS_DATA_TYPE;
	} else {
		pattrib->priority = 0;
		pattrib->hdrlen = WLAN_HDR_A3_LEN;
		pattrib->subtype = WIFI_DATA;
	}

	/* TODO:_lock */
	if (update_attrib_sec_info(padapter, pattrib, psta, NON_EAPOL) == _FAIL) {
		res = _FAIL;
		goto exit;
	}

	update_attrib_phy_info(padapter, pattrib, psta);


exit:

	return res;
}

#endif /* CONFIG_TDLS */


#ifdef CONFIG_LPS
#define LPS_PT_NORMAL	0
#define LPS_PT_SP		1/* only DHCP packets is as SPECIAL_PACKET*/
#define LPS_PT_ICMP		2

/*If EAPOL , ARP , OR DHCP packet, driver must be in active mode.*/
static u8 _rtw_lps_chk_packet_type(struct pkt_attrib *pattrib)
{
	u8 pkt_type = LPS_PT_NORMAL; /*normal data frame*/

	#ifdef CONFIG_WAPI_SUPPORT
	if ((pattrib->ether_type == 0x88B4) || (pattrib->ether_type == 0x0806) || (pattrib->ether_type == 0x888e) || (pattrib->dhcp_pkt == 1))
		pkt_type = LPS_PT_SP;
	#else /* !CONFIG_WAPI_SUPPORT */

	#ifndef CONFIG_LPS_NOT_LEAVE_FOR_ICMP
	if (pattrib->icmp_pkt == 1)
		pkt_type = LPS_PT_ICMP;
	else
	#endif
		if (pattrib->dhcp_pkt == 1)
			pkt_type = LPS_PT_SP;
	#endif
	return pkt_type;
}
#endif

#if 0 //RTW_PHL_TX: mark un-finished codes for reading
static s32 update_xmitframe_from_hdr(_adapter *padapter, struct xmit_frame *pxframe)
{
	uint i;
	struct pkt_file pktfile;
	struct sta_info *psta = NULL;
	struct ethhdr etherhdr;
	struct sk_buff *pkt = NULL;
	sint bmcast;

	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct qos_priv		*pqospriv = &pmlmepriv->qospriv;
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;

	PHLTX_LOG;

	if(XF_SKB)
		pkt = XF_SKB;
	else
		return FAIL;

	PHLTX_LOG;

	_rtw_open_pktfile(pkt, &pktfile);
	i = _rtw_pktfile_read(&pktfile, (u8 *)&etherhdr, ETH_HLEN);

	XF_ETHTYPE = ntohs(etherhdr.h_proto);

	if (MLME_IS_MESH(padapter)) /* address resolve is done for mesh */
		goto get_sta_info;

	_rtw_memcpy(XF_DA, &etherhdr.h_dest, ETH_ALEN);
	_rtw_memcpy(XF_SA, &etherhdr.h_source, ETH_ALEN);

	if ((check_fwstate(pmlmepriv, WIFI_ADHOC_STATE) == _TRUE) ||
	    (check_fwstate(pmlmepriv, WIFI_ADHOC_MASTER_STATE) == _TRUE)) {
		_rtw_memcpy(XF_RA, XF_DA, ETH_ALEN);
		_rtw_memcpy(XF_TA, adapter_mac_addr(padapter), ETH_ALEN);
	} else if (MLME_IS_STA(padapter)) {

#if 0//def CONFIG_TDLS  //rtw_phl_tx
		if (rtw_check_tdls_established(padapter, pattrib) == _TRUE)
			_rtw_memcpy(pattrib->ra, pattrib->dst, ETH_ALEN);	/* For TDLS direct link Tx, set ra to be same to dst */
		else
#endif
		_rtw_memcpy(XF_RA, get_bssid(pmlmepriv), ETH_ALEN);
		_rtw_memcpy(XF_TA, adapter_mac_addr(padapter), ETH_ALEN);
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_sta);
	} else if (check_fwstate(pmlmepriv, WIFI_AP_STATE)) {
		_rtw_memcpy(XF_RA, XF_DA, ETH_ALEN);
		_rtw_memcpy(XF_TA, get_bssid(pmlmepriv), ETH_ALEN);
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_ap);
	} else
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_unknown);

	PHLTX_LOG;

get_sta_info:
	bmcast = IS_MCAST(XF_RA);
	if (bmcast) {
		PHLTX_LOG;
		psta = rtw_get_bcmc_stainfo(padapter);
		if (psta == NULL) { /* if we cannot get psta => drop the pkt */
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_sta);
			#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s get sta_info fail, ra:" MAC_FMT"\n", __func__, MAC_ARG(XF_RA));
			#endif
			return FAIL;
		}
	} else {
		PHLTX_LOG;
		psta = rtw_get_stainfo(pstapriv, XF_RA);
		if (psta == NULL) { /* if we cannot get psta => drop the pkt */
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_ucast_sta);
			#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s get sta_info fail, ra:" MAC_FMT"\n", __func__, MAC_ARG(XF_RA));
			#endif
			return FAIL;
		} else if (check_fwstate(pmlmepriv, WIFI_AP_STATE) == _TRUE && !(psta->state & WIFI_ASOC_STATE)) {
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_ucast_ap_link);
			return FAIL;
		}
	}

	PHLTX_LOG;

	if (!(psta->state & WIFI_ASOC_STATE)) {
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_link);
		RTW_INFO("%s-"ADPT_FMT" psta("MAC_FMT")->state(0x%x) != WIFI_ASOC_STATE\n",
			__func__, ADPT_ARG(padapter), MAC_ARG(psta->phl_sta->mac_addr), psta->state);
		return FAIL;
	}

	XF_STA = psta;

	PHLTX_LOG;

	XF_SZ_PAYLOAD = pktfile.pkt_len;

	/* TODO: 802.1Q VLAN header */
	/* TODO: IPV6 */

	if (ETH_P_IP == XF_ETHTYPE) {
		u8 ip[20];

		_rtw_pktfile_read(&pktfile, ip, 20);

		if (GET_IPV4_IHL(ip) * 4 > 20)
			_rtw_pktfile_read(&pktfile, NULL, GET_IPV4_IHL(ip) - 20);

		XF_ICMP = 0;
		XF_DHCP = 0;
		XF_HI_PRI = 0;

		if (GET_IPV4_PROTOCOL(ip) == 0x01) { /* ICMP */
			XF_ICMP = 1;
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_icmp);

		} else if (GET_IPV4_PROTOCOL(ip) == 0x11) { /* UDP */
			u8 udp[24];

			_rtw_pktfile_read(&pktfile, udp, 24);

			if ((GET_UDP_SRC(udp) == 68 && GET_UDP_DST(udp) == 67)
				|| (GET_UDP_SRC(udp) == 67 && GET_UDP_DST(udp) == 68)
			) {
				/* 67 : UDP BOOTP server, 68 : UDP BOOTP client */
				if (XF_SZ_PAYLOAD > 282) { /* MINIMUM_DHCP_PACKET_SIZE */
					XF_DHCP = 1;
					DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_dhcp);
					if (0)
						RTW_INFO("send DHCP packet\n");
				}
			}

			/* WaveAgent packet, increase priority so that the system can read data in time */
			if (((GET_UDP_SIG1(udp) == 0xcc) || (GET_UDP_SIG1(udp) == 0xdd)) &&
				(GET_UDP_SIG2(udp) == 0xe2)) {
				XF_HI_PRI = 1;
			}

		} else if (GET_IPV4_PROTOCOL(ip) == 0x06 /* TCP */
			&& rtw_st_ctl_chk_reg_s_proto(&psta->st_ctl, 0x06) == _TRUE
		) {
			u8 tcp[20];

			_rtw_pktfile_read(&pktfile, tcp, 20);

			if (rtw_st_ctl_chk_reg_rule(&psta->st_ctl, padapter, IPV4_SRC(ip), TCP_SRC(tcp), IPV4_DST(ip), TCP_DST(tcp)) == _TRUE) {
				if (GET_TCP_SYN(tcp) && GET_TCP_ACK(tcp)) {
					session_tracker_add_cmd(padapter, psta
						, IPV4_SRC(ip), TCP_SRC(tcp)
						, IPV4_SRC(ip), TCP_DST(tcp));
					if (DBG_SESSION_TRACKER)
						RTW_INFO(FUNC_ADPT_FMT" local:"IP_FMT":"PORT_FMT", remote:"IP_FMT":"PORT_FMT" SYN-ACK\n"
							, FUNC_ADPT_ARG(padapter)
							, IP_ARG(IPV4_SRC(ip)), PORT_ARG(TCP_SRC(tcp))
							, IP_ARG(IPV4_DST(ip)), PORT_ARG(TCP_DST(tcp)));
				}
				if (GET_TCP_FIN(tcp)) {
					session_tracker_del_cmd(padapter, psta
						, IPV4_SRC(ip), TCP_SRC(tcp)
						, IPV4_SRC(ip), TCP_DST(tcp));
					if (DBG_SESSION_TRACKER)
						RTW_INFO(FUNC_ADPT_FMT" local:"IP_FMT":"PORT_FMT", remote:"IP_FMT":"PORT_FMT" FIN\n"
							, FUNC_ADPT_ARG(padapter)
							, IP_ARG(IPV4_SRC(ip)), PORT_ARG(TCP_SRC(tcp))
							, IP_ARG(IPV4_DST(ip)), PORT_ARG(TCP_DST(tcp)));
				}
			}
		}

	}
	else if (0x888e == XF_ETHTYPE)
		parsing_eapol_packet(padapter, pktfile.cur_addr, psta, 1);
#if defined (DBG_ARP_DUMP) || defined (DBG_IP_R_MONITOR)
	else if (XF_ETHTYPE == ETH_P_ARP) {
		u8 arp[28] = {0};

		_rtw_pktfile_read(&pktfile, arp, 28);
		dump_arp_pkt(RTW_DBGDUMP, etherhdr.h_dest, etherhdr.h_source, arp, 1);
	}
#endif

	PHLTX_LOG;

	if ((XF_ETHTYPE == 0x888e) || (XF_DHCP == 1))
		rtw_mi_set_scan_deny(padapter, 3000);

	if (MLME_IS_STA(padapter) &&
		XF_ETHTYPE == ETH_P_ARP &&
		!IS_MCAST(XF_DA)) {
		rtw_mi_set_scan_deny(padapter, 1000);
		rtw_mi_scan_abort(padapter, _FALSE); /*rtw_scan_abort_no_wait*/
	}


	PHLTX_LOG;

	/* get ether_hdr_len */
	XF_HDRLEN = ETH_HLEN;/* (pattrib->ether_type == 0x8100) ? (14 + 4 ): 14; */ /* vlan tag */

	XF_WL_HDRLEN = WLAN_HDR_A3_LEN;
	XF_WL_TYPE = WIFI_DATA_TYPE;
	XF_WL_SUBTYPE = WIFI_DATA_TYPE;
	XF_WL_QOS = XF_STA->qos_option;
	XF_WL_TID = 0;

	XF_FRAG_LEN = pxmitpriv->frag_len;



	PHLTX_LOG;

	return SUCCESS;
}


static s32 update_xmitframe_qos(_adapter *padapter, struct xmit_frame *pxframe)
{

	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct qos_priv		*pqospriv = &pmlmepriv->qospriv;
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;

	if(!XF_WL_QOS)
		return SUCCESS;

	if (check_fwstate(pmlmepriv, WIFI_AP_STATE | WIFI_MESH_STATE
			| WIFI_ADHOC_STATE | WIFI_ADHOC_MASTER_STATE)
		) {
				set_qos_core(pxframe);
			#if 0//rtw_phl_tx def CONFIG_RTW_MESH
				if (MLME_IS_MESH(padapter))
					rtw_mesh_tx_set_whdr_mctrl_len(pattrib->mesh_frame_mode, pattrib);
			#endif
		} else {
#if 0// def CONFIG_TDLS
			if (pattrib->direct_link == _TRUE) {
				if (pattrib->qos_en)
					set_qos(pkt, pattrib);
			} else
#endif
			{
				if (pqospriv->qos_option) {
					set_qos_core(pxframe);

					if (pmlmepriv->acm_mask != 0)
						XF_WL_TID = qos_acm(pmlmepriv->acm_mask, XF_WL_TID);
				}
			}
		}

	return SUCCESS;
}

static s32 update_xmitframe_security(_adapter *padapter, struct xmit_frame *pxframe) //rtw_phl_tx todo
{
	sint res = _SUCCESS;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct security_priv *psecuritypriv = &padapter->securitypriv;
	sint bmcast = IS_MCAST(XF_RA);

#if 0
	_rtw_memset(pattrib->dot118021x_UncstKey.skey,  0, 16);
	_rtw_memset(pattrib->dot11tkiptxmickey.skey,  0, 16);
	pattrib->mac_id = psta->phl_sta->macid;
#endif

	if (XF_STA->ieee8021x_blocked == _TRUE) {

		XF_SEC_TYPE = 0;

		if ((XF_ETHTYPE != 0x888e) && (check_fwstate(pmlmepriv, WIFI_MP_STATE) == _FALSE)) {
#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s psta->ieee8021x_blocked == _TRUE,  pattrib->ether_type(%04x) != 0x888e\n", __FUNCTION__, XF_ETHTYPE);
#endif
			res = _FAIL;
			goto exit;
		}
	} else {
		GET_ENCRY_ALGO(psecuritypriv, XF_STA, XF_SEC_TYPE, bmcast);

#ifdef CONFIG_WAPI_SUPPORT
		if (XF_ETHTYPE == 0x88B4)
			XF_SEC_TYPE = _NO_PRIVACY_;
#endif

		switch (psecuritypriv->dot11AuthAlgrthm) {
		case dot11AuthAlgrthm_Open:
		case dot11AuthAlgrthm_Shared:
		case dot11AuthAlgrthm_Auto:
			XF_KEYIDX = (u8)psecuritypriv->dot11PrivacyKeyIndex;
			break;
		case dot11AuthAlgrthm_8021X:
			if (bmcast)
				XF_KEYIDX = (u8)psecuritypriv->dot118021XGrpKeyid;
			else
				XF_KEYIDX = 0;
			break;
		default:
			XF_KEYIDX = 0;
			break;
		}

		/* For WPS 1.0 WEP, driver should not encrypt EAPOL Packet for WPS handshake. */
		if (((XF_SEC_TYPE == _WEP40_) || (XF_SEC_TYPE == _WEP104_)) && (XF_ETHTYPE == 0x888e))
			XF_SEC_TYPE = _NO_PRIVACY_;

	}

#if 0 //def CONFIG_TDLS
	if (pattrib->direct_link == _TRUE) {
		if (XF_SEC_TYPE > 0)
			XF_SEC_TYPE = _AES_;
	}
#endif

	switch (XF_SEC_TYPE) {
	case _WEP40_:
	case _WEP104_:
		XF_IVLEN = 4;
		XF_ICVLEN = 4;
		UPDATE_WEP_PN(XF_PN, XF_STA->dot11txpn);
		WEP_IV(XF_IV, XF_PN, XF_KEYIDX);
		break;

	case _TKIP_:
		XF_IVLEN = 8;
		XF_ICVLEN = 4;

		if (psecuritypriv->busetkipkey == _FAIL) {
#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s psecuritypriv->busetkipkey(%d)==_FAIL drop packet\n", __FUNCTION__, psecuritypriv->busetkipkey);
#endif
			res = _FAIL;
			goto exit;
		}

		UPDATE_TKIP_CCMP_GCMP_PN(XF_PN, XF_STA->dot11txpn);
		TKIP_IV(XF_IV, XF_PN, XF_KEYIDX);

		//_rtw_memcpy(pattrib->dot11tkiptxmickey.skey, XF_STA->dot11tkiptxmickey.skey, 16);

		break;

	case _AES_:
		XF_IVLEN = 8;
		XF_ICVLEN = 8;
		UPDATE_TKIP_CCMP_GCMP_PN(XF_PN, XF_STA->dot11txpn);
		CCMP_IV(XF_IV, XF_PN, XF_KEYIDX);
		break;

	case _CCMP_256_:
		XF_IVLEN = 8;
		XF_ICVLEN = 16;
		UPDATE_TKIP_CCMP_GCMP_PN(XF_PN, XF_STA->dot11txpn);
		CCMP_IV(XF_IV, XF_PN, XF_KEYIDX);
		break;

	case _GCMP_:
	case _GCMP_256_:
		XF_IVLEN = 8;
		XF_ICVLEN = 16;
		UPDATE_TKIP_CCMP_GCMP_PN(XF_PN, XF_STA->dot11txpn);
		GCMP_IV(XF_IV, XF_PN, XF_KEYIDX);
		break;

#ifdef CONFIG_WAPI_SUPPORT
	case _SMS4_:
		XF_IVLEN = 18;
		XF_ICVLEN = 16;
		rtw_wapi_get_iv(padapter, XF_RA, XF_IV);
		break;
#endif
	default:
		XF_IVLEN = 0;
		XF_ICVLEN = 0;
		break;
	}

#if 0
	if (XF_SEC_TYPE > 0) {
		_rtw_memcpy(pattrib->dot118021x_UncstKey.skey
			, XF_STA->dot118021x_UncstKey.skey
			, (XF_SEC_TYPE & _SEC_TYPE_256_) ? 32 : 16);
	}
#endif

	if (XF_SEC_TYPE &&
	    ((padapter->securitypriv.sw_encrypt == _TRUE) || (psecuritypriv->hw_decrypted == _FALSE))) {
		XF_SWENC = _TRUE;
	} else {
		XF_SWENC = _FALSE;
	}

#if defined(CONFIG_CONCURRENT_MODE)
	//pattrib->bmc_camid = padapter->securitypriv.dot118021x_bmc_cam_id;
#endif

#ifdef CONFIG_WAPI_SUPPORT
	if (XF_SEC_TYPE == _SMS4_)
		XF_SWENC = _FALSE;
#endif

exit:
	return res;

}

static s32 update_xmitframe_hw(_adapter *padapter, struct xmit_frame *pxframe)
{
	XF_RTS = XF_STA->rtsen;
	XF_CTS2SELT = XF_STA->cts2self;
	XF_AMPDU_DENSITY = 0;
	return 0;
}

#if 0
static s32 rtw_core_update_txattrib(_adapter *padapter, struct xmit_frame *pxframe)
{
	uint i;
	struct pkt_file pktfile;
	struct sta_info *psta = NULL;
	struct ethhdr etherhdr;
	struct sk_buff *pkt = NULL;

	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct qos_priv		*pqospriv = &pmlmepriv->qospriv;
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;
	sint res = _SUCCESS;

#if 0//rtw_phl_tx todo  def CONFIG_LPS
	pkt_type = _rtw_lps_chk_packet_type(pattrib);

	if (pkt_type == LPS_PT_SP) {/*packet is as SPECIAL_PACKET*/
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_active);
		rtw_lps_ctrl_wk_cmd(padapter, LPS_CTRL_SPECIAL_PACKET, 0);
	} else if (pkt_type == LPS_PT_ICMP)
		rtw_lps_ctrl_wk_cmd(padapter, LPS_CTRL_LEAVE, 0);
#endif /* CONFIG_LPS */

#if 0//rtw_phl_tx todo def CONFIG_BEAMFORMING
	update_attrib_txbf_info(padapter, pattrib, psta);
#endif

#if 0
	/* TODO:_lock */
	if (update_attrib_sec_info(padapter, pattrib, psta, NON_EAPOL) == _FAIL) {
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_sec);
		res = _FAIL;
		goto exit;
	}
#endif

	update_attrib_phy_info(padapter, pattrib, psta);

	/* RTW_INFO("%s ==> mac_id(%d)\n",__FUNCTION__,pattrib->mac_id ); */
	/* TODO:_unlock */

#ifdef CONFIG_AUTO_AP_MODE
	if (psta->isrc && psta->pid > 0)
		pattrib->pctrl = _TRUE;
	else
#endif
		pattrib->pctrl = 0;

	pattrib->ack_policy = 0;

	if (bmcast)
		pattrib->rate = psta->init_rate;


#ifdef CONFIG_WMMPS_STA
	update_attrib_trigger_frame_info(padapter, pattrib);
#endif /* CONFIG_WMMPS_STA */

	/* pattrib->priority = 5; */ /* force to used VI queue, for testing */
	pattrib->hw_ssn_sel = pxmitpriv->hw_ssn_seq_no;

	pattrib->wdinfo_en = 1;/*FPGA_test YiWei need modify*/

	rtw_set_tx_chksum_offload(pkt, pattrib);

exit:
	return res;
}
#endif
#endif

static u8 rtw_chk_htc_en(_adapter *padapter, struct sta_info *psta)
{
#ifdef CONFIG_80211AX_HE
	if (psta->hepriv.he_option == _TRUE)
		return rtw_he_htc_en(padapter, psta);
#endif

	return 0;
}

#ifdef CONFIG_DBG_HNDSK_MGMT
static u8 rtw_get_dhcp_opt53_msg_type(unsigned char *ptr, int leftlen)
{
	unsigned char option = 0;
	unsigned char option_len = 0;
	u8 msg_type = 0;

	do {
		option = *ptr;
		option_len = *(ptr + 1);
		if(option == 0x35) {
			msg_type = *(ptr + 2);
			break;
		}

		ptr += (1 + 1 + option_len);
		leftlen -= (1 + 1 + option_len);
	} while((leftlen > 0));

	return msg_type;
}

static u8 rtw_process_dhcp_opt53(unsigned char *ptr, int len)
{
	unsigned char *dhcp = ptr;
	unsigned char op53 = 0;
	u32 dhcp_magic_coolie = 0x63825363;
	u32 *p1 = NULL;
	int i = 0;
	u8 ret_msgType = 0;

	for(i = 0; i < len ; i++) {
		p1 = (u32 *) (dhcp + i);
		if (*p1 == htonl(dhcp_magic_coolie)){
			dhcp = (unsigned char *)p1 + 4;
			len -= (i+4);
			break;
		}
	}

	if(len > 0) {
		op53 = rtw_get_dhcp_opt53_msg_type(dhcp, len);
		switch (op53) {
		case RTW_PKT_DHCP_DISCOVER:
			ret_msgType = HNDSK_DHCP_DISCOVER;
			break;
		case RTW_PKT_DHCP_OFFER:
			ret_msgType = HNDSK_DHCP_OFFER;
			break;
		case RTW_PKT_DHCP_REQUEST:
			ret_msgType = HNDSK_DHCP_REQUEST;
			break;
		case RTW_PKT_DHCP_DECLINE:
			ret_msgType = HNDSK_DHCP_DECLINE;
			break;
		case RTW_PKT_DHCP_ACK:
			ret_msgType = HNDSK_DHCP_ACK;
			break;
		case RTW_PKT_DHCP_NAK:
			ret_msgType = HNDSK_DHCP_NAK;
			break;
		case RTW_PKT_DHCP_RELEASE:
			ret_msgType = HNDSK_DHCP_RELEASE;
			break;
		case RTW_PKT_DHCP_INFORM:
			ret_msgType = HNDSK_DHCP_INFORM;
			break;
		default:
			RTW_ERR("Cant found DHCP option 53 or msg type not recognized\n");
			break;
		}
	}

	return ret_msgType;
}
#endif

static s32 update_attrib(_adapter *padapter, struct sk_buff *pkt, struct pkt_attrib *pattrib)
{
	uint i;
	struct pkt_file pktfile;
	struct sta_info *psta = NULL;
	struct ethhdr etherhdr;

	sint bmcast;
	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct mlme_priv		*pmlmepriv = &padapter->mlmepriv;
	struct qos_priv		*pqospriv = &pmlmepriv->qospriv;
	struct xmit_priv		*pxmitpriv = &padapter->xmitpriv;
	sint res = _SUCCESS;
	enum eap_type eapol_type = NON_EAPOL;
#ifdef CONFIG_LPS
	u8 pkt_type = 0;
#endif
	struct	registry_priv *pregistrypriv = &padapter->registrypriv;

	int idx;
	unsigned long timejiffies;
	int j;

	_rtw_memset(&etherhdr, 0, sizeof(etherhdr));
	DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib);

	_rtw_open_pktfile(pkt, &pktfile);
	i = _rtw_pktfile_read(&pktfile, (u8 *)&etherhdr, ETH_HLEN);

	pattrib->pktlen = pktfile.pkt_len;
#ifdef CONFIG_CORE_TXSC
	pattrib->frag_len = pxmitpriv->frag_len;
#endif

	pattrib->ether_type = ntohs(etherhdr.h_proto);

	if(pattrib->ether_type == ETH_P_8021Q)
	{
		u8 vlan_id[2] = {0}, eth_type[2] = {0};

		_rtw_pktfile_read(&pktfile, vlan_id, 2);
		pattrib->vlan_proto = ETH_P_8021Q;

		_rtw_pktfile_read(&pktfile, eth_type, 2);
		pattrib->ether_type = ntohs(*((u16*)&eth_type));
	}

	if (MLME_IS_MESH(padapter)) /* address resolve is done for mesh */
		goto get_sta_info;

	_rtw_memcpy(pattrib->dst, &etherhdr.h_dest, ETH_ALEN);
	_rtw_memcpy(pattrib->src, &etherhdr.h_source, ETH_ALEN);

	if ((check_fwstate(pmlmepriv, WIFI_ADHOC_STATE) == _TRUE) ||
	    (check_fwstate(pmlmepriv, WIFI_ADHOC_MASTER_STATE) == _TRUE)) {
		_rtw_memcpy(pattrib->ra, pattrib->dst, ETH_ALEN);
		_rtw_memcpy(pattrib->ta, adapter_mac_addr(padapter), ETH_ALEN);
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_adhoc);
	} else if (MLME_IS_STA(padapter)) {
#ifdef CONFIG_TDLS
		if (rtw_check_tdls_established(padapter, pattrib) == _TRUE)
			_rtw_memcpy(pattrib->ra, pattrib->dst, ETH_ALEN);	/* For TDLS direct link Tx, set ra to be same to dst */
		else
#endif
		{
			_rtw_memcpy(pattrib->ra, get_bssid(pmlmepriv), ETH_ALEN);
			#ifdef CONFIG_RTW_A4_STA
			if (IS_MCAST(pattrib->dst) && (MLME_IS_STA(padapter) && padapter->a4_enable))
				core_tx_a4_gptr_update(padapter, pattrib->src);
			#endif
		}
		_rtw_memcpy(pattrib->ta, adapter_mac_addr(padapter), ETH_ALEN);
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_sta);
	} else if (check_fwstate(pmlmepriv, WIFI_AP_STATE)) {
		_rtw_memcpy(pattrib->ra, pattrib->dst, ETH_ALEN);
		_rtw_memcpy(pattrib->ta, get_bssid(pmlmepriv), ETH_ALEN);
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_ap);
	} else
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_unknown);

get_sta_info:

#ifdef A4_TX_MCAST2UNI
	if (padapter->a4_enable) {
		if (_rtw_memcmp(&pkt->cb[_SKB_CB_MC2U_RA], "\x0\x0\x0\x0\x0\x0", ETH_ALEN) == _FALSE)
			_rtw_memcpy(pattrib->ra, &pkt->cb[_SKB_CB_MC2U_RA], ETH_ALEN);
	}
#endif

	bmcast = IS_MCAST(pattrib->ra);
	if (bmcast) {
		psta = rtw_get_bcmc_stainfo(padapter);
		if (psta == NULL) { /* if we cannot get psta => drop the pkt */
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_sta);
			#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s get sta_info fail, ra:" MAC_FMT"\n", __func__, MAC_ARG(pattrib->ra));
			#endif
			res = _FAIL;
			goto exit;
		}
	} else {
		psta = rtw_get_stainfo(pstapriv, pattrib->ra);

#ifdef CONFIG_RTW_A4_STA
		if (!psta) {
			psta = core_a4_get_fwd_sta(padapter, pattrib->dst);

			if (!psta || !psta->phl_sta)
				psta = NULL;
		}
		if(psta && (psta->flags & WLAN_STA_A4)) {
			_rtw_memcpy(pattrib->ra, psta->phl_sta->mac_addr, ETH_ALEN);
		}
#endif

		if(psta)
		{
			pattrib->mac_id = psta->phl_sta->macid;

			#ifdef CONFIG_WFA_OFDMA_Logo_Test_Statistic
			psta->core_xframe_total_cnt++;
			#endif
		}

		if (psta == NULL) { /* if we cannot get psta => drop the pkt */
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_ucast_sta);
			#ifdef DBG_TX_DROP_FRAME
			RTW_INFO("DBG_TX_DROP_FRAME %s get sta_info fail, ra:" MAC_FMT"\n", __func__, MAC_ARG(pattrib->ra));
			#endif
			res = _FAIL;
			goto exit;
		} else if (check_fwstate(pmlmepriv, WIFI_AP_STATE) == _TRUE && !(psta->state & WIFI_ASOC_STATE)) {
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_ucast_ap_link);
			res = _FAIL;
			goto exit;
		}
	}

	if (!(psta->state & WIFI_ASOC_STATE)) {
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_link);
		RTW_INFO("%s-"ADPT_FMT" psta("MAC_FMT")->state(0x%x) != WIFI_ASOC_STATE\n",
			__func__, ADPT_ARG(padapter), MAC_ARG(psta->phl_sta->mac_addr), psta->state);
		res = _FAIL;
		goto exit;
	}

#ifdef DEBUG_A4_TXFORCE
#ifndef DEBUG_A4_EAPOL
	if (ETH_P_EAPOL != pattrib->ether_type)
#endif
	if (psta)
		psta->flags |= WLAN_STA_A4;
#endif

	/* TODO: 802.1Q VLAN header */
	/* TODO: IPV6 */
	if (ETH_P_IP == pattrib->ether_type) {
		u8 ip[20] = {0};

		_rtw_pktfile_read(&pktfile, ip, 20);

		if (GET_IPV4_IHL(ip) * 4 > 20)
			_rtw_pktfile_read(&pktfile, NULL, 4*GET_IPV4_IHL(ip) - 20);

		pattrib->icmp_pkt = 0;
		pattrib->dhcp_pkt = 0;
		pattrib->hipriority_pkt = 0;

		if (GET_IPV4_PROTOCOL(ip) == 0x01) { /* ICMP */
			pattrib->icmp_pkt = 1;
			DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_icmp);

		} else if (GET_IPV4_PROTOCOL(ip) == 0x11) { /* UDP */
			u8 udp[24] = {0};

			_rtw_pktfile_read(&pktfile, udp, 24);

			if ((GET_UDP_SRC(udp) == 68 && GET_UDP_DST(udp) == 67)
				|| (GET_UDP_SRC(udp) == 67 && GET_UDP_DST(udp) == 68)
			) {
				/* 67 : UDP BOOTP server, 68 : UDP BOOTP client */
				if (pattrib->pktlen > 282) { /* MINIMUM_DHCP_PACKET_SIZE */
					pattrib->dhcp_pkt = 1;
#ifdef CONFIG_DBG_HNDSK_MGMT
					pattrib->hndsk_type = rtw_process_dhcp_opt53(pkt->data, pkt->len);
					padapter->tx_logs.core_hndsk_tx_cnt[pattrib->hndsk_type]++;
#endif
					DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_dhcp);
					if (0)
						RTW_INFO("send DHCP packet\n");
#ifdef CONFIG_RECORD_CLIENT_HOST
					{
						u8 client_host_ip[4];
						_rtw_pktfile_read(&pktfile, client_host_ip, 4);
						_rtw_memcpy(psta->client_host_ip, client_host_ip, 4);
					}
#endif
				}
			}

			/* WaveAgent packet, increase priority so that the system can read data in time */
			if (((GET_UDP_SIG1(udp) == 0xcc) || (GET_UDP_SIG1(udp) == 0xdd)) &&
				(GET_UDP_SIG2(udp) == 0xe2)) {
				pattrib->hipriority_pkt = 1;
			}

		} else if (GET_IPV4_PROTOCOL(ip) == 0x06 /* TCP */
			&& rtw_st_ctl_chk_reg_s_proto(&psta->st_ctl, 0x06) == _TRUE
		) {
			u8 tcp[20];

			_rtw_pktfile_read(&pktfile, tcp, 20);

			if (rtw_st_ctl_chk_reg_rule(&psta->st_ctl, padapter, IPV4_SRC(ip), TCP_SRC(tcp), IPV4_DST(ip), TCP_DST(tcp)) == _TRUE) {
				if (GET_TCP_SYN(tcp) && GET_TCP_ACK(tcp)) {
					session_tracker_add_cmd(padapter, psta
						, IPV4_SRC(ip), TCP_SRC(tcp)
						, IPV4_SRC(ip), TCP_DST(tcp));
					if (DBG_SESSION_TRACKER)
						RTW_INFO(FUNC_ADPT_FMT" local:"IP_FMT":"PORT_FMT", remote:"IP_FMT":"PORT_FMT" SYN-ACK\n"
							, FUNC_ADPT_ARG(padapter)
							, IP_ARG(IPV4_SRC(ip)), PORT_ARG(TCP_SRC(tcp))
							, IP_ARG(IPV4_DST(ip)), PORT_ARG(TCP_DST(tcp)));
				}
				if (GET_TCP_FIN(tcp)) {
					session_tracker_del_cmd(padapter, psta
						, IPV4_SRC(ip), TCP_SRC(tcp)
						, IPV4_SRC(ip), TCP_DST(tcp));
					if (DBG_SESSION_TRACKER)
						RTW_INFO(FUNC_ADPT_FMT" local:"IP_FMT":"PORT_FMT", remote:"IP_FMT":"PORT_FMT" FIN\n"
							, FUNC_ADPT_ARG(padapter)
							, IP_ARG(IPV4_SRC(ip)), PORT_ARG(TCP_SRC(tcp))
							, IP_ARG(IPV4_DST(ip)), PORT_ARG(TCP_DST(tcp)));
				}
			}
		}

	}
	else if (ETH_P_IPV6 == pattrib->ether_type) {
		u8 ipv6[40] = {0};
		u8 next_type = 0;

		pattrib->icmpv6_pkt = 0;
		_rtw_pktfile_read(&pktfile, ipv6, 40);
		next_type = GET_IPV6_PROTOCOL(ipv6);
		if (next_type == 0x00) { /* IPV6 Hop-by-Hop option */
			u8 option[8] = {0};
			_rtw_pktfile_read(&pktfile, option, 8);
			if(((GET_IPV6_opt_hdrlen(option) + 1) * 8) > 8)
				_rtw_pktfile_read(&pktfile, NULL, ((GET_IPV6_opt_hdrlen(option) + 1) * 8) - 8);
			next_type = GET_IPV6_opt_nexttype(option);
		}

		if(next_type == 0x3a) { /* icmpv6 */
			pattrib->icmpv6_pkt = 1;
		}
	}
	else if (0x888e == pattrib->ether_type) {
		eapol_type = parsing_eapol_packet(padapter, pktfile.cur_addr, psta, 1);
#ifdef CONFIG_DBG_HNDSK_MGMT
		if (eapol_type == EAPOL_1_4) {
			pattrib->hndsk_type = HNDSK_EAPOL_4_1_PKT;
			padapter->tx_logs.core_hndsk_tx_cnt[HNDSK_EAPOL_4_1_PKT]++;
		} else if (eapol_type == EAPOL_3_4) {
			pattrib->hndsk_type = HNDSK_EAPOL_4_3_PKT;
			padapter->tx_logs.core_hndsk_tx_cnt[HNDSK_EAPOL_4_3_PKT]++;
		}
#endif
	}
#if defined (DBG_ARP_DUMP) || defined (DBG_IP_R_MONITOR)
	else if (pattrib->ether_type == ETH_P_ARP) {
		u8 arp[28] = {0};

		_rtw_pktfile_read(&pktfile, arp, 28);
		dump_arp_pkt(RTW_DBGDUMP, etherhdr.h_dest, etherhdr.h_source, arp, 1);
	}
#endif
#if 0
	if ((pattrib->ether_type == 0x888e) || (pattrib->dhcp_pkt == 1))
		rtw_mi_set_scan_deny(padapter, 3000);

	if (MLME_IS_STA(padapter) &&
		pattrib->ether_type == ETH_P_ARP &&
		!IS_MCAST(pattrib->dst)) {
		rtw_mi_set_scan_deny(padapter, 1000);
		rtw_mi_scan_abort(padapter, _FALSE); /*rtw_scan_abort_no_wait*/
	}
#else
//WNC, Don't deny scan when user performs site survey from GUI
	if (adapter_to_dvobj(padapter)->SS_triggered_from_gui == _FALSE) {
		if ((pattrib->ether_type == 0x888e) || (pattrib->dhcp_pkt == 1)) {
			//printk("%s,%d %s\n", __func__, __LINE__, padapter->pnetdev->name);
			rtw_mi_set_scan_deny(padapter, 3000);
		}
		if (MLME_IS_STA(padapter) &&
			(pattrib->ether_type == ETH_P_ARP) &&
			!IS_MCAST(pattrib->dst)) {
			//printk("%s,%d %s\n", __func__, __LINE__, padapter->pnetdev->name);
			rtw_mi_set_scan_deny(padapter, 1000);
			rtw_mi_scan_abort(padapter, _FALSE); /*rtw_scan_abort_no_wait*/
		}
	}
#endif
#ifdef CONFIG_LPS
	pkt_type = _rtw_lps_chk_packet_type(pattrib);

	if (pkt_type == LPS_PT_SP) {/*packet is as SPECIAL_PACKET*/
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_active);
		rtw_lps_ctrl_wk_cmd(padapter, LPS_CTRL_SPECIAL_PACKET, 0);
	} else if (pkt_type == LPS_PT_ICMP)
		rtw_lps_ctrl_wk_cmd(padapter, LPS_CTRL_LEAVE, 0);
#endif /* CONFIG_LPS */

#ifdef CONFIG_BEAMFORMING
	update_attrib_txbf_info(padapter, pattrib, psta);
#endif

	/* TODO:_lock */
	if (update_attrib_sec_info(padapter, pattrib, psta, eapol_type) == _FAIL) {
		DBG_COUNTER(padapter->tx_logs.core_tx_upd_attrib_err_sec);
		res = _FAIL;
		goto exit;
	}

	/* get ether_hdr_len */
	pattrib->pkt_hdrlen = ETH_HLEN;/* (pattrib->ether_type == 0x8100) ? (14 + 4 ): 14; */ /* vlan tag */

	pattrib->hdrlen = WLAN_HDR_A3_LEN;
	pattrib->type = WIFI_DATA_TYPE;
	pattrib->subtype = WIFI_DATA;
	/* do not set qos subtype when DHCP/ARP */
	if (IS_MCAST(pattrib->ra))
        pattrib->qos_en = 0;
	else
		pattrib->qos_en = psta->qos_option;
	pattrib->priority = 0;

	if (check_fwstate(pmlmepriv, WIFI_AP_STATE | WIFI_MESH_STATE
		| WIFI_ADHOC_STATE | WIFI_ADHOC_MASTER_STATE)
	) {
		if (pattrib->qos_en) {
			set_qos(padapter, pkt, pattrib);
			#ifdef CONFIG_RTW_MESH
			if (MLME_IS_MESH(padapter))
				rtw_mesh_tx_set_whdr_mctrl_len(pattrib->mesh_frame_mode, pattrib);
			#endif
		}
	} else {
#ifdef CONFIG_TDLS
		if (pattrib->direct_link == _TRUE) {
			if (pattrib->qos_en)
				set_qos(padapter, pkt, pattrib);
		} else
#endif
		{
			if (pqospriv->qos_option && pattrib->qos_en) {
				set_qos(padapter, pkt, pattrib);

				if (pmlmepriv->acm_mask != 0)
					pattrib->priority = qos_acm(pmlmepriv->acm_mask, pattrib->priority);
			}
		}
	}

	pattrib->order = rtw_chk_htc_en(padapter, psta);
	if (pattrib->order) {
		if (pattrib->qos_en)
			pattrib->hdrlen = WLAN_HDR_A3_QOS_HTC_LEN;
		else
			pattrib->hdrlen = WLAN_HDR_A3_HTC_LEN;
	}

#ifdef CONFIG_RTW_A4_STA
	if (WLAN_STA_A4 & psta->flags) {
#ifndef DEBUG_A4_EAPOL
		if (ETH_P_EAPOL != pattrib->ether_type
#ifdef RTW_MAP_BACKHAUL_A4_EAPOL
			|| ((MAP_MODE_BACKHAL_AP & padapter->multi_ap_mode) && (psta->flags & WLAN_STA_MULTI_AP_BACKHAUL_STA))
			|| ((MAP_MODE_BACKHAL_STA & padapter->multi_ap_mode) && (psta->flags & WLAN_STA_MULTI_AP_BACKHAUL_BSS))
#endif
			)
#endif
			pattrib->hdrlen += ETH_ALEN;
	}
#endif

	update_attrib_phy_info(padapter, pattrib, psta);
	if(pattrib->qos_en == 0)
		pattrib->ampdu_en = _FALSE;

	/* RTW_INFO("%s ==> mac_id(%d)\n",__FUNCTION__,pattrib->mac_id ); */

	pattrib->psta = psta;
	/* TODO:_unlock */

#ifdef CONFIG_AUTO_AP_MODE
	if (psta->isrc && psta->pid > 0)
		pattrib->pctrl = _TRUE;
	else
#endif
		pattrib->pctrl = 0;

	pattrib->ack_policy = 0;

	if (psta->state & WIFI_SLEEP_STATE) {
		struct sta_xmit_priv *pstaxmitpriv = &psta->sta_xmitpriv;
//#ifdef CONFIG_ONE_TXQ
//		u8 q_idx = pkt->cb[_SKB_CB_QNUM];
//#else
		u8 q_idx = rtw_get_txq_idx(pattrib->priority);
//#endif
		if (psta->uapsd_bitmap & BIT(q_idx)) {
			if (pstaxmitpriv->tx_pending_bitmap & psta->uapsd_bitmap)
				pattrib->mdata = 1;
			else
				pattrib->eosp = 1;
		} else {
			if (pstaxmitpriv->tx_pending_bitmap & ~ psta->uapsd_bitmap)
				pattrib->mdata = 1;
		}
	}

	if (bmcast)
		pattrib->rate = psta->init_rate;

#ifdef CONFIG_ETHER_PKT_AGG
	if (pkt->cb[_SKB_CB_ETH_AGG] == _PKT_TYPE_AGG_MULTI_PKT)
		pattrib->isAggPkt =  _AGG_TYPE_MULTI_PKT;
	else if (pkt->cb[_SKB_CB_ETH_AGG] == _PKT_TYPE_AGG_PKTLIST)
		pattrib->isAggPkt =  _AGG_TYPE_PKTLIST;
	else
		pattrib->isAggPkt =  0;

	if (pattrib->isAggPkt) {
		pattrib->amsdu = 1;
		pattrib->ether_type = ntohs(*(u16 *)(pkt->data + 20)); // 14(DA+SA+LEN) + 6 (LLC)
	}
#endif /* CONFIG_ETHER_PKT_AGG */


#ifdef CONFIG_WMMPS_STA
	update_attrib_trigger_frame_info(padapter, pattrib);
#endif /* CONFIG_WMMPS_STA */

	/* pattrib->priority = 5; */ /* force to used VI queue, for testing */
#ifdef CONFIG_RTW_SSID_PRIORITY
	if(pregistrypriv->wifi_mib.manual_priority != 0xff)
		pattrib->priority = pregistrypriv->wifi_mib.manual_priority;
#endif

	pattrib->hw_ssn_sel = pxmitpriv->hw_ssn_seq_no;

	pattrib->wdinfo_en = 1;/*FPGA_test YiWei need modify*/

	rtw_set_tx_chksum_offload(pkt, pattrib);

exit:


	return res;
}

static s32 xmitframe_addmic(_adapter *padapter, struct xmit_frame *pxmitframe)
{
	sint			curfragnum, length;
	u8	*pframe, *payload, mic[8];
	struct	mic_data		micdata;
	/* struct	sta_info		*stainfo; */
	struct	pkt_attrib	*pattrib = &pxmitframe->attrib;
	struct	security_priv	*psecuritypriv = &padapter->securitypriv;
	struct	xmit_priv		*pxmitpriv = &padapter->xmitpriv;
	u8 priority[4] = {0x0, 0x0, 0x0, 0x0};
	u8 hw_hdr_offset = 0;
	sint bmcst = IS_MCAST(pattrib->ra);

	/*
		if(pattrib->psta)
		{
			stainfo = pattrib->psta;
		}
		else
		{
			RTW_INFO("%s, call rtw_get_stainfo()\n", __func__);
			stainfo=rtw_get_stainfo(&padapter->stapriv ,&pattrib->ra[0]);
		}

		if(stainfo==NULL)
		{
			RTW_INFO("%s, psta==NUL\n", __func__);
			return _FAIL;
		}

		if(!(stainfo->state &WIFI_ASOC_STATE))
		{
			RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, stainfo->state);
			return _FAIL;
		}
	*/


#ifdef CONFIG_USB_TX_AGGREGATION
	hw_hdr_offset = TXDESC_SIZE + (pxmitframe->pkt_offset * PACKET_OFFSET_SZ);;
#else
#ifdef CONFIG_TX_EARLY_MODE
	hw_hdr_offset = TXDESC_OFFSET + EARLY_MODE_INFO_SIZE;
#else
	hw_hdr_offset = TXDESC_OFFSET;
#endif
#endif

	if (pattrib->encrypt == _TKIP_) { /* if(psecuritypriv->dot11PrivacyAlgrthm==_TKIP_PRIVACY_) */
		/* encode mic code */
		/* if(stainfo!= NULL) */
		{
			u8 null_key[16] = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};

			pframe = pxmitframe->buf_addr + hw_hdr_offset;

			if (bmcst) {
				if (_rtw_memcmp(psecuritypriv->dot118021XGrptxmickey[psecuritypriv->dot118021XGrpKeyid].skey, null_key, 16) == _TRUE) {
					/* DbgPrint("\nxmitframe_addmic:stainfo->dot11tkiptxmickey==0\n"); */
					/* rtw_msleep_os(10); */
					return _FAIL;
				}
				/* start to calculate the mic code */
				rtw_secmicsetkey(&micdata, psecuritypriv->dot118021XGrptxmickey[psecuritypriv->dot118021XGrpKeyid].skey);
			} else {
				if (_rtw_memcmp(&pattrib->dot11tkiptxmickey.skey[0], null_key, 16) == _TRUE) {
					/* DbgPrint("\nxmitframe_addmic:stainfo->dot11tkiptxmickey==0\n"); */
					/* rtw_msleep_os(10); */
					return _FAIL;
				}
				/* start to calculate the mic code */
				rtw_secmicsetkey(&micdata, &pattrib->dot11tkiptxmickey.skey[0]);
			}

			if (pframe[1] & 1) { /* ToDS==1 */
				rtw_secmicappend(&micdata, &pframe[16], 6);  /* DA */
				if (pframe[1] & 2) /* From Ds==1 */
					rtw_secmicappend(&micdata, &pframe[24], 6);
				else
					rtw_secmicappend(&micdata, &pframe[10], 6);
			} else {	/* ToDS==0 */
				rtw_secmicappend(&micdata, &pframe[4], 6);   /* DA */
				if (pframe[1] & 2) /* From Ds==1 */
					rtw_secmicappend(&micdata, &pframe[16], 6);
				else
					rtw_secmicappend(&micdata, &pframe[10], 6);

			}

			if (pattrib->qos_en)
				priority[0] = (u8)pxmitframe->attrib.priority;


			rtw_secmicappend(&micdata, &priority[0], 4);

			payload = pframe;

			for (curfragnum = 0; curfragnum < pattrib->nr_frags; curfragnum++) {
				payload = (u8 *)RND4((SIZE_PTR)(payload));

				payload = payload + pattrib->hdrlen + pattrib->iv_len;
				if ((curfragnum + 1) == pattrib->nr_frags) {
					length = pattrib->last_txcmdsz - pattrib->hdrlen - pattrib->iv_len - ((pattrib->bswenc) ? pattrib->icv_len : 0);
					rtw_secmicappend(&micdata, payload, length);
					payload = payload + length;
				} else {
					length = pxmitpriv->frag_len - pattrib->hdrlen - pattrib->iv_len - ((pattrib->bswenc) ? pattrib->icv_len : 0);
					rtw_secmicappend(&micdata, payload, length);
					payload = payload + length + pattrib->icv_len;
				}
			}
			rtw_secgetmic(&micdata, &(mic[0]));
			/* add mic code  and add the mic code length in last_txcmdsz */

			_rtw_memcpy(payload, &(mic[0]), 8);
			pattrib->last_txcmdsz += 8;

			payload = payload - pattrib->last_txcmdsz + 8;
		}
	}


	return _SUCCESS;
}

/*#define DBG_TX_SW_ENCRYPTOR*/

static s32 xmitframe_swencrypt(_adapter *padapter, struct xmit_frame *pxmitframe)
{
	struct pkt_attrib *pattrib = &pxmitframe->attrib;


	if (!pattrib->bswenc)
		return _SUCCESS;

#ifdef DBG_TX_SW_ENCRYPTOR
	RTW_INFO(ADPT_FMT" - sec_type:%s DO SW encryption\n",
		ADPT_ARG(padapter), security_type_str(pattrib->encrypt));
#endif

	switch (pattrib->encrypt) {
	case _WEP40_:
	case _WEP104_:
		rtw_wep_encrypt(padapter, (u8 *)pxmitframe);
		break;
	case _TKIP_:
		rtw_tkip_encrypt(padapter, (u8 *)pxmitframe);
		break;
	case _AES_:
	case _CCMP_256_:
		rtw_aes_encrypt(padapter, (u8 *)pxmitframe);
		break;
	case _GCMP_:
	case _GCMP_256_:
		rtw_gcmp_encrypt(padapter, (u8 *)pxmitframe);
		break;
#if defined(CONFIG_WAPI_SUPPORT) || defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
	case _SMS4_:
		rtw_sms4_encrypt(padapter, (u8 *)pxmitframe);
		break;
	case _GCM_SM4_:
		rtw_gcm_sm4_encrypt(padapter, (u8 *)pxmitframe);
		break;
#endif
	default:
		break;
	}

	return _SUCCESS;
}

#if 0 //RTW_PHL_TX: mark un-finished codes for reading
static s32 rtw_core_xmitframe_addmic(_adapter *padapter, struct xmit_frame *pxframe)
{
	sint curfragnum, payload_length;
	u8	*pwlhdr, *payload, mic[8];
	struct	mic_data		micdata;
	/* struct	sta_info		*stainfo; */
	struct	security_priv	*psecuritypriv = &padapter->securitypriv;
	struct	xmit_priv		*pxmitpriv = &padapter->xmitpriv;
	u8 priority[4] = {0x0, 0x0, 0x0, 0x0};
	u8 hw_hdr_offset = 0;
	sint bmcst = IS_MCAST(XF_RA);

	if (XF_SEC_TYPE == _TKIP_) { /* if(psecuritypriv->dot11PrivacyAlgrthm==_TKIP_PRIVACY_) */
		/* encode mic code */
		/* if(stainfo!= NULL) */
		{
			u8 null_key[16] = {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};

			pwlhdr = XF_WLHDR[0];
			payload = XF_SKB->data + XF_HDRLEN;
			payload_length = XF_SKB->len - XF_HDRLEN;

			if (bmcst) {
				if (_rtw_memcmp(psecuritypriv->dot118021XGrptxmickey[psecuritypriv->dot118021XGrpKeyid].skey, null_key, 16) == _TRUE) {
					/* DbgPrint("\nxmitframe_addmic:stainfo->dot11tkiptxmickey==0\n"); */
					/* rtw_msleep_os(10); */
					return _FAIL;
				}
				/* start to calculate the mic code */
				rtw_secmicsetkey(&micdata, psecuritypriv->dot118021XGrptxmickey[psecuritypriv->dot118021XGrpKeyid].skey);
			} else {
				if (_rtw_memcmp(&XF_STA->dot11tkiptxmickey.skey[0], null_key, 16) == _TRUE) {
					/* DbgPrint("\nxmitframe_addmic:stainfo->dot11tkiptxmickey==0\n"); */
					/* rtw_msleep_os(10); */
					return _FAIL;
				}
				/* start to calculate the mic code */
				rtw_secmicsetkey(&micdata, &XF_STA->dot11tkiptxmickey.skey[0]);
			}

			if (pwlhdr[1] & 1) { /* ToDS==1 */
				rtw_secmicappend(&micdata, &pwlhdr[16], 6);  /* DA */
				if (pwlhdr[1] & 2) /* From Ds==1 */
					rtw_secmicappend(&micdata, &pwlhdr[24], 6);
				else
					rtw_secmicappend(&micdata, &pwlhdr[10], 6);
			} else {	/* ToDS==0 */
				rtw_secmicappend(&micdata, &pwlhdr[4], 6);   /* DA */
				if (pwlhdr[1] & 2) /* From Ds==1 */
					rtw_secmicappend(&micdata, &pwlhdr[16], 6);
				else
					rtw_secmicappend(&micdata, &pwlhdr[10], 6);

			}

			if (XF_WL_QOS)
				priority[0] = (u8)XF_WL_QOS;

			rtw_secmicappend(&micdata, &priority[0], 4);

			payload = (u8 *)RND4((SIZE_PTR)(payload));
			rtw_secmicappend(&micdata, payload, payload_length);

			rtw_secgetmic(&micdata, &(mic[0]));
			/* add mic code  and add the mic code length in last_txcmdsz */

			_rtw_memcpy(XF_WLTAIL[0]+XF_ICVLEN, &(mic[0]), 8);
		}
	}

	return _SUCCESS;
}

/*#define DBG_TX_SW_ENCRYPTOR*/

static s32 rtw_core_xmitframe_swencrypt(_adapter *padapter, struct xmit_frame *pxframe)
{
	if (XF_SWENC) {
#ifdef DBG_TX_SW_ENCRYPTOR
		RTW_INFO(ADPT_FMT" - sec_type:%s DO SW encryption\n",
			ADPT_ARG(padapter), security_type_str(XF_SEC_TYPE));
#endif

		switch (XF_SEC_TYPE) {
		case _WEP40_:
		case _WEP104_:
			//rtw_wep_encrypt(padapter, (u8 *)pxmitframe);
			break;
		case _TKIP_:
			//rtw_tkip_encrypt(padapter, (u8 *)pxmitframe);
			break;
		case _AES_:
		case _CCMP_256_:
			rtw_core_aes_encrypt(padapter, (u8 *)pxframe);
			break;
		case _GCMP_:
		case _GCMP_256_:
			//rtw_gcmp_encrypt(padapter, (u8 *)pxmitframe);
			break;
#ifdef CONFIG_WAPI_SUPPORT
		case _SMS4_:
			//rtw_sms4_encrypt(padapter, (u8 *)pxmitframe);
#endif
		default:
			break;
		}

	}
	return _SUCCESS;
}


s32 rtw_core_make_wlanhdr(_adapter *padapter , u8 *hdr,  struct xmit_frame *pxframe)
{
	u16 *qc;

	struct rtw_ieee80211_hdr *pwlanhdr = (struct rtw_ieee80211_hdr *)hdr;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct qos_priv *pqospriv = &pmlmepriv->qospriv;
	u8 qos_option = _FALSE;
	sint res = _SUCCESS;
	u16 *fctrl = &pwlanhdr->frame_ctl;

	_rtw_memset(hdr, 0, WLANHDR_OFFSET);

	set_frame_sub_type(fctrl, XF_WL_SUBTYPE);

	if (XF_WL_SUBTYPE & WIFI_DATA_TYPE) {
		if ((MLME_IS_STA(padapter)) {
#ifdef CONFIG_TDLS
			if (pattrib->direct_link == _TRUE) {
				/* TDLS data transfer, ToDS=0, FrDs=0 */
				_rtw_memcpy(pwlanhdr->addr1, XF_DA, ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr2, XF_SA, ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr3, get_bssid(pmlmepriv), ETH_ALEN);

				if (XF_WL_QOS)
					qos_option = _TRUE;
			} else
#endif /* CONFIG_TDLS */
			{
				/* to_ds = 1, fr_ds = 0; */
				/* 1.Data transfer to AP */
				/* 2.Arp pkt will relayed by AP */
				SetToDs(fctrl);
				_rtw_memcpy(pwlanhdr->addr1, get_bssid(pmlmepriv), ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr2, XF_TA, ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr3, XF_DA, ETH_ALEN);

				if (pqospriv->qos_option)
					qos_option = _TRUE;
			}
		} else if ((check_fwstate(pmlmepriv,  WIFI_AP_STATE) == _TRUE)) {
			/* to_ds = 0, fr_ds = 1; */
			SetFrDs(fctrl);
			_rtw_memcpy(pwlanhdr->addr1, XF_DA, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, get_bssid(pmlmepriv), ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, XF_SA, ETH_ALEN);

			if (XF_WL_QOS)
				qos_option = _TRUE;
		} else if ((check_fwstate(pmlmepriv, WIFI_ADHOC_STATE) == _TRUE) ||
			(check_fwstate(pmlmepriv, WIFI_ADHOC_MASTER_STATE) == _TRUE)) {
			_rtw_memcpy(pwlanhdr->addr1, XF_DA, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, XF_TA, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, get_bssid(pmlmepriv), ETH_ALEN);

			if (XF_WL_QOS)
				qos_option = _TRUE;
#ifdef CONFIG_RTW_MESH
		} else if (MLME_IS_STA(padapter)) {
			rtw_mesh_tx_build_whdr(padapter, pattrib, fctrl, pwlanhdr);
			if (XF_WL_QOS)
				qos_option = _TRUE;
			else {
				RTW_WARN("[%s] !qos_en in Mesh\n", __FUNCTION__);
				res = _FAIL;
				goto exit;
			}
#endif
		} else {
			res = _FAIL;
			goto exit;
		}

		if (XF_WL_MDATA)
			SetMData(fctrl);

		if (XF_SEC_TYPE)
			SetPrivacy(fctrl);

		if (qos_option) {
			qc = (unsigned short *)(hdr + XF_WL_HDRLEN - 2);

			if (XF_WL_TID)
				SetPriority(qc, XF_WL_TID);

			SetEOSP(qc, XF_WL_EOSP);

			SetAckpolicy(qc, XF_WL_ACK_POLICY);

			if(XF_WL_AMSDU)
				SetAMsdu(qc, XF_WL_AMSDU);
#ifdef CONFIG_RTW_MESH
			if (MLME_IS_MESH(padapter)) {
				/* active: don't care, light sleep: 0, deep sleep: 1*/
				set_mps_lv(qc, 0); //TBD

				/* TBD: temporary set (rspi, eosp) = (0, 1) which means End MPSP */
				set_rspi(qc, 0);
				SetEOSP(qc, 1);

				set_mctrl_present(qc, 1);
			}
#endif
		}

		/* TODO: fill HT Control Field */

		/* Update Seq Num will be handled by f/w */
		{
			struct sta_info *psta;
			psta = XF_STA;

			if (psta == NULL) {
				RTW_INFO("%s, psta==NUL\n", __func__);
				return _FAIL;
			}

			if (!(psta->state & WIFI_ASOC_STATE)) {
				RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
				return _FAIL;
			}

			if (psta) {
				psta->sta_xmitpriv.txseq_tid[XF_WL_TID]++;
				psta->sta_xmitpriv.txseq_tid[XF_WL_TID] &= 0xFFF;
				XF_WL_SEQ = psta->sta_xmitpriv.txseq_tid[XF_WL_TID];

				SetSeqNum(hdr, XF_WL_SEQ);

#ifdef CONFIG_80211N_HT
#if 0 /* move into update_attrib_phy_info(). */
				/* check if enable ampdu */
				if (pattrib->ht_en && psta->htpriv.ampdu_enable) {
					if (psta->htpriv.agg_enable_bitmap & BIT(pattrib->priority))
						pattrib->ampdu_en = _TRUE;
				}
#endif
				/* re-check if enable ampdu by BA_starting_seqctrl */
				if (XF_WL_AMPDU == _TRUE) {
					u16 tx_seq;

					tx_seq = psta->BA_starting_seqctrl[XF_WL_TID & 0x0f];

					/* check BA_starting_seqctrl */
					if (SN_LESS(XF_WL_SEQ, tx_seq)) {
						/* RTW_INFO("tx ampdu seqnum(%d) < tx_seq(%d)\n", pattrib->seqnum, tx_seq); */
						XF_WL_AMPDU = _FALSE;/* AGG BK */
					} else if (SN_EQUAL(XF_WL_SEQ, tx_seq)) {
						psta->BA_starting_seqctrl[XF_WL_TID & 0x0f] = (tx_seq + 1) & 0xfff;

						XF_WL_AMPDU = _TRUE;/* AGG EN */
					} else {
						/* RTW_INFO("tx ampdu over run\n"); */
						psta->BA_starting_seqctrl[XF_WL_TID & 0x0f] = (XF_WL_SEQ + 1) & 0xfff;
						XF_WL_AMPDU = _TRUE;/* AGG EN */
					}

				}
#endif /* CONFIG_80211N_HT */
			}
		}

	} else {

	}

exit:


	return res;
}





#endif

static void rtw_fill_htc_in_wlanhdr(_adapter *padapter, struct pkt_attrib *pattrib, u32 *phtc_buf)
{
#ifdef CONFIG_80211AX_HE
	rtw_he_fill_htc(padapter, pattrib, phtc_buf);
#endif
}

s32 rtw_make_wlanhdr(_adapter *padapter , u8 *hdr, struct pkt_attrib *pattrib)
{
	u16 *qc;
	u32 *htc = NULL;

	struct rtw_ieee80211_hdr *pwlanhdr = (struct rtw_ieee80211_hdr *)hdr;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct qos_priv *pqospriv = &pmlmepriv->qospriv;
	u8 qos_option = _FALSE, htc_option = _FALSE;
	sint res = _SUCCESS;
	u16 *fctrl = &pwlanhdr->frame_ctl;

	/* struct sta_info *psta; */

	/* sint bmcst = IS_MCAST(pattrib->ra); */


	/*
		psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
		if(pattrib->psta != psta)
		{
			RTW_INFO("%s, pattrib->psta(%p) != psta(%p)\n", __func__, pattrib->psta, psta);
			return;
		}

		if(psta==NULL)
		{
			RTW_INFO("%s, psta==NUL\n", __func__);
			return _FAIL;
		}

		if(!(psta->state &WIFI_ASOC_STATE))
		{
			RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
			return _FAIL;
		}
	*/

#ifdef RTW_PHL_TX
	_rtw_memset(hdr, 0, pattrib->hdrlen);
#else
	_rtw_memset(hdr, 0, WLANHDR_OFFSET);
#endif

	set_frame_sub_type(fctrl, pattrib->subtype);

	if (pattrib->subtype & WIFI_DATA_TYPE) {
#ifdef CONFIG_RTW_A4_STA
		if (WLAN_STA_A4 & pattrib->psta->flags
#ifndef DEBUG_A4_EAPOL
			&& (ETH_P_EAPOL != pattrib->ether_type
#ifdef RTW_MAP_BACKHAUL_A4_EAPOL
				|| ((MAP_MODE_BACKHAL_AP & padapter->multi_ap_mode) && (pattrib->psta->flags & WLAN_STA_MULTI_AP_BACKHAUL_STA))
				|| ((MAP_MODE_BACKHAL_STA & padapter->multi_ap_mode) && (pattrib->psta->flags & WLAN_STA_MULTI_AP_BACKHAUL_BSS))
#endif
				)
#endif
			) {

			SetToDs(fctrl);
			SetFrDs(fctrl);

			_rtw_memcpy(pwlanhdr->addr1, pattrib->ra, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, pattrib->ta, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, pattrib->dst, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr4, pattrib->src, ETH_ALEN);

			if (pattrib->qos_en)
				qos_option = _TRUE;

			padapter->cnt_a4_tx++;
		} else
#endif
		if (MLME_IS_STA(padapter)) {
#ifdef CONFIG_TDLS
			if (pattrib->direct_link == _TRUE) {
				/* TDLS data transfer, ToDS=0, FrDs=0 */
				_rtw_memcpy(pwlanhdr->addr1, pattrib->dst, ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr2, pattrib->src, ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr3, get_bssid(pmlmepriv), ETH_ALEN);

				if (pattrib->qos_en)
					qos_option = _TRUE;
			} else
#endif /* CONFIG_TDLS */
			{
				/* to_ds = 1, fr_ds = 0; */
				/* 1.Data transfer to AP */
				/* 2.Arp pkt will relayed by AP */
				SetToDs(fctrl);
				_rtw_memcpy(pwlanhdr->addr1, get_bssid(pmlmepriv), ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr2, pattrib->ta, ETH_ALEN);
				_rtw_memcpy(pwlanhdr->addr3, pattrib->dst, ETH_ALEN);

				if (pqospriv->qos_option)
					qos_option = _TRUE;
			}
		} else if ((check_fwstate(pmlmepriv,  WIFI_AP_STATE) == _TRUE)) {
			/* to_ds = 0, fr_ds = 1; */
			SetFrDs(fctrl);
			_rtw_memcpy(pwlanhdr->addr1, pattrib->dst, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, get_bssid(pmlmepriv), ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, pattrib->src, ETH_ALEN);

			if (pattrib->qos_en)
				qos_option = _TRUE;
		} else if ((check_fwstate(pmlmepriv, WIFI_ADHOC_STATE) == _TRUE) ||
			(check_fwstate(pmlmepriv, WIFI_ADHOC_MASTER_STATE) == _TRUE)) {
			_rtw_memcpy(pwlanhdr->addr1, pattrib->dst, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, pattrib->ta, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, get_bssid(pmlmepriv), ETH_ALEN);

			if (pattrib->qos_en)
				qos_option = _TRUE;
#ifdef CONFIG_RTW_MESH
		} else if (check_fwstate(pmlmepriv, WIFI_MESH_STATE) == _TRUE) {
			rtw_mesh_tx_build_whdr(padapter, pattrib, fctrl, pwlanhdr);
			if (pattrib->qos_en)
				qos_option = _TRUE;
			else {
				RTW_WARN("[%s] !qos_en in Mesh\n", __FUNCTION__);
				res = _FAIL;
				goto exit;
			}
#endif
		} else {
			res = _FAIL;
			goto exit;
		}

		if (pattrib->mdata)
			SetMData(fctrl);

		if (pattrib->encrypt)
			SetPrivacy(fctrl);

		if (pattrib->order)
			htc_option = _TRUE;

		if (qos_option) {
			qc = (unsigned short *)(hdr + pattrib->hdrlen - 2);/* CONFIG_RTW_A4_STA, WLAN_HDR_A3_LEN */

			if (pattrib->priority)
				SetPriority(qc, pattrib->priority);

			SetEOSP(qc, pattrib->eosp);

			SetAckpolicy(qc, pattrib->ack_policy);

			if(pattrib->amsdu)
				SetAMsdu(qc, pattrib->amsdu);
#ifdef CONFIG_RTW_MESH
			if (MLME_IS_MESH(padapter)) {
				/* active: don't care, light sleep: 0, deep sleep: 1*/
				set_mps_lv(qc, 0); //TBD

				/* TBD: temporary set (rspi, eosp) = (0, 1) which means End MPSP */
				set_rspi(qc, 0);
				SetEOSP(qc, 1);

				set_mctrl_present(qc, 1);
			}
#endif
		}

		/* TODO: fill HT Control Field */
		if (htc_option == _TRUE) {
			set_order_bit(fctrl);

			htc = (u32*)(hdr + pattrib->hdrlen - 4);
			rtw_fill_htc_in_wlanhdr(padapter, pattrib, htc);
		}

		/* Update Seq Num will be handled by f/w */
		{
			struct sta_info *psta;
			psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
			if (pattrib->psta != psta) {
				RTW_INFO("%s, pattrib->psta(%p) != psta(%p)\n", __func__, pattrib->psta, psta);
				return _FAIL;
			}

			if (psta == NULL) {
				RTW_INFO("%s, psta==NUL\n", __func__);
				return _FAIL;
			}

			if (!(psta->state & WIFI_ASOC_STATE)) {
				RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
				return _FAIL;
			}


			if (psta) {
				psta->sta_xmitpriv.txseq_tid[pattrib->priority]++;
				psta->sta_xmitpriv.txseq_tid[pattrib->priority] &= 0xFFF;
				pattrib->seqnum = psta->sta_xmitpriv.txseq_tid[pattrib->priority];

				SetSeqNum(hdr, pattrib->seqnum);

#ifdef CONFIG_80211N_HT
#if 0 /* move into update_attrib_phy_info(). */
				/* check if enable ampdu */
				if (pattrib->ht_en && psta->htpriv.ampdu_enable) {
					if (psta->htpriv.agg_enable_bitmap & BIT(pattrib->priority))
						pattrib->ampdu_en = _TRUE;
				}
#endif
				/* re-check if enable ampdu by BA_starting_seqctrl */
				if (pattrib->ampdu_en == _TRUE) {
					u16 tx_seq;

					tx_seq = psta->BA_starting_seqctrl[pattrib->priority & 0x0f];

					/* check BA_starting_seqctrl */
					if (SN_LESS(pattrib->seqnum, tx_seq)) {
						/* RTW_INFO("tx ampdu seqnum(%d) < tx_seq(%d)\n", pattrib->seqnum, tx_seq); */
						pattrib->ampdu_en = _FALSE;/* AGG BK */
					} else if (SN_EQUAL(pattrib->seqnum, tx_seq)) {
						psta->BA_starting_seqctrl[pattrib->priority & 0x0f] = (tx_seq + 1) & 0xfff;

						pattrib->ampdu_en = _TRUE;/* AGG EN */
					} else {
						/* RTW_INFO("tx ampdu over run\n"); */
						psta->BA_starting_seqctrl[pattrib->priority & 0x0f] = (pattrib->seqnum + 1) & 0xfff;
						pattrib->ampdu_en = _TRUE;/* AGG EN */
					}

				}
#endif /* CONFIG_80211N_HT */
			}
		}

	} else {

	}

exit:


	return res;
}

s32 rtw_txframes_pending(_adapter *padapter)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;

	return ((_rtw_queue_empty(&pxmitpriv->be_pending) == _FALSE) ||
		(_rtw_queue_empty(&pxmitpriv->bk_pending) == _FALSE) ||
		(_rtw_queue_empty(&pxmitpriv->vi_pending) == _FALSE) ||
		(_rtw_queue_empty(&pxmitpriv->vo_pending) == _FALSE));
}

s32 rtw_txframes_sta_ac_pending(_adapter *padapter, struct pkt_attrib *pattrib)
{
	struct sta_info *psta;
	struct tx_servq *ptxservq;
	int priority = pattrib->priority;
	/*
		if(pattrib->psta)
		{
			psta = pattrib->psta;
		}
		else
		{
			RTW_INFO("%s, call rtw_get_stainfo()\n", __func__);
			psta=rtw_get_stainfo(&padapter->stapriv ,&pattrib->ra[0]);
		}
	*/
	psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
	if (pattrib->psta != psta) {
		RTW_INFO("%s, pattrib->psta(%p) != psta(%p)\n", __func__, pattrib->psta, psta);
		return 0;
	}

	if (psta == NULL) {
		RTW_INFO("%s, psta==NUL\n", __func__);
		return 0;
	}

	if (!(psta->state & WIFI_ASOC_STATE)) {
		RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
		return 0;
	}

	switch (priority) {
	case 1:
	case 2:
		ptxservq = &(psta->sta_xmitpriv.bk_q);
		break;
	case 4:
	case 5:
		ptxservq = &(psta->sta_xmitpriv.vi_q);
		break;
	case 6:
	case 7:
		ptxservq = &(psta->sta_xmitpriv.vo_q);
		break;
	case 0:
	case 3:
	default:
		ptxservq = &(psta->sta_xmitpriv.be_q);
		break;

	}

	return ptxservq->qcnt;
}

#ifdef CONFIG_TDLS

int rtw_build_tdls_ies(_adapter *padapter, struct xmit_frame *pxmitframe, u8 *pframe, struct tdls_txmgmt *ptxmgmt)
{
	struct pkt_attrib *pattrib = &pxmitframe->attrib;
	struct sta_info *ptdls_sta = NULL;
	int res = _SUCCESS;

	ptdls_sta = rtw_get_stainfo((&padapter->stapriv), pattrib->dst);
	if (ptdls_sta == NULL) {
		switch (ptxmgmt->action_code) {
		case TDLS_DISCOVERY_REQUEST:
		case TUNNELED_PROBE_REQ:
		case TUNNELED_PROBE_RSP:
			break;
		default:
			RTW_INFO("[TDLS] %s - Direct Link Peer = "MAC_FMT" not found for action = %d\n", __func__, MAC_ARG(pattrib->dst), ptxmgmt->action_code);
			res = _FAIL;
			goto exit;
		}
	}

	switch (ptxmgmt->action_code) {
	case TDLS_SETUP_REQUEST:
		rtw_build_tdls_setup_req_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
	case TDLS_SETUP_RESPONSE:
		rtw_build_tdls_setup_rsp_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
	case TDLS_SETUP_CONFIRM:
		rtw_build_tdls_setup_cfm_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
	case TDLS_TEARDOWN:
		rtw_build_tdls_teardown_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
	case TDLS_DISCOVERY_REQUEST:
		rtw_build_tdls_dis_req_ies(padapter, pxmitframe, pframe, ptxmgmt);
		break;
	case TDLS_PEER_TRAFFIC_INDICATION:
		rtw_build_tdls_peer_traffic_indication_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
#ifdef CONFIG_TDLS_CH_SW
	case TDLS_CHANNEL_SWITCH_REQUEST:
		rtw_build_tdls_ch_switch_req_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
	case TDLS_CHANNEL_SWITCH_RESPONSE:
		rtw_build_tdls_ch_switch_rsp_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
#endif
	case TDLS_PEER_TRAFFIC_RESPONSE:
		rtw_build_tdls_peer_traffic_rsp_ies(padapter, pxmitframe, pframe, ptxmgmt, ptdls_sta);
		break;
#ifdef CONFIG_WFD
	case TUNNELED_PROBE_REQ:
		rtw_build_tunneled_probe_req_ies(padapter, pxmitframe, pframe);
		break;
	case TUNNELED_PROBE_RSP:
		rtw_build_tunneled_probe_rsp_ies(padapter, pxmitframe, pframe);
		break;
#endif /* CONFIG_WFD */
	default:
		res = _FAIL;
		break;
	}

exit:
	return res;
}

s32 rtw_make_tdls_wlanhdr(_adapter *padapter , u8 *hdr, struct pkt_attrib *pattrib, struct tdls_txmgmt *ptxmgmt)
{
	u16 *qc;
	struct rtw_ieee80211_hdr *pwlanhdr = (struct rtw_ieee80211_hdr *)hdr;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	struct qos_priv *pqospriv = &pmlmepriv->qospriv;
	struct sta_priv	*pstapriv = &padapter->stapriv;
	struct sta_info *psta = NULL, *ptdls_sta = NULL;
	u8 tdls_seq = 0, baddr[ETH_ALEN] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

	sint res = _SUCCESS;
	u16 *fctrl = &pwlanhdr->frame_ctl;


	_rtw_memset(hdr, 0, WLANHDR_OFFSET);

	set_frame_sub_type(fctrl, pattrib->subtype);

	switch (ptxmgmt->action_code) {
	case TDLS_SETUP_REQUEST:
	case TDLS_SETUP_RESPONSE:
	case TDLS_SETUP_CONFIRM:
	case TDLS_PEER_TRAFFIC_INDICATION:
	case TDLS_PEER_PSM_REQUEST:
	case TUNNELED_PROBE_REQ:
	case TUNNELED_PROBE_RSP:
	case TDLS_DISCOVERY_REQUEST:
		SetToDs(fctrl);
		_rtw_memcpy(pwlanhdr->addr1, get_bssid(pmlmepriv), ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, pattrib->src, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, pattrib->dst, ETH_ALEN);
		break;
	case TDLS_CHANNEL_SWITCH_REQUEST:
	case TDLS_CHANNEL_SWITCH_RESPONSE:
	case TDLS_PEER_PSM_RESPONSE:
	case TDLS_PEER_TRAFFIC_RESPONSE:
		_rtw_memcpy(pwlanhdr->addr1, pattrib->dst, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr2, pattrib->src, ETH_ALEN);
		_rtw_memcpy(pwlanhdr->addr3, get_bssid(pmlmepriv), ETH_ALEN);
		tdls_seq = 1;
		break;
	case TDLS_TEARDOWN:
		if (ptxmgmt->status_code == _RSON_TDLS_TEAR_UN_RSN_) {
			_rtw_memcpy(pwlanhdr->addr1, pattrib->dst, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, pattrib->src, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, get_bssid(pmlmepriv), ETH_ALEN);
			tdls_seq = 1;
		} else {
			SetToDs(fctrl);
			_rtw_memcpy(pwlanhdr->addr1, get_bssid(pmlmepriv), ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr2, pattrib->src, ETH_ALEN);
			_rtw_memcpy(pwlanhdr->addr3, pattrib->dst, ETH_ALEN);
		}
		break;
	}

	if (pattrib->encrypt)
		SetPrivacy(fctrl);

	if (ptxmgmt->action_code == TDLS_PEER_TRAFFIC_RESPONSE)
		SetPwrMgt(fctrl);

	if (pqospriv->qos_option) {
		qc = (unsigned short *)(hdr + pattrib->hdrlen - 2);
		if (pattrib->priority)
			SetPriority(qc, pattrib->priority);
		SetAckpolicy(qc, pattrib->ack_policy);
	}

	psta = pattrib->psta;

	/* 1. update seq_num per link by sta_info */
	/* 2. rewrite encrypt to _AES_, also rewrite iv_len, icv_len */
	if (tdls_seq == 1) {
		ptdls_sta = rtw_get_stainfo(pstapriv, pattrib->dst);
		if (ptdls_sta) {
			ptdls_sta->sta_xmitpriv.txseq_tid[pattrib->priority]++;
			ptdls_sta->sta_xmitpriv.txseq_tid[pattrib->priority] &= 0xFFF;
			pattrib->seqnum = ptdls_sta->sta_xmitpriv.txseq_tid[pattrib->priority];
			SetSeqNum(hdr, pattrib->seqnum);

			if (pattrib->encrypt) {
				pattrib->encrypt = _AES_;
				pattrib->iv_len = 8;
				pattrib->icv_len = 8;
				pattrib->bswenc = _FALSE;
			}
			pattrib->mac_id = ptdls_sta->phl_sta->macid;
		} else {
			res = _FAIL;
			goto exit;
		}
	} else if (psta) {
		psta->sta_xmitpriv.txseq_tid[pattrib->priority]++;
		psta->sta_xmitpriv.txseq_tid[pattrib->priority] &= 0xFFF;
		pattrib->seqnum = psta->sta_xmitpriv.txseq_tid[pattrib->priority];
		SetSeqNum(hdr, pattrib->seqnum);
	}


exit:


	return res;
}

s32 rtw_xmit_tdls_coalesce(_adapter *padapter, struct xmit_frame *pxmitframe, struct tdls_txmgmt *ptxmgmt)
{
	s32 llc_sz;

	u8 *pframe, *mem_start;

	struct sta_info		*psta;
	struct sta_priv		*pstapriv = &padapter->stapriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct pkt_attrib	*pattrib = &pxmitframe->attrib;
	u8 *pbuf_start;
	s32 bmcst = IS_MCAST(pattrib->ra);
	s32 res = _SUCCESS;


	if (pattrib->psta)
		psta = pattrib->psta;
	else {
		if (bmcst)
			psta = rtw_get_bcmc_stainfo(padapter);
		else
			psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
	}

	if (psta == NULL) {
		res = _FAIL;
		goto exit;
	}

	if (pxmitframe->buf_addr == NULL) {
		res = _FAIL;
		goto exit;
	}

	pbuf_start = pxmitframe->buf_addr;
	mem_start = pbuf_start + TXDESC_OFFSET;

	if (rtw_make_tdls_wlanhdr(padapter, mem_start, pattrib, ptxmgmt) == _FAIL) {
		res = _FAIL;
		goto exit;
	}

	pframe = mem_start;
	pframe += pattrib->hdrlen;

	/* adding icv, if necessary... */
	if (pattrib->iv_len) {
		if (psta != NULL) {
			switch (pattrib->encrypt) {
			case _WEP40_:
			case _WEP104_:
				UPDATE_WEP_PN(pattrib->pn, psta->dot11txpn);
				WEP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
				break;
			case _TKIP_:
				UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, psta->dot11txpn);
				TKIP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
				break;
			case _AES_:
				UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, psta->dot11txpn);
				CCMP_IV(pattrib->iv, pattrib->pn, pattrib->key_idx);
				break;
			}
		}

		_rtw_memcpy(pframe, pattrib->iv, pattrib->iv_len);
		pframe += pattrib->iv_len;

	}

	if(pattrib->vlan_proto)
		llc_sz = rtw_put_snap(pframe, pattrib->vlan_proto);
	else
		llc_sz = rtw_put_snap(pframe, pattrib->ether_type);
	pframe += llc_sz;

	/* pattrib->pktlen will be counted in rtw_build_tdls_ies */
	pattrib->pktlen = 0;

	rtw_build_tdls_ies(padapter, pxmitframe, pframe, ptxmgmt);

	if ((pattrib->icv_len > 0) && (pattrib->bswenc)) {
		pframe += pattrib->pktlen;
		_rtw_memcpy(pframe, pattrib->icv, pattrib->icv_len);
		pframe += pattrib->icv_len;
	}

	pattrib->nr_frags = 1;
	pattrib->last_txcmdsz = pattrib->hdrlen + pattrib->iv_len + llc_sz +
		((pattrib->bswenc) ? pattrib->icv_len : 0) + pattrib->pktlen;

	if (xmitframe_addmic(padapter, pxmitframe) == _FAIL) {
		res = _FAIL;
		goto exit;
	}

	xmitframe_swencrypt(padapter, pxmitframe);

	update_attrib_vcs_info(padapter, pxmitframe);

exit:


	return res;
}
#endif /* CONFIG_TDLS */

/*
 * Calculate wlan 802.11 packet MAX size from pkt_attrib
 * This function doesn't consider fragment case
 */
u32 rtw_calculate_wlan_pkt_size_by_attribue(struct pkt_attrib *pattrib)
{
	u32	len = 0;

	len = pattrib->hdrlen /* WLAN Header */
		+ pattrib->iv_len /* IV */
		+ XATTRIB_GET_MCTRL_LEN(pattrib)
		+ SNAP_SIZE + sizeof(u16) /* LLC */
		+ pattrib->pktlen
		+ (pattrib->encrypt == _TKIP_ ? 8 : 0) /* MIC */
		+ (pattrib->bswenc ? pattrib->icv_len : 0) /* ICV */
		;

	return len;
}

#ifdef CONFIG_TX_AMSDU
s32 check_amsdu(struct xmit_frame *pxmitframe)
{
	struct pkt_attrib *pattrib;
	s32 ret = _TRUE;

	if (!pxmitframe)
		ret = _FALSE;

	pattrib = &pxmitframe->attrib;

	if (pattrib) {
		if (IS_MCAST(pattrib->ra))
			ret = _FALSE;

		if ((pattrib->ether_type == 0x888e) ||
			(pattrib->ether_type == 0x0806) ||
			(pattrib->ether_type == 0x88b4) ||
			(pattrib->dhcp_pkt == 1))
			ret = _FALSE;

		if ((pattrib->encrypt == _WEP40_) ||
		    (pattrib->encrypt == _WEP104_) ||
		    (pattrib->encrypt == _TKIP_))
			ret = _FALSE;

		if (!pattrib->qos_en)
			ret = _FALSE;

		if (IS_AMSDU_AMPDU_NOT_VALID(pattrib))
			ret = _FALSE;
	}

	return ret;
}

s32 check_amsdu_tx_support(_adapter *padapter)
{
	struct dvobj_priv *pdvobjpriv;
	int tx_amsdu;
	int tx_amsdu_rate;
	int current_tx_rate;
	s32 ret = _FALSE;

	pdvobjpriv = adapter_to_dvobj(padapter);
	tx_amsdu = padapter->tx_amsdu;
	tx_amsdu_rate = padapter->tx_amsdu_rate;
	current_tx_rate = pdvobjpriv->traffic_stat.cur_tx_tp;

	if (tx_amsdu == 1)
		ret = _TRUE;
	else if (tx_amsdu == 2 && (tx_amsdu_rate == 0 || current_tx_rate > tx_amsdu_rate))
		ret = _TRUE;
	else
		ret = _FALSE;

	return ret;
}

s32 rtw_xmitframe_coalesce_amsdu(_adapter *padapter, struct xmit_frame *pxmitframe, struct xmit_frame *pxmitframe_queue)
{

	struct pkt_file pktfile;
	struct pkt_attrib *pattrib;
	struct sk_buff *pkt;

	struct pkt_file pktfile_queue;
	struct pkt_attrib *pattrib_queue;
	struct sk_buff *pkt_queue;

	s32 llc_sz, mem_sz;

	s32 padding = 0;

	u8 *pframe, *mem_start;
	u8 hw_hdr_offset;

	u16* len;
	u8 *pbuf_start;
	s32 res = _SUCCESS;

	if (pxmitframe->buf_addr == NULL) {
		RTW_INFO("==> %s buf_addr==NULL\n", __FUNCTION__);
		return _FAIL;
	}


	pbuf_start = pxmitframe->buf_addr;

#ifdef CONFIG_USB_TX_AGGREGATION
	hw_hdr_offset =  TXDESC_SIZE + (pxmitframe->pkt_offset * PACKET_OFFSET_SZ);
#else
#ifdef CONFIG_TX_EARLY_MODE /* for SDIO && Tx Agg */
	hw_hdr_offset = TXDESC_OFFSET + EARLY_MODE_INFO_SIZE;
#else
	hw_hdr_offset = TXDESC_OFFSET;
#endif
#endif

	mem_start = pbuf_start + hw_hdr_offset; //for DMA

	pattrib = &pxmitframe->attrib;

	pattrib->amsdu = 1;

	if (rtw_make_wlanhdr(padapter, mem_start, pattrib) == _FAIL) {
		RTW_INFO("%s: rtw_make_wlanhdr fail; drop pkt\n", __func__);
		res = _FAIL;
		goto exit;
	}

	llc_sz = 0;

	pframe = mem_start;

	//SetMFrag(mem_start);
	ClearMFrag(mem_start);

	pframe += pattrib->hdrlen;

	/* adding icv, if necessary... */
	if (pattrib->iv_len) {
		update_attrib_sec_iv_info(padapter, pattrib);
		_rtw_memcpy(pframe, pattrib->iv, pattrib->iv_len); // queue or new?

		RTW_DBG("%s: keyid=%d pattrib->iv[3]=%.2x pframe=%.2x %.2x %.2x %.2x\n",
			__func__, padapter->securitypriv.dot11PrivacyKeyIndex,
			pattrib->iv[3], *pframe, *(pframe + 1), *(pframe + 2), *(pframe + 3));

		pframe += pattrib->iv_len;
	}

	pattrib->last_txcmdsz = pattrib->hdrlen + pattrib->iv_len;

	if(pxmitframe_queue)
	{
		pattrib_queue = &pxmitframe_queue->attrib;
		pkt_queue = pxmitframe_queue->pkt;

		_rtw_open_pktfile(pkt_queue, &pktfile_queue);
		_rtw_pktfile_read(&pktfile_queue, NULL, pattrib_queue->pkt_hdrlen);

		#ifdef CONFIG_RTW_MESH
		if (MLME_IS_MESH(padapter)) {
			/* mDA(6), mSA(6), len(2), mctrl */
			_rtw_memcpy(pframe, pattrib_queue->mda, ETH_ALEN);
			pframe += ETH_ALEN;
			_rtw_memcpy(pframe, pattrib_queue->msa, ETH_ALEN);
			pframe += ETH_ALEN;
			len = (u16*)pframe;
			pframe += 2;
			rtw_mesh_tx_build_mctrl(padapter, pattrib_queue, pframe);
			pframe += XATTRIB_GET_MCTRL_LEN(pattrib_queue);
		} else
		#endif
		{
			/* 802.3 MAC Header DA(6)  SA(6)  Len(2)*/
			_rtw_memcpy(pframe, pattrib_queue->dst, ETH_ALEN);
			pframe += ETH_ALEN;
			_rtw_memcpy(pframe, pattrib_queue->src, ETH_ALEN);
			pframe += ETH_ALEN;
			len = (u16*)pframe;
			pframe += 2;
		}

		if(pattrib->vlan_proto)
			llc_sz = rtw_put_snap(pframe, pattrib->vlan_proto);
		else
			llc_sz = rtw_put_snap(pframe, pattrib->ether_type);
		pframe += llc_sz;

		mem_sz = _rtw_pktfile_read(&pktfile_queue, pframe, pattrib_queue->pktlen);
		pframe += mem_sz;

		*len = htons(XATTRIB_GET_MCTRL_LEN(pattrib_queue) + llc_sz + mem_sz);

		//calc padding
		padding = 4 - ((ETH_HLEN + XATTRIB_GET_MCTRL_LEN(pattrib_queue) + llc_sz + mem_sz) & (4-1));
		if(padding == 4)
			padding = 0;

		//_rtw_memset(pframe,0xaa, padding);
		pframe += padding;

		pattrib->last_txcmdsz += ETH_HLEN + XATTRIB_GET_MCTRL_LEN(pattrib_queue) + llc_sz + mem_sz + padding ;
	}

	//2nd mpdu

	pkt = pxmitframe->pkt;
	_rtw_open_pktfile(pkt, &pktfile);
	_rtw_pktfile_read(&pktfile, NULL, pattrib->pkt_hdrlen);

#ifdef CONFIG_RTW_MESH
	if (MLME_IS_MESH(padapter)) {
		/* mDA(6), mSA(6), len(2), mctrl */
		_rtw_memcpy(pframe, pattrib->mda, ETH_ALEN);
		pframe += ETH_ALEN;
		_rtw_memcpy(pframe, pattrib->msa, ETH_ALEN);
		pframe += ETH_ALEN;
		len = (u16*)pframe;
		pframe += 2;
		rtw_mesh_tx_build_mctrl(padapter, pattrib, pframe);
		pframe += XATTRIB_GET_MCTRL_LEN(pattrib);
	} else
#endif
	{
		/* 802.3 MAC Header  DA(6)  SA(6)  Len(2) */
		_rtw_memcpy(pframe, pattrib->dst, ETH_ALEN);
		pframe += ETH_ALEN;
		_rtw_memcpy(pframe, pattrib->src, ETH_ALEN);
		pframe += ETH_ALEN;
		len = (u16*)pframe;
		pframe += 2;
	}

	if(pattrib->vlan_proto)
		llc_sz = rtw_put_snap(pframe, pattrib->vlan_proto);
	else
		llc_sz = rtw_put_snap(pframe, pattrib->ether_type);
	pframe += llc_sz;

	mem_sz = _rtw_pktfile_read(&pktfile, pframe, pattrib->pktlen);

	pframe += mem_sz;

	*len = htons(XATTRIB_GET_MCTRL_LEN(pattrib) + llc_sz + mem_sz);

	//the last ampdu has no padding
	padding = 0;

	pattrib->nr_frags = 1;

	pattrib->last_txcmdsz += ETH_HLEN + XATTRIB_GET_MCTRL_LEN(pattrib) + llc_sz + mem_sz + padding +
		((pattrib->bswenc) ? pattrib->icv_len : 0) ;

	if ((pattrib->icv_len > 0) && (pattrib->bswenc)) {
		_rtw_memcpy(pframe, pattrib->icv, pattrib->icv_len);
		pframe += pattrib->icv_len;
	}

	if (xmitframe_addmic(padapter, pxmitframe) == _FAIL) {
		RTW_INFO("xmitframe_addmic(padapter, pxmitframe)==_FAIL\n");
		res = _FAIL;
		goto exit;
	}

	xmitframe_swencrypt(padapter, pxmitframe);

	update_attrib_vcs_info(padapter, pxmitframe);

exit:
	return res;
}
#endif /* CONFIG_TX_AMSDU */

/*

This sub-routine will perform all the following:

1. remove 802.3 header.
2. create wlan_header, based on the info in pxmitframe
3. append sta's iv/ext-iv
4. append LLC
5. move frag chunk from pframe to pxmitframe->mem
6. apply sw-encrypt, if necessary.

*/
s32 rtw_xmitframe_coalesce(_adapter *padapter, struct sk_buff *pkt, struct xmit_frame *pxmitframe)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pkt_file pktfile;

	s32 frg_inx, frg_len, mpdu_len, llc_sz, mem_sz;

	SIZE_PTR addr;

	u8 *pframe, *mem_start;
	u8 hw_hdr_offset;

	/* struct sta_info		*psta; */
	/* struct sta_priv		*pstapriv = &padapter->stapriv; */
	/* struct mlme_priv	*pmlmepriv = &padapter->mlmepriv; */
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;

	struct pkt_attrib	*pattrib = &pxmitframe->attrib;

	u8 *pbuf_start;

	s32 bmcst = IS_MCAST(pattrib->ra);
	s32 res = _SUCCESS;


	/*
		if (pattrib->psta)
		{
			psta = pattrib->psta;
		} else
		{
			RTW_INFO("%s, call rtw_get_stainfo()\n", __func__);
			psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
		}

		if(psta==NULL)
		{

			RTW_INFO("%s, psta==NUL\n", __func__);
			return _FAIL;
		}


		if(!(psta->state &WIFI_ASOC_STATE))
		{
			RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
			return _FAIL;
		}
	*/
	if (pxmitframe->buf_addr == NULL) {
		RTW_INFO("==> %s buf_addr==NULL\n", __FUNCTION__);
		return _FAIL;
	}

	pbuf_start = pxmitframe->buf_addr;

#if 0
#ifdef CONFIG_USB_TX_AGGREGATION
	hw_hdr_offset =  TXDESC_SIZE + (pxmitframe->pkt_offset * PACKET_OFFSET_SZ);
#else
#ifdef CONFIG_TX_EARLY_MODE /* for SDIO && Tx Agg */
	hw_hdr_offset = TXDESC_OFFSET + EARLY_MODE_INFO_SIZE;
#else
	hw_hdr_offset = TXDESC_OFFSET;
#endif
#endif
#endif
	hw_hdr_offset = rtw_hal_get_txdesc_len(GET_HAL_DATA(dvobj), pattrib); /*FPGA_test*/

	mem_start = pbuf_start +	hw_hdr_offset;

	if (rtw_make_wlanhdr(padapter, mem_start, pattrib) == _FAIL) {
		RTW_INFO("%s: rtw_make_wlanhdr fail; drop pkt\n", __func__);
		res = _FAIL;
		goto exit;
	}

	_rtw_open_pktfile(pkt, &pktfile);
	_rtw_pktfile_read(&pktfile, NULL, pattrib->pkt_hdrlen);

	frg_inx = 0;
	frg_len = pxmitpriv->frag_len - 4;/* 2346-4 = 2342 */

	while (1) {
		llc_sz = 0;

		mpdu_len = frg_len;

		pframe = mem_start;

		SetMFrag(mem_start);

		pframe += pattrib->hdrlen;
		mpdu_len -= pattrib->hdrlen;

		/* adding icv, if necessary... */
		if (pattrib->iv_len) {
			update_attrib_sec_iv_info(padapter, pattrib);
			_rtw_memcpy(pframe, pattrib->iv, pattrib->iv_len);


			pframe += pattrib->iv_len;

			mpdu_len -= pattrib->iv_len;
		}

		if (frg_inx == 0) {
			#ifdef CONFIG_RTW_MESH
			if (MLME_IS_MESH(padapter)) {
				rtw_mesh_tx_build_mctrl(padapter, pattrib, pframe);
				pframe += XATTRIB_GET_MCTRL_LEN(pattrib);
				mpdu_len -= XATTRIB_GET_MCTRL_LEN(pattrib);
			}
			#endif

			if(pattrib->vlan_proto)
				llc_sz = rtw_put_snap(pframe, pattrib->vlan_proto);
			else
				llc_sz = rtw_put_snap(pframe, pattrib->ether_type);
			pframe += llc_sz;
			mpdu_len -= llc_sz;
		}

		if ((pattrib->icv_len > 0) && (pattrib->bswenc))
			mpdu_len -= pattrib->icv_len;


		if (bmcst) {
			/* don't do fragment to broadcat/multicast packets */
			mem_sz = _rtw_pktfile_read(&pktfile, pframe, pattrib->pktlen);
		} else
			mem_sz = _rtw_pktfile_read(&pktfile, pframe, mpdu_len);

		pframe += mem_sz;

		if ((pattrib->icv_len > 0) && (pattrib->bswenc)) {
			_rtw_memcpy(pframe, pattrib->icv, pattrib->icv_len);
			pframe += pattrib->icv_len;
		}

		frg_inx++;

		if (bmcst || (rtw_endofpktfile(&pktfile) == _TRUE)) {
			pattrib->nr_frags = frg_inx;

			pattrib->last_txcmdsz = pattrib->hdrlen + pattrib->iv_len +
				((pattrib->nr_frags == 1) ? (XATTRIB_GET_MCTRL_LEN(pattrib) + llc_sz) : 0) +
				((pattrib->bswenc) ? pattrib->icv_len : 0) + mem_sz;

			ClearMFrag(mem_start);

			break;
		}

		addr = (SIZE_PTR)(pframe);

		mem_start = (unsigned char *)RND4(addr) + hw_hdr_offset;
		_rtw_memcpy(mem_start, pbuf_start + hw_hdr_offset, pattrib->hdrlen);

	}

	if (xmitframe_addmic(padapter, pxmitframe) == _FAIL) {
		RTW_INFO("xmitframe_addmic(padapter, pxmitframe)==_FAIL\n");
		res = _FAIL;
		goto exit;
	}

	xmitframe_swencrypt(padapter, pxmitframe);

	if (bmcst == _FALSE)
		update_attrib_vcs_info(padapter, pxmitframe);
	else
		pattrib->vcs_mode = NONE_VCS;

exit:


	return res;
}

#if defined(CONFIG_IEEE80211W) || defined(CONFIG_RTW_MESH)
/*
 * CCMP encryption for unicast robust mgmt frame and broadcast group privicy action
 * BIP for broadcast robust mgmt frame
 */
s32 rtw_mgmt_xmitframe_coalesce(_adapter *padapter, struct sk_buff *pkt, struct xmit_frame *pxmitframe)
{
#define DBG_MGMT_XMIT_COALESEC_DUMP 0
#define DBG_MGMT_XMIT_BIP_DUMP 0
#define DBG_MGMT_XMIT_ENC_DUMP 0

	struct pkt_file pktfile;
	s32 frg_inx, frg_len, mpdu_len, llc_sz, mem_sz;
	SIZE_PTR addr;
	u8 *pframe, *mem_start = NULL, *tmp_buf = NULL;
	u8 hw_hdr_offset, subtype ;
	u8 category = 0xFF, action = 0xFF;
	struct sta_info		*psta = NULL;
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;
	struct pkt_attrib	*pattrib = &pxmitframe->attrib;
	u8 *pbuf_start;
	s32 bmcst = IS_MCAST(pattrib->ra);
	s32 res = _FAIL;
	u8 *BIP_AAD = NULL;
	u8 *MGMT_body = NULL;

	struct mlme_ext_priv	*pmlmeext = &padapter->mlmeextpriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	struct rtw_ieee80211_hdr	*pwlanhdr;
	u8 mme_cont[_MME_IE_LENGTH_];
	u8 mme_clen;

	u32	ori_len;
	union pn48 *pn = NULL;
	enum security_type cipher = _NO_PRIVACY_;
	u8 kid;
	u8 hw_security_zero_hdrlen = _FALSE;
	u8 force_sw_enc = 0;

	if (pxmitframe->buf_addr == NULL) {
		RTW_WARN(FUNC_ADPT_FMT" pxmitframe->buf_addr\n"
			, FUNC_ADPT_ARG(padapter));
		return _FAIL;
	}

	mem_start = pframe = (u8 *)(pxmitframe->buf_addr) + TXDESC_OFFSET;
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;
	subtype = get_frame_sub_type(pframe); /* bit(7)~bit(2) */

	/* check if robust mgmt frame */
	if (subtype != WIFI_DEAUTH && subtype != WIFI_DISASSOC && subtype != WIFI_ACTION)
		return _SUCCESS;
	if ((subtype == WIFI_DEAUTH) || (subtype == WIFI_DISASSOC))
		force_sw_enc = 1;
	if (subtype == WIFI_ACTION) {
		category = *(pframe + sizeof(struct rtw_ieee80211_hdr_3addr));
		if (CATEGORY_IS_NON_ROBUST(category))
			return _SUCCESS;

		if (category == RTW_WLAN_CATEGORY_BACK) {
			action = *(pframe + sizeof(struct rtw_ieee80211_hdr_3addr) + 1);
			if (action == RTW_WLAN_ACTION_DELBA)
				force_sw_enc = 1;
		}
	}
	if (!bmcst) {
		if (pattrib->psta)
			psta = pattrib->psta;
		else
			pattrib->psta = psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
		if (psta == NULL) {
			RTW_INFO(FUNC_ADPT_FMT" unicast sta == NULL\n", FUNC_ADPT_ARG(padapter));
			return _FAIL;
		}
		if (!(psta->flags & WLAN_STA_MFP)) {
			/* peer is not MFP capable, no need to encrypt */
			return _SUCCESS;
		}
		if (psta->bpairwise_key_installed != _TRUE) {
			RTW_INFO(FUNC_ADPT_FMT" PTK is not installed\n"
				, FUNC_ADPT_ARG(padapter));
			return _FAIL;
		}
	}

	ori_len = BIP_AAD_SIZE + pattrib->pktlen + _MME_IE_LENGTH_;
	tmp_buf = BIP_AAD = rtw_zmalloc(ori_len);
	if (BIP_AAD == NULL)
		return _FAIL;

	_rtw_spinlock_bh(&padapter->security_key_mutex);

	if (bmcst) {
		if (subtype == WIFI_ACTION && CATEGORY_IS_GROUP_PRIVACY(category)) {
			/* broadcast group privacy action frame */
			#if DBG_MGMT_XMIT_COALESEC_DUMP
			RTW_INFO(FUNC_ADPT_FMT" broadcast gp action(%u)\n"
				, FUNC_ADPT_ARG(padapter), category);
			#endif

			if (pattrib->psta)
				psta = pattrib->psta;
			else
				pattrib->psta = psta = rtw_get_bcmc_stainfo(padapter);
			if (psta == NULL) {
				RTW_INFO(FUNC_ADPT_FMT" broadcast sta == NULL\n"
					, FUNC_ADPT_ARG(padapter));
				goto xmitframe_coalesce_fail;
			}
			if (padapter->securitypriv.binstallGrpkey != _TRUE) {
				RTW_INFO(FUNC_ADPT_FMT" GTK is not installed\n"
					, FUNC_ADPT_ARG(padapter));
				goto xmitframe_coalesce_fail;
			}

			pn = &psta->dot11txpn;
			cipher = padapter->securitypriv.dot118021XGrpPrivacy;
			kid = padapter->securitypriv.dot118021XGrpKeyid;
		} else {
			#ifdef CONFIG_IEEE80211W
			/* broadcast robust mgmt frame, using BIP */
			int frame_body_len;
			u8 mic[16];

			/* IGTK key is not install ex: mesh MFP without IGTK */
			if (SEC_IS_BIP_KEY_INSTALLED(&padapter->securitypriv) != _TRUE)
				goto xmitframe_coalesce_success;

			#if DBG_MGMT_XMIT_COALESEC_DUMP
			if (subtype == WIFI_DEAUTH)
				RTW_INFO(FUNC_ADPT_FMT" braodcast deauth\n", FUNC_ADPT_ARG(padapter));
			else if (subtype == WIFI_DISASSOC)
				RTW_INFO(FUNC_ADPT_FMT" braodcast disassoc\n", FUNC_ADPT_ARG(padapter));
			else if (subtype == WIFI_ACTION) {
				RTW_INFO(FUNC_ADPT_FMT" braodcast action(%u)\n"
					, FUNC_ADPT_ARG(padapter), category);
			}
			#endif

			/*HW encrypt need to record encrypt type*/
			pattrib->encrypt = padapter->securitypriv.dot11wCipher;

			MGMT_body = pframe + sizeof(struct rtw_ieee80211_hdr_3addr);
			pframe += pattrib->pktlen;

			_rtw_memset(mme_cont, 0, sizeof(mme_cont));

#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
			if (pattrib->encrypt == _BIP_CMAC_SM4_128_)
			{
				mme_clen = rtw_wapi_build_mmie(padapter, mme_cont, sizeof(mme_cont));
				if (mme_clen > 0) {
					_rtw_memcpy(pframe, mme_cont, mme_clen);
					pframe += mme_clen;
					pattrib->pktlen += mme_clen;
				} else {
					/* unlikely */
					goto xmitframe_coalesce_fail;
				}
			}
			else
#endif
			{
				mme_clen = padapter->securitypriv.dot11wCipher == _BIP_CMAC_128_ ? 16 : 24;

				/* octent 0 and 1 is key index, BIP keyid is 4 or 5, LSB only need octent 0 */
				mme_cont[0] = padapter->securitypriv.dot11wBIPKeyid;
				/* increase PN and apply to packet */
				padapter->securitypriv.dot11wBIPtxpn.val++;
				RTW_PUT_LE64(&mme_cont[2], padapter->securitypriv.dot11wBIPtxpn.val);
				/* IPN is actually 6 bytes, clear additional 2 bytes */
				mme_cont[8] = 0; mme_cont[9] = 0;

				/* add MME IE with MIC all zero, MME string doesn't include element id and length */
				pframe = rtw_set_ie(pframe, _MME_IE_ , mme_clen , mme_cont, &(pattrib->pktlen));
			}

			pattrib->last_txcmdsz = pattrib->pktlen;

			if (pattrib->encrypt &&
			(padapter->securitypriv.sw_encrypt == _TRUE || padapter->securitypriv.hw_decrypted == _FALSE)) {
				pattrib->bswenc = _TRUE;
			} else {
				/* currently HW only support _BIP_CMAC_128_ */
				if (pattrib->encrypt == _BIP_CMAC_128_)
					pattrib->bswenc = _FALSE;
				else
					pattrib->bswenc = _TRUE;
			}

			if (force_sw_enc)
				pattrib->bswenc = _TRUE;

			if (!pattrib->bswenc) {
				pattrib->key_idx = padapter->securitypriv.dot11wBIPKeyid;
				/*Don't need to append MIC part of MME*/
				pattrib->pktlen -= (mme_clen == 16 ? 8 :16);
				pattrib->last_txcmdsz = pattrib->pktlen;
				goto xmitframe_coalesce_success;
			}

			/* total frame length - header length */
			frame_body_len = pattrib->pktlen - sizeof(struct rtw_ieee80211_hdr_3addr);

			/* conscruct AAD, copy frame control field */
			_rtw_memcpy(BIP_AAD, &pwlanhdr->frame_ctl, 2);
			ClearRetry(BIP_AAD);
			ClearPwrMgt(BIP_AAD);
			ClearMData(BIP_AAD);
			/* conscruct AAD, copy address 1 to address 3 */
			_rtw_memcpy(BIP_AAD + 2, mem_start + 4, 3 * ETH_ALEN);
			/* copy management fram body */
			_rtw_memcpy(BIP_AAD + BIP_AAD_SIZE, MGMT_body, frame_body_len);

			#if DBG_MGMT_XMIT_BIP_DUMP
			/* dump total packet include MME with zero MIC */
			{
				int i;
				printk("Total packet: ");
				for (i = 0; i < BIP_AAD_SIZE + frame_body_len; i++)
					printk(" %02x ", BIP_AAD[i]);
				printk("\n");
			}
			#endif

			/* calculate mic */
			if (rtw_calculate_bip_mic(padapter->securitypriv.dot11wCipher,
				(u8 *)pwlanhdr, pattrib->pktlen,
				padapter->securitypriv.dot11wBIPKey[padapter->securitypriv.dot11wBIPKeyid].skey,
				BIP_AAD, (BIP_AAD_SIZE + frame_body_len), mic) == _FAIL)
				goto xmitframe_coalesce_fail;

			#if DBG_MGMT_XMIT_BIP_DUMP
			/* dump calculated mic result */
			{
				int i;
				printk("Calculated mic result: ");
				for (i = 0; i < 16; i++)
					printk(" %02x ", mic[i]);
				printk("\n");
			}
			#endif

			/* copy right BIP mic value, total is 128bits, we use the 0~63 bits */
			if (padapter->securitypriv.dot11wCipher == _BIP_CMAC_128_)
				_rtw_memcpy(pframe - 8, mic, 8);
			else
				_rtw_memcpy(pframe - 16, mic, 16);

			#if DBG_MGMT_XMIT_BIP_DUMP
			/*dump all packet after mic ok */
			{
				int pp;
				printk("pattrib->pktlen = %d\n", pattrib->pktlen);
				for(pp=0;pp< pattrib->pktlen; pp++)
					printk(" %02x ", mem_start[pp]);
				printk("\n");
			}
			#endif

			#endif /* CONFIG_IEEE80211W */

			goto xmitframe_coalesce_success;
		}
	}
	else {
		/* unicast robust mgmt frame */
		#if DBG_MGMT_XMIT_COALESEC_DUMP
		if (subtype == WIFI_DEAUTH) {
			RTW_INFO(FUNC_ADPT_FMT" unicast deauth to "MAC_FMT"\n"
				, FUNC_ADPT_ARG(padapter), MAC_ARG(pattrib->ra));
		} else if (subtype == WIFI_DISASSOC) {
			RTW_INFO(FUNC_ADPT_FMT" unicast disassoc to "MAC_FMT"\n"
				, FUNC_ADPT_ARG(padapter), MAC_ARG(pattrib->ra));
		} else if (subtype == WIFI_ACTION) {
			RTW_INFO(FUNC_ADPT_FMT" unicast action(%u) to "MAC_FMT"\n"
				, FUNC_ADPT_ARG(padapter), category, MAC_ARG(pattrib->ra));
		}
		#endif

		pn = &psta->dot11txpn;
		cipher = psta->dot118021XPrivacy;
		kid = 0;
#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
		if (padapter->securitypriv.dot11AuthAlgrthm == dot11AuthAlgrthm_WAPI)
			kid = psta->wapiStaInfo.keyIdx;
#endif

		_rtw_memcpy(pattrib->dot118021x_UncstKey.skey
			, psta->dot118021x_UncstKey.skey
			, (cipher & _SEC_TYPE_256_) ? 32 : 16);

		/* To use wrong key */
		if (pattrib->key_type == IEEE80211W_WRONG_KEY) {
			RTW_INFO("use wrong key\n");
			pattrib->dot118021x_UncstKey.skey[0] = 0xff;
		}
	}

	#if DBG_MGMT_XMIT_ENC_DUMP
	/* before encrypt dump the management packet content */
	{
		int i;
		printk("Management pkt: ");
		for(i=0; i<pattrib->pktlen; i++)
		printk(" %02x ", pframe[i]);
		printk("=======\n");
	}
	#endif

	/* bakeup original management packet */
	_rtw_memcpy(tmp_buf, pframe, pattrib->pktlen);
	/* move to data portion */
	pframe += pattrib->hdrlen;

	if (pattrib->key_type != IEEE80211W_NO_KEY) {
		pattrib->encrypt = cipher;
		pattrib->bswenc = _TRUE;
	}

	/*
	* 802.11w encrypted management packet must be:
	* _AES_, _CCMP_256_, _GCMP_, _GCMP_256_
	*/
	switch (pattrib->encrypt) {
	case _AES_:
		pattrib->iv_len = 8;
		pattrib->icv_len = 8;
		UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, (*pn));
		CCMP_IV(pattrib->iv, pattrib->pn, kid);
		hw_security_zero_hdrlen = _TRUE;
		break;
	case _CCMP_256_:
		pattrib->iv_len = 8;
		pattrib->icv_len = 16;
		UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, (*pn));
		CCMP_IV(pattrib->iv, pattrib->pn, kid);
		hw_security_zero_hdrlen = _TRUE;
		break;
	case _GCMP_:
	case _GCMP_256_:
		pattrib->iv_len = 8;
		pattrib->icv_len = 16;
		UPDATE_TKIP_CCMP_GCMP_PN(pattrib->pn, (*pn));
		GCMP_IV(pattrib->iv, pattrib->pn, kid);
		hw_security_zero_hdrlen = _TRUE;
		break;
#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
	case _SMS4_:
	case _GCM_SM4_:
		pattrib->iv_len = 18;
		pattrib->icv_len = 16;
		if (bmcst)
			rtw_wapi_get_iv(padapter, NULL, kid, pattrib->iv);
		else
			rtw_wapi_get_iv(padapter, psta, kid, pattrib->iv);
		break;
#endif
	default:
		goto xmitframe_coalesce_fail;
	}

	if (pattrib->encrypt &&
	(padapter->securitypriv.sw_encrypt == _TRUE || psta->hw_decrypted == _FALSE)) {
		pattrib->bswenc = _TRUE;
	} else {
		/* only right key can use HW encrypt */
		if (pattrib->key_type == IEEE80211W_RIGHT_KEY)
			pattrib->bswenc = _FALSE;
		else
			pattrib->bswenc = _TRUE;
	}

	/* at the moment the security CAM may be cleaned already --> use SW encryption */
	if (force_sw_enc)
		pattrib->bswenc = _TRUE;

	if ((pattrib->bswenc == _FALSE) &&
	    (hw_security_zero_hdrlen == _TRUE) &&
	    (padapter->dvobj->phl_com->dev_cap.sec_cap.hw_form_hdr)) {
		pattrib->iv_len = 0;
	}

	/* insert iv header into management frame */
	_rtw_memcpy(pframe, pattrib->iv, pattrib->iv_len);
	pframe += pattrib->iv_len;
	/* copy mgmt data portion after CCMP header */
	_rtw_memcpy(pframe, tmp_buf + pattrib->hdrlen, pattrib->pktlen - pattrib->hdrlen);
	/* move pframe to end of mgmt pkt */
	pframe += pattrib->pktlen - pattrib->hdrlen;
	/* add 8 bytes CCMP IV header to length */
	pattrib->pktlen += pattrib->iv_len;

	#if DBG_MGMT_XMIT_ENC_DUMP
	/* dump management packet include AES IV header */
	{
		int i;
		printk("Management pkt + IV: ");
		/* for(i=0; i<pattrib->pktlen; i++) */

		printk("@@@@@@@@@@@@@\n");
	}
	#endif

	if (!pattrib->bswenc) {
		pattrib->key_idx = kid;
		pattrib->last_txcmdsz = pattrib->pktlen;
		SetPrivacy(mem_start);
		goto xmitframe_coalesce_success;
	}

	if ((pattrib->icv_len > 0) && (pattrib->bswenc)) {
		_rtw_memcpy(pframe, pattrib->icv, pattrib->icv_len);
		pframe += pattrib->icv_len;
	}
	/* add 8 bytes MIC */
	pattrib->pktlen += pattrib->icv_len;
	/* set final tx command size */
	pattrib->last_txcmdsz = pattrib->pktlen;

	/* set protected bit must be beofre SW encrypt */
	SetPrivacy(mem_start);

	#if DBG_MGMT_XMIT_ENC_DUMP
	/* dump management packet include AES header */
	{
		int i;
		printk("prepare to enc Management pkt + IV: ");
		for (i = 0; i < pattrib->pktlen; i++)
			printk(" %02x ", mem_start[i]);
		printk("@@@@@@@@@@@@@\n");
	}
	#endif

	/* software encrypt */
	/* move to core_wlan_sw_encrypt() because of new txreq architecture */

xmitframe_coalesce_success:
	_rtw_spinunlock_bh(&padapter->security_key_mutex);
	rtw_mfree(BIP_AAD, ori_len);
	return _SUCCESS;

xmitframe_coalesce_fail:
	_rtw_spinunlock_bh(&padapter->security_key_mutex);
	rtw_mfree(BIP_AAD, ori_len);

	return _FAIL;
}
#endif /* defined(CONFIG_IEEE80211W) || defined(CONFIG_RTW_MESH) */

/* Logical Link Control(LLC) SubNetwork Attachment Point(SNAP) header
 * IEEE LLC/SNAP header contains 8 octets
 * First 3 octets comprise the LLC portion
 * SNAP portion, 5 octets, is divided into two fields:
 *	Organizationally Unique Identifier(OUI), 3 octets,
 *	type, defined by that organization, 2 octets.
 */
s32 rtw_put_snap(u8 *data, u16 h_proto)
{
	struct ieee80211_snap_hdr *snap;
	u8 *oui;


	snap = (struct ieee80211_snap_hdr *)data;
	snap->dsap = 0xaa;
	snap->ssap = 0xaa;
	snap->ctrl = 0x03;

	if (h_proto == 0x8137 || h_proto == 0x80f3)
		oui = P802_1H_OUI;
	else
		oui = RFC1042_OUI;

	snap->oui[0] = oui[0];
	snap->oui[1] = oui[1];
	snap->oui[2] = oui[2];

	*(u16 *)(data + SNAP_SIZE) = htons(h_proto);


	return SNAP_SIZE + sizeof(u16);
}

void rtw_update_protection(_adapter *padapter, u8 *ie, uint ie_len)
{

	uint	protection;
	u8	*perp;
	sint	 erp_len;
	struct	xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct	registry_priv *pregistrypriv = &padapter->registrypriv;


	switch (pxmitpriv->vcs_setting) {
	case DISABLE_VCS:
		pxmitpriv->vcs = NONE_VCS;
		break;

	case ENABLE_VCS:
		break;

	case AUTO_VCS:
	default:
		perp = rtw_get_ie(ie, _ERPINFO_IE_, &erp_len, ie_len);
		if (perp == NULL)
			pxmitpriv->vcs = NONE_VCS;
		else {
			protection = (*(perp + 2)) & BIT(1);
			if (protection) {
				if (pregistrypriv->vcs_type == RTS_CTS)
					pxmitpriv->vcs = RTS_CTS;
				else
					pxmitpriv->vcs = CTS_TO_SELF;
			} else
				pxmitpriv->vcs = NONE_VCS;
		}

		break;

	}


}

static void rtw_count_tx_wmm_stats(_adapter *padapter, u8 priority)
{
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;
	u8 index = XMIT_BE_QUEUE;

	switch (priority) {
		case 0:
		case 3:
			index = XMIT_BE_QUEUE;
			break;
		case 1:
		case 2:
			index = XMIT_BK_QUEUE;
			break;
		case 4:
		case 5:
			index = XMIT_VI_QUEUE;
			break;
		case 6:
		case 7:
			index = XMIT_VO_QUEUE;
			break;
	}
	pxmitpriv->tx_wmm_pkts[index]++;
}

static void rtw_reverse_count_tx_wmm_stats(_adapter *padapter, u8 priority, u8 pkt_cnt)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	u8 index = XMIT_BE_QUEUE;

	switch (priority) {
		case 0:
		case 3:
			index = XMIT_BE_QUEUE;
			break;
		case 1:
		case 2:
			index = XMIT_BK_QUEUE;
			break;
		case 4:
		case 5:
			index = XMIT_VI_QUEUE;
			break;
		case 6:
		case 7:
			index = XMIT_VO_QUEUE;
			break;
	}
	pxmitpriv->tx_wmm_pkts[index] -= pkt_cnt;
}

#ifdef CONFIG_CORE_TXSC
void rtw_count_tx_stats_tx_req(_adapter *padapter, struct rtw_xmit_req *txreq, struct sta_info *psta)
{
	struct stainfo_stats *pstats = NULL;
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;
	u32 sz = 0;

	if (txreq->mdata.type == RTW_PHL_PKT_TYPE_DATA) {
		pmlmepriv->LinkDetectInfo.NumTxOkInPeriod++;
		pxmitpriv->tx_pkts += (txreq->pkt_cnt - 1);
		sz = txreq->mdata.pktlen - RTW_SZ_LLC - (txreq->mdata.hdr_len << 1);
		switch (txreq->mdata.sec_type) {
			case RTW_ENC_WEP104:
			case RTW_ENC_WEP40:
				sz -= 4;
				break;
			case RTW_ENC_TKIP:
				sz -= 8;
				break;
			case RTW_ENC_CCMP:
				sz -= 8;
				break;
			case RTW_ENC_WAPI:
			case RTW_ENC_GCMSMS4:
				sz -= 18;
				break;
			case RTW_ENC_GCMP256:
			case RTW_ENC_GCMP:
			case RTW_ENC_CCMP256:
				sz -= 8;
				break;
			default:
				break;
		}

		pxmitpriv->tx_bytes += sz;

		rtw_count_tx_wmm_stats(padapter, txreq->mdata.tid);

		if (psta) {
			pstats = &psta->sta_stats;
			pstats->tx_pkts += (txreq->pkt_cnt - 1);
			pstats->tx_bytes += sz;

			/* for speedtest fast reaction to turn on amsdu */
			#ifdef CONFIG_TXSC_AMSDU
			if (pxmitpriv->txsc_amsdu_enable == 1 &&
				psta->txsc_amsdu_num == 0 &&
				padapter->registrypriv.wifi_mib.amsdu_pps > 0) {
				if ((pstats->tx_pkts - pstats->last_tx_pkts) > padapter->registrypriv.wifi_mib.amsdu_pps) {
					psta->txsc_amsdu_num = psta->txsc_amsdu_max / 2;
					if (psta->txsc_amsdu_num <= AMSDU_0_MAX_NUM)
						psta->txsc_amsdu_size = AMSDU_0_SIZE - CORE_TXSC_WLHDR_SIZE;
					else if (psta->txsc_amsdu_num <= AMSDU_1_MAX_NUM)
						psta->txsc_amsdu_size = AMSDU_1_SIZE - CORE_TXSC_WLHDR_SIZE;
					else
						psta->txsc_amsdu_size = AMSDU_2_SIZE - CORE_TXSC_WLHDR_SIZE;
					RTW_PRINT("set sta amsdu on:%pM txsc_amsdu_num=%d txsc_amsdu_size=%d\n",
						psta->phl_sta->mac_addr, psta->txsc_amsdu_num, psta->txsc_amsdu_size);
				}
			}
			#endif
		}

		if (txreq->mdata.bc && txreq->mdata.mc) {
			pxmitpriv->tx_mc_pkts++;
			pxmitpriv->tx_mc_bytes += sz;
		}
		else if(!txreq->mdata.bc && txreq->mdata.mc) {
			pxmitpriv->tx_bc_pkts++;
			pxmitpriv->tx_bc_bytes += sz;
		}
		else {
			pxmitpriv->tx_uc_pkts++;
			pxmitpriv->tx_uc_bytes += sz;
		}
	}
}

void rtw_reverse_count_tx_stats_tx_req(_adapter *padapter, struct rtw_xmit_req *txreq, struct sta_info *psta)
{
	struct stainfo_stats *pstats = NULL;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	u32 sz = 0;

	if (txreq->mdata.type == RTW_PHL_PKT_TYPE_DATA) {
		pmlmepriv->LinkDetectInfo.NumTxOkInPeriod--;
		pxmitpriv->tx_pkts -= (txreq->pkt_cnt - 1);
		sz = txreq->mdata.pktlen - RTW_SZ_LLC - (txreq->mdata.hdr_len << 1);
		switch (txreq->mdata.sec_type) {
			case RTW_ENC_WEP104:
			case RTW_ENC_WEP40:
				sz -= 4;
				break;
			case RTW_ENC_TKIP:
				sz -= 8;
				break;
			case RTW_ENC_CCMP:
				sz -= 8;
				break;
			case RTW_ENC_WAPI:
			case RTW_ENC_GCMSMS4:
				sz -= 18;
				break;
			case RTW_ENC_GCMP256:
			case RTW_ENC_GCMP:
			case RTW_ENC_CCMP256:
				sz -= 8;
				break;
			default:
				break;
		}
		pxmitpriv->tx_bytes -= sz;

		rtw_reverse_count_tx_wmm_stats(padapter, txreq->mdata.tid, (txreq->pkt_cnt - 1));

		if (psta) {
			pstats = &psta->sta_stats;
			pstats->tx_pkts -= (txreq->pkt_cnt - 1);
			pstats->tx_bytes -= sz;
		}
		if (txreq->mdata.bc && txreq->mdata.mc) {
			pxmitpriv->tx_mc_pkts--;
			pxmitpriv->tx_mc_bytes -= sz;
		}
		else if(!txreq->mdata.bc && txreq->mdata.mc) {
			pxmitpriv->tx_bc_pkts--;
			pxmitpriv->tx_bc_bytes -= sz;
		}
		else {
			pxmitpriv->tx_uc_pkts--;
			pxmitpriv->tx_uc_bytes -= sz;
		}
	}
}

#endif

void rtw_count_tx_stats(_adapter *padapter, struct xmit_frame *pxmitframe, int sz)
{
	struct sta_info *psta = NULL;
	struct stainfo_stats *pstats = NULL;
	struct xmit_priv	*pxmitpriv = &padapter->xmitpriv;
	struct mlme_priv	*pmlmepriv = &padapter->mlmepriv;


	if (pxmitframe->xftype == RTW_TX_OS) {
		pmlmepriv->LinkDetectInfo.NumTxOkInPeriod++;
		pxmitpriv->tx_pkts++;
		pxmitpriv->tx_bytes += sz;

		rtw_count_tx_wmm_stats(padapter, pxmitframe->attrib.priority);
	#if defined(WFO_VIRT_RECEIVER)
		if (wfo_check_offload(padapter)) {
			sync_tx_stats(padapter->iface_id, pxmitpriv);
		}
	#endif /* WFO_VIRT_RECEIVER */

		psta = pxmitframe->attrib.psta;
		if (psta) {
			pstats = &psta->sta_stats;

			pstats->tx_pkts++;
			pstats->tx_bytes += sz;
			#if defined(CONFIG_CHECK_LEAVE_LPS) && defined(CONFIG_LPS_CHK_BY_TP)
			if (adapter_to_pwrctl(padapter)->lps_chk_by_tp)
				traffic_check_for_leave_lps_by_tp(padapter, _TRUE, psta);
			#endif /* CONFIG_LPS */
		}
		if (is_multicast_mac_addr(pxmitframe->attrib.ra)) {
			pxmitpriv->tx_mc_pkts++;
			pxmitpriv->tx_mc_bytes += sz;
		}
		else if(is_broadcast_mac_addr(pxmitframe->attrib.ra)) {
			pxmitpriv->tx_bc_pkts++;
			pxmitpriv->tx_bc_bytes += sz;
		}
		else {
			pxmitpriv->tx_uc_pkts++;
			pxmitpriv->tx_uc_bytes += sz;
		}

#ifdef CONFIG_CHECK_LEAVE_LPS
		/* traffic_check_for_leave_lps(padapter, _TRUE); */
#endif /* CONFIG_CHECK_LEAVE_LPS */
	} else if (pxmitframe->xftype == RTW_TX_DRV_MGMT) {
		pxmitpriv->tx_mgmt_pkts++;
	}
}

void rtw_reverse_count_tx_stats(_adapter *padapter, struct xmit_frame *pxmitframe, int sz)
{
	struct sta_info *psta = NULL;
	struct stainfo_stats *pstats = NULL;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;

	if (pxmitframe->xftype == RTW_TX_OS) {
		pmlmepriv->LinkDetectInfo.NumTxOkInPeriod--;
		pxmitpriv->tx_pkts--;
		pxmitpriv->tx_bytes -= sz;

		rtw_reverse_count_tx_wmm_stats(padapter, pxmitframe->attrib.priority, 1);

		psta = pxmitframe->attrib.psta;
		if (psta) {
			pstats = &psta->sta_stats;

			pstats->tx_pkts--;
			pstats->tx_bytes -= sz;
		}
		if (is_multicast_mac_addr(pxmitframe->attrib.ra)) {
			pxmitpriv->tx_mc_pkts--;
			pxmitpriv->tx_mc_bytes -= sz;
		}
		else if(is_broadcast_mac_addr(pxmitframe->attrib.ra)) {
			pxmitpriv->tx_bc_pkts--;
			pxmitpriv->tx_bc_bytes -= sz;
		}
		else {
			pxmitpriv->tx_uc_pkts--;
			pxmitpriv->tx_uc_bytes -= sz;
		}

	} else if (pxmitframe->xftype == RTW_TX_DRV_MGMT) {
		pxmitpriv->tx_mgmt_pkts--;
	}
}

#if 0 /*CONFIG_CORE_XMITBUF*/
static struct xmit_buf *__rtw_alloc_cmd_xmitbuf(struct xmit_priv *pxmitpriv,
		enum cmdbuf_type buf_type)
{
	struct xmit_buf *pxmitbuf =  NULL;


	pxmitbuf = &pxmitpriv->pcmd_xmitbuf[buf_type];
	if (pxmitbuf !=  NULL) {
		pxmitbuf->priv_data = NULL;

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
		pxmitbuf->len = 0;
		pxmitbuf->pdata = pxmitbuf->ptail = pxmitbuf->phead;
		pxmitbuf->agg_num = 0;
		pxmitbuf->pg_num = 0;
#endif
#ifdef CONFIG_PCI_HCI
		pxmitbuf->len = 0;
#ifdef CONFIG_TRX_BD_ARCH
		/*pxmitbuf->buf_desc = NULL;*/
#else
		pxmitbuf->desc = NULL;
#endif
#endif

		if (pxmitbuf->sctx) {
			RTW_INFO("%s pxmitbuf->sctx is not NULL\n", __func__);
			rtw_sctx_done_err(&pxmitbuf->sctx, RTW_SCTX_DONE_BUF_ALLOC);
		}
	} else
		RTW_INFO("%s fail, no xmitbuf available !!!\n", __func__);

	return pxmitbuf;
}

struct xmit_frame *__rtw_alloc_cmdxmitframe(struct xmit_priv *pxmitpriv,
		enum cmdbuf_type buf_type)
{
	struct xmit_frame		*pcmdframe;
	struct xmit_buf		*pxmitbuf;

	#if 1/* XFRAME_CMD */
	pcmdframe = rtw_alloc_xmitframe_cmd(pxmitpriv);
	#else
	pcmdframe = rtw_alloc_xmitframe(pxmitpriv);
	#endif
	if (pcmdframe == NULL) {
		RTW_INFO("%s, alloc xmitframe fail\n", __FUNCTION__);
		return NULL;
	}

	pxmitbuf = __rtw_alloc_cmd_xmitbuf(pxmitpriv, buf_type);
	if (pxmitbuf == NULL) {
		RTW_INFO("%s, alloc xmitbuf fail\n", __FUNCTION__);
		rtw_free_xmitframe(pxmitpriv, pcmdframe);
		return NULL;
	}

	pcmdframe->frame_tag = MGNT_FRAMETAG;

	pcmdframe->pxmitbuf = pxmitbuf;

	pcmdframe->buf_addr = pxmitbuf->pbuf;

	/* initial memory to zero */
	_rtw_memset(pcmdframe->buf_addr, 0, MAX_CMDBUF_SZ);

	pxmitbuf->priv_data = pcmdframe;

	return pcmdframe;

}

struct xmit_buf *rtw_alloc_xmitbuf_ext(struct xmit_priv *pxmitpriv)
{
	struct xmit_buf *pxmitbuf =  NULL;
	_list *plist, *phead;
	_queue *pfree_queue = &pxmitpriv->free_xmit_extbuf_queue;
	unsigned long sp_flags;

	_rtw_spinlock_irq(&pfree_queue->lock, &sp_flags);

	if (_rtw_queue_empty(pfree_queue) == _TRUE)
		pxmitbuf = NULL;
	else {

		phead = get_list_head(pfree_queue);

		plist = get_next(phead);

		pxmitbuf = LIST_CONTAINOR(plist, struct xmit_buf, list);

		rtw_list_delete(&(pxmitbuf->list));
	}

	if (pxmitbuf !=  NULL) {
		pxmitpriv->free_xmit_extbuf_cnt--;
#ifdef DBG_XMIT_BUF_EXT
		RTW_INFO("DBG_XMIT_BUF_EXT ALLOC no=%d,  free_xmit_extbuf_cnt=%d\n", pxmitbuf->no, pxmitpriv->free_xmit_extbuf_cnt);
#endif


		pxmitbuf->priv_data = NULL;

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
		pxmitbuf->len = 0;
		pxmitbuf->pdata = pxmitbuf->ptail = pxmitbuf->phead;
		pxmitbuf->agg_num = 1;
#endif
#ifdef CONFIG_PCI_HCI
		pxmitbuf->len = 0;
#ifdef CONFIG_TRX_BD_ARCH
		/*pxmitbuf->buf_desc = NULL;*/
#else
		pxmitbuf->desc = NULL;
#endif
#endif

		if (pxmitbuf->sctx) {
			RTW_INFO("%s pxmitbuf->sctx is not NULL\n", __func__);
			rtw_sctx_done_err(&pxmitbuf->sctx, RTW_SCTX_DONE_BUF_ALLOC);
		}

	}

	_rtw_spinunlock_irq(&pfree_queue->lock, &sp_flags);


	return pxmitbuf;
}

s32 rtw_free_xmitbuf_ext(struct xmit_priv *pxmitpriv, struct xmit_buf *pxmitbuf)
{
	_queue *pfree_queue = &pxmitpriv->free_xmit_extbuf_queue;
	unsigned long sp_flags;

	if (pxmitbuf == NULL)
		return _FAIL;

	_rtw_spinlock_irq(&pfree_queue->lock, &sp_flags);

	rtw_list_delete(&pxmitbuf->list);

	rtw_list_insert_tail(&(pxmitbuf->list), get_list_head(pfree_queue));
	pxmitpriv->free_xmit_extbuf_cnt++;
#ifdef DBG_XMIT_BUF_EXT
	RTW_INFO("DBG_XMIT_BUF_EXT FREE no=%d, free_xmit_extbuf_cnt=%d\n", pxmitbuf->no , pxmitpriv->free_xmit_extbuf_cnt);
#endif

	_rtw_spinunlock_irq(&pfree_queue->lock, &sp_flags);


	return _SUCCESS;
}

struct xmit_buf *rtw_alloc_xmitbuf(struct xmit_priv *pxmitpriv)
{
	struct xmit_buf *pxmitbuf =  NULL;
	_list *plist, *phead;
	_queue *pfree_xmitbuf_queue = &pxmitpriv->free_xmitbuf_queue;
	unsigned long sp_flags;

	/* RTW_INFO("+rtw_alloc_xmitbuf\n"); */

	_rtw_spinlock_irq(&pfree_xmitbuf_queue->lock, &sp_flags);

	if (_rtw_queue_empty(pfree_xmitbuf_queue) == _TRUE)
		pxmitbuf = NULL;
	else {

		phead = get_list_head(pfree_xmitbuf_queue);

		plist = get_next(phead);

		pxmitbuf = LIST_CONTAINOR(plist, struct xmit_buf, list);

		rtw_list_delete(&(pxmitbuf->list));
	}

	if (pxmitbuf !=  NULL) {
		pxmitpriv->free_xmitbuf_cnt--;
#ifdef DBG_XMIT_BUF
		RTW_INFO("DBG_XMIT_BUF ALLOC no=%d,  free_xmitbuf_cnt=%d\n", pxmitbuf->no, pxmitpriv->free_xmitbuf_cnt);
#endif
		/* RTW_INFO("alloc, free_xmitbuf_cnt=%d\n", pxmitpriv->free_xmitbuf_cnt); */

		pxmitbuf->priv_data = NULL;

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
		pxmitbuf->len = 0;
		pxmitbuf->pdata = pxmitbuf->ptail = pxmitbuf->phead;
		pxmitbuf->agg_num = 0;
		pxmitbuf->pg_num = 0;
#endif
#ifdef CONFIG_PCI_HCI
		pxmitbuf->len = 0;
#ifdef CONFIG_TRX_BD_ARCH
		/*pxmitbuf->buf_desc = NULL;*/
#else
		pxmitbuf->desc = NULL;
#endif
#endif

		if (pxmitbuf->sctx) {
			RTW_INFO("%s pxmitbuf->sctx is not NULL\n", __func__);
			rtw_sctx_done_err(&pxmitbuf->sctx, RTW_SCTX_DONE_BUF_ALLOC);
		}
	}
#ifdef DBG_XMIT_BUF
	else
		RTW_INFO("DBG_XMIT_BUF rtw_alloc_xmitbuf return NULL\n");
#endif

	_rtw_spinunlock_irq(&pfree_xmitbuf_queue->lock, &sp_flags);


	return pxmitbuf;
}

s32 rtw_free_xmitbuf(struct xmit_priv *pxmitpriv, struct xmit_buf *pxmitbuf)
{
	_queue *pfree_xmitbuf_queue = &pxmitpriv->free_xmitbuf_queue;
	unsigned long sp_flags;

	/* RTW_INFO("+rtw_free_xmitbuf\n"); */

	if (pxmitbuf == NULL)
		return _FAIL;

	if (pxmitbuf->sctx) {
		RTW_INFO("%s pxmitbuf->sctx is not NULL\n", __func__);
		rtw_sctx_done_err(&pxmitbuf->sctx, RTW_SCTX_DONE_BUF_FREE);
	}

	if (pxmitbuf->buf_tag == XMITBUF_CMD) {
	} else if (pxmitbuf->buf_tag == XMITBUF_MGNT)
		rtw_free_xmitbuf_ext(pxmitpriv, pxmitbuf);
	else {
		_rtw_spinlock_irq(&pfree_xmitbuf_queue->lock, &sp_flags);

		rtw_list_delete(&pxmitbuf->list);

		rtw_list_insert_tail(&(pxmitbuf->list), get_list_head(pfree_xmitbuf_queue));

		pxmitpriv->free_xmitbuf_cnt++;
		/* RTW_INFO("FREE, free_xmitbuf_cnt=%d\n", pxmitpriv->free_xmitbuf_cnt); */
#ifdef DBG_XMIT_BUF
		RTW_INFO("DBG_XMIT_BUF FREE no=%d, free_xmitbuf_cnt=%d\n", pxmitbuf->no , pxmitpriv->free_xmitbuf_cnt);
#endif
		_rtw_spinunlock_irq(&pfree_xmitbuf_queue->lock, &sp_flags);
	}


	return _SUCCESS;
}
#endif

void rtw_init_xmitframe(struct xmit_frame *pxframe)
{
	if (pxframe !=  NULL) { /* default value setting */
		#if 0 /*CONFIG_CORE_XMITBUF*/
		pxframe->buf_addr = NULL;
		pxframe->pxmitbuf = NULL;
		#endif

		_rtw_memset(&pxframe->attrib, 0, sizeof(struct pkt_attrib));
		/* pxframe->attrib.psta = NULL; */

		pxframe->frame_tag = DATA_FRAMETAG;

#ifdef CONFIG_USB_HCI
		pxframe->pkt = NULL;
#ifdef USB_PACKET_OFFSET_SZ
		pxframe->pkt_offset = (PACKET_OFFSET_SZ / 8);
#else
		pxframe->pkt_offset = 1;/* default use pkt_offset to fill tx desc */
#endif

#ifdef CONFIG_USB_TX_AGGREGATION
		pxframe->agg_num = 1;
#endif

#endif /* #ifdef CONFIG_USB_HCI */

#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
		pxframe->pg_num = 1;
		pxframe->agg_num = 1;
#endif

#ifdef CONFIG_XMIT_MGMT_ACK
		pxframe->ack_rpt.txfb.txfb_cb = NULL;
		pxframe->ack_rpt.ctx_buf_len = 0;
#endif
#ifdef CONFIG_XMIT_ACK
		pxframe->ack_report = 0;
#endif
		XF_TXFREE_CNT = 0;
	}
}

/*
Calling context:
1. OS_TXENTRY
2. RXENTRY (rx_thread or RX_ISR/RX_CallBack)

If we turn on USE_RXTHREAD, then, no need for critical section.
Otherwise, we must use _enter/_exit critical to protect free_xmit_queue...

Must be very very cautious...

*/

#ifdef RTW_PHL_TX

#ifdef CONFIG_LMT_TXREQ
void rtw_core_upd_lmt_txreq_stats(_adapter *padapter,
				struct rtw_xmit_req *tx_req, struct xmit_frame *pxframe)
{
	struct xmit_txreq_buf *ptxreq_buf = NULL;
	struct sta_info *psta = NULL;
	u16 macid = tx_req->mdata.macid;
	u8 acq = 4;
	static const u8 tid_2_qsel[8] = {0 ,1, 1, 0, 2, 2, 3, 3};

	if (tx_req->mdata.type != RTW_PHL_PKT_TYPE_DATA)
		return;

	ptxreq_buf = (pxframe) ? pxframe->ptxreq_buf : (struct xmit_txreq_buf *)tx_req->os_priv;

	if (ptxreq_buf) { psta = ptxreq_buf->psta; }

	if (!psta)
		return;

	if (ATOMIC_READ(&psta->num_pending_txreq))
		ATOMIC_DEC(&psta->num_pending_txreq);

	if (tx_req->mdata.tid <= 7) {
		acq = tid_2_qsel[tx_req->mdata.tid];

		if (ATOMIC_READ(&psta->num_pending_txreq_ac[acq]))
			ATOMIC_DEC(&psta->num_pending_txreq_ac[acq]);
	}
}
#endif

#ifdef CONFIG_ONE_TXQ
void rtw_core_upd_txreq_ts(_adapter *padapter,
			struct rtw_xmit_req *tx_req, struct xmit_frame *pxframe) {
	struct xmit_txreq_buf *ptxreq_buf = NULL;
	struct sta_info *psta = NULL;
	struct sta_xmit_priv *pstaxmitpriv;
	struct sk_buff *tx_skb = NULL;
	u32 ts_consumed = 0;
	int i;

	if (tx_req->mdata.type != RTW_PHL_PKT_TYPE_DATA)
		return;

	if (padapter->dvobj->tx_mode != 2)
		return;

	ptxreq_buf = (pxframe) ? pxframe->ptxreq_buf : (struct xmit_txreq_buf *)tx_req->os_priv;

	if (ptxreq_buf)
		psta = ptxreq_buf->psta;

	if (!psta)
		return;

	pstaxmitpriv = &psta->sta_xmitpriv;
	if (pxframe) {
		ATOMIC_SUB(&pstaxmitpriv->txreq_ts_used, *(u32 *)&pxframe->pkt->cb[_SKB_CB_AIRTIME]);
		ATOMIC_DEC(&pstaxmitpriv->txreq_used);
	} else if (tx_req) {
		tx_skb = (struct sk_buff *)ptxreq_buf->pkt[0];
		if (tx_skb)
			ts_consumed += *(u32 *)&tx_skb->cb[_SKB_CB_AIRTIME];
		ATOMIC_SUB(&pstaxmitpriv->txreq_ts_used, ts_consumed);
		ATOMIC_DEC(&pstaxmitpriv->txreq_used);
	}
}
#endif

void core_tx_init_xmitframe(struct xmit_frame *pxframe)
{
	if (!pxframe)
		return;
	#if 0 /*CONFIG_CORE_XMITBUF*/
	pxframe->pxmitbuf = NULL;
	#endif
	_rtw_memset(&pxframe->attrib, 0, sizeof(struct pkt_attrib));
	/* TXREQ_QMGT */
	pxframe->ptxreq_buf = NULL;
	XF_TXREQ = NULL;

	XF_TXREQ_CNT = 0;
	XF_TXFREE_CNT = 0;
}

s32 core_tx_alloc_xmitframe(_adapter *padapter, struct xmit_frame **pxmitframe, struct sk_buff *pskb)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	#ifdef CONFIG_WFA_OFDMA_Logo_Test
	struct dvobj_priv *pdvobjpriv = adapter_to_dvobj(padapter);
	struct rtw_phl_com_t *phl_com = GET_HAL_DATA(pdvobjpriv);
	struct ru_grp_table *rugrptable = &phl_com->rugrptable[padapter->phl_role->id];
	struct ru_common_ctrl *ru_ctrl = &rugrptable->ru_ctrl;
	#endif
	struct xmit_frame *pxframe = NULL;
	_queue *pfree_xmit_queue = &pxmitpriv->free_xmit_queue;
	_list *plist, *phead;
	u32 nr_xmitframe_cnt = GET_HAL_SPEC(pdvobjpriv)->band_cap & BAND_CAP_5G ? NR_XMITFRAME_5G : NR_XMITFRAME_2G;

#ifdef CONFIG_WFA_OFDMA_Logo_Test
	struct sta_info *psta = NULL;
	u8 *ra;
#endif
#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	u8* alloc_addr = NULL;
#endif

	PHLTX_LOG;

	_rtw_spinlock_bh(&pfree_xmit_queue->lock);
	if ( check_net_lmt( padapter) )  {
		if ( pxmitpriv->free_xmitframe_cnt <  nr_xmitframe_cnt - 30 ) {
		   _rtw_spinunlock_bh(&pfree_xmit_queue->lock);
		   return FAIL;
		}
	}

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	if(!pxmitpriv->free_xmitframe_cnt)
	{
		_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
		pxmitpriv->full_xmitframe_cnt++;
		return FAIL;
	}
	else
	{
		#ifdef CONFIG_WFA_OFDMA_Logo_Test
		ra = pskb->data;
		psta = rtw_get_stainfo(&padapter->stapriv, ra);
		if (psta && (psta->state & WIFI_ASOC_STATE)) {
			psta->core_current_xframe_cnt++;

			if(phl_com->tx_phase){
				if(psta->core_current_xframe_cnt > (nr_xmitframe_cnt / ru_ctrl->netif_drop_thd))
				{
					psta->core_xframe_abort++;
					psta->core_current_xframe_cnt--;
					_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
					return FAIL;
				}
			}
		}
		#endif

		alloc_addr = rtw_zmalloc(sizeof(struct xmit_frame) + 4);
		if (alloc_addr == NULL)
		{
			_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
			pxmitpriv->alloc_fail_xmitframe_cnt++;
			return FAIL;
		}

		pxframe = (struct xmit_frame *)N_BYTE_ALIGMENT((SIZE_PTR)(alloc_addr), 4);
		pxframe->alloc_addr = alloc_addr;
		pxframe->padapter = pxmitpriv->adapter;
		pxframe->frame_tag = NULL_FRAMETAG;
		pxframe->pkt = NULL;

		_rtw_init_listhead(&(pxframe->list));
		rtw_list_insert_tail(&(pxframe->list), &(pxmitpriv->free_xmit_queue.queue));

		//allocate success
		pxmitpriv->free_xmitframe_cnt--;
	}
#else
	if (_rtw_queue_empty(pfree_xmit_queue) == _TRUE) {
		_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
		pxmitpriv->full_xmitframe_cnt++;
		return FAIL;
	} else {
		#ifdef CONFIG_WFA_OFDMA_Logo_Test
		ra = pskb->data;
		psta = rtw_get_stainfo(&padapter->stapriv, ra);
		if (psta && (psta->state & WIFI_ASOC_STATE)) {
			psta->core_current_xframe_cnt++;

			if(phl_com->tx_phase){
				if(psta->core_current_xframe_cnt > (nr_xmitframe_cnt/ru_ctrl->netif_drop_thd))
				{
					psta->core_xframe_abort++;
					psta->core_current_xframe_cnt--;
					_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
					return FAIL;
				}
			}
		}
		#endif

		phead = get_list_head(pfree_xmit_queue);

		plist = get_next(phead);

		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);

		rtw_list_delete(&XF_LIST);
		pxmitpriv->free_xmitframe_cnt--;
	}
#endif

	_rtw_spinunlock_bh(&pfree_xmit_queue->lock);

	core_tx_init_xmitframe(pxframe);

	*pxmitframe = pxframe;
	return SUCCESS;
}

s32 core_tx_free_xmitframe(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct xmit_priv 	*pxmitpriv = &padapter->xmitpriv;
	#ifdef CONFIG_WFA_OFDMA_Logo_Test
	struct dvobj_priv *pdvobjpriv = adapter_to_dvobj(padapter);
	struct rtw_phl_com_t *phl_com = GET_HAL_DATA(pdvobjpriv);
	struct ru_grp_table *rugrptable = &phl_com->rugrptable[padapter->phl_role->id];
	struct ru_common_ctrl *ru_ctrl = &rugrptable->ru_ctrl;
	#endif
	_queue *queue = NULL;
	/* TXREQ_QMGT */
	struct xmit_txreq_buf *ptxreq_buf = NULL;
	struct sta_info *psta = NULL;
	int i;
	struct rtw_xmit_req *txreq = NULL;
	struct rtw_pkt_buf_list *pkt_list = NULL;
#ifdef CONFIG_ONE_TXQ
	struct sta_xmit_priv *pstaxmitpriv;
#endif

	PHLTX_LOG;

	if (pxframe == NULL)
		goto exit;

	/* TXREQ_QMGT */
	ptxreq_buf = pxframe->ptxreq_buf;
	if (ptxreq_buf)
		psta = ptxreq_buf->psta;

	XF_TXFREE_CNT ++;

	/* ?? shall detail check, like free 1 2 3, not free 2 2 3 */
	/* ?? rtw_alloc_xmitframe_once case, seems no one use*/

	if(XF_TXFREE_CNT < XF_TXREQ_CNT)
		goto exit;

	#if 0 /*CONFIG_CORE_XMITBUF*/
	if(pxframe->pxmitbuf)
		rtw_free_xmitbuf(pxmitpriv, pxframe->pxmitbuf);
	#endif

#ifdef CONFIG_XMIT_MGMT_ACK
	if (pxframe->ack_rpt.txfb.ctx) {
		pxframe->ack_rpt.txfb.txfb_cb = NULL;
		if (pxframe->ack_rpt.ctx_buf_len) {
			rtw_mfree(pxframe->ack_rpt.txfb.ctx,
			          pxframe->ack_rpt.ctx_buf_len);
			pxframe->ack_rpt.ctx_buf_len = 0;
		}
		pxframe->ack_rpt.txfb.ctx = NULL;
	}
#endif

	for (i = 0; i < XF_TXREQ_CNT; i++) {
		txreq = &pxframe->phl_txreq[i];
#ifdef RTW_CORE_PKT_TRACE
		if(txreq->pktinfo)
		{
			_rtw_mfree(txreq->pktinfo, sizeof(struct rtw_pkt_trace_info) * txreq->trace_pkt_cnt);
			txreq->pktinfo = NULL;
		}
		txreq->trace_pkt_cnt = 0;
#endif
		if (!pxframe->buf_need_free)
			break;
		if (!(pxframe->buf_need_free & BIT(i)))
			continue;
		pxframe->buf_need_free &= ~BIT(i);

		rtw_warn_on(txreq->pkt_cnt != 1);
		pkt_list = (struct rtw_pkt_buf_list *)txreq->pkt_list;
		if (pkt_list->vir_addr && pkt_list->length)
			rtw_mfree(pkt_list->vir_addr, pkt_list->length);
	}

	/* TXREQ_QMGT */
	if (ptxreq_buf) {
		ptxreq_buf->psta = NULL;
		queue = padapter->pfree_txreq_queue;
		_rtw_spinlock_bh(&queue->lock);

		rtw_list_delete(&ptxreq_buf->list);
		rtw_list_insert_tail(&ptxreq_buf->list, get_list_head(queue));

		queue->qlen++;
		_rtw_spinunlock_bh(&queue->lock);
		#ifdef CONFIG_WFA_OFDMA_Logo_Test
		if(psta) {
			psta->core_current_txreq_cnt--;
			if(psta->core_current_txreq_cnt < 0) {
				psta->core_current_txreq_cnt = 0;
			}
		}
		#endif
	} else {
		if(pxframe->ext_tag==0)
			;//printk("%s:tx recyele: ptxreq_buf=NULL\n", __FUNCTION__);
	}

	if (pxframe->ext_tag == 0)
		queue = &pxmitpriv->free_xmit_queue;
	else if (pxframe->ext_tag == 1)
		queue = &pxmitpriv->free_xframe_ext_queue;
#if 0
	else if (pxframe->ext_tag == 2)/* XFRAME_CMD */
		queue = &pxmitpriv->free_xframe_cmd_queue;
#endif
	else
		rtw_warn_on(1);

#ifdef CONFIG_ETHER_PKT_AGG
		if (ptxreq_buf) {
			txreq = (struct rtw_xmit_req *) ptxreq_buf->txreq;
			if (txreq->isAggPkt == _AGG_TYPE_PKTLIST) {
				for (i=0; i < txreq->pkt_cnt; i++) {
					if(ptxreq_buf->pkt[i])
						rtw_os_pkt_complete(padapter, (struct sk_buff *)ptxreq_buf->pkt[i]);
				}
				pxframe->pkt = NULL;
			}
		}
#endif /* CONFIG_ETHER_PKT_AGG */

	_rtw_spinlock_bh(&queue->lock);

	rtw_os_xmit_complete(padapter, pxframe);

	rtw_list_delete(&XF_LIST);
#ifndef CONFIG_DYN_ALLOC_XMITFRAME
	rtw_list_insert_tail(&XF_LIST, get_list_head(queue));
#endif

	if (pxframe->ext_tag == 0) {
		pxmitpriv->free_xmitframe_cnt++;
		#ifdef CONFIG_WFA_OFDMA_Logo_Test
		if(psta) {
			psta->core_current_xframe_cnt--;
			if(psta->core_current_xframe_cnt < 0)
				psta->core_current_xframe_cnt = 0;
		}
		#endif
	}
	else if (pxframe->ext_tag == 1)
		pxmitpriv->free_xframe_ext_cnt++;
#if 0
	else if (pxframe->ext_tag == 2)/* XFRAME_CMD */
		pxmitpriv->free_xframe_cmd_cnt++;
#endif

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	if(pxframe->ext_tag == 1)
	{
		rtw_mfree(pxframe->phl_txreq, SZ_MGT_RING);
		rtw_os_xmit_resource_free(padapter, pxframe);
	}
	#ifdef CONFIG_RTW_DBG_TX_MGNT
	if (pxframe->ack_rpt.dbg_tx_mgnt) {
		RTW_PRINT("F %pX\n", pxframe);
	}
	#endif /* CONFIG_RTW_DBG_TX_MGNT */
	rtw_mfree(pxframe->alloc_addr, sizeof(struct xmit_frame) + 4);
#endif

	_rtw_spinunlock_bh(&queue->lock);

exit:
	return _SUCCESS;
}

s32 rtw_core_free_xmitframe_queue(_adapter *padapter, _queue *queue)
{
	_list *plist, *phead;
	struct xmit_frame *pxframe;
	s32 cnt = 0;

	_rtw_spinlock_bh(&queue->lock);
	phead = get_list_head(queue);
	plist = get_next(phead);

	while (plist != phead) {
		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);
		plist = get_next(plist);

		core_tx_free_xmitframe(padapter, pxframe);
		cnt++;
	}
	queue->qlen = 0;
	_rtw_spinunlock_bh(&queue->lock);

	return cnt;
}

/* CONFIG_VW_REAFINE */
static void core_free_sta_mgt_queue(_adapter *padapter, struct sta_xmit_priv *pstaxmitpriv)
{
	_queue *queue = &pstaxmitpriv->mgt_q;
	_list *phead, *plist;
	struct xmit_frame *pxframe;

	phead = get_list_head(queue);

	while (1) {
		_rtw_spinlock_bh(&queue->lock);
		plist = get_next(phead);
		if (plist != phead) {
			rtw_list_delete(plist);
			queue->qlen--;
		} else
			rtw_clear_bit(TXQ_MGT, &pstaxmitpriv->tx_pending_bitmap);
		_rtw_spinunlock_bh(&queue->lock);

		if (plist == phead)
			break;

		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);
		core_tx_free_xmitframe(padapter, pxframe);
	}
}

/* CONFIG_VW_REAFINE */
void rtw_core_free_sta_xmit_queue(_adapter *padapter, struct sta_xmit_priv *pstaxmitpriv)
{
	int cnt = 0;

	if (pstaxmitpriv->tx_pending_bitmap) {
		struct dvobj_priv *dvobj = padapter->dvobj;
		_queue *sta_queue;
		struct sta_tx_queue *txq;
		int q_idx;

		sta_queue = &dvobj->tx_pending_sta_queue;
		_rtw_spinlock_bh(&sta_queue->lock);
		if (rtw_is_list_empty(&pstaxmitpriv->tx_pending) == _FALSE) {
			rtw_list_delete(&pstaxmitpriv->tx_pending);
			sta_queue->qlen--;
		}
		_rtw_spinunlock_bh(&sta_queue->lock);

		sta_queue = &dvobj->ps_trigger_sta_queue;
		_rtw_spinlock_bh(&sta_queue->lock);
		if (rtw_is_list_empty(&pstaxmitpriv->ps_trigger) == _FALSE) {
			rtw_list_delete(&pstaxmitpriv->ps_trigger);
			sta_queue->qlen--;
		}
		_rtw_spinunlock_bh(&sta_queue->lock);

		core_free_sta_mgt_queue(padapter, pstaxmitpriv);

		for (q_idx = 0; q_idx < MAX_TXQ; q_idx++) {
			if (!(pstaxmitpriv->tx_pending_bitmap & BIT(q_idx)))
				continue;

			txq = &pstaxmitpriv->txq[q_idx];

			_rtw_spinlock_bh(&txq->qhead.lock);
			cnt += txq->qhead.qlen;
			__skb_queue_purge(&txq->qhead);
			rtw_clear_bit(q_idx, &pstaxmitpriv->tx_pending_bitmap);
			_rtw_spinunlock_bh(&txq->qhead.lock);
		}
		ATOMIC_SUB(&dvobj->sleep_q_total_len, cnt);
#ifdef CONFIG_ONE_TXQ
		ATOMIC_SUB(&dvobj->txq_total_len, cnt);
#endif
	}

	DBG_COUNTER_NUM(padapter->tx_logs.core_tx_swq_enq, cnt);
	ATOMIC_SUB(&pstaxmitpriv->txq_total_len, cnt);
}

#endif

struct xmit_frame *rtw_alloc_xmitframe(struct xmit_priv *pxmitpriv)/* (_queue *pfree_xmit_queue) */
{
	/*
		Please remember to use all the osdep_service api,
		and lock/unlock or _enter/_exit critical to protect
		pfree_xmit_queue
	*/

	struct xmit_frame *pxframe = NULL;
	_list *plist, *phead;
	_queue *pfree_xmit_queue = &pxmitpriv->free_xmit_queue;


	_rtw_spinlock_bh(&pfree_xmit_queue->lock);

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
		if(!pxmitpriv->free_xmitframe_cnt)
		{
			_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
			pxmitpriv->full_xmitframe_cnt++;
			return NULL;
		}
		else
		{
			u8* alloc_addr = rtw_zmalloc(sizeof(struct xmit_frame) + 4);
			if (alloc_addr == NULL)
			{
				_rtw_spinunlock_bh(&pfree_xmit_queue->lock);
				pxmitpriv->alloc_fail_xmitframe_cnt++;
				return NULL;
			}

			pxframe = (struct xmit_frame *)N_BYTE_ALIGMENT((SIZE_PTR)(alloc_addr), 4);
			pxframe->alloc_addr = alloc_addr;
			pxframe->padapter = pxmitpriv->adapter;
			pxframe->frame_tag = NULL_FRAMETAG;
			pxframe->pkt = NULL;

			_rtw_init_listhead(&(pxframe->list));
			rtw_list_insert_tail(&(pxframe->list), &(pxmitpriv->free_xmit_queue.queue));

			//allocate success
			pxmitpriv->free_xmitframe_cnt--;
		}
#else
	if (_rtw_queue_empty(pfree_xmit_queue) == _TRUE) {
		pxframe =  NULL;
	} else {
		phead = get_list_head(pfree_xmit_queue);

		plist = get_next(phead);

		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);

		rtw_list_delete(&(pxframe->list));
		pxmitpriv->free_xmitframe_cnt--;
	}
#endif

	_rtw_spinunlock_bh(&pfree_xmit_queue->lock);

	rtw_init_xmitframe(pxframe);

	return pxframe;
}

struct xmit_frame *rtw_alloc_xmitframe_ext(struct xmit_priv *pxmitpriv)
{
	struct xmit_frame *pxframe = NULL;
	_list *plist, *phead;
	_queue *queue = &pxmitpriv->free_xframe_ext_queue;
#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	u8* alloc_addr = NULL;
	u8* txreq_alloc_addr = NULL;
#endif

	_rtw_spinlock_bh(&queue->lock);

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	if(!pxmitpriv->free_xframe_ext_cnt)
	{
		_rtw_spinunlock_bh(&queue->lock);
		pxmitpriv->full_xframe_ext_cnt++;
		return NULL;
	}
	else
	{
		alloc_addr = rtw_zmalloc(sizeof(struct xmit_frame) + 4);
		if (alloc_addr == NULL)
		{
			_rtw_spinunlock_bh(&queue->lock);
			pxmitpriv->alloc_fail_xmitframe_ext_cnt++;
			goto err;
		}

		txreq_alloc_addr = rtw_zmalloc(SZ_MGT_RING);
		if (txreq_alloc_addr == NULL)
		{
			_rtw_spinunlock_bh(&queue->lock);
			pxmitpriv->alloc_fail_txreq_ext_cnt++;
			goto err;
		}

		pxframe = (struct xmit_frame *)N_BYTE_ALIGMENT((SIZE_PTR)(alloc_addr), 4);
		pxframe->alloc_addr = alloc_addr;
		pxframe->padapter = pxmitpriv->adapter;
		pxframe->frame_tag = NULL_FRAMETAG;
		pxframe->pkt = NULL;

		#if 0 /*CONFIG_CORE_XMITBUF*/
		pxframe->buf_addr = NULL;
		pxframe->pxmitbuf = NULL;
		#else
		/*alloc buf_addr*/
		if(!rtw_os_xmit_resource_alloc(pxmitpriv->adapter, pxframe)) {
			_rtw_spinunlock_bh(&queue->lock);
			goto err;
		}
		#endif

		pxframe->ext_tag = 1;

		/* MGT_TXREQ_QMGT */
		pxframe->phl_txreq = (struct rtw_xmit_req *)txreq_alloc_addr;
#ifdef PLATFORM_ECOS
		pxframe->phl_txreq->pkt_list = N_BYTE_ALIGNMENT(((SIZE_PTR)txreq_alloc_addr + sizeof(struct rtw_xmit_req)), SMP_CACHE_BYTES);
#else
		pxframe->phl_txreq->pkt_list = txreq_alloc_addr + sizeof(struct rtw_xmit_req);
#endif

		_rtw_init_listhead(&(pxframe->list));
		rtw_list_insert_tail(&(pxframe->list), &(pxmitpriv->free_xframe_ext_queue.queue));

		//allocate success
		pxmitpriv->free_xframe_ext_cnt--;
	}
#else
	if (_rtw_queue_empty(queue) == _TRUE) {
		pxframe =  NULL;
	} else {
		phead = get_list_head(queue);
		plist = get_next(phead);
		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);

		rtw_list_delete(&(pxframe->list));
		pxmitpriv->free_xframe_ext_cnt--;
	}
#endif

	_rtw_spinunlock_bh(&queue->lock);

	rtw_init_xmitframe(pxframe);

	return pxframe;

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
err:
	if(alloc_addr)
		rtw_mfree(alloc_addr, sizeof(struct xmit_frame) + 4);
	if(txreq_alloc_addr)
		rtw_mfree(txreq_alloc_addr, SZ_MGT_RING);
	return NULL;
#endif
}

#if 0
/* XFRAME_CMD */
struct xmit_frame *rtw_alloc_xmitframe_cmd(struct xmit_priv *pxmitpriv)
{
	struct xmit_frame *pxframe = NULL;
	_list *plist, *phead;
	_queue *pfree_xmit_queue = &pxmitpriv->free_xframe_cmd_queue;

	_rtw_spinlock_bh(&pfree_xmit_queue->lock);

	if (_rtw_queue_empty(pfree_xmit_queue) == _TRUE) {
		pxframe =  NULL;
		pxmitpriv->full_xframe_cmd_cnt++;
	} else {
		phead = get_list_head(pfree_xmit_queue);
		plist = get_next(phead);
		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);

		rtw_list_delete(&(pxframe->list));
		pxmitpriv->free_xframe_cmd_cnt--;
	}

	_rtw_spinunlock_bh(&pfree_xmit_queue->lock);

	rtw_init_xmitframe(pxframe);

	return pxframe;
}
#endif
struct xmit_frame *rtw_alloc_xmitframe_once(struct xmit_priv *pxmitpriv)
{
	struct xmit_frame *pxframe = NULL;
	u8 *alloc_addr;

	alloc_addr = rtw_zmalloc(sizeof(struct xmit_frame) + 4);

	if (alloc_addr == NULL)
		goto exit;

	pxframe = (struct xmit_frame *)N_BYTE_ALIGMENT((SIZE_PTR)(alloc_addr), 4);
	pxframe->alloc_addr = alloc_addr;

	pxframe->padapter = pxmitpriv->adapter;
	pxframe->frame_tag = NULL_FRAMETAG;

	pxframe->pkt = NULL;
	#if 0 /*CONFIG_CORE_XMITBUF*/
	pxframe->buf_addr = NULL;
	pxframe->pxmitbuf = NULL;
	#endif

	rtw_init_xmitframe(pxframe);

	RTW_INFO("################## %s ##################\n", __func__);

exit:
	return pxframe;
}

s32 rtw_free_xmitframe(struct xmit_priv *pxmitpriv, struct xmit_frame *pxmitframe)
{
	_queue *queue = NULL;
	_adapter *padapter = pxmitpriv->adapter;
	struct sk_buff *pndis_pkt = NULL;


	if (pxmitframe == NULL) {
		goto exit;
	}

	if (pxmitframe->pkt) {
		pndis_pkt = pxmitframe->pkt;
		pxmitframe->pkt = NULL;
	}

#if 0
	if (pxmitframe->alloc_addr) {
		RTW_INFO("################## %s with alloc_addr ##################\n", __func__);
		rtw_mfree(pxmitframe->alloc_addr, sizeof(struct xmit_frame) + 4);
		goto check_pkt_complete;
	}
#endif

	if (pxmitframe->ext_tag == 0)
		queue = &pxmitpriv->free_xmit_queue;
	else if (pxmitframe->ext_tag == 1)
		queue = &pxmitpriv->free_xframe_ext_queue;
#if 0
	else if (pxmitframe->ext_tag == 2)/* XFRAME_CMD */
		queue = &pxmitpriv->free_xframe_cmd_queue;
#endif
	else
		rtw_warn_on(1);

	_rtw_spinlock_bh(&queue->lock);

	rtw_list_delete(&pxmitframe->list);
#ifndef CONFIG_DYN_ALLOC_XMITFRAME
	rtw_list_insert_tail(&pxmitframe->list, get_list_head(queue));
#endif

	if (pxmitframe->ext_tag == 0)
		pxmitpriv->free_xmitframe_cnt++;
	else if (pxmitframe->ext_tag == 1)
		pxmitpriv->free_xframe_ext_cnt++;
#if 0
	else if (pxmitframe->ext_tag == 2)/* XFRAME_CMD */
		pxmitpriv->free_xframe_cmd_cnt++;
#endif

#ifdef CONFIG_DYN_ALLOC_XMITFRAME
	if(pxmitframe->ext_tag == 1)
	{
		rtw_mfree(pxmitframe->phl_txreq, SZ_MGT_RING);
		rtw_os_xmit_resource_free(padapter, pxmitframe);
	}
	rtw_mfree(pxmitframe->alloc_addr, sizeof(struct xmit_frame) + 4);
#endif

	_rtw_spinunlock_bh(&queue->lock);

check_pkt_complete:

	if (pndis_pkt)
		rtw_os_pkt_complete(padapter, pndis_pkt);

exit:


	return _SUCCESS;
}

void rtw_free_xmitframe_queue(struct xmit_priv *pxmitpriv, _queue *pframequeue)
{
	_list	*plist, *phead;
	struct	xmit_frame	*pxmitframe;


	_rtw_spinlock_bh(&(pframequeue->lock));

	phead = get_list_head(pframequeue);
	plist = get_next(phead);

	while (rtw_end_of_queue_search(phead, plist) == _FALSE) {

		pxmitframe = LIST_CONTAINOR(plist, struct xmit_frame, list);

		plist = get_next(plist);

		rtw_free_xmitframe(pxmitpriv, pxmitframe);

	}
	_rtw_spinunlock_bh(&(pframequeue->lock));

}

s32 rtw_xmitframe_enqueue(_adapter *padapter, struct xmit_frame *pxmitframe)
{
	DBG_COUNTER(padapter->tx_logs.core_tx_enqueue);
	if (rtw_xmit_classifier(padapter, pxmitframe) == _FAIL) {
		/*		pxmitframe->pkt = NULL; */
		return _FAIL;
	}

	return _SUCCESS;
}

static struct xmit_frame *dequeue_one_xmitframe(struct xmit_priv *pxmitpriv, struct hw_xmit *phwxmit, struct tx_servq *ptxservq, _queue *pframe_queue)
{
	_list	*xmitframe_plist, *xmitframe_phead;
	struct	xmit_frame	*pxmitframe = NULL;

	xmitframe_phead = get_list_head(pframe_queue);
	xmitframe_plist = get_next(xmitframe_phead);

	while ((rtw_end_of_queue_search(xmitframe_phead, xmitframe_plist)) == _FALSE) {
		pxmitframe = LIST_CONTAINOR(xmitframe_plist, struct xmit_frame, list);

		/* xmitframe_plist = get_next(xmitframe_plist); */

		/*#ifdef RTK_DMP_PLATFORM
		#ifdef CONFIG_USB_TX_AGGREGATION
				if((ptxservq->qcnt>0) && (ptxservq->qcnt<=2))
				{
					pxmitframe = NULL;

					rtw_tasklet_schedule(&pxmitpriv->xmit_tasklet);

					break;
				}
		#endif
		#endif*/
		rtw_list_delete(&pxmitframe->list);

		ptxservq->qcnt--;

		/* rtw_list_insert_tail(&pxmitframe->list, &phwxmit->pending); */

		/* ptxservq->qcnt--; */

		break;

		/* pxmitframe = NULL; */

	}

	return pxmitframe;
}

static struct xmit_frame *get_one_xmitframe(struct xmit_priv *pxmitpriv, struct hw_xmit *phwxmit, struct tx_servq *ptxservq, _queue *pframe_queue)
{
	_list	*xmitframe_plist, *xmitframe_phead;
	struct	xmit_frame	*pxmitframe = NULL;

	xmitframe_phead = get_list_head(pframe_queue);
	xmitframe_plist = get_next(xmitframe_phead);

	while ((rtw_end_of_queue_search(xmitframe_phead, xmitframe_plist)) == _FALSE) {
		pxmitframe = LIST_CONTAINOR(xmitframe_plist, struct xmit_frame, list);
		break;
	}

	return pxmitframe;
}

struct xmit_frame *rtw_get_xframe(struct xmit_priv *pxmitpriv, int *num_frame)
{
	_list *sta_plist, *sta_phead;
	struct hw_xmit *phwxmit_i = pxmitpriv->hwxmits;
	sint entry =  pxmitpriv->hwxmit_entry;

	struct hw_xmit *phwxmit;
	struct tx_servq *ptxservq = NULL;
	_queue *pframe_queue = NULL;
	struct xmit_frame *pxmitframe = NULL;
	_adapter *padapter = pxmitpriv->adapter;
	struct registry_priv	*pregpriv = &padapter->registrypriv;
	int i, inx[4];

	inx[0] = 0;
	inx[1] = 1;
	inx[2] = 2;
	inx[3] = 3;

	*num_frame = 0;

	/*No amsdu when wifi_spec on*/
	if (pregpriv->wifi_spec == 1) {
		return NULL;
	}

	_rtw_spinlock_bh(&pxmitpriv->lock);

	for (i = 0; i < entry; i++) {
		phwxmit = phwxmit_i + inx[i];

		sta_phead = get_list_head(phwxmit->sta_queue);
		sta_plist = get_next(sta_phead);

		while ((rtw_end_of_queue_search(sta_phead, sta_plist)) == _FALSE) {

			ptxservq = LIST_CONTAINOR(sta_plist, struct tx_servq, tx_pending);
			pframe_queue = &ptxservq->queue;

			if(ptxservq->qcnt)
			{
				*num_frame = ptxservq->qcnt;
				pxmitframe = get_one_xmitframe(pxmitpriv, phwxmit, ptxservq, pframe_queue);
				goto exit;
			}
			sta_plist = get_next(sta_plist);
		}
	}

exit:

	_rtw_spinunlock_bh(&pxmitpriv->lock);

	return pxmitframe;
}

#if 0/* CONFIG_VW_REFINE */
#ifdef RTW_PHL_TX
struct xmit_frame *core_dequeue_one_xframe(_queue *queue)
{
	_list *plist, *phead;
	struct xmit_frame *pxframe = NULL;

	phead = get_list_head(queue);
	plist = get_next(phead);

	if (plist != phead) {
		pxframe = LIST_CONTAINOR(plist, struct xmit_frame, list);
		rtw_list_delete(plist);
		queue->qlen--;
	}

	return pxframe;
}

struct xmit_frame *core_dequeue_xframe(struct xmit_priv *pxmitpriv)
{
	_list *phead, *plist;
	_queue *psta_queue;
	_queue *pframe_queue = NULL;
	struct sta_xmit_priv *pstaxmitpriv;
	struct tx_servq *ptxservq = NULL;
	struct xmit_frame *pxmitframe = NULL;
	int q_idx;

	_rtw_spinlock_bh(&pxmitpriv->lock);

	for (q_idx = 0; q_idx < TXQ_MAX; q_idx++) {
		psta_queue = &pxmitpriv->tx_pending_sta_queue[q_idx];
		phead = get_list_head(psta_queue);
		plist = get_next(phead);

		while (plist != phead) {
			ptxservq = LIST_CONTAINOR(plist, struct tx_servq, tx_pending);
			plist = get_next(plist);

			pstaxmitpriv = (struct sta_xmit_priv *)((u8*)ptxservq
					- q_idx * sizeof(struct tx_servq)
					- FIELD_OFFSET(struct sta_xmit_priv, swq));

			pframe_queue = &ptxservq->queue;
			pxmitframe = core_dequeue_one_xframe(pframe_queue);
			if (_rtw_queue_empty(pframe_queue)) {
				rtw_list_delete(&ptxservq->tx_pending);
				psta_queue->qlen--;
				pstaxmitpriv->tx_pending &= ~ BIT(q_idx);
			}

			if (pxmitframe) {
				pstaxmitpriv->swq_total_len--;
				goto exit;
			}
		}
	}

exit:
	_rtw_spinunlock_bh(&pxmitpriv->lock);

	return pxmitframe;
}
#endif
#endif

struct xmit_frame *rtw_dequeue_xframe(struct xmit_priv *pxmitpriv, struct hw_xmit *phwxmit_i, sint entry)
{
	_list *sta_plist, *sta_phead;
	struct hw_xmit *phwxmit;
	struct tx_servq *ptxservq = NULL;
	_queue *pframe_queue = NULL;
	struct xmit_frame *pxmitframe = NULL;
	_adapter *padapter = pxmitpriv->adapter;
	struct registry_priv	*pregpriv = &padapter->registrypriv;
	int i, inx[4];

	inx[0] = 0;
	inx[1] = 1;
	inx[2] = 2;
	inx[3] = 3;

	if (pregpriv->wifi_spec == 1) {
		int j;
#if 0
		if (flags < XMIT_QUEUE_ENTRY) {
			/* priority exchange according to the completed xmitbuf flags. */
			inx[flags] = 0;
			inx[0] = flags;
		}
#endif

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI) || defined(CONFIG_PCI_HCI)
		for (j = 0; j < 4; j++)
			inx[j] = pxmitpriv->wmm_para_seq[j];
#endif
	}

	_rtw_spinlock_bh(&pxmitpriv->lock);

	for (i = 0; i < entry; i++) {
		phwxmit = phwxmit_i + inx[i];

		/* _rtw_spinlock_irq(&phwxmit->sta_queue->lock, &sp_flags); */

		sta_phead = get_list_head(phwxmit->sta_queue);
		sta_plist = get_next(sta_phead);

		while ((rtw_end_of_queue_search(sta_phead, sta_plist)) == _FALSE) {

			ptxservq = LIST_CONTAINOR(sta_plist, struct tx_servq, tx_pending);

			pframe_queue = &ptxservq->queue;

			pxmitframe = dequeue_one_xmitframe(pxmitpriv, phwxmit, ptxservq, pframe_queue);

			if (pxmitframe) {
				phwxmit->accnt--;

				/* Remove sta node when there is no pending packets. */
				if (_rtw_queue_empty(pframe_queue)) /* must be done after get_next and before break */
					rtw_list_delete(&ptxservq->tx_pending);

				/* _rtw_spinunlock_irq(&phwxmit->sta_queue->lock, sp_flags); */

				goto exit;
			}

			sta_plist = get_next(sta_plist);

		}

		/* _rtw_spinunlock_irq(&phwxmit->sta_queue->lock, sp_flags); */

	}

exit:

	_rtw_spinunlock_bh(&pxmitpriv->lock);

	return pxmitframe;
}

#if 1
struct tx_servq *rtw_get_sta_pending(_adapter *padapter, struct sta_info *psta, sint up, u8 *ac)
{
	struct tx_servq *ptxservq = NULL;


	switch (up) {
	case 1:
	case 2:
		ptxservq = &(psta->sta_xmitpriv.bk_q);
		*(ac) = 3;
		break;

	case 4:
	case 5:
		ptxservq = &(psta->sta_xmitpriv.vi_q);
		*(ac) = 1;
		break;

	case 6:
	case 7:
		ptxservq = &(psta->sta_xmitpriv.vo_q);
		*(ac) = 0;
		break;

	case 0:
	case 3:
	default:
		ptxservq = &(psta->sta_xmitpriv.be_q);
		*(ac) = 2;
		break;

	}


	return ptxservq;
}
#else
__inline static struct tx_servq *rtw_get_sta_pending
(_adapter *padapter, _queue **ppstapending, struct sta_info *psta, sint up)
{
	struct tx_servq *ptxservq;
	struct hw_xmit *phwxmits =  padapter->xmitpriv.hwxmits;


#ifdef CONFIG_RTL8711

	if (IS_MCAST(psta->phl_sta->mac_addr)) {
		ptxservq = &(psta->sta_xmitpriv.be_q); /* we will use be_q to queue bc/mc frames in BCMC_stainfo */
		*ppstapending = &padapter->xmitpriv.bm_pending;
	} else
#endif
	{
		switch (up) {
		case 1:
		case 2:
			ptxservq = &(psta->sta_xmitpriv.bk_q);
			*ppstapending = &padapter->xmitpriv.bk_pending;
			(phwxmits + 3)->accnt++;
			break;

		case 4:
		case 5:
			ptxservq = &(psta->sta_xmitpriv.vi_q);
			*ppstapending = &padapter->xmitpriv.vi_pending;
			(phwxmits + 1)->accnt++;
			break;

		case 6:
		case 7:
			ptxservq = &(psta->sta_xmitpriv.vo_q);
			*ppstapending = &padapter->xmitpriv.vo_pending;
			(phwxmits + 0)->accnt++;
			break;

		case 0:
		case 3:
		default:
			ptxservq = &(psta->sta_xmitpriv.be_q);
			*ppstapending = &padapter->xmitpriv.be_pending;
			(phwxmits + 2)->accnt++;
			break;

		}

	}


	return ptxservq;
}
#endif

/*
 * Will enqueue pxmitframe to the proper queue,
 * and indicate it to xx_pending list.....
 */
s32 rtw_xmit_classifier(_adapter *padapter, struct xmit_frame *pxmitframe)
{
	u8	ac_index;
	struct sta_info	*psta;
	struct tx_servq	*ptxservq;
	struct pkt_attrib	*pattrib = &pxmitframe->attrib;
	struct hw_xmit	*phwxmits =  padapter->xmitpriv.hwxmits;
	sint res = _SUCCESS;


	DBG_COUNTER(padapter->tx_logs.core_tx_enqueue_class);

	/*
		if (pattrib->psta) {
			psta = pattrib->psta;
		} else {
			RTW_INFO("%s, call rtw_get_stainfo()\n", __func__);
			psta = rtw_get_stainfo(pstapriv, pattrib->ra);
		}
	*/

	psta = rtw_get_stainfo(&padapter->stapriv, pattrib->ra);
	if (pattrib->psta != psta) {
		DBG_COUNTER(padapter->tx_logs.core_tx_enqueue_class_err_sta);
		RTW_INFO("%s, pattrib->psta(%p) != psta(%p)\n", __func__, pattrib->psta, psta);
		return _FAIL;
	}

	if (psta == NULL) {
		DBG_COUNTER(padapter->tx_logs.core_tx_enqueue_class_err_nosta);
		res = _FAIL;
		RTW_INFO("rtw_xmit_classifier: psta == NULL\n");
		goto exit;
	}

	if (!(psta->state & WIFI_ASOC_STATE)) {
		DBG_COUNTER(padapter->tx_logs.core_tx_enqueue_class_err_fwlink);
		RTW_INFO("%s, psta->state(0x%x) != WIFI_ASOC_STATE\n", __func__, psta->state);
		return _FAIL;
	}

	ptxservq = rtw_get_sta_pending(padapter, psta, pattrib->priority, (u8 *)(&ac_index));

	/* _rtw_spinlock_irq(&pstapending->lock, &flags); */

	if (rtw_is_list_empty(&ptxservq->tx_pending))
		rtw_list_insert_tail(&ptxservq->tx_pending, get_list_head(phwxmits[ac_index].sta_queue));

	/* _rtw_spinlock_irq(&ptxservq->queue.lock, &sp_flags); */

	rtw_list_insert_tail(&pxmitframe->list, get_list_head(&ptxservq->queue));
	ptxservq->qcnt++;
	phwxmits[ac_index].accnt++;

	/* _rtw_spinunlock_irq(&ptxservq->queue.lock, &sp_flags); */

	/* _rtw_spinunlock_irq(&pstapending->lock, &flags); */

exit:


	return res;
}

void rtw_alloc_hwxmits(_adapter *padapter)
{
	struct hw_xmit *hwxmits;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;

	pxmitpriv->hwxmit_entry = HWXMIT_ENTRY;

	pxmitpriv->hwxmits = NULL;

	pxmitpriv->hwxmits = (struct hw_xmit *)rtw_zmalloc(sizeof(struct hw_xmit) * pxmitpriv->hwxmit_entry);

	if (pxmitpriv->hwxmits == NULL) {
		RTW_INFO("alloc hwxmits fail!...\n");
		return;
	}

	hwxmits = pxmitpriv->hwxmits;

	if (pxmitpriv->hwxmit_entry == 5) {
		/* pxmitpriv->bmc_txqueue.head = 0; */
		/* hwxmits[0] .phwtxqueue = &pxmitpriv->bmc_txqueue; */
		hwxmits[0] .sta_queue = &pxmitpriv->bm_pending;

		/* pxmitpriv->vo_txqueue.head = 0; */
		/* hwxmits[1] .phwtxqueue = &pxmitpriv->vo_txqueue; */
		hwxmits[1] .sta_queue = &pxmitpriv->vo_pending;

		/* pxmitpriv->vi_txqueue.head = 0; */
		/* hwxmits[2] .phwtxqueue = &pxmitpriv->vi_txqueue; */
		hwxmits[2] .sta_queue = &pxmitpriv->vi_pending;

		/* pxmitpriv->bk_txqueue.head = 0; */
		/* hwxmits[3] .phwtxqueue = &pxmitpriv->bk_txqueue; */
		hwxmits[3] .sta_queue = &pxmitpriv->bk_pending;

		/* pxmitpriv->be_txqueue.head = 0; */
		/* hwxmits[4] .phwtxqueue = &pxmitpriv->be_txqueue; */
		hwxmits[4] .sta_queue = &pxmitpriv->be_pending;

	} else if (pxmitpriv->hwxmit_entry == 4) {

		/* pxmitpriv->vo_txqueue.head = 0; */
		/* hwxmits[0] .phwtxqueue = &pxmitpriv->vo_txqueue; */
		hwxmits[0] .sta_queue = &pxmitpriv->vo_pending;

		/* pxmitpriv->vi_txqueue.head = 0; */
		/* hwxmits[1] .phwtxqueue = &pxmitpriv->vi_txqueue; */
		hwxmits[1] .sta_queue = &pxmitpriv->vi_pending;

		/* pxmitpriv->be_txqueue.head = 0; */
		/* hwxmits[2] .phwtxqueue = &pxmitpriv->be_txqueue; */
		hwxmits[2] .sta_queue = &pxmitpriv->be_pending;

		/* pxmitpriv->bk_txqueue.head = 0; */
		/* hwxmits[3] .phwtxqueue = &pxmitpriv->bk_txqueue; */
		hwxmits[3] .sta_queue = &pxmitpriv->bk_pending;
	} else {


	}


}

void rtw_free_hwxmits(_adapter *padapter)
{
	struct hw_xmit *hwxmits;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;

	hwxmits = pxmitpriv->hwxmits;
	if (hwxmits)
		rtw_mfree((u8 *)hwxmits, (sizeof(struct hw_xmit) * pxmitpriv->hwxmit_entry));
}

void rtw_init_hwxmits(struct hw_xmit *phwxmit, sint entry)
{
	sint i;
	for (i = 0; i < entry; i++, phwxmit++) {
		/* _rtw_spinlock_init(&phwxmit->xmit_lock); */
		/* _rtw_init_listhead(&phwxmit->pending);		 */
		/* phwxmit->txcmdcnt = 0; */
		phwxmit->accnt = 0;
	}
}

#ifdef CONFIG_BR_EXT
int rtw_br_client_tx(_adapter *padapter, struct sk_buff **pskb, void *br_port)
{
	struct sk_buff *skb = *pskb;
#ifdef CONFIG_RTW_A4_STA
	struct mlme_ext_priv *pmlmeext = &(padapter->mlmeextpriv);
	struct mlme_ext_info *pmlmeinfo = &(pmlmeext->mlmext_info);
#endif

	/* if(MLME_IS_STA(adapter) */
	{
		void dhcp_flag_bcast(_adapter *priv, struct sk_buff *skb);
		int res, is_vlan_tag = 0, i, do_nat25 = 1;
		unsigned short vlan_hdr = 0;
		struct sk_buff *newskb;

#if 0
		void *br_port = NULL;

		/* mac_clone_handle_frame(priv, skb); */

#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35))
		br_port = padapter->pnetdev->br_port;
#else   /* (LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35)) */
		rcu_read_lock();
		br_port = rcu_dereference(padapter->pnetdev->rx_handler_data);
		rcu_read_unlock();
#endif /* (LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35)) */
#endif

		_rtw_spinlock_bh(&padapter->br_ext_lock);
		if (!(skb->data[0] & 1) &&
		    br_port &&
		    memcmp(skb->data + MACADDRLEN, padapter->br_mac, MACADDRLEN) &&
		    *((unsigned short *)(skb->data + MACADDRLEN * 2)) != __constant_htons(ETH_P_8021Q) &&
		    *((unsigned short *)(skb->data + MACADDRLEN * 2)) == __constant_htons(ETH_P_IP) &&
		    !memcmp(padapter->scdb_mac, skb->data + MACADDRLEN, MACADDRLEN) && padapter->scdb_entry &&
			!(skb->cb[_SKB_CB_FLAGS] & _PKT_TYPE_URGENT)) {
			_rtw_memcpy(skb->data + MACADDRLEN, GET_MY_HWADDR(padapter), MACADDRLEN);
			padapter->scdb_entry->ageing_timer = jiffies;
			_rtw_spinunlock_bh(&padapter->br_ext_lock);
		} else
			/* if (!priv->pmib->ethBrExtInfo.nat25_disable)		 */
		{
			/*			if (priv->dev->br_port &&
			 *				 !_rtw_memcmp(skb->data+MACADDRLEN, priv->br_mac, MACADDRLEN)) { */
			if (skb_cloned(skb))
			{
				newskb = rtw_skb_copy(skb);
				if (newskb == NULL) {
					/* priv->ext_stats.tx_drops++; */
					DEBUG_ERR("TX DROP: rtw_skb_copy fail!\n");
					/* goto stop_proc; */
					_rtw_spinunlock_bh(&padapter->br_ext_lock);
					return -1;
				}
				rtw_skb_free(skb);
				*pskb = skb = newskb;
			}
#if 1
			if (*((unsigned short *)(skb->data + MACADDRLEN * 2)) == __constant_htons(ETH_P_8021Q)) {
				is_vlan_tag = 1;
				vlan_hdr = *((unsigned short *)(skb->data + MACADDRLEN * 2 + 2));
				for (i = 0; i < 6; i++)
					*((unsigned short *)(skb->data + MACADDRLEN * 2 + 2 - i * 2)) = *((unsigned short *)(skb->data + MACADDRLEN * 2 - 2 - i * 2));
				skb_pull(skb, 4);
			}
			/* if SA == br_mac && skb== IP  => copy SIP to br_ip ?? why */
			if (!memcmp(skb->data + MACADDRLEN, padapter->br_mac, MACADDRLEN) &&
			    (*((unsigned short *)(skb->data + MACADDRLEN * 2)) == __constant_htons(ETH_P_IP)))
				_rtw_memcpy(padapter->br_ip, skb->data + WLAN_ETHHDR_LEN + 12, 4);

			if (*((unsigned short *)(skb->data + MACADDRLEN * 2)) == __constant_htons(ETH_P_IP)) {
				if (memcmp(padapter->scdb_mac, skb->data + MACADDRLEN, MACADDRLEN)) {
					void *scdb_findEntry(_adapter *priv, unsigned char *macAddr, unsigned char *ipAddr);

					padapter->scdb_entry = (struct nat25_network_db_entry *)scdb_findEntry(padapter,
						skb->data + MACADDRLEN, skb->data + WLAN_ETHHDR_LEN + 12);
					if (padapter->scdb_entry != NULL) {
						_rtw_memcpy(padapter->scdb_mac, skb->data + MACADDRLEN, MACADDRLEN);
						_rtw_memcpy(padapter->scdb_ip, skb->data + WLAN_ETHHDR_LEN + 12, 4);
						padapter->scdb_entry->ageing_timer = jiffies;
						do_nat25 = 0;
					}
				} else {
					if (padapter->scdb_entry) {
						padapter->scdb_entry->ageing_timer = jiffies;
						do_nat25 = 0;
					} else {
						_rtw_memset(padapter->scdb_mac, 0, MACADDRLEN);
						_rtw_memset(padapter->scdb_ip, 0, 4);
					}
				}
			}
			_rtw_spinunlock_bh(&padapter->br_ext_lock);
#endif /* 1 */
#ifdef CONFIG_RTW_A4_STA
			if ((padapter->a4_enable == 1) && (pmlmeinfo->state & WIFI_FW_ASSOC_SUCCESS))
				do_nat25 = 0;
#endif
			if (do_nat25) {
				int nat25_db_handle(_adapter *priv, struct sk_buff *skb, int method);
				if (nat25_db_handle(padapter, skb, NAT25_CHECK) == 0) {
					#if 0
					struct sk_buff *newskb;

					if (is_vlan_tag) {
						skb_push(skb, 4);
						for (i = 0; i < 6; i++)
							*((unsigned short *)(skb->data + i * 2)) = *((unsigned short *)(skb->data + 4 + i * 2));
						*((unsigned short *)(skb->data + MACADDRLEN * 2)) = __constant_htons(ETH_P_8021Q);
						*((unsigned short *)(skb->data + MACADDRLEN * 2 + 2)) = vlan_hdr;
					}

					newskb = rtw_skb_copy(skb);
					if (newskb == NULL) {
						/* priv->ext_stats.tx_drops++; */
						DEBUG_ERR("TX DROP: rtw_skb_copy fail!\n");
						/* goto stop_proc; */
						return -1;
					}
					rtw_skb_free(skb);

					*pskb = skb = newskb;
					if (is_vlan_tag) {
						vlan_hdr = *((unsigned short *)(skb->data + MACADDRLEN * 2 + 2));
						for (i = 0; i < 6; i++)
							*((unsigned short *)(skb->data + MACADDRLEN * 2 + 2 - i * 2)) = *((unsigned short *)(skb->data + MACADDRLEN * 2 - 2 - i * 2));
						skb_pull(skb, 4);
					}
					#endif
				}

				if (skb_is_nonlinear(skb))
					DEBUG_ERR("%s(): skb_is_nonlinear!!\n", __FUNCTION__);


#if (LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 18))
				res = skb_linearize(skb, GFP_ATOMIC);
#else	/* (LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 18)) */
				res = skb_linearize(skb);
#endif /* (LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 18)) */
				if (res < 0) {
					DEBUG_ERR("TX DROP: skb_linearize fail!\n");
					/* goto free_and_stop; */
					return -1;
				}

				res = nat25_db_handle(padapter, skb, NAT25_INSERT);
				if (res < 0) {
					if (res == -2) {
						/* priv->ext_stats.tx_drops++; */
						DEBUG_ERR("TX DROP: nat25_db_handle fail!\n");
						/* goto free_and_stop; */
						return -1;

					}
					/* we just print warning message and let it go */
					/* DEBUG_WARN("%s()-%d: nat25_db_handle INSERT Warning!\n", __FUNCTION__, __LINE__); */
					/* return -1; */ /* return -1 will cause system crash on 2011/08/30! */
					return 0;
				}
			}

			_rtw_memcpy(skb->data + MACADDRLEN, GET_MY_HWADDR(padapter), MACADDRLEN);

			dhcp_flag_bcast(padapter, skb);

			if (is_vlan_tag) {
				skb_push(skb, 4);
				for (i = 0; i < 6; i++)
					*((unsigned short *)(skb->data + i * 2)) = *((unsigned short *)(skb->data + 4 + i * 2));
				*((unsigned short *)(skb->data + MACADDRLEN * 2)) = __constant_htons(ETH_P_8021Q);
				*((unsigned short *)(skb->data + MACADDRLEN * 2 + 2)) = vlan_hdr;
			}
		}
#if 0
		else {
			if (*((unsigned short *)(skb->data + MACADDRLEN * 2)) == __constant_htons(ETH_P_8021Q))
				is_vlan_tag = 1;

			if (is_vlan_tag) {
				if (ICMPV6_MCAST_MAC(skb->data) && ICMPV6_PROTO1A_VALN(skb->data))
					_rtw_memcpy(skb->data + MACADDRLEN, GET_MY_HWADDR(padapter), MACADDRLEN);
			} else {
				if (ICMPV6_MCAST_MAC(skb->data) && ICMPV6_PROTO1A(skb->data))
					_rtw_memcpy(skb->data + MACADDRLEN, GET_MY_HWADDR(padapter), MACADDRLEN);
			}
		}
#endif /* 0 */

		/* check if SA is equal to our MAC */
		if (memcmp(skb->data + MACADDRLEN, GET_MY_HWADDR(padapter), MACADDRLEN)) {
			/* priv->ext_stats.tx_drops++; */
			DEBUG_ERR("TX DROP: untransformed frame SA:%02X%02X%02X%02X%02X%02X!\n",
				skb->data[6], skb->data[7], skb->data[8], skb->data[9], skb->data[10], skb->data[11]);
			/* goto free_and_stop; */
			return -1;
		}
	}
	return 0;
}
#endif /* CONFIG_BR_EXT */

u32 rtw_get_txq_idx(int priority)
{
	int index;

	switch (priority) {
	case 0:
	case 3:
		index = TXQ_BE;
		break;
	case 1:
	case 2:
		index = TXQ_BK;
		break;
	case 4:
	case 5:
		index = TXQ_VI;
		break;
	case 6:
	case 7:
		index = TXQ_VO;
		break;
	default:
		index = TXQ_BE;
		break;
	}

	return index;
}

u32 rtw_get_ff_hwaddr(struct xmit_frame *pxmitframe)
{
	u32 addr;
	struct pkt_attrib *pattrib = &pxmitframe->attrib;

	switch (pattrib->qsel) {
	case 0:
	case 3:
		addr = BE_QUEUE_INX;
		break;
	case 1:
	case 2:
		addr = BK_QUEUE_INX;
		break;
	case 4:
	case 5:
		addr = VI_QUEUE_INX;
		break;
	case 6:
	case 7:
		addr = VO_QUEUE_INX;
		break;
	case 0x10:
		addr = BCN_QUEUE_INX;
		break;
	case 0x11: /* BC/MC in PS (HIQ) */
		addr = HIGH_QUEUE_INX;
		break;
	case 0x13:
		addr = TXCMD_QUEUE_INX;
		break;
	case 0x12:
	default:
		addr = MGT_QUEUE_INX;
		break;

	}

	return addr;

}

static void do_queue_select(_adapter	*padapter, struct pkt_attrib *pattrib)
{
	u8 qsel;

	qsel = pattrib->priority;

#ifdef CONFIG_MCC_MODE
	if (MCC_EN(padapter)) {
		/* Under MCC */
		if (rtw_hal_check_mcc_status(padapter, MCC_STATUS_NEED_MCC)) {
			if (padapter->mcc_adapterpriv.role == MCC_ROLE_GO
			    || padapter->mcc_adapterpriv.role == MCC_ROLE_AP) {
				pattrib->qsel = rtw_hal_get_qsel(padapter, QSLT_VO_ID); /* AP interface VO queue */
				pattrib->priority  = rtw_hal_get_qsel(padapter, QSLT_VO_ID);
			} else {
				pattrib->qsel = rtw_hal_get_qsel(padapter, QSLT_BE); /* STA interface BE queue */
				pattrib->priority  = rtw_hal_get_qsel(padapter, QSLT_BE);
			}
		} else
			/* Not Under MCC */
			pattrib->qsel = qsel;
	} else
		/* Not enable MCC */
		pattrib->qsel = qsel;
#else /* !CONFIG_MCC_MODE */
	pattrib->qsel = qsel;
#endif /* CONFIG_MCC_MODE */

	/* high priority packet */
	if (pattrib->hipriority_pkt) {
		pattrib->qsel = rtw_hal_get_qsel(padapter, QSLT_VO_ID);
		pattrib->priority  = rtw_hal_get_qsel(padapter, QSLT_VO_ID);
	}
}

/*
 * The main transmit(tx) entry
 *
 * Return
 *	1	enqueue
 *	0	success, hardware will handle this xmit frame(packet)
 *	<0	fail
 */
 #if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24))
s32 rtw_monitor_xmit_entry(struct sk_buff *skb, struct net_device *ndev)
{
	u16 frame_ctl;
	struct ieee80211_radiotap_header rtap_hdr;
	_adapter *padapter = (_adapter *)rtw_netdev_priv(ndev);
	struct pkt_file pktfile;
	struct rtw_ieee80211_hdr *pwlanhdr;
	struct pkt_attrib	*pattrib;
	struct xmit_frame		*pmgntframe;
	struct mlme_ext_priv	*pmlmeext = &(padapter->mlmeextpriv);
	struct xmit_priv	*pxmitpriv = &(padapter->xmitpriv);
	unsigned char	*pframe;
	u8 dummybuf[32];
	int len = skb->len, rtap_len;

	_rtw_memset(&rtap_hdr, 0, sizeof(rtap_hdr));
	rtw_mstat_update(MSTAT_TYPE_SKB, MSTAT_ALLOC_SUCCESS, skb->truesize);

#ifndef CONFIG_CUSTOMER_ALIBABA_GENERAL
	if (unlikely(skb->len < sizeof(struct ieee80211_radiotap_header)))
		goto fail;

	_rtw_open_pktfile((struct sk_buff *)skb, &pktfile);
	_rtw_pktfile_read(&pktfile, (u8 *)(&rtap_hdr), sizeof(struct ieee80211_radiotap_header));
	rtap_len = ieee80211_get_radiotap_len((u8 *)(&rtap_hdr));
	if (unlikely(rtap_hdr.it_version))
		goto fail;

	if (unlikely(skb->len < rtap_len))
		goto fail;

	if (rtap_len != 12) {
		RTW_INFO("radiotap len (should be 14): %d\n", rtap_len);
		goto fail;
	}
	_rtw_pktfile_read(&pktfile, dummybuf, rtap_len-sizeof(struct ieee80211_radiotap_header));
	len = len - rtap_len;
#endif
	pmgntframe = alloc_mgtxmitframe(pxmitpriv);
	if (pmgntframe == NULL) {
		rtw_udelay_os(500);
		goto fail;
	}

	_rtw_memset(pmgntframe->buf_addr, 0, WLANHDR_OFFSET + TXDESC_OFFSET);
	pframe = (u8 *)(pmgntframe->buf_addr) + TXDESC_OFFSET;
//	_rtw_memcpy(pframe, (void *)checking, len);
	_rtw_pktfile_read(&pktfile, pframe, len);


	/* Check DATA/MGNT frames */
	pwlanhdr = (struct rtw_ieee80211_hdr *)pframe;
	frame_ctl = le16_to_cpu(pwlanhdr->frame_ctl);
	if ((frame_ctl & RTW_IEEE80211_FCTL_FTYPE) == RTW_IEEE80211_FTYPE_DATA) {

		pattrib = &pmgntframe->attrib;
		update_monitor_frame_attrib(padapter, pattrib);

		if (is_broadcast_mac_addr(pwlanhdr->addr3) || is_broadcast_mac_addr(pwlanhdr->addr1))
			pattrib->rate = MGN_24M;

	} else {
		pattrib = &pmgntframe->attrib;
		if (update_mgntframe_attrib(padapter, pattrib) != _SUCCESS) {
			rtw_free_xmitframe(&padapter->xmitpriv, pmgntframe);
			goto fail;
		}
	}
	pattrib->retry_ctrl = _FALSE;
	pattrib->pktlen = len;
	pmlmeext->mgnt_seq = GetSequence(pwlanhdr);
	pattrib->seqnum = pmlmeext->mgnt_seq;
	pmlmeext->mgnt_seq++;
	pattrib->last_txcmdsz = pattrib->pktlen;

	dump_mgntframe(padapter, pmgntframe);

fail:
	rtw_skb_free(skb);
	return 0;
}
#endif

/*
 *
 * Return _TRUE when frame has been put to queue, otherwise return _FALSE.
 */
static u8 xmit_enqueue(_adapter *a, struct xmit_frame *frame)
{
	struct sta_info *sta = NULL;
	struct pkt_attrib *attrib = NULL;
	_list *head;
	u8 ret = _TRUE;


	attrib = &frame->attrib;
	sta = attrib->psta;
	if (!sta)
		return _FALSE;

	_rtw_spinlock_bh(&sta->tx_queue.lock);

	head = get_list_head(&sta->tx_queue);

	if ((rtw_is_list_empty(head) == _TRUE) && (!sta->tx_q_enable)) {
		ret = _FALSE;
		goto exit;
	}

	rtw_list_insert_tail(&frame->list, head);
	RTW_INFO(FUNC_ADPT_FMT ": en-queue tx pkt for macid=%d\n",
		 FUNC_ADPT_ARG(a), sta->phl_sta->macid);

exit:
	_rtw_spinunlock_bh(&sta->tx_queue.lock);

	return ret;
}

static void xmit_dequeue(struct sta_info *sta)
{
	_adapter *a;
	_list *head, *list;
	struct xmit_frame *frame;

	a = sta->padapter;

	do {
		_rtw_spinlock_bh(&sta->tx_queue.lock);

		head = get_list_head(&sta->tx_queue);

		if (rtw_is_list_empty(head) == _TRUE) {
			_rtw_spinunlock_bh(&sta->tx_queue.lock);
			break;
		}

		list = get_next(head);
		rtw_list_delete(list);
		frame = LIST_CONTAINOR(list, struct xmit_frame, list);
		RTW_INFO(FUNC_ADPT_FMT ": de-queue tx frame of macid=%d\n",
			 FUNC_ADPT_ARG(a), sta->phl_sta->macid);

		_rtw_spinunlock_bh(&sta->tx_queue.lock);

		/*rtw_hal_xmit(a, frame);*/
		rtw_intf_data_xmit(a, frame);
	} while (1);

}

void rtw_xmit_dequeue_callback(_workitem *work)
{
	struct sta_info *sta;


	sta = container_of(work, struct sta_info, tx_q_work);
	xmit_dequeue(sta);
}

void rtw_xmit_queue_set(struct sta_info *sta)
{
	_rtw_spinlock_bh(&sta->tx_queue.lock);

	if (sta->tx_q_enable) {
		RTW_WARN(FUNC_ADPT_FMT ": duplicated set!\n",
			 FUNC_ADPT_ARG(sta->padapter));
		goto exit;
	}
	sta->tx_q_enable = 1;
	RTW_INFO(FUNC_ADPT_FMT ": enable queue TX for macid=%d\n",
		 FUNC_ADPT_ARG(sta->padapter), sta->phl_sta->macid);

exit:
	_rtw_spinunlock_bh(&sta->tx_queue.lock);
}

void rtw_xmit_queue_clear(struct sta_info *sta)
{
	_rtw_spinlock_bh(&sta->tx_queue.lock);

	if (!sta->tx_q_enable) {
		RTW_WARN(FUNC_ADPT_FMT ": tx queue for macid=%d "
			 "not be enabled!\n",
			 FUNC_ADPT_ARG(sta->padapter), sta->phl_sta->macid);
		goto exit;
	}

	sta->tx_q_enable = 0;
	RTW_INFO(FUNC_ADPT_FMT ": disable queue TX for macid=%d\n",
		 FUNC_ADPT_ARG(sta->padapter), sta->phl_sta->macid);

	_set_workitem(&sta->tx_q_work);

exit:
	_rtw_spinunlock_bh(&sta->tx_queue.lock);
}

/*
 * The main transmit(tx) entry post handle
 *
 * Return
 *	1	enqueue
 *	0	success, hardware will handle this xmit frame(packet)
 *	<0	fail
 */
s32 rtw_xmit_posthandle(_adapter *padapter, struct xmit_frame *pxmitframe,
							struct sk_buff *pkt)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	s32 res;

	res = update_attrib(padapter, pkt, &pxmitframe->attrib);

#ifdef CONFIG_MCC_MODE
	/* record data kernel TX to driver to check MCC concurrent TX */
	rtw_hal_mcc_calc_tx_bytes_from_kernel(padapter, pxmitframe->attrib.pktlen);
#endif /* CONFIG_MCC_MODE */

#if defined(CONFIG_WAPI_SUPPORT)
	if (pxmitframe->attrib.ether_type != 0x88B4) {
		if (rtw_wapi_drop_for_key_absent(padapter, pxmitframe->attrib.ra)) {
			WAPI_TRACE(WAPI_RX, "drop for key absend when tx\n");
			res = _FAIL;
		}
	}
#endif
	if (res == _FAIL) {
		/*RTW_INFO("%s-"ADPT_FMT" update attrib fail\n", __func__, ADPT_ARG(padapter));*/
#ifdef DBG_TX_DROP_FRAME
		RTW_INFO("DBG_TX_DROP_FRAME %s update attrib fail\n", __FUNCTION__);
#endif
		rtw_free_xmitframe(pxmitpriv, pxmitframe);
		return -1;
	}
	pxmitframe->pkt = pkt;

	#ifdef CONFIG_RTW_SW_LED
	rtw_led_tx_control(padapter, pxmitframe->attrib.dst);
	#endif

	do_queue_select(padapter, &pxmitframe->attrib);

#if 0//def CONFIG_AP_MODE
	_rtw_spinlock_bh(&pxmitpriv->lock);
	if (xmitframe_enqueue_for_sleeping_sta(padapter, pxmitframe) == _TRUE) {
		_rtw_spinunlock_bh(&pxmitpriv->lock);
		DBG_COUNTER(padapter->tx_logs.core_tx_ap_enqueue);
		return 1;
	}
	_rtw_spinunlock_bh(&pxmitpriv->lock);
#endif

	/*if (xmit_enqueue(padapter, pxmitframe) == _TRUE)*/
	/*	return 1;*/

	/* pre_xmitframe */
	/*if (rtw_hal_xmit(padapter, pxmitframe) == _FALSE)*/
	if (rtw_intf_data_xmit(padapter, pxmitframe) == _FALSE)
		return 1;

	return 0;
}

/*
 * The main transmit(tx) entry
 *
 * Return
 *	1	enqueue
 *	0	success, hardware will handle this xmit frame(packet)
 *	<0	fail
 */
s32 rtw_xmit(_adapter *padapter, struct sk_buff **ppkt)
{
	static systime start = 0;
	static u32 drop_cnt = 0;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct xmit_frame *pxmitframe = NULL;
	s32 res;

	DBG_COUNTER(padapter->tx_logs.core_tx);

	if (IS_CH_WAITING(adapter_to_rfctl(padapter)))
		return -1;

	if (rtw_linked_check(padapter) == _FALSE)
		return -1;

	if (start == 0)
		start = rtw_get_current_time();

	pxmitframe = rtw_alloc_xmitframe(pxmitpriv);

	if (rtw_get_passing_time_ms(start) > 2000) {
		if (drop_cnt)
			RTW_INFO("DBG_TX_DROP_FRAME %s no more pxmitframe, drop_cnt:%u\n", __FUNCTION__, drop_cnt);
		start = rtw_get_current_time();
		drop_cnt = 0;
	}

	if (pxmitframe == NULL) {
		drop_cnt++;
		/*RTW_INFO("%s-"ADPT_FMT" no more xmitframe\n", __func__, ADPT_ARG(padapter));*/
		DBG_COUNTER(padapter->tx_logs.core_tx_err_pxmitframe);
		return -1;
	}

#ifdef CONFIG_BR_EXT
	if (MLME_IS_STA(padapter) || MLME_IS_ADHOC(padapter)) {
		void *br_port = NULL;
		struct net_device *ndev = padapter->pnetdev;

	#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
		ndev = wfo_rx_ndev(ndev);
	#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

		#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35))
		br_port = ndev->br_port;
		#else
		rcu_read_lock();
		br_port = rcu_dereference(ndev->rx_handler_data);
		rcu_read_unlock();
		#endif

		if (br_port) {
			res = rtw_br_client_tx(padapter, ppkt, br_port);
			if (res == -1) {
				rtw_free_xmitframe(pxmitpriv, pxmitframe);
				DBG_COUNTER(padapter->tx_logs.core_tx_err_brtx);
				return -1;
			}
		}
	}
#endif /* CONFIG_BR_EXT */

#ifdef CONFIG_RTW_MESH
	if (MLME_IS_MESH(padapter)) {
		_list b2u_list;

		res = rtw_mesh_addr_resolve(padapter, pxmitframe, *ppkt, &b2u_list);
		if (res == RTW_RA_RESOLVING)
			return 1;
		if (res == _FAIL)
			return -1;

		#if CONFIG_RTW_MESH_DATA_BMC_TO_UC
		if (!rtw_is_list_empty(&b2u_list)) {
			_list *list = get_next(&b2u_list);
			struct xmit_frame *b2uframe;

			while ((rtw_end_of_queue_search(&b2u_list, list)) == _FALSE) {
				b2uframe = LIST_CONTAINOR(list, struct xmit_frame, list);
				list = get_next(list);
				rtw_list_delete(&b2uframe->list);

				b2uframe->pkt = rtw_skb_copy(*ppkt);
				if (!b2uframe->pkt) {
					if (res == RTW_BMC_NO_NEED)
						res = _SUCCESS;
					rtw_free_xmitframe(pxmitpriv, b2uframe);
					continue;
				}

				rtw_xmit_posthandle(padapter, b2uframe, b2uframe->pkt);
			}
		}
		#endif /* CONFIG_RTW_MESH_DATA_BMC_TO_UC */

		if (res == RTW_BMC_NO_NEED) {
			rtw_free_xmitframe(&padapter->xmitpriv, pxmitframe);
			return 0;
		}
	}
#endif /* CONFIG_RTW_MESH */

	pxmitframe->pkt = NULL; /* let rtw_xmit_posthandle not to free pkt inside */
	res = rtw_xmit_posthandle(padapter, pxmitframe, *ppkt);

	return res;
}

#ifdef RTW_PHL_TX

#ifdef RTW_PHL_TEST_FPGA
u32 test_seq = 0;
#endif

u8 *get_head_from_txreq(_adapter *padapter, struct xmit_frame *pxframe, u8 frag_idx)
{
	return 0;
}

u8 *get_tail_from_txreq(_adapter *padapter, struct xmit_frame *pxframe, u8 frag_idx)
{
	return 0;
}

void dump_pkt(u8 *start, u32 len)
{
	u32 idx=0;
	for(idx=0; idx<len; idx++){
		printk("%02x ", start[idx]);

		if(idx%20==19)
			printk("\n");
	}
	printk("\n");
}

/* TXREQ_QMGT */
u8 *get_txreq_buffer(_adapter *padapter, u8 **txreq, u8 **pkt_list, u8 **head, u8 **tail, u8 txsc, struct sta_info *psta, struct sk_buff *pskb)
{
	struct xmit_txreq_buf *ptxreq_buf = NULL;
	_list *plist, *phead;
	_queue *pfree_txreq_queue = padapter->pfree_txreq_queue;
#ifdef 	CONFIG_CORE_TXSC
	u8 i = 0;
#endif
	struct rtw_xmit_req *treq = NULL;
	u8 is_ergent = 0;

	/* RESERVE_TXREQ */
	if (pskb && pskb->cb[_SKB_CB_FLAGS] == _PKT_TYPE_URGENT)
		is_ergent = 1;

	_rtw_spinlock_bh(&pfree_txreq_queue->lock);
	if (_rtw_queue_empty(pfree_txreq_queue) == _TRUE) {
		padapter->txreq_full_cnt++;
	} else {
		/* RESERVE_TXREQ */
		if (is_ergent || (!is_ergent && pfree_txreq_queue->qlen > padapter->registrypriv.wifi_mib.res_txreq)) {
			phead = get_list_head(pfree_txreq_queue);
			plist = get_next(phead);
			ptxreq_buf = LIST_CONTAINOR(plist, struct xmit_txreq_buf, list);
			rtw_list_delete(&ptxreq_buf->list);

			pfree_txreq_queue->qlen--;
			if(is_ergent)
				RTW_WARN("it is ergent packet, the free txreq is %d now\n", pfree_txreq_queue->qlen);
		} else 
			padapter->txreq_full_cnt++;
	}
	_rtw_spinunlock_bh(&pfree_txreq_queue->lock);

	if(ptxreq_buf){

		if(txreq) {
			if(!txsc)
				_rtw_memset(ptxreq_buf->txreq, 0x0, SZ_TXREQ);
			*txreq = ptxreq_buf->txreq;
			treq = (struct rtw_xmit_req *)ptxreq_buf->txreq;
		#ifdef CONFIG_VW_REFINE
			treq->vw_cnt = 0;
		#endif
		}

		if(head){
			#ifdef USE_ONE_WLHDR
			if(!txsc)
			#endif
			{
				_rtw_memset(ptxreq_buf->head, 0x0, SZ_HEAD_BUF);
			}
			*head = ptxreq_buf->head;
		}

		if(tail)
			*tail = ptxreq_buf->tail;

		if(pkt_list)
			*pkt_list = ptxreq_buf->pkt_list;

#ifdef CONFIG_CORE_TXSC
		for (i = 0; i < MAX_TXSC_SKB_NUM; i++)
			ptxreq_buf->pkt[i] = NULL;
		ptxreq_buf->pkt_cnt = 0;
#endif

		ptxreq_buf->psta = psta;
	}

	return (u8 *)ptxreq_buf;
}

void get_txreq_resources(_adapter *padapter, struct xmit_frame *pxframe,
	u8 **txreq, u8 **pkt_list, u8 **head, u8 **tail)
{
	u32 offset_head = (sizeof(struct rtw_xmit_req) * RTW_MAX_FRAG_NUM);
	u32 offset_tail = offset_head + (SZ_HEAD_BUF*RTW_MAX_FRAG_NUM);
	u32 offset_list = offset_tail + (SZ_TAIL_BUF*RTW_MAX_FRAG_NUM);
	u8 *pbuf = NULL;

	PHLTX_ENTER;

	//rtw_phl_tx todo: error handle, max tx req limit
	padapter->tx_ring_idx++;
	padapter->tx_ring_idx=(padapter->tx_ring_idx%padapter->max_tx_ring_cnt);

	pbuf = *padapter->tx_pool_ring_ptr + padapter->tx_ring_idx;
	//memset(pbuf, 0, (SZ_TX_RING*RTW_MAX_FRAG_NUM));

	if(txreq)
		*txreq = pbuf;

	if(head)
		*head = pbuf+offset_head;

	if(tail)
		*tail = pbuf+offset_tail;

	if(pkt_list)
		*pkt_list = pbuf+offset_list;
}

void dump_xmitframe_txreq(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct rtw_xmit_req *txreq = XF_TXREQ;
	u32 idx, idx1 = 0;

	PHLTX_ENTER;
	printk("total txreq=%d \n", XF_TXREQ_CNT);

	for(idx=0; idx<XF_TXREQ_CNT; idx++){
		struct rtw_pkt_buf_list *pkt_list =(struct rtw_pkt_buf_list *)txreq->pkt_list;
		printk("txreq[%d] with %d pkts =====\n", idx, txreq->pkt_cnt);
		for(idx1=0; idx1<txreq->pkt_cnt; idx1++){
			printk("pkt[%d] 0x%p len=%d\n", idx1, (void *)pkt_list->vir_addr, pkt_list->length);
			dump_pkt(pkt_list->vir_addr, pkt_list->length);
			pkt_list++;
		}
		txreq++;
	}
	printk("\n");
}

#ifdef CONFIG_PCI_HCI
void core_recycle_txreq_phyaddr(_adapter *padapter, struct rtw_xmit_req *txreq)
{
	PPCI_DATA pci_data = dvobj_to_pci(padapter->dvobj);
	struct pci_dev *pdev = pci_data->ppcidev;
	struct rtw_pkt_buf_list *pkt_list =(struct rtw_pkt_buf_list *)txreq->pkt_list;
	u32 idx = 0;

	for(idx=0; idx<txreq->pkt_cnt; idx++){
		dma_addr_t phy_addr = (pkt_list->phy_addr_l);
#ifdef CONFIG_ARCH_DMA_ADDR_T_64BIT
		{
			u64 phy_addr_h = pkt_list->phy_addr_h;
			phy_addr |= (phy_addr_h << 32);
		}
#endif
		pci_unmap_bus_addr(pdev, &phy_addr, pkt_list->length, PCI_DMA_TODEVICE);
		pkt_list++;
	}
}

void fill_txreq_phyaddr(_adapter *padapter, struct xmit_frame *pxframe)
{
	PPCI_DATA pci_data = dvobj_to_pci(padapter->dvobj);
	struct pci_dev *pdev = pci_data->ppcidev;

	struct rtw_xmit_req *txreq = XF_TXREQ;
	u32 idx, idx1 = 0;

	PHLTX_ENTER;

	for(idx=0; idx<XF_TXREQ_CNT; idx++){
		struct rtw_pkt_buf_list *pkt_list =(struct rtw_pkt_buf_list *)txreq->pkt_list;
		for(idx1=0; idx1<txreq->pkt_cnt; idx1++){
			dma_addr_t phy_addr = 0;
			pci_get_bus_addr(pdev, pkt_list->vir_addr, &phy_addr, pkt_list->length, PCI_DMA_TODEVICE);
#ifdef CONFIG_ARCH_DMA_ADDR_T_64BIT
			pkt_list->phy_addr_h =  phy_addr >> 32;
#else
			pkt_list->phy_addr_h = 0x0;
#endif
			pkt_list->phy_addr_l = phy_addr & 0xFFFFFFFF;
			pkt_list++;
		}
		txreq++;
	}
}
#endif

static void _fill_txreq_list_skb(_adapter *padapter,
	struct rtw_xmit_req *txreq, struct rtw_pkt_buf_list **pkt_list,
	struct sk_buff *skb, u32 *req_sz, s32 *req_offset)
{
#if (LINUX_VERSION_CODE < KERNEL_VERSION(5, 4, 0)) || defined(PLATFORM_ECOS)
	#define skb_frag_off(f)	((f)->page_offset)
#endif
#define PKT_LIST_APPEND(_addr, _len)	do {				\
		u32 __len = _len;					\
		if (__len == 0)						\
			break;						\
		list->vir_addr = _addr;					\
		list->length = __len;					\
		txreq->pkt_cnt++;					\
		txreq->total_len += __len;				\
		list++;							\
		*pkt_list = list;					\
	} while (0)

	struct rtw_pkt_buf_list *list = *pkt_list;
	u8 nr_frags = skb_shinfo(skb)->nr_frags;
	s32 offset = *req_offset;
	u32 rem_sz = *req_sz;
	u32 cur_frag_total, cur_frag_rem;
	int i;

	/* skb head frag */
	cur_frag_total = skb_headlen(skb);

	if (cur_frag_total > offset) {
		cur_frag_rem = rtw_min(cur_frag_total - offset, rem_sz);
		PKT_LIST_APPEND(skb->data + offset, cur_frag_rem);
		rem_sz -= cur_frag_rem;
		offset = 0;
	} else {
		offset -= cur_frag_total;
	}

	for (i = 0; i < skb_shinfo(skb)->nr_frags; i++) {
		skb_frag_t *frag = &skb_shinfo(skb)->frags[i];
		u8 *addr;

		addr = ((void *)page_address(skb_frag_page(frag))) + skb_frag_off(frag);
		cur_frag_total = skb_frag_size(frag);

		if (offset < cur_frag_total) {
			cur_frag_rem = cur_frag_total - offset;

			if (rem_sz < cur_frag_rem) {
				PKT_LIST_APPEND(addr + offset, rem_sz);
				RTW_WARN("%s:%d, size(rem_sz)=%d cur_frag_rem=%d txreq->total_length = %d\n",
					 __func__, __LINE__, rem_sz, cur_frag_rem, txreq->total_len);
				rem_sz = 0;
				break;
			} else {
				PKT_LIST_APPEND(addr + offset, cur_frag_rem);
				RTW_DBG("%s:%d, size=%d txreq->total_length = %d\n",
					__func__, __LINE__, cur_frag_rem, txreq->total_len);
				rem_sz -= cur_frag_rem;
			}

			offset = 0;
		} else {
			offset -= cur_frag_total;
		}
	}

	*req_sz = rem_sz;
	*req_offset = offset;

#undef PKT_LIST_APPEND
#if (LINUX_VERSION_CODE < KERNEL_VERSION(5, 4, 0)) || defined(PLATFORM_ECOS)
	#undef skb_frag_off
#endif
}

static int skb_total_frag_nr(struct sk_buff *head_skb)
{
	struct sk_buff *skb;
	int nr;

	nr = 1 + skb_shinfo(head_skb)->nr_frags;

	skb_walk_frags(head_skb, skb)
		nr += 1 + skb_shinfo(skb)->nr_frags;

	return nr;
}

static void fill_txreq_list_skb(_adapter *padapter,
	struct rtw_xmit_req *txreq, struct rtw_pkt_buf_list **pkt_list,
	struct sk_buff *head_skb, u32 req_sz, s32 offset)
{
	struct sk_buff *skb;

	if (skb_total_frag_nr(head_skb) > NUM_PKT_LIST_PER_TXREQ - 2) {
		rtw_skb_linearize(head_skb);
		RTW_WARN("skb total frag nr over %d\n", NUM_PKT_LIST_PER_TXREQ - 2);
	}

	_fill_txreq_list_skb(padapter, txreq, pkt_list, head_skb, &req_sz, &offset);

	skb_walk_frags(head_skb, skb)
		_fill_txreq_list_skb(padapter, txreq, pkt_list, skb, &req_sz, &offset);

	if (req_sz != 0)
		RTW_WARN("remain req_sz=%d should be zero\n", req_sz);
}

s32 rtw_core_replace_skb(struct sk_buff **pskb, u32 need_head, u32 need_tail)
{
	struct sk_buff *newskb;
	struct sk_buff *skb = *pskb;

	newskb = rtw_skb_copy(skb);

	if (newskb == NULL)
		return FAIL;

	rtw_skb_free(skb);
	*pskb = newskb;

	return SUCCESS;
}

#ifdef CONFIG_BR_EXT
s32 core_br_client_tx(_adapter *padapter, struct xmit_frame *pxframe, struct sk_buff **pskb)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct net_device *ndev = padapter->pnetdev;
#ifdef CONFIG_RTL_VLAN_8021Q
	extern int linux_vlan_enable;
#endif

	if (check_fwstate(&padapter->mlmepriv, WIFI_STATION_STATE | WIFI_ADHOC_STATE) == _TRUE) {
		void *br_port = NULL;
		struct net_device *vlan_dev = NULL;

#ifdef CONFIG_RTW_A4_STA
		if (_TRUE == core_a4_check_tx(padapter, pskb))
			return SUCCESS;

		if ((padapter->a4_enable == 1) &&
			(padapter->mlmeextpriv.mlmext_info.state & WIFI_FW_ASSOC_SUCCESS))
			return SUCCESS;
#endif

	#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
		ndev = wfo_rx_ndev(ndev);
	#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

		if (PKT_ETH_TYPE(*pskb) == __constant_htons(ETH_P_8021Q)
		#ifdef CONFIG_RTL_VLAN_8021Q
			|| linux_vlan_enable
		#endif
		) {
			vlan_dev = rtw_get_vlan_dev(padapter, *pskb);
			if (vlan_dev)
				ndev = vlan_dev;
		}

		#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35))
		br_port = ndev->br_port;
		#else
		rcu_read_lock();
		br_port = rcu_dereference(ndev->rx_handler_data);
		rcu_read_unlock();
		#endif

		if (br_port) {
			if (rtw_br_client_tx(padapter, pskb, br_port) == FAIL) {
				DBG_COUNTER(padapter->tx_logs.core_tx_err_brtx);
				return FAIL;
			}
		}
	}
	return SUCCESS;
}
#endif

s32 core_tx_update_pkt(_adapter *padapter, struct xmit_frame *pxframe, struct sk_buff **pskb)
{
	struct xmit_priv 	*pxmitpriv = &padapter->xmitpriv;
	struct sk_buff 		*skb_orig = *pskb;

	PHLTX_LOG;

//rtw_phl_tx todo, BR EXT
#ifdef CONFIG_BR_EXT
	if(core_br_client_tx(padapter, pxframe, pskb) == FAIL)
		return FAIL;
#endif

	return SUCCESS;
}

s32 core_tx_update_xmitframe(_adapter *padapter,
	struct xmit_frame *pxframe, struct sk_buff **pskb, struct sta_info *psta, u8 type)
{
	XF_TYPE = type;
	XF_SKB = *pskb;

	PHLTX_LOG;

#if 1
	if(XF_TYPE == RTW_TX_OS){
		if(update_attrib(padapter, *pskb, &XF_ATTRIB) != _SUCCESS)
		return FAIL;
	}
#else
	XF_SKB = *pskb;

	if(update_xmitframe_from_hdr(padapter, pxframe)==FAIL)
		return FAIL;

	PHLTX_LOG;

	if(update_xmitframe_qos(padapter, pxframe)==FAIL)
		return FAIL;

	PHLTX_LOG;

	if(update_xmitframe_security(padapter, pxframe)==FAIL)
		return FAIL;

	PHLTX_LOG;

	//if(update_xmitframe_hw(padapter, pxframe)==FAIL)
		//return FAIL;

	PHLTX_LOG;

	if(XF_TYPE == RTW_TX_OS){
		if(XF_SWENC
			&&(skb_shared(*pskb) || skb_cloned(*pskb))
			&&(rtw_core_replace_skb(pskb, RTW_MAX_WL_HEAD, RTW_MAX_WL_TAIL)==FAIL))
		return FAIL;
	}
#endif

	PHLTX_LOG;

	return SUCCESS;
}



void get_wl_frag_paras(_adapter *padapter, struct xmit_frame *pxframe,
	u32 *frag_perfr, u32 *wl_frags)
{
	u32 wl_head, wl_tail, payload_totalsz, payload_fragsz, wl_frag_num;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;

	wl_head = wl_tail = payload_totalsz = 0;

	wl_head += XF_WL_HDRLEN;
	wl_tail += RTW_SZ_FCS;
	if (XF_SEC_TYPE) {
		wl_head += XF_IVLEN;
		wl_tail += XF_ICVLEN;
	}

	payload_fragsz = pxmitpriv->frag_len - wl_head - wl_tail;

	payload_totalsz = XF_SZ_PAYLOAD;
	if (XF_TYPE == RTW_TX_OS)
		payload_totalsz += RTW_SZ_LLC;
	if (XF_SEC_TYPE == _TKIP_)
		payload_totalsz += RTW_TKIP_MIC_LEN;

	if (XF_WL_AMSDU)
		wl_frag_num = 1;
	else if (payload_fragsz < payload_totalsz)
		wl_frag_num = RTW_DIV_ROUND_UP(payload_totalsz, payload_fragsz);
	else
		wl_frag_num = 1;

	XF_FRAG_DATA_LEN = *frag_perfr = payload_fragsz;
	XF_NR_FRAGS = *wl_frags = wl_frag_num;
#ifdef CONFIG_CORE_TXSC
	XF_FRAG_LEN_TXSC = payload_fragsz - (payload_totalsz - XF_SZ_PAYLOAD);
#endif
}

u8 fill_txreq_pkt_perfrag_txos(struct _ADAPTER *padapter,
			       struct xmit_frame *pxframe,
			       u32 frag_perfr, u32 wl_frags, struct sta_info *psta)
{
	struct rtw_xmit_req *xf_txreq = NULL;
	struct rtw_pkt_buf_list *pkt_list = NULL;
	struct sk_buff *skb = XF_SKB;
	u8 *txreq, *head, *tail, *list;
	u32 head_sz, tail_sz, wlan_tail;
	u32 payload_sz, payload_offset;
	u8 idx, i;
	u8 *wlhdr[RTW_MAX_FRAG_NUM] = {NULL};
	u8 *wltail[RTW_MAX_FRAG_NUM] = {NULL};
	/* TXREQ_QMGT */
	struct xmit_txreq_buf *txreq_buf = NULL;
#ifdef CONFIG_ETHER_PKT_AGG
	struct sk_buff *xmit_skb;
#endif
#ifdef CONFIG_ONE_TXQ
	struct sta_xmit_priv *pstaxmitpriv;
#endif

	PHLTX_ENTER;

	//get_txreq_resources(padapter, pxframe, &txreq, &list, &head, &tail);
	/* TXREQ_QMGT */
	txreq_buf = (struct xmit_txreq_buf *)get_txreq_buffer(padapter, &txreq, &list, &head, &tail, 0, psta, pxframe->pkt);
	if(txreq_buf == NULL){
		//do this in core_tx_init_xmitframe
		//XF_TXREQ = NULL;
		//pxframe->ptxreq_buf = NULL;

		//free in rtw_core_tx
		//XF_SKB = NULL;//for not recycle in abort_core_tx
		goto fail;
	}

	#ifdef CONFIG_WFA_OFDMA_Logo_Test
	if(psta)
		psta->core_current_txreq_cnt++;
	#endif

	//printk("XF_HDRLEN=%d XF_WL_HDRLEN=%d XF_IVLEN=%d \n", XF_HDRLEN, XF_WL_HDRLEN, XF_IVLEN);

	XF_TXREQ_CNT = wl_frags;

	head_sz = XF_WL_HDRLEN + (XF_WL_AMSDU ? 0 : RTW_SZ_LLC);
	tail_sz = 0;
	if (XF_SEC_TYPE) {
		head_sz += XF_IVLEN;
		if (XF_SEC_TYPE == _TKIP_)
			tail_sz += RTW_TKIP_MIC_LEN;
		if (XF_SWENC)
			tail_sz += XF_ICVLEN;
	}

	PHLTX_LOG;

	pxframe->ptxreq_buf = txreq_buf;

	PHLTX_LOG;

#if 0
	payload = skb->data+XF_HDRLEN;
	printk("num_txreq=%d, hw_head=%d, hw_tail=%d, list=0x%p\n",
		num_txreq, hw_head, hw_tail, (void *)list);

	printk("p:txreq=0x%p, head=0x%p, tail=0x%p, payload=0x%p\n",
		(void *)txreq, (void *)head, (void *)tail, (void *)payload);
#endif

	XF_TXREQ = xf_txreq = (struct rtw_xmit_req *)txreq;
	pkt_list = (struct rtw_pkt_buf_list *)list;

#ifdef CONFIG_CORE_TXSC
	xf_txreq->shortcut_id = 0;
	xf_txreq->treq_type = RTW_PHL_TREQ_TYPE_NORMAL;
#endif

	PHLTX_LOG;

	/* move to first payload position */
	payload_offset = XF_HDRLEN;
#ifdef CONFIG_ETHER_PKT_AGG
	if(pxframe->attrib.isAggPkt) {
		payload_offset = 0;
	}
#endif /* CONFIG_ETHER_PKT_AGG */

	for (idx = 0; idx < wl_frags; idx++) {
		/* for no memset */
		xf_txreq->pkt_cnt = 0;
		xf_txreq->total_len = 0;
		xf_txreq->pkt_list = (u8 *)pkt_list;

		/* fill head into txreq */
		wlhdr[idx] = head;
		pkt_list->vir_addr = head;
		pkt_list->length = head_sz;
		if (idx) {
			/* deduct LLC size if not first fragment */
			pkt_list->length -= RTW_SZ_LLC;
		}
		head += pkt_list->length;
		xf_txreq->pkt_cnt++;
		xf_txreq->total_len += pkt_list->length;
		pkt_list++;

		/* fill payload into txreq */
		if (idx == (wl_frags - 1)) {
			/* last payload size */
			payload_sz = skb->len - payload_offset;
		} else if (idx == 0) {
			/* first payload size should deduct LLC size */
			payload_sz = frag_perfr - RTW_SZ_LLC;
		} else {
			payload_sz = frag_perfr;
		}
#ifdef CONFIG_ETHER_PKT_AGG
		if (pxframe->attrib.isAggPkt == _AGG_TYPE_PKTLIST) {
			xmit_skb = skb;
			for (i = 0; i < MAX_TXSC_SKB_NUM; i++) {
				/* Fill pkt_list */
				pkt_list->vir_addr = xmit_skb->data;
				pkt_list->length = xmit_skb->len;

				xf_txreq->total_len += pkt_list->length;
				xf_txreq->pkt_cnt++;
				txreq_buf->pkt[i] = (u8 *)xmit_skb;
				pkt_list++;
				if (xmit_skb->next == NULL)
					break;
				xmit_skb = xmit_skb->next;
			}

			if (i == MAX_TXSC_SKB_NUM && xmit_skb->next != NULL) {
				RTW_PRINT("[ERR][%s:%d] skb list num > %d, please check", __func__, __LINE__, MAX_TXSC_SKB_NUM);
			}
		}
		else
#endif /* CONFIG_ETHER_PKT_AGG */
		{
			/* xf_txreq would be update and pkt_list++ inside */
			fill_txreq_list_skb(padapter, xf_txreq, &pkt_list, skb,
						payload_sz, payload_offset);
			payload_offset += payload_sz;
		}


		/* fill tail(if alloc) into txreq */
		if (tail_sz) {
			wlan_tail = tail_sz;
			if ((XF_SEC_TYPE == _TKIP_) && (idx != (wl_frags - 1))) {
				/* deduct MIC size if not last fragment with TKIP */
				wlan_tail -= RTW_TKIP_MIC_LEN;
			}
			if (wlan_tail) {
				wltail[0] = tail;
				pkt_list->vir_addr = tail;
				pkt_list->length = wlan_tail;
				tail += pkt_list->length;
				xf_txreq->pkt_cnt++;
				xf_txreq->total_len += pkt_list->length;
				pkt_list++;
			}
		}

		if (xf_txreq->pkt_cnt > NUM_PKT_LIST_PER_TXREQ)
			RTW_WARN("xf_txreq->pkt_cnt=%d > NUM_PKT_LIST_PER_TXREQ\n",
				 xf_txreq->pkt_cnt);

		xf_txreq++;
	}

	_rtw_memcpy(XF_WLHDR, wlhdr, sizeof(wlhdr));
	_rtw_memcpy(XF_WLTAIL, wltail, sizeof(wltail));
	PHLTX_EXIT;
	return _SUCCESS;

fail:
	return _FAIL;
}

/* TXREQ_QMGT, MGT_TXREQ_QMGT */
u8 fill_txreq_pkt_mgmt(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct rtw_xmit_req *xf_txreq = NULL;
	struct rtw_pkt_buf_list *pkt_list = NULL;
	//u8 *txreq, *head, *tail, *list, *mgmt = NULL;

	PHLTX_ENTER;

	if(!pxframe->phl_txreq)
		goto fail;

	xf_txreq = pxframe->phl_txreq;
	pkt_list = (struct rtw_pkt_buf_list *)xf_txreq->pkt_list;

	//get_txreq_resources(padapter, pxframe,
	//	(u8 **)&xf_txreq, (u8 **)&pkt_list, NULL, NULL);
	//printk("p:txreq=0x%p, pkt_list=0x%p \n", (void *)xf_txreq, (void *)pkt_list);

	//for no memset
	xf_txreq->pkt_cnt = 0;
	xf_txreq->total_len = 0;
#ifdef CONFIG_CORE_TXSC
	xf_txreq->shortcut_id = 0;
#endif

	pkt_list->vir_addr = XF_MGMTBUF;
	pkt_list->length = XF_LEN_ORIG;

	xf_txreq->pkt_cnt = 1;
	//xf_txreq->pkt_list = (u8 *)pkt_list;
	xf_txreq->treq_type = RTW_PHL_TREQ_TYPE_NORMAL;

	XF_TXREQ_CNT = 1;
	//XF_TXREQ = xf_txreq;

	xf_txreq->total_len = xf_txreq->total_len + XF_LEN_ORIG;
	//RTW_INFO("%s,%d, xf_txreq->total_length = %d\n", __func__, __LINE__, xf_txreq->total_len);

#ifdef RTW_PHL_TEST_FPGA
{
	struct rtw_ieee80211_hdr *p = (struct rtw_ieee80211_hdr *)XF_MGMTBUF;

	test_seq++;
	test_seq = test_seq%0xFFF;
	SetSeqNum(p, test_seq);
}
#endif

exit:
	return _SUCCESS;

fail:
	return _FAIL;
}

static u8 merge_txreq_to_one_piece(struct _ADAPTER *a,
				   struct xmit_frame *xf)
{
	struct rtw_xmit_req *txreq = NULL;
	struct rtw_pkt_buf_list *pkt_list = NULL;
	int i, j;
	u32 total_sz;
	u8 *buf, *ptr;


	for (i = 0; i < xf->txreq_cnt; i++) {
		txreq = &xf->phl_txreq[i];
		if (txreq->pkt_cnt == 1)
			continue;
		total_sz = txreq->total_len;
		buf = rtw_zmalloc(total_sz);
		if (!buf)
			return _FAIL;
		xf->buf_need_free |= BIT(i);

		ptr = buf;
		for (j = 0; j < txreq->pkt_cnt; j++) {
			pkt_list = &((struct rtw_pkt_buf_list*)txreq->pkt_list)[j];
			_rtw_memcpy(ptr, pkt_list->vir_addr, pkt_list->length);
			ptr += pkt_list->length;
		}
		txreq->pkt_cnt = 1;
		pkt_list = (struct rtw_pkt_buf_list *)txreq->pkt_list;
		pkt_list->vir_addr = buf;
		pkt_list->length = total_sz;
	}

	return _SUCCESS;
}

#ifdef RTW_PHL_TEST_FPGA
#define F_TX_MACID	(0)
#define F_TX_TID		(1)
#define F_TX_TYPE	RTW_PHL_PKT_TYPE_DATA
#define F_TX_RATE	(0x8F) //HRATE_MCS15
#define F_TX_BW		(1)
#define F_TX_DMACH	(0)
#endif


static u8 get_security_cam_id(struct _ADAPTER *padapter, struct xmit_frame *pxframe, u8 keyid)
{
	struct dvobj_priv *d;
	void *phl;
	u8 sec_cam_id = 0;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct sta_info *sta;
	sint bmcast = IS_MCAST(pxframe->attrib.ra);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	WLAN_BSSID_EX *pbss_network = (WLAN_BSSID_EX *)&pmlmepriv->cur_network.network;

	if (bmcast == _TRUE) {
		/* WEP: use unicast key type to match halmac rule (see: setkey_hdl) */
		if (XF_SEC_TYPE == _WEP40_ || XF_SEC_TYPE == _WEP104_)
			bmcast = _FALSE;

		sta = rtw_get_stainfo(pstapriv, pbss_network->MacAddress);
	}
	else {
		sta = rtw_get_stainfo(pstapriv, pxframe->attrib.ra);
	}

	if (!sta) {
		RTW_ERR("%s sta not found: %pM\n", __func__,
			(IS_MCAST(pxframe->attrib.ra) == _TRUE) ? pbss_network->MacAddress : pxframe->attrib.ra);
		return sec_cam_id;
	}

	d = adapter_to_dvobj(padapter);
	phl = GET_HAL_INFO(d);

	if (keyid >= 4)
		sec_cam_id = rtw_phl_get_sec_cam_idx(phl,sta->phl_sta, keyid,
			RTW_SEC_KEY_BIP);
	else
		sec_cam_id = rtw_phl_get_sec_cam_idx(phl,sta->phl_sta, keyid,
			bmcast?RTW_SEC_KEY_MULTICAST:RTW_SEC_KEY_UNICAST);

	return sec_cam_id;
}

/* Todo: HE rate mapping not ready */
static const enum rtw_data_rate mrate2phlrate_tbl[] = {
	[MGN_1M] = RTW_DATA_RATE_CCK1,
	[MGN_2M] = RTW_DATA_RATE_CCK2,
	[MGN_5_5M] = RTW_DATA_RATE_CCK5_5,
	[MGN_11M] = RTW_DATA_RATE_CCK11,
	[MGN_6M] = RTW_DATA_RATE_OFDM6,
	[MGN_9M] = RTW_DATA_RATE_OFDM9,
	[MGN_12M] = RTW_DATA_RATE_OFDM12,
	[MGN_18M] = RTW_DATA_RATE_OFDM18,
	[MGN_24M] = RTW_DATA_RATE_OFDM24,
	[MGN_36M] = RTW_DATA_RATE_OFDM36,
	[MGN_48M] = RTW_DATA_RATE_OFDM48,
	[MGN_54M] = RTW_DATA_RATE_OFDM54,
	[MGN_MCS0] = RTW_DATA_RATE_MCS0,
	[MGN_MCS1] = RTW_DATA_RATE_MCS1,
	[MGN_MCS2] = RTW_DATA_RATE_MCS2,
	[MGN_MCS3] = RTW_DATA_RATE_MCS3,
	[MGN_MCS4] = RTW_DATA_RATE_MCS4,
	[MGN_MCS5] = RTW_DATA_RATE_MCS5,
	[MGN_MCS6] = RTW_DATA_RATE_MCS6,
	[MGN_MCS7] = RTW_DATA_RATE_MCS7,
	[MGN_MCS8] = RTW_DATA_RATE_MCS8,
	[MGN_MCS9] = RTW_DATA_RATE_MCS9,
	[MGN_MCS10] = RTW_DATA_RATE_MCS10,
	[MGN_MCS11] = RTW_DATA_RATE_MCS11,
	[MGN_MCS12] = RTW_DATA_RATE_MCS12,
	[MGN_MCS13] = RTW_DATA_RATE_MCS13,
	[MGN_MCS14] = RTW_DATA_RATE_MCS14,
	[MGN_MCS15] = RTW_DATA_RATE_MCS15,
	[MGN_MCS16] = RTW_DATA_RATE_MCS16,
	[MGN_MCS17] = RTW_DATA_RATE_MCS17,
	[MGN_MCS18] = RTW_DATA_RATE_MCS18,
	[MGN_MCS19] = RTW_DATA_RATE_MCS19,
	[MGN_MCS20] = RTW_DATA_RATE_MCS20,
	[MGN_MCS21] = RTW_DATA_RATE_MCS21,
	[MGN_MCS22] = RTW_DATA_RATE_MCS22,
	[MGN_MCS23] = RTW_DATA_RATE_MCS23,
	[MGN_MCS24] = RTW_DATA_RATE_MCS24,
	[MGN_MCS25] = RTW_DATA_RATE_MCS25,
	[MGN_MCS26] = RTW_DATA_RATE_MCS26,
	[MGN_MCS27] = RTW_DATA_RATE_MCS27,
	[MGN_MCS28] = RTW_DATA_RATE_MCS28,
	[MGN_MCS29] = RTW_DATA_RATE_MCS29,
	[MGN_MCS30] = RTW_DATA_RATE_MCS30,
	[MGN_MCS31] = RTW_DATA_RATE_MCS31,
	[MGN_VHT1SS_MCS0] = RTW_DATA_RATE_VHT_NSS1_MCS0,
	[MGN_VHT1SS_MCS1] = RTW_DATA_RATE_VHT_NSS1_MCS1,
	[MGN_VHT1SS_MCS2] = RTW_DATA_RATE_VHT_NSS1_MCS2,
	[MGN_VHT1SS_MCS3] = RTW_DATA_RATE_VHT_NSS1_MCS3,
	[MGN_VHT1SS_MCS4] = RTW_DATA_RATE_VHT_NSS1_MCS4,
	[MGN_VHT1SS_MCS5] = RTW_DATA_RATE_VHT_NSS1_MCS5,
	[MGN_VHT1SS_MCS6] = RTW_DATA_RATE_VHT_NSS1_MCS6,
	[MGN_VHT1SS_MCS7] = RTW_DATA_RATE_VHT_NSS1_MCS7,
	[MGN_VHT1SS_MCS8] = RTW_DATA_RATE_VHT_NSS1_MCS8,
	[MGN_VHT1SS_MCS9] = RTW_DATA_RATE_VHT_NSS1_MCS9,
	[MGN_VHT2SS_MCS0] = RTW_DATA_RATE_VHT_NSS2_MCS0,
	[MGN_VHT2SS_MCS1] = RTW_DATA_RATE_VHT_NSS2_MCS1,
	[MGN_VHT2SS_MCS2] = RTW_DATA_RATE_VHT_NSS2_MCS2,
	[MGN_VHT2SS_MCS3] = RTW_DATA_RATE_VHT_NSS2_MCS3,
	[MGN_VHT2SS_MCS4] = RTW_DATA_RATE_VHT_NSS2_MCS4,
	[MGN_VHT2SS_MCS5] = RTW_DATA_RATE_VHT_NSS2_MCS5,
	[MGN_VHT2SS_MCS6] = RTW_DATA_RATE_VHT_NSS2_MCS6,
	[MGN_VHT2SS_MCS7] = RTW_DATA_RATE_VHT_NSS2_MCS7,
	[MGN_VHT2SS_MCS8] = RTW_DATA_RATE_VHT_NSS2_MCS8,
	[MGN_VHT2SS_MCS9] = RTW_DATA_RATE_VHT_NSS2_MCS9,
	[MGN_VHT3SS_MCS0] = RTW_DATA_RATE_VHT_NSS3_MCS0,
	[MGN_VHT3SS_MCS1] = RTW_DATA_RATE_VHT_NSS3_MCS1,
	[MGN_VHT3SS_MCS2] = RTW_DATA_RATE_VHT_NSS3_MCS2,
	[MGN_VHT3SS_MCS3] = RTW_DATA_RATE_VHT_NSS3_MCS3,
	[MGN_VHT3SS_MCS4] = RTW_DATA_RATE_VHT_NSS3_MCS4,
	[MGN_VHT3SS_MCS5] = RTW_DATA_RATE_VHT_NSS3_MCS5,
	[MGN_VHT3SS_MCS6] = RTW_DATA_RATE_VHT_NSS3_MCS6,
	[MGN_VHT3SS_MCS7] = RTW_DATA_RATE_VHT_NSS3_MCS7,
	[MGN_VHT3SS_MCS8] = RTW_DATA_RATE_VHT_NSS3_MCS8,
	[MGN_VHT3SS_MCS9] = RTW_DATA_RATE_VHT_NSS3_MCS9,
	[MGN_VHT4SS_MCS0] = RTW_DATA_RATE_VHT_NSS4_MCS0,
	[MGN_VHT4SS_MCS1] = RTW_DATA_RATE_VHT_NSS4_MCS1,
	[MGN_VHT4SS_MCS2] = RTW_DATA_RATE_VHT_NSS4_MCS2,
	[MGN_VHT4SS_MCS3] = RTW_DATA_RATE_VHT_NSS4_MCS3,
	[MGN_VHT4SS_MCS4] = RTW_DATA_RATE_VHT_NSS4_MCS4,
	[MGN_VHT4SS_MCS5] = RTW_DATA_RATE_VHT_NSS4_MCS5,
	[MGN_VHT4SS_MCS6] = RTW_DATA_RATE_VHT_NSS4_MCS6,
	[MGN_VHT4SS_MCS7] = RTW_DATA_RATE_VHT_NSS4_MCS7,
	[MGN_VHT4SS_MCS8] = RTW_DATA_RATE_VHT_NSS4_MCS8,
	[MGN_VHT4SS_MCS9] = RTW_DATA_RATE_VHT_NSS4_MCS9,
};

/*
 * _rate_mrate2phl() - convert data rate from mrate to PHL(MAC)
 * @sta:	struct sta_info *
 * @mrate:	date rate of mrate type, enum MGN_RATE
 *
 * Convert data rate from MGN_RATE definition to PHL's definition.
 *
 * Return PHL's data rate definition "enum rtw_data_rate".
 * 0x0~0xB: CCK 1M ~ OFDM 54M
 * 0x80~0x9F: HT MCS0~MCS31
 * 0x100~0x109: VHT 1SS MCS0~MCS9
 * 0x110~0x119: VHT 2SS MCS0~MCS9
 * 0x120~0x129: VHT 3SS MCS0~MCS9
 * 0x130~0x139: VHT 4SS MCS0~MCS9
 * 0x180~0x18B: HE 1SS MCS0~MCS11
 * 0x190~0x19B: HE 2SS MCS0~MCS11
 * 0x1A0~0x1AB: HE 3SS MCS0~MCS11
 * 0x1B0~0x1BB: HE 4SS MCS0~MCS11
 */
static enum rtw_data_rate _rate_mrate2phl(enum MGN_RATE mrate)
{
	enum rtw_data_rate phl = RTW_DATA_RATE_CCK1;


	if (mrate < ARRAY_SIZE(mrate2phlrate_tbl))
		phl = mrate2phlrate_tbl[mrate];

	if ((mrate != MGN_1M) && (phl == RTW_DATA_RATE_CCK1))
		RTW_WARN("%s: Invalid rate 0x%x\n", __func__, mrate);

	return phl;
}

/*
 * _rate_drv2phl() - convert data rate from drive to PHL(MAC)
 * @sta:	struct sta_info *
 * @rate:	date rate of driver
 *		0x0~0xB: CCK 1M ~ OFDM 54M
 *		>0xB: HT/VHT/HE use the same bits field to represent each
 *		      data rate, so these bits's real definition depended on
 *		      sta's wireless mode.
 *
 * Convert driver's data rate definition to PHL's definition.
 *
 * Return PHL's data rate definition "enum rtw_data_rate".
 */
static enum rtw_data_rate _rate_drv2phl(struct sta_info *sta, u8 rate)
{
	enum rtw_data_rate phl = RTW_DATA_RATE_CCK1;
	u8 ht_support = 0, vht_support = 0, he_support = 0;


	if (rate < 12) {
		/* B/G mode, CCK/OFDM rate */
		return (enum rtw_data_rate)rate;
	}

#ifdef CONFIG_80211N_HT
	if (sta->htpriv.ht_option == _TRUE)
		ht_support = 1;
#ifdef CONFIG_80211AC_VHT
	if (sta->vhtpriv.vht_option == _TRUE)
		vht_support = 1;
#ifdef CONFIG_80211AX_HE
	if (sta->hepriv.he_option == _TRUE)
		he_support = 1;
#endif /* CONFIG_80211AX_HE */
#endif /* CONFIG_80211AC_VHT */
#endif /* CONFIG_80211N_HT */

	rate -= 12;
	if (he_support) {
		if (rate < 12)
			phl = RTW_DATA_RATE_HE_NSS1_MCS0 + rate;
		else if (rate < 24)
			phl = RTW_DATA_RATE_HE_NSS2_MCS0 + (rate - 12);
		else if (rate < 36)
			phl = RTW_DATA_RATE_HE_NSS3_MCS0 + (rate - 24);
		else
			phl = RTW_DATA_RATE_HE_NSS4_MCS0 + (rate - 36);
	} else if (vht_support) {
		if (rate < 10)
			phl = RTW_DATA_RATE_VHT_NSS1_MCS0 + rate;
		else if (rate < 20)
			phl = RTW_DATA_RATE_VHT_NSS2_MCS0 + (rate - 10);
		else if (rate < 30)
			phl = RTW_DATA_RATE_VHT_NSS3_MCS0 + (rate - 20);
		else
			phl = RTW_DATA_RATE_VHT_NSS4_MCS0 + (rate - 30);
	} else if (ht_support) {
		phl = RTW_DATA_RATE_MCS0 + rate;
	}

	return phl;
}

#ifdef DYNAMIC_RTS_CONTROL
void check_rts(_adapter *padapter, struct sta_info *psta, struct rtw_t_meta_data *mdata)
{
	if (!psta || !psta->phl_sta)
		return;

	if (mdata->type != RTW_PHL_PKT_TYPE_DATA)
		return;

	if (mdata->mc) {
		mdata->hw_rts_en = 0;
		mdata->rts_en = 0;
		mdata->cts2self = 0;
		mdata->rts_cca_mode = 0;
		return;
	}

	mdata->rts_en = psta->phl_sta->rts_en;
	mdata->hw_rts_en = psta->phl_sta->hw_rts_en;
	mdata->cts2self = psta->phl_sta->cts2self;
	mdata->rts_cca_mode = psta->phl_sta->rts_cca_mode;

	if (padapter->registrypriv.wifi_mib.rtsthres > 0){
		if   (mdata->pktlen >= padapter->registrypriv.wifi_mib.rtsthres){
			mdata->rts_en = 1;
			mdata->cts2self = 0;
		}else{
			mdata->rts_en =0;
			mdata->cts2self = 1;
		}
	}

}

#endif
u8 _stbc_mapping(_adapter *padapter, struct sta_info *psta)
{
	struct rtw_phl_stainfo_t *phl_sta_i;
	struct rtw_wifi_role_t *wrole;
	struct protocol_cap_t *asoc_cap_i;
	u8 stbc_en = 0;

	if (!psta || !psta->phl_sta)
		return stbc_en;

	phl_sta_i = psta->phl_sta;
	wrole = phl_sta_i->wrole;
	asoc_cap_i = &phl_sta_i->asoc_cap;

	/* Driver wifi mode mapping */
	if (phl_sta_i->wmode & WLAN_MD_11AX) {
		if (!wrole->proto_role_cap.stbc_he_tx){
			stbc_en = 0;
		}else if ((asoc_cap_i->stbc_he_rx != 0 && psta->cur_tx_bw <= CHANNEL_WIDTH_80) ||
			(asoc_cap_i->stbc_rx_greater_80mhz!= 0 && psta->cur_tx_bw > CHANNEL_WIDTH_80)){
			stbc_en = 1;
                }
	} else if (phl_sta_i->wmode & WLAN_MD_11AC) {
		if (!wrole->proto_role_cap.stbc_vht_tx)
			stbc_en = 0;
		else if (asoc_cap_i->stbc_vht_rx)
			stbc_en = 1;
	} else if  (phl_sta_i->wmode & WLAN_MD_11N) {
		if (!wrole->proto_role_cap.stbc_ht_tx)
			stbc_en = 0;
		else if (asoc_cap_i->stbc_ht_rx)
			stbc_en = 1;
	}
	return stbc_en;
}

u8 _ldpc_mapping(_adapter *padapter, struct sta_info *psta)
{
	u8 ldpc_en = 0;

	if (!psta)
		return 0;

	if (!psta->phl_sta)
		return 0;

	if (!padapter->registrypriv.wifi_mib.ldpc)
		return 0;

	/* Driver wifi mode mapping */
	if (psta->phl_sta->wmode & WLAN_MD_11AX) {
		if (psta->phl_sta->asoc_cap.he_ldpc)
			ldpc_en = 1;
	} else if (psta->phl_sta->wmode & WLAN_MD_11AC) {
		if (psta->phl_sta->asoc_cap.vht_ldpc)
			ldpc_en = 1;
	} else if (psta->phl_sta->wmode & WLAN_MD_11N) {
		if (psta->phl_sta->asoc_cap.ht_ldpc)
			ldpc_en = 1;
	}
	return ldpc_en;
}

void fill_txreq_mdata(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct rtw_xmit_req *txreq = XF_TXREQ;
	struct sta_info *psta = XF_STA;
	struct rtw_t_meta_data *mdata = &(txreq->mdata);
	u32 idx = 0;
	u8 subtype = 0;

	PHLTX_LOG;

	memset(mdata, 0 , sizeof(struct rtw_t_meta_data));

	/* packet identify */
	if(XF_TYPE == RTW_TX_DRV_MGMT) {
		mdata->type = RTW_PHL_PKT_TYPE_MGNT;
		subtype = get_frame_sub_type((u8 *)(pxframe->buf_addr) + TXDESC_OFFSET);
		/* if null data/qos null data, set phl pkt type to data */
		if ((subtype == WIFI_DATA_NULL) || (subtype == WIFI_QOS_DATA_NULL))
			mdata->type = RTW_PHL_PKT_TYPE_DATA;
	} else
		mdata->type = RTW_PHL_PKT_TYPE_DATA;

#ifdef CONFIG_ETHER_PKT_AGG
	txreq->isAggPkt = pxframe->attrib.isAggPkt;
#endif

	if (psta && psta->phl_sta)
		mdata->macid = psta->phl_sta->macid;
	else if (   MLME_IS_AP(padapter)
		 && padapter->self_sta && padapter->self_sta->phl_sta) {
		mdata->macid = padapter->self_sta->phl_sta->macid;
	} else
		mdata->macid = 0;

	if (padapter->phl_role) {
		mdata->hal_port = padapter->phl_role->hw_port;
		mdata->mbssid = padapter->phl_role->hw_mbssid;
	}

	/* enable wd info by default */
#ifdef CONFIG_VW_REFINE
	/* enable wd info by default */
	if (padapter->no_wdinfo)
		mdata->wdinfo_en = 0;
	else
#endif
		mdata->wdinfo_en = 1;

	/* packet content */
	mdata->hdr_len = (XF_WL_HDRLEN >> 1);	/* for HW encrypt and HW header conversion usage, it should be half of the packet header length */
	mdata->hw_seq_mode = 0;
	mdata->sw_seq = XF_WL_SEQ;
	mdata->hw_sec_iv = 0;
	mdata->nav_use_hdr = 0;
	mdata->mc = IS_MCAST(XF_RA) ? 1 : 0;
	mdata->bc = MacAddr_isBcst(XF_RA) ? 1 : 0;

	/* packet security */
	if (XF_SEC_TYPE == _NO_PRIVACY_ || XF_SWENC == _TRUE) {
		mdata->sec_hw_enc = _FALSE;
		mdata->sec_type = RTW_ENC_NONE;
	} else {
		mdata->sec_hw_enc = _TRUE;
		mdata->sec_type = rtw_sec_algo_drv2phl(XF_SEC_TYPE);
		mdata->sec_cam_idx = get_security_cam_id(padapter, pxframe, XF_KEYIDX);
		mdata->hw_sec_iv = 1;
		if (mdata->bc || mdata->mc)
		{
			mdata->hw_sec_iv = 0;
			mdata->sw_sec_iv = 0;
			memcpy(mdata->iv, pxframe->attrib.pn, sizeof(mdata->iv));
		}

		mdata->sec_keyid = XF_KEYIDX;
		mdata->force_key_en = 1;
	}
	/* Currently dump secrity settings for dbg */
	RTW_DBG("sec_type= %d sec_hw_enc= %d sec_cam_idx= %d \n",
		mdata->sec_type, mdata->sec_hw_enc, mdata->sec_cam_idx);

	/* packet capability */
	if (pxframe->attrib.ampdu_en == _TRUE) {
		mdata->ampdu_en = 1;
		mdata->bk = 0;

		if (psta && psta->phl_sta) {
			mdata->max_agg_num = psta->phl_sta->asoc_cap.num_ampdu;
			mdata->ampdu_density = psta->phl_sta->asoc_cap.ampdu_density;
		}

		#ifdef RTW_WKRND_2G_AMPDU_LIMIT
		if (   (padapter->mlmepriv.ori_ch < 36)
		    && (mdata->max_agg_num > (RTW_WKRND_2G_AMPDU_LIMIT - 1)))  {
			mdata->max_agg_num = (RTW_WKRND_2G_AMPDU_LIMIT - 1);
		}
		#endif /* RTW_WKRND_2G_AMPDU_LIMIT */

		#ifdef RTW_PHL_DBG_CMD
		if (   padapter->txForce_aggnum != INV_TXFORCE_VAL
		    && padapter->txForce_aggnum != 0)
			mdata->max_agg_num = padapter->txForce_aggnum;

		if (padapter->txForce_ampdu_density != INV_TXFORCE_VAL)
			mdata->ampdu_density = padapter->txForce_ampdu_density;
		#endif /* RTW_PHL_DBG_CMD */
#ifdef WIFI_LOGO_HE_4_56_1
		if ((padapter->mlmepriv.ori_ch < 36) && padapter->mlmeextpriv.mlmext_info.is_HE_4_56_1) {
			mdata->max_agg_num = 0x1f;
		}
#endif
	} else {
		mdata->ampdu_en = 0;
		mdata->bk = 1;
	}
	mdata->dis_data_rate_fb = 0;
	mdata->dis_rts_rate_fb = 0;
	mdata->data_tx_cnt_lmt_en = 0;
	mdata->data_tx_cnt_lmt = 0;
	mdata->data_rty_lowest_rate = 0;
	mdata->life_time_sel = 0;

	mdata->f_bw = pxframe->attrib.bwmode;
	/* Todo: GI and LTF not ready for HE */
	mdata->f_gi_ltf = pxframe->attrib.sgi;

	/* packet type */
	//mdata->mc = IS_MCAST(XF_RA) ? 1 : 0;
	//mdata->bc = MacAddr_isBcst(XF_RA) ? 1 : 0;

	mdata->f_er = 0;
	mdata->f_dcm = 0;
	mdata->f_stbc = 0;
	mdata->f_ldpc = 0;
#ifdef USE_HIQ
	if ((pxframe->xftype != RTW_TX_DRV_MGMT) &&  (mdata->mc || mdata->bc)) {
		mdata->cat = RTW_PHL_RING_CAT_HIQ;      /* HIQ */
	}
	else
#endif
	{
		if (pxframe->xftype == RTW_TX_DRV_MGMT &&
			(subtype != WIFI_DATA_NULL && subtype != WIFI_QOS_DATA_NULL))
			mdata->cat = RTW_PHL_RING_CAT_MGNT;
		else
			mdata->cat = rtw_phl_cvt_tid_to_cat(pxframe->attrib.priority);
	}
	mdata->tid = XF_WL_TID;

#ifdef CONFIG_CORE_TXSC
	/* mdata->ampdu_density = 0; */
	mdata->userate_sel = 0;
#endif

	if (XF_TYPE == RTW_TX_DRV_MGMT) {
		mdata->userate_sel = 1;
		mdata->f_rate = _rate_mrate2phl(pxframe->attrib.rate);
		if (subtype == WIFI_PROBERSP) {
			mdata->data_tx_cnt_lmt_en = 1;
			mdata->data_tx_cnt_lmt = 1;
		}
	} else {
		/* low rate for EAPOL/ARP/DHCP */
#ifdef WIFI_LOGO_HE_4_52_1
		if (padapter->mlmeextpriv.mlmext_info.is_HE_4_52_1
			&& (XF_ETHTYPE == 0x0806)) {
			mdata->userate_sel = 0;
		} else
#endif
		if ((XF_ETHTYPE == 0x888e) ||
#ifdef CONFIG_RTL_CFG80211_WAPI_SUPPORT
		    (XF_ETHTYPE == 0x88B4) ||
#endif
		    (XF_ETHTYPE == 0x0806) ||
			(XF_DHCP == 1)) {
			mdata->userate_sel = 1;
			mdata->f_gi_ltf = 0;

			if (IS_CCK_RATE(padapter->mlmeextpriv.tx_rate))
				mdata->f_rate = RTW_DATA_RATE_CCK1;
			else
				mdata->f_rate = RTW_DATA_RATE_OFDM6;
		} else if (mdata->mc) {
			if (padapter->mc_rate == NO_FIX_RATE) {
				mdata->userate_sel = 1;
				mdata->f_gi_ltf = 0;

				if (IS_CCK_RATE(padapter->mlmeextpriv.tx_rate))
					mdata->f_rate = RTW_DATA_RATE_CCK1;
				else
					mdata->f_rate = RTW_DATA_RATE_OFDM6;
			} else {
				mdata->userate_sel = 1;
				mdata->f_rate = GET_FIX_RATE(padapter->mc_rate);
				mdata->f_gi_ltf = GET_FIX_RATE_SGI(padapter->mc_rate);
			}
		} else if (mdata->bc) {
			if (padapter->bc_rate == NO_FIX_RATE) {
				mdata->userate_sel = 1;
				mdata->f_gi_ltf = 0;

				if (IS_CCK_RATE(padapter->mlmeextpriv.tx_rate))
					mdata->f_rate = RTW_DATA_RATE_CCK1;
				else
					mdata->f_rate = RTW_DATA_RATE_OFDM6;
			} else {
				mdata->userate_sel = 1;
				mdata->f_rate = GET_FIX_RATE(padapter->bc_rate);
				mdata->f_gi_ltf = GET_FIX_RATE_SGI(padapter->bc_rate);
			}
		} else {
#ifdef WIFI_LOGO_HE_4_20_1
			if (padapter->mlmeextpriv.mlmext_info.is_HE_4_20_1_24G
				&& psta && psta->hepriv.he_option) {
				mdata->f_ldpc = 1;
				mdata->f_rate = RTW_DATA_RATE_HE_NSS1_MCS7;
				mdata->userate_sel = 1;
				mdata->dis_data_rate_fb = 1;
				mdata->dis_rts_rate_fb = 1;
			}
#endif
			/* fix rate for non specail packet */
			if (padapter->fix_rate != NO_FIX_RATE) {
				mdata->userate_sel = 1;
				mdata->f_rate = GET_FIX_RATE(padapter->fix_rate);
				mdata->f_gi_ltf = GET_FIX_RATE_SGI(padapter->fix_rate);
				if (!padapter->data_fb)
					mdata->dis_data_rate_fb = 1;
			} else if (psta->fixRate != 0 && psta->fixRate != NO_FIX_RATE) {
				mdata->userate_sel = 1;
				mdata->f_rate = GET_FIX_RATE(psta->fixRate);
				mdata->f_gi_ltf = GET_FIX_RATE_SGI(psta->fixRate);
				if (!padapter->data_fb)
					mdata->dis_data_rate_fb = 1;
			}

			if (padapter->fix_bw != NO_FIX_BW)
				mdata->f_bw = padapter->fix_bw;
		}

#ifdef CONFIG_LIFETIME_FEATURE
		if (pxframe->attrib.dhcp_pkt)
			mdata->life_time_sel = 0;
		else
		{
			if (padapter->registrypriv.wifi_mib.lifetime)
				mdata->life_time_sel = 1;
			else
				mdata->life_time_sel = 0;
		}
#endif
	}
#ifdef RTW_WKARD_RATE_DRV_CTRL
	if (mdata->userate_sel) {
		mdata->dis_data_rate_fb = 1;
		mdata->dis_rts_rate_fb = 1;
	}
#endif /* RTW_WKARD_RATE_DRV_CTRL */

	/* Always flag LDPC if peer's RX cap support it.
	   HW will prevent from sending LDPC coded frames
	   when TX rate is not allowed with LDPC coding. */
	mdata->f_ldpc = _ldpc_mapping(padapter, psta);

	mdata->band = 0;
	mdata->dma_ch = 0;

#ifdef CONFIG_GREEN_CHANNEL_FOR_LATENCY_STA
	if (psta && psta->phl_sta && psta->phl_sta->is_latency_sta && padapter->registrypriv.wifi_mib.latency_hiq) {
		mdata->cat = RTW_PHL_RING_CAT_HIQ;
		mdata->dma_ch = RTW_PHL_RING_CAT_HIQ;
	}
#endif

#ifdef CONFIG_CORE_TXSC
	mdata->wp_offset = 56;
	mdata->wd_page_size = 1;
	mdata->pktlen = txreq->total_len;
#endif

#ifdef CONFIG_24G_256QAM
	if (XF_TYPE == RTW_TX_DRV_MGMT && pxframe->attrib.tx_force_rate != INV_TXFORCE_VAL) {
		mdata->userate_sel = 1;
		mdata->dis_data_rate_fb = 1;
		mdata->dis_rts_rate_fb = 1;
		mdata->f_rate = pxframe->attrib.tx_force_rate;
	}
#endif

#ifdef RTW_PHL_DBG_CMD
	if(XF_TYPE != RTW_TX_DRV_MGMT){
		if(padapter->txForce_enable){
			mdata->wdinfo_en = 1;
			if(padapter->txForce_rate != INV_TXFORCE_VAL && !mdata->userate_sel){
				mdata->userate_sel = 1;
				mdata->dis_data_rate_fb = 1;
				mdata->dis_rts_rate_fb = 1;
				mdata->f_rate = padapter->txForce_rate;
			}
			if(padapter->txForce_agg != INV_TXFORCE_VAL)
				mdata->ampdu_en = padapter->txForce_agg;
			if(padapter->txForce_aggnum != INV_TXFORCE_VAL)
				mdata->max_agg_num = (padapter->txForce_aggnum);
			if(padapter->txForce_gi != INV_TXFORCE_VAL)
				mdata->f_gi_ltf = padapter->txForce_gi;
			if(padapter->txForce_bw != INV_TXFORCE_VAL)
				mdata->f_bw = padapter->txForce_bw;
			if(padapter->txForce_ampdu_density != INV_TXFORCE_VAL)
				mdata->ampdu_density = padapter->txForce_ampdu_density;
		}
	}
#endif

	/* set RTS/CTS mode */
	mdata->rts_en = XF_RTS;
	mdata->cts2self = XF_CTS2SELT;
	mdata->hw_rts_en = XF_HWRTS;
	mdata->rts_cca_mode = 0;
#ifdef WKARD_RTSCTS_EN
	if ((padapter->registrypriv.vrtl_carrier_sense != DISABLE_VCS) &&
			(padapter->registrypriv.vcs_type == RTS_CTS)) {
		if (mdata->type == RTW_PHL_PKT_TYPE_DATA) {
			mdata->rts_en = 1;
			mdata->hw_rts_en = 1;
		}
	}
	else
#endif /* WKARD_RTSCTS_EN */
	{
#ifdef DYNAMIC_RTS_CONTROL
		check_rts(padapter, psta, mdata);
#endif
	}
	//mdata->rts_en = 1;

#ifdef CONFIG_RTW_TXSC_USE_HW_SEQ
	if (mdata->type == RTW_PHL_PKT_TYPE_DATA &&
		pxframe->attrib.qos_en &&
		!(mdata->mc || mdata->bc))
		mdata->hw_seq_mode = 1;
#else

#if defined(CONFIG_CORE_TXSC) && defined(CONFIG_TXSC_AMSDU)
	if (pxmitpriv->txsc_amsdu_enable)
		mdata->hw_seq_mode = 0;
#endif
#endif

#ifdef CTC_QOS_DSCP
	/* not use HW SEQ */
	if (padapter->registrypriv.ctc_dscp)
		mdata->hw_seq_mode = 0;
#endif

#ifdef CONFIG_RTW_MULTI_AP_R3
#ifdef CONFIG_RTW_MULTI_AP_LOGO
	mdata->hw_seq_mode = 0;
#endif
#endif

#ifdef CONFIG_CORE_TXSC
	print_txreq_mdata(mdata, __FUNCTION__);
#endif

	if (XF_TXREQ_CNT > 1) {
		struct rtw_t_meta_data *mdata_tmp;
		txreq++;
		for (idx = 1; idx < XF_TXREQ_CNT; idx++) {
#ifdef CONFIG_CORE_TXSC
			mdata->pktlen = txreq->total_len;
#endif
			mdata_tmp = &(txreq->mdata);
			memcpy(mdata_tmp, mdata, sizeof(struct rtw_t_meta_data));
			txreq++;
		}
	}

}


void fill_txreq_others(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct rtw_xmit_req *txreq = XF_TXREQ;
	u32 idx = 0;

	PHLTX_ENTER;

	for(idx=0; idx<XF_TXREQ_CNT; idx++){
		txreq->os_priv = pxframe;
		txreq++;
	}
}

u8 core_wlan_fill_txreq_pre(_adapter *padapter, struct xmit_frame *pxframe)
{
	u32 frag_perfr, wl_frags = 0;

	if(XF_TYPE == RTW_TX_OS){
		get_wl_frag_paras(padapter, pxframe, &frag_perfr, &wl_frags);
		if (wl_frags > RTW_MAX_FRAG_NUM) {
			RTW_PRINT(" !!! Error wl_frags %d\n",wl_frags);/* mlog */
			return _FAIL;
		}
		if(fill_txreq_pkt_perfrag_txos(padapter, pxframe, frag_perfr, wl_frags, pxframe->attrib.psta)==_FAIL)
			return _FAIL;
	}
	else if(XF_TYPE == RTW_TX_DRV_MGMT){
		if(fill_txreq_pkt_mgmt(padapter, pxframe)==_FAIL)
			return _FAIL;
	}

	return _SUCCESS;
}

void core_wlan_fill_txreq_post(_adapter *padapter, struct xmit_frame *pxframe)
{
	fill_txreq_mdata(padapter, pxframe);
	fill_txreq_others(padapter, pxframe);

#ifdef CONFIG_PCI_HCI
	/*must be called after all pkt contents modified (cache sync)*/
	fill_txreq_phyaddr(padapter, pxframe);
#endif

}

void core_wlan_fill_head(_adapter *padapter, struct xmit_frame *pxframe)
{
	if(XF_TYPE == RTW_TX_OS){
		u32 idx = 0;
		for(idx=0; idx<XF_NR_FRAGS; idx++){
			u8 *pwlanhdr = pxframe->wlhdr[idx];

			if(!pwlanhdr){
				PHLTX_ERR;
				continue;
			}

			rtw_make_wlanhdr(padapter, pwlanhdr, &XF_ATTRIB); //rtw_core_make_wlanhdr(padapter, pwlanhdr, pxframe);

			if(idx==(XF_NR_FRAGS-1))
				ClearMFrag(pwlanhdr);
			else
				SetMFrag(pwlanhdr);

			update_attrib_sec_iv_info(padapter, &XF_ATTRIB);
			if (XF_IVLEN)
				_rtw_memcpy((pwlanhdr+XF_WL_HDRLEN), XF_IV, XF_IVLEN);

			if (idx == 0 && !XF_WL_AMSDU) {
				/* Add LLC/SNAP to first fragment */
				if(XF_VLAN_PROTO)
					rtw_put_snap(pwlanhdr+XF_WL_HDRLEN+XF_IVLEN, XF_VLAN_PROTO);
				else
					rtw_put_snap(pwlanhdr+XF_WL_HDRLEN+XF_IVLEN, XF_ETHTYPE);
			}

#ifdef RTW_PHL_TEST_FPGA
{
	struct rtw_ieee80211_hdr *p = (struct rtw_ieee80211_hdr *)pwlanhdr;
	unsigned short		*fctrl;
	unsigned int pktlen = 0;
	u16 *qc;

	test_seq++;
	test_seq = test_seq%0xFFF;
	SetSeqNum(p, test_seq);
}
#endif

		}
	}
}


void core_wlan_fill_tail(_adapter *padapter, struct xmit_frame *pxframe)
{
	;

}


u8 core_wlan_fill_tkip_mic(_adapter *padapter, struct xmit_frame *pxframe)
{
	u8 *llc = NULL;
	u8 *payload = NULL;
	u8 mic[8] = {0x0};
	struct mic_data micdata;
	struct pkt_attrib *pattrib = &pxframe->attrib;
	struct security_priv *psecuritypriv = &padapter->securitypriv;
	s8 bmcst = IS_MCAST(pattrib->ra);
	u8 priority[4] = {0x0};

	if (pattrib->encrypt == _TKIP_) {
		u8 null_key[16] = {0x0};

		/* set TKIP MIC key */
		if (bmcst) {
			if (_rtw_memcmp(
					psecuritypriv->dot118021XGrptxmickey[psecuritypriv->dot118021XGrpKeyid].skey,
					null_key, 16) == _TRUE)
				return _FAIL;

			rtw_secmicsetkey(&micdata,
				psecuritypriv->dot118021XGrptxmickey[psecuritypriv->dot118021XGrpKeyid].skey);
		} else {
			if (_rtw_memcmp(
					&pattrib->dot11tkiptxmickey.skey[0],
					null_key, 16) == _TRUE)
				return _FAIL;

			rtw_secmicsetkey(&micdata, &pattrib->dot11tkiptxmickey.skey[0]);
		}

		/* set DA, SA */
		rtw_secmicappend(&micdata, &pattrib->dst[0], 6);
		rtw_secmicappend(&micdata, &pattrib->src[0], 6);

		if (pattrib->qos_en)
			priority[0] = pattrib->priority;

		/* set priority */
		rtw_secmicappend(&micdata, &priority[0], 4);

		/* set LLC; TBD: should check if LLC is existed or not */
		llc = XF_WLHDR[0] + XF_WL_HDRLEN + XF_IVLEN;
		rtw_secmicappend(&micdata, llc, SNAP_SIZE + sizeof(u16));

		/* set MSDU payload */
		payload = XF_SKB->data + XF_HDRLEN;
		//payload = (u8 *)RND4((SIZE_PTR)(payload));
		rtw_secmicappend(&micdata, payload, XF_SZ_PAYLOAD);

		/* calculate MIC */
		rtw_secgetmic(&micdata, &mic[0]);

		/* append MIC to the last tail */
		_rtw_memcpy(XF_WLTAIL[XF_NR_FRAGS-1], &(mic[0]), 8);
	}

	return _SUCCESS;
}


static void core_wlan_sw_encrypt(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct pkt_attrib *attrib;
	u8 res;


	attrib = &pxframe->attrib;
	if (!attrib->encrypt)
		return;
	if (!attrib->bswenc)
		return;

	/* convert txreq to one piece */
	res = merge_txreq_to_one_piece(padapter, pxframe);
	if (res != _SUCCESS) {
		RTW_ERR("%s: fail alloc buffer for sw enc!\n", __func__);
		return;
	}
	xmitframe_swencrypt(padapter, pxframe);
}

#ifdef CONFIG_TX_AMSDU_SW_MODE
static bool core_tx_amsdu_timeout(_adapter *padapter, struct pkt_attrib *pattrib)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	u8 amsdu_timeout;

	amsdu_timeout = rtw_amsdu_get_timer_status(padapter, pattrib->priority);

	if (amsdu_timeout == RTW_AMSDU_TIMER_UNSET) {
		rtw_amsdu_set_timer_status(padapter,
			pattrib->priority, RTW_AMSDU_TIMER_SETTING);
		rtw_amsdu_set_timer(padapter, pattrib->priority);
		pxmitpriv->amsdu_debug_set_timer++;
		return false;
	} else if (amsdu_timeout == RTW_AMSDU_TIMER_SETTING) {
		return false;
	} else if (amsdu_timeout == RTW_AMSDU_TIMER_TIMEOUT) {
		rtw_amsdu_set_timer_status(padapter,
			pattrib->priority, RTW_AMSDU_TIMER_UNSET);
		pxmitpriv->amsdu_debug_timeout++;
		return true;
	}

	return false;
}

/* 'pxframes[]' is array to store xframe to do AMSDU whose size is 'max_xf_nr',
 * and return value is real used size. If return size is 1, then set 'amsdu' to
 * decide normal frame or AMSDU one.
 */
static int core_tx_amsdu_dequeue(_adapter *padapter, struct xmit_frame *pxframes[],
				 int max_xf_nr, bool *amsdu)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct xmit_frame *pxframe;
	int tx_amsdu = rtw_min(padapter->tx_amsdu, max_xf_nr);
	int tx_amsdu_rate = padapter->tx_amsdu_rate;
	int current_tx_rate = dvobj->traffic_stat.cur_tx_tp;
	int num_frame;
	int nr_xf;

	if (tx_amsdu == 0)
		goto dequeue_normal_pkt;

	if (!MLME_IS_STA(padapter))
		goto dequeue_normal_pkt;

	if (tx_amsdu >= 2 && tx_amsdu_rate && current_tx_rate < tx_amsdu_rate)
		goto dequeue_normal_pkt;

	pxframe = rtw_get_xframe(pxmitpriv, &num_frame);
	if (num_frame == 0 || !pxframe)
		return 0;

	if (num_frame < tx_amsdu) {	/* Not enough MSDU for specific A-MSDU */
		if (!core_tx_amsdu_timeout(padapter, &pxframe->attrib))
			return 0;	/* Not timeout yet */
	}

	for (nr_xf = 0; nr_xf < tx_amsdu; nr_xf++) {
		pxframe = rtw_get_xframe(pxmitpriv, &num_frame);

		if (num_frame == 0 || !pxframe)
			break;

		if (!check_amsdu(pxframe))
			break;

		/* TODO: check if size is over peer's capability */

		pxframe = rtw_dequeue_xframe(pxmitpriv, pxmitpriv->hwxmits,
					     pxmitpriv->hwxmit_entry);

		pxframes[nr_xf] = pxframe;
	}

	if (nr_xf == 0 && num_frame > 0)
		goto dequeue_normal_pkt;

	if (nr_xf == 1)
		pxmitpriv->amsdu_debug_coalesce_one++;
	else if (nr_xf == 2)
		pxmitpriv->amsdu_debug_coalesce_two++;

	*amsdu = (nr_xf == 1 && tx_amsdu >= 2) ? false : true;

	return nr_xf;

dequeue_normal_pkt:
	pxframe = rtw_dequeue_xframe(pxmitpriv, pxmitpriv->hwxmits,
				     pxmitpriv->hwxmit_entry);
	if (!pxframe)
		return 0;

	pxframes[0] = pxframe;
	*amsdu = false;

	return 1;
}

static bool core_tx_amsdu_dump(_adapter *padapter, struct xmit_frame *pxframes[],
			       int xf_nr, bool amsdu)
{
	struct xmit_frame *head_xframe;
	struct pkt_attrib *head_attrib;
	u32 pktlen;

	/* prepare head xmitframe */
	head_xframe = pxframes[0];
	head_attrib = &head_xframe->attrib;

	if (xf_nr == 1 && !amsdu)
		goto dump_pkt;

	rtw_coalesce_tx_amsdu(padapter, pxframes, xf_nr, amsdu, &pktlen);

	/* update proper attribute */
	head_attrib->amsdu = 1;
	head_attrib->pkt_hdrlen = 0;
	head_attrib->pktlen = pktlen;

dump_pkt:
	if (core_tx_prepare_phl(padapter, head_xframe) == FAIL)
		goto abort_core_tx;

	if (core_tx_call_phl(padapter, head_xframe, NULL) == FAIL)
		goto abort_core_tx;

	return true;

abort_core_tx:
	core_tx_free_xmitframe(padapter, head_xframe);

	return true;
}

void core_tx_amsdu_tasklet(_adapter *padapter)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct xmit_frame *pxframes[5];
	int xf_nr;
	bool amsdu;

	pxmitpriv->amsdu_debug_tasklet++;

	while (1) {
		xf_nr = core_tx_amsdu_dequeue(padapter, pxframes, ARRAY_SIZE(pxframes),
					      &amsdu);
		if (xf_nr == 0)
			break;

		pxmitpriv->amsdu_debug_dequeue++;

		core_tx_amsdu_dump(padapter, pxframes, xf_nr, amsdu);
	}
}

static s32 core_tx_amsdu_enqueue(_adapter *padapter, struct xmit_frame *pxframe)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct pkt_attrib *pattrib = &pxframe->attrib;
	int tx_amsdu = padapter->tx_amsdu;
	u8 amsdu_timeout;
	s32 res;

	if (MLME_IS_STA(padapter) && check_amsdu_tx_support(padapter)) {
		if (IS_AMSDU_AMPDU_VALID(pattrib))
			goto enqueue;
	}

	return FAIL;

enqueue:
	_rtw_spinlock_bh(&pxmitpriv->lock);

	res = rtw_xmitframe_enqueue(padapter, pxframe);
	if (res == _FAIL) {
		_rtw_spinunlock_bh(&pxmitpriv->lock);
		return FAIL;
	}

	pxmitpriv->amsdu_debug_enqueue++;

	if (tx_amsdu == 2) {
		amsdu_timeout = rtw_amsdu_get_timer_status(padapter, pattrib->priority);
		if (amsdu_timeout == RTW_AMSDU_TIMER_SETTING) {
			rtw_amsdu_cancel_timer(padapter, pattrib->priority);
			rtw_amsdu_set_timer_status(padapter, pattrib->priority,
				RTW_AMSDU_TIMER_UNSET);
		}
	}

	_rtw_spinunlock_bh(&pxmitpriv->lock);

	rtw_tasklet_hi_schedule(&pxmitpriv->xmit_tasklet);

	return _TRUE;
}
#endif /* CONFIG_TX_AMSDU_SW_MODE */

s32 core_tx_prepare_phl(_adapter *padapter, struct xmit_frame *pxframe)
{
	if(core_wlan_fill_txreq_pre(padapter, pxframe)==_FAIL)
		return FAIL;

	if(XF_TYPE == RTW_TX_OS){
		core_wlan_fill_head(padapter, pxframe);
		if (core_wlan_fill_tkip_mic(padapter, pxframe) == _FAIL) {
			RTW_ERR("core_wlan_fill_tkip_mic FAIL\n");
			return FAIL;
		}
	}
	core_wlan_fill_tail(padapter, pxframe);
	core_wlan_sw_encrypt(padapter, pxframe);

	core_wlan_fill_txreq_post(padapter, pxframe);

	return SUCCESS;
}

#ifdef CONFIG_TX_DEFER
void txdefer_timer_handler(void *context){

	_adapter *padapter = (_adapter *)context;
	struct dvobj_priv *drv_priv = adapter_to_dvobj(padapter);
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;

	if(ATOMIC_READ(&pxmitpriv->defer_tx_cnt) != 0) {
		ATOMIC_SET(&pxmitpriv->defer_tx_cnt, 0);
		rtw_phl_tx_req_notify(padapter->dvobj->phl);
	}


	if (netif_running(padapter->pnetdev))
		_set_timer(&pxmitpriv->tx_defer_timer, padapter->registrypriv.wifi_mib.defertxtimeout);

}
#endif

#ifdef CONFIG_LMT_TXREQ
u8 _txreq_lmt_check_pending(struct sta_info *psta)
{
	u8 ret = _TRUE;

	if (psta->lmt_pending_txreq && ATOMIC_READ(&psta->num_pending_txreq) >= psta->lmt_pending_txreq) {
		psta->lmt_txreq_drop++;
		ret = _FALSE;
	}

	return ret;
}

u8 _txreq_lmt_check(_adapter *padapter, struct rtw_xmit_req *txreq, struct sta_info *psta, u8 *acq)
{
	u8 ret = _TRUE;
	extern uint rtw_wifi_mode;
	extern uint rtw_2gtxreq_limit;
	extern uint rtw_5gtxreq_limit;
	uint rtw_txreq_limit = (rtw_get_oper_ch(padapter) >= 36) ? rtw_5gtxreq_limit : rtw_2gtxreq_limit;
	static const u8 tid_2_qsel[8] = {0 ,1, 1, 0, 2, 2, 3, 3};

	if (txreq->mdata.tid > 7)
		return ret;

	*acq = tid_2_qsel[txreq->mdata.tid];

	if(psta->lmt_pending_txreq_ac[*acq]
		&& ATOMIC_READ(&psta->num_pending_txreq_ac[*acq]) >= psta->lmt_pending_txreq_ac[*acq]) {
		psta->lmt_txreq_drop++;
		ret = _FALSE;
	}

	if ((padapter->dvobj->wmm_mode || padapter->dvobj->wmm_test || rtw_wifi_mode)
		&& ATOMIC_READ(&psta->num_pending_txreq_ac[*acq]) >= rtw_txreq_limit) {
		psta->lmt_txreq_drop++;
		ret = _FALSE;
	}

	return ret;
}
#endif

#ifdef RTW_CORE_PKT_TRACE
static inline void rtw_core_txreq_malloc_pktinfo(struct rtw_pkt_trace_info *pktinfo, int pkt_cnt, struct rtw_xmit_req *txreq)
{
	if(pktinfo->parsed)
	{
		txreq->pktinfo = _rtw_zmalloc(sizeof(struct rtw_pkt_trace_info) * pkt_cnt);
		if(txreq->pktinfo)
		{
			txreq->trace_pkt_cnt = pkt_cnt;
			memcpy(txreq->pktinfo, pktinfo, sizeof(struct rtw_pkt_trace_info) * pkt_cnt);
		}
	}
}
#endif

__IMEM_WLAN_SECTION__
s32 core_tx_call_phl(_adapter *padapter, struct xmit_frame *pxframe, void *txsc_pkt)
{
	struct rtw_xmit_req *txreq = NULL;
	struct sta_info *psta = NULL;
	void *phl = padapter->dvobj->phl;
	u32 idx = 0, txreq_cnt = 0;
#ifdef CONFIG_VW_REFINE
	u32 vw_cnt = 0;
#endif
#ifdef CONFIG_CORE_TXSC
	struct rtw_xmit_req *ptxsc_txreq = NULL;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct txsc_pkt_entry *ptxsc_pkt;
#ifdef CONFIG_TXSC_AMSDU
	struct txsc_amsdu_swq *txq = NULL;
#endif
#endif
	enum rtw_packet_type type = 0;
	s8 add_sts = RTW_PHL_STATUS_FAILURE;/* CONFIG_VW_REFINE */
#ifdef RTW_CORE_PKT_TRACE
	int i;
#endif
#ifdef CONFIG_LMT_TXREQ
	u8 acq = 4;
#endif
#ifdef CONFIG_ONE_TXQ
	struct xmit_txreq_buf *ptxreq_buf = NULL;
	struct sk_buff *tx_skb = NULL;
	u32 ts_consumed = 0;
	int update_ts = 0;
#endif
	u32 slow_data_req_cnt = 0;

#ifdef CONFIG_CORE_TXSC
	ptxsc_pkt = (struct txsc_pkt_entry *)txsc_pkt;
	if (ptxsc_pkt) {
		ptxsc_txreq = ptxsc_pkt->ptxreq;
		#ifdef CONFIG_VW_REFINE
		vw_cnt = ptxsc_pkt->vw_cnt;
		#endif
	}

	if(pxframe) {
		txreq = XF_TXREQ;
		txreq_cnt = XF_TXREQ_CNT;
		psta = pxframe->attrib.psta;
	} else {
		txreq = ptxsc_txreq;
		txreq_cnt = 1;
		if (ptxsc_pkt)
			psta = ptxsc_pkt->psta;
	}
#ifdef CONFIG_TXSC_AMSDU
	if (psta && ptxsc_pkt) {
		txq = &psta->amsdu_txq[ptxsc_pkt->ac];
		if (!ptxsc_pkt->is_amsdu_timeout && ptxsc_pkt->step == TXSC_AMSDU_APPLY) {
			_txsc_spinlock_bh(&txq->txsc_amsdu_lock);
			txq->is_normal_deq = 0;
			_txsc_spinunlock_bh(&txq->txsc_amsdu_lock);
		}
	}
#endif
#else
	txreq = XF_TXREQ;
	txreq_cnt = XF_TXREQ_CNT;
	psta = pxframe->attrib.psta;
#endif

	if(!txreq){
		goto abort_call_phl;
	}

#ifdef CONFIG_LMT_TXREQ
	if (psta && padapter->lmt_txreq_enable == 1) {
	if (_txreq_lmt_check(padapter, txreq, psta, &acq) == _FALSE)
		goto abort_call_phl;
	}
#endif

	for(idx = 0; idx < txreq_cnt; idx++){
#ifdef RTW_PHL_TEST_FPGA
		core_add_record(padapter, padapter->record_enable, REC_TX_PHL, txreq);
#endif

#ifdef CONFIG_CORE_TXSC
		if (ptxsc_txreq != NULL) {
			rtw_count_tx_stats_tx_req(padapter, ptxsc_txreq, ptxsc_pkt->psta);
#ifdef CONFIG_VW_REFINE
			DBG_COUNTER_NUM(padapter->tx_logs.core_vw_add_tx_req, vw_cnt);
#endif
		} else
#endif
		if (pxframe)
			rtw_count_tx_stats(padapter, pxframe, pxframe->attrib.pktlen);

#ifdef RTW_CORE_PKT_TRACE
		if(padapter->pkt_trace_enable)
		{
			if(pxframe)
			{
				RTW_TX_TRACE(padapter,&pxframe->attrib.pktinfo);
			}
			else
			{
				for(i = 0; i < ptxsc_pkt->skb_cnt; i++) {
					RTW_TX_TRACE(padapter,&ptxsc_pkt->pktinfo[idx]);
				}
			}
		}
#endif

		type = txreq->mdata.type;

#ifdef CONFIG_ONE_TXQ
		update_ts = 0;

		if (padapter->dvobj->tx_mode == 2) {
#ifdef CONFIG_CORE_TXSC
			if (ptxsc_txreq != NULL) {
				ptxreq_buf = (struct xmit_txreq_buf *)txreq->os_priv;
				tx_skb = (struct sk_buff *)ptxreq_buf->pkt[0];
				if (tx_skb) {
					ts_consumed = *(u32 *)&tx_skb->cb[_SKB_CB_AIRTIME];
					update_ts = 1;
				}
			} else
#endif
			if (pxframe->pkt) {
				ts_consumed = *(u32 *)&pxframe->pkt->cb[_SKB_CB_AIRTIME];
				update_ts = 1;
			}
		}
#endif

		add_sts = rtw_phl_add_tx_req(phl, txreq);
		if (add_sts != RTW_PHL_STATUS_SUCCESS) {
#ifdef RTW_CORE_PKT_TRACE
			if (padapter->pkt_trace_enable) {
				if (pxframe) {
					RTW_TX_TRACE(padapter,&pxframe->attrib.pktinfo);
				} else {
					for(i = 0; i < ptxsc_pkt->skb_cnt; i++) {
						RTW_TX_TRACE(padapter,&ptxsc_pkt->pktinfo[i]);
					}
				}
			}
#endif

			//Add txreq fail, reverse count
#ifdef CONFIG_CORE_TXSC
			if (ptxsc_txreq != NULL) {
				rtw_reverse_count_tx_stats_tx_req(padapter, ptxsc_txreq, ptxsc_pkt->psta);
#ifdef CONFIG_VW_REFINE
				DBG_REVERSE_COUNTER_NUM(padapter->tx_logs.core_vw_add_tx_req, vw_cnt);
#endif
			} else
#endif
			if (pxframe)
				rtw_reverse_count_tx_stats(padapter, pxframe, pxframe->attrib.pktlen);

			goto abort_call_phl;
		}

#ifdef RTW_CORE_PKT_TRACE
		if(padapter->pkt_trace_enable)
		{
			if(pxframe)
			{
				rtw_core_txreq_malloc_pktinfo(&pxframe->attrib.pktinfo, 1, txreq);
			}
#ifdef CONFIG_CORE_TXSC
			else
			{
				rtw_core_txreq_malloc_pktinfo(&ptxsc_pkt->pktinfo[0], ptxsc_pkt->skb_cnt, txreq);
			}
#endif
		}
#endif
		if (type == RTW_PHL_PKT_TYPE_DATA) {
			if (txreq_cnt != 1)
				slow_data_req_cnt++;
			else
				DBG_COUNTER(padapter->tx_logs.core_tx_add_req_data);
			if (psta) {
				psta->sta_stats.tx_add_req_data++;
				#ifdef CONFIG_LMT_TXREQ
				ATOMIC_INC(&psta->num_pending_txreq);
				if (acq != 4)
					ATOMIC_INC(&psta->num_pending_txreq_ac[acq]);
				#endif
				#ifdef CONFIG_ONE_TXQ
				if (padapter->dvobj->tx_mode == 2) {
					if (update_ts) {
						ATOMIC_ADD(&psta->sta_xmitpriv.txreq_ts_used, ts_consumed);
						psta->sta_xmitpriv.txreq_ts_used_total += ts_consumed;
						ATOMIC_INC(&psta->sta_xmitpriv.txreq_used);
					}
				}
				#endif
			}
		} else if (type == RTW_PHL_PKT_TYPE_MGNT)
			DBG_COUNTER(padapter->tx_logs.core_tx_add_req_mgnt);

		#ifdef CONFIG_VW_REFINE
		//DBG_COUNTER_NUM(padapter->tx_logs.core_vw_add_tx_req, txreq->vw_cnt);
		#endif
#ifdef CONFIG_TX_DEFER
		if(pxmitpriv->defer_tx_flag) {
			if ((ATOMIC_READ(&pxmitpriv->defer_tx_cnt) > padapter->registrypriv.wifi_mib.defer_tx_cnt)
				#ifdef CONFIG_GREEN_CHANNEL_FOR_LATENCY_STA
				|| (psta && psta->phl_sta->is_latency_sta)
				#endif
				)
			{
				rtw_phl_tx_req_notify(phl);
				ATOMIC_SET(&pxmitpriv->defer_tx_cnt, 0);
			} else
				ATOMIC_INC(&pxmitpriv->defer_tx_cnt);
		} else
#endif
		{
			rtw_phl_tx_req_notify(phl);
		}
		txreq++;
	}

	if (txreq_cnt != 1)
		padapter->tx_logs.core_tx_add_req_data += slow_data_req_cnt;

	return SUCCESS;

abort_call_phl:
	DBG_COUNTER(padapter->tx_logs.core_tx_err_add_req);
	return FAIL;
}

#ifdef CONFIG_RTK_TRANSPORTABLE_PROTO
extern int is_transportable_pkt(struct sk_buff *pskb);
#endif

__IMEM_WLAN_SECTION__
s32 rtw_core_tx(_adapter *padapter, struct sk_buff **pskb, struct sta_info *psta)
{
	struct xmit_frame *pxframe = NULL;
	u8 abort_core_tx_flag = 0;
	s32 sts, ret = FAIL;
	struct sk_buff *my_pskb = *pskb;
	u8 is_vw_pkt =0;
#ifdef RTW_CORE_PKT_TRACE
	int i;
#endif

#ifdef CONFIG_CORE_TXSC
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct txsc_pkt_entry txsc_pkt;
	u8 skip_add_txsc = 0;
#ifdef CONFIG_TXSC_AMSDU
	u8 status = TXSC_AMSDU_NEED_DEQ;
#endif
#endif

#ifdef CONFIG_CORE_TXSC
	memset(&txsc_pkt, 0, sizeof(struct txsc_pkt_entry));
	txsc_pkt.ptxreq = NULL;
	txsc_pkt.txsc_id = 0xff;
#ifdef CONFIG_TXSC_AMSDU
	txsc_pkt.amsdu = false;
#endif
#endif

#ifdef CONFIG_RTK_TRANSPORTABLE_PROTO
	if(MLME_IS_STA(padapter) && padapter->registrypriv.wifi_mib.trans_proto_enable
	&& is_transportable_pkt(my_pskb) == 0)
		goto abort_core_tx;
#endif

#ifdef CONFIG_RTW_MULTI_AP_R2
	if (core_map_tx_vlan_process(padapter, my_pskb, psta) != MAP_TX_CONTINUE)
		goto abort_core_tx;
#endif

#ifdef CONFIG_RTW_MULTI_AP_R3
	if (core_map_tx_set_vlan_pcp(padapter, my_pskb, psta) != MAP_TX_CONTINUE)
		goto abort_core_tx;
#endif
#ifdef CONFIG_LMT_TXREQ
	if (psta && padapter->lmt_txreq_enable == 1) {
		if (_txreq_lmt_check_pending(psta) == _FALSE)
		goto abort_core_tx;
	}
#endif

#ifdef GBWC
	if (psta && padapter->registrypriv.wifi_mib.gbwcmode) {
		ret = gbwc_tx(padapter, *pskb, psta);
		if (ret == GBWC_DROP_SKB) {
			ret = FAIL;
			goto abort_core_tx;
		} else if (ret == GBWC_QUEUE_SKB) {
			return SUCCESS;
		}
	}
#endif

#ifdef CONFIG_CORE_TXSC
	pxmitpriv->core_tx_pkts++;

#ifdef CONFIG_A4_LOOPBACK
	if (padapter->a4_enable) {
		if(IS_MCAST(my_pskb->data))
			rtw_update_a4_loop_entry(padapter, my_pskb->data + ETH_ALEN);
	}
#endif

	_txsc_one_spinlock_bh(&pxmitpriv->txsc_lock, NULL);

	if (txsc_get_sc_cached_entry(padapter, *pskb, &txsc_pkt, psta) == _SUCCESS) {
		RTW_TX_TRACE_ETH_TXSC(padapter, txsc_pkt);
		DBG_COUNTER(padapter->tx_logs.core_tx_txsc);
		goto core_txsc;
	}
#ifdef CONFIG_VW_REFINE
	else {
		_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);
		if (psta != NULL && !((psta->flags & WLAN_STA_MFP) && (*(u16 *)(my_pskb->cb + _SKB_CB_ETH_PROTOCOL) == ETH_P_PAE)))
			txsc_issue_addbareq_cmd(padapter, 0, psta, _TRUE);
	}
#endif
#endif

#if 0//def CONFIG_ETHER_PKT_AGG
	if(txsc_pkt.isAggPkt) {
		GDEBUG("[ERROR] agg pkt doesn't enter to txsc path\n");
	}
#endif /* CONFIG_ETHER_PKT_AGG */

	if (core_tx_alloc_xmitframe(padapter, &pxframe, *pskb) == FAIL) {
		abort_core_tx_flag = 1;
		goto abort_core_tx;
	}

	RTW_TX_TRACE_ETH_XFRAME(padapter,pxframe, my_pskb);

	if (core_tx_update_pkt(padapter, pxframe, pskb) == FAIL) {
		RTW_TX_TRACE_XFRAME(padapter,pxframe);
		abort_core_tx_flag = 2;
		goto abort_core_tx;
	}

	if (core_tx_update_xmitframe(padapter, pxframe, pskb, psta, RTW_TX_OS) == FAIL) {
		RTW_TX_TRACE_XFRAME(padapter,pxframe);
		abort_core_tx_flag = 3;
		goto abort_core_tx;
	}

#ifdef CONFIG_80211N_HT
	if (/*(pxframe->attrib.ether_type != 0x0806)
	    &&*/ (pxframe->attrib.ether_type != 0x888e)
	    && (pxframe->attrib.dhcp_pkt != 1))
		rtw_issue_addbareq_cmd(padapter, pxframe, _TRUE);
#endif /* CONFIG_80211N_HT */

#ifdef CONFIG_TX_AMSDU_SW_MODE
#ifdef CONFIG_ETHER_PKT_AGG
	if(!pxframe->attrib.isAggPkt)
#endif /* CONFIG_ETHER_PKT_AGG */
	{
		if (core_tx_amsdu_enqueue(padapter, pxframe) == _TRUE) {
			RTW_TX_TRACE_XFRAME(padapter,pxframe);
			return SUCCESS;	/* queued to do AMSDU */
		}
	}
#endif

#ifdef CONFIG_RTW_HANDLE_SER_L2
	if (padapter->dvobj->ser_L2_inprogress &&
	    XF_SEC_TYPE != _NO_PRIVACY_ && XF_SWENC != _TRUE) {
	    	pxframe->attrib.bswenc = _TRUE;
		skip_add_txsc = 1;
	}
#endif

	if (core_tx_prepare_phl(padapter, pxframe) == FAIL) {
		RTW_TX_TRACE_XFRAME(padapter,pxframe);
		abort_core_tx_flag = 4;
		goto abort_core_tx;
	}

#ifdef CONFIG_CORE_TXSC

	if (skip_add_txsc) {
		DBG_COUNTER(padapter->tx_logs.core_tx_direct_phl);
		goto direct_call_phl;
	}

	/* pskb may be changed, so let xmit_skb[0] re-point to it */
	txsc_pkt.xmit_skb[0] = *pskb;

	txsc_add_sc_cache_entry(padapter, pxframe, &txsc_pkt);
	goto direct_call_phl;

core_txsc:

#ifdef CONFIG_TXSC_AMSDU
#if defined(CONFIG_VW_REFINE) || defined(CONFIG_ONE_TXQ)
	if (padapter->dvobj->tx_mode == 0)
#endif
	if (txsc_pkt.step == TXSC_AMSDU_APPLY && txsc_amsdu_enqueue(padapter, &txsc_pkt, &status) == _SUCCESS) {
		if (status == TXSC_AMSDU_ENQ_ABORT) {
			RTW_TX_TRACE_CORE(padapter, pxframe, txsc_pkt, i, 1);
			abort_core_tx_flag = 5;
			txsc_amsdu_process_check(padapter, &txsc_pkt);
			#ifdef CONFIG_WFA_OFDMA_Logo_Test_Statistic
			psta->core_txsc_amsdu_abort++;
			#endif

			_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);
			goto abort_core_tx;//drop this packet
		} else if(status == TXSC_AMSDU_ENQ_SUCCESS){
			RTW_TX_TRACE_CORE(padapter, pxframe, txsc_pkt, i, 1);
			#ifdef CONFIG_WFA_OFDMA_Logo_Test_Statistic
			psta->core_txsc_amsdu_need_enq++;
			#endif

			txsc_release_entry_use_cnt(padapter, &txsc_pkt);

			_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);
			return SUCCESS;//enq but not enough to deq
		}
		else {
			#ifdef CONFIG_WFA_OFDMA_Logo_Test_Statistic
			psta->core_txsc_amsdu_need_deq++;
			#endif
		}
	}
#endif

#ifdef CONFIG_VW_REFINE
	if (padapter->dvobj->tx_mode == 1) {
		if (0 != my_pskb->cb[_SKB_VW_FLAG]) {
			struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
			is_vw_pkt = 1;
			DBG_COUNTER(padapter->tx_logs.core_vw_test1);
			txsc_pkt.vw_cnt = 1;

			if ( (1 == pxmitpriv->txsc_amsdu_enable) &&
				(txsc_pkt.step != TXSC_AMSDU_APPLY)) {
				printk_ratelimited(KERN_WARNING "txsc err code:0x%x cb:0x%x\n",
					txsc_pkt.err, my_pskb->cb[_SKB_CB_FLAGS]);
				// my_dump_data(my_pskb->data, 32, "test");
			}
		}
	}
#endif

	#ifdef CONFIG_WFA_OFDMA_Logo_Test_Statistic
	if (psta)
		psta->core_txsc_apply_cnt_1++;
	#endif

	if (txsc_apply_sc_cached_entry(padapter, &txsc_pkt, is_vw_pkt) == _FAIL) {
		if (txsc_pkt.ptxreq && (txsc_pkt.ptxreq->pkt_cnt == 0)) {
#ifdef CONFIG_VW_REFINE
 			ret = _RTW_QUE_EMPTY;
#else
			ret = SUCCESS;
#endif
		}
		RTW_TX_TRACE_CORE(padapter,pxframe,txsc_pkt,i, txsc_pkt.skb_cnt);
		abort_core_tx_flag = 6;
		txsc_amsdu_process_check(padapter, &txsc_pkt);

		_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);
		goto abort_core_tx;
	} else {
		txsc_release_entry_use_cnt(padapter, &txsc_pkt);
	}

#ifdef CONFIG_VW_REFINE
	if ( is_vw_pkt ) {
	      DBG_COUNTER(padapter->tx_logs.core_vw_amsdu_dir);
	}
#endif

direct_call_phl:
	/* for slow path debug */
	print_txreq_pklist(pxframe, NULL, my_pskb->data, __func__);

	sts = core_tx_call_phl(padapter, pxframe, (u8 *)&txsc_pkt);
	if (sts == FAIL) {
		RTW_TX_TRACE_CORE(padapter, pxframe, txsc_pkt, i, txsc_pkt.skb_cnt);
		abort_core_tx_flag = 8;

		if (txsc_pkt.step == TXSC_APPLY || txsc_pkt.step == TXSC_AMSDU_APPLY)
			_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);
		goto abort_core_tx;
	}
#else
	if (core_tx_call_phl(padapter, pxframe, NULL) == FAIL) {
		RTW_TX_TRACE_XFRAME(padapter, pxframe);
		abort_core_tx_flag = 7;

		if (txsc_pkt.step == TXSC_APPLY || txsc_pkt.step == TXSC_AMSDU_APPLY)
			_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);
		goto abort_core_tx;
	}
#endif

	if (txsc_pkt.step == TXSC_APPLY || txsc_pkt.step == TXSC_AMSDU_APPLY)
		_txsc_one_spinunlock_bh(&pxmitpriv->txsc_lock, NULL);

	return SUCCESS;

abort_core_tx:

#ifdef CONFIG_CORE_TXSC
	txsc_release_entry_use_cnt(padapter, &txsc_pkt);
	pxmitpriv->core_tx_abort[abort_core_tx_flag]++;
#endif
	if (ret == FAIL) {
		DBG_COUNTER(padapter->tx_logs.core_tx_err_drop);
		padapter->xmitpriv.tx_drop++;
	}

	if (pxframe == NULL){
#ifdef CONFIG_CORE_TXSC
		if(txsc_pkt.ptxreq){
			txsc_pkt.ptxreq->mdata.macid = txsc_pkt.psta->phl_sta->macid;
			txsc_free_txreq(padapter, txsc_pkt.ptxreq);
		}
		else
#endif
		{
			#ifdef CONFIG_ETHER_PKT_AGG
			if (txsc_pkt.isAggPkt == _AGG_TYPE_PKTLIST) {
				struct sk_buff **pskb_next;
				do {
					pskb_next = &((*pskb)->next);
					rtw_os_pkt_complete(padapter, *pskb);
					pskb = pskb_next;
				} while(pskb);
			} else
			#endif /* CONFIG_ETHER_PKT_AGG */
			{
				#ifdef CONFIG_TXSC_AMSDU
				if (!txsc_pkt.amsdu
					#ifdef CONFIG_ETHER_PKT_AGG
					|| txsc_pkt.isAggPkt
					#endif
				)
				#endif
					rtw_os_pkt_complete(padapter, *pskb);
			}
		}
	} else {
		if (pxframe->pkt == NULL)
			rtw_os_pkt_complete(padapter, *pskb);

		core_tx_free_xmitframe(padapter, pxframe);
	}

#ifdef CONFIG_CORE_TXSC
	pxmitpriv->core_tx_drop++;
#endif
	return FAIL;
}

#ifdef CONFIG_VW_REFINE
u32 rtw_core_tx_dev_map(void *drv_priv, struct rtw_xmit_req *txreq)
{
	_adapter  *padapter;
	PPCI_DATA pci_data = NULL;
	struct pci_dev *pdev = NULL;
	struct rtw_pkt_buf_list *pkt_list = NULL;
#ifdef RTW_CORE_TX_MSDU_TRANSFER_IN_PHL
	struct sk_buff *skb = NULL;
#endif
	struct sta_info *psta = NULL;
	struct txsc_entry *txsc = NULL;
	struct xmit_txreq_buf *ptxreq_buf = NULL;
	u8 i, payload_offset = ETH_HLEN;

	#ifdef CONFIG_CORE_TXSC
	if (   txreq->treq_type == RTW_PHL_TREQ_TYPE_CORE_TXSC
		|| txreq->treq_type == (RTW_PHL_TREQ_TYPE_CORE_TXSC|RTW_PHL_TREQ_TYPE_PHL_UPDATE_TXSC)
	    #ifdef CONFIG_RTW_ENABLE_HW_TXSC
	    || txreq->treq_type == RTW_PHL_TREQ_TYPE_HW_TXSC
	    #endif /* CONFIG_RTW_ENABLE_HW_TXSC */
	   ) {

		ptxreq_buf = (struct xmit_txreq_buf *)txreq->os_priv;
		psta = ptxreq_buf->psta;
		txsc = &psta->txsc_entry_cache[txreq->shortcut_id];
		padapter = ptxreq_buf->adapter;

		pci_data = dvobj_to_pci(padapter->dvobj);
		pdev = pci_data->ppcidev;

#ifdef RTW_CORE_TX_MSDU_TRANSFER_IN_PHL
		if (txreq->is_msdu && padapter->dvobj->tx_mode == 0) {
			pkt_list = (struct rtw_pkt_buf_list *) txreq->pkt_list;
			if (ptxreq_buf->pkt_cnt > 1) {
				txreq->total_len = pkt_list->length;
				for (i = 0; i < ptxreq_buf->pkt_cnt; i++) {
					skb = (struct sk_buff *)ptxreq_buf->pkt[i];
					ieee8023_header_to_rfc1042_shortcut(padapter, skb, txsc, psta,
														(((i + 1) == ptxreq_buf->pkt_cnt) ? false : true));
					ptxreq_buf->pkt[i] = (u8 *)skb;

					/* Next pkt list */
					pkt_list++;
					pkt_list->vir_addr = skb->data;
					pkt_list->length = skb->len;
					txreq->total_len += pkt_list->length;
				}
			}
		}
#endif
		pkt_list = (struct rtw_pkt_buf_list *) txreq->pkt_list;

		for (i = 0; i < txreq->pkt_cnt; i++ ) {
			#ifdef USE_ONE_WLHDR/* _VW_ */
			if (i != 0) // pkt_list[0] do this in core apply_txsc
			#endif
			{
		    	txsc_fill_txreq_phyaddr(padapter, pkt_list);
			}

			pkt_list++;
		}

		print_txreq_pklist(NULL, txreq, (u8 *)&txsc->txsc_ethdr, __func__);
	}
	#endif /* CONFIG_CORE_TXSC */

	return RTW_PHL_STATUS_SUCCESS;
}
#endif

static void upd_sta_recycle_sts(struct sta_info *psta, struct rtw_xmit_req *txreq)
{
	if ((psta != NULL) && (psta->state & WIFI_ASOC_STATE)) {
		switch (txreq->mdata.no_ack) {
		case TX_STATUS_TX_DONE:
			psta->fast_txnok_chk = 0;
			psta->sta_stats.last_rx_time = rtw_get_current_time();
			break;
		case TX_STATUS_TX_FAIL_REACH_RTY_LMT:
			psta->fast_txnok_chk++;
			break;
		default:
			break;
		}
	}

	return;
}

void upd_ap_recycle_sts(_adapter *padapter, u8 tx_status, u8 type, u8 pkt_category)
{
	if (padapter != NULL) {
		switch (tx_status) {
		case TX_STATUS_TX_DONE:
			if (type == RTW_PHL_PKT_TYPE_DATA)
				padapter->tx_logs.core_tx_recycle_data_frame_ok++;
#ifdef CONFIG_DBG_HNDSK_MGMT
			if (pkt_category != CATEGORY_END)
				padapter->tx_logs.core_hndsk_tx_ok_cnt[pkt_category]++;
#endif
			break;
		case TX_STATUS_TX_FAIL_REACH_RTY_LMT:
		case TX_STATUS_TX_FAIL_LIFETIME_DROP:
		case TX_STATUS_TX_FAIL_MACID_DROP:
		case TX_STATUS_TX_FAIL_SW_DROP:
		case TX_STATUS_TX_FAIL_FORCE_DROP_BY_STUCK:
		default:
			if (type == RTW_PHL_PKT_TYPE_DATA)
				padapter->tx_logs.core_tx_recycle_data_frame_fail++;
#ifdef CONFIG_DBG_HNDSK_MGMT
			if (pkt_category != CATEGORY_END)
				padapter->tx_logs.core_hndsk_tx_fail_cnt[pkt_category]++;
#endif
			RTW_INFO("[%s] Tx fail, reason:%d\n", __func__, tx_status);
			break;
		}
	}

	return;
}

enum rtw_phl_status rtw_core_tx_recycle(void *drv_priv, struct rtw_xmit_req *txreq)
{
	_adapter *padapter = NULL;
	struct xmit_frame *pxframe = NULL;
	struct sta_info *psta = NULL;
#ifdef CONFIG_CORE_TXSC
	struct xmit_txreq_buf *ptxreq_buf = NULL;
#endif

	if (txreq->os_priv == NULL) {
		RTW_ERR("NULL txreq!\n");
		return RTW_PHL_STATUS_FAILURE;
	}

#ifdef CONFIG_CORE_TXSC
	if (txreq->treq_type == RTW_PHL_TREQ_TYPE_CORE_TXSC
		#ifdef CONFIG_RTW_ENABLE_HW_TXSC
		|| txreq->treq_type == RTW_PHL_TREQ_TYPE_HW_TXSC
		#endif /* CONFIG_RTW_ENABLE_HW_TXSC */
	   ) {
		#ifdef CONFIG_VW_REFINE
		int macid = txreq->my_macid;
		#endif /* CONFIG_VW_REFINE */
		ptxreq_buf = (struct xmit_txreq_buf *)txreq->os_priv;
		padapter = ptxreq_buf->adapter;
		psta = ptxreq_buf->psta;

		#ifdef CONFIG_VW_REFINE
		padapter->skb_vw_rec_cnt[macid] += txreq->vw_cnt;
		#endif
		#ifdef RTW_PHL_DBG_CMD
		core_add_record(padapter, padapter->record_enable, REC_TX_PHL_RCC, txreq);
		#endif
		#ifdef CONFIG_LMT_TXREQ
		rtw_core_upd_lmt_txreq_stats(padapter, txreq, NULL);
		#endif
		#ifdef CONFIG_ONE_TXQ
		rtw_core_upd_txreq_ts(padapter, txreq, NULL);
		#endif
		upd_ap_recycle_sts(padapter, txreq->mdata.no_ack, txreq->mdata.type, CATEGORY_END);
		txsc_free_txreq(padapter, txreq);
		upd_sta_recycle_sts(psta, txreq);
		return RTW_PHL_STATUS_SUCCESS;
	}
#endif /* CONFIG_CORE_TXSC */

	pxframe = (struct xmit_frame *)txreq->os_priv;
	if (pxframe == NULL) {
		RTW_ERR("%s: NULL xmitframe !!\n", __func__);
		rtw_warn_on(1);
		return RTW_PHL_STATUS_FAILURE;
	}

	padapter = pxframe->padapter;
	psta = XF_STA;
	upd_sta_recycle_sts(psta, txreq);
#ifdef CONFIG_DBG_HNDSK_MGMT
	if (pxframe->attrib.ether_type == 0x888e || pxframe->attrib.dhcp_pkt) {
		upd_ap_recycle_sts(padapter, txreq->mdata.no_ack, txreq->mdata.type, pxframe->attrib.hndsk_type);
	} else
#endif
		upd_ap_recycle_sts(padapter, txreq->mdata.no_ack, txreq->mdata.type, CATEGORY_END);

	/* Use TX status feedback call back instead of checking txsts here */
	#if 0
	if (XF_TYPE == RTW_TX_DRV_MGMT) {
		u16 subtype = 0xFFFF;
		u8 *pframe = NULL;
		struct sta_info *psta = NULL;

		pframe = (u8 *)(pxframe->buf_addr) + TXDESC_OFFSET;
		subtype = get_frame_sub_type(pframe);
		psta = XF_STA;
		if (   (   subtype == WIFI_DATA_NULL
			|| subtype == WIFI_QOS_DATA_NULL)
		    && psta != NULL
		    && txreq->mdata.no_ack == 0) {
			if (psta->state & WIFI_STA_ALIVE_CHK_STATE) {
				psta->state ^= WIFI_STA_ALIVE_CHK_STATE;
				psta->keep_alive_trycnt = 0;
				psta->sta_stats.last_rx_time = rtw_get_current_time(); //update for keep alive inactive_time
				RTW_INFO("[%s] keep alive check, sta_mac : %02x:%02x:%02x:%02x:%02x:%02x\n"
					, __func__, psta->phl_sta->mac_addr[0], psta->phl_sta->mac_addr[1],
								psta->phl_sta->mac_addr[2], psta->phl_sta->mac_addr[3],
								psta->phl_sta->mac_addr[4], psta->phl_sta->mac_addr[5]);
			}
		}
	}
	#endif

#ifdef RTW_PHL_DBG_CMD
//	core_add_record(padapter, padapter->record_enable, REC_TX_PHL_RCC, txreq);
	if(padapter->self_sta){
		core_add_record(padapter, padapter->record_enable, REC_TX_PHL_RCC, txreq);
	} else {
		RTW_INFO(FUNC_ADPT_FMT"adapter->self_sta is NULL\n", FUNC_ADPT_ARG(padapter));
	}

#endif

#ifdef CONFIG_PCI_HCI
	core_recycle_txreq_phyaddr(padapter, txreq);
#endif
#ifdef CONFIG_LMT_TXREQ
	rtw_core_upd_lmt_txreq_stats(padapter, txreq, pxframe);
#endif
#ifdef CONFIG_ONE_TXQ
	rtw_core_upd_txreq_ts(padapter, txreq, pxframe);
#endif
	core_tx_free_xmitframe(padapter, pxframe);

	return RTW_PHL_STATUS_SUCCESS;
}
#endif

#define RTW_HIQ_FILTER_ALLOW_ALL 0
#define RTW_HIQ_FILTER_ALLOW_SPECIAL 1
#define RTW_HIQ_FILTER_DENY_ALL 2

inline bool xmitframe_hiq_filter(struct xmit_frame *xmitframe)
{
	bool allow = _FALSE;
	_adapter *adapter = xmitframe->padapter;
	struct registry_priv *registry = &adapter->registrypriv;

	if (adapter->registrypriv.wifi_spec == 1)
		allow = _TRUE;
	else if (registry->hiq_filter == RTW_HIQ_FILTER_ALLOW_SPECIAL) {

		struct pkt_attrib *attrib = &xmitframe->attrib;

		if (attrib->ether_type == 0x0806
		    || attrib->ether_type == 0x888e
#ifdef CONFIG_WAPI_SUPPORT
		    || attrib->ether_type == 0x88B4
#endif
		    || attrib->dhcp_pkt
		   ) {
			if (0)
				RTW_INFO(FUNC_ADPT_FMT" ether_type:0x%04x%s\n", FUNC_ADPT_ARG(xmitframe->padapter)
					, attrib->ether_type, attrib->dhcp_pkt ? " DHCP" : "");
			allow = _TRUE;
		}
	} else if (registry->hiq_filter == RTW_HIQ_FILTER_ALLOW_ALL)
		allow = _TRUE;
	else if (registry->hiq_filter == RTW_HIQ_FILTER_DENY_ALL)
		allow = _FALSE;
	else
		rtw_warn_on(1);

	return allow;
}

#if defined(CONFIG_AP_MODE) || defined(CONFIG_TDLS)

/* CONFIG_VW_REFINE */
void stop_sta_xmit(_adapter *padapter, struct sta_info *psta)
{
	struct sta_info *psta_bmc;
	struct sta_xmit_priv *pstaxmitpriv = &psta->sta_xmitpriv;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	bool update_tim = _FALSE;
	struct rtw_wifi_role_t *wrole = padapter->phl_role;

	_rtw_spinlock_bh(&pxmitpriv->lock);
#ifdef RTW_WKARD_MACID_PAUSE_BY_DRIVER
	if (wrole)
		rtw_phl_cmd_set_macid_pause(wrole, psta->phl_sta, true, PHL_CMD_DIRECTLY, 0);
#endif
	psta->state |= WIFI_SLEEP_STATE;
	psta->sta_stats.nr_sleep++;

#ifdef WIFI_LOGO_HT_4_2_47
    if (check_net_lmt(padapter) && wrole) {
		rtw_phl_cmd_set_macid_pause(wrole, psta->phl_sta, true, PHL_CMD_DIRECTLY, 0);
		rtw_phl_cmd_set_macid_pkt_drop(wrole, psta->phl_sta, 0, PHL_CMD_DIRECTLY, 0);
		rtw_phl_cmd_set_macid_pkt_drop(wrole, psta->phl_sta, 1, PHL_CMD_DIRECTLY, 0);
		rtw_phl_cmd_set_macid_pkt_drop(wrole, psta->phl_sta, 2, PHL_CMD_DIRECTLY, 0);
		rtw_phl_cmd_set_macid_pause(wrole, psta->phl_sta, false, PHL_CMD_DIRECTLY, 0);
    }
#endif

	if (pstaxmitpriv->tx_pending_bitmap) {
		_queue *sta_queue;
		sta_queue = &padapter->dvobj->tx_pending_sta_queue;

		_rtw_spinlock_bh(&sta_queue->lock);
		if (rtw_is_list_empty(&pstaxmitpriv->tx_pending) == _FALSE) {
			rtw_list_delete(&pstaxmitpriv->tx_pending);
			sta_queue->qlen--;
		}
		_rtw_spinunlock_bh(&sta_queue->lock);
	}

#ifdef CONFIG_TDLS
	if (psta->tdls_sta_state & TDLS_LINKED_STATE) {
		if (pstaxmitpriv->tx_pending_bitmap)
			rtw_tdls_cmd(padapter, psta->phl_sta->mac_addr, TDLS_ISSUE_PTI);
		_rtw_spinunlock_bh(&pxmitpriv->lock);
		return;
	}
#endif

	rtw_tim_map_set(padapter, pstapriv->sta_dz_bitmap, psta->phl_sta->aid);

	if ((psta->uapsd_bitmap == (BIT(TXQ_VO)|BIT(TXQ_VI)|BIT(TXQ_BE)|BIT(TXQ_BK))
			&& pstaxmitpriv->tx_pending_bitmap)
			|| (pstaxmitpriv->tx_pending_bitmap & ~ psta->uapsd_bitmap)) {
		rtw_tim_map_set(padapter, pstapriv->tim_bitmap, psta->phl_sta->aid);
#if defined(USE_HIQ)
		_update_beacon(padapter, _TIM_IE_, NULL, _TRUE, 0, "buffer UC");
#else
		update_tim = _TRUE;
#endif
	}

#if !defined(USE_HIQ)
	/* for BC/MC Frames */
	psta_bmc = rtw_get_bcmc_stainfo(padapter);
	if (psta_bmc) {
		rtw_tim_map_set(padapter, pstapriv->sta_dz_bitmap, 0);

		if (psta_bmc->sleep_q.qlen) {
			if (rtw_is_list_empty(&psta_bmc->bmc_list)) {
				rtw_list_insert_tail(&psta_bmc->bmc_list, &pxmitpriv->bmc_list);
//#if !defined(CONFIG_ONE_TXQ)
				if (padapter->dvobj->tx_mode != 2)
					rtw_tasklet_hi_schedule(&padapter->dvobj->ps_trigger_tasklet);
//#endif
			}
		}

#if 0
		/* update by hw */
		if (update_tim || (!rtw_tim_map_is_set(padapter, pstapriv->tim_bitmap, 0)
				&& psta_bmc->sleep_q.qlen)) {
			rtw_tim_map_set(padapter, pstapriv->tim_bitmap, 0);
			_update_beacon(padapter, _TIM_IE_, NULL, _TRUE, 0, "buffer BMC");
		} else
			chk_bmc_sleepq_cmd(padapter);
#endif
	} else
		rtw_warn_on(1);
#endif

	_rtw_spinunlock_bh(&pxmitpriv->lock);
}

void wakeup_sta_to_xmit(_adapter *padapter, struct sta_info *psta)
{
	u8 update_mask = 0;
	struct sta_info *psta_bmc;
	struct sta_xmit_priv *pstaxmitpriv = &psta->sta_xmitpriv;
	struct sta_priv *pstapriv = &padapter->stapriv;
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct rtw_wifi_role_t *wrole = padapter->phl_role;

	_rtw_spinlock_bh(&pxmitpriv->lock);

	if (psta->state & WIFI_SLEEP_STATE)
		psta->state ^= WIFI_SLEEP_STATE;
#ifdef RTW_WKARD_MACID_PAUSE_BY_DRIVER
	if (wrole)
		rtw_phl_cmd_set_macid_pause(wrole, psta->phl_sta, false, PHL_CMD_DIRECTLY, 0);
#endif
	if (pstaxmitpriv->tx_pending_bitmap) {
		struct dvobj_priv *dvobj = padapter->dvobj;
		_queue *sta_queue = &dvobj->tx_pending_sta_queue;

		_rtw_spinlock_bh(&sta_queue->lock);
		if (rtw_is_list_empty(&pstaxmitpriv->tx_pending) == _TRUE) {
			rtw_list_insert_tail(&pstaxmitpriv->tx_pending, &sta_queue->queue);
			sta_queue->qlen++;
//#if !defined(CONFIG_ONE_TXQ)
			if (dvobj->tx_mode != 2)
				rtw_tasklet_hi_schedule(&dvobj->ps_trigger_tasklet);
//#endif
		}
		_rtw_spinunlock_bh(&sta_queue->lock);
	}

#ifdef CONFIG_TDLS
	if (psta->tdls_sta_state & TDLS_LINKED_STATE) {
		_rtw_spinunlock_bh(&pxmitpriv->lock);
		return;
	}
#endif

	rtw_tim_map_clear(padapter, pstapriv->sta_dz_bitmap, psta->phl_sta->aid);

	if (rtw_tim_map_is_set(padapter, pstapriv->tim_bitmap, psta->phl_sta->aid)) {
		rtw_tim_map_clear(padapter, pstapriv->tim_bitmap, psta->phl_sta->aid);
		update_mask = BIT(0);
	}

	if (psta->state & WIFI_STA_ALIVE_CHK_STATE) {
		RTW_INFO("%s alive check\n", __func__);
		psta->expire_to = pstapriv->expire_to;
		psta->state ^= WIFI_STA_ALIVE_CHK_STATE;
	}

#if !defined(USE_HIQ)
	/* for BC/MC Frames */
	psta_bmc = rtw_get_bcmc_stainfo(padapter);
	if (psta_bmc && !rtw_tim_map_anyone_be_set_exclude_aid0(padapter, pstapriv->sta_dz_bitmap)) { /* no any sta in ps mode */
		rtw_tim_map_clear(padapter, pstapriv->sta_dz_bitmap, 0);

		if (rtw_tim_map_is_set(padapter, pstapriv->tim_bitmap, 0)) {
			rtw_tim_map_clear(padapter, pstapriv->tim_bitmap, 0);
			update_mask |= BIT(1);
		}
	}
#endif

	if (update_mask) {
#if !defined(USE_HIQ)
		if ((update_mask & (BIT(0) | BIT(1))) == (BIT(0) | BIT(1)))
			_update_beacon(padapter, _TIM_IE_, NULL, _TRUE, 0, "clear UC&BMC");
		else if ((update_mask & BIT(1)) == BIT(1))
			_update_beacon(padapter, _TIM_IE_, NULL, _TRUE, 0, "clear BMC");
		else
#endif
			_update_beacon(padapter, _TIM_IE_, NULL, _TRUE, 0, "clear UC");
	}

	_rtw_spinunlock_bh(&pxmitpriv->lock);
}
#endif /* defined(CONFIG_AP_MODE) || defined(CONFIG_TDLS) */

#if 0 /*#ifdef CONFIG_XMIT_THREAD_MODE*/
void enqueue_pending_xmitbuf(
	struct xmit_priv *pxmitpriv,
	struct xmit_buf *pxmitbuf)
{
	_queue *pqueue;
	_adapter *pri_adapter = pxmitpriv->adapter;

	pqueue = &pxmitpriv->pending_xmitbuf_queue;

	_rtw_spinlock_bh(&pqueue->lock);
	rtw_list_delete(&pxmitbuf->list);
	rtw_list_insert_tail(&pxmitbuf->list, get_list_head(pqueue));
	_rtw_spinunlock_bh(&pqueue->lock);

#if defined(CONFIG_SDIO_HCI) && defined(CONFIG_CONCURRENT_MODE)
	pri_adapter = GET_PRIMARY_ADAPTER(pri_adapter);
#endif /*SDIO_HCI + CONCURRENT*/
	_rtw_up_sema(&(pri_adapter->xmitpriv.xmit_sema));
}

void enqueue_pending_xmitbuf_to_head(
	struct xmit_priv *pxmitpriv,
	struct xmit_buf *pxmitbuf)
{
	_queue *pqueue = &pxmitpriv->pending_xmitbuf_queue;

	_rtw_spinlock_bh(&pqueue->lock);
	rtw_list_delete(&pxmitbuf->list);
	rtw_list_insert_head(&pxmitbuf->list, get_list_head(pqueue));
	_rtw_spinunlock_bh(&pqueue->lock);
}

struct xmit_buf *dequeue_pending_xmitbuf(
	struct xmit_priv *pxmitpriv)
{
	struct xmit_buf *pxmitbuf;
	_queue *pqueue;


	pxmitbuf = NULL;
	pqueue = &pxmitpriv->pending_xmitbuf_queue;

	_rtw_spinlock_bh(&pqueue->lock);

	if (_rtw_queue_empty(pqueue) == _FALSE) {
		_list *plist, *phead;

		phead = get_list_head(pqueue);
		plist = get_next(phead);
		pxmitbuf = LIST_CONTAINOR(plist, struct xmit_buf, list);
		rtw_list_delete(&pxmitbuf->list);
	}

	_rtw_spinunlock_bh(&pqueue->lock);

	return pxmitbuf;
}

static struct xmit_buf *dequeue_pending_xmitbuf_ext(
	struct xmit_priv *pxmitpriv)
{
	struct xmit_buf *pxmitbuf;
	_queue *pqueue;

	pxmitbuf = NULL;
	pqueue = &pxmitpriv->pending_xmitbuf_queue;

	_rtw_spinlock_bh(&pqueue->lock);

	if (_rtw_queue_empty(pqueue) == _FALSE) {
		_list *plist, *phead;

		phead = get_list_head(pqueue);
		plist = phead;
		do {
			plist = get_next(plist);
			if (plist == phead)
				break;

			pxmitbuf = LIST_CONTAINOR(plist, struct xmit_buf, list);

			if (pxmitbuf->buf_tag == XMITBUF_MGNT) {
				rtw_list_delete(&pxmitbuf->list);
				break;
			}
			pxmitbuf = NULL;
		} while (1);
	}

	_rtw_spinunlock_bh(&pqueue->lock);

	return pxmitbuf;
}

struct xmit_buf *select_and_dequeue_pending_xmitbuf(_adapter *padapter)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	struct xmit_buf *pxmitbuf = NULL;

	if (_TRUE == rtw_is_xmit_blocked(padapter))
		return pxmitbuf;

	pxmitbuf = dequeue_pending_xmitbuf_ext(pxmitpriv);
	if (pxmitbuf == NULL && rtw_xmit_ac_blocked(padapter) != _TRUE)
		pxmitbuf = dequeue_pending_xmitbuf(pxmitpriv);

	return pxmitbuf;
}

sint check_pending_xmitbuf(
	struct xmit_priv *pxmitpriv)
{
	_queue *pqueue;
	sint	ret = _FALSE;

	pqueue = &pxmitpriv->pending_xmitbuf_queue;

	_rtw_spinlock_bh(&pqueue->lock);

	if (_rtw_queue_empty(pqueue) == _FALSE)
		ret = _TRUE;

	_rtw_spinunlock_bh(&pqueue->lock);

	return ret;
}

thread_return rtw_xmit_thread(thread_context context)
{
	s32 err;
	_adapter *adapter;
#ifdef RTW_XMIT_THREAD_HIGH_PRIORITY
#ifdef PLATFORM_LINUX
	struct sched_param param = { .sched_priority = 1 };

	sched_setscheduler(current, SCHED_FIFO, &param);
#endif /* PLATFORM_LINUX */
#endif /* RTW_XMIT_THREAD_HIGH_PRIORITY */

	err = _SUCCESS;
	adapter = (_adapter *)context;

	rtw_thread_enter("RTW_XMIT_THREAD");

	do {
		err = rtw_intf_xmit_buf_handler(adapter);
		flush_signals_thread();
	} while (_SUCCESS == err);

	RTW_INFO(FUNC_ADPT_FMT " Exit\n", FUNC_ADPT_ARG(adapter));

	rtw_thread_wait_stop();

	return 0;
}
#endif

#ifdef DBG_XMIT_BLOCK
void dump_xmit_block(void *sel, _adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	RTW_PRINT_SEL(sel, "[XMIT-BLOCK] xmit_block :0x%02x\n", dvobj->xmit_block);
	if (dvobj->xmit_block & XMIT_BLOCK_REDLMEM)
		RTW_PRINT_SEL(sel, "Reason:%s\n", "XMIT_BLOCK_REDLMEM");
	if (dvobj->xmit_block & XMIT_BLOCK_SUSPEND)
		RTW_PRINT_SEL(sel, "Reason:%s\n", "XMIT_BLOCK_SUSPEND");
	if (dvobj->xmit_block == XMIT_BLOCK_NONE)
		RTW_PRINT_SEL(sel, "Reason:%s\n", "XMIT_BLOCK_NONE");
}
void dump_xmit_block_info(void *sel, const char *fun_name, _adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	RTW_INFO("\n"ADPT_FMT" call %s\n", ADPT_ARG(padapter), fun_name);
	dump_xmit_block(sel, padapter);
}
#define DBG_XMIT_BLOCK_DUMP(adapter)	dump_xmit_block_info(RTW_DBGDUMP, __func__, adapter)
#endif

void rtw_set_xmit_block(_adapter *padapter, enum XMIT_BLOCK_REASON reason)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	_rtw_spinlock_bh(&dvobj->xmit_block_lock);
	dvobj->xmit_block |= reason;
	_rtw_spinunlock_bh(&dvobj->xmit_block_lock);

	#ifdef DBG_XMIT_BLOCK
	DBG_XMIT_BLOCK_DUMP(padapter);
	#endif
}

void rtw_clr_xmit_block(_adapter *padapter, enum XMIT_BLOCK_REASON reason)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	_rtw_spinlock_bh(&dvobj->xmit_block_lock);
	dvobj->xmit_block &= ~reason;
	_rtw_spinunlock_bh(&dvobj->xmit_block_lock);

	#ifdef DBG_XMIT_BLOCK
	DBG_XMIT_BLOCK_DUMP(padapter);
	#endif
}
bool rtw_is_xmit_blocked(_adapter *padapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);

	#ifdef DBG_XMIT_BLOCK
	DBG_XMIT_BLOCK_DUMP(padapter);
	#endif
	return ((dvobj->xmit_block) ? _TRUE : _FALSE);
}

bool rtw_xmit_ac_blocked(_adapter *adapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(adapter);
	struct rf_ctl_t *rfctl = adapter_to_rfctl(adapter);
	_adapter *iface;
	struct mlme_ext_priv *mlmeext;
	bool blocked = _FALSE;
	int i;
#ifdef DBG_CONFIG_ERROR_DETECT
#ifdef DBG_CONFIG_ERROR_RESET
#ifdef CONFIG_USB_HCI
	if (rtw_hal_sreset_inprogress(adapter) == _TRUE) {
		blocked = _TRUE;
		goto exit;
	}
#endif/* #ifdef CONFIG_USB_HCI */
#endif/* #ifdef DBG_CONFIG_ERROR_RESET */
#endif/* #ifdef DBG_CONFIG_ERROR_DETECT */

	if (rfctl->offch_state != OFFCHS_NONE
		#if CONFIG_DFS
		|| IS_RADAR_DETECTED(rfctl)
		#endif
		|| rfctl->csa_ch
	) {
		blocked = _TRUE;
		goto exit;
	}

	for (i = 0; i < dvobj->iface_nums; i++) {
		iface = dvobj->padapters[i];
		mlmeext = &iface->mlmeextpriv;

		/* check scan state */
		if (mlmeext_scan_state(mlmeext) != SCAN_DISABLE
			&& mlmeext_scan_state(mlmeext) != SCAN_BACK_OP
		) {
			blocked = _TRUE;
			goto exit;
		}

		if (mlmeext_scan_state(mlmeext) == SCAN_BACK_OP
			&& !mlmeext_chk_scan_backop_flags(mlmeext, SS_BACKOP_TX_RESUME)
		) {
			blocked = _TRUE;
			goto exit;
		}
	}

#ifdef CONFIG_MCC_MODE
	if (MCC_EN(adapter)) {
		if (rtw_hal_check_mcc_status(adapter, MCC_STATUS_DOING_MCC)) {
			if (MCC_STOP(adapter)) {
				blocked = _TRUE;
				goto exit;
			}
		}
	}
#endif /*  CONFIG_MCC_MODE */

exit:
	return blocked;
}

#ifdef CONFIG_TX_AMSDU
void rtw_amsdu_vo_timeout_handler(void *FunctionContext)
{
	_adapter *adapter = (_adapter *)FunctionContext;

	adapter->xmitpriv.amsdu_vo_timeout = RTW_AMSDU_TIMER_TIMEOUT;

	rtw_tasklet_hi_schedule(&adapter->xmitpriv.xmit_tasklet);
}

void rtw_amsdu_vi_timeout_handler(void *FunctionContext)
{
	_adapter *adapter = (_adapter *)FunctionContext;

	adapter->xmitpriv.amsdu_vi_timeout = RTW_AMSDU_TIMER_TIMEOUT;

	rtw_tasklet_hi_schedule(&adapter->xmitpriv.xmit_tasklet);
}

void rtw_amsdu_be_timeout_handler(void *FunctionContext)
{
	_adapter *adapter = (_adapter *)FunctionContext;

	adapter->xmitpriv.amsdu_be_timeout = RTW_AMSDU_TIMER_TIMEOUT;

	if (printk_ratelimit())
		RTW_DBG("%s Timeout!\n",__FUNCTION__);

	rtw_tasklet_hi_schedule(&adapter->xmitpriv.xmit_tasklet);
}

void rtw_amsdu_bk_timeout_handler(void *FunctionContext)
{
	_adapter *adapter = (_adapter *)FunctionContext;

	adapter->xmitpriv.amsdu_bk_timeout = RTW_AMSDU_TIMER_TIMEOUT;

	rtw_tasklet_hi_schedule(&adapter->xmitpriv.xmit_tasklet);
}

u8 rtw_amsdu_get_timer_status(_adapter *padapter, u8 priority)
{
	struct xmit_priv        *pxmitpriv = &padapter->xmitpriv;

	u8 status =  RTW_AMSDU_TIMER_UNSET;

	switch(priority)
	{
		case 1:
		case 2:
			status = pxmitpriv->amsdu_bk_timeout;
			break;
		case 4:
		case 5:
			status = pxmitpriv->amsdu_vi_timeout;
			break;
		case 6:
		case 7:
			status = pxmitpriv->amsdu_vo_timeout;
			break;
		case 0:
		case 3:
		default:
			status = pxmitpriv->amsdu_be_timeout;
			break;
	}
	return status;
}

void rtw_amsdu_set_timer_status(_adapter *padapter, u8 priority, u8 status)
{
	struct xmit_priv        *pxmitpriv = &padapter->xmitpriv;

	switch(priority)
	{
		case 1:
		case 2:
			pxmitpriv->amsdu_bk_timeout = status;
			break;
		case 4:
		case 5:
			pxmitpriv->amsdu_vi_timeout = status;
			break;
		case 6:
		case 7:
			pxmitpriv->amsdu_vo_timeout = status;
			break;
		case 0:
		case 3:
		default:
			pxmitpriv->amsdu_be_timeout = status;
			break;
	}
}

void rtw_amsdu_set_timer(_adapter *padapter, u8 priority)
{
	struct xmit_priv        *pxmitpriv = &padapter->xmitpriv;

	_timer* amsdu_timer = NULL;

	switch(priority)
	{
		case 1:
		case 2:
			amsdu_timer = &pxmitpriv->amsdu_bk_timer;
			break;
		case 4:
		case 5:
			amsdu_timer = &pxmitpriv->amsdu_vi_timer;
			break;
		case 6:
		case 7:
			amsdu_timer = &pxmitpriv->amsdu_vo_timer;
			break;
		case 0:
		case 3:
		default:
			amsdu_timer = &pxmitpriv->amsdu_be_timer;
			break;
	}
	_set_timer(amsdu_timer, 1);
}

void rtw_amsdu_cancel_timer(_adapter *padapter, u8 priority)
{
	struct xmit_priv        *pxmitpriv = &padapter->xmitpriv;
	_timer* amsdu_timer = NULL;

	switch(priority)
	{
		case 1:
		case 2:
			amsdu_timer = &pxmitpriv->amsdu_bk_timer;
			break;
		case 4:
		case 5:
			amsdu_timer = &pxmitpriv->amsdu_vi_timer;
			break;
		case 6:
		case 7:
			amsdu_timer = &pxmitpriv->amsdu_vo_timer;
			break;
		case 0:
		case 3:
		default:
			amsdu_timer = &pxmitpriv->amsdu_be_timer;
			break;
	}
	_cancel_timer_ex(amsdu_timer);
}
#endif /* CONFIG_TX_AMSDU */

#if 0 /*def DBG_TXBD_DESC_DUMP*/
static struct rtw_tx_desc_backup tx_backup[HW_QUEUE_ENTRY][TX_BAK_FRMAE_CNT];
static u8 backup_idx[HW_QUEUE_ENTRY];

void rtw_tx_desc_backup(_adapter *padapter, struct xmit_frame *pxmitframe, u8 desc_size, u8 hwq)
{
	u32 tmp32;
	u8 *pxmit_buf;

	if (rtw_hw_get_init_completed(adapter_to_dvobj(padapter)) == _FALSE)
		return;

	pxmit_buf = pxmitframe->pxmitbuf->pbuf;

	_rtw_memcpy(tx_backup[hwq][backup_idx[hwq]].tx_bak_desc, pxmit_buf, desc_size);
	_rtw_memcpy(tx_backup[hwq][backup_idx[hwq]].tx_bak_data_hdr, pxmit_buf+desc_size, TX_BAK_DATA_LEN);

	#if 0 /*GEORGIA_TODO_REDEFINE_IO*/
	tmp32 = rtw_read32(padapter, get_txbd_rw_reg(hwq));
	#else
	tmp32 = rtw_hal_get_txbd_rwreg(padapter);
	#endif

	tx_backup[hwq][backup_idx[hwq]].tx_bak_rp = (tmp32>>16)&0xfff;
	tx_backup[hwq][backup_idx[hwq]].tx_bak_wp = tmp32&0xfff;

	tx_backup[hwq][backup_idx[hwq]].tx_desc_size = desc_size;

	backup_idx[hwq] = (backup_idx[hwq] + 1) % TX_BAK_FRMAE_CNT;
}

void rtw_tx_desc_backup_reset(void)
{
	int i, j;

	for (i = 0; i < HW_QUEUE_ENTRY; i++) {
		for (j = 0; j < TX_BAK_FRMAE_CNT; j++)
			_rtw_memset(&tx_backup[i][j], 0, sizeof(struct rtw_tx_desc_backup));

		backup_idx[i] = 0;
	}
}

u8 rtw_get_tx_desc_backup(_adapter *padapter, u8 hwq, struct rtw_tx_desc_backup **pbak)
{
	*pbak = &tx_backup[hwq][0];

	return backup_idx[hwq];
}
#endif

#ifdef CONFIG_PCI_TX_POLLING
void rtw_tx_poll_init(_adapter *padapter)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	_timer* timer = &pxmitpriv->tx_poll_timer;

	if (!is_primary_adapter(padapter))
		return;

	if (timer->function != NULL) {
		RTW_INFO("tx polling timer has been init.\n");
		return;
	}

	rtw_init_timer(timer, rtw_tx_poll_timeout_handler, padapter);
	rtw_tx_poll_timer_set(padapter, 1);
	RTW_INFO("Tx poll timer init!\n");
}

void rtw_tx_poll_timeout_handler(void *FunctionContext)
{
	_adapter *adapter = (_adapter *)FunctionContext;

	rtw_tx_poll_timer_set(adapter, 1);

	if (adapter->dvobj->hal_func.tx_poll_handler)
		adapter->dvobj->hal_func.tx_poll_handler(adapter);
	else
		RTW_WARN("hal ops: tx_poll_handler is NULL\n");
}

void rtw_tx_poll_timer_set(_adapter *padapter, u32 delay)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	_timer* timer = NULL;

	timer = &pxmitpriv->tx_poll_timer;
	_set_timer(timer, delay);
}

void rtw_tx_poll_timer_cancel(_adapter *padapter)
{
	struct xmit_priv *pxmitpriv = &padapter->xmitpriv;
	_timer* timer = NULL;

	if (!is_primary_adapter(padapter))
		return;

	timer = &pxmitpriv->tx_poll_timer;
	_cancel_timer_ex(timer);
	timer->function = NULL;
	RTW_INFO("Tx poll timer cancel !\n");
}
#endif /* CONFIG_PCI_TX_POLLING */

struct submit_ctx *rtw_sctx_alloc(_adapter *adapter)
{
	struct submit_ctx *sctx = rtw_zmalloc(sizeof(struct submit_ctx));
	if (sctx) {
		ATOMIC_SET(&sctx->ref_count, 1);
		// RTW_PRINT("Allocated sctx %px\n.", sctx);
		#ifdef CONFIG_RTW_DEBUG_SCTX_ALLOC
		adapter->tx_logs.sctx_alloc++;
		sctx->free_cnt = &adapter->tx_logs.sctx_free;
		#endif /* CONFIG_RTW_DEBUG_SCTX_ALLOC */
	}
	return sctx;
}

void rtw_sctx_free(struct submit_ctx *sctx)
{
	int ref_cnt;

	ref_cnt = ATOMIC_DEC_RETURN(&sctx->ref_count);
	if (ref_cnt)
		return;
	#ifdef CONFIG_RTW_DEBUG_SCTX_ALLOC
	// RTW_PRINT("Freed sctx %px\n.", sctx);
	++(*sctx->free_cnt);
	#endif

	rtw_mfree(sctx, sizeof(*sctx));
}

void rtw_sctx_init(struct submit_ctx *sctx, int timeout_ms)
{
	sctx->timeout_ms = timeout_ms;
	sctx->submit_time = rtw_get_current_time();
	_rtw_init_completion(&sctx->done);
	sctx->status = RTW_SCTX_SUBMITTED;
}

int rtw_sctx_wait(struct submit_ctx *sctx, const char *msg)
{
	int ret = _FAIL;
	unsigned long expire;
	int status = 0;

#if defined(PLATFORM_LINUX) || defined(PLATFORM_ECOS)
	expire = sctx->timeout_ms ? msecs_to_jiffies(sctx->timeout_ms) : MAX_SCHEDULE_TIMEOUT;
	if (!_rtw_wait_for_comp_timeout(&sctx->done, expire)) {
		/* timeout, do something?? */
		status = RTW_SCTX_DONE_TIMEOUT;
		RTW_WARN("%s timeout: %s\n", __func__, msg);
	} else
		status = sctx->status;
#endif

	if (status == RTW_SCTX_DONE_SUCCESS)
		ret = _SUCCESS;

	return ret;
}

bool rtw_sctx_chk_waring_status(int status)
{
	switch (status) {
	case RTW_SCTX_DONE_UNKNOWN:
	case RTW_SCTX_DONE_BUF_ALLOC:
	case RTW_SCTX_DONE_BUF_FREE:

	case RTW_SCTX_DONE_DRV_STOP:
	case RTW_SCTX_DONE_DEV_REMOVE:
		return _TRUE;
	default:
		return _FALSE;
	}
}

void rtw_sctx_done_err(struct submit_ctx **sctx, int status)
{
	if (*sctx) {
		if (rtw_sctx_chk_waring_status(status))
			RTW_INFO("%s status:%d\n", __func__, status);
		(*sctx)->status = status;
#if defined(PLATFORM_LINUX) || defined(PLATFORM_ECOS)
		complete(&((*sctx)->done));
#endif
		*sctx = NULL;
	}
}

void rtw_sctx_done(struct submit_ctx **sctx)
{
	rtw_sctx_done_err(sctx, RTW_SCTX_DONE_SUCCESS);
}

#ifdef CONFIG_XMIT_ACK
int rtw_ack_tx_wait(struct xmit_priv *pxmitpriv, u32 timeout_ms)
{
	struct submit_ctx *pack_tx_ops = &pxmitpriv->ack_tx_ops;

	pack_tx_ops->submit_time = rtw_get_current_time();
	pack_tx_ops->timeout_ms = timeout_ms;
	pack_tx_ops->status = RTW_SCTX_SUBMITTED;

	return rtw_sctx_wait(pack_tx_ops, __func__);
}

void rtw_ack_tx_done(struct xmit_priv *pxmitpriv, int status)
{
	struct submit_ctx *pack_tx_ops = &pxmitpriv->ack_tx_ops;

	if (pxmitpriv->ack_tx)
		rtw_sctx_done_err(&pack_tx_ops, status);
	else
		RTW_INFO("%s ack_tx not set\n", __func__);
}

#endif /* CONFIG_XMIT_ACK */

void rtw_init_dscp_table(_adapter *padapter)
{
	int dscp;
	int up = 0;

	/* refer to IEEE802.11-2016 Table R-3;
	 * DCSP 32(CS4) comply with IETF RFC4594
	 */
	for (dscp = 0; dscp < DSCP_TABLE_SIZE; dscp++) {
		up = 0;
		if ( dscp == 0 )
			up = 0;
		else if ( dscp >= 1 && dscp <= 9)
			up = 1;
		else if ( dscp >= 10 && dscp <= 16)
			up = 2;
		else if ( dscp >= 17 && dscp <= 23)
			up = 3;
		else if ( dscp >= 24 && dscp <= 31)
			up = 4;
		else if ( dscp >= 33 && dscp <= 40)
			up = 5;
		else if ((dscp >= 41 && dscp <= 47) || (dscp == 32))
			up = 6;
		else if ( dscp >= 48 && dscp <= 63)
			up = 7;
		padapter->dscp_mapping_table[dscp] = up;
	}
}
