#ifndef __RTW_IOCTL_DE_STRUCT_H__
#define __RTW_IOCTL_DE_STRUCT_H__
#define SIOCDE_CAC_CHANEL_MAXNUM   (32)
#define SIOCDE_CAC_METHOD_MAXNUM   (16)
#define SIOCDE_CAC_METHOD_OPCLASS_MAXNUM        (32)
#define SIOCDE_CAC_METHOD_OPCLASS_CHAN_MAXNUM   (32)
#define SIOCDE_WIFI6INFO_MCSNSS_MAXNUM          (16)
#define SIOCDE_STA_TID_MAXNUM      (32)
#define SIOCDE_BSSID_MAXLEN        (64)
#define SIOCDE_CAP_MAXLEN          (32)

enum SIOCDE_FLAGS{
	SIOCDE_GETPRIOINFO = 0x8BA0,
	SIOCDE_GETRADIOTIMEUSEINFO,
	SIOCDE_GETBSSINFO,
	SIOCDE_GETSTAWIFI6CAPABILITY,
	SIOCDE_GETRADIOCACINFO,
	SIOCDE_GETRADIOWIFI6APROLE,
	SIOCDE_GETRADIOWIFI6STAROLE,
	SIOCDE_SETDEVCACREQ,
	SIOCDE_GETDEVCACSTATUS,
	SIOCDE_GETSTAINFO,
	SIOCDE_GETSTATIDINFO,
	SIOCDE_GETASSOCDATA,
	SIOCDE_GETDISASSOCDATA,
	SIOCDE_GETFAILCONNDATA,
};

/* SIOCDE_GETPRIOINFO */
struct siocde_prio_info {
	char dscpmap[65];
	unsigned char max_prio_rules;
	unsigned char basic_prio;
	unsigned char enhanced_prio;
};

/* SIOCDE_SETDEVCACREQ */
struct siocde_cac_request {
};

/* SIOCDE_GETDEVCACSTATUS */
struct siocde_cac_info {
	unsigned char opclass;
	unsigned char channel;
	union {
		unsigned short minutes; /*available channel*/
		unsigned short seconds; /*non occupancy channel*/
		unsigned short countdown; /*active channel*/
	};
};

struct siocde_cac_result {
	unsigned char nr_avail;
	unsigned char nr_non_occupy;
	unsigned char nr_active;
	struct siocde_cac_info avail_channs[SIOCDE_CAC_CHANEL_MAXNUM];
	struct siocde_cac_info non_occupy_chans[SIOCDE_CAC_CHANEL_MAXNUM];
	struct siocde_cac_info active_chans[SIOCDE_CAC_CHANEL_MAXNUM];
};

/* SIOCDE_GETRADIOTIMEUSEINFO */
struct siocde_radio_timeuse {
	unsigned char transmit;
	unsigned char receive_self;
	unsigned char receive_other;
};

/* SIOCDE_GETRADIOCACINFO */
struct siocde_cacmeth_opclass {
	unsigned char operating_class;
	unsigned char nr_chan;
	unsigned char chan_list[SIOCDE_CAC_METHOD_OPCLASS_CHAN_MAXNUM];
};

struct siocde_cac_method {
	unsigned char method;
	unsigned char nr_opclass;
	unsigned int num_of_seconds;
	struct siocde_cacmeth_opclass opclasses[SIOCDE_CAC_METHOD_OPCLASS_MAXNUM];
};

struct siocde_cac_capability {
	struct siocde_cac_method methods[SIOCDE_CAC_METHOD_MAXNUM];
};

/* SIOCDE_GETBSSINFO */
struct siocde_bssinfo {
	unsigned int last_change;
	unsigned char multi_bssid;
	unsigned char transmitted_bssid;
};

/* SIOCDE_GETSTAINFO */
struct siocde_stainfo {
	unsigned int last_dl_rate;
	unsigned int last_ul_rate;
	unsigned int utilization_recv;
	unsigned int utilization_tran;
};

/* SIOCDE_GETSTAWIFI6CAPABILITY */
struct siocde_wifi6info {
	unsigned char he160;
    unsigned char he8080;
    unsigned char mcsnss[SIOCDE_WIFI6INFO_MCSNSS_MAXNUM];
    unsigned char SUBeamformer;
    unsigned char SUBeamformee;
    unsigned char MUBeamformer;
    unsigned char Beamformee80orLess;
    unsigned char BeamformeeAbove80;
    unsigned char ulmumimo;
    unsigned char ulofdma;
    unsigned char dlofdma;
    unsigned char maxdlmumimo;
    unsigned char maxulmumimo;
    unsigned char maxulofdma;
    unsigned char maxdlofdma;
    unsigned char rts;
    unsigned char murts;
    unsigned char Multibssid;
    unsigned char muedca;
    unsigned char TWTRequestor;
    unsigned char TWTResponder;
};

struct siocde_sta_wifi6info {
	struct siocde_wifi6info sta_6info;
};

/* SIOCDE_GETSTATIDINFO */
struct siocde_tidinfo {
	unsigned char tid;
	unsigned char size;
};

struct siocde_sta_tidinfo {
	struct siocde_tidinfo sta_tids[SIOCDE_STA_TID_MAXNUM];
};

/* SIOCDE_GETRADIOWIFI6APROLE */
struct siocde_wifi6_apcap {
	struct siocde_wifi6info aprole_6info;
};

/* SIOCDE_GETRADIOWIFI6STAROLE */
struct siocde_wifi6_stacap {
	struct siocde_wifi6info starole_6info;
};

/* SIOCDE_GETASSOCDATA */
struct siocde_assoc_data {
	unsigned int timestamp;
    unsigned char bssid [SIOCDE_BSSID_MAXLEN];
    unsigned char mac[6];
    unsigned short status_code;
    unsigned char ht_cap [SIOCDE_CAP_MAXLEN];
    unsigned char vht_cap [SIOCDE_CAP_MAXLEN];
    unsigned char he_cap [SIOCDE_CAP_MAXLEN];
    unsigned char client_cap [SIOCDE_CAP_MAXLEN];
    struct siocde_wifi6info wifi6_cap;
};

/* SIOCDE_GETDISASSOCDATA */
struct siocde_disassoc_data {
	unsigned int timestamp;
    unsigned char bssid[SIOCDE_BSSID_MAXLEN];
    unsigned char mac[6];
    unsigned short reason_code;
    unsigned int bytes_sent;
    unsigned int bytes_recv;
    unsigned int pkts_sent;
    unsigned int pkts_recv;
    unsigned int err_sent;
    unsigned int err_recv;
    unsigned int retrans_cnt;
};

/* SIOCDE_GETFAILCONNDATA */
struct siocde_failassoc_data {
	unsigned int timestamp;
    unsigned char mac[6];
    unsigned short reason_code;
    unsigned short status_code;
};
#endif