/******************************************************************************
 *
 * Copyright(c) 2007 - 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#ifndef __RTW_CMD_H_
#define __RTW_CMD_H_


#define C2H_MEM_SZ (16*1024)


#define MAX_CMDSZ	1024
#define MAX_RSPSZ	512
#define MAX_EVTSZ	1024

#define CMDBUFF_ALIGN_SZ 512

struct cmd_obj {
	_adapter *padapter;
	u16	cmdcode;
	u8	res;
	u8	*parmbuf;
	u32	cmdsz;
	u8	*rsp;
	u32	rspsz;
	struct submit_ctx *sctx;
	u8 no_io;
	u32 *msg_hdl;
	/* _sema 	cmd_sem; */
	_list	list;
};

/* cmd flags */
enum {
	RTW_CMDF_DIRECTLY = BIT0,
	RTW_CMDF_WAIT_ACK = BIT1,
};

/* bcn_msg_hdl_state flags */
enum {
	RTW_BCN_MSG_HDL_BIT_SET = 0,
	RTW_BCN_MSG_HDL_BIT_RUN_IDX0 = 1,
	RTW_BCN_MSG_HDL_BIT_RUN_IDX1 = 2,
};

#ifdef CONFIG_WFA_OFDMA_Logo_Test
struct rtw_ru_cfg_list {
	char *name;
};
#endif

struct cmd_priv {
	u8	cmd_seq;
	u8	*cmd_buf;	/* shall be non-paged, and 4 bytes aligned */
	u8	*cmd_allocated_buf;
	u8	*rsp_buf;	/* shall be non-paged, and 4 bytes aligned		 */
	u8	*rsp_allocated_buf;
	u32	cmd_issued_cnt;
	struct dvobj_priv *dvobj;
	_mutex sctx_mutex;

	#if 0 /*#ifdef CONFIG_CORE_CMD_THREAD*/
	_queue	cmd_queue;
	_sema	cmd_queue_sema;
	_sema	start_cmdthread_sema;
	ATOMIC_T cmdthd_running;
	#endif
};

#ifdef CONFIG_EVENT_THREAD_MODE
struct evt_obj {
	u16	evtcode;
	u8	res;
	u8	*parmbuf;
	u32	evtsz;
	_list	list;
};
#endif

struct	evt_priv {
#ifdef CONFIG_EVENT_THREAD_MODE
	_sema	evt_notify;

	_queue	evt_queue;
#endif

#ifdef CONFIG_H2CLBK
	_sema	lbkevt_done;
	u8	lbkevt_limit;
	u8	lbkevt_num;
	u8	*cmdevt_parm;
#endif
	ATOMIC_T event_seq;
	u8	*evt_buf;	/* shall be non-paged, and 4 bytes aligned		 */
	u8	*evt_allocated_buf;
	u32	evt_done_cnt;
#if defined(CONFIG_SDIO_HCI) || defined(CONFIG_GSPI_HCI)
	u8	*c2h_mem;
	u8	*allocated_c2h_mem;
#endif

};

struct back_op_param {
	unsigned int off_ch_dur;
	unsigned int off_ch_ext_dur; /* extend when MGNT_TX */
	unsigned int on_ch_dur;
};

#define init_h2fwcmd_w_parm_no_rsp(pcmd, pparm, code) \
	do {\
		_rtw_init_listhead(&pcmd->list);\
		pcmd->cmdcode = code;\
		pcmd->parmbuf = (u8 *)(pparm);\
		pcmd->cmdsz = sizeof (*pparm);\
		pcmd->rsp = NULL;\
		pcmd->rspsz = 0;\
	} while (0)

#define init_h2fwcmd_w_parm_no_parm_rsp(pcmd, code) \
	do {\
		_rtw_init_listhead(&pcmd->list);\
		pcmd->cmdcode = code;\
		pcmd->parmbuf = NULL;\
		pcmd->cmdsz = 0;\
		pcmd->rsp = NULL;\
		pcmd->rspsz = 0;\
	} while (0)

struct P2P_PS_Offload_t {
	u8 Offload_En:1;
	u8 role:1; /* 1: Owner, 0: Client */
	u8 CTWindow_En:1;
	u8 NoA0_En:1;
	u8 NoA1_En:1;
	u8 AllStaSleep:1; /* Only valid in Owner */
	u8 discovery:1;
	u8 rsvd:1;
#ifdef CONFIG_P2P_PS_NOA_USE_MACID_SLEEP
	u8 p2p_macid:7;
	u8 disable_close_rf:1; /*1: not close RF but just pause p2p_macid when NoA duration*/
#endif /* CONFIG_P2P_PS_NOA_USE_MACID_SLEEP */
};

struct P2P_PS_CTWPeriod_t {
	u8 CTWPeriod;	/* TU */
};

#ifdef CONFIG_P2P_WOWLAN

struct P2P_WoWlan_Offload_t {
	u8 Disconnect_Wkup_Drv:1;
	u8 role:2;
	u8 Wps_Config[2];
};

#endif /* CONFIG_P2P_WOWLAN */

extern u32 rtw_enqueue_cmd(struct cmd_priv *pcmdpriv, struct cmd_obj *obj);
extern struct cmd_obj *rtw_dequeue_cmd(struct cmd_priv *pcmdpriv);
extern void rtw_free_cmd_obj(struct cmd_obj *pcmd);

#ifdef CONFIG_EVENT_THREAD_MODE
extern u32 rtw_enqueue_evt(struct evt_priv *pevtpriv, struct evt_obj *obj);
extern struct evt_obj *rtw_dequeue_evt(_queue *queue);
extern void rtw_free_evt_obj(struct evt_obj *pcmd);
#endif

#if 0 /*#ifdef CONFIG_CORE_CMD_THREAD*/
void rtw_stop_cmd_thread(_adapter *adapter);
thread_return rtw_cmd_thread(thread_context context);
#endif


u32 rtw_init_cmd_priv(struct dvobj_priv *dvobj);
void rtw_free_cmd_priv(struct dvobj_priv *dvobj);

extern u32 rtw_init_evt_priv(struct evt_priv *pevtpriv);
extern void rtw_free_evt_priv(struct evt_priv *pevtpriv);
extern void rtw_evt_notify_isr(struct evt_priv *pevtpriv);
#ifdef CONFIG_P2P
u8 p2p_protocol_wk_cmd(_adapter *padapter, int intCmdType);

#ifdef CONFIG_IOCTL_CFG80211
struct p2p_roch_parm {
	u64 cookie;
	struct wireless_dev *wdev;
	struct ieee80211_channel ch;
	enum nl80211_channel_type ch_type;
	unsigned int duration;
};

u8 p2p_roch_cmd(_adapter *adapter
	, u64 cookie, struct wireless_dev *wdev
	, struct ieee80211_channel *ch, enum nl80211_channel_type ch_type
	, unsigned int duration
	, u8 flags
);
u8 p2p_cancel_roch_cmd(_adapter *adapter, u64 cookie, struct wireless_dev *wdev, u8 flags);

#endif /* CONFIG_IOCTL_CFG80211 */
#endif /* CONFIG_P2P */

#ifdef CONFIG_IOCTL_CFG80211
u8 rtw_mgnt_tx_cmd(_adapter *adapter, u8 tx_ch, u8 no_cck, const u8 *buf,
		  size_t len, u32 wait_ack, u32 wait_ms, u8 flags);
struct mgnt_tx_parm {
	u8 tx_ch;
	u8 no_cck;
	const u8 *buf;
	size_t len;
	u32 wait_ack;
	u32 wait_ms;
};
#endif

enum rtw_drvextra_cmd_id {
	NONE_WK_CID, /*MCC_CMD_WK_CID*/
	STA_MSTATUS_RPT_WK_CID,
	DYNAMIC_CHK_WK_CID,
	DM_CTRL_WK_CID,
	PBC_POLLING_WK_CID,
	#ifdef CONFIG_POWER_SAVING
	POWER_SAVING_CTRL_WK_CID,/* IPS,AUTOSuspend */
	#endif
	LPS_CTRL_WK_CID,
	ANT_SELECT_WK_CID,
	P2P_PS_WK_CID,
	P2P_PROTO_WK_CID,
	CHECK_HIQ_WK_CID,/* for softap mode, check hi queue if empty */
	C2H_WK_CID,
	RESET_SECURITYPRIV, /* add for CONFIG_IEEE80211W, none 11w also can use */
	FREE_ASSOC_RESOURCES, /* add for CONFIG_IEEE80211W, none 11w also can use */
	DM_IN_LPS_WK_CID,
	DM_RA_MSK_WK_CID, /* add for STA update RAMask when bandwith change. */
	BEAMFORMING_WK_CID,
	LPS_CHANGE_DTIM_CID,
	DFS_RADAR_DETECT_WK_CID,
	DFS_RADAR_DETECT_EN_DEC_WK_CID,
	SESSION_TRACKER_WK_CID,
	TEST_H2C_CID,
	MP_CMD_WK_CID,
	CUSTOMER_STR_WK_CID,
	MGNT_TX_WK_CID,
	REQ_PER_CMD_WK_CID,
	SSMPS_WK_CID,
#ifdef CONFIG_CTRL_TXSS_BY_TP
	TXSS_WK_CID,
#endif
	AC_PARM_CMD_WK_CID,
#ifdef CONFIG_AP_MODE
	STOP_AP_WK_CID,
#endif
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	TBTX_CONTROL_TX_WK_CID,
#endif
	MAX_WK_CID
};

enum LPS_CTRL_TYPE {
	LPS_CTRL_SCAN = 0,
	LPS_CTRL_JOINBSS = 1,
	LPS_CTRL_CONNECT = 2,
	LPS_CTRL_DISCONNECT = 3,
	LPS_CTRL_SPECIAL_PACKET = 4,
	LPS_CTRL_LEAVE = 5,
	LPS_CTRL_TRAFFIC_BUSY = 6,
	LPS_CTRL_TX_TRAFFIC_LEAVE = 7,
	LPS_CTRL_RX_TRAFFIC_LEAVE = 8,
	LPS_CTRL_ENTER = 9,
	LPS_CTRL_LEAVE_CFG80211_PWRMGMT = 10,
	LPS_CTRL_LEAVE_SET_OPTION = 11,
};

enum STAKEY_TYPE {
	GROUP_KEY		= 0,
	UNICAST_KEY		= 1,
	TDLS_KEY		= 2,
};

enum RFINTFS {
	SWSI,
	HWSI,
	HWPI,
};


/*
Caller Mode: Infra, Ad-HoC(C)

Notes: To disconnect the current associated BSS

Command Mode

*/
struct disconnect_parm {
	u32 deauth_timeout_ms;
};

/*
Caller Mode: AP, Ad-HoC(M)

Notes: To create a BSS

Command Mode
*/
struct createbss_parm {
	bool adhoc;

	/* used by AP/Mesh mode now */
	u16 ifbmp;
	u16 excl_ifbmp;
	s16 req_ch;
	s8 req_bw;
	s8 req_offset;
	u8 is_change_chbw;
};


struct	setopmode_parm {
	u8	mode;
	u8	rsvd[3];
};

/*
Caller Mode: AP, Ad-HoC, Infra

Notes: To ask RTL8711 performing site-survey

Command-Event Mode

*/

enum rtw_scan_type {
	RTW_SCAN_NORMAL,
	RTW_SCAN_P2P,
	RTW_SCAN_RRM,
	RTW_SCAN_ACS
};

/* remain on channel priv */
struct scan_priv {
	_adapter *padapter;

	/* for remain on channel callback */
	struct wireless_dev *wdev;
	struct ieee80211_channel channel;
	u8 channel_type;
	unsigned int duration;
	u64 cookie;

	u8 restore_ch;

	u8 roch_step;
#ifdef CONFIG_RTW_80211K
	u32 rrm_token;	/* 80211k use it to identify caller */
#endif
};

#define RTW_SSID_SCAN_AMOUNT 9 /* for WEXT_CSCAN_AMOUNT 9 */
#define RTW_CHANNEL_SCAN_AMOUNT (14+37)
struct sitesurvey_parm {
	enum rtw_phl_scan_type scan_mode;	/* active: 1, passive: 0 */
	/* sint bsslimit;	// 1 ~ 48 */
	u8 ssid_num;
	u8 ch_num;
	NDIS_802_11_SSID ssid[RTW_SSID_SCAN_AMOUNT];
	struct rtw_ieee80211_channel ch[RTW_CHANNEL_SCAN_AMOUNT];

	u32 token; 	/* 80211k use it to identify caller */
	u16 duration;	/* 0: use default, otherwise: channel scan time */
	u8 igi;		/* 0: use defalut */
	u8 bw;		/* 0: use default */

	u8 acs; /* aim to trigger channel selection when scan done */

	bool is_p2p;
	enum rtw_scan_type scan_type;
};

/*
Caller Mode: Any

Notes: To set the auth type of RTL8711. open/shared/802.1x

Command Mode

*/
struct setauth_parm {
	u8 mode;  /* 0: legacy open, 1: legacy shared 2: 802.1x */
	u8 _1x;   /* 0: PSK, 1: TLS */
	u8 rsvd[2];
};

/*
Caller Mode: Infra

a. algorithm: wep40, wep104, tkip & aes
b. keytype: grp key/unicast key
c. key contents

when shared key ==> keyid is the camid
when 802.1x ==> keyid [0:1] ==> grp key
when 802.1x ==> keyid > 2 ==> unicast key

*/
struct setkey_parm {
	u8	algorithm;	/* encryption algorithm, could be none, wep40, TKIP, CCMP, wep104 */
	u8	keyid;
	u8	set_tx;		/* 1: main tx key for wep. 0: other key. */
	u8	key[32];	/* this could be 40 or 104 */
};

/*
When in AP or Ad-Hoc mode, this is used to
allocate an sw/hw entry for a newly associated sta.

Command

when shared key ==> algorithm/keyid

*/
struct set_stakey_parm {
	u8 addr[ETH_ALEN];
	u8 algorithm;
	u8 keyid;
	u8 key[32];
	u8 gk;
};

struct set_stakey_rsp {
	u8	addr[ETH_ALEN];
	u8	keyid;
	u8	rsvd;
};

struct Tx_Beacon_param {
	WLAN_BSSID_EX network;
	u8 msg_hdl_idx;
};

/*
	Notes: This command is used for H2C/C2H loopback testing

	mac[0] == 0
	==> CMD mode, return H2C_SUCCESS.
	The following condition must be ture under CMD mode
		mac[1] == mac[4], mac[2] == mac[3], mac[0]=mac[5]= 0;
		s0 == 0x1234, s1 == 0xabcd, w0 == 0x78563412, w1 == 0x5aa5def7;
		s2 == (b1 << 8 | b0);

	mac[0] == 1
	==> CMD_RSP mode, return H2C_SUCCESS_RSP

	The rsp layout shall be:
	rsp:			parm:
		mac[0]  =   mac[5];
		mac[1]  =   mac[4];
		mac[2]  =   mac[3];
		mac[3]  =   mac[2];
		mac[4]  =   mac[1];
		mac[5]  =   mac[0];
		s0		=   s1;
		s1		=   swap16(s0);
		w0		=	swap32(w1);
		b0		=	b1
		s2		=	s0 + s1
		b1		=	b0
		w1		=	w0

	mac[0] ==	2
	==> CMD_EVENT mode, return	H2C_SUCCESS
	The event layout shall be:
	event:			parm:
		mac[0]  =   mac[5];
		mac[1]  =   mac[4];
		mac[2]  =   event's sequence number, starting from 1 to parm's marc[3]
		mac[3]  =   mac[2];
		mac[4]  =   mac[1];
		mac[5]  =   mac[0];
		s0		=   swap16(s0) - event.mac[2];
		s1		=   s1 + event.mac[2];
		w0		=	swap32(w0);
		b0		=	b1
		s2		=	s0 + event.mac[2]
		b1		=	b0
		w1		=	swap32(w1) - event.mac[2];

		parm->mac[3] is the total event counts that host requested.


	event will be the same with the cmd's param.

*/

#ifdef CONFIG_H2CLBK

struct seth2clbk_parm {
	u8 mac[6];
	u16	s0;
	u16	s1;
	u32	w0;
	u8	b0;
	u16  s2;
	u8	b1;
	u32	w1;
};

struct geth2clbk_parm {
	u32 rsv;
};

struct geth2clbk_rsp {
	u8	mac[6];
	u16	s0;
	u16	s1;
	u32	w0;
	u8	b0;
	u16	s2;
	u8	b1;
	u32	w1;
};

#endif	/* CONFIG_H2CLBK */

/* CMD param Formart for driver extra cmd handler */
struct drvextra_cmd_parm {
	int ec_id; /* extra cmd id */
	int type; /* Can use this field as the type id or command size */
	int size; /* buffer size */
	unsigned char *pbuf;
};

/*------------------- Below are used for RF/BB tunning ---------------------*/
struct addBaReq_parm {
	unsigned int tid;
	u8	addr[ETH_ALEN];
};

struct addBaRsp_parm {
	unsigned int tid;
	unsigned int start_seq;
	u8 addr[ETH_ALEN];
	u8 status;
	u8 size;
	struct ADDBA_request preq;
};

struct set_ch_parm {
	u8 ch;
	u8 bw;
	u8 ch_offset;
	u8 do_rfk;
};

struct SetChannelPlan_param {
	const struct country_chplan *country_ent;
	u8 channel_plan;
#if CONFIG_IEEE80211_BAND_6GHZ
	u8 channel_plan_6g;
#endif
};

struct LedBlink_param {
	void *pLed;
};

struct TDLSoption_param {
	u8 addr[ETH_ALEN];
	u8 option;
};

struct RunInThread_param {
	void (*func)(void *);
	void *context;
};

struct SetRunCmdEn_param {
	u8 value;
};

#define GEN_CMD_CODE(cmd)	cmd ## _CMD_


/*

Result:
0x00: success
0x01: sucess, and check Response.
0x02: cmd ignored due to duplicated sequcne number
0x03: cmd dropped due to invalid cmd code
0x04: reserved.

*/

#define H2C_RSP_OFFSET			512

#define H2C_SUCCESS			0x00
#define H2C_SUCCESS_RSP			0x01
#define H2C_DUPLICATED			0x02
#define H2C_DROPPED			0x03
#define H2C_PARAMETERS_ERROR		0x04
#define H2C_REJECTED			0x05
#define H2C_CMD_OVERFLOW		0x06
#define H2C_RESERVED			0x07
#define H2C_ENQ_HEAD			0x08
#define H2C_ENQ_HEAD_FAIL		0x09
#define H2C_CMD_FAIL			0x0A

void rtw_init_sitesurvey_parm(_adapter *padapter, struct sitesurvey_parm *pparm);
u8 rtw_sitesurvey_cmd(_adapter *padapter, struct sitesurvey_parm *pparm);
u8 rtw_create_ibss_cmd(_adapter *adapter, int flags);
u8 rtw_startbss_cmd(_adapter *adapter, int flags);

#define REQ_CH_NONE		-1
#define REQ_CH_INT_INFO	-2
#define REQ_BW_NONE		-1
#define REQ_BW_ORI		-2
#define REQ_OFFSET_NONE	-1

u8 rtw_change_bss_chbw_cmd(_adapter *adapter, int flags
	, u16 ifbmp, u16 excl_ifbmp, s16 req_ch, s8 req_bw, s8 req_offset);

struct sta_info;
extern u8 rtw_setstakey_cmd(_adapter  *padapter, struct sta_info *sta, u8 key_type, bool enqueue);
extern u8 rtw_clearstakey_cmd(_adapter *padapter, struct sta_info *sta, u8 enqueue);

extern u8 rtw_joinbss_cmd(_adapter  *padapter, struct wlan_network *pnetwork);
u8 rtw_disassoc_cmd(_adapter *padapter, u32 deauth_timeout_ms, int flags);
#ifdef CONFIG_AP_MODE
u8 rtw_stop_ap_cmd(_adapter *adapter, u8 flags);
#endif
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
u8 rtw_tx_control_cmd(_adapter *adapter);
#endif
extern u8 rtw_setopmode_cmd(_adapter  *padapter, NDIS_802_11_NETWORK_INFRASTRUCTURE networktype, u8 flags);

extern u8 rtw_addbareq_cmd(_adapter *padapter, u8 tid, u8 *addr);
extern u8 rtw_addbarsp_cmd(_adapter *padapter, u8 *addr, u16 tid,
			   struct ADDBA_request *paddba_req, u8 status, u8 size,
			   u16 start_seq);
extern u8 rtw_delba_cmd(struct _ADAPTER *a, u8 *addr, u16 tid);
/* add for CONFIG_IEEE80211W, none 11w also can use */
extern u8 rtw_reset_securitypriv_cmd(_adapter *padapter);
extern u8 rtw_free_assoc_resources_cmd(_adapter *padapter, u8 lock_scanned_queue, int flags);
extern u8 rtw_dynamic_chk_wk_cmd(_adapter *adapter);

u8 rtw_lps_ctrl_wk_cmd(_adapter *padapter, u8 lps_ctrl_type, u8 flags);
u8 rtw_lps_ctrl_leave_set_level_cmd(_adapter *adapter, u8 lps_level, u8 flags);
#ifdef CONFIG_LPS_1T1R
u8 rtw_lps_ctrl_leave_set_1t1r_cmd(_adapter *adapter, u8 lps_1t1r, u8 flags);
#endif
u8 rtw_dm_in_lps_wk_cmd(_adapter *padapter);
u8 rtw_lps_change_dtim_cmd(_adapter *padapter, u8 dtim);

#ifdef CONFIG_ANTENNA_DIVERSITY
extern  u8 rtw_antenna_select_cmd(_adapter *padapter, u8 antenna, u8 enqueue);
#endif

u8 rtw_dm_ra_mask_wk_cmd(_adapter *padapter, u8 *psta);

#ifdef CONFIG_POWER_SAVING
extern u8 rtw_ps_cmd(_adapter *padapter);
#endif
void rtw_ch_switch_hdl(struct dvobj_priv *dvobj);

#ifdef CONFIG_AP_MODE
u8 rtw_chk_hi_queue_cmd(_adapter *padapter);
#endif /* CONFIG_AP_MODE */

#ifdef CONFIG_BTC
u8 rtw_btinfo_cmd(_adapter *padapter, u8 *pbuf, u16 length);
u8 rtw_btc_reduce_wl_txpwr_cmd(_adapter *adapter, u32 val);
#endif

u8 rtw_test_h2c_cmd(_adapter *adapter, u8 *buf, u8 len);
#if defined(RTW_PHL_DBG_CMD)
void core_cmd_phl_handler(_adapter *adapter, char *extra);
void _core_add_record(_adapter *adapter, u32 type, void *p);
static inline void core_add_record(_adapter *adapter, u8 record_enable, u32 type, void *p)
{
	if(record_enable)
		_core_add_record(adapter, type, p);

}
void phl_add_record(void *d, u32 type, void *p, u32 size);
#endif

u8 rtw_set_chbw_cmd(_adapter *padapter, u8 ch, u8 bw, u8 ch_offset, u8 flags);

u8 rtw_set_chplan_cmd(_adapter *adapter, int flags, u8 chplan, u8 chplan_6g, u8 swconfig);
u8 rtw_set_country_cmd(_adapter *adapter, int flags, const char *country_code, u8 swconfig);

#ifdef CONFIG_RTW_LED_HANDLED_BY_CMD_THREAD
u8 rtw_led_blink_cmd(_adapter *padapter, void *pLed);
#endif
extern u8 rtw_set_csa_cmd(_adapter *adapter);
extern u8 rtw_tdls_cmd(_adapter *padapter, u8 *addr, u8 option);
extern u8 rtw_set_run_cmd_en(_adapter *padapter, u8 value, u8 flags);

void Get_macid_WD_by_AC(_adapter *adapter, u8 macid, u8 AC);

u8 rtw_mp_cmd(_adapter *adapter, u8 mp_cmd_id, u8 flags);

#ifdef CONFIG_RTW_CUSTOMER_STR
u8 rtw_customer_str_req_cmd(_adapter *adapter);
u8 rtw_customer_str_write_cmd(_adapter *adapter, const u8 *cstr);
#endif

u8 rtw_c2h_packet_wk_cmd(_adapter *adapter, u8 *c2h_evt, u16 length);

u8 rtw_run_in_thread_cmd(_adapter *adapter, void (*func)(void *), void *context);
u8 rtw_run_in_thread_cmd_wait(_adapter *adapter, void (*func)(void *), void *context, s32 timeout_ms);

struct ssmps_cmd_parm {
	struct sta_info *sta;
	u8 smps;
};
u8 rtw_ssmps_wk_cmd(_adapter *adapter, struct sta_info *sta, u8 smps, u8 enqueue);

u8 session_tracker_chk_cmd(_adapter *adapter, struct sta_info *sta);
u8 session_tracker_add_cmd(_adapter *adapter, struct sta_info *sta, u8 *local_naddr, u8 *local_port, u8 *remote_naddr, u8 *remote_port);
u8 session_tracker_del_cmd(_adapter *adapter, struct sta_info *sta, u8 *local_naddr, u8 *local_port, u8 *remote_naddr, u8 *remote_port);

u8 set_txq_params_cmd(_adapter *adapter, u32 ac_parm, u8 ac_type);

#if defined(CONFIG_RTW_MESH) && defined(RTW_PER_CMD_SUPPORT_FW)
u8 rtw_req_per_cmd(_adapter * adapter);
#endif
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
u8 rtw_tbtx_chk_cmd(_adapter *adapter);
u8 rtw_tbtx_token_dispatch_cmd(_adapter *adapter);
#endif
#ifdef CONFIG_CTRL_TXSS_BY_TP
struct txss_cmd_parm {
	struct sta_info *sta;
	bool tx_1ss;
};

void rtw_ctrl_txss_update_mimo_type(_adapter *adapter, struct sta_info *sta);
u8 rtw_ctrl_txss(_adapter *adapter, struct sta_info *sta, bool tx_1ss);
void rtw_ctrl_tx_ss_by_tp(_adapter *adapter, u8 from_timer);

#ifdef DBG_CTRL_TXSS
void dbg_ctrl_txss(_adapter *adapter, bool tx_1ss);
#endif
#endif

u8 rtw_drvextra_cmd_hdl(_adapter *padapter, unsigned char *pbuf);

extern void rtw_survey_cmd_callback(_adapter  *padapter, struct cmd_obj *pcmd);
extern void rtw_disassoc_cmd_callback(_adapter  *padapter, struct cmd_obj *pcmd);
extern void rtw_joinbss_cmd_callback(_adapter  *padapter, struct cmd_obj *pcmd);
void rtw_create_ibss_post_hdl(_adapter *padapter, int status);
extern void rtw_readtssi_cmdrsp_callback(_adapter	*padapter,  struct cmd_obj *pcmd);

extern void rtw_setstaKey_cmdrsp_callback(_adapter  *padapter,  struct cmd_obj *pcmd);
extern void rtw_getrttbl_cmdrsp_callback(_adapter  *padapter,  struct cmd_obj *pcmd);
void rtw_run_cmd(_adapter *padapter, struct cmd_obj *pcmd, bool discard);
#ifdef CONFIG_RTW_DEBUG_CAM
u8 get_cmac_8852ae(_adapter *adapter, u32 macid, char *target_attr, u32 *oval);
void get_cmac_many_8852ae(_adapter *adapter, u32 macid, char **target_attr, u32 *oval);
#endif

#ifdef CONFIG_RTW_HANDLE_SER_L2
u8 rtw_recover_dev_cmd(_adapter *padapter);
#endif /* CONFIG_RTW_HANDLE_SER_L2 */

#ifdef CONFIG_IOCTL_CFG80211
u8 rtw_phl_remain_on_ch_cmd(_adapter *padapter, u64 cookie, struct wireless_dev *wdev,
	struct ieee80211_channel *ch, u8 ch_type, unsigned int duration,
	struct back_op_param *bkop_parm, u8 is_p2p);
#endif

enum rtw_cmd_id {
	CMD_JOINBSS,
	CMD_DISCONNECT,
	CMD_CREATE_BSS,
	CMD_SET_OPMODE,
#ifdef CONFIG_FSM
	CMD_SITE_SURVEY,
#endif
	CMD_SET_AUTH,
#ifndef CONFIG_CMD_DISP
	CMD_SET_KEY,
	CMD_SET_STAKEY,
#endif
	CMD_ADD_BAREQ,
	CMD_SET_CHANNEL,
	CMD_TX_BEACON,
	CMD_SET_MLME_EVT,
	CMD_SET_DRV_EXTRA,
	CMD_SET_CHANPLAN,
	CMD_LEDBLINK,
	CMD_SET_CHANSWITCH,
	CMD_TDLS,
	CMD_CHK_BMCSLEEPQ,
	CMD_RUN_INTHREAD,
	CMD_ADD_BARSP,
	CMD_RM_POST_EVENT,
	CMD_SET_MESH_PLINK_STATE,
	CMD_DELBA,
	CMD_SET_RUN_CMD_EN,
	CMD_ID_MAX
};

#define CMD_FMT "cmd=%d,%d,%d"
#define CMD_ARG(cmd) \
	(cmd)->cmdcode, \
	(cmd)->cmdcode == CMD_SET_DRV_EXTRA ? ((struct drvextra_cmd_parm *)(cmd)->parmbuf)->ec_id : ((cmd)->cmdcode == CMD_SET_MLME_EVT ? ((struct rtw_evt_header *)(cmd)->parmbuf)->id : 0), \
	(cmd)->cmdcode == CMD_SET_DRV_EXTRA ? ((struct drvextra_cmd_parm *)(cmd)->parmbuf)->type : 0

#ifdef CONFIG_CMD_GENERAL
void rtw_dynamic_chk_wk_sw_hdl(_adapter *padapter);
void rtw_dynamic_chk_wk_hw_hdl(_adapter *padapter);
#else
void rtw_dynamic_chk_wk_hdl(_adapter *padapter);
#endif

void rtw_switch_wmm_mode(_adapter *padapter);


#define SHOW_REG32(adapter, reg, m) \
	do { \
		RTW_PRINT_SEL(m, "\t%04X = %08X\n", \
			  (reg), rtw_phl_read32(adapter->dvobj->phl, reg)); \
	} while (0)

#define SHOW_REG32_MSG(adapter, reg, msg, m) \
	do { \
		RTW_PRINT_SEL(m, "\t%04X = %08X - %s\n", \
			  (reg), rtw_phl_read32(adapter->dvobj->phl, reg), msg); \
	} while (0)

#define SHOW_REG16(adapter, reg, m) \
	do { \
		RTW_PRINT_SEL(m, "\t%04X = %04X\n", \
			  (reg), rtw_phl_read16(adapter->dvobj->phl, reg)); \
	} while (0)

#define SHOW_REG16_MSG(adapter, reg, msg, m) \
	do { \
		RTW_PRINT_SEL(m, "\t%04X = %04X - %s\n", \
			  (reg), rtw_phl_read16(adapter->dvobj->phl, reg), msg); \
	} while (0)

void _show_RX_counter(_adapter *adapter, void *m);
void _show_TX_dbg_status(_adapter *adapter, void *m);
void _show_BCN_dbg_status(_adapter *adapter, void *m);
void Get_macid_WD_by_AC(_adapter *adapter, u8 macid, u8 AC);
void cmd_a4_dump_sta(_adapter *adapter, void *m);
void cmd_a4_dump_db(_adapter *adapter, void *m);
void core_dump_record(_adapter *adapter, u8 dump_type, void *m);
void rtw_core_dump_buf_cap(_adapter *padapter, void *m);

#ifdef DEBUG_PHL_RX
void rtw_phl_cmd_phl_rx_dump(_adapter *adapter, void* m);
#endif

#define _rtw_phl_read32_(reg) (*((volatile unsigned int *)(reg)))
#define rtw_init_mask0 0xb8b00000
#define rtw_init_mask1 0xb80007f0

void core_cmd_dump_cnt(_adapter *adapter, void *cmd_para, u32 para_num);

#ifdef CONFIG_OCTOSCOPE_REFINE
enum {
	OCTOSCOPE_TESTCASE_START,
	CMCC_5G_1_STA_SMALL_PKT_DL,
	CMCC_5G_5_STA_SMALL_PKT_DL,
	CMCC_5G_40_STA_SMALL_PKT_DL,
	CMCC_5G_40_STA_MEDIUM_PKT_DL,
	CMCC_5G_160M_5_STA_BIG_PKT_UL,
	CMCC_5G_160M_40_STA_BIG_PKT_DL,
	CT_5G_8_STA_LATENCY_DL,
	CT_5G_8_STA_LATENCY_UL,
	CT_5G_8_STA_SMALL_PKT_DL,
	CT_5G_64_STA_DL,
	OCTOSCOPE_TESTCASE_END
};

void rtw_octoscope_handler(_adapter *padapter);
void rtw_octoscope_pkt_count(_adapter *padapter, struct sk_buff *skb);
#endif

#endif /* _CMD_H_ */
