/******************************************************************************
 *
 * Copyright(c) 2007 - 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#ifndef __STA_INFO_H_
#define __STA_INFO_H_

#include <rtw_sta_info.h>

#ifdef CONFIG_CORE_TXSC
#include <rtw_xmit_shortcut.h>
#endif

#ifdef CONFIG_RTW_CORE_RXSC
#include <rtw_recv_shortcut.h>
#endif

#ifdef CONFIG_RTW_A4_STA
#include <rtw_a4.h>
#endif

#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
#include <rtw_ap_wapi.h>
#endif

#define IBSS_START_MAC_ID	2
#define NUM_STA MACID_NUM_SW_LIMIT

#ifdef CONFIG_GREEN_CHANNEL_FOR_LATENCY_STA
#define num_latency_sta 6
#endif

#ifndef CONFIG_RTW_MACADDR_ACL
	#define CONFIG_RTW_MACADDR_ACL 1
#endif

#ifndef CONFIG_RTW_PRE_LINK_STA
	#define CONFIG_RTW_PRE_LINK_STA 0
#endif

#define NUM_ACL 100

#define RTW_ACL_PERIOD_DEV 0
#define RTW_ACL_PERIOD_BSS 1
#define RTW_ACL_PERIOD_NUM 2

#define RTW_ACL_MODE_DISABLED				0
#define RTW_ACL_MODE_ACCEPT_UNLESS_LISTED	1
#define RTW_ACL_MODE_DENY_UNLESS_LISTED		2
#define RTW_ACL_MODE_MAX					3

#if CONFIG_RTW_MACADDR_ACL
extern const char *const _acl_period_str[RTW_ACL_PERIOD_NUM];
#define acl_period_str(mode) (((mode) >= RTW_ACL_PERIOD_NUM) ? "INVALID" : _acl_period_str[(mode)])
extern const char *const _acl_mode_str[RTW_ACL_MODE_MAX];
#define acl_mode_str(mode) (((mode) >= RTW_ACL_MODE_MAX) ? "INVALID" : _acl_mode_str[(mode)])
#endif

#ifndef RTW_PRE_LINK_STA_NUM
	#define RTW_PRE_LINK_STA_NUM 8
#endif

struct pre_link_sta_node_t {
	u8 valid;
	u8 addr[ETH_ALEN];
};

struct pre_link_sta_ctl_t {
	_lock lock;
	u8 num;
	struct pre_link_sta_node_t node[RTW_PRE_LINK_STA_NUM];
};

#ifdef CONFIG_TDLS
#define MAX_ALLOWED_TDLS_STA_NUM	4
#endif

enum sta_info_update_type {
	STA_INFO_UPDATE_NONE = 0,
	STA_INFO_UPDATE_BW = BIT(0),
	STA_INFO_UPDATE_RATE = BIT(1),
	STA_INFO_UPDATE_PROTECTION_MODE = BIT(2),
	STA_INFO_UPDATE_CAP = BIT(3),
	STA_INFO_UPDATE_HT_CAP = BIT(4),
	STA_INFO_UPDATE_VHT_CAP = BIT(5),
	STA_INFO_UPDATE_ALL = STA_INFO_UPDATE_BW
			      | STA_INFO_UPDATE_RATE
			      | STA_INFO_UPDATE_PROTECTION_MODE
			      | STA_INFO_UPDATE_CAP
			      | STA_INFO_UPDATE_HT_CAP
			      | STA_INFO_UPDATE_VHT_CAP,
	STA_INFO_UPDATE_MAX
};

enum rtw_free_phl_sta_type {
	RTW_FREE_PHL_STA_SW,
	RTW_FREE_PHL_STA_HW,
	RTW_FREE_PHL_STA_ALL
};

enum rtw_bit_sta_check_state {
	RTW_BIT_STA_ALLOC_DONE
};

struct rtw_wlan_acl_node {
	_list		        list;
	u8       addr[ETH_ALEN];
	u8       valid;
	u32      hit;
	u32      valid_time;
};

struct wlan_acl_pool {
	int mode;
	int num;
	struct rtw_wlan_acl_node aclnode[NUM_ACL];
	_queue	acl_node_q;
};

struct	stainfo_stats	{
	systime last_rx_time;

	u64 rx_mgnt_pkts;
	u64 rx_beacon_pkts;
	u64 rx_probereq_pkts;
	u64 rx_probersp_pkts; /* unicast to self */
	u64 rx_probersp_bm_pkts;
	u64 rx_probersp_uo_pkts; /* unicast to others */
	u64 rx_ctrl_pkts;
	u64 rx_data_pkts;
	u64 rx_data_bc_pkts;
	u64 rx_data_mc_pkts;
	u64 rx_data_qos_pkts[TID_NUM]; /* unicast only */
	u64 rx_data_retry_pkts;
	u32 rx_data_pkts_cur;
	u32 rx_data_retry_pkts_cur;

	u64	last_rx_mgnt_pkts;
	u64 last_rx_beacon_pkts;
	u64 last_rx_probereq_pkts;
	u64 last_rx_probersp_pkts; /* unicast to self */
	u64 last_rx_probersp_bm_pkts;
	u64 last_rx_probersp_uo_pkts; /* unicast to others */
	u64	last_rx_ctrl_pkts;
	u64	last_rx_data_pkts;
	u64 last_rx_data_bc_pkts;
	u64 last_rx_data_mc_pkts;
	u64 last_rx_data_qos_pkts[TID_NUM]; /* unicast only */
	u64 last_rx_data_retry_pkts;

#ifdef CONFIG_TDLS
	u64 rx_tdls_disc_rsp_pkts;
	u64 last_rx_tdls_disc_rsp_pkts;
#endif

	u64	rx_bytes;
	u64	rx_bc_bytes;
	u64	rx_mc_bytes;
	u64	last_rx_bytes;
	u64 last_rx_bc_bytes;
	u64 last_rx_mc_bytes;
	u64	rx_drops; /* TBD */
	u32 rx_tp_kbits;
	u32 smooth_rx_tp_kbits;

	u64	tx_pkts;
	u64	last_tx_pkts;
	u64 tx_add_req_data;
	u64 tx_data_retry_pkts;
	u64 last_tx_data_retry_pkts;
	u32 tx_data_retry_pkts_cur;
	u32 tx_data_pkts_cur;
	u64 tx_data_fail_pkts;
	u64 last_tx_data_fail_pkts;
	u32 tx_data_fail_pkts_cur;

	u64	tx_bytes;
	u64	last_tx_bytes;
	u64 tx_drops; /* TBD */
	u32 tx_tp_kbits;
	u32 smooth_tx_tp_kbits;
	u32 my_tx_tp_kbits;

#ifdef CONFIG_LPS_CHK_BY_TP
	u64 acc_tx_bytes;
	u64 acc_rx_bytes;
#endif

	u32 nr_sleep;

	/* unicast only */
	u64 last_rx_data_uc_pkts; /* For Read & Clear requirement in proc_get_rx_stat() */
	u32 duplicate_cnt;	/* Read & Clear, in proc_get_rx_stat() */
	u32 rxratecnt[RTW_DATA_RATE_MAX];	/* Read & Clear, in proc_get_rx_stat() */
	u32 tx_ok_cnt;		/* Read & Clear, in proc_get_tx_stat() */
	u32 tx_fail_cnt;	/* Read & Clear, in proc_get_tx_stat() */
	u32 tx_retry_cnt;	/* Read & Clear, in proc_get_tx_stat() */
	u32 tx_retry_ratio;
#ifdef CONFIG_RTW_MESH
	u32 rx_hwmp_pkts;
	u32 last_rx_hwmp_pkts;
#endif
	u8  leave;
	u32 last_tx_ok_cnt;
	u32 last_tx_fail_cnt;
	u32 tx_conti_fail;
	u32 tx_conti_fail_cnt;
	u64 tx_last_good_time;
	u32 rx_icverr_pkts;
	u32 rx_conti_icverr_pkts;
	u32 rx_conti_icverr_times;
#ifdef CONFIG_AMSDU_HW_TIMER
	u32 smooth_tx_data_pkts_pps;
	u32 last_smooth_tx_data_pkts_pps;
	u8  hw_timer_ignore_cnt;
#endif
};

#ifndef DBG_SESSION_TRACKER
#define DBG_SESSION_TRACKER 0
#endif

/* session tracker status */
#define ST_STATUS_NONE		0
#define ST_STATUS_CHECK		BIT0
#define ST_STATUS_ESTABLISH	BIT1
#define ST_STATUS_EXPIRE	BIT2

#define ST_EXPIRE_MS (10 * 1000)

struct session_tracker {
	_list list; /* session_tracker_queue */
	u32 local_naddr;
	u16 local_port;
	u32 remote_naddr;
	u16 remote_port;
	systime set_time;
	u8 status;
};

/* session tracker cmd */
#define ST_CMD_ADD 0
#define ST_CMD_DEL 1
#define ST_CMD_CHK 2

struct st_cmd_parm {
	u8 cmd;
	struct sta_info *sta;
	u32 local_naddr; /* TODO: IPV6 */
	u16 local_port;
	u32 remote_naddr; /* TODO: IPV6 */
	u16 remote_port;
};

typedef bool (*st_match_rule)(_adapter *adapter, u8 *local_naddr, u8 *local_port, u8 *remote_naddr, u8 *remote_port);

struct st_register {
	u8 s_proto;
	st_match_rule rule;
};

#define SESSION_TRACKER_REG_ID_WFD 0
#define SESSION_TRACKER_REG_ID_NUM 1

struct st_ctl_t {
	struct st_register reg[SESSION_TRACKER_REG_ID_NUM];
	_queue tracker_q;
};

void rtw_st_ctl_init(struct st_ctl_t *st_ctl);
void rtw_st_ctl_deinit(struct st_ctl_t *st_ctl);
void rtw_st_ctl_register(struct st_ctl_t *st_ctl, u8 st_reg_id, struct st_register *reg);
void rtw_st_ctl_unregister(struct st_ctl_t *st_ctl, u8 st_reg_id);
bool rtw_st_ctl_chk_reg_s_proto(struct st_ctl_t *st_ctl, u8 s_proto);
bool rtw_st_ctl_chk_reg_rule(struct st_ctl_t *st_ctl, _adapter *adapter, u8 *local_naddr, u8 *local_port, u8 *remote_naddr, u8 *remote_port);
void rtw_st_ctl_rx(struct sta_info *sta, u8 *ehdr_pos);
void dump_st_ctl(void *sel, struct st_ctl_t *st_ctl);

#ifdef CONFIG_TDLS
struct TDLS_PeerKey {
	u8 kck[16]; /* TPK-KCK */
	u8 tk[16]; /* TPK-TK; only CCMP will be used */
} ;
#endif /* CONFIG_TDLS */

#ifdef CONFIG_RTW_MESH
struct mesh_plink_ent;
struct rtw_ewma_err_rate {
	unsigned long internal;
};

/* Mesh airtime link metrics parameters */
struct rtw_atlm_param {
	struct rtw_ewma_err_rate err_rate; /* Now is PACKET error rate */
	u16 data_rate; /* The unit is 100Kbps */
	u16 total_pkt;
	u16 overhead; /* Channel access overhead */
};
#endif

enum TRAFFIC_MODE {
	TRAFFIC_MODE_UNKNOWN = 0,
	TRAFFIC_MODE_TX = 1,
	TRAFFIC_MODE_RX = 2,
	TRAFFIC_MODE_BIDIR = 3,
};

#ifdef CONFIG_TX_MCAST2UNI
#define MAX_IP_MC_ENTRY 64
#define MAX_CLIENT_IP_ENTRY 4

struct ip_mcast_info {
	u8 mcmac[MAC_ADDR_LEN];
	u8 is_ipv6;
	u8 client_num;
	u32 v4_client_ip[MAX_CLIENT_IP_ENTRY];
	struct in6_addr v6_client_ip[MAX_CLIENT_IP_ENTRY];
};
#endif

#ifdef CONFIG_IEEE80211W
#define SA_QUERY_RETRY_TO				201
#define SA_QUERY_MAX_TO					1000
#define SA_QUERY_MAX_NUM				5
#endif

struct sta_info {

	struct rtw_phl_stainfo_t *phl_sta;

	/***********************************************************
	 * from here on, data will be clear in _rtw_init_stainfo() *
	 ***********************************************************/

	unsigned int sta_info_clear_start;

	_lock	lock;
	_list	free_list; /* free_sta_queue */
	_list	hash_list; /* sta_hash */
	/* _list asoc_list; */ /* 20061114 */
	/* _list sleep_list; */ /* sleep_q */
	/* _list wakeup_list; */ /* wakeup_q */
	_adapter *padapter;

	/* move to phl station info */
	/* struct cmn_sta_info cmn; */

	struct sta_xmit_priv sta_xmitpriv;
	struct sta_recv_priv sta_recvpriv;

#ifdef SBWC
	unsigned char SBWC_mode;
	unsigned int SBWC_tx_limit; 		//kbps
	unsigned int SBWC_rx_limit; 		//kbps
	unsigned int SBWC_tx_limit_byte;
	unsigned int SBWC_rx_limit_byte;
	unsigned int SBWC_tx_count;
	unsigned int SBWC_rx_count;
	struct sk_buff_head SBWC_txq;
	struct sk_buff_head SBWC_rxq;
	unsigned char SBWC_consuming_q;
#endif
#ifdef GBWC
	unsigned char		GBWC_in_group;
#endif

#ifdef RTW_STA_BWC
	unsigned int		sta_bwc_tx_limit;	 	// bw control value, kbps
	unsigned int		sta_bwc_tx_limit_byte;	// bw control value, byte period
	unsigned int		sta_bwc_tx_cnt;			// tx Byte count
	struct sk_buff_head	sta_bwc_txq;
	unsigned char		sta_bwc_consuming_q;
#endif

	_queue sleep_q;
	_list bmc_list;
	//_list trigger_list;
	//unsigned int sleepq_len;

	uint state;
	uint qos_option;
	u16 hwseq;

	unsigned long check_state;

#ifdef CONFIG_RTW_80211K
	u8 rm_en_cap[5];
	u8 rm_diag_token;
#ifdef CONFIG_RTW_AP_EXT_SUPPORT
	struct dot11k_beacon_measurement_report rm_beacon_rpt_list[RTW_MAX_RADIO_RPT_NUM];
#endif /* CONFIG_RTW_AP_EXT_SUPPORT */
	u8 rm_beacon_rpt_num;
	u8 rm_beacon_rpt_status;
#ifdef CONFIG_RTW_MULTI_AP
	u8 beacon_report_start_index;
	u8 rm_beacon_rpt_len[RTW_MAX_RADIO_RPT_NUM];
	u8 rm_becaon_meas_token[RTW_MAX_RADIO_RPT_NUM];
	u8 rm_beacon_rpt_mode[RTW_MAX_RADIO_RPT_NUM];
#endif
#endif /* CONFIG_RTW_80211K */

	systime	resp_nonenc_eapol_key_starttime;
	uint	ieee8021x_blocked;	/* 0: allowed, 1:blocked */
	uint	dot118021XPrivacy; /* aes, tkip... */
	union Keytype	dot11tkiptxmickey;
	union Keytype	dot11tkiprxmickey;
	union Keytype	dot118021x_UncstKey;
	union pn48		dot11txpn;			/* PN48 used for Unicast xmit */
	union pn48		dot11rxpn;			/* PN48 used for Unicast recv. */
	s8		hw_decrypted; /* STA HW security is ready or not */
	u8 key_installed[3]; /* bitmap of keytype installed */

#ifdef CONFIG_RTW_CORE_RXSC
	u32 rxsc_idx_new;
	u32 rxsc_idx_cached;
	struct core_rxsc_entry rxsc_entry[NUM_RXSC_ENTRY];
#if defined(CONFIG_RTW_BYPASS_DEAMSDU) && defined(PLATFORM_LINUX)
	unsigned char subpkt_addr1[NUM_RXSC_ENTRY][ETH_ALEN];
	u8 subpkt_idx;
	u8 subpkt_cnt;
#endif
#endif
	ATOMIC_T	keytrack;
#ifdef CONFIG_RTW_MESH
	/* peer's GTK, RX only */
	u8 group_privacy;
	u8 gtk_bmp;
	union Keytype gtk;
	union pn48 gtk_pn;
	#ifdef CONFIG_IEEE80211W
	/* peer's IGTK, RX only */
	enum security_type dot11wCipher;
	u8 igtk_bmp;
	u8 igtk_id;
	union Keytype igtk;
	union pn48 igtk_pn;
	#endif /* CONFIG_IEEE80211W */
#endif /* CONFIG_RTW_MESH */
#ifdef CONFIG_GTK_OL
	u8 kek[RTW_KEK_LEN];
	u8 kck[RTW_KCK_LEN];
	u8 replay_ctr[RTW_REPLAY_CTR_LEN];
#endif /* CONFIG_GTK_OL */
#ifdef CONFIG_IEEE80211W
#ifndef CONFIG_IOCTL_CFG80211
	_timer dot11w_expire_timer;
	unsigned long sa_query_end;
	u32 sa_query_cnt;
	u16 sa_query_tid[SA_QUERY_MAX_NUM + 1];
	u8 sa_query_timed_out;
#else
	u8 pmf_timeout_ie[5];
	u8 pmf_timeout_ie_len;
#endif
#endif /* CONFIG_IEEE80211W */

	u8	bssrateset[16];
	u32	bssratelen;

	u8	init_rate;
	u16 cur_tx_data_rate;
	u16 cur_rx_data_rate;
	u8 cur_tx_gi_ltf;
	u8 cur_rx_gi_ltf;
	u8 cur_tx_bw;
	u8 cur_rx_bw;

	struct stainfo_stats sta_stats;

#ifdef CONFIG_TDLS
	u32	tdls_sta_state;
	u8	SNonce[32];
	u8	ANonce[32];
	u32	TDLS_PeerKey_Lifetime;
	u32	TPK_count;
	_timer	TPK_timer;
	struct TDLS_PeerKey	tpk;
#ifdef CONFIG_TDLS_CH_SW
	u16	ch_switch_time;
	u16	ch_switch_timeout;
	/* u8	option; */
	_timer	ch_sw_timer;
	_timer	delay_timer;
	_timer	stay_on_base_chnl_timer;
	_timer	ch_sw_monitor_timer;
#endif
	_timer handshake_timer;
	u8 alive_count;
	_timer	pti_timer;
	u8	TDLS_RSNIE[20];	/* Save peer's RSNIE, used for sending TDLS_SETUP_RSP */
#endif /* CONFIG_TDLS */

	/* for A-MPDU TX, ADDBA timeout check	 */
	_timer addba_retry_timer;

	/* for A-MPDU Rx reordering buffer control */
	struct recv_reorder_ctrl recvreorder_ctrl[TID_NUM];
	ATOMIC_T continual_no_rx_packet[TID_NUM];
	/* for A-MPDU Tx */
	/* unsigned char		ampdu_txen_bitmap; */
	u16	BA_starting_seqctrl[16];


#ifdef CONFIG_80211N_HT
	struct ht_priv	htpriv;
#endif

#ifdef CONFIG_80211AC_VHT
	struct vht_priv	vhtpriv;
#endif

#ifdef CONFIG_80211AX_HE
	struct he_priv	hepriv;
#endif

#ifdef CONFIG_RTW_MBO
	struct mbo_priv mbopriv;
#endif /* CONFIG_RTW_MBO */

	/* Notes:	 */
	/* STA_Mode: */
	/* curr_network(mlme_priv/security_priv/qos/ht) + sta_info: (STA & AP) CAP/INFO	 */
	/* scan_q: AP CAP/INFO */

	/* AP_Mode: */
	/* curr_network(mlme_priv/security_priv/qos/ht) : AP CAP/INFO */
	/* sta_info: (AP & STA) CAP/INFO */

	unsigned int expire_to;/* unit: 2 sec */

#ifdef CONFIG_NEC_RX_DATA_EXPIRE
	unsigned int rx_data_expire_to; /* sec , time to expire after associated. */
#endif

#ifdef CONFIG_RTW_A4_STA
	struct list_head	a4_sta_list;
#endif

#ifdef CONFIG_AP_MODE

	_list asoc_list;
	_list auth_list;

	unsigned int auth_seq;
	unsigned int authalg;
	unsigned char chg_txt[128];

	unsigned int link_time; /* unit: 1 sec */
	u16 capability;
	u8 ext_capab_ie_data[12];/*currently for ap mode only*/
	u8 ext_capab_ie_len;
	int flags;

	int dot8021xalg;/* 0:disable, 1:psk, 2:802.1x */
	int wpa_psk;/* 0:disable, bit(0): WPA, bit(1):WPA2 */
	int wpa_group_cipher;
	int wpa2_group_cipher;
	int wpa_pairwise_cipher;
	int wpa2_pairwise_cipher;
#if defined(CONFIG_RTL_CFG80211_WAPI_SUPPORT)
	u32 wapi_group_cipher;
	u32 wapi_pairwise_cipher;
	u16 wapi_cap;

	RTL_WAPI_STA_INFO wapiStaInfo;
#endif
	u32 akm_suite_type;

	u8 bpairwise_key_installed;
#ifdef CONFIG_RTW_80211R
	u8 ft_pairwise_key_installed;
	u8 ft_support;
	u8 ft_roaming;
#endif

#ifdef CONFIG_NATIVEAP_MLME
	u8 wpa_ie[32];

	u8 nonerp_set;
	u8 no_short_slot_time_set;
	u8 no_short_preamble_set;
	u8 no_ht_gf_set;
	u8 no_ht_set;
	u8 ht_20mhz_set;
	u8 ht_40mhz_intolerant;
#endif /* CONFIG_NATIVEAP_MLME */

#ifdef CONFIG_ATMEL_RC_PATCH
	u8 flag_atmel_rc;
#endif

	u8 qos_info;

	u8 max_sp_len;
	u16 uapsd_bitmap;

#ifdef CONFIG_P2P
	/* p2p priv data */
	u8 is_p2p_device;
	u8 p2p_status_code;

	/* p2p client info */
	u8 dev_addr[ETH_ALEN];
	/* u8 iface_addr[ETH_ALEN]; */ /* = hwaddr[ETH_ALEN] */
	u8 dev_cap;
	u16 config_methods;
	u8 primary_dev_type[8];
	u8 num_of_secdev_type;
	u8 secdev_types_list[32];/* 32/8 == 4; */
	u16 dev_name_len;
	u8 dev_name[32];
#endif /* CONFIG_P2P */

#ifdef CONFIG_WFD
	u8 op_wfd_mode;
#endif

#ifdef CONFIG_TX_MCAST2UNI
	u8 ipmc_num;
	struct ip_mcast_info ipmc[MAX_IP_MC_ENTRY];
#endif /* CONFIG_TX_MCAST2UNI */

#ifdef CONFIG_AUTO_AP_MODE
	u8 isrc; /* this device is rc */
	u16 pid; /* pairing id */
#endif

#ifdef CONFIG_RTW_WNM
	int bss_trans_status_code;
	unsigned char bss_trans_support;
#endif

#ifdef CONFIG_RECORD_CLIENT_HOST
	unsigned char client_host_name[256];
	unsigned char client_host_ip[4];
#endif

#endif /* CONFIG_AP_MODE	 */

#ifdef CONFIG_RTW_MESH
	struct mesh_plink_ent *plink;

	u8 local_mps;
	u8 peer_mps;
	u8 nonpeer_mps;

	struct rtw_atlm_param metrics;
	/* The reference for nexthop_lookup */
	BOOLEAN alive;
#endif



#ifdef CONFIG_IOCTL_CFG80211
	u8 *pauth_frame;
	u32 auth_len;
	u8 *pcommit;
	u32 commit_len;
	u8 *passoc_req;
	u32 assoc_req_len;
#endif

	u8 vendor;			/* enum _HT_IOT_PEER */
#ifdef CONFIG_LPS_PG
	u8		lps_pg_rssi_lv;
#endif

	/* To store the sequence number of received management frame */
	u16 RxMgmtFrameSeqNum;

	struct st_ctl_t st_ctl;
	u8 max_agg_num_minimal_record; /*keep minimal tx desc max_agg_num setting*/
	u8 curr_rx_rate;
	u8 curr_rx_rate_bmc;
#ifdef CONFIG_RTS_FULL_BW
	bool vendor_8812;
#endif

#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	u8 tbtx_enable;			/* Does this sta_info support & enable TBTX function? */
//	u8 tbtx_timeslot;		/* This sta_info belong to which time slot.	*/
#endif

	/*
	 * Vaiables for queuing TX pkt a short period of time
	 * to wait something ready.
	 */
	u8 tx_q_enable;
	struct __queue tx_queue;
	_workitem tx_q_work;

#ifdef CONFIG_CORE_TXSC
	u32	txsc_cache_hit;
	u32 txsc_a4_hit;
#ifdef CONFIG_TXSC_AMSDU
	u32 txsc_amsdu_hit; /* CONFIG_TXSC_AMSDU */
	u32 txsc_a4_amsdu_hit;
#endif
	u32	txsc_cache_miss;
	u32	txsc_path_slow;
	u32	txsc_path_ps;
	u32	txsc_wlhdr_copy;
	u32	txsc_priority_update;
	u8 txsc_cur_idx;	//next entry to add
	u8 txsc_cache_idx;	//latest cache idx
	u8 txsc_cache_num;	//num of txsc entry
	#ifdef CONFIG_RTW_ENABLE_HW_TXSC
	u32	hw_txsc_hit;
	u8	hw_txsc_set;
	u8	hw_entry_used;
	#ifdef CONFIG_RTW_DEBUG_HW_TXSC
	u8	txsc_data[64];
	u8	txsc_data_len;
	#endif /* CONFIG_RTW_DEBUG_HW_TXSC */
	#endif /* CONFIG_RTW_ENABLE_HW_TXSC */
	struct txsc_entry txsc_entry_cache[CORE_TXSC_ENTRY_NUM];
	u32 txsc_entry_full;

#ifdef CONFIG_TXSC_AMSDU
	struct txsc_amsdu_swq amsdu_txq[4]; //VO VI BE BK
	u8 txsc_amsdu_num;
	u8 txsc_amsdu_max;

	/* AMSDU_BY_SIZE */
	u32 txsc_amsdu_size;
	u32 txsc_amsdu_max_size;

	_timer txsc_amsdu_vo_timer;
	u8 txsc_amsdu_vo_timeout_sts;

	_timer txsc_amsdu_vi_timer;
	u8 txsc_amsdu_vi_timeout_sts;

	_timer txsc_amsdu_be_timer;
	u8 txsc_amsdu_be_timeout_sts;

	_timer txsc_amsdu_bk_timer;
	u8 txsc_amsdu_bk_timeout_sts;
#ifdef CONFIG_AMSDU_HW_TIMER
	u8 txsc_amsdu_hw_timeout; //ms
#endif
#endif /* CONFIG_TXSC_AMSDU */
	u8 txsc_sec_cam_idx;
#endif /* CONFIG_CORE_TXSC */
#ifdef CONFIG_APPEND_VENDOR_IE_ENABLE
	u8 *vendor_ie[WLAN_MAX_VENDOR_IE_NUM];
	u8 vendor_ielen[WLAN_MAX_VENDOR_IE_NUM];
#endif
#ifdef WIFI_LOGO_HE_4_52_1
	u8 om_time;
	u8 om_step;
#endif
#ifdef CONFIG_RTW_TWT
	u8 twt_cur_operate_num[4];
#endif

unsigned char multiap_profile;

#if defined(CONFIG_RTW_MULTI_AP) || defined(CONFIG_WLAN_DE_SUPPORT)
	u8 last_rssi;
	u16 assoc_req_length;
	u8 assoc_req_body[512];
#endif

#ifdef CONFIG_WLAN_MANAGER
	u8 supported_band;
#endif /* CONFIG_WLAN_MANAGER */
	u8 dialog_token;
	u8 traffic_mode;	/* refer enum TRAFFIC_MODE */
#ifdef CONFIG_BW160M_EXTREME_THROUGHPUT_RX
	u8 extreme_rx_traffic;
#endif
#ifdef CONFIG_CTC_FEATURE
	u8 roaming_indicate;
	u8 roaming_wait_cnt;
#endif
#ifdef CONFIG_LMT_TXREQ
	ATOMIC_T num_pending_txreq;
	ATOMIC_T num_pending_txreq_ac[4];
	u16 lmt_pending_txreq;
	u16 lmt_pending_txreq_ac[4];
	u32 lmt_txreq_drop;
#endif
	u32 snr_fd_total[4];
	u32 snr_td_total[4];
	u8 snr_fd_avg[4];
	u8 snr_td_avg[4];
	u32 snr_num;
	/* store rx nss parsed when assoc */
	u8 nss_rx_assoc;

#ifdef CONFIG_WFA_OFDMA_Logo_Test
	s32	core_current_xframe_cnt;
	s32 core_xframe_abort;
	s32 core_current_txreq_cnt;
#ifdef CONFIG_MULTI_STA_REFINE
	s32 core_current_txreq_cnt_prev;
#endif
	s32 core_txreq_abort;
#endif

#ifdef CONFIG_WFA_OFDMA_Logo_Test_Statistic
	u32 os_tx_cnt;
	u32 os_tx_drop_cnt;

	u32 core_xframe_total_cnt;

	u32 core_txsc_amsdu_need_enq;
	u32 core_txsc_amsdu_need_deq;
	u32 core_txsc_amsdu_abort;
	u32 core_txsc_amsdu_timeout;
	u32 core_txsc_amsdu_deq;

	u32 core_txsc_apply_cnt_1;
	u32 core_txsc_apply_cnt_2;

	u32 core_txsc_apply_no_txreq;
	u32 core_txsc_apply_fail;
#endif
	u8  fix_amsdu;
	u16 fixRate;
	u32 fast_txnok_chk;
#ifdef CONFIG_HAPD_OWE
	u8 owe_dh_ie[OWE_DH_IE_LEN];
	u8 owe_dh_ie_len;
#endif /* CONFIG_HAPD_OWE */
#if defined(CONFIG_HAPD_OWE) || defined(DIRECT_HAPD_RSN_IE)
	u8 rsn_ie[60];
	u8 rsn_ie_len;
#endif
	u8 leave_conti_icverr;
	u8 assoc_type;
#ifdef CONFIG_24G_256QAM
	u8 vht_2g_chk_cnt; /* used for checking if a 2G HT STA supports VHT */
#endif
};

#ifdef CONFIG_GREEN_CHANNEL_FOR_LATENCY_STA
struct latency_sta_info {
	_list free_list;
	_list asoc_list;
	u8 mac_addr[MAC_ALEN];
	u8 set_enable;
};
#endif

#ifdef CONFIG_RTW_MESH
#define STA_SET_MESH_PLINK(sta, link) (sta)->plink = link
#else
#define STA_SET_MESH_PLINK(sta, link) do {} while (0)
#endif

#define sta_tx_pkts(sta) \
	(sta->sta_stats.tx_pkts)

#define sta_last_tx_pkts(sta) \
	(sta->sta_stats.last_tx_pkts)

#define sta_rx_pkts(sta) \
	(sta->sta_stats.rx_mgnt_pkts \
	 + sta->sta_stats.rx_ctrl_pkts \
	 + sta->sta_stats.rx_data_pkts)

#define sta_last_rx_pkts(sta) \
	(sta->sta_stats.last_rx_mgnt_pkts \
	 + sta->sta_stats.last_rx_ctrl_pkts \
	 + sta->sta_stats.last_rx_data_pkts)

#define sta_rx_data_pkts(sta) (sta->sta_stats.rx_data_pkts)
#define sta_last_rx_data_pkts(sta) (sta->sta_stats.last_rx_data_pkts)

#define sta_rx_data_uc_pkts(sta) (sta->sta_stats.rx_data_pkts - sta->sta_stats.rx_data_bc_pkts - sta->sta_stats.rx_data_mc_pkts)
#define sta_last_rx_data_uc_pkts(sta) (sta->sta_stats.last_rx_data_pkts - sta->sta_stats.last_rx_data_bc_pkts - sta->sta_stats.last_rx_data_mc_pkts)

#define sta_rx_data_qos_pkts(sta, i) \
	(sta->sta_stats.rx_data_qos_pkts[i])

#define sta_last_rx_data_qos_pkts(sta, i) \
	(sta->sta_stats.last_rx_data_qos_pkts[i])

#define sta_rx_mgnt_pkts(sta) \
	(sta->sta_stats.rx_mgnt_pkts)

#define sta_last_rx_mgnt_pkts(sta) \
	(sta->sta_stats.last_rx_mgnt_pkts)

#define sta_rx_beacon_pkts(sta) \
	(sta->sta_stats.rx_beacon_pkts)

#define sta_last_rx_beacon_pkts(sta) \
	(sta->sta_stats.last_rx_beacon_pkts)

#define sta_rx_probereq_pkts(sta) \
	(sta->sta_stats.rx_probereq_pkts)

#define sta_last_rx_probereq_pkts(sta) \
	(sta->sta_stats.last_rx_probereq_pkts)

#define sta_rx_probersp_pkts(sta) \
	(sta->sta_stats.rx_probersp_pkts)

#define sta_last_rx_probersp_pkts(sta) \
	(sta->sta_stats.last_rx_probersp_pkts)

#define sta_rx_probersp_bm_pkts(sta) \
	(sta->sta_stats.rx_probersp_bm_pkts)

#define sta_last_rx_probersp_bm_pkts(sta) \
	(sta->sta_stats.last_rx_probersp_bm_pkts)

#define sta_rx_probersp_uo_pkts(sta) \
	(sta->sta_stats.rx_probersp_uo_pkts)

#define sta_last_rx_probersp_uo_pkts(sta) \
	(sta->sta_stats.last_rx_probersp_uo_pkts)

#ifdef CONFIG_RTW_MESH
#define update_last_rx_hwmp_pkts(sta) \
	do { \
		sta->sta_stats.last_rx_hwmp_pkts = sta->sta_stats.rx_hwmp_pkts; \
	} while(0)
#else
#define update_last_rx_hwmp_pkts(sta) do {} while(0)
#endif

/*
 * For AP mode last_rx_data_pkts update is moved to collect_sta_traffic_statistics
 */
#define sta_update_last_rx_pkts_apmode(sta) \
	do { \
		int __i; \
		\
		sta->sta_stats.last_rx_mgnt_pkts = sta->sta_stats.rx_mgnt_pkts; \
		sta->sta_stats.last_rx_beacon_pkts = sta->sta_stats.rx_beacon_pkts; \
		sta->sta_stats.last_rx_probereq_pkts = sta->sta_stats.rx_probereq_pkts; \
		sta->sta_stats.last_rx_probersp_pkts = sta->sta_stats.rx_probersp_pkts; \
		sta->sta_stats.last_rx_probersp_bm_pkts = sta->sta_stats.rx_probersp_bm_pkts; \
		sta->sta_stats.last_rx_probersp_uo_pkts = sta->sta_stats.rx_probersp_uo_pkts; \
		sta->sta_stats.last_rx_ctrl_pkts = sta->sta_stats.rx_ctrl_pkts; \
		update_last_rx_hwmp_pkts(sta); \
		\
		sta->sta_stats.last_rx_data_bc_pkts = sta->sta_stats.rx_data_bc_pkts; \
		sta->sta_stats.last_rx_data_mc_pkts = sta->sta_stats.rx_data_mc_pkts; \
		for (__i = 0; __i < TID_NUM; __i++) \
			sta->sta_stats.last_rx_data_qos_pkts[__i] = sta->sta_stats.rx_data_qos_pkts[__i]; \
	} while (0)

#define sta_update_last_rx_pkts(sta) \
	do { \
		sta_update_last_rx_pkts_apmode(sta); \
		sta->sta_stats.last_rx_data_pkts = sta->sta_stats.rx_data_pkts; \
	} while (0)

#define STA_RX_PKTS_ARG(sta) \
	sta->sta_stats.rx_mgnt_pkts \
	, sta->sta_stats.rx_ctrl_pkts \
	, sta->sta_stats.rx_data_pkts

#define STA_LAST_RX_PKTS_ARG(sta) \
	sta->sta_stats.last_rx_mgnt_pkts \
	, sta->sta_stats.last_rx_ctrl_pkts \
	, sta->sta_stats.last_rx_data_pkts

#define STA_RX_PKTS_DIFF_ARG(sta) \
	sta->sta_stats.rx_mgnt_pkts - sta->sta_stats.last_rx_mgnt_pkts \
	, sta->sta_stats.rx_ctrl_pkts - sta->sta_stats.last_rx_ctrl_pkts \
	, sta->sta_stats.rx_data_pkts - sta->sta_stats.last_rx_data_pkts

#define STA_PKTS_FMT "(m:%llu, c:%llu, d:%llu)"

#define sta_rx_uc_bytes(sta) (sta->sta_stats.rx_bytes - sta->sta_stats.rx_bc_bytes - sta->sta_stats.rx_mc_bytes)
#define sta_last_rx_uc_bytes(sta) (sta->sta_stats.last_rx_bytes - sta->sta_stats.last_rx_bc_bytes - sta->sta_stats.last_rx_mc_bytes)

#ifdef CONFIG_WFD
#define STA_OP_WFD_MODE(sta) (sta)->op_wfd_mode
#define STA_SET_OP_WFD_MODE(sta, mode) (sta)->op_wfd_mode = (mode)
#else
#define STA_OP_WFD_MODE(sta) 0
#define STA_SET_OP_WFD_MODE(sta, mode) do {} while (0)
#endif

#define AID_BMP_LEN(max_aid) ((max_aid + 1) / 8 + (((max_aid + 1) % 8) ? 1 : 0))

struct	sta_priv {

	u8 *pallocated_stainfo_buf;
	u8 *pstainfo_buf;
	_queue	*pfree_sta_queue;

	_lock sta_hash_lock;
	_list   sta_hash[NUM_STA];
	int asoc_sta_count;
	_queue sleep_q;
	_queue wakeup_q;

	_adapter *padapter;

	struct sta_info *psta_cache;
	u32 adhoc_expire_to;

	int rx_chk_limit;
	int rx_chk_limit_w53w56;

#if defined(RTW_WKARD_AP_CMD_DISPATCH) || defined(WFO_STRUCT_ALIGNED) || defined(RTW_STA_ALLOC_FREE_SAFE)
	_lock sta_info_lock;
#endif

#ifdef CONFIG_GREEN_CHANNEL_FOR_LATENCY_STA
	u8 *pallocated_latency_sta_buf;
	u8 *platency_sta_buf;
	_queue	*free_latency_queue;

	_list latency_sta_list;
	_lock latency_sta_list_lock;
	u8 latency_sta_list_cnt;
#endif

#ifdef CONFIG_AP_MODE
	_list asoc_list;
	_list auth_list;
	_lock asoc_list_lock;
	_lock auth_list_lock;
	u8 asoc_list_cnt;
	u8 auth_list_cnt;

	unsigned int auth_to;  /* sec, time to expire in authenticating. */
	unsigned int assoc_to; /* sec, time to expire before associating. */
	unsigned int expire_to; /* sec , time to expire after associated. */
#ifdef CONFIG_NEC_RX_DATA_EXPIRE
	unsigned int rx_data_expire_to; /* sec , time to expire after associated. */
#endif

	/*
	* pointers to STA info; based on allocated AID or NULL if AID free
	* AID is in the range 1-2007, so sta_aid[0] corresponders to AID 1
	*/
	struct sta_info **sta_aid;
	u16 max_aid;
	u16 started_aid; /* started AID for allocation search */
	bool rr_aid; /* round robin AID allocation, will modify started_aid */
	u8 aid_bmp_len; /* in byte */
	u8 *sta_dz_bitmap;
	u8 *tim_bitmap;

	u16 max_num_sta;

#if CONFIG_RTW_MACADDR_ACL
	struct wlan_acl_pool acl_list[RTW_ACL_PERIOD_NUM];
#endif

	#if CONFIG_RTW_PRE_LINK_STA
	struct pre_link_sta_ctl_t pre_link_sta_ctl;
	#endif
#ifdef CONFIG_RTW_TOKEN_BASED_XMIT
	u8 tbtx_asoc_list_cnt;
	struct sta_info *token_holder[NR_MAXSTA_INSLOT];
	struct sta_info *last_token_holder;
	ATOMIC_T nr_token_keeper;
#endif
#endif /* CONFIG_AP_MODE */

#ifdef CONFIG_ATMEL_RC_PATCH
	u8 atmel_rc_pattern[6];
#endif
	u8 c2h_sta_mac[ETH_ALEN];
	u8 c2h_adapter_id;
	struct submit_ctx *gotc2h;
};


__inline static u32 wifi_mac_hash(const u8 *mac)
{
	u32 x;

	x = mac[0];
	x = (x << 2) ^ mac[1];
	x = (x << 2) ^ mac[2];
	x = (x << 2) ^ mac[3];
	x = (x << 2) ^ mac[4];
	x = (x << 2) ^ mac[5];

	x ^= x >> 8;
	x  = x % NUM_STA;

	return x;
}


extern u32	_rtw_init_sta_priv(struct sta_priv *pstapriv);
extern u32	_rtw_free_sta_priv(struct sta_priv *pstapriv);

#define stainfo_offset_valid(offset) (offset < NUM_STA && offset >= 0)
int rtw_stainfo_offset(struct sta_priv *stapriv, struct sta_info *sta);
struct sta_info *rtw_get_stainfo_by_offset(struct sta_priv *stapriv, int offset);

u8 rtw_get_sta_disabled(struct rtw_phl_stainfo_t *phl_sta);
void rtw_set_sta_disabled(struct rtw_phl_stainfo_t *phl_sta, u8 disable);
extern struct sta_info *rtw_alloc_stainfo(struct sta_priv *pstapriv, const u8 *hwaddr, enum phl_cmd_type cmd_type);

extern struct sta_info *rtw_alloc_stainfo_sw(struct	sta_priv *stapriv, const u8 *hwaddr);
extern u32 rtw_alloc_stainfo_hw(struct	sta_priv *stapriv, struct sta_info *psta);
u32 rtw_init_stainfo(_adapter *padapter , struct sta_info *psta);

extern u32 rtw_free_stainfo(_adapter *padapter , struct sta_info *psta);
extern u32 rtw_free_stainfo_sw(_adapter *padapter, struct sta_info *psta);
extern void rtw_free_all_stainfo(_adapter *padapter);
extern void rtw_free_disabled_stainfo(_adapter *padapter);
extern struct sta_info *rtw_get_stainfo(struct sta_priv *pstapriv, const u8 *hwaddr);
extern struct sta_info *rtw_get_stainfo_by_macid(struct sta_priv *pstapriv, u16 macid);
extern struct sta_info *rtw_get_bcmc_stainfo(_adapter *padapter);

u32	rtw_free_self_stainfo(_adapter *adapter);
u32 rtw_init_self_stainfo(_adapter *adapter, enum phl_cmd_type cmd_type);

#ifdef CONFIG_AP_MODE
u16 rtw_aid_alloc(_adapter *adapter, struct sta_info *sta);
void dump_aid_status(void *sel, _adapter *adapter);
#endif

#if CONFIG_RTW_MACADDR_ACL
extern u8 rtw_access_ctrl(_adapter *adapter, const u8 *mac_addr);
void dump_macaddr_acl(void *sel, _adapter *adapter);
#endif

#if CONFIG_RTW_PRE_LINK_STA
bool rtw_is_pre_link_sta(struct sta_priv *stapriv, u8 *addr);
struct sta_info *rtw_pre_link_sta_add(struct sta_priv *stapriv, u8 *hwaddr);
void rtw_pre_link_sta_del(struct sta_priv *stapriv, u8 *hwaddr);
void rtw_pre_link_sta_ctl_reset(struct sta_priv *stapriv);
void rtw_pre_link_sta_ctl_init(struct sta_priv *stapriv);
void rtw_pre_link_sta_ctl_deinit(struct sta_priv *stapriv);
void dump_pre_link_sta_ctl(void *sel, struct sta_priv *stapriv);
#endif /* CONFIG_RTW_PRE_LINK_STA */

extern void rtw_update_stainfo_by_asoc(_adapter *padapter, u8 *hwaddr);

#ifdef CONFIG_GREEN_CHANNEL_FOR_LATENCY_STA
struct latency_sta_info *rtw_check_latency_sta_exist(_adapter *adapter, u8 *mac_addr);
#endif

#endif /* _STA_INFO_H_ */
