/******************************************************************************
 *
 * Copyright(c) 2012 - 2020 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef __HAL1115_FW_LOG__
#define __HAL1115_FW_LOG__
#include "../../type.h"

enum LOG_MSG_1115_TABLE {
    MSG_1115_FIRST = 0,                                                  //"RESERVED"
    MSG_1115_SAMPLE_NO_PARAMETER,                                    //"Sample without parameter.\n"
    MSG_1115_SAMPLE_PARAMETER,                                       //"Sample string:%s.\n"
    MSG_1115_SAMPLE_INTEGER,                                         //"Sample integer:%d.\n"
    MSG_1115_SAMPLE_INTEGER_X,                                       //"Sample integer:0x%x.\n"
    MSG_1115_SAMPLE_INTEGER_2,                                       //"Sample integer1:%d, integer2:%d.\n"
    MSG_1115_FCUN_NAME,                                              //"%s()\n"
    MSG_1115_MAIN_1,                                                 //"FW from host\n"
    MSG_1115_MAIN_2,                                                 //"Skip DL FW handler\n"
    MSG_1115_MAIN_3,                                                 //"FW from flash\n"
    MSG_1115_MAIN_4,                                                //"Invalid boot mode\n"
    MSG_1115_FWDLHDL_1,                                             //"Invalid boot reason\n"
    MSG_1115_FWDLHDL_2,                                             //"Enter DL FW handler\n"
    MSG_1115_FWDLHDL_3,                                             //"FWHDR H2C done\n"
    MSG_1115_FLASHBOOT,                                             //"Enter flash FW loader\n"
    MSG_1115_IRAMENTRN,                                             //"Load FW RAM code OK\n"
    MSG_1115_FIRSTH2C_1,                                            //"First H2C Enqueue\n"
    MSG_1115_FIRSTH2C_2,                                            //"H2C node malloc fail\n"
    MSG_1115_FIRSTH2C_3,                                            //"H2C node content malloc fail\n"
    MSG_1115_H2CDEQ_1,                                              //"H2C Dequeue\n"
    MSG_1115_H2CDEQ_2,                                              //"H2CPKT enqueue fail\n"
    MSG_1115_CMDTABLE_NAME,                                        //"%s "
    MSG_1115_CMDTABLE_1,                                           //"        ?\n"
    MSG_1115_CMDTABLE_2,                                           //"       dump bytes, ex: DB 0xb8e00000\n"
    MSG_1115_CMDTABLE_3,                                           //"       write bytes,  ex: EB 0xb8e00000 0x1\n"
    MSG_1115_CMDTABLE_4,                                           //"       dump words, ex: DW 0xb8e00000\n"
    MSG_1115_CMDTABLE_5,                                           //"       write words, ex: EW 0xb8e00000, 0x12345678\n"
    MSG_1115_CMDTABLE_6,                                           //"        jump to address, ex: j 0xb8900000\n"
    MSG_1115_CMDTABLE_7,                                           //"   set debug level\n"
    MSG_1115_CMDTABLE_8,                                           //"  set debug compoment bitmap\n"
    MSG_1115_CMDTABLE_9,                                           //" show task info\n"
    MSG_1115_CMDTABLE_10,                                          //" show heap info\n"
    MSG_1115_CMDTABLE_11,                                          //"  show dynamic allocate memory info, <index>, <mode>\n"
    MSG_1115_CMDTABLE_12,                                          //"  show task time state\n"
    MSG_1115_CMDTABLE_13,                                          //"   AXIDMA test\n"
    MSG_1115_CMDTABLE_14,                                          //"   SPIC test\n"
    MSG_1115_CMDTABLE_15,                                          //"    IDDMA test\n"
    MSG_1115_CMDTABLE_16,                                          //"   RXI300 test\n"
    MSG_1115_CMDTABLE_17,                                          //"      DLE test\n"
    MSG_1115_CMDTABLE_18,                                          //"     HIOE test\n"
    MSG_1115_CMDTABLE_19,                                          //"     RPT test\n"
    MSG_1115_CMDTABLE_20,                                          //"     MISC test\n"
    MSG_1115_CMDTABLE_21,                                          //"  Update STA para for F2PTXCMD\n"
    MSG_1115_CMDTABLE_22,                                          //" Update Common para for F2PTXCMD\n"
    MSG_1115_CMDTABLE_23,                                          //" Wlan Flow Test\n"
    MSG_1115_CMDTABLE_24,                                          //" Wlan Test Mode Setting\n"
    MSG_1115_CMDTABLE_25,                                          //"   Wlan Flow with RUA Test\n"
    MSG_1115_CMDTABLE_26,                                          //"   Wlan UL Flow Test\n"
    MSG_1115_CMDTABLE_27,                                          //"       IPSec test\n"
    MSG_1115_CMDTABLE_28,                                          //"   CryptoSig test\n"
    MSG_1115_CMDTABLE_29,                                          //"  SecureBoot test\n"
    MSG_1115_CMDTABLE_30,                                          //" Secure eFuse R/W test\n"
    MSG_1115_CMDTABLE_31,                                          //"      Plat test\n"
    MSG_1115_CMDTABLE_32,                                          //"    H2C/C2H test\n"
    MSG_1115_CMDTABLE_33,                                          //"    UL F2PCMD test, <number of STAs>, <frame exchange type>, 0\n"
    MSG_1115_CMDTABLE_34,                                          //" Sounding test\n"
    MSG_1115_CMDTABLE_35,                                          //"   security CAM test\n"
    MSG_1115_CMDTABLE_36,                                          //"   Gtimer test, <id>, <mode>, <unit>, <duration>\n"
    MSG_1115_CMDTABLE_37,                                          //"  PStimer test, <band>, <id>, <mode>, <tsf> (valid if mode = 0)\n"
    MSG_1115_CMDTABLE_38,                                          //"     RPWM test\n"
    MSG_1115_CMDTABLE_39,                                          //"    DLTXD test\n"
    MSG_1115_CMDTABLE_40,                                          //"       PS test\n"
    MSG_1115_CMDTABLE_41,                                          //"      32K CAL test\n"
    MSG_1115_CMDTABLE_42,                                          //"   WoW CAM test\n"
    MSG_1115_CMDTABLE_43,                                          //"   PS ONOFF test\n"
    MSG_1115_CMDTABLE_44,                                          //"    BTCoex test\n"
    MSG_1115_CMDTABLE_45,                                          //"    DL Parameters Setting\n"
    MSG_1115_CMDTABLE_46,                                          //"      Dump Wlan common info, f2pcmd result, decision result\n"
    MSG_1115_CMDTABLE_47,                                          //"      Dump Wlan sta or muru grp info\n"
    MSG_1115_CMDTABLE_48,                                          //"      Dump Wlan decision info\n"
    MSG_1115_CMDTABLE_49,                                          //"     Dump FW info\n"
    MSG_1115_CMDTABLE_50,                                          //"    TFDBG\n"
    MSG_1115_CMDTABLE_51,                                          //"    CRT\n"
    MSG_1115_MALLOC_F,                                             //"malloc is failed\n"
    MSG_1115_STRING_0,                                             //"%s\n"
    MSG_1115_STRING_1,                                             //"%s"
    MSG_1115_PARA_INVALID,                                         //"Invalid parameters\n"
    MSG_1115_CMD_UNKNOWN,                                          //"Unknown cmd\n"
    MSG_1115_CONSOLE_1,                                            //"- CMD -\n"
    MSG_1115_CONSOLE_2,                                            //"0x%x: 0x%x\n"
    MSG_1115_CONSOLE_3,                                            //"Jump to 0x%x\n"
    MSG_1115_CONSOLE_4,                                            //"Set dbg level to: 0x%x\n"
    MSG_1115_CONSOLE_5,                                            //"Set dbg component bitmap to: 0x%x\n"
    MSG_1115_CONSOLE_6,                                            //"Task\t\tState\tPrio\tStack start\tMin Stack(DW)\tNum\tCnt\n"
    MSG_1115_CONSOLE_7,                                            //"--------------------------------------------------------------------------------\n"
    MSG_1115_CONSOLE_8,                                            //"Index\t\tStart\t\tTotal(B)\tFree(B)\tMin Free(B)\n"
    MSG_1115_CONSOLE_9,                                            //"------------------------------------------------------------------------\n"
    MSG_1115_CONSOLE_10,                                           //"Address\t\tOwner ID\tFunction\tType\t\tSize(B)\n"
    MSG_1115_CONSOLE_11,                                           //"Owner ID\tFunction\tType\t\tCounter\t\tTotalSize(B)\tHistorical High\n"
    MSG_1115_CONSOLE_12,                                           //"------------------------------------------------------------------------------------------------\n"
    MSG_1115_CONSOLE_13,                                           //"Owner ID\tType\t\tTotalSize(B)\n"
    MSG_1115_CONSOLE_14,                                           //"------------------------------------------------\n"
    MSG_1115_MCC_SEARCHMACID_1,                                    //"[MCC] pmcc_info is NULL!\n"
    MSG_1115_MCC_SEARCHMACID_2,                                    //"[MCC] pgroup_list is empty!\n"
    MSG_1115_MCC_STATUSRPTHDL_1,                                    //"[MCC] MCCStatusRptHDL macid: %d, group: %d, status: %d\n"
    MSG_1115_MCC_STATUSRPTHDL_2,                                    //"[MCC] tsf: 0x%x 0x%x\n"
    MSG_1115_MCC_TBTTSTATUSRPTHDL,                                    //"[MCC] B%dP%d TBTT TSF = 0x%x\n"
    MSG_1115_MCC_MACIDDROP,                                        //"[MCC] MACIDTxIdleCheck fail\n"
    MSG_1115_MCC_ISSUENULLWOLPS_1,                                    //"[MCC][%d][CXEVNT_ENULL]\n"
    MSG_1115_MCC_ISSUENULLWOLPS_2,                                    //"[MCC] Issue null %d fail!!!\n"
    MSG_1115_MCC_ISSUENULL_1,                                        //"[MCC] macid %d role not found\n"
    MSG_1115_MCC_ISSUENULL_2,                                        //"[MCC][%d]Macid %d Null %d, TSF = 0x%x, freerun = 0x%x\n"
    MSG_1115_MCC_TXNULLCHK_1,                                        //"[MCC] mcc group not found\n"
    MSG_1115_MCC_TXNULLCHK_2,                                        //"[MCC] take semaphore fail!\n"
    MSG_1115_MCC_TXNULLCHK_3,                                        //"[MCC][%d]Macid %d TxNull %d SUCCESS, freerun = 0x%x\n"
    MSG_1115_MCC_TXNULLCHK_4,                                        //"[MCC][%d]Macid %d TxNull %d FAIL, freerun = 0x%x\n"
    MSG_1115_MCC_SENDNULLCB_1,                                        //"[MCC][RPT] MACID DROP => macid (%d)\n"
    MSG_1115_MCC_SENDNULLCB_2,                                        //"[MCC][RPT] LIFE DROP => macid (%d)\n"
    MSG_1115_MCC_SENDNULLCB_3,                                        //"[MCC][RPT] invalid RPT (%d)\n"
    MSG_1115_MCC_SWITCHCH_1,                                        //"[MCC] cfg ch FAIL!!!\n"
    MSG_1115_MCC_SWITCHCH_2,                                        //"[MCC] RFK CH SW, CH= %d\n"
    MSG_1115_MCC_SWITCHCH_3,                                        //"[MCC] RFK FAIL!!!\n"
    MSG_1115_MCC_SWITCHCH_4,                                        //"[MCC] RFK bypass\n"
    MSG_1115_MCC_CHANGEROLE_1,                                        //"[MCC] MCCMacidDrop fail\n"
    MSG_1115_MCC_CHANGEROLE_2,                                        //"[MCC](courtesy)macid %d => macid %d\n"
    MSG_1115_MCC_CHANGEROLE_3,                                        //"[MCC][%d][CXEVNT_EBT]\n"
    MSG_1115_MCC_CHANGEROLE_4,                                        //"[MCC][%d][CXEVNT_E5G]\n"
    MSG_1115_MCC_CHANGEROLE_5,                                        //"[MCC][%d][CXEVNT_E2G]\n"
    MSG_1115_MCC_CHANGEROLE_6,                                        //"[MCC][%d]Start BT TSF = 0x%x, freerun = 0x%x\n"
    MSG_1115_MCC_CHANGEROLE_7,                                        //"[MCC][%d]Start macid %d TSF = 0x%x, freerun = 0x%x\n"
    MSG_1115_MCC_CHANGEROLE_8,                                        //"[MCC] MCCMacidDropRel fail\n"
    MSG_1115_MCC_FIRSTDURATIONENDHDL_1,                            //"[MCC] First duration running\n"
    MSG_1115_MCC_FIRSTDURATIONENDHDL_2,                            //"[MCC][REP/STP] act: %d, deal with old schedule now...\n"
    MSG_1115_MCC_FIRSTDURATIONENDHDL_3,                            //"[MCC] MCCGroupStop fail\n"
    MSG_1115_MCC_FIRSTDURATIONENDHDL_4,                            //"[MCC] MCCGroupDel fail\n"
    MSG_1115_MCC_GROUPSTOP_1,                                        //"[MCC] FirstDuration timer del!\n"
    MSG_1115_MCC_GROUPSTOP_2,                                        //"[MCC] replace/pause mode, FirstDuration del bypass!\n"
    MSG_1115_MCC_NEWDURATIONHDL,                                    //"[MCC] Set duration\n"
    MSG_1115_MCC_BITMAPCMP_1,                                        //"[MCC] Release macid %d\n"
    MSG_1115_MCC_BITMAPCMP_2,                                        //"[MCC] Pause macid %d\n"
    MSG_1115_MCC_H2CADDMCCHDL_1,                                    //"[MCC] Add MCC macid %d to group %d\n"
    MSG_1115_MCC_H2CADDMCCHDL_2,                                    //"[MCC] macid: %d, duration: %d, bt_in_2g: %d\n"
    MSG_1115_MCC_H2CADDMCCHDL_3,                                    //"[MCC] Add MCC band %d port %d\n"
    MSG_1115_MCC_H2CSTARTMCCHDL_1,                                    //"[MCC] Start MCC group %d from macid %d\n"
    MSG_1115_MCC_H2CSTARTMCCHDL_2,                                    //"[MCC][REP/STP] Group new idx: %d, old idx: %d, act: %d\n"
    MSG_1115_MCC_H2CSTOPMCCHDL_1,                                    //"[MCC][stop]prev_groups: %d\n"
    MSG_1115_MCC_H2CSTOPMCCHDL_2,                                    //"[MCC][stop]stop group %d fail\n"
    MSG_1115_MCC_H2CSTOPMCCHDL_3,                                    //"[MCC][stop]group %d stop!\n"
    MSG_1115_MCC_H2CDELMCCGROUPHDL_1,                                //"[MCC][Del] prev_groups: %d\n"
    MSG_1115_MCC_H2CDELMCCGROUPHDL_2,                                //"[MCC][del]del group %d fail\n"
    MSG_1115_MCC_H2CDELMCCGROUPHDL_3,                                //"[MCC][del]group %d del!\n"
    MSG_1115_MCC_H2CMCCREQTSFHDL_1,                                //"[MCC] macid %d is not in role table\n"
    MSG_1115_DEBUGINFO_1,                                          //"ISR Name\tCount\t\tExec Time(historical high)\n"
    MSG_1115_DEBUGINFO_2,                                          //"------------------------------------------------\n"
    MSG_1115_DEBUGINFO_3,                                          //"\t%d\t\t%d_%d\n"
    MSG_1115_DEBUGINFO_4,                                          //"\t\t%d\t\t%d_%d\n"
    MSG_1115_DEBUGINFO_5,                                          //"[Error] ISRInfo len = %d!\n"
    MSG_1115_PROFILING_1,                                          //"func_name %s , "
    MSG_1115_PROFILING_2,                                          //"line %d , cycle %d , offset = %d\n"
    MSG_1115_WLANDUMP_0,                                                  //"Tx ok packet cnt: %d\n Tx fail packet cnt: %d\n Txcmd success cnt: %d\n Txcmd abort (MU-RTS/RTS fail) cnt: %d\n Txcmd abort (over SP) cnt: %d\n"
    MSG_1115_WLANDUMP_1,                                                  //"Txcmd sounding abort cnt: %d\n Txcmd abort (pri user fail) cnt: %d\n Txcmd abort ( cca or medium busy)  cnt: %d\n Txcmd RU/MU2SU cnt: %d\n"
    MSG_1115_WLANDUMP_2,                                                  //"chkcmd_sts cnt: %d %d %d %d %d %d %d\n"
    MSG_1115_WLANDUMP_3,                                                  //"TBD"
    MSG_1115_WLANDUMP_4,                                                  //"DL Txcmd in last TXOP cnt: %d\n UL Txcmd in last TXOP cnt: %d\n Empty DL SS2F report cnt: %d\n Empty UL SS2F report cnt: %d\n DL TxcmdQ empty cnt: %d\n"
    MSG_1115_WLANDUMP_5,                                                  //"Issue DL SU Txcmd cnt: %d\n Issue DL MU Txcmd cnt: %d\n Issue DL RU Txcmd cnt: %d\n Issue UL Txcmd cnt: %d\n f2p_Triggerpkt_cnt=%d\n"
    MSG_1115_WLANDUMP_6,                                                  //"Decision MU2SU cnt: %d\n Decision RU2SU cnt: %d\n DLDecision Result record: %x\n Decision SU_FORCESU cnt: %d\n Decision MU_FORCEMU cnt: %d\n"
    MSG_1115_WLANDUMP_7,                                                  //"Decision SU_FORCEMU_FAIL cnt: %d\n Decision SU_FORCERU_FAIL cnt: %d\n Decision SU_FORCERU_RUARST_RU2SU cnt: %d\n Decision SU_NOT4_USER cnt: %d\n Decision RU_FORCERU_RUSRST_FIXTBL cnt: %d\n"
    MSG_1115_WLANDUMP_8,                                                  //"Decision RU_FORCERU cnt: %d\n Decision SU_WDINFO_USERATE cnt: %d\n Decision SU_PRINULLWD cnt: %d\n ecision MU_BYPASS_MUTPCOMPARE cnt: %d\n Decision SU_MUTXTIME_PASS_MU_NOTSUPPORT cnt: %d\n"
    MSG_1115_WLANDUMP_9,                                                  //"Decision SU_MUTXTIME_FAIL_RU_NOTSUPPORT cnt: %d\n Decision SU_RUARST_RU2SU cnt: %d\n Decision RU_RUARST_FIXTBL cnt: %d\n Decision MU_TPCOMPARE_RST cnt: %d\n Decision RU_TPCOMPARE_RST cnt: %d\n Decision SU_TPCOMPARE_RST cnt: %d\n"
    MSG_1115_WLANDUMP_10,                                                  //"fw txcmdQ[0] cmd num: %d, fw txcmdQ[1] cmd num: %d,fw txcmdQ[2] cmd num: %d,fw txcmdQ[3] cmd num: %d,fw txcmdQ[4] cmd num: %d\n"
    MSG_1115_WLANDUMP_11,                                                  //"fw txcmdQ[5] cmd num: %d, fw txcmdQ[6] cmd num: %d,fw txcmdQ[7] cmd num: %d,fw txcmdQ[8] cmd num: %d,fw txcmdQ[9] cmd num: %d, fw txcmdQ[10] cmd num: %d\n"
    MSG_1115_WLANDUMP_12,                                                  //TBD
    MSG_1115_WLANDUMP_13,                                                  //"mbid0~7: %d %d %d %d %d %d %d %d\n"
    MSG_1115_WLANDUMP_14,                                                  //"macid    %d info:\n isHESTA =%d\n AID12 =%d\n DL_BW =%d\n DL_T_PE =%d\n"
    MSG_1115_WLANDUMP_15,                                                  //"TF_MAC_Padding =%d\n force tx su =%d\n force tx mu =%d\n fw force mu2su TH = %d\n force tx ru =%d\n"
    MSG_1115_WLANDUMP_16,                                                  //"txok_pkt =%d\n txfail pkt cnt: %d\n retry_cnt =%d\n mbssid_idx =%d\n ulgroup_bitmap =%d\n null_wd_cnt =%d\n"
    MSG_1115_WLANDUMP_17,                                                  //"ul_sw_grp_bitmap =%d\n AMPDU_max_txtime =%d\n mu_doppler_ctrl =%d\n mu_gi_ltf =%d\n mu decision txtime_bypass =%d\n mu decision mutp_bypass =%d\n"
    MSG_1115_WLANDUMP_18,                                                  //"mu_maxinitrate = %x\n mu_maxfinalrate = %x\n mu_mininitrate = %x\n mu_minfinalrate = %x\n mu primary cnt = %d\n"
    MSG_1115_WLANDUMP_19,                                                  //" PwrBit =%d\n TP =%d Mbps\n Max Txlen = %x (unit23 byte)\n Min Txlen = %x (unit23 byte)\n Last Txlen = %x (unit23 byte)\n Last BSRlen = %x (unit256 byte) AC=%d\n"
    MSG_1115_WLANDUMP_20,                                                  //"mu sta %d info\n mu sta macid= %d\n"
    MSG_1115_WLANDUMP_21,                                                  //"mu sta rate array(8bit) 0-4: %x %x %x %x %x"
    MSG_1115_WLANDUMP_22,                                                  //"mu sta rate array(8bit) 5-9: %x %x %x %x %x"
    MSG_1115_WLANDUMP_23,                                                  //"su ok pkt cnt = %d\n su fail pkt cnt = %d\n su_norsp_pktcnt = %d\n SU TOTALPKTNUM 1~16/17~32/33~64/>65 : %d %d %d %d, OK=0: %d\n SU TXCNT 1/<6/<16/>=16 : %d %d %d %d\n"
    MSG_1115_WLANDUMP_24,                                                  //"mu ok pkt cnt = %d\n mu fail pkt cnt = %d\n mu_norsp_pktcnt = %d\n mu2su ok pkt cnt = %d\n mu2su fail pkt cnt = %d\n"
    MSG_1115_WLANDUMP_25,                                                  //"ru ok pkt cnt = %d\n ru fail pkt cnt = %d\n"
    MSG_1115_WLANDUMP_26,                                                  //"MU TOTALPKTNUM  1~16/17~32/33~64/>65 :  %d %d %d %d, OK=0: %d\n MU DIFF <4/<8/<12/>=12 : %d %d %d %d\n"
    MSG_1115_WLANDUMP_27,                                                  //"MU TXCNT 1/<6/<16/>=16: %d %d %d %d\n
    MSG_1115_WLANDUMP_28,                                                  //"pktmaxtxcnt(su base) [0]= %d [1]= %d [2]= %d \n pktmaxtxcnt(mu base) [0]= %d [1]= %d [2]= %d \n pktmaxtxcnt(mu2nd base) [0]= %d [1]= %d [2]= %d \n"
    MSG_1115_WLANDUMP_30,                                                  //"F2PTXCMDRPT cnt= %d, SS2FWRPT     cnt =%d, TXRPT cnt =%d, PLDRLSRPT cnt = %d\n"
    MSG_1115_WLANDUMP_31,                                                  //"SU DIFF <4/<8/<12/>=12 : %d %d %d %d\n pkt_max_queue_time = %x, pkt_min_queue_time=%x\n"
    MSG_1115_WLANDUMP_32,                                                  //"TWT %d info:\n Txcmd overSP= %d\n Txcmd pri user fail= %d\n DL cmdCnt inSP= %d\n UL cmdCnt inSP= %d\n"
    MSG_1115_WLANDUMP_33,                                                  //"DL cmdCnt all= %d\n UL cmdCnt all= %d\n UL fixmode = %x\n cur cmd num = %x\n"
    MSG_1115_WLANDUMP_34,                                                  //"start_d= %d\n start_t= %d\n endearly_d= %d\n endearly_t= %d\n end_d= %d\n"
    MSG_1115_WLANDUMP_35,                                                  //"end_t= %d\n timer_qrydl= %d\n timer_qryul= %d\n start_qrydl= %d\n total_qryul=%d\n"
    MSG_1115_WLANDUMP_36,                                                  //"firstTF_fail = %d,%d\n"
    MSG_1115_WLANDUMP_37,                                                  //"twt_decision_brk = %d, %d, %d, %d, %d, %d, %d, %d\n"
    MSG_1115_WLANDUMP_38,                                                  //"twt_decision_rst= %d, %d, %d\n"
    MSG_1115_WLANDUMP_39,                                                  //"twt_ACdecision_rst= %d, %d, %d, %d\n"
    MSG_1115_WLANDUMP_40,                                                  //"twt_validdlss2f_cnt= %d, twt_emptydlss2f_cnt= %d, twt_validulss2f_cnt= %d, twt_emptyulss2f_cnt= %d, twt_dlss2f_fromquery= %d, twt_dlss2f_fromtxcmd=%d, twt_ulss2f_fromquery= %d, twt_ulss2f_fromtxcmd=%d\n"
    MSG_1115_WLANDUMP_41,                                                  //"TWT member: %d %d %d %d %d\n"
    MSG_1115_WLANDUMP_42,                                                  //"twt_dlss2f_qrycnt[0]=%d,twt_dlss2f_qrycnt[1]=%d,twt_dlss2f_qrycnt[2]=%d,twt_dlss2f_qrycnt[3]=%d\n"
    MSG_1115_WLANDUMP_43,                                                  //"reform_fail_rst[0]=%d, reform_fail_rst[1]=%d, reform_fail_rst[2]=%d, reform_fail_rst[3]=%d, reform_fail_rst[4]=%d\n"
    MSG_1115_WLANDUMP_44,                                                //"MACID WD count BE:%d BK:%d VI:%d VO:%d\n"
    MSG_1115_WLANDUMP_45,                                                //"PPS F2PCMD_PPS:%d/s TXRPT_PPS:%d/s TXPKT_PPS:%d/s SS2F_0_PPS:%d/s SS2F_1_PPS:%d/s SS2F_2_PPS:%d/s"
    MSG_1115_ROLE_1,                                                //"B%dP%d RXBCNOK\n"
    MSG_1115_ROLE_2,                                                //"B%dP%d BCNNOHIT\n"
    MSG_1115_ROLE_3,                                                //"Role idx search fail\n
    MSG_1115_ROLE_4,                                                //"=>CreateRole\n"
    MSG_1115_ROLE_5,                                                //"[FAIL] Role info alloc fail!\n"
    MSG_1115_ROLE_6,                                                //"[FAIL] Role info - PPSDbgParm alloc fail!\n"
    MSG_1115_ROLE_7,                                                //"[FAIL] Role info - PTWTParam alloc fail!\n"
    MSG_1115_ROLE_8,                                                //"[CreateRole] ActRole=%d, LinkRole=%d.\n
    MSG_1115_ROLE_9,                                                //"[CreateRole] band=%d, port=%d, macid=%d.\n"
    MSG_1115_ROLE_10,                                                //"=>DelRole\n"
    MSG_1115_ROLE_11,                                                //"[Warn] ROLE_NOT_EXIST for DelRole!\n"
    MSG_1115_ROLE_12,                                                //"[DelRole] ActRole=%d!role_idx=%d\n"
    MSG_1115_ROLE_13,                                                //"Role idx search by macid fail\n"
    MSG_1115_ROLE_14,                                                //"[WARN] Role exist for macid=0x%x! role_idx=0x%x\n"
    MSG_1115_ROLE_15,                                                //"[FAIL] Create Role idx > max_number!\n"
    MSG_1115_ROLE_16,                                                //"[FAIL] Create Role fail!\n"
    MSG_1115_ROLE_17,                                                //"[Warn] search role fail for JoinInfo!\n"
    MSG_1115_ROLE_18,                                                //"[FAIL] JoinInfo Role idx > max_number!\n"
    MSG_1115_ROLE_19,                                                //"[WARN] Role exist for macid=0x%x! role_idx=0x%x\n"
    MSG_1115_ROLE_20,                                                //"[Warn] search role fail for DelRole!\n"
    MSG_1115_ROLE_21,                                                //"[FAIL] Del Role idx > max_number!\n"
    MSG_1115_PMF_00,                                                    //"start saquery timer fail\n"
    MSG_1115_PMF_01,                                                    //"start saquery timer\n"
    MSG_1115_PMF_02,                                                    //"creat saquery timer fail\n"
    MSG_1115_PMF_03,                                                    //"saquery timer is lanched alread\n"
    MSG_1115_PMF_04,                                                    //"SA Query timer deleted!\n"
    MSG_1115_PMF_05,                                                    //"Deauth content\n"
    MSG_1115_PMF_06,                                                    //"packet_len_no_fcs error\n"
    MSG_1115_PMF_07,                                                    //"ICV Error ok\n"
    MSG_1115_PMF_08,                                                    //"encrypted deauth frame, SEC_TYPE: 0x%x) \n"
    MSG_1115_PMF_09,                                                    //"not Encrypted Deauth/Disassoc\n"
    MSG_1115_PMF_10,                                                    //"deauth_reason = %x %x\n"
    MSG_1115_PMF_11,                                                    //"tx_sa_query_result = 0x%x\n"
    MSG_1115_PMF_12,                                                    //"issue saquery req fail\n"
    MSG_1115_PMF_13,                                                    //"ignore the deauth frame\n"
    MSG_1115_PMF_14,                                                    //"ICV Error\n"
    MSG_1115_PMF_15,                                                    //"bip_result=0x%x\n"
    MSG_1115_PMF_16,                                                    //"\npacket_len_no_fcs error\n"
    MSG_1115_PMF_17,                                                    //"\nOn SA Query Req! (len=0x%x)\n"
    MSG_1115_PMF_18,                                                    //"issue saquery rsp fail\n"
    MSG_1115_PMF_19,                                                    //"\nOn SA Query Resp!(len=0x%x)\n"
    MSG_1115_PMF_20,                                                    //"issue_sa_query_timeout_hdl!\n"
    MSG_1115_PMF_21,                                                    //"Deauth wake up!\n"
    MSG_1115_PMF_22,                                                    //"can't get offload PKT for saquery\n"
    MSG_1115_PMF_23,                                                    //"can't allocate sendpkt_buff \n"
    MSG_1115_PMF_24,                                                    //"FW IPN > pkt IPN\n"
    MSG_1115_PMF_25,                                                    //"FW IPN < pkt IPN\n"
    MSG_1115_PMF_26,                                                    //"FW IPN == pkt IPN\n"
    MSG_1115_PMF_27,                                                    //"IPSecAESECBInit false\n"
    MSG_1115_PMF_28,                                                    //"IPSecAESECBEncrypt false\n"
    MSG_1115_PMF_30,                                                    //"key_len = %d, false\n"
    MSG_1115_PMF_31,                                                    //"iv_len = %d, false\n"
    MSG_1115_PMF_32,                                                    //"IPSecInitWithISRDisable false\n"
    MSG_1115_PMF_40,                                                    //"MIC check fail\n"
    MSG_1115_PMF_41,                                                    //"\n: aes_gmac fail!\n"
    MSG_1115_PMF_42,                                                    //"\n: _bip_gcmp_protect(128) fail!\n"
    MSG_1115_PMF_43,                                                    //"\n: _bip_gcmp_protect(256) fail!\n"
    MSG_1115_PMF_44,                                                    //"\n: unsupport dot11wCipher !\n"
    MSG_1115_PMF_45,                                                    //"not a management frame\n"
    MSG_1115_PMF_46,                                                    //"is a beacon\n"
    MSG_1115_PMF_47,                                                    //"not a broadcast frame\n"
    MSG_1115_PMF_48,                                                    //"packet too small\n"
    MSG_1115_PMF_49,                                                    //"elemnt_id != 0x4c\n"
    MSG_1115_PMF_50,                                                    //"is_bip_enc_frameComm return TRUE\n"
    MSG_1115_PMF_51,                                                    //"\nbip_verifyComm: PKT (len=0x%x)\n"
    MSG_1115_PMF_52,                                                    //"BSSID not match\n"
    MSG_1115_PMF_53,                                                    //"ori_len = 0x%x\n"
    MSG_1115_PMF_54,                                                    //"SW BIP DEC FAIL\n"
    MSG_1115_PMF_55,                                                    //"NOT encrypted\n"
    MSG_1115_PMF_56,                                                    //"IPN verify Fail\n"
    MSG_1115_PMF_57,                                                    //"bip_verifyComm return TRUE\n"
    MSG_1115_PMF_58,                                                    //"protection bit is not 1\n"
    MSG_1115_PMF_59,                                                    //"not a unicast frame\n"
    MSG_1115_PMF_60,                                                    //"PairwiseEncAlg not GCMP\n"
    MSG_1115_PMF_61,                                                    //"aes_gcm_ad fail\n"
    MSG_1115_PMF_62,                                                    //"aes_gcm_ae fail\n"
    MSG_1115_WLANDUMP_46,                                                  //"TF NUM: %d\n""
    MSG_1115_WLANDUMP_47,                                                  //"BSRP NUM: %d\n"
    MSG_1115_WLANDUMP_48,                                                  //"basictf NUM: %d\n"
    MSG_1115_WLANDUMP_49,                                                  //"MAX count: %d\n"
    MSG_1115_WLANDUMP_50,                                                  //"trigger %d user num: %d\n"
    MSG_1115_WLANDUMP_51,                                                  //"ru2su: %d\n"
    MSG_1115_WLANDUMP_52,                                                  //"mac not recv any tb: %d (%d percent)\n"
    MSG_1115_WLANDUMP_53,                                                  //"tb freerun fail: %d\n"
    MSG_1115_WLANDUMP_54,                                                  //"cca break count: %d\n"
    MSG_1115_WLANDUMP_55,                                                  //"ampdu miss count: %d\n"
    MSG_1115_WLANDUMP_56,                                                  //"csrequired: auto\n"
    MSG_1115_WLANDUMP_57,                                                  //"csrequired: %d\n"
    MSG_1115_WLANDUMP_58,                                                  //"SS2FWRPT %d SU cnt: %d\n"
    MSG_1115_WLANDUMP_59,                                                  //"SS2FWRPT %d RU cnt: %d\n"
    MSG_1115_WLANDUMP_60,                                                  //"SS2FWRPT empty cnt: %d\n"
    MSG_1115_WLANDUMP_61,                                                  //"SS2FWRPT reason %d:%d\n"
    MSG_1115_WLANDUMP_62,                                                  //"------------------------------\n"
    MSG_1115_WLANDUMP_63,                                                  //"U%d, MACID%d, \n"
    MSG_1115_WLANDUMP_64,                                                  //"recv_num: %d (%d percent)\n"
    MSG_1115_WLANDUMP_65,                                                  //"tbok_num: %d (%d percent)\n"
    MSG_1115_WLANDUMP_66,                                                  //"fcs_eror: %d (%d percent)\n"
    MSG_1115_WLANDUMP_67,                                                  //"cur tb_rssi %d.%d dbm\n"
    MSG_1115_WLANDUMP_68,                                                  //"min tb_rssi %d.%d dbm\n"
    MSG_1115_WLANDUMP_69,                                                  //"max tb_rssi %d.%d dbm\n"
    MSG_1115_WLANDUMP_70,                                                  //"avg tb_rssi %d.%d dbm\n"
    MSG_1115_WLANDUMP_71,                                                  //"rech minpow %d (%d percent)\n"
    MSG_1115_WLANDUMP_72,                                                  //"rech maxpow %d (%d percent)\n"
    MSG_1115_WLANDUMP_73,                                                  //"avg uph %d dbm\n"
    MSG_1115_RXFLOW_1,                                                   //"can't allocate wlan pktbuf\n"
    MSG_1115_RXFLOW_2,                                                   //"DD=%x\n"
    MSG_1115_RXFLOW_3,                                                   //"A=%x\n"
    MSG_1115_RXFLOW_4,                                                   //"B=%x\n"
    MSG_1115_RXFWD_1,                                                    //"Unsupported index!\n"
    MSG_1115_WLAN_1,                                                     //"SS Query Report HW stuck!!\n"
    MSG_1115_SECCAM_1,                                                   //"Search key, mac_id : %d, key_id : %d, key_type : %d , fail\n"
    MSG_1115_SECCAM_2,                                                   //"Search key success\nMac_id : %d, key_id : %d, key_type : %d, key cam index : %d\n"
    MSG_1115_SECCAM_3,                                                   //"Wowlan rekey %d, %d, %d\n"
    MSG_1115_SECCAM_4,                                                   //"check addr key index full\n"
    MSG_1115_SECCAM_5,                                                   //"Free cam index: %d\n"
    MSG_1115_SECCAM_6,                                                   //"insertKeyAddrCam ret : %d\n"
    MSG_1115_RPTHDL_1,                                                      //"pldrlsrpt len %d not align\n"
    MSG_1115_RPTHDL_2,                                                      //"RlsRptHDLRAM1115,rpt_num=%x,len=%x\n"
    MSG_1115_RPTHDL_3,                                                      //"ERR: TxCmdRptHDL get NULL txinfo node,rpt->QSEL=%x,  (rpt->FW_DEFINE & MAX_TXCMD_SEQ_MSK)=%x\n"
    MSG_1115_RPTHDL_4,                                                      //"ERR: TxRptHDL get NULL txinfo node,rpt->QSEL=%x,(rpt->FW_DEFINE & MAX_TXCMD_SEQ_MSK)=%x\n"
    MSG_1115_RPTHDL_5,                                                      //"ERR: TfRptHDL get NULL txinfo node\n"
    MSG_1115_RPTHDL_6,                                                      //"SS2FInfoDeQ1115\n"
    MSG_1115_RPTHDL_7,                                                      //"F2PTXCMDRPT HDL\n"
    MSG_1115_RPTHDL_8,                                                      //"SS2FWRPT HDL\n"
    MSG_1115_RPTHDL_9,                                                      //"TFRPT HDL\n"
    MSG_1115_RPTHDL_10,                                                  //"TXBCNRPT HDL\n"
    MSG_1115_RPTHDL_11,                                                  //"CCXRPT HDL\n"
    MSG_1115_RPTHDL_12,                                                  //"TXRPT HDL\n"
    MSG_1115_RPTHDL_13,                                                  //"PLDRLSRPT HDL\n"
    MSG_1115_ERRHDL_1,                                                      //"[ERR]DLE Timeout(idx = %d)\n"
    MSG_1115_ERRHDL_2,                                                      //"[ERR]AXIDMA is not idle!\n"
    MSG_1115_ERRHDL_3,                                                      //"[ERR]STA scheduler init\n"
    MSG_1115_ERRHDL_4,                                                      //"[ERR]WDE cfg ready\n"
    MSG_1115_ERRHDL_5,                                                      //"[ERR]PLE cfg ready\n"
    MSG_1115_ERRHDL_6,                                                      //"=>DmaTopStuck:FA sts: %d, data: %d!\n"
    MSG_1115_ERRHDL_7,                                                      //"=>DmaTopStuck:FA!\n"
    MSG_1115_ERRHDL_8,                                                      //"=>DmaTopStuck:know!\n"
    MSG_1115_ERRHDL_9,                                                      //"=>RecoveryCMAC!\n"
    MSG_1115_ERRHDL_10,                                                  //"[ERR]BBRPT CHIF\n"
    MSG_1115_ERRHDL_11,                                                  //"[ERR]Check CMAC_idle\n"
    MSG_1115_ERRHDL_12,                                                  //"[ERR]PTCL tx\n"
    MSG_1115_ERRHDL_13,                                                  //"[ERR]L0 promote event %x\n"
    MSG_1115_ERRHDL_14,                                                  //"[ERR][C2H]Previous: %x; Current: %x\n"
    MSG_1115_ERRHDL_15,                                                  //"ErrHDL in!\n"
    MSG_1115_ERRHDL_16,                                                  //"ErrHDL out!\n"
    MSG_1115_ERRHDL_17,                                                  //"DMAC error: %x\n"
    MSG_1115_ERRHDL_18,                                                  //"CMAC0 error: %x\n"
    MSG_1115_ERRHDL_19,                                                  //"CMAC1 error: %x\n"
    MSG_1115_ERRHDL_20,                                                  //"notify: %x\n"
    MSG_1115_ERRHDL_21,                                                  //"--->\n err=%x\n"
    MSG_1115_ERRHDL_22,                                                  //"R_AX_SER_DBG_INFO =%x\n"
    MSG_1115_ERRHDL_23,                                                  //"R_AX_DMAC_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_24,                                                  //"R_AX_WDE_ERR_FLAG_CFG_NUM1 =%x\n"
    MSG_1115_ERRHDL_25,                                                  //"R_AX_PLE_ERR_FLAG_CFG_NUM1 =%x\n"
    MSG_1115_ERRHDL_26,                                                  //"R_AX_WDRLS_ERR_IMR =%x "
    MSG_1115_ERRHDL_27,                                                  //"R_AX_WDRLS_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_28,                                                  //"R_AX_RPQ_RXBD_IDX =%x\n"
    MSG_1115_ERRHDL_29,                                                  //"R_AX_SEC_DEBUG =%x\n"
    MSG_1115_ERRHDL_30,                                                  //"R_AX_MPDU_TX_ERR_IMR =%x "
    MSG_1115_ERRHDL_31,                                                  //"R_AX_MPDU_TX_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_32,                                                  //"R_AX_MPDU_RX_ERR_IMR =%x "
    MSG_1115_ERRHDL_33,                                                  //"R_AX_MPDU_RX_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_34,                                                  //"R_AX_STA_SCHEDULER_ERR_IMR =%x "
    MSG_1115_ERRHDL_35,                                                  //"R_AX_STA_SCHEDULER_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_36,                                                  //"R_AX_WDE_ERR_IMR=%x "
    MSG_1115_ERRHDL_37,                                                  //"R_AX_WDE_ERR_ISR=%x\n"
    MSG_1115_ERRHDL_38,                                                  //"R_AX_PLE_ERR_IMR=%x "
    MSG_1115_ERRHDL_39,                                                  //"R_AX_PLE_ERR_FLAG_ISR=%x\n"
    MSG_1115_ERRHDL_40,                                                  //"R_AX_TXPKTCTL_ERR_IMR_ISR=%x\n"
    MSG_1115_ERRHDL_41,                                                  //"R_AX_TXPKTCTL_ERR_IMR_ISR_B1=%x\n"
    MSG_1115_ERRHDL_42,                                                  //"R_AX_PKTIN_ERR_IMR =%x "
    MSG_1115_ERRHDL_43,                                                  //"R_AX_PKTIN_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_44,                                                  //"R_AX_PKTIN_ERR_IMR =%x "
    MSG_1115_ERRHDL_45,                                                  //"R_AX_PKTIN_ERR_ISR =%x\n"
    MSG_1115_ERRHDL_46,                                                  //"R_AX_HOST_DISPATCHER_ERR_IMR=%x "
    MSG_1115_ERRHDL_47,                                                  //"R_AX_HOST_DISPATCHER_ERR_ISR=%x\n"
    MSG_1115_ERRHDL_48,                                                  //"R_AX_CPU_DISPATCHER_ERR_IMR=%x "
    MSG_1115_ERRHDL_49,                                                  //"R_AX_CPU_DISPATCHER_ERR_ISR=%x\n"
    MSG_1115_ERRHDL_50,                                                  //"R_AX_CPUIO_ERR_IMR=%x "
    MSG_1115_ERRHDL_51,                                                  //"R_AX_CPUIO_ERR_ISR=%x\n"
    MSG_1115_ERRHDL_52,                                                  //"R_AX_BBRPT_COM_ERR_IMR_ISR=%x\n"
    MSG_1115_ERRHDL_53,                                                  //"0xC164=%x\n"
    MSG_1115_ERRHDL_54,                                                  //"R_AX_SCHEDULE_ERR_IMR=%x "
    MSG_1115_ERRHDL_55,                                                  //"R_AX_SCHEDULE_ERR_ISR=%x\n"
    MSG_1115_ERRHDL_56,                                                  //"R_AX_PTCL_IMR0=%x "
    MSG_1115_ERRHDL_57,                                                  //"R_AX_PTCL_ISR0=%x\n"
    MSG_1115_ERRHDL_58,                                                  //"R_AX_DLE_CTRL=%x\n"
    MSG_1115_ERRHDL_59,                                                  //"R_AX_PHYINFO_ERR_IMR=%x\n"
    MSG_1115_ERRHDL_60,                                                  //"R_AX_TXPWR_IMR= N/A "
    MSG_1115_ERRHDL_61,                                                  //"R_AX_TXPWR_ISR= N/A\n"
    MSG_1115_ERRHDL_62,                                                  //"R_AX_DBGSEL_TRXPTCL=%x "
    MSG_1115_ERRHDL_63,                                                  //"R_AX_PHYINFO_ERR_IMR=%x\n"
    MSG_1115_ERRHDL_64,                                                  //"R_AX_TMAC_ERR_IMR_ISR=%x "
    MSG_1115_ERRHDL_65,                                                  //"R_AX_DBGSEL_TRXPTCL=%x\n"
    MSG_1115_ERRHDL_66,                                                  //"<---\n"
    MSG_1115_ERRHDL_67,                                                  //"UL_Mode_add_link\n"
    MSG_1115_ERRHDL_68,                                                  //"ul macid:%d exist already\n"
    MSG_1115_ERRHDL_69,                                                  //"UL_Mode_del_link\n"
    MSG_1115_ERRHDL_70,                                                  //"ul macid %d del already\n"
    MSG_1115_PSTIMER_00,                                                 //"handle task:%x\n"
    MSG_1115_PSTIMER_01,                                                 //"handle tsf: %x\n"
    MSG_1115_PSTIMER_02,                                                 //"tsf in list: %x\n"
    MSG_1115_AXIDMA_00,                                                  //"Error in AXIDMA_BufferInfoInit\n"
    MSG_1115_AXIDMA_01,                                                  //"Error in AXIDMA_RX_BufferInit\n"
    MSG_1115_AXIDMA_02,                                                  //"[ERR] AXIDMA is not enable\n"
    MSG_1115_AXIDMA_03,                                                  //"[AXIDMA RX Init]Allocate H2C buffer fail\n"
    MSG_1115_AXIDMA_04,                                                  //"[AXIDMA RX Init]Allocate PKT buffer fail\n"
    MSG_1115_AXIDMA_05,                                                  //"[AXIDMA RX Init]Allocate RPT buffer fail\n"
    MSG_1115_AXIDMA_06,                                                  //"The PKT type error\n"
    MSG_1115_AXIDMA_07,                                                  //"AXIDMA_FreeContentBuffer free NULL\n"
    MSG_1115_AXIDMA_08,                                                  //"The PKT type error\n"
    MSG_1115_AXIDMA_09,                                                  //"Please Check the input address is include rxbd info\n"
    MSG_1115_AXIDMA_10,                                                  //"AXIDMA_FreeContentBuffer out of bound\n"
    MSG_1115_AXIDMA_11,                                                  //"AXIDMA_Buffer_Channel Error\n"
    MSG_1115_AXIDMA_12,                                                  //"invalid BD\n"
    MSG_1115_AXIDMA_13,                                                  //"[AXIDMA RX]error packet type\n"
    MSG_1115_AXIDMA_14,                                                  //"No buffer\n"
    MSG_1115_AXIDMA_15,                                                  //"Error in AXIDMA_RX_ISR\n"
    MSG_1115_AXIDMA_16,                                                  //"AXIDMA RX[CH%d] tag inconsistent!hw tag =%x, sw tag = %x\n"
    MSG_1115_AXIDMA_17,                                                  //"NOT support multi-TXBD for single TX yet\n"
    MSG_1115_AXIDMA_18,                                                  //"CH%d has no pld info\n"
    MSG_1115_AXIDMA_19,                                                  //"No tx_para_p input\n"
    MSG_1115_AXIDMA_20,                                                  //"AXIDMA TX setup buff fail %d\n"
    MSG_1115_MAIN_00,                                                    //"SW Queue reCreate\n"
    MSG_1115_MAIN_01,                                                    //"Enter AXIDMA_init... \n"
    MSG_1115_MAIN_02,                                                    //"WDT_timer start... \n"
    MSG_1115_MAIN_03,                                                    //"InitHWPostDLRAM done\n"
    MSG_1115_MAIN_04,                                                    //"InitFWFuncPostDL RAM done\n"
    MSG_1115_MAIN_05,                                                    //"MAC per STAInfo %d bytes\n"
    MSG_1115_MAIN_06,                                                    //"BB per STAInfo %d bytes\n"
    MSG_1115_MAIN_07,                                                    //"InitWLANFuncRAM done\n"
    MSG_1115_MAIN_08,                                                    //"Enter test id (0~7): "
    MSG_1115_MAIN_09,                                                    //"%s\n"
    MSG_1115_MAIN_10,                                                    //"Thread Metric: %d\n"
    MSG_1115_MAIN_11,                                                    //"Test duration: %d seconds\n"
    MSG_1115_MAIN_14,                                                    //"WDT_timer start fail \n"
    MSG_1115_MAIN_15,                                                    //" SysMib.PInternal->PDebugInfo->DbgLvl =%x\n"
    MSG_1115_MAIN_16,                                                    //"Enter flash FW loader\n
    MSG_1115_MAIN_17,                                                    //"Wrong CMAC band!!!\n"
    MSG_1115_IRAMENTRY_00,                                               //"ROM function ptr length %x,RAM function ptr length %x\n"
    MSG_1115_IRAMENTRY_01,                                               //"Function ptr length not equal!!\n"
    MSG_1115_IRAMENTRY_02,                                               //"Initializing RAM bss...\n"
    MSG_1115_IRAMENTRY_03,                                               //"Load FW RAM code OK\n"
    MSG_1115_BACKTRACE_00,                                               //"Heap space is not enough for backtrace.......\n"
    MSG_1115_BACKTRACE_01,                                               //"Start stack backtracing for pc:%x, sp:%x, ra:%x\n"
    MSG_1115_BACKTRACE_02,                                               //"Can't backtrace stack for rv32c neither, end processing. sp:%x, pc:%x\n"
    MSG_1115_BACKTRACE_03,                                               //"[frame #%d] sp:%x, pc:%x, stack_size:%d, ra:%x\n"
    MSG_1115_BACKTRACE_04,                                               //"Backtrace memory is full, DumpMem_idx:%x\n"
    MSG_1115_BACKTRACE_05,                                               //"EPC: %x, Cause: %x, BADVADDR: %x, Status: %x\n"
    MSG_1115_BACKTRACE_06,                                               //"t6: %x, t5: %x, t4: %x, t3: %x\n"
    MSG_1115_BACKTRACE_07,                                               //"s11: %x, s10: %x, s9: %x, s8: %x\n"
    MSG_1115_BACKTRACE_08,                                               //"s7: %x, s6: %x, s5: %x, s4: %x\n"
    MSG_1115_BACKTRACE_09,                                               //"s3: %x, s2: %x, a7: %x, a6: %x\n"
    MSG_1115_BACKTRACE_10,                                               //"a5: %x, a4: %x, a3: %x, a2: %x\n"
    MSG_1115_BACKTRACE_11,                                               //"a1: %x, a0: %x, s1: %x, s0: %x\n"
    MSG_1115_BACKTRACE_12,                                               //"t2: %x, t1: %x, t0: %x, tp: %x\n"
    MSG_1115_BACKTRACE_13,                                               //"gp: %x, sp: %x, ra: %x\n"
    MSG_1115_BACKTRACE_14,                                               //"not send c2hHalt\n"
    MSG_1115_BACKTRACE_15,                                               //"no loop\n"
    MSG_1115_BACKTRACE_16,                                               //"Something wrong when allocating backtrace memory\n"
    MSG_1115_BACKTRACE_17,                                               //"Backtrace memory is full!!\n"
    MSG_1115_BACKTRACE_18,                                               //"Init Backtrace Memory failed\n"
    MSG_1115_PORT_00,                                                    //"Assert at file: %s\n"
    MSG_1115_PORT_01,                                                    //"not send c2hHalt\n"
    MSG_1115_PORT_02,                                                    //"Assert at line: %d\n"
    MSG_1115_PORT_03,                                                    //"Watch dog timeout in critical section\n"
    MSG_1115_PORT_04,                                                    //"Watch dog remain: %d(us)\n"
    MSG_1115_PORT_05,                                                    //"Exec Time %x ~ %x: %d(us)\n"
    MSG_1115_RXI300_00,                                                  //"EPC Value: %x\n"
    MSG_1115_RXI300_01,                                                  //"Error id is inexistent(%x)!\n"
    MSG_1115_RXI300_02,                                                  //"Error code is inexistent(%x)!\n"
    MSG_1115_RXI300_03,                                                  //"RXI300_ERR_SRC_APB_DEF_SLV"
    MSG_1115_RXI300_04,                                                  //"RXI300_ERR_SRC_AXI_APB_SA"
    MSG_1115_RXI300_05,                                                  //"Error source is inexistent(%x)!\n"
    MSG_1115_RXI300_06,                                                  //"HaltC2H = %x, Error address = %x!\n"
    MSG_1115_RXI300_07,                                                  //"Clear interrupt fail!\n"
    MSG_1115_RXI300_08,                                                  //"RA/SP Value: %x, %x\n
	MSG_1115_WLANDUMP_74,												  //"txbrk reason cnt : [0]=%d, [1]=%d, [2]=%d, [3]=%d, [4]=%d, [5]=%d, [6]=%d, [7]=%d, [8]=%d, [9]=%d, [10]=%d, [11]=%d,\n"
	MSG_1115_WLANDUMP_75,												  //"wlan err flag bit = %x, total txbrk cnt =%d\n"
    MSG_1115_WOWLAN_1,											              //"H2C wowlan, fun: %x"
    MSG_1115_WOWLAN_2,											              //"H2C Keep Alive, Enable: %x\n"
    MSG_1115_WOWLAN_3,											              //"H2C disconn, Enable: %x\n"
    MSG_1115_WOWLAN_4,											              //"Wow stop AXIDMA failed\n"
    MSG_1115_WOWLAN_5,											              //"H2C wow global, Enable: %x\n"
    MSG_1115_WOWLAN_6,											              //"H2C wakeup ctrl, pattern match Enable: %x\n"
    MSG_1115_WOWLAN_7,											              //"H2C , nlo Enable: %x\n"
    MSG_1115_WOWLAN_8,											              //"H2C , wow cam: %x\n"
    MSG_1115_WOWLAN_9,											              //"\nAppendTkipMICComm\n"
    MSG_1115_WOWLAN_10,											      //"key[%d]=%bx\n"
    MSG_1115_WOWLAN_11,											      //"DA[%d]=%bx\n"
    MSG_1115_WOWLAN_12,											      //"SA[%d]=%bx\n"
    MSG_1115_WOWLAN_13,											      //"Priority[%d]=%bx\n"
    MSG_1115_WOWLAN_14,											      //"data[%d]=%bx\n"
    MSG_1115_WOWLAN_15,											      //"miccode[%d]=%bx\n"
    MSG_1115_WOWLAN_16,										              //"get 1st rx pktid fail\n"
    MSG_1115_WOWLAN_17,											      //"(%d, %d) Parsed Failed!\n"
    MSG_1115_WOWLAN_18,											      //"Magic Packet Parsed Done, reason_bits<%x>\n"
    MSG_1115_WOWLAN_19,											      //"H2C , arp ofld Enable: %x\n"
    MSG_1115_WOWLAN_20,											      //"Unexpected HCI type in togglewake\n"
    MSG_1115_PS_CHK_PLATFORM_ERR_1,                                     //"DMAC error: %x\n"
    MSG_1115_PS_CHK_PLATFORM_ERR_2,                                     //"CMAC%d error: %x\n"
    MSG_1115_PS_DDMA_BUFFER_SIZE_OVERFLOW,                              //"MAC%d DDMA buffer size (%x) is overflow!\n"
    MSG_1115_PS_HIOE_START_ADDR,                                        //"LPS HIOE start address = %x, size = %x\n"
    MSG_1115_PS_HIOE_END_ADDR,                                          //"LPS HIOE end address = %x\n"
    MSG_1115_PS_HIOE_INST_OVERFLOW,                                     //"LPS HIOE instruction is overflow! inst_size(%x).\n"
    MSG_1115_PS_HIOE_READ_PCIEMIO_FAIL,                                 //"[Err] ReadPCIEMIO Fail! reg = %x\n"
    MSG_1115_PS_HIOE_WRITE_PCIEMIO_FAIL,                                //"[Err] WritePCIEMIO Fail! reg = %x\n"
    MSG_1115_PS_HIOE_BACKUP_FAIL,                                       //"BKP fail st.(%x)\n"
    MSG_1115_PS_HIOE_RESTORE_FAIL,                                      //"RES fail st.(%x)\n"
    MSG_1115_PS_HIOE_INVALID_STATE,                                     //"Invalid st.(%x)\n"
    MSG_1115_PS_HIOE_BACKUP_TIMEOUT,                                    //"Bkp (%d) polling timeout!\n"
    MSG_1115_PS_HIOE_RESTORE_TIMEOUT,                                   //"Res polling timeout!\n"
    MSG_1115_PS_ENTER_32K,                                              //">C\n"
    MSG_1115_PS_LEAVE_32K,                                              //"<C\n"
    MSG_1115_PS_RESET_BD_POLLING_TIMEOUT,                               //"Reset BD polling timeout! val(%d)\n"
    MSG_1115_PS_BACKUP_MAC_FAIL,                                        //"BkpMAC (%d) start fail!!\n"
    MSG_1115_PS_BACKUP_MAC_TIMEOUT,                                     //"BkpMAC (%d) polling timeout! idx=%x!\n"
    MSG_1115_PS_RESTORE_MAC_FAIL,                                       //"RestoreMAC (%d) start fail!!\n"
    MSG_1115_PS_RESTORE_MAC_TIMEOUT,                                    //"RestoreMAC (%d) polling timeout! idx=%x!\n"
    MSG_1115_PS_TIMER_STOP_FAIL,                                        //"[32K] timer (%d) stop FAIL!\n"
    MSG_1115_PS_TIMER_START_FAIL,                                       //"[32K] timer (%d) start FAIL!\n"
    MSG_1115_PS_DISABLE_HCIDMA_FAIL,                                    //"Disable HCI TX DMA FAIL!\n"
    MSG_1115_PS_READ_PCIEMIO_FAIL,                                      //"[Err] ReadPCIEMIO Fail! reg = %x\n"
    MSG_1115_PS_WRITE_PCIEMIO_FAIL,                                     //"[Err] WritePCIEMIO Fail! reg = %x\n"
    MSG_1115_PS_32K_STATUS,                                             //"LPS Status: %x\n"
    MSG_1115_PS_32K_ERROR,                                              //"LPS Error: %x\n"
    MSG_1115_PS_32K_INFO,                                               //"LPS Info: %x\n"
    MSG_1115_PS_SLEEP_TIME,                                             //"[Sleep Time] Expect=%x, Complete=%x\n"
    MSG_1115_PS_TIMING_LOG_1,                                           //"[PST] ResPG Analysis(us): %d, MAC: %d, BB: %d, RF: %d\n"
    MSG_1115_PS_TIMING_LOG_2,                                           //"[PST] Res timer(us): %d us, MAC1st backup: %d, MAC everytime backup: %d, Enable WDE/PLE: %d\n"
    MSG_1115_PS_TIMING_LOG_3,                                           //"[PST] RFK(us): %d, DACK: %d, Radio: %d, RFC: %d\n"
    MSG_1115_PS_TIMING_LOG_4,                                           //"[PST] T2 ClkUp to OpenRF: %d us\n"
    MSG_1115_PS_TIMING_LOG_5,                                           //"[PST] ResDone = %x us, OpenRF = %x us, TBTT = %x us, RxBcn = %x us\n"
    MSG_1115_PS_TIMING_LOG_6,                                           //"[PST] OpenRF to TBTT = %d us, TBTT to RxBcn = %d us, RxBcn to ClsRF = %d us, ClsRF to 32k = %d us\n"
    MSG_1115_PS_TIMING_LOG_7,                                           //"[PST] ResDone = %x us, OpenRF = %x us, TBTT = %x us\n",
    MSG_1115_PS_TIMING_LOG_8,                                           //"[PST] ResDone to SetBcnTo = %d us, SetBcnTo to BcnTo = %d us, BcnTo to ClsRF = %d us, ClsRF to 32k = %d us\n"
    MSG_1115_PS_TIMING_LOG_9,                                           //"[PST] OpenRF = %x us, TBTT = %x us, RxBcn = %x us\n"
    MSG_1115_PS_TIMING_LOG_10,                                          //"[PST] OpenRF to TBTT = %d us, TBTT to RxBcn = %d us, RxBcn to ClsRF = %d us\n"
    MSG_1115_PS_TIMING_LOG_11,                                          //"[PST] OpenRF = %x us, TBTT = %x us, SetBcnTo to BcnTo = %d us, BcnTo to ClsRF = %d us\n"
    MSG_1115_PS_TIMING_LOG_12,                                          //"[PST] OpenRF to ClsRF = %d us, RxBcn to S4 = %d us, S4Cnt = %d\n"
    MSG_1115_PS_TIMING_LOG_13,                                          //"[PST] OpenRF to ClsRF = %d us, BcnTo to S4 = %d us, S4Cnt = %d\n"
    MSG_1115_PS_TIMING_LOG_14,                                          //"[PST] BcnLossRate = %d/100, BcnTimeoutCnt = %d, BcnErlyCnt = %d\n"
    MSG_1115_PS_TIMING_LOG_15,                                          //"[PST] S4Error[%d] = %d\n"
    MSG_1115_PS_INIT_FAIL,                                              //"[FAIL] lps_info alloc fail!\n"
    MSG_1115_PS_PLATFORM_ERR,                                           //"Platform error (%d)!\n"
    MSG_1115_PS_RESTORE_FLOW_FAIL,                                      //"RestoreFlow FAIL!\n"
    MSG_1115_PS_AXIDMA_NOT_EMPTY,                                       //"[32K] AXIDMA not empty (%d). host = %x, hw = %x\n"
    MSG_1115_PS_NO_ENTER_LPS,                                           //"0x90=%x, No Enter LPS! 0xC0=%x\n"
    MSG_1115_PS_TX_PACKT_IN,                                            //"TxPktIn\n"
    MSG_1115_PS_TXDMA_BUSY,                                             //"[Err] TXDMA is busy! dma_busy1 = %x, dma_busy2 = %x\n"
    MSG_1115_PS_TAKE_SEMAPHORE_FAIL,                                    //"Step(%d) Take RxModeLock FAIL!!!\n"
    MSG_1115_PS_NULL_SEMAPHORE,                                         //"Step(%d) RxModeLock == NULL!\n"
    MSG_1115_PS_CLOSE_RF,                                               //">\n"
    MSG_1115_PS_OPEN_RF,                                                //"<\n"
    MSG_1115_PS_GRANT_WLAN_FAIL,                                        //"[PDCK] GNT WL FAIL!!\n"
    MSG_1115_PS_PDCK_CAL_FAIL,                                          //"PDCK CAL FAIL!!\n"
    MSG_1115_PS_ANACLK_CAL_FAIL,                                        //"ANACLK CAL FAIL!!\n"
    MSG_1115_PS_EN_RX_NORMAL_MODE_FAIL,                                 //"RF is OFF. EnRxNormMode FAIL!\n"
    MSG_1115_PS_EN_RX_NORMAL_MODE,                                      //"1->2"
    MSG_1115_PS_SET_RF_OFF_PERMISSION,                                  //"SetRfOffPermission: PhyRfOffPermission[%d]=%d\n"
    MSG_1115_PS_SET_32K_PERMISSION,                                     //"Set32KandPGPermission. 32K(%d), PG(%d)\n"
    MSG_1115_PS_ENABLE_LPS_FW_TEST,                                     //"Enable LPS FW test. Target LPS number (%x)\n"
    MSG_1115_PS_WAKE_BAR_PULL,                                          //"[RF OFF] Wake bar is pulled\n"
    MSG_1115_PS_RX_FAIL_KEEP_RF_ON,                                     //"[RF OFF] Rx FAIL! keep RF on.\n"
    MSG_1115_PS_CHECK_RF_CONDITION_FAIL,                                //"Check RF OFF condition FAIL (%d)\n"
    MSG_1115_PS_TX_NULL_FAIL,                                           //"[Error] Cannot tx null%d\n"
    MSG_1115_PS_CREATE_ROLE_FAIL,                                       //"[FAIL] Create Role fail!\n"
    MSG_1115_PS_ALREADY_IN_PS_MODE,                                     //"[Error] Already in LPS/WMM PS (%x)!!\n"
    MSG_1115_PS_SET_POWER_MODE_1,                                       //"MAC ID = %d, PS Mode = %d, RLBM = %d\n"
    MSG_1115_PS_SET_POWER_MODE_2,                                       //"Smart PS = %d, Awake Interval = %d, Last RPWM = %d\n"
    MSG_1115_PS_BEACON_EARLY,                                           //"E\n"
    MSG_1115_PS_RX_BEACON,                                              //"R\n"
    MSG_1115_PS_RX_BEACON_NO_HIT,                                       //"N\n"
    MSG_1115_PS_INVALID_BEACON_REPORT,                                  //"[Error] Does not receive BCN Parser Rpt\n"
    MSG_1115_PS_KEEP_RF_ON,                                             //"Keep ON\n"
    MSG_1115_PS_ENABLE_BEACON_TIMEOUT_TIMER_FAIL,                       //"EnBcnTimeOutCount fail!!\n"
    MSG_1115_PS_TIMER_VALUE_NOT_INIT,                                   //"Timer (%d) val is not init!! role_idx(%d)\n"
    MSG_1115_PS_CREATE_TIMER_FAIL,                                      //"Create timer (%d) fail!! role_idx(%d)\n"
    MSG_1115_PS_SEND_NULL_FAIL_RESULT,                                  //"TxNull %d FAIL! ret_type(%d), result(%d)\n"
    MSG_1115_PS_INVALID_POWER_BIT,                                      //"[PsSendNullCb] invalid pwr_bit(%d)\n"
    MSG_1115_PS_INIT_PS_PARAMETER,                                      //"InitPSParm, role_idx=%d\n"
    MSG_1115_PS_S2_CONDITION_MISMATCH,                                  //"[ChkS2 no match] Condition(%d), LpsDbgInfo = 0x%x\n"
    MSG_1115_PS_S4_CONDITION_MISMATCH,                                  //"[ChkS4 no match] Condition(%d), LpsDbgInfo = 0x%x\n"
    MSG_1115_PS_CHANGE_PS_STATE,                                        //"[ChangePSStateByRPWM] REQ State: %d, Cur State: %d\n"
    MSG_1115_PS_SET_POWER_MODE_ROLE_NOT_EXIST,                          //"[SetPwrMode] Role not exist! Condition (%d)\n"
    MSG_1115_PS_SET_TBTT_AGG_NUM,                                       //"Step(%d), SetTbttAggNum(%d).\n"
    MSG_1115_PS_RX_BEACON_TIMEOUT,                                      //"PsBcnTimeOut\n"
    MSG_1115_PS_SET_POWER_STATE,                                        //"CURRENT_PS_STATE: %d, LASTRPWM: %d\n"
    MSG_1115_PS_RESET_PS_PARAMETER,                                     //"ResetPSParm\n"
    MSG_1115_PS_ACTIVATE_SETTING,                                       //"ActiveSetting\n"
    MSG_1115_PS_SEND_NULL_RESULT,                                       //"[PsSendNullCb] type(%d), result(%d)\n"
    MSG_1115_PACKET_TX_NOT_ENABLE,                                      //"[ERR]MGQ1 Txen = 0, TXEN(0xC348)=%x\n"
    MSG_1115_PACKET_MACID_SLEEP,                                        //"MACID_SLEEP_0(0xC2C0)=%x\n"
    MSG_1115_PACKET_TX_NULL,                                            //"Null %d\n"
    MSG_1115_PACKET_SEND_NULL_FAIL,                                     //"Send NULL FAIL! ret_type(%d), ret_result(%d).\n"
    MSG_1115_PACKET_INVALID_POWER_BIT,                                  //"Send NULL with invalid type(%d)!.\n"
    MSG_1115_PACKET_NULL_PKTID_NOT_EXIST,                               //"Null PKTID No Exist!!\n"
    MSG_1115_PACKET_NULL_READ_PKT_OFFLOAD_FAIL,                         //"[IssueNull]ReadFWOfldPKT FAIL!!\n"
    MSG_1115_PACKET_NULL_PKT_OFFLOAD,                                   //"Null ID=%d, pkt_len=%d, ppkt_content=%x\n"
    MSG_1115_PACKET_PROBE_REQ_PKTID_NOT_EXIST,                          //"Probe req PKTID No Exist!!\n"
    MSG_1115_PACKET_PROBE_REQ_READ_PKT_OFFLOAD_FAIL,                    //"[IssueProbeReq]ReadFWOfldPKT FAIL!!\n"
    MSG_1115_BEACON_1,                                                   //"req bcn mem err\n"
    MSG_1115_BEACON_2,                                                   //"CPUIO rls bcn pld fail\n"
    MSG_1115_BEACON_3,                                                   //"req bcn wp err %d\n"
    MSG_1115_BEACON_4,                                                   //"bcnq lock fail\n"
    MSG_1115_BEACON_5,                                                   //"CPUIO deq bcn fail\n"
    MSG_1115_BEACON_6,                                                   //"bcn req wd fail %d\n"
    MSG_1115_BEACON_7,                                                   //"enq bcn fail %d\n"
    MSG_1115_PPS_00,                                                     //"B%d pps%d already enable\n"
    MSG_1115_PPS_01,                                                     //"B%d pps%d already disable\n"
    MSG_1115_PPS_02,                                                     //"B%d pps%d reg already enable\n"
    MSG_1115_PPS_03,                                                     //"B%d pps%d reg already disable\n"
    MSG_1115_PPS_04,                                                     //"invalid pps band %d\n"
    MSG_1115_PPS_05,                                                     //"B%d pps%d is not enable yet\n"
    MSG_1115_PPS_06,                                                     //"B%d pps%d pof%d already enable\n"
    MSG_1115_PPS_07,                                                     //"B%d pps%d pof%d already disable\n"
    MSG_1115_PPS_08,                                                     //"B%d pps%d pof%d reg already enable\n"
    MSG_1115_PPS_09,                                                     //"B%d pps%d pof%d reg already disable\n"
    MSG_1115_PPS_10,                                                     //"B%d pps%d pof%d running\n"
    MSG_1115_PPS_11,                                                     //"pps no param ptr %d\n"
    MSG_1115_PPS_12,                                                     //"invalid pps port %d\n"
    MSG_1115_PPS_13,                                                     //"no valid pps id\n"
    MSG_1115_PPS_14,                                                     //"pps is already running\n"
    MSG_1115_H2CPKT_0,											          //"content = %x  %x  %x  %x\n"
    MSG_1115_H2CPKT_1,											          //"H2C Loopback\n"
    MSG_1115_H2CPKT_2,											          //"size mismatch while deaggregating H2C\n"
    MSG_1115_H2CPKT_3,											          //"First H2C Enqueue\n"
    MSG_1115_H2CPKT_4,											          //"Get free H2C node fail\n"
    MSG_1115_H2CPKT_5,											          //"Get free H2C node fail\n"
    MSG_1115_H2CPKT_6,											          //"_InitH2CPktPoolRAMComm: H2C ptr is null!!!\n"
    MSG_1115_H2CPKT_7,											          //"_InitH2CPktPoolRAMComm: H2C queue is full!!!\n"
    MSG_1115_H2CPKT_8,											          //"H2C is null!!!\n"
    MSG_1115_H2CPKT_9,											          //"H2C Dequeue\n"
    MSG_1115_H2CPKT_10,											      //"H2CPKT dequeue fail\n"
    MSG_1115_H2CPKT_11,											      //"H2CPktEnQueueRAMComm\n"
    MSG_1115_H2CPKT_12,											      //"H2C header len %d & rx bd info len %d mismatch\n"
    MSG_1115_H2CPKT_13,											      //"H2CPKT enqueue fail\n"
    MSG_1115_H2CPKT_14,											      //"H2CPktNodeFreeRAMComm\n"
    MSG_1115_H2CPKT_15,											      //"Wrong H2C pool class: %d\n"
    MSG_1115_H2CPKT_16,											      //"H2CPktNodeFreeRAMComm: class %d H2C queue is full!!!\n"
    MSG_1115_H2CPKT_17,											      //"H2CPktNodeAllocRAMComm\n"
    MSG_1115_H2CPKT_18,											      //"H2CPkt length is too large\n"
    MSG_1115_H2CPKT_19,											      //"H2C node pool is empty\n"
    MSG_1115_H2CPKT_20,											      //"H2C node is valid\n"
    MSG_1115_H2CPKT_21,											      //"H2C Enqueue\n"
    MSG_1115_H2CPKT_22,											      //"H2CPKT get lock fail\n"
    MSG_1115_H2CPKT_23,											      //"H2C size is inconsistent\n"
    MSG_1115_H2CPKT_24,											      //"H2C node is NULL\n"
    MSG_1115_H2CPKT_25,											      //"H2CPKT get lock fail\n"
    MSG_1115_H2CPKT_26,											      //"H2CPKT return lock fail\n"
    MSG_1115_H2CPKT_27,                                                  //"FWCMD_H2C_FUNC_SET_SND_PARA_V1\n"
    MSG_1115_H2C2HREG_0,                                                 //"AXIDMA Stop Failed\n"
    MSG_1115_H2C2HREG_1,                                                 //"Should never get here\n"
    MSG_1115_PWRCTRL_0,                                                 //"=>Set32KandPGPermission\n"
    MSG_1115_PWRCTRL_1,                                                 //"Enter32KHzPermission: %d\n"
    MSG_1115_PWRCTRL_2,                                                 //"EnterPGPermission: %d\n"
    MSG_1115_PWRCTRL_3,                                                 //"PG resume!\n"
    MSG_1115_PWRCTRL_4,                                                 //">C\n\n"
    MSG_1115_PWRCTRL_5,                                                 //"BackupMacOnce fail\n"
    MSG_1115_PWRCTRL_6,                                                 //"BkpMAC1stSCH start fail!!\n"
    MSG_1115_PWRCTRL_7,                                                 //"BkpMAC1st polling timeout! ch_idx=%x!\n"
    MSG_1115_PWRCTRL_8,                                                 //"BkpMAC1stUNSCH start fail!!\n"
    MSG_1115_PWRCTRL_9,                                                 //"BkpMAC1st ch0 polling timeout!\n"
    MSG_1115_PWRCTRL_10,                                                 //"BkpMAC1st ch1 polling timeout!\n"
    MSG_1115_PWRCTRL_11,                                                 //"BkpMACeverytimeSCH start fail!!\n"
    MSG_1115_PWRCTRL_12,                                                 //"BkpMACeverytime polling timeout! ch_idx=%x!\n"
    MSG_1115_PWRCTRL_13,                                                 //"BkpMACeverytimeUNSCH start fail!!\n"
    MSG_1115_PWRCTRL_14,                                                 //"BkpMACeverytime ch0 polling timeout\n"
    MSG_1115_PWRCTRL_15,                                                 //"BkpMACeverytime ch1 polling timeout\n"
    MSG_1115_PWRCTRL_16,                                                 //"RestoreMAC1stSCH start fail!!\n"
    MSG_1115_PWRCTRL_17,                                                 //"RestoreMAC1stSCH polling timeout! ch_idx=%x!\n"
    MSG_1115_PWRCTRL_18,                                                 //"RestoreMACeverytimeSCH start fail!!\n"
    MSG_1115_PWRCTRL_19,                                                 //"RestoreMACeverytimeSCH polling timeout! ch_idx=%x!\n"
    MSG_1115_PWRCTRL_20,                                                 //"RestoreMACSCH ch0 polling timeout!\n"
    MSG_1115_PWRCTRL_21,                                                 //"RestoreMACSCH ch1 polling timeout!\n"
    MSG_1115_PWRCTRL_22,                                                 //"RestoreMAC polling WDE/PLE timeout!\n"
    MSG_1115_PWRCTRL_23,                                                 //"RestoreMAC1stUNSCH start fail!!\n"
    MSG_1115_PWRCTRL_24,                                                 //"RestoreMACS1stUNCH polling timeout! ch_idx=%x!\n"
    MSG_1115_PWRCTRL_25,                                                 //"RestoreMACeverytimeUNSCH start fail!!\n"
    MSG_1115_PWRCTRL_26,                                                 //"RestoreMACevertytimeUNSCH polling timeout! ch_idx=%x!\n"
    MSG_1115_PWRCTRL_27,                                                 //"RestoreMACUNSCH ch0 polling timeout!!\n"
    MSG_1115_PWRCTRL_28,                                                 //"RestoreMACUNSCH ch1 polling timeout!!\n"
    MSG_1115_PWRCTRL_29,                                                 //"BackupBBOnce fail\n"
    MSG_1115_PWRCTRL_30,                                                 //"BbRfModeLock is NULL!\n"
    MSG_1115_PWRCTRL_31,                                                 //"Take BbRfModeLock FAIL!\n"
    MSG_1115_PWRCTRL_32,                                                 //"Req mode invalid!\n"
    MSG_1115_TWT_00,                                                     //"TWT init fail, ALLOC NULL\n"
    MSG_1115_TWT_01,                                                     //"TWT init fail, create timer fail\n"
    MSG_1115_TWT_02,                                                     //"TWT init fail, create twtc2hLock fail\n"
    MSG_1115_TWT_03,                                                     //"TWT id %d invalid\n"
    MSG_1115_TWT_04,                                                     //"[TSF]invalid port %d\n"
    MSG_1115_TWT_05,                                                     //"add TWT[%d] h2c already valid\n"
    MSG_1115_TWT_06,                                                     //"add TWT h2c Role idx srch fail B%dP%d\n"
    MSG_1115_TWT_07,                                                     //"add TWT[%d] h2c Role idx %d exist\n"
    MSG_1115_TWT_08,                                                     //"add TWT done, port %x, itvl %d, dur %d\n"
    MSG_1115_TWT_09,                                                     //"[TWT]enable PCIE ACH%d DMA fail\n"
    MSG_1115_TWT_10,                                                     //"del TWT h2c Role srch fail B%dP%d\n"
    MSG_1115_TWT_11,                                                     //"del TWT h2c Role %d not match srch idx %d\n"
    MSG_1115_TWT_12,                                                     //"del TWT h2c clr TWT[%d] COM info fail\n"
    MSG_1115_TWT_13,                                                     //"del TWT h2c clr TWT[%d] NIC info fail\n"
    MSG_1115_TWT_14,                                                     //"TWT timer start fail\n"
    MSG_1115_TWT_15,                                                     //"did not assign twt ul fix, force to all TF fix.\n"
    MSG_1115_TWT_16,                                                     //"stop TWT timer fail\n"
    MSG_1115_TWT_17,                                                     //"del TWT h2c clr TWT[%d] AP info fail\n"
    MSG_1115_TWT_18,                                                     //"TWT act %d, macid %d, id %d\n"
    MSG_1115_TWT_19,                                                     //"TWT sta num %d\n"
    MSG_1115_TWT_20,                                                     //"[TWT]get B%d port %d tsf fail\n"
    MSG_1115_TWT_21,                                                     //"[TWT%d]issue wake pkt fail %d-%d\n"
    MSG_1115_TWT_22,                                                     //"[TWT]enable PCIE ACH%d DMA fail\n"
    MSG_1115_TWT_23,                                                     //"[TWT]disable PCIE ACH%d DMA fail\n"
    MSG_1115_TWT_24,                                                     //"[TWT]Next start %X-%X, end %X-%X\n"
    MSG_1115_TWT_25,                                                     //"[TWT]TSF diff over u32\n"
    MSG_1115_TWT_26,                                                     //"[TWT]SP start early %X-%X, srt diff %d,dur diff %d, end diff %d\n"
    MSG_1115_PS_TX_REQ,                                                  //"PsTxReq. role(%d), feature(%d), en(%d)\n"
    MSG_1115_PS_TX_REQ_DUPLICATED_DISABLE,                               //"[ERROR] role(%d), feature(%d) Tx has been disabled!\n"
    MSG_1115_PS_0,                                                       //"Wait Tx Null Result...\n"
    MSG_1115_PS_1,                                                       //"=>ResetPSParm\n"
    MSG_1115_PS_2,                                                       //"=>S0ToS1State\n"
    MSG_1115_PS_3,                                                       //"[Error] Cannot tx null1\n"
    MSG_1115_PS_4,                                                       //"=>S2ToS3State\n"
    MSG_1115_PS_5,                                                       //"[Error] Cannot tx null0\n"
    MSG_1115_PS_6,                                                       //"=>S2ToS0State\n"
    MSG_1115_PS_7,                                                       //"(S2toS0) Send NULL 0 Fail\n"
    MSG_1115_PS_CREATE_TIMER_DUPLICATED,                                 //"[ERR][LPS] Create timer (%d) is existed!! role_idx(%d)\n"
    MSG_1115_PS_DELETE_TIMER_FAIL,                                       //"[ERR][LPS] Delete timer (%d) FAIL!! role_idx(%d)\n"
    MSG_1115_PS_DELETE_TIMER_NOT_EXIST,                                  //"[ERR][LPS] Delete timer (%d) is not existed!! role_idx(%d)\n"
    MSG_1115_PS_DTIM_TIMER_NOT_EXIST,                                    //"[ERR][LPS] Operation(%d) DTIM timer is not existed!! role_idx(%d)\n"
    MSG_1115_PS_BCN_TIMER_NOT_EXIST,                                     //"[ERR][LPS] Operation(%d) BCN timer is not existed!! role_idx(%d)\n"
    MSG_1115_PS_TRX_TIMER_NOT_EXIST,                                     //"[ERR][LPS] Operation(%d) TRX timer is not existed!! role_idx(%d)\n"
    MSG_1115_PS_ENABLE_DTIM_TIMEOUT_TIMER_FAIL,                          //"[ERR][LPS] EnDTIMTimeOutCountComm fail!!\n"
    MSG_1115_PS_ENABLE_TRX_TIMEOUT_TIMER_FAIL,                           //"[ERR][LPS] EnTRXTimeOutCount fail!!\n"
	MSG_1115_PS_TIMER_CREATE_0,										//"=>PsTimerCreate\n"
	MSG_1115_PS_TIMER_CREATE_1,										//"Create BCN time out timer fail!!\n"
	MSG_1115_PS_TIMER_CREATE_2,										//"Create DTIM time out timer fail!!\n"
	MSG_1115_PS_TIMER_CREATE_3,										//"Create TRX time out timer fail!!\n"
	MSG_1115_PS_SET_PWR_MODE_0,										//"=>SetPwrMode\n"
	MSG_1115_PS_SET_PWR_MODE_1,										//"[SetPwrMode] Role not exist!\n"
	MSG_1115_PS_SET_PWR_MODE_2,										//"[SetPwrMode] Already in LPS/WMM PS!!\n"
	MSG_1115_PS_SET_PWR_MODE_3,										//"MAC ID = %d\n"
	MSG_1115_PS_SET_PWR_MODE_4,										//"PS Mode = %d\n"
	MSG_1115_PS_SET_PWR_MODE_5,										//"RLBM = %d\n"
	MSG_1115_PS_SET_PWR_MODE_6,										//"Smart PS = %d\n"
	MSG_1115_PS_SET_PWR_MODE_7,										//"Awake Interval = %d\n"
	MSG_1115_PS_SET_PWR_MODE_8,										//"Last RPWM = %d\n"
    MSG_1115_MP_0,                                                       //"error=%d\n"
    MSG_1115_MP_1,                                                       //"ips 0x1C err = 0x%08x\n"
    MSG_1115_MP_2,                                                       //"Wait Timeout ips status =0x%x, ips err = 0x%x\n"
    MSG_1115_MP_3,                                                       //"bit=%x"
    MSG_1115_MP_4,                                                       //"CMAC"
    MSG_1115_MP_5,                                                       //"ALL"
    MSG_1115_P2P_00,                                                     //"[P2P]no act info ptr\n"
    MSG_1115_P2P_01,                                                     //"[P2P]act h2c init Role idx srch fail macid %d\n"
    MSG_1115_P2P_02,                                                     //"[P2P]set pps param fail %d\n"
    MSG_1115_P2P_03,                                                     //"[P2P]B%d pps%d en%d fail %d\n"
    MSG_1115_P2P_04,                                                     //"[P2P]B%d pps%d pof%d en%d fail %d\n"
    MSG_1115_P2P_05,                                                     //"[P2P]set pof param fail %d\n"
    MSG_1115_P2P_06,                                                     //"[P2P]B%d P2P%d noa%d already disable\n"
    MSG_1115_P2P_07,                                                     //"[P2P]B%d P2P%d has no running NoA sch\n"
    MSG_1115_P2P_08,                                                     //"[P2P]no content ptr\n"
    MSG_1115_P2P_09,                                                     //"[P2P]act h2c p2p%d over max\n"
    MSG_1115_P2P_10,                                                     //"[P2P]act h2c noa%d over max\n"
    MSG_1115_P2P_11,                                                     //"[P2P]p2p%d already running\n"
    MSG_1115_P2P_12,                                                     //"[P2P]p2p%d not init yet\n"
    MSG_1115_P2P_13,                                                     //"[P2P]act h2c init fail %d\n"
    MSG_1115_P2P_14,                                                     //"[P2P]act h2c upd sch fail %d\n"
    MSG_1115_P2P_15,                                                     //"[P2P]act h2c rm sch fail %d\n"
    MSG_1115_P2P_16,                                                     //"[P2P]act h2c term fail %d\n"
    MSG_1115_P2P_17,                                                     //"[P2P]illegal act h2c %d\n"
    MSG_1115_P2P_18,                                                     //"[P2P] macid ctrl h2c p2p id %d over max\n"
    MSG_1115_P2P_19,                                                     //"[P2P]macid ctrl type %d invalid\n"
    MSG_1115_P2P_20,                                                     //"[P2P]no p2p info ptr\n"
    MSG_1115_P2P_21,                                                     //"[P2P]P2P%d clear MACID ctrl all fail %d\n"
    MSG_1115_P2P_22,                                                     //"[P2P]H2C Act fail %d\n"
    MSG_1115_P2P_23,                                                     //"[P2P]H2C MACID ctrl fail %d\n"
    MSG_1115_MALLOC_1, //"%x\t"
    MSG_1115_MALLOC_2, //"\t\t%u\t\t"
    MSG_1115_MALLOC_3, //"\t\t%u\n"
    MSG_1115_MALLOC_4, //"Fast heap\t%x\t%u\t\t%u\t%u\n"
    MSG_1115_MALLOC_5, //"Slow heap\t%x\t%u\t\t%u\t%u\n"
    MSG_1115_MALLOC_6, //"\t\t%u\t\t%u\t\t%u\n"
    MSG_1115_MALLOC_7, //"Don't support this mode!\n"
    MSG_1115_MALLOC_8, //"%s\t\t"
    MSG_1115_MALLOC_9, //"[Err][Phase%d]FastHeap(%u) is under threshold(%u)!\n"
    MSG_1115_MALLOC_10,	//"[Phase%d]FastHeap(%u) is above threshold(%u)!\n"
    MSG_1115_MALLOC_11,	//"[Err][Phase%d]SlowHeap(%u) is under threshold(%u)!\n"
    MSG_1115_MALLOC_12,	//"[Phase%d]SlowHeap(%u) is above threshold(%u)!\n"
    MSG_1115_MALLOC_13,	//"call %s return NULL\n"
    MSG_1115_MALLOC_14,	//"exceed memory limit\n"
    MSG_1115_MALLOC_15,	//" total: %d bytes\n cur used: %d bytes\n"
    MSG_1115_MALLOC_16,	//"cur free: %d bytes\n release size exceed allocate size\n"
    MSG_1115_SND_1,                                                      //"pctrlframe alloc fail \n"
    MSG_1115_SND_2,                                                      //"SND settle wrong\n"
    MSG_1115_SND_3,                                                      //"[ERR] sfp.f2p_index %d\n"
    MSG_1115_SND_4,                                                      //"SNDF2PTimer%d stop failed\n"
    MSG_1115_SND_5,                                                      //"[ERR][SND]sfp.f2p_period %d\n"
    MSG_1115_SND_6,                                                      //"SNDF2PTimer%d change period failed\n"
    MSG_1115_SND_7,                                                      //"SNDF2PTimer%d start failed\n"
    MSG_1115_SND_8,                                                      //"[ERR][SND]sfp.f2ps_type %d\n"
    MSG_1115_SND_9,                                                      //"insertSNDQ fail \n"
    MSG_1115_SND_10,                                                     //"popSNDQ fail \n"
    MSG_1115_MCC_H2CADDMCCHDL_4,                                         //"[MCC] channel band type is None!\n"
	MSG_1115_WLAN_2,														//"%s"
	MSG_1115_WLAN_3,														//"ERROR seq assign!!\n"
	MSG_1115_WLAN_4,														//"WARN: ReleasePacket get NULL packet address. \n"
	MSG_1115_WLAN_5,														//"free NULL txinfo node\n"
	MSG_1115_WLAN_6,														//"WAR: TXCMD FULL 1\n"
	MSG_1115_WLAN_7,														//"WAR: TXCMD FULL 2\n"
	MSG_1115_WLAN_8,														//"DLE_DFI_ctrl Error(%x)!\n"
    MSG_1115_WLAN_9,														//"macid is not valid\n"
    MSG_1115_WLAN_10,														//"sta is not created before connect\n"
    MSG_1115_WLAN_11,														//"sta re-init before disconnect\n"
	MSG_1115_PS_S2TOS4_0,													//"=>S2ToS4State\n"
	MSG_1115_PS_S2TOS4_1,													//"[LPS]Macid TX busy\n"
    MSG_1115_TASK_ERROR,                                                 //"Task Error: %wx\n"
    MSG_1115_GETMEDIASTS_1,                                              //"GetMediaStatusbyMacid fail, macid = %bx!\n"
    MSG_1115_SETMEDIASTS_1,                                              //"SetMediaStatusbyMacid: macid number >= 32, macid = %bx!\n"
    MSG_1115_SETMEDIASTS_2,                                              //"SetMediaStatusbyMacid: Role_idx error, macid = %bx, role_idx = %bx!\n"
	MSG_1115_WLANDUMP_76,                                                  //"[DL_DBG][Stage 1] AXIDMA channel[%d] in: %d  buffer full:%d\n"
    MSG_1115_WLANDUMP_77,                                                  //"[DL_DBG][Stage 1] enqueue xMessageBuffer fail: %d \n"
    MSG_1115_WLANDUMP_78,                                                  //"[DL_DBG][Stage 1] RPT type[%d]: %d \n"
    MSG_1115_WLANDUMP_79,                                                  //"[DL_DBG][Stage 2] SS2F total in :%d total abort : %d \n"
    MSG_1115_WLANDUMP_80,                                                  //"[DL_DBG][Stage 2] SS2F from_Txcmd: %d from_Empty: %d from_Query: %d \n"
    MSG_1115_WLANDUMP_81,                                                  //"[DL_DBG][Stage 2] RUA output user nums %d :%d \n"
    MSG_1115_WLANDUMP_82,                                                  //"[DL_DBG][Stage 2] Response NUser_BA :%d Nminus1User_BA %d MU_BAR %d HTP_ACK %d\n"
    MSG_1115_WLANDUMP_83,                                                  //"[DL_DBG][Stage 2] Protect  NO_PROETCT %d  PRI_HW_RTS %d RTS %d CTS2SELF %d MURTS %d \n"
    MSG_1115_WLANDUMP_84,                                                  //"[DL_DBG][Stage 3] su rate \nOFDM_CCK %d \nVHT_HT_MCS0_3 %d \nVHT_HT_MCS4_7 %d \nVHT_HT_MCS8_9 %d \nHE_MCS0_MCS3 %d \nHE_MCS4_MCS7 %d \nHE_MCS8_MCS9 %d \nHE_MCS10_MCS11 %d\n"
    MSG_1115_WLANDUMP_85,                                                  //"[DL_DBG][Stage 3] mu rate \nVHT_HT_MCS0_3 %d \nVHT_HT_MCS4_7 %d \nVHT_HT_MCS8_9 %d \nHE_MCS0_MCS3 %d \nHE_MCS4_MCS7 %d \nHE_MCS8_MCS9 %d \nHE_MCS10_MCS11 %d\n"
    MSG_1115_WLANDUMP_86,                                                  //"[DL_DBG][Stage 3] ru rate \nHE_MCS0_MCS3 %d \nHE_MCS4_MCS7 %d \nHE_MCS8_MCS9 %d \nHE_MCS10_MCS11 %d\n"
    MSG_1115_WLANDUMP_87,                                                  //"[DL_DBG][Stage 3] su_avg_agg %d mu_avg_agg %d ru_avg_agg %d\n"
    MSG_1115_WLANDUMP_88,                                                  //"[DL_DBG][Stage 3] Packet error rate : su %d mu %d ru %d\n"
    MSG_1115_WLANDUMP_89,                                                  //"[DL_DBG][Stage 3] su_ok %d, su_fail %d ; mu_ok %d, mu_fail %d ; ru_ok %d, ru_fail %d ;  "
    MSG_1115_WLANDUMP_90,                                                  //"[DL_DBG][Stage 3] tone usage \nHE_RU_26 %d \nHE_RU_52 %d \nHE_RU_106 %d \nHE_RU_242 %d \nHE_RU_484 %d \nHE_RU_996 %d \nHE_RU_2x996 %d\n"
    MSG_1115_WLANDUMP_91,                                                  //"[DL_DBG][Error  ] DL not valid total %d NOT_PRI_STA_VLD %d RPT_NOT_VALID %d NOT_SS2F %d\n "
    MSG_1115_WLANDUMP_92,                                                  //"[DL_DBG][Stage 3] SS2F SU user num = %d : %d;\n"
    MSG_1115_WLANDUMP_93,                                                  //"[DL_DBG][Stage 3] SS2F MU user num = %d : %d;\n"
    MSG_1115_WLANDUMP_94,                                                  //"[DL_DBG][Stage 3] SS2F RU user num = %d : %d;\n"
    MSG_1115_WLANDUMP_95,                                                  //"[DL_DBG][Error  ] TXCMD_FULL Reason 1 = %d, Reason 2 = %d ; \n"
    MSG_1115_WLANDUMP_96,                                                  //"[DL_DBG][Error  ] ss2f query reason %d, times = %d ;"
    MSG_1115_IO_0,			//"[ERR] XTAL_SI write fail !\n"
	MSG_1115_IO_1,			//"[ERR] XTAL_SI read fail !\n"
    MSG_1115_IPS_SET_CFG_ROLE_NOT_EXIST,                                   //"[SetIpsCfg] role is not existed\n"
    MSG_1115_IPS_SET_CFG_DUPLICATE_ENABLE,                                 //"[SetIpsCfg] IPS is already enabled! role_idx(%d)\n"
    MSG_1115_IPS_SET_CFG,                                                  //"[SetIpsCfg] macid(%d), Enable(%d)\n"
    MSG_1115_IPS_CHK_I1_COND_MATCH_1,                                      //"=>ChkI1ConditionMatch\n"
    MSG_1115_IPS_CHK_I1_COND_MATCH_2,                                      //"[ChkI1 no match] IpsDbgInfo = 0x%x\n"
    MSG_1115_IPS_CHANGE_IPS_STATE_INVALID_REQ_STATE,                       //"[ChangeIpsState] Invalid req_state = %d\n"
    MSG_1115_IPS_CHANGE_STATE_BY_CONDITION,                                //"[ChangeIPSStateByCondition] REQ State: %d, Cur State: %d\n"
    MSG_1115_PS_TRX_REQ_ROLE_NOT_EXIST,                                    //"[ERR] [PsTRxReq] role(%d) is not existed!\n"
    MSG_1115_PS_TRX_REQ,                                                   //"[PsTRxReq] %d. role(%d), feature(%d), en(%d)\n"
    MSG_1115_PS_TRX_REQ_DISABLE_ERR,                                       //"[ERR] [PsTRxReq] %d. role(%d), feature(%d) Tx has been disabled!\n"
    MSG_1115_ROLE_22,                                                      //"[FAIL] Role info - IpsParm alloc fail!\n"
    MSG_1115_OUTSRC_START = 20000,	// "out source delimiter start"
    MSG_1115_BTC_0,                                                      //"_setup_slot  new_ver:%d, ver:%d\n"
    MSG_1115_BTC_1,                                                      //"_check_bt_rfk_req(): mbx=%d, result=%d\n"
    MSG_1115_BTC_2,                                                      //"_send_offload_runinfo(): type:%d, run_cnt:%d\n"
    MSG_1115_BTC_3,                                                      //"_send_bt_info: len = %d\n"
    MSG_1115_BTC_4,                                                      //"_get_mbx30_rsp: Length=%x, data0=%x, data1=%x, data2=%x, data3=%x, data4=%x\n"
    MSG_1115_BTC_5,                                                      //"seq = %x, reg_val=%x\n"
    MSG_1115_BTC_6,                                                      //"_read_mreg\n"
    MSG_1115_BTC_7,                                                      //"_send_rpt(): cnt=%d, len=%d, type=%d, map=%x\n"
    MSG_1115_BTC_8,                                                      //"_tmr_btrfk(): BT RFK timeout!!\n"
    MSG_1115_BTC_9,                                                      //"_tmr_mon\n"
    MSG_1115_BTC_10,                                                      //"Aboart BT mailbox\n"
    MSG_1115_BTC_11,                                                      //"Mailbox dequeue fail\n"
    MSG_1115_BTC_12,                                                      //"_setup_rpt, enable=%x, para=%x, rpt_enable=%x\n"
    MSG_1115_BTC_13,                                                      //"_setup_slot->[Slot-%d Policy] dur:%d(modify:%x), tbl:%x, cxtype:%d\n"
    MSG_1115_BTC_14,                                                      //"_setup_mreg -> rid: %d, type: %d, byte: %d, offset: %x\n"
    MSG_1115_BTC_15,                                                      //"_setup_cxpolicy->[TDMA Policy] type:%d, rxflctrl:%d, txpause:%d, wtgle_n:%d, leak_n:%d, ext_ctrl=%d\n"
    MSG_1115_BTC_16,                                                      //"_setup_cxpolicy->[Slot-%d Policy] dur:%d(modify:%x), tbl:%x, cxtype:%d\n"
    MSG_1115_BTC_17,                                                      //"_setup_drvinfo(): type:%d, len=%d\n"
    MSG_1115_BTC_18,                                                      //"_setup_gpio_dbg(): phdl->gpio_dbg.en_map = %x\n"
    MSG_1115_BTC_19,                                                      //"_setup_gpio_dbg(): dbg_signal-%d ==> gpio-%d\n"
    MSG_1115_BTC_20,                                                      //"_setup_gpio_dbg(): enable dbg_signal-%d ==> gpio-%d\n"
    MSG_1115_BTC_21,                                                      //"_setup_bt: data0=%x, data1=%x, data2=%x, data3=%x\n"
    MSG_1115_BTC_22,                                                      //"mailbox enqueue fail\n"
    MSG_1115_BTC_23,                                                      //"mailbox: curr abalible bytes: %d\n"
    MSG_1115_BTC_24,                                                      //"[BTC], _update_bt_scbd return by invalid scbd value\n"
    MSG_1115_BTC_25,                                                      //"[BTC], _update_bt_info \n"
    MSG_1115_BTC_26,                                                      //"[BTC], _update_bt_info return by bt-info duplicate!!\n"
    MSG_1115_BTC_27,                                                      //"BTCoexMailboxSendComm return because mailbox not-avl (%x)\n"
    MSG_1115_BTC_28,                                                      //"BTCoexMailboxDataHDLComm: id = %d\n"
    MSG_1115_BTC_29,                                                      //"Recv H2C class: %d\n"
    MSG_1115_BTC_30,                                                      //"H2C Process status: %d\n"
    MSG_1115_BTC_31,                                                      //"cat: %d, class: %d, func: %d\n"
    MSG_1115_BTC_32,                                                      //"Wrong BTC AOAC state"
    MSG_1115_BTC_33,                                                      //"_evnt_wltmr: cycle.c_slot = %d!!\n"
    MSG_1115_BTC_34,                                                      //"_cx_policy_update\n"
    MSG_1115_BTC_35,                                                      //"_btc_gpio\n"
    MSG_1115_BTC_36,                                                      //"Coex exception: %x\n"
    MSG_1115_BTC_37,                                                      //"_enter: n_slot=%d, bt_relink=%d\n"
    MSG_1115_BTC_38,                                                      //"_enter-collision!!: n_slot=%d, last_slot=%d\n"
    MSG_1115_BTC_39,                                                      //"skip_cnt=%d\n"
    MSG_1115_BTC_40,                                                      //"tdma.type=%d, tdma_new.type=%d, c_slot=%d!!\n"
    MSG_1115_BTC_41,                                                      //"wait cycle_w2b to update cxpolicy!!\n"
    MSG_1115_BTC_42,                                                      //"BTCoexFCInitComm\n"
    MSG_1115_BTC_43,                                                      //"[FAIL] Create Role fail!\n"
    MSG_1115_BTC_44,                                                      //"[BTC], _set_bt_wl_ch_info():\n"
    MSG_1115_BTC_45,                                                      //"_set_policy(): policy_type:%x\n"
    MSG_1115_BTC_46,                                                      //"[BTC], _set_ant(): return by no change!!\n"
    MSG_1115_BTC_47,                                                      //"[BTC], _set_ant(): return by bt rfk!!\n"
    MSG_1115_BTC_48,                                                      //"[BTC], _set_ant(): return by wl rfk!!\n"
    MSG_1115_BTC_49,                                                      //"[BTC], _set_ant(): phy_map=%d, type=%d\n"
    MSG_1115_BTC_50,                                                      //"[BTC], _action_wl_only !!\n"
    MSG_1115_BTC_51,                                                      //"[BTC], _action_wl_init !!\n"
    MSG_1115_BTC_52,                                                      //"[BTC], _action_wl_off !!\n"
    MSG_1115_BTC_53,                                                      //"[BTC], _action_freerun !!\n"
    MSG_1115_BTC_54,                                                      //"[BTC], _action_bt_whql_test !!\n"
    MSG_1115_BTC_55,                                                      //"[BTC], _action_bt_rfk !!\n"
    MSG_1115_BTC_56,                                                      //"[BTC], _action_bt_off !!\n"
    MSG_1115_BTC_57,                                                      //"[BTC], _action_wl_5g !!\n"
    MSG_1115_BTC_58,                                                      //"[BTC], _action_wl_other !!\n"
    MSG_1115_BTC_59,                                                      //"[BTC], _action_wl_idle !!\n"
    MSG_1115_BTC_60,                                                      //"[BTC], _action_wl_nc !!\n"
    MSG_1115_BTC_61,                                                      //"[BTC], _action_wl_rfk !!\n"
    MSG_1115_BTC_62,                                                      //"[BTC], _set_action_by_bt !!\n"
    MSG_1115_BTC_63,                                                      //"[BTC], _run_coex(): run_reason = %s\n"
    MSG_1115_BTC_64,                                                      //"[BTC], _run_coex(): return for Manual CTRL!!\n"
    MSG_1115_BTC_65,                                                      //"[BTC], _run_coex(): return for Stop Coex DM!!\n"
    MSG_1115_BTC_66,                                                      //"[BTC], _run_coex(): return for WL init fail!!\n"
    MSG_1115_BTC_67,                                                      //"[BTC], _set_bt_tx_power(): level = %d\n"
    MSG_1115_BTC_68,                                                      //"[BTC], _set_bt_rx_gain(): level = %d\n"
    MSG_1115_BTC_69,                                                      //"[BTC], _set_bt_golden_rx_range(): p_id=%d, level=%d\n"
    MSG_1115_OUTSRC_BB_SURA_0,							  //"[RA]RateChange=%x\n"
    MSG_1115_OUTSRC_BB_SURA_1,							  //"[RA]RDth=0x%x,RUth=0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_2,							  //"[RA]r4=100\n"
    MSG_1115_OUTSRC_BB_SURA_3,							  //"[RA]ForceRD\n"
    MSG_1115_OUTSRC_BB_SURA_4,							  //"[RA]RDCnt=0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_5,							  //"[RA]RUCnt=0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_6,							  //"[RA]RS\n"
    MSG_1115_OUTSRC_BB_SURA_7,							  //"[RA]SGIRD\n"
    MSG_1115_OUTSRC_BB_SURA_8,							  //"[RA]BWRD\n"
    MSG_1115_OUTSRC_BB_SURA_9,							  //"[RA]RDToLowest1\n"
    MSG_1115_OUTSRC_BB_SURA_10,							  //"[RA]RDToLowest2\n"
    MSG_1115_OUTSRC_BB_SURA_11,							  //"[RA]RD:crate=0x%x,mrate0=0x%x,mrate1=0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_12,							  //"[RA]rate=0x%x,bw:0x%x,rate2=0x%x,bw2:0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_13,							  //"[RA]Hit:bw=0x%x->0x%x,rate=0x%x->0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_14,							  //"[RA]SR:rate0=0x%x,rate1=0x%x,rate2=0x%x,cnt=0x%x\n"
    MSG_1115_OUTSRC_BB_SURA_15,							  //"RSVD\n"
    MSG_1115_OUTSRC_BB_SURA_16,							  //"[RA]SGIRU\n"
    MSG_1115_OUTSRC_BB_SURA_17,							  //"[RA]BWRU\n"
    MSG_1115_OUTSRC_BB_SURA_18,							  //"[RA]RUbw++\n"
    MSG_1115_OUTSRC_BB_SURA_19,							  //"[RA]RUToHighest\n"
    MSG_1115_OUTSRC_BB_SURA_20,							  //"[RA]NoUpRate\n"
    MSG_1115_OUTSRC_BB_SURA_21,							  //"[RA]RU:crate=%x,mrate0=%x,mrate1=%x\n"
    MSG_1115_OUTSRC_BB_SURA_22,							  //"[RA,W]macid:%x,mode:%x,rate_idx:%x,mcs:%x,ss:%x\n"
    MSG_1115_OUTSRC_BB_SURA_23,							  //"[RA][TRY]PER=%x,RDR=%x,R4=%x, pre_tp=%d, next_tp=%d\n"
    MSG_1115_OUTSRC_BB_SURA_24,							  //"[RA][TRY]R4=100,cnt=%x\n"
    MSG_1115_OUTSRC_BB_SURA_25,							  //"[RA][TRY]rate=%x,sta->up_fail_limit_rate[0]=%x,sta->up_fail_limit_rate[1]=%x\n"
    MSG_1115_OUTSRC_BB_SURA_26,							  //"[RA]TryFail\n"
    MSG_1115_OUTSRC_BB_SURA_27,							  //"[RA]TrySuccess\n"
    MSG_1115_OUTSRC_BB_SURA_28,							  //"[RA]MtTryIdx=%x\n"
    MSG_1115_OUTSRC_BB_SURA_29,							  //"[RA]TryFailCnt=%x,rate=%x,bw=%x\n"
    MSG_1115_OUTSRC_BB_SURA_30,							  //"[RA]DrvFixRate\n"
    MSG_1115_OUTSRC_BB_SURA_31,							  //"[RA]POLLUTED\n"
    MSG_1115_OUTSRC_BB_SURA_32,							  //"[RA]Tot=0\n"
    MSG_1115_OUTSRC_BB_SURA_33,							  //"[RA]Tx=0,Tot:%x,Ok:%x\n"
    MSG_1115_OUTSRC_BB_SURA_34,							  //"[RA]StaNull\n"
    MSG_1115_OUTSRC_BB_SURA_35,							  //"[RA]NoHESU\n"
    MSG_1115_OUTSRC_BB_SURA_36,							  //"[RA]WDNoRelease\n"
    MSG_1115_OUTSRC_BB_SURA_37,							  //"[RA]TxRptTot=%x\n"
    MSG_1115_OUTSRC_BB_SURA_38,							  //"[RA]Ovfl\n"
    MSG_1115_OUTSRC_BB_SURA_39,							  //"RSVD\n"
    MSG_1115_OUTSRC_BB_SURA_40,							  //"RSVD\n"
    MSG_1115_OUTSRC_BB_SURA_41,							  //"RSVD\n"
    MSG_1115_OUTSRC_BB_SURA_42,							  //"[RA]1 chk_rate_up_lmt return: r_idx = %x, c_mcs = %x >= l_mcs = %x\n"
    MSG_1115_OUTSRC_BB_SURA_43,							  //"[RA]PER=%x,RDR=%x,r4=%x\n"
    MSG_1115_OUTSRC_BB_SURA_44,							  //"[RA]2 chk_rate_up_lmt return: r_idx = %x, c_mcs = %x >= l_mcs = %x\n"
    MSG_1115_OUTSRC_BB_SURA_45,							  //"[RA]3 chk_rate_up_lmt OK: r_idx = %x, c_mcs = %x >= l_mcs = %x\n"
    MSG_1115_OUTSRC_BB_SURA_46,							  //"[RA]rate_changed=%x @ rate_check_for_update\n"
    MSG_1115_OUTSRC_BB_SURA_47,							  //"[RA]chk rate exist: rate_idx=%x->%x (%x,%x,%x)\n"
    MSG_1115_OUTSRC_BB_SURA_48,							  //"[RA]chk_rate_up_lmt=%x,sta->up_fail_limit_rate[0]=%x,sta->up_fail_limit_rate[1]=%x\n"
    MSG_1115_OUTSRC_BB_SURA_49,							  //"[RA]r_idx = %x => per_ma = %x, per_var == %x, decision_offset_n=%x, decision_offset_p=%x\n"
    MSG_1115_OUTSRC_BB_SURA_50,							  //"[RA]UpFailLimitCnt:%x,m_rtae_up_fail_cnt_lmt:%x\n"
    MSG_1115_OUTSRC_BB_SURA_51,							  //"[RA][txrpt]Txcnt=%x, Try=%x, total=%x, OK=%x, Initrate,Giltf=%x,%x, Finalrate,Giltf=%x,%x, BW=%x,wd_not_released=%x\n"
    MSG_1115_OUTSRC_BB_SURA_52,							  //"[RA][TBTT]ID=%x,Media:%x,Tot=%x,Ok=%x,OK=%x\n"
    MSG_1115_OUTSRC_BB_SURA_53,							  //"[RA][TBTT][FWfixrate]ID=%x,Media:%x,Tot=%x,Ok=%x,a-OK%x\n"
    MSG_1115_OUTSRC_BB_SURA_54,							  //"[RA]Sgi_pending_cnt = %x\n"
    MSG_1115_OUTSRC_BB_SURA_55,							  //"[RA][SGI]New rate = %x, Old gi = %x, New gi = %x\n"
    MSG_1115_OUTSRC_BB_SURA_56,							  //"[RA][H2C]Mode_sel=%x, gi_ltf=%x, dcm_cap=%x, er_cap=%x, init_rate_lv=%x, ldpc_cap=%x, stbc_cap=%x, arfr_ctrl=%x\n"
    MSG_1115_OUTSRC_BB_SURA_57,							  //"[RA][H2C]Initial_BW=%x, max_ss_support=%x\n"
    MSG_1115_OUTSRC_BB_SURA_58,							  //"[RA][H2C]Ra_mask0=%x, ra_mask1=%x, highest_rate=%x, max_start_rate=%x, lowest_rate=%x\n"
    MSG_1115_OUTSRC_BB_SURA_59,							  //"[RA][H2C]Initrate: rateidx=%x, mode=%x, gi_ltf=%x, bw_idx=%x\n"
    MSG_1115_OUTSRC_END,		// "out source delimiter end"
    MSG_1115_LAST,                                                        //"Please add your log above."
};
extern struct mac_fw_msg fw_log_1115[];
#endif //__HAL1115_FW_LOG__
