#ifndef __HCI_REG_AX_H__
#define __HCI_REG_AX_H__

//
// WL_AX_Reg_PCIE.xls
//

//
// PCIE
//

#define R_AX_PCIE_INIT_CFG1 0x1000
#define B_AX_PCIE_RXRST_KEEP_REG BIT(23)
#define B_AX_PCIE_TXRST_KEEP_REG BIT(22)
#define B_AX_PCIE_PERST_KEEP_REG BIT(21)
#define B_AX_PCIE_FLR_KEEP_REG BIT(20)
#define B_AX_PCIE_TRAIN_KEEP_REG BIT(19)
#define B_AX_RXBD_MODE BIT(18)
#define B_AX_PCIE_MAX_RXDMA_SH 14
#define B_AX_PCIE_MAX_RXDMA_MSK 0x7
#define B_AX_RXHCI_EN BIT(13)
#define B_AX_LATENCY_CONTROL BIT(12)
#define B_AX_TXHCI_EN BIT(11)
#define B_AX_PCIE_MAX_TXDMA_SH 8
#define B_AX_PCIE_MAX_TXDMA_MSK 0x7
#define B_AX_TX_TRUNC_MODE BIT(5)
#define B_AX_RX_TRUNC_MODE BIT(4)
#define B_AX_RST_BDRAM BIT(3)
#define B_AX_DIS_RXDMA_PRE BIT(2)

#define R_AX_PCIE_INIT_CFG2 0x1004
#define B_AX_WD_ITVL_IDLE_SH 24
#define B_AX_WD_ITVL_IDLE_MSK 0xf
#define B_AX_WD_ITVL_ACT_SH 16
#define B_AX_WD_ITVL_ACT_MSK 0xf
#define B_AX_PCIE_RX_APPLEN_SH 0
#define B_AX_PCIE_RX_APPLEN_MSK 0x3fff

#define R_AX_PCIE_PS_CTRL 0x1008
#define B_AX_RSM_FROM_L0S_CNT_SH 24
#define B_AX_RSM_FROM_L0S_CNT_MSK 0xff
#define B_AX_RSM_L0S_EN BIT(8)
#define B_AX_TXON_EXIT_L1_EN BIT(7)
#define B_AX_WD_NO_EMP_EXIT_L1_EN BIT(6)
#define B_AX_L1OFF_PWR_OFF_EN BIT(5)
#define B_AX_PCIE_FORCE_L0 BIT(4)
#define B_AX_TXFLAG_EXIT_L1_EN BIT(3)
#define B_AX_EN_HWENTR_L1 BIT(2)
#define B_AX_PCIE_EN_SWENT_L23 BIT(1)
#define B_AX_PCIE_EN_HWEXT_L1 BIT(0)

#define R_AX_PCIE_MIX_CFG 0x100C
#define B_AX_PCIE_T3_TIME_SH 22
#define B_AX_PCIE_T3_TIME_MSK 0x3
#define B_AX_PCIE_T2_TIME_SH 20
#define B_AX_PCIE_T2_TIME_MSK 0x3
#define B_AX_HOTRST_EN BIT(19)
#define B_AX_MDIO_MODE BIT(18)
#define B_AX_CHANGE_PCIE_SPEED BIT(16)
#define B_AX_GEN1_GEN2_SH 14
#define B_AX_GEN1_GEN2_MSK 0x3
#define B_AX_HPS_CLKR_PCIE_SH 12
#define B_AX_HPS_CLKR_PCIE_MSK 0x3
#define B_AX_PCIEIO_PERSTB_SEL BIT(10)
#define B_AX_EPHY_RX50_EN BIT(8)
#define B_AX_MSI_TIMEOUT_ID_V1_SH 5
#define B_AX_MSI_TIMEOUT_ID_V1_MSK 0x7
#define B_AX_RADDR_RD BIT(4)
#define B_AX_ECRC_EN BIT(3)
#define B_AX_EN_SLOW_MAC_TX BIT(2)
#define B_AX_EN_SLOW_MAC_RX BIT(1)
#define B_AX_EN_SLOW_MAC_HW BIT(0)

#define R_AX_PCIE_DMA_STOP1 0x1010
#define B_AX_STOP_PCIEIO BIT(20)
#define B_AX_STOP_WPDMA BIT(19)
#define B_AX_STOP_CH12 BIT(18)
#define B_AX_STOP_CH9 BIT(17)
#define B_AX_STOP_CH8 BIT(16)
#define B_AX_STOP_ACH7 BIT(15)
#define B_AX_STOP_ACH6 BIT(14)
#define B_AX_STOP_ACH5 BIT(13)
#define B_AX_STOP_ACH4 BIT(12)
#define B_AX_STOP_ACH3 BIT(11)
#define B_AX_STOP_ACH2 BIT(10)
#define B_AX_STOP_ACH1 BIT(9)
#define B_AX_STOP_ACH0 BIT(8)

#define R_AX_TXBD_RWPTR_CLR1 0x1014
#define B_AX_CLR_CH12_IDX BIT(10)
#define B_AX_CLR_CH9_IDX BIT(9)
#define B_AX_CLR_CH8_IDX BIT(8)
#define B_AX_CLR_ACH7_IDX BIT(7)
#define B_AX_CLR_ACH6_IDX BIT(6)
#define B_AX_CLR_ACH5_IDX BIT(5)
#define B_AX_CLR_ACH4_IDX BIT(4)
#define B_AX_CLR_ACH3_IDX BIT(3)
#define B_AX_CLR_ACH2_IDX BIT(2)
#define B_AX_CLR_ACH1_IDX BIT(1)
#define B_AX_CLR_ACH0_IDX BIT(0)

#define R_AX_RXBD_RWPTR_CLR 0x1018
#define B_AX_CLR_RPQ_IDX BIT(1)
#define B_AX_CLR_RXQ_IDX BIT(0)

#define R_AX_PCIE_DMA_BUSY1 0x101C
#define B_AX_PCIEIO_RX_BUSY BIT(22)
#define B_AX_PCIEIO_TX_BUSY BIT(21)
#define B_AX_PCIEIO_BUSY BIT(20)
#define B_AX_WPDMA_BUSY BIT(19)
#define B_AX_CH12_BUSY BIT(18)
#define B_AX_CH9_BUSY BIT(17)
#define B_AX_CH8_BUSY BIT(16)
#define B_AX_ACH7_BUSY BIT(15)
#define B_AX_ACH6_BUSY BIT(14)
#define B_AX_ACH5_BUSY BIT(13)
#define B_AX_ACH4_BUSY BIT(12)
#define B_AX_ACH3_BUSY BIT(11)
#define B_AX_ACH2_BUSY BIT(10)
#define B_AX_ACH1_BUSY BIT(9)
#define B_AX_ACH0_BUSY BIT(8)
#define B_AX_RPQ_BUSY BIT(1)
#define B_AX_RXQ_BUSY BIT(0)

#define R_AX_RXQ_RXBD_NUM 0x1020
#define B_AX_RXQ_DESC_NUM_SH 0
#define B_AX_RXQ_DESC_NUM_MSK 0x3ff

#define R_AX_RPQ_RXBD_NUM 0x1022
#define B_AX_RPQ_DESC_NUM_SH 0
#define B_AX_RPQ_DESC_NUM_MSK 0x3ff

#define R_AX_ACH0_TXBD_NUM 0x1024
#define B_AX_PCIE_ACH0_FLAG BIT(14)
#define B_AX_ACH0_DESC_NUM_SH 0
#define B_AX_ACH0_DESC_NUM_MSK 0x3ff

#define R_AX_ACH1_TXBD_NUM 0x1026
#define B_AX_PCIE_ACH1_FLAG BIT(14)
#define B_AX_ACH1_DESC_NUM_SH 0
#define B_AX_ACH1_DESC_NUM_MSK 0x3ff

#define R_AX_ACH2_TXBD_NUM 0x1028
#define B_AX_PCIE_ACH2_FLAG BIT(14)
#define B_AX_ACH2_DESC_NUM_SH 0
#define B_AX_ACH2_DESC_NUM_MSK 0x3ff

#define R_AX_ACH3_TXBD_NUM 0x102A
#define B_AX_PCIE_ACH3_FLAG BIT(14)
#define B_AX_ACH3_DESC_NUM_SH 0
#define B_AX_ACH3_DESC_NUM_MSK 0x3ff

#define R_AX_ACH4_TXBD_NUM 0x102C
#define B_AX_PCIE_ACH4_FLAG BIT(14)
#define B_AX_ACH4_DESC_NUM_SH 0
#define B_AX_ACH4_DESC_NUM_MSK 0x3ff

#define R_AX_ACH5_TXBD_NUM 0x102E
#define B_AX_PCIE_ACH5_FLAG BIT(14)
#define B_AX_ACH5_DESC_NUM_SH 0
#define B_AX_ACH5_DESC_NUM_MSK 0x3ff

#define R_AX_ACH6_TXBD_NUM 0x1030
#define B_AX_PCIE_ACH6_FLAG BIT(14)
#define B_AX_ACH6_DESC_NUM_SH 0
#define B_AX_ACH6_DESC_NUM_MSK 0x3ff

#define R_AX_ACH7_TXBD_NUM 0x1032
#define B_AX_PCIE_ACH7_FLAG BIT(14)
#define B_AX_ACH7_DESC_NUM_SH 0
#define B_AX_ACH7_DESC_NUM_MSK 0x3ff

#define R_AX_CH8_TXBD_NUM 0x1034
#define B_AX_PCIE_CH8_FLAG BIT(14)
#define B_AX_CH8_DESC_NUM_SH 0
#define B_AX_CH8_DESC_NUM_MSK 0x3ff

#define R_AX_CH9_TXBD_NUM 0x1036
#define B_AX_PCIE_CH9_FLAG BIT(14)
#define B_AX_CH9_DESC_NUM_SH 0
#define B_AX_CH9_DESC_NUM_MSK 0x3ff

#define R_AX_CH12_TXBD_NUM 0x1038
#define B_AX_PCIE_CH12_FLAG BIT(14)
#define B_AX_CH12_DESC_NUM_SH 0
#define B_AX_CH12_DESC_NUM_MSK 0x3ff

#define R_AX_RXQ_RXBD_IDX 0x1050
#define B_AX_RXQ_HW_IDX_SH 16
#define B_AX_RXQ_HW_IDX_MSK 0x3ff
#define B_AX_RXQ_HOST_IDX_SH 0
#define B_AX_RXQ_HOST_IDX_MSK 0x3ff

#define R_AX_RPQ_RXBD_IDX 0x1054
#define B_AX_RPQ_HW_IDX_SH 16
#define B_AX_RPQ_HW_IDX_MSK 0x3ff
#define B_AX_RPQ_HOST_IDX_SH 0
#define B_AX_RPQ_HOST_IDX_MSK 0x3ff

#define R_AX_ACH0_TXBD_IDX 0x1058
#define B_AX_ACH0_HW_IDX_SH 16
#define B_AX_ACH0_HW_IDX_MSK 0x3ff
#define B_AX_ACH0_HOST_IDX_SH 0
#define B_AX_ACH0_HOST_IDX_MSK 0x3ff

#define R_AX_ACH1_TXBD_IDX 0x105C
#define B_AX_ACH1_HW_IDX_SH 16
#define B_AX_ACH1_HW_IDX_MSK 0x3ff
#define B_AX_ACH1_HOST_IDX_SH 0
#define B_AX_ACH1_HOST_IDX_MSK 0x3ff

#define R_AX_ACH2_TXBD_IDX 0x1060
#define B_AX_ACH2_HW_IDX_SH 16
#define B_AX_ACH2_HW_IDX_MSK 0x3ff
#define B_AX_ACH2_HOST_IDX_SH 0
#define B_AX_ACH2_HOST_IDX_MSK 0x3ff

#define R_AX_ACH3_TXBD_IDX 0x1064
#define B_AX_ACH3_HW_IDX_SH 16
#define B_AX_ACH3_HW_IDX_MSK 0x3ff
#define B_AX_ACH3_HOST_IDX_SH 0
#define B_AX_ACH3_HOST_IDX_MSK 0x3ff

#define R_AX_ACH4_TXBD_IDX 0x1068
#define B_AX_ACH4_HW_IDX_SH 16
#define B_AX_ACH4_HW_IDX_MSK 0x3ff
#define B_AX_ACH4_HOST_IDX_SH 0
#define B_AX_ACH4_HOST_IDX_MSK 0x3ff

#define R_AX_ACH5_TXBD_IDX 0x106C
#define B_AX_ACH5_HW_IDX_SH 16
#define B_AX_ACH5_HW_IDX_MSK 0x3ff
#define B_AX_ACH5_HOST_IDX_SH 0
#define B_AX_ACH5_HOST_IDX_MSK 0x3ff

#define R_AX_ACH6_TXBD_IDX 0x1070
#define B_AX_ACH6_HW_IDX_SH 16
#define B_AX_ACH6_HW_IDX_MSK 0x3ff
#define B_AX_ACH6_HOST_IDX_SH 0
#define B_AX_ACH6_HOST_IDX_MSK 0x3ff

#define R_AX_ACH7_TXBD_IDX 0x1074
#define B_AX_ACH7_HW_IDX_SH 16
#define B_AX_ACH7_HW_IDX_MSK 0x3ff
#define B_AX_ACH7_HOST_IDX_SH 0
#define B_AX_ACH7_HOST_IDX_MSK 0x3ff

#define R_AX_CH8_TXBD_IDX 0x1078
#define B_AX_CH8_HW_IDX_SH 16
#define B_AX_CH8_HW_IDX_MSK 0x3ff
#define B_AX_CH8_HOST_IDX_SH 0
#define B_AX_CH8_HOST_IDX_MSK 0x3ff

#define R_AX_CH9_TXBD_IDX 0x107C
#define B_AX_CH9_HW_IDX_SH 16
#define B_AX_CH9_HW_IDX_MSK 0x3ff
#define B_AX_CH9_HOST_IDX_SH 0
#define B_AX_CH9_HOST_IDX_MSK 0x3ff

#define R_AX_CH12_TXBD_IDX 0x1080
#define B_AX_CH12_HW_IDX_SH 16
#define B_AX_CH12_HW_IDX_MSK 0x3ff
#define B_AX_CH12_HOST_IDX_SH 0
#define B_AX_CH12_HOST_IDX_MSK 0x3ff

#define R_AX_DBI_FLAG 0x1090
#define B_AX_DBI_RFLAG BIT(17)
#define B_AX_DBI_WFLAG BIT(16)
#define B_AX_DBI_WREN_SH 12
#define B_AX_DBI_WREN_MSK 0xf
#define B_AX_DBI_ADDR_SH 0
#define B_AX_DBI_ADDR_MSK 0xfff

#define R_AX_DBI_WDATA  0x1094
#define B_AX_DBI_WDATA_SH 0
#define B_AX_DBI_WDATA_MSK 0xffffffffL

#define R_AX_DBI_RDATA 0x1098
#define B_AX_DBI_RDATA_SH 0
#define B_AX_DBI_RDATA_MSK 0xffffffffL

#define R_AX_MDIO_CFG 0x10A0
#define B_AX_MDIO_PHY_ADDR_SH 12
#define B_AX_MDIO_PHY_ADDR_MSK 0x3
#define B_AX_MDIO_RFLAG BIT(9)
#define B_AX_MDIO_WFLAG BIT(8)
#define B_AX_MDIO_ADDR_SH 0
#define B_AX_MDIO_ADDR_MSK 0x1f

#define R_AX_MDIO_WDATA 0x10A4
#define B_AX_MDIO_WDATA_SH 0
#define B_AX_MDIO_WDATA_MSK 0xffff

#define R_AX_MDIO_RDATA 0x10A6
#define B_AX_MDIO_RDATA_SH 0
#define B_AX_MDIO_RDATA_MSK 0xffff

#define R_AX_PCIE_HIMR00 0x10B0
#define B_AX_L0S_FAIL_INT_EN BIT(28)
#define B_AX_HC00ISR_IND_INT_EN BIT(27)
#define B_AX_HD1ISR_IND_INT_EN BIT(26)
#define B_AX_HD0ISR_IND_INT_EN BIT(25)
#define B_AX_HS0ISR_IND_INT_EN BIT(24)
#define B_AX_LINK_SPEED_INT_EN BIT(22)
#define B_AX_RETRAIN_INT_EN BIT(21)
#define B_AX_RPQBD_FULL_INT_EN BIT(20)
#define B_AX_RDU_INT_EN BIT(19)
#define B_AX_RXDMA_STUCK_INT_EN BIT(18)
#define B_AX_TXDMA_STUCK_INT_EN BIT(17)
#define B_AX_PCIE_HOTRST_INT_EN BIT(16)
#define B_AX_PCIE_FLR_INT_EN BIT(15)
#define B_AX_PCIE_PERST_INT_EN BIT(14)
#define B_AX_TXDMA_CH12_INT_EN BIT(13)
#define B_AX_TXDMA_CH9_INT_EN BIT(12)
#define B_AX_TXDMA_CH8_INT_EN BIT(11)
#define B_AX_TXDMA_ACH7_INT_EN BIT(10)
#define B_AX_TXDMA_ACH6_INT_EN BIT(9)
#define B_AX_TXDMA_ACH5_INT_EN BIT(8)
#define B_AX_TXDMA_ACH4_INT_EN BIT(7)
#define B_AX_TXDMA_ACH3_INT_EN BIT(6)
#define B_AX_TXDMA_ACH2_INT_EN BIT(5)
#define B_AX_TXDMA_ACH1_INT_EN BIT(4)
#define B_AX_TXDMA_ACH0_INT_EN BIT(3)
#define B_AX_RPQDMA_INT_EN BIT(2)
#define B_AX_RXP1DMA_INT_EN BIT(1)
#define B_AX_RXDMA_INT_EN BIT(0)

#define R_AX_PCIE_HISR00 0x10B4
#define B_AX_L0S_FAIL_INT BIT(28)
#define B_AX_HC00ISR_IND_INT BIT(27)
#define B_AX_HD1ISR_IND_INT BIT(26)
#define B_AX_HD0ISR_IND_INT BIT(25)
#define B_AX_HS0ISR_IND_INT BIT(24)
#define B_AX_LINK_SPEED_INT BIT(22)
#define B_AX_RETRAIN_INT BIT(21)
#define B_AX_RPQBD_FULL_INT BIT(20)
#define B_AX_RDU_INT BIT(19)
#define B_AX_RXDMA_STUCK_INT BIT(18)
#define B_AX_TXDMA_STUCK_INT BIT(17)
#define B_AX_PCIE_HOTRST_INT BIT(16)
#define B_AX_PCIE_FLR_INT BIT(15)
#define B_AX_PCIE_PERST_INT BIT(14)
#define B_AX_TXDMA_CH12_INT BIT(13)
#define B_AX_TXDMA_CH9_INT BIT(12)
#define B_AX_TXDMA_CH8_INT BIT(11)
#define B_AX_TXDMA_ACH7_INT BIT(10)
#define B_AX_TXDMA_ACH6_INT BIT(9)
#define B_AX_TXDMA_ACH5_INT BIT(8)
#define B_AX_TXDMA_ACH4_INT BIT(7)
#define B_AX_TXDMA_ACH3_INT BIT(6)
#define B_AX_TXDMA_ACH2_INT BIT(5)
#define B_AX_TXDMA_ACH1_INT BIT(4)
#define B_AX_TXDMA_ACH0_INT BIT(3)
#define B_AX_RPQDMA_INT BIT(2)
#define B_AX_RXP1DMA_INT BIT(1)
#define B_AX_RXDMA_INT BIT(0)

#define R_AX_PCIE_HRPWM 0x10C0
#define B_AX_PCIE_HRPWM_SH 0
#define B_AX_PCIE_HRPWM_MSK 0xffff

#define R_AX_INT_MIT_TX 0x10D0
#define B_AX_TXMIT_CH12_SEL BIT(31)
#define B_AX_TXMIT_CH11_SEL BIT(30)
#define B_AX_TXMIT_CH10_SEL BIT(29)
#define B_AX_TXMIT_CH9_SEL BIT(28)
#define B_AX_TXMIT_CH8_SEL BIT(27)
#define B_AX_TXMIT_ACH7_SEL BIT(26)
#define B_AX_TXMIT_ACH6_SEL BIT(25)
#define B_AX_TXMIT_ACH5_SEL BIT(24)
#define B_AX_TXMIT_ACH4_SEL BIT(23)
#define B_AX_TXMIT_ACH3_SEL BIT(22)
#define B_AX_TXMIT_ACH2_SEL BIT(21)
#define B_AX_TXMIT_ACH1_SEL BIT(20)
#define B_AX_TXMIT_ACH0_SEL BIT(19)
#define B_AX_TXTIMER_UNIT_SH 16
#define B_AX_TXTIMER_UNIT_MSK 0x3
#define B_AX_TXCOUNTER_MATCH_SH 8
#define B_AX_TXCOUNTER_MATCH_MSK 0xff
#define B_AX_TXTIMER_MATCH_SH 0
#define B_AX_TXTIMER_MATCH_MSK 0xff

#define R_AX_INT_MIT_RX 0x10D4
#define B_AX_RXMIT_RXP1_SEL BIT(19)
#define B_AX_RXMIT_RXP2_SEL BIT(18)
#define B_AX_RXTIMER_UNIT_SH 16
#define B_AX_RXTIMER_UNIT_MSK 0x3
#define B_AX_RXCOUNTER_MATCH_SH 8
#define B_AX_RXCOUNTER_MATCH_MSK 0xff
#define B_AX_RXTIMER_MATCH_SH 0
#define B_AX_RXTIMER_MATCH_MSK 0xff

#define R_AX_BD_ADDR_H 0x10E0
#define B_AX_BD_ADDR_H_SH 8
#define B_AX_BD_ADDR_H_MSK 0xffffff

#define R_AX_WD_ADDR_H 0x10E4
#define B_AX_WD_ADDR_H_SH 8
#define B_AX_WD_ADDR_H_MSK 0xffffff

#define R_AX_WP_ADDR_H 0x10E8
#define B_AX_WP_ADDR_H_SH 8
#define B_AX_WP_ADDR_H_MSK 0xffffff

#define R_AX_RXP1_ADDR_H 0x10EC
#define B_AX_RXP1_ADDR_H_SH 8
#define B_AX_RXP1_ADDR_H_MSK 0xffffff

#define R_AX_RX_ADDR_H 0x10F0
#define B_AX_RX_ADDR_H_SH 8
#define B_AX_RX_ADDR_H_MSK 0xffffff

#define R_AX_PCIE_INFO 0x10F8
#define B_AX_HOST_GEN2_SUPPORT BIT(4)
#define B_AX_ACT_LINK_OFF BIT(2)
#define B_AX_PCIERX_IDLE BIT(1)
#define B_AX_PCIETX_IDLE BIT(0)

#define R_AX_TSFTIMER_HCI 0x10FC
#define B_AX_TSFT2_HCI_SH 16
#define B_AX_TSFT2_HCI_MSK 0xffff
#define B_AX_TSFT1_HCI_SH 0
#define B_AX_TSFT1_HCI_MSK 0xffff

#define R_AX_RXQ_RXBD_DESA_L 0x1100
#define B_AX_RXQ_RXBD_DESA_L_SH 0
#define B_AX_RXQ_RXBD_DESA_L_MSK 0xffffffffL

#define R_AX_RXQ_RXBD_DESA_H 0x1104
#define B_AX_RXQ_RXBD_DESA_H_SH 0
#define B_AX_RXQ_RXBD_DESA_H_MSK 0xff

#define R_AX_RPQ_RXBD_DESA_L 0x1108
#define B_AX_RPQ_RXBD_DESA_L_SH 0
#define B_AX_RPQ_RXBD_DESA_L_MSK 0xffffffffL

#define R_AX_RPQ_RXBD_DESA_H 0x110C
#define B_AX_RPQ_RXBD_DESA_H_SH 0
#define B_AX_RPQ_RXBD_DESA_H_MSK 0xff

#define R_AX_ACH0_TXBD_DESA_L 0x1110
#define B_AX_ACH0_TXBD_DESA_L_SH 0
#define B_AX_ACH0_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH0_TXBD_DESA_H 0x1114
#define B_AX_ACH0_TXBD_DESA_H_SH 0
#define B_AX_ACH0_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH1_TXBD_DESA_L 0x1118
#define B_AX_ACH1_TXBD_DESA_L_SH 0
#define B_AX_ACH1_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH1_TXBD_DESA_H 0x111C
#define B_AX_ACH1_TXBD_DESA_H_SH 0
#define B_AX_ACH1_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH2_TXBD_DESA_L 0x1120
#define B_AX_ACH2_TXBD_DESA_L_SH 0
#define B_AX_ACH2_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH2_TXBD_DESA_H 0x1124
#define B_AX_ACH2_TXBD_DESA_H_SH 0
#define B_AX_ACH2_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH3_TXBD_DESA_L 0x1128
#define B_AX_ACH3_TXBD_DESA_L_SH 0
#define B_AX_ACH3_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH3_TXBD_DESA_H 0x112C
#define B_AX_ACH3_TXBD_DESA_H_SH 0
#define B_AX_ACH3_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH4_TXBD_DESA_L 0x1130
#define B_AX_ACH4_TXBD_DESA_L_SH 0
#define B_AX_ACH4_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH4_TXBD_DESA_H 0x1134
#define B_AX_ACH4_TXBD_DESA_H_SH 0
#define B_AX_ACH4_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH5_TXBD_DESA_L 0x1138
#define B_AX_ACH5_TXBD_DESA_L_SH 0
#define B_AX_ACH5_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH5_TXBD_DESA_H 0x113C
#define B_AX_ACH5_TXBD_DESA_H_SH 0
#define B_AX_ACH5_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH6_TXBD_DESA_L 0x1140
#define B_AX_ACH6_TXBD_DESA_L_SH 0
#define B_AX_ACH6_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH6_TXBD_DESA_H 0x1144
#define B_AX_ACH6_TXBD_DESA_H_SH 0
#define B_AX_ACH6_TXBD_DESA_H_MSK 0xff

#define R_AX_ACH7_TXBD_DESA_L 0x1148
#define B_AX_ACH7_TXBD_DESA_L_SH 0
#define B_AX_ACH7_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH7_TXBD_DESA_H 0x114C
#define B_AX_ACH7_TXBD_DESA_H_SH 0
#define B_AX_ACH7_TXBD_DESA_H_MSK 0xff

#define R_AX_CH8_TXBD_DESA_L 0x1150
#define B_AX_CH8_TXBD_DESA_L_SH 0
#define B_AX_CH8_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH8_TXBD_DESA_H 0x1154
#define B_AX_CH8_TXBD_DESA_H_SH 0
#define B_AX_CH8_TXBD_DESA_H_MSK 0xff

#define R_AX_CH9_TXBD_DESA_L 0x1158
#define B_AX_CH9_TXBD_DESA_L_SH 0
#define B_AX_CH9_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH9_TXBD_DESA_H 0x115C
#define B_AX_CH9_TXBD_DESA_H_SH 0
#define B_AX_CH9_TXBD_DESA_H_MSK 0xff

#define R_AX_CH12_TXBD_DESA_L 0x1160
#define B_AX_CH12_TXBD_DESA_L_SH 0
#define B_AX_CH12_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH12_TXBD_DESA_H 0x1164
#define B_AX_CH12_TXBD_DESA_H_SH 0
#define B_AX_CH12_TXBD_DESA_H_MSK 0xff

#define R_AX_PCIE_DBG_CTRL 0x11C0
#define B_AX_PCIE_DBG_SEL_SH 13
#define B_AX_PCIE_DBG_SEL_MSK 0x7
#define B_AX_MRD_TIMEOUT_EN BIT(10)
#define B_AX_ASFF_FULL_NO_STK BIT(1)
#define B_AX_EN_STUCK_DBG BIT(0)

#define R_AX_DBG_ERR_FLAG 0x11C4
#define B_AX_PCIE_RPQ_FULL BIT(29)
#define B_AX_PCIE_RXQ_FULL BIT(28)
#define B_AX_CPL_STATUS_SH 25
#define B_AX_CPL_STATUS_MSK 0x7
#define B_AX_RX_STUCK BIT(22)
#define B_AX_TX_STUCK BIT(21)
#define B_AX_PCIEDBG_TXERR0 BIT(16)
#define B_AX_PCIE_RXP1_ERR0 BIT(4)
#define B_AX_PCIE_TXBD_LEN0 BIT(1)
#define B_AX_PCIE_TXBD_4KBOUD_LENERR BIT(0)

#define R_AX_PCIE_LPWR_DBG 0x11C8
#define B_AX_PCIE_L1_COND_WP_EMPY BIT(12)
#define B_AX_PCIE_L1_COND_PHY_TXON BIT(11)
#define B_AX_PCIE_L1_COND_CFG_SPC BIT(10)
#define B_AX_PCIE_L1_COND_MAC_REG BIT(9)
#define B_AX_PCIE_L1_COND_HISR BIT(8)
#define B_AX_PCIE_L1_COND_RX BIT(7)
#define B_AX_PCIE_L1_COND_TX BIT(6)
#define B_AX_PCIE_L1_COND_HDP_RX BIT(5)
#define B_AX_PCIE_L1_COND_LTR BIT(4)
#define B_AX_PCIE_L1_COND_FORC_L0 BIT(3)
#define B_AX_PCIE_L1_COND_WD_EMPY BIT(2)
#define B_AX_PCIE_L1_COND_TXFLAG1 BIT(1)
#define B_AX_PCIE_L1_COND_TXFLAG0 BIT(0)

#define R_AX_STC_INT_CS 0x11D0
#define B_AX_STC_INT_EN BIT(31)
#define B_AX_STC_INT_FLAG_SH 16
#define B_AX_STC_INT_FLAG_MSK 0xff
#define B_AX_STC_INT_IDX_SH 8
#define B_AX_STC_INT_IDX_MSK 0x7
#define B_AX_STC_INT_REALTIME_CS_SH 0
#define B_AX_STC_INT_REALTIME_CS_MSK 0x3f

#define R_AX_ST_INT_CFG 0x11D4
#define B_AX_STC_INT_GRP_EN BIT(31)
#define B_AX_STC_INT_EXPECT_LS_SH 8
#define B_AX_STC_INT_EXPECT_LS_MSK 0x3f
#define B_AX_STC_INT_EXPECT_CS_SH 0
#define B_AX_STC_INT_EXPECT_CS_MSK 0x3f

#define R_AX_LBC_WATCHDOG 0x11D8
#define B_AX_LBC_ADDR_SH 10
#define B_AX_LBC_ADDR_MSK 0x3ffff
#define B_AX_LBC_TIMER_SH 4
#define B_AX_LBC_TIMER_MSK 0xf
#define B_AX_LBC_FLAG BIT(1)
#define B_AX_LBC_EN BIT(0)

#define R_AX_DEBUG_STATE1 0x11E0
#define B_AX_DEBUG_STATE1_SH 0
#define B_AX_DEBUG_STATE1_MSK 0xffffffffL

#define R_AX_DEBUG_STATE2 0x11E4
#define B_AX_DEBUG_STATE2_SH 0
#define B_AX_DEBUG_STATE2_MSK 0xffffffffL

#define R_AX_DEBUG_STATE3 0x11E8
#define B_AX_DEBUG_STATE3_SH 0
#define B_AX_DEBUG_STATE3_MSK 0xffffffffL

#define R_AX_ACH0_BDRAM_CTRL 0x1200
#define B_AX_ACH0_BDRAM_MIN_SH 16
#define B_AX_ACH0_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH0_BDRAM_MAX_SH 8
#define B_AX_ACH0_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH0_BDRAM_SIDX_SH 0
#define B_AX_ACH0_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH1_BDRAM_CTRL 0x1204
#define B_AX_ACH1_BDRAM_MIN_SH 16
#define B_AX_ACH1_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH1_BDRAM_MAX_SH 8
#define B_AX_ACH1_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH1_BDRAM_SIDX_SH 0
#define B_AX_ACH1_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH2_BDRAM_CTRL 0x1208
#define B_AX_ACH2_BDRAM_MIN_SH 16
#define B_AX_ACH2_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH2_BDRAM_MAX_SH 8
#define B_AX_ACH2_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH2_BDRAM_SIDX_SH 0
#define B_AX_ACH2_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH3_BDRAM_CTRL 0x120C
#define B_AX_ACH3_BDRAM_MIN_SH 16
#define B_AX_ACH3_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH3_BDRAM_MAX_SH 8
#define B_AX_ACH3_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH3_BDRAM_SIDX_SH 0
#define B_AX_ACH3_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH4_BDRAM_CTRL 0x1210
#define B_AX_ACH4_BDRAM_MIN_SH 16
#define B_AX_ACH4_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH4_BDRAM_MAX_SH 8
#define B_AX_ACH4_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH4_BDRAM_SIDX_SH 0
#define B_AX_ACH4_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH5_BDRAM_CTRL 0x1214
#define B_AX_ACH5_BDRAM_MIN_SH 16
#define B_AX_ACH5_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH5_BDRAM_MAX_SH 8
#define B_AX_ACH5_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH5_BDRAM_SIDX_SH 0
#define B_AX_ACH5_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH6_BDRAM_CTRL 0x1218
#define B_AX_ACH6_BDRAM_MIN_SH 16
#define B_AX_ACH6_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH6_BDRAM_MAX_SH 8
#define B_AX_ACH6_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH6_BDRAM_SIDX_SH 0
#define B_AX_ACH6_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH7_BDRAM_CTRL 0x121C
#define B_AX_ACH7_BDRAM_MIN_SH 16
#define B_AX_ACH7_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH7_BDRAM_MAX_SH 8
#define B_AX_ACH7_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH7_BDRAM_SIDX_SH 0
#define B_AX_ACH7_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH8_BDRAM_CTRL 0x1220
#define B_AX_CH8_BDRAM_MIN_SH 16
#define B_AX_CH8_BDRAM_MIN_MSK 0x3f
#define B_AX_CH8_BDRAM_MAX_SH 8
#define B_AX_CH8_BDRAM_MAX_MSK 0x3f
#define B_AX_CH8_BDRAM_SIDX_SH 0
#define B_AX_CH8_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH9_BDRAM_CTRL 0x1224
#define B_AX_CH9_BDRAM_MIN_SH 16
#define B_AX_CH9_BDRAM_MIN_MSK 0x3f
#define B_AX_CH9_BDRAM_MAX_SH 8
#define B_AX_CH9_BDRAM_MAX_MSK 0x3f
#define B_AX_CH9_BDRAM_SIDX_SH 0
#define B_AX_CH9_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH12_BDRAM_CTRL 0x1228
#define B_AX_CH12_BDRAM_MIN_SH 16
#define B_AX_CH12_BDRAM_MIN_MSK 0x3f
#define B_AX_CH12_BDRAM_MAX_SH 8
#define B_AX_CH12_BDRAM_MAX_MSK 0x3f
#define B_AX_CH12_BDRAM_SIDX_SH 0
#define B_AX_CH12_BDRAM_SIDX_MSK 0x3f

#define R_AX_ACH0_BDRAM_RWPTR 0x1230
#define B_AX_ACH0_BDRAM_WPTR_SH 8
#define B_AX_ACH0_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH0_BDRAM_RPTR_SH 0
#define B_AX_ACH0_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH1_BDRAM_RWPTR 0x1232
#define B_AX_ACH1_BDRAM_WPTR_SH 8
#define B_AX_ACH1_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH1_BDRAM_RPTR_SH 0
#define B_AX_ACH1_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH2_BDRAM_RWPTR 0x1234
#define B_AX_ACH2_BDRAM_WPTR_SH 8
#define B_AX_ACH2_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH2_BDRAM_RPTR_SH 0
#define B_AX_ACH2_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH3_BDRAM_RWPTR 0x1236
#define B_AX_ACH3_BDRAM_WPTR_SH 8
#define B_AX_ACH3_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH3_BDRAM_RPTR_SH 0
#define B_AX_ACH3_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH4_BDRAM_RWPTR 0x1238
#define B_AX_ACH4_BDRAM_WPTR_SH 8
#define B_AX_ACH4_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH4_BDRAM_RPTR_SH 0
#define B_AX_ACH4_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH5_BDRAM_RWPTR 0x123A
#define B_AX_ACH5_BDRAM_WPTR_SH 8
#define B_AX_ACH5_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH5_BDRAM_RPTR_SH 0
#define B_AX_ACH5_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH6_BDRAM_RWPTR 0x123C
#define B_AX_ACH6_BDRAM_WPTR_SH 8
#define B_AX_ACH6_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH6_BDRAM_RPTR_SH 0
#define B_AX_ACH6_BDRAM_RPTR_MSK 0x3f

#define R_AX_ACH7_BDRAM_RWPTR 0x123E
#define B_AX_ACH7_BDRAM_WPTR_SH 8
#define B_AX_ACH7_BDRAM_WPTR_MSK 0x3f
#define B_AX_ACH7_BDRAM_RPTR_SH 0
#define B_AX_ACH7_BDRAM_RPTR_MSK 0x3f

#define R_AX_CH8_BDRAM_RWPTR 0x1240
#define B_AX_CH8_BDRAM_WPTR_SH 8
#define B_AX_CH8_BDRAM_WPTR_MSK 0x3f
#define B_AX_CH8_BDRAM_RPTR_SH 0
#define B_AX_CH8_BDRAM_RPTR_MSK 0x3f

#define R_AX_CH9_BDRAM_RWPTR 0x1242
#define B_AX_CH9_BDRAM_WPTR_SH 8
#define B_AX_CH9_BDRAM_WPTR_MSK 0x3f
#define B_AX_CH9_BDRAM_RPTR_SH 0
#define B_AX_CH9_BDRAM_RPTR_MSK 0x3f

#define R_AX_CH12_BDRAM_RWPTR 0x1244
#define B_AX_CH12_BDRAM_WPTR_SH 8
#define B_AX_CH12_BDRAM_WPTR_MSK 0x3f
#define B_AX_CH12_BDRAM_RPTR_SH 0
#define B_AX_CH12_BDRAM_RPTR_MSK 0x3f

#define R_AX_PCIE_DMA_STOP2 0x1310
#define B_AX_STOP_CH11 BIT(1)
#define B_AX_STOP_CH10 BIT(0)

#define R_AX_TXBD_RWPTR_CLR2 0x1314
#define B_AX_CLR_CH11_IDX BIT(1)
#define B_AX_CLR_CH10_IDX BIT(0)

#define R_AX_PCIE_DMA_BUSY2 0x131C
#define B_AX_CH11_BUSY BIT(1)
#define B_AX_CH10_BUSY BIT(0)

#define R_AX_CH10_BDRAM_CTRL 0x1320
#define B_AX_ACH10_BDRAM_MIN_SH 16
#define B_AX_ACH10_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH10_BDRAM_MAX_SH 8
#define B_AX_ACH10_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH10_BDRAM_SIDX_SH 0
#define B_AX_ACH10_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH11_BDRAM_CTRL 0x1324
#define B_AX_ACH11_BDRAM_MIN_SH 16
#define B_AX_ACH11_BDRAM_MIN_MSK 0x3f
#define B_AX_ACH11_BDRAM_MAX_SH 8
#define B_AX_ACH11_BDRAM_MAX_MSK 0x3f
#define B_AX_ACH11_BDRAM_SIDX_SH 0
#define B_AX_ACH11_BDRAM_SIDX_MSK 0x3f

#define R_AX_CH10_TXBD_NUM 0x1338
#define B_AX_PCIE_CH10_FLAG BIT(14)
#define B_AX_CH10_DESC_NUM_SH 0
#define B_AX_CH10_DESC_NUM_MSK 0x3ff

#define R_AX_CH11_TXBD_NUM 0x133A
#define B_AX_PCIE_CH11_FLAG BIT(14)
#define B_AX_CH11_DESC_NUM_SH 0
#define B_AX_CH11_DESC_NUM_MSK 0x3ff

#define R_AX_CH10_BDRAM_RWPTR 0x1340
#define B_AX_CH10_BDRAM_WPTR_SH 8
#define B_AX_CH10_BDRAM_WPTR_MSK 0x3f
#define B_AX_CH10_BDRAM_RPTR_SH 0
#define B_AX_CH10_BDRAM_RPTR_MSK 0x3f

#define R_AX_CH11_BDRAM_RWPTR 0x1342
#define B_AX_CH11_BDRAM_WPTR_SH 8
#define B_AX_CH11_BDRAM_WPTR_MSK 0x3f
#define B_AX_CH11_BDRAM_RPTR_SH 0
#define B_AX_CH11_BDRAM_RPTR_MSK 0x3f

#define R_AX_CH10_TXBD_DESA_L 0x1358
#define B_AX_CH10_TXBD_DESA_L_SH 0
#define B_AX_CH10_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH10_TXBD_DESA_H 0x135C
#define B_AX_CH10_TXBD_DESA_H_SH 0
#define B_AX_CH10_TXBD_DESA_H_MSK 0xff

#define R_AX_CH11_TXBD_DESA_L 0x1360
#define B_AX_CH11_TXBD_DESA_L_SH 0
#define B_AX_CH11_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH11_TXBD_DESA_H 0x1364
#define B_AX_CH11_TXBD_DESA_H_SH 0
#define B_AX_CH11_TXBD_DESA_H_MSK 0xff

#define R_AX_CH10_TXBD_IDX 0x137C
#define B_AX_CH10_HW_IDX_SH 16
#define B_AX_CH10_HW_IDX_MSK 0x3ff
#define B_AX_CH10_HOST_IDX_SH 0
#define B_AX_CH10_HOST_IDX_MSK 0x3ff

#define R_AX_CH11_TXBD_IDX 0x1380
#define B_AX_CH11_HW_IDX_SH 16
#define B_AX_CH11_HW_IDX_MSK 0x3ff
#define B_AX_CH11_HOST_IDX_SH 0
#define B_AX_CH11_HOST_IDX_MSK 0x3ff

#define R_AX_PCIE_HIMR10 0x13B0
#define B_AX_HC10ISR_IND_INT_EN BIT(28)
#define B_AX_TXDMA_CH11_INT_EN BIT(12)
#define B_AX_TXDMA_CH10_INT_EN BIT(11)

#define R_AX_PCIE_HISR10 0x13B4
#define B_AX_HC10ISR_IND_INT BIT(28)
#define B_AX_TXDMA_CH11_INT BIT(12)
#define B_AX_TXDMA_CH10_INT BIT(11)

#define R_AX_PCIE_EXP_CTRL 0x13F0
#define B_AX_EN_CHKDSC_NO_RX_STUCK BIT(20)
#define B_AX_MAX_TAG_NUM_SH 16
#define B_AX_MAX_TAG_NUM_MSK 0x7
#define B_AX_RET_STICKY_RST_N_KEEP_REG_PERST BIT(14)
#define B_AX_RET_NON_STICKY_RST_N_KEEP_REG_PERST BIT(13)
#define B_AX_RET_NON_STICKY_RST_N_KEEP_REG_LINKRST BIT(12)
#define B_AX_EN_LAT_PHYSTATUS BIT(11)
#define B_AX_EN_OLD_WAKE_MODE BIT(10)
#define B_AX_EN_TIMEOUT_T_PCLKACK BIT(9)
#define B_AX_EN_DIS_IO_MEM_EN BIT(8)
#define B_AX_FORCE_REG_CLK_EN BIT(5)
#define B_AX_SIC_EN_FORCE_CLKREQ BIT(4)
#define B_AX_DIS_L1_2_SUS BIT(3)
#define B_AX_IB_EN_FORCE BIT(2)
#define B_AX_PCIE_ACTIVE_FORCE BIT(1)

#define R_AX_PCIE_RX_PREF_ADV 0x13F4
#define B_AX_RXDMA_PREF_ADV_TH_SH 1
#define B_AX_RXDMA_PREF_ADV_TH_MSK 0x3
#define B_AX_RXDMA_PREF_ADV_EN BIT(0)

//
// WL_AX_Reg_PCIE.xls
//

//
// PCIE
//
#define B_AX_EN_CHKDSC_NO_RX_STUCK_V1 BIT(2)

#define R_AX_ACH0_BDRAM_CTRL_V2 0x1200
#define B_AX_ACH0_BDRAM_MIN_V2_SH 16
#define B_AX_ACH0_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH0_BDRAM_MAX_V2_SH 8
#define B_AX_ACH0_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH0_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH0_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH1_BDRAM_CTRL_V2 0x1204
#define B_AX_ACH1_BDRAM_MIN_V2_SH 16
#define B_AX_ACH1_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH1_BDRAM_MAX_V2_SH 8
#define B_AX_ACH1_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH1_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH1_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH2_BDRAM_CTRL_V2 0x1208
#define B_AX_ACH2_BDRAM_MIN_V2_SH 16
#define B_AX_ACH2_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH2_BDRAM_MAX_V2_SH 8
#define B_AX_ACH2_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH2_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH2_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH3_BDRAM_CTRL_V2 0x120C
#define B_AX_ACH3_BDRAM_MIN_V2_SH 16
#define B_AX_ACH3_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH3_BDRAM_MAX_V2_SH 8
#define B_AX_ACH3_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH3_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH3_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH4_BDRAM_CTRL_V2 0x1210
#define B_AX_ACH4_BDRAM_MIN_V2_SH 16
#define B_AX_ACH4_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH4_BDRAM_MAX_V2_SH 8
#define B_AX_ACH4_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH4_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH4_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH5_BDRAM_CTRL_V2 0x1214
#define B_AX_ACH5_BDRAM_MIN_V2_SH 16
#define B_AX_ACH5_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH5_BDRAM_MAX_V2_SH 8
#define B_AX_ACH5_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH5_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH5_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH6_BDRAM_CTRL_V2 0x1218
#define B_AX_ACH6_BDRAM_MIN_V2_SH 16
#define B_AX_ACH6_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH6_BDRAM_MAX_V2_SH 8
#define B_AX_ACH6_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH6_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH6_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH7_BDRAM_CTRL_V2 0x121C
#define B_AX_ACH7_BDRAM_MIN_V2_SH 16
#define B_AX_ACH7_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH7_BDRAM_MAX_V2_SH 8
#define B_AX_ACH7_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH7_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH7_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_CH8_BDRAM_CTRL_V2 0x1220
#define B_AX_CH8_BDRAM_MIN_V2_SH 16
#define B_AX_CH8_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_CH8_BDRAM_MAX_V2_SH 8
#define B_AX_CH8_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_CH8_BDRAM_SIDX_V2_SH 0
#define B_AX_CH8_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_CH9_BDRAM_CTRL_V2 0x1224
#define B_AX_CH9_BDRAM_MIN_V2_SH 16
#define B_AX_CH9_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_CH9_BDRAM_MAX_V2_SH 8
#define B_AX_CH9_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_CH9_BDRAM_SIDX_V2_SH 0
#define B_AX_CH9_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_CH12_BDRAM_CTRL_V2 0x1228
#define B_AX_CH12_BDRAM_MIN_V2_SH 16
#define B_AX_CH12_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_CH12_BDRAM_MAX_V2_SH 8
#define B_AX_CH12_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_CH12_BDRAM_SIDX_V2_SH 0
#define B_AX_CH12_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_ACH0_BDRAM_RWPTR_V2 0x1230
#define B_AX_ACH0_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH0_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH0_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH0_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH1_BDRAM_RWPTR_V2 0x1232
#define B_AX_ACH1_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH1_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH1_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH1_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH2_BDRAM_RWPTR_V2 0x1234
#define B_AX_ACH2_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH2_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH2_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH2_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH3_BDRAM_RWPTR_V2 0x1236
#define B_AX_ACH3_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH3_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH3_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH3_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH4_BDRAM_RWPTR_V2 0x1238
#define B_AX_ACH4_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH4_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH4_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH4_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH5_BDRAM_RWPTR_V2 0x123A
#define B_AX_ACH5_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH5_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH5_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH5_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH6_BDRAM_RWPTR_V2 0x123C
#define B_AX_ACH6_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH6_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH6_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH6_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_ACH7_BDRAM_RWPTR_V2 0x123E
#define B_AX_ACH7_BDRAM_WPTR_V2_SH 8
#define B_AX_ACH7_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_ACH7_BDRAM_RPTR_V2_SH 0
#define B_AX_ACH7_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_CH8_BDRAM_RWPTR_V2 0x1240
#define B_AX_CH8_BDRAM_WPTR_V2_SH 8
#define B_AX_CH8_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_CH8_BDRAM_RPTR_V2_SH 0
#define B_AX_CH8_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_CH9_BDRAM_RWPTR_V2 0x1242
#define B_AX_CH9_BDRAM_WPTR_V2_SH 8
#define B_AX_CH9_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_CH9_BDRAM_RPTR_V2_SH 0
#define B_AX_CH9_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_CH12_BDRAM_RWPTR_V2 0x1244
#define B_AX_CH12_BDRAM_WPTR_V2_SH 8
#define B_AX_CH12_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_CH12_BDRAM_RPTR_V2_SH 0
#define B_AX_CH12_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_CH11_BDRAM_CTRL_V2 0x1324
#define B_AX_ACH11_BDRAM_MIN_V2_SH 16
#define B_AX_ACH11_BDRAM_MIN_V2_MSK 0x1f
#define B_AX_ACH11_BDRAM_MAX_V2_SH 8
#define B_AX_ACH11_BDRAM_MAX_V2_MSK 0x1f
#define B_AX_ACH11_BDRAM_SIDX_V2_SH 0
#define B_AX_ACH11_BDRAM_SIDX_V2_MSK 0x1f

#define R_AX_CH10_BDRAM_RWPTR_V2 0x1340
#define B_AX_CH10_BDRAM_WPTR_V2_SH 8
#define B_AX_CH10_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_CH10_BDRAM_RPTR_V2_SH 0
#define B_AX_CH10_BDRAM_RPTR_V2_MSK 0x1f

#define R_AX_CH11_BDRAM_RWPTR_V2 0x1342
#define B_AX_CH11_BDRAM_WPTR_V2_SH 8
#define B_AX_CH11_BDRAM_WPTR_V2_MSK 0x1f
#define B_AX_CH11_BDRAM_RPTR_V2_SH 0
#define B_AX_CH11_BDRAM_RPTR_V2_MSK 0x1f

//
// WL_AX_Reg_PCIE.xls
//

//
// PCIE
//

#define R_AX_PCIE_TOG_RST 0x3000
#define B_AX_PCIE_INTX_EN BIT(29)
#define B_AX_PCIE_TOG_ELBI_RST BIT(13)
#define B_AX_PCIE_TOG_WLAN_FLR_RST BIT(12)
#define B_AX_PCIE_TOG_REG_FLR_RST BIT(11)
#define B_AX_PCIE_TOG_REG_RST BIT(10)
#define B_AX_PCIE_TOG_ANA_RST BIT(9)
#define B_AX_PCIE_TOG_WLAN_RST BIT(8)
#define B_AX_PCIE_TOG_FLR_RST BIT(7)
#define B_AX_PCIE_TOG_RET_NON_STKY_RST BIT(6)
#define B_AX_PCIE_TOG_RET_STKY_RST BIT(5)
#define B_AX_PCIE_TOG_NON_STKY_RST BIT(4)
#define B_AX_PCIE_TOG_STKY_RST BIT(3)
#define B_AX_PCIE_TOG_RET_CORE_RST BIT(2)
#define B_AX_PCIE_TOG_PWR_RST BIT(1)
#define B_AX_PCIE_TOG_PERST_RST BIT(0)

#define R_AX_PCIE_FRZ_CLK 0x3004
#define B_AX_PCIE_FRZ_ELBI_RST BIT(29)
#define B_AX_PCIE_FRZ_WLAN_FLR_RST BIT(28)
#define B_AX_PCIE_FRZ_REG_FLR_RST BIT(27)
#define B_AX_PCIE_FRZ_REG_RST BIT(26)
#define B_AX_PCIE_FRZ_ANA_RST BIT(25)
#define B_AX_PCIE_FRZ_WLAN_RST BIT(24)
#define B_AX_PCIE_FRZ_FLR_RST BIT(23)
#define B_AX_PCIE_FRZ_RET_NON_STKY_RST BIT(22)
#define B_AX_PCIE_FRZ_RET_STKY_RST BIT(21)
#define B_AX_PCIE_FRZ_NON_STKY_RST BIT(20)
#define B_AX_PCIE_FRZ_STKY_RST BIT(19)
#define B_AX_PCIE_FRZ_RET_CORE_RST BIT(18)
#define B_AX_PCIE_FRZ_PWR_RST BIT(17)
#define B_AX_PCIE_FRZ_PERST_RST BIT(16)
#define B_AX_PCIE_DBG_CLK BIT(4)
#define B_AX_PCIE_EN_CLK BIT(3)
#define B_AX_PCIE_DBI_ACLK_ACT BIT(2)
#define B_AX_PCIE_S1_ACLK_ACT BIT(1)
#define B_AX_PCIE_EN_AUX_CLK BIT(0)

#define R_AX_PCIE_PS_CTRL_V1 0x3008
#define B_AX_CMAC_EXIT_L1_EN BIT(7)
#define B_AX_DMAC0_EXIT_L1_EN BIT(6)
#define B_AX_SEL_XFER_PENDING BIT(3)
#define B_AX_SEL_REQ_ENTR_L1 BIT(2)
#define B_AX_SEL_REQ_EXIT_L1 BIT(0)

#define R_AX_PCIE_MIX_CFG_V1 0x300C
#define B_AX_ASPM_CTRL_SH 16
#define B_AX_ASPM_CTRL_MSK 0x3
#define B_AX_XFER_PENDING_FW BIT(11)
#define B_AX_XFER_PENDING BIT(10)
#define B_AX_REQ_EXIT_L1 BIT(9)
#define B_AX_REQ_ENTR_L1 BIT(8)
#define B_AX_L1SUB_DISABLE BIT(0)

#define R_AX_L1_CLK_CTRL 0x3010
#define B_AX_RAS_SD_HOLD_LTSSM BIT(12)
#define B_AX_RAS_TBA_CTRL_SH 8
#define B_AX_RAS_TBA_CTRL_MSK 0x3
#define B_AX_CLK_REQ_N BIT(1)
#define B_AX_CLK_PM_EN BIT(0)

#define R_AX_PCIE_MAILBOX 0x3014
#define B_AX_PCIE_MAILBOX_SH 0
#define B_AX_PCIE_MAILBOX_MSK 0xffffffffL

#define R_AX_AWMISC_INFO 0x3020
#define B_AX_INFO_SILENT_DROP BIT(25)
#define B_AX_INFO_EP BIT(24)
#define B_AX_AWMISC_INFO_SH 0
#define B_AX_AWMISC_INFO_MSK 0x3fffff

#define R_AX_AWMISC_INFO_L 0x3024
#define B_AX_AWMISIC_INFO_L_SH 0
#define B_AX_AWMISIC_INFO_L_MSK 0xffffffffL

#define R_AX_AWMISC_INFO_H 0x3028
#define B_AX_AWMISC_INFO_H_SH 0
#define B_AX_AWMISC_INFO_H_MSK 0xffffffffL

#define R_AX_AWMISC_INFO_TAG 0x302C
#define B_AX_AWMISC_INFO_TAG_SH 0
#define B_AX_AWMISC_INFO_TAG_MSK 0xff

#define R_AX_ARMISC_INFO 0x3030
#define B_AX_ARMISC_INFO_SH 0
#define B_AX_ARMISC_INFO_MSK 0x3fffff

#define R_AX_PCIE_BG_CLR 0x303C
#define B_AX_BG_CLR_APB_S0 BIT(15)
#define B_AX_BG_CLR_ASYNC_APB_S0 BIT(14)
#define B_AX_BG_CLR_APB_REG BIT(13)
#define B_AX_BG_CLR_ASYNC_APB_REG BIT(12)
#define B_AX_BG_CLR_M0 BIT(11)
#define B_AX_BG_CLR_ASYNC_M0 BIT(10)
#define B_AX_BG_CLR_M1 BIT(9)
#define B_AX_BG_CLR_ASYNC_M1 BIT(8)
#define B_AX_BG_CLR_M2 BIT(7)
#define B_AX_BG_CLR_ASYNC_M2 BIT(6)
#define B_AX_BG_CLR_M3 BIT(5)
#define B_AX_BG_CLR_ASYNC_M3 BIT(4)
#define B_AX_IO8_BG_CLR BIT(3)
#define B_AX_IO8_BG_CLR_ASYNC BIT(2)

#define R_AX_DBI_ADDR_SEL 0x3040
#define B_AX_DBI_ADDR_SEL_SH 12
#define B_AX_DBI_ADDR_SEL_MSK 0xfffff

#define R_AX_PCIE_LAT_CTRL 0x3044
#define B_AX_SYS_SUS_L12_EN BIT(17)
#define B_AX_MDIO_S_EN BIT(16)
#define B_AX_LDO_T3_LAT_SH 12
#define B_AX_LDO_T3_LAT_MSK 0x7
#define B_AX_VMAIN_LAT_SH 8
#define B_AX_VMAIN_LAT_MSK 0x7
#define B_AX_CLK_REQ_LAT_SH 4
#define B_AX_CLK_REQ_LAT_MSK 0xf
#define B_AX_CLK_REQ_SEL_OPT BIT(1)
#define B_AX_CLK_REQ_SEL BIT(0)

#define R_AX_PCIE_HIMR00_V1 0x30B0
#define B_AX_HCI_AXIDMA_INT_EN BIT(29)
#define B_AX_HC00ISR_IND_INT_EN_V1 BIT(28)
#define B_AX_HD1ISR_IND_INT_EN_V1 BIT(27)
#define B_AX_HD0ISR_IND_INT_EN_V1 BIT(26)
#define B_AX_HS1ISR_IND_INT_EN BIT(25)
#define B_AX_PCIE_DBG_STE_INT_EN BIT(13)

#define R_AX_PCIE_HISR00_V1 0x30B4
#define B_AX_HCI_AXIDMA_INT BIT(29)
#define B_AX_HC00ISR_IND_INT_V1 BIT(28)
#define B_AX_HD1ISR_IND_INT_V1 BIT(27)
#define B_AX_HD0ISR_IND_INT_V1 BIT(26)
#define B_AX_HS1ISR_IND_INT BIT(25)
#define B_AX_PCIE_DBG_STE_INT BIT(13)

#define R_AX_PCIE_HRPWM_V1 0x30C0

#define R_AX_PCIE_CRPWM 0x30C4
#define B_AX_PCIE_CRPWM_SH 0
#define B_AX_PCIE_CRPWM_MSK 0xffff

#define R_AX_LBC_WATCHDOG_V1 0x30D8
#define B_AX_LBC_ADDR_V1_SH 10
#define B_AX_LBC_ADDR_V1_MSK 0x3ffff
#define B_AX_LBC_TIMER_V1_SH 4
#define B_AX_LBC_TIMER_V1_MSK 0xf
#define B_AX_LBC_FLAG_V1 BIT(1)
#define B_AX_LBC_EN_V1 BIT(0)

#define R_AX_PCIE_HIMR10_V1 0x30E0
#define B_AX_HC10ISR_IND_INT_EN_V1 BIT(28)

#define R_AX_PCIE_HISR10_V1 0x30E4
#define B_AX_HC10ISR_IND_INT_V1 BIT(28)

#define R_AX_PCIE_EXP_CTRL_V1 0x30F0
#define B_AX_PCIE_ACTIVE_FORCE_V1 BIT(1)
#define B_AX_PCIE_BIAS_FORCE_V1 BIT(0)

#define R_AX_TSFTIMER_HCI_V1 0x30FC

#define R_AX_PCIE_IO_RCY_M1 0x3100
#define B_AX_PCIE_IO_RCY_P_M1 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_P_M1 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_M1 BIT(3)
#define B_AX_PCIE_IO_RCY_TRIG_M1 BIT(0)

#define R_AX_PCIE_WDT_TIMER_M1 0x3104
#define B_AX_PCIE_WDT_TIMER_M1_SH 0
#define B_AX_PCIE_WDT_TIMER_M1_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_M1 0x3108
#define B_AX_PCIE_PADDR_M1_SH 0
#define B_AX_PCIE_PADDR_M1_MSK 0xffffffffL

#define R_AX_PCIE_IO_RCY_M2 0x310C
#define B_AX_PCIE_IO_RCY_P_M2 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_P_M2 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_M2 BIT(3)
#define B_AX_PCIE_IO_RCY_TRIG_M2 BIT(0)

#define R_AX_PCIE_WDT_TIMER_M2 0x3110
#define B_AX_PCIE_WDT_TIMER_M2_SH 0
#define B_AX_PCIE_WDT_TIMER_M2_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_M2 0x3114
#define B_AX_PCIE_PADDR_M2_SH 0
#define B_AX_PCIE_PADDR_M2_MSK 0xffffffffL

#define R_AX_PCIE_IO_RCY_E0 0x3118
#define B_AX_PCIE_IO_RCY_P_E0 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_P_E0 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_E0 BIT(3)
#define B_AX_PCIE_IO_RCY_TRIG_E0 BIT(0)

#define R_AX_PCIE_WDT_TIMER_E0 0x311C
#define B_AX_PCIE_WDT_TIMER_E0_SH 0
#define B_AX_PCIE_WDT_TIMER_E0_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_E0 0x3120
#define B_AX_PCIE_PADDR_E0_SH 0
#define B_AX_PCIE_PADDR_E0_MSK 0xffffffffL

#define R_AX_PCIE_IO_RCY_S1 0x3124
#define B_AX_PCIE_IO_RCY_RP_S1 BIT(7)
#define B_AX_PCIE_IO_RCY_WP_S1 BIT(6)
#define B_AX_PCIE_IO_RCY_WDT_RP_S1 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_WP_S1 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_S1 BIT(3)
#define B_AX_PCIE_IO_RCY_RTRIG_S1 BIT(1)
#define B_AX_PCIE_IO_RCY_WTRIG_S1 BIT(0)

#define R_AX_PCIE_WDT_TIMER_S1 0x3128
#define B_AX_PCIE_WDT_TIMER_S1_SH 0
#define B_AX_PCIE_WDT_TIMER_S1_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_W_S1 0x312C
#define B_AX_PCIE_PADDR_W_S1_SH 0
#define B_AX_PCIE_PADDR_W_S1_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_R_S1 0x3130
#define B_AX_PCIE_PADDR_R_S1_SH 0
#define B_AX_PCIE_PADDR_R_S1_MSK 0xffffffffL

#define R_AX_PCIE_DBG_MODE 0x31C0
#define B_AX_PCIE_DBG_MODE_SH 16
#define B_AX_PCIE_DBG_MODE_MSK 0x3f

#define R_AX_PCIE_DBG_GPO 0x31C4
#define B_AX_PCIE_DBG_GPO_SH 0
#define B_AX_PCIE_DBG_GPO_MSK 0xffffffffL

#define R_AX_PCIE_DBG_INFO 0x31C8
#define B_AX_PCIE_DBG_INFO_SH 0
#define B_AX_PCIE_DBG_INFO_MSK 0xffffffffL

#define R_AX_PCIE_DBG_STATE 0x31D0
#define B_AX_PCIE_DBG_STATE_MODE_SH 8
#define B_AX_PCIE_DBG_STATE_MODE_MSK 0x7
#define B_AX_PCIE_DBG_STATE_GRP_SH 4
#define B_AX_PCIE_DBG_STATE_GRP_MSK 0x7
#define B_AX_PCIE_DBG_STATE_MSK BIT(2)
#define B_AX_PCIE_DBG_STATE_CLR BIT(1)
#define B_AX_PCIE_DBG_STATE_SET BIT(0)

#define R_AX_PCIE_DBG_STATE_D 0x31D4
#define B_AX_PCIE_DBG_STATE_D3_SH 16
#define B_AX_PCIE_DBG_STATE_D3_MSK 0x7f
#define B_AX_PCIE_DBG_STATE_D2_SH 8
#define B_AX_PCIE_DBG_STATE_D2_MSK 0x7f
#define B_AX_PCIE_DBG_STATE_D1_SH 0
#define B_AX_PCIE_DBG_STATE_D1_MSK 0x7f

#define R_AX_PCIE_DBG_INFO_D 0x31D8
#define B_AX_PCIE_DBG_INFO_D3_SH 16
#define B_AX_PCIE_DBG_INFO_D3_MSK 0x3f
#define B_AX_PCIE_DBG_INFO_D2_SH 8
#define B_AX_PCIE_DBG_INFO_D2_MSK 0x3f
#define B_AX_PCIE_DBG_INFO_D1_SH 0
#define B_AX_PCIE_DBG_INFO_D1_MSK 0x3f

#define R_AX_PCIE_MIT_TMR 0x3330
#define B_AX_PCIE_MIT_RX_TMR_SH 4
#define B_AX_PCIE_MIT_RX_TMR_MSK 0x3
#define B_AX_PCIE_MIT_TX_TMR_SH 0
#define B_AX_PCIE_MIT_TX_TMR_MSK 0x3

#define R_AX_PCIE_MIT_CNT 0x3334
#define B_AX_PCIE_RX_MIT_CNT_SH 24
#define B_AX_PCIE_RX_MIT_CNT_MSK 0xff
#define B_AX_PCIE_TX_MIT_CNT_SH 16
#define B_AX_PCIE_TX_MIT_CNT_MSK 0xff
#define B_AX_PCIE_RX_MIT_TMR_CNT_SH 8
#define B_AX_PCIE_RX_MIT_TMR_CNT_MSK 0xff
#define B_AX_PCIE_TX_MIT_TMR_CNT_SH 0
#define B_AX_PCIE_TX_MIT_TMR_CNT_MSK 0xff

#define R_AX_PCIE_MIT_CH_EN 0x3338
#define B_AX_PCIE_MIT_RXP2_EN BIT(17)
#define B_AX_PCIE_MIT_RXP1_EN BIT(16)
#define B_AX_PCIE_MIT_TXCH12_EN BIT(12)
#define B_AX_PCIE_MIT_TXCH11_EN BIT(11)
#define B_AX_PCIE_MIT_TXCH10_EN BIT(10)
#define B_AX_PCIE_MIT_TXCH9_EN BIT(9)
#define B_AX_PCIE_MIT_TXCH8_EN BIT(8)
#define B_AX_PCIE_MIT_TXCH7_EN BIT(7)
#define B_AX_PCIE_MIT_TXCH6_EN BIT(6)
#define B_AX_PCIE_MIT_TXCH5_EN BIT(5)
#define B_AX_PCIE_MIT_TXCH4_EN BIT(4)
#define B_AX_PCIE_MIT_TXCH3_EN BIT(3)
#define B_AX_PCIE_MIT_TXCH2_EN BIT(2)
#define B_AX_PCIE_MIT_TXCH1_EN BIT(1)
#define B_AX_PCIE_MIT_TXCH0_EN BIT(0)

#define R_AX_PCIE_MIT_TX_ISR 0x3340
#define B_AX_PCIE_TX_CH12_ISR BIT(12)
#define B_AX_PCIE_TX_CH11_ISR BIT(11)
#define B_AX_PCIE_TX_CH10_ISR BIT(10)
#define B_AX_PCIE_TX_CH9_ISR BIT(9)
#define B_AX_PCIE_TX_CH8_ISR BIT(8)
#define B_AX_PCIE_TX_CH7_ISR BIT(7)
#define B_AX_PCIE_TX_CH6_ISR BIT(6)
#define B_AX_PCIE_TX_CH5_ISR BIT(5)
#define B_AX_PCIE_TX_CH4_ISR BIT(4)
#define B_AX_PCIE_TX_CH3_ISR BIT(3)
#define B_AX_PCIE_TX_CH2_ISR BIT(2)
#define B_AX_PCIE_TX_CH1_ISR BIT(1)
#define B_AX_PCIE_TX_CH0_ISR BIT(0)

#define R_AX_PCIE_MIT_RX_ISR 0x3344
#define B_AX_PCIE_RX_RXP2_ISR BIT(1)
#define B_AX_PCIE_RX_RXP1_ISR BIT(0)

#define R_AX_PCIE_MIT_TX_IMR 0x3348
#define B_AX_PCIE_TX_CH12_IMR BIT(12)
#define B_AX_PCIE_TX_CH11_IMR BIT(11)
#define B_AX_PCIE_TX_CH10_IMR BIT(10)
#define B_AX_PCIE_TX_CH9_IMR BIT(9)
#define B_AX_PCIE_TX_CH8_IMR BIT(8)
#define B_AX_PCIE_TX_CH7_IMR BIT(7)
#define B_AX_PCIE_TX_CH6_IMR BIT(6)
#define B_AX_PCIE_TX_CH5_IMR BIT(5)
#define B_AX_PCIE_TX_CH4_IMR BIT(4)
#define B_AX_PCIE_TX_CH3_IMR BIT(3)
#define B_AX_PCIE_TX_CH2_IMR BIT(2)
#define B_AX_PCIE_TX_CH1_IMR BIT(1)
#define B_AX_PCIE_TX_CH0_IMR BIT(0)

#define R_AX_PCIE_MIT_RX_IMR 0x334C
#define B_AX_PCIE_RX_RXP2_IMR BIT(1)
#define B_AX_PCIE_RX_RXP1_IMR BIT(0)

//
// WL_AX_Reg_PCIE.xls
//

//
// PCIE
//

#define R_AX_PCIE_TX_ISR 0x3340

#define R_AX_PCIE_RX_ISR 0x3344

//
// WL_AX_Reg_Page_SDIO.xls
//

//
// SDIO_Local_Reg_Spec
//

#define R_AX_SDIO_TX_CTRL 0x1000
#define B_AX_SDIO_INT_TIMEOUT_SH 16
#define B_AX_SDIO_INT_TIMEOUT_MSK 0xffff
#define B_AX_IO_ERR_STATUS BIT(15)
#define B_AX_CMD53_W_MIX BIT(14)
#define B_AX_CMD53_TX_FORMAT BIT(13)
#define B_AX_CMD53_R_TIMEOUT_MASK BIT(12)
#define B_AX_CMD53_R_TIMEOUT_UNIT_SH 10
#define B_AX_CMD53_R_TIMEOUT_UNIT_MSK 0x3
#define B_AX_REPLY_ERRCRC_IN_DATA BIT(9)
#define B_AX_EN_CMD53_OVERLAP BIT(8)
#define B_AX_REPLY_ERR_IN_R5 BIT(7)
#define B_AX_R18A_EN BIT(6)
#define B_AX_SDIO_CMD_FORCE_VLD BIT(5)
#define B_AX_INIT_CMD_EN BIT(4)
#define B_AX_RXINT_READ_MASK_DIS BIT(3)
#define B_AX_EN_RXDMA_MASK_INT BIT(2)
#define B_AX_EN_MASK_TIMER BIT(1)
#define B_AX_CMD_ERR_STOP_INT_EN BIT(0)

#define R_AX_SDIO_CTRL 0x1004
#define B_AX_SDIO_DRV_TYPE_D_SH 28
#define B_AX_SDIO_DRV_TYPE_D_MSK 0xf
#define B_AX_SDIO_DRV_TYPE_C_SH 24
#define B_AX_SDIO_DRV_TYPE_C_MSK 0xf
#define B_AX_SDIO_DRV_TYPE_B_SH 20
#define B_AX_SDIO_DRV_TYPE_B_MSK 0xf
#define B_AX_SDIO_DRV_TYPE_A_SH 16
#define B_AX_SDIO_DRV_TYPE_A_MSK 0xf
#define B_AX_SIG_OUT_PH BIT(8)
#define B_AX_CMD11_SEQ_END_DELAY_SH 4
#define B_AX_CMD11_SEQ_END_DELAY_MSK 0xf
#define B_AX_CMD11_SEQ_SAMPLE_INTERVAL_SH 1
#define B_AX_CMD11_SEQ_SAMPLE_INTERVAL_MSK 0x7
#define B_AX_CMD11_SEQ_EN BIT(0)

#define R_AX_SDIO_MONITOR 0x1008
#define B_AX_SDIO_INT_START_SH 0
#define B_AX_SDIO_INT_START_MSK 0xffffffffL

#define R_AX_SDIO_MONITOR_2 0x100C
#define B_AX_CMD53_WT_EN BIT(23)
#define B_AX_SDIO_CLK_MONITOR_SH 21
#define B_AX_SDIO_CLK_MONITOR_MSK 0x3
#define B_AX_SDIO_CLK_CNT_SH 0
#define B_AX_SDIO_CLK_CNT_MSK 0x1fffff

#define R_AX_SDIO_CTRL_2 0x1010
#define B_AX_SDIO_CLK_SMT BIT(1)
#define B_AX_SDIO_DATA_SMT BIT(0)

#define R_AX_SDIO_MONITOR_3 0x1014
#define B_AX_SDIO_USER_DEF_SH 0
#define B_AX_SDIO_USER_DEF_MSK 0xffffffffL

#define R_AX_SDIO_LOCAL_REG 0x1018

#define R_AX_SDIO_HTSFR_INFO 0x1030
#define B_AX_HTSFR0_SH 0
#define B_AX_HTSFR0_MSK 0xffff

#define R_AX_SDIO_INDIRECT_ADDR 0x1040
#define B_AX_INDIRECT_RDY BIT(31)
#define B_AX_INDIRECT_ADDR_SH 0
#define B_AX_INDIRECT_ADDR_MSK 0x7fffffffL

#define R_AX_SDIO_INDIRECT_DATA 0x1044
#define B_AX_INDIRECT_DATA_SH 0
#define B_AX_INDIRECT_DATA_MSK 0xffffffffL

#define R_AX_SDIO_INDIRECT_CTRL 0x1048
#define B_AX_INDIRECT_REG_R BIT(3)
#define B_AX_INDIRECT_REG_W BIT(2)
#define B_AX_INDIRECT_REG_SIZE_SH 0
#define B_AX_INDIRECT_REG_SIZE_MSK 0x3

#define R_AX_SDIO_TRX_STAT 0x1070
#define B_AX_RX_DMA_WRAP_STAT_SH 12
#define B_AX_RX_DMA_WRAP_STAT_MSK 0xf
#define B_AX_RX_DATA_STAGE_STAT_SH 8
#define B_AX_RX_DATA_STAGE_STAT_MSK 0xf
#define B_AX_TX_DMA_WRAP_STAT_SH 4
#define B_AX_TX_DMA_WRAP_STAT_MSK 0xf
#define B_AX_TX_DATA_STAGE_STAT_SH 0
#define B_AX_TX_DATA_STAGE_STAT_MSK 0xf

#define R_AX_SDIO_HRPWM1 0x1080
#define B_AX_HRPWM_SH 16
#define B_AX_HRPWM_MSK 0xffff

#define R_AX_SDIO_BUS_CTRL 0x1084
#define B_AX_R_CCCR_EHS BIT(22)
#define B_AX_SPI_PHASE BIT(21)
#define B_AX_INTR_CTRL BIT(20)
#define B_AX_SDIO_VOLTAGE BIT(19)
#define B_AX_BYPASS_INIT BIT(18)
#define B_AX_HCI_RESUME_RDY BIT(17)
#define B_AX_HCI_SUS_REQ BIT(16)
#define B_AX_CMD53_RDATA_EARLY BIT(14)
#define B_AX_HISR_W_CLR_EN BIT(13)
#define B_AX_INT_MASK_DIS BIT(12)
#define B_AX_PAD_CLK_XHGE_EN BIT(11)
#define B_AX_INTER_CLK_EN BIT(10)
#define B_AX_EN_RPT_TXCRC BIT(9)
#define B_AX_DIS_RXDMA_STS BIT(8)

#define R_AX_SDIO_RESPONSE_TIMER 0x1088
#define B_AX_SDIO_CMD_CRC_SH 16
#define B_AX_SDIO_CMD_CRC_MSK 0xff
#define B_AX_CMDIN_2RESP_TIMER_SH 0
#define B_AX_CMDIN_2RESP_TIMER_MSK 0xffff

#define R_AX_SDIO_HSISR 0x1090
#define B_AX_HISR_MASK BIT(8)
#define B_AX_DRV_WLAN_INT_CLR BIT(1)
#define B_AX_DRV_WLAN_INT BIT(0)

#define R_AX_SDIO_EXTEND_RBLOK_GAP 0x1094
#define B_AX_EXTEND_RBLOCK_GAP_SH 0
#define B_AX_EXTEND_RBLOCK_GAP_MSK 0x3f

#define R_AX_SDIO_DIOERR_RPT 0x10C0
#define B_AX_DATA_CRC_ERR_CNT_SH 24
#define B_AX_DATA_CRC_ERR_CNT_MSK 0xff
#define B_AX_CMD_CRC_ERR_CNT_SH 16
#define B_AX_CMD_CRC_ERR_CNT_MSK 0xff
#define B_AX_SDIO_PAGE_ERR BIT(0)

#define R_AX_SDIO_CMD_ERR_CONTENT_L 0x10C4
#define B_AX_SDIO_CMD_ERR_CONTENT_L_SH 0
#define B_AX_SDIO_CMD_ERR_CONTENT_L_MSK 0xffffffffL

#define R_AX_SDIO_CMD_ERR_CONTENT 0x10C8
#define B_AX_SDIO_DATA_CRC_SH 16
#define B_AX_SDIO_DATA_CRC_MSK 0xffff
#define B_AX_FN1_WDATA_TO_FLG BIT(15)
#define B_AX_FN1_WDATA_LEN_SHORT_FLG BIT(14)
#define B_AX_D3_CRC_ERR BIT(12)
#define B_AX_D2_CRC_ERR BIT(11)
#define B_AX_D1_CRC_ERR BIT(10)
#define B_AX_D0_CRC_ERR BIT(9)
#define B_AX_CMD_CRC_ERR BIT(8)
#define B_AX_SDIO_CMD_ERR_CONTENT_H_SH 0
#define B_AX_SDIO_CMD_ERR_CONTENT_H_MSK 0xff

#define R_AX_SDIO_TRANS_FIFO_STATUS 0x10CC
#define B_AX_TRANS_FIFO_UNDERFLOW BIT(1)
#define B_AX_TRANS_FIFO_OVERFLOW BIT(0)

#define R_AX_SDIO_HIMR 0x1100
#define B_AX_BT_INT_EN BIT(24)
#define B_AX_HS0ISR_IND_EN BIT(16)
#define B_AX_HC10ISR_IND_EN BIT(9)
#define B_AX_HC00ISR_IND_EN BIT(8)
#define B_AX_HD1ISR_IND_EN BIT(3)
#define B_AX_HD0ISR_IND_EN BIT(2)
#define B_AX_SDIO_AVAL_INT_EN BIT(1)
#define B_AX_RX_REQUEST_INT_EN BIT(0)

#define R_AX_SDIO_HISR 0x1104
#define B_AX_BT_INT BIT(24)
#define B_AX_HS0ISR_IND BIT(16)
#define B_AX_HC10ISR_IND BIT(9)
#define B_AX_HC00ISR_IND BIT(8)
#define B_AX_HD1ISR_IND BIT(3)
#define B_AX_HD0ISR_IND BIT(2)
#define B_AX_SDIO_AVAL_INT BIT(1)
#define B_AX_RX_REQUEST_INT BIT(0)

#define R_AX_SDIO_RX_REQ_LEN 0x1108
#define B_AX_RX_REQ_LEN_SH 0
#define B_AX_RX_REQ_LEN_MSK 0x3ffff

#define R_AX_SDIO_AVAL_INTRPT_STAT 0x110C
#define B_AX_SDIO_ACH11_INTRPT_STAT BIT(11)
#define B_AX_SDIO_ACH10_INTRPT_STAT BIT(10)
#define B_AX_SDIO_ACH9_INTRPT_STAT BIT(9)
#define B_AX_SDIO_ACH8_INTRPT_STAT BIT(8)
#define B_AX_SDIO_ACH7_INTRPT_STAT BIT(7)
#define B_AX_SDIO_ACH6_INTRPT_STAT BIT(6)
#define B_AX_SDIO_ACH5_INTRPT_STAT BIT(5)
#define B_AX_SDIO_ACH4_INTRPT_STAT BIT(4)
#define B_AX_SDIO_ACH3_INTRPT_STAT BIT(3)
#define B_AX_SDIO_ACH2_INTRPT_STAT BIT(2)
#define B_AX_SDIO_ACH1_INTRPT_STAT BIT(1)
#define B_AX_SDIO_ACH0_INTRPT_STAT BIT(0)

#define R_AX_SDIO_TXPG_WP 0x1110
#define B_AX_SDIO_ACH12_AVAL_PG_SH 16
#define B_AX_SDIO_ACH12_AVAL_PG_MSK 0x1fff
#define B_AX_SDIO_WP_AVAL_PG_SH 0
#define B_AX_SDIO_WP_AVAL_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_0 0x1114
#define B_AX_SDIO_ACH1_USE_PG_SH 16
#define B_AX_SDIO_ACH1_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH0_USE_PG_SH 0
#define B_AX_SDIO_ACH0_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_1 0x1118
#define B_AX_SDIO_ACH3_USE_PG_SH 16
#define B_AX_SDIO_ACH3_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH2_USE_PG_SH 0
#define B_AX_SDIO_ACH2_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_2 0x111C
#define B_AX_SDIO_ACH5_USE_PG_SH 16
#define B_AX_SDIO_ACH5_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH4_USE_PG_SH 0
#define B_AX_SDIO_ACH4_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_3 0x1120
#define B_AX_SDIO_ACH7_USE_PG_SH 16
#define B_AX_SDIO_ACH7_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH6_USE_PG_SH 0
#define B_AX_SDIO_ACH6_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_4 0x1124
#define B_AX_SDIO_ACH9_USE_PG_SH 16
#define B_AX_SDIO_ACH9_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH8_USE_PG_SH 0
#define B_AX_SDIO_ACH8_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_5 0x1128
#define B_AX_SDIO_ACH11_USE_PG_SH 16
#define B_AX_SDIO_ACH11_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH10_USE_PG_SH 0
#define B_AX_SDIO_ACH10_USE_PG_MSK 0x1fff

//
// WL_AX_Reg_Page_SDIO.xls
//

//
// SDIO_Local_Reg_Spec
//
#define B_AX_TRANS_FIFO_UNDERFLOW_B BIT(1)
#define B_AX_TRANS_FIFO_OVERFLOW_B BIT(0)

//
// WL_AX_Reg_Page_SDIO.xls
//

//
// SDIO_Local_Reg_Spec
//

#define R_AX_SDIO_TX_CTRL_V1 0x4000

#define R_AX_SDIO_CTRL_V1 0x4004

#define R_AX_SDIO_MONITOR_V1 0x4008
#define B_AX_TSF_FREERUN_CNT_REG_SH 0
#define B_AX_TSF_FREERUN_CNT_REG_MSK 0xffffff

#define R_AX_SDIO_MONITOR_2_V1 0x400C

#define R_AX_SDIO_CTRL_2_V1 0x4010

#define R_AX_SDIO_MONITOR_3_V1 0x4014
#define B_AX_MAC_THR_SH 0
#define B_AX_MAC_THR_MSK 0xffffffffL

#define R_AX_SDIO_LOCAL_REG_V1 0x4018
#define B_AX_RX_LEN_UP_MODE_SH 6
#define B_AX_RX_LEN_UP_MODE_MSK 0x3
#define B_AX_BYPASS_RX_INT BIT(5)
#define B_AX__MAC_IS_ACTIVE BIT(4)
#define B_AX_SDIO_IOREG_RST BIT(3)
#define B_AX_DISABLE_0X800 BIT(2)
#define B_AX_EN_CMD53_RX_MIX_MODE BIT(1)
#define B_AX_EN_RX_LEN_CMD_OK BIT(0)
#define B_AX_CMD11_TIMEOUT_THRESHOLD_SH 0
#define B_AX_CMD11_TIMEOUT_THRESHOLD_MSK 0xffff

#define R_AX_SDIO_HTSFR_INFO_V1 0x4030
#define B_AX_HTSFT2_SH 16
#define B_AX_HTSFT2_MSK 0xffff
#define B_AX_HTSFT1_SH 0
#define B_AX_HTSFT1_MSK 0xffff

#define R_AX_SDIO_TX_IOREG_INFO 0x4034
#define B_AX_IOREG_W_BUSY_EN BIT(2)
#define B_AX_TX_TRIGGER_DELAY BIT(1)
#define B_AX_HCPWM2_SDIO_SYNC_SH 0
#define B_AX_HCPWM2_SDIO_SYNC_MSK 0xffff

#define R_AX_SDIO_INDIRECT_ADDR_V1 0x4040

#define R_AX_SDIO_INDIRECT_DATA_V1 0x4044

#define R_AX_SDIO_INDIRECT_CTRL_V1 0x4048

#define R_AX_SDIO_TRX_STAT_V1 0x4070
#define B_AX_TX_DMA_WRAP_STAT_V1_SH 12
#define B_AX_TX_DMA_WRAP_STAT_V1_MSK 0x7
#define B_AX_TX_DATA_STAGE_STAT_V1_SH 8
#define B_AX_TX_DATA_STAGE_STAT_V1_MSK 0xf
#define B_AX_RX_DMA_WRAP_STAT_V1_SH 4
#define B_AX_RX_DMA_WRAP_STAT_V1_MSK 0xf
#define B_AX_RX_DATA_STAGE_STAT_V1_SH 0
#define B_AX_RX_DATA_STAGE_STAT_V1_MSK 0xf

#define R_AX_SDIO_HRPWM1_V1 0x4080

#define R_AX_SDIO_BUS_CTRL_V1 0x4084
#define B_AX_EE_SPI_CLK_OPTION BIT(21)
#define B_AX_FN1_CRC16_SYNC_EN BIT(15)
#define B_AX_HPS_CLKR_SH 0
#define B_AX_HPS_CLKR_MSK 0xff

#define R_AX_SDIO_RESPONSE_TIMER_V1 0x4088

#define R_AX_SDIO_HSISR_V1 0x4090
#define B_AX_SDIO_RESP_FLAG_EN_SH 24
#define B_AX_SDIO_RESP_FLAG_EN_MSK 0xff
#define B_AX_SDIO_RESP_FLAG_SH 16
#define B_AX_SDIO_RESP_FLAG_MSK 0xff

#define R_AX_SDIO_EXTEND_RBLOK_GAP_V1 0x4094

#define R_AX_SDIO_DIOERR_RPT_V1 0x40C0

#define R_AX_SDIO_CMD_ERR_CONTENT_L_V1 0x40C4

#define R_AX_SDIO_CMD_ERR_CONTENT_V1 0x40C8

#define R_AX_SDIO_TRANS_FIFO_STATUS_V1 0x40CC
#define B_AX_SD_DBG_SEL_SH 8
#define B_AX_SD_DBG_SEL_MSK 0xff
#define B_AX_RXDMA_READ_PTR_CLR BIT(7)
#define B_AX_RXDMA_WRITE_PTR_CLR BIT(6)
#define B_AX_TXDMA_READ_PTR_CLR BIT(5)
#define B_AX_TXDMA_WRITE_PTR_CLR BIT(4)
#define B_AX__RXDMA_FIFO_UNDERFLOW BIT(3)
#define B_AX_RXDMA_FIFO_OVERFLOW BIT(2)
#define B_AX_TXDMA_FIFO_UNDERFLOW BIT(1)
#define B_AX_TXDMA_FIFO_OVERFLOW BIT(0)

#define R_AX_SDIO_HIMR_V1 0x4100
#define B_AX_RXDMA_FIFO_UNDERFLOW_EN BIT(29)
#define B_AX_TXDMA_FIFO_OVERFLOW_EN BIT(28)

#define R_AX_SDIO_HISR_V1 0x4104
#define B_AX_RXDMA_FIFO_UNDERFLOW_INT BIT(29)
#define B_AX_TXDMA_FIFO_OVERFLOW_INT BIT(28)

#define R_AX_SDIO_RX_REQ_LEN_V1 0x4108

#define R_AX_SDIO_AVAL_INTRPT_STAT_V1 0x410C

#define R_AX_SDIO_TXPG_WP_V1 0x4110

#define R_AX_SDIO_TXPG_0_V1 0x4114

#define R_AX_SDIO_TXPG_1_V1 0x4118

#define R_AX_SDIO_TXPG_2_V1 0x411C

#define R_AX_SDIO_TXPG_3_V1 0x4120

#define R_AX_SDIO_TXPG_4_V1 0x4124

#define R_AX_SDIO_TXPG_5_V1 0x4128

#define R_AX_BT_IINT 0x4210
#define B_AX_BT_INTRD_AND_ENINTRD BIT(24)

#define R_AX_BT_ENINTRD 0x4214
#define B_AX_BT_ENINTRD BIT(0)

#define R_AX_BTSTATE_DBG_BT2SDIO 0x4230
#define B_AX_BTSTATE_DBG_BT2SDIO_SH 0
#define B_AX_BTSTATE_DBG_BT2SDIO_MSK 0xffffffffL

#define R_AX_BT_SRAM 0x4240
#define B_AX_RXPKT_REMAIN_CNT_SH 16
#define B_AX_RXPKT_REMAIN_CNT_MSK 0xffff
#define B_AX_SRAM_R_UNDERFLOW BIT(13)
#define B_AX_SRAM_W_OVERERFLOW BIT(12)
#define B_AX_RXFIFO_READY_SH 10
#define B_AX_RXFIFO_READY_MSK 0x3
#define B_AX_TXFIFO_EMPTY_SH 8
#define B_AX_TXFIFO_EMPTY_MSK 0x3
#define B_AX_BT_WAKEUP BIT(0)

#define R_AX_BT_SDIO_HEADER 0x4244
#define B_AX_SDIO_HEADER_SH 0
#define B_AX_SDIO_HEADER_MSK 0xffffffffL

#define R_AX_BT_ENINT_TXDROP 0x4248
#define B_AX_BT_ENINT_TXDROP BIT(25)
#define B_AX_BT_ENINT_TXDROP_LEISO BIT(24)
#define B_AX_SDIO_FN2_SB_INT_POL BIT(16)
#define B_AX_TXPKT_REMAIN_CNT_SH 0
#define B_AX_TXPKT_REMAIN_CNT_MSK 0xffff

#define R_AX_BT_EMIT_TXDROP 0x424C
#define B_AX_SDIO_FN2_LEISO_EN BIT(8)
#define B_AX_BT_ENINTANDINT_TXDROP BIT(1)
#define B_AX_BT_ENINTANDINT_TXDROP_LEISO BIT(0)

#define R_AX_BT_SDIO_FN2_CLK 0x4270
#define B_AX_FN2_RXCRC_BAD_EVT_DIS BIT(16)
#define B_AX_FN2_TXCRC_ERR_NO_DELAY BIT(10)
#define B_AX_FN2_TXCRC_BAD_EVT_DIS BIT(9)
#define B_AX_FN2_TXCRC_EN BIT(8)
#define B_AX_NOT_FN2_GCLK_EN BIT(1)
#define B_AX_SDIO_FN2_GCLK_EN BIT(0)

#define R_AX_FN2_CRC_ERR 0x4274
#define B_AX_FN2_LAT_CMD_REG_15_0_SH 16
#define B_AX_FN2_LAT_CMD_REG_15_0_MSK 0xffff
#define B_AX_FN2_DAT_CRC_ERR_CNT_SH 8
#define B_AX_FN2_DAT_CRC_ERR_CNT_MSK 0xf
#define B_AX_FN2_CMD_CRC_ERR_CNT_SH 0
#define B_AX_FN2_CMD_CRC_ERR_CNT_MSK 0xf

#define R_AX_FN2_LAT_CMD 0x4278
#define B_AX_FN2_LESS_WDATA_FLG BIT(30)
#define B_AX_FN2_WDATA_TO_FLG BIT(29)
#define B_AX_FN2_LAT_CRC_ERROR_SH 24
#define B_AX_FN2_LAT_CRC_ERROR_MSK 0x1f
#define B_AX_FN2_LAT_CMD_REG_39_16_SH 0
#define B_AX_FN2_LAT_CMD_REG_39_16_MSK 0xffffff

#define R_AX_FN2_LAT_DATA_CRC 0x427C
#define B_AX_FN2_LAT_DATA_CRC_SH 0
#define B_AX_FN2_LAT_DATA_CRC_MSK 0xffff

#define R_AX_SDIO_CCCR_000 0x4300
#define B_AX_R_CCCR_IOR2 BIT(26)
#define B_AX_R_CCCR_IOR1 BIT(25)
#define B_AX_CCCR_IOE2 BIT(18)
#define B_AX_CCCR_IOE1 BIT(17)
#define B_AX_EE_SD_REV_SH 8
#define B_AX_EE_SD_REV_MSK 0xf
#define B_AX_EE_SDIO_REV_SH 4
#define B_AX_EE_SDIO_REV_MSK 0xf
#define B_AX_EE_CCCR_REV_SH 0
#define B_AX_EE_CCCR_REV_MSK 0xf

#define R_AX_SDIO_CCCR_004 0x4304
#define B_AX_CCCR_CD_DIS BIT(31)
#define B_AX_EE_CCCR_SCSI BIT(30)
#define B_AX_CCCR_ECSI BIT(29)
#define B_AX_CCCR_BUS_WIDTH_SH 24
#define B_AX_CCCR_BUS_WIDTH_MSK 0x3
#define B_AX_CCCR_RES BIT(19)
#define B_AX_CCCR_AS_SH 16
#define B_AX_CCCR_AS_MSK 0x7
#define B_AX_R_CCCR_INT2 BIT(10)
#define B_AX_R_CCCR_INT1 BIT(9)
#define B_AX_CCCR_IEN2 BIT(2)
#define B_AX_CCCR_IEN1 BIT(1)
#define B_AX_CCCR_IENM BIT(0)

#define R_AX_SDIO_CCCR_008 0x4308
#define B_AX_FN0_CIS_PTR_RO_SH 8
#define B_AX_FN0_CIS_PTR_RO_MSK 0xffffff
#define B_AX_CCCR_E4MI BIT(5)

#define R_AX_SDIO_CCCR_00C 0x430C

#define R_AX_SDIO_CCCR_010 0x4310
#define B_AX_CCCR_BSS_SH 25
#define B_AX_CCCR_BSS_MSK 0x7
#define B_AX_CCCR_EMPC BIT(17)
#define B_AX_EE_CCCR_SMPC BIT(16)
#define B_AX_CCCR_FN0_BLK_SIZE_SH 0
#define B_AX_CCCR_FN0_BLK_SIZE_MSK 0xffff

#define R_AX_SDIO_CCCR_014 0x4314
#define B_AX_CCCR_EAI BIT(17)
#define B_AX_EE_SAI BIT(16)
#define B_AX_CCCR_DTS_SH 12
#define B_AX_CCCR_DTS_MSK 0x3
#define B_AX_EE_CCCR_SDTD BIT(10)
#define B_AX_EE_CCCR_SDTC BIT(9)
#define B_AX_EE_CCCR_SDTA BIT(8)
#define B_AX_EE_SDDR50 BIT(2)
#define B_AX_EE_SSDR104 BIT(1)
#define B_AX_EE_SSDR50 BIT(0)

#define R_AX_SDIO_FBR1_100 0x4400
#define B_AX_EE_FN1_PS3_SH 20
#define B_AX_EE_FN1_PS3_MSK 0xf
#define B_AX_FN1_EPS BIT(17)
#define B_AX_EE_FN1_SPS BIT(16)
#define B_AX_SDIO_WIFI_RO_SH 0
#define B_AX_SDIO_WIFI_RO_MSK 0xff

#define R_AX_SDIO_FBR1_104 0x4404

#define R_AX_SDIO_FBR1_108 0x4408
#define B_AX_FN1_CIS_PTR_RO_SH 8
#define B_AX_FN1_CIS_PTR_RO_MSK 0xffffff

#define R_AX_SDIO_FBR1_110 0x4410
#define B_AX_CCCR_FN1_BLK_SIZE_SH 0
#define B_AX_CCCR_FN1_BLK_SIZE_MSK 0xffff

#define R_AX_SDIO_FBR2_200 0x4500
#define B_AX_EE_FN1_PS3_BT_SH 12
#define B_AX_EE_FN1_PS3_BT_MSK 0xf
#define B_AX_SDIO_BT_RO_SH 0
#define B_AX_SDIO_BT_RO_MSK 0xff

#define R_AX_SDIO_FBR1_204 0x4504

#define R_AX_SDIO_FBR1_208 0x4508
#define B_AX_FN2_CIS_PTR_RO_SH 8
#define B_AX_FN2_CIS_PTR_RO_MSK 0xffffff

#define R_AX_SDIO_FBR1_210 0x4510
#define B_AX_CCCR_FN2_BLK_SIZE_SH 0
#define B_AX_CCCR_FN2_BLK_SIZE_MSK 0xffff

#define R_AX_SDIO_FN0_CIS_000 0x4600
#define B_AX_FN0_CIS_3_SH 24
#define B_AX_FN0_CIS_3_MSK 0xff
#define B_AX_FN0_CIS_2_SH 16
#define B_AX_FN0_CIS_2_MSK 0xff
#define B_AX_FN0_CIS_1_SH 8
#define B_AX_FN0_CIS_1_MSK 0xff
#define B_AX_FN0_CIS_0_SH 0
#define B_AX_FN0_CIS_0_MSK 0xff

#define R_AX_SDIO_FN0_CIS_004 0x4604
#define B_AX_FN0_CIS_7_SH 24
#define B_AX_FN0_CIS_7_MSK 0xff
#define B_AX_FN0_CIS_6_SH 16
#define B_AX_FN0_CIS_6_MSK 0xff
#define B_AX_FN0_CIS_5_SH 8
#define B_AX_FN0_CIS_5_MSK 0xff
#define B_AX_FN0_CIS_4_SH 0
#define B_AX_FN0_CIS_4_MSK 0xff

#define R_AX_SDIO_FN0_CIS_008 0x4608
#define B_AX_FN0_CIS_11_SH 24
#define B_AX_FN0_CIS_11_MSK 0xff
#define B_AX_FN0_CIS_10_SH 16
#define B_AX_FN0_CIS_10_MSK 0xff
#define B_AX_FN0_CIS_9_SH 8
#define B_AX_FN0_CIS_9_MSK 0xff
#define B_AX_FN0_CIS_8_SH 0
#define B_AX_FN0_CIS_8_MSK 0xff

#define R_AX_SDIO_FN0_CIS_00C 0x460C
#define B_AX_FN0_CIS_15_SH 24
#define B_AX_FN0_CIS_15_MSK 0xff
#define B_AX_FN0_CIS_14_SH 16
#define B_AX_FN0_CIS_14_MSK 0xff
#define B_AX_FN0_CIS_13_SH 8
#define B_AX_FN0_CIS_13_MSK 0xff
#define B_AX_FN0_CIS_12_SH 0
#define B_AX_FN0_CIS_12_MSK 0xff

#define R_AX_SDIO_FN0_CIS_010 0x4610
#define B_AX_FN0_CIS_END_FLAG_SH 0
#define B_AX_FN0_CIS_END_FLAG_MSK 0xff

#define R_AX_SDIO_FN1_CIS_100 0x4700
#define B_AX_FN1_CIS_3_SH 24
#define B_AX_FN1_CIS_3_MSK 0xff
#define B_AX_FN1_CIS_2_SH 16
#define B_AX_FN1_CIS_2_MSK 0xff
#define B_AX_FN1_CIS_1_SH 8
#define B_AX_FN1_CIS_1_MSK 0xff
#define B_AX_FN1_CIS_0_SH 0
#define B_AX_FN1_CIS_0_MSK 0xff

#define R_AX_SDIO_FN1_CIS_104 0x4704
#define B_AX_FN1_CIS_7_SH 24
#define B_AX_FN1_CIS_7_MSK 0xff
#define B_AX_FN1_CIS_6_SH 16
#define B_AX_FN1_CIS_6_MSK 0xff
#define B_AX_FN1_CIS_5_SH 8
#define B_AX_FN1_CIS_5_MSK 0xff
#define B_AX_FN1_CIS_4_SH 0
#define B_AX_FN1_CIS_4_MSK 0xff

#define R_AX_SDIO_FN1_CIS_108 0x4708
#define B_AX_FN1_CIS_11_SH 24
#define B_AX_FN1_CIS_11_MSK 0xff
#define B_AX_FN1_CIS_10_SH 16
#define B_AX_FN1_CIS_10_MSK 0xff
#define B_AX_FN1_CIS_9_SH 8
#define B_AX_FN1_CIS_9_MSK 0xff
#define B_AX_FN1_CIS_8_SH 0
#define B_AX_FN1_CIS_8_MSK 0xff

#define R_AX_SDIO_FN1_CIS_10C 0x470C
#define B_AX_FN1_CIS_15_SH 24
#define B_AX_FN1_CIS_15_MSK 0xff
#define B_AX_FN1_CIS_14_SH 16
#define B_AX_FN1_CIS_14_MSK 0xff
#define B_AX_FN1_CIS_13_SH 8
#define B_AX_FN1_CIS_13_MSK 0xff
#define B_AX_FN1_CIS_12_SH 0
#define B_AX_FN1_CIS_12_MSK 0xff

#define R_AX_SDIO_FN1_CIS_110 0x4710
#define B_AX_FN1_CIS_19_SH 24
#define B_AX_FN1_CIS_19_MSK 0xff
#define B_AX_FN1_CIS_18_SH 16
#define B_AX_FN1_CIS_18_MSK 0xff
#define B_AX_FN1_CIS_17_SH 8
#define B_AX_FN1_CIS_17_MSK 0xff
#define B_AX_FN1_CIS_16_SH 0
#define B_AX_FN1_CIS_16_MSK 0xff

#define R_AX_SDIO_FN1_CIS_114 0x4714
#define B_AX_FN1_CIS_23_SH 24
#define B_AX_FN1_CIS_23_MSK 0xff
#define B_AX_FN1_CIS_22_SH 16
#define B_AX_FN1_CIS_22_MSK 0xff
#define B_AX_FN1_CIS_21_SH 8
#define B_AX_FN1_CIS_21_MSK 0xff
#define B_AX_FN1_CIS_20_SH 0
#define B_AX_FN1_CIS_20_MSK 0xff

#define R_AX_SDIO_FN1_CIS_118 0x4718
#define B_AX_FN1_CIS_27_SH 24
#define B_AX_FN1_CIS_27_MSK 0xff
#define B_AX_FN1_CIS_26_SH 16
#define B_AX_FN1_CIS_26_MSK 0xff
#define B_AX_FN1_CIS_25_SH 8
#define B_AX_FN1_CIS_25_MSK 0xff
#define B_AX_FN1_CIS_24_SH 0
#define B_AX_FN1_CIS_24_MSK 0xff

#define R_AX_SDIO_FN1_CIS_11C 0x471C
#define B_AX_FN1_CIS_31_SH 24
#define B_AX_FN1_CIS_31_MSK 0xff
#define B_AX_FN1_CIS_30_SH 16
#define B_AX_FN1_CIS_30_MSK 0xff
#define B_AX_FN1_CIS_29_SH 8
#define B_AX_FN1_CIS_29_MSK 0xff
#define B_AX_FN1_CIS_28_SH 0
#define B_AX_FN1_CIS_28_MSK 0xff

#define R_AX_SDIO_FN1_CIS_120 0x4720
#define B_AX_FN1_CIS_35_SH 24
#define B_AX_FN1_CIS_35_MSK 0xff
#define B_AX_FN1_CIS_34_SH 16
#define B_AX_FN1_CIS_34_MSK 0xff
#define B_AX_FN1_CIS_33_SH 8
#define B_AX_FN1_CIS_33_MSK 0xff
#define B_AX_FN1_CIS_32_SH 0
#define B_AX_FN1_CIS_32_MSK 0xff

#define R_AX_SDIO_FN1_CIS_124 0x4724
#define B_AX_FN1_CIS_39_SH 24
#define B_AX_FN1_CIS_39_MSK 0xff
#define B_AX_FN1_CIS_38_SH 16
#define B_AX_FN1_CIS_38_MSK 0xff
#define B_AX_FN1_CIS_37_SH 8
#define B_AX_FN1_CIS_37_MSK 0xff
#define B_AX_FN1_CIS_36_SH 0
#define B_AX_FN1_CIS_36_MSK 0xff

#define R_AX_SDIO_FN1_CIS_128 0x4728
#define B_AX_FN1_CIS_43_SH 24
#define B_AX_FN1_CIS_43_MSK 0xff
#define B_AX_FN1_CIS_42_SH 16
#define B_AX_FN1_CIS_42_MSK 0xff
#define B_AX_FN1_CIS_41_SH 8
#define B_AX_FN1_CIS_41_MSK 0xff
#define B_AX_FN1_CIS_40_SH 0
#define B_AX_FN1_CIS_40_MSK 0xff

#define R_AX_SDIO_FN1_CIS_12C 0x472C
#define B_AX_FN1_CIS_47_SH 24
#define B_AX_FN1_CIS_47_MSK 0xff
#define B_AX_FN1_CIS_46_SH 16
#define B_AX_FN1_CIS_46_MSK 0xff
#define B_AX_FN1_CIS_45_SH 8
#define B_AX_FN1_CIS_45_MSK 0xff
#define B_AX_FN1_CIS_44_SH 0
#define B_AX_FN1_CIS_44_MSK 0xff

#define R_AX_SDIO_FN1_CIS_130 0x4730
#define B_AX_FN1_CIS_END_FLAG_SH 0
#define B_AX_FN1_CIS_END_FLAG_MSK 0xff

#define R_AX_SDIO_FN2_CIS_200 0x4800
#define B_AX_FN2_CIS_3_SH 24
#define B_AX_FN2_CIS_3_MSK 0xff
#define B_AX_FN2_CIS_2_SH 16
#define B_AX_FN2_CIS_2_MSK 0xff
#define B_AX_FN2_CIS_1_SH 8
#define B_AX_FN2_CIS_1_MSK 0xff
#define B_AX_FN2_CIS_0_SH 0
#define B_AX_FN2_CIS_0_MSK 0xff

#define R_AX_SDIO_FN2_CIS_204 0x4804
#define B_AX_FN2_CIS_7_SH 24
#define B_AX_FN2_CIS_7_MSK 0xff
#define B_AX_FN2_CIS_6_SH 16
#define B_AX_FN2_CIS_6_MSK 0xff
#define B_AX_FN2_CIS_5_SH 8
#define B_AX_FN2_CIS_5_MSK 0xff
#define B_AX_FN2_CIS_4_SH 0
#define B_AX_FN2_CIS_4_MSK 0xff

#define R_AX_SDIO_FN2_CIS_208 0x4808
#define B_AX_FN2_CIS_11_SH 24
#define B_AX_FN2_CIS_11_MSK 0xff
#define B_AX_FN2_CIS_10_SH 16
#define B_AX_FN2_CIS_10_MSK 0xff
#define B_AX_FN2_CIS_9_SH 8
#define B_AX_FN2_CIS_9_MSK 0xff
#define B_AX_FN2_CIS_8_SH 0
#define B_AX_FN2_CIS_8_MSK 0xff

#define R_AX_SDIO_FN2_CIS_20C 0x480C
#define B_AX_FN2_CIS_15_SH 24
#define B_AX_FN2_CIS_15_MSK 0xff
#define B_AX_FN2_CIS_14_SH 16
#define B_AX_FN2_CIS_14_MSK 0xff
#define B_AX_FN2_CIS_13_SH 8
#define B_AX_FN2_CIS_13_MSK 0xff
#define B_AX_FN2_CIS_12_SH 0
#define B_AX_FN2_CIS_12_MSK 0xff

#define R_AX_SDIO_FN2_CIS_210 0x4810
#define B_AX_FN2_CIS_19_SH 24
#define B_AX_FN2_CIS_19_MSK 0xff
#define B_AX_FN2_CIS_18_SH 16
#define B_AX_FN2_CIS_18_MSK 0xff
#define B_AX_FN2_CIS_17_SH 8
#define B_AX_FN2_CIS_17_MSK 0xff
#define B_AX_FN2_CIS_16_SH 0
#define B_AX_FN2_CIS_16_MSK 0xff

#define R_AX_SDIO_FN2_CIS_214 0x4814
#define B_AX_FN2_CIS_23_SH 24
#define B_AX_FN2_CIS_23_MSK 0xff
#define B_AX_FN2_CIS_22_SH 16
#define B_AX_FN2_CIS_22_MSK 0xff
#define B_AX_FN2_CIS_21_SH 8
#define B_AX_FN2_CIS_21_MSK 0xff
#define B_AX_FN2_CIS_20_SH 0
#define B_AX_FN2_CIS_20_MSK 0xff

#define R_AX_SDIO_FN2_CIS_218 0x4818
#define B_AX_FN2_CIS_27_SH 24
#define B_AX_FN2_CIS_27_MSK 0xff
#define B_AX_FN2_CIS_26_SH 16
#define B_AX_FN2_CIS_26_MSK 0xff
#define B_AX_FN2_CIS_25_SH 8
#define B_AX_FN2_CIS_25_MSK 0xff
#define B_AX_FN2_CIS_24_SH 0
#define B_AX_FN2_CIS_24_MSK 0xff

#define R_AX_SDIO_FN2_CIS_21C 0x481C
#define B_AX_FN2_CIS_31_SH 24
#define B_AX_FN2_CIS_31_MSK 0xff
#define B_AX_FN2_CIS_30_SH 16
#define B_AX_FN2_CIS_30_MSK 0xff
#define B_AX_FN2_CIS_29_SH 8
#define B_AX_FN2_CIS_29_MSK 0xff
#define B_AX_FN2_CIS_28_SH 0
#define B_AX_FN2_CIS_28_MSK 0xff

#define R_AX_SDIO_FN2_CIS_220 0x4820
#define B_AX_FN2_CIS_35_SH 24
#define B_AX_FN2_CIS_35_MSK 0xff
#define B_AX_FN2_CIS_34_SH 16
#define B_AX_FN2_CIS_34_MSK 0xff
#define B_AX_FN2_CIS_33_SH 8
#define B_AX_FN2_CIS_33_MSK 0xff
#define B_AX_FN2_CIS_32_SH 0
#define B_AX_FN2_CIS_32_MSK 0xff

#define R_AX_SDIO_FN2_CIS_224 0x4824
#define B_AX_FN2_CIS_39_SH 24
#define B_AX_FN2_CIS_39_MSK 0xff
#define B_AX_FN2_CIS_38_SH 16
#define B_AX_FN2_CIS_38_MSK 0xff
#define B_AX_FN2_CIS_37_SH 8
#define B_AX_FN2_CIS_37_MSK 0xff
#define B_AX_FN2_CIS_36_SH 0
#define B_AX_FN2_CIS_36_MSK 0xff

#define R_AX_SDIO_FN2_CIS_228 0x4828
#define B_AX_FN2_CIS_43_SH 24
#define B_AX_FN2_CIS_43_MSK 0xff
#define B_AX_FN2_CIS_42_SH 16
#define B_AX_FN2_CIS_42_MSK 0xff
#define B_AX_FN2_CIS_41_SH 8
#define B_AX_FN2_CIS_41_MSK 0xff
#define B_AX_FN2_CIS_40_SH 0
#define B_AX_FN2_CIS_40_MSK 0xff

#define R_AX_SDIO_FN2_CIS_22C 0x482C
#define B_AX_FN2_CIS_47_SH 24
#define B_AX_FN2_CIS_47_MSK 0xff
#define B_AX_FN2_CIS_46_SH 16
#define B_AX_FN2_CIS_46_MSK 0xff
#define B_AX_FN2_CIS_45_SH 8
#define B_AX_FN2_CIS_45_MSK 0xff
#define B_AX_FN2_CIS_44_SH 0
#define B_AX_FN2_CIS_44_MSK 0xff

#define R_AX_SDIO_FN2_CIS_230 0x4830
#define B_AX_FN2_CIS_END_FLAG_SH 0
#define B_AX_FN2_CIS_END_FLAG_MSK 0xff

//
// WL_AX_Reg_Page_SDIO.xls
//

//
// SDIO_Local_Reg_Spec
//

//
// WL_AX_Reg_USB.xls
//

//
// USB_REG
//

#define R_AX_USB2_MAC_0 0x1000
#define B_AX_TOUT_DELAY_FS_SH 24
#define B_AX_TOUT_DELAY_FS_MSK 0xff
#define B_AX_TOUT_DELAY_HS_SH 16
#define B_AX_TOUT_DELAY_HS_MSK 0xff
#define B_AX_TOUT_DIS BIT(15)
#define B_AX_CRC_CHK_OPT BIT(14)
#define B_AX_FORCE_PCERST BIT(13)
#define B_AX_FORCE_TOGL BIT(12)
#define B_AX_FORCE_TOGLSEL BIT(11)
#define B_AX_FORCE_PIDSW BIT(10)
#define B_AX_FORCE_PCE_IN BIT(9)
#define B_AX_FORCE_PCE_OUT BIT(8)
#define B_AX_PID_FORCE_SH 0
#define B_AX_PID_FORCE_MSK 0xff

#define R_AX_USB2_MAC_1 0x1004
#define B_AX_FORCE_PCE_CMD BIT(31)

#define R_AX_USB2_LINK_PORT 0x1008
#define B_AX_R_HOST_PWR_CTRL BIT(23)
#define B_AX_R_USB2_CLR_TXVLD BIT(22)
#define B_AX_R_USB2_SE0 BIT(21)
#define B_AX_HOST_RESUME_EDGE_EN BIT(20)
#define B_AX_RESUME_SEL_SH 16
#define B_AX_RESUME_SEL_MSK 0xf
#define B_AX_DELAY_CHIRP_K_SH 14
#define B_AX_DELAY_CHIRP_K_MSK 0x3
#define B_AX_FORCE_TXVLD1 BIT(13)
#define B_AX_FORCE_TXVLD0 BIT(12)
#define B_AX_DORCE_DAT1 BIT(11)
#define B_AX_FORCE_DAT0 BIT(10)
#define B_AX_LS_TEST BIT(9)
#define B_AX_LS_CHANGE BIT(8)
#define B_AX_FORCE_HS_SW BIT(7)
#define B_AX_FORCE_FS_SW BIT(6)
#define B_AX_FORCE_HSXCVR BIT(5)
#define B_AX_FORCE_FSXCVR BIT(4)
#define B_AX_FORCE_HSTERM BIT(3)
#define B_AX_FORCE_FSTERM BIT(2)
#define B_AX_FORCE_NORM_SW BIT(1)
#define B_AX_FORCE_DBSN BIT(0)

#define R_AX_USB2_LPM_0 0x1010
#define B_AX_USBPHY_PLL_ALIVE BIT(17)
#define B_AX_USB_LPM_MAX_EN BIT(16)
#define B_AX_USB_LPM_MIN_EN BIT(15)
#define B_AX_BESL_EN BIT(14)
#define B_AX_USB_LPM_NYET_EN BIT(13)
#define B_AX_USB_LPM_MAX_ACK BIT(12)
#define B_AX_USB_LPM_EN BIT(11)
#define B_AX_USB2_SUSB BIT(10)
#define B_AX_LPM_PLL_ALIVE BIT(9)
#define B_AX_USB_LPS_OUT BIT(8)
#define B_AX_USB_LPM_WAKEUP_EN BIT(6)
#define B_AX_NEVER_SUSPEND BIT(5)
#define B_AX_SUSPND_EN BIT(4)
#define B_AX_WAKEUP_EN BIT(3)
#define B_AX_USB_SUS_WAKEUP_EN BIT(2)
#define B_AX_RESUME_SND BIT(1)
#define B_AX_CONNECT_EN BIT(0)

#define R_AX_USB2_LPM_1 0x1014
#define B_AX_USB_LPM_MAX_SH 20
#define B_AX_USB_LPM_MAX_MSK 0xf
#define B_AX_USB_LPM_MIN_SH 16
#define B_AX_USB_LPM_MIN_MSK 0xf
#define B_AX_R_WAKE_HOST_WT_H_SH 8
#define B_AX_R_WAKE_HOST_WT_H_MSK 0xff
#define B_AX_R_WAKE_HOST_WT_L_SH 0
#define B_AX_R_WAKE_HOST_WT_L_MSK 0xff

#define R_AX_USB2_MACRO_TEST_MODE 0x1018
#define B_AX_TXRDY_SLB_SEL BIT(14)
#define B_AX_SLB_EN BIT(13)
#define B_AX_SLB_RST BIT(12)
#define B_AX_SLB_FAIL BIT(11)
#define B_AX_SLB_DONE BIT(10)
#define B_AX_SLB_PS1_SW_SH 8
#define B_AX_SLB_PS1_SW_MSK 0x3
#define B_AX_PHY_LOOP_TEST BIT(3)
#define B_AX_USBTMOD_SH 0
#define B_AX_USBTMOD_MSK 0x7

#define R_AX_USB2_PHY_REG_0 0x1020
#define B_AX_USB2PHY_REG_EN BIT(17)
#define B_AX_VLPADM BIT(16)
#define B_AX_VSTATUS_IN_SH 8
#define B_AX_VSTATUS_IN_MSK 0xff
#define B_AX_VCONTROL_SH 0
#define B_AX_VCONTROL_MSK 0xff

#define R_AX_USB2_PHY_REG_1 0x1024
#define B_AX_USB2PHY_DELAY_SH 8
#define B_AX_USB2PHY_DELAY_MSK 0xff
#define B_AX_VSTATUS_OUT_SH 0
#define B_AX_VSTATUS_OUT_MSK 0xff

#define R_AX_USB2_PHY_REG_2 0x1028
#define B_AX_USB2_PHY_P0_E3_SH 24
#define B_AX_USB2_PHY_P0_E3_MSK 0xff
#define B_AX_USB2_PHY_P0_E2_SH 16
#define B_AX_USB2_PHY_P0_E2_MSK 0xff
#define B_AX_USB2_PHY_P0_E1_SH 8
#define B_AX_USB2_PHY_P0_E1_MSK 0xff
#define B_AX_USB2_PHY_P0_E0_SH 0
#define B_AX_USB2_PHY_P0_E0_MSK 0xff

#define R_AX_USB2_PHY_REG_3 0x102C
#define B_AX_USB2_PHY_P0_E7_SH 24
#define B_AX_USB2_PHY_P0_E7_MSK 0xff
#define B_AX_USB2_PHY_P0_E6_SH 16
#define B_AX_USB2_PHY_P0_E6_MSK 0xff
#define B_AX_USB2_PHY_P0_E5_SH 8
#define B_AX_USB2_PHY_P0_E5_MSK 0xff
#define B_AX_USB2_PHY_P0_E4_SH 0
#define B_AX_USB2_PHY_P0_E4_MSK 0xff

#define R_AX_USB2_PHY_REG_4 0x1030
#define B_AX_USB2_PHY_P1_E3_SH 24
#define B_AX_USB2_PHY_P1_E3_MSK 0xff
#define B_AX_USB2_PHY_P1_E2_SH 16
#define B_AX_USB2_PHY_P1_E2_MSK 0xff
#define B_AX_USB2_PHY_P1_E1_SH 8
#define B_AX_USB2_PHY_P1_E1_MSK 0xff
#define B_AX_USB2_PHY_P1_E0_SH 0
#define B_AX_USB2_PHY_P1_E0_MSK 0xff

#define R_AX_USB2_PHY_REG_5 0x1034
#define B_AX_USB2_PHY_P1_E7_SH 24
#define B_AX_USB2_PHY_P1_E7_MSK 0xff
#define B_AX_USB2_PHY_P1_E6_SH 16
#define B_AX_USB2_PHY_P1_E6_MSK 0xff
#define B_AX_USB2_PHY_P1_E5_SH 8
#define B_AX_USB2_PHY_P1_E5_MSK 0xff
#define B_AX_USB2_PHY_P1_E4_SH 0
#define B_AX_USB2_PHY_P1_E4_MSK 0xff

#define R_AX_USB2_PHY_REG_6 0x1038
#define B_AX_USB2_PHY_F3_SH 24
#define B_AX_USB2_PHY_F3_MSK 0xff
#define B_AX_USB2_PHY_F2_SH 16
#define B_AX_USB2_PHY_F2_MSK 0xff
#define B_AX_USB2_PHY_F1_SH 8
#define B_AX_USB2_PHY_F1_MSK 0xff
#define B_AX_USB2_PHY_F0_SH 0
#define B_AX_USB2_PHY_F0_MSK 0xff

#define R_AX_USB2_PHY_REG_7 0x103C
#define B_AX_USB2_PHY_F7_SH 24
#define B_AX_USB2_PHY_F7_MSK 0xff
#define B_AX_USB2_PHY_F6_SH 16
#define B_AX_USB2_PHY_F6_MSK 0xff
#define B_AX_USB2_PHY_F5_SH 8
#define B_AX_USB2_PHY_F5_MSK 0xff
#define B_AX_USB2_PHY_F4_SH 0
#define B_AX_USB2_PHY_F4_MSK 0xff

#define R_AX_USB2_PHY_REG_8 0x1040
#define B_AX_USB2PHY_UPDATE_2_SH 16
#define B_AX_USB2PHY_UPDATE_2_MSK 0xff
#define B_AX_USB2PHY_UPDATE_1_SH 8
#define B_AX_USB2PHY_UPDATE_1_MSK 0xff
#define B_AX_USB2PHY_UPDATE_0_SH 0
#define B_AX_USB2PHY_UPDATE_0_MSK 0xff

#define R_AX_USB_ENDPOINT_0 0x1060
#define B_AX_EP_MAXPKT_SH 16
#define B_AX_EP_MAXPKT_MSK 0x3ff
#define B_AX_EP_EN BIT(15)
#define B_AX_EP_TYPE_SH 13
#define B_AX_EP_TYPE_MSK 0x3
#define B_AX_EP_ISTALL BIT(12)
#define B_AX_EP_OSTALL BIT(11)
#define B_AX_EP_STREAMEN BIT(10)
#define B_AX_EP_OUT BIT(9)
#define B_AX_EP_IN BIT(8)
#define B_AX_BT_INTR_SEL BIT(5)
#define B_AX_R_SIE_INIT_DONE BIT(4)
#define B_AX_EP_IDX_SH 0
#define B_AX_EP_IDX_MSK 0xf

#define R_AX_USB_ENDPOINT_1 0x1064
#define B_AX_EP_MAX_STREAM_SH 16
#define B_AX_EP_MAX_STREAM_MSK 0xff
#define B_AX_EP_MAX_BURST_SH 8
#define B_AX_EP_MAX_BURST_MSK 0xff
#define B_AX_EP_INT_INTERVAL_SH 0
#define B_AX_EP_INT_INTERVAL_MSK 0xff

#define R_AX_USB_ENDPOINT_2 0x1068
#define B_AX_EP_BPI_SH 16
#define B_AX_EP_BPI_MSK 0xffff
#define B_AX_USB3_EP_IN_ST_SH 8
#define B_AX_USB3_EP_IN_ST_MSK 0xff
#define B_AX_USB3_EP_OUT_ST_SH 0
#define B_AX_USB3_EP_OUT_ST_MSK 0xff

#define R_AX_USB_ENDPOINT_3 0x106C
#define B_AX_EP12_PAUSE_STATE BIT(31)
#define B_AX_EP11_PAUSE_STATE BIT(30)
#define B_AX_EP10_PAUSE_STATE BIT(29)
#define B_AX_EP9_PAUSE_STATE BIT(28)
#define B_AX_EP8_PAUSE_STATE BIT(27)
#define B_AX_EP7_PAUSE_STATE BIT(26)
#define B_AX_EP6_PAUSE_STATE BIT(25)
#define B_AX_EP5_PAUSE_STATE BIT(24)
#define B_AX_EP4_PAUSE_STATE BIT(23)
#define B_AX_EP12_TX_PAUSE BIT(22)
#define B_AX_EP11_TX_PAUSE BIT(21)
#define B_AX_EP10_TX_PAUSE BIT(20)
#define B_AX_EP9_TX_PAUSE BIT(19)
#define B_AX_EP8_RX_PAUSE BIT(18)
#define B_AX_EP7_TX_PAUSE BIT(17)
#define B_AX_EP6_TX_PAUSE BIT(16)
#define B_AX_EP5_TX_PAUSE BIT(15)
#define B_AX_EP4_RX_PAUSE BIT(14)
#define B_AX_INTERRUPT_BULK_IN BIT(12)
#define B_AX_AC_BULKOUT_SH 10
#define B_AX_AC_BULKOUT_MSK 0x3
#define B_AX_BULKOUT1 BIT(9)
#define B_AX_BULKOUT0 BIT(8)
#define B_AX_INTERRUPT_INTERVAL_SH 0
#define B_AX_INTERRUPT_INTERVAL_MSK 0xf

#define R_AX_USB_HOST_REQUEST_0 0x1070
#define B_AX_ERR_STR2_LEN_SH 24
#define B_AX_ERR_STR2_LEN_MSK 0xff
#define B_AX_ERR_STR1_LEN_SH 8
#define B_AX_ERR_STR1_LEN_MSK 0xffff
#define B_AX_DEVADDR_SH 0
#define B_AX_DEVADDR_MSK 0x7f

#define R_AX_USB_HOST_REQUEST_1 0x1074
#define B_AX_USB_PID_SH 16
#define B_AX_USB_PID_MSK 0xffff
#define B_AX_USB_VID_SH 0
#define B_AX_USB_VID_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_2 0x1078
#define B_AX_MAC_ADDR_1_SH 24
#define B_AX_MAC_ADDR_1_MSK 0xff
#define B_AX_MAC_ADDR_0_SH 16
#define B_AX_MAC_ADDR_0_MSK 0xff
#define B_AX_FORCE_LPM_BCD201 BIT(15)
#define B_AX_SELF_POWER_EN BIT(14)
#define B_AX_R_FORCE_U3MAC_HS_MODE BIT(13)
#define B_AX_LOAD_LTM_CAP BIT(12)
#define B_AX_USB3_DEV_CAP_DESC_EN BIT(11)
#define B_AX_AUTOLOAD_STRING_EN BIT(10)
#define B_AX_REMOTE_WAKEUP BIT(9)
#define B_AX_SQNUM_ROM BIT(8)
#define B_AX_ERR_STR2_LEN_FLAG BIT(7)
#define B_AX_ERR_STR1_LEN_FLAG BIT(6)
#define B_AX_ERR_STR0_LEN_FLAG BIT(5)
#define B_AX_R_USBIO_MODE BIT(4)
#define B_AX_EXREG_TO_EN BIT(3)
#define B_AX_EXREG_TO_SEL_SH 0
#define B_AX_EXREG_TO_SEL_MSK 0x7

#define R_AX_USB_HOST_REQUEST_3 0x107C
#define B_AX_MAC_ADDR_5_SH 24
#define B_AX_MAC_ADDR_5_MSK 0xff
#define B_AX_MAC_ADDR_4_SH 16
#define B_AX_MAC_ADDR_4_MSK 0xff
#define B_AX_MAC_ADDR_3_SH 8
#define B_AX_MAC_ADDR_3_MSK 0xff
#define B_AX_MAC_ADDR_2_SH 0
#define B_AX_MAC_ADDR_2_MSK 0xff

#define R_AX_USB_HOST_REQUEST_4 0x1080
#define B_AX__MANUFACTURE_STRING_3_SH 24
#define B_AX__MANUFACTURE_STRING_3_MSK 0xff
#define B_AX__MANUFACTURE_STRING_2_SH 16
#define B_AX__MANUFACTURE_STRING_2_MSK 0xff
#define B_AX__MANUFACTURE_STRING_1_SH 8
#define B_AX__MANUFACTURE_STRING_1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_0_SH 0
#define B_AX__MANUFACTURE_STRING_0_MSK 0xff

#define R_AX_USB_HOST_REQUEST_5 0x1084
#define B_AX_MANUFACTURE_STRING_7_SH 24
#define B_AX_MANUFACTURE_STRING_7_MSK 0xff
#define B_AX_MANUFACTURE_STRING_6_SH 16
#define B_AX_MANUFACTURE_STRING_6_MSK 0xff
#define B_AX_MANUFACTURE_STRING_5_SH 8
#define B_AX_MANUFACTURE_STRING_5_MSK 0xff
#define B_AX_MANUFACTURE_STRING_4_SH 0
#define B_AX_MANUFACTURE_STRING_4_MSK 0xff

#define R_AX_USB_HOST_REQUEST_6 0x1088
#define B_AX_MANUFACTURE_STRING_B_SH 24
#define B_AX_MANUFACTURE_STRING_B_MSK 0xff
#define B_AX_MANUFACTURE_STRING_A_SH 16
#define B_AX_MANUFACTURE_STRING_A_MSK 0xff
#define B_AX_MANUFACTURE_STRING_9_SH 8
#define B_AX_MANUFACTURE_STRING_9_MSK 0xff
#define B_AX_MANUFACTURE_STRING_8_SH 0
#define B_AX_MANUFACTURE_STRING_8_MSK 0xff

#define R_AX_USB_HOST_REQUEST_7 0x108C
#define B_AX_MANUFACTURE_STRING_F_SH 24
#define B_AX_MANUFACTURE_STRING_F_MSK 0xff
#define B_AX_MANUFACTURE_STRING_E_SH 16
#define B_AX_MANUFACTURE_STRING_E_MSK 0xff
#define B_AX_MANUFACTURE_STRING_D_SH 8
#define B_AX_MANUFACTURE_STRING_D_MSK 0xff
#define B_AX_MANUFACTURE_STRING_C_SH 0
#define B_AX_MANUFACTURE_STRING_C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_8 0x1090
#define B_AX_MANUFACTURE_STRING_13_SH 24
#define B_AX_MANUFACTURE_STRING_13_MSK 0xff
#define B_AX_MANUFACTURE_STRING_12_SH 16
#define B_AX_MANUFACTURE_STRING_12_MSK 0xff
#define B_AX_MANUFACTURE_STRING_11_SH 8
#define B_AX_MANUFACTURE_STRING_11_MSK 0xff
#define B_AX_MANUFACTURE_STRING_10_SH 0
#define B_AX_MANUFACTURE_STRING_10_MSK 0xff

#define R_AX_USB_HOST_REQUEST_9 0x1094
#define B_AX_MANUFACTURE_STRING_17_SH 24
#define B_AX_MANUFACTURE_STRING_17_MSK 0xff
#define B_AX_MANUFACTURE_STRING_16_SH 16
#define B_AX_MANUFACTURE_STRING_16_MSK 0xff
#define B_AX_MANUFACTURE_STRING_15_SH 8
#define B_AX_MANUFACTURE_STRING_15_MSK 0xff
#define B_AX_MANUFACTURE_STRING_14_SH 0
#define B_AX_MANUFACTURE_STRING_14_MSK 0xff

#define R_AX_USB_HOST_REQUEST_A 0x1098
#define B_AX_MANUFACTURE_STRING_1B_SH 24
#define B_AX_MANUFACTURE_STRING_1B_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1A_SH 16
#define B_AX_MANUFACTURE_STRING_1A_MSK 0xff
#define B_AX_MANUFACTURE_STRING_19_SH 8
#define B_AX_MANUFACTURE_STRING_19_MSK 0xff
#define B_AX_MANUFACTURE_STRING_18_SH 0
#define B_AX_MANUFACTURE_STRING_18_MSK 0xff

#define R_AX_USB_HOST_REQUEST_B 0x109C
#define B_AX_MANUFACTURE_STRING_1F_SH 24
#define B_AX_MANUFACTURE_STRING_1F_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1E_SH 16
#define B_AX_MANUFACTURE_STRING_1E_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1D_SH 8
#define B_AX_MANUFACTURE_STRING_1D_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1C_SH 0
#define B_AX_MANUFACTURE_STRING_1C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_C 0x10A0
#define B_AX_PRODUCT_STRING_3_SH 24
#define B_AX_PRODUCT_STRING_3_MSK 0xff
#define B_AX_PRODUCT_STRING_2_SH 16
#define B_AX_PRODUCT_STRING_2_MSK 0xff
#define B_AX_PRODUCT_STRING_1_SH 8
#define B_AX_PRODUCT_STRING_1_MSK 0xff
#define B_AX_PRODUCT_STRING_0_SH 0
#define B_AX_PRODUCT_STRING_0_MSK 0xff

#define R_AX_USB_HOST_REQUEST_D 0x10A4
#define B_AX_PRODUCT_STRING_7_SH 24
#define B_AX_PRODUCT_STRING_7_MSK 0xff
#define B_AX_PRODUCT_STRING_6_SH 16
#define B_AX_PRODUCT_STRING_6_MSK 0xff
#define B_AX_PRODUCT_STRING_5_SH 8
#define B_AX_PRODUCT_STRING_5_MSK 0xff
#define B_AX_PRODUCT_STRING_4_SH 0
#define B_AX_PRODUCT_STRING_4_MSK 0xff

#define R_AX_USB_HOST_REQUEST_E 0x10A8
#define B_AX_PRODUCT_STRING_B_SH 24
#define B_AX_PRODUCT_STRING_B_MSK 0xff
#define B_AX_PRODUCT_STRING_A_SH 16
#define B_AX_PRODUCT_STRING_A_MSK 0xff
#define B_AX_PRODUCT_STRING_9_SH 8
#define B_AX_PRODUCT_STRING_9_MSK 0xff
#define B_AX_PRODUCT_STRING_8_SH 0
#define B_AX_PRODUCT_STRING_8_MSK 0xff

#define R_AX_USB_HOST_REQUEST_F 0x10AC
#define B_AX_PRODUCT_STRING_F_SH 24
#define B_AX_PRODUCT_STRING_F_MSK 0xff
#define B_AX_PRODUCT_STRING_E_SH 16
#define B_AX_PRODUCT_STRING_E_MSK 0xff
#define B_AX_PRODUCT_STRING_D_SH 8
#define B_AX_PRODUCT_STRING_D_MSK 0xff
#define B_AX_PRODUCT_STRING_C_SH 0
#define B_AX_PRODUCT_STRING_C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_10 0x10B0
#define B_AX_PRODUCT_STRING_13_SH 24
#define B_AX_PRODUCT_STRING_13_MSK 0xff
#define B_AX_PRODUCT_STRING_12_SH 16
#define B_AX_PRODUCT_STRING_12_MSK 0xff
#define B_AX_PRODUCT_STRING_11_SH 8
#define B_AX_PRODUCT_STRING_11_MSK 0xff
#define B_AX_PRODUCT_STRING_10_SH 0
#define B_AX_PRODUCT_STRING_10_MSK 0xff

#define R_AX_USB_HOST_REQUEST_11 0x10B4
#define B_AX_PRODUCT_STRING_17_SH 24
#define B_AX_PRODUCT_STRING_17_MSK 0xff
#define B_AX_PRODUCT_STRING_16_SH 16
#define B_AX_PRODUCT_STRING_16_MSK 0xff
#define B_AX_PRODUCT_STRING_15_SH 8
#define B_AX_PRODUCT_STRING_15_MSK 0xff
#define B_AX_PRODUCT_STRING_14_SH 0
#define B_AX_PRODUCT_STRING_14_MSK 0xff

#define R_AX_USB_HOST_REQUEST_12 0x10B8
#define B_AX_PRODUCT_STRING_1B_SH 24
#define B_AX_PRODUCT_STRING_1B_MSK 0xff
#define B_AX_PRODUCT_STRING_1A_SH 16
#define B_AX_PRODUCT_STRING_1A_MSK 0xff
#define B_AX_PRODUCT_STRING_19_SH 8
#define B_AX_PRODUCT_STRING_19_MSK 0xff
#define B_AX_PRODUCT_STRING_18_SH 0
#define B_AX_PRODUCT_STRING_18_MSK 0xff

#define R_AX_USB_HOST_REQUEST_13 0x10BC
#define B_AX_PRODUCT_STRING_1F_SH 24
#define B_AX_PRODUCT_STRING_1F_MSK 0xff
#define B_AX_PRODUCT_STRING_1E_SH 16
#define B_AX_PRODUCT_STRING_1E_MSK 0xff
#define B_AX_PRODUCT_STRING_1D_SH 8
#define B_AX_PRODUCT_STRING_1D_MSK 0xff
#define B_AX_PRODUCT_STRING_1C_SH 0
#define B_AX_PRODUCT_STRING_1C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_14 0x10C0
#define B_AX_PRODUCT_STRING_23_SH 24
#define B_AX_PRODUCT_STRING_23_MSK 0xff
#define B_AX_PRODUCT_STRING_22_SH 16
#define B_AX_PRODUCT_STRING_22_MSK 0xff
#define B_AX_PRODUCT_STRING_21_SH 8
#define B_AX_PRODUCT_STRING_21_MSK 0xff
#define B_AX_PRODUCT_STRING_20_SH 0
#define B_AX_PRODUCT_STRING_20_MSK 0xff

#define R_AX_USB_HOST_REQUEST_15 0x10C4
#define B_AX_PRODUCT_STRING_27_SH 24
#define B_AX_PRODUCT_STRING_27_MSK 0xff
#define B_AX_PRODUCT_STRING_26_SH 16
#define B_AX_PRODUCT_STRING_26_MSK 0xff
#define B_AX_PRODUCT_STRING_25_SH 8
#define B_AX_PRODUCT_STRING_25_MSK 0xff
#define B_AX_PRODUCT_STRING_24_SH 0
#define B_AX_PRODUCT_STRING_24_MSK 0xff

#define R_AX_USB_HOST_REQUEST_16 0x10C8
#define B_AX_PRODUCT_STRING_2B_SH 24
#define B_AX_PRODUCT_STRING_2B_MSK 0xff
#define B_AX_PRODUCT_STRING_2A_SH 16
#define B_AX_PRODUCT_STRING_2A_MSK 0xff
#define B_AX_PRODUCT_STRING_29_SH 8
#define B_AX_PRODUCT_STRING_29_MSK 0xff
#define B_AX_PRODUCT_STRING_28_SH 0
#define B_AX_PRODUCT_STRING_28_MSK 0xff

#define R_AX_USB_HOST_REQUEST_17 0x10CC
#define B_AX_PRODUCT_STRING_2F_SH 24
#define B_AX_PRODUCT_STRING_2F_MSK 0xff
#define B_AX_PRODUCT_STRING_2E_SH 16
#define B_AX_PRODUCT_STRING_2E_MSK 0xff
#define B_AX_PRODUCT_STRING_2D_SH 8
#define B_AX_PRODUCT_STRING_2D_MSK 0xff
#define B_AX_PRODUCT_STRING_2C_SH 0
#define B_AX_PRODUCT_STRING_2C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_18 0x10D0
#define B_AX_SERIAL_NUMBER_STRING_3_SH 24
#define B_AX_SERIAL_NUMBER_STRING_3_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_2_SH 16
#define B_AX_SERIAL_NUMBER_STRING_2_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_0_SH 0
#define B_AX_SERIAL_NUMBER_STRING_0_MSK 0xff

#define R_AX_USB_HOST_REQUEST_19 0x10D4
#define B_AX_SERIAL_NUMBER_STRING_7_SH 24
#define B_AX_SERIAL_NUMBER_STRING_7_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_6_SH 16
#define B_AX_SERIAL_NUMBER_STRING_6_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_5_SH 8
#define B_AX_SERIAL_NUMBER_STRING_5_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_4_SH 0
#define B_AX_SERIAL_NUMBER_STRING_4_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1A 0x10D8
#define B_AX_SERIAL_NUMBER_STRING_B_SH 24
#define B_AX_SERIAL_NUMBER_STRING_B_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_A_SH 16
#define B_AX_SERIAL_NUMBER_STRING_A_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_9_SH 8
#define B_AX_SERIAL_NUMBER_STRING_9_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_8_SH 0
#define B_AX_SERIAL_NUMBER_STRING_8_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1B 0x10DC
#define B_AX_SERIAL_NUMBER_STRING_F_SH 24
#define B_AX_SERIAL_NUMBER_STRING_F_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_E_SH 16
#define B_AX_SERIAL_NUMBER_STRING_E_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_D_SH 8
#define B_AX_SERIAL_NUMBER_STRING_D_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_C_SH 0
#define B_AX_SERIAL_NUMBER_STRING_C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1C 0x10E0
#define B_AX_USB3_U2SEL_SH 16
#define B_AX_USB3_U2SEL_MSK 0xffff
#define B_AX_USB3_U1PEL_SH 0
#define B_AX_USB3_U1PEL_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_1D 0x10E4
#define B_AX_HW_VENDOR_INDEX_SH 16
#define B_AX_HW_VENDOR_INDEX_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1E 0x10E8
#define B_AX_DIS_STALL_FUNC_WAKE BIT(24)
#define B_AX_USB3_U2_DEV_EXIT_LAT_SH 8
#define B_AX_USB3_U2_DEV_EXIT_LAT_MSK 0xffff
#define B_AX_USB3_U1_DEV_EXIT_LAT_SH 0
#define B_AX_USB3_U1_DEV_EXIT_LAT_MSK 0xff

#define R_AX_USB3_MAC_LINK_0 0x1100
#define B_AX_INTS_USB3_HRESET_EN BIT(31)
#define B_AX_INTS_USB3_RECOV_EN BIT(30)
#define B_AX_INTS_USB3_LPBK_EN BIT(29)
#define B_AX_INTS_USB3_RXDET_EN BIT(28)
#define B_AX_INTS_USB3_POLL_EN BIT(27)
#define B_AX_INTS_USB3_U3_EN BIT(26)
#define B_AX_INTS_USB3_U1U2_EN BIT(25)
#define B_AX_INTS_USB3_U0_EN BIT(24)
#define B_AX_INTS_USB3_RECOV2U0_EN BIT(23)
#define B_AX_INTS_USB3_SSINACT_EN BIT(22)
#define B_AX_INTS_USB3_SSDIS_EN BIT(21)
#define B_AX_INTS_USB3_CMPLY_EN BIT(20)
#define B_AX_INTS_USB3_RECOV2U0 BIT(19)
#define B_AX_INTS_USB3_SSINACT BIT(18)
#define B_AX_INTS_USB3_SSDIS BIT(17)
#define B_AX_INTS_USB3_CMPLY BIT(16)
#define B_AX_INTS_USB3_HRESET BIT(15)
#define B_AX_INTS_USB3_RECOV BIT(14)
#define B_AX_INTS_USB3_LPBK BIT(13)
#define B_AX_INTS_USB3_RXDET BIT(12)
#define B_AX_INTS_USB3_POLL BIT(11)
#define B_AX_INTS_USB3_U3 BIT(10)
#define B_AX_INTS_USB3_U1U2 BIT(9)
#define B_AX_INTS_USB3_U0 BIT(8)
#define B_AX_EN_ROVIDLE_TIMEOUT BIT(6)
#define B_AX_EN_UNFIN_RTY BIT(5)
#define B_AX_SSPHY_U1_QUICK_LFPS BIT(4)
#define B_AX_USB3_DIS_ISOC_TIME_GT BIT(3)
#define B_AX_R_DIS_USB3_U2_EN BIT(2)
#define B_AX_R_DIS_USB3_U1_EN BIT(1)
#define B_AX_LINK_ST_DETECT_TERM BIT(0)

#define R_AX_USB3_MAC_LINK_1 0x1104
#define B_AX_WARM_RESET_TIME_SH 0
#define B_AX_WARM_RESET_TIME_MSK 0x3

#define R_AX_USB3_MAC_PIU 0x1108
#define B_AX_SSPHY_CLR_TERM BIT(1)
#define B_AX_SSPHY_SET_TERM BIT(0)

#define R_AX_USB3_MAC_PTL 0x110C
#define B_AX_BCDVALUE_SH 2
#define B_AX_BCDVALUE_MSK 0x3
#define B_AX_WLAN0_BUF_NUMP_EN BIT(1)
#define B_AX_IGNORE_RETRY_BIT BIT(0)

#define R_AX_USB3_MAC_PRTSM 0x1110
#define B_AX_EN_IMMED_POP_CREDIT BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_0 0x1114
#define B_AX_SSPHY_LFPS_FILTER BIT(31)
#define B_AX_SSPHY_TX_SWING BIT(30)
#define B_AX_SSPHY_TXMARGIN_SH 27
#define B_AX_SSPHY_TXMARGIN_MSK 0x7
#define B_AX_SSPHY_TXDEEMPHASIS_SH 25
#define B_AX_SSPHY_TXDEEMPHASIS_MSK 0x3
#define B_AX_SSPHY_ELASTIC_BUF BIT(24)
#define B_AX_HIRD_THR_SH 19
#define B_AX_HIRD_THR_MSK 0x1f
#define B_AX_DEV_SPEED_SH 16
#define B_AX_DEV_SPEED_MSK 0x7
#define B_AX_U1_ACTIVE_TIMEOUT_SH 8
#define B_AX_U1_ACTIVE_TIMEOUT_MSK 0xff
#define B_AX_USB3_TARGET_LINK_STATE_SH 4
#define B_AX_USB3_TARGET_LINK_STATE_MSK 0xf
#define B_AX_APPL1RSP BIT(3)
#define B_AX_LPM_CAPABLE BIT(2)
#define B_AX_USB3_EOF_SH 0
#define B_AX_USB3_EOF_MSK 0x3

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_1 0x1118
#define B_AX_NPI_SCALEDOWN_MODE_SH 24
#define B_AX_NPI_SCALEDOWN_MODE_MSK 0x3
#define B_AX_SSPHY_POWERDOWN_SCALE_SH 8
#define B_AX_SSPHY_POWERDOWN_SCALE_MSK 0x1fff
#define B_AX_SSPHY_U1_FAST_OUT BIT(7)
#define B_AX_SSPHY_P3_FOR_P2 BIT(6)
#define B_AX_SSPHY_U1_RXVALID BIT(5)
#define B_AX_SSPHY_DIS_SCAMBLE BIT(4)
#define B_AX_SSPHY_SKIP_RXDETECT BIT(3)
#define B_AX_SSPHY_LFPS_P0_ALIGN BIT(2)
#define B_AX_SSPHY_P3P2_TRANS BIT(1)
#define B_AX_SSPHY_P3_EXITIN_P2 BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_2 0x111C
#define B_AX_SSPHY_U2EXIT_LPFS BIT(18)
#define B_AX_SSPHY_PHYSOFTRST BIT(17)
#define B_AX_SSPHY_HSTPRTCMPL BIT(16)
#define B_AX_SSPHY_U2SSINACTP3OK BIT(15)
#define B_AX_SSPHY_DISRXDETP3 BIT(14)
#define B_AX_SSPHY_UX_EXIT_IN_PX BIT(13)
#define B_AX_SSPHY_PING_ENH_EN BIT(12)
#define B_AX_SSPHY_U1U2EXITFAIL_TO_RECOV BIT(11)
#define B_AX_SSPHY_ALWAYS_REQ BIT(10)
#define B_AX_SSPHY_START_RX_DET BIT(9)
#define B_AX_SSPHY_DIS_RX_DET BIT(8)
#define B_AX_SSPHY_DELAY_P1P2P3_SH 5
#define B_AX_SSPHY_DELAY_P1P2P3_MSK 0x7
#define B_AX_SSPHY_SUSPEND_EN BIT(4)
#define B_AX_SSPHY_DATWIDTH_SH 2
#define B_AX_SSPHY_DATWIDTH_MSK 0x3
#define B_AX_SSPHY_ABORTRXDETLNU2 BIT(1)
#define B_AX_SSPHY_RX_DETECT_LPFS BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_0 0x1120
#define B_AX_U3_LTM_EN BIT(28)
#define B_AX_LINK_STATE_REQ_SH 24
#define B_AX_LINK_STATE_REQ_MSK 0xf
#define B_AX_SUSCLK_RATIO_SH 8
#define B_AX_SUSCLK_RATIO_MSK 0x1fff
#define B_AX_TEST_CTRL_SH 4
#define B_AX_TEST_CTRL_MSK 0xf
#define B_AX_UFRAME_SCALE_SH 2
#define B_AX_UFRAME_SCALE_MSK 0x3
#define B_AX_LOCAL_LBK BIT(1)
#define B_AX_EN_SLEEP_USB BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_1 0x1124
#define B_AX_WAKE_WAIT_XTAL BIT(27)
#define B_AX_WAKE_WAIT_CURRENT BIT(26)
#define B_AX_WAKEUP_NEG_SEL BIT(25)
#define B_AX_SSPHY_USB3_ATTEMPT BIT(24)
#define B_AX_WAIT_IDLE_TIME_SH 20
#define B_AX_WAIT_IDLE_TIME_MSK 0xf
#define B_AX_U2_EN_MAC_IDLE BIT(18)
#define B_AX_U1_EN_MAC_IDLE BIT(17)
#define B_AX_SWITCH_CLK_EN BIT(16)
#define B_AX_USB3_SAMPLE_RXELECIDLE_SH 8
#define B_AX_USB3_SAMPLE_RXELECIDLE_MSK 0xff
#define B_AX_U3_INIT_U2 BIT(7)
#define B_AX_U3_INIT_U1 BIT(6)
#define B_AX_SET_U3_WAKE BIT(5)
#define B_AX_U3_U2_EN BIT(4)
#define B_AX_U3_U1_EN BIT(3)
#define B_AX_U3_INIT_U2_EN BIT(2)
#define B_AX_U3_INIT_U1_EN BIT(1)
#define B_AX_USB3_RUN BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_2 0x1128
#define B_AX_NPI_LINK_STATE_LATCH_SH 16
#define B_AX_NPI_LINK_STATE_LATCH_MSK 0xff
#define B_AX_NPI_HOST_RESUME_DETECTED BIT(15)
#define B_AX_NPI_DEV_CONNECT_SPEED_SH 12
#define B_AX_NPI_DEV_CONNECT_SPEED_MSK 0x7
#define B_AX_NPI_LINK_STATE_SH 8
#define B_AX_NPI_LINK_STATE_MSK 0xf
#define B_AX_POLL_EN BIT(7)
#define B_AX_POLL_SAMPLE_ON BIT(6)
#define B_AX_POLL_ACT_SH 4
#define B_AX_POLL_ACT_MSK 0x3
#define B_AX_POLL_NOACT_SH 0
#define B_AX_POLL_NOACT_MSK 0xf

#define R_AX_USB3_MAC_NPI_POWER_3 0x112C
#define B_AX_R_CNT_SWITCH_USB32_PARA_SH 0
#define B_AX_R_CNT_SWITCH_USB32_PARA_MSK 0xffff

#define R_AX_USB3_MAC_NPI_STATUS 0x1130
#define B_AX_NPI_DEV_CONNECTED BIT(0)

#define R_AX_USB3_MAC_NPI_DEVICE_NOTIFICATION 0x1134
#define B_AX_DEVNOTE_BIA_SH 16
#define B_AX_DEVNOTE_BIA_MSK 0xffff
#define B_AX_DEVNOTE_BELT_SH 0
#define B_AX_DEVNOTE_BELT_MSK 0xfff

#define R_AX_USB3_MAC_NPI_TRANSMIT 0x1138
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_SH 0
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_MSK 0xf

#define R_AX_USB3_MAC_NPI_OTHERS 0x113C
#define B_AX_EN_FIX_RX_ABORT BIT(8)
#define B_AX_FLADJ_30MHZ_REG_SH 0
#define B_AX_FLADJ_30MHZ_REG_MSK 0x3f

#define R_AX_USB3_WRAP_0 0x1140
#define B_AX_U1TOU2_TIMER_SH 24
#define B_AX_U1TOU2_TIMER_MSK 0xff
#define B_AX_WAKE_ST_DBG_SH 20
#define B_AX_WAKE_ST_DBG_MSK 0xf
#define B_AX_ARB_ST_DBG_SH 18
#define B_AX_ARB_ST_DBG_MSK 0x3
#define B_AX_BIA_REQ BIT(17)
#define B_AX_BELT_REQ BIT(16)
#define B_AX_USB3_VENDOR_LEN_TH_SH 0
#define B_AX_USB3_VENDOR_LEN_TH_MSK 0xffff

#define R_AX_USB3_WRAP_1 0x1144
#define B_AX_DIS_PKT_FUNC_WAKE BIT(0)

#define R_AX_USB3_PHY 0x1148
#define B_AX_USB3_PHY_RWDATA_SH 16
#define B_AX_USB3_PHY_RWDATA_MSK 0xffff
#define B_AX_USB3_PHY_ADR_SH 8
#define B_AX_USB3_PHY_ADR_MSK 0x1f
#define B_AX_USB3_PHY_REG_WRFLAG BIT(7)
#define B_AX_USB3_PHY_REG_RDFLAG BIT(6)
#define B_AX_USB3_PHY_REG_ADR_SH 0
#define B_AX_USB3_PHY_REG_ADR_MSK 0x1f

#define R_AX_USB3_OTHERS 0x1150
#define B_AX_R_REATTACH_TIMER_SH 28
#define B_AX_R_REATTACH_TIMER_MSK 0xf
#define B_AX_R_CNT_MS_SEL_SH 24
#define B_AX_R_CNT_MS_SEL_MSK 0x7
#define B_AX_VENDOR_LPM_TEST_SH 16
#define B_AX_VENDOR_LPM_TEST_MSK 0xff
#define B_AX_ISOC_DELAY_VALUE_SH 0
#define B_AX_ISOC_DELAY_VALUE_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_0 0x1160
#define B_AX_BTRX0_BUFFER_WADDR_SH 24
#define B_AX_BTRX0_BUFFER_WADDR_MSK 0xff
#define B_AX_USB_INTOKEN_TIMEOUT_SH 20
#define B_AX_USB_INTOKEN_TIMEOUT_MSK 0x7
#define B_AX_BRX_BUF_CHK_SH 16
#define B_AX_BRX_BUF_CHK_MSK 0x7
#define B_AX_BTRX0_RPKT_SIZE_SH 0
#define B_AX_BTRX0_RPKT_SIZE_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_1 0x1164
#define B_AX_USB2BT_PWR_INFO_REG_MASK_SH 20
#define B_AX_USB2BT_PWR_INFO_REG_MASK_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_BT BIT(19)
#define B_AX_LOWPOWER_BT BIT(18)
#define B_AX_FUNCTION_WAKE_EN_BT BIT(17)
#define B_AX_FUNCTION_WAKE_CAPABLE_BT BIT(16)
#define B_AX_BT_ISO_ZERO_EN BIT(14)
#define B_AX_R_RXDMA_MODE_SH 12
#define B_AX_R_RXDMA_MODE_MSK 0x3
#define B_AX_GPS_USB_ACTIVE BIT(11)
#define B_AX_BT_TXQ_STOP_SH 8
#define B_AX_BT_TXQ_STOP_MSK 0x7

#define R_AX_USB_APPLICATION_BT_2 0x1168
#define B_AX_BT_TX BIT(17)
#define B_AX_BT_RX BIT(16)
#define B_AX_BTTX_FIFO_OVER_EP3 BIT(13)
#define B_AX_BTTX_FIFO_OVER_EP2 BIT(12)
#define B_AX_BTTX_FIFO_OVER_EP0 BIT(11)
#define B_AX_BTRX_FIFO_OVER_EP3 BIT(10)
#define B_AX_BTRX_FIFO_OVER_EP2 BIT(9)
#define B_AX_BTRX_FIFO_OVER_EP1 BIT(8)
#define B_AX_BTTX_FIFO_UNDR_EP3 BIT(5)
#define B_AX_BTTX_FIFO_UNDR_EP2 BIT(4)
#define B_AX_BTTX_FIFO_UNDR_EP0 BIT(3)
#define B_AX_BTRX_FIFO_UNDR_EP3 BIT(2)
#define B_AX_BTRX_FIFO_UNDR_EP2 BIT(1)
#define B_AX_BTRX_FIFO_UNDR_EP1 BIT(0)

#define R_AX_USB_APPLICATION_BT_3 0x116C
#define B_AX_DBG_BTRX_WADDR_SH 16
#define B_AX_DBG_BTRX_WADDR_MSK 0xfff
#define B_AX_DBG_BTRX_RPKT_SH 0
#define B_AX_DBG_BTRX_RPKT_MSK 0xffff

#define R_AX_USB_WLAN0_0 0x1170
#define B_AX_WLAN_INT_LEN_SH 16
#define B_AX_WLAN_INT_LEN_MSK 0xffff
#define B_AX_WLAN0_TXQ_STALL_DIS BIT(4)
#define B_AX_FUNCTION_SUSB_EN_WLAN0 BIT(3)
#define B_AX_LOWPOWER_WLAN0 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN0 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN0 BIT(0)

#define R_AX_USB_WLAN0_1 0x1174
#define B_AX_USBRX_RST BIT(9)
#define B_AX_USBTX_RST BIT(8)
#define B_AX_R_USBRX_SRAM_LS BIT(7)
#define B_AX_R_USBRX_SRAM_DS BIT(6)
#define B_AX_R_USBTX_SRAM_LS BIT(5)
#define B_AX_R_USBTX_SRAM_DS BIT(4)
#define B_AX_WLRX_FIFO_OVER_SH 2
#define B_AX_WLRX_FIFO_OVER_MSK 0x3
#define B_AX_WLRX_FIFO_UNDR_SH 0
#define B_AX_WLRX_FIFO_UNDR_MSK 0x3

#define R_AX_USB_AUTO_INSTALL_0 0x1180
#define B_AX_AINST_POLL_1 BIT(28)
#define B_AX_AINST_POLL_0 BIT(27)
#define B_AX_AINST_TX1_CLR_BUF BIT(26)
#define B_AX_AINST_TX0_CLR_BUF BIT(25)
#define B_AX_WLAN_FW_RDY BIT(24)
#define B_AX_RECONF_USBEP BIT(23)
#define B_AX_RECONF_USBEP_EN BIT(22)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET BIT(21)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET_EN BIT(20)
#define B_AX_AINST_RXLEN_SH 8
#define B_AX_AINST_RXLEN_MSK 0xfff
#define B_AX_AINST_RX1_INTR BIT(7)
#define B_AX_AINST_RX0_INTR BIT(6)
#define B_AX_AINXT_TX1_INTR BIT(5)
#define B_AX_AINST_TX0_INTR BIT(4)
#define B_AX_AUTO_INST_TXQ_STALL_DIS BIT(3)
#define B_AX_LOWPOWER_AINST BIT(2)
#define B_AX_FUNCTION_WANE_EN_AINST BIT(1)

#define R_AX_USB_AUTO_INSTALL_1 0x1184
#define B_AX_AINST_TX1LEN_SH 16
#define B_AX_AINST_TX1LEN_MSK 0xfff
#define B_AX_AINST_TX0LEN_SH 0
#define B_AX_AINST_TX0LEN_MSK 0xfff

#define R_AX_USB_AUTO_INSTALL_2 0x1188
#define B_AX_AINST_PID_SH 16
#define B_AX_AINST_PID_MSK 0xffff
#define B_AX_AINST_VID_SH 0
#define B_AX_AINST_VID_MSK 0xffff

#define R_AX_USB_AUTO_INSTALL_3 0x118C
#define B_AX_AINST_TXSTATUS_SH 8
#define B_AX_AINST_TXSTATUS_MSK 0xff
#define B_AX_AINST_RXSTATUS_SH 0
#define B_AX_AINST_RXSTATUS_MSK 0xff

#define R_AX_USB_BRIDGE_UART_0 0x1190
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_SH 16
#define B_AX_BRIDGE_XFACTOR_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB2_SH 0
#define B_AX_BRIDGE_BAUD_USB2_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_1 0x1194
#define B_AX_BRIDGE_WAKEUP_EN_SH 30
#define B_AX_BRIDGE_WAKEUP_EN_MSK 0x3
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_SH 16
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_MSK 0xfff
#define B_AX_BRIDGE_LE_CON_HAN_VLD BIT(9)
#define B_AX_BRIDGE_LE_ON BIT(8)
#define B_AX_BRIDGE_DEBUG_PKTCNT_EN BIT(6)
#define B_AX_BRIDGE_RESET_RCV_SEL BIT(5)
#define B_AX_BRIDGE_WLS0 BIT(4)
#define B_AX_BRIDGE_STB BIT(3)
#define B_AX_BRIDGE_PEN BIT(2)
#define B_AX_BRIDGE_EPS BIT(1)
#define B_AX_BRIDGE_STKP BIT(0)

#define R_AX_USB_BRIDGE_UART_2 0x1198
#define B_AX_BRIDGE_DEBUG_SEL_SH 24
#define B_AX_BRIDGE_DEBUG_SEL_MSK 0xff
#define B_AX_R_BRIDGE_UARTEN BIT(23)
#define B_AX_BRIDGE_LPM_EN BIT(22)
#define B_AX_BRIDGE_TXSCO_TIME_INTERVAL_EN BIT(21)
#define B_AX_BRIDGE_TXSCO_PKT_LEN_MAT_EN BIT(20)
#define B_AX_BRIDGE_TXSCO_CON_HAN_MAT_EN BIT(19)
#define B_AX_BRIDGE_USB_TX_HCICMDLEN_SEL BIT(18)
#define B_AX_R_BRIDGE_JCIRXEN BIT(17)
#define B_AX_R_BRIDGE_HCITXEN BIT(16)
#define B_AX_BRIDGE_RXSCOBUF_FLOW_SEL_SH 12
#define B_AX_BRIDGE_RXSCOBUF_FLOW_SEL_MSK 0xf
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_SH 0
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_3 0x119C
#define B_AX_BRIDGE_URT_RXINDIC_ERR BIT(31)
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_SH 24
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_MSK 0x7f
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_SH 16
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_MSK 0xff
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_SH 8
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_MSK 0xff
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_SH 0
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_MSK 0xff

#define R_AX_USB_BRIDGE_UART_4 0x11A0
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_USB3_SH 16
#define B_AX_BRIDGE_XFACTOR_USB3_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB3_SH 0
#define B_AX_BRIDGE_BAUD_USB3_MSK 0xfff

#define R_AX_USB_BT_BRIDGE 0x11A8
#define B_AX_R_DIS_BTBRI_SS_SYSON BIT(2)
#define B_AX_R_DIS_BTBRI_SS_STS BIT(1)
#define B_AX_R_DIS_BTBRI_L1U2_STS BIT(0)

#define R_AX_USB_DMA_WRAPPER 0x11B0
#define B_AX_PKT_BASE_EN BIT(11)
#define B_AX_FUNCTION_SUSB_OPT BIT(8)
#define B_AX_TX7LEN_MISMATCH BIT(7)
#define B_AX_TX6LEN_MISMATCH BIT(6)
#define B_AX_TX5LEN_MISMATCH BIT(5)
#define B_AX_TX4LEN_MISMATCH BIT(4)
#define B_AX_TX3LEN_MISMATCH BIT(3)
#define B_AX_TX2LEN_MISMATCH BIT(2)
#define B_AX_TX1LEN_MISMATCH BIT(1)
#define B_AX_TX0LEN_MISMATCH BIT(0)

#define R_AX_USB_WLAN1 0x11B8
#define B_AX_WLAN_TX BIT(12)
#define B_AX_WLAN_RX BIT(11)
#define B_AX_WLAN1_TXQ_STALL_DIS BIT(10)
#define B_AX_WLAN1_RXQ_STOP_SH 8
#define B_AX_WLAN1_RXQ_STOP_MSK 0x3
#define B_AX_WLAN1_TXQ_STOP_SH 4
#define B_AX_WLAN1_TXQ_STOP_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_WLAN1 BIT(3)
#define B_AX_LOWPOWER_WLAN1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN1 BIT(0)

#define R_AX_USB_GPS 0x11C0
#define B_AX_FUNCTION_SUSB_EN_GPS BIT(3)
#define B_AX_LOWPOWER_GPS BIT(2)
#define B_AX_FUNCTION_WAKE_EN_GPS BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_GPS BIT(0)

#define R_AX_USB_DEBUG_0 0x11D0
#define B_AX_SLEEP_GNT_BT BIT(17)
#define B_AX_SLEEP_REQ_BT BIT(16)
#define B_AX_DEBUG_SIGNAL_001_SH 8
#define B_AX_DEBUG_SIGNAL_001_MSK 0xff
#define B_AX_USB_DBGO_SEL_SH 0
#define B_AX_USB_DBGO_SEL_MSK 0xff

#define R_AX_USB_DEBUG_1 0x11D4
#define B_AX_RXDMA_ENDPOINT_COUNTER_SH 24
#define B_AX_RXDMA_ENDPOINT_COUNTER_MSK 0xff
#define B_AX_RXDMA_DMA_COUNTER_SH 16
#define B_AX_RXDMA_DMA_COUNTER_MSK 0xff
#define B_AX_TXDMA_ENDPOINT_COUNTER_SH 8
#define B_AX_TXDMA_ENDPOINT_COUNTER_MSK 0xff
#define B_AX_TXDMA_DMA_COUNTER_SH 0
#define B_AX_TXDMA_DMA_COUNTER_MSK 0xff

#define R_AX_USB_DEBUG_2 0x11D8
#define B_AX_REG_READ_COUNTER_SH 8
#define B_AX_REG_READ_COUNTER_MSK 0xff
#define B_AX_REG_WRITE_COUNTER_SH 0
#define B_AX_REG_WRITE_COUNTER_MSK 0xff

#define R_AX_USB_DEBUG_3 0x11DC
#define B_AX_RX_STATE_MACHINE_SH 24
#define B_AX_RX_STATE_MACHINE_MSK 0xff
#define B_AX_TX_STATE_MACHINE_SH 16
#define B_AX_TX_STATE_MACHINE_MSK 0xff
#define B_AX_IO_STATE_MACHINE_SH 8
#define B_AX_IO_STATE_MACHINE_MSK 0xff
#define B_AX_HW_TXVLD_TOGGLE_EN BIT(15)
#define B_AX_HW_FORCE_TXRDY_EN BIT(14)
#define B_AX_TXVLD_TOGGLE_VAL_SH 8
#define B_AX_TXVLD_TOGGLE_VAL_MSK 0xf
#define B_AX_TXVLD_TOUT_VAL_SH 0
#define B_AX_TXVLD_TOUT_VAL_MSK 0xff

#define R_AX_USB_STATUS 0x11F0
#define B_AX_USB_EP_NUM_SH 4
#define B_AX_USB_EP_NUM_MSK 0xf
#define B_AX_R_SSIC_EN BIT(2)
#define B_AX_R_USB2_SEL BIT(1)
#define B_AX_MODE_HS BIT(0)

#define R_AX_USB_D2F_F2D_INFO 0x1200
#define B_AX_HRPWM2_SH 16
#define B_AX_HRPWM2_MSK 0xffff
#define B_AX_CPWM2_SH 0
#define B_AX_CPWM2_MSK 0xffff

#define R_AX_USB3 0x1220
#define B_AX_U3_STATE_SH 12
#define B_AX_U3_STATE_MSK 0xf
#define B_AX_U3_SUB_STATE_SH 8
#define B_AX_U3_SUB_STATE_MSK 0xf
#define B_AX_HPS_CLKR_USB_SH 0
#define B_AX_HPS_CLKR_USB_MSK 0xff

#define R_AX_USB_OTHERS_0 0x1230
#define B_AX_USBTX_EP3IF_OK_CNT_SH 24
#define B_AX_USBTX_EP3IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP2IF_OK_CNT_SH 16
#define B_AX_USBTX_EP2IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP1IF_OK_CNT_SH 8
#define B_AX_USBTX_EP1IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP0IF_OK_CNT_SH 0
#define B_AX_USBTX_EP0IF_OK_CNT_MSK 0xff

#define R_AX_USB_OTHERS_1 0x1234
#define B_AX_USBTX_EP7IF_OK_CNT_SH 24
#define B_AX_USBTX_EP7IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP6IF_OK_CNT_SH 16
#define B_AX_USBTX_EP6IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP5IF_OK_CNT_SH 8
#define B_AX_USBTX_EP5IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP4IF_OK_CNT_SH 0
#define B_AX_USBTX_EP4IF_OK_CNT_MSK 0xff

#define R_AX_USB_OTHERS_2 0x1238
#define B_AX_USBRX_DMAIF_OK_CNT_SH 24
#define B_AX_USBRX_DMAIF_OK_CNT_MSK 0xff
#define B_AX_USBRX_EPIF_OK_CNT_SH 16
#define B_AX_USBRX_EPIF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP9IF_OK_CNT_SH 8
#define B_AX_USBTX_EP9IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP8IF_OK_CNT_SH 0
#define B_AX_USBTX_EP8IF_OK_CNT_MSK 0xff

#define R_AX_USB_OTHERS_3 0x123C
#define B_AX_VENDOR_LMP_LATCH_DATA_L_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_L_MSK 0xffffffffL

#define R_AX_USB_OTHERS_4 0x1240
#define B_AX_VENDOR_LMP_LATCH_DATA_H_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_H_MSK 0xffffffffL

#define R_AX_USB_OTHERS_5 0x1244
#define B_AX_APPEND_ZERO_PKT_SH 24
#define B_AX_APPEND_ZERO_PKT_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_7_SH 21
#define B_AX_USB_AUTO_LOAD_EXTE_7_MSK 0x3
#define B_AX_USB_AUTO_LOAD_EXTE_0_SH 16
#define B_AX_USB_AUTO_LOAD_EXTE_0_MSK 0x1f
#define B_AX_USB_AUTO_LOAD_EXTE_2_SH 8
#define B_AX_USB_AUTO_LOAD_EXTE_2_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_1_SH 0
#define B_AX_USB_AUTO_LOAD_EXTE_1_MSK 0xff

#define R_AX_USB_OTHERS_6 0x1248
#define B_AX_USB_AUTO_LOAD_STRING_3_SH 24
#define B_AX_USB_AUTO_LOAD_STRING_3_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_2_SH 16
#define B_AX_USB_AUTO_LOAD_STRING_2_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_1_SH 8
#define B_AX_USB_AUTO_LOAD_STRING_1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_0_SH 0
#define B_AX_USB_AUTO_LOAD_STRING_0_MSK 0xff

#define R_AX_USB_OTHERS_7 0x124C
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_SH 22
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_SH 14
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_FLAG BIT(13)
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_SH 7
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_MSK 0x3f
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_SH 0
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_MSK 0x7f

#define R_AX_USB_FW_IMR 0x1258
#define B_AX_IO_OFFREG_TIMEOUT_INT_EN BIT(8)
#define B_AX_IO_ONREG_TIMEOUT_INT_EN BIT(0)

#define R_AX_HUSBIMR 0x1270
#define B_AX_HD1ISR_B00_IND_INT_EN BIT(26)
#define B_AX_USBRX_INT_EN BIT(7)
#define B_AX_PUSBTX_CH12_INT_EN BIT(6)
#define B_AX_USBTX_CH10_INT_EN BIT(5)
#define B_AX_USBTX_CH8_INT_EN BIT(4)
#define B_AX_USBTX_ACH6_INT_EN BIT(3)
#define B_AX_USBTX_ACH4_INT_EN BIT(2)
#define B_AX_USBTX_ACH2_INT_EN BIT(1)
#define B_AX_USBTX_ACH0_INT_EN BIT(0)

#define R_AX_HUSBISR 0x1274
#define B_AX_HD1ISR_B00_IND_INT BIT(26)
#define B_AX_USBRX_INT BIT(7)
#define B_AX_PUSBTX_CH12_INT BIT(6)
#define B_AX_USBTX_CH10_INT BIT(5)
#define B_AX_USBTX_CH8_INT BIT(4)
#define B_AX_USBTX_ACH6_INT BIT(3)
#define B_AX_USBTX_ACH4_INT BIT(2)
#define B_AX_USBTX_ACH2_INT BIT(1)
#define B_AX_USBTX_ACH0_INT BIT(0)

//
// WL_AX_Reg_USB.xls
//

//
// USB_REG
//

#define R_AX_USB_WATCHDOG 0x1260
#define B_AX_USBIO_WD_FLAG BIT(31)
#define B_AX_USBIO_WD_EN BIT(30)
#define B_AX_USBIO_WD_TIMER_SH 24
#define B_AX_USBIO_WD_TIMER_MSK 0xf
#define B_AX_USBIO_WD_ADDR_SH 0
#define B_AX_USBIO_WD_ADDR_MSK 0xffffff

//
// WL_AX_Reg_USB.xls
//

//
// USB_REG
//

#define R_AX_USB2_MAC_0_V1 0x5000
#define B_AX_TOUT_DELAY_FS_V1_SH 24
#define B_AX_TOUT_DELAY_FS_V1_MSK 0xff
#define B_AX_TOUT_DELAY_HS_V1_SH 16
#define B_AX_TOUT_DELAY_HS_V1_MSK 0xff
#define B_AX_TOUT_DIS_V1 BIT(15)
#define B_AX_CRC_CHK_OPT_V1 BIT(14)
#define B_AX_FORCE_PCERST_V1 BIT(13)
#define B_AX_FORCE_TOGL_V1 BIT(12)
#define B_AX_FORCE_TOGLSEL_V1 BIT(11)
#define B_AX_FORCE_PIDSW_V1 BIT(10)
#define B_AX_FORCE_PCE_IN_V1 BIT(9)
#define B_AX_FORCE_PCE_OUT_V1 BIT(8)
#define B_AX_PID_FORCE_V1_SH 0
#define B_AX_PID_FORCE_V1_MSK 0xff

#define R_AX_USB2_MAC_1_V1 0x5004
#define B_AX_FORCE_PCE_CMD_V1 BIT(31)

#define R_AX_USB2_LINK_PORT_V1 0x5008
#define B_AX_R_HOST_PWR_CTRL_V1 BIT(23)
#define B_AX_R_USB2_CLR_TXVLD_V1 BIT(22)
#define B_AX_R_USB2_SE0_V1 BIT(21)
#define B_AX_HOST_RESUME_EDGE_EN_V1 BIT(20)
#define B_AX_RESUME_SEL_V1_SH 16
#define B_AX_RESUME_SEL_V1_MSK 0xf
#define B_AX_DELAY_CHIRP_K_V1_SH 14
#define B_AX_DELAY_CHIRP_K_V1_MSK 0x3
#define B_AX_FORCE_TXVLD1_V1 BIT(13)
#define B_AX_FORCE_TXVLD0_V1 BIT(12)
#define B_AX_DORCE_DAT1_V1 BIT(11)
#define B_AX_FORCE_DAT0_V1 BIT(10)
#define B_AX_LS_TEST_V1 BIT(9)
#define B_AX_LS_CHANGE_V1 BIT(8)
#define B_AX_FORCE_HS_SW_V1 BIT(7)
#define B_AX_FORCE_FS_SW_V1 BIT(6)
#define B_AX_FORCE_HSXCVR_V1 BIT(5)
#define B_AX_FORCE_FSXCVR_V1 BIT(4)
#define B_AX_FORCE_HSTERM_V1 BIT(3)
#define B_AX_FORCE_FSTERM_V1 BIT(2)
#define B_AX_FORCE_NORM_SW_V1 BIT(1)
#define B_AX_FORCE_DBSN_V1 BIT(0)

#define R_AX_USB2_LPM_0_V1 0x5010
#define B_AX_USBPHY_PLL_ALIVE_V1 BIT(17)
#define B_AX_USB_LPM_MAX_EN_V1 BIT(16)
#define B_AX_USB_LPM_MIN_EN_V1 BIT(15)
#define B_AX_BESL_EN_V1 BIT(14)
#define B_AX_USB_LPM_NYET_EN_V1 BIT(13)
#define B_AX_USB_LPM_MAX_ACK_V1 BIT(12)
#define B_AX_USB_LPM_EN_V1 BIT(11)
#define B_AX_USB2_SUSB_V1 BIT(10)
#define B_AX_LPM_PLL_ALIVE_V1 BIT(9)
#define B_AX_USB_LPS_OUT_V1 BIT(8)
#define B_AX_USB_LPM_WAKEUP_EN_V1 BIT(6)
#define B_AX_NEVER_SUSPEND_V1 BIT(5)
#define B_AX_SUSPND_EN_V1 BIT(4)
#define B_AX_WAKEUP_EN_V1 BIT(3)
#define B_AX_USB_SUS_WAKEUP_EN_V1 BIT(2)
#define B_AX_RESUME_SND_V1 BIT(1)
#define B_AX_CONNECT_EN_V1 BIT(0)

#define R_AX_USB2_LPM_1_V1 0x5014
#define B_AX_USB_LPM_MAX_V1_SH 20
#define B_AX_USB_LPM_MAX_V1_MSK 0xf
#define B_AX_USB_LPM_MIN_V1_SH 16
#define B_AX_USB_LPM_MIN_V1_MSK 0xf
#define B_AX_R_WAKE_HOST_WT_H_V1_SH 8
#define B_AX_R_WAKE_HOST_WT_H_V1_MSK 0xff
#define B_AX_R_WAKE_HOST_WT_L_V1_SH 0
#define B_AX_R_WAKE_HOST_WT_L_V1_MSK 0xff

#define R_AX_USB2_MACRO_TEST_MODE_V1 0x5018
#define B_AX_TXRDY_SLB_SEL_V1 BIT(14)
#define B_AX_SLB_EN_V1 BIT(13)
#define B_AX_SLB_RST_V1 BIT(12)
#define B_AX_SLB_FAIL_V1 BIT(11)
#define B_AX_SLB_DONE_V1 BIT(10)
#define B_AX_SLB_PS1_SW_V1_SH 8
#define B_AX_SLB_PS1_SW_V1_MSK 0x3
#define B_AX_PHY_LOOP_TEST_V1 BIT(3)
#define B_AX_USBTMOD_V1_SH 0
#define B_AX_USBTMOD_V1_MSK 0x7

#define R_AX_USB2_PHY_REG_0_V1 0x5020
#define B_AX_USB2PHY_REG_EN_V1 BIT(17)
#define B_AX_VLPADM_V1 BIT(16)
#define B_AX_VSTATUS_IN_V1_SH 8
#define B_AX_VSTATUS_IN_V1_MSK 0xff
#define B_AX_VCONTROL_V1_SH 0
#define B_AX_VCONTROL_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_1_V1 0x5024
#define B_AX_USB2PHY_DELAY_V1_SH 8
#define B_AX_USB2PHY_DELAY_V1_MSK 0xff
#define B_AX_VSTATUS_OUT_V1_SH 0
#define B_AX_VSTATUS_OUT_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_2_V1 0x5028
#define B_AX_USB2_PHY_P0_E3_V1_SH 24
#define B_AX_USB2_PHY_P0_E3_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E2_V1_SH 16
#define B_AX_USB2_PHY_P0_E2_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E1_V1_SH 8
#define B_AX_USB2_PHY_P0_E1_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E0_V1_SH 0
#define B_AX_USB2_PHY_P0_E0_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_3_V1 0x502C
#define B_AX_USB2_PHY_P0_E7_V1_SH 24
#define B_AX_USB2_PHY_P0_E7_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E6_V1_SH 16
#define B_AX_USB2_PHY_P0_E6_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E5_V1_SH 8
#define B_AX_USB2_PHY_P0_E5_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E4_V1_SH 0
#define B_AX_USB2_PHY_P0_E4_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_4_V1 0x5030
#define B_AX_USB2_PHY_P1_E3_V1_SH 24
#define B_AX_USB2_PHY_P1_E3_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E2_V1_SH 16
#define B_AX_USB2_PHY_P1_E2_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E1_V1_SH 8
#define B_AX_USB2_PHY_P1_E1_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E0_V1_SH 0
#define B_AX_USB2_PHY_P1_E0_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_5_V1 0x5034
#define B_AX_USB2_PHY_P1_E7_V1_SH 24
#define B_AX_USB2_PHY_P1_E7_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E6_V1_SH 16
#define B_AX_USB2_PHY_P1_E6_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E5_V1_SH 8
#define B_AX_USB2_PHY_P1_E5_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E4_V1_SH 0
#define B_AX_USB2_PHY_P1_E4_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_6_V1 0x5038
#define B_AX_USB2_PHY_F3_V1_SH 24
#define B_AX_USB2_PHY_F3_V1_MSK 0xff
#define B_AX_USB2_PHY_F2_V1_SH 16
#define B_AX_USB2_PHY_F2_V1_MSK 0xff
#define B_AX_USB2_PHY_F1_V1_SH 8
#define B_AX_USB2_PHY_F1_V1_MSK 0xff
#define B_AX_USB2_PHY_F0_V1_SH 0
#define B_AX_USB2_PHY_F0_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_7_V1 0x503C
#define B_AX_USB2_PHY_F7_V1_SH 24
#define B_AX_USB2_PHY_F7_V1_MSK 0xff
#define B_AX_USB2_PHY_F6_V1_SH 16
#define B_AX_USB2_PHY_F6_V1_MSK 0xff
#define B_AX_USB2_PHY_F5_V1_SH 8
#define B_AX_USB2_PHY_F5_V1_MSK 0xff
#define B_AX_USB2_PHY_F4_V1_SH 0
#define B_AX_USB2_PHY_F4_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_8_V1 0x5040
#define B_AX_USB2PHY_UPDATE_2_V1_SH 16
#define B_AX_USB2PHY_UPDATE_2_V1_MSK 0xff
#define B_AX_USB2PHY_UPDATE_1_V1_SH 8
#define B_AX_USB2PHY_UPDATE_1_V1_MSK 0xff
#define B_AX_USB2PHY_UPDATE_0_V1_SH 0
#define B_AX_USB2PHY_UPDATE_0_V1_MSK 0xff
#define B_AX_VENDOR_IDX_UPPER_BOND_SH 0
#define B_AX_VENDOR_IDX_UPPER_BOND_MSK 0xff

#define R_AX_USB_ENDPOINT_0_V1 0x5060
#define B_AX_EP_MAXPKT_V1_SH 16
#define B_AX_EP_MAXPKT_V1_MSK 0x3ff
#define B_AX_EP_EN_V1 BIT(15)
#define B_AX_EP_TYPE_V1_SH 13
#define B_AX_EP_TYPE_V1_MSK 0x3
#define B_AX_EP_ISTALL_V1 BIT(12)
#define B_AX_EP_OSTALL_V1 BIT(11)
#define B_AX_EP_STREAMEN_V1 BIT(10)
#define B_AX_EP_OUT_V1 BIT(9)
#define B_AX_EP_IN_V1 BIT(8)
#define B_AX_BT_INTR_SEL_V1 BIT(5)
#define B_AX_R_SIE_INIT_DONE_V1 BIT(4)
#define B_AX_EP_IDX_V1_SH 0
#define B_AX_EP_IDX_V1_MSK 0xf

#define R_AX_USB_ENDPOINT_1_V1 0x5064
#define B_AX_EP_MAX_STREAM_V1_SH 16
#define B_AX_EP_MAX_STREAM_V1_MSK 0xff
#define B_AX_EP_MAX_BURST_V1_SH 8
#define B_AX_EP_MAX_BURST_V1_MSK 0xff
#define B_AX_EP_INT_INTERVAL_V1_SH 0
#define B_AX_EP_INT_INTERVAL_V1_MSK 0xff

#define R_AX_USB_ENDPOINT_2_V1 0x5068
#define B_AX_EP_BPI_V1_SH 16
#define B_AX_EP_BPI_V1_MSK 0xffff
#define B_AX_USB3_EP_IN_ST_V1_SH 8
#define B_AX_USB3_EP_IN_ST_V1_MSK 0xff
#define B_AX_USB3_EP_OUT_ST_V1_SH 0
#define B_AX_USB3_EP_OUT_ST_V1_MSK 0xff

#define R_AX_USB_ENDPOINT_3_V1 0x506C
#define B_AX_EP12_PAUSE_STATE_V1 BIT(31)
#define B_AX_EP11_PAUSE_STATE_V1 BIT(30)
#define B_AX_EP10_PAUSE_STATE_V1 BIT(29)
#define B_AX_EP9_PAUSE_STATE_V1 BIT(28)
#define B_AX_EP8_PAUSE_STATE_V1 BIT(27)
#define B_AX_EP7_PAUSE_STATE_V1 BIT(26)
#define B_AX_EP6_PAUSE_STATE_V1 BIT(25)
#define B_AX_EP5_PAUSE_STATE_V1 BIT(24)
#define B_AX_EP4_PAUSE_STATE_V1 BIT(23)
#define B_AX_EP12_TX_PAUSE_V1 BIT(22)
#define B_AX_EP11_TX_PAUSE_V1 BIT(21)
#define B_AX_EP10_TX_PAUSE_V1 BIT(20)
#define B_AX_EP9_TX_PAUSE_V1 BIT(19)
#define B_AX_EP8_RX_PAUSE_V1 BIT(18)
#define B_AX_EP7_TX_PAUSE_V1 BIT(17)
#define B_AX_EP6_TX_PAUSE_V1 BIT(16)
#define B_AX_EP5_TX_PAUSE_V1 BIT(15)
#define B_AX_EP4_RX_PAUSE_V1 BIT(14)
#define B_AX_INTERRUPT_BULK_IN_V1 BIT(12)
#define B_AX_AC_BULKOUT_V1_SH 10
#define B_AX_AC_BULKOUT_V1_MSK 0x3
#define B_AX_BULKOUT1_V1 BIT(9)
#define B_AX_BULKOUT0_V1 BIT(8)
#define B_AX_INTERRUPT_INTERVAL_V1_SH 0
#define B_AX_INTERRUPT_INTERVAL_V1_MSK 0xf

#define R_AX_USB_HOST_REQUEST_0_V1 0x5070
#define B_AX_ERR_STR2_LEN_V1_SH 24
#define B_AX_ERR_STR2_LEN_V1_MSK 0xff
#define B_AX_ERR_STR1_LEN_V1_SH 8
#define B_AX_ERR_STR1_LEN_V1_MSK 0xffff
#define B_AX_DEVADDR_V1_SH 0
#define B_AX_DEVADDR_V1_MSK 0x7f

#define R_AX_USB_HOST_REQUEST_1_V1 0x5074
#define B_AX_USB_PID_V1_SH 16
#define B_AX_USB_PID_V1_MSK 0xffff
#define B_AX_USB_VID_V1_SH 0
#define B_AX_USB_VID_V1_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_2_V1 0x5078
#define B_AX_MAC_ADDR_1_V1_SH 24
#define B_AX_MAC_ADDR_1_V1_MSK 0xff
#define B_AX_MAC_ADDR_0_V1_SH 16
#define B_AX_MAC_ADDR_0_V1_MSK 0xff
#define B_AX_FORCE_LPM_BCD201_V1 BIT(15)
#define B_AX_SELF_POWER_EN_V1 BIT(14)
#define B_AX_R_FORCE_U3MAC_HS_MODE_V1 BIT(13)
#define B_AX_LOAD_LTM_CAP_V1 BIT(12)
#define B_AX_USB3_DEV_CAP_DESC_EN_V1 BIT(11)
#define B_AX_AUTOLOAD_STRING_EN_V1 BIT(10)
#define B_AX_REMOTE_WAKEUP_V1 BIT(9)
#define B_AX_SQNUM_ROM_V1 BIT(8)
#define B_AX_ERR_STR2_LEN_FLAG_V1 BIT(7)
#define B_AX_ERR_STR1_LEN_FLAG_V1 BIT(6)
#define B_AX_ERR_STR0_LEN_FLAG_V1 BIT(5)
#define B_AX_R_USBIO_MODE_V1 BIT(4)
#define B_AX_EXREG_TO_EN_V1 BIT(3)
#define B_AX_EXREG_TO_SEL_V1_SH 0
#define B_AX_EXREG_TO_SEL_V1_MSK 0x7

#define R_AX_USB_HOST_REQUEST_3_V1 0x507C
#define B_AX_MAC_ADDR_5_V1_SH 24
#define B_AX_MAC_ADDR_5_V1_MSK 0xff
#define B_AX_MAC_ADDR_4_V1_SH 16
#define B_AX_MAC_ADDR_4_V1_MSK 0xff
#define B_AX_MAC_ADDR_3_V1_SH 8
#define B_AX_MAC_ADDR_3_V1_MSK 0xff
#define B_AX_MAC_ADDR_2_V1_SH 0
#define B_AX_MAC_ADDR_2_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_4_V1 0x5080
#define B_AX__MANUFACTURE_STRING_3_V1_SH 24
#define B_AX__MANUFACTURE_STRING_3_V1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_2_V1_SH 16
#define B_AX__MANUFACTURE_STRING_2_V1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_1_V1_SH 8
#define B_AX__MANUFACTURE_STRING_1_V1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_0_V1_SH 0
#define B_AX__MANUFACTURE_STRING_0_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_5_V1 0x5084
#define B_AX_MANUFACTURE_STRING_7_V1_SH 24
#define B_AX_MANUFACTURE_STRING_7_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_6_V1_SH 16
#define B_AX_MANUFACTURE_STRING_6_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_5_V1_SH 8
#define B_AX_MANUFACTURE_STRING_5_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_4_V1_SH 0
#define B_AX_MANUFACTURE_STRING_4_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_6_V1 0x5088
#define B_AX_MANUFACTURE_STRING_B_V1_SH 24
#define B_AX_MANUFACTURE_STRING_B_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_A_V1_SH 16
#define B_AX_MANUFACTURE_STRING_A_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_9_V1_SH 8
#define B_AX_MANUFACTURE_STRING_9_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_8_V1_SH 0
#define B_AX_MANUFACTURE_STRING_8_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_7_V1 0x508C
#define B_AX_MANUFACTURE_STRING_F_V1_SH 24
#define B_AX_MANUFACTURE_STRING_F_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_E_V1_SH 16
#define B_AX_MANUFACTURE_STRING_E_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_D_V1_SH 8
#define B_AX_MANUFACTURE_STRING_D_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_C_V1_SH 0
#define B_AX_MANUFACTURE_STRING_C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_8_V1 0x5090
#define B_AX_MANUFACTURE_STRING_13_V1_SH 24
#define B_AX_MANUFACTURE_STRING_13_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_12_V1_SH 16
#define B_AX_MANUFACTURE_STRING_12_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_11_V1_SH 8
#define B_AX_MANUFACTURE_STRING_11_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_10_V1_SH 0
#define B_AX_MANUFACTURE_STRING_10_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_9_V1 0x5094
#define B_AX_MANUFACTURE_STRING_17_V1_SH 24
#define B_AX_MANUFACTURE_STRING_17_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_16_V1_SH 16
#define B_AX_MANUFACTURE_STRING_16_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_15_V1_SH 8
#define B_AX_MANUFACTURE_STRING_15_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_14_V1_SH 0
#define B_AX_MANUFACTURE_STRING_14_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_A_V1 0x5098
#define B_AX_MANUFACTURE_STRING_1B_V1_SH 24
#define B_AX_MANUFACTURE_STRING_1B_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1A_V1_SH 16
#define B_AX_MANUFACTURE_STRING_1A_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_19_V1_SH 8
#define B_AX_MANUFACTURE_STRING_19_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_18_V1_SH 0
#define B_AX_MANUFACTURE_STRING_18_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_B_V1 0x509C
#define B_AX_MANUFACTURE_STRING_1F_V1_SH 24
#define B_AX_MANUFACTURE_STRING_1F_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1E_V1_SH 16
#define B_AX_MANUFACTURE_STRING_1E_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1D_V1_SH 8
#define B_AX_MANUFACTURE_STRING_1D_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1C_V1_SH 0
#define B_AX_MANUFACTURE_STRING_1C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_C_V1 0x50A0
#define B_AX_PRODUCT_STRING_3_V1_SH 24
#define B_AX_PRODUCT_STRING_3_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2_V1_SH 16
#define B_AX_PRODUCT_STRING_2_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1_V1_SH 8
#define B_AX_PRODUCT_STRING_1_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_0_V1_SH 0
#define B_AX_PRODUCT_STRING_0_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_D_V1 0x50A4
#define B_AX_PRODUCT_STRING_7_V1_SH 24
#define B_AX_PRODUCT_STRING_7_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_6_V1_SH 16
#define B_AX_PRODUCT_STRING_6_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_5_V1_SH 8
#define B_AX_PRODUCT_STRING_5_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_4_V1_SH 0
#define B_AX_PRODUCT_STRING_4_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_E_V1 0x50A8
#define B_AX_PRODUCT_STRING_B_V1_SH 24
#define B_AX_PRODUCT_STRING_B_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_A_V1_SH 16
#define B_AX_PRODUCT_STRING_A_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_9_V1_SH 8
#define B_AX_PRODUCT_STRING_9_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_8_V1_SH 0
#define B_AX_PRODUCT_STRING_8_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_F_V1 0x50AC
#define B_AX_PRODUCT_STRING_F_V1_SH 24
#define B_AX_PRODUCT_STRING_F_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_E_V1_SH 16
#define B_AX_PRODUCT_STRING_E_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_D_V1_SH 8
#define B_AX_PRODUCT_STRING_D_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_C_V1_SH 0
#define B_AX_PRODUCT_STRING_C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_10_V1 0x50B0
#define B_AX_PRODUCT_STRING_13_V1_SH 24
#define B_AX_PRODUCT_STRING_13_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_12_V1_SH 16
#define B_AX_PRODUCT_STRING_12_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_11_V1_SH 8
#define B_AX_PRODUCT_STRING_11_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_10_V1_SH 0
#define B_AX_PRODUCT_STRING_10_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_11_V1 0x50B4
#define B_AX_PRODUCT_STRING_17_V1_SH 24
#define B_AX_PRODUCT_STRING_17_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_16_V1_SH 16
#define B_AX_PRODUCT_STRING_16_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_15_V1_SH 8
#define B_AX_PRODUCT_STRING_15_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_14_V1_SH 0
#define B_AX_PRODUCT_STRING_14_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_12_V1 0x50B8
#define B_AX_PRODUCT_STRING_1B_V1_SH 24
#define B_AX_PRODUCT_STRING_1B_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1A_V1_SH 16
#define B_AX_PRODUCT_STRING_1A_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_19_V1_SH 8
#define B_AX_PRODUCT_STRING_19_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_18_V1_SH 0
#define B_AX_PRODUCT_STRING_18_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_13_V1 0x50BC
#define B_AX_PRODUCT_STRING_1F_V1_SH 24
#define B_AX_PRODUCT_STRING_1F_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1E_V1_SH 16
#define B_AX_PRODUCT_STRING_1E_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1D_V1_SH 8
#define B_AX_PRODUCT_STRING_1D_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1C_V1_SH 0
#define B_AX_PRODUCT_STRING_1C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_14_V1 0x50C0
#define B_AX_PRODUCT_STRING_23_V1_SH 24
#define B_AX_PRODUCT_STRING_23_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_22_V1_SH 16
#define B_AX_PRODUCT_STRING_22_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_21_V1_SH 8
#define B_AX_PRODUCT_STRING_21_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_20_V1_SH 0
#define B_AX_PRODUCT_STRING_20_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_15_V1 0x50C4
#define B_AX_PRODUCT_STRING_27_V1_SH 24
#define B_AX_PRODUCT_STRING_27_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_26_V1_SH 16
#define B_AX_PRODUCT_STRING_26_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_25_V1_SH 8
#define B_AX_PRODUCT_STRING_25_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_24_V1_SH 0
#define B_AX_PRODUCT_STRING_24_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_16_V1 0x50C8
#define B_AX_PRODUCT_STRING_2B_V1_SH 24
#define B_AX_PRODUCT_STRING_2B_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2A_V1_SH 16
#define B_AX_PRODUCT_STRING_2A_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_29_V1_SH 8
#define B_AX_PRODUCT_STRING_29_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_28_V1_SH 0
#define B_AX_PRODUCT_STRING_28_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_17_V1 0x50CC
#define B_AX_PRODUCT_STRING_2F_V1_SH 24
#define B_AX_PRODUCT_STRING_2F_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2E_V1_SH 16
#define B_AX_PRODUCT_STRING_2E_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2D_V1_SH 8
#define B_AX_PRODUCT_STRING_2D_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2C_V1_SH 0
#define B_AX_PRODUCT_STRING_2C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_18_V1 0x50D0
#define B_AX_SERIAL_NUMBER_STRING_3_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_3_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_2_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_2_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_1_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_1_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_0_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_0_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_19_V1 0x50D4
#define B_AX_SERIAL_NUMBER_STRING_7_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_7_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_6_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_6_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_5_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_5_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_4_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_4_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1A_V1 0x50D8
#define B_AX_SERIAL_NUMBER_STRING_B_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_B_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_A_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_A_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_9_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_9_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_8_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_8_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1B_V1 0x50DC
#define B_AX_SERIAL_NUMBER_STRING_F_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_F_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_E_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_E_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_D_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_D_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_C_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1C_V1 0x50E0
#define B_AX_USB3_U2SEL_V1_SH 16
#define B_AX_USB3_U2SEL_V1_MSK 0xffff
#define B_AX_USB3_U1PEL_V1_SH 0
#define B_AX_USB3_U1PEL_V1_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_1D_V1 0x50E4
#define B_AX_HW_VENDOR_INDEX_V1_SH 16
#define B_AX_HW_VENDOR_INDEX_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1E_V1 0x50E8
#define B_AX_DIS_STALL_FUNC_WAKE_V1 BIT(24)
#define B_AX_USB3_U2_DEV_EXIT_LAT_V1_SH 8
#define B_AX_USB3_U2_DEV_EXIT_LAT_V1_MSK 0xffff
#define B_AX_USB3_U1_DEV_EXIT_LAT_V1_SH 0
#define B_AX_USB3_U1_DEV_EXIT_LAT_V1_MSK 0xff

#define R_AX_USB3_MAC_LINK_0_V1 0x5100
#define B_AX_INTS_USB3_HRESET_EN_V1 BIT(31)
#define B_AX_INTS_USB3_RECOV_EN_V1 BIT(30)
#define B_AX_INTS_USB3_LPBK_EN_V1 BIT(29)
#define B_AX_INTS_USB3_RXDET_EN_V1 BIT(28)
#define B_AX_INTS_USB3_POLL_EN_V1 BIT(27)
#define B_AX_INTS_USB3_U3_EN_V1 BIT(26)
#define B_AX_INTS_USB3_U1U2_EN_V1 BIT(25)
#define B_AX_INTS_USB3_U0_EN_V1 BIT(24)
#define B_AX_INTS_USB3_RECOV2U0_EN_V1 BIT(23)
#define B_AX_INTS_USB3_SSINACT_EN_V1 BIT(22)
#define B_AX_INTS_USB3_SSDIS_EN_V1 BIT(21)
#define B_AX_INTS_USB3_CMPLY_EN_V1 BIT(20)
#define B_AX_INTS_USB3_RECOV2U0_V1 BIT(19)
#define B_AX_INTS_USB3_SSINACT_V1 BIT(18)
#define B_AX_INTS_USB3_SSDIS_V1 BIT(17)
#define B_AX_INTS_USB3_CMPLY_V1 BIT(16)
#define B_AX_INTS_USB3_HRESET_V1 BIT(15)
#define B_AX_INTS_USB3_RECOV_V1 BIT(14)
#define B_AX_INTS_USB3_LPBK_V1 BIT(13)
#define B_AX_INTS_USB3_RXDET_V1 BIT(12)
#define B_AX_INTS_USB3_POLL_V1 BIT(11)
#define B_AX_INTS_USB3_U3_V1 BIT(10)
#define B_AX_INTS_USB3_U1U2_V1 BIT(9)
#define B_AX_INTS_USB3_U0_V1 BIT(8)
#define B_AX_EN_ROVIDLE_TIMEOUT_V1 BIT(6)
#define B_AX_EN_UNFIN_RTY_V1 BIT(5)
#define B_AX_SSPHY_U1_QUICK_LFPS_V1 BIT(4)
#define B_AX_USB3_DIS_ISOC_TIME_GT_V1 BIT(3)
#define B_AX_R_DIS_USB3_U2_EN_V1 BIT(2)
#define B_AX_R_DIS_USB3_U1_EN_V1 BIT(1)
#define B_AX_LINK_ST_DETECT_TERM_V1 BIT(0)

#define R_AX_USB3_MAC_LINK_1_V1 0x5104
#define B_AX_WARM_RESET_TIME_V1_SH 0
#define B_AX_WARM_RESET_TIME_V1_MSK 0x3

#define R_AX_USB3_MAC_PIU_V1 0x5108
#define B_AX_SSPHY_CLR_TERM_V1 BIT(1)
#define B_AX_SSPHY_SET_TERM_V1 BIT(0)

#define R_AX_USB3_MAC_PTL_V1 0x510C
#define B_AX_BCDVALUE_V1_SH 2
#define B_AX_BCDVALUE_V1_MSK 0x3
#define B_AX_WLAN0_BUF_NUMP_EN_V1 BIT(1)
#define B_AX_IGNORE_RETRY_BIT_V1 BIT(0)

#define R_AX_USB3_MAC_PRTSM_V1 0x5110
#define B_AX_EN_IMMED_POP_CREDIT_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_0_V1 0x5114
#define B_AX_SSPHY_LFPS_FILTER_V1 BIT(31)
#define B_AX_SSPHY_TX_SWING_V1 BIT(30)
#define B_AX_SSPHY_TXMARGIN_V1_SH 27
#define B_AX_SSPHY_TXMARGIN_V1_MSK 0x7
#define B_AX_SSPHY_TXDEEMPHASIS_V1_SH 25
#define B_AX_SSPHY_TXDEEMPHASIS_V1_MSK 0x3
#define B_AX_SSPHY_ELASTIC_BUF_V1 BIT(24)
#define B_AX_HIRD_THR_V1_SH 19
#define B_AX_HIRD_THR_V1_MSK 0x1f
#define B_AX_DEV_SPEED_V1_SH 16
#define B_AX_DEV_SPEED_V1_MSK 0x7
#define B_AX_U1_ACTIVE_TIMEOUT_V1_SH 8
#define B_AX_U1_ACTIVE_TIMEOUT_V1_MSK 0xff
#define B_AX_USB3_TARGET_LINK_STATE_V1_SH 4
#define B_AX_USB3_TARGET_LINK_STATE_V1_MSK 0xf
#define B_AX_APPL1RSP_V1 BIT(3)
#define B_AX_LPM_CAPABLE_V1 BIT(2)
#define B_AX_USB3_EOF_V1_SH 0
#define B_AX_USB3_EOF_V1_MSK 0x3

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_1_V1 0x5118
#define B_AX_NPI_SCALEDOWN_MODE_V1_SH 24
#define B_AX_NPI_SCALEDOWN_MODE_V1_MSK 0x3
#define B_AX_SSPHY_POWERDOWN_SCALE_V1_SH 8
#define B_AX_SSPHY_POWERDOWN_SCALE_V1_MSK 0x1fff
#define B_AX_SSPHY_U1_FAST_OUT_V1 BIT(7)
#define B_AX_SSPHY_P3_FOR_P2_V1 BIT(6)
#define B_AX_SSPHY_U1_RXVALID_V1 BIT(5)
#define B_AX_SSPHY_DIS_SCAMBLE_V1 BIT(4)
#define B_AX_SSPHY_SKIP_RXDETECT_V1 BIT(3)
#define B_AX_SSPHY_LFPS_P0_ALIGN_V1 BIT(2)
#define B_AX_SSPHY_P3P2_TRANS_V1 BIT(1)
#define B_AX_SSPHY_P3_EXITIN_P2_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_2_V1 0x511C
#define B_AX_SSPHY_U2EXIT_LPFS_V1 BIT(18)
#define B_AX_SSPHY_PHYSOFTRST_V1 BIT(17)
#define B_AX_SSPHY_HSTPRTCMPL_V1 BIT(16)
#define B_AX_SSPHY_U2SSINACTP3OK_V1 BIT(15)
#define B_AX_SSPHY_DISRXDETP3_V1 BIT(14)
#define B_AX_SSPHY_UX_EXIT_IN_PX_V1 BIT(13)
#define B_AX_SSPHY_PING_ENH_EN_V1 BIT(12)
#define B_AX_SSPHY_U1U2EXITFAIL_TO_RECOV_V1 BIT(11)
#define B_AX_SSPHY_ALWAYS_REQ_V1 BIT(10)
#define B_AX_SSPHY_START_RX_DET_V1 BIT(9)
#define B_AX_SSPHY_DIS_RX_DET_V1 BIT(8)
#define B_AX_SSPHY_DELAY_P1P2P3_V1_SH 5
#define B_AX_SSPHY_DELAY_P1P2P3_V1_MSK 0x7
#define B_AX_SSPHY_SUSPEND_EN_V1 BIT(4)
#define B_AX_SSPHY_DATWIDTH_V1_SH 2
#define B_AX_SSPHY_DATWIDTH_V1_MSK 0x3
#define B_AX_SSPHY_ABORTRXDETLNU2_V1 BIT(1)
#define B_AX_SSPHY_RX_DETECT_LPFS_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_0_V1 0x5120
#define B_AX_U3_LTM_EN_V1 BIT(28)
#define B_AX_LINK_STATE_REQ_V1_SH 24
#define B_AX_LINK_STATE_REQ_V1_MSK 0xf
#define B_AX_SUSCLK_RATIO_V1_SH 8
#define B_AX_SUSCLK_RATIO_V1_MSK 0x1fff
#define B_AX_TEST_CTRL_V1_SH 4
#define B_AX_TEST_CTRL_V1_MSK 0xf
#define B_AX_UFRAME_SCALE_V1_SH 2
#define B_AX_UFRAME_SCALE_V1_MSK 0x3
#define B_AX_LOCAL_LBK_V1 BIT(1)
#define B_AX_EN_SLEEP_USB_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_1_V1 0x5124
#define B_AX_WAKE_WAIT_XTAL_V1 BIT(27)
#define B_AX_WAKE_WAIT_CURRENT_V1 BIT(26)
#define B_AX_WAKEUP_NEG_SEL_V1 BIT(25)
#define B_AX_SSPHY_USB3_ATTEMPT_V1 BIT(24)
#define B_AX_WAIT_IDLE_TIME_V1_SH 20
#define B_AX_WAIT_IDLE_TIME_V1_MSK 0xf
#define B_AX_U2_EN_MAC_IDLE_V1 BIT(18)
#define B_AX_U1_EN_MAC_IDLE_V1 BIT(17)
#define B_AX_SWITCH_CLK_EN_V1 BIT(16)
#define B_AX_USB3_SAMPLE_RXELECIDLE_V1_SH 8
#define B_AX_USB3_SAMPLE_RXELECIDLE_V1_MSK 0xff
#define B_AX_U3_INIT_U2_V1 BIT(7)
#define B_AX_U3_INIT_U1_V1 BIT(6)
#define B_AX_SET_U3_WAKE_V1 BIT(5)
#define B_AX_U3_U2_EN_V1 BIT(4)
#define B_AX_U3_U1_EN_V1 BIT(3)
#define B_AX_U3_INIT_U2_EN_V1 BIT(2)
#define B_AX_U3_INIT_U1_EN_V1 BIT(1)
#define B_AX_USB3_RUN_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_2_V1 0x5128
#define B_AX_NPI_LINK_STATE_LATCH_V1_SH 16
#define B_AX_NPI_LINK_STATE_LATCH_V1_MSK 0xff
#define B_AX_NPI_HOST_RESUME_DETECTED_V1 BIT(15)
#define B_AX_NPI_DEV_CONNECT_SPEED_V1_SH 12
#define B_AX_NPI_DEV_CONNECT_SPEED_V1_MSK 0x7
#define B_AX_NPI_LINK_STATE_V1_SH 8
#define B_AX_NPI_LINK_STATE_V1_MSK 0xf
#define B_AX_POLL_EN_V1 BIT(7)
#define B_AX_POLL_SAMPLE_ON_V1 BIT(6)
#define B_AX_POLL_ACT_V1_SH 4
#define B_AX_POLL_ACT_V1_MSK 0x3
#define B_AX_POLL_NOACT_V1_SH 0
#define B_AX_POLL_NOACT_V1_MSK 0xf

#define R_AX_USB3_MAC_NPI_POWER_3_V1 0x512C
#define B_AX_R_CNT_SWITCH_USB32_PARA_V1_SH 0
#define B_AX_R_CNT_SWITCH_USB32_PARA_V1_MSK 0xffff

#define R_AX_USB3_MAC_NPI_STATUS_V1 0x5130
#define B_AX_NPI_DEV_CONNECTED_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_DEVICE_NOTIFICATION_V1 0x5134
#define B_AX_DEVNOTE_BIA_V1_SH 16
#define B_AX_DEVNOTE_BIA_V1_MSK 0xffff
#define B_AX_DEVNOTE_BELT_V1_SH 0
#define B_AX_DEVNOTE_BELT_V1_MSK 0xfff

#define R_AX_USB3_MAC_NPI_TRANSMIT_V1 0x5138
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_V1_SH 0
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_V1_MSK 0xf

#define R_AX_USB3_MAC_NPI_OTHERS_V1 0x513C
#define B_AX_EN_FIX_RX_ABORT_V1 BIT(8)
#define B_AX_FLADJ_30MHZ_REG_V1_SH 0
#define B_AX_FLADJ_30MHZ_REG_V1_MSK 0x3f

#define R_AX_USB3_WRAP_0_V1 0x5140
#define B_AX_U1TOU2_TIMER_V1_SH 24
#define B_AX_U1TOU2_TIMER_V1_MSK 0xff
#define B_AX_WAKE_ST_DBG_V1_SH 20
#define B_AX_WAKE_ST_DBG_V1_MSK 0xf
#define B_AX_ARB_ST_DBG_V1_SH 18
#define B_AX_ARB_ST_DBG_V1_MSK 0x3
#define B_AX_BIA_REQ_V1 BIT(17)
#define B_AX_BELT_REQ_V1 BIT(16)
#define B_AX_USB3_VENDOR_LEN_TH_V1_SH 0
#define B_AX_USB3_VENDOR_LEN_TH_V1_MSK 0xffff

#define R_AX_USB3_WRAP_1_V1 0x5144
#define B_AX_DIS_PKT_FUNC_WAKE_V1 BIT(0)

#define R_AX_USB3_PHY_V1 0x5148
#define B_AX_USB3_PHY_RWDATA_V1_SH 16
#define B_AX_USB3_PHY_RWDATA_V1_MSK 0xffff
#define B_AX_USB3_PHY_ADR_V1_SH 8
#define B_AX_USB3_PHY_ADR_V1_MSK 0x1f
#define B_AX_USB3_PHY_REG_WRFLAG_V1 BIT(7)
#define B_AX_USB3_PHY_REG_RDFLAG_V1 BIT(6)
#define B_AX_USB3_PHY_REG_ADR_V1_SH 0
#define B_AX_USB3_PHY_REG_ADR_V1_MSK 0x1f

#define R_AX_USB3_OTHERS_V1 0x5150
#define B_AX_R_REATTACH_TIMER_V1_SH 28
#define B_AX_R_REATTACH_TIMER_V1_MSK 0xf
#define B_AX_R_CNT_MS_SEL_V1_SH 24
#define B_AX_R_CNT_MS_SEL_V1_MSK 0x7
#define B_AX_VENDOR_LPM_TEST_V1_SH 16
#define B_AX_VENDOR_LPM_TEST_V1_MSK 0xff
#define B_AX_ISOC_DELAY_VALUE_V1_SH 0
#define B_AX_ISOC_DELAY_VALUE_V1_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_0_V1 0x5160
#define B_AX_BTRX0_BUFFER_WADDR_V1_SH 24
#define B_AX_BTRX0_BUFFER_WADDR_V1_MSK 0xff
#define B_AX_USB_INTOKEN_TIMEOUT_V1_SH 20
#define B_AX_USB_INTOKEN_TIMEOUT_V1_MSK 0x7
#define B_AX_BRX_BUF_CHK_V1_SH 16
#define B_AX_BRX_BUF_CHK_V1_MSK 0x7
#define B_AX_BTRX0_RPKT_SIZE_V1_SH 0
#define B_AX_BTRX0_RPKT_SIZE_V1_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_1_V1 0x5164
#define B_AX_USB2BT_PWR_INFO_REG_MASK_V1_SH 20
#define B_AX_USB2BT_PWR_INFO_REG_MASK_V1_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_BT_V1 BIT(19)
#define B_AX_LOWPOWER_BT_V1 BIT(18)
#define B_AX_FUNCTION_WAKE_EN_BT_V1 BIT(17)
#define B_AX_FUNCTION_WAKE_CAPABLE_BT_V1 BIT(16)
#define B_AX_BT_ISO_ZERO_EN_V1 BIT(14)
#define B_AX_R_RXDMA_MODE_V1_SH 12
#define B_AX_R_RXDMA_MODE_V1_MSK 0x3
#define B_AX_GPS_USB_ACTIVE_V1 BIT(11)
#define B_AX_BT_TXQ_STOP_V1_SH 8
#define B_AX_BT_TXQ_STOP_V1_MSK 0x7

#define R_AX_USB_APPLICATION_BT_2_V1 0x5168
#define B_AX_BT_TX_V1 BIT(17)
#define B_AX_BT_RX_V1 BIT(16)
#define B_AX_BTTX_FIFO_OVER_EP3_V1 BIT(13)
#define B_AX_BTTX_FIFO_OVER_EP2_V1 BIT(12)
#define B_AX_BTTX_FIFO_OVER_EP0_V1 BIT(11)
#define B_AX_BTRX_FIFO_OVER_EP3_V1 BIT(10)
#define B_AX_BTRX_FIFO_OVER_EP2_V1 BIT(9)
#define B_AX_BTRX_FIFO_OVER_EP1_V1 BIT(8)
#define B_AX_BTTX_FIFO_UNDR_EP3_V1 BIT(5)
#define B_AX_BTTX_FIFO_UNDR_EP2_V1 BIT(4)
#define B_AX_BTTX_FIFO_UNDR_EP0_V1 BIT(3)
#define B_AX_BTRX_FIFO_UNDR_EP3_V1 BIT(2)
#define B_AX_BTRX_FIFO_UNDR_EP2_V1 BIT(1)
#define B_AX_BTRX_FIFO_UNDR_EP1_V1 BIT(0)

#define R_AX_USB_APPLICATION_BT_3_V1 0x516C
#define B_AX_DBG_BTRX_WADDR_V1_SH 16
#define B_AX_DBG_BTRX_WADDR_V1_MSK 0xfff
#define B_AX_DBG_BTRX_RPKT_V1_SH 0
#define B_AX_DBG_BTRX_RPKT_V1_MSK 0xffff

#define R_AX_USB_WLAN0_0_V1 0x5170
#define B_AX_WLAN_INT_LEN_V1_SH 16
#define B_AX_WLAN_INT_LEN_V1_MSK 0xffff
#define B_AX_WLAN0_TXQ_STALL_DIS_V1 BIT(4)
#define B_AX_FUNCTION_SUSB_EN_WLAN0_V1 BIT(3)
#define B_AX_LOWPOWER_WLAN0_V1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN0_V1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN0_V1 BIT(0)

#define R_AX_USB_WLAN0_1_V1 0x5174
#define B_AX_USBRX_RST_V1 BIT(9)
#define B_AX_USBTX_RST_V1 BIT(8)
#define B_AX_R_USBRX_SRAM_LS_V1 BIT(7)
#define B_AX_R_USBRX_SRAM_DS_V1 BIT(6)
#define B_AX_R_USBTX_SRAM_LS_V1 BIT(5)
#define B_AX_R_USBTX_SRAM_DS_V1 BIT(4)
#define B_AX_WLRX_FIFO_OVER_V1_SH 2
#define B_AX_WLRX_FIFO_OVER_V1_MSK 0x3
#define B_AX_WLRX_FIFO_UNDR_V1_SH 0
#define B_AX_WLRX_FIFO_UNDR_V1_MSK 0x3

#define R_AX_USB_AUTO_INSTALL_0_V1 0x5180
#define B_AX_AINST_POLL_1_V1 BIT(28)
#define B_AX_AINST_POLL_0_V1 BIT(27)
#define B_AX_AINST_TX1_CLR_BUF_V1 BIT(26)
#define B_AX_AINST_TX0_CLR_BUF_V1 BIT(25)
#define B_AX_WLAN_FW_RDY_V1 BIT(24)
#define B_AX_RECONF_USBEP_V1 BIT(23)
#define B_AX_RECONF_USBEP_EN_V1 BIT(22)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET_V1 BIT(21)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET_EN_V1 BIT(20)
#define B_AX_AINST_RXLEN_V1_SH 8
#define B_AX_AINST_RXLEN_V1_MSK 0xfff
#define B_AX_AINST_RX1_INTR_V1 BIT(7)
#define B_AX_AINST_RX0_INTR_V1 BIT(6)
#define B_AX_AINXT_TX1_INTR_V1 BIT(5)
#define B_AX_AINST_TX0_INTR_V1 BIT(4)
#define B_AX_AUTO_INST_TXQ_STALL_DIS_V1 BIT(3)
#define B_AX_LOWPOWER_AINST_V1 BIT(2)
#define B_AX_FUNCTION_WANE_EN_AINST_V1 BIT(1)

#define R_AX_USB_AUTO_INSTALL_1_V1 0x5184
#define B_AX_AINST_TX1LEN_V1_SH 16
#define B_AX_AINST_TX1LEN_V1_MSK 0xfff
#define B_AX_AINST_TX0LEN_V1_SH 0
#define B_AX_AINST_TX0LEN_V1_MSK 0xfff

#define R_AX_USB_AUTO_INSTALL_2_V1 0x5188
#define B_AX_AINST_PID_V1_SH 16
#define B_AX_AINST_PID_V1_MSK 0xffff
#define B_AX_AINST_VID_V1_SH 0
#define B_AX_AINST_VID_V1_MSK 0xffff

#define R_AX_USB_AUTO_INSTALL_3_V1 0x518C
#define B_AX_AINST_TXSTATUS_V1_SH 8
#define B_AX_AINST_TXSTATUS_V1_MSK 0xff
#define B_AX_AINST_RXSTATUS_V1_SH 0
#define B_AX_AINST_RXSTATUS_V1_MSK 0xff

#define R_AX_USB_BRIDGE_UART_0_V1 0x5190
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_V1_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_V1_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_V1_SH 16
#define B_AX_BRIDGE_XFACTOR_V1_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB2_V1_SH 0
#define B_AX_BRIDGE_BAUD_USB2_V1_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_1_V1 0x5194
#define B_AX_BRIDGE_WAKEUP_EN_V1_SH 30
#define B_AX_BRIDGE_WAKEUP_EN_V1_MSK 0x3
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_V1_SH 16
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_V1_MSK 0xfff
#define B_AX_BRIDGE_LE_CON_HAN_VLD_V1 BIT(9)
#define B_AX_BRIDGE_LE_ON_V1 BIT(8)
#define B_AX_BRIDGE_DEBUG_PKTCNT_EN_V1 BIT(6)
#define B_AX_BRIDGE_RESET_RCV_SEL_V1 BIT(5)
#define B_AX_BRIDGE_WLS0_V1 BIT(4)
#define B_AX_BRIDGE_STB_V1 BIT(3)
#define B_AX_BRIDGE_PEN_V1 BIT(2)
#define B_AX_BRIDGE_EPS_V1 BIT(1)
#define B_AX_BRIDGE_STKP_V1 BIT(0)

#define R_AX_USB_BRIDGE_UART_2_V1 0x5198
#define B_AX_BRIDGE_DEBUG_SEL_V1_SH 24
#define B_AX_BRIDGE_DEBUG_SEL_V1_MSK 0xff
#define B_AX_R_BRIDGE_UARTEN_V1 BIT(23)
#define B_AX_BRIDGE_LPM_EN_V1 BIT(22)
#define B_AX_BRIDGE_TXSCO_TIME_INTERVAL_EN_V1 BIT(21)
#define B_AX_BRIDGE_TXSCO_PKT_LEN_MAT_EN_V1 BIT(20)
#define B_AX_BRIDGE_TXSCO_CON_HAN_MAT_EN_V1 BIT(19)
#define B_AX_BRIDGE_USB_TX_HCICMDLEN_SEL_V1 BIT(18)
#define B_AX_R_BRIDGE_JCIRXEN_V1 BIT(17)
#define B_AX_R_BRIDGE_HCITXEN_V1 BIT(16)
#define B_AX_BRIDGE_RXSCOBUF_FLOW_SEL_V1_SH 12
#define B_AX_BRIDGE_RXSCOBUF_FLOW_SEL_V1_MSK 0xf
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_V1_SH 0
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_V1_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_3_V1 0x519C
#define B_AX_BRIDGE_URT_RXINDIC_ERR_V1 BIT(31)
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_V1_SH 24
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_V1_MSK 0x7f
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_V1_SH 16
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_V1_MSK 0xff
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_V1_SH 8
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_V1_MSK 0xff
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_V1_SH 0
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_V1_MSK 0xff

#define R_AX_USB_BRIDGE_UART_4_V1 0x51A0
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_V1_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_V1_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_USB3_V1_SH 16
#define B_AX_BRIDGE_XFACTOR_USB3_V1_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB3_V1_SH 0
#define B_AX_BRIDGE_BAUD_USB3_V1_MSK 0xfff

#define R_AX_USB_BT_BRIDGE_V1 0x51A8
#define B_AX_R_DIS_BTBRI_SS_SYSON_V1 BIT(2)
#define B_AX_R_DIS_BTBRI_SS_STS_V1 BIT(1)
#define B_AX_R_DIS_BTBRI_L1U2_STS_V1 BIT(0)

#define R_AX_USB_DMA_WRAPPER_V1 0x51B0
#define B_AX_PKT_BASE_EN_V1 BIT(11)
#define B_AX_FUNCTION_SUSB_OPT_V1 BIT(8)
#define B_AX_TX7LEN_MISMATCH_V1 BIT(7)
#define B_AX_TX6LEN_MISMATCH_V1 BIT(6)
#define B_AX_TX5LEN_MISMATCH_V1 BIT(5)
#define B_AX_TX4LEN_MISMATCH_V1 BIT(4)
#define B_AX_TX3LEN_MISMATCH_V1 BIT(3)
#define B_AX_TX2LEN_MISMATCH_V1 BIT(2)
#define B_AX_TX1LEN_MISMATCH_V1 BIT(1)
#define B_AX_TX0LEN_MISMATCH_V1 BIT(0)

#define R_AX_USB_WLAN1_V1 0x51B8
#define B_AX_WLAN_TX_V1 BIT(12)
#define B_AX_WLAN_RX_V1 BIT(11)
#define B_AX_WLAN1_TXQ_STALL_DIS_V1 BIT(10)
#define B_AX_WLAN1_RXQ_STOP_V1_SH 8
#define B_AX_WLAN1_RXQ_STOP_V1_MSK 0x3
#define B_AX_WLAN1_TXQ_STOP_V1_SH 4
#define B_AX_WLAN1_TXQ_STOP_V1_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_WLAN1_V1 BIT(3)
#define B_AX_LOWPOWER_WLAN1_V1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN1_V1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN1_V1 BIT(0)

#define R_AX_USB_GPS_V1 0x51C0
#define B_AX_FUNCTION_SUSB_EN_GPS_V1 BIT(3)
#define B_AX_LOWPOWER_GPS_V1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_GPS_V1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_GPS_V1 BIT(0)

#define R_AX_USB_DBGSEL_0_V1 0x51CC
#define B_AX_USB_DBGSEL_0_V1_SH 0
#define B_AX_USB_DBGSEL_0_V1_MSK 0xff

#define R_AX_USB_DEBUG_0_V1 0x51D0
#define B_AX_SLEEP_GNT_BT_V1 BIT(17)
#define B_AX_SLEEP_REQ_BT_V1 BIT(16)
#define B_AX_DEBUG_SIGNAL_001_V1_SH 8
#define B_AX_DEBUG_SIGNAL_001_V1_MSK 0xff
#define B_AX_USB_DBGO_SEL_V1_SH 0
#define B_AX_USB_DBGO_SEL_V1_MSK 0xff

#define R_AX_USB_DEBUG_1_V1 0x51D4
#define B_AX_RXDMA_ENDPOINT_COUNTER_V1_SH 24
#define B_AX_RXDMA_ENDPOINT_COUNTER_V1_MSK 0xff
#define B_AX_RXDMA_DMA_COUNTER_V1_SH 16
#define B_AX_RXDMA_DMA_COUNTER_V1_MSK 0xff
#define B_AX_TXDMA_ENDPOINT_COUNTER_V1_SH 8
#define B_AX_TXDMA_ENDPOINT_COUNTER_V1_MSK 0xff
#define B_AX_TXDMA_DMA_COUNTER_V1_SH 0
#define B_AX_TXDMA_DMA_COUNTER_V1_MSK 0xff

#define R_AX_USB_DEBUG_2_V1 0x51D8
#define B_AX_REG_READ_COUNTER_V1_SH 8
#define B_AX_REG_READ_COUNTER_V1_MSK 0xff
#define B_AX_REG_WRITE_COUNTER_V1_SH 0
#define B_AX_REG_WRITE_COUNTER_V1_MSK 0xff

#define R_AX_USB_DEBUG_3_V1 0x51DC
#define B_AX_RX_STATE_MACHINE_V1_SH 24
#define B_AX_RX_STATE_MACHINE_V1_MSK 0xff
#define B_AX_TX_STATE_MACHINE_V1_SH 16
#define B_AX_TX_STATE_MACHINE_V1_MSK 0xff
#define B_AX_IO_STATE_MACHINE_V1_SH 8
#define B_AX_IO_STATE_MACHINE_V1_MSK 0xff
#define B_AX_HW_TXVLD_TOGGLE_EN_V1 BIT(15)
#define B_AX_HW_FORCE_TXRDY_EN_V1 BIT(14)
#define B_AX_TXVLD_TOGGLE_VAL_V1_SH 8
#define B_AX_TXVLD_TOGGLE_VAL_V1_MSK 0xf
#define B_AX_TXVLD_TOUT_VAL_V1_SH 0
#define B_AX_TXVLD_TOUT_VAL_V1_MSK 0xff

#define R_AX_USB_IO_ONREG_WDT_V1 0x51E4
#define B_AX_ON_IOH_ADDR_V1_SH 8
#define B_AX_ON_IOH_ADDR_V1_MSK 0xffffff
#define B_AX_ON_IOH_TIMER_V1_SH 4
#define B_AX_ON_IOH_TIMER_V1_MSK 0xf
#define B_AX_ON_IOH_HW_AUTO_RST_V1 BIT(3)
#define B_AX_ON_IOH_EMPTY_V1 BIT(2)
#define B_AX_ON_IOH_RST_STS_V1 BIT(0)

#define R_AX_USB_IO_OFFREG_WDT_V1 0x51E8
#define B_AX_OFF_IOH_ADDR_V1_SH 8
#define B_AX_OFF_IOH_ADDR_V1_MSK 0xffffff
#define B_AX_OFF_IOH_TIMER_V1_SH 4
#define B_AX_OFF_IOH_TIMER_V1_MSK 0xf
#define B_AX_OFF_IOH_HW_AUTO_RST_V1 BIT(3)
#define B_AX_ON_IOH_SW_RST_V1 BIT(2)
#define B_AX_OFF_IOH_RST_STS_V1 BIT(0)

#define R_AX_USB_CPU_IO_RST_V1 0x51EC
#define B_AX_CPU_IOH_ADDR_V1_SH 16
#define B_AX_CPU_IOH_ADDR_V1_MSK 0xffff
#define B_AX_CPU_IOH_TIMEOUT_TH_V1_SH 8
#define B_AX_CPU_IOH_TIMEOUT_TH_V1_MSK 0x1f
#define B_AX_CPU_IOH_DSC_SW_RST_V1 BIT(1)
#define B_AX_CPU_IOH_SRC_SW_RST_V1 BIT(0)

#define R_AX_USB_STATUS_V1 0x51F0
#define B_AX_USB3_DIS_USB2PHY BIT(30)
#define B_AX_USB2_DIS_USB3 BIT(29)
#define B_AX_USB11_DIS_USB3 BIT(28)
#define B_AX_DIS_CTRL BIT(27)
#define B_AX_USB_EP_NUM_V1_SH 4
#define B_AX_USB_EP_NUM_V1_MSK 0xf
#define B_AX_R_SSIC_EN_V1 BIT(2)
#define B_AX_R_USB2_SEL_V1 BIT(1)
#define B_AX_MODE_HS_V1 BIT(0)

#define R_AX_USB_D2F_F2D_INFO_V1 0x5200
#define B_AX_HRPWM_V1_SH 16
#define B_AX_HRPWM_V1_MSK 0xffff
#define B_AX_CPWM_V1_SH 0
#define B_AX_CPWM_V1_MSK 0xffff

#define R_AX_USB_DBGSEL_1_V1 0x521C
#define B_AX_USB_DBGSEL_1_V1_SH 0
#define B_AX_USB_DBGSEL_1_V1_MSK 0xffffffffL

#define R_AX_USB3_V1 0x5220
#define B_AX_U3_STATE_V1_SH 12
#define B_AX_U3_STATE_V1_MSK 0xf
#define B_AX_U3_SUB_STATE_V1_SH 8
#define B_AX_U3_SUB_STATE_V1_MSK 0xf
#define B_AX_HPS_CLKR_USB_V1_SH 0
#define B_AX_HPS_CLKR_USB_V1_MSK 0xff

#define R_AX_USB_OTHERS_0_V1 0x5230
#define B_AX_USBTX_EP3IF_OK_CNT_V1_SH 24
#define B_AX_USBTX_EP3IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP2IF_OK_CNT_V1_SH 16
#define B_AX_USBTX_EP2IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP1IF_OK_CNT_V1_SH 8
#define B_AX_USBTX_EP1IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP0IF_OK_CNT_V1_SH 0
#define B_AX_USBTX_EP0IF_OK_CNT_V1_MSK 0xff

#define R_AX_USB_OTHERS_1_V1 0x5234
#define B_AX_USBTX_EP7IF_OK_CNT_V1_SH 24
#define B_AX_USBTX_EP7IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP6IF_OK_CNT_V1_SH 16
#define B_AX_USBTX_EP6IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP5IF_OK_CNT_V1_SH 8
#define B_AX_USBTX_EP5IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP4IF_OK_CNT_V1_SH 0
#define B_AX_USBTX_EP4IF_OK_CNT_V1_MSK 0xff

#define R_AX_USB_OTHERS_2_V1 0x5238
#define B_AX_USBRX_DMAIF_OK_CNT_V1_SH 24
#define B_AX_USBRX_DMAIF_OK_CNT_V1_MSK 0xff
#define B_AX_USBRX_EPIF_OK_CNT_V1_SH 16
#define B_AX_USBRX_EPIF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP9IF_OK_CNT_V1_SH 8
#define B_AX_USBTX_EP9IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP8IF_OK_CNT_V1_SH 0
#define B_AX_USBTX_EP8IF_OK_CNT_V1_MSK 0xff

#define R_AX_USB_OTHERS_3_V1 0x523C
#define B_AX_VENDOR_LMP_LATCH_DATA_L_V1_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_L_V1_MSK 0xffffffffL

#define R_AX_USB_OTHERS_4_V1 0x5240
#define B_AX_VENDOR_LMP_LATCH_DATA_H_V1_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_H_V1_MSK 0xffffffffL

#define R_AX_USB_OTHERS_5_V1 0x5244
#define B_AX_APPEND_ZERO_PKT_V1_SH 24
#define B_AX_APPEND_ZERO_PKT_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_7_V1_SH 21
#define B_AX_USB_AUTO_LOAD_EXTE_7_V1_MSK 0x3
#define B_AX_USB_AUTO_LOAD_EXTE_0_V1_SH 16
#define B_AX_USB_AUTO_LOAD_EXTE_0_V1_MSK 0x1f
#define B_AX_USB_AUTO_LOAD_EXTE_2_V1_SH 8
#define B_AX_USB_AUTO_LOAD_EXTE_2_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_1_V1_SH 0
#define B_AX_USB_AUTO_LOAD_EXTE_1_V1_MSK 0xff

#define R_AX_USB_OTHERS_6_V1 0x5248
#define B_AX_USB_AUTO_LOAD_STRING_3_V1_SH 24
#define B_AX_USB_AUTO_LOAD_STRING_3_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_2_V1_SH 16
#define B_AX_USB_AUTO_LOAD_STRING_2_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_1_V1_SH 8
#define B_AX_USB_AUTO_LOAD_STRING_1_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_0_V1_SH 0
#define B_AX_USB_AUTO_LOAD_STRING_0_V1_MSK 0xff

#define R_AX_USB_OTHERS_7_V1 0x524C
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_V1_SH 22
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_V1_SH 14
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_FLAG_V1 BIT(13)
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_V1_SH 7
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_V1_MSK 0x3f
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_V1_SH 0
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_V1_MSK 0x7f

#define R_AX_USB_FW_ISR_V1 0x5254
#define B_AX_IO_OFFREG_TIMEOUT_INT_V1 BIT(8)
#define B_AX_IO_ONREG_TIMEOUT_INT_V1 BIT(0)

#define R_AX_USB_FW_IMR_V1 0x5258
#define B_AX_IO_OFFREG_TIMEOUT_INT_EN_V1 BIT(8)
#define B_AX_IO_ONREG_TIMEOUT_INT_EN_V1 BIT(0)

#define R_AX_HUSBIMR_V1 0x5270
#define B_AX_USB_CPUIO_TIMEOUT_INT_EN_V1 BIT(29)
#define B_AX_USB_HC1ISR_IDCT_INT_EN_V1 BIT(28)
#define B_AX_USB_HC0ISR_IDCT_INT_EN_V1 BIT(27)
#define B_AX_USB_HD1ISR_IDCT_INT_EN_V1 BIT(26)
#define B_AX_USB_HD0ISR_IDCT_INT_EN_V1 BIT(25)
#define B_AX_USB_HS1ISR_IDCT_INT_EN_V1 BIT(24)
#define B_AX_USB_HS0ISR_IDCT_INT_EN_V1 BIT(23)
#define B_AX_USB_TX_CH12_INT_EN_V1 BIT(7)
#define B_AX_USB_TX_CH10_INT_EN_V1 BIT(6)
#define B_AX_USB_TX_CH8_INT_EN_V1 BIT(5)
#define B_AX_USB_TX_CH6_INT_EN_V1 BIT(4)
#define B_AX_USB_TX_CH4_INT_EN_V1 BIT(3)
#define B_AX_USB_TX_CH2_INT_EN_V1 BIT(2)
#define B_AX_USB_TX_CH0_INT_EN_V1 BIT(1)
#define B_AX_USB_RX_INT_EN_V1 BIT(0)

#define R_AX_HUSBISR_V1 0x5274
#define B_AX_USB_CPUIO_TIMEOUT_INT_V1 BIT(29)
#define B_AX_USB_HC1ISR_IDCT_INT_V1 BIT(28)
#define B_AX_USB_HC0ISR_IDCT_INT_V1 BIT(27)
#define B_AX_USB_HD1ISR_IDCT_INT_V1 BIT(26)
#define B_AX_USB_HD0ISR_IDCT_INT_V1 BIT(25)
#define B_AX_USB_HS1ISR_IDCT_INT_V1 BIT(24)
#define B_AX_USB_HS0ISR_IDCT_INT_V1 BIT(23)
#define B_AX_USB_TX_CH12_INT_V1 BIT(7)
#define B_AX_USB_TX_CH10_INT_V1 BIT(6)
#define B_AX_USB_TX_CH8_INT_V1 BIT(5)
#define B_AX_USB_TX_CH6_INT_V1 BIT(4)
#define B_AX_USB_TX_CH4_INT_V1 BIT(3)
#define B_AX_USB_TX_CH2_INT_V1 BIT(2)
#define B_AX_USB_TX_CH0_INT_V1 BIT(1)
#define B_AX_USB_RX_INT_V1 BIT(0)

//
// WL_AX_Reg_USB.xls
//

//
// USB_REG
//

#endif
