/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef _MAC_AX_SER_1115E_H_
#define _MAC_AX_SER_1115E_H_

#include "../trxcfg.h"
#if MAC_AX_1115E_SUPPORT

#define SER_ENABLE 0XFFFFFFFF
#define SER_DISABLE 0X00000000

//STA_SCH 0x9EF0
//bit[0]
#define B_AX_SEARCH_HANG_TIMEOUT_SER_EN SER_ENABLE
//bit[1]
#define B_AX_RPT_HANG_TIMEOUT_SER_EN SER_ENABLE
//bit[2]
#define B_AX_PLE_B_PKTID_ERR_SER_EN SER_ENABLE

//MPDU_TX_ERR_IMR 0x9BF4
//bit[1]
#define B_AX_TX_GET_ERRPKTID_SER_EN SER_ENABLE
//bit[2]
#define B_AX_TX_NXT_ERRPKTID_SER_EN SER_ENABLE
//bit[3]
#define B_AX_TX_MPDU_SIZE_ZERO_SER_EN SER_ENABLE
//bit[4]
#define B_AX_TX_OFFSET_ERR_SER_EN SER_ENABLE
//bit[5]
#define B_AX_TX_HDR3_SIZE_ERR_SER_EN SER_ENABLE
//bit[6]
#define B_AX_TX_ETH_TYPE_SER_EN SER_ENABLE
//bit[7]
#define B_AX_TX_LLC_PRE_SER_EN SER_ENABLE
//bit[8]
#define B_AX_TX_NW_TYPE_SER_EN SER_ENABLE
//bit[9]
#define B_AX_TX_KSRCH_SER_EN SER_ENABLE

//MPDU_RX_ERR_IMR 0x9CF4
//bit[0]
#define B_AX_GETPKTID_ERR_SER_EN SER_ENABLE
//bit[1]
#define B_AX_MHDRLEN_ERR_SER_EN SER_ENABLE
//bit[3]
#define B_AX_RPT_ERR_SER_EN SER_ENABLE

//SEC_DEBUG 0x9D2C
//bit[0]
#define B_AX_TX_HANG_SER_EN SER_ENABLE
//bit[1]
#define B_AX_RX_HANG_SER_EN SER_ENABLE

//PKTIN_ERR_IMR 0x9A20
//bit[0]
#define B_AX_GET_NULL_PKTID_ERR_SER_EN SER_ENABLE

//HOST_DISPATCHER_ERR_IMR 0x8850
//bit[0]
#define B_AX_HT_EP_CH_DIFF_ERR_SER_EN SER_DISABLE
//bit[1]
#define B_AX_HT_CH_ID_ERR_SER_EN SER_DISABLE
//bit[2]
#define B_AX_HT_PKT_FAIL_ERR_SER_EN SER_DISABLE
//bit[3]
#define B_AX_HT_PERMU_FF_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[4]
#define B_AX_HT_PERMU_FF_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[5]
#define B_AX_HT_PAYLOAD_OVER_ERR_SER_EN SER_ENABLE
//bit[6]
#define B_AX_HT_PAYLOAD_UNDER_ERR_SER_EN SER_ENABLE
//bit[7]
#define B_AX_HT_OFFSET_UNMATCH_ERR_SER_EN SER_DISABLE
//bit[8]
#define B_AX_HT_CHANNEL_DMA_ERR_SER_EN SER_DISABLE
//bit[9]
#define B_AX_HT_WD_CHKSUM_ERR_SER_EN SER_DISABLE
//bit[10]
#define B_AX_HT_PRE_SUB_ERR_SER_EN SER_DISABLE
//bit[11]
#define B_AX_HT_TXPKTSIZE_ERR_SER_EN SER_DISABLE
//bit[12]
#define B_AX_HT_CHKSUM_FSM_ERR_SER_EN SER_DISABLE
//bit[13]
#define B_AX_HT_WRFF_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[14]
#define B_AX_HT_WRFF_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[15]
#define B_AX_HT_PLD_CMD_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[16]
#define B_AX_HT_PLD_CMD_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[17]
#define B_AX_HT_WD_LEN_OVER_ERR_SER_EN SER_DISABLE
//bit[18]
#define B_AX_HT_ADDR_INFO_LEN_ERR_SER_EN SER_DISABLE
//bit[20]
#define B_AX_HT_ILL_CH_ERR_SER_EN SER_ENABLE
//bit[22]
#define B_AX_HR_PLD_LEN_ZERO_ERR_SER_EN SER_DISABLE
//bit[23]
#define B_AX_HR_DMA_RD_CNT_DEQ_ERR_SER_EN SER_DISABLE
//bit[24]
#define B_AX_HR_AGG_CFG_ERR_SER_EN SER_DISABLE
//bit[25]
#define B_AX_HR_SHIFT_EN_ERR_SER_EN SER_DISABLE
//bit[26]
#define B_AX_HR_TOTAL_LEN_UNDER_ERR_SER_EN SER_ENABLE
//bit[27]
#define B_AX_HR_DMA_PROCESS_ERR_SER_EN SER_ENABLE
//bit[28]
#define B_AX_HR_SHIFT_DMA_CFG_ERR_SER_EN SER_DISABLE
//bit[29]
#define B_AX_HR_CHKSUM_FSM_ERR_SER_EN SER_DISABLE
//bit[30]
#define B_AX_HR_WRFF_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[31]
#define B_AX_HR_WRFF_UNDERFLOW_ERR_SER_EN SER_DISABLE

//CPU_DISPATCHER_ERR_IMR 0x8854
//bit[0]
#define B_AX_CT_EP_CH_DIFF_ERR_SER_EN SER_DISABLE
//bit[2]
#define B_AX_CT_CH_ID_ERR_SER_EN SER_DISABLE
//bit[3]
#define B_AX_CT_PERMU_FF_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[4]
#define B_AX_CT_PERMU_FF_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[5]
#define B_AX_CT_PAYLOAD_OVER_ERR_SER_EN SER_ENABLE
//bit[6]
#define B_AX_CT_PAYLOAD_UNDER_ERR_SER_EN SER_ENABLE
//bit[7]
#define B_AX_CT_PAYLOAD_CHKSUM_ERR_SER_EN SER_DISABLE
//bit[8]
#define B_AX_CT_OFFSET_UNMATCH_ERR_SER_EN SER_DISABLE
//bit[9]
#define B_AX_CT_CHANNEL_DMA_ERR_SER_EN SER_DISABLE
//bit[10]
#define B_AX_CT_WD_CHKSUM_ERR_SER_EN SER_DISABLE
//bit[11]
#define B_AX_CT_PRE_SUB_ERR_SER_EN SER_DISABLE
//bit[12]
#define B_AX_CT_PLD_CMD_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[13]
#define B_AX_CT_PLD_CMD_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[14]
#define B_AX_CT_F2P_QSEL_ERR_SER_EN SER_DISABLE
//bit[15]
#define B_AX_CT_F2P_SEQ_ERR_SER_EN SER_DISABLE
//bit[16]
#define B_AX_CT_WD_LEN_OVER_ERR_SER_EN SER_DISABLE
//bit[17]
#define B_AX_CT_ADDR_INFO_LEN_MISS_ERR_SER_EN SER_DISABLE
//bit[19]
#define B_AX_REUSE_FIFO_A_OVER_ERR_SER_EN SER_DISABLE
//bit[20]
#define B_AX_REUSE_FIFO_A_UNDER_ERR_SER_EN SER_DISABLE
//bit[21]
#define B_AX_REUSE_FIFO_B_OVER_ERR_SER_EN SER_DISABLE
//bit[22]
#define B_AX_REUSE_FIFO_B_UNDER_ERR_SER_EN SER_DISABLE
//bit[24]
#define B_AX_CR_SHIFT_EN_ERR_SER_EN SER_DISABLE
//bit[25]
#define B_AX_CR_TOTAL_LEN_UNDER_ERR_SER_EN SER_ENABLE
//bit[26]
#define B_AX_CR_DMA_PROCESS_ERR_SER_EN SER_ENABLE
//bit[27]
#define B_AX_CR_SHIFT_DMA_CFG_ERR_SER_EN SER_DISABLE
//bit[28]
#define B_AX_CR_WRFF_OVERFLOW_ERR_SER_EN SER_ENABLE
//bit[29]
#define B_AX_CR_WRFF_UNDERFLOW_ERR_SER_EN SER_ENABLE
//bit[30]
#define B_AX_CR_PLD_LEN_ERR_SER_EN SER_DISABLE

//OTHER_DISPATCHER_ERR_IMR 0x8858
//bit[0]
#define B_AX_WDE_FLOW_CTRL_ERR_SER_EN SER_DISABLE
//bit[1]
#define B_AX_WDE_NULL_PKT_ERR_SER_EN SER_DISABLE
//bit[2]
#define B_AX_WDE_BURST_NUM_ERR_SER_EN SER_DISABLE
//bit[3]
#define B_AX_WDE_RESPONSE_ERR_SER_EN SER_DISABLE
//bit[4]
#define B_AX_WDE_OUTPUT_ERR_SER_EN SER_DISABLE
//bit[6]
#define B_AX_HDR_RX_TIMEOUT_ERR_SER_EN SER_DISABLE
//bit[7]
#define B_AX_HDR_DMA_TIMEOUT_ERR_SER_EN SER_DISABLE
//bit[8]
#define B_AX_PLE_FLOW_CTRL_ERR_SER_EN SER_DISABLE
//bit[9]
#define B_AX_PLE_NULL_PKT_ERR_SER_EN SER_DISABLE
//bit[10]
#define B_AX_PLE_BURST_NUM_ERR_SER_EN SER_DISABLE
//bit[11]
#define B_AX_PLE_RESPOSE_ERR_SER_EN SER_DISABLE
//bit[12]
#define B_AX_PLE_OUTPUT_ERR_SER_EN SER_DISABLE
//bit[14]
#define B_AX_CDR_RX_TIMEOUT_ERR_SER_EN SER_ENABLE
//bit[15]
#define B_AX_CDR_DMA_TIMEOUT_ERR_SER_EN SER_ENABLE
//bit[16]
#define B_AX_HDT_ADDR_INFO_LEN_ERR_SER_EN SER_DISABLE
//bit[17]
#define B_AX_CDT_ADDR_INFO_LEN_ERR_SER_EN SER_DISABLE
//bit[18]
#define B_AX_HDT_HCI_TIMEOUT_ERR_SER_EN SER_ENABLE
//bit[19]
#define B_AX_HDT_PTR_TIMEOUT_ERR_SER_EN SER_ENABLE
//bit[20]
#define B_AX_CDT_HCI_TIMEOUT_ERR_SER_EN SER_ENABLE
//bit[21]
#define B_AX_CDT_PTR_TIMEOUT_ERR_SER_EN SER_ENABLE
//bit[22]
#define B_AX_REUSE_PKT_CNT_ERR_SER_EN SER_DISABLE
//bit[23]
#define B_AX_REUSE_SIZE_ZERO_ERR_SER_EN SER_DISABLE
//bit[24]
#define B_AX_STF_CMD_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[25]
#define B_AX_STF_CMD_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[26]
#define B_AX_STF_WRFF_OVERFLOW_ERR_SER_EN SER_DISABLE
//bit[27]
#define B_AX_STF_WRFF_UNDERFLOW_ERR_SER_EN SER_DISABLE
//bit[28]
#define B_AX_STF_OQT_OVERFLOW_ERR_SER_EN SER_ENABLE
//bit[29]
#define B_AX_STF_OQT_UNDERFLOW_ERR_SER_EN SER_ENABLE
//bit[30]
#define B_AX_REUSE_EN_ERR_SER_EN SER_DISABLE
//bit[31]
#define B_AX_REUSE_SIZE_ERR_SER_EN SER_DISABLE

//CPUIO_ERR_IMR 0x9840
//bit[0]
#define B_AX_WDEBUF_OP_ERR_SER_EN SER_ENABLE
//bit[4]
#define B_AX_WDEQUE_OP_ERR_SER_EN SER_ENABLE
//bit[8]
#define B_AX_PLEBUF_OP_ERR_SER_EN SER_ENABLE
//bit[12]
#define B_AX_PLEQUE_OP_ERR_SER_EN SER_ENABLE

//WDE_ERR_IMR 0x8C38
//bit[0]
#define B_AX_WDE_BUFREQ_QTAID_ERR_SER_EN SER_ENABLE
//bit[1]
#define B_AX_WDE_BUFREQ_SIZE0_SER_EN SER_ENABLE
//bit[2]
#define B_AX_WDE_BUFREQ_SIZELMT_SER_EN SER_ENABLE
//bit[3]
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_SER_EN SER_ENABLE
//bit[4]
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_SER_EN SER_ENABLE
//bit[5]
#define B_AX_WDE_BUFRTN_SIZE_ERR_SER_EN SER_ENABLE
//bit[6]
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_SER_EN SER_ENABLE
//bit[7]
#define B_AX_WDE_GETNPG_STRPG_ERR_SER_EN SER_ENABLE
//bit[8]
#define B_AX_WDE_GETNPG_PGOFST_ERR_SER_EN SER_ENABLE
//bit[9]
#define B_AX_WDE_BUFMGN_FRZTO_ERR_SER_EN SER_ENABLE
//bit[12]
#define B_AX_WDE_QUE_CMDTYPE_ERR_SER_EN SER_ENABLE
//bit[13]
#define B_AX_WDE_QUE_DSTQUEID_ERR_SER_EN SER_ENABLE
//bit[14]
#define B_AX_WDE_QUE_SRCQUEID_ERR_SER_EN SER_ENABLE
//bit[15]
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_SER_EN SER_ENABLE
//bit[16]
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_SER_EN SER_ENABLE
//bit[17]
#define B_AX_WDE_PREPKTLLT_AD_ERR_SER_EN SER_ENABLE
//bit[18]
#define B_AX_WDE_NXTPKTLL_AD_ERR_SER_EN SER_ENABLE
//bit[19]
#define B_AX_WDE_QUEMGN_FRZTO_ERR_SER_EN SER_ENABLE
//bit[24]
#define B_AX_WDE_DATCHN_ARBT_ERR_SER_EN SER_ENABLE
//bit[25]
#define B_AX_WDE_DATCHN_NULLPG_ERR_SER_EN SER_ENABLE
//bit[26]
#define B_AX_WDE_DATCHN_FRZTO_ERR_SER_EN SER_ENABLE
//bit[27]
#define B_AX_WDE_DATCHN_RRDY_ERR_SER_EN SER_ENABLE
//bit[28]
#define B_AX_WDE_DATCHN_ADRERR_ERR_SER_EN SER_ENABLE
//bit[29]
#define B_AX_WDE_DATCHN_CAMREQ_ERR_SER_EN SER_ENABLE

//PLE_ERR_IMR 0x9038
//bit[0]
#define B_AX_PLE_BUFREQ_QTAID_ERR_SER_EN SER_ENABLE
//bit[1]
#define B_AX_PLE_BUFREQ_SIZE0_SER_EN SER_ENABLE
//bit[2]
#define B_AX_PLE_BUFREQ_SIZELMT_SER_EN SER_ENABLE
//bit[3]
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_SER_EN SER_ENABLE
//bit[4]
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_SER_EN SER_ENABLE
//bit[5]
#define B_AX_PLE_BUFRTN_SIZE_ERR_SER_EN SER_ENABLE
//bit[6]
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_SER_EN SER_ENABLE
//bit[7]
#define B_AX_PLE_GETNPG_STRPG_ERR_SER_EN SER_ENABLE
//bit[8]
#define B_AX_PLE_GETNPG_PGOFST_ERR_SER_EN SER_ENABLE
//bit[9]
#define B_AX_PLE_BUFMGN_FRZTO_ERR_SER_EN SER_ENABLE
//bit[12]
#define B_AX_PLE_QUE_CMDTYPE_ERR_SER_EN SER_ENABLE
//bit[13]
#define B_AX_PLE_QUE_DSTQUEID_ERR_SER_EN SER_ENABLE
//bit[14]
#define B_AX_PLE_QUE_SRCQUEID_ERR_SER_EN SER_ENABLE
//bit[15]
#define B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_SER_EN SER_ENABLE
//bit[16]
#define B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_SER_EN SER_ENABLE
//bit[17]
#define B_AX_PLE_PREPKTLLT_AD_ERR_SER_EN SER_ENABLE
//bit[18]
#define B_AX_PLE_NXTPKTLL_AD_ERR_SER_EN SER_ENABLE
//bit[19]
#define B_AX_PLE_QUEMGN_FRZTO_ERR_SER_EN SER_ENABLE
//bit[24]
#define B_AX_PLE_DATCHN_ARBT_ERR_SER_EN SER_ENABLE
//bit[25]
#define B_AX_PLE_DATCHN_NULLPG_ERR_SER_EN SER_ENABLE
//bit[26]
#define B_AX_PLE_DATCHN_FRZTO_ERR_SER_EN SER_ENABLE
//bit[27]
#define B_AX_PLE_DATCHN_RRDY_ERR_SER_EN SER_ENABLE
//bit[28]
#define B_AX_PLE_DATCHN_ADRERR_ERR_SER_EN SER_ENABLE
//bit[29]
#define B_AX_PLE_DATCHN_CAMREQ_ERR_SER_EN SER_ENABLE

//WDRLS 0x9430
//bit[0]
#define B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_SER_EN SER_ENABLE
//bit[1]
#define B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_SER_EN SER_ENABLE
//bit[2]
#define B_AX_WDRLS_CTL_FRZTO_ERR_SER_EN SER_ENABLE
//bit[4]
#define B_AX_WDRLS_PLEBREQ_TO_ERR_SER_EN SER_ENABLE
//bit[5]
#define B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_SER_EN SER_ENABLE
//bit[8]
#define B_AX_WDRLS_RPT0_AGGNUM0_ERR_SER_EN SER_ENABLE
//bit[9]
#define B_AX_WDRLS_RPT0_FRZTO_ERR_SER_EN SER_ENABLE
//bit[12]
#define B_AX_WDRLS_RPT1_AGGNUM0_ERR_SER_EN SER_ENABLE
//bit[13]
#define B_AX_WDRLS_RPT1_FRZTO_ERR_SER_EN SER_ENABLE

//TXPKTCTL_ERR_IMR_ISR 0x9F78
//bit[0]
#define B_AX_B0_IMR_ERR_USRCTL_REINIT_SER_EN SER_ENABLE
//bit[1]
#define B_AX_B0_IMR_ERR_USRCTL_NOINIT_SER_EN SER_ENABLE
//bit[2]
#define B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD_SER_EN SER_ENABLE
//bit[3]
#define B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN_SER_EN SER_ENABLE
//bit[8]
#define B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR_SER_EN SER_ENABLE
//bit[9]
#define B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE_SER_EN SER_ENABLE
//bit[10]
#define B_AX_B0_IMR_ERR_CMDPSR_FRZTO_SER_EN SER_ENABLE
//bit[11]
#define B_AX_B0_IMR_ERR_CMDPSR_TBLSZ_SER_EN SER_ENABLE
//bit[16]
#define B_AX_B0_IMR_ERR_MPDUINFO_RECFG_SER_EN SER_ENABLE
//bit[18]
#define B_AX_B0_IMR_ERR_MPDUIF_DATAERR_SER_EN SER_ENABLE
//bit[20]
#define B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR_SER_EN SER_ENABLE
//bit[21]
#define B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG_SER_EN SER_ENABLE

//TXPKTCTL_ERR_IMR_ISR_B1 0x9FB8
//bit[0]
#define B_AX_B1_IMR_ERR_USRCTL_REINIT_SER_EN SER_ENABLE
//bit[1]
#define B_AX_B1_IMR_ERR_USRCTL_NOINIT_SER_EN SER_ENABLE
//bit[2]
#define B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD_SER_EN SER_ENABLE
//bit[3]
#define B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN_SER_EN SER_ENABLE
//bit[8]
#define B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR_SER_EN SER_ENABLE
//bit[9]
#define B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE_SER_EN SER_ENABLE
//bit[10]
#define B_AX_B1_IMR_ERR_CMDPSR_FRZTO_SER_EN SER_ENABLE
//bit[11]
#define B_AX_B1_IMR_ERR_CMDPSR_TBLSZ_SER_EN SER_ENABLE
//bit[16]
#define B_AX_B1_IMR_ERR_MPDUINFO_RECFG_SER_EN SER_ENABLE
//bit[18]
#define B_AX_B1_IMR_ERR_MPDUIF_DATAERR_SER_EN SER_ENABLE
//bit[20]
#define B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR_SER_EN SER_ENABLE
//bit[21]
#define B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG_SER_EN SER_ENABLE

//BBRPT_COM_ERR_IMR_ISR 0x960C
//bit[0]
#define B_AX_BBRPT_COM_HANG_EN_SER_EN SER_DISABLE
//bit[1]
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_SER_EN SER_ENABLE

//BBRPT_CHINFO_ERR_IMR_ISR 0x962C
//bit[0]
#define B_AX_BBPRT_CHIF_BB_TO_V1_SER_EN SER_ENABLE
//bit[1]
#define B_AX_BBPRT_CHIF_OVF_V1_SER_EN SER_ENABLE
//bit[2]
#define B_AX_BBPRT_CHIF_BOVF_V1_SER_EN SER_ENABLE
//bit[3]
#define B_AX_BBPRT_CHIF_HDRL_V1_SER_EN SER_ENABLE
//bit[4]
#define B_AX_BBPRT_CHIF_LEFT1_V1_SER_EN SER_ENABLE
//bit[5]
#define B_AX_BBPRT_CHIF_LEFT2_V1_SER_EN SER_ENABLE
//bit[6]
#define B_AX_BBPRT_CHIF_NULL_V1_SER_EN SER_ENABLE
//bit[7]
#define B_AX_BBPRT_CHIF_TO_V1_SER_EN SER_ENABLE

//BBRPT_DFS_ERR_IMR_ISR 0x963C
//bit[0]
#define B_AX_BBRPT_DFS_TO_ERR_V1_SER_EN SER_ENABLE

//LA_ERRFLAG 0x966C
//bit[0]
#define B_AX_LA_ISR_DATA_LOSS_V1_SER_EN SER_ENABLE

//H_AXIDMA 0x10B8
//bit[0]
#define B_AX_TXMDA_STUCK_IDCT_SER_EN SER_ENABLE
//bit[1]
#define B_AX_RXMDA_STUCK_IDCT_SER_EN SER_ENABLE
//bit[2]
#define B_AX__TXBD_4KBOUND_ERR_IDCT_SER_EN SER_ENABLE
//bit[3]
#define B_AX__TXBD_LEN0_ERR_IDCT_SER_EN SER_ENABLE

//P_AXIDMA 0x6910

//HCI_BUF 0x6018

/*-------------------- CMAC DMA IMR --------------------------------------*/
// 0xC870
// bit[14]
#define CMAC_DMA_TX_WD_PLD_ID_FSM_HANG_SER_EN SER_ENABLE
// bit[15]
#define CMAC_DMA_TX_CSI_FSM_HANG_SER_EN SER_ENABLE
// bit[24]
#define CMAC_DMA_TX_RU7_FSM_HANG_SER_EN SER_ENABLE
// bit[25]
#define CMAC_DMA_TX_RU6_FSM_HANG_SER_EN SER_ENABLE
// bit[26]
#define CMAC_DMA_TX_RU5_FSM_HANG_SER_EN SER_ENABLE
// bit[27]
#define CMAC_DMA_TX_RU4_FSM_HANG_SER_EN SER_ENABLE
// bit[28]
#define CMAC_DMA_TX_RU3_FSM_HANG_SER_EN SER_ENABLE
// bit[29]
#define CMAC_DMA_TX_RU2_FSM_HANG_SER_EN SER_ENABLE
// bit[30]
#define CMAC_DMA_TX_RU1_FSM_HANG_SER_EN SER_ENABLE
// bit[31]
#define CMAC_DMA_TX_RU0_FSM_HANG_SER_EN SER_ENABLE

// CMAC DMA 0xC804
// bit[1]
#define CMAC_DMA_RXSTS_ENQUE_ORDER_SER_EN SER_ENABLE
// bit[2]
#define CMAC_DMA_RXDATA_ENQUE_ORDER_SER_EN SER_ENABLE
// bit[8]
#define CMAC_DMA_RX_CSI_ZERO_LEN_SER_EN SER_ENABLE
// bit[9]
#define CMAC_DMA_RX_RXSTS_ZERO_LEN_SER_EN SER_ENABLE
// bit[10]
#define CMAC_DMA_RX_RU7_ZERO_LEN_SER_EN SER_ENABLE
// bit[11]
#define CMAC_DMA_RX_RU6_ZERO_LEN_SER_EN SER_ENABLE
// bit[12]
#define CMAC_DMA_RX_RU5_ZERO_LEN_SER_EN SER_ENABLE
// bit[13]
#define CMAC_DMA_RX_RU4_ZERO_LEN_SER_EN SER_ENABLE
// bit[14]
#define CMAC_DMA_RX_RU3_ZERO_LEN_SER_EN SER_ENABLE
// bit[15]
#define CMAC_DMA_RX_RU2_ZERO_LEN_SER_EN SER_ENABLE
// bit[16]
#define CMAC_DMA_RX_RU1_ZERO_LEN_SER_EN SER_ENABLE
// bit[17]
#define CMAC_DMA_RX_RU0_ZERO_LEN_SER_EN SER_ENABLE
// bit[18]
#define CMAC_DMA_RX_F2PCMD_FSM_HANG_SER_EN SER_ENABLE
// bit[19]
#define CMAC_DMA_RX_TXRPT_FSM_HANG_SER_EN SER_ENABLE
// bit[20]
#define CMAC_DMA_RX_CSI_FSM_HANG_SER_EN SER_ENABLE
// bit[21]
#define CMAC_DMA_RX_RXSTS_FSM_HANG_SER_EN SER_ENABLE
// bit[22]
#define CMAC_DMA_RX_RU7_FSM_HANG_SER_EN SER_ENABLE
// bit[23]
#define CMAC_DMA_RX_RU6_FSM_HANG_SER_EN SER_ENABLE
// bit[24]
#define CMAC_DMA_RX_RU5_FSM_HANG_SER_EN SER_ENABLE
// bit[25]
#define CMAC_DMA_RX_RU4_FSM_HANG_SER_EN SER_ENABLE
// bit[26]
#define CMAC_DMA_RX_RU3_FSM_HANG_SER_EN SER_ENABLE
// bit[27]
#define CMAC_DMA_RX_RU2_FSM_HANG_SER_EN SER_ENABLE
// bit[28]
#define CMAC_DMA_RX_RU1_FSM_HANG_SER_EN SER_ENABLE
// bit[29]
#define CMAC_DMA_RX_RU0_FSM_HANG_SER_EN SER_ENABLE
// bit[30]
#define CMAC_DMA_RX_GET_NULL_PKT_SER_EN SER_ENABLE

/*-------------------- PTCL IMR --------------------------------------*/
// 0xC6C0
// bit[0]
#define PTCL_FSM_TIMEOUT_SER_EN SER_ENABLE
// bit[1]
#define PTCL_FSM1_TIMEOUT_SER_EN SER_ENABLE

/*-------------------- Scheduler IMR --------------------------------------*/
// 0xC3E8
// bit[0]
#define SCHEDULER_FSM_TIMEOUT_52C_ERR_SER_EN SER_ENABLE
// bit[1]
#define SCHEDULER_SORT_NON_IDLE_52C_ERR_SER_EN SER_DISABLE

/*-------------------- PHY INTF IMR --------------------------------------*/
// 0xCCF8
// bit[0]
#define PHY_INTF_PHY_TXON_TIMEOUT_SER_EN SER_ENABLE
// bit[1]
#define PHY_INTF_CCK_CCA_TIMEOUT_SER_EN SER_ENABLE
// bit[2]
#define PHY_INTF_OFDM_CCA_TIMEOUT_SER_EN SER_ENABLE
// bit[3]
#define PHY_INTF_DATA_ON_TIMEOUT_SER_EN SER_ENABLE
// bit[4]
#define PHY_INTF_STS_ON_TIMEOUT_SER_EN SER_ENABLE
// bit[5]
#define PHY_INTF_CSI_ON_TIMEOUT_SER_EN SER_ENABLE

/*-------------------- RMAC IMR --------------------------------------*/
// 0xCEF8
// bit[0]
#define RMAC_RX_ERR_CCA_TO_SER_EN SER_ENABLE
// bit[1]
#define RMAC_RX_ERR_DATA_TO_SER_EN SER_ENABLE
// bit[2]
#define RMAC_RX_ERR_DMA_TO_SER_EN SER_ENABLE
// bit[3]
#define RMAC_CCA_ASSERT_TO_SER_EN SER_ENABLE
// bit[4]
#define RMAC_DATAON_ASSERT_TO_SER_EN SER_ENABLE
// bit[5]
#define RMAC_CSI_DATAON_ASSERT_TO_SER_EN SER_ENABLE
// bit[6]
#define RMAC_RX_ERR_ACT_TO_SER_EN SER_ENABLE
// bit[7]
#define RMAC_RX_ERR_CSI_ACT_TO_SER_EN SER_DISABLE
// bit[8]
#define RMAC_RX_ERR_STS_ACT_TO_SER_EN SER_ENABLE
// bit[9]
#define RMAC_RX_ERR_TRIG_ACT_TO_SER_EN SER_ENABLE

/*-------------------- TMAC IMR --------------------------------------*/
// 0xCCBC
// bit[0]
#define TMAC_MACTX_SER_EN SER_ENABLE
// bit[1]
#define TMAC_TXCTL_SER_EN SER_ENABLE
// bit[2]
#define TMAC_RESP_SER_EN SER_ENABLE
// bit[3]
#define TMAC_TXPLCP_SER_EN SER_ENABLE
// bit[4]
#define TMAC_HWSIGB_GEN_SER_EN SER_ENABLE
// bit[5]
#define TMAC_RXTB_SER_EN SER_ENABLE
// bit[6]
#define TMAC_MIMO_CTRL_SER_EN SER_ENABLE
// bit[7]
#define TMAC_RMAC_CSI_SER_EN SER_ENABLE
// bit[8]
#define TMAC_RMAC_FTM_SER_EN SER_ENABLE

u32 ser_imr_config_1115e(struct mac_ax_adapter *adapter, u8 band,
			 enum mac_ax_hwmod_sel sel);

#endif /* #if MAC_AX_1115E_SUPPORT */
#endif
