/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/
#include "../gpio_cmd.h"
#include "../gpio.h"
#include "../../mac_reg.h"
#include "gpio_8851b.h"
#if MAC_AX_8851B_SUPPORT

#define MAC_AX_GPIO_MAX_8851B (sizeof(PIN_LIST_8851B) / sizeof(struct mac_ax_pin_list *))

/* GPIO0 definition */
#define GPIO0_BT_GPIO0_8851B	\
	{MAC_AX_SWGPIO, MAC_AX_GPIO0, MAC_AX_GPIO_IN_OUT, \
	 0x66, BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define GPIO0_BT_SDIO_INT_8851B	\
	{MAC_AX_BT_SDIO_INT, MAC_AX_GPIO0, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(5), BIT(5)}
#define GPIO0_USIN_8851B	\
	{MAC_AX_SWGPIO, MAC_AX_GPIO0, MAC_AX_GPIO_IN, \
	 0x66, BIT(6), BIT(6)}
#define GPIO0_BT_ANT_SW0_8851B	\
	{MAC_AX_BT_RF, MAC_AX_GPIO0, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(6), BIT(6)}
#define GPIO0_BT_ACT_8851B	\
	{MAC_AX_BT_PTA, MAC_AX_GPIO0, MAC_AX_GPIO_IN_OUT, \
	 0x41, BIT(1), BIT(1)}
#define GPIO0_WL_ACT_8851B	\
	{MAC_AX_WL_PTA, MAC_AX_GPIO0, MAC_AX_GPIO_IN_OUT, \
	 0x41, BIT(2), BIT(2)}
#define GPIO0_WLMAC_DBG_GPIO0_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO0, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO0_WLPHY_DBG_GPIO0_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO0, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO0_BT_DBG_GPIO0_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO0, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO0_PAON_2G_S0_8851B	\
	{MAC_AX_PAON_LNAON_2G_S0, MAC_AX_GPIO0, MAC_AX_GPIO_IN, \
	 0x142, BIT(0), BIT(0)}
#define GPIO0_WL_RFE_CTRL0_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_0, MAC_AX_GPIO0, MAC_AX_GPIO_IN, \
	 0x142, BIT(1), BIT(1)}
#define GPIO0_PAON_5G_S0_8851B	\
	{MAC_AX_PAON_LNAON_5G_S0, MAC_AX_GPIO0, MAC_AX_GPIO_IN, \
	 0x142, BIT(4), BIT(4)}
#define GPIO0_WL_RFE_CTRL0_1_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_2, MAC_AX_GPIO0, MAC_AX_GPIO_IN, \
	 0x142, BIT(5), BIT(5)}
#define GPIO0_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO0, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO1 definition */
#define GPIO1_BT_GPIO1_8851B	\
	{MAC_AX_SWGPIO, MAC_AX_GPIO1, MAC_AX_GPIO_IN_OUT, \
	 0x66, BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define GPIO1_USOUT_8851B	\
	{MAC_AX_UART, MAC_AX_GPIO1, MAC_AX_GPIO_OUT, \
	 0x66, BIT(6), BIT(6)}
#define GPIO1_BT_ANT_SW1_8851B	\
	{MAC_AX_BT_RF, MAC_AX_GPIO1, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(6), BIT(6)}
#define GPIO1_BT_3DD_SYNC_8851B	\
	{MAC_AX_BT_3DDLS_A, MAC_AX_GPIO1, MAC_AX_GPIO_IN, \
	 0x22, BIT(2), BIT(2)}
#define GPIO1_WL_CK_8851B	\
	{MAC_AX_BT_PTA, MAC_AX_GPIO1, MAC_AX_GPIO_OUT, \
	 0x41, BIT(1), BIT(1)}
#define GPIO1_BT_CK_8851B	\
	{MAC_AX_WL_PTA, MAC_AX_GPIO1, MAC_AX_GPIO_OUT, \
	 0x41, BIT(2), BIT(2)}
#define GPIO1_WLMAC_DBG_GPIO1_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO1, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO1_WLPHY_DBG_GPIO1_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO1, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO1_BT_DBG_GPIO1_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO1, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO1_LNAON_2G_S0_8851B	\
	{MAC_AX_PAON_LNAON_2G_S0, MAC_AX_GPIO1, MAC_AX_GPIO_IN, \
	 0x142, BIT(0), BIT(0)}
#define GPIO1_WL_RFE_CTRL1_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_0, MAC_AX_GPIO1, MAC_AX_GPIO_IN, \
	 0x142, BIT(1), BIT(1)}
#define GPIO1_LNAON_5G_S0_8851B	\
	{MAC_AX_PAON_LNAON_5G_S0, MAC_AX_GPIO1, MAC_AX_GPIO_IN, \
	 0x142, BIT(4), BIT(4)}
#define GPIO1_WL_RFE_CTRL1_1_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_2, MAC_AX_GPIO1, MAC_AX_GPIO_IN, \
	 0x142, BIT(5), BIT(5)}
#define GPIO1_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO1, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO2 definition */
#define GPIO2_BT_GPIO2_8851B	\
	{MAC_AX_SWGPIO, MAC_AX_GPIO2, MAC_AX_GPIO_IN_OUT, \
	 0x66, BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define GPIO2_BT_WAKE_8851B	\
	{MAC_AX_GPIO13_14_WL_CTRL_EN, MAC_AX_GPIO2, MAC_AX_GPIO_IN, \
	 0x4E, BIT(6), BIT(6)}
#define GPIO2_BT_ANT_SW2_8851B	\
	{MAC_AX_BT_RF, MAC_AX_GPIO2, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(6), BIT(6)}
#define GPIO2_WL_STATE_8851B	\
	{MAC_AX_BT_PTA, MAC_AX_GPIO2, MAC_AX_GPIO_OUT, \
	 0x41, BIT(1), BIT(1)}
#define GPIO2_BT_STATE_8851B	\
	{MAC_AX_WL_PTA, MAC_AX_GPIO2, MAC_AX_GPIO_OUT, \
	 0x41, BIT(2), BIT(2)}
#define GPIO2_WLMAC_DBG_GPIO2_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO2, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO2_WLPHY_DBG_GPIO2_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO2, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO2_BT_DBG_GPIO2_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO2, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO2_PAON_2G_S1_8851B	\
	{MAC_AX_PAON_LNAON_2G_S1, MAC_AX_GPIO2, MAC_AX_GPIO_IN, \
	 0x142, BIT(2), BIT(2)}
#define GPIO2_WL_RFE_CTRL2_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_1, MAC_AX_GPIO2, MAC_AX_GPIO_IN, \
	 0x142, BIT(3), BIT(3)}
#define GPIO2_PAON_5G_S1_8851B	\
	{MAC_AX_PAON_LNAON_5G_S1, MAC_AX_GPIO2, MAC_AX_GPIO_IN, \
	 0x142, BIT(6), BIT(6)}
#define GPIO2_WL_RFE_CTRL2_1_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_3, MAC_AX_GPIO2, MAC_AX_GPIO_IN, \
	 0x142, BIT(7), BIT(7)}
#define GPIO2_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO2, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO3 definition */
#define GPIO3_BT_GPIO3_8851B	\
	{MAC_AX_SWGPIO, MAC_AX_GPIO3, MAC_AX_GPIO_IN_OUT, \
	 0x66, BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define GPIO3_UART_WAKE_8851B	\
	{MAC_AX_GPIO13_14_WL_CTRL_EN, MAC_AX_GPIO3, MAC_AX_GPIO_OUT, \
	 0x4E, BIT(6), BIT(6)}
#define GPIO3_BT_ANT_SW3_8851B	\
	{MAC_AX_BT_RF, MAC_AX_GPIO3, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(6), BIT(6)}
#define GPIO3_WL_PRI_8851B	\
	{MAC_AX_BT_PTA, MAC_AX_GPIO3, MAC_AX_GPIO_OUT, \
	 0x41, BIT(1), BIT(1)}
#define GPIO3_BT_PRI_8851B	\
	{MAC_AX_WL_PTA, MAC_AX_GPIO3, MAC_AX_GPIO_OUT, \
	 0x41, BIT(2), BIT(2)}
#define GPIO3_WLMAC_DBG_GPIO3_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO3, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO3_WLPHY_DBG_GPIO3_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO3, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO3_BT_DBG_GPIO3_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO3, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO3_LNAON_2G_S1_8851B	\
	{MAC_AX_PAON_LNAON_2G_S1, MAC_AX_GPIO3, MAC_AX_GPIO_IN, \
	 0x142, BIT(2), BIT(2)}
#define GPIO3_WL_RFE_CTRL3_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_1, MAC_AX_GPIO3, MAC_AX_GPIO_IN, \
	 0x142, BIT(3), BIT(3)}
#define GPIO3_LNAON_5G_S1_8851B	\
	{MAC_AX_PAON_LNAON_5G_S1, MAC_AX_GPIO3, MAC_AX_GPIO_IN, \
	 0x142, BIT(6), BIT(6)}
#define GPIO3_WL_RFE_CTRL3_1_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_3, MAC_AX_GPIO3, MAC_AX_GPIO_IN, \
	 0x142, BIT(7), BIT(7)}
#define GPIO3_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO3, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO4 definition */
#define GPIO4_BT_SPI0_8851B	\
	{MAC_AX_BT_SFALSH, MAC_AX_GPIO4, MAC_AX_GPIO_IN_OUT, \
	 0x66, BIT(4), BIT(4)}
#define GPIO4_WL_SPI0_8851B	\
	{MAC_AX_WL_SFALSH, MAC_AX_GPIO4, MAC_AX_GPIO_IN_OUT, \
	 0x42, BIT(3), BIT(3)}
#define GPIO4_BT_JTAG_TRST_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO4, MAC_AX_GPIO_OUT, \
	 0x67, BIT(0), BIT(0)}
#define GPIO4_WL_JTAG_TRST_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO4, MAC_AX_GPIO_OUT, \
	 0x65, BIT(7), BIT(7)}
#define GPIO4_DBG_GNT_WL_8851B	\
	{MAC_AX_DBG_GNT, MAC_AX_GPIO4, MAC_AX_GPIO_OUT, \
	 0x73, BIT(3), BIT(3)}
#define GPIO4_WLMAC_DBG_GPIO4_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO4, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO4_WLPHY_DBG_GPIO4_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO4, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO4_BT_DBG_GPIO4_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO4, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO4_BANDSEL_5_6G_8851B	\
	{MAC_AX_BANDSEL_5_6G, MAC_AX_GPIO4, MAC_AX_GPIO_IN, \
	 0x143, BIT(4), BIT(4)}
#define GPIO4_WL_RFE_CTRL4_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_4, MAC_AX_GPIO4, MAC_AX_GPIO_IN, \
	 0x144, BIT(4), BIT(4)}
#define GPIO4_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO4, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO5 definition */
#define GPIO5_BT_SPI1_8851B	\
	{MAC_AX_BT_SFALSH, MAC_AX_GPIO5, MAC_AX_GPIO_OUT, \
	 0x66, BIT(4), BIT(4)}
#define GPIO5_WL_SPI1_8851B	\
	{MAC_AX_WL_SFALSH, MAC_AX_GPIO5, MAC_AX_GPIO_OUT, \
	 0x42, BIT(3), BIT(3)}
#define GPIO5_BT_JTAG_TDI_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO5, MAC_AX_GPIO_IN, \
	 0x67, BIT(0), BIT(0)}
#define GPIO5_WL_JTAG_TDI_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO5, MAC_AX_GPIO_IN, \
	 0x65, BIT(7), BIT(7)}
#define GPIO5_DBG_GNT_BT_8851B	\
	{MAC_AX_DBG_GNT, MAC_AX_GPIO5, MAC_AX_GPIO_OUT, \
	 0x73, BIT(3), BIT(3)}
#define GPIO5_BT_GPIO18_8851B	\
	{MAC_AX_BT_GPIO18, MAC_AX_GPIO5, MAC_AX_GPIO_IN_OUT, \
	 0x67, BIT(1), BIT(1)}
#define GPIO5_SOUT_8851B	\
	{MAC_AX_WL_UART_TX, MAC_AX_GPIO5, MAC_AX_GPIO_OUT, \
	 0x41, BIT(0), BIT(0)}
#define GPIO5_WLMAC_DBG_GPIO5_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO5, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO5_WLPHY_DBG_GPIO5_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO5, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO5_BT_DBG_GPIO5_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO5, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO5_I2C_INT_3W_8851B	\
	{MAC_AX_MAILBOX_3W, MAC_AX_GPIO5, MAC_AX_GPIO_IN, \
	 0x4F, BIT(4), BIT(4)}
#define GPIO5_I2C_INT_1W_8851B	\
	{MAC_AX_MAILBOX_1W, MAC_AX_GPIO5, MAC_AX_GPIO_IN, \
	 0x4F, BIT(7), BIT(7)}
#define GPIO5_BANDSEL_5_6G_8851B	\
	{MAC_AX_BANDSEL_5_6G, MAC_AX_GPIO5, MAC_AX_GPIO_IN, \
	 0x143, BIT(4), BIT(4)}
#define GPIO5_WL_RFE_CTRL5_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_4, MAC_AX_GPIO5, MAC_AX_GPIO_IN, \
	 0x144, BIT(4), BIT(4)}
#define GPIO5_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO5, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO6 definition */
#define GPIO6_BT_SPI2_8851B	\
	{MAC_AX_BT_SFALSH, MAC_AX_GPIO6, MAC_AX_GPIO_OUT, \
	 0x66, BIT(4), BIT(4)}
#define GPIO6_WL_SPI2_8851B	\
	{MAC_AX_WL_SFALSH, MAC_AX_GPIO6, MAC_AX_GPIO_OUT, \
	 0x42, BIT(3), BIT(3)}
#define GPIO6_BT_JTAG_TDO_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO6, MAC_AX_GPIO_OUT, \
	 0x67, BIT(0), BIT(0)}
#define GPIO6_WL_JTAG_TDO_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO6, MAC_AX_GPIO_OUT, \
	 0x65, BIT(7), BIT(7)}
#define GPIO6_LTE_UART_IN_8851B	\
	{MAC_AX_LTE_UART, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x73, BIT(2), BIT(2)}
#define GPIO6_LTE_3W_RX_IN_8851B	\
	{MAC_AX_LTE_3W, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x73, BIT(2), BIT(2)}
#define GPIO6_BT_3DD_SYNC_8851B	\
	{MAC_AX_BT_3DDLS_B, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x67, BIT(1), BIT(1)}
#define GPIO6_SIN_8851B	\
	{MAC_AX_WL_UART_RX, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x40, BIT(2), BIT(2)}
#define GPIO6_WLMAC_DBG_GPIO6_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO6, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO6_WLPHY_DBG_GPIO6_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO6, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO6_BT_DBG_GPIO6_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO6, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO6_PAON_6G_S1_8851B	\
	{MAC_AX_PAON_LNAON_6G_S1, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x143, BIT(2), BIT(2)}
#define GPIO6_WL_RFE_CTRL6_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_7, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x144, BIT(4), BIT(4)}
#define GPIO6_BANDSEL_5G_8851B	\
	{MAC_AX_BANDSEL_5G, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x143, BIT(2), BIT(2)}
#define GPIO6_WL_RFE_CTRL6_1_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_8, MAC_AX_GPIO6, MAC_AX_GPIO_IN, \
	 0x145, BIT(0), BIT(0)}
#define GPIO6_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO6, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO7 definition */
#define GPIO7_BT_SPI3_8851B	\
	{MAC_AX_BT_SFALSH, MAC_AX_GPIO7, MAC_AX_GPIO_OUT, \
	 0x66, BIT(4), BIT(4)}
#define GPIO7_WL_SPI3_8851B	\
	{MAC_AX_WL_SFALSH, MAC_AX_GPIO7, MAC_AX_GPIO_OUT, \
	 0x42, BIT(3), BIT(3)}
#define GPIO7_BT_JTAG_TMS_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x67, BIT(0), BIT(0)}
#define GPIO7_WL_JTAG_TMS_8851B	\
	{MAC_AX_BT_JTAG, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x65, BIT(7), BIT(7)}
#define GPIO7_LTE_UART_OUT_8851B	\
	{MAC_AX_LTE_UART, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x73, BIT(2), BIT(2)}
#define GPIO7_LTE_3W_TX_IN_8851B	\
	{MAC_AX_LTE_3W, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x73, BIT(2), BIT(2)}
#define GPIO7_BT_GPIO16_8851B	\
	{MAC_AX_BT_GPIO16, MAC_AX_GPIO7, MAC_AX_GPIO_IN_OUT, \
	 0x67, BIT(2), BIT(2)}
#define GPIO7_SOUT_8851B	\
	{MAC_AX_WL_UART_TX, MAC_AX_GPIO7, MAC_AX_GPIO_OUT, \
	 0x41, BIT(0), BIT(0)}
#define GPIO7_WLMAC_DBG_GPIO7_8851B	\
	{MAC_AX_WLMAC_DBG, MAC_AX_GPIO7, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(0)}
#define GPIO7_WLPHY_DBG_GPIO7_8851B	\
	{MAC_AX_WLPHY_DBG, MAC_AX_GPIO7, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1)}
#define GPIO7_BT_DBG_GPIO7_8851B	\
	{MAC_AX_BT_DBG, MAC_AX_GPIO7, MAC_AX_GPIO_OUT, \
	 0x40, BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define GPIO7_LNAON_6G_S1_8851B	\
	{MAC_AX_PAON_LNAON_6G_S1, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x143, BIT(2), BIT(2)}
#define GPIO7_WL_RFE_CTRL7_0_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_7, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x144, BIT(4), BIT(4)}
#define GPIO7_BANDSEL_5G_8851B	\
	{MAC_AX_BANDSEL_5G, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x143, BIT(2), BIT(2)}
#define GPIO7_WL_RFE_CTRL7_1_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_8, MAC_AX_GPIO7, MAC_AX_GPIO_IN, \
	 0x145, BIT(0), BIT(0)}
#define GPIO7_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO7, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO8 definition */
#define GPIO8_EXT_WOL_8851B	\
	{MAC_AX_WL_HW_EXTWOL, MAC_AX_GPIO8, MAC_AX_GPIO_IN, \
	 0x4A, BIT(0), BIT(0)}
#define GPIO8_SICK_8851B	\
	{MAC_AX_SIC, MAC_AX_GPIO8, MAC_AX_GPIO_IN, \
	 0x41, BIT(4), BIT(4)}
#define GPIO8_WL_LED_8851B	\
	{MAC_AX_WL_LED, MAC_AX_GPIO8, MAC_AX_GPIO_IN, \
	 0x4E, BIT(5), BIT(5)}
#define GPIO8_SOUT_8851B	\
	{MAC_AX_WL_UART_TX, MAC_AX_GPIO8, MAC_AX_GPIO_OUT, \
	 0x41, BIT(0), BIT(0)}
#define GPIO8_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO8, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO9 definition */
#define GPIO9_DIS_WL_N_8851B	\
	{MAC_AX_WL_HWPDN, MAC_AX_GPIO9, MAC_AX_GPIO_IN, \
	 0x68, BIT(3), BIT(3)}
#define GPIO9_EXT_WOL_8851B	\
	{MAC_AX_WL_HW_EXTWOL, MAC_AX_GPIO9, MAC_AX_GPIO_IN, \
	 0x4A, BIT(0), BIT(0)}
#define GPIO9_USIN_8851B	\
	{MAC_AX_UART, MAC_AX_GPIO9, MAC_AX_GPIO_IN, \
	 0x66, BIT(6), BIT(6)}
#define GPIO9_I2C_SD_8851B	\
	{MAC_AX_MAILBOX_3W, MAC_AX_GPIO9, MAC_AX_GPIO_IN, \
	 0x4F, BIT(4), BIT(4)}
#define GPIO9_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO9, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO10 definition */
#define GPIO10_WL_SDIO_INT_8851B	\
	{MAC_AX_WL_SDIO_INT, MAC_AX_GPIO10, MAC_AX_GPIO_OUT, \
	 0x72, BIT(2), BIT(2)}
#define GPIO10_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO10, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO11 definition */
#define GPIO11_DIS_BT_N_8851B	\
	{MAC_AX_BT_HWPDN, MAC_AX_GPIO11, MAC_AX_GPIO_IN, \
	 0x6A, BIT(3), BIT(3)}
#define GPIO11_USOUT_8851B	\
	{MAC_AX_UART, MAC_AX_GPIO11, MAC_AX_GPIO_OUT, \
	 0x66, BIT(6), BIT(6)}
#define GPIO11_BANDSEL_5G_G7G6_8851B	\
	{MAC_AX_BANDSEL_5G_G7G6, MAC_AX_GPIO11, MAC_AX_GPIO_IN, \
	 0x143, BIT(6), BIT(6)}
#define GPIO11_WL_RFE_CTRL11_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_5, MAC_AX_GPIO11, MAC_AX_GPIO_IN, \
	 0x144, BIT(5), BIT(5)}
#define GPIO11_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO11, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO12 definition */
#define GPIO12_USCTS_8851B	\
	{MAC_AX_UART, MAC_AX_GPIO12, MAC_AX_GPIO_IN, \
	 0x66, BIT(6), BIT(6)}
#define GPIO12_LTE_PRI_OUT_8851B	\
	{MAC_AX_LTE_3W, MAC_AX_GPIO12, MAC_AX_GPIO_OUT, \
	 0x73, BIT(2), BIT(2)}
#define GPIO12_I2C_CLK_8851B	\
	{MAC_AX_MAILBOX_3W, MAC_AX_GPIO12, MAC_AX_GPIO_IN, \
	 0x4F, BIT(4), BIT(4)}
#define GPIO12_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO12, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO13 definition */
#define GPIO13_BT_WAKE_8851B	\
	{MAC_AX_GPIO13_14_WL_CTRL_EN, MAC_AX_GPIO13, MAC_AX_GPIO_IN, \
	 0x4E, BIT(6), BIT(6)}
#define GPIO13_BT_ANT_SW0_8851B	\
	{MAC_AX_BT_RF, MAC_AX_GPIO13, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(6), BIT(6)}
#define GPIO13_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO13, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO14 definition */
#define GPIO14_UART_WAKE_8851B	\
	{MAC_AX_GPIO13_14_WL_CTRL_EN, MAC_AX_GPIO14, MAC_AX_GPIO_IN, \
	 0x4E, BIT(6), BIT(6)}
#define GPIO14_BT_ANT_SW1_8851B	\
	{MAC_AX_BT_RF, MAC_AX_GPIO14, MAC_AX_GPIO_OUT, \
	 0x4F, BIT(6), BIT(6)}
#define GPIO14_SIN_8851B	\
	{MAC_AX_WL_UART_RX, MAC_AX_GPIO14, MAC_AX_GPIO_IN, \
	 0x40, BIT(2), BIT(2)}
#define GPIO14_BANDSEL_5G_G7G6_8851B	\
	{MAC_AX_BANDSEL_5G_G7G6, MAC_AX_GPIO14, MAC_AX_GPIO_IN, \
	 0x143, BIT(6), BIT(6)}
#define GPIO14_WL_RFE_CTRL11_8851B	\
	{MAC_AX_RFE_WLBT_FUNC_5, MAC_AX_GPIO14, MAC_AX_GPIO_IN, \
	 0x144, BIT(5), BIT(5)}
#define GPIO14_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO14, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

/* GPIO15 definition */
#define GPIO15_EXT_XTAL_EN_8851B	\
	{MAC_AX_EXT_XTAL_CLK, MAC_AX_GPIO15, MAC_AX_GPIO_IN, \
	 0x66, BIT(7), BIT(7)}
#define GPIO15_SW_IO_8851B	\
	{MAC_AX_SW_IO, MAC_AX_GPIO15, MAC_AX_GPIO_IN_OUT, \
	 0x40, BIT(1) | BIT(0), 0}

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO0_8851B[] = {
	GPIO0_BT_GPIO0_8851B,
	GPIO0_BT_SDIO_INT_8851B,
	GPIO0_USIN_8851B,
	GPIO0_BT_ANT_SW0_8851B,
	GPIO0_BT_ACT_8851B,
	GPIO0_WL_ACT_8851B,
	GPIO0_WLMAC_DBG_GPIO0_8851B,
	GPIO0_WLPHY_DBG_GPIO0_8851B,
	GPIO0_BT_DBG_GPIO0_8851B,
	GPIO0_PAON_2G_S0_8851B,
	GPIO0_WL_RFE_CTRL0_0_8851B,
	GPIO0_PAON_5G_S0_8851B,
	GPIO0_WL_RFE_CTRL0_1_8851B,
	GPIO0_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO1_8851B[] = {
	GPIO1_BT_GPIO1_8851B,
	GPIO1_USOUT_8851B,
	GPIO1_BT_ANT_SW1_8851B,
	GPIO1_BT_3DD_SYNC_8851B,
	GPIO1_WL_CK_8851B,
	GPIO1_BT_CK_8851B,
	GPIO1_WLMAC_DBG_GPIO1_8851B,
	GPIO1_WLPHY_DBG_GPIO1_8851B,
	GPIO1_BT_DBG_GPIO1_8851B,
	GPIO1_LNAON_2G_S0_8851B,
	GPIO1_WL_RFE_CTRL1_0_8851B,
	GPIO1_LNAON_5G_S0_8851B,
	GPIO1_WL_RFE_CTRL1_1_8851B,
	GPIO1_SW_IO_8851B,
	GPIO1_BT_3DD_SYNC_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO2_8851B[] = {
	GPIO2_BT_GPIO2_8851B,
	GPIO2_BT_WAKE_8851B,
	GPIO2_BT_ANT_SW2_8851B,
	GPIO2_WL_STATE_8851B,
	GPIO2_BT_STATE_8851B,
	GPIO2_WLMAC_DBG_GPIO2_8851B,
	GPIO2_WLPHY_DBG_GPIO2_8851B,
	GPIO2_BT_DBG_GPIO2_8851B,
	GPIO2_PAON_2G_S1_8851B,
	GPIO2_WL_RFE_CTRL2_0_8851B,
	GPIO2_PAON_5G_S1_8851B,
	GPIO2_WL_RFE_CTRL2_1_8851B,
	GPIO2_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO3_8851B[] = {
	GPIO3_BT_GPIO3_8851B,
	GPIO3_UART_WAKE_8851B,
	GPIO3_BT_ANT_SW3_8851B,
	GPIO3_WL_PRI_8851B,
	GPIO3_BT_PRI_8851B,
	GPIO3_WLMAC_DBG_GPIO3_8851B,
	GPIO3_WLPHY_DBG_GPIO3_8851B,
	GPIO3_BT_DBG_GPIO3_8851B,
	GPIO3_LNAON_2G_S1_8851B,
	GPIO3_WL_RFE_CTRL3_0_8851B,
	GPIO3_LNAON_5G_S1_8851B,
	GPIO3_WL_RFE_CTRL3_1_8851B,
	GPIO3_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO4_8851B[] = {
	GPIO4_BT_SPI0_8851B,
	GPIO4_WL_SPI0_8851B,
	GPIO4_BT_JTAG_TRST_8851B,
	GPIO4_WL_JTAG_TRST_8851B,
	GPIO4_DBG_GNT_WL_8851B,
	GPIO4_WLMAC_DBG_GPIO4_8851B,
	GPIO4_WLPHY_DBG_GPIO4_8851B,
	GPIO4_BT_DBG_GPIO4_8851B,
	GPIO4_BANDSEL_5_6G_8851B,
	GPIO4_WL_RFE_CTRL4_0_8851B,
	GPIO4_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO5_8851B[] = {
	GPIO5_BT_SPI1_8851B,
	GPIO5_WL_SPI1_8851B,
	GPIO5_BT_JTAG_TDI_8851B,
	GPIO5_WL_JTAG_TDI_8851B,
	GPIO5_DBG_GNT_BT_8851B,
	GPIO5_BT_GPIO18_8851B,
	GPIO5_SOUT_8851B,
	GPIO5_WLMAC_DBG_GPIO5_8851B,
	GPIO5_WLPHY_DBG_GPIO5_8851B,
	GPIO5_BT_DBG_GPIO5_8851B,
	GPIO5_I2C_INT_3W_8851B,
	GPIO5_I2C_INT_1W_8851B,
	GPIO5_BANDSEL_5_6G_8851B,
	GPIO5_WL_RFE_CTRL5_0_8851B,
	GPIO5_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO6_8851B[] = {
	GPIO6_BT_SPI2_8851B,
	GPIO6_WL_SPI2_8851B,
	GPIO6_BT_JTAG_TDO_8851B,
	GPIO6_WL_JTAG_TDO_8851B,
	GPIO6_LTE_UART_IN_8851B,
	GPIO6_LTE_3W_RX_IN_8851B,
	GPIO6_SIN_8851B,
	GPIO6_WLMAC_DBG_GPIO6_8851B,
	GPIO6_WLPHY_DBG_GPIO6_8851B,
	GPIO6_BT_DBG_GPIO6_8851B,
	GPIO6_PAON_6G_S1_8851B,
	GPIO6_WL_RFE_CTRL6_0_8851B,
	GPIO6_BANDSEL_5G_8851B,
	GPIO6_WL_RFE_CTRL6_1_8851B,
	GPIO6_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO7_8851B[] = {
	GPIO7_BT_SPI3_8851B,
	GPIO7_WL_SPI3_8851B,
	GPIO7_BT_JTAG_TMS_8851B,
	GPIO7_WL_JTAG_TMS_8851B,
	GPIO7_LTE_UART_OUT_8851B,
	GPIO7_LTE_3W_TX_IN_8851B,
	GPIO7_BT_GPIO16_8851B,
	GPIO7_SOUT_8851B,
	GPIO7_WLMAC_DBG_GPIO7_8851B,
	GPIO7_WLPHY_DBG_GPIO7_8851B,
	GPIO7_BT_DBG_GPIO7_8851B,
	GPIO7_LNAON_6G_S1_8851B,
	GPIO7_WL_RFE_CTRL7_0_8851B,
	GPIO7_BANDSEL_5G_8851B,
	GPIO7_WL_RFE_CTRL7_1_8851B,
	GPIO7_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO8_8851B[] = {
	GPIO8_EXT_WOL_8851B,
	GPIO8_SICK_8851B,
	GPIO8_WL_LED_8851B,
	GPIO8_SOUT_8851B,
	GPIO8_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO9_8851B[] = {
	GPIO9_DIS_WL_N_8851B,
	GPIO9_EXT_WOL_8851B,
	GPIO9_USIN_8851B,
	GPIO9_I2C_SD_8851B,
	GPIO9_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO10_8851B[] = {
	GPIO10_WL_SDIO_INT_8851B,
	GPIO10_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO11_8851B[] = {
	GPIO11_DIS_BT_N_8851B,
	GPIO11_USOUT_8851B,
	GPIO11_BANDSEL_5G_G7G6_8851B,
	GPIO11_WL_RFE_CTRL11_8851B,
	GPIO11_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO12_8851B[] = {
	GPIO12_USCTS_8851B,
	GPIO12_LTE_PRI_OUT_8851B,
	GPIO12_I2C_CLK_8851B,
	GPIO12_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO13_8851B[] = {
	GPIO13_BT_WAKE_8851B,
	GPIO13_BT_ANT_SW0_8851B,
	GPIO13_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO14_8851B[] = {
	GPIO14_UART_WAKE_8851B,
	GPIO14_BT_ANT_SW1_8851B,
	GPIO14_SIN_8851B,
	GPIO14_BANDSEL_5G_G7G6_8851B,
	GPIO14_WL_RFE_CTRL11_8851B,
	GPIO14_SW_IO_8851B,
};

static const struct mac_ax_pinmux_list PINMUX_LIST_GPIO15_8851B[] = {
	GPIO15_EXT_XTAL_EN_8851B,
	GPIO15_SW_IO_8851B,
};

#define PINMUX_GPIO0_BT_GPIO0_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO0_LTE_UART_IN_PINEN_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define PINMUX_GPIO0_LTE_UART_IN_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO0_LTE_UART_IN_DIS_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO0_LTE_3W_RX_IN_PINEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define PINMUX_GPIO0_LTE_3W_RX_IN_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO0_LTE_3W_RX_IN_DIS_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO0_WL_ACT_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO0_WL_ACT_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO0_BT_ACT_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO0_BT_ACT_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO0_DBG_GNT_WL_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1)}
#define PINMUX_GPIO0_WL_JTAG_TRST_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO0_WL_JTAG_TRST_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO0_WL_JTAG_TRST_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO0_WL_JTAG_TRST_DIS_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO0_WL_RFE_CTRL0_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO0_DBG0_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO0_SW_IO0_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO1_BT_GPIO1_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO1_LTE_UART_OUT_PINEN_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(5) | BIT(4)}
#define PINMUX_GPIO1_LTE_UART_OUT_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO1_LTE_3W_TX_IN_PINEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6)}
#define PINMUX_GPIO1_LTE_3W_TX_IN_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO1_LTE_3W_TX_IN_DIS_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO1_BT_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO1_BT_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO1_WL_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO1_WL_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO1_DBG_GNT_BT_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5)}
#define PINMUX_GPIO1_WL_JTAG_TDI_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO1_WL_JTAG_TDI_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO1_WL_JTAG_TDI_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO1_WL_JTAG_TDI_DIS_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO1_WL_RFE_CTRL1_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO1_DBG1_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO1_SW_IO1_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D0, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO2_WL_PD_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PD, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), 0}
#define PINMUX_GPIO2_WL_PD_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PD, 0x68, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO2_WL_PD_DIS_8851B \
	{RTW_MAC_GPIO_WL_PD, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO2_WL_PD_DIS_2_8851B \
	{RTW_MAC_GPIO_WL_PD, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO2_BT_GPIO2_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO2_LTE_3W_PRI_OUT_PINEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define PINMUX_GPIO2_LTE_3W_PRI_OUT_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO2_BT_STA_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO2_BT_STA_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO2_WL_STA_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO2_WL_STA_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO2_DBG_GNT_WL_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1)}
#define PINMUX_GPIO2_WL_JTAG_TDO_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO2_WL_JTAG_TDO_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO2_WL_JTAG_TDO_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO2_WL_JTAG_TDO_DIS_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO2_WL_RFE_CTRL2_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO2_DBG2_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO2_SW_IO02_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D1, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO3_BT_PD_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), 0}
#define PINMUX_GPIO3_BT_PD_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x6A, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO3_BT_GPIO3_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO3_BT_PRI_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO3_BT_PRI_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO3_WL_PRI_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO3_WL_PRI_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO3_DBG_GNT_BT_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5)}
#define PINMUX_GPIO3_WL_JTAG_TMS_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO3_WL_JTAG_TMS_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO3_WL_JTAG_TMS_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO3_WL_JTAG_TMS_DIS_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO3_WL_RFE_CTRL3_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO3_DBG3_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO3_SW_IO3_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D1, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO4_BT_GPIO4_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO4_WL_FLASH0_PINEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO4_WL_FLASH0_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x42, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO4_BT_FLASH0_PINEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO4_BT_FLASH0_SECEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO4_BT_FLASH0_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x66, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO4_WL_JTAG_TRST_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO4_WL_JTAG_TRST_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO4_WL_JTAG_TRST_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO4_WL_RFE_CTRL4_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO4_DBG4_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO4_SW_IO04_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D2, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO5_BT_GPIO5_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO5_WL_FLASH1_PINEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(5)}
#define PINMUX_GPIO5_WL_FLASH1_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x42, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO5_BT_FLASH1_PINEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(5)}
#define PINMUX_GPIO5_BT_FLASH1_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x66, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO5_BT_FLASH1_SECEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO5_MAILBOX_I2C_INT_PINEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO5_MAILBOX_I2C_INT_FUNCEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x4F, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO5_XTAL_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_XTAL_CLK, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5)}
#define PINMUX_GPIO5_XTAL_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_XTAL_CLK, 0x4F, \
	 BIT(5), BIT(5)}
#define PINMUX_GPIO5_WL_JTAG_TDI_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO5_WL_JTAG_TDI_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO5_WL_JTAG_TDI_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO5_WL_RFE_CTRL5_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO5_DBG5_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO5_SW_IO5_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D2, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO6_BT_PD_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), 0}
#define PINMUX_GPIO6_BT_PD_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x6A, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO6_BT_GPIO6_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO6_WL_FLASH2_PINEN_8851B	\
	{RTW_MAC_GPIO_WL_FLASH, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO6_WL_FLASH2_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x42, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO6_BT_FLASH2_PINEN_8851B	\
	{RTW_MAC_GPIO_BT_FLASH, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO6_BT_FLASH2_SECEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO6_BT_FLASH2_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x66, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO6_LTE_UART_IN_PINEN_8851B	\
	{RTW_MAC_GPIO_LTE_UART, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1) | BIT(0)}
#define PINMUX_GPIO6_LTE_UART_IN_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO6_LTE_3W_RX_IN_PINEN_8851B	\
	{RTW_MAC_GPIO_LTE_3W, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2)}
#define PINMUX_GPIO6_LTE_3W_RX_IN_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO6_MAILBOX_I2C_SD_PINEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO6_MAILBOX_I2C_SD_FUNCEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x4F, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO6_DBG_GNT_WL_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1)}
#define PINMUX_GPIO6_WL_JTAG_TDO_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO6_WL_JTAG_TDO_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO6_WL_JTAG_TDO_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO6_WL_RFE6_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO6_DBG_GPIO6_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO6_SW_IO6_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D3, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO7_BT_PD_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), 0}
#define PINMUX_GPIO7_BT_PD_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x6A, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO7_BT_GPIO7_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO7_WL_FLASH3_PINEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(5)}
#define PINMUX_GPIO7_WL_FLASH3_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_FLASH, 0x42, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO7_BT_FLASH3_PINEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(5)}
#define PINMUX_GPIO7_BT_FLASH3_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0x66, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO7_BT_FLASH3_SECEN_8851B \
	{RTW_MAC_GPIO_BT_FLASH, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO7_LTE_UART_OUT_PINEN_8851B	\
	{RTW_MAC_GPIO_LTE_UART, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(5) | BIT(4)}
#define PINMUX_GPIO7_LTE_UART_OUT_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_UART, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO7_LTE_3W_TX_IN_PINEN_8851B	\
	{RTW_MAC_GPIO_LTE_3W, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6)}
#define PINMUX_GPIO7_LTE_3W_TX_IN_FUNCEN_8851B \
	{RTW_MAC_GPIO_LTE_3W, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO7_MAILBOX_I2C_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO7_MAILBOX_I2C_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x4F, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO7_DBG_GNT_BT_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5)}
#define PINMUX_GPIO7_WL_JTAG_TMS_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO7_WL_JTAG_TMS_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO7_WL_JTAG_TMS_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO7_WL_RFE_CTRL7_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO7_DBG7_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO7_SW_IO7_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D3, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO8_EXT_WOL_PINEN_8851B \
	{RTW_MAC_GPIO_WL_EXTWOL, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), 0}
#define PINMUX_GPIO8_EXT_WOL_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_EXTWOL, 0x4A, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO8_BT_GPIO8_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO8_SIC_CLK_PINEN_8851B	\
	{RTW_MAC_GPIO_SIC, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO8_SIC_CLK_FUNCEN_8851B	\
	{RTW_MAC_GPIO_SIC, 0x41, \
	 BIT(4) | BIT(3), BIT(4) | BIT(3)}
#define PINMUX_GPIO8_SIC_CLK_SECEN_8851B	\
	{RTW_MAC_GPIO_SIC, 0xC00, \
	 BIT(1), BIT(1)}
#define PINMUX_GPIO8_MAILBOX_I2C_INT_PINEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO8_MAILBOX_I2C_INT_FUNCEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x4F, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO8_WL_LED_PINEN_8851B \
	{RTW_MAC_GPIO_WL_LED, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1)}
#define PINMUX_GPIO8_WL_LED_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_LED, 0x4E, \
	 BIT(5), BIT(5)}
#define PINMUX_GPIO8_WL_UART_TX_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO8_WL_UART_TX_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x41, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO8_WL_UART_TX_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0xC00, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO8_WL_RFE8_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO8_DBG_GPIO8_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO8_SW_IO8_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D4, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO9_WL_PD_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PD, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), 0}
#define PINMUX_GPIO9_BT_GPIO9_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO9_MAILBOX_I2C_SD_PINEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO9_MAILBOX_I2C_SD_FUNCEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x4F, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO9_DBG_GNT_WL_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5)}
#define PINMUX_GPIO9_WL_UART_TX_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO9_WL_UART_TX_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x41, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO9_WL_UART_TX_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0xC00, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO9_WL_RFE_CTRL9_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO9_DBG9_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO9_SW_IO9_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D4, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO10_BT_GPIO10_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO10_WL_SDIO_INT_PINEN_8851B	\
	{RTW_MAC_GPIO_WL_SDIO_INT, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO10_WL_UART_RX_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO10_WL_UART_RX_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x40, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO10_WL_UART_RX_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0xC00, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO10_WL_UART_RX_DIS_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO10_WL_UART_RX_DIS_2_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO10_WL_RFE10_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO10_DBG_GPIO10_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO10_SW_IO10_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO11_BT_PD_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PD, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), 0}
#define PINMUX_GPIO11_BT_GPIO11_PINEN_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO11_MAILBOX_I2C_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO11_MAILBOX_I2C_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_MAILBOX, 0x4F, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO11_DBG_GNT_BT_PINEN_8851B \
	{RTW_MAC_GPIO_DBG_GNT, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5)}
#define PINMUX_GPIO11_WL_UART_RX_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO11_WL_UART_RX_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0xC00, \
	 BIT(4), BIT(4)}
#define PINMUX_GPIO11_WL_UART_RX_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x40, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO11_WL_UART_RX_DIS_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x2D5, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO11_WL_UART_RX_DIS_2_8851B \
	{RTW_MAC_GPIO_WL_UART_RX, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO11_WL_RFE_CTRL11_PINEN_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO11_DBG11_PINEN_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO11_SW_IO11_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D5, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO12_BT_GPIO12_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO12_LTE_3W_PRI_OUT_PINEN_8851B	\
	{RTW_MAC_GPIO_LTE_3W, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(1)}
#define PINMUX_GPIO12_LTE_3W_PRI_OUT_FUNCEN_8851B	\
	{RTW_MAC_GPIO_LTE_3W, 0x73, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO12_WL_ACT_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO12_WL_ACT_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO12_BT_ACT_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO12_BT_ACT_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO12_BT_ACT_DIS_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D0, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO12_DBG_GNT_WL_PINEN_8851B	\
	{RTW_MAC_GPIO_DBG_GNT, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1)}
#define PINMUX_GPIO12_SOUT_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO12_SOUT_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0xC00, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO12_SOUT_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x41, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO12_WL_RFE12_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO12_DBG_GPIO12_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO12_SW_IO12_PINEN_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D6, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO13_BT_GPIO13_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO13_WL_PTA_BT_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO13_WL_PTA_BT_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO13_BT_PTA_WL_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO13_BT_PTA_WL_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO13_WL_UART_TX_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO13_WL_UART_TX_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0xC00, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO13_WL_UART_TX_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x41, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO13_WL_RFE_CTRL13_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO13_DBG13_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO13_SW_IO13_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D6, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO14_BT_GPIO14_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(0)}
#define PINMUX_GPIO14_WL_PTA_BT_STA_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO14_WL_PTA_BT_STA_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO14_BT_PTA_WL_STA_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(0)}
#define PINMUX_GPIO14_BT_PTA_WL_STA_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO14_WL_JTAG_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(2) | BIT(1) | BIT(0)}
#define PINMUX_GPIO14_WL_JTAG_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0x65, \
	 BIT(7), BIT(7)}
#define PINMUX_GPIO14_WL_JTAG_CLK_SECEN_8851B \
	{RTW_MAC_GPIO_WL_JTAG, 0xC00, \
	 BIT(2), BIT(2)}
#define PINMUX_GPIO14_WL_RFE_CTRL13_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}
#define PINMUX_GPIO14_DBG14_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1)}
#define PINMUX_GPIO14_SW_IO14_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D7, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3) | BIT(2) | BIT(1) | BIT(0)}

#define PINMUX_GPIO15_WL_PD_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PD, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), 0}
#define PINMUX_GPIO15_BT_GPIO15_8851B \
	{RTW_MAC_GPIO_BT_GPIO, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(4)}
#define PINMUX_GPIO15_WL_PTA_BT_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO15_WL_PTA_BT_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2)}
#define PINMUX_GPIO15_BT_PTA_WL_CLK_PINEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(4)}
#define PINMUX_GPIO15_BT_PTA_WL_CLK_FUNCEN_8851B \
	{RTW_MAC_GPIO_BT_PTA, 0x41, \
	 BIT(2) | BIT(1), BIT(2) | BIT(1)}
#define PINMUX_GPIO15_WL_UART_TX_PINEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(6) | BIT(5) | BIT(4)}
#define PINMUX_GPIO15_WL_UART_TX_SECEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0xC00, \
	 BIT(3), BIT(3)}
#define PINMUX_GPIO15_WL_UART_TX_FUNCEN_8851B \
	{RTW_MAC_GPIO_WL_UART_TX, 0x41, \
	 BIT(0), BIT(0)}
#define PINMUX_GPIO15_WL_RFE_CTRL15_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}
#define PINMUX_GPIO15_DBG15_8851B \
	{RTW_MAC_GPIO_DBG, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5)}
#define PINMUX_GPIO15_SW_IO15_8851B \
	{RTW_MAC_GPIO_SW_IO, 0x2D7, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7) | BIT(6) | BIT(5) | BIT(4)}

#define PINMUX_GPIO16_WL_RFE_CTRL16_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D8, \
	 BIT(3) | BIT(2) | BIT(1) | BIT(0), BIT(3)}

#define PINMUX_GPIO17_WL_RFE_CTRL17_8851B \
	{RTW_MAC_GPIO_WL_RFE_CTRL, 0x2D8, \
	 BIT(7) | BIT(6) | BIT(5) | BIT(4), BIT(7)}

#define PINMUX_GPIO_END_8851B \
	{RTW_MAC_GPIO_INVALID, 0, 0, 0}

static const struct mac_ax_pin_list PIN_LIST_GPIO0_8851B[] = {
	PINMUX_GPIO0_BT_GPIO0_PINEN_8851B,
	PINMUX_GPIO0_LTE_UART_IN_PINEN_8851B,
	PINMUX_GPIO0_LTE_UART_IN_FUNCEN_8851B,
	PINMUX_GPIO0_LTE_UART_IN_DIS_8851B,
	PINMUX_GPIO0_LTE_3W_RX_IN_PINEN_8851B,
	PINMUX_GPIO0_LTE_3W_RX_IN_FUNCEN_8851B,
	PINMUX_GPIO0_LTE_3W_RX_IN_DIS_8851B,
	PINMUX_GPIO0_WL_ACT_PINEN_8851B,
	PINMUX_GPIO0_WL_ACT_FUNCEN_8851B,
	PINMUX_GPIO0_BT_ACT_PINEN_8851B,
	PINMUX_GPIO0_BT_ACT_FUNCEN_8851B,
	PINMUX_GPIO0_DBG_GNT_WL_PINEN_8851B,
	PINMUX_GPIO0_WL_JTAG_TRST_PINEN_8851B,
	PINMUX_GPIO0_WL_JTAG_TRST_FUNCEN_8851B,
	PINMUX_GPIO0_WL_JTAG_TRST_SECEN_8851B,
	PINMUX_GPIO0_WL_JTAG_TRST_DIS_8851B,
	PINMUX_GPIO0_WL_RFE_CTRL0_PINEN_8851B,
	PINMUX_GPIO0_DBG0_PINEN_8851B,
	PINMUX_GPIO0_SW_IO0_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO1_8851B[] = {
	PINMUX_GPIO1_BT_GPIO1_PINEN_8851B,
	PINMUX_GPIO1_LTE_UART_OUT_PINEN_8851B,
	PINMUX_GPIO1_LTE_UART_OUT_FUNCEN_8851B,
	PINMUX_GPIO1_LTE_3W_TX_IN_PINEN_8851B,
	PINMUX_GPIO1_LTE_3W_TX_IN_FUNCEN_8851B,
	PINMUX_GPIO1_LTE_3W_TX_IN_DIS_8851B,
	PINMUX_GPIO1_BT_CLK_PINEN_8851B,
	PINMUX_GPIO1_BT_CLK_FUNCEN_8851B,
	PINMUX_GPIO1_WL_CLK_PINEN_8851B,
	PINMUX_GPIO1_WL_CLK_FUNCEN_8851B,
	PINMUX_GPIO1_DBG_GNT_BT_PINEN_8851B,
	PINMUX_GPIO1_WL_JTAG_TDI_PINEN_8851B,
	PINMUX_GPIO1_WL_JTAG_TDI_FUNCEN_8851B,
	PINMUX_GPIO1_WL_JTAG_TDI_SECEN_8851B,
	PINMUX_GPIO1_WL_JTAG_TDI_DIS_8851B,
	PINMUX_GPIO1_WL_RFE_CTRL1_PINEN_8851B,
	PINMUX_GPIO1_DBG1_PINEN_8851B,
	PINMUX_GPIO1_SW_IO1_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO2_8851B[] = {
	PINMUX_GPIO2_WL_PD_PINEN_8851B,
	PINMUX_GPIO2_WL_PD_FUNCEN_8851B,
	PINMUX_GPIO2_WL_PD_DIS_8851B,
	PINMUX_GPIO2_WL_PD_DIS_2_8851B,
	PINMUX_GPIO2_BT_GPIO2_PINEN_8851B,
	PINMUX_GPIO2_LTE_3W_PRI_OUT_PINEN_8851B,
	PINMUX_GPIO2_LTE_3W_PRI_OUT_FUNCEN_8851B,
	PINMUX_GPIO2_BT_STA_PINEN_8851B,
	PINMUX_GPIO2_BT_STA_FUNCEN_8851B,
	PINMUX_GPIO2_WL_STA_PINEN_8851B,
	PINMUX_GPIO2_WL_STA_FUNCEN_8851B,
	PINMUX_GPIO2_DBG_GNT_WL_PINEN_8851B,
	PINMUX_GPIO2_WL_JTAG_TDO_PINEN_8851B,
	PINMUX_GPIO2_WL_JTAG_TDO_FUNCEN_8851B,
	PINMUX_GPIO2_WL_JTAG_TDO_SECEN_8851B,
	PINMUX_GPIO2_WL_JTAG_TDO_DIS_8851B,
	PINMUX_GPIO2_WL_RFE_CTRL2_PINEN_8851B,
	PINMUX_GPIO2_DBG2_PINEN_8851B,
	PINMUX_GPIO2_SW_IO02_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO3_8851B[] = {
	PINMUX_GPIO3_BT_PD_PINEN_8851B,
	PINMUX_GPIO3_BT_PD_FUNCEN_8851B,
	PINMUX_GPIO3_BT_GPIO3_PINEN_8851B,
	PINMUX_GPIO3_BT_PRI_PINEN_8851B,
	PINMUX_GPIO3_BT_PRI_FUNCEN_8851B,
	PINMUX_GPIO3_WL_PRI_PINEN_8851B,
	PINMUX_GPIO3_WL_PRI_FUNCEN_8851B,
	PINMUX_GPIO3_DBG_GNT_BT_PINEN_8851B,
	PINMUX_GPIO3_WL_JTAG_TMS_PINEN_8851B,
	PINMUX_GPIO3_WL_JTAG_TMS_FUNCEN_8851B,
	PINMUX_GPIO3_WL_JTAG_TMS_SECEN_8851B,
	PINMUX_GPIO3_WL_JTAG_TMS_DIS_8851B,
	PINMUX_GPIO3_WL_RFE_CTRL3_PINEN_8851B,
	PINMUX_GPIO3_DBG3_PINEN_8851B,
	PINMUX_GPIO3_SW_IO3_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO4_8851B[] = {
	PINMUX_GPIO4_BT_GPIO4_PINEN_8851B,
	PINMUX_GPIO4_WL_FLASH0_PINEN_8851B,
	PINMUX_GPIO4_WL_FLASH0_FUNCEN_8851B,
	PINMUX_GPIO4_BT_FLASH0_PINEN_8851B,
	PINMUX_GPIO4_BT_FLASH0_SECEN_8851B,
	PINMUX_GPIO4_BT_FLASH0_FUNCEN_8851B,
	PINMUX_GPIO4_WL_JTAG_TRST_PINEN_8851B,
	PINMUX_GPIO4_WL_JTAG_TRST_FUNCEN_8851B,
	PINMUX_GPIO4_WL_JTAG_TRST_SECEN_8851B,
	PINMUX_GPIO4_WL_RFE_CTRL4_PINEN_8851B,
	PINMUX_GPIO4_DBG4_PINEN_8851B,
	PINMUX_GPIO4_SW_IO04_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO5_8851B[] = {
	PINMUX_GPIO5_BT_GPIO5_PINEN_8851B,
	PINMUX_GPIO5_WL_FLASH1_PINEN_8851B,
	PINMUX_GPIO5_WL_FLASH1_FUNCEN_8851B,
	PINMUX_GPIO5_BT_FLASH1_PINEN_8851B,
	PINMUX_GPIO5_BT_FLASH1_FUNCEN_8851B,
	PINMUX_GPIO5_BT_FLASH1_SECEN_8851B,
	PINMUX_GPIO5_MAILBOX_I2C_INT_PINEN_8851B,
	PINMUX_GPIO5_MAILBOX_I2C_INT_FUNCEN_8851B,
	PINMUX_GPIO5_XTAL_CLK_PINEN_8851B,
	PINMUX_GPIO5_XTAL_CLK_FUNCEN_8851B,
	PINMUX_GPIO5_WL_JTAG_TDI_PINEN_8851B,
	PINMUX_GPIO5_WL_JTAG_TDI_FUNCEN_8851B,
	PINMUX_GPIO5_WL_JTAG_TDI_SECEN_8851B,
	PINMUX_GPIO5_WL_RFE_CTRL5_PINEN_8851B,
	PINMUX_GPIO5_DBG5_PINEN_8851B,
	PINMUX_GPIO5_SW_IO5_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO6_8851B[] = {
	PINMUX_GPIO6_BT_PD_PINEN_8851B,
	PINMUX_GPIO6_BT_PD_FUNCEN_8851B,
	PINMUX_GPIO6_BT_GPIO6_8851B,
	PINMUX_GPIO6_WL_FLASH2_PINEN_8851B,
	PINMUX_GPIO6_WL_FLASH2_FUNCEN_8851B,
	PINMUX_GPIO6_BT_FLASH2_PINEN_8851B,
	PINMUX_GPIO6_BT_FLASH2_SECEN_8851B,
	PINMUX_GPIO6_BT_FLASH2_FUNCEN_8851B,
	PINMUX_GPIO6_LTE_UART_IN_PINEN_8851B,
	PINMUX_GPIO6_LTE_UART_IN_FUNCEN_8851B,
	PINMUX_GPIO6_LTE_3W_RX_IN_PINEN_8851B,
	PINMUX_GPIO6_LTE_3W_RX_IN_FUNCEN_8851B,
	PINMUX_GPIO6_MAILBOX_I2C_SD_PINEN_8851B,
	PINMUX_GPIO6_MAILBOX_I2C_SD_FUNCEN_8851B,
	PINMUX_GPIO6_DBG_GNT_WL_PINEN_8851B,
	PINMUX_GPIO6_WL_JTAG_TDO_PINEN_8851B,
	PINMUX_GPIO6_WL_JTAG_TDO_FUNCEN_8851B,
	PINMUX_GPIO6_WL_JTAG_TDO_SECEN_8851B,
	PINMUX_GPIO6_WL_RFE6_8851B,
	PINMUX_GPIO6_DBG_GPIO6_8851B,
	PINMUX_GPIO6_SW_IO6_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO7_8851B[] = {
	PINMUX_GPIO7_BT_PD_PINEN_8851B,
	PINMUX_GPIO7_BT_PD_FUNCEN_8851B,
	PINMUX_GPIO7_BT_GPIO7_PINEN_8851B,
	PINMUX_GPIO7_WL_FLASH3_PINEN_8851B,
	PINMUX_GPIO7_WL_FLASH3_FUNCEN_8851B,
	PINMUX_GPIO7_BT_FLASH3_PINEN_8851B,
	PINMUX_GPIO7_BT_FLASH3_FUNCEN_8851B,
	PINMUX_GPIO7_BT_FLASH3_SECEN_8851B,
	PINMUX_GPIO7_LTE_UART_OUT_PINEN_8851B,
	PINMUX_GPIO7_LTE_UART_OUT_FUNCEN_8851B,
	PINMUX_GPIO7_LTE_3W_TX_IN_PINEN_8851B,
	PINMUX_GPIO7_LTE_3W_TX_IN_FUNCEN_8851B,
	PINMUX_GPIO7_MAILBOX_I2C_CLK_PINEN_8851B,
	PINMUX_GPIO7_MAILBOX_I2C_CLK_FUNCEN_8851B,
	PINMUX_GPIO7_DBG_GNT_BT_PINEN_8851B,
	PINMUX_GPIO7_WL_JTAG_TMS_PINEN_8851B,
	PINMUX_GPIO7_WL_JTAG_TMS_FUNCEN_8851B,
	PINMUX_GPIO7_WL_JTAG_TMS_SECEN_8851B,
	PINMUX_GPIO7_WL_RFE_CTRL7_PINEN_8851B,
	PINMUX_GPIO7_DBG7_PINEN_8851B,
	PINMUX_GPIO7_SW_IO7_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO8_8851B[] = {
	PINMUX_GPIO8_EXT_WOL_PINEN_8851B,
	PINMUX_GPIO8_EXT_WOL_FUNCEN_8851B,
	PINMUX_GPIO8_BT_GPIO8_8851B,
	PINMUX_GPIO8_SIC_CLK_PINEN_8851B,
	PINMUX_GPIO8_SIC_CLK_FUNCEN_8851B,
	PINMUX_GPIO8_SIC_CLK_SECEN_8851B,
	PINMUX_GPIO8_MAILBOX_I2C_INT_PINEN_8851B,
	PINMUX_GPIO8_MAILBOX_I2C_INT_FUNCEN_8851B,
	PINMUX_GPIO8_WL_LED_PINEN_8851B,
	PINMUX_GPIO8_WL_LED_FUNCEN_8851B,
	PINMUX_GPIO8_WL_UART_TX_PINEN_8851B,
	PINMUX_GPIO8_WL_UART_TX_FUNCEN_8851B,
	PINMUX_GPIO8_WL_UART_TX_SECEN_8851B,
	PINMUX_GPIO8_WL_RFE8_8851B,
	PINMUX_GPIO8_DBG_GPIO8_8851B,
	PINMUX_GPIO8_SW_IO8_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO9_8851B[] = {
	PINMUX_GPIO9_WL_PD_PINEN_8851B,
	PINMUX_GPIO9_BT_GPIO9_PINEN_8851B,
	PINMUX_GPIO9_MAILBOX_I2C_SD_PINEN_8851B,
	PINMUX_GPIO9_MAILBOX_I2C_SD_FUNCEN_8851B,
	PINMUX_GPIO9_DBG_GNT_WL_PINEN_8851B,
	PINMUX_GPIO9_WL_UART_TX_PINEN_8851B,
	PINMUX_GPIO9_WL_UART_TX_FUNCEN_8851B,
	PINMUX_GPIO9_WL_UART_TX_SECEN_8851B,
	PINMUX_GPIO9_WL_RFE_CTRL9_PINEN_8851B,
	PINMUX_GPIO9_DBG9_PINEN_8851B,
	PINMUX_GPIO9_SW_IO9_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO10_8851B[] = {
	PINMUX_GPIO10_BT_GPIO10_8851B,
	PINMUX_GPIO10_WL_SDIO_INT_PINEN_8851B,
	PINMUX_GPIO10_WL_UART_RX_PINEN_8851B,
	PINMUX_GPIO10_WL_UART_RX_FUNCEN_8851B,
	PINMUX_GPIO10_WL_UART_RX_SECEN_8851B,
	PINMUX_GPIO10_WL_UART_RX_DIS_8851B,
	PINMUX_GPIO10_WL_UART_RX_DIS_2_8851B,
	PINMUX_GPIO10_WL_RFE10_8851B,
	PINMUX_GPIO10_DBG_GPIO10_8851B,
	PINMUX_GPIO10_SW_IO10_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO11_8851B[] = {
	PINMUX_GPIO11_BT_PD_PINEN_8851B,
	PINMUX_GPIO11_BT_GPIO11_PINEN_8851B,
	PINMUX_GPIO11_MAILBOX_I2C_CLK_PINEN_8851B,
	PINMUX_GPIO11_MAILBOX_I2C_CLK_FUNCEN_8851B,
	PINMUX_GPIO11_DBG_GNT_BT_PINEN_8851B,
	PINMUX_GPIO11_WL_UART_RX_PINEN_8851B,
	PINMUX_GPIO11_WL_UART_RX_SECEN_8851B,
	PINMUX_GPIO11_WL_UART_RX_FUNCEN_8851B,
	PINMUX_GPIO11_WL_UART_RX_DIS_8851B,
	PINMUX_GPIO11_WL_UART_RX_DIS_2_8851B,
	PINMUX_GPIO11_WL_RFE_CTRL11_PINEN_8851B,
	PINMUX_GPIO11_DBG11_PINEN_8851B,
	PINMUX_GPIO11_SW_IO11_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO12_8851B[] = {
	PINMUX_GPIO12_BT_GPIO12_8851B,
	PINMUX_GPIO12_LTE_3W_PRI_OUT_PINEN_8851B,
	PINMUX_GPIO12_LTE_3W_PRI_OUT_FUNCEN_8851B,
	PINMUX_GPIO12_WL_ACT_PINEN_8851B,
	PINMUX_GPIO12_WL_ACT_FUNCEN_8851B,
	PINMUX_GPIO12_BT_ACT_PINEN_8851B,
	PINMUX_GPIO12_BT_ACT_FUNCEN_8851B,
	PINMUX_GPIO12_BT_ACT_DIS_8851B,
	PINMUX_GPIO12_DBG_GNT_WL_PINEN_8851B,
	PINMUX_GPIO12_SOUT_PINEN_8851B,
	PINMUX_GPIO12_SOUT_SECEN_8851B,
	PINMUX_GPIO12_SOUT_FUNCEN_8851B,
	PINMUX_GPIO12_WL_RFE12_8851B,
	PINMUX_GPIO12_DBG_GPIO12_8851B,
	PINMUX_GPIO12_SW_IO12_PINEN_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO13_8851B[] = {
	PINMUX_GPIO13_BT_GPIO13_8851B,
	PINMUX_GPIO13_WL_PTA_BT_CLK_PINEN_8851B,
	PINMUX_GPIO13_WL_PTA_BT_CLK_FUNCEN_8851B,
	PINMUX_GPIO13_BT_PTA_WL_CLK_PINEN_8851B,
	PINMUX_GPIO13_BT_PTA_WL_CLK_FUNCEN_8851B,
	PINMUX_GPIO13_WL_UART_TX_PINEN_8851B,
	PINMUX_GPIO13_WL_UART_TX_SECEN_8851B,
	PINMUX_GPIO13_WL_UART_TX_FUNCEN_8851B,
	PINMUX_GPIO13_WL_RFE_CTRL13_8851B,
	PINMUX_GPIO13_DBG13_8851B,
	PINMUX_GPIO13_SW_IO13_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO14_8851B[] = {
	PINMUX_GPIO14_BT_GPIO14_8851B,
	PINMUX_GPIO14_WL_PTA_BT_STA_PINEN_8851B,
	PINMUX_GPIO14_WL_PTA_BT_STA_FUNCEN_8851B,
	PINMUX_GPIO14_BT_PTA_WL_STA_PINEN_8851B,
	PINMUX_GPIO14_BT_PTA_WL_STA_FUNCEN_8851B,
	PINMUX_GPIO14_WL_JTAG_CLK_PINEN_8851B,
	PINMUX_GPIO14_WL_JTAG_CLK_FUNCEN_8851B,
	PINMUX_GPIO14_WL_JTAG_CLK_SECEN_8851B,
	PINMUX_GPIO14_WL_RFE_CTRL13_8851B,
	PINMUX_GPIO14_DBG14_8851B,
	PINMUX_GPIO14_SW_IO14_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO15_8851B[] = {
	PINMUX_GPIO15_WL_PD_PINEN_8851B,
	PINMUX_GPIO15_BT_GPIO15_8851B,
	PINMUX_GPIO15_WL_PTA_BT_CLK_PINEN_8851B,
	PINMUX_GPIO15_WL_PTA_BT_CLK_FUNCEN_8851B,
	PINMUX_GPIO15_BT_PTA_WL_CLK_PINEN_8851B,
	PINMUX_GPIO15_BT_PTA_WL_CLK_FUNCEN_8851B,
	PINMUX_GPIO15_WL_UART_TX_PINEN_8851B,
	PINMUX_GPIO15_WL_UART_TX_SECEN_8851B,
	PINMUX_GPIO15_WL_UART_TX_FUNCEN_8851B,
	PINMUX_GPIO15_WL_RFE_CTRL15_8851B,
	PINMUX_GPIO15_DBG15_8851B,
	PINMUX_GPIO15_SW_IO15_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO16_8851B[] = {
	PINMUX_GPIO16_WL_RFE_CTRL16_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list PIN_LIST_GPIO17_8851B[] = {
	PINMUX_GPIO17_WL_RFE_CTRL17_8851B,
	PINMUX_GPIO_END_8851B,
};

static const struct mac_ax_pin_list *PIN_LIST_8851B[] = {
	PIN_LIST_GPIO0_8851B, /* gpio0 */
	PIN_LIST_GPIO1_8851B, /* gpio1 */
	PIN_LIST_GPIO2_8851B, /* gpio2 */
	PIN_LIST_GPIO3_8851B, /* gpio3 */
	PIN_LIST_GPIO4_8851B, /* gpio4 */
	PIN_LIST_GPIO5_8851B, /* gpio5 */
	PIN_LIST_GPIO6_8851B, /* gpio6 */
	PIN_LIST_GPIO7_8851B, /* gpio7 */
	PIN_LIST_GPIO8_8851B, /* gpio8 */
	PIN_LIST_GPIO9_8851B, /* gpio9 */
	PIN_LIST_GPIO10_8851B, /* gpio10 */
	PIN_LIST_GPIO11_8851B, /* gpio11 */
	PIN_LIST_GPIO12_8851B, /* gpio12 */
	PIN_LIST_GPIO13_8851B, /* gpio13 */
	PIN_LIST_GPIO14_8851B, /* gpio14 */
	PIN_LIST_GPIO15_8851B, /* gpio15 */
	PIN_LIST_GPIO16_8851B, /* gpio16 */
	PIN_LIST_GPIO17_8851B, /* gpio17 */
};

static u32 mac_get_pinmux_list_8851b(struct mac_ax_adapter *adapter,
				     enum mac_ax_gpio_func func,
				     const struct mac_ax_pinmux_list **list,
				     u32 *list_size, u32 *gpio_id)
{
	switch (func) {
	case MAC_AX_GPIO_SW_IO_0:
		*list = PINMUX_LIST_GPIO0_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO0_8851B);
		*gpio_id = MAC_AX_GPIO0;
		break;
	case MAC_AX_GPIO_SW_IO_1:
		*list = PINMUX_LIST_GPIO1_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO1_8851B);
		*gpio_id = MAC_AX_GPIO1;
		break;
	case MAC_AX_GPIO_SW_IO_2:
		*list = PINMUX_LIST_GPIO2_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO2_8851B);
		*gpio_id = MAC_AX_GPIO2;
		break;
	case MAC_AX_GPIO_SW_IO_3:
		*list = PINMUX_LIST_GPIO3_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO3_8851B);
		*gpio_id = MAC_AX_GPIO3;
		break;
	case MAC_AX_GPIO_SW_IO_4:
		*list = PINMUX_LIST_GPIO4_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO4_8851B);
		*gpio_id = MAC_AX_GPIO4;
		break;
	case MAC_AX_GPIO_SW_IO_5:
	case MAC_AX_GPIO_UART_TX_GPIO5:
		*list = PINMUX_LIST_GPIO5_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO5_8851B);
		*gpio_id = MAC_AX_GPIO5;
		break;
	case MAC_AX_GPIO_SW_IO_6:
	case MAC_AX_GPIO_UART_RX_GPIO6:
		*list = PINMUX_LIST_GPIO6_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO6_8851B);
		*gpio_id = MAC_AX_GPIO6;
		break;
	case MAC_AX_GPIO_SW_IO_7:
	case MAC_AX_GPIO_UART_TX_GPIO7:
		*list = PINMUX_LIST_GPIO7_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO7_8851B);
		*gpio_id = MAC_AX_GPIO7;
		break;
	case MAC_AX_GPIO_SW_IO_8:
	case MAC_AX_GPIO_UART_TX_GPIO8:
		*list = PINMUX_LIST_GPIO8_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO8_8851B);
		*gpio_id = MAC_AX_GPIO8;
		break;
	case MAC_AX_GPIO_SW_IO_9:
		*list = PINMUX_LIST_GPIO9_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO9_8851B);
		*gpio_id = MAC_AX_GPIO9;
		break;
	case MAC_AX_GPIO_SW_IO_10:
		*list = PINMUX_LIST_GPIO10_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO10_8851B);
		*gpio_id = MAC_AX_GPIO10;
		break;
	case MAC_AX_GPIO_SW_IO_11:
		*list = PINMUX_LIST_GPIO11_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO11_8851B);
		*gpio_id = MAC_AX_GPIO11;
		break;
	case MAC_AX_GPIO_SW_IO_12:
		*list = PINMUX_LIST_GPIO12_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO12_8851B);
		*gpio_id = MAC_AX_GPIO12;
		break;
	case MAC_AX_GPIO_SW_IO_13:
		*list = PINMUX_LIST_GPIO13_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO13_8851B);
		*gpio_id = MAC_AX_GPIO13;
		break;
	case MAC_AX_GPIO_SW_IO_14:
	case MAC_AX_GPIO_UART_RX_GPIO14:
		*list = PINMUX_LIST_GPIO14_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO14_8851B);
		*gpio_id = MAC_AX_GPIO14;
		break;
	case MAC_AX_GPIO_SW_IO_15:
		*list = PINMUX_LIST_GPIO15_8851B;
		*list_size = ARRAY_SIZE(PINMUX_LIST_GPIO15_8851B);
		*gpio_id = MAC_AX_GPIO15;
		break;
	default:
		return MACNOITEM;
	}

	return MACSUCCESS;
}

u32 mac_pinmux_set_func_8851b(struct mac_ax_adapter *adapter,
			      enum mac_ax_gpio_func func)
{
	const struct mac_ax_pinmux_list *list = NULL;
	u32 ret;
	u32 gpio_id, list_size;

	ret = mac_pinmux_status(adapter, func);
	if (ret)
		goto END;

	ret = mac_get_pinmux_list_8851b(adapter, func, &list,
					&list_size, &gpio_id);
	if (ret)
		goto END;

	ret = mac_pinmux_switch(adapter, func, list, list_size, gpio_id);
	if (ret)
		goto END;

	ret = mac_pinmux_record(adapter, func, 1);

END:
	return ret;
}

u32 mac_gpio_init_8851b(struct mac_ax_adapter *adapter)
{
	bool is_fpga = false;

#if MAC_AX_FEATURE_HV
	if (adapter->env == HV_AX_FPGA)
		is_fpga = true;
	else
		is_fpga = false;
#elif MAC_AX_FPGA_TEST
	is_fpga = true;
#endif
	if (is_fpga) {
		adapter->gpio_info.uart_tx_gpio = 13;
		adapter->gpio_info.uart_rx_gpio = 11;
	} else {
		adapter->gpio_info.uart_tx_gpio = 12;
		adapter->gpio_info.uart_rx_gpio = 11;
	}
	adapter->gpio_info.gpio_max = MAC_AX_GPIO_MAX_8851B;
	return MACSUCCESS;
}

u32 mac_set_gpio_func_8851b(struct mac_ax_adapter *adapter,
			    enum rtw_mac_gfunc func, s8 gpio_cfg)
{
	const struct mac_ax_pin_list *list;
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u8 val, is_set = 0;
	u8 gpio;

	if (gpio_cfg < MAC_AX_GPIO_MIN || gpio_cfg > RTW_MAC_GPIO_MAX) {
		PLTFM_MSG_ERR("The GPIO number is wrong: %d", gpio_cfg);
		return MACGPIONUM;
	}

	gpio = gpio_cfg;
	list = PIN_LIST_8851B[gpio];
	while (list && list->func != RTW_MAC_GPIO_INVALID) {
		if (list->func == func) {
			val = MAC_REG_R8(list->offset);
			val = (val & ~(list->msk)) | list->value;
			MAC_REG_W8(list->offset, val);
			is_set++;
		}
		list++;
	}

	if (!is_set) {
		PLTFM_MSG_ERR("The GPIO function is NOT available in %d", gpio);
		return MACNOITEM;
	}

	return MACSUCCESS;
}

u32 mac_get_gpio_status_8851b(struct mac_ax_adapter *adapter,
			      enum rtw_mac_gfunc *func, u8 gpio)
{
	if (gpio > RTW_MAC_GPIO_MAX) {
		PLTFM_MSG_ERR("The GPIO number is wrong: %d", gpio);
		return MACGPIONUM;
	}

	*func = mac_get_gpio_status(adapter, PIN_LIST_8851B[gpio]);

	return MACSUCCESS;
}
#endif /* #if MAC_AX_8851B_SUPPORT */
