/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#include "ser_8851e.h"
#include "../../type.h"
#if MAC_AX_8851E_SUPPORT

static u32 scheduler_imr_enable_8851e(struct mac_ax_adapter *adapter, u8 band)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32, reg;

	reg = band == MAC_AX_BAND_0 ?
	      R_AX_SCHEDULE_ERR_IMR : R_AX_SCHEDULE_ERR_IMR_C1;
	val32 = MAC_REG_R32(reg);
	val32 &= ~(B_AX_SORT_NON_IDLE_ERR_INT_EN |
		   B_AX_FSM_TIMEOUT_ERR_INT_EN);
	val32 |= ((B_AX_SORT_NON_IDLE_ERR_INT_EN &
		   SCHEDULER_SORT_NON_IDLE_52C_ERR_SER_EN) |
		  (B_AX_FSM_TIMEOUT_ERR_INT_EN &
		   SCHEDULER_FSM_TIMEOUT_52C_ERR_SER_EN));
	MAC_REG_W32(reg, val32);

	return 0;
}

static u32 ptcl_imr_enable_8851e(struct mac_ax_adapter *adapter, u8 band)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32, reg;

	reg = band == MAC_AX_BAND_0 ?
	      R_AX_PTCL_IMR0 : R_AX_PTCL_IMR0_C1;
	val32 = MAC_REG_R32(reg);
	val32 &= ~(B_AX_FSM1_TIMEOUT_ERR_INT_EN |
		   B_AX_FSM_TIMEOUT_ERR_INT_EN);
	val32 |= ((B_AX_FSM1_TIMEOUT_ERR_INT_EN &
		   PTCL_FSM1_TIMEOUT_SER_EN) |
		  (B_AX_FSM_TIMEOUT_ERR_INT_EN &
		   PTCL_FSM_TIMEOUT_SER_EN));
	MAC_REG_W32(reg, val32);

	return 0;
}

static u32 cdma_imr_enable_8851e(struct mac_ax_adapter *adapter, u8 band)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32, reg, reg_2;

	reg = band == MAC_AX_BAND_0 ?
	      R_AX_RX_ERR_FLAG_IMR : R_AX_RX_ERR_FLAG_IMR_C1;
	reg_2 = band == MAC_AX_BAND_0 ?
	      R_AX_TX_ERR_FLAG_IMR : R_AX_TX_ERR_FLAG_IMR_C1;
	/* CMAC DMA RX IMR Setting */
	val32 = MAC_REG_R32(reg);
	val32 &= ~(B_AX_RXSTS_ENQUE_ORDER_ERR_MSK |
		   B_AX_RXDATA_ENQUE_ORDER_ERR_MSK |
		   B_AX_RX_CSI_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RXSTS_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU7_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU6_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU5_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU4_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU3_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU2_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU1_ZERO_LEN_ERR_MSK |
		   B_AX_RX_RU0_ZERO_LEN_ERR_MSK |
		   B_AX_RX_F2PCMD_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_TXRPT_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_CSI_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RXSTS_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU7_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU6_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU5_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU4_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU3_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU2_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU1_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_RU0_FSM_HANG_MSK_ERR_MSK |
		   B_AX_RX_GET_NULL_PKT_ERR_MSK);
	val32 |= ((B_AX_RXSTS_ENQUE_ORDER_ERR_MSK &
		   CMAC_DMA_RXSTS_ENQUE_ORDER_SER_EN) |
		  (B_AX_RXDATA_ENQUE_ORDER_ERR_MSK &
		   CMAC_DMA_RXDATA_ENQUE_ORDER_SER_EN) |
		  (B_AX_RX_CSI_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_CSI_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RXSTS_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RXSTS_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU7_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU7_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU6_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU6_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU5_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU5_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU4_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU4_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU3_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU3_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU2_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU2_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU1_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU1_ZERO_LEN_SER_EN) |
		  (B_AX_RX_RU0_ZERO_LEN_ERR_MSK &
		   CMAC_DMA_RX_RU0_ZERO_LEN_SER_EN) |
		  (B_AX_RX_F2PCMD_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_F2PCMD_FSM_HANG_SER_EN) |
		  (B_AX_RX_TXRPT_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_TXRPT_FSM_HANG_SER_EN) |
		  (B_AX_RX_CSI_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_CSI_FSM_HANG_SER_EN) |
		  (B_AX_RX_RXSTS_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RXSTS_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU7_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU7_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU6_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU6_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU5_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU5_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU4_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU4_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU3_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU3_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU2_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU2_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU1_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU1_FSM_HANG_SER_EN) |
		  (B_AX_RX_RU0_FSM_HANG_MSK_ERR_MSK &
		   CMAC_DMA_RX_RU0_FSM_HANG_SER_EN) |
		  (B_AX_RX_GET_NULL_PKT_ERR_MSK &
		   CMAC_DMA_RX_GET_NULL_PKT_SER_EN));
	MAC_REG_W32(reg, val32);
	/* CMAC DMA TX IMR Setting */
	val32 = MAC_REG_R32(reg_2);
	val32 &= ~(B_AX_TX_WD_PLD_ID_FSM_HANG_ERR_MSK |
		   B_AX_TX_CSI_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU7_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU6_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU5_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU4_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU3_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU2_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU1_FSM_HANG_ERR_MSK |
		   B_AX_TX_RU0_FSM_HANG_ERR_MSK);
	val32 |= ((B_AX_TX_WD_PLD_ID_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_WD_PLD_ID_FSM_HANG_SER_EN) |
		  (B_AX_TX_CSI_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_CSI_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU7_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU7_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU6_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU6_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU5_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU5_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU4_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU4_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU3_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU3_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU2_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU2_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU1_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU1_FSM_HANG_SER_EN) |
		  (B_AX_TX_RU0_FSM_HANG_ERR_MSK &
		   CMAC_DMA_TX_RU0_FSM_HANG_SER_EN));
	MAC_REG_W32(reg_2, val32);

	return 0;
}

static u32 phy_intf_imr_enable_8851e(struct mac_ax_adapter *adapter, u8 band)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;
	u32 reg;

	reg = band == MAC_AX_BAND_0 ?
	      R_AX_PHYINFO_ERR_IMR_V1 : R_AX_PHYINFO_ERR_IMR_V1_C1;
	val32 = MAC_REG_R32(reg);
	val32 &= ~(B_AX_PHY_TXON_TIMEOUT_EN |
		   B_AX_CCK_CCA_TIMEOUT_EN |
		   B_AX_OFDM_CCA_TIMEOUT_EN |
		   B_AX_DATA_ON_TIMEOUT_EN |
		   B_AX_STS_ON_TIMEOUT_EN |
		   B_AX_CSI_ON_TIMEOUT_EN);

	val32 |= ((B_AX_PHY_TXON_TIMEOUT_EN &
		   PHY_INTF_PHY_TXON_TIMEOUT_SER_EN) |
		  (B_AX_CCK_CCA_TIMEOUT_EN &
		   PHY_INTF_CCK_CCA_TIMEOUT_SER_EN) |
		  (B_AX_OFDM_CCA_TIMEOUT_EN &
		   PHY_INTF_OFDM_CCA_TIMEOUT_SER_EN) |
		  (B_AX_DATA_ON_TIMEOUT_EN &
		   PHY_INTF_DATA_ON_TIMEOUT_SER_EN) |
		  (B_AX_STS_ON_TIMEOUT_EN &
		   PHY_INTF_STS_ON_TIMEOUT_SER_EN) |
		  (B_AX_CSI_ON_TIMEOUT_EN &
		   PHY_INTF_CSI_ON_TIMEOUT_SER_EN));
	MAC_REG_W32(reg, val32);

	return 0;
}

static u32 rmac_imr_enable_8851e(struct mac_ax_adapter *adapter, u8 band)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32, reg;

	reg = band == MAC_AX_BAND_0 ?
	      R_AX_RX_ERR_IMR : R_AX_RX_ERR_IMR_C1;
	val32 = MAC_REG_R32(reg);
	val32 &= ~(B_AX_RX_ERR_CCA_TO_MSK |
		   B_AX_RX_ERR_DATA_TO_MSK |
		   B_AX_RX_ERR_DMA_TO_MSK |
		   B_AX_CCA_ASSERT_TO_MSK |
		   B_AX_DATAON_ASSERT_TO_MSK |
		   B_AX_CSI_DATAON_ASSERT_TO_MSK |
		   B_AX_RX_ERR_ACT_TO_MSK |
		   B_AX_RX_ERR_CSI_ACT_TO_MSK |
		   B_AX_RX_ERR_STS_ACT_TO_MSK |
		   B_AX_RX_ERR_TRIG_ACT_TO_MSK);

	val32 |= ((B_AX_RX_ERR_CCA_TO_MSK &
		   RMAC_RX_ERR_CCA_TO_SER_EN) |
		  (B_AX_RX_ERR_DATA_TO_MSK &
		   RMAC_RX_ERR_DATA_TO_SER_EN) |
		  (B_AX_RX_ERR_DMA_TO_MSK &
		   RMAC_RX_ERR_DMA_TO_SER_EN) |
		  (B_AX_CCA_ASSERT_TO_MSK &
		   RMAC_CCA_ASSERT_TO_SER_EN) |
		  (B_AX_DATAON_ASSERT_TO_MSK &
		   RMAC_DATAON_ASSERT_TO_SER_EN) |
		  (B_AX_CSI_DATAON_ASSERT_TO_MSK &
		   RMAC_CSI_DATAON_ASSERT_TO_SER_EN) |
		  (B_AX_RX_ERR_ACT_TO_MSK &
		   RMAC_RX_ERR_ACT_TO_SER_EN) |
		  (B_AX_RX_ERR_CSI_ACT_TO_MSK &
		   RMAC_RX_ERR_CSI_ACT_TO_SER_EN) |
		  (B_AX_RX_ERR_STS_ACT_TO_MSK &
		   RMAC_RX_ERR_STS_ACT_TO_SER_EN) |
		  (B_AX_RX_ERR_TRIG_ACT_TO_MSK &
		   RMAC_RX_ERR_TRIG_ACT_TO_SER_EN));
	MAC_REG_W32(reg, val32);

#if MAC_AX_USB_SUPPORT
	if (!chk_patch_snd_fifofull_err(adapter))
		return MACSUCCESS;

	if (get_usb_mode(adapter) == MAC_AX_USB2) {
		reg = band == MAC_AX_BAND_0 ?
		      R_AX_RX_ERR_IMR : R_AX_RX_ERR_IMR_C1;
		val32 = MAC_REG_R32(reg);
		val32 &= ~(B_AX_RX_ERR_CSI_ACT_TO_MSK);
		MAC_REG_W32(reg, val32);
	}
#endif
	return 0;
}

static u32 tmac_imr_enable_8851e(struct mac_ax_adapter *adapter, u8 band)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32, reg;

	reg = band == MAC_AX_BAND_0 ? R_AX_TRXPTCL_ERROR_INDICA_MASK :
	      R_AX_TRXPTCL_ERROR_INDICA_MASK_C1;
	val32 = MAC_REG_R32(reg);
	val32 &= ~(B_AX_TMAC_MACTX |
		   B_AX_TMAC_TXCTL |
		   B_AX_TMAC_RESP |
		   B_AX_TMAC_TXPLCP |
		   B_AX_TMAC_HWSIGB_GEN |
		   B_AX_TMAC_RXTB |
		   B_AX_TMAC_MIMO_CTRL |
		   B_AX_RMAC_CSI |
		   B_AX_RMAC_FTM);

	val32 |= ((B_AX_TMAC_MACTX &
		   TMAC_MACTX_SER_EN) |
		  (B_AX_TMAC_TXCTL &
		   TMAC_TXCTL_SER_EN) |
		  (B_AX_TMAC_RESP &
		   TMAC_RESP_SER_EN) |
		  (B_AX_TMAC_TXPLCP &
		   TMAC_TXPLCP_SER_EN) |
		  (B_AX_TMAC_HWSIGB_GEN &
		   TMAC_HWSIGB_GEN_SER_EN) |
		  (B_AX_TMAC_RXTB &
		   TMAC_RXTB_SER_EN) |
		  (B_AX_TMAC_MIMO_CTRL &
		   TMAC_MIMO_CTRL_SER_EN) |
		  (B_AX_RMAC_CSI &
		   TMAC_RMAC_CSI_SER_EN) |
		  (B_AX_RMAC_FTM &
		   TMAC_RMAC_FTM_SER_EN));
	MAC_REG_W32(reg, val32);
	return 0;
}

static u32 wdrls_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_WDRLS_ERR_IMR);
	val32 &= ~(B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN |
		   B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN |
		   B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN |
		   B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN |
		   B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN |
		   B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN |
		   B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN |
		   B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN |
		   B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN);

	val32 |= ((B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN &
		   B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_SER_EN) |
		  (B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN &
		   B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_SER_EN) |
		  (B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN &
		   B_AX_WDRLS_CTL_FRZTO_ERR_SER_EN) |
		  (B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN &
		   B_AX_WDRLS_PLEBREQ_TO_ERR_SER_EN) |
		  (B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN &
		   B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_SER_EN) |
		  (B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN &
		   B_AX_WDRLS_RPT0_AGGNUM0_ERR_SER_EN) |
		  (B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN &
		   B_AX_WDRLS_RPT0_FRZTO_ERR_SER_EN) |
		  (B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN &
		   B_AX_WDRLS_RPT1_AGGNUM0_ERR_SER_EN) |
		  (B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN &
		   B_AX_WDRLS_RPT1_FRZTO_ERR_SER_EN));
	MAC_REG_W32(R_AX_WDRLS_ERR_IMR, val32);
	return 0;
}

static u32 wsec_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_SEC_ERROR_FLAG_IMR);
	val32 &= ~(B_AX_TX_HANG_IMR |
		   B_AX_RX_HANG_IMR);

	val32 |= ((B_AX_TX_HANG_IMR &
		   B_AX_TX_HANG_SER_EN) |
		  (B_AX_RX_HANG_IMR &
		   B_AX_RX_HANG_SER_EN));

	MAC_REG_W32(R_AX_SEC_ERROR_FLAG_IMR, val32);
	return 0;
}

static u32 mpdu_trx_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	/* MDPU Processor TX */
	val32 = MAC_REG_R32(R_AX_MPDU_TX_ERR_IMR);
	val32 &= ~(B_AX_TX_GET_ERRPKTID_INT_EN |
		   B_AX_TX_NXT_ERRPKTID_INT_EN |
		   B_AX_TX_MPDU_SIZE_ZERO_INT_EN |
		   B_AX_TX_OFFSET_ERR_INT_EN |
		   B_AX_TX_HDR3_SIZE_ERR_INT_EN |
		   B_AX_TX_ETH_TYPE_ERR_EN |
		   B_AX_TX_LLC_PRE_ERR_EN |
		   B_AX_TX_NW_TYPE_ERR_EN |
		   B_AX_TX_KSRCH_ERR_EN);

	val32 |= ((B_AX_TX_GET_ERRPKTID_INT_EN &
		   B_AX_TX_GET_ERRPKTID_SER_EN) |
		  (B_AX_TX_NXT_ERRPKTID_INT_EN &
		   B_AX_TX_NXT_ERRPKTID_SER_EN) |
		  (B_AX_TX_MPDU_SIZE_ZERO_INT_EN &
		   B_AX_TX_MPDU_SIZE_ZERO_SER_EN) |
		  (B_AX_TX_OFFSET_ERR_INT_EN &
		   B_AX_TX_OFFSET_ERR_SER_EN) |
		  (B_AX_TX_HDR3_SIZE_ERR_INT_EN &
		   B_AX_TX_HDR3_SIZE_ERR_SER_EN) |
		  (B_AX_TX_ETH_TYPE_ERR_EN &
		   B_AX_TX_ETH_TYPE_SER_EN) |
		  (B_AX_TX_LLC_PRE_ERR_EN &
		   B_AX_TX_LLC_PRE_SER_EN) |
		  (B_AX_TX_NW_TYPE_ERR_EN &
		   B_AX_TX_NW_TYPE_SER_EN) |
		  (B_AX_TX_KSRCH_ERR_EN &
		   B_AX_TX_KSRCH_SER_EN));
	MAC_REG_W32(R_AX_MPDU_TX_ERR_IMR, val32);

	/* MDPU Processor RX */
	val32 = MAC_REG_R32(R_AX_MPDU_RX_ERR_IMR);
	val32 &= ~(B_AX_GETPKTID_ERR_INT_EN |
		   B_AX_MHDRLEN_ERR_INT_EN |
		   B_AX_RPT_ERR_INT_EN);

	val32 |= ((B_AX_GETPKTID_ERR_INT_EN &
		   B_AX_GETPKTID_ERR_SER_EN) |
		  (B_AX_MHDRLEN_ERR_INT_EN &
		   B_AX_MHDRLEN_ERR_SER_EN) |
		  (B_AX_RPT_ERR_INT_EN &
		   B_AX_RPT_ERR_SER_EN));
	MAC_REG_W32(R_AX_MPDU_RX_ERR_IMR, val32);
	return 0;
}

static u32 sta_sch_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	/* MDPU Processor TX */
	val32 = MAC_REG_R32(R_AX_STA_SCHEDULER_ERR_IMR);
	val32 &= ~(B_AX_SEARCH_HANG_TIMEOUT_INT_EN |
		   B_AX_RPT_HANG_TIMEOUT_INT_EN |
		   B_AX_PLE_B_PKTID_ERR_INT_EN);

	val32 |= ((B_AX_SEARCH_HANG_TIMEOUT_INT_EN &
		   B_AX_SEARCH_HANG_TIMEOUT_SER_EN) |
		  (B_AX_RPT_HANG_TIMEOUT_INT_EN &
		   B_AX_RPT_HANG_TIMEOUT_SER_EN) |
		  (B_AX_PLE_B_PKTID_ERR_INT_EN &
		   B_AX_PLE_B_PKTID_ERR_SER_EN));
	MAC_REG_W32(R_AX_STA_SCHEDULER_ERR_IMR, val32);
	return 0;
}

static u32 txpktctl_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_TXPKTCTL_B0_ERRFLAG_IMR);
	val32 &= ~(B_AX_B0_IMR_ERR_USRCTL_REINIT |
		   B_AX_B0_IMR_ERR_USRCTL_NOINIT |
		   B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD |
		   B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN |
		   B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR |
		   B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE |
		   B_AX_B0_IMR_ERR_CMDPSR_FRZTO |
		   B_AX_B0_IMR_ERR_CMDPSR_TBLSZ |
		   B_AX_B0_IMR_ERR_MPDUINFO_RECFG |
		   B_AX_B0_IMR_ERR_MPDUIF_DATAERR |
		   B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR |
		   B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG);

	val32 |= ((B_AX_B0_IMR_ERR_USRCTL_REINIT &
		   B_AX_B0_IMR_ERR_USRCTL_REINIT_SER_EN) |
		  (B_AX_B0_IMR_ERR_USRCTL_NOINIT &
		   B_AX_B0_IMR_ERR_USRCTL_NOINIT_SER_EN) |
		  (B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD &
		   B_AX_B0_IMR_ERR_USRCTL_RDNRLSCMD_SER_EN) |
		  (B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN &
		   B_AX_B0_IMR_ERR_USRCTL_RLSBMPLEN_SER_EN) |
		  (B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR &
		   B_AX_B0_IMR_ERR_CMDPSR_1STCMDERR_SER_EN) |
		  (B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE &
		   B_AX_B0_IMR_ERR_CMDPSR_CMDTYPE_SER_EN) |
		  (B_AX_B0_IMR_ERR_CMDPSR_FRZTO &
		   B_AX_B0_IMR_ERR_CMDPSR_FRZTO_SER_EN) |
		  (B_AX_B0_IMR_ERR_CMDPSR_TBLSZ &
		   B_AX_B0_IMR_ERR_CMDPSR_TBLSZ_SER_EN) |
		  (B_AX_B0_IMR_ERR_MPDUINFO_RECFG &
		   B_AX_B0_IMR_ERR_MPDUINFO_RECFG_SER_EN) |
		  (B_AX_B0_IMR_ERR_MPDUIF_DATAERR &
		   B_AX_B0_IMR_ERR_MPDUIF_DATAERR_SER_EN) |
		  (B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR &
		   B_AX_B0_IMR_ERR_PRELD_RLSPKTSZERR_SER_EN) |
		  (B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG &
		   B_AX_B0_IMR_ERR_PRELD_ENTNUMCFG_SER_EN));
	MAC_REG_W32(R_AX_TXPKTCTL_B0_ERRFLAG_IMR, val32);

	val32 = MAC_REG_R32(R_AX_TXPKTCTL_B1_ERRFLAG_IMR);
	val32 &= ~(B_AX_B1_IMR_ERR_USRCTL_REINIT |
		   B_AX_B1_IMR_ERR_USRCTL_NOINIT |
		   B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD |
		   B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN |
		   B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR |
		   B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE |
		   B_AX_B1_IMR_ERR_CMDPSR_FRZTO |
		   B_AX_B1_IMR_ERR_CMDPSR_TBLSZ |
		   B_AX_B1_IMR_ERR_MPDUINFO_RECFG |
		   B_AX_B1_IMR_ERR_MPDUIF_DATAERR |
		   B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR |
		   B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG);

	val32 |= ((B_AX_B1_IMR_ERR_USRCTL_REINIT &
		   B_AX_B1_IMR_ERR_USRCTL_REINIT_SER_EN) |
		  (B_AX_B1_IMR_ERR_USRCTL_NOINIT &
		   B_AX_B1_IMR_ERR_USRCTL_NOINIT_SER_EN) |
		  (B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD &
		   B_AX_B1_IMR_ERR_USRCTL_RDNRLSCMD_SER_EN) |
		  (B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN &
		   B_AX_B1_IMR_ERR_USRCTL_RLSBMPLEN_SER_EN) |
		  (B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR &
		   B_AX_B1_IMR_ERR_CMDPSR_1STCMDERR_SER_EN) |
		  (B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE &
		   B_AX_B1_IMR_ERR_CMDPSR_CMDTYPE_SER_EN) |
		  (B_AX_B1_IMR_ERR_CMDPSR_FRZTO &
		   B_AX_B1_IMR_ERR_CMDPSR_FRZTO_SER_EN) |
		  (B_AX_B1_IMR_ERR_CMDPSR_TBLSZ &
		   B_AX_B1_IMR_ERR_CMDPSR_TBLSZ_SER_EN) |
		  (B_AX_B1_IMR_ERR_MPDUINFO_RECFG &
		   B_AX_B1_IMR_ERR_MPDUINFO_RECFG_SER_EN) |
		  (B_AX_B1_IMR_ERR_MPDUIF_DATAERR &
		   B_AX_B1_IMR_ERR_MPDUIF_DATAERR_SER_EN) |
		  (B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR &
		   B_AX_B1_IMR_ERR_PRELD_RLSPKTSZERR_SER_EN) |
		  (B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG &
		   B_AX_B1_IMR_ERR_PRELD_ENTNUMCFG_SER_EN));
	MAC_REG_W32(R_AX_TXPKTCTL_B1_ERRFLAG_IMR, val32);
	return 0;
}

static u32 wde_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_WDE_ERR_IMR);
	val32 &= ~(B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN |
		   B_AX_WDE_BUFREQ_SIZE0_INT_EN |
		   B_AX_WDE_BUFREQ_SIZELMT_INT_EN |
		   B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN_V1 |
		   B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 |
		   B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 |
		   B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 |
		   B_AX_WDE_GETNPG_STRPG_ERR_INT_EN_V1 |
		   B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN_V1 |
		   B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN_V1 |
		   B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN |
		   B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN |
		   B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN |
		   B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN |
		   B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN |
		   B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN |
		   B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN |
		   B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN |
		   B_AX_WDE_DATCHN_ARBT_ERR_INT_EN |
		   B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN |
		   B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN |
		   B_AX_WDE_DATCHN_RRDY_ERR_INT_EN |
		   B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN |
		   B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN);

	val32 |= ((B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN &
		   B_AX_WDE_BUFREQ_QTAID_ERR_SER_EN) |
		  (B_AX_WDE_BUFREQ_SIZE0_INT_EN &
		   B_AX_WDE_BUFREQ_UNAVAL_ERR_SER_EN) |
		  (B_AX_WDE_BUFREQ_SIZELMT_INT_EN &
		   B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_SER_EN) |
		  (B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN_V1 &
		   B_AX_WDE_BUFRTN_SIZE_ERR_SER_EN) |
		  (B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 &
		   B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_SER_EN) |
		  (B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN_V1 &
		   B_AX_WDE_GETNPG_STRPG_ERR_SER_EN) |
		  (B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 &
		   B_AX_WDE_GETNPG_PGOFST_ERR_SER_EN) |
		  (B_AX_WDE_GETNPG_STRPG_ERR_INT_EN_V1 &
		   B_AX_WDE_BUFMGN_FRZTO_ERR_SER_EN) |
		  (B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN_V1 &
		   B_AX_WDE_QUE_CMDTYPE_ERR_SER_EN) |
		  (B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN_V1 &
		   B_AX_WDE_QUE_DSTQUEID_ERR_SER_EN) |
		  (B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN &
		   B_AX_WDE_QUE_SRCQUEID_ERR_SER_EN) |
		  (B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN &
		   B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_SER_EN) |
		  (B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN &
		   B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_SER_EN) |
		  (B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN &
		   B_AX_WDE_PREPKTLLT_AD_ERR_SER_EN) |
		  (B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN &
		   B_AX_WDE_NXTPKTLL_AD_ERR_SER_EN) |
		  (B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN &
		   B_AX_WDE_QUEMGN_FRZTO_ERR_SER_EN) |
		  (B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN &
		   B_AX_WDE_DATCHN_ARBT_ERR_SER_EN) |
		  (B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN &
		   B_AX_WDE_DATCHN_NULLPG_ERR_SER_EN) |
		  (B_AX_WDE_DATCHN_ARBT_ERR_INT_EN &
		   B_AX_WDE_PREPKTLLT_AD_ERR_SER_EN) |
		  (B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN &
		   B_AX_WDE_NXTPKTLL_AD_ERR_SER_EN) |
		  (B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN &
		   B_AX_WDE_QUEMGN_FRZTO_ERR_SER_EN) |
		  (B_AX_WDE_DATCHN_RRDY_ERR_INT_EN &
		   B_AX_WDE_DATCHN_ARBT_ERR_SER_EN) |
		  (B_AX_WDE_DATCHN_ADRERR_ERR_INT_EN &
		   B_AX_WDE_DATCHN_NULLPG_ERR_SER_EN) |
		  (B_AX_WDE_DATCHN_CAMREQ_ERR_INT_EN &
		   B_AX_WDE_DATCHN_FRZTO_ERR_SER_EN));
	MAC_REG_W32(R_AX_WDE_ERR_IMR, val32);
	return 0;
}

static u32 ple_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_PLE_ERR_IMR);
	val32 &= ~(B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN |
		   B_AX_PLE_BUFREQ_SIZE0_INT_EN |
		   B_AX_PLE_BUFREQ_SIZELMT_INT_EN |
		   B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 |
		   B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 |
		   B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 |
		   B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 |
		   B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 |
		   B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 |
		   B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 |
		   B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN |
		   B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN |
		   B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN |
		   B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN |
		   B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN |
		   B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN |
		   B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN |
		   B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN |
		   B_AX_PLE_DATCHN_ARBT_ERR_INT_EN |
		   B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN |
		   B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN |
		   B_AX_PLE_DATCHN_RRDY_ERR_INT_EN |
		   B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN |
		   B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN);

	val32 |= ((B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN &
		   B_AX_PLE_BUFREQ_QTAID_ERR_SER_EN) |
		  (B_AX_PLE_BUFREQ_SIZE0_INT_EN &
		   B_AX_PLE_BUFREQ_UNAVAL_ERR_SER_EN) |
		  (B_AX_PLE_BUFREQ_SIZELMT_INT_EN &
		   B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_SER_EN) |
		  (B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN_V1 &
		   B_AX_PLE_BUFRTN_SIZE_ERR_SER_EN) |
		  (B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN_V1 &
		   B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_SER_EN) |
		  (B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN_V1 &
		   B_AX_PLE_GETNPG_STRPG_ERR_SER_EN) |
		  (B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN_V1 &
		   B_AX_PLE_GETNPG_PGOFST_ERR_SER_EN) |
		  (B_AX_PLE_GETNPG_STRPG_ERR_INT_EN_V1 &
		   B_AX_PLE_BUFMGN_FRZTO_ERR_SER_EN) |
		  (B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN_V1 &
		   B_AX_PLE_QUE_CMDTYPE_ERR_SER_EN) |
		  (B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN_V1 &
		   B_AX_PLE_QUE_DSTQUEID_ERR_SER_EN) |
		  (B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN &
		   B_AX_PLE_QUE_SRCQUEID_ERR_SER_EN) |
		  (B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN &
		   B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_SER_EN) |
		  (B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN &
		   B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_SER_EN) |
		  (B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN &
		   B_AX_PLE_PREPKTLLT_AD_ERR_SER_EN) |
		  (B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN &
		   B_AX_PLE_NXTPKTLL_AD_ERR_SER_EN) |
		  (B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN &
		   B_AX_PLE_QUEMGN_FRZTO_ERR_SER_EN) |
		  (B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN &
		   B_AX_PLE_DATCHN_ARBT_ERR_SER_EN) |
		  (B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN &
		   B_AX_PLE_DATCHN_NULLPG_ERR_SER_EN) |
		  (B_AX_PLE_DATCHN_ARBT_ERR_INT_EN &
		   B_AX_PLE_PREPKTLLT_AD_ERR_SER_EN) |
		  (B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN &
		   B_AX_PLE_NXTPKTLL_AD_ERR_SER_EN) |
		  (B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN &
		   B_AX_PLE_QUEMGN_FRZTO_ERR_SER_EN) |
		  (B_AX_PLE_DATCHN_RRDY_ERR_INT_EN &
		   B_AX_PLE_DATCHN_ARBT_ERR_SER_EN) |
		  (B_AX_PLE_DATCHN_ADRERR_ERR_INT_EN &
		   B_AX_PLE_DATCHN_NULLPG_ERR_SER_EN) |
		  (B_AX_PLE_DATCHN_CAMREQ_ERR_INT_EN &
		   B_AX_PLE_DATCHN_FRZTO_ERR_SER_EN));
	MAC_REG_W32(R_AX_PLE_ERR_IMR, val32);
	return 0;
}

static u32 pktin_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_PKTIN_ERR_IMR);
	val32 &= ~(B_AX_PKTIN_GETPKTID_ERR_INT_EN);

	val32 |= ((B_AX_PKTIN_GETPKTID_ERR_INT_EN &
		   B_AX_GET_NULL_PKTID_ERR_SER_EN));
	MAC_REG_W32(R_AX_PKTIN_ERR_IMR, val32);
	return 0;
}

static u32 dispatcher_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_HOST_DISPATCHER_ERR_IMR);
	val32 &= ~(B_AX_HT_EP_CH_DIFF_ERR_INT_EN |
		   B_AX_HT_CH_ID_ERR_INT_EN |
		   B_AX_HT_PKT_FAIL_ERR_INT_EN |
		   B_AX_HT_PERMU_FF_OVERFLOW_ERR_INT_EN |
		   B_AX_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN |
		   B_AX_HT_PAYLOAD_OVER_ERR_INT_EN |
		   B_AX_HT_PAYLOAD_UNDER_ERR_INT_EN |
		   B_AX_HT_OFFSET_UNMATCH_ERR_INT_EN |
		   B_AX_HT_CHANNEL_DMA_ERR_INT_EN |
		   B_AX_HT_WD_CHKSUM_ERR_INT_EN |
		   B_AX_HT_PRE_SUB_ERR_INT_EN |
		   B_AX_HT_TXPKTSIZE_ERR_INT_EN |
		   B_AX_HT_CHKSUM_FSM_ERR_INT_EN |
		   B_AX_HT_WRFF_OVERFLOW_ERR_INT_EN |
		   B_AX_HT_WRFF_UNDERFLOW_ERR_INT_EN |
		   B_AX_HT_PLD_CMD_OVERFLOW_ERR_INT_EN |
		   B_AX_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN |
		   B_AX_HT_WD_LEN_OVER_ERR_INT_EN |
		   B_AX_HT_ADDR_INFO_LEN_ERR_INT_EN |
		   B_AX_HR_PLD_LEN_ZERO_ERR_INT_EN |
		   B_AX_HR_DMA_RD_CNT_DEQ_ERR_INT_EN |
		   B_AX_HR_AGG_CFG_ERR_INT_EN |
		   B_AX_HR_SHIFT_EN_ERR_INT_EN |
		   B_AX_HR_TOTAL_LEN_UNDER_ERR_INT_EN |
		   B_AX_HR_DMA_PROCESS_ERR_INT_EN |
		   B_AX_HR_SHIFT_DMA_CFG_ERR_INT_EN |
		   B_AX_HR_CHKSUM_FSM_ERR_INT_EN |
		   B_AX_HR_WRFF_OVERFLOW_ERR_INT_EN |
		   B_AX_HR_WRFF_UNDERFLOW_ERR_INT_EN);

	val32 |= ((B_AX_HT_EP_CH_DIFF_ERR_INT_EN &
		   B_AX_HT_EP_CH_DIFF_ERR_SER_EN) |
		  (B_AX_HT_CH_ID_ERR_INT_EN &
		   B_AX_HT_CH_ID_ERR_SER_EN) |
		  (B_AX_HT_PKT_FAIL_ERR_INT_EN &
		   B_AX_HT_PKT_FAIL_ERR_SER_EN) |
		  (B_AX_HT_PERMU_FF_OVERFLOW_ERR_INT_EN &
		   B_AX_HT_PERMU_FF_OVERFLOW_ERR_SER_EN) |
		  (B_AX_HT_PERMU_FF_UNDERFLOW_ERR_INT_EN &
		   B_AX_HT_PERMU_FF_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_HT_PAYLOAD_OVER_ERR_INT_EN &
		   B_AX_HT_PAYLOAD_OVER_ERR_SER_EN) |
		  (B_AX_HT_PAYLOAD_UNDER_ERR_INT_EN &
		   B_AX_HT_PAYLOAD_UNDER_ERR_SER_EN) |
		  (B_AX_HT_OFFSET_UNMATCH_ERR_INT_EN &
		   B_AX_HT_OFFSET_UNMATCH_ERR_SER_EN) |
		  (B_AX_HT_CHANNEL_DMA_ERR_INT_EN &
		   B_AX_HT_CHANNEL_DMA_ERR_SER_EN) |
		  (B_AX_HT_WD_CHKSUM_ERR_INT_EN &
		   B_AX_HT_WD_CHKSUM_ERR_SER_EN) |
		  (B_AX_HT_PRE_SUB_ERR_INT_EN &
		   B_AX_HT_PRE_SUB_ERR_SER_EN) |
		  (B_AX_HT_TXPKTSIZE_ERR_INT_EN &
		   B_AX_HT_TXPKTSIZE_ERR_SER_EN) |
		  (B_AX_HT_CHKSUM_FSM_ERR_INT_EN &
		   B_AX_HT_CHKSUM_FSM_ERR_SER_EN) |
		  (B_AX_HT_WRFF_OVERFLOW_ERR_INT_EN &
		   B_AX_HT_WRFF_OVERFLOW_ERR_SER_EN) |
		  (B_AX_HT_WRFF_UNDERFLOW_ERR_INT_EN &
		   B_AX_HT_WRFF_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_HT_PLD_CMD_OVERFLOW_ERR_INT_EN &
		   B_AX_HT_PLD_CMD_OVERFLOW_ERR_SER_EN) |
		  (B_AX_HT_PLD_CMD_UNDERFLOW_ERR_INT_EN &
		   B_AX_HT_PLD_CMD_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_HT_WD_LEN_OVER_ERR_INT_EN &
		   B_AX_HT_WD_LEN_OVER_ERR_SER_EN) |
		  (B_AX_HT_ADDR_INFO_LEN_ERR_INT_EN &
		   B_AX_HT_ADDR_INFO_LEN_ERR_SER_EN) |
		  (B_AX_HT_ILL_CH_ERR_INT_EN &
		   B_AX_HT_ILL_CH_ERR_SER_EN) |
		  (B_AX_HR_PLD_LEN_ZERO_ERR_INT_EN &
		   B_AX_HR_PLD_LEN_ZERO_ERR_SER_EN) |
		  (B_AX_HR_DMA_RD_CNT_DEQ_ERR_INT_EN &
		   B_AX_HR_DMA_RD_CNT_DEQ_ERR_SER_EN) |
		  (B_AX_HR_AGG_CFG_ERR_INT_EN &
		   B_AX_HR_AGG_CFG_ERR_SER_EN) |
		  (B_AX_HR_SHIFT_EN_ERR_INT_EN &
		   B_AX_HR_SHIFT_EN_ERR_SER_EN) |
		  (B_AX_HR_TOTAL_LEN_UNDER_ERR_INT_EN &
		   B_AX_HR_TOTAL_LEN_UNDER_ERR_SER_EN) |
		  (B_AX_HR_DMA_PROCESS_ERR_INT_EN &
		   B_AX_HR_DMA_PROCESS_ERR_SER_EN) |
		  (B_AX_HR_SHIFT_DMA_CFG_ERR_INT_EN &
		   B_AX_HR_SHIFT_DMA_CFG_ERR_SER_EN) |
		  (B_AX_HR_CHKSUM_FSM_ERR_INT_EN &
		   B_AX_HR_CHKSUM_FSM_ERR_SER_EN) |
		  (B_AX_HR_WRFF_OVERFLOW_ERR_INT_EN &
		   B_AX_HR_WRFF_OVERFLOW_ERR_SER_EN) |
		  (B_AX_HR_WRFF_UNDERFLOW_ERR_INT_EN &
		   B_AX_HR_WRFF_UNDERFLOW_ERR_SER_EN));
	MAC_REG_W32(R_AX_HOST_DISPATCHER_ERR_IMR, val32);

	val32 = MAC_REG_R32(R_AX_CPU_DISPATCHER_ERR_IMR);
	val32 &= ~(B_AX_CT_EP_CH_DIFF_ERR_INT_EN |
		   B_AX_CT_CH_ID_ERR_INT_EN |
		   B_AX_CT_PERMU_FF_OVERFLOW_ERR_INT_EN |
		   B_AX_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN |
		   B_AX_CT_PAYLOAD_OVER_ERR_INT_EN |
		   B_AX_CT_PAYLOAD_UNDER_ERR_INT_EN |
		   B_AX_CT_PAYLOAD_CHKSUM_ERR_INT_EN |
		   B_AX_CT_OFFSET_UNMATCH_ERR_INT_EN |
		   B_AX_CT_CHANNEL_DMA_ERR_INT_EN |
		   B_AX_CT_WD_CHKSUM_ERR_INT_EN |
		   B_AX_CT_PRE_SUB_ERR_INT_EN |
		   B_AX_CT_PLD_CMD_OVERFLOW_ERR_INT_EN |
		   B_AX_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN |
		   B_AX_CT_F2P_QSEL_ERR_INT_EN |
		   B_AX_CT_F2P_SEQ_ERR_INT_EN |
		   B_AX_CT_WD_LEN_OVER_ERR_INT_EN |
		   B_AX_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN |
		   B_AX_REUSE_FIFO_A_OVER_ERR_INT_EN |
		   B_AX_REUSE_FIFO_A_UNDER_ERR_INT_EN |
		   B_AX_REUSE_FIFO_B_OVER_ERR_INT_EN |
		   B_AX_REUSE_FIFO_B_UNDER_ERR_INT_EN |
		   B_AX_CR_SHIFT_EN_ERR_INT_EN |
		   B_AX_CR_TOTAL_LEN_UNDER_ERR_INT_EN |
		   B_AX_CR_DMA_PROCESS_ERR_INT_EN |
		   B_AX_CR_SHIFT_DMA_CFG_ERR_INT_EN |
		   B_AX_CR_WRFF_OVERFLOW_ERR_INT_EN |
		   B_AX_CR_WRFF_UNDERFLOW_ERR_INT_EN |
		   B_AX_CR_PLD_LEN_ERR_INT_EN);

	val32 |= ((B_AX_CT_EP_CH_DIFF_ERR_INT_EN &
		   B_AX_CT_EP_CH_DIFF_ERR_SER_EN) |
		  (B_AX_CT_CH_ID_ERR_INT_EN &
		   B_AX_CT_CH_ID_ERR_SER_EN) |
		  (B_AX_CT_PERMU_FF_OVERFLOW_ERR_INT_EN &
		   B_AX_CT_PERMU_FF_OVERFLOW_ERR_SER_EN) |
		  (B_AX_CT_PERMU_FF_UNDERFLOW_ERR_INT_EN &
		   B_AX_CT_PERMU_FF_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_CT_PAYLOAD_OVER_ERR_INT_EN &
		   B_AX_CT_PAYLOAD_OVER_ERR_SER_EN) |
		  (B_AX_CT_PAYLOAD_UNDER_ERR_INT_EN &
		   B_AX_CT_PAYLOAD_UNDER_ERR_SER_EN) |
		  (B_AX_CT_PAYLOAD_CHKSUM_ERR_INT_EN &
		   B_AX_CT_PAYLOAD_CHKSUM_ERR_SER_EN) |
		  (B_AX_CT_OFFSET_UNMATCH_ERR_INT_EN &
		   B_AX_CT_OFFSET_UNMATCH_ERR_SER_EN) |
		  (B_AX_CT_CHANNEL_DMA_ERR_INT_EN &
		   B_AX_CT_CHANNEL_DMA_ERR_SER_EN) |
		  (B_AX_CT_WD_CHKSUM_ERR_INT_EN &
		   B_AX_CT_WD_CHKSUM_ERR_SER_EN) |
		  (B_AX_CT_PRE_SUB_ERR_INT_EN &
		   B_AX_CT_PRE_SUB_ERR_SER_EN) |
		  (B_AX_CT_PLD_CMD_OVERFLOW_ERR_INT_EN &
		   B_AX_CT_PLD_CMD_OVERFLOW_ERR_SER_EN) |
		  (B_AX_CT_PLD_CMD_UNDERFLOW_ERR_INT_EN &
		   B_AX_CT_PLD_CMD_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_CT_F2P_QSEL_ERR_INT_EN &
		   B_AX_CT_F2P_QSEL_ERR_SER_EN) |
		  (B_AX_CT_F2P_SEQ_ERR_INT_EN &
		   B_AX_CT_F2P_SEQ_ERR_SER_EN) |
		  (B_AX_CT_WD_LEN_OVER_ERR_INT_EN &
		   B_AX_CT_WD_LEN_OVER_ERR_SER_EN) |
		  (B_AX_CT_ADDR_INFO_LEN_MISS_ERR_INT_EN &
		   B_AX_CT_ADDR_INFO_LEN_MISS_ERR_SER_EN) |
		  (B_AX_REUSE_FIFO_A_OVER_ERR_INT_EN &
		   B_AX_REUSE_FIFO_A_OVER_ERR_SER_EN) |
		  (B_AX_REUSE_FIFO_A_UNDER_ERR_INT_EN &
		   B_AX_REUSE_FIFO_A_UNDER_ERR_SER_EN) |
		  (B_AX_REUSE_FIFO_B_OVER_ERR_INT_EN &
		   B_AX_REUSE_FIFO_B_OVER_ERR_SER_EN) |
		  (B_AX_REUSE_FIFO_B_UNDER_ERR_INT_EN &
		   B_AX_REUSE_FIFO_B_UNDER_ERR_SER_EN) |
		  (B_AX_CR_SHIFT_EN_ERR_INT_EN &
		   B_AX_CR_SHIFT_EN_ERR_SER_EN) |
		  (B_AX_CR_TOTAL_LEN_UNDER_ERR_INT_EN &
		   B_AX_CR_TOTAL_LEN_UNDER_ERR_SER_EN) |
		  (B_AX_CR_DMA_PROCESS_ERR_INT_EN &
		   B_AX_CR_DMA_PROCESS_ERR_SER_EN) |
		  (B_AX_CR_SHIFT_DMA_CFG_ERR_INT_EN &
		   B_AX_CR_SHIFT_DMA_CFG_ERR_SER_EN) |
		  (B_AX_CR_WRFF_OVERFLOW_ERR_INT_EN &
		   B_AX_CR_WRFF_OVERFLOW_ERR_SER_EN) |
		  (B_AX_CR_WRFF_UNDERFLOW_ERR_INT_EN &
		   B_AX_CR_WRFF_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_CR_PLD_LEN_ERR_INT_EN &
		   B_AX_CR_PLD_LEN_ERR_SER_EN));
	MAC_REG_W32(R_AX_CPU_DISPATCHER_ERR_IMR, val32);

	val32 = MAC_REG_R32(R_AX_OTHER_DISPATCHER_ERR_IMR);
	val32 &= ~(B_AX_WDE_FLOW_CTRL_ERR_INT_EN |
		   B_AX_WDE_NULL_PKT_ERR_INT_EN |
		   B_AX_WDE_BURST_NUM_ERR_INT_EN |
		   B_AX_WDE_RESPONSE_ERR_INT_EN |
		   B_AX_WDE_OUTPUT_ERR_INT_EN |
		   B_AX_HDR_RX_TIMEOUT_ERR_INT_EN |
		   B_AX_HDR_DMA_TIMEOUT_ERR_INT_EN |
		   B_AX_PLE_FLOW_CTRL_ERR_INT_EN |
		   B_AX_PLE_NULL_PKT_ERR_INT_EN |
		   B_AX_PLE_BURST_NUM_ERR_INT_EN |
		   B_AX_PLE_RESPOSE_ERR_INT_EN |
		   B_AX_PLE_OUTPUT_ERR_INT_EN |
		   B_AX_CDR_RX_TIMEOUT_ERR_INT_EN |
		   B_AX_CDR_DMA_TIMEOUT_ERR_INT_EN |
		   B_AX_HDT_ADDR_INFO_LEN_ERR_INT_EN |
		   B_AX_CDT_ADDR_INFO_LEN_ERR_INT_EN |
		   B_AX_HDT_HCI_TIMEOUT_ERR_INT_EN |
		   B_AX_HDT_PTR_TIMEOUT_ERR_INT_EN |
		   B_AX_CDT_HCI_TIMEOUT_ERR_INT_EN |
		   B_AX_CDT_PTR_TIMEOUT_ERR_INT_EN |
		   B_AX_REUSE_PKT_CNT_ERR_INT_EN |
		   B_AX_REUSE_SIZE_ZERO_ERR_INT_EN |
		   B_AX_STF_CMD_OVERFLOW_ERR_INT_EN |
		   B_AX_STF_CMD_UNDERFLOW_ERR_INT_EN |
		   B_AX_STF_WRFF_OVERFLOW_ERR_INT_EN |
		   B_AX_STF_WRFF_UNDERFLOW_ERR_INT_EN |
		   B_AX_STF_OQT_OVERFLOW_ERR_INT_EN |
		   B_AX_STF_OQT_UNDERFLOW_ERR_INT_EN |
		   B_AX_REUSE_EN_ERR_INT_EN |
		   B_AX_REUSE_SIZE_ERR_INT_EN);

	val32 |= ((B_AX_WDE_FLOW_CTRL_ERR_INT_EN &
		   B_AX_WDE_FLOW_CTRL_ERR_SER_EN) |
		  (B_AX_WDE_NULL_PKT_ERR_INT_EN &
		   B_AX_WDE_NULL_PKT_ERR_SER_EN) |
		  (B_AX_WDE_BURST_NUM_ERR_INT_EN &
		   B_AX_WDE_BURST_NUM_ERR_SER_EN) |
		  (B_AX_WDE_RESPONSE_ERR_INT_EN &
		   B_AX_WDE_RESPONSE_ERR_SER_EN) |
		  (B_AX_WDE_OUTPUT_ERR_INT_EN &
		   B_AX_WDE_OUTPUT_ERR_SER_EN) |
		  (B_AX_HDR_RX_TIMEOUT_ERR_INT_EN &
		   B_AX_HDR_RX_TIMEOUT_ERR_SER_EN) |
		  (B_AX_HDR_DMA_TIMEOUT_ERR_INT_EN &
		   B_AX_HDR_DMA_TIMEOUT_ERR_SER_EN) |
		  (B_AX_PLE_FLOW_CTRL_ERR_INT_EN &
		   B_AX_PLE_FLOW_CTRL_ERR_SER_EN) |
		  (B_AX_PLE_NULL_PKT_ERR_INT_EN &
		   B_AX_PLE_NULL_PKT_ERR_SER_EN) |
		  (B_AX_PLE_BURST_NUM_ERR_INT_EN &
		   B_AX_PLE_BURST_NUM_ERR_SER_EN) |
		  (B_AX_PLE_RESPOSE_ERR_INT_EN &
		   B_AX_PLE_RESPOSE_ERR_SER_EN) |
		  (B_AX_PLE_OUTPUT_ERR_INT_EN &
		   B_AX_PLE_OUTPUT_ERR_SER_EN) |
		  (B_AX_CDR_RX_TIMEOUT_ERR_INT_EN &
		   B_AX_CDR_RX_TIMEOUT_ERR_SER_EN) |
		  (B_AX_CDR_DMA_TIMEOUT_ERR_INT_EN &
		   B_AX_CDR_DMA_TIMEOUT_ERR_SER_EN) |
		  (B_AX_HDT_ADDR_INFO_LEN_ERR_INT_EN &
		   B_AX_HDT_ADDR_INFO_LEN_ERR_SER_EN) |
		  (B_AX_CDT_ADDR_INFO_LEN_ERR_INT_EN &
		   B_AX_CDT_ADDR_INFO_LEN_ERR_SER_EN) |
		  (B_AX_HDT_HCI_TIMEOUT_ERR_INT_EN &
		   B_AX_HDT_HCI_TIMEOUT_ERR_SER_EN) |
		  (B_AX_HDT_PTR_TIMEOUT_ERR_INT_EN &
		   B_AX_HDT_PTR_TIMEOUT_ERR_SER_EN) |
		  (B_AX_CDT_HCI_TIMEOUT_ERR_INT_EN &
		   B_AX_CDT_HCI_TIMEOUT_ERR_SER_EN) |
		  (B_AX_CDT_PTR_TIMEOUT_ERR_INT_EN &
		   B_AX_CDT_PTR_TIMEOUT_ERR_SER_EN) |
		  (B_AX_REUSE_PKT_CNT_ERR_INT_EN &
		   B_AX_REUSE_PKT_CNT_ERR_SER_EN) |
		  (B_AX_REUSE_SIZE_ZERO_ERR_INT_EN &
		   B_AX_REUSE_SIZE_ZERO_ERR_SER_EN) |
		  (B_AX_STF_CMD_OVERFLOW_ERR_INT_EN &
		   B_AX_STF_CMD_OVERFLOW_ERR_SER_EN) |
		  (B_AX_STF_CMD_UNDERFLOW_ERR_INT_EN &
		   B_AX_STF_CMD_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_STF_WRFF_OVERFLOW_ERR_INT_EN &
		   B_AX_STF_WRFF_OVERFLOW_ERR_SER_EN) |
		  (B_AX_STF_WRFF_UNDERFLOW_ERR_INT_EN &
		   B_AX_STF_WRFF_UNDERFLOW_ERR_SER_EN) |
		  (B_AX_STF_OQT_OVERFLOW_ERR_INT_EN &
		   B_AX_STF_OQT_OVERFLOW_ERR_SER_EN) |
		  (B_AX_STF_OQT_UNDERFLOW_ERR_INT_EN &
		   B_AX_STF_OQT_OVERFLOW_ERR_SER_EN) |
		  (B_AX_REUSE_EN_ERR_INT_EN &
		   B_AX_REUSE_EN_ERR_SER_EN) |
		  (B_AX_REUSE_SIZE_ERR_INT_EN &
		   B_AX_REUSE_SIZE_ERR_SER_EN));
	MAC_REG_W32(R_AX_OTHER_DISPATCHER_ERR_IMR, val32);
	return 0;
}

static u32 cpuio_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_CPUIO_ERR_IMR);
	val32 &= ~(B_AX_WDEBUF_OP_ERR_INT_EN |
		   B_AX_WDEQUE_OP_ERR_INT_EN |
		   B_AX_PLEBUF_OP_ERR_INT_EN |
		   B_AX_PLEQUE_OP_ERR_INT_EN);

	val32 |= ((B_AX_WDEBUF_OP_ERR_INT_EN &
		   B_AX_WDEBUF_OP_ERR_SER_EN) |
		  (B_AX_WDEQUE_OP_ERR_INT_EN &
		   B_AX_WDEQUE_OP_ERR_SER_EN) |
		  (B_AX_PLEBUF_OP_ERR_INT_EN &
		   B_AX_PLEBUF_OP_ERR_SER_EN) |
		  (B_AX_PLEQUE_OP_ERR_INT_EN &
		   B_AX_PLEQUE_OP_ERR_SER_EN));
	MAC_REG_W32(R_AX_CPUIO_ERR_IMR, val32);
	return 0;
}

static u32 bbrpt_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_BBRPT_COM_ERR_IMR);
	val32 &= ~(B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN_V1 |
		   B_AX_BBRPT_COM_HANG_EN);

	val32 |= ((B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN_V1 &
		   B_AX_BBRPT_COM_NULL_PLPKTID_ERR_SER_EN) |
		  (B_AX_BBRPT_COM_HANG_EN &
		   B_AX_BBRPT_COM_HANG_EN_SER_EN));
	MAC_REG_W32(R_AX_BBRPT_COM_ERR_IMR, val32);

	val32 = MAC_REG_R32(R_AX_BBRPT_CHINFO_ERR_IMR);
	val32 &= ~(B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_OVF_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_NULL_ERR_INT_EN |
		   B_AX_BBPRT_CHIF_TO_ERR_INT_EN);

	val32 |= ((B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_BB_TO_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_OVF_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_OVF_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_BOVF_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_HDRL_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_LEFT1_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_LEFT2_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_NULL_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_NULL_V1_SER_EN) |
		  (B_AX_BBPRT_CHIF_TO_ERR_INT_EN &
		   B_AX_BBPRT_CHIF_TO_V1_SER_EN));
	MAC_REG_W32(R_AX_BBRPT_CHINFO_ERR_IMR, val32);

	val32 = MAC_REG_R32(R_AX_BBRPT_DFS_ERR_IMR);
	val32 &= ~(B_AX_BBRPT_DFS_TO_ERR_INT_EN);

	val32 |= ((B_AX_BBRPT_DFS_TO_ERR_INT_EN &
		   B_AX_BBRPT_DFS_TO_ERR_V1_SER_EN));
	MAC_REG_W32(R_AX_BBRPT_DFS_ERR_IMR, val32);

	val32 = MAC_REG_R32(R_AX_LA_ERRFLAG);
	val32 &= ~(B_AX_LA_IMR_DATA_LOSS_ERR);

	val32 |= ((B_AX_LA_IMR_DATA_LOSS_ERR &
		   B_AX_LA_ISR_DATA_LOSS_V1_SER_EN));
	MAC_REG_W32(R_AX_LA_ERRFLAG, val32);
	return 0;
}

static u32 haxidma_imr_enable_8851e(struct mac_ax_adapter *adapter)
{
	struct mac_ax_intf_ops *ops = adapter_to_intf_ops(adapter);
	u32 val32;

	val32 = MAC_REG_R32(R_AX_HAXI_IDCT_MSK);
	val32 &= ~(B_AX__TXBD_LEN0_ERR_IDCT_MSK |
		   B_AX__TXBD_4KBOUND_ERR_IDCT_MSK |
		   B_AX_RXMDA_STUCK_IDCT_MSK |
		   B_AX_TXMDA_STUCK_IDCT_MSK);

	val32 |= ((B_AX__TXBD_LEN0_ERR_IDCT_MSK &
		   B_AX__TXBD_LEN0_ERR_IDCT_SER_EN) |
		  (B_AX__TXBD_4KBOUND_ERR_IDCT_MSK &
		   B_AX__TXBD_4KBOUND_ERR_IDCT_SER_EN) |
		  (B_AX_RXMDA_STUCK_IDCT_MSK &
		   B_AX_RXMDA_STUCK_IDCT_SER_EN) |
		  (B_AX_TXMDA_STUCK_IDCT_MSK &
		   B_AX_TXMDA_STUCK_IDCT_SER_EN));
	MAC_REG_W32(R_AX_HAXI_IDCT_MSK, val32);

	if (adapter->hw_info->intf == MAC_AX_INTF_USB ||
	    adapter->hw_info->intf == MAC_AX_INTF_SDIO) {
		val32 = MAC_REG_R32(R_AX_HAXI_IDCT_MSK);
		val32 &= ~(B_AX_RXMDA_STUCK_IDCT_MSK);
		MAC_REG_W32(R_AX_HAXI_IDCT_MSK, val32);
	}

	/* 8851E H_AXIDMA SER IMR Patch code */
	if (chk_patch_haxidma_ind(adapter) == PATCH_DISABLE) {
		return MACSUCCESS;
	} else {
		if (adapter->hw_info->intf == MAC_AX_INTF_USB ||
		    adapter->hw_info->intf == MAC_AX_INTF_SDIO) {
			val32 = MAC_REG_R32(R_AX_HAXI_IDCT_MSK);

			val32 &= ~(B_AX__TXBD_LEN0_ERR_IDCT_MSK |
				   B_AX__TXBD_4KBOUND_ERR_IDCT_MSK);

			MAC_REG_W32(R_AX_HAXI_IDCT_MSK, val32);
		}
	}
	return MACSUCCESS;
}

u32 ser_imr_config_8851e(struct mac_ax_adapter *adapter, u8 band,
			 enum mac_ax_hwmod_sel sel)
{
	u32 ret;

	ret = check_mac_en(adapter, band, sel);
	if (ret) {
		PLTFM_MSG_ERR("MAC%d band%d is not ready\n", sel, band);
		return ret;
	}

	if (sel == MAC_AX_DMAC_SEL) {
		ret = wdrls_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]wdrls_imr_enable %d\n", ret);
			return ret;
		}

		ret = wsec_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]wsec_imr_enable %d\n", ret);
			return ret;
		}

		ret = mpdu_trx_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]mpdu_trx_imr_enable %d\n", ret);
			return ret;
		}

		ret = sta_sch_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]sta_sch_imr_enable %d\n", ret);
			return ret;
		}

		ret = txpktctl_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]txpktctl_imr_enable %d\n", ret);
			return ret;
		}

		ret = wde_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]wde_imr_enable %d\n", ret);
			return ret;
		}

		ret = ple_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]ple_imr_enable %d\n", ret);
			return ret;
		}

		ret = pktin_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]pktin_imr_enable %d\n", ret);
			return ret;
		}

		ret = dispatcher_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]dispatcher_imr_enable %d\n", ret);
			return ret;
		}

		ret = cpuio_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]cpuio_imr_enable %d\n", ret);
			return ret;
		}

		ret = bbrpt_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]bbrpt_imr_enable %d\n", ret);
			return ret;
		}

		ret = haxidma_imr_enable_8851e(adapter);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]haxidma_imr_enable %d\n", ret);
			return ret;
		}
	} else if (sel == MAC_AX_CMAC_SEL) {
		ret = scheduler_imr_enable_8851e(adapter, band);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]scheduler_imr_enable %d\n", ret);
			return ret;
		}

		ret = ptcl_imr_enable_8851e(adapter, band);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]ptcl_imr_enable %d\n", ret);
			return ret;
		}

		ret = cdma_imr_enable_8851e(adapter, band);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]cdma_imr_enable %d\n", ret);
			return ret;
		}

		ret = phy_intf_imr_enable_8851e(adapter, band);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]phy_intf_imr_enable %d\n", ret);
			return ret;
		}

		ret = rmac_imr_enable_8851e(adapter, band);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]rmac_imr_enable %d\n", ret);
			return ret;
		}

		ret = tmac_imr_enable_8851e(adapter, band);
		if (ret) {
			PLTFM_MSG_ERR("[ERR]tmac_imr_enable %d\n", ret);
			return ret;
		}
	} else {
		PLTFM_MSG_ERR("illegal sel %d\n", sel);
		return MACNOITEM;
	}
	return MACSUCCESS;
}
#endif /* #if MAC_AX_8851E_SUPPORT */
