/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.6*/
#ifndef _HALRF_HWIMG_RAW_DATA_8192XB_H
#define _HALRF_HWIMG_RAW_DATA_8192XB_H

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE


#if 0
/* Please put following enum definitions in appropriate header file. */
enum odm_pw_byrate_para_type {
	PW_BYRATE_PARA_NSS1,
	PW_BYRATE_PARA_NSS2,
	PW_BYRATE_PARA_OFFS = 0xF
};

enum odm_pw_byrate_rate_type {
	PW_BYRATE_RATE_11M_1M,
	PW_BYRATE_RATE_18M_6M,
	PW_BYRATE_RATE_54M_24M,
	PW_BYRATE_RATE_MCS3_0,
	PW_BYRATE_RATE_MCS7_4,
	PW_BYRATE_RATE_MCS11_8,
	PW_BYRATE_RATE_DCM4_0,
	PW_BYRATE_RATE_AllRate2_1,  /* CCK, OFDM, HT, VHT */
	PW_BYRATE_RATE_AllRate2_2,  /* HE_HEDCM */
	PW_BYRATE_RATE_AllRate5_1,  /* OFDM, HT, VHT, HE_HEDCM */
	PW_BYRATE_RATE_NULL = 0xF
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC,
	PW_LMT_REGU_ETSI,
	PW_LMT_REGU_MKK,
	PW_LMT_REGU_IC,
	PW_LMT_REGU_KCC,
	PW_LMT_REGU_ACMA,
	PW_LMT_REGU_CHILE,
	PW_LMT_REGU_UKRAINE,
	PW_LMT_REGU_MEXICO,
	PW_LMT_REGU_CN,
	PW_LMT_REGU_WW13,
	PW_LMT_REGU_NULL
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_2_4G,
	PW_LMT_BAND_5G,
	PW_LMT_BAND_NULL
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_20M,
	PW_LMT_BW_40M,
	PW_LMT_BW_80M,
	PW_LMT_BW_NULL
};

enum odm_pw_lmt_ru_bandwidth_type {
	PW_LMT_RU_BW_RU26,
	PW_LMT_RU_BW_RU52,
	PW_LMT_RU_BW_RU106,
	PW_LMT_RU_BW_NULL
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_CCK,
	PW_LMT_RS_OFDM,
	PW_LMT_RS_HT,
	PW_LMT_RS_VHT,
	PW_LMT_RS_HE,
	PW_LMT_RS_NULL
};

enum odm_pw_lmt_beamform_type {
	PW_LMT_BF,
	PW_LMT_NONBF,
	PW_LMT_NULL
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_1T,
	PW_LMT_PH_2T,
	PW_LMT_PH_3T,
	PW_LMT_PH_4T,
	PW_LMT_PH_NULL
};

struct halrf_tx_pw_lmt {
	u8			band:1;
	u8			bw:3;
	u8			rs:2;
	u8			ntx:2;
	u8			bf:3;
	u8			reg:5;
	u8			ch;
	s8			val;
};

struct halrf_tx_pw_lmt_ru {
	u8			band:1;
	u8			bw:2;
	u8			ntx:2;
	u8			rs:3;
	u8			reg;
	u8			ch;
	s8			val;
};
#endif


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8192xb_radioa[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0010001, 0x00000002,
		0xF0020001, 0x00000003,
		0xF0030001, 0x00000004,
		0xF0040001, 0x00000005,
		0x005, 0x00000000,
		0x000, 0x00030000,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x000, 0x00033C00,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x0FE, 0x00000000,
		0x011, 0x00014073,
		0x067, 0x00000070,
		0x059, 0x000A0000,
		0x066, 0x00000100,
		0x057, 0x0000D589,
		0x05A, 0x0007FFFF,
		0x0A4, 0x0006FF12,
		0x043, 0x00005000,
		0x0E1, 0x00000001,
		0x0DD, 0x000001A0,
		0x0CA, 0x00002000,
		0x0D3, 0x00000103,
		0x0B3, 0x0004EFE0,
		0x0B4, 0x0007C07E,
		0x0B5, 0x0003A701,
		0x0B6, 0x000581E0,
		0x0B7, 0x00001A0A,
		0x0BB, 0x000C7000,
		0x0ED, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x00000543,
		0x033, 0x00000001,
		0x03F, 0x00000542,
		0x033, 0x00000002,
		0x03F, 0x00000541,
		0x033, 0x00000003,
		0x03F, 0x00000521,
		0x033, 0x00000004,
		0x03F, 0x00000343,
		0x033, 0x00000005,
		0x03F, 0x00000342,
		0x033, 0x00000006,
		0x03F, 0x00000341,
		0x033, 0x00000007,
		0x03F, 0x00000321,
		0x033, 0x00000008,
		0x03F, 0x000005C3,
		0x033, 0x00000009,
		0x03F, 0x000005C2,
		0x033, 0x0000000A,
		0x03F, 0x000005C1,
		0x033, 0x0000000B,
		0x03F, 0x000005A1,
		0x033, 0x0000000C,
		0x03F, 0x000002C3,
		0x033, 0x0000000D,
		0x03F, 0x000002C2,
		0x033, 0x0000000E,
		0x03F, 0x000002C1,
		0x033, 0x0000000F,
		0x03F, 0x000002A1,
		0x0ED, 0x00000000,
		0x0ED, 0x00002000,
		0x033, 0x00000002,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000006,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x0ED, 0x00000000,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000004,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
		0x08F, 0x000D0F7A,
		0x0EF, 0x00080000,
		0x033, 0x00000008,
		0x03E, 0x000000C4,
		0x03F, 0x000034C0,
		0x033, 0x0000000A,
		0x03E, 0x000000C4,
		0x03F, 0x000035D0,
		0x033, 0x0000000B,
		0x03E, 0x000000C4,
		0x03F, 0x000035C8,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000006,
		0x03F, 0x00000700,
		0x033, 0x00000005,
		0x03F, 0x00090600,
		0x033, 0x00000004,
		0x03F, 0x000A3500,
		0x033, 0x00000003,
		0x03F, 0x000A3400,
		0x033, 0x00000002,
		0x03F, 0x00008B00,
		0x033, 0x00000001,
		0x03F, 0x00001B00,
		0x033, 0x00000000,
		0x03F, 0x00003A00,
		0x0EF, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
		0x03F, 0x00000017,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000000,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000001,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000002,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000003,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000004,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000005,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000006,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000008,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000009,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000000A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000000B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000000C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000000D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000000E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000010,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000011,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000012,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000013,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000014,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000015,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000016,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000020,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000021,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000022,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000023,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000024,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000025,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000026,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000028,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000029,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000002A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000002B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000002C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000002D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000002E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000030,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000031,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000032,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000033,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000034,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000035,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000036,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00004376,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03F, 0x00004376,
		0x033, 0x00000007,
		0x03F, 0x00004376,
		0x033, 0x00000008,
		0x03F, 0x00004376,
		0x033, 0x00000009,
		0x03F, 0x00004376,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004376,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004396,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004386,
	0xA0000000,	0x00000000,
		0x03F, 0x00004396,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x067, 0x00008072,
		0x0EF, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x00000ED5,
		0x033, 0x00000002,
		0x03F, 0x00000FC7,
		0x033, 0x00000003,
		0x03F, 0x00000783,
		0x033, 0x00000004,
		0x03F, 0x00000973,
		0x033, 0x00000005,
		0x03F, 0x00000762,
		0x033, 0x00000006,
		0x03F, 0x00000762,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023958,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000002B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026858,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x00026858,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x033, 0x0000003B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C758,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00023A58,
	0xA0000000,	0x00000000,
		0x03F, 0x0002C758,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x033, 0x00000004,
		0x03F, 0x00000001,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00003000,
		0x033, 0x00000001,
		0x03F, 0x00003001,
		0x033, 0x00000002,
		0x03F, 0x00003003,
		0x033, 0x00000003,
		0x03F, 0x00003007,
		0x033, 0x00000004,
		0x03F, 0x0000300F,
		0x033, 0x00000005,
		0x03F, 0x0000310F,
		0x033, 0x00000006,
		0x03F, 0x0000330F,
		0x033, 0x00000007,
		0x03F, 0x0000330F,
		0x033, 0x00000008,
		0x03F, 0x00003000,
		0x033, 0x00000009,
		0x03F, 0x00003001,
		0x033, 0x0000000A,
		0x03F, 0x00003003,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0xA0000000,	0x00000000,
		0x03F, 0x00003103,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0xA0000000,	0x00000000,
		0x03F, 0x00003307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0xA0000000,	0x00000000,
		0x03F, 0x00002307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EC, 0x00000100,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03D, 0x00000078,
		0x03E, 0x00080000,
		0x03F, 0x00000000,
		0x033, 0x00000005,
		0x03D, 0x0000007B,
		0x03E, 0x00020000,
		0x03F, 0x00000000,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x0000017F,
		0x033, 0x00000001,
		0x03F, 0x0000017F,
		0x033, 0x00000002,
		0x03F, 0x0000017F,
		0x033, 0x00000003,
		0x03F, 0x0000007F,
		0x033, 0x00000004,
		0x03F, 0x0000007F,
		0x033, 0x00000005,
		0x03F, 0x0000007F,
		0x033, 0x00000006,
		0x03F, 0x0000007F,
		0x033, 0x00000007,
		0x03F, 0x0000007F,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06F, 0x00077A18,
		0x06D, 0x00000C31,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03F, 0x000005FF,
		0x0EF, 0x00000000,
		0x005, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0xA0000000,	0x00000000,
		0x094, 0x000001FC,
	0xB0000000,	0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000080,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000081,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000082,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x00000083,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000080,
		0x1003F, 0x000001A9,
		0x10033, 0x00000081,
		0x1003F, 0x000001A3,
		0x10033, 0x00000082,
		0x1003F, 0x0000019D,
		0x10033, 0x00000083,
		0x1003F, 0x00000197,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x00000091,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000A1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000A2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000A3,
		0x1003F, 0x00000197,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000C1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000C2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000C3,
		0x1003F, 0x00000197,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000000,
		0x1003F, 0x000000F6,
		0x10033, 0x00000001,
		0x1003F, 0x000000F3,
		0x10033, 0x00000002,
		0x1003F, 0x000000F0,
		0x10033, 0x00000003,
		0x1003F, 0x000000ED,
		0x10033, 0x00000004,
		0x1003F, 0x000000EA,
		0x10033, 0x00000005,
		0x1003F, 0x000000E7,
		0x10033, 0x00000006,
		0x1003F, 0x000000A6,
		0x10033, 0x00000007,
		0x1003F, 0x000000A3,
		0x10033, 0x00000008,
		0x1003F, 0x00000063,
		0x10033, 0x00000009,
		0x1003F, 0x00000060,
		0x10033, 0x0000000A,
		0x1003F, 0x00000023,
		0x10033, 0x0000000B,
		0x1003F, 0x00000020,
		0x10033, 0x0000000C,
		0x1003F, 0x0000001D,
		0x10033, 0x0000000D,
		0x1003F, 0x0000001A,
		0x10033, 0x0000000E,
		0x1003F, 0x00000017,
		0x10033, 0x0000000F,
		0x1003F, 0x00000014,
		0x10033, 0x00000010,
		0x1003F, 0x00000011,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000000,
		0x1003F, 0x000001AF,
		0x10033, 0x00000001,
		0x1003F, 0x000001A9,
		0x10033, 0x00000002,
		0x1003F, 0x000001A3,
		0x10033, 0x00000003,
		0x1003F, 0x0000019D,
		0x10033, 0x00000004,
		0x1003F, 0x00000197,
		0x10033, 0x00000005,
		0x1003F, 0x0000015F,
		0x10033, 0x00000006,
		0x1003F, 0x00000159,
		0x10033, 0x00000007,
		0x1003F, 0x0000011F,
		0x10033, 0x00000008,
		0x1003F, 0x00000119,
		0x10033, 0x00000009,
		0x1003F, 0x000000DF,
		0x10033, 0x0000000A,
		0x1003F, 0x000000D9,
		0x10033, 0x0000000B,
		0x1003F, 0x0000009F,
		0x10033, 0x0000000C,
		0x1003F, 0x00000099,
		0x10033, 0x0000000D,
		0x1003F, 0x0000005F,
		0x10033, 0x0000000E,
		0x1003F, 0x00000059,
		0x10033, 0x0000000F,
		0x1003F, 0x0000001F,
		0x10033, 0x00000010,
		0x1003F, 0x00000019,
		0x10033, 0x00000011,
		0x1003F, 0x00000013,
		0x100EE, 0x00000000,
		0x10005, 0x00000001,
		0x09F, 0x00000019,

};


/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8192xb_radiob[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0010001, 0x00000002,
		0xF0020001, 0x00000003,
		0xF0030001, 0x00000004,
		0xF0040001, 0x00000005,
		0x005, 0x00000000,
		0x000, 0x00030000,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x000, 0x00033C00,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x0FE, 0x00000000,
		0x011, 0x00014073,
		0x067, 0x00000070,
		0x059, 0x000A0000,
		0x066, 0x00000100,
		0x05A, 0x0007F000,
		0x0A4, 0x0006FF12,
		0x043, 0x00005000,
		0x0E1, 0x00000001,
		0x0DD, 0x000001A0,
		0x0CA, 0x00002000,
		0x0D3, 0x00000103,
		0x0B3, 0x0004EFE0,
		0x0B4, 0x0007C03E,
		0x0B5, 0x0003A201,
		0x0BB, 0x000C7000,
		0x0ED, 0x00002000,
		0x033, 0x00000002,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000006,
		0x03D, 0x0004A883,
		0x03E, 0x00000000,
		0x03F, 0x00000001,
		0x0ED, 0x00000000,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000004,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
		0x08F, 0x000D0F7A,
		0x0EF, 0x00080000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D30,
	0xA0000000,	0x00000000,
		0x03E, 0x000000C4,
		0x03F, 0x000034C0,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D74,
	0xA0000000,	0x00000000,
		0x03E, 0x000000C4,
		0x03F, 0x000035D0,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000031,
		0x03F, 0x00000D72,
	0xA0000000,	0x00000000,
		0x03E, 0x000000C4,
		0x03F, 0x000035C8,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000007,
		0x03F, 0x00000707,
		0x033, 0x00000006,
		0x03F, 0x00000707,
		0x033, 0x00000005,
		0x03F, 0x00090607,
		0x033, 0x00000004,
		0x03F, 0x000A3507,
		0x033, 0x00000003,
		0x03F, 0x000A3407,
		0x033, 0x00000002,
		0x03F, 0x00008B07,
		0x033, 0x00000001,
		0x03F, 0x00001B07,
		0x033, 0x00000000,
		0x03F, 0x00003A07,
		0x033, 0x00000017,
		0x03F, 0x00000705,
		0x033, 0x00000016,
		0x03F, 0x00000705,
		0x033, 0x00000015,
		0x03F, 0x00090605,
		0x033, 0x00000014,
		0x03F, 0x000A3505,
		0x033, 0x00000013,
		0x03F, 0x000A3405,
		0x033, 0x00000012,
		0x03F, 0x00008B05,
		0x033, 0x00000011,
		0x03F, 0x00001B05,
		0x033, 0x00000010,
		0x03F, 0x00003A05,
		0x0EF, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0xA0000000,	0x00000000,
		0x03F, 0x00000005,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000015,
	0xA0000000,	0x00000000,
		0x03F, 0x00000017,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000005,
	0xA0000000,	0x00000000,
		0x03F, 0x00000007,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000000,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000001,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000002,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000003,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000004,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000005,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000006,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000008,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000009,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000000A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000000B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000000C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000000D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000000E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000010,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000011,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000012,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000013,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000014,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000015,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000016,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000020,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000021,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000022,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000023,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000024,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000025,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000026,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000028,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000029,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x0000002A,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x0000002B,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x0000002C,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x0000002D,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x0000002E,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x033, 0x00000030,
		0x03E, 0x00004FC0,
		0x03F, 0x00000087,
		0x033, 0x00000031,
		0x03E, 0x000046C0,
		0x03F, 0x00000087,
		0x033, 0x00000032,
		0x03E, 0x00004240,
		0x03F, 0x00000087,
		0x033, 0x00000033,
		0x03E, 0x00008010,
		0x03F, 0x00000147,
		0x033, 0x00000034,
		0x03E, 0x0000A048,
		0x03F, 0x0000004F,
		0x033, 0x00000035,
		0x03E, 0x0000A030,
		0x03F, 0x0000005F,
		0x033, 0x00000036,
		0x03E, 0x0000A000,
		0x03F, 0x0000009F,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00004346,
		0x033, 0x00000001,
		0x03F, 0x00004346,
		0x033, 0x00000002,
		0x03F, 0x00004346,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03F, 0x00004346,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004317,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004376,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000043A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00004346,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004347,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004366,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00004346,
	0xA0000000,	0x00000000,
		0x03F, 0x00004366,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03F, 0x00004386,
		0x033, 0x00000024,
		0x03F, 0x00004386,
		0x033, 0x00000025,
		0x03F, 0x00004386,
		0x033, 0x00000026,
		0x03F, 0x00004386,
		0x033, 0x00000027,
		0x03F, 0x00004386,
		0x0EF, 0x00000000,
		0x067, 0x00008072,
		0x0EF, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x00000ED5,
		0x033, 0x00000002,
		0x03F, 0x00000FC5,
		0x033, 0x00000003,
		0x03F, 0x00000A93,
		0x033, 0x00000004,
		0x03F, 0x00000973,
		0x033, 0x00000005,
		0x03F, 0x00000761,
		0x033, 0x00000006,
		0x03F, 0x00000761,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022758,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020758,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026558,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000002B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00026458,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022658,
	0xA0000000,	0x00000000,
		0x03F, 0x00026458,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00022858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x033, 0x0000003B,
		0x03E, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00027558,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00020858,
	0xA0000000,	0x00000000,
		0x03F, 0x00027558,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x033, 0x00000004,
		0x03F, 0x00000001,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00003000,
		0x033, 0x00000001,
		0x03F, 0x00003001,
		0x033, 0x00000002,
		0x03F, 0x00003003,
		0x033, 0x00000003,
		0x03F, 0x00003007,
		0x033, 0x00000004,
		0x03F, 0x0000300F,
		0x033, 0x00000005,
		0x03F, 0x0000310F,
		0x033, 0x00000006,
		0x03F, 0x0000330F,
		0x033, 0x00000007,
		0x03F, 0x0000330F,
		0x033, 0x00000008,
		0x03F, 0x00003000,
		0x033, 0x00000009,
		0x03F, 0x00003001,
		0x033, 0x0000000A,
		0x03F, 0x00003003,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003007,
	0xA0000000,	0x00000000,
		0x03F, 0x00003103,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003107,
	0xA0000000,	0x00000000,
		0x03F, 0x00003307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00003307,
	0xA0000000,	0x00000000,
		0x03F, 0x00002307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00001307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000307,
	0xA0000000,	0x00000000,
		0x03F, 0x00000307,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000003,
		0x033, 0x00000002,
		0x03F, 0x00000005,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000100,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EC, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EC, 0x00000100,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03D, 0x00000078,
		0x03E, 0x00080000,
		0x03F, 0x00000000,
		0x033, 0x00000005,
		0x03D, 0x0000007B,
		0x03E, 0x00020000,
		0x03F, 0x00000000,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x0000013F,
		0x033, 0x00000003,
		0x03F, 0x000000FB,
		0x033, 0x00000004,
		0x03F, 0x000000FB,
		0x033, 0x00000005,
		0x03F, 0x000000FB,
		0x033, 0x00000006,
		0x03F, 0x000000FB,
		0x033, 0x00000007,
		0x03F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x000001FF,
		0x033, 0x00000001,
		0x03F, 0x000001FF,
		0x033, 0x00000002,
		0x03F, 0x000001F7,
		0x033, 0x00000003,
		0x03F, 0x000000FF,
		0x033, 0x00000004,
		0x03F, 0x000000FF,
		0x033, 0x00000005,
		0x03F, 0x000000FF,
		0x033, 0x00000006,
		0x03F, 0x000000FF,
		0x033, 0x00000007,
		0x03F, 0x000000FF,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x0000017F,
		0x033, 0x00000001,
		0x03F, 0x0000017F,
		0x033, 0x00000002,
		0x03F, 0x0000017F,
		0x033, 0x00000003,
		0x03F, 0x0000007F,
		0x033, 0x00000004,
		0x03F, 0x0000007F,
		0x033, 0x00000005,
		0x03F, 0x0000007F,
		0x033, 0x00000006,
		0x03F, 0x0000007F,
		0x033, 0x00000007,
		0x03F, 0x0000007F,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06F, 0x00077A18,
		0x06D, 0x00000C31,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03F, 0x000005FF,
		0x0EF, 0x00000000,
		0x005, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x094, 0x000000FC,
	0xA0000000,	0x00000000,
		0x094, 0x000001FC,
	0xB0000000,	0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000080,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000081,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000082,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x00000083,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000FB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C2,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F5,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000F0,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C3,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000F2,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000ED,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EF,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000EA,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000EC,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000E7,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000AB,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A6,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000A8,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000A3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000068,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000063,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000065,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000060,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000002B,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000026,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000028,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000023,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000025,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000020,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000022,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000001A,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000017,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000014,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000080,
		0x1003F, 0x000001A9,
		0x10033, 0x00000081,
		0x1003F, 0x000001A3,
		0x10033, 0x00000082,
		0x1003F, 0x0000019D,
		0x10033, 0x00000083,
		0x1003F, 0x00000197,
		0x10033, 0x00000084,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x00000085,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000086,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x00000087,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x00000088,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x00000089,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x0000008F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x00000090,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x00000091,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000A1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000A2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000A3,
		0x1003F, 0x00000197,
		0x10033, 0x000000A4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000A9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000B1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C0,
		0x1003F, 0x000001A9,
		0x10033, 0x000000C1,
		0x1003F, 0x000001A3,
		0x10033, 0x000000C2,
		0x1003F, 0x0000019D,
		0x10033, 0x000000C3,
		0x1003F, 0x00000197,
		0x10033, 0x000000C4,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000158,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000191,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C5,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000011F,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000018B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000119,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000014D,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000010B,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C8,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000DF,
	0xB0000000,	0x00000000,
		0x10033, 0x000000C9,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000009F,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D9,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CA,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000099,
	0xA0000000,	0x00000000,
		0x1003F, 0x000000D3,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CB,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000005F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000099,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000059,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000093,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CD,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000001F,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000059,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000019,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000053,
	0xB0000000,	0x00000000,
		0x10033, 0x000000CF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000013,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000019,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D0,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xA0000000,	0x00000000,
		0x1003F, 0x00000013,
	0xB0000000,	0x00000000,
		0x10033, 0x000000D1,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x1003F, 0x00000007,
	0xA0000000,	0x00000000,
		0x1003F, 0x0000000D,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10033, 0x00000000,
		0x1003F, 0x000000F6,
		0x10033, 0x00000001,
		0x1003F, 0x000000F3,
		0x10033, 0x00000002,
		0x1003F, 0x000000F0,
		0x10033, 0x00000003,
		0x1003F, 0x000000ED,
		0x10033, 0x00000004,
		0x1003F, 0x000000EA,
		0x10033, 0x00000005,
		0x1003F, 0x000000E7,
		0x10033, 0x00000006,
		0x1003F, 0x000000A6,
		0x10033, 0x00000007,
		0x1003F, 0x000000A3,
		0x10033, 0x00000008,
		0x1003F, 0x00000063,
		0x10033, 0x00000009,
		0x1003F, 0x00000060,
		0x10033, 0x0000000A,
		0x1003F, 0x00000023,
		0x10033, 0x0000000B,
		0x1003F, 0x00000020,
		0x10033, 0x0000000C,
		0x1003F, 0x0000001D,
		0x10033, 0x0000000D,
		0x1003F, 0x0000001A,
		0x10033, 0x0000000E,
		0x1003F, 0x00000017,
		0x10033, 0x0000000F,
		0x1003F, 0x00000014,
		0x10033, 0x00000010,
		0x1003F, 0x00000011,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10033, 0x00000000,
		0x1003F, 0x000001AF,
		0x10033, 0x00000001,
		0x1003F, 0x000001A9,
		0x10033, 0x00000002,
		0x1003F, 0x000001A3,
		0x10033, 0x00000003,
		0x1003F, 0x0000019D,
		0x10033, 0x00000004,
		0x1003F, 0x00000197,
		0x10033, 0x00000005,
		0x1003F, 0x0000015F,
		0x10033, 0x00000006,
		0x1003F, 0x00000159,
		0x10033, 0x00000007,
		0x1003F, 0x0000011F,
		0x10033, 0x00000008,
		0x1003F, 0x00000119,
		0x10033, 0x00000009,
		0x1003F, 0x000000DF,
		0x10033, 0x0000000A,
		0x1003F, 0x000000D9,
		0x10033, 0x0000000B,
		0x1003F, 0x0000009F,
		0x10033, 0x0000000C,
		0x1003F, 0x00000099,
		0x10033, 0x0000000D,
		0x1003F, 0x0000005F,
		0x10033, 0x0000000E,
		0x1003F, 0x00000059,
		0x10033, 0x0000000F,
		0x1003F, 0x0000001F,
		0x10033, 0x00000010,
		0x1003F, 0x00000019,
		0x10033, 0x00000011,
		0x1003F, 0x00000013,
		0x100EE, 0x00000000,
		0x10005, 0x00000001,
		0x09F, 0x00000019,

};


/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8192xb_txpwr_lmt[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 80, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 56, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 56, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 68, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 68, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 32, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 32, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 64, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 64, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 36, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 36, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 36, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 36, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 36, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 36, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 32, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 32, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 32, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 32, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 40, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 40, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 40, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 40, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 36, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 36, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 36, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 36, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 40, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 40, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 40, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 40, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 44, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 44, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 44, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 44, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 48, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 48, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 48, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 48, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 52, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 52, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 52, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 52, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 56, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 56, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 56, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 56, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 60, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 60, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 60, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 60, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 64, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 64, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 64, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 100, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 100, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 100, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 104, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 104, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 104, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 108, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 108, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 108, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 112, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 112, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 112, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 116, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 116, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 116, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 120, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 120, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 120, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 124, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 124, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 124, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 128, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 128, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 128, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 132, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 132, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 132, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 132, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 132, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 136, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 136, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 136, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 136, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 136, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 140, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 140, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 140, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 140, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 140, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 144, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 149, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 153, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 161, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 38, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 38, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 38, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 46, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 46, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 54, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 54, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 62, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 62, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 102, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 102, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 102, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 102, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 102, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 110, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 110, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 110, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 110, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 110, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 118, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 118, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 118, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 126, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 126, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 126, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 134, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 134, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 134, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 134, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 134, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 142, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 142, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 142, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 142, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 151, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 151, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 159, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 159, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 159, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 159, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 42, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 42, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 42, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 42, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 58, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 58, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 58, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 58, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 106, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 106, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 106, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 106, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 106, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 122, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 122, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 138, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 138, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 155, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 171, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8192xb_txpwr_lmt_ru[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 32, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 32, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 30, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 30, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 32, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 32, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 44, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 24, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 24, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 24, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 24, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 0, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 4, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 0, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 0, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 12, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 10, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 14, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 10, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 10, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 82, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 82, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 18, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 22, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 22, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0}
};


/******************************************************************************
 *                           txpwr_tracktssi.TXT
 ******************************************************************************/

const s8 delta_swingidx_mp_5gb_n_txpwrtrkssi_8192xb[][D_S_SIZE] = {
	{0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8},
	{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8},
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7,
	 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12},
};

const s8 delta_swingidx_mp_5gb_p_txpwrtrkssi_8192xb[][D_S_SIZE] = {
	{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8},
	{0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8},
	{0, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
};

const s8 delta_swingidx_mp_5ga_n_txpwrtrkssi_8192xb[][D_S_SIZE] = {
	{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
	 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4},
	{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3},
	{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3},
};

const s8 delta_swingidx_mp_5ga_p_txpwrtrkssi_8192xb[][D_S_SIZE] = {
	{0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4,
	 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7},
	{0, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9},
};

const s8 delta_swingidx_mp_2gb_n_txpwrtrkssi_8192xb[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2};
const s8 delta_swingidx_mp_2gb_p_txpwrtrkssi_8192xb[]    = {
	0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,
	 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6};
const s8 delta_swingidx_mp_2ga_n_txpwrtrkssi_8192xb[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const s8 delta_swingidx_mp_2ga_p_txpwrtrkssi_8192xb[]    = {
	0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3,
	 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5};
const s8 delta_swingidx_mp_2g_cck_b_n_txpwrtrkssi_8192xb[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
const s8 delta_swingidx_mp_2g_cck_b_p_txpwrtrkssi_8192xb[] = {
	0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6};
const s8 delta_swingidx_mp_2g_cck_a_n_txpwrtrkssi_8192xb[] = {
	0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2,
	 -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3};
const s8 delta_swingidx_mp_2g_cck_a_p_txpwrtrkssi_8192xb[] = {
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

/******************************************************************************
 *                           txpwr_byrate.TXT
 ******************************************************************************/

const u32 array_mp_8192xb_txpwr_byrate[] = {
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_11M_1M , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_18M_6M , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_54M_24M, 0x484c5050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS3_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS7_4 , 0x44484c50,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS11_8, 0x34383c40,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_DCM4_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS3_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS7_4 , 0x44484c50,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS11_8, 0x34383c40,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_DCM4_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate2_1, 0x00000000,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate2_2, 0x00000000,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_18M_6M , 0x50505050,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_54M_24M, 0x484c5050,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS3_0 , 0x50505050,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS7_4 , 0x44484c50,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS11_8, 0x34383c40,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_DCM4_0 , 0x50505050,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS3_0 , 0x50505050,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS7_4 , 0x44484c50,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS11_8, 0x34383c40,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_DCM4_0 , 0x50505050,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate5_1, 0x00000000
};


#endif	/* _HALRF_HWIMG_RAW_DATA_8192XB_H */