/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/
#ifndef _HALRF_EFUSE_8832BR_H_
#define _HALRF_EFUSE_8832BR_H_

#ifdef RF_8832BR_SUPPORT

enum rtw_flash_8832br_info {
	/* AP customize configs*/
	FLASH_INFO_START_8832BR = (EFUSE_INFO_BTCOEX_MAX + 1),
	FLASH_INFO_COSTUM_PARA_PATH_8832BR = FLASH_INFO_START_8832BR,

	/* RF TSSI SLOPE K, GAIN DIFF */
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8832BR_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8832BR_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8832BR_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8832BR_14,

	/* RF TSSI SLOPE K, CW DIFF */
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8832BR_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8832BR_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8832BR_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8832BR_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8832BR_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8832BR_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8832BR_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8832BR_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8832BR_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8832BR_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8832BR_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8832BR_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8832BR_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8832BR_14,

	/*Error Code*/
	FLASH_INFO_ID_ERROR_8832BR,
};

enum halrf_efsue_info_8832br_offset {
	EFUSE_INFO_RF_BOARD_OPTION_8832BR_ADDR	= 0x2c1,
	EFUSE_INFO_RF_RFE_8832BR_ADDR		= 0x2ca,
	EFUSE_INFO_RF_CHAN_PLAN_8832BR_ADDR	= 0x2b8,
	EFUSE_INFO_RF_XTAL_8832BR_ADDR		= 0x2b9,
	EFUSE_INFO_RF_THERMAL_A_8832BR_ADDR	= 0x2d0,
	EFUSE_INFO_RF_THERMAL_B_8832BR_ADDR	= 0x2d1,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_1_8832BR_ADDR	= 0x210,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_2_8832BR_ADDR	= 0x211,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_3_8832BR_ADDR	= 0x212,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_4_8832BR_ADDR	= 0x213,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_5_8832BR_ADDR	= 0x214,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_6_8832BR_ADDR	= 0x215,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_1_8832BR_ADDR	= 0x216,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_2_8832BR_ADDR	= 0x217,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_3_8832BR_ADDR	= 0x218,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_4_8832BR_ADDR	= 0x219,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_5_8832BR_ADDR	= 0x21a,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_1_8832BR_ADDR	= 0x222,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_2_8832BR_ADDR	= 0x223,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_3_8832BR_ADDR	= 0x224,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_4_8832BR_ADDR	= 0x225,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_5_8832BR_ADDR	= 0x226,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_6_8832BR_ADDR	= 0x227,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_7_8832BR_ADDR	= 0x228,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_8_8832BR_ADDR	= 0x229,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_9_8832BR_ADDR	= 0x22a,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_10_8832BR_ADDR	= 0x22b,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_11_8832BR_ADDR	= 0x22c,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_12_8832BR_ADDR	= 0x22d,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_13_8832BR_ADDR	= 0x22e,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_14_8832BR_ADDR	= 0x22f,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_1_8832BR_ADDR	= 0x23a,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_2_8832BR_ADDR	= 0x23b,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_3_8832BR_ADDR	= 0x23c,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_4_8832BR_ADDR	= 0x23d,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_5_8832BR_ADDR	= 0x23e,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_6_8832BR_ADDR	= 0x23f,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_1_8832BR_ADDR	= 0x240,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_2_8832BR_ADDR	= 0x241,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_3_8832BR_ADDR	= 0x242,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_4_8832BR_ADDR	= 0x243,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_5_8832BR_ADDR	= 0x244,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_1_8832BR_ADDR	= 0x24c,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_2_8832BR_ADDR	= 0x24d,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_3_8832BR_ADDR	= 0x24e,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_4_8832BR_ADDR	= 0x24f,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_5_8832BR_ADDR	= 0x250,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_6_8832BR_ADDR	= 0x251,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_7_8832BR_ADDR	= 0x252,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_8_8832BR_ADDR	= 0x253,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_9_8832BR_ADDR	= 0x254,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_10_8832BR_ADDR	= 0x255,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_11_8832BR_ADDR	= 0x256,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_12_8832BR_ADDR	= 0x257,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_13_8832BR_ADDR	= 0x258,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_14_8832BR_ADDR	= 0x259,
	EFUSE_INFO_RF_RX_GAIN_K_A_2G_CCK_8832BR_ADDR	= 0x2d6,
	EFUSE_INFO_RF_RX_GAIN_K_A_2G_OFMD_8832BR_ADDR	= 0x2d4,
	EFUSE_INFO_RF_RX_GAIN_K_A_5GL_8832BR_ADDR	= 0x2d8,
	EFUSE_INFO_RF_RX_GAIN_K_A_5GM_8832BR_ADDR	= 0x2da,
	EFUSE_INFO_RF_RX_GAIN_K_A_5GH_8832BR_ADDR	= 0x2dc
};

enum halrf_efsue_default_value_8832br {
	EFUSE_INFO_RF_RFE_8832BR_VALUE		= 0x1,
	EFUSE_INFO_RF_CHAN_PLAN_8832BR_VALUE	= 0x7f,
	EFUSE_INFO_RF_XTAL_8832BR_VALUE	= 0x3f,
	EFUSE_INFO_RF_THERMAL_A_8832BR_VALUE	= 0x22,
	EFUSE_INFO_RF_THERMAL_B_8832BR_VALUE	= 0x22,
	EFUSE_INFO_RF_TSSI_DE_8832BR_VALUE	= 0x0,
	EFUSE_INFO_RF_RX_GAIN_K_8832BR_VALUE	= 0xf,
	EFUSE_INFO_RF_BOARD_OPTION_8832BR_VALUE	= 0x1
};

bool halrf_get_efuse_info_8832br(struct rf_info *rf, u8 *efuse_map,
		       enum rtw_efuse_info id, void *value, u32 length,
		       u8 autoload_status);

#endif	/*RF_8832BR_SUPPORT*/
#endif	/*_HALRF_EFUSE_8832BR_H_*/

