/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.10*/
#ifndef _HALRF_HWIMG_RAW_DATA_8832CRVU_H
#define _HALRF_HWIMG_RAW_DATA_8832CRVU_H

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE


#if 0
/* Please put following enum definitions in appropriate header file. */
enum odm_pw_byrate_para_type {
	PW_BYRATE_PARA_NSS1,
	PW_BYRATE_PARA_NSS2,
	PW_BYRATE_PARA_OFFS = 0xF
};

enum odm_pw_byrate_rate_type {
	PW_BYRATE_RATE_11M_1M,
	PW_BYRATE_RATE_18M_6M,
	PW_BYRATE_RATE_54M_24M,
	PW_BYRATE_RATE_MCS3_0,
	PW_BYRATE_RATE_MCS7_4,
	PW_BYRATE_RATE_MCS11_8,
	PW_BYRATE_RATE_DCM4_0,
	PW_BYRATE_RATE_AllRate2_1,  /* CCK, OFDM, HT, VHT */
	PW_BYRATE_RATE_AllRate2_2,  /* HE_HEDCM */
	PW_BYRATE_RATE_AllRate5_1,  /* OFDM, HT, VHT, HE_HEDCM */
	PW_BYRATE_RATE_AllRate6_1,  /* OFDM, HT, VHT, HE_HEDCM (6G) */
	PW_BYRATE_RATE_NULL = 0xF
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC,
	PW_LMT_REGU_ETSI,
	PW_LMT_REGU_MKK,
	PW_LMT_REGU_IC,
	PW_LMT_REGU_KCC,
	PW_LMT_REGU_ACMA,
	PW_LMT_REGU_CHILE,
	PW_LMT_REGU_UKRAINE,
	PW_LMT_REGU_MEXICO,
	PW_LMT_REGU_CN,
	PW_LMT_REGU_WW13,
	PW_LMT_REGU_NULL
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_2_4G,
	PW_LMT_BAND_5G,
	PW_LMT_BAND_6G,
	PW_LMT_BAND_NULL
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_20M,
	PW_LMT_BW_40M,
	PW_LMT_BW_80M,
	PW_LMT_BW_160M,
	PW_LMT_BW_NULL
};

enum odm_pw_lmt_ru_bandwidth_type {
	PW_LMT_RU_BW_RU26,
	PW_LMT_RU_BW_RU52,
	PW_LMT_RU_BW_RU106,
	PW_LMT_RU_BW_NULL
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_CCK,
	PW_LMT_RS_OFDM,
	PW_LMT_RS_HT,
	PW_LMT_RS_VHT,
	PW_LMT_RS_HE,
	PW_LMT_RS_NULL
};

enum odm_pw_lmt_beamform_type {
	PW_LMT_BF,
	PW_LMT_NONBF,
	PW_LMT_NULL
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_1T,
	PW_LMT_PH_2T,
	PW_LMT_PH_3T,
	PW_LMT_PH_4T,
	PW_LMT_PH_NULL
};

struct halrf_tx_pw_lmt {
	u8			band:1;
	u8			bw:3;
	u8			rs:2;
	u8			ntx:2;
	u8			bf:3;
	u8			reg:5;
	u8			ch;
	s8			val;
};

struct halrf_tx_pw_lmt_ru {
	u8			band:1;
	u8			bw:2;
	u8			ntx:2;
	u8			rs:3;
	u8			reg;
	u8			ch;
	s8			val;
};
#endif


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8832crvu_radioa[] = {
		
		0x03F, 0x0000020C,

};


/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8832crvu_radiob[] = {
		
		0x03F, 0x0000020C,

};


/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8832crvu_txpwr_lmt[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 36, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 40, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 44, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 48, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 48, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 52, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 56, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 60, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 64, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 100, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 104, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 104, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 108, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 108, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 112, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 112, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 116, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 116, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 120, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 120, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 124, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 124, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 128, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 128, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 132, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 132, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 132, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 136, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 136, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 136, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 140, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 144, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 149, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 149, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 153, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 153, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 157, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 157, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 161, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 165, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 38, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 38, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 38, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 46, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 54, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 62, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 142, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 151, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 151, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 151, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 159, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 159, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 159, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 159, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 42, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 42, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 42, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 58, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 122, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 122, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 138, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 155, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 155, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 155, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 50, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 50, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 50, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 50, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 114, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 114, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 50, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 50, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 50, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 50, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 114, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 114, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 114, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 50, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 50, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 50, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 50, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 50, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 114, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 114, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 163, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 163, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_6g_low.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8832crvu_txpwr_lmt_6g_low[] = {
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 17, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 21, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 25, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 29, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 33, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 37, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 41, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 45, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 49, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 53, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 57, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 61, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 65, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 69, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 73, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 77, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 81, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 85, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 89, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 93, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 97, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 101, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 109, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 113, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 117, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 121, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 125, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 129, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 133, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 137, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 141, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 145, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 181, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 185, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 189, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 193, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 197, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 201, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 205, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 209, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 213, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 217, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 221, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 225, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 229, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 233, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 49, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 53, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 57, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 61, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 65, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 69, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 73, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 77, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 81, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 85, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 89, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 97, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 101, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 105, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 109, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 113, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 117, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 121, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 125, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 129, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 133, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 137, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 141, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 145, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 181, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 185, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 189, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 193, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 197, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 201, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 205, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 209, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 213, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 217, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 221, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 225, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 229, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 233, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 17, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 21, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 25, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 29, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 33, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 37, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 41, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 45, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 49, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 53, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 57, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 61, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 65, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 69, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 73, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 77, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 81, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 85, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 89, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 93, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 97, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 101, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 109, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 113, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 117, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 121, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 125, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 129, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 133, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 137, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 141, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 145, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 181, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 185, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 189, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 193, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 197, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 201, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 205, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 209, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 213, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 217, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 221, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 225, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 229, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 233, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 49, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 53, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 57, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 61, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 65, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 69, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 73, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 77, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 81, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 85, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 89, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 97, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 101, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 105, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 109, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 113, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 117, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 121, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 125, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 129, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 133, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 137, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 141, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 145, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 181, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 185, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 189, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 193, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 197, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 201, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 205, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 209, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 213, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 217, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 221, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 225, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 229, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 233, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 17, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 21, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 25, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 29, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 33, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 37, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 41, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 45, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 49, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 49, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 53, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 53, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 57, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 57, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 61, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 61, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 65, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 65, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 69, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 69, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 73, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 73, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 77, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 77, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 81, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 81, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 85, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 85, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 89, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 89, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 93, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 97, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 101, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 105, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 109, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 113, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 117, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 121, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 125, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 129, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 133, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 137, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 141, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 145, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 149, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 153, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 157, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 161, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 165, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 169, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 173, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 177, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 181, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 185, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 189, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 193, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 197, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 201, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 205, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 209, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 213, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 217, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 221, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 225, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 229, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 233, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 19, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 19, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 19, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 27, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 27, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 27, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 35, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 35, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 35, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 43, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 43, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 43, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 51, 36, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 51, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 51, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 59, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 59, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 59, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 67, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 67, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 67, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 75, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 75, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 75, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 83, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 83, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 83, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 91, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 91, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 91, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 99, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 99, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 107, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 107, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 115, 36, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 115, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 123, 36, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 123, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 123, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 131, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 131, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 131, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 139, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 139, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 139, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 147, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 147, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 147, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 179, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 179, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 179, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 187, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 187, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 195, 36, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 195, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 203, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 203, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 211, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 211, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 219, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 219, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 227, 36, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 227, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 19, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 19, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 19, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 27, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 27, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 27, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 35, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 35, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 35, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 43, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 43, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 43, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 51, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 51, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 51, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 59, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 59, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 59, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 67, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 67, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 67, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 75, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 75, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 75, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 83, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 83, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 83, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 91, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 91, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 91, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 99, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 99, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 107, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 107, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 115, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 115, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 123, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 123, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 123, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 131, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 131, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 131, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 139, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 139, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 139, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 147, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 147, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 147, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 179, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 179, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 179, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 187, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 187, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 195, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 195, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 203, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 203, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 211, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 211, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 219, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 219, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 227, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 227, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 19, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 19, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 19, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 27, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 27, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 27, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 35, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 35, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 35, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 43, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 43, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 43, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 51, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 51, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 51, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 59, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 59, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 59, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 67, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 67, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 67, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 75, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 75, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 75, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 83, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 83, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 83, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 91, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 91, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 91, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 99, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 99, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 107, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 107, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 115, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 115, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 123, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 123, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 123, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 131, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 131, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 131, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 139, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 139, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 139, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 147, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 147, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 147, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 155, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 163, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 163, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 171, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 179, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 179, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 179, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 187, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 187, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 195, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 195, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 203, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 203, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 211, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 211, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 219, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 219, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 227, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 227, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 23, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 23, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 23, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 39, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 39, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 39, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 55, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 55, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 55, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 71, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 71, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 71, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 87, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 87, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 87, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 103, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 103, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 119, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 119, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 135, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 135, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 135, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 183, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 183, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 199, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 199, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 215, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 215, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 23, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 23, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 23, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 39, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 39, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 39, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 55, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 55, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 55, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 71, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 71, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 71, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 87, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 87, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 87, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 103, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 103, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 119, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 119, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 135, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 135, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 135, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 183, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 183, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 199, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 199, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 215, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 215, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 23, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 23, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 23, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 39, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 39, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 39, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 55, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 55, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 55, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 71, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 71, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 71, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 87, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 87, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 87, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 103, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 103, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 119, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 119, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 135, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 135, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 135, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 151, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 167, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 183, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 183, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 199, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 199, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 215, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 215, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 15, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 15, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 15, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 47, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 47, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 47, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 79, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 79, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 79, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 111, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 111, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 143, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 143, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 143, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 207, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 207, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 15, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 15, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 15, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 47, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 47, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 47, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 79, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 79, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 79, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 111, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 111, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 143, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 143, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 143, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 207, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 207, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 15, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 15, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 15, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 47, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 47, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 47, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 79, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 79, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 79, 40, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 111, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 111, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 143, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 143, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 143, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 175, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 207, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 207, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 239, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_6g_std.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8832crvu_txpwr_lmt_6g_std[] = {
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 49, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 53, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 57, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 61, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 65, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 69, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 73, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 77, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 81, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 85, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 89, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 93, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 17, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 21, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 25, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 29, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 33, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 37, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 41, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 45, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 49, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 49, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 53, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 53, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 57, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 57, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 61, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 61, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 65, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 65, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 69, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 69, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 73, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 73, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 77, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 77, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 81, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 81, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 85, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 85, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 89, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 89, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 93, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 93, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 19, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 19, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 27, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 27, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 35, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 35, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 43, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 43, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 51, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 51, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 59, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 59, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 67, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 67, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 75, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 75, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 83, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 83, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 91, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 91, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 123, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 123, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 131, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 131, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 139, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 139, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 147, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 147, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 179, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 179, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 19, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 19, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 27, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 27, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 35, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 35, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 43, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 43, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 51, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 51, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 59, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 59, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 67, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 67, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 75, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 75, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 83, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 83, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 91, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 91, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 123, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 123, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 131, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 131, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 139, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 139, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 147, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 147, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 179, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 179, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 19, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 19, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 27, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 27, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 35, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 35, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 43, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 43, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 51, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 51, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 59, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 59, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 67, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 67, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 75, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 75, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 83, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 83, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 91, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 91, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 99, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 107, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 115, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 123, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 123, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 131, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 131, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 139, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 139, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 147, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 147, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 163, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 179, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 179, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 187, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 195, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 203, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 211, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 219, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 227, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 235, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 243, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 251, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 23, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 23, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 39, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 39, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 55, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 55, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 71, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 71, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 87, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 87, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 135, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 135, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 23, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 23, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 39, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 39, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 55, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 55, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 71, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 71, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 87, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 87, 48, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 135, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 135, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 23, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 23, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 39, 50, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 39, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 55, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 55, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 71, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 71, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 87, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 87, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 103, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 119, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 135, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 135, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 58, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 183, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 199, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 215, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 231, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 247, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 15, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 15, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 47, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 47, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 79, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 79, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 143, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 143, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 15, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 15, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 47, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 47, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 79, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 79, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 143, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 143, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 15, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 15, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 47, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 47, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 79, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 79, 38, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 111, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 143, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 143, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 207, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 239, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 239, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8832crvu_txpwr_lmt_ru[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 26, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 26, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -20, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, -20, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 50, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 42, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 22, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 22, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -30, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 24, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, -30, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 4, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 4, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 52, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 30, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 30, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -6, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, -6, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 48, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 6, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 6, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 22, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 10, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 8, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 8, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 8, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 8, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 8, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 8, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 0, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 8, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 18, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 20, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 8, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 30, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 82, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 82, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 26, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 26, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 26, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 26, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 20, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru_6g_low.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8832crvu_txpwr_lmt_ru_6g_low[] = {
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, -12, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, -12, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, -40, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, -38, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, -34, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, -34, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 2, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, -28, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, -26, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, -22, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, -22, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 8, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, -18, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, -16, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, -12, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, -10, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru_6g_std.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8832crvu_txpwr_lmt_ru_6g_std[] = {
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 30, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 52, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 46, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 60, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 78, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 17, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 21, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 25, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 29, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 33, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 37, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 41, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 45, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 49, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 53, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 57, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 61, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 65, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 69, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 73, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 77, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 81, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 85, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 89, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 93, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 117, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 121, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 125, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 129, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 133, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 137, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 141, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 145, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 181, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 253, 127, 0}
};


/******************************************************************************
 *                           txpwr_tracktssi.TXT
 ******************************************************************************/

const s8 delta_swingidx_mp_6gb_n_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
};

const s8 delta_swingidx_mp_6gb_p_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11,
	 11, 12, 12, 13, 14, 14, 15, 15, 16, 17, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	 10, 11, 11, 12, 12, 13, 13, 14, 15, 15, 16, 16},
};

const s8 delta_swingidx_mp_6ga_n_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
};

const s8 delta_swingidx_mp_6ga_p_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15},
};

const s8 delta_swingidx_mp_5gb_n_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
	 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8},
	{0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7,
	 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12},
};

const s8 delta_swingidx_mp_5gb_p_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 16},
	{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10,
	 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 16},
};

const s8 delta_swingidx_mp_5ga_n_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6},
	{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3},
	{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
	 5, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8},
};

const s8 delta_swingidx_mp_5ga_p_txpwrtrkssi_8832crvu[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14},
};

const s8 delta_swingidx_mp_2gb_n_txpwrtrkssi_8832crvu[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
const s8 delta_swingidx_mp_2gb_p_txpwrtrkssi_8832crvu[]    = {
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2};
const s8 delta_swingidx_mp_2ga_n_txpwrtrkssi_8832crvu[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2,
	 -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3};
const s8 delta_swingidx_mp_2ga_p_txpwrtrkssi_8832crvu[]    = {
	0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3,
	 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5};
const s8 delta_swingidx_mp_2g_cck_b_n_txpwrtrkssi_8832crvu[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
const s8 delta_swingidx_mp_2g_cck_b_p_txpwrtrkssi_8832crvu[] = {
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2};
const s8 delta_swingidx_mp_2g_cck_a_n_txpwrtrkssi_8832crvu[] = {
	0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -2,
	 -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3};
const s8 delta_swingidx_mp_2g_cck_a_p_txpwrtrkssi_8832crvu[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3,
	 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5};

/******************************************************************************
 *                           txpwr_byrate.TXT
 ******************************************************************************/

const u32 array_mp_8832crvu_txpwr_byrate[] = {
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_11M_1M , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_18M_6M , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_54M_24M, 0x484c5050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS3_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS7_4 , 0x44484c50,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS11_8, 0x34383c40,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_DCM4_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS3_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS7_4 , 0x44484c50,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS11_8, 0x34383c40,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_DCM4_0 , 0x50505050,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate2_1, 0x00000000,
	PW_LMT_BAND_2_4G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate2_2, 0x00000000,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_18M_6M , 0x48484848,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_54M_24M, 0x40444848,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS3_0 , 0x48484848,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS7_4 , 0x3c404448,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS11_8, 0x2c303438,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_DCM4_0 , 0x48484848,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS3_0 , 0x48484848,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS7_4 , 0x3c404448,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS11_8, 0x2c303438,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_DCM4_0 , 0x48484848,
	PW_LMT_BAND_5G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate5_1, 0x00000000,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_18M_6M , 0x40404040,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_54M_24M, 0x383c4040,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS3_0 , 0x40404040,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS7_4 , 0x34383c40,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_MCS11_8, 0x24282c30,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS1, PW_BYRATE_RATE_DCM4_0 , 0x40404040,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS3_0 , 0x40404040,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS7_4 , 0x34383c40,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_MCS11_8, 0x24282c30,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_NSS2, PW_BYRATE_RATE_DCM4_0 , 0x40404040,
	PW_LMT_BAND_6G, PW_BYRATE_PARA_OFFS, PW_BYRATE_RATE_AllRate6_1, 0x00000000
};


#endif	/* _HALRF_HWIMG_RAW_DATA_8832CRVU_H */