/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.11*/
#ifndef _HALRF_HWIMG_RAW_DATA_8832D_H
#define _HALRF_HWIMG_RAW_DATA_8832D_H

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE


#if 0
/* Please put following enum definitions in appropriate header file. */
enum odm_pw_byrate_para_type {
	PW_BYRATE_PARA_NSS1,
	PW_BYRATE_PARA_NSS2,
	PW_BYRATE_PARA_OFFS = 0xF
};

enum odm_pw_byrate_rate_type {
	PW_BYRATE_RATE_11M_1M,
	PW_BYRATE_RATE_18M_6M,
	PW_BYRATE_RATE_54M_24M,
	PW_BYRATE_RATE_MCS3_0,
	PW_BYRATE_RATE_MCS7_4,
	PW_BYRATE_RATE_MCS11_8,
	PW_BYRATE_RATE_DCM4_0,
	PW_BYRATE_RATE_AllRate2_1,  /* CCK, OFDM, HT, VHT */
	PW_BYRATE_RATE_AllRate2_2,  /* HE_HEDCM */
	PW_BYRATE_RATE_AllRate5_1,  /* OFDM, HT, VHT, HE_HEDCM */
	PW_BYRATE_RATE_AllRate6_1,  /* OFDM, HT, VHT, HE_HEDCM (6G) */
	PW_BYRATE_RATE_NULL = 0xF
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC,
	PW_LMT_REGU_ETSI,
	PW_LMT_REGU_MKK,
	PW_LMT_REGU_IC,
	PW_LMT_REGU_KCC,
	PW_LMT_REGU_ACMA,
	PW_LMT_REGU_CHILE,
	PW_LMT_REGU_UKRAINE,
	PW_LMT_REGU_MEXICO,
	PW_LMT_REGU_CN,
	PW_LMT_REGU_WW13,
	PW_LMT_REGU_NULL
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_2_4G,
	PW_LMT_BAND_5G,
	PW_LMT_BAND_6G,
	PW_LMT_BAND_NULL
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_20M,
	PW_LMT_BW_40M,
	PW_LMT_BW_80M,
	PW_LMT_BW_160M,
	PW_LMT_BW_NULL
};

enum odm_pw_lmt_ru_bandwidth_type {
	PW_LMT_RU_BW_RU26,
	PW_LMT_RU_BW_RU52,
	PW_LMT_RU_BW_RU106,
	PW_LMT_RU_BW_NULL
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_CCK,
	PW_LMT_RS_OFDM,
	PW_LMT_RS_HT,
	PW_LMT_RS_VHT,
	PW_LMT_RS_HE,
	PW_LMT_RS_NULL
};

enum odm_pw_lmt_beamform_type {
	PW_LMT_BF,
	PW_LMT_NONBF,
	PW_LMT_NULL
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_1T,
	PW_LMT_PH_2T,
	PW_LMT_PH_3T,
	PW_LMT_PH_4T,
	PW_LMT_PH_NULL
};

struct halrf_tx_pw_lmt {
	u8			band:1;
	u8			bw:3;
	u8			rs:2;
	u8			ntx:2;
	u8			bf:3;
	u8			reg:5;
	u8			ch;
	s8			val;
};

struct halrf_tx_pw_lmt_ru {
	u8			band:1;
	u8			bw:2;
	u8			ntx:2;
	u8			rs:3;
	u8			reg;
	u8			ch;
	s8			val;
};
#endif


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8832d_radioa[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0030000, 0x00000002,
		0xF0040000, 0x00000003,
		0x005, 0x00000000,
		0x10005, 0x00000000,
		0x000, 0x00030001,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x0A3, 0x000B9204,
		0x0AD, 0x00091E0F,
		0x05D, 0x00001012,
		0x05C, 0x00079C5C,
		0x062, 0x00055220,
		0x0D3, 0x00000103,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000620,
		0x03F, 0x0000020C,
		0x0EF, 0x00000000,
		0x05F, 0x00000038,
		0x097, 0x00043200,
		0x0A6, 0x00066DB7,
		0x0EF, 0x00004000,
		0x033, 0x00000005,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x00000003,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x00000002,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x0000000D,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x0000000B,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x0000000A,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x0EF, 0x00000000,
		0x000, 0x00033C01,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x096, 0x00015200,
		0x10055, 0x00080080,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
		0x057, 0x0000D589,
		0x05A, 0x0007FFFF,
		0x043, 0x00005000,
		0x0B5, 0x00001720,
		0x0ED, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x00013FAB,
		0x03F, 0x000FD800,
		0x033, 0x00000010,
		0x03E, 0x00013FAB,
		0x03F, 0x000FD800,
		0x033, 0x00000020,
		0x03E, 0x00013FAB,
		0x03F, 0x000FD800,
		0x0ED, 0x00000000,
		0x0ED, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x000000FA,
		0x033, 0x00000001,
		0x03F, 0x000000F2,
		0x033, 0x00000002,
		0x03F, 0x000000EA,
		0x033, 0x00000003,
		0x03F, 0x000000E2,
		0x033, 0x00000004,
		0x03F, 0x000000DA,
		0x033, 0x00000005,
		0x03F, 0x000000D2,
		0x033, 0x00000006,
		0x03F, 0x000000CC,
		0x033, 0x00000007,
		0x03F, 0x000000C4,
		0x033, 0x00000008,
		0x03F, 0x000000BC,
		0x033, 0x00000009,
		0x03F, 0x000000B4,
		0x033, 0x0000000A,
		0x03F, 0x000000AC,
		0x033, 0x0000000B,
		0x03F, 0x000000A4,
		0x033, 0x0000000C,
		0x03F, 0x0000009C,
		0x033, 0x0000000D,
		0x03F, 0x00000094,
		0x033, 0x0000000E,
		0x03F, 0x0000008C,
		0x033, 0x0000000F,
		0x03F, 0x00000084,
		0x033, 0x00000010,
		0x03F, 0x000000BC,
		0x033, 0x00000011,
		0x03F, 0x000000B4,
		0x033, 0x00000012,
		0x03F, 0x000000AC,
		0x033, 0x00000013,
		0x03F, 0x000000A4,
		0x033, 0x00000014,
		0x03F, 0x0000009C,
		0x033, 0x00000015,
		0x03F, 0x00000094,
		0x033, 0x00000016,
		0x03F, 0x0000008C,
		0x033, 0x00000017,
		0x03F, 0x00000084,
		0x033, 0x00000018,
		0x03F, 0x0000003C,
		0x033, 0x00000019,
		0x03F, 0x00000034,
		0x033, 0x0000001A,
		0x03F, 0x0000002C,
		0x033, 0x0000001B,
		0x03F, 0x00000024,
		0x033, 0x0000001C,
		0x03F, 0x0000001C,
		0x033, 0x0000001D,
		0x03F, 0x00000014,
		0x033, 0x0000001E,
		0x03F, 0x0000000C,
		0x033, 0x0000001F,
		0x03F, 0x00000004,
		0x0ED, 0x00000000,
		0x0B9, 0x00020440,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000000,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
		0x08F, 0x000D1352,
		0x0EB, 0x00000000,
		0x030, 0x000109B0,
		0x030, 0x000189B0,
		0x0EB, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
		0x03F, 0x00000017,
		0x033, 0x00000002,
		0x03F, 0x00000017,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00060001,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00000001,
		0x033, 0x00000025,
		0x03F, 0x00000002,
		0x033, 0x00000026,
		0x03F, 0x00000003,
		0x033, 0x00000027,
		0x03F, 0x00000003,
		0x033, 0x00000028,
		0x03F, 0x00060001,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00000001,
		0x033, 0x0000002D,
		0x03F, 0x00000002,
		0x033, 0x0000002E,
		0x03F, 0x00000003,
		0x033, 0x0000002F,
		0x03F, 0x00000003,
		0x033, 0x00000030,
		0x03F, 0x00060001,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00000001,
		0x033, 0x00000035,
		0x03F, 0x00000002,
		0x033, 0x00000036,
		0x03F, 0x00000003,
		0x033, 0x00000037,
		0x03F, 0x00000003,
		0x033, 0x00000060,
		0x03F, 0x00060001,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00000001,
		0x033, 0x00000065,
		0x03F, 0x00000002,
		0x033, 0x00000066,
		0x03F, 0x00000003,
		0x033, 0x00000067,
		0x03F, 0x00000003,
		0x033, 0x00000068,
		0x03F, 0x00060001,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00000001,
		0x033, 0x0000006D,
		0x03F, 0x00000002,
		0x033, 0x0000006E,
		0x03F, 0x00000003,
		0x033, 0x0000006F,
		0x03F, 0x00000003,
		0x033, 0x00000070,
		0x03F, 0x00060001,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00000001,
		0x033, 0x00000075,
		0x03F, 0x00000002,
		0x033, 0x00000076,
		0x03F, 0x00000003,
		0x033, 0x00000077,
		0x03F, 0x00000003,
		0x033, 0x00000078,
		0x03F, 0x00060001,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00000001,
		0x033, 0x0000007D,
		0x03F, 0x00000002,
		0x033, 0x0000007E,
		0x03F, 0x00000003,
		0x033, 0x0000007F,
		0x03F, 0x00000003,
		0x033, 0x000000A0,
		0x03F, 0x00060001,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00000001,
		0x033, 0x000000A5,
		0x03F, 0x00000002,
		0x033, 0x000000A6,
		0x03F, 0x00000003,
		0x033, 0x000000A7,
		0x03F, 0x00000003,
		0x033, 0x000000A8,
		0x03F, 0x00060001,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00000001,
		0x033, 0x000000AD,
		0x03F, 0x00000002,
		0x033, 0x000000AE,
		0x03F, 0x00000003,
		0x033, 0x000000AF,
		0x03F, 0x00000003,
		0x033, 0x000000B0,
		0x03F, 0x00060001,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00000001,
		0x033, 0x000000B5,
		0x03F, 0x00000002,
		0x033, 0x000000B6,
		0x03F, 0x00000003,
		0x033, 0x000000B7,
		0x03F, 0x00000003,
		0x033, 0x000000E0,
		0x03F, 0x00060001,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00000001,
		0x033, 0x000000E5,
		0x03F, 0x00000002,
		0x033, 0x000000E6,
		0x03F, 0x00000003,
		0x033, 0x000000E7,
		0x03F, 0x00000003,
		0x033, 0x000000E8,
		0x03F, 0x00060001,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00000001,
		0x033, 0x000000ED,
		0x03F, 0x00000002,
		0x033, 0x000000EE,
		0x03F, 0x00000003,
		0x033, 0x000000EF,
		0x03F, 0x00000003,
		0x033, 0x000000F0,
		0x03F, 0x00060001,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00000001,
		0x033, 0x000000F5,
		0x03F, 0x00000002,
		0x033, 0x000000F6,
		0x03F, 0x00000003,
		0x033, 0x000000F7,
		0x03F, 0x00000003,
		0x033, 0x000000F8,
		0x03F, 0x00060001,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00000001,
		0x033, 0x000000FD,
		0x03F, 0x00000002,
		0x033, 0x000000FE,
		0x03F, 0x00000003,
		0x033, 0x000000FF,
		0x03F, 0x00000003,
		0x033, 0x00000120,
		0x03F, 0x00060001,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00000001,
		0x033, 0x00000125,
		0x03F, 0x00000002,
		0x033, 0x00000126,
		0x03F, 0x00000003,
		0x033, 0x00000127,
		0x03F, 0x00000003,
		0x033, 0x00000128,
		0x03F, 0x00060001,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00000001,
		0x033, 0x0000012D,
		0x03F, 0x00000002,
		0x033, 0x0000012E,
		0x03F, 0x00000003,
		0x033, 0x0000012F,
		0x03F, 0x00000003,
		0x033, 0x00000130,
		0x03F, 0x00060001,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00000001,
		0x033, 0x00000135,
		0x03F, 0x00000002,
		0x033, 0x00000136,
		0x03F, 0x00000003,
		0x033, 0x00000137,
		0x03F, 0x00000003,
		0x033, 0x00000160,
		0x03F, 0x00060001,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00000001,
		0x033, 0x00000165,
		0x03F, 0x00000002,
		0x033, 0x00000166,
		0x03F, 0x00000003,
		0x033, 0x00000167,
		0x03F, 0x00000003,
		0x033, 0x00000168,
		0x03F, 0x00060001,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00000001,
		0x033, 0x0000016D,
		0x03F, 0x00000002,
		0x033, 0x0000016E,
		0x03F, 0x00000003,
		0x033, 0x0000016F,
		0x03F, 0x00000003,
		0x033, 0x00000170,
		0x03F, 0x00060001,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00000001,
		0x033, 0x00000175,
		0x03F, 0x00000002,
		0x033, 0x00000176,
		0x03F, 0x00000003,
		0x033, 0x00000177,
		0x03F, 0x00000003,
		0x033, 0x00000178,
		0x03F, 0x00060001,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00000001,
		0x033, 0x0000017D,
		0x03F, 0x00000002,
		0x033, 0x0000017E,
		0x03F, 0x00000003,
		0x033, 0x0000017F,
		0x03F, 0x00000003,
		0x033, 0x000001A0,
		0x03F, 0x00060001,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00000001,
		0x033, 0x000001A5,
		0x03F, 0x00000002,
		0x033, 0x000001A6,
		0x03F, 0x00000003,
		0x033, 0x000001A7,
		0x03F, 0x00000003,
		0x033, 0x000001A8,
		0x03F, 0x00060001,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00000001,
		0x033, 0x000001AD,
		0x03F, 0x00000002,
		0x033, 0x000001AE,
		0x03F, 0x00000003,
		0x033, 0x000001AF,
		0x03F, 0x00000003,
		0x033, 0x000001B0,
		0x03F, 0x00060001,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00000001,
		0x033, 0x000001B5,
		0x03F, 0x00000002,
		0x033, 0x000001B6,
		0x03F, 0x00000003,
		0x033, 0x000001B7,
		0x03F, 0x00000003,
		0x033, 0x000001E0,
		0x03F, 0x00060001,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00000001,
		0x033, 0x000001E5,
		0x03F, 0x00000002,
		0x033, 0x000001E6,
		0x03F, 0x00000003,
		0x033, 0x000001E7,
		0x03F, 0x00000003,
		0x033, 0x000001E8,
		0x03F, 0x00060001,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00000001,
		0x033, 0x000001ED,
		0x03F, 0x00000002,
		0x033, 0x000001EE,
		0x03F, 0x00000003,
		0x033, 0x000001EF,
		0x03F, 0x00000003,
		0x033, 0x000001F0,
		0x03F, 0x00060001,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00000001,
		0x033, 0x000001F5,
		0x03F, 0x00000002,
		0x033, 0x000001F6,
		0x03F, 0x00000003,
		0x033, 0x000001F7,
		0x03F, 0x00000003,
		0x033, 0x000001F8,
		0x03F, 0x00060001,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00000001,
		0x033, 0x000001FD,
		0x03F, 0x00000002,
		0x033, 0x000001FE,
		0x03F, 0x00000003,
		0x033, 0x000001FF,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x0000EFFF,
		0x033, 0x00000002,
		0x03F, 0x0000EFFF,
		0x033, 0x00000003,
		0x03F, 0x0000EFFF,
		0x033, 0x00000004,
		0x03F, 0x0000EFFF,
		0x033, 0x00000005,
		0x03F, 0x0000EFFF,
		0x033, 0x00000006,
		0x03F, 0x0000EFFF,
		0x033, 0x00000007,
		0x03F, 0x0000EFFF,
		0x033, 0x00000008,
		0x03F, 0x0000EFFF,
		0x033, 0x00000009,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000A,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000B,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000C,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000D,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000E,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000F,
		0x03F, 0x0000EFFF,
		0x033, 0x00000010,
		0x03F, 0x0000EFFF,
		0x033, 0x00000011,
		0x03F, 0x0000EFFF,
		0x033, 0x00000012,
		0x03F, 0x0000EFFF,
		0x033, 0x00000013,
		0x03F, 0x0000EFFF,
		0x033, 0x00000014,
		0x03F, 0x0000EFFF,
		0x033, 0x00000015,
		0x03F, 0x0000EFFF,
		0x033, 0x00000016,
		0x03F, 0x0000EFFF,
		0x033, 0x00000017,
		0x03F, 0x0000EFFF,
		0x033, 0x00000018,
		0x03F, 0x0000FBFF,
		0x033, 0x00000019,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001A,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001B,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001C,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001D,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001E,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001F,
		0x03F, 0x0000EFFF,
		0x033, 0x00000020,
		0x03F, 0x0000EFFF,
		0x033, 0x00000021,
		0x03F, 0x0000EFFF,
		0x033, 0x00000022,
		0x03F, 0x0000EFFF,
		0x033, 0x00000023,
		0x03F, 0x0000EFFF,
		0x033, 0x00000024,
		0x03F, 0x0000EFFF,
		0x033, 0x00000025,
		0x03F, 0x0000EFFF,
		0x033, 0x00000026,
		0x03F, 0x0000EFFF,
		0x033, 0x00000027,
		0x03F, 0x0000EFFF,
		0x033, 0x00000028,
		0x03F, 0x0000EFFF,
		0x033, 0x00000029,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002A,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002B,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002C,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002D,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002E,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002F,
		0x03F, 0x0000EFFF,
		0x033, 0x00000030,
		0x03F, 0x0000EFFF,
		0x033, 0x00000031,
		0x03F, 0x0000EFFF,
		0x033, 0x00000032,
		0x03F, 0x0000EFFF,
		0x033, 0x00000033,
		0x03F, 0x0000EFFF,
		0x033, 0x00000034,
		0x03F, 0x0000EFFF,
		0x033, 0x00000035,
		0x03F, 0x0000EFFF,
		0x033, 0x00000036,
		0x03F, 0x0000EFFF,
		0x033, 0x00000037,
		0x03F, 0x0000EFFF,
		0x033, 0x00000038,
		0x03F, 0x0000EFFF,
		0x033, 0x00000039,
		0x03F, 0x0000EFFF,
		0x033, 0x0000003A,
		0x03F, 0x0000EFFF,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00004344,
		0x033, 0x00000001,
		0x03F, 0x00004344,
		0x033, 0x00000002,
		0x03F, 0x00004344,
		0x033, 0x00000003,
		0x03F, 0x00004344,
		0x033, 0x00000004,
		0x03F, 0x00004344,
		0x033, 0x00000005,
		0x03F, 0x00004344,
		0x033, 0x00000006,
		0x03F, 0x00004344,
		0x033, 0x00000007,
		0x03F, 0x00004344,
		0x033, 0x00000008,
		0x03F, 0x00004344,
		0x033, 0x00000009,
		0x03F, 0x00004344,
		0x033, 0x0000000A,
		0x03F, 0x00004344,
		0x033, 0x0000000B,
		0x03F, 0x00004344,
		0x033, 0x00000010,
		0x03F, 0x00004344,
		0x033, 0x00000011,
		0x03F, 0x00004344,
		0x033, 0x00000012,
		0x03F, 0x00004344,
		0x033, 0x00000013,
		0x03F, 0x00004344,
		0x033, 0x00000014,
		0x03F, 0x00004344,
		0x033, 0x00000015,
		0x03F, 0x00004344,
		0x033, 0x00000016,
		0x03F, 0x00004344,
		0x033, 0x00000017,
		0x03F, 0x00004344,
		0x033, 0x00000018,
		0x03F, 0x00004344,
		0x033, 0x00000019,
		0x03F, 0x00004344,
		0x033, 0x0000001A,
		0x03F, 0x00004344,
		0x033, 0x0000001B,
		0x03F, 0x00004344,
		0x033, 0x0000001C,
		0x03F, 0x00004344,
		0x033, 0x0000001D,
		0x03F, 0x00004344,
		0x033, 0x0000001E,
		0x03F, 0x00004344,
		0x033, 0x0000001F,
		0x03F, 0x00004344,
		0x0EF, 0x00000000,
		0x0EF, 0x00000020,
		0x033, 0x00000010,
		0x03F, 0x00000200,
		0x033, 0x00000011,
		0x03F, 0x00000200,
		0x033, 0x00000012,
		0x03F, 0x00000200,
		0x033, 0x00000013,
		0x03F, 0x00000200,
		0x033, 0x00000020,
		0x03F, 0x00000200,
		0x033, 0x00000021,
		0x03F, 0x00000200,
		0x033, 0x00000022,
		0x03F, 0x00000200,
		0x033, 0x00000023,
		0x03F, 0x00000200,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
		0x030, 0x00068000,
		0x030, 0x00070000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000004,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000005,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000006,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x00000007,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x00000008,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000009,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x0000000A,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x0000000B,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x0000000C,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x0000000D,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x0000000E,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x0000000F,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x00000010,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000011,
		0x03E, 0x0000001B,
		0x03F, 0x00023C58,
		0x033, 0x00000012,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x00000013,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x00000014,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000015,
		0x03E, 0x0000001B,
		0x03F, 0x00025A58,
		0x033, 0x00000016,
		0x03E, 0x0000001C,
		0x03F, 0x00021C58,
		0x033, 0x00000017,
		0x03E, 0x00000014,
		0x03F, 0x00022A58,
		0x033, 0x00000018,
		0x03E, 0x00000013,
		0x03F, 0x00025A58,
		0x033, 0x00000019,
		0x03E, 0x0000001B,
		0x03F, 0x00025A58,
		0x033, 0x0000001A,
		0x03E, 0x00000014,
		0x03F, 0x00022A58,
		0x033, 0x0000001B,
		0x03E, 0x00000014,
		0x03F, 0x00022A58,
		0x033, 0x0000001C,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000001D,
		0x03E, 0x0000001B,
		0x03F, 0x00025A58,
		0x033, 0x0000001E,
		0x03E, 0x00000013,
		0x03F, 0x00021E58,
		0x033, 0x0000001F,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000020,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000021,
		0x03E, 0x0000001C,
		0x03F, 0x0002CD58,
		0x033, 0x00000022,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000023,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000024,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000025,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000026,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000027,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000028,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000029,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000002A,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000002B,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x0000002C,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000002D,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000002E,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000002F,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000030,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000031,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000032,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000033,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000034,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000035,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000036,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000037,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000038,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000039,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000003A,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000003B,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x0000003C,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000003D,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000003E,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000003F,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000031,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x033, 0x00000002,
		0x03F, 0x00000015,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EC, 0x00000400,
		0x033, 0x00000003,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000021,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
		0x0A7, 0x00080308,
		0x066, 0x00006000,
		0x0EF, 0x00000400,
		0x030, 0x000001FF,
		0x030, 0x000081FF,
		0x030, 0x000101FF,
		0x030, 0x000181FF,
		0x030, 0x000201FF,
		0x030, 0x000281FF,
		0x030, 0x000300FF,
		0x030, 0x000380FB,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06D, 0x00000C31,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
		0x0EF, 0x00000200,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
		0x0EF, 0x00000000,
		0x0EB, 0x00080000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
		0x030, 0x0003803C,
		0x030, 0x0004003C,
		0x030, 0x0004803C,
		0x030, 0x0005003C,
		0x030, 0x0005803C,
		0x030, 0x0006003C,
		0x030, 0x0006803C,
		0x030, 0x0007003C,
		0x0EB, 0x00000000,
		0x094, 0x000000FC,
		0x095, 0x00000008,
		0x0EE, 0x00001000,
		0x033, 0x00000020,
		0x03F, 0x00000152,
		0x033, 0x00000024,
		0x03F, 0x0000015A,
		0x033, 0x00000028,
		0x03F, 0x0000019C,
		0x033, 0x0000002C,
		0x03F, 0x000001A4,
		0x033, 0x00000030,
		0x03F, 0x000001E6,
		0x033, 0x00000034,
		0x03F, 0x000002E6,
		0x033, 0x00000038,
		0x03F, 0x000002E7,
		0x033, 0x0000003C,
		0x03F, 0x000003E7,
		0x033, 0x00000021,
		0x03F, 0x00000152,
		0x033, 0x00000025,
		0x03F, 0x0000015A,
		0x033, 0x00000029,
		0x03F, 0x0000019C,
		0x033, 0x0000002D,
		0x03F, 0x000001A4,
		0x033, 0x00000031,
		0x03F, 0x000001E6,
		0x033, 0x00000035,
		0x03F, 0x000002E6,
		0x033, 0x00000039,
		0x03F, 0x000002E7,
		0x033, 0x0000003D,
		0x03F, 0x000003E7,
		0x033, 0x00000022,
		0x03F, 0x00000152,
		0x033, 0x00000026,
		0x03F, 0x0000015A,
		0x033, 0x0000002A,
		0x03F, 0x0000019C,
		0x033, 0x0000002E,
		0x03F, 0x000001A4,
		0x033, 0x00000032,
		0x03F, 0x000001E6,
		0x033, 0x00000036,
		0x03F, 0x000002E6,
		0x033, 0x0000003A,
		0x03F, 0x000002E7,
		0x033, 0x0000003E,
		0x03F, 0x000003E7,
		0x033, 0x00000060,
		0x03F, 0x00000152,
		0x033, 0x00000064,
		0x03F, 0x0000015A,
		0x033, 0x00000068,
		0x03F, 0x0000019C,
		0x033, 0x0000006C,
		0x03F, 0x000001A4,
		0x033, 0x00000070,
		0x03F, 0x000001E6,
		0x033, 0x00000074,
		0x03F, 0x000002E6,
		0x033, 0x00000078,
		0x03F, 0x000002E7,
		0x033, 0x0000007C,
		0x03F, 0x000003E7,
		0x033, 0x00000061,
		0x03F, 0x00000152,
		0x033, 0x00000065,
		0x03F, 0x0000015A,
		0x033, 0x00000069,
		0x03F, 0x0000019C,
		0x033, 0x0000006D,
		0x03F, 0x000001A4,
		0x033, 0x00000071,
		0x03F, 0x000001E6,
		0x033, 0x00000075,
		0x03F, 0x000002E6,
		0x033, 0x00000079,
		0x03F, 0x000002E7,
		0x033, 0x0000007D,
		0x03F, 0x000003E7,
		0x033, 0x00000062,
		0x03F, 0x00000152,
		0x033, 0x00000066,
		0x03F, 0x0000015A,
		0x033, 0x0000006A,
		0x03F, 0x0000019C,
		0x033, 0x0000006E,
		0x03F, 0x000001A4,
		0x033, 0x00000072,
		0x03F, 0x000001E6,
		0x033, 0x00000076,
		0x03F, 0x000002E6,
		0x033, 0x0000007A,
		0x03F, 0x000002E7,
		0x033, 0x0000007E,
		0x03F, 0x000003E7,
		0x033, 0x00000063,
		0x03F, 0x00000152,
		0x033, 0x00000067,
		0x03F, 0x0000015A,
		0x033, 0x0000006B,
		0x03F, 0x0000019C,
		0x033, 0x0000006F,
		0x03F, 0x000001A4,
		0x033, 0x00000073,
		0x03F, 0x000001E6,
		0x033, 0x00000077,
		0x03F, 0x000002E6,
		0x033, 0x0000007B,
		0x03F, 0x000002E7,
		0x033, 0x0000007F,
		0x03F, 0x000003E7,
		0x0EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10030, 0x000000FC,
		0x10030, 0x000004F9,
		0x10030, 0x000008F6,
		0x10030, 0x00000CF3,
		0x10030, 0x000010F0,
		0x10030, 0x000014ED,
		0x10030, 0x000018AC,
		0x10030, 0x00001CA9,
		0x10030, 0x00002069,
		0x10030, 0x00002466,
		0x10030, 0x00002829,
		0x10030, 0x00002C26,
		0x10030, 0x00003023,
		0x10030, 0x00003420,
		0x10030, 0x0000381D,
		0x10030, 0x00003C1A,
		0x10030, 0x00004017,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
		0x10030, 0x000600F6,
		0x10030, 0x000604F3,
		0x10030, 0x000608F0,
		0x10030, 0x00060CED,
		0x10030, 0x000610EA,
		0x10030, 0x000614E7,
		0x10030, 0x000618E4,
		0x10030, 0x00061CE1,
		0x10030, 0x000620DE,
		0x10030, 0x000624DB,
		0x10030, 0x000628D8,
		0x10030, 0x00062CD5,
		0x10030, 0x000630D2,
		0x10030, 0x000634CF,
		0x10030, 0x000638CC,
		0x10030, 0x00063C09,
		0x10030, 0x00064006,
		0x10030, 0x000680F5,
		0x10030, 0x000684F2,
		0x10030, 0x000688EF,
		0x10030, 0x00068CEC,
		0x10030, 0x000690E9,
		0x10030, 0x000694E6,
		0x10030, 0x000698E3,
		0x10030, 0x00069CE0,
		0x10030, 0x0006A0DD,
		0x10030, 0x0006A4DA,
		0x10030, 0x0006A8D7,
		0x10030, 0x0006ACD4,
		0x10030, 0x0006B0D1,
		0x10030, 0x0006B4CE,
		0x10030, 0x0006B8CB,
		0x10030, 0x0006BC08,
		0x10030, 0x0006C005,
		0x10030, 0x000700F5,
		0x10030, 0x000704F2,
		0x10030, 0x000708EF,
		0x10030, 0x00070CEC,
		0x10030, 0x000710E9,
		0x10030, 0x000714E6,
		0x10030, 0x000718E3,
		0x10030, 0x00071CE0,
		0x10030, 0x000720DD,
		0x10030, 0x000724DA,
		0x10030, 0x000728D7,
		0x10030, 0x00072CD4,
		0x10030, 0x000730D1,
		0x10030, 0x000734CE,
		0x10030, 0x000738CB,
		0x10030, 0x00073C08,
		0x10030, 0x00074005,
		0x10030, 0x000780F4,
		0x10030, 0x000784F1,
		0x10030, 0x000788EE,
		0x10030, 0x00078CEB,
		0x10030, 0x000790E8,
		0x10030, 0x000794E5,
		0x10030, 0x000798E2,
		0x10030, 0x00079CDF,
		0x10030, 0x0007A0DC,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D6,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B0D0,
		0x10030, 0x0007B4CD,
		0x10030, 0x0007B8CA,
		0x10030, 0x0007BC07,
		0x10030, 0x0007C004,
		0x100EE, 0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000008,
		0x03F, 0x00000004,
		0x033, 0x00000009,
		0x03F, 0x00000003,
		0x033, 0x0000000A,
		0x03F, 0x00000003,
		0x033, 0x0000000B,
		0x03F, 0x00000002,
		0x033, 0x0000000C,
		0x03F, 0x00000002,
		0x033, 0x0000000D,
		0x03F, 0x00000002,
		0x033, 0x0000000E,
		0x03F, 0x00000002,
		0x033, 0x0000000F,
		0x03F, 0x00000002,
		0x0EF, 0x00000000,
		0x0EB, 0x00040000,
		0x030, 0x000109B7,
		0x0EB, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00050002,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00008001,
		0x033, 0x00000025,
		0x03F, 0x00008002,
		0x033, 0x00000026,
		0x03F, 0x00000003,
		0x033, 0x00000027,
		0x03F, 0x00000003,
		0x033, 0x00000028,
		0x03F, 0x00050002,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00008001,
		0x033, 0x0000002D,
		0x03F, 0x00008002,
		0x033, 0x0000002E,
		0x03F, 0x00000003,
		0x033, 0x0000002F,
		0x03F, 0x00000003,
		0x033, 0x00000030,
		0x03F, 0x00050002,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00008001,
		0x033, 0x00000035,
		0x03F, 0x00008002,
		0x033, 0x00000036,
		0x03F, 0x00000003,
		0x033, 0x00000037,
		0x03F, 0x00000003,
		0x033, 0x00000060,
		0x03F, 0x00050002,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00008001,
		0x033, 0x00000065,
		0x03F, 0x00008002,
		0x033, 0x00000066,
		0x03F, 0x00000003,
		0x033, 0x00000067,
		0x03F, 0x00000003,
		0x033, 0x00000068,
		0x03F, 0x00050002,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00008001,
		0x033, 0x0000006D,
		0x03F, 0x00008002,
		0x033, 0x0000006E,
		0x03F, 0x00000003,
		0x033, 0x0000006F,
		0x03F, 0x00000003,
		0x033, 0x00000070,
		0x03F, 0x00050002,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00008001,
		0x033, 0x00000075,
		0x03F, 0x00008002,
		0x033, 0x00000076,
		0x03F, 0x00000003,
		0x033, 0x00000077,
		0x03F, 0x00000003,
		0x033, 0x00000078,
		0x03F, 0x00050002,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00008001,
		0x033, 0x0000007D,
		0x03F, 0x00008002,
		0x033, 0x0000007E,
		0x03F, 0x00000003,
		0x033, 0x0000007F,
		0x03F, 0x00000003,
		0x033, 0x000000A0,
		0x03F, 0x00050002,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00008001,
		0x033, 0x000000A5,
		0x03F, 0x00008002,
		0x033, 0x000000A6,
		0x03F, 0x00000003,
		0x033, 0x000000A7,
		0x03F, 0x00000003,
		0x033, 0x000000A8,
		0x03F, 0x00050002,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00008001,
		0x033, 0x000000AD,
		0x03F, 0x00008002,
		0x033, 0x000000AE,
		0x03F, 0x00000003,
		0x033, 0x000000AF,
		0x03F, 0x00000003,
		0x033, 0x000000B0,
		0x03F, 0x00050002,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00008001,
		0x033, 0x000000B5,
		0x03F, 0x00008002,
		0x033, 0x000000B6,
		0x03F, 0x00000003,
		0x033, 0x000000B7,
		0x03F, 0x00000003,
		0x033, 0x000000E0,
		0x03F, 0x00050002,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00008001,
		0x033, 0x000000E5,
		0x03F, 0x00008002,
		0x033, 0x000000E6,
		0x03F, 0x00000003,
		0x033, 0x000000E7,
		0x03F, 0x00000003,
		0x033, 0x000000E8,
		0x03F, 0x00050002,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00008001,
		0x033, 0x000000ED,
		0x03F, 0x00008002,
		0x033, 0x000000EE,
		0x03F, 0x00000003,
		0x033, 0x000000EF,
		0x03F, 0x00000003,
		0x033, 0x000000F0,
		0x03F, 0x00050002,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00008001,
		0x033, 0x000000F5,
		0x03F, 0x00008002,
		0x033, 0x000000F6,
		0x03F, 0x00000003,
		0x033, 0x000000F7,
		0x03F, 0x00000003,
		0x033, 0x000000F8,
		0x03F, 0x00050002,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00008001,
		0x033, 0x000000FD,
		0x03F, 0x00008002,
		0x033, 0x000000FE,
		0x03F, 0x00000003,
		0x033, 0x000000FF,
		0x03F, 0x00000003,
		0x033, 0x00000120,
		0x03F, 0x00050002,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00008001,
		0x033, 0x00000125,
		0x03F, 0x00008002,
		0x033, 0x00000126,
		0x03F, 0x00000003,
		0x033, 0x00000127,
		0x03F, 0x00000003,
		0x033, 0x00000128,
		0x03F, 0x00050002,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00008001,
		0x033, 0x0000012D,
		0x03F, 0x00008002,
		0x033, 0x0000012E,
		0x03F, 0x00000003,
		0x033, 0x0000012F,
		0x03F, 0x00000003,
		0x033, 0x00000130,
		0x03F, 0x00050002,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00008001,
		0x033, 0x00000135,
		0x03F, 0x00008002,
		0x033, 0x00000136,
		0x03F, 0x00000003,
		0x033, 0x00000137,
		0x03F, 0x00000003,
		0x033, 0x00000160,
		0x03F, 0x00050002,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00008001,
		0x033, 0x00000165,
		0x03F, 0x00008002,
		0x033, 0x00000166,
		0x03F, 0x00000003,
		0x033, 0x00000167,
		0x03F, 0x00000003,
		0x033, 0x00000168,
		0x03F, 0x00050002,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00008001,
		0x033, 0x0000016D,
		0x03F, 0x00008002,
		0x033, 0x0000016E,
		0x03F, 0x00000003,
		0x033, 0x0000016F,
		0x03F, 0x00000003,
		0x033, 0x00000170,
		0x03F, 0x00050002,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00008001,
		0x033, 0x00000175,
		0x03F, 0x00008002,
		0x033, 0x00000176,
		0x03F, 0x00000003,
		0x033, 0x00000177,
		0x03F, 0x00000003,
		0x033, 0x00000178,
		0x03F, 0x00050002,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00008001,
		0x033, 0x0000017D,
		0x03F, 0x00008002,
		0x033, 0x0000017E,
		0x03F, 0x00000003,
		0x033, 0x0000017F,
		0x03F, 0x00000003,
		0x033, 0x000001A0,
		0x03F, 0x00050002,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00008001,
		0x033, 0x000001A5,
		0x03F, 0x00008002,
		0x033, 0x000001A6,
		0x03F, 0x00000003,
		0x033, 0x000001A7,
		0x03F, 0x00000003,
		0x033, 0x000001A8,
		0x03F, 0x00050002,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00008001,
		0x033, 0x000001AD,
		0x03F, 0x00008002,
		0x033, 0x000001AE,
		0x03F, 0x00000003,
		0x033, 0x000001AF,
		0x03F, 0x00000003,
		0x033, 0x000001B0,
		0x03F, 0x00050002,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00008001,
		0x033, 0x000001B5,
		0x03F, 0x00008002,
		0x033, 0x000001B6,
		0x03F, 0x00000003,
		0x033, 0x000001B7,
		0x03F, 0x00000003,
		0x033, 0x000001E0,
		0x03F, 0x00050002,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00008001,
		0x033, 0x000001E5,
		0x03F, 0x00008002,
		0x033, 0x000001E6,
		0x03F, 0x00000003,
		0x033, 0x000001E7,
		0x03F, 0x00000003,
		0x033, 0x000001E8,
		0x03F, 0x00050002,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00008001,
		0x033, 0x000001ED,
		0x03F, 0x00008002,
		0x033, 0x000001EE,
		0x03F, 0x00000003,
		0x033, 0x000001EF,
		0x03F, 0x00000003,
		0x033, 0x000001F0,
		0x03F, 0x00050002,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00008001,
		0x033, 0x000001F5,
		0x03F, 0x00008002,
		0x033, 0x000001F6,
		0x03F, 0x00000003,
		0x033, 0x000001F7,
		0x03F, 0x00000003,
		0x033, 0x000001F8,
		0x03F, 0x00050002,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00008001,
		0x033, 0x000001FD,
		0x03F, 0x00008002,
		0x033, 0x000001FE,
		0x03F, 0x00000003,
		0x033, 0x000001FF,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x005, 0x00000001,
		0x10005, 0x00000001,
		0x100EE, 0x00000400,
		0x10030, 0x00000000,
		0x10030, 0x00001000,
		0x10030, 0x00002000,
		0x10030, 0x00003000,
		0x10030, 0x00004000,
		0x10030, 0x00005000,
		0x10030, 0x00006003,
		0x10030, 0x00007003,
		0x10030, 0x00008000,
		0x10030, 0x00009000,
		0x10030, 0x0000A000,
		0x10030, 0x0000B000,
		0x10030, 0x0000C000,
		0x10030, 0x0000D000,
		0x10030, 0x0000E003,
		0x10030, 0x0000F003,
		0x10030, 0x00010000,
		0x10030, 0x00011000,
		0x10030, 0x00012000,
		0x10030, 0x00013000,
		0x10030, 0x00014000,
		0x10030, 0x00015000,
		0x10030, 0x00016003,
		0x10030, 0x00017003,
		0x10030, 0x00018000,
		0x10030, 0x00019000,
		0x10030, 0x0001A000,
		0x10030, 0x0001B000,
		0x10030, 0x0001C000,
		0x10030, 0x0001D000,
		0x10030, 0x0001E003,
		0x10030, 0x0001F003,
		0x10030, 0x00020000,
		0x10030, 0x00021000,
		0x10030, 0x00022000,
		0x10030, 0x00023000,
		0x10030, 0x00024000,
		0x10030, 0x00025003,
		0x10030, 0x00026003,
		0x10030, 0x00027003,
		0x10030, 0x00028000,
		0x10030, 0x00029000,
		0x10030, 0x0002A000,
		0x10030, 0x0002B000,
		0x10030, 0x0002C000,
		0x10030, 0x0002D003,
		0x10030, 0x0002E003,
		0x10030, 0x0002F003,
		0x10030, 0x00030000,
		0x10030, 0x00031000,
		0x10030, 0x00032000,
		0x10030, 0x00033000,
		0x10030, 0x00034000,
		0x10030, 0x00035003,
		0x10030, 0x00036003,
		0x10030, 0x00037003,
		0x10030, 0x00038000,
		0x10030, 0x00039000,
		0x10030, 0x0003A000,
		0x10030, 0x0003B000,
		0x10030, 0x0003C000,
		0x10030, 0x0003D003,
		0x10030, 0x0003E003,
		0x10030, 0x0003F003,
		0x10030, 0x00060000,
		0x10030, 0x00061000,
		0x10030, 0x00062000,
		0x10030, 0x00063000,
		0x10030, 0x00064000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
		0x10030, 0x00067003,
		0x10030, 0x00068000,
		0x10030, 0x00069000,
		0x10030, 0x0006A000,
		0x10030, 0x0006B000,
		0x10030, 0x0006C000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
		0x10030, 0x0006F003,
		0x10030, 0x00070000,
		0x10030, 0x00071000,
		0x10030, 0x00072000,
		0x10030, 0x00073000,
		0x10030, 0x00074000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
		0x10030, 0x00077003,
		0x10030, 0x00078000,
		0x10030, 0x00079000,
		0x10030, 0x0007A000,
		0x10030, 0x0007B000,
		0x10030, 0x0007C000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
		0x10030, 0x0007F003,
		0x100EE, 0x00000000,
		0x0FE, 0x00000007,

};


/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8832d_radiob[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0030000, 0x00000002,
		0xF0040000, 0x00000003,
		0x005, 0x00000000,
		0x10005, 0x00000000,
		0x0B9, 0x00020440,
		0x000, 0x00030001,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x0A3, 0x000B9204,
		0x0AD, 0x00091E0F,
		0x05D, 0x00001012,
		0x05C, 0x00079C5C,
		0x062, 0x00055220,
		0x0D3, 0x00000103,
		0x05F, 0x00000038,
		0x097, 0x00043200,
		0x0A6, 0x00066DB7,
		0x0EF, 0x00004000,
		0x033, 0x00000005,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x00000004,
		0x03E, 0x00000000,
		0x03F, 0x00000400,
		0x033, 0x00000003,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x00000002,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x00000001,
		0x03E, 0x00000000,
		0x03F, 0x00001A00,
		0x033, 0x00000000,
		0x03E, 0x00000000,
		0x03F, 0x00002900,
		0x033, 0x0000000D,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x0000000C,
		0x03E, 0x00000000,
		0x03F, 0x00000400,
		0x033, 0x0000000B,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x0000000A,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x00000009,
		0x03E, 0x00000000,
		0x03F, 0x00001A00,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x00002900,
		0x033, 0x00000015,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x00000014,
		0x03E, 0x00000000,
		0x03F, 0x00000400,
		0x033, 0x00000013,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x00000012,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x00000011,
		0x03E, 0x00000000,
		0x03F, 0x00001A00,
		0x033, 0x00000010,
		0x03E, 0x00000000,
		0x03F, 0x00002900,
		0x0EF, 0x00000000,
		0x10055, 0x00080080,
		0x000, 0x00033C01,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x096, 0x00015200,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
		0x057, 0x0000D589,
		0x05A, 0x0007F0F8,
		0x043, 0x00005000,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000000,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
		0x08F, 0x000D1352,
		0x0EB, 0x00000000,
		0x030, 0x000109B0,
		0x030, 0x000189B0,
		0x0EB, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
		0x03F, 0x00000017,
		0x033, 0x00000004,
		0x03F, 0x00000017,
		0x033, 0x00000005,
		0x03F, 0x00000007,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00060001,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00000001,
		0x033, 0x00000025,
		0x03F, 0x00000002,
		0x033, 0x00000026,
		0x03F, 0x00000003,
		0x033, 0x00000027,
		0x03F, 0x00000003,
		0x033, 0x00000028,
		0x03F, 0x00060001,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00000001,
		0x033, 0x0000002D,
		0x03F, 0x00000002,
		0x033, 0x0000002E,
		0x03F, 0x00000003,
		0x033, 0x0000002F,
		0x03F, 0x00000003,
		0x033, 0x00000030,
		0x03F, 0x00060001,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00000001,
		0x033, 0x00000035,
		0x03F, 0x00000002,
		0x033, 0x00000036,
		0x03F, 0x00000003,
		0x033, 0x00000037,
		0x03F, 0x00000003,
		0x033, 0x00000060,
		0x03F, 0x00060001,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00000001,
		0x033, 0x00000065,
		0x03F, 0x00000002,
		0x033, 0x00000066,
		0x03F, 0x00000003,
		0x033, 0x00000067,
		0x03F, 0x00000003,
		0x033, 0x00000068,
		0x03F, 0x00060001,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00000001,
		0x033, 0x0000006D,
		0x03F, 0x00000002,
		0x033, 0x0000006E,
		0x03F, 0x00000003,
		0x033, 0x0000006F,
		0x03F, 0x00000003,
		0x033, 0x00000070,
		0x03F, 0x00060001,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00000001,
		0x033, 0x00000075,
		0x03F, 0x00000002,
		0x033, 0x00000076,
		0x03F, 0x00000003,
		0x033, 0x00000077,
		0x03F, 0x00000003,
		0x033, 0x00000078,
		0x03F, 0x00060001,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00000001,
		0x033, 0x0000007D,
		0x03F, 0x00000002,
		0x033, 0x0000007E,
		0x03F, 0x00000003,
		0x033, 0x0000007F,
		0x03F, 0x00000003,
		0x033, 0x000000A0,
		0x03F, 0x00060001,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00000001,
		0x033, 0x000000A5,
		0x03F, 0x00000002,
		0x033, 0x000000A6,
		0x03F, 0x00000003,
		0x033, 0x000000A7,
		0x03F, 0x00000003,
		0x033, 0x000000A8,
		0x03F, 0x00060001,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00000001,
		0x033, 0x000000AD,
		0x03F, 0x00000002,
		0x033, 0x000000AE,
		0x03F, 0x00000003,
		0x033, 0x000000AF,
		0x03F, 0x00000003,
		0x033, 0x000000B0,
		0x03F, 0x00060001,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00000001,
		0x033, 0x000000B5,
		0x03F, 0x00000002,
		0x033, 0x000000B6,
		0x03F, 0x00000003,
		0x033, 0x000000B7,
		0x03F, 0x00000003,
		0x033, 0x000000E0,
		0x03F, 0x00060001,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00000001,
		0x033, 0x000000E5,
		0x03F, 0x00000002,
		0x033, 0x000000E6,
		0x03F, 0x00000003,
		0x033, 0x000000E7,
		0x03F, 0x00000003,
		0x033, 0x000000E8,
		0x03F, 0x00060001,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00000001,
		0x033, 0x000000ED,
		0x03F, 0x00000002,
		0x033, 0x000000EE,
		0x03F, 0x00000003,
		0x033, 0x000000EF,
		0x03F, 0x00000003,
		0x033, 0x000000F0,
		0x03F, 0x00060001,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00000001,
		0x033, 0x000000F5,
		0x03F, 0x00000002,
		0x033, 0x000000F6,
		0x03F, 0x00000003,
		0x033, 0x000000F7,
		0x03F, 0x00000003,
		0x033, 0x000000F8,
		0x03F, 0x00060001,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00000001,
		0x033, 0x000000FD,
		0x03F, 0x00000002,
		0x033, 0x000000FE,
		0x03F, 0x00000003,
		0x033, 0x000000FF,
		0x03F, 0x00000003,
		0x033, 0x00000120,
		0x03F, 0x00060001,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00000001,
		0x033, 0x00000125,
		0x03F, 0x00000002,
		0x033, 0x00000126,
		0x03F, 0x00000003,
		0x033, 0x00000127,
		0x03F, 0x00000003,
		0x033, 0x00000128,
		0x03F, 0x00060001,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00000001,
		0x033, 0x0000012D,
		0x03F, 0x00000002,
		0x033, 0x0000012E,
		0x03F, 0x00000003,
		0x033, 0x0000012F,
		0x03F, 0x00000003,
		0x033, 0x00000130,
		0x03F, 0x00060001,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00000001,
		0x033, 0x00000135,
		0x03F, 0x00000002,
		0x033, 0x00000136,
		0x03F, 0x00000003,
		0x033, 0x00000137,
		0x03F, 0x00000003,
		0x033, 0x00000160,
		0x03F, 0x00060001,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00000001,
		0x033, 0x00000165,
		0x03F, 0x00000002,
		0x033, 0x00000166,
		0x03F, 0x00000003,
		0x033, 0x00000167,
		0x03F, 0x00000003,
		0x033, 0x00000168,
		0x03F, 0x00060001,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00000001,
		0x033, 0x0000016D,
		0x03F, 0x00000002,
		0x033, 0x0000016E,
		0x03F, 0x00000003,
		0x033, 0x0000016F,
		0x03F, 0x00000003,
		0x033, 0x00000170,
		0x03F, 0x00060001,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00000001,
		0x033, 0x00000175,
		0x03F, 0x00000002,
		0x033, 0x00000176,
		0x03F, 0x00000003,
		0x033, 0x00000177,
		0x03F, 0x00000003,
		0x033, 0x00000178,
		0x03F, 0x00060001,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00000001,
		0x033, 0x0000017D,
		0x03F, 0x00000002,
		0x033, 0x0000017E,
		0x03F, 0x00000003,
		0x033, 0x0000017F,
		0x03F, 0x00000003,
		0x033, 0x000001A0,
		0x03F, 0x00060001,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00000001,
		0x033, 0x000001A5,
		0x03F, 0x00000002,
		0x033, 0x000001A6,
		0x03F, 0x00000003,
		0x033, 0x000001A7,
		0x03F, 0x00000003,
		0x033, 0x000001A8,
		0x03F, 0x00060001,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00000001,
		0x033, 0x000001AD,
		0x03F, 0x00000002,
		0x033, 0x000001AE,
		0x03F, 0x00000003,
		0x033, 0x000001AF,
		0x03F, 0x00000003,
		0x033, 0x000001B0,
		0x03F, 0x00060001,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00000001,
		0x033, 0x000001B5,
		0x03F, 0x00000002,
		0x033, 0x000001B6,
		0x03F, 0x00000003,
		0x033, 0x000001B7,
		0x03F, 0x00000003,
		0x033, 0x000001E0,
		0x03F, 0x00060001,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00000001,
		0x033, 0x000001E5,
		0x03F, 0x00000002,
		0x033, 0x000001E6,
		0x03F, 0x00000003,
		0x033, 0x000001E7,
		0x03F, 0x00000003,
		0x033, 0x000001E8,
		0x03F, 0x00060001,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00000001,
		0x033, 0x000001ED,
		0x03F, 0x00000002,
		0x033, 0x000001EE,
		0x03F, 0x00000003,
		0x033, 0x000001EF,
		0x03F, 0x00000003,
		0x033, 0x000001F0,
		0x03F, 0x00060001,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00000001,
		0x033, 0x000001F5,
		0x03F, 0x00000002,
		0x033, 0x000001F6,
		0x03F, 0x00000003,
		0x033, 0x000001F7,
		0x03F, 0x00000003,
		0x033, 0x000001F8,
		0x03F, 0x00060001,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00000001,
		0x033, 0x000001FD,
		0x03F, 0x00000002,
		0x033, 0x000001FE,
		0x03F, 0x00000003,
		0x033, 0x000001FF,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x0000EFFF,
		0x033, 0x00000002,
		0x03F, 0x0000EFFF,
		0x033, 0x00000003,
		0x03F, 0x0000EFFF,
		0x033, 0x00000004,
		0x03F, 0x0000EFFF,
		0x033, 0x00000005,
		0x03F, 0x0000EFFF,
		0x033, 0x00000006,
		0x03F, 0x0000EFFF,
		0x033, 0x00000007,
		0x03F, 0x0000EFFF,
		0x033, 0x00000008,
		0x03F, 0x0000EFFF,
		0x033, 0x00000009,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000A,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000B,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000C,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000D,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000E,
		0x03F, 0x0000EFFF,
		0x033, 0x0000000F,
		0x03F, 0x0000EFFF,
		0x033, 0x00000010,
		0x03F, 0x0000EFFF,
		0x033, 0x00000011,
		0x03F, 0x0000EFFF,
		0x033, 0x00000012,
		0x03F, 0x0000EFFF,
		0x033, 0x00000013,
		0x03F, 0x0000EFFF,
		0x033, 0x00000014,
		0x03F, 0x0000EFFF,
		0x033, 0x00000015,
		0x03F, 0x0000EFFF,
		0x033, 0x00000016,
		0x03F, 0x0000EFFF,
		0x033, 0x00000017,
		0x03F, 0x0000EFFF,
		0x033, 0x00000018,
		0x03F, 0x0000FBFF,
		0x033, 0x00000019,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001A,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001B,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001C,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001D,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001E,
		0x03F, 0x0000EFFF,
		0x033, 0x0000001F,
		0x03F, 0x0000EFFF,
		0x033, 0x00000020,
		0x03F, 0x0000EFFF,
		0x033, 0x00000021,
		0x03F, 0x0000EFFF,
		0x033, 0x00000022,
		0x03F, 0x0000EFFF,
		0x033, 0x00000023,
		0x03F, 0x0000EFFF,
		0x033, 0x00000024,
		0x03F, 0x0000EFFF,
		0x033, 0x00000025,
		0x03F, 0x0000EFFF,
		0x033, 0x00000026,
		0x03F, 0x0000EFFF,
		0x033, 0x00000027,
		0x03F, 0x0000EFFF,
		0x033, 0x00000028,
		0x03F, 0x0000EFFF,
		0x033, 0x00000029,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002A,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002B,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002C,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002D,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002E,
		0x03F, 0x0000EFFF,
		0x033, 0x0000002F,
		0x03F, 0x0000EFFF,
		0x033, 0x00000030,
		0x03F, 0x0000EFFF,
		0x033, 0x00000031,
		0x03F, 0x0000EFFF,
		0x033, 0x00000032,
		0x03F, 0x0000EFFF,
		0x033, 0x00000033,
		0x03F, 0x0000EFFF,
		0x033, 0x00000034,
		0x03F, 0x0000EFFF,
		0x033, 0x00000035,
		0x03F, 0x0000EFFF,
		0x033, 0x00000036,
		0x03F, 0x0000EFFF,
		0x033, 0x00000037,
		0x03F, 0x0000EFFF,
		0x033, 0x00000038,
		0x03F, 0x0000EFFF,
		0x033, 0x00000039,
		0x03F, 0x0000EFFF,
		0x033, 0x0000003A,
		0x03F, 0x0000EFFF,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00004344,
		0x033, 0x00000001,
		0x03F, 0x00004344,
		0x033, 0x00000002,
		0x03F, 0x00004344,
		0x033, 0x00000003,
		0x03F, 0x00004344,
		0x033, 0x00000004,
		0x03F, 0x00004344,
		0x033, 0x00000005,
		0x03F, 0x00004344,
		0x033, 0x00000006,
		0x03F, 0x00004344,
		0x033, 0x00000007,
		0x03F, 0x00004344,
		0x033, 0x00000008,
		0x03F, 0x00004344,
		0x033, 0x00000009,
		0x03F, 0x00004344,
		0x033, 0x0000000A,
		0x03F, 0x00004344,
		0x033, 0x0000000B,
		0x03F, 0x00004344,
		0x033, 0x00000010,
		0x03F, 0x00004344,
		0x033, 0x00000011,
		0x03F, 0x00004344,
		0x033, 0x00000012,
		0x03F, 0x00004344,
		0x033, 0x00000013,
		0x03F, 0x00004344,
		0x033, 0x00000014,
		0x03F, 0x00004344,
		0x033, 0x00000015,
		0x03F, 0x00004344,
		0x033, 0x00000016,
		0x03F, 0x00004344,
		0x033, 0x00000017,
		0x03F, 0x00004344,
		0x033, 0x00000018,
		0x03F, 0x00004344,
		0x033, 0x00000019,
		0x03F, 0x00004344,
		0x033, 0x0000001A,
		0x03F, 0x00004344,
		0x033, 0x0000001B,
		0x03F, 0x00004344,
		0x033, 0x0000001C,
		0x03F, 0x00004344,
		0x033, 0x0000001D,
		0x03F, 0x00004344,
		0x033, 0x0000001E,
		0x03F, 0x00004344,
		0x033, 0x0000001F,
		0x03F, 0x00004344,
		0x0EF, 0x00000000,
		0x0EF, 0x00000020,
		0x033, 0x00000010,
		0x03F, 0x00000200,
		0x033, 0x00000011,
		0x03F, 0x00000200,
		0x033, 0x00000012,
		0x03F, 0x00000200,
		0x033, 0x00000013,
		0x03F, 0x00000200,
		0x033, 0x00000020,
		0x03F, 0x00000200,
		0x033, 0x00000021,
		0x03F, 0x00000200,
		0x033, 0x00000022,
		0x03F, 0x00000200,
		0x033, 0x00000023,
		0x03F, 0x00000200,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
		0x030, 0x00068000,
		0x030, 0x00070000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000004,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000005,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000006,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x00000007,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000008,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000009,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x0000000A,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x0000000B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000000C,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x0000000D,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x0000000E,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x0000000F,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000010,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000011,
		0x03E, 0x0000001B,
		0x03F, 0x00022A58,
		0x033, 0x00000012,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x00000013,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000014,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000015,
		0x03E, 0x0000001B,
		0x03F, 0x00029858,
		0x033, 0x00000016,
		0x03E, 0x0000001C,
		0x03F, 0x00023958,
		0x033, 0x00000017,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000018,
		0x03E, 0x00000013,
		0x03F, 0x00029858,
		0x033, 0x00000019,
		0x03E, 0x0000001B,
		0x03F, 0x00029858,
		0x033, 0x0000001A,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000001B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000001C,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000001D,
		0x03E, 0x0000001B,
		0x03F, 0x00029858,
		0x033, 0x0000001E,
		0x03E, 0x00000013,
		0x03F, 0x00023A58,
		0x033, 0x0000001F,
		0x03E, 0x00000013,
		0x03F, 0x00023A58,
		0x033, 0x00000020,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000021,
		0x03E, 0x0000001C,
		0x03F, 0x0002AC58,
		0x033, 0x00000022,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000023,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000024,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000025,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000026,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000027,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000028,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000029,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000002A,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000002B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000002C,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000002D,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000002E,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000002F,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000030,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000031,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000032,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000033,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000034,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000035,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000036,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000037,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000038,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000039,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000003A,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000003B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000003C,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000003D,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000003E,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000003F,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000031,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x033, 0x00000002,
		0x03F, 0x00000015,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EC, 0x00000400,
		0x033, 0x00000003,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000021,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
		0x0A7, 0x00080308,
		0x066, 0x00006000,
		0x0EF, 0x00000400,
		0x030, 0x000001FF,
		0x030, 0x000081FF,
		0x030, 0x000101FF,
		0x030, 0x000181FF,
		0x030, 0x000201FF,
		0x030, 0x000281FF,
		0x030, 0x0003017F,
		0x030, 0x000380FB,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06D, 0x00000C31,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
		0x0EF, 0x00000200,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
		0x0EF, 0x00000000,
		0x0EB, 0x00080000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
		0x030, 0x0003803C,
		0x030, 0x0004003C,
		0x030, 0x0004803C,
		0x030, 0x0005003C,
		0x030, 0x0005803C,
		0x030, 0x0006003C,
		0x030, 0x0006803C,
		0x030, 0x0007003C,
		0x0EB, 0x00000000,
		0x094, 0x000000FC,
		0x095, 0x00000008,
		0x0EE, 0x00001000,
		0x033, 0x00000020,
		0x03F, 0x00000152,
		0x033, 0x00000024,
		0x03F, 0x0000015A,
		0x033, 0x00000028,
		0x03F, 0x0000019C,
		0x033, 0x0000002C,
		0x03F, 0x000001A4,
		0x033, 0x00000030,
		0x03F, 0x000001E6,
		0x033, 0x00000034,
		0x03F, 0x000002E6,
		0x033, 0x00000038,
		0x03F, 0x000002E7,
		0x033, 0x0000003C,
		0x03F, 0x000003E7,
		0x033, 0x00000021,
		0x03F, 0x00000152,
		0x033, 0x00000025,
		0x03F, 0x0000015A,
		0x033, 0x00000029,
		0x03F, 0x0000019C,
		0x033, 0x0000002D,
		0x03F, 0x000001A4,
		0x033, 0x00000031,
		0x03F, 0x000001E6,
		0x033, 0x00000035,
		0x03F, 0x000002E6,
		0x033, 0x00000039,
		0x03F, 0x000002E7,
		0x033, 0x0000003D,
		0x03F, 0x000003E7,
		0x033, 0x00000022,
		0x03F, 0x00000152,
		0x033, 0x00000026,
		0x03F, 0x0000015A,
		0x033, 0x0000002A,
		0x03F, 0x0000019C,
		0x033, 0x0000002E,
		0x03F, 0x000001A4,
		0x033, 0x00000032,
		0x03F, 0x000001E6,
		0x033, 0x00000036,
		0x03F, 0x000002E6,
		0x033, 0x0000003A,
		0x03F, 0x000002E7,
		0x033, 0x0000003E,
		0x03F, 0x000003E7,
		0x033, 0x00000060,
		0x03F, 0x00000152,
		0x033, 0x00000064,
		0x03F, 0x0000015A,
		0x033, 0x00000068,
		0x03F, 0x0000019C,
		0x033, 0x0000006C,
		0x03F, 0x000001A4,
		0x033, 0x00000070,
		0x03F, 0x000001E6,
		0x033, 0x00000074,
		0x03F, 0x000002E6,
		0x033, 0x00000078,
		0x03F, 0x000002E7,
		0x033, 0x0000007C,
		0x03F, 0x000003E7,
		0x033, 0x00000061,
		0x03F, 0x00000152,
		0x033, 0x00000065,
		0x03F, 0x0000015A,
		0x033, 0x00000069,
		0x03F, 0x0000019C,
		0x033, 0x0000006D,
		0x03F, 0x000001A4,
		0x033, 0x00000071,
		0x03F, 0x000001E6,
		0x033, 0x00000075,
		0x03F, 0x000002E6,
		0x033, 0x00000079,
		0x03F, 0x000002E7,
		0x033, 0x0000007D,
		0x03F, 0x000003E7,
		0x033, 0x00000062,
		0x03F, 0x00000152,
		0x033, 0x00000066,
		0x03F, 0x0000015A,
		0x033, 0x0000006A,
		0x03F, 0x0000019C,
		0x033, 0x0000006E,
		0x03F, 0x000001A4,
		0x033, 0x00000072,
		0x03F, 0x000001E6,
		0x033, 0x00000076,
		0x03F, 0x000002E6,
		0x033, 0x0000007A,
		0x03F, 0x000002E7,
		0x033, 0x0000007E,
		0x03F, 0x000003E7,
		0x033, 0x00000063,
		0x03F, 0x00000152,
		0x033, 0x00000067,
		0x03F, 0x0000015A,
		0x033, 0x0000006B,
		0x03F, 0x0000019C,
		0x033, 0x0000006F,
		0x03F, 0x000001A4,
		0x033, 0x00000073,
		0x03F, 0x000001E6,
		0x033, 0x00000077,
		0x03F, 0x000002E6,
		0x033, 0x0000007B,
		0x03F, 0x000002E7,
		0x033, 0x0000007F,
		0x03F, 0x000003E7,
		0x0EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10030, 0x000000FC,
		0x10030, 0x000004F9,
		0x10030, 0x000008F6,
		0x10030, 0x00000CF3,
		0x10030, 0x000010F0,
		0x10030, 0x000014ED,
		0x10030, 0x000018AC,
		0x10030, 0x00001CA9,
		0x10030, 0x00002069,
		0x10030, 0x00002466,
		0x10030, 0x00002829,
		0x10030, 0x00002C26,
		0x10030, 0x00003023,
		0x10030, 0x00003420,
		0x10030, 0x0000381D,
		0x10030, 0x00003C1A,
		0x10030, 0x00004017,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
		0x10030, 0x000600F6,
		0x10030, 0x000604F3,
		0x10030, 0x000608F0,
		0x10030, 0x00060CED,
		0x10030, 0x000610EA,
		0x10030, 0x000614E7,
		0x10030, 0x000618E4,
		0x10030, 0x00061CE1,
		0x10030, 0x000620DE,
		0x10030, 0x000624DB,
		0x10030, 0x000628D8,
		0x10030, 0x00062CD5,
		0x10030, 0x000630D2,
		0x10030, 0x000634CF,
		0x10030, 0x000638CC,
		0x10030, 0x00063C09,
		0x10030, 0x00064006,
		0x10030, 0x000680F5,
		0x10030, 0x000684F2,
		0x10030, 0x000688EF,
		0x10030, 0x00068CEC,
		0x10030, 0x000690E9,
		0x10030, 0x000694E6,
		0x10030, 0x000698E3,
		0x10030, 0x00069CE0,
		0x10030, 0x0006A0DD,
		0x10030, 0x0006A4DA,
		0x10030, 0x0006A8D7,
		0x10030, 0x0006ACD4,
		0x10030, 0x0006B0D1,
		0x10030, 0x0006B4CE,
		0x10030, 0x0006B8CB,
		0x10030, 0x0006BC08,
		0x10030, 0x0006C005,
		0x10030, 0x000700F5,
		0x10030, 0x000704F2,
		0x10030, 0x000708EF,
		0x10030, 0x00070CEC,
		0x10030, 0x000710E9,
		0x10030, 0x000714E6,
		0x10030, 0x000718E3,
		0x10030, 0x00071CE0,
		0x10030, 0x000720DD,
		0x10030, 0x000724DA,
		0x10030, 0x000728D7,
		0x10030, 0x00072CD4,
		0x10030, 0x000730D1,
		0x10030, 0x000734CE,
		0x10030, 0x000738CB,
		0x10030, 0x00073C08,
		0x10030, 0x00074005,
		0x10030, 0x000780F4,
		0x10030, 0x000784F1,
		0x10030, 0x000788EE,
		0x10030, 0x00078CEB,
		0x10030, 0x000790E8,
		0x10030, 0x000794E5,
		0x10030, 0x000798E2,
		0x10030, 0x00079CDF,
		0x10030, 0x0007A0DC,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D6,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B0D0,
		0x10030, 0x0007B4CD,
		0x10030, 0x0007B8CA,
		0x10030, 0x0007BC07,
		0x10030, 0x0007C004,
		0x100EE, 0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000008,
		0x03F, 0x00000004,
		0x033, 0x00000009,
		0x03F, 0x00000003,
		0x033, 0x0000000A,
		0x03F, 0x00000003,
		0x033, 0x0000000B,
		0x03F, 0x00000002,
		0x033, 0x0000000C,
		0x03F, 0x00000002,
		0x033, 0x0000000D,
		0x03F, 0x00000002,
		0x033, 0x0000000E,
		0x03F, 0x00000002,
		0x033, 0x0000000F,
		0x03F, 0x00000002,
		0x0EF, 0x00000000,
		0x0EB, 0x00040000,
		0x030, 0x000109B7,
		0x0EB, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00050002,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00008001,
		0x033, 0x00000025,
		0x03F, 0x00008002,
		0x033, 0x00000026,
		0x03F, 0x00000003,
		0x033, 0x00000027,
		0x03F, 0x00000003,
		0x033, 0x00000028,
		0x03F, 0x00050002,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00008001,
		0x033, 0x0000002D,
		0x03F, 0x00008002,
		0x033, 0x0000002E,
		0x03F, 0x00000003,
		0x033, 0x0000002F,
		0x03F, 0x00000003,
		0x033, 0x00000030,
		0x03F, 0x00050002,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00008001,
		0x033, 0x00000035,
		0x03F, 0x00008002,
		0x033, 0x00000036,
		0x03F, 0x00000003,
		0x033, 0x00000037,
		0x03F, 0x00000003,
		0x033, 0x00000060,
		0x03F, 0x00050002,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00008001,
		0x033, 0x00000065,
		0x03F, 0x00008002,
		0x033, 0x00000066,
		0x03F, 0x00000003,
		0x033, 0x00000067,
		0x03F, 0x00000003,
		0x033, 0x00000068,
		0x03F, 0x00050002,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00008001,
		0x033, 0x0000006D,
		0x03F, 0x00008002,
		0x033, 0x0000006E,
		0x03F, 0x00000003,
		0x033, 0x0000006F,
		0x03F, 0x00000003,
		0x033, 0x00000070,
		0x03F, 0x00050002,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00008001,
		0x033, 0x00000075,
		0x03F, 0x00008002,
		0x033, 0x00000076,
		0x03F, 0x00000003,
		0x033, 0x00000077,
		0x03F, 0x00000003,
		0x033, 0x00000078,
		0x03F, 0x00050002,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00008001,
		0x033, 0x0000007D,
		0x03F, 0x00008002,
		0x033, 0x0000007E,
		0x03F, 0x00000003,
		0x033, 0x0000007F,
		0x03F, 0x00000003,
		0x033, 0x000000A0,
		0x03F, 0x00050002,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00008001,
		0x033, 0x000000A5,
		0x03F, 0x00008002,
		0x033, 0x000000A6,
		0x03F, 0x00000003,
		0x033, 0x000000A7,
		0x03F, 0x00000003,
		0x033, 0x000000A8,
		0x03F, 0x00050002,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00008001,
		0x033, 0x000000AD,
		0x03F, 0x00008002,
		0x033, 0x000000AE,
		0x03F, 0x00000003,
		0x033, 0x000000AF,
		0x03F, 0x00000003,
		0x033, 0x000000B0,
		0x03F, 0x00050002,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00008001,
		0x033, 0x000000B5,
		0x03F, 0x00008002,
		0x033, 0x000000B6,
		0x03F, 0x00000003,
		0x033, 0x000000B7,
		0x03F, 0x00000003,
		0x033, 0x000000E0,
		0x03F, 0x00050002,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00008001,
		0x033, 0x000000E5,
		0x03F, 0x00008002,
		0x033, 0x000000E6,
		0x03F, 0x00000003,
		0x033, 0x000000E7,
		0x03F, 0x00000003,
		0x033, 0x000000E8,
		0x03F, 0x00050002,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00008001,
		0x033, 0x000000ED,
		0x03F, 0x00008002,
		0x033, 0x000000EE,
		0x03F, 0x00000003,
		0x033, 0x000000EF,
		0x03F, 0x00000003,
		0x033, 0x000000F0,
		0x03F, 0x00050002,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00008001,
		0x033, 0x000000F5,
		0x03F, 0x00008002,
		0x033, 0x000000F6,
		0x03F, 0x00000003,
		0x033, 0x000000F7,
		0x03F, 0x00000003,
		0x033, 0x000000F8,
		0x03F, 0x00050002,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00008001,
		0x033, 0x000000FD,
		0x03F, 0x00008002,
		0x033, 0x000000FE,
		0x03F, 0x00000003,
		0x033, 0x000000FF,
		0x03F, 0x00000003,
		0x033, 0x00000120,
		0x03F, 0x00050002,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00008001,
		0x033, 0x00000125,
		0x03F, 0x00008002,
		0x033, 0x00000126,
		0x03F, 0x00000003,
		0x033, 0x00000127,
		0x03F, 0x00000003,
		0x033, 0x00000128,
		0x03F, 0x00050002,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00008001,
		0x033, 0x0000012D,
		0x03F, 0x00008002,
		0x033, 0x0000012E,
		0x03F, 0x00000003,
		0x033, 0x0000012F,
		0x03F, 0x00000003,
		0x033, 0x00000130,
		0x03F, 0x00050002,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00008001,
		0x033, 0x00000135,
		0x03F, 0x00008002,
		0x033, 0x00000136,
		0x03F, 0x00000003,
		0x033, 0x00000137,
		0x03F, 0x00000003,
		0x033, 0x00000160,
		0x03F, 0x00050002,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00008001,
		0x033, 0x00000165,
		0x03F, 0x00008002,
		0x033, 0x00000166,
		0x03F, 0x00000003,
		0x033, 0x00000167,
		0x03F, 0x00000003,
		0x033, 0x00000168,
		0x03F, 0x00050002,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00008001,
		0x033, 0x0000016D,
		0x03F, 0x00008002,
		0x033, 0x0000016E,
		0x03F, 0x00000003,
		0x033, 0x0000016F,
		0x03F, 0x00000003,
		0x033, 0x00000170,
		0x03F, 0x00050002,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00008001,
		0x033, 0x00000175,
		0x03F, 0x00008002,
		0x033, 0x00000176,
		0x03F, 0x00000003,
		0x033, 0x00000177,
		0x03F, 0x00000003,
		0x033, 0x00000178,
		0x03F, 0x00050002,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00008001,
		0x033, 0x0000017D,
		0x03F, 0x00008002,
		0x033, 0x0000017E,
		0x03F, 0x00000003,
		0x033, 0x0000017F,
		0x03F, 0x00000003,
		0x033, 0x000001A0,
		0x03F, 0x00050002,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00008001,
		0x033, 0x000001A5,
		0x03F, 0x00008002,
		0x033, 0x000001A6,
		0x03F, 0x00000003,
		0x033, 0x000001A7,
		0x03F, 0x00000003,
		0x033, 0x000001A8,
		0x03F, 0x00050002,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00008001,
		0x033, 0x000001AD,
		0x03F, 0x00008002,
		0x033, 0x000001AE,
		0x03F, 0x00000003,
		0x033, 0x000001AF,
		0x03F, 0x00000003,
		0x033, 0x000001B0,
		0x03F, 0x00050002,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00008001,
		0x033, 0x000001B5,
		0x03F, 0x00008002,
		0x033, 0x000001B6,
		0x03F, 0x00000003,
		0x033, 0x000001B7,
		0x03F, 0x00000003,
		0x033, 0x000001E0,
		0x03F, 0x00050002,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00008001,
		0x033, 0x000001E5,
		0x03F, 0x00008002,
		0x033, 0x000001E6,
		0x03F, 0x00000003,
		0x033, 0x000001E7,
		0x03F, 0x00000003,
		0x033, 0x000001E8,
		0x03F, 0x00050002,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00008001,
		0x033, 0x000001ED,
		0x03F, 0x00008002,
		0x033, 0x000001EE,
		0x03F, 0x00000003,
		0x033, 0x000001EF,
		0x03F, 0x00000003,
		0x033, 0x000001F0,
		0x03F, 0x00050002,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00008001,
		0x033, 0x000001F5,
		0x03F, 0x00008002,
		0x033, 0x000001F6,
		0x03F, 0x00000003,
		0x033, 0x000001F7,
		0x03F, 0x00000003,
		0x033, 0x000001F8,
		0x03F, 0x00050002,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00008001,
		0x033, 0x000001FD,
		0x03F, 0x00008002,
		0x033, 0x000001FE,
		0x03F, 0x00000003,
		0x033, 0x000001FF,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x005, 0x00000001,
		0x10005, 0x00000001,
		0x100EE, 0x00000400,
		0x10030, 0x00000000,
		0x10030, 0x00001000,
		0x10030, 0x00002000,
		0x10030, 0x00003000,
		0x10030, 0x00004000,
		0x10030, 0x00005000,
		0x10030, 0x00006003,
		0x10030, 0x00007003,
		0x10030, 0x00008000,
		0x10030, 0x00009000,
		0x10030, 0x0000A000,
		0x10030, 0x0000B000,
		0x10030, 0x0000C000,
		0x10030, 0x0000D000,
		0x10030, 0x0000E003,
		0x10030, 0x0000F003,
		0x10030, 0x00010000,
		0x10030, 0x00011000,
		0x10030, 0x00012000,
		0x10030, 0x00013000,
		0x10030, 0x00014000,
		0x10030, 0x00015000,
		0x10030, 0x00016003,
		0x10030, 0x00017003,
		0x10030, 0x00018000,
		0x10030, 0x00019000,
		0x10030, 0x0001A000,
		0x10030, 0x0001B000,
		0x10030, 0x0001C000,
		0x10030, 0x0001D000,
		0x10030, 0x0001E003,
		0x10030, 0x0001F003,
		0x10030, 0x00020000,
		0x10030, 0x00021000,
		0x10030, 0x00022000,
		0x10030, 0x00023000,
		0x10030, 0x00024000,
		0x10030, 0x00025003,
		0x10030, 0x00026003,
		0x10030, 0x00027003,
		0x10030, 0x00028000,
		0x10030, 0x00029000,
		0x10030, 0x0002A000,
		0x10030, 0x0002B000,
		0x10030, 0x0002C000,
		0x10030, 0x0002D003,
		0x10030, 0x0002E003,
		0x10030, 0x0002F003,
		0x10030, 0x00030000,
		0x10030, 0x00031000,
		0x10030, 0x00032000,
		0x10030, 0x00033000,
		0x10030, 0x00034000,
		0x10030, 0x00035003,
		0x10030, 0x00036003,
		0x10030, 0x00037003,
		0x10030, 0x00038000,
		0x10030, 0x00039000,
		0x10030, 0x0003A000,
		0x10030, 0x0003B000,
		0x10030, 0x0003C000,
		0x10030, 0x0003D003,
		0x10030, 0x0003E003,
		0x10030, 0x0003F003,
		0x10030, 0x00060000,
		0x10030, 0x00061000,
		0x10030, 0x00062000,
		0x10030, 0x00063000,
		0x10030, 0x00064000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
		0x10030, 0x00067003,
		0x10030, 0x00068000,
		0x10030, 0x00069000,
		0x10030, 0x0006A000,
		0x10030, 0x0006B000,
		0x10030, 0x0006C000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
		0x10030, 0x0006F003,
		0x10030, 0x00070000,
		0x10030, 0x00071000,
		0x10030, 0x00072000,
		0x10030, 0x00073000,
		0x10030, 0x00074000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
		0x10030, 0x00077003,
		0x10030, 0x00078000,
		0x10030, 0x00079000,
		0x10030, 0x0007A000,
		0x10030, 0x0007B000,
		0x10030, 0x0007C000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
		0x10030, 0x0007F003,
		0x0ED, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x0000000A,
		0x033, 0x00000003,
		0x03F, 0x0000000A,
		0x033, 0x00000005,
		0x03F, 0x0000000A,
		0x033, 0x00000006,
		0x03F, 0x0000000A,
		0x033, 0x00000007,
		0x03F, 0x0000000A,
		0x0ED, 0x00000000,
		0x100EE, 0x00000000,
		0x0FE, 0x00000007,

};


/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8832d_txpwr_lmt[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 18, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 26, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 26, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 14, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 14, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 12, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 16, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 13, 16, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 7, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 8, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 34, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 48, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 52, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 56, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 60, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 64, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 100, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 104, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 108, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 112, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 116, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 120, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 120, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 124, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 128, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 136, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 149, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 153, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 157, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 161, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 165, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 36, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 36, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 36, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 36, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 36, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 40, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 40, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 40, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 40, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 40, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 44, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 44, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 44, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 48, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 48, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 52, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 52, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 52, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 56, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 56, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 56, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 56, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 60, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 60, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 60, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 64, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 64, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 64, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 100, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 100, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 100, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 100, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 104, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 104, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 104, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 104, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 108, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 108, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 108, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 108, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 112, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 112, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 112, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 112, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 116, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 116, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 116, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 116, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 120, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 120, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 120, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 120, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 120, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 120, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 124, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 124, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 124, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 124, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 124, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 128, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 128, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 128, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 128, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 128, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 132, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 132, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 132, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 132, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 132, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 132, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 136, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 136, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 136, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 136, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 136, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 136, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 140, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 140, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 140, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 140, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 144, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 144, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 144, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 149, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 149, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 149, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 149, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 149, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 153, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 153, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 153, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 153, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 153, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 157, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 157, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 157, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 157, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 157, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 161, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 161, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 161, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 161, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 161, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 165, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 165, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 165, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 165, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 165, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 38, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 38, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 38, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 46, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 62, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 62, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 62, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 102, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 102, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 126, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 134, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 134, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 151, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 151, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 159, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 159, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 38, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 46, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 54, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 54, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 102, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 110, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 118, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 126, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 134, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 151, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 151, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 159, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 159, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 38, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 38, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 38, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 38, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 38, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 38, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 38, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 38, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 46, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 46, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 46, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 46, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 46, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 46, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 46, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 46, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 46, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 54, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 54, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 54, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 54, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 54, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 54, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 54, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 62, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 62, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 62, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 62, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 62, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 62, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 62, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 102, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 102, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 102, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 102, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 110, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 110, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 110, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 110, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 110, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 118, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 118, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 118, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 118, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 118, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 126, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 126, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 126, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 126, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 134, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 134, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 134, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 134, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 142, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 142, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 142, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 151, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 151, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 151, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 151, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 151, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 151, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 151, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 151, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 159, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 159, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 159, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 159, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 159, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 159, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 159, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 159, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 159, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 42, 58, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 42, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 58, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 58, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 58, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 106, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 122, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 155, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 155, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 155, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 155, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 42, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 42, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 42, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 42, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 58, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 58, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 106, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 106, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 122, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 122, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 122, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 155, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 155, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 42, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 42, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 42, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 42, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 42, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 42, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 42, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 42, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 58, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 58, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 58, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 58, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 58, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 58, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 58, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 106, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 106, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 106, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 106, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 106, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 106, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 122, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 122, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 122, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 122, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 122, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 122, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 122, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 138, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 138, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 138, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 155, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 155, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 155, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 155, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 155, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 155, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 155, 6, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 50, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 50, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 50, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 50, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 50, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 114, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 114, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 50, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 50, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 50, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 50, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 50, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 114, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 114, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 114, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 114, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 50, 32, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 50, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 50, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 50, 44, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 50, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 50, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 50, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 50, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 50, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 114, 36, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 114, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 114, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 114, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 114, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 163, 46, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 163, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_6g.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8832d_txpwr_lmt_6g[] = {
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 1, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 5, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 5, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 5, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 5, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 9, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 9, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 9, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 9, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 13, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 13, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 13, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 13, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 17, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 17, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 17, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 17, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 21, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 21, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 21, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 21, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 25, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 25, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 25, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 25, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 29, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 29, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 29, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 29, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 33, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 33, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 33, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 33, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 37, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 37, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 37, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 37, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 41, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 41, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 41, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 41, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 45, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 45, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 45, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 45, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 49, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 49, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 49, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 49, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 53, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 53, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 53, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 53, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 57, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 57, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 57, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 57, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 61, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 61, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 61, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 61, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 65, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 65, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 65, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 65, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 69, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 69, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 69, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 69, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 73, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 73, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 73, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 73, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 77, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 77, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 77, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 77, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 81, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 81, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 81, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 81, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 85, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 85, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 85, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 85, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 89, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 89, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 89, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 89, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 93, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 93, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 93, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 93, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 93, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 97, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 97, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 97, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 101, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 101, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 101, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 109, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 109, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 109, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 113, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 113, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 113, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 117, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 117, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 117, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 121, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 121, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 121, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 125, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 125, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 125, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 129, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 129, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 129, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 133, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 133, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 133, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 137, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 137, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 137, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 141, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 141, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 141, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 145, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 145, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 145, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 149, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 149, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 149, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 153, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 153, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 153, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 157, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 157, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 157, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 161, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 161, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 161, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 165, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 165, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 165, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 169, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 169, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 169, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 173, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 173, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 173, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 177, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 177, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 177, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 181, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 181, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 181, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 185, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 185, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 185, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 189, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 189, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 189, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 193, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 193, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 193, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 197, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 197, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 197, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 201, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 201, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 201, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 205, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 205, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 205, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 209, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 209, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 209, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 213, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 213, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 213, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 217, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 217, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 217, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 221, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 221, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 221, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 225, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 225, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 225, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 229, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 229, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 229, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 233, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 233, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 233, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 1, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 1, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 1, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 5, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 9, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 13, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 17, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 21, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 25, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 29, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 33, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 37, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 41, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 45, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 49, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 49, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 49, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 49, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 53, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 53, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 53, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 53, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 57, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 57, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 57, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 57, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 61, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 61, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 61, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 61, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 65, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 65, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 65, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 65, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 69, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 69, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 69, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 69, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 73, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 73, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 73, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 73, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 77, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 77, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 77, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 77, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 81, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 81, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 81, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 81, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 85, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 85, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 85, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 85, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 89, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 89, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 89, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 89, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 93, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 93, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 93, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 97, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 101, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 105, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 109, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 113, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 117, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 121, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 125, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 129, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 133, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 137, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 141, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 145, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 149, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 153, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 157, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 161, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 165, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 169, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 173, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 177, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 181, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 185, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 189, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 193, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 197, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 201, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 205, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 209, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 213, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 217, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 221, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 225, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 229, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 233, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 1, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 1, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 1, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 5, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 5, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 5, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 5, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 5, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 5, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 9, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 9, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 9, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 9, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 9, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 9, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 13, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 13, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 13, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 13, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 13, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 13, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 17, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 17, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 17, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 17, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 17, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 17, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 21, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 21, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 21, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 21, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 21, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 21, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 25, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 25, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 25, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 25, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 25, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 25, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 29, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 29, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 29, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 29, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 29, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 29, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 33, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 33, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 33, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 33, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 33, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 33, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 37, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 37, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 37, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 37, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 37, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 37, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 41, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 41, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 41, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 41, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 41, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 41, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 45, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 45, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 45, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 45, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 45, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 45, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 49, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 49, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 49, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 49, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 49, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 49, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 53, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 53, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 53, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 53, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 53, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 53, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 57, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 57, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 57, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 57, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 57, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 57, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 61, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 61, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 61, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 61, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 61, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 61, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 65, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 65, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 65, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 65, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 65, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 65, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 69, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 69, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 69, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 69, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 69, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 69, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 73, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 73, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 73, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 73, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 73, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 73, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 77, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 77, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 77, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 77, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 77, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 77, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 81, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 81, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 81, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 81, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 81, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 81, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 85, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 85, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 85, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 85, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 85, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 85, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 89, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 89, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 89, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 89, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 89, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 89, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 93, 70, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 93, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 93, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 93, 44, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 93, 28, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 93, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 93, 66, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 97, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 97, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 97, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 101, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 101, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 101, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 105, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 109, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 109, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 109, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 113, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 113, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 113, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 117, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 117, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 117, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 121, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 121, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 121, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 125, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 125, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 125, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 129, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 129, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 129, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 133, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 133, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 133, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 137, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 137, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 137, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 141, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 141, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 141, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 145, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 145, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 145, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 149, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 149, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 149, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 153, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 153, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 153, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 157, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 157, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 157, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 161, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 161, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 161, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 165, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 165, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 165, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 169, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 169, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 169, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 173, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 173, 26, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 173, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 177, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 177, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 177, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 181, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 181, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 181, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 185, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 185, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 185, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 189, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 189, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 189, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 193, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 193, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 193, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 197, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 197, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 197, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 201, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 201, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 201, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 205, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 205, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 205, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 209, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 209, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 209, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 213, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 213, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 213, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 217, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 217, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 217, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 221, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 221, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 221, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 225, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 225, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 225, 22, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 229, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 229, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 229, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 233, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 233, 32, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 233, 24, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 1, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 1, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 1, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 5, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 9, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 13, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 17, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 21, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 25, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 29, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 33, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 37, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 41, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 45, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 49, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 49, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 49, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 49, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 53, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 53, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 53, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 53, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 57, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 57, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 57, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 57, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 61, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 61, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 61, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 61, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 65, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 65, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 65, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 65, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 69, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 69, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 69, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 69, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 73, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 73, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 73, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 73, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 77, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 77, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 77, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 77, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 81, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 81, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 81, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 81, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 85, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 85, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 85, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 85, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 89, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 89, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 89, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 89, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 93, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 93, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 93, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 93, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 97, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 101, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 105, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 109, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 113, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 117, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 121, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 125, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 129, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 133, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 137, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 141, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 145, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 149, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 153, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 157, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 161, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 165, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 169, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 173, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 177, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 181, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 185, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 189, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 193, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 197, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 201, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 205, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 209, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 213, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 217, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 221, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 225, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 229, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 233, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 237, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 241, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 245, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 249, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_FCC_STD, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ETSI_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_KCC_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_IC_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_ACMA_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_UK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_MKK_VLP, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_CHILE_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_6G_QATAR_LPI, 253, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 1, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 1, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 1, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 1, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 1, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 1, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 1, 56, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 1, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 1, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 1, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 5, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 5, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 5, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 5, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 5, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 5, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 5, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 5, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 9, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 9, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 9, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 9, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 9, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 9, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 9, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 9, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 13, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 13, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 13, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 13, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 13, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 13, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 13, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 13, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 17, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 17, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 17, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 17, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 17, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 17, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 17, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 17, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 21, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 21, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 21, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 21, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 21, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 21, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 21, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 21, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 25, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 25, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 25, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 25, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 25, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 25, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 25, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 25, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 29, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 29, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 29, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 29, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 29, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 29, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 29, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 29, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 33, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 33, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 33, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 33, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 33, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 33, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 33, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 33, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 37, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 37, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 37, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 37, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 37, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 37, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 37, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 37, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 41, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 41, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 41, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 41, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 41, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 41, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 41, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 41, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 45, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 45, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 45, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 45, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 45, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 45, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 45, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 45, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 49, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 49, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 49, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 49, 10, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 49, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 49, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 49, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 49, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 49, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 49, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 53, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 53, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 53, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 53, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 53, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 53, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 53, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 53, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 53, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 53, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 57, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 57, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 57, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 57, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 57, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 57, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 57, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 57, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 57, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 57, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 61, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 61, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 61, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 61, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 61, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 61, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 61, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 61, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 61, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 61, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 65, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 65, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 65, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 65, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 65, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 65, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 65, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 65, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 65, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 65, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 69, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 69, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 69, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 69, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 69, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 69, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 69, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 69, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 69, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 69, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 73, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 73, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 73, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 73, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 73, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 73, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 73, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 73, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 73, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 73, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 77, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 77, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 77, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 77, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 77, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 77, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 77, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 77, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 77, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 77, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 81, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 81, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 81, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 81, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 81, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 81, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 81, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 81, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 81, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 81, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 85, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 85, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 85, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 85, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 85, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 85, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 85, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 85, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 85, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 85, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 89, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 89, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 89, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 89, 14, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 89, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 89, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 89, 54, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 89, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 89, -4, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 89, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 93, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 93, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 93, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 93, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 93, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 93, 34, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 93, 16, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 93, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 93, 42, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 97, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 97, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 97, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 101, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 101, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 101, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 105, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 105, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 105, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 109, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 109, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 109, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 113, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 113, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 113, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 117, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 117, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 117, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 117, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 121, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 121, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 121, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 121, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 125, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 125, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 125, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 125, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 129, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 129, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 129, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 129, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 133, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 133, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 133, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 133, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 137, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 137, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 137, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 137, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 141, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 141, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 141, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 141, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 145, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 145, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 145, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 145, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 149, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 149, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 149, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 149, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 153, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 153, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 153, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 153, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 157, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 157, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 157, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 157, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 161, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 161, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 161, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 161, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 165, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 165, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 165, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 165, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 169, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 169, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 169, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 169, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 173, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 173, 12, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 173, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 173, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 177, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 177, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 177, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 177, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 181, 68, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 181, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 181, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 181, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 185, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 185, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 185, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 189, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 189, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 189, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 193, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 193, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 193, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 197, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 197, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 197, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 201, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 201, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 201, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 205, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 205, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 205, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 209, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 209, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 209, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 213, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 213, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 213, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 217, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 217, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 217, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 221, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 221, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 221, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 225, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 225, -2, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 225, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 229, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 229, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 229, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_LPI, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_FCC_STD, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ETSI_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_LPI, 233, 20, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_KCC_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_IC_LPI, 233, 0, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_ACMA_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_UK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_MKK_VLP, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_CHILE_LPI, 233, 127, 0},
	{PW_LMT_BAND_6G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_6G_QATAR_LPI, 233, 127,