/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/
#include "../halrf_precomp.h"

#ifdef RF_8852C_SUPPORT

bool halrf_get_efuse_info_8852c(struct rf_info *rf, u8 *efuse_map,
		       enum rtw_efuse_info id, void *value, u32 length,
		       u8 autoload_status)
{
	struct rtw_hal_com_t *hal = rf->hal_com;

	u32 offset = 0;
	u8 default_value = 0;

	if (length != 1)
		return false;

	switch (id) {
		case EFUSE_INFO_RF_PKG_TYPE:
			offset = 0;
			default_value = 0;
			break;
		case EFUSE_INFO_RF_PA:
			offset = 0;
			default_value = 0;
			break;
		case EFUSE_INFO_RF_VALID_PATH:
			offset = 0;
			default_value = 0;
			break;
		case EFUSE_INFO_RF_RFE:
			offset = EFUSE_INFO_RF_RFE_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RFE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_TXPWR:
			offset = 0;
			default_value = 0;
			break;
		case EFUSE_INFO_RF_BOARD_OPTION:
			offset = EFUSE_INFO_RF_BOARD_OPTION_8852C_ADDR;
			default_value = EFUSE_INFO_RF_BOARD_OPTION_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_CHAN_PLAN:
			offset = EFUSE_INFO_RF_CHAN_PLAN_8852C_ADDR;
			default_value = EFUSE_INFO_RF_CHAN_PLAN_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_CHAN_PLAN_6GHZ:
			offset = EFUSE_INFO_RF_CHAN_PLAN_6GHZ_8852C_ADDR;
			default_value = EFUSE_INFO_RF_CHAN_PLAN_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_COUNTRY:
			offset = 0;
			default_value = 0;
			break;
		/*TSSI DE PathA CCK*/
		case EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_1:
			offset = EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_2:
			offset = EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_3:
			offset = EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_4:
			offset = EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_5:
			offset = EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_6:
			offset = EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;

		/*TSSI DE PathA 2G MCS7 BW40M*/
		case EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_1:
			offset = EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_2:
			offset = EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_3:
			offset = EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_4:
			offset = EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_5:
			offset = EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;

		/*TSSI DE PathA 5G MCS7 BW40M*/
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_1:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_2:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_3:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_4:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_5:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_6:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_7:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_7_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_8:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_8_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_9:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_9_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_10:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_10_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_11:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_11_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_12:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_12_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_13:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_13_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_14:
			offset = EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_14_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		/*5G Diff A*/
		case EFUSE_INFO_RF_5G_BW20M1S_BW40M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M1S_BW40M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_OFDM1T_BW40M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM1T_BW40M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW40M2S_BW40M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW40M2S_BW40M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW20M2S_BW20M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M2S_BW20M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW40M3S_BW40M2S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW40M3S_BW40M2S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW20M3S_BW20M2S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M3S_BW20M2S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW40M4S_BW40M3S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW40M4S_BW40M3S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW20M4S_BW20M3S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M4S_BW20M3S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_OFDM2T_OFDM1T_A_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM2T_OFDM1T_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_OFDM3T_OFDM2T_A_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM3T_OFDM2T_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_OFDM4T_OFDM3T_A_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM4T_OFDM3T_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW80M2S_BW80M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M2S_BW80M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW160M2S_BW160M1S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M2S_BW160M1S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW80M3S_BW80M2S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M3S_BW80M2S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW160M3S_BW160M2S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M3S_BW160M2S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW80M4S_BW80M3S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M4S_BW80M3S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW160M4S_BW160M3S_A_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M4S_BW160M3S_A_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;

		/*TSSI DE PathB CCK*/
		case EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_1:
			offset = EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_2:
			offset = EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_3:
			offset = EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_4:
			offset = EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_5:
			offset = EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_6:
			offset = EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;

		/*TSSI DE PathB 2G MCS7 BW40M*/
		case EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_1:
			offset = EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_2:
			offset = EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_3:
			offset = EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_4:
			offset = EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_5:
			offset = EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;

		/*TSSI DE PathB 5G MCS7 BW40M*/
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_1:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_2:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_3:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_4:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_5:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_6:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_7:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_7_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_8:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_8_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_9:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_9_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_10:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_10_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_11:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_11_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_12:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_12_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_13:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_13_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_14:
			offset = EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_14_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;

		/*5G Diff B*/
		case EFUSE_INFO_RF_5G_BW20M1S_BW40M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M1S_BW40M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_OFDM1T_BW40M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM1T_BW40M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW40M2S_BW40M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW40M2S_BW40M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW20M2S_BW20M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M2S_BW20M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW40M3S_BW40M2S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW40M3S_BW40M2S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW20M3S_BW20M2S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M3S_BW20M2S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW40M4S_BW40M3S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW40M4S_BW40M3S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW20M4S_BW20M3S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW20M4S_BW20M3S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_OFDM2T_OFDM1T_B_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM2T_OFDM1T_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_OFDM3T_OFDM2T_B_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM3T_OFDM2T_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_OFDM4T_OFDM3T_B_DIFF:
			offset = EFUSE_INFO_RF_5G_OFDM4T_OFDM3T_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW80M2S_BW80M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M2S_BW80M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW160M2S_BW160M1S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M2S_BW160M1S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_1;
			break;
		case EFUSE_INFO_RF_5G_BW80M3S_BW80M2S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M3S_BW80M2S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW160M3S_BW160M2S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M3S_BW160M2S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW80M4S_BW80M3S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW80M4S_BW80M3S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;
		case EFUSE_INFO_RF_5G_BW160M4S_BW160M3S_B_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M4S_BW160M3S_B_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_5G_DIFF_VALUE_2;
			break;

		case EFUSE_INFO_RF_RX_GAIN_K_A_2G_CCK:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_2G_CCK_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_2G_OFMD:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_2G_OFMD_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_5GL:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_5GL_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_5GM:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_5GM_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_5GH:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_5GH_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GL1:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GL1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GL2:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GL2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GL3:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GL3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GM1:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GM1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GM2:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GM2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GM3:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GM3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GH1:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GH1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_RX_GAIN_K_A_6GH2:
			offset = EFUSE_INFO_RF_RX_GAIN_K_A_6GH2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE;
			break;
		/*Thermal*/
		case EFUSE_INFO_RF_THERMAL_A:
			offset = EFUSE_INFO_RF_THERMAL_A_8852C_ADDR;
			default_value = EFUSE_INFO_RF_THERMAL_A_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_THERMAL_B:
			offset = EFUSE_INFO_RF_THERMAL_B_8852C_ADDR;
			default_value = EFUSE_INFO_RF_THERMAL_B_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_XTAL:
			offset = EFUSE_INFO_RF_XTAL_8852C_ADDR;
			default_value = EFUSE_INFO_RF_XTAL_8852C_VALUE;
			break;
		/*5G DIFF*/
		case EFUSE_INFO_RF_5G_BW160M_BW40M_DIFF:
			offset = EFUSE_INFO_RF_5G_BW160M_BW40M_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_BW_DIFF_VALUE;
			break;
		/*TSSI DE PathA 6G BW40M*/
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_1:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_2:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_3:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_4:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_5:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_6:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_7:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_7_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_8:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_8_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_9:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_9_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_10:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_10_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_11:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_11_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_12:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_12_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_13:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_13_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_14:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_14_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_15:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_15_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_16:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_16_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_17:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_17_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_18:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_18_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_19:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_19_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_20:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_20_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_21:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_21_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_22:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_22_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_23:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_23_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_24:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_24_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_25:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_25_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_26:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_26_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_27:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_27_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_28:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_28_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_29:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_29_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_30:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_30_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;	
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_31:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_31_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_32:
			offset = EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_32_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		/*TSSI DE PathB 6G BW40M*/
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_1:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_2:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_3:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_4:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_5:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_6:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_7:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_7_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_8:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_8_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_9:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_9_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_10:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_10_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_11:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_11_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_12:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_12_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_13:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_13_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_14:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_14_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_15:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_15_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_16:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_16_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_17:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_17_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_18:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_18_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_19:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_19_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_20:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_20_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_21:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_21_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_22:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_22_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_23:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_23_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_24:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_24_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_25:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_25_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_26:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_26_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_27:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_27_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_28:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_28_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_29:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_29_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_30:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_30_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;	
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_31:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_31_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_32:
			offset = EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_32_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		/*TSSI DE PathC 6G BW40M*/
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_1:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_2:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_3:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_4:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_5:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_6:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_7:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_7_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_8:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_8_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_9:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_9_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_10:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_10_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_11:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_11_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_12:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_12_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_13:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_13_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_14:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_14_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_15:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_15_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_16:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_16_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_17:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_17_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_18:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_18_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_19:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_19_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_20:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_20_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_21:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_21_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_22:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_22_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_23:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_23_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_24:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_24_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_25:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_25_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_26:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_26_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_27:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_27_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_28:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_28_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_29:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_29_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_30:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_30_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;	
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_31:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_31_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_32:
			offset = EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_32_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		/*TSSI DE PathD 6G BW40M*/
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_1:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_1_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_2:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_2_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_3:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_3_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_4:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_4_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_5:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_5_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_6:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_6_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_7:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_7_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_8:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_8_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_9:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_9_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_10:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_10_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_11:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_11_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_12:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_12_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_13:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_13_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_14:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_14_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_15:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_15_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_16:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_16_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_17:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_17_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_18:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_18_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_19:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_19_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_20:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_20_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_21:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_21_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_22:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_22_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_23:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_23_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_24:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_24_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_25:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_25_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_26:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_26_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_27:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_27_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_28:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_28_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_29:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_29_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_30:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_30_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;	
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_31:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_31_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_32:
			offset = EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_32_8852C_ADDR;
			default_value = EFUSE_INFO_RF_TSSI_DE_8852C_VALUE;
			break;
		/*6G BW DIFF*/
		case EFUSE_INFO_RF_6G_BW160M_BW40M_DIFF:
			offset = EFUSE_INFO_RF_6G_BW160M_BW40M_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_BW_DIFF_VALUE;
			break;
		case EFUSE_INFO_RF_6G_BW320M_BW160M_DIFF:
			offset = EFUSE_INFO_RF_6G_BW160M_BW40M_DIFF_ADDR;
			default_value = EFUSE_INFO_RF_BW_DIFF_VALUE;
			break;

		default:
			return false;
	}

	if (autoload_status == 0)
		hal_mem_cpy(hal, value, &default_value, 1);
	else {
		hal_mem_cpy(hal, value, efuse_map + offset, length);

#if 0
		if (id == EFUSE_INFO_RF_XTAL) {
			if (*((u8 *)value) == 0xff)
				hal_mem_set(hal, value, 0x3f, 1);
		} else if (id == EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_A_DIFF ||
				id == EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_B_DIFF) {
			*((u8 *)value) = *((u8 *)value) & 0xf0;
		} else if (id == EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_A_DIFF ||
				id == EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_B_DIFF) {
			*((u8 *)value) = *((u8 *)value) & 0xf;
		}
#endif
		switch (id) {
			case EFUSE_INFO_RF_XTAL:
				if (*((u8 *)value) == 0xff)
					hal_mem_set(hal, value, 0x3f, 1);
				break;
			case EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_A_DIFF:
			case EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_B_DIFF:
			case EFUSE_INFO_RF_5G_BW160M_BW40M_DIFF:
			case EFUSE_INFO_RF_6G_BW160M_BW40M_DIFF:
				*((u8 *)value) = ((*((u8 *)value)) & 0xf0) >> 4;
				break;
			case EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_A_DIFF:
			case EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_B_DIFF:
			case EFUSE_INFO_RF_6G_BW320M_BW160M_DIFF:
				*((u8 *)value) = *((u8 *)value) & 0xf;
				break;
			default:
				break;
		}
	}

	return true;
}

#endif	/*#ifdef RF_8852C_SUPPORT*/