/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/
#ifndef _HALRF_EFUSE_8852C_H_
#define _HALRF_EFUSE_8852C_H_

#ifdef RF_8852C_SUPPORT

enum rtw_flash_8852c_info {
	/* AP customize configs*/
	FLASH_INFO_START_8852C = (EFUSE_INFO_BTCOEX_MAX + 1),
	FLASH_INFO_COSTUM_PARA_PATH_8852C = FLASH_INFO_START_8852C,

	/* RF TSSI SLOPE K, GAIN DIFF */
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_8852C_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8852C_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8852C_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8852C_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8852C_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8852C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_8852C_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8852C_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8852C_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8852C_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8852C_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8852C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_8852C_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8852C_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8852C_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8852C_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8852C_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8852C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_8852C_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8852C_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8852C_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8852C_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8852C_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8852C_14,

	/* RF TSSI SLOPE K, CW DIFF */
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_8852C_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8852C_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8852C_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8852C_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8852C_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8852C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_8852C_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8852C_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8852C_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8852C_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8852C_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8852C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_8852C_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8852C_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8852C_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8852C_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8852C_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8852C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8852C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8852C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8852C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8852C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8852C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_8852C_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8852C_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8852C_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8852C_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8852C_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8852C_14,

	/* RF 20M 80M 160M, TSSI DIFF */
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8852C_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8852C_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8852C_14,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8852C_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8852C_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8852C_14,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8852C_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8852C_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8852C_14,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8852C_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8852C_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8852C_14,

	/*Error Code*/
	FLASH_INFO_ID_ERROR_8852C,
};

enum halrf_efsue_info_8852c_offset {
	EFUSE_INFO_RF_BOARD_OPTION_8852C_ADDR	= 0x2c1,
	EFUSE_INFO_RF_RFE_8852C_ADDR		= 0x2ca,
	EFUSE_INFO_RF_CHAN_PLAN_8852C_ADDR	= 0x2b8,
	EFUSE_INFO_RF_CHAN_PLAN_6GHZ_8852C_ADDR	= 0x3b8,
	EFUSE_INFO_RF_XTAL_8852C_ADDR		= 0x2b9,
	EFUSE_INFO_RF_THERMAL_A_8852C_ADDR	= 0x2d0,
	EFUSE_INFO_RF_THERMAL_B_8852C_ADDR	= 0x2d1,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_1_8852C_ADDR	= 0x210,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_2_8852C_ADDR	= 0x211,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_3_8852C_ADDR	= 0x212,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_4_8852C_ADDR	= 0x213,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_5_8852C_ADDR	= 0x214,
	EFUSE_INFO_RF_2G_CCK_A_TSSI_DE_6_8852C_ADDR	= 0x215,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_1_8852C_ADDR	= 0x216,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_2_8852C_ADDR	= 0x217,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_3_8852C_ADDR	= 0x218,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_4_8852C_ADDR	= 0x219,
	EFUSE_INFO_RF_2G_BW40M_A_TSSI_DE_5_8852C_ADDR	= 0x21a,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_1_8852C_ADDR	= 0x222,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_2_8852C_ADDR	= 0x223,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_3_8852C_ADDR	= 0x224,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_4_8852C_ADDR	= 0x225,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_5_8852C_ADDR	= 0x226,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_6_8852C_ADDR	= 0x227,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_7_8852C_ADDR	= 0x228,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_8_8852C_ADDR	= 0x229,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_9_8852C_ADDR	= 0x22a,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_10_8852C_ADDR	= 0x22b,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_11_8852C_ADDR	= 0x22c,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_12_8852C_ADDR	= 0x22d,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_13_8852C_ADDR	= 0x22e,
	EFUSE_INFO_RF_5G_BW40M_A_TSSI_DE_14_8852C_ADDR	= 0x22f,
	EFUSE_INFO_RF_5G_BW20M1S_BW40M1S_A_DIFF_ADDR	= 0x230,
	EFUSE_INFO_RF_5G_OFDM1T_BW40M1S_A_DIFF_ADDR	= 0x230,
	EFUSE_INFO_RF_5G_BW40M2S_BW40M1S_A_DIFF_ADDR	= 0x231,
	EFUSE_INFO_RF_5G_BW20M2S_BW20M1S_A_DIFF_ADDR	= 0x231,
	EFUSE_INFO_RF_5G_BW40M3S_BW40M2S_A_DIFF_ADDR	= 0x232,
	EFUSE_INFO_RF_5G_BW20M3S_BW20M2S_A_DIFF_ADDR	= 0x232,
	EFUSE_INFO_RF_5G_BW40M4S_BW40M3S_A_DIFF_ADDR	= 0x233,
	EFUSE_INFO_RF_5G_BW20M4S_BW20M3S_A_DIFF_ADDR	= 0x233,
	EFUSE_INFO_RF_5G_OFDM2T_OFDM1T_A_DIFF_ADDR	= 0x234,
	EFUSE_INFO_RF_5G_OFDM3T_OFDM2T_A_DIFF_ADDR	= 0x234,
	EFUSE_INFO_RF_5G_OFDM4T_OFDM3T_A_DIFF_ADDR	= 0x235,
	EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_A_DIFF_ADDR	= 0x236,
	EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_A_DIFF_ADDR	= 0x236,
	EFUSE_INFO_RF_5G_BW80M2S_BW80M1S_A_DIFF_ADDR	= 0x237,
	EFUSE_INFO_RF_5G_BW160M2S_BW160M1S_A_DIFF_ADDR	= 0x237,
	EFUSE_INFO_RF_5G_BW80M3S_BW80M2S_A_DIFF_ADDR	= 0x238,
	EFUSE_INFO_RF_5G_BW160M3S_BW160M2S_A_DIFF_ADDR	= 0x238,
	EFUSE_INFO_RF_5G_BW80M4S_BW80M3S_A_DIFF_ADDR	= 0x239,
	EFUSE_INFO_RF_5G_BW160M4S_BW160M3S_A_DIFF_ADDR	= 0x239,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_1_8852C_ADDR	= 0x23a,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_2_8852C_ADDR	= 0x23b,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_3_8852C_ADDR	= 0x23c,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_4_8852C_ADDR	= 0x23d,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_5_8852C_ADDR	= 0x23e,
	EFUSE_INFO_RF_2G_CCK_B_TSSI_DE_6_8852C_ADDR	= 0x23f,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_1_8852C_ADDR	= 0x240,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_2_8852C_ADDR	= 0x241,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_3_8852C_ADDR	= 0x242,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_4_8852C_ADDR	= 0x243,
	EFUSE_INFO_RF_2G_BW40M_B_TSSI_DE_5_8852C_ADDR	= 0x244,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_1_8852C_ADDR	= 0x24c,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_2_8852C_ADDR	= 0x24d,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_3_8852C_ADDR	= 0x24e,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_4_8852C_ADDR	= 0x24f,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_5_8852C_ADDR	= 0x250,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_6_8852C_ADDR	= 0x251,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_7_8852C_ADDR	= 0x252,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_8_8852C_ADDR	= 0x253,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_9_8852C_ADDR	= 0x254,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_10_8852C_ADDR	= 0x255,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_11_8852C_ADDR	= 0x256,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_12_8852C_ADDR	= 0x257,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_13_8852C_ADDR	= 0x258,
	EFUSE_INFO_RF_5G_BW40M_B_TSSI_DE_14_8852C_ADDR	= 0x259,
	EFUSE_INFO_RF_5G_BW20M1S_BW40M1S_B_DIFF_ADDR	= 0x25a,
	EFUSE_INFO_RF_5G_OFDM1T_BW40M1S_B_DIFF_ADDR	= 0x25a,
	EFUSE_INFO_RF_5G_BW40M2S_BW40M1S_B_DIFF_ADDR	= 0x25b,
	EFUSE_INFO_RF_5G_BW20M2S_BW20M1S_B_DIFF_ADDR	= 0x25b,
	EFUSE_INFO_RF_5G_BW40M3S_BW40M2S_B_DIFF_ADDR	= 0x25c,
	EFUSE_INFO_RF_5G_BW20M3S_BW20M2S_B_DIFF_ADDR	= 0x25c,
	EFUSE_INFO_RF_5G_BW40M4S_BW40M3S_B_DIFF_ADDR	= 0x25d,
	EFUSE_INFO_RF_5G_BW20M4S_BW20M3S_B_DIFF_ADDR	= 0x25d,
	EFUSE_INFO_RF_5G_OFDM2T_OFDM1T_B_DIFF_ADDR	= 0x25e,
	EFUSE_INFO_RF_5G_OFDM3T_OFDM2T_B_DIFF_ADDR	= 0x25e,
	EFUSE_INFO_RF_5G_OFDM4T_OFDM3T_B_DIFF_ADDR	= 0x25f,
	EFUSE_INFO_RF_5G_BW80M1S_BW40M1S_B_DIFF_ADDR	= 0x260,
	EFUSE_INFO_RF_5G_BW160M1S_BW80M1S_B_DIFF_ADDR	= 0x260,
	EFUSE_INFO_RF_5G_BW80M2S_BW80M1S_B_DIFF_ADDR	= 0x261,
	EFUSE_INFO_RF_5G_BW160M2S_BW160M1S_B_DIFF_ADDR	= 0x261,
	EFUSE_INFO_RF_5G_BW80M3S_BW80M2S_B_DIFF_ADDR	= 0x262,
	EFUSE_INFO_RF_5G_BW160M3S_BW160M2S_B_DIFF_ADDR	= 0x262,
	EFUSE_INFO_RF_5G_BW80M4S_BW80M3S_B_DIFF_ADDR	= 0x263,
	EFUSE_INFO_RF_5G_BW160M4S_BW160M3S_B_DIFF_ADDR	= 0x263,
	EFUSE_INFO_RF_RX_GAIN_K_A_2G_CCK_8852C_ADDR	= 0x2d6,
	EFUSE_INFO_RF_RX_GAIN_K_A_2G_OFMD_8852C_ADDR	= 0x2d4,
	EFUSE_INFO_RF_RX_GAIN_K_A_5GL_8852C_ADDR	= 0x2d8,
	EFUSE_INFO_RF_RX_GAIN_K_A_5GM_8852C_ADDR	= 0x2da,
	EFUSE_INFO_RF_RX_GAIN_K_A_5GH_8852C_ADDR	= 0x2dc,
	EFUSE_INFO_RF_5G_BW160M_BW40M_DIFF_ADDR		= 0x2e8,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_1_8852C_ADDR	= 0x300,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_2_8852C_ADDR	= 0x301,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_3_8852C_ADDR	= 0x302,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_4_8852C_ADDR	= 0x303,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_5_8852C_ADDR	= 0x304,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_6_8852C_ADDR	= 0x305,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_7_8852C_ADDR	= 0x306,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_8_8852C_ADDR	= 0x307,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_9_8852C_ADDR	= 0x308,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_10_8852C_ADDR	= 0x309,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_11_8852C_ADDR	= 0x30a,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_12_8852C_ADDR	= 0x30b,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_13_8852C_ADDR	= 0x30c,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_14_8852C_ADDR	= 0x30d,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_15_8852C_ADDR	= 0x30e,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_16_8852C_ADDR	= 0x30f,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_17_8852C_ADDR	= 0x310,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_18_8852C_ADDR	= 0x311,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_19_8852C_ADDR	= 0x312,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_20_8852C_ADDR	= 0x313,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_21_8852C_ADDR	= 0x314,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_22_8852C_ADDR	= 0x315,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_23_8852C_ADDR	= 0x316,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_24_8852C_ADDR	= 0x317,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_25_8852C_ADDR	= 0x318,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_26_8852C_ADDR	= 0x319,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_27_8852C_ADDR	= 0x31a,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_28_8852C_ADDR	= 0x31b,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_29_8852C_ADDR	= 0x31c,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_30_8852C_ADDR	= 0x31d,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_31_8852C_ADDR	= 0x31e,
	EFUSE_INFO_RF_6G_BW40M_A_TSSI_DE_32_8852C_ADDR	= 0x31f,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_1_8852C_ADDR	= 0x32a,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_2_8852C_ADDR	= 0x32b,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_3_8852C_ADDR	= 0x32c,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_4_8852C_ADDR	= 0x32d,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_5_8852C_ADDR	= 0x32e,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_6_8852C_ADDR	= 0x32f,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_7_8852C_ADDR	= 0x330,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_8_8852C_ADDR	= 0x331,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_9_8852C_ADDR	= 0x332,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_10_8852C_ADDR	= 0x333,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_11_8852C_ADDR	= 0x334,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_12_8852C_ADDR	= 0x335,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_13_8852C_ADDR	= 0x336,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_14_8852C_ADDR	= 0x337,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_15_8852C_ADDR	= 0x338,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_16_8852C_ADDR	= 0x339,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_17_8852C_ADDR	= 0x33a,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_18_8852C_ADDR	= 0x33b,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_19_8852C_ADDR	= 0x33c,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_20_8852C_ADDR	= 0x33d,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_21_8852C_ADDR	= 0x33e,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_22_8852C_ADDR	= 0x33f,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_23_8852C_ADDR	= 0x340,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_24_8852C_ADDR	= 0x341,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_25_8852C_ADDR	= 0x342,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_26_8852C_ADDR	= 0x343,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_27_8852C_ADDR	= 0x344,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_28_8852C_ADDR	= 0x345,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_29_8852C_ADDR	= 0x346,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_30_8852C_ADDR	= 0x347,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_31_8852C_ADDR	= 0x348,
	EFUSE_INFO_RF_6G_BW40M_B_TSSI_DE_32_8852C_ADDR	= 0x349,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_1_8852C_ADDR	= 0x354,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_2_8852C_ADDR	= 0x355,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_3_8852C_ADDR	= 0x356,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_4_8852C_ADDR	= 0x357,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_5_8852C_ADDR	= 0x358,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_6_8852C_ADDR	= 0x359,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_7_8852C_ADDR	= 0x35a,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_8_8852C_ADDR	= 0x35b,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_9_8852C_ADDR	= 0x35c,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_10_8852C_ADDR	= 0x35d,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_11_8852C_ADDR	= 0x35e,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_12_8852C_ADDR	= 0x35f,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_13_8852C_ADDR	= 0x360,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_14_8852C_ADDR	= 0x361,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_15_8852C_ADDR	= 0x362,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_16_8852C_ADDR	= 0x363,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_17_8852C_ADDR	= 0x364,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_18_8852C_ADDR	= 0x365,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_19_8852C_ADDR	= 0x366,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_20_8852C_ADDR	= 0x367,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_21_8852C_ADDR	= 0x368,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_22_8852C_ADDR	= 0x369,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_23_8852C_ADDR	= 0x36a,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_24_8852C_ADDR	= 0x36b,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_25_8852C_ADDR	= 0x36c,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_26_8852C_ADDR	= 0x36d,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_27_8852C_ADDR	= 0x36e,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_28_8852C_ADDR	= 0x36f,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_29_8852C_ADDR	= 0x370,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_30_8852C_ADDR	= 0x371,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_31_8852C_ADDR	= 0x372,
	EFUSE_INFO_RF_6G_BW40M_C_TSSI_DE_32_8852C_ADDR	= 0x373,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_1_8852C_ADDR	= 0x37e,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_2_8852C_ADDR	= 0x37f,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_3_8852C_ADDR	= 0x380,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_4_8852C_ADDR	= 0x381,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_5_8852C_ADDR	= 0x382,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_6_8852C_ADDR	= 0x383,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_7_8852C_ADDR	= 0x384,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_8_8852C_ADDR	= 0x385,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_9_8852C_ADDR	= 0x386,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_10_8852C_ADDR	= 0x387,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_11_8852C_ADDR	= 0x388,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_12_8852C_ADDR	= 0x389,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_13_8852C_ADDR	= 0x38a,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_14_8852C_ADDR	= 0x38b,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_15_8852C_ADDR	= 0x38c,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_16_8852C_ADDR	= 0x38d,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_17_8852C_ADDR	= 0x38e,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_18_8852C_ADDR	= 0x38f,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_19_8852C_ADDR	= 0x390,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_20_8852C_ADDR	= 0x391,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_21_8852C_ADDR	= 0x392,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_22_8852C_ADDR	= 0x393,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_23_8852C_ADDR	= 0x394,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_24_8852C_ADDR	= 0x395,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_25_8852C_ADDR	= 0x396,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_26_8852C_ADDR	= 0x397,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_27_8852C_ADDR	= 0x398,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_28_8852C_ADDR	= 0x399,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_29_8852C_ADDR	= 0x39a,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_30_8852C_ADDR	= 0x39b,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_31_8852C_ADDR	= 0x39c,
	EFUSE_INFO_RF_6G_BW40M_D_TSSI_DE_32_8852C_ADDR	= 0x39d,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GL1_8852C_ADDR	= 0x3a8,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GL2_8852C_ADDR	= 0x3aa,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GL3_8852C_ADDR	= 0x3ac,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GM1_8852C_ADDR	= 0x3ae,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GM2_8852C_ADDR	= 0x3b0,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GM3_8852C_ADDR	= 0x3b2,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GH1_8852C_ADDR	= 0x3b4,
	EFUSE_INFO_RF_RX_GAIN_K_A_6GH2_8852C_ADDR	= 0x3b6,
	EFUSE_INFO_RF_6G_BW160M_BW40M_DIFF_ADDR		= 0x3ca
};

enum halrf_efsue_default_value_8852c {
	EFUSE_INFO_RF_RFE_8852C_VALUE		= 0x1,
	EFUSE_INFO_RF_CHAN_PLAN_8852C_VALUE	= 0x7f,
	EFUSE_INFO_RF_XTAL_8852C_VALUE		= 0x3f,
	EFUSE_INFO_RF_THERMAL_A_8852C_VALUE	= 0x22,
	EFUSE_INFO_RF_THERMAL_B_8852C_VALUE	= 0x22,
	EFUSE_INFO_RF_TSSI_DE_8852C_VALUE	= 0x0,
	EFUSE_INFO_RF_RX_GAIN_K_8852C_VALUE	= 0xff,
	EFUSE_INFO_RF_BOARD_OPTION_8852C_VALUE	= 0x1,
	EFUSE_INFO_RF_5G_DIFF_VALUE_1		= 0x0,
	EFUSE_INFO_RF_5G_DIFF_VALUE_2		= 0xf,
	EFUSE_INFO_RF_BW_DIFF_VALUE		= 0x0,
};

bool halrf_get_efuse_info_8852c(struct rf_info *rf, u8 *efuse_map,
		       enum rtw_efuse_info id, void *value, u32 length,
		       u8 autoload_status);

#endif	/*RF_8852C_SUPPORT*/
#endif	/*_HALRF_EFUSE_8852C_H_*/

