/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.12*/
#ifndef _HALRF_HWIMG_RAW_DATA_8852C_H
#define _HALRF_HWIMG_RAW_DATA_8852C_H

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE


#if 0
/* Please put following enum definitions in appropriate header file. */
enum odm_pw_byrate_para_type {
	PW_BYRATE_PARA_NSS1,
	PW_BYRATE_PARA_NSS2,
	PW_BYRATE_PARA_OFFS = 0xF
};

enum odm_pw_byrate_rate_type {
	PW_BYRATE_RATE_11M_1M,
	PW_BYRATE_RATE_18M_6M,
	PW_BYRATE_RATE_54M_24M,
	PW_BYRATE_RATE_MCS3_0,
	PW_BYRATE_RATE_MCS7_4,
	PW_BYRATE_RATE_MCS11_8,
	PW_BYRATE_RATE_DCM4_0,
	PW_BYRATE_RATE_AllRate2_1,  /* CCK, OFDM, HT, VHT */
	PW_BYRATE_RATE_AllRate2_2,  /* HE_HEDCM */
	PW_BYRATE_RATE_AllRate5_1,  /* OFDM, HT, VHT, HE_HEDCM */
	PW_BYRATE_RATE_AllRate6_1,  /* OFDM, HT, VHT, HE_HEDCM (6G) */
	PW_BYRATE_RATE_NULL = 0xF
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC,
	PW_LMT_REGU_ETSI,
	PW_LMT_REGU_MKK,
	PW_LMT_REGU_IC,
	PW_LMT_REGU_KCC,
	PW_LMT_REGU_ACMA,
	PW_LMT_REGU_CHILE,
	PW_LMT_REGU_UKRAINE,
	PW_LMT_REGU_MEXICO,
	PW_LMT_REGU_CN,
	PW_LMT_REGU_WW13,
	PW_LMT_REGU_NULL
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_2_4G,
	PW_LMT_BAND_5G,
	PW_LMT_BAND_6G,
	PW_LMT_BAND_NULL
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_20M,
	PW_LMT_BW_40M,
	PW_LMT_BW_80M,
	PW_LMT_BW_160M,
	PW_LMT_BW_NULL
};

enum odm_pw_lmt_ru_bandwidth_type {
	PW_LMT_RU_BW_RU26,
	PW_LMT_RU_BW_RU52,
	PW_LMT_RU_BW_RU106,
	PW_LMT_RU_BW_NULL
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_CCK,
	PW_LMT_RS_OFDM,
	PW_LMT_RS_HT,
	PW_LMT_RS_VHT,
	PW_LMT_RS_HE,
	PW_LMT_RS_NULL
};

enum odm_pw_lmt_beamform_type {
	PW_LMT_BF,
	PW_LMT_NONBF,
	PW_LMT_NULL
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_1T,
	PW_LMT_PH_2T,
	PW_LMT_PH_3T,
	PW_LMT_PH_4T,
	PW_LMT_PH_NULL
};

struct halrf_tx_pw_lmt {
	u8			band:1;
	u8			bw:3;
	u8			rs:2;
	u8			ntx:2;
	u8			bf:3;
	u8			reg:5;
	u8			ch;
	s8			val;
};

struct halrf_tx_pw_lmt_ru {
	u8			band:1;
	u8			bw:2;
	u8			ntx:2;
	u8			rs:3;
	u8			reg;
	u8			ch;
	s8			val;
};
#endif


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8852c_radioa[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0010001, 0x00000002,
		0xF0020001, 0x00000003,
		0xF0030001, 0x00000004,
		0xF0040001, 0x00000005,
		0xF0050001, 0x00000006,
		0xF0070001, 0x00000007,
		0xF0150001, 0x00000008,
		0xF0160001, 0x00000009,
		0xF0320001, 0x0000000A,
		0xF0330001, 0x0000000B,
		0xF0340001, 0x0000000C,
		0xF0350001, 0x0000000D,
		0xF0360001, 0x0000000E,
		0xF03F0001, 0x0000000F,
		0xF0400001, 0x00000010,
		0x005, 0x00000000,
		0x10005, 0x00000000,
		0x000, 0x00030001,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x0A3, 0x000B9204,
		0x0AD, 0x00091E0F,
		0x05D, 0x00001012,
		0x05C, 0x00061C5C,
		0x062, 0x00055220,
		0x0D3, 0x00000103,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000620,
		0x03F, 0x0000020C,
		0x0EF, 0x00000000,
		0x05F, 0x00000038,
		0x097, 0x00043200,
		0x0A6, 0x00066DB7,
		0x0EF, 0x00004000,
		0x033, 0x00000005,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x00000003,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x00000002,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x0000000D,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x0000000B,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x0000000A,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x0EF, 0x00000000,
		0x000, 0x00033C01,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x096, 0x00015200,
		0x10055, 0x00080080,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0004D000,
		0x0DA, 0x000D4009,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0004D000,
		0x0DA, 0x000D4009,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0xA0000000,	0x00000000,
		0x067, 0x0004D000,
		0x0DA, 0x000D4009,
	0xB0000000,	0x00000000,
		0x057, 0x0000D589,
		0x05A, 0x0007FFFF,
		0x043, 0x00005000,
		0x0B5, 0x00001720,
		0x0ED, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x00013FAB,
		0x03F, 0x000FD800,
		0x033, 0x00000010,
		0x03E, 0x00013FAB,
		0x03F, 0x000FD800,
		0x033, 0x00000020,
		0x03E, 0x00013FAB,
		0x03F, 0x000FD800,
		0x0ED, 0x00000000,
		0x0ED, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x000000FA,
		0x033, 0x00000001,
		0x03F, 0x000000F2,
		0x033, 0x00000002,
		0x03F, 0x000000EA,
		0x033, 0x00000003,
		0x03F, 0x000000E2,
		0x033, 0x00000004,
		0x03F, 0x000000DA,
		0x033, 0x00000005,
		0x03F, 0x000000D2,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CA,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CA,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000CC,
	0xA0000000,	0x00000000,
		0x03F, 0x000000CA,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C2,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C2,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000C4,
	0xA0000000,	0x00000000,
		0x03F, 0x000000C2,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0xA0000000,	0x00000000,
		0x03F, 0x000000B8,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B0,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B0,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0xA0000000,	0x00000000,
		0x03F, 0x000000B0,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0xA0000000,	0x00000000,
		0x03F, 0x000000A8,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A0,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A0,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000000A0,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000098,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000098,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000098,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000098,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000098,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0xA0000000,	0x00000000,
		0x03F, 0x00000098,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000088,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000088,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000088,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000088,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000088,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0xA0000000,	0x00000000,
		0x03F, 0x00000088,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000BC,
	0xA0000000,	0x00000000,
		0x03F, 0x000000B8,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B0,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B0,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000B4,
	0xA0000000,	0x00000000,
		0x03F, 0x000000B0,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A8,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A8,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000AC,
	0xA0000000,	0x00000000,
		0x03F, 0x000000A8,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A0,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A0,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000000A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000000A0,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000098,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000098,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000098,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000090,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000090,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000094,
	0xA0000000,	0x00000000,
		0x03F, 0x00000090,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000088,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000088,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000008C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000088,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000080,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000080,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000084,
	0xA0000000,	0x00000000,
		0x03F, 0x00000080,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000038,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000038,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000003C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000038,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000030,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000030,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000034,
	0xA0000000,	0x00000000,
		0x03F, 0x00000030,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000028,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000028,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000002C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000028,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000020,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000020,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000024,
	0xA0000000,	0x00000000,
		0x03F, 0x00000020,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000018,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000018,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000001C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000018,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000010,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000010,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000014,
	0xA0000000,	0x00000000,
		0x03F, 0x00000010,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000008,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000008,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000000C,
	0xA0000000,	0x00000000,
		0x03F, 0x00000008,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000004,
	0xA0000000,	0x00000000,
		0x03F, 0x00000000,
	0xB0000000,	0x00000000,
		0x0ED, 0x00000000,
		0x0B9, 0x00020440,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000000,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1752,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1752,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0xA0000000,	0x00000000,
		0x08F, 0x000D1752,
	0xB0000000,	0x00000000,
		0x0EB, 0x00000000,
		0x030, 0x000109B0,
		0x030, 0x000189B0,
		0x0EB, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
		0x03F, 0x00000017,
		0x033, 0x00000002,
		0x03F, 0x00000017,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0xA0000000,	0x00000000,
		0x03F, 0x00000007,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00060001,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00000001,
		0x033, 0x00000025,
		0x03F, 0x00000002,
		0x033, 0x00000026,
		0x03F, 0x00000003,
		0x033, 0x00000027,
		0x03F, 0x00000003,
		0x033, 0x00000028,
		0x03F, 0x00060001,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00000001,
		0x033, 0x0000002D,
		0x03F, 0x00000002,
		0x033, 0x0000002E,
		0x03F, 0x00000003,
		0x033, 0x0000002F,
		0x03F, 0x00000003,
		0x033, 0x00000030,
		0x03F, 0x00060001,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00000001,
		0x033, 0x00000035,
		0x03F, 0x00000002,
		0x033, 0x00000036,
		0x03F, 0x00000003,
		0x033, 0x00000037,
		0x03F, 0x00000003,
		0x033, 0x00000060,
		0x03F, 0x00060001,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00000001,
		0x033, 0x00000065,
		0x03F, 0x00000002,
		0x033, 0x00000066,
		0x03F, 0x00000003,
		0x033, 0x00000067,
		0x03F, 0x00000003,
		0x033, 0x00000068,
		0x03F, 0x00060001,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00000001,
		0x033, 0x0000006D,
		0x03F, 0x00000002,
		0x033, 0x0000006E,
		0x03F, 0x00000003,
		0x033, 0x0000006F,
		0x03F, 0x00000003,
		0x033, 0x00000070,
		0x03F, 0x00060001,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00000001,
		0x033, 0x00000075,
		0x03F, 0x00000002,
		0x033, 0x00000076,
		0x03F, 0x00000003,
		0x033, 0x00000077,
		0x03F, 0x00000003,
		0x033, 0x00000078,
		0x03F, 0x00060001,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00000001,
		0x033, 0x0000007D,
		0x03F, 0x00000002,
		0x033, 0x0000007E,
		0x03F, 0x00000003,
		0x033, 0x0000007F,
		0x03F, 0x00000003,
		0x033, 0x000000A0,
		0x03F, 0x00060001,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00000001,
		0x033, 0x000000A5,
		0x03F, 0x00000002,
		0x033, 0x000000A6,
		0x03F, 0x00000003,
		0x033, 0x000000A7,
		0x03F, 0x00000003,
		0x033, 0x000000A8,
		0x03F, 0x00060001,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00000001,
		0x033, 0x000000AD,
		0x03F, 0x00000002,
		0x033, 0x000000AE,
		0x03F, 0x00000003,
		0x033, 0x000000AF,
		0x03F, 0x00000003,
		0x033, 0x000000B0,
		0x03F, 0x00060001,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00000001,
		0x033, 0x000000B5,
		0x03F, 0x00000002,
		0x033, 0x000000B6,
		0x03F, 0x00000003,
		0x033, 0x000000B7,
		0x03F, 0x00000003,
		0x033, 0x000000E0,
		0x03F, 0x00060001,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00000001,
		0x033, 0x000000E5,
		0x03F, 0x00000002,
		0x033, 0x000000E6,
		0x03F, 0x00000003,
		0x033, 0x000000E7,
		0x03F, 0x00000003,
		0x033, 0x000000E8,
		0x03F, 0x00060001,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00000001,
		0x033, 0x000000ED,
		0x03F, 0x00000002,
		0x033, 0x000000EE,
		0x03F, 0x00000003,
		0x033, 0x000000EF,
		0x03F, 0x00000003,
		0x033, 0x000000F0,
		0x03F, 0x00060001,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00000001,
		0x033, 0x000000F5,
		0x03F, 0x00000002,
		0x033, 0x000000F6,
		0x03F, 0x00000003,
		0x033, 0x000000F7,
		0x03F, 0x00000003,
		0x033, 0x000000F8,
		0x03F, 0x00060001,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00000001,
		0x033, 0x000000FD,
		0x03F, 0x00000002,
		0x033, 0x000000FE,
		0x03F, 0x00000003,
		0x033, 0x000000FF,
		0x03F, 0x00000003,
		0x033, 0x00000120,
		0x03F, 0x00060001,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00000001,
		0x033, 0x00000125,
		0x03F, 0x00000002,
		0x033, 0x00000126,
		0x03F, 0x00000003,
		0x033, 0x00000127,
		0x03F, 0x00000003,
		0x033, 0x00000128,
		0x03F, 0x00060001,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00000001,
		0x033, 0x0000012D,
		0x03F, 0x00000002,
		0x033, 0x0000012E,
		0x03F, 0x00000003,
		0x033, 0x0000012F,
		0x03F, 0x00000003,
		0x033, 0x00000130,
		0x03F, 0x00060001,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00000001,
		0x033, 0x00000135,
		0x03F, 0x00000002,
		0x033, 0x00000136,
		0x03F, 0x00000003,
		0x033, 0x00000137,
		0x03F, 0x00000003,
		0x033, 0x00000160,
		0x03F, 0x00060001,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00000001,
		0x033, 0x00000165,
		0x03F, 0x00000002,
		0x033, 0x00000166,
		0x03F, 0x00000003,
		0x033, 0x00000167,
		0x03F, 0x00000003,
		0x033, 0x00000168,
		0x03F, 0x00060001,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00000001,
		0x033, 0x0000016D,
		0x03F, 0x00000002,
		0x033, 0x0000016E,
		0x03F, 0x00000003,
		0x033, 0x0000016F,
		0x03F, 0x00000003,
		0x033, 0x00000170,
		0x03F, 0x00060001,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00000001,
		0x033, 0x00000175,
		0x03F, 0x00000002,
		0x033, 0x00000176,
		0x03F, 0x00000003,
		0x033, 0x00000177,
		0x03F, 0x00000003,
		0x033, 0x00000178,
		0x03F, 0x00060001,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00000001,
		0x033, 0x0000017D,
		0x03F, 0x00000002,
		0x033, 0x0000017E,
		0x03F, 0x00000003,
		0x033, 0x0000017F,
		0x03F, 0x00000003,
		0x033, 0x000001A0,
		0x03F, 0x00060001,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00000001,
		0x033, 0x000001A5,
		0x03F, 0x00000002,
		0x033, 0x000001A6,
		0x03F, 0x00000003,
		0x033, 0x000001A7,
		0x03F, 0x00000003,
		0x033, 0x000001A8,
		0x03F, 0x00060001,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00000001,
		0x033, 0x000001AD,
		0x03F, 0x00000002,
		0x033, 0x000001AE,
		0x03F, 0x00000003,
		0x033, 0x000001AF,
		0x03F, 0x00000003,
		0x033, 0x000001B0,
		0x03F, 0x00060001,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00000001,
		0x033, 0x000001B5,
		0x03F, 0x00000002,
		0x033, 0x000001B6,
		0x03F, 0x00000003,
		0x033, 0x000001B7,
		0x03F, 0x00000003,
		0x033, 0x000001E0,
		0x03F, 0x00060001,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00000001,
		0x033, 0x000001E5,
		0x03F, 0x00000002,
		0x033, 0x000001E6,
		0x03F, 0x00000003,
		0x033, 0x000001E7,
		0x03F, 0x00000003,
		0x033, 0x000001E8,
		0x03F, 0x00060001,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00000001,
		0x033, 0x000001ED,
		0x03F, 0x00000002,
		0x033, 0x000001EE,
		0x03F, 0x00000003,
		0x033, 0x000001EF,
		0x03F, 0x00000003,
		0x033, 0x000001F0,
		0x03F, 0x00060001,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00000001,
		0x033, 0x000001F5,
		0x03F, 0x00000002,
		0x033, 0x000001F6,
		0x03F, 0x00000003,
		0x033, 0x000001F7,
		0x03F, 0x00000003,
		0x033, 0x000001F8,
		0x03F, 0x00060001,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00000001,
		0x033, 0x000001FD,
		0x03F, 0x00000002,
		0x033, 0x000001FE,
		0x03F, 0x00000003,
		0x033, 0x000001FF,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000E3FF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000E3FF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000E3FF,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00004344,
		0x033, 0x00000001,
		0x03F, 0x00004344,
		0x033, 0x00000002,
		0x03F, 0x00004344,
		0x033, 0x00000003,
		0x03F, 0x00004344,
		0x033, 0x00000004,
		0x03F, 0x00004344,
		0x033, 0x00000005,
		0x03F, 0x00004344,
		0x033, 0x00000006,
		0x03F, 0x00004344,
		0x033, 0x00000007,
		0x03F, 0x00004344,
		0x033, 0x00000008,
		0x03F, 0x00004344,
		0x033, 0x00000009,
		0x03F, 0x00004344,
		0x033, 0x0000000A,
		0x03F, 0x00004344,
		0x033, 0x0000000B,
		0x03F, 0x00004344,
		0x033, 0x00000010,
		0x03F, 0x00004344,
		0x033, 0x00000011,
		0x03F, 0x00004344,
		0x033, 0x00000012,
		0x03F, 0x00004344,
		0x033, 0x00000013,
		0x03F, 0x00004344,
		0x033, 0x00000014,
		0x03F, 0x00004344,
		0x033, 0x00000015,
		0x03F, 0x00004344,
		0x033, 0x00000016,
		0x03F, 0x00004344,
		0x033, 0x00000017,
		0x03F, 0x00004344,
		0x033, 0x00000018,
		0x03F, 0x00004344,
		0x033, 0x00000019,
		0x03F, 0x00004344,
		0x033, 0x0000001A,
		0x03F, 0x00004344,
		0x033, 0x0000001B,
		0x03F, 0x00004344,
		0x033, 0x0000001C,
		0x03F, 0x00004344,
		0x033, 0x0000001D,
		0x03F, 0x00004344,
		0x033, 0x0000001E,
		0x03F, 0x00004344,
		0x033, 0x0000001F,
		0x03F, 0x00004344,
		0x0EF, 0x00000000,
		0x0EF, 0x00000020,
		0x033, 0x00000010,
		0x03F, 0x00000200,
		0x033, 0x00000011,
		0x03F, 0x00000200,
		0x033, 0x00000012,
		0x03F, 0x00000200,
		0x033, 0x00000013,
		0x03F, 0x00000200,
		0x033, 0x00000020,
		0x03F, 0x00000200,
		0x033, 0x00000021,
		0x03F, 0x00000200,
		0x033, 0x00000022,
		0x03F, 0x00000200,
		0x033, 0x00000023,
		0x03F, 0x00000200,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000084DC,
		0x030, 0x000103C9,
		0x030, 0x00018399,
		0x030, 0x00020287,
		0x030, 0x00028277,
		0x030, 0x00030165,
		0x030, 0x00038144,
		0x030, 0x00040044,
		0x030, 0x00048022,
		0x030, 0x00050011,
		0x030, 0x00058000,
		0x030, 0x00060000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000084DC,
		0x030, 0x000103C9,
		0x030, 0x00018399,
		0x030, 0x00020287,
		0x030, 0x00028277,
		0x030, 0x00030165,
		0x030, 0x00038144,
		0x030, 0x00040044,
		0x030, 0x00048022,
		0x030, 0x00050011,
		0x030, 0x00058000,
		0x030, 0x00060000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0xA0000000,	0x00000000,
		0x030, 0x000084DC,
		0x030, 0x000103C9,
		0x030, 0x00018399,
		0x030, 0x00020287,
		0x030, 0x00028277,
		0x030, 0x00030165,
		0x030, 0x00038144,
		0x030, 0x00040044,
		0x030, 0x00048022,
		0x030, 0x00050011,
		0x030, 0x00058000,
		0x030, 0x00060000,
	0xB0000000,	0x00000000,
		0x030, 0x00068000,
		0x030, 0x00070000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000004,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000005,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000006,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x00000007,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x00000008,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000009,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x0000000A,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x0000000B,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x0000000C,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x0000000D,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x0000000E,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x0000000F,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x00000010,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000011,
		0x03E, 0x0000001B,
		0x03F, 0x00023C58,
		0x033, 0x00000012,
		0x03E, 0x00000014,
		0x03F, 0x00021C58,
		0x033, 0x00000013,
		0x03E, 0x00000014,
		0x03F, 0x00022B58,
		0x033, 0x00000014,
		0x03E, 0x00000013,
		0x03F, 0x00023C58,
		0x033, 0x00000015,
		0x03E, 0x0000001B,
		0x03F, 0x00025A58,
		0x033, 0x00000016,
		0x03E, 0x0000001C,
		0x03F, 0x00021C58,
		0x033, 0x00000017,
		0x03E, 0x00000014,
		0x03F, 0x00022A58,
		0x033, 0x00000018,
		0x03E, 0x00000013,
		0x03F, 0x00025A58,
		0x033, 0x00000019,
		0x03E, 0x0000001B,
		0x03F, 0x00025A58,
		0x033, 0x0000001A,
		0x03E, 0x00000014,
		0x03F, 0x00022A58,
		0x033, 0x0000001B,
		0x03E, 0x00000014,
		0x03F, 0x00022A58,
		0x033, 0x0000001C,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000001D,
		0x03E, 0x0000001B,
		0x03F, 0x00025A58,
		0x033, 0x0000001E,
		0x03E, 0x00000013,
		0x03F, 0x00021E58,
		0x033, 0x0000001F,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000020,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000021,
		0x03E, 0x0000001C,
		0x03F, 0x0002CD58,
		0x033, 0x00000022,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000023,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000024,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000025,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000026,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000027,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000028,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000029,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000002A,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000002B,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x0000002C,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000002D,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000002E,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000002F,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000030,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000031,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000032,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000033,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000034,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000035,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000036,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x00000037,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x00000038,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x00000039,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000003A,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000003B,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x033, 0x0000003C,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000003D,
		0x03E, 0x00000014,
		0x03F, 0x0002CD58,
		0x033, 0x0000003E,
		0x03E, 0x00000014,
		0x03F, 0x00021E58,
		0x033, 0x0000003F,
		0x03E, 0x00000014,
		0x03F, 0x00022D58,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000031,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x033, 0x00000002,
		0x03F, 0x00000015,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EC, 0x00000400,
		0x033, 0x00000003,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000021,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
		0x0A7, 0x00080308,
		0x066, 0x00006000,
		0x0EF, 0x00000400,
		0x030, 0x000001FF,
		0x030, 0x000081FF,
		0x030, 0x000101FF,
		0x030, 0x000181FF,
		0x030, 0x000201FF,
		0x030, 0x000281FF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003017F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003017F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000300FF,
	0xA0000000,	0x00000000,
		0x030, 0x0003017F,
	0xB0000000,	0x00000000,
		0x030, 0x000380FB,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06D, 0x00000C31,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0380,
		0x06B, 0x00003CA0,
		0x06F, 0x000C01FC,
		0x05E, 0x0000001F,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0380,
		0x06B, 0x00003CA0,
		0x06F, 0x000C01FC,
		0x05E, 0x0000001F,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0xA0000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
		0x05E, 0x0000001F,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0xA0000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EB, 0x00080000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0000803C,
		0x030, 0x0001003C,
		0x030, 0x0001803C,
		0x030, 0x0002003C,
		0x030, 0x0002803C,
		0x030, 0x0003003C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0000803C,
		0x030, 0x0001003C,
		0x030, 0x0001803C,
		0x030, 0x0002003C,
		0x030, 0x0002803C,
		0x030, 0x0003003C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0xA0000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0xB0000000,	0x00000000,
		0x030, 0x0003803C,
		0x030, 0x0004003C,
		0x030, 0x0004803C,
		0x030, 0x0005003C,
		0x030, 0x0005803C,
		0x030, 0x0006003C,
		0x030, 0x0006803C,
		0x030, 0x0007003C,
		0x0EB, 0x00000000,
		0x094, 0x000000FC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0xA0000000,	0x00000000,
		0x095, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E7,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
		0x03F, 0x000002E7,
		0x033, 0x0000003C,
		0x03F, 0x000003E7,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000003D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000003E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000060,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000064,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000068,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000070,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000074,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000078,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000061,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000065,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000069,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000071,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000075,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000079,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000062,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000066,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x0000006A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000072,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000076,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000063,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000067,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x0000006B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000073,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000077,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007B,
		0x03F, 0x000002E7,
		0x033, 0x0000007F,
		0x03F, 0x000003E7,
		0x0EE, 0x00000000,
		0x100EE, 0x00004000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201ED,
		0x10030, 0x000205AD,
		0x10030, 0x000209A7,
		0x10030, 0x00020DA1,
		0x10030, 0x0002119B,
		0x10030, 0x00021561,
		0x10030, 0x0002195B,
		0x10030, 0x00021D27,
		0x10030, 0x00022121,
		0x10030, 0x000224E9,
		0x10030, 0x000228E3,
		0x10030, 0x00022CA9,
		0x10030, 0x000230A3,
		0x10030, 0x00023469,
		0x10030, 0x00023863,
		0x10030, 0x00023C29,
		0x10030, 0x00024023,
		0x10030, 0x0002441D,
		0x10030, 0x000281EF,
		0x10030, 0x000285AF,
		0x10030, 0x000289A9,
		0x10030, 0x00028DA3,
		0x10030, 0x0002919D,
		0x10030, 0x00029563,
		0x10030, 0x0002995D,
		0x10030, 0x00029D25,
		0x10030, 0x0002A11F,
		0x10030, 0x0002A4E7,
		0x10030, 0x0002A8E1,
		0x10030, 0x0002ACA7,
		0x10030, 0x0002B0A1,
		0x10030, 0x0002B467,
		0x10030, 0x0002B861,
		0x10030, 0x0002BC27,
		0x10030, 0x0002C021,
		0x10030, 0x0002C41B,
		0x10030, 0x000301EF,
		0x10030, 0x000305AF,
		0x10030, 0x000309A9,
		0x10030, 0x00030DA3,
		0x10030, 0x0003119D,
		0x10030, 0x00031563,
		0x10030, 0x0003195D,
		0x10030, 0x00031D25,
		0x10030, 0x0003211F,
		0x10030, 0x000324E7,
		0x10030, 0x000328E1,
		0x10030, 0x00032CA7,
		0x10030, 0x000330A1,
		0x10030, 0x00033467,
		0x10030, 0x00033861,
		0x10030, 0x00033C27,
		0x10030, 0x00034021,
		0x10030, 0x0003441B,
		0x10030, 0x000601EB,
		0x10030, 0x000605AB,
		0x10030, 0x000609A5,
		0x10030, 0x00060D9F,
		0x10030, 0x00061199,
		0x10030, 0x00061593,
		0x10030, 0x00061959,
		0x10030, 0x00061D53,
		0x10030, 0x0006211B,
		0x10030, 0x00062515,
		0x10030, 0x000628DD,
		0x10030, 0x00062CD7,
		0x10030, 0x0006309D,
		0x10030, 0x00063497,
		0x10030, 0x0006385D,
		0x10030, 0x00063C57,
		0x10030, 0x0006401D,
		0x10030, 0x00064417,
		0x10030, 0x000681E7,
		0x10030, 0x000685A7,
		0x10030, 0x000689A1,
		0x10030, 0x00068D9B,
		0x10030, 0x00069195,
		0x10030, 0x0006955F,
		0x10030, 0x00069959,
		0x10030, 0x00069D21,
		0x10030, 0x0006A11B,
		0x10030, 0x0006A4E3,
		0x10030, 0x0006A8DD,
		0x10030, 0x0006ACA5,
		0x10030, 0x0006B09F,
		0x10030, 0x0006B465,
		0x10030, 0x0006B85F,
		0x10030, 0x0006BC25,
		0x10030, 0x0006C01F,
		0x10030, 0x0006C419,
		0x10030, 0x000701E7,
		0x10030, 0x000705A7,
		0x10030, 0x000709A1,
		0x10030, 0x00070D9B,
		0x10030, 0x00071195,
		0x10030, 0x0007155B,
		0x10030, 0x00071955,
		0x10030, 0x00071D1D,
		0x10030, 0x00072117,
		0x10030, 0x000724DF,
		0x10030, 0x000728D9,
		0x10030, 0x00072CA1,
		0x10030, 0x0007309B,
		0x10030, 0x00073461,
		0x10030, 0x0007385B,
		0x10030, 0x00073C21,
		0x10030, 0x0007401B,
		0x10030, 0x0007441B,
		0x10030, 0x000781E9,
		0x10030, 0x000785A9,
		0x10030, 0x000789A3,
		0x10030, 0x00078D9D,
		0x10030, 0x00079197,
		0x10030, 0x00079591,
		0x10030, 0x00079957,
		0x10030, 0x00079D51,
		0x10030, 0x0007A119,
		0x10030, 0x0007A513,
		0x10030, 0x0007A8D9,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B099,
		0x10030, 0x0007B493,
		0x10030, 0x0007B859,
		0x10030, 0x0007BC53,
		0x10030, 0x0007C019,
		0x10030, 0x0007C413,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201ED,
		0x10030, 0x000205AD,
		0x10030, 0x000209A7,
		0x10030, 0x00020DA1,
		0x10030, 0x0002119B,
		0x10030, 0x00021561,
		0x10030, 0x0002195B,
		0x10030, 0x00021D27,
		0x10030, 0x00022121,
		0x10030, 0x000224E9,
		0x10030, 0x000228E3,
		0x10030, 0x00022CA9,
		0x10030, 0x000230A3,
		0x10030, 0x00023469,
		0x10030, 0x00023863,
		0x10030, 0x00023C29,
		0x10030, 0x00024023,
		0x10030, 0x0002441D,
		0x10030, 0x000281EF,
		0x10030, 0x000285AF,
		0x10030, 0x000289A9,
		0x10030, 0x00028DA3,
		0x10030, 0x0002919D,
		0x10030, 0x00029563,
		0x10030, 0x0002995D,
		0x10030, 0x00029D25,
		0x10030, 0x0002A11F,
		0x10030, 0x0002A4E7,
		0x10030, 0x0002A8E1,
		0x10030, 0x0002ACA7,
		0x10030, 0x0002B0A1,
		0x10030, 0x0002B467,
		0x10030, 0x0002B861,
		0x10030, 0x0002BC27,
		0x10030, 0x0002C021,
		0x10030, 0x0002C41B,
		0x10030, 0x000301EF,
		0x10030, 0x000305AF,
		0x10030, 0x000309A9,
		0x10030, 0x00030DA3,
		0x10030, 0x0003119D,
		0x10030, 0x00031563,
		0x10030, 0x0003195D,
		0x10030, 0x00031D25,
		0x10030, 0x0003211F,
		0x10030, 0x000324E7,
		0x10030, 0x000328E1,
		0x10030, 0x00032CA7,
		0x10030, 0x000330A1,
		0x10030, 0x00033467,
		0x10030, 0x00033861,
		0x10030, 0x00033C27,
		0x10030, 0x00034021,
		0x10030, 0x0003441B,
		0x10030, 0x000601EB,
		0x10030, 0x000605AB,
		0x10030, 0x000609A5,
		0x10030, 0x00060D9F,
		0x10030, 0x00061199,
		0x10030, 0x00061593,
		0x10030, 0x00061959,
		0x10030, 0x00061D53,
		0x10030, 0x0006211B,
		0x10030, 0x00062515,
		0x10030, 0x000628DD,
		0x10030, 0x00062CD7,
		0x10030, 0x0006309D,
		0x10030, 0x00063497,
		0x10030, 0x0006385D,
		0x10030, 0x00063C57,
		0x10030, 0x0006401D,
		0x10030, 0x00064417,
		0x10030, 0x000681E7,
		0x10030, 0x000685A7,
		0x10030, 0x000689A1,
		0x10030, 0x00068D9B,
		0x10030, 0x00069195,
		0x10030, 0x0006955F,
		0x10030, 0x00069959,
		0x10030, 0x00069D21,
		0x10030, 0x0006A11B,
		0x10030, 0x0006A4E3,
		0x10030, 0x0006A8DD,
		0x10030, 0x0006ACA5,
		0x10030, 0x0006B09F,
		0x10030, 0x0006B465,
		0x10030, 0x0006B85F,
		0x10030, 0x0006BC25,
		0x10030, 0x0006C01F,
		0x10030, 0x0006C419,
		0x10030, 0x000701E7,
		0x10030, 0x000705A7,
		0x10030, 0x000709A1,
		0x10030, 0x00070D9B,
		0x10030, 0x00071195,
		0x10030, 0x0007155B,
		0x10030, 0x00071955,
		0x10030, 0x00071D1D,
		0x10030, 0x00072117,
		0x10030, 0x000724DF,
		0x10030, 0x000728D9,
		0x10030, 0x00072CA1,
		0x10030, 0x0007309B,
		0x10030, 0x00073461,
		0x10030, 0x0007385B,
		0x10030, 0x00073C21,
		0x10030, 0x0007401B,
		0x10030, 0x0007441B,
		0x10030, 0x000781E9,
		0x10030, 0x000785A9,
		0x10030, 0x000789A3,
		0x10030, 0x00078D9D,
		0x10030, 0x00079197,
		0x10030, 0x00079591,
		0x10030, 0x00079957,
		0x10030, 0x00079D51,
		0x10030, 0x0007A119,
		0x10030, 0x0007A513,
		0x10030, 0x0007A8D9,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B099,
		0x10030, 0x0007B493,
		0x10030, 0x0007B859,
		0x10030, 0x0007BC53,
		0x10030, 0x0007C019,
		0x10030, 0x0007C413,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701EF,
		0x10030, 0x000705E7,
		0x10030, 0x000709A7,
		0x10030, 0x00070D61,
		0x10030, 0x0007115B,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720DF,
		0x10030, 0x000724D9,
		0x10030, 0x000728A1,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA1,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x00079921,
		0x10030, 0x00079D1B,
		0x10030, 0x0007A0E3,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B823,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0xA0000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201ED,
		0x10030, 0x000205AD,
		0x10030, 0x000209A7,
		0x10030, 0x00020DA1,
		0x10030, 0x0002119B,
		0x10030, 0x00021561,
		0x10030, 0x0002195B,
		0x10030, 0x00021D27,
		0x10030, 0x00022121,
		0x10030, 0x000224E9,
		0x10030, 0x000228E3,
		0x10030, 0x00022CA9,
		0x10030, 0x000230A3,
		0x10030, 0x00023469,
		0x10030, 0x00023863,
		0x10030, 0x00023C29,
		0x10030, 0x00024023,
		0x10030, 0x0002441D,
		0x10030, 0x000281EF,
		0x10030, 0x000285AF,
		0x10030, 0x000289A9,
		0x10030, 0x00028DA3,
		0x10030, 0x0002919D,
		0x10030, 0x00029563,
		0x10030, 0x0002995D,
		0x10030, 0x00029D25,
		0x10030, 0x0002A11F,
		0x10030, 0x0002A4E7,
		0x10030, 0x0002A8E1,
		0x10030, 0x0002ACA7,
		0x10030, 0x0002B0A1,
		0x10030, 0x0002B467,
		0x10030, 0x0002B861,
		0x10030, 0x0002BC27,
		0x10030, 0x0002C021,
		0x10030, 0x0002C41B,
		0x10030, 0x000301EF,
		0x10030, 0x000305AF,
		0x10030, 0x000309A9,
		0x10030, 0x00030DA3,
		0x10030, 0x0003119D,
		0x10030, 0x00031563,
		0x10030, 0x0003195D,
		0x10030, 0x00031D25,
		0x10030, 0x0003211F,
		0x10030, 0x000324E7,
		0x10030, 0x000328E1,
		0x10030, 0x00032CA7,
		0x10030, 0x000330A1,
		0x10030, 0x00033467,
		0x10030, 0x00033861,
		0x10030, 0x00033C27,
		0x10030, 0x00034021,
		0x10030, 0x0003441B,
		0x10030, 0x000601EB,
		0x10030, 0x000605AB,
		0x10030, 0x000609A5,
		0x10030, 0x00060D9F,
		0x10030, 0x00061199,
		0x10030, 0x00061593,
		0x10030, 0x00061959,
		0x10030, 0x00061D53,
		0x10030, 0x0006211B,
		0x10030, 0x00062515,
		0x10030, 0x000628DD,
		0x10030, 0x00062CD7,
		0x10030, 0x0006309D,
		0x10030, 0x00063497,
		0x10030, 0x0006385D,
		0x10030, 0x00063C57,
		0x10030, 0x0006401D,
		0x10030, 0x00064417,
		0x10030, 0x000681E7,
		0x10030, 0x000685A7,
		0x10030, 0x000689A1,
		0x10030, 0x00068D9B,
		0x10030, 0x00069195,
		0x10030, 0x0006955F,
		0x10030, 0x00069959,
		0x10030, 0x00069D21,
		0x10030, 0x0006A11B,
		0x10030, 0x0006A4E3,
		0x10030, 0x0006A8DD,
		0x10030, 0x0006ACA5,
		0x10030, 0x0006B09F,
		0x10030, 0x0006B465,
		0x10030, 0x0006B85F,
		0x10030, 0x0006BC25,
		0x10030, 0x0006C01F,
		0x10030, 0x0006C419,
		0x10030, 0x000701E7,
		0x10030, 0x000705A7,
		0x10030, 0x000709A1,
		0x10030, 0x00070D9B,
		0x10030, 0x00071195,
		0x10030, 0x0007155B,
		0x10030, 0x00071955,
		0x10030, 0x00071D1D,
		0x10030, 0x00072117,
		0x10030, 0x000724DF,
		0x10030, 0x000728D9,
		0x10030, 0x00072CA1,
		0x10030, 0x0007309B,
		0x10030, 0x00073461,
		0x10030, 0x0007385B,
		0x10030, 0x00073C21,
		0x10030, 0x0007401B,
		0x10030, 0x0007441B,
		0x10030, 0x000781E9,
		0x10030, 0x000785A9,
		0x10030, 0x000789A3,
		0x10030, 0x00078D9D,
		0x10030, 0x00079197,
		0x10030, 0x00079591,
		0x10030, 0x00079957,
		0x10030, 0x00079D51,
		0x10030, 0x0007A119,
		0x10030, 0x0007A513,
		0x10030, 0x0007A8D9,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B099,
		0x10030, 0x0007B493,
		0x10030, 0x0007B859,
		0x10030, 0x0007BC53,
		0x10030, 0x0007C019,
		0x10030, 0x0007C413,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10030, 0x000000FC,
		0x10030, 0x000004F9,
		0x10030, 0x000008F6,
		0x10030, 0x00000CF3,
		0x10030, 0x000010F0,
		0x10030, 0x000014ED,
		0x10030, 0x000018AC,
		0x10030, 0x00001CA9,
		0x10030, 0x00002069,
		0x10030, 0x00002466,
		0x10030, 0x00002829,
		0x10030, 0x00002C26,
		0x10030, 0x00003023,
		0x10030, 0x00003420,
		0x10030, 0x0000381D,
		0x10030, 0x00003C1A,
		0x10030, 0x00004017,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x0002240D,
		0x10030, 0x0002280A,
		0x10030, 0x00022C07,
		0x10030, 0x00023004,
		0x10030, 0x00023401,
		0x10030, 0x00023800,
		0x10030, 0x00023C00,
		0x10030, 0x00024000,
		0x10030, 0x000280ED,
		0x10030, 0x000284EA,
		0x10030, 0x000288E7,
		0x10030, 0x00028CE4,
		0x10030, 0x000290E1,
		0x10030, 0x000294DE,
		0x10030, 0x000298DB,
		0x10030, 0x00029CD8,
		0x10030, 0x0002A0D5,
		0x10030, 0x0002A4D2,
		0x10030, 0x0002A8CF,
		0x10030, 0x0002AC0C,
		0x10030, 0x0002B009,
		0x10030, 0x0002B406,
		0x10030, 0x0002B803,
		0x10030, 0x0002BC00,
		0x10030, 0x0002C000,
		0x10030, 0x000300EE,
		0x10030, 0x000304EB,
		0x10030, 0x000308E8,
		0x10030, 0x00030CE5,
		0x10030, 0x000310E2,
		0x10030, 0x000314DF,
		0x10030, 0x000318DC,
		0x10030, 0x00031CD9,
		0x10030, 0x000320D6,
		0x10030, 0x000324D3,
		0x10030, 0x000328D0,
		0x10030, 0x00032CCD,
		0x10030, 0x0003300A,
		0x10030, 0x00033407,
		0x10030, 0x00033804,
		0x10030, 0x00033C01,
		0x10030, 0x00034000,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x0002240D,
		0x10030, 0x0002280A,
		0x10030, 0x00022C07,
		0x10030, 0x00023004,
		0x10030, 0x00023401,
		0x10030, 0x00023800,
		0x10030, 0x00023C00,
		0x10030, 0x00024000,
		0x10030, 0x000280ED,
		0x10030, 0x000284EA,
		0x10030, 0x000288E7,
		0x10030, 0x00028CE4,
		0x10030, 0x000290E1,
		0x10030, 0x000294DE,
		0x10030, 0x000298DB,
		0x10030, 0x00029CD8,
		0x10030, 0x0002A0D5,
		0x10030, 0x0002A4D2,
		0x10030, 0x0002A8CF,
		0x10030, 0x0002AC0C,
		0x10030, 0x0002B009,
		0x10030, 0x0002B406,
		0x10030, 0x0002B803,
		0x10030, 0x0002BC00,
		0x10030, 0x0002C000,
		0x10030, 0x000300EE,
		0x10030, 0x000304EB,
		0x10030, 0x000308E8,
		0x10030, 0x00030CE5,
		0x10030, 0x000310E2,
		0x10030, 0x000314DF,
		0x10030, 0x000318DC,
		0x10030, 0x00031CD9,
		0x10030, 0x000320D6,
		0x10030, 0x000324D3,
		0x10030, 0x000328D0,
		0x10030, 0x00032CCD,
		0x10030, 0x0003300A,
		0x10030, 0x00033407,
		0x10030, 0x00033804,
		0x10030, 0x00033C01,
		0x10030, 0x00034000,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0xA0000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0xB0000000,	0x00000000,
		0x10030, 0x000600F6,
		0x10030, 0x000604F3,
		0x10030, 0x000608F0,
		0x10030, 0x00060CED,
		0x10030, 0x000610EA,
		0x10030, 0x000614E7,
		0x10030, 0x000618E4,
		0x10030, 0x00061CE1,
		0x10030, 0x000620DE,
		0x10030, 0x000624DB,
		0x10030, 0x000628D8,
		0x10030, 0x00062CD5,
		0x10030, 0x000630D2,
		0x10030, 0x000634CF,
		0x10030, 0x000638CC,
		0x10030, 0x00063C09,
		0x10030, 0x00064006,
		0x10030, 0x000680F5,
		0x10030, 0x000684F2,
		0x10030, 0x000688EF,
		0x10030, 0x00068CEC,
		0x10030, 0x000690E9,
		0x10030, 0x000694E6,
		0x10030, 0x000698E3,
		0x10030, 0x00069CE0,
		0x10030, 0x0006A0DD,
		0x10030, 0x0006A4DA,
		0x10030, 0x0006A8D7,
		0x10030, 0x0006ACD4,
		0x10030, 0x0006B0D1,
		0x10030, 0x0006B4CE,
		0x10030, 0x0006B8CB,
		0x10030, 0x0006BC08,
		0x10030, 0x0006C005,
		0x10030, 0x000700F5,
		0x10030, 0x000704F2,
		0x10030, 0x000708EF,
		0x10030, 0x00070CEC,
		0x10030, 0x000710E9,
		0x10030, 0x000714E6,
		0x10030, 0x000718E3,
		0x10030, 0x00071CE0,
		0x10030, 0x000720DD,
		0x10030, 0x000724DA,
		0x10030, 0x000728D7,
		0x10030, 0x00072CD4,
		0x10030, 0x000730D1,
		0x10030, 0x000734CE,
		0x10030, 0x000738CB,
		0x10030, 0x00073C08,
		0x10030, 0x00074005,
		0x10030, 0x000780F4,
		0x10030, 0x000784F1,
		0x10030, 0x000788EE,
		0x10030, 0x00078CEB,
		0x10030, 0x000790E8,
		0x10030, 0x000794E5,
		0x10030, 0x000798E2,
		0x10030, 0x00079CDF,
		0x10030, 0x0007A0DC,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D6,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B0D0,
		0x10030, 0x0007B4CD,
		0x10030, 0x0007B8CA,
		0x10030, 0x0007BC07,
		0x10030, 0x0007C004,
		0x100EE, 0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000008,
		0x03F, 0x00000004,
		0x033, 0x00000009,
		0x03F, 0x00000003,
		0x033, 0x0000000A,
		0x03F, 0x00000003,
		0x033, 0x0000000B,
		0x03F, 0x00000002,
		0x033, 0x0000000C,
		0x03F, 0x00000002,
		0x033, 0x0000000D,
		0x03F, 0x00000002,
		0x033, 0x0000000E,
		0x03F, 0x00000002,
		0x033, 0x0000000F,
		0x03F, 0x00000002,
		0x0EF, 0x00000000,
		0x0EB, 0x00040000,
		0x030, 0x000109B7,
		0x0EB, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00050002,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00008001,
		0x033, 0x00000025,
		0x03F, 0x00008002,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03F, 0x00050002,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00008001,
		0x033, 0x0000002D,
		0x03F, 0x00008002,
		0x033, 0x0000002E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
		0x03F, 0x00050002,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00008001,
		0x033, 0x00000035,
		0x03F, 0x00008002,
		0x033, 0x00000036,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00050002,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00008001,
		0x033, 0x00000065,
		0x03F, 0x00008002,
		0x033, 0x00000066,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000067,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000068,
		0x03F, 0x00050002,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00008001,
		0x033, 0x0000006D,
		0x03F, 0x00008002,
		0x033, 0x0000006E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000006F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000070,
		0x03F, 0x00050002,
		0x033, 0x00000071,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0xA0000000,	0x00000000,
		0x03F, 0x00060032,
	0xB0000000,	0x00000000,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00008001,
		0x033, 0x00000075,
		0x03F, 0x00008002,
		0x033, 0x00000076,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000077,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000078,
		0x03F, 0x00050002,
		0x033, 0x00000079,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00060032,
	0xA0000000,	0x00000000,
		0x03F, 0x00060032,
	0xB0000000,	0x00000000,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00008001,
		0x033, 0x0000007D,
		0x03F, 0x00008002,
		0x033, 0x0000007E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000007F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00050002,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00008001,
		0x033, 0x000000A5,
		0x03F, 0x00008002,
		0x033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000A8,
		0x03F, 0x00050002,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00008001,
		0x033, 0x000000AD,
		0x03F, 0x00008002,
		0x033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000B0,
		0x03F, 0x00050002,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00008001,
		0x033, 0x000000B5,
		0x03F, 0x00008002,
		0x033, 0x000000B6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000B7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000E0,
		0x03F, 0x00050002,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00008001,
		0x033, 0x000000E5,
		0x03F, 0x00008002,
		0x033, 0x000000E6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000E7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000E8,
		0x03F, 0x00050002,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00008001,
		0x033, 0x000000ED,
		0x03F, 0x00008002,
		0x033, 0x000000EE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000EF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000F0,
		0x03F, 0x00050002,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00008001,
		0x033, 0x000000F5,
		0x03F, 0x00008002,
		0x033, 0x000000F6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000F7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000F8,
		0x03F, 0x00050002,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00008001,
		0x033, 0x000000FD,
		0x03F, 0x00008002,
		0x033, 0x000000FE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000FF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000120,
		0x03F, 0x00050002,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00008001,
		0x033, 0x00000125,
		0x03F, 0x00008002,
		0x033, 0x00000126,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000127,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000128,
		0x03F, 0x00050002,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00008001,
		0x033, 0x0000012D,
		0x03F, 0x00008002,
		0x033, 0x0000012E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000012F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000130,
		0x03F, 0x00050002,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00008001,
		0x033, 0x00000135,
		0x03F, 0x00008002,
		0x033, 0x00000136,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000137,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000160,
		0x03F, 0x00050002,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00008001,
		0x033, 0x00000165,
		0x03F, 0x00008002,
		0x033, 0x00000166,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000167,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000168,
		0x03F, 0x00050002,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00008001,
		0x033, 0x0000016D,
		0x03F, 0x00008002,
		0x033, 0x0000016E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000016F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000170,
		0x03F, 0x00050002,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00008001,
		0x033, 0x00000175,
		0x03F, 0x00008002,
		0x033, 0x00000176,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000177,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000178,
		0x03F, 0x00050002,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00008001,
		0x033, 0x0000017D,
		0x03F, 0x00008002,
		0x033, 0x0000017E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000017F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001A0,
		0x03F, 0x00050002,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00008001,
		0x033, 0x000001A5,
		0x03F, 0x00008002,
		0x033, 0x000001A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001A8,
		0x03F, 0x00050002,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00008001,
		0x033, 0x000001AD,
		0x03F, 0x00008002,
		0x033, 0x000001AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001B0,
		0x03F, 0x00050002,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00008001,
		0x033, 0x000001B5,
		0x03F, 0x00008002,
		0x033, 0x000001B6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001B7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001E0,
		0x03F, 0x00050002,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00008001,
		0x033, 0x000001E5,
		0x03F, 0x00008002,
		0x033, 0x000001E6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001E7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001E8,
		0x03F, 0x00050002,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00008001,
		0x033, 0x000001ED,
		0x03F, 0x00008002,
		0x033, 0x000001EE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001EF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001F0,
		0x03F, 0x00050002,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00008001,
		0x033, 0x000001F5,
		0x03F, 0x00008002,
		0x033, 0x000001F6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001F7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001F8,
		0x03F, 0x00050002,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00008001,
		0x033, 0x000001FD,
		0x03F, 0x00008002,
		0x033, 0x000001FE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001FF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x005, 0x00000001,
		0x10005, 0x00000001,
		0x100EE, 0x00000400,
		0x10030, 0x00000000,
		0x10030, 0x00001000,
		0x10030, 0x00002000,
		0x10030, 0x00003000,
		0x10030, 0x00004000,
		0x10030, 0x00005000,
		0x10030, 0x00006003,
		0x10030, 0x00007003,
		0x10030, 0x00008000,
		0x10030, 0x00009000,
		0x10030, 0x0000A000,
		0x10030, 0x0000B000,
		0x10030, 0x0000C000,
		0x10030, 0x0000D000,
		0x10030, 0x0000E003,
		0x10030, 0x0000F003,
		0x10030, 0x00010000,
		0x10030, 0x00011000,
		0x10030, 0x00012000,
		0x10030, 0x00013000,
		0x10030, 0x00014000,
		0x10030, 0x00015000,
		0x10030, 0x00016003,
		0x10030, 0x00017003,
		0x10030, 0x00018000,
		0x10030, 0x00019000,
		0x10030, 0x0001A000,
		0x10030, 0x0001B000,
		0x10030, 0x0001C000,
		0x10030, 0x0001D000,
		0x10030, 0x0001E003,
		0x10030, 0x0001F003,
		0x10030, 0x00020000,
		0x10030, 0x00021000,
		0x10030, 0x00022000,
		0x10030, 0x00023000,
		0x10030, 0x00024000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0xA0000000,	0x00000000,
		0x10030, 0x00025000,
	0xB0000000,	0x00000000,
		0x10030, 0x00026003,
		0x10030, 0x00027003,
		0x10030, 0x00028000,
		0x10030, 0x00029000,
		0x10030, 0x0002A000,
		0x10030, 0x0002B000,
		0x10030, 0x0002C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0xA0000000,	0x00000000,
		0x10030, 0x0002D000,
	0xB0000000,	0x00000000,
		0x10030, 0x0002E003,
		0x10030, 0x0002F003,
		0x10030, 0x00030000,
		0x10030, 0x00031000,
		0x10030, 0x00032000,
		0x10030, 0x00033000,
		0x10030, 0x00034000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0xA0000000,	0x00000000,
		0x10030, 0x00035000,
	0xB0000000,	0x00000000,
		0x10030, 0x00036003,
		0x10030, 0x00037003,
		0x10030, 0x00038000,
		0x10030, 0x00039000,
		0x10030, 0x0003A000,
		0x10030, 0x0003B000,
		0x10030, 0x0003C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0xA0000000,	0x00000000,
		0x10030, 0x0003D000,
	0xB0000000,	0x00000000,
		0x10030, 0x0003E003,
		0x10030, 0x0003F003,
		0x10030, 0x00060000,
		0x10030, 0x00061000,
		0x10030, 0x00062000,
		0x10030, 0x00063000,
		0x10030, 0x00064000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065000,
		0x10030, 0x00066000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065000,
		0x10030, 0x00066000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0xA0000000,	0x00000000,
		0x10030, 0x00065000,
		0x10030, 0x00066000,
	0xB0000000,	0x00000000,
		0x10030, 0x00067003,
		0x10030, 0x00068000,
		0x10030, 0x00069000,
		0x10030, 0x0006A000,
		0x10030, 0x0006B000,
		0x10030, 0x0006C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D000,
		0x10030, 0x0006E000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D000,
		0x10030, 0x0006E000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0xA0000000,	0x00000000,
		0x10030, 0x0006D000,
		0x10030, 0x0006E000,
	0xB0000000,	0x00000000,
		0x10030, 0x0006F003,
		0x10030, 0x00070000,
		0x10030, 0x00071000,
		0x10030, 0x00072000,
		0x10030, 0x00073000,
		0x10030, 0x00074000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075000,
		0x10030, 0x00076000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075000,
		0x10030, 0x00076000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0xA0000000,	0x00000000,
		0x10030, 0x00075000,
		0x10030, 0x00076000,
	0xB0000000,	0x00000000,
		0x10030, 0x00077003,
		0x10030, 0x00078000,
		0x10030, 0x00079000,
		0x10030, 0x0007A000,
		0x10030, 0x0007B000,
		0x10030, 0x0007C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D000,
		0x10030, 0x0007E000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D000,
		0x10030, 0x0007E000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0xA0000000,	0x00000000,
		0x10030, 0x0007D000,
		0x10030, 0x0007E000,
	0xB0000000,	0x00000000,
		0x10030, 0x0007F003,
		0x100EE, 0x00000000,
		0x0FE, 0x00000067,

};


/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8852c_radiob[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0010001, 0x00000002,
		0xF0020001, 0x00000003,
		0xF0030001, 0x00000004,
		0xF0040001, 0x00000005,
		0xF0050001, 0x00000006,
		0xF0070001, 0x00000007,
		0xF0150001, 0x00000008,
		0xF0160001, 0x00000009,
		0xF0320001, 0x0000000A,
		0xF0330001, 0x0000000B,
		0xF0340001, 0x0000000C,
		0xF0350001, 0x0000000D,
		0xF0360001, 0x0000000E,
		0xF03F0001, 0x0000000F,
		0xF0400001, 0x00000010,
		0x005, 0x00000000,
		0x10005, 0x00000000,
		0x0B9, 0x00020440,
		0x000, 0x00030001,
		0x10000, 0x00030000,
		0x018, 0x00011124,
		0x10018, 0x00011124,
		0x0A3, 0x000B9204,
		0x0AD, 0x00091E0F,
		0x05D, 0x00001012,
		0x05C, 0x00079C5C,
		0x062, 0x00055220,
		0x0D3, 0x00000103,
		0x05F, 0x00000038,
		0x097, 0x00043200,
		0x0A6, 0x00066DB7,
		0x0EF, 0x00004000,
		0x033, 0x00000005,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x00000004,
		0x03E, 0x00000000,
		0x03F, 0x00000400,
		0x033, 0x00000003,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x00000002,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x00000001,
		0x03E, 0x00000000,
		0x03F, 0x00001A00,
		0x033, 0x00000000,
		0x03E, 0x00000000,
		0x03F, 0x00002900,
		0x033, 0x0000000D,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x0000000C,
		0x03E, 0x00000000,
		0x03F, 0x00000400,
		0x033, 0x0000000B,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x0000000A,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x00000009,
		0x03E, 0x00000000,
		0x03F, 0x00001A00,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x00002900,
		0x033, 0x00000015,
		0x03E, 0x00000000,
		0x03F, 0x00010500,
		0x033, 0x00000014,
		0x03E, 0x00000000,
		0x03F, 0x00000400,
		0x033, 0x00000013,
		0x03E, 0x00000000,
		0x03F, 0x00028B00,
		0x033, 0x00000012,
		0x03E, 0x00000000,
		0x03F, 0x0009AB00,
		0x033, 0x00000011,
		0x03E, 0x00000000,
		0x03F, 0x00001A00,
		0x033, 0x00000010,
		0x03E, 0x00000000,
		0x03F, 0x00002900,
		0x0EF, 0x00000000,
		0x10055, 0x00080080,
		0x000, 0x00033C01,
		0x10000, 0x00033C00,
		0x01A, 0x00040004,
		0x096, 0x00015200,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0004D000,
		0x0DA, 0x000D4009,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0004D000,
		0x0DA, 0x000D4009,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x0000D300,
		0x0DA, 0x000D4000,
	0xA0000000,	0x00000000,
		0x067, 0x0004D000,
		0x0DA, 0x000D4009,
	0xB0000000,	0x00000000,
		0x057, 0x0000D589,
		0x05A, 0x0007F0F8,
		0x043, 0x00005000,
		0x018, 0x00001001,
		0x10018, 0x00001001,
		0x002, 0x0000000D,
		0x10002, 0x0000000D,
		0x0EE, 0x00000000,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x0EE, 0x00000000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1752,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1752,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x08F, 0x000D1352,
	0xA0000000,	0x00000000,
		0x08F, 0x000D1752,
	0xB0000000,	0x00000000,
		0x0EB, 0x00000000,
		0x030, 0x000109B0,
		0x030, 0x000189B0,
		0x0EB, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x033, 0x00000008,
		0x03F, 0x00000001,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000015,
		0x033, 0x00000001,
		0x03F, 0x00000017,
		0x033, 0x00000004,
		0x03F, 0x00000017,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000007,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000017,
	0xA0000000,	0x00000000,
		0x03F, 0x00000007,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00060001,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00000001,
		0x033, 0x00000025,
		0x03F, 0x00000002,
		0x033, 0x00000026,
		0x03F, 0x00000003,
		0x033, 0x00000027,
		0x03F, 0x00000003,
		0x033, 0x00000028,
		0x03F, 0x00060001,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00000001,
		0x033, 0x0000002D,
		0x03F, 0x00000002,
		0x033, 0x0000002E,
		0x03F, 0x00000003,
		0x033, 0x0000002F,
		0x03F, 0x00000003,
		0x033, 0x00000030,
		0x03F, 0x00060001,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00000001,
		0x033, 0x00000035,
		0x03F, 0x00000002,
		0x033, 0x00000036,
		0x03F, 0x00000003,
		0x033, 0x00000037,
		0x03F, 0x00000003,
		0x033, 0x00000060,
		0x03F, 0x00060001,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00000001,
		0x033, 0x00000065,
		0x03F, 0x00000002,
		0x033, 0x00000066,
		0x03F, 0x00000003,
		0x033, 0x00000067,
		0x03F, 0x00000003,
		0x033, 0x00000068,
		0x03F, 0x00060001,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00000001,
		0x033, 0x0000006D,
		0x03F, 0x00000002,
		0x033, 0x0000006E,
		0x03F, 0x00000003,
		0x033, 0x0000006F,
		0x03F, 0x00000003,
		0x033, 0x00000070,
		0x03F, 0x00060001,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00000001,
		0x033, 0x00000075,
		0x03F, 0x00000002,
		0x033, 0x00000076,
		0x03F, 0x00000003,
		0x033, 0x00000077,
		0x03F, 0x00000003,
		0x033, 0x00000078,
		0x03F, 0x00060001,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00000001,
		0x033, 0x0000007D,
		0x03F, 0x00000002,
		0x033, 0x0000007E,
		0x03F, 0x00000003,
		0x033, 0x0000007F,
		0x03F, 0x00000003,
		0x033, 0x000000A0,
		0x03F, 0x00060001,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00000001,
		0x033, 0x000000A5,
		0x03F, 0x00000002,
		0x033, 0x000000A6,
		0x03F, 0x00000003,
		0x033, 0x000000A7,
		0x03F, 0x00000003,
		0x033, 0x000000A8,
		0x03F, 0x00060001,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00000001,
		0x033, 0x000000AD,
		0x03F, 0x00000002,
		0x033, 0x000000AE,
		0x03F, 0x00000003,
		0x033, 0x000000AF,
		0x03F, 0x00000003,
		0x033, 0x000000B0,
		0x03F, 0x00060001,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00000001,
		0x033, 0x000000B5,
		0x03F, 0x00000002,
		0x033, 0x000000B6,
		0x03F, 0x00000003,
		0x033, 0x000000B7,
		0x03F, 0x00000003,
		0x033, 0x000000E0,
		0x03F, 0x00060001,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00000001,
		0x033, 0x000000E5,
		0x03F, 0x00000002,
		0x033, 0x000000E6,
		0x03F, 0x00000003,
		0x033, 0x000000E7,
		0x03F, 0x00000003,
		0x033, 0x000000E8,
		0x03F, 0x00060001,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00000001,
		0x033, 0x000000ED,
		0x03F, 0x00000002,
		0x033, 0x000000EE,
		0x03F, 0x00000003,
		0x033, 0x000000EF,
		0x03F, 0x00000003,
		0x033, 0x000000F0,
		0x03F, 0x00060001,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00000001,
		0x033, 0x000000F5,
		0x03F, 0x00000002,
		0x033, 0x000000F6,
		0x03F, 0x00000003,
		0x033, 0x000000F7,
		0x03F, 0x00000003,
		0x033, 0x000000F8,
		0x03F, 0x00060001,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00000001,
		0x033, 0x000000FD,
		0x03F, 0x00000002,
		0x033, 0x000000FE,
		0x03F, 0x00000003,
		0x033, 0x000000FF,
		0x03F, 0x00000003,
		0x033, 0x00000120,
		0x03F, 0x00060001,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00000001,
		0x033, 0x00000125,
		0x03F, 0x00000002,
		0x033, 0x00000126,
		0x03F, 0x00000003,
		0x033, 0x00000127,
		0x03F, 0x00000003,
		0x033, 0x00000128,
		0x03F, 0x00060001,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00000001,
		0x033, 0x0000012D,
		0x03F, 0x00000002,
		0x033, 0x0000012E,
		0x03F, 0x00000003,
		0x033, 0x0000012F,
		0x03F, 0x00000003,
		0x033, 0x00000130,
		0x03F, 0x00060001,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00000001,
		0x033, 0x00000135,
		0x03F, 0x00000002,
		0x033, 0x00000136,
		0x03F, 0x00000003,
		0x033, 0x00000137,
		0x03F, 0x00000003,
		0x033, 0x00000160,
		0x03F, 0x00060001,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00000001,
		0x033, 0x00000165,
		0x03F, 0x00000002,
		0x033, 0x00000166,
		0x03F, 0x00000003,
		0x033, 0x00000167,
		0x03F, 0x00000003,
		0x033, 0x00000168,
		0x03F, 0x00060001,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00000001,
		0x033, 0x0000016D,
		0x03F, 0x00000002,
		0x033, 0x0000016E,
		0x03F, 0x00000003,
		0x033, 0x0000016F,
		0x03F, 0x00000003,
		0x033, 0x00000170,
		0x03F, 0x00060001,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00000001,
		0x033, 0x00000175,
		0x03F, 0x00000002,
		0x033, 0x00000176,
		0x03F, 0x00000003,
		0x033, 0x00000177,
		0x03F, 0x00000003,
		0x033, 0x00000178,
		0x03F, 0x00060001,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00000001,
		0x033, 0x0000017D,
		0x03F, 0x00000002,
		0x033, 0x0000017E,
		0x03F, 0x00000003,
		0x033, 0x0000017F,
		0x03F, 0x00000003,
		0x033, 0x000001A0,
		0x03F, 0x00060001,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00000001,
		0x033, 0x000001A5,
		0x03F, 0x00000002,
		0x033, 0x000001A6,
		0x03F, 0x00000003,
		0x033, 0x000001A7,
		0x03F, 0x00000003,
		0x033, 0x000001A8,
		0x03F, 0x00060001,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00000001,
		0x033, 0x000001AD,
		0x03F, 0x00000002,
		0x033, 0x000001AE,
		0x03F, 0x00000003,
		0x033, 0x000001AF,
		0x03F, 0x00000003,
		0x033, 0x000001B0,
		0x03F, 0x00060001,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00000001,
		0x033, 0x000001B5,
		0x03F, 0x00000002,
		0x033, 0x000001B6,
		0x03F, 0x00000003,
		0x033, 0x000001B7,
		0x03F, 0x00000003,
		0x033, 0x000001E0,
		0x03F, 0x00060001,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00000001,
		0x033, 0x000001E5,
		0x03F, 0x00000002,
		0x033, 0x000001E6,
		0x03F, 0x00000003,
		0x033, 0x000001E7,
		0x03F, 0x00000003,
		0x033, 0x000001E8,
		0x03F, 0x00060001,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00000001,
		0x033, 0x000001ED,
		0x03F, 0x00000002,
		0x033, 0x000001EE,
		0x03F, 0x00000003,
		0x033, 0x000001EF,
		0x03F, 0x00000003,
		0x033, 0x000001F0,
		0x03F, 0x00060001,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00000001,
		0x033, 0x000001F5,
		0x03F, 0x00000002,
		0x033, 0x000001F6,
		0x03F, 0x00000003,
		0x033, 0x000001F7,
		0x03F, 0x00000003,
		0x033, 0x000001F8,
		0x03F, 0x00060001,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00000001,
		0x033, 0x000001FD,
		0x03F, 0x00000002,
		0x033, 0x000001FE,
		0x03F, 0x00000003,
		0x033, 0x000001FF,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000AFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000E3FF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000E3FF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000E3FF,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000FBFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000DBFF,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xA0000000,	0x00000000,
		0x03F, 0x0000EFFF,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00004344,
		0x033, 0x00000001,
		0x03F, 0x00004344,
		0x033, 0x00000002,
		0x03F, 0x00004344,
		0x033, 0x00000003,
		0x03F, 0x00004344,
		0x033, 0x00000004,
		0x03F, 0x00004344,
		0x033, 0x00000005,
		0x03F, 0x00004344,
		0x033, 0x00000006,
		0x03F, 0x00004344,
		0x033, 0x00000007,
		0x03F, 0x00004344,
		0x033, 0x00000008,
		0x03F, 0x00004344,
		0x033, 0x00000009,
		0x03F, 0x00004344,
		0x033, 0x0000000A,
		0x03F, 0x00004344,
		0x033, 0x0000000B,
		0x03F, 0x00004344,
		0x033, 0x00000010,
		0x03F, 0x00004344,
		0x033, 0x00000011,
		0x03F, 0x00004344,
		0x033, 0x00000012,
		0x03F, 0x00004344,
		0x033, 0x00000013,
		0x03F, 0x00004344,
		0x033, 0x00000014,
		0x03F, 0x00004344,
		0x033, 0x00000015,
		0x03F, 0x00004344,
		0x033, 0x00000016,
		0x03F, 0x00004344,
		0x033, 0x00000017,
		0x03F, 0x00004344,
		0x033, 0x00000018,
		0x03F, 0x00004344,
		0x033, 0x00000019,
		0x03F, 0x00004344,
		0x033, 0x0000001A,
		0x03F, 0x00004344,
		0x033, 0x0000001B,
		0x03F, 0x00004344,
		0x033, 0x0000001C,
		0x03F, 0x00004344,
		0x033, 0x0000001D,
		0x03F, 0x00004344,
		0x033, 0x0000001E,
		0x03F, 0x00004344,
		0x033, 0x0000001F,
		0x03F, 0x00004344,
		0x0EF, 0x00000000,
		0x0EF, 0x00000020,
		0x033, 0x00000010,
		0x03F, 0x00000200,
		0x033, 0x00000011,
		0x03F, 0x00000200,
		0x033, 0x00000012,
		0x03F, 0x00000200,
		0x033, 0x00000013,
		0x03F, 0x00000200,
		0x033, 0x00000020,
		0x03F, 0x00000200,
		0x033, 0x00000021,
		0x03F, 0x00000200,
		0x033, 0x00000022,
		0x03F, 0x00000200,
		0x033, 0x00000023,
		0x03F, 0x00000200,
		0x0EF, 0x00000000,
		0x0EF, 0x00000010,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000084DC,
		0x030, 0x000103C9,
		0x030, 0x00018399,
		0x030, 0x00020287,
		0x030, 0x00028277,
		0x030, 0x00030165,
		0x030, 0x00038144,
		0x030, 0x00040044,
		0x030, 0x00048022,
		0x030, 0x00050011,
		0x030, 0x00058000,
		0x030, 0x00060000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000084DC,
		0x030, 0x000103C9,
		0x030, 0x00018399,
		0x030, 0x00020287,
		0x030, 0x00028277,
		0x030, 0x00030165,
		0x030, 0x00038144,
		0x030, 0x00040044,
		0x030, 0x00048022,
		0x030, 0x00050011,
		0x030, 0x00058000,
		0x030, 0x00060000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x000085ED,
		0x030, 0x000105CC,
		0x030, 0x000184AA,
		0x030, 0x00020388,
		0x030, 0x00028377,
		0x030, 0x00030377,
		0x030, 0x00038255,
		0x030, 0x00040244,
		0x030, 0x00048133,
		0x030, 0x00050112,
		0x030, 0x00058101,
		0x030, 0x00060001,
	0xA0000000,	0x00000000,
		0x030, 0x000084DC,
		0x030, 0x000103C9,
		0x030, 0x00018399,
		0x030, 0x00020287,
		0x030, 0x00028277,
		0x030, 0x00030165,
		0x030, 0x00038144,
		0x030, 0x00040044,
		0x030, 0x00048022,
		0x030, 0x00050011,
		0x030, 0x00058000,
		0x030, 0x00060000,
	0xB0000000,	0x00000000,
		0x030, 0x00068000,
		0x030, 0x00070000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000004,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000005,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000006,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x00000007,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000008,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000009,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x0000000A,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x0000000B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000000C,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x0000000D,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x0000000E,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x0000000F,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000010,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000011,
		0x03E, 0x0000001B,
		0x03F, 0x00022A58,
		0x033, 0x00000012,
		0x03E, 0x00000014,
		0x03F, 0x00023958,
		0x033, 0x00000013,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000014,
		0x03E, 0x00000013,
		0x03F, 0x00022A58,
		0x033, 0x00000015,
		0x03E, 0x0000001B,
		0x03F, 0x00029858,
		0x033, 0x00000016,
		0x03E, 0x0000001C,
		0x03F, 0x00023958,
		0x033, 0x00000017,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000018,
		0x03E, 0x00000013,
		0x03F, 0x00029858,
		0x033, 0x00000019,
		0x03E, 0x0000001B,
		0x03F, 0x00029858,
		0x033, 0x0000001A,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000001B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000001C,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000001D,
		0x03E, 0x0000001B,
		0x03F, 0x00029858,
		0x033, 0x0000001E,
		0x03E, 0x00000013,
		0x03F, 0x00023A58,
		0x033, 0x0000001F,
		0x03E, 0x00000013,
		0x03F, 0x00023A58,
		0x033, 0x00000020,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000021,
		0x03E, 0x0000001C,
		0x03F, 0x0002AC58,
		0x033, 0x00000022,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000023,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000024,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000025,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000026,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000027,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000028,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000029,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000002A,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000002B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000002C,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000002D,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000002E,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000002F,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000030,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000031,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000032,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000033,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000034,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000035,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000036,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000037,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x00000038,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x00000039,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000003A,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000003B,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000003C,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000003D,
		0x03E, 0x00000014,
		0x03F, 0x0002AC58,
		0x033, 0x0000003E,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x033, 0x0000003F,
		0x03E, 0x00000014,
		0x03F, 0x00023A58,
		0x0EF, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000031,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x033, 0x00000002,
		0x03F, 0x00000015,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EC, 0x00000400,
		0x033, 0x00000003,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000021,
		0x0EC, 0x00000000,
		0x0DE, 0x00000000,
		0x0EF, 0x00000000,
		0x033, 0x00000000,
		0x008, 0x00060280,
		0x009, 0x00030400,
		0x0EF, 0x00000000,
		0x0A7, 0x00080308,
		0x066, 0x00006000,
		0x0EF, 0x00000400,
		0x030, 0x000001FF,
		0x030, 0x000081FF,
		0x030, 0x000101FF,
		0x030, 0x000181FF,
		0x030, 0x000201FF,
		0x030, 0x000281FF,
		0x030, 0x0003017F,
		0x030, 0x000380FB,
		0x0EF, 0x00000000,
		0x06E, 0x00077A18,
		0x06D, 0x00000C31,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0380,
		0x06B, 0x00003CA0,
		0x06F, 0x000C01FC,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0380,
		0x06B, 0x00003CA0,
		0x06F, 0x000C01FC,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0xA0000000,	0x00000000,
		0x06A, 0x000E0F8A,
		0x06B, 0x000018A0,
		0x06F, 0x000F81FC,
	0xB0000000,	0x00000000,
		0x05E, 0x0000001F,
		0x0EF, 0x00000200,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
		0x030, 0x0003E207,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0xA0000000,	0x00000000,
		0x030, 0x0003D407,
		0x030, 0x00035A87,
		0x030, 0x0002CF07,
		0x030, 0x00024F07,
		0x030, 0x0001CF07,
		0x030, 0x00014F07,
		0x030, 0x0000CF07,
		0x030, 0x00004F07,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EB, 0x00080000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0000803C,
		0x030, 0x0001003C,
		0x030, 0x0001803C,
		0x030, 0x0002003C,
		0x030, 0x0002803C,
		0x030, 0x0003003C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x0000803C,
		0x030, 0x0001003C,
		0x030, 0x0001803C,
		0x030, 0x0002003C,
		0x030, 0x0002803C,
		0x030, 0x0003003C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0xA0000000,	0x00000000,
		0x030, 0x00008038,
		0x030, 0x00010038,
		0x030, 0x00018038,
		0x030, 0x00020038,
		0x030, 0x00028038,
		0x030, 0x00030038,
	0xB0000000,	0x00000000,
		0x030, 0x0003803C,
		0x030, 0x0004003C,
		0x030, 0x0004803C,
		0x030, 0x0005003C,
		0x030, 0x0005803C,
		0x030, 0x0006003C,
		0x030, 0x0006803C,
		0x030, 0x0007003C,
		0x0EB, 0x00000000,
		0x094, 0x000000FC,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x095, 0x00000008,
	0xA0000000,	0x00000000,
		0x095, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000020,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000002C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000034,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E7,
	0xB0000000,	0x00000000,
		0x033, 0x00000038,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E7,
	0xB0000000,	0x00000000,
		0x033, 0x0000003C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E7,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000002D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000031,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000035,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000039,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000003D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000002E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000032,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000036,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000003A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000003E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000060,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000064,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000068,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000070,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000074,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000078,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007C,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000061,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000065,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x00000069,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000071,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000075,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000079,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007D,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000062,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000066,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x0000006A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000072,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000076,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007A,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000002E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000003E7,
	0xA0000000,	0x00000000,
		0x03F, 0x000003E6,
	0xB0000000,	0x00000000,
		0x033, 0x00000063,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000052,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000152,
	0xA0000000,	0x00000000,
		0x03F, 0x00000052,
	0xB0000000,	0x00000000,
		0x033, 0x00000067,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000005A,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000015A,
	0xA0000000,	0x00000000,
		0x03F, 0x0000005A,
	0xB0000000,	0x00000000,
		0x033, 0x0000006B,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000009C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0xA0000000,	0x00000000,
		0x03F, 0x0000009C,
	0xB0000000,	0x00000000,
		0x033, 0x0000006F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000019C,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0xA0000000,	0x00000000,
		0x03F, 0x0000019C,
	0xB0000000,	0x00000000,
		0x033, 0x00000073,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001A4,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000077,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000001E6,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002E6,
	0xA0000000,	0x00000000,
		0x03F, 0x000001E6,
	0xB0000000,	0x00000000,
		0x033, 0x0000007B,
		0x03F, 0x000002E7,
		0x033, 0x0000007F,
		0x03F, 0x000003E7,
		0x0EE, 0x00000000,
		0x100EE, 0x00004000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201ED,
		0x10030, 0x000205AD,
		0x10030, 0x000209A7,
		0x10030, 0x00020DA1,
		0x10030, 0x0002119B,
		0x10030, 0x00021561,
		0x10030, 0x0002195B,
		0x10030, 0x00021D27,
		0x10030, 0x00022121,
		0x10030, 0x000224E9,
		0x10030, 0x000228E3,
		0x10030, 0x00022CA9,
		0x10030, 0x000230A3,
		0x10030, 0x00023469,
		0x10030, 0x00023863,
		0x10030, 0x00023C29,
		0x10030, 0x00024023,
		0x10030, 0x0002441D,
		0x10030, 0x000281EF,
		0x10030, 0x000285AF,
		0x10030, 0x000289A9,
		0x10030, 0x00028DA3,
		0x10030, 0x0002919D,
		0x10030, 0x00029563,
		0x10030, 0x0002995D,
		0x10030, 0x00029D25,
		0x10030, 0x0002A11F,
		0x10030, 0x0002A4E7,
		0x10030, 0x0002A8E1,
		0x10030, 0x0002ACA7,
		0x10030, 0x0002B0A1,
		0x10030, 0x0002B467,
		0x10030, 0x0002B861,
		0x10030, 0x0002BC27,
		0x10030, 0x0002C021,
		0x10030, 0x0002C41B,
		0x10030, 0x000301EF,
		0x10030, 0x000305AF,
		0x10030, 0x000309A9,
		0x10030, 0x00030DA3,
		0x10030, 0x0003119D,
		0x10030, 0x00031563,
		0x10030, 0x0003195D,
		0x10030, 0x00031D25,
		0x10030, 0x0003211F,
		0x10030, 0x000324E7,
		0x10030, 0x000328E1,
		0x10030, 0x00032CA7,
		0x10030, 0x000330A1,
		0x10030, 0x00033467,
		0x10030, 0x00033861,
		0x10030, 0x00033C27,
		0x10030, 0x00034021,
		0x10030, 0x0003441B,
		0x10030, 0x000601EB,
		0x10030, 0x000605AB,
		0x10030, 0x000609A5,
		0x10030, 0x00060D9F,
		0x10030, 0x00061199,
		0x10030, 0x00061593,
		0x10030, 0x00061959,
		0x10030, 0x00061D53,
		0x10030, 0x0006211B,
		0x10030, 0x00062515,
		0x10030, 0x000628DD,
		0x10030, 0x00062CD7,
		0x10030, 0x0006309D,
		0x10030, 0x00063497,
		0x10030, 0x0006385D,
		0x10030, 0x00063C57,
		0x10030, 0x0006401D,
		0x10030, 0x00064417,
		0x10030, 0x000681E7,
		0x10030, 0x000685A7,
		0x10030, 0x000689A1,
		0x10030, 0x00068D9B,
		0x10030, 0x00069195,
		0x10030, 0x0006955F,
		0x10030, 0x00069959,
		0x10030, 0x00069D21,
		0x10030, 0x0006A11B,
		0x10030, 0x0006A4E3,
		0x10030, 0x0006A8DD,
		0x10030, 0x0006ACA5,
		0x10030, 0x0006B09F,
		0x10030, 0x0006B465,
		0x10030, 0x0006B85F,
		0x10030, 0x0006BC25,
		0x10030, 0x0006C01F,
		0x10030, 0x0006C419,
		0x10030, 0x000701E7,
		0x10030, 0x000705A7,
		0x10030, 0x000709A1,
		0x10030, 0x00070D9B,
		0x10030, 0x00071195,
		0x10030, 0x0007155B,
		0x10030, 0x00071955,
		0x10030, 0x00071D1D,
		0x10030, 0x00072117,
		0x10030, 0x000724DF,
		0x10030, 0x000728D9,
		0x10030, 0x00072CA1,
		0x10030, 0x0007309B,
		0x10030, 0x00073461,
		0x10030, 0x0007385B,
		0x10030, 0x00073C21,
		0x10030, 0x0007401B,
		0x10030, 0x0007441B,
		0x10030, 0x000781E9,
		0x10030, 0x000785A9,
		0x10030, 0x000789A3,
		0x10030, 0x00078D9D,
		0x10030, 0x00079197,
		0x10030, 0x00079591,
		0x10030, 0x00079957,
		0x10030, 0x00079D51,
		0x10030, 0x0007A119,
		0x10030, 0x0007A513,
		0x10030, 0x0007A8D9,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B099,
		0x10030, 0x0007B493,
		0x10030, 0x0007B859,
		0x10030, 0x0007BC53,
		0x10030, 0x0007C019,
		0x10030, 0x0007C413,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201ED,
		0x10030, 0x000205AD,
		0x10030, 0x000209A7,
		0x10030, 0x00020DA1,
		0x10030, 0x0002119B,
		0x10030, 0x00021561,
		0x10030, 0x0002195B,
		0x10030, 0x00021D27,
		0x10030, 0x00022121,
		0x10030, 0x000224E9,
		0x10030, 0x000228E3,
		0x10030, 0x00022CA9,
		0x10030, 0x000230A3,
		0x10030, 0x00023469,
		0x10030, 0x00023863,
		0x10030, 0x00023C29,
		0x10030, 0x00024023,
		0x10030, 0x0002441D,
		0x10030, 0x000281EF,
		0x10030, 0x000285AF,
		0x10030, 0x000289A9,
		0x10030, 0x00028DA3,
		0x10030, 0x0002919D,
		0x10030, 0x00029563,
		0x10030, 0x0002995D,
		0x10030, 0x00029D25,
		0x10030, 0x0002A11F,
		0x10030, 0x0002A4E7,
		0x10030, 0x0002A8E1,
		0x10030, 0x0002ACA7,
		0x10030, 0x0002B0A1,
		0x10030, 0x0002B467,
		0x10030, 0x0002B861,
		0x10030, 0x0002BC27,
		0x10030, 0x0002C021,
		0x10030, 0x0002C41B,
		0x10030, 0x000301EF,
		0x10030, 0x000305AF,
		0x10030, 0x000309A9,
		0x10030, 0x00030DA3,
		0x10030, 0x0003119D,
		0x10030, 0x00031563,
		0x10030, 0x0003195D,
		0x10030, 0x00031D25,
		0x10030, 0x0003211F,
		0x10030, 0x000324E7,
		0x10030, 0x000328E1,
		0x10030, 0x00032CA7,
		0x10030, 0x000330A1,
		0x10030, 0x00033467,
		0x10030, 0x00033861,
		0x10030, 0x00033C27,
		0x10030, 0x00034021,
		0x10030, 0x0003441B,
		0x10030, 0x000601EB,
		0x10030, 0x000605AB,
		0x10030, 0x000609A5,
		0x10030, 0x00060D9F,
		0x10030, 0x00061199,
		0x10030, 0x00061593,
		0x10030, 0x00061959,
		0x10030, 0x00061D53,
		0x10030, 0x0006211B,
		0x10030, 0x00062515,
		0x10030, 0x000628DD,
		0x10030, 0x00062CD7,
		0x10030, 0x0006309D,
		0x10030, 0x00063497,
		0x10030, 0x0006385D,
		0x10030, 0x00063C57,
		0x10030, 0x0006401D,
		0x10030, 0x00064417,
		0x10030, 0x000681E7,
		0x10030, 0x000685A7,
		0x10030, 0x000689A1,
		0x10030, 0x00068D9B,
		0x10030, 0x00069195,
		0x10030, 0x0006955F,
		0x10030, 0x00069959,
		0x10030, 0x00069D21,
		0x10030, 0x0006A11B,
		0x10030, 0x0006A4E3,
		0x10030, 0x0006A8DD,
		0x10030, 0x0006ACA5,
		0x10030, 0x0006B09F,
		0x10030, 0x0006B465,
		0x10030, 0x0006B85F,
		0x10030, 0x0006BC25,
		0x10030, 0x0006C01F,
		0x10030, 0x0006C419,
		0x10030, 0x000701E7,
		0x10030, 0x000705A7,
		0x10030, 0x000709A1,
		0x10030, 0x00070D9B,
		0x10030, 0x00071195,
		0x10030, 0x0007155B,
		0x10030, 0x00071955,
		0x10030, 0x00071D1D,
		0x10030, 0x00072117,
		0x10030, 0x000724DF,
		0x10030, 0x000728D9,
		0x10030, 0x00072CA1,
		0x10030, 0x0007309B,
		0x10030, 0x00073461,
		0x10030, 0x0007385B,
		0x10030, 0x00073C21,
		0x10030, 0x0007401B,
		0x10030, 0x0007441B,
		0x10030, 0x000781E9,
		0x10030, 0x000785A9,
		0x10030, 0x000789A3,
		0x10030, 0x00078D9D,
		0x10030, 0x00079197,
		0x10030, 0x00079591,
		0x10030, 0x00079957,
		0x10030, 0x00079D51,
		0x10030, 0x0007A119,
		0x10030, 0x0007A513,
		0x10030, 0x0007A8D9,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B099,
		0x10030, 0x0007B493,
		0x10030, 0x0007B859,
		0x10030, 0x0007BC53,
		0x10030, 0x0007C019,
		0x10030, 0x0007C413,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DA3,
		0x10030, 0x00021161,
		0x10030, 0x0002155B,
		0x10030, 0x0002191F,
		0x10030, 0x00021D19,
		0x10030, 0x000220E1,
		0x10030, 0x000224DB,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1B,
		0x10030, 0x00024015,
		0x10030, 0x0002440F,
		0x10030, 0x000281EF,
		0x10030, 0x000285E7,
		0x10030, 0x000289A7,
		0x10030, 0x00028D65,
		0x10030, 0x0002915F,
		0x10030, 0x00029523,
		0x10030, 0x0002991D,
		0x10030, 0x00029CE5,
		0x10030, 0x0002A0DF,
		0x10030, 0x0002A4A7,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC67,
		0x10030, 0x0002B061,
		0x10030, 0x0002B427,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC19,
		0x10030, 0x0002C013,
		0x10030, 0x0002C40D,
		0x10030, 0x000301EF,
		0x10030, 0x000305E7,
		0x10030, 0x000309A7,
		0x10030, 0x00030D65,
		0x10030, 0x0003115F,
		0x10030, 0x00031525,
		0x10030, 0x0003191F,
		0x10030, 0x00031CE7,
		0x10030, 0x000320E1,
		0x10030, 0x000324A9,
		0x10030, 0x000328A3,
		0x10030, 0x00032C69,
		0x10030, 0x00033063,
		0x10030, 0x00033429,
		0x10030, 0x00033823,
		0x10030, 0x00033C1D,
		0x10030, 0x00034013,
		0x10030, 0x0003440D,
		0x10030, 0x000601F1,
		0x10030, 0x000605E9,
		0x10030, 0x000609A9,
		0x10030, 0x00060D65,
		0x10030, 0x0006115F,
		0x10030, 0x00061525,
		0x10030, 0x0006191F,
		0x10030, 0x00061CE7,
		0x10030, 0x000620E1,
		0x10030, 0x000624DB,
		0x10030, 0x000628A3,
		0x10030, 0x00062C69,
		0x10030, 0x00063063,
		0x10030, 0x00063429,
		0x10030, 0x00063823,
		0x10030, 0x00063C1D,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681EF,
		0x10030, 0x000685E7,
		0x10030, 0x000689A7,
		0x10030, 0x00068D61,
		0x10030, 0x0006915B,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069CE5,
		0x10030, 0x0006A0DF,
		0x10030, 0x0006A4A7,
		0x10030, 0x0006A8A1,
		0x10030, 0x0006AC67,
		0x10030, 0x0006B061,
		0x10030, 0x0006B429,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C40D,
		0x10030, 0x000701F1,
		0x10030, 0x000705E9,
		0x10030, 0x000709A9,
		0x10030, 0x00070D63,
		0x10030, 0x0007115D,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x00072111,
		0x10030, 0x000724D9,
		0x10030, 0x000728D3,
		0x10030, 0x00072C67,
		0x10030, 0x00073061,
		0x10030, 0x00073427,
		0x10030, 0x00073821,
		0x10030, 0x00073C1B,
		0x10030, 0x00074015,
		0x10030, 0x0007440D,
		0x10030, 0x000781F1,
		0x10030, 0x000785EB,
		0x10030, 0x000789E5,
		0x10030, 0x00078DA3,
		0x10030, 0x00079161,
		0x10030, 0x0007955B,
		0x10030, 0x00079923,
		0x10030, 0x00079D1D,
		0x10030, 0x0007A117,
		0x10030, 0x0007A4DD,
		0x10030, 0x0007A8D7,
		0x10030, 0x0007AC9D,
		0x10030, 0x0007B063,
		0x10030, 0x0007B45D,
		0x10030, 0x0007B857,
		0x10030, 0x0007BC1D,
		0x10030, 0x0007C017,
		0x10030, 0x0007C40F,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201A7,
		0x10030, 0x000205A1,
		0x10030, 0x0002099B,
		0x10030, 0x00020D95,
		0x10030, 0x0002115B,
		0x10030, 0x00021555,
		0x10030, 0x00021921,
		0x10030, 0x00021D1B,
		0x10030, 0x000220E3,
		0x10030, 0x000224DD,
		0x10030, 0x000228A3,
		0x10030, 0x00022C9D,
		0x10030, 0x00023063,
		0x10030, 0x0002345D,
		0x10030, 0x00023823,
		0x10030, 0x00023C1D,
		0x10030, 0x00024017,
		0x10030, 0x00024411,
		0x10030, 0x000281A9,
		0x10030, 0x000285A3,
		0x10030, 0x0002899D,
		0x10030, 0x00028D97,
		0x10030, 0x0002915D,
		0x10030, 0x00029557,
		0x10030, 0x0002991F,
		0x10030, 0x00029D19,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DB,
		0x10030, 0x0002A8A1,
		0x10030, 0x0002AC9B,
		0x10030, 0x0002B061,
		0x10030, 0x0002B45B,
		0x10030, 0x0002B821,
		0x10030, 0x0002BC1B,
		0x10030, 0x0002C015,
		0x10030, 0x0002C40F,
		0x10030, 0x000301A9,
		0x10030, 0x000305A3,
		0x10030, 0x0003099D,
		0x10030, 0x00030D97,
		0x10030, 0x0003115D,
		0x10030, 0x00031557,
		0x10030, 0x0003191F,
		0x10030, 0x00031D19,
		0x10030, 0x000320E1,
		0x10030, 0x000324DB,
		0x10030, 0x000328A1,
		0x10030, 0x00032C9B,
		0x10030, 0x00033061,
		0x10030, 0x0003345B,
		0x10030, 0x00033821,
		0x10030, 0x00033C1B,
		0x10030, 0x00034015,
		0x10030, 0x0003440F,
		0x10030, 0x000601E9,
		0x10030, 0x000605E3,
		0x10030, 0x000609A3,
		0x10030, 0x00060D5F,
		0x10030, 0x00061159,
		0x10030, 0x00061521,
		0x10030, 0x0006191B,
		0x10030, 0x00061CE3,
		0x10030, 0x000620DD,
		0x10030, 0x000624D7,
		0x10030, 0x0006289F,
		0x10030, 0x00062C99,
		0x10030, 0x0006305F,
		0x10030, 0x00063459,
		0x10030, 0x0006381F,
		0x10030, 0x00063C19,
		0x10030, 0x00064013,
		0x10030, 0x0006440D,
		0x10030, 0x000681E7,
		0x10030, 0x000685E1,
		0x10030, 0x000689A1,
		0x10030, 0x00068D5F,
		0x10030, 0x00069159,
		0x10030, 0x00069523,
		0x10030, 0x0006991D,
		0x10030, 0x00069D17,
		0x10030, 0x0006A0E1,
		0x10030, 0x0006A4DB,
		0x10030, 0x0006A8A3,
		0x10030, 0x0006AC9D,
		0x10030, 0x0006B063,
		0x10030, 0x0006B45D,
		0x10030, 0x0006B823,
		0x10030, 0x0006BC1D,
		0x10030, 0x0006C017,
		0x10030, 0x0006C411,
		0x10030, 0x000701E9,
		0x10030, 0x000705E3,
		0x10030, 0x000709A3,
		0x10030, 0x00070D5F,
		0x10030, 0x00071159,
		0x10030, 0x00071523,
		0x10030, 0x0007191D,
		0x10030, 0x00071D17,
		0x10030, 0x000720E1,
		0x10030, 0x000724DB,
		0x10030, 0x000728A3,
		0x10030, 0x00072C9D,
		0x10030, 0x00073063,
		0x10030, 0x0007345D,
		0x10030, 0x00073823,
		0x10030, 0x00073C1D,
		0x10030, 0x00074017,
		0x10030, 0x00074411,
		0x10030, 0x000781EF,
		0x10030, 0x000785E9,
		0x10030, 0x000789E3,
		0x10030, 0x00078DA3,
		0x10030, 0x0007915F,
		0x10030, 0x00079559,
		0x10030, 0x0007991F,
		0x10030, 0x00079D19,
		0x10030, 0x0007A0DF,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D3,
		0x10030, 0x0007AC99,
		0x10030, 0x0007B05F,
		0x10030, 0x0007B459,
		0x10030, 0x0007B81F,
		0x10030, 0x0007BC19,
		0x10030, 0x0007C013,
		0x10030, 0x0007C40D,
	0xA0000000,	0x00000000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011D7,
		0x10030, 0x0000159F,
		0x10030, 0x00001999,
		0x10030, 0x00001D5F,
		0x10030, 0x00002159,
		0x10030, 0x0000251F,
		0x10030, 0x00002919,
		0x10030, 0x00002CDF,
		0x10030, 0x000030D9,
		0x10030, 0x0000349F,
		0x10030, 0x00003899,
		0x10030, 0x00003C5F,
		0x10030, 0x00004059,
		0x10030, 0x00004453,
		0x10030, 0x000201ED,
		0x10030, 0x000205AD,
		0x10030, 0x000209A7,
		0x10030, 0x00020DA1,
		0x10030, 0x0002119B,
		0x10030, 0x00021561,
		0x10030, 0x0002195B,
		0x10030, 0x00021D27,
		0x10030, 0x00022121,
		0x10030, 0x000224E9,
		0x10030, 0x000228E3,
		0x10030, 0x00022CA9,
		0x10030, 0x000230A3,
		0x10030, 0x00023469,
		0x10030, 0x00023863,
		0x10030, 0x00023C29,
		0x10030, 0x00024023,
		0x10030, 0x0002441D,
		0x10030, 0x000281EF,
		0x10030, 0x000285AF,
		0x10030, 0x000289A9,
		0x10030, 0x00028DA3,
		0x10030, 0x0002919D,
		0x10030, 0x00029563,
		0x10030, 0x0002995D,
		0x10030, 0x00029D25,
		0x10030, 0x0002A11F,
		0x10030, 0x0002A4E7,
		0x10030, 0x0002A8E1,
		0x10030, 0x0002ACA7,
		0x10030, 0x0002B0A1,
		0x10030, 0x0002B467,
		0x10030, 0x0002B861,
		0x10030, 0x0002BC27,
		0x10030, 0x0002C021,
		0x10030, 0x0002C41B,
		0x10030, 0x000301EF,
		0x10030, 0x000305AF,
		0x10030, 0x000309A9,
		0x10030, 0x00030DA3,
		0x10030, 0x0003119D,
		0x10030, 0x00031563,
		0x10030, 0x0003195D,
		0x10030, 0x00031D25,
		0x10030, 0x0003211F,
		0x10030, 0x000324E7,
		0x10030, 0x000328E1,
		0x10030, 0x00032CA7,
		0x10030, 0x000330A1,
		0x10030, 0x00033467,
		0x10030, 0x00033861,
		0x10030, 0x00033C27,
		0x10030, 0x00034021,
		0x10030, 0x0003441B,
		0x10030, 0x000601EB,
		0x10030, 0x000605AB,
		0x10030, 0x000609A5,
		0x10030, 0x00060D9F,
		0x10030, 0x00061199,
		0x10030, 0x00061593,
		0x10030, 0x00061959,
		0x10030, 0x00061D53,
		0x10030, 0x0006211B,
		0x10030, 0x00062515,
		0x10030, 0x000628DD,
		0x10030, 0x00062CD7,
		0x10030, 0x0006309D,
		0x10030, 0x00063497,
		0x10030, 0x0006385D,
		0x10030, 0x00063C57,
		0x10030, 0x0006401D,
		0x10030, 0x00064417,
		0x10030, 0x000681E7,
		0x10030, 0x000685A7,
		0x10030, 0x000689A1,
		0x10030, 0x00068D9B,
		0x10030, 0x00069195,
		0x10030, 0x0006955F,
		0x10030, 0x00069959,
		0x10030, 0x00069D21,
		0x10030, 0x0006A11B,
		0x10030, 0x0006A4E3,
		0x10030, 0x0006A8DD,
		0x10030, 0x0006ACA5,
		0x10030, 0x0006B09F,
		0x10030, 0x0006B465,
		0x10030, 0x0006B85F,
		0x10030, 0x0006BC25,
		0x10030, 0x0006C01F,
		0x10030, 0x0006C419,
		0x10030, 0x000701E7,
		0x10030, 0x000705A7,
		0x10030, 0x000709A1,
		0x10030, 0x00070D9B,
		0x10030, 0x00071195,
		0x10030, 0x0007155B,
		0x10030, 0x00071955,
		0x10030, 0x00071D1D,
		0x10030, 0x00072117,
		0x10030, 0x000724DF,
		0x10030, 0x000728D9,
		0x10030, 0x00072CA1,
		0x10030, 0x0007309B,
		0x10030, 0x00073461,
		0x10030, 0x0007385B,
		0x10030, 0x00073C21,
		0x10030, 0x0007401B,
		0x10030, 0x0007441B,
		0x10030, 0x000781E9,
		0x10030, 0x000785A9,
		0x10030, 0x000789A3,
		0x10030, 0x00078D9D,
		0x10030, 0x00079197,
		0x10030, 0x00079591,
		0x10030, 0x00079957,
		0x10030, 0x00079D51,
		0x10030, 0x0007A119,
		0x10030, 0x0007A513,
		0x10030, 0x0007A8D9,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B099,
		0x10030, 0x0007B493,
		0x10030, 0x0007B859,
		0x10030, 0x0007BC53,
		0x10030, 0x0007C019,
		0x10030, 0x0007C413,
	0xB0000000,	0x00000000,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
		0x10030, 0x000000FC,
		0x10030, 0x000004F9,
		0x10030, 0x000008F6,
		0x10030, 0x00000CF3,
		0x10030, 0x000010F0,
		0x10030, 0x000014ED,
		0x10030, 0x000018AC,
		0x10030, 0x00001CA9,
		0x10030, 0x00002069,
		0x10030, 0x00002466,
		0x10030, 0x00002829,
		0x10030, 0x00002C26,
		0x10030, 0x00003023,
		0x10030, 0x00003420,
		0x10030, 0x0000381D,
		0x10030, 0x00003C1A,
		0x10030, 0x00004017,
		0x100EE, 0x00000000,
		0x100EE, 0x00002000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x0002240D,
		0x10030, 0x0002280A,
		0x10030, 0x00022C07,
		0x10030, 0x00023004,
		0x10030, 0x00023401,
		0x10030, 0x00023800,
		0x10030, 0x00023C00,
		0x10030, 0x00024000,
		0x10030, 0x000280E7,
		0x10030, 0x000284E4,
		0x10030, 0x000288E1,
		0x10030, 0x00028CDE,
		0x10030, 0x000290DB,
		0x10030, 0x000294D8,
		0x10030, 0x000298D5,
		0x10030, 0x00029CD2,
		0x10030, 0x0002A0CF,
		0x10030, 0x0002A40C,
		0x10030, 0x0002A809,
		0x10030, 0x0002AC06,
		0x10030, 0x0002B003,
		0x10030, 0x0002B400,
		0x10030, 0x0002B800,
		0x10030, 0x0002BC00,
		0x10030, 0x0002C000,
		0x10030, 0x000300E7,
		0x10030, 0x000304E4,
		0x10030, 0x000308E1,
		0x10030, 0x00030CDE,
		0x10030, 0x000310DB,
		0x10030, 0x000314D8,
		0x10030, 0x000318D5,
		0x10030, 0x00031CD2,
		0x10030, 0x000320CF,
		0x10030, 0x000324CC,
		0x10030, 0x00032809,
		0x10030, 0x00032C06,
		0x10030, 0x00033003,
		0x10030, 0x00033400,
		0x10030, 0x00033800,
		0x10030, 0x00033C00,
		0x10030, 0x00034000,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x0002240D,
		0x10030, 0x0002280A,
		0x10030, 0x00022C07,
		0x10030, 0x00023004,
		0x10030, 0x00023401,
		0x10030, 0x00023800,
		0x10030, 0x00023C00,
		0x10030, 0x00024000,
		0x10030, 0x000280E7,
		0x10030, 0x000284E4,
		0x10030, 0x000288E1,
		0x10030, 0x00028CDE,
		0x10030, 0x000290DB,
		0x10030, 0x000294D8,
		0x10030, 0x000298D5,
		0x10030, 0x00029CD2,
		0x10030, 0x0002A0CF,
		0x10030, 0x0002A40C,
		0x10030, 0x0002A809,
		0x10030, 0x0002AC06,
		0x10030, 0x0002B003,
		0x10030, 0x0002B400,
		0x10030, 0x0002B800,
		0x10030, 0x0002BC00,
		0x10030, 0x0002C000,
		0x10030, 0x000300E7,
		0x10030, 0x000304E4,
		0x10030, 0x000308E1,
		0x10030, 0x00030CDE,
		0x10030, 0x000310DB,
		0x10030, 0x000314D8,
		0x10030, 0x000318D5,
		0x10030, 0x00031CD2,
		0x10030, 0x000320CF,
		0x10030, 0x000324CC,
		0x10030, 0x00032809,
		0x10030, 0x00032C06,
		0x10030, 0x00033003,
		0x10030, 0x00033400,
		0x10030, 0x00033800,
		0x10030, 0x00033C00,
		0x10030, 0x00034000,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x000200E8,
		0x10030, 0x000204E5,
		0x10030, 0x000208E2,
		0x10030, 0x00020CDF,
		0x10030, 0x000210DC,
		0x10030, 0x000214D9,
		0x10030, 0x000218D6,
		0x10030, 0x00021CD3,
		0x10030, 0x000220D0,
		0x10030, 0x000224CD,
		0x10030, 0x000228CD,
		0x10030, 0x00022CCD,
		0x10030, 0x000230CD,
		0x10030, 0x000234CD,
		0x10030, 0x000238CD,
		0x10030, 0x00023CCD,
		0x10030, 0x000240CD,
		0x10030, 0x000280E8,
		0x10030, 0x000284E5,
		0x10030, 0x000288E2,
		0x10030, 0x00028CDF,
		0x10030, 0x000290DC,
		0x10030, 0x000294D9,
		0x10030, 0x000298D6,
		0x10030, 0x00029CD3,
		0x10030, 0x0002A0D0,
		0x10030, 0x0002A4CD,
		0x10030, 0x0002A8CD,
		0x10030, 0x0002ACCD,
		0x10030, 0x0002B0CD,
		0x10030, 0x0002B4CD,
		0x10030, 0x0002B8CD,
		0x10030, 0x0002BCCD,
		0x10030, 0x0002C0CD,
		0x10030, 0x000300E8,
		0x10030, 0x000304E5,
		0x10030, 0x000308E2,
		0x10030, 0x00030CDF,
		0x10030, 0x000310DC,
		0x10030, 0x000314D9,
		0x10030, 0x000318D6,
		0x10030, 0x00031CD3,
		0x10030, 0x000320D0,
		0x10030, 0x000324CD,
		0x10030, 0x000328CD,
		0x10030, 0x00032CCD,
		0x10030, 0x000330CD,
		0x10030, 0x000334CD,
		0x10030, 0x000338CD,
		0x10030, 0x00033CCD,
		0x10030, 0x000340CD,
	0xA0000000,	0x00000000,
		0x10030, 0x000200FA,
		0x10030, 0x000204F7,
		0x10030, 0x000208F4,
		0x10030, 0x00020CF1,
		0x10030, 0x000210EE,
		0x10030, 0x000214EB,
		0x10030, 0x000218E8,
		0x10030, 0x00021CE5,
		0x10030, 0x000220E2,
		0x10030, 0x000224DF,
		0x10030, 0x000228DC,
		0x10030, 0x00022CD9,
		0x10030, 0x000230D6,
		0x10030, 0x000234D3,
		0x10030, 0x000238D0,
		0x10030, 0x00023C0D,
		0x10030, 0x0002400A,
		0x10030, 0x000280F9,
		0x10030, 0x000284F6,
		0x10030, 0x000288F3,
		0x10030, 0x00028CF0,
		0x10030, 0x000290ED,
		0x10030, 0x000294EA,
		0x10030, 0x000298E7,
		0x10030, 0x00029CE4,
		0x10030, 0x0002A0E1,
		0x10030, 0x0002A4DE,
		0x10030, 0x0002A8DB,
		0x10030, 0x0002ACD8,
		0x10030, 0x0002B0D5,
		0x10030, 0x0002B4D2,
		0x10030, 0x0002B8CF,
		0x10030, 0x0002BC0C,
		0x10030, 0x0002C009,
		0x10030, 0x000300F6,
		0x10030, 0x000304F3,
		0x10030, 0x000308F0,
		0x10030, 0x00030CED,
		0x10030, 0x000310EA,
		0x10030, 0x000314E7,
		0x10030, 0x000318E4,
		0x10030, 0x00031CE1,
		0x10030, 0x000320DE,
		0x10030, 0x000324DB,
		0x10030, 0x000328D8,
		0x10030, 0x00032CD5,
		0x10030, 0x000330D2,
		0x10030, 0x000334CF,
		0x10030, 0x000338CC,
		0x10030, 0x00033C09,
		0x10030, 0x00034006,
	0xB0000000,	0x00000000,
		0x10030, 0x000600F6,
		0x10030, 0x000604F3,
		0x10030, 0x000608F0,
		0x10030, 0x00060CED,
		0x10030, 0x000610EA,
		0x10030, 0x000614E7,
		0x10030, 0x000618E4,
		0x10030, 0x00061CE1,
		0x10030, 0x000620DE,
		0x10030, 0x000624DB,
		0x10030, 0x000628D8,
		0x10030, 0x00062CD5,
		0x10030, 0x000630D2,
		0x10030, 0x000634CF,
		0x10030, 0x000638CC,
		0x10030, 0x00063C09,
		0x10030, 0x00064006,
		0x10030, 0x000680F5,
		0x10030, 0x000684F2,
		0x10030, 0x000688EF,
		0x10030, 0x00068CEC,
		0x10030, 0x000690E9,
		0x10030, 0x000694E6,
		0x10030, 0x000698E3,
		0x10030, 0x00069CE0,
		0x10030, 0x0006A0DD,
		0x10030, 0x0006A4DA,
		0x10030, 0x0006A8D7,
		0x10030, 0x0006ACD4,
		0x10030, 0x0006B0D1,
		0x10030, 0x0006B4CE,
		0x10030, 0x0006B8CB,
		0x10030, 0x0006BC08,
		0x10030, 0x0006C005,
		0x10030, 0x000700F5,
		0x10030, 0x000704F2,
		0x10030, 0x000708EF,
		0x10030, 0x00070CEC,
		0x10030, 0x000710E9,
		0x10030, 0x000714E6,
		0x10030, 0x000718E3,
		0x10030, 0x00071CE0,
		0x10030, 0x000720DD,
		0x10030, 0x000724DA,
		0x10030, 0x000728D7,
		0x10030, 0x00072CD4,
		0x10030, 0x000730D1,
		0x10030, 0x000734CE,
		0x10030, 0x000738CB,
		0x10030, 0x00073C08,
		0x10030, 0x00074005,
		0x10030, 0x000780F4,
		0x10030, 0x000784F1,
		0x10030, 0x000788EE,
		0x10030, 0x00078CEB,
		0x10030, 0x000790E8,
		0x10030, 0x000794E5,
		0x10030, 0x000798E2,
		0x10030, 0x00079CDF,
		0x10030, 0x0007A0DC,
		0x10030, 0x0007A4D9,
		0x10030, 0x0007A8D6,
		0x10030, 0x0007ACD3,
		0x10030, 0x0007B0D0,
		0x10030, 0x0007B4CD,
		0x10030, 0x0007B8CA,
		0x10030, 0x0007BC07,
		0x10030, 0x0007C004,
		0x100EE, 0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000008,
		0x03F, 0x00000004,
		0x033, 0x00000009,
		0x03F, 0x00000003,
		0x033, 0x0000000A,
		0x03F, 0x00000003,
		0x033, 0x0000000B,
		0x03F, 0x00000002,
		0x033, 0x0000000C,
		0x03F, 0x00000002,
		0x033, 0x0000000D,
		0x03F, 0x00000002,
		0x033, 0x0000000E,
		0x03F, 0x00000002,
		0x033, 0x0000000F,
		0x03F, 0x00000002,
		0x0EF, 0x00000000,
		0x0EB, 0x00040000,
		0x030, 0x000109B7,
		0x0EB, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00050002,
		0x033, 0x00000021,
		0x03F, 0x00060032,
		0x033, 0x00000022,
		0x03F, 0x00050042,
		0x033, 0x00000023,
		0x03F, 0x00040042,
		0x033, 0x00000024,
		0x03F, 0x00008001,
		0x033, 0x00000025,
		0x03F, 0x00008002,
		0x033, 0x00000026,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03F, 0x00050002,
		0x033, 0x00000029,
		0x03F, 0x00060032,
		0x033, 0x0000002A,
		0x03F, 0x00050042,
		0x033, 0x0000002B,
		0x03F, 0x00040042,
		0x033, 0x0000002C,
		0x03F, 0x00008001,
		0x033, 0x0000002D,
		0x03F, 0x00008002,
		0x033, 0x0000002E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000002F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000030,
		0x03F, 0x00050002,
		0x033, 0x00000031,
		0x03F, 0x00060032,
		0x033, 0x00000032,
		0x03F, 0x00050042,
		0x033, 0x00000033,
		0x03F, 0x00040042,
		0x033, 0x00000034,
		0x03F, 0x00008001,
		0x033, 0x00000035,
		0x03F, 0x00008002,
		0x033, 0x00000036,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000037,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00050002,
		0x033, 0x00000061,
		0x03F, 0x00060032,
		0x033, 0x00000062,
		0x03F, 0x00050042,
		0x033, 0x00000063,
		0x03F, 0x00040042,
		0x033, 0x00000064,
		0x03F, 0x00008001,
		0x033, 0x00000065,
		0x03F, 0x00008002,
		0x033, 0x00000066,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000067,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000068,
		0x03F, 0x00050002,
		0x033, 0x00000069,
		0x03F, 0x00060032,
		0x033, 0x0000006A,
		0x03F, 0x00050042,
		0x033, 0x0000006B,
		0x03F, 0x00040042,
		0x033, 0x0000006C,
		0x03F, 0x00008001,
		0x033, 0x0000006D,
		0x03F, 0x00008002,
		0x033, 0x0000006E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000006F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000070,
		0x03F, 0x00050002,
		0x033, 0x00000071,
		0x03F, 0x00060032,
		0x033, 0x00000072,
		0x03F, 0x00050042,
		0x033, 0x00000073,
		0x03F, 0x00040042,
		0x033, 0x00000074,
		0x03F, 0x00008001,
		0x033, 0x00000075,
		0x03F, 0x00008002,
		0x033, 0x00000076,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000077,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000078,
		0x03F, 0x00050002,
		0x033, 0x00000079,
		0x03F, 0x00060032,
		0x033, 0x0000007A,
		0x03F, 0x00050042,
		0x033, 0x0000007B,
		0x03F, 0x00040042,
		0x033, 0x0000007C,
		0x03F, 0x00008001,
		0x033, 0x0000007D,
		0x03F, 0x00008002,
		0x033, 0x0000007E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000007F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00050002,
		0x033, 0x000000A1,
		0x03F, 0x00060032,
		0x033, 0x000000A2,
		0x03F, 0x00050042,
		0x033, 0x000000A3,
		0x03F, 0x00040042,
		0x033, 0x000000A4,
		0x03F, 0x00008001,
		0x033, 0x000000A5,
		0x03F, 0x00008002,
		0x033, 0x000000A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000A8,
		0x03F, 0x00050002,
		0x033, 0x000000A9,
		0x03F, 0x00060032,
		0x033, 0x000000AA,
		0x03F, 0x00050042,
		0x033, 0x000000AB,
		0x03F, 0x00040042,
		0x033, 0x000000AC,
		0x03F, 0x00008001,
		0x033, 0x000000AD,
		0x03F, 0x00008002,
		0x033, 0x000000AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000B0,
		0x03F, 0x00050002,
		0x033, 0x000000B1,
		0x03F, 0x00060032,
		0x033, 0x000000B2,
		0x03F, 0x00050042,
		0x033, 0x000000B3,
		0x03F, 0x00040042,
		0x033, 0x000000B4,
		0x03F, 0x00008001,
		0x033, 0x000000B5,
		0x03F, 0x00008002,
		0x033, 0x000000B6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000B7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000E0,
		0x03F, 0x00050002,
		0x033, 0x000000E1,
		0x03F, 0x00060032,
		0x033, 0x000000E2,
		0x03F, 0x00050042,
		0x033, 0x000000E3,
		0x03F, 0x00040042,
		0x033, 0x000000E4,
		0x03F, 0x00008001,
		0x033, 0x000000E5,
		0x03F, 0x00008002,
		0x033, 0x000000E6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000E7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000E8,
		0x03F, 0x00050002,
		0x033, 0x000000E9,
		0x03F, 0x00060032,
		0x033, 0x000000EA,
		0x03F, 0x00050042,
		0x033, 0x000000EB,
		0x03F, 0x00040042,
		0x033, 0x000000EC,
		0x03F, 0x00008001,
		0x033, 0x000000ED,
		0x03F, 0x00008002,
		0x033, 0x000000EE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000EF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000F0,
		0x03F, 0x00050002,
		0x033, 0x000000F1,
		0x03F, 0x00060032,
		0x033, 0x000000F2,
		0x03F, 0x00050042,
		0x033, 0x000000F3,
		0x03F, 0x00040042,
		0x033, 0x000000F4,
		0x03F, 0x00008001,
		0x033, 0x000000F5,
		0x03F, 0x00008002,
		0x033, 0x000000F6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000F7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000F8,
		0x03F, 0x00050002,
		0x033, 0x000000F9,
		0x03F, 0x00060032,
		0x033, 0x000000FA,
		0x03F, 0x00050042,
		0x033, 0x000000FB,
		0x03F, 0x00040042,
		0x033, 0x000000FC,
		0x03F, 0x00008001,
		0x033, 0x000000FD,
		0x03F, 0x00008002,
		0x033, 0x000000FE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000000FF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000120,
		0x03F, 0x00050002,
		0x033, 0x00000121,
		0x03F, 0x00060032,
		0x033, 0x00000122,
		0x03F, 0x00050042,
		0x033, 0x00000123,
		0x03F, 0x00040042,
		0x033, 0x00000124,
		0x03F, 0x00008001,
		0x033, 0x00000125,
		0x03F, 0x00008002,
		0x033, 0x00000126,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000127,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000128,
		0x03F, 0x00050002,
		0x033, 0x00000129,
		0x03F, 0x00060032,
		0x033, 0x0000012A,
		0x03F, 0x00050042,
		0x033, 0x0000012B,
		0x03F, 0x00040042,
		0x033, 0x0000012C,
		0x03F, 0x00008001,
		0x033, 0x0000012D,
		0x03F, 0x00008002,
		0x033, 0x0000012E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000012F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000130,
		0x03F, 0x00050002,
		0x033, 0x00000131,
		0x03F, 0x00060032,
		0x033, 0x00000132,
		0x03F, 0x00050042,
		0x033, 0x00000133,
		0x03F, 0x00040042,
		0x033, 0x00000134,
		0x03F, 0x00008001,
		0x033, 0x00000135,
		0x03F, 0x00008002,
		0x033, 0x00000136,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000137,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000160,
		0x03F, 0x00050002,
		0x033, 0x00000161,
		0x03F, 0x00060032,
		0x033, 0x00000162,
		0x03F, 0x00050042,
		0x033, 0x00000163,
		0x03F, 0x00040042,
		0x033, 0x00000164,
		0x03F, 0x00008001,
		0x033, 0x00000165,
		0x03F, 0x00008002,
		0x033, 0x00000166,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000167,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000168,
		0x03F, 0x00050002,
		0x033, 0x00000169,
		0x03F, 0x00060032,
		0x033, 0x0000016A,
		0x03F, 0x00050042,
		0x033, 0x0000016B,
		0x03F, 0x00040042,
		0x033, 0x0000016C,
		0x03F, 0x00008001,
		0x033, 0x0000016D,
		0x03F, 0x00008002,
		0x033, 0x0000016E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000016F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000170,
		0x03F, 0x00050002,
		0x033, 0x00000171,
		0x03F, 0x00060032,
		0x033, 0x00000172,
		0x03F, 0x00050042,
		0x033, 0x00000173,
		0x03F, 0x00040042,
		0x033, 0x00000174,
		0x03F, 0x00008001,
		0x033, 0x00000175,
		0x03F, 0x00008002,
		0x033, 0x00000176,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000177,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x00000178,
		0x03F, 0x00050002,
		0x033, 0x00000179,
		0x03F, 0x00060032,
		0x033, 0x0000017A,
		0x03F, 0x00050042,
		0x033, 0x0000017B,
		0x03F, 0x00040042,
		0x033, 0x0000017C,
		0x03F, 0x00008001,
		0x033, 0x0000017D,
		0x03F, 0x00008002,
		0x033, 0x0000017E,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x0000017F,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001A0,
		0x03F, 0x00050002,
		0x033, 0x000001A1,
		0x03F, 0x00060032,
		0x033, 0x000001A2,
		0x03F, 0x00050042,
		0x033, 0x000001A3,
		0x03F, 0x00040042,
		0x033, 0x000001A4,
		0x03F, 0x00008001,
		0x033, 0x000001A5,
		0x03F, 0x00008002,
		0x033, 0x000001A6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001A7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001A8,
		0x03F, 0x00050002,
		0x033, 0x000001A9,
		0x03F, 0x00060032,
		0x033, 0x000001AA,
		0x03F, 0x00050042,
		0x033, 0x000001AB,
		0x03F, 0x00040042,
		0x033, 0x000001AC,
		0x03F, 0x00008001,
		0x033, 0x000001AD,
		0x03F, 0x00008002,
		0x033, 0x000001AE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001AF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001B0,
		0x03F, 0x00050002,
		0x033, 0x000001B1,
		0x03F, 0x00060032,
		0x033, 0x000001B2,
		0x03F, 0x00050042,
		0x033, 0x000001B3,
		0x03F, 0x00040042,
		0x033, 0x000001B4,
		0x03F, 0x00008001,
		0x033, 0x000001B5,
		0x03F, 0x00008002,
		0x033, 0x000001B6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001B7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001E0,
		0x03F, 0x00050002,
		0x033, 0x000001E1,
		0x03F, 0x00060032,
		0x033, 0x000001E2,
		0x03F, 0x00050042,
		0x033, 0x000001E3,
		0x03F, 0x00040042,
		0x033, 0x000001E4,
		0x03F, 0x00008001,
		0x033, 0x000001E5,
		0x03F, 0x00008002,
		0x033, 0x000001E6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001E7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001E8,
		0x03F, 0x00050002,
		0x033, 0x000001E9,
		0x03F, 0x00060032,
		0x033, 0x000001EA,
		0x03F, 0x00050042,
		0x033, 0x000001EB,
		0x03F, 0x00040042,
		0x033, 0x000001EC,
		0x03F, 0x00008001,
		0x033, 0x000001ED,
		0x03F, 0x00008002,
		0x033, 0x000001EE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001EF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001F0,
		0x03F, 0x00050002,
		0x033, 0x000001F1,
		0x03F, 0x00060032,
		0x033, 0x000001F2,
		0x03F, 0x00050042,
		0x033, 0x000001F3,
		0x03F, 0x00040042,
		0x033, 0x000001F4,
		0x03F, 0x00008001,
		0x033, 0x000001F5,
		0x03F, 0x00008002,
		0x033, 0x000001F6,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001F7,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001F8,
		0x03F, 0x00050002,
		0x033, 0x000001F9,
		0x03F, 0x00060032,
		0x033, 0x000001FA,
		0x03F, 0x00050042,
		0x033, 0x000001FB,
		0x03F, 0x00040042,
		0x033, 0x000001FC,
		0x03F, 0x00008001,
		0x033, 0x000001FD,
		0x03F, 0x00008002,
		0x033, 0x000001FE,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x033, 0x000001FF,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008002,
	0xA0000000,	0x00000000,
		0x03F, 0x00000003,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x005, 0x00000001,
		0x10005, 0x00000001,
		0x100EE, 0x00000400,
		0x10030, 0x00000000,
		0x10030, 0x00001000,
		0x10030, 0x00002000,
		0x10030, 0x00003000,
		0x10030, 0x00004000,
		0x10030, 0x00005000,
		0x10030, 0x00006003,
		0x10030, 0x00007003,
		0x10030, 0x00008000,
		0x10030, 0x00009000,
		0x10030, 0x0000A000,
		0x10030, 0x0000B000,
		0x10030, 0x0000C000,
		0x10030, 0x0000D000,
		0x10030, 0x0000E003,
		0x10030, 0x0000F003,
		0x10030, 0x00010000,
		0x10030, 0x00011000,
		0x10030, 0x00012000,
		0x10030, 0x00013000,
		0x10030, 0x00014000,
		0x10030, 0x00015000,
		0x10030, 0x00016003,
		0x10030, 0x00017003,
		0x10030, 0x00018000,
		0x10030, 0x00019000,
		0x10030, 0x0001A000,
		0x10030, 0x0001B000,
		0x10030, 0x0001C000,
		0x10030, 0x0001D000,
		0x10030, 0x0001E003,
		0x10030, 0x0001F003,
		0x10030, 0x00020000,
		0x10030, 0x00021000,
		0x10030, 0x00022000,
		0x10030, 0x00023000,
		0x10030, 0x00024000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00025003,
	0xA0000000,	0x00000000,
		0x10030, 0x00025000,
	0xB0000000,	0x00000000,
		0x10030, 0x00026003,
		0x10030, 0x00027003,
		0x10030, 0x00028000,
		0x10030, 0x00029000,
		0x10030, 0x0002A000,
		0x10030, 0x0002B000,
		0x10030, 0x0002C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0002D003,
	0xA0000000,	0x00000000,
		0x10030, 0x0002D000,
	0xB0000000,	0x00000000,
		0x10030, 0x0002E003,
		0x10030, 0x0002F003,
		0x10030, 0x00030000,
		0x10030, 0x00031000,
		0x10030, 0x00032000,
		0x10030, 0x00033000,
		0x10030, 0x00034000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00035003,
	0xA0000000,	0x00000000,
		0x10030, 0x00035000,
	0xB0000000,	0x00000000,
		0x10030, 0x00036003,
		0x10030, 0x00037003,
		0x10030, 0x00038000,
		0x10030, 0x00039000,
		0x10030, 0x0003A000,
		0x10030, 0x0003B000,
		0x10030, 0x0003C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0003D003,
	0xA0000000,	0x00000000,
		0x10030, 0x0003D000,
	0xB0000000,	0x00000000,
		0x10030, 0x0003E003,
		0x10030, 0x0003F003,
		0x10030, 0x00060000,
		0x10030, 0x00061000,
		0x10030, 0x00062000,
		0x10030, 0x00063000,
		0x10030, 0x00064000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065000,
		0x10030, 0x00066000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065000,
		0x10030, 0x00066000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00065003,
		0x10030, 0x00066003,
	0xA0000000,	0x00000000,
		0x10030, 0x00065000,
		0x10030, 0x00066000,
	0xB0000000,	0x00000000,
		0x10030, 0x00067003,
		0x10030, 0x00068000,
		0x10030, 0x00069000,
		0x10030, 0x0006A000,
		0x10030, 0x0006B000,
		0x10030, 0x0006C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D000,
		0x10030, 0x0006E000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D000,
		0x10030, 0x0006E000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0006D003,
		0x10030, 0x0006E003,
	0xA0000000,	0x00000000,
		0x10030, 0x0006D000,
		0x10030, 0x0006E000,
	0xB0000000,	0x00000000,
		0x10030, 0x0006F003,
		0x10030, 0x00070000,
		0x10030, 0x00071000,
		0x10030, 0x00072000,
		0x10030, 0x00073000,
		0x10030, 0x00074000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075000,
		0x10030, 0x00076000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075000,
		0x10030, 0x00076000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x00075003,
		0x10030, 0x00076003,
	0xA0000000,	0x00000000,
		0x10030, 0x00075000,
		0x10030, 0x00076000,
	0xB0000000,	0x00000000,
		0x10030, 0x00077003,
		0x10030, 0x00078000,
		0x10030, 0x00079000,
		0x10030, 0x0007A000,
		0x10030, 0x0007B000,
		0x10030, 0x0007C000,
	0x80010000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D000,
		0x10030, 0x0007E000,
	0x90020000,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D000,
		0x10030, 0x0007E000,
	0x90010001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90020001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90030001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90040001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90050001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90070001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90150001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90160001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90320001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90330001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90340001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90350001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90360001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x903f0001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0x90400001,	0x00000000,	0x40000000,	0x00000000,
		0x10030, 0x0007D003,
		0x10030, 0x0007E003,
	0xA0000000,	0x00000000,
		0x10030, 0x0007D000,
		0x10030, 0x0007E000,
	0xB0000000,	0x00000000,
		0x10030, 0x0007F003,
		0x0ED, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000000A,
		0x033, 0x00000002,
		0x03F, 0x0000000A,
		0x033, 0x00000003,
		0x03F, 0x0000000A,
		0x033, 0x00000005,
		0x03F, 0x0000000A,
		0x033, 0x00000006,
		0x03F, 0x0000000A,
		0x033, 0x00000007,
		0x03F, 0x0000000A,
		0x0ED, 0x00000000,
		0x100EE, 0x00000000,
		0x0FE, 0x00000067,

};


/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8852c_txpwr_lmt[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 58, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 76, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 70, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 72, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 18, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 18, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 44, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 60, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 28, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 28, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 26, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 26, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 26, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 46, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 48, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 40, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 14, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 14, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 14, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 12, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 12, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 38, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 16, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 1, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 1, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 2, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 2, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 2, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 5, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 7, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 8, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 9, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 9, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 10, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 10, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 10, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 11, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 12, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 12, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 12, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 26, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 13, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 13, 16, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 13, 16, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 13, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 62, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 3, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 4, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 7, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 8, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 8, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 9, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 9, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 10, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 10, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 10, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 11, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 11, 46, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 11, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CNOLD, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MEXICO, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UKRAINE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CHILE, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_QATAR, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_THAILAND, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 3, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 3, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 3, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 4, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 4, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 4, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 5, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 5, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 5, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CNOLD, 6, 34, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MEXICO, 6, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UKRAINE, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CHILE, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_QATAR, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_THAILAND, 6, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 36, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_