/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#ifndef _RTW_FLASH_EXPORT_H_
#define _RTW_FLASH_EXPORT_H_

#include <../phl/hal_g6/hal_general_def.h>

enum rtw_flash_info {
	/* AP customize configs*/
	FLASH_INFO_START = (EFUSE_INFO_BTCOEX_MAX + 1),
	FLASH_INFO_COSTUM_PARA_PATH = FLASH_INFO_START,

	/* RF TSSI SLOPE K, GAIN DIFF */
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_A_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_A_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_A_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_B_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_B_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_B_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_C_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_1,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_2,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_3,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_4,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_5,
	FLASH_INFO_RF_2G_CCK_TSSI_GAIN_DIFF_D_6,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_1,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_2,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_3,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_4,
	FLASH_INFO_RF_2G_TSSI_GAIN_DIFF_D_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_1,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_2,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_3,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_4,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_5,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_6,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_7,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_8,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_9,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_10,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_11,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_12,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_13,
	FLASH_INFO_RF_5G_TSSI_GAIN_DIFF_D_14,

	/* RF TSSI SLOPE K, CW DIFF */
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_A_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_A_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_A_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_B_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_B_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_B_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_C_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_C_14,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_1,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_2,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_3,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_4,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_5,
	FLASH_INFO_RF_2G_CCK_TSSI_CW_DIFF_D_6,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_1,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_2,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_3,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_4,
	FLASH_INFO_RF_2G_TSSI_CW_DIFF_D_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_1,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_2,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_3,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_4,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_5,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_6,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_7,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_8,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_9,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_10,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_11,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_12,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_13,
	FLASH_INFO_RF_5G_TSSI_CW_DIFF_D_14,

	/* RF 20M 80M 160M, TSSI DIFF */
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_A_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_A_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_A_14,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_B_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_B_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_B_14,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_C_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_C_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_C_14,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_1,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_2,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_3,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_4,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_5,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_6,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_7,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_8,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_9,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_10,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_11,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_12,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_13,
	FLASH_INFO_RF_5G_BW20M_BW40M_TSSI_DIFF_D_14,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_1,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_2,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_3,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_4,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_5,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_6,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_7,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_8,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_9,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_10,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_11,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_12,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_13,
	FLASH_INFO_RF_5G_BW80M_BW40M_TSSI_DIFF_D_14,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_1,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_2,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_3,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_4,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_5,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_6,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_7,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_8,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_9,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_10,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_11,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_12,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_13,
	FLASH_INFO_RF_5G_BW160M_BW40M_TSSI_DIFF_D_14,

	/*Error Code*/
	FLASH_INFO_ID_ERROR,
};

struct flash_dict;

/* flash exported API */
u32
rtw_flash_init(struct dvobj_priv *dvobj, void **flash);

u32
rtw_flash_efuse_init(struct dvobj_priv *dvobj);

void rtw_flash_deinit(struct dvobj_priv *dvobj, void *flash);

u32
rtw_flash_get_info(void *flash, enum rtw_efuse_info info_type, void *value,
				   u8 size);

u32
rtw_flash_set_info(void *flash, enum rtw_efuse_info info_type, void *value,
				   u8 size, u32 offset);

void rtw_flash_process(void *flash);

u32
rtw_flash_shadow_load(void *flash, bool is_limit, u8 *map);

u32
rtw_flash_shadow_read(void *flash, u8 byte_count, u16 offset, u32 *value,
					  bool is_limit);

u32
rtw_flash_shadow_write(void *flash, u8 byte_count, u16 offset, u32 value,
					   bool is_limit);

u32
rtw_flash_shadow_update(void *flash, bool is_limit);

u32
rtw_flash_shadow2buf(void *flash, u8 *destbuf, u16 buflen);

u32
rtw_flash_file_map_load(void *flash, char *file_path, u8 is_limit);

u32
rtw_flash_file_mask_load(void *flash, char *file_path, u8 is_limit);

u32
rtw_flash_get_usage(void *flash, u32 *usage);

u32
rtw_flash_get_logical_size(void *flash, u32 *size, bool is_limited);

u32
rtw_flash_get_size(void *flash, u32 *size);

u32
rtw_flash_get_avl(void *flash, u32 *size);

u32
rtw_flash_get_offset_mask(void *flash, u16 offset, u8 *mask);

void deinit_flash_id_table(struct dvobj_priv *dvobj, struct flash_dict *table, u16 len);

enum rtw_flash_info lookup_flash_id(struct flash_dict *table,
                                    u8 *src, u32 *offset, u8 *size);

void rtw_flash_set_offset(void *flash, u32 offset, u32 value);

u8 rtw_flash_get_offset(void *flash, u32 offset);

void rtw_flash_dump(void *flash);

void rtw_flash_set_para_path(void *flash, const char *path);

const char * rtw_flash_get_para_path(void *flash);

void rtw_flash_set_tssi_slp_info(void *flash, enum rtw_flash_info info_type,
                                 u8 *input_data, u8 len);

void rtw_flash_get_tssi_slp_info(struct dvobj_priv *d, void *flash,
                                 enum rtw_flash_info info_type,
                                 void *value, u8 size);

void rtw_flash_set_tssi_diff_info(void *flash, enum rtw_flash_info info_type,
                                 u8 *input_data, u8 len);

void rtw_flash_get_tssi_diff_info(struct dvobj_priv *d, void *flash,
                                 enum rtw_flash_info info_type,
                                 void *value, u8 size);

#endif /* _RTW_flash_EXPORT_H_ */

